package com.zell_mbc.publicartexplorer

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.*
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.items
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalDensity
import androidx.compose.ui.platform.LocalWindowInfo
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.zell_mbc.publicartexplorer.data.ViewModel

@Composable
fun DebugOverlay(viewModel: ViewModel,    content: @Composable () -> Unit) {
    val windowInfo = LocalWindowInfo.current
    val density = LocalDensity.current
    val screenWidth = with(density) { windowInfo.containerSize.width.toDp() }
    val overlayWidth = screenWidth - 120.dp

    Box {
        content()

        // Debug log overlay
        LazyColumn(modifier = Modifier.width(overlayWidth).fillMaxHeight().background(Color(0x80000000)).padding(8.dp).align(Alignment.TopStart), horizontalAlignment = Alignment.Start) {
            items(viewModel.debugList) { line ->
                Text(text = line, color = Color.Yellow, fontSize = 12.sp, fontFamily = FontFamily.Monospace)
            }
        }
    }
}
