import android.annotation.SuppressLint
import android.content.Context
import android.location.Location
import android.location.LocationListener
import android.location.LocationManager

class LocationTracker(private val context: Context) {

    private val locationManager =
        context.getSystemService(Context.LOCATION_SERVICE) as LocationManager

    private var listener: LocationListener? = null

    @SuppressLint("MissingPermission")
    fun startTracking(onLocationChanged: (Location) -> Unit) {
        if (listener != null) return

        listener = object : LocationListener {
            override fun onLocationChanged(location: Location) {
                onLocationChanged(location)
            }
        }

        val provider = if ("fused" in locationManager.allProviders) "fused"
        else LocationManager.GPS_PROVIDER

        locationManager.requestLocationUpdates(provider, 2000L, 0f, listener!!)
    }

    fun stopTracking() {
        listener?.let { locationManager.removeUpdates(it) }
        listener = null
    }
}
