import android.annotation.SuppressLint
import android.content.Context
import android.location.Location
import android.os.Looper
import com.google.android.gms.location.*

class LocationTracker(context: Context) {

    private val fused: FusedLocationProviderClient =
        LocationServices.getFusedLocationProviderClient(context)

        private var locationCallback: LocationCallback? = null

            @SuppressLint("MissingPermission")
            fun startTracking(onLocationChanged: (Location) -> Unit) {
                if (locationCallback != null) return
                val request = LocationRequest.Builder(Priority.PRIORITY_HIGH_ACCURACY,2000L).build()

                locationCallback = object : LocationCallback() {
                    override fun onLocationResult(result: LocationResult) {
                        result.lastLocation?.let(onLocationChanged)
                    }
                }
                fused.requestLocationUpdates(request, locationCallback!!, Looper.getMainLooper())
            }

            fun stopTracking() {
                locationCallback?.let { fused.removeLocationUpdates(it) }
                locationCallback = null
            }
}
