package com.zell_mbc.publicartexplorer.detailview

import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.zell_mbc.publicartexplorer.R
import com.zell_mbc.publicartexplorer.Relation
import com.zell_mbc.publicartexplorer.createClickableUrl
import com.zell_mbc.publicartexplorer.data.ViewModel
import com.zell_mbc.publicartexplorer.helpers.createWikipediaUrl
import kotlin.collections.iterator
import kotlin.text.isNotEmpty

// If id is part of a relation, show the relation details
@Composable
fun ShowRelationsData(viewModel: ViewModel,id: String) {
    val context = LocalContext.current

    val relation = lookUpRelation(viewModel,id)
    if (relation == null) return

    HorizontalDivider(thickness = 1.dp, color = MaterialTheme.colorScheme.primary)
    Text("")
    Text(stringResource(R.string.relation) + ":", color = MaterialTheme.colorScheme.onSurface)

    var s = relation.tags["name"] ?: ""
    if (s.isNotEmpty()) Text(context.getString(R.string.tag_name) + ": $s")

    s = createWikipediaUrl(relation.tags["wikipedia"] ?: "")
    if (s.isNotEmpty()) {
        val linkText = stringResource(R.string.relation) + " Wikipedia"
        Text(createClickableUrl(s, linkText), color = MaterialTheme.colorScheme.onSurface)
        Text("")
    }

    // Iterate through tags and see if there's a url to display
    //Text(createClickableUrl(tmp))
}

@Composable
fun ShowRelationsRawData(viewModel: ViewModel, id: String) {
    val relation = lookUpRelation(viewModel, id)
    if (relation == null) return

    HorizontalDivider(thickness = 1.dp, color = MaterialTheme.colorScheme.primary)
    Text("")
    Text(stringResource(R.string.relation) + ":", color = MaterialTheme.colorScheme.onSurface)
    for (tag in relation.tags) {
        Text(tag.toString(), style = MaterialTheme.typography.bodyMedium, color = MaterialTheme.colorScheme.onSurface)
    }
    Text("")
}


fun lookUpRelation(viewModel: ViewModel, id: String): Relation? {
    var hit: Relation? = null
    for (relation in viewModel.relations)
        for (member in relation.members)
            if (member == id) hit = relation
    return hit
}
