package com.zell_mbc.publicartexplorer.billing

import android.app.Activity
import android.content.Context

// Need this so I do not need to pull in the Billing ProductInfo for the FOSS flavour
data class UpgradeProductInfo(
    val title: String,
    val description: String,
    val price: String
)

interface BillingManager {
    fun isSubscriptionActive(context: Context)
    fun launchPurchaseFlow(activity: Activity)
    fun queryUpgradeProduct(context: Context, onResult: (UpgradeProductInfo?) -> Unit)
    var showThankYouDialog: ((Boolean) -> Unit)?
    var setSubscriptionStatus: ((Boolean) -> Unit)?
    var showBillingUnavailableDialog: ((Boolean) -> Unit)?
    var setExpiryTimestamp: ((Long) -> Unit)?
}