package com.zell_mbc.publicartexplorer

import android.content.Context
import androidx.compose.runtime.mutableStateListOf
import coil3.ImageLoader
import coil3.network.okhttp.OkHttpNetworkFetcherFactory
import okhttp3.OkHttpClient
import okhttp3.internal.platform.PlatformRegistry.applicationContext
import java.util.concurrent.TimeUnit
import androidx.core.content.edit
import com.zell_mbc.publicartexplorer.screens.WikiUser
import okhttp3.MediaType.Companion.toMediaType
import okhttp3.Protocol
import okhttp3.Response
import okhttp3.ResponseBody
import java.io.IOException
import java.net.SocketTimeoutException

// Get's filled from assets folder upon app start
var mapboxStyles = listOf("") // Will get filled during build of url
var appVersion = "" // Version of the app

//User-Agent: MyCoolApp/1.0 (https://example.com/contact)
//PublicArtExplorer (publicartexplorer@zell-mbc.com)"
//.header("User-Agent", "Mozilla/5.0 (Android) Coil/3.3.0")

val sharedOkHttpClient = OkHttpClient.Builder()
    .connectTimeout(15, TimeUnit.SECONDS)
    .readTimeout(15, TimeUnit.SECONDS)
    .addInterceptor { chain ->
        val newRequest = chain.request().newBuilder()
            .header("User-Agent", "PublicArtExplorer (https://publicartexplorer.com)")
            .build()
        try {
            chain.proceed(newRequest)
        } catch (e: SocketTimeoutException) {
            DebugLog.add("OkHttp: Timeout connecting to ${newRequest.url}, $e")
            // You MUST return a Response or rethrow
            Response.Builder()
                .request(newRequest)
                .protocol(Protocol.HTTP_1_1)
                .code(504) // Gateway Timeout
                .message("Socket timeout")
                .body(ResponseBody.create("text/plain".toMediaType(), "Timeout"))
                .build()
        } catch (e: IOException) {
            DebugLog.add("OkHttp: Network error connecting to ${newRequest.url}, $e")
            Response.Builder()
                .request(newRequest)
                .protocol(Protocol.HTTP_1_1)
                .code(599) // custom code for "Network error"
                .message("Network error")
                .body(ResponseBody.create("text/plain".toMediaType(), "Network error"))
                .build()
        }
    }
    .build()

// New singleton object to be able to plug in the above OkHttp client
object CoilImageLoader {
    val imageLoader: ImageLoader by lazy {
        ImageLoader.Builder(context = (applicationContext as PublicArtExplorer))
            .components {
                add(OkHttpNetworkFetcherFactory(callFactory = { sharedOkHttpClient }))
            }
            .build()
    }
}

object DebugLog {
    // Observable list for Compose
    val messages = mutableStateListOf("Debug log:")

    fun add(newLine: String) {
        // Inserts at index 1 (below the title)
        messages.add(1, newLine)
    }

    fun clear() {
        messages.clear()
        messages.add("Debug log:")
    }
}
