import java.util.Properties

plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)
    alias(libs.plugins.kotlin.compose)
    alias(libs.plugins.kotlin.serialization)
}

val secretsProperties = Properties()
val secretsFile = rootProject.file("secrets.properties")
if (secretsFile.exists()) {
    secretsFile.inputStream().use { secretsProperties.load(it) }
}

android {
    buildFeatures.buildConfig = true
    dependenciesInfo {
        // Disables dependency metadata when building APKs (for IzzyOnDroid/F-Droid)
        includeInApk = false
        // Disables dependency metadata when building Android App Bundles (for Google Play)
        includeInBundle = true
    }

    // Signing config in KTS

    namespace = "com.zell_mbc.publicartexplorer"
    compileSdk = 36

    //tasks.register('prepareKotlinBuildScriptMode')
    java.targetCompatibility = JavaVersion.VERSION_17
    defaultConfig {
        // Defined in gradle.properties
        versionCode = (project.findProperty("VERSION_CODE") as String).toInt()
        versionName = project.findProperty("VERSION_NAME") as String
        rootProject.extra.set("globalVersionCode", versionCode)

        applicationId = "com.zell_mbc.publicartexplorer"

        minSdk = 24
        targetSdk = 36

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"

        // Do not include the X86 binaries to keep the apk size down
        // Enable before compiling a release
       //ndk {
        //    abiFilters.addAll(listOf("armeabi-v7a", "arm64-v8a"))
        //}
    }

    flavorDimensions += "version"
    productFlavors {
        create("foss") {
            dimension = "version"
            applicationIdSuffix = ".foss"
            buildConfigField("String", "FLAVOUR", "\"foss\"")
            buildConfigField("String", "MAPTOOLKIT_API_KEY", "\"\"")
            buildConfigField("String", "MAPBOX_API_KEY", "\"\"")
            manifestPlaceholders["appAuthRedirectScheme"] = "com.zell_mbc.publicartexplorer.foss"
        }
        create("play") {
            dimension = "version"
            applicationIdSuffix = ".play"
            buildConfigField("String", "FLAVOUR", "\"play\"")
            val maptoolkitApiKey = secretsProperties.getProperty("MAPTOOLKIT_API_KEY") ?: ""
            val mapboxApiKey = secretsProperties.getProperty("MAPBOX_API_KEY") ?: ""
            buildConfigField("String", "MAPTOOLKIT_API_KEY", "\"$maptoolkitApiKey\"")
            buildConfigField("String", "MAPBOX_API_KEY", "\"$mapboxApiKey\"")
            manifestPlaceholders["appAuthRedirectScheme"] = "com.zell_mbc.publicartexplorer.play"
        }
    }

    buildTypes {
        getByName("release") {
            isMinifyEnabled = true
            // isShrinkResources = false // optional
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
            isJniDebuggable = false
            isDebuggable = false
            // applicationIdSuffix = ".release"
        }
        getByName("debug") {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
            isJniDebuggable = true
            isDebuggable = true
            versionNameSuffix = " - Debug"
            // applicationIdSuffix = ".debug"
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    kotlinOptions {
        jvmTarget = "17"
    }

    buildFeatures {
        compose = true
    }

    tasks.whenTaskAdded {
        if (name.contains("ArtProfile")) {
            enabled = false
        }
    }
}

dependencies {
    implementation(libs.androidx.compose.foundation.layout)
    implementation(libs.androidx.core.ktx)
    implementation(libs.androidx.lifecycle.runtime.ktx)
    implementation(libs.androidx.activity.compose)
    implementation(platform(libs.androidx.compose.bom))
    implementation(libs.androidx.ui)
    implementation(libs.androidx.ui.graphics)
    implementation(libs.androidx.ui.tooling.preview)
    implementation(libs.androidx.material3)
    implementation(libs.androidx.compose.material.icons.extended)
    implementation(libs.navigation.compose)
    implementation(libs.datastore.preferences)
    implementation(libs.androidx.security.crypto)
    implementation(libs.kotlinx.serialization.json)

            // 3rd party
    implementation(libs.acra.mail)
    implementation(libs.acra.dialog)
    implementation(libs.acra.notification)
    implementation(libs.acra.toast)
    implementation(libs.okhttp)
    implementation(libs.json)
    implementation(libs.coil.compose)
    implementation(libs.coil.network.okhttp)
    implementation(libs.okhttp)
    implementation(libs.accompanist.permissions)
    implementation(libs.androidx.appcompat)
    implementation(libs.maplibre.compose)
    implementation(libs.maplibre.gl)
    implementation(libs.appauth)
    implementation(libs.androidx.compose.runtime)
    implementation(libs.androidx.compose.foundation.layout)
    implementation(libs.androidx.exifinterface)
    implementation(libs.androidx.compose.foundation)
    implementation(libs.androidx.compose.material3)

    // Play flavor only
    add("playImplementation", libs.google.billing.ktx)
    add("playImplementation", libs.google.billing)
    add("playImplementation",libs.play.services.location)

    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.junit)
    androidTestImplementation(libs.androidx.espresso.core)
    androidTestImplementation(platform(libs.androidx.compose.bom))
    androidTestImplementation(libs.androidx.ui.test.junit4)
    debugImplementation(libs.androidx.ui.tooling)
    debugImplementation(libs.androidx.ui.test.manifest)
}