package com.zell_mbc.publicartexplorer.screens

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material3.Button
import androidx.compose.material3.DropdownMenu
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.Switch
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import com.zell_mbc.publicartexplorer.ui.theme.Contrast

enum class DarkThemeOption {
    Light, Dark, FollowSystem
}

object ThemeState {
    var darkThemeOption by mutableStateOf(DarkThemeOption.FollowSystem)
    var contrast by mutableStateOf(Contrast.Normal)
}

@Composable
fun ThemeSettingsUI() {
    Column(modifier = Modifier.padding(16.dp)) {
        Text("Dark Mode")
        var expandedMode by remember { mutableStateOf(false) }
        Box {
            Button(onClick = { expandedMode = true }) {
                Text(ThemeState.darkThemeOption.name)
            }
            DropdownMenu(expanded = expandedMode, onDismissRequest = { expandedMode = false }) {
                DarkThemeOption.values().forEach { option ->
                    DropdownMenuItem(
                        text = { Text(option.name) },
                        onClick = {
                            ThemeState.darkThemeOption = option
                            expandedMode = false
                        }
                    )
                }
            }
        }

        Spacer(Modifier.height(16.dp))

        Text("Contrast")
        Spacer(Modifier.height(8.dp))

        // Dropdown menu for contrast selection
        var expanded by remember { mutableStateOf(false) }
        Box {
            Button(onClick = { expanded = true }) {
                Text(ThemeState.contrast.name)
            }
            DropdownMenu(expanded = expanded, onDismissRequest = { expanded = false }) {
                Contrast.values().forEach { c ->
                    DropdownMenuItem(
                        text = { Text(c.name) },
                        onClick = {
                            ThemeState.contrast = c
                            expanded = false
                        }
                    )
                }
            }
        }
    }
}
