package com.zell_mbc.publicartexplorer.screens

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.CheckCircle
import androidx.compose.material.icons.filled.Clear
import androidx.compose.material.icons.filled.LocationOn
import androidx.compose.material.icons.filled.Lock
import androidx.compose.material.icons.filled.Settings
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.zell_mbc.publicartexplorer.R

const val colorGood = 0xFF388E3C
const val colorBad =  0xFFD32F2F

@Composable
fun ConnectionSection(
    locationEnabled: Boolean,
    locationProvider: String,
    locationTime: String,
    permissionsGranted: Boolean,
    modifier: Modifier = Modifier
) {
    Surface(modifier = modifier.fillMaxWidth(), tonalElevation = 6.dp, shape = MaterialTheme.shapes.medium,) {
        Column(modifier = Modifier.padding(20.dp), verticalArrangement = Arrangement.spacedBy(16.dp)) {
            Text(
                stringResource(R.string.connectionStatus),
                style = MaterialTheme.typography.titleMedium,
                color = MaterialTheme.colorScheme.primary
            )
            ItemRow(
                icon = if (locationEnabled) Icons.Default.CheckCircle else Icons.Filled.Clear,
                iconTint = if (locationEnabled) Color(colorGood) else Color(colorBad),
                label = stringResource(R.string.locationServicesEnabled),
                value = if (locationEnabled) stringResource(R.string.yes) else stringResource(R.string.no)
            )
            ItemRow(
                icon = if (permissionsGranted) Icons.Default.CheckCircle else Icons.Default.Lock,
                iconTint = if (permissionsGranted) Color(colorGood) else Color(colorBad),
                label = stringResource(R.string.permissionsGranted),
                value = if (locationEnabled) stringResource(R.string.yes) else stringResource(R.string.no)
            )
            ItemRow(
                icon = Icons.Default.LocationOn,
                label = stringResource(R.string.locationProvider),
                value = locationProvider
            )
            ItemRow(
                icon = Icons.Default.Settings,
                label = stringResource(R.string.lastLocationUpdate),
                value = locationTime
            )
        }
    }
}

@Composable
fun ItemRow(
    icon: androidx.compose.ui.graphics.vector.ImageVector? = null,
    iconTint: Color = MaterialTheme.colorScheme.primary,
    label: String,
    value: String
) {
    Row(
        verticalAlignment = Alignment.CenterVertically,
        modifier = Modifier.fillMaxWidth()
    ) {
        if (icon != null) {
            Icon(
                imageVector = icon,
                contentDescription = null,
                tint = iconTint,
                modifier = Modifier.size(20.dp)
            )
            Spacer(Modifier.width(10.dp))
        }
        Text(
            text = label,
            style = MaterialTheme.typography.bodyMedium,
            color = MaterialTheme.colorScheme.onSurfaceVariant,
            modifier = Modifier.weight(1f)
        )
        Text(
            text = value,
            style = MaterialTheme.typography.bodyMedium,
            color = iconTint
        )
    }
}
