package com.zell_mbc.publicartexplorer

import android.app.Application
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import com.zell_mbc.publicartexplorer.maps.getAvailableMapboxStyles
import com.zell_mbc.publicartexplorer.oauth2.TokenManager
import com.zell_mbc.publicartexplorer.onboarding.AppStart
import com.zell_mbc.publicartexplorer.onboarding.checkAppStart
import com.zell_mbc.publicartexplorer.wiki.WikiUserObject
import org.acra.config.dialog
import org.acra.config.mailSender
import org.acra.data.StringFormat
import org.acra.dialog.BuildConfig
import org.acra.ktx.initAcra
import kotlin.jvm.java

class PublicArtExplorer: Application() {
    lateinit var appStart: AppStart

    override fun onCreate() {
        super.onCreate()

        appStart = checkAppStart(this) // Needs to be here to ensure it runs only once
        //appStart = AppStart.FIRST_TIME_APP
        //appStart = AppStart.FIRST_TIME_VERSION

        mapboxStyles = getAvailableMapboxStyles(this) // Fill lists from asset folder
        TokenManager.loadWikiToken(this)
        TokenManager.loadOsmToken(this)

        val packageInfo = if (Build.VERSION.SDK_INT >= 33) { packageManager.getPackageInfo(packageName,PackageManager.PackageInfoFlags.of(0))
        } else {
            @Suppress("DEPRECATION")
            packageManager.getPackageInfo(packageName, 0)
        }
        appVersion = packageInfo.versionName ?: ""
        WikiUserObject.loadName(this)
    }

    override fun attachBaseContext(base: Context) {
        super.attachBaseContext(base)

        initAcra {
            //core configuration:
            buildConfigClass = BuildConfig::class.java
            reportFormat = StringFormat.KEY_VALUE_LIST

            mailSender {
                //required
                mailTo = "publicartexplorer@zell-mbc.com"
                reportAsFile = true
                reportFileName = "crashLog.txt"
                subject = getString(R.string.crashTitle)
                body = getString(R.string.crashMessageEmail)
            }
            dialog {
                text = getString(R.string.crashMessageDialog)
                title = getString(R.string.crashTitle)
                positiveButtonText = getString(R.string.ok)
                negativeButtonText = getString(R.string.cancel)
                commentPrompt = getString(R.string.crashContext)
                resIcon = android.R.drawable.ic_dialog_alert
                emailPrompt = ""
            }
        }
    }

    companion object {
        @Volatile
        private var instance: PublicArtExplorer? = null

        fun getInstance(): PublicArtExplorer = instance ?: throw IllegalStateException("App not initialized yet!")

        val context: Context?
            get() = getInstance().applicationContext
    }
}

