# PublicArtExplorer
[<img src="./Logo.png"
     alt="Logo"
     height="80">](./Logo.png)

[![Status: Active](./badges/status.svg)](#)
[![Status: Active](./badges/release.svg)](#)
[![API Reference](./badges/license.svg)](./LICENSE)

Have you ever found yourself standing before a piece of outdoor art, curious about its story?
Or arrived in a new place wondering if there’s any outdoor artwork waiting to be discovered nearby?

PublicArtExplorer allows you to discover and explore public art around you in just two clicks. The app uses your location to instantly reveal nearby sculptures, murals, and installations, complete with detailed information about each piece and its artist. 

PublicArtExplorer’s data is based on the open platforms OpenStreetMap and Wikipedia. Because these platforms are built and maintained by a global community of volunteers, anyone can contribute: if you notice missing details or discover new artworks, you’re encouraged to add or update information directly on OpenStreetMap or Wikipedia. This collective approach means that every contribution helps to improve the app for all users, fostering a shared, up-to-date resource that benefits everyone interested in public art.

## Key features

Show what's around and offer to show the details for each artwork.

Aimed at providing low barrier access to public art as well as encouraging people to add missing information to OSM and Wikipedia for the benefit of others.

## Web site

https://publicartexplorer.com/


### How do I get the app?

From here: 
- https://codeberg.org/toz/PublicArtExplorer/releases

or via an AppStore:

<p float="left">
  <a href="https://f-droid.org/packages/com.zell_mbc.publicartexplorer.foss/">
    <img alt="Get it on F-Droid" src="assets/f-droid.png" height="80">
  </a>
  <a href="https://apt.izzysoft.de/fdroid/index/apk/com.zell_mbc.publicartexplorer.foss/">
    <img alt="Get it on IzzyInDroid" src="assets/IzzyOnDroidButton.png" height="80">
  </a>
  <a href="https://play.google.com/store/apps/details?id=com.zell_mbc.publicartexplorer.play">
    <img alt="Get it on GooglePlay" src="assets/google-play.png" height="80">
  </a>
</p>



### Privacy Policy
https://publicartexplorer.com/index.php/en/dataprotectiondeclaration-en

#### Stored data
No personal data is requested and stored.


#### Required permissions
- INTERNET is required to be able to branch out to e.g. Wikipedia articles and to download images
- For INTERNET to work, ACCESS_NETWORK_STATE is required
- ACCESS_FINE_LOCATION and ACCESS_COARSE_LOCATION are required to be able to point the map to your current location. You can decline this permission and the app will still function. Obviously positioning the map to your location won't work in that case.

#### Tracking
This app is open source and contains no advertising and no hidden tracking!

In case of a serious crash there is the possibility to send a crash log. However, crash log emails will never be sent without your explicit approval. See here for more details: https://codeberg.org/toz/MediLog/wiki/Crash-logs


#### Libraries
3rd party libraries in use are the below:

- [MapLibre](https://maplibre.org/): Access to OpenStreetMap
- [Coil](https://github.com/coil-kt/coil): To load remote pictures
- [OKHTTP](https://github.com/square/okhttp): Communication with OSM and Wikipedia
- [ACRA](https://www.acra.ch/): Enable crash logs

## Contact & Bug reporting

Please use the issue tracker [here](https://codeberg.org/toz/PublicArtExplorer/issues) for reporting issues and/or suggestions:

Other means to contact the author are:
- Fediverse: Akkoma/Mastodon/Pleroma/etc., @thomas@social.zell-mbc.com
- eMail: PublicArtExplorer@zell-mbc.com


## Donations
If you feel like it…

[<img src="https://liberapay.com/assets/widgets/donate.svg" border="0" alt="Donate using Liberapay">](https://liberapay.com/MediLog/donate)
[<img src="https://www.paypalobjects.com/webstatic/de_DE/i/de-pp-logo-100px.png" border="0" alt="PayPal Logo">](https://www.paypal.com/paypalme/thomaszellmbc)
[<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/c5/Bitcoin_logo.svg/252px-Bitcoin_logo.svg.png" border="0" height="20" alt="Bitcoin Logo">](https://live.blockcypher.com/btc/address/1EUrRpjDAGgpS8J46tmsVWKbgNqAv7rWC7/)

## Screenshots
<p float="left">
  <img src="fastlane/metadata/android/de/images/phoneScreenshots/MapScreen.png" width="400" />
  <img src="fastlane/metadata/android/de/images/phoneScreenshots/DetailView.png" width="400" />
  <img src="fastlane/metadata/android/de/images/tabletScreenshots/Description.png" width="400" />
</p>

## Changelog
[Change log](ChangeLog.md)


