
package com.zell_mbc.medilog.billing

import androidx.compose.material3.*
import androidx.compose.runtime.*
import androidx.compose.ui.window.Dialog
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Star
import androidx.compose.material.icons.filled.Warning
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.zell_mbc.medilog.R

@Composable
fun UnlimitedUpgradeDialog(
    show: Boolean,
    productDetails: UpgradeProductInfo?,
    onPurchaseClick: (UpgradeProductInfo) -> Unit,
    onRestoreClick: () -> Unit,
    onDismiss: () -> Unit
) {
    if (show && productDetails != null) {
        Dialog(onDismissRequest = onDismiss) {
            Surface(
                shape = MaterialTheme.shapes.medium,
                tonalElevation = 8.dp
            ) {
                Column(modifier = Modifier.padding(24.dp)) {
                    Text(text = stringResource(R.string.appName) + " " + stringResource(R.string.upgrade), style = MaterialTheme.typography.titleLarge)
                    Spacer(Modifier.height(8.dp))
                    Text(text = productDetails.title, style = MaterialTheme.typography.bodyLarge)
                    Spacer(Modifier.height(8.dp))
                    Text(text = stringResource(R.string.price) + ": " + productDetails.price, style = MaterialTheme.typography.bodyMedium)
                    Spacer(Modifier.height(16.dp))
                    Button(onClick = { onPurchaseClick(productDetails) }, modifier = Modifier.fillMaxWidth()) {
                        Text(stringResource(R.string.unlockUnlimited))
                    }
                    /*Spacer(Modifier.height(8.dp))
                    OutlinedButton(onClick = onRestoreClick, modifier = Modifier.fillMaxWidth()) {
                        Text(stringResource(R.string.restorePurchase))
                    }*/
                    Spacer(Modifier.height(8.dp))
                    TextButton(onClick = onDismiss, modifier = Modifier.fillMaxWidth()
                    ) {
                        Text(stringResource(R.string.cancel))
                    }
                }
            }
        }
    }
}

@Composable
fun ThankYouForPurchaseDialog(
    onDismiss: () -> Unit
) {
    AlertDialog(
        onDismissRequest = onDismiss,
        title = {
            Text(text = stringResource(R.string.thankYou), style = MaterialTheme.typography.headlineSmall, color = MaterialTheme.colorScheme.primary)
        },
        text = {
            Column(horizontalAlignment = Alignment.CenterHorizontally) {
                Icon(
                    imageVector = Icons.Default.Star,
                    contentDescription = null,
                    tint = MaterialTheme.colorScheme.secondary,
                    modifier = Modifier.size(48.dp)
                )
                Spacer(modifier = Modifier.height(12.dp))
                Text(stringResource(R.string.thankYouDescription), textAlign = TextAlign.Center, style = MaterialTheme.typography.bodyLarge)
            }
        },
        confirmButton = {
            TextButton(onClick = onDismiss) {
                Text(stringResource(R.string.ok))
            }
        },
        shape = RoundedCornerShape(20.dp),
        tonalElevation = 8.dp
    )
}


@Composable
fun BillingUnavailableDialog(
    onDismiss: () -> Unit
) {
    AlertDialog(
        onDismissRequest = onDismiss,
        icon = {
            Icon(
                imageVector = Icons.Default.Warning,
                contentDescription = stringResource(R.string.warning),
                tint = Color(0xFFFFC107), // Amber
                modifier = Modifier.size(48.dp)
            )
        },
        title = {
            Text(stringResource(R.string.googlePlayRequired), fontWeight = FontWeight.Bold, fontSize = 20.sp)
        },
        text = {
            Text(stringResource(R.string.googlePlayRequirdDescription), fontSize = 16.sp)
        },
        confirmButton = {
            TextButton(onClick = onDismiss) {
                Text(stringResource(R.string.ok))
            }
        }
    )
}
