/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.preferences

import android.content.Intent
import android.os.Bundle
import android.view.MenuItem
import android.view.ViewGroup
import androidx.activity.addCallback
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.WindowCompat
import androidx.preference.Preference
import androidx.preference.PreferenceFragmentCompat
import androidx.preference.PreferenceManager
import com.zell_mbc.medilog.R
import androidx.core.content.edit
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.updatePadding

class SettingsActivity : AppCompatActivity(), PreferenceFragmentCompat.OnPreferenceStartFragmentCallback {

    override fun onPreferenceStartFragment(caller: PreferenceFragmentCompat, pref: Preference): Boolean {
            // Instantiate the new Fragment
            val args = pref.extras
            val fragment = supportFragmentManager.fragmentFactory.instantiate(classLoader, pref.fragment.toString())
            fragment.arguments = args
            //fragment.setTargetFragment(caller, 0)
            // Replace the existing Fragment with the new Fragment
            supportFragmentManager.beginTransaction().replace(android.R.id.content, fragment).addToBackStack(null).commit()
            return true
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        //WindowCompat.setDecorFitsSystemWindows(window, true)
        super.onCreate(savedInstanceState)

        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        enableEdgeToEdge() //This will include/color the top Android info bar
        WindowCompat.setDecorFitsSystemWindows(window, true)

        val container = findViewById<ViewGroup>(android.R.id.content)

        // Need this for targetSdkVersion > 35
        ViewCompat.setOnApplyWindowInsetsListener(container) { v, insets ->
            val bars = insets.getInsets(WindowInsetsCompat.Type.systemBars())
            v.updatePadding(top = bars.top, bottom = bars.bottom, left = bars.left, right = bars.right)
            WindowInsetsCompat.CONSUMED
        }

        // Set preference descriptions before they get build
        val preferences = PreferenceManager.getDefaultSharedPreferences(this)
        val threshold = "" + preferences.getString(KEY_PREF_TEMPERATURE_THRESHOLDS,"")
        if (threshold.isEmpty()) {
            val itemUnit = "" + preferences.getString(KEY_PREF_TEMPERATURE_UNIT,getString(R.string.TEMPERATURE_CELSIUS))
            val default = if (itemUnit == getString(R.string.TEMPERATURE_CELSIUS)) getString(R.string.TEMPERATURE_THRESHOLDS_CELSIUS_DEFAULT) else getString(R.string.TEMPERATURE_THRESHOLDS_FAHRENHEIT_DEFAULT)
            preferences.edit() {
                putString(KEY_PREF_TEMPERATURE_THRESHOLDS, default)
            }
            }
        supportFragmentManager.beginTransaction().replace(android.R.id.content, SettingsFragment()).commit()

       onBackPressedDispatcher.addCallback(this) { handleBackPress() }  // Handle the 'hardware' back button
    }

    // Handle top bar back arrow
    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        if (item.itemId == android.R.id.home) {
            handleBackPress()
            return true
        }
        return false
    }

    // This is required to catch the back buttons which otherwise won't reload the activity to reflect settings changes
    private fun handleBackPress() {
        if (supportFragmentManager.backStackEntryCount == 0) { // Reload main activity if on top level
            finish() // Finish SettingsActivity to make sure it's not handling backPressed any longer
        }
        else supportFragmentManager.popBackStack()
    }

    // This is called when the backup folder setting is changed
    @Deprecated("Deprecated in Java")
    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        data ?: return

        if (resultCode == RESULT_OK) {
            val preferences = PreferenceManager.getDefaultSharedPreferences(this)
//            Log.i("Test", "Result URI " + data.data)
            preferences.edit() {
                putString(KEY_PREF_BACKUP_URI, data.data.toString())
            }
            // Refresh screen
            this.recreate()
        }
    }


    companion object {
        const val KEY_PREF_DELIMITER = "delimiter"
        const val KEY_PREF_TEMPERATURE_THRESHOLDS        = "profile_etTemperatureThresholds"
        const val KEY_PREF_TEMPERATURE_UNIT              = "etTemperatureUnit"
        const val KEY_PREF_TEMPERATURE_SHOW_THRESHOLDS   = "cbShowTemperatureThresholds"
        const val KEY_PREF_TEMPERATURE_SHOW_GRID         = "cbShowTemperatureGrid"
        const val KEY_PREF_TEMPERATURE_SHOW_LEGEND       = "cbShowTemperatureLegend"
        const val KEY_PREF_TEMPERATURE_LANDSCAPE         = "cbTemperatureLandscape"
        const val KEY_PREF_TEMPERATURE_PAPER_SIZE        = "liTemperaturePaperSize"
        const val KEY_PREF_TEMPERATURE_HIGHLIGHT_VALUES  = "cbTemperatureHighlightValues"
        const val KEY_PREF_TEMPERATURE_SHOWTIME          = "swTemperatureShowtime"
        const val KEY_PREF_TEMPERATURE_BLENDINITEMS      = "swTemperatureBlendInDiary"
        const val KEY_PREF_TEMPERATURE_PDF_DAYSEPARATOR  = "swTemperaturePdfDaySeparatorLines"
        const val KEY_PREF_TEMPERATURE_PDF_NOTES         = "etTemperaturePdfNotes"
        const val KEY_PREF_TEMPERATURE_SHOW_VALUES        = "cbTemperatureShowValues"
        const val KEY_PREF_TEMPERATURE_SHOW_MOVING_AVERAGE = "cbTemperatureShowMovingAverage"
        const val KEY_PREF_TEMPERATURE_MOVING_AVERAGE_SIZE = "etTemperatureMovingAverageSize"
        const val KEY_PREF_TEMPERATURE_CUSTOM_NAME       = "etTemperatureCustomName"
        const val KEY_PREF_TEMPERATURE_CUSTOM_UNIT       = "etTemperatureCustomUnit"
        const val KEY_PREF_TEMPERATURE_CUSTOM_TEMPLATE     = "etTemperatureCustomDigits"
        const val KEY_PREF_TEMPERATURE_CUSTOM_ICON       = "btTemperatureCustomIcon"

        const val KEY_PREF_GLUCOSE_THRESHOLDS         = "profile_etGlucoseThresholds"
        const val KEY_PREF_GLUCOSE_SHOW_THRESHOLDS    = "cbShowGlucoseThresholds"
        const val KEY_PREF_GLUCOSE_UNIT               = "lpGlucoseUnit"
        const val KEY_PREF_GLUCOSE_SHOW_GRID          = "cbShowGlucoseGrid"
        const val KEY_PREF_GLUCOSE_SHOW_LEGEND        = "cbShowGlucoseLegend"
        const val KEY_PREF_GLUCOSE_LANDSCAPE          = "cbGlucoseLandscape"
        const val KEY_PREF_GLUCOSE_PAPER_SIZE         = "liGlucosePaperSize"
        const val KEY_PREF_LOG_KETONE                 = "cbLogKetone"
        const val KEY_PREF_GLUCOSE_HIGHLIGHT_VALUES   = "cbGlucoseHighlightValues"
        const val KEY_PREF_GLUCOSE_SHOWTIME           = "swGlucoseShowtime"
        const val KEY_PREF_GLUCOSE_BLENDINITEMS       = "swGlucoseBlendInDiary"
        const val KEY_PREF_GLUCOSE_PDF_DAYSEPARATOR   = "swGlucosePdfDaySeparatorLines"
        const val KEY_PREF_GLUCOSE_CUSTOM_NAME        = "etGlucoseCustomName"
        const val KEY_PREF_GLUCOSE_CUSTOM_UNIT        = "etGlucoseCustomUnit"
        const val KEY_PREF_GLUCOSE_CUSTOM_TEMPLATE    = "etGlucoseCustomDigits"
        const val KEY_PREF_GLUCOSE_PDF_NOTES          = "etGlucosePdfNotes"
        const val KEY_PREF_GLUCOSE_SHOW_VALUES        = "cbGlucoseShowValues"
        const val KEY_PREF_GLUCOSE_SHOW_MOVING_AVERAGE = "cbGlucoseShowMovingAverage"
        const val KEY_PREF_GLUCOSE_MOVING_AVERAGE_SIZE = "etGlucoseMovingAverageSize"

        const val KEY_PREF_OXIMETRY_THRESHOLDS        = "profile_etOximetryThresholds"
        const val KEY_PREF_OXIMETRY_SHOW_THRESHOLDS   = "cbShowOximetryThresholds"
        const val KEY_PREF_OXIMETRY_UNIT              = "etOximetryUnit"
        const val KEY_PREF_OXIMETRY_SHOW_GRID         = "cbShowOximetryGrid"
        const val KEY_PREF_OXIMETRY_SHOW_LEGEND       = "cbShowOximetryLegend"
        const val KEY_PREF_OXIMETRY_LANDSCAPE         = "cbOximetryLandscape"
        const val KEY_PREF_OXIMETRY_PAPER_SIZE         = "liOximetryPaperSize"
        const val KEY_PREF_OXIMETRY_HIGHLIGHT_VALUES   = "cbOximetryHighlightValues"
        const val KEY_PREF_OXIMETRY_SHOWTIME           = "swOximetryShowtime"
        const val KEY_PREF_OXIMETRY_BLENDINITEMS       = "swOximetryBlendInDiary"
        const val KEY_PREF_OXIMETRY_PDF_DAYSEPARATOR   = "swOximetryPdfDaySeparatorLines"
        const val KEY_PREF_OXIMETRY_PDF_NOTES           = "etOximetryPdfNotes"
        const val KEY_PREF_OXIMETRY_SHOW_VALUES         = "cbOximetryShowValues"
        const val KEY_PREF_OXIMETRY_SHOW_MOVING_AVERAGE = "cbOximetryShowMovingAverage"
        const val KEY_PREF_OXIMETRY_MOVING_AVERAGE_SIZE = "etOximetryMovingAverageSize"
        const val KEY_PREF_OXIMETRY_CUSTOM_NAME         = "etOximetryCustomName"
        const val KEY_PREF_OXIMETRY_CUSTOM_UNIT         = "etOximetryCustomUnit"
        const val KEY_PREF_OXIMETRY_CUSTOM_TEMPLATE     = "etOximetryCustomTemplate"

        const val KEY_PREF_BODY_HEIGHT                = "profile_etHeight"
        const val KEY_PREF_WEIGHT_THRESHOLDS           = "profile_etWeightThresholds"
        const val KEY_PREF_LOG_FAT                    = "profile_cbLogBodyFat"
        const val KEY_PREF_FAT_MIN_MAX                = "profile_etFatMinMax"
        const val KEY_PREF_WEIGHT_TARE                = "profile_etTare"
        const val KEY_PREF_WEIGHT_UNIT                = "liWeightUnit"
        const val KEY_PREF_WEIGHT_HIGHLIGHT_VALUES    = "cbWeightHighlightValues"
        const val KEY_PREF_SHOW_WEIGHT_THRESHOLD      = "cbShowWeightThreshold"
        const val KEY_PREF_SHOW_WEIGHT_GRID           = "cbShowWeightGrid"
        const val KEY_PREF_SHOW_WEIGHT_LEGEND         = "cbShowWeightLegend"
        const val KEY_PREF_WEIGHT_SHOW_VALUES         = "cbWeightShowValues"
        const val KEY_PREF_WEIGHT_SHOW_MOVING_AVERAGE = "cbWeightShowMovingAverage"
        const val KEY_PREF_WEIGHT_MOVING_AVERAGE_SIZE = "etWeightMovingAverageSize"
        const val KEY_PREF_WEIGHT_LANDSCAPE           = "cbWeightLandscape"
        const val KEY_PREF_WEIGHT_PAPER_SIZE          = "liWeightPaperSize"
        const val KEY_PREF_WEIGHT_SHOWTIME            = "swWeightShowtime"
        const val KEY_PREF_WEIGHT_BLENDINITEMS        = "swWeightBlendInDiary"
        const val KEY_PREF_WEIGHT_PDF_DAYSEPARATOR    = "swWeightPdfDaySeparatorLines"
        const val KEY_PREF_SHOW_WEIGHT_LINEAR_TRENDLINE = "cbWeightLinearTrendline"
        const val KEY_PREF_WEIGHT_CUSTOM_NAME          = "etWeightCustomName"
        const val KEY_PREF_WEIGHT_CUSTOM_UNIT          = "etWeightCustomUnit"
        const val KEY_PREF_WEIGHT_CUSTOM_TEMPLATE      = "etWeightCustomTemplate"
        const val KEY_PREF_WEIGHT_PDF_NOTES            = "etWeightPdfNotes"

        const val KEY_PREF_FLUID_THRESHOLD            = "profile_evFluidThreshold"
        const val KEY_PREF_FLUID_ENABLE_TAGS          = "evFluidEnableTags"
        const val KEY_PREF_FLUID_UNIT                 = "evFluidUnit"
        const val KEY_PREF_FLUID_SUMMARYPDF           = "swShowSummaryInPDF"
        const val KEY_PREF_FLUID_SUMMARY_CHART        = "swShowSummaryInChart"
        const val KEY_PREF_SHOW_FLUID_THRESHOLD       = "cbShowFluidThreshold"
        const val KEY_PREF_SHOW_FLUID_GRID            = "cbShowFluidGrid"
        const val KEY_PREF_SHOW_FLUID_LEGEND          = "cbShowFluidLegend"
        const val KEY_PREF_FLUID_LANDSCAPE            = "cbFluidLandscape"
        const val KEY_PREF_FLUID_PAPER_SIZE           = "liFluidPaperSize"
        const val KEY_PREF_FLUID_SHOWTIME             = "swFluidShowtime"
        const val KEY_PREF_FLUID_BLENDINITEMS         = "swFluidBlendInDiary"
        const val KEY_PREF_FLUID_PDF_DAYSEPARATOR     = "swFluidPdfDaySeparatorLines"
        const val KEY_PREF_FLUID_CUSTOM_NAME          = "etFluidCustomName"
        const val KEY_PREF_FLUID_CUSTOM_UNIT          = "etFluidCustomUnit"
        const val KEY_PREF_FLUID_CUSTOM_TEMPLATE      = "etFluidCustomTemplate"
        const val KEY_PREF_FLUID_PDF_NOTES            = "etFluidPdfNotes"
        const val KEY_PREF_FLUID_SHOW_MOVING_AVERAGE = "cbFluidShowMovingAverage"
        const val KEY_PREF_FLUID_MOVING_AVERAGE_SIZE = "etFluidMovingAverageSize"
        const val KEY_PREF_FLUID_SHOW_VALUES         = "cbFluidShowValues"

        const val KEY_PREF_BLOODPRESSURE_HIGHLIGHT_VALUES          = "cbBloodPressureHighlightValues"
        const val KEY_PREF_BLOODPRESSURE_UNIT                      = "etBloodPressureUnit"
        const val KEY_PREF_LOG_HEART_RHYTHM                        = "cbLogHeartRhythm"
        const val KEY_PREF_SHOW_BLOODPRESSURE_THRESHOLD            = "cbShowBloodPressureThreshold"
        const val KEY_PREF_SHOW_BLOODPRESSURE_GRID                 = "cbShowBloodPressureGrid"
        const val KEY_PREF_SHOW_BLOODPRESSURE_LEGEND               = "cbShowBloodPressureLegend"
        const val KEY_PREF_SHOWPULSE                               = "cbShowPulse"
        const val KEY_PREF_HYPERGRADE3                             = "grade3"
        const val KEY_PREF_HYPERGRADE2                             = "grade2"
        const val KEY_PREF_HYPERGRADE1                             = "grade1"
        const val KEY_PREF_HYPOTENSION                             = "etHypotension"
        const val KEY_PREF_BLOODPRESSURE_SHOW_VALUES               = "cbBloodPressureShowValues"
        const val KEY_PREF_BLOODPRESSURE_SHOW_MOVING_AVERAGE       = "cbBloodPressureShowMovingAverage"
        const val KEY_PREF_BLOODPRESSURE_MOVING_AVERAGE_SIZE       = "etBloodPressureMovingAverageSize"
        const val KEY_PREF_BLOODPRESSURE_PAPER_SIZE                = "liBloodPressurePaperSize"
        const val KEY_PREF_BLOODPRESSURE_LANDSCAPE                 = "cbBloodPressureLandscape"
        const val KEY_PREF_BLOODPRESSURE_TIMEZONES                 = "etTimezones"
        const val KEY_PREF_BLOODPRESSURE_SHOWTIME                  = "swBloodPressureShowtime"
        const val KEY_PREF_BLOODPRESSURE_BLENDINITEMS              = "swBloodPressureBlendInDiary"
        const val KEY_PREF_BLOODPRESSURE_MULTI_MEASUREMENTS_WINDOW = "etMultiMeasurementsWindow"
        const val KEY_PREF_BLOODPRESSURE_PDF_DAYSEPARATOR          = "swBloodPressurePdfDaySeparatorLines"
        const val KEY_PREF_BLOODPRESSURE_RIBBON_CHART              = "swBloodPressureRibbonChart"
        const val KEY_PREF_SHOW_BLOODPRESSURE_LINEAR_TRENDLINE     = "cbBloodPressureLinearTrendline"
        const val KEY_PREF_BLOODPRESSURE_PDF_NOTES                 = "etBloodPressurePdfNotes"
        const val KEY_PREF_BLOODPRESSURE_CUSTOM_NAME1              = "etBloodPressureCustomLabel1"
        const val KEY_PREF_BLOODPRESSURE_CUSTOM_UNIT               = "etBloodPressureCustomUnit"
        const val KEY_PREF_BLOODPRESSURE_CUSTOM_TEMPLATE           = "etBloodPressureCustomTemplate"

        const val KEY_PREF_DIARY_PAPER_SIZE        = "liDiaryPaperSize"
        const val KEY_PREF_DIARY_LANDSCAPE         = "cbDiaryLandscape"
        const val KEY_PREF_DIARY_SHOWTIME          = "swDiaryShowtime"
        const val KEY_PREF_DIARY_SHOWGOOD          = "swShowGoodEmoji"
        const val KEY_PREF_DIARY_SHOWNOTGOOD       = "swShowNotGoodEmoji"
        const val KEY_PREF_DIARY_SHOWBAD           = "swShowBadEmoji"
        const val KEY_PREF_DIARY_BLENDINITEMS      = "swDiaryBlendInItems"
        const val KEY_PREF_DIARY_PDF_DAYSEPARATOR  = "swDiaryPdfDaySeparatorLines"
        const val KEY_PREF_DIARY_PDF_NOTES         = "etDiaryPdfNotes"
        const val KEY_PREF_DIARY_CUSTOM_NAME       = "etDiaryCustomName"

        const val KEY_PREF_BACKUP_WARNING  = "etBackupWarning"
        const val KEY_PREF_AUTO_BACKUP     = "etAutoBackup"
        const val KEY_PREF_LAST_BACKUP     = "tvLastBackup"
        const val KEY_PREF_BACKUP_URI      = "tvBackupUri"
        const val KEY_PREF_ADD_TIMESTAMP   = "cbAddTimestamp"

        const val KEY_PREF_ACTIVE_TABS_SET      = "liActiveTabs"

        const val KEY_PREF_TEXT_SIZE = "listTextSize"
        const val KEY_PREF_QUICKENTRY = "quickEntry"
        const val KEY_PREF_APP_THEME = "lpAppTheme"
        const val KEY_PREF_PDF_TEXT_SIZE = "etPdfTextSize"
        const val KEY_PREF_PDF_ORDER = "liPdfDataOrder"

        const val KEY_PREF_PASSWORD               = "zipPassword"
        const val KEY_PREF_BIOMETRIC              = "spEnableBiometric"
        const val KEY_PREF_ENABLECRASHLOGS        = "spTurnOnCrashLogs"
        const val KEY_PREF_BLOCK_SCREENSHOTS      = "spBlockScreenshots"
        const val KEY_PREF_FORCE_REAUTHENTICATION = "etAuthenticationTimeout"
        const val KEY_PREF_DYNAMIC_COLOR          = "swDynamicColor"
        const val DEBUG_MODE_KEY                  = "debug_mode"

        //const val KEY_PREF_ENABLEATTACHMENTS = "cbEnableAttachments"

    }
}