/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.documents

import android.app.Application
import com.zell_mbc.medilog.Tabs
import com.zell_mbc.medilog.R.string
import com.zell_mbc.medilog.data.DataViewModel

class DocumentsViewModel(application: Application): DataViewModel(application, Tabs.DOCUMENTS) {
    override val filterStartPref = "DOCUMENTS_FILTER_START"
    override val filterEndPref = "DOCUMENTS_FILTER_END"
    override val timeFilterModePref =  "DOCUMENTS_FILTER_MODE"
    override val rollingFilterValuePref = "DOCUMENTS_ROLLING_FILTER_VALUE"
    override val rollingFilterTimeframePref = "DOCUMENTS_ROLLING_FILTER_TIMEFRAME"
    override val tagFilterPref = "DOCUMENTS_TAG_FILTER"
    override val dateTimeColumnWidthPref = "DOCUMENTS_DATE_COLUMN_WIDTH"

    //All preferences that affect UI or app behavior displayed in UI should be here
    // General settings
    override var blendInItems    = false
    override var highlightValues = false
    override var showTime        = true //by mutableStateOf(preferences.getBoolean(SettingsActivity.KEY_PREF_DOCUMENTS_SHOWTIME, app.getString(string.SHOWTIME_DEFAULT).toBoolean()))
    override var upperThreshold  = 0f
    override var lowerThreshold  = 0f

    init {
        quickEntry = false // Always false, no matter the global setting
        setupEntryFields()
    }

    // Specific parameters, applicable to just this field
    override fun setupEntryFields() {
        comment.label = app.getString(string.documentName)
    }
}
