plugins {
    id("com.google.devtools.ksp")
    alias(libs.plugins.compose.compiler)
    id("com.android.application")
    id("kotlin-android")
    id("kotlin-parcelize")
}

kotlin {
    jvmToolchain {
        languageVersion.set(JavaLanguageVersion.of(17))
    }
}

android {
    ksp {
        arg("room.schemaLocation", "$projectDir/schemas")
    }

    namespace = "com.zell_mbc.medilog"
    compileSdk = 36

    lint {
        disable.add("MissingTranslation")
    }

    // Compose for Kotlin DSL: = true (not 'set true')
    buildFeatures {
        viewBinding = true
        compose = true
    }

    dependenciesInfo {
        // .set(false) for Kotlin DSL (no '=')
        includeInApk = false
        includeInBundle = false
    }

    // Signing config in KTS

    // Java compatibility - both here and in compileOptions
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    java {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
    }

    // Needed for some IDEs/tools, but not always required
    // tasks.register("prepareKotlinBuildScriptMode") // Only needed if referenced elsewhere

    defaultConfig {
        // Defined in gradle.properties
        versionCode = (project.findProperty("VERSION_CODE") as String).toInt()
        versionName = project.findProperty("VERSION_NAME") as String
        rootProject.extra.set("globalVersionCode", versionCode)

        applicationId = "com.zell_mbc.medilog"
        minSdk = 26
        targetSdk = 36
//        versionCode = 5495
 //       versionName = "3.3.4"
        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"

        // For Room schema location annotation processor argument
        javaCompileOptions {
            annotationProcessorOptions {
                arguments += mapOf("room.schemaLocation" to "$projectDir/schemas")
            }
        }

        vectorDrawables {
            useSupportLibrary = true
        }
    }

    flavorDimensions += "version"

    productFlavors {
        create("foss") {
            dimension = "version"
            resValue("integer", "flavour", "0")
        }
        create("play") {
            dimension = "version"
            applicationIdSuffix = ".play"
            resValue("integer", "flavour", "1")
        }
        create("fdroid") {
            dimension = "version"
            applicationIdSuffix = ".fdroid"
            resValue("integer", "flavour", "2")
        }
    }

    buildTypes {
        getByName("release") {
            isMinifyEnabled = true
            // isShrinkResources = false // optional
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
            isJniDebuggable = false
            isDebuggable = false
            // applicationIdSuffix = ".release"
        }
        getByName("debug") {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
            isJniDebuggable = true
            isDebuggable = true
            versionNameSuffix = " - Debug"
            // applicationIdSuffix = ".debug"
        }
        create("beta") {
            isMinifyEnabled = true
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
            versionNameSuffix = " - Beta"
            isDebuggable = false
            isJniDebuggable = false
            applicationIdSuffix = ".beta"
        }
    }

    tasks.whenTaskAdded {
        if (name.contains("ArtProfile")) {
            enabled = false
        }
    }
}

dependencies {
    implementation(platform(libs.androidx.compose.bom))
    implementation(libs.androidx.material3)
    implementation(libs.androidx.compiler)
    implementation(libs.androidx.foundation)
    implementation(libs.androidx.runtime)
    implementation(libs.androidx.runtime.livedata)
    implementation(libs.androidx.ui)
    implementation(libs.androidx.animation)
    implementation(libs.androidx.ui.tooling)
    implementation(libs.androidx.material.icons.extended)
    implementation(libs.androidx.compose.runtime)
    implementation(libs.androidx.compose.foundation.layout)
    implementation(libs.androidx.compose.ui)
    implementation(libs.androidx.compose.foundation)
    ksp(libs.room.compiler)

    implementation(libs.androidx.activity.compose)
    implementation(libs.androidx.databinding.runtime)
    implementation(libs.androidx.preference.ktx)
    implementation(fileTree(mapOf("dir" to "libs", "include" to listOf("*.jar"))))
    implementation(libs.androidx.appcompat)
    implementation(libs.androidx.constraintlayout)
    implementation(libs.google.material)
    implementation(libs.androidx.legacy.support.v4)
    implementation(libs.androidx.security.crypto)

    implementation(libs.androidx.biometric)
    implementation(libs.androidx.annotation)
    implementation(libs.androidx.fragment.ktx)
    implementation(libs.androidx.core.ktx)

    implementation(libs.kotlin.stdlib.jdk8)
    implementation(libs.androidx.navigation.compose)

    implementation(libs.androidx.lifecycle.extensions)
    implementation(libs.androidx.lifecycle.viewmodel.ktx)
    implementation(libs.androidx.lifecycle.viewmodel.savedstate)
    implementation(libs.androidx.lifecycle.common.java8)

    implementation(libs.androidx.room.runtime)
    implementation(libs.androidx.room.ktx)

    // Compose
    implementation(libs.androidx.room.ktx)

    // Play flavour only
    add("playImplementation", libs.google.billing.ktx)
    add("playImplementation", libs.google.billing)

    // 3rd party
    implementation(libs.acra.mail)
    implementation(libs.acra.dialog)
    implementation(libs.acra.notification)
    implementation(libs.acra.toast)

    implementation(libs.zip4j)
    add("fossImplementation", libs.sqlcipher.android)
    implementation(libs.kizitonwose)

    implementation(libs.vicoCompose)
    implementation(libs.vicoCore)

    // Integration tests
    // Core library
    androidTestImplementation(libs.androidx.core)
    androidTestImplementation(libs.androidx.rules)
    testImplementation(libs.androidx.runner)
    testImplementation(libs.androidx.junit.ktx)
    testImplementation(libs.junit)
    androidTestImplementation(libs.androidx.espresso.core)
    androidTestImplementation(libs.androidx.espresso.intents)

    // Unit tests
    testImplementation(libs.truth)
    testImplementation(libs.mockito.core)
    testImplementation(libs.mockito.inline)
    testImplementation(libs.kotlinx.coroutines.test)

    // other test dependencies like:
    testImplementation(libs.junit)
    testImplementation(libs.androidx.room.testing)

    testImplementation(libs.truth)
    testImplementation(libs.kotlinx.coroutines.test)
    testImplementation(kotlin("test"))
}
