/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.data

import android.content.Context
import android.content.SharedPreferences
import android.util.Log
import androidx.preference.PreferenceManager
import com.zell_mbc.medilog.preferences.SettingsActivity
import com.zell_mbc.medilog.preferences.SettingsActivity.Companion.KEY_PREF_QUICKENTRY
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow

// Create state flows for global settings
class SettingsRepository(context: Context) {
    private val prefs = PreferenceManager.getDefaultSharedPreferences(context)

    private val _quickEntry = MutableStateFlow(prefs.getBoolean(KEY_PREF_QUICKENTRY, true))
    val quickEntry: StateFlow<Boolean> = _quickEntry

    private val prefListener = SharedPreferences.OnSharedPreferenceChangeListener { shared, key ->
        //Log.d("SettingsRepo", "pref listener fired: key=$key")
        if (key == KEY_PREF_QUICKENTRY) {
            val newVal = shared.getBoolean(key, true)
           // Log.d("SettingsRepo", "quickEntry change detected: $newVal")
            _quickEntry.value = newVal
        }
    }
    init {
        //Log.d("SettingsRepo", "Registering pref listener on prefs=${prefs}")
        prefs.registerOnSharedPreferenceChangeListener(prefListener)
    }

    fun cleanup() {
        prefs.unregisterOnSharedPreferenceChangeListener(prefListener)
    }
}
