/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog

import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.setValue
import com.zell_mbc.medilog.Tabs.BLOODPRESSURE
import com.zell_mbc.medilog.Tabs.DIARY
import com.zell_mbc.medilog.Tabs.DOCUMENTS
import com.zell_mbc.medilog.Tabs.FLUID
import com.zell_mbc.medilog.Tabs.GLUCOSE
import com.zell_mbc.medilog.Tabs.OXIMETRY
import com.zell_mbc.medilog.Tabs.TEMPERATURE
import com.zell_mbc.medilog.Tabs.WEIGHT

// Preferences which are not settings
const val ACTIVE_TABS_KEY = "profile_activeTabs"
const val ACTIVE_TAB_KEY = "profile_activeTab"
const val ACTIVE_PROFILE_KEY = "activeProfile"

const val PROFILE_PREFERENCES_STUB = "profile_"
const val DATABASE_PIN_KEY = "databasePin"

const val UNSET = -1
object ActiveProfile {
    // Compose-friendly state
    var id by mutableStateOf(UNSET)
    var name = ""
}

const val INITIAL_TABS = "$WEIGHT,$BLOODPRESSURE,$DIARY,$DOCUMENTS"

const val UnlimitedRecords = "unlock_unlimited_records" // Dual use: Name of the product in Google Play, preferences key
const val databaseName = "MediLogDatabase"
const val glucoseUnitUndefined = "GLUCOSE_UNDEFINED"

val backupFileNames = arrayOf("MediLog-Data.csv", "MediLog-Profiles.csv", "MediLog-TextTemplates.csv", "MediLog-Tags.csv")

object AppFlavours {
    const val FOSS = 0
    const val PLAY = 1
    const val PLAY_NOT_LICENSED_WARNING = 90
    const val PLAY_NOT_LICENSED = 100
    const val ALL_TABS_PLAY = "$WEIGHT,$BLOODPRESSURE,$DIARY,$DOCUMENTS"
    const val ALL_TABS_FOSS = "$WEIGHT,$BLOODPRESSURE,$DIARY,$FLUID,$GLUCOSE,$TEMPERATURE,$OXIMETRY,$DOCUMENTS"
}

object Tabs {
    const val WEIGHT = 1
    const val BLOODPRESSURE = 2
    const val DIARY = 3
    const val FLUID = 4
    const val GLUCOSE = 5
    const val TEMPERATURE = 6
    const val OXIMETRY = 7
    const val DOCUMENTS = 8
    const val LAST_TAB = 8
    //const val ALL_TABS = "$WEIGHT,$BLOODPRESSURE,$DIARY,$FLUID,$GLUCOSE,$TEMPERATURE,$OXIMETRY,$DOCUMENTS"
}

object ProjectDetails {
    const val author = "Zell-MBC"
    const val authorUrl = "https://zell-mbc.com"
    const val projectWebsiteUrl = "https://codeberg.org/toz/MediLog"
    const val emailAddress = "medilog@zell-mbc.com"
    const val fediverseUrl = "https://social.zell-mbc.com/medilog"
    const val thirdParty = "https://codeberg.org/toz/MediLog#libraries"
    const val appLicense = "https://codeberg.org/toz/MediLog/src/branch/master/LICENSE"
}

object Thresholds {
    const val NO_THRESHOLD_FLOAT = Float.MAX_VALUE
    const val NO_THRESHOLD_INT = Int.MAX_VALUE
    const val MIN_WEIGHT = 20f
    const val MAX_WEIGHT = 999
    const val MAX_BODYFAT = 99
    const val MAX_FLUID = 9999
    const val MAX_TEMPERATURE = 999f
    const val MAX_GLUCOSE_MG = 600
    const val MAX_GLUCOSE_MMOL = 99.9F

    const val MAX_OXYGEN = 100
    const val MAX_SYS = 399
    const val MAX_DIA = 299
    const val MAX_PULSE = 299
}

object IntentTypes {
    const val ZIP = "application/zip"
    const val CSV = "application/txt"
    const val PDF = "application/pdf"
}

object Filter {
    const val OFF = 0
    const val STATIC = 1
    const val ROLLING = 2
    const val NO_TAGS = ""
}
