/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */
package com.zell_mbc.medilog.billing

import android.app.Activity
import android.content.Context

class BillingManagerImpl : BillingManager {
    // Those get never called
    override var showThankYouDialog: ((Boolean) -> Unit)? = null
    override var setUnlimitedRecords: ((Boolean) -> Unit)? = null
    override var showBillingUnavailableDialog: ((Boolean) -> Unit)? = null

    override fun isLicensedUser(context: Context) {
        return
    }

    override fun launchPurchaseFlow(activity: Activity) {
        // No-op: FOSS version does not support purchases
    }

    override fun queryUpgradeProduct(context: Context, onResult: (UpgradeProductInfo?) -> Unit) {
        onResult(null)
    }
}
