import androidx.room.Room
import androidx.test.core.app.ApplicationProvider
import com.zell_mbc.medilog.data.MediLogDB
import com.zell_mbc.medilog.data.TextTemplates
import com.zell_mbc.medilog.texttemplates.TextTemplatesDao
import com.zell_mbc.medilog.texttemplates.TextTemplatesViewModel
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.runBlocking
import org.junit.After
import org.junit.Before
import org.junit.Test
import org.junit.Assert.*

class TextTemplatesTest {
    private lateinit var dao_rw: TextTemplatesDao
    private lateinit var dao_ro: TextTemplatesDao
    private lateinit var db_rw: MediLogDB
    private lateinit var db_ro: MediLogDB
    private lateinit var vm: TextTemplatesViewModel

    @Before
    fun createDb() {
        //MediLogDB.TEST_MODE = true
        db_rw = Room.inMemoryDatabaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java).build()
        db_ro = Room.databaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java, "MediLogDatabase").build()
        dao_rw = db_rw.TextTemplatesDao()
        dao_ro = db_ro.TextTemplatesDao()
        vm = TextTemplatesViewModel(ApplicationProvider.getApplicationContext())
    }

    @After
    fun closeDb() {
        db_rw.close()
        db_ro.close()
    }

    @Test
    fun insertEntry_andGetAllEntries() {
        val item = TextTemplates(_id = 1, template = "Test Entry", type = 1)
        var allEntries: List<TextTemplates> = emptyList()
        runBlocking {
                dao_rw.upsert(item)
                allEntries = dao_rw.getAllRecords().first()
        }

        // Assert: Check if the inserted tag is in the list
        assertTrue(allEntries.contains(item))
    }

    @Test
    fun insertAndGetEntryById() {
        // Arrange: Create a tag and insert it
        val item = TextTemplates(_id = 1, template = "Test Entry", type = 1)
        var retrievedEntry: TextTemplates? = null

        // Act: Get the entry by ID
        runBlocking {
                dao_rw.upsert(item)
                retrievedEntry = dao_rw.getItem(item._id)
        }
        // Assert: Check if the retrieved entry is the same
        assertNotNull(retrievedEntry)
        assertEquals(item,retrievedEntry)
    }

    @Test
    fun convert_to_CSV() {
        var allEntries: List<TextTemplates> = emptyList()
        runBlocking { allEntries = dao_ro.getAllRecords().first() }

        // Assert: Check if the inserted tag is in the list
        val lines = vm.dataToCSV(allEntries)
        val listCount = allEntries.count() + 1 // +1 because of header
        val csvCount = lines.lines().count()
        assertEquals(listCount, csvCount)
    }

}