import androidx.room.Room
import androidx.test.core.app.ApplicationProvider
import com.zell_mbc.medilog.data.MediLogDB
import com.zell_mbc.medilog.data.Profiles
import com.zell_mbc.medilog.profiles.ProfilesViewModel
import com.zell_mbc.medilog.profiles.ProfilesDao
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.runBlocking
import org.junit.After
import org.junit.Before
import org.junit.Test
import org.junit.Assert.*

class ProfilesTest {
    private lateinit var dao_rw: ProfilesDao
    private lateinit var dao_ro: ProfilesDao
    private lateinit var db_rw: MediLogDB
    private lateinit var db_ro: MediLogDB
    private lateinit var vm: ProfilesViewModel

    @Before
    fun createDb() {
        //MediLogDB.TEST_MODE = true
        db_rw = Room.inMemoryDatabaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java).build()
        db_ro = Room.databaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java, "MediLogDatabase").build()
        dao_rw = db_rw.profilesDao()
        dao_ro = db_ro.profilesDao()
        vm = ProfilesViewModel(ApplicationProvider.getApplicationContext())
    }

    @After
    fun closeDb() {
        db_rw.close()
        db_ro.close()
    }

    @Test
    fun insertEntry_andGetAllEntries() {
        val item = Profiles(_id = 1, name = "Test Profile", description = "Description")
        var allEntries: List<Profiles> = emptyList()
        runBlocking {
            dao_rw.upsert(item)
            allEntries = dao_rw.getAllRecords().first()
        }

        // Assert: Check if the inserted tag is in the list
        assertTrue(allEntries.contains(item))
    }

    @Test
    fun insertAndGetEntryById() {
        // Arrange: Create a tag and insert it
        val item = Profiles(_id = 1, name = "Test Profile", description = "Description")
        var retrievedEntry: Profiles? = null

        // Act: Get the entry by ID
        runBlocking {
            dao_rw.upsert(item)
            retrievedEntry = dao_rw.getItem(item._id)
        }
        // Assert: Check if the retrieved entry is the same
        assertNotNull(retrievedEntry)
        assertEquals(item,retrievedEntry)
    }

    @Test
    fun convert_to_CSV() {
        var allEntries: List<Profiles> = emptyList()
        runBlocking { allEntries = dao_ro.getAllRecords().first() }

        // Assert: Check if the inserted tag is in the list
        val lines = vm.dataToCSV(allEntries)
        val listCount = allEntries.count() + 1 // +1 because of header
        val csvCount = lines.lines().count()
        assertEquals(listCount, csvCount)
    }

}