import androidx.room.Room
import androidx.test.core.app.ApplicationProvider
import com.zell_mbc.medilog.data.Data
import com.zell_mbc.medilog.data.MediLogDB
import com.zell_mbc.medilog.data.Profiles
import com.zell_mbc.medilog.data.DataViewModel
import com.zell_mbc.medilog.data.DataDao
import com.zell_mbc.medilog.weight.WeightViewModel
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.runBlocking
import org.junit.After
import org.junit.Before
import org.junit.Test
import org.junit.Assert.*
import java.util.Date

class DataTest {
    private lateinit var dao_rw: DataDao
    private lateinit var dao_ro: DataDao
    private lateinit var db_rw: MediLogDB
    private lateinit var db_ro: MediLogDB
    private lateinit var vm: DataViewModel

    @Before
    fun createDb() {
        //MediLogDB.TEST_MODE = true
        db_rw = Room.inMemoryDatabaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java).build()
        db_ro = Room.databaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java, "MediLogDatabase").build()
        dao_rw = db_rw.dataDao()
        dao_ro = db_ro.dataDao()
        vm = WeightViewModel(ApplicationProvider.getApplicationContext())
    }

    @After
    fun closeDb() {
        db_rw.close()
        db_ro.close()
    }

    @Test
    fun insertEntry_andGetAllEntries() {
        val item = Data(_id = 1, timestamp = Date().time, value1 = "1.0", value2 = "2.0", value3 = "3.0", value4 = "4.0", type = 1, profile_id = 1,attachment = "", tags = "", category_id = -1, comment = "test")
        var allEntries: List<Data> = emptyList()
        runBlocking {
            dao_rw.upsert(item)
            allEntries = dao_rw.getAllRecords().first()
        }

        // Assert: Check if the inserted tag is in the list
        assertTrue(allEntries.contains(item))
    }

    @Test
    fun insertAndGetEntryById() {
        // Arrange: Create a tag and insert it
        val item = Data(_id = 1, timestamp = Date().time, value1 = "1.0", value2 = "2.0", value3 = "3.0", value4 = "4.0", type = 1, profile_id = 1,attachment = "", tags = "", category_id = -1, comment = "test")
        var retrievedEntry: Data? = null

        // Act: Get the entry by ID
        runBlocking {
            dao_rw.upsert(item)
            retrievedEntry = dao_rw.getItem(item._id)
        }
        // Assert: Check if the retrieved entry is the same
        assertNotNull(retrievedEntry)
        assertEquals(item,retrievedEntry)
    }

    @Test
    fun convert_to_CSV() {
        var allEntries: List<Data> = emptyList()
        runBlocking { allEntries = dao_ro.getAllRecords().first() }

        // Assert: Check if the inserted tag is in the list
        val lines = vm.dataToCSV(allEntries)
        val listCount = allEntries.count() + 1 // +1 because of header
        val csvCount = lines.lines().count()
        assertEquals(listCount, csvCount)
    }

}