/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.weight

import android.os.Bundle
import android.widget.Toast
import androidx.activity.viewModels
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.safeDrawingPadding
import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.lifecycle.viewmodel.compose.viewModel
import com.patrykandpatrick.vico.compose.cartesian.CartesianChartHost
import com.patrykandpatrick.vico.compose.cartesian.axis.rememberBottom
import com.patrykandpatrick.vico.compose.cartesian.axis.rememberStart
import com.patrykandpatrick.vico.compose.cartesian.layer.rememberLine
import com.patrykandpatrick.vico.compose.cartesian.layer.rememberLineCartesianLayer
import com.patrykandpatrick.vico.compose.cartesian.rememberCartesianChart
import com.patrykandpatrick.vico.compose.cartesian.rememberVicoZoomState
import com.patrykandpatrick.vico.compose.common.ProvideVicoTheme
import com.patrykandpatrick.vico.compose.common.fill
import com.patrykandpatrick.vico.compose.m3.common.rememberM3VicoTheme
import com.patrykandpatrick.vico.core.cartesian.Zoom
import com.patrykandpatrick.vico.core.cartesian.axis.HorizontalAxis
import com.patrykandpatrick.vico.core.cartesian.axis.VerticalAxis
import com.patrykandpatrick.vico.core.cartesian.data.CartesianChartModelProducer
import com.patrykandpatrick.vico.core.cartesian.data.CartesianLayerRangeProvider
import com.patrykandpatrick.vico.core.cartesian.data.lineSeries
import com.patrykandpatrick.vico.core.cartesian.layer.LineCartesianLayer
import com.zell_mbc.medilog.R.string
import com.zell_mbc.medilog.base.ChartActivity.legendItem
import com.zell_mbc.medilog.base.rememberMarker
import com.zell_mbc.medilog.debug.DebugLog
import com.zell_mbc.medilog.preferences.SettingsActivity
import com.zell_mbc.medilog.support.checkThresholds
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import kotlin.getValue
import kotlin.text.toInt
/*
@Composable
fun WeightChartScreen: ChartScreen() {
    // Activities need to be self sufficient because MainActivity might get killed by OS
    val viewModel: WeightViewModel by viewModel()

    override val filename = "WeightChart.jpg"

    var showBodyFat = false
    private var upperThresholdLine = 0f
    private var lowerThresholdLine = 0f

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        // Not yet implemented
        showBodyFat = preferences.getBoolean(SettingsActivity.KEY_PREF_LOG_FAT, getString(string.LOG_FAT_DEFAULT).toBoolean())

        showLinearTrendline = preferences.getBoolean(SettingsActivity.KEY_PREF_SHOW_WEIGHT_LINEAR_TRENDLINE, false)
        showGrid = preferences.getBoolean(SettingsActivity.KEY_PREF_SHOW_WEIGHT_GRID, getString(string.SHOW_WEIGHT_GRID_DEFAULT).toBoolean())
        showLegend = preferences.getBoolean(SettingsActivity.KEY_PREF_SHOW_WEIGHT_LEGEND, getString(string.SHOW_WEIGHT_LEGEND_DEFAULT).toBoolean())
        showValues = preferences.getBoolean(SettingsActivity.KEY_PREF_WEIGHT_SHOW_VALUES, true)
        showBodyFat = preferences.getBoolean(SettingsActivity.KEY_PREF_LOG_FAT, getString(string.LOG_FAT_DEFAULT).toBoolean())
        showMovingAverage = preferences.getBoolean(SettingsActivity.KEY_PREF_WEIGHT_SHOW_MOVING_AVERAGE, false)
        showThreshold = preferences.getBoolean(SettingsActivity.KEY_PREF_SHOW_WEIGHT_THRESHOLD, getString(string.SHOW_WEIGHT_THRESHOLD_DEFAULT).toBoolean())
        if (showThreshold) {
            val s = "" + preferences.getString(SettingsActivity.KEY_PREF_WEIGHT_THRESHOLDS, "")
            val th = checkThresholds(this, s, getString(string.WEIGHT_THRESHOLD_DEFAULT), viewModel.value1.label)
            lowerThresholdLine = try { th[0].toFloat() } catch  (_: NumberFormatException) { 0f }
            upperThresholdLine = try { th[1].toFloat() } catch  (_: NumberFormatException) { 0f }
        }

        // For the charts only native entries can be considered, no matter what showAllTabs is set to
        val tmp = viewModel.blendInItems
        viewModel.blendInItems = false
        items = viewModel.getItems("ASC", filtered = true)
        viewModel.blendInItems = tmp

        if (items.size < 2) {
            Toast.makeText(this, getString(string.notEnoughDataForChart), Toast.LENGTH_LONG).show()
            finish()
            return // Needs return to avoid the rest to be executed because finish() may not kill the activity fast enough
        }

        if (!(showValues || showLinearTrendline || showMovingAverage)) {
            Toast.makeText(this, getString(string.noValuesActivated), Toast.LENGTH_LONG).show()
            finish()
            return // Needs return to avoid the rest to be executed because finish() may not kill the activity fast enough
        }
        // Collect list values and hold min/max values. Always use actual values, the trend lines won't be more extreme
        var fTmp: Float
        var i = 0
        for (item in items) {
            timestamps.add(i++)
            fTmp = try { item.value1.toFloat() } catch (_: NumberFormatException) { 0f }
            value1List.add(fTmp)
            if (fTmp > chartMax) chartMax = fTmp
            if (fTmp < chartMin) chartMin = fTmp

            if (showBodyFat){
                fTmp = try { item.value2.toFloat() } catch (_: NumberFormatException) { 0f }
                value2List.add(fTmp)
                if (fTmp < chartMin) chartMin = fTmp
            }
        }
        // Add a bit of top and bottom filling
        //chartMin = ((chartMin.toInt()).toFloat())-5
        //chartMax += 5


        xAxisOffset = items[0].timestamp
        if (showValues) {
            legendList.add(legendItem(label = viewModel.value1.label, color = lineColor1))
            if (showBodyFat) legendList.add(legendItem(label = getString(string.bodyFat), color = lineColor2))

            value1Map = items.associateBy({ scaledTimeStamp(it.timestamp) }, { try { it.value1.toFloat() } catch (_: NumberFormatException) { 0f } })
            if (showBodyFat) value2Map = items.associateBy({ scaledTimeStamp(it.timestamp) }, { try { it.value2.toFloat() } catch (_: NumberFormatException) { 0F } })
        }

        // Compile moving average values
        if (showMovingAverage) {
            legendList.add(legendItem(label = getString(string.showMovingAverage), color = movingAverageColor))
            val p = preferences.getString(SettingsActivity.KEY_PREF_WEIGHT_MOVING_AVERAGE_SIZE, "6")
            if (p != null) {
                val period = try { p.toInt() } catch (_: NumberFormatException) { 0 }
                movingAverageValue1List = getMovingAverageFloat(value1List, period)
                var ii = 0
                movingAverageValue1Map = items.associateBy({ scaledTimeStamp(it.timestamp) }, { try { movingAverageValue1List[ii++] } catch (_: NumberFormatException) { 0F }})
            }
        }
        // Compile linear trendline values
        if (showLinearTrendline) {
            legendList.add(legendItem(label = getString(string.showLinearTrendline), color = lineColor3))
            linearTrendlineValue1List = getLinearTrendlineFloat(value1List)
            var ii = 0
            linearTrendlineValue1Map = items.associateBy({ scaledTimeStamp(it.timestamp) }, { try { linearTrendlineValue1List[ii++] } catch (_: NumberFormatException) { 0F } })
        }

        showContent()
    }

    @Composable
    override fun ShowContent() {
        Box(Modifier.safeDrawingPadding()) {
            val modelProducer = remember { CartesianChartModelProducer() }
            LaunchedEffect(Unit) {
                withContext(Dispatchers.Default) {
                    modelProducer.runTransaction {
                        lineSeries {
                            if (showValues) {
                                value1Map?.let { series(it.keys, it.values) }
                                value2Map?.let { series(it.keys, it.values) }
                                value3Map?.let { series(it.keys, it.values) }
                            }
                            if (showMovingAverage) {
                                movingAverageValue1Map?.let { series(it.keys, it.values) }
                                movingAverageValue2Map?.let { series(it.keys, it.values) }
                                movingAverageValue3Map?.let { series(it.keys, it.values) }
                            }
                            if (showLinearTrendline) {
                                linearTrendlineValue1Map?.let { series(it.keys, it.values) }
                                linearTrendlineValue2Map?.let { series(it.keys, it.values) }
                                linearTrendlineValue3Map?.let { series(it.keys, it.values) }
                            }
                        }
                    }
                }
            }
            ProvideVicoTheme(rememberM3VicoTheme()) { ComposeChart(modelProducer, Modifier.fillMaxHeight()) }
        }
    }

    @Composable
    private fun ComposeChart(modelProducer: CartesianChartModelProducer, modifier: Modifier) {
        val lineProvider = LineCartesianLayer.LineProvider.series(
            buildList {
                if (showValues) add(LineCartesianLayer.rememberLine(areaFill = LineCartesianLayer.AreaFill.single(fill = fill(fillColor1)), fill = LineCartesianLayer.LineFill.single(fill = fill(lineColor1))))
                if (showMovingAverage) add(LineCartesianLayer.rememberLine(fill = LineCartesianLayer.LineFill.single(fill(movingAverageColor)), areaFill = null))
                if (showLinearTrendline) add(LineCartesianLayer.rememberLine(stroke = linearTrendLineStroke, fill = LineCartesianLayer.LineFill.single(fill(linearTrendlineColor)), areaFill = null))
            }
        )
        val span = chartMax - chartMin
        val step = findNiceStep(span.toDouble())
        val start = determineYAxisStart(chartMin)
        DebugLog.add("Max: $chartMax")
        DebugLog.add("Min $chartMin")
        DebugLog.add("Span: $span")
        DebugLog.add("Step: $step")
        DebugLog.add("Start: $start")

        CartesianChartHost(
            chart = rememberCartesianChart(
                rememberLineCartesianLayer(lineProvider = lineProvider, rangeProvider = CartesianLayerRangeProvider.fixed(minY = start.toDouble(), maxY = chartMax.toDouble())),
                startAxis =  VerticalAxis.rememberStart(
                    guideline = guideline(), // horizontal lines
                    itemPlacer = remember { VerticalAxis.ItemPlacer.step(step = { step }, shiftTopLines = false) }
                ),
                bottomAxis = HorizontalAxis.rememberBottom(
                    guideline = guideline(), // vertical lines
                    valueFormatter = bottomAxisValueFormatter, // Convert values back to proper dates
                ),
                legend = if (showLegend) rememberLegend() else null,
                decorations = if (showThreshold) listOf(helperLine("", upperThresholdLine.toDouble(), lineColor1), helperLine("", lowerThresholdLine.toDouble(), lineColor1)) else listOf(),
                marker = rememberMarker(),
            ),
            modelProducer = modelProducer,
            modifier = modifier,
            zoomState = rememberVicoZoomState(zoomEnabled = true, maxZoom = Zoom.max(Zoom.fixed(100f), Zoom.Content), initialZoom = Zoom.min(Zoom.fixed(), Zoom.Content)),
        )
    }
}
*/