/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.support

import android.content.Context
import android.text.InputFilter
import android.text.Spanned
import android.widget.Toast
import com.zell_mbc.medilog.R

// Filter class to handle input of custom templates in preferences
class TemplateInputFilter(val context: Context?): InputFilter {
    private val filterString = "0.,"

    override fun filter(source: CharSequence, start: Int, end: Int, dest: Spanned, dstart: Int, dend: Int): CharSequence? {
        try {
            if (filterString.indexOf(source.toString()) >= 0) return null
            else Toast.makeText(context, context?.getString(R.string.allowedInput) + " $filterString", Toast.LENGTH_LONG).show()
        } catch (_: NumberFormatException) { return "" }  // Define abstract function
        return ""
    }
}

