/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.preferences

import android.content.SharedPreferences
import android.os.Bundle
import androidx.core.content.ContextCompat
import androidx.preference.Preference
import androidx.preference.PreferenceFragmentCompat
import com.zell_mbc.medilog.R
import com.zell_mbc.medilog.preferences.SettingsActivity.Companion.KEY_PREF_TEMPERATURE_CUSTOM_ICON
import com.zell_mbc.medilog.support.getAllTabMeta
import com.zell_mbc.medilog.support.loadEnabledTabs


class SettingsFragment : PreferenceFragmentCompat() {
     override fun onCreatePreferences(savedInstanceState: Bundle?, rootKey: String?) {
        setPreferencesFromResource(R.xml.preferences, rootKey)

         // Hide unused tabs and reset title in case a custom title is used
         val allTabMeta = getAllTabMeta(requireContext())
         val prefs: SharedPreferences? = preferenceManager.sharedPreferences
         val enabledTabs = loadEnabledTabs(prefs)

         // All available tabs are defined in preferences.xml, the code here hides the ones which are not active
         for (tab in allTabMeta) {
             //val id = tab.id.toString()
             val pref: Preference? = preferenceManager.findPreference("id_${tab.key}") // Key id's are "id_1, etc. in xml
             pref?.isVisible = enabledTabs.contains(tab.key)
             pref?.title = tab.value
         }

         // Map preference keys to dynamic icons
         val dynamicIcons = mapOf(
             "id_1" to R.drawable.ic_weight_filled,
             "id_2" to R.drawable.ic_bloodpressure,
             "id_3" to R.drawable.ic_diary_outlined,
             "id_4" to R.drawable.ic_fluid,
             "id_5" to R.drawable.ic_glucose,
             "id_6" to (prefs?.getInt(KEY_PREF_TEMPERATURE_CUSTOM_ICON,R.drawable.ic_outline_device_thermostat_24) ?: R.drawable.ic_outline_device_thermostat_24),
             "id_7" to R.drawable.ic_spo2_outlined
         )

         dynamicIcons.forEach { (key, iconRes) ->
             findPreference<Preference>(key)?.icon = ContextCompat.getDrawable(requireContext(), iconRes)
         }
     }
}