/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.preferences

import android.content.Context
import android.widget.GridLayout
import android.widget.ImageView
import androidx.appcompat.app.AlertDialog
import androidx.core.content.ContextCompat
import androidx.core.view.setPadding
import androidx.preference.Preference
import com.zell_mbc.medilog.R

fun setupIconPicker(preference: Preference, context: Context, titleRes: Int = R.string.selectTabIcon) {
    val icons = listOf(
        R.drawable.ic_weight_outlined,
        R.drawable.ic_blood_pressure_outlined,
        R.drawable.ic_diary_outlined,
        R.drawable.ic_fluid,
        R.drawable.ic_outline_device_thermostat_24,
        R.drawable.ic_glucose_outlined,
        R.drawable.ic_baseline_attach_file_24,
        R.drawable.ic_baseline_call_made_24,
        R.drawable.ic_health_metrics_24px,
        R.drawable.ic_self_improvement_24px,
        R.drawable.ic_pregnancy_24px,
        R.drawable.ic_height_24px,
        R.drawable.ic_chart_data_24px,
        R.drawable.ic_healing_24px,
        R.drawable.ic_gastroenterology_24px,
        R.drawable.ic_fluid_med_24px,
        R.drawable.ic_ecg_heart_24px,
        R.drawable.ic_ecg_24px,
        R.drawable.ic_dentistry_24px,
        R.drawable.ic_coronavirus_24px,
        R.drawable.ic_chronic_24px,
        R.drawable.ic_body_fat_24px,
        R.drawable.ic_bloodtype_24px,
        R.drawable.ic_admin_meds_24px,
        R.drawable.ic_menstrual_health_24px,
        R.drawable.ic_home_health_24px
    )

    val sharedPrefs = preference.sharedPreferences
    val currentIcon = sharedPrefs?.getInt(preference.key, icons.firstOrNull() ?: 0)

    preference.setOnPreferenceClickListener { pref ->
        // GridLayout for icon selection
        val grid = GridLayout(context).apply {
            columnCount = 10
            setPadding(16, 16, 16, 16)
        }

        lateinit var dialog: AlertDialog

        icons.forEach { resId ->
            val image = ImageView(context).apply {
                setImageResource(resId)
                setPadding(16)
                adjustViewBounds = true
                maxWidth = 120
                maxHeight = 120
                // Optionally highlight current icon
                // if (resId == currentIcon) {
                //     setBackgroundResource(R.drawable.icon_selected_background)
                // }
                setOnClickListener {
                    sharedPrefs?.edit()?.putInt(pref.key, resId)?.apply()
                    pref.icon = ContextCompat.getDrawable(context, resId)
                    dialog.dismiss()
                }
            }
            grid.addView(image)
        }

        dialog = AlertDialog.Builder(context)
            .setTitle(titleRes)
            .setView(grid)
            .create()

        dialog.show()
        true
    }
}