/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.fluid

import android.os.Bundle
import android.widget.Toast
import androidx.activity.compose.setContent
import androidx.activity.viewModels
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.safeDrawingPadding
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.foundation.verticalScroll
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.unit.dp
import com.zell_mbc.medilog.R
import com.zell_mbc.medilog.base.InfoActivity
import com.zell_mbc.medilog.preferences.SettingsActivity
import androidx.core.graphics.toColorInt
import com.zell_mbc.medilog.tags.TagsViewModel
import kotlin.getValue

class FluidInfoActivity: InfoActivity() {
    // Activities need to be self sufficient because MainActivity might get killed by OS
    val viewModel: FluidViewModel by viewModels()
    val tagsViewModel: TagsViewModel by viewModels()

    private val textArray = mutableListOf<String>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState) // View Model needs to be initilalised before super is called
        supportActionBar?.setIcon(R.drawable.ic_fluid)

        viewModel.loadFilter()
        itemUnit = " " + preferences.getString(SettingsActivity.KEY_PREF_FLUID_UNIT, getString(R.string.FLUID_UNIT_DEFAULT))

        collectData(this, viewModel, tagsViewModel, textArray, itemUnit)
        setContent { StartCompose() }
    }

    @Composable
    override fun ShowContent() {
        Surface(shape = RoundedCornerShape(8.dp), modifier = Modifier.safeDrawingPadding().fillMaxWidth()) {
            Column(modifier = Modifier.verticalScroll(rememberScrollState()).padding(8.dp)) {
                Text("")
                for (i in 0..2)
                    Text(textArray[i], modifier = Modifier.padding(start = leftPadding.dp), color = MaterialTheme.colorScheme.primary)

                var textColor = MaterialTheme.colorScheme.primary
                var backgroundColor = MaterialTheme.colorScheme.background

                if (textArray.size > 3) { // Include tag information
                    Text("")
                    HorizontalDivider(thickness = 1.dp, color = MaterialTheme.colorScheme.secondary)
                    Text("")
                    Text(textArray[3], modifier = Modifier.padding(start = leftPadding.dp), color = MaterialTheme.colorScheme.primary)

                    for (i in 4..textArray.size - 1) {
                        val data = try {
                            textArray[i].split('|')
                        }
                        catch (_: Exception) {
                            "Error|in array".split('|')
                        }
                        val colorString = data[1]
                        backgroundColor = if (colorString.isNotEmpty()) try { Color(colorString.toColorInt()) } catch (_: Exception) { MaterialTheme.colorScheme.background }
                        else MaterialTheme.colorScheme.background
                        if (backgroundColor != MaterialTheme.colorScheme.background) textColor = MaterialTheme.colorScheme.inversePrimary
                        //val textColor = if (MainActivity.isDarkThemeOn(application) && backgroundColor != MaterialTheme.colorScheme.background) MaterialTheme.colorScheme.onPrimary else MaterialTheme.colorScheme.primary
                        Row(modifier = Modifier.padding(start = leftPadding.dp).background(color = backgroundColor)) {
                            Text(text = data[0], color = textColor, fontStyle = FontStyle.Italic)
                        }
                    }
                }
            }
        }
    }
}
