/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.fluid

import android.app.Activity
import android.widget.Toast
import com.zell_mbc.medilog.Tabs.FLUID
import com.zell_mbc.medilog.MainActivity.Companion.decimalSeparator
import com.zell_mbc.medilog.MainActivity.Companion.modifyDecimalSeparator
import com.zell_mbc.medilog.R
import com.zell_mbc.medilog.data.Data
import com.zell_mbc.medilog.data.DataViewModel
import com.zell_mbc.medilog.tags.TagsViewModel
import java.text.DateFormat

fun collectData(app: Activity, viewModel: FluidViewModel, tagsViewModel: TagsViewModel, textArray: MutableList<String>, itemUnit: String) {
    var avgString = ""
    var minMaxString = ""
    val dateFormat: DateFormat = DateFormat.getDateInstance(DateFormat.SHORT)

    textArray.clear()

    val count = viewModel.getSize(true)
    var item: Data? = viewModel.getFirst(true)
    if (item == null) {
        Toast.makeText(app, app.getString(R.string.noDataToShow), Toast.LENGTH_LONG).show()
        return
    }
    val startDate = dateFormat.format(item.timestamp)

    item = viewModel.getLast(true)
    if (item == null) {
        Toast.makeText(app, app.getString(R.string.noDataToShow), Toast.LENGTH_LONG).show()
        return
    }
    val endDate = dateFormat.format(item.timestamp)

    val txt = if (viewModel.filterActive()) app.getString(R.string.measurementsInFilter) else app.getString(R.string.measurementsInDB)
    textArray.add("$txt $count")
    textArray.add(app.getString(R.string.timePeriod) + " $startDate - $endDate")

    val avg = viewModel.getAvgInt("value1", true)
    val tmp = avg.toString()
    avgString = app.getString(R.string.average) + ": $tmp$itemUnit"

    val min = viewModel.getMinValue1(true).toInt()
    val max = viewModel.getMaxValue1(true).toInt()
    minMaxString = app.getString(R.string.minMaxValues) + " $min - $max$itemUnit"
    if (modifyDecimalSeparator) minMaxString = minMaxString.replace('.', decimalSeparator)
    textArray.add(minMaxString)

    //var tagCount = tagsViewModel.count(FLUID).toInt()
    if (tagsViewModel.count(FLUID).toInt() > 0) {
        //textArray.add("")
        textArray.add(app.getString(R.string.tags) + ":")
        var tagCount = viewModel.tagCount(tagId = 0, filtered = true)
        textArray.add("- No tag: $tagCount|")

        for (tag in tagsViewModel.getTagList(FLUID)) {
            tagCount = viewModel.tagCount(tagId = tag._id, filtered = true)
            textArray.add("- " + app.getString(R.string.tag) + tag.tag + ": $tagCount|${tag.color}")
        }
    }
}