/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

package com.zell_mbc.medilog.data

import android.content.Context
import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey

@Entity(tableName = "data", indices = [Index(value = ["timestamp"]), Index(value = ["type"]), Index(value = ["profile_id"])])
data class Data(
    @PrimaryKey(autoGenerate = true) val _id: Int,
    var timestamp: Long,
    var comment: String = "",
    var type: Int,
    var value1: String = "",
    var value2: String = "",
    var value3: String = "",
    var value4: String = "",
    var attachment: String,
    var profile_id: Int,
    var category_id: Int, // Drop!
    var tags: String = ""
)

// Per user data and settings
@Entity(tableName = "profiles", indices = [Index(value = ["_id"])])
data class Profiles(
    @PrimaryKey(autoGenerate = true) var _id: Int,
    var name: String  = "",
    var description: String = ""
)

//@Entity(tableName = "settings", indices = [Index(value = ["_id","profile_id", "_key" ], unique = true)])
@Entity(tableName = "settings", indices = [Index(value = ["profile_id"]), Index(value = ["_key"])])
data class Settings(
    @PrimaryKey(autoGenerate = true) var _id: Long,
    var profile_id: Int,
    var _key: String,
    var value: String
)

@Entity(tableName = "texttemplates", indices = [Index(value = ["type"])])
data class TextTemplates(
    @PrimaryKey(autoGenerate = true) var _id: Int,
    var type: Int,
    var template: String
)

@Entity(tableName = "tags", indices = [Index(value = ["type"])])
data class Tags(
    @PrimaryKey(autoGenerate = true) var _id: Int,
    var type: Int,
    var tag: String,
    var color: String
)

// Sort in ascending or descending order
enum class Order {
    ASC,
    DESC
}

fun getTableColumnNames(tableName: String, context: Context): List<String> {
    val rv = arrayListOf<String>()
    val csr = MediLogDB.getDatabase(context).query("SELECT name FROM pragma_table_info('${tableName}')", emptyArray())
    while (csr.moveToNext()) {
        rv.add(csr.getString(0))
    }
    csr.close()
    return rv.toList()
}
