import androidx.room.Room
import androidx.test.core.app.ApplicationProvider
import com.zell_mbc.medilog.data.MediLogDB
import com.zell_mbc.medilog.data.Tags
import com.zell_mbc.medilog.tags.TagsDao
import com.zell_mbc.medilog.tags.TagsViewModel
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.runBlocking
import org.junit.After
import org.junit.Before
import org.junit.Test
import org.junit.Assert.*

class TagsTest {
    private lateinit var dao_rw: TagsDao
    private lateinit var dao_ro: TagsDao
    private lateinit var db_rw: MediLogDB
    private lateinit var db_ro: MediLogDB
    private lateinit var vm: TagsViewModel

    @Before
    fun createDb() {
        //MediLogDB.TEST_MODE = true
        db_rw = Room.inMemoryDatabaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java).build()
        db_ro = Room.databaseBuilder(ApplicationProvider.getApplicationContext(), MediLogDB::class.java, "MediLogDatabase").build()
        dao_rw = db_rw.TagsDao()
        dao_ro = db_ro.TagsDao()
        vm = TagsViewModel(ApplicationProvider.getApplicationContext())
    }

    @After
    fun closeDb() {
        db_rw.close()
        db_ro.close()
    }

    @Test
    fun insertEntry_andGetAllEntries() {
        val item = Tags(_id = 1, tag = "Test Entry", type = 1, color = "#000000")
        var allEntries: List<Tags> = emptyList()
        runBlocking {
                dao_rw.upsert(item)
                allEntries = dao_rw.getAllRecords().first()
        }

        // Assert: Check if the inserted tag is in the list
        assertTrue(allEntries.contains(item))
    }

    @Test
    fun getEntryById() {
        var retrievedEntry: Tags? = null

        // Act: Get the entry by ID
        runBlocking {
            retrievedEntry = dao_rw.getItem(-1)
        }
        // Assert: Check if the retrieved entry is the same
        assertNull(retrievedEntry)
        assertEquals(null,retrievedEntry)
    }

    @Test
    fun insertAndGetEntryById() {
        // Arrange: Create a tag and insert it
        val item = Tags(_id = 1, tag = "Test Entry", type = 1, color = "#000000")
        var retrievedEntry: Tags? = null

        // Act: Get the entry by ID
        runBlocking {
                dao_rw.upsert(item)
                retrievedEntry = dao_rw.getItem(item._id)
        }
        // Assert: Check if the retrieved entry is the same
        assertNotNull(retrievedEntry)
        assertEquals(item,retrievedEntry)
    }

    @Test
    fun convert_to_CSV() {
        var allEntries: List<Tags> = emptyList()
        runBlocking { allEntries = dao_ro.getAllRecords().first() }

        // Assert: Check if the inserted tag is in the list
        val lines = vm.dataToCSV(allEntries)
        val listCount = allEntries.count() + 1 // +1 because of header
        val csvCount = lines.lines().count()
        assertEquals(listCount, csvCount)
    }

}