import android.content.Context
import android.content.SharedPreferences
import androidx.test.core.app.ApplicationProvider
import org.junit.Assert.*
import org.junit.Before
import org.junit.Test

class CrashFlagTest {

    private lateinit var context: Context
    private lateinit var preferences: SharedPreferences

    @Before
    fun setup() {
        context = ApplicationProvider.getApplicationContext()
        preferences = context.getSharedPreferences("crash_prefs", Context.MODE_PRIVATE)

        // Simulate a crash by setting crash_count
        preferences.edit().putInt("crash_count", 1).apply()
    }

    @Test
    fun testCrashFlagPersistsAndResets() {
        val crashedLastTime = preferences.getInt("crash_count", 0)

        assertTrue("Crash flag should be greater than 0", crashedLastTime > 0)

        // Simulate clearing the crash flag after normal shutdown
        preferences.edit().putInt("crash_count", 0).apply()

        val clearedFlag = preferences.getInt("crash_count", -1)
        assertEquals("Crash flag should be reset to 0", 0, clearedFlag)
    }
}
