# MediLog
[<img src="./ic_launcher-source.png" alt="MediLog Logo" height="80">](./ic_launcher-source.png)

[![Status: Active](./badges/status.svg)](#)
[![Status: Active](./badges/release.svg)](#)
[![API Reference](./badges/license.svg)](./LICENSE)

Android App to easily capture medical data. The following values are supported at present:

- Blood Pressure
- Weight
- Glucose
- Oximetry
- Temperature
- Water intake
- A Diary
- Documents

Additional values can be supported through modifying the Temperature tab

## Key features

The main goal of _MediLog_ is to allow the manual capturing of medical data, basically replacing pen and paper. And to do this as quickly as possible. This means supporting smart devices is not on my roadmap.

Also, I don't plan to cover the whole universe of medical data, but rather provide a solution for types of data which have to be entered often and cases where the alternatives either don't respect privacy, are full of trackers or simply too complicated. E.g.

For example:
- Blood Pressure values and Weight might get captured multiple times a day and are a good fit for _MediLog_, therefore there's a dedicated tab for these values.
- PSA values get captured once or twice a year, which means a dedicated tab would be too complicated, I'd recommend storing these in _MediLog_'s Diary tab. Search will allow to retrieve such values whenever required.


Guiding principles for _MediLog_ are:

- Be simple. Allow to capture data as quickly as possible, don't get in the way. If you can think of ways to improve the UI, let me know.
- Be open. Export and import format is a simple CSV, if you can export CSV from your existing application it should be fairly easy to import into _MediLog_, and of course, import into your new application if you ever wish to move on with your data
- Be secure. PDF reports and ZIP file backups are password protected, the database is encrypted
- Be transparent. No data transfers to anyone but the one you choose. No hidden telemetry, no automatic crash logs, etc.
- In essence, offer appropriate measures to protect your data as defined by art. 9 GDPR, Processing of special categories of personal data


[![Awesome Humane Tech](https://raw.githubusercontent.com/humanetech-community/awesome-humane-tech/main/humane-tech-badge.svg?sanitize=true)](https://delightful.club/delightful-humane-design/#health)

### Installation


Download and install _MediLog_ from here https://codeberg.org/toz/_MediLog_/releases or ...

<p float="left">
  <a href="https://apt.izzysoft.de/packages/com.zell_mbc.medilog">
    <img alt="Get it on IzzyOnDroid" src="badges/IzzyOnDroidButton.png" height="80">
  </a>
  <a href="https://f-droid.org/packages/com.zell_mbc.medilog.fdroid/">
    <img alt="Get it on F-Droid" src="badges/f-droid.png" height="80">
  </a>
  <a href="https://play.google.com/store/apps/details?id=com.zell_mbc.medilog.play">
    <img alt="Get it on GooglePlay" src="badges/google-play.png" height="80">
  </a>

</p>


#### Flavours
_MediLog_ is available in 3 flavours:
- **FOSS**, com.zell_mbc.medilog: The original flavour of _MediLog_ distributed by 
  - IzzyOnDroid with my signature, each release checked for reproducibility by IzzyOnDroid
  - F-Droid with F-Droids signature and therefore not reproducible
- **FDroid**, com.zell_mbc.medilog.fdroid: Distributed by F-Droid as well. From a feature point of view identical to the above, but with my signature which allows F-Droid to verify reproducibility. If you use F-Droid, select this flavour!
- **Play**, com.zell_mbc.medilog.play: GooglePlay flavour, limited to 100 records, unlimited records via a small inApp purchase. GooglePlay is geared for closed source apps, hence the concept of reproducibility is not applicable

Check the _MediLog_ About dialog to see which flavour you are running.

More on reproducible builds here: https://codeberg.org/toz/_MediLog_/wiki/Reproducible-Builds

**Important note:** Be careful when downloading _MediLog_ from different locations. The flavours are treated like independent applications by Android. Use backup/restore if you want to move from one flavour to another.

### Removal
Like with all Android applications, via a long click on the app icon.


**Uninstalling the application will delete all data! Unrecoverable! Make sure you backup your data first!**

### User manual
Can be found here: https://codeberg.org/toz/_MediLog_/wiki/?action=_pages

I know it's missing lots of sections, feel free to contribute.


## Privacy Policy

#### Stored data
Data entered by the user is stored inside an encrypted SQLite database.

**To keep the input process as simple and fast as possible, the app/your data is not protected with an additional password. If your device has support for Biometric (Fingerprint) make sure to enable it. Otherwise, if someone is able to unlock your device they can access your health data!**

The app supports storing backups in encrypted ZIP files. Make use of it by adding a password whenever you create a file or setting a default one in the settings dialog. Don't forget to test (and remember) the password.
The app allows to send password protected files so you can share over unprotected media (eg. email) reducing the risk of your data getting in the wrong hands.


#### Required permissions

- WRITE_EXTERNAL_STORAGE : Required to export backup files
- READ_EXTERNAL_STORAGE: Required to import backup files
- USE_BIOMETRIC: Required to enable biometric logon protection
- INTERNET: Required for automated and ad-hoc feedback

#### Tracking
No advertising, no hidden tracking!
You can however let me know which tabs you use via the *user feedback* function, which I would appreciate because it's the only way for me to know if I focus my time and efforts on areas which are actually used by people out there.
As of version 3.0 there is also the possibility to send crash logs to the developers in case of application crashes. However, crash logs will never be sent without your explicit approval. See here for more details: https://codeberg.org/toz/_MediLog_/wiki/Crash-logs

#### Flavours
_MediLog_ is available in 3 flavours:
- com.zell_mbc.medilog: The original flavour of _MediLog_ distributed by 
  - IzzyOnDroid with my signature (each release checked for reproducibility by IzzyOnDroid) 
  - F-Droid with F-Droids signature and therefore not reproducible
- com.zell_mbc.medilog.fdroid: A recent flavour distributed by F-Droid as well. From a feature point of view identicial to the above, but with my signature which allos F-Droid to verify reproducibility. If you start with _MediLog_ from F-Droid, uses this build!
- com.zell_mbc.medilog.play: GooglePlay build, limited to 100 records, unlimited records via a small inApp purchase

#### Libraries
3rd party libraries in use are the below:

- [Vico](https://patrykandpatrick.com/vico/wiki/): Most of the charts,
- [Calendar](https://github.com/kizitonwose/Calendar): Diary heatmap chart
- [Zip4J](https://github.com/srikanth-lingala/zip4j): Enable password protected ZIP files
- [SQLCipher](https://www.zetetic.net/sqlcipher/): Encrypt the SQLite database
- [ACRA](https://www.acra.ch/): Enable crash logs

## Contact & Bug reporting

Please use the issue tracker at [codeberg.org](https://codeberg.org/toz/_MediLog_/issues) for reporting issues and/or suggestions:

Other means to contact the developer are:
- Matrix: medilog:matrix.org
- Fediverse: Akkoma/Mastodon/Pleroma/etc., @medilog@social.zell-mbc.com
- eMail: medilog@zell-mbc.com

## Translations
The number of translations is growing quickly. If your language isn't covered yet please contact me. I'll have a first go in translating via AI, to hopefully save you a lot of work.

Translation platform: https://translate.codeberg.org/projects/medilog/

[<img src="https://translate.codeberg.org/widgets/medilog/-/multi-blue.svg">](https://translate.codeberg.org/engage/medilog/)


## Donations

If you find _MediLog_ useful and want to support its development, you can contribute in several ways:

💶 Bank Transfer (SEPA):

<img src="app/src/main/res/drawable/ic_sepa_qr_medilog.png" alt="SEPA QR Code" width="260">

**Account details**

- **IBAN:** `DE04 5001 0517 0098 7035 40`  
- **BIC:** `INGDDEFFXXX`  
- **Account holder:** Thomas Zell

You can scan the QR code above with your banking app to start a pre-filled transfer.

🌐 Online Donation Options:


If you prefer online services, you can donate via:

[<img src="https://liberapay.com/assets/widgets/donate.svg" alt="Donate using Liberapay" height="28">](https://liberapay.com/_MediLog_/donate)
[<img src="https://www.paypalobjects.com/webstatic/de_DE/i/de-pp-logo-100px.png" alt="PayPal Logo" height="28">](https://www.paypal.com/paypalme/thomaszellmbc)
[<img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/c5/Bitcoin_logo.svg/252px-Bitcoin_logo.svg.png" alt="Bitcoin Logo" height="28">](https://live.blockcypher.com/btc/address/1EUrRpjDAGgpS8J46tmsVWKbgNqAv7rWC7/)

---

## Screenshots
<p float="left">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/Weight.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/WeightChart.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/WeightInfo.png" width="400" />
</p>
<p float="left">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/BloodPressure.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/BloodPressureChart.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/BloodPressureInfo.png" width="400" />
</p>
<p float="left">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/Diary.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/DiaryEdit.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/DiaryChart.png" width="400" />
</p>
<p float="left">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/PDFReport.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/Settings.png" width="400" />
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/About.png" width="400" />
</p>

## Changelog
[Change log](ChangeLog.md)

**Icon credits:**
[Disclaimer icons created by Uniconlabs - Flaticon](https://www.flaticon.com/free-icons/disclaimer)

[Restore icons created by Uniconlabs - Flaticon](https://www.flaticon.com/free-icons/restore)

[Medical report icons created by Freepik - Flaticon](https://www.flaticon.com/free-icons/medical-report)

