/*
 *     This file is part of MediLog.
 *
 *     MediLog is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU Affero General Public License as published by
 *     the Free Software Foundation.
 *
 *     MediLog is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU Affero General Public License for more details.
 *
 *     You should have received a copy of the GNU Affero General Public License
 *     along with MediLog.  If not, see <http://www.gnu.org/licenses/>.
 *
 *     Copyright (c) 2018 - 2025 by Zell-MBC.com
 */

/*
 */

package com.zell_mbc.medilog.preferences

import android.content.SharedPreferences
import android.os.Bundle
import android.text.InputFilter
import android.text.Spanned
import android.widget.Toast
import androidx.preference.EditTextPreference
import androidx.preference.ListPreference
import androidx.preference.Preference
import androidx.preference.PreferenceFragmentCompat
import androidx.preference.PreferenceManager
import com.zell_mbc.medilog.MainActivity
import com.zell_mbc.medilog.R
import com.zell_mbc.medilog.preferences.SettingsActivity.Companion.KEY_PREF_GLUCOSE_CUSTOM_TEMPLATE
import com.zell_mbc.medilog.preferences.SettingsActivity.Companion.KEY_PREF_WEIGHT_CUSTOM_TEMPLATE
import com.zell_mbc.medilog.support.TemplateInputFilter

class GlucoseSettingsFragment : PreferenceFragmentCompat() {
    override fun onCreatePreferences(savedInstanceState: Bundle?, rootKey: String?) {
        setPreferencesFromResource(R.xml.glucose_preferences, rootKey)

        val paperSize = preferenceManager.findPreference<ListPreference>(SettingsActivity.KEY_PREF_GLUCOSE_PAPER_SIZE)
        paperSize?.summary = requireContext().getString(R.string.paperSizeSummary) + ", " + paperSize.value
        paperSize?.onPreferenceChangeListener = Preference.OnPreferenceChangeListener { _, newValue ->
            val tmpString = paperSize.summary.toString()
            paperSize.summary = tmpString.replace(paperSize.value.toString(), newValue.toString())
            true
        }

        val thresholdObject = preferenceManager.findPreference<EditTextPreference>(SettingsActivity.KEY_PREF_GLUCOSE_THRESHOLDS)
        var thresholds = ""
        if (thresholdObject != null) {
            val preferences: SharedPreferences = PreferenceManager.getDefaultSharedPreferences(requireContext())
            val mg_dl = (preferences.getString(SettingsActivity.KEY_PREF_GLUCOSE_UNIT, requireContext().getString(R.string.GLUCOSE_UNIT_MG_DL)) == requireContext().getString(R.string.GLUCOSE_UNIT_MG_DL))
            if (thresholdObject.text.isNullOrEmpty()) {
                thresholds = if (mg_dl) requireContext().getString(R.string.GLUCOSE_THRESHOLDS_DEFAULT_MG_DL) else requireContext().getString(R.string.GLUCOSE_THRESHOLDS_DEFAULT_MMOL_L)
                thresholdObject.text = thresholds
            } else thresholds = "" + thresholdObject.text
            //val default = getString(R.string.defaultValue) + ": " + if (mg_dl) getString(R.string.GLUCOSE_THRESHOLDS_DEFAULT_MG_DL) else getString(R.string.GLUCOSE_THRESHOLDS_DEFAULT_MMOL_L)
            thresholdObject.summary = requireContext().getString(R.string.thresholdSummaryRange) + ": $thresholds"

            thresholdObject.onPreferenceChangeListener = Preference.OnPreferenceChangeListener { _, newValue ->
                val tmpString = thresholdObject.summary.toString()
                thresholdObject.summary = tmpString.replace(thresholdObject.text.toString(), newValue.toString())
                true
            }
        }

    val inputFormatObject = preferenceManager.findPreference<EditTextPreference>(KEY_PREF_GLUCOSE_CUSTOM_TEMPLATE)
    inputFormatObject?.setOnBindEditTextListener { editText ->
        val filterArray = arrayOfNulls<InputFilter>(2)
        filterArray[0] = InputFilter.LengthFilter(7)
        filterArray[1] = TemplateInputFilter(context)
        editText.filters = filterArray
    }
}

override fun onPause() {
    super.onPause()
    MainActivity.resetReAuthenticationTimer(requireContext())
}

}
