// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get app_name => 'Yubico 身份验证器';

  @override
  String get native_language_name => '简体中文';

  @override
  String s_translated(int percentage) {
    return '已翻译：$percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return '待校对：$percentage%';
  }

  @override
  String get l_incomplete_translation => '未完成的翻译';

  @override
  String get p_translation_progress_desc => '进度指标反映了翻译的成熟度。';

  @override
  String get s_community => '社区';

  @override
  String get l_localization_project => '本地化项目';

  @override
  String get s_save => '保存';

  @override
  String get s_cancel => '取消';

  @override
  String get s_close => '关闭';

  @override
  String get s_delete => '删除';

  @override
  String get s_move => '移动';

  @override
  String get s_quit => '退出';

  @override
  String get s_enable => '允许';

  @override
  String get s_enabled => '已启用';

  @override
  String get s_disabled => '已禁用';

  @override
  String get s_status => '状态';

  @override
  String get s_unlock => '解锁';

  @override
  String get s_calculate => '计算';

  @override
  String get s_import => '导入';

  @override
  String get s_overwrite => '覆写';

  @override
  String get s_done => '完成';

  @override
  String get s_success => '成功';

  @override
  String get s_loading => '加载中…';

  @override
  String get s_more => '更多';

  @override
  String get s_label => '标签';

  @override
  String get s_name => '名字';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => '选项';

  @override
  String get s_details => '详细信息';

  @override
  String get s_show_window => '显示窗口';

  @override
  String get s_hide_window => '隐藏窗口';

  @override
  String get s_show_navigation => '显示导航按钮';

  @override
  String get s_expand_navigation => '展开导航栏';

  @override
  String get s_collapse_navigation => '折叠导航栏';

  @override
  String get s_expand_collapse_navigation => '展开/折叠导航栏';

  @override
  String get s_show_menu => '显示菜单';

  @override
  String get s_toggle_menu_bar => '切换菜单栏';

  @override
  String get s_more_info => '更多信息';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => '关于';

  @override
  String get s_algorithm => '算法';

  @override
  String get s_appearance => '外观';

  @override
  String get s_actions => '操作';

  @override
  String get s_manage => '管理';

  @override
  String get s_setup => '设置';

  @override
  String get s_device => '设备';

  @override
  String get s_application => '应用程序';

  @override
  String get s_settings => '设置';

  @override
  String get s_reset_settings => '重置设置';

  @override
  String get l_reset_settings_desc => '恢复默认设置';

  @override
  String get q_reset_settings => '重置设置？';

  @override
  String get p_reset_settings_confirmation_desc => '这将重置所有设置为其默认值';

  @override
  String get s_support => '支持';

  @override
  String get s_certificates => '证书';

  @override
  String get s_security_key => '安全密钥';

  @override
  String get s_slots => '槽位';

  @override
  String get s_help_and_about => '关于及帮助';

  @override
  String get s_help => '帮助';

  @override
  String get s_app_information => '应用程序信息';

  @override
  String get s_home => '主页';

  @override
  String get s_user_guide => '用户指南';

  @override
  String get s_i_need_help => '寻求帮助';

  @override
  String get s_terms_of_use => '使用条款';

  @override
  String get s_privacy_policy => '隐私政策';

  @override
  String get s_open_src_licenses => '开源许可';

  @override
  String get s_please_wait => '请稍候…';

  @override
  String get s_secret_key => '密钥';

  @override
  String get s_show_secret_key => '显示密钥';

  @override
  String get s_hide_secret_key => '隐藏密钥';

  @override
  String get s_private_key => '私钥';

  @override
  String get s_public_key => '公钥';

  @override
  String get s_invalid_length => '长度无效';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return '格式无效，允许的字符： $characters';
  }

  @override
  String get l_invalid_keyboard_character => '所选键盘字符无效';

  @override
  String get s_require_touch => '需要触摸';

  @override
  String get q_have_account_info => '有账户信息吗？';

  @override
  String get s_debugging_tools => '调试工具';

  @override
  String get s_run_diagnostics => '运行诊断';

  @override
  String get l_run_diagnostics_desc => '运行诊断以解决问题';

  @override
  String get s_logging_level => '日志级别';

  @override
  String s_current_log_level(String level) {
    return '日志级别： $level';
  }

  @override
  String get s_character_count => '字符数';

  @override
  String get s_language => '语言';

  @override
  String get s_app_theme => '应用程序主题';

  @override
  String get s_system_default => '系统默认';

  @override
  String get s_light_mode => '亮色主题';

  @override
  String get s_dark_mode => '暗色主题';

  @override
  String get s_list_layout => '列表布局';

  @override
  String get s_grid_layout => '网格布局';

  @override
  String get s_mixed_layout => '混合布局';

  @override
  String get s_select_layout => '选择布局';

  @override
  String get s_select_to_scan => '选择以扫描';

  @override
  String get s_hide_reader => '隐藏读取器';

  @override
  String get s_show_hidden_readers => '显示隐藏的读取器';

  @override
  String get s_toggle_readers => '切换读取器';

  @override
  String get l_toggle_readers_desc => '显示或隐藏读取器';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return '序列号： $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return '固件版本： $version';
  }

  @override
  String get l_fips_capable => 'FIPS 兼容';

  @override
  String get l_fips_approved => 'FIPS 已认证';

  @override
  String get l_insert_yk => '插入您的 YubiKey';

  @override
  String get l_insert_or_tap_yk => '插入或轻触 YubiKey';

  @override
  String get l_unplug_yk => '拔出您的 YubiKey';

  @override
  String get l_reinsert_yk => '重新插入您的 YubiKey';

  @override
  String get l_place_on_nfc_reader => '请把您的 YubiKey 放在NFC读取器上';

  @override
  String get l_replace_yk_on_reader => '请把您的 YubiKey 放回读取器上';

  @override
  String get l_remove_yk_from_reader => '请从NFC读取器上取走您的 YubiKey';

  @override
  String get p_try_reinsert_yk => '尝试拔出并重新插入您的 Yubikey。';

  @override
  String get s_touch_required => '需要触摸';

  @override
  String get l_touch_button_now => '现在触摸 YubiKey 上的按钮';

  @override
  String get l_long_touch_button_now => '现在按住 YubiKey 上的按钮 10 秒钟';

  @override
  String get l_keep_touching_yk => '不断重复触摸 YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => '选择应用程序';

  @override
  String get s_toggle_interfaces => '切换接口';

  @override
  String get p_toggle_applications_desc => '在可用的使用方式上启用或禁用应用程序。';

  @override
  String get p_toggle_interfaces_desc => '启用或禁用 USB 接口。';

  @override
  String get l_toggle_applications_desc => '启用/禁用应用程序';

  @override
  String get l_toggle_interfaces_desc => '启用/禁用接口';

  @override
  String get s_reconfiguring_yk => '正在重新配置 YubiKey…';

  @override
  String get s_config_updated => '配置已更新';

  @override
  String get l_config_updated_reinsert => '配置已更新，拔出并重新插入您的 YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 已禁用';

  @override
  String get l_webauthn_req_fido2 => 'WebAuthn 要求您的 YubiKey 启用 FIDO2 应用程序';

  @override
  String get s_lock_code => '锁定密码';

  @override
  String get l_wrong_lock_code => '锁定密码错误';

  @override
  String get s_show_lock_code => '显示锁定密码';

  @override
  String get s_hide_lock_code => '隐藏锁定密码';

  @override
  String get p_lock_code_required_desc => '执行的操作需要输入配置锁定密码。';

  @override
  String get l_helper_not_responding => '帮助进程没有响应';

  @override
  String get l_yk_no_access => '此 YubiKey 无法访问';

  @override
  String get s_yk_inaccessible => '设备不可访问';

  @override
  String get l_open_connection_failed => '无法建立连接';

  @override
  String get l_ccid_connection_failed => '未能建立智能卡连接';

  @override
  String get p_ccid_service_unavailable => '请确保您的智能卡服务正常运行。';

  @override
  String get p_pcscd_unavailable => '请确认 pcscd 已安装并运行。';

  @override
  String get l_no_yk_present => '没有 YubiKey';

  @override
  String get s_unknown_type => '未知类型';

  @override
  String get s_unknown_device => '无法识别的设备';

  @override
  String get s_restricted_nfc => 'NFC 激活';

  @override
  String get l_deactivate_restricted_nfc => '如何激活 NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      '将 YubiKey 与任何 USB 电源（如电脑）连接至少 3 秒钟。\n\n接通电源后，NFC 将被激活并可随时使用。';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      '您的 YubiKey 具有 NFC 限制功能，该功能旨在防止运输过程中的无线接触使用。这意味着在您进行激活之前，NFC 功能将暂时禁用。';

  @override
  String get s_unsupported_yk => '不支持的 YubiKey';

  @override
  String get p_operation_failed_try_again => '操作失败，请重试。';

  @override
  String get l_configuration_unsupported => '配置不受支持';

  @override
  String get p_scp_unsupported =>
      '要通过 NFC 进行通信，YubiKey 需要本手机不支持的技术。请将 YubiKey 插入手机的 USB 端口。';

  @override
  String get l_error_occurred => '发生了一个错误';

  @override
  String get s_application_error => '应用程序错误';

  @override
  String get l_import_error => '导入出错';

  @override
  String get l_file_not_found => '未找到文件';

  @override
  String get l_file_too_big => '文件大小过大';

  @override
  String get l_filesystem_error => '文件系统操作错误';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => '设置 PIN';

  @override
  String get s_change_pin => '更改 PIN';

  @override
  String get s_change_puk => '更改 PUK';

  @override
  String get s_show_pin => '显示 PIN';

  @override
  String get s_hide_pin => '隐藏 PIN';

  @override
  String get s_show_puk => '显示 PUK';

  @override
  String get s_hide_puk => '隐藏 PUK';

  @override
  String get s_current_pin => '当前 PIN';

  @override
  String get s_current_puk => '当前 PUK';

  @override
  String get s_new_pin => '新 PIN';

  @override
  String get s_new_puk => '新 PUK';

  @override
  String get s_confirm_pin => '确认 PIN';

  @override
  String get s_confirm_puk => '确认 PUK';

  @override
  String get s_unblock_pin => '重置 PIN';

  @override
  String get l_pin_mismatch => 'PIN 不一致';

  @override
  String get l_puk_mismatch => 'PUK 不一致';

  @override
  String get s_pin_set => '已设置 PIN';

  @override
  String get s_puk_set => '已设置 PUK';

  @override
  String l_set_pin_failed(String message) {
    return '密码设置失败： $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries 次剩余机会',
      one: '$retries 次剩余机会',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries 次剩余机会',
      one: '$retries 次剩余机会',
    );
    return 'PIN 错误，$_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries 次剩余机会',
      one: '$retries 次剩余机会',
    );
    return 'PUK 错误， $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'FIDO PIN 保护';

  @override
  String get s_pin_change_required => '需要更改 PIN';

  @override
  String get l_enter_fido2_pin => '输入 YubiKey 的 FIDO2 PIN';

  @override
  String get p_fido2_pin_required => '您将要执行的操作需要输入 FIDO2 PIN 。';

  @override
  String get l_pin_blocked_reset => 'PIN 已被封禁，将 FIDO 应用程序恢复出厂设置';

  @override
  String get l_pin_blocked => 'PIN 已被封禁';

  @override
  String get l_set_pin_first => '需要 PIN';

  @override
  String get l_unlock_pin_first => '使用 PIN 解锁';

  @override
  String get l_pin_soft_locked => '在重新拔插YubiKey之前，PIN 已被锁定';

  @override
  String get l_pin_change_required_desc => '您必须先设置新的 PIN 才能使用此应用程序';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'PIN 长度必须为 $min_length-$max_length 个字符，可包含字母、数字和特殊字符。';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'PIN 长度必须为 $min_length-$max_length 字符，至少包含 $unique_characters 唯一字符，并且不能是常用的 PIN ，如 \"$common_pin\"。它可以包含字母、数字和特殊字符。';
  }

  @override
  String get s_ep_attestation => '企业认证';

  @override
  String get s_ep_attestation_enabled => '企业认证已启用';

  @override
  String get q_enable_ep_attestation => '启用企业认证？';

  @override
  String get p_enable_ep_attestation_desc => '这将启用企业认证，允许授权域唯一识别您的 YubiKey。';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      '一旦启用企业认证，就只能将 FIDO 恢复出厂设置来进行禁用。';

  @override
  String get s_pin_required => '需要 PIN';

  @override
  String get p_pin_required_desc => '您将要执行的操作需要输入 PIV PIN 。';

  @override
  String get l_piv_pin_blocked => '已封禁，请使用 PUK 以重置';

  @override
  String get p_piv_pin_blocked_desc => 'PIN 已被封禁。请使用 PUK 重置。';

  @override
  String get p_piv_pin_blocked_bio_desc => 'PIN已被封禁。需要恢复出厂设置。';

  @override
  String get l_piv_pin_puk_blocked => '已封禁，需要恢复出厂设置';

  @override
  String get p_piv_pin_puk_blocked_desc => 'PIN 和 PUK 均被封禁。需要对 PIV 应用程序恢复出厂设置。';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name 的长度必须至少为 $length 个字符。';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name 的长度必须至少为 $length 字符，至少包含 2 个唯一字符，并且不是常用的 $name，如 \"$common\"。';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return '新的 $name 不符合复杂性要求。';
  }

  @override
  String get s_dismiss => '取消';

  @override
  String get p_default_pin_puk_key_desc => '建议更改默认 PIN 、PUK 和管理密钥。';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      '为符合 FIPS 标准，需要更改默认 PIN、PUK 和管理密钥。';

  @override
  String get l_warning_default_pin => '警告：使用了默认 PIN';

  @override
  String get l_warning_default_puk => '警告：使用了默认 PUK ';

  @override
  String get l_default_pin_used => '默认 PIN 已使用';

  @override
  String get l_default_puk_used => '默认 PUK 已使用';

  @override
  String get l_pin_complexity => 'PIN 复杂性已强制要求';

  @override
  String get s_password => '密码';

  @override
  String get s_manage_password => '管理密码';

  @override
  String get s_set_password => '设置密码';

  @override
  String get s_password_set => '密码已设置';

  @override
  String get s_show_password => '显示密码';

  @override
  String get s_hide_password => '隐藏密码';

  @override
  String get l_password_protection => '账户密码保护';

  @override
  String get s_new_password => '新密码';

  @override
  String get s_current_password => '当前密码';

  @override
  String get s_confirm_password => '确认密码';

  @override
  String get l_password_mismatch => '密码不一致';

  @override
  String get s_wrong_password => '密码错误';

  @override
  String get p_wrong_password => '密码错误。如果您不知道密码，则需要重置 YubiKey。';

  @override
  String get s_remove_password => '移除密码';

  @override
  String get s_password_removed => '密码已移除';

  @override
  String get s_remember_password => '记住密码';

  @override
  String get s_clear_saved_password => '清除已保存的密码';

  @override
  String get s_password_forgotten => '忘记密码';

  @override
  String get l_keystore_unavailable => '操作系统密钥库不可用';

  @override
  String get l_remember_pw_failed => '忘记密码失败';

  @override
  String get l_unlock_first => '使用密码解锁';

  @override
  String get l_set_password_first => '设置密码';

  @override
  String get l_enter_oath_pw => '请输入 YubiKey 的 OATH 密码';

  @override
  String get p_new_password_requirements => '密码可以包含字母、数字和特殊字符。';

  @override
  String get s_management_key => '管理密钥';

  @override
  String get s_current_management_key => '当前管理密钥';

  @override
  String get s_new_management_key => '新的管理密钥';

  @override
  String get l_change_management_key => '更改管理密钥';

  @override
  String get l_management_key_changed => '管理密钥已更改';

  @override
  String get l_default_key_used => '默认管理密钥已使用';

  @override
  String get s_generate_random => '随机生成';

  @override
  String get s_use_default => '使用默认值';

  @override
  String get l_warning_default_key => '警告：已使用默认密钥';

  @override
  String get s_protect_key => '使用 PIN 保护';

  @override
  String get p_protect_key_desc => '在需要管理密钥验证的操作中，使用 PIN 代替管理密钥。';

  @override
  String get s_management_key_algorithm => '管理密钥算法';

  @override
  String get p_management_key_algorithm_desc => '选择管理密钥的算法。';

  @override
  String get l_pin_protected_key => '可使用 PIN 代替';

  @override
  String get l_wrong_key => '错误的密钥';

  @override
  String get l_unlock_piv_management => '解锁 PIV 管理';

  @override
  String get p_unlock_piv_management_desc => '您即将执行的操作需要 PIV 管理密钥。';

  @override
  String l_account(String label) {
    return '账户：$label';
  }

  @override
  String get s_accounts => '账户';

  @override
  String get s_no_accounts => '没有账户';

  @override
  String l_results_for(String query) {
    return '\"$query\" 的结果';
  }

  @override
  String get l_authenticator_get_started => '开始使用 OTP 账户';

  @override
  String get l_no_accounts_desc => '从任何支持 OATH TOTP/HOTP 的提供商添加账户到你的 YubiKey';

  @override
  String get s_add_account => '添加账户';

  @override
  String get p_add_account_desc => '扫描二维码或手动输入凭证。';

  @override
  String get s_add_accounts => '添加账户';

  @override
  String get l_drop_qr_description => '拖放二维码以添加账户';

  @override
  String get p_add_account_three_ways => '有三种添加账户的方法。';

  @override
  String get s_scanning => '扫描（推荐）';

  @override
  String get p_scanning_desc => '在扫描二维码之前，确保完整的二维码在屏幕上可见。';

  @override
  String get s_drag_and_drop => '拖放';

  @override
  String get p_drag_and_drop_desc => '包含二维码的图像可以放置在账户视图的任何位置。';

  @override
  String get s_manually => '手动';

  @override
  String get p_manually_desc => '可在表格中手动输入账户凭证详细信息。';

  @override
  String get s_account_added => '账户已添加';

  @override
  String l_account_add_failed(String message) {
    return '添加账户失败： $message';
  }

  @override
  String get l_add_account_password_required => '需要密码';

  @override
  String get l_add_account_unlock_required => '需要解锁';

  @override
  String get l_add_account_func_missing => '功能缺失或禁用';

  @override
  String get l_account_name_required => '您的帐号必须有一个名称';

  @override
  String get l_name_already_exists => '发行者名称已存在';

  @override
  String get l_account_already_exists => '此账户已存在于 YubiKey 中';

  @override
  String get l_invalid_character_issuer => '无效字符：发行人中不允许使用\":\"';

  @override
  String get l_select_accounts => '选择要添加到 YubiKey 的账户（们）';

  @override
  String get s_pin_account => '置顶账户';

  @override
  String get s_unpin_account => '取消置顶账户';

  @override
  String get s_no_pinned_accounts => '没有置顶账户';

  @override
  String get s_pinned => '已置顶';

  @override
  String get l_pin_account_desc => '将您的重要账户集中在一起';

  @override
  String get s_rename_account => '重命名账户';

  @override
  String get l_rename_account_desc => '编辑账户的发行者/名称';

  @override
  String get s_account_renamed => '账户已重命名';

  @override
  String l_rename_account_failed(String message) {
    return '重命名账户失败： $message';
  }

  @override
  String get p_rename_will_change_account_displayed => '这将改变帐号在列表中的显示方式。';

  @override
  String get s_delete_account => '删除账户';

  @override
  String get q_delete_account => '删除账户？';

  @override
  String get l_delete_account_desc => '从您的 YubiKey 中删除账户';

  @override
  String get s_account_deleted => '账户已删除';

  @override
  String get p_warning_delete_account => '警告！此操作将从您的 Yubikey 删除账户。';

  @override
  String get p_warning_disable_credential => '请确保已从注册的服务中禁用此账户，以避免无法登录。';

  @override
  String get s_account_name => '账户名';

  @override
  String get s_search_accounts => '搜索账户';

  @override
  String l_accounts_used(int used, int capacity) {
    return '已使用$used 个账户 ，总共$capacity 账户可用';
  }

  @override
  String s_num_digits(int num) {
    return '$num 位';
  }

  @override
  String s_num_sec(int num) {
    return '$num 秒';
  }

  @override
  String get s_issuer_optional => '发行者（可选）';

  @override
  String get s_counter_based => '基于计数器';

  @override
  String get s_time_based => '基于时间';

  @override
  String get l_copy_code_desc => '将验证码粘贴到另一个应用程序中';

  @override
  String get l_calculate_code_desc => '从您的 YubiKey 获取新代码';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => '用户 ID';

  @override
  String get s_credential_id => '凭证 ID';

  @override
  String get s_display_name => '显示名称';

  @override
  String get s_user_name => '用户名';

  @override
  String get s_passkeys => '通行密钥';

  @override
  String get s_no_passkeys => '无通行密钥';

  @override
  String get l_ready_to_use => '准备就绪';

  @override
  String get l_register_sk_on_websites => '在网站上注册为安全密钥';

  @override
  String get l_no_discoverable_accounts => '未存储通行密钥';

  @override
  String get p_non_passkeys_note => '非密钥凭证可能存在，但无法列出。';

  @override
  String get s_delete_passkey => '删除通行密钥';

  @override
  String get q_delete_passkey => '删除通行密钥？';

  @override
  String get l_delete_passkey_desc => '从 YubiKey 中移除密钥';

  @override
  String get s_passkey_deleted => '通行密钥已删除';

  @override
  String get p_warning_delete_passkey => '警告！此操作将从您的 YubiKey 中删除通行密钥。';

  @override
  String get p_warning_delete_passkey_desc => '您将不能使用由此密钥注册的服务。';

  @override
  String get l_do_not_remove_yk_delete => '删除时不要移除 YubiKey';

  @override
  String get s_search_passkeys => '搜索通行密钥';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used $max 使用的通行秘钥。';
  }

  @override
  String get s_biometrics => '生物识别';

  @override
  String l_fingerprint(String label) {
    return '指纹： $label';
  }

  @override
  String get s_fingerprints => '指纹';

  @override
  String get l_fingerprint_captured => '指纹采集成功！';

  @override
  String get s_fingerprint_added => '指纹已添加';

  @override
  String l_adding_fingerprint_failed(String message) {
    return '添加指纹时出错： $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return '设置名称错误： $message';
  }

  @override
  String get s_setup_fingerprints => '设置指纹';

  @override
  String get p_setup_fingerprints_desc => '在使用密钥之前，需要先设置指纹。';

  @override
  String get s_add_fingerprint => '添加指纹';

  @override
  String get s_delete_fingerprint => '删除指纹';

  @override
  String get q_delete_fingerprint => '要删除指纹吗？';

  @override
  String get l_delete_fingerprint_desc => '从 YubiKey 移除指纹';

  @override
  String get s_fingerprint_deleted => '指纹已删除';

  @override
  String get p_warning_delete_fingerprint => '这将从 Yubikey 中删除指纹。';

  @override
  String get s_fingerprints_get_started => '从使用指纹开始';

  @override
  String get p_set_fingerprints_desc => '在注册指纹之前，需要设置一个 PIN 码。';

  @override
  String get l_no_fps_added => '未添加指纹';

  @override
  String get s_rename_fp => '重命名指纹';

  @override
  String get l_rename_fp_desc => '更改名称';

  @override
  String get s_fingerprint_renamed => '指纹已重命名';

  @override
  String l_rename_fp_failed(String message) {
    return '重命名错误： $message';
  }

  @override
  String get l_add_one_or_more_fps => '添加一个或多个（最多五个）指纹';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5个指纹已被登记';
  }

  @override
  String get p_press_fingerprint_begin => '将手指按在 YubiKey 上开始操作。';

  @override
  String get l_name_fingerprint => '为这个指纹命名';

  @override
  String get l_user_action_timeout_error => '因用户不活动而失败';

  @override
  String get l_wrong_inserted_yk_error => '重新插入的 YubiKey 与初始设备不匹配';

  @override
  String get l_failed_connecting_to_fido => '连接 FIDO 接口失败';

  @override
  String get l_self_signed_certificate => '自签名证书';

  @override
  String get l_certificate_signing_request => '证书签名请求（CSR）';

  @override
  String get s_certificate => '证书';

  @override
  String get s_subject => '主体';

  @override
  String get l_export_csr_file => '将 CSR 保存到文件';

  @override
  String get l_export_public_key => '导出公钥';

  @override
  String get l_export_public_key_file => '保存公钥到文件';

  @override
  String get l_export_public_key_desc => '将证书导出到文件';

  @override
  String get l_public_key_exported => '已导出公钥';

  @override
  String get l_export_certificate => '导出证书';

  @override
  String get l_export_certificate_file => '将证书导出到文件';

  @override
  String get l_export_certificate_desc => '将该证书导出到文件';

  @override
  String get l_certificate_exported => '证书已导出';

  @override
  String get l_select_import_file => '选择要导入的文件';

  @override
  String get l_import_file => '导入文件';

  @override
  String get l_import_desc => '导入密钥和（或）证书';

  @override
  String get l_import_nothing => '没有可导入的内容';

  @override
  String get l_importing_file => '正在导入文件…';

  @override
  String get s_file_imported => '文件已导入';

  @override
  String get l_unsupported_key_type => '不支持的密钥类型';

  @override
  String get l_delete_certificate => '删除证书';

  @override
  String get q_delete_certificate => '删除证书？';

  @override
  String get l_delete_certificate_desc => '从 YubiKey 中删除证书';

  @override
  String get l_delete_key => '删除密钥';

  @override
  String get q_delete_key => '删除密钥？';

  @override
  String get l_delete_key_desc => '从您的 YubiKey 中移除密钥';

  @override
  String get l_delete_certificate_or_key => '删除证书/密钥';

  @override
  String get q_delete_certificate_or_key => '删除证书/密钥？';

  @override
  String get l_delete_certificate_or_key_desc => '从您的 YubiKey 中删除证书或密钥';

  @override
  String get l_move_key => '移动密钥';

  @override
  String get l_move_key_desc => '将一个密钥从一个 PIV 槽位移动到另一个';

  @override
  String get l_change_defaults => '更改默认访问码';

  @override
  String get s_issuer => '发行者';

  @override
  String get s_serial => '序列号';

  @override
  String get s_certificate_fingerprint => '指纹';

  @override
  String get s_valid_from => '有效期从';

  @override
  String get s_valid_to => '有效期至';

  @override
  String get l_no_certificate => '未加载证书';

  @override
  String get l_key_no_certificate => '已加载无密钥的证书';

  @override
  String get s_generate_key => '生成密钥';

  @override
  String get l_generate_desc => '生成新证书或 CSR';

  @override
  String p_generate_desc(String slot) {
    return '这将在 YubiKey 的 PIV 槽位 $slot 中上生成一个新密钥。';
  }

  @override
  String get s_private_key_generated => '私钥已生成';

  @override
  String get p_select_what_to_delete => '选择要从槽位中删除的内容。';

  @override
  String get p_warning_delete_certificate => '警告！此操作将从您的 YubiKey 中删除证书。';

  @override
  String get p_warning_delete_key => '警告！此操作将从您的 Yubikey 中删除私钥。';

  @override
  String get p_warning_delete_certificate_and_key =>
      '警告！此操作将从您的 YubiKey 中删除证书和私钥。';

  @override
  String get p_warning_usb_preferred => 'RSA 密钥首选 USB 接口。NFC 可能会导致错误。';

  @override
  String p_delete_certificate_desc(String slot) {
    return '这将删除 PIV 槽位 $slot中的证书。';
  }

  @override
  String p_delete_key_desc(String slot) {
    return '这将删除 PIV 槽位 $slot中的私钥。';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return '这将删除 PIV 槽位 $slot中的证书和私钥。';
  }

  @override
  String get l_certificate_deleted => '证书已删除';

  @override
  String get l_key_deleted => '密钥已删除';

  @override
  String get l_certificate_and_key_deleted => '证书和密钥已删除';

  @override
  String get l_include_certificate => '包含证书';

  @override
  String get l_select_destination_slot => '选择目标槽位';

  @override
  String q_move_key_confirm(String from_slot) {
    return '移动 PIV 槽位 $from_slot 中的私钥？';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return '将 PIV 槽位 $from_slot 中的私钥移至槽位 $to_slot ？';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return '将 PIV 槽位 $from_slot 中的私钥和证书移至槽位 $to_slot？';
  }

  @override
  String get p_password_protected_file => '选中的文件受密码保护。';

  @override
  String p_import_items_desc(String slot) {
    return '以下项目将导入 PIV 槽位 $slot。';
  }

  @override
  String get l_warning_public_key_mismatch => '证书的公钥与槽位中的私钥不匹配';

  @override
  String get l_key_moved => '密钥已移动';

  @override
  String get l_key_and_certificate_moved => '移动密钥和证书';

  @override
  String get p_subject_desc => '一个满足 RFC 4514 标准的可识别的名称(DN)。';

  @override
  String get l_rfc4514_invalid => '无效的RFC 4514 格式';

  @override
  String get rfc4514_examples =>
      '示例:\nCN=Example Name\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => '允许使用指纹';

  @override
  String get s_pin_policy => 'PIN 策略';

  @override
  String get s_output_format => '输出格式';

  @override
  String get s_expiration_date => '有效期至';

  @override
  String get p_algorithm_desc => '要使用的密钥算法。';

  @override
  String get p_expiration_date_desc => '证书过期日期，默认为 1 年（仅限证书）。';

  @override
  String get p_key_options_bio_desc => '允许使用生物识别技术代替 PIN 。';

  @override
  String get q_overwrite_slot => '覆盖槽位？';

  @override
  String p_overwrite_slot_desc(String slot) {
    return '这将永久覆盖槽位 $slot 中的现有内容。';
  }

  @override
  String get l_overwrite_cert => '证书将被覆盖';

  @override
  String get l_overwrite_key => '私钥将被覆盖';

  @override
  String get l_overwrite_key_maybe => '槽位中的任何现有密钥都将被覆盖';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => '身份认证';

  @override
  String get s_slot_9c => '数字签名';

  @override
  String get s_slot_9d => '密钥管理';

  @override
  String get s_slot_9e => '卡片认证';

  @override
  String get s_retired_slot => '退役密钥管理';

  @override
  String get s_otp_slot_one => '短触';

  @override
  String get s_otp_slot_two => '长按';

  @override
  String get l_otp_slot_empty => '槽位为空';

  @override
  String get l_otp_slot_configured => '槽位已配置';

  @override
  String get l_yubiotp_desc => '配置 Yubico OTP 凭证';

  @override
  String get s_challenge_response => '挑战/应答';

  @override
  String get l_challenge_response_desc => '配置一个 挑战/应答 凭证';

  @override
  String get s_static_password => '静态密码';

  @override
  String get l_static_password_desc => '配置静态密码';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => '配置基于 HMAC-SHA1 的凭证';

  @override
  String get s_public_id => '公开ID';

  @override
  String get s_private_id => '私有ID';

  @override
  String get s_use_serial => '使用序列号';

  @override
  String get l_select_file => '选择文件';

  @override
  String get l_no_export_file => '没有文件导出';

  @override
  String get s_no_export => '无导出';

  @override
  String get s_export => '导出';

  @override
  String get l_export_configuration_file => '将配置导出到文件';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return '导出的凭证可上传至 $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return '键盘 $layout';
  }

  @override
  String get s_delete_slot => '删除凭证';

  @override
  String get q_delete_slot => '删除凭证？';

  @override
  String get l_delete_slot_desc => '移除槽位中的凭据';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return '警告！此操作将永久删除槽位 $slot_id 中的凭据。';
  }

  @override
  String get l_slot_deleted => '凭据已删除';

  @override
  String get s_swap => '交换';

  @override
  String get s_swap_slots => '交换槽位';

  @override
  String get q_swap_slots => '交换槽位？';

  @override
  String get l_swap_slots_desc => '交换短/长触摸';

  @override
  String get p_swap_slots_desc => '这将调换两个槽位的配置。';

  @override
  String get l_slots_swapped => '交换槽位配置';

  @override
  String l_slot_credential_configured(String type) {
    return '配置的 $type 凭据';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return '配置 $type 凭据并导出至 $file';
  }

  @override
  String get s_append_enter => '附加 ⏎';

  @override
  String get l_append_enter_desc => '输入 OTP 后追加回车键';

  @override
  String get p_otp_swap_error => '交换槽位失败！请确保 YubiKey 没有被限制访问权限。';

  @override
  String get l_wrong_access_code => '访问码错误';

  @override
  String get s_access_code => '访问码';

  @override
  String get s_show_access_code => '显示访问码';

  @override
  String get s_hide_access_code => '隐藏访问码';

  @override
  String p_enter_access_code(String slot) {
    return '输入槽位的访问码 $slot。';
  }

  @override
  String get s_enable_nfc => '启用 NFC';

  @override
  String get s_request_access => '申请权限';

  @override
  String get s_permission_denied => '权限被拒绝';

  @override
  String get l_elevating_permissions => '正在提升权限…';

  @override
  String get s_review_permissions => '检查权限';

  @override
  String get s_open_windows_settings => '打开 Windows 设置';

  @override
  String get l_admin_privileges_required => '需要管理员权限';

  @override
  String get p_elevated_permissions_required =>
      '管理此设备需要管理员权限。或者，您可以使用 Windows 设置来管理 FIDO 配置。';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'WebAuthn 管理需要管理员权限。或者，您可以使用 Windows 设置来管理 FIDO 配置。';

  @override
  String get p_ms_store_permission_note =>
      '由于 Windows 沙盒的限制，微软商店版本的应用程序一般无法提升权限。我们建议使用官方 .msi 安装程序安装 Yubico 身份验证器。';

  @override
  String get p_need_camera_permission => 'Yubico 身份验证器需要相机权限以扫描二维码。';

  @override
  String get s_qr_scan => '扫描二维码';

  @override
  String get l_invalid_qr => '二维码无效';

  @override
  String get l_qr_not_found => '未发现二维码';

  @override
  String get l_qr_scanned => '已扫描二维码';

  @override
  String l_qr_file_too_large(String max) {
    return '文件过大（最多 $max ）';
  }

  @override
  String get l_qr_invalid_image_file => '图片文件无效';

  @override
  String get l_qr_select_file => '选择带有二维码的文件';

  @override
  String l_qr_not_read(String message) {
    return '读取二维码失败： $message';
  }

  @override
  String get l_point_camera_scan => '将摄像头对准二维码进行扫描';

  @override
  String get q_want_to_scan => '要扫描吗？';

  @override
  String get q_no_qr => '没有二维码？';

  @override
  String get s_enter_manually => '手动输入';

  @override
  String get s_read_from_file => '从文件读取';

  @override
  String get s_reset => '重置';

  @override
  String get s_factory_reset => '恢复出厂设置';

  @override
  String get l_factory_reset_desc => '恢复 YubiKey 的默认设置';

  @override
  String get l_factory_reset_required => '需要恢复出厂设置';

  @override
  String get l_oath_application_reset => '重置 OATH 应用程序';

  @override
  String get l_fido_app_reset => '重置 FIDO 应用程序';

  @override
  String l_reset_failed(String message) {
    return '执行重置时出错： $message';
  }

  @override
  String get l_piv_app_reset => '重置 PIV 应用程序';

  @override
  String get p_factory_reset_an_app => '将您 YubiKey 上的一个应用程序恢复出厂设置。';

  @override
  String get p_factory_reset_desc =>
      '数据被存储在 YubiKey 上的多个应用程序中，其中有些程序可以单独恢复出厂设置。\n\n选择要恢复出厂设置的应用程序。';

  @override
  String get p_warning_factory_reset =>
      '警告！这将不可逆地删除您的 YubiKey 中的所有 OATH TOTP/HOTP 账户。';

  @override
  String get p_warning_disable_credentials =>
      '您的 OATH 凭据以及设置的任何密码都将从此 YubiKey 中删除。请确保从各自的网站上禁用这些功能，以免无法访问账户。';

  @override
  String get p_warning_deletes_accounts =>
      '警告！这将不可撤销地删除 YubiKey 中的所有 U2F 和 FIDO2 账户，包括密钥。';

  @override
  String get p_warning_disable_accounts =>
      '您的凭证和设置的任何 PIN 都将从该 YubiKey 中删除。请确保在各自的网站上禁用这些功能，以免无法访问账户。';

  @override
  String l_reset_not_allowed_over(String transport) {
    return '通过 $transport禁用 FIDO 复位';
  }

  @override
  String get p_warning_piv_reset => '警告！存储在 PIV 上的所有数据将不可逆地从您的 Yubikey 删除。';

  @override
  String get p_warning_piv_reset_desc => '这包括私钥和证书。您的 PIN、PUK 和管理密钥将被重置为出厂默认值。';

  @override
  String get p_warning_global_reset => '警告！这将不可逆地删除 YubiKey 中所有已保存的数据，包括证书。';

  @override
  String get p_warning_global_reset_desc =>
      '将 YubiKey 上的应用程序恢复出厂设置。PIN将重置为出厂默认值，已注册的指纹将被删除。任何密钥、证书或其他凭证都将被永久删除。';

  @override
  String get l_copy_to_clipboard => '复制到剪贴板';

  @override
  String get s_code_copied => '代码已复制';

  @override
  String get l_code_copied_clipboard => '代码已复制到剪贴板';

  @override
  String get s_copy_log => '复制日志';

  @override
  String get l_copy_log_clipboard => '复制日志到剪贴板';

  @override
  String get l_log_copied => '日志已复制到剪贴板';

  @override
  String get l_diagnostics_copied => '诊断数据已复制到剪贴板';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label 已复制到剪贴板。';
  }

  @override
  String get s_custom_icons => '自定义图标';

  @override
  String get l_set_icons_for_accounts => '为账号设置图标';

  @override
  String get p_custom_icons_description => '图标包可以通过使用熟悉的徽标和颜色，让您的账号更容易辨识。';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return '图标包使用 $aegis_icon_pack 格式。您可以下载预制图标包，也可以创建自己的图标包。';
  }

  @override
  String get s_replace_icon_pack => '替换图标包';

  @override
  String get l_loading_icon_pack => '加载图标包中…';

  @override
  String get s_load_icon_pack => '加载图标包';

  @override
  String get l_load_icon_pack_desc => '从文件加载图标包';

  @override
  String get s_remove_icon_pack => '删除图标包';

  @override
  String get l_remove_icon_pack_desc => '删除活动图标包';

  @override
  String get l_icon_pack_removed => '图标包已删除';

  @override
  String get l_remove_icon_pack_failed => '删除图标包时出错';

  @override
  String get s_choose_icon_pack => '选择图标包';

  @override
  String get l_icon_pack_imported => '图标包已导入';

  @override
  String l_import_icon_pack_failed(String message) {
    return '导入图标包出错： $message';
  }

  @override
  String get l_invalid_icon_pack => '无效的图标包';

  @override
  String get l_icon_pack_copy_failed => '复制图标包文件失败';

  @override
  String get s_nfc_and_usb_options => 'NFC 和 USB 选项';

  @override
  String get l_nfc_and_usb_options_desc => '配置 YubiKey 的操作';

  @override
  String get l_on_yk_nfc_tap => '在 NFC 轻触时';

  @override
  String get l_on_yk_usb_insert => '在 USB 插入时';

  @override
  String get l_do_nothing => '不进行任何操作';

  @override
  String get l_launch_ya => '启动 Yubico 身份验证器';

  @override
  String get l_copy_otp_clipboard => '复制 OTP（一次性密码） 到剪贴板';

  @override
  String get l_launch_and_copy_otp => '启动应用程序并复制 OTP （一次性密码）';

  @override
  String get l_kbd_layout_for_static => '键盘布局（用于静态密码）';

  @override
  String get s_choose_kbd_layout => '选择键盘布局';

  @override
  String get l_bypass_touch_requirement => '跳过触摸需求';

  @override
  String get l_bypass_touch_requirement_on => '需要触摸的账户会在 NFC 中自动显示';

  @override
  String get l_bypass_touch_requirement_off => '需要触摸的账户需要额外再使用 NFC 轻触一次';

  @override
  String get s_silence_nfc_sounds => '静音 NFC 提示音';

  @override
  String get l_silence_nfc_sounds_on => '读取 NFC 时不会播放任何声音';

  @override
  String get l_silence_nfc_sounds_off => '声音将在 NFC 读取时播放';

  @override
  String get l_launch_app_on_usb_on => '这可以防止其他应用程序通过 USB 使用 YubiKey';

  @override
  String get l_launch_app_on_usb_off => '其他应用程序可通过 USB 使用 YubiKey';

  @override
  String get s_allow_screenshots => '允许截图';

  @override
  String get l_allow_screenshots_desc => '允许其他应用程序截屏';

  @override
  String get s_nfc_ready_to_scan => '已准备好扫描';

  @override
  String get s_nfc_hold_still => '保持不动…';

  @override
  String get s_nfc_tap_your_yubikey => '读取您的 YubiKey';

  @override
  String get s_nfc_remove_key => '移除 YubiKey';

  @override
  String get l_nfc_failed_to_scan => '扫描失败，请重试';

  @override
  String get s_usb_processing => '从 YubiKey 读取数据';

  @override
  String get s_usb_dont_remove => '不要拔下密钥…';

  @override
  String get l_usb_read_error => '从 YubiKey 读取数据失败';

  @override
  String get p_ndef_set_otp => '成功将 OTP 代码从 YubiKey 复制到剪贴板。';

  @override
  String get p_ndef_set_password => '成功将密码从 YubiKey 复制到剪贴板。';

  @override
  String get p_ndef_parse_failure => '从 Yubikey 解析 OTP 代码失败。';

  @override
  String get p_ndef_set_clip_failure => '尝试从 YubiKey 复制 OTP 代码时，访问剪贴板失败。';

  @override
  String get s_set_label => '设置标签';

  @override
  String get s_set_color => '设置颜色';

  @override
  String get s_change_label => '更改标签';

  @override
  String get p_set_will_add_custom_name => '这将为你的 YubiKey 起一个自定义名称。';

  @override
  String get p_rename_will_change_custom_name => '这将更改您的 YubiKey 的标签。';

  @override
  String get s_keyboard_shortcuts => '键盘快捷键';

  @override
  String get s_global_shortcuts => '全局快捷键';

  @override
  String get s_application_shortcuts => '应用程序快捷键';

  @override
  String s_quit_app(String app) {
    return '退出 $app';
  }

  @override
  String s_hide_app(String app) {
    return '隐藏 $app';
  }

  @override
  String get s_search => '搜索';

  @override
  String get s_next_device => '下一个设备';

  @override
  String get s_previous_device => '上一个设备';

  @override
  String get s_open_settings => '打开设置';

  @override
  String get s_open_item => '打开项目';

  @override
  String get s_edit_item => '编辑项目';

  @override
  String get s_delete_item => '删除项目';

  @override
  String get s_calculate_oath_code => '计算 OATH 代码';

  @override
  String get s_open_keyboard_shortcuts => '打开键盘快捷键';
}

/// The translations for Chinese, as used in Taiwan (`zh_TW`).
class AppLocalizationsZhTw extends AppLocalizationsZh {
  AppLocalizationsZhTw() : super('zh_TW');

  @override
  String get app_name => 'Yubico 驗證器';

  @override
  String get native_language_name => '繁體中文';

  @override
  String s_translated(int percentage) {
    return '翻譯： $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return '校對： $percentage%';
  }

  @override
  String get l_incomplete_translation => '翻譯不完整';

  @override
  String get p_translation_progress_desc => '進度指標反映翻譯的成熟度。';

  @override
  String get s_save => '儲存';

  @override
  String get s_cancel => '取消';

  @override
  String get s_close => '關閉';

  @override
  String get s_delete => '刪除';

  @override
  String get s_move => '移動';

  @override
  String get s_quit => '離開';

  @override
  String get s_enable => '啟用';

  @override
  String get s_enabled => '已啟用';

  @override
  String get s_disabled => '已禁用';

  @override
  String get s_status => '狀態';

  @override
  String get s_unlock => '解鎖';

  @override
  String get s_calculate => '計算';

  @override
  String get s_import => '導入';

  @override
  String get s_overwrite => '覆寫';

  @override
  String get s_done => '完成';

  @override
  String get s_label => '標籤';

  @override
  String get s_name => '名稱';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => '選項';

  @override
  String get s_details => '詳細資訊';

  @override
  String get s_show_window => '顯示視窗';

  @override
  String get s_hide_window => '隱藏視窗';

  @override
  String get s_show_navigation => '顯示導覽列';

  @override
  String get s_expand_navigation => '展開導覽列';

  @override
  String get s_collapse_navigation => '折疊導覽列';

  @override
  String get s_expand_collapse_navigation => '展開/折疊導覽列';

  @override
  String get s_show_menu => '顯示選單';

  @override
  String get s_toggle_menu_bar => '切換功能表列';

  @override
  String get s_more_info => '更多資訊';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => '關於';

  @override
  String get s_algorithm => '演算法';

  @override
  String get s_appearance => '外觀';

  @override
  String get s_actions => '動作';

  @override
  String get s_manage => '管理';

  @override
  String get s_setup => '設定';

  @override
  String get s_device => '裝置';

  @override
  String get s_application => '應用程式';

  @override
  String get s_settings => '設定';

  @override
  String get s_certificates => '憑證';

  @override
  String get s_security_key => '安全密鑰';

  @override
  String get s_slots => '插槽';

  @override
  String get s_home => '主頁';

  @override
  String get s_user_guide => '使用手冊';

  @override
  String get s_i_need_help => '需要協助';

  @override
  String get s_terms_of_use => '用戶協議';

  @override
  String get s_privacy_policy => '隱私權政策';

  @override
  String get s_open_src_licenses => '開放原始碼授權';

  @override
  String get s_please_wait => '請稍候…';

  @override
  String get s_secret_key => '密鑰';

  @override
  String get s_show_secret_key => '查看密鑰';

  @override
  String get s_hide_secret_key => '隱藏密鑰';

  @override
  String get s_private_key => '私鑰';

  @override
  String get s_public_key => '公鑰';

  @override
  String get s_invalid_length => '無效的長度';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return '無效格式，允許字元： $characters';
  }

  @override
  String get l_invalid_keyboard_character => '所選鍵盤的字元無效';

  @override
  String get s_require_touch => '要求觸摸';

  @override
  String get q_have_account_info => '有帳戶資訊嗎？';

  @override
  String get s_run_diagnostics => '執行診斷';

  @override
  String get s_character_count => '字元計數';

  @override
  String get s_language => '語言';

  @override
  String get s_app_theme => '應用程式佈景主題';

  @override
  String get s_system_default => '系統預設值';

  @override
  String get s_light_mode => '淺色模式';

  @override
  String get s_dark_mode => '暗色模式';

  @override
  String get s_list_layout => '列表佈局';

  @override
  String get s_grid_layout => '網格布局';

  @override
  String get s_mixed_layout => '混合佈局';

  @override
  String get s_select_layout => '選擇佈局';

  @override
  String get s_select_to_scan => '選擇掃描';

  @override
  String get s_hide_reader => '隱藏閱讀器';

  @override
  String get s_show_hidden_readers => '顯示隱藏閱讀器';

  @override
  String get s_toggle_readers => '切換閱讀器';

  @override
  String get l_toggle_readers_desc => '顯示或隱藏閱讀器';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return '序號： $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return '韌體版本： $version';
  }

  @override
  String get l_fips_capable => 'FIPS 使能';

  @override
  String get l_fips_approved => '通過 FIPS 認證';

  @override
  String get l_insert_yk => '插入您的 YubiKey';

  @override
  String get l_insert_or_tap_yk => '插入或輕按 YubiKey';

  @override
  String get l_unplug_yk => '拔出您的 YubiKey';

  @override
  String get l_reinsert_yk => '重新插入您的 YubiKey';

  @override
  String get l_place_on_nfc_reader => '將您的 YubiKey 放在 NFC 讀卡器上';

  @override
  String get l_replace_yk_on_reader => '將您的 YubiKey 放回讀卡器上';

  @override
  String get l_remove_yk_from_reader => '從 NFC 讀卡器中取走 YubiKey';

  @override
  String get p_try_reinsert_yk => '嘗試移除並重新插入您的 YubiKey。';

  @override
  String get s_touch_required => '需要觸摸';

  @override
  String get l_touch_button_now => '立即輕觸 YubiKey 上的按鈕';

  @override
  String get l_keep_touching_yk => '持續重複觸碰您的 YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => '切換應用程式';

  @override
  String get s_toggle_interfaces => '切換介面';

  @override
  String get p_toggle_applications_desc => '透過可用的傳輸啟用或停用應用程式。';

  @override
  String get p_toggle_interfaces_desc => '啟用或停用 USB 介面。';

  @override
  String get l_toggle_applications_desc => '啟用/停用應用程式';

  @override
  String get l_toggle_interfaces_desc => '啟用/停用介面';

  @override
  String get s_reconfiguring_yk => '正在重新配置 YubiKey…';

  @override
  String get s_config_updated => '設定已更新';

  @override
  String get l_config_updated_reinsert => '已更新設定，移除並重新插入您的 YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 已停用';

  @override
  String get l_webauthn_req_fido2 => 'WebAuthn 需要在您的 YubiKey 上啟用 FIDO2 應用程式';

  @override
  String get s_lock_code => '鎖定密碼';

  @override
  String get l_wrong_lock_code => '鎖定密碼錯誤';

  @override
  String get s_show_lock_code => '顯示鎖定密碼';

  @override
  String get s_hide_lock_code => '隱藏鎖定密碼';

  @override
  String get p_lock_code_required_desc => '您要執行的動作需要輸入設定鎖定密碼。';

  @override
  String get l_helper_not_responding => 'Helper 程序沒有回應';

  @override
  String get l_yk_no_access => '無法存取此 YubiKey';

  @override
  String get s_yk_inaccessible => '裝置無法存取';

  @override
  String get l_open_connection_failed => '無法建立連線';

  @override
  String get l_ccid_connection_failed => '智慧卡連線失敗';

  @override
  String get p_ccid_service_unavailable => '確保您的智慧卡服務正常運作。';

  @override
  String get p_pcscd_unavailable => '確定 pcscd 已經安裝並開始執行。';

  @override
  String get l_no_yk_present => '沒有 YubiKey';

  @override
  String get s_unknown_type => '未知類別';

  @override
  String get s_unknown_device => '無法辨識的裝置';

  @override
  String get s_restricted_nfc => 'NFC 啟動';

  @override
  String get l_deactivate_restricted_nfc => '如何啟動 NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      '將 YubiKey 連接到任何 USB 電源，例如電腦，至少 3 秒鐘。\n\n一旦接上電源，NFC 即會啟動並可隨時使用。';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      '您的 YubiKey 配備了限制 NFC 功能，此功能是為了防止在運送過程中被無線操控而設計。表示在您啓用之前，NFC功能會暫時失效。';

  @override
  String get s_unsupported_yk => '不支援的 YubiKey';

  @override
  String get p_operation_failed_try_again => '操作失敗，請重試。';

  @override
  String get l_configuration_unsupported => '不支援的配置';

  @override
  String get p_scp_unsupported =>
      '要透過 NFC 進行通訊，YubiKey 需要本手機不支援的技術。請將 YubiKey 插入手機的 USB 連接埠。';

  @override
  String get l_error_occurred => '發生錯誤';

  @override
  String get s_application_error => '程式出錯';

  @override
  String get l_import_error => '匯入錯誤';

  @override
  String get l_file_not_found => '找不到檔案';

  @override
  String get l_file_too_big => '檔案太大';

  @override
  String get l_filesystem_error => '檔案系統作業錯誤';

  @override
  String get s_pin => 'PIN 碼';

  @override
  String get s_puk => 'PUK 碼';

  @override
  String get s_set_pin => '設定 PIN 碼';

  @override
  String get s_change_pin => '變更 PIN 碼';

  @override
  String get s_change_puk => '變更 PUK 碼';

  @override
  String get s_show_pin => '顯示 PIN 碼';

  @override
  String get s_hide_pin => '隱藏 PIN 碼';

  @override
  String get s_show_puk => '顯示 PUK 碼';

  @override
  String get s_hide_puk => '隱藏 PUK 碼';

  @override
  String get s_current_pin => '目前的 PIN 碼';

  @override
  String get s_current_puk => '目前的 PUK 碼';

  @override
  String get s_new_pin => '新 PIN 碼';

  @override
  String get s_new_puk => '新 PUK 碼';

  @override
  String get s_confirm_pin => '確認 PIN 碼';

  @override
  String get s_confirm_puk => '確認 PUK 碼';

  @override
  String get s_unblock_pin => '重設 PIN 碼';

  @override
  String get l_pin_mismatch => 'PIN 碼不符';

  @override
  String get l_puk_mismatch => 'PUK 碼不符';

  @override
  String get s_pin_set => 'PIN 碼已設定';

  @override
  String get s_puk_set => 'PUK 碼已設定';

  @override
  String l_set_pin_failed(String message) {
    return '設定 PIN 失敗： $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries 次嘗試剩餘',
      one: '$retries 次嘗試剩餘',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries 次嘗試剩餘',
      one: '$retries 次嘗試剩餘',
    );
    return '錯誤的 PIN 碼, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries 次嘗試剩餘',
      one: '$retries 次嘗試剩餘',
    );
    return '錯誤的 PUK 碼, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'FIDO PIN 保護';

  @override
  String get s_pin_change_required => '需要更改 PIN 碼';

  @override
  String get l_enter_fido2_pin => '輸入 YubiKey 的 FIDO2 PIN 碼';

  @override
  String get l_pin_blocked_reset => 'PIN 碼被封鎖；出廠重設 FIDO 應用程式';

  @override
  String get l_pin_blocked => 'PIN 碼已被封鎖';

  @override
  String get l_set_pin_first => '需要 PIN 碼';

  @override
  String get l_unlock_pin_first => '使用 PIN 碼解鎖';

  @override
  String get l_pin_soft_locked => 'PIN 碼已被封鎖，直到 YubiKey 被移除並重新插入';

  @override
  String get l_pin_change_required_desc => '必須設定新的 PIN 碼，才能使用此應用程式';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'PIN 碼的長度必須為 $min_length-$max_length 字元，並可包含字母、數字和特殊字符。';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'PIN 碼的長度必須是 $min_length-$max_length 字元，至少包含 $unique_characters 獨特字元，而且不能是常用的 PIN 碼，例如 \"$common_pin\"。它可以包含字母、數字和特殊字符。';
  }

  @override
  String get s_ep_attestation => '企業認證';

  @override
  String get s_ep_attestation_enabled => '企業驗證已啓用';

  @override
  String get q_enable_ep_attestation => '啟用企業驗證？';

  @override
  String get p_enable_ep_attestation_desc => '這將啟用企業認證，允許授權網域唯一識別您的 YubiKey。';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      '一旦啟用，企業認證只能透過執行 FIDO 工廠重設來停用。';

  @override
  String get s_pin_required => '需要 PIN 碼';

  @override
  String get p_pin_required_desc => '您要執行的動作需要輸入 PIV PIN。';

  @override
  String get l_piv_pin_blocked => '已封鎖，請使用 PUK 碼重設';

  @override
  String get p_piv_pin_blocked_desc => 'PIN 碼已被封鎖。使用 PUK 碼重設。';

  @override
  String get p_piv_pin_blocked_bio_desc => 'PIN 碼已被封鎖。需要出廠重設。';

  @override
  String get l_piv_pin_puk_blocked => '已封鎖，需要出廠重設';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'PIN 碼和 PUK 碼均被封鎖。需要對 PIV 應用程式進行出廠重設。';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name 的長度必須至少為 $length 字元。';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name 的長度必須至少為 $length 字元，至少包含 2 個獨特的字元，而且不能是常用的 $name，例如 \"$common\" 。';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return '新的 $name 不符合複雜性要求。';
  }

  @override
  String get s_dismiss => '放棄';

  @override
  String get p_default_pin_puk_key_desc => '建議變更預設 PIN 碼、PUK 碼和管理金鑰。';

  @override
  String get l_warning_default_pin => '警告：已使用預設 PIN 碼';

  @override
  String get l_warning_default_puk => '警告：使用預設 PUK 碼';

  @override
  String get l_default_pin_used => '使用的預設 PIN 碼';

  @override
  String get l_default_puk_used => '使用的預設 PUK 碼';

  @override
  String get l_pin_complexity => '已執行 PIN 碼複雜性';

  @override
  String get s_password => '密碼';

  @override
  String get s_manage_password => '管理密碼';

  @override
  String get s_set_password => '設定密碼';

  @override
  String get s_password_set => '密碼已設定';

  @override
  String get s_show_password => '顯示密碼';

  @override
  String get s_hide_password => '隱藏密碼';

  @override
  String get l_password_protection => '帳戶密碼保護';

  @override
  String get s_new_password => '新密碼';

  @override
  String get s_current_password => '目前密碼';

  @override
  String get s_confirm_password => '確認密碼';

  @override
  String get l_password_mismatch => '密碼不匹配';

  @override
  String get s_wrong_password => '密碼錯誤';

  @override
  String get p_wrong_password => '密碼錯誤如果您不知道您的密碼，您需要重新設定 YubiKey。';

  @override
  String get s_remove_password => '移除密碼';

  @override
  String get s_password_removed => '密碼已移除';

  @override
  String get s_remember_password => '記住密碼';

  @override
  String get s_clear_saved_password => '清除已儲存的密碼';

  @override
  String get s_password_forgotten => '忘記密碼';

  @override
  String get l_keystore_unavailable => '作業系統密鑰庫無法使用';

  @override
  String get l_remember_pw_failed => '無法記住密碼';

  @override
  String get l_unlock_first => '使用密碼解鎖';

  @override
  String get l_set_password_first => '設定密碼';

  @override
  String get l_enter_oath_pw => '輸入 YubiKey 的 OATH 密碼';

  @override
  String get p_new_password_requirements => '密碼可包含字母、數字和特殊字符。';

  @override
  String get s_management_key => '管理密鑰';

  @override
  String get s_current_management_key => '目前的管理密鑰';

  @override
  String get s_new_management_key => '新的管理密鑰';

  @override
  String get l_change_management_key => '變更管理密鑰';

  @override
  String get l_management_key_changed => '管理密鑰已變更';

  @override
  String get l_default_key_used => '使用的預設管理密鑰';

  @override
  String get s_generate_random => '隨機生成';

  @override
  String get s_use_default => '使用預設';

  @override
  String get l_warning_default_key => '警告：已使用預設密鑰';

  @override
  String get s_protect_key => '使用 PIN 碼保護';

  @override
  String get p_protect_key_desc => '在需要管理密鑰驗證的作業中，使用 PIN 碼代替管理密鑰。';

  @override
  String get s_management_key_algorithm => '管理密鑰演算法';

  @override
  String get p_management_key_algorithm_desc => '為管理密鑰選擇的演算法。';

  @override
  String get l_pin_protected_key => '可使用 PIN 碼代替';

  @override
  String get l_wrong_key => '錯誤的密鑰';

  @override
  String get l_unlock_piv_management => '解鎖 PIV 管理';

  @override
  String get p_unlock_piv_management_desc => '您將要執行的動作需要 PIV 管理密鑰。';

  @override
  String l_account(String label) {
    return '帳戶： $label';
  }

  @override
  String get s_accounts => '帳戶';

  @override
  String get s_no_accounts => '沒有帳戶';

  @override
  String l_results_for(String query) {
    return '\"$query”的結果 ';
  }

  @override
  String get l_authenticator_get_started => '開始使用 OTP 帳戶';

  @override
  String get l_no_accounts_desc => '從任何支援 OATH TOTP/HOTP 的服務供應商新增帳號至您的 YubiKey';

  @override
  String get s_add_account => '新增帳戶';

  @override
  String get p_add_account_desc => '掃描 QR 碼或手動輸入憑證詳細資料。';

  @override
  String get s_add_accounts => '新增帳戶(s)';

  @override
  String get l_drop_qr_description => '輸入 QR 碼以新增帳戶(s)';

  @override
  String get p_add_account_three_ways => '有三種新增帳號的方式。';

  @override
  String get s_scanning => '掃描 (建議)';

  @override
  String get p_scanning_desc => '掃描 QR 碼前，請確定完整的代碼在螢幕上可見。';

  @override
  String get s_drag_and_drop => '拖放';

  @override
  String get p_drag_and_drop_desc => '包含 QR 碼的圖片可以放置在「帳戶」檢視中的任何位置。';

  @override
  String get s_manually => '手動';

  @override
  String get p_manually_desc => '帳戶憑證詳細資訊可以手動輸入表格中。';

  @override
  String get s_account_added => '已新增帳戶';

  @override
  String l_account_add_failed(String message) {
    return '新增帳戶失敗： $message';
  }

  @override
  String get l_add_account_password_required => '需要密碼';

  @override
  String get l_add_account_unlock_required => '需要解鎖';

  @override
  String get l_add_account_func_missing => '功能遺失或停用';

  @override
  String get l_account_name_required => '您的帳戶必須有一個名稱';

  @override
  String get l_name_already_exists => '此發行人名稱已存在';

  @override
  String get l_account_already_exists => '此帳戶已存在於 YubiKey 上';

  @override
  String get l_invalid_character_issuer => '無效字元：發行人中不允許使用 \':\' 字元';

  @override
  String get l_select_accounts => '選擇要加入 YubiKey 的帳戶(s)';

  @override
  String get s_pin_account => '釘選帳戶';

  @override
  String get s_unpin_account => '取消釘選帳戶';

  @override
  String get s_no_pinned_accounts => '無釘選帳戶';

  @override
  String get s_pinned => '已釘選';

  @override
  String get l_pin_account_desc => '將您的重要帳戶放在一起';

  @override
  String get s_rename_account => '重新命名帳戶';

  @override
  String get l_rename_account_desc => '編輯帳戶的發行人/名稱';

  @override
  String get s_account_renamed => '帳戶重新命名';

  @override
  String l_rename_account_failed(String message) {
    return '重新命名帳戶失敗： $message';
  }

  @override
  String get p_rename_will_change_account_displayed => '這將會改變帳戶在清單中的顯示方式。';

  @override
  String get s_delete_account => '刪除帳戶';

  @override
  String get q_delete_account => '刪除帳戶？';

  @override
  String get l_delete_account_desc => '從您的 YubiKey 中移除帳戶';

  @override
  String get s_account_deleted => '帳戶已刪除';

  @override
  String get p_warning_delete_account => '警告！此動作將從您的 YubiKey 中刪除帳戶。';

  @override
  String get p_warning_disable_credential => '請確保從註冊的服務中停用此帳戶，以免被鎖定。';

  @override
  String get s_account_name => '帳戶名稱';

  @override
  String get s_search_accounts => '搜索帳戶';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used 使用的 $capacity 帳戶';
  }

  @override
  String s_num_digits(int num) {
    return '$num 位';
  }

  @override
  String s_num_sec(int num) {
    return '$num 秒';
  }

  @override
  String get s_issuer_optional => '發行人（可選）';

  @override
  String get s_counter_based => '基於計數器';

  @override
  String get s_time_based => '基於時間';

  @override
  String get l_copy_code_desc => '將程式碼貼到另一個應用程式中';

  @override
  String get l_calculate_code_desc => '從您的 YubiKey 取得新密碼';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => '用户 ID';

  @override
  String get s_credential_id => '憑證 ID';

  @override
  String get s_display_name => '顯示名稱';

  @override
  String get s_user_name => '用戶名稱';

  @override
  String get s_passkeys => '通行密鑰';

  @override
  String get s_no_passkeys => '無通行密鑰';

  @override
  String get l_ready_to_use => '準備好使用';

  @override
  String get l_register_sk_on_websites => '在網站上註冊為安全密鑰';

  @override
  String get l_no_discoverable_accounts => '未儲存密碼';

  @override
  String get p_non_passkeys_note => '非密匙憑證可能存在，但無法列出。';

  @override
  String get s_delete_passkey => '刪除通行密鑰';

  @override
  String get q_delete_passkey => '是否刪除通行密鑰？';

  @override
  String get l_delete_passkey_desc => '從 YubiKey 移除密鑰';

  @override
  String get s_passkey_deleted => '通行密鑰現已刪除';

  @override
  String get p_warning_delete_passkey => '警告！此動作會刪除 YubiKey 中通行密鑰。';

  @override
  String get p_warning_delete_passkey_desc => '您將無法再將此密鑰用於註冊服務。';

  @override
  String get s_search_passkeys => '搜尋通行密鑰';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used 使用的 $max 通行密鑰。';
  }

  @override
  String get s_biometrics => '生物特徵辨識';

  @override
  String l_fingerprint(String label) {
    return '指紋: $label';
  }

  @override
  String get s_fingerprints => '指紋';

  @override
  String get l_fingerprint_captured => '成功擷取指紋！';

  @override
  String get s_fingerprint_added => '指紋已添加';

  @override
  String l_adding_fingerprint_failed(String message) {
    return '新增指紋錯誤： $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return '錯誤設定名稱： $message';
  }

  @override
  String get s_setup_fingerprints => '設定指紋';

  @override
  String get p_setup_fingerprints_desc => '在使用密鑰前，必須先設定指紋。';

  @override
  String get s_add_fingerprint => '添加指紋';

  @override
  String get s_delete_fingerprint => '刪除指紋';

  @override
  String get q_delete_fingerprint => '要刪除指紋嗎？';

  @override
  String get l_delete_fingerprint_desc => '從 YubiKey 移除指紋';

  @override
  String get s_fingerprint_deleted => '指紋已刪除';

  @override
  String get p_warning_delete_fingerprint => '這將會刪除 YubiKey 中的指紋。';

  @override
  String get s_fingerprints_get_started => '開始使用指紋';

  @override
  String get p_set_fingerprints_desc => '在註冊指紋之前，必須先設定 PIN 碼。';

  @override
  String get l_no_fps_added => '未添加指紋';

  @override
  String get s_rename_fp => '重命名指紋';

  @override
  String get l_rename_fp_desc => '變更名稱';

  @override
  String get s_fingerprint_renamed => '指紋已重命名';

  @override
  String l_rename_fp_failed(String message) {
    return '重新命名錯誤： $message';
  }

  @override
  String get l_add_one_or_more_fps => '新增一個或更多（最多五個）指紋';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 指紋已註冊';
  }

  @override
  String get p_press_fingerprint_begin => '用手指按住 YubiKey 開始操作。';

  @override
  String get l_name_fingerprint => '命名此指紋';

  @override
  String get l_user_action_timeout_error => '由於使用者未活動而失敗';

  @override
  String get l_wrong_inserted_yk_error => '重新插入的 YubiKey 與初始裝置不匹配';

  @override
  String get l_failed_connecting_to_fido => '連線至 FIDO 介面失敗';

  @override
  String get l_self_signed_certificate => '自簽憑證';

  @override
  String get l_certificate_signing_request => '憑證簽章請求 (CSR)';

  @override
  String get s_certificate => '憑證';

  @override
  String get s_subject => '標題';

  @override
  String get l_export_csr_file => '將 CSR 儲存至檔案';

  @override
  String get l_export_public_key => '匯出公鑰';

  @override
  String get l_export_public_key_file => '儲存公鑰到檔案';

  @override
  String get l_export_public_key_desc => '匯出公鑰到檔案';

  @override
  String get l_public_key_exported => '已輸出的公鑰';

  @override
  String get l_export_certificate => '匯出憑證';

  @override
  String get l_export_certificate_file => '匯出憑證到檔案';

  @override
  String get l_export_certificate_desc => '將此憑證匯出到檔案';

  @override
  String get l_certificate_exported => '已輸出的憑證';

  @override
  String get l_select_import_file => '選擇要匯入的檔案';

  @override
  String get l_import_file => '匯入檔案';

  @override
  String get l_import_desc => '匯入金鑰及/或憑證';

  @override
  String get l_import_nothing => '沒有要匯入的內容';

  @override
  String get l_importing_file => '匯入檔案…';

  @override
  String get s_file_imported => '檔案已導入';

  @override
  String get l_unsupported_key_type => '不支援的金鑰類型';

  @override
  String get l_delete_certificate => '刪除憑證';

  @override
  String get q_delete_certificate => '刪除憑證嗎?';

  @override
  String get l_delete_certificate_desc => '從您的 YubiKey 移除憑證';

  @override
  String get l_delete_key => '刪除密鑰';

  @override
  String get q_delete_key => '刪除密鑰嗎?';

  @override
  String get l_delete_key_desc => '從您的 YubiKey 移除密鑰';

  @override
  String get l_delete_certificate_or_key => '刪除憑證/密鑰';

  @override
  String get q_delete_certificate_or_key => '刪除憑證/密鑰嗎？';

  @override
  String get l_delete_certificate_or_key_desc => '從您的 YubiKey 移除憑證或密鑰';

  @override
  String get l_move_key => '移動密鑰';

  @override
  String get l_move_key_desc => '將密鑰從一個 PIV 插槽移到另一個插槽中';

  @override
  String get l_change_defaults => '變更預設存取密碼';

  @override
  String get s_issuer => '發行者';

  @override
  String get s_serial => '序號';

  @override
  String get s_certificate_fingerprint => '指紋';

  @override
  String get s_valid_from => '有效期自';

  @override
  String get s_valid_to => '有效期至';

  @override
  String get l_no_certificate => '未載入憑證';

  @override
  String get l_key_no_certificate => '未載入憑證的密鑰';

  @override
  String get s_generate_key => '生成密鑰';

  @override
  String get l_generate_desc => '產生新的憑證或 CSR';

  @override
  String p_generate_desc(String slot) {
    return '這將在 YubiKey 的 PIV 插槽 $slot中生成一個新的密鑰。';
  }

  @override
  String get s_private_key_generated => '私人密鑰已生成';

  @override
  String get p_select_what_to_delete => '選擇要從插槽中刪除的內容。';

  @override
  String get p_warning_delete_certificate => '警告！此動作將從您的 YubiKey 中刪除帳戶。';

  @override
  String get p_warning_delete_key => '警告！此動作將從您的 YubiKey 中刪除私人密鑰。';

  @override
  String get p_warning_delete_certificate_and_key =>
      '警告！此動作將從您的 YubiKey 中刪除憑證和私人密鑰。';

  @override
  String p_delete_certificate_desc(String slot) {
    return '這將刪除 PIV 插槽 $slot中的憑證。';
  }

  @override
  String p_delete_key_desc(String slot) {
    return '這將刪除 PIV 插槽 $slot中的私人密鑰。';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return '這將刪除 PIV 插槽 $slot中的憑證和私人密鑰。';
  }

  @override
  String get l_certificate_deleted => '憑證已刪除';

  @override
  String get l_key_deleted => '密鑰已刪除';

  @override
  String get l_certificate_and_key_deleted => '憑證和密鑰已刪除';

  @override
  String get l_include_certificate => '包含憑證';

  @override
  String get l_select_destination_slot => '選擇目標插槽';

  @override
  String q_move_key_confirm(String from_slot) {
    return '移動 PIV 插槽中的私人密鑰 $from_slot？';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return '將 PIV 插槽 $from_slot 中的私鑰移至插槽 $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return '將 PIV 插槽 $from_slot 中的私人密鑰和憑證移至插槽 $to_slot？';
  }

  @override
  String get p_password_protected_file => '選取的檔案受到密碼保護。';

  @override
  String p_import_items_desc(String slot) {
    return '下列項目(s)將會匯入 PIV 插槽 $slot。';
  }

  @override
  String get l_warning_public_key_mismatch => '憑證的公鑰與插槽中的私人密鑰不符';

  @override
  String get l_key_moved => '密鑰已移動';

  @override
  String get l_key_and_certificate_moved => '移動密鑰與憑證';

  @override
  String get p_subject_desc => '依照 RFC 4514 規格格式化的識別名 (DN)。';

  @override
  String get l_rfc4514_invalid => '無效的 RFC 4514 格式';

  @override
  String get rfc4514_examples =>
      '範例：\nCN=Example 名稱\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => '允許使用指紋';

  @override
  String get s_pin_policy => 'PIN 碼政策';

  @override
  String get s_output_format => '輸出格式';

  @override
  String get s_expiration_date => '有效期至';

  @override
  String get p_algorithm_desc => '使用的密鑰演算法。';

  @override
  String get p_expiration_date_desc => '憑證到期的日期，預設為 1 年（僅限憑證）。';

  @override
  String get p_key_options_bio_desc => '允許使用生物辨識技術取代 PIN 碼。';

  @override
  String get q_overwrite_slot => '覆寫插槽？';

  @override
  String p_overwrite_slot_desc(String slot) {
    return '這將永久覆寫插槽 $slot中的現有內容。';
  }

  @override
  String get l_overwrite_cert => '憑證將被覆寫';

  @override
  String get l_overwrite_key => '私人密鑰將被覆寫';

  @override
  String get l_overwrite_key_maybe => '插槽中任何現有的私人密鑰都會被覆蓋';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => '身份驗證';

  @override
  String get s_slot_9c => '數位簽章';

  @override
  String get s_slot_9d => '密鑰管理';

  @override
  String get s_slot_9e => '卡片驗證';

  @override
  String get s_retired_slot => '退役密鑰管理';

  @override
  String get s_otp_slot_one => '短觸';

  @override
  String get s_otp_slot_two => '長按';

  @override
  String get l_otp_slot_empty => '插槽為空';

  @override
  String get l_otp_slot_configured => '插槽已設定';

  @override
  String get l_yubiotp_desc => '配置 Yubico OTP 憑證';

  @override
  String get s_challenge_response => '挑戰-回應';

  @override
  String get l_challenge_response_desc => '配置一個 挑戰-回應 憑證';

  @override
  String get s_static_password => '靜態密碼';

  @override
  String get l_static_password_desc => '設定靜態密碼';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => '配置基於 HMAC-SHA1 的憑證';

  @override
  String get s_public_id => '公開 ID';

  @override
  String get s_private_id => '私人 ID';

  @override
  String get s_use_serial => '使用序列號';

  @override
  String get l_select_file => '選擇檔案';

  @override
  String get l_no_export_file => '沒有檔案匯出';

  @override
  String get s_no_export => '無匯出';

  @override
  String get s_export => '匯出';

  @override
  String get l_export_configuration_file => '匯出配置至檔案';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return '匯出的憑證可上傳至 $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return '鍵盤 $layout';
  }

  @override
  String get s_delete_slot => '刪除憑證';

  @override
  String get q_delete_slot => '刪除憑證嗎？';

  @override
  String get l_delete_slot_desc => '移除插槽中的憑證';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return '警告！此操作將永久移除插槽 $slot_id中的憑證。';
  }

  @override
  String get l_slot_deleted => '憑證已刪除';

  @override
  String get s_swap => '交換';

  @override
  String get s_swap_slots => '交換插槽';

  @override
  String get q_swap_slots => '交換插槽嗎？';

  @override
  String get l_swap_slots_desc => '交換短/長觸控';

  @override
  String get p_swap_slots_desc => '這將交換兩個插槽的配置。';

  @override
  String get l_slots_swapped => '交換插槽配置';

  @override
  String l_slot_credential_configured(String type) {
    return '設定 $type 憑證';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return '設定 $type 憑證並匯出至 $file';
  }

  @override
  String get s_append_enter => '附加 ⏎';

  @override
  String get l_append_enter_desc => '在發出 OTP 後追加 Enter 鍵';

  @override
  String get p_otp_swap_error => '交換插槽失敗！請確定 YubiKey 沒有限制存取權限。';

  @override
  String get l_wrong_access_code => '存取碼錯誤';

  @override
  String get s_access_code => '存取碼';

  @override
  String get s_show_access_code => '顯示存取碼';

  @override
  String get s_hide_access_code => '隱藏存取碼';

  @override
  String p_enter_access_code(String slot) {
    return '輸入插槽的存取碼 $slot。';
  }

  @override
  String get s_enable_nfc => '啟用 NFC';

  @override
  String get s_request_access => '請求存取';

  @override
  String get s_permission_denied => '權限不足';

  @override
  String get l_elevating_permissions => '提升權限…';

  @override
  String get s_review_permissions => '審查權限';

  @override
  String get s_open_windows_settings => '開啟 Windows 設定';

  @override
  String get l_admin_privileges_required => '需要管理員許可權';

  @override
  String get p_elevated_permissions_required =>
      '管理此裝置需要提升權限。或者，您可以使用 Windows 設定來管理 FIDO 組態。';

  @override
  String get p_webauthn_elevated_permissions_required =>
      '管理此裝置需要提升權限。或者，您可以使用 Windows 設定來管理 FIDO 組態。';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator 需要相機權限才能掃描 QR 碼。';

  @override
  String get s_qr_scan => '掃描 QR 碼';

  @override
  String get l_invalid_qr => 'QR 碼無效';

  @override
  String get l_qr_not_found => '找不到 QR 碼';

  @override
  String get l_qr_scanned => '掃描 QR 碼';

  @override
  String l_qr_file_too_large(String max) {
    return '檔案太大 (max $max)';
  }

  @override
  String get l_qr_invalid_image_file => '無效影像檔案';

  @override
  String get l_qr_select_file => '選擇具有 QR 碼的檔案';

  @override
  String l_qr_not_read(String message) {
    return '讀取 QR 碼失敗：$message';
  }

  @override
  String get l_point_camera_scan => '將相機對準 QR 碼進行掃描';

  @override
  String get q_want_to_scan => '想要掃描嗎？';

  @override
  String get q_no_qr => '沒有 QR 碼嗎？';

  @override
  String get s_enter_manually => '手動輸入';

  @override
  String get s_read_from_file => '從檔案讀取';

  @override
  String get s_reset => '重置';

  @override
  String get s_factory_reset => '恢復原廠設定';

  @override
  String get l_factory_reset_desc => '還原 YubiKey 預設值';

  @override
  String get l_factory_reset_required => '需要出廠重設';

  @override
  String get l_oath_application_reset => 'OATH 應用程式重設';

  @override
  String get l_fido_app_reset => 'FIDO 應用程式重設';

  @override
  String l_reset_failed(String message) {
    return '執行重設時出錯： $message';
  }

  @override
  String get l_piv_app_reset => 'PIV 應用程式重設';

  @override
  String get p_factory_reset_an_app => '工廠重設 YubiKey 上的應用程式。';

  @override
  String get p_factory_reset_desc =>
      '資料儲存在 YubiKey 上的多個應用程式中，其中某些應用程式可獨立進行出廠重設。\n\n請選取上方的應用程式進行重設。';

  @override
  String get p_warning_factory_reset =>
      '警告！這將不可撤銷地從您的 YubiKey 中刪除所有 OATH TOTP/HOTP 帳戶。';

  @override
  String get p_warning_disable_credentials =>
      '您的 OATH 認證以及任何設定的密碼都會從此 YubiKey 中移除。請務必從其各自的網站停用這些功能，以免被鎖在您的帳戶之外。';

  @override
  String get p_warning_deletes_accounts =>
      '警告！這將不可撤銷地從您的 YubiKey 刪除所有 U2F 和 FIDO2 帳戶，包括密碼。';

  @override
  String get p_warning_disable_accounts =>
      '您的 OATH 認證以及任何設定的密碼都會從此 YubiKey 中移除。請務必從其各自的網站停用這些功能，以免被鎖在您的帳戶之外。';

  @override
  String get p_warning_piv_reset => '警告！為 PIV 儲存的所有資料將不可撤銷地從您的 YubiKey 中刪除。';

  @override
  String get p_warning_piv_reset_desc =>
      '這包括私人密鑰和憑證。您的 PIN 碼、PUK 碼和管理密鑰會重設為出廠預設值。';

  @override
  String get p_warning_global_reset => '警告！這將不可撤銷地從您的 YubiKey 刪除所有儲存的資料，包括憑證。';

  @override
  String get p_warning_global_reset_desc =>
      '出廠重設 YubiKey 上的應用程式。PIN 碼將被重設為出廠預設值，已註冊的指紋將被移除。任何密鑰、證書或其他憑證都會被永久移除。';

  @override
  String get l_copy_to_clipboard => '複製到剪貼簿';

  @override
  String get s_code_copied => '代碼已複製';

  @override
  String get l_code_copied_clipboard => '驗證碼已複製至剪貼簿';

  @override
  String get s_copy_log => '複製記錄檔';

  @override
  String get l_log_copied => '日誌已複製到剪貼簿';

  @override
  String get l_diagnostics_copied => '診斷資料複製到剪貼簿';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label 複製到剪貼簿。';
  }

  @override
  String get s_custom_icons => '自訂圖示';

  @override
  String get l_set_icons_for_accounts => '為帳戶設定圖示';

  @override
  String get p_custom_icons_description => '圖示包可以讓您的帳戶更容易以熟悉的標誌和顏色區分。';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return '圖示包使用 $aegis_icon_pack 格式。您可以下載預先製作好的圖示包，也可以自己製作。';
  }

  @override
  String get s_replace_icon_pack => '取代圖示包';

  @override
  String get l_loading_icon_pack => '載入圖示套件…';

  @override
  String get s_load_icon_pack => '載入圖示套件';

  @override
  String get s_remove_icon_pack => '移除圖示套件';

  @override
  String get l_icon_pack_removed => '移除圖示包';

  @override
  String get l_remove_icon_pack_failed => '移除圖示包出錯';

  @override
  String get s_choose_icon_pack => '選擇圖示包';

  @override
  String get l_icon_pack_imported => '匯入圖示包';

  @override
  String l_import_icon_pack_failed(String message) {
    return '匯入圖示套件出錯： $message';
  }

  @override
  String get l_invalid_icon_pack => '無效圖示套件';

  @override
  String get l_icon_pack_copy_failed => '複製圖示套件檔案失敗';

  @override
  String get l_do_nothing => '不執行任何動作';

  @override
  String get l_launch_ya => '啟動 Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => '複製 OTP 到剪貼簿';

  @override
  String get l_launch_and_copy_otp => '啟動應用程式並複製 OTP';

  @override
  String get l_kbd_layout_for_static => '鍵盤配置 (用於靜態密碼)';

  @override
  String get s_choose_kbd_layout => '選擇鍵盤配置';

  @override
  String get l_bypass_touch_requirement => '繞過觸控要求';

  @override
  String get l_bypass_touch_requirement_on => '需要觸控的帳號會透過 NFC 自動顯示';

  @override
  String get l_bypass_touch_requirement_off => '需要觸控的帳戶需要透過 NFC 額外點擊';

  @override
  String get s_silence_nfc_sounds => '靜音 NFC 聲音';

  @override
  String get l_silence_nfc_sounds_on => 'NFC 點按不會播放聲音';

  @override
  String get l_silence_nfc_sounds_off => '聲音會在 NFC 點選時播放';

  @override
  String get l_launch_app_on_usb_on => '這可防止其他應用程式透過 USB 使用 YubiKey';

  @override
  String get l_launch_app_on_usb_off => '其他應用程式可透過 USB 使用 YubiKey';

  @override
  String get s_allow_screenshots => '允許截圖';

  @override
  String get s_nfc_ready_to_scan => '準備掃描';

  @override
  String get s_nfc_hold_still => '保持不動…';

  @override
  String get s_nfc_tap_your_yubikey => '點選您的 YubiKey';

  @override
  String get l_nfc_failed_to_scan => '掃描失敗，請重試';

  @override
  String get s_usb_processing => '從 YubiKey 讀取資料';

  @override
  String get s_usb_dont_remove => '不要移除密鑰…';

  @override
  String get l_usb_read_error => '從 YubiKey 讀取資料失敗';

  @override
  String get p_ndef_set_otp => '成功將 OTP 代碼從 YubiKey 複製到剪貼簿。';

  @override
  String get p_ndef_set_password => '成功將密碼從 YubiKey 複製到剪貼簿。';

  @override
  String get p_ndef_parse_failure => '解析 YubiKey 的 OTP 代碼失敗。';

  @override
  String get p_ndef_set_clip_failure => '當嘗試從 YubiKey 複製 OTP 代碼時，存取剪貼簿失敗。';

  @override
  String get s_set_label => '設定標籤';

  @override
  String get s_set_color => '設定顏色';

  @override
  String get s_change_label => '變更標籤';

  @override
  String get p_set_will_add_custom_name => '這將為您的 YubiKey 自訂一個名稱。';

  @override
  String get p_rename_will_change_custom_name => '這將會變更 YubiKey 的標籤。';

  @override
  String get s_keyboard_shortcuts => '鍵盤快捷鍵';

  @override
  String get s_global_shortcuts => '全域快捷鍵';

  @override
  String get s_application_shortcuts => '應用程式捷徑';

  @override
  String s_quit_app(String app) {
    return '退出 $app';
  }

  @override
  String s_hide_app(String app) {
    return '隱藏 $app';
  }

  @override
  String get s_search => '搜尋';

  @override
  String get s_next_device => '下一個裝置';

  @override
  String get s_previous_device => '前一個裝置';

  @override
  String get s_open_settings => '開啟設定';

  @override
  String get s_open_item => '開啟項目';

  @override
  String get s_edit_item => '編輯項目';

  @override
  String get s_delete_item => '刪除項目';

  @override
  String get s_calculate_oath_code => '計算 OATH 代碼';

  @override
  String get s_open_keyboard_shortcuts => '開啟快捷鍵';
}
