// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class AppLocalizationsUk extends AppLocalizations {
  AppLocalizationsUk([String locale = 'uk']) : super(locale);

  @override
  String get app_name => 'Yubico  Authenticator';

  @override
  String get native_language_name => 'Українська';

  @override
  String s_translated(int percentage) {
    return 'Перекладено: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Схвалено: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Неповний переклад';

  @override
  String get p_translation_progress_desc =>
      'Індикатори відображають прогрес перекладу.';

  @override
  String get s_community => 'Спільнота';

  @override
  String get l_localization_project => 'Проєкт локалізації';

  @override
  String get s_save => 'Зберегти';

  @override
  String get s_cancel => 'Скасувати';

  @override
  String get s_close => 'Закрити';

  @override
  String get s_delete => 'Видалити';

  @override
  String get s_move => 'Перемістити';

  @override
  String get s_quit => 'Вийти';

  @override
  String get s_enable => 'Увімкнути';

  @override
  String get s_enabled => 'Увімкнено';

  @override
  String get s_disabled => 'Відключено';

  @override
  String get s_status => 'Статус';

  @override
  String get s_unlock => 'Розблокувати';

  @override
  String get s_calculate => 'Розрахувати';

  @override
  String get s_import => 'Імпортувати';

  @override
  String get s_overwrite => 'Перезаписати';

  @override
  String get s_done => 'Готово';

  @override
  String get s_success => 'Успіх';

  @override
  String get s_loading => 'Завантаження…';

  @override
  String get s_more => 'Більше';

  @override
  String get s_label => 'Мітка';

  @override
  String get s_name => 'Ім\'я';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Опції';

  @override
  String get s_details => 'Деталі';

  @override
  String get s_show_window => 'Показати вікно';

  @override
  String get s_hide_window => 'Приховати вікно';

  @override
  String get s_show_navigation => 'Показати навігацію';

  @override
  String get s_expand_navigation => 'Розгорнути панель навігації';

  @override
  String get s_collapse_navigation => 'Згорнути панель навігації';

  @override
  String get s_expand_collapse_navigation =>
      'Розгорнути/згорнути панель навігації';

  @override
  String get s_show_menu => 'Показати меню';

  @override
  String get s_toggle_menu_bar => 'Перемикання рядка меню';

  @override
  String get s_more_info => 'Більше інформації';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'Про програму';

  @override
  String get s_algorithm => 'Алгоритм';

  @override
  String get s_appearance => 'Зовнішній вигляд';

  @override
  String get s_actions => 'Дії';

  @override
  String get s_manage => 'Керувати';

  @override
  String get s_setup => 'Установка';

  @override
  String get s_device => 'Пристрій';

  @override
  String get s_application => 'Застосування';

  @override
  String get s_settings => 'Налаштування';

  @override
  String get s_reset_settings => 'Скинути налаштування';

  @override
  String get l_reset_settings_desc =>
      'Відновлення налаштувань до заводських значень';

  @override
  String get q_reset_settings => 'Скинути налаштування?';

  @override
  String get p_reset_settings_confirmation_desc =>
      'Це відновить усі налаштування до значень за замовчуванням.';

  @override
  String get s_support => 'Підтримка';

  @override
  String get s_certificates => 'Сертифікати';

  @override
  String get s_security_key => 'Ключ безпеки';

  @override
  String get s_slots => 'Слоти';

  @override
  String get s_help_and_about => 'Довідка та інформація';

  @override
  String get s_help => 'Допомога';

  @override
  String get s_app_information => 'Інформація про заявку';

  @override
  String get s_home => 'Головна';

  @override
  String get s_user_guide => 'Посібник користувача';

  @override
  String get s_i_need_help => 'Мені потрібна допомога';

  @override
  String get s_terms_of_use => 'Умови використання';

  @override
  String get s_privacy_policy => 'Політика конфіденційності';

  @override
  String get s_open_src_licenses => 'Ліцензії з відкритим кодом';

  @override
  String get s_please_wait => 'Будь ласка, зачекайте…';

  @override
  String get s_secret_key => 'Секретний ключ';

  @override
  String get s_show_secret_key => 'Показати секретний ключ';

  @override
  String get s_hide_secret_key => 'Приховати секретний ключ';

  @override
  String get s_private_key => 'Закритий ключ';

  @override
  String get s_public_key => 'Відкритий ключ';

  @override
  String get s_invalid_length => 'Недійсна довжина';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Недійсний формат, дозволені символи: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Недійсні символи для вибраної клавіатури';

  @override
  String get s_require_touch => 'Вимагати дотику';

  @override
  String get q_have_account_info => 'Маєте інформацію про обліковий запис?';

  @override
  String get s_debugging_tools => 'Інструменти налагодження';

  @override
  String get s_run_diagnostics => 'Виконати діагностику';

  @override
  String get l_run_diagnostics_desc =>
      'Виконайте діагностику для усунення несправностей';

  @override
  String get s_logging_level => 'Рівень журналу';

  @override
  String s_current_log_level(String level) {
    return 'Рівень журналу: $level';
  }

  @override
  String get s_character_count => 'Кількість символів';

  @override
  String get s_language => 'Мова';

  @override
  String get s_app_theme => 'Тема програми';

  @override
  String get s_system_default => 'Системні за замовчуванням';

  @override
  String get s_light_mode => 'Світлий режим';

  @override
  String get s_dark_mode => 'Темний режим';

  @override
  String get s_list_layout => 'Макет списку';

  @override
  String get s_grid_layout => 'Макет сітки';

  @override
  String get s_mixed_layout => 'Змішане планування';

  @override
  String get s_select_layout => 'Виберіть макет';

  @override
  String get s_select_to_scan => 'Виберіть для сканування';

  @override
  String get s_hide_reader => 'Приховати читача';

  @override
  String get s_show_hidden_readers => 'Показати прихованих читачів';

  @override
  String get s_toggle_readers => 'Перемикання читачів';

  @override
  String get l_toggle_readers_desc => 'Показати або приховати читачів';

  @override
  String s_sn_serial(int serial) {
    return 'Серійний номер:$serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'Прошивка: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Серійний номер: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Версія прошивки: $version';
  }

  @override
  String get l_fips_capable => 'Сумісний з FIPS';

  @override
  String get l_fips_approved => 'Схвалено FIPS';

  @override
  String get l_insert_yk => 'Вставте свій YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Вставте або торкніться YubiKey';

  @override
  String get l_unplug_yk => 'Від’єднайте свій YubiKey';

  @override
  String get l_reinsert_yk => 'Знову вставте свій YubiKey';

  @override
  String get l_place_on_nfc_reader =>
      'Прикладіть свій YubiKey до NFC-зчитувача';

  @override
  String get l_replace_yk_on_reader => 'Поверніть свій YubiKey на зчитувач';

  @override
  String get l_remove_yk_from_reader => 'Вийміть свій YubiKey зі зчитувача NFC';

  @override
  String get p_try_reinsert_yk =>
      'Спробуйте вийняти та знову вставити свій YubiKey.';

  @override
  String get s_touch_required => 'Потрібен дотик';

  @override
  String get l_touch_button_now => 'Натисніть кнопку на вашому YubiKey зараз';

  @override
  String get l_long_touch_button_now =>
      'Натисніть і утримуйте кнопку на вашому YubiKey протягом 10 секунд';

  @override
  String get l_keep_touching_yk =>
      'Продовжуйте торкатися свого YubiKey кілька разів…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'Аутентифікація YubiHSM';

  @override
  String get s_toggle_applications => 'Перемикання програм';

  @override
  String get s_toggle_interfaces => 'Перемикання інтерфейсів';

  @override
  String get p_toggle_applications_desc =>
      'Увімкнути або вимкнути програми через доступні транспортні мережі.';

  @override
  String get p_toggle_interfaces_desc =>
      'Увімкнути або вимкнути USB-інтерфейси.';

  @override
  String get l_toggle_applications_desc => 'Увімкнення/вимкнення програми';

  @override
  String get l_toggle_interfaces_desc => 'Увімкнення/вимкнення інтерфейсів';

  @override
  String get s_reconfiguring_yk => 'Переналаштування YubiKey…';

  @override
  String get s_config_updated => 'Конфігурацію оновлено';

  @override
  String get l_config_updated_reinsert =>
      'Конфігурацію оновлено, вийміть та знову вставте свій YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 вимкнено';

  @override
  String get l_webauthn_req_fido2 =>
      'Для WebAuthn потрібно ввімкнути застосунок FIDO2 на вашому YubiKey';

  @override
  String get s_lock_code => 'Код блокування';

  @override
  String get l_wrong_lock_code => 'Неправильний код блокування';

  @override
  String get s_show_lock_code => 'Показати код блокування';

  @override
  String get s_hide_lock_code => 'Приховати код блокування';

  @override
  String get p_lock_code_required_desc =>
      'Дія, яку ви збираєтеся виконати, вимагає введення коду блокування конфігурації.';

  @override
  String get l_helper_not_responding => 'Допоміжний процес не відповідає';

  @override
  String get l_yk_no_access => 'Цей YubiKey недоступний';

  @override
  String get s_yk_inaccessible => 'Пристрій недоступний';

  @override
  String get l_open_connection_failed => 'Не вдалося відкрити з\'єднання';

  @override
  String get l_ccid_connection_failed =>
      'Не вдалося відкрити підключення смарт-картки';

  @override
  String get p_ccid_service_unavailable =>
      'Переконайтеся, що ваш сервіс смарт-карт працює.';

  @override
  String get p_pcscd_unavailable =>
      'Переконайтеся, що pcscd встановлено та працює.';

  @override
  String get l_no_yk_present => 'YubiKey відсутній';

  @override
  String get s_unknown_type => 'Невідомий тип';

  @override
  String get s_unknown_device => 'Нерозпізнаний пристрій';

  @override
  String get s_restricted_nfc => 'Активація NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Як активувати NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Підключіть свій YubiKey до будь-якого джерела живлення USB, такого як комп\'ютер, щонайменше на 3 секунди.\n\nПісля підключення NFC активується та буде готовий до використання.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Ваш YubiKey оснащений функцією обмеженого NFC, призначеною для захисту від бездротових маніпуляцій під час транспортування. Це означає, що операції NFC тимчасово вимкнені, доки ви їх не активуєте.';

  @override
  String get s_unsupported_yk => 'Непідтримуваний YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'Операція не вдалася, спробуйте ще раз.';

  @override
  String get l_configuration_unsupported => 'Конфігурація не підтримується';

  @override
  String get p_scp_unsupported =>
      'Для зв\'язку через NFC YubiKey потрібна технологія, яка не підтримується цим телефоном. Будь ласка, підключіть YubiKey до USB-порту телефону.';

  @override
  String get l_error_occurred => 'Сталася помилка';

  @override
  String get s_application_error => 'Помилка програми';

  @override
  String get l_import_error => 'Помилка імпорту';

  @override
  String get l_file_not_found => 'Файл не знайдено';

  @override
  String get l_file_too_big => 'Розмір файлу занадто великий';

  @override
  String get l_filesystem_error => 'Помилка роботи файлової системи';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Встановити PIN-код';

  @override
  String get s_change_pin => 'Змінити PIN-код';

  @override
  String get s_change_puk => 'Змінити PUK-код';

  @override
  String get s_show_pin => 'Показати PIN-код';

  @override
  String get s_hide_pin => 'Приховати PIN-код';

  @override
  String get s_show_puk => 'Показати PUK';

  @override
  String get s_hide_puk => 'Приховати PUK-код';

  @override
  String get s_current_pin => 'Поточний PIN-код';

  @override
  String get s_current_puk => 'Поточний PUK-код';

  @override
  String get s_new_pin => 'Новий PIN-код';

  @override
  String get s_new_puk => 'Новий PUK-код';

  @override
  String get s_confirm_pin => 'Підтвердьте PIN-код';

  @override
  String get s_confirm_puk => 'Підтвердьте PUK-код';

  @override
  String get s_unblock_pin => 'Скинути PIN-код';

  @override
  String get l_pin_mismatch => 'PIN-коди не збігаються';

  @override
  String get l_puk_mismatch => 'PUK-коди не збігаються';

  @override
  String get s_pin_set => 'PIN-код встановлено';

  @override
  String get s_puk_set => 'Набір PUK-коду';

  @override
  String l_set_pin_failed(String message) {
    return 'Не вдалося встановити PIN-код:$message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries спроби, що залишилися',
      one: '$retries спроба залишилася',
      many: '$retries спроби, що залишилися',
      few: '$retries спроби, що залишилися',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries спроби, що залишилися',
      one: '$retries спроби, що залишилися',
      many: '$retries спроби, що залишилися',
      few: '$retries спроби, що залишилися',
    );
    return 'Неправильний PIN-код, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries спроби, що залишилися',
      one: '$retries спроби, що залишилися',
      many: '$retries спроби, що залишилися',
      few: '$retries спроби, що залишилися',
    );
    return 'Неправильний PUK-код, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Захист PIN-коду FIDO';

  @override
  String get s_pin_change_required => 'Потрібна зміна PIN-коду';

  @override
  String get l_enter_fido2_pin => 'Введіть PIN-код FIDO2 для вашого YubiKey';

  @override
  String get p_fido2_pin_required =>
      'Дія, яку ви збираєтеся виконати, вимагає введення PIN-коду FIDO2.';

  @override
  String get l_pin_blocked_reset =>
      'PIN-код заблоковано; скиньте налаштування програми FIDO до заводських';

  @override
  String get l_pin_blocked => 'ПІН-код заблоковано';

  @override
  String get l_set_pin_first => 'Потрібен PIN-код';

  @override
  String get l_unlock_pin_first => 'Розблокувати за допомогою PIN-коду';

  @override
  String get l_pin_soft_locked =>
      'ПІН-код заблоковано, доки YubiKey не буде вийнято та знову вставлено';

  @override
  String get l_pin_change_required_desc =>
      'Перш ніж ви зможете користуватися цією програмою, необхідно встановити новий PIN-код';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'PIN-код має містити $min_length-$max_length символів і може містити літери, цифри та спеціальні символи.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'PIN-код має містити $min_length-$max_length символів завдовжки, щонайменше $unique_characters унікальних символів і не бути поширеним PIN-кодом, як-от \"$common_pin\". Він може містити літери, цифри та спеціальні символи.';
  }

  @override
  String get s_ep_attestation => 'Атестація підприємства';

  @override
  String get s_ep_attestation_enabled => 'Атестацію підприємства ввімкнено';

  @override
  String get q_enable_ep_attestation => 'Увімкнути корпоративну атестацію?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Це активує корпоративну атестацію, що дозволить авторизованим доменам унікально ідентифікувати ваш YubiKey.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Після ввімкнення корпоративну атестацію можна вимкнути лише шляхом скидання налаштувань FIDO до заводських.';

  @override
  String get s_pin_required => 'Потрібен PIN-код';

  @override
  String get p_pin_required_desc =>
      'Дія, яку ви збираєтеся виконати, вимагає введення PIN-коду PIV.';

  @override
  String get l_piv_pin_blocked =>
      'Заблоковано, використовуйте PUK для скидання';

  @override
  String get p_piv_pin_blocked_desc =>
      'PIN-код заблоковано. Використайте PUK-код, щоб скинути його.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'PIN-код заблоковано. Потрібне скидання до заводських налаштувань.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Заблоковано, потрібне скидання до заводських налаштувань';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'PIN-код та PUK-код заблоковано. Потрібне скидання налаштувань програми PIV до заводських.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name має містити щонайменше $length символів.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name має містити щонайменше $length символів, щонайменше 2 унікальних символи та не бути поширеним $name, як-от \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Новий $name не відповідає вимогам складності.';
  }

  @override
  String get s_dismiss => 'Відхилити';

  @override
  String get p_default_pin_puk_key_desc =>
      'Рекомендується змінити PIN-код, PUK-код та ключ керування за замовчуванням.';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      'Для відповідності стандарту FIPS необхідно змінити PIN-код, PUK-код та ключ керування за замовчуванням.';

  @override
  String get l_warning_default_pin =>
      'Увага: Використано PIN-код за замовчуванням';

  @override
  String get l_warning_default_puk => 'Увага: Використано PUK за замовчуванням';

  @override
  String get l_default_pin_used => 'Використано PIN-код за замовчуванням';

  @override
  String get l_default_puk_used => 'Використано PUK за замовчуванням';

  @override
  String get l_pin_complexity => 'Застосовується складність PIN-коду';

  @override
  String get s_password => 'Пароль';

  @override
  String get s_manage_password => 'Керувати паролем';

  @override
  String get s_set_password => 'Встановити пароль';

  @override
  String get s_password_set => 'Пароль встановлено';

  @override
  String get s_show_password => 'Показати пароль';

  @override
  String get s_hide_password => 'Приховати пароль';

  @override
  String get l_password_protection => 'Захист облікових записів паролем';

  @override
  String get s_new_password => 'Новий пароль';

  @override
  String get s_current_password => 'Поточний пароль';

  @override
  String get s_confirm_password => 'Підтвердьте пароль';

  @override
  String get l_password_mismatch => 'Паролі не збігаються';

  @override
  String get s_wrong_password => 'Неправильний пароль';

  @override
  String get p_wrong_password =>
      'Неправильний пароль. Якщо ви не знаєте свій пароль, вам потрібно буде скинути налаштування YubiKey.';

  @override
  String get s_remove_password => 'Видалити пароль';

  @override
  String get s_password_removed => 'Пароль видалено';

  @override
  String get s_remember_password => 'Запам\'ятати пароль';

  @override
  String get s_clear_saved_password => 'Очистити збережений пароль';

  @override
  String get s_password_forgotten => 'Забули пароль';

  @override
  String get l_keystore_unavailable => 'Сховище ключів ОС недоступне';

  @override
  String get l_remember_pw_failed => 'Не вдалося згадати пароль';

  @override
  String get l_unlock_first => 'Розблокувати паролем';

  @override
  String get l_set_password_first => 'Встановити пароль';

  @override
  String get l_enter_oath_pw => 'Введіть пароль OATH для вашого YubiKey';

  @override
  String get p_new_password_requirements =>
      'Пароль може містити літери, цифри та спеціальні символи.';

  @override
  String get s_management_key => 'Ключ управління';

  @override
  String get s_current_management_key => 'Поточний ключ управління';

  @override
  String get s_new_management_key => 'Новий ключ управління';

  @override
  String get l_change_management_key => 'Ключ управління змінами';

  @override
  String get l_management_key_changed => 'Ключ керування змінено';

  @override
  String get l_default_key_used =>
      'Використано ключ керування за замовчуванням';

  @override
  String get s_generate_random => 'Генерувати випадкові';

  @override
  String get s_use_default => 'Використовувати за замовчуванням';

  @override
  String get l_warning_default_key =>
      'Попередження: Використано ключ за замовчуванням';

  @override
  String get s_protect_key => 'Захист за допомогою PIN-коду';

  @override
  String get p_protect_key_desc =>
      'Використовуйте PIN-код замість ключа керування під час операцій, що потребують автентифікації за допомогою ключа керування.';

  @override
  String get s_management_key_algorithm => 'Алгоритм ключа управління';

  @override
  String get p_management_key_algorithm_desc =>
      'Алгоритм вибору ключа керування.';

  @override
  String get l_pin_protected_key =>
      'Замість цього можна використовувати PIN-код';

  @override
  String get l_wrong_key => 'Неправильний ключ';

  @override
  String get l_unlock_piv_management => 'Розблокування керування PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'Дія, яку ви збираєтеся виконати, вимагає ключа керування PIV.';

  @override
  String l_account(String label) {
    return 'Обліковий запис: $label';
  }

  @override
  String get s_accounts => 'Облікові записи';

  @override
  String get s_no_accounts => 'Немає облікових записів';

  @override
  String l_results_for(String query) {
    return 'Результати для \"$query\"';
  }

  @override
  String get l_authenticator_get_started =>
      'Початок роботи з обліковими записами OTP';

  @override
  String get l_no_accounts_desc =>
      'Додайте облікові записи до свого YubiKey від будь-якого постачальника послуг, який підтримує OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Додати обліковий запис';

  @override
  String get p_add_account_desc =>
      'Відскануйте QR-код або введіть дані облікових даних вручну.';

  @override
  String get s_add_accounts => 'Додати обліковий запис(и)';

  @override
  String get l_drop_qr_description =>
      'Вставте QR-код, щоб додати обліковий запис(и)';

  @override
  String get p_add_account_three_ways =>
      'Існує три способи додавання облікових записів.';

  @override
  String get s_scanning => 'Сканування (рекомендовано)';

  @override
  String get p_scanning_desc =>
      'Перш ніж сканувати QR-код, переконайтеся, що повний код видно на екрані.';

  @override
  String get s_drag_and_drop => 'Перетягування';

  @override
  String get p_drag_and_drop_desc =>
      'Зображення з QR-кодом можна розмістити будь-де в області перегляду облікових записів.';

  @override
  String get s_manually => 'Вручну';

  @override
  String get p_manually_desc =>
      'Дані облікового запису можна ввести у форму вручну.';

  @override
  String get s_account_added => 'Обліковий запис додано';

  @override
  String l_account_add_failed(String message) {
    return 'Не вдалося додати обліковий запис:$message';
  }

  @override
  String get l_add_account_password_required => 'Потрібен пароль';

  @override
  String get l_add_account_unlock_required => 'Потрібне розблокування';

  @override
  String get l_add_account_func_missing =>
      'Функціональність відсутня або вимкнена';

  @override
  String get l_account_name_required =>
      'Ваш обліковий запис повинен мати ім\'я';

  @override
  String get l_name_already_exists => 'Це ім\'я вже існує для емітента';

  @override
  String get l_account_already_exists =>
      'Цей обліковий запис вже існує на YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Недійсний символ: \':\' не дозволено в емітенті';

  @override
  String get l_select_accounts =>
      'Виберіть обліковий запис(и) для додавання до YubiKey';

  @override
  String get s_pin_account => 'Закріпити обліковий запис';

  @override
  String get s_unpin_account => 'Відкріпити обліковий запис';

  @override
  String get s_no_pinned_accounts => 'Немає закріплених облікових записів';

  @override
  String get s_pinned => 'Закріплено';

  @override
  String get l_pin_account_desc => 'Тримайте важливі облікові записи разом';

  @override
  String get s_rename_account => 'Перейменувати обліковий запис';

  @override
  String get l_rename_account_desc => 'Редагувати емітента/назву рахунку';

  @override
  String get s_account_renamed => 'Обліковий запис перейменовано';

  @override
  String l_rename_account_failed(String message) {
    return 'Не вдалося перейменувати обліковий запис: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Це змінить спосіб відображення облікового запису у списку.';

  @override
  String get s_delete_account => 'Видалити обліковий запис';

  @override
  String get q_delete_account => 'Видалити обліковий запис?';

  @override
  String get l_delete_account_desc =>
      'Видаліть обліковий запис з вашого YubiKey';

  @override
  String get s_account_deleted => 'Обліковий запис видалено';

  @override
  String get p_warning_delete_account =>
      'Увага! Ця дія призведе до видалення облікового запису з вашого YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Обов’язково вимкніть цей обліковий запис у сервісі, в якому він зареєстрований, щоб уникнути блокування.';

  @override
  String get s_account_name => 'Ім\'я облікового запису';

  @override
  String get s_search_accounts => 'Пошук облікових записів';

  @override
  String l_accounts_used(int used, int capacity) {
    return 'Використано $used з $capacity облікових записів';
  }

  @override
  String s_num_digits(int num) {
    return '$num цифр';
  }

  @override
  String s_num_sec(int num) {
    return '$num сек';
  }

  @override
  String get s_issuer_optional => 'Емітент (необов\'язково)';

  @override
  String get s_counter_based => 'На основі лічильника';

  @override
  String get s_time_based => 'Залежно від часу';

  @override
  String get l_copy_code_desc => 'Вставте код в іншу програму';

  @override
  String get l_calculate_code_desc => 'Отримайте новий код з вашого YubiKey';

  @override
  String get s_rp_id => 'Ідентифікатор RP';

  @override
  String get s_user_id => 'Ідентифікатор користувача';

  @override
  String get s_credential_id => 'Ідентифікатор облікових даних';

  @override
  String get s_display_name => 'Відображуване ім\'я';

  @override
  String get s_user_name => 'Ім\'я користувача';

  @override
  String get s_passkeys => 'Ключі доступу';

  @override
  String get s_no_passkeys => 'Без ключів доступу';

  @override
  String get l_ready_to_use => 'Готовий до використання';

  @override
  String get l_register_sk_on_websites =>
      'Зареєструватися як ключ безпеки на вебсайтах';

  @override
  String get l_no_discoverable_accounts => 'Ключі доступу не збережено';

  @override
  String get p_non_passkeys_note =>
      'Облікові дані без ключа доступу можуть існувати, але їх не можна перерахувати.';

  @override
  String get s_delete_passkey => 'Видалити ключ доступу';

  @override
  String get q_delete_passkey => 'Видалити ключ доступу?';

  @override
  String get l_delete_passkey_desc => 'Видаліть ключ доступу з YubiKey';

  @override
  String get s_passkey_deleted => 'Ключ доступу видалено';

  @override
  String get p_warning_delete_passkey =>
      'Увага! Ця дія видалить ключ доступу з вашого YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Ви більше не зможете використовувати цей ключ доступу для служби, де він зареєстрований.';

  @override
  String get l_do_not_remove_yk_delete =>
      'Не видаляйте YubiKey під час видалення';

  @override
  String get s_search_passkeys => 'Пошук ключів доступу';

  @override
  String p_passkeys_used(int used, int max) {
    return 'Використано $used з $max ключів доступу.';
  }

  @override
  String get s_biometrics => 'Біометрія';

  @override
  String l_fingerprint(String label) {
    return 'Відбиток пальця: $label';
  }

  @override
  String get s_fingerprints => 'Відбитки пальців';

  @override
  String get l_fingerprint_captured => 'Відбиток пальця успішно знято!';

  @override
  String get s_fingerprint_added => 'Відбиток пальця додано';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Помилка додавання відбитка пальця: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Помилка налаштування імені: $message';
  }

  @override
  String get s_setup_fingerprints => 'Налаштування відбитків пальців';

  @override
  String get p_setup_fingerprints_desc =>
      'Перш ніж використовувати ключ, необхідно налаштувати відбитки пальців.';

  @override
  String get s_add_fingerprint => 'Додати відбиток пальця';

  @override
  String get s_delete_fingerprint => 'Видалити відбиток пальця';

  @override
  String get q_delete_fingerprint => 'Видалити відбиток пальця?';

  @override
  String get l_delete_fingerprint_desc => 'Видаліть відбиток пальця з YubiKey';

  @override
  String get s_fingerprint_deleted => 'Відбиток пальця видалено';

  @override
  String get p_warning_delete_fingerprint =>
      'Це видалить відбиток пальця з вашого YubiKey.';

  @override
  String get s_fingerprints_get_started =>
      'Почніть роботу з відбитками пальців';

  @override
  String get p_set_fingerprints_desc =>
      'Перш ніж можна буде зареєструвати відбитки пальців, потрібно встановити PIN-код.';

  @override
  String get l_no_fps_added => 'Відбитки пальців не додано';

  @override
  String get s_rename_fp => 'Перейменувати відбиток пальця';

  @override
  String get l_rename_fp_desc => 'Змінити назву';

  @override
  String get s_fingerprint_renamed => 'Відбиток пальця перейменовано';

  @override
  String l_rename_fp_failed(String message) {
    return 'Помилка перейменування: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Додайте один або декілька (до п\'яти) відбитків пальців';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 зареєстрованих відбитків пальців';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Натисніть пальцем на YubiKey, щоб розпочати.';

  @override
  String get l_name_fingerprint => 'Назвіть цей відбиток пальця';

  @override
  String get l_user_action_timeout_error =>
      'Не вдалося через неактивність користувача';

  @override
  String get l_wrong_inserted_yk_error =>
      'Повторно вставлений YubiKey не відповідає початковому пристрою';

  @override
  String get l_failed_connecting_to_fido =>
      'Не вдалося підключитися до інтерфейсу FIDO';

  @override
  String get l_self_signed_certificate => 'Самопідписаний сертифікат';

  @override
  String get l_certificate_signing_request =>
      'Запит на підпис сертифіката (CSR)';

  @override
  String get s_certificate => 'Сертифікат';

  @override
  String get s_subject => 'Тема';

  @override
  String get l_export_csr_file => 'Зберегти CSR у файл';

  @override
  String get l_export_public_key => 'Експортувати відкритий ключ';

  @override
  String get l_export_public_key_file => 'Зберегти відкритий ключ у файл';

  @override
  String get l_export_public_key_desc => 'Експортувати відкритий ключ у файл';

  @override
  String get l_public_key_exported => 'Експортовано відкритий ключ';

  @override
  String get l_export_certificate => 'Експортний сертифікат';

  @override
  String get l_export_certificate_file => 'Експорт сертифіката у файл';

  @override
  String get l_export_certificate_desc => 'Експортувати сертифікат у файл';

  @override
  String get l_certificate_exported => 'Сертифікат експортовано';

  @override
  String get l_select_import_file => 'Виберіть файл для імпорту';

  @override
  String get l_import_file => 'Імпортувати файл';

  @override
  String get l_import_desc => 'Імпорт ключа та/або сертифіката';

  @override
  String get l_import_nothing => 'Немає чого імпортувати';

  @override
  String get l_importing_file => 'Імпорт файлу…';

  @override
  String get s_file_imported => 'Файл імпортовано';

  @override
  String get l_unsupported_key_type => 'Непідтримуваний тип ключа';

  @override
  String get l_delete_certificate => 'Видалити сертифікат';

  @override
  String get q_delete_certificate => 'Видалити сертифікат?';

  @override
  String get l_delete_certificate_desc =>
      'Видаліть сертифікат з вашого YubiKey';

  @override
  String get l_delete_key => 'Видалити ключ';

  @override
  String get q_delete_key => 'Видалити ключ?';

  @override
  String get l_delete_key_desc => 'Вийміть ключ зі свого YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Видалити сертифікат/ключ';

  @override
  String get q_delete_certificate_or_key => 'Видалити сертифікат/ключ?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Видаліть сертифікат або ключ зі свого YubiKey';

  @override
  String get l_move_key => 'Перемістити ключ';

  @override
  String get l_move_key_desc => 'Переміщення ключа з одного слота PIV в інший';

  @override
  String get l_change_defaults => 'Зміна кодів доступу за замовчуванням';

  @override
  String get s_issuer => 'Емітент';

  @override
  String get s_serial => 'Серійний';

  @override
  String get s_certificate_fingerprint => 'Відбиток пальця';

  @override
  String get s_valid_from => 'Дійсний з';

  @override
  String get s_valid_to => 'Дійсний до';

  @override
  String get l_no_certificate => 'Сертифікат не завантажено';

  @override
  String get l_key_no_certificate => 'Ключ без завантаженого сертифіката';

  @override
  String get s_generate_key => 'Згенерувати ключ';

  @override
  String get l_generate_desc => 'Згенерувати новий сертифікат або CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Це згенерує новий ключ на слоті YubiKey у PIV $slot.';
  }

  @override
  String get s_private_key_generated => 'Згенеровано закритий ключ';

  @override
  String get p_select_what_to_delete => 'Виберіть, що видалити зі слота.';

  @override
  String get p_warning_delete_certificate =>
      'Увага! Ця дія видалить сертифікат з вашого YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Увага! Ця дія видалить закритий ключ з вашого YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Увага! Ця дія видалить сертифікат і закритий ключ з вашого YubiKey.';

  @override
  String get p_warning_usb_preferred =>
      'Для ключів RSA краще використовувати USB. NFC може призвести до помилок.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Це видалить сертифікат у слоті PIV $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Це видалить закритий ключ у слоті PIV $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Це видалить сертифікат і закритий ключ у слоті PIV $slot.';
  }

  @override
  String get l_certificate_deleted => 'Сертифікат видалено';

  @override
  String get l_key_deleted => 'Ключ видалено';

  @override
  String get l_certificate_and_key_deleted => 'Сертифікат і ключ видалено';

  @override
  String get l_include_certificate => 'Включити сертифікат';

  @override
  String get l_select_destination_slot => 'Виберіть слот призначення';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Перемістити закритий ключ у слот PIV $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Перемістити закритий ключ зі слота PIV $from_slot до слота $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Перемістити закритий ключ і сертифікат зі слота PIV $from_slot до слота $to_slot?';
  }

  @override
  String get p_password_protected_file => 'Вибраний файл захищено паролем.';

  @override
  String p_import_items_desc(String slot) {
    return 'Наступні елементи будуть імпортовані в слот PIV $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Відкритий ключ сертифіката не збігається із закритим ключем у слоті';

  @override
  String get l_key_moved => 'Ключ переміщено';

  @override
  String get l_key_and_certificate_moved => 'Ключ і сертифікат переміщено';

  @override
  String get p_subject_desc =>
      'Визначне ім\'я (DN), відформатоване відповідно до специфікації RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Недійсний формат RFC 4514';

  @override
  String get rfc4514_examples =>
      'Приклади:\nCN=Приклад назви\nCN=jsmith,DC=приклад,DC=net';

  @override
  String get s_allow_fingerprint => 'Дозволити відбиток пальця';

  @override
  String get s_pin_policy => 'Політика щодо PIN-кодів';

  @override
  String get s_output_format => 'Вихідний формат';

  @override
  String get s_expiration_date => 'Термін дії';

  @override
  String get p_algorithm_desc => 'Ключовий алгоритм для використання.';

  @override
  String get p_expiration_date_desc =>
      'Дата закінчення терміну дії сертифіката, за замовчуванням 1 рік (лише для сертифіката).';

  @override
  String get p_key_options_bio_desc =>
      'Дозволити використання біометричних даних замість PIN-коду.';

  @override
  String get q_overwrite_slot => 'Перезаписати слот?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Це назавжди перезапише існуючий вміст у слоті $slot.';
  }

  @override
  String get l_overwrite_cert => 'Сертифікат буде перезаписано';

  @override
  String get l_overwrite_key => 'Закритий ключ буде перезаписано';

  @override
  String get l_overwrite_key_maybe =>
      'Будь-який існуючий закритий ключ у слоті буде перезаписано';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Автентифікація';

  @override
  String get s_slot_9c => 'Цифровий підпис';

  @override
  String get s_slot_9d => 'Управління ключами';

  @override
  String get s_slot_9e => 'Автентифікація картки';

  @override
  String get s_retired_slot => 'Керування ключами, що вийшло з експлуатації';

  @override
  String get s_otp_slot_one => 'Короткий дотик';

  @override
  String get s_otp_slot_two => 'Довгий дотик';

  @override
  String get l_otp_slot_empty => 'Слот порожній';

  @override
  String get l_otp_slot_configured => 'Слот налаштовано';

  @override
  String get l_yubiotp_desc => 'Запрограмуйте облікові дані Yubico OTP';

  @override
  String get s_challenge_response => 'Виклик-відповідь';

  @override
  String get l_challenge_response_desc =>
      'Запрограмуйте облікові дані для запиту та відповіді';

  @override
  String get s_static_password => 'Статичний пароль';

  @override
  String get l_static_password_desc => 'Налаштуйте статичний пароль';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Запрограмуйте облікові дані на основі HMAC-SHA1';

  @override
  String get s_public_id => 'Публічний ідентифікатор';

  @override
  String get s_private_id => 'Приватне посвідчення особи';

  @override
  String get s_use_serial => 'Використовуйте серійний номер';

  @override
  String get l_select_file => 'Вибрати файл';

  @override
  String get l_no_export_file => 'Немає файлу експорту';

  @override
  String get s_no_export => 'Експорт заборонено';

  @override
  String get s_export => 'Експорт';

  @override
  String get l_export_configuration_file => 'Експорт конфігурації у файл';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Експортовані облікові дані можна завантажити за адресою $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Розкладка клавіатури $layout';
  }

  @override
  String get s_delete_slot => 'Видалити облікові дані';

  @override
  String get q_delete_slot => 'Видалити облікові дані?';

  @override
  String get l_delete_slot_desc => 'Видалити облікові дані з гнізда';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Увага! Ця дія назавжди видалить облікові дані зі слота $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Облікові дані видалено';

  @override
  String get s_swap => 'Обмін';

  @override
  String get s_swap_slots => 'Поміняйте слоти';

  @override
  String get q_swap_slots => 'Поміняти місцями слоти?';

  @override
  String get l_swap_slots_desc => 'Поміняти місцями короткий/довгий дотик';

  @override
  String get p_swap_slots_desc => 'Це змінить конфігурацію двох слотів.';

  @override
  String get l_slots_swapped => 'Конфігурації слотів помінялися місцями';

  @override
  String l_slot_credential_configured(String type) {
    return 'Налаштовані облікові дані $type';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Налаштовано облікові дані $type та експортовано до $file';
  }

  @override
  String get s_append_enter => 'Додати ⏎';

  @override
  String get l_append_enter_desc =>
      'Додати натискання клавіші Enter після введення одноразового пароля OTP';

  @override
  String get p_otp_swap_error =>
      'Не вдалося поміняти місцями слоти! Переконайтеся, що YubiKey не має обмеженого доступу.';

  @override
  String get l_wrong_access_code => 'Неправильний код доступу';

  @override
  String get s_access_code => 'Код доступу';

  @override
  String get s_show_access_code => 'Показати код доступу';

  @override
  String get s_hide_access_code => 'Приховати код доступу';

  @override
  String p_enter_access_code(String slot) {
    return 'Введіть код доступу для слота $slot.';
  }

  @override
  String get s_enable_nfc => 'Увімкнути NFC';

  @override
  String get s_request_access => 'Запит доступу';

  @override
  String get s_permission_denied => 'Дозвіл відхилено';

  @override
  String get l_elevating_permissions => 'Підвищення дозволів…';

  @override
  String get s_review_permissions => 'Перегляд дозволів';

  @override
  String get s_open_windows_settings => 'Відкрийте параметри Windows';

  @override
  String get l_admin_privileges_required => 'Потрібні права адміністратора';

  @override
  String get p_elevated_permissions_required =>
      'Для керування цим пристроєм потрібні підвищені права. Або ж ви можете скористатися параметрами Windows для керування конфігурацією FIDO.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'Для керування WebAuthn потрібні підвищені права. Або ж ви можете скористатися параметрами Windows для керування конфігурацією FIDO.';

  @override
  String get p_ms_store_permission_note =>
      'Версія програми з Microsoft Store зазвичай не може підвищувати дозволи через обмеження ізольованого програмного середовища Windows. Ми рекомендуємо встановити Yubico Authenticator з нашого офіційного інсталятора .msi.';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator потребує доступу до камери для сканування QR-кодів.';

  @override
  String get s_qr_scan => 'Відскануйте QR-код';

  @override
  String get l_invalid_qr => 'Недійсний QR-код';

  @override
  String get l_qr_not_found => 'QR-код не знайдено';

  @override
  String get l_qr_scanned => 'Відсканований QR-код';

  @override
  String l_qr_file_too_large(String max) {
    return 'Файл занадто великий (max $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Недійсний файл зображення';

  @override
  String get l_qr_select_file => 'Виберіть файл за допомогою QR-коду';

  @override
  String l_qr_not_read(String message) {
    return 'Не вдалося прочитати QR-код: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Наведіть камеру на QR-код, щоб відсканувати його';

  @override
  String get q_want_to_scan => 'Хочете просканувати?';

  @override
  String get q_no_qr => 'Немає QR-коду?';

  @override
  String get s_enter_manually => 'Ввести вручну';

  @override
  String get s_read_from_file => 'Читати з файлу';

  @override
  String get s_reset => 'Скинути';

  @override
  String get s_factory_reset => 'Скидання до заводських налаштувань';

  @override
  String get l_factory_reset_desc =>
      'Відновлення налаштувань YubiKey за замовчуванням';

  @override
  String get l_factory_reset_required =>
      'Потрібне скидання до заводських налаштувань';

  @override
  String get l_oath_application_reset => 'Скидання налаштувань програми OATH';

  @override
  String get l_fido_app_reset => 'Скидання програми FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Помилка під час скидання налаштувань: $message';
  }

  @override
  String get l_piv_app_reset => 'Скидання програми PIV';

  @override
  String get p_factory_reset_an_app =>
      'Скидання налаштувань програми на вашому YubiKey до заводських.';

  @override
  String get p_factory_reset_desc =>
      'Дані зберігаються в кількох програмах на YubiKey, деякі з яких можна скинути до заводських налаштувань незалежно одна від одної.\n\nВиберіть програму вище для скидання.';

  @override
  String get p_warning_factory_reset =>
      'Виберіть програму вище для скидання налаштувань.';

  @override
  String get p_warning_disable_credentials =>
      'Ваші облікові дані OATH, а також будь-який встановлений пароль будуть видалені з цього YubiKey. Обов’язково вимкніть їх на відповідних веб-сайтах, щоб уникнути блокування ваших облікових записів.';

  @override
  String get p_warning_deletes_accounts =>
      'Увага! Це безповоротно видалить усі облікові записи U2F та FIDO2, включаючи ключі доступу, з вашого YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Ваші облікові дані, а також будь-який встановлений PIN-код будуть видалені з цього YubiKey. Обов’язково вимкніть їх на відповідних веб-сайтах, щоб уникнути блокування ваших облікових записів.';

  @override
  String l_reset_not_allowed_over(String transport) {
    return 'Скидання FIDO вимкнено через $transport';
  }

  @override
  String get p_warning_piv_reset =>
      'Увага! Усі дані, що зберігаються для PIV, будуть безповоротно видалені з вашого YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'Це включає закриті ключі та сертифікати. Ваші PIN-код, PUK-код і ключ керування будуть скинуті до заводських значень за замовчуванням.';

  @override
  String get p_warning_global_reset =>
      'Увага! Це безповоротно видалить усі збережені дані, включаючи облікові дані, з вашого YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Скиньте налаштування програм на вашому YubiKey до заводських. PIN-код буде скинуто до заводського значення за замовчуванням, а зареєстровані відбитки пальців будуть видалені. Будь-які ключі, сертифікати чи інші облікові дані будуть видалені назавжди.';

  @override
  String get l_copy_to_clipboard => 'Копіювати в буфер обміну';

  @override
  String get s_code_copied => 'Код скопійовано';

  @override
  String get l_code_copied_clipboard => 'Код скопійовано в буфер обміну';

  @override
  String get s_copy_log => 'Копіювати журнал';

  @override
  String get l_copy_log_clipboard => 'Копіювати журнал у буфер обміну';

  @override
  String get l_log_copied => 'Журнал скопійовано в буфер обміну';

  @override
  String get l_diagnostics_copied =>
      'Діагностичні дані скопійовано в буфер обміну';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label скопійовано в буфер обміну.';
  }

  @override
  String get s_custom_icons => 'Користувацькі значки';

  @override
  String get l_set_icons_for_accounts =>
      'Встановіть значки для облікових записів';

  @override
  String get p_custom_icons_description =>
      'Пакети значків можуть зробити ваші облікові записи простішими.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Пакети значків використовують формат $aegis_icon_pack. Ви можете завантажити готовий пакет значків або створити свій власний.';
  }

  @override
  String get s_replace_icon_pack => 'Замінити пакет значків';

  @override
  String get l_loading_icon_pack => 'Завантаження пакета значків…';

  @override
  String get s_load_icon_pack => 'Завантажити пакет значків';

  @override
  String get l_load_icon_pack_desc => 'Завантажити пакет значків з файлу';

  @override
  String get s_remove_icon_pack => 'Видалити пакет значків';

  @override
  String get l_remove_icon_pack_desc => 'Видалити активний пакет значків';

  @override
  String get l_icon_pack_removed => 'Пакет значків видалено';

  @override
  String get l_remove_icon_pack_failed => 'Помилка видалення пакета значків';

  @override
  String get s_choose_icon_pack => 'Виберіть пакет значків';

  @override
  String get l_icon_pack_imported => 'Пакет значків імпортовано';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Помилка імпорту пакета значків: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Недійсний пакет значків';

  @override
  String get l_icon_pack_copy_failed =>
      'Не вдалося скопіювати файли пакета значків';

  @override
  String get s_nfc_and_usb_options => 'Опції NFC та USB';

  @override
  String get l_nfc_and_usb_options_desc => 'Налаштувати дію для YubiKey';

  @override
  String get l_on_yk_nfc_tap => 'Увімкнено NFC-дотик';

  @override
  String get l_on_yk_usb_insert => 'Увімкнено USB-вставка';

  @override
  String get l_do_nothing => 'Нічого не робити';

  @override
  String get l_launch_ya => 'Запустіть Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard =>
      'Копіювати одноразовий пароль OTP у буфер обміну';

  @override
  String get l_launch_and_copy_otp => 'Запустіть програму та скопіюйте OTP';

  @override
  String get l_kbd_layout_for_static =>
      'Розкладка клавіатури (для статичного пароля)';

  @override
  String get s_choose_kbd_layout => 'Виберіть розкладку клавіатури';

  @override
  String get l_bypass_touch_requirement => 'Вимога обходу дотику';

  @override
  String get l_bypass_touch_requirement_on =>
      'Облікові записи, що потребують дотику, автоматично відображаються через NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Облікові записи, що потребують дотику, потребують додаткового дотику через NFC';

  @override
  String get s_silence_nfc_sounds => 'Вимкнення звуків NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'При дотику NFC звуки не відтворюватимуться';

  @override
  String get l_silence_nfc_sounds_off =>
      'Звук відтворюватиметься при дотику до NFC';

  @override
  String get l_launch_app_on_usb_on =>
      'Це запобігає використанню YubiKey іншими програмами через USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Інші програми можуть використовувати YubiKey через USB';

  @override
  String get s_allow_screenshots => 'Дозволити скріншоти';

  @override
  String get l_allow_screenshots_desc =>
      'Дозволити іншим програмам робити знімки екрана';

  @override
  String get s_nfc_ready_to_scan => 'Готовий до сканування';

  @override
  String get s_nfc_hold_still => 'Тримайся нерухомо…';

  @override
  String get s_nfc_tap_your_yubikey => 'Торкніться свого YubiKey';

  @override
  String get s_nfc_remove_key => 'Видалити YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Не вдалося сканувати, спробуйте ще раз';

  @override
  String get s_usb_processing => 'Зчитування даних з YubiKey';

  @override
  String get s_usb_dont_remove => 'Не виймай ключ…';

  @override
  String get l_usb_read_error => 'Не вдалося прочитати дані з YubiKey';

  @override
  String get p_ndef_set_otp =>
      'Код OTP успішно скопійовано з YubiKey в буфер обміну.';

  @override
  String get p_ndef_set_password =>
      'Пароль успішно скопійовано з YubiKey в буфер обміну.';

  @override
  String get p_ndef_parse_failure => 'Не вдалося розібрати код OTP з YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Не вдалося отримати доступ до буфера обміну під час спроби копіювання коду OTP з YubiKey.';

  @override
  String get s_set_label => 'Встановити мітку';

  @override
  String get s_set_color => 'Встановити колір';

  @override
  String get s_change_label => 'Змінити мітку';

  @override
  String get p_set_will_add_custom_name =>
      'Це надасть вашому YubiKey власну назву.';

  @override
  String get p_rename_will_change_custom_name =>
      'Це змінить мітку вашого YubiKey.';

  @override
  String get s_keyboard_shortcuts => 'Комбінації клавіш';

  @override
  String get s_global_shortcuts => 'Глобальні скорочення';

  @override
  String get s_application_shortcuts => 'Ярлики програм';

  @override
  String s_quit_app(String app) {
    return 'Закрити $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Приховати $app';
  }

  @override
  String get s_search => 'Пошук';

  @override
  String get s_next_device => 'Наступний пристрій';

  @override
  String get s_previous_device => 'Попередній пристрій';

  @override
  String get s_open_settings => 'Відкрити налаштування';

  @override
  String get s_open_item => 'Відкрити елемент';

  @override
  String get s_edit_item => 'Редагувати елемент';

  @override
  String get s_delete_item => 'Видалити елемент';

  @override
  String get s_calculate_oath_code => 'Розрахувати код OATH';

  @override
  String get s_open_keyboard_shortcuts => 'Відкрити комбінації клавіш';
}
