// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Slovak (`sk`).
class AppLocalizationsSk extends AppLocalizations {
  AppLocalizationsSk([String locale = 'sk']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Slovenčina';

  @override
  String s_translated(int percentage) {
    return 'Preložené: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Schválené: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Neúplný preklad';

  @override
  String get p_translation_progress_desc =>
      'Ukazovatele pokroku odrážajú úroveň prekladu.';

  @override
  String get s_community => 'Komunita';

  @override
  String get l_localization_project => 'Projekt lokalizácie';

  @override
  String get s_save => 'Uložiť';

  @override
  String get s_cancel => 'Zrušiť';

  @override
  String get s_close => 'Zavrieť';

  @override
  String get s_delete => 'Vymazať';

  @override
  String get s_move => 'Presunúť';

  @override
  String get s_quit => 'Ukončiť';

  @override
  String get s_enable => 'Povoliť';

  @override
  String get s_enabled => 'Povolené';

  @override
  String get s_disabled => 'Zakázané';

  @override
  String get s_status => 'Stav';

  @override
  String get s_unlock => 'Odomknúť';

  @override
  String get s_calculate => 'Vypočítať';

  @override
  String get s_import => 'Importovať';

  @override
  String get s_overwrite => 'Prepísať';

  @override
  String get s_done => 'Hotovo';

  @override
  String get s_success => 'Hotovo';

  @override
  String get s_loading => 'Načítava sa…';

  @override
  String get s_more => 'Viac';

  @override
  String get s_label => 'Menovka';

  @override
  String get s_name => 'Názov';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Možnosti';

  @override
  String get s_details => 'Podrobnosti';

  @override
  String get s_show_window => 'Zobraziť okno';

  @override
  String get s_hide_window => 'Skryť okno';

  @override
  String get s_show_navigation => 'Zobraziť navigáciu';

  @override
  String get s_expand_navigation => 'Rozbaliť navigačný panel';

  @override
  String get s_collapse_navigation => 'Zbaliť navigačný panel';

  @override
  String get s_expand_collapse_navigation => 'Rozbaliť/zbaliť navigačný panel';

  @override
  String get s_show_menu => 'Zobraziť ponuku';

  @override
  String get s_toggle_menu_bar => 'Prepnúť panel ponuky';

  @override
  String get s_more_info => 'Viac informácií';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'O aplikácii';

  @override
  String get s_algorithm => 'Algoritmus';

  @override
  String get s_appearance => 'Vzhľad';

  @override
  String get s_actions => 'Akcie';

  @override
  String get s_manage => 'Spravovať';

  @override
  String get s_setup => 'Nastaviť';

  @override
  String get s_device => 'Zariadenie';

  @override
  String get s_application => 'Aplikácia';

  @override
  String get s_settings => 'Nastavenia';

  @override
  String get s_reset_settings => 'Obnoviť nastavenia';

  @override
  String get l_reset_settings_desc => 'Obnoviť nastavenia na predvolené';

  @override
  String get q_reset_settings => 'Obnoviť nastavenia?';

  @override
  String get p_reset_settings_confirmation_desc =>
      'Týmto sa obnovia všetky nastavenia na predvolené hodnoty.';

  @override
  String get s_support => 'Podpora';

  @override
  String get s_certificates => 'Certifikáty';

  @override
  String get s_security_key => 'Bezpečnostný kľúč';

  @override
  String get s_slots => 'Sloty';

  @override
  String get s_help_and_about => 'Pomoc a o aplikácii';

  @override
  String get s_help => 'Pomoc';

  @override
  String get s_app_information => 'Informácie o aplikácii';

  @override
  String get s_home => 'Domov';

  @override
  String get s_user_guide => 'Používateľská príručka';

  @override
  String get s_i_need_help => 'Potrebujem pomoc';

  @override
  String get s_terms_of_use => 'Podmienky používania';

  @override
  String get s_privacy_policy => 'Zásady ochrany osobných údajov';

  @override
  String get s_open_src_licenses => 'Licencie otvoreného zdrojového kódu';

  @override
  String get s_please_wait => 'Prosím čakajte…';

  @override
  String get s_secret_key => 'Tajný kľúč';

  @override
  String get s_show_secret_key => 'Zobraziť tajný kľúč';

  @override
  String get s_hide_secret_key => 'Skryť tajný kľúč';

  @override
  String get s_private_key => 'Súkromný kľúč';

  @override
  String get s_public_key => 'Verejný kľúč';

  @override
  String get s_invalid_length => 'Neplatná dĺžka';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Neplatný formát, povolené znaky: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Neplatné znaky pre vybranú klávesnicu';

  @override
  String get s_require_touch => 'Vyžadovať dotyk';

  @override
  String get q_have_account_info => 'Máte informácie o účte?';

  @override
  String get s_debugging_tools => 'Nástroje na odstraňovanie chýb';

  @override
  String get s_run_diagnostics => 'Spustiť diagnostiku';

  @override
  String get l_run_diagnostics_desc =>
      'Spustiť diagnostiku na odstránenie problémov';

  @override
  String get s_logging_level => 'Úroveň záznamu';

  @override
  String s_current_log_level(String level) {
    return 'Úroveň záznamu: $level';
  }

  @override
  String get s_character_count => 'Počet znakov';

  @override
  String get s_language => 'Jazyk';

  @override
  String get s_app_theme => 'Téma aplikácie';

  @override
  String get s_system_default => 'Predvolená systémová';

  @override
  String get s_light_mode => 'Svetlý režim';

  @override
  String get s_dark_mode => 'Tmavý režim';

  @override
  String get s_list_layout => 'Vzhľad ako zoznam';

  @override
  String get s_grid_layout => 'Vzhľad ako mriežka';

  @override
  String get s_mixed_layout => 'Zmiešané rozloženie';

  @override
  String get s_select_layout => 'Vybrať rozloženie';

  @override
  String get s_select_to_scan => 'Vyberte na skenovanie';

  @override
  String get s_hide_reader => 'Skryť čítačku';

  @override
  String get s_show_hidden_readers => 'Zobraziť skryté čítačky';

  @override
  String get s_toggle_readers => 'Prepnúť čítačky';

  @override
  String get l_toggle_readers_desc => 'Zobraziť alebo skryť čítačky';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Sériové číslo: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Verzia firmvéru: $version';
  }

  @override
  String get l_fips_capable => 'Schopné využívať FIPS';

  @override
  String get l_fips_approved => 'Schválené FIPS';

  @override
  String get l_insert_yk => 'Vložte svoj kľúč YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Vložte alebo ťuknite na tlačidlo YubiKey';

  @override
  String get l_unplug_yk => 'Odpojte svoj YubiKey';

  @override
  String get l_reinsert_yk => 'Opätovne vložte svoj YubiKey';

  @override
  String get l_place_on_nfc_reader => 'Umiestnite svoj YubiKey na čítačku NFC';

  @override
  String get l_replace_yk_on_reader =>
      'Umiestnite kľúč YubiKey späť na čítačku';

  @override
  String get l_remove_yk_from_reader =>
      'Odoberte svoj kľúč YubiKey z čítačky NFC';

  @override
  String get p_try_reinsert_yk => 'Skúste vybrať a znovu vložiť kľúč YubiKey.';

  @override
  String get s_touch_required => 'Vyžaduje sa dotyk';

  @override
  String get l_touch_button_now =>
      'Teraz sa dotknite tlačidla na svojom YubiKey';

  @override
  String get l_long_touch_button_now =>
      'Teraz stlačte a podržte tlačidlo na vašom YubiKey po dobu 10 sekúnd';

  @override
  String get l_keep_touching_yk => 'Opakovane sa dotýkajte tlačidla YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Aktivácia aplikácií';

  @override
  String get s_toggle_interfaces => 'Prepínanie rozhraní';

  @override
  String get p_toggle_applications_desc =>
      'Povoliť alebo zakázať aplikácie cez dostupné spôsoby prenosu.';

  @override
  String get p_toggle_interfaces_desc => 'Povoliť alebo zakázať USB rozhrania.';

  @override
  String get l_toggle_applications_desc => 'Povoliť/zakázať aplikácie';

  @override
  String get l_toggle_interfaces_desc => 'Povoliť/zakázať rozhrania';

  @override
  String get s_reconfiguring_yk => 'Zmena nastavenia YubiKey…';

  @override
  String get s_config_updated => 'Nastavenie bolo aktualizované';

  @override
  String get l_config_updated_reinsert =>
      'Nastavenie bolo aktualizované, vyberte a znovu vložte svoj YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 vypnuté';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn vyžaduje, aby bola aplikácia FIDO2 povolená na vašom YubiKey';

  @override
  String get s_lock_code => 'Kód zámku';

  @override
  String get l_wrong_lock_code => 'Nesprávny kód zámku';

  @override
  String get s_show_lock_code => 'Zobraziť kód zámku';

  @override
  String get s_hide_lock_code => 'Skryť kód zámku';

  @override
  String get p_lock_code_required_desc =>
      'Akcia, ktorú sa chystáte vykonať, si vyžaduje zadanie kódu zámku nastavenia.';

  @override
  String get l_helper_not_responding => 'Proces Helper nereaguje';

  @override
  String get l_yk_no_access => 'K tomuto YubiKey nie je možné získať prístup';

  @override
  String get s_yk_inaccessible => 'Zariadenie nie je dostupné';

  @override
  String get l_open_connection_failed => 'Nepodarilo sa otvoriť pripojenie';

  @override
  String get l_ccid_connection_failed =>
      'Nepodarilo sa otvoriť pripojenie k čipovej karte';

  @override
  String get p_ccid_service_unavailable =>
      'Uistite sa, že služba inteligentných kariet funguje.';

  @override
  String get p_pcscd_unavailable =>
      'Uistite sa, že je nainštalovaný a spustený program pcscd.';

  @override
  String get l_no_yk_present => 'Nie je prítomný žiadny YubiKey';

  @override
  String get s_unknown_type => 'Neznámy typ';

  @override
  String get s_unknown_device => 'Nerozpoznané zariadenie';

  @override
  String get s_restricted_nfc => 'Aktivácia NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Ako aktivovať NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Pripojte svoj YubiKey k akémukoľvek zdroju napájania USB, napríklad k počítaču, na minimálne 3 sekundy.\n\nPo napojení sa aktivuje funkcia NFC a bude pripravená na používanie.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Váš kľúč YubiKey je vybavený funkciou Obmedzené NFC (Restricted NFC), ktorá je určená na ochranu pred bezdrôtovou manipuláciou počas prepravy. To znamená, že operácie NFC sú dočasne deaktivované, kým ich neaktivujete.';

  @override
  String get s_unsupported_yk => 'Nepodporovaný YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'Operácia sa nepodarila, skúste to prosím znova.';

  @override
  String get l_configuration_unsupported => 'Nastavenie nie je podporované';

  @override
  String get p_scp_unsupported =>
      'Na komunikáciu cez NFC vyžaduje YubiKey technológiu, ktorú tento telefón nepodporuje. Pripojte YubiKey k USB portu telefónu.';

  @override
  String get l_error_occurred => 'Vyskytla sa chyba';

  @override
  String get s_application_error => 'Chyba aplikácie';

  @override
  String get l_import_error => 'Chyba importu';

  @override
  String get l_file_not_found => 'Súbor nebol nájdený';

  @override
  String get l_file_too_big => 'Súbor je príliš veľký';

  @override
  String get l_filesystem_error => 'Chyba operácie súborového systému';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Nastaviť PIN';

  @override
  String get s_change_pin => 'Zmeniť PIN';

  @override
  String get s_change_puk => 'Zmeniť PUK';

  @override
  String get s_show_pin => 'Zobraziť PIN';

  @override
  String get s_hide_pin => 'Skryť PIN';

  @override
  String get s_show_puk => 'Zobraziť PUK';

  @override
  String get s_hide_puk => 'Skryť PUK';

  @override
  String get s_current_pin => 'Aktuálny PIN';

  @override
  String get s_current_puk => 'Aktuálny PUK';

  @override
  String get s_new_pin => 'Nový PIN';

  @override
  String get s_new_puk => 'Nový PUK';

  @override
  String get s_confirm_pin => 'Potvrdiť PIN';

  @override
  String get s_confirm_puk => 'Potvrdiť PUK';

  @override
  String get s_unblock_pin => 'Obnoviť PIN';

  @override
  String get l_pin_mismatch => 'PIN kódy sa nezhodujú';

  @override
  String get l_puk_mismatch => 'PUK kódy sa nezhodujú';

  @override
  String get s_pin_set => 'PIN kód nastavený';

  @override
  String get s_puk_set => 'PUK kód nastavený';

  @override
  String l_set_pin_failed(String message) {
    return 'Nepodarilo sa nastaviť PIN: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'Zostáva $retries pokusov',
      many: 'Zostáva $retries pokusov',
      few: 'Zostávajú $retries pokusy',
      one: 'Zostáva $retries pokus',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'zostáva $retries pokusov',
      many: 'zostáva $retries pokusov',
      few: 'zostávajú $retries pokusy',
      one: 'zostáva $retries pokus',
    );
    return 'Nesprávny PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'zostáva $retries pokusov',
      many: 'zostáva $retries pokusov',
      few: 'zostávajú $retries pokusy',
      one: 'zostáva $retries pokus',
    );
    return 'Nesprávny PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Ochrana FIDO PIN kódom';

  @override
  String get s_pin_change_required => 'Vyžaduje sa zmena PIN kódu';

  @override
  String get l_enter_fido2_pin => 'Zadajte FIDO2 PIN kód pre svoj kľúč YubiKey';

  @override
  String get p_fido2_pin_required =>
      'Akcia, ktorú sa chystáte vykonať, vyžaduje zadanie FIDO2 PIN kódu.';

  @override
  String get l_pin_blocked_reset =>
      'PIN je zablokovaný; obnoviť výrobné nastavenie aplikácie FIDO';

  @override
  String get l_pin_blocked => 'PIN je zablokovaný';

  @override
  String get l_set_pin_first => 'Vyžaduje sa PIN kód';

  @override
  String get l_unlock_pin_first => 'Odomknúť pomocou PIN';

  @override
  String get l_pin_soft_locked =>
      'PIN bol zablokovaný, kým sa kľúč YubiKey nevyberie a nevloží znova';

  @override
  String get l_pin_change_required_desc =>
      'Pred použitím tejto aplikácie je potrebné nastaviť nový PIN kód';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'PIN kód musí mať $min_length až $max_length znakov a môže obsahovať písmená, číslice a špeciálne znaky.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'PIN musí mať dĺžku $min_length až $max_length znakov, musí obsahovať aspoň $unique_characters jedinečných znakov a nesmie byť bežne používaným PIN kódom, ako napríklad „$common_pin“. Môže obsahovať písmená, číslice a špeciálne znaky.';
  }

  @override
  String get s_ep_attestation => 'Podniková atestácia';

  @override
  String get s_ep_attestation_enabled => 'Podniková atestácia povolená';

  @override
  String get q_enable_ep_attestation => 'Povoliť podnikovú atestáciu?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Týmto sa umožní podniková atestácia, ktorá umožní autorizovaným doménam jednoznačne identifikovať váš YubiKey.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Po zapnutí podnikovej atestácie ju možno vypnúť len vykonaním obnovenia výrobných nastavení FIDO.';

  @override
  String get s_pin_required => 'Vyžaduje sa PIN kód';

  @override
  String get p_pin_required_desc =>
      'Akcia, ktorú sa chystáte vykonať, vyžaduje zadanie kódu PIV PIN.';

  @override
  String get l_piv_pin_blocked => 'Zablokované, na obnovenie použite PUK';

  @override
  String get p_piv_pin_blocked_desc =>
      'PIN kód je zablokovaný. Na jeho obnovenie použite PUK.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'PIN kód je zablokovaný. Je potrebné obnoviť výrobné nastavenia.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Zablokované, je potrebné obnovenie výrobných nastavení';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'PIN aj PUK sú zablokované. Vyžaduje sa obnovenie výrobných nastavení aplikácie PIV.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name musí mať aspoň $length znakov.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name musí mať dĺžku aspoň $length znakov, musí obsahovať aspoň 2 jedinečné znaky a nesmie byť bežne používaným $name ako napríklad „$common“.';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Nový $name nespĺňa požiadavky na komplexnosť.';
  }

  @override
  String get s_dismiss => 'Zamietnuť';

  @override
  String get p_default_pin_puk_key_desc =>
      'Odporúča sa zmeniť predvolený PIN kód, PUK kód a spravovací kľúč.';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      'Pre splnenie požiadaviek FIPS je potrebné zmeniť predvolené kódy PIN, PUK a spravovací kľúč.';

  @override
  String get l_warning_default_pin =>
      'Varovanie: Používa sa predvolený PIN kód';

  @override
  String get l_warning_default_puk =>
      'Varovanie: Používa sa predvolený PUK kód';

  @override
  String get l_default_pin_used => 'Používa sa predvolený PIN';

  @override
  String get l_default_puk_used => 'Používa sa predvolený PUK';

  @override
  String get l_pin_complexity => 'Vynútená zložitosť kódu PIN';

  @override
  String get s_password => 'Heslo';

  @override
  String get s_manage_password => 'Spravovať heslo';

  @override
  String get s_set_password => 'Nastaviť heslo';

  @override
  String get s_password_set => 'Heslo nastavené';

  @override
  String get s_show_password => 'Zobraziť heslo';

  @override
  String get s_hide_password => 'Skryť heslo';

  @override
  String get l_password_protection => 'Ochrana účtov heslom';

  @override
  String get s_new_password => 'Nové heslo';

  @override
  String get s_current_password => 'Aktuálne heslo';

  @override
  String get s_confirm_password => 'Potvrdiť heslo';

  @override
  String get l_password_mismatch => 'Heslá sa nezhodujú';

  @override
  String get s_wrong_password => 'Nesprávne heslo';

  @override
  String get p_wrong_password =>
      'Nesprávne heslo. Ak heslo nepoznáte, budete musieť obnoviť YubiKey.';

  @override
  String get s_remove_password => 'Odstrániť heslo';

  @override
  String get s_password_removed => 'Heslo bolo odstránené';

  @override
  String get s_remember_password => 'Zapamätať si heslo';

  @override
  String get s_clear_saved_password => 'Vymazať uložené heslo';

  @override
  String get s_password_forgotten => 'Zabudnuté heslo';

  @override
  String get l_keystore_unavailable => 'OS Keystore nie je k dispozícii';

  @override
  String get l_remember_pw_failed => 'Nepodarilo sa zapamätať heslo';

  @override
  String get l_unlock_first => 'Odomknúť pomocou hesla';

  @override
  String get l_set_password_first => 'Nastaviť heslo';

  @override
  String get l_enter_oath_pw => 'Zadajte heslo OATH pre svoj YubiKey';

  @override
  String get p_new_password_requirements =>
      'Heslo môže obsahovať písmená, číslice a špeciálne znaky.';

  @override
  String get s_management_key => 'Spravovací kľúč';

  @override
  String get s_current_management_key => 'Aktuálny spravovací kľúč';

  @override
  String get s_new_management_key => 'Nový spravovací kľúč';

  @override
  String get l_change_management_key => 'Zmeniť spravovací kľúč';

  @override
  String get l_management_key_changed => 'Spravovací kľúč bol zmenený';

  @override
  String get l_default_key_used => 'Používa sa predvolený spravovací kľúč';

  @override
  String get s_generate_random => 'Generovať náhodný';

  @override
  String get s_use_default => 'Použiť predvolené';

  @override
  String get l_warning_default_key => 'Varovanie: Používa sa predvolený kľúč';

  @override
  String get s_protect_key => 'Chrániť pomocou PIN kódu';

  @override
  String get p_protect_key_desc =>
      'Použiť PIN kód namiesto spravovacieho kľúča pri operáciách, ktoré vyžadujú overenie spravovacím kľúčom.';

  @override
  String get s_management_key_algorithm => 'Algoritmus spravovacieho kľúča';

  @override
  String get p_management_key_algorithm_desc =>
      'Algoritmus, ktorý sa má použiť pre spravovací kľúč.';

  @override
  String get l_pin_protected_key => 'Namiesto toho je možné použiť PIN kód';

  @override
  String get l_wrong_key => 'Nesprávny kľúč';

  @override
  String get l_unlock_piv_management => 'Odomknúť spravovanie PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'Akcia, ktorú sa chystáte vykonať, vyžaduje spravovací kľúč PIV.';

  @override
  String l_account(String label) {
    return 'Účet: $label';
  }

  @override
  String get s_accounts => 'Účty';

  @override
  String get s_no_accounts => 'Žiadne účty';

  @override
  String l_results_for(String query) {
    return 'Výsledky pre \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Začnite s účtami OTP';

  @override
  String get l_no_accounts_desc =>
      'Pridajte si do svojho YubiKey účty od akéhokoľvek poskytovateľa služieb podporujúceho OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Pridať účet';

  @override
  String get p_add_account_desc =>
      'Naskenujte QR kód alebo zadajte údaje o poverení ručne.';

  @override
  String get s_add_accounts => 'Pridať účet(-y)';

  @override
  String get l_drop_qr_description => 'Vložte QR kód a pridajte účet/-y';

  @override
  String get p_add_account_three_ways =>
      'Existujú tri spôsoby pridávania účtov.';

  @override
  String get s_scanning => 'Skenovanie (odporúčané)';

  @override
  String get p_scanning_desc =>
      'Pred skenovaním kódu QR sa uistite, že je na obrazovke viditeľný celý kód.';

  @override
  String get s_drag_and_drop => 'Potiahnuť a pustiť';

  @override
  String get p_drag_and_drop_desc =>
      'Obrázok obsahujúci QR kód môžete umiestniť kdekoľvek v zobrazení účtov.';

  @override
  String get s_manually => 'Ručne';

  @override
  String get p_manually_desc =>
      'Údaje o poverení účtu môžete do formulára zadať ručne.';

  @override
  String get s_account_added => 'Účet bol pridaný';

  @override
  String l_account_add_failed(String message) {
    return 'Nepodarilo sa pridať účet: $message';
  }

  @override
  String get l_add_account_password_required => 'Vyžaduje sa heslo';

  @override
  String get l_add_account_unlock_required => 'Vyžaduje sa odomknutie';

  @override
  String get l_add_account_func_missing => 'Funkcia chýba alebo je zakázaná';

  @override
  String get l_account_name_required => 'Váš účet musí mať názov';

  @override
  String get l_name_already_exists => 'Tento názov už pre vydavateľa existuje';

  @override
  String get l_account_already_exists => 'Tento účet už existuje na YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Neplatný znak: „:\" nie je povolený v položke vydavateľ';

  @override
  String get l_select_accounts =>
      'Vyberte účet/-y, ktoré chcete pridať do YubiKey';

  @override
  String get s_pin_account => 'Pripnúť účet';

  @override
  String get s_unpin_account => 'Zrušiť pripnutie účtu';

  @override
  String get s_no_pinned_accounts => 'Žiadne pripnuté účty';

  @override
  String get s_pinned => 'Pripnuté';

  @override
  String get l_pin_account_desc => 'Udržujte svoje dôležité účty pohromade';

  @override
  String get s_rename_account => 'Premenovať účet';

  @override
  String get l_rename_account_desc => 'Upraviť vydavateľa/názov účtu';

  @override
  String get s_account_renamed => 'Účet bol premenovaný';

  @override
  String l_rename_account_failed(String message) {
    return 'Zlyhalo premenovanie účtu: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Týmto sa zmení spôsob zobrazenia účtu v zozname.';

  @override
  String get s_delete_account => 'Vymazať účet';

  @override
  String get q_delete_account => 'Vymazať účet?';

  @override
  String get l_delete_account_desc => 'Odstrániť účet z vášho YubiKey';

  @override
  String get s_account_deleted => 'Účet bol odstránený';

  @override
  String get p_warning_delete_account =>
      'Varovanie! Táto akcia vymaže účet z vášho YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Aby ste sa vyhli zablokovaniu tohto konta, nezabudnite ho deaktivovať v službe, v ktorej je zaregistrovaný.';

  @override
  String get s_account_name => 'Názov účtu';

  @override
  String get s_search_accounts => 'Hľadať účty';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used z $capacity účtov je využitých';
  }

  @override
  String s_num_digits(int num) {
    return '$num číslic';
  }

  @override
  String s_num_sec(int num) {
    return '$num sek';
  }

  @override
  String get s_issuer_optional => 'Vydavateľ (nepovinné)';

  @override
  String get s_counter_based => 'Založené na počítadle';

  @override
  String get s_time_based => 'Založené na čase';

  @override
  String get l_copy_code_desc => 'Vložiť kód do inej aplikácie';

  @override
  String get l_calculate_code_desc => 'Získať nový kód z vášho YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'ID používateľa';

  @override
  String get s_credential_id => 'ID poverenia';

  @override
  String get s_display_name => 'Zobrazovaný názov';

  @override
  String get s_user_name => 'Meno používateľa';

  @override
  String get s_passkeys => 'Prístupové kľúče';

  @override
  String get s_no_passkeys => 'Žiadne prístupové kľúče';

  @override
  String get l_ready_to_use => 'Pripravené na použitie';

  @override
  String get l_register_sk_on_websites =>
      'Zaregistrovať ako bezpečnostný kľúč na webových stránkach';

  @override
  String get l_no_discoverable_accounts =>
      'Nie sú uložené žiadne prístupové kľúče';

  @override
  String get p_non_passkeys_note =>
      'Môžu existovať poverenia bez prístupového kľúča, ale nemôžu byť zobrazené v zozname.';

  @override
  String get s_delete_passkey => 'Vymazať prístupový kľúč';

  @override
  String get q_delete_passkey => 'Vymazať prístupový kľúč?';

  @override
  String get l_delete_passkey_desc => 'Odstrániť prístupový kľúč z YubiKey';

  @override
  String get s_passkey_deleted => 'Prístupový kľúč bol odstránený';

  @override
  String get p_warning_delete_passkey =>
      'Varovanie! Táto akcia vymaže prístupový kľúč z vášho YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Tento prístupový kľúč už nebudete môcť používať pre službu, v ktorej je zaregistrovaný.';

  @override
  String get l_do_not_remove_yk_delete =>
      'Počas vymazávania nevyberajte YubiKey';

  @override
  String get s_search_passkeys => 'Vyhľadávanie prístupových kľúčov';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used z $max prístupových kľúčov je použitých.';
  }

  @override
  String get s_biometrics => 'Biometria';

  @override
  String l_fingerprint(String label) {
    return 'Odtlačok prsta: $label';
  }

  @override
  String get s_fingerprints => 'Odtlačky prstov';

  @override
  String get l_fingerprint_captured => 'Odtlačok prsta úspešne zachytený!';

  @override
  String get s_fingerprint_added => 'Odtlačok bol pridaný';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Chyba pri pridávaní odtlačku prsta: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Chyba nastavenia názvu: $message';
  }

  @override
  String get s_setup_fingerprints => 'Nastaviť odtlačky prstov';

  @override
  String get p_setup_fingerprints_desc =>
      'Pred použitím kľúča je potrebné nastaviť odtlačky prstov.';

  @override
  String get s_add_fingerprint => 'Pridať odtlačok prsta';

  @override
  String get s_delete_fingerprint => 'Odtlačok prsta bol odstránený';

  @override
  String get q_delete_fingerprint => 'Vymazať odtlačok prsta?';

  @override
  String get l_delete_fingerprint_desc =>
      'Odstrániť odtlačok prsta z kľúča YubiKey';

  @override
  String get s_fingerprint_deleted => 'Odtlačok prsta bol odstránený';

  @override
  String get p_warning_delete_fingerprint =>
      'Týmto sa odstráni odtlačok prsta z vášho YubiKey.';

  @override
  String get s_fingerprints_get_started => 'Začnite s odtlačkami prstov';

  @override
  String get p_set_fingerprints_desc =>
      'Predtým, ako je možné zaregistrovať odtlačky prstov, je potrebné nastaviť PIN kód.';

  @override
  String get l_no_fps_added => 'Neboli pridané žiadne odtlačky prstov';

  @override
  String get s_rename_fp => 'Premenovať odtlačok prsta';

  @override
  String get l_rename_fp_desc => 'Zmeniť názov';

  @override
  String get s_fingerprint_renamed => 'Odtlačok bol premenovaný';

  @override
  String l_rename_fp_failed(String message) {
    return 'Chyba pri premenovaní: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Pridajte jeden alebo viac (až päť) odtlačkov prstov';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 odtlačkov prstov je registrovaných';
  }

  @override
  String get p_press_fingerprint_begin => 'Začnite stlačením prsta na YubiKey.';

  @override
  String get l_name_fingerprint => 'Pomenujte tento odtlačok prsta';

  @override
  String get l_user_action_timeout_error =>
      'Nepodarilo sa z dôvodu nečinnosti používateľa';

  @override
  String get l_wrong_inserted_yk_error =>
      'Opätovne vložený kľúč YubiKey nezodpovedá pôvodnému zariadeniu';

  @override
  String get l_failed_connecting_to_fido =>
      'Zlyhalo pripojenie k rozhraniu FIDO';

  @override
  String get l_self_signed_certificate => 'Certifikát s vlastným podpisom';

  @override
  String get l_certificate_signing_request =>
      'Žiadosť o podpísanie certifikátu (CSR)';

  @override
  String get s_certificate => 'Certifikát';

  @override
  String get s_subject => 'Predmet';

  @override
  String get l_export_csr_file => 'Uložiť CSR do súboru';

  @override
  String get l_export_public_key => 'Exportovať verejný kľúč';

  @override
  String get l_export_public_key_file => 'Uložiť verejný kľúč do súboru';

  @override
  String get l_export_public_key_desc => 'Exportovať verejný kľúč do súboru';

  @override
  String get l_public_key_exported => 'Verejný kľúč exportovaný';

  @override
  String get l_export_certificate => 'Exportovať certifikát';

  @override
  String get l_export_certificate_file => 'Exportovať certifikátu do súboru';

  @override
  String get l_export_certificate_desc => 'Exportovanie certifikátu do súboru';

  @override
  String get l_certificate_exported => 'Certifikát bol exportovaný';

  @override
  String get l_select_import_file => 'Vyberte súbor, ktorý chcete importovať';

  @override
  String get l_import_file => 'Importovať súbor';

  @override
  String get l_import_desc => 'Importovať kľúč a/alebo certifikát';

  @override
  String get l_import_nothing => 'Nie je čo importovať';

  @override
  String get l_importing_file => 'Importuje sa súbor…';

  @override
  String get s_file_imported => 'Súbor bol importovaný';

  @override
  String get l_unsupported_key_type => 'Nepodporovaný typ kľúča';

  @override
  String get l_delete_certificate => 'Odstrániť certifikát';

  @override
  String get q_delete_certificate => 'Vymazať certifikát?';

  @override
  String get l_delete_certificate_desc =>
      'Odstrániť certifikát z vášho YubiKey';

  @override
  String get l_delete_key => 'Vymazať kľúč';

  @override
  String get q_delete_key => 'Vymazať kľúč?';

  @override
  String get l_delete_key_desc => 'Odstrániť kľúč z vášho YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Vymazať certifikát/kľúč';

  @override
  String get q_delete_certificate_or_key => 'Vymazať certifikát/kľúč?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Odstráňte certifikát alebo kľúč z vášho YubiKey';

  @override
  String get l_move_key => 'Presunúť kľúč';

  @override
  String get l_move_key_desc => 'Presunúť kľúč z jedného slotu PIV do druhého';

  @override
  String get l_change_defaults => 'Zmeniť predvolené prístupové kódy';

  @override
  String get s_issuer => 'Vydavateľ';

  @override
  String get s_serial => 'Sériové číslo';

  @override
  String get s_certificate_fingerprint => 'Odtlačok prsta';

  @override
  String get s_valid_from => 'Platné od';

  @override
  String get s_valid_to => 'Platné do';

  @override
  String get l_no_certificate => 'Nie je načítaný žiadny certifikát';

  @override
  String get l_key_no_certificate => 'Kľúč bez načítaného certifikátu';

  @override
  String get s_generate_key => 'Vygenerovať kľúč';

  @override
  String get l_generate_desc => 'Vygenerovať nový certifikát alebo CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Týmto sa vygeneruje nový kľúč na YubiKey v slote PIV $slot.';
  }

  @override
  String get s_private_key_generated => 'Súkromný kľúč bol vygenerovaný';

  @override
  String get p_select_what_to_delete => 'Vyberte, čo sa má zo slotu odstrániť.';

  @override
  String get p_warning_delete_certificate =>
      'Varovanie! Táto akcia vymaže certifikát z vášho YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Varovanie! Táto akcia vymaže súkromný kľúč z vášho YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Varovanie! Táto akcia vymaže certifikát a súkromný kľúč z vášho YubiKey.';

  @override
  String get p_warning_usb_preferred =>
      'Pre RSA kľúče uprednostniť USB. NFC môže spôsobiť chyby.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Týmto sa odstráni certifikát v slote PIV $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Týmto sa odstráni súkromný kľúč v slote PIV $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Týmto sa odstráni certifikát a súkromný kľúč v slote PIV $slot.';
  }

  @override
  String get l_certificate_deleted => 'Certifikát bol vymazaný';

  @override
  String get l_key_deleted => 'Kľúč bol vymazaný';

  @override
  String get l_certificate_and_key_deleted => 'Certifikát a kľúč boli vymazané';

  @override
  String get l_include_certificate => 'Zahrnúť certifikát';

  @override
  String get l_select_destination_slot => 'Vyberte cieľový slot';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Presunúť súkromný kľúč v slote PIV $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Presunúť súkromný kľúč v slote PIV $from_slot do slotu $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Premiestniť súkromný kľúč a certifikát v slote PIV $from_slot do slotu $to_slot?';
  }

  @override
  String get p_password_protected_file => 'Vybraný súbor je chránený heslom.';

  @override
  String p_import_items_desc(String slot) {
    return 'Do slotu PIV $slot sa naimportujú tieto položky.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Verejný kľúč certifikátu sa nezhoduje so súkromným kľúčom v slote';

  @override
  String get l_key_moved => 'Kľúč bol presunutý';

  @override
  String get l_key_and_certificate_moved => 'Kľúč a certifikát boli presunuté';

  @override
  String get p_subject_desc =>
      'Rozlišujúci názov (DN) naformátovaný v súlade so špecifikáciou RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Neplatný formát RFC 4514';

  @override
  String get rfc4514_examples =>
      'Príklady:\nCN=Vzorové Meno\nCN=jnovak,DC=priklad,DC=net';

  @override
  String get s_allow_fingerprint => 'Povoliť odtlačok prsta';

  @override
  String get s_pin_policy => 'Zásady PIN';

  @override
  String get s_output_format => 'Výstupný formát';

  @override
  String get s_expiration_date => 'Dátum skončenia platnosti';

  @override
  String get p_algorithm_desc => 'Použitý algoritmus kľúča.';

  @override
  String get p_expiration_date_desc =>
      'Dátum ukončenia platnosti certifikátu, predvolene 1 rok (len certifikát).';

  @override
  String get p_key_options_bio_desc =>
      'Umožniť používanie biometrických údajov namiesto PIN kódu.';

  @override
  String get q_overwrite_slot => 'Prepísať slot?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Tým sa natrvalo prepíše existujúci obsah v slote $slot.';
  }

  @override
  String get l_overwrite_cert => 'Certifikát bude prepísaný';

  @override
  String get l_overwrite_key => 'Súkromný kľúč bude prepísaný';

  @override
  String get l_overwrite_key_maybe =>
      'Akýkoľvek existujúci súkromný kľúč v slote sa prepíše';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Autentifikácia';

  @override
  String get s_slot_9c => 'Digitálny podpis';

  @override
  String get s_slot_9d => 'Spravovanie kľúčov';

  @override
  String get s_slot_9e => 'Autentifikácia karty';

  @override
  String get s_retired_slot => 'Správa vyradených kľúčov';

  @override
  String get s_otp_slot_one => 'Krátky dotyk';

  @override
  String get s_otp_slot_two => 'Dlhý dotyk';

  @override
  String get l_otp_slot_empty => 'Slot je prázdny';

  @override
  String get l_otp_slot_configured => 'Slot je nastavený';

  @override
  String get l_yubiotp_desc => 'Naprogramujte poverenie Yubico OTP';

  @override
  String get s_challenge_response => 'Výzva-odpoveď';

  @override
  String get l_challenge_response_desc =>
      'Naprogramovať poverenie typu výzva-odpoveď';

  @override
  String get s_static_password => 'Statické heslo';

  @override
  String get l_static_password_desc => 'Nastaviť statické heslo';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Naprogramovať poverenie založené na HMAC-SHA1';

  @override
  String get s_public_id => 'Verejné ID';

  @override
  String get s_private_id => 'Súkromné ID';

  @override
  String get s_use_serial => 'Použiť sériové číslo';

  @override
  String get l_select_file => 'Vybrať súbor';

  @override
  String get l_no_export_file => 'Žiadny exportný súbor';

  @override
  String get s_no_export => 'Žiadny export';

  @override
  String get s_export => 'Exportovať';

  @override
  String get l_export_configuration_file => 'Exportovať nastavenie do súboru';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Exportované poverenia je možné nahrať na stránke $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Klávesnica $layout';
  }

  @override
  String get s_delete_slot => 'Odstrániť poverenie';

  @override
  String get q_delete_slot => 'Odstrániť poverenie?';

  @override
  String get l_delete_slot_desc => 'Odstrániť poverenie v slote';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Varovanie! Táto akcia natrvalo odstráni poverenie zo slotu $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Poverenie odstránené';

  @override
  String get s_swap => 'Vymeniť';

  @override
  String get s_swap_slots => 'Vymeniť sloty';

  @override
  String get q_swap_slots => 'Vymeniť sloty?';

  @override
  String get l_swap_slots_desc => 'Vymeniť krátky/dlhý dotyk';

  @override
  String get p_swap_slots_desc => 'Týmto sa vymení nastavenie oboch slotov.';

  @override
  String get l_slots_swapped => 'Nastavenie slotov bolo vymenené';

  @override
  String l_slot_credential_configured(String type) {
    return 'Nastavené poverenie $type';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Nastavené poverenie $type a exportované do $file';
  }

  @override
  String get s_append_enter => 'Pripojiť ⏎';

  @override
  String get l_append_enter_desc =>
      'Pripojiť stlačenie klávesu Enter po vyslaní OTP';

  @override
  String get p_otp_swap_error =>
      'Nepodarilo sa vymeniť sloty! Uistite sa, že kľúč YubiKey nemá obmedzený prístup.';

  @override
  String get l_wrong_access_code => 'Nesprávny prístupový kód';

  @override
  String get s_access_code => 'Prístupový kód';

  @override
  String get s_show_access_code => 'Zobraziť prístupový kód';

  @override
  String get s_hide_access_code => 'Skryť prístupový kód';

  @override
  String p_enter_access_code(String slot) {
    return 'Zadajte prístupový kód pre slot $slot.';
  }

  @override
  String get s_enable_nfc => 'Povoliť NFC';

  @override
  String get s_request_access => 'Požiadať o prístup';

  @override
  String get s_permission_denied => 'Prístup zamietnutý';

  @override
  String get l_elevating_permissions => 'Zvyšovanie oprávnení…';

  @override
  String get s_review_permissions => 'Skontrolovať oprávnenia';

  @override
  String get s_open_windows_settings => 'Otvoriť nastavenia systému Windows';

  @override
  String get l_admin_privileges_required => 'Vyžadujú sa oprávnenia správcu';

  @override
  String get p_elevated_permissions_required =>
      'Spravovanie tohto zariadenia vyžaduje zvýšené oprávnenia. Alternatívne môžete na správu nastavenia FIDO použiť Nastavenia systému Windows.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'Spravovanie WebAuthn vyžaduje zvýšené oprávnenia. Alternatívne môžete na správu nastavenia FIDO použiť Nastavenia systému Windows.';

  @override
  String get p_ms_store_permission_note =>
      'Verzia aplikácie z Microsoft Store zvyčajne nedokáže zvýšiť oprávnenia kvôli obmedzeniam sandboxu v systéme Windows. Odporúčame nainštalovať aplikáciu Yubico Authenticator z nášho oficiálneho inštalačného programu .msi.';

  @override
  String get p_need_camera_permission =>
      'Aplikácia Yubico Authenticator potrebuje na skenovanie QR kódov povolenia kamery.';

  @override
  String get s_qr_scan => 'Skenovať QR kód';

  @override
  String get l_invalid_qr => 'Neplatný QR kód';

  @override
  String get l_qr_not_found => 'Nenašiel sa žiadny QR kód';

  @override
  String get l_qr_scanned => 'Naskenovaný QR kód';

  @override
  String l_qr_file_too_large(String max) {
    return 'Príliš veľký súbor (max. $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Neplatný obrázkový súbor';

  @override
  String get l_qr_select_file => 'Vyberte súbor s QR kódom';

  @override
  String l_qr_not_read(String message) {
    return 'Nepodarilo sa načítať QR kód: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Nasmerujte kameru na QR kód a naskenujte ho';

  @override
  String get q_want_to_scan => 'Chceli by ste naskenovať?';

  @override
  String get q_no_qr => 'Žiadny QR kód?';

  @override
  String get s_enter_manually => 'Zadať ručne';

  @override
  String get s_read_from_file => 'Čítať zo súboru';

  @override
  String get s_reset => 'Obnoviť';

  @override
  String get s_factory_reset => 'Obnoviť výrobné nastavenia';

  @override
  String get l_factory_reset_desc => 'Obnoviť predvolené nastavenia YubiKey';

  @override
  String get l_factory_reset_required =>
      'Vyžaduje sa obnovenie do výrobného stavu';

  @override
  String get l_oath_application_reset => 'Obnovenie aplikácie OATH';

  @override
  String get l_fido_app_reset => 'Obnovenie aplikácie FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Chyba pri vykonaní obnovenia: $message';
  }

  @override
  String get l_piv_app_reset => 'Obnovenie aplikácie PIV';

  @override
  String get p_factory_reset_an_app =>
      'Obnoviť výrobné nastavenia aplikácie na vašom YubiKey.';

  @override
  String get p_factory_reset_desc =>
      'Údaje sú v zariadení YubiKey uložené vo viacerých aplikáciách, pričom niektoré z nich je možné obnoviť do výrobného nastavenia nezávisle od ostatných.\n\nVyberte aplikáciu vyššie, ktorú chcete obnoviť.';

  @override
  String get p_warning_factory_reset =>
      'Varovanie! Týmto sa z vášho YubiKey nenávratne vymažú všetky účty OATH TOTP/HOTP.';

  @override
  String get p_warning_disable_credentials =>
      'Vaše poverenia OATH, ako aj všetky nastavené heslá budú z tohto kľúča YubiKey odstránené. Nezabudnite ich deaktivovať na príslušných webových stránkach, aby ste sa vyhli zablokovaniu svojich účtov.';

  @override
  String get p_warning_deletes_accounts =>
      'Varovanie! Tým sa z vášho YubiKey nenávratne odstránia všetky účty U2F a FIDO2 vrátane prístupových kľúčov.';

  @override
  String get p_warning_disable_accounts =>
      'Vaše poverovacie údaje, ako aj všetky nastavené PIN kódy budú z tohto YubiKey odstránené. Nezabudnite ich deaktivovať na príslušných webových stránkach, aby ste sa vyhli zablokovaniu svojich účtov.';

  @override
  String l_reset_not_allowed_over(String transport) {
    return 'Obnovenie FIDO je zakázané cez $transport';
  }

  @override
  String get p_warning_piv_reset =>
      'Varovanie! Všetky údaje uložené pre PIV budú z vášho YubiKey nenávratne vymazané.';

  @override
  String get p_warning_piv_reset_desc =>
      'To zahŕňa súkromné kľúče a certifikáty. Vaše PIN, PUK a kľúč na spravovanie sa obnovia na predvolené hodnoty z výroby.';

  @override
  String get p_warning_global_reset =>
      'Varovanie! Týmto sa z vášho YubiKey nenávratne vymažú všetky uložené údaje vrátane poverení.';

  @override
  String get p_warning_global_reset_desc =>
      'Obnovenie výrobných nastavení aplikácií na vašom YubiKey. PIN kód sa obnoví na predvolenú hodnotu z výroby a registrované odtlačky prstov sa odstránia. Všetky kľúče, certifikáty alebo iné poverenia budú natrvalo odstránené.';

  @override
  String get l_copy_to_clipboard => 'Kopírovať do schránky';

  @override
  String get s_code_copied => 'Kód skopírovaný';

  @override
  String get l_code_copied_clipboard => 'Kód bol skopírovaný do schránky';

  @override
  String get s_copy_log => 'Kopírovať záznam';

  @override
  String get l_copy_log_clipboard => 'Skopírovať záznam do schránky';

  @override
  String get l_log_copied => 'Záznam skopírovaný do schránky';

  @override
  String get l_diagnostics_copied =>
      'Diagnostické údaje boli skopírované do schránky';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label skopírovaná do schránky.';
  }

  @override
  String get s_custom_icons => 'Vlastné ikony';

  @override
  String get l_set_icons_for_accounts => 'Nastaviť ikony pre účty';

  @override
  String get p_custom_icons_description =>
      'Vďaka balíkom ikon môžete svoje účty ľahšie rozlíšiť pomocou známych log a farieb.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Balíky ikon používajú formát $aegis_icon_pack. Môžete si stiahnuť vopred pripravený balík ikon alebo si môžete vytvoriť vlastný.';
  }

  @override
  String get s_replace_icon_pack => 'Nahradiť balík ikon';

  @override
  String get l_loading_icon_pack => 'Načítanie balíka ikon…';

  @override
  String get s_load_icon_pack => 'Načítať balík ikon';

  @override
  String get l_load_icon_pack_desc => 'Načítať balík ikon zo súboru';

  @override
  String get s_remove_icon_pack => 'Odstrániť balík ikon';

  @override
  String get l_remove_icon_pack_desc => 'Odstrániť aktívny balík ikon';

  @override
  String get l_icon_pack_removed => 'Balík ikon bol odstránený';

  @override
  String get l_remove_icon_pack_failed => 'Chyba pri odstraňovaní balíka ikon';

  @override
  String get s_choose_icon_pack => 'Vyberte si balík ikon';

  @override
  String get l_icon_pack_imported => 'Balík ikon bol importovaný';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Chyba pri importovaní balíka ikon: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Neplatný balík ikon';

  @override
  String get l_icon_pack_copy_failed =>
      'Nepodarilo sa skopírovať súbory balíka ikon';

  @override
  String get s_nfc_and_usb_options => 'Možnosti NFC a USB';

  @override
  String get l_nfc_and_usb_options_desc => 'Nastaviť akciu pre YubiKey';

  @override
  String get l_on_yk_nfc_tap => 'Pri dotyku NFC';

  @override
  String get l_on_yk_usb_insert => 'Pri vložení do USB';

  @override
  String get l_do_nothing => 'Neurobiť nič';

  @override
  String get l_launch_ya => 'Spustiť Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Skopírovať OTP do schránky';

  @override
  String get l_launch_and_copy_otp => 'Spustite aplikáciu a skopírujte OTP';

  @override
  String get l_kbd_layout_for_static =>
      'Rozloženie klávesnice (pre statické heslo)';

  @override
  String get s_choose_kbd_layout => 'Zvoľte rozloženie klávesnice';

  @override
  String get l_bypass_touch_requirement => 'Obísť požiadavku na dotyk';

  @override
  String get l_bypass_touch_requirement_on =>
      'Účty, ktoré vyžadujú dotyk, sa automaticky zobrazujú cez NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Účty, ktoré vyžadujú dotyk, potrebujú dodatočné ťuknutie cez NFC';

  @override
  String get s_silence_nfc_sounds => 'Vypnúť zvuky NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'Pri ťuknutí cez NFC sa nebudú prehrávať žiadne zvuky';

  @override
  String get l_silence_nfc_sounds_off => 'Pri ťuknutí na NFC sa prehrá zvuk';

  @override
  String get l_launch_app_on_usb_on =>
      'Toto zabráni používaniu YubiKey cez USB inými aplikáciami';

  @override
  String get l_launch_app_on_usb_off =>
      'Ostatné aplikácie môžu používať YubiKey cez USB';

  @override
  String get s_allow_screenshots => 'Povoliť snímky obrazovky';

  @override
  String get l_allow_screenshots_desc =>
      'Povoliť iným aplikáciám vytvárať snímky obrazovky';

  @override
  String get s_nfc_ready_to_scan => 'Pripravené na skenovanie';

  @override
  String get s_nfc_hold_still => 'Prosím držte pevne…';

  @override
  String get s_nfc_tap_your_yubikey => 'Ťuknite na svoj YubiKey';

  @override
  String get s_nfc_remove_key => 'Odobrať YubiKey';

  @override
  String get l_nfc_failed_to_scan =>
      'Skenovanie sa nepodarilo, skúste to znova';

  @override
  String get s_usb_processing => 'Čítanie údajov z YubiKey';

  @override
  String get s_usb_dont_remove => 'Neodstraňujte kľúč…';

  @override
  String get l_usb_read_error => 'Nepodarilo sa načítať údaje z YubiKey';

  @override
  String get p_ndef_set_otp =>
      'OTP kód sa úspešne skopíroval z YubiKey do schránky.';

  @override
  String get p_ndef_set_password =>
      'Heslo bolo úspešne skopírované z YubiKey do schránky.';

  @override
  String get p_ndef_parse_failure =>
      'Nepodarilo sa spracovať OTP kód z YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Nepodarilo sa získať prístup k schránke pri pokuse o skopírovanie OTP kódu z YubiKey.';

  @override
  String get s_set_label => 'Nastaviť menovku';

  @override
  String get s_set_color => 'Nastaviť farbu';

  @override
  String get s_change_label => 'Zmeniť menovku';

  @override
  String get p_set_will_add_custom_name =>
      'Týmto sa vášmu kľúču YubiKey pridelí vlastný názov.';

  @override
  String get p_rename_will_change_custom_name =>
      'Týmto sa zmení menovka vášho kľúča YubiKey.';

  @override
  String get s_keyboard_shortcuts => 'Klávesové skratky';

  @override
  String get s_global_shortcuts => 'Globálne skratky';

  @override
  String get s_application_shortcuts => 'Skratky aplikácie';

  @override
  String s_quit_app(String app) {
    return 'Opustiť $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Skryť $app';
  }

  @override
  String get s_search => 'Hľadať';

  @override
  String get s_next_device => 'Ďalšie zariadenie';

  @override
  String get s_previous_device => 'Predchádzajúce zariadenie';

  @override
  String get s_open_settings => 'Otvoriť nastavenia';

  @override
  String get s_open_item => 'Otvoriť položku';

  @override
  String get s_edit_item => 'Upraviť položku';

  @override
  String get s_delete_item => 'Odstrániť položku';

  @override
  String get s_calculate_oath_code => 'Vypočítať OATH kód';

  @override
  String get s_open_keyboard_shortcuts => 'Otvoriť klávesové skratky';
}
