// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Swedish (`sv`).
class AppLocalizationsSv extends AppLocalizations {
  AppLocalizationsSv([String locale = 'sv']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Svenska';

  @override
  String s_translated(int percentage) {
    return 'Översatt: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Korrekturläst: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Ofullständig översättning';

  @override
  String get p_translation_progress_desc =>
      'Staplarna återspeglar översättningens mognadsgrad.';

  @override
  String get s_community => 'Gemenskap';

  @override
  String get l_localization_project => 'Lokaliseringsprojekt';

  @override
  String get s_save => 'Spara';

  @override
  String get s_cancel => 'Avbryt';

  @override
  String get s_close => 'Stäng';

  @override
  String get s_delete => 'Radera';

  @override
  String get s_move => 'Flytta';

  @override
  String get s_quit => 'Avsluta';

  @override
  String get s_enable => 'Aktivera';

  @override
  String get s_enabled => 'Aktiverad';

  @override
  String get s_disabled => 'Inaktiverad';

  @override
  String get s_status => 'Status';

  @override
  String get s_unlock => 'Lås upp';

  @override
  String get s_calculate => 'Beräkna';

  @override
  String get s_import => 'Importera';

  @override
  String get s_overwrite => 'Skriv över';

  @override
  String get s_done => 'Klar';

  @override
  String get s_success => 'Slutfört';

  @override
  String get s_loading => 'Laddar…';

  @override
  String get s_more => 'Mer';

  @override
  String get s_label => 'Etikett';

  @override
  String get s_name => 'Namn';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Alternativ';

  @override
  String get s_details => 'Detaljer';

  @override
  String get s_show_window => 'Visa fönster';

  @override
  String get s_hide_window => 'Dölj fönster';

  @override
  String get s_show_navigation => 'Visa navigering';

  @override
  String get s_expand_navigation => 'Expandera navigeringsfältet';

  @override
  String get s_collapse_navigation => 'Minimera navigationsfältet';

  @override
  String get s_expand_collapse_navigation =>
      'Expandera/minimera navigeringsfältet';

  @override
  String get s_show_menu => 'Visa meny';

  @override
  String get s_toggle_menu_bar => 'Växla menyfältet';

  @override
  String get s_more_info => 'Mer info';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'Om';

  @override
  String get s_algorithm => 'Algoritm';

  @override
  String get s_appearance => 'Utseende';

  @override
  String get s_actions => 'Åtgärder';

  @override
  String get s_manage => 'Hantera';

  @override
  String get s_setup => 'Inställning';

  @override
  String get s_device => 'Enhet';

  @override
  String get s_application => 'Applikation';

  @override
  String get s_settings => 'Inställningar';

  @override
  String get s_reset_settings => 'Återställ inställningar';

  @override
  String get l_reset_settings_desc => 'Återställ inställningar till standard';

  @override
  String get q_reset_settings => 'Återställ inställningar';

  @override
  String get p_reset_settings_confirmation_desc =>
      'Detta återställer alla inställningar till deras standardvärden.';

  @override
  String get s_support => 'Kundtjänst';

  @override
  String get s_certificates => 'Certifikat';

  @override
  String get s_security_key => 'Säkerhetsnyckel';

  @override
  String get s_slots => 'Slots';

  @override
  String get s_help_and_about => 'Hjälp & om';

  @override
  String get s_help => 'Hjälp';

  @override
  String get s_app_information => 'Applikationsinformation';

  @override
  String get s_home => 'Hem';

  @override
  String get s_user_guide => 'Användarhandbok';

  @override
  String get s_i_need_help => 'Jag behöver hjälp';

  @override
  String get s_terms_of_use => 'Användarvillkor';

  @override
  String get s_privacy_policy => 'Integritetspolicy';

  @override
  String get s_open_src_licenses => 'Licenser för öppen källkod';

  @override
  String get s_please_wait => 'Vänligen vänta…';

  @override
  String get s_secret_key => 'Hemlig nyckel';

  @override
  String get s_show_secret_key => 'Visa hemlig nyckel';

  @override
  String get s_hide_secret_key => 'Dölj hemlig nyckel';

  @override
  String get s_private_key => 'Privat nyckel';

  @override
  String get s_public_key => 'Publik nyckel';

  @override
  String get s_invalid_length => 'Ogiltig längd';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Ogiltigt format, tillåtna tecken: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Ogiltiga tecken för valt tangentbord';

  @override
  String get s_require_touch => 'Kräver beröring';

  @override
  String get q_have_account_info => 'Har du kontoinformation?';

  @override
  String get s_debugging_tools => 'Verktyg för felsökning';

  @override
  String get s_run_diagnostics => 'Kör diagnostik';

  @override
  String get l_run_diagnostics_desc => 'Kör diagnostik för att felsöka';

  @override
  String get s_logging_level => 'Loggnivå';

  @override
  String s_current_log_level(String level) {
    return 'Loggnivå: $level';
  }

  @override
  String get s_character_count => 'Antal tecken';

  @override
  String get s_language => 'Språk';

  @override
  String get s_app_theme => 'Applikationstema';

  @override
  String get s_system_default => 'Systemstandard';

  @override
  String get s_light_mode => 'Ljust läge';

  @override
  String get s_dark_mode => 'Mörkt läge';

  @override
  String get s_list_layout => 'Layout för lista';

  @override
  String get s_grid_layout => 'Layout för rutnät';

  @override
  String get s_mixed_layout => 'Blandad layout';

  @override
  String get s_select_layout => 'Välj layout';

  @override
  String get s_select_to_scan => 'Välj att skanna';

  @override
  String get s_hide_reader => 'Göm läsare';

  @override
  String get s_show_hidden_readers => 'Visa gömda läsare';

  @override
  String get s_toggle_readers => 'Växla läsare';

  @override
  String get l_toggle_readers_desc => 'Visa eller göm läsare';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Serienummer: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Firmware version: $version';
  }

  @override
  String get l_fips_capable => 'FIPS kapabel';

  @override
  String get l_fips_approved => 'FIPS godkänd';

  @override
  String get l_insert_yk => 'Sätt i din YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Sätt i eller tryck på en YubiKey';

  @override
  String get l_unplug_yk => 'Koppla ur din YubiKey';

  @override
  String get l_reinsert_yk => 'Sätt tillbaka din YubiKey';

  @override
  String get l_place_on_nfc_reader => 'Placera din YubiKey på NFC-läsaren';

  @override
  String get l_replace_yk_on_reader => 'Sätt tillbaka din YubiKey på läsaren';

  @override
  String get l_remove_yk_from_reader => 'Ta bort din YubiKey från NFC-läsaren';

  @override
  String get p_try_reinsert_yk => 'Försök att ta ut och sätta i YubiKey igen.';

  @override
  String get s_touch_required => 'Beröring krävs';

  @override
  String get l_touch_button_now => 'Tryck på knappen på din YubiKey nu';

  @override
  String get l_long_touch_button_now =>
      'Tryck och håll in knappen på din YubiKey i 10 sekunder nu';

  @override
  String get l_keep_touching_yk =>
      'Fortsätt att röra vid din YubiKey upprepade gånger…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Växla applikationer';

  @override
  String get s_toggle_interfaces => 'Växla gränssnitt';

  @override
  String get p_toggle_applications_desc =>
      'Aktivera eller inaktivera applikationer över tillgängliga transporter.';

  @override
  String get p_toggle_interfaces_desc =>
      'Aktivera eller inaktivera USB-gränssnitt.';

  @override
  String get l_toggle_applications_desc => 'Aktivera/inaktivera applikationer';

  @override
  String get l_toggle_interfaces_desc => 'Aktivera/avaktivera gränssnitt';

  @override
  String get s_reconfiguring_yk => 'Omkonfigurering av YubiKey…';

  @override
  String get s_config_updated => 'Konfigurationen uppdaterad';

  @override
  String get l_config_updated_reinsert =>
      'Konfigurationen uppdaterad, ta bort och sätt tillbaka din YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 avaktiverad';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn kräver att FIDO2 applikationen är aktiverad på din YubiKey';

  @override
  String get s_lock_code => 'Låskod';

  @override
  String get l_wrong_lock_code => 'Felaktig låskod';

  @override
  String get s_show_lock_code => 'Visa låskod';

  @override
  String get s_hide_lock_code => 'Dölj låskod';

  @override
  String get p_lock_code_required_desc =>
      'Den åtgärd som du ska utföra kräver att du anger koden för konfigurationslåset.';

  @override
  String get l_helper_not_responding => 'Hjälp processen svarar inte';

  @override
  String get l_yk_no_access => 'Det går inte att komma åt denna YubiKey';

  @override
  String get s_yk_inaccessible => 'Enheten är inte åtkomlig';

  @override
  String get l_open_connection_failed =>
      'Misslyckades med att öppna anslutningen';

  @override
  String get l_ccid_connection_failed =>
      'Misslyckades med att öppna anslutning för smartkort';

  @override
  String get p_ccid_service_unavailable =>
      'Kontrollera att din smartkortstjänst fungerar.';

  @override
  String get p_pcscd_unavailable =>
      'Kontrollera att pcscd är installerat och körs.';

  @override
  String get l_no_yk_present => 'Ingen YubiKey närvarande';

  @override
  String get s_unknown_type => 'Okänd typ';

  @override
  String get s_unknown_device => 'Okänd enhet';

  @override
  String get s_restricted_nfc => 'NFC-aktivering';

  @override
  String get l_deactivate_restricted_nfc => 'Så här aktiverar du NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Anslut din YubiKey till en USB-strömkälla, t.ex. en dator, i minst 3 sekunder.\n\nNär den är strömförsörjd aktiveras NFC och är klar att användas.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Din YubiKey är utrustad med Restricted NFC, en funktion som är utformad för att skydda mot trådlös manipulation under transport. Detta innebär att NFC-funktioner är tillfälligt inaktiverade tills du aktiverar dem.';

  @override
  String get s_unsupported_yk => 'YubiKey som inte stöds';

  @override
  String get p_operation_failed_try_again =>
      'Åtgärden misslyckades, vänligen försök igen.';

  @override
  String get l_configuration_unsupported => 'Konfiguration stöds inte';

  @override
  String get p_scp_unsupported =>
      'För att kommunicera via NFC kräver YubiKey teknik som inte stöds av den här telefonen. Anslut YubiKey till telefonens USB-port.';

  @override
  String get l_error_occurred => 'Ett fel har inträffat';

  @override
  String get s_application_error => 'Fel i ansökan';

  @override
  String get l_import_error => 'Fel vid import';

  @override
  String get l_file_not_found => 'Filen hittades inte';

  @override
  String get l_file_too_big => 'Filstorleken är för stor';

  @override
  String get l_filesystem_error => 'Fel i filsystemets funktion';

  @override
  String get s_pin => 'PIN-kod';

  @override
  String get s_puk => 'PUK-kod';

  @override
  String get s_set_pin => 'Ställ in PIN-kod';

  @override
  String get s_change_pin => 'Ändra PIN-kod';

  @override
  String get s_change_puk => 'Ändra PUK-kod';

  @override
  String get s_show_pin => 'Visa PIN-kod';

  @override
  String get s_hide_pin => 'Dölj PIN-kod';

  @override
  String get s_show_puk => 'Visa PUK-kod';

  @override
  String get s_hide_puk => 'Dölj PUK-kod';

  @override
  String get s_current_pin => 'Nuvarande PIN-kod';

  @override
  String get s_current_puk => 'Nuvarande PUK-kod';

  @override
  String get s_new_pin => 'Ny PIN-kod';

  @override
  String get s_new_puk => 'Ny PUK-kod';

  @override
  String get s_confirm_pin => 'Bekräfta PIN-kod';

  @override
  String get s_confirm_puk => 'Bekräfta PUK-kod';

  @override
  String get s_unblock_pin => 'Återställ PIN';

  @override
  String get l_pin_mismatch => 'PIN-koderna stämmer inte överens';

  @override
  String get l_puk_mismatch => 'PUK-koderna stämmer inte överens';

  @override
  String get s_pin_set => 'PIN-kod satt';

  @override
  String get s_puk_set => 'PUK-kod satt';

  @override
  String l_set_pin_failed(String message) {
    return 'Det gick inte att sätta PIN-kod: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries försök återstår',
      one: '$retries försök återstår',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries försök återstår',
      one: '$retries försök återstår',
    );
    return 'Fel PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries försök återstår',
      one: '$retries försök återstår',
    );
    return 'Fel PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'FIDO PIN-skydd';

  @override
  String get s_pin_change_required => 'Ändring av PIN-kod krävs';

  @override
  String get l_enter_fido2_pin => 'Ange FIDO2 PIN-koden för din YubiKey';

  @override
  String get p_fido2_pin_required =>
      'Den åtgärd du ska utföra kräver att du anger FIDO2 PIN-koden.';

  @override
  String get l_pin_blocked_reset =>
      'PIN-koden är blockerad; fabriksåterställ FIDO-applikationen';

  @override
  String get l_pin_blocked => 'PIN-koden är spärrad';

  @override
  String get l_set_pin_first => 'En PIN-kod krävs';

  @override
  String get l_unlock_pin_first => 'Lås upp med PIN-kod';

  @override
  String get l_pin_soft_locked =>
      'PIN-koden har spärrats tills YubiKey tas ut och sätts in igen';

  @override
  String get l_pin_change_required_desc =>
      'En ny PIN-kod måste anges innan du kan använda denna applikation';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'En PIN måste vara $min_length-$max_length tecken lång och kan innehålla bokstäver, siffror och specialtecken.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'En PIN måste vara $min_length-$max_length tecken lång, innehålla minst $unique_characters unika tecken, och inte vara en vanlig PIN-kod, som \"$common_pin\". Det kan innehålla bokstäver, siffror och specialtecken.';
  }

  @override
  String get s_ep_attestation => 'Företagsintyg';

  @override
  String get s_ep_attestation_enabled => 'Företagsattestering aktiverad';

  @override
  String get q_enable_ep_attestation => 'Aktivera Enterprise Attestation?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Detta möjliggör Enterprise Attestation, vilket gör att auktoriserade domäner kan identifiera din YubiKey på ett unikt sätt.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'När Enterprise Attestation har aktiverats kan den endast avaktiveras genom att utföra en fabriksåterställning av FIDO.';

  @override
  String get s_pin_required => 'PIN-kod krävs';

  @override
  String get p_pin_required_desc =>
      'Den åtgärd du ska utföra kräver att du anger PIV PIN-koden.';

  @override
  String get l_piv_pin_blocked => 'Blockerad, använd PUK för att återställa';

  @override
  String get p_piv_pin_blocked_desc =>
      'PIN-koden är blockerad. Använd PUK för att återställa den.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'PIN-koden är blockerad. En fabriksåterställning krävs.';

  @override
  String get l_piv_pin_puk_blocked => 'Blockerad, fabriksåterställning krävs';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Både PIN och PUK är blockerade. En fabriksåterställning av PIV applikationen krävs.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'En $name måste vara minst $length tecken lång.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'En $name måste vara minst $length tecken lång, innehålla minst 2 unika tecken och får inte vara en vanligt förekommande $name, som \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Nya $name uppfyller inte kraven på komplexitet.';
  }

  @override
  String get s_dismiss => 'Avfärda';

  @override
  String get p_default_pin_puk_key_desc =>
      'Det rekommenderas att ändra standard PIN, PUK och management nyckel.';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      'För FIPS-efterlevnad krävs det att ändra standard PIN, PUK och hanteringsnyckel.';

  @override
  String get l_warning_default_pin => 'Varning: Standard-PIN används';

  @override
  String get l_warning_default_puk => 'Varning: Standard PUK används';

  @override
  String get l_default_pin_used => 'Standard-PIN används';

  @override
  String get l_default_puk_used => 'Standard PUK används';

  @override
  String get l_pin_complexity => 'PIN-komplexitet genomdrivs';

  @override
  String get s_password => 'Lösenord';

  @override
  String get s_manage_password => 'Hantera lösenord';

  @override
  String get s_set_password => 'Ställ in lösenord';

  @override
  String get s_password_set => 'Lösenordsinställning';

  @override
  String get s_show_password => 'Visa lösenord';

  @override
  String get s_hide_password => 'Dölj lösenord';

  @override
  String get l_password_protection => 'Lösenordsskydd för konton';

  @override
  String get s_new_password => 'Nytt lösenord';

  @override
  String get s_current_password => 'Nuvarande lösenord';

  @override
  String get s_confirm_password => 'Bekräfta lösenord';

  @override
  String get l_password_mismatch => 'Lösenorden matchar inte';

  @override
  String get s_wrong_password => 'Felaktigt lösenord';

  @override
  String get p_wrong_password =>
      'Fel lösenord. Om du glömt ditt lösenord måste du fabriksåterställa YubiKey.';

  @override
  String get s_remove_password => 'Ta bort lösenord';

  @override
  String get s_password_removed => 'Lösenord borttaget';

  @override
  String get s_remember_password => 'Kom ihåg lösenord';

  @override
  String get s_clear_saved_password => 'Rensa sparat lösenord';

  @override
  String get s_password_forgotten => 'Lösenord glömt';

  @override
  String get l_keystore_unavailable => 'OS Keystore inte tillgänglig';

  @override
  String get l_remember_pw_failed => 'Kom inte ihåg lösenordet';

  @override
  String get l_unlock_first => 'Lås upp med lösenord';

  @override
  String get l_set_password_first => 'Ställ in ett lösenord';

  @override
  String get l_enter_oath_pw => 'Ange OATH-lösenordet för din YubiKey';

  @override
  String get p_new_password_requirements =>
      'Ett lösenord kan innehålla bokstäver, siffror och specialtecken.';

  @override
  String get s_management_key => 'Management nyckel';

  @override
  String get s_current_management_key => 'Nuvarande management-nyckel';

  @override
  String get s_new_management_key => 'Ny management-nyckel';

  @override
  String get l_change_management_key => 'Ändra management-nyckel';

  @override
  String get l_management_key_changed => 'Förvaltningsnyckel ändrad';

  @override
  String get l_default_key_used => 'Standardhanteringsnyckel används';

  @override
  String get s_generate_random => 'Generera slumpmässigt';

  @override
  String get s_use_default => 'Använd standard';

  @override
  String get l_warning_default_key =>
      'Varning för felaktig nyckel: Standardnyckel används';

  @override
  String get s_protect_key => 'Skydda med PIN-kod';

  @override
  String get p_protect_key_desc =>
      'Använd PIN-koden i stället för management nyckeln vid åtgärder som kräver autentisering av management nyckeln.';

  @override
  String get s_management_key_algorithm => 'Management nyckelalgoritm';

  @override
  String get p_management_key_algorithm_desc =>
      'Algoritmen att välja för management nyckel.';

  @override
  String get l_pin_protected_key => 'PIN-kod kan användas istället';

  @override
  String get l_wrong_key => 'Fel tangent';

  @override
  String get l_unlock_piv_management => 'Lås upp PIV-hantering';

  @override
  String get p_unlock_piv_management_desc =>
      'Åtgärden du ska utföra kräver PIV management nyckeln.';

  @override
  String l_account(String label) {
    return 'Konto: $label';
  }

  @override
  String get s_accounts => 'Konton';

  @override
  String get s_no_accounts => 'Inga konton';

  @override
  String l_results_for(String query) {
    return 'Resultat för \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Kom igång med OTP-konton';

  @override
  String get l_no_accounts_desc =>
      'Lägg till konton till din YubiKey från alla tjänsteleverantörer som stöder OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Lägg till konto';

  @override
  String get p_add_account_desc =>
      'Skanna QR-kod eller ange kontouppgifterna manuellt.';

  @override
  String get s_add_accounts => 'Lägg till konto(n)';

  @override
  String get l_drop_qr_description =>
      'Släpp QR-kod för att lägga till konto(n)';

  @override
  String get p_add_account_three_ways =>
      'Det finns tre sätt att lägga till konton.';

  @override
  String get s_scanning => 'Skanna (rekommenderas)';

  @override
  String get p_scanning_desc =>
      'Innan du skannar en QR-kod, se till att hela koden är synlig på skärmen.';

  @override
  String get s_drag_and_drop => 'Dra och släpp';

  @override
  String get p_drag_and_drop_desc =>
      'En bild som innehåller en QR-kod kan släppas var som helst i kontovyn.';

  @override
  String get s_manually => 'Manuellt';

  @override
  String get p_manually_desc =>
      'Kontouppgifter kan anges manuellt i formuläret.';

  @override
  String get s_account_added => 'Konto tillagt';

  @override
  String l_account_add_failed(String message) {
    return 'Misslyckades med att lägga till konto: $message';
  }

  @override
  String get l_add_account_password_required => 'Lösenord krävs';

  @override
  String get l_add_account_unlock_required => 'Upplåsning krävs';

  @override
  String get l_add_account_func_missing =>
      'Funktionalitet saknas eller är inaktiverad';

  @override
  String get l_account_name_required => 'Ditt konto måste ha ett namn';

  @override
  String get l_name_already_exists => 'Detta namn finns redan för emittenten';

  @override
  String get l_account_already_exists => 'Detta konto finns redan på YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Ogiltigt tecken: \':\' är inte tillåtet i issuer';

  @override
  String get l_select_accounts =>
      'Välj konto(n) som ska läggas till på YubiKey';

  @override
  String get s_pin_account => 'Fäst konto';

  @override
  String get s_unpin_account => 'Avmarkera konto';

  @override
  String get s_no_pinned_accounts => 'Inga fastlåsta konton';

  @override
  String get s_pinned => 'Pinned';

  @override
  String get l_pin_account_desc => 'Håll dina viktiga konton samlade';

  @override
  String get s_rename_account => 'Byt namn på konto';

  @override
  String get l_rename_account_desc => 'Redigera kontots utfärdare/namn';

  @override
  String get s_account_renamed => 'Konto bytt namn';

  @override
  String l_rename_account_failed(String message) {
    return 'Det gick inte att byta namn på kontot: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Detta ändrar hur kontot visas i listan.';

  @override
  String get s_delete_account => 'Radera konto';

  @override
  String get q_delete_account => 'Radera konto?';

  @override
  String get l_delete_account_desc => 'Ta bort kontot från din YubiKey';

  @override
  String get s_account_deleted => 'Konto raderat';

  @override
  String get p_warning_delete_account =>
      'Varning för detta! Denna åtgärd kommer att radera kontot från din YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Se till att inaktivera det här kontot från den tjänst det är registrerat med för att undvika att bli utelåst.';

  @override
  String get s_account_name => 'Kontonamn';

  @override
  String get s_search_accounts => 'Sök konton';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used av $capacity konton som används';
  }

  @override
  String s_num_digits(int num) {
    return '$num siffror';
  }

  @override
  String s_num_sec(int num) {
    return '$num sek';
  }

  @override
  String get s_issuer_optional => 'Utfärdare (valfritt)';

  @override
  String get s_counter_based => 'Räknare baserad';

  @override
  String get s_time_based => 'Tidsbaserad';

  @override
  String get l_copy_code_desc => 'Klistra in koden i ett annat program';

  @override
  String get l_calculate_code_desc => 'Få en ny kod från din YubiKey';

  @override
  String get s_rp_id => 'RP-ID';

  @override
  String get s_user_id => 'Användar-ID';

  @override
  String get s_credential_id => 'Legitimations-ID';

  @override
  String get s_display_name => 'Visningsnamn';

  @override
  String get s_user_name => 'Användarnamn';

  @override
  String get s_passkeys => 'Passkeys';

  @override
  String get s_no_passkeys => 'Inga passkeys';

  @override
  String get l_ready_to_use => 'Klar att använda';

  @override
  String get l_register_sk_on_websites =>
      'Registrera som säkerhetsnyckel på webbplatser';

  @override
  String get l_no_discoverable_accounts => 'Inga passkeys lagrade';

  @override
  String get p_non_passkeys_note =>
      'Icke-passkey autentiseringsuppgifter kan finnas, men kan inte listas.';

  @override
  String get s_delete_passkey => 'Radera passkey';

  @override
  String get q_delete_passkey => 'Radera passkey?';

  @override
  String get l_delete_passkey_desc => 'Ta bort passkey från YubiKey';

  @override
  String get s_passkey_deleted => 'Passkey raderad';

  @override
  String get p_warning_delete_passkey =>
      'Varning! Denna åtgärd kommer att ta bort vald passkey från din YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Du kommer inte längre att kunna använda den här passkey för den tjänst där den är registrerad.';

  @override
  String get l_do_not_remove_yk_delete => 'Ta inte bort YubiKey under radering';

  @override
  String get s_search_passkeys => 'Sök passkeys';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used av $max använda passkeys.';
  }

  @override
  String get s_biometrics => 'Biometri';

  @override
  String l_fingerprint(String label) {
    return 'Fingeravtryck: $label';
  }

  @override
  String get s_fingerprints => 'Fingeravtryck';

  @override
  String get l_fingerprint_captured =>
      'Fingeravtrycket har registrerats framgångsrikt!';

  @override
  String get s_fingerprint_added => 'Fingeravtryck läggs till';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Fel vid tillägg av fingeravtryck: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Namn på felinställning: $message';
  }

  @override
  String get s_setup_fingerprints => 'Skapa fingeravtryck';

  @override
  String get p_setup_fingerprints_desc =>
      'Fingeravtryck måste upprättas innan nyckeln kan användas.';

  @override
  String get s_add_fingerprint => 'Lägg till fingeravtryck';

  @override
  String get s_delete_fingerprint => 'Radera fingeravtryck';

  @override
  String get q_delete_fingerprint => 'Radera fingeravtryck?';

  @override
  String get l_delete_fingerprint_desc =>
      'Ta bort fingeravtrycket från YubiKey';

  @override
  String get s_fingerprint_deleted => 'Fingeravtryck raderat';

  @override
  String get p_warning_delete_fingerprint =>
      'Detta raderar fingeravtrycket från din YubiKey.';

  @override
  String get s_fingerprints_get_started => 'Kom igång med fingeravtryck';

  @override
  String get p_set_fingerprints_desc =>
      'Innan det går att registrera fingeravtryck måste en PIN-kod anges.';

  @override
  String get l_no_fps_added => 'Inga fingeravtryck har lagts till';

  @override
  String get s_rename_fp => 'Byt namn på fingeravtryck';

  @override
  String get l_rename_fp_desc => 'Ändra namn';

  @override
  String get s_fingerprint_renamed => 'Fingeravtryck omdöpt';

  @override
  String l_rename_fp_failed(String message) {
    return 'Fel vid namnändring: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Lägg till ett eller flera (upp till fem) fingeravtryck';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 fingeravtryck registrerade';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Tryck fingret mot YubiKey för att börja.';

  @override
  String get l_name_fingerprint => 'Namnge detta fingeravtryck';

  @override
  String get l_user_action_timeout_error =>
      'Misslyckades på grund av inaktivitet hos användaren';

  @override
  String get l_wrong_inserted_yk_error =>
      'Återinsatt YubiKey matchar inte den ursprungliga enheten';

  @override
  String get l_failed_connecting_to_fido =>
      'Misslyckades med att ansluta till FIDO-gränssnittet';

  @override
  String get l_self_signed_certificate => 'Självsignerat certifikat';

  @override
  String get l_certificate_signing_request =>
      'Begäran om certifikatsignering (CSR)';

  @override
  String get s_certificate => 'Certifikat';

  @override
  String get s_subject => 'Ämne';

  @override
  String get l_export_csr_file => 'Spara CSR till fil';

  @override
  String get l_export_public_key => 'Exportera offentlig nyckel';

  @override
  String get l_export_public_key_file => 'Spara offentlig nyckel till fil';

  @override
  String get l_export_public_key_desc =>
      'Exportera den offentliga nyckeln till en fil';

  @override
  String get l_public_key_exported => 'Public key exporterad';

  @override
  String get l_export_certificate => 'Exportera certifikat';

  @override
  String get l_export_certificate_file => 'Exportera certifikat till fil';

  @override
  String get l_export_certificate_desc => 'Exportera certifikatet till en fil';

  @override
  String get l_certificate_exported => 'Certifikat exporterat';

  @override
  String get l_select_import_file => 'Välj fil att importera';

  @override
  String get l_import_file => 'Importera fil';

  @override
  String get l_import_desc => 'Importera en nyckel och/eller ett certifikat';

  @override
  String get l_import_nothing => 'Inget att importera';

  @override
  String get l_importing_file => 'Importera fil…';

  @override
  String get s_file_imported => 'Fil importerad';

  @override
  String get l_unsupported_key_type => 'Typ av nyckel som inte stöds';

  @override
  String get l_delete_certificate => 'Radera certifikat';

  @override
  String get q_delete_certificate => 'Radera certifikat?';

  @override
  String get l_delete_certificate_desc =>
      'Ta bort certifikatet från din YubiKey';

  @override
  String get l_delete_key => 'Radera nyckel';

  @override
  String get q_delete_key => 'Radera nyckel?';

  @override
  String get l_delete_key_desc => 'Ta bort nyckeln från din YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Radera certifikat/nyckel';

  @override
  String get q_delete_certificate_or_key => 'Radera certifikat/nyckel?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Ta bort certifikatet eller nyckeln från din YubiKey';

  @override
  String get l_move_key => 'Flytta tangent';

  @override
  String get l_move_key_desc =>
      'Flytta en nyckel från en PIV-plats till en annan';

  @override
  String get l_change_defaults => 'Ändra standardåtkomstkoder';

  @override
  String get s_issuer => 'Utfärdare';

  @override
  String get s_serial => 'Serie';

  @override
  String get s_certificate_fingerprint => 'Fingeravtryck';

  @override
  String get s_valid_from => 'Giltig från';

  @override
  String get s_valid_to => 'Giltig till';

  @override
  String get l_no_certificate => 'Inget certifikat laddat';

  @override
  String get l_key_no_certificate => 'Nyckel utan certifikat laddad';

  @override
  String get s_generate_key => 'Generera nyckel';

  @override
  String get l_generate_desc => 'Generera ett nytt certifikat eller CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Detta kommer att generera en ny nyckel på YubiKey i PIV slot $slot.';
  }

  @override
  String get s_private_key_generated => 'Privat nyckel genererad';

  @override
  String get p_select_what_to_delete =>
      'Välj vad som ska tas bort från spelautomaten.';

  @override
  String get p_warning_delete_certificate =>
      'Varning för detta! Denna åtgärd kommer att radera certifikatet från YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Varning för detta! Denna åtgärd raderar den privata nyckeln från din YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Varning för detta! Denna åtgärd raderar certifikatet och den privata nyckeln från din YubiKey.';

  @override
  String get p_warning_usb_preferred =>
      'Föredra USB för RSA nycklar. NFC kan resultera i fel.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Detta kommer att radera certifikatet i PIV slot $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Detta kommer att radera den privata nyckeln i PIV slot $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Detta kommer att radera certifikatet och den privata nyckeln i PIV slot $slot.';
  }

  @override
  String get l_certificate_deleted => 'Certifikat raderat';

  @override
  String get l_key_deleted => 'Nyckel borttagen';

  @override
  String get l_certificate_and_key_deleted => 'Certifikat och nyckel raderade';

  @override
  String get l_include_certificate => 'Inkludera certifikat';

  @override
  String get l_select_destination_slot => 'Välj destinationsplats';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Flytta den privata nyckeln i PIV-platsen $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Flytta den privata nyckeln i PIV-platsen $from_slot till platsen $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Flytta den privata nyckeln och certifikatet i PIV-platsen $from_slot till platsen $to_slot?';
  }

  @override
  String get p_password_protected_file =>
      'Den valda filen är lösenordsskyddad.';

  @override
  String p_import_items_desc(String slot) {
    return 'Följande artiklar kommer att importeras till PIV-platsen $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Den publika nyckeln till certifikatet matchar inte den privata nyckeln i slot:en';

  @override
  String get l_key_moved => 'Nyckel flyttas';

  @override
  String get l_key_and_certificate_moved => 'Nyckel och certifikat flyttas';

  @override
  String get p_subject_desc =>
      'Ett DN (distinguished name) formaterat i enlighet med RFC 4514-specifikationen.';

  @override
  String get l_rfc4514_invalid => 'Ogiltigt RFC 4514-format';

  @override
  String get rfc4514_examples =>
      'Exempel:\nCN=Example Namn\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => 'Tillåt fingeravtryck';

  @override
  String get s_pin_policy => 'PIN policy';

  @override
  String get s_output_format => 'Spara som';

  @override
  String get s_expiration_date => 'Förfallodatum';

  @override
  String get p_algorithm_desc => 'Nyckelalgoritm att använda.';

  @override
  String get p_expiration_date_desc =>
      'Datum då certifikatet upphör att gälla, standard 1 år (endast certifikat).';

  @override
  String get p_key_options_bio_desc =>
      'Tillåt att biometri används i stället för PIN-kod.';

  @override
  String get q_overwrite_slot => 'Skriv över slot?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Detta kommer permanent att skriva över befintligt innehåll i slot $slot.';
  }

  @override
  String get l_overwrite_cert => 'Certifikatet kommer att skrivas över';

  @override
  String get l_overwrite_key => 'Den privata nyckeln kommer att skrivas över';

  @override
  String get l_overwrite_key_maybe =>
      'Alla befintliga privata nycklar i kortplatsen skrivs över';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Autentisering';

  @override
  String get s_slot_9c => 'Digital signatur';

  @override
  String get s_slot_9d => 'Nyckelhantering';

  @override
  String get s_slot_9e => 'Autentisering av kort';

  @override
  String get s_retired_slot => 'Pensionerad Key Management';

  @override
  String get s_otp_slot_one => 'Kort touch';

  @override
  String get s_otp_slot_two => 'Lång beröring';

  @override
  String get l_otp_slot_empty => 'Spåret är tomt';

  @override
  String get l_otp_slot_configured => 'Kortplatsen är konfigurerad';

  @override
  String get l_yubiotp_desc => 'Programmera en Yubico OTP-legitimation';

  @override
  String get s_challenge_response => 'Utmaning-svar';

  @override
  String get l_challenge_response_desc =>
      'Programmera en referens för utmaning/svar';

  @override
  String get s_static_password => 'Statiskt lösenord';

  @override
  String get l_static_password_desc => 'Konfigurera ett statiskt lösenord';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc =>
      'Programmera en HMAC-SHA1-baserad autentiseringsuppgift';

  @override
  String get s_public_id => 'Offentligt ID';

  @override
  String get s_private_id => 'Privat ID';

  @override
  String get s_use_serial => 'Använd seriell';

  @override
  String get l_select_file => 'Välj fil';

  @override
  String get l_no_export_file => 'Ingen exportfil';

  @override
  String get s_no_export => 'Ingen export';

  @override
  String get s_export => 'Export';

  @override
  String get l_export_configuration_file => 'Exportera konfiguration till fil';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Exporterade referenser kan laddas upp på $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Tangentbord $layout';
  }

  @override
  String get s_delete_slot => 'Ta bort referenser';

  @override
  String get q_delete_slot => 'Ta bort kontouppgifter?';

  @override
  String get l_delete_slot_desc => 'Ta bort referensen i facket';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Varning för detta! Denna åtgärd kommer permanent att ta bort referensen från plats $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Legitimation raderad';

  @override
  String get s_swap => 'Byta';

  @override
  String get s_swap_slots => 'Byt platser';

  @override
  String get q_swap_slots => 'Växla slots?';

  @override
  String get l_swap_slots_desc => 'Byt kort/lång beröring';

  @override
  String get p_swap_slots_desc =>
      'Detta kommer att ändra konfigurationen för de två platserna.';

  @override
  String get l_slots_swapped => 'Slot-konfigurationer utbytta';

  @override
  String l_slot_credential_configured(String type) {
    return 'Konfigurerad $type -legitimation';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Konfigurerad $type -legitimation och exporterad till $file';
  }

  @override
  String get s_append_enter => 'Tillägg ⏎';

  @override
  String get l_append_enter_desc =>
      'Lägg till en Enter-tangenttryckning efter att OTP:n har skickats ut';

  @override
  String get p_otp_swap_error =>
      'Misslyckades med att byta kortplatser! Kontrollera att YubiKey inte har begränsad åtkomst.';

  @override
  String get l_wrong_access_code => 'Fel åtkomstkod';

  @override
  String get s_access_code => 'Åtkomstkod';

  @override
  String get s_show_access_code => 'Visa åtkomstkod';

  @override
  String get s_hide_access_code => 'Dölj åtkomstkod';

  @override
  String p_enter_access_code(String slot) {
    return 'Ange åtkomstkod för slot $slot.';
  }

  @override
  String get s_enable_nfc => 'Aktivera NFC';

  @override
  String get s_request_access => 'Begär åtkomst';

  @override
  String get s_permission_denied => 'Behörighet nekad';

  @override
  String get l_elevating_permissions => 'Höjda behörigheter…';

  @override
  String get s_review_permissions => 'Granska behörigheter';

  @override
  String get s_open_windows_settings => 'Öppna Windows-inställningar';

  @override
  String get l_admin_privileges_required => 'Administratörsbehörighet krävs';

  @override
  String get p_elevated_permissions_required =>
      'För att hantera den här enheten krävs förhöjda behörigheter. Alternativt kan du använda Windows-inställningar för att hantera FIDO-konfigurationen.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'WebAuthn-hantering kräver förhöjda behörigheter. Alternativt kan du använda Windows-inställningar för att hantera FIDO-konfigurationen.';

  @override
  String get p_ms_store_permission_note =>
      'Microsoft Store-versionen av appen kan i allmänhet inte höja behörigheterna på grund av begränsningar sandboxning i Windows. Vi rekommenderar att du installerar Yubico Authenticator från vårt officiella .msi installationsprogram.';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator behöver kamerabehörighet för att skanna QR-koder.';

  @override
  String get s_qr_scan => 'Skanna QR-kod';

  @override
  String get l_invalid_qr => 'Ogiltig QR-kod';

  @override
  String get l_qr_not_found => 'Ingen QR-kod hittades';

  @override
  String get l_qr_scanned => 'Skannad QR-kod';

  @override
  String l_qr_file_too_large(String max) {
    return 'Filen är för stor (max $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Ogiltig bildfil';

  @override
  String get l_qr_select_file => 'Välj fil med QR-kod';

  @override
  String l_qr_not_read(String message) {
    return 'Misslyckades med att läsa QR-koden: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Rikta kameran mot en QR-kod för att skanna den';

  @override
  String get q_want_to_scan => 'Skulle du vilja skanna?';

  @override
  String get q_no_qr => 'Ingen QR-kod?';

  @override
  String get s_enter_manually => 'Ange manuellt';

  @override
  String get s_read_from_file => 'Läs från fil';

  @override
  String get s_reset => 'Återställ';

  @override
  String get s_factory_reset => 'Fabriksåterställning';

  @override
  String get l_factory_reset_desc => 'Återställ YubiKey-standardvärden';

  @override
  String get l_factory_reset_required => 'Fabriksåterställning krävs';

  @override
  String get l_oath_application_reset => 'Återställning av OATH-ansökan';

  @override
  String get l_fido_app_reset => 'Återställning av FIDO-applikation';

  @override
  String l_reset_failed(String message) {
    return 'Fel vid återställning: $message';
  }

  @override
  String get l_piv_app_reset => 'Återställning av PIV-ansökan';

  @override
  String get p_factory_reset_an_app =>
      'Fabriksåterställ en applikation på din YubiKey.';

  @override
  String get p_factory_reset_desc =>
      'Data lagras i flera applikationer på YubiKey, varav vissa kan fabriksåterställas oberoende av varandra.\n\nVälj en applikation ovan för att återställa.';

  @override
  String get p_warning_factory_reset =>
      'Varning för detta! Detta kommer oåterkalleligen att radera alla OATH TOTP / HOTP-konton från din YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Dina OATH-uppgifter, liksom alla lösenord, kommer att tas bort från denna YubiKey. Se till att inaktivera dessa från deras respektive webbplatser för att undvika att bli utelåsta från dina konton.';

  @override
  String get p_warning_deletes_accounts =>
      'Varning! Detta kommer oåterkalleligen att radera alla U2F- och FIDO2-konton, inklusive passkeys, från din YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Dina inloggningsuppgifter, liksom eventuella PIN-koder, kommer att tas bort från denna YubiKey. Se till att inaktivera dessa från deras respektive webbplatser för att undvika att bli utelåsta från dina konton.';

  @override
  String l_reset_not_allowed_over(String transport) {
    return 'FIDO återställning är inaktiverad över $transport';
  }

  @override
  String get p_warning_piv_reset =>
      'Varning för detta! Alla data som lagras för PIV kommer oåterkalleligen att raderas från din YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'Detta inkluderar privata nycklar och certifikat. Din PIN-kod, PUK-kod och administrationsnyckel återställs till fabriksinställningarna.';

  @override
  String get p_warning_global_reset =>
      'Varning för detta! Detta kommer oåterkalleligen att radera alla sparade data, inklusive inloggningsuppgifter, från din YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Fabriksåterställ applikationerna på din YubiKey. PIN-koden återställs till fabriksinställt värde och registrerade fingeravtryck tas bort. Alla nycklar, certifikat eller andra referenser tas bort permanent.';

  @override
  String get l_copy_to_clipboard => 'Kopiera till urklipp';

  @override
  String get s_code_copied => 'Kod kopierad';

  @override
  String get l_code_copied_clipboard => 'Kod kopierad till urklipp';

  @override
  String get s_copy_log => 'Kopiera logg';

  @override
  String get l_copy_log_clipboard => 'Kopiera logg till urklipp';

  @override
  String get l_log_copied => 'Logg kopierad till urklipp';

  @override
  String get l_diagnostics_copied => 'Diagnosdata kopieras till urklipp';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label kopieras till urklipp.';
  }

  @override
  String get s_custom_icons => 'Anpassade ikoner';

  @override
  String get l_set_icons_for_accounts => 'Ange ikoner för konton';

  @override
  String get p_custom_icons_description =>
      'Ikonpaket kan göra det lättare att urskilja dina konton med bekanta logotyper och färger.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Ikonpaket använder formatet $aegis_icon_pack. Du kan ladda ner ett färdigt ikonpaket eller skapa ditt eget.';
  }

  @override
  String get s_replace_icon_pack => 'Byt ut ikonpaket';

  @override
  String get l_loading_icon_pack => 'Laddar ikonpaket…';

  @override
  String get s_load_icon_pack => 'Ladda ikonpaket';

  @override
  String get l_load_icon_pack_desc => 'Ladda ikonpaket från fil';

  @override
  String get s_remove_icon_pack => 'Ta bort ikonpaket';

  @override
  String get l_remove_icon_pack_desc => 'Ta bort det aktiva ikonpaketet';

  @override
  String get l_icon_pack_removed => 'Ikonpaket borttaget';

  @override
  String get l_remove_icon_pack_failed => 'Fel vid borttagning av ikonpaket';

  @override
  String get s_choose_icon_pack => 'Välj ikonpaket';

  @override
  String get l_icon_pack_imported => 'Ikonpaket importerat';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Fel vid import av ikonpaket: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Ogiltigt ikonpaket';

  @override
  String get l_icon_pack_copy_failed =>
      'Misslyckades med att kopiera ikonpaketfiler';

  @override
  String get s_nfc_and_usb_options => 'NFC & USB inställningar';

  @override
  String get l_nfc_and_usb_options_desc => 'Konfigurera åtgärd för YubiKey';

  @override
  String get l_on_yk_nfc_tap => 'Vid NFC aktivering';

  @override
  String get l_on_yk_usb_insert => 'Vid USB inmatning';

  @override
  String get l_do_nothing => 'Gör ingenting';

  @override
  String get l_launch_ya => 'Starta Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Kopiera OTP till urklipp';

  @override
  String get l_launch_and_copy_otp => 'Starta appen och kopiera OTP';

  @override
  String get l_kbd_layout_for_static =>
      'Tangentbordslayout (för statiskt lösenord)';

  @override
  String get s_choose_kbd_layout => 'Välj tangentbordslayout';

  @override
  String get l_bypass_touch_requirement => 'Bypass touch-krav';

  @override
  String get l_bypass_touch_requirement_on =>
      'Konton som kräver beröring visas automatiskt via NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Konton som kräver beröring behöver en extra tryckning via NFC';

  @override
  String get s_silence_nfc_sounds => 'Tysta NFC-ljud';

  @override
  String get l_silence_nfc_sounds_on =>
      'Inga ljud kommer att spelas upp vid NFC-tryckning';

  @override
  String get l_silence_nfc_sounds_off =>
      'Ljudet kommer att spela på NFC-kranen';

  @override
  String get l_launch_app_on_usb_on =>
      'Detta förhindrar andra appar från att använda YubiKey via USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Andra appar kan använda YubiKey via USB';

  @override
  String get s_allow_screenshots => 'Tillåt skärmdumpar';

  @override
  String get l_allow_screenshots_desc =>
      'Tillåt andra appar att ta skärmbilder';

  @override
  String get s_nfc_ready_to_scan => 'Redo att skanna';

  @override
  String get s_nfc_hold_still => 'Håll stilla…';

  @override
  String get s_nfc_tap_your_yubikey => 'Tryck på din YubiKey';

  @override
  String get s_nfc_remove_key => 'Ta bort YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Misslyckades med skanningen, försök igen';

  @override
  String get s_usb_processing => 'Läser data från YubiKey';

  @override
  String get s_usb_dont_remove =>
      'Låt nyckeln sitta kvar – ta inte bort nyckeln…';

  @override
  String get l_usb_read_error => 'Misslyckades att läsa data från YubiKey';

  @override
  String get p_ndef_set_otp =>
      'Kopierade framgångsrikt OTP-kod från YubiKey till urklipp.';

  @override
  String get p_ndef_set_password =>
      'Kopierade lösenordet från YubiKey till urklipp.';

  @override
  String get p_ndef_parse_failure =>
      'Misslyckades med att tolka OTP-koden från YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Det gick inte att komma åt urklipp när man försökte kopiera OTP-kod från YubiKey.';

  @override
  String get s_set_label => 'Ställ in etikett';

  @override
  String get s_set_color => 'Ställ in färg';

  @override
  String get s_change_label => 'Ändra etikett';

  @override
  String get p_set_will_add_custom_name =>
      'Detta ger din YubiKey ett eget namn.';

  @override
  String get p_rename_will_change_custom_name =>
      'Detta kommer att ändra etiketten på din YubiKey.';

  @override
  String get s_keyboard_shortcuts => 'Tangentbords kortkommandon';

  @override
  String get s_global_shortcuts => 'Globala kortkommandon';

  @override
  String get s_application_shortcuts => 'Snabbkommandon';

  @override
  String s_quit_app(String app) {
    return 'Avsluta $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Dölj $app';
  }

  @override
  String get s_search => 'Sök';

  @override
  String get s_next_device => 'Nästa enhet';

  @override
  String get s_previous_device => 'Föregående enhet';

  @override
  String get s_open_settings => 'Öppna inställningar';

  @override
  String get s_open_item => 'Öppna objekt';

  @override
  String get s_edit_item => 'Redigera objekt';

  @override
  String get s_delete_item => 'Radera objekt';

  @override
  String get s_calculate_oath_code => 'Beräkna OATH-kod';

  @override
  String get s_open_keyboard_shortcuts => 'Öppna kortkommandon för tangentbord';
}
