// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'English';

  @override
  String s_translated(int percentage) {
    return 'Translated: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Proofread: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Incomplete translation';

  @override
  String get p_translation_progress_desc =>
      'Progress indicators reflect the maturity of the translation.';

  @override
  String get s_community => 'Community';

  @override
  String get l_localization_project => 'Localization project';

  @override
  String get s_save => 'Save';

  @override
  String get s_cancel => 'Cancel';

  @override
  String get s_close => 'Close';

  @override
  String get s_delete => 'Delete';

  @override
  String get s_move => 'Move';

  @override
  String get s_quit => 'Quit';

  @override
  String get s_enable => 'Enable';

  @override
  String get s_enabled => 'Enabled';

  @override
  String get s_disabled => 'Disabled';

  @override
  String get s_status => 'Status';

  @override
  String get s_unlock => 'Unlock';

  @override
  String get s_calculate => 'Calculate';

  @override
  String get s_import => 'Import';

  @override
  String get s_overwrite => 'Overwrite';

  @override
  String get s_done => 'Done';

  @override
  String get s_success => 'Success';

  @override
  String get s_loading => 'Loading…';

  @override
  String get s_more => 'More';

  @override
  String get s_label => 'Label';

  @override
  String get s_name => 'Name';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Options';

  @override
  String get s_details => 'Details';

  @override
  String get s_show_window => 'Show window';

  @override
  String get s_hide_window => 'Hide window';

  @override
  String get s_show_navigation => 'Show navigation';

  @override
  String get s_expand_navigation => 'Expand navigation bar';

  @override
  String get s_collapse_navigation => 'Collapse navigation bar';

  @override
  String get s_expand_collapse_navigation => 'Expand/collapse navigation bar';

  @override
  String get s_show_menu => 'Show menu';

  @override
  String get s_toggle_menu_bar => 'Toggle menu bar';

  @override
  String get s_more_info => 'More info';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'About';

  @override
  String get s_algorithm => 'Algorithm';

  @override
  String get s_appearance => 'Appearance';

  @override
  String get s_actions => 'Actions';

  @override
  String get s_manage => 'Manage';

  @override
  String get s_setup => 'Setup';

  @override
  String get s_device => 'Device';

  @override
  String get s_application => 'Application';

  @override
  String get s_settings => 'Settings';

  @override
  String get s_reset_settings => 'Reset settings';

  @override
  String get l_reset_settings_desc => 'Restore settings to default';

  @override
  String get q_reset_settings => 'Reset settings?';

  @override
  String get p_reset_settings_confirmation_desc =>
      'This will restore all settings to their default values.';

  @override
  String get s_support => 'Support';

  @override
  String get s_certificates => 'Certificates';

  @override
  String get s_security_key => 'Security Key';

  @override
  String get s_slots => 'Slots';

  @override
  String get s_help_and_about => 'Help & about';

  @override
  String get s_help => 'Help';

  @override
  String get s_app_information => 'Application information';

  @override
  String get s_home => 'Home';

  @override
  String get s_user_guide => 'User guide';

  @override
  String get s_i_need_help => 'I need help';

  @override
  String get s_terms_of_use => 'Terms of use';

  @override
  String get s_privacy_policy => 'Privacy policy';

  @override
  String get s_open_src_licenses => 'Open source licenses';

  @override
  String get s_please_wait => 'Please wait…';

  @override
  String get s_secret_key => 'Secret key';

  @override
  String get s_show_secret_key => 'Show secret key';

  @override
  String get s_hide_secret_key => 'Hide secret key';

  @override
  String get s_private_key => 'Private key';

  @override
  String get s_public_key => 'Public key';

  @override
  String get s_invalid_length => 'Invalid length';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Invalid format, allowed characters: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Invalid characters for selected keyboard';

  @override
  String get s_require_touch => 'Require touch';

  @override
  String get q_have_account_info => 'Have account info?';

  @override
  String get s_debugging_tools => 'Debugging tools';

  @override
  String get s_run_diagnostics => 'Run diagnostics';

  @override
  String get l_run_diagnostics_desc => 'Run diagnostics to troubleshoot';

  @override
  String get s_logging_level => 'Log level';

  @override
  String s_current_log_level(String level) {
    return 'Log level: $level';
  }

  @override
  String get s_character_count => 'Character count';

  @override
  String get s_language => 'Language';

  @override
  String get s_app_theme => 'Application theme';

  @override
  String get s_system_default => 'System default';

  @override
  String get s_light_mode => 'Light mode';

  @override
  String get s_dark_mode => 'Dark mode';

  @override
  String get s_list_layout => 'List layout';

  @override
  String get s_grid_layout => 'Grid layout';

  @override
  String get s_mixed_layout => 'Mixed layout';

  @override
  String get s_select_layout => 'Select layout';

  @override
  String get s_select_to_scan => 'Select to scan';

  @override
  String get s_hide_reader => 'Hide reader';

  @override
  String get s_show_hidden_readers => 'Show hidden readers';

  @override
  String get s_toggle_readers => 'Toggle readers';

  @override
  String get l_toggle_readers_desc => 'Show or hide readers';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Serial number: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Firmware version: $version';
  }

  @override
  String get l_fips_capable => 'FIPS capable';

  @override
  String get l_fips_approved => 'FIPS approved';

  @override
  String get l_insert_yk => 'Insert your YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Insert or tap a YubiKey';

  @override
  String get l_unplug_yk => 'Unplug your YubiKey';

  @override
  String get l_reinsert_yk => 'Reinsert your YubiKey';

  @override
  String get l_place_on_nfc_reader => 'Place your YubiKey on the NFC reader';

  @override
  String get l_replace_yk_on_reader => 'Place your YubiKey back on the reader';

  @override
  String get l_remove_yk_from_reader =>
      'Remove your YubiKey from the NFC reader';

  @override
  String get p_try_reinsert_yk => 'Try to remove and reinsert your YubiKey.';

  @override
  String get s_touch_required => 'Touch required';

  @override
  String get l_touch_button_now => 'Touch the button on your YubiKey now';

  @override
  String get l_long_touch_button_now =>
      'Press and hold the button on your YubiKey for 10 seconds now';

  @override
  String get l_keep_touching_yk => 'Keep touching your YubiKey repeatedly…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Toggle applications';

  @override
  String get s_toggle_interfaces => 'Toggle interfaces';

  @override
  String get p_toggle_applications_desc =>
      'Enable or disable applications over available transports.';

  @override
  String get p_toggle_interfaces_desc => 'Enable or disable USB interfaces.';

  @override
  String get l_toggle_applications_desc => 'Enable/disable applications';

  @override
  String get l_toggle_interfaces_desc => 'Enable/disable interfaces';

  @override
  String get s_reconfiguring_yk => 'Reconfiguring YubiKey…';

  @override
  String get s_config_updated => 'Configuration updated';

  @override
  String get l_config_updated_reinsert =>
      'Configuration updated, remove and reinsert your YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 disabled';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn requires the FIDO2 application to be enabled on your YubiKey';

  @override
  String get s_lock_code => 'Lock code';

  @override
  String get l_wrong_lock_code => 'Wrong lock code';

  @override
  String get s_show_lock_code => 'Show lock code';

  @override
  String get s_hide_lock_code => 'Hide lock code';

  @override
  String get p_lock_code_required_desc =>
      'The action you are about to perform requires the configuration lock code to be entered.';

  @override
  String get l_helper_not_responding => 'The Helper process isn\'t responding';

  @override
  String get l_yk_no_access => 'This YubiKey cannot be accessed';

  @override
  String get s_yk_inaccessible => 'Device inaccessible';

  @override
  String get l_open_connection_failed => 'Failed to open connection';

  @override
  String get l_ccid_connection_failed => 'Failed to open smart card connection';

  @override
  String get p_ccid_service_unavailable =>
      'Make sure your smart card service is functioning.';

  @override
  String get p_pcscd_unavailable => 'Make sure pcscd is installed and running.';

  @override
  String get l_no_yk_present => 'No YubiKey present';

  @override
  String get s_unknown_type => 'Unknown type';

  @override
  String get s_unknown_device => 'Unrecognized device';

  @override
  String get s_restricted_nfc => 'NFC activation';

  @override
  String get l_deactivate_restricted_nfc => 'How to activate NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Connect your YubiKey to any USB power source, such as a computer, for at least 3 seconds.\n\nOnce powered, NFC will be activated and ready for use.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Your YubiKey is equipped with Restricted NFC, a feature designed to safeguard against wireless manipulation during shipping. This means that NFC operations are temporarily disabled until you activate them.';

  @override
  String get s_unsupported_yk => 'Unsupported YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'The operation failed, please try again.';

  @override
  String get l_configuration_unsupported => 'Configuration not supported';

  @override
  String get p_scp_unsupported =>
      'To communicate over NFC, the YubiKey requires technology which is not supported by this phone. Please plug the YubiKey to the phone\'s USB port.';

  @override
  String get l_error_occurred => 'An error has occurred';

  @override
  String get s_application_error => 'Application error';

  @override
  String get l_import_error => 'Import error';

  @override
  String get l_file_not_found => 'File not found';

  @override
  String get l_file_too_big => 'File size too big';

  @override
  String get l_filesystem_error => 'File system operation error';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Set PIN';

  @override
  String get s_change_pin => 'Change PIN';

  @override
  String get s_change_puk => 'Change PUK';

  @override
  String get s_show_pin => 'Show PIN';

  @override
  String get s_hide_pin => 'Hide PIN';

  @override
  String get s_show_puk => 'Show PUK';

  @override
  String get s_hide_puk => 'Hide PUK';

  @override
  String get s_current_pin => 'Current PIN';

  @override
  String get s_current_puk => 'Current PUK';

  @override
  String get s_new_pin => 'New PIN';

  @override
  String get s_new_puk => 'New PUK';

  @override
  String get s_confirm_pin => 'Confirm PIN';

  @override
  String get s_confirm_puk => 'Confirm PUK';

  @override
  String get s_unblock_pin => 'Reset PIN';

  @override
  String get l_pin_mismatch => 'PINs do not match';

  @override
  String get l_puk_mismatch => 'PUKs do not match';

  @override
  String get s_pin_set => 'PIN set';

  @override
  String get s_puk_set => 'PUK set';

  @override
  String l_set_pin_failed(String message) {
    return 'Failed to set PIN: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries attempts remaining',
      one: '$retries attempt remaining',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries attempts remaining',
      one: '$retries attempt remaining',
    );
    return 'Wrong PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries attempts remaining',
      one: '$retries attempt remaining',
    );
    return 'Wrong PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'FIDO PIN protection';

  @override
  String get s_pin_change_required => 'PIN change required';

  @override
  String get l_enter_fido2_pin => 'Enter the FIDO2 PIN for your YubiKey';

  @override
  String get p_fido2_pin_required =>
      'The action you are about to perform requires the FIDO2 PIN to be entered.';

  @override
  String get l_pin_blocked_reset =>
      'PIN is blocked; factory reset the FIDO application';

  @override
  String get l_pin_blocked => 'PIN is blocked';

  @override
  String get l_set_pin_first => 'A PIN is required';

  @override
  String get l_unlock_pin_first => 'Unlock with PIN';

  @override
  String get l_pin_soft_locked =>
      'PIN has been blocked until the YubiKey is removed and reinserted';

  @override
  String get l_pin_change_required_desc =>
      'A new PIN must be set before you can use this application';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'A PIN must be $min_length-$max_length characters long and may contain letters, numbers and special characters.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'A PIN must be $min_length-$max_length characters long, contain at least $unique_characters unique characters, and not be a commonly used PIN, like \"$common_pin\". It may contain letters, numbers, and special characters.';
  }

  @override
  String get s_ep_attestation => 'Enterprise Attestation';

  @override
  String get s_ep_attestation_enabled => 'Enterprise Attestation enabled';

  @override
  String get q_enable_ep_attestation => 'Enable Enterprise Attestation?';

  @override
  String get p_enable_ep_attestation_desc =>
      'This will enable Enterprise Attestation, allowing authorized domains to uniquely identify your YubiKey.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Once enabled, Enterprise Attestation can only be disabled by performing a FIDO factory reset.';

  @override
  String get s_pin_required => 'PIN required';

  @override
  String get p_pin_required_desc =>
      'The action you are about to perform requires the PIV PIN to be entered.';

  @override
  String get l_piv_pin_blocked => 'Blocked, use PUK to reset';

  @override
  String get p_piv_pin_blocked_desc =>
      'The PIN is blocked. Use the PUK to reset it.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'The PIN is blocked. A factory reset is required.';

  @override
  String get l_piv_pin_puk_blocked => 'Blocked, factory reset needed';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Both the PIN and PUK are blocked. A factory reset of the PIV application is required.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'A $name must be at least $length characters long.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'A $name must be at least $length characters long, contain at least 2 unique characters, and not be a commonly used $name, like \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'New $name doesn\'t meet complexity requirements.';
  }

  @override
  String get s_dismiss => 'Dismiss';

  @override
  String get p_default_pin_puk_key_desc =>
      'It is recommended to change the default PIN, PUK and management key.';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      'For FIPS compliance it is required to change the default PIN, PUK and management key.';

  @override
  String get l_warning_default_pin => 'Warning: Default PIN used';

  @override
  String get l_warning_default_puk => 'Warning: Default PUK used';

  @override
  String get l_default_pin_used => 'Default PIN used';

  @override
  String get l_default_puk_used => 'Default PUK used';

  @override
  String get l_pin_complexity => 'PIN complexity enforced';

  @override
  String get s_password => 'Password';

  @override
  String get s_manage_password => 'Manage password';

  @override
  String get s_set_password => 'Set password';

  @override
  String get s_password_set => 'Password set';

  @override
  String get s_show_password => 'Show password';

  @override
  String get s_hide_password => 'Hide password';

  @override
  String get l_password_protection => 'Password protection of accounts';

  @override
  String get s_new_password => 'New password';

  @override
  String get s_current_password => 'Current password';

  @override
  String get s_confirm_password => 'Confirm password';

  @override
  String get l_password_mismatch => 'Passwords do not match';

  @override
  String get s_wrong_password => 'Wrong password';

  @override
  String get p_wrong_password =>
      'Wrong password. If you don\'t know your password, you\'ll need to reset the YubiKey.';

  @override
  String get s_remove_password => 'Remove password';

  @override
  String get s_password_removed => 'Password removed';

  @override
  String get s_remember_password => 'Remember password';

  @override
  String get s_clear_saved_password => 'Clear saved password';

  @override
  String get s_password_forgotten => 'Password forgotten';

  @override
  String get l_keystore_unavailable => 'OS Keystore unavailable';

  @override
  String get l_remember_pw_failed => 'Failed to remember password';

  @override
  String get l_unlock_first => 'Unlock with password';

  @override
  String get l_set_password_first => 'Set a password';

  @override
  String get l_enter_oath_pw => 'Enter the OATH password for your YubiKey';

  @override
  String get p_new_password_requirements =>
      'A password may contain letters, numbers and special characters.';

  @override
  String get s_management_key => 'Management key';

  @override
  String get s_current_management_key => 'Current management key';

  @override
  String get s_new_management_key => 'New management key';

  @override
  String get l_change_management_key => 'Change management key';

  @override
  String get l_management_key_changed => 'Management key changed';

  @override
  String get l_default_key_used => 'Default management key used';

  @override
  String get s_generate_random => 'Generate random';

  @override
  String get s_use_default => 'Use default';

  @override
  String get l_warning_default_key => 'Warning: Default key used';

  @override
  String get s_protect_key => 'Protect with PIN';

  @override
  String get p_protect_key_desc =>
      'Use the PIN in place of the management key during operations that require management key authentication.';

  @override
  String get s_management_key_algorithm => 'Management key algorithm';

  @override
  String get p_management_key_algorithm_desc =>
      'The algorithm to choose for the management key.';

  @override
  String get l_pin_protected_key => 'PIN can be used instead';

  @override
  String get l_wrong_key => 'Wrong key';

  @override
  String get l_unlock_piv_management => 'Unlock PIV management';

  @override
  String get p_unlock_piv_management_desc =>
      'The action you are about to perform requires the PIV management key.';

  @override
  String l_account(String label) {
    return 'Account: $label';
  }

  @override
  String get s_accounts => 'Accounts';

  @override
  String get s_no_accounts => 'No accounts';

  @override
  String l_results_for(String query) {
    return 'Results for \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Get started with OTP accounts';

  @override
  String get l_no_accounts_desc =>
      'Add accounts to your YubiKey from any service provider supporting OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Add account';

  @override
  String get p_add_account_desc =>
      'Scan QR code or enter the credential details manually.';

  @override
  String get s_add_accounts => 'Add account(s)';

  @override
  String get l_drop_qr_description => 'Drop QR code to add account(s)';

  @override
  String get p_add_account_three_ways =>
      'There are three ways of adding accounts.';

  @override
  String get s_scanning => 'Scanning (recommended)';

  @override
  String get p_scanning_desc =>
      'Before scanning a QR code, make sure the full code is visible on screen.';

  @override
  String get s_drag_and_drop => 'Drag and drop';

  @override
  String get p_drag_and_drop_desc =>
      'An image containing a QR code may be dropped anywhere in the Accounts view.';

  @override
  String get s_manually => 'Manually';

  @override
  String get p_manually_desc =>
      'Account credential details may be entered manually in the form.';

  @override
  String get s_account_added => 'Account added';

  @override
  String l_account_add_failed(String message) {
    return 'Failed adding account: $message';
  }

  @override
  String get l_add_account_password_required => 'Password required';

  @override
  String get l_add_account_unlock_required => 'Unlock required';

  @override
  String get l_add_account_func_missing => 'Functionality missing or disabled';

  @override
  String get l_account_name_required => 'Your account must have a name';

  @override
  String get l_name_already_exists => 'This name already exists for the issuer';

  @override
  String get l_account_already_exists =>
      'This account already exists on the YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Invalid character: \':\' is not allowed in issuer';

  @override
  String get l_select_accounts => 'Select account(s) to add to the YubiKey';

  @override
  String get s_pin_account => 'Pin account';

  @override
  String get s_unpin_account => 'Unpin account';

  @override
  String get s_no_pinned_accounts => 'No pinned accounts';

  @override
  String get s_pinned => 'Pinned';

  @override
  String get l_pin_account_desc => 'Keep your important accounts together';

  @override
  String get s_rename_account => 'Rename account';

  @override
  String get l_rename_account_desc => 'Edit the issuer/name of the account';

  @override
  String get s_account_renamed => 'Account renamed';

  @override
  String l_rename_account_failed(String message) {
    return 'Failed renaming account: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'This will change how the account is displayed in the list.';

  @override
  String get s_delete_account => 'Delete account';

  @override
  String get q_delete_account => 'Delete account?';

  @override
  String get l_delete_account_desc => 'Remove the account from your YubiKey';

  @override
  String get s_account_deleted => 'Account deleted';

  @override
  String get p_warning_delete_account =>
      'Warning! This action will delete the account from your YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Make sure to disable this account from the service it is registered with to avoid being locked out.';

  @override
  String get s_account_name => 'Account name';

  @override
  String get s_search_accounts => 'Search accounts';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used of $capacity accounts used';
  }

  @override
  String s_num_digits(int num) {
    return '$num digits';
  }

  @override
  String s_num_sec(int num) {
    return '$num sec';
  }

  @override
  String get s_issuer_optional => 'Issuer (optional)';

  @override
  String get s_counter_based => 'Counter based';

  @override
  String get s_time_based => 'Time based';

  @override
  String get l_copy_code_desc => 'Paste the code into another application';

  @override
  String get l_calculate_code_desc => 'Get a new code from your YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'User ID';

  @override
  String get s_credential_id => 'Credential ID';

  @override
  String get s_display_name => 'Display Name';

  @override
  String get s_user_name => 'User Name';

  @override
  String get s_passkeys => 'Passkeys';

  @override
  String get s_no_passkeys => 'No passkeys';

  @override
  String get l_ready_to_use => 'Ready to use';

  @override
  String get l_register_sk_on_websites =>
      'Register as a Security Key on websites';

  @override
  String get l_no_discoverable_accounts => 'No passkeys stored';

  @override
  String get p_non_passkeys_note =>
      'Non-passkey credentials may exist, but can not be listed.';

  @override
  String get s_delete_passkey => 'Delete passkey';

  @override
  String get q_delete_passkey => 'Delete passkey?';

  @override
  String get l_delete_passkey_desc => 'Remove the passkey from the YubiKey';

  @override
  String get s_passkey_deleted => 'Passkey deleted';

  @override
  String get p_warning_delete_passkey =>
      'Warning! This action will delete the passkey from your YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'You will no longer be able to use this passkey for the service where it is registered.';

  @override
  String get l_do_not_remove_yk_delete =>
      'Do not remove YubiKey during deletion';

  @override
  String get s_search_passkeys => 'Search passkeys';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used of $max passkeys used.';
  }

  @override
  String get s_biometrics => 'Biometrics';

  @override
  String l_fingerprint(String label) {
    return 'Fingerprint: $label';
  }

  @override
  String get s_fingerprints => 'Fingerprints';

  @override
  String get l_fingerprint_captured => 'Fingerprint captured successfully!';

  @override
  String get s_fingerprint_added => 'Fingerprint added';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Error adding fingerprint: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Error setting name: $message';
  }

  @override
  String get s_setup_fingerprints => 'Set up fingerprints';

  @override
  String get p_setup_fingerprints_desc =>
      'Fingerprints need to be set up before the key can be used.';

  @override
  String get s_add_fingerprint => 'Add fingerprint';

  @override
  String get s_delete_fingerprint => 'Delete fingerprint';

  @override
  String get q_delete_fingerprint => 'Delete fingerprint?';

  @override
  String get l_delete_fingerprint_desc =>
      'Remove the fingerprint from the YubiKey';

  @override
  String get s_fingerprint_deleted => 'Fingerprint deleted';

  @override
  String get p_warning_delete_fingerprint =>
      'This will delete the fingerprint from your YubiKey.';

  @override
  String get s_fingerprints_get_started => 'Get started with fingerprints';

  @override
  String get p_set_fingerprints_desc =>
      'Before it\'s possible to register fingerprints, a PIN needs to be set.';

  @override
  String get l_no_fps_added => 'No fingerprints have been added';

  @override
  String get s_rename_fp => 'Rename fingerprint';

  @override
  String get l_rename_fp_desc => 'Change the name';

  @override
  String get s_fingerprint_renamed => 'Fingerprint renamed';

  @override
  String l_rename_fp_failed(String message) {
    return 'Error renaming: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Add one or more (up to five) fingerprints';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 fingerprints registered';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Press your finger against the YubiKey to begin.';

  @override
  String get l_name_fingerprint => 'Name this fingerprint';

  @override
  String get l_user_action_timeout_error => 'Failed due to user inactivity';

  @override
  String get l_wrong_inserted_yk_error =>
      'Re-inserted YubiKey does not match initial device';

  @override
  String get l_failed_connecting_to_fido =>
      'Failed connecting to FIDO interface';

  @override
  String get l_self_signed_certificate => 'Self-signed certificate';

  @override
  String get l_certificate_signing_request =>
      'Certificate Signing Request (CSR)';

  @override
  String get s_certificate => 'Certificate';

  @override
  String get s_subject => 'Subject';

  @override
  String get l_export_csr_file => 'Save CSR to file';

  @override
  String get l_export_public_key => 'Export public key';

  @override
  String get l_export_public_key_file => 'Save public key to file';

  @override
  String get l_export_public_key_desc => 'Export the public key to a file';

  @override
  String get l_public_key_exported => 'Public key exported';

  @override
  String get l_export_certificate => 'Export certificate';

  @override
  String get l_export_certificate_file => 'Export certificate to file';

  @override
  String get l_export_certificate_desc => 'Export the certificate to a file';

  @override
  String get l_certificate_exported => 'Certificate exported';

  @override
  String get l_select_import_file => 'Select file to import';

  @override
  String get l_import_file => 'Import file';

  @override
  String get l_import_desc => 'Import a key and/or certificate';

  @override
  String get l_import_nothing => 'Nothing to import';

  @override
  String get l_importing_file => 'Importing file…';

  @override
  String get s_file_imported => 'File imported';

  @override
  String get l_unsupported_key_type => 'Unsupported key type';

  @override
  String get l_delete_certificate => 'Delete certificate';

  @override
  String get q_delete_certificate => 'Delete certificate?';

  @override
  String get l_delete_certificate_desc =>
      'Remove the certificate from your YubiKey';

  @override
  String get l_delete_key => 'Delete key';

  @override
  String get q_delete_key => 'Delete key?';

  @override
  String get l_delete_key_desc => 'Remove the key from your YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Delete certificate/key';

  @override
  String get q_delete_certificate_or_key => 'Delete certificate/key?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Remove the certificate or key from your YubiKey';

  @override
  String get l_move_key => 'Move key';

  @override
  String get l_move_key_desc => 'Move a key from one PIV slot into another';

  @override
  String get l_change_defaults => 'Change default access codes';

  @override
  String get s_issuer => 'Issuer';

  @override
  String get s_serial => 'Serial';

  @override
  String get s_certificate_fingerprint => 'Fingerprint';

  @override
  String get s_valid_from => 'Valid from';

  @override
  String get s_valid_to => 'Valid to';

  @override
  String get l_no_certificate => 'No certificate loaded';

  @override
  String get l_key_no_certificate => 'Key without certificate loaded';

  @override
  String get s_generate_key => 'Generate key';

  @override
  String get l_generate_desc => 'Generate a new certificate or CSR';

  @override
  String p_generate_desc(String slot) {
    return 'This will generate a new key on the YubiKey in PIV slot $slot.';
  }

  @override
  String get s_private_key_generated => 'Private key generated';

  @override
  String get p_select_what_to_delete => 'Select what to delete from the slot.';

  @override
  String get p_warning_delete_certificate =>
      'Warning! This action will delete the certificate from your YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Warning! This action will delete the private key from your YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Warning! This action will delete the certificate and private key from your YubiKey.';

  @override
  String get p_warning_usb_preferred =>
      'Prefer USB for RSA keys. NFC may result in errors.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'This will delete the certificate in PIV slot $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'This will delete the private key in PIV slot $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'This will delete the certificate and private key in PIV slot $slot.';
  }

  @override
  String get l_certificate_deleted => 'Certificate deleted';

  @override
  String get l_key_deleted => 'Key deleted';

  @override
  String get l_certificate_and_key_deleted => 'Certificate and key deleted';

  @override
  String get l_include_certificate => 'Include certificate';

  @override
  String get l_select_destination_slot => 'Select destination slot';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Move the private key in PIV slot $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Move the private key in PIV slot $from_slot to slot $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Move the private key and certificate in PIV slot $from_slot to slot $to_slot?';
  }

  @override
  String get p_password_protected_file =>
      'The selected file is password protected.';

  @override
  String p_import_items_desc(String slot) {
    return 'The following item(s) will be imported into PIV slot $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'The public key of the certificate does not match the private key in the slot';

  @override
  String get l_key_moved => 'Key moved';

  @override
  String get l_key_and_certificate_moved => 'Key and certificate moved';

  @override
  String get p_subject_desc =>
      'A distinguished name (DN) formatted in accordance to the RFC 4514 specification.';

  @override
  String get l_rfc4514_invalid => 'Invalid RFC 4514 format';

  @override
  String get rfc4514_examples =>
      'Examples:\nCN=Example Name\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => 'Allow fingerprint';

  @override
  String get s_pin_policy => 'PIN policy';

  @override
  String get s_output_format => 'Output format';

  @override
  String get s_expiration_date => 'Expiration date';

  @override
  String get p_algorithm_desc => 'Key algorithm to use.';

  @override
  String get p_expiration_date_desc =>
      'Date when the certificate expires, default 1 year (certificate only).';

  @override
  String get p_key_options_bio_desc =>
      'Allow biometrics to be used instead of PIN.';

  @override
  String get q_overwrite_slot => 'Overwrite slot?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'This will permanently overwrite existing content in slot $slot.';
  }

  @override
  String get l_overwrite_cert => 'The certificate will be overwritten';

  @override
  String get l_overwrite_key => 'The private key will be overwritten';

  @override
  String get l_overwrite_key_maybe =>
      'Any existing private key in the slot will be overwritten';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Authentication';

  @override
  String get s_slot_9c => 'Digital Signature';

  @override
  String get s_slot_9d => 'Key Management';

  @override
  String get s_slot_9e => 'Card Authentication';

  @override
  String get s_retired_slot => 'Retired Key Management';

  @override
  String get s_otp_slot_one => 'Short touch';

  @override
  String get s_otp_slot_two => 'Long touch';

  @override
  String get l_otp_slot_empty => 'Slot is empty';

  @override
  String get l_otp_slot_configured => 'Slot is configured';

  @override
  String get l_yubiotp_desc => 'Program a Yubico OTP credential';

  @override
  String get s_challenge_response => 'Challenge-response';

  @override
  String get l_challenge_response_desc =>
      'Program a challenge-response credential';

  @override
  String get s_static_password => 'Static password';

  @override
  String get l_static_password_desc => 'Configure a static password';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Program a HMAC-SHA1 based credential';

  @override
  String get s_public_id => 'Public ID';

  @override
  String get s_private_id => 'Private ID';

  @override
  String get s_use_serial => 'Use serial';

  @override
  String get l_select_file => 'Select file';

  @override
  String get l_no_export_file => 'No export file';

  @override
  String get s_no_export => 'No export';

  @override
  String get s_export => 'Export';

  @override
  String get l_export_configuration_file => 'Export configuration to file';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Exported credentials can be uploaded at $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Keyboard $layout';
  }

  @override
  String get s_delete_slot => 'Delete credential';

  @override
  String get q_delete_slot => 'Delete credential?';

  @override
  String get l_delete_slot_desc => 'Remove credential in slot';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Warning! This action will permanently remove the credential from slot $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Credential deleted';

  @override
  String get s_swap => 'Swap';

  @override
  String get s_swap_slots => 'Swap slots';

  @override
  String get q_swap_slots => 'Swap slots?';

  @override
  String get l_swap_slots_desc => 'Swap short/long touch';

  @override
  String get p_swap_slots_desc =>
      'This will swap the configuration of the two slots.';

  @override
  String get l_slots_swapped => 'Slot configurations swapped';

  @override
  String l_slot_credential_configured(String type) {
    return 'Configured $type credential';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Configured $type credential and exported to $file';
  }

  @override
  String get s_append_enter => 'Append ⏎';

  @override
  String get l_append_enter_desc =>
      'Append an Enter keystroke after emitting the OTP';

  @override
  String get p_otp_swap_error =>
      'Failed to swap slots! Make sure the YubiKey does not have restrictive access.';

  @override
  String get l_wrong_access_code => 'Wrong access code';

  @override
  String get s_access_code => 'Access code';

  @override
  String get s_show_access_code => 'Show access code';

  @override
  String get s_hide_access_code => 'Hide access code';

  @override
  String p_enter_access_code(String slot) {
    return 'Enter access code for slot $slot.';
  }

  @override
  String get s_enable_nfc => 'Enable NFC';

  @override
  String get s_request_access => 'Request access';

  @override
  String get s_permission_denied => 'Permission denied';

  @override
  String get l_elevating_permissions => 'Elevating permissions…';

  @override
  String get s_review_permissions => 'Review permissions';

  @override
  String get s_open_windows_settings => 'Open Windows settings';

  @override
  String get l_admin_privileges_required => 'Administrator privileges required';

  @override
  String get p_elevated_permissions_required =>
      'Managing this device requires elevated privileges. Alternatively, you can use Windows Settings to manage FIDO configuration.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'WebAuthn management requires elevated privileges. Alternatively, you can use Windows Settings to manage FIDO configuration.';

  @override
  String get p_ms_store_permission_note =>
      'The Microsoft Store version of the app is generally unable to elevate permissions due to sandboxing limitations of Windows. We recommend installing Yubico Authenticator from our official .msi installer.';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator needs Camera permissions for scanning QR codes.';

  @override
  String get s_qr_scan => 'Scan QR code';

  @override
  String get l_invalid_qr => 'Invalid QR code';

  @override
  String get l_qr_not_found => 'No QR code found';

  @override
  String get l_qr_scanned => 'Scanned QR code';

  @override
  String l_qr_file_too_large(String max) {
    return 'File too large (max $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Invalid image file';

  @override
  String get l_qr_select_file => 'Select file with QR code';

  @override
  String l_qr_not_read(String message) {
    return 'Failed reading QR code: $message';
  }

  @override
  String get l_point_camera_scan => 'Point your camera at a QR code to scan it';

  @override
  String get q_want_to_scan => 'Would like to scan?';

  @override
  String get q_no_qr => 'No QR code?';

  @override
  String get s_enter_manually => 'Enter manually';

  @override
  String get s_read_from_file => 'Read from file';

  @override
  String get s_reset => 'Reset';

  @override
  String get s_factory_reset => 'Factory reset';

  @override
  String get l_factory_reset_desc => 'Restore YubiKey defaults';

  @override
  String get l_factory_reset_required => 'Factory reset required';

  @override
  String get l_oath_application_reset => 'OATH application reset';

  @override
  String get l_fido_app_reset => 'FIDO application reset';

  @override
  String l_reset_failed(String message) {
    return 'Error performing reset: $message';
  }

  @override
  String get l_piv_app_reset => 'PIV application reset';

  @override
  String get p_factory_reset_an_app =>
      'Factory reset an application on your YubiKey.';

  @override
  String get p_factory_reset_desc =>
      'Data is stored in multiple applications on the YubiKey, some of which can be factory reset independently of each other.\n\nSelect an application above to reset.';

  @override
  String get p_warning_factory_reset =>
      'Warning! This will irrevocably delete all OATH TOTP/HOTP accounts from your YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Your OATH credentials, as well as any password set, will be removed from this YubiKey. Make sure to disable these from their respective web sites to avoid being locked out of your accounts.';

  @override
  String get p_warning_deletes_accounts =>
      'Warning! This will irrevocably delete all U2F and FIDO2 accounts, including passkeys, from your YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Your credentials, as well as any PIN set, will be removed from this YubiKey. Make sure to disable these from their respective web sites to avoid being locked out of your accounts.';

  @override
  String l_reset_not_allowed_over(String transport) {
    return 'FIDO reset is disabled over $transport';
  }

  @override
  String get p_warning_piv_reset =>
      'Warning! All data stored for PIV will be irrevocably deleted from your YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'This includes private keys and certificates. Your PIN, PUK, and management key will be reset to their factory default values.';

  @override
  String get p_warning_global_reset =>
      'Warning! This will irrevocably delete all saved data, including credentials, from your YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Factory reset the applications on your YubiKey. PIN will be reset to its factory default value, and registered fingerprints will be removed. Any keys, certificates, or other credentials will all be permanently removed.';

  @override
  String get l_copy_to_clipboard => 'Copy to clipboard';

  @override
  String get s_code_copied => 'Code copied';

  @override
  String get l_code_copied_clipboard => 'Code copied to clipboard';

  @override
  String get s_copy_log => 'Copy log';

  @override
  String get l_copy_log_clipboard => 'Copy log to clipboard';

  @override
  String get l_log_copied => 'Log copied to clipboard';

  @override
  String get l_diagnostics_copied => 'Diagnostic data copied to clipboard';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label copied to clipboard.';
  }

  @override
  String get s_custom_icons => 'Custom icons';

  @override
  String get l_set_icons_for_accounts => 'Set icons for accounts';

  @override
  String get p_custom_icons_description =>
      'Icon packs can make your accounts more easily distinguishable with familiar logos and colors.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Icon packs use the $aegis_icon_pack format. You can download a pre-made icon pack, or you can create your own.';
  }

  @override
  String get s_replace_icon_pack => 'Replace icon pack';

  @override
  String get l_loading_icon_pack => 'Loading icon pack…';

  @override
  String get s_load_icon_pack => 'Load icon pack';

  @override
  String get l_load_icon_pack_desc => 'Load icon pack from file';

  @override
  String get s_remove_icon_pack => 'Remove icon pack';

  @override
  String get l_remove_icon_pack_desc => 'Delete the active icon pack';

  @override
  String get l_icon_pack_removed => 'Icon pack removed';

  @override
  String get l_remove_icon_pack_failed => 'Error removing icon pack';

  @override
  String get s_choose_icon_pack => 'Choose icon pack';

  @override
  String get l_icon_pack_imported => 'Icon pack imported';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Error importing icon pack: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Invalid icon pack';

  @override
  String get l_icon_pack_copy_failed => 'Failed to copy icon pack files';

  @override
  String get s_nfc_and_usb_options => 'NFC & USB options';

  @override
  String get l_nfc_and_usb_options_desc => 'Configure action for YubiKey';

  @override
  String get l_on_yk_nfc_tap => 'On NFC tap';

  @override
  String get l_on_yk_usb_insert => 'On USB insert';

  @override
  String get l_do_nothing => 'Do nothing';

  @override
  String get l_launch_ya => 'Launch Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Copy OTP to clipboard';

  @override
  String get l_launch_and_copy_otp => 'Launch app and copy OTP';

  @override
  String get l_kbd_layout_for_static => 'Keyboard layout (for static password)';

  @override
  String get s_choose_kbd_layout => 'Choose keyboard layout';

  @override
  String get l_bypass_touch_requirement => 'Bypass touch requirement';

  @override
  String get l_bypass_touch_requirement_on =>
      'Accounts that require touch are automatically shown over NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Accounts that require touch need an additional tap over NFC';

  @override
  String get s_silence_nfc_sounds => 'Silence NFC sounds';

  @override
  String get l_silence_nfc_sounds_on => 'No sounds will be played on NFC tap';

  @override
  String get l_silence_nfc_sounds_off => 'Sound will play on NFC tap';

  @override
  String get l_launch_app_on_usb_on =>
      'This prevents other apps from using the YubiKey over USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Other apps can use the YubiKey over USB';

  @override
  String get s_allow_screenshots => 'Allow screenshots';

  @override
  String get l_allow_screenshots_desc => 'Allow other apps to take screenshots';

  @override
  String get s_nfc_ready_to_scan => 'Ready to scan';

  @override
  String get s_nfc_hold_still => 'Hold still…';

  @override
  String get s_nfc_tap_your_yubikey => 'Tap your YubiKey';

  @override
  String get s_nfc_remove_key => 'Remove YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Failed to scan, try again';

  @override
  String get s_usb_processing => 'Reading data from YubiKey';

  @override
  String get s_usb_dont_remove => 'Don\'t remove the key…';

  @override
  String get l_usb_read_error => 'Failed to read data from YubiKey';

  @override
  String get p_ndef_set_otp =>
      'Successfully copied OTP code from YubiKey to clipboard.';

  @override
  String get p_ndef_set_password =>
      'Successfully copied password from YubiKey to clipboard.';

  @override
  String get p_ndef_parse_failure => 'Failed to parse OTP code from YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Failed to access clipboard when trying to copy OTP code from YubiKey.';

  @override
  String get s_set_label => 'Set label';

  @override
  String get s_set_color => 'Set color';

  @override
  String get s_change_label => 'Change label';

  @override
  String get p_set_will_add_custom_name =>
      'This will give your YubiKey a custom name.';

  @override
  String get p_rename_will_change_custom_name =>
      'This will change the label of your YubiKey.';

  @override
  String get s_keyboard_shortcuts => 'Keyboard shortcuts';

  @override
  String get s_global_shortcuts => 'Global shortcuts';

  @override
  String get s_application_shortcuts => 'Application shortcuts';

  @override
  String s_quit_app(String app) {
    return 'Quit $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Hide $app';
  }

  @override
  String get s_search => 'Search';

  @override
  String get s_next_device => 'Next device';

  @override
  String get s_previous_device => 'Previous device';

  @override
  String get s_open_settings => 'Open settings';

  @override
  String get s_open_item => 'Open item';

  @override
  String get s_edit_item => 'Edit item';

  @override
  String get s_delete_item => 'Delete item';

  @override
  String get s_calculate_oath_code => 'Calculate OATH code';

  @override
  String get s_open_keyboard_shortcuts => 'Open keyboard shortcuts';
}
