import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_cs.dart';
import 'app_localizations_de.dart';
import 'app_localizations_el.dart';
import 'app_localizations_en.dart';
import 'app_localizations_es.dart';
import 'app_localizations_fr.dart';
import 'app_localizations_ja.dart';
import 'app_localizations_pl.dart';
import 'app_localizations_ru.dart';
import 'app_localizations_sk.dart';
import 'app_localizations_sv.dart';
import 'app_localizations_tr.dart';
import 'app_localizations_uk.dart';
import 'app_localizations_vi.dart';
import 'app_localizations_zh.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'l10n/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale)
    : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations)!;
  }

  static const LocalizationsDelegate<AppLocalizations> delegate =
      _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates =
      <LocalizationsDelegate<dynamic>>[
        delegate,
        GlobalMaterialLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
      ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('cs'),
    Locale('de'),
    Locale('el'),
    Locale('en'),
    Locale('es'),
    Locale('fr'),
    Locale('ja'),
    Locale('pl'),
    Locale('ru'),
    Locale('sk'),
    Locale('sv'),
    Locale('tr'),
    Locale('uk'),
    Locale('vi'),
    Locale('zh'),
    Locale('zh', 'TW'),
  ];

  /// No description provided for @app_name.
  ///
  /// In en, this message translates to:
  /// **'Yubico Authenticator'**
  String get app_name;

  /// IMPORTANT: This is the name of YOUR language written in YOUR language. For example: 'Deutsch' for German, 'Français' for French. DO NOT translate the word 'English'.
  ///
  /// In en, this message translates to:
  /// **'English'**
  String get native_language_name;

  /// No description provided for @s_translated.
  ///
  /// In en, this message translates to:
  /// **'Translated: {percentage}%'**
  String s_translated(int percentage);

  /// No description provided for @s_proofread.
  ///
  /// In en, this message translates to:
  /// **'Proofread: {percentage}%'**
  String s_proofread(int percentage);

  /// No description provided for @l_incomplete_translation.
  ///
  /// In en, this message translates to:
  /// **'Incomplete translation'**
  String get l_incomplete_translation;

  /// No description provided for @p_translation_progress_desc.
  ///
  /// In en, this message translates to:
  /// **'Progress indicators reflect the maturity of the translation.'**
  String get p_translation_progress_desc;

  /// No description provided for @s_community.
  ///
  /// In en, this message translates to:
  /// **'Community'**
  String get s_community;

  /// No description provided for @l_localization_project.
  ///
  /// In en, this message translates to:
  /// **'Localization project'**
  String get l_localization_project;

  /// No description provided for @s_save.
  ///
  /// In en, this message translates to:
  /// **'Save'**
  String get s_save;

  /// No description provided for @s_cancel.
  ///
  /// In en, this message translates to:
  /// **'Cancel'**
  String get s_cancel;

  /// No description provided for @s_close.
  ///
  /// In en, this message translates to:
  /// **'Close'**
  String get s_close;

  /// No description provided for @s_delete.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get s_delete;

  /// No description provided for @s_move.
  ///
  /// In en, this message translates to:
  /// **'Move'**
  String get s_move;

  /// No description provided for @s_quit.
  ///
  /// In en, this message translates to:
  /// **'Quit'**
  String get s_quit;

  /// No description provided for @s_enable.
  ///
  /// In en, this message translates to:
  /// **'Enable'**
  String get s_enable;

  /// No description provided for @s_enabled.
  ///
  /// In en, this message translates to:
  /// **'Enabled'**
  String get s_enabled;

  /// No description provided for @s_disabled.
  ///
  /// In en, this message translates to:
  /// **'Disabled'**
  String get s_disabled;

  /// No description provided for @s_status.
  ///
  /// In en, this message translates to:
  /// **'Status'**
  String get s_status;

  /// No description provided for @s_unlock.
  ///
  /// In en, this message translates to:
  /// **'Unlock'**
  String get s_unlock;

  /// No description provided for @s_calculate.
  ///
  /// In en, this message translates to:
  /// **'Calculate'**
  String get s_calculate;

  /// No description provided for @s_import.
  ///
  /// In en, this message translates to:
  /// **'Import'**
  String get s_import;

  /// No description provided for @s_overwrite.
  ///
  /// In en, this message translates to:
  /// **'Overwrite'**
  String get s_overwrite;

  /// No description provided for @s_done.
  ///
  /// In en, this message translates to:
  /// **'Done'**
  String get s_done;

  /// No description provided for @s_success.
  ///
  /// In en, this message translates to:
  /// **'Success'**
  String get s_success;

  /// No description provided for @s_loading.
  ///
  /// In en, this message translates to:
  /// **'Loading…'**
  String get s_loading;

  /// No description provided for @s_more.
  ///
  /// In en, this message translates to:
  /// **'More'**
  String get s_more;

  /// No description provided for @s_label.
  ///
  /// In en, this message translates to:
  /// **'Label'**
  String get s_label;

  /// No description provided for @s_name.
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get s_name;

  /// No description provided for @s_usb.
  ///
  /// In en, this message translates to:
  /// **'USB'**
  String get s_usb;

  /// No description provided for @s_nfc.
  ///
  /// In en, this message translates to:
  /// **'NFC'**
  String get s_nfc;

  /// No description provided for @s_options.
  ///
  /// In en, this message translates to:
  /// **'Options'**
  String get s_options;

  /// No description provided for @s_details.
  ///
  /// In en, this message translates to:
  /// **'Details'**
  String get s_details;

  /// No description provided for @s_show_window.
  ///
  /// In en, this message translates to:
  /// **'Show window'**
  String get s_show_window;

  /// No description provided for @s_hide_window.
  ///
  /// In en, this message translates to:
  /// **'Hide window'**
  String get s_hide_window;

  /// No description provided for @s_show_navigation.
  ///
  /// In en, this message translates to:
  /// **'Show navigation'**
  String get s_show_navigation;

  /// No description provided for @s_expand_navigation.
  ///
  /// In en, this message translates to:
  /// **'Expand navigation bar'**
  String get s_expand_navigation;

  /// No description provided for @s_collapse_navigation.
  ///
  /// In en, this message translates to:
  /// **'Collapse navigation bar'**
  String get s_collapse_navigation;

  /// No description provided for @s_expand_collapse_navigation.
  ///
  /// In en, this message translates to:
  /// **'Expand/collapse navigation bar'**
  String get s_expand_collapse_navigation;

  /// No description provided for @s_show_menu.
  ///
  /// In en, this message translates to:
  /// **'Show menu'**
  String get s_show_menu;

  /// No description provided for @s_toggle_menu_bar.
  ///
  /// In en, this message translates to:
  /// **'Toggle menu bar'**
  String get s_toggle_menu_bar;

  /// No description provided for @s_more_info.
  ///
  /// In en, this message translates to:
  /// **'More info'**
  String get s_more_info;

  /// No description provided for @l_bullet.
  ///
  /// In en, this message translates to:
  /// **'• {item}'**
  String l_bullet(String item);

  /// No description provided for @s_none.
  ///
  /// In en, this message translates to:
  /// **'<none>'**
  String get s_none;

  /// No description provided for @s_about.
  ///
  /// In en, this message translates to:
  /// **'About'**
  String get s_about;

  /// No description provided for @s_algorithm.
  ///
  /// In en, this message translates to:
  /// **'Algorithm'**
  String get s_algorithm;

  /// No description provided for @s_appearance.
  ///
  /// In en, this message translates to:
  /// **'Appearance'**
  String get s_appearance;

  /// No description provided for @s_actions.
  ///
  /// In en, this message translates to:
  /// **'Actions'**
  String get s_actions;

  /// No description provided for @s_manage.
  ///
  /// In en, this message translates to:
  /// **'Manage'**
  String get s_manage;

  /// No description provided for @s_setup.
  ///
  /// In en, this message translates to:
  /// **'Setup'**
  String get s_setup;

  /// No description provided for @s_device.
  ///
  /// In en, this message translates to:
  /// **'Device'**
  String get s_device;

  /// No description provided for @s_application.
  ///
  /// In en, this message translates to:
  /// **'Application'**
  String get s_application;

  /// No description provided for @s_settings.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get s_settings;

  /// No description provided for @s_reset_settings.
  ///
  /// In en, this message translates to:
  /// **'Reset settings'**
  String get s_reset_settings;

  /// No description provided for @l_reset_settings_desc.
  ///
  /// In en, this message translates to:
  /// **'Restore settings to default'**
  String get l_reset_settings_desc;

  /// No description provided for @q_reset_settings.
  ///
  /// In en, this message translates to:
  /// **'Reset settings?'**
  String get q_reset_settings;

  /// No description provided for @p_reset_settings_confirmation_desc.
  ///
  /// In en, this message translates to:
  /// **'This will restore all settings to their default values.'**
  String get p_reset_settings_confirmation_desc;

  /// No description provided for @s_support.
  ///
  /// In en, this message translates to:
  /// **'Support'**
  String get s_support;

  /// No description provided for @s_certificates.
  ///
  /// In en, this message translates to:
  /// **'Certificates'**
  String get s_certificates;

  /// No description provided for @s_security_key.
  ///
  /// In en, this message translates to:
  /// **'Security Key'**
  String get s_security_key;

  /// No description provided for @s_slots.
  ///
  /// In en, this message translates to:
  /// **'Slots'**
  String get s_slots;

  /// No description provided for @s_help_and_about.
  ///
  /// In en, this message translates to:
  /// **'Help & about'**
  String get s_help_and_about;

  /// No description provided for @s_help.
  ///
  /// In en, this message translates to:
  /// **'Help'**
  String get s_help;

  /// No description provided for @s_app_information.
  ///
  /// In en, this message translates to:
  /// **'Application information'**
  String get s_app_information;

  /// No description provided for @s_home.
  ///
  /// In en, this message translates to:
  /// **'Home'**
  String get s_home;

  /// No description provided for @s_user_guide.
  ///
  /// In en, this message translates to:
  /// **'User guide'**
  String get s_user_guide;

  /// No description provided for @s_i_need_help.
  ///
  /// In en, this message translates to:
  /// **'I need help'**
  String get s_i_need_help;

  /// No description provided for @s_terms_of_use.
  ///
  /// In en, this message translates to:
  /// **'Terms of use'**
  String get s_terms_of_use;

  /// No description provided for @s_privacy_policy.
  ///
  /// In en, this message translates to:
  /// **'Privacy policy'**
  String get s_privacy_policy;

  /// No description provided for @s_open_src_licenses.
  ///
  /// In en, this message translates to:
  /// **'Open source licenses'**
  String get s_open_src_licenses;

  /// No description provided for @s_please_wait.
  ///
  /// In en, this message translates to:
  /// **'Please wait…'**
  String get s_please_wait;

  /// No description provided for @s_secret_key.
  ///
  /// In en, this message translates to:
  /// **'Secret key'**
  String get s_secret_key;

  /// No description provided for @s_show_secret_key.
  ///
  /// In en, this message translates to:
  /// **'Show secret key'**
  String get s_show_secret_key;

  /// No description provided for @s_hide_secret_key.
  ///
  /// In en, this message translates to:
  /// **'Hide secret key'**
  String get s_hide_secret_key;

  /// No description provided for @s_private_key.
  ///
  /// In en, this message translates to:
  /// **'Private key'**
  String get s_private_key;

  /// No description provided for @s_public_key.
  ///
  /// In en, this message translates to:
  /// **'Public key'**
  String get s_public_key;

  /// No description provided for @s_invalid_length.
  ///
  /// In en, this message translates to:
  /// **'Invalid length'**
  String get s_invalid_length;

  /// No description provided for @l_invalid_format_allowed_chars.
  ///
  /// In en, this message translates to:
  /// **'Invalid format, allowed characters: {characters}'**
  String l_invalid_format_allowed_chars(String characters);

  /// No description provided for @l_invalid_keyboard_character.
  ///
  /// In en, this message translates to:
  /// **'Invalid characters for selected keyboard'**
  String get l_invalid_keyboard_character;

  /// No description provided for @s_require_touch.
  ///
  /// In en, this message translates to:
  /// **'Require touch'**
  String get s_require_touch;

  /// No description provided for @q_have_account_info.
  ///
  /// In en, this message translates to:
  /// **'Have account info?'**
  String get q_have_account_info;

  /// No description provided for @s_debugging_tools.
  ///
  /// In en, this message translates to:
  /// **'Debugging tools'**
  String get s_debugging_tools;

  /// No description provided for @s_run_diagnostics.
  ///
  /// In en, this message translates to:
  /// **'Run diagnostics'**
  String get s_run_diagnostics;

  /// No description provided for @l_run_diagnostics_desc.
  ///
  /// In en, this message translates to:
  /// **'Run diagnostics to troubleshoot'**
  String get l_run_diagnostics_desc;

  /// No description provided for @s_logging_level.
  ///
  /// In en, this message translates to:
  /// **'Log level'**
  String get s_logging_level;

  /// No description provided for @s_current_log_level.
  ///
  /// In en, this message translates to:
  /// **'Log level: {level}'**
  String s_current_log_level(String level);

  /// No description provided for @s_character_count.
  ///
  /// In en, this message translates to:
  /// **'Character count'**
  String get s_character_count;

  /// No description provided for @s_language.
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get s_language;

  /// No description provided for @s_app_theme.
  ///
  /// In en, this message translates to:
  /// **'Application theme'**
  String get s_app_theme;

  /// No description provided for @s_system_default.
  ///
  /// In en, this message translates to:
  /// **'System default'**
  String get s_system_default;

  /// No description provided for @s_light_mode.
  ///
  /// In en, this message translates to:
  /// **'Light mode'**
  String get s_light_mode;

  /// No description provided for @s_dark_mode.
  ///
  /// In en, this message translates to:
  /// **'Dark mode'**
  String get s_dark_mode;

  /// No description provided for @s_list_layout.
  ///
  /// In en, this message translates to:
  /// **'List layout'**
  String get s_list_layout;

  /// No description provided for @s_grid_layout.
  ///
  /// In en, this message translates to:
  /// **'Grid layout'**
  String get s_grid_layout;

  /// No description provided for @s_mixed_layout.
  ///
  /// In en, this message translates to:
  /// **'Mixed layout'**
  String get s_mixed_layout;

  /// No description provided for @s_select_layout.
  ///
  /// In en, this message translates to:
  /// **'Select layout'**
  String get s_select_layout;

  /// No description provided for @s_select_to_scan.
  ///
  /// In en, this message translates to:
  /// **'Select to scan'**
  String get s_select_to_scan;

  /// No description provided for @s_hide_reader.
  ///
  /// In en, this message translates to:
  /// **'Hide reader'**
  String get s_hide_reader;

  /// No description provided for @s_show_hidden_readers.
  ///
  /// In en, this message translates to:
  /// **'Show hidden readers'**
  String get s_show_hidden_readers;

  /// No description provided for @s_toggle_readers.
  ///
  /// In en, this message translates to:
  /// **'Toggle readers'**
  String get s_toggle_readers;

  /// No description provided for @l_toggle_readers_desc.
  ///
  /// In en, this message translates to:
  /// **'Show or hide readers'**
  String get l_toggle_readers_desc;

  /// No description provided for @s_sn_serial.
  ///
  /// In en, this message translates to:
  /// **'S/N: {serial}'**
  String s_sn_serial(int serial);

  /// No description provided for @s_fw_version.
  ///
  /// In en, this message translates to:
  /// **'F/W: {version}'**
  String s_fw_version(Object version);

  /// No description provided for @l_serial_number.
  ///
  /// In en, this message translates to:
  /// **'Serial number: {serial}'**
  String l_serial_number(int serial);

  /// No description provided for @l_firmware_version.
  ///
  /// In en, this message translates to:
  /// **'Firmware version: {version}'**
  String l_firmware_version(Object version);

  /// No description provided for @l_fips_capable.
  ///
  /// In en, this message translates to:
  /// **'FIPS capable'**
  String get l_fips_capable;

  /// No description provided for @l_fips_approved.
  ///
  /// In en, this message translates to:
  /// **'FIPS approved'**
  String get l_fips_approved;

  /// No description provided for @l_insert_yk.
  ///
  /// In en, this message translates to:
  /// **'Insert your YubiKey'**
  String get l_insert_yk;

  /// No description provided for @l_insert_or_tap_yk.
  ///
  /// In en, this message translates to:
  /// **'Insert or tap a YubiKey'**
  String get l_insert_or_tap_yk;

  /// No description provided for @l_unplug_yk.
  ///
  /// In en, this message translates to:
  /// **'Unplug your YubiKey'**
  String get l_unplug_yk;

  /// No description provided for @l_reinsert_yk.
  ///
  /// In en, this message translates to:
  /// **'Reinsert your YubiKey'**
  String get l_reinsert_yk;

  /// No description provided for @l_place_on_nfc_reader.
  ///
  /// In en, this message translates to:
  /// **'Place your YubiKey on the NFC reader'**
  String get l_place_on_nfc_reader;

  /// No description provided for @l_replace_yk_on_reader.
  ///
  /// In en, this message translates to:
  /// **'Place your YubiKey back on the reader'**
  String get l_replace_yk_on_reader;

  /// No description provided for @l_remove_yk_from_reader.
  ///
  /// In en, this message translates to:
  /// **'Remove your YubiKey from the NFC reader'**
  String get l_remove_yk_from_reader;

  /// No description provided for @p_try_reinsert_yk.
  ///
  /// In en, this message translates to:
  /// **'Try to remove and reinsert your YubiKey.'**
  String get p_try_reinsert_yk;

  /// No description provided for @s_touch_required.
  ///
  /// In en, this message translates to:
  /// **'Touch required'**
  String get s_touch_required;

  /// No description provided for @l_touch_button_now.
  ///
  /// In en, this message translates to:
  /// **'Touch the button on your YubiKey now'**
  String get l_touch_button_now;

  /// No description provided for @l_long_touch_button_now.
  ///
  /// In en, this message translates to:
  /// **'Press and hold the button on your YubiKey for 10 seconds now'**
  String get l_long_touch_button_now;

  /// No description provided for @l_keep_touching_yk.
  ///
  /// In en, this message translates to:
  /// **'Keep touching your YubiKey repeatedly…'**
  String get l_keep_touching_yk;

  /// No description provided for @s_capability_otp.
  ///
  /// In en, this message translates to:
  /// **'Yubico OTP'**
  String get s_capability_otp;

  /// No description provided for @s_capability_u2f.
  ///
  /// In en, this message translates to:
  /// **'FIDO U2F'**
  String get s_capability_u2f;

  /// No description provided for @s_capability_fido2.
  ///
  /// In en, this message translates to:
  /// **'FIDO2'**
  String get s_capability_fido2;

  /// No description provided for @s_capability_oath.
  ///
  /// In en, this message translates to:
  /// **'OATH'**
  String get s_capability_oath;

  /// No description provided for @s_capability_piv.
  ///
  /// In en, this message translates to:
  /// **'PIV'**
  String get s_capability_piv;

  /// No description provided for @s_capability_openpgp.
  ///
  /// In en, this message translates to:
  /// **'OpenPGP'**
  String get s_capability_openpgp;

  /// No description provided for @s_capability_hsmauth.
  ///
  /// In en, this message translates to:
  /// **'YubiHSM Auth'**
  String get s_capability_hsmauth;

  /// No description provided for @s_toggle_applications.
  ///
  /// In en, this message translates to:
  /// **'Toggle applications'**
  String get s_toggle_applications;

  /// No description provided for @s_toggle_interfaces.
  ///
  /// In en, this message translates to:
  /// **'Toggle interfaces'**
  String get s_toggle_interfaces;

  /// No description provided for @p_toggle_applications_desc.
  ///
  /// In en, this message translates to:
  /// **'Enable or disable applications over available transports.'**
  String get p_toggle_applications_desc;

  /// No description provided for @p_toggle_interfaces_desc.
  ///
  /// In en, this message translates to:
  /// **'Enable or disable USB interfaces.'**
  String get p_toggle_interfaces_desc;

  /// No description provided for @l_toggle_applications_desc.
  ///
  /// In en, this message translates to:
  /// **'Enable/disable applications'**
  String get l_toggle_applications_desc;

  /// No description provided for @l_toggle_interfaces_desc.
  ///
  /// In en, this message translates to:
  /// **'Enable/disable interfaces'**
  String get l_toggle_interfaces_desc;

  /// No description provided for @s_reconfiguring_yk.
  ///
  /// In en, this message translates to:
  /// **'Reconfiguring YubiKey…'**
  String get s_reconfiguring_yk;

  /// No description provided for @s_config_updated.
  ///
  /// In en, this message translates to:
  /// **'Configuration updated'**
  String get s_config_updated;

  /// No description provided for @l_config_updated_reinsert.
  ///
  /// In en, this message translates to:
  /// **'Configuration updated, remove and reinsert your YubiKey'**
  String get l_config_updated_reinsert;

  /// No description provided for @s_fido_disabled.
  ///
  /// In en, this message translates to:
  /// **'FIDO2 disabled'**
  String get s_fido_disabled;

  /// No description provided for @l_webauthn_req_fido2.
  ///
  /// In en, this message translates to:
  /// **'WebAuthn requires the FIDO2 application to be enabled on your YubiKey'**
  String get l_webauthn_req_fido2;

  /// No description provided for @s_lock_code.
  ///
  /// In en, this message translates to:
  /// **'Lock code'**
  String get s_lock_code;

  /// No description provided for @l_wrong_lock_code.
  ///
  /// In en, this message translates to:
  /// **'Wrong lock code'**
  String get l_wrong_lock_code;

  /// No description provided for @s_show_lock_code.
  ///
  /// In en, this message translates to:
  /// **'Show lock code'**
  String get s_show_lock_code;

  /// No description provided for @s_hide_lock_code.
  ///
  /// In en, this message translates to:
  /// **'Hide lock code'**
  String get s_hide_lock_code;

  /// No description provided for @p_lock_code_required_desc.
  ///
  /// In en, this message translates to:
  /// **'The action you are about to perform requires the configuration lock code to be entered.'**
  String get p_lock_code_required_desc;

  /// No description provided for @l_helper_not_responding.
  ///
  /// In en, this message translates to:
  /// **'The Helper process isn\'t responding'**
  String get l_helper_not_responding;

  /// No description provided for @l_yk_no_access.
  ///
  /// In en, this message translates to:
  /// **'This YubiKey cannot be accessed'**
  String get l_yk_no_access;

  /// No description provided for @s_yk_inaccessible.
  ///
  /// In en, this message translates to:
  /// **'Device inaccessible'**
  String get s_yk_inaccessible;

  /// No description provided for @l_open_connection_failed.
  ///
  /// In en, this message translates to:
  /// **'Failed to open connection'**
  String get l_open_connection_failed;

  /// No description provided for @l_ccid_connection_failed.
  ///
  /// In en, this message translates to:
  /// **'Failed to open smart card connection'**
  String get l_ccid_connection_failed;

  /// No description provided for @p_ccid_service_unavailable.
  ///
  /// In en, this message translates to:
  /// **'Make sure your smart card service is functioning.'**
  String get p_ccid_service_unavailable;

  /// No description provided for @p_pcscd_unavailable.
  ///
  /// In en, this message translates to:
  /// **'Make sure pcscd is installed and running.'**
  String get p_pcscd_unavailable;

  /// No description provided for @l_no_yk_present.
  ///
  /// In en, this message translates to:
  /// **'No YubiKey present'**
  String get l_no_yk_present;

  /// No description provided for @s_unknown_type.
  ///
  /// In en, this message translates to:
  /// **'Unknown type'**
  String get s_unknown_type;

  /// No description provided for @s_unknown_device.
  ///
  /// In en, this message translates to:
  /// **'Unrecognized device'**
  String get s_unknown_device;

  /// No description provided for @s_restricted_nfc.
  ///
  /// In en, this message translates to:
  /// **'NFC activation'**
  String get s_restricted_nfc;

  /// No description provided for @l_deactivate_restricted_nfc.
  ///
  /// In en, this message translates to:
  /// **'How to activate NFC'**
  String get l_deactivate_restricted_nfc;

  /// No description provided for @p_deactivate_restricted_nfc_desc.
  ///
  /// In en, this message translates to:
  /// **'Connect your YubiKey to any USB power source, such as a computer, for at least 3 seconds.\n\nOnce powered, NFC will be activated and ready for use.'**
  String get p_deactivate_restricted_nfc_desc;

  /// No description provided for @p_deactivate_restricted_nfc_footer.
  ///
  /// In en, this message translates to:
  /// **'Your YubiKey is equipped with Restricted NFC, a feature designed to safeguard against wireless manipulation during shipping. This means that NFC operations are temporarily disabled until you activate them.'**
  String get p_deactivate_restricted_nfc_footer;

  /// No description provided for @s_unsupported_yk.
  ///
  /// In en, this message translates to:
  /// **'Unsupported YubiKey'**
  String get s_unsupported_yk;

  /// No description provided for @p_operation_failed_try_again.
  ///
  /// In en, this message translates to:
  /// **'The operation failed, please try again.'**
  String get p_operation_failed_try_again;

  /// No description provided for @l_configuration_unsupported.
  ///
  /// In en, this message translates to:
  /// **'Configuration not supported'**
  String get l_configuration_unsupported;

  /// No description provided for @p_scp_unsupported.
  ///
  /// In en, this message translates to:
  /// **'To communicate over NFC, the YubiKey requires technology which is not supported by this phone. Please plug the YubiKey to the phone\'s USB port.'**
  String get p_scp_unsupported;

  /// No description provided for @l_error_occurred.
  ///
  /// In en, this message translates to:
  /// **'An error has occurred'**
  String get l_error_occurred;

  /// No description provided for @s_application_error.
  ///
  /// In en, this message translates to:
  /// **'Application error'**
  String get s_application_error;

  /// No description provided for @l_import_error.
  ///
  /// In en, this message translates to:
  /// **'Import error'**
  String get l_import_error;

  /// No description provided for @l_file_not_found.
  ///
  /// In en, this message translates to:
  /// **'File not found'**
  String get l_file_not_found;

  /// No description provided for @l_file_too_big.
  ///
  /// In en, this message translates to:
  /// **'File size too big'**
  String get l_file_too_big;

  /// No description provided for @l_filesystem_error.
  ///
  /// In en, this message translates to:
  /// **'File system operation error'**
  String get l_filesystem_error;

  /// No description provided for @s_pin.
  ///
  /// In en, this message translates to:
  /// **'PIN'**
  String get s_pin;

  /// No description provided for @s_puk.
  ///
  /// In en, this message translates to:
  /// **'PUK'**
  String get s_puk;

  /// No description provided for @s_set_pin.
  ///
  /// In en, this message translates to:
  /// **'Set PIN'**
  String get s_set_pin;

  /// No description provided for @s_change_pin.
  ///
  /// In en, this message translates to:
  /// **'Change PIN'**
  String get s_change_pin;

  /// No description provided for @s_change_puk.
  ///
  /// In en, this message translates to:
  /// **'Change PUK'**
  String get s_change_puk;

  /// No description provided for @s_show_pin.
  ///
  /// In en, this message translates to:
  /// **'Show PIN'**
  String get s_show_pin;

  /// No description provided for @s_hide_pin.
  ///
  /// In en, this message translates to:
  /// **'Hide PIN'**
  String get s_hide_pin;

  /// No description provided for @s_show_puk.
  ///
  /// In en, this message translates to:
  /// **'Show PUK'**
  String get s_show_puk;

  /// No description provided for @s_hide_puk.
  ///
  /// In en, this message translates to:
  /// **'Hide PUK'**
  String get s_hide_puk;

  /// No description provided for @s_current_pin.
  ///
  /// In en, this message translates to:
  /// **'Current PIN'**
  String get s_current_pin;

  /// No description provided for @s_current_puk.
  ///
  /// In en, this message translates to:
  /// **'Current PUK'**
  String get s_current_puk;

  /// No description provided for @s_new_pin.
  ///
  /// In en, this message translates to:
  /// **'New PIN'**
  String get s_new_pin;

  /// No description provided for @s_new_puk.
  ///
  /// In en, this message translates to:
  /// **'New PUK'**
  String get s_new_puk;

  /// No description provided for @s_confirm_pin.
  ///
  /// In en, this message translates to:
  /// **'Confirm PIN'**
  String get s_confirm_pin;

  /// No description provided for @s_confirm_puk.
  ///
  /// In en, this message translates to:
  /// **'Confirm PUK'**
  String get s_confirm_puk;

  /// No description provided for @s_unblock_pin.
  ///
  /// In en, this message translates to:
  /// **'Reset PIN'**
  String get s_unblock_pin;

  /// No description provided for @l_pin_mismatch.
  ///
  /// In en, this message translates to:
  /// **'PINs do not match'**
  String get l_pin_mismatch;

  /// No description provided for @l_puk_mismatch.
  ///
  /// In en, this message translates to:
  /// **'PUKs do not match'**
  String get l_puk_mismatch;

  /// No description provided for @s_pin_set.
  ///
  /// In en, this message translates to:
  /// **'PIN set'**
  String get s_pin_set;

  /// No description provided for @s_puk_set.
  ///
  /// In en, this message translates to:
  /// **'PUK set'**
  String get s_puk_set;

  /// No description provided for @l_set_pin_failed.
  ///
  /// In en, this message translates to:
  /// **'Failed to set PIN: {message}'**
  String l_set_pin_failed(String message);

  /// No description provided for @l_attempts_remaining.
  ///
  /// In en, this message translates to:
  /// **'{retries, plural, =1{{retries} attempt remaining}other{{retries} attempts remaining}}'**
  String l_attempts_remaining(int retries);

  /// No description provided for @l_wrong_pin_attempts_remaining.
  ///
  /// In en, this message translates to:
  /// **'Wrong PIN, {retries, plural, =1{{retries} attempt remaining}other{{retries} attempts remaining}}'**
  String l_wrong_pin_attempts_remaining(int retries);

  /// No description provided for @l_wrong_puk_attempts_remaining.
  ///
  /// In en, this message translates to:
  /// **'Wrong PUK, {retries, plural, =1{{retries} attempt remaining}other{{retries} attempts remaining}}'**
  String l_wrong_puk_attempts_remaining(int retries);

  /// No description provided for @s_fido_pin_protection.
  ///
  /// In en, this message translates to:
  /// **'FIDO PIN protection'**
  String get s_fido_pin_protection;

  /// No description provided for @s_pin_change_required.
  ///
  /// In en, this message translates to:
  /// **'PIN change required'**
  String get s_pin_change_required;

  /// No description provided for @l_enter_fido2_pin.
  ///
  /// In en, this message translates to:
  /// **'Enter the FIDO2 PIN for your YubiKey'**
  String get l_enter_fido2_pin;

  /// No description provided for @p_fido2_pin_required.
  ///
  /// In en, this message translates to:
  /// **'The action you are about to perform requires the FIDO2 PIN to be entered.'**
  String get p_fido2_pin_required;

  /// No description provided for @l_pin_blocked_reset.
  ///
  /// In en, this message translates to:
  /// **'PIN is blocked; factory reset the FIDO application'**
  String get l_pin_blocked_reset;

  /// No description provided for @l_pin_blocked.
  ///
  /// In en, this message translates to:
  /// **'PIN is blocked'**
  String get l_pin_blocked;

  /// No description provided for @l_set_pin_first.
  ///
  /// In en, this message translates to:
  /// **'A PIN is required'**
  String get l_set_pin_first;

  /// No description provided for @l_unlock_pin_first.
  ///
  /// In en, this message translates to:
  /// **'Unlock with PIN'**
  String get l_unlock_pin_first;

  /// No description provided for @l_pin_soft_locked.
  ///
  /// In en, this message translates to:
  /// **'PIN has been blocked until the YubiKey is removed and reinserted'**
  String get l_pin_soft_locked;

  /// No description provided for @l_pin_change_required_desc.
  ///
  /// In en, this message translates to:
  /// **'A new PIN must be set before you can use this application'**
  String get l_pin_change_required_desc;

  /// No description provided for @p_new_fido2_pin_requirements.
  ///
  /// In en, this message translates to:
  /// **'A PIN must be {min_length}-{max_length} characters long and may contain letters, numbers and special characters.'**
  String p_new_fido2_pin_requirements(int min_length, int max_length);

  /// No description provided for @p_new_fido2_pin_complexity_active_requirements.
  ///
  /// In en, this message translates to:
  /// **'A PIN must be {min_length}-{max_length} characters long, contain at least {unique_characters} unique characters, and not be a commonly used PIN, like \"{common_pin}\". It may contain letters, numbers, and special characters.'**
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  );

  /// No description provided for @s_ep_attestation.
  ///
  /// In en, this message translates to:
  /// **'Enterprise Attestation'**
  String get s_ep_attestation;

  /// No description provided for @s_ep_attestation_enabled.
  ///
  /// In en, this message translates to:
  /// **'Enterprise Attestation enabled'**
  String get s_ep_attestation_enabled;

  /// No description provided for @q_enable_ep_attestation.
  ///
  /// In en, this message translates to:
  /// **'Enable Enterprise Attestation?'**
  String get q_enable_ep_attestation;

  /// No description provided for @p_enable_ep_attestation_desc.
  ///
  /// In en, this message translates to:
  /// **'This will enable Enterprise Attestation, allowing authorized domains to uniquely identify your YubiKey.'**
  String get p_enable_ep_attestation_desc;

  /// No description provided for @p_enable_ep_attestation_disable_with_factory_reset.
  ///
  /// In en, this message translates to:
  /// **'Once enabled, Enterprise Attestation can only be disabled by performing a FIDO factory reset.'**
  String get p_enable_ep_attestation_disable_with_factory_reset;

  /// No description provided for @s_pin_required.
  ///
  /// In en, this message translates to:
  /// **'PIN required'**
  String get s_pin_required;

  /// No description provided for @p_pin_required_desc.
  ///
  /// In en, this message translates to:
  /// **'The action you are about to perform requires the PIV PIN to be entered.'**
  String get p_pin_required_desc;

  /// No description provided for @l_piv_pin_blocked.
  ///
  /// In en, this message translates to:
  /// **'Blocked, use PUK to reset'**
  String get l_piv_pin_blocked;

  /// No description provided for @p_piv_pin_blocked_desc.
  ///
  /// In en, this message translates to:
  /// **'The PIN is blocked. Use the PUK to reset it.'**
  String get p_piv_pin_blocked_desc;

  /// No description provided for @p_piv_pin_blocked_bio_desc.
  ///
  /// In en, this message translates to:
  /// **'The PIN is blocked. A factory reset is required.'**
  String get p_piv_pin_blocked_bio_desc;

  /// No description provided for @l_piv_pin_puk_blocked.
  ///
  /// In en, this message translates to:
  /// **'Blocked, factory reset needed'**
  String get l_piv_pin_puk_blocked;

  /// No description provided for @p_piv_pin_puk_blocked_desc.
  ///
  /// In en, this message translates to:
  /// **'Both the PIN and PUK are blocked. A factory reset of the PIV application is required.'**
  String get p_piv_pin_puk_blocked_desc;

  /// No description provided for @p_new_piv_pin_puk_requirements.
  ///
  /// In en, this message translates to:
  /// **'A {name} must be at least {length} characters long.'**
  String p_new_piv_pin_puk_requirements(String name, int length);

  /// No description provided for @p_new_piv_pin_puk_complexity_active_requirements.
  ///
  /// In en, this message translates to:
  /// **'A {name} must be at least {length} characters long, contain at least 2 unique characters, and not be a commonly used {name}, like \"{common}\".'**
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  );

  /// No description provided for @p_pin_puk_complexity_failure.
  ///
  /// In en, this message translates to:
  /// **'New {name} doesn\'t meet complexity requirements.'**
  String p_pin_puk_complexity_failure(String name);

  /// No description provided for @s_dismiss.
  ///
  /// In en, this message translates to:
  /// **'Dismiss'**
  String get s_dismiss;

  /// No description provided for @p_default_pin_puk_key_desc.
  ///
  /// In en, this message translates to:
  /// **'It is recommended to change the default PIN, PUK and management key.'**
  String get p_default_pin_puk_key_desc;

  /// No description provided for @p_default_pin_puk_key_fips_desc.
  ///
  /// In en, this message translates to:
  /// **'For FIPS compliance it is required to change the default PIN, PUK and management key.'**
  String get p_default_pin_puk_key_fips_desc;

  /// No description provided for @l_warning_default_pin.
  ///
  /// In en, this message translates to:
  /// **'Warning: Default PIN used'**
  String get l_warning_default_pin;

  /// No description provided for @l_warning_default_puk.
  ///
  /// In en, this message translates to:
  /// **'Warning: Default PUK used'**
  String get l_warning_default_puk;

  /// No description provided for @l_default_pin_used.
  ///
  /// In en, this message translates to:
  /// **'Default PIN used'**
  String get l_default_pin_used;

  /// No description provided for @l_default_puk_used.
  ///
  /// In en, this message translates to:
  /// **'Default PUK used'**
  String get l_default_puk_used;

  /// No description provided for @l_pin_complexity.
  ///
  /// In en, this message translates to:
  /// **'PIN complexity enforced'**
  String get l_pin_complexity;

  /// No description provided for @s_password.
  ///
  /// In en, this message translates to:
  /// **'Password'**
  String get s_password;

  /// No description provided for @s_manage_password.
  ///
  /// In en, this message translates to:
  /// **'Manage password'**
  String get s_manage_password;

  /// No description provided for @s_set_password.
  ///
  /// In en, this message translates to:
  /// **'Set password'**
  String get s_set_password;

  /// No description provided for @s_password_set.
  ///
  /// In en, this message translates to:
  /// **'Password set'**
  String get s_password_set;

  /// No description provided for @s_show_password.
  ///
  /// In en, this message translates to:
  /// **'Show password'**
  String get s_show_password;

  /// No description provided for @s_hide_password.
  ///
  /// In en, this message translates to:
  /// **'Hide password'**
  String get s_hide_password;

  /// No description provided for @l_password_protection.
  ///
  /// In en, this message translates to:
  /// **'Password protection of accounts'**
  String get l_password_protection;

  /// No description provided for @s_new_password.
  ///
  /// In en, this message translates to:
  /// **'New password'**
  String get s_new_password;

  /// No description provided for @s_current_password.
  ///
  /// In en, this message translates to:
  /// **'Current password'**
  String get s_current_password;

  /// No description provided for @s_confirm_password.
  ///
  /// In en, this message translates to:
  /// **'Confirm password'**
  String get s_confirm_password;

  /// No description provided for @l_password_mismatch.
  ///
  /// In en, this message translates to:
  /// **'Passwords do not match'**
  String get l_password_mismatch;

  /// No description provided for @s_wrong_password.
  ///
  /// In en, this message translates to:
  /// **'Wrong password'**
  String get s_wrong_password;

  /// No description provided for @p_wrong_password.
  ///
  /// In en, this message translates to:
  /// **'Wrong password. If you don\'t know your password, you\'ll need to reset the YubiKey.'**
  String get p_wrong_password;

  /// No description provided for @s_remove_password.
  ///
  /// In en, this message translates to:
  /// **'Remove password'**
  String get s_remove_password;

  /// No description provided for @s_password_removed.
  ///
  /// In en, this message translates to:
  /// **'Password removed'**
  String get s_password_removed;

  /// No description provided for @s_remember_password.
  ///
  /// In en, this message translates to:
  /// **'Remember password'**
  String get s_remember_password;

  /// No description provided for @s_clear_saved_password.
  ///
  /// In en, this message translates to:
  /// **'Clear saved password'**
  String get s_clear_saved_password;

  /// No description provided for @s_password_forgotten.
  ///
  /// In en, this message translates to:
  /// **'Password forgotten'**
  String get s_password_forgotten;

  /// No description provided for @l_keystore_unavailable.
  ///
  /// In en, this message translates to:
  /// **'OS Keystore unavailable'**
  String get l_keystore_unavailable;

  /// No description provided for @l_remember_pw_failed.
  ///
  /// In en, this message translates to:
  /// **'Failed to remember password'**
  String get l_remember_pw_failed;

  /// No description provided for @l_unlock_first.
  ///
  /// In en, this message translates to:
  /// **'Unlock with password'**
  String get l_unlock_first;

  /// No description provided for @l_set_password_first.
  ///
  /// In en, this message translates to:
  /// **'Set a password'**
  String get l_set_password_first;

  /// No description provided for @l_enter_oath_pw.
  ///
  /// In en, this message translates to:
  /// **'Enter the OATH password for your YubiKey'**
  String get l_enter_oath_pw;

  /// No description provided for @p_new_password_requirements.
  ///
  /// In en, this message translates to:
  /// **'A password may contain letters, numbers and special characters.'**
  String get p_new_password_requirements;

  /// No description provided for @s_management_key.
  ///
  /// In en, this message translates to:
  /// **'Management key'**
  String get s_management_key;

  /// No description provided for @s_current_management_key.
  ///
  /// In en, this message translates to:
  /// **'Current management key'**
  String get s_current_management_key;

  /// No description provided for @s_new_management_key.
  ///
  /// In en, this message translates to:
  /// **'New management key'**
  String get s_new_management_key;

  /// No description provided for @l_change_management_key.
  ///
  /// In en, this message translates to:
  /// **'Change management key'**
  String get l_change_management_key;

  /// No description provided for @l_management_key_changed.
  ///
  /// In en, this message translates to:
  /// **'Management key changed'**
  String get l_management_key_changed;

  /// No description provided for @l_default_key_used.
  ///
  /// In en, this message translates to:
  /// **'Default management key used'**
  String get l_default_key_used;

  /// No description provided for @s_generate_random.
  ///
  /// In en, this message translates to:
  /// **'Generate random'**
  String get s_generate_random;

  /// No description provided for @s_use_default.
  ///
  /// In en, this message translates to:
  /// **'Use default'**
  String get s_use_default;

  /// No description provided for @l_warning_default_key.
  ///
  /// In en, this message translates to:
  /// **'Warning: Default key used'**
  String get l_warning_default_key;

  /// No description provided for @s_protect_key.
  ///
  /// In en, this message translates to:
  /// **'Protect with PIN'**
  String get s_protect_key;

  /// No description provided for @p_protect_key_desc.
  ///
  /// In en, this message translates to:
  /// **'Use the PIN in place of the management key during operations that require management key authentication.'**
  String get p_protect_key_desc;

  /// No description provided for @s_management_key_algorithm.
  ///
  /// In en, this message translates to:
  /// **'Management key algorithm'**
  String get s_management_key_algorithm;

  /// No description provided for @p_management_key_algorithm_desc.
  ///
  /// In en, this message translates to:
  /// **'The algorithm to choose for the management key.'**
  String get p_management_key_algorithm_desc;

  /// No description provided for @l_pin_protected_key.
  ///
  /// In en, this message translates to:
  /// **'PIN can be used instead'**
  String get l_pin_protected_key;

  /// No description provided for @l_wrong_key.
  ///
  /// In en, this message translates to:
  /// **'Wrong key'**
  String get l_wrong_key;

  /// No description provided for @l_unlock_piv_management.
  ///
  /// In en, this message translates to:
  /// **'Unlock PIV management'**
  String get l_unlock_piv_management;

  /// No description provided for @p_unlock_piv_management_desc.
  ///
  /// In en, this message translates to:
  /// **'The action you are about to perform requires the PIV management key.'**
  String get p_unlock_piv_management_desc;

  /// No description provided for @l_account.
  ///
  /// In en, this message translates to:
  /// **'Account: {label}'**
  String l_account(String label);

  /// No description provided for @s_accounts.
  ///
  /// In en, this message translates to:
  /// **'Accounts'**
  String get s_accounts;

  /// No description provided for @s_no_accounts.
  ///
  /// In en, this message translates to:
  /// **'No accounts'**
  String get s_no_accounts;

  /// No description provided for @l_results_for.
  ///
  /// In en, this message translates to:
  /// **'Results for \"{query}\"'**
  String l_results_for(String query);

  /// No description provided for @l_authenticator_get_started.
  ///
  /// In en, this message translates to:
  /// **'Get started with OTP accounts'**
  String get l_authenticator_get_started;

  /// No description provided for @l_no_accounts_desc.
  ///
  /// In en, this message translates to:
  /// **'Add accounts to your YubiKey from any service provider supporting OATH TOTP/HOTP'**
  String get l_no_accounts_desc;

  /// No description provided for @s_add_account.
  ///
  /// In en, this message translates to:
  /// **'Add account'**
  String get s_add_account;

  /// No description provided for @p_add_account_desc.
  ///
  /// In en, this message translates to:
  /// **'Scan QR code or enter the credential details manually.'**
  String get p_add_account_desc;

  /// No description provided for @s_add_accounts.
  ///
  /// In en, this message translates to:
  /// **'Add account(s)'**
  String get s_add_accounts;

  /// No description provided for @l_drop_qr_description.
  ///
  /// In en, this message translates to:
  /// **'Drop QR code to add account(s)'**
  String get l_drop_qr_description;

  /// No description provided for @p_add_account_three_ways.
  ///
  /// In en, this message translates to:
  /// **'There are three ways of adding accounts.'**
  String get p_add_account_three_ways;

  /// No description provided for @s_scanning.
  ///
  /// In en, this message translates to:
  /// **'Scanning (recommended)'**
  String get s_scanning;

  /// No description provided for @p_scanning_desc.
  ///
  /// In en, this message translates to:
  /// **'Before scanning a QR code, make sure the full code is visible on screen.'**
  String get p_scanning_desc;

  /// No description provided for @s_drag_and_drop.
  ///
  /// In en, this message translates to:
  /// **'Drag and drop'**
  String get s_drag_and_drop;

  /// No description provided for @p_drag_and_drop_desc.
  ///
  /// In en, this message translates to:
  /// **'An image containing a QR code may be dropped anywhere in the Accounts view.'**
  String get p_drag_and_drop_desc;

  /// No description provided for @s_manually.
  ///
  /// In en, this message translates to:
  /// **'Manually'**
  String get s_manually;

  /// No description provided for @p_manually_desc.
  ///
  /// In en, this message translates to:
  /// **'Account credential details may be entered manually in the form.'**
  String get p_manually_desc;

  /// No description provided for @s_account_added.
  ///
  /// In en, this message translates to:
  /// **'Account added'**
  String get s_account_added;

  /// No description provided for @l_account_add_failed.
  ///
  /// In en, this message translates to:
  /// **'Failed adding account: {message}'**
  String l_account_add_failed(String message);

  /// No description provided for @l_add_account_password_required.
  ///
  /// In en, this message translates to:
  /// **'Password required'**
  String get l_add_account_password_required;

  /// No description provided for @l_add_account_unlock_required.
  ///
  /// In en, this message translates to:
  /// **'Unlock required'**
  String get l_add_account_unlock_required;

  /// No description provided for @l_add_account_func_missing.
  ///
  /// In en, this message translates to:
  /// **'Functionality missing or disabled'**
  String get l_add_account_func_missing;

  /// No description provided for @l_account_name_required.
  ///
  /// In en, this message translates to:
  /// **'Your account must have a name'**
  String get l_account_name_required;

  /// No description provided for @l_name_already_exists.
  ///
  /// In en, this message translates to:
  /// **'This name already exists for the issuer'**
  String get l_name_already_exists;

  /// No description provided for @l_account_already_exists.
  ///
  /// In en, this message translates to:
  /// **'This account already exists on the YubiKey'**
  String get l_account_already_exists;

  /// No description provided for @l_invalid_character_issuer.
  ///
  /// In en, this message translates to:
  /// **'Invalid character: \':\' is not allowed in issuer'**
  String get l_invalid_character_issuer;

  /// No description provided for @l_select_accounts.
  ///
  /// In en, this message translates to:
  /// **'Select account(s) to add to the YubiKey'**
  String get l_select_accounts;

  /// No description provided for @s_pin_account.
  ///
  /// In en, this message translates to:
  /// **'Pin account'**
  String get s_pin_account;

  /// No description provided for @s_unpin_account.
  ///
  /// In en, this message translates to:
  /// **'Unpin account'**
  String get s_unpin_account;

  /// No description provided for @s_no_pinned_accounts.
  ///
  /// In en, this message translates to:
  /// **'No pinned accounts'**
  String get s_no_pinned_accounts;

  /// No description provided for @s_pinned.
  ///
  /// In en, this message translates to:
  /// **'Pinned'**
  String get s_pinned;

  /// No description provided for @l_pin_account_desc.
  ///
  /// In en, this message translates to:
  /// **'Keep your important accounts together'**
  String get l_pin_account_desc;

  /// No description provided for @s_rename_account.
  ///
  /// In en, this message translates to:
  /// **'Rename account'**
  String get s_rename_account;

  /// No description provided for @l_rename_account_desc.
  ///
  /// In en, this message translates to:
  /// **'Edit the issuer/name of the account'**
  String get l_rename_account_desc;

  /// No description provided for @s_account_renamed.
  ///
  /// In en, this message translates to:
  /// **'Account renamed'**
  String get s_account_renamed;

  /// No description provided for @l_rename_account_failed.
  ///
  /// In en, this message translates to:
  /// **'Failed renaming account: {message}'**
  String l_rename_account_failed(String message);

  /// No description provided for @p_rename_will_change_account_displayed.
  ///
  /// In en, this message translates to:
  /// **'This will change how the account is displayed in the list.'**
  String get p_rename_will_change_account_displayed;

  /// No description provided for @s_delete_account.
  ///
  /// In en, this message translates to:
  /// **'Delete account'**
  String get s_delete_account;

  /// No description provided for @q_delete_account.
  ///
  /// In en, this message translates to:
  /// **'Delete account?'**
  String get q_delete_account;

  /// No description provided for @l_delete_account_desc.
  ///
  /// In en, this message translates to:
  /// **'Remove the account from your YubiKey'**
  String get l_delete_account_desc;

  /// No description provided for @s_account_deleted.
  ///
  /// In en, this message translates to:
  /// **'Account deleted'**
  String get s_account_deleted;

  /// No description provided for @p_warning_delete_account.
  ///
  /// In en, this message translates to:
  /// **'Warning! This action will delete the account from your YubiKey.'**
  String get p_warning_delete_account;

  /// No description provided for @p_warning_disable_credential.
  ///
  /// In en, this message translates to:
  /// **'Make sure to disable this account from the service it is registered with to avoid being locked out.'**
  String get p_warning_disable_credential;

  /// No description provided for @s_account_name.
  ///
  /// In en, this message translates to:
  /// **'Account name'**
  String get s_account_name;

  /// No description provided for @s_search_accounts.
  ///
  /// In en, this message translates to:
  /// **'Search accounts'**
  String get s_search_accounts;

  /// No description provided for @l_accounts_used.
  ///
  /// In en, this message translates to:
  /// **'{used} of {capacity} accounts used'**
  String l_accounts_used(int used, int capacity);

  /// No description provided for @s_num_digits.
  ///
  /// In en, this message translates to:
  /// **'{num} digits'**
  String s_num_digits(int num);

  /// No description provided for @s_num_sec.
  ///
  /// In en, this message translates to:
  /// **'{num} sec'**
  String s_num_sec(int num);

  /// No description provided for @s_issuer_optional.
  ///
  /// In en, this message translates to:
  /// **'Issuer (optional)'**
  String get s_issuer_optional;

  /// No description provided for @s_counter_based.
  ///
  /// In en, this message translates to:
  /// **'Counter based'**
  String get s_counter_based;

  /// No description provided for @s_time_based.
  ///
  /// In en, this message translates to:
  /// **'Time based'**
  String get s_time_based;

  /// No description provided for @l_copy_code_desc.
  ///
  /// In en, this message translates to:
  /// **'Paste the code into another application'**
  String get l_copy_code_desc;

  /// No description provided for @l_calculate_code_desc.
  ///
  /// In en, this message translates to:
  /// **'Get a new code from your YubiKey'**
  String get l_calculate_code_desc;

  /// No description provided for @s_rp_id.
  ///
  /// In en, this message translates to:
  /// **'RP ID'**
  String get s_rp_id;

  /// No description provided for @s_user_id.
  ///
  /// In en, this message translates to:
  /// **'User ID'**
  String get s_user_id;

  /// No description provided for @s_credential_id.
  ///
  /// In en, this message translates to:
  /// **'Credential ID'**
  String get s_credential_id;

  /// No description provided for @s_display_name.
  ///
  /// In en, this message translates to:
  /// **'Display Name'**
  String get s_display_name;

  /// No description provided for @s_user_name.
  ///
  /// In en, this message translates to:
  /// **'User Name'**
  String get s_user_name;

  /// No description provided for @s_passkeys.
  ///
  /// In en, this message translates to:
  /// **'Passkeys'**
  String get s_passkeys;

  /// No description provided for @s_no_passkeys.
  ///
  /// In en, this message translates to:
  /// **'No passkeys'**
  String get s_no_passkeys;

  /// No description provided for @l_ready_to_use.
  ///
  /// In en, this message translates to:
  /// **'Ready to use'**
  String get l_ready_to_use;

  /// No description provided for @l_register_sk_on_websites.
  ///
  /// In en, this message translates to:
  /// **'Register as a Security Key on websites'**
  String get l_register_sk_on_websites;

  /// No description provided for @l_no_discoverable_accounts.
  ///
  /// In en, this message translates to:
  /// **'No passkeys stored'**
  String get l_no_discoverable_accounts;

  /// No description provided for @p_non_passkeys_note.
  ///
  /// In en, this message translates to:
  /// **'Non-passkey credentials may exist, but can not be listed.'**
  String get p_non_passkeys_note;

  /// No description provided for @s_delete_passkey.
  ///
  /// In en, this message translates to:
  /// **'Delete passkey'**
  String get s_delete_passkey;

  /// No description provided for @q_delete_passkey.
  ///
  /// In en, this message translates to:
  /// **'Delete passkey?'**
  String get q_delete_passkey;

  /// No description provided for @l_delete_passkey_desc.
  ///
  /// In en, this message translates to:
  /// **'Remove the passkey from the YubiKey'**
  String get l_delete_passkey_desc;

  /// No description provided for @s_passkey_deleted.
  ///
  /// In en, this message translates to:
  /// **'Passkey deleted'**
  String get s_passkey_deleted;

  /// No description provided for @p_warning_delete_passkey.
  ///
  /// In en, this message translates to:
  /// **'Warning! This action will delete the passkey from your YubiKey.'**
  String get p_warning_delete_passkey;

  /// No description provided for @p_warning_delete_passkey_desc.
  ///
  /// In en, this message translates to:
  /// **'You will no longer be able to use this passkey for the service where it is registered.'**
  String get p_warning_delete_passkey_desc;

  /// No description provided for @l_do_not_remove_yk_delete.
  ///
  /// In en, this message translates to:
  /// **'Do not remove YubiKey during deletion'**
  String get l_do_not_remove_yk_delete;

  /// No description provided for @s_search_passkeys.
  ///
  /// In en, this message translates to:
  /// **'Search passkeys'**
  String get s_search_passkeys;

  /// No description provided for @p_passkeys_used.
  ///
  /// In en, this message translates to:
  /// **'{used} of {max} passkeys used.'**
  String p_passkeys_used(int used, int max);

  /// No description provided for @s_biometrics.
  ///
  /// In en, this message translates to:
  /// **'Biometrics'**
  String get s_biometrics;

  /// No description provided for @l_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'Fingerprint: {label}'**
  String l_fingerprint(String label);

  /// No description provided for @s_fingerprints.
  ///
  /// In en, this message translates to:
  /// **'Fingerprints'**
  String get s_fingerprints;

  /// No description provided for @l_fingerprint_captured.
  ///
  /// In en, this message translates to:
  /// **'Fingerprint captured successfully!'**
  String get l_fingerprint_captured;

  /// No description provided for @s_fingerprint_added.
  ///
  /// In en, this message translates to:
  /// **'Fingerprint added'**
  String get s_fingerprint_added;

  /// No description provided for @l_adding_fingerprint_failed.
  ///
  /// In en, this message translates to:
  /// **'Error adding fingerprint: {message}'**
  String l_adding_fingerprint_failed(String message);

  /// No description provided for @l_setting_name_failed.
  ///
  /// In en, this message translates to:
  /// **'Error setting name: {message}'**
  String l_setting_name_failed(String message);

  /// No description provided for @s_setup_fingerprints.
  ///
  /// In en, this message translates to:
  /// **'Set up fingerprints'**
  String get s_setup_fingerprints;

  /// No description provided for @p_setup_fingerprints_desc.
  ///
  /// In en, this message translates to:
  /// **'Fingerprints need to be set up before the key can be used.'**
  String get p_setup_fingerprints_desc;

  /// No description provided for @s_add_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'Add fingerprint'**
  String get s_add_fingerprint;

  /// No description provided for @s_delete_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'Delete fingerprint'**
  String get s_delete_fingerprint;

  /// No description provided for @q_delete_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'Delete fingerprint?'**
  String get q_delete_fingerprint;

  /// No description provided for @l_delete_fingerprint_desc.
  ///
  /// In en, this message translates to:
  /// **'Remove the fingerprint from the YubiKey'**
  String get l_delete_fingerprint_desc;

  /// No description provided for @s_fingerprint_deleted.
  ///
  /// In en, this message translates to:
  /// **'Fingerprint deleted'**
  String get s_fingerprint_deleted;

  /// No description provided for @p_warning_delete_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'This will delete the fingerprint from your YubiKey.'**
  String get p_warning_delete_fingerprint;

  /// No description provided for @s_fingerprints_get_started.
  ///
  /// In en, this message translates to:
  /// **'Get started with fingerprints'**
  String get s_fingerprints_get_started;

  /// No description provided for @p_set_fingerprints_desc.
  ///
  /// In en, this message translates to:
  /// **'Before it\'s possible to register fingerprints, a PIN needs to be set.'**
  String get p_set_fingerprints_desc;

  /// No description provided for @l_no_fps_added.
  ///
  /// In en, this message translates to:
  /// **'No fingerprints have been added'**
  String get l_no_fps_added;

  /// No description provided for @s_rename_fp.
  ///
  /// In en, this message translates to:
  /// **'Rename fingerprint'**
  String get s_rename_fp;

  /// No description provided for @l_rename_fp_desc.
  ///
  /// In en, this message translates to:
  /// **'Change the name'**
  String get l_rename_fp_desc;

  /// No description provided for @s_fingerprint_renamed.
  ///
  /// In en, this message translates to:
  /// **'Fingerprint renamed'**
  String get s_fingerprint_renamed;

  /// No description provided for @l_rename_fp_failed.
  ///
  /// In en, this message translates to:
  /// **'Error renaming: {message}'**
  String l_rename_fp_failed(String message);

  /// No description provided for @l_add_one_or_more_fps.
  ///
  /// In en, this message translates to:
  /// **'Add one or more (up to five) fingerprints'**
  String get l_add_one_or_more_fps;

  /// No description provided for @l_fingerprints_used.
  ///
  /// In en, this message translates to:
  /// **'{used}/5 fingerprints registered'**
  String l_fingerprints_used(int used);

  /// No description provided for @p_press_fingerprint_begin.
  ///
  /// In en, this message translates to:
  /// **'Press your finger against the YubiKey to begin.'**
  String get p_press_fingerprint_begin;

  /// No description provided for @l_name_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'Name this fingerprint'**
  String get l_name_fingerprint;

  /// No description provided for @l_user_action_timeout_error.
  ///
  /// In en, this message translates to:
  /// **'Failed due to user inactivity'**
  String get l_user_action_timeout_error;

  /// No description provided for @l_wrong_inserted_yk_error.
  ///
  /// In en, this message translates to:
  /// **'Re-inserted YubiKey does not match initial device'**
  String get l_wrong_inserted_yk_error;

  /// No description provided for @l_failed_connecting_to_fido.
  ///
  /// In en, this message translates to:
  /// **'Failed connecting to FIDO interface'**
  String get l_failed_connecting_to_fido;

  /// No description provided for @l_self_signed_certificate.
  ///
  /// In en, this message translates to:
  /// **'Self-signed certificate'**
  String get l_self_signed_certificate;

  /// No description provided for @l_certificate_signing_request.
  ///
  /// In en, this message translates to:
  /// **'Certificate Signing Request (CSR)'**
  String get l_certificate_signing_request;

  /// No description provided for @s_certificate.
  ///
  /// In en, this message translates to:
  /// **'Certificate'**
  String get s_certificate;

  /// No description provided for @s_subject.
  ///
  /// In en, this message translates to:
  /// **'Subject'**
  String get s_subject;

  /// No description provided for @l_export_csr_file.
  ///
  /// In en, this message translates to:
  /// **'Save CSR to file'**
  String get l_export_csr_file;

  /// No description provided for @l_export_public_key.
  ///
  /// In en, this message translates to:
  /// **'Export public key'**
  String get l_export_public_key;

  /// No description provided for @l_export_public_key_file.
  ///
  /// In en, this message translates to:
  /// **'Save public key to file'**
  String get l_export_public_key_file;

  /// No description provided for @l_export_public_key_desc.
  ///
  /// In en, this message translates to:
  /// **'Export the public key to a file'**
  String get l_export_public_key_desc;

  /// No description provided for @l_public_key_exported.
  ///
  /// In en, this message translates to:
  /// **'Public key exported'**
  String get l_public_key_exported;

  /// No description provided for @l_export_certificate.
  ///
  /// In en, this message translates to:
  /// **'Export certificate'**
  String get l_export_certificate;

  /// No description provided for @l_export_certificate_file.
  ///
  /// In en, this message translates to:
  /// **'Export certificate to file'**
  String get l_export_certificate_file;

  /// No description provided for @l_export_certificate_desc.
  ///
  /// In en, this message translates to:
  /// **'Export the certificate to a file'**
  String get l_export_certificate_desc;

  /// No description provided for @l_certificate_exported.
  ///
  /// In en, this message translates to:
  /// **'Certificate exported'**
  String get l_certificate_exported;

  /// No description provided for @l_select_import_file.
  ///
  /// In en, this message translates to:
  /// **'Select file to import'**
  String get l_select_import_file;

  /// No description provided for @l_import_file.
  ///
  /// In en, this message translates to:
  /// **'Import file'**
  String get l_import_file;

  /// No description provided for @l_import_desc.
  ///
  /// In en, this message translates to:
  /// **'Import a key and/or certificate'**
  String get l_import_desc;

  /// No description provided for @l_import_nothing.
  ///
  /// In en, this message translates to:
  /// **'Nothing to import'**
  String get l_import_nothing;

  /// No description provided for @l_importing_file.
  ///
  /// In en, this message translates to:
  /// **'Importing file…'**
  String get l_importing_file;

  /// No description provided for @s_file_imported.
  ///
  /// In en, this message translates to:
  /// **'File imported'**
  String get s_file_imported;

  /// No description provided for @l_unsupported_key_type.
  ///
  /// In en, this message translates to:
  /// **'Unsupported key type'**
  String get l_unsupported_key_type;

  /// No description provided for @l_delete_certificate.
  ///
  /// In en, this message translates to:
  /// **'Delete certificate'**
  String get l_delete_certificate;

  /// No description provided for @q_delete_certificate.
  ///
  /// In en, this message translates to:
  /// **'Delete certificate?'**
  String get q_delete_certificate;

  /// No description provided for @l_delete_certificate_desc.
  ///
  /// In en, this message translates to:
  /// **'Remove the certificate from your YubiKey'**
  String get l_delete_certificate_desc;

  /// No description provided for @l_delete_key.
  ///
  /// In en, this message translates to:
  /// **'Delete key'**
  String get l_delete_key;

  /// No description provided for @q_delete_key.
  ///
  /// In en, this message translates to:
  /// **'Delete key?'**
  String get q_delete_key;

  /// No description provided for @l_delete_key_desc.
  ///
  /// In en, this message translates to:
  /// **'Remove the key from your YubiKey'**
  String get l_delete_key_desc;

  /// No description provided for @l_delete_certificate_or_key.
  ///
  /// In en, this message translates to:
  /// **'Delete certificate/key'**
  String get l_delete_certificate_or_key;

  /// No description provided for @q_delete_certificate_or_key.
  ///
  /// In en, this message translates to:
  /// **'Delete certificate/key?'**
  String get q_delete_certificate_or_key;

  /// No description provided for @l_delete_certificate_or_key_desc.
  ///
  /// In en, this message translates to:
  /// **'Remove the certificate or key from your YubiKey'**
  String get l_delete_certificate_or_key_desc;

  /// No description provided for @l_move_key.
  ///
  /// In en, this message translates to:
  /// **'Move key'**
  String get l_move_key;

  /// No description provided for @l_move_key_desc.
  ///
  /// In en, this message translates to:
  /// **'Move a key from one PIV slot into another'**
  String get l_move_key_desc;

  /// No description provided for @l_change_defaults.
  ///
  /// In en, this message translates to:
  /// **'Change default access codes'**
  String get l_change_defaults;

  /// No description provided for @s_issuer.
  ///
  /// In en, this message translates to:
  /// **'Issuer'**
  String get s_issuer;

  /// No description provided for @s_serial.
  ///
  /// In en, this message translates to:
  /// **'Serial'**
  String get s_serial;

  /// No description provided for @s_certificate_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'Fingerprint'**
  String get s_certificate_fingerprint;

  /// No description provided for @s_valid_from.
  ///
  /// In en, this message translates to:
  /// **'Valid from'**
  String get s_valid_from;

  /// No description provided for @s_valid_to.
  ///
  /// In en, this message translates to:
  /// **'Valid to'**
  String get s_valid_to;

  /// No description provided for @l_no_certificate.
  ///
  /// In en, this message translates to:
  /// **'No certificate loaded'**
  String get l_no_certificate;

  /// No description provided for @l_key_no_certificate.
  ///
  /// In en, this message translates to:
  /// **'Key without certificate loaded'**
  String get l_key_no_certificate;

  /// No description provided for @s_generate_key.
  ///
  /// In en, this message translates to:
  /// **'Generate key'**
  String get s_generate_key;

  /// No description provided for @l_generate_desc.
  ///
  /// In en, this message translates to:
  /// **'Generate a new certificate or CSR'**
  String get l_generate_desc;

  /// No description provided for @p_generate_desc.
  ///
  /// In en, this message translates to:
  /// **'This will generate a new key on the YubiKey in PIV slot {slot}.'**
  String p_generate_desc(String slot);

  /// No description provided for @s_private_key_generated.
  ///
  /// In en, this message translates to:
  /// **'Private key generated'**
  String get s_private_key_generated;

  /// No description provided for @p_select_what_to_delete.
  ///
  /// In en, this message translates to:
  /// **'Select what to delete from the slot.'**
  String get p_select_what_to_delete;

  /// No description provided for @p_warning_delete_certificate.
  ///
  /// In en, this message translates to:
  /// **'Warning! This action will delete the certificate from your YubiKey.'**
  String get p_warning_delete_certificate;

  /// No description provided for @p_warning_delete_key.
  ///
  /// In en, this message translates to:
  /// **'Warning! This action will delete the private key from your YubiKey.'**
  String get p_warning_delete_key;

  /// No description provided for @p_warning_delete_certificate_and_key.
  ///
  /// In en, this message translates to:
  /// **'Warning! This action will delete the certificate and private key from your YubiKey.'**
  String get p_warning_delete_certificate_and_key;

  /// No description provided for @p_warning_usb_preferred.
  ///
  /// In en, this message translates to:
  /// **'Prefer USB for RSA keys. NFC may result in errors.'**
  String get p_warning_usb_preferred;

  /// No description provided for @p_delete_certificate_desc.
  ///
  /// In en, this message translates to:
  /// **'This will delete the certificate in PIV slot {slot}.'**
  String p_delete_certificate_desc(String slot);

  /// No description provided for @p_delete_key_desc.
  ///
  /// In en, this message translates to:
  /// **'This will delete the private key in PIV slot {slot}.'**
  String p_delete_key_desc(String slot);

  /// No description provided for @p_delete_certificate_and_key_desc.
  ///
  /// In en, this message translates to:
  /// **'This will delete the certificate and private key in PIV slot {slot}.'**
  String p_delete_certificate_and_key_desc(String slot);

  /// No description provided for @l_certificate_deleted.
  ///
  /// In en, this message translates to:
  /// **'Certificate deleted'**
  String get l_certificate_deleted;

  /// No description provided for @l_key_deleted.
  ///
  /// In en, this message translates to:
  /// **'Key deleted'**
  String get l_key_deleted;

  /// No description provided for @l_certificate_and_key_deleted.
  ///
  /// In en, this message translates to:
  /// **'Certificate and key deleted'**
  String get l_certificate_and_key_deleted;

  /// No description provided for @l_include_certificate.
  ///
  /// In en, this message translates to:
  /// **'Include certificate'**
  String get l_include_certificate;

  /// No description provided for @l_select_destination_slot.
  ///
  /// In en, this message translates to:
  /// **'Select destination slot'**
  String get l_select_destination_slot;

  /// No description provided for @q_move_key_confirm.
  ///
  /// In en, this message translates to:
  /// **'Move the private key in PIV slot {from_slot}?'**
  String q_move_key_confirm(String from_slot);

  /// No description provided for @q_move_key_to_slot_confirm.
  ///
  /// In en, this message translates to:
  /// **'Move the private key in PIV slot {from_slot} to slot {to_slot}?'**
  String q_move_key_to_slot_confirm(String from_slot, String to_slot);

  /// No description provided for @q_move_key_and_certificate_to_slot_confirm.
  ///
  /// In en, this message translates to:
  /// **'Move the private key and certificate in PIV slot {from_slot} to slot {to_slot}?'**
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  );

  /// No description provided for @p_password_protected_file.
  ///
  /// In en, this message translates to:
  /// **'The selected file is password protected.'**
  String get p_password_protected_file;

  /// No description provided for @p_import_items_desc.
  ///
  /// In en, this message translates to:
  /// **'The following item(s) will be imported into PIV slot {slot}.'**
  String p_import_items_desc(String slot);

  /// No description provided for @l_warning_public_key_mismatch.
  ///
  /// In en, this message translates to:
  /// **'The public key of the certificate does not match the private key in the slot'**
  String get l_warning_public_key_mismatch;

  /// No description provided for @l_key_moved.
  ///
  /// In en, this message translates to:
  /// **'Key moved'**
  String get l_key_moved;

  /// No description provided for @l_key_and_certificate_moved.
  ///
  /// In en, this message translates to:
  /// **'Key and certificate moved'**
  String get l_key_and_certificate_moved;

  /// No description provided for @p_subject_desc.
  ///
  /// In en, this message translates to:
  /// **'A distinguished name (DN) formatted in accordance to the RFC 4514 specification.'**
  String get p_subject_desc;

  /// No description provided for @l_rfc4514_invalid.
  ///
  /// In en, this message translates to:
  /// **'Invalid RFC 4514 format'**
  String get l_rfc4514_invalid;

  /// No description provided for @rfc4514_examples.
  ///
  /// In en, this message translates to:
  /// **'Examples:\nCN=Example Name\nCN=jsmith,DC=example,DC=net'**
  String get rfc4514_examples;

  /// No description provided for @s_allow_fingerprint.
  ///
  /// In en, this message translates to:
  /// **'Allow fingerprint'**
  String get s_allow_fingerprint;

  /// No description provided for @s_pin_policy.
  ///
  /// In en, this message translates to:
  /// **'PIN policy'**
  String get s_pin_policy;

  /// No description provided for @s_output_format.
  ///
  /// In en, this message translates to:
  /// **'Output format'**
  String get s_output_format;

  /// No description provided for @s_expiration_date.
  ///
  /// In en, this message translates to:
  /// **'Expiration date'**
  String get s_expiration_date;

  /// No description provided for @p_algorithm_desc.
  ///
  /// In en, this message translates to:
  /// **'Key algorithm to use.'**
  String get p_algorithm_desc;

  /// No description provided for @p_expiration_date_desc.
  ///
  /// In en, this message translates to:
  /// **'Date when the certificate expires, default 1 year (certificate only).'**
  String get p_expiration_date_desc;

  /// No description provided for @p_key_options_bio_desc.
  ///
  /// In en, this message translates to:
  /// **'Allow biometrics to be used instead of PIN.'**
  String get p_key_options_bio_desc;

  /// No description provided for @q_overwrite_slot.
  ///
  /// In en, this message translates to:
  /// **'Overwrite slot?'**
  String get q_overwrite_slot;

  /// No description provided for @p_overwrite_slot_desc.
  ///
  /// In en, this message translates to:
  /// **'This will permanently overwrite existing content in slot {slot}.'**
  String p_overwrite_slot_desc(String slot);

  /// No description provided for @l_overwrite_cert.
  ///
  /// In en, this message translates to:
  /// **'The certificate will be overwritten'**
  String get l_overwrite_cert;

  /// No description provided for @l_overwrite_key.
  ///
  /// In en, this message translates to:
  /// **'The private key will be overwritten'**
  String get l_overwrite_key;

  /// No description provided for @l_overwrite_key_maybe.
  ///
  /// In en, this message translates to:
  /// **'Any existing private key in the slot will be overwritten'**
  String get l_overwrite_key_maybe;

  /// No description provided for @s_slot_display_name.
  ///
  /// In en, this message translates to:
  /// **'{name} ({hexid})'**
  String s_slot_display_name(String name, String hexid);

  /// No description provided for @s_slot_9a.
  ///
  /// In en, this message translates to:
  /// **'Authentication'**
  String get s_slot_9a;

  /// No description provided for @s_slot_9c.
  ///
  /// In en, this message translates to:
  /// **'Digital Signature'**
  String get s_slot_9c;

  /// No description provided for @s_slot_9d.
  ///
  /// In en, this message translates to:
  /// **'Key Management'**
  String get s_slot_9d;

  /// No description provided for @s_slot_9e.
  ///
  /// In en, this message translates to:
  /// **'Card Authentication'**
  String get s_slot_9e;

  /// No description provided for @s_retired_slot.
  ///
  /// In en, this message translates to:
  /// **'Retired Key Management'**
  String get s_retired_slot;

  /// No description provided for @s_otp_slot_one.
  ///
  /// In en, this message translates to:
  /// **'Short touch'**
  String get s_otp_slot_one;

  /// No description provided for @s_otp_slot_two.
  ///
  /// In en, this message translates to:
  /// **'Long touch'**
  String get s_otp_slot_two;

  /// No description provided for @l_otp_slot_empty.
  ///
  /// In en, this message translates to:
  /// **'Slot is empty'**
  String get l_otp_slot_empty;

  /// No description provided for @l_otp_slot_configured.
  ///
  /// In en, this message translates to:
  /// **'Slot is configured'**
  String get l_otp_slot_configured;

  /// No description provided for @l_yubiotp_desc.
  ///
  /// In en, this message translates to:
  /// **'Program a Yubico OTP credential'**
  String get l_yubiotp_desc;

  /// No description provided for @s_challenge_response.
  ///
  /// In en, this message translates to:
  /// **'Challenge-response'**
  String get s_challenge_response;

  /// No description provided for @l_challenge_response_desc.
  ///
  /// In en, this message translates to:
  /// **'Program a challenge-response credential'**
  String get l_challenge_response_desc;

  /// No description provided for @s_static_password.
  ///
  /// In en, this message translates to:
  /// **'Static password'**
  String get s_static_password;

  /// No description provided for @l_static_password_desc.
  ///
  /// In en, this message translates to:
  /// **'Configure a static password'**
  String get l_static_password_desc;

  /// No description provided for @s_hotp.
  ///
  /// In en, this message translates to:
  /// **'OATH-HOTP'**
  String get s_hotp;

  /// No description provided for @l_hotp_desc.
  ///
  /// In en, this message translates to:
  /// **'Program a HMAC-SHA1 based credential'**
  String get l_hotp_desc;

  /// No description provided for @s_public_id.
  ///
  /// In en, this message translates to:
  /// **'Public ID'**
  String get s_public_id;

  /// No description provided for @s_private_id.
  ///
  /// In en, this message translates to:
  /// **'Private ID'**
  String get s_private_id;

  /// No description provided for @s_use_serial.
  ///
  /// In en, this message translates to:
  /// **'Use serial'**
  String get s_use_serial;

  /// No description provided for @l_select_file.
  ///
  /// In en, this message translates to:
  /// **'Select file'**
  String get l_select_file;

  /// No description provided for @l_no_export_file.
  ///
  /// In en, this message translates to:
  /// **'No export file'**
  String get l_no_export_file;

  /// No description provided for @s_no_export.
  ///
  /// In en, this message translates to:
  /// **'No export'**
  String get s_no_export;

  /// No description provided for @s_export.
  ///
  /// In en, this message translates to:
  /// **'Export'**
  String get s_export;

  /// No description provided for @l_export_configuration_file.
  ///
  /// In en, this message translates to:
  /// **'Export configuration to file'**
  String get l_export_configuration_file;

  /// No description provided for @l_exported_can_be_uploaded_at.
  ///
  /// In en, this message translates to:
  /// **'Exported credentials can be uploaded at {url}'**
  String l_exported_can_be_uploaded_at(String url);

  /// No description provided for @l_keyboard_layout.
  ///
  /// In en, this message translates to:
  /// **'Keyboard {layout}'**
  String l_keyboard_layout(Object layout);

  /// No description provided for @s_delete_slot.
  ///
  /// In en, this message translates to:
  /// **'Delete credential'**
  String get s_delete_slot;

  /// No description provided for @q_delete_slot.
  ///
  /// In en, this message translates to:
  /// **'Delete credential?'**
  String get q_delete_slot;

  /// No description provided for @l_delete_slot_desc.
  ///
  /// In en, this message translates to:
  /// **'Remove credential in slot'**
  String get l_delete_slot_desc;

  /// No description provided for @p_warning_delete_slot_configuration.
  ///
  /// In en, this message translates to:
  /// **'Warning! This action will permanently remove the credential from slot {slot_id}.'**
  String p_warning_delete_slot_configuration(int slot_id);

  /// No description provided for @l_slot_deleted.
  ///
  /// In en, this message translates to:
  /// **'Credential deleted'**
  String get l_slot_deleted;

  /// No description provided for @s_swap.
  ///
  /// In en, this message translates to:
  /// **'Swap'**
  String get s_swap;

  /// No description provided for @s_swap_slots.
  ///
  /// In en, this message translates to:
  /// **'Swap slots'**
  String get s_swap_slots;

  /// No description provided for @q_swap_slots.
  ///
  /// In en, this message translates to:
  /// **'Swap slots?'**
  String get q_swap_slots;

  /// No description provided for @l_swap_slots_desc.
  ///
  /// In en, this message translates to:
  /// **'Swap short/long touch'**
  String get l_swap_slots_desc;

  /// No description provided for @p_swap_slots_desc.
  ///
  /// In en, this message translates to:
  /// **'This will swap the configuration of the two slots.'**
  String get p_swap_slots_desc;

  /// No description provided for @l_slots_swapped.
  ///
  /// In en, this message translates to:
  /// **'Slot configurations swapped'**
  String get l_slots_swapped;

  /// No description provided for @l_slot_credential_configured.
  ///
  /// In en, this message translates to:
  /// **'Configured {type} credential'**
  String l_slot_credential_configured(String type);

  /// No description provided for @l_slot_credential_configured_and_exported.
  ///
  /// In en, this message translates to:
  /// **'Configured {type} credential and exported to {file}'**
  String l_slot_credential_configured_and_exported(String type, String file);

  /// No description provided for @s_append_enter.
  ///
  /// In en, this message translates to:
  /// **'Append ⏎'**
  String get s_append_enter;

  /// No description provided for @l_append_enter_desc.
  ///
  /// In en, this message translates to:
  /// **'Append an Enter keystroke after emitting the OTP'**
  String get l_append_enter_desc;

  /// No description provided for @p_otp_swap_error.
  ///
  /// In en, this message translates to:
  /// **'Failed to swap slots! Make sure the YubiKey does not have restrictive access.'**
  String get p_otp_swap_error;

  /// No description provided for @l_wrong_access_code.
  ///
  /// In en, this message translates to:
  /// **'Wrong access code'**
  String get l_wrong_access_code;

  /// No description provided for @s_access_code.
  ///
  /// In en, this message translates to:
  /// **'Access code'**
  String get s_access_code;

  /// No description provided for @s_show_access_code.
  ///
  /// In en, this message translates to:
  /// **'Show access code'**
  String get s_show_access_code;

  /// No description provided for @s_hide_access_code.
  ///
  /// In en, this message translates to:
  /// **'Hide access code'**
  String get s_hide_access_code;

  /// No description provided for @p_enter_access_code.
  ///
  /// In en, this message translates to:
  /// **'Enter access code for slot {slot}.'**
  String p_enter_access_code(String slot);

  /// No description provided for @s_enable_nfc.
  ///
  /// In en, this message translates to:
  /// **'Enable NFC'**
  String get s_enable_nfc;

  /// No description provided for @s_request_access.
  ///
  /// In en, this message translates to:
  /// **'Request access'**
  String get s_request_access;

  /// No description provided for @s_permission_denied.
  ///
  /// In en, this message translates to:
  /// **'Permission denied'**
  String get s_permission_denied;

  /// No description provided for @l_elevating_permissions.
  ///
  /// In en, this message translates to:
  /// **'Elevating permissions…'**
  String get l_elevating_permissions;

  /// No description provided for @s_review_permissions.
  ///
  /// In en, this message translates to:
  /// **'Review permissions'**
  String get s_review_permissions;

  /// No description provided for @s_open_windows_settings.
  ///
  /// In en, this message translates to:
  /// **'Open Windows settings'**
  String get s_open_windows_settings;

  /// No description provided for @l_admin_privileges_required.
  ///
  /// In en, this message translates to:
  /// **'Administrator privileges required'**
  String get l_admin_privileges_required;

  /// No description provided for @p_elevated_permissions_required.
  ///
  /// In en, this message translates to:
  /// **'Managing this device requires elevated privileges. Alternatively, you can use Windows Settings to manage FIDO configuration.'**
  String get p_elevated_permissions_required;

  /// No description provided for @p_webauthn_elevated_permissions_required.
  ///
  /// In en, this message translates to:
  /// **'WebAuthn management requires elevated privileges. Alternatively, you can use Windows Settings to manage FIDO configuration.'**
  String get p_webauthn_elevated_permissions_required;

  /// No description provided for @p_ms_store_permission_note.
  ///
  /// In en, this message translates to:
  /// **'The Microsoft Store version of the app is generally unable to elevate permissions due to sandboxing limitations of Windows. We recommend installing Yubico Authenticator from our official .msi installer.'**
  String get p_ms_store_permission_note;

  /// No description provided for @p_need_camera_permission.
  ///
  /// In en, this message translates to:
  /// **'Yubico Authenticator needs Camera permissions for scanning QR codes.'**
  String get p_need_camera_permission;

  /// No description provided for @s_qr_scan.
  ///
  /// In en, this message translates to:
  /// **'Scan QR code'**
  String get s_qr_scan;

  /// No description provided for @l_invalid_qr.
  ///
  /// In en, this message translates to:
  /// **'Invalid QR code'**
  String get l_invalid_qr;

  /// No description provided for @l_qr_not_found.
  ///
  /// In en, this message translates to:
  /// **'No QR code found'**
  String get l_qr_not_found;

  /// No description provided for @l_qr_scanned.
  ///
  /// In en, this message translates to:
  /// **'Scanned QR code'**
  String get l_qr_scanned;

  /// No description provided for @l_qr_file_too_large.
  ///
  /// In en, this message translates to:
  /// **'File too large (max {max})'**
  String l_qr_file_too_large(String max);

  /// No description provided for @l_qr_invalid_image_file.
  ///
  /// In en, this message translates to:
  /// **'Invalid image file'**
  String get l_qr_invalid_image_file;

  /// No description provided for @l_qr_select_file.
  ///
  /// In en, this message translates to:
  /// **'Select file with QR code'**
  String get l_qr_select_file;

  /// No description provided for @l_qr_not_read.
  ///
  /// In en, this message translates to:
  /// **'Failed reading QR code: {message}'**
  String l_qr_not_read(String message);

  /// No description provided for @l_point_camera_scan.
  ///
  /// In en, this message translates to:
  /// **'Point your camera at a QR code to scan it'**
  String get l_point_camera_scan;

  /// No description provided for @q_want_to_scan.
  ///
  /// In en, this message translates to:
  /// **'Would like to scan?'**
  String get q_want_to_scan;

  /// No description provided for @q_no_qr.
  ///
  /// In en, this message translates to:
  /// **'No QR code?'**
  String get q_no_qr;

  /// No description provided for @s_enter_manually.
  ///
  /// In en, this message translates to:
  /// **'Enter manually'**
  String get s_enter_manually;

  /// No description provided for @s_read_from_file.
  ///
  /// In en, this message translates to:
  /// **'Read from file'**
  String get s_read_from_file;

  /// No description provided for @s_reset.
  ///
  /// In en, this message translates to:
  /// **'Reset'**
  String get s_reset;

  /// No description provided for @s_factory_reset.
  ///
  /// In en, this message translates to:
  /// **'Factory reset'**
  String get s_factory_reset;

  /// No description provided for @l_factory_reset_desc.
  ///
  /// In en, this message translates to:
  /// **'Restore YubiKey defaults'**
  String get l_factory_reset_desc;

  /// No description provided for @l_factory_reset_required.
  ///
  /// In en, this message translates to:
  /// **'Factory reset required'**
  String get l_factory_reset_required;

  /// No description provided for @l_oath_application_reset.
  ///
  /// In en, this message translates to:
  /// **'OATH application reset'**
  String get l_oath_application_reset;

  /// No description provided for @l_fido_app_reset.
  ///
  /// In en, this message translates to:
  /// **'FIDO application reset'**
  String get l_fido_app_reset;

  /// No description provided for @l_reset_failed.
  ///
  /// In en, this message translates to:
  /// **'Error performing reset: {message}'**
  String l_reset_failed(String message);

  /// No description provided for @l_piv_app_reset.
  ///
  /// In en, this message translates to:
  /// **'PIV application reset'**
  String get l_piv_app_reset;

  /// No description provided for @p_factory_reset_an_app.
  ///
  /// In en, this message translates to:
  /// **'Factory reset an application on your YubiKey.'**
  String get p_factory_reset_an_app;

  /// No description provided for @p_factory_reset_desc.
  ///
  /// In en, this message translates to:
  /// **'Data is stored in multiple applications on the YubiKey, some of which can be factory reset independently of each other.\n\nSelect an application above to reset.'**
  String get p_factory_reset_desc;

  /// No description provided for @p_warning_factory_reset.
  ///
  /// In en, this message translates to:
  /// **'Warning! This will irrevocably delete all OATH TOTP/HOTP accounts from your YubiKey.'**
  String get p_warning_factory_reset;

  /// No description provided for @p_warning_disable_credentials.
  ///
  /// In en, this message translates to:
  /// **'Your OATH credentials, as well as any password set, will be removed from this YubiKey. Make sure to disable these from their respective web sites to avoid being locked out of your accounts.'**
  String get p_warning_disable_credentials;

  /// No description provided for @p_warning_deletes_accounts.
  ///
  /// In en, this message translates to:
  /// **'Warning! This will irrevocably delete all U2F and FIDO2 accounts, including passkeys, from your YubiKey.'**
  String get p_warning_deletes_accounts;

  /// No description provided for @p_warning_disable_accounts.
  ///
  /// In en, this message translates to:
  /// **'Your credentials, as well as any PIN set, will be removed from this YubiKey. Make sure to disable these from their respective web sites to avoid being locked out of your accounts.'**
  String get p_warning_disable_accounts;

  /// No description provided for @l_reset_not_allowed_over.
  ///
  /// In en, this message translates to:
  /// **'FIDO reset is disabled over {transport}'**
  String l_reset_not_allowed_over(String transport);

  /// No description provided for @p_warning_piv_reset.
  ///
  /// In en, this message translates to:
  /// **'Warning! All data stored for PIV will be irrevocably deleted from your YubiKey.'**
  String get p_warning_piv_reset;

  /// No description provided for @p_warning_piv_reset_desc.
  ///
  /// In en, this message translates to:
  /// **'This includes private keys and certificates. Your PIN, PUK, and management key will be reset to their factory default values.'**
  String get p_warning_piv_reset_desc;

  /// No description provided for @p_warning_global_reset.
  ///
  /// In en, this message translates to:
  /// **'Warning! This will irrevocably delete all saved data, including credentials, from your YubiKey.'**
  String get p_warning_global_reset;

  /// No description provided for @p_warning_global_reset_desc.
  ///
  /// In en, this message translates to:
  /// **'Factory reset the applications on your YubiKey. PIN will be reset to its factory default value, and registered fingerprints will be removed. Any keys, certificates, or other credentials will all be permanently removed.'**
  String get p_warning_global_reset_desc;

  /// No description provided for @l_copy_to_clipboard.
  ///
  /// In en, this message translates to:
  /// **'Copy to clipboard'**
  String get l_copy_to_clipboard;

  /// No description provided for @s_code_copied.
  ///
  /// In en, this message translates to:
  /// **'Code copied'**
  String get s_code_copied;

  /// No description provided for @l_code_copied_clipboard.
  ///
  /// In en, this message translates to:
  /// **'Code copied to clipboard'**
  String get l_code_copied_clipboard;

  /// No description provided for @s_copy_log.
  ///
  /// In en, this message translates to:
  /// **'Copy log'**
  String get s_copy_log;

  /// No description provided for @l_copy_log_clipboard.
  ///
  /// In en, this message translates to:
  /// **'Copy log to clipboard'**
  String get l_copy_log_clipboard;

  /// No description provided for @l_log_copied.
  ///
  /// In en, this message translates to:
  /// **'Log copied to clipboard'**
  String get l_log_copied;

  /// No description provided for @l_diagnostics_copied.
  ///
  /// In en, this message translates to:
  /// **'Diagnostic data copied to clipboard'**
  String get l_diagnostics_copied;

  /// No description provided for @p_target_copied_clipboard.
  ///
  /// In en, this message translates to:
  /// **'{label} copied to clipboard.'**
  String p_target_copied_clipboard(String label);

  /// No description provided for @s_custom_icons.
  ///
  /// In en, this message translates to:
  /// **'Custom icons'**
  String get s_custom_icons;

  /// No description provided for @l_set_icons_for_accounts.
  ///
  /// In en, this message translates to:
  /// **'Set icons for accounts'**
  String get l_set_icons_for_accounts;

  /// No description provided for @p_custom_icons_description.
  ///
  /// In en, this message translates to:
  /// **'Icon packs can make your accounts more easily distinguishable with familiar logos and colors.'**
  String get p_custom_icons_description;

  /// No description provided for @p_custom_icons_format_desc.
  ///
  /// In en, this message translates to:
  /// **'Icon packs use the {aegis_icon_pack} format. You can download a pre-made icon pack, or you can create your own.'**
  String p_custom_icons_format_desc(String aegis_icon_pack);

  /// No description provided for @s_replace_icon_pack.
  ///
  /// In en, this message translates to:
  /// **'Replace icon pack'**
  String get s_replace_icon_pack;

  /// No description provided for @l_loading_icon_pack.
  ///
  /// In en, this message translates to:
  /// **'Loading icon pack…'**
  String get l_loading_icon_pack;

  /// No description provided for @s_load_icon_pack.
  ///
  /// In en, this message translates to:
  /// **'Load icon pack'**
  String get s_load_icon_pack;

  /// No description provided for @l_load_icon_pack_desc.
  ///
  /// In en, this message translates to:
  /// **'Load icon pack from file'**
  String get l_load_icon_pack_desc;

  /// No description provided for @s_remove_icon_pack.
  ///
  /// In en, this message translates to:
  /// **'Remove icon pack'**
  String get s_remove_icon_pack;

  /// No description provided for @l_remove_icon_pack_desc.
  ///
  /// In en, this message translates to:
  /// **'Delete the active icon pack'**
  String get l_remove_icon_pack_desc;

  /// No description provided for @l_icon_pack_removed.
  ///
  /// In en, this message translates to:
  /// **'Icon pack removed'**
  String get l_icon_pack_removed;

  /// No description provided for @l_remove_icon_pack_failed.
  ///
  /// In en, this message translates to:
  /// **'Error removing icon pack'**
  String get l_remove_icon_pack_failed;

  /// No description provided for @s_choose_icon_pack.
  ///
  /// In en, this message translates to:
  /// **'Choose icon pack'**
  String get s_choose_icon_pack;

  /// No description provided for @l_icon_pack_imported.
  ///
  /// In en, this message translates to:
  /// **'Icon pack imported'**
  String get l_icon_pack_imported;

  /// No description provided for @l_import_icon_pack_failed.
  ///
  /// In en, this message translates to:
  /// **'Error importing icon pack: {message}'**
  String l_import_icon_pack_failed(String message);

  /// No description provided for @l_invalid_icon_pack.
  ///
  /// In en, this message translates to:
  /// **'Invalid icon pack'**
  String get l_invalid_icon_pack;

  /// No description provided for @l_icon_pack_copy_failed.
  ///
  /// In en, this message translates to:
  /// **'Failed to copy icon pack files'**
  String get l_icon_pack_copy_failed;

  /// No description provided for @s_nfc_and_usb_options.
  ///
  /// In en, this message translates to:
  /// **'NFC & USB options'**
  String get s_nfc_and_usb_options;

  /// No description provided for @l_nfc_and_usb_options_desc.
  ///
  /// In en, this message translates to:
  /// **'Configure action for YubiKey'**
  String get l_nfc_and_usb_options_desc;

  /// No description provided for @l_on_yk_nfc_tap.
  ///
  /// In en, this message translates to:
  /// **'On NFC tap'**
  String get l_on_yk_nfc_tap;

  /// No description provided for @l_on_yk_usb_insert.
  ///
  /// In en, this message translates to:
  /// **'On USB insert'**
  String get l_on_yk_usb_insert;

  /// No description provided for @l_do_nothing.
  ///
  /// In en, this message translates to:
  /// **'Do nothing'**
  String get l_do_nothing;

  /// No description provided for @l_launch_ya.
  ///
  /// In en, this message translates to:
  /// **'Launch Yubico Authenticator'**
  String get l_launch_ya;

  /// No description provided for @l_copy_otp_clipboard.
  ///
  /// In en, this message translates to:
  /// **'Copy OTP to clipboard'**
  String get l_copy_otp_clipboard;

  /// No description provided for @l_launch_and_copy_otp.
  ///
  /// In en, this message translates to:
  /// **'Launch app and copy OTP'**
  String get l_launch_and_copy_otp;

  /// No description provided for @l_kbd_layout_for_static.
  ///
  /// In en, this message translates to:
  /// **'Keyboard layout (for static password)'**
  String get l_kbd_layout_for_static;

  /// No description provided for @s_choose_kbd_layout.
  ///
  /// In en, this message translates to:
  /// **'Choose keyboard layout'**
  String get s_choose_kbd_layout;

  /// No description provided for @l_bypass_touch_requirement.
  ///
  /// In en, this message translates to:
  /// **'Bypass touch requirement'**
  String get l_bypass_touch_requirement;

  /// No description provided for @l_bypass_touch_requirement_on.
  ///
  /// In en, this message translates to:
  /// **'Accounts that require touch are automatically shown over NFC'**
  String get l_bypass_touch_requirement_on;

  /// No description provided for @l_bypass_touch_requirement_off.
  ///
  /// In en, this message translates to:
  /// **'Accounts that require touch need an additional tap over NFC'**
  String get l_bypass_touch_requirement_off;

  /// No description provided for @s_silence_nfc_sounds.
  ///
  /// In en, this message translates to:
  /// **'Silence NFC sounds'**
  String get s_silence_nfc_sounds;

  /// No description provided for @l_silence_nfc_sounds_on.
  ///
  /// In en, this message translates to:
  /// **'No sounds will be played on NFC tap'**
  String get l_silence_nfc_sounds_on;

  /// No description provided for @l_silence_nfc_sounds_off.
  ///
  /// In en, this message translates to:
  /// **'Sound will play on NFC tap'**
  String get l_silence_nfc_sounds_off;

  /// No description provided for @l_launch_app_on_usb_on.
  ///
  /// In en, this message translates to:
  /// **'This prevents other apps from using the YubiKey over USB'**
  String get l_launch_app_on_usb_on;

  /// No description provided for @l_launch_app_on_usb_off.
  ///
  /// In en, this message translates to:
  /// **'Other apps can use the YubiKey over USB'**
  String get l_launch_app_on_usb_off;

  /// No description provided for @s_allow_screenshots.
  ///
  /// In en, this message translates to:
  /// **'Allow screenshots'**
  String get s_allow_screenshots;

  /// No description provided for @l_allow_screenshots_desc.
  ///
  /// In en, this message translates to:
  /// **'Allow other apps to take screenshots'**
  String get l_allow_screenshots_desc;

  /// No description provided for @s_nfc_ready_to_scan.
  ///
  /// In en, this message translates to:
  /// **'Ready to scan'**
  String get s_nfc_ready_to_scan;

  /// No description provided for @s_nfc_hold_still.
  ///
  /// In en, this message translates to:
  /// **'Hold still…'**
  String get s_nfc_hold_still;

  /// No description provided for @s_nfc_tap_your_yubikey.
  ///
  /// In en, this message translates to:
  /// **'Tap your YubiKey'**
  String get s_nfc_tap_your_yubikey;

  /// No description provided for @s_nfc_remove_key.
  ///
  /// In en, this message translates to:
  /// **'Remove YubiKey'**
  String get s_nfc_remove_key;

  /// No description provided for @l_nfc_failed_to_scan.
  ///
  /// In en, this message translates to:
  /// **'Failed to scan, try again'**
  String get l_nfc_failed_to_scan;

  /// No description provided for @s_usb_processing.
  ///
  /// In en, this message translates to:
  /// **'Reading data from YubiKey'**
  String get s_usb_processing;

  /// No description provided for @s_usb_dont_remove.
  ///
  /// In en, this message translates to:
  /// **'Don\'t remove the key…'**
  String get s_usb_dont_remove;

  /// No description provided for @l_usb_read_error.
  ///
  /// In en, this message translates to:
  /// **'Failed to read data from YubiKey'**
  String get l_usb_read_error;

  /// No description provided for @p_ndef_set_otp.
  ///
  /// In en, this message translates to:
  /// **'Successfully copied OTP code from YubiKey to clipboard.'**
  String get p_ndef_set_otp;

  /// No description provided for @p_ndef_set_password.
  ///
  /// In en, this message translates to:
  /// **'Successfully copied password from YubiKey to clipboard.'**
  String get p_ndef_set_password;

  /// No description provided for @p_ndef_parse_failure.
  ///
  /// In en, this message translates to:
  /// **'Failed to parse OTP code from YubiKey.'**
  String get p_ndef_parse_failure;

  /// No description provided for @p_ndef_set_clip_failure.
  ///
  /// In en, this message translates to:
  /// **'Failed to access clipboard when trying to copy OTP code from YubiKey.'**
  String get p_ndef_set_clip_failure;

  /// No description provided for @s_set_label.
  ///
  /// In en, this message translates to:
  /// **'Set label'**
  String get s_set_label;

  /// No description provided for @s_set_color.
  ///
  /// In en, this message translates to:
  /// **'Set color'**
  String get s_set_color;

  /// No description provided for @s_change_label.
  ///
  /// In en, this message translates to:
  /// **'Change label'**
  String get s_change_label;

  /// No description provided for @p_set_will_add_custom_name.
  ///
  /// In en, this message translates to:
  /// **'This will give your YubiKey a custom name.'**
  String get p_set_will_add_custom_name;

  /// No description provided for @p_rename_will_change_custom_name.
  ///
  /// In en, this message translates to:
  /// **'This will change the label of your YubiKey.'**
  String get p_rename_will_change_custom_name;

  /// No description provided for @s_keyboard_shortcuts.
  ///
  /// In en, this message translates to:
  /// **'Keyboard shortcuts'**
  String get s_keyboard_shortcuts;

  /// No description provided for @s_global_shortcuts.
  ///
  /// In en, this message translates to:
  /// **'Global shortcuts'**
  String get s_global_shortcuts;

  /// No description provided for @s_application_shortcuts.
  ///
  /// In en, this message translates to:
  /// **'Application shortcuts'**
  String get s_application_shortcuts;

  /// No description provided for @s_quit_app.
  ///
  /// In en, this message translates to:
  /// **'Quit {app}'**
  String s_quit_app(String app);

  /// No description provided for @s_hide_app.
  ///
  /// In en, this message translates to:
  /// **'Hide {app}'**
  String s_hide_app(String app);

  /// No description provided for @s_search.
  ///
  /// In en, this message translates to:
  /// **'Search'**
  String get s_search;

  /// No description provided for @s_next_device.
  ///
  /// In en, this message translates to:
  /// **'Next device'**
  String get s_next_device;

  /// No description provided for @s_previous_device.
  ///
  /// In en, this message translates to:
  /// **'Previous device'**
  String get s_previous_device;

  /// No description provided for @s_open_settings.
  ///
  /// In en, this message translates to:
  /// **'Open settings'**
  String get s_open_settings;

  /// No description provided for @s_open_item.
  ///
  /// In en, this message translates to:
  /// **'Open item'**
  String get s_open_item;

  /// No description provided for @s_edit_item.
  ///
  /// In en, this message translates to:
  /// **'Edit item'**
  String get s_edit_item;

  /// No description provided for @s_delete_item.
  ///
  /// In en, this message translates to:
  /// **'Delete item'**
  String get s_delete_item;

  /// No description provided for @s_calculate_oath_code.
  ///
  /// In en, this message translates to:
  /// **'Calculate OATH code'**
  String get s_calculate_oath_code;

  /// No description provided for @s_open_keyboard_shortcuts.
  ///
  /// In en, this message translates to:
  /// **'Open keyboard shortcuts'**
  String get s_open_keyboard_shortcuts;
}

class _AppLocalizationsDelegate
    extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>[
    'cs',
    'de',
    'el',
    'en',
    'es',
    'fr',
    'ja',
    'pl',
    'ru',
    'sk',
    'sv',
    'tr',
    'uk',
    'vi',
    'zh',
  ].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {
  // Lookup logic when language+country codes are specified.
  switch (locale.languageCode) {
    case 'zh':
      {
        switch (locale.countryCode) {
          case 'TW':
            return AppLocalizationsZhTw();
        }
        break;
      }
  }

  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'cs':
      return AppLocalizationsCs();
    case 'de':
      return AppLocalizationsDe();
    case 'el':
      return AppLocalizationsEl();
    case 'en':
      return AppLocalizationsEn();
    case 'es':
      return AppLocalizationsEs();
    case 'fr':
      return AppLocalizationsFr();
    case 'ja':
      return AppLocalizationsJa();
    case 'pl':
      return AppLocalizationsPl();
    case 'ru':
      return AppLocalizationsRu();
    case 'sk':
      return AppLocalizationsSk();
    case 'sv':
      return AppLocalizationsSv();
    case 'tr':
      return AppLocalizationsTr();
    case 'uk':
      return AppLocalizationsUk();
    case 'vi':
      return AppLocalizationsVi();
    case 'zh':
      return AppLocalizationsZh();
  }

  throw FlutterError(
    'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.',
  );
}
