// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Vietnamese (`vi`).
class AppLocalizationsVi extends AppLocalizations {
  AppLocalizationsVi([String locale = 'vi']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Tiếng Việt';

  @override
  String s_translated(int percentage) {
    return 'Đã dịch: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Đã hiệu đính: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Incomplete translation';

  @override
  String get p_translation_progress_desc =>
      'Progress indicators reflect the maturity of the translation.';

  @override
  String get s_community => 'Community';

  @override
  String get l_localization_project => 'Localization project';

  @override
  String get s_save => 'Lưu';

  @override
  String get s_cancel => 'Hủy';

  @override
  String get s_close => 'Đóng';

  @override
  String get s_delete => 'Xóa';

  @override
  String get s_move => 'Di chuyển';

  @override
  String get s_quit => 'Thoát';

  @override
  String get s_enable => 'Bật';

  @override
  String get s_enabled => 'Đã bật';

  @override
  String get s_disabled => 'Đã tắt';

  @override
  String get s_status => 'Trạng thái';

  @override
  String get s_unlock => 'Mở khóa';

  @override
  String get s_calculate => 'Tính toán';

  @override
  String get s_import => 'Nhập khẩu';

  @override
  String get s_overwrite => 'Ghi đè';

  @override
  String get s_done => 'Xong';

  @override
  String get s_success => 'Success';

  @override
  String get s_loading => 'Loading…';

  @override
  String get s_more => 'More';

  @override
  String get s_label => 'Nhãn';

  @override
  String get s_name => 'Tên';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Tùy chọn';

  @override
  String get s_details => 'Chi tiết';

  @override
  String get s_show_window => 'Hiển thị cửa sổ';

  @override
  String get s_hide_window => 'Ẩn cửa sổ';

  @override
  String get s_show_navigation => 'Hiển thị điều hướng';

  @override
  String get s_expand_navigation => 'Expand navigation bar';

  @override
  String get s_collapse_navigation => 'Collapse navigation bar';

  @override
  String get s_expand_collapse_navigation => 'Expand/collapse navigation bar';

  @override
  String get s_show_menu => 'Hiển thị thực đơn';

  @override
  String get s_toggle_menu_bar => 'Toggle menu bar';

  @override
  String get s_more_info => 'More info';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<không có>';

  @override
  String get s_about => 'Giới thiệu';

  @override
  String get s_algorithm => 'Thuật toán';

  @override
  String get s_appearance => 'Giao diện';

  @override
  String get s_actions => 'Hành động';

  @override
  String get s_manage => 'Quản lý';

  @override
  String get s_setup => 'Cài đặt';

  @override
  String get s_device => 'Thiết bị';

  @override
  String get s_application => 'Ứng dụng';

  @override
  String get s_settings => 'Cài đặt';

  @override
  String get s_reset_settings => 'Reset settings';

  @override
  String get l_reset_settings_desc => 'Restore settings to default';

  @override
  String get q_reset_settings => 'Reset settings?';

  @override
  String get p_reset_settings_confirmation_desc =>
      'This will restore all settings to their default values.';

  @override
  String get s_support => 'Support';

  @override
  String get s_certificates => 'Chứng chỉ';

  @override
  String get s_security_key => 'Khóa bảo mật';

  @override
  String get s_slots => 'Khe cắm';

  @override
  String get s_help_and_about => 'Help & about';

  @override
  String get s_help => 'Help';

  @override
  String get s_app_information => 'Application information';

  @override
  String get s_home => 'Trang chủ';

  @override
  String get s_user_guide => 'Hướng dẫn sử dụng';

  @override
  String get s_i_need_help => 'Tôi cần trợ giúp';

  @override
  String get s_terms_of_use => 'Điều khoản sử dụng';

  @override
  String get s_privacy_policy => 'Chính sách bảo mật';

  @override
  String get s_open_src_licenses => 'Giấy phép mã nguồn mở';

  @override
  String get s_please_wait => 'Vui lòng chờ…';

  @override
  String get s_secret_key => 'Khóa bí mật';

  @override
  String get s_show_secret_key => 'Hiển thị khóa bí mật';

  @override
  String get s_hide_secret_key => 'Ẩn khóa bí mật';

  @override
  String get s_private_key => 'Khóa riêng tư';

  @override
  String get s_public_key => 'Khóa công khai';

  @override
  String get s_invalid_length => 'Độ dài không hợp lệ';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Định dạng không hợp lệ, các ký tự được phép: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Ký tự không hợp lệ cho bàn phím đã chọn';

  @override
  String get s_require_touch => 'Yêu cầu chạm';

  @override
  String get q_have_account_info => 'Có thông tin tài khoản?';

  @override
  String get s_debugging_tools => 'Debugging tools';

  @override
  String get s_run_diagnostics => 'Chạy chẩn đoán';

  @override
  String get l_run_diagnostics_desc => 'Run diagnostics to troubleshoot';

  @override
  String get s_logging_level => 'Log level';

  @override
  String s_current_log_level(String level) {
    return 'Log level: $level';
  }

  @override
  String get s_character_count => 'Số lượng ký tự';

  @override
  String get s_language => 'Ngôn ngữ';

  @override
  String get s_app_theme => 'Chủ đề ứng dụng';

  @override
  String get s_system_default => 'Mặc định hệ thống';

  @override
  String get s_light_mode => 'Chế độ sáng';

  @override
  String get s_dark_mode => 'Chế độ tối';

  @override
  String get s_list_layout => 'Bố cục danh sách';

  @override
  String get s_grid_layout => 'Bố cục lưới';

  @override
  String get s_mixed_layout => 'Bố cục hỗn hợp';

  @override
  String get s_select_layout => 'Chọn bố cục';

  @override
  String get s_select_to_scan => 'Chọn để quét';

  @override
  String get s_hide_reader => 'Ẩn đầu đọc';

  @override
  String get s_show_hidden_readers => 'Xem đầu đọc đã ẩn';

  @override
  String get s_toggle_readers => 'Bật/tắt đầu đọc';

  @override
  String get l_toggle_readers_desc => 'Hiện hoặc ẩn đầu đọc';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Số serial: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Phiên bản firmware: $version';
  }

  @override
  String get l_fips_capable => 'Hỗ trợ FIPS';

  @override
  String get l_fips_approved => 'Đã phê duyệt FIPS';

  @override
  String get l_insert_yk => 'Chèn YubiKey của bạn';

  @override
  String get l_insert_or_tap_yk => 'Chèn hoặc chạm YubiKey';

  @override
  String get l_unplug_yk => 'Rút YubiKey của bạn';

  @override
  String get l_reinsert_yk => 'Cắm lại YubiKey của bạn';

  @override
  String get l_place_on_nfc_reader => 'Đặt YubiKey của bạn lên đầu đọc NFC';

  @override
  String get l_replace_yk_on_reader => 'Đặt lại YubiKey của bạn lên đầu đọc';

  @override
  String get l_remove_yk_from_reader => 'Rút YubiKey của bạn khỏi đầu đọc NFC';

  @override
  String get p_try_reinsert_yk => 'Hãy thử rút và cắm lại YubiKey của bạn.';

  @override
  String get s_touch_required => 'Yêu cầu chạm';

  @override
  String get l_touch_button_now =>
      'Chạm vào nút trên YubiKey của bạn ngay bây giờ';

  @override
  String get l_long_touch_button_now =>
      'Press and hold the button on your YubiKey for 10 seconds now';

  @override
  String get l_keep_touching_yk => 'Giữ chạm vào YubiKey của bạn liên tục…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Chuyển đổi ứng dụng';

  @override
  String get s_toggle_interfaces => 'Chuyển đổi giao diện';

  @override
  String get p_toggle_applications_desc =>
      'Bật hoặc tắt ứng dụng qua các phương tiện có sẵn.';

  @override
  String get p_toggle_interfaces_desc => 'Bật hoặc tắt giao diện USB.';

  @override
  String get l_toggle_applications_desc => 'Bật/tắt ứng dụng';

  @override
  String get l_toggle_interfaces_desc => 'Bật/tắt giao diện';

  @override
  String get s_reconfiguring_yk => 'Đang cấu hình lại YubiKey…';

  @override
  String get s_config_updated => 'Đã cập nhật cấu hình';

  @override
  String get l_config_updated_reinsert =>
      'Đã cập nhật cấu hình, rút và cắm lại YubiKey của bạn';

  @override
  String get s_fido_disabled => 'FIDO2 đã bị tắt';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn yêu cầu ứng dụng FIDO2 được bật trên YubiKey của bạn';

  @override
  String get s_lock_code => 'Mã khóa';

  @override
  String get l_wrong_lock_code => 'Mã khóa sai';

  @override
  String get s_show_lock_code => 'Hiển thị mã khóa';

  @override
  String get s_hide_lock_code => 'Ẩn mã khóa';

  @override
  String get p_lock_code_required_desc =>
      'Hành động bạn sắp thực hiện yêu cầu nhập mã khóa cấu hình.';

  @override
  String get l_helper_not_responding => 'Quá trình Helper không phản hồi';

  @override
  String get l_yk_no_access => 'YubiKey này không thể truy cập';

  @override
  String get s_yk_inaccessible => 'Thiết bị không thể truy cập';

  @override
  String get l_open_connection_failed => 'Không mở được kết nối';

  @override
  String get l_ccid_connection_failed => 'Không mở được kết nối thẻ thông minh';

  @override
  String get p_ccid_service_unavailable =>
      'Đảm bảo dịch vụ thẻ thông minh của bạn đang hoạt động.';

  @override
  String get p_pcscd_unavailable =>
      'Đảm bảo pcscd đã được cài đặt và đang chạy.';

  @override
  String get l_no_yk_present => 'Không có YubiKey nào hiện diện';

  @override
  String get s_unknown_type => 'Loại không xác định';

  @override
  String get s_unknown_device => 'Thiết bị không nhận dạng';

  @override
  String get s_restricted_nfc => 'Kích hoạt NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Cách kích hoạt NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Kết nối YubiKey của bạn với bất kỳ nguồn điện USB nào, chẳng hạn như máy tính, trong ít nhất 3 giây.\n\nKhi đã có nguồn điện, NFC sẽ được kích hoạt và sẵn sàng sử dụng.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'YubiKey của bạn được trang bị NFC Giới hạn, một tính năng được thiết kế để bảo vệ chống lại thao tác không dây trong quá trình vận chuyển. Điều này có nghĩa là các hoạt động NFC tạm thời bị tắt cho đến khi bạn kích hoạt chúng.';

  @override
  String get s_unsupported_yk => 'YubiKey không được hỗ trợ';

  @override
  String get p_operation_failed_try_again =>
      'Thao tác không thành công, vui lòng thử lại.';

  @override
  String get l_configuration_unsupported => 'Cấu hình không được hỗ trợ';

  @override
  String get p_scp_unsupported =>
      'Để giao tiếp qua NFC, YubiKey yêu cầu công nghệ không được điện thoại này hỗ trợ. Vui lòng cắm YubiKey vào cổng USB của điện thoại.';

  @override
  String get l_error_occurred => 'Đã xảy ra lỗi';

  @override
  String get s_application_error => 'Lỗi ứng dụng';

  @override
  String get l_import_error => 'Lỗi nhập';

  @override
  String get l_file_not_found => 'Tệp không tìm thấy';

  @override
  String get l_file_too_big => 'Kích thước tệp quá lớn';

  @override
  String get l_filesystem_error => 'Lỗi hệ thống tệp';

  @override
  String get s_pin => 'Mã PIN';

  @override
  String get s_puk => 'Mã PUK';

  @override
  String get s_set_pin => 'Cài đặt Mã PIN';

  @override
  String get s_change_pin => 'Thay đổi Mã PIN';

  @override
  String get s_change_puk => 'Thay đổi Mã PUK';

  @override
  String get s_show_pin => 'Hiển thị Mã PIN';

  @override
  String get s_hide_pin => 'Ẩn Mã PIN';

  @override
  String get s_show_puk => 'Hiển thị Mã PUK';

  @override
  String get s_hide_puk => 'Ẩn Mã PUK';

  @override
  String get s_current_pin => 'Mã PIN hiện tại';

  @override
  String get s_current_puk => 'Mã PUK hiện tại';

  @override
  String get s_new_pin => 'Mã PIN mới';

  @override
  String get s_new_puk => 'Mã PUK mới';

  @override
  String get s_confirm_pin => 'Xác nhận Mã PIN';

  @override
  String get s_confirm_puk => 'Xác nhận Mã PUK';

  @override
  String get s_unblock_pin => 'Đặt lại PIN';

  @override
  String get l_pin_mismatch => 'Mã PIN không khớp';

  @override
  String get l_puk_mismatch => 'Mã PUK không khớp';

  @override
  String get s_pin_set => 'Mã PIN đã được cài đặt';

  @override
  String get s_puk_set => 'Mã PUK đã được cài đặt';

  @override
  String l_set_pin_failed(String message) {
    return 'Cài đặt Mã PIN thất bại: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'Còn $retries lần thử lại',
      one: 'Còn $retries lần thử lại',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'còn $retries lần thử lại',
      one: 'còn $retries lần thử lại',
    );
    return 'Mã PIN không đúng, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'còn $retries lần thử lại',
      one: 'còn $retries lần thử lại',
    );
    return 'Mã PUK không đúng, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Bảo vệ Mã PIN FIDO';

  @override
  String get s_pin_change_required => 'Cần thay đổi Mã PIN';

  @override
  String get l_enter_fido2_pin => 'Nhập Mã PIN FIDO2 cho YubiKey của bạn';

  @override
  String get p_fido2_pin_required =>
      'The action you are about to perform requires the FIDO2 PIN to be entered.';

  @override
  String get l_pin_blocked_reset =>
      'Mã PIN bị khóa; khôi phục cài đặt gốc ứng dụng FIDO';

  @override
  String get l_pin_blocked => 'Mã PIN bị khóa';

  @override
  String get l_set_pin_first => 'Cần có Mã PIN';

  @override
  String get l_unlock_pin_first => 'Mở khóa bằng Mã PIN';

  @override
  String get l_pin_soft_locked =>
      'Mã PIN đã bị khóa cho đến khi YubiKey được tháo ra và cắm lại';

  @override
  String get l_pin_change_required_desc =>
      'Cần thiết lập một Mã PIN mới trước khi bạn có thể sử dụng ứng dụng này';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'Mã PIN phải có độ dài trong khoảng $min_length tới $max_length ký tự, và có thể bao gồm chữ, số và ký tự đặc biệt.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'Mã PIN phải có độ dài trong khoảng $min_length tới $max_length ký tự, có ít nhất $unique_characters ký tự khác nhau, không nằm trong danh sách mã PIN dễ đoán (ví dụ: $common_pin), và có thể bao gồm chữ, số và ký tự đặc biệt.';
  }

  @override
  String get s_ep_attestation => 'Xác thực Doanh Nghiệp';

  @override
  String get s_ep_attestation_enabled =>
      'Xác thực Doanh Nghiệp đã được kích hoạt';

  @override
  String get q_enable_ep_attestation => 'Bật tính năng Chứng thực cấp tổ chức?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Điều này sẽ kích hoạt Xác thực Doanh Nghiệp, cho phép các miền được ủy quyền xác định YubiKey của bạn một cách duy nhất.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Khi đã kích hoạt, Xác thực Doanh Nghiệp chỉ có thể bị tắt bằng cách thực hiện khôi phục cài đặt gốc FIDO.';

  @override
  String get s_pin_required => 'Cần Mã PIN';

  @override
  String get p_pin_required_desc =>
      'Hành động bạn sắp thực hiện yêu cầu phải nhập Mã PIN PIV.';

  @override
  String get l_piv_pin_blocked => 'Bị khóa, sử dụng PUK để khôi phục';

  @override
  String get p_piv_pin_blocked_desc =>
      'Đã nhập sai mã PIN quá số lần cho phép. Vui lòng nhập mã PUK để đặt lại PIN.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'The PIN is blocked. A factory reset is required.';

  @override
  String get l_piv_pin_puk_blocked => 'Bị khóa, cần khôi phục cài đặt gốc';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Đã nhập sai cả mã PIN và PUK quá số lần cho phép. Yêu cầu đưa vùng chứa chứng thư PIV về cài đặt lúc xuất xưởng.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'Mã $name phải dài ít nhất $length ký tự.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'Mã $name phải dài ít nhất $length ký tự, có ít nhất 2 ký tự không lặp lại, và không nằm trong danh sách mã $name dễ đoán (ví dụ: $common).';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Mới $name không đáp ứng yêu cầu độ phức tạp.';
  }

  @override
  String get s_dismiss => 'Bỏ qua';

  @override
  String get p_default_pin_puk_key_desc =>
      'Khuyến nghị nên đổi ngay mã PIN, PUK và khoá quản lý khác với cài đặt lúc xuất xưởng.';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      'For FIPS compliance it is required to change the default PIN, PUK and management key.';

  @override
  String get l_warning_default_pin => 'Cảnh báo: Đã sử dụng Mã PIN mặc định';

  @override
  String get l_warning_default_puk => 'Cảnh báo: Đã sử dụng Mã PUK mặc định';

  @override
  String get l_default_pin_used => 'Đã sử dụng Mã PIN mặc định';

  @override
  String get l_default_puk_used => 'Đã sử dụng Mã PUK mặc định';

  @override
  String get l_pin_complexity => 'Yêu cầu độ phức tạp của Mã PIN';

  @override
  String get s_password => 'Mật khẩu';

  @override
  String get s_manage_password => 'Quản lý mật khẩu';

  @override
  String get s_set_password => 'Đặt mật khẩu';

  @override
  String get s_password_set => 'Mật khẩu đã được đặt';

  @override
  String get s_show_password => 'Hiển thị mật khẩu';

  @override
  String get s_hide_password => 'Ẩn mật khẩu';

  @override
  String get l_password_protection => 'Bảo vệ mật khẩu của các tài khoản';

  @override
  String get s_new_password => 'Mật khẩu mới';

  @override
  String get s_current_password => 'Mật khẩu hiện tại';

  @override
  String get s_confirm_password => 'Xác nhận mật khẩu';

  @override
  String get l_password_mismatch => 'Mật khẩu không khớp';

  @override
  String get s_wrong_password => 'Mật khẩu sai';

  @override
  String get p_wrong_password =>
      'Mật khẩu không đúng. Nếu bạn không biết mật khẩu, bạn sẽ cần phải đặt lại YubiKey.';

  @override
  String get s_remove_password => 'Xóa mật khẩu';

  @override
  String get s_password_removed => 'Mật khẩu đã bị xóa';

  @override
  String get s_remember_password => 'Nhớ mật khẩu';

  @override
  String get s_clear_saved_password => 'Xóa mật khẩu đã lưu';

  @override
  String get s_password_forgotten => 'Quên mật khẩu';

  @override
  String get l_keystore_unavailable =>
      'Keystore của hệ điều hành không khả dụng';

  @override
  String get l_remember_pw_failed => 'Không thể nhớ mật khẩu';

  @override
  String get l_unlock_first => 'Mở khóa bằng mật khẩu';

  @override
  String get l_set_password_first => 'Đặt mật khẩu';

  @override
  String get l_enter_oath_pw => 'Nhập mật khẩu OATH cho YubiKey của bạn';

  @override
  String get p_new_password_requirements =>
      'A password may contain letters, numbers and special characters.';

  @override
  String get s_management_key => 'Khóa quản lý';

  @override
  String get s_current_management_key => 'Khóa quản lý hiện tại';

  @override
  String get s_new_management_key => 'Khóa quản lý mới';

  @override
  String get l_change_management_key => 'Thay đổi khóa quản lý';

  @override
  String get l_management_key_changed => 'Khóa quản lý đã được thay đổi';

  @override
  String get l_default_key_used => 'Đã sử dụng khóa quản lý mặc định';

  @override
  String get s_generate_random => 'Tạo ngẫu nhiên';

  @override
  String get s_use_default => 'Sử dụng mặc định';

  @override
  String get l_warning_default_key => 'Cảnh báo: Đã sử dụng khóa mặc định';

  @override
  String get s_protect_key => 'Bảo vệ bằng Mã PIN';

  @override
  String get p_protect_key_desc =>
      'Use the PIN in place of the management key during operations that require management key authentication.';

  @override
  String get s_management_key_algorithm => 'Management key algorithm';

  @override
  String get p_management_key_algorithm_desc =>
      'The algorithm to choose for the management key.';

  @override
  String get l_pin_protected_key => 'Mã PIN có thể được sử dụng thay thế';

  @override
  String get l_wrong_key => 'Khóa sai';

  @override
  String get l_unlock_piv_management => 'Mở khóa quản lý PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'The action you are about to perform requires the PIV management key.';

  @override
  String l_account(String label) {
    return 'Tài khoản: $label';
  }

  @override
  String get s_accounts => 'Các tài khoản';

  @override
  String get s_no_accounts => 'Không có tài khoản';

  @override
  String l_results_for(String query) {
    return 'Kết quả cho \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Bắt đầu với các tài khoản OTP';

  @override
  String get l_no_accounts_desc =>
      'Thêm tài khoản vào YubiKey của bạn từ bất kỳ nhà cung cấp dịch vụ nào hỗ trợ OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Thêm tài khoản';

  @override
  String get p_add_account_desc =>
      'Scan QR code or enter the credential details manually.';

  @override
  String get s_add_accounts => 'Thêm tài khoản(s)';

  @override
  String get l_drop_qr_description => 'Kéo mã QR để thêm tài khoản(s)';

  @override
  String get p_add_account_three_ways =>
      'There are three ways of adding accounts.';

  @override
  String get s_scanning => 'Scanning (recommended)';

  @override
  String get p_scanning_desc =>
      'Before scanning a QR code, make sure the full code is visible on screen.';

  @override
  String get s_drag_and_drop => 'Drag and drop';

  @override
  String get p_drag_and_drop_desc =>
      'An image containing a QR code may be dropped anywhere in the Accounts view.';

  @override
  String get s_manually => 'Manually';

  @override
  String get p_manually_desc =>
      'Account credential details may be entered manually in the form.';

  @override
  String get s_account_added => 'Tài khoản đã được thêm';

  @override
  String l_account_add_failed(String message) {
    return 'Thêm tài khoản thất bại: $message';
  }

  @override
  String get l_add_account_password_required => 'Yêu cầu mật khẩu';

  @override
  String get l_add_account_unlock_required => 'Yêu cầu mở khóa';

  @override
  String get l_add_account_func_missing =>
      'Chức năng bị thiếu hoặc bị vô hiệu hóa';

  @override
  String get l_account_name_required => 'Tài khoản của bạn phải có tên';

  @override
  String get l_name_already_exists => 'Tên này đã tồn tại cho nhà phát hành';

  @override
  String get l_account_already_exists =>
      'Tài khoản này đã tồn tại trên YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Ký tự không hợp lệ: \':\' không được phép trong nhà phát hành';

  @override
  String get l_select_accounts => 'Chọn tài khoản(s) để thêm vào YubiKey';

  @override
  String get s_pin_account => 'Ghim tài khoản';

  @override
  String get s_unpin_account => 'Bỏ ghim tài khoản';

  @override
  String get s_no_pinned_accounts => 'Không có tài khoản nào được ghim';

  @override
  String get s_pinned => 'Đã ghim';

  @override
  String get l_pin_account_desc =>
      'Giữ các tài khoản quan trọng của bạn cùng nhau';

  @override
  String get s_rename_account => 'Đổi tên tài khoản';

  @override
  String get l_rename_account_desc =>
      'Chỉnh sửa nhà phát hành/tên của tài khoản';

  @override
  String get s_account_renamed => 'Tài khoản đã được đổi tên';

  @override
  String l_rename_account_failed(String message) {
    return 'Đổi tên tài khoản không thành công: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Điều này sẽ thay đổi cách tài khoản được hiển thị trong danh sách.';

  @override
  String get s_delete_account => 'Xóa tài khoản';

  @override
  String get q_delete_account => 'Delete account?';

  @override
  String get l_delete_account_desc => 'Xóa tài khoản khỏi YubiKey của bạn';

  @override
  String get s_account_deleted => 'Tài khoản đã bị xóa';

  @override
  String get p_warning_delete_account =>
      'Cảnh báo! Hành động này sẽ xóa tài khoản khỏi YubiKey của bạn.';

  @override
  String get p_warning_disable_credential =>
      'Make sure to disable this account from the service it is registered with to avoid being locked out.';

  @override
  String get s_account_name => 'Tên tài khoản';

  @override
  String get s_search_accounts => 'Tìm kiếm tài khoản';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used trong $capacity tài khoản đã sử dụng';
  }

  @override
  String s_num_digits(int num) {
    return '$num chữ số';
  }

  @override
  String s_num_sec(int num) {
    return '$num giây';
  }

  @override
  String get s_issuer_optional => 'Nhà phát hành (tùy chọn)';

  @override
  String get s_counter_based => 'Dựa trên bộ đếm';

  @override
  String get s_time_based => 'Dựa trên thời gian';

  @override
  String get l_copy_code_desc => 'Dán mã vào ứng dụng khác';

  @override
  String get l_calculate_code_desc => 'Lấy mã mới từ YubiKey của bạn';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'User ID';

  @override
  String get s_credential_id => 'Credential ID';

  @override
  String get s_display_name => 'Tên hiển thị';

  @override
  String get s_user_name => 'Tên người dùng';

  @override
  String get s_passkeys => 'Mã bảo mật';

  @override
  String get s_no_passkeys => 'Không có mã bảo mật';

  @override
  String get l_ready_to_use => 'Sẵn sàng sử dụng';

  @override
  String get l_register_sk_on_websites =>
      'Đăng ký làm Security Key trên các trang web';

  @override
  String get l_no_discoverable_accounts => 'Không có mã bảo mật đã lưu';

  @override
  String get p_non_passkeys_note =>
      'Có thể có thông tin đăng nhập không phải là mã bảo mật, nhưng không thể được liệt kê.';

  @override
  String get s_delete_passkey => 'Xóa mã bảo mật';

  @override
  String get q_delete_passkey => 'Delete passkey?';

  @override
  String get l_delete_passkey_desc => 'Xóa mã bảo mật khỏi YubiKey';

  @override
  String get s_passkey_deleted => 'Mã bảo mật đã bị xóa';

  @override
  String get p_warning_delete_passkey =>
      'Warning! This action will delete the passkey from your YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'You will no longer be able to use this passkey for the service where it is registered.';

  @override
  String get l_do_not_remove_yk_delete =>
      'Do not remove YubiKey during deletion';

  @override
  String get s_search_passkeys => 'Tìm kiếm mã bảo mật';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used trong $max mã bảo mật đã sử dụng.';
  }

  @override
  String get s_biometrics => 'Sinh trắc học';

  @override
  String l_fingerprint(String label) {
    return 'Vân tay: $label';
  }

  @override
  String get s_fingerprints => 'Vân tay';

  @override
  String get l_fingerprint_captured => 'Vân tay đã được ghi lại thành công!';

  @override
  String get s_fingerprint_added => 'Vân tay đã được thêm';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Lỗi khi thêm vân tay: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Lỗi khi thiết lập tên: $message';
  }

  @override
  String get s_setup_fingerprints => 'Thiết lập vân tay';

  @override
  String get p_setup_fingerprints_desc =>
      'Cần thiết lập vân tay trước khi có thể sử dụng khóa.';

  @override
  String get s_add_fingerprint => 'Thêm vân tay';

  @override
  String get s_delete_fingerprint => 'Xóa vân tay';

  @override
  String get q_delete_fingerprint => 'Delete fingerprint?';

  @override
  String get l_delete_fingerprint_desc => 'Xóa vân tay khỏi YubiKey';

  @override
  String get s_fingerprint_deleted => 'Vân tay đã bị xóa';

  @override
  String get p_warning_delete_fingerprint =>
      'Điều này sẽ xóa vân tay khỏi YubiKey của bạn.';

  @override
  String get s_fingerprints_get_started => 'Bắt đầu với vân tay';

  @override
  String get p_set_fingerprints_desc =>
      'Trước khi có thể đăng ký vân tay, cần thiết lập mã PIN.';

  @override
  String get l_no_fps_added => 'Chưa có vân tay nào được thêm';

  @override
  String get s_rename_fp => 'Đổi tên vân tay';

  @override
  String get l_rename_fp_desc => 'Thay đổi tên';

  @override
  String get s_fingerprint_renamed => 'Vân tay đã được đổi tên';

  @override
  String l_rename_fp_failed(String message) {
    return 'Lỗi khi đổi tên: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Thêm một hoặc nhiều (tối đa năm) vân tay';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 vân tay đã đăng ký';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Ấn ngón tay của bạn vào YubiKey để bắt đầu.';

  @override
  String get l_name_fingerprint => 'Đặt tên cho vân tay này';

  @override
  String get l_user_action_timeout_error =>
      'Thất bại do không hoạt động của người dùng';

  @override
  String get l_wrong_inserted_yk_error =>
      'YubiKey được cắm lại không khớp với thiết bị ban đầu';

  @override
  String get l_failed_connecting_to_fido =>
      'Kết nối với giao diện FIDO thất bại';

  @override
  String get l_self_signed_certificate => 'Self-signed certificate';

  @override
  String get l_certificate_signing_request =>
      'Certificate Signing Request (CSR)';

  @override
  String get s_certificate => 'Chứng chỉ';

  @override
  String get s_subject => 'Chủ thể';

  @override
  String get l_export_csr_file => 'Lưu CSR vào tập tin';

  @override
  String get l_export_public_key => 'Xuất khóa công khai';

  @override
  String get l_export_public_key_file => 'Lưu khóa công khai vào tập tin';

  @override
  String get l_export_public_key_desc => 'Xuất khóa công khai vào một tập tin';

  @override
  String get l_public_key_exported => 'Khóa công khai đã được xuất';

  @override
  String get l_export_certificate => 'Xuất chứng chỉ';

  @override
  String get l_export_certificate_file => 'Xuất chứng chỉ vào tập tin';

  @override
  String get l_export_certificate_desc => 'Xuất chứng chỉ vào một tập tin';

  @override
  String get l_certificate_exported => 'Chứng chỉ đã được xuất';

  @override
  String get l_select_import_file => 'Chọn tập tin để nhập';

  @override
  String get l_import_file => 'Nhập tập tin';

  @override
  String get l_import_desc => 'Nhập khóa và/hoặc chứng chỉ';

  @override
  String get l_import_nothing => 'Không có gì để nhập';

  @override
  String get l_importing_file => 'Đang nhập tập tin…';

  @override
  String get s_file_imported => 'Tập tin đã được nhập';

  @override
  String get l_unsupported_key_type => 'Loại khóa không được hỗ trợ';

  @override
  String get l_delete_certificate => 'Xóa chứng chỉ';

  @override
  String get q_delete_certificate => 'Delete certificate?';

  @override
  String get l_delete_certificate_desc => 'Xóa chứng chỉ khỏi YubiKey của bạn';

  @override
  String get l_delete_key => 'Xóa khóa';

  @override
  String get q_delete_key => 'Delete key?';

  @override
  String get l_delete_key_desc => 'Xóa khóa khỏi YubiKey của bạn';

  @override
  String get l_delete_certificate_or_key => 'Xóa chứng chỉ/khóa';

  @override
  String get q_delete_certificate_or_key => 'Delete certificate/key?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Xóa chứng chỉ hoặc khóa khỏi YubiKey';

  @override
  String get l_move_key => 'Di chuyển khóa';

  @override
  String get l_move_key_desc =>
      'Di chuyển một khóa từ khe PIV này sang khe khác';

  @override
  String get l_change_defaults => 'Thay đổi mã truy cập mặc định';

  @override
  String get s_issuer => 'Nhà phát hành';

  @override
  String get s_serial => 'Số serial';

  @override
  String get s_certificate_fingerprint => 'Dấu vân tay';

  @override
  String get s_valid_from => 'Có hiệu lực từ';

  @override
  String get s_valid_to => 'Có hiệu lực đến';

  @override
  String get l_no_certificate => 'Chưa có chứng chỉ nào được tải';

  @override
  String get l_key_no_certificate => 'Khóa không có chứng chỉ được tải';

  @override
  String get s_generate_key => 'Tạo khóa';

  @override
  String get l_generate_desc => 'Tạo một chứng chỉ hoặc CSR mới';

  @override
  String p_generate_desc(String slot) {
    return 'This will generate a new key on the YubiKey in PIV slot $slot.';
  }

  @override
  String get s_private_key_generated => 'Khóa riêng đã được tạo';

  @override
  String get p_select_what_to_delete => 'Chọn những gì để xóa từ khe.';

  @override
  String get p_warning_delete_certificate =>
      'Cảnh báo! Hành động này sẽ xóa chứng chỉ khỏi YubiKey của bạn.';

  @override
  String get p_warning_delete_key =>
      'Cảnh báo! Hành động này sẽ xóa khóa riêng khỏi YubiKey của bạn.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Cảnh báo! Hành động này sẽ xóa chứng chỉ và khóa riêng khỏi YubiKey của bạn.';

  @override
  String get p_warning_usb_preferred =>
      'Prefer USB for RSA keys. NFC may result in errors.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'This will delete the certificate in PIV slot $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'This will delete the private key in PIV slot $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'This will delete the certificate and private key in PIV slot $slot.';
  }

  @override
  String get l_certificate_deleted => 'Chứng chỉ đã bị xóa';

  @override
  String get l_key_deleted => 'Khóa đã bị xóa';

  @override
  String get l_certificate_and_key_deleted => 'Chứng chỉ và khóa đã bị xóa';

  @override
  String get l_include_certificate => 'Bao gồm chứng chỉ';

  @override
  String get l_select_destination_slot => 'Chọn khe đích';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Di chuyển khóa riêng trong khe PIV $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Di chuyển khóa riêng trong khe PIV $from_slot đến khe $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Di chuyển khóa riêng và chứng chỉ trong khe PIV $from_slot đến khe $to_slot?';
  }

  @override
  String get p_password_protected_file =>
      'The selected file is password protected.';

  @override
  String p_import_items_desc(String slot) {
    return 'Các mục sau sẽ được nhập vào khe PIV $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'The public key of the certificate does not match the private key in the slot';

  @override
  String get l_key_moved => 'Khóa đã được di chuyển';

  @override
  String get l_key_and_certificate_moved =>
      'Khóa và chứng chỉ đã được di chuyển';

  @override
  String get p_subject_desc =>
      'Tên phân biệt (DN) được định dạng theo tiêu chuẩn RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Định dạng RFC 4514 không hợp lệ';

  @override
  String get rfc4514_examples =>
      'Ví dụ:\nCN=Tên Ví dụ\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => 'Cho phép vân tay';

  @override
  String get s_pin_policy => 'PIN policy';

  @override
  String get s_output_format => 'Output format';

  @override
  String get s_expiration_date => 'Expiration date';

  @override
  String get p_algorithm_desc => 'Key algorithm to use.';

  @override
  String get p_expiration_date_desc =>
      'Date when the certificate expires, default 1 year (certificate only).';

  @override
  String get p_key_options_bio_desc =>
      'Cho phép sử dụng sinh trắc học thay cho PIN.';

  @override
  String get q_overwrite_slot => 'Overwrite slot?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Điều này sẽ ghi đè vĩnh viễn nội dung hiện có trong khe $slot.';
  }

  @override
  String get l_overwrite_cert => 'Chứng chỉ sẽ bị ghi đè';

  @override
  String get l_overwrite_key => 'Khóa riêng sẽ bị ghi đè';

  @override
  String get l_overwrite_key_maybe =>
      'Bất kỳ khóa riêng nào hiện có trong khe sẽ bị ghi đè';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Xác thực';

  @override
  String get s_slot_9c => 'Chữ ký số';

  @override
  String get s_slot_9d => 'Quản lý khóa';

  @override
  String get s_slot_9e => 'Xác thực thẻ';

  @override
  String get s_retired_slot => 'Quản lý khóa đã nghỉ hưu';

  @override
  String get s_otp_slot_one => 'Chạm ngắn';

  @override
  String get s_otp_slot_two => 'Chạm lâu';

  @override
  String get l_otp_slot_empty => 'Khe trống';

  @override
  String get l_otp_slot_configured => 'Khe đã được cấu hình';

  @override
  String get l_yubiotp_desc => 'Cài đặt thông tin xác thực Yubico OTP';

  @override
  String get s_challenge_response => 'Thách thức-phản hồi';

  @override
  String get l_challenge_response_desc =>
      'Cài đặt thông tin xác thực thách thức-phản hồi';

  @override
  String get s_static_password => 'Mật khẩu tĩnh';

  @override
  String get l_static_password_desc => 'Cấu hình mật khẩu tĩnh';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Cài đặt thông tin xác thực dựa trên HMAC-SHA1';

  @override
  String get s_public_id => 'ID công khai';

  @override
  String get s_private_id => 'ID riêng tư';

  @override
  String get s_use_serial => 'Sử dụng số sê-ri';

  @override
  String get l_select_file => 'Chọn tệp';

  @override
  String get l_no_export_file => 'Không có tệp xuất khẩu';

  @override
  String get s_no_export => 'Không xuất khẩu';

  @override
  String get s_export => 'Xuất khẩu';

  @override
  String get l_export_configuration_file => 'Xuất cấu hình ra tệp';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Các thông tin xác thực đã xuất có thể được tải lên tại $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Keyboard $layout';
  }

  @override
  String get s_delete_slot => 'Xóa thông tin xác thực';

  @override
  String get q_delete_slot => 'Delete credential?';

  @override
  String get l_delete_slot_desc => 'Xóa thông tin xác thực trong khe';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Cảnh báo! Hành động này sẽ xóa vĩnh viễn thông tin xác thực khỏi khe $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Thông tin xác thực đã bị xóa';

  @override
  String get s_swap => 'Hoán đổi';

  @override
  String get s_swap_slots => 'Hoán đổi các khe';

  @override
  String get q_swap_slots => 'Swap slots?';

  @override
  String get l_swap_slots_desc => 'Hoán đổi chạm ngắn/dài';

  @override
  String get p_swap_slots_desc => 'Điều này sẽ hoán đổi cấu hình của hai khe.';

  @override
  String get l_slots_swapped => 'Cấu hình khe đã được hoán đổi';

  @override
  String l_slot_credential_configured(String type) {
    return 'Thông tin xác thực $type đã được cấu hình';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Thông tin xác thực $type đã được cấu hình và xuất khẩu ra $file';
  }

  @override
  String get s_append_enter => 'Thêm ⏎';

  @override
  String get l_append_enter_desc => 'Thêm một cú nhấn Enter sau khi phát OTP';

  @override
  String get p_otp_swap_error =>
      'Không thể hoán đổi khe! Đảm bảo YubiKey không có quyền truy cập hạn chế.';

  @override
  String get l_wrong_access_code => 'Mã truy cập sai';

  @override
  String get s_access_code => 'Mã truy cập';

  @override
  String get s_show_access_code => 'Hiển thị mã truy cập';

  @override
  String get s_hide_access_code => 'Ẩn mã truy cập';

  @override
  String p_enter_access_code(String slot) {
    return 'Nhập mã truy cập cho khe $slot.';
  }

  @override
  String get s_enable_nfc => 'Bật NFC';

  @override
  String get s_request_access => 'Yêu cầu quyền truy cập';

  @override
  String get s_permission_denied => 'Quyền truy cập bị từ chối';

  @override
  String get l_elevating_permissions => 'Nâng cao quyền…';

  @override
  String get s_review_permissions => 'Xem xét quyền';

  @override
  String get s_open_windows_settings => 'Mở cài đặt Windows';

  @override
  String get l_admin_privileges_required => 'Yêu cầu quyền quản trị';

  @override
  String get p_elevated_permissions_required =>
      'Quản lý thiết bị này yêu cầu quyền quản trị. Bạn cũng có thể sử dụng Cài đặt Windows để quản lý cấu hình FIDO.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'Quản lý WebAuthn yêu cầu quyền quản trị. Bạn cũng có thể sử dụng Cài đặt Windows để quản lý cấu hình FIDO.';

  @override
  String get p_ms_store_permission_note =>
      'The Microsoft Store version of the app is generally unable to elevate permissions due to sandboxing limitations of Windows. We recommend installing Yubico Authenticator from our official .msi installer.';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator cần quyền truy cập Camera để quét mã QR.';

  @override
  String get s_qr_scan => 'Quét mã QR';

  @override
  String get l_invalid_qr => 'Mã QR không hợp lệ';

  @override
  String get l_qr_not_found => 'Không tìm thấy mã QR';

  @override
  String get l_qr_scanned => 'Scanned QR code';

  @override
  String l_qr_file_too_large(String max) {
    return 'Tệp quá lớn (tối đa $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Tệp hình ảnh không hợp lệ';

  @override
  String get l_qr_select_file => 'Chọn tệp có mã QR';

  @override
  String l_qr_not_read(String message) {
    return 'Không thể đọc mã QR: $message';
  }

  @override
  String get l_point_camera_scan => 'Chỉa camera vào mã QR để quét';

  @override
  String get q_want_to_scan => 'Bạn có muốn quét không?';

  @override
  String get q_no_qr => 'Không có mã QR?';

  @override
  String get s_enter_manually => 'Nhập thủ công';

  @override
  String get s_read_from_file => 'Đọc từ tệp';

  @override
  String get s_reset => 'Đặt lại';

  @override
  String get s_factory_reset => 'Đặt lại nhà máy';

  @override
  String get l_factory_reset_desc =>
      'Khôi phục các cài đặt mặc định của YubiKey';

  @override
  String get l_factory_reset_required => 'Yêu cầu đặt lại nhà máy';

  @override
  String get l_oath_application_reset => 'Đặt lại ứng dụng OATH';

  @override
  String get l_fido_app_reset => 'Đặt lại ứng dụng FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Lỗi khi thực hiện đặt lại: $message';
  }

  @override
  String get l_piv_app_reset => 'Đặt lại ứng dụng PIV';

  @override
  String get p_factory_reset_an_app =>
      'Đặt lại một ứng dụng trên YubiKey của bạn.';

  @override
  String get p_factory_reset_desc =>
      'Dữ liệu được lưu trữ trong nhiều ứng dụng trên YubiKey, một số trong số đó có thể được đặt lại nhà máy độc lập với nhau.\n\nChọn một ứng dụng ở trên để đặt lại.';

  @override
  String get p_warning_factory_reset =>
      'Cảnh báo! Điều này sẽ xóa vĩnh viễn tất cả các tài khoản OATH TOTP/HOTP khỏi YubiKey của bạn.';

  @override
  String get p_warning_disable_credentials =>
      'Các thông tin xác thực OATH của bạn, cũng như bất kỳ mật khẩu nào đã đặt, sẽ bị xóa khỏi YubiKey này. Hãy đảm bảo vô hiệu hóa chúng từ các trang web tương ứng để tránh bị khóa tài khoản của bạn.';

  @override
  String get p_warning_deletes_accounts =>
      'Cảnh báo! Điều này sẽ xóa vĩnh viễn tất cả các tài khoản U2F và FIDO2, bao gồm cả passkeys, khỏi YubiKey của bạn.';

  @override
  String get p_warning_disable_accounts =>
      'Các thông tin xác thực của bạn, cũng như bất kỳ PIN nào đã đặt, sẽ bị xóa khỏi YubiKey này. Hãy đảm bảo vô hiệu hóa chúng từ các trang web tương ứng để tránh bị khóa tài khoản của bạn.';

  @override
  String l_reset_not_allowed_over(String transport) {
    return 'FIDO reset is disabled over $transport';
  }

  @override
  String get p_warning_piv_reset =>
      'Cảnh báo! Tất cả dữ liệu được lưu trữ cho PIV sẽ bị xóa vĩnh viễn khỏi YubiKey của bạn.';

  @override
  String get p_warning_piv_reset_desc =>
      'Điều này bao gồm các khóa riêng và chứng chỉ. PIN, PUK và khóa quản lý của bạn sẽ được đặt lại về giá trị mặc định của nhà máy.';

  @override
  String get p_warning_global_reset =>
      'Cảnh báo! Điều này sẽ xóa vĩnh viễn tất cả dữ liệu đã lưu, bao gồm các thông tin xác thực, khỏi YubiKey của bạn.';

  @override
  String get p_warning_global_reset_desc =>
      'Đặt lại các ứng dụng trên YubiKey của bạn về cài đặt mặc định của nhà máy. PIN sẽ được đặt lại về giá trị mặc định của nhà máy, và các dấu vân tay đã đăng ký sẽ bị xóa. Tất cả các khóa, chứng chỉ hoặc các thông tin xác thực khác sẽ bị xóa vĩnh viễn.';

  @override
  String get l_copy_to_clipboard => 'Sao chép vào clipboard';

  @override
  String get s_code_copied => 'Mã đã được sao chép';

  @override
  String get l_code_copied_clipboard => 'Mã đã được sao chép vào clipboard';

  @override
  String get s_copy_log => 'Sao chép nhật ký';

  @override
  String get l_copy_log_clipboard => 'Copy log to clipboard';

  @override
  String get l_log_copied => 'Nhật ký đã được sao chép vào clipboard';

  @override
  String get l_diagnostics_copied =>
      'Dữ liệu chẩn đoán đã được sao chép vào clipboard';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label đã được sao chép vào clipboard.';
  }

  @override
  String get s_custom_icons => 'Biểu tượng tùy chỉnh';

  @override
  String get l_set_icons_for_accounts => 'Đặt biểu tượng cho các tài khoản';

  @override
  String get p_custom_icons_description =>
      'Các gói biểu tượng có thể làm cho các tài khoản của bạn dễ phân biệt hơn với các logo và màu sắc quen thuộc.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Icon packs use the $aegis_icon_pack format. You can download a pre-made icon pack, or you can create your own.';
  }

  @override
  String get s_replace_icon_pack => 'Thay thế gói biểu tượng';

  @override
  String get l_loading_icon_pack => 'Đang tải gói biểu tượng…';

  @override
  String get s_load_icon_pack => 'Tải gói biểu tượng';

  @override
  String get l_load_icon_pack_desc => 'Load icon pack from file';

  @override
  String get s_remove_icon_pack => 'Gỡ gói biểu tượng';

  @override
  String get l_remove_icon_pack_desc => 'Delete the active icon pack';

  @override
  String get l_icon_pack_removed => 'Gói biểu tượng đã được gỡ bỏ';

  @override
  String get l_remove_icon_pack_failed => 'Lỗi khi gỡ bỏ gói biểu tượng';

  @override
  String get s_choose_icon_pack => 'Chọn gói biểu tượng';

  @override
  String get l_icon_pack_imported => 'Gói biểu tượng đã được nhập khẩu';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Lỗi khi nhập khẩu gói biểu tượng: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Gói biểu tượng không hợp lệ';

  @override
  String get l_icon_pack_copy_failed =>
      'Không thể sao chép các tệp gói biểu tượng';

  @override
  String get s_nfc_and_usb_options => 'NFC & USB options';

  @override
  String get l_nfc_and_usb_options_desc => 'Configure action for YubiKey';

  @override
  String get l_on_yk_nfc_tap => 'On NFC tap';

  @override
  String get l_on_yk_usb_insert => 'On USB insert';

  @override
  String get l_do_nothing => 'Không làm gì';

  @override
  String get l_launch_ya => 'Khởi chạy Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Sao chép OTP vào clipboard';

  @override
  String get l_launch_and_copy_otp => 'Khởi chạy ứng dụng và sao chép OTP';

  @override
  String get l_kbd_layout_for_static => 'Bố cục bàn phím (cho mật khẩu tĩnh)';

  @override
  String get s_choose_kbd_layout => 'Chọn bố cục bàn phím';

  @override
  String get l_bypass_touch_requirement => 'Bỏ qua yêu cầu chạm';

  @override
  String get l_bypass_touch_requirement_on =>
      'Các tài khoản yêu cầu chạm sẽ tự động được hiển thị qua NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Các tài khoản yêu cầu chạm cần thêm một lần chạm qua NFC';

  @override
  String get s_silence_nfc_sounds => 'Tắt âm thanh NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'Không có âm thanh nào sẽ được phát khi chạm NFC';

  @override
  String get l_silence_nfc_sounds_off => 'Âm thanh sẽ phát khi chạm NFC';

  @override
  String get l_launch_app_on_usb_on =>
      'Điều này ngăn cản các ứng dụng khác sử dụng YubiKey qua USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Các ứng dụng khác có thể sử dụng YubiKey qua USB';

  @override
  String get s_allow_screenshots => 'Cho phép chụp ảnh màn hình';

  @override
  String get l_allow_screenshots_desc => 'Allow other apps to take screenshots';

  @override
  String get s_nfc_ready_to_scan => 'Sẵn sàng để quét';

  @override
  String get s_nfc_hold_still => 'Giữ yên…';

  @override
  String get s_nfc_tap_your_yubikey => 'Nhấn vào YubiKey của bạn';

  @override
  String get s_nfc_remove_key => 'Remove YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Không quét được, hãy thử lại';

  @override
  String get s_usb_processing => 'Reading data from YubiKey';

  @override
  String get s_usb_dont_remove => 'Don\'t remove the key…';

  @override
  String get l_usb_read_error => 'Failed to read data from YubiKey';

  @override
  String get p_ndef_set_otp => 'Đã sao chép mã OTP từ YubiKey vào clipboard.';

  @override
  String get p_ndef_set_password =>
      'Đã sao chép mật khẩu từ YubiKey vào clipboard.';

  @override
  String get p_ndef_parse_failure => 'Không thể phân tích mã OTP từ YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Không thể truy cập clipboard khi cố gắng sao chép mã OTP từ YubiKey.';

  @override
  String get s_set_label => 'Đặt nhãn';

  @override
  String get s_set_color => 'Đặt màu';

  @override
  String get s_change_label => 'Thay đổi nhãn';

  @override
  String get p_set_will_add_custom_name =>
      'Điều này sẽ đặt tên tùy chỉnh cho YubiKey của bạn.';

  @override
  String get p_rename_will_change_custom_name =>
      'Điều này sẽ thay đổi nhãn của YubiKey của bạn.';

  @override
  String get s_keyboard_shortcuts => 'Keyboard shortcuts';

  @override
  String get s_global_shortcuts => 'Global shortcuts';

  @override
  String get s_application_shortcuts => 'Application shortcuts';

  @override
  String s_quit_app(String app) {
    return 'Quit $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Hide $app';
  }

  @override
  String get s_search => 'Search';

  @override
  String get s_next_device => 'Next device';

  @override
  String get s_previous_device => 'Previous device';

  @override
  String get s_open_settings => 'Open settings';

  @override
  String get s_open_item => 'Open item';

  @override
  String get s_edit_item => 'Edit item';

  @override
  String get s_delete_item => 'Delete item';

  @override
  String get s_calculate_oath_code => 'Calculate OATH code';

  @override
  String get s_open_keyboard_shortcuts => 'Open keyboard shortcuts';
}
