// GENERATED FILE. DO NOT EDIT.
//
// To edit this file modify the generator file `generator/update_package.dart` and
// re-generate.
// This file was generated 2025-09-12 07:59:53.032815 by the dart file
// `generator/update_package.dart`.
//
// Copyright 2025. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/// These data tables provide metadata for the Material Symbols icons.
///  The data was derived from the official Material Symbols metadata file
/// downloaded from `http://fonts.google.com/metadata/icons?incomplete=1&key=material_symbols`
/// 
library symbols;

import 'dart:convert';

/// This class represents the metadata for an icon in the Material Symbols collection.
class SymbolsMetadata {
  String? originalName;  // This is set if the icon was renamed from the original name (to create a valid Dart symbol name). Otherwise it is null.
  int popularity;
  int codepoint;
  List<int> categories;
  List<int> tags;
  bool rtlAutoMirrored = false; // Default to false
  List<int> codePointsFromCodePointsFiles = [];
  
  SymbolsMetadata(
      {
      this.originalName,
      required this.popularity,
      required this.codepoint,
      required this.categories,
      required this.tags,
      this.rtlAutoMirrored = false}); // Default to false

  factory SymbolsMetadata.fromJson(Map<String, dynamic> json) {
    return SymbolsMetadata(
      originalName: (json['originalName']!=null && json['originalName']!.isNotEmpty && json['originalName']!=json['name']) ? json['originalName'] : null,
      popularity: json['popularity'] ?? 0,
      codepoint: json['codepoint'] ?? 0,
      categories:
          (json['categories'] as List<dynamic>?)?.cast<int>() ?? [],
      tags: (json['tags'] as List<dynamic>?)?.cast<int>() ?? [],
      rtlAutoMirrored: json['rtlAutoMirrored'] ?? false,
    );
  }

  String toJson() {
    return json.encode({
      if(originalName!=null && originalName!.isNotEmpty) 'originalName': originalName!,
      if(rtlAutoMirrored) 'rtlAutoMirrored': rtlAutoMirrored,
      'popularity': popularity,
      'codepoint': codepoint,
      'categories': categories,
      'tags': tags,
    });
  }
}

/// List of all Categories - SymbolsMetadata() objects reference categories by their INDEX this table.
/// To get the category name, use `categoryMap[categoryIndexFromSymbolsMetadata]`
List<String> categoryMap = [
  "Audio&Video",
  "Images",
  "UI actions",
  "Social",
  "Android",
  "Maps",
  "Actions",
  "Communicate",
  "Household",
  "Business",
  "Home",
  "Hardware",
  "Text",
  "Privacy",
  "Transit",
  "Activities",
  "Travel",
];

/// List of all Tags - SymbolsMetadata() objects reference tags by their INDEX this table.
/// To get the tag name, use `tagMap[tagIndexFromSymbolsMetadata]`
List<String> tagMap = [
  "10000",
  "10K",
  "10k",
  "achievement",
  "alphabet",
  "analytics",
  "badge",
  "box",
  "character",
  "count",
  "data",
  "digit",
  "display",
  "followers",
  "font",
  "goal",
  "icon",
  "k",
  "label",
  "letters",
  "likes",
  "marker",
  "metric",
  "number",
  "numbers",
  "numeral",
  "pixel",
  "pixels",
  "progress",
  "quantity",
  "resolution",
  "social media",
  "square",
  "statistics",
  "subscribers",
  "symbol",
  "target",
  "ten thousand",
  "text",
  "thousand",
  "type",
  "video",
  "views",
  "10",
  "10 megapixel",
  "10 megapixels",
  "10mp",
  "camera",
  "camera icon",
  "camera settings",
  "digits",
  "high quality",
  "high resolution",
  "image",
  "image quality",
  "image resolution",
  "megapixel",
  "megapixels",
  "mp",
  "photo",
  "photo icon",
  "photography",
  "quality",
  "quality icon",
  "resolution icon",
  "settings",
  "settings icon",
  "video icon",
  "video resolution",
  "11",
  "11mp",
  "digital camera",
  "eleven megapixel",
  "photo quality",
  "picture resolution",
  "rectangle",
  "resolution settings",
  "rounded rectangle",
  "rounded square",
  "1",
  "123",
  "2",
  "3",
  "basic",
  "beginning",
  "cardinal",
  "counter",
  "counting",
  "digital",
  "elementary",
  "first",
  "index",
  "list",
  "numbering",
  "numerals",
  "one two three",
  "order",
  "ordinal",
  "organize",
  "prioritize",
  "queue",
  "rank",
  "rating",
  "second",
  "sequence",
  "simple",
  "sort",
  "stack",
  "start",
  "steps",
  "third",
  "12",
  "12 megapixel",
  "12mp",
  "camera resolution",
  "camera setting",
  "capture",
  "image size",
  "photo size",
  "picture",
  "picture size",
  "record",
  "sensor",
  "twelve",
  "13",
  "13mp",
  "lens",
  "thirteen megapixel",
  "14",
  "14 megapixel",
  "14mp",
  "camera spec",
  "details",
  "high quality image",
  "high quality photo",
  "information",
  "specification",
  "15",
  "15 megapixel",
  "15mp",
  "high-res",
  "photo resolution",
  "16",
  "16 megapixel",
  "16mp",
  "camera sensor",
  "sixteen",
  "17",
  "17mp",
  "camera quality",
  "picture quality",
  "seventeen megapixel",
  "18",
  "18+",
  "adult",
  "adults only",
  "age",
  "age limit",
  "age restriction",
  "content rating",
  "content warning",
  "eighteen",
  "eighteen plus",
  "explicit content",
  "mature",
  "no minors",
  "nsfw",
  "number in square",
  "over 18",
  "parental guidance",
  "pg-18",
  "restriction",
  "sensitive content",
  "under 18 not allowed",
  "x-rated",
  "18 megapixel",
  "18mp",
  "recording",
  "19",
  "19 megapixel",
  "19mp",
  "digital image",
  "photography icon",
  "1000",
  "1K",
  "1k",
  "abbreviation",
  "engagement",
  "indicator",
  "performance",
  "rounded corners",
  "total",
  "+",
  "1k plus",
  "community",
  "greater than one thousand",
  "growth",
  "influence",
  "milestone",
  "more than one thousand",
  "one thousand",
  "over one thousand",
  "plus",
  "popularity",
  "reach",
  "stats",
  "1x",
  "1x speed",
  "cellular",
  "cellular connection",
  "cellular data",
  "connection",
  "connectivity",
  "data connection",
  "data speed",
  "internet",
  "internet connection",
  "low signal",
  "low speed",
  "mobile",
  "mobile connectivity",
  "mobile network",
  "mobiledata",
  "network",
  "network speed",
  "one x",
  "phone",
  "signal",
  "signal strength",
  "slow",
  "slow connection",
  "speed",
  "weak signal",
  "wifi",
  "wireless",
  "wireless connection",
  "edge",
  "gprs",
  "internet speed",
  "limited connection",
  "mobile data connection",
  "mobile icon",
  "network status",
  "20",
  "20 megapixel",
  "20mp",
  "grid",
  "high quality picture",
  "resolution setting",
  "21",
  "21 megapixel",
  "21mp",
  "22",
  "22 megapixel",
  "22mp",
  "four squares",
  "hd",
  "high definition",
  "23",
  "23 megapixel",
  "23mp",
  "24 frames per second",
  "24fps",
  "30",
  "animation",
  "animation rate",
  "choose",
  "cinema",
  "configuration",
  "control",
  "film",
  "film settings",
  "film speed",
  "fps",
  "frame",
  "frame rate",
  "frames",
  "frequency",
  "movie",
  "movie player",
  "movie settings",
  "option",
  "per",
  "playback",
  "playback speed",
  "preference",
  "rate",
  "seconds",
  "select",
  "time",
  "timeline",
  "video player",
  "video settings",
  "video speed",
  "24",
  "24 megapixel",
  "24mp",
  "2d",
  "button",
  "design",
  "dimension",
  "dimensional",
  "drawing",
  "flat",
  "geometry",
  "graphics",
  "layout",
  "mode",
  "plane",
  "render",
  "setting",
  "shape",
  "surface",
  "switch",
  "toggle",
  "two",
  "two dimensional",
  "view",
  "1080p",
  "2000",
  "2048",
  "2048 x 1080",
  "2048p",
  "2K",
  "2k",
  "display settings",
  "media player",
  "monitor",
  "multimedia",
  "preferences",
  "screen",
  "screen resolution",
  "uhd",
  "ultra high definition",
  "video quality",
  "2k plus",
  "2k resolution",
  "download",
  "gaming",
  "greater than",
  "minimum",
  "more than",
  "streaming",
  "television",
  "tv",
  "two thousand",
  "upload",
  "2 megapixel",
  "2mp",
  "border",
  "cctv",
  "surveillance",
  "webcam",
  "30 frames per second",
  "30fps",
  "broadcast",
  "digital video",
  "fast motion",
  "frames per second",
  "high speed",
  "motion picture",
  "refresh rate",
  "slow motion",
  "time lapse",
  "video editing",
  "bars",
  "lines",
  "media",
  "media settings",
  "playback settings",
  "recording settings",
  "selection",
  "slider",
  "thirty",
  "three",
  "zero",
  "360",
  "all around",
  "angle",
  "ar",
  "arrow",
  "augmented reality",
  "av",
  "circle",
  "circular",
  "cycle",
  "cycling",
  "degree",
  "direction",
  "immersive",
  "loop",
  "looping",
  "panorama",
  "panoramic",
  "revolution",
  "revolve",
  "rotate",
  "rotation",
  "spherical",
  "spin",
  "spinning",
  "surround",
  "turn",
  "turning",
  "virtual reality",
  "vr",
  "3d",
  "D",
  "cube",
  "depth",
  "holographic",
  "model",
  "perspective",
  "spatial",
  "stereoscopic",
  "three dimensional",
  "three dimensions",
  "virtual_reality",
  "3d rotation",
  "arrows",
  "motion",
  "navigation",
  "object",
  "orbit",
  "refresh",
  "reload",
  "reset",
  "transform",
  "3g",
  "cellular network",
  "connection status",
  "generation three",
  "internet access",
  "mobile data",
  "mobile internet",
  "mobile technology",
  "network connection",
  "phone signal",
  "telecom",
  "telecommunication",
  "three bars",
  "three lines",
  "wireless network",
  "communication",
  "data indicator",
  "device",
  "smartphone",
  "tablet",
  "three g",
  "1440p",
  "2160p",
  "3000",
  "3000 pixels",
  "3K",
  "3k",
  "4k",
  "three thousand",
  "three thousand pixels",
  "amount",
  "limit",
  "statistic",
  "sum",
  "thousands",
  "value",
  "3 megapixel",
  "3mp",
  "medium resolution",
  "3p",
  "account",
  "alert",
  "avatar",
  "bubble",
  "chat",
  "comment",
  "communicate",
  "contact",
  "conversation",
  "dialog",
  "discussion",
  "face",
  "feedback",
  "forum",
  "help",
  "human",
  "info",
  "message",
  "notification",
  "party",
  "people",
  "person",
  "profile",
  "quote",
  "speak",
  "speech",
  "speech bubble",
  "support",
  "talk",
  "testimonial",
  "third person",
  "three people",
  "three person",
  "user",
  "4g",
  "4g lte",
  "broadband",
  "fourth generation",
  "high-speed",
  "lte",
  "reception",
  "4g+",
  "data plan",
  "enhanced 4g",
  "enhanced lte",
  "fast internet",
  "high speed data",
  "lte+",
  "mobile signal",
  "network signal",
  "4000",
  "4096p",
  "4K",
  "4k resolution",
  "four k",
  "ultra hd",
  "ultra high definition video",
  "4k+",
  "add",
  "better quality",
  "enhance",
  "feature",
  "improve",
  "premium",
  "subscription",
  "upgrade",
  "4",
  "4 megapixel",
  "4 megapixels",
  "4mp",
  "four",
  "four megapixel",
  "video recording",
  "50",
  "50 megapixel",
  "50mp",
  "clarity",
  "detail",
  "5g",
  "5g icon",
  "5g symbol",
  "five g",
  "network icon",
  "technology",
  "5g network",
  "status",
  "5000",
  "5K",
  "5k",
  "5k display",
  "5k resolution",
  "5k video",
  "five k",
  "5k plus",
  "five thousand",
  "threshold",
  "5",
  "5 megapixel",
  "5mp",
  "video setting",
  "60",
  "60fps",
  "high frame rate",
  "high performance",
  "sixty",
  "smooth motion",
  "video game",
  "chosen",
  "high refresh rate",
  "sixty fps",
  "video option",
  "video playback",
  "6",
  "6 feet",
  "6ft apart",
  "apart",
  "body",
  "coronavirus",
  "covid",
  "covid-19",
  "distance",
  "distancing",
  "feet",
  "figures",
  "ft",
  "gap",
  "guidelines",
  "health",
  "infection control",
  "measure",
  "pandemic",
  "prevention",
  "regulation",
  "rule",
  "safety",
  "sars-cov-2",
  "separation",
  "six feet",
  "six ft apart",
  "social",
  "social distancing",
  "space",
  "two figures",
  "two people",
  "6000",
  "6K",
  "6k",
  "6k resolution",
  "6k video",
  "8k",
  "monitor settings",
  "6k plus",
  "six k",
  "six k plus",
  "six thousand",
  "6 megapixel",
  "6 megapixels",
  "6mp",
  "7000",
  "7K",
  "7k",
  "seven k",
  "seven thousand",
  "7k resolution",
  "7k video",
  "kilo",
  "measurement",
  "unit",
  "7",
  "7 megapixel",
  "7 megapixels",
  "7mp",
  "number 7",
  "seven",
  "4320p",
  "8000",
  "8K",
  "8k video",
  "sharpness",
  "super high resolution",
  "video format",
  "8k plus icon",
  "8k resolution",
  "8k ultra hd",
  "8k+",
  "display resolution",
  "enhanced",
  "k plus",
  "options",
  "video options",
  "8",
  "8 megapixel",
  "8mp",
  "eight",
  "letters mp",
  "number 8",
  "9 kilobytes",
  "9000",
  "9K",
  "9k",
  "definition",
  "kilobytes",
  "nine k",
  "nine kilobytes",
  "nine thousand",
  "size",
  "storage",
  "9 thousand",
  "9k resolution",
  "9",
  "9 megapixel",
  "9 megapixels",
  "9mp",
  "digital photography",
  "nine",
  "number nine",
  "8-bit",
  "a",
  "abc",
  "acronym",
  "arcade",
  "b",
  "block letters",
  "c",
  "characters",
  "compose",
  "computer",
  "digital text",
  "edit",
  "game",
  "initialism",
  "monospace",
  "pixel font",
  "retro",
  "typography",
  "vintage",
  "writing",
  "ac",
  "ac unit",
  "air",
  "air conditioner",
  "air conditioning",
  "arctic",
  "chill",
  "climate",
  "climate control",
  "cold",
  "conditioner",
  "conditioning",
  "cool",
  "cooling",
  "fan",
  "flake",
  "freeze",
  "frosty",
  "hvac",
  "ice",
  "snow",
  "snowflake",
  "temperature",
  "temperature control",
  "thermostat",
  "ventilation",
  "weather",
  "winter",
  "accessibility",
  "accessible",
  "ada",
  "aid",
  "arms outstretched",
  "assistance",
  "assistive technology",
  "barrier-free",
  "disability",
  "diversity",
  "equal access",
  "handicap",
  "human figure",
  "impairment",
  "inclusion",
  "inclusive design",
  "section 508",
  "stick figure",
  "t-shape",
  "universal access",
  "wcag",
  "abstract person",
  "access",
  "accessibility new",
  "aoda",
  "assistive",
  "impaired",
  "inclusive",
  "inclusiveness",
  "inclusivity",
  "new",
  "open arms",
  "outstretched arms",
  "welcome",
  "disabled",
  "handicapped",
  "impaired mobility",
  "mobility",
  "person in wheelchair",
  "sitting",
  "wheel",
  "wheelchair",
  "advance",
  "continue",
  "forward",
  "move",
  "navigate",
  "next",
  "proceed",
  "right arrow",
  "a11y",
  "accessible design",
  "controls",
  "ellipsis",
  "expand",
  "menu",
  "more",
  "personal",
  "three dots",
  "user interface",
  "account balance",
  "balance",
  "bank",
  "banking",
  "bill",
  "building",
  "card",
  "cash",
  "coin",
  "columns",
  "commerce",
  "courthouse",
  "credit",
  "currency",
  "dollars",
  "finance",
  "financial",
  "financial institution",
  "funds",
  "government",
  "government building",
  "institution",
  "investment",
  "law",
  "legal",
  "money",
  "online",
  "pay",
  "payment",
  "pillars",
  "roof",
  "savings",
  "savings account",
  "three pillars",
  "billfold",
  "budget",
  "credit card",
  "debit card",
  "digital wallet",
  "dot",
  "e-wallet",
  "expenses",
  "flap",
  "online payment",
  "personal finance",
  "pocketbook",
  "pouch",
  "purchase",
  "shopping",
  "transaction",
  "wallet",
  "account box",
  "account settings",
  "bust",
  "contact information",
  "contacts",
  "head and shoulders",
  "identity",
  "inbox",
  "login",
  "member",
  "portrait",
  "profile settings",
  "registration",
  "signup",
  "thumbnail",
  "user information",
  "user profile",
  "add child",
  "child",
  "child account",
  "child profile",
  "children",
  "dependent",
  "family",
  "family account",
  "guardian",
  "kid",
  "kids",
  "manage child",
  "minor",
  "parent",
  "parental control",
  "parenting",
  "supervision",
  "under 18",
  "young",
  "youth",
  "invert",
  "underaged",
  "young person",
  "account circle",
  "individual",
  "my account",
  "person circle",
  "personal information",
  "round",
  "user account",
  "user circle",
  "access denied",
  "account disabled",
  "blocked",
  "cancel",
  "deactivate",
  "delete",
  "enabled",
  "forbidden",
  "hide",
  "inactive",
  "log out",
  "logout",
  "no account",
  "no profile",
  "no user",
  "off",
  "offline",
  "on",
  "profile disabled",
  "remove",
  "restricted",
  "sign out",
  "slash",
  "unavailable",
  "user disabled",
  "account tree",
  "blocks",
  "branches",
  "chart",
  "connect",
  "connected",
  "descendants",
  "diagram",
  "family tree",
  "flow",
  "flow chart",
  "genealogy",
  "graph",
  "group",
  "grouping",
  "hierarchy",
  "infographic",
  "levels",
  "link",
  "management",
  "metrics",
  "nested",
  "nodes",
  "organization",
  "organization chart",
  "process",
  "sitemap",
  "squares",
  "structure",
  "team",
  "tracking",
  "tree",
  "action",
  "action key",
  "activate",
  "buttons",
  "circles",
  "command",
  "discover",
  "dots",
  "execute",
  "explore",
  "filter",
  "find",
  "four circles",
  "four rings",
  "function",
  "glass",
  "hardware",
  "input",
  "investigate",
  "key",
  "keyboard",
  "keypad",
  "look",
  "lookup",
  "magnifier",
  "magnify",
  "magnifying",
  "magnifying glass",
  "operation",
  "perform",
  "query",
  "search",
  "see",
  "shortcut",
  "three circles",
  "three rings",
  "trigger",
  "zoom",
  "active area",
  "active zone",
  "activity",
  "activity ",
  "activity area",
  "activity zone",
  "area",
  "boundary",
  "contained area",
  "designated area",
  "four corners",
  "four points",
  "home",
  "linked",
  "location",
  "map",
  "mapping",
  "nest",
  "network zone",
  "perimeter",
  "range",
  "region",
  "restricted area",
  "scope",
  "security",
  "select area",
  "zone",
  "acute",
  "appointment",
  "clock",
  "date",
  "deadline",
  "delivery",
  "duration",
  "express",
  "fast",
  "history",
  "immediate",
  "instance",
  "occurrence",
  "quick",
  "rapid",
  "recent",
  "reminder",
  "schedule",
  "short-term",
  "timer",
  "urgent",
  "ad",
  "advert",
  "advertisement",
  "banner",
  "browser",
  "campaign",
  "commercial",
  "content",
  "digital marketing",
  "insert",
  "marketing",
  "online advertising",
  "paid content",
  "placeholder",
  "pop-up",
  "promotion",
  "sponsored",
  "web advertising",
  "website",
  "window",
  "ad group",
  "ads",
  "append",
  "attach",
  "audience",
  "banner multiple",
  "combine",
  "corner",
  "demographics",
  "join",
  "layered",
  "layers",
  "merge",
  "pane",
  "stacked",
  "tab",
  "targeting",
  "Ads",
  "advertising",
  "block",
  "cancelled",
  "deactivated",
  "disable",
  "hidden",
  "no ads",
  "no promotion",
  "overlay",
  "pause",
  "stop",
  "windows",
  "ad block",
  "ad blocker",
  "ad break off",
  "ad disabled",
  "ad_off",
  "advertisement disabled",
  "advertisement off",
  "advertising off",
  "block ad",
  "block advertisement",
  "disable ad",
  "disable ads",
  "disable advertisement",
  "hide ad",
  "hide advertisement",
  "no advertisement",
  "no advertising",
  "remove ad",
  "remove advertisement",
  "stop ad",
  "stop advertisement",
  "stop advertising",
  "turn off ads",
  "turn off advertisement",
  "Android",
  "OS",
  "ad management",
  "ad unit",
  "cell",
  "iOS",
  "message ad",
  "minus",
  "mobile ad",
  "mobile marketing",
  "mobile text ad",
  "notifications",
  "sms",
  "subtract",
  "text ad",
  "top",
  "units",
  "accounts",
  "adaptive",
  "adjust",
  "audio",
  "audio mesh",
  "auto",
  "automatic",
  "call",
  "committee",
  "conference",
  "dictation",
  "friends",
  "google meet",
  "hear",
  "hearing",
  "humans",
  "interview",
  "listen",
  "meet",
  "meeting",
  "mic",
  "microphone",
  "noise",
  "noise cancelling",
  "noise reduction",
  "persons",
  "podcast",
  "profiles",
  "recorder",
  "smart",
  "sound",
  "speaker",
  "transcription",
  "users",
  "video call",
  "voice",
  "voice chat",
  "adaptive audio",
  "mute",
  "muted",
  "no audio",
  "no mic",
  "no microphone",
  "no sound",
  "silence",
  "silent",
  "speaking",
  "video conference",
  "adb",
  "android",
  "android debug bridge",
  "android icon",
  "android logo",
  "android robot",
  "antenna",
  "app development",
  "bridge",
  "bugdroid",
  "debug",
  "debugging",
  "developer",
  "development tools",
  "eyes",
  "google",
  "head",
  "mobile development",
  "operating system",
  "os",
  "platform",
  "robot",
  "software",
  "addition",
  "arithmetic",
  "calculate",
  "center point",
  "create",
  "cross",
  "four way",
  "grow",
  "horizontal line",
  "include",
  "increase",
  "intersecting lines",
  "intersection",
  "math",
  "new symbol",
  "plus sign",
  "positive",
  "two lines",
  "vertical line",
  "enlarge",
  "increment",
  "intersect",
  "a photo",
  "add image",
  "add photo",
  "add picture",
  "add symbol",
  "image icon",
  "picture icon",
  "add ad",
  "add advertisement",
  "add page",
  "app",
  "application",
  "create ad",
  "create page",
  "digital ad",
  "new ad",
  "new advertisement",
  "new page",
  "online ad",
  "plus ad",
  "web ad",
  "web page",
  "webpage",
  "active",
  "add notification",
  "alarm",
  "announcement",
  "bell",
  "bell plus",
  "chime",
  "create alert",
  "follow",
  "important",
  "new alert",
  "notification bell",
  "notify",
  "plus bell",
  "register",
  "ring",
  "subscribe",
  "subscribe to alerts",
  "update",
  "warning",
  "add box",
  "add container",
  "add item",
  "add square",
  "add to collection",
  "add to list",
  "append item",
  "container",
  "create container",
  "create new",
  "include item",
  "insert item",
  "new box",
  "new item",
  "new square",
  "plus box",
  "plus square",
  "add business",
  "add company",
  "add shop",
  "add store",
  "awning",
  "business",
  "company",
  "create business",
  "create company",
  "create shop",
  "create store",
  "local business",
  "market",
  "marketplace",
  "new business",
  "new shop",
  "new store",
  "retail",
  "shop",
  "store",
  "storefront",
  "vendor",
  "add call",
  "add participant",
  "add phone",
  "add to call",
  "communication plus",
  "conference call",
  "create call",
  "dial",
  "handset",
  "initiate call",
  "invite",
  "join call",
  "join conference",
  "merge call",
  "new call",
  "phone plus",
  "plus phone",
  "receiver",
  "start call",
  "telephone",
  "add credit card",
  "add debit card",
  "add payment",
  "attach card",
  "billing",
  "checkout",
  "cost",
  "credit card details",
  "ecommerce",
  "include card",
  "insert card",
  "link card",
  "new card",
  "new payment",
  "payment details",
  "payment method",
  "price",
  "register card",
  "add bar chart",
  "add chart",
  "add document",
  "add graph",
  "bar",
  "bar chart",
  "bar graph",
  "create chart",
  "document",
  "insert chart",
  "new chart",
  "new document",
  "plus chart",
  "plus graph",
  "report",
  "reporting",
  "visualization",
  "add circle",
  "add new",
  "circle plus",
  "circles add",
  "control point",
  "outline",
  "plus circle",
  "point",
  "unknown",
  "add column",
  "add left",
  "arrange",
  "column",
  "column left",
  "divide",
  "editor",
  "format",
  "insert column",
  "insert left",
  "left",
  "rows",
  "section",
  "split",
  "spreadsheet",
  "table",
  "vertical",
  "add right",
  "add section",
  "column right",
  "expand grid",
  "expand layout",
  "grid layout",
  "increase grid",
  "increase layout",
  "insert right",
  "layout grid",
  "new column",
  "new section",
  "plus column",
  "plus right",
  "right",
  "section layout",
  "table grid",
  "add message",
  "blog",
  "chat bubble",
  "create comment",
  "create message",
  "insert comment",
  "insert message",
  "message bubble",
  "new comment",
  "new message",
  "post",
  "reply",
  "respond",
  "submit",
  "45 degrees",
  "add diamond",
  "create diamond",
  "diamond",
  "diamond shape",
  "gem",
  "insert diamond",
  "new diamond",
  "rhombus",
  "rotated diamond",
  "rotated square",
  "tilted square",
  "add address",
  "add home",
  "add property",
  "add residence",
  "address",
  "create home",
  "create house",
  "create property",
  "domestic",
  "dwelling",
  "house",
  "household",
  "new home",
  "new house",
  "new property",
  "new residence",
  "plus home",
  "plus house",
  "primary residence",
  "property",
  "real estate",
  "residence",
  "set home",
  "add building",
  "add house",
  "add work",
  "create building",
  "create work",
  "homework",
  "new building",
  "new work",
  "office",
  "plus building",
  "plus work",
  "work",
  "workplace",
  "add connection",
  "add link",
  "add url",
  "add website",
  "attach link",
  "attachment",
  "chain",
  "chain link",
  "clip",
  "create link",
  "external link",
  "hyperlink",
  "insert hyperlink",
  "insert link",
  "link icon",
  "new connection",
  "new link",
  "plus link",
  "url",
  "web link",
  "add location",
  "add marker",
  "current location",
  "destination",
  "drop pin",
  "geolocation",
  "geotag",
  "gps",
  "locate",
  "maps",
  "mark location",
  "new location",
  "pin",
  "pinpoint",
  "place",
  "position",
  "save location",
  "set location",
  "alt",
  "drop",
  "itinerary",
  "plus location",
  "route",
  "travel",
  "add moderator",
  "add user",
  "admin",
  "administrator",
  "assign",
  "certified",
  "grant",
  "moderator",
  "new moderator",
  "permission",
  "plus shield",
  "privacy",
  "private",
  "promote",
  "protect",
  "protection",
  "role",
  "shield",
  "verified",
  "add note",
  "compose note",
  "create document",
  "create note",
  "doc",
  "edit note",
  "file",
  "new note",
  "note",
  "notes",
  "page",
  "paper",
  "write",
  "write note",
  "album",
  "alternate",
  "contribute",
  "gallery",
  "import",
  "landscape",
  "mountain",
  "mountains",
  "scenery",
  "add reaction",
  "agree",
  "approve",
  "emoji",
  "emoticon",
  "emotion",
  "emotions",
  "expressions",
  "feelings",
  "glad",
  "happiness",
  "happy",
  "icons",
  "like",
  "mood",
  "new reaction",
  "pleased",
  "reaction",
  "response",
  "sentiment",
  "smile",
  "smiley",
  "smiling",
  "survey",
  "add destination",
  "add path",
  "add route",
  "add street",
  "create road",
  "create route",
  "dashed line",
  "directions",
  "dotted line",
  "highway",
  "journey",
  "new path",
  "new road",
  "new route",
  "new street",
  "path",
  "road",
  "route planning",
  "street",
  "traffic",
  "trip",
  "vertical lines",
  "above",
  "add above",
  "add line",
  "add row",
  "entry",
  "form",
  "insert above",
  "insert line",
  "insert row",
  "line",
  "row",
  "spreadsheet row",
  "table row",
  "add below",
  "data grid",
  "insert below",
  "line below",
  "new line",
  "new row",
  "row below",
  "add to basket",
  "add to cart",
  "add to shopping cart",
  "basket",
  "basket plus",
  "buy",
  "cart",
  "item",
  "online shopping",
  "product",
  "purchase item",
  "shopping cart plus",
  "trolley",
  "trolley plus",
  "accept",
  "add task",
  "assign task",
  "check",
  "checklist",
  "checkmark",
  "complete",
  "complete task",
  "completed",
  "confirm",
  "confirm task",
  "create task",
  "done",
  "finish",
  "mark",
  "new task",
  "ok",
  "project management",
  "task",
  "task management",
  "tick",
  "to do",
  "to-do",
  "yes",
  "backup",
  "cloud",
  "cloud upload",
  "drive",
  "files",
  "folder",
  "folders",
  "gdrive",
  "geometric",
  "google drive",
  "hexagon",
  "polygon",
  "recovery",
  "save",
  "share",
  "six sides",
  "sync",
  "add to",
  "add to home screen",
  "bookmark",
  "diagonal arrow",
  "export",
  "fullscreen",
  "install",
  "mobile device",
  "up",
  "up arrow",
  "add movie",
  "add program",
  "add to playlist",
  "add to queue",
  "add to watchlist",
  "add video",
  "chrome",
  "desktop",
  "enqueue",
  "mac",
  "task list",
  "to",
  "watch later",
  "web",
  "add triangle",
  "caution",
  "delta",
  "mid trip",
  "obstacle",
  "plus triangle",
  "pyramid",
  "slowdown",
  "three sides",
  "triangle",
  "triangle add",
  "triangle plus",
  "trigon",
  "adf",
  "all-in-one",
  "copy",
  "copy machine",
  "digitize",
  "document scanner",
  "electronics",
  "fax",
  "fax machine",
  "feeder",
  "flatbed scanner",
  "image scanner",
  "machine",
  "multifunction",
  "output",
  "peripherals",
  "print",
  "printer",
  "scan",
  "scanner",
  "accuracy",
  "alter",
  "auto click",
  "brightness",
  "calibrate",
  "center",
  "change",
  "concentric circles",
  "configure",
  "contrast",
  "customize",
  "dials",
  "fix",
  "focus",
  "knobs",
  "modify",
  "precision",
  "refinement",
  "sliders",
  "tune",
  "volume",
  "administer",
  "administration",
  "capsule",
  "clinic",
  "clipboard",
  "doctor",
  "drugs",
  "healthcare",
  "hospital",
  "manage",
  "med",
  "medical",
  "medical record",
  "medication",
  "medicine",
  "nurse",
  "patient",
  "pharmacy",
  "pill",
  "prescription",
  "rx",
  "admin settings",
  "authentication",
  "authorization",
  "panel",
  "pentagon",
  "safe",
  "secure",
  "user settings",
  "bullseye",
  "click",
  "clicks",
  "conversion",
  "cost per click",
  "cpc",
  "cursor",
  "pay per click",
  "pointer",
  "ppc",
  "propagation",
  "rings",
  "ripple",
  "agender",
  "combined symbol",
  "female",
  "gender",
  "gender expression",
  "gender identity",
  "gender neutrality",
  "gender symbol",
  "genderfree",
  "genderless",
  "genderqueer",
  "lgbt",
  "lgbtq",
  "lgbtq+",
  "lgbtqia",
  "male",
  "neutral",
  "neutrois",
  "no gender",
  "non-binary",
  "pride",
  "sexless",
  "without gender",
  "agricultural machinery",
  "agriculture",
  "agriculture icon",
  "automobile",
  "car",
  "cars",
  "countryside",
  "countryside icon",
  "crop",
  "cultivate",
  "cultivation",
  "farm",
  "farm equipment",
  "farmer",
  "farming",
  "farming icon",
  "field",
  "field icon",
  "food",
  "grow icon",
  "harvest",
  "harvest icon",
  "land",
  "machinery",
  "plant",
  "plant icon",
  "produce",
  "rural",
  "soil",
  "tractor",
  "tractor icon",
  "transport",
  "truck",
  "vehicle",
  "aerodynamics",
  "airflow",
  "atmosphere",
  "blow",
  "blowing",
  "breeze",
  "current",
  "curves",
  "draft",
  "gas",
  "gust",
  "invisible",
  "meteorology",
  "movement",
  "nature",
  "outdoor",
  "swirls",
  "wave",
  "wind",
  "aerosol",
  "air freshener",
  "air purifier",
  "aroma",
  "bathroom",
  "bottle",
  "bottler",
  "clean",
  "deodorant",
  "dispenser",
  "fragrance",
  "fragrance diffuser",
  "fresh",
  "mist",
  "odor",
  "perfume",
  "room spray",
  "scent",
  "smell",
  "spray",
  "spray bottle",
  "toilet",
  "air flow",
  "air quality",
  "appliance",
  "cleaner",
  "environment",
  "filtration",
  "fresh air",
  "freshener",
  "healthy air",
  "home appliance",
  "internet of things",
  "iot",
  "pure air",
  "purifier",
  "purify",
  "smart home",
  "waves",
  "air cleaning",
  "humidity",
  "wellness",
  "aircraft",
  "airline",
  "airplane seat",
  "bed",
  "book",
  "business class",
  "chair",
  "class",
  "comfort",
  "cushion",
  "first class",
  "flight",
  "fly",
  "headrest",
  "legroom",
  "lie flat",
  "passenger",
  "recline",
  "reservation",
  "rest",
  "seat",
  "seat selection",
  "select seat",
  "sleep",
  "transportation",
  "airline seat",
  "airplane",
  "angled",
  "angled seat",
  "aviation",
  "booking",
  "economy",
  "flat seat",
  "aisle seat",
  "amenity",
  "armrest",
  "check-in",
  "compartment",
  "luxury",
  "pod",
  "reclined seat",
  "single seat",
  "suite",
  "window seat",
  "aeroplane",
  "extra",
  "extra legroom",
  "extra space",
  "foot",
  "leg",
  "more space",
  "reclining",
  "relax",
  "relaxation",
  "room",
  "sit",
  "spacious",
  "travel comfort",
  "furniture",
  "leg space",
  "normal",
  "pictogram",
  "standard",
  "basic economy",
  "cramped",
  "crowded",
  "discomfort",
  "flying",
  "knee room",
  "limited",
  "no legroom",
  "personal space",
  "reduced",
  "small",
  "tight",
  "travel planning",
  "uncomfortable",
  "adjustable seat",
  "extra recline",
  "lean back",
  "reclining seat",
  "choose seat",
  "flight settings",
  "person sitting",
  "seat adjustment",
  "travel settings",
  "upright",
  "airline stops",
  "branch",
  "connecting flights",
  "curved line",
  "detour",
  "divert",
  "flight stops",
  "fork",
  "indirect",
  "layover",
  "layovers",
  "multiple stops",
  "stops",
  "straight line",
  "transfer",
  "transit",
  "two paths",
  "air travel",
  "airlines",
  "airplanes",
  "airport",
  "arrival",
  "cockpit",
  "departure",
  "flights",
  "holiday",
  "parallelogram",
  "planes",
  "porthole",
  "ticket",
  "tourism",
  "vacation",
  "airplane ticket",
  "boarding",
  "boarding pass",
  "pass",
  "plane icon",
  "travel document",
  "airplane disabled",
  "airplane inactive",
  "airplane mode",
  "airplane mode off",
  "bluetooth off",
  "cellular off",
  "disconnected",
  "flight disabled",
  "flight mode",
  "flight mode off",
  "network off",
  "no airplane mode",
  "no connection",
  "no flight",
  "no signal",
  "offline mode",
  "radio off",
  "signals off",
  "wifi off",
  "wireless off",
  "airplay",
  "arrow up",
  "cast",
  "external display",
  "projector",
  "screen mirroring",
  "stream",
  "streaming media",
  "wireless display",
  "airport shuttle",
  "airport transfer",
  "bus",
  "commute",
  "drop off",
  "four wheels",
  "ground transportation",
  "hotel shuttle",
  "mini",
  "minivan",
  "pick up",
  "public",
  "ride",
  "shuttle",
  "side view",
  "two windows",
  "van",
  "airware",
  "airwave",
  "curved lines",
  "horizontal lines",
  "music",
  "oscillation",
  "radio",
  "signals",
  "transmission",
  "vibration",
  "access alarms",
  "access_alarm",
  "access_alarms",
  "alarms",
  "bells",
  "countdown",
  "due date",
  "event",
  "hour",
  "minute",
  "morning",
  "ringing",
  "time management",
  "wake",
  "wake up",
  "watch",
  "add alarm",
  "add time",
  "create alarm",
  "new alarm",
  "planning",
  "set alarm",
  "alarm cancelled",
  "alarm disabled",
  "alarm inactive",
  "alarm off",
  "bell off",
  "bell silenced",
  "cancel alarm",
  "clock disabled",
  "clock off",
  "deactivate alarm",
  "disable alarm",
  "mute alarm",
  "no alarm",
  "notification off",
  "quiet",
  "reminder off",
  "silence alarm",
  "strikethrough",
  "time off",
  "timer off",
  "turn off alarm",
  "alarm active",
  "alarm clock",
  "alarm on",
  "alarm set",
  "scheduled",
  "bedside",
  "break",
  "delay",
  "double lines",
  "hold",
  "interrupt",
  "pause button",
  "postpone",
  "resume",
  "snooze",
  "temporary stop",
  "two bars",
  "wait",
  "automation",
  "intelligent",
  "smart alarm",
  "archive",
  "artist",
  "bvb",
  "cd",
  "collection",
  "disc",
  "disk",
  "gramophone",
  "library",
  "lp",
  "phonograph",
  "play",
  "playlist",
  "song",
  "track",
  "vinyl",
  "align",
  "align center",
  "alignment",
  "arrangement",
  "center align",
  "content alignment",
  "distribute",
  "equal",
  "formatting",
  "horizontal",
  "horizontal alignment",
  "justify",
  "middle",
  "paragraph",
  "rules",
  "style",
  "text alignment",
  "text edit",
  "word processing",
  "align end",
  "align right",
  "bottom",
  "end",
  "flush right",
  "horizontal align",
  "justify end",
  "justify right",
  "right align",
  "right alignment",
  "text align",
  "text right",
  "vertical align",
  "vertical alignment",
  "crosshair",
  "equidistant",
  "flex",
  "flexible",
  "justify center",
  "midpoint",
  "symmetry",
  "align bottom",
  "align to bottom",
  "bottom alignment",
  "distribution",
  "flex end",
  "flexbox",
  "align items",
  "align top",
  "flex start",
  "justify content",
  "justify start",
  "justify top",
  "text top",
  "top align",
  "top left",
  "word processor",
  "content organization",
  "document formatting",
  "justify left",
  "left align",
  "page layout",
  "paragraph alignment",
  "text editor",
  "text formatting",
  "text left",
  "arrange right",
  "horizontal align right",
  "horizontal alignment right",
  "move right",
  "right justified",
  "shift right",
  "side",
  "align_items",
  "equal height",
  "equal width",
  "fit",
  "full height",
  "full width",
  "items",
  "justification",
  "resize",
  "spacing",
  "stretch",
  "equal spacing",
  "three columns",
  "three rectangles",
  "vertical bars",
  "flex-end",
  "justify-content",
  "text-align-right",
  "paragraph formatting",
  "rectangles",
  "space around",
  "edges",
  "horizontal spacing",
  "margins",
  "padding",
  "separate",
  "space between",
  "text justify",
  "text spacing",
  "vertical spacing",
  "even",
  "justify space even",
  "typesetting",
  "content editing",
  "fit to width",
  "text justification",
  "text stretch",
  "adapt",
  "align self",
  "content fitting",
  "fill",
  "responsive",
  "scale",
  "self stretch",
  "vertical stretch",
  "around",
  "horizontal distribution",
  "horizontal space",
  "paragraph spacing",
  "vertical distribution",
  "vertical space",
  "equal distance",
  "horizontal distribute",
  "justify space",
  "organize horizontally",
  "parallel",
  "parallel lines",
  "three horizontal lines",
  "align left",
  "align start",
  "editing",
  "16:9",
  "aspect ratio",
  "capital h",
  "h",
  "horizontal scale",
  "horizontal stretch",
  "letterbox",
  "maximize",
  "pillarbox",
  "widescreen",
  "arrange vertical",
  "baseline",
  "bottom align",
  "bottom justification",
  "justify bottom",
  "lower",
  "vertical bottom",
  "vertical justification",
  "centering",
  "equilibrium",
  "vertical center",
  "align vertical",
  "column alignment",
  "text layout",
  "Inbox",
  "all",
  "all inbox",
  "archive all",
  "collect",
  "collect all",
  "combined",
  "correspondence",
  "curve",
  "delivered",
  "download all",
  "email",
  "gather",
  "gather all",
  "incoming",
  "integrated",
  "mail",
  "messages",
  "receive",
  "send",
  "tray",
  "unified",
  "all inclusive",
  "boundless",
  "circulation",
  "continuous",
  "endless",
  "eternity",
  "everything",
  "figure eight",
  "forever",
  "included",
  "infinite",
  "infinity",
  "limitless",
  "mobius",
  "mobius strip",
  "neverending",
  "no limits",
  "ongoing",
  "package deal",
  "perpetual",
  "recurring",
  "repeat",
  "ribbon",
  "strip",
  "sustainability",
  "sustainable",
  "unending",
  "unlimited",
  "all match",
  "calculation",
  "correct",
  "equation",
  "formula",
  "match",
  "mathematics",
  "select all",
  "sigma",
  "summation",
  "tag",
  "valid",
  "validate",
  "validation",
  "verification",
  "verify",
  "all out",
  "corners",
  "expand outwards",
  "fit to screen",
  "fit to window",
  "full screen",
  "increase size",
  "make bigger",
  "out",
  "outwards",
  "presentation",
  "scale up",
  "windowed mode",
  "zoom in",
  "zoom out",
  "allergen",
  "allergic",
  "allergies",
  "allergy",
  "antibodies",
  "antibody",
  "antibody test",
  "biology",
  "diagnosis",
  "disease",
  "health condition",
  "illness",
  "immune",
  "immune system",
  "immunoglobulin",
  "immunology",
  "intolerance",
  "pollen",
  "protein",
  "science",
  "sensitivity",
  "sickness",
  "symptom",
  "treatment",
  "y-shaped",
  "airway",
  "asthma",
  "dust",
  "flower",
  "inflammation",
  "irritation",
  "respiratory",
  "spores",
  "spread",
  "spring",
  "alt_route",
  "alternate route",
  "alternative",
  "alternative route",
  "arrow fork",
  "arrow split",
  "branching arrows",
  "choice",
  "dash",
  "dashed",
  "double arrow",
  "other",
  "reroute",
  "route change",
  "routes",
  "two arrows",
  "way",
  "@",
  "alternate email",
  "at sign",
  "at symbol",
  "electronic mail",
  "secondary email",
  "spiral",
  "adventure",
  "altitude",
  "ascend",
  "climb",
  "elevation",
  "geography",
  "height",
  "high",
  "level",
  "level up",
  "peak",
  "rise",
  "sea",
  "terrain",
  "topography",
  "ambulance",
  "approved",
  "confirmed",
  "emergency",
  "emergency lights",
  "lights",
  "siren",
  "sos",
  "success",
  "amend",
  "back",
  "circular arrow",
  "document edit",
  "redo",
  "refine",
  "renew",
  "return",
  "revert",
  "revise",
  "underline",
  "undo",
  "amp",
  "article",
  "feed",
  "news",
  "publish",
  "publishing",
  "read",
  "reading",
  "sidebars",
  "stories",
  "story",
  "trio",
  "viewing",
  "analysis",
  "assessment",
  "dashboard",
  "insights",
  "key performance indicator",
  "kpi",
  "visualize",
  "anchor",
  "boat",
  "dock",
  "equipment",
  "fastener",
  "fixed",
  "harbor",
  "hook",
  "logo",
  "marine",
  "maritime",
  "mooring",
  "nautical",
  "ocean",
  "port",
  "ship",
  "stability",
  "tool",
  "bot",
  "brand",
  "humanoid",
  "mascot",
  "semicircle",
  "toy",
  "animated gif",
  "animated_images",
  "cinemagraph",
  "dynamic",
  "frame animation",
  "gemini",
  "generate",
  "gif",
  "gifs",
  "image carousel",
  "image sequence",
  "moving image",
  "moving picture",
  "multiple",
  "multiple images",
  "overlapping",
  "prints",
  "short video",
  "slideshow",
  "videos",
  "animated",
  "buffer",
  "concentric",
  "effect",
  "loading",
  "rotating",
  "series",
  "transition",
  "visual effect",
  "always",
  "always on display",
  "aod",
  "cellphone",
  "content display",
  "homescreen",
  "mobile content",
  "mobile info",
  "mobile message",
  "mobile notification",
  "mobile text",
  "borders",
  "portable",
  "stripes",
  "accessory",
  "band",
  "digital watch",
  "gadget",
  "smartwatch",
  "strap",
  "tracker",
  "wearable",
  "wearable tech",
  "wearables",
  "wrist",
  "wristwatch",
  "accommodation",
  "apartment",
  "architecture",
  "city",
  "condominium",
  "door",
  "estate",
  "high rise",
  "hotel",
  "housing",
  "lease",
  "lodging",
  "motel",
  "multi-story",
  "places",
  "real",
  "rental",
  "residential",
  "shelter",
  "skyscraper",
  "three sections",
  "tower",
  "urban",
  "api",
  "application programming interface",
  "code",
  "development",
  "enterprise",
  "exchange",
  "external",
  "integration",
  "programming",
  "service",
  "system",
  "android application",
  "android document",
  "android file",
  "android package",
  "android setup",
  "android software",
  "apk",
  "apk document",
  "apk file",
  "app download",
  "app install",
  "installation",
  "mobile app",
  "mobile software",
  "package",
  "program",
  "setup",
  "arrow down",
  "down",
  "get",
  "open",
  "alerts",
  "app badge",
  "app icon",
  "apps",
  "badging",
  "incomplete",
  "new messages",
  "notification badge",
  "notification icon",
  "reminder icon",
  "unread",
  "unread messages",
  "updates available",
  "app block",
  "app management",
  "app security",
  "blocking",
  "device block",
  "device lock",
  "device management",
  "lock",
  "mobile block",
  "mobile management",
  "mobile security",
  "no access",
  "no mobile",
  "no phone",
  "no symbol",
  "phone lock",
  "prohibition",
  "stopped",
  "app registration",
  "app settings",
  "apply",
  "create account",
  "edit app",
  "enroll",
  "enrollment",
  "new account",
  "pen",
  "pencil",
  "personalize",
  "sign up",
  "apparel",
  "attire",
  "blouse",
  "casual",
  "clothes",
  "clothing",
  "cotton",
  "fabric",
  "fashion",
  "garment",
  "outfit",
  "shirt",
  "short sleeves",
  "sleeve",
  "t-shirt",
  "tee",
  "textile",
  "wardrobe",
  "wear",
  "acceptance",
  "approval",
  "approvals",
  "certificate",
  "certification",
  "checkpoint",
  "disapproval",
  "dropoff",
  "impression",
  "ink",
  "location tag",
  "postage",
  "stamp",
  "submission",
  "authority",
  "authorize",
  "delegation",
  "empowerment",
  "fingers",
  "gesture",
  "give",
  "giving",
  "hand",
  "handoff",
  "handover",
  "hands",
  "offer",
  "palm",
  "responsibility",
  "trust",
  "workflow",
  "app drawer",
  "app store",
  "applications",
  "components",
  "interface",
  "launcher",
  "matrix",
  "programs",
  "services",
  "tools",
  "ui",
  "utilities",
  "ux",
  "app launcher",
  "app menu",
  "application error",
  "application outage",
  "apps down",
  "crash",
  "error",
  "exclamation",
  "failure",
  "issue",
  "maintenance",
  "outage",
  "problem",
  "service unavailable",
  "system error",
  "a and q",
  "aq",
  "bismuth",
  "bold",
  "branding",
  "initials",
  "letter a",
  "letter q",
  "monogram",
  "pollutants",
  "pollution",
  "sans serif",
  "text icon",
  "two letters",
  "uppercase",
  "fluid",
  "house icon",
  "iaq",
  "indoor",
  "indoor air quality",
  "inside",
  "interior",
  "leak",
  "liquid",
  "moisture",
  "plumbing",
  "water",
  "waves icon",
  "ar_on_you",
  "detect",
  "detection",
  "face recognition",
  "face tracking",
  "facial recognition",
  "identification",
  "identify",
  "image capture",
  "scanning",
  "selfie",
  "viewfinder",
  "you",
  "ar location",
  "ar object",
  "ar sticker placement",
  "fun",
  "placement",
  "playful",
  "playground",
  "reality",
  "sticker",
  "stickers",
  "virtual",
  "arc",
  "architect",
  "art",
  "blueprint",
  "compass",
  "construction",
  "drafting",
  "draw",
  "engineering",
  "instrument",
  "mechanical",
  "plan",
  "technical",
  "down arrow",
  "past",
  "put away",
  "repository",
  "retrieve",
  "area chart",
  "area graph",
  "data visualization",
  "line graph",
  "mountain chart",
  "polygon chart",
  "results",
  "trend",
  "arming",
  "defense",
  "enable",
  "guard",
  "initialization",
  "pending",
  "preparing",
  "starting",
  "branched",
  "chevron",
  "inbound",
  "inverted y",
  "pathway",
  "DISABLE_IOS",
  "arrow back",
  "arrow left",
  "back arrow",
  "backward",
  "caret",
  "disable_ios",
  "go back",
  "last",
  "left arrow",
  "previous",
  "previous page",
  "prior",
  "retrace",
  "return arrow",
  "reverse",
  "site",
  "arrowhead",
  "earlier",
  "last page",
  "rewind",
  "step back",
  "ios",
  "angled lines",
  "angular",
  "arrow circle",
  "arrow in circle",
  "caret circle",
  "caret in circle",
  "circled arrow",
  "collapse",
  "download icon",
  "move down",
  "scroll",
  "scroll down",
  "back button",
  "circle arrow",
  "media control",
  "player",
  "previous button",
  "previous track",
  "clockwise",
  "clockwise rotation",
  "enter",
  "go",
  "right arrow in circle",
  "rotate right",
  "sign in",
  "back to top",
  "scroll up",
  "upward",
  "upwards",
  "breathe",
  "contract",
  "cool down",
  "cool off",
  "decrease",
  "descending",
  "downward",
  "exercise",
  "fitbit",
  "fitness",
  "minimize",
  "point down",
  "reduce",
  "routine",
  "running",
  "shrink",
  "slow down",
  "south",
  "three squares",
  "descend",
  "drop down",
  "triangle down",
  "below",
  "dropdown",
  "under",
  "arrowhead down",
  "caret down",
  "drop down arrow",
  "dropdown arrow",
  "expand more",
  "reveal",
  "unfold",
  "close",
  "drop-down menu",
  "dropdown menu",
  "expand menu",
  "arrow drop up",
  "drop up",
  "expand up",
  "higher",
  "move up",
  "arrow forward",
  "arrow head",
  "direction indicator",
  "following",
  "angle bracket",
  "apple",
  "arrow forward ios",
  "skip",
  "subsequent",
  "arrow insert",
  "diagonal",
  "embed",
  "ingress",
  "northwest",
  "leftward",
  "move left",
  "turn left",
  "arrow left alt",
  "directional arrow",
  "retreat",
  "shift left",
  "arrow and line",
  "close panel",
  "collapse menu",
  "drawer",
  "drawer close",
  "exit",
  "hamburger",
  "hide menu",
  "menu close",
  "minimize menu",
  "nav",
  "panel close",
  "retract",
  "sidebar",
  "sidebar close",
  "disclose",
  "extend",
  "show",
  "double down arrow",
  "duplicate",
  "pair",
  "pull",
  "two down arrows",
  "new window",
  "outward",
  "back and forth",
  "between",
  "drag",
  "forth",
  "length",
  "opposite arrows",
  "opposite direction",
  "push",
  "shorten",
  "width",
  "arrow right alt",
  "east",
  "pointing",
  "right direction",
  "highlight",
  "mouse",
  "pick",
  "picker",
  "polyline",
  "sharp",
  "vector",
  "branching",
  "decision",
  "diverge",
  "diverging",
  "pathways",
  "two-way",
  "variant",
  "arrow left up",
  "arrow top left",
  "backwards",
  "shift",
  "up left",
  "upstairs",
  "west",
  "arrow icon",
  "arrow top right",
  "bend",
  "direction icon",
  "minimalist arrow",
  "navigation icon",
  "right angle",
  "simple arrow",
  "top right",
  "contributing",
  "data transfer",
  "exporting",
  "file transfer",
  "incomplete circle",
  "loading indicator",
  "pie chart",
  "progress indicator",
  "sending",
  "sharing",
  "submitting",
  "transferring",
  "uploading",
  "uploads",
  "available",
  "deploy",
  "finished",
  "online upload",
  "ready",
  "release",
  "upload ready",
  "north",
  "arrow upward alternative",
  "upward arrow alt",
  "attention",
  "boot",
  "exclamation point",
  "heat",
  "heating up",
  "hot",
  "initialize",
  "launch",
  "preparation",
  "warm up",
  "warmth",
  "warmup",
  "centralize",
  "compress",
  "consolidate",
  "converge",
  "four arrows",
  "fullscreen exit",
  "in",
  "inward",
  "scale down",
  "window resize",
  "cascade",
  "expand all",
  "overflow",
  "reveal all",
  "show all",
  "two ls",
  "disclosure",
  "expand section",
  "show more",
  "explode",
  "angle brackets",
  "arrow out",
  "arrows outward",
  "double",
  "expand outward",
  "widen",
  "art track",
  "tracks",
  "digital document",
  "text document",
  "assignment",
  "author",
  "contributor",
  "membership",
  "owner",
  "writer",
  "curved arrow",
  "query reference",
  "quick access",
  "reference",
  "artist profile",
  "composer",
  "content creator",
  "creator",
  "music account",
  "music creator",
  "music library",
  "music note",
  "music profile",
  "musical",
  "musical artist",
  "musician",
  "my music",
  "performer",
  "personal music",
  "singer",
  "user music",
  "4:3",
  "aspect",
  "display ratio",
  "image editing",
  "image ratio",
  "orientation",
  "proportions",
  "ratio",
  "screen ratio",
  "screen settings",
  "screen size",
  "education",
  "exam",
  "notepad",
  "project",
  "quiz",
  "school",
  "tasks",
  "test",
  "to do list",
  "request",
  "assign user",
  "assignment card",
  "delegate",
  "employee",
  "id",
  "id card",
  "ind",
  "job",
  "person card",
  "person icon",
  "profile card",
  "user assignment",
  "!",
  "danger",
  "exclamation mark",
  "late",
  "missed",
  "overdue",
  "correction",
  "grading",
  "retun",
  "review",
  "send back",
  "give back",
  "hand in",
  "returned",
  "turn in",
  "assignment complete",
  "finished task",
  "submit assignment",
  "turned in",
  "aged",
  "aging",
  "assist",
  "eldercare",
  "elderly",
  "independence",
  "injured",
  "injury",
  "mobility device",
  "rehabilitation",
  "rolling walker",
  "senior",
  "walk",
  "walker",
  "walking aid",
  "zimmer frame",
  "IoT",
  "ai",
  "artificial intelligence",
  "assistant",
  "assistant device",
  "digital assistant",
  "electronic",
  "home assistant",
  "home device",
  "smart speaker",
  "virtual assistant",
  "voice assistant",
  "voice control",
  "assistant direction",
  "direction assistant",
  "guidance",
  "guide",
  "right turn",
  "routing",
  "wayfinding",
  "straight",
  "ai assistant",
  "assistant on hub",
  "console",
  "control panel",
  "home automation",
  "hub",
  "smart device",
  "smart hub",
  "assured",
  "assured workload",
  "compliance",
  "confidential",
  "data integrity",
  "data protection",
  "data security",
  "enterprise security",
  "federal",
  "regulatory compliance",
  "risk management",
  "secure data",
  "secure workload",
  "sensitive regulatory",
  "workload",
  "annotation",
  "asterisk",
  "eight-pointed asterisk",
  "eight-pointed star",
  "emphasis",
  "footnote",
  "multiplication",
  "multiply",
  "operator",
  "special character",
  "star",
  "times",
  "wildcard",
  "atm",
  "automated",
  "automated teller machine",
  "automatic teller machine",
  "bank machine",
  "banking machine",
  "cash machine",
  "deposit",
  "money machine",
  "pixelated",
  "teller",
  "teller machine",
  "withdrawal",
  "atr",
  "collaboration",
  "node",
  "attach document",
  "attach file",
  "email attachment",
  "envelop",
  "new mail",
  "outbox",
  "paperclip",
  "add attachment",
  "add file",
  "clip file",
  "insert file",
  "link file",
  "pinned",
  "stationery",
  "upload file",
  "attach page",
  "clip add",
  "link plus",
  "paperclip plus",
  "crossed out",
  "detach",
  "diagonal line",
  "disable attachment",
  "disconnect",
  "no attachments",
  "no file",
  "remove attachment",
  "restrict",
  "unattach",
  "unlink",
  "accounting",
  "contribution",
  "dollar",
  "donate",
  "earnings",
  "expense",
  "fund",
  "income",
  "monetization",
  "sell",
  "usd",
  "wealth",
  "abstract",
  "curved",
  "element",
  "graphic",
  "minimal",
  "oblong",
  "rounded",
  "amusement",
  "amusement park",
  "attractions",
  "cabins",
  "carnival",
  "entertainment",
  "fair",
  "ferris",
  "ferris wheel",
  "festival",
  "gondolas",
  "landmark",
  "leisure",
  "park",
  "pods",
  "recreation",
  "sightseeing",
  "accreditation",
  "acknowledge",
  "attribute",
  "attribution",
  "cc attribution",
  "citation",
  "cite",
  "contained",
  "copyright",
  "copywriter",
  "creative commons",
  "enclosed",
  "license",
  "origin",
  "ownership",
  "source",
  "youtube",
  "youtube attribution",
  "alt text",
  "alternative text",
  "audio description",
  "blind",
  "descriptive",
  "descriptive audio",
  "documentary",
  "e-learning",
  "learning",
  "narrated",
  "narration",
  "screen reader",
  "script",
  "sound waves",
  "spoken text",
  "tv show",
  "visually impaired",
  "voiceover",
  "aiff",
  "audio content",
  "audio document",
  "audio file",
  "audio track",
  "mp3",
  "music content",
  "music document",
  "music file",
  "musical note",
  "sheet music",
  "sound content",
  "sound document",
  "sound file",
  "sound recording",
  "wav",
  "amplifier",
  "audio receiver",
  "av equipment",
  "av receiver",
  "avr",
  "hi-fi",
  "home theater",
  "knob",
  "renderer",
  "sound system",
  "stereo",
  "theater",
  "tuner",
  "video receiver",
  "auto awesome",
  "awesome",
  "collage",
  "composition",
  "framework",
  "mosaic",
  "panels",
  "photo editing",
  "sections",
  "segments",
  "side by side",
  "tiles",
  "two panels",
  "cinematography",
  "enhancement",
  "auto-delete",
  "automated deletion",
  "autoremove",
  "bin",
  "can",
  "cleanup",
  "clear",
  "dispose",
  "erase",
  "garbage",
  "purge",
  "scheduled deletion",
  "temp",
  "temporary",
  "trash",
  "trash can",
  "auto read pause",
  "auto-read pause",
  "halt",
  "interruption",
  "auto play",
  "auto read",
  "autoplay",
  "begin",
  "play arrow",
  "chapter",
  "content creation",
  "creation",
  "diary",
  "flipping",
  "generated",
  "journal",
  "literature",
  "open book",
  "pages",
  "storytelling",
  "accident",
  "automotive",
  "breakdown",
  "broken down",
  "crane",
  "garage",
  "lift",
  "removal",
  "repair",
  "roadside",
  "roadside assistance",
  "tow",
  "tow truck",
  "towing",
  "vehicle recovery",
  "wrecker",
  "automatic transmission",
  "clutch",
  "driving",
  "gear",
  "gearbox",
  "gears",
  "h-pattern",
  "handle",
  "manual transmission",
  "mechanism",
  "shifter",
  "stick",
  "stick shift",
  "A",
  "optimize",
  "smooth",
  "algorithm",
  "automations",
  "efficiency",
  "flowchart",
  "intelligence",
  "machine learning",
  "magic",
  "pipeline",
  "productivity",
  "robotics",
  "workspace",
  "auto-pause",
  "automatic pause",
  "autopause",
  "broken circle",
  "load",
  "player controls",
  "replay",
  "restart",
  "two vertical lines",
  "succession",
  "uninterrupted",
  "autorenew",
  "cache",
  "cached",
  "counterclockwise",
  "inprogress",
  "loading refresh",
  "refresh page",
  "reload page",
  "retry",
  "synchronize",
  "autostop",
  "cease",
  "repeating",
  "alliance for open media",
  "aom",
  "av1",
  "codec",
  "compression",
  "decoding",
  "encoding",
  "file format",
  "movies",
  "one",
  "open source",
  "royalty-free",
  "video codec",
  "video compression",
  "av_timer",
  "minutes",
  "stopwatch",
  "advanced video coding",
  "avc",
  "h.264",
  "mpeg-4",
  "three letters",
  "video encoding",
  "video file format",
  "average",
  "average pace",
  "avg pace",
  "gauge",
  "meter",
  "needle",
  "pace",
  "speedometer",
  "tempo",
  "average duration",
  "average time",
  "avg time",
  "heartbeat",
  "pulse",
  "sine wave",
  "variability",
  "accomplishment",
  "award",
  "best",
  "champion",
  "emblem",
  "favorite",
  "guarantee",
  "octagon",
  "prize",
  "ranking",
  "recognition",
  "reward",
  "seal",
  "special",
  "star in octagon",
  "victory",
  "winner",
  "active zone minutes",
  "azm",
  "chevrons",
  "double chevron",
  "modern",
  "sports",
  "workout",
  "amenities",
  "babies",
  "baby",
  "care",
  "changing",
  "childcare",
  "diaper",
  "facilities",
  "father",
  "infant",
  "mother",
  "nappy",
  "newborn",
  "restroom",
  "station",
  "toddler",
  "wc",
  "backhand",
  "dismiss",
  "four fingers",
  "hand gesture",
  "move back",
  "raised",
  "return to previous",
  "app navigation",
  "back to tab",
  "change tab",
  "new tab",
  "open tab",
  "return to previous tab",
  "switch tab",
  "tab navigation",
  "web navigation",
  "background",
  "background option",
  "background setting",
  "four dots",
  "large",
  "pattern",
  "texture",
  "tile",
  "array",
  "cells",
  "dotted",
  "points",
  "small dots",
  "4x4",
  "background grid",
  "background pattern",
  "grid pattern",
  "small grid",
  "small squares",
  "square grid",
  "tile pattern",
  "account background",
  "backdrop",
  "backdrop replacement",
  "change background",
  "customize background",
  "diagonal lines",
  "edit background",
  "image background",
  "photo background",
  "profile background",
  "remove background",
  "replace",
  "scene",
  "swap background",
  "user background",
  "adjust brightness",
  "backlight",
  "backlit",
  "beam",
  "bright",
  "brilliance",
  "display brightness",
  "full brightness",
  "glow",
  "high brightness",
  "illuminate",
  "illumination",
  "increase brightness",
  "intense light",
  "light",
  "maximum brightness",
  "mobile settings",
  "radiant",
  "rays",
  "screen brightness",
  "sun",
  "sunshine",
  "backlight off",
  "brightness off",
  "dark",
  "dim",
  "disable backlight",
  "disable brightness",
  "high backlight",
  "monitor brightness",
  "negative",
  "no backlight",
  "no brightness",
  "shine",
  "turn off backlight",
  "turn off brightness",
  "brightness control",
  "brightness level",
  "brightness setting",
  "device brightness",
  "diamonds",
  "dimmed",
  "display dim",
  "laptop brightness",
  "low backlight",
  "low brightness",
  "low illumination",
  "low light",
  "phone brightness",
  "reduce brightness",
  "screen dim",
  "tablet brightness",
  "backpack",
  "bag",
  "belongings",
  "bookbag",
  "camping",
  "carry",
  "hiking",
  "knapsack",
  "luggage",
  "outdoors",
  "pack",
  "rucksack",
  "student",
  "backspace",
  "character delete",
  "text field",
  "text input",
  "typing",
  "x",
  "archiving",
  "cloud backup",
  "cloud computing",
  "cloud icon",
  "cloud storage",
  "data backup",
  "data safety",
  "data storage",
  "file storage",
  "files folders",
  "online storage",
  "recover",
  "restore",
  "synchronization",
  "bracket",
  "business continuity",
  "clone",
  "data management",
  "data recovery",
  "database",
  "database backup",
  "disaster recovery",
  "l shape",
  "retrieval",
  "server",
  "table backup",
  "credentials",
  "name",
  "name tag",
  "permit",
  "staff",
  "visitor",
  "battery",
  "battery indicator",
  "battery level",
  "battery life",
  "charge",
  "charging",
  "critical",
  "critical battery",
  "critical power",
  "empty battery",
  "energy",
  "low battery",
  "low power",
  "power",
  "power source",
  "very low battery",
  "bake",
  "baked goods",
  "bakery",
  "bakery dining",
  "bread",
  "breakfast",
  "brunch",
  "cafe",
  "chef",
  "clam",
  "cook",
  "croissant",
  "dessert",
  "dine in",
  "dining",
  "eat",
  "eat in",
  "kitchen",
  "lunch",
  "meal",
  "oven",
  "pastry",
  "restaurant",
  "shell",
  "snack",
  "sweet",
  "analyze",
  "compare",
  "comparison",
  "compromise",
  "court",
  "courtroom",
  "equality",
  "equity",
  "evaluate",
  "fairness",
  "impartiality",
  "judgment",
  "justice",
  "parity",
  "pros and cons",
  "scales",
  "stability. equilibrium",
  "steadiness",
  "tradeoff",
  "unbiased",
  "weight",
  "arched window",
  "balcony",
  "balustrade",
  "deck",
  "doors",
  "double doors",
  "exterior",
  "french doors",
  "open air",
  "outside",
  "patio",
  "porch",
  "railing",
  "scenic",
  "stay",
  "terrace",
  "veranda",
  "ballot",
  "ballot box",
  "bullet",
  "checkboxes",
  "election",
  "poll",
  "vote",
  "voting",
  "sales",
  "trending",
  "4 bars",
  "four bars",
  "health dashboard",
  "health metric dashboard",
  "health monitoring",
  "histogram",
  "oxygen",
  "analytics off",
  "bar chart disabled",
  "bar graph disabled",
  "cancel chart",
  "cancel graph",
  "chart disabled",
  "chart off",
  "data off",
  "data visualization off",
  "disable chart",
  "disable graph",
  "graph disabled",
  "graph off",
  "hide chart",
  "hide graph",
  "measurement off",
  "metrics off",
  "no chart",
  "no graph",
  "remove chart",
  "remove graph",
  "reporting off",
  "statistics off",
  "turn off chart",
  "turn off graph",
  "visualization off",
  "barcode",
  "ean",
  "grocery",
  "inventory",
  "logistics",
  "product code",
  "sale",
  "supply chain",
  "universal product code",
  "upc",
  "warehouse",
  "barcode reader",
  "barcode scanner",
  "handheld",
  "laser",
  "qr code",
  "reader",
  "brackets",
  "code reader",
  "point of sale",
  "pos",
  "price check",
  "price scanner",
  "product scanner",
  "qr code scanner",
  "scan code",
  "square brackets",
  "anatomy",
  "bare",
  "bare foot",
  "barefoot",
  "beach",
  "footmark",
  "footprint",
  "footprint outline",
  "footstep",
  "footsteps",
  "ground",
  "hike",
  "imprint",
  "podiatry",
  "sand",
  "sole",
  "step",
  "toes",
  "trace",
  "trail",
  "walking",
  "batch",
  "batch prediction",
  "bulb",
  "computation",
  "idea",
  "insight",
  "lightbulb",
  "predict",
  "prediction",
  "processing",
  "bath",
  "bathe",
  "bathhouse",
  "bathing",
  "geothermal",
  "hot spring",
  "hot springs",
  "hot tub",
  "japan",
  "japanese",
  "mineral bath",
  "onsen",
  "pool",
  "rocks",
  "sauna",
  "soak",
  "spa",
  "steam",
  "stones",
  "tub",
  "bathtub",
  "couple",
  "hygiene",
  "jacuzzi",
  "personal care",
  "shared bath",
  "steam lines",
  "steam room",
  "warm",
  "comfort station",
  "communal bath",
  "group bath",
  "lavatory",
  "public bath",
  "public restroom",
  "sento",
  "washroom",
  "water closet",
  "accessible restroom",
  "closet",
  "faucet",
  "gender neutral restroom",
  "latrine",
  "loo",
  "men's room",
  "powder room",
  "privy",
  "rounded top",
  "shower",
  "sink",
  "sprinkler",
  "wash",
  "wash closet",
  "women's room",
  "basin",
  "cleaning",
  "hot water",
  "sanitary",
  "tap",
  "battery_0",
  "battery_empty",
  "dead",
  "dead_battery",
  "empty",
  "low",
  "low_battery",
  "low_power",
  "no_charge",
  "no_power",
  "20%",
  "battery low",
  "charge level",
  "one bar",
  "power saving",
  "2 bars",
  "30 percent",
  "30%",
  "battery charging",
  "battery status",
  "portable device",
  "status bar icon",
  "thirty percent",
  "50 percent",
  "half charged",
  "half full",
  "medium battery",
  "power management",
  "status bar",
  "system status",
  "three segments",
  "3/4",
  "60%",
  "almost full",
  "full",
  "medium",
  "moderate",
  "sixty percent",
  "three quarters",
  "80%",
  "electricity",
  "five bars",
  "high battery",
  "laptop",
  "90%",
  "capacity",
  "nearly full",
  "six bars",
  "battery alert",
  "device status",
  "energy level",
  "level indicator",
  "no power",
  "power gauge",
  "power level",
  "power status",
  "zero battery",
  "full battery",
  "maximum battery",
  "resource",
  "android battery",
  "charge indicator",
  "charge status",
  "electrical",
  "power indicator",
  "electric",
  "percentage",
  "glyph",
  "interface element",
  "representation",
  "ui element",
  "cell phone",
  "charged",
  "remaining",
  "ui icon",
  "battery bar",
  "battery gauge",
  "device battery",
  "terminal",
  "battery icon",
  "bolt",
  "bolt icon",
  "charging indicator",
  "electricity icon",
  "instant",
  "lightning",
  "lightning icon",
  "power icon",
  "tech",
  "thunderbolt",
  "fully charged",
  "saver",
  "sign",
  "?",
  "punctuation",
  "question",
  "question mark",
  "battery share",
  "power share",
  "reverse charging",
  "wireless charging",
  "battery saver",
  "device health",
  "electric vehicle",
  "energy efficiency",
  "ev",
  "power saver",
  "battery change",
  "battery replacement",
  "battery swap",
  "battery symbol",
  "change battery",
  "lightning bolt",
  "new battery",
  "replace battery",
  "surge",
  "swap battery",
  "charging symbol",
  "flash",
  "power supply",
  "twenty percent",
  "partial",
  "plugin",
  "power up",
  "mid charge",
  "charging battery",
  "eighty percent",
  "ninety percent",
  "battery full",
  "full charge",
  "battery critical",
  "battery error",
  "battery failure",
  "battery issue",
  "battery problem",
  "charging error",
  "no",
  "power error",
  "power issue",
  "full power",
  "energy indicator",
  "full bar",
  "full energy",
  "0%",
  "dead battery",
  "no charge",
  "50%",
  "medium charge",
  "75 percent",
  "75%",
  "almost empty",
  "add battery",
  "add sign",
  "battery boost",
  "battery top up",
  "boost",
  "extend battery",
  "increase battery",
  "more battery",
  "more power",
  "top up",
  "battery management",
  "battery optimization",
  "battery profile",
  "battery settings",
  "cog",
  "cogwheel",
  "energy management",
  "energy settings",
  "mechanics",
  "power settings",
  "battery plus",
  "conserve battery",
  "device settings",
  "energy saver",
  "energy saving",
  "low power mode",
  "optimize battery",
  "power save",
  "save battery",
  "outgoing",
  "portable charger",
  "power bank",
  "battery charged",
  "battery good",
  "good",
  "status indicator",
  "vertical rectangle",
  "battery health",
  "status unknown",
  "unknown level",
  "beach umbrella",
  "beach_access",
  "coast",
  "parasol",
  "resort",
  "seaside",
  "shade",
  "shoreline",
  "summer",
  "sun protection",
  "sunny",
  "sunshade",
  "umbrella",
  "bedroom",
  "bedtime",
  "blanket",
  "double bed",
  "dream",
  "guest room",
  "hospitality",
  "king",
  "mattress",
  "night",
  "overnight",
  "pillow",
  "pillows",
  "queen",
  "twin bed",
  "bassinet",
  "cot",
  "crib",
  "horse",
  "nursery",
  "rocking",
  "rocking horse",
  "bunk bed",
  "child's room",
  "kids room",
  "nap",
  "twin",
  "headboard",
  "master bedroom",
  "parents",
  "sizem master",
  "after dark",
  "astronomy",
  "celestial",
  "clear night",
  "crescent",
  "crescent moon",
  "dnd",
  "do not disturb",
  "dusk",
  "evening",
  "lunar",
  "moon",
  "night mode",
  "nightime",
  "nighttime",
  "quiet time",
  "shhh",
  "sleep mode",
  "twilight",
  "bedtime mode",
  "concentration",
  "downtime",
  "focus mode",
  "quiet mode",
  "time out",
  "beenhere",
  "completion",
  "confirmation",
  "remember",
  "saved",
  "visited",
  "bento",
  "compartments",
  "dinner",
  "divided",
  "food container",
  "lunchbox",
  "meal prep",
  "picnic",
  "portable meal",
  "school lunch",
  "takeaway",
  "takeout",
  "work lunch",
  "bia",
  "bodies",
  "body composition",
  "bone",
  "business intelligence",
  "data analysis",
  "discovery",
  "fat",
  "inspect",
  "muscle",
  "bid",
  "fusion table",
  "zigzag",
  "bidding disabled",
  "landscape disabled",
  "landscape off",
  "no bidding",
  "no landscape",
  "bigtop",
  "bigtop updates",
  "concentric arcs",
  "transmitter",
  "updates",
  "arch",
  "base",
  "bicycle",
  "bike",
  "bike parking",
  "bike rack",
  "bike rental",
  "bike share",
  "bike stand",
  "docking station",
  "parking",
  "pillar",
  "rack",
  "slot",
  "stand",
  "bike lane",
  "commuting",
  "cyclist",
  "lane",
  "permitted",
  "protected",
  "e-scooter",
  "electric scooter",
  "handlebars",
  "kick scooter",
  "micro mobility",
  "moped",
  "motorbike",
  "motorcycle",
  "personal transport",
  "scooter",
  "two wheels",
  "urban mobility",
  "vespa",
  "wheels",
  "biochemistry",
  "biotech",
  "biotechnology",
  "chemistry",
  "experiment",
  "genetics",
  "investigation",
  "lab equipment",
  "laboratory",
  "life science",
  "microbiology",
  "microorganism",
  "microscope",
  "molecule",
  "pharmaceutical",
  "research",
  "scientific instrument",
  "scientific research",
  "cable",
  "connector",
  "cord",
  "cover",
  "electric cable",
  "electric cord",
  "electric plug",
  "electric wire",
  "outlet",
  "plug",
  "plug in",
  "power cable",
  "power cord",
  "recharge",
  "socket",
  "throw",
  "wire",
  "wrap",
  "appliance icon",
  "beverage",
  "blade",
  "blend",
  "blender",
  "chop",
  "cooking",
  "crush",
  "drink",
  "food icon",
  "food preparation",
  "food processor",
  "jug",
  "juice",
  "juicer",
  "kitchen tool",
  "kitchenware",
  "liquefy",
  "milkshake",
  "mix",
  "motor",
  "puree",
  "smoothie",
  "vitamix",
  "blind person",
  "blindness",
  "cane",
  "disability access",
  "figure",
  "impaired vision",
  "low vision",
  "sightless",
  "visual aid",
  "walking cane",
  "walking stick",
  "white cane",
  "blinds",
  "curtains",
  "interior design",
  "lever",
  "light control",
  "roller blinds",
  "shutter",
  "venetian blinds",
  "window blinds",
  "window covering",
  "window shade",
  "window treatment",
  "closed",
  "horizontal blinds",
  "mini blinds",
  "room darkening",
  "shut",
  "slatted blinds",
  "window dressing",
  "avoid",
  "circle with line",
  "circle with slash",
  "crossed out circle",
  "decline",
  "denied",
  "disturb",
  "do disturb",
  "ignore",
  "not allowed",
  "not interested",
  "opt out",
  "prohibit",
  "prohibited",
  "quit",
  "reject",
  "blood pressure",
  "cardiology",
  "diagnostics",
  "health data",
  "heart",
  "hypertension",
  "hypotension",
  "monitoring",
  "pressure",
  "sphygmomanometer",
  "vital signs",
  "vitals",
  "blood",
  "blood donation",
  "blood drop",
  "blood group",
  "blood test",
  "blood type",
  "bloodtype",
  "donation",
  "droplet",
  "first aid",
  "health record",
  "lab",
  "result",
  "transfusion",
  "bluetooth",
  "bluetooth icon",
  "networking",
  "paired",
  "pairing",
  "pan",
  "paring",
  "personal area network",
  "short-range",
  "unpaired",
  "wireless technology",
  "b symbol",
  "bluetooth connected",
  "headphones",
  "rune",
  "two dots",
  "x shape",
  "bluetooth disabled",
  "bluetooth logo",
  "bluetooth symbol",
  "connection disabled",
  "connection icon",
  "connection off",
  "device disabled",
  "device off",
  "network disabled",
  "no bluetooth",
  "nordic",
  "pairing disabled",
  "pairing off",
  "sync disabled",
  "sync off",
  "wireless disabled",
  "wireless icon",
  "bluetooth car",
  "bluetooth connection",
  "car bluetooth",
  "connected car",
  "in-car entertainment",
  "road trip",
  "smart car",
  "vehicle connection",
  "wireless automotive",
  "wireless car",
  "audio connection",
  "bluetooth audio",
  "bluetooth searching",
  "find device",
  "searching",
  "wireless audio",
  "wireless headphones",
  "blur",
  "blur circular",
  "bokeh",
  "defocus",
  "diffuse",
  "distortion",
  "image adjustment",
  "image effect",
  "optics",
  "out of focus",
  "radial blur",
  "scattered",
  "soften",
  "unfocus",
  "blur linear",
  "fade",
  "gradient",
  "linear",
  "motion blur",
  "photo effect",
  "picture edit",
  "row of circles",
  "three rows",
  "blurring",
  "gaussian blur",
  "image blur",
  "image filter",
  "medium blur",
  "photo blur",
  "photo filter",
  "soft focus",
  "unfocused",
  "anti blur",
  "blur off",
  "cancel blur",
  "cross out",
  "defocus off",
  "disable blur",
  "image correction",
  "image enhancement",
  "no blur",
  "out of focus off",
  "photo correction",
  "photo enhancement",
  "picture correction",
  "picture editing",
  "picture enhancement",
  "remove blur",
  "restore sharpness",
  "sharpen",
  "unblur",
  "blur on",
  "blurry",
  "dispersion",
  "raster",
  "vision",
  "adjust blur",
  "blur tool",
  "editing tool",
  "fast blur",
  "photo adjustment",
  "quick blur",
  "short",
  "special effect",
  "toggle blur",
  "aquatic",
  "boat icon",
  "boat trip",
  "bus icon",
  "cruise",
  "excursion",
  "ferry",
  "marine transport",
  "public transport",
  "river bus",
  "sea bus",
  "shipping",
  "voyage",
  "water bus",
  "water taxi",
  "water travel",
  "waterfront",
  "canal",
  "cargo",
  "crossing",
  "engine",
  "freight",
  "lake",
  "locomotive",
  "monorail",
  "rail",
  "railway",
  "river",
  "subway",
  "train",
  "tram",
  "bmi",
  "body fat",
  "body fat caliper",
  "body fat measurement",
  "body fat percentage",
  "body fat scale",
  "body fat tracker",
  "body mass index",
  "caliper",
  "fat percentage",
  "fitness tracker",
  "human body",
  "measurement tool",
  "physical health",
  "pinch",
  "skinfold",
  "wellness tracker",
  "body system",
  "full body",
  "holistic",
  "organs",
  "physiology",
  "wellbeing",
  "hazard",
  "high voltage",
  "shock",
  "storm",
  "strike",
  "thunderstorm",
  "voltage",
  "zap",
  "atomic",
  "attack",
  "blast",
  "blasts",
  "bomb",
  "boom",
  "burst",
  "bursts",
  "conflict",
  "damage",
  "destroy",
  "destruction",
  "detonation",
  "disaster",
  "explosion",
  "explosive",
  "fuse",
  "loud",
  "mine",
  "sabotage",
  "security threat",
  "terrorism",
  "threat",
  "violence",
  "war",
  "weapon",
  "🧨",
  "academy",
  "bookmark ribbon",
  "course",
  "curriculum",
  "knowledge",
  "lesson",
  "page marker",
  "study",
  "syllabus",
  "textbook",
  "book_2",
  "digital book",
  "ebook",
  "learn",
  "magazine",
  "novel",
  "online reading",
  "publication",
  "studying",
  "academic",
  "dictionary",
  "encyclopedia",
  "letter",
  "fourth",
  "spine",
  "five",
  "notebook",
  "stacked books",
  "admission",
  "concert",
  "digital ticket",
  "e-ticket",
  "entry pass",
  "event ticket",
  "mobile ticket",
  "museum",
  "travel ticket",
  "deselect",
  "flag",
  "later",
  "unmark",
  "add bookmark",
  "add to bookmarks",
  "add to reading list",
  "bookmark add",
  "bookmark plus",
  "bookmarking",
  "bookmarks",
  "favorite bookmark",
  "new bookmark",
  "plus bookmark",
  "reading list",
  "save bookmark",
  "save to reading list",
  "added",
  "bookmark added",
  "favorites",
  "mark as read",
  "save for later",
  "baggage",
  "packing list",
  "shopping bag",
  "suitcase",
  "tote",
  "travel bag",
  "travel gear",
  "wishlist",
  "completed task",
  "okay",
  "selected",
  "country",
  "flags",
  "follow up",
  "milepost",
  "nation",
  "pole",
  "priority",
  "tagged",
  "waypoint",
  "world",
  "add to favorites",
  "affection",
  "appreciate",
  "bookmark heart",
  "favorites list",
  "heart bookmark",
  "love",
  "mark as favorite",
  "passion",
  "preferred",
  "romance",
  "romantic",
  "saved items",
  "valentine",
  "wish list",
  "bookmark manager",
  "content management",
  "document management",
  "edit bookmark",
  "file management",
  "folder edit",
  "folder editor",
  "manage bookmarks",
  "organize bookmarks",
  "sheet",
  "slide",
  "check mark",
  "delete bookmark",
  "remove bookmark",
  "unarchive",
  "unbookmark",
  "unfavorite",
  "unsave",
  "unsaved",
  "bookmark shape",
  "essential",
  "featured",
  "five pointed star",
  "five points",
  "important items",
  "memorable",
  "noteworthy",
  "star shape",
  "starred",
  "ribbons",
  "tabs",
  "audiobook",
  "book and play",
  "books",
  "combined media",
  "digital content",
  "entertainment library",
  "media library",
  "movie and play",
  "music and play",
  "border all",
  "stroke",
  "border bottom",
  "bottom border",
  "bottom line",
  "separator",
  "underscore",
  "border_clear",
  "default",
  "no border",
  "plain",
  "remove border",
  "remove formatting",
  "border color",
  "border horizontal",
  "divider",
  "splitter",
  "inner",
  "inset",
  "internal",
  "margin",
  "border left",
  "border style",
  "border_left",
  "left alignment",
  "left border",
  "text border",
  "outer",
  "border right",
  "right border",
  "broken line",
  "color",
  "perforated",
  "segment",
  "border_top",
  "header",
  "top border",
  "border vertical",
  "panes",
  "two columns",
  "vertical border",
  "vertical divide",
  "assemble",
  "assimilate",
  "borg",
  "build",
  "collective",
  "component",
  "construct",
  "futuristic",
  "integrate",
  "module",
  "app bar",
  "bottom app bar",
  "bottom bar",
  "bottom dock",
  "bottom navigation",
  "bottom panel",
  "footer",
  "mobile interface",
  "mobile navigation",
  "mobile ui",
  "navigation bar",
  "ui bar",
  "bottom drawer",
  "bottom modal",
  "bottom sheet",
  "modal",
  "popup",
  "slide up",
  "ui component",
  "bottom menu",
  "bottom tabs",
  "tab bar",
  "web app",
  "website navigation",
  "UI panel",
  "bottom sheet close",
  "interaction",
  "mobile UI",
  "slide down",
  "spaces",
  "collapse panel",
  "expand panel",
  "pull up",
  "bottom corner",
  "bottom right",
  "bottom right corner",
  "click location",
  "context menu",
  "context menu location",
  "corner click",
  "mouse click",
  "right click",
  "right click corner",
  "right corner",
  "bottom_sheets",
  "overlap",
  "sheets",
  "closed box",
  "goods",
  "merchandise",
  "parcel",
  "postal",
  "shipment",
  "add package",
  "add to box",
  "add to package",
  "create box",
  "create package",
  "new package",
  "plus package",
  "box edit",
  "edit box",
  "avatar icon",
  "boy",
  "boy icon",
  "child icon",
  "kid icon",
  "male icon",
  "man",
  "profile icon",
  "standing",
  "user icon",
  "announce",
  "awareness",
  "brand awareness",
  "brand recognition",
  "megaphone",
  "outreach",
  "pr",
  "public relations",
  "capital a",
  "change font",
  "choose font",
  "font selection",
  "fonts",
  "italic",
  "lowercase a",
  "regular",
  "serif",
  "styles",
  "tester",
  "typeface",
  "typefaces",
  "intellectual property",
  "layer",
  "trademark",
  "watermark",
  "breakfast food",
  "breakfast time",
  "butter",
  "carbohydrate",
  "continental breakfast",
  "edible",
  "food and beverage",
  "food service",
  "grain",
  "loaf",
  "mealtime",
  "sandwich",
  "slice",
  "toast",
  "wheat",
  "breaking news",
  "bulletin",
  "headline",
  "live",
  "newspaper",
  "press",
  "press release",
  "baby care",
  "breast",
  "breast milk",
  "breastfed",
  "breastfeed",
  "breastfeeding",
  "cuddle",
  "feeding",
  "hug",
  "human milk",
  "infant feeding",
  "lactation",
  "mama",
  "maternity",
  "mom",
  "mommy",
  "motherhood",
  "nursing",
  "nursing mother",
  "nurturing",
  "parenthood",
  "pregnancy",
  "woman",
  "brick",
  "building block",
  "games",
  "lego",
  "masonry",
  "minecraft",
  "piece",
  "pixel art",
  "wall",
  "empty circle",
  "hollow",
  "visibility",
  "dark mode",
  "half moon",
  "sky",
  "theme",
  "waning crescent",
  "third quarter",
  "eight pointed star",
  "islamic star",
  "level 4",
  "moderate brightness",
  "quarter",
  "day",
  "intensity",
  "luminance",
  "maximum",
  "radial",
  "50% brightness",
  "eight points",
  "half",
  "half brightness",
  "medium brightness",
  "daylight",
  "level 7",
  "exposure",
  "overexposure",
  "adaptive brightness",
  "ambient light",
  "auto brightness",
  "auto-adjust",
  "auto-control",
  "automatic brightness",
  "brightness auto",
  "dynamic brightness",
  "starburst",
  "0",
  "octagram",
  "adjustment",
  "brightness medium",
  "lighting",
  "semi-circle",
  "bring",
  "bring your own ip",
  "byoip",
  "custom ip",
  "data center",
  "external ip",
  "global",
  "globe",
  "hosting",
  "infrastructure",
  "internet protocol",
  "ip",
  "ip address",
  "manage ip",
  "network settings",
  "own",
  "protocol",
  "sphere",
  "user ip",
  "your",
  "broadcast on home",
  "router",
  "transmit",
  "broadcast signal",
  "home broadcast",
  "home network",
  "hotspot",
  "house broadcast",
  "lan",
  "local network",
  "personal broadcast",
  "smart house",
  "wlan",
  "bad file",
  "broken",
  "broken file",
  "broken image",
  "connection error",
  "corrupt",
  "corrupted image",
  "damaged file",
  "display error",
  "download error",
  "file error",
  "file not found",
  "glitch",
  "image error",
  "image not found",
  "image placeholder",
  "load error",
  "lost image",
  "missing image",
  "network error",
  "server error",
  "sync error",
  "torn",
  "unreadable file",
  "upload error",
  "zig zag",
  "browse",
  "choices",
  "browsing",
  "log",
  "online activity",
  "page views",
  "site activity",
  "web activity",
  "website activity",
  "browse_gallery",
  "events",
  "moments",
  "parentheses",
  "records",
  "two circles",
  "application update",
  "browser download",
  "browser update",
  "new version",
  "software update",
  "system update",
  "updated",
  "web browser",
  "breakfast and lunch",
  "brunch icon",
  "cafe icon",
  "celebration",
  "champagne",
  "dining icon",
  "flute",
  "food and drink",
  "meal icon",
  "mimosa",
  "pancakes",
  "restaurant icon",
  "waffles",
  "weekend",
  "artistic",
  "artistic tool",
  "brush",
  "creativity",
  "digital art",
  "illustration",
  "paint",
  "paint tool",
  "paintbrush",
  "painting",
  "sketch",
  "answer",
  "bubble chart",
  "bubbles",
  "overlapping circles",
  "trends",
  "animal",
  "bug",
  "bug icon",
  "bug report",
  "bug tracking",
  "defect",
  "exoskeleton",
  "insect",
  "oval",
  "qa",
  "quality assurance",
  "report bug",
  "segmented",
  "software testing",
  "submit bug",
  "testing",
  "virus",
  "crescent wrench",
  "implement",
  "implementation",
  "mechanic",
  "spanner",
  "wrench",
  "build_circle",
  "works",
  "bungalow",
  "cabin",
  "cottage",
  "home page",
  "initial",
  "main page",
  "primary",
  "traveling",
  "burst mode",
  "camera burst",
  "continuous capture",
  "continuous shooting",
  "image burst",
  "multi-shot",
  "multiple photos",
  "photo burst",
  "photo sequence",
  "quick capture",
  "rapid capture",
  "rapid fire",
  "bus stop",
  "incident",
  "road closure",
  "schedule change",
  "service disruption",
  "bus station",
  "commute icon",
  "public transport icon",
  "public transportation",
  "railway icon",
  "straight lines",
  "train icon",
  "train station",
  "transport icon",
  "transportation icon",
  "travel icon",
  "briefcase",
  "business_center",
  "career",
  "case",
  "corporate",
  "documents",
  "employment",
  "portfolio",
  "professional",
  "purse",
  "resources",
  "asset",
  "chip",
  "enclosure",
  "business chat",
  "business communication",
  "business message",
  "dialogue",
  "swap",
  "UI",
  "controller",
  "floating",
  "gamepad",
  "chalet",
  "chimney",
  "getaway",
  "logs",
  "rustic",
  "smoke",
  "wood",
  "wooden",
  "adapter",
  "aux",
  "charger",
  "ethernet",
  "hdmi",
  "jack",
  "usb",
  "aerial tramway",
  "cable car",
  "cable railway",
  "cablecar",
  "chairlift",
  "funicular",
  "gondola",
  "mountain cableway",
  "ropeway",
  "san francisco",
  "ski lift",
  "ski resort",
  "three windows",
  "winter sports",
  "buffering",
  "memory",
  "amplitude",
  "beat",
  "beats per minute",
  "cadence",
  "consistent",
  "repetition",
  "rhythm",
  "steps per minute",
  "anniversary",
  "baked",
  "birthday",
  "birthday cake",
  "birthday icon",
  "cake",
  "cake icon",
  "candle",
  "candles",
  "celebration icon",
  "dessert icon",
  "flame",
  "frosting",
  "party icon",
  "pastries",
  "single candle",
  "special occasion",
  "sweets icon",
  "tiered cake",
  "treat",
  "two layers",
  "add birthday",
  "add cake",
  "add icon",
  "confectionery",
  "create cake",
  "new birthday",
  "new cake",
  "plus cake",
  "plus icon",
  "-",
  "=",
  "calculator",
  "difference",
  "equals",
  "finance calculator",
  "quotient",
  "solve",
  "add reminder",
  "add to calendar",
  "agenda",
  "calendar",
  "calendar icon",
  "calendar page",
  "create event",
  "date picker",
  "event planning",
  "month",
  "new appointment",
  "save the date",
  "schedule meeting",
  "today",
  "year",
  "add event",
  "calendar apps script",
  "choose date",
  "new event",
  "pick date",
  "save date",
  "select date",
  "appointment reminder",
  "calendar date",
  "calendar reminder",
  "clock icon",
  "daily schedule",
  "date and time",
  "time of day",
  "calendar month",
  "month view",
  "organization icon",
  "schedule icon",
  "timetable",
  "week",
  "current date",
  "daily",
  "schedule date",
  "today's date",
  "calendar day",
  "calendar view",
  "daily agenda",
  "daily calendar",
  "daily view",
  "date view",
  "day planner",
  "day view",
  "organizer",
  "schedule day",
  "single day",
  "view day",
  "calendar grid",
  "calendar month view",
  "grid view",
  "monthly calendar",
  "schedule view",
  "seven days",
  "timeframe",
  "week view",
  "weekly",
  "alternative phone",
  "call icon",
  "communication icon",
  "contact icon",
  "hotline",
  "landline",
  "local call",
  "local phone",
  "phone alt",
  "phone icon",
  "receiver icon",
  "telephone call",
  "voicemail",
  "audio call",
  "call end",
  "call_end",
  "call_end_alt",
  "earpiece",
  "end call",
  "hang up",
  "mouthpiece",
  "phone call",
  "telephony",
  "voice call",
  "all calls",
  "call details",
  "call history",
  "call log",
  "call records",
  "calls",
  "communication history",
  "contact history",
  "contact log",
  "dialed calls",
  "missed calls",
  "past calls",
  "phone calls",
  "phone log",
  "phone records",
  "received calls",
  "recent calls",
  "call made",
  "made",
  "outgoing call",
  "call merge",
  "converging arrows",
  "converging lines",
  "group call",
  "multi call",
  "three way call",
  "call missed",
  "callback",
  "declined",
  "hung up",
  "ignored",
  "missed call",
  "rejected",
  "cancel call",
  "declined call",
  "missed connection",
  "no answer",
  "rejected call",
  "unanswered",
  "about",
  "call quality",
  "i",
  "phone information",
  "troubleshoot",
  "voip",
  "accept call",
  "answer call",
  "call received",
  "get call",
  "incoming call",
  "receive call",
  "received",
  "slanted arrow",
  "call branching",
  "call forwarding",
  "call management",
  "call split",
  "call transfer",
  "diverging arrows",
  "redirect",
  "replicate",
  "call to action",
  "cta",
  "instruction",
  "prompt",
  "aperture",
  "camcorder",
  "record button",
  "shoot",
  "snapshot",
  "take photo",
  "take picture",
  "take video",
  "triangles",
  "videocamera",
  "camera flip",
  "facing",
  "flip",
  "front",
  "front camera",
  "mobile camera",
  "portrait mode",
  "self portrait",
  "switch camera",
  "user facing camera",
  "cam",
  "camera indoor",
  "filming",
  "home cam",
  "home monitoring",
  "home security",
  "house camera",
  "indoor camera",
  "ip camera",
  "live stream",
  "security camera",
  "surveillance camera",
  "video camera",
  "video surveillance",
  "videography",
  "camera recording",
  "outdoor camera",
  "property surveillance",
  "remote viewing",
  "smart camera",
  "video monitoring",
  "camera app",
  "rear",
  "rear camera",
  "video capture",
  "analog",
  "camera roll",
  "classic camera",
  "film reel",
  "film roll",
  "filmstrip",
  "picture roll",
  "reel",
  "roll",
  "desk",
  "live video",
  "online meeting",
  "record video",
  "start recording",
  "stop recording",
  "tripod",
  "video broadcast",
  "video chat",
  "video streaming",
  "virtual meeting",
  "webcam call",
  "back camera",
  "camera rotate",
  "camera switch",
  "camera toggle",
  "cameraswitch",
  "change camera",
  "flip camera",
  "rotate camera",
  "selfie camera",
  "advertise",
  "bullhorn",
  "content marketing",
  "email marketing",
  "influencer marketing",
  "loudspeaker",
  "paid advertising",
  "public address",
  "shout",
  "social media marketing",
  "camp",
  "campsite",
  "expedition",
  "exploration",
  "outdoor activities",
  "teepee",
  "tent",
  "trekking",
  "wigwam",
  "wilderness",
  "cancel button",
  "close button",
  "cross mark",
  "highlight off",
  "remove selection",
  "turn off",
  "unselect",
  "abort",
  "cancel presentation mode",
  "present",
  "presentation mode",
  "terminate",
  "prevent",
  "unschedule",
  "unsend",
  "burn",
  "candelabra",
  "candlestick",
  "christmas",
  "fire",
  "holder",
  "hope",
  "ideology",
  "memorial",
  "prayer",
  "religion",
  "remembrance",
  "spiritual",
  "teardrop",
  "torch",
  "vigil",
  "wax",
  "worship",
  "candlestick chart",
  "financial chart",
  "market chart",
  "price chart",
  "stock",
  "stock chart",
  "trading",
  "trading chart",
  "trend chart",
  "wick",
  "420",
  "alternative medicine",
  "cannabis",
  "cbd",
  "dispensary",
  "drug",
  "ganja",
  "hemp",
  "herbal",
  "hybrid",
  "illegal",
  "indica",
  "leaf",
  "marijuana",
  "pot",
  "rasta",
  "recreational",
  "sativa",
  "seven leaves",
  "thc",
  "weed",
  "captive portal",
  "gateway",
  "go to",
  "guest wifi",
  "landing page",
  "language",
  "planet",
  "portal",
  "public wifi",
  "www",
  "acquire",
  "content capture",
  "data capture",
  "grab",
  "obtain",
  "picture in picture",
  "screen capture",
  "screengrab",
  "screenshot",
  "window capture",
  "car symbol",
  "collision",
  "insurance",
  "defog",
  "defrost",
  "demist",
  "driver",
  "heating",
  "warmer",
  "windshield",
  "blower",
  "vent",
  "car controls",
  "front window",
  "windscreen",
  "air direction",
  "legs",
  "mid",
  "front seat",
  "seated",
  "back seat",
  "mid left",
  "middle seat",
  "rear seat",
  "air vent",
  "low level",
  "mid level",
  "right side",
  "air circulation",
  "car interior",
  "circulate",
  "recirculate",
  "recirculation symbol",
  "auto maintenance",
  "auto repair",
  "auto service",
  "car maintenance",
  "car repair",
  "car service",
  "car settings",
  "tuning",
  "vehicle maintenance",
  "vehicle repair",
  "vehicle service",
  "anti-theft",
  "car lock",
  "car security",
  "immobilizer",
  "keyless entry",
  "locked",
  "password",
  "remote",
  "unlock",
  "vehicle lock",
  "vehicle security",
  "car part",
  "condensation",
  "defroster",
  "fog",
  "heated",
  "mirror",
  "rearview mirror",
  "side mirror",
  "sideview",
  "wing mirror",
  "car hire",
  "car rental",
  "car sharing",
  "carpool",
  "hire",
  "loan",
  "pickup",
  "rent",
  "car lift",
  "elevated",
  "fix car",
  "hoist",
  "service car",
  "workshop",
  "car deal",
  "car label",
  "car offer",
  "car price",
  "car sale",
  "car tag",
  "deal",
  "discount",
  "trade",
  "access card",
  "badge card",
  "card membership",
  "exclusive",
  "exclusive card",
  "loyalty",
  "loyalty card",
  "payment card",
  "premium card",
  "rewards",
  "rewards card",
  "saved card",
  "subscription card",
  "vip",
  "vip card",
  "business trip",
  "card_travel",
  "carry-on",
  "miles",
  "work trip",
  "cardiac",
  "cardio",
  "exertion",
  "gym",
  "heart monitor",
  "heart rate",
  "physical activity",
  "sport",
  "training",
  "training effort",
  "training load",
  "cardiovascular",
  "ecg",
  "ekg",
  "electrocardiogram",
  "heart health",
  "life",
  "vital",
  "app view",
  "boxes",
  "cards",
  "modules",
  "quad",
  "switch view",
  "collections",
  "highlights",
  "images",
  "photos",
  "pictures",
  "scratchcard",
  "builder",
  "carpenter",
  "carpentry",
  "craft",
  "cut",
  "cutting",
  "diy",
  "grip",
  "handsaw",
  "handyman",
  "home improvement",
  "lumber",
  "renovation",
  "saw",
  "sawing",
  "teeth",
  "timber",
  "woodworking",
  "cabin luggage",
  "carryon",
  "personal item",
  "rolling",
  "allowed",
  "checked",
  "hand luggage",
  "overhead compartment",
  "travel accessories",
  "carry on",
  "airport information",
  "baggage information",
  "baggage question",
  "carry-on baggage",
  "carry-on luggage",
  "flight information",
  "luggage information",
  "luggage question",
  "travel information",
  "travel question",
  "assignments",
  "cases",
  "bet",
  "betting",
  "casino",
  "casino chip",
  "casino game",
  "chance",
  "chips",
  "dice",
  "dice roll",
  "five dots",
  "fortune",
  "gamble",
  "gambling",
  "game of chance",
  "las vegas",
  "luck",
  "probability",
  "random",
  "risk",
  "spots",
  "tokens",
  "wager",
  "chromecast",
  "media sharing",
  "mirroring",
  "projection",
  "screen share",
  "screencast",
  "smart tv",
  "miracast",
  "screen sharing",
  "classroom",
  "distance learning",
  "for",
  "graduation cap",
  "lecture",
  "lessons teaching",
  "teach",
  "tutorial",
  "university",
  "webinar",
  "cast alert",
  "cast error",
  "cast issue",
  "cast problem",
  "cast signal",
  "connection issue",
  "connection problem",
  "network issue",
  "network problem",
  "signal bars",
  "wireless error",
  "wireless issue",
  "wireless problem",
  "ancient",
  "battlement",
  "castle",
  "citadel",
  "fairytale",
  "fantasy",
  "fort",
  "fortification",
  "fortress",
  "kingdom",
  "mansion",
  "medieval",
  "palace",
  "rampart",
  "royalty",
  "stronghold",
  "turret",
  "assortment",
  "building blocks",
  "categories",
  "categorize",
  "category",
  "classification",
  "elements",
  "personalization",
  "shapes",
  "taxonomy",
  "themes",
  "types",
  "variety",
  "advanced search",
  "classify",
  "department",
  "detailed search",
  "item category",
  "product category",
  "topic",
  "celebrate",
  "cheers",
  "cone",
  "confetti",
  "congrats",
  "congratulations",
  "exploding",
  "festive",
  "hooray",
  "noisemaker",
  "party popper",
  "popper",
  "streams",
  "yay",
  "incorporate",
  "unite",
  "casting",
  "cell tower",
  "strength",
  "transmitting",
  "cellular service",
  "roaming",
  "signal bar",
  "aim",
  "aiming",
  "calibration",
  "center focus",
  "object recognition",
  "precise",
  "reticle",
  "strong",
  "strong focus",
  "auto focus",
  "autofocus",
  "center focus weak",
  "framing",
  "image focus",
  "manual focus",
  "positioning",
  "screen focus",
  "weak",
  "weak focus",
  "armchair",
  "couch",
  "decoration",
  "furnishings",
  "furniture store",
  "living",
  "living room",
  "lobby",
  "lounge",
  "lounging",
  "loveseat",
  "seating",
  "sofa",
  "two seater",
  "waiting room",
  "alternative chair",
  "bench",
  "cahir",
  "chair_alt",
  "stool",
  "waiting",
  "lodge",
  "mountain resort",
  "ski",
  "winter holiday",
  "winter vacation",
  "alteration",
  "change history",
  "changes",
  "edit history",
  "git",
  "github",
  "revisions",
  "track changes",
  "version control",
  "version history",
  "versioning",
  "batteries",
  "fast charge",
  "quick charge",
  "charging station",
  "fill up",
  "mobile charging",
  "power station",
  "gain",
  "line chart",
  "messenger",
  "add chat",
  "add comment",
  "add conversation",
  "add post",
  "create chat",
  "join chat",
  "new chat",
  "new post",
  "plus message",
  "start chat",
  "chat bot",
  "chatbot",
  "interact",
  "comment bubble",
  "cancel chat",
  "chat error",
  "chat fail",
  "chat problem",
  "chat x",
  "close chat",
  "communication error",
  "delete chat",
  "delete message",
  "error message",
  "fail message",
  "message error",
  "message fail",
  "message problem",
  "messaging",
  "remove chat",
  "remove message",
  "about chat",
  "chat details",
  "chat info",
  "chat information",
  "chat support",
  "conversation details",
  "conversation info",
  "conversation information",
  "hint",
  "info bubble",
  "learn more",
  "message details",
  "message info",
  "message information",
  "more info",
  "tooltip",
  "chat message",
  "chat reply",
  "paste",
  "paste text",
  "quick reply",
  "send message",
  "share text",
  "share message",
  "text area",
  "text box",
  "accepted",
  "agreed",
  "submitted",
  "task complete",
  "todo",
  "checkbox",
  "checked box",
  "tick mark",
  "blank",
  "deselected",
  "empty box",
  "empty square",
  "tickbox",
  "uncheck",
  "unchecked",
  "unselected",
  "successful",
  "attendance",
  "availability",
  "check in",
  "check out",
  "coming",
  "doorway",
  "entrance",
  "gate",
  "going",
  "inscription",
  "presence",
  "hyphen",
  "in progress",
  "indeterminate",
  "indeterminate state",
  "intermediate",
  "mixed state",
  "progress bar",
  "three-state",
  "tri-state",
  "undefined",
  "checkbook",
  "cheque",
  "ledger",
  "signature",
  "withdraw",
  "carousel",
  "baggage_info",
  "found",
  "lost",
  "travel_info",
  "questionnaire",
  "right to left",
  "rtl",
  "checkroom",
  "cloakroom",
  "clothes hanger",
  "clothes rack",
  "coat check",
  "coat hanger",
  "hanger",
  "hanging",
  "lost and found",
  "temporary storage",
  "applaud",
  "applause",
  "cheer",
  "cheering",
  "clap",
  "clapping hands",
  "encourage",
  "encouragement",
  "enthusiasm",
  "excitement",
  "fans",
  "good job",
  "gratitude",
  "greeting",
  "hype",
  "joy",
  "ovation",
  "positive feedback",
  "praise",
  "thank you",
  "thanks",
  "well done",
  "baker",
  "catering",
  "chef's hat",
  "chef's uniform",
  "cooking show",
  "cuisine",
  "culinary",
  "culinary arts",
  "food blog",
  "food industry",
  "gastronomy",
  "hat",
  "head chef",
  "pastry chef",
  "recipe",
  "restaurant management",
  "toque",
  "uniform",
  "board",
  "board game",
  "challenge",
  "chess",
  "chess piece",
  "competition",
  "crown",
  "google play",
  "hobby",
  "logic",
  "skill",
  "strategy",
  "tactics",
  "tournament",
  "trophy",
  "beginner",
  "chess pawn",
  "game icon",
  "pawn",
  "silhouette",
  "tabletop",
  "tactic",
  "backward navigation",
  "before",
  "caret back",
  "chevron back",
  "arrow_forward",
  "chevron_forward",
  "fast_forward",
  "greater_than",
  "right_arrow",
  "next page",
  "next track",
  "babysitting",
  "child friendly",
  "childhood",
  "curl",
  "daycare",
  "hair",
  "kids zone",
  "parental",
  "preschool",
  "baby carriage",
  "baby products",
  "baby transport",
  "buggy",
  "canopy",
  "carriage",
  "family-friendly",
  "friendly",
  "hood",
  "juvenile",
  "kids friendly",
  "pram",
  "pushchair",
  "stroller",
  "travel with kids",
  "chip extraction",
  "data extraction",
  "depart",
  "eject",
  "extract",
  "leave",
  "undocking",
  "unplug",
  "condense",
  "lessen",
  "take away",
  "chrome reader mode",
  "clean view",
  "digital reading",
  "distraction-free",
  "mobile view",
  "readability",
  "simplify",
  "split view",
  "text mode",
  "chromecast 2",
  "dongle",
  "google cast",
  "streaming device",
  "chronic",
  "extended",
  "interval",
  "long-term",
  "persistent",
  "scheduling",
  "cathedral",
  "ceremony",
  "chapel",
  "christian",
  "christianity",
  "church",
  "crucifix",
  "faith",
  "funeral",
  "gathering",
  "holy",
  "map marker",
  "place of worship",
  "pray",
  "religious",
  "spirituality",
  "steeple",
  "wedding",
  "actor",
  "actress",
  "cinematic",
  "clapper",
  "clapperboard",
  "crew",
  "director",
  "film making",
  "headshot",
  "production",
  "slate",
  "circumference",
  "donut",
  "eye",
  "fish",
  "hoop",
  "null",
  "orb",
  "torus",
  "wide",
  "alert icon",
  "alert symbol",
  "bell icon",
  "bell symbol",
  "circle notification",
  "notification symbol",
  "round notification",
  "orbital",
  "satellite",
  "venn diagram",
  "cluster",
  "converging",
  "converging circles",
  "ext",
  "joining",
  "merging",
  "triangular",
  "additional",
  "clarify",
  "description",
  "explanation",
  "hamburger menu",
  "mobile menu",
  "supplement",
  "uncover",
  "bacteria",
  "disinfect",
  "germ",
  "germs",
  "handwashing",
  "infection",
  "sanitize",
  "sanitizer",
  "soap",
  "bleach",
  "bottle shape",
  "chores",
  "clean surface",
  "cleaning product",
  "cleaning supplies",
  "detergent",
  "disinfectant",
  "housekeeping",
  "housework",
  "sanitation",
  "sanitizing",
  "spring cleaning",
  "tidy",
  "tidying",
  "trigger spray",
  "washing",
  "wipe",
  "wiping",
  "bucket",
  "disinfection",
  "janitorial",
  "pail",
  "sterilization",
  "sterilize",
  "suds",
  "trapezoid",
  "utility",
  "vessel",
  "broom",
  "cleaning services",
  "dirt",
  "dustpan",
  "mess",
  "scoop",
  "sweep",
  "utensil",
  "clear all",
  "clear field",
  "clear input",
  "clear list",
  "clear selection",
  "clear text",
  "delete all",
  "remove all",
  "remove list",
  "stacked lines",
  "beams",
  "clear day",
  "clear sky",
  "daytime",
  "eight rays",
  "forecast",
  "solar",
  "sunny day",
  "sunrise",
  "sunset",
  "mini split",
  "split system",
  "wall mounted",
  "clinical notes",
  "consultation",
  "medic",
  "summary",
  "due",
  "accelerate",
  "clock arrow",
  "future",
  "time up",
  "10%",
  "circular progress",
  "loader",
  "partial circle",
  "percent",
  "ten percent",
  "1/4",
  "25%",
  "pie",
  "portion",
  "hourglass",
  "spinner",
  "90 degrees",
  "asynchronous",
  "background task",
  "alert close",
  "dialog close",
  "discard",
  "error close",
  "modal close",
  "notification close",
  "overlay close",
  "popup close",
  "window close",
  "arrow cross",
  "close fullscreen",
  "corner arrows",
  "cross arrows",
  "default view",
  "diagonal arrows",
  "exit fullscreen",
  "four way arrow",
  "leave fullscreen",
  "normal screen",
  "pointing in",
  "pointing inwards",
  "quad arrow",
  "standard view",
  "unfullscreen",
  "close dialog",
  "close window",
  "close_small",
  "eliminate",
  "kill",
  "remove small",
  "small close button",
  "accessibility options",
  "audio settings",
  "caption",
  "captioning",
  "captions",
  "cc",
  "closed caption",
  "closed captioning",
  "decoder",
  "disable subtitles",
  "double c",
  "media controls",
  "mute subtitles",
  "speech to text",
  "subtitle",
  "subtitles",
  "transcript",
  "turn off subtitles",
  "two c's",
  "video controls",
  "add subtitles",
  "enable closed captions",
  "turn on",
  "cc off",
  "no captions",
  "no subtitles",
  "cloudy",
  "cumulus",
  "nimbus",
  "overcast",
  "stratus",
  "cloud alert",
  "cloud error",
  "cloud issue",
  "cloud notification",
  "cloud problem",
  "cloud status",
  "cloud warning",
  "data alert",
  "data warning",
  "network alert",
  "network warning",
  "server alert",
  "server warning",
  "circled cloud",
  "cloud data",
  "cloud hosting",
  "cloud in circle",
  "cloud service",
  "cloud symbol",
  "data cloud",
  "data synchronization",
  "network storage",
  "cloud check",
  "cloud complete",
  "cloud success",
  "cloud tick",
  "complete download",
  "complete upload",
  "successful download",
  "successful upload",
  "synchronized",
  "cloud download",
  "downward arrow",
  "rounded shapes",
  "web storage",
  "access control",
  "cloud access",
  "cloud lock",
  "cloud security",
  "data encryption",
  "encryption",
  "internet security",
  "network security",
  "online security",
  "padlock",
  "private cloud",
  "restricted access",
  "secure cloud",
  "cloud delete",
  "cloud disabled",
  "cloud disconnect",
  "cloud off",
  "cloud remove",
  "delete cloud",
  "download disabled",
  "internet off",
  "no cloud",
  "no internet",
  "no wifi",
  "remove cloud",
  "upload disabled",
  "circular arrows",
  "data import",
  "data upload",
  "file upload",
  "save to cloud",
  "upload icon",
  "air pollution",
  "carbon",
  "carbon dioxide",
  "carbon footprint",
  "chemical",
  "climate change",
  "co2",
  "co2 emissions",
  "co2 icon",
  "co2 levels",
  "co2 reduction",
  "dioxide",
  "ecology",
  "emissions",
  "global warming",
  "greenhouse effect",
  "greenhouse gas",
  "reduce emissions",
  "co-present",
  "presenter",
  "seminar",
  "share screen",
  "slides",
  "togather",
  "wfh",
  "work from home",
  "code editor",
  "coding",
  "css",
  "develop",
  "engineer",
  "html",
  "ide",
  "javascript",
  "less than",
  "programming language",
  "snippet",
  "source code",
  "syntax",
  "code blocks",
  "code snippet",
  "code window",
  "developer tools",
  "edit code",
  "insert code",
  "code_off",
  "coding off",
  "no code",
  "power off",
  "suppress",
  "break time",
  "caffeine",
  "cappuccino",
  "coffee",
  "coffee shop",
  "cup",
  "espresso",
  "hot drink",
  "latte",
  "mocha",
  "mug",
  "plate",
  "set",
  "tea",
  "appliances",
  "break room",
  "brew",
  "brewing",
  "carafe",
  "coffee machine",
  "coffee maker",
  "coffee pot",
  "drip",
  "maker",
  "pour",
  "brain",
  "cognition",
  "ideas",
  "innovation",
  "mental",
  "mental process",
  "mind",
  "perception",
  "problem solving",
  "psychology",
  "reasoning",
  "swirl",
  "thinking",
  "thought",
  "thoughts",
  "understanding",
  "brainpower",
  "concept",
  "consciousness",
  "intellect",
  "neurology",
  "neuroscience",
  "carets",
  "collapse all",
  "compact",
  "double caret",
  "inverted v",
  "minimize all",
  "tree view",
  "accordion",
  "collapse content",
  "conceal",
  "content toggle",
  "display toggle",
  "expandable",
  "expansion",
  "fold",
  "hide content",
  "minimize content",
  "tuck",
  "visibility toggle",
  "add to library",
  "corner bookmark",
  "read later",
  "color fill",
  "color sampling",
  "colorize",
  "customization",
  "dropper",
  "eyedropper",
  "pipette",
  "sample",
  "colors",
  "colour",
  "dye",
  "graphic design",
  "pigment",
  "spill",
  "column layout",
  "combine columns",
  "join columns",
  "merge columns",
  "acting",
  "anonymous",
  "broadway",
  "comedy",
  "comedy mask",
  "comic",
  "drama",
  "entertainment genre",
  "expression",
  "funny",
  "humor",
  "laugh",
  "mask",
  "masks",
  "stage",
  "standup",
  "theatre",
  "theatrical mask",
  "tour",
  "anime",
  "cartoons",
  "comic book",
  "comic bubble",
  "comic strip",
  "comics",
  "graphic novels",
  "jagged",
  "manga",
  "opinion",
  "pointed",
  "thought bubble",
  "insert_comment",
  "cchat",
  "comment bank",
  "comment repository",
  "documentation",
  "feedback repository",
  "flagged comments",
  "important comments",
  "saved comments",
  "saved messages",
  "saved replies",
  "block comments",
  "cancel comments",
  "comments",
  "comments blocked",
  "comments disabled",
  "comments hidden",
  "comments off",
  "comments restricted",
  "comments slash",
  "conversation disabled",
  "conversation off",
  "disable comments",
  "feedback disabled",
  "feedback off",
  "hide comments",
  "message disabled",
  "message off",
  "mute comments",
  "no comments",
  "remove comments",
  "reply disabled",
  "reply off",
  "restrict comments",
  "silence comments",
  "speech bubble disabled",
  "speech bubble off",
  "turn off comments",
  "accomplish",
  "bind",
  "commit",
  "dedicate",
  "finalize",
  "pledge",
  "collaborate",
  "communities",
  "connections",
  "forums",
  "groups",
  "huddle",
  "social network",
  "teams",
  "commute mode",
  "commute time",
  "daily commute",
  "going out",
  "mode of transport",
  "multi-modal",
  "multimodal",
  "park and ride",
  "rideshare",
  "travel options",
  "travel time",
  "work commute",
  "a/b",
  "a/b testing",
  "dual",
  "edits",
  "evaluation",
  "similarity",
  "variants",
  "versus",
  "vs",
  "alongside",
  "collide",
  "compare arrows",
  "differentiate",
  "distinction",
  "opposite",
  "opposition",
  "shuffle",
  "together",
  "finding",
  "magnetic",
  "cogs",
  "teamwork",
  "bio",
  "compost",
  "compostable",
  "decomposable",
  "decompose",
  "decomposition",
  "eco",
  "environmental",
  "garden",
  "gardening",
  "green",
  "leafs",
  "leaves",
  "organic",
  "recycle",
  "recycling",
  "renewable",
  "sprout",
  "zero waste",
  "bring together",
  "constrict",
  "decrease height",
  "decrease size",
  "deflate",
  "flatten",
  "make smaller",
  "narrow",
  "push together",
  "squeeze",
  "zip",
  "computing",
  "pc",
  "personal computer",
  "workstation",
  "caret up",
  "computer arrow",
  "computer transfer",
  "computer upload",
  "laptop transfer",
  "laptop upload",
  "send to computer",
  "send to device",
  "send to laptop",
  "transfer to computer",
  "transfer to device",
  "upload to device",
  "upload to pc",
  "shut down",
  "assistance bell",
  "bellhop",
  "call for help",
  "concierge",
  "customer service",
  "customer support",
  "dome",
  "front desk",
  "guest services",
  "help desk",
  "hospitality service",
  "hotel service",
  "local",
  "request assistance",
  "ring for service",
  "service bell",
  "conditions",
  "criteria",
  "examination",
  "find person",
  "requirements",
  "search user",
  "user search",
  "admit",
  "confirmation number",
  "coupon",
  "stub",
  "tear-off",
  "voucher",
  "anomaly",
  "birth",
  "chromosome",
  "cleft",
  "condition",
  "congenital",
  "dna",
  "embryo",
  "fetus",
  "genetic",
  "hereditary",
  "inherited",
  "lip",
  "lips",
  "mouth",
  "mutation",
  "palate",
  "prenatal",
  "syndrome",
  "trait",
  "communicating",
  "contactless",
  "contactless connection",
  "remote connection",
  "social distance",
  "socialize",
  "wireless communication",
  "without",
  "connected tv",
  "digital tv",
  "internet tv",
  "online tv",
  "three arcs",
  "air traffic",
  "two airplanes",
  "crossed tools",
  "hammer",
  "improvement",
  "industrial",
  "industry",
  "manufacturing",
  "site maintenance",
  "under construction",
  "website maintenance",
  "wip",
  "work in progress",
  "911",
  "emergency contact",
  "in case of emergency",
  "address book",
  "contact us",
  "directory",
  "get in touch",
  "inquiry",
  "mail contact",
  "about us",
  "contact page",
  "listing",
  "call contact",
  "contact card",
  "contact info",
  "helpline",
  "phone book",
  "phone contact",
  "reach out",
  "ask",
  "faq",
  "get help",
  "question circle",
  "cardless",
  "contactless payment",
  "mobile pay",
  "near field communication",
  "nfc",
  "proximity",
  "touchless",
  "blocked contactless",
  "contactless blocked",
  "contactless disabled",
  "contactless off",
  "contactless payment off",
  "disabled contactless",
  "mobile payment off",
  "nfc disabled",
  "nfc off",
  "nfc payment off",
  "no contactless",
  "no mobile payment",
  "no nfc",
  "no proximity payment",
  "no tap",
  "no tap to pay",
  "no wireless payment",
  "off contactless",
  "proximity payment off",
  "signal off",
  "tap disabled",
  "tap off",
  "tap to pay off",
  "wireless payment off",
  "contact list",
  "find contact",
  "individuals",
  "manage contacts",
  "roster",
  "shoulders",
  "client",
  "clients",
  "customer",
  "customers",
  "offering",
  "offerings",
  "products",
  "content copy",
  "content duplication",
  "copy paste",
  "reproduce",
  "content_cut",
  "excerpt",
  "excise",
  "isolate",
  "scissors",
  "sever",
  "snip",
  "trim",
  "no document",
  "no entry",
  "no paste",
  "paste off",
  "audit",
  "content_paste_search",
  "context",
  "contextual",
  "contextual token",
  "custom",
  "data entry",
  "form field",
  "input field",
  "token",
  "user input",
  "variable",
  "agreement",
  "binding",
  "folded corner",
  "obligation",
  "official",
  "paperwork",
  "policy",
  "terms",
  "abolish",
  "cancel contract",
  "delete contract",
  "nullify",
  "remove contract",
  "repeal",
  "revoke",
  "terminate contract",
  "void",
  "x out",
  "adjust contrast",
  "black",
  "dark theme",
  "grayscale",
  "half and half",
  "light mode",
  "two halves",
  "two parts",
  "white",
  "yin yang",
  "adjustments",
  "editier",
  "filters",
  "half circle",
  "high contrast",
  "increases",
  "low contrast",
  "accessibility off",
  "contrast disabled",
  "contrast off",
  "contrast setting",
  "default contrast",
  "disable contrast",
  "line through",
  "normal contrast",
  "reset contrast",
  "sight",
  "view settings",
  "camera control",
  "reposition",
  "video control",
  "constitute",
  "establish",
  "generation",
  "initiate",
  "institute",
  "make",
  "originate",
  "regulator",
  "connecting",
  "conversion path",
  "funnel",
  "sales funnel",
  "two points",
  "cancel conversion",
  "conversion blocked",
  "conversion disabled",
  "conversion off",
  "disable conversion",
  "flow off",
  "funnel off",
  "journey off",
  "no conversion",
  "path blocked",
  "path disabled",
  "path off",
  "process off",
  "route disabled",
  "route off",
  "sequence off",
  "stop conversion",
  "workflow off",
  "convert",
  "decode",
  "encode",
  "parse",
  "translate",
  "assembly line",
  "conveyor",
  "conveyor belt",
  "factory",
  "logistic",
  "manufactory",
  "manufacturing process",
  "production line",
  "supply",
  "biscuit",
  "bite",
  "chocolate chip",
  "chunk",
  "cookie",
  "cookies",
  "crumbs",
  "eaten",
  "eating",
  "missing piece",
  "wafer",
  "web cookie",
  "anti-tracking",
  "block cookies",
  "block tracking",
  "browser settings",
  "clear cookies",
  "cookie off",
  "data privacy",
  "disable cookies",
  "internet privacy",
  "no cookies",
  "no tracking",
  "reject cookies",
  "remove cookies",
  "web tracking",
  "website tracking",
  "boil",
  "braiser",
  "burner",
  "cast iron",
  "cooking pot",
  "cooktop",
  "cookware",
  "dutch oven",
  "hob",
  "induction",
  "lid",
  "meals",
  "prepare",
  "simmer",
  "stockpot",
  "stove",
  "stovetop",
  "cool ",
  "dry",
  "evaporation",
  "ripples",
  "copy all",
  "copy content",
  "all rights reserved",
  "circled c",
  "commercial use",
  "fair use",
  "infringement",
  "letter c",
  "registered",
  "reserved",
  "rights",
  "contagion",
  "epidemic",
  "isolation",
  "microbe",
  "outbreak",
  "pathogen",
  "quarantine",
  "sick",
  "spikes",
  "fare",
  "fee",
  "invoice",
  "homestead",
  "rooftop",
  "village",
  "looks",
  "none",
  "score",
  "tally",
  "single",
  "2 items",
  "number 2",
  "number two",
  "two items",
  "badge count",
  "notification count",
  "numeric",
  "message count",
  "six",
  "balls",
  "billiard",
  "snooker",
  "cabinet",
  "countertop surface",
  "countertops",
  "dishwashing",
  "kitchen counter",
  "remodel",
  "tops",
  "vanity",
  "add folder",
  "create directory",
  "create folder",
  "create new folder",
  "folder management",
  "new directory",
  "new folder",
  "plus folder",
  "debt",
  "e-commerce",
  "swipe",
  "bnpl",
  "credit card activity",
  "credit card expiry",
  "credit card payment time",
  "credit card timer",
  "expiry",
  "pay later",
  "pay over time",
  "payment due",
  "payment pending",
  "payment schedule",
  "payment time",
  "purchase history",
  "transaction history",
  "billing settings",
  "card settings",
  "configure billing",
  "configure payment",
  "credit card settings",
  "debit",
  "edit billing",
  "edit payment",
  "finance settings",
  "manage billing",
  "manage payment",
  "money management",
  "payment options",
  "payment settings",
  "charity",
  "redeem",
  "no card",
  "no credit card",
  "no payment",
  "credit score",
  "baby furniture",
  "cradle",
  "lullaby",
  "rocker",
  "sleeping",
  "swing",
  "crisis",
  "power button",
  "cropping tool",
  "image crop",
  "image manipulation",
  "photo crop",
  "by",
  "proportion",
  "3:2 ratio",
  "crop tool",
  "edit image",
  "edit photo",
  "image adjust",
  "image frame",
  "image resize",
  "image trim",
  "photo resize",
  "picture crop",
  "picture resize",
  "5:4",
  "crop image",
  "crop photo",
  "editing settings",
  "five by four",
  "five to four",
  "image proportions",
  "photo proportions",
  "7 by 5",
  "7:5",
  "picture adjustment",
  "9:16",
  "mobile first",
  "mobile video",
  "portrait video",
  "sixteen by nine",
  "social media video",
  "story format",
  "vertical format",
  "vertical video",
  "crop free",
  "free",
  "free aspect ratio",
  "freeform",
  "freeform crop",
  "180 degrees",
  "adjust image",
  "image editor",
  "image rotation",
  "photo manipulation",
  "1:1",
  "crop din",
  "crop square",
  "crop to square",
  "din",
  "square crop tool",
  "brain teaser",
  "crossword",
  "letter game",
  "mental exercise",
  "mind game",
  "puzzle",
  "trivia",
  "word game",
  "word puzzle",
  "words",
  "crowd",
  "crowdsource",
  "funding",
  "hands up",
  "participation",
  "polling",
  "sourcing",
  "user generated content",
  "diadem",
  "headwear",
  "leader",
  "leadership",
  "monarchy",
  "noble",
  "tiara",
  "tier",
  "animal friendly",
  "beauty",
  "bunny",
  "compassion",
  "cosmetics",
  "cruelty",
  "cruelty free",
  "ears",
  "ethical",
  "humane",
  "kindness",
  "makeup",
  "no animal testing",
  "not tested on animals",
  "pet",
  "product label",
  "rabbit",
  "skincare",
  "vegan",
  "vegetarian",
  "wildlife",
  "cascading style sheets",
  "frontend",
  "sans-serif",
  "software development",
  "stylesheet",
  "web design",
  "web development",
  "comma",
  "comma separated values",
  "csv",
  "data exchange",
  "data file",
  "file extension",
  "file type",
  "separated",
  "spreadsheets",
  "text file",
  "values",
  "bitcoin",
  "blockchain",
  "btc",
  "crypto",
  "cryptocurrency",
  "decentralized",
  "digital currency",
  "franc",
  "letter b",
  "mining",
  "virtual currency",
  "currency exchange",
  "universal",
  "central african cfa franc",
  "cfa franc",
  "cfp franc",
  "chf",
  "comorian franc",
  "djiboutian franc",
  "foreign currency",
  "france",
  "france money",
  "french franc",
  "guinean franc",
  "international",
  "swiss",
  "swiss franc",
  "swiss money",
  "switzerland",
  "west african cfa franc",
  "letter l",
  "lira",
  "try",
  "turkey",
  "turkish",
  "turkish lira",
  "british pound",
  "england",
  "foreign exchange",
  "forex",
  "gbp",
  "great britain",
  "great britain pound",
  "monetary",
  "pound",
  "pound sterling",
  "sterling",
  "uk",
  "united kingdom",
  "£",
  "cyrillic",
  "economics",
  "letter p",
  "rub",
  "ruble",
  "russia",
  "russian ruble",
  "capital letter r",
  "economic",
  "india",
  "indian rupee",
  "inr",
  "rupee",
  "asia",
  "asian",
  "letter y",
  "yen",
  "¥",
  "china",
  "chinese",
  "cny",
  "crossbar",
  "renminbi",
  "rmb",
  "yuan",
  "curtain rods",
  "drapery",
  "drapes",
  "home decor",
  "stage curtain",
  "theater curtains",
  "window frame",
  "closed blinds",
  "curtain",
  "vertical rectangles",
  "custom typography",
  "text editing",
  "iteration",
  "reuse",
  "atmospheric",
  "cyclone",
  "eye of the storm",
  "hurricane",
  "low pressure",
  "natural",
  "natural disaster",
  "rain",
  "tornado",
  "typhoon",
  "vortex",
  "winds",
  "windy",
  "dangerous",
  "multiplication sign",
  "wrong",
  "light switch",
  "user preferences",
  "main",
  "overview",
  "widgets",
  "dashboard 2",
  "homepage",
  "reports",
  "widget",
  "data_alert",
  "lists",
  "coder",
  "data array",
  "data collection",
  "data container",
  "data element",
  "data format",
  "data list",
  "data sequence",
  "data structure",
  "delimiter",
  "json",
  "data approved",
  "data check",
  "data complete",
  "data validation",
  "data verification",
  "information check",
  "information verified",
  "analysis tool",
  "data exploration",
  "data mining",
  "upward trend",
  "advice",
  "information icon",
  "tip",
  "data loss prevention",
  "information protection",
  "loss",
  "results about you",
  "seek",
  "sensitive data",
  "threat detection",
  "vulnerability",
  "braces",
  "coding tools",
  "curly brackets",
  "data object",
  "bandwidth",
  "data control",
  "data economy",
  "data limit",
  "data restriction",
  "data saver",
  "data saving",
  "data settings",
  "data usage",
  "internet data",
  "limit data",
  "network data",
  "network management",
  "reduce data",
  "restrict data",
  "save data",
  "catalog",
  "data table",
  "data filtering",
  "data thresholding",
  "thresholding",
  "thresold",
  "data saver off",
  "data usage off",
  "disable data",
  "enable data",
  "usage",
  "big data",
  "cylinder",
  "mysql",
  "nosql",
  "postgresql",
  "sql",
  "warehousing",
  "data disabled",
  "data offline",
  "database disabled",
  "database off",
  "database offline",
  "no data",
  "no database",
  "no server",
  "no storage",
  "server disabled",
  "server off",
  "server offline",
  "storage disabled",
  "storage off",
  "storage offline",
  "data inspection",
  "data lookup",
  "data query",
  "data search",
  "database query",
  "database search",
  "disks",
  "explore data",
  "find data",
  "find information",
  "information retrieval",
  "inspect data",
  "search icon",
  "cloud storage upload",
  "database import",
  "dataset",
  "dataset link",
  "linked data",
  "related",
  "relation",
  "relational",
  "table link",
  "calendar event",
  "date range",
  "date_range",
  "period",
  "schedule event",
  "deblur",
  "bereavement",
  "bloom",
  "blossom",
  "cemetery",
  "condolences",
  "death",
  "deceased",
  "died",
  "end of life",
  "flowers",
  "fragility",
  "grave",
  "grief",
  "life cycle",
  "mourning",
  "obituary",
  "passed away",
  "rest in peace",
  "rip",
  "sympathy",
  "tulip",
  "yard",
  "decimal",
  "decrement",
  "fine-tune",
  "fraction",
  "fractions",
  "less",
  "smaller",
  "bigger",
  "decimal point",
  "greater",
  "larger",
  "backyard",
  "chairs",
  "furniture set",
  "lawn",
  "outdoor seating",
  "two chairs",
  "dehaze",
  "haze",
  "interface menu",
  "unhide",
  "website menu",
  "delete_outline",
  "disposal",
  "expunge",
  "garbage can",
  "rub out",
  "waste",
  "wastebasket",
  "delete forever",
  "dustbin",
  "obliterate",
  "permanently delete",
  "remove permanently",
  "trash bin",
  "x mark",
  "cancel history",
  "circular time",
  "clear history",
  "clock with x",
  "delete history",
  "history removal",
  "remove history",
  "time with x",
  "delete many",
  "delete selection",
  "delete_sweep",
  "fast delete",
  "multiple delete",
  "quick delete",
  "delivery truck",
  "electric delivery",
  "fast delivery",
  "quick shipping",
  "rush",
  "sustainable delivery",
  "delivery service",
  "expedite",
  "express delivery",
  "next day delivery",
  "rapid shipping",
  "same day delivery",
  "census",
  "demography",
  "hr",
  "human resources",
  "population",
  "society",
  "content density",
  "density",
  "double space",
  "information density",
  "line spacing",
  "magnification",
  "single space",
  "text density",
  "medium density",
  "density_small",
  "four lines",
  "layout density",
  "visual density",
  "cavity",
  "checkup",
  "dental",
  "dental care",
  "dentist",
  "dentistry",
  "enamel",
  "flossing",
  "gum",
  "implant",
  "molar",
  "oral",
  "root canal",
  "teeth whitening",
  "tooth",
  "toothbrush",
  "veneer",
  "arrival time",
  "bus schedule",
  "coach",
  "departure time",
  "metro",
  "public transit",
  "train schedule",
  "transport schedule",
  "deployed_code",
  "deployment",
  "installed",
  "packet",
  "three-dimensional",
  "artifact",
  "deployed",
  "cicd",
  "containerization",
  "devops",
  "docker",
  "kubernetes",
  "version",
  "deliver",
  "product launch",
  "acne",
  "blackhead",
  "blemish",
  "comedone extractor",
  "cosmetology",
  "derm",
  "dermatology",
  "estetics",
  "esthetics",
  "extraction",
  "facial",
  "follicle",
  "metal",
  "pore",
  "pores",
  "skin",
  "skin care",
  "whitehead",
  "architecture tools",
  "construction tools",
  "design services",
  "design tools",
  "drafting tools",
  "engineering tools",
  "ruler",
  "drawers",
  "home office",
  "line art",
  "minimalist",
  "office furniture",
  "simple desk",
  "three drawers",
  "calling",
  "communication device",
  "desk phone",
  "desk phone icon",
  "dialing",
  "office phone",
  "telephone icon",
  "telephone receiver",
  "computer access disabled",
  "desktop off",
  "monitor disabled",
  "remote access disabled",
  "screen disabled",
  "cloud desktop service",
  "daas",
  "desktop access",
  "desktop as a service",
  "online desktop",
  "remote access",
  "remote desktop",
  "virtual desktop",
  "cloud desktop",
  "cloud infrastructure",
  "virtual machine",
  "virtual workspace",
  "change view",
  "multitasking",
  "second screen",
  "splitscreen",
  "add desktop",
  "add display",
  "add landscape",
  "add screen",
  "add window",
  "create desktop",
  "create display",
  "create landscape",
  "create screen",
  "create window",
  "new desktop",
  "new display",
  "new landscape",
  "new screen",
  "plus desktop",
  "plus display",
  "plus screen",
  "desktop computer",
  "imac",
  "screen rotation",
  "bang",
  "detonate",
  "detonator",
  "dynamite",
  "impact",
  "kaboom",
  "sparkles",
  "additional information",
  "collapse icon",
  "drill down",
  "expand details",
  "expand icon",
  "hide details",
  "show details",
  "submenu",
  "supplementary",
  "detection zone",
  "monitored area",
  "motion detection",
  "person in area",
  "person in zone",
  "zone detection",
  "co",
  "detector",
  "radar",
  "building security",
  "detector alarm",
  "intrusion detection",
  "detector power",
  "sensor battery",
  "smart sensor",
  "wireless sensor",
  "carbon monoxide",
  "fault",
  "malfunction",
  "not working",
  "ceiling",
  "fire alarm",
  "fire detector",
  "fumes",
  "mount",
  "smoke detector",
  "functional",
  "operational",
  "working",
  "breadboard",
  "circuit",
  "developer board",
  "embedded",
  "microchip",
  "microcontroller",
  "pins",
  "ports",
  "processor",
  "prototype",
  "stem",
  "arduino",
  "board off",
  "circuit board",
  "circuit off",
  "deactivated board",
  "development off",
  "disable board",
  "electronics off",
  "embedded off",
  "hardware off",
  "no board",
  "no electronics",
  "programming off",
  "raspberry pi",
  "stop board",
  "booklet",
  "guideline",
  "handbook",
  "instructions",
  "manual",
  "sdk",
  "developer mode",
  "mobile code",
  "tv code",
  "tv developer mode",
  "tv programming",
  "tv settings",
  "calories",
  "wristband",
  "combining",
  "connected devices",
  "device connection",
  "device link",
  "device network",
  "multiple devices",
  "network hub",
  "celsius",
  "degrees",
  "fahrenheit",
  "home climate control",
  "mercury",
  "smart thermostat",
  "temperature sensor",
  "thermometer",
  "device_unknown",
  "how",
  "missing",
  "mobile_question",
  "troubleshooting",
  "unidentified",
  "what",
  "why",
  "devices",
  "phonelink",
  "tethering",
  "closing",
  "dual screen",
  "foldable",
  "folding",
  "hinge",
  "peel",
  "connection management",
  "disable casting",
  "disable mirroring",
  "disable projection",
  "disable sharing",
  "disabled device",
  "disabled phone",
  "disconnect device",
  "disconnect phone",
  "no casting",
  "no devices",
  "no mirroring",
  "no network",
  "no pairing",
  "no projection",
  "no sharing",
  "remove device",
  "remove phone",
  "stop casting",
  "stop mirroring",
  "stop projection",
  "stop sharing",
  "unpair",
  "accessories",
  "ecosystem",
  "ipad",
  "rounded corner",
  "wearable technology",
  "dew",
  "dew point",
  "dewpoint",
  "droplets",
  "drops",
  "precipitation",
  "saturation",
  "three drops",
  "water vapor",
  "health report",
  "medical report",
  "association",
  "bond",
  "endpoints",
  "ends",
  "oblique",
  "relationship",
  "slanted",
  "slope",
  "dial icon",
  "dialer",
  "handset icon",
  "initiation",
  "internet call",
  "internet telephony",
  "network call",
  "online call",
  "over",
  "session",
  "session initiation protocol",
  "sip",
  "sip icon",
  "voice over ip",
  "voip icon",
  "dialogs",
  "nested boxes",
  "nested squares",
  "talking",
  "dialpad",
  "number pad",
  "pad",
  "pbx",
  "push buttons",
  "ten",
  "tone",
  "touch",
  "crystal",
  "elegant",
  "expensive",
  "facet",
  "gems",
  "gemstone",
  "jewel",
  "jewelry",
  "sparkle",
  "top tier",
  "treasure",
  "valuable",
  "valuables",
  "glossary",
  "lexicon",
  "thesaurus",
  "translation",
  "vocabulary",
  "word",
  "diff",
  "dissimilarity",
  "two files",
  "variation",
  "billboard",
  "digital out of home",
  "digital signage",
  "dooh",
  "interactive",
  "kiosk",
  "outdoor advertising",
  "pedestrian",
  "public display",
  "public space",
  "digital detox",
  "digital wellbeing",
  "harmony",
  "health settings",
  "healthy",
  "healthy lifestyle",
  "mental health",
  "mental health settings",
  "mindfulness",
  "screen time",
  "self-care",
  "spirit",
  "well-being",
  "wellbeing settings",
  "cafeteria",
  "cutlery",
  "diner",
  "eatery",
  "food court",
  "hunger",
  "nutrition",
  "silverware",
  "spoon",
  "supper",
  "table service",
  "dinner time",
  "dish",
  "eat out",
  "italian",
  "noodles",
  "pasta",
  "spaghetti",
  "utensils",
  "change direction",
  "turn right",
  "direction right",
  "directions alternative",
  "directions_alt",
  "alt route off",
  "alternate directions off",
  "alternate route off",
  "directions alt off",
  "directions disabled",
  "gps disabled",
  "gps off",
  "location disabled",
  "location off",
  "map disabled",
  "map off",
  "navigation disabled",
  "no alt route",
  "no alternate route",
  "no directions",
  "no navigation",
  "biker",
  "riding",
  "directions_boat",
  "directions_boat_filled",
  "sail",
  "sailing",
  "watercraft",
  "car icon",
  "estimated time of arrival",
  "eta",
  "front view",
  "time to leave",
  "cancel location",
  "cancel navigation",
  "cancel route",
  "directions off",
  "disable directions",
  "disable gps",
  "disable location",
  "disable navigation",
  "navigation off",
  "no gps",
  "no route",
  "turn off directions",
  "railroad",
  "underground",
  "athlete",
  "jogger",
  "jogging",
  "marathon",
  "moving",
  "race",
  "racing",
  "run",
  "runner",
  "sprint",
  "sprinting",
  "locomotion",
  "metropolitan",
  "tube",
  "underground railway",
  "crosswalk",
  "pedestrian crossing",
  "person walking",
  "stroll",
  "trek",
  "walking man",
  "🚶",
  "syncing",
  "bad photo",
  "blocked lens",
  "blot",
  "camera error",
  "camera malfunction",
  "camera problem",
  "corrupt image",
  "dirty",
  "dirty camera",
  "dirty lens",
  "lens cap",
  "lens problem",
  "obscured lens",
  "obstruction",
  "photo error",
  "photography problem",
  "picture error",
  "smudge",
  "splash",
  "splat",
  "splatter",
  "spot",
  "stain",
  "disabled by default",
  "blocked view",
  "cancel view",
  "circle slash",
  "eye crossed",
  "eye disabled",
  "eye off",
  "eye slash",
  "no view",
  "no visibility",
  "restricted view",
  "show disabled",
  "sight disabled",
  "sight off",
  "unseen",
  "unview",
  "view disabled",
  "view hidden",
  "visibility off",
  "visible",
  "vision disabled",
  "vision off",
  "blu-ray",
  "capacity limit",
  "disk full",
  "disk space",
  "dvd",
  "full disc",
  "full storage",
  "no space",
  "optical disc",
  "optical media",
  "storage capacity",
  "storage full",
  "eq",
  "equalizer",
  "horizontal slider",
  "vertical sliders",
  "appliance control",
  "automatic dishwasher",
  "chore",
  "clean dishes",
  "dishes",
  "dishwasher",
  "kitchen appliance",
  "wash cycle",
  "wash dishes",
  "washer",
  "washing machine",
  "water drop",
  "connect to display",
  "dual monitors",
  "extend display",
  "external device",
  "external input",
  "external output",
  "mirror display",
  "multiple displays",
  "display adjustment",
  "display configuration",
  "display options",
  "here",
  "location services",
  "abstract people",
  "culture",
  "diverse",
  "members",
  "multicultural",
  "partnership",
  "togetherness",
  "unity",
  "belonging",
  "ethnicity",
  "interwoven",
  "connected group",
  "user group",
  "empathy",
  "humanity",
  "non-profit",
  "respect",
  "tolerance",
  "dns",
  "domain",
  "it",
  "nameserver",
  "resolve",
  "two rectangles",
  "alerts on",
  "allow alerts",
  "allow disturbances",
  "allow notifications",
  "allow sounds",
  "deny",
  "dnd off",
  "do",
  "do disturb off",
  "do not disturb off",
  "focus off",
  "notifications on",
  "quiet mode off",
  "remove restriction",
  "ringer on",
  "silence off",
  "sleep off",
  "sounds on",
  "unmute",
  "unrestricted",
  "volume on",
  "work off",
  "circle outline",
  "not",
  "alarms off",
  "ban",
  "busy",
  "complete silence",
  "interruptions off",
  "no alerts",
  "no notifications",
  "notification settings",
  "on total",
  "phone settings",
  "ringer off",
  "silent mode",
  "sound off",
  "sound settings",
  "total silence",
  "volume off",
  "do not enter",
  "do not step",
  "keep off",
  "no step",
  "no stepping",
  "no trespassing",
  "shoe",
  "slanted line",
  "sneaker",
  "stepping",
  "do not touch",
  "don't touch",
  "hands off",
  "keep out",
  "no touch",
  "off limits",
  "unauthorized",
  "peripheral",
  "dock to bottom",
  "shelf",
  "snap",
  "taskbar",
  "dock to left",
  "left dock",
  "screen layout",
  "side panel",
  "split screen",
  "window management",
  "app layout",
  "application layout",
  "dock right",
  "interface layout",
  "position right",
  "right dock",
  "right panel",
  "right sidebar",
  "view arrangement",
  "docs",
  "add-on",
  "addon",
  "extension",
  "OCR",
  "digitize document",
  "document capture",
  "document scan",
  "optical character recognition",
  "scan document",
  "document icon",
  "document search",
  "explore document",
  "file icon",
  "file search",
  "find document",
  "find page",
  "inspect document",
  "loupe",
  "magnifying glass on document",
  "search file",
  "search page",
  "corporation",
  "headquarters",
  "add domain",
  "company registration",
  "create domain",
  "domain creation",
  "domain registration",
  "domain setup",
  "new domain",
  "web address",
  "domain inactive",
  "suspend",
  "website disabled",
  "application desktop",
  "domain security",
  "domain validated",
  "https",
  "ssl",
  "tls",
  "validated",
  "website security",
  "invalid",
  "costume",
  "disguise",
  "domino",
  "domino mask",
  "eye mask",
  "incognito",
  "masquerade",
  "secret",
  "superhero",
  "unmask",
  "villain",
  "checkmarks",
  "complete all",
  "completed tasks",
  "done all",
  "double check",
  "finish all",
  "ticks",
  "check outline",
  "thin checkmark",
  "donut_large",
  "doughnut chart",
  "hole",
  "two-part",
  "donut_small",
  "doughnut",
  "part",
  "door knob",
  "front door",
  "single door",
  "door frame",
  "entryway",
  "open door",
  "passage",
  "breach",
  "building automation",
  "door sensor",
  "intrusion",
  "automatic door",
  "double door",
  "elevator",
  "partition",
  "sliding",
  "sliding door",
  "two doors",
  "doorbell",
  "guest",
  "3 people",
  "doorbell_3p",
  "fast forward",
  "fast skip",
  "alpine skiing",
  "athletic",
  "downhill",
  "downhill skiing",
  "ski social",
  "skier",
  "skiing",
  "skis",
  "slopes",
  "downloads",
  "file download",
  "get app",
  "save alt",
  "save icon",
  "download complete",
  "download done",
  "download finished",
  "download successful",
  "file complete",
  "file downloaded",
  "file finished",
  "import complete",
  "import finished",
  "save complete",
  "save finished",
  "available offline",
  "device storage",
  "download for offline",
  "for offline",
  "keep",
  "local storage",
  "offline access",
  "offline use",
  "offline viewing",
  "save offline",
  "acquisition",
  "content download",
  "digital asset",
  "downloading",
  "order processing",
  "orders",
  "preliminary",
  "unfinished",
  "compose message",
  "drafts",
  "drag click",
  "selects",
  "application ui",
  "drag and drop",
  "drag handle",
  "draggable",
  "reorder",
  "drag indicator",
  "grabber",
  "manipulator",
  "six circles",
  "three by two",
  "vertical dots",
  "directional arrows",
  "four directions",
  "map navigation",
  "move tool",
  "pan tool",
  "screen navigation",
  "with",
  "annotate",
  "doodle",
  "freehand",
  "handwriting",
  "illustrate",
  "scribble",
  "stylus",
  "abstraction",
  "artwork",
  "squiggle",
  "abstract shape",
  "glue",
  "bedroom furniture",
  "bureau",
  "chest of drawers",
  "decor",
  "dresser",
  "home furnishings",
  "sideboard",
  "content migration",
  "data migration",
  "folder transfer",
  "migrate",
  "relocate",
  "drive folder",
  "folder drive",
  "folder upload",
  "upload cloud",
  "upload folder",
  "choose color",
  "color picker",
  "color selector",
  "copy color",
  "element selection",
  "extract color",
  "identify color",
  "inspect color",
  "inspect element",
  "observe",
  "sample color",
  "select element",
  "air dry",
  "arid",
  "dehydration",
  "desert",
  "dry hands",
  "dryer",
  "drying",
  "evaporate",
  "hand dryer",
  "no water",
  "thermal",
  "vapor",
  "clothes care",
  "dry cleaning",
  "dry cleaning service",
  "dryclean",
  "garment care",
  "laundry",
  "laundry service",
  "towel",
  "valet",
  "valet service",
  "application window",
  "dual monitor",
  "duo",
  "extended display",
  "multiple monitors",
  "screen extend",
  "screens",
  "two monitors",
  "two screens",
  "waterdrop",
  "bullets",
  "digital video recorder",
  "dvr",
  "'mail_outline'",
  "'markunread'. Keep 'mail' and remove others.",
  "Duplicate of 'email'",
  "atom",
  "dynamic feed",
  "rss",
  "dynamic form",
  "efficient",
  "fields",
  "communication alert",
  "contact emergency",
  "emergency call",
  "phone alert",
  "telephone notification",
  "urgent call",
  "beacon",
  "emergency light",
  "first responder",
  "flashing",
  "police",
  "2g",
  "e",
  "letter e",
  "cellular indicator",
  "connection badge",
  "data badge",
  "mobile badge",
  "mobile indicator",
  "network badge",
  "network indicator",
  "aids",
  "amplify",
  "ear",
  "earbud",
  "headphone",
  "headset",
  "hearing aids",
  "listening",
  "mono",
  "sound on",
  "soundwave",
  "charging case",
  "earbud case",
  "earbuds",
  "earphone",
  "earphones",
  "open case",
  "audio device",
  "audio input",
  "earbud left",
  "handsfree",
  "in-ear",
  "left earbud",
  "left side",
  "listening device",
  "single earbud",
  "sound device",
  "earbud right",
  "right ear",
  "right earbud",
  "audio controls",
  "headphone jack",
  "listen to music",
  "music controls",
  "earbuds_2",
  "in-ear headphones",
  "portable audio",
  "wireless earbuds",
  "earbuds battery",
  "headphone battery",
  "early",
  "soon",
  "timely",
  "aftershock",
  "catastrophe",
  "earth",
  "earthquake",
  "fault line",
  "geology",
  "geophysics",
  "ground motion",
  "plates",
  "preparedness",
  "seismic",
  "seismograph",
  "shake",
  "tectonic",
  "tremor",
  "ahead",
  "directional",
  "further",
  "onwards",
  "orient",
  "rightward",
  "waveform",
  "heart rhythm",
  "lifeline",
  "botanical",
  "conservation",
  "eco icon",
  "eco-friendly",
  "economical",
  "environment protection",
  "leaf icon",
  "biometric",
  "eda",
  "electrodermal",
  "electrodermal activity responses",
  "electrodermal responses",
  "open hand",
  "thumb",
  "edge sensor",
  "high alert",
  "mobile sensor",
  "vibrate",
  "auxiliary",
  "auxiliary sensor",
  "flanking",
  "flanking sensors",
  "limited range",
  "short range",
  "side bars",
  "side sensors",
  "supplementary sensor",
  "compose mode",
  "edit mode",
  "elevate",
  "shift up",
  "attributes",
  "edit attributes",
  "properties",
  "adjust sound",
  "audio adjust",
  "audio editing",
  "change sound",
  "edit audio",
  "edit sound",
  "horizontal arrows",
  "modify sound",
  "music editing",
  "scrub",
  "sound adjust",
  "sound controls",
  "sound editing",
  "timing",
  "change date",
  "e appointment",
  "edit calendar",
  "edit date",
  "modify event",
  "reschedul",
  "update schedule",
  "compose document",
  "document editing",
  "edit document",
  "edit file",
  "file edit",
  "file editing",
  "modify document",
  "revise document",
  "update document",
  "change location",
  "edit location",
  "edit marker",
  "edit pin",
  "edit place",
  "location editing",
  "map edit",
  "map marker edit",
  "modify location",
  "place edit",
  "update location",
  "edit gps",
  "edit map",
  "edit navigation",
  "edit pinpoint",
  "edit pointer",
  "edit position",
  "map pin",
  "edit text",
  "memo",
  "note taking",
  "taking notes",
  "writing tool",
  "alert settings",
  "change notification",
  "edit notification",
  "modify notification",
  "notification preferences",
  "pen icon",
  "pencil icon",
  "reminder settings",
  "update notification",
  "cancel edit",
  "cancel pencil",
  "cancel writing",
  "disable edit",
  "disable pencil",
  "disable writing",
  "edit off",
  "editing disabled",
  "no edit",
  "no pencil",
  "no writing",
  "pencil off",
  "read only",
  "remove edit",
  "writing off",
  "change road",
  "edit road",
  "edit route",
  "modify road",
  "plan route",
  "roadwork",
  "update road",
  "annotations",
  "edit square",
  "markup",
  "pencil square",
  "square edit",
  "editor choice",
  "editor pick",
  "editor's choice",
  "editor's pick",
  "recommendation",
  "recommended",
  "top pick",
  "win",
  "baking",
  "bird",
  "chicken",
  "diet",
  "easter",
  "egg",
  "ellipse",
  "ingredient",
  "new life",
  "yolk",
  "blob",
  "fried egg",
  "external storage",
  "pop out",
  "pop-out",
  "push out",
  "push-out",
  "elder",
  "geriatric",
  "old",
  "pensioner",
  "retiree",
  "retirement",
  "social security",
  "elderly care",
  "girl",
  "grandma",
  "grandmother",
  "grandparent",
  "lady",
  "retired",
  "senior citizen",
  "women",
  "e-bike",
  "ebike",
  "electric bike",
  "motorized bicycle",
  "pedal assist",
  "electric icon",
  "electric power",
  "electric shock",
  "electricity symbol",
  "energy symbol",
  "lightning bolt symbol",
  "power symbol",
  "thunder",
  "charge station",
  "electric car",
  "electric station",
  "ampere",
  "consumption",
  "electric meter",
  "kilowatts",
  "two legs",
  "volts",
  "watts",
  "eco friendly",
  "electric charge",
  "electric moped",
  "green transport",
  "ride sharing",
  "sustainable transport",
  "auto rickshaw",
  "battery powered",
  "cab",
  "electric auto",
  "electric rickshaw",
  "electric transport",
  "rickshaw",
  "taxi",
  "three wheeler",
  "tuk tuk",
  "zero emission",
  "dockless",
  "handlebar",
  "micro-mobility",
  "personal mobility",
  "urban transport",
  "ac power",
  "dc power",
  "electrical services",
  "electrical work",
  "electrician",
  "hill",
  "hills",
  "incline",
  "inclines",
  "ramp",
  "tiers",
  "building navigation",
  "conveyance",
  "floor",
  "vertical transport",
  "six pointed star",
  "boiler",
  "emergency heat",
  "furnace",
  "heat alert",
  "house fire",
  "overheat",
  "auxiliary heat",
  "extreme temperature",
  "heat waves",
  "high temperature",
  "temperature warning",
  "wavy",
  "emergency services",
  "evidence",
  "coordinates",
  "drop a pin",
  "emergency location",
  "find my location",
  "location sharing",
  "share location",
  "broadcast off",
  "disable emergency",
  "emergency sharing off",
  "find off",
  "locate off",
  "no location",
  "no share",
  "pin off",
  "share off",
  "sharing off",
  "coaster",
  "drink menu",
  "herbal tea",
  "hot beverage menu",
  "infusion",
  "refreshment",
  "tea bag",
  "tea time",
  "teacup",
  "warm beverage",
  "abroad",
  "dialect",
  "foreign language",
  "global communication",
  "intercultural",
  "internationalization",
  "keyboards",
  "localization",
  "multilingual",
  "worldwide",
  "bee",
  "daisy",
  "floral",
  "honey",
  "ladybug",
  "meadow",
  "petals",
  "pollination",
  "wings",
  "creative",
  "emoji_objects",
  "filament",
  "inspiration",
  "invention",
  "objects",
  "solution",
  "suggestion",
  "arm",
  "hello",
  "hi",
  "raised hand",
  "waving",
  "ampersand",
  "and",
  "equal sign",
  "hieroglyph",
  "symbols",
  "cityscape",
  "town",
  "feeling",
  "flirt",
  "kind",
  "nice",
  "satisfied",
  "tease",
  "wink",
  "winking",
  "empty state",
  "engage",
  "startup",
  "cybersecurity",
  "defend",
  "encrypted",
  "information security",
  "keyhole",
  "latch",
  "lock and key",
  "safeguard",
  "system security",
  "add encrypted",
  "add encryption",
  "add privacy",
  "add protection",
  "add security",
  "enhance security",
  "increase security",
  "new encryption",
  "new security",
  "plus privacy",
  "plus protection",
  "plus security",
  "add account",
  "add safe",
  "add safety",
  "increase privacy",
  "new user",
  "decrypt",
  "disable encryption",
  "encryption off",
  "remove encryption",
  "unencrypted",
  "decrypted",
  "disable security",
  "exposed",
  "insecure",
  "lock off",
  "no encryption",
  "no security",
  "protection off",
  "security off",
  "shield off",
  "unlocked",
  "adrenal gland",
  "double curve",
  "endocrine system",
  "endocrinology",
  "gland",
  "glands",
  "hormone therapy",
  "hormones",
  "insulin",
  "m shape",
  "metabolism",
  "neck",
  "pancreas",
  "pituitary gland",
  "reproduction",
  "rounded shape",
  "sexual health",
  "specialist",
  "stylized",
  "throat",
  "thyroid",
  "alternative energy",
  "blades",
  "clean energy",
  "generator",
  "green energy",
  "propeller",
  "renewable energy",
  "sustainable energy",
  "turbine",
  "wind energy",
  "wind power",
  "windmill",
  "eco mode",
  "energy program",
  "lower consumption",
  "reduce energy",
  "save energy",
  "warranty",
  "used",
  "energy conservation",
  "energy consumption",
  "energy performance",
  "energy savings",
  "optimize energy",
  "fixing",
  "hardhat",
  "helmet",
  "labor",
  "occupation",
  "profession",
  "technician",
  "worker",
  "enhanced encryption",
  "reinforced",
  "stronger security",
  "vault",
  "chin",
  "letter f",
  "nose",
  "profile picture",
  "think",
  "wisdom",
  "consulting",
  "operations",
  "deactivate enterprise",
  "no business",
  "no company",
  "no enterprise",
  "no job",
  "no office",
  "no work",
  "equivalent",
  "identical",
  "matching",
  "mathmatical",
  "same",
  "adjust frequency",
  "audio control",
  "audio frequency",
  "audio levels",
  "music control",
  "music settings",
  "sound control",
  "sound frequency",
  "sound levels",
  "sound wave",
  "static",
  "volume control",
  "drawing tool",
  "eraser",
  "line weight",
  "strokes",
  "thickness",
  "whiteboard",
  "mistake",
  "rubber",
  "thick",
  "big",
  "brush size",
  "design tool",
  "size 5",
  "fail",
  "incorrect",
  "oops",
  "uh oh",
  "notice",
  "zig-zag",
  "electric stairs",
  "escalator",
  "mall",
  "moving stairs",
  "moving walkway",
  "staircase",
  "stairs",
  "beware",
  "holding hands",
  "eu",
  "euro",
  "europe",
  "european union",
  "euros",
  "open c",
  "€",
  "telematics",
  "vehicle connectivity",
  "eclipse",
  "greyscale",
  "grill",
  "shadow",
  "tonality",
  "transparency",
  "augment",
  "diminish",
  "ev charger",
  "ev station",
  "fuel",
  "refill",
  "invitation",
  "occasion",
  "special day",
  "booked",
  "busy day",
  "cancel event",
  "decline event",
  "event conflict",
  "occupied",
  "remove event",
  "scheduling conflict",
  "unavailable date",
  "appointments",
  "camerazilla",
  "entries",
  "event list",
  "list view",
  "reminders",
  "two squares",
  "calendar note",
  "date note",
  "event note",
  "schedule note",
  "monthly",
  "recurrence",
  "recurring appointment",
  "recurring event",
  "recurring task",
  "yearly",
  "assigned",
  "attendee",
  "event_seat",
  "venue",
  "attend",
  "calendar entry",
  "import event",
  "participate",
  "upcoming",
  "high priority",
  "severity",
  "athletics",
  "barbell",
  "bodybuilding",
  "dumbbell",
  "lifestyle",
  "lifting",
  "weightlifting",
  "weights",
  "exit app",
  "external application",
  "leave app",
  "open app",
  "open in new",
  "expand arrows",
  "dropdown icon",
  "expand collapse",
  "open all",
  "open icon",
  "reveal icon",
  "show icon",
  "unfold icon",
  "expand circle",
  "expand content",
  "expand down",
  "v shape",
  "arrow button",
  "circle icon",
  "expand button",
  "expand right",
  "navigation button",
  "right arrow button",
  "fullscreen icon",
  "maximize icon",
  "expansion panel",
  "analysis icon",
  "beaker",
  "beaker icon",
  "chemical icon",
  "chemistry icon",
  "conical flask",
  "conical flask icon",
  "erlenmeyer flask",
  "erlenmeyer flask icon",
  "experiment icon",
  "flask",
  "flask icon",
  "lab icon",
  "research icon",
  "science icon",
  "scientific",
  "scientific icon",
  "test icon",
  "explicit",
  "initial e",
  "compass icon",
  "explore icon",
  "explore nearby",
  "local search",
  "locartion",
  "nearby",
  "neighborhood",
  "poi",
  "point of interest",
  "adventure off",
  "compass off",
  "direction off",
  "discovery off",
  "expedition off",
  "exploration off",
  "explore disabled",
  "explore off",
  "guide off",
  "no explore",
  "roam off",
  "search off",
  "sightseeing off",
  "tour off",
  "track off",
  "trail off",
  "travel off",
  "trip off",
  "wander off",
  "fireworks",
  "pow",
  "radiate",
  "shockwave",
  "spark",
  "import/export",
  "iso",
  "darken",
  "exposure compensation",
  "exposure value",
  "minus one",
  "neg",
  "negative one",
  "underexpose",
  "-2",
  "level down",
  "minus two",
  "negative two",
  "add one",
  "exposure plus one",
  "increase by one",
  "increment one",
  "plus one",
  "+2",
  "brighter",
  "ev+2",
  "increase exposure",
  "lighten",
  "plus two",
  "two levels",
  "two steps",
  "functionality",
  "jigsaw",
  "plugin add",
  "addon off",
  "deactivate addon",
  "deactivate extension",
  "deactivate plugin",
  "disable addon",
  "disable extension",
  "disable plugin",
  "extension off",
  "no addon",
  "no extension",
  "no plugin",
  "plugin off",
  "puzzle piece",
  "remove addon",
  "remove extension",
  "remove plugin",
  "uninstall",
  "uninstall addon",
  "uninstall extension",
  "uninstall plugin",
  "eye scan",
  "eye tracking",
  "gaze",
  "motion sensor",
  "eye protection",
  "eyeglasses",
  "eyesight",
  "eyewear",
  "geek",
  "glasses",
  "lenses",
  "nerd",
  "optical",
  "professor",
  "reading glasses",
  "specs",
  "spectacles",
  "sunglasses",
  "teacher",
  "optic",
  "view mode",
  "face unlock",
  "facial scan",
  "simple face",
  "face 2",
  "bangs",
  "expressionless",
  "fringe",
  "generic",
  "bun",
  "demographic",
  "double bun",
  "female user",
  "girl avatar",
  "woman profile",
  "bald",
  "balding",
  "forehead",
  "mesh",
  "scalp",
  "blank face",
  "default profile",
  "emotionless",
  "face 6",
  "generic person",
  "avatar down",
  "face down",
  "face forward",
  "gestures",
  "head down",
  "looking down",
  "person down",
  "profile down",
  "user down",
  "acknowledgment",
  "body language",
  "nod",
  "nonverbal",
  "rotate head",
  "understood",
  "authentic look",
  "beauty filter off",
  "beauty mode off",
  "cosmetic edits off",
  "disable filter",
  "disable retouching",
  "editing off",
  "edits off",
  "enhancements off",
  "face adjustments off",
  "face retouch disabled",
  "face retouching off",
  "faces",
  "filter off",
  "filters disabled",
  "image editing off",
  "natural face",
  "no cosmetic filters",
  "no edits",
  "no face retouch",
  "no filter",
  "no retouching",
  "original face",
  "photo editing off",
  "portrait retouching off",
  "raw image",
  "retouch",
  "retouch off",
  "retouching",
  "selfie retouching off",
  "unedited photo",
  "unretouched",
  "untouched",
  "follower",
  "disagree",
  "oscillate",
  "refuse",
  "side to side",
  "wobble",
  "account picture",
  "face up",
  "upload avatar",
  "upload face",
  "upload photo",
  "upload profile",
  "user upload",
  "fact",
  "fact check",
  "fact checking",
  "fact-check",
  "true",
  "assembly",
  "fabrication",
  "factory building",
  "heavy industry",
  "industrial building",
  "industrial plant",
  "industrial production",
  "light industry",
  "manufacturing facility",
  "manufacturing plant",
  "production facility",
  "production plant",
  "smokestack",
  "awkward",
  "clumsiness",
  "descent",
  "downwards",
  "fall",
  "falling",
  "falling down",
  "falling over",
  "gravity",
  "imbalance",
  "lose balance",
  "person falling",
  "slip",
  "stumble",
  "tumbling",
  "familiar",
  "guided frame",
  "ancestors",
  "ancestry",
  "family structure",
  "heritage",
  "lineage",
  "pedigree",
  "root",
  "tree structure",
  "family home",
  "family house",
  "family values",
  "heart home",
  "home heart",
  "home love",
  "home sweet home",
  "house heart",
  "love house",
  "loved ones",
  "my home",
  "safe place",
  "sweet home",
  "kite",
  "kiting",
  "string",
  "tail",
  "all gender",
  "family symbol",
  "gender neutral",
  "men",
  "parent and child",
  "stick figures",
  "unisex",
  "clan",
  "concentrate",
  "fan focus",
  "specific",
  "targeted",
  "three arrows",
  "triple arrow",
  "air distribution",
  "bounce",
  "deflect",
  "disperse",
  "down arrows",
  "36",
  "digital clock",
  "digital display",
  "digital time",
  "farsight",
  "thirty-six",
  "double triangle",
  "fastforward",
  "jump",
  "skip forward",
  "two triangles",
  "audio player",
  "fast rewind",
  "music player",
  "skip back",
  "burger",
  "cheeseburger",
  "combo",
  "fast food meal",
  "fastfood",
  "quick service",
  "soda",
  "soft drink",
  "straw",
  "pipe",
  "running water",
  "spout",
  "washbasin",
  "add to favourites",
  "dating",
  "favourite",
  "heart outline",
  "remove from favorites",
  "remove from favourites",
  "unfavourite",
  "unlike",
  "valentine's day",
  "legacy",
  "outdated",
  "receive fax",
  "send fax",
  "characteristic",
  "examine",
  "highlighted",
  "bonus",
  "bow",
  "gift",
  "gifts",
  "giveaway",
  "seasonal",
  "surprise",
  "advertised",
  "featured video",
  "spotlight",
  "delivery failed",
  "failed",
  "sending failed",
  "undelivered",
  "biological sex",
  "female symbol",
  "feminine",
  "ladies' room",
  "sex",
  "venus",
  "venus symbol",
  "women's restroom",
  "body part",
  "bone health",
  "bone structure",
  "bones",
  "calcium",
  "dinosaur",
  "dog bone",
  "femur",
  "fossil",
  "fracture",
  "hip",
  "joint",
  "knee",
  "limb",
  "orthopedic",
  "osteology",
  "skeletal system",
  "skeleton",
  "thigh bone",
  "bone scan",
  "bone symbol",
  "femur_alt",
  "orthopedics",
  "skeletal",
  "thigh",
  "x-ray",
  "barrier",
  "boundaries",
  "boundary line",
  "fence",
  "grass",
  "limits",
  "paling",
  "picket fence",
  "suburban",
  "three peaks",
  "botany",
  "cracked",
  "fertile",
  "horticulture",
  "menstrual",
  "opening",
  "ovulation",
  "potential",
  "seed",
  "u shape",
  "booth",
  "circus",
  "marquee",
  "pavilion",
  "stall",
  "tradition",
  "fiber",
  "live tv",
  "personal video recorder",
  "pvr",
  "record show",
  "set top box",
  "stb",
  "timeshift",
  "audio record",
  "filled circle",
  "hollow circle",
  "radio button",
  "video record",
  "voice record",
  "latest",
  "wordmark",
  "pushpin",
  "tack",
  "thumbtack",
  "double circle",
  "open circle",
  "smart record",
  "smart recording",
  "copy document",
  "copy file",
  "copy page",
  "document copy",
  "document duplicate",
  "duplicate file",
  "file copy",
  "file duplicate",
  "page copy",
  "two pages",
  "cancel copy",
  "copy disabled",
  "disable copy",
  "document restriction",
  "file restriction",
  "no copy",
  "no duplicate",
  "prevent copy",
  "remove copy",
  "stop copy",
  "block download",
  "cancel download",
  "download off",
  "export off",
  "file download off",
  "get file off",
  "import off",
  "no download",
  "no file download",
  "no files",
  "prevent download",
  "receive file off",
  "restrict download",
  "save disabled",
  "stop download",
  "transfer disabled",
  "interchange",
  "key-value",
  "geo data",
  "location file",
  "map file",
  "atlas",
  "cartography",
  "geospatial",
  "choose file",
  "open file",
  "select file",
  "bitmap",
  "image file",
  "lossless",
  "png",
  "portable network graphics",
  "discovered",
  "existing",
  "file_present",
  "horseshoe",
  "located",
  "u",
  "download file",
  "file save",
  "floppy",
  "preserve",
  "save file",
  "file_save_off",
  "no save",
  "blocked import",
  "blocked upload",
  "cancel import",
  "cancel upload",
  "cloud upload disabled",
  "cloud upload off",
  "disable cloud upload",
  "disable import",
  "disable send",
  "disable transfer",
  "disable upload",
  "file upload disabled",
  "file upload off",
  "forbidden import",
  "forbidden upload",
  "import disabled",
  "no import",
  "no send",
  "no transfer",
  "no upload",
  "send disabled",
  "send off",
  "transfer off",
  "upload off",
  "filter_1",
  "number one",
  "sorting",
  "filter criteria",
  "filter settings",
  "filter_2",
  "layered filter",
  "multiple filters",
  "parameters",
  "refine options",
  "stacking",
  "two filters",
  "sift",
  "filter options",
  "four filters",
  "refine results",
  "filter 5",
  "number five",
  "filter 6",
  "number 6",
  "number eight",
  "9 and over",
  "9+",
  "adult content",
  "age rating",
  "child protection",
  "content filter",
  "family filter",
  "inappropriate content",
  "kids filter",
  "mature content",
  "nine and up",
  "nine plus",
  "over 9",
  "safe search",
  "data filter",
  "filter_alt",
  "filtering",
  "funnel shape",
  "inverted triangle",
  "results filter",
  "search filter",
  "strain",
  "disable funnel",
  "disable options",
  "disable refine",
  "disable sort",
  "filter disabled",
  "funnel disabled",
  "no funnel",
  "no options",
  "no refine",
  "no sort",
  "options disabled",
  "options off",
  "refine disabled",
  "refine off",
  "remove filter",
  "remove funnel",
  "remove options",
  "remove refine",
  "remove sort",
  "sort disabled",
  "sort off",
  "apply filter",
  "arrow right",
  "filter next",
  "filter right",
  "funnel right",
  "b&w",
  "black and white",
  "filter_b_and_w",
  "monochrome",
  "w",
  "cloud shape",
  "content filtering",
  "drama filter",
  "sky camera",
  "theatrical",
  "tragedy",
  "boarders",
  "filter frames",
  "filtering options",
  "media editing",
  "video filter",
  "hdr",
  "high dynamic range",
  "filter_list",
  "clear filter",
  "clear funnel",
  "filter delete",
  "filter remove",
  "funnel delete",
  "funnel remove",
  "hide filter",
  "hide funnel",
  "display all",
  "filter none",
  "no restrictions",
  "reset filter",
  "lux",
  "retrolux",
  "diorama",
  "diorama effect",
  "miniature",
  "miniature effect",
  "tilt",
  "tilt shift",
  "tilt shift effect",
  "tilt-shift",
  "decorative",
  "ornamentation",
  "petal",
  "sieve",
  "axis",
  "revenue",
  "stocks",
  "pill shape",
  "poker chip",
  "stake",
  "finance mode",
  "financial report",
  "explore page",
  "find in document",
  "find in page",
  "find text",
  "page search",
  "search document",
  "search text",
  "find and replace",
  "search and replace",
  "finger",
  "fingerprint",
  "loops",
  "ridges",
  "thumbprint",
  "touch id",
  "whorls",
  "biometric off",
  "biometrics",
  "biometrics disabled",
  "disable fingerprint",
  "fingerprint disabled",
  "fingerprint login",
  "fingerprint off",
  "fingerprint scan",
  "no fingerprint",
  "remove fingerprint",
  "touch id off",
  "building safety",
  "canister",
  "emergency equipment",
  "extinguisher",
  "fire control",
  "fire extinguisher",
  "fire safety",
  "firefighting",
  "hose",
  "nozzle",
  "office safety",
  "put out fire",
  "rescue",
  "suppressant",
  "tank",
  "workplace safety",
  "fire hydrant",
  "firefighter",
  "fireplug",
  "hydrant",
  "municipal",
  "blaze",
  "emergency service",
  "fire department",
  "fire truck",
  "fireman",
  "firetruck",
  "flames",
  "ladder",
  "ladder truck",
  "burning",
  "cozy",
  "ember",
  "fireplace",
  "hearth",
  "ignite",
  "pit",
  "wood burning",
  "angled line",
  "earliest",
  "form control",
  "go to beginning",
  "jump to start",
  "page 1",
  "page one",
  "very beginning",
  "expand to fit",
  "fit page",
  "fit to height",
  "fit to page",
  "full page",
  "horizontal fit",
  "page break",
  "scale to fit",
  "shrink to fit",
  "vertical fit",
  "zoom to fit",
  "fit height",
  "page height",
  "tall",
  "fit content",
  "fit page width",
  "page formatting",
  "resize page",
  "resize width",
  "scale to page",
  "scale to width",
  "zoom to page",
  "zoom to width",
  "expand to screen",
  "fit screen",
  "container fit",
  "content fit",
  "fit width",
  "frame fit",
  "image fit",
  "maximize width",
  "text fit",
  "window fit",
  "exercise equipment",
  "fitness center",
  "fitness equipment",
  "gym equipment",
  "flag outline",
  "outlined flag",
  "flag_2",
  "flag post",
  "flagpole",
  "objective",
  "flag in circle",
  "erratic",
  "flaky",
  "inconsistent",
  "intermittent",
  "irregular",
  "maybe",
  "patchy",
  "sporadic",
  "undependable",
  "unpredictable",
  "unreliable",
  "unstable",
  "dazzle",
  "flare",
  "glimmer",
  "glitter",
  "glowing",
  "radiating",
  "ray",
  "shimmer",
  "shining",
  "sunburst",
  "automatic flash",
  "flash auto mode",
  "flash photography",
  "energy off",
  "flash_off",
  "no bolt",
  "no electricity",
  "no flash",
  "no lightning",
  "no lightning bolt",
  "no thunderstorm",
  "photography settings",
  "flash on",
  "instantaneous",
  "flashlight",
  "flashlight off",
  "lamp",
  "no flashlight",
  "no light",
  "no torch",
  "switch off",
  "torch off",
  "activated",
  "flashlight on",
  "torch on",
  "flatware",
  "knife",
  "place setting",
  "restaurant menu",
  "table setting",
  "flex direction",
  "layouts",
  "3x3",
  "fixed size",
  "fixed width",
  "inflexible",
  "inflexible layout",
  "line break",
  "no overflow",
  "no wrap",
  "nowrap",
  "rigid",
  "text flow",
  "three boxes",
  "word wrap",
  "6x6",
  "flex wrap",
  "reflow",
  "text wrap",
  "wraparound",
  "airfare",
  "fuselage",
  "holidays",
  "jet",
  "overhead view",
  "downgrade",
  "flight class",
  "in-flight",
  "airplane arrival",
  "airplane landing",
  "airport icon",
  "approaching",
  "arrive",
  "arriving",
  "coming down",
  "departing",
  "flight arrival",
  "incoming flight",
  "landing",
  "plane landing",
  "runway",
  "touchdown",
  "airborne",
  "embark",
  "flight path",
  "takeoff",
  "flight booking",
  "hotel reservation",
  "hotels",
  "leisure travel",
  "travel and hotel",
  "trip planning",
  "vacation planning",
  "scan scanning",
  "transpose",
  "backside",
  "detached window",
  "float",
  "floating panel",
  "floating window",
  "popout",
  "separate window",
  "undock",
  "deluge",
  "flood",
  "flood zone",
  "flooded house",
  "flooding",
  "heavy rain",
  "inundation",
  "property damage",
  "sinking",
  "sinking house",
  "submerged",
  "torrential rain",
  "floors",
  "four levels",
  "four steps",
  "multi-level",
  "storey",
  "fixture",
  "floor ",
  "floor lamp",
  "standing lamp",
  "data flow",
  "flowsheet",
  "information flow",
  "procedure",
  "fluids",
  "karaoke",
  "voice input",
  "voice memo",
  "fluid balance",
  "fluid intake",
  "hydration",
  "intake",
  "intravenous",
  "iv",
  "medical chart",
  "therapy",
  "dose",
  "injection",
  "syringe",
  "vaccination",
  "vaccine",
  "flourescent",
  "fluorescent",
  "iridescent",
  "tungsten",
  "wb_iridescent",
  "abstract arrow",
  "application development",
  "cross-platform",
  "dart",
  "flutter",
  "google flutter",
  "software development kit",
  "stylized arrow",
  "ui toolkit",
  "beak",
  "cute",
  "owl",
  "penguin",
  "whimsical",
  "autobahn",
  "bypass",
  "expressway",
  "flyover",
  "freeway",
  "motorway",
  "overpass",
  "ramps",
  "road bridge",
  "thruway",
  "turnpike",
  "bad",
  "fmd",
  "location alert",
  "map warning",
  "clouds",
  "cloudy with fog",
  "evening fog",
  "foggy",
  "hazy",
  "low visibility",
  "morning fog",
  "partly cloudy",
  "folded hands",
  "mosque",
  "namaste",
  "peace",
  "please",
  "praying hands",
  "temple",
  "wish",
  "archive folder",
  "contents",
  "directory icon",
  "documents folder",
  "file folder",
  "folder icon",
  "check folder",
  "folder check",
  "folder complete",
  "folder confirmed",
  "folder verified",
  "code brackets",
  "code directory",
  "development folder",
  "folder symbol",
  "programming folder",
  "repository folder",
  "script folder",
  "scripts",
  "source folder",
  "archive management",
  "copy folder",
  "duplicate folder",
  "folder copy",
  "multiple folders",
  "two folders",
  "data folder",
  "folder connection",
  "folder data",
  "folder structure",
  "linked folder",
  "organize data",
  "shared folder",
  "delete folder",
  "delete icon",
  "folder delete",
  "folder removal",
  "remove folder",
  "trash folder",
  "trash icon",
  "directory access",
  "directory view",
  "file access",
  "file view",
  "folder access",
  "folder view",
  "peek",
  "preview",
  "reveal hidden files",
  "show hidden files",
  "details view",
  "directory information",
  "file help",
  "file info",
  "file properties",
  "folder details",
  "folder help",
  "folder properties",
  "get info",
  "lowercase i",
  "metadata",
  "question mark symbol",
  "file permission",
  "folder restriction",
  "limited access",
  "permissions",
  "restricted folder",
  "directory management",
  "directory options",
  "directory settings",
  "folder options",
  "folder settings",
  "archives",
  "copying",
  "directories",
  "duplicating",
  "block folder",
  "cancel folder",
  "disable folder",
  "folder disabled",
  "folder inactive",
  "folder off",
  "folder unavailable",
  "hide folder",
  "no folder",
  "file browser",
  "file explorer",
  "folder open",
  "open folder",
  "contribute folder",
  "folder share",
  "folder sharing",
  "folder user",
  "shared",
  "shared directory",
  "user folder",
  "marked",
  "oversee",
  "supervise",
  "bundled",
  "compressed",
  "compressed folder",
  "decompress",
  "folder zip",
  "zipped",
  "zipped folder",
  "zipper",
  "follow the signs",
  "obey",
  "signage",
  "signs",
  "the",
  "add font",
  "character set",
  "download font",
  "font family",
  "font icon",
  "font library",
  "font management",
  "font pack",
  "font style",
  "get font",
  "install font",
  "new font",
  "text style",
  "font download",
  "font off",
  "no fonts",
  "food bank",
  "food donation center",
  "food drive",
  "food pantry",
  "hunger relief",
  "relief",
  "social services",
  "ankle",
  "appendage",
  "chiropractic",
  "foot bones",
  "heel",
  "joints",
  "metatarsals",
  "phalanges",
  "podiatrist",
  "tarsals",
  "footprints",
  "cupped hands",
  "curated",
  "for you",
  "holding",
  "my feed",
  "personalized",
  "recommendation engine",
  "serving",
  "suggestions",
  "tailored",
  "abstract tree",
  "conifer",
  "evergreen",
  "fir",
  "forest",
  "grove",
  "jungle",
  "national park",
  "pine",
  "plantation",
  "plants",
  "spruce",
  "trees",
  "two trees",
  "woodland",
  "woods",
  "branch left",
  "diverge left",
  "fork left",
  "split left",
  "branch right",
  "decisions",
  "diverge right",
  "fork right",
  "paths",
  "split right",
  "two directions",
  "forklift",
  "handling",
  "heavy machinery",
  "lift truck",
  "pallet",
  "unloading",
  "horizontal center",
  "align text",
  "five lines",
  "format text",
  "justify text",
  "text format",
  "B",
  "boldface",
  "font weight",
  "rich text",
  "T",
  "cancel format",
  "character formatting",
  "clear format",
  "clear formatting",
  "delete format",
  "format clear",
  "indentation",
  "no format",
  "remove format",
  "reset format",
  "change color",
  "color adjustment",
  "paint bucket",
  "pouring",
  "styling",
  "cancel formatting",
  "clear color",
  "delete color",
  "no color",
  "no formatting",
  "remove color",
  "font color",
  "text color",
  "underlining",
  "h1",
  "heading",
  "information architecture",
  "text size",
  "title",
  "h2",
  "heading 2",
  "large text",
  "second level heading",
  "subheading",
  "h3",
  "heading 3",
  "third level heading",
  "fourth heading",
  "h4",
  "heading 4",
  "heading level 4",
  "fifth heading",
  "font size",
  "h5",
  "heading 5",
  "heading five",
  "html tag",
  "html5",
  "h6",
  "heading 6",
  "heading six",
  "markdown",
  "sixth heading",
  "small text",
  "arrange image",
  "image formatting",
  "insert image",
  "image right",
  "decrease indent",
  "decrease indentation",
  "formatting tools",
  "indent",
  "outdent",
  "reduce indent",
  "unindent",
  "code formatting",
  "increase indent",
  "indent right",
  "tab right",
  "text indent",
  "emphasize",
  "highlighter",
  "text highlight",
  "capital i",
  "adjust spacing",
  "character spacing",
  "kerning",
  "decrease spacing",
  "increase spacing",
  "letter spacing",
  "text manipulation",
  "sentence",
  "character width",
  "formatting options",
  "letter width",
  "text adjust",
  "text width",
  "letter manipulation",
  "text adjustment",
  "wider",
  "writing tools",
  "line height",
  "bullet points",
  "bulleted",
  "bulleted list",
  "ordering",
  "unordered list",
  "create list",
  "list add",
  "list append",
  "list insert",
  "new list",
  "numbered",
  "numbered list",
  "ordered list",
  "format rtl",
  "list rtl",
  "right-to-left",
  "overbar",
  "overline",
  "overscore",
  "text decoration",
  "text overlay",
  "appearance",
  "roller",
  "insert paragraph",
  "new paragraph",
  "paragraph symbol",
  "pilcrow",
  "blockquote",
  "double quote",
  "ninety-nine",
  "quotation",
  "delete quote",
  "disable quote",
  "format quote",
  "quotation marks",
  "remove location",
  "remove quote",
  "speech marks",
  "turn off quote",
  "uncite",
  "unquote",
  "text frame",
  "change text size",
  "format strikethrough",
  "letter h",
  "text clip formatting",
  "textdirection",
  "truncate",
  "text overflow",
  "wrap text",
  "carriage return",
  "format text wrap",
  "newline",
  "language settings",
  "left to right",
  "ltr",
  "reading direction",
  "text direction",
  "writing direction",
  "arabic",
  "bidi",
  "bidirectional",
  "flip text",
  "hebrew",
  "i18n",
  "l10n",
  "mirror text",
  "persian",
  "reverse text",
  "switch direction",
  "urdu",
  "portrait orientation",
  "rotate text",
  "vertical text",
  "format underlined",
  "letter u",
  "text formatting toolbar",
  "underbar",
  "underlined",
  "u letter",
  "underline squiggle",
  "underscored",
  "wavy line",
  "wavy underline",
  "add entry",
  "add form",
  "add list",
  "create form",
  "forms",
  "new entry",
  "crenellation",
  "military",
  "parapet",
  "answers",
  "discuss",
  "online forum",
  "overlapping speech bubbles",
  "q&a",
  "question_answer",
  "questions",
  "two speech bubbles",
  "google plus",
  "googleplus",
  "open in new window",
  "repost",
  "reshare",
  "sent",
  "+10",
  "forward 10",
  "next 10",
  "skip 10",
  "step forward",
  "30 seconds forward",
  "30 seconds skip",
  "forward 30",
  "next 30",
  "skip 30",
  "advance 5",
  "forward 5",
  "jump 5",
  "next 5",
  "skip 5",
  "ff",
  "envelope",
  "move to",
  "paper plane",
  "send to",
  "basis",
  "beginnings",
  "foundation",
  "scaffold",
  "underpinning",
  "body spray",
  "cologne",
  "cosmetic",
  "freshness",
  "particles",
  "puff",
  "sprinkle",
  "spritz",
  "toiletry",
  "frame_inspect",
  "image recognition",
  "object detection",
  "audio recording",
  "framed",
  "speech recording",
  "voice recording",
  "exclude",
  "frame disabled",
  "hidden person",
  "hidden profile",
  "hidden user",
  "no frame",
  "no person",
  "person disabled",
  "person hidden",
  "person removed",
  "profile hidden",
  "profile removed",
  "user hidden",
  "user removed",
  "resync",
  "change source",
  "choose source",
  "external source",
  "frame source",
  "inward arrows",
  "select source",
  "cancellation",
  "free cancellation",
  "front hand",
  "haptic",
  "high five",
  "bulldozer",
  "dig",
  "digger",
  "earth mover",
  "earthmoving",
  "excavate",
  "excavation",
  "front loader",
  "groundworks",
  "heavy equipment",
  "landscaping",
  "shovel",
  "breaking",
  "coverage",
  "full coverage",
  "propaganda",
  "ux element",
  "1920x1080",
  "fhd",
  "full hd",
  "high-resolution",
  "expand view",
  "l shapes",
  "maximize view",
  "outward arrows",
  "four l's",
  "opposite l's",
  "small screen",
  "undo fullscreen",
  "unmaximize",
  "windowed",
  "nested rectangles",
  "algebra",
  "calculus",
  "compute",
  "f(x)",
  "function of x",
  "functions",
  "fx",
  "letter x",
  "notation",
  "plotting",
  "greek letter",
  "inclined plane",
  "mountain transport",
  "uphill",
  "cellular plan",
  "g",
  "internet plan",
  "letter g",
  "mobile plan",
  "square with cutout",
  "mobile phone",
  "foreign character",
  "google translate",
  "interpret",
  "overlapping squares",
  "phrasebook",
  "translator",
  "d-pad",
  "directional pad",
  "game controller",
  "game start",
  "play button",
  "playstation",
  "headlights",
  "gable",
  "garage door",
  "garden cart",
  "haul",
  "single wheel",
  "wheelbarrow",
  "butane",
  "natural gas",
  "propane",
  "abdomen",
  "belly",
  "bowels",
  "digest",
  "digestion",
  "digestive",
  "digestive health",
  "digestive system",
  "esophageal",
  "gastric",
  "gastro",
  "gastroenterology",
  "gastrointestinal",
  "gi",
  "gi tract",
  "gut",
  "gut health",
  "guts",
  "internal organs",
  "intestine",
  "intestines",
  "organ",
  "stomach",
  "tract",
  "archway",
  "members only",
  "attorney",
  "auction",
  "bidding",
  "constitution",
  "gavel",
  "judge",
  "lawsuit",
  "lawyer",
  "litigation",
  "mallet",
  "politics",
  "trial",
  "verdict",
  "consumer electronics",
  "digital device",
  "electronic device",
  "general",
  "general device",
  "bioengineering",
  "bioinformatics",
  "biological",
  "double helix",
  "evolution",
  "gene",
  "genetic code",
  "genetic engineering",
  "genome",
  "helix",
  "heredity",
  "inheritance",
  "nucleotide",
  "organism",
  "strand",
  "genres",
  "melody",
  "music genres",
  "play all",
  "play music",
  "songs",
  "start music",
  "air gesture",
  "thread",
  "index finger",
  "touchscreen",
  "animated image",
  "graphic interchange format",
  "meme",
  "video clip",
  "animated loop",
  "gif file",
  "gif image",
  "gif_2",
  "graphics interchange format",
  "internet meme",
  "reaction image",
  "animated icon",
  "gif box",
  "gif icon",
  "dress",
  "skirt",
  "womens",
  "farmhouse",
  "gite",
  "holiday home",
  "hostel",
  "short-term rental",
  "vacation rental",
  "alcohol",
  "barware",
  "drinking",
  "drinkware",
  "glassware",
  "liquor",
  "pub",
  "shot glass",
  "single line",
  "tableware",
  "tumbler",
  "waterglass",
  "whiskey",
  "trinity",
  "apac",
  "asia-pacific",
  "continent",
  "eastern",
  "eastern hemisphere",
  "eastern world",
  "far east",
  "global business",
  "global network",
  "globe icon",
  "hemisphere",
  "southeast",
  "territory",
  "digital learning",
  "global education",
  "global knowledge",
  "global learning",
  "global resources",
  "globe book",
  "international education",
  "international library",
  "online learning",
  "online resources",
  "study abroad",
  "world book",
  "world library",
  "globe pin",
  "world location",
  "britain",
  "british",
  "blood glucose",
  "blood sugar",
  "diabetes",
  "finger prick",
  "glucose",
  "glucose check",
  "glucose meter",
  "glucose test",
  "foreign",
  "glyphs",
  "latin",
  "go to line",
  "goto",
  "line jump",
  "line number",
  "specific line",
  "ball",
  "club",
  "flag in hole",
  "golf",
  "golf ball",
  "golf course",
  "golf flag",
  "golfer",
  "golfing",
  "putt",
  "putting green",
  "aerial lift",
  "cable transportation",
  "cableway",
  "gondola lift",
  "mountain transportation",
  "snowboard",
  "snowboarding",
  "audio output",
  "connected home",
  "device pairing",
  "google devices",
  "google home",
  "home entertainment",
  "screen cast",
  "smart display",
  "av remote",
  "channel changer",
  "clicker",
  "device control",
  "google tv remote",
  "input device",
  "media remote",
  "nest remote",
  "remote control",
  "six dots",
  "smart remote",
  "streaming remote",
  "television remote",
  "tv remote",
  "access point",
  "gale",
  "google wifi",
  "horizontal bars",
  "modem",
  "nest wifi",
  "network device",
  "rectangular",
  "compromised",
  "gpp",
  "sim",
  "unsafe",
  "data breach",
  "potential threat",
  "questionable",
  "security alert",
  "uncertain",
  "unsure",
  "checkerboard",
  "color blend",
  "color fade",
  "color gradient",
  "color transition",
  "dithering",
  "gradual change",
  "image edit",
  "photo edit",
  "smooth transition",
  "spectrum",
  "'favorite'_new'.  ' Remove this icon & keep 'star'.",
  "'star_boarder'",
  "'star_border_purple500'",
  "'star_outline'",
  "'star_purple500'",
  "'star_rate'",
  "Same as 'star'",
  "assess",
  "grade",
  "scoring",
  "cereal",
  "couscous",
  "particle",
  "quinoa",
  "rice",
  "rough",
  "scatter",
  "seeds",
  "links",
  "connected circles",
  "top down",
  "tree diagram",
  "network graph",
  "graph_6",
  "plot",
  "relationships",
  "scheme",
  "audio adjustment",
  "graphic equalizer",
  "sound adjustment",
  "fodder",
  "foliage",
  "three leaves",
  "turf",
  "vegetation",
  "hashtag",
  "number sign",
  "tic-tac-toe",
  "disable blocks",
  "disable grid",
  "disable layout",
  "disable matrix",
  "grid off",
  "grid view off",
  "hashtag off",
  "hide blocks",
  "hide grid",
  "hide matrix",
  "layout off",
  "matrix off",
  "no blocks",
  "no grid",
  "no matrix",
  "remove blocks",
  "remove grid",
  "remove matrix",
  "grate",
  "lattice",
  "weave",
  "aesthetics",
  "divine proportion",
  "golden",
  "golden ratio",
  "golden section",
  "goldenratio",
  "grid system",
  "modular",
  "phi",
  "template",
  "cropping",
  "grid guides",
  "grids",
  "guides",
  "resizing",
  "rule of thirds",
  "scaling",
  "snapping",
  "grid layout disable",
  "grid layout off",
  "grid view disable",
  "grid on",
  "thumbnails",
  "toggle view",
  "waffle",
  "application square",
  "food delivery",
  "fruit",
  "groceries",
  "grocery delivery",
  "ingredients",
  "milk",
  "online grocery",
  "orange",
  "shopping cart",
  "supermarket",
  "multiple users",
  "personnel",
  "add friend",
  "add member",
  "add person",
  "add to group",
  "create group",
  "friend",
  "join group",
  "new group",
  "block group",
  "block team",
  "cancel group",
  "cancel team",
  "deactivate group",
  "deactivate team",
  "delete group",
  "delete team",
  "disable group",
  "disable team",
  "exclude group",
  "exclude team",
  "group disabled",
  "group hidden",
  "group off",
  "group remove",
  "hide group",
  "hide team",
  "no group",
  "no team",
  "remove group",
  "remove team",
  "team disabled",
  "team hidden",
  "team off",
  "team remove",
  "turn off group",
  "turn off team",
  "ungroup",
  "delete from group",
  "exit group",
  "leave group",
  "remove from group",
  "unfriend",
  "unsubscribe",
  "find group",
  "find team",
  "find users",
  "group search",
  "look up",
  "people search",
  "recruitment",
  "search people",
  "search team",
  "search users",
  "team search",
  "alliance",
  "collaboration circle",
  "group circle",
  "group work",
  "team circle",
  "three users",
  "grouped",
  "forum discussion",
  "group chat",
  "online group",
  "avatars",
  "busts",
  "heads",
  "different",
  "group of three",
  "custodian",
  "supervised",
  "supervisor",
  "birth control",
  "cervix",
  "endometriosis",
  "fallopian",
  "fallopian tubes",
  "female reproductive system",
  "fertility",
  "fibroids",
  "gynecology",
  "gyno",
  "hormone",
  "menstrual cycle",
  "obgyn",
  "obstetrics",
  "ovaries",
  "ovary",
  "pcos",
  "pelvic pain",
  "reproductive",
  "reproductive health",
  "uterus",
  "vagina",
  "women's health",
  "h symbol",
  "hsdpa",
  "hspa",
  "h+",
  "high-speed data",
  "3.5g",
  "3g plus",
  "enhanced 3g",
  "fast connection",
  "h plus",
  "phone network",
  "signal icon",
  "curb",
  "get a ride",
  "hail",
  "hail a cab",
  "hail a taxi",
  "hailing",
  "hand up",
  "street hail",
  "corridor",
  "hallway",
  "long",
  "passageway",
  "walls",
  "arthritis",
  "hand_bones",
  "radiology",
  "five fingers",
  "flick",
  "swipe down",
  "swipe left",
  "block gesture",
  "block hand",
  "cancel gesture",
  "cancel hand",
  "crossed hand",
  "deactivate gesture",
  "deactivate hand",
  "disable gesture",
  "disable hand",
  "gesture blocked",
  "gesture cancel",
  "gesture deactivate",
  "gesture disabled",
  "gesture off",
  "gesture reject",
  "hand blocked",
  "hand cancel",
  "hand deactivate",
  "hand disabled",
  "hand gesture off",
  "hand reject",
  "hand with line",
  "no gesture",
  "no hand",
  "reject gesture",
  "reject hand",
  "slashed hand",
  "stop gesture",
  "stop hand",
  "flight stick",
  "game console",
  "gaming device",
  "handheld game",
  "handheld gaming device",
  "handheld_controller",
  "joystick",
  "play game",
  "portable console",
  "videogame",
  "commitment",
  "cooperate",
  "cooperation",
  "deal making",
  "friendship",
  "handshake",
  "partnership agreement",
  "crossed",
  "do it yourself",
  "screw",
  "screwdriver",
  "woodwork",
  "google hangout",
  "hangout",
  "video meeting",
  "virtual call",
  "camera disabled",
  "camera off",
  "disable video",
  "end video",
  "mute video",
  "no camera",
  "no video",
  "no webcam",
  "screen recording off",
  "screen share off",
  "stop video",
  "video call off",
  "video chat off",
  "video conference off",
  "video disabled",
  "video off",
  "video recording off",
  "webcam disabled",
  "webcam off",
  "hard disk",
  "hard drive",
  "hdd",
  "indicator light",
  "hand tool",
  "nail",
  "tinker",
  "toolbox",
  "720p",
  "high res",
  "high-definition",
  "auto hdr",
  "dynamic range",
  "hdr auto",
  "hdr mode",
  "imaging",
  "auto selection",
  "hdr selection",
  "hdr+",
  "rich colors",
  "vivid",
  "dynamic range enhancement",
  "visual",
  "disable hdr",
  "hdr off",
  "image settings",
  "no hdr",
  "hdr deactivated",
  "hdr disabled",
  "hdr plus",
  "toggle hdr",
  "dynamic range imaging",
  "enhanced video",
  "high dynamic range plus",
  "improved video",
  "visual enhancement",
  "hdr plus off",
  "no hdr plus",
  "post-processing",
  "tone mapping",
  "augmented",
  "daydream",
  "experience",
  "extended reality",
  "goggles",
  "head mounted display",
  "hmd",
  "metaverse",
  "mixed reality",
  "simulation",
  "straps",
  "visor",
  "xr",
  "audio jack",
  "bluetooth headphones",
  "headphone battery life",
  "headphones battery",
  "headset battery",
  "headset battery life",
  "music device",
  "headphone symbol",
  "headset mic",
  "headset symbol",
  "microphone symbol",
  "over-the-ear headphones",
  "tech support",
  "audio disabled",
  "audio off",
  "cancel audio",
  "cancel sound",
  "disable audio",
  "disable headphones",
  "disable headset",
  "disable sound",
  "headphones disabled",
  "headphones off",
  "headset disabled",
  "headset off",
  "no headphones",
  "no headset",
  "silenced",
  "sound disabled",
  "adhesive bandage",
  "band-aid",
  "bandage",
  "bandaid",
  "cure",
  "healing",
  "mend",
  "plaster",
  "remedy",
  "wound",
  "beauty products",
  "comb",
  "getting ready",
  "grooming",
  "hair care",
  "hair styling",
  "hairbrush",
  "morning routine",
  "polish",
  "self",
  "toiletries",
  "cross icon",
  "health and safety",
  "health insurance",
  "health protection",
  "health security",
  "medical safety",
  "medical security",
  "medical shield",
  "safety protection",
  "shield icon",
  "blood oxygen saturation",
  "body metrics",
  "breathing rate",
  "health information",
  "health metrics",
  "heart rate variability",
  "medical cross",
  "medical data",
  "medical information",
  "medical symbol",
  "resting heart rate",
  "skin temperature",
  "heap",
  "java",
  "allocation",
  "profiling",
  "division",
  "parts",
  "whole",
  "audio waves",
  "deaf",
  "hard of hearing",
  "hearing_aid",
  "hearing aid",
  "hearing impaired",
  "hearing loss",
  "no hearing",
  "disabled hearing aid",
  "hearing aid off",
  "hearing device",
  "left ear",
  "assistive device",
  "sound amplifier",
  "accessibility icon",
  "crossed ear",
  "deafness",
  "ear icon",
  "ear with slash",
  "hearing disability",
  "impaired hearing",
  "listen off",
  "broken heart",
  "core",
  "crack",
  "dislike",
  "electric heart",
  "heartbreak",
  "heartbreak icon",
  "hurt",
  "nucleus",
  "pain",
  "sadness",
  "unfollow",
  "deduct",
  "delete favorite",
  "heart break",
  "heart broken",
  "heart removal",
  "heart with minus",
  "less love",
  "remove favorite",
  "removeFromFavorites",
  "unlike post",
  "unlove",
  "add favorite",
  "add heart",
  "add to wishlist",
  "create favorite",
  "heart collection",
  "heart plus",
  "heart symbol",
  "love symbol",
  "new love",
  "plus heart",
  "save heart",
  "rising",
  "furnance",
  "heat pump",
  "pump",
  "spokes",
  "pipes",
  "increase height",
  "shorter",
  "taller",
  "aerial",
  "airlift",
  "chopper",
  "copter",
  "helicopter",
  "rotor",
  "rotorcraft",
  "whirlybird",
  "find answer",
  "help center",
  "help outline",
  "how to",
  "question icon",
  "contact support",
  "find answers",
  "knowledge base",
  "online help",
  "question box",
  "clinic information",
  "health center",
  "home icon",
  "arteries",
  "blood analysis",
  "blood count",
  "blood sample",
  "blood vessels",
  "blood work",
  "capillaries",
  "cell biology",
  "circulatory system",
  "hematology",
  "platelets",
  "red blood cells",
  "vein",
  "veins",
  "white blood cells",
  "h.265",
  "hevc",
  "high efficiency video coding",
  "video file",
  "video standard",
  "6 sided",
  "honeycomb",
  "nut",
  "six sided",
  "disappear",
  "obscure",
  "pointing arrows",
  "vanish",
  "block image",
  "cancel image",
  "content visibility",
  "delete image",
  "disable image",
  "hide image",
  "no image",
  "no photo",
  "no picture",
  "remove image",
  "censored",
  "hide source",
  "obfuscate",
  "redact",
  "dense",
  "dots per inch",
  "dpi",
  "high density",
  "pixel density",
  "pixels per inch",
  "ppi",
  "retina",
  "audio quality",
  "hq",
  "media quality",
  "hi-res",
  "high dpi",
  "hires",
  "upscale",
  "symbolic",
  "I",
  "chromeos",
  "highlight text",
  "i beam",
  "i-beam",
  "keyboard focus",
  "select text",
  "indicate",
  "mouse hover",
  "mouseover",
  "insert text",
  "text cursor",
  "text selection",
  "text tool",
  "type tool",
  "writing text",
  "size 1",
  "medium size",
  "size 2",
  "size two",
  "text marker",
  "size 3",
  "four sides",
  "quadrilateral",
  "backpacking",
  "climbing",
  "duffle",
  "hiker",
  "rollback",
  "turn back",
  "clock face",
  "viewed",
  "college",
  "edu",
  "feather",
  "history_edu",
  "quill",
  "no history",
  "activity history",
  "history disabled",
  "history off",
  "history toggle",
  "notches",
  "tick marks",
  "time tracking",
  "bee nest",
  "beehive",
  "bees",
  "colony",
  "hexagons",
  "hive",
  "honeycomb structure",
  "insects",
  "adaptive bitrate streaming",
  "adaptive streaming",
  "cdn",
  "content delivery",
  "hls",
  "http",
  "http live streaming",
  "internet protocol suite",
  "m3u8",
  "on-demand",
  "real-time",
  "vod",
  "hls deactivated",
  "hls disabled",
  "hls off",
  "live stream off",
  "live streaming",
  "live streaming off",
  "no hls",
  "no live stream",
  "no live streaming",
  "no streaming",
  "stop streaming",
  "buildings",
  "homes",
  "houses",
  "application--house",
  "filled home",
  "go home",
  "home screen",
  "home symbol",
  "solid home",
  "home and garden",
  "condo",
  "assisted living",
  "doctor house call",
  "elder care",
  "home health aide",
  "home healthcare",
  "home medical equipment",
  "home medical services",
  "home nursing",
  "home visit",
  "house with cross",
  "in-home care",
  "medical house call",
  "nurse house call",
  "private nursing",
  "remote patient monitoring",
  "senior care",
  "visiting nurse",
  "furniture assembly",
  "home repair",
  "slotted",
  "slotted screw",
  "home control",
  "smart light",
  "smart temperature",
  "abode",
  "back to home",
  "max",
  "return home",
  "start page",
  "things",
  "primary navigation",
  "Internet",
  "main menu",
  "site navigation",
  "default location",
  "find home",
  "home address",
  "home base",
  "home location",
  "home pin",
  "house location",
  "property location",
  "residence location",
  "starting point",
  "contractor",
  "home services",
  "kit",
  "repair service",
  "repairing",
  "toolkit",
  "bluetooth speaker",
  "home audio",
  "speaker system",
  "wireless speaker",
  "home folder",
  "my documents",
  "my files",
  "personal files",
  "user data",
  "building icon",
  "combined building",
  "hybrid work",
  "office address",
  "overlapping icons",
  "remote work",
  "telecommute",
  "work address",
  "evenly",
  "horizontal_distribute",
  "content divider",
  "design element",
  "gmail",
  "horizontal rule",
  "list divider",
  "menu separator",
  "novitas",
  "section break",
  "section divider",
  "subsection",
  "thematic break",
  "toolbar",
  "horizontal split",
  "parallel bars",
  "cloud server",
  "computers",
  "host",
  "network hosting",
  "racks",
  "servers",
  "web hosting",
  "jets",
  "steamy",
  "swim",
  "abstract bed",
  "check-out",
  "hotel symbol",
  "inn",
  "local hotel",
  "place to sleep",
  "simple bed",
  "broken star",
  "five star",
  "four star",
  "hotel class",
  "hotel rating",
  "one star",
  "stars",
  "three star",
  "two star",
  "hourglass icon",
  "loading icon",
  "patience",
  "progress icon",
  "sand clock",
  "sand timer",
  "sandglass",
  "time icon",
  "timer icon",
  "wait icon",
  "download time",
  "hourglass down",
  "time elapsed",
  "time remaining",
  "faster",
  "hourglass up",
  "speed up",
  "time increase",
  "anticipation",
  "hourglass_bottom",
  "limited time",
  "time passing",
  "delay off",
  "hourglass disabled",
  "hourglass not allowed",
  "hourglass off",
  "no delay",
  "no processing",
  "no time",
  "no waiting",
  "paused",
  "time not allowed",
  "timeout",
  "wait off",
  "duration icon",
  "empty hourglass",
  "hourglass empty",
  "hourglass outline",
  "deferred",
  "delay timer",
  "hourglass pause",
  "hourglass timer",
  "on hold",
  "pause process",
  "paused timer",
  "process pause",
  "suspension",
  "task pause",
  "workflow pause",
  "hourglass top half",
  "hourglass_top",
  "top half hourglass",
  "⏳",
  "simple house",
  "facade",
  "homeowner",
  "property management",
  "siding",
  "domestic security",
  "family safety",
  "home protection",
  "home safe",
  "house protection",
  "property security",
  "protected home",
  "protected house",
  "residential security",
  "safe home",
  "secure house",
  "boat house",
  "floating accommodation",
  "floating home",
  "floating house",
  "house on water",
  "houseboat",
  "vacation home",
  "disinfecting",
  "household supplies",
  "plant care",
  "sprayer",
  "squirt",
  "supplies",
  "watering",
  "high occupancy vehicle",
  "hov",
  "hover",
  "account creation",
  "sign-up",
  "to reg",
  "user registration",
  "civic duty",
  "civic engagement",
  "democracy",
  "elections",
  "calm",
  "healthy heart",
  "heart icon",
  "low intensity",
  "resting",
  "rhr",
  "backend",
  "central",
  "distribute hub",
  "focal point",
  "network node",
  "topology",
  "arm bone",
  "chew",
  "dog",
  "forelimb",
  "humerus",
  "surgery",
  "upper arm",
  "vitamin d",
  "arm injury",
  "bone fracture",
  "broken bone",
  "heal",
  "sling",
  "trauma",
  "damp",
  "high humidity",
  "humid",
  "muggy",
  "raindrop",
  "tear",
  "wet",
  "humidity control",
  "indoor climate",
  "droplet outline",
  "dry air",
  "empty drop",
  "low humidity",
  "low moisture",
  "menstruation",
  "thirst",
  "waterless",
  "half empty",
  "humidity mid",
  "mid humidity",
  "sweat",
  "water level",
  "air moisture",
  "dampness",
  "drop shape",
  "humidity percentage",
  "building management",
  "defogger",
  "s shape",
  "figure skating",
  "footwear",
  "frozen",
  "glide",
  "hockey",
  "ice skate",
  "ice skating",
  "new year",
  "rink",
  "skate",
  "skates",
  "skating",
  "winter activity",
  "chocolate",
  "cone icon",
  "cream",
  "dairy",
  "frozen dessert",
  "frozen yogurt",
  "gelato",
  "ice cream",
  "ice cream cone",
  "icecream",
  "scoop icon",
  "soft serve",
  "sorbet",
  "strawberry",
  "summer icon",
  "sundae",
  "vanilla",
  "driver license",
  "driver's license",
  "id_card",
  "aware",
  "firewall",
  "iap",
  "identity aware proxy",
  "proxy",
  "zero trust",
  "identity management",
  "user management",
  "die",
  "i'm",
  "ifl",
  "lucky",
  "randomness",
  "table game",
  "triple circle",
  "triple dot",
  "content loading",
  "external content",
  "iframe",
  "inline",
  "inline frame",
  "subwindow",
  "web component",
  "no iframe",
  "third party",
  "original",
  "upload picture",
  "export image",
  "export photo",
  "export picture",
  "image upload",
  "move image",
  "move photo",
  "move picture",
  "photo upload",
  "picture upload",
  "send image",
  "send photo",
  "send picture",
  "share image",
  "share photo",
  "share picture",
  "transfer image",
  "transfer photo",
  "transfer picture",
  "image aspect ratio",
  "explore images",
  "find image",
  "find photo",
  "find photos",
  "find picture",
  "gallery search",
  "image discovery",
  "image explorer",
  "image finder",
  "image library search",
  "image search",
  "photo finder",
  "photo search",
  "picture finder",
  "picture search",
  "search image",
  "search photo",
  "search picture",
  "coat",
  "decorate",
  "decorating",
  "imagesearch",
  "paint roller",
  "assets",
  "image browser",
  "image collection",
  "image gallery",
  "image library",
  "image mode",
  "photo mode",
  "picture mode",
  "upload image",
  "view images",
  "antigen",
  "immune response",
  "infectious",
  "viruses",
  "add contacts",
  "copy contacts",
  "import contacts",
  "transfer contacts",
  "upload contacts",
  "device priority",
  "important devices",
  "manage devices",
  "my devices",
  "preferred device",
  "primary device",
  "select device",
  "top devices",
  "checked in",
  "home mode",
  "house mode",
  "in home",
  "stay at home",
  "stay home",
  "inactive order",
  "purchase order",
  "receipt",
  "receipts",
  "sales order",
  "work order",
  "rounded bottom",
  "recipient",
  "sender",
  "3/4 circle",
  "circle segment",
  "three quarter circle",
  "mixed",
  "no tick",
  "partial selection",
  "state",
  "ui widget",
  "undetermined",
  "ambiguity",
  "doubt",
  "unknown location",
  "letter i",
  "electromagnetic",
  "infrared",
  "ir",
  "night vision",
  "radiation",
  "wavelength",
  "art tool",
  "ink eraser",
  "slant",
  "block eraser",
  "disable eraser",
  "no eraser",
  "no ink",
  "restrict eraser",
  "sketching",
  "highlighting",
  "felt tip",
  "content selection",
  "dashed square",
  "dotted square",
  "ink selection",
  "inpatient",
  "ward",
  "log in",
  "input circle",
  "into",
  "rounded arrow",
  "add break",
  "insert page",
  "page divider",
  "text break",
  "letter t",
  "t",
  "text container",
  "text entry",
  "computer download",
  "desktop download",
  "desktop install",
  "download to desktop",
  "install on desktop",
  "monitor download",
  "pwa",
  "screen download",
  "audio mixer",
  "dj",
  "faders",
  "instant mix",
  "mixing",
  "multitrack",
  "remix",
  "soundboard",
  "stems",
  "studio",
  "switches",
  "engineering clipboard",
  "how-to",
  "digital world",
  "geometric shapes",
  "interactive space",
  "activities",
  "areas of interest",
  "choose interests",
  "favorite things",
  "fields of interest",
  "hobbies",
  "interest selection",
  "interests",
  "my interests",
  "passions",
  "pick interests",
  "select interests",
  "things i like",
  "topics of interest",
  "interpreter",
  "packages",
  "archive box",
  "fewer",
  "inventory management",
  "product inventory",
  "stock control",
  "storage container",
  "hue",
  "inverse",
  "inverted",
  "palette",
  "color inversion disabled",
  "disable invert",
  "high contrast off",
  "inverse colors off",
  "inverse off",
  "invert colors off",
  "invert off",
  "inverted colors disabled",
  "negative colors off",
  "negative off",
  "no invert",
  "opacity",
  "reverse colors off",
  "reverse off",
  "toggle off",
  "apple ecosystem",
  "apple inc",
  "iphone",
  "ipod",
  "lowercase",
  "mobile os",
  "o",
  "operating",
  "operating system icon",
  "s",
  "clothes iron",
  "crease",
  "flatiron",
  "iron",
  "iron icon",
  "ironing",
  "presser",
  "steam iron",
  "wrinkle",
  "wrinkles",
  "display mode",
  "google jamboard",
  "interactive display",
  "jamboard",
  "public access",
  "self-service",
  "coding language",
  "javascript icon",
  "js",
  "js icon",
  "scripting",
  "arcs",
  "combined shape",
  "common",
  "crossroads",
  "union",
  "docking",
  "join left",
  "join right",
  "northeast",
  "teleport",
  "warp",
  "boating",
  "canoe",
  "canoeing",
  "kayak",
  "kayaking",
  "paddle",
  "paddling",
  "rafting",
  "water sports",
  "appetizer",
  "barbecue",
  "bbq",
  "brochette",
  "cookout",
  "grilled",
  "kebab",
  "meat",
  "satay",
  "shish kebab",
  "skewer",
  "souvlaki",
  "two skewers",
  "vegetable",
  "location pin",
  "pin icon",
  "pin location",
  "pin outline",
  "pin point",
  "pin symbol",
  "push pin",
  "stick pin",
  "no pin",
  "no tack",
  "remove pin",
  "unfasten",
  "unpin",
  "unpin post",
  "unstick",
  "untack",
  "boiling",
  "electric kettle",
  "hot beverage",
  "kettle",
  "steamer",
  "stovetop kettle",
  "tea kettle",
  "teapot",
  "decryption",
  "disabled key",
  "key disabled",
  "key off",
  "credential",
  "key_vertical",
  "sign-in",
  "vertical key",
  "heatmap",
  "introspection",
  "key_visualizer",
  "visualizer",
  "keys",
  "spacebar",
  "alternative keyboard",
  "external keyboard",
  "keyboard_alt",
  "expand_more",
  "keyboard_arrow_down",
  "keyboard arrow",
  "keyboard arrow left",
  "left caret",
  "left chevron",
  "chevron right",
  "disclosure indicator",
  "keyboard navigation",
  "keyboard right",
  "scroll right",
  "slide right",
  "swipe right",
  "keyboard_arrow_up",
  "navigate back",
  "all caps",
  "capital letters",
  "caps lock",
  "capslock",
  "capitalization",
  "caps",
  "access key",
  "cloverleaf",
  "command key",
  "hotkey",
  "intertwined",
  "keyboard shortcut",
  "keystroke",
  "knot",
  "macos",
  "modifier key",
  "osx",
  "control key",
  "up key",
  "chevron down",
  "keyboard input",
  "page down",
  "chevron left",
  "double left arrow",
  "fast forward (reverse)",
  "jump back",
  "two chevrons",
  "arrow keys",
  "right key",
  "double up arrow",
  "page up",
  "up arrows",
  "add keyboard",
  "bluetooth keyboard",
  "connect keyboard",
  "external hardware",
  "pair keyboard",
  "send to keyboard",
  "wireless keyboard",
  "enter text",
  "full keyboard",
  "keyboard layout",
  "keyboard_full",
  "close keyboard",
  "dismiss keyboard",
  "form input",
  "hide keypad",
  "input method",
  "keyboard arrow down",
  "keyboard down",
  "keyboard hide",
  "mobile keyboard",
  "onscreen keyboard",
  "virtual keyboard",
  "keyboard keys",
  "disable keyboard",
  "enable keyboard",
  "input lock",
  "keyboard access",
  "keyboard blocked",
  "keyboard disabled",
  "keyboard lock",
  "keyboard security",
  "keypad lock",
  "lock keys",
  "locked keyboard",
  "secure keyboard",
  "typing lock",
  "block keyboard",
  "deactivate keyboard",
  "input block",
  "input disabled",
  "keyboard deactivated",
  "keyboard lock off",
  "keyboard off",
  "keyboard restriction",
  "keyboard unlock",
  "no keyboard",
  "no typing",
  "unlock keyboard",
  "input off",
  "keyboard inactive",
  "keys disabled",
  "keys off",
  "text entry off",
  "text input off",
  "typing disabled",
  "typing off",
  "chatting",
  "commenting",
  "digital keyboard",
  "soft keyboard",
  "alt key",
  "modifier",
  "option key",
  "language selection",
  "previous language",
  "angular arrow",
  "bent arrow",
  "arrow key",
  "keyboard tab",
  "next field",
  "next item",
  "tab key",
  "reverse tab",
  "child-friendly",
  "favourites",
  "kids' content",
  "king bed",
  "king-size",
  "cooler",
  "food preservation",
  "fridge",
  "meal preparation",
  "refrigerator",
  "shelves",
  "two door",
  "extreme sport",
  "extreme sports",
  "kite board",
  "kite surf",
  "kiteboarding",
  "kitesurf",
  "kitesurfing",
  "surf",
  "surfing",
  "water sport",
  "cylinders",
  "lab panel",
  "labs",
  "samples",
  "lab profile",
  "lab report",
  "lab results",
  "lab test",
  "patient profile",
  "biological research",
  "chemical analysis",
  "explore research",
  "lab research",
  "medical research",
  "scientific discovery",
  "test tube",
  "vial",
  "wing",
  "disable label",
  "disable tag",
  "hide label",
  "hide tag",
  "label off",
  "marker off",
  "markers",
  "markers off",
  "no label",
  "no tag",
  "suppress label",
  "suppress tag",
  "tag off",
  "tags",
  "tags off",
  "untagged",
  "research and development",
  "local area network",
  "mountain range",
  "peaks",
  "summit",
  "vista",
  "horizon",
  "landscape_2",
  "outdoor activity",
  "rolling hills",
  "scenic route",
  "valleys",
  "autorotate",
  "autorotate disabled",
  "autorotate off",
  "display disabled",
  "display off",
  "orientation disabled",
  "orientation off",
  "rotate disabled",
  "rotate off",
  "screen rotation disabled",
  "screen rotation off",
  "view off",
  "avalanche",
  "cliff collapse",
  "debris",
  "earth movement",
  "erosion",
  "falling debris",
  "falling rocks",
  "ground movement",
  "landfall",
  "landslide",
  "mudslide",
  "rockfall",
  "rockslide",
  "tumbling rocks",
  "unstable ground",
  "cantonese",
  "languages",
  "linguistics",
  "mandarin",
  "translations",
  "cangjie",
  "cangjie input method",
  "chinese input method",
  "dayi",
  "phonetic",
  "pinyin",
  "eastern languages",
  "language support",
  "east asian languages",
  "five strokes",
  "ime",
  "wubi",
  "country code",
  "european",
  "fr",
  "french",
  "language code",
  "language icon",
  "language option",
  "language select",
  "locale",
  "text language",
  "gb",
  "globalization",
  "intl",
  "language options",
  "multiple languages",
  "world language",
  "east asian",
  "hiragana",
  "japanese language",
  "kana",
  "katakana",
  "nihongo",
  "hangul",
  "korean",
  "korean language",
  "romanization",
  "조선말",
  "조선어",
  "한국",
  "한국어",
  "한글",
  "hanzi",
  "pronunciation",
  "tones",
  "choose language",
  "es",
  "latin america",
  "select language",
  "spain",
  "spanish",
  "america",
  "american",
  "en",
  "english",
  "united states",
  "us",
  "usa",
  "colemak",
  "essay",
  "dv",
  "dvorak",
  "dvorak keyboard",
  "keyboard settings",
  "language us",
  "language us dvorak",
  "us dvorak",
  "lap",
  "laps",
  "car tech",
  "chrome os",
  "chromebook",
  "mac chromebook",
  "mobile computing",
  "netbook",
  "portable computer",
  "trackpad",
  "ultrabook",
  "clamshell",
  "macbook",
  "microsoft",
  "area selection",
  "dotted circle",
  "free select",
  "freeform selection",
  "lasso",
  "object selection",
  "region selection",
  "select tool",
  "end page",
  "end slide",
  "final",
  "final page",
  "go to end",
  "greater than sign",
  "jump to end",
  "last slide",
  "pagination",
  "right chevron",
  "scroll to end",
  "two shapes",
  "vertical bar",
  "cleanliness",
  "clothing care",
  "fabric care",
  "laundromat",
  "laundry basket",
  "laundry day",
  "laundry room",
  "tshirt",
  "tumble dry",
  "combine layers",
  "delete layers",
  "flatten layers",
  "hide layers",
  "layer management",
  "layering",
  "layers off",
  "merge layers",
  "no layers",
  "remove layers",
  "reset layers",
  "unstack",
  "drain",
  "lda",
  "modeling",
  "parameter",
  "topics",
  "variables",
  "contest",
  "first place",
  "high score",
  "leaderboard",
  "podium",
  "scores",
  "second place",
  "third place",
  "winners",
  "diffusion",
  "emit",
  "leak_add",
  "quadrants",
  "synce",
  "fix_leak",
  "leak_remove",
  "leak_repair",
  "no_crack",
  "no_leak",
  "prevent_leak",
  "stop_leak",
  "waterproof",
  "watertight",
  "clicking",
  "computer interaction",
  "computer mouse",
  "gui",
  "left click",
  "mouse action",
  "mouse arrow",
  "hide panel",
  "left panel",
  "show panel",
  "toggle panel",
  "legend",
  "legend_toggle",
  "map key",
  "map legend",
  "stackdriver",
  "depth of field",
  "fuzzy",
  "lens blur",
  "character switch",
  "flips",
  "swaps",
  "append to queue",
  "stack of layers",
  "save to library",
  "textbooks",
  "albums",
  "audio collection",
  "audio library",
  "library_music",
  "music collection",
  "sound library",
  "sounds",
  "medal",
  "lift to talk",
  "ptt",
  "push to talk",
  "raise",
  "walkie talkie",
  "ceiling light",
  "dome light",
  "electric light",
  "hanging light",
  "house light",
  "lighting fixture",
  "pendant light",
  "pendent",
  "room light",
  "fixtures",
  "hanging lamp",
  "lamps",
  "table lamp",
  "darkness",
  "deactivated light",
  "disabled light",
  "light off",
  "lights out",
  "no illumination",
  "incandescent",
  "led",
  "light bulb",
  "invent",
  "lightbulb_2",
  "electric stand",
  "energy boost",
  "ev charging",
  "fast charging",
  "line_axis",
  "quarter circle",
  "top left corner",
  "trajectory",
  "arrowheads",
  "endcap",
  "endpoint",
  "line end",
  "termination",
  "arrow end",
  "end point",
  "line arrow",
  "triangle arrow",
  "notch",
  "line end circle",
  "conclude",
  "commence",
  "jump off",
  "line segment",
  "onset",
  "outset",
  "line start",
  "start point",
  "beginning of line",
  "start of line",
  "entry point",
  "prepend",
  "lines of text",
  "paragraphs",
  "text lines",
  "linear_scale",
  "attached",
  "broken chain",
  "broken link",
  "cancel link",
  "chain off",
  "delete link",
  "disable link",
  "disconnection",
  "lost connection",
  "remove chain",
  "remove link",
  "slashed",
  "unchain",
  "connected camera",
  "linked camera",
  "remote camera",
  "wireless camera",
  "digital markets act",
  "dma",
  "federation",
  "linked circles",
  "alcohol consumption",
  "bottle and glass",
  "celebration drink",
  "cocktail",
  "coupe",
  "martini",
  "nightlife",
  "spirits",
  "spirits bottle",
  "wine",
  "wineglass",
  "live chat",
  "live help",
  "need help",
  "antennas hardware",
  "channel",
  "video on demand",
  "indoors",
  "entertainment ticket",
  "local event",
  "local show",
  "nearby event",
  "star ticket",
  "dollar sign",
  "bar location",
  "find bar",
  "happy hour",
  "local bar",
  "nearby bar",
  "nightclub",
  "breakfast service",
  "cafe service",
  "coffee cup",
  "local cafe",
  "auto cleaning",
  "auto detailing",
  "automotive service",
  "car care",
  "car cleaning",
  "car wash",
  "car wash service",
  "local car wash",
  "nearby car wash",
  "vehicle cleaning",
  "water drops",
  "--",
  "24 hours",
  "24/7",
  "all day",
  "all night",
  "all night long",
  "always open",
  "anytime",
  "convenience",
  "convenience store",
  "hours",
  "local market",
  "local store",
  "open 24 hours",
  "open 24/7",
  "twenty four",
  "dine",
  "find restaurant",
  "local restaurant",
  "nearby restaurant",
  "restaurant locator",
  "beer",
  "drinkable",
  "local drink",
  "nearby drinks",
  "potable",
  "combustion",
  "hotness",
  "inferno",
  "local fire department",
  "popular",
  "trending topic",
  "trending up",
  "viral",
  "wildfire",
  "youtube trending",
  "bouquet",
  "florist",
  "flower shop",
  "local florist",
  "local shop",
  "plant shop",
  "diesel",
  "fuel station",
  "gas station",
  "gasoline",
  "oil",
  "petrol",
  "petrol station",
  "refuel",
  "service station",
  "infirmary",
  "medical center",
  "urgent care",
  "clothes washing",
  "local laundry",
  "spin cycle",
  "bookstore",
  "community learning",
  "public library",
  "consumerism",
  "department store",
  "handbag",
  "local shopping",
  "nearby shops",
  "plaza",
  "retail therapy",
  "shopping center",
  "auto park",
  "car park",
  "find parking",
  "local parking",
  "nearby parking",
  "on-street parking",
  "p",
  "parking area",
  "parking garage",
  "parking lot",
  "parking space",
  "street parking",
  "apothecary",
  "chemist",
  "drugstore",
  "mortar",
  "pestle",
  "cheese",
  "fast food",
  "italian food",
  "local pizza",
  "order food",
  "pepperoni",
  "pizza",
  "pizza slice",
  "toppings",
  "community policing",
  "crime prevention",
  "enforcement",
  "first responders",
  "law enforcement",
  "local police",
  "neighborhood watch",
  "officer",
  "precinct",
  "public safety",
  "sheriff",
  "local mail",
  "mail delivery",
  "mailbox",
  "post office",
  "postal service",
  "find a place",
  "local guide",
  "nearby photos",
  "courier",
  "delivery van",
  "local delivery",
  "local shipping",
  "lorry",
  "shipping truck",
  "shipping van",
  "lyft",
  "ride-sharing",
  "roof sign",
  "taxi sign",
  "uber",
  "yellow",
  "away",
  "gone",
  "leaving",
  "location away",
  "not home",
  "occupancy",
  "vacant",
  "find location",
  "location chip",
  "apartments",
  "civic",
  "downtown",
  "municipality",
  "offices",
  "hide location",
  "location services off",
  "resident",
  "crossed out location",
  "disabled location",
  "find location off",
  "gps slash",
  "gps unavailable",
  "location hidden",
  "location slash",
  "location unavailable",
  "map pin off",
  "marker slash",
  "no position",
  "pinpoint off",
  "pinpoint slash",
  "place off",
  "position disabled",
  "position off",
  "position unavailable",
  "tracking disabled",
  "tracking off",
  "fmd good",
  "location on",
  "meeting place",
  "acquiring location",
  "finding location",
  "location error",
  "location not found",
  "searching for gps",
  "signal lost",
  "lock screen timeout",
  "lock timer",
  "session timeout",
  "temporary access",
  "time limit",
  "time lock",
  "unlock time",
  "access granted",
  "lock_open",
  "no restriction",
  "open access",
  "open lock",
  "open padlock",
  "unlocked padlock",
  "lock open",
  "authorized",
  "no lock",
  "open right",
  "right open",
  "right unlock",
  "shackle",
  "u-shape",
  "unlock right",
  "lock person",
  "user lock",
  "change password",
  "forgot password",
  "lock_reset",
  "password reset",
  "dev",
  "dev.to",
  "door out",
  "end session",
  "escape",
  "session end",
  "sign off",
  "arches",
  "glance",
  "glimpse",
  "rainbow",
  "seen",
  "semi-circles",
  "triple",
  "quartet",
  "looks 6",
  "looks six",
  "number six",
  "numeral six",
  "rounded box",
  "six looks",
  "looks_two",
  "closer",
  "observation",
  "zoom tool",
  "dispersed",
  "low density",
  "small amount",
  "sparse",
  "spread out",
  "de-prioritize",
  "decrease priority",
  "deprioritize",
  "importance",
  "low priority",
  "reduce priority",
  "text transformation",
  "title case",
  "benefits",
  "data signal",
  "lte network",
  "mobile broadband",
  "burger icon",
  "eating icon",
  "lunchtime",
  "sandwich icon",
  "closed captions",
  "lyrics",
  "music lyrics",
  "sing",
  "singing",
  "song lyrics",
  "close-up",
  "macro",
  "macro photography",
  "close up",
  "close-up off",
  "closeup",
  "deactivate macro",
  "disable macro",
  "macro disabled",
  "macro_off",
  "no close-up",
  "no closeup",
  "no focus",
  "no macro",
  "no_macro",
  "smaller view",
  "docked",
  "enter fullscreen",
  "full screen mode",
  "mail outline",
  "closed lock",
  "email lock",
  "email privacy",
  "email security",
  "locked mail",
  "mail lock",
  "mail privacy",
  "mail security",
  "message privacy",
  "message security",
  "privacy lock",
  "private message",
  "secure mail",
  "secure message",
  "communication off",
  "email disabled",
  "inbox off",
  "mail disabled",
  "no email",
  "no mail",
  "no messages",
  "unsubscribed",
  "boy's restroom",
  "gentleman",
  "male symbol",
  "mars",
  "masculine",
  "men's restroom",
  "account icon",
  "gender icon",
  "human icon",
  "restroom sign",
  "simple figure",
  "man icon",
  "guy",
  "man 3",
  "individual icon",
  "member icon",
  "account management",
  "edit profile",
  "manage accounts",
  "person and cog",
  "person and gear",
  "list search",
  "manage search",
  "search options",
  "broken manga",
  "broken panel",
  "cracked screen",
  "damaged manga",
  "fragment",
  "graphic novel",
  "ripped page",
  "shattered",
  "torn page",
  "clockwork",
  "operate",
  "refinery",
  "brochure",
  "folded",
  "folded map",
  "leaflet",
  "pamphlet",
  "paper map",
  "three panels",
  "explore map",
  "find place",
  "location search",
  "map quest",
  "route finder",
  "search map",
  "ugc",
  "as",
  "mark as unread",
  "mark unread",
  "multiple emails",
  "reopen",
  "stacked mail",
  "two messages",
  "undo read",
  "mark read",
  "read message",
  "direct message",
  "dm",
  "letter m",
  "m",
  "markup language",
  "copy to clipboard",
  "markunread",
  "postbox",
  "raised flag",
  "blending",
  "compositing",
  "effects",
  "masked",
  "masked transitions",
  "masking",
  "morph",
  "morphing",
  "spheres",
  "transformation",
  "transitions",
  "add mask",
  "add transition",
  "create mask",
  "layer mask",
  "new transition",
  "contagious",
  "face covering",
  "face mask",
  "flu",
  "medical mask",
  "personal protective equipment",
  "ppe",
  "respirator",
  "surgical mask",
  "aa",
  "capital",
  "fontsize",
  "lower case",
  "upper case",
  "case insensitive",
  "case insensitive filter",
  "case insensitive search",
  "case sensitivity",
  "disable case sensitivity",
  "ignore case",
  "match case off",
  "no case",
  "no match case",
  "text matching",
  "toggle case sensitivity",
  "match_word",
  "proofread",
  "convergence",
  "matter",
  "title bar",
  "top bar",
  "upper bar",
  "dimensions",
  "extendable",
  "measuring_tape",
  "retractable",
  "rolled",
  "sewing",
  "tailoring",
  "tape",
  "media bluetooth",
  "media off",
  "music off",
  "no music",
  "car audio",
  "connected media",
  "media embed",
  "media layers",
  "media link",
  "media merge",
  "play video",
  "shared media",
  "video link",
  "video merge",
  "computer audio",
  "external audio",
  "media output",
  "mobile audio",
  "phone audio",
  "share audio",
  "aggregation",
  "channels",
  "combination",
  "confluence",
  "mediation",
  "medical history",
  "medical id",
  "medical information card",
  "ear loops",
  "respiratory protection",
  "health services",
  "healthcare provider",
  "medical assistance",
  "medical bag",
  "medical help",
  "medical kit",
  "medical supplies",
  "cap",
  "jar",
  "medicine bottle",
  "pill bottle",
  "pills",
  "cough syrup",
  "dosage",
  "liquid medication bottle",
  "liquid medicine",
  "medications",
  "syrup",
  "boardroom",
  "book_room",
  "conference_room",
  "huddle_room",
  "meeting_room",
  "meeting_space",
  "open_door",
  "reserve",
  "cpu",
  "electronic component",
  "integrated circuit",
  "memory module",
  "micro",
  "motherboard",
  "ram",
  "rom",
  "sd",
  "semiconductor",
  "connectors",
  "memory card",
  "memory stick",
  "abstract flower",
  "cycle tracker",
  "feminine health",
  "menstrual health",
  "period tracker",
  "womb",
  "application menu",
  "close menu",
  "drawer menu",
  "menu open",
  "code merge",
  "collaborative",
  "combine data",
  "combine files",
  "data merging",
  "fusion",
  "git merge",
  "junction",
  "synthesize",
  "two way",
  "amalgamation",
  "merge type",
  "M",
  "city icon",
  "city transit",
  "initial m",
  "m logo",
  "metro system",
  "rapid transit",
  "subway system",
  "transit system",
  "underground system",
  "digital lock",
  "electronic lock",
  "mfg",
  "numeric keypad",
  "passcode",
  "pin code",
  "pin pad",
  "smart lock",
  "yale",
  "keyboard voice",
  "mic none",
  "mic off",
  "microphone off",
  "speech recognition",
  "voice command",
  "voice search",
  "audio error",
  "audio problem",
  "input error",
  "mic alert",
  "microphone error",
  "microphone problem",
  "recording error",
  "sound error",
  "sound problem",
  "speech error",
  "voice error",
  "voice problem",
  "double mic",
  "dual mic",
  "duet",
  "two microphones",
  "external mic",
  "external microphone",
  "no recording",
  "wired",
  "amoeba",
  "biohazard",
  "contamination",
  "eukaryote",
  "medical icon",
  "microbes",
  "microbiology lab",
  "microscopic",
  "prokaryote",
  "single-celled",
  "cook time",
  "microwave",
  "nuking",
  "quick meal",
  "reheat",
  "nuke",
  "achievement unlocked",
  "armed forces",
  "army",
  "bravery",
  "heroism",
  "honor",
  "insignia",
  "merit",
  "military tech",
  "privilege",
  "soldier",
  "valor",
  "veteran",
  "warrior",
  "hangouts",
  "mimo",
  "no computer",
  "no display",
  "no monitor",
  "no screen",
  "shutdown",
  "brain waves",
  "human head",
  "meditation",
  "personal growth",
  "restore down",
  "system tray",
  "window control",
  "fender bender",
  "mishap",
  "small accident",
  "wreck",
  "cheap",
  "mintmark",
  "declined video call",
  "declined videocall",
  "missed video call",
  "missed videocall",
  "rejected video call",
  "rejected videocall",
  "upward arrow",
  "videocall",
  "locating",
  "misty",
  "smog",
  "bishop's mitre",
  "cyber attacks",
  "mitre",
  "schema",
  "antibiotic",
  "booster",
  "immunization",
  "meds",
  "mixture",
  "shot",
  "vitamin",
  "image message",
  "mms",
  "multimedia message",
  "photo message",
  "picture message",
  "texting",
  "take",
  "grasp",
  "calls off",
  "cellphone off",
  "disable calls",
  "disable cellphone",
  "disable mobile",
  "disable phone",
  "disable smartphone",
  "disable texting",
  "hand off",
  "handheld off",
  "mobile off",
  "no calls",
  "no cellphone",
  "no device",
  "no handheld",
  "no smartphone",
  "no texting",
  "phone off",
  "restrict calls",
  "restrict cellphone",
  "restrict mobile",
  "restrict phone",
  "restrict smartphone",
  "restrict texting",
  "smartphone off",
  "texting off",
  "no cellular",
  "no handoff",
  "add tag",
  "create tag",
  "label phone",
  "mobile search",
  "new tag",
  "phone search",
  "tag phone",
  "mobile_off",
  "mobile application",
  "mobile screen share",
  "mobile share",
  "idle",
  "lock screen",
  "screen lock",
  "screensaver",
  "standby",
  "wallpaper",
  "ringer",
  "ringtone",
  "vibrate mode",
  "volume down",
  "volume up",
  "speakerphone",
  "cellular disabled",
  "internet disabled",
  "signal disabled",
  "comment box",
  "leave comment",
  "mode comment",
  "chiller",
  "cool mode",
  "frost",
  "ice crystal",
  "low temperature",
  "mode cool",
  "wintertime",
  "ac off",
  "air conditioning off",
  "cold off",
  "cooling off",
  "deactivate cool",
  "disable cool",
  "freeze off",
  "mode cool off",
  "no cool",
  "no cooling",
  "snowflake off",
  "stop cool",
  "stop cooling",
  "turn off cool",
  "winter off",
  "cool air",
  "four blades",
  "four leaf clover",
  "velocity",
  "disable fan",
  "fan control",
  "fan disabled",
  "mode fan off",
  "no airflow",
  "no fan",
  "no ventilation",
  "heatwave",
  "warm weather",
  "deactivate heat",
  "disable heating",
  "disabled heat",
  "fire off",
  "flame off",
  "heat disabled",
  "heat off",
  "heating disabled",
  "heating off",
  "no fire",
  "no flame",
  "no heat",
  "no heating",
  "no warmth",
  "temperature off",
  "thermostat off",
  "turn off heat",
  "turn off heating",
  "warmth off",
  "mode of travel",
  "of",
  "returning",
  "round trip",
  "on/off switch",
  "hibernate",
  "on/off",
  "deep learning",
  "iterate",
  "ml",
  "model_training",
  "neural network",
  "optimization",
  "manipulate",
  "manipulation",
  "modelling",
  "100",
  "hundred",
  "profit",
  "lend",
  "loans",
  "loot",
  "money bag",
  "money sack",
  "sack",
  "cancel payment",
  "cashback",
  "currency off",
  "dollar off",
  "money off",
  "no cost",
  "no fee",
  "no money",
  "no transaction",
  "price cut",
  "price reduction",
  "reduced price",
  "refund",
  "remove cost",
  "slashed price",
  "zero cost",
  "lcd",
  "ecc",
  "monitor_heart",
  "telehealth",
  "add weight",
  "weight tracking",
  "digital health",
  "online tracking",
  "open corner",
  "track weight",
  "weight goal",
  "weight loss",
  "weight management",
  "bw",
  "dual tone",
  "photography mode",
  "two tone",
  "elevated train",
  "reactions",
  "smiley face",
  "bad mood",
  "customer feedback",
  "disappointment",
  "frown",
  "mood bad",
  "negative emotion",
  "sad",
  "unhappiness",
  "unhappy",
  "unhappy face",
  "unpleased",
  "unsmile",
  "unsmiling",
  "upset",
  "cosmos",
  "galaxy",
  "night time",
  "twinkle",
  "bristles",
  "custodial",
  "janitor",
  "mop",
  "neaten",
  "sweep up",
  "sweeper",
  "tidy up",
  "meal delivery",
  "on-demand delivery",
  "rider",
  "actions",
  "etc",
  "show less",
  "double l",
  "see more",
  "hamburger menu alternative",
  "horiz",
  "kebab menu",
  "more actions",
  "more options",
  "add duration",
  "additional duration",
  "additional time",
  "extra duration",
  "extra time",
  "increase duration",
  "more time",
  "rescheduling",
  "time extension",
  "double line",
  "more up",
  "additional options",
  "additional settings",
  "extra options",
  "hidden menu",
  "more settings",
  "vert",
  "vertical ellipsis",
  "vertical menu",
  "arab",
  "eid",
  "holy place",
  "islam",
  "islamic",
  "masjid",
  "middle east",
  "minaret",
  "muslim",
  "pilgrimage",
  "ramadan",
  "acceleration",
  "comet",
  "motionblur",
  "streaks",
  "swift",
  "motion mode",
  "live photo",
  "motion photo",
  "disable motion photo",
  "line through circle",
  "live picture",
  "motion photos",
  "motion photos off",
  "no motion",
  "no motion photos",
  "no photos",
  "animate",
  "live photos",
  "still",
  "field of view",
  "motion ",
  "no movement",
  "not detected",
  "movement sensor",
  "motorsport",
  "two-wheeler",
  "aspiration",
  "conquer",
  "motivation",
  "mountain top",
  "overcome",
  "self help",
  "computer hardware",
  "computer peripheral",
  "scrolling",
  "click lock",
  "click restrict",
  "cursor lock",
  "mouse access",
  "mouse control",
  "mouse lock",
  "mouse restriction",
  "peripheral lock",
  "pointer lock",
  "disable mouse",
  "mouse disabled",
  "mouse off",
  "no mouse",
  "restrict mouse",
  "unlock mouse",
  "move location",
  "content movement",
  "rearrange",
  "export group",
  "import group",
  "migration",
  "move group",
  "relocate group",
  "send group",
  "shift group",
  "transfer group",
  "transition group",
  "export item",
  "item management",
  "move item",
  "relocate item",
  "send item",
  "share item",
  "shift item",
  "transfer item",
  "change address",
  "direction arrow",
  "person location",
  "search location",
  "user location",
  "move selection",
  "content arrangement",
  "element movement",
  "layer adjustment",
  "move selection left",
  "position adjustment",
  "realign",
  "move selection up",
  "compile",
  "moved",
  "directing",
  "hollywood",
  "shooting",
  "film editing",
  "filmmaker",
  "movie editing",
  "movie maker",
  "post-production",
  "film details",
  "movie information",
  "movie reel",
  "synopsis",
  "block film",
  "block movie",
  "block video",
  "cancel film",
  "cancel movie",
  "cancel video",
  "cinema off",
  "clapperboard off",
  "disabled film",
  "disabled movie",
  "disabled video",
  "end film",
  "end movie",
  "film off",
  "film slate",
  "movie off",
  "movie slate",
  "no cinema",
  "no film",
  "no movie",
  "restrict film",
  "restrict movie",
  "restrict video",
  "stop film",
  "stop movie",
  "advancement",
  "ascending",
  "change rooms",
  "department transfer",
  "healthcare move",
  "hospital bed",
  "medical transfer",
  "move patient",
  "move ward",
  "moving_beds",
  "patient move",
  "patient transfer",
  "room change",
  "transfer bed",
  "ward change",
  "company move",
  "ministry",
  "move office",
  "relocation",
  "audio format",
  "digital media",
  "media format",
  "mp4",
  "crock-pot",
  "electric cooker",
  "instant pot",
  "multicooker",
  "pressure cooker",
  "slow cooker",
  "multiline chart",
  "hand eye coordination",
  "human computer interaction",
  "airports",
  "destinations",
  "locations",
  "multi-city",
  "multi-city flight",
  "multiple airports",
  "waypoints",
  "left and right",
  "multi-stop",
  "attraction",
  "exhibit",
  "exhibition",
  "family trip",
  "field trip",
  "school trip",
  "visit",
  "audio cast",
  "audio sharing",
  "broadcasting",
  "music broadcast",
  "music share",
  "music streaming",
  "sound stream",
  "audiotrack",
  "eighth note",
  "quaver",
  "single note",
  "soundtrack",
  "add audio",
  "add music",
  "add sound",
  "audio plus",
  "create audio",
  "create music",
  "create sound",
  "include audio",
  "include music",
  "include sound",
  "insert audio",
  "insert music",
  "insert sound",
  "music plus",
  "new audio",
  "new music",
  "new sound",
  "plus audio",
  "plus music",
  "plus sound",
  "sound plus",
  "disable music",
  "music disabled",
  "turn off music",
  "turn off sound",
  "music video",
  "my location",
  "whereabouts",
  "detective",
  "eyeball",
  "magnify glass",
  "mystery",
  "thrillers",
  "nat",
  "network address translation",
  "port forwarding",
  "arbor",
  "flora",
  "greenery",
  "roots",
  "sapling",
  "seedling",
  "trunk",
  "nature walk",
  "find me",
  "me",
  "near",
  "near me",
  "find disabled",
  "location services disabled",
  "near me disabled",
  "pin disabled",
  "pinpoint disabled",
  "place disabled",
  "proximity disabled",
  "search disabled",
  "around me",
  "points of interest",
  "surroundings",
  "vicinity",
  "gps error",
  "map error",
  "nearby issue",
  "nearby problem",
  "proximity alert",
  "area disabled",
  "area off",
  "local disabled",
  "local off",
  "nearby_off",
  "neighborhood disabled",
  "neighborhood off",
  "proximity off",
  "surrounding",
  "surrounding disabled",
  "surrounding off",
  "vicinity disabled",
  "vicinity off",
  "abstract kidney",
  "bladder",
  "clinical",
  "dual kidney",
  "human organ",
  "human organs",
  "kidney",
  "kidney icon",
  "kidney symbol",
  "kidneys",
  "mirrored kidney",
  "nephrology",
  "renal",
  "ureter",
  "urethra",
  "urinary",
  "urinary system",
  "urology",
  "google nest",
  "nest hub",
  "nest mini",
  "floodlight",
  "iq",
  "nest cam",
  "protext",
  "nest cam iq",
  "mounted",
  "wall mount",
  "adhesion",
  "magnet",
  "magnet mount",
  "magnetic mount",
  "mounting",
  "wifi camera",
  "swivel",
  "wall ",
  "internet camera",
  "watching",
  "12:36",
  "twelve thirty-six",
  "linking",
  "hub max",
  "nest display max",
  "doorbell cam",
  "remote monitoring",
  "rebate",
  "gen",
  "gen 3",
  "heat link",
  "nest thermostat",
  "intercom",
  "nest hello",
  "smart doorbell",
  "video doorbell",
  "ornament",
  "pendant",
  "floor plan",
  "multi",
  "multi-room",
  "multiple rooms",
  "rooms",
  "carbon monoxide detector",
  "nest protect",
  "smarthouse",
  "access code",
  "nest secure",
  "nine dots",
  "sunblock",
  "sunscreen",
  "ultraviolet",
  "uv",
  "locator",
  "70",
  "digital thermostat",
  "frostat",
  "room temperature",
  "temperature setting",
  "nest thermostat e",
  "nest thermostat eu",
  "generation 3",
  "nest gen 3",
  "nest learning thermostat",
  "zirconium",
  "double u",
  "flowing",
  "meander",
  "meandering",
  "serpentine",
  "snake",
  "winding",
  "approach",
  "approach detection",
  "proximity sensor",
  "user presence",
  "wake on approach",
  "power on",
  "extender",
  "repeater",
  "vento",
  "pro",
  "single dot",
  "curved rectangle",
  "mesh network",
  "mistral",
  "network cell",
  "diagnose",
  "network check",
  "network performance",
  "speed test",
  "wi-fi",
  "clever",
  "connected nodes",
  "digital brain",
  "distributed network",
  "network connections",
  "network intelligence node",
  "smart network",
  "hemispheres",
  "network analysis",
  "network diagram",
  "network intelligence",
  "ai history",
  "ai network",
  "deep learning history",
  "intelligence history",
  "intelligence timeline",
  "machine learning history",
  "machine learning network",
  "network activity",
  "network history",
  "network insights",
  "network intelligence history",
  "network intelligence log",
  "network log",
  "network timeline",
  "neural network history",
  "past intelligence",
  "past network activity",
  "brain icon",
  "cognitive",
  "connection security",
  "network access",
  "network locked",
  "network symbol",
  "network unavailable",
  "private network",
  "restricted network",
  "secure network",
  "signal lock",
  "signal secure",
  "wifi locked",
  "wifi security",
  "wireless locked",
  "wireless security",
  "wireless symbol",
  "internet management",
  "internet settings",
  "network configuration",
  "wifi icon",
  "wifi management",
  "wifi settings",
  "wireless management",
  "wireless settings",
  "joined",
  "network topology",
  "echo",
  "ping",
  "sonar",
  "radiating lines",
  "radio waves",
  "internet signal",
  "low wifi",
  "network bars",
  "poor connection",
  "weak wifi",
  "wifi bars",
  "wifi signal",
  "wifi status",
  "wifi strength",
  "wireless status",
  "network lock",
  "wifi connection",
  "wifi lock",
  "wireless lock",
  "internet icon",
  "internet status",
  "medium signal",
  "wireless fidelity",
  "locked network",
  "secure wifi",
  "3 bars",
  "moderate signal",
  "full signal",
  "strong signal",
  "wep",
  "wpa",
  "brainstorm",
  "central nervous system",
  "nervous system",
  "neural",
  "neurologist",
  "add label",
  "create label",
  "forward arrow",
  "add tab",
  "browser tab",
  "browser window",
  "create tab",
  "open in new tab",
  "open window",
  "tab management",
  "newsletter",
  "current events",
  "digital news",
  "newsmode",
  "online news",
  "jagged edge",
  "periodical",
  "articles",
  "leaning",
  "newsstand",
  "next plan",
  "next song",
  "progression",
  "next week",
  "mobile payment",
  "payment off",
  "homeless",
  "homelessness",
  "night_shelter",
  "nonprofit",
  "refuge",
  "resting place",
  "sanctuary",
  "temporary housing",
  "auto night sight",
  "night sight",
  "night view",
  "auto adjust",
  "auto night mode off",
  "auto rotate",
  "night photography",
  "late night",
  "night sight max",
  "dance",
  "nightlife icon",
  "astronomy icon",
  "bedtime story",
  "night icon",
  "nightlight",
  "sleep icon",
  "honeymoon",
  "nights",
  "nights_stay",
  "phases",
  "ban user",
  "block user",
  "cancel account",
  "delete account",
  "no accounts",
  "no login",
  "no registration",
  "no sign in",
  "remove user",
  "unidentifiable",
  "adult content ban",
  "block adult content",
  "child safe",
  "explicit content ban",
  "family friendly",
  "mature content ban",
  "no 18+",
  "no adult",
  "no adult content",
  "no explicit content",
  "no mature content",
  "no nsfw",
  "no nudity",
  "no pornography",
  "no sex",
  "no xxx",
  "nsfw ban",
  "pornography ban",
  "prohibition sign",
  "restricted content",
  "under 18 restricted",
  "xxx forbidden",
  "bag ban",
  "baggage restriction",
  "luggage ban",
  "luggage restriction",
  "no backpack",
  "no backpacks allowed",
  "no baggage",
  "no bags",
  "no bags allowed",
  "no carry on",
  "no knapsack",
  "no large bags",
  "no luggage",
  "no personal items",
  "no rucksack",
  "no school bags",
  "pack ban",
  "school ban",
  "school restriction",
  "travel ban",
  "travel restriction",
  "accident prevention",
  "car check",
  "no accident",
  "no crash",
  "road safety",
  "safe car",
  "secure car",
  "cocktail glass",
  "do not drink",
  "drinks",
  "martini glass",
  "no alcohol",
  "no beer",
  "no beverages",
  "no cocktails",
  "no drinking",
  "no drinks",
  "no liquids",
  "no wine",
  "sobriety",
  "temperance",
  "unprotected",
  "disable flash",
  "flash forbidden",
  "flash off",
  "flash prohibited",
  "no photo flash",
  "no photography",
  "no pictures",
  "photography disabled",
  "photography restriction",
  "pictures disabled",
  "dieting",
  "do not eat",
  "do not eat here",
  "dont",
  "eating prohibited",
  "fasting",
  "food prohibited",
  "food restriction",
  "no consumption",
  "no eating",
  "no food",
  "no food allowed",
  "no food or drink",
  "no meals",
  "no snacks",
  "restricted food",
  "disallowed",
  "no carry-on",
  "no hand luggage",
  "no suitcase",
  "no travel",
  "restricted luggage",
  "avoid food",
  "cleanse",
  "cutlery ban",
  "detox",
  "dining restrictions",
  "food break",
  "fork and knife",
  "hunger strike",
  "intermittent fasting",
  "no breakfast",
  "no dining",
  "no dinner",
  "no lunch",
  "no utensils",
  "restricted diet",
  "skip meal",
  "appointment cancelled",
  "booking cancelled",
  "conference room unavailable",
  "meeting cancelled",
  "meeting unavailable",
  "no appointments",
  "no availability",
  "no bookings",
  "no conference room",
  "no meeting",
  "no meeting room",
  "no room available",
  "no rooms",
  "room unavailable",
  "camera ban",
  "capture ban",
  "do not record",
  "film ban",
  "image ban",
  "no capture",
  "no images",
  "photo off",
  "photography ban",
  "picture ban",
  "record off",
  "video ban",
  "insert sim",
  "missing sim",
  "network strength",
  "no sim",
  "sim card",
  "sim error",
  "Volume",
  "audio mute",
  "audio with x",
  "crossed out speaker",
  "disable volume",
  "no volume",
  "sound mute",
  "sound with x",
  "speaker disabled",
  "speaker mute",
  "speaker off",
  "speaker with x",
  "turn off audio",
  "turn off volume",
  "volume disabled",
  "volume mute",
  "volume with x",
  "no babies",
  "no children",
  "no stroller",
  "bus stop closed",
  "bus unavailable",
  "no bus",
  "no coach",
  "no service",
  "no shuttle",
  "no transportation",
  "public transport unavailable",
  "transportation disabled",
  "ambient noise",
  "noise cancellation",
  "noise control",
  "noise_aware",
  "sound sensitivity",
  "mute audio",
  "mute sound",
  "noise cancellation off",
  "noise control off",
  "noise reduction off",
  "activate audio",
  "audio on",
  "enable sound",
  "noise on",
  "sound activated",
  "sound enabled",
  "unmuted",
  "cross-country",
  "figure walking",
  "nordic walking",
  "poles",
  "snowshoeing",
  "sticks",
  "noth",
  "up right",
  "upper right",
  "arrow pointing northwest",
  "arrow pointing top left",
  "arrow pointing up left",
  "north west",
  "top-left",
  "up-left",
  "accessibility restriction",
  "disabled access",
  "inaccessible",
  "mobility impaired",
  "no disabilities",
  "no wheelchair",
  "not accessible",
  "wheelchair access denied",
  "wheelchair symbol",
  "wheelchair user",
  "disabled person",
  "no go",
  "no wheelchair access",
  "wheelchair inaccessible",
  "explore location",
  "explore place",
  "hidden location",
  "listed",
  "mystery location",
  "not listed location",
  "search place",
  "secret location",
  "uncharted territory",
  "undiscovered location",
  "unknown area",
  "unknown place",
  "unlisted location",
  "unmarked place",
  "where",
  "not started",
  "started",
  "unpause",
  "create file",
  "document creation",
  "file creation",
  "new file",
  "alternative note",
  "jot down",
  "note alt",
  "note pad",
  "take notes",
  "papers",
  "post it",
  "post-it",
  "sticky note",
  "sticky notes",
  "memo pad",
  "add alert",
  "create notification",
  "enable notifications",
  "new notification",
  "notification control",
  "notification management",
  "notification on",
  "notification plus",
  "subscribe to notifications",
  "turn on notifications",
  "alert bell",
  "application notification",
  "essential notification",
  "important update",
  "status update",
  "system notification",
  "time sensitive",
  "warning bell",
  "alert control",
  "alert management",
  "alert preferences",
  "bell settings",
  "audio notification",
  "bell curve",
  "notification sound",
  "ringing bell",
  "sound effect",
  "warnings",
  "active notification",
  "alerts disabled",
  "alerts off",
  "bell with slash",
  "crossed out bell",
  "disable alerts",
  "disable notifications",
  "notification disabled",
  "notifications off",
  "slashed bell",
  "turn off notifications",
  "notification paused",
  "notifications paused",
  "ring --- pause",
  "z",
  "zzz",
  "announcements",
  "facebook",
  "hash",
  "instagram",
  "tagging",
  "tagging symbol",
  "twitter",
  "citrus",
  "healthy eating",
  "minerals",
  "plant-based",
  "vitamins",
  "calc",
  "libreoffice",
  "ods",
  "office suite",
  "open document",
  "open document spreadsheet",
  "openoffice",
  "workbook",
  "editable",
  "odt",
  "open format",
  "word document alternative",
  "word processing document",
  "not available",
  "offline bolt",
  "power outage",
  "synced",
  "map marker off",
  "offline location",
  "unavailable location",
  "device to device",
  "offline share",
  "barrel",
  "commodity",
  "crude oil",
  "drum",
  "energy industry",
  "fossil fuel",
  "oil barrel",
  "oil drop",
  "oil industry",
  "petroleum",
  "mobile learning",
  "mobile training",
  "on device",
  "on-device",
  "active device",
  "connected device",
  "device hub",
  "device on",
  "hub device",
  "cancer",
  "cancer diagnosis",
  "cancer treatment",
  "find oncology",
  "health research",
  "healthcare icon",
  "oncology",
  "oncology research",
  "physician",
  "search oncology",
  "anticipate",
  "foresee",
  "bowl",
  "japanese bath",
  "rising steam",
  "thermal bath",
  "alpha",
  "see-through",
  "translucent",
  "external program",
  "open in browser",
  "open link",
  "open in full",
  "external website",
  "offsite link",
  "external link off",
  "launch off",
  "new window off",
  "open in new off",
  "open off",
  "pop out off",
  "jam",
  "jam session",
  "open jam",
  "fullscreen mode",
  "breakout",
  "cardinal directions",
  "open with",
  "eye care",
  "ophthalmology",
  "optometry",
  "vision care",
  "abstract teeth",
  "bad breath",
  "cavities",
  "gingivitis",
  "gum disease",
  "gums",
  "halitosis",
  "oral health",
  "periodontitis",
  "plaque",
  "tooth decay",
  "tooth icon",
  "two teeth",
  "dv360",
  "outer space",
  "physics",
  "planetary",
  "solar system",
  "universe",
  "checkmark circle",
  "order approve",
  "begin order",
  "begin process",
  "execute order",
  "execute process",
  "order execution",
  "play document",
  "play list",
  "play order",
  "process order",
  "run order",
  "run process",
  "start order",
  "start process",
  "open box",
  "packaged",
  "unboxing",
  "backbone",
  "physical therapy",
  "physiotherapy",
  "posture",
  "spinal",
  "vertebrae",
  "vertebral column",
  "alternative admission",
  "other admission",
  "pend",
  "special admission",
  "accommodations",
  "listings",
  "multiple houses",
  "other houses",
  "suburb",
  "offsite",
  "outbound",
  "dispatch",
  "front yard",
  "three pickets",
  "charcoal",
  "grilling",
  "hotdog",
  "outdoor cooking",
  "steak",
  "mail out",
  "outgoing mail",
  "send mail",
  "share email",
  "connecter",
  "electric socket",
  "electrical outlet",
  "power outlet",
  "three prongs",
  "two prongs",
  "wall socket",
  "day care",
  "discharge",
  "facility",
  "non-resident",
  "outpatient",
  "short stay",
  "cooker",
  "cooking appliance",
  "heet",
  "roast",
  "birdwatching",
  "nocturnal",
  "ornithology",
  "predator",
  "wise",
  "blood oxygen",
  "breathing",
  "lungs",
  "nostril",
  "oximetry",
  "oxygen level",
  "pulse ox",
  "pulse oximeter",
  "respiration",
  "spo2",
  "data bridge",
  "data sharing",
  "file sharing",
  "p2p",
  "peer",
  "peer to peer",
  "peer-to-peer",
  "peers",
  "life support",
  "pacemaker",
  "isometric",
  "negative space",
  "offset",
  "white space",
  "current page",
  "image slider",
  "onboarding",
  "page control",
  "paging",
  "steppers",
  "walkthrough",
  "end of page",
  "page footer",
  "privacy policy",
  "terms of service",
  "underneath",
  "page header",
  "doc info",
  "document details",
  "document information",
  "document symbol",
  "file details",
  "file information",
  "info symbol",
  "page details",
  "page info",
  "page information",
  "page symbol",
  "borderless",
  "continuous view",
  "edge to edge",
  "frameless",
  "no breaks",
  "no pages",
  "pageless",
  "seamless",
  "gplus",
  "pageview",
  "site search",
  "dues",
  "paid",
  "cmyk",
  "color lens",
  "color scheme",
  "color selection",
  "color theory",
  "color wheel",
  "rgb",
  "swatch",
  "crate",
  "skid",
  "drag tool",
  "grab tool",
  "three fingers",
  "viewport",
  "pan down",
  "pan left",
  "pan right",
  "pan up",
  "shrink view",
  "zooms",
  "planner",
  "ultrawide",
  "wide angle",
  "360 view",
  "full view",
  "panoramic view",
  "photosphere",
  "surround view",
  "vertical panorama",
  "air sports",
  "gliding",
  "hang gliding",
  "harness",
  "parachute",
  "paragliding",
  "skydiving",
  "evergreen icon",
  "fir tree icon",
  "pine tree icon",
  "state park",
  "three triangles",
  "tree icon",
  "afternoon",
  "broken clouds",
  "cloudy sunshine",
  "light cloud",
  "mostly sunny",
  "partial cloud",
  "scattered clouds",
  "sun and cloud",
  "sun behind cloud",
  "sun icon",
  "sun rays",
  "sunny intervals",
  "partly",
  "partner",
  "partner report",
  "partner reports",
  "partners",
  "moment",
  "party mode",
  "account key",
  "key management",
  "passkey",
  "personal key",
  "secure key",
  "signin",
  "user access",
  "user key",
  "asterisks",
  "redacted",
  "three stars",
  "horizontal bar",
  "hide password",
  "mask password",
  "password disabled",
  "password hidden",
  "password off",
  "password visibility",
  "show password",
  "toggle password",
  "unmask password",
  "view password",
  "health records",
  "medical records",
  "patient list",
  "person list",
  "user list",
  "control button",
  "double bar",
  "intermission",
  "media button",
  "playback control",
  "filled",
  "outlined",
  "solid",
  "pause presentation",
  "presentation control",
  "slide deck",
  "stop button",
  "video conferencing",
  "payments",
  "bicycle icon",
  "biking",
  "pedal",
  "pedal bike",
  "baby bottle",
  "child health",
  "feeding bottle",
  "pacifier",
  "pediatrics",
  "fine",
  "oblique line",
  "pen stroke",
  "pen tool",
  "thin",
  "pen_size_2",
  "pen size",
  "pen_size_3",
  "pending action",
  "pending task",
  "queued",
  "delayed",
  "pending actions",
  "postponed",
  "five sides",
  "five-angled",
  "five-sided",
  "regular pentagon",
  "%",
  "per hundred",
  "gazebo",
  "outdoor structure",
  "pergola",
  "posts",
  "trellis",
  "audio conference",
  "min",
  "perm",
  "calendar appointment",
  "contact calendar",
  "contact date",
  "contact event",
  "person calendar",
  "profile calendar",
  "schedule appointment",
  "user calendar",
  "user event",
  "adjust angle",
  "change angle",
  "data adjust",
  "data configuration",
  "data permission",
  "data setting",
  "data transformation",
  "perm data setting",
  "about device",
  "about phone",
  "device details",
  "device info",
  "handset information",
  "mobile device information",
  "mobile information",
  "mobile specs",
  "phone details",
  "specifications",
  "perm_media",
  "msg",
  "phone message",
  "connection details",
  "connection help",
  "connection info",
  "info icon",
  "internet details",
  "internet help",
  "internet info",
  "network details",
  "network help",
  "network info",
  "signal details",
  "signal help",
  "signal info",
  "wifi details",
  "wifi help",
  "wifi info",
  "wireless details",
  "wireless help",
  "wireless info",
  "person outline",
  "2 people",
  "person_2",
  "torso",
  "3 users",
  "multiple people",
  "people group",
  "users group",
  "four people",
  "group of people",
  "team of four",
  "add contact",
  "create contact",
  "create person",
  "create user",
  "new contact",
  "new member",
  "new person",
  "person plus",
  "plus person",
  "user plus",
  "add person disabled",
  "add user disabled",
  "cannot add",
  "create user disabled",
  "forbid",
  "new user disabled",
  "no add",
  "no new users",
  "person add disabled",
  "person_alert",
  "apron",
  "barista",
  "bartender",
  "butcher",
  "craftsman",
  "gardener",
  "laborer",
  "painter",
  "potter",
  "protective gear",
  "waiter",
  "waitress",
  "biography",
  "memoir",
  "account deletion",
  "account removal",
  "block friend",
  "block person",
  "cancel person",
  "cancel user",
  "delete friend",
  "delete person",
  "delete user",
  "person deletion",
  "person removal",
  "person x",
  "person_cancel",
  "profile deletion",
  "profile removal",
  "remove friend",
  "remove person",
  "user deletion",
  "user removal",
  "user x",
  "juggle",
  "juggling",
  "person_celebrate",
  "talent",
  "person check",
  "user check",
  "account off",
  "ban person",
  "deactivate account",
  "disable person",
  "disable user",
  "hide person",
  "hide user",
  "person blocked",
  "person off",
  "profile off",
  "user off",
  "contact location",
  "person pin",
  "profile location",
  "coordinate",
  "location marker",
  "map pointer",
  "person marker",
  "user pin",
  "entertain",
  "multitask",
  "person_play",
  "trick",
  "tricks",
  "ask question",
  "raise hand",
  "simple person",
  "volunteer",
  "account delete",
  "account remove",
  "delete profile",
  "minus person",
  "person block",
  "person delete",
  "person minus",
  "person subtract",
  "person_remove",
  "profile delete",
  "profile remove",
  "remove account",
  "remove profile",
  "subtract person",
  "user block",
  "user delete",
  "user minus",
  "person_search",
  "account security",
  "member protection",
  "profile security",
  "security settings",
  "user privacy",
  "user security",
  "haversack",
  "personal items",
  "satchel",
  "baggage restrictions",
  "luggage restrictions",
  "no bag",
  "no satchel",
  "personal item restriction",
  "uncertainty",
  "broke",
  "broken arm",
  "claim",
  "personal injury",
  "worker's compensation",
  "custom locations",
  "favorite places",
  "my places",
  "placemark",
  "saved places",
  "user locations",
  "ant",
  "anti pest",
  "beetle",
  "bug fix",
  "bug spray",
  "cockroach",
  "eliminate pest",
  "extermination",
  "exterminator",
  "fix bug",
  "insect control",
  "insecticide",
  "kill bug",
  "pest",
  "pest control",
  "pest removal",
  "remove bug",
  "software bug",
  "spider",
  "bait",
  "health hazard",
  "home pest",
  "household pests",
  "infestation",
  "mammal",
  "mice",
  "pest problem",
  "rat",
  "rats",
  "rodent",
  "rodent control",
  "trap",
  "unwanted guest",
  "vermin",
  "animal food",
  "animal supplies",
  "cat",
  "chew toy",
  "dog treat",
  "kitten",
  "pet food",
  "pet products",
  "pet shop",
  "pet store",
  "pet supplies",
  "puppy",
  "adoption",
  "animal footprint",
  "animal paw",
  "animal shelter",
  "animal track",
  "companion animal",
  "domestic animal",
  "fauna",
  "four paws",
  "four toes",
  "paw",
  "paw print",
  "pawpads",
  "pet care",
  "pets",
  "veterinary",
  "account takeover",
  "cyber security",
  "cybercrime",
  "fish hook",
  "fishing",
  "fraud",
  "hack",
  "identity theft",
  "internet fraud",
  "lure",
  "malicious",
  "online fraud",
  "phishing",
  "scam",
  "suspicious",
  "android phone",
  "android phone icon",
  "button icon",
  "cellular icon",
  "device icon",
  "digital icon",
  "display icon",
  "dot icon",
  "electronics icon",
  "gadget icon",
  "handheld icon",
  "mobile phone icon",
  "portable icon",
  "rectangle icon",
  "rounded rectangle icon",
  "screen icon",
  "technology icon",
  "hands free",
  "helpdesk",
  "inbound call",
  "phone and arrow",
  "phone arrow",
  "return call",
  "calling disabled",
  "no calling",
  "phone disabled",
  "make a call",
  "receive a call",
  "call divert",
  "call redirect",
  "forwarded",
  "forwarding",
  "telephone forwarding",
  "telephone redirect",
  "telephone transfer",
  "active call",
  "in call",
  "ongoing call",
  "call blocked",
  "call lock",
  "call restriction",
  "incoming call lock",
  "outgoing call lock",
  "phone locked",
  "phone restriction",
  "phone security",
  "missed notification",
  "call paused",
  "communication paused",
  "hold call",
  "mute call",
  "pause call",
  "phone paused",
  "break link",
  "mobile connection",
  "phone management",
  "call mute",
  "call silence",
  "no mobile signal",
  "no ring",
  "notification mute",
  "notification silence",
  "app_settings_alt",
  "application settings",
  "mobile gear",
  "mobile_gear",
  "phonelink_setup",
  "picture frame",
  "bookmarked album",
  "favorite album",
  "image folder",
  "memories",
  "photo album",
  "photo archive",
  "photo storage",
  "picture archive",
  "picture folder",
  "picture gallery",
  "saved album",
  "scrapbook",
  "photo auto merge",
  "best take",
  "capture icon",
  "camera mode",
  "toggle camera",
  "account image",
  "front facing camera",
  "photo capture",
  "profile image",
  "user image",
  "user photo",
  "digital photo",
  "picture viewer",
  "hard copy",
  "photo prints",
  "physical photo",
  "photo frame",
  "photo settings",
  "picture settings",
  "dynamic website",
  "hypertext preprocessor",
  "php",
  "php development",
  "scripting language",
  "server-side scripting",
  "web application",
  "physical therapist",
  "pose",
  "rehab center",
  "stretching",
  "therapy session",
  "yoga",
  "audio app",
  "black keys",
  "chords",
  "digital piano",
  "midi",
  "music app",
  "musical instrument",
  "musical keys",
  "piano",
  "synthesizer",
  "three keys",
  "white keys",
  "no piano",
  "no playing",
  "piano keys",
  "acrobat",
  "adobe",
  "pdf",
  "portable document format",
  "cropped",
  "displays",
  "floating video",
  "multi window",
  "nested window",
  "overlay window",
  "pip",
  "pop-out video",
  "sizes",
  "small window",
  "talktrack",
  "video overlay",
  "multiscreen",
  "nested square",
  "expand window",
  "large view",
  "multi-window",
  "shrink window",
  "mini player",
  "no pip",
  "picture-in-picture",
  "pop up",
  "compact view",
  "pie graph",
  "painkiller",
  "capsules",
  "illicit",
  "medication off",
  "no drugs",
  "no medication",
  "no pills",
  "pills off",
  "stop medication",
  "stop pills",
  "tablets",
  "treatment off",
  "latitude",
  "longitude",
  "pin drop",
  "invoke",
  "pin invoke",
  "pin note",
  "pin push",
  "pin tack",
  "pinboard",
  "sticky",
  "mobile gesture",
  "multitouch",
  "nip",
  "shrink arrows",
  "tweak",
  "two fingers",
  "expand gesture",
  "image scaling",
  "map scaling",
  "pinch gesture",
  "two finger",
  "zoom control",
  "zoom gesture",
  "zoom in gesture",
  "pinch out",
  "mini view",
  "pip exit",
  "bi",
  "data manipulation",
  "pivot",
  "pivot chart",
  "pivot table",
  "place item",
  "put",
  "honesty",
  "integrity",
  "originality",
  "plagiarism",
  "plagiarism check",
  "asteroid",
  "extraterrestrial",
  "gas giant",
  "ringed planet",
  "saturn",
  "sci-fi",
  "pt",
  "audio visual",
  "play circle",
  "start playback",
  "blocked play",
  "cant play",
  "disabled play",
  "inactive play",
  "no play",
  "play blocked",
  "play disabled",
  "play off",
  "play restriction",
  "restrict play",
  "stop play",
  "unavailable play",
  "unplayable",
  "begin task",
  "download for work",
  "duty",
  "play for work",
  "start work",
  "work assignment",
  "audio lesson",
  "begin lesson",
  "online course",
  "play course",
  "play lesson",
  "play tutorial",
  "play_lesson",
  "start course",
  "start lesson",
  "video lesson",
  "play/pause",
  "right triangle",
  "blackjack",
  "card deck",
  "card game",
  "clubs",
  "hearts",
  "playing",
  "playing cards",
  "poker",
  "solitaire",
  "spades",
  "suit",
  "suits",
  "append to playlist",
  "create playlist",
  "new playlist",
  "playlist complete",
  "playlist confirmed",
  "playlist created",
  "playlist success",
  "playlist valid",
  "save playlist",
  "check circle",
  "confirmed playlist",
  "playlist addition",
  "playlist checked",
  "add song",
  "audio playlist",
  "media playlist",
  "music playlist",
  "play icon",
  "play playlist",
  "playlist icon",
  "start playlist",
  "adjustable wrench",
  "pipe wrench",
  "plumbing service",
  "podcasts",
  "boots",
  "chiropodist",
  "chiropody",
  "foot care",
  "foot health",
  "insole",
  "lower leg",
  "shoes",
  "toe",
  "conference equipment",
  "dais",
  "debate",
  "keynote",
  "lectern",
  "microphone stand",
  "presentation stand",
  "public speaking",
  "pulpit",
  "rostrum",
  "seminar equipment",
  "speaking engagement",
  "cash register",
  "cashier",
  "merchant",
  "four rectangles",
  "casino token",
  "coins",
  "gambling chip",
  "jackpot",
  "slots",
  "winnings",
  "find policy",
  "inspect policy",
  "policy inspection",
  "policy review",
  "policy search",
  "review policy",
  "search policy",
  "security policy",
  "inspection",
  "policy breach",
  "policy violation",
  "angles",
  "multi-point",
  "three points",
  "vertices",
  "material",
  "plastic",
  "polymer",
  "synthetic",
  "dive",
  "diving",
  "person swimming",
  "swimmer",
  "swimming",
  "wavy lines",
  "mobile hotspot",
  "personal hotspot",
  "tether",
  "bottom left",
  "z-index",
  "position bottom right",
  "rectangle with bar",
  "compose post",
  "create post",
  "write post",
  "flowerpot",
  "houseplant",
  "indoor plant",
  "planter",
  "potted",
  "potted plant",
  "two leaves",
  "reboot",
  "power input",
  "appliance off",
  "computer off",
  "off switch",
  "power plug",
  "system off",
  "technology off",
  "system settings",
  "power control",
  "universal power symbol",
  "asr",
  "dhuhr",
  "fajr",
  "isha",
  "islamic calendar",
  "maghrib",
  "prayer times",
  "rub el hizb",
  "salah",
  "articulated arm",
  "clamp",
  "industrial robot",
  "mechanical arm",
  "robotic arm",
  "robotic automation",
  "three claws",
  "childbirth",
  "dad",
  "expectant mother",
  "expecting",
  "gestation",
  "paternity",
  "pregnant",
  "prescriptions",
  "present to all",
  "send to all",
  "triangle up",
  "pre-view",
  "quick view",
  "block preview",
  "cancel preview",
  "disable preview",
  "eye closed",
  "hide view",
  "monitor off",
  "no eye",
  "no preview",
  "presentation off",
  "preview_off",
  "screen off",
  "stop preview",
  "cost change",
  "price change",
  "pricing",
  "hardcopy",
  "local print",
  "local printshop",
  "print job",
  "printing",
  "printshop",
  "add print job",
  "add print task",
  "add printer",
  "create printer",
  "new print job",
  "new printer",
  "print document",
  "print queue",
  "print task",
  "print connected",
  "printer ready",
  "select printer",
  "block print",
  "cannot print",
  "crossed out print",
  "disable print",
  "disabled printer",
  "forbidden print",
  "no print",
  "no printer",
  "no printing",
  "off printer",
  "print block",
  "print crossed out",
  "print disabled",
  "print forbidden",
  "print off",
  "print restriction",
  "print slash",
  "print stop",
  "print unavailable",
  "printer disabled",
  "printer off",
  "printer unavailable",
  "printing disabled",
  "printing off",
  "restrict print",
  "slash print",
  "stop print",
  "unavailable print",
  "document error",
  "print error",
  "print fail",
  "print warning",
  "printer error",
  "printer issue",
  "printer warning",
  "printing failure",
  "printing problem",
  "confidential printing",
  "document security",
  "lock print",
  "manage printing",
  "print access",
  "print job security",
  "print lock",
  "print management",
  "print permissions",
  "print restrictions",
  "print security",
  "printing restrictions",
  "private printing",
  "protected printing",
  "restricted printing",
  "secure document printing",
  "secure print",
  "secure print job",
  "tick box",
  "microphone disabled",
  "recording disabled",
  "recording off",
  "private information",
  "security tip",
  "closed network",
  "intranet",
  "isolated",
  "private link",
  "secure connection",
  "secure link",
  "tunnel",
  "virtual private network",
  "vpn",
  "execution",
  "method",
  "operating room",
  "slants",
  "slashes",
  "stages",
  "out of stock",
  "finish task",
  "loading animation",
  "progress animation",
  "artificial",
  "autocomplete",
  "genai",
  "predictive text",
  "prompt_suggestion",
  "camping gear",
  "energy source",
  "fuel tank",
  "gas canister",
  "gas cylinder",
  "heating fuel",
  "propane tank",
  "camping fuel",
  "liquid propane gas",
  "lpg",
  "propane gas",
  "valve",
  "brain health",
  "emotional health",
  "flourish",
  "new beginnings",
  "psychiatry",
  "thrive",
  "ability",
  "behavior",
  "brain function",
  "intellectual",
  "psychiatric",
  "psychology settings",
  "confusion",
  "curiosity",
  "psychology_alt",
  "wonder",
  "dissemination",
  "everyone",
  "no public access",
  "public_off",
  "unshare",
  "go live",
  "share online",
  "modification",
  "published",
  "abstract lungs",
  "airways",
  "alveoli",
  "breath",
  "bronchi",
  "bronchial tubes",
  "chest",
  "exhale",
  "inhale",
  "lung",
  "pulmonology",
  "stylized lungs",
  "thorax",
  "trachea",
  "emergency alert",
  "health alert",
  "heart issue",
  "heartbeat alert",
  "irregular heartbeat",
  "loss of pulse",
  "medical alert",
  "pulse rate",
  "vital sign alert",
  "clock in",
  "clock out",
  "payroll",
  "punch",
  "punch clock",
  "time clock",
  "timecard",
  "timekeeping",
  "timesheet",
  "work hours",
  "2d code",
  "barcode scan",
  "digital code",
  "mobile scan",
  "mobile tag",
  "qr",
  "qrcode",
  "quick response",
  "quick response code",
  "squares and pixels",
  "two-dimensional code",
  "urls",
  "qr code 2",
  "scannable",
  "square code",
  "add qr",
  "create qr",
  "generate qr",
  "new qr code",
  "qr code add",
  "qr code create",
  "qr code generate",
  "qr code plus",
  "mobile scanning",
  "read qr",
  "read qr code",
  "data insights",
  "data metrics",
  "query_stats",
  "search data",
  "search trends",
  "trend analysis",
  "knowledge sharing",
  "question exchange",
  "interrogation",
  "music queue",
  "now playing",
  "playlist queue",
  "queue music",
  "song list",
  "up next",
  "media queue",
  "next up",
  "play next",
  "queue management",
  "automated response",
  "canned response",
  "phrases",
  "quick phrases",
  "cheat sheet",
  "frequently asked questions",
  "quick reference",
  "quickref",
  "all documents",
  "all files",
  "find all",
  "quick find",
  "quickview",
  "search all",
  "quick reorder",
  "quickreply",
  "multiple choice",
  "online exam",
  "online quiz",
  "online test",
  "true false",
  "cellular signal",
  "data roaming",
  "letter r",
  "r",
  "roaming indicator",
  "am",
  "classic",
  "fm",
  "old fashioned",
  "portable radio",
  "transistor",
  "checked button",
  "form element",
  "radiobutton",
  "ui control",
  "intermediate state",
  "radio button indeterminate",
  "radio button partial",
  "selection control",
  "false",
  "medical exam",
  "medical imaging",
  "medical test",
  "radiography",
  "radiologists",
  "disruption",
  "railway alert",
  "train alert",
  "train car",
  "exclamatory",
  "autumn",
  "bad weather",
  "cloud with rain",
  "downpour",
  "drizzle",
  "raindrops",
  "rainfall",
  "raining",
  "rainy",
  "showers",
  "cloudburst",
  "heavy",
  "intense",
  "rainstorm",
  "slanted lines",
  "torrent",
  "intermittent rain",
  "isolated showers",
  "light rain",
  "light shower",
  "scattered showers",
  "spitting",
  "blizzard",
  "flurries",
  "inclement weather",
  "mixed precipitation",
  "rain and snow",
  "rainy snow",
  "sleet",
  "snow rain",
  "snowing",
  "snowy rain",
  "winter weather",
  "wintry mix",
  "asian food",
  "chopsticks",
  "japanese cuisine",
  "japanese food",
  "noodle bowl",
  "ramen",
  "ramen noodles",
  "merge left",
  "ramp left",
  "arrow join",
  "arrow merge",
  "merge right",
  "on-ramp",
  "ramp right",
  "air filtration",
  "aroma control",
  "clean air",
  "exhaust",
  "extractor fan",
  "fume extractor",
  "grease",
  "kitchen ventilation",
  "overhead hood",
  "range hood",
  "restaurants",
  "suction",
  "avian",
  "blackbird",
  "claw",
  "corvid",
  "creature",
  "crow",
  "perch",
  "poetry",
  "raven",
  "cancel raw",
  "disable editing",
  "image format",
  "image processing",
  "no raw",
  "no unprocessed",
  "post processing",
  "raw",
  "raw disabled",
  "raw format",
  "raw off",
  "remove raw",
  "unedited",
  "unprocessed",
  "uncompressed",
  "read more",
  "view more",
  "hrv",
  "readiness",
  "tachometer",
  "agent",
  "broker",
  "mortgage",
  "realtor",
  "outward facing camera",
  "rebase",
  "proof of purchase",
  "tax",
  "torn paper",
  "zig zag edge",
  "budget management",
  "long receipt",
  "order history",
  "bill off",
  "disable bill",
  "disable invoice",
  "disable payment",
  "disable purchase",
  "disable receipt",
  "disable ticket",
  "hide bill",
  "hide invoice",
  "hide payment",
  "hide purchase",
  "hide receipt",
  "hide ticket",
  "invoice off",
  "no bill",
  "no invoice",
  "no purchase",
  "no receipt",
  "no ticket",
  "purchase off",
  "receipt off",
  "remove bill",
  "remove invoice",
  "remove payment",
  "remove purchase",
  "remove receipt",
  "remove ticket",
  "ticket off",
  "actors",
  "recent activity",
  "recent history",
  "recent items",
  "ehr",
  "electronic health record",
  "emr",
  "meeting point",
  "normalize",
  "recenter",
  "circled thumb up",
  "endorse",
  "endorsement",
  "recommend",
  "suggest",
  "thumb up",
  "thumb up in circle",
  "thumbs",
  "thumbs up",
  "well",
  "audio message",
  "audio note",
  "person speaking",
  "user speaking",
  "voice message",
  "voice note",
  "image area",
  "parallelograms",
  "polygons",
  "quadrilaterals",
  "recangle",
  "arrow loop",
  "ecological",
  "recyclable",
  "waste management",
  "gift card",
  "gift certificate",
  "giftcard",
  "decrease capacity",
  "downsize",
  "fewer people",
  "less people",
  "lower capacity",
  "reduce attendees",
  "reduce capacity",
  "shrink group",
  "smaller group",
  "restart page",
  "update page",
  "algorithms",
  "patterns",
  "regex",
  "regular expression",
  "strings",
  "chillout",
  "de-stress",
  "destress",
  "lax",
  "loosen up",
  "repose",
  "selfcare",
  "serenity",
  "stay loose",
  "stress relief",
  "tranquility",
  "unwind",
  "releases",
  "persistence",
  "remember me",
  "grabbing",
  "prompts",
  "TV",
  "universal remote",
  "substract",
  "action complete",
  "delete done",
  "remove done",
  "dequeue",
  "from",
  "remove from list",
  "remove from queue",
  "waiting list",
  "demote",
  "no protection",
  "remove admin",
  "remove moderator",
  "remove permission",
  "remove role",
  "revoke admin",
  "revoke moderator",
  "revoke permission",
  "revoke role",
  "unmoderator",
  "clear road",
  "delete road",
  "directions delete",
  "directions remove",
  "erase road",
  "highway delete",
  "highway remove",
  "map delete",
  "map remove",
  "navigation delete",
  "navigation remove",
  "path delete",
  "path remove",
  "remove road",
  "road deletion",
  "road removal",
  "route delete",
  "route remove",
  "street delete",
  "street remove",
  "cancel selection",
  "selection border",
  "selection box",
  "selection tool",
  "cancel order",
  "cancel purchase",
  "clear cart",
  "delete from cart",
  "empty cart",
  "remove from cart",
  "change order",
  "item order",
  "list reorder",
  "reallocate",
  "redistribute",
  "repartition",
  "reshuffle",
  "reiterate",
  "repeat all",
  "repeat on",
  "loop one",
  "number 1",
  "repeat one",
  "repeat song",
  "repeat track",
  "replay one",
  "single item",
  "single song",
  "single track",
  "loop single",
  "numeral 1",
  "numeral one",
  "once",
  "repeat single",
  "replay single",
  "restart one",
  "restart single",
  "alternate audio",
  "change audio",
  "exchange audio",
  "refresh audio",
  "replace audio",
  "restart audio",
  "sound clip",
  "substitute audio",
  "swap audio",
  "switch audio",
  "update audio",
  "change orientation",
  "photo rotation",
  "picture rotation",
  "change video",
  "replace video",
  "substitute",
  "substitute video",
  "update video",
  "replay track",
  "start over",
  "try again",
  "u-turn",
  "10 seconds back",
  "back 10 seconds",
  "previous 10 seconds",
  "replay 10 seconds",
  "rewind 10 seconds",
  "replay 30",
  "rewind 30",
  "thirty seconds",
  "5s",
  "back 5 seconds",
  "five seconds back",
  "last 5 seconds",
  "previous 5 seconds",
  "replay 5 seconds",
  "rewind 5 seconds",
  "react",
  "reply all",
  "answer all",
  "distribution list",
  "group message",
  "reply to all",
  "respond all",
  "send all",
  "important message",
  "alert disabled",
  "alert off",
  "cancel report",
  "cancel reporting",
  "disable report",
  "disable reporting",
  "no report",
  "no reporting",
  "no warnings",
  "report off",
  "reporting disabled",
  "reports disabled",
  "reports off",
  "stop reporting",
  "stop reports",
  "turn off reporting",
  "turn off reports",
  "warning disabled",
  "warning off",
  "currency symbol",
  "request page",
  "statement",
  "ask price",
  "estimate",
  "get quote",
  "request pricing",
  "request quote",
  "defaults",
  "refocus",
  "reset camera",
  "reset view",
  "reset zoom",
  "reset image",
  "reset picture",
  "restore default",
  "restore image",
  "revert image",
  "anticlockwise",
  "factory reset",
  "reset settings",
  "revert to default",
  "system restore",
  "factory settings",
  "initial settings",
  "default settings",
  "reset exposure",
  "shutter aperture",
  "display reset",
  "monitor reset",
  "reset tv",
  "screen reset",
  "tv reset",
  "wb",
  "white balance",
  "boundary box",
  "dashes",
  "sizing",
  "pulmonary",
  "respiratory health",
  "respiratory_rate",
  "responsive layout",
  "restart process",
  "eat icon",
  "find food",
  "food service icon",
  "knife and fork",
  "where to eat",
  "get back",
  "put back",
  "recycle bin",
  "reinstate",
  "remove from trash",
  "salvage",
  "undelete",
  "restore page",
  "revert changes",
  "google suite",
  "gsuite",
  "reviews",
  "chalice",
  "earn",
  "incentive",
  "mission",
  "rewarded",
  "ache",
  "osteoarthritis",
  "rheumatic",
  "rheumatism",
  "rheumatoid",
  "rheumatologists",
  "rheumatology",
  "cage",
  "rib",
  "rib_cage",
  "ribs",
  "sternum",
  "thoracic",
  "appetite",
  "serve",
  "staple",
  "open menu",
  "right-click menu",
  "secondary click",
  "minimize panel",
  "hide right panel",
  "show right panel",
  "slide in",
  "slide out",
  "toggle right panel",
  "disturbance",
  "expanding",
  "radial effect",
  "spreading",
  "avenue",
  "boulevard",
  "dashed lines",
  "dotted lines",
  "pavement",
  "road markings",
  "roadway",
  "automation bot",
  "cyborg",
  "droid",
  "science fiction",
  "scifi",
  "square jaw",
  "robot head",
  "astronaut",
  "blastoff",
  "propulsion",
  "rocket",
  "spaceship",
  "pull down",
  "roller blind",
  "roller shade",
  "block light",
  "closed shade",
  "lower shade",
  "window blind",
  "quad skate",
  "quad skates",
  "roller skate",
  "roller skating",
  "rollerskates",
  "building maintenance",
  "roofing",
  "room access",
  "room control",
  "room management",
  "room setup",
  "cloche",
  "in-room dining",
  "room service",
  "90",
  "ccw",
  "ninety degrees",
  "rotate image",
  "rotate left",
  "rotate object",
  "rotate photo",
  "cw",
  "auto a",
  "auto-rotate",
  "device rotation",
  "rotate a",
  "object rotation",
  "left turn",
  "roundabout",
  "roundabout left",
  "turn around",
  "u turn",
  "circular intersection",
  "rotary",
  "roundabout right",
  "traffic circle",
  "bevel",
  "border radius",
  "fillet",
  "rounded edge",
  "soft corner",
  "wan",
  "disable router",
  "router off",
  "consistency",
  "habit",
  "ui theme",
  "oar",
  "rowing",
  "rss feed",
  "syndicate",
  "syndication",
  "web feed",
  "xml",
  "guest list",
  "not going",
  "plaît",
  "respond please",
  "rsvp",
  "répondez",
  "répondez s'il vous plaît",
  "sil",
  "vous",
  "hurry",
  "initial t",
  "latency",
  "real time",
  "round trip time",
  "rrt",
  "rtt",
  "rubric",
  "standards",
  "policies",
  "regulations",
  "validation check",
  "automated rules",
  "manage rules",
  "rule management",
  "rule_settings",
  "workflow settings",
  "jog",
  "errors",
  "interrupted",
  "camper",
  "caravan",
  "hookup",
  "mobile home",
  "pull in",
  "recreational vehicle",
  "rv",
  "trailer",
  "clock shield",
  "protection check",
  "safe time",
  "safety check",
  "safety timer",
  "schedule security",
  "secure schedule",
  "secure time",
  "security check",
  "security timer",
  "time protection",
  "time security",
  "time shield",
  "disable safety",
  "no safety",
  "safety check off",
  "security check off",
  "turn off safety",
  "turn off security",
  "community health",
  "physical distancing",
  "precaution",
  "prevent spread",
  "public health",
  "safety measure",
  "sailboat",
  "social sports",
  "yacht",
  "mineral",
  "purity",
  "saline",
  "salinity",
  "salt",
  "antibacterial",
  "antimicrobial",
  "antiseptic",
  "hand sanitizer",
  "handwash",
  "liquid soap",
  "earth observation",
  "remote sensing",
  "satellite_alt",
  "space station",
  "space technology",
  "diskette",
  "floppy disk",
  "retain",
  "save as",
  "autosave",
  "save time",
  "timestamp",
  "bookmarked",
  "bookmarked search",
  "favorite search",
  "important search",
  "remember search",
  "saved query",
  "saved search",
  "search history",
  "starred search",
  "accumulation",
  "interest",
  "pig",
  "piggy",
  "piggy bank",
  "weighing",
  "file scan",
  "scan file",
  "scan image",
  "scan paper",
  "text recognition",
  "cancel scan",
  "clear scan",
  "close scan",
  "delete document",
  "delete file",
  "delete page",
  "delete scan",
  "document delete",
  "document removal",
  "file delete",
  "file removal",
  "page delete",
  "remove scan",
  "scan removal",
  "circle group",
  "data points",
  "scatter plot",
  "reading light",
  "access time",
  "o'clock",
  "delayed message",
  "event reminder",
  "paper airplane",
  "post later",
  "schedule message",
  "schedule post",
  "send later",
  "timed message",
  "timed post",
  "graduate",
  "graduation",
  "mortarboard",
  "beaker disabled",
  "beaker off",
  "blocked science",
  "cancel science",
  "chemistry off",
  "deactivate science",
  "disable science",
  "experiment off",
  "flask disabled",
  "flask off",
  "forbidden science",
  "lab off",
  "laboratory off",
  "no beaker",
  "no chemistry",
  "no experiment",
  "no flask",
  "no research",
  "no science",
  "research off",
  "science disabled",
  "science inactive",
  "science_off",
  "micro scooter",
  "push scooter",
  "short distance",
  "2k image",
  "2k video",
  "two k",
  "colon",
  "flipboard",
  "lose",
  "scoreboard",
  "mobile lock",
  "screen orientation",
  "device security",
  "lock portrait",
  "lock symbol",
  "mobile device security",
  "padlock symbol",
  "phone portrait",
  "privacy settings",
  "screen security",
  "screenlock",
  "smartphone security",
  "autorotation",
  "disable rotation",
  "fixed orientation",
  "immobile",
  "locked rotation",
  "orientation lock",
  "prevent rotation",
  "rotation lock",
  "abstract circle",
  "capture screen",
  "livestream",
  "rec",
  "screen record",
  "screen recording",
  "screencapture",
  "start rec",
  "stop rec",
  "mobile setting",
  "screen orientation lock",
  "screen rotation lock",
  "display rotation",
  "rotate screen",
  "rotation control",
  "screen_rotation_alt",
  "change display",
  "computer search",
  "desktop search",
  "explore screen",
  "find in desktop",
  "find in screen",
  "inspect screen",
  "magnifying glass on screen",
  "screen search",
  "search computer",
  "search desktop",
  "search screen",
  "screen_share",
  "snipping tool",
  "print screen",
  "screenshot frame 2",
  "clipping",
  "desktop capture",
  "prtscn",
  "record screen",
  "screen grab",
  "screenshot keyboard",
  "computer screen",
  "display capture",
  "partial screenshot",
  "screenshot region",
  "select region",
  "device screenshot",
  "mobile screenshot",
  "screen image",
  "tablet screenshot",
  "ui capture",
  "hand-drawn",
  "scrollable",
  "scrollbar",
  "diver",
  "scuba",
  "scuba diving",
  "underwater",
  "flash memory",
  "portable storage",
  "sd card",
  "secure digital",
  "digital storage",
  "micro sd",
  "removable storage",
  "sd storage",
  "corner cut",
  "error sign",
  "memory alert",
  "memory error",
  "memory problem",
  "memory warning",
  "notification sign",
  "sd card alert",
  "sd card error",
  "sd card issue",
  "sd card notification",
  "sd card problem",
  "sd card warning",
  "sim card alert",
  "sim card error",
  "sim card issue",
  "sim card notification",
  "sim card problem",
  "sim card warning",
  "storage alert",
  "storage error",
  "storage problem",
  "storage warning",
  "warning sign",
  "websites",
  "broad",
  "comprehensive",
  "entire",
  "everywhere",
  "overall",
  "search_activity",
  "magnifying glass with check",
  "search complete",
  "search successful",
  "search with check",
  "magnifyingglass",
  "search_check",
  "hands-free",
  "in-car",
  "steering",
  "steering wheel",
  "voice activated",
  "bar chart search",
  "chart analysis",
  "data analysis tools",
  "data discovery",
  "dataform",
  "magnifying glass graph",
  "market research",
  "search analytics",
  "search_insights",
  "cancel search",
  "clear search",
  "deactivate search",
  "disable search",
  "hide search",
  "magnifier disabled",
  "magnifier off",
  "magnifying glass disabled",
  "magnifying glass off",
  "no search",
  "remove search",
  "search deactivated",
  "search_off",
  "climate control seat",
  "cooled seat",
  "heated seat",
  "seat warmer",
  "car seat",
  "passenger seat",
  "fan blades",
  "seat ventilation",
  "antivirus",
  "armor",
  "threat protection",
  "2-step",
  "2fa",
  "digital security",
  "fob",
  "hardware key",
  "ldap",
  "reauth",
  "security key",
  "thumb drive",
  "two-factor authentication",
  "u2f",
  "webauthn",
  "yubi",
  "yubi key",
  "mobile friendly",
  "mobile update",
  "passed",
  "mobile alert",
  "security warning",
  "choosing",
  "marking",
  "multiple selection",
  "selector",
  "ticking",
  "check box",
  "select box",
  "select to speak",
  "activate window",
  "arrange windows",
  "change window",
  "choose window",
  "dual windows",
  "focus window",
  "highlight window",
  "manage windows",
  "multiple windows",
  "organize windows",
  "overlapping windows",
  "pick window",
  "program window",
  "select window",
  "software window",
  "stacked squares",
  "stacked windows",
  "switch window",
  "webpages",
  "active window",
  "alt+tab",
  "application windows",
  "cascading windows",
  "command+tab",
  "select application",
  "task switching",
  "ui window",
  "window navigation",
  "window selection",
  "no selection",
  "no windows",
  "barbershop",
  "chi",
  "hairstyle",
  "pampering",
  "reflection",
  "salon",
  "self_care",
  "legs crossed",
  "lotus position",
  "meditate",
  "self care",
  "self improvement",
  "zen",
  "bargain",
  "price tag",
  "message icon",
  "send icon",
  "share icon",
  "inbox zero",
  "send and archive",
  "digital payment",
  "double arc",
  "electronic transfer",
  "funds transfer",
  "remit",
  "remittance",
  "send money",
  "extend deadline",
  "fitting",
  "reschedule",
  "send document",
  "send file",
  "open in",
  "open on",
  "porting",
  "push notification",
  "security system",
  "area occupied",
  "body response",
  "detected",
  "occupancy sensor",
  "person detected",
  "presence sensor",
  "room occupied",
  "sensors",
  "smart body scan sensor",
  "space occupied",
  "user present",
  "closed window",
  "double pane",
  "smart window",
  "window sensor",
  "receiving",
  "krx",
  "no connections",
  "no signals",
  "sensor off",
  "sensors off",
  "activate sensors",
  "deactivate sensors",
  "disable sensors",
  "enable sensors",
  "no sensors",
  "parenthesis",
  "toggle sensors",
  "at peace",
  "closed eyes",
  "dreamy",
  "peaceful",
  "relaxed",
  "serene",
  "smile face",
  "tranquil",
  "apathy",
  "facial expression",
  "indifferent",
  "passive",
  "satisfy",
  "uninterested",
  "angry",
  "disappointed",
  "dissatisfied",
  "frowning face",
  "poor",
  "sad face",
  "sentiment analysis",
  "unsatisfied",
  "user feedback",
  "amused",
  "delighted",
  "ecstatic",
  "entertained",
  "excite",
  "excited",
  "glee",
  "good vibes",
  "grin",
  "grinning",
  "laughing",
  "overjoyed",
  "passionate",
  "pleasure",
  "thrilled",
  "awful",
  "extremely",
  "extremely dissatisfied",
  "eyebrows",
  "frustration",
  "furious",
  "hate",
  "mad",
  "rage",
  "terrible",
  "very angry",
  "worst",
  "anxious",
  "concerned",
  "frustrated",
  "stressed",
  "troubled",
  "worried",
  "indifference",
  "meh",
  "no expression",
  "poker face",
  "straight face",
  "cry",
  "sentiment_sad",
  "sorrow",
  "satisfaction",
  "sentiment satisfied",
  "sentiment_satisfied",
  "sentiment_satisfied_alt",
  "anxiety",
  "burden",
  "concern",
  "distressed",
  "emotional state",
  "overwhelmed",
  "stress",
  "tense",
  "tension",
  "worry",
  "very",
  "very dissatisfied",
  "amazing",
  "excellent",
  "five stars",
  "great",
  "perfect",
  "smiling face",
  "top rating",
  "very satisfied",
  "wonderful",
  "apprehensive",
  "fear",
  "grimace",
  "nervous",
  "uneasy",
  "traditional",
  "network administration",
  "server administration",
  "server management",
  "server settings",
  "sole tenancy",
  "sole tenant",
  "user administration",
  "instruments",
  "combo meal",
  "fish dish",
  "meal deal",
  "menu icon",
  "seafood",
  "set meal",
  "teishoku",
  "accessibility settings",
  "cognitive impairment",
  "hearing impairment",
  "motor impairment",
  "visual impairment",
  "person settings",
  "settings alert",
  "settings warning",
  "modifications",
  "program settings",
  "settings b roll",
  "settings export",
  "settings migration",
  "settings transfer",
  "settings bluetooth",
  "brightness settings",
  "setting_brightness",
  "mobile options",
  "phone menu",
  "blur settings",
  "cinematic mode",
  "dof",
  "film mode",
  "video mode",
  "cables",
  "composite",
  "inputs",
  "three sliders",
  "audio video",
  "audiovisual",
  "four pin",
  "s-video",
  "svideo",
  "video input",
  "activity tracking",
  "motion settings",
  "movement detection",
  "overscan",
  "three sixty",
  "vrpano",
  "call settings",
  "communication settings",
  "contact settings",
  "handset settings",
  "phone options",
  "telephone settings",
  "camera options",
  "photo options",
  "power options",
  "settings menu",
  "decrease speed",
  "reduce speed",
  "settings cog",
  "settings gear",
  "snail",
  "turtle",
  "imagination",
  "fast forward settings",
  "settings timelapse",
  "time-lapse settings",
  "timelapse",
  "camera configuration",
  "camera controls",
  "camera preferences",
  "video configuration",
  "video preferences",
  "video recording settings",
  "webcam settings",
  "microphone settings",
  "voice settings",
  "cable box",
  "digital receiver",
  "settop",
  "tv box",
  "extreme cold",
  "ice storm",
  "severe",
  "severe weather",
  "weather alert",
  "winter storm",
  "behind",
  "add layer",
  "clip art",
  "branched lines",
  "contect",
  "three dots connected",
  "delivery time",
  "send eta",
  "send time",
  "share arrival time",
  "share eta",
  "share time",
  "send location",
  "share coordinates",
  "share place",
  "share position",
  "block share",
  "cancel share",
  "cross share",
  "disable share",
  "disconnect share",
  "distribute off",
  "forbidden share",
  "link off",
  "remove share",
  "restrict share",
  "share disabled",
  "sharing disabled",
  "sharing prohibited",
  "slashed share",
  "social media off",
  "social share off",
  "x share",
  "customer review",
  "post review",
  "referral",
  "review sharing",
  "share feedback",
  "share reviews",
  "submit review",
  "user review",
  "word of mouth",
  "auto-hide",
  "autohide",
  "bookcase",
  "infographic grid",
  "shelf position",
  "containers",
  "stacked boxes",
  "two shelves",
  "malware protection",
  "lock security",
  "security lock",
  "shield lock",
  "moon icon",
  "night shield",
  "protection mode",
  "person in shield",
  "shield person",
  "shield user",
  "user protection",
  "user safety",
  "user shield",
  "secure help",
  "security information",
  "security question",
  "shield question",
  "active protection",
  "around the clock",
  "constant protection",
  "personal safety",
  "real-time protection",
  "smartwatch security",
  "time management security",
  "watch icon",
  "watch protection",
  "wearable security",
  "heart in shield",
  "shield with heart",
  "house inside shield",
  "safe house",
  "shield with house",
  "composing",
  "shift key",
  "small letters",
  "digital shop",
  "online store",
  "web store",
  "product video",
  "shop 2",
  "shop two",
  "add to bag",
  "consumer",
  "shopping_bag",
  "next day",
  "quick buy",
  "same day",
  "retail store",
  "shopping_basket",
  "local grocery",
  "push cart",
  "shopping list",
  "complete order",
  "confirm order",
  "finalize order",
  "go to checkout",
  "proceed to checkout",
  "cart disabled",
  "cart off",
  "cart unavailable",
  "disable cart",
  "no cart",
  "no orders",
  "no purchases",
  "no shopping",
  "shopping cart off",
  "shopping cart unavailable",
  "shopping disabled",
  "shopping off",
  "shopping mode",
  "shoppingmode",
  "brief",
  "few days",
  "short term",
  "staycation",
  "short_text",
  "fluctuation",
  "show chart",
  "bathroom fixture",
  "rinse",
  "showerhead",
  "crisscross",
  "disarray",
  "disorganized",
  "intersecting arrows",
  "jumble",
  "randomize",
  "scramble",
  "chaos",
  "crisscross arrows",
  "crossed arrows",
  "randomized",
  "shuffle mode",
  "shuffle on",
  "shuffle play",
  "diaphragm",
  "quick settings",
  "shutter speed",
  "slower",
  "fever",
  "ill",
  "unhealthy",
  "unwell",
  "content navigation",
  "off-canvas",
  "page navigation",
  "section navigation",
  "side menu",
  "side navigation",
  "view navigation",
  "asl",
  "communication aid",
  "hand symbol",
  "interpreting",
  "linguistic",
  "non verbal",
  "sign language",
  "translated",
  "lost signal",
  "no bars",
  "zero bars",
  "cell signal",
  "increasing",
  "cell service",
  "carrier",
  "provider",
  "strengthen",
  "full bars",
  "increasing bars",
  "signal indicator",
  "gsm",
  "empty bars",
  "4 bar",
  "cellularnodata",
  "nodata",
  "antenna off",
  "no antenna",
  "no wireless",
  "held",
  "suspended",
  "connection lost",
  "internet disconnected",
  "network offline",
  "no broadcast",
  "wifi disconnected",
  "wireless disconnected",
  "excellent connection",
  "strong connection",
  "bad signal",
  "statusbar",
  "wifi error",
  "wifi problem",
  "empty signal",
  "autograph",
  "cancel signature",
  "clear signature",
  "cursive",
  "delete signature",
  "john hancock",
  "remove signature",
  "signatory",
  "signing",
  "signpost",
  "cut corner",
  "identity module",
  "simcard",
  "subscriber",
  "sim card alt",
  "sim card download",
  "virtual world",
  "double bed (as a potential search term from users unsure of bed sizes)",
  "one person",
  "single bed",
  "real-time communication",
  "rtc",
  "ambulance siren",
  "emergency vehicle",
  "police siren",
  "warning signal",
  "siren_check",
  "alarm status",
  "emergency question",
  "find out",
  "extreme",
  "grind",
  "ollie",
  "skateboard",
  "skateboarder",
  "skateboarding",
  "skateboarding icon",
  "skater",
  "sports icon",
  "halloween",
  "halloween costume",
  "human skeleton",
  "monster",
  "rib cage",
  "spinal column",
  "spooky",
  "cooking pan",
  "fry",
  "fry pan",
  "frying",
  "saucepan",
  "skillet",
  "steaming",
  "frying pan",
  "saute",
  "jump ahead",
  "next button",
  "skip button",
  "skip next",
  "skip track",
  "previous song",
  "previous video",
  "skip_previous",
  "cranium",
  "evil",
  "gothic",
  "graveyard",
  "grim reaper",
  "piracy",
  "poison",
  "scary",
  "skull",
  "toxic",
  "blacklist",
  "dark web",
  "mortality",
  "subject",
  "character style",
  "slab serif",
  "luge",
  "sled",
  "sledding",
  "sledge",
  "toboggan",
  "sleep analysis",
  "sleep data",
  "sleep health",
  "sleep quality",
  "sleep score",
  "sleep time",
  "sleep tracking",
  "stat",
  "tracking progress",
  "creating",
  "designing",
  "presentations",
  "image viewer",
  "photo viewer",
  "gaps",
  "play triangle",
  "card reader",
  "chip card",
  "pc/sc",
  "rfid",
  "smart card",
  "smart card reader",
  "swipe card",
  "tap card",
  "no card reader",
  "no smart card",
  "power socket",
  "receptacle",
  "smart outlet",
  "wall outlet",
  "smart menu",
  "smart screen",
  "smart settings",
  "smart toy",
  "front-facing camera",
  "stay current",
  "mobile camera app",
  "mobile photography",
  "smartphone camera app",
  "smartphone photography",
  "cloud share",
  "cloud sharing",
  "network share",
  "network sharing",
  "server message block",
  "smb",
  "windows share",
  "anti smoking",
  "cigarette",
  "cigarette ban",
  "dont smoke",
  "never",
  "nicotine free",
  "no cigarettes",
  "no smoke",
  "no smoking",
  "no tobacco",
  "non smoking",
  "smoke free",
  "smoking",
  "smoking prohibited",
  "stop smoking",
  "tobacco",
  "tobacco free",
  "addiction",
  "ashtray",
  "cigar",
  "cigarette break",
  "designated smoking area",
  "nicotine",
  "permitted smoking",
  "smoking allowed",
  "smoking area",
  "smoking lounge",
  "smoking room",
  "vape",
  "vaping",
  "text message",
  "folder within folder",
  "inner folder",
  "nested folder",
  "subfolder",
  "remind",
  "flakes",
  "season",
  "flurry",
  "heavy snow",
  "powder",
  "slush",
  "snow shower",
  "snowfall",
  "snowstorm",
  "whiteout",
  "motorized sled",
  "skimobile",
  "snow machine",
  "snow travel",
  "snowmobile",
  "cold weather",
  "snow gear",
  "snow trail",
  "snowshoe",
  "winter gear",
  "winter sport",
  "winter trail",
  "hand care",
  "hand hygiene",
  "lather",
  "2 meters",
  "keep apart",
  "keep distance",
  "two users",
  "medallion",
  "medals",
  "photovoltaic",
  "solar energy",
  "solar panel",
  "solar power",
  "alphabetical",
  "numerical",
  "a-z",
  "alphabetically",
  "alphabetize",
  "az",
  "by alpha",
  "sequencing",
  "bold text",
  "distress",
  "morse code",
  "save our souls",
  "animal noise",
  "bark",
  "barking",
  "canine",
  "dog sound",
  "hound",
  "noise detection",
  "pet sound",
  "sound recognition",
  "woof",
  "shatter",
  "high volume",
  "sound detection",
  "sampler",
  "sound player",
  "helping",
  "ladle",
  "soup",
  "soup kitchen",
  "volunteering",
  "bottom arrow",
  "south arrow",
  "central america",
  "south america",
  "south american continent",
  "southern hemisphere",
  "arrow down right",
  "arrow point down right",
  "south east",
  "south east arrow",
  "southeast arrow",
  "bottom-left",
  "lower left",
  "southwest",
  "aromatherapy",
  "lotus",
  "massage",
  "stylized flower",
  "space bar",
  "whitespace",
  "multi-tasking",
  "space management",
  "360 audio",
  "360 sound",
  "3d audio",
  "3d sound",
  "dolby atmos",
  "dts:x",
  "headphone settings",
  "immersive audio",
  "immersive sound",
  "person audio",
  "sound propagation",
  "spatial audio",
  "spatial sound",
  "speaker settings",
  "surround sound",
  "user audio",
  "3d audio off",
  "immersive audio off",
  "spatial sound off",
  "surround sound off",
  "apple spatial audio",
  "audio signal",
  "multichannel",
  "sound output",
  "speaker output",
  "find user",
  "locate user",
  "person position",
  "person tracking",
  "spatial_tracking",
  "track user",
  "user position",
  "audio icon",
  "music icon",
  "sound icon",
  "speaker icon",
  "volume icon",
  "audio system",
  "multiple speakers",
  "pa system",
  "speaker group",
  "speakers",
  "speaker notes",
  "blog off",
  "chat off",
  "comment off",
  "dialogue off",
  "messages off",
  "no speech",
  "notes off",
  "speakers off",
  "speech off",
  "closed loop",
  "greek alphabet",
  "ohms",
  "omega",
  "open loop",
  "resistance",
  "u-shaped",
  "ultimate",
  "hydrometer",
  "mass",
  "relative density",
  "specific gravity",
  "substance",
  "audio to text",
  "voice recognition",
  "speedometer needle",
  "0.25",
  "0.25x",
  "audio speed",
  "quarter speed",
  "speed control",
  "tortoise",
  "0.2x",
  "half speed",
  "multiplier",
  "point two",
  ".5",
  "0.5",
  "playback rate",
  "point five",
  "speed adjustment",
  ".5x",
  "0.5x",
  "slow playback",
  "0.75",
  "point seventy-five",
  "0.7x",
  "70%",
  "1.2",
  "one and two tenths",
  "one point two",
  "speed indicator",
  "speed setting",
  "1.25",
  "1.25x",
  "125%",
  "audio playback speed",
  "one and a quarter speed",
  "one point two five",
  "time control",
  "video playback speed",
  "1.2x",
  "1.5",
  "1.5x",
  "decelerate",
  "one and a half",
  "one point five",
  "150%",
  "one and one half",
  "one hundred fifty percent",
  "1.75",
  "175",
  "one point seventy-five",
  "1.7",
  "1.7x",
  "170%",
  "one point seven",
  "rate control",
  "2x",
  "double speed",
  "quick motion",
  "twice",
  "two times",
  "l-shape",
  "speed limit",
  "speed_camera",
  "speed_control",
  "speed_limit",
  "speeding",
  "grammar",
  "spell",
  "spell checker",
  "spellcheck",
  "spelling",
  "side-by-side",
  "split scene",
  "vertical split",
  "drag down",
  "dual pane",
  "content split",
  "dual view",
  "interface division",
  "left split",
  "right panel open",
  "split screen view",
  "bundle",
  "customizable",
  "design asset",
  "digital product",
  "effective",
  "iconography",
  "information design",
  "intuitive",
  "meaning",
  "personal use",
  "product design",
  "scalable",
  "semiotics",
  "stylish",
  "symbolism",
  "ui design",
  "usable",
  "user experience",
  "user interface design",
  "user interface element",
  "ux design",
  "visual analysis",
  "visual arts",
  "visual aspects",
  "visual attention",
  "visual attributes",
  "visual branding",
  "visual characteristics",
  "visual cognition",
  "visual communication",
  "visual communication design",
  "visual communication theory",
  "visual components",
  "visual content",
  "visual culture",
  "visual design",
  "visual design accessibility",
  "visual design agency",
  "visual design best practices",
  "visual design blog",
  "visual design book",
  "visual design career",
  "visual design career path",
  "visual design certification",
  "visual design collaboration",
  "visual design communication",
  "visual design community",
  "visual design conference",
  "visual design consultant",
  "visual design course",
  "visual design deliverables",
  "visual design director",
  "visual design documentation",
  "visual design education",
  "visual design elements",
  "visual design ethics",
  "visual design feedback",
  "visual design for social activism",
  "visual design for social advocacy",
  "visual design for social betterment",
  "visual design for social change",
  "visual design for social cohesion",
  "visual design for social connection",
  "visual design for social development",
  "visual design for social engagement",
  "visual design for social entrepreneurship",
  "visual design for social equality",
  "visual design for social equity",
  "visual design for social good",
  "visual design for social harmony",
  "visual design for social impact",
  "visual design for social inclusion",
  "visual design for social innovation",
  "visual design for social integration",
  "visual design for social interaction",
  "visual design for social justice",
  "visual design for social mobility",
  "visual design for social participation",
  "visual design for social progress",
  "visual design for social responsibility",
  "visual design for social transformation",
  "visual design for social welfare",
  "visual design for social well-being",
  "visual design freelancer",
  "visual design future",
  "visual design guidelines",
  "visual design inclusivity",
  "visual design industry",
  "visual design innovation",
  "visual design inspiration",
  "visual design iteration",
  "visual design job market",
  "visual design lead",
  "visual design leadership",
  "visual design management",
  "visual design manager",
  "visual design methodology",
  "visual design optimization",
  "visual design patterns",
  "visual design planning",
  "visual design portfolio",
  "visual design portfolio development",
  "visual design presentation",
  "visual design principles",
  "visual design principles and elements",
  "visual design process",
  "visual design quality assurance",
  "visual design refinement",
  "visual design research",
  "visual design resources",
  "visual design review",
  "visual design software",
  "visual design specifications",
  "visual design standards",
  "visual design strategy",
  "visual design studio",
  "visual design sustainability",
  "visual design systems",
  "visual design team",
  "visual design testing",
  "visual design tools",
  "visual design training",
  "visual design trends",
  "visual design trends and technologies",
  "visual design workflow",
  "visual design workshop",
  "visual details",
  "visual elements",
  "visual features",
  "visual identity",
  "visual identity design",
  "visual information",
  "visual interpretation",
  "visual language",
  "visual learning",
  "visual literacy",
  "visual marketing",
  "visual memory",
  "visual message",
  "visual neuroscience",
  "visual perception",
  "visual perception research",
  "visual problem solving",
  "visual properties",
  "visual psychology",
  "visual qualities",
  "visual representation",
  "visual rhetoric",
  "visual search",
  "visual semiotics",
  "visual storytelling",
  "visual style",
  "visual synthesis",
  "visual thinking",
  "visual thinking tools",
  "double window",
  "splitview",
  "view split",
  "add pane",
  "add panel",
  "multiple panes",
  "new pane",
  "new panel",
  "bottom split",
  "double panel",
  "layered panels",
  "split bottom",
  "stacked panels",
  "stacked view",
  "screen divide",
  "screen split",
  "split layout",
  "two panes",
  "parallel view",
  "dual window",
  "multi panel",
  "right split",
  "divide screen",
  "horizontal divide",
  "lower panel",
  "split top",
  "split window",
  "top split",
  "upper panel",
  "window pane",
  "window split",
  "add split",
  "new split",
  "blood oxygenation",
  "o2",
  "oximeter",
  "oxygen saturation",
  "radius",
  "rim",
  "spoke",
  "tire",
  "referee",
  "whistle",
  "and outdoors",
  "football",
  "kick",
  "league",
  "soccer",
  "ale",
  "bubbly",
  "foam",
  "froth",
  "game day",
  "lager",
  "pint",
  "sports bar",
  "stein",
  "stout",
  "tankard",
  "tavern",
  "watch party",
  "baseball",
  "baseball icon",
  "leather",
  "major league",
  "mlb",
  "pastime",
  "seam",
  "sports equipment",
  "stitches",
  "basketball",
  "bball",
  "hoops",
  "nba",
  "australia",
  "bat",
  "championship",
  "cricket",
  "hit",
  "innings",
  "pakistan",
  "stumps",
  "wicket",
  "esports",
  "play games",
  "sports esports",
  "stadia",
  "video gaming",
  "xbox",
  "american football",
  "field goal",
  "gridiron",
  "laces",
  "nfl",
  "pigskin",
  "quarterback",
  "running back",
  "stadium",
  "super bowl",
  "fairway",
  "putter",
  "sports golf",
  "flexibility",
  "gymnastics",
  "leg split",
  "martial arts",
  "side kick",
  "splits",
  "catch",
  "catching",
  "handball",
  "jumping",
  "throwing",
  "crossed sticks",
  "hockey sticks",
  "ice hockey",
  "nhl",
  "puck",
  "anti",
  "athletes",
  "combat",
  "contact sport",
  "fighting",
  "indian sport",
  "kabaddi",
  "offence",
  "players",
  "raid",
  "raider",
  "sport icon",
  "struggle",
  "tackle",
  "tackling",
  "team sport",
  "wrestle",
  "wrestling",
  "arts",
  "fighter",
  "judo",
  "karate",
  "kickboxing",
  "kung fu",
  "martial",
  "self defense",
  "taekwondo",
  "boxing",
  "boxing glove",
  "fight",
  "fist",
  "glove",
  "mixed martial arts",
  "mma",
  "sparring",
  "ufc",
  "ultimate fighting championship",
  "f1",
  "formula one",
  "indycar",
  "motogp",
  "motorsports",
  "nascar",
  "racing helmet",
  "superbike",
  "rugby",
  "rugby ball",
  "rugby football",
  "auto racing",
  "car racing",
  "checkered flag",
  "finish line",
  "penalty",
  "pitch",
  "world cup",
  "Australian Open",
  "French Open",
  "US Open",
  "Wimbledon",
  "grand slam",
  "racket",
  "racquet",
  "sport equipment",
  "tennis",
  "tennis ball",
  "sports_volleyball",
  "volley",
  "volleyball",
  "irrigation",
  "t-shaped",
  "water feature",
  "geometric shape",
  "quadrangle",
  "sides",
  "centered dot",
  "circle in square",
  "dot in square",
  "full stop",
  "lacto",
  "lacto-vegetarian",
  "square dot",
  "hypotenuse",
  "inches",
  "set square",
  "square foot",
  "square footage",
  "ssid",
  "pile",
  "no stacking",
  "badges",
  "stack_star",
  "chart-chart",
  "stacked bar chart",
  "filing",
  "trays",
  "stacked chart",
  "stacked line chart",
  "moma search",
  "stack of diamonds",
  "stack of squares",
  "stacks",
  "teamgraph",
  "controller icon",
  "gamepad icon",
  "gamer",
  "gaming controller",
  "joystick icon",
  "stadia controller",
  "start game",
  "video game controller",
  "amphitheater",
  "arena",
  "coliseum",
  "pennants",
  "multilevel",
  "stairway",
  "stairwell",
  "next level",
  "three steps",
  "empty star",
  "favorite news",
  "five-pointed star",
  "toggle favorite",
  "unfilled star",
  "2.5 stars",
  "adequate",
  "decent",
  "fifty percent",
  "half star",
  "rating rank",
  "satisfactory",
  "so-so",
  "two and a half stars",
  "5 star",
  "customer rating",
  "feedback rating",
  "partially filled",
  "star outline",
  "user rating",
  "brilliant",
  "excellence",
  "gleam",
  "shiny",
  "sparkle lines",
  "achievements",
  "double star",
  "two stars",
  "45 degree rotation",
  "stat 0",
  "stat_0",
  "1 arrow",
  "doward",
  "three chevrons",
  "three down arrows",
  "rectangle with rounded corners",
  "heat control",
  "heated steering wheel",
  "heater",
  "steering wheel warmer",
  "phase",
  "code stepping",
  "debugger",
  "step into",
  "step out",
  "step over",
  "step through",
  "linear progress",
  "stepper",
  "wizard",
  "pedometer",
  "sneakers",
  "auscultation",
  "physical",
  "practitioner",
  "stethoscope",
  "poa",
  "stethoscope arrow",
  "health check",
  "stethoscope check",
  "notepaper",
  "asset management",
  "content library",
  "media browser",
  "media manager",
  "stock audio",
  "stock images",
  "stock media",
  "stock music",
  "stock photos",
  "covered",
  "hot food",
  "stew",
  "discontinue",
  "filled square",
  "stop sign",
  "brick and mortar",
  "storefront icon",
  "twister",
  "direct",
  "straight up",
  "equalize",
  "neat",
  "straighten",
  "symmetrical",
  "app streaming",
  "chat app",
  "message app",
  "mobile chat",
  "mobile streaming",
  "online chat",
  "phone app",
  "streaming app",
  "street view",
  "streetview",
  "virtual tour",
  "emotional",
  "psychological",
  "stress management",
  "strikeout",
  "hatch",
  "shading",
  "block stroke",
  "cancel stroke",
  "delete stroke",
  "disable stroke",
  "end stroke",
  "hide stroke",
  "partial stroke",
  "remove stroke",
  "stop stroke",
  "fatherhood",
  "boutique",
  "fashion design",
  "hairdresser",
  "styler",
  "digital pen",
  "tablet pen",
  "calligraphy",
  "digital ink",
  "digital painting",
  "fountain pen",
  "nib",
  "chisel tip",
  "electronic pen",
  "slanted tip",
  "touchscreen pen",
  "electronic signature",
  "laser pointer",
  "annotation tool",
  "creative tool",
  "note-taking",
  "sketching tool",
  "enter directory",
  "enter folder",
  "exit directory",
  "exit folder",
  "parent directory",
  "parent folder",
  "previous directory",
  "previous folder",
  "sub",
  "subdirectory",
  "up one level",
  "angle arrow",
  "file system",
  "inline arrow",
  "subheader",
  "exponent",
  "scientific notation",
  "squared",
  "subscript",
  "x2",
  "films",
  "playlists",
  "shows",
  "subscribed",
  "subscriptions",
  "live caption",
  "caption settings",
  "captions configuration",
  "subtitle settings",
  "subtitles configuration",
  "text settings",
  "captions off",
  "closed captions off",
  "no text",
  "subtitles off",
  "text off",
  "underground station",
  "abridge",
  "recap",
  "summarize",
  "eight lines",
  "changing weather",
  "daytime snow",
  "sun and snow",
  "unusual weather",
  "winter sun",
  "power of two",
  "raise to the power",
  "second power",
  "superscript",
  "x squared",
  "x to the power of two",
  "restrictions",
  "supervised user",
  "block supervision",
  "cancel supervision",
  "child lock off",
  "circle cross",
  "disable supervision",
  "monitoring off",
  "no supervision",
  "parental control off",
  "remove supervision",
  "restricted user",
  "stop supervision",
  "supervised user circle off",
  "supervised user disabled",
  "supervised user inactive",
  "supervision disabled",
  "supervision off",
  "unsupervised",
  "unsupervised user",
  "user disable",
  "user restricted",
  "user supervision off",
  "user unsupervised",
  "assistance icon",
  "buoy",
  "emergency icon",
  "life preserver",
  "life ring",
  "life ring icon",
  "lifebuoy",
  "lifesaver",
  "solutions",
  "support icon",
  "technical support",
  "call center",
  "customer support agent",
  "online support",
  "representative",
  "service desk",
  "coastline",
  "surfboard",
  "surfer",
  "surfing icon",
  "water activity",
  "watersport",
  "wave riding",
  "incision",
  "scalpel",
  "surgeon",
  "surgical",
  "atmos",
  "dolby",
  "surround system",
  "volumn",
  "call change",
  "call flip",
  "call swap",
  "call switch",
  "change call",
  "flip call",
  "redirect call",
  "swap calls",
  "switch calls",
  "transfer call",
  "car navigation",
  "change apps",
  "change navigation",
  "driving directions",
  "swap routes",
  "switch apps",
  "toggle apps",
  "swap horizontal",
  "import export",
  "swap vertical",
  "vertical arrows",
  "one finger",
  "pull to refresh",
  "swpie",
  "circle arrow down",
  "left swipe",
  "slide left",
  "swipe left gesture",
  "finger swipe",
  "right swipe",
  "touch screen",
  "swipe_right_alt",
  "swipe up",
  "drag up",
  "vertical drag",
  "vertical navigation",
  "vertical scroll",
  "vertical swipe",
  "verticle",
  "concentric squares",
  "settings control",
  "toggle switch",
  "alternative input",
  "switch access",
  "device switching",
  "accessibility shortcut",
  "switch control",
  "alternate account",
  "change account",
  "change user",
  "choose account",
  "multiple accounts",
  "profile management",
  "select account",
  "swap user",
  "switch account",
  "switch profile",
  "switch user",
  "toggle account",
  "camera outline",
  "invert camera",
  "reverse camera",
  "swap camera",
  "switch left",
  "toggle left",
  "change right",
  "switch right",
  "toggle right",
  "transfer right",
  "camera direction",
  "camera input",
  "switch input",
  "toggle video",
  "video device",
  "video switch",
  "battle",
  "beast",
  "chivalry",
  "dagger",
  "duel",
  "rose",
  "rpg",
  "sword",
  "young adult",
  "blades crossed",
  "crossed swords",
  "fencing",
  "knight",
  "player versus player",
  "pvp",
  "swords",
  "two swords",
  "viking",
  "conjunctivitis",
  "crying",
  "crying eye",
  "dryness",
  "eye infection",
  "eye irritation",
  "eye problem",
  "pink eye",
  "symptoms",
  "tears",
  "watery eye",
  "weep",
  "high holidays",
  "house of worship",
  "israel",
  "jew",
  "jewish",
  "judaism",
  "rosh hashanah",
  "shabbat",
  "shul",
  "star of david",
  "synagogue",
  "torah",
  "yom kippur",
  "cloud sync",
  "file synchronization",
  "refresh icon",
  "reload icon",
  "sync icon",
  "update icon",
  "alternative sync",
  "correspond",
  "cyclical",
  "information exchange",
  "sync alt",
  "sync down",
  "cancel sync",
  "cloud sync disabled",
  "data synchronization disabled",
  "disable synchronization",
  "not syncing",
  "pause sync",
  "refresh disabled",
  "stop sync",
  "syncing off",
  "unsynchronized",
  "locked refresh",
  "locked update",
  "refresh lock",
  "restricted sync",
  "restricted update",
  "secure sync",
  "secure update",
  "sync lock",
  "sync security",
  "update security",
  "out of sync",
  "refresh error",
  "refresh issue",
  "refresh problem",
  "sync issue",
  "sync problem",
  "synchronization error",
  "synchronization issue",
  "syncing error",
  "syncing issue",
  "update error",
  "update issue",
  "update problem",
  "flu shot",
  "health care",
  "hypodermic",
  "inoculation",
  "jab",
  "vaccines",
  "download app",
  "install app",
  "mobile download",
  "security update",
  "application install",
  "firmware update",
  "install icon",
  "os update",
  "software install",
  "system refresh",
  "close tab",
  "multiple tabs",
  "remove panel",
  "stacked tabs",
  "close right",
  "close right tabs",
  "close tabs",
  "delete tab",
  "delete tabs",
  "dismiss tab",
  "dismiss tabs",
  "remove tab",
  "remove tabs",
  "tabs right",
  "browser tabs",
  "layered windows",
  "switching",
  "tab group",
  "web pages",
  "tab inactive",
  "duplicate tab",
  "forward tab",
  "move tab",
  "next tab",
  "open new",
  "browser history",
  "last viewed",
  "open recent",
  "previously viewed",
  "recent documents",
  "recent files",
  "recent tabs",
  "restore tab",
  "search tab",
  "tab search",
  "bar table",
  "bistro",
  "bistro table",
  "cafe table",
  "high top",
  "high top table",
  "pub table",
  "restaurant table",
  "round table",
  "table bar",
  "column chart",
  "table chart",
  "chart view",
  "data view",
  "restructure",
  "data edit",
  "edit table",
  "grid edit",
  "modify table",
  "spreadsheet edit",
  "table edit",
  "table modify",
  "inspect table",
  "show table",
  "table inspection",
  "table view",
  "view table",
  "adjustable",
  "desk lamp",
  "banquet",
  "canteen",
  "four legs",
  "table rows",
  "tabular data",
  "digital tablet",
  "handheld device",
  "rectangle screen",
  "square screen",
  "home button",
  "capture image",
  "device camera",
  "portable camera",
  "tablet photography",
  "tablet mac",
  "content sections",
  "panel navigation",
  "tab control",
  "tabbed interface",
  "tabbed navigation",
  "tabbed view",
  "gameplan",
  "crosshatch",
  "hash symbol",
  "keyword",
  "microblogging",
  "octothorpe",
  "pound sign",
  "carryout",
  "chinese food",
  "delivery icon",
  "food box",
  "food order",
  "food package",
  "handles",
  "takeout icon",
  "to go",
  "to-go box",
  "to-go container",
  "anti-tamper",
  "interference",
  "no tampering",
  "tamper",
  "tamper detection",
  "OS wifi",
  "mobile cast",
  "tap and play",
  "mediterranean",
  "olives",
  "small plates",
  "tapas",
  "toothpick",
  "archery",
  "bulls",
  "dartboard",
  "task_alt",
  "tick circle",
  "boast",
  "brag",
  "dab",
  "dabbing",
  "disrespect",
  "emote",
  "internet culture",
  "jeer",
  "mock",
  "ridicule",
  "show off",
  "taunt",
  "troll",
  "taxi cab",
  "taxi service",
  "group dashboard",
  "project dashboard",
  "shared dashboard",
  "team dashboard",
  "conserve",
  "preservation",
  "buddha",
  "buddhism",
  "buddhist",
  "historical",
  "monastery",
  "monument",
  "pagoda",
  "religious icon",
  "shrine",
  "gopuram",
  "hindu",
  "hinduism",
  "hindus",
  "indian",
  "mandir",
  "south asia",
  "affiliation",
  "subordinate",
  "tenancy",
  "bash",
  "cli",
  "command line",
  "command prompt",
  "emulator",
  "zsh",
  "blog post",
  "web form",
  "revision",
  "text_compare",
  "character size",
  "decrease font",
  "font scaling",
  "font size decrease",
  "reduce text size",
  "smaller text",
  "text decrease",
  "text scaling",
  "zoom out text",
  "capital t",
  "double t",
  "lowercase t",
  "text fields",
  "tt",
  "two t's",
  "ai content",
  "ai text",
  "ai writing",
  "generate text",
  "language model",
  "text generation",
  "square A",
  "text options",
  "text styling",
  "text_increase",
  "capital letter",
  "rotate text up",
  "text flip",
  "text orientation",
  "text rotate",
  "text rotation",
  "vertical rotation",
  "angledown",
  "angle up",
  "angleup",
  "text angle",
  "character rotation",
  "dow",
  "rotate text down",
  "text down",
  "no rotation",
  "end of text",
  "text end",
  "go to start",
  "scroll to top",
  "text navigation",
  "cursor navigation",
  "end of line",
  "eol",
  "move cursor",
  "skip to end",
  "text jump",
  "editing text",
  "move text",
  "previous character",
  "previous word",
  "adjust text",
  "change text order",
  "down caret",
  "line down",
  "lower text",
  "move line down",
  "move text down",
  "order down",
  "paragraph down",
  "paragraph move",
  "reorder text",
  "shift down",
  "sort down",
  "text move",
  "text position",
  "text reorder",
  "text select",
  "text shift",
  "next character",
  "move word",
  "select word",
  "shift text",
  "move line up",
  "move paragraph up",
  "move text up",
  "select move",
  "text block",
  "text select move",
  "text up",
  "text_snippet",
  "convert text",
  "doc data",
  "listen to text",
  "play sound",
  "pronounce",
  "read aloud",
  "read text",
  "text reader",
  "text to speech",
  "tts",
  "capitalize",
  "increase font size",
  "unknow",
  "grooved",
  "ribbed",
  "ridged",
  "tilted",
  "add pattern",
  "add texture",
  "apply texture",
  "create texture",
  "insert texture",
  "new pattern",
  "new texture",
  "pattern icon",
  "plus pattern",
  "plus texture",
  "stripes pattern",
  "texture icon",
  "decrease pattern",
  "decrease texture",
  "diagonal stripes",
  "less pattern",
  "less texture",
  "pattern control",
  "pattern removal",
  "reduce pattern",
  "reduce texture",
  "remove overlay",
  "remove pattern",
  "remove texture",
  "subtract pattern",
  "subtract texture",
  "texture control",
  "texture removal",
  "comedy show",
  "drama show",
  "entertainment industry",
  "mask icon",
  "performing arts",
  "theatrical performance",
  "tragedy mask",
  "entertainment venues",
  "local cinema",
  "local films",
  "local movies",
  "local theater",
  "showtimes",
  "theaters",
  "tickets",
  "kelvin",
  "weather forecast",
  "add temperature",
  "add thermometer",
  "create temperature",
  "hotter",
  "new temperature",
  "new thermometer",
  "temperature measurement",
  "thermometer plus",
  "heat up",
  "temperature increase",
  "temperature rising",
  "thermometer up",
  "warming",
  "heat loss",
  "reduction",
  "subzero",
  "temperature drop",
  "thermometer down",
  "cold temperature",
  "colder",
  "decrease temperature",
  "lower temperature",
  "reduce temperature",
  "remove heat",
  "temperature down",
  "adjust temperature",
  "increase temperature",
  "raise temperature",
  "temperature adjustment",
  "temperature up",
  "regulate",
  "landmarks",
  "things to do",
  "cyberattack",
  "cybersecurity threat",
  "risk assessment",
  "threat analysis",
  "threat intelligence",
  "against",
  "ate",
  "disapproval gesture",
  "disapprove",
  "dislike button",
  "down vote",
  "downvote",
  "negative feedback",
  "thumb down",
  "thumbs down",
  "thumbs down button",
  "unlike button",
  "veto",
  "like outline",
  "thumb up outline",
  "upvote",
  "content view",
  "image list",
  "image preview",
  "previews",
  "thumbnail bar",
  "double thumbs",
  "thumbs up down",
  "cloud with lightning",
  "electric storm",
  "tibia",
  "fibula",
  "human anatomy",
  "human leg",
  "leg bone",
  "patella",
  "large tile",
  "tile large",
  "tile medium",
  "auto time",
  "auto timer",
  "automatic time",
  "time automation",
  "time settings",
  "elapsed time",
  "chronology",
  "dates",
  "roadmap",
  "count up",
  "10 minutes",
  "10 seconds",
  "count down",
  "10s",
  "picked",
  "ten seconds",
  "3 seconds",
  "3s",
  "number three",
  "numeral three",
  "short timer",
  "three seconds",
  "5 minutes",
  "5 seconds",
  "brief timer",
  "five minutes",
  "five seconds",
  "quick timer",
  "countdown down",
  "decrease time",
  "duration decrease",
  "lower time",
  "reduce time",
  "shorten time",
  "stopwatch down",
  "time decrease",
  "time down",
  "timer down",
  "increase time",
  "lengthen",
  "timer up",
  "no timer",
  "remove timer",
  "countdown timer",
  "interval timer",
  "pause symbol",
  "progress pause",
  "task timer",
  "timer control",
  "begin timer",
  "play symbol",
  "start timer",
  "air pump",
  "check tire pressure",
  "flat tire",
  "inflate",
  "inflation",
  "pit stop",
  "pressure gauge",
  "tire inflation gauge",
  "tire pressure",
  "cross shape",
  "letterform",
  "resize text",
  "sentence case",
  "heads up display",
  "hud",
  "snackbar",
  "system message",
  "chapters",
  "table of contents",
  "titles",
  "toc",
  "now",
  "inable",
  "power_off",
  "slider_off",
  "switch_off",
  "toggle_button",
  "toggle_off",
  "toggle_switch",
  "switch on",
  "toggle button",
  "toggle on",
  "toll",
  "flat head",
  "rungs",
  "three rungs",
  "bubble level",
  "spirit level",
  "crosshead",
  "phillips",
  "crimp",
  "crimper",
  "crimping",
  "cutter",
  "gripping",
  "pincers",
  "pliers",
  "stripper",
  "wire stripper",
  "bore",
  "cordless drill",
  "crafting",
  "drill",
  "drilling",
  "electric drill",
  "fasten",
  "power drill",
  "powertool",
  "screws",
  "bubbletool",
  "expand information",
  "explain",
  "more information",
  "say",
  "additional info",
  "on hover",
  "top panel",
  "open panel",
  "folder with lines",
  "lines in folder",
  "force",
  "dissolved",
  "impurity",
  "salts",
  "sediment",
  "substances",
  "tds",
  "total dissolved solids",
  "water analysis",
  "water quality",
  "water testing",
  "double click",
  "double finger tap",
  "double press",
  "double tap",
  "double touch",
  "multi-touch",
  "touchpad",
  "two taps",
  "two touches",
  "long press",
  "long touch",
  "press and hold",
  "touch and hold",
  "three touch",
  "triple arc",
  "triple tap",
  "triple touch",
  "clickwheel",
  "cursor control",
  "mouse settings",
  "pointing device",
  "scroll wheel",
  "touchpad settings",
  "two-finger scroll",
  "no cursor",
  "no pointer",
  "travel plan",
  "children's toy",
  "kids store",
  "toy car",
  "toy store",
  "toys",
  "jigsaw piece",
  "puzzles",
  "pinwheel",
  "quatrefoil",
  "activity log",
  "change log",
  "compare versions",
  "evolve",
  "revision history",
  "three finger gesture",
  "three finger swipe",
  "three finger tap",
  "trackpad_input_3",
  "signalization",
  "stoplight",
  "three lights",
  "traffic light",
  "bumper to bumper",
  "car column",
  "car row",
  "congestion",
  "heavy traffic",
  "standstill",
  "three cars",
  "traffic jam",
  "vehicles",
  "meteor",
  "streak",
  "halfway",
  "mid-level",
  "short path",
  "short trail",
  "electric train",
  "light rail",
  "public transit map",
  "streetcar",
  "trolleybus",
  "transcribe",
  "voice to text",
  "bus transfer",
  "internal transfer",
  "platform change",
  "station change",
  "station transfer",
  "train transfer",
  "transport hub",
  "within",
  "within station",
  "human rights",
  "sexual identity",
  "social movement",
  "trans",
  "transgender",
  "transgender symbol",
  "egress",
  "enterexit",
  "public transportation ticket",
  "train ticket",
  "transit pass",
  "director's cut",
  "film cut",
  "flix",
  "jump cut",
  "montage",
  "scenes",
  "appear",
  "dissolve",
  "image transition",
  "transition effect",
  "video transition",
  "fade to black",
  "halftone",
  "stipple",
  "car and motorcycle",
  "four wheeled vehicle",
  "mixed transportation",
  "transportation modes",
  "two wheeled vehicle",
  "destination search",
  "explore the world",
  "find a trip",
  "global search",
  "globe search",
  "search travel",
  "travel discovery",
  "travel search",
  "world explorer",
  "bags",
  "luggage bag",
  "packing",
  "depreciation",
  "downturn",
  "trending down",
  "domestic travel",
  "international travel",
  "long trip",
  "overseas trip",
  "short trip",
  "weekend getaway",
  "handcart",
  "pushcart",
  "shopping trolley",
  "two boxes",
  "cable car icon",
  "passenger car",
  "public transit icon",
  "tourism icon",
  "tram icon",
  "trolley icon",
  "uphill transport",
  "1st",
  "big wave",
  "cataclysm",
  "crest",
  "giant wave",
  "seaquake",
  "tidal wave",
  "tide",
  "tsunami",
  "delimited",
  "tab separated values",
  "tsv",
  "digital communication",
  "teletype",
  "text-based communication",
  "tty",
  "horizontal sliders",
  "sharp left",
  "sharp turn",
  "sharp turn left",
  "turn left arrow",
  "arrow turn right",
  "right turn arrow",
  "sharp right",
  "sharp right turn",
  "turn corner",
  "turn sharp right",
  "upwards arrow",
  "arrow bend",
  "continue left",
  "proceed left",
  "slight",
  "slight left",
  "slight turn",
  "turn arrow",
  "slight right",
  "slight right turn",
  "my tv",
  "my videos",
  "personal media",
  "personal video",
  "video library",
  "configure displays",
  "connect display",
  "dual screens",
  "duplicate display",
  "monitors",
  "tv setup",
  "airtime",
  "channel guide",
  "episode",
  "program guide",
  "tv icon",
  "tv listing",
  "tv logo",
  "tv program",
  "forward skip",
  "next channel",
  "next episode",
  "tv control",
  "disabled state",
  "inactive state",
  "monitor power",
  "no television",
  "no tv",
  "off state",
  "television disabled",
  "television off",
  "tv disabled",
  "tv power",
  "tv_off",
  "channel list",
  "epg",
  "google connect",
  "google tv",
  "television control",
  "tv with assistant",
  "double page",
  "dual page",
  "page spread",
  "two page",
  "two pager",
  "pager",
  "sidecar",
  "two wheeler",
  "specimen",
  "180",
  "about-face",
  "backtrack",
  "hairpin turn",
  "about face",
  "u turn right",
  "uturn",
  "connected lines",
  "forearm",
  "intertwined lines",
  "orthopaedic",
  "ulna",
  "two bones",
  "rainy day",
  "rainy season",
  "decompression",
  "unpack",
  "command z",
  "control z",
  "display less",
  "expand less",
  "reveal less",
  "section toggle",
  "unfold less",
  "collapse less",
  "minimize less",
  "reveal more",
  "vertical expand",
  "break apart",
  "unmerge",
  "unknown document",
  "unknown file",
  "unknown file type",
  "unsupported",
  "what is this",
  "miss",
  "temporary halt",
  "anti-copyright",
  "cc0",
  "copyright free",
  "creative commons zero",
  "free to use",
  "freeware",
  "license removal",
  "no copyright",
  "no license",
  "open license",
  "permissive license",
  "public domain",
  "remove license",
  "slashed c",
  "slashed circle",
  "uncrossed circle",
  "unlicense",
  "all-terrain",
  "bumpy road",
  "dirt road",
  "gravel road",
  "off-road",
  "pebbles",
  "rough road",
  "suv",
  "uneven surface",
  "unmaintained road",
  "unpaved road",
  "unpublished",
  "mail stop",
  "no notification",
  "expect",
  "forthcoming",
  "imminent",
  "block refresh",
  "block reload",
  "block sync",
  "block update",
  "disabled refresh",
  "disabled reload",
  "disabled sync",
  "disabled update",
  "no refresh",
  "no reload",
  "no sync",
  "no update",
  "reload disabled",
  "update disabled",
  "instal",
  "cashless",
  "fast payment",
  "gpay",
  "instant payment",
  "mobile banking",
  "secure payment",
  "unified payments interface",
  "upi",
  "contribute file",
  "document upload",
  "import file",
  "share file",
  "submit file",
  "transfer file",
  "media upload",
  "upload 2",
  "incontinence",
  "men's health",
  "pelvic health",
  "prostate",
  "urinary tract",
  "urologist",
  "trident",
  "universal serial bus",
  "data transfer off",
  "device disconnected",
  "hardware disconnected",
  "no usb",
  "port disabled",
  "port off",
  "usb disabled",
  "usb disconnect",
  "usb off",
  "user options",
  "user profile attributes",
  "immunisation",
  "immunity",
  "carpet",
  "deep clean",
  "hoover",
  "upholstery",
  "vacuum",
  "vacuuming",
  "hydraulic",
  "pneumatic",
  "shut off",
  "do not",
  "e-cigarette",
  "e-cigarette ban",
  "electronic cigarette prohibited",
  "no e-cigarette",
  "no electronic cigarette",
  "no nicotine",
  "no vape",
  "no vaping",
  "smoking ban",
  "vape free",
  "vaping prohibited",
  "ecigarette",
  "electronic cigarette",
  "vape pen",
  "vape shop",
  "vape store",
  "vaping area",
  "vaping lounge",
  "vaping room",
  "vaporizer",
  "add variable",
  "create variable",
  "insert variable",
  "new variable",
  "clear variable",
  "delete variable",
  "field remove",
  "form delete",
  "input delete",
  "remove variable",
  "variable delete",
  "breathing apparatus",
  "icu",
  "intensive care",
  "mechanical ventilation",
  "medical device",
  "medical equipment",
  "respiratory support",
  "respiratory therapy",
  "ventilator",
  "new releases",
  "reliable",
  "authenticity disabled",
  "authenticity off",
  "authenticity remove",
  "badge disabled",
  "badge off",
  "badge remove",
  "cancel verification",
  "disable verification",
  "not verified",
  "reject verification",
  "remove verification",
  "seal broken",
  "seal disabled",
  "seal off",
  "seal remove",
  "security disabled",
  "security remove",
  "starburst disabled",
  "starburst off",
  "starburst remove",
  "trust disabled",
  "trust off",
  "trust remove",
  "unverification",
  "unverified",
  "verification cancelled",
  "verification disabled",
  "verification off",
  "verification rejected",
  "verification removed",
  "verified_off",
  "trusted",
  "lowest",
  "middle align",
  "up and down",
  "vertical_distribute",
  "covering",
  "louvers",
  "shades",
  "four columns",
  "lowered",
  "vertical_split",
  "tremble",
  "create video call",
  "join video call",
  "new video call",
  "start video call",
  "camera view",
  "add recording",
  "camera add",
  "create video",
  "film video",
  "new video",
  "plus camera",
  "plus video",
  "video camera add",
  "video plus",
  "capture video",
  "person video",
  "profile video",
  "record symbol",
  "start video",
  "user video",
  "video camera icon",
  "video message",
  "video stream",
  "video symbol",
  "camera slash",
  "forbidden video",
  "front camera off",
  "no video signal",
  "selfie camera off",
  "user camera off",
  "video broadcast off",
  "video slash",
  "video stream off",
  "facetime",
  "movie file",
  "video archive",
  "video document",
  "footage",
  "video label",
  "video management",
  "video marker",
  "video metadata",
  "video tag",
  "film library",
  "movie library",
  "content search",
  "explore video",
  "find video",
  "media search",
  "online video",
  "search video",
  "video browser",
  "video discovery",
  "video platform",
  "video player search",
  "video search",
  "video setup",
  "anti-shake",
  "image stabilization",
  "motion stabilization",
  "stabilize",
  "stable",
  "steady",
  "steady cam",
  "steady video",
  "taping",
  "video stabilization",
  "video_stable",
  "movie camera",
  "record icon",
  "video recorder",
  "camera issue",
  "camera warning",
  "recording issue",
  "recording problem",
  "recording warning",
  "video error",
  "video issue",
  "video problem",
  "video warning",
  "disable camera",
  "disabled camera",
  "end video call",
  "end video chat",
  "hide video",
  "video hidden",
  "video mute",
  "video privacy",
  "videocam off",
  "game asset",
  "gaming console",
  "video game asset",
  "asset off",
  "controller disabled",
  "end game",
  "game asset off",
  "game off",
  "gamepad disabled",
  "gaming disabled",
  "no controller",
  "no game",
  "no gamepad",
  "no gaming",
  "pause game",
  "stop game",
  "subjects",
  "view agenda",
  "select app",
  "view all",
  "view array",
  "content browsing",
  "image browsing",
  "media browsing",
  "media viewer",
  "picture browsing",
  "three items",
  "three slides",
  "three vertical lines",
  "view column",
  "view display",
  "view layout",
  "view_column",
  "comfortable",
  "comfy",
  "two column",
  "2x2",
  "condensed",
  "layout dense",
  "view cozy",
  "multiple lines",
  "view content",
  "view headline",
  "view title",
  "3d model",
  "view in ar",
  "3d disabled",
  "3d inactive",
  "3d off",
  "3d view off",
  "ar disabled",
  "ar inactive",
  "ar off",
  "augmented reality disabled",
  "augmented reality inactive",
  "augmented reality off",
  "disable 3d",
  "disable ar",
  "disable view",
  "disable vr",
  "three dimensional off",
  "three dimensional view off",
  "view in ar off",
  "virtual reality disabled",
  "virtual reality inactive",
  "virtual reality off",
  "vr disabled",
  "vr inactive",
  "vr off",
  "agile",
  "columns view",
  "kanban",
  "kanban board",
  "kanban view",
  "project organization",
  "project view",
  "scrum",
  "vertical columns",
  "view kanban",
  "workflow management",
  "view_list",
  "view module",
  "quilt",
  "100%",
  "actual size",
  "default size",
  "full size",
  "normal size",
  "one hundred percent",
  "one to one",
  "original size",
  "real size",
  "screen fit",
  "stream view",
  "view stream",
  "chronological",
  "view timeline",
  "weekly view",
  "select image",
  "vignette",
  "vacation stay",
  "villa",
  "eye icon",
  "open eye",
  "viewable",
  "eye lock",
  "show view",
  "view lock",
  "visibility lock",
  "cant see",
  "censorship",
  "do not show",
  "no looking",
  "obscured",
  "unsee",
  "viewing off",
  "life signs",
  "vital statistics",
  "aerobic",
  "cardiorespiratory",
  "endurance",
  "maximal oxygen consumption",
  "vital capacity",
  "vo2",
  "vo2 max",
  "vocal",
  "voice_chat",
  "commentary off",
  "disable voice",
  "narration off",
  "no voice",
  "person mute",
  "user mute",
  "voice disabled",
  "voice off",
  "voice over off",
  "voiceover off",
  "choose voice",
  "select voice",
  "side profile",
  "voice selection",
  "sound input",
  "speech control",
  "speech input",
  "speech selection",
  "answerphone",
  "cassette tape",
  "reel-to-reel",
  "voicemail symbol",
  "cassette",
  "voicemail message",
  "voicemail_2",
  "active volcano",
  "eruption",
  "geological",
  "lava",
  "magma",
  "volcano",
  "adjust volume",
  "audio down",
  "decrease volume",
  "lower volume",
  "quieter",
  "reduce volume",
  "sound down",
  "volume adjustment",
  "volume decrease",
  "volume_down",
  "lower sound",
  "volume down alt",
  "audio muted",
  "sound muted",
  "speaker muted",
  "volume_mute",
  "amplification",
  "increase volume",
  "louder",
  "volume increase",
  "activism",
  "generosity",
  "humanitarian",
  "philanthropy",
  "social good",
  "welfare",
  "key icon",
  "lock icon",
  "privacy key",
  "vpn key",
  "connection alert",
  "key alert",
  "private key",
  "vpn alert",
  "vpn warning",
  "no key",
  "no vpn",
  "private off",
  "unlock off",
  "vpn disabled",
  "global security",
  "safe browsing",
  "secure browsing",
  "vpn connection",
  "web security",
  "encrypted connection",
  "globe lock",
  "lock globe",
  "world lock",
  "create2d",
  "vr180",
  "vr panorama",
  "canvas",
  "poster",
  "wall art",
  "sconce",
  "wall lamp",
  "wall light",
  "wall-mounted",
  "enchantment",
  "magic wand",
  "sorcery",
  "wand",
  "wand_shine",
  "witch",
  "fairy",
  "illusion",
  "mage",
  "magical",
  "miracle",
  "mystic",
  "warlock",
  "witchcraft",
  "depot",
  "hangar",
  "house shape",
  "storage building",
  "storehouse",
  "wholesale",
  "all clear",
  "cancel warning",
  "caution off",
  "disable warning",
  "ignore warnings",
  "issue resolved",
  "problem solved",
  "remove warning",
  "silence warnings",
  "suppress warnings",
  "threat removed",
  "turn off warnings",
  "warning dismissed",
  "warning inactive",
  "disease prevention",
  "hand wash",
  "analog watch",
  "lugs",
  "timepiece",
  "watch app",
  "watch control",
  "watch face",
  "watch navigation",
  "wearable control",
  "side button",
  "watch button",
  "watch check",
  "watch checkmark",
  "no watch",
  "watch off",
  "screentime",
  "activity tracker",
  "awaken",
  "wearable device",
  "aqua",
  "hydrate",
  "hydration reminder",
  "hydroflask",
  "reusable",
  "sipper",
  "sports bottle",
  "water_bottle",
  "gallon",
  "h2o",
  "water bottle",
  "water cooler",
  "burst pipe",
  "home insurance",
  "house flood",
  "leak detection",
  "plumbing issue",
  "roof leak",
  "water damage",
  "carbonated",
  "droplet do",
  "fizz",
  "sparkling",
  "water do",
  "water supply",
  "hydroelectricity",
  "hydropower",
  "save water",
  "water charge",
  "water conservation",
  "water electricity",
  "water energy",
  "water power",
  "drinking water",
  "full cup",
  "full glass",
  "full tank",
  "potable water",
  "quench",
  "reservoir",
  "geyser",
  "water heater",
  "water_heater",
  "conserve water",
  "leakproof",
  "sealed",
  "water resistant",
  "water_lock",
  "drought",
  "refraction",
  "orp",
  "oxidation",
  "oxidation-reduction potential",
  "purification",
  "redox",
  "water treatment",
  "acid",
  "acidic",
  "acidity",
  "alkaline",
  "alkalinity",
  "hydrogen",
  "ph",
  "water droplet",
  "water ph",
  "groundwater intake",
  "pump system",
  "pumping",
  "rainwater harvesting",
  "wastewater",
  "water pressure",
  "water pressure boosting",
  "water pump",
  "waterworks",
  "chemicals",
  "compounds",
  "voc",
  "volatile",
  "volatile organic compounds",
  "warm water",
  "water pollution",
  "water voc",
  "rectangular bars",
  "waterfall",
  "approachable",
  "bye",
  "farewell",
  "goodbye",
  "greetings",
  "hey",
  "salutation",
  "waving hand",
  "W",
  "aw",
  "letter w",
  "wp",
  "light fixture",
  "wb_incandescent",
  "sunlight",
  "wb_shade",
  "wb_sunny",
  "dawn",
  "half sun",
  "noon",
  "partial sun",
  "rising sun",
  "setting sun",
  "restroom symbols",
  "forecast icon",
  "hailstone",
  "hailstones",
  "hailstorm",
  "snowy",
  "weather icon",
  "weather symbol",
  "mixed conditions",
  "rain symbol",
  "snow symbol",
  "freezing",
  "-website",
  "browser error",
  "incompatible",
  "not supported",
  "web error",
  "online content",
  "web stories",
  "clickstream",
  "inbound marketing",
  "internet traffic",
  "mouse cursor",
  "online marketing",
  "sem",
  "seo",
  "user activity",
  "user engagement",
  "web traffic",
  "website analytics",
  "website traffic",
  "website visits",
  "webhook",
  "days off",
  "free time",
  "saturday",
  "sunday",
  "grams",
  "heavy lifting",
  "kg",
  "kilogram",
  "lb",
  "lbs",
  "pounds",
  "tonne",
  "weigh",
  "weight plate",
  "western",
  "hot topics",
  "trending content",
  "trending now",
  "trending topics",
  "what's hot",
  "whatshot",
  "para-transit",
  "paratransit",
  "pick-up",
  "find polling place",
  "polling place",
  "validate election",
  "vote location",
  "where to vote",
  "content width",
  "default width",
  "display size",
  "video size",
  "window size",
  "1 bar",
  "connection indicator",
  "low connectivity",
  "weak connection",
  "wifi bar",
  "wifi indicator",
  "add network",
  "add wifi",
  "connect wifi",
  "join wifi",
  "new network",
  "new wifi",
  "wifi add",
  "wifi plus",
  "voip call",
  "wifi calling",
  "wireless call",
  "high signal",
  "change channel",
  "double arch",
  "select channel",
  "wifi channel",
  "connection search",
  "discover wifi",
  "find signal",
  "find wifi",
  "internet search",
  "locate wifi",
  "network discovery",
  "network search",
  "search signal",
  "search wifi",
  "signal search",
  "wifi find",
  "wifi location",
  "wifi scan",
  "wireless search",
  "domestic network",
  "home wifi",
  "residential network",
  "wifi_home",
  "full strength",
  "connectivity alert",
  "internet notification",
  "network notification",
  "signal notification",
  "wifi alert",
  "disable internet",
  "disable network",
  "disable wifi",
  "disable wireless",
  "no internet symbol",
  "wifi symbol",
  "lock wifi",
  "password protected",
  "private wifi",
  "wifi password",
  "wps",
  "wifi building",
  "wifi proxy",
  "concentric semicircles",
  "internet sharing",
  "portable hotspot",
  "semicircles",
  "wifi tethering",
  "three blades",
  "wind farm",
  "sliding window",
  "demister",
  "goblet",
  "wine bar",
  "female icon",
  "woman symbol",
  "female_2",
  "ladies",
  "profile_2",
  "user_2",
  "woman_2",
  "cv",
  "attention work",
  "briefcase alert",
  "briefcase notification",
  "briefcase warning",
  "business alert",
  "business notification",
  "career alert",
  "deadline alert",
  "deadline warning",
  "employment alert",
  "employment notification",
  "employment warning",
  "important task",
  "job alert",
  "job notification",
  "job reminder",
  "job warning",
  "office alert",
  "office notification",
  "project alert",
  "project notification",
  "task alert",
  "task notification",
  "urgent task",
  "work alert",
  "work notification",
  "work reminder",
  "work warning",
  "employment history",
  "job history",
  "past work",
  "previous jobs",
  "track record",
  "work history",
  "benefit",
  "perk",
  "workspace premium",
  "projects",
  "workspaces",
  "abrasion",
  "gash",
  "injuries",
  "laceration",
  "scar",
  "scratch",
  "sew",
  "staples",
  "stitch",
  "stitching",
  "suture",
  "wounds",
  "arrow writing",
  "line wrap",
  "feel",
  "bad location",
  "inaccurate",
  "incorrect position",
  "misplaced",
  "not found",
  "content editor",
  "what you see is what you get",
  "wysiwyg",
  "pettle",
  "past trips",
  "trips",
  "your_trips",
  "find again",
  "last search",
  "past searches",
  "previous searches",
  "redo search",
  "refresh search",
  "reload search",
  "repeat search",
  "search loop",
  "geofence",
  "person alert",
  "zone alert",
  "account blocked",
  "exclusion zone",
  "no people allowed",
  "person crossed out",
  "person restriction",
  "user blocked",
  "user restriction",
  "closer look",
  "zoom level",
  "zoom_in",
  "closer view",
  "detailed view",
  "enlarge map",
  "expand map",
  "inwards",
  "inwards arrows",
  "location zoom",
  "magnify map",
  "map zoom",
  "navigation zoom",
  "zoom map",
  "zoom_in_map",
  "content zoom",
  "document zoom",
  "image zoom",
  "text zoom",
  "zoom_out",
  "zoom out map",
  "Chinese medicine",
  "acupuncture",
  "needles",
  "pain relief",
  "tcm",
  "three needles",
  "traditional chinese medicine",
  "no approval",
  "no delegation",
  "badminton",
  "birdie",
  "shuttlecock",
  "summer sports",
  "lying",
  "establishment",
  "foamy",
  "frothy",
  "izakaya",
  "vent direction",
  "air vents",
  "airflow to legs",
  "foot warmer",
  "leg warmer",
  "seated person",
  "bar stool",
  "high chair",
  "al fresco",
  "poolside",
  "achieved",
  "acknowledged",
  "bishop",
  "game piece",
  "miter",
  "pointy",
  "round top",
  "tabletop game",
  "boardgame",
  "circle top",
  "domed",
  "monarch",
  "simplified",
  "gameplay",
  "L-shape",
  "equestrian",
  "mane",
  "pawn piece",
  "semicircular",
  "rook",
  "sovereign",
  "abstract mark",
  "abstract mark element",
  "achievement badge",
  "app development asset",
  "brand design",
  "brand design element",
  "brand identity",
  "brand identity element",
  "brand mark",
  "brand mark element",
  "branding design",
  "branding design element",
  "branding element",
  "branding element element",
  "design resource",
  "design resource element",
  "device element",
  "digital art element",
  "emblem element",
  "game asset element",
  "game development",
  "game development asset",
  "game ui",
  "graphic design element",
  "graphic element",
  "graphic element element",
  "gui element",
  "hud element",
  "icon library",
  "icon library element",
  "icon pack",
  "icon pack element",
  "icon set",
  "icon set element",
  "image element",
  "insignia element",
  "logo design",
  "logo design element",
  "logotype",
  "logotype element",
  "object element",
  "picture element",
  "svg",
  "symbol design",
  "symbol design element",
  "symbol mark",
  "symbol mark element",
  "trademark element",
  "visual art",
  "visual art element",
  "visual asset",
  "visual asset element",
  "visual communication design element",
  "visual communication element",
  "visual design element",
  "visual element",
  "visual element element",
  "visual identity design element",
  "visual identity element",
  "visual language element",
  "visual representation element",
  "visual style element",
  "visual symbol",
  "visual symbol element",
  "web design element",
  "dining table",
  "consuming",
  "dining area",
  "indoor dining",
  "simplified person",
  "overhead light",
  "drone",
  "quadcopter",
  "robotic",
  "uas",
  "uav",
  "unmanned aerial vehicle",
  "accessibility features",
  "audio assistance",
  "enhanced hearing",
  "volume level",
  "garage sale",
  "catering service",
  "covered dish",
  "dining room",
  "fine dining",
  "hand serving",
  "meal service",
  "restaurant service",
  "serving plate",
  "silver dome",
  "health cross",
  "cheerful",
  "baby gear",
  "baby seat",
  "caregiver",
  "curry",
  "delicious",
  "flavor",
  "gravy",
  "japanese curry",
  "meal time",
  "spicy",
  "east asia",
  "national flag",
  "waving flag",
  "preferred location",
  "saved location",
  "geotagging",
  "abstract hand",
  "abstract massage",
  "bodywork",
  "knead",
  "soothe",
  "book icon",
  "cookbook",
  "digital menu",
  "kitchen icon",
  "menu book",
  "recipe book",
  "recipes",
  "mobile_layout",
  "one square",
  "device maintenance",
  "device repair",
  "mobile configuration",
  "mobile repair",
  "phone configuration",
  "phone repair",
  "errand",
  "geographic",
  "rock",
  "film audio",
  "listen movie",
  "movie clip",
  "movie sound",
  "talkie",
  "watch movie",
  "audio history",
  "audio playback",
  "music history",
  "music loop",
  "music playback",
  "playback history",
  "playlist history",
  "recent tracks",
  "recently played",
  "song history",
  "track history",
  "centered",
  "dual mode",
  "ecology symbol",
  "environmental symbol",
  "nature symbol",
  "clover",
  "letter s",
  "notched circle",
  "scalloped circle",
  "serpentine s",
  "serrated edge",
  "snake s",
  "wavy s",
  "wavy shape",
  "winding s",
  "beach tennis",
  "holes",
  "padel",
  "pop tennis",
  "racket sports",
  "squash",
  "parking fee",
  "parking meter",
  "parking regulations",
  "parking sign",
  "parking spot",
  "attendant",
  "chauffeur",
  "add funds",
  "get cash",
  "load money",
  "payment gateway",
  "receive money",
  "plastic money",
  "doubles",
  "net sport",
  "pickleball",
  "singles",
  "wiffle ball",
  "airliner",
  "contrail",
  "soaring",
  "vapor trail",
  "play_area",
  "seesaw",
  "swing set",
  "children's area",
  "entertainment area",
  "entertainment symbol",
  "fun area",
  "kids' area",
  "leisure activity",
  "outdoor symbol",
  "park area",
  "play area",
  "recreation area",
  "recreation symbol",
  "summer activity",
  "undo change",
  "access control mode",
  "activate deactivate",
  "antivirus mode",
  "authorization mode",
  "data protection mode",
  "enable disable",
  "firewall mode",
  "insecure mode",
  "network security mode",
  "on off",
  "permissions mode",
  "privacy mode",
  "protection active",
  "protection configuration",
  "protection controls",
  "protection inactive",
  "protection management",
  "protection on",
  "protection options",
  "protection switch",
  "protection toggle",
  "safe mode",
  "secure mode",
  "security active",
  "security configuration",
  "security controls",
  "security inactive",
  "security management",
  "security on",
  "security options",
  "security switch",
  "security toggle",
  "shield configuration",
  "shield control",
  "shield management",
  "shield settings",
  "shield toggle",
  "toggle configuration",
  "toggle control",
  "toggle icon",
  "toggle management",
  "toggle settings",
  "two factor authentication",
  "unsafe mode",
  "interpretation",
  "transit map",
  "transit route",
  "local sync",
  "not saved",
  "not synchronized",
  "save off",
  "synchronization off",
  "unsynced",
  "conference table",
  "furniture arrangement",
  "large table",
  "meeting table",
  "overhead",
  "top view",
  "solo",
  "shadows",
  "alphabets",
  "devanagari",
  "hindi",
  "indian scripts",
  "indic",
  "indic languages",
  "indo",
  "language change",
  "marathi",
  "nepali",
  "regional language",
  "sanskrit",
  "switch language",
  "photography.",
  "asian cuisine",
  "healthy food",
  "hot meal",
  "hungry",
  "rice bowl",
  "serving dish",
  "washoku",
  "dining utensil",
  "dinnerware",
  "dumpling",
  "eating utensil",
  "salad",
  "communication signal",
  "notification bar",
  "phone reception",
  "strength indicator",
  "cellular bars",
  "telecommunications",
  "good signal",
  "graduated",
  "signal issue",
  "bars indicator",
  "maximum signal",
  "more signal",
  "peak signal",
  "phone service",
  "dual sim",
  "dual cell",
  "5 bars",
  "bars icon",
  "max bars",
  "status icon",
  "arcs.",
  "connectivity status",
  "protected connection",
  "protected network",
  "restricted wifi",
  "secured",
  "secured wifi",
  "wireless signal",
  "off signal",
  "bars plus",
  "create hotspot",
  "join network",
  "network plus",
  "wifi create",
  "medium strength",
  "connectivity issue",
  "hot spot",
  "signal strength indicator",
  "unlocked wifi",
  "communications",
  "poor signal",
  "connection strength",
  "excellent signal",
  "wifi question",
  "basic arrow",
  "directional symbol",
  "navigational arrow",
  "single arrow",
  "organisation",
  "sending information",
  "sharing data",
  "stacking elements",
  "upload to cloud",
  "multiple layers",
  "achievement award",
  "food award",
  "good food",
  "high rating",
  "reward points",
  "star plate",
  "rectangular outline",
  "rounded edges",
  "phone battery",
  "battery frame",
  "charging status",
  "rechargeable",
  "battery charge",
  "battery meter",
  "cell phone battery",
  "charge meter",
  "mobile battery",
  "smartphone battery",
  "charging port",
  "charged battery",
  "packed lunch",
  "affirmative",
  "applied",
  "accurate",
  "confirmed appointment",
  "confirmed date",
  "confirmed schedule",
  "datepicker",
  "selected date",
  "granted",
  "dining plan",
  "meal schedule",
  "organizing",
  "bonnet",
  "head covering",
  "little",
  "cherry blossom",
  "dumplings",
  "food item",
  "hanami dango",
  "mitarashi",
  "mochi",
  "pink",
  "rice cakes",
  "image inset",
  "photo inset",
  "picture inset",
  "brewery",
  "japanese text",
  "kanji",
  "sake",
  "defended",
  "guarded",
  "protected mail",
  "safe mail",
  "dishware",
  "eating out",
  "chow",
  "eating utensils",
  "grub",
  "nosh",
  "nourishment",
  "repast",
  "sustenance",
  "extent",
  "money value",
  "range limit",
  "span",
  "baby chair",
  "baby dining",
  "baby friendly",
  "child dining",
  "family dining",
  "hotel services",
  "kid friendly",
  "leisure activities",
  "parent child",
  "restaurant services",
  "travel services",
  "affinity",
  "bonding",
  "companion",
  "mutual",
  "tie",
  "math symbol",
  "percent sign",
  "percent symbol",
  "percentage sign",
  "saving",
  "break area",
  "picnic area",
  "public amenity",
  "rest stop",
  "serve area",
  "way point",
  "search settings",
  "search tools",
  "lumbar",
  "frozen icon",
  "icy",
  "icy treat",
  "paper cone",
  "refreshment icon",
  "shaved ice",
  "summer treat",
  "sweet icon",
  "sweet treat",
  "treat icon",
  "alone",
  "single person",
  "solo dining",
  "flooring",
  "mat",
  "tatami",
  "double like",
  "highly rated",
  "two thumbs up",
  "vote up",
  "broth",
  "comfort food",
  "cooked",
  "oriental",
  "prepared",
  "stir fry",
  "clearing",
  "defogging",
  "defrosting",
  "front glass",
  "grilled food",
  "kushiyaki",
  "poultry",
  "roasted",
  "yakitori",
  "relations",
  "silhouettes",
  "data tracking",
  "fitness device",
  "fitness trackers",
  "health tracking",
  "personal trainer",
  "sports band",
  "crime",
  "criminal",
  "robbery",
  "steal",
  "stolen",
  "theft",
  "unauthorized access",
];


/// This map contains the metadata for all Material Symbols icons.
/// The keys are the icon's dart symbol name and the values are SymbolsMetadata objects that contain the metadata.
/// The metadata includes the original name, popularity, codepoint, categories, tags, and whether the icon is RTL auto-mirrored.
Map<String, SymbolsMetadata> iconMap = {
  "ten_k": SymbolsMetadata(
    originalName: "10k",
    popularity: 203,
    codepoint: 0xe951,
    categories: [0],
    tags: [
      0,
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
      13,
      14,
      15,
      16,
      17,
      18,
      19,
      20,
      21,
      22,
      23,
      24,
      25,
      26,
      27,
      28,
      29,
      30,
      31,
      32,
      33,
      34,
      35,
      36,
      37,
      38,
      39,
      40,
      41,
      42
    ],
  ),
  "ten_mp": SymbolsMetadata(
    originalName: "10mp",
    popularity: 115,
    codepoint: 0xe952,
    categories: [1],
    tags: [
      43,
      44,
      45,
      46,
      7,
      47,
      48,
      49,
      50,
      14,
      51,
      52,
      53,
      54,
      55,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      60,
      61,
      26,
      27,
      62,
      63,
      30,
      64,
      65,
      66,
      32,
      35,
      38,
      40,
      41,
      67,
      68
    ],
  ),
  "eleven_mp": SymbolsMetadata(
    originalName: "11mp",
    popularity: 91,
    codepoint: 0xe953,
    categories: [1],
    tags: [
      69,
      70,
      47,
      48,
      49,
      71,
      50,
      72,
      14,
      53,
      54,
      55,
      19,
      56,
      57,
      58,
      24,
      59,
      60,
      73,
      61,
      74,
      26,
      27,
      62,
      75,
      30,
      64,
      76,
      77,
      78,
      65,
      32,
      35,
      38,
      40
    ],
  ),
  "onetwothree": SymbolsMetadata(
    originalName: "123",
    popularity: 2266,
    codepoint: 0xeb8d,
    categories: [2],
    tags: [
      79,
      80,
      81,
      82,
      83,
      84,
      85,
      86,
      87,
      11,
      88,
      89,
      90,
      91,
      92,
      93,
      24,
      94,
      95,
      96,
      97,
      98,
      99,
      100,
      101,
      102,
      103,
      104,
      105,
      106,
      107,
      108,
      109,
      35,
      110
    ],
  ),
  "twelve_mp": SymbolsMetadata(
    originalName: "12mp",
    popularity: 112,
    codepoint: 0xe954,
    categories: [1],
    tags: [
      111,
      112,
      113,
      47,
      114,
      115,
      116,
      71,
      50,
      14,
      52,
      53,
      117,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      118,
      61,
      119,
      120,
      26,
      27,
      62,
      121,
      30,
      78,
      122,
      65,
      32,
      35,
      38,
      123,
      40
    ],
  ),
  "thirteen_mp": SymbolsMetadata(
    originalName: "13mp",
    popularity: 98,
    codepoint: 0xe955,
    categories: [1],
    tags: [
      124,
      125,
      47,
      48,
      49,
      116,
      71,
      50,
      14,
      52,
      53,
      55,
      126,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      60,
      61,
      119,
      26,
      27,
      62,
      75,
      30,
      64,
      78,
      122,
      32,
      35,
      38,
      127,
      40
    ],
  ),
  "fourteen_mp": SymbolsMetadata(
    originalName: "14mp",
    popularity: 92,
    codepoint: 0xe956,
    categories: [1],
    tags: [
      128,
      129,
      130,
      47,
      114,
      115,
      131,
      132,
      71,
      50,
      14,
      133,
      134,
      52,
      53,
      117,
      135,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      61,
      119,
      26,
      27,
      62,
      30,
      78,
      122,
      136,
      32,
      35,
      38,
      40
    ],
  ),
  "fifteen_mp": SymbolsMetadata(
    originalName: "15mp",
    popularity: 96,
    codepoint: 0xe957,
    categories: [1],
    tags: [
      137,
      138,
      139,
      47,
      114,
      49,
      71,
      50,
      14,
      51,
      52,
      140,
      53,
      54,
      55,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      73,
      141,
      61,
      119,
      26,
      27,
      62,
      30,
      78,
      122,
      65,
      32,
      35,
      38,
      40
    ],
  ),
  "sixteen_mp": SymbolsMetadata(
    originalName: "16mp",
    popularity: 94,
    codepoint: 0xe958,
    categories: [1],
    tags: [
      142,
      143,
      144,
      7,
      47,
      114,
      145,
      49,
      71,
      50,
      14,
      133,
      134,
      52,
      53,
      117,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      141,
      61,
      119,
      26,
      27,
      62,
      30,
      122,
      65,
      146,
      32,
      35,
      38,
      40
    ],
  ),
  "seventeen_mp": SymbolsMetadata(
    originalName: "17mp",
    popularity: 87,
    codepoint: 0xe959,
    categories: [1],
    tags: [
      147,
      148,
      47,
      48,
      149,
      49,
      71,
      50,
      14,
      52,
      16,
      53,
      55,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      141,
      61,
      119,
      150,
      26,
      27,
      62,
      30,
      64,
      76,
      65,
      151,
      32,
      35,
      38,
      40
    ],
  ),
  "eighteen_up_rating": SymbolsMetadata(
    originalName: "18_up_rating",
    popularity: 446,
    codepoint: 0xf8fd,
    categories: [3],
    tags: [
      152,
      153,
      154,
      155,
      156,
      157,
      158,
      7,
      159,
      160,
      161,
      162,
      163,
      164,
      165,
      166,
      23,
      167,
      168,
      169,
      170,
      102,
      171,
      172,
      32,
      173,
      174
    ],
  ),
  "eighteen_mp": SymbolsMetadata(
    originalName: "18mp",
    popularity: 108,
    codepoint: 0xe95a,
    categories: [1],
    tags: [
      152,
      175,
      176,
      7,
      47,
      114,
      115,
      71,
      50,
      161,
      14,
      51,
      52,
      53,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      61,
      119,
      26,
      27,
      62,
      177,
      30,
      65,
      32,
      35,
      38,
      40,
      41,
      68
    ],
  ),
  "nineteen_mp": SymbolsMetadata(
    originalName: "19mp",
    popularity: 96,
    codepoint: 0xe95b,
    categories: [1],
    tags: [
      178,
      179,
      180,
      47,
      48,
      114,
      49,
      71,
      181,
      50,
      14,
      133,
      134,
      52,
      53,
      117,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      141,
      61,
      182,
      119,
      26,
      27,
      62,
      30,
      76,
      122,
      32,
      35,
      38,
      40
    ],
  ),
  "one_k": SymbolsMetadata(
    originalName: "1k",
    popularity: 134,
    codepoint: 0xe95c,
    categories: [0],
    tags: [
      183,
      184,
      185,
      186,
      4,
      5,
      6,
      7,
      8,
      9,
      86,
      10,
      11,
      12,
      187,
      13,
      14,
      188,
      17,
      18,
      19,
      20,
      22,
      23,
      24,
      189,
      26,
      27,
      29,
      30,
      190,
      31,
      32,
      33,
      34,
      35,
      38,
      39,
      191,
      40,
      41,
      42
    ],
  ),
  "one_k_plus": SymbolsMetadata(
    originalName: "1k_plus",
    popularity: 101,
    codepoint: 0xe95d,
    categories: [0],
    tags: [
      192,
      183,
      184,
      185,
      193,
      3,
      4,
      6,
      7,
      8,
      194,
      9,
      86,
      11,
      12,
      187,
      13,
      14,
      195,
      196,
      197,
      19,
      20,
      22,
      198,
      199,
      24,
      200,
      201,
      26,
      27,
      202,
      203,
      204,
      30,
      78,
      31,
      32,
      33,
      205,
      34,
      35,
      38,
      39,
      40,
      41,
      42
    ],
  ),
  "one_x_mobiledata": SymbolsMetadata(
    originalName: "1x_mobiledata",
    popularity: 339,
    codepoint: 0xefcd,
    categories: [4],
    tags: [
      206,
      207,
      4,
      208,
      209,
      210,
      8,
      211,
      212,
      10,
      213,
      214,
      11,
      14,
      215,
      216,
      19,
      217,
      218,
      219,
      220,
      221,
      222,
      223,
      224,
      24,
      225,
      226,
      227,
      228,
      229,
      230,
      231,
      35,
      38,
      40,
      232,
      233,
      234,
      235
    ],
  ),
  "one_x_mobiledata_badge": SymbolsMetadata(
    originalName: "1x_mobiledata_badge",
    popularity: 13,
    codepoint: 0xf7f1,
    categories: [4],
    tags: [
      206,
      207,
      4,
      6,
      208,
      209,
      8,
      211,
      212,
      10,
      214,
      11,
      236,
      14,
      237,
      188,
      215,
      238,
      19,
      239,
      217,
      219,
      240,
      241,
      221,
      222,
      223,
      242,
      24,
      226,
      227,
      228,
      229,
      230,
      231,
      35,
      38,
      40,
      232,
      233,
      234
    ],
  ),
  "twenty_mp": SymbolsMetadata(
    originalName: "20mp",
    popularity: 97,
    codepoint: 0xe95e,
    categories: [1],
    tags: [
      243,
      244,
      245,
      47,
      48,
      114,
      115,
      71,
      50,
      14,
      246,
      133,
      134,
      247,
      52,
      53,
      54,
      117,
      19,
      56,
      57,
      58,
      24,
      59,
      73,
      118,
      61,
      119,
      150,
      120,
      26,
      27,
      62,
      30,
      248,
      78,
      122,
      32,
      35,
      38,
      40
    ],
  ),
  "twenty_one_mp": SymbolsMetadata(
    originalName: "21mp",
    popularity: 87,
    codepoint: 0xe95f,
    categories: [1],
    tags: [
      249,
      250,
      251,
      47,
      48,
      114,
      115,
      116,
      71,
      181,
      50,
      14,
      133,
      52,
      53,
      117,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      118,
      61,
      119,
      26,
      27,
      62,
      121,
      30,
      248,
      78,
      122,
      65,
      32,
      35,
      38,
      40
    ],
  ),
  "twenty_two_mp": SymbolsMetadata(
    originalName: "22mp",
    popularity: 117,
    codepoint: 0xe960,
    categories: [1],
    tags: [
      252,
      253,
      254,
      47,
      48,
      115,
      131,
      71,
      50,
      14,
      255,
      246,
      256,
      257,
      51,
      52,
      53,
      117,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      118,
      61,
      119,
      26,
      27,
      62,
      30,
      248,
      122,
      136,
      32,
      35,
      38,
      40
    ],
  ),
  "twenty_three_mp": SymbolsMetadata(
    originalName: "23mp",
    popularity: 95,
    codepoint: 0xe961,
    categories: [1],
    tags: [
      258,
      259,
      260,
      47,
      114,
      49,
      71,
      181,
      50,
      14,
      256,
      257,
      51,
      52,
      53,
      55,
      117,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      141,
      61,
      150,
      26,
      27,
      62,
      30,
      76,
      78,
      122,
      32,
      35,
      38,
      40
    ],
  ),
  "twenty_four_fps_select": SymbolsMetadata(
    originalName: "24fps_select",
    popularity: 2,
    codepoint: 0xf3f2,
    categories: [1],
    tags: [
      261,
      262,
      263,
      264,
      265,
      47,
      266,
      267,
      268,
      269,
      50,
      270,
      271,
      272,
      273,
      274,
      275,
      276,
      277,
      53,
      278,
      279,
      280,
      24,
      281,
      282,
      283,
      284,
      285,
      286,
      103,
      287,
      288,
      65,
      231,
      289,
      290,
      41,
      291,
      292,
      293
    ],
  ),
  "twenty_four_mp": SymbolsMetadata(
    originalName: "24mp",
    popularity: 124,
    codepoint: 0xe962,
    categories: [1],
    tags: [
      294,
      295,
      296,
      47,
      48,
      114,
      115,
      116,
      71,
      181,
      50,
      14,
      133,
      52,
      53,
      117,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      141,
      61,
      182,
      119,
      26,
      27,
      62,
      121,
      30,
      248,
      122,
      32,
      35,
      38,
      40
    ],
  ),
  "twod": SymbolsMetadata(
    originalName: "2d",
    popularity: 17,
    codepoint: 0xef37,
    categories: [0],
    tags: [
      297,
      4,
      298,
      8,
      299,
      11,
      300,
      301,
      12,
      302,
      303,
      14,
      304,
      305,
      16,
      53,
      18,
      306,
      19,
      307,
      23,
      24,
      25,
      281,
      308,
      309,
      288,
      310,
      311,
      32,
      312,
      313,
      35,
      38,
      314,
      315,
      316,
      40,
      317
    ],
  ),
  "two_k": SymbolsMetadata(
    originalName: "2k",
    popularity: 110,
    codepoint: 0xe963,
    categories: [0],
    tags: [
      318,
      319,
      320,
      321,
      322,
      323,
      324,
      4,
      7,
      8,
      11,
      12,
      325,
      14,
      256,
      257,
      52,
      19,
      326,
      327,
      328,
      24,
      26,
      27,
      285,
      329,
      30,
      330,
      331,
      310,
      65,
      32,
      35,
      38,
      40,
      332,
      333,
      41,
      291,
      334,
      292
    ],
  ),
  "two_k_plus": SymbolsMetadata(
    originalName: "2k_plus",
    popularity: 92,
    codepoint: 0xe964,
    categories: [0],
    tags: [
      192,
      319,
      324,
      335,
      336,
      4,
      7,
      8,
      11,
      12,
      337,
      14,
      274,
      338,
      339,
      52,
      53,
      19,
      340,
      327,
      341,
      24,
      202,
      62,
      30,
      330,
      32,
      342,
      35,
      343,
      38,
      344,
      345,
      40,
      332,
      333,
      346,
      41
    ],
  ),
  "two_mp": SymbolsMetadata(
    originalName: "2mp",
    popularity: 93,
    codepoint: 0xe965,
    categories: [1],
    tags: [
      81,
      347,
      348,
      349,
      7,
      47,
      350,
      11,
      88,
      12,
      14,
      274,
      53,
      19,
      56,
      57,
      327,
      58,
      23,
      24,
      59,
      61,
      26,
      27,
      62,
      177,
      30,
      331,
      65,
      32,
      351,
      35,
      38,
      315,
      40,
      41,
      352
    ],
  ),
  "thirty_fps": SymbolsMetadata(
    originalName: "30fps",
    popularity: 167,
    codepoint: 0xefce,
    categories: [0],
    tags: [
      353,
      354,
      4,
      264,
      355,
      47,
      8,
      267,
      11,
      356,
      357,
      270,
      14,
      273,
      275,
      276,
      358,
      359,
      19,
      218,
      360,
      278,
      24,
      283,
      177,
      361,
      362,
      231,
      342,
      35,
      343,
      38,
      363,
      40,
      41,
      364,
      291,
      334,
      292
    ],
  ),
  "thirty_fps_select": SymbolsMetadata(
    originalName: "30fps_select",
    popularity: 158,
    codepoint: 0xefcf,
    categories: [1],
    tags: [
      263,
      353,
      354,
      365,
      47,
      266,
      269,
      50,
      270,
      273,
      274,
      275,
      277,
      53,
      366,
      367,
      368,
      280,
      23,
      24,
      281,
      282,
      283,
      369,
      286,
      177,
      370,
      103,
      287,
      288,
      371,
      65,
      372,
      231,
      373,
      374,
      41,
      292,
      375
    ],
  ),
  "threesixty": SymbolsMetadata(
    originalName: "360",
    popularity: 1871,
    codepoint: 0xe577,
    categories: [5],
    tags: [
      376,
      377,
      378,
      379,
      380,
      381,
      382,
      47,
      383,
      384,
      385,
      386,
      387,
      388,
      389,
      390,
      391,
      392,
      393,
      394,
      395,
      396,
      397,
      398,
      399,
      400,
      401,
      402,
      403,
      317,
      404,
      405
    ],
  ),
  "threed": SymbolsMetadata(
    originalName: "3d",
    popularity: 4,
    codepoint: 0xed38,
    categories: [0],
    tags: [
      82,
      406,
      407,
      4,
      264,
      379,
      381,
      7,
      8,
      408,
      409,
      11,
      12,
      270,
      14,
      304,
      410,
      389,
      19,
      411,
      278,
      24,
      412,
      75,
      309,
      330,
      413,
      32,
      414,
      35,
      38,
      415,
      416,
      40,
      41,
      317,
      404,
      417,
      405
    ],
  ),
  "threed_rotation": SymbolsMetadata(
    originalName: "3d_rotation",
    popularity: 1214,
    codepoint: 0xe84d,
    categories: [6],
    tags: [
      82,
      406,
      418,
      407,
      4,
      264,
      379,
      380,
      419,
      381,
      382,
      47,
      8,
      383,
      384,
      269,
      385,
      11,
      14,
      19,
      390,
      411,
      420,
      421,
      24,
      422,
      423,
      424,
      425,
      426,
      395,
      396,
      397,
      399,
      35,
      38,
      415,
      416,
      427,
      402,
      40,
      317,
      404,
      417,
      405
    ],
  ),
  "three_g_mobiledata": SymbolsMetadata(
    originalName: "3g_mobiledata",
    popularity: 193,
    codepoint: 0xefd0,
    categories: [4],
    tags: [
      428,
      4,
      208,
      210,
      429,
      8,
      430,
      212,
      10,
      213,
      11,
      14,
      431,
      215,
      432,
      19,
      219,
      433,
      434,
      221,
      435,
      222,
      223,
      436,
      242,
      24,
      226,
      437,
      227,
      228,
      231,
      35,
      438,
      439,
      38,
      440,
      441,
      40,
      233,
      234,
      442
    ],
  ),
  "three_g_mobiledata_badge": SymbolsMetadata(
    originalName: "3g_mobiledata_badge",
    popularity: 3,
    codepoint: 0xf7f0,
    categories: [4],
    tags: [
      428,
      4,
      6,
      208,
      210,
      429,
      8,
      443,
      430,
      213,
      444,
      445,
      11,
      14,
      16,
      215,
      216,
      19,
      219,
      433,
      434,
      221,
      222,
      223,
      242,
      24,
      226,
      77,
      227,
      228,
      446,
      231,
      32,
      35,
      447,
      38,
      448,
      40,
      233,
      234,
      442
    ],
  ),
  "three_k": SymbolsMetadata(
    originalName: "3k",
    popularity: 86,
    codepoint: 0xe966,
    categories: [0],
    tags: [
      318,
      449,
      450,
      324,
      451,
      452,
      453,
      454,
      455,
      4,
      8,
      11,
      12,
      325,
      14,
      256,
      257,
      52,
      19,
      327,
      24,
      26,
      27,
      285,
      329,
      62,
      30,
      330,
      331,
      310,
      65,
      35,
      38,
      456,
      457,
      40,
      332,
      333,
      41,
      334,
      68,
      292
    ],
  ),
  "three_k_plus": SymbolsMetadata(
    originalName: "3k_plus",
    popularity: 86,
    codepoint: 0xe967,
    categories: [0],
    tags: [
      192,
      451,
      453,
      454,
      186,
      4,
      458,
      6,
      7,
      8,
      9,
      86,
      10,
      11,
      12,
      14,
      274,
      339,
      17,
      19,
      459,
      22,
      341,
      23,
      24,
      26,
      27,
      202,
      29,
      30,
      78,
      32,
      460,
      461,
      35,
      38,
      39,
      462,
      456,
      191,
      40,
      463,
      41
    ],
  ),
  "three_mp": SymbolsMetadata(
    originalName: "3mp",
    popularity: 95,
    codepoint: 0xe968,
    categories: [1],
    tags: [
      82,
      464,
      465,
      7,
      47,
      49,
      11,
      71,
      356,
      14,
      52,
      16,
      53,
      54,
      19,
      466,
      56,
      57,
      58,
      23,
      24,
      59,
      73,
      61,
      26,
      27,
      62,
      177,
      30,
      76,
      65,
      32,
      35,
      38,
      40,
      41,
      292
    ],
  ),
  "three_p": SymbolsMetadata(
    originalName: "3p",
    popularity: 1316,
    codepoint: 0xefd1,
    categories: [7],
    tags: [
      82,
      467,
      468,
      469,
      470,
      471,
      472,
      473,
      474,
      443,
      475,
      476,
      477,
      478,
      479,
      480,
      481,
      482,
      483,
      484,
      135,
      485,
      223,
      486,
      487,
      488,
      489,
      490,
      491,
      31,
      492,
      493,
      494,
      495,
      496,
      497,
      498,
      499,
      500,
      501
    ],
  ),
  "four_g_mobiledata": SymbolsMetadata(
    originalName: "4g_mobiledata",
    popularity: 335,
    codepoint: 0xefd2,
    categories: [4],
    tags: [
      502,
      503,
      4,
      504,
      208,
      210,
      8,
      443,
      211,
      212,
      213,
      445,
      11,
      14,
      505,
      506,
      215,
      19,
      507,
      219,
      433,
      434,
      221,
      222,
      223,
      242,
      24,
      226,
      508,
      227,
      228,
      446,
      231,
      35,
      447,
      38,
      40,
      233,
      234
    ],
  ),
  "four_g_mobiledata_badge": SymbolsMetadata(
    originalName: "4g_mobiledata_badge",
    popularity: 8,
    codepoint: 0xf7ef,
    categories: [4],
    tags: [
      502,
      503,
      4,
      6,
      7,
      208,
      210,
      8,
      443,
      211,
      213,
      445,
      11,
      14,
      505,
      16,
      215,
      432,
      19,
      507,
      219,
      433,
      434,
      221,
      222,
      223,
      24,
      226,
      77,
      227,
      446,
      231,
      32,
      35,
      447,
      38,
      40,
      233,
      234,
      235
    ],
  ),
  "four_g_plus_mobiledata": SymbolsMetadata(
    originalName: "4g_plus_mobiledata",
    popularity: 224,
    codepoint: 0xefd3,
    categories: [4],
    tags: [
      502,
      509,
      4,
      208,
      210,
      429,
      8,
      212,
      213,
      510,
      11,
      511,
      512,
      513,
      14,
      359,
      514,
      215,
      216,
      19,
      507,
      515,
      219,
      433,
      434,
      221,
      516,
      222,
      223,
      517,
      24,
      226,
      437,
      202,
      227,
      228,
      231,
      35,
      38,
      40,
      233,
      234,
      442
    ],
  ),
  "four_k": SymbolsMetadata(
    originalName: "4k",
    popularity: 361,
    codepoint: 0xe072,
    categories: [0],
    tags: [
      450,
      518,
      519,
      520,
      455,
      521,
      4,
      7,
      8,
      11,
      356,
      12,
      337,
      270,
      14,
      522,
      257,
      51,
      52,
      19,
      367,
      278,
      24,
      26,
      27,
      283,
      30,
      330,
      32,
      342,
      35,
      343,
      38,
      344,
      40,
      332,
      523,
      333,
      524,
      41,
      334,
      68
    ],
  ),
  "four_k_plus": SymbolsMetadata(
    originalName: "4k_plus",
    popularity: 160,
    codepoint: 0xe969,
    categories: [0],
    tags: [
      192,
      518,
      520,
      455,
      521,
      525,
      526,
      4,
      527,
      8,
      11,
      12,
      528,
      529,
      270,
      14,
      522,
      257,
      51,
      52,
      530,
      19,
      367,
      278,
      24,
      281,
      26,
      27,
      202,
      531,
      30,
      330,
      310,
      532,
      35,
      38,
      40,
      332,
      523,
      333,
      533,
      41,
      334
    ],
  ),
  "four_mp": SymbolsMetadata(
    originalName: "4mp",
    popularity: 87,
    codepoint: 0xe96a,
    categories: [1],
    tags: [
      534,
      535,
      536,
      537,
      7,
      47,
      114,
      49,
      11,
      14,
      538,
      539,
      256,
      257,
      52,
      53,
      54,
      55,
      19,
      56,
      57,
      58,
      24,
      59,
      61,
      26,
      27,
      62,
      177,
      30,
      65,
      32,
      35,
      38,
      40,
      41,
      334,
      540,
      68,
      292
    ],
  ),
  "five_0mp": SymbolsMetadata(
    originalName: "50mp",
    popularity: 30,
    codepoint: 0xf6f3,
    categories: [1],
    tags: [
      541,
      542,
      543,
      47,
      114,
      115,
      116,
      544,
      545,
      11,
      71,
      529,
      14,
      51,
      52,
      53,
      54,
      19,
      56,
      57,
      58,
      23,
      24,
      281,
      59,
      61,
      119,
      26,
      27,
      62,
      121,
      30,
      78,
      122,
      65,
      136,
      32,
      35,
      38,
      40
    ],
  ),
  "five_g": SymbolsMetadata(
    originalName: "5g",
    popularity: 599,
    codepoint: 0xef38,
    categories: [4],
    tags: [
      546,
      547,
      548,
      4,
      504,
      208,
      210,
      8,
      443,
      211,
      212,
      10,
      11,
      88,
      549,
      14,
      506,
      215,
      432,
      19,
      219,
      433,
      221,
      223,
      550,
      24,
      226,
      227,
      228,
      231,
      35,
      551,
      438,
      439,
      38,
      40,
      233,
      234,
      442
    ],
  ),
  "five_g_mobiledata_badge": SymbolsMetadata(
    originalName: "5g_mobiledata_badge",
    popularity: 13,
    codepoint: 0xf7ee,
    categories: [4],
    tags: [
      546,
      552,
      4,
      6,
      208,
      210,
      8,
      443,
      211,
      212,
      10,
      213,
      444,
      11,
      14,
      359,
      16,
      188,
      215,
      432,
      19,
      219,
      433,
      241,
      221,
      435,
      223,
      550,
      24,
      226,
      227,
      228,
      231,
      553,
      35,
      551,
      438,
      38,
      40,
      233,
      234,
      235
    ],
  ),
  "five_k": SymbolsMetadata(
    originalName: "5k",
    popularity: 98,
    codepoint: 0xe96b,
    categories: [0],
    tags: [
      554,
      555,
      556,
      557,
      558,
      559,
      4,
      349,
      7,
      8,
      11,
      12,
      325,
      560,
      14,
      274,
      256,
      257,
      52,
      19,
      327,
      24,
      281,
      26,
      27,
      285,
      30,
      330,
      331,
      310,
      32,
      35,
      38,
      40,
      332,
      333,
      41,
      334,
      68,
      292
    ],
  ),
  "five_k_plus": SymbolsMetadata(
    originalName: "5k_plus",
    popularity: 91,
    codepoint: 0xe96c,
    categories: [0],
    tags: [
      192,
      554,
      555,
      556,
      561,
      4,
      7,
      8,
      9,
      11,
      12,
      562,
      14,
      274,
      339,
      51,
      52,
      19,
      340,
      327,
      341,
      23,
      24,
      26,
      27,
      202,
      62,
      29,
      30,
      330,
      32,
      35,
      343,
      38,
      563,
      344,
      40,
      332,
      333,
      41,
      68
    ],
  ),
  "five_mp": SymbolsMetadata(
    originalName: "5mp",
    popularity: 97,
    codepoint: 0xe96d,
    categories: [1],
    tags: [
      564,
      565,
      566,
      47,
      114,
      115,
      11,
      14,
      52,
      53,
      54,
      19,
      56,
      57,
      58,
      23,
      24,
      59,
      73,
      61,
      26,
      27,
      285,
      329,
      62,
      177,
      30,
      248,
      310,
      65,
      32,
      35,
      38,
      40,
      41,
      68,
      567
    ],
  ),
  "sixty_fps": SymbolsMetadata(
    originalName: "60fps",
    popularity: 193,
    codepoint: 0xefd4,
    categories: [0],
    tags: [
      568,
      569,
      264,
      47,
      11,
      325,
      270,
      273,
      275,
      276,
      358,
      338,
      570,
      571,
      51,
      359,
      326,
      420,
      23,
      24,
      25,
      189,
      283,
      361,
      572,
      573,
      231,
      35,
      41,
      574,
      291,
      334,
      292
    ],
  ),
  "sixty_fps_select": SymbolsMetadata(
    originalName: "60fps_select",
    popularity: 163,
    codepoint: 0xefd5,
    categories: [1],
    tags: [
      568,
      569,
      47,
      575,
      50,
      273,
      274,
      275,
      358,
      277,
      570,
      51,
      576,
      359,
      420,
      24,
      281,
      282,
      189,
      283,
      284,
      286,
      361,
      103,
      287,
      288,
      371,
      310,
      65,
      572,
      577,
      573,
      231,
      41,
      578,
      579,
      334,
      292
    ],
  ),
  "six_ft_apart": SymbolsMetadata(
    originalName: "6_ft_apart",
    popularity: 442,
    codepoint: 0xf21e,
    categories: [3],
    tags: [
      580,
      581,
      582,
      583,
      419,
      584,
      585,
      586,
      587,
      588,
      589,
      590,
      591,
      592,
      593,
      594,
      595,
      483,
      596,
      597,
      598,
      488,
      489,
      599,
      600,
      601,
      602,
      603,
      604,
      605,
      606,
      607,
      608,
      609,
      610,
      611
    ],
  ),
  "six_k": SymbolsMetadata(
    originalName: "6k",
    popularity: 92,
    codepoint: 0xe96e,
    categories: [0],
    tags: [
      455,
      612,
      613,
      614,
      615,
      616,
      617,
      4,
      7,
      8,
      11,
      12,
      325,
      337,
      270,
      14,
      257,
      51,
      52,
      19,
      618,
      278,
      328,
      24,
      26,
      27,
      62,
      30,
      331,
      32,
      342,
      35,
      38,
      40,
      332,
      523,
      333,
      346,
      41,
      291,
      334,
      68,
      292
    ],
  ),
  "six_k_plus": SymbolsMetadata(
    originalName: "6k_plus",
    popularity: 87,
    codepoint: 0xe96f,
    categories: [0],
    tags: [
      192,
      612,
      613,
      614,
      619,
      4,
      349,
      8,
      11,
      12,
      325,
      14,
      274,
      339,
      257,
      52,
      17,
      19,
      327,
      618,
      341,
      24,
      26,
      27,
      202,
      30,
      330,
      331,
      620,
      621,
      622,
      32,
      35,
      38,
      40,
      332,
      523,
      41,
      334,
      68,
      292
    ],
  ),
  "six_mp": SymbolsMetadata(
    originalName: "6mp",
    popularity: 92,
    codepoint: 0xe970,
    categories: [1],
    tags: [
      580,
      623,
      624,
      625,
      47,
      114,
      116,
      11,
      71,
      181,
      356,
      14,
      51,
      52,
      53,
      55,
      19,
      367,
      56,
      57,
      58,
      23,
      24,
      141,
      61,
      119,
      26,
      27,
      62,
      121,
      30,
      122,
      65,
      32,
      35,
      38,
      40,
      41
    ],
  ),
  "seven_k": SymbolsMetadata(
    originalName: "7k",
    popularity: 106,
    codepoint: 0xe971,
    categories: [0],
    tags: [
      626,
      627,
      628,
      4,
      7,
      8,
      11,
      12,
      325,
      270,
      14,
      256,
      257,
      17,
      19,
      278,
      328,
      24,
      26,
      27,
      285,
      329,
      62,
      30,
      330,
      331,
      310,
      65,
      629,
      630,
      32,
      35,
      38,
      40,
      332,
      333,
      41,
      291,
      334,
      68
    ],
  ),
  "seven_k_plus": SymbolsMetadata(
    originalName: "7k_plus",
    popularity: 86,
    codepoint: 0xe972,
    categories: [0],
    tags: [
      192,
      626,
      627,
      628,
      631,
      632,
      4,
      458,
      6,
      349,
      7,
      8,
      9,
      11,
      12,
      14,
      274,
      339,
      188,
      17,
      633,
      18,
      19,
      634,
      22,
      341,
      23,
      24,
      26,
      27,
      202,
      29,
      30,
      330,
      630,
      32,
      461,
      35,
      38,
      462,
      191,
      40,
      523,
      635,
      41,
      334
    ],
  ),
  "seven_mp": SymbolsMetadata(
    originalName: "7mp",
    popularity: 96,
    codepoint: 0xe973,
    categories: [1],
    tags: [
      636,
      637,
      638,
      639,
      47,
      48,
      49,
      116,
      11,
      71,
      14,
      52,
      53,
      54,
      55,
      19,
      367,
      56,
      57,
      58,
      23,
      640,
      24,
      73,
      141,
      61,
      26,
      27,
      62,
      177,
      30,
      122,
      65,
      641,
      32,
      35,
      38,
      40,
      41,
      334,
      68
    ],
  ),
  "eight_k": SymbolsMetadata(
    originalName: "8k",
    popularity: 150,
    codepoint: 0xe974,
    categories: [0],
    tags: [
      642,
      643,
      644,
      617,
      645,
      4,
      8,
      544,
      545,
      11,
      356,
      12,
      337,
      14,
      256,
      257,
      52,
      53,
      19,
      367,
      327,
      24,
      119,
      26,
      27,
      30,
      330,
      646,
      342,
      647,
      35,
      343,
      38,
      344,
      40,
      332,
      523,
      333,
      346,
      41,
      648,
      334
    ],
  ),
  "eight_k_plus": SymbolsMetadata(
    originalName: "8k_plus",
    popularity: 112,
    codepoint: 0xe975,
    categories: [0],
    tags: [
      192,
      626,
      644,
      617,
      649,
      650,
      651,
      645,
      652,
      4,
      8,
      11,
      12,
      653,
      654,
      14,
      274,
      257,
      51,
      52,
      655,
      19,
      367,
      24,
      656,
      26,
      27,
      202,
      531,
      30,
      64,
      330,
      331,
      65,
      32,
      35,
      38,
      40,
      332,
      523,
      41,
      657,
      334,
      68,
      292
    ],
  ),
  "eight_mp": SymbolsMetadata(
    originalName: "8mp",
    popularity: 93,
    codepoint: 0xe976,
    categories: [1],
    tags: [
      658,
      659,
      660,
      47,
      115,
      116,
      11,
      71,
      661,
      529,
      14,
      51,
      52,
      53,
      54,
      19,
      662,
      56,
      57,
      58,
      663,
      24,
      281,
      59,
      61,
      26,
      27,
      62,
      177,
      30,
      248,
      78,
      122,
      65,
      32,
      35,
      38,
      40,
      41
    ],
  ),
  "nine_k": SymbolsMetadata(
    originalName: "9k",
    popularity: 101,
    codepoint: 0xe977,
    categories: [0],
    tags: [
      664,
      665,
      666,
      667,
      4,
      8,
      10,
      668,
      11,
      12,
      337,
      14,
      51,
      52,
      17,
      669,
      19,
      367,
      670,
      671,
      672,
      24,
      26,
      27,
      62,
      30,
      330,
      673,
      674,
      342,
      35,
      38,
      40,
      332,
      333,
      346,
      41,
      334,
      68
    ],
  ),
  "nine_k_plus": SymbolsMetadata(
    originalName: "9k_plus",
    popularity: 103,
    codepoint: 0xe978,
    categories: [0],
    tags: [
      192,
      675,
      665,
      666,
      667,
      676,
      4,
      7,
      8,
      9,
      11,
      12,
      337,
      14,
      274,
      339,
      52,
      17,
      19,
      367,
      340,
      341,
      23,
      24,
      26,
      27,
      283,
      202,
      29,
      30,
      330,
      32,
      342,
      35,
      38,
      462,
      40,
      332,
      333,
      41,
      334,
      68
    ],
  ),
  "nine_mp": SymbolsMetadata(
    originalName: "9mp",
    popularity: 102,
    codepoint: 0xe979,
    categories: [1],
    tags: [
      677,
      678,
      679,
      680,
      7,
      47,
      114,
      49,
      11,
      71,
      681,
      14,
      51,
      52,
      53,
      54,
      55,
      19,
      56,
      57,
      58,
      682,
      23,
      683,
      24,
      59,
      141,
      61,
      119,
      26,
      27,
      62,
      30,
      65,
      32,
      35,
      38,
      40
    ],
  ),
  "abc": SymbolsMetadata(
    popularity: 1491,
    codepoint: 0xeb94,
    categories: [2],
    tags: [
      684,
      685,
      186,
      686,
      687,
      4,
      688,
      689,
      690,
      691,
      8,
      692,
      693,
      694,
      695,
      696,
      14,
      697,
      698,
      19,
      485,
      699,
      700,
      701,
      35,
      38,
      40,
      702,
      703,
      704
    ],
  ),
  "ac_unit": SymbolsMetadata(
    popularity: 3143,
    codepoint: 0xeb3b,
    categories: [8],
    tags: [
      705,
      706,
      707,
      708,
      709,
      710,
      711,
      712,
      713,
      714,
      715,
      716,
      717,
      718,
      719,
      720,
      721,
      722,
      723,
      724,
      725,
      726,
      727,
      728,
      729,
      635,
      730,
      731,
      732
    ],
  ),
  "accessibility": SymbolsMetadata(
    popularity: 1961,
    codepoint: 0xe84e,
    categories: [6],
    tags: [
      733,
      734,
      468,
      735,
      736,
      737,
      738,
      739,
      740,
      584,
      741,
      742,
      743,
      744,
      482,
      483,
      745,
      746,
      747,
      748,
      656,
      488,
      489,
      329,
      490,
      749,
      65,
      750,
      495,
      751,
      752,
      501,
      753
    ],
  ),
  "accessibility_new": SymbolsMetadata(
    popularity: 3540,
    codepoint: 0xe92c,
    categories: [6],
    tags: [
      754,
      755,
      733,
      756,
      734,
      735,
      757,
      738,
      758,
      584,
      741,
      744,
      482,
      483,
      745,
      759,
      746,
      760,
      761,
      762,
      763,
      764,
      765,
      488,
      489,
      749,
      750,
      495,
      752,
      501,
      753,
      766
    ],
  ),
  "accessible": SymbolsMetadata(
    popularity: 2273,
    codepoint: 0xe914,
    categories: [6],
    tags: [
      755,
      733,
      734,
      735,
      738,
      758,
      739,
      740,
      584,
      383,
      741,
      767,
      744,
      768,
      482,
      483,
      769,
      747,
      760,
      770,
      488,
      489,
      771,
      772,
      495,
      752,
      501,
      753,
      773,
      774
    ],
  ),
  "accessible_forward": SymbolsMetadata(
    popularity: 1134,
    codepoint: 0xe934,
    categories: [6],
    tags: [
      755,
      733,
      734,
      775,
      758,
      584,
      383,
      776,
      388,
      741,
      767,
      777,
      744,
      768,
      482,
      483,
      760,
      770,
      778,
      779,
      421,
      780,
      488,
      489,
      781,
      28,
      782,
      501,
      773,
      774
    ],
  ),
  "accessible_menu": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf34e,
    categories: [2],
    tags: [
      783,
      733,
      734,
      784,
      468,
      738,
      584,
      785,
      132,
      741,
      786,
      787,
      483,
      760,
      135,
      788,
      789,
      421,
      764,
      656,
      488,
      489,
      790,
      329,
      490,
      65,
      791,
      752,
      501,
      792,
      766
    ],
  ),
  "account_balance": SymbolsMetadata(
    popularity: 11593,
    codepoint: 0xe84f,
    categories: [9],
    tags: [
      468,
      793,
      794,
      795,
      796,
      797,
      798,
      799,
      800,
      801,
      802,
      803,
      804,
      805,
      806,
      807,
      808,
      809,
      810,
      811,
      812,
      813,
      814,
      815,
      816,
      817,
      818,
      819,
      820,
      821,
      822,
      823,
      824,
      825,
      826
    ],
  ),
  "account_balance_wallet": SymbolsMetadata(
    popularity: 10261,
    codepoint: 0xe850,
    categories: [9],
    tags: [
      468,
      793,
      794,
      795,
      796,
      797,
      827,
      828,
      799,
      800,
      383,
      801,
      803,
      805,
      829,
      806,
      830,
      831,
      807,
      832,
      833,
      834,
      808,
      835,
      811,
      818,
      819,
      836,
      820,
      821,
      837,
      838,
      839,
      840,
      75,
      824,
      841,
      32,
      842,
      843
    ],
  ),
  "account_box": SymbolsMetadata(
    popularity: 5292,
    codepoint: 0xe851,
    categories: [6],
    tags: [
      468,
      844,
      845,
      470,
      7,
      846,
      383,
      475,
      847,
      848,
      479,
      849,
      483,
      850,
      53,
      851,
      852,
      853,
      488,
      489,
      790,
      59,
      119,
      854,
      490,
      855,
      856,
      78,
      857,
      32,
      858,
      501,
      859,
      860
    ],
  ),
  "account_child": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xe852,
    categories: [6],
    tags: [
      468,
      845,
      861,
      584,
      862,
      863,
      864,
      865,
      383,
      866,
      867,
      868,
      869,
      483,
      870,
      871,
      872,
      873,
      874,
      875,
      876,
      488,
      489,
      490,
      877,
      878,
      501,
      879,
      880
    ],
  ),
  "account_child_invert": SymbolsMetadata(
    popularity: 79,
    codepoint: 0xe659,
    categories: [6],
    tags: [
      755,
      468,
      845,
      470,
      584,
      862,
      863,
      864,
      865,
      866,
      867,
      868,
      869,
      483,
      881,
      870,
      871,
      852,
      873,
      874,
      875,
      876,
      488,
      489,
      490,
      877,
      882,
      501,
      879,
      883,
      880
    ],
  ),
  "account_circle": SymbolsMetadata(
    popularity: 67549,
    codepoint: 0xe853,
    categories: [6],
    tags: [
      468,
      884,
      845,
      470,
      383,
      475,
      479,
      483,
      850,
      885,
      135,
      852,
      853,
      886,
      488,
      489,
      887,
      790,
      888,
      854,
      329,
      490,
      855,
      889,
      65,
      857,
      858,
      501,
      890,
      891,
      860
    ],
  ),
  "account_circle_off": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xf7b3,
    categories: [6],
    tags: [
      892,
      468,
      893,
      470,
      894,
      895,
      383,
      896,
      897,
      767,
      898,
      479,
      899,
      900,
      483,
      901,
      902,
      903,
      904,
      905,
      906,
      907,
      908,
      909,
      488,
      489,
      490,
      910,
      911,
      912,
      913,
      914,
      858,
      915,
      501,
      916
    ],
  ),
  "account_tree": SymbolsMetadata(
    popularity: 7382,
    codepoint: 0xe97a,
    categories: [9],
    tags: [
      468,
      917,
      5,
      918,
      919,
      920,
      862,
      921,
      922,
      211,
      10,
      923,
      924,
      925,
      926,
      927,
      928,
      929,
      930,
      931,
      932,
      933,
      934,
      935,
      936,
      597,
      937,
      938,
      223,
      939,
      940,
      941,
      874,
      942,
      943,
      32,
      944,
      33,
      945,
      946,
      947,
      948
    ],
  ),
  "action_key": SymbolsMetadata(
    popularity: 139,
    codepoint: 0xf502,
    categories: [2],
    tags: [
      755,
      949,
      950,
      951,
      952,
      953,
      954,
      694,
      445,
      955,
      956,
      957,
      958,
      959,
      960,
      961,
      962,
      963,
      964,
      246,
      965,
      966,
      967,
      968,
      969,
      970,
      971,
      972,
      973,
      974,
      975,
      976,
      977,
      978,
      979,
      980,
      981,
      982,
      983,
      984,
      985,
      986
    ],
  ),
  "activity_zone": SymbolsMetadata(
    popularity: 436,
    codepoint: 0xe1e6,
    categories: [10],
    tags: [
      987,
      988,
      989,
      990,
      991,
      992,
      993,
      994,
      921,
      211,
      995,
      996,
      997,
      998,
      999,
      1000,
      1001,
      1002,
      1003,
      1004,
      223,
      1005,
      939,
      1006,
      1007,
      1008,
      1009,
      1010,
      1011,
      1012,
      371,
      32,
      1013
    ],
  ),
  "acute": SymbolsMetadata(
    popularity: 274,
    codepoint: 0xe4cb,
    categories: [2],
    tags: [
      989,
      1014,
      469,
      1015,
      383,
      1016,
      1017,
      1018,
      1019,
      1020,
      1021,
      1022,
      595,
      1023,
      1024,
      1025,
      486,
      1026,
      28,
      1027,
      1028,
      1029,
      1030,
      1031,
      1032,
      231,
      441,
      289,
      1033,
      947,
      1034
    ],
  ),
  "ad": SymbolsMetadata(
    popularity: 111,
    codepoint: 0xe65a,
    categories: [6],
    tags: [
      1035,
      1036,
      1037,
      469,
      1038,
      1039,
      1040,
      1041,
      1042,
      1043,
      12,
      274,
      1044,
      215,
      1045,
      367,
      486,
      1046,
      1047,
      1048,
      1049,
      1050,
      75,
      190,
      1051,
      32,
      1052,
      1053,
      1054
    ],
  ),
  "ad_group": SymbolsMetadata(
    popularity: 121,
    codepoint: 0xe65b,
    categories: [6],
    tags: [
      1035,
      1055,
      526,
      1056,
      1037,
      1057,
      1058,
      1059,
      1060,
      1039,
      1040,
      1061,
      921,
      1062,
      1063,
      930,
      215,
      1064,
      1065,
      1066,
      935,
      1045,
      1067,
      1068,
      1050,
      75,
      32,
      107,
      1069,
      1070,
      1071,
      1053,
      1054
    ],
  ),
  "ad_group_off": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xeae5,
    categories: [6],
    tags: [
      1072,
      1035,
      1055,
      1037,
      1073,
      1074,
      894,
      1040,
      895,
      1075,
      896,
      1076,
      897,
      1077,
      767,
      930,
      1078,
      900,
      1045,
      1079,
      1080,
      907,
      1081,
      1082,
      1050,
      75,
      911,
      65,
      914,
      32,
      1083,
      1084
    ],
  ),
  "ad_off": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf7b2,
    categories: [6],
    tags: [
      1035,
      1085,
      1086,
      1087,
      1088,
      1089,
      1037,
      1090,
      1091,
      1092,
      1038,
      1093,
      1094,
      1039,
      895,
      1095,
      1096,
      1097,
      767,
      898,
      899,
      1098,
      1099,
      215,
      1079,
      1100,
      1101,
      907,
      908,
      909,
      1102,
      1103,
      914,
      32,
      1104,
      1105,
      1106,
      1107,
      1108,
      1053,
      1054
    ],
  ),
  "ad_units": SymbolsMetadata(
    popularity: 791,
    codepoint: 0xef39,
    categories: [11],
    tags: [
      1109,
      1110,
      1035,
      1111,
      1112,
      1073,
      1038,
      1040,
      1113,
      208,
      472,
      443,
      1042,
      897,
      445,
      1043,
      696,
      965,
      1114,
      1045,
      485,
      1115,
      1116,
      219,
      1117,
      1118,
      1119,
      486,
      1120,
      226,
      75,
      911,
      1121,
      1122,
      447,
      38,
      1123,
      1124,
      1125
    ],
  ),
  "adaptive_audio_mic": SymbolsMetadata(
    popularity: 152,
    codepoint: 0xf4cc,
    categories: [0],
    tags: [
      468,
      1126,
      1127,
      1128,
      1129,
      1130,
      1131,
      1132,
      1133,
      1134,
      443,
      1135,
      445,
      1136,
      479,
      867,
      1137,
      1138,
      930,
      1139,
      1140,
      483,
      1141,
      966,
      1142,
      969,
      1143,
      1144,
      1145,
      1146,
      1147,
      223,
      1148,
      1149,
      1150,
      488,
      489,
      1151,
      1152,
      490,
      1153,
      121,
      1154,
      177,
      1155,
      607,
      1156,
      492,
      1157,
      496,
      946,
      1158,
      501,
      1159,
      1160,
      1161,
      1162
    ],
  ),
  "adaptive_audio_mic_off": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf4cb,
    categories: [0],
    tags: [
      468,
      1126,
      1127,
      1163,
      1129,
      1130,
      1133,
      1134,
      443,
      1135,
      1136,
      1077,
      767,
      479,
      867,
      1137,
      1138,
      930,
      1139,
      1140,
      483,
      1141,
      969,
      1144,
      1145,
      1146,
      1147,
      1164,
      1165,
      223,
      1166,
      1167,
      1168,
      1169,
      1148,
      907,
      488,
      489,
      1151,
      490,
      1153,
      121,
      1154,
      1170,
      1171,
      607,
      1156,
      1157,
      1172,
      493,
      496,
      946,
      501,
      1159,
      1160,
      1173,
      1161
    ],
  ),
  "adb": SymbolsMetadata(
    popularity: 895,
    codepoint: 0xe60e,
    categories: [4],
    tags: [
      1174,
      1175,
      1176,
      1177,
      1178,
      1179,
      1180,
      1181,
      584,
      1182,
      1183,
      1184,
      1185,
      1186,
      1187,
      445,
      1188,
      1189,
      1190,
      219,
      1191,
      1192,
      1193,
      1194,
      1195,
      446,
      1196,
      447,
      551
    ],
  ),
  "add": SymbolsMetadata(
    popularity: 72454,
    codepoint: 0xe145,
    categories: [2],
    tags: [
      192,
      526,
      1197,
      1057,
      1198,
      1199,
      1200,
      1061,
      1201,
      1202,
      787,
      1203,
      1204,
      1205,
      1206,
      1207,
      1044,
      1208,
      1209,
      1064,
      1210,
      763,
      1211,
      202,
      1212,
      1213,
      461,
      35,
      1214,
      1215
    ],
  ),
  "add_2": SymbolsMetadata(
    popularity: 129,
    codepoint: 0xf3dd,
    categories: [2],
    tags: [
      192,
      526,
      1197,
      1057,
      1198,
      1058,
      1061,
      1201,
      1202,
      1216,
      787,
      1204,
      1205,
      1206,
      1207,
      1217,
      1044,
      1218,
      1209,
      1064,
      1210,
      763,
      1211,
      202,
      1212,
      1213,
      461,
      35,
      1214,
      1215
    ],
  ),
  "add_a_photo": SymbolsMetadata(
    popularity: 6339,
    codepoint: 0xe439,
    categories: [1],
    tags: [
      192,
      1219,
      526,
      1220,
      1221,
      1222,
      1223,
      47,
      48,
      116,
      383,
      1042,
      1201,
      53,
      1224,
      966,
      1044,
      126,
      367,
      763,
      59,
      60,
      61,
      119,
      1225,
      202,
      1212,
      75,
      32,
      35,
      346
    ],
  ),
  "add_ad": SymbolsMetadata(
    popularity: 64,
    codepoint: 0xe72a,
    categories: [6],
    tags: [
      192,
      1035,
      526,
      1226,
      1227,
      1228,
      1037,
      1229,
      1230,
      1039,
      1201,
      1231,
      1232,
      1233,
      1206,
      1044,
      215,
      1045,
      763,
      1234,
      1235,
      1236,
      1237,
      202,
      1238,
      1050,
      1239,
      1240,
      1241,
      1053,
      1054
    ],
  ),
  "add_alert": SymbolsMetadata(
    popularity: 1113,
    codepoint: 0xe003,
    categories: [6],
    tags: [
      192,
      1242,
      526,
      1243,
      1244,
      469,
      1245,
      1246,
      1247,
      1248,
      1201,
      1249,
      1250,
      1251,
      763,
      1252,
      486,
      1253,
      1120,
      1254,
      202,
      1255,
      1256,
      1030,
      1257,
      227,
      857,
      1156,
      1258,
      1259,
      35,
      1260,
      1034,
      1261
    ],
  ),
  "add_box": SymbolsMetadata(
    popularity: 10875,
    codepoint: 0xe146,
    categories: [2],
    tags: [
      526,
      1262,
      1263,
      1264,
      1265,
      1266,
      1267,
      1057,
      1268,
      7,
      1269,
      1201,
      1270,
      1271,
      1206,
      1272,
      1044,
      1273,
      763,
      1274,
      1275,
      1276,
      202,
      1277,
      1212,
      1278,
      32,
      35
    ],
  ),
  "add_business": SymbolsMetadata(
    popularity: 2102,
    codepoint: 0xe729,
    categories: [9],
    tags: [
      192,
      526,
      1279,
      1280,
      1281,
      1282,
      1283,
      797,
      798,
      1284,
      799,
      800,
      801,
      803,
      1285,
      1201,
      1286,
      1287,
      1288,
      1289,
      805,
      806,
      807,
      1290,
      1291,
      1292,
      818,
      763,
      1293,
      1294,
      1295,
      819,
      940,
      820,
      821,
      202,
      1212,
      1296,
      1297,
      841,
      1298,
      1299,
      35,
      1300
    ],
  ),
  "add_call": SymbolsMetadata(
    popularity: 830,
    codepoint: 0xe0e8,
    categories: [7],
    tags: [
      192,
      526,
      1301,
      1302,
      1303,
      1304,
      1133,
      1113,
      443,
      1305,
      1135,
      1306,
      475,
      1307,
      445,
      1308,
      1309,
      965,
      1206,
      1310,
      1311,
      1312,
      1313,
      1314,
      219,
      763,
      1315,
      226,
      1316,
      202,
      1317,
      1318,
      1319,
      35,
      1320
    ],
  ),
  "add_card": SymbolsMetadata(
    popularity: 2063,
    codepoint: 0xeb86,
    categories: [9],
    tags: [
      192,
      526,
      1321,
      1322,
      1323,
      1223,
      1324,
      796,
      797,
      1325,
      799,
      800,
      1326,
      801,
      803,
      1327,
      805,
      829,
      1328,
      806,
      830,
      807,
      1329,
      808,
      1330,
      1331,
      1332,
      818,
      763,
      1333,
      1334,
      819,
      820,
      821,
      1335,
      1336,
      202,
      1212,
      1337,
      75,
      1338,
      841,
      35
    ],
  ),
  "add_chart": SymbolsMetadata(
    popularity: 957,
    codepoint: 0xe97b,
    categories: [9],
    tags: [
      192,
      526,
      1339,
      1340,
      1341,
      1342,
      5,
      1343,
      1344,
      1345,
      365,
      920,
      1201,
      1346,
      10,
      924,
      1347,
      929,
      933,
      1044,
      1348,
      597,
      937,
      763,
      1349,
      1350,
      202,
      1351,
      1352,
      1353,
      1354,
      33,
      35,
      947,
      1355
    ],
  ),
  "add_circle": SymbolsMetadata(
    popularity: 41071,
    codepoint: 0xe147,
    categories: [2],
    tags: [
      192,
      526,
      1356,
      1357,
      1057,
      1058,
      298,
      383,
      1358,
      1359,
      269,
      1360,
      86,
      1201,
      1271,
      787,
      1206,
      1207,
      1044,
      1064,
      1210,
      789,
      763,
      1361,
      202,
      1362,
      1363,
      1213,
      461,
      1364
    ],
  ),
  "add_column_left": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf425,
    categories: [12],
    tags: [
      192,
      526,
      1365,
      1366,
      1367,
      1368,
      1369,
      802,
      1042,
      1201,
      299,
      1370,
      1347,
      1371,
      1372,
      246,
      1044,
      1373,
      1374,
      306,
      1375,
      763,
      1211,
      98,
      1068,
      202,
      1376,
      1377,
      1378,
      1379,
      35,
      1380,
      1381,
      317,
      1053,
      1054
    ],
  ),
  "add_column_right": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf424,
    categories: [12],
    tags: [
      192,
      526,
      1365,
      1382,
      1383,
      1057,
      1368,
      1384,
      802,
      299,
      787,
      1385,
      1386,
      1372,
      246,
      1387,
      1207,
      1388,
      1389,
      1044,
      1373,
      1390,
      306,
      1391,
      763,
      1392,
      1393,
      1211,
      202,
      1394,
      1395,
      1396,
      1376,
      1377,
      1397,
      1379,
      35,
      1380,
      1398,
      1381,
      317,
      1053
    ],
  ),
  "add_comment": SymbolsMetadata(
    popularity: 2174,
    codepoint: 0xe266,
    categories: [7],
    tags: [
      192,
      526,
      1399,
      1400,
      471,
      472,
      1401,
      473,
      474,
      443,
      476,
      1402,
      1403,
      1202,
      477,
      480,
      481,
      1404,
      1405,
      485,
      1406,
      763,
      1407,
      1408,
      202,
      1212,
      1409,
      1410,
      1411,
      77,
      31,
      493,
      494,
      1412,
      35
    ],
  ),
  "add_diamond": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf49c,
    categories: [11],
    tags: [
      192,
      1413,
      526,
      1414,
      1264,
      1357,
      1057,
      1201,
      1415,
      1271,
      1202,
      1416,
      1417,
      787,
      1418,
      1204,
      1206,
      1207,
      1044,
      1419,
      763,
      1420,
      1211,
      202,
      1212,
      1421,
      1422,
      1423,
      32,
      35,
      1424
    ],
  ),
  "add_home": SymbolsMetadata(
    popularity: 390,
    codepoint: 0xf8eb,
    categories: [5],
    tags: [
      526,
      1425,
      1426,
      1427,
      1428,
      1429,
      798,
      1430,
      1431,
      1432,
      1433,
      1434,
      867,
      999,
      1435,
      1436,
      1001,
      1437,
      1438,
      1439,
      1440,
      202,
      1441,
      1442,
      1443,
      1444,
      1445,
      1446,
      1447
    ],
  ),
  "add_home_work": SymbolsMetadata(
    popularity: 325,
    codepoint: 0xf8ed,
    categories: [5],
    tags: [
      526,
      1448,
      1426,
      1449,
      1450,
      798,
      1201,
      1451,
      1430,
      1431,
      1452,
      999,
      1453,
      1435,
      763,
      1454,
      1437,
      1438,
      1455,
      1456,
      202,
      1457,
      1441,
      1442,
      1458,
      1446,
      1459,
      1460
    ],
  ),
  "add_link": SymbolsMetadata(
    popularity: 1450,
    codepoint: 0xe178,
    categories: [12],
    tags: [
      526,
      1461,
      1462,
      1463,
      1464,
      1058,
      1465,
      1466,
      1467,
      1468,
      1469,
      921,
      211,
      1470,
      1471,
      1472,
      1473,
      1474,
      1064,
      935,
      1475,
      763,
      1476,
      1477,
      202,
      1478,
      35,
      1479,
      1480,
      1053
    ],
  ),
  "add_location": SymbolsMetadata(
    popularity: 2801,
    codepoint: 0xe567,
    categories: [5],
    tags: [
      192,
      526,
      1481,
      1482,
      1429,
      1483,
      1484,
      388,
      955,
      1485,
      958,
      960,
      1486,
      1487,
      1488,
      1489,
      1001,
      1002,
      1490,
      1491,
      21,
      421,
      763,
      1492,
      1493,
      1494,
      1495,
      202,
      1363,
      1496,
      1497,
      1498,
      1083,
      35,
      947
    ],
  ),
  "add_location_alt": SymbolsMetadata(
    popularity: 1717,
    codepoint: 0xef3a,
    categories: [5],
    tags: [
      192,
      526,
      1481,
      1429,
      1499,
      1201,
      1484,
      388,
      955,
      1500,
      958,
      960,
      1486,
      1487,
      1488,
      1501,
      1489,
      1001,
      1002,
      1490,
      21,
      421,
      763,
      1492,
      1493,
      1494,
      1495,
      202,
      1502,
      1363,
      1496,
      1503,
      1083,
      35,
      1504
    ],
  ),
  "add_moderator": SymbolsMetadata(
    popularity: 617,
    codepoint: 0xe97d,
    categories: [13],
    tags: [
      192,
      755,
      526,
      1505,
      1506,
      1507,
      1508,
      1509,
      6,
      1510,
      194,
      269,
      481,
      1511,
      930,
      936,
      1512,
      763,
      1513,
      819,
      1514,
      202,
      1515,
      1516,
      1517,
      1518,
      1519,
      1520,
      1521,
      1011,
      1522,
      31,
      35,
      946,
      501,
      1523
    ],
  ),
  "add_notes": SymbolsMetadata(
    popularity: 112,
    codepoint: 0xe091,
    categories: [12],
    tags: [
      192,
      526,
      1341,
      1524,
      1228,
      693,
      1525,
      1201,
      1526,
      1527,
      1232,
      1528,
      1347,
      696,
      1529,
      1530,
      366,
      92,
      763,
      1350,
      1531,
      1236,
      1532,
      1533,
      1534,
      1535,
      202,
      1212,
      107,
      38,
      1536,
      1537
    ],
  ),
  "add_photo_alternate": SymbolsMetadata(
    popularity: 4165,
    codepoint: 0xe43e,
    categories: [1],
    tags: [
      192,
      526,
      1220,
      1221,
      1222,
      1538,
      1539,
      1058,
      1042,
      1540,
      1201,
      1541,
      53,
      1542,
      966,
      1044,
      1543,
      367,
      1544,
      1545,
      763,
      59,
      61,
      119,
      202,
      1212,
      1546,
      32,
      35,
      441,
      346
    ],
  ),
  "add_reaction": SymbolsMetadata(
    popularity: 2556,
    codepoint: 0xe1d3,
    categories: [3],
    tags: [
      192,
      526,
      1547,
      1548,
      1549,
      472,
      383,
      473,
      443,
      478,
      1550,
      1551,
      1552,
      1553,
      1554,
      479,
      480,
      1555,
      481,
      1556,
      1557,
      1558,
      16,
      1559,
      1044,
      1560,
      1561,
      763,
      1562,
      489,
      1563,
      202,
      1213,
      102,
      1564,
      1565,
      1566,
      1567,
      1568,
      1569,
      607,
      31,
      495,
      1570,
      35
    ],
  ),
  "add_road": SymbolsMetadata(
    popularity: 752,
    codepoint: 0xef3b,
    categories: [5],
    tags: [
      192,
      526,
      1571,
      1572,
      1573,
      1574,
      1575,
      1576,
      1202,
      1577,
      1484,
      388,
      1578,
      1579,
      1488,
      1580,
      1581,
      366,
      1002,
      1490,
      421,
      763,
      1582,
      1583,
      1584,
      1585,
      1586,
      202,
      1212,
      1587,
      1588,
      1083,
      1589,
      35,
      441,
      1590,
      1591,
      1592
    ],
  ),
  "add_row_above": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf423,
    categories: [12],
    tags: [
      192,
      1593,
      526,
      1594,
      1595,
      1596,
      1368,
      802,
      1201,
      1202,
      10,
      299,
      1597,
      1598,
      1372,
      246,
      1044,
      1599,
      1600,
      1601,
      306,
      1602,
      92,
      763,
      1211,
      202,
      1212,
      1603,
      1376,
      1379,
      1604,
      32,
      35,
      1380,
      1605,
      441,
      1124,
      1381,
      317,
      1053
    ],
  ),
  "add_row_below": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf422,
    categories: [12],
    tags: [
      192,
      526,
      1606,
      1595,
      1596,
      1057,
      1368,
      802,
      1201,
      1202,
      10,
      1607,
      299,
      787,
      1372,
      246,
      1044,
      1608,
      1600,
      1601,
      306,
      1602,
      1609,
      763,
      1610,
      1611,
      1211,
      202,
      1212,
      1603,
      1612,
      1376,
      1379,
      1604,
      35,
      1380,
      1605,
      1381,
      317,
      1053
    ],
  ),
  "add_shopping_cart": SymbolsMetadata(
    popularity: 6974,
    codepoint: 0xe854,
    categories: [9],
    tags: [
      526,
      1264,
      1613,
      1614,
      1615,
      1616,
      1617,
      1618,
      799,
      1619,
      800,
      1326,
      801,
      803,
      805,
      806,
      807,
      1329,
      1620,
      1291,
      818,
      1275,
      819,
      1621,
      96,
      820,
      821,
      202,
      1622,
      840,
      1623,
      1296,
      1297,
      841,
      1624,
      1298,
      1625,
      1626
    ],
  ),
  "add_task": SymbolsMetadata(
    popularity: 4213,
    codepoint: 0xf23a,
    categories: [2],
    tags: [
      192,
      1627,
      526,
      1628,
      1267,
      1549,
      1629,
      1630,
      1631,
      1632,
      383,
      1633,
      1634,
      1635,
      1636,
      1637,
      1201,
      1638,
      1639,
      1640,
      1207,
      1641,
      763,
      1642,
      1643,
      202,
      1212,
      1644,
      288,
      1412,
      1645,
      1646,
      1647,
      1648,
      1649,
      1650
    ],
  ),
  "add_to_drive": SymbolsMetadata(
    popularity: 739,
    codepoint: 0xe65c,
    categories: [12],
    tags: [
      526,
      1229,
      1057,
      1230,
      1651,
      1652,
      1653,
      1540,
      1201,
      10,
      1347,
      1654,
      1530,
      1655,
      1656,
      1657,
      1658,
      1659,
      1189,
      1660,
      1661,
      1542,
      1206,
      1044,
      763,
      202,
      1662,
      1663,
      1664,
      311,
      1665,
      982,
      1666,
      674,
      1412,
      1667,
      346
    ],
  ),
  "add_to_home_screen": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xe1fe,
    categories: [11],
    tags: [
      1109,
      1110,
      949,
      526,
      1668,
      1669,
      1229,
      1230,
      380,
      1670,
      1113,
      445,
      1671,
      388,
      787,
      1672,
      1673,
      965,
      999,
      1114,
      1674,
      219,
      1675,
      421,
      226,
      1493,
      75,
      782,
      1664,
      330,
      1665,
      982,
      446,
      32,
      35,
      447,
      1676,
      1677,
      346
    ],
    rtlAutoMirrored: true,
  ),
  "add_to_queue": SymbolsMetadata(
    popularity: 536,
    codepoint: 0xe05c,
    categories: [0],
    tags: [
      192,
      1109,
      1110,
      526,
      1678,
      1679,
      1267,
      1680,
      1681,
      1682,
      1683,
      1057,
      1684,
      694,
      1201,
      1202,
      1685,
      445,
      12,
      1686,
      965,
      1114,
      1206,
      1044,
      1687,
      327,
      763,
      202,
      1212,
      100,
      330,
      342,
      35,
      1645,
      1688,
      343,
      1689,
      344,
      1690,
      1691,
      1054
    ],
  ),
  "add_triangle": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf48e,
    categories: [5],
    tags: [
      192,
      526,
      1692,
      469,
      1057,
      380,
      1693,
      1201,
      1694,
      388,
      787,
      304,
      1204,
      1206,
      1207,
      1044,
      1695,
      421,
      763,
      1211,
      1696,
      202,
      1697,
      1698,
      311,
      1699,
      35,
      1700,
      1590,
      1701,
      1702,
      1703,
      1704,
      1261
    ],
  ),
  "adf_scanner": SymbolsMetadata(
    popularity: 244,
    codepoint: 0xeada,
    categories: [11],
    tags: [
      1705,
      1706,
      383,
      1707,
      1708,
      445,
      181,
      1709,
      1347,
      1710,
      832,
      1711,
      1712,
      1713,
      1714,
      1715,
      965,
      53,
      1716,
      966,
      1717,
      1718,
      1456,
      1719,
      1534,
      1535,
      1720,
      1721,
      1722,
      75,
      1723,
      1724,
      32,
      551
    ],
  ),
  "adjust": SymbolsMetadata(
    popularity: 1676,
    codepoint: 0xe39e,
    categories: [1],
    tags: [
      1725,
      1128,
      1726,
      1129,
      1727,
      794,
      1728,
      1729,
      1730,
      1731,
      383,
      953,
      1732,
      1733,
      1734,
      269,
      1735,
      1736,
      832,
      696,
      1737,
      1738,
      53,
      1739,
      934,
      1740,
      778,
      656,
      1741,
      329,
      1742,
      65,
      1743,
      1156,
      36,
      1744,
      1745
    ],
  ),
  "admin_meds": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xe48d,
    categories: [3],
    tags: [
      1507,
      1746,
      1747,
      1748,
      1749,
      1750,
      1751,
      1347,
      1752,
      696,
      595,
      1753,
      1754,
      92,
      1755,
      1756,
      1757,
      1758,
      1759,
      1760,
      1761,
      1762,
      1763,
      1764,
      1765,
      121,
      1353,
      1766,
      447
    ],
  ),
  "admin_panel_settings": SymbolsMetadata(
    popularity: 7993,
    codepoint: 0xef3d,
    categories: [13],
    tags: [
      754,
      755,
      468,
      1507,
      1767,
      1508,
      1768,
      1769,
      470,
      6,
      1510,
      268,
      269,
      479,
      1661,
      483,
      850,
      936,
      853,
      1770,
      1771,
      488,
      489,
      1516,
      1517,
      490,
      1519,
      1520,
      1772,
      602,
      1773,
      1011,
      65,
      1522,
      501,
      1774,
      1523
    ],
  ),
  "ads_click": SymbolsMetadata(
    popularity: 7036,
    codepoint: 0xe762,
    categories: [6],
    tags: [
      1035,
      1056,
      1037,
      5,
      1039,
      1775,
      1040,
      953,
      1776,
      1777,
      1732,
      1778,
      1779,
      1780,
      1781,
      1043,
      215,
      1045,
      1046,
      1782,
      1783,
      1784,
      1050,
      1785,
      1786,
      1787,
      288,
      36,
      1071,
      947,
      1590,
      1691
    ],
  ),
  "agender": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xf888,
    categories: [3],
    tags: [
      1788,
      383,
      1789,
      1790,
      1791,
      1792,
      1793,
      1794,
      1795,
      1796,
      1797,
      1798,
      1205,
      16,
      850,
      1799,
      1800,
      1801,
      1802,
      1602,
      1803,
      1804,
      1805,
      1806,
      1807,
      1808,
      1809,
      607,
      35,
      1215,
      1810
    ],
  ),
  "agriculture": SymbolsMetadata(
    popularity: 1703,
    codepoint: 0xea79,
    categories: [14],
    tags: [
      1811,
      1812,
      1813,
      1814,
      1815,
      1816,
      1817,
      1818,
      1819,
      1820,
      1821,
      1822,
      1823,
      1824,
      1825,
      1826,
      1827,
      1828,
      1829,
      1204,
      1830,
      1831,
      1832,
      1833,
      1834,
      1490,
      1835,
      1836,
      1837,
      1838,
      1839,
      1840,
      1841,
      1842,
      1504,
      1843,
      1844
    ],
  ),
  "air": SymbolsMetadata(
    popularity: 2740,
    codepoint: 0xefd8,
    categories: [15],
    tags: [
      705,
      1845,
      707,
      709,
      1846,
      1847,
      1848,
      1849,
      1850,
      712,
      1851,
      1852,
      1853,
      719,
      926,
      1854,
      1855,
      723,
      1856,
      366,
      1857,
      1858,
      1859,
      1860,
      1861,
      441,
      730,
      1862,
      731,
      1863
    ],
  ),
  "air_freshener": SymbolsMetadata(
    popularity: 418,
    codepoint: 0xe2ca,
    categories: [8],
    tags: [
      1864,
      707,
      1865,
      1866,
      1867,
      1868,
      1869,
      1870,
      1815,
      953,
      1871,
      1269,
      1872,
      1873,
      956,
      1874,
      1875,
      1876,
      999,
      1877,
      1004,
      1878,
      1879,
      424,
      1880,
      1881,
      1882,
      1883,
      1884,
      1885
    ],
  ),
  "air_purifier": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xe97e,
    categories: [8],
    tags: [
      707,
      1886,
      1866,
      1887,
      1846,
      1888,
      1848,
      1849,
      383,
      1871,
      1889,
      712,
      445,
      1711,
      1890,
      719,
      959,
      1891,
      1874,
      1876,
      1892,
      1893,
      1894,
      999,
      1895,
      1435,
      1896,
      1897,
      1898,
      1899,
      1900,
      1901,
      32,
      727,
      730,
      1902
    ],
  ),
  "air_purifier_gen": SymbolsMetadata(
    popularity: 326,
    codepoint: 0xe829,
    categories: [8],
    tags: [
      707,
      1903,
      1886,
      1866,
      1846,
      1888,
      1848,
      1871,
      1889,
      712,
      269,
      445,
      1890,
      719,
      959,
      1892,
      595,
      999,
      1895,
      1435,
      1904,
      1897,
      1004,
      1899,
      1901,
      727,
      441,
      730,
      1862,
      1902,
      1905,
      1863
    ],
  ),
  "airline_seat_flat": SymbolsMetadata(
    popularity: 271,
    codepoint: 0xe630,
    categories: [16],
    tags: [
      1906,
      1907,
      1908,
      1909,
      584,
      1910,
      1284,
      1911,
      1912,
      1913,
      1914,
      1915,
      90,
      1916,
      303,
      1917,
      1918,
      1919,
      483,
      1581,
      1920,
      1921,
      1922,
      488,
      489,
      308,
      1923,
      1924,
      1925,
      1926,
      1927,
      1928,
      1929,
      1930,
      1504,
      1591
    ],
  ),
  "airline_seat_flat_angled": SymbolsMetadata(
    popularity: 144,
    codepoint: 0xe631,
    categories: [16],
    tags: [
      1907,
      1931,
      1932,
      1908,
      1933,
      1934,
      1935,
      584,
      1910,
      1936,
      1284,
      1911,
      1912,
      1913,
      1914,
      1937,
      90,
      1916,
      303,
      1938,
      1917,
      1918,
      1919,
      483,
      1581,
      1920,
      1922,
      488,
      489,
      308,
      1923,
      1924,
      1925,
      1926,
      1929,
      1842,
      1930,
      1504,
      1591
    ],
  ),
  "airline_seat_individual_suite": SymbolsMetadata(
    popularity: 219,
    codepoint: 0xe632,
    categories: [16],
    tags: [
      1906,
      1907,
      1932,
      1939,
      1940,
      1941,
      584,
      1936,
      1284,
      1911,
      1942,
      1913,
      1914,
      1943,
      90,
      1916,
      1917,
      1919,
      483,
      885,
      1920,
      1944,
      1922,
      488,
      489,
      1945,
      531,
      1517,
      1946,
      1924,
      1925,
      1926,
      1947,
      1929,
      1948,
      1930,
      1504,
      1949
    ],
  ),
  "airline_seat_legroom_extra": SymbolsMetadata(
    popularity: 159,
    codepoint: 0xe633,
    categories: [16],
    tags: [
      1950,
      1907,
      1931,
      1932,
      1908,
      584,
      1912,
      1914,
      1951,
      1952,
      1953,
      590,
      1917,
      1954,
      483,
      1955,
      1920,
      1956,
      1922,
      488,
      489,
      1923,
      1957,
      1958,
      1959,
      1960,
      1926,
      1961,
      772,
      609,
      1962,
      1504,
      1963,
      533
    ],
  ),
  "airline_seat_legroom_normal": SymbolsMetadata(
    popularity: 142,
    codepoint: 0xe634,
    categories: [16],
    tags: [
      1906,
      1907,
      1932,
      584,
      1910,
      1936,
      1912,
      266,
      1914,
      1937,
      590,
      1917,
      1918,
      1964,
      483,
      16,
      1581,
      1955,
      1965,
      1920,
      1966,
      1922,
      488,
      489,
      1967,
      308,
      1924,
      1926,
      288,
      1961,
      772,
      609,
      1968,
      35,
      1930,
      1504,
      1591
    ],
  ),
  "airline_seat_legroom_reduced": SymbolsMetadata(
    popularity: 137,
    codepoint: 0xe635,
    categories: [16],
    tags: [
      1907,
      1932,
      1908,
      1969,
      584,
      828,
      1912,
      1970,
      1971,
      1972,
      1937,
      590,
      1917,
      1973,
      483,
      1974,
      1955,
      1920,
      1975,
      1976,
      1922,
      488,
      489,
      1977,
      1978,
      912,
      1926,
      1927,
      772,
      1979,
      609,
      1980,
      1504,
      1981,
      1982
    ],
  ),
  "airline_seat_recline_extra": SymbolsMetadata(
    popularity: 568,
    codepoint: 0xe636,
    categories: [16],
    tags: [
      1983,
      1907,
      1932,
      1908,
      1940,
      584,
      1911,
      1912,
      1914,
      1951,
      1984,
      590,
      1916,
      1917,
      1918,
      1919,
      483,
      1985,
      1955,
      1920,
      1922,
      488,
      489,
      1923,
      1986,
      1958,
      1926,
      772,
      609,
      750,
      1930,
      1504,
      1591,
      533
    ],
  ),
  "airline_seat_recline_normal": SymbolsMetadata(
    popularity: 658,
    codepoint: 0xe637,
    categories: [16],
    tags: [
      1128,
      1907,
      1932,
      584,
      1912,
      1987,
      1914,
      1951,
      590,
      1917,
      1988,
      483,
      16,
      1955,
      1920,
      1966,
      1922,
      488,
      489,
      1989,
      308,
      1496,
      1923,
      1926,
      1990,
      1927,
      1928,
      65,
      1961,
      772,
      609,
      750,
      35,
      1504,
      1991,
      1992
    ],
  ),
  "airline_stops": SymbolsMetadata(
    popularity: 376,
    codepoint: 0xe7d0,
    categories: [5],
    tags: [
      1907,
      1993,
      380,
      1994,
      1731,
      1995,
      1996,
      1484,
      1997,
      388,
      1578,
      1998,
      1999,
      2000,
      2001,
      1501,
      1581,
      2002,
      2003,
      1001,
      1490,
      2004,
      421,
      1586,
      1495,
      1503,
      1378,
      2005,
      2006,
      441,
      2007,
      2008,
      1930,
      1504,
      1591,
      2009
    ],
  ),
  "airlines": SymbolsMetadata(
    popularity: 443,
    codepoint: 0xe7ca,
    categories: [14],
    tags: [
      1950,
      707,
      2010,
      1906,
      2011,
      1932,
      2012,
      2013,
      2014,
      1935,
      1936,
      383,
      2015,
      2016,
      832,
      1917,
      2017,
      1918,
      1973,
      2018,
      1581,
      307,
      909,
      2019,
      308,
      2020,
      2021,
      227,
      2022,
      1424,
      2023,
      1930,
      1504,
      1591,
      2024,
      1054
    ],
  ),
  "airplane_ticket": SymbolsMetadata(
    popularity: 1633,
    codepoint: 0xefd9,
    categories: [16],
    tags: [
      707,
      2010,
      1906,
      1907,
      1932,
      2025,
      2012,
      2013,
      2014,
      1935,
      2026,
      2027,
      1936,
      2016,
      1917,
      2017,
      1918,
      1973,
      2018,
      1501,
      1581,
      1490,
      2028,
      308,
      2029,
      2020,
      75,
      1924,
      77,
      227,
      2022,
      2023,
      1930,
      1504,
      2030,
      1591,
      2024
    ],
  ),
  "airplanemode_inactive": SymbolsMetadata(
    popularity: 259,
    codepoint: 0xe194,
    categories: [4],
    tags: [
      1950,
      707,
      1906,
      1932,
      2031,
      2032,
      2033,
      2034,
      2012,
      2013,
      2035,
      895,
      2036,
      1202,
      1077,
      767,
      2037,
      898,
      1917,
      2038,
      2039,
      2040,
      2017,
      1918,
      1973,
      901,
      1490,
      307,
      2041,
      2042,
      2043,
      2044,
      2045,
      907,
      908,
      2046,
      909,
      308,
      2020,
      2047,
      227,
      2048,
      914,
      1930,
      1504,
      1591,
      2049,
      2050
    ],
  ),
  "airplay": SymbolsMetadata(
    popularity: 371,
    codepoint: 0xe055,
    categories: [0],
    tags: [
      2051,
      380,
      2052,
      1129,
      355,
      2053,
      921,
      269,
      1685,
      445,
      12,
      2054,
      367,
      327,
      1719,
      2055,
      75,
      330,
      2056,
      1665,
      227,
      32,
      2057,
      2058,
      343,
      1701,
      344,
      41,
      235,
      2059
    ],
  ),
  "airport_shuttle": SymbolsMetadata(
    popularity: 2252,
    codepoint: 0xeb3c,
    categories: [14],
    tags: [
      2013,
      2060,
      2061,
      2014,
      1814,
      2062,
      1815,
      1816,
      1041,
      2063,
      1019,
      2016,
      388,
      2064,
      2065,
      2066,
      2067,
      1581,
      1490,
      2068,
      2069,
      1922,
      2070,
      2071,
      2072,
      2073,
      2074,
      2007,
      2008,
      1842,
      1930,
      1504,
      1591,
      1843,
      2075,
      2076,
      1844
    ],
  ),
  "airware": SymbolsMetadata(
    popularity: 441,
    codepoint: 0xf154,
    categories: [8],
    tags: [
      2077,
      2078,
      1129,
      355,
      212,
      2079,
      10,
      926,
      277,
      2080,
      215,
      420,
      2081,
      223,
      2082,
      2083,
      1787,
      227,
      2084,
      1156,
      342,
      441,
      2085,
      2086,
      1862,
      1902,
      233,
      234
    ],
  ),
  "airwave": SymbolsMetadata(
    popularity: 665,
    codepoint: 0xe29c,
    categories: [10],
    tags: [
      707,
      2077,
      2078,
      1129,
      1849,
      1850,
      355,
      712,
      212,
      2079,
      10,
      926,
      277,
      999,
      2080,
      215,
      420,
      2081,
      1004,
      223,
      2082,
      2083,
      1787,
      227,
      2084,
      1156,
      342,
      729,
      441,
      2085,
      2086,
      1862,
      1902,
      731,
      233,
      1863,
      234
    ],
  ),
  "alarm": SymbolsMetadata(
    popularity: 4663,
    codepoint: 0xe855,
    categories: [6],
    tags: [
      2087,
      2088,
      2089,
      1244,
      2090,
      469,
      1015,
      1246,
      2091,
      1016,
      2092,
      1017,
      1018,
      2093,
      2094,
      2095,
      2096,
      2097,
      486,
      1030,
      1257,
      2098,
      1031,
      103,
      289,
      2099,
      1033,
      2100,
      2101,
      2102
    ],
  ),
  "alarm_add": SymbolsMetadata(
    popularity: 730,
    codepoint: 0xe856,
    categories: [6],
    tags: [
      192,
      526,
      2103,
      2104,
      1244,
      469,
      1246,
      2091,
      383,
      1016,
      2092,
      1201,
      2105,
      1017,
      2097,
      763,
      2106,
      486,
      98,
      2107,
      202,
      1212,
      1030,
      2098,
      1031,
      2108,
      35,
      441,
      289,
      2099,
      1033,
      2101
    ],
  ),
  "alarm_off": SymbolsMetadata(
    popularity: 479,
    codepoint: 0xe857,
    categories: [6],
    tags: [
      1244,
      2109,
      2110,
      2111,
      2112,
      469,
      1246,
      2113,
      2114,
      2115,
      1075,
      1630,
      1632,
      383,
      1016,
      2116,
      2117,
      2118,
      2119,
      767,
      1020,
      898,
      901,
      1164,
      2120,
      2121,
      486,
      2122,
      907,
      909,
      2123,
      1030,
      2124,
      1170,
      2125,
      914,
      2126,
      289,
      2127,
      1033,
      2128,
      2129,
      2102
    ],
  ),
  "alarm_on": SymbolsMetadata(
    popularity: 1948,
    codepoint: 0xe858,
    categories: [6],
    tags: [
      1242,
      1244,
      2130,
      2131,
      2132,
      2133,
      469,
      1246,
      1630,
      1632,
      383,
      1016,
      1633,
      1636,
      1639,
      1020,
      898,
      2097,
      486,
      909,
      1030,
      2098,
      1031,
      2134,
      1156,
      1647,
      289,
      2099,
      1033,
      1214,
      2101,
      2102
    ],
  ),
  "alarm_pause": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf35b,
    categories: [6],
    tags: [
      1244,
      2131,
      469,
      2135,
      1246,
      2136,
      383,
      1016,
      2137,
      2138,
      1020,
      2139,
      2140,
      2097,
      486,
      1082,
      2141,
      2142,
      1030,
      2143,
      1929,
      2144,
      1083,
      2145,
      289,
      2099,
      1033,
      2146,
      2147,
      2100,
      2102
    ],
  ),
  "alarm_smart_wake": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf6b0,
    categories: [6],
    tags: [
      1244,
      2131,
      469,
      2148,
      1246,
      383,
      1016,
      786,
      2149,
      788,
      789,
      2097,
      486,
      656,
      1030,
      1257,
      1031,
      65,
      1929,
      2150,
      1901,
      1156,
      791,
      289,
      1033,
      2100,
      2101
    ],
  ),
  "album": SymbolsMetadata(
    popularity: 1456,
    codepoint: 0xe019,
    categories: [0],
    tags: [
      1538,
      2151,
      2152,
      1129,
      2153,
      2154,
      383,
      2155,
      694,
      1732,
      10,
      2156,
      2157,
      1530,
      2158,
      2159,
      1143,
      2160,
      367,
      2081,
      2161,
      2162,
      2163,
      121,
      701,
      1786,
      2164,
      1156,
      674,
      2165,
      703,
      2166
    ],
  ),
  "align_center": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xe356,
    categories: [12],
    tags: [
      2167,
      2168,
      2169,
      2170,
      794,
      1730,
      2171,
      2172,
      2173,
      696,
      2174,
      1372,
      2175,
      2176,
      2177,
      2080,
      2178,
      1066,
      306,
      366,
      2179,
      98,
      2180,
      1496,
      601,
      2181,
      107,
      2182,
      38,
      2183,
      2184,
      441,
      702,
      2185
    ],
  ),
  "align_end": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf797,
    categories: [12],
    tags: [
      2167,
      2186,
      2187,
      2169,
      2188,
      2189,
      2190,
      1372,
      2191,
      2177,
      2178,
      2192,
      2193,
      366,
      2180,
      1396,
      2194,
      2195,
      38,
      2196,
      2183,
      2197,
      441,
      2198,
      2199
    ],
  ),
  "align_flex_center": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf796,
    categories: [12],
    tags: [
      526,
      2167,
      2169,
      2170,
      794,
      1730,
      2171,
      1061,
      1202,
      2200,
      2173,
      2201,
      2202,
      2203,
      1372,
      2191,
      1209,
      1064,
      2178,
      2204,
      306,
      366,
      1067,
      2179,
      2205,
      202,
      1212,
      1496,
      601,
      2182,
      2206,
      1381,
      2198
    ],
  ),
  "align_flex_end": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf795,
    categories: [12],
    tags: [
      2167,
      2207,
      2187,
      2208,
      2169,
      1367,
      1343,
      2188,
      2209,
      1730,
      1368,
      2173,
      2210,
      2189,
      2202,
      2211,
      2212,
      2203,
      1372,
      2178,
      2192,
      306,
      1602,
      366,
      96,
      1496,
      75,
      1396,
      2194,
      601,
      107,
      2182,
      2196,
      2183,
      1381,
      2198,
      2199
    ],
  ),
  "align_flex_start": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf794,
    categories: [12],
    tags: [
      2167,
      2213,
      2214,
      2169,
      1367,
      2170,
      1730,
      2173,
      2202,
      2215,
      2212,
      2203,
      1372,
      2175,
      2177,
      2178,
      2216,
      2217,
      2218,
      306,
      366,
      96,
      1496,
      601,
      108,
      2182,
      38,
      2196,
      2183,
      2219,
      1124,
      2220,
      2221,
      1381,
      2198,
      2199
    ],
  ),
  "align_horizontal_center": SymbolsMetadata(
    popularity: 344,
    codepoint: 0xe00f,
    categories: [12],
    tags: [
      2167,
      2169,
      1367,
      1730,
      2171,
      1202,
      2173,
      696,
      1371,
      1372,
      2175,
      2176,
      2191,
      2177,
      2178,
      306,
      366,
      2179,
      2180,
      202,
      601,
      2181,
      2182,
      38,
      2183,
      2184,
      702,
      2198,
      2199,
      2222
    ],
  ),
  "align_horizontal_left": SymbolsMetadata(
    popularity: 463,
    codepoint: 0xe00d,
    categories: [12],
    tags: [
      2167,
      2169,
      1367,
      2172,
      2223,
      1347,
      2224,
      1372,
      2175,
      2176,
      2191,
      2177,
      2178,
      2225,
      306,
      1375,
      2226,
      366,
      96,
      98,
      2227,
      2180,
      2228,
      601,
      2181,
      2182,
      38,
      2183,
      2229,
      2230,
      2231,
      441,
      702
    ],
  ),
  "align_horizontal_right": SymbolsMetadata(
    popularity: 308,
    codepoint: 0xe010,
    categories: [12],
    tags: [
      2167,
      2187,
      2169,
      1367,
      2232,
      365,
      236,
      2190,
      1372,
      2175,
      2176,
      2233,
      2234,
      2178,
      2193,
      306,
      366,
      2235,
      2180,
      1396,
      2194,
      2236,
      601,
      2181,
      2237,
      2238,
      2182,
      38,
      2183,
      2197,
      441
    ],
  ),
  "align_items_stretch": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf793,
    categories: [12],
    tags: [
      2167,
      2213,
      2239,
      2169,
      1367,
      2170,
      2188,
      1730,
      802,
      2173,
      2210,
      2240,
      2241,
      787,
      2242,
      1372,
      2243,
      2244,
      246,
      2176,
      2245,
      2246,
      2178,
      306,
      366,
      2247,
      1376,
      601,
      2181,
      2248,
      2249,
      2182,
      1124,
      1381,
      2198,
      2199
    ],
  ),
  "align_justify_center": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf792,
    categories: [12],
    tags: [
      2167,
      2169,
      1367,
      1730,
      2171,
      802,
      2172,
      2173,
      2250,
      1372,
      2175,
      2176,
      2178,
      2204,
      306,
      366,
      2179,
      98,
      2180,
      601,
      2248,
      107,
      2182,
      38,
      2183,
      2230,
      2251,
      441,
      2252,
      2198,
      2199,
      2253
    ],
  ),
  "align_justify_flex_end": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf791,
    categories: [12],
    tags: [
      2167,
      2169,
      2170,
      365,
      918,
      1730,
      2173,
      236,
      2189,
      2202,
      2254,
      2212,
      2203,
      2190,
      1372,
      2175,
      2178,
      2255,
      306,
      366,
      2180,
      1496,
      1396,
      2194,
      2195,
      601,
      2182,
      38,
      2183,
      2230,
      2256,
      440,
      441,
      1381,
      1592
    ],
  ),
  "align_justify_flex_start": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf790,
    categories: [12],
    tags: [
      2167,
      2169,
      1367,
      365,
      84,
      1730,
      802,
      2172,
      2173,
      1347,
      1371,
      2215,
      2203,
      1372,
      2175,
      2178,
      2225,
      306,
      2226,
      366,
      98,
      2180,
      2228,
      601,
      108,
      2182,
      2196,
      2183,
      2230,
      2231,
      440,
      1124,
      1381,
      2198,
      2253
    ],
  ),
  "align_justify_space_around": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf78f,
    categories: [12],
    tags: [
      2167,
      2169,
      2170,
      794,
      365,
      1730,
      802,
      2173,
      2250,
      2201,
      1372,
      2175,
      2176,
      2178,
      306,
      366,
      98,
      2180,
      2257,
      2258,
      601,
      2259,
      2248,
      2182,
      2206,
      2183,
      2229,
      2230,
      702,
      1592,
      2222
    ],
  ),
  "align_justify_space_between": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf78e,
    categories: [12],
    tags: [
      2167,
      2169,
      2170,
      794,
      918,
      1730,
      802,
      2173,
      2260,
      2250,
      2201,
      1372,
      246,
      2176,
      2261,
      2178,
      306,
      366,
      2262,
      98,
      2263,
      2180,
      601,
      2264,
      2265,
      2248,
      945,
      2182,
      2183,
      2266,
      2267,
      2268
    ],
  ),
  "align_justify_space_even": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf78d,
    categories: [12],
    tags: [
      2167,
      2169,
      1367,
      365,
      918,
      1730,
      802,
      2172,
      2173,
      1347,
      1371,
      2250,
      2201,
      2269,
      1372,
      2175,
      2176,
      2178,
      2270,
      306,
      366,
      2227,
      2180,
      601,
      609,
      2248,
      2182,
      38,
      2183,
      2266,
      2271,
      702,
      1592
    ],
  ),
  "align_justify_stretch": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf78c,
    categories: [12],
    tags: [
      2167,
      2169,
      1730,
      802,
      2272,
      2173,
      1347,
      696,
      1371,
      787,
      2273,
      1372,
      2175,
      2244,
      246,
      2176,
      2191,
      2178,
      306,
      366,
      2227,
      2247,
      601,
      2249,
      2182,
      1380,
      2196,
      2230,
      2274,
      2275,
      702,
      2198,
      1054,
      2185
    ],
  ),
  "align_self_stretch": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf78b,
    categories: [12],
    tags: [
      2276,
      1128,
      2167,
      2277,
      2169,
      2170,
      2188,
      1730,
      1368,
      1269,
      2278,
      2173,
      787,
      2279,
      2242,
      2212,
      1372,
      2243,
      246,
      306,
      366,
      1496,
      2247,
      2280,
      1603,
      601,
      2181,
      2281,
      2282,
      2249,
      2182,
      1124,
      1381,
      2198,
      2283
    ],
  ),
  "align_space_around": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf78a,
    categories: [12],
    tags: [
      2167,
      2169,
      2284,
      2170,
      794,
      1730,
      2173,
      1347,
      696,
      2250,
      2201,
      1372,
      2191,
      2261,
      2178,
      1066,
      306,
      2179,
      98,
      2180,
      609,
      2248,
      107,
      2183,
      440,
      441,
      2252,
      702,
      2268
    ],
  ),
  "align_space_between": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf789,
    categories: [12],
    tags: [
      2167,
      2169,
      2170,
      794,
      365,
      2188,
      2173,
      2260,
      2250,
      2201,
      1372,
      2191,
      2285,
      2286,
      2178,
      306,
      366,
      2262,
      96,
      98,
      2263,
      2228,
      2287,
      2265,
      2248,
      2183,
      2266,
      1124,
      2198,
      2288,
      2289
    ],
  ),
  "align_space_even": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf788,
    categories: [12],
    tags: [
      2167,
      2169,
      1367,
      2170,
      794,
      2173,
      2290,
      2250,
      2201,
      2269,
      1372,
      2176,
      2177,
      2291,
      2261,
      2178,
      2292,
      1066,
      306,
      366,
      98,
      2293,
      2294,
      2295,
      609,
      2248,
      107,
      2296,
      441
    ],
  ),
  "align_start": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf787,
    categories: [12],
    tags: [
      2167,
      2297,
      2298,
      2170,
      84,
      1042,
      1347,
      696,
      2299,
      1372,
      2175,
      2080,
      2246,
      2178,
      306,
      2226,
      366,
      96,
      98,
      2180,
      108,
      2196,
      2183,
      2184,
      2229,
      2231,
      441,
      1124
    ],
  ),
  "align_stretch": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf786,
    categories: [12],
    tags: [
      2300,
      2167,
      2170,
      2301,
      365,
      2302,
      1042,
      2210,
      787,
      2273,
      2244,
      2303,
      2191,
      2304,
      2305,
      53,
      2178,
      306,
      2306,
      2307,
      2308,
      2247,
      2281,
      2249,
      38,
      2296,
      441,
      2309,
      1054
    ],
  ),
  "align_vertical_bottom": SymbolsMetadata(
    popularity: 319,
    codepoint: 0xe015,
    categories: [12],
    tags: [
      2167,
      2207,
      2169,
      1367,
      2310,
      365,
      2311,
      2188,
      2312,
      2313,
      802,
      1372,
      2178,
      2314,
      306,
      1602,
      366,
      2315,
      96,
      98,
      2180,
      601,
      2181,
      106,
      107,
      2182,
      38,
      2196,
      2183,
      1381,
      2198,
      2316,
      2317
    ],
  ),
  "align_vertical_center": SymbolsMetadata(
    popularity: 257,
    codepoint: 0xe011,
    categories: [12],
    tags: [
      2167,
      2169,
      1367,
      794,
      365,
      1730,
      2171,
      2318,
      802,
      1347,
      696,
      2319,
      1372,
      2175,
      1205,
      2178,
      2204,
      306,
      366,
      2179,
      2205,
      2180,
      1496,
      601,
      2181,
      2182,
      38,
      2196,
      2183,
      2184,
      2229,
      702,
      1381,
      2198,
      2199,
      2320,
      1592,
      2222
    ],
  ),
  "align_vertical_top": SymbolsMetadata(
    popularity: 253,
    codepoint: 0xe00c,
    categories: [12],
    tags: [
      2167,
      2214,
      2321,
      2169,
      1367,
      2322,
      802,
      1372,
      2175,
      1205,
      2178,
      306,
      366,
      2180,
      2228,
      601,
      2181,
      2182,
      38,
      2196,
      2183,
      2323,
      441,
      1124,
      2220,
      1214,
      702,
      1381,
      2198,
      2199,
      1592
    ],
  ),
  "all_inbox": SymbolsMetadata(
    popularity: 814,
    codepoint: 0xe97f,
    categories: [7],
    tags: [
      2324,
      2325,
      2326,
      2151,
      2327,
      7,
      2328,
      2329,
      2330,
      443,
      1269,
      2331,
      2332,
      2333,
      1019,
      337,
      2334,
      2335,
      2336,
      2337,
      851,
      2338,
      2339,
      2340,
      485,
      2341,
      2342,
      75,
      2343,
      32,
      674,
      1298,
      2344,
      2345
    ],
  ),
  "all_inclusive": SymbolsMetadata(
    popularity: 3178,
    codepoint: 0xeb3d,
    categories: [6],
    tags: [
      2325,
      2346,
      2347,
      2348,
      2349,
      385,
      2350,
      2351,
      2352,
      2353,
      926,
      2354,
      2355,
      760,
      2356,
      2357,
      2358,
      390,
      2359,
      2360,
      2361,
      2362,
      2363,
      2364,
      2365,
      2366,
      2367,
      2368,
      2369,
      2370,
      2371,
      2372,
      2373
    ],
  ),
  "all_match": SymbolsMetadata(
    popularity: 79,
    codepoint: 0xe093,
    categories: [2],
    tags: [
      1627,
      1548,
      2325,
      2374,
      1549,
      1199,
      2375,
      1630,
      1632,
      1633,
      1636,
      2376,
      1639,
      2377,
      2378,
      18,
      1641,
      2379,
      1210,
      2380,
      1643,
      1213,
      288,
      2381,
      2382,
      461,
      2383,
      2384,
      1647,
      2385,
      2386,
      2387,
      2388,
      1523,
      2389,
      1650
    ],
  ),
  "all_out": SymbolsMetadata(
    popularity: 417,
    codepoint: 0xe90b,
    categories: [6],
    tags: [
      2325,
      2390,
      419,
      2301,
      383,
      2391,
      12,
      1216,
      787,
      2392,
      2393,
      2394,
      2395,
      1673,
      1204,
      2396,
      2397,
      2307,
      2398,
      2399,
      2400,
      2247,
      2281,
      2401,
      311,
      2249,
      317,
      2402,
      986,
      2403,
      2404
    ],
  ),
  "allergies": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xe094,
    categories: [3],
    tags: [
      2405,
      2406,
      2407,
      2408,
      2409,
      2410,
      2411,
      2412,
      383,
      2413,
      2414,
      595,
      2415,
      1753,
      2416,
      2417,
      2418,
      2419,
      2420,
      2421,
      1757,
      1760,
      2422,
      2423,
      1564,
      2424,
      2425,
      2426,
      2427,
      441,
      2428,
      2429
    ],
  ),
  "allergy": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xe64e,
    categories: [3],
    tags: [
      2430,
      2405,
      2406,
      2407,
      2408,
      2431,
      2412,
      1994,
      2332,
      2414,
      956,
      2432,
      2433,
      595,
      2417,
      2434,
      2421,
      2435,
      366,
      1757,
      1859,
      1835,
      2422,
      1564,
      2436,
      2425,
      2426,
      2437,
      2438,
      2439,
      948
    ],
  ),
  "alt_route": SymbolsMetadata(
    popularity: 1403,
    codepoint: 0xf184,
    categories: [5],
    tags: [
      1499,
      2440,
      1539,
      2441,
      2442,
      2443,
      2444,
      2445,
      419,
      1994,
      2446,
      1731,
      2447,
      2448,
      2449,
      1997,
      388,
      1578,
      2450,
      2000,
      777,
      1488,
      1581,
      1002,
      1490,
      421,
      656,
      2451,
      1586,
      2452,
      1587,
      1503,
      2453,
      2454,
      1378,
      35,
      1504,
      2455,
      1676,
      2456
    ],
  ),
  "alternate_email": SymbolsMetadata(
    popularity: 7850,
    codepoint: 0xe0e6,
    categories: [7],
    tags: [
      2457,
      468,
      1429,
      1539,
      2458,
      2442,
      2459,
      2460,
      383,
      443,
      693,
      475,
      2332,
      2461,
      2335,
      851,
      215,
      390,
      2340,
      485,
      223,
      819,
      490,
      1410,
      2462,
      2343,
      2463,
      2384,
      501,
      1053
    ],
  ),
  "altitude": SymbolsMetadata(
    popularity: 88,
    codepoint: 0xf873,
    categories: [3],
    tags: [
      1593,
      2464,
      2465,
      380,
      2052,
      2466,
      2467,
      388,
      2468,
      2469,
      1488,
      196,
      2470,
      2471,
      1207,
      2472,
      2473,
      1001,
      1545,
      421,
      1860,
      2474,
      28,
      2475,
      2476,
      2477,
      2478,
      1504,
      1701,
      1676
    ],
  ),
  "ambulance": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf803,
    categories: [14],
    tags: [
      469,
      2479,
      1549,
      2480,
      1131,
      1814,
      1815,
      1630,
      1632,
      1633,
      2481,
      2376,
      1639,
      2482,
      2483,
      595,
      1753,
      1754,
      2484,
      1641,
      1757,
      486,
      1643,
      1213,
      288,
      2485,
      2486,
      2487,
      1647,
      1842,
      1930,
      2385,
      2386,
      2076,
      1844,
      1523,
      1650
    ],
  ),
  "amend": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xf802,
    categories: [2],
    tags: [
      1128,
      1726,
      2488,
      380,
      419,
      2489,
      1731,
      383,
      2490,
      2376,
      388,
      1347,
      2491,
      696,
      1737,
      530,
      1375,
      1602,
      390,
      1740,
      421,
      2492,
      2493,
      424,
      425,
      2494,
      2367,
      2495,
      2496,
      2497,
      396,
      2184,
      2498,
      2499,
      1260
    ],
  ),
  "amp_stories": SymbolsMetadata(
    popularity: 186,
    codepoint: 0xea13,
    categories: [12],
    tags: [
      2500,
      2501,
      365,
      1400,
      2155,
      802,
      1042,
      2502,
      930,
      366,
      367,
      219,
      2503,
      2504,
      2505,
      2506,
      2507,
      75,
      2508,
      31,
      32,
      2509,
      2510,
      374,
      2511,
      317,
      2512,
      1691
    ],
  ),
  "analytics": SymbolsMetadata(
    popularity: 10870,
    codepoint: 0xef3e,
    categories: [9],
    tags: [
      2513,
      5,
      2514,
      1343,
      1344,
      365,
      1284,
      920,
      2515,
      10,
      924,
      929,
      933,
      2516,
      2517,
      2518,
      597,
      634,
      937,
      189,
      2400,
      28,
      1353,
      1354,
      78,
      32,
      33,
      440,
      947,
      2253,
      1355,
      2519
    ],
  ),
  "anchor": SymbolsMetadata(
    popularity: 1253,
    codepoint: 0xf1cd,
    categories: [6],
    tags: [
      2520,
      1058,
      2521,
      211,
      1202,
      2332,
      2522,
      2523,
      2524,
      2525,
      1189,
      2526,
      2139,
      2527,
      16,
      935,
      2528,
      2529,
      2530,
      2531,
      2532,
      421,
      2533,
      2534,
      1257,
      2476,
      1773,
      2535,
      2536,
      35,
      2537
    ],
  ),
  "android": SymbolsMetadata(
    popularity: 3434,
    codepoint: 0xe859,
    categories: [4],
    tags: [
      1175,
      1180,
      1229,
      1230,
      2148,
      2538,
      2539,
      8,
      383,
      2332,
      445,
      1188,
      479,
      1189,
      1190,
      2540,
      2528,
      2541,
      219,
      1192,
      1193,
      1194,
      1195,
      2542,
      446,
      1196,
      35,
      447,
      551,
      2543
    ],
  ),
  "animated_images": SymbolsMetadata(
    popularity: 236,
    codepoint: 0xf49a,
    categories: [0],
    tags: [
      2544,
      2545,
      264,
      2546,
      2547,
      270,
      2548,
      1541,
      2549,
      2550,
      2551,
      2552,
      2553,
      2554,
      1066,
      390,
      367,
      420,
      2555,
      2556,
      328,
      2557,
      2558,
      2559,
      59,
      61,
      119,
      2162,
      283,
      2560,
      2561,
      2562,
      107,
      41,
      2563
    ],
  ),
  "animation": SymbolsMetadata(
    popularity: 1057,
    codepoint: 0xe71c,
    categories: [1],
    tags: [
      2564,
      264,
      2565,
      953,
      384,
      2566,
      2349,
      385,
      2547,
      2567,
      270,
      926,
      276,
      1065,
      2568,
      390,
      420,
      1858,
      2559,
      28,
      2367,
      1786,
      396,
      2569,
      104,
      2570,
      2562,
      1069,
      2571,
      41,
      2572
    ],
  ),
  "aod": SymbolsMetadata(
    popularity: 333,
    codepoint: 0xefda,
    categories: [11],
    tags: [
      1109,
      1110,
      469,
      2573,
      2574,
      2575,
      365,
      2576,
      472,
      443,
      2577,
      445,
      88,
      12,
      965,
      2578,
      2080,
      1114,
      135,
      366,
      485,
      219,
      2579,
      2580,
      2581,
      2582,
      2583,
      486,
      909,
      226,
      75,
      77,
      330,
      446,
      1121,
      447,
      38
    ],
  ),
  "aod_tablet": SymbolsMetadata(
    popularity: 140,
    codepoint: 0xf89f,
    categories: [11],
    tags: [
      1109,
      1110,
      2573,
      2574,
      2575,
      2584,
      268,
      1042,
      269,
      445,
      88,
      12,
      1347,
      1711,
      965,
      2578,
      1114,
      135,
      366,
      788,
      219,
      909,
      656,
      1770,
      226,
      2585,
      75,
      77,
      330,
      65,
      2508,
      2586,
      447,
      551,
      38
    ],
  ),
  "aod_watch": SymbolsMetadata(
    popularity: 60,
    codepoint: 0xf6ac,
    categories: [11],
    tags: [
      2587,
      469,
      2574,
      2575,
      379,
      2588,
      1016,
      445,
      2589,
      12,
      2590,
      2080,
      1114,
      485,
      486,
      1082,
      330,
      2591,
      2592,
      2586,
      551,
      441,
      289,
      1033,
      2593,
      1214,
      405,
      2102,
      2594,
      2595,
      2596,
      1691,
      2597,
      2598
    ],
  ),
  "apartment": SymbolsMetadata(
    popularity: 11274,
    codepoint: 0xea40,
    categories: [16],
    tags: [
      2599,
      2600,
      2601,
      1074,
      798,
      2602,
      1285,
      2603,
      2604,
      1434,
      2605,
      303,
      2606,
      999,
      2607,
      1435,
      2608,
      2609,
      2610,
      2611,
      2612,
      1456,
      2613,
      1444,
      2614,
      1445,
      2615,
      1446,
      2616,
      2617,
      2618,
      944,
      2619,
      2620,
      1125,
      2621,
      1084,
      1460
    ],
  ),
  "api": SymbolsMetadata(
    popularity: 2845,
    codepoint: 0xf1b7,
    categories: [6],
    tags: [
      755,
      2622,
      2623,
      1730,
      2624,
      921,
      211,
      10,
      1186,
      2625,
      1416,
      2626,
      2627,
      787,
      2628,
      255,
      2629,
      935,
      1067,
      223,
      1194,
      2630,
      396,
      2631,
      1665,
      1196,
      32,
      2632,
      551,
      2007
    ],
  ),
  "apk_document": SymbolsMetadata(
    popularity: 166,
    codepoint: 0xf88e,
    categories: [4],
    tags: [
      1175,
      2633,
      2634,
      2635,
      2636,
      2637,
      2638,
      2639,
      2640,
      2641,
      1229,
      2642,
      2643,
      1230,
      1183,
      10,
      1347,
      337,
      1654,
      1530,
      1674,
      2644,
      219,
      2645,
      2646,
      2647,
      1534,
      1535,
      2648,
      1195,
      2649,
      1196,
      2632
    ],
  ),
  "apk_install": SymbolsMetadata(
    popularity: 220,
    codepoint: 0xf88f,
    categories: [4],
    tags: [
      526,
      1175,
      1179,
      2639,
      1230,
      380,
      2650,
      10,
      445,
      1347,
      2651,
      337,
      1654,
      1530,
      2652,
      1674,
      219,
      763,
      2653,
      2647,
      1534,
      1535,
      226,
      2648,
      1195,
      2649,
      1196,
      2632,
      447,
      1260,
      533
    ],
  ),
  "app_badging": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf72f,
    categories: [2],
    tags: [
      469,
      2654,
      1229,
      2655,
      2656,
      1230,
      2657,
      6,
      2658,
      383,
      832,
      16,
      2659,
      188,
      2568,
      485,
      763,
      2660,
      486,
      2661,
      2662,
      1120,
      28,
      1030,
      2663,
      1257,
      553,
      35,
      2664,
      2665,
      1260,
      2666
    ],
  ),
  "app_blocking": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xef3f,
    categories: [11],
    tags: [
      1109,
      1110,
      892,
      1229,
      2667,
      2668,
      2669,
      1230,
      1074,
      2670,
      895,
      1113,
      383,
      269,
      896,
      445,
      2671,
      2672,
      2673,
      1077,
      899,
      965,
      1114,
      459,
      2674,
      219,
      2675,
      1675,
      2676,
      2677,
      2678,
      2679,
      2680,
      2681,
      875,
      226,
      2682,
      1516,
      2683,
      75,
      171,
      77,
      1011,
      914,
      1083,
      2684,
      447
    ],
  ),
  "app_registration": SymbolsMetadata(
    popularity: 4308,
    codepoint: 0xef40,
    categories: [2],
    tags: [
      755,
      468,
      1229,
      2685,
      2686,
      1230,
      2687,
      2657,
      953,
      2688,
      1735,
      956,
      696,
      2689,
      2690,
      2691,
      246,
      852,
      853,
      1740,
      2692,
      2693,
      2694,
      2695,
      329,
      490,
      1256,
      856,
      65,
      2696,
      857,
      501
    ],
  ),
  "apparel": SymbolsMetadata(
    popularity: 331,
    codepoint: 0xef7b,
    categories: [8],
    tags: [
      2697,
      2698,
      2699,
      2700,
      2701,
      2702,
      2703,
      2704,
      2705,
      2706,
      16,
      2707,
      1967,
      1622,
      1296,
      2708,
      841,
      2709,
      2710,
      1298,
      2182,
      35,
      2711,
      2712,
      2713,
      1124,
      2714,
      2715
    ],
  ),
  "approval": SymbolsMetadata(
    popularity: 1787,
    codepoint: 0xe982,
    categories: [6],
    tags: [
      1627,
      2716,
      1429,
      2687,
      2717,
      2718,
      1549,
      2480,
      2719,
      2720,
      1630,
      2721,
      1636,
      1484,
      2722,
      1654,
      1500,
      2723,
      1530,
      1487,
      2724,
      2725,
      1001,
      2726,
      1002,
      1641,
      21,
      1493,
      1494,
      1495,
      1496,
      2727,
      288,
      371,
      2728,
      2729,
      1412,
      2384,
      2387
    ],
  ),
  "approval_delegation": SymbolsMetadata(
    popularity: 387,
    codepoint: 0xf84a,
    categories: [6],
    tags: [
      1627,
      755,
      1548,
      2687,
      2717,
      2718,
      1549,
      1509,
      2730,
      2731,
      1630,
      1632,
      1633,
      1636,
      2732,
      1639,
      2733,
      2734,
      777,
      2735,
      2736,
      2737,
      2738,
      2739,
      2740,
      2741,
      936,
      2742,
      2743,
      1514,
      942,
      2342,
      2744,
      2487,
      1645,
      1647,
      2007,
      2745,
      2387,
      2746
    ],
  ),
  "apps": SymbolsMetadata(
    popularity: 18837,
    codepoint: 0xe5c3,
    categories: [2],
    tags: [
      755,
      2325,
      2747,
      2748,
      1230,
      2749,
      2657,
      1731,
      953,
      2155,
      2750,
      956,
      246,
      2751,
      2752,
      2753,
      788,
      789,
      421,
      682,
      656,
      98,
      1194,
      2754,
      371,
      2755,
      1196,
      32,
      944,
      313,
      2756,
      2757,
      2758,
      2759,
      317
    ],
  ),
  "apps_outage": SymbolsMetadata(
    popularity: 1135,
    codepoint: 0xe7cc,
    categories: [2],
    tags: [
      469,
      2325,
      2760,
      2761,
      1230,
      2762,
      2763,
      2749,
      2657,
      2764,
      953,
      2155,
      2750,
      2765,
      2037,
      956,
      2651,
      2766,
      2767,
      2768,
      246,
      2751,
      2769,
      2752,
      2770,
      788,
      486,
      908,
      2771,
      2772,
      2773,
      944,
      2774,
      2757,
      915,
      2759,
      1261
    ],
  ),
  "aq": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf55a,
    categories: [10],
    tags: [
      2775,
      186,
      707,
      1887,
      4,
      2776,
      1847,
      6,
      2777,
      2778,
      2779,
      8,
      712,
      14,
      850,
      698,
      2780,
      18,
      2781,
      2782,
      19,
      2528,
      2783,
      2784,
      2785,
      62,
      2786,
      35,
      38,
      2787,
      2788,
      40,
      702,
      2789
    ],
  ),
  "aq_indoor": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf55b,
    categories: [10],
    tags: [
      707,
      709,
      1887,
      4,
      2776,
      1847,
      2777,
      798,
      8,
      712,
      1890,
      2790,
      14,
      999,
      1435,
      2791,
      1904,
      723,
      2792,
      2793,
      2794,
      2795,
      2796,
      2797,
      19,
      2798,
      2799,
      2800,
      2784,
      2785,
      1444,
      62,
      1446,
      35,
      38,
      441,
      40,
      730,
      2801,
      1862,
      1902,
      2802
    ],
  ),
  "ar_on_you": SymbolsMetadata(
    popularity: 143,
    codepoint: 0xef7c,
    categories: [0],
    tags: [
      379,
      2803,
      381,
      47,
      383,
      2391,
      2804,
      2805,
      1553,
      1554,
      479,
      2806,
      2807,
      2808,
      1555,
      960,
      1738,
      274,
      1556,
      1557,
      1558,
      2809,
      2810,
      2811,
      1560,
      1561,
      909,
      489,
      59,
      1563,
      1723,
      2812,
      2813,
      1567,
      1569,
      32,
      1570,
      36,
      1071,
      947,
      501,
      2814,
      2815
    ],
  ),
  "ar_stickers": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xe983,
    categories: [0],
    tags: [
      406,
      379,
      2816,
      2817,
      2818,
      381,
      1550,
      1551,
      1553,
      1554,
      479,
      1555,
      2819,
      1556,
      1558,
      1001,
      1002,
      21,
      1561,
      421,
      422,
      1081,
      1493,
      1495,
      2820,
      2821,
      2822,
      1496,
      2823,
      1567,
      1568,
      1569,
      2824,
      2825,
      1570,
      2826
    ],
  ),
  "architecture": SymbolsMetadata(
    popularity: 2030,
    codepoint: 0xea3b,
    categories: [15],
    tags: [
      2827,
      2828,
      2601,
      2829,
      2830,
      798,
      383,
      2831,
      2832,
      1201,
      299,
      2833,
      2834,
      302,
      2835,
      1659,
      304,
      2836,
      366,
      1210,
      2380,
      634,
      2837,
      2838,
      1741,
      945,
      2839,
      2537,
      1701
    ],
  ),
  "archive": SymbolsMetadata(
    popularity: 3537,
    codepoint: 0xe149,
    categories: [12],
    tags: [
      2151,
      2650,
      1651,
      7,
      2155,
      1269,
      10,
      1347,
      2840,
      337,
      1530,
      1023,
      851,
      135,
      966,
      1044,
      2159,
      2340,
      936,
      98,
      2841,
      2842,
      121,
      2843,
      2844,
      1664,
      674,
      1298
    ],
  ),
  "area_chart": SymbolsMetadata(
    popularity: 1076,
    codepoint: 0xe770,
    categories: [9],
    tags: [
      2513,
      5,
      993,
      2845,
      2846,
      1284,
      920,
      10,
      2847,
      924,
      808,
      929,
      196,
      933,
      135,
      2518,
      2848,
      597,
      634,
      937,
      2849,
      189,
      2850,
      2400,
      28,
      1353,
      2851,
      33,
      947,
      2852,
      1355
    ],
  ),
  "arming_countdown": SymbolsMetadata(
    popularity: 183,
    codepoint: 0xe78a,
    categories: [10],
    tags: [
      951,
      469,
      2827,
      2853,
      6,
      383,
      2092,
      2854,
      2137,
      2855,
      2856,
      999,
      2857,
      2568,
      1004,
      486,
      2858,
      2859,
      942,
      28,
      1520,
      1772,
      602,
      1773,
      1011,
      2649,
      1522,
      2860,
      553,
      791,
      1033,
      2147
    ],
  ),
  "arrow_and_edge": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xf5d7,
    categories: [2],
    tags: [
      380,
      2650,
      419,
      1058,
      2861,
      2862,
      1061,
      921,
      1484,
      1578,
      2651,
      2840,
      337,
      1597,
      926,
      2000,
      1542,
      2863,
      966,
      1044,
      2864,
      1064,
      935,
      1067,
      421,
      1586,
      2865,
      1318,
      1503,
      1378,
      36,
      441,
      2007,
      2571
    ],
  ),
  "arrow_back": SymbolsMetadata(
    popularity: 54088,
    codepoint: 0xe5c4,
    categories: [2],
    tags: [
      2866,
      1229,
      1230,
      380,
      2867,
      2868,
      2489,
      2869,
      2870,
      2871,
      2862,
      2750,
      269,
      388,
      2872,
      2873,
      1023,
      188,
      2751,
      2874,
      1375,
      2875,
      779,
      421,
      1783,
      2876,
      2877,
      2878,
      2879,
      2495,
      2880,
      2881,
      2496,
      330,
      2882,
      2757,
      2499,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_back_2": SymbolsMetadata(
    popularity: 53,
    codepoint: 0xf43a,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      2883,
      2489,
      2870,
      2871,
      2862,
      2750,
      269,
      785,
      388,
      2884,
      777,
      2873,
      1023,
      188,
      2751,
      2885,
      1375,
      367,
      2081,
      779,
      421,
      2162,
      1783,
      2876,
      2877,
      2878,
      2495,
      2881,
      2886,
      1396,
      330,
      2882,
      2887,
      1701,
      2757,
      2499,
      2759,
      41,
      1691,
      1053
    ],
  ),
  "arrow_back_ios": SymbolsMetadata(
    popularity: 39357,
    codepoint: 0xe5e0,
    categories: [2],
    tags: [
      2866,
      378,
      1229,
      1230,
      380,
      2489,
      2869,
      2870,
      2871,
      2862,
      2750,
      269,
      388,
      2872,
      2873,
      1023,
      188,
      2751,
      2888,
      1375,
      2875,
      219,
      779,
      421,
      1783,
      2876,
      2877,
      2878,
      2495,
      2880,
      2881,
      2886,
      330,
      2882,
      2757,
      2499,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_back_ios_new": SymbolsMetadata(
    popularity: 10823,
    codepoint: 0xe2ea,
    categories: [2],
    tags: [
      2866,
      2889,
      2890,
      1229,
      1230,
      380,
      2489,
      2870,
      2871,
      2862,
      2750,
      1062,
      388,
      2872,
      2884,
      2873,
      1023,
      188,
      2751,
      2888,
      1375,
      219,
      779,
      421,
      1783,
      2876,
      2878,
      2879,
      2495,
      2881,
      330,
      2882,
      1214,
      2757,
      2499,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_circle_down": SymbolsMetadata(
    popularity: 2895,
    codepoint: 0xf181,
    categories: [2],
    tags: [
      380,
      2891,
      2892,
      2188,
      2871,
      2893,
      2894,
      383,
      2895,
      2896,
      388,
      2651,
      337,
      2897,
      787,
      2652,
      1542,
      188,
      1674,
      2898,
      421,
      780,
      1664,
      2899,
      2900,
      2007
    ],
  ),
  "arrow_circle_left": SymbolsMetadata(
    popularity: 4180,
    codepoint: 0xeaa7,
    categories: [2],
    tags: [
      380,
      2892,
      2489,
      2901,
      383,
      2902,
      269,
      388,
      2884,
      2874,
      1375,
      390,
      2903,
      2081,
      779,
      421,
      2904,
      2876,
      2905,
      2906,
      2367,
      2495,
      2881,
      2886,
      396,
      402,
      2499,
      41
    ],
  ),
  "arrow_circle_right": SymbolsMetadata(
    popularity: 9077,
    codepoint: 0xeaaa,
    categories: [2],
    tags: [
      775,
      380,
      2892,
      383,
      2902,
      2907,
      2908,
      776,
      388,
      2909,
      777,
      2910,
      852,
      778,
      779,
      421,
      780,
      2162,
      781,
      28,
      1396,
      782,
      2911,
      2912,
      2913,
      108,
      1412
    ],
  ),
  "arrow_circle_up": SymbolsMetadata(
    popularity: 4241,
    codepoint: 0xf182,
    categories: [2],
    tags: [
      380,
      2466,
      2914,
      383,
      384,
      2490,
      776,
      388,
      787,
      777,
      1204,
      1207,
      778,
      421,
      780,
      1518,
      2495,
      2475,
      889,
      2899,
      2915,
      1124,
      1676,
      346,
      2916,
      2917
    ],
  ),
  "arrow_cool_down": SymbolsMetadata(
    popularity: 90,
    codepoint: 0xf4b6,
    categories: [15],
    tags: [
      380,
      2650,
      419,
      2188,
      2918,
      2871,
      2862,
      2896,
      2919,
      2920,
      2921,
      2448,
      2449,
      2922,
      2923,
      388,
      956,
      2651,
      337,
      2924,
      2925,
      2926,
      2927,
      2315,
      2928,
      421,
      780,
      2929,
      2930,
      2931,
      2932,
      2900,
      2933,
      2934,
      2935,
      944,
      791,
      2936,
      1381
    ],
  ),
  "arrow_downward": SymbolsMetadata(
    popularity: 11403,
    codepoint: 0xe5db,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      2650,
      2188,
      2871,
      2862,
      2896,
      2750,
      776,
      2937,
      2923,
      388,
      2651,
      337,
      2924,
      2938,
      2909,
      787,
      777,
      188,
      966,
      2751,
      788,
      421,
      780,
      330,
      2899,
      2882,
      106,
      1412,
      441,
      2939,
      2757,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_downward_alt": SymbolsMetadata(
    popularity: 189,
    codepoint: 0xe984,
    categories: [2],
    tags: [
      380,
      2650,
      419,
      2940,
      2188,
      2871,
      776,
      2937,
      388,
      2651,
      337,
      2924,
      2941,
      787,
      777,
      1542,
      188,
      966,
      1044,
      788,
      421,
      780,
      2653,
      2899,
      2900,
      2935,
      2007,
      2942
    ],
  ),
  "arrow_drop_down": SymbolsMetadata(
    popularity: 33121,
    codepoint: 0xe5c5,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      2650,
      2883,
      2943,
      2871,
      2944,
      2750,
      388,
      12,
      2651,
      1500,
      2938,
      2945,
      2941,
      2946,
      787,
      2947,
      2751,
      788,
      789,
      421,
      2653,
      2948,
      330,
      2899,
      2900,
      288,
      371,
      2882,
      314,
      1701,
      2939,
      2757,
      2949,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_drop_down_circle": SymbolsMetadata(
    popularity: 2569,
    codepoint: 0xe5c6,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      2891,
      2892,
      2871,
      383,
      2950,
      2896,
      2750,
      388,
      2651,
      1500,
      2938,
      2951,
      2941,
      2952,
      787,
      2953,
      1598,
      966,
      2751,
      92,
      788,
      789,
      421,
      2653,
      656,
      330,
      2899,
      2900,
      288,
      371,
      65,
      2882,
      314,
      2757,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_drop_up": SymbolsMetadata(
    popularity: 6327,
    codepoint: 0xe5c7,
    categories: [2],
    tags: [
      775,
      1229,
      1230,
      380,
      2954,
      2466,
      2871,
      2862,
      2750,
      388,
      1500,
      2955,
      787,
      2956,
      777,
      1204,
      2957,
      1207,
      188,
      2751,
      2958,
      421,
      780,
      1783,
      2475,
      330,
      2915,
      2882,
      1124,
      1701,
      2757,
      1676,
      1677,
      346,
      2916,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_forward": SymbolsMetadata(
    popularity: 35528,
    codepoint: 0xe5c8,
    categories: [2],
    tags: [
      775,
      1229,
      1230,
      380,
      2959,
      2960,
      419,
      2862,
      2750,
      776,
      269,
      388,
      2961,
      2909,
      2962,
      777,
      2910,
      339,
      2751,
      2903,
      778,
      779,
      421,
      780,
      2162,
      1783,
      781,
      28,
      1396,
      782,
      330,
      2343,
      2882,
      1412,
      2571,
      2757,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_forward_ios": SymbolsMetadata(
    popularity: 45601,
    codepoint: 0xe5e1,
    categories: [2],
    tags: [
      775,
      2963,
      1229,
      2964,
      1230,
      380,
      2965,
      2862,
      2750,
      776,
      388,
      2909,
      2962,
      777,
      339,
      2751,
      2888,
      778,
      779,
      421,
      780,
      2162,
      781,
      28,
      1396,
      782,
      330,
      2343,
      2882,
      2966,
      1412,
      2967,
      2757,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_insert": SymbolsMetadata(
    popularity: 172,
    codepoint: 0xf837,
    categories: [2],
    tags: [
      526,
      378,
      1229,
      1230,
      380,
      2968,
      2896,
      2750,
      1062,
      2969,
      388,
      2970,
      2909,
      787,
      1542,
      1206,
      188,
      2971,
      966,
      1044,
      2751,
      1375,
      421,
      2972,
      1495,
      1363,
      1783,
      330,
      2343,
      2882,
      1412,
      2221,
      1214,
      2757,
      346,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_left": SymbolsMetadata(
    popularity: 3299,
    codepoint: 0xe5de,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      2868,
      2489,
      2901,
      2870,
      2871,
      2862,
      2750,
      388,
      2884,
      2873,
      188,
      2751,
      2885,
      1375,
      2875,
      2973,
      2974,
      779,
      421,
      1783,
      2876,
      2877,
      2878,
      2495,
      2881,
      2886,
      330,
      2882,
      1701,
      2975,
      2757,
      2499,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_left_alt": SymbolsMetadata(
    popularity: 108,
    codepoint: 0xef7d,
    categories: [2],
    tags: [
      1499,
      2442,
      380,
      2976,
      419,
      2489,
      2870,
      2871,
      388,
      2977,
      2884,
      2873,
      188,
      2874,
      1375,
      2875,
      2973,
      2974,
      779,
      421,
      1783,
      2876,
      2878,
      2978,
      2495,
      2881,
      2886,
      2979,
      2238,
      1214,
      2499
    ],
  ),
  "arrow_menu_close": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf3d3,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      2980,
      2489,
      2869,
      2950,
      2981,
      2896,
      2982,
      2750,
      388,
      2983,
      2984,
      2985,
      2986,
      900,
      2987,
      188,
      2751,
      1375,
      2875,
      788,
      2988,
      2928,
      2989,
      2990,
      421,
      2653,
      1770,
      2991,
      2992,
      2495,
      1396,
      2993,
      2994,
      2882,
      1701,
      2757,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_menu_open": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf3d2,
    categories: [2],
    tags: [
      755,
      1229,
      1230,
      380,
      2950,
      2896,
      2750,
      269,
      388,
      2995,
      12,
      2983,
      2909,
      787,
      2996,
      777,
      1659,
      2986,
      188,
      2751,
      1375,
      92,
      788,
      789,
      2990,
      421,
      780,
      2653,
      656,
      2162,
      2948,
      1396,
      2997,
      2993,
      2882,
      108,
      314,
      1701,
      2757,
      2949,
      2759,
      1215,
      1691,
      1053
    ],
  ),
  "arrow_or_edge": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf5d6,
    categories: [2],
    tags: [
      378,
      2650,
      419,
      2188,
      1707,
      1062,
      2923,
      388,
      1578,
      2450,
      2998,
      2651,
      2840,
      337,
      2999,
      236,
      926,
      2652,
      1542,
      2863,
      1067,
      778,
      421,
      3000,
      1586,
      3001,
      2342,
      1503,
      1664,
      2007,
      2571,
      2455,
      3002,
      1381
    ],
  ),
  "arrow_outward": SymbolsMetadata(
    popularity: 2468,
    codepoint: 0xf8ce,
    categories: [2],
    tags: [
      378,
      1229,
      1230,
      380,
      419,
      2750,
      776,
      1062,
      2969,
      388,
      787,
      1672,
      2628,
      1471,
      777,
      2751,
      421,
      3003,
      780,
      2653,
      2398,
      3004,
      1586,
      781,
      1396,
      1503,
      330,
      2343,
      1665,
      2882,
      1214,
      2757,
      1676,
      346,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_range": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xf69b,
    categories: [2],
    tags: [
      1128,
      380,
      419,
      2489,
      3005,
      3006,
      2919,
      269,
      588,
      2450,
      3007,
      787,
      2996,
      2926,
      3008,
      2176,
      2875,
      3009,
      778,
      421,
      3010,
      3011,
      3001,
      3012,
      1007,
      2247,
      782,
      2281,
      1010,
      3013,
      372,
      2455,
      3014
    ],
  ),
  "arrow_right": SymbolsMetadata(
    popularity: 8986,
    codepoint: 0xe5df,
    categories: [2],
    tags: [
      775,
      1229,
      1230,
      380,
      2750,
      776,
      388,
      2909,
      787,
      2962,
      777,
      2910,
      2751,
      789,
      778,
      779,
      421,
      780,
      2653,
      2162,
      1363,
      781,
      28,
      1396,
      782,
      330,
      2343,
      2882,
      1412,
      2967,
      2571,
      1701,
      2757,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_right_alt": SymbolsMetadata(
    popularity: 18555,
    codepoint: 0xe941,
    categories: [2],
    tags: [
      755,
      775,
      1499,
      2963,
      380,
      3015,
      419,
      2862,
      776,
      388,
      3016,
      2909,
      787,
      777,
      339,
      188,
      789,
      778,
      779,
      421,
      780,
      2653,
      1783,
      3017,
      781,
      28,
      1396,
      782,
      3018,
      2343,
      1412
    ],
  ),
  "arrow_selector_tool": SymbolsMetadata(
    popularity: 534,
    codepoint: 0xf82f,
    categories: [6],
    tags: [
      2890,
      380,
      2883,
      419,
      266,
      1776,
      694,
      269,
      1781,
      299,
      388,
      302,
      696,
      2299,
      305,
      3019,
      1375,
      3020,
      421,
      281,
      3021,
      3022,
      1783,
      3017,
      1662,
      3023,
      288,
      371,
      3024,
      2537,
      1701,
      3025
    ],
  ),
  "arrow_split": SymbolsMetadata(
    popularity: 292,
    codepoint: 0xe985,
    categories: [2],
    tags: [
      380,
      2445,
      419,
      1994,
      3026,
      2447,
      3027,
      388,
      2173,
      2210,
      3028,
      3029,
      1370,
      2450,
      2651,
      926,
      2000,
      2557,
      421,
      656,
      1586,
      3030,
      942,
      1396,
      1503,
      2264,
      1378,
      2455,
      3031,
      1676,
      3032,
      2746
    ],
  ),
  "arrow_top_left": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf72e,
    categories: [2],
    tags: [
      378,
      380,
      3033,
      3034,
      419,
      2489,
      3035,
      2862,
      1062,
      2969,
      388,
      1659,
      778,
      421,
      1363,
      1783,
      2876,
      2495,
      396,
      3036,
      441,
      2221,
      2571,
      402,
      1214,
      2499,
      1676,
      3037,
      3038,
      3039
    ],
  ),
  "arrow_top_right": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf72d,
    categories: [2],
    tags: [
      380,
      3040,
      3041,
      419,
      3042,
      776,
      1062,
      388,
      3043,
      3016,
      1216,
      787,
      1471,
      777,
      1659,
      3044,
      421,
      3045,
      780,
      781,
      3046,
      2343,
      1665,
      3047,
      3048,
      402,
      1214,
      1676,
      346
    ],
  ),
  "arrow_upload_progress": SymbolsMetadata(
    popularity: 55,
    codepoint: 0xf3f4,
    categories: [2],
    tags: [
      380,
      383,
      384,
      1653,
      1540,
      3049,
      2448,
      2449,
      3050,
      1672,
      3051,
      3052,
      3053,
      1674,
      2568,
      3054,
      2858,
      3055,
      28,
      3056,
      2504,
      2505,
      2343,
      3057,
      1665,
      3058,
      553,
      1412,
      3059,
      2007,
      3060,
      1676,
      1677,
      346,
      3061,
      3062
    ],
  ),
  "arrow_upload_ready": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf3f5,
    categories: [2],
    tags: [
      380,
      3063,
      383,
      1653,
      1633,
      1540,
      2448,
      2449,
      3050,
      3064,
      2173,
      1672,
      3052,
      3065,
      1674,
      421,
      3066,
      2858,
      1409,
      28,
      2504,
      3067,
      3068,
      2343,
      1665,
      227,
      553,
      1412,
      36,
      2007,
      1676,
      1677,
      346,
      3069,
      3061,
      3062
    ],
  ),
  "arrow_upward": SymbolsMetadata(
    popularity: 14767,
    codepoint: 0xe5d8,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      2052,
      2466,
      2914,
      2871,
      2862,
      2750,
      776,
      388,
      787,
      777,
      1207,
      2751,
      778,
      421,
      780,
      3070,
      2475,
      330,
      2915,
      2343,
      2882,
      1412,
      441,
      1124,
      1701,
      2757,
      1676,
      346,
      2916,
      2759,
      1691,
      1053
    ],
  ),
  "arrow_upward_alt": SymbolsMetadata(
    popularity: 215,
    codepoint: 0xe986,
    categories: [2],
    tags: [
      775,
      380,
      3071,
      419,
      2466,
      2871,
      2862,
      388,
      787,
      777,
      1204,
      1207,
      421,
      780,
      3070,
      1518,
      2475,
      2343,
      441,
      1124,
      1701,
      1676,
      1677,
      533,
      346,
      2916,
      3072
    ],
  ),
  "arrow_warm_up": SymbolsMetadata(
    popularity: 114,
    codepoint: 0xf4b5,
    categories: [15],
    tags: [
      469,
      380,
      419,
      2466,
      3073,
      3074,
      1693,
      2448,
      2449,
      388,
      956,
      2767,
      3075,
      2925,
      787,
      2926,
      2927,
      1204,
      3076,
      3077,
      3078,
      530,
      1207,
      3079,
      3080,
      2568,
      421,
      486,
      3081,
      28,
      3056,
      3067,
      2475,
      2931,
      2932,
      108,
      553,
      791,
      1676,
      1677,
      346,
      3082,
      3083,
      3084,
      1261
    ],
  ),
  "arrows_input": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xf394,
    categories: [2],
    tags: [
      380,
      419,
      1730,
      3085,
      2896,
      1061,
      3086,
      3087,
      2919,
      3088,
      2922,
      1484,
      388,
      1738,
      3089,
      3090,
      3091,
      966,
      3092,
      1001,
      1490,
      1067,
      2179,
      2928,
      778,
      421,
      1495,
      1363,
      2930,
      3093,
      2933,
      1083,
      36,
      3094,
      986,
      2404
    ],
  ),
  "arrows_more_down": SymbolsMetadata(
    popularity: 162,
    codepoint: 0xf8ab,
    categories: [10],
    tags: [
      378,
      419,
      2188,
      3095,
      712,
      1042,
      785,
      1062,
      12,
      2651,
      337,
      2941,
      787,
      3096,
      1659,
      932,
      999,
      1066,
      92,
      788,
      789,
      421,
      1004,
      2653,
      656,
      3097,
      2948,
      3098,
      3046,
      2899,
      65,
      3099,
      107,
      729,
      3100,
      2949
    ],
  ),
  "arrows_more_up": SymbolsMetadata(
    popularity: 349,
    codepoint: 0xf8ac,
    categories: [10],
    tags: [
      378,
      419,
      2466,
      2871,
      2862,
      712,
      2896,
      776,
      1062,
      388,
      3101,
      2450,
      787,
      3102,
      1204,
      999,
      1207,
      2928,
      789,
      778,
      421,
      1004,
      781,
      2948,
      3046,
      2899,
      3103,
      729,
      2007,
      2455,
      1676,
      346
    ],
  ),
  "arrows_output": SymbolsMetadata(
    popularity: 72,
    codepoint: 0xf393,
    categories: [2],
    tags: [
      380,
      419,
      1730,
      2391,
      3064,
      1484,
      2969,
      388,
      832,
      1216,
      787,
      3104,
      2996,
      2628,
      3089,
      1673,
      1204,
      3080,
      1001,
      1490,
      2307,
      2179,
      778,
      2653,
      2398,
      1719,
      3004,
      1495,
      1363,
      2247,
      2281,
      1665,
      32,
      1083,
      2249,
      2949,
      986
    ],
  ),
  "arrows_outward": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xf72c,
    categories: [2],
    tags: [
      3105,
      380,
      3106,
      419,
      3107,
      2862,
      388,
      3108,
      2450,
      1216,
      787,
      3109,
      2393,
      2395,
      1673,
      1375,
      2875,
      2307,
      778,
      421,
      3010,
      2398,
      3004,
      2247,
      1396,
      782,
      2281,
      2401,
      2249,
      2455,
      3110,
      986,
      2403,
      2404
    ],
  ),
  "art_track": SymbolsMetadata(
    popularity: 396,
    codepoint: 0xe060,
    categories: [0],
    tags: [
      1538,
      1367,
      2829,
      3111,
      2152,
      1129,
      2155,
      1042,
      12,
      1541,
      930,
      53,
      1543,
      2159,
      92,
      367,
      1544,
      2557,
      2081,
      98,
      2295,
      59,
      61,
      119,
      2163,
      100,
      75,
      106,
      1156,
      32,
      107,
      441,
      2165,
      3112,
      1592,
      317
    ],
  ),
  "article": SymbolsMetadata(
    popularity: 9028,
    codepoint: 0xef42,
    categories: [12],
    tags: [
      2501,
      1652,
      1042,
      1201,
      3113,
      1528,
      1347,
      337,
      1853,
      1654,
      696,
      1530,
      1598,
      135,
      366,
      92,
      1533,
      2653,
      1361,
      1534,
      1535,
      2506,
      75,
      1353,
      1664,
      32,
      674,
      38,
      3114,
      441,
      346,
      317,
      1536,
      704
    ],
  ),
  "article_person": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf368,
    categories: [12],
    tags: [
      468,
      2501,
      3115,
      3116,
      1400,
      475,
      1042,
      3117,
      1528,
      1347,
      479,
      1530,
      483,
      850,
      135,
      92,
      853,
      3118,
      2503,
      3119,
      1534,
      1535,
      488,
      489,
      1409,
      490,
      2506,
      2507,
      78,
      2729,
      1412,
      1645,
      38,
      441,
      501,
      3120,
      704
    ],
  ),
  "article_shortcut": SymbolsMetadata(
    popularity: 75,
    codepoint: 0xf587,
    categories: [12],
    tags: [
      526,
      380,
      2501,
      1042,
      1540,
      1201,
      3121,
      388,
      1528,
      1347,
      2651,
      1471,
      1530,
      777,
      1542,
      366,
      935,
      763,
      1534,
      1535,
      1409,
      2504,
      979,
      3122,
      3123,
      75,
      3124,
      1396,
      2343,
      1665,
      982,
      32,
      1412,
      38,
      1677,
      346,
      704
    ],
  ),
  "artist": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xe01a,
    categories: [0],
    tags: [
      468,
      2152,
      3125,
      1129,
      470,
      3126,
      3127,
      3128,
      479,
      483,
      1143,
      2081,
      3129,
      3130,
      3131,
      3132,
      3133,
      3134,
      3135,
      3136,
      3137,
      1532,
      488,
      3138,
      489,
      3139,
      2163,
      490,
      3140,
      2164,
      1156,
      501,
      3141
    ],
  ),
  "aspect_ratio": SymbolsMetadata(
    popularity: 1708,
    codepoint: 0xe85b,
    categories: [1],
    tags: [
      2300,
      3142,
      3143,
      2301,
      2391,
      1819,
      2448,
      2449,
      3144,
      325,
      787,
      2242,
      1372,
      274,
      1673,
      53,
      3145,
      3146,
      117,
      1543,
      3147,
      854,
      3148,
      3149,
      2247,
      2281,
      3150,
      3151,
      3152,
      673,
      32,
      364,
      292,
      2309,
      986
    ],
  ),
  "assignment": SymbolsMetadata(
    popularity: 7239,
    codepoint: 0xe85d,
    categories: [12],
    tags: [
      1230,
      3115,
      1631,
      1750,
      1633,
      1528,
      1347,
      3153,
      3154,
      1598,
      1453,
      92,
      3155,
      1533,
      1456,
      98,
      2858,
      2838,
      3156,
      3157,
      1353,
      1031,
      3158,
      1412,
      1645,
      3159,
      3160,
      38,
      3161,
      1649,
      1459,
      704
    ],
  ),
  "assignment_add": SymbolsMetadata(
    popularity: 190,
    codepoint: 0xf848,
    categories: [12],
    tags: [
      192,
      526,
      1057,
      1230,
      3115,
      1058,
      1631,
      1750,
      693,
      1201,
      1528,
      1347,
      696,
      3153,
      1598,
      1453,
      1206,
      1044,
      92,
      763,
      1532,
      3155,
      1456,
      202,
      3156,
      1027,
      3162,
      3158,
      1412,
      35,
      1645,
      38,
      1459,
      704
    ],
  ),
  "assignment_ind": SymbolsMetadata(
    popularity: 3096,
    codepoint: 0xe85e,
    categories: [12],
    tags: [
      468,
      1509,
      1629,
      3163,
      3115,
      3164,
      6,
      799,
      383,
      1750,
      475,
      3165,
      1528,
      1347,
      3166,
      479,
      3167,
      3168,
      2809,
      3169,
      885,
      3170,
      853,
      488,
      489,
      3171,
      3172,
      490,
      3173,
      2744,
      1521,
      78,
      32,
      1645,
      501,
      3174
    ],
  ),
  "assignment_late": SymbolsMetadata(
    popularity: 1107,
    codepoint: 0xe85f,
    categories: [12],
    tags: [
      3175,
      469,
      3115,
      3073,
      1693,
      1750,
      3176,
      1018,
      2137,
      1528,
      1347,
      2766,
      2767,
      3177,
      3075,
      1530,
      1251,
      2769,
      3178,
      1641,
      3179,
      486,
      3180,
      2858,
      2772,
      1030,
      1353,
      1031,
      1412,
      35,
      1645,
      1649,
      1034,
      1261
    ],
  ),
  "assignment_return": SymbolsMetadata(
    popularity: 1005,
    codepoint: 0xe860,
    categories: [12],
    tags: [
      380,
      3115,
      2489,
      1750,
      1633,
      3181,
      388,
      1528,
      1347,
      696,
      480,
      3065,
      1598,
      3182,
      1453,
      1375,
      2875,
      2876,
      75,
      1353,
      3183,
      2495,
      2881,
      2496,
      3184,
      3185,
      32,
      1412,
      1645,
      2499
    ],
  ),
  "assignment_returned": SymbolsMetadata(
    popularity: 477,
    codepoint: 0xe861,
    categories: [12],
    tags: [
      380,
      2650,
      3115,
      1631,
      1750,
      1633,
      1528,
      1347,
      2651,
      337,
      2924,
      3153,
      480,
      1530,
      3186,
      3182,
      3187,
      1453,
      1542,
      2342,
      75,
      1353,
      2844,
      2495,
      3188,
      3158,
      32,
      1412,
      1645,
      3189
    ],
  ),
  "assignment_turned_in": SymbolsMetadata(
    popularity: 2973,
    codepoint: 0xe862,
    categories: [12],
    tags: [
      1627,
      1549,
      3115,
      3190,
      1630,
      1631,
      1632,
      1750,
      1633,
      1634,
      1636,
      1528,
      1347,
      1639,
      3153,
      3154,
      1640,
      3191,
      1453,
      3091,
      1641,
      1643,
      3157,
      1353,
      3158,
      288,
      1412,
      3192,
      1645,
      3160,
      1647,
      402,
      3193,
      2386,
      2387,
      1523,
      1650
    ],
  ),
  "assist_walker": SymbolsMetadata(
    popularity: 333,
    codepoint: 0xf8d5,
    categories: [5],
    tags: [
      733,
      734,
      3194,
      3195,
      736,
      3196,
      738,
      584,
      741,
      3197,
      3198,
      744,
      1753,
      482,
      483,
      746,
      3199,
      3200,
      3201,
      1757,
      770,
      3202,
      489,
      3203,
      3204,
      3205,
      750,
      495,
      3206,
      3207,
      3208,
      3209
    ],
  ),
  "assistant_device": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xe987,
    categories: [11],
    tags: [
      3210,
      3211,
      3212,
      3213,
      3214,
      1129,
      2148,
      383,
      443,
      445,
      3215,
      832,
      3216,
      1711,
      2590,
      1189,
      965,
      999,
      3217,
      3218,
      1435,
      215,
      1897,
      1143,
      1147,
      1004,
      75,
      77,
      1155,
      1901,
      3219,
      1156,
      1157,
      496,
      551,
      3220,
      3221,
      3222,
      234
    ],
  ),
  "assistant_direction": SymbolsMetadata(
    popularity: 1627,
    codepoint: 0xe988,
    categories: [2],
    tags: [
      380,
      3213,
      3223,
      383,
      776,
      1484,
      1416,
      388,
      3224,
      1578,
      777,
      1488,
      3225,
      3226,
      1001,
      1002,
      1490,
      779,
      421,
      780,
      1586,
      1493,
      1495,
      781,
      1396,
      3227,
      396,
      1503,
      3228,
      32,
      1083,
      1504,
      402,
      3229
    ],
  ),
  "assistant_navigation": SymbolsMetadata(
    popularity: 2596,
    codepoint: 0xe989,
    categories: [2],
    tags: [
      380,
      3213,
      383,
      2831,
      776,
      1484,
      388,
      1578,
      958,
      777,
      1488,
      3225,
      3226,
      188,
      1581,
      1001,
      1002,
      1490,
      421,
      780,
      3070,
      1493,
      1495,
      1363,
      781,
      1503,
      1083,
      3230,
      1504,
      1701,
      1676,
      3229
    ],
  ),
  "assistant_on_hub": SymbolsMetadata(
    popularity: 55,
    codepoint: 0xf6c1,
    categories: [10],
    tags: [
      3210,
      3231,
      3213,
      3232,
      2148,
      268,
      211,
      3233,
      3234,
      2515,
      1685,
      445,
      3215,
      12,
      956,
      3216,
      1189,
      965,
      999,
      3235,
      1435,
      3236,
      2751,
      215,
      788,
      327,
      1004,
      223,
      656,
      330,
      65,
      1155,
      3237,
      1901,
      3238,
      791,
      3221,
      234
    ],
  ),
  "assured_workload": SymbolsMetadata(
    popularity: 2156,
    codepoint: 0xeb6f,
    categories: [13],
    tags: [
      468,
      3239,
      3240,
      794,
      795,
      797,
      798,
      799,
      800,
      1632,
      801,
      803,
      3241,
      3242,
      804,
      805,
      806,
      3243,
      3244,
      3245,
      807,
      3246,
      3247,
      808,
      812,
      814,
      818,
      819,
      820,
      821,
      822,
      1520,
      3248,
      3249,
      1772,
      602,
      1773,
      3250,
      3251,
      1011,
      3252,
      1522,
      2745,
      1523,
      3253
    ],
  ),
  "asterisk": SymbolsMetadata(
    popularity: 87,
    codepoint: 0xf525,
    categories: [12],
    tags: [
      3254,
      3255,
      8,
      2950,
      2896,
      897,
      3256,
      3257,
      3258,
      787,
      14,
      3259,
      3019,
      16,
      1251,
      1641,
      1210,
      2380,
      788,
      3260,
      3261,
      421,
      3262,
      656,
      3124,
      911,
      65,
      3263,
      3264,
      35,
      38,
      3265,
      40,
      3266,
      986
    ],
  ),
  "atm": SymbolsMetadata(
    popularity: 515,
    codepoint: 0xe573,
    categories: [9],
    tags: [
      4,
      3267,
      3268,
      3269,
      3270,
      3271,
      796,
      3272,
      797,
      690,
      799,
      1619,
      800,
      3273,
      8,
      801,
      803,
      805,
      829,
      806,
      830,
      3274,
      88,
      807,
      808,
      809,
      14,
      811,
      19,
      1001,
      1717,
      1002,
      818,
      3275,
      819,
      820,
      821,
      1493,
      26,
      3276,
      701,
      841,
      35,
      3277,
      3278,
      38,
      842,
      40,
      3279
    ],
  ),
  "atr": SymbolsMetadata(
    popularity: 1035,
    codepoint: 0xebc7,
    categories: [9],
    tags: [
      733,
      3280,
      953,
      3281,
      2896,
      194,
      921,
      211,
      832,
      956,
      787,
      930,
      932,
      788,
      789,
      421,
      223,
      3282,
      656,
      940,
      329,
      1698,
      65,
      1665,
      3058,
      607,
      609,
      945,
      946,
      983,
      791,
      1701,
      1459
    ],
  ),
  "attach_email": SymbolsMetadata(
    popularity: 1094,
    codepoint: 0xea5e,
    categories: [7],
    tags: [
      526,
      1058,
      3283,
      3284,
      1466,
      1469,
      443,
      693,
      475,
      2331,
      1347,
      337,
      2335,
      3285,
      3286,
      1530,
      777,
      851,
      1044,
      19,
      935,
      2340,
      485,
      3287,
      3288,
      3289,
      1410,
      2343,
      1665,
      346
    ],
  ),
  "attach_file": SymbolsMetadata(
    popularity: 7758,
    codepoint: 0xe226,
    categories: [12],
    tags: [
      526,
      3290,
      1341,
      3291,
      1057,
      1058,
      3283,
      3284,
      1466,
      1469,
      3292,
      921,
      1347,
      1530,
      1044,
      3293,
      1064,
      935,
      3294,
      2340,
      367,
      1456,
      1535,
      3289,
      1493,
      3295,
      3296,
      346,
      3297
    ],
  ),
  "attach_file_add": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf841,
    categories: [12],
    tags: [
      192,
      526,
      3290,
      3291,
      1462,
      1057,
      1058,
      3283,
      3284,
      3298,
      1466,
      1469,
      3299,
      1061,
      1201,
      1530,
      1206,
      1044,
      3293,
      1064,
      935,
      3300,
      2340,
      367,
      763,
      3289,
      3301,
      202,
      1212,
      346
    ],
  ),
  "attach_file_off": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf4d9,
    categories: [12],
    tags: [
      526,
      1058,
      1466,
      1074,
      895,
      1469,
      3302,
      897,
      3303,
      3304,
      1077,
      3305,
      767,
      3306,
      898,
      1530,
      899,
      1044,
      935,
      2340,
      367,
      3307,
      3308,
      907,
      908,
      909,
      3289,
      911,
      3309,
      3310,
      914,
      3311,
      915,
      3312,
      346
    ],
  ),
  "attach_money": SymbolsMetadata(
    popularity: 13815,
    codepoint: 0xe227,
    categories: [9],
    tags: [
      3313,
      526,
      1058,
      796,
      797,
      828,
      1618,
      799,
      800,
      383,
      801,
      803,
      3314,
      1327,
      805,
      806,
      3315,
      807,
      3316,
      3317,
      3318,
      808,
      809,
      3319,
      3320,
      815,
      935,
      3321,
      818,
      909,
      819,
      820,
      821,
      1337,
      840,
      3322,
      841,
      35,
      842,
      3323,
      3324
    ],
  ),
  "attachment": SymbolsMetadata(
    popularity: 3116,
    codepoint: 0xe2bc,
    categories: [12],
    tags: [
      3325,
      2587,
      526,
      1058,
      1466,
      1469,
      693,
      921,
      3326,
      1347,
      3327,
      1530,
      3328,
      16,
      53,
      2751,
      1064,
      366,
      935,
      390,
      3329,
      3330,
      1456,
      3289,
      1586,
      3331,
      311,
      105,
      3296,
      35,
      2537
    ],
  ),
  "attractions": SymbolsMetadata(
    popularity: 884,
    codepoint: 0xea52,
    categories: [16],
    tags: [
      989,
      3332,
      3333,
      3334,
      3335,
      3336,
      383,
      384,
      2602,
      1484,
      3337,
      3338,
      3339,
      3340,
      3341,
      2819,
      3342,
      2018,
      3343,
      3344,
      1490,
      3345,
      2613,
      3346,
      3347,
      2072,
      396,
      2569,
      3348,
      2023,
      1504,
      2024,
      773
    ],
  ),
  "attribution": SymbolsMetadata(
    popularity: 741,
    codepoint: 0xefdb,
    categories: [7],
    tags: [
      468,
      3349,
      3350,
      3351,
      3352,
      3116,
      584,
      3353,
      383,
      3354,
      3355,
      3356,
      3357,
      3358,
      3359,
      3128,
      805,
      3360,
      483,
      850,
      885,
      3361,
      3362,
      3363,
      488,
      489,
      490,
      3124,
      1257,
      3364,
      501,
      3365,
      3366
    ],
  ),
  "audio_description": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf58c,
    categories: [0],
    tags: [
      733,
      1035,
      4,
      3367,
      3368,
      739,
      1129,
      3369,
      3370,
      355,
      8,
      3371,
      3372,
      3373,
      3374,
      3153,
      270,
      14,
      3375,
      19,
      326,
      278,
      3376,
      3377,
      1152,
      330,
      3378,
      3379,
      227,
      1156,
      3380,
      3381,
      35,
      38,
      344,
      3382,
      40,
      41,
      291,
      3383,
      3384,
      1902
    ],
  ),
  "audio_file": SymbolsMetadata(
    popularity: 698,
    codepoint: 0xeb82,
    categories: [0],
    tags: [
      3385,
      1129,
      3386,
      3387,
      3388,
      3389,
      1528,
      1347,
      1530,
      968,
      1143,
      367,
      3390,
      328,
      2081,
      3391,
      3392,
      3393,
      3394,
      1532,
      2162,
      2163,
      1152,
      121,
      3395,
      1156,
      3396,
      3397,
      3398,
      3399,
      2165,
      3400
    ],
  ),
  "audio_video_receiver": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf5d3,
    categories: [11],
    tags: [
      2500,
      3401,
      1888,
      1129,
      3402,
      382,
      3403,
      3404,
      3405,
      298,
      383,
      269,
      445,
      1711,
      3337,
      3406,
      3407,
      3408,
      367,
      326,
      2081,
      2083,
      1318,
      75,
      3409,
      77,
      65,
      1156,
      3410,
      3411,
      343,
      3412,
      3413,
      344,
      41,
      3414
    ],
  ),
  "auto_awesome_mosaic": SymbolsMetadata(
    popularity: 712,
    codepoint: 0xe660,
    categories: [1],
    tags: [
      1128,
      2169,
      1367,
      1131,
      3415,
      3416,
      918,
      3417,
      1061,
      3418,
      12,
      1370,
      696,
      2299,
      528,
      3419,
      1541,
      246,
      53,
      3145,
      306,
      1067,
      3420,
      98,
      3421,
      59,
      3422,
      2258,
      3423,
      3424,
      3425,
      1378,
      944,
      945,
      3426,
      3427,
      317,
      1054
    ],
  ),
  "auto_awesome_motion": SymbolsMetadata(
    popularity: 899,
    codepoint: 0xe661,
    categories: [1],
    tags: [
      1128,
      264,
      1131,
      1132,
      2148,
      3416,
      3095,
      267,
      3428,
      3417,
      2391,
      696,
      2299,
      528,
      3429,
      270,
      53,
      530,
      1066,
      367,
      420,
      1858,
      278,
      59,
      3046,
      190,
      104,
      32,
      107,
      41
    ],
  ),
  "auto_delete": SymbolsMetadata(
    popularity: 1124,
    codepoint: 0xea4c,
    categories: [6],
    tags: [
      2151,
      1131,
      3430,
      3431,
      1132,
      3432,
      1616,
      3433,
      3434,
      3435,
      3436,
      1016,
      1269,
      1017,
      897,
      3437,
      3438,
      3439,
      1023,
      3440,
      1029,
      911,
      1031,
      3441,
      674,
      3442,
      3443,
      289,
      1033,
      3444,
      3445
    ],
  ),
  "auto_read_pause": SymbolsMetadata(
    popularity: 287,
    codepoint: 0xf219,
    categories: [7],
    tags: [
      1129,
      1131,
      3446,
      3447,
      1132,
      2136,
      471,
      472,
      473,
      474,
      269,
      477,
      3448,
      3449,
      1143,
      485,
      3377,
      1082,
      283,
      2904,
      2506,
      75,
      77,
      493,
      494,
      1083,
      38,
      1214,
      1592,
      1161,
      2147
    ],
  ),
  "auto_read_play": SymbolsMetadata(
    popularity: 427,
    codepoint: 0xf216,
    categories: [7],
    tags: [
      380,
      1129,
      1131,
      3450,
      3451,
      1132,
      3452,
      3453,
      471,
      472,
      1401,
      473,
      474,
      476,
      477,
      1143,
      367,
      485,
      1406,
      2162,
      3454,
      283,
      1152,
      2506,
      782,
      77,
      493,
      494,
      32,
      108,
      342,
      496,
      1701,
      41,
      2102
    ],
  ),
  "auto_stories": SymbolsMetadata(
    popularity: 4902,
    codepoint: 0xe666,
    categories: [1],
    tags: [
      2501,
      1131,
      1132,
      2148,
      1400,
      1910,
      3455,
      1042,
      3456,
      1201,
      3457,
      3458,
      1347,
      3153,
      3459,
      2550,
      3460,
      3461,
      3375,
      2159,
      3462,
      2503,
      3463,
      1534,
      3464,
      2506,
      2507,
      3379,
      2509,
      2510,
      3465
    ],
  ),
  "auto_towing": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xe71e,
    categories: [14],
    tags: [
      3466,
      738,
      1131,
      1814,
      3467,
      3468,
      3469,
      1815,
      1816,
      3470,
      388,
      2482,
      3471,
      2527,
      3472,
      1490,
      3473,
      3474,
      3475,
      3476,
      2631,
      3477,
      3478,
      3479,
      1842,
      1930,
      1843,
      1844,
      3480,
      3481
    ],
  ),
  "auto_transmission": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf53f,
    categories: [14],
    tags: [
      534,
      1131,
      1132,
      3482,
      1814,
      3467,
      1815,
      1731,
      953,
      3483,
      922,
      269,
      3484,
      538,
      3485,
      3486,
      3487,
      3488,
      3489,
      366,
      3490,
      3491,
      281,
      1586,
      285,
      65,
      3036,
      3492,
      231,
      3493,
      3494,
      2085,
      1842,
      1930,
      1844
    ],
  ),
  "autofps_select": SymbolsMetadata(
    popularity: 150,
    codepoint: 0xefdc,
    categories: [1],
    tags: [
      3495,
      1128,
      4,
      264,
      1131,
      1132,
      365,
      47,
      8,
      267,
      383,
      268,
      269,
      270,
      14,
      273,
      274,
      275,
      358,
      277,
      2781,
      19,
      420,
      278,
      3496,
      282,
      189,
      283,
      286,
      177,
      103,
      287,
      288,
      65,
      372,
      3497,
      231,
      35,
      38,
      314,
      40,
      41
    ],
  ),
  "automation": SymbolsMetadata(
    popularity: 358,
    codepoint: 0xf421,
    categories: [12],
    tags: [
      3211,
      3498,
      3212,
      1131,
      1132,
      2148,
      3499,
      2538,
      921,
      211,
      269,
      385,
      3500,
      926,
      3501,
      2629,
      3502,
      935,
      1000,
      390,
      3503,
      3504,
      936,
      3282,
      977,
      3505,
      942,
      3506,
      2367,
      3507,
      104,
      2632,
      1645,
      2746,
      3508
    ],
  ),
  "autopause": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf6b6,
    categories: [0],
    tags: [
      2284,
      380,
      3509,
      1132,
      3510,
      3511,
      3512,
      383,
      384,
      269,
      785,
      2448,
      2449,
      3513,
      2568,
      390,
      2903,
      326,
      2081,
      1082,
      2141,
      283,
      3514,
      424,
      425,
      2494,
      3515,
      3516,
      2143,
      2495,
      2886,
      396,
      397,
      1156,
      1667,
      1214,
      3517,
      2499,
      41
    ],
  ),
  "autoplay": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf6b5,
    categories: [0],
    tags: [
      2284,
      380,
      1129,
      1132,
      3452,
      3453,
      383,
      384,
      2348,
      2349,
      269,
      785,
      385,
      2448,
      2449,
      926,
      3513,
      2568,
      390,
      367,
      2081,
      780,
      2162,
      3454,
      283,
      424,
      2494,
      2367,
      3515,
      3516,
      396,
      104,
      1156,
      108,
      3518,
      1667,
      3519,
      41
    ],
  ),
  "autorenew": SymbolsMetadata(
    popularity: 12702,
    codepoint: 0xe863,
    categories: [2],
    tags: [
      2284,
      380,
      419,
      3520,
      3521,
      3522,
      383,
      384,
      2907,
      2349,
      3523,
      385,
      388,
      2450,
      3524,
      3513,
      3525,
      390,
      421,
      2492,
      424,
      3526,
      425,
      3527,
      2494,
      2367,
      3515,
      426,
      3516,
      3528,
      2496,
      396,
      397,
      1667,
      3529,
      402,
      2499,
      1260
    ],
  ),
  "autostop": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf682,
    categories: [0],
    tags: [
      2284,
      380,
      1132,
      2148,
      3530,
      2136,
      895,
      3531,
      383,
      269,
      785,
      385,
      386,
      2448,
      2449,
      3448,
      2140,
      3513,
      2568,
      390,
      391,
      2081,
      424,
      425,
      2494,
      2367,
      3532,
      3515,
      426,
      3516,
      2496,
      396,
      397,
      1156,
      32,
      1083,
      1667,
      402,
      403,
      2499
    ],
  ),
  "av1": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf4b0,
    categories: [0],
    tags: [
      79,
      3533,
      4,
      3534,
      382,
      3535,
      8,
      3536,
      3537,
      3538,
      668,
      356,
      12,
      337,
      3539,
      1530,
      3540,
      270,
      14,
      1372,
      2471,
      18,
      19,
      278,
      3541,
      328,
      3542,
      3543,
      2162,
      283,
      75,
      30,
      77,
      3544,
      330,
      32,
      342,
      35,
      38,
      344,
      40,
      41,
      3545,
      3546,
      648
    ],
  ),
  "av_timer": SymbolsMetadata(
    popularity: 1344,
    codepoint: 0xe01b,
    categories: [0],
    tags: [
      1015,
      380,
      382,
      3547,
      383,
      384,
      1016,
      2092,
      956,
      1020,
      2568,
      3548,
      1082,
      942,
      28,
      424,
      1030,
      396,
      889,
      1031,
      287,
      65,
      3549,
      1667,
      3529,
      791,
      289,
      1033,
      1260,
      2147,
      2102
    ],
  ),
  "avc": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf4af,
    categories: [0],
    tags: [
      687,
      3550,
      4,
      3551,
      7,
      8,
      3536,
      3537,
      1269,
      3538,
      668,
      356,
      12,
      337,
      3539,
      1530,
      270,
      14,
      1372,
      3552,
      2471,
      19,
      326,
      278,
      3541,
      3553,
      328,
      283,
      75,
      30,
      77,
      330,
      342,
      35,
      38,
      3554,
      344,
      40,
      41,
      364,
      3555,
      3556,
      291
    ],
  ),
  "avg_pace": SymbolsMetadata(
    popularity: 97,
    codepoint: 0xf6bb,
    categories: [15],
    tags: [
      5,
      3557,
      3558,
      3559,
      383,
      1016,
      2448,
      2515,
      2449,
      1308,
      956,
      1020,
      2927,
      3560,
      188,
      597,
      634,
      3561,
      937,
      3562,
      3563,
      189,
      1783,
      28,
      286,
      2542,
      231,
      3564,
      3549,
      3565,
      289,
      1033,
      947
    ],
  ),
  "avg_time": SymbolsMetadata(
    popularity: 66,
    codepoint: 0xf813,
    categories: [15],
    tags: [
      5,
      3557,
      3566,
      3567,
      3568,
      383,
      1016,
      1020,
      2927,
      277,
      595,
      3569,
      1602,
      597,
      634,
      937,
      327,
      2082,
      189,
      3570,
      227,
      3571,
      231,
      33,
      3549,
      3565,
      289,
      1033,
      2165,
      947,
      3572,
      1862,
      1905
    ],
  ),
  "award_star": SymbolsMetadata(
    popularity: 278,
    codepoint: 0xf612,
    categories: [6],
    tags: [
      3573,
      3,
      3574,
      6,
      3575,
      1670,
      3576,
      3257,
      3577,
      3578,
      1659,
      3579,
      1251,
      3580,
      531,
      3581,
      62,
      3582,
      102,
      3583,
      3584,
      3585,
      311,
      3586,
      3264,
      3587,
      2487,
      3588,
      3589
    ],
  ),
  "azm": SymbolsMetadata(
    popularity: 89,
    codepoint: 0xf6ec,
    categories: [15],
    tags: [
      3325,
      1242,
      3590,
      2890,
      380,
      419,
      3591,
      2539,
      2862,
      3592,
      388,
      2450,
      3593,
      2925,
      2926,
      2927,
      777,
      1659,
      196,
      16,
      366,
      2528,
      3548,
      3594,
      421,
      780,
      1783,
      28,
      1396,
      2343,
      311,
      3024,
      3595,
      35,
      2916,
      3596,
      1013
    ],
  ),
  "baby_changing_station": SymbolsMetadata(
    popularity: 638,
    codepoint: 0xf19b,
    categories: [5],
    tags: [
      733,
      734,
      3597,
      3598,
      3599,
      1868,
      584,
      3600,
      1731,
      3601,
      862,
      3602,
      865,
      3603,
      3604,
      867,
      3605,
      483,
      3606,
      871,
      1001,
      1002,
      3607,
      3608,
      3609,
      874,
      876,
      488,
      489,
      2071,
      3610,
      2631,
      3611,
      1380,
      3612,
      1885,
      3613,
      879
    ],
  ),
  "back_hand": SymbolsMetadata(
    popularity: 2056,
    codepoint: 0xe764,
    categories: [8],
    tags: [
      2489,
      2869,
      3614,
      2870,
      895,
      388,
      3615,
      2734,
      538,
      3616,
      2735,
      2873,
      2738,
      3617,
      1023,
      2874,
      1375,
      3618,
      421,
      2743,
      2876,
      2878,
      3619,
      2978,
      2495,
      3620,
      2881,
      2496,
      2499
    ],
  ),
  "back_to_tab": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf72b,
    categories: [2],
    tags: [
      3621,
      380,
      2489,
      3622,
      3042,
      1039,
      3623,
      1062,
      2985,
      1471,
      274,
      1375,
      2875,
      390,
      779,
      421,
      3624,
      3625,
      2876,
      75,
      2495,
      3626,
      2496,
      32,
      3627,
      1070,
      3628,
      2499,
      1676,
      3629,
      1054
    ],
  ),
  "background_dot_large": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf79e,
    categories: [1],
    tags: [
      3630,
      3631,
      3632,
      298,
      266,
      383,
      953,
      269,
      832,
      956,
      538,
      961,
      3633,
      246,
      3019,
      3634,
      306,
      2753,
      788,
      421,
      281,
      3635,
      285,
      78,
      288,
      371,
      65,
      609,
      32,
      3636,
      3637,
      314
    ],
  ),
  "background_dot_small": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf514,
    categories: [1],
    tags: [
      2170,
      3638,
      3630,
      918,
      3639,
      956,
      3640,
      246,
      306,
      2753,
      788,
      682,
      656,
      98,
      3635,
      27,
      3641,
      329,
      78,
      288,
      371,
      65,
      1979,
      3642,
      609,
      32,
      945,
      3636,
      3637,
      3426
    ],
  ),
  "background_grid_small": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf79d,
    categories: [1],
    tags: [
      534,
      3643,
      2170,
      3630,
      3644,
      3645,
      3639,
      802,
      299,
      3419,
      246,
      1387,
      3646,
      306,
      1602,
      2753,
      940,
      98,
      3635,
      1376,
      3647,
      3648,
      609,
      1379,
      3649,
      944,
      945,
      1380,
      3636,
      3650,
      3426
    ],
  ),
  "background_replace": SymbolsMetadata(
    popularity: 1341,
    codepoint: 0xf20a,
    categories: [6],
    tags: [
      3651,
      470,
      3652,
      3653,
      3630,
      47,
      3654,
      3655,
      2969,
      3656,
      3657,
      959,
      483,
      3658,
      1543,
      366,
      3635,
      488,
      489,
      3659,
      854,
      490,
      3660,
      3661,
      3662,
      3663,
      1546,
      310,
      32,
      2586,
      3664,
      3636,
      501,
      3665,
      41,
      352
    ],
  ),
  "backlight_high": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf7ed,
    categories: [4],
    tags: [
      3666,
      3667,
      3668,
      3669,
      3670,
      1728,
      3671,
      785,
      3672,
      325,
      3673,
      3674,
      3675,
      3676,
      3677,
      3678,
      3679,
      969,
      3680,
      3681,
      3682,
      618,
      3683,
      3684,
      3685,
      3151,
      65,
      3686,
      3687
    ],
  ),
  "backlight_high_off": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf4ef,
    categories: [4],
    tags: [
      3667,
      3688,
      3668,
      3670,
      1728,
      3689,
      895,
      3690,
      3691,
      3692,
      3693,
      767,
      3672,
      898,
      3694,
      3675,
      969,
      3680,
      366,
      3695,
      3696,
      3697,
      3698,
      907,
      908,
      909,
      3684,
      2258,
      3685,
      3699,
      914,
      2126,
      3686,
      441,
      3700,
      3701
    ],
  ),
  "backlight_low": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf7ec,
    categories: [4],
    tags: [
      3666,
      3667,
      3668,
      1728,
      3702,
      3703,
      3704,
      3690,
      3705,
      3706,
      3691,
      3707,
      3672,
      3708,
      3677,
      969,
      3709,
      3680,
      3710,
      3711,
      3712,
      3713,
      3695,
      3714,
      75,
      3715,
      1421,
      3685,
      3716,
      944,
      3717,
      2936
    ],
  ),
  "backpack": SymbolsMetadata(
    popularity: 973,
    codepoint: 0xf19c,
    categories: [15],
    tags: [
      2464,
      2489,
      3718,
      3719,
      3720,
      1910,
      3721,
      3722,
      3723,
      1269,
      3153,
      2523,
      835,
      3489,
      3724,
      2245,
      3725,
      3726,
      3727,
      3728,
      790,
      2585,
      75,
      3729,
      3158,
      32,
      674,
      2592,
      3730,
      1504
    ],
  ),
  "backspace": SymbolsMetadata(
    popularity: 9071,
    codepoint: 0xe14a,
    categories: [2],
    tags: [
      380,
      2489,
      3731,
      2870,
      895,
      3732,
      3436,
      2376,
      3181,
      1202,
      897,
      696,
      1597,
      3438,
      1598,
      966,
      969,
      2875,
      2876,
      911,
      2495,
      2184,
      3733,
      3734,
      40,
      3735,
      2499,
      3736
    ],
  ),
  "backup": SymbolsMetadata(
    popularity: 2029,
    codepoint: 0xe864,
    categories: [6],
    tags: [
      2151,
      3737,
      380,
      1651,
      1652,
      3738,
      3739,
      3740,
      3741,
      10,
      3742,
      3743,
      3744,
      3050,
      1654,
      3745,
      3052,
      3746,
      3747,
      1520,
      3748,
      1663,
      3749,
      1664,
      1011,
      674,
      1298,
      1667,
      3750,
      2007,
      1676,
      1677,
      346
    ],
  ),
  "backup_table": SymbolsMetadata(
    popularity: 807,
    codepoint: 0xef43,
    categories: [6],
    tags: [
      2151,
      1651,
      3751,
      3752,
      3753,
      3741,
      1707,
      10,
      3754,
      3755,
      3756,
      3757,
      3758,
      1654,
      2999,
      3746,
      1372,
      246,
      3759,
      306,
      3748,
      75,
      2843,
      3749,
      3760,
      1664,
      3761,
      1379,
      32,
      107,
      674,
      1380,
      3762,
      2936
    ],
  ),
  "badge": SymbolsMetadata(
    popularity: 11591,
    codepoint: 0xea67,
    categories: [13],
    tags: [
      755,
      468,
      1768,
      1769,
      470,
      6,
      799,
      1510,
      1942,
      1469,
      1135,
      3763,
      3166,
      2094,
      479,
      483,
      3167,
      3168,
      2809,
      850,
      3118,
      3764,
      3765,
      2028,
      488,
      3766,
      489,
      490,
      75,
      1011,
      3767,
      2384,
      501,
      2388,
      3768,
      1459
    ],
  ),
  "badge_critical_battery": SymbolsMetadata(
    popularity: 344,
    codepoint: 0xf147,
    categories: [4],
    tags: [
      469,
      6,
      1343,
      3769,
      3770,
      3771,
      3772,
      1113,
      3773,
      3774,
      3775,
      3776,
      3777,
      445,
      3778,
      3779,
      965,
      3780,
      3781,
      219,
      486,
      3782,
      3783,
      75,
      65,
      553,
      2632,
      3784,
      1261
    ],
  ),
  "bakery_dining": SymbolsMetadata(
    popularity: 1343,
    codepoint: 0xea53,
    categories: [16],
    tags: [
      3785,
      3786,
      3787,
      3788,
      3789,
      3790,
      3791,
      3792,
      3793,
      3794,
      3795,
      3796,
      3797,
      3798,
      3799,
      3800,
      3801,
      1829,
      3802,
      3803,
      3804,
      3805,
      3806,
      3807,
      3808,
      3809,
      3810,
      441
    ],
  ),
  "balance": SymbolsMetadata(
    popularity: 2794,
    codepoint: 0xeaf6,
    categories: [11],
    tags: [
      3811,
      2514,
      794,
      2447,
      3812,
      3813,
      3814,
      3815,
      3816,
      3027,
      2174,
      3817,
      2319,
      3818,
      3819,
      3820,
      3821,
      3822,
      3823,
      816,
      817,
      597,
      634,
      656,
      3824,
      3825,
      3826,
      3827,
      3828,
      2206,
      3829,
      3830,
      3831
    ],
  ),
  "balcony": SymbolsMetadata(
    popularity: 407,
    codepoint: 0xe58f,
    categories: [8],
    tags: [
      1940,
      2600,
      3832,
      2601,
      3833,
      3834,
      798,
      3835,
      3836,
      3837,
      2605,
      3838,
      529,
      3839,
      999,
      1435,
      1490,
      3840,
      2398,
      1860,
      3841,
      3842,
      1495,
      3843,
      1444,
      3844,
      2614,
      1445,
      2615,
      1446,
      2616,
      3845,
      3846,
      3847,
      3848,
      317,
      1054
    ],
  ),
  "ballot": SymbolsMetadata(
    popularity: 1454,
    codepoint: 0xe172,
    categories: [12],
    tags: [
      3849,
      3850,
      3851,
      1630,
      3852,
      1631,
      2447,
      953,
      3027,
      956,
      3853,
      1598,
      2080,
      966,
      2245,
      366,
      92,
      656,
      1363,
      3854,
      285,
      78,
      288,
      371,
      32,
      1570,
      1647,
      3855,
      3856
    ],
  ),
  "bar_chart": SymbolsMetadata(
    popularity: 7579,
    codepoint: 0xe26b,
    categories: [9],
    tags: [
      2513,
      5,
      1343,
      1344,
      1345,
      365,
      1284,
      920,
      802,
      10,
      924,
      808,
      929,
      933,
      2518,
      1045,
      597,
      634,
      937,
      189,
      28,
      1353,
      1354,
      2851,
      3857,
      33,
      440,
      947,
      2852,
      3858,
      2253,
      1355,
      2519
    ],
  ),
  "bar_chart_4_bars": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xf681,
    categories: [9],
    tags: [
      3859,
      2513,
      5,
      1344,
      1345,
      1284,
      920,
      802,
      10,
      924,
      808,
      2926,
      2927,
      3860,
      929,
      3861,
      3862,
      3863,
      3864,
      933,
      2518,
      1045,
      597,
      634,
      22,
      937,
      3865,
      189,
      28,
      1353,
      1354,
      2851,
      3857,
      33,
      947,
      2852,
      3858,
      2253,
      1355,
      2519
    ],
  ),
  "bar_chart_off": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf411,
    categories: [9],
    tags: [
      5,
      3866,
      1343,
      1344,
      3867,
      1345,
      3868,
      3869,
      3870,
      920,
      3871,
      3872,
      10,
      3873,
      3874,
      3304,
      924,
      3875,
      3876,
      929,
      3877,
      3878,
      3879,
      3880,
      933,
      597,
      3881,
      937,
      3882,
      3883,
      3884,
      3885,
      3886,
      3887,
      914,
      33,
      3888,
      440,
      947,
      3889,
      3890,
      3891
    ],
  ),
  "barcode": SymbolsMetadata(
    popularity: 2446,
    codepoint: 0xe70b,
    categories: [9],
    tags: [
      3892,
      1326,
      2624,
      10,
      3893,
      1329,
      3894,
      2809,
      135,
      3895,
      3896,
      2295,
      1337,
      1622,
      3897,
      840,
      1296,
      3898,
      1723,
      1724,
      1297,
      841,
      1298,
      2586,
      3899,
      2384,
      947,
      3900,
      3901,
      1592,
      3902
    ],
  ),
  "barcode_reader": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf85c,
    categories: [9],
    tags: [
      3892,
      3903,
      3904,
      3669,
      1630,
      1326,
      2624,
      10,
      445,
      1329,
      3216,
      960,
      3905,
      2809,
      135,
      3895,
      3906,
      1717,
      1337,
      1622,
      3907,
      3908,
      2507,
      1296,
      1723,
      1724,
      980,
      122,
      1297,
      841,
      1298,
      2384,
      947,
      3901
    ],
  ),
  "barcode_scanner": SymbolsMetadata(
    popularity: 2935,
    codepoint: 0xe70c,
    categories: [9],
    tags: [
      3892,
      3904,
      365,
      3909,
      1326,
      3910,
      2805,
      1329,
      2810,
      3895,
      3906,
      3911,
      3912,
      1337,
      3913,
      3914,
      3897,
      3915,
      3907,
      3916,
      3908,
      1296,
      1723,
      3917,
      1724,
      122,
      1297,
      841,
      3918,
      1298,
      2384,
      947,
      3900,
      3901,
      1592
    ],
  ),
  "barefoot": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xf871,
    categories: [3],
    tags: [
      3919,
      3920,
      3921,
      3922,
      3923,
      584,
      590,
      1954,
      3924,
      3925,
      3926,
      3927,
      3928,
      3929,
      3930,
      3724,
      483,
      2724,
      3931,
      1581,
      1859,
      3727,
      489,
      3932,
      3933,
      3934,
      3935,
      109,
      3936,
      3937,
      2165,
      947,
      3938,
      1504,
      3206,
      3939
    ],
  ),
  "batch_prediction": SymbolsMetadata(
    popularity: 657,
    codepoint: 0xf0f5,
    categories: [6],
    tags: [
      3211,
      2513,
      5,
      3212,
      2148,
      3940,
      3941,
      3942,
      1199,
      3943,
      10,
      930,
      3944,
      135,
      3945,
      2516,
      1066,
      3680,
      3946,
      92,
      3503,
      2557,
      3947,
      3948,
      942,
      3949,
      100,
      2851,
      107
    ],
  ),
  "bath_outdoor": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf6fb,
    categories: [15],
    tags: [
      3950,
      3951,
      3952,
      3953,
      3954,
      3076,
      3078,
      3955,
      3956,
      3957,
      3958,
      3959,
      3960,
      1859,
      3961,
      1860,
      3841,
      3962,
      1959,
      3963,
      3964,
      3965,
      3966,
      3967,
      3968,
      2023,
      1504,
      3969,
      3083,
      2801,
      1905
    ],
  ),
  "bath_private": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf6fa,
    categories: [15],
    tags: [
      3950,
      3951,
      3952,
      3953,
      1868,
      3970,
      584,
      3971,
      3078,
      3955,
      3956,
      3957,
      483,
      3972,
      2795,
      3973,
      366,
      3961,
      488,
      489,
      3974,
      1517,
      1958,
      1959,
      3964,
      3975,
      3966,
      3967,
      3976,
      3977,
      2586,
      3969,
      611,
      3978,
      2801,
      1902,
      1905
    ],
  ),
  "bath_public_large": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf6f9,
    categories: [15],
    tags: [
      3950,
      3951,
      3952,
      1868,
      584,
      3979,
      3980,
      930,
      3981,
      3078,
      3955,
      3956,
      3957,
      483,
      2795,
      3982,
      3961,
      488,
      489,
      3983,
      3984,
      1959,
      3610,
      3964,
      3985,
      3975,
      3966,
      3967,
      3977,
      499,
      1885,
      3986,
      2801,
      3987,
      1902,
      3613,
      1905
    ],
  ),
  "bathroom": SymbolsMetadata(
    popularity: 529,
    codepoint: 0xefdd,
    categories: [8],
    tags: [
      733,
      3988,
      735,
      3950,
      1868,
      3970,
      3989,
      3979,
      956,
      3604,
      3990,
      3991,
      246,
      999,
      1435,
      3972,
      3992,
      3982,
      3993,
      3994,
      1495,
      2800,
      3995,
      3996,
      3984,
      3610,
      1960,
      3997,
      3998,
      3999,
      4000,
      32,
      1885,
      4001,
      4002,
      3986,
      2801,
      3987,
      3613,
      4003
    ],
  ),
  "bathtub": SymbolsMetadata(
    popularity: 1289,
    codepoint: 0xea41,
    categories: [8],
    tags: [
      4004,
      3950,
      3953,
      1868,
      3970,
      584,
      1871,
      4005,
      3990,
      999,
      4006,
      2607,
      483,
      3972,
      489,
      2800,
      1958,
      1959,
      3610,
      4007,
      3998,
      3965,
      3966,
      4008,
      1504,
      3969,
      501,
      4001,
      2801,
      1905
    ],
  ),
  "battery_0_bar": SymbolsMetadata(
    popularity: 1134,
    codepoint: 0xebdc,
    categories: [4],
    tags: [
      469,
      1343,
      3769,
      4009,
      4010,
      1113,
      3773,
      3774,
      4011,
      4012,
      445,
      1711,
      4013,
      965,
      188,
      4014,
      4015,
      4016,
      219,
      4017,
      4018,
      2585,
      3782,
      75,
      553,
      1261
    ],
  ),
  "battery_1_bar": SymbolsMetadata(
    popularity: 809,
    codepoint: 0xebd9,
    categories: [4],
    tags: [
      4019,
      469,
      1343,
      3769,
      3770,
      3772,
      4020,
      1113,
      3773,
      4021,
      3774,
      3776,
      445,
      1711,
      3778,
      3779,
      188,
      1602,
      3780,
      3781,
      219,
      4022,
      226,
      3782,
      4023,
      75,
      553,
      1261
    ],
  ),
  "battery_2_bar": SymbolsMetadata(
    popularity: 595,
    codepoint: 0xebe0,
    categories: [4],
    tags: [
      4024,
      4025,
      4026,
      3769,
      4027,
      3770,
      3771,
      3772,
      4020,
      4028,
      1113,
      3773,
      3774,
      445,
      1711,
      3779,
      3780,
      3781,
      219,
      226,
      4029,
      3782,
      3783,
      75,
      77,
      4030,
      4031,
      2146
    ],
  ),
  "battery_3_bar": SymbolsMetadata(
    popularity: 803,
    codepoint: 0xebdd,
    categories: [4],
    tags: [
      4032,
      1343,
      3769,
      4027,
      3770,
      3771,
      3772,
      4028,
      1113,
      3773,
      3774,
      445,
      3779,
      4033,
      4034,
      3781,
      4035,
      219,
      3782,
      4036,
      75,
      77,
      65,
      4037,
      4038,
      440,
      4039
    ],
  ),
  "battery_4_bar": SymbolsMetadata(
    popularity: 1226,
    codepoint: 0xebe2,
    categories: [4],
    tags: [
      4040,
      3859,
      4041,
      4042,
      1345,
      365,
      3769,
      3770,
      3772,
      1113,
      3773,
      445,
      1711,
      3779,
      3860,
      4043,
      188,
      2472,
      366,
      4044,
      219,
      4045,
      2585,
      3782,
      3783,
      75,
      77,
      4046,
      553,
      4047
    ],
  ),
  "battery_5_bar": SymbolsMetadata(
    popularity: 1720,
    codepoint: 0xebd4,
    categories: [4],
    tags: [
      4048,
      4042,
      1344,
      3769,
      1113,
      3773,
      3774,
      445,
      4049,
      1711,
      3779,
      4050,
      3860,
      4043,
      4051,
      188,
      4052,
      2472,
      219,
      226,
      2585,
      3782,
      3783,
      75,
      77,
      553,
      447
    ],
  ),
  "battery_6_bar": SymbolsMetadata(
    popularity: 1046,
    codepoint: 0xebd2,
    categories: [4],
    tags: [
      4053,
      4042,
      1344,
      3769,
      3770,
      3772,
      4054,
      1113,
      3773,
      3774,
      445,
      1711,
      3779,
      4043,
      188,
      4052,
      2472,
      366,
      219,
      4055,
      226,
      3782,
      3783,
      75,
      4056,
      553,
      447,
      2253
    ],
  ),
  "battery_alert": SymbolsMetadata(
    popularity: 777,
    codepoint: 0xe19c,
    categories: [4],
    tags: [
      3175,
      469,
      3073,
      1343,
      3769,
      4057,
      1693,
      1113,
      3773,
      3774,
      3775,
      3176,
      445,
      4013,
      3779,
      2766,
      2767,
      3177,
      3075,
      1251,
      4052,
      3780,
      3781,
      1641,
      219,
      486,
      226,
      3782,
      4036,
      75,
      65,
      553,
      35,
      447,
      1261
    ],
  ),
  "battery_android_0": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf30d,
    categories: [4],
    tags: [
      1175,
      1343,
      3769,
      1113,
      3773,
      3774,
      4058,
      3778,
      3779,
      4059,
      3560,
      16,
      188,
      4060,
      3780,
      219,
      4061,
      3782,
      4062,
      4063,
      4064,
      75,
      77,
      4037,
      35,
      551,
      4065
    ],
  ),
  "battery_android_1": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf30c,
    categories: [4],
    tags: [
      1175,
      1343,
      3769,
      4028,
      1113,
      3773,
      4021,
      212,
      445,
      3779,
      4043,
      4066,
      2590,
      188,
      2472,
      4067,
      219,
      327,
      1192,
      226,
      202,
      3782,
      4063,
      75,
      4068,
      553,
      35,
      4038,
      551
    ],
  ),
  "battery_android_2": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf30b,
    categories: [4],
    tags: [
      1175,
      4069,
      1343,
      3769,
      3771,
      1113,
      3773,
      4070,
      4071,
      445,
      4072,
      3216,
      3779,
      2590,
      3560,
      188,
      2472,
      3561,
      219,
      226,
      3782,
      4062,
      4073,
      4064,
      75,
      190,
      553,
      447,
      1381
    ],
  ),
  "battery_android_3": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf30a,
    categories: [4],
    tags: [
      1175,
      1343,
      3769,
      1113,
      3773,
      3774,
      445,
      4074,
      3779,
      2279,
      4043,
      2176,
      188,
      2472,
      219,
      327,
      4075,
      226,
      3782,
      75,
      227,
      553,
      35,
      551
    ],
  ),
  "battery_android_4": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf309,
    categories: [4],
    tags: [
      1175,
      1343,
      3769,
      4054,
      1113,
      3773,
      445,
      4074,
      3779,
      2590,
      4076,
      16,
      188,
      4077,
      2472,
      3561,
      219,
      4075,
      226,
      3782,
      75,
      4078,
      3364,
      32,
      553,
      35,
      551,
      4079
    ],
  ),
  "battery_android_5": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf308,
    categories: [4],
    tags: [
      564,
      1175,
      1343,
      3769,
      4054,
      1113,
      4080,
      3773,
      4081,
      445,
      4013,
      3779,
      4043,
      3328,
      16,
      188,
      2472,
      3561,
      219,
      486,
      1361,
      4075,
      3782,
      4082,
      446,
      553,
      4037,
      35,
      2632,
      4083
    ],
  ),
  "battery_android_6": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf307,
    categories: [4],
    tags: [
      1175,
      4069,
      1343,
      3769,
      4084,
      4085,
      3772,
      4028,
      1113,
      3773,
      4021,
      445,
      4086,
      4074,
      4049,
      3779,
      4059,
      4066,
      3560,
      188,
      2472,
      3780,
      219,
      226,
      3782,
      4062,
      4063,
      75,
      553,
      4087
    ],
  ),
  "battery_android_alert": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf306,
    categories: [4],
    tags: [
      3175,
      469,
      1175,
      3073,
      3769,
      1693,
      1113,
      3773,
      3774,
      3775,
      3176,
      4011,
      445,
      4013,
      3779,
      2766,
      2767,
      1251,
      188,
      2472,
      3780,
      1641,
      219,
      486,
      226,
      1212,
      1662,
      3782,
      75,
      4082,
      553,
      35,
      2632,
      1701,
      1034,
      1261
    ],
  ),
  "battery_android_bolt": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf305,
    categories: [4],
    tags: [
      1175,
      3769,
      4088,
      3771,
      4089,
      4090,
      1113,
      3773,
      4071,
      3774,
      4091,
      445,
      4074,
      4049,
      4092,
      3779,
      4093,
      4094,
      4095,
      4014,
      219,
      1675,
      226,
      3782,
      4096,
      4064,
      446,
      553,
      4097,
      551,
      4098
    ],
  ),
  "battery_android_full": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf304,
    categories: [4],
    tags: [
      1175,
      1343,
      3769,
      3772,
      4054,
      1113,
      3773,
      4081,
      3774,
      1633,
      445,
      4049,
      3216,
      3779,
      4059,
      4043,
      4099,
      16,
      188,
      2472,
      3561,
      219,
      4075,
      226,
      3782,
      4063,
      75,
      311,
      227,
      553,
      35,
      551
    ],
  ),
  "battery_android_plus": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf303,
    categories: [4],
    tags: [
      192,
      526,
      1175,
      3769,
      3773,
      3774,
      445,
      3779,
      4043,
      3560,
      16,
      188,
      135,
      2751,
      2472,
      219,
      763,
      226,
      202,
      1213,
      3782,
      4100,
      4101,
      553,
      35,
      2632
    ],
  ),
  "battery_android_question": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf302,
    categories: [4],
    tags: [
      4102,
      469,
      1175,
      738,
      3769,
      1113,
      3773,
      445,
      832,
      3779,
      2766,
      482,
      484,
      135,
      2472,
      1602,
      219,
      226,
      3782,
      4103,
      979,
      4104,
      4105,
      75,
      311,
      553,
      495,
      35,
      447,
      1364,
      1381
    ],
  ),
  "battery_android_share": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf301,
    categories: [4],
    tags: [
      1175,
      380,
      419,
      3769,
      4106,
      1113,
      3773,
      443,
      921,
      211,
      212,
      445,
      2210,
      4074,
      3779,
      2590,
      16,
      935,
      219,
      223,
      226,
      3782,
      4107,
      2342,
      4108,
      1396,
      2343,
      1665,
      35,
      551,
      2007,
      234,
      4109
    ],
  ),
  "battery_android_shield": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf300,
    categories: [4],
    tags: [
      1175,
      3769,
      3772,
      4110,
      1113,
      1510,
      3773,
      3774,
      2854,
      4111,
      4074,
      4112,
      3779,
      4113,
      4114,
      2856,
      595,
      16,
      3780,
      219,
      226,
      3782,
      4036,
      4115,
      1516,
      1517,
      1519,
      1520,
      602,
      1773,
      1011,
      1522,
      35,
      447,
      1523
    ],
  ),
  "battery_change": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf7eb,
    categories: [4],
    tags: [
      3769,
      4116,
      4088,
      3770,
      3771,
      4117,
      4028,
      4118,
      4119,
      1113,
      4120,
      3773,
      3774,
      445,
      3216,
      3778,
      3779,
      965,
      4121,
      3780,
      219,
      4122,
      3782,
      4036,
      75,
      4123,
      65,
      4124,
      4125
    ],
  ),
  "battery_charging_20": SymbolsMetadata(
    popularity: 425,
    codepoint: 0xf0a2,
    categories: [4],
    tags: [
      4019,
      1343,
      3769,
      3770,
      3771,
      4028,
      4089,
      1113,
      3773,
      3774,
      4126,
      445,
      4074,
      4049,
      1711,
      3779,
      4127,
      4093,
      4094,
      4121,
      4014,
      3780,
      3781,
      219,
      226,
      2585,
      3782,
      4128,
      75,
      4037,
      4098,
      4129
    ],
  ),
  "battery_charging_30": SymbolsMetadata(
    popularity: 283,
    codepoint: 0xf0a3,
    categories: [4],
    tags: [
      4026,
      3769,
      3771,
      3772,
      4089,
      1113,
      3773,
      3774,
      445,
      4074,
      4049,
      1711,
      3779,
      4127,
      4043,
      188,
      4093,
      4094,
      4014,
      219,
      4130,
      226,
      4131,
      2585,
      3782,
      4132,
      75,
      553,
      4031,
      4098
    ],
  ),
  "battery_charging_50": SymbolsMetadata(
    popularity: 388,
    codepoint: 0xf0a4,
    categories: [4],
    tags: [
      4032,
      1343,
      3769,
      3770,
      3771,
      3772,
      4028,
      4089,
      1113,
      3773,
      3774,
      4126,
      445,
      4074,
      4049,
      3779,
      4127,
      4034,
      4093,
      4094,
      4121,
      4014,
      3780,
      4133,
      219,
      486,
      3782,
      4036,
      75,
      65,
      4037,
      4098
    ],
  ),
  "battery_charging_60": SymbolsMetadata(
    popularity: 321,
    codepoint: 0xf0a5,
    categories: [4],
    tags: [
      4041,
      3769,
      3770,
      3771,
      4028,
      4089,
      1113,
      3773,
      3774,
      445,
      4074,
      4049,
      3216,
      3779,
      4043,
      16,
      188,
      4093,
      4094,
      4121,
      4014,
      219,
      4075,
      226,
      3782,
      75,
      77,
      4046,
      553,
      35,
      447,
      4098
    ],
  ),
  "battery_charging_80": SymbolsMetadata(
    popularity: 421,
    codepoint: 0xf0a6,
    categories: [4],
    tags: [
      4048,
      4042,
      3769,
      3770,
      3771,
      4028,
      4089,
      1113,
      3773,
      3774,
      4134,
      445,
      4135,
      4074,
      4049,
      1711,
      3779,
      4127,
      4043,
      188,
      4093,
      4094,
      4014,
      219,
      226,
      2585,
      3782,
      4128,
      75,
      77,
      553,
      4098
    ],
  ),
  "battery_charging_90": SymbolsMetadata(
    popularity: 440,
    codepoint: 0xf0a7,
    categories: [4],
    tags: [
      4053,
      4042,
      3769,
      3770,
      3771,
      4028,
      4089,
      1113,
      3773,
      3774,
      445,
      4074,
      4049,
      1711,
      3779,
      4127,
      4043,
      188,
      4093,
      4094,
      4121,
      4014,
      219,
      4136,
      226,
      3782,
      4132,
      75,
      77,
      553,
      4098
    ],
  ),
  "battery_charging_full": SymbolsMetadata(
    popularity: 2261,
    codepoint: 0xe1a3,
    categories: [4],
    tags: [
      3769,
      4137,
      4088,
      3770,
      3771,
      4028,
      4089,
      1113,
      3773,
      4081,
      3774,
      445,
      4074,
      4049,
      3779,
      4127,
      4043,
      4066,
      4138,
      188,
      4093,
      4094,
      4121,
      4014,
      219,
      226,
      3782,
      4128,
      75,
      553,
      4098
    ],
  ),
  "battery_error": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf7ea,
    categories: [4],
    tags: [
      469,
      3769,
      4139,
      4140,
      4141,
      4142,
      4143,
      895,
      1113,
      3773,
      4144,
      3436,
      2950,
      1202,
      445,
      2766,
      2985,
      965,
      2769,
      4052,
      366,
      3780,
      219,
      4145,
      486,
      226,
      3782,
      4146,
      4147,
      2772,
      75,
      911,
      553,
      1083,
      447,
      1261,
      3736
    ],
  ),
  "battery_full": SymbolsMetadata(
    popularity: 2654,
    codepoint: 0xe1a4,
    categories: [4],
    tags: [
      1343,
      3769,
      4088,
      3770,
      3771,
      3772,
      4028,
      1113,
      3773,
      4081,
      445,
      4049,
      1711,
      3779,
      4043,
      4066,
      4148,
      188,
      219,
      2585,
      3782,
      4036,
      75,
      77,
      65,
      553,
      2632
    ],
  ),
  "battery_full_alt": SymbolsMetadata(
    popularity: 1174,
    codepoint: 0xf13b,
    categories: [4],
    tags: [
      1343,
      3769,
      4137,
      3770,
      3771,
      4028,
      1113,
      3773,
      4081,
      445,
      1711,
      3779,
      4149,
      4150,
      4066,
      4138,
      4151,
      4148,
      188,
      4052,
      2472,
      219,
      226,
      3782,
      4073,
      75,
      77,
      553,
      447
    ],
  ),
  "battery_horiz_000": SymbolsMetadata(
    popularity: 295,
    codepoint: 0xf8ae,
    categories: [10],
    tags: [
      4152,
      469,
      1343,
      3769,
      4088,
      3770,
      3771,
      4028,
      1113,
      3773,
      3774,
      4153,
      445,
      1711,
      3778,
      3779,
      999,
      2176,
      188,
      4052,
      3780,
      219,
      1004,
      4154,
      226,
      3782,
      4036,
      75,
      65,
      4037,
      447,
      1261
    ],
  ),
  "battery_horiz_050": SymbolsMetadata(
    popularity: 502,
    codepoint: 0xf8af,
    categories: [10],
    tags: [
      4155,
      1343,
      3769,
      4088,
      3770,
      3771,
      3772,
      4028,
      1113,
      3773,
      3774,
      445,
      1711,
      3779,
      4033,
      4034,
      999,
      2176,
      3781,
      4035,
      4156,
      219,
      1004,
      486,
      3782,
      4036,
      3783,
      75,
      4037
    ],
  ),
  "battery_horiz_075": SymbolsMetadata(
    popularity: 833,
    codepoint: 0xf8b0,
    categories: [10],
    tags: [
      4157,
      4158,
      1343,
      3769,
      3770,
      3771,
      3772,
      4028,
      1113,
      3773,
      3774,
      445,
      4049,
      1711,
      3779,
      4043,
      999,
      2176,
      4052,
      3780,
      219,
      1004,
      226,
      3782,
      4036,
      75,
      4037,
      447,
      4047
    ],
  ),
  "battery_low": SymbolsMetadata(
    popularity: 707,
    codepoint: 0xf155,
    categories: [4],
    tags: [
      469,
      4159,
      1343,
      3769,
      3770,
      4020,
      4028,
      1113,
      3773,
      3774,
      3776,
      445,
      1711,
      4013,
      3779,
      965,
      999,
      2176,
      188,
      3780,
      3781,
      219,
      1004,
      486,
      3782,
      3783,
      75,
      553,
      1261
    ],
  ),
  "battery_plus": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf7e9,
    categories: [4],
    tags: [
      192,
      526,
      4160,
      4161,
      3769,
      4162,
      4027,
      3770,
      3771,
      3772,
      4110,
      4028,
      4163,
      4164,
      3773,
      3774,
      3779,
      4165,
      1207,
      4166,
      366,
      4167,
      4168,
      763,
      202,
      1212,
      3782,
      4023,
      75,
      4100,
      35,
      4169
    ],
  ),
  "battery_profile": SymbolsMetadata(
    popularity: 188,
    codepoint: 0xe206,
    categories: [10],
    tags: [
      1128,
      1230,
      3769,
      4170,
      4171,
      4172,
      4110,
      4173,
      1731,
      3773,
      3774,
      4174,
      4175,
      268,
      269,
      1735,
      132,
      3779,
      4176,
      4177,
      3485,
      999,
      484,
      135,
      3780,
      4178,
      1740,
      1004,
      656,
      790,
      3782,
      4036,
      4179,
      329,
      490,
      1011,
      2631,
      65
    ],
  ),
  "battery_saver": SymbolsMetadata(
    popularity: 430,
    codepoint: 0xefde,
    categories: [4],
    tags: [
      192,
      526,
      4160,
      3769,
      4162,
      4088,
      3770,
      3772,
      4171,
      4180,
      4110,
      3773,
      3774,
      4181,
      4182,
      4183,
      4184,
      4165,
      3781,
      4185,
      763,
      4186,
      202,
      3782,
      4187,
      4023,
      75,
      4188,
      4100,
      65,
      35
    ],
  ),
  "battery_share": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf67e,
    categories: [4],
    tags: [
      380,
      419,
      3769,
      3771,
      4028,
      1113,
      3773,
      3774,
      211,
      445,
      3779,
      2985,
      1672,
      3780,
      219,
      4189,
      4190,
      3782,
      4191,
      3068,
      4108,
      1396,
      782,
      2343,
      1665,
      3058,
      2007,
      234,
      4109
    ],
  ),
  "battery_status_good": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf67d,
    categories: [4],
    tags: [
      1549,
      3769,
      4192,
      4137,
      4193,
      4028,
      1113,
      3773,
      4081,
      1630,
      1632,
      1633,
      445,
      1639,
      3779,
      4043,
      4194,
      4052,
      219,
      1643,
      226,
      1213,
      3782,
      75,
      288,
      65,
      4195,
      2487,
      4038,
      447,
      441,
      1647,
      2386,
      1523,
      4196,
      1650
    ],
  ),
  "battery_unknown": SymbolsMetadata(
    popularity: 425,
    codepoint: 0xe1a6,
    categories: [4],
    tags: [
      4102,
      469,
      738,
      3769,
      4197,
      4088,
      3770,
      3771,
      4028,
      1113,
      3773,
      3774,
      4058,
      3778,
      2766,
      4066,
      482,
      484,
      135,
      2769,
      3780,
      219,
      486,
      3782,
      2772,
      4103,
      4104,
      4105,
      75,
      65,
      4198,
      495,
      35,
      1364,
      4199,
      1261
    ],
  ),
  "battery_very_low": SymbolsMetadata(
    popularity: 435,
    codepoint: 0xf156,
    categories: [4],
    tags: [
      469,
      1343,
      3769,
      3770,
      3771,
      3772,
      1113,
      3773,
      3774,
      3776,
      3777,
      445,
      3778,
      3779,
      965,
      999,
      2176,
      3780,
      3781,
      219,
      1004,
      486,
      3782,
      3783,
      75,
      65,
      553,
      2632,
      3784,
      1261
    ],
  ),
  "beach_access": SymbolsMetadata(
    popularity: 2225,
    codepoint: 0xeb3e,
    categories: [16],
    tags: [
      755,
      3923,
      4200,
      4201,
      4202,
      1484,
      2018,
      2533,
      3727,
      4203,
      2613,
      3347,
      1959,
      4204,
      3933,
      2476,
      4205,
      4206,
      4207,
      4208,
      3686,
      4209,
      4210,
      4211,
      2023,
      1504,
      1591,
      4212,
      2024
    ],
  ),
  "bed": SymbolsMetadata(
    popularity: 3276,
    codepoint: 0xefdf,
    categories: [8],
    tags: [
      2599,
      1909,
      4213,
      4214,
      4215,
      1936,
      1914,
      3108,
      4216,
      4217,
      4043,
      1964,
      4218,
      2018,
      999,
      4219,
      2607,
      1435,
      4220,
      2610,
      4221,
      2611,
      4222,
      4223,
      4224,
      4225,
      4226,
      1959,
      1924,
      1925,
      1960,
      673,
      1929,
      3846,
      1948,
      1504,
      4227,
      2024
    ],
  ),
  "bedroom_baby": SymbolsMetadata(
    popularity: 566,
    codepoint: 0xefe0,
    categories: [8],
    tags: [
      2600,
      3598,
      3599,
      4228,
      4213,
      862,
      865,
      4229,
      4230,
      867,
      1964,
      999,
      4231,
      1435,
      3606,
      2796,
      870,
      3609,
      4232,
      75,
      1925,
      4233,
      4234,
      1960,
      1929,
      32,
      3612,
      2543,
      879
    ],
  ),
  "bedroom_child": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xefe1,
    categories: [8],
    tags: [
      2599,
      2600,
      3599,
      1909,
      4213,
      4235,
      862,
      4236,
      865,
      4230,
      867,
      1964,
      999,
      2607,
      1435,
      3606,
      870,
      4237,
      366,
      4238,
      4222,
      4232,
      4225,
      75,
      1925,
      1960,
      673,
      1929,
      32,
      3612,
      1504,
      4239,
      4227,
      879
    ],
  ),
  "bedroom_parent": SymbolsMetadata(
    popularity: 603,
    codepoint: 0xefe2,
    categories: [8],
    tags: [
      2599,
      2600,
      1909,
      4213,
      1936,
      865,
      3108,
      4216,
      867,
      274,
      4043,
      1964,
      4240,
      999,
      2607,
      1435,
      2796,
      871,
      4220,
      2610,
      4241,
      4222,
      874,
      4242,
      4225,
      4226,
      75,
      1924,
      1925,
      1960,
      4243,
      1929,
      32,
      1948
    ],
  ),
  "bedtime": SymbolsMetadata(
    popularity: 2131,
    codepoint: 0xef44,
    categories: [3],
    tags: [
      4244,
      4245,
      4214,
      4246,
      3436,
      4247,
      712,
      4248,
      4249,
      3690,
      4250,
      4251,
      4252,
      4253,
      999,
      4254,
      4255,
      1004,
      4222,
      4256,
      4257,
      4258,
      2123,
      4259,
      1958,
      1925,
      1011,
      4260,
      1170,
      1171,
      1929,
      4261,
      729,
      289,
      4262,
      731
    ],
  ),
  "bedtime_off": SymbolsMetadata(
    popularity: 289,
    codepoint: 0xeb76,
    categories: [3],
    tags: [
      1242,
      4214,
      4263,
      2136,
      895,
      1075,
      3436,
      712,
      4264,
      4248,
      767,
      4250,
      4251,
      4265,
      4266,
      899,
      999,
      901,
      4254,
      4255,
      1164,
      1004,
      4222,
      4257,
      907,
      908,
      1082,
      2123,
      4267,
      4259,
      1959,
      1925,
      1011,
      1170,
      914,
      1929,
      4261,
      729,
      289,
      4268,
      915,
      731
    ],
  ),
  "beenhere": SymbolsMetadata(
    popularity: 1341,
    codepoint: 0xe52d,
    categories: [5],
    tags: [
      2717,
      1549,
      2480,
      2151,
      6,
      4269,
      1670,
      1630,
      1632,
      1633,
      1635,
      4270,
      1636,
      4271,
      2481,
      1639,
      3578,
      1023,
      18,
      2159,
      1001,
      1641,
      21,
      1643,
      1493,
      2506,
      2507,
      4272,
      2368,
      1772,
      602,
      1664,
      4273,
      1773,
      1011,
      288,
      1522,
      2384,
      1647,
      2386,
      2387,
      1523,
      2389,
      4274,
      1650
    ],
  ),
  "bento": SymbolsMetadata(
    popularity: 313,
    codepoint: 0xf1f4,
    categories: [16],
    tags: [
      4275,
      7,
      383,
      4276,
      1269,
      4277,
      4278,
      832,
      1829,
      4279,
      246,
      3959,
      306,
      3803,
      4280,
      3804,
      4281,
      940,
      98,
      4282,
      4283,
      75,
      3807,
      4284,
      3423,
      3809,
      32,
      674,
      4285,
      4286,
      4287
    ],
  ),
  "bia": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf6eb,
    categories: [15],
    tags: [
      2513,
      5,
      3811,
      4288,
      4289,
      584,
      4290,
      4291,
      1284,
      4292,
      920,
      2515,
      10,
      4293,
      4294,
      958,
      4295,
      2926,
      2927,
      929,
      595,
      483,
      135,
      966,
      2516,
      4296,
      969,
      2518,
      366,
      976,
      634,
      937,
      4297,
      75,
      1354,
      3184,
      980,
      33
    ],
  ),
  "bid_landscape": SymbolsMetadata(
    popularity: 163,
    codepoint: 0xe667,
    categories: [9],
    tags: [
      2513,
      5,
      1343,
      365,
      4298,
      1284,
      920,
      10,
      3756,
      924,
      808,
      4299,
      304,
      929,
      196,
      1207,
      933,
      2516,
      2518,
      1543,
      366,
      1291,
      597,
      634,
      937,
      189,
      28,
      1354,
      1379,
      32,
      33,
      1380,
      947,
      2852,
      1676,
      1355,
      4300
    ],
  ),
  "bid_landscape_disabled": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xef81,
    categories: [9],
    tags: [
      5,
      380,
      2301,
      1343,
      365,
      4298,
      4301,
      894,
      895,
      920,
      10,
      924,
      767,
      899,
      929,
      53,
      901,
      933,
      1543,
      4302,
      4303,
      597,
      937,
      4304,
      4305,
      907,
      3147,
      59,
      119,
      912,
      396,
      914,
      32,
      33,
      313,
      314,
      947,
      915,
      2309
    ],
  ),
  "bigtop_updates": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xe669,
    categories: [4],
    tags: [
      469,
      1180,
      2827,
      4306,
      4307,
      355,
      383,
      443,
      4308,
      1732,
      211,
      212,
      10,
      277,
      135,
      215,
      223,
      486,
      2083,
      1318,
      227,
      342,
      441,
      2620,
      2085,
      4309,
      1260,
      4310,
      1902,
      233,
      234
    ],
  ),
  "bike_dock": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf47b,
    categories: [14],
    tags: [
      4311,
      4312,
      4313,
      4314,
      4315,
      4316,
      4317,
      4318,
      4319,
      2602,
      2063,
      386,
      2522,
      4320,
      1001,
      1002,
      1490,
      421,
      4321,
      4322,
      4323,
      2615,
      3058,
      4324,
      4325,
      441,
      1930,
      1504,
      2621,
      1381
    ],
  ),
  "bike_lane": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf47a,
    categories: [14],
    tags: [
      1549,
      2480,
      4313,
      4314,
      4326,
      1510,
      1630,
      1632,
      2063,
      4327,
      1633,
      386,
      4328,
      388,
      1578,
      1639,
      2925,
      2927,
      1488,
      483,
      4329,
      1001,
      1002,
      1490,
      1641,
      421,
      1643,
      1586,
      4330,
      489,
      1516,
      1517,
      1519,
      4331,
      1520,
      2071,
      3347,
      1587,
      1503,
      1772,
      602,
      1773,
      1011,
      288,
      1522,
      1647,
      1930,
      1504,
      501,
      2386,
      1523,
      1650
    ],
  ),
  "bike_scooter": SymbolsMetadata(
    popularity: 261,
    codepoint: 0xef45,
    categories: [14],
    tags: [
      1814,
      4313,
      4314,
      1815,
      1816,
      2602,
      2063,
      1019,
      4332,
      4333,
      4334,
      4335,
      1490,
      4336,
      4337,
      4338,
      4339,
      4340,
      2615,
      2072,
      1587,
      4341,
      3058,
      1589,
      1842,
      1930,
      1504,
      4342,
      4343,
      1844,
      4344,
      4345
    ],
  ),
  "biotech": SymbolsMetadata(
    popularity: 2707,
    codepoint: 0xea3a,
    categories: [15],
    tags: [
      2513,
      4346,
      2412,
      4347,
      4348,
      1113,
      4349,
      4294,
      4350,
      4351,
      1753,
      4352,
      4353,
      4354,
      126,
      4355,
      974,
      1757,
      4356,
      4357,
      4358,
      4359,
      4360,
      4361,
      2424,
      4362,
      4363,
      551,
      986
    ],
  ),
  "blanket": SymbolsMetadata(
    popularity: 163,
    codepoint: 0xe828,
    categories: [8],
    tags: [
      3769,
      4215,
      4364,
      3773,
      3774,
      714,
      211,
      4365,
      4366,
      4367,
      445,
      4074,
      4368,
      4369,
      4370,
      4371,
      4049,
      3216,
      1711,
      3779,
      1004,
      4372,
      4373,
      4374,
      4190,
      3782,
      4191,
      4375,
      4376,
      4377,
      4378,
      4379,
      4380,
      4381
    ],
  ),
  "blender": SymbolsMetadata(
    popularity: 600,
    codepoint: 0xefe3,
    categories: [8],
    tags: [
      1888,
      4382,
      4383,
      4384,
      4385,
      4386,
      298,
      4387,
      1269,
      269,
      3795,
      4388,
      4389,
      4390,
      4074,
      4391,
      4392,
      4393,
      3489,
      4394,
      4395,
      4396,
      3802,
      4397,
      4398,
      4399,
      1717,
      4400,
      4401,
      4402,
      4403,
      4404,
      4405
    ],
  ),
  "blind": SymbolsMetadata(
    popularity: 446,
    codepoint: 0xf8d6,
    categories: [3],
    tags: [
      733,
      734,
      784,
      736,
      3196,
      738,
      739,
      3370,
      4406,
      4407,
      584,
      4408,
      741,
      4409,
      4410,
      744,
      482,
      483,
      4411,
      3199,
      4412,
      770,
      421,
      489,
      4413,
      750,
      4414,
      3383,
      3206,
      3207,
      4415,
      4416,
      4417
    ],
  ),
  "blinds": SymbolsMetadata(
    popularity: 254,
    codepoint: 0xe286,
    categories: [8],
    tags: [
      1128,
      4418,
      2950,
      269,
      4366,
      4367,
      4419,
      3489,
      3235,
      2176,
      2080,
      4420,
      4421,
      4422,
      1004,
      2653,
      1516,
      3001,
      75,
      4423,
      65,
      4206,
      4424,
      1901,
      32,
      4211,
      4425,
      730,
      1054,
      4426,
      4427,
      4428,
      4429
    ],
  ),
  "blinds_closed": SymbolsMetadata(
    popularity: 208,
    codepoint: 0xec1f,
    categories: [8],
    tags: [
      4418,
      1074,
      4430,
      4367,
      4419,
      2651,
      3235,
      4431,
      2080,
      4420,
      4422,
      366,
      2315,
      4432,
      1004,
      1516,
      75,
      4433,
      4206,
      4434,
      4424,
      4435,
      1901,
      944,
      4211,
      4425,
      1054,
      4426,
      4427,
      4436,
      4429
    ],
  ),
  "block": SymbolsMetadata(
    popularity: 11751,
    codepoint: 0xe14b,
    categories: [2],
    tags: [
      4437,
      1074,
      895,
      383,
      4438,
      4439,
      2950,
      4440,
      4441,
      4442,
      767,
      4443,
      4250,
      4444,
      4251,
      1597,
      2985,
      899,
      4445,
      1164,
      4145,
      4446,
      4447,
      907,
      4448,
      4449,
      4450,
      4451,
      4452,
      911,
      171,
      1170,
      914,
      1083,
      915
    ],
  ),
  "blood_pressure": SymbolsMetadata(
    popularity: 53,
    codepoint: 0xe097,
    categories: [3],
    tags: [
      4453,
      4454,
      920,
      10,
      4455,
      1751,
      3560,
      929,
      595,
      4456,
      1753,
      4457,
      3569,
      4458,
      4459,
      597,
      634,
      1757,
      1760,
      3561,
      327,
      4460,
      1762,
      4461,
      3570,
      121,
      177,
      4462,
      2165,
      947,
      4463,
      4464
    ],
  ),
  "bloodtype": SymbolsMetadata(
    popularity: 1082,
    codepoint: 0xefe4,
    categories: [3],
    tags: [
      2513,
      4465,
      4466,
      4467,
      4468,
      4469,
      4470,
      4471,
      1749,
      3316,
      4472,
      1500,
      4473,
      2482,
      4474,
      595,
      4475,
      1753,
      1754,
      4476,
      4354,
      1757,
      1758,
      1760,
      1116,
      3696,
      1762,
      202,
      1213,
      4477,
      4478,
      40,
      2801
    ],
  ),
  "bluetooth": SymbolsMetadata(
    popularity: 2387,
    codepoint: 0xe1a7,
    categories: [4],
    tags: [
      951,
      4479,
      4480,
      2053,
      443,
      921,
      211,
      212,
      269,
      3050,
      896,
      445,
      1077,
      3306,
      1711,
      2855,
      277,
      223,
      4481,
      656,
      4482,
      4483,
      4484,
      4485,
      4486,
      2083,
      65,
      4487,
      227,
      342,
      35,
      1667,
      3529,
      551,
      4488,
      234,
      4489
    ],
  ),
  "bluetooth_connected": SymbolsMetadata(
    popularity: 648,
    codepoint: 0xe1a8,
    categories: [4],
    tags: [
      2587,
      1129,
      4490,
      4479,
      4491,
      2053,
      443,
      694,
      921,
      922,
      211,
      269,
      3050,
      445,
      1711,
      4492,
      4052,
      2081,
      223,
      4482,
      4483,
      4485,
      226,
      4493,
      65,
      227,
      1157,
      342,
      35,
      1667,
      447,
      551,
      1701,
      4494,
      234,
      4495
    ],
  ),
  "bluetooth_disabled": SymbolsMetadata(
    popularity: 527,
    codepoint: 0xe1a9,
    categories: [4],
    tags: [
      4479,
      4496,
      4480,
      4497,
      2035,
      4498,
      895,
      2053,
      921,
      211,
      4499,
      4500,
      4501,
      1202,
      445,
      4502,
      4503,
      767,
      898,
      4504,
      2041,
      4505,
      2043,
      4506,
      907,
      908,
      909,
      4507,
      4508,
      4485,
      4493,
      914,
      342,
      35,
      4509,
      4510,
      234,
      4511,
      4512,
      2050
    ],
  ),
  "bluetooth_drive": SymbolsMetadata(
    popularity: 243,
    codepoint: 0xefe5,
    categories: [4],
    tags: [
      1131,
      1814,
      3467,
      4479,
      4513,
      4514,
      1815,
      4515,
      1816,
      2053,
      2063,
      921,
      4516,
      211,
      445,
      1654,
      1488,
      4517,
      1001,
      1490,
      421,
      4485,
      4518,
      4519,
      342,
      35,
      551,
      1842,
      1930,
      1504,
      1844,
      4520,
      234,
      4521,
      4522
    ],
  ),
  "bluetooth_searching": SymbolsMetadata(
    popularity: 687,
    codepoint: 0xe1aa,
    categories: [4],
    tags: [
      1129,
      4523,
      4479,
      4524,
      4525,
      355,
      921,
      211,
      445,
      955,
      1711,
      4526,
      4492,
      1143,
      2081,
      223,
      4506,
      4483,
      4485,
      4493,
      980,
      4527,
      227,
      1156,
      1157,
      2057,
      35,
      551,
      234,
      4528,
      4529
    ],
  ),
  "blur_circular": SymbolsMetadata(
    popularity: 440,
    codepoint: 0xe3a2,
    categories: [1],
    tags: [
      4530,
      4531,
      4532,
      47,
      383,
      384,
      4533,
      4534,
      4535,
      956,
      696,
      2299,
      2567,
      528,
      959,
      1738,
      4536,
      3145,
      4537,
      126,
      4538,
      4539,
      3422,
      61,
      119,
      3641,
      4540,
      1257,
      4541,
      4542,
      2438,
      4543
    ],
  ),
  "blur_linear": SymbolsMetadata(
    popularity: 259,
    codepoint: 0xe3a3,
    categories: [1],
    tags: [
      1128,
      4530,
      4544,
      953,
      4533,
      956,
      696,
      2299,
      2567,
      528,
      4545,
      959,
      1738,
      4546,
      53,
      4536,
      3145,
      4537,
      4547,
      366,
      4548,
      4539,
      59,
      3422,
      4549,
      119,
      4550,
      4551,
      441,
      4552,
      2571
    ],
  ),
  "blur_medium": SymbolsMetadata(
    popularity: 242,
    codepoint: 0xe84c,
    categories: [1],
    tags: [
      4530,
      4553,
      47,
      383,
      4533,
      696,
      2299,
      2567,
      528,
      1022,
      959,
      4554,
      4555,
      3145,
      4537,
      4556,
      4044,
      4557,
      420,
      4548,
      1858,
      4539,
      4558,
      3422,
      4549,
      4559,
      61,
      4560,
      4542,
      231,
      441,
      2571,
      4561,
      41,
      364
    ],
  ),
  "blur_off": SymbolsMetadata(
    popularity: 165,
    codepoint: 0xe3a4,
    categories: [1],
    tags: [
      4562,
      4530,
      4563,
      4564,
      953,
      544,
      4565,
      4566,
      3304,
      4567,
      767,
      956,
      696,
      2299,
      2567,
      898,
      528,
      1738,
      4536,
      4568,
      3145,
      4569,
      4570,
      907,
      909,
      4571,
      4572,
      3422,
      4573,
      4574,
      4575,
      4576,
      4577,
      4578,
      4541,
      4579,
      914,
      2438,
      4580
    ],
  ),
  "blur_on": SymbolsMetadata(
    popularity: 1380,
    codepoint: 0xe3a5,
    categories: [1],
    tags: [
      4530,
      4581,
      4582,
      4532,
      47,
      953,
      4533,
      4534,
      767,
      4583,
      4535,
      956,
      696,
      2299,
      2567,
      898,
      528,
      959,
      1738,
      246,
      4536,
      4537,
      54,
      2753,
      907,
      909,
      4538,
      4539,
      3635,
      3422,
      3276,
      4584,
      4541,
      914,
      4560,
      2438,
      4543,
      4585
    ],
  ),
  "blur_short": SymbolsMetadata(
    popularity: 198,
    codepoint: 0xe8cf,
    categories: [1],
    tags: [
      4586,
      4530,
      4587,
      4553,
      383,
      2332,
      4533,
      696,
      2299,
      4588,
      2567,
      528,
      4589,
      959,
      1738,
      4536,
      3145,
      4537,
      4556,
      366,
      420,
      1858,
      4539,
      4590,
      3422,
      4559,
      4591,
      3331,
      4592,
      4593,
      314,
      4594,
      1214,
      4580,
      2572
    ],
  ),
  "boat_bus": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf36d,
    categories: [14],
    tags: [
      4595,
      1814,
      2521,
      4596,
      4597,
      2062,
      4598,
      1815,
      1816,
      2063,
      4599,
      388,
      1578,
      4600,
      4601,
      2526,
      1490,
      4602,
      2530,
      2532,
      1922,
      2071,
      4603,
      4604,
      4605,
      4606,
      2023,
      2008,
      1930,
      1504,
      1844,
      4607,
      4608,
      4609,
      4610,
      4611
    ],
  ),
  "boat_railway": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf36c,
    categories: [14],
    tags: [
      1814,
      2521,
      4612,
      1815,
      4613,
      1816,
      2063,
      4614,
      388,
      1578,
      4615,
      4601,
      4616,
      1581,
      4617,
      4618,
      1490,
      4619,
      2533,
      1922,
      2071,
      4603,
      4620,
      4621,
      4622,
      2476,
      2535,
      4606,
      4623,
      2165,
      4624,
      4625,
      2008,
      1842,
      1930,
      1504,
      1844,
      4607,
      2801
    ],
  ),
  "body_fat": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xe098,
    categories: [3],
    tags: [
      2513,
      4626,
      4290,
      4627,
      4628,
      4629,
      4630,
      4631,
      4632,
      4633,
      4634,
      4635,
      2927,
      4636,
      595,
      4456,
      4637,
      597,
      634,
      4638,
      3561,
      4639,
      4640,
      2281,
      4641,
      947,
      1701,
      3831,
      1905,
      4642
    ],
  ),
  "body_system": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xe099,
    categories: [3],
    tags: [
      376,
      377,
      3919,
      2412,
      584,
      4643,
      383,
      385,
      2927,
      4644,
      595,
      1753,
      4645,
      483,
      390,
      1757,
      4646,
      488,
      489,
      4647,
      396,
      397,
      2424,
      399,
      2632,
      402,
      4648,
      1905
    ],
  ),
  "bolt": SymbolsMetadata(
    popularity: 15609,
    codepoint: 0xea0b,
    categories: [2],
    tags: [
      469,
      3769,
      4089,
      3773,
      3774,
      3176,
      4074,
      4049,
      3779,
      1022,
      4127,
      4649,
      4650,
      4093,
      4094,
      3782,
      1027,
      1028,
      4651,
      231,
      4652,
      4653,
      4098,
      4654,
      4655,
      1261,
      731,
      4656
    ],
  ),
  "bomb": SymbolsMetadata(
    popularity: 63,
    codepoint: 0xf568,
    categories: [3],
    tags: [
      469,
      688,
      4657,
      4658,
      4659,
      4660,
      4661,
      4662,
      4663,
      4664,
      4665,
      4666,
      3176,
      4667,
      4668,
      4669,
      4670,
      3104,
      4671,
      4672,
      4673,
      697,
      4649,
      4674,
      4675,
      4676,
      4677,
      4678,
      4679,
      4680,
      4681,
      1261,
      4682,
      4683
    ],
  ),
  "book": SymbolsMetadata(
    popularity: 4742,
    codepoint: 0xe865,
    categories: [12],
    tags: [
      4684,
      3115,
      1910,
      1670,
      4685,
      3455,
      1913,
      4686,
      4687,
      1347,
      3153,
      3578,
      1530,
      1453,
      135,
      4688,
      18,
      3375,
      4689,
      2159,
      1533,
      4690,
      2506,
      2507,
      75,
      4272,
      2368,
      1664,
      3158,
      4691,
      4692,
      2384,
      4693
    ],
  ),
  "book_2": SymbolsMetadata(
    popularity: 138,
    codepoint: 0xf53e,
    categories: [12],
    tags: [
      1910,
      4694,
      1670,
      3455,
      1042,
      4695,
      1347,
      4696,
      3153,
      3578,
      135,
      3461,
      4688,
      18,
      4697,
      3375,
      2159,
      3462,
      4698,
      4699,
      4700,
      1534,
      4701,
      2506,
      2507,
      4272,
      4361,
      2368,
      1664,
      3158,
      4691,
      4702,
      2384,
      4693
    ],
  ),
  "book_3": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf53d,
    categories: [12],
    tags: [
      685,
      4703,
      4,
      2501,
      1910,
      1670,
      1042,
      4704,
      4695,
      1347,
      4696,
      3153,
      4705,
      3578,
      135,
      3461,
      4688,
      18,
      4697,
      3375,
      4706,
      2159,
      3462,
      4699,
      3463,
      4701,
      2506,
      2507,
      4272,
      4361,
      2368,
      1664,
      3158,
      4691,
      4702,
      2384,
      38,
      4693
    ],
  ),
  "book_4": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf53c,
    categories: [12],
    tags: [
      534,
      4703,
      1910,
      1670,
      3455,
      2155,
      3458,
      1347,
      3153,
      3578,
      4707,
      135,
      3461,
      4688,
      18,
      4697,
      3375,
      2159,
      3462,
      4699,
      3463,
      3464,
      4701,
      2506,
      2507,
      4272,
      4361,
      2368,
      1664,
      2570,
      4708,
      2510,
      4691,
      2384,
      4693,
      1745
    ],
  ),
  "book_5": SymbolsMetadata(
    popularity: 87,
    codepoint: 0xf53b,
    categories: [12],
    tags: [
      564,
      1910,
      1670,
      3455,
      2155,
      3458,
      1347,
      3153,
      3578,
      4709,
      135,
      3461,
      4688,
      18,
      4697,
      3375,
      2159,
      3462,
      4710,
      3463,
      1534,
      4701,
      2506,
      2507,
      4272,
      2368,
      1664,
      2570,
      4711,
      2510,
      4691,
      2384,
      4693
    ],
  ),
  "book_6": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf3df,
    categories: [12],
    tags: [
      4703,
      4,
      2501,
      1910,
      1670,
      4704,
      1347,
      696,
      2299,
      3153,
      4705,
      3578,
      14,
      135,
      3461,
      4688,
      18,
      4697,
      3375,
      4706,
      2159,
      4701,
      2506,
      2507,
      4272,
      2368,
      1664,
      3158,
      4691,
      4702,
      2384,
      38,
      4693,
      702,
      1536,
      704
    ],
  ),
  "book_online": SymbolsMetadata(
    popularity: 1465,
    codepoint: 0xf217,
    categories: [11],
    tags: [
      1109,
      1110,
      755,
      4712,
      1229,
      1015,
      1910,
      1936,
      2062,
      1113,
      267,
      4713,
      1636,
      445,
      88,
      4714,
      956,
      4715,
      3216,
      3337,
      4716,
      2094,
      4717,
      1917,
      965,
      1114,
      788,
      219,
      1675,
      4718,
      4719,
      819,
      656,
      96,
      2028,
      226,
      840,
      75,
      1924,
      77,
      2997,
      446,
      447,
      3412,
      791,
      2022,
      4624,
      1842,
      4720,
      2387
    ],
  ),
  "book_ribbon": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf3e7,
    categories: [6],
    tags: [
      1910,
      1670,
      3455,
      4686,
      4687,
      1347,
      3153,
      3578,
      135,
      3461,
      4688,
      18,
      4697,
      3375,
      2159,
      3462,
      4698,
      1641,
      3463,
      1534,
      28,
      4701,
      2506,
      2507,
      4272,
      2368,
      1664,
      2510,
      4691,
      4692,
      2384,
      4693
    ],
  ),
  "bookmark": SymbolsMetadata(
    popularity: 13440,
    codepoint: 0xe866,
    categories: [6],
    tags: [
      526,
      2151,
      2501,
      1038,
      1670,
      1062,
      4721,
      1347,
      4013,
      3578,
      4722,
      1251,
      18,
      4723,
      2159,
      935,
      1641,
      1361,
      1534,
      1048,
      2506,
      2507,
      4272,
      1030,
      911,
      2368,
      1664,
      288,
      1070,
      2384,
      314,
      4724,
      2664,
      1053
    ],
  ),
  "bookmark_add": SymbolsMetadata(
    popularity: 2204,
    codepoint: 0xe598,
    categories: [6],
    tags: [
      192,
      526,
      4725,
      4726,
      4727,
      1670,
      4728,
      4729,
      4730,
      4731,
      1062,
      1201,
      3578,
      4732,
      4722,
      215,
      935,
      1641,
      763,
      4733,
      1534,
      202,
      4734,
      2507,
      4735,
      75,
      4272,
      2368,
      1664,
      4736,
      4737,
      35,
      441,
      1691
    ],
  ),
  "bookmark_added": SymbolsMetadata(
    popularity: 1524,
    codepoint: 0xe599,
    categories: [6],
    tags: [
      526,
      4725,
      4738,
      1549,
      1670,
      4739,
      1630,
      1631,
      1632,
      1633,
      1636,
      4271,
      1062,
      1639,
      3578,
      4740,
      4722,
      1641,
      4741,
      1643,
      4735,
      4272,
      2368,
      1664,
      4736,
      4742,
      288,
      2487,
      441,
      1647,
      2386,
      1523,
      1650
    ],
  ),
  "bookmark_bag": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf410,
    categories: [6],
    tags: [
      2013,
      2151,
      3719,
      4743,
      1670,
      3723,
      1484,
      3578,
      4722,
      1917,
      3489,
      1501,
      1581,
      18,
      2159,
      3726,
      21,
      909,
      4744,
      2506,
      2507,
      75,
      4272,
      1030,
      2368,
      1664,
      4742,
      841,
      4745,
      32,
      4746,
      2384,
      4747,
      2023,
      1504,
      4748,
      4749,
      1981,
      1591,
      2024,
      4750
    ],
  ),
  "bookmark_check": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf457,
    categories: [6],
    tags: [
      2716,
      526,
      4738,
      1549,
      2480,
      2151,
      1670,
      1630,
      1632,
      1633,
      4751,
      1636,
      2376,
      1639,
      2909,
      3578,
      4740,
      3065,
      4722,
      1251,
      18,
      2159,
      1641,
      1643,
      4752,
      2506,
      2507,
      4735,
      4272,
      2368,
      1664,
      4273,
      288,
      4753,
      2384,
      1646,
      1647,
      2385,
      2387,
      1523,
      1650
    ],
  ),
  "bookmark_flag": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf456,
    categories: [6],
    tags: [
      469,
      2151,
      1670,
      1631,
      4754,
      1484,
      1550,
      3578,
      4740,
      4722,
      4755,
      4756,
      15,
      3019,
      1251,
      18,
      3343,
      4723,
      2159,
      1001,
      1641,
      21,
      4757,
      198,
      4758,
      486,
      1493,
      1495,
      4759,
      4760,
      2506,
      2507,
      4735,
      4272,
      1030,
      1353,
      2368,
      1664,
      607,
      108,
      2384,
      4761,
      1645,
      1648,
      2165,
      4762,
      4763
    ],
  ),
  "bookmark_heart": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf455,
    categories: [6],
    tags: [
      4764,
      4765,
      4766,
      2151,
      1670,
      4767,
      3578,
      4768,
      4722,
      4457,
      4769,
      1251,
      18,
      2159,
      1560,
      4770,
      4771,
      21,
      4772,
      4773,
      2506,
      2507,
      4735,
      75,
      4272,
      2368,
      4774,
      4775,
      1664,
      4776,
      311,
      3586,
      2384,
      4777,
      4778
    ],
  ),
  "bookmark_manager": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf7b1,
    categories: [6],
    tags: [
      2151,
      1367,
      1670,
      4779,
      4731,
      1731,
      2155,
      693,
      4780,
      1201,
      1735,
      10,
      1528,
      1347,
      4781,
      1853,
      1654,
      696,
      4782,
      2299,
      4740,
      1530,
      4783,
      1656,
      4784,
      4785,
      966,
      2159,
      1755,
      4786,
      1740,
      763,
      98,
      4787,
      2693,
      2694,
      202,
      4735,
      1664,
      4788,
      4789,
      674,
      35,
      1260,
      1536,
      704
    ],
  ),
  "bookmark_remove": SymbolsMetadata(
    popularity: 727,
    codepoint: 0xe59a,
    categories: [6],
    tags: [
      2151,
      1670,
      895,
      4790,
      1631,
      1062,
      897,
      4791,
      1347,
      3578,
      4722,
      2159,
      21,
      1116,
      1534,
      2507,
      4735,
      4272,
      911,
      4792,
      2368,
      1664,
      1122,
      4793,
      4794,
      4795,
      4796,
      4797,
      1691
    ],
  ),
  "bookmark_star": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf454,
    categories: [6],
    tags: [
      2151,
      1038,
      3575,
      1670,
      4798,
      4799,
      3578,
      4740,
      4800,
      4801,
      4802,
      4722,
      3019,
      1251,
      4803,
      18,
      2159,
      1641,
      21,
      4804,
      4805,
      3582,
      286,
      102,
      2506,
      2507,
      4735,
      4272,
      1030,
      2368,
      1664,
      4273,
      3586,
      3264,
      4806,
      4807,
      2384,
      314
    ],
  ),
  "bookmarks": SymbolsMetadata(
    popularity: 3361,
    codepoint: 0xe98b,
    categories: [6],
    tags: [
      2151,
      1670,
      4731,
      2155,
      1062,
      1347,
      3578,
      4740,
      4722,
      4755,
      18,
      4723,
      1065,
      1066,
      2159,
      1641,
      21,
      2557,
      1361,
      1534,
      2506,
      2507,
      4735,
      4272,
      2368,
      4808,
      1664,
      4273,
      107,
      1069,
      4809,
      2384,
      315
    ],
  ),
  "books_movies_and_music": SymbolsMetadata(
    popularity: 50,
    codepoint: 0xef82,
    categories: [15],
    tags: [
      1129,
      4810,
      1910,
      4811,
      4812,
      2155,
      4813,
      1042,
      4814,
      1347,
      4696,
      3153,
      3337,
      4815,
      1530,
      3375,
      2159,
      367,
      4816,
      278,
      4817,
      3541,
      328,
      2081,
      4818,
      3463,
      2162,
      2163,
      1152,
      342,
      41
    ],
  ),
  "border_all": SymbolsMetadata(
    popularity: 389,
    codepoint: 0xe228,
    categories: [12],
    tags: [
      2325,
      1230,
      1367,
      349,
      4819,
      7,
      3639,
      802,
      1269,
      1370,
      1528,
      696,
      2299,
      1371,
      538,
      274,
      246,
      306,
      2753,
      98,
      1361,
      1068,
      75,
      1376,
      371,
      2264,
      4788,
      1379,
      32,
      4820,
      945,
      1380,
      38,
      40,
      317,
      1054,
      704
    ],
  ),
  "border_bottom": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xe229,
    categories: [12],
    tags: [
      349,
      4821,
      2188,
      4822,
      4823,
      3639,
      802,
      1042,
      2448,
      2449,
      1370,
      1528,
      1347,
      696,
      2299,
      1371,
      1372,
      2175,
      246,
      1205,
      306,
      1376,
      1377,
      4824,
      4788,
      1379,
      944,
      4820,
      1380,
      38,
      2230,
      40,
      3735,
      2498,
      4825,
      2185,
      704
    ],
  ),
  "border_clear": SymbolsMetadata(
    popularity: 194,
    codepoint: 0xe22a,
    categories: [12],
    tags: [
      2170,
      349,
      4826,
      994,
      3639,
      3436,
      2448,
      2449,
      4827,
      897,
      1528,
      236,
      696,
      2299,
      1371,
      1372,
      246,
      306,
      2753,
      4828,
      3841,
      3635,
      4829,
      911,
      4830,
      4831,
      426,
      4788,
      105,
      1379,
      32,
      944,
      4820,
      945,
      1380,
      38,
      3637,
      3426,
      40,
      704
    ],
  ),
  "border_color": SymbolsMetadata(
    popularity: 4696,
    codepoint: 0xe22b,
    categories: [12],
    tags: [
      1128,
      2325,
      349,
      4832,
      1731,
      693,
      1042,
      1201,
      1735,
      299,
      1528,
      1347,
      2834,
      696,
      2299,
      1371,
      1372,
      1205,
      1602,
      21,
      1740,
      1532,
      1534,
      2693,
      2694,
      75,
      4788,
      1379,
      4820,
      2182,
      38,
      40,
      2498,
      4825,
      1536,
      704
    ],
  ),
  "border_horizontal": SymbolsMetadata(
    popularity: 140,
    codepoint: 0xe22c,
    categories: [12],
    tags: [
      1593,
      2170,
      2940,
      349,
      4833,
      2188,
      3639,
      802,
      1042,
      2448,
      2449,
      1370,
      4834,
      1528,
      696,
      2299,
      1371,
      1372,
      2175,
      246,
      2176,
      306,
      1602,
      940,
      98,
      75,
      1376,
      1377,
      2264,
      4824,
      4788,
      1378,
      4835,
      1379,
      32,
      944,
      4820,
      945,
      1380,
      38,
      1124,
      40,
      704
    ],
  ),
  "border_inner": SymbolsMetadata(
    popularity: 120,
    codepoint: 0xe22d,
    categories: [12],
    tags: [
      2169,
      2170,
      349,
      994,
      1202,
      2448,
      2449,
      1370,
      1528,
      956,
      236,
      696,
      2299,
      1371,
      2628,
      274,
      246,
      4836,
      4837,
      2795,
      4838,
      306,
      459,
      366,
      4839,
      2263,
      1068,
      202,
      1496,
      75,
      1377,
      2264,
      4788,
      2248,
      1379,
      32,
      4820,
      945,
      38,
      40,
      1054,
      704
    ],
  ),
  "border_left": SymbolsMetadata(
    popularity: 119,
    codepoint: 0xe22e,
    categories: [12],
    tags: [
      2167,
      2169,
      349,
      4840,
      4841,
      4842,
      3639,
      1368,
      1042,
      2272,
      2448,
      2449,
      1528,
      696,
      2299,
      1371,
      1372,
      2175,
      246,
      2225,
      306,
      1375,
      2226,
      4843,
      4844,
      1534,
      2180,
      4788,
      1379,
      944,
      4820,
      1380,
      38,
      2183,
      4845,
      2231,
      40,
      1215,
      704
    ],
  ),
  "border_outer": SymbolsMetadata(
    popularity: 187,
    codepoint: 0xe22f,
    categories: [12],
    tags: [
      2169,
      2170,
      349,
      994,
      7,
      1269,
      2919,
      2448,
      2449,
      1528,
      956,
      236,
      696,
      2299,
      1371,
      787,
      2628,
      274,
      246,
      306,
      459,
      4839,
      4846,
      1361,
      3841,
      2263,
      1068,
      3635,
      1006,
      75,
      2247,
      2281,
      4788,
      2248,
      1379,
      32,
      944,
      4820,
      945,
      38,
      40,
      1054,
      704
    ],
  ),
  "border_right": SymbolsMetadata(
    popularity: 104,
    codepoint: 0xe230,
    categories: [12],
    tags: [
      2169,
      1367,
      349,
      4847,
      3639,
      802,
      1042,
      2448,
      2449,
      1370,
      4834,
      1528,
      1347,
      236,
      696,
      2299,
      1371,
      274,
      246,
      306,
      98,
      1534,
      1770,
      1396,
      4848,
      1376,
      1377,
      4824,
      4788,
      2238,
      2993,
      1378,
      1379,
      4820,
      945,
      1380,
      38,
      40,
      1381,
      1054,
      704
    ],
  ),
  "border_style": SymbolsMetadata(
    popularity: 199,
    codepoint: 0xe231,
    categories: [12],
    tags: [
      1128,
      349,
      4841,
      994,
      4849,
      4850,
      1042,
      1062,
      2448,
      2449,
      1577,
      1370,
      1528,
      1347,
      1579,
      236,
      696,
      2299,
      1371,
      1372,
      274,
      306,
      1361,
      1534,
      1770,
      4851,
      75,
      2247,
      1377,
      4852,
      371,
      4824,
      311,
      4788,
      1379,
      32,
      4820,
      945,
      2182,
      38,
      40,
      1054,
      704
    ],
  ),
  "border_top": SymbolsMetadata(
    popularity: 118,
    codepoint: 0xe232,
    categories: [12],
    tags: [
      2169,
      1367,
      349,
      4853,
      3639,
      802,
      1042,
      2448,
      2449,
      10,
      1370,
      1528,
      1347,
      696,
      2299,
      1371,
      1372,
      246,
      4854,
      2176,
      306,
      1602,
      92,
      98,
      1534,
      75,
      1376,
      1377,
      2264,
      4788,
      1379,
      32,
      4820,
      945,
      1380,
      38,
      1124,
      4855,
      40,
      704
    ],
  ),
  "border_vertical": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xe233,
    categories: [12],
    tags: [
      2169,
      1367,
      349,
      4856,
      802,
      2448,
      2449,
      1370,
      4834,
      1528,
      696,
      2299,
      1371,
      1372,
      2175,
      246,
      306,
      940,
      2227,
      3421,
      4857,
      1377,
      2264,
      4824,
      4788,
      1378,
      1379,
      4820,
      1380,
      38,
      2183,
      2230,
      2251,
      4858,
      40,
      1381,
      2199,
      4859,
      4860,
      1054,
      704
    ],
  ),
  "borg": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf40d,
    categories: [2],
    tags: [
      3325,
      4861,
      4862,
      4863,
      7,
      4864,
      4865,
      4866,
      211,
      4867,
      1269,
      408,
      10,
      3419,
      4868,
      1659,
      930,
      1661,
      4869,
      1064,
      935,
      4870,
      223,
      2424,
      32,
      945,
      2632,
      551
    ],
  ),
  "bottom_app_bar": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xe730,
    categories: [2],
    tags: [
      1229,
      4871,
      3621,
      1230,
      1343,
      2188,
      4872,
      4873,
      4874,
      4875,
      4876,
      383,
      2750,
      299,
      1370,
      4834,
      2522,
      4877,
      1205,
      2751,
      306,
      1602,
      788,
      219,
      2645,
      4878,
      4879,
      4880,
      327,
      421,
      4881,
      1770,
      226,
      78,
      330,
      1377,
      2882,
      1378,
      32,
      447,
      2757,
      4882,
      792,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "bottom_drawer": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xe72d,
    categories: [2],
    tags: [
      1229,
      1230,
      2188,
      4883,
      4884,
      4885,
      2896,
      4866,
      2750,
      1269,
      1042,
      299,
      2983,
      787,
      1078,
      900,
      2751,
      1065,
      306,
      788,
      219,
      4886,
      327,
      421,
      1081,
      1770,
      226,
      4887,
      75,
      2948,
      330,
      4788,
      2997,
      2882,
      4789,
      4888,
      32,
      447,
      1214,
      2757,
      4889,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "bottom_navigation": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xe98c,
    categories: [2],
    tags: [
      1229,
      4871,
      1230,
      1343,
      2188,
      4873,
      4890,
      4875,
      4891,
      2750,
      299,
      4877,
      2751,
      306,
      1602,
      788,
      219,
      2645,
      4879,
      4880,
      327,
      421,
      4881,
      1770,
      226,
      75,
      190,
      78,
      330,
      2882,
      32,
      4892,
      447,
      4809,
      2757,
      4882,
      792,
      2759,
      1691,
      4893,
      1053,
      4894,
      1054
    ],
  ),
  "bottom_panel_close": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf72a,
    categories: [2],
    tags: [
      4895,
      380,
      2188,
      4876,
      4896,
      2871,
      2950,
      2981,
      2896,
      269,
      388,
      3615,
      2651,
      2924,
      2983,
      2735,
      900,
      4897,
      4077,
      306,
      2928,
      4898,
      4886,
      421,
      1081,
      1770,
      3421,
      4788,
      4899,
      4900,
      1701,
      1054,
      2746
    ],
  ),
  "bottom_panel_open": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf729,
    categories: [2],
    tags: [
      1229,
      380,
      2052,
      2188,
      4876,
      2871,
      2862,
      4901,
      1943,
      388,
      12,
      2983,
      787,
      4902,
      1078,
      306,
      2315,
      788,
      4880,
      421,
      2653,
      1770,
      3421,
      4903,
      2948,
      1377,
      4788,
      2997,
      4888,
      4900,
      314,
      1701,
      1676,
      2916,
      1054,
      2746
    ],
  ),
  "bottom_right_click": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf684,
    categories: [2],
    tags: [
      380,
      2650,
      419,
      2188,
      4904,
      4905,
      4906,
      1776,
      4907,
      4908,
      4909,
      1062,
      4910,
      1781,
      388,
      832,
      2840,
      3016,
      3759,
      1001,
      788,
      3020,
      4911,
      421,
      1783,
      1496,
      1396,
      4912,
      4913,
      4914,
      288,
      371,
      2935,
      32,
      36
    ],
  ),
  "bottom_sheets": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe98d,
    categories: [2],
    tags: [
      1229,
      1230,
      2188,
      4915,
      2896,
      4866,
      2750,
      299,
      2983,
      787,
      2751,
      1066,
      306,
      788,
      219,
      4886,
      327,
      656,
      4916,
      1081,
      1770,
      3421,
      226,
      4903,
      330,
      4788,
      4917,
      2882,
      4888,
      107,
      1069,
      447,
      2344,
      2757,
      2759,
      317,
      42,
      1691,
      1053,
      1054,
      1084
    ],
  ),
  "box": SymbolsMetadata(
    popularity: 98,
    codepoint: 0xf5a4,
    categories: [9],
    tags: [
      1670,
      7,
      4918,
      1269,
      408,
      1019,
      2210,
      3578,
      4919,
      1251,
      3895,
      18,
      3896,
      1641,
      4920,
      96,
      2647,
      4921,
      1409,
      4922,
      1622,
      1030,
      2368,
      1664,
      4923,
      4606,
      841,
      674,
      532,
      2384,
      441,
      3902
    ],
  ),
  "box_add": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf5a5,
    categories: [9],
    tags: [
      192,
      526,
      1262,
      1264,
      4924,
      4925,
      4926,
      1057,
      2151,
      7,
      4918,
      1269,
      1201,
      4927,
      4928,
      1019,
      1206,
      1044,
      763,
      1274,
      4929,
      2647,
      4921,
      202,
      1277,
      4930,
      1409,
      4922,
      1622,
      4923,
      4606,
      674
    ],
  ),
  "box_edit": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf5a6,
    categories: [9],
    tags: [
      1128,
      1726,
      2488,
      1670,
      7,
      4931,
      1731,
      693,
      1269,
      2376,
      1201,
      1735,
      1019,
      1347,
      1853,
      696,
      4932,
      2299,
      1530,
      966,
      1740,
      1532,
      2647,
      4921,
      2693,
      2694,
      2695,
      75,
      2497,
      1664,
      4606,
      441,
      1260,
      1536,
      704
    ],
  ),
  "boy": SymbolsMetadata(
    popularity: 1528,
    codepoint: 0xeb67,
    categories: [3],
    tags: [
      468,
      470,
      4933,
      83,
      584,
      4934,
      4935,
      862,
      4936,
      1791,
      483,
      16,
      870,
      4937,
      1803,
      4938,
      4939,
      1361,
      488,
      489,
      3172,
      1967,
      490,
      4940,
      105,
      607,
      4941,
      750,
      35,
      501,
      4942
    ],
  ),
  "brand_awareness": SymbolsMetadata(
    popularity: 597,
    codepoint: 0xe98e,
    categories: [0],
    tags: [
      1073,
      469,
      4943,
      1245,
      3073,
      1129,
      4944,
      2539,
      4945,
      4946,
      355,
      1040,
      443,
      269,
      187,
      197,
      1045,
      4947,
      2081,
      2503,
      486,
      4948,
      4949,
      1050,
      4950,
      204,
      1665,
      227,
      31,
      1156,
      1157,
      441,
      344,
      1745,
      1902
    ],
  ),
  "brand_family": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf4f1,
    categories: [12],
    tags: [
      3495,
      685,
      4,
      2778,
      2539,
      4951,
      4952,
      8,
      692,
      4953,
      867,
      14,
      4954,
      4955,
      1372,
      2175,
      4956,
      19,
      4957,
      4958,
      2786,
      3379,
      4959,
      2182,
      4960,
      35,
      4961,
      38,
      2230,
      40,
      4962,
      4963,
      702
    ],
  ),
  "branding_watermark": SymbolsMetadata(
    popularity: 990,
    codepoint: 0xe06b,
    categories: [0],
    tags: [
      526,
      3352,
      3116,
      6,
      2539,
      2779,
      2750,
      1042,
      3357,
      3128,
      299,
      2970,
      3577,
      1372,
      850,
      53,
      1044,
      4964,
      2751,
      4965,
      306,
      2528,
      1081,
      3363,
      59,
      119,
      1520,
      75,
      330,
      2882,
      32,
      2728,
      4966,
      2757,
      2759,
      4967,
      1691,
      1053,
      1054
    ],
  ),
  "breakfast_dining": SymbolsMetadata(
    popularity: 540,
    codepoint: 0xea54,
    categories: [16],
    tags: [
      3787,
      3789,
      3790,
      4968,
      4969,
      3791,
      4970,
      3792,
      4971,
      4972,
      3799,
      3800,
      4973,
      1829,
      4974,
      4975,
      4976,
      4977,
      3804,
      4978,
      2097,
      3807,
      4979,
      4980,
      3809,
      4981,
      4982
    ],
  ),
  "breaking_news": SymbolsMetadata(
    popularity: 135,
    codepoint: 0xea08,
    categories: [12],
    tags: [
      3175,
      469,
      1245,
      2501,
      3073,
      1400,
      4983,
      4984,
      1693,
      3176,
      832,
      2766,
      2767,
      3177,
      2502,
      4985,
      1251,
      135,
      92,
      4986,
      1641,
      367,
      485,
      2503,
      4987,
      486,
      1409,
      4988,
      1029,
      1353,
      77,
      1258,
      35,
      441,
      1260,
      1034,
      1261
    ],
  ),
  "breaking_news_alt_1": SymbolsMetadata(
    popularity: 969,
    codepoint: 0xf0ba,
    categories: [12],
    tags: [
      3175,
      469,
      1245,
      2501,
      3073,
      1400,
      4983,
      4984,
      1693,
      3176,
      2766,
      2767,
      3177,
      2502,
      4985,
      1251,
      135,
      1641,
      367,
      2503,
      4987,
      486,
      1409,
      4989,
      4760,
      75,
      1353,
      190,
      32,
      1258,
      35,
      441,
      1260,
      1034,
      1261
    ],
  ),
  "breastfeeding": SymbolsMetadata(
    popularity: 125,
    codepoint: 0xf856,
    categories: [3],
    tags: [
      3598,
      3599,
      4990,
      584,
      4991,
      4992,
      4993,
      4994,
      4995,
      3600,
      862,
      3602,
      865,
      4996,
      867,
      2502,
      4997,
      595,
      4998,
      483,
      4999,
      3606,
      5000,
      871,
      5001,
      4770,
      5002,
      5003,
      5004,
      5005,
      3607,
      5006,
      3609,
      5007,
      5008,
      5009,
      874,
      5010,
      488,
      489,
      5011,
      495,
      3612,
      1905,
      5012,
      879
    ],
  ),
  "brick": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xf388,
    categories: [3],
    tags: [
      684,
      2601,
      1074,
      5013,
      4864,
      798,
      5014,
      4866,
      2832,
      1201,
      88,
      3327,
      697,
      5015,
      1659,
      871,
      4965,
      5016,
      2472,
      5017,
      5018,
      4870,
      5019,
      26,
      5020,
      75,
      105,
      32,
      107,
      945,
      3637,
      2543,
      5021
    ],
  ),
  "brightness_1": SymbolsMetadata(
    popularity: 637,
    codepoint: 0xe3a6,
    categories: [1],
    tags: [
      79,
      733,
      1128,
      1728,
      47,
      116,
      383,
      1732,
      269,
      4248,
      12,
      5022,
      4127,
      1738,
      5023,
      53,
      126,
      2472,
      3680,
      974,
      4255,
      1361,
      61,
      121,
      177,
      1257,
      330,
      310,
      41,
      317,
      5024,
      986
    ],
  ),
  "brightness_2": SymbolsMetadata(
    popularity: 401,
    codepoint: 0xe3a7,
    categories: [1],
    tags: [
      81,
      1128,
      4245,
      4214,
      1728,
      4246,
      383,
      269,
      4248,
      4249,
      5025,
      3691,
      4253,
      5026,
      2472,
      4254,
      4255,
      4222,
      4256,
      329,
      330,
      3685,
      65,
      5027,
      1929,
      313,
      5028,
      314,
      4262,
      5029,
      731
    ],
  ),
  "brightness_3": SymbolsMetadata(
    popularity: 469,
    codepoint: 0xe3a8,
    categories: [1],
    tags: [
      82,
      4040,
      3666,
      4245,
      4214,
      1728,
      4246,
      383,
      269,
      4248,
      4249,
      5025,
      3691,
      4252,
      4253,
      2472,
      3713,
      4254,
      4255,
      4222,
      4256,
      3715,
      330,
      3685,
      310,
      1929,
      5030,
      374,
      4047,
      4262,
      5029
    ],
  ),
  "brightness_4": SymbolsMetadata(
    popularity: 889,
    codepoint: 0xe3a9,
    categories: [1],
    tags: [
      534,
      3325,
      3666,
      1728,
      383,
      269,
      4248,
      5025,
      3691,
      3672,
      5031,
      538,
      1659,
      16,
      5032,
      2472,
      5033,
      3680,
      5034,
      4255,
      4222,
      4256,
      1662,
      5035,
      330,
      3685,
      65,
      3699,
      3264,
      3686,
      35
    ],
  ),
  "brightness_5": SymbolsMetadata(
    popularity: 1027,
    codepoint: 0xe3aa,
    categories: [1],
    tags: [
      564,
      1128,
      3670,
      1728,
      383,
      269,
      4248,
      5036,
      12,
      3257,
      4043,
      3674,
      2471,
      3677,
      5037,
      2472,
      3680,
      5038,
      5039,
      327,
      4255,
      3641,
      5040,
      3683,
      330,
      310,
      3699,
      3264,
      3686,
      4210,
      731
    ],
  ),
  "brightness_6": SymbolsMetadata(
    popularity: 1594,
    codepoint: 0xe3ab,
    categories: [1],
    tags: [
      5041,
      580,
      1128,
      3666,
      1728,
      3702,
      383,
      269,
      4248,
      3691,
      12,
      5042,
      3257,
      1659,
      5043,
      5044,
      2472,
      3680,
      5045,
      4045,
      327,
      4255,
      4130,
      1662,
      330,
      3685,
      310,
      65,
      3699,
      3264,
      3686
    ],
  ),
  "brightness_7": SymbolsMetadata(
    popularity: 620,
    codepoint: 0xe3ac,
    categories: [1],
    tags: [
      636,
      1128,
      3670,
      1728,
      3702,
      3703,
      3704,
      383,
      269,
      4248,
      5046,
      12,
      3257,
      1659,
      3674,
      2471,
      3676,
      5037,
      2472,
      5047,
      3680,
      5038,
      5039,
      327,
      4255,
      2097,
      3683,
      330,
      310,
      641,
      3699,
      3264,
      3686,
      4210
    ],
  ),
  "brightness_alert": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xf5cf,
    categories: [4],
    tags: [
      3175,
      469,
      3073,
      6,
      3670,
      1728,
      1693,
      269,
      3775,
      3176,
      12,
      2766,
      2767,
      5048,
      480,
      2471,
      3019,
      1251,
      5037,
      2769,
      2472,
      3680,
      1641,
      219,
      327,
      486,
      5049,
      226,
      1363,
      2772,
      1353,
      330,
      310,
      3264,
      3686,
      1034,
      1261
    ],
  ),
  "brightness_auto": SymbolsMetadata(
    popularity: 272,
    codepoint: 0xe1ab,
    categories: [4],
    tags: [
      3495,
      685,
      1127,
      5050,
      1128,
      5051,
      1131,
      5052,
      5053,
      5054,
      1132,
      5055,
      6,
      1728,
      5056,
      3702,
      269,
      12,
      325,
      5057,
      2781,
      2472,
      3680,
      5038,
      219,
      327,
      226,
      330,
      3685,
      310,
      65,
      3264,
      5058,
      3686
    ],
  ),
  "brightness_empty": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xf7e8,
    categories: [4],
    tags: [
      5059,
      1128,
      3670,
      1728,
      269,
      3690,
      3691,
      3257,
      4013,
      1659,
      901,
      188,
      5037,
      2472,
      3680,
      4014,
      3329,
      5060,
      907,
      1361,
      1662,
      65,
      311,
      105,
      372,
      3264,
      4820,
      3686,
      314
    ],
  ),
  "brightness_medium": SymbolsMetadata(
    popularity: 483,
    codepoint: 0xe1ae,
    categories: [4],
    tags: [
      4155,
      1128,
      5061,
      1131,
      1728,
      5062,
      269,
      785,
      4248,
      12,
      5031,
      5043,
      4034,
      3677,
      5037,
      2472,
      3680,
      5063,
      5038,
      4044,
      219,
      4045,
      327,
      656,
      1770,
      226,
      330,
      5064,
      310,
      65,
      3699,
      3264,
      3686
    ],
  ),
  "bring_your_own_ip": SymbolsMetadata(
    popularity: 899,
    codepoint: 0xe016,
    categories: [3],
    tags: [
      5065,
      5066,
      5067,
      1652,
      268,
      211,
      212,
      5068,
      5069,
      5070,
      5071,
      5072,
      246,
      5073,
      5074,
      215,
      5075,
      5076,
      5077,
      5078,
      223,
      5079,
      5080,
      5081,
      3761,
      65,
      5082,
      32,
      5083,
      4763,
      5084
    ],
  ),
  "broadcast_on_home": SymbolsMetadata(
    popularity: 191,
    codepoint: 0xf8f8,
    categories: [0],
    tags: [
      1180,
      2827,
      355,
      5085,
      211,
      445,
      1711,
      999,
      3235,
      1435,
      16,
      215,
      223,
      75,
      5086,
      2343,
      3057,
      1665,
      3058,
      227,
      1901,
      342,
      35,
      551,
      441,
      2085,
      5087,
      1902,
      233,
      234
    ],
  ),
  "broadcast_on_personal": SymbolsMetadata(
    popularity: 247,
    codepoint: 0xf8f9,
    categories: [0],
    tags: [
      1180,
      355,
      5088,
      211,
      999,
      5089,
      5090,
      5091,
      1435,
      5092,
      215,
      216,
      5093,
      5094,
      223,
      436,
      790,
      5095,
      5086,
      1665,
      227,
      228,
      1901,
      5096,
      2057,
      5087,
      233,
      234,
      442,
      5097
    ],
  ),
  "broken_image": SymbolsMetadata(
    popularity: 994,
    codepoint: 0xe3ad,
    categories: [1],
    tags: [
      469,
      5098,
      5099,
      5100,
      5101,
      5102,
      5103,
      5104,
      5105,
      5106,
      5107,
      2766,
      5108,
      5109,
      5110,
      53,
      5111,
      5112,
      5113,
      1543,
      5114,
      5115,
      5116,
      1544,
      1545,
      5117,
      59,
      61,
      119,
      1048,
      2772,
      5118,
      32,
      5119,
      441,
      5120,
      5121,
      5122,
      1261,
      5123
    ],
  ),
  "browse": SymbolsMetadata(
    popularity: 151,
    codepoint: 0xeb13,
    categories: [6],
    tags: [
      1230,
      1367,
      5124,
      1039,
      5125,
      1042,
      955,
      958,
      1541,
      246,
      215,
      306,
      2159,
      2557,
      421,
      656,
      98,
      3464,
      3421,
      4857,
      2258,
      371,
      944,
      313,
      314,
      317,
      1691,
      1053,
      1054,
      1084
    ],
  ),
  "browse_activity": SymbolsMetadata(
    popularity: 1393,
    codepoint: 0xf8a5,
    categories: [2],
    tags: [
      989,
      5124,
      1039,
      5126,
      920,
      1685,
      445,
      924,
      12,
      929,
      965,
      1023,
      5127,
      327,
      4460,
      5128,
      5129,
      189,
      1353,
      330,
      980,
      5130,
      3264,
      33,
      947,
      2852,
      317,
      5131,
      5132,
      1054
    ],
  ),
  "browse_gallery": SymbolsMetadata(
    popularity: 1687,
    codepoint: 0xebd1,
    categories: [2],
    tags: [
      989,
      2151,
      5124,
      5133,
      383,
      1016,
      2155,
      385,
      1020,
      5134,
      958,
      1541,
      1023,
      2159,
      5127,
      390,
      5135,
      5136,
      2841,
      28,
      1029,
      5137,
      2367,
      1031,
      107,
      289,
      290,
      5138,
      317,
      2102
    ],
  ),
  "browser_updated": SymbolsMetadata(
    popularity: 656,
    codepoint: 0xe7cf,
    categories: [11],
    tags: [
      1109,
      1110,
      1230,
      5139,
      380,
      2650,
      1039,
      5140,
      5141,
      1684,
      694,
      1685,
      445,
      12,
      337,
      965,
      1114,
      1542,
      1674,
      215,
      3513,
      1687,
      327,
      5142,
      2648,
      424,
      1664,
      330,
      5143,
      5144,
      1260,
      5145,
      533,
      1691,
      5146,
      1054
    ],
  ),
  "brunch_dining": SymbolsMetadata(
    popularity: 468,
    codepoint: 0xea73,
    categories: [16],
    tags: [
      3790,
      5147,
      3791,
      5148,
      3792,
      5149,
      5150,
      5151,
      3799,
      5152,
      4390,
      5153,
      1829,
      5154,
      964,
      1066,
      3803,
      3804,
      5155,
      5156,
      2097,
      5157,
      3807,
      5158,
      1069,
      4981,
      5159,
      5160
    ],
  ),
  "brush": SymbolsMetadata(
    popularity: 3894,
    codepoint: 0xe3ae,
    categories: [1],
    tags: [
      2829,
      5161,
      5162,
      5163,
      1201,
      5164,
      2332,
      299,
      5165,
      2834,
      302,
      696,
      2299,
      1371,
      305,
      5166,
      53,
      3145,
      2836,
      1602,
      1740,
      5167,
      5168,
      5169,
      5170,
      311,
      5171,
      4820,
      2537
    ],
  ),
  "bubble": SymbolsMetadata(
    popularity: 102,
    codepoint: 0xef83,
    categories: [2],
    tags: [
      5172,
      380,
      419,
      471,
      472,
      383,
      384,
      473,
      474,
      443,
      476,
      2969,
      477,
      388,
      480,
      777,
      485,
      1409,
      979,
      4104,
      1410,
      1565,
      1396,
      889,
      2343,
      1665,
      31,
      493,
      1412,
      496,
      1676,
      346
    ],
  ),
  "bubble_chart": SymbolsMetadata(
    popularity: 1321,
    codepoint: 0xe6dd,
    categories: [9],
    tags: [
      2513,
      5,
      1343,
      365,
      471,
      5173,
      5174,
      1284,
      920,
      953,
      10,
      4293,
      2847,
      924,
      808,
      929,
      933,
      135,
      2516,
      2518,
      1045,
      597,
      937,
      5175,
      189,
      1353,
      4078,
      3857,
      33,
      983,
      947,
      5176,
      1355
    ],
  ),
  "bubbles": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf64e,
    categories: [2],
    tags: [
      469,
      1229,
      380,
      2650,
      419,
      2188,
      471,
      5174,
      116,
      472,
      383,
      2950,
      2896,
      473,
      1042,
      3050,
      388,
      832,
      2651,
      337,
      2652,
      1542,
      2863,
      2338,
      2751,
      485,
      763,
      3282,
      486,
      1363,
      2342,
      75,
      1396,
      1664,
      32,
      2007,
      2757,
      1260,
      2759,
      1054
    ],
  ),
  "bug_report": SymbolsMetadata(
    popularity: 6524,
    codepoint: 0xe868,
    categories: [6],
    tags: [
      469,
      5177,
      1180,
      5178,
      5179,
      5180,
      5181,
      1184,
      1185,
      5182,
      2766,
      5183,
      480,
      1737,
      5184,
      2769,
      366,
      5185,
      2772,
      5186,
      5187,
      1353,
      5188,
      5189,
      5190,
      5191,
      5192,
      441,
      5193,
      1261
    ],
  ),
  "build": SymbolsMetadata(
    popularity: 8322,
    codepoint: 0xe869,
    categories: [6],
    tags: [
      1128,
      4864,
      268,
      2832,
      5194,
      1735,
      2625,
      696,
      2835,
      1737,
      999,
      5195,
      5196,
      1674,
      2644,
      2770,
      5197,
      2837,
      1740,
      1004,
      656,
      329,
      3474,
      2631,
      65,
      2649,
      5198,
      2537,
      2756,
      5199
    ],
  ),
  "build_circle": SymbolsMetadata(
    popularity: 2625,
    codepoint: 0xef48,
    categories: [6],
    tags: [
      1128,
      4864,
      5200,
      383,
      4867,
      2832,
      1201,
      3457,
      2625,
      1737,
      2770,
      1755,
      5197,
      2837,
      1740,
      281,
      329,
      3474,
      65,
      2649,
      5198,
      2537,
      1260,
      533,
      5201,
      5199
    ],
  ),
  "bungalow": SymbolsMetadata(
    popularity: 263,
    codepoint: 0xe591,
    categories: [16],
    tags: [
      2599,
      2601,
      798,
      5202,
      5203,
      5204,
      4827,
      1434,
      2605,
      999,
      5205,
      1435,
      5206,
      2781,
      2610,
      5207,
      1490,
      421,
      1495,
      5208,
      1444,
      2614,
      1445,
      2615,
      1446,
      2616,
      823,
      2617,
      32,
      3846,
      5209,
      1701,
      2024
    ],
  ),
  "burst_mode": SymbolsMetadata(
    popularity: 245,
    codepoint: 0xe43c,
    categories: [1],
    tags: [
      4663,
      5210,
      47,
      5211,
      116,
      5212,
      5213,
      53,
      5214,
      2554,
      1543,
      366,
      307,
      1544,
      1545,
      5215,
      2557,
      5216,
      59,
      5217,
      5218,
      61,
      119,
      5219,
      5220,
      5221,
      75,
      2570,
      32,
      2586,
      440,
      441
    ],
  ),
  "bus_alert": SymbolsMetadata(
    popularity: 458,
    codepoint: 0xe98f,
    categories: [14],
    tags: [
      3175,
      3466,
      469,
      3073,
      1814,
      2062,
      5222,
      1815,
      1816,
      1693,
      383,
      2063,
      3176,
      2137,
      1997,
      2482,
      2766,
      2767,
      3177,
      1251,
      5223,
      2769,
      1490,
      1641,
      486,
      2772,
      4603,
      5224,
      2453,
      5225,
      5226,
      35,
      1590,
      2008,
      1930,
      1504,
      1844,
      1261
    ],
  ),
  "bus_railway": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf36b,
    categories: [14],
    tags: [
      2014,
      1814,
      2062,
      4598,
      5227,
      1815,
      1816,
      383,
      2063,
      5228,
      2079,
      2016,
      388,
      1581,
      1490,
      1967,
      2071,
      4603,
      5229,
      5230,
      4620,
      4621,
      5231,
      3611,
      5232,
      4623,
      35,
      4624,
      5233,
      5234,
      4625,
      2008,
      5235,
      1930,
      5236,
      1504,
      5237,
      1591,
      1625,
      1844
    ],
  ),
  "business_center": SymbolsMetadata(
    popularity: 5226,
    codepoint: 0xeb3f,
    categories: [5],
    tags: [
      3719,
      4743,
      5238,
      1284,
      5239,
      5240,
      3723,
      5241,
      1730,
      1285,
      5242,
      5243,
      5244,
      808,
      3489,
      3170,
      3726,
      1145,
      1456,
      940,
      2613,
      2585,
      5245,
      5246,
      5247,
      75,
      5248,
      32,
      4746,
      2537,
      1459
    ],
  ),
  "business_chip": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf84c,
    categories: [12],
    tags: [
      5249,
      6,
      3719,
      4743,
      5238,
      1284,
      298,
      5240,
      5241,
      5250,
      383,
      1269,
      5251,
      808,
      16,
      815,
      3170,
      936,
      1456,
      5185,
      5245,
      5246,
      1519,
      1520,
      5247,
      3331,
      1011,
      2631,
      4746,
      35,
      1459
    ],
  ),
  "business_messages": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xef84,
    categories: [7],
    tags: [
      419,
      3005,
      471,
      1284,
      5252,
      5253,
      5254,
      472,
      473,
      443,
      476,
      5255,
      478,
      2450,
      2627,
      1672,
      480,
      1542,
      485,
      2341,
      2342,
      75,
      1410,
      1411,
      2343,
      1665,
      493,
      494,
      32,
      5256,
      313,
      496,
      38,
      2007
    ],
  ),
  "buttons_alt": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xe72f,
    categories: [2],
    tags: [
      192,
      5257,
      949,
      526,
      298,
      952,
      383,
      4866,
      1733,
      3233,
      269,
      5258,
      1201,
      1202,
      1735,
      445,
      1711,
      787,
      5259,
      697,
      5260,
      1207,
      966,
      2751,
      789,
      763,
      656,
      1770,
      202,
      1212,
      1213,
      75,
      77,
      65,
      551
    ],
  ),
  "cabin": SymbolsMetadata(
    popularity: 496,
    codepoint: 0xe589,
    categories: [16],
    tags: [
      2599,
      2601,
      798,
      5203,
      3722,
      5261,
      5262,
      5204,
      1817,
      2605,
      5263,
      2018,
      999,
      2080,
      1435,
      366,
      2610,
      5127,
      5264,
      1490,
      1495,
      2614,
      2615,
      1446,
      2616,
      2978,
      823,
      5265,
      2617,
      5266,
      1069,
      3846,
      2586,
      1504,
      5209,
      1701,
      2024,
      5267,
      5268
    ],
  ),
  "cable": SymbolsMetadata(
    popularity: 1363,
    codepoint: 0xefe6,
    categories: [4],
    tags: [
      5269,
      1129,
      5270,
      382,
      4364,
      5271,
      921,
      211,
      4365,
      4366,
      445,
      1711,
      5272,
      965,
      5273,
      966,
      5274,
      1602,
      935,
      223,
      1719,
      4373,
      2534,
      3782,
      227,
      551,
      2007,
      5275,
      41,
      4380
    ],
  ),
  "cable_car": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf479,
    categories: [14],
    tags: [
      5276,
      1814,
      7,
      5277,
      5278,
      5279,
      1815,
      1816,
      5280,
      383,
      388,
      5281,
      5282,
      2018,
      1490,
      1544,
      5283,
      2071,
      4603,
      5230,
      4620,
      4621,
      5284,
      5285,
      3348,
      5286,
      5287,
      4623,
      5288,
      2023,
      4624,
      4625,
      2008,
      1842,
      1930,
      1504,
      1625,
      2024,
      1844,
      732,
      5289
    ],
  ),
  "cached": SymbolsMetadata(
    popularity: 5550,
    codepoint: 0xe86a,
    categories: [2],
    tags: [
      2284,
      419,
      2565,
      5290,
      3521,
      3522,
      384,
      2907,
      3523,
      385,
      2627,
      3524,
      3513,
      2568,
      3525,
      390,
      5291,
      2492,
      424,
      425,
      2494,
      426,
      3516,
      2496,
      396,
      397,
      674,
      5256,
      1667,
      3529,
      2007,
      2499,
      1260
    ],
  ),
  "cadence": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf4b4,
    categories: [15],
    tags: [
      5292,
      4311,
      1129,
      365,
      5293,
      5294,
      1182,
      5295,
      920,
      5296,
      2332,
      385,
      10,
      2925,
      2926,
      2927,
      926,
      277,
      929,
      390,
      634,
      937,
      2081,
      2082,
      3635,
      3570,
      5297,
      5298,
      2931,
      2932,
      227,
      1156,
      109,
      5299,
      3565,
      441,
      2086,
      1862
    ],
  ),
  "cake": SymbolsMetadata(
    popularity: 3906,
    codepoint: 0xe7e9,
    categories: [15],
    tags: [
      526,
      5300,
      5301,
      3787,
      5302,
      5303,
      5304,
      5305,
      5306,
      5307,
      5308,
      5150,
      5309,
      3797,
      5310,
      2094,
      5311,
      1829,
      5312,
      2018,
      763,
      487,
      5313,
      5314,
      3806,
      202,
      5315,
      607,
      5316,
      3810,
      5317,
      35,
      5318,
      5319,
      5320
    ],
  ),
  "cake_add": SymbolsMetadata(
    popularity: 99,
    codepoint: 0xf85b,
    categories: [15],
    tags: [
      526,
      5321,
      5322,
      5323,
      5300,
      3787,
      5302,
      5303,
      5305,
      5306,
      5150,
      5324,
      1201,
      5325,
      3797,
      5310,
      2094,
      1829,
      763,
      5326,
      5327,
      487,
      3806,
      202,
      5328,
      5329,
      5316,
      3810
    ],
  ),
  "calculate": SymbolsMetadata(
    popularity: 7519,
    codepoint: 0xea5f,
    categories: [9],
    tags: [
      192,
      5330,
      5331,
      526,
      5172,
      1230,
      1198,
      298,
      1199,
      2375,
      5332,
      3943,
      9,
      5333,
      1370,
      5334,
      2377,
      5335,
      2378,
      1210,
      2380,
      1116,
      3261,
      202,
      1622,
      5336,
      4477,
      5337,
      32,
      1122,
      461,
      3265,
      2537
    ],
  ),
  "calendar_add_on": SymbolsMetadata(
    popularity: 2207,
    codepoint: 0xef85,
    categories: [7],
    tags: [
      192,
      526,
      5338,
      5339,
      5340,
      1015,
      1936,
      5341,
      5342,
      5343,
      1201,
      5344,
      1017,
      5345,
      5036,
      2094,
      5346,
      5347,
      763,
      5348,
      1211,
      2838,
      202,
      1212,
      1030,
      5349,
      1031,
      5350,
      35,
      289,
      5351,
      5352
    ],
  ),
  "calendar_apps_script": SymbolsMetadata(
    popularity: 320,
    codepoint: 0xf0bb,
    categories: [7],
    tags: [
      5353,
      5340,
      1015,
      2148,
      1936,
      5341,
      5354,
      5355,
      5344,
      1017,
      5036,
      1018,
      337,
      2094,
      1672,
      5347,
      5356,
      98,
      5357,
      2838,
      1030,
      5358,
      1031,
      3379,
      5359,
      1645,
      289,
      5351,
      5352
    ],
  ),
  "calendar_clock": SymbolsMetadata(
    popularity: 250,
    codepoint: 0xf540,
    categories: [6],
    tags: [
      5340,
      1244,
      469,
      1015,
      5360,
      1246,
      1936,
      5341,
      5361,
      5342,
      5362,
      1016,
      5363,
      5364,
      1017,
      5365,
      5036,
      1018,
      767,
      2093,
      1020,
      898,
      2094,
      4723,
      459,
      5347,
      486,
      2838,
      1030,
      1031,
      5350,
      289,
      2099,
      5366,
      1033,
      5351,
      2102,
      5352
    ],
  ),
  "calendar_month": SymbolsMetadata(
    popularity: 38121,
    codepoint: 0xebcc,
    categories: [6],
    tags: [
      5340,
      1015,
      1936,
      5341,
      5342,
      5367,
      1017,
      5345,
      5036,
      1018,
      956,
      2094,
      5347,
      5368,
      940,
      5369,
      2107,
      1030,
      2663,
      1924,
      1031,
      5370,
      32,
      289,
      2099,
      5371,
      5351,
      5372
    ],
  ),
  "calendar_today": SymbolsMetadata(
    popularity: 11860,
    codepoint: 0xe935,
    categories: [6],
    tags: [
      5340,
      1015,
      5341,
      5342,
      5343,
      1851,
      5373,
      5374,
      1017,
      5345,
      5036,
      1018,
      2094,
      5347,
      1534,
      2107,
      75,
      1030,
      1031,
      5375,
      32,
      289,
      5351,
      5376,
      1214,
      5372,
      5352
    ],
  ),
  "calendar_view_day": SymbolsMetadata(
    popularity: 703,
    codepoint: 0xe936,
    categories: [12],
    tags: [
      5340,
      1015,
      5341,
      5377,
      5378,
      5374,
      5379,
      5380,
      5364,
      5381,
      1017,
      5382,
      5036,
      5383,
      5384,
      2094,
      1372,
      246,
      306,
      5347,
      5385,
      2107,
      75,
      1030,
      1031,
      5386,
      5387,
      441,
      5371,
      5351,
      317,
      5388,
      5372
    ],
  ),
  "calendar_view_month": SymbolsMetadata(
    popularity: 995,
    codepoint: 0xefe7,
    categories: [12],
    tags: [
      5340,
      1015,
      5341,
      5389,
      5342,
      5390,
      5378,
      1017,
      5345,
      5036,
      2094,
      1372,
      246,
      5391,
      306,
      2753,
      5347,
      5368,
      5392,
      940,
      2107,
      1030,
      1031,
      5393,
      32,
      944,
      289,
      5371,
      5351,
      317,
      5372
    ],
  ),
  "calendar_view_week": SymbolsMetadata(
    popularity: 750,
    codepoint: 0xefe8,
    categories: [12],
    tags: [
      5340,
      1015,
      5341,
      5378,
      802,
      1017,
      5036,
      1018,
      2094,
      1372,
      3860,
      246,
      306,
      92,
      5347,
      5385,
      2107,
      1030,
      1031,
      5393,
      5394,
      289,
      5395,
      5371,
      5351,
      2253,
      317,
      5372,
      5396,
      5397
    ],
  ),
  "call": SymbolsMetadata(
    popularity: 48041,
    codepoint: 0xe0b0,
    categories: [7],
    tags: [
      5398,
      5172,
      738,
      1133,
      5399,
      1113,
      443,
      5400,
      475,
      5401,
      3326,
      445,
      1308,
      1309,
      965,
      2527,
      5402,
      5403,
      5404,
      5405,
      219,
      226,
      5406,
      5407,
      1318,
      5408,
      1257,
      495,
      496,
      1320,
      5409,
      5410
    ],
  ),
  "call_end": SymbolsMetadata(
    popularity: 1816,
    codepoint: 0xe0b1,
    categories: [7],
    tags: [
      2827,
      5411,
      1133,
      5412,
      5413,
      5414,
      895,
      1113,
      443,
      475,
      476,
      2332,
      4441,
      445,
      3306,
      5415,
      2189,
      5416,
      3489,
      1309,
      5417,
      965,
      219,
      5418,
      226,
      5419,
      1318,
      4452,
      1083,
      496,
      438,
      1320,
      5420,
      5421
    ],
  ),
  "call_log": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xe08e,
    categories: [7],
    tags: [
      5422,
      1133,
      5423,
      5424,
      5425,
      5426,
      5427,
      1113,
      443,
      5428,
      475,
      5429,
      5430,
      445,
      5431,
      1309,
      965,
      1023,
      366,
      92,
      5127,
      788,
      5432,
      219,
      5433,
      226,
      5434,
      5435,
      5436,
      5437,
      1318,
      5438,
      1320,
      441
    ],
  ),
  "call_made": SymbolsMetadata(
    popularity: 1399,
    codepoint: 0xe0b2,
    categories: [7],
    tags: [
      378,
      380,
      1133,
      5439,
      776,
      1062,
      445,
      2969,
      388,
      787,
      1672,
      1471,
      777,
      3080,
      5440,
      219,
      421,
      780,
      2653,
      5441,
      5419,
      781,
      1396,
      2343,
      1665,
      1412,
      1214,
      346,
      2916
    ],
  ),
  "call_merge": SymbolsMetadata(
    popularity: 441,
    codepoint: 0xe0b3,
    categories: [7],
    tags: [
      1301,
      1302,
      380,
      419,
      3026,
      1133,
      5442,
      1061,
      443,
      1135,
      1306,
      921,
      5443,
      5444,
      445,
      5445,
      1064,
      1312,
      366,
      935,
      1067,
      219,
      5446,
      226,
      1320,
      441,
      5447,
      1701,
      1677,
      2916
    ],
  ),
  "call_missed": SymbolsMetadata(
    popularity: 354,
    codepoint: 0xe0b4,
    categories: [7],
    tags: [
      380,
      1133,
      5448,
      5449,
      1630,
      1632,
      443,
      475,
      4441,
      5450,
      445,
      2189,
      5416,
      5417,
      1023,
      5451,
      4445,
      5452,
      5127,
      3179,
      5453,
      219,
      226,
      5419,
      1029,
      4452,
      5454,
      1320,
      1647,
      5410
    ],
  ),
  "call_missed_outgoing": SymbolsMetadata(
    popularity: 384,
    codepoint: 0xe0e4,
    categories: [7],
    tags: [
      378,
      380,
      1133,
      5424,
      5425,
      5455,
      443,
      475,
      1062,
      4441,
      5456,
      445,
      1308,
      3306,
      5416,
      5417,
      3179,
      5453,
      5457,
      219,
      5458,
      4189,
      5441,
      226,
      5419,
      5438,
      5459,
      782,
      1320,
      1214,
      5460,
      915
    ],
  ),
  "call_quality": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xf652,
    categories: [7],
    tags: [
      5461,
      469,
      1245,
      738,
      1133,
      5462,
      1113,
      443,
      211,
      475,
      132,
      445,
      1309,
      965,
      482,
      5463,
      484,
      135,
      2769,
      219,
      223,
      486,
      226,
      5464,
      2772,
      62,
      1318,
      2631,
      227,
      553,
      495,
      1320,
      5465,
      5466,
      1261
    ],
  ),
  "call_received": SymbolsMetadata(
    popularity: 931,
    codepoint: 0xe0b5,
    categories: [7],
    tags: [
      1627,
      5467,
      5172,
      5468,
      380,
      2650,
      1133,
      5469,
      443,
      921,
      475,
      445,
      1671,
      337,
      2924,
      5470,
      2863,
      2338,
      5471,
      219,
      226,
      5419,
      2070,
      2342,
      5472,
      5473,
      5474,
      1319,
      1320
    ],
  ),
  "call_split": SymbolsMetadata(
    popularity: 928,
    codepoint: 0xe0b6,
    categories: [7],
    tags: [
      380,
      2868,
      2052,
      419,
      1994,
      2446,
      1133,
      5475,
      5476,
      5477,
      5478,
      5479,
      443,
      1306,
      445,
      2173,
      3028,
      5480,
      1370,
      2450,
      2999,
      2000,
      219,
      226,
      5481,
      5482,
      2452,
      1503,
      2264,
      1378,
      1320,
      2007,
      2455
    ],
  ),
  "call_to_action": SymbolsMetadata(
    popularity: 582,
    codepoint: 0xe06c,
    categories: [0],
    tags: [
      949,
      469,
      1343,
      4873,
      298,
      1133,
      5483,
      1776,
      2896,
      954,
      2750,
      269,
      5484,
      299,
      2983,
      787,
      1598,
      484,
      135,
      966,
      5485,
      2751,
      306,
      788,
      485,
      421,
      486,
      907,
      909,
      281,
      4988,
      5486,
      75,
      77,
      330,
      288,
      2882,
      4789,
      372,
      32,
      1412,
      313,
      1689,
      314,
      2757,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "camera": SymbolsMetadata(
    popularity: 2698,
    codepoint: 0xe3af,
    categories: [1],
    tags: [
      5487,
      5488,
      47,
      116,
      383,
      384,
      270,
      53,
      126,
      367,
      59,
      61,
      119,
      1662,
      121,
      5489,
      177,
      5490,
      4424,
      5491,
      5492,
      5493,
      5494,
      1701,
      5495,
      41,
      5496,
      352
    ],
  ),
  "camera_front": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xe3b1,
    categories: [1],
    tags: [
      380,
      584,
      47,
      5497,
      116,
      1731,
      383,
      1135,
      445,
      388,
      5498,
      5499,
      777,
      5500,
      5501,
      483,
      966,
      126,
      1145,
      219,
      5502,
      489,
      226,
      61,
      854,
      5503,
      490,
      121,
      396,
      5504,
      2813,
      1665,
      31,
      32,
      313,
      5505,
      314,
      2007,
      346,
      501,
      5506,
      41,
      1160
    ],
  ),
  "camera_indoor": SymbolsMetadata(
    popularity: 403,
    codepoint: 0xefe9,
    categories: [8],
    tags: [
      2601,
      798,
      5507,
      47,
      5508,
      350,
      2605,
      270,
      5509,
      999,
      5510,
      5511,
      5512,
      1435,
      5513,
      53,
      2793,
      5514,
      2795,
      2796,
      5515,
      5516,
      327,
      420,
      1004,
      119,
      1495,
      2614,
      177,
      1446,
      2616,
      1960,
      1011,
      5517,
      2617,
      1901,
      2057,
      351,
      5518,
      41,
      5519,
      5520,
      5521,
      352
    ],
  ),
  "camera_outdoor": SymbolsMetadata(
    popularity: 317,
    codepoint: 0xefea,
    categories: [8],
    tags: [
      2601,
      798,
      47,
      5522,
      350,
      2605,
      270,
      5509,
      999,
      5511,
      5512,
      1435,
      5513,
      53,
      327,
      420,
      1004,
      1860,
      5523,
      3841,
      119,
      1495,
      1444,
      5524,
      1519,
      2614,
      121,
      177,
      5525,
      1446,
      2616,
      602,
      1011,
      5517,
      2617,
      5526,
      1901,
      351,
      41,
      5527,
      5520,
      5521,
      2102
    ],
  ),
  "camera_rear": SymbolsMetadata(
    popularity: 158,
    codepoint: 0xe3b2,
    categories: [1],
    tags: [
      380,
      47,
      5528,
      116,
      383,
      3456,
      445,
      388,
      832,
      1672,
      5500,
      2811,
      966,
      126,
      367,
      219,
      5502,
      1675,
      1719,
      226,
      59,
      61,
      119,
      854,
      5529,
      5530,
      177,
      782,
      2813,
      2343,
      1665,
      32,
      2007,
      346,
      41,
      5531
    ],
  ),
  "camera_roll": SymbolsMetadata(
    popularity: 443,
    codepoint: 0xe3b3,
    categories: [1],
    tags: [
      5532,
      264,
      2151,
      47,
      5533,
      116,
      267,
      5534,
      270,
      5535,
      5536,
      5537,
      276,
      1541,
      53,
      2159,
      367,
      5291,
      278,
      3696,
      59,
      61,
      5538,
      121,
      5539,
      5540,
      104,
      674,
      2369,
      41,
      703
    ],
  ),
  "camera_video": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xf7a6,
    categories: [11],
    tags: [
      355,
      5507,
      5488,
      47,
      116,
      383,
      5541,
      270,
      5509,
      965,
      53,
      5516,
      5542,
      420,
      278,
      5543,
      119,
      121,
      5544,
      4325,
      5545,
      5546,
      342,
      5547,
      41,
      5548,
      1160,
      5519,
      5549,
      1173,
      540,
      5550,
      5521,
      5551,
      352,
      5552
    ],
  ),
  "cameraswitch": SymbolsMetadata(
    popularity: 1098,
    codepoint: 0xefeb,
    categories: [4],
    tags: [
      419,
      5553,
      47,
      5497,
      5554,
      5555,
      5556,
      5557,
      116,
      1731,
      5558,
      383,
      385,
      5499,
      5559,
      5501,
      881,
      126,
      59,
      177,
      2881,
      396,
      5560,
      5561,
      5256,
      313,
      5505,
      314,
      41,
      1160,
      5519,
      1173,
      317,
      352
    ],
  ),
  "campaign": SymbolsMetadata(
    popularity: 10440,
    codepoint: 0xef49,
    categories: [15],
    tags: [
      5562,
      1037,
      469,
      1245,
      355,
      5563,
      1040,
      443,
      5564,
      1043,
      5565,
      5566,
      4674,
      5567,
      1045,
      4947,
      1147,
      2503,
      486,
      4948,
      5568,
      1050,
      5569,
      3857,
      1665,
      5570,
      5571,
      492,
      1157,
      496
    ],
  ),
  "camping": SymbolsMetadata(
    popularity: 769,
    codepoint: 0xf8a2,
    categories: [15],
    tags: [
      2599,
      989,
      2464,
      5572,
      3722,
      5573,
      1202,
      5574,
      5575,
      1659,
      3724,
      2018,
      16,
      366,
      2610,
      1859,
      5576,
      3727,
      3347,
      2617,
      105,
      35,
      5577,
      5578,
      2023,
      1504,
      5579,
      1701,
      2024,
      5580,
      5581,
      3736
    ],
  ),
  "cancel": SymbolsMetadata(
    popularity: 41042,
    codepoint: 0xe5c9,
    categories: [2],
    tags: [
      895,
      5582,
      383,
      3436,
      2950,
      5583,
      1202,
      5584,
      2200,
      896,
      4441,
      897,
      4721,
      1077,
      3615,
      2985,
      900,
      5585,
      3696,
      4145,
      907,
      4452,
      911,
      5586,
      1083,
      5587,
      5588,
      3736
    ],
  ),
  "cancel_presentation": SymbolsMetadata(
    popularity: 1185,
    codepoint: 0xe0e9,
    categories: [7],
    tags: [
      5589,
      895,
      5590,
      3531,
      3436,
      2950,
      1202,
      4441,
      897,
      445,
      3615,
      12,
      2189,
      2985,
      3448,
      3696,
      4145,
      5591,
      2400,
      5592,
      4451,
      4452,
      911,
      330,
      4789,
      2562,
      1083,
      5593,
      3265,
      1053,
      1054,
      3736
    ],
  ),
  "cancel_schedule_send": SymbolsMetadata(
    popularity: 580,
    codepoint: 0xea39,
    categories: [7],
    tags: [
      5589,
      469,
      1074,
      5341,
      895,
      383,
      3436,
      2950,
      1202,
      4441,
      897,
      1077,
      3615,
      2335,
      2094,
      3448,
      2340,
      485,
      4145,
      486,
      5594,
      4451,
      4452,
      1030,
      911,
      1031,
      2343,
      1665,
      1083,
      441,
      1701,
      2499,
      5595,
      5596,
      3736
    ],
  ),
  "candle": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf588,
    categories: [3],
    tags: [
      5300,
      5302,
      5597,
      5598,
      5307,
      5599,
      5150,
      5600,
      2332,
      4473,
      5601,
      5311,
      3489,
      5602,
      2018,
      5603,
      5604,
      3677,
      3680,
      5063,
      5605,
      5606,
      1959,
      5607,
      5608,
      4774,
      3966,
      5609,
      5610,
      5611,
      5612,
      3083,
      5613,
      5614
    ],
  ),
  "candlestick_chart": SymbolsMetadata(
    popularity: 686,
    codepoint: 0xead4,
    categories: [9],
    tags: [
      2513,
      5,
      584,
      7,
      5599,
      5615,
      920,
      2950,
      10,
      2847,
      924,
      808,
      5616,
      929,
      2471,
      933,
      815,
      4014,
      1291,
      5617,
      597,
      937,
      2653,
      1337,
      5618,
      75,
      33,
      5619,
      5620,
      947,
      5621,
      5622,
      2852,
      5623,
      1592,
      5624
    ],
  ),
  "cannabis": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf2f3,
    categories: [3],
    tags: [
      5625,
      5626,
      5627,
      5628,
      5629,
      5630,
      1752,
      5631,
      595,
      5632,
      5633,
      5634,
      5635,
      5636,
      5637,
      817,
      5638,
      1760,
      1859,
      1835,
      5639,
      5640,
      5641,
      5642,
      5643,
      5644,
      5645,
      1905
    ],
  ),
  "captive_portal": SymbolsMetadata(
    popularity: 194,
    codepoint: 0xf728,
    categories: [2],
    tags: [
      755,
      380,
      1039,
      5646,
      211,
      388,
      2909,
      1471,
      5647,
      5072,
      5648,
      5649,
      5091,
      966,
      215,
      5650,
      5651,
      1375,
      935,
      852,
      223,
      2972,
      819,
      2653,
      5652,
      5653,
      5654,
      2631,
      2913,
      346,
      1691,
      1053,
      233,
      234,
      4763,
      5655
    ],
  ),
  "capture": SymbolsMetadata(
    popularity: 80,
    codepoint: 0xf727,
    categories: [2],
    tags: [
      5656,
      1229,
      1230,
      993,
      349,
      116,
      1469,
      2750,
      5657,
      1707,
      5658,
      1347,
      274,
      4043,
      1673,
      5659,
      53,
      1542,
      2751,
      306,
      5660,
      1361,
      59,
      119,
      5661,
      1496,
      121,
      75,
      1008,
      1664,
      1723,
      330,
      5662,
      5663,
      5664,
      288,
      2882,
      673,
      5491,
      32,
      2757,
      2759,
      317,
      1691,
      1053,
      1054,
      5665
    ],
  ),
  "car_crash": SymbolsMetadata(
    popularity: 888,
    codepoint: 0xebf2,
    categories: [14],
    tags: [
      3466,
      469,
      738,
      1814,
      3467,
      3468,
      1815,
      5666,
      1816,
      383,
      5667,
      2765,
      3176,
      388,
      2482,
      2766,
      2767,
      3075,
      4649,
      5223,
      5668,
      2769,
      1490,
      1641,
      486,
      2772,
      2071,
      3474,
      1353,
      3475,
      602,
      2631,
      1930,
      1844,
      1261
    ],
  ),
  "car_defrost_left": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf344,
    categories: [14],
    tags: [
      707,
      380,
      1814,
      3467,
      1815,
      712,
      1914,
      716,
      269,
      5669,
      5670,
      5671,
      388,
      5672,
      5500,
      3076,
      5673,
      483,
      723,
      1375,
      366,
      1922,
      488,
      489,
      1926,
      2238,
      727,
      1844,
      730,
      3978,
      5674,
      1902,
      1054,
      5675
    ],
  ),
  "car_defrost_low_left": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf343,
    categories: [14],
    tags: [
      705,
      707,
      1846,
      380,
      1814,
      3467,
      1848,
      5676,
      1815,
      1912,
      712,
      716,
      269,
      5669,
      5670,
      5671,
      388,
      2651,
      5672,
      719,
      5500,
      3076,
      5673,
      483,
      723,
      1375,
      366,
      4014,
      1922,
      488,
      489,
      1926,
      35,
      727,
      1844,
      5677,
      730,
      3978,
      5674,
      1902,
      1054,
      5675
    ],
  ),
  "car_defrost_low_right": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf342,
    categories: [14],
    tags: [
      709,
      1846,
      380,
      1814,
      3467,
      5676,
      1815,
      5678,
      712,
      713,
      5669,
      5670,
      5671,
      388,
      2651,
      719,
      5679,
      3076,
      5673,
      483,
      723,
      4014,
      1922,
      488,
      489,
      1396,
      1926,
      727,
      1844,
      730,
      1054,
      5680,
      5675
    ],
  ),
  "car_defrost_mid_low_left": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf341,
    categories: [14],
    tags: [
      5681,
      1846,
      380,
      419,
      1814,
      3467,
      1815,
      713,
      1914,
      3234,
      718,
      2515,
      5669,
      5670,
      5671,
      924,
      388,
      5672,
      590,
      5500,
      3076,
      5673,
      483,
      723,
      16,
      1375,
      5682,
      4014,
      5683,
      1922,
      488,
      489,
      1926,
      35,
      1844,
      5677,
      5675
    ],
  ),
  "car_defrost_mid_right": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf340,
    categories: [14],
    tags: [
      707,
      380,
      1814,
      3467,
      1815,
      712,
      716,
      269,
      5669,
      5670,
      5671,
      388,
      5500,
      3076,
      5673,
      483,
      723,
      16,
      2179,
      1922,
      488,
      489,
      1396,
      1926,
      35,
      727,
      1844,
      5677,
      730,
      3978,
      5674,
      5680,
      5675
    ],
  ),
  "car_defrost_right": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf33f,
    categories: [14],
    tags: [
      707,
      1846,
      380,
      1814,
      3467,
      1848,
      1815,
      1912,
      712,
      1914,
      716,
      269,
      2079,
      5669,
      5670,
      5671,
      388,
      719,
      5500,
      3076,
      5673,
      483,
      723,
      366,
      1922,
      488,
      489,
      1396,
      1926,
      727,
      1844,
      730,
      3978,
      5674,
      1902,
      5675
    ],
  ),
  "car_fan_low_left": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf33e,
    categories: [14],
    tags: [
      705,
      1128,
      709,
      1846,
      380,
      1814,
      3467,
      1815,
      712,
      713,
      1914,
      717,
      388,
      2651,
      5672,
      719,
      5684,
      3076,
      483,
      723,
      1375,
      4014,
      1922,
      488,
      489,
      1496,
      1926,
      65,
      727,
      1844,
      730
    ],
  ),
  "car_fan_low_mid_left": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf33d,
    categories: [14],
    tags: [
      705,
      1128,
      5061,
      709,
      1846,
      380,
      1814,
      3467,
      1815,
      712,
      713,
      1914,
      269,
      717,
      718,
      2969,
      388,
      2651,
      719,
      3076,
      483,
      723,
      1375,
      4014,
      5683,
      1922,
      488,
      489,
      1496,
      1926,
      65,
      727,
      1844,
      730
    ],
  ),
  "car_fan_low_right": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf33c,
    categories: [14],
    tags: [
      705,
      1128,
      709,
      1846,
      380,
      1814,
      3467,
      1815,
      1912,
      712,
      713,
      1914,
      269,
      717,
      718,
      388,
      2651,
      719,
      3076,
      483,
      723,
      4014,
      1922,
      488,
      489,
      1396,
      1926,
      5685,
      310,
      727,
      1844,
      730
    ],
  ),
  "car_fan_mid_left": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf33b,
    categories: [14],
    tags: [
      705,
      1128,
      709,
      1846,
      380,
      1814,
      3467,
      5686,
      1815,
      712,
      1914,
      269,
      388,
      719,
      3076,
      483,
      723,
      1375,
      5687,
      5688,
      1922,
      488,
      489,
      1496,
      5689,
      1926,
      5685,
      65,
      772,
      1842,
      1930,
      1504,
      1844,
      730
    ],
  ),
  "car_fan_mid_low_right": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf33a,
    categories: [14],
    tags: [
      705,
      1128,
      5061,
      709,
      5681,
      5690,
      1846,
      380,
      1814,
      3467,
      5676,
      1815,
      712,
      713,
      1914,
      269,
      388,
      2840,
      719,
      3076,
      483,
      723,
      5691,
      5692,
      1922,
      488,
      489,
      5693,
      1926,
      65,
      727,
      1677,
      1844,
      730
    ],
  ),
  "car_fan_mid_right": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf339,
    categories: [14],
    tags: [
      705,
      1128,
      709,
      1846,
      380,
      1814,
      3467,
      1848,
      1815,
      1912,
      2348,
      712,
      1914,
      269,
      718,
      388,
      719,
      3076,
      5673,
      483,
      723,
      2179,
      1922,
      488,
      489,
      1396,
      1926,
      5685,
      727,
      1844,
      5677,
      730
    ],
  ),
  "car_fan_recirculate": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf338,
    categories: [14],
    tags: [
      705,
      707,
      5694,
      709,
      1846,
      380,
      1814,
      3467,
      5203,
      1815,
      5695,
      5696,
      712,
      1914,
      269,
      385,
      1890,
      719,
      3076,
      723,
      2795,
      4838,
      390,
      5697,
      5698,
      424,
      2367,
      727,
      1844,
      730
    ],
  ),
  "car_gear": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf337,
    categories: [14],
    tags: [
      1131,
      5699,
      5700,
      5701,
      1814,
      3467,
      1815,
      5702,
      5703,
      5704,
      5705,
      4174,
      4175,
      268,
      1735,
      1737,
      3471,
      3485,
      2770,
      5197,
      656,
      790,
      3474,
      2631,
      65,
      5706,
      533,
      1844,
      5707,
      5708,
      5709
    ],
  ),
  "car_lock": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf336,
    categories: [14],
    tags: [
      755,
      1244,
      5710,
      1131,
      1814,
      3467,
      1815,
      5711,
      5712,
      269,
      3471,
      5713,
      5714,
      2674,
      5715,
      4321,
      5716,
      1516,
      1517,
      1520,
      5717,
      602,
      1773,
      1011,
      1842,
      1930,
      1504,
      5718,
      1844,
      5719,
      5720
    ],
  ),
  "car_mirror_heat": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf335,
    categories: [14],
    tags: [
      1814,
      3467,
      1815,
      5721,
      3436,
      714,
      5722,
      269,
      5669,
      5670,
      5723,
      5671,
      5724,
      3076,
      5725,
      724,
      366,
      5726,
      5727,
      65,
      5728,
      5729,
      725,
      3967,
      727,
      1844,
      5024,
      3978,
      1902,
      5730,
      732
    ],
  ),
  "car_rental": SymbolsMetadata(
    popularity: 689,
    codepoint: 0xea55,
    categories: [16],
    tags: [
      755,
      1131,
      1814,
      1936,
      1815,
      5731,
      5732,
      5733,
      5734,
      1816,
      2064,
      2723,
      1597,
      5735,
      1581,
      968,
      2609,
      5736,
      2674,
      1490,
      5716,
      2070,
      5737,
      5738,
      2615,
      1924,
      2495,
      1930,
      1504,
      1591,
      5718,
      1844
    ],
  ),
  "car_repair": SymbolsMetadata(
    popularity: 510,
    codepoint: 0xea56,
    categories: [16],
    tags: [
      1131,
      5700,
      5701,
      1814,
      3467,
      3468,
      1815,
      5739,
      5702,
      5704,
      1816,
      5740,
      1737,
      5741,
      3471,
      5742,
      3472,
      2770,
      1490,
      5197,
      1194,
      3619,
      3474,
      2631,
      5743,
      1930,
      1844,
      5707,
      5708,
      5744
    ],
  ),
  "car_tag": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf4e3,
    categories: [14],
    tags: [
      1131,
      1814,
      3467,
      797,
      1618,
      1815,
      5745,
      5746,
      5747,
      5748,
      5749,
      5750,
      799,
      1816,
      1619,
      800,
      801,
      803,
      1327,
      805,
      806,
      5751,
      5752,
      807,
      2809,
      18,
      2609,
      21,
      818,
      2742,
      819,
      820,
      821,
      1337,
      840,
      5738,
      3898,
      3322,
      841,
      2824,
      2384,
      5753,
      1930,
      1504,
      463,
      1844
    ],
  ),
  "card_membership": SymbolsMetadata(
    popularity: 1973,
    codepoint: 0xe8f7,
    categories: [9],
    tags: [
      755,
      5754,
      6,
      5755,
      797,
      1670,
      799,
      5756,
      800,
      2719,
      801,
      803,
      1327,
      805,
      829,
      806,
      830,
      807,
      5757,
      5758,
      808,
      5759,
      5760,
      853,
      3118,
      818,
      819,
      820,
      821,
      5761,
      531,
      5762,
      75,
      5763,
      5764,
      2368,
      1664,
      5765,
      841,
      532,
      5766,
      5767,
      5768
    ],
  ),
  "card_travel": SymbolsMetadata(
    popularity: 864,
    codepoint: 0xe8f8,
    categories: [9],
    tags: [
      2014,
      3719,
      4743,
      797,
      5238,
      5769,
      799,
      5770,
      5771,
      800,
      801,
      803,
      2063,
      1327,
      805,
      806,
      2016,
      1484,
      807,
      808,
      3489,
      2018,
      1581,
      3726,
      3118,
      5772,
      818,
      819,
      1922,
      820,
      821,
      2585,
      75,
      4746,
      2023,
      1842,
      1930,
      1504,
      1591,
      2024,
      4607,
      5773
    ],
  ),
  "cardio_load": SymbolsMetadata(
    popularity: 66,
    codepoint: 0xf4b9,
    categories: [3],
    tags: [
      989,
      4766,
      5774,
      5775,
      4454,
      10,
      2925,
      5776,
      3578,
      2926,
      2927,
      5777,
      595,
      1753,
      4457,
      5778,
      5779,
      3569,
      5037,
      934,
      1560,
      3513,
      2568,
      4770,
      597,
      1757,
      937,
      327,
      5780,
      28,
      3570,
      5781,
      5782,
      5783,
      5784,
      4463,
      1905,
      3596
    ],
  ),
  "cardiology": SymbolsMetadata(
    popularity: 110,
    codepoint: 0xe09c,
    categories: [3],
    tags: [
      5774,
      5775,
      4454,
      5785,
      1749,
      1751,
      5786,
      5787,
      5788,
      2927,
      595,
      3863,
      1753,
      4457,
      5789,
      5779,
      3569,
      1754,
      5790,
      597,
      1757,
      1760,
      327,
      1762,
      3570,
      5298,
      5791,
      4463,
      4648,
      1905
    ],
  ),
  "cards": SymbolsMetadata(
    popularity: 111,
    codepoint: 0xe991,
    categories: [2],
    tags: [
      1229,
      5792,
      1230,
      2749,
      1367,
      5793,
      5124,
      5794,
      2155,
      2750,
      1042,
      2515,
      299,
      958,
      538,
      1541,
      246,
      930,
      2751,
      306,
      2159,
      219,
      5795,
      327,
      2557,
      656,
      98,
      4857,
      226,
      5796,
      330,
      3423,
      2882,
      944,
      5797,
      447,
      2757,
      2759,
      317,
      1691,
      1053,
      1054
    ],
  ),
  "cards_star": SymbolsMetadata(
    popularity: 96,
    codepoint: 0xf375,
    categories: [9],
    tags: [
      3575,
      1670,
      4731,
      799,
      5794,
      2155,
      5798,
      3578,
      4740,
      4800,
      1541,
      3019,
      5799,
      53,
      5800,
      1251,
      4965,
      1066,
      2557,
      59,
      5801,
      119,
      5802,
      2560,
      99,
      4760,
      3582,
      286,
      102,
      1664,
      5803,
      288,
      371,
      3586,
      107,
      1069,
      3264,
      4807
    ],
  ),
  "carpenter": SymbolsMetadata(
    popularity: 519,
    codepoint: 0xf1f8,
    categories: [16],
    tags: [
      4384,
      4864,
      5804,
      798,
      5805,
      5806,
      2832,
      5807,
      5808,
      5809,
      5810,
      5811,
      3489,
      5812,
      5813,
      5814,
      5815,
      2770,
      5816,
      3474,
      5817,
      5818,
      5819,
      5820,
      2537,
      5267,
      5821,
      5744
    ],
  ),
  "carry_on_bag": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xeb08,
    categories: [16],
    tags: [
      2013,
      2014,
      3719,
      4743,
      5822,
      3723,
      5823,
      2016,
      1917,
      3489,
      2018,
      1581,
      366,
      3726,
      909,
      5824,
      2585,
      75,
      5825,
      4746,
      2023,
      1842,
      1504,
      1591,
      1625,
      2024,
      773
    ],
  ),
  "carry_on_bag_checked": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xeb0b,
    categories: [16],
    tags: [
      1627,
      1907,
      1932,
      5826,
      1549,
      2480,
      3719,
      4743,
      5822,
      3723,
      5771,
      1630,
      5827,
      1632,
      383,
      1633,
      2481,
      1917,
      5828,
      3726,
      1643,
      909,
      5829,
      4330,
      288,
      4746,
      1647,
      1504,
      5830,
      1591,
      2385,
      1650
    ],
  ),
  "carry_on_bag_inactive": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xeb0a,
    categories: [16],
    tags: [
      1932,
      2013,
      3719,
      894,
      895,
      3723,
      5831,
      5771,
      383,
      3302,
      897,
      2969,
      767,
      898,
      1917,
      899,
      901,
      1602,
      3726,
      4145,
      907,
      909,
      4450,
      75,
      911,
      912,
      914,
      2126,
      4746,
      1504,
      915
    ],
  ),
  "carry_on_bag_question": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xeb09,
    categories: [16],
    tags: [
      4102,
      1907,
      2013,
      5832,
      738,
      3719,
      4743,
      5833,
      5834,
      3723,
      5831,
      5771,
      5835,
      5836,
      1917,
      5837,
      5828,
      482,
      484,
      135,
      3726,
      5838,
      5839,
      909,
      979,
      4104,
      4105,
      4746,
      495,
      35,
      1504,
      5840,
      5841,
      1591,
      1364
    ],
  ),
  "cases": SymbolsMetadata(
    popularity: 1146,
    codepoint: 0xe992,
    categories: [9],
    tags: [
      5842,
      3719,
      4743,
      5238,
      1284,
      5240,
      5241,
      5843,
      1269,
      1062,
      5243,
      1655,
      3489,
      3170,
      3759,
      1066,
      3726,
      936,
      1456,
      940,
      5245,
      5246,
      3156,
      5247,
      75,
      32,
      107,
      674,
      4746,
      3159,
      1459
    ],
  ),
  "casino": SymbolsMetadata(
    popularity: 1700,
    codepoint: 0xeb40,
    categories: [16],
    tags: [
      564,
      5844,
      5845,
      5846,
      5847,
      5848,
      5849,
      5850,
      408,
      5851,
      5852,
      956,
      3337,
      4709,
      5853,
      5854,
      5855,
      5856,
      697,
      5857,
      5015,
      5858,
      5859,
      2613,
      2162,
      5860,
      5861,
      3347,
      5862,
      5540,
      5863,
      32,
      5864,
      5865
    ],
  ),
  "cast": SymbolsMetadata(
    popularity: 1644,
    codepoint: 0xe307,
    categories: [11],
    tags: [
      1109,
      1110,
      2051,
      2053,
      1684,
      5866,
      921,
      211,
      1685,
      445,
      12,
      965,
      1114,
      1687,
      367,
      5867,
      5726,
      5868,
      327,
      1719,
      2400,
      3156,
      5869,
      330,
      5870,
      5871,
      1665,
      3058,
      227,
      5872,
      2057,
      342,
      343,
      344,
      1691,
      233,
      1054,
      234
    ],
  ),
  "cast_connected": SymbolsMetadata(
    popularity: 580,
    codepoint: 0xe308,
    categories: [11],
    tags: [
      1109,
      1110,
      2051,
      2827,
      1129,
      355,
      2053,
      1684,
      5866,
      921,
      922,
      211,
      1685,
      445,
      12,
      2996,
      965,
      1114,
      1687,
      367,
      5873,
      5868,
      327,
      223,
      1719,
      5869,
      1318,
      190,
      330,
      5874,
      5871,
      1665,
      227,
      5872,
      32,
      342,
      343,
      441,
      4309,
      344,
      41,
      1902,
      1691,
      233,
      1054,
      234
    ],
  ),
  "cast_for_education": SymbolsMetadata(
    popularity: 1338,
    codepoint: 0xefec,
    categories: [11],
    tags: [
      1109,
      1110,
      4703,
      2051,
      2053,
      1684,
      5875,
      921,
      1685,
      445,
      12,
      5876,
      3374,
      3153,
      5877,
      5878,
      965,
      1114,
      3375,
      5879,
      5880,
      1687,
      327,
      819,
      2400,
      3156,
      5717,
      3158,
      330,
      5871,
      1665,
      227,
      342,
      5881,
      343,
      5782,
      5882,
      344,
      5883,
      1691,
      5884,
      233,
      1054,
      234
    ],
  ),
  "cast_pause": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf5f0,
    categories: [11],
    tags: [
      1109,
      1110,
      2051,
      2827,
      355,
      2053,
      1684,
      5866,
      383,
      921,
      269,
      785,
      1685,
      445,
      12,
      965,
      1114,
      1687,
      367,
      5868,
      327,
      2081,
      223,
      1719,
      1082,
      2141,
      2400,
      5869,
      330,
      5871,
      1665,
      227,
      228,
      5872,
      1083,
      342,
      343,
      344,
      1214,
      41,
      1902,
      1691,
      233,
      1054,
      234
    ],
  ),
  "cast_warning": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf5ef,
    categories: [11],
    tags: [
      3175,
      1109,
      1110,
      2051,
      469,
      2827,
      3073,
      2053,
      5885,
      5886,
      5887,
      5888,
      5889,
      1693,
      1684,
      383,
      921,
      211,
      5102,
      5890,
      5891,
      3176,
      1685,
      445,
      12,
      2766,
      2767,
      3177,
      965,
      2471,
      1114,
      1251,
      2769,
      1687,
      1641,
      327,
      223,
      5117,
      5892,
      5893,
      486,
      2772,
      330,
      5871,
      227,
      5894,
      342,
      35,
      343,
      344,
      1261,
      1691,
      233,
      1054,
      234,
      5895,
      5896,
      5897
    ],
  ),
  "castle": SymbolsMetadata(
    popularity: 707,
    codepoint: 0xeab1,
    categories: [5],
    tags: [
      5898,
      2601,
      5899,
      798,
      5900,
      5901,
      2854,
      1484,
      5902,
      5903,
      5904,
      5905,
      5906,
      697,
      1023,
      5907,
      3343,
      1001,
      5908,
      5909,
      5910,
      1495,
      1520,
      5911,
      5912,
      1011,
      5913,
      2023,
      2620,
      1504,
      5914,
      5021
    ],
  ),
  "category": SymbolsMetadata(
    popularity: 9439,
    codepoint: 0xe574,
    categories: [6],
    tags: [
      5915,
      5916,
      5917,
      5918,
      5919,
      383,
      5920,
      2155,
      2750,
      1735,
      5921,
      959,
      304,
      930,
      932,
      2245,
      656,
      940,
      5922,
      329,
      1622,
      288,
      65,
      5923,
      106,
      32,
      945,
      5924,
      5925,
      1701,
      5926,
      5927
    ],
  ),
  "category_search": SymbolsMetadata(
    popularity: 110,
    codepoint: 0xf437,
    categories: [2],
    tags: [
      5928,
      5124,
      5917,
      5918,
      5919,
      2447,
      383,
      5929,
      2155,
      5930,
      5931,
      955,
      958,
      959,
      960,
      964,
      930,
      932,
      5932,
      2245,
      92,
      971,
      974,
      975,
      976,
      656,
      940,
      1622,
      5933,
      2493,
      980,
      1377,
      981,
      288,
      5923,
      106,
      32,
      945,
      5924,
      5934,
      1701
    ],
  ),
  "celebration": SymbolsMetadata(
    popularity: 5576,
    codepoint: 0xea65,
    categories: [6],
    tags: [
      3,
      989,
      5300,
      5302,
      4663,
      5935,
      5150,
      5936,
      5937,
      5938,
      5939,
      5940,
      1852,
      2094,
      5941,
      5942,
      2819,
      2018,
      5943,
      366,
      5944,
      487,
      5945,
      5946,
      5316,
      5947,
      2487,
      1701,
      5948
    ],
  ),
  "cell_merge": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xf82e,
    categories: [12],
    tags: [
      2169,
      380,
      419,
      1113,
      3639,
      802,
      1061,
      3086,
      921,
      3087,
      10,
      388,
      787,
      2175,
      246,
      930,
      2176,
      5949,
      4869,
      3092,
      1064,
      306,
      1375,
      935,
      1067,
      778,
      1396,
      1376,
      4917,
      3036,
      1379,
      1380,
      5950
    ],
  ),
  "cell_tower": SymbolsMetadata(
    popularity: 1811,
    codepoint: 0xebba,
    categories: [7],
    tags: [
      502,
      546,
      1180,
      355,
      5951,
      1113,
      5952,
      208,
      211,
      212,
      10,
      277,
      5091,
      215,
      507,
      219,
      223,
      2083,
      1318,
      508,
      2631,
      227,
      5953,
      438,
      439,
      2620,
      4309,
      5954,
      1902,
      233,
      234
    ],
  ),
  "cell_wifi": SymbolsMetadata(
    popularity: 416,
    codepoint: 0xe0ec,
    categories: [7],
    tags: [
      1180,
      1343,
      355,
      1113,
      4080,
      5952,
      208,
      5955,
      443,
      211,
      10,
      445,
      5091,
      215,
      432,
      219,
      433,
      221,
      223,
      226,
      508,
      5956,
      2631,
      227,
      5957,
      5953,
      2620,
      1701,
      233,
      234,
      235
    ],
  ),
  "center_focus_strong": SymbolsMetadata(
    popularity: 1381,
    codepoint: 0xe3b4,
    categories: [1],
    tags: [
      1725,
      5958,
      5959,
      2169,
      1775,
      1729,
      5960,
      47,
      1730,
      5961,
      2318,
      2200,
      2805,
      12,
      1738,
      53,
      126,
      5962,
      59,
      61,
      1363,
      3017,
      5963,
      1741,
      5964,
      330,
      5965,
      5966,
      36,
      1071,
      2814,
      986
    ],
  ),
  "center_focus_weak": SymbolsMetadata(
    popularity: 902,
    codepoint: 0xe3b5,
    categories: [1],
    tags: [
      5958,
      5959,
      2169,
      5967,
      5968,
      3909,
      47,
      1730,
      5969,
      2318,
      383,
      2391,
      2805,
      1738,
      5970,
      53,
      5971,
      126,
      5972,
      5962,
      59,
      61,
      1496,
      5973,
      177,
      5974,
      4560,
      36,
      1071,
      41,
      2814,
      5975,
      5976,
      986
    ],
  ),
  "chair": SymbolsMetadata(
    popularity: 2925,
    codepoint: 0xefed,
    categories: [8],
    tags: [
      2600,
      5977,
      1912,
      1914,
      5978,
      5979,
      5980,
      1964,
      5981,
      999,
      4219,
      2607,
      1435,
      4420,
      5982,
      5983,
      5984,
      5985,
      5986,
      5987,
      1361,
      508,
      1958,
      1925,
      1960,
      1926,
      5988,
      105,
      1961,
      5989,
      5990,
      5991
    ],
  ),
  "chair_alt": SymbolsMetadata(
    popularity: 600,
    codepoint: 0xefee,
    categories: [8],
    tags: [
      2599,
      5992,
      2600,
      5977,
      5993,
      2136,
      5994,
      1912,
      5995,
      1964,
      5981,
      999,
      2607,
      1435,
      4420,
      3802,
      5984,
      5985,
      5986,
      1456,
      508,
      1958,
      1925,
      1960,
      1926,
      5988,
      1961,
      5996,
      1380,
      5997,
      5991
    ],
  ),
  "chalet": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xe585,
    categories: [16],
    tags: [
      2599,
      2601,
      798,
      5203,
      5261,
      714,
      5204,
      2605,
      721,
      2018,
      999,
      1435,
      2608,
      724,
      5998,
      2610,
      1490,
      1544,
      5999,
      1495,
      1444,
      2614,
      2615,
      1446,
      2616,
      6000,
      5287,
      725,
      726,
      3846,
      727,
      5209,
      2024,
      731,
      732,
      6001,
      6002
    ],
  ),
  "change_circle": SymbolsMetadata(
    popularity: 5157,
    codepoint: 0xe2e7,
    categories: [2],
    tags: [
      2284,
      2891,
      419,
      1731,
      383,
      384,
      2490,
      385,
      388,
      2450,
      696,
      2627,
      390,
      1740,
      421,
      2492,
      424,
      425,
      2367,
      3662,
      426,
      2496,
      396,
      397,
      5256,
      313,
      1667,
      3529,
      2007,
      427,
      2455,
      2499,
      1260
    ],
  ),
  "change_history": SymbolsMetadata(
    popularity: 2949,
    codepoint: 0xe86b,
    categories: [6],
    tags: [
      989,
      6003,
      1731,
      6004,
      6005,
      3812,
      1694,
      5333,
      6006,
      1659,
      6007,
      6008,
      1023,
      5127,
      1740,
      2492,
      2496,
      6009,
      311,
      1700,
      290,
      6010,
      1701,
      2499,
      4310,
      6011,
      6012,
      6013
    ],
  ),
  "charger": SymbolsMetadata(
    popularity: 993,
    codepoint: 0xe2ae,
    categories: [4],
    tags: [
      5269,
      6014,
      3769,
      4164,
      4364,
      3773,
      5271,
      3774,
      383,
      445,
      4074,
      4112,
      4049,
      3779,
      4114,
      6015,
      4138,
      4094,
      4121,
      1004,
      4373,
      3782,
      4128,
      4132,
      6016,
      4377,
      889,
      4098,
      4655,
      4109
    ],
  ),
  "charging_station": SymbolsMetadata(
    popularity: 501,
    codepoint: 0xf19d,
    categories: [11],
    tags: [
      1109,
      1110,
      3769,
      4089,
      1113,
      3773,
      3774,
      6017,
      445,
      4074,
      4112,
      4049,
      3779,
      4114,
      6018,
      4043,
      965,
      1114,
      16,
      188,
      4093,
      4395,
      4094,
      219,
      6019,
      226,
      3782,
      6020,
      4377,
      75,
      77,
      3611,
      553,
      35,
      447,
      4098,
      4169,
      4109
    ],
  ),
  "chart_data": SymbolsMetadata(
    popularity: 268,
    codepoint: 0xe473,
    categories: [9],
    tags: [
      5,
      380,
      2052,
      7,
      1284,
      920,
      10,
      924,
      808,
      6021,
      929,
      196,
      595,
      530,
      1207,
      933,
      1602,
      6022,
      597,
      634,
      937,
      189,
      1213,
      28,
      1353,
      32,
      33,
      2487,
      947,
      2852,
      3858,
      1676,
      2916
    ],
  ),
  "chat": SymbolsMetadata(
    popularity: 18436,
    codepoint: 0xe0b7,
    categories: [7],
    tags: [
      1400,
      471,
      472,
      473,
      474,
      443,
      475,
      476,
      477,
      478,
      480,
      481,
      851,
      485,
      6023,
      2503,
      486,
      1410,
      1565,
      77,
      1121,
      492,
      493,
      494,
      495,
      496,
      38,
      441
    ],
  ),
  "chat_add_on": SymbolsMetadata(
    popularity: 562,
    codepoint: 0xf0f3,
    categories: [7],
    tags: [
      526,
      6024,
      6025,
      6026,
      1399,
      6027,
      472,
      473,
      693,
      476,
      1201,
      6028,
      1403,
      1064,
      6029,
      485,
      763,
      6030,
      1407,
      1408,
      6031,
      202,
      6032,
      1409,
      494,
      108,
      6033,
      496
    ],
  ),
  "chat_apps_script": SymbolsMetadata(
    popularity: 270,
    codepoint: 0xf0bd,
    categories: [7],
    tags: [
      2657,
      2148,
      2538,
      472,
      6034,
      6035,
      266,
      1776,
      2624,
      473,
      443,
      476,
      1781,
      1347,
      696,
      2738,
      966,
      6036,
      485,
      1533,
      1409,
      1410,
      3379,
      288,
      2343,
      1121,
      38,
      1536
    ],
  ),
  "chat_bubble": SymbolsMetadata(
    popularity: 10109,
    codepoint: 0xe0ca,
    categories: [7],
    tags: [
      1400,
      471,
      472,
      1401,
      473,
      6037,
      474,
      443,
      475,
      476,
      477,
      480,
      481,
      851,
      485,
      1406,
      486,
      1361,
      75,
      77,
      1121,
      492,
      493,
      494,
      32,
      495,
      496,
      38
    ],
  ),
  "chat_error": SymbolsMetadata(
    popularity: 62,
    codepoint: 0xf7ac,
    categories: [7],
    tags: [
      469,
      3073,
      471,
      895,
      6038,
      1693,
      472,
      1401,
      6039,
      6040,
      6041,
      6042,
      3436,
      2950,
      6043,
      473,
      474,
      6044,
      476,
      1202,
      3176,
      6045,
      6046,
      477,
      2766,
      6047,
      2985,
      6048,
      480,
      1251,
      2769,
      1641,
      485,
      6049,
      6050,
      6051,
      6052,
      4145,
      486,
      2772,
      911,
      6053,
      6054,
      1353,
      493,
      494,
      1083,
      35,
      1261,
      3736
    ],
  ),
  "chat_info": SymbolsMetadata(
    popularity: 119,
    codepoint: 0xf52b,
    categories: [7],
    tags: [
      6055,
      469,
      1245,
      738,
      471,
      472,
      1401,
      6056,
      6057,
      6058,
      6059,
      383,
      473,
      474,
      6060,
      6061,
      6062,
      132,
      477,
      480,
      3225,
      482,
      6063,
      5463,
      484,
      6064,
      135,
      6065,
      485,
      6066,
      6067,
      6068,
      6069,
      77,
      2631,
      493,
      494,
      495,
      496,
      6070
    ],
  ),
  "chat_paste_go": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf6bd,
    categories: [7],
    tags: [
      380,
      419,
      471,
      472,
      6071,
      6072,
      1750,
      473,
      474,
      443,
      476,
      1707,
      477,
      388,
      1578,
      1347,
      1672,
      480,
      777,
      2910,
      1542,
      485,
      421,
      6073,
      6074,
      1409,
      6075,
      1410,
      1411,
      1396,
      2343,
      6076,
      1665,
      6077,
      493,
      1412,
      38
    ],
  ),
  "chat_paste_go_2": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf3cb,
    categories: [7],
    tags: [
      380,
      419,
      471,
      472,
      6071,
      473,
      474,
      443,
      476,
      477,
      388,
      1578,
      1672,
      480,
      777,
      2910,
      966,
      485,
      421,
      1719,
      6073,
      6074,
      1409,
      6075,
      1410,
      1396,
      782,
      2343,
      6076,
      1665,
      6078,
      493,
      494,
      1412,
      6079,
      6080,
      3734,
      2007
    ],
  ),
  "check": SymbolsMetadata(
    popularity: 31008,
    codepoint: 0xe5ca,
    categories: [2],
    tags: [
      2866,
      1627,
      6081,
      1548,
      6082,
      1549,
      2480,
      1630,
      1632,
      1633,
      1635,
      1636,
      2481,
      2376,
      2872,
      1639,
      2909,
      1640,
      3065,
      1641,
      1643,
      4752,
      1213,
      288,
      4753,
      1412,
      6083,
      2487,
      6084,
      1647,
      6085,
      2385,
      2387,
      1650
    ],
  ),
  "check_box": SymbolsMetadata(
    popularity: 25575,
    codepoint: 0xe834,
    categories: [2],
    tags: [
      1627,
      1548,
      1549,
      2480,
      7,
      298,
      1630,
      4790,
      6086,
      6087,
      2447,
      1633,
      4866,
      1636,
      269,
      1639,
      1598,
      966,
      1641,
      1643,
      281,
      329,
      288,
      4753,
      371,
      65,
      32,
      1645,
      1647,
      6088,
      6085,
      314,
      2757,
      2387,
      1523,
      1650
    ],
  ),
  "check_box_outline_blank": SymbolsMetadata(
    popularity: 21894,
    codepoint: 0xe835,
    categories: [2],
    tags: [
      6089,
      349,
      7,
      298,
      1630,
      4790,
      6086,
      1631,
      1632,
      2447,
      4866,
      269,
      2448,
      2449,
      4721,
      6090,
      4013,
      6091,
      6092,
      1598,
      966,
      281,
      1361,
      3331,
      190,
      288,
      371,
      32,
      1645,
      1647,
      6093,
      6085,
      314,
      2757,
      6094,
      6095,
      6096
    ],
  ),
  "check_circle": SymbolsMetadata(
    popularity: 84256,
    codepoint: 0xe86c,
    categories: [2],
    tags: [
      1627,
      6081,
      1548,
      6082,
      1549,
      2480,
      1630,
      1632,
      383,
      1633,
      1635,
      4270,
      1636,
      4271,
      2376,
      1639,
      1641,
      1643,
      4752,
      1361,
      1213,
      1257,
      288,
      4753,
      2487,
      6097,
      1645,
      1647,
      6088,
      6085,
      2385,
      2386,
      2387,
      1523,
      1650
    ],
  ),
  "check_in_out": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf6f6,
    categories: [15],
    tags: [
      755,
      2014,
      6098,
      6099,
      3952,
      1630,
      6100,
      6101,
      6102,
      2016,
      6103,
      6104,
      1597,
      2985,
      6105,
      6106,
      4219,
      2607,
      3091,
      6107,
      2795,
      852,
      903,
      2398,
      3841,
      6108,
      1256,
      3964,
      2913,
      913,
      3966,
      313,
      1647,
      314
    ],
  ),
  "check_indeterminate_small": SymbolsMetadata(
    popularity: 707,
    codepoint: 0xf88a,
    categories: [2],
    tags: [
      1549,
      1343,
      1630,
      6086,
      383,
      1633,
      2448,
      1639,
      3065,
      1205,
      6109,
      6110,
      2659,
      6111,
      6112,
      6113,
      2568,
      1641,
      1116,
      6114,
      1643,
      281,
      1361,
      4130,
      2858,
      1048,
      6115,
      75,
      288,
      371,
      1979,
      6116,
      1647,
      314,
      6117,
      6095,
      6118,
      1364,
      2386,
      1523,
      1650
    ],
  ),
  "check_small": SymbolsMetadata(
    popularity: 1994,
    codepoint: 0xf88b,
    categories: [2],
    tags: [
      1627,
      6081,
      1548,
      2717,
      1549,
      2480,
      1630,
      1632,
      383,
      1633,
      1635,
      1636,
      2376,
      1639,
      1640,
      3065,
      1641,
      1643,
      4752,
      1361,
      1213,
      1396,
      288,
      4753,
      1979,
      2487,
      1645,
      1647,
      6085,
      2386,
      2387,
      1523,
      1650
    ],
  ),
  "checkbook": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xe70d,
    categories: [9],
    tags: [
      468,
      3313,
      794,
      795,
      796,
      1910,
      1284,
      1630,
      6119,
      6120,
      3274,
      1347,
      696,
      3318,
      808,
      1598,
      811,
      3320,
      6121,
      366,
      818,
      1532,
      820,
      821,
      2694,
      121,
      75,
      1256,
      6122,
      842,
      6123,
      1536
    ],
  ),
  "checked_bag": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xeb0c,
    categories: [16],
    tags: [
      6081,
      2013,
      2480,
      3719,
      4743,
      6124,
      1630,
      5827,
      1632,
      1633,
      2481,
      1639,
      1917,
      3489,
      2018,
      1581,
      1602,
      3726,
      1194,
      75,
      288,
      4753,
      32,
      4746,
      1647,
      1504,
      1591,
      2024
    ],
  ),
  "checked_bag_question": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xeb0d,
    categories: [16],
    tags: [
      1907,
      2013,
      738,
      3719,
      4743,
      6125,
      5238,
      1630,
      5827,
      1917,
      6126,
      482,
      135,
      2769,
      1581,
      6127,
      3726,
      2772,
      979,
      4104,
      4105,
      553,
      4746,
      495,
      1647,
      1504,
      6128,
      1591,
      1364
    ],
  ),
  "checklist": SymbolsMetadata(
    popularity: 7056,
    codepoint: 0xe6b1,
    categories: [12],
    tags: [
      3573,
      2167,
      2169,
      1230,
      1549,
      2514,
      1630,
      1631,
      1632,
      2447,
      1633,
      1636,
      1528,
      1347,
      1639,
      696,
      2299,
      1371,
      3154,
      1598,
      1372,
      2245,
      92,
      1641,
      1533,
      1643,
      656,
      3854,
      28,
      3157,
      288,
      4788,
      1379,
      109,
      1570,
      1645,
      3160,
      38,
      1647,
      6085,
      40,
      2386,
      2387,
      1523,
      2389,
      3855,
      704,
      1650
    ],
  ),
  "checklist_rtl": SymbolsMetadata(
    popularity: 2202,
    codepoint: 0xe6b3,
    categories: [12],
    tags: [
      1627,
      2716,
      2167,
      2169,
      2717,
      1549,
      1630,
      1631,
      1632,
      5125,
      1633,
      1635,
      1636,
      1528,
      1639,
      3108,
      696,
      2299,
      1371,
      1598,
      1372,
      2245,
      366,
      92,
      1641,
      1533,
      1643,
      656,
      6129,
      6130,
      6131,
      288,
      371,
      4788,
      1379,
      1570,
      1645,
      38,
      1647,
      6085,
      315,
      40,
      2386,
      2387,
      2388,
      1523,
      704,
      1650
    ],
  ),
  "checkroom": SymbolsMetadata(
    popularity: 1949,
    codepoint: 0xf19e,
    categories: [8],
    tags: [
      1940,
      2697,
      4743,
      6132,
      6133,
      3989,
      2701,
      6134,
      6135,
      6136,
      6137,
      3274,
      2705,
      2706,
      6138,
      6139,
      2527,
      2607,
      6140,
      3726,
      1296,
      2631,
      841,
      674,
      6141,
      1504,
      1701,
      2714
    ],
  ),
  "cheer": SymbolsMetadata(
    popularity: 94,
    codepoint: 0xf6a8,
    categories: [3],
    tags: [
      6142,
      6143,
      2717,
      1059,
      5935,
      5150,
      6144,
      6145,
      6146,
      6147,
      5939,
      5940,
      6148,
      6149,
      6150,
      6151,
      719,
      6152,
      6153,
      6154,
      6155,
      1557,
      5943,
      6156,
      6157,
      6158,
      6159,
      6160,
      495,
      6161,
      6162,
      6163,
      5948
    ],
  ),
  "chef_hat": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf357,
    categories: [3],
    tags: [
      6164,
      3787,
      6165,
      3793,
      6166,
      6167,
      3795,
      4388,
      6168,
      6169,
      6170,
      6171,
      3799,
      3800,
      1829,
      6172,
      6173,
      4392,
      4975,
      6174,
      6175,
      6176,
      3802,
      4398,
      3804,
      788,
      6177,
      6178,
      3807,
      6179,
      6180,
      6181
    ],
  ),
  "chess": SymbolsMetadata(
    popularity: 159,
    codepoint: 0xf5e7,
    categories: [3],
    tags: [
      3,
      3574,
      6182,
      6183,
      6184,
      3576,
      6185,
      6186,
      6187,
      6188,
      3337,
      697,
      6189,
      6190,
      3502,
      4220,
      3344,
      6191,
      778,
      5019,
      2107,
      2162,
      4226,
      101,
      6192,
      6193,
      6194,
      6195,
      6196,
      3588,
      3589
    ],
  ),
  "chess_pawn": SymbolsMetadata(
    popularity: 50,
    codepoint: 0xf3b6,
    categories: [3],
    tags: [
      4312,
      6197,
      6182,
      6183,
      6184,
      6185,
      6198,
      6186,
      383,
      6187,
      4410,
      697,
      6199,
      6189,
      16,
      390,
      3329,
      778,
      1361,
      6200,
      5019,
      2162,
      2904,
      889,
      6201,
      105,
      4325,
      6193,
      35,
      6202,
      6203
    ],
  ),
  "chevron_backward": SymbolsMetadata(
    popularity: 93,
    codepoint: 0xf46b,
    categories: [2],
    tags: [
      380,
      419,
      2489,
      2869,
      2870,
      6204,
      6205,
      2871,
      6206,
      2862,
      6207,
      388,
      2884,
      5499,
      2873,
      1023,
      2874,
      1375,
      2875,
      779,
      421,
      2876,
      2877,
      2878,
      2495,
      2881,
      2886,
      396,
      402,
      2499
    ],
  ),
  "chevron_forward": SymbolsMetadata(
    popularity: 159,
    codepoint: 0xf46a,
    categories: [2],
    tags: [
      775,
      378,
      2890,
      380,
      6208,
      419,
      2871,
      2862,
      6209,
      776,
      132,
      388,
      3101,
      787,
      6210,
      777,
      6211,
      789,
      778,
      779,
      421,
      780,
      2653,
      2162,
      781,
      28,
      1396,
      6212,
      2966
    ],
  ),
  "chevron_left": SymbolsMetadata(
    popularity: 20326,
    codepoint: 0xe5cb,
    categories: [2],
    tags: [
      2866,
      2890,
      380,
      419,
      2489,
      2869,
      2870,
      6205,
      2871,
      2862,
      269,
      388,
      2872,
      2884,
      5499,
      2873,
      188,
      2874,
      1375,
      778,
      779,
      421,
      1783,
      2876,
      2877,
      2878,
      2495,
      2881,
      2886,
      396,
      402,
      2499
    ],
  ),
  "chevron_right": SymbolsMetadata(
    popularity: 52065,
    codepoint: 0xe5cc,
    categories: [2],
    tags: [
      775,
      2963,
      380,
      419,
      2871,
      2862,
      776,
      132,
      388,
      787,
      777,
      339,
      188,
      789,
      778,
      779,
      421,
      780,
      6213,
      6214,
      2653,
      2162,
      781,
      28,
      1396,
      782,
      2899,
      4789,
      2571
    ],
  ),
  "child_care": SymbolsMetadata(
    popularity: 2439,
    codepoint: 0xeb41,
    categories: [8],
    tags: [
      3598,
      3599,
      4990,
      6215,
      3600,
      862,
      6216,
      3602,
      6217,
      865,
      383,
      6218,
      6219,
      479,
      867,
      6220,
      1558,
      1190,
      3606,
      870,
      871,
      6221,
      3609,
      4232,
      874,
      6222,
      876,
      6223,
      889,
      1567,
      3612,
      879
    ],
  ),
  "child_friendly": SymbolsMetadata(
    popularity: 578,
    codepoint: 0xeb42,
    categories: [16],
    tags: [
      734,
      3599,
      6224,
      6225,
      6226,
      6227,
      6228,
      3600,
      6229,
      862,
      6216,
      3602,
      865,
      867,
      6230,
      6231,
      3489,
      6232,
      3606,
      6233,
      870,
      6234,
      5003,
      3609,
      876,
      6235,
      6236,
      6237,
      3612,
      6238,
      4342,
      4345,
      879
    ],
  ),
  "chip_extraction": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf821,
    categories: [2],
    tags: [
      2827,
      380,
      419,
      5250,
      6239,
      3121,
      10,
      6240,
      6241,
      3064,
      3303,
      388,
      3306,
      6103,
      3016,
      6242,
      2985,
      6243,
      6105,
      6244,
      903,
      2653,
      2398,
      3068,
      911,
      2844,
      1396,
      782,
      2542,
      2343,
      913,
      2007,
      6245,
      6246,
      346
    ],
  ),
  "chips": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xe993,
    categories: [2],
    tags: [
      949,
      1229,
      1230,
      3351,
      1343,
      952,
      895,
      5250,
      5850,
      2896,
      2750,
      6247,
      2448,
      4441,
      2922,
      897,
      299,
      900,
      2176,
      1205,
      966,
      2751,
      306,
      6248,
      1602,
      2928,
      1116,
      219,
      327,
      3696,
      226,
      75,
      2930,
      911,
      77,
      78,
      330,
      3013,
      2882,
      32,
      1122,
      447,
      6249,
      4285,
      2757,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "chrome_reader_mode": SymbolsMetadata(
    popularity: 957,
    codepoint: 0xe86d,
    categories: [6],
    tags: [
      2501,
      1039,
      1684,
      6250,
      6251,
      802,
      1042,
      6252,
      6253,
      1347,
      4696,
      1738,
      306,
      6254,
      307,
      1534,
      1770,
      3421,
      2506,
      6255,
      3908,
      2507,
      6256,
      1378,
      6257,
      38,
      6258,
      4858,
      317,
      1241,
      1053
    ],
  ),
  "chromecast_2": SymbolsMetadata(
    popularity: 202,
    codepoint: 0xf17b,
    categories: [10],
    tags: [
      81,
      2051,
      1129,
      2053,
      5866,
      6259,
      383,
      921,
      211,
      445,
      12,
      6260,
      3337,
      1189,
      6261,
      965,
      5273,
      390,
      5867,
      278,
      2081,
      1004,
      2056,
      5871,
      1665,
      227,
      342,
      343,
      2085,
      344,
      41,
      234,
      2059
    ],
  ),
  "chromecast_device": SymbolsMetadata(
    popularity: 210,
    codepoint: 0xe83c,
    categories: [11],
    tags: [
      3210,
      2051,
      2053,
      5866,
      921,
      445,
      12,
      6260,
      3216,
      1711,
      3337,
      1189,
      6261,
      965,
      5273,
      999,
      1435,
      215,
      367,
      5867,
      327,
      1004,
      5869,
      1318,
      2056,
      5870,
      5871,
      1665,
      227,
      1155,
      342,
      6262,
      551,
      343,
      344,
      233,
      234,
      2059
    ],
  ),
  "chronic": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xebb2,
    categories: [2],
    tags: [
      1244,
      469,
      6263,
      1016,
      268,
      2349,
      269,
      385,
      1020,
      6264,
      277,
      595,
      1023,
      6265,
      6266,
      936,
      2363,
      656,
      6267,
      28,
      2366,
      1030,
      2367,
      3532,
      1031,
      6268,
      65,
      289,
      1033,
      947,
      2102
    ],
  ),
  "church": SymbolsMetadata(
    popularity: 1171,
    codepoint: 0xeaae,
    categories: [5],
    tags: [
      798,
      6269,
      6270,
      6271,
      6272,
      6273,
      6274,
      194,
      1202,
      6275,
      6276,
      6277,
      6278,
      6279,
      5604,
      3343,
      1001,
      6280,
      6281,
      6282,
      5606,
      5607,
      6283,
      2631,
      5609,
      6284,
      6285,
      1504,
      6286,
      5614
    ],
  ),
  "cinematic_blur": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf853,
    categories: [0],
    tags: [
      468,
      6287,
      6288,
      4530,
      2053,
      267,
      6289,
      3428,
      6290,
      6291,
      6292,
      6293,
      2567,
      270,
      6294,
      959,
      1738,
      6295,
      483,
      278,
      489,
      854,
      6296,
      490,
      121,
      177,
      6297,
      441,
      501,
      41,
      364
    ],
  ),
  "circle": SymbolsMetadata(
    popularity: 8373,
    codepoint: 0xef4a,
    categories: [1],
    tags: [
      3325,
      378,
      383,
      6298,
      385,
      6299,
      3327,
      4013,
      6300,
      6301,
      4043,
      304,
      3328,
      5023,
      6302,
      53,
      126,
      2568,
      390,
      4255,
      6303,
      6304,
      1361,
      392,
      59,
      61,
      119,
      1048,
      28,
      121,
      2367,
      1257,
      396,
      889,
      311,
      5082,
      35,
      6305,
      6306,
      375
    ],
  ),
  "circle_notifications": SymbolsMetadata(
    popularity: 2407,
    codepoint: 0xe994,
    categories: [6],
    tags: [
      1242,
      1244,
      469,
      6307,
      6308,
      1245,
      1246,
      6309,
      6310,
      1248,
      383,
      6311,
      1251,
      851,
      484,
      135,
      485,
      1408,
      486,
      1253,
      6312,
      1120,
      1254,
      1030,
      2663,
      1257,
      889,
      6313,
      227,
      1156,
      1260,
      4310,
      1261
    ],
  ),
  "circles": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xe7ea,
    categories: [6],
    tags: [
      3325,
      920,
      383,
      953,
      443,
      921,
      211,
      4248,
      924,
      1654,
      304,
      929,
      930,
      1064,
      935,
      390,
      1067,
      4255,
      223,
      423,
      6314,
      4916,
      1081,
      5652,
      396,
      397,
      6315,
      607,
      6316
    ],
  ),
  "circles_ext": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xe7ec,
    categories: [6],
    tags: [
      3325,
      1994,
      3026,
      953,
      6317,
      1732,
      921,
      211,
      6318,
      6319,
      924,
      2173,
      2210,
      2985,
      787,
      6320,
      2996,
      2628,
      1659,
      930,
      1064,
      6321,
      1067,
      6322,
      223,
      4846,
      3841,
      1786,
      1665,
      3058,
      374,
      1701,
      6323,
      2511,
      6316
    ],
  ),
  "clarify": SymbolsMetadata(
    popularity: 263,
    codepoint: 0xf0bf,
    categories: [12],
    tags: [
      6324,
      2501,
      6325,
      269,
      6326,
      132,
      12,
      1528,
      1347,
      2983,
      787,
      6327,
      958,
      1951,
      1530,
      6328,
      900,
      135,
      306,
      366,
      92,
      788,
      6329,
      789,
      421,
      2503,
      656,
      1534,
      1770,
      329,
      2948,
      77,
      65,
      2997,
      2993,
      32,
      6330,
      38,
      441,
      314,
      6331,
      704
    ],
  ),
  "clean_hands": SymbolsMetadata(
    popularity: 934,
    codepoint: 0xf21f,
    categories: [3],
    tags: [
      6332,
      1868,
      1871,
      4005,
      2414,
      6333,
      1500,
      4473,
      3990,
      6334,
      6335,
      2735,
      2738,
      2741,
      6336,
      595,
      3972,
      6337,
      1757,
      599,
      2071,
      3610,
      602,
      4007,
      6338,
      6339,
      6340,
      5193,
      4001,
      3986,
      2801
    ],
  ),
  "cleaning": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xe995,
    categories: [15],
    tags: [
      6341,
      1869,
      6342,
      6343,
      6344,
      1889,
      4005,
      6345,
      6346,
      6347,
      6348,
      1433,
      999,
      1436,
      6349,
      6350,
      3972,
      2798,
      2770,
      6351,
      6338,
      6352,
      1883,
      1884,
      6353,
      6354,
      6355,
      6356,
      4001,
      6357,
      6358,
      6359
    ],
  ),
  "cleaning_bucket": SymbolsMetadata(
    popularity: 392,
    codepoint: 0xf8b4,
    categories: [10],
    tags: [
      1868,
      5174,
      6360,
      6343,
      953,
      4005,
      6346,
      3435,
      1269,
      6361,
      999,
      6349,
      6350,
      3972,
      6362,
      3802,
      2770,
      6363,
      6351,
      6340,
      6353,
      6364,
      6365,
      6366,
      6354,
      6355,
      6367,
      6368,
      6369,
      4001,
      6357
    ],
  ),
  "cleaning_services": SymbolsMetadata(
    popularity: 1894,
    codepoint: 0xf0ff,
    categories: [5],
    tags: [
      6370,
      6343,
      1871,
      4005,
      6371,
      3435,
      3436,
      6372,
      1433,
      2432,
      6373,
      3489,
      1436,
      6349,
      3972,
      6362,
      2770,
      6374,
      75,
      911,
      77,
      6351,
      6375,
      2755,
      6353,
      6376,
      441,
      6354,
      2537,
      6377
    ],
  ),
  "clear_all": SymbolsMetadata(
    popularity: 2495,
    codepoint: 0xe0b8,
    categories: [2],
    tags: [
      2325,
      895,
      3436,
      6378,
      6379,
      6380,
      6381,
      6382,
      6383,
      897,
      6384,
      3615,
      1528,
      1347,
      3438,
      1372,
      2080,
      1066,
      366,
      92,
      788,
      763,
      656,
      424,
      911,
      6385,
      6386,
      426,
      3516,
      65,
      6387,
      6376,
      441
    ],
  ),
  "clear_day": SymbolsMetadata(
    popularity: 1602,
    codepoint: 0xf157,
    categories: [3],
    tags: [
      6388,
      1728,
      383,
      3436,
      6389,
      6390,
      712,
      5036,
      5046,
      6391,
      6392,
      6393,
      3076,
      999,
      3078,
      1857,
      2097,
      1004,
      3684,
      6394,
      4208,
      3686,
      4210,
      6395,
      6396,
      6397,
      3687,
      727,
      729,
      3978,
      731
    ],
  ),
  "climate_mini_split": SymbolsMetadata(
    popularity: 149,
    codepoint: 0xf8b5,
    categories: [10],
    tags: [
      705,
      708,
      709,
      5690,
      1846,
      798,
      712,
      713,
      716,
      717,
      718,
      1852,
      3076,
      5673,
      999,
      1435,
      723,
      2793,
      2068,
      6398,
      1456,
      75,
      1960,
      1378,
      6399,
      727,
      728,
      729,
      441,
      730,
      6400
    ],
  ),
  "clinical_notes": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xe09e,
    categories: [3],
    tags: [
      755,
      468,
      1015,
      584,
      1749,
      6401,
      6402,
      10,
      132,
      1528,
      1751,
      1347,
      696,
      1530,
      1598,
      595,
      1753,
      1754,
      483,
      135,
      92,
      1755,
      6403,
      1757,
      1532,
      1533,
      1761,
      1534,
      1535,
      1762,
      488,
      489,
      490,
      121,
      1353,
      78,
      6404,
      441,
      501,
      317,
      1536,
      704
    ],
  ),
  "clock_arrow_down": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf382,
    categories: [2],
    tags: [
      755,
      2151,
      380,
      1016,
      1018,
      2922,
      2651,
      337,
      6405,
      1020,
      2094,
      1023,
      5127,
      656,
      2841,
      329,
      1029,
      121,
      2930,
      1030,
      2844,
      1664,
      1031,
      65,
      1298,
      289,
      1033
    ],
  ),
  "clock_arrow_up": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf381,
    categories: [2],
    tags: [
      6406,
      469,
      380,
      2052,
      383,
      1016,
      6407,
      1018,
      1020,
      1022,
      777,
      6408,
      1023,
      1207,
      486,
      1409,
      28,
      2504,
      1027,
      1030,
      1031,
      2343,
      231,
      1412,
      289,
      6409,
      1033,
      1676,
      346
    ],
  ),
  "clock_loader_10": SymbolsMetadata(
    popularity: 170,
    codepoint: 0xf726,
    categories: [2],
    tags: [
      6410,
      920,
      383,
      384,
      6411,
      1016,
      2092,
      337,
      1020,
      3524,
      3513,
      6412,
      2568,
      6413,
      6414,
      4075,
      3055,
      28,
      3056,
      424,
      1257,
      396,
      397,
      4852,
      1667,
      3529,
      6415,
      289,
      1033,
      1260,
      346,
      2147,
      5997
    ],
  ),
  "clock_loader_20": SymbolsMetadata(
    popularity: 98,
    codepoint: 0xf725,
    categories: [2],
    tags: [
      4019,
      383,
      6411,
      1016,
      4270,
      2092,
      337,
      3524,
      3513,
      6412,
      2568,
      6413,
      6414,
      4075,
      3055,
      942,
      28,
      3056,
      5035,
      424,
      396,
      4852,
      553,
      1667,
      3529,
      289,
      1033,
      4129,
      1260,
      346,
      2147,
      5997
    ],
  ),
  "clock_loader_40": SymbolsMetadata(
    popularity: 184,
    codepoint: 0xf724,
    categories: [2],
    tags: [
      6416,
      6417,
      989,
      920,
      383,
      384,
      1016,
      2092,
      337,
      1020,
      929,
      188,
      3524,
      3513,
      6412,
      2568,
      6414,
      4075,
      6418,
      3055,
      6419,
      3949,
      28,
      5035,
      424,
      396,
      4852,
      553,
      1667,
      3529,
      289,
      1033,
      1260,
      346,
      2147,
      5997
    ],
  ),
  "clock_loader_60": SymbolsMetadata(
    popularity: 216,
    codepoint: 0xf723,
    categories: [2],
    tags: [
      568,
      383,
      1016,
      4270,
      2092,
      337,
      1020,
      6420,
      188,
      3524,
      3513,
      6412,
      2568,
      4130,
      6414,
      4075,
      3055,
      942,
      28,
      424,
      396,
      4852,
      572,
      6421,
      553,
      1667,
      3529,
      1645,
      289,
      1033,
      1260,
      346,
      2147,
      5997
    ],
  ),
  "clock_loader_80": SymbolsMetadata(
    popularity: 102,
    codepoint: 0xf722,
    categories: [2],
    tags: [
      4048,
      920,
      383,
      1016,
      2092,
      337,
      1020,
      4135,
      2659,
      3524,
      3513,
      6412,
      2568,
      4130,
      6414,
      4075,
      6418,
      3055,
      942,
      28,
      5035,
      424,
      396,
      4852,
      553,
      1667,
      3529,
      289,
      1033,
      1260,
      346,
      2147,
      5997
    ],
  ),
  "clock_loader_90": SymbolsMetadata(
    popularity: 104,
    codepoint: 0xf721,
    categories: [2],
    tags: [
      6422,
      6423,
      6424,
      383,
      1016,
      2092,
      337,
      1020,
      188,
      3524,
      3513,
      6412,
      2568,
      977,
      6414,
      4075,
      3055,
      942,
      28,
      5035,
      424,
      396,
      4852,
      553,
      1667,
      3529,
      1645,
      289,
      1033,
      1260,
      346,
      2147,
      5997
    ],
  ),
  "close": SymbolsMetadata(
    popularity: 135100,
    codepoint: 0xe5cd,
    categories: [2],
    tags: [
      6425,
      895,
      3436,
      2950,
      1202,
      5584,
      2200,
      4441,
      897,
      6426,
      6427,
      3615,
      2189,
      3438,
      6428,
      2985,
      900,
      6429,
      3696,
      4145,
      6430,
      6431,
      6432,
      4451,
      4452,
      911,
      1083,
      5593,
      6433,
      3736
    ],
  ),
  "close_fullscreen": SymbolsMetadata(
    popularity: 4397,
    codepoint: 0xf1cf,
    categories: [2],
    tags: [
      949,
      380,
      6434,
      419,
      2950,
      6435,
      2896,
      3086,
      2919,
      6436,
      6437,
      6438,
      6439,
      388,
      6440,
      3089,
      6441,
      4043,
      1673,
      3090,
      3092,
      6442,
      2928,
      6443,
      3010,
      6444,
      6445,
      6446,
      2930,
      3749,
      330,
      2933,
      6447,
      6448,
      1054
    ],
  ),
  "close_small": SymbolsMetadata(
    popularity: 177,
    codepoint: 0xf508,
    categories: [2],
    tags: [
      895,
      3436,
      2950,
      5583,
      6449,
      6450,
      6451,
      1202,
      4441,
      897,
      1077,
      6427,
      3615,
      6452,
      2189,
      3438,
      2985,
      900,
      6453,
      3696,
      907,
      4451,
      4452,
      911,
      6454,
      1979,
      6455,
      1083,
      5593,
      3736
    ],
  ),
  "closed_caption": SymbolsMetadata(
    popularity: 1319,
    codepoint: 0xe01c,
    categories: [0],
    tags: [
      733,
      6456,
      734,
      4,
      6457,
      6458,
      6459,
      6460,
      6461,
      8,
      4430,
      6462,
      6463,
      6464,
      6465,
      6466,
      14,
      5651,
      19,
      367,
      6467,
      326,
      3541,
      6468,
      6469,
      32,
      6470,
      6471,
      35,
      38,
      6080,
      6472,
      6473,
      344,
      6474,
      40,
      702,
      6475,
      291,
      292
    ],
  ),
  "closed_caption_add": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf4ae,
    categories: [0],
    tags: [
      192,
      733,
      734,
      951,
      526,
      6476,
      4,
      7,
      6458,
      6460,
      6461,
      8,
      4430,
      6462,
      6463,
      1733,
      1201,
      6464,
      2855,
      6477,
      14,
      1044,
      5651,
      19,
      367,
      3541,
      763,
      1211,
      656,
      2904,
      202,
      1212,
      65,
      32,
      6470,
      6471,
      35,
      38,
      6478,
      344,
      2788,
      40,
      41
    ],
  ),
  "closed_caption_disabled": SymbolsMetadata(
    popularity: 315,
    codepoint: 0xf1dc,
    categories: [0],
    tags: [
      733,
      734,
      4,
      1129,
      6458,
      6460,
      6461,
      6479,
      8,
      4430,
      6462,
      6463,
      6464,
      3304,
      767,
      898,
      14,
      899,
      5651,
      19,
      367,
      3541,
      1164,
      6480,
      6481,
      907,
      909,
      283,
      3514,
      75,
      1170,
      914,
      6469,
      32,
      2126,
      6470,
      6471,
      35,
      38,
      344,
      40,
      915,
      41
    ],
  ),
  "cloud": SymbolsMetadata(
    popularity: 6814,
    codepoint: 0xe2bd,
    categories: [12],
    tags: [
      1847,
      5290,
      712,
      1652,
      3739,
      6482,
      211,
      6483,
      3744,
      337,
      6393,
      215,
      1857,
      223,
      6484,
      819,
      6485,
      2858,
      3949,
      100,
      3761,
      5027,
      553,
      674,
      6486,
      1667,
      727,
      346,
      731
    ],
  ),
  "cloud_alert": SymbolsMetadata(
    popularity: 67,
    codepoint: 0xf3cc,
    categories: [12],
    tags: [
      3175,
      469,
      3073,
      1693,
      712,
      1652,
      6487,
      3739,
      6488,
      6489,
      6490,
      6491,
      6492,
      6493,
      211,
      3176,
      6494,
      6495,
      2766,
      2767,
      3177,
      3075,
      2471,
      1251,
      215,
      2769,
      1641,
      223,
      6496,
      6497,
      486,
      3747,
      2772,
      100,
      6498,
      6499,
      5027,
      553,
      35,
      727,
      346,
      1261,
      731
    ],
  ),
  "cloud_circle": SymbolsMetadata(
    popularity: 581,
    codepoint: 0xe2be,
    categories: [12],
    tags: [
      1229,
      1230,
      1847,
      1651,
      383,
      6500,
      712,
      1652,
      3739,
      6501,
      6502,
      3740,
      6503,
      6504,
      3741,
      6505,
      211,
      212,
      6506,
      3744,
      6507,
      3756,
      337,
      1654,
      1655,
      1657,
      6393,
      215,
      223,
      6508,
      3747,
      3761,
      5027,
      674,
      1667,
      3529,
      346,
      731
    ],
  ),
  "cloud_done": SymbolsMetadata(
    popularity: 2012,
    codepoint: 0xe2bf,
    categories: [12],
    tags: [
      1229,
      1230,
      1549,
      1651,
      1630,
      1632,
      1652,
      6509,
      6510,
      3739,
      3741,
      6511,
      6512,
      1633,
      6513,
      6514,
      211,
      10,
      1639,
      337,
      1654,
      1655,
      3065,
      1657,
      215,
      1641,
      223,
      1643,
      1664,
      4273,
      288,
      3761,
      5027,
      674,
      2487,
      6515,
      6516,
      1667,
      6517,
      1647,
      2007,
      346,
      2386,
      1523,
      1650
    ],
  ),
  "cloud_download": SymbolsMetadata(
    popularity: 3948,
    codepoint: 0xe2c0,
    categories: [12],
    tags: [
      1229,
      1230,
      380,
      2650,
      1651,
      1652,
      3739,
      6518,
      3740,
      6504,
      3741,
      6505,
      211,
      6507,
      3050,
      2651,
      337,
      2897,
      6519,
      1654,
      3052,
      1655,
      1657,
      2652,
      1542,
      215,
      223,
      3747,
      3001,
      3749,
      2844,
      6520,
      1664,
      5027,
      674,
      1667,
      3529,
      441,
      2007,
      346,
      6521
    ],
  ),
  "cloud_lock": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf386,
    categories: [12],
    tags: [
      6522,
      712,
      1652,
      6523,
      3739,
      6501,
      6524,
      6525,
      6504,
      3741,
      3242,
      211,
      6526,
      3244,
      3245,
      6527,
      215,
      6528,
      2674,
      5715,
      223,
      6529,
      6530,
      6531,
      5716,
      1516,
      1517,
      6532,
      1520,
      100,
      6533,
      1772,
      602,
      1773,
      6534,
      1011,
      5027,
      727,
      346,
      731
    ],
  ),
  "cloud_off": SymbolsMetadata(
    popularity: 1574,
    codepoint: 0xe2c1,
    categories: [12],
    tags: [
      1229,
      1230,
      1651,
      1652,
      3739,
      6535,
      6536,
      6537,
      6538,
      6539,
      3741,
      211,
      4501,
      6540,
      1077,
      767,
      3306,
      2037,
      6541,
      1654,
      898,
      1655,
      1657,
      215,
      6542,
      223,
      6543,
      2043,
      6544,
      6545,
      907,
      908,
      909,
      911,
      6546,
      5027,
      914,
      674,
      4509,
      346,
      6547,
      2049
    ],
  ),
  "cloud_sync": SymbolsMetadata(
    popularity: 2021,
    codepoint: 0xeb5a,
    categories: [12],
    tags: [
      1229,
      1230,
      2284,
      419,
      1651,
      6548,
      1652,
      3738,
      3739,
      6518,
      3741,
      1653,
      211,
      212,
      3121,
      385,
      3742,
      6507,
      3050,
      337,
      1654,
      3052,
      1655,
      1657,
      3524,
      215,
      3513,
      3525,
      390,
      223,
      3747,
      424,
      2494,
      2367,
      3749,
      396,
      5027,
      674,
      1667,
      2007,
      402,
      2455,
      346
    ],
  ),
  "cloud_upload": SymbolsMetadata(
    popularity: 6349,
    codepoint: 0xe2c3,
    categories: [12],
    tags: [
      1229,
      1230,
      380,
      1651,
      1652,
      3739,
      3740,
      3741,
      1653,
      211,
      10,
      3742,
      6549,
      3050,
      6550,
      1347,
      337,
      1654,
      1530,
      3052,
      6551,
      1655,
      1657,
      1542,
      215,
      223,
      3747,
      1664,
      6552,
      1665,
      3058,
      5027,
      674,
      1667,
      3529,
      2007,
      1676,
      1677,
      346,
      6553,
      6521
    ],
  ),
  "co2": SymbolsMetadata(
    popularity: 1065,
    codepoint: 0xe7b0,
    categories: [3],
    tags: [
      6554,
      1847,
      6555,
      6556,
      6557,
      6558,
      712,
      6559,
      6560,
      6561,
      6562,
      6563,
      6564,
      6565,
      6566,
      6567,
      1890,
      3925,
      1854,
      6568,
      6569,
      6570,
      4359,
      2785,
      6571,
      2424,
      2370
    ],
  ),
  "co_present": SymbolsMetadata(
    popularity: 1989,
    codepoint: 0xeaf0,
    categories: [7],
    tags: [
      380,
      355,
      5875,
      6572,
      443,
      1135,
      12,
      3153,
      5879,
      1145,
      5543,
      489,
      5591,
      2400,
      6573,
      2055,
      5717,
      1353,
      330,
      6574,
      1665,
      6575,
      2882,
      6576,
      2562,
      1172,
      5881,
      6577,
      5782,
      1160,
      1173,
      1691,
      5884,
      1053,
      6578,
      6579
    ],
  ),
  "code": SymbolsMetadata(
    popularity: 8756,
    codepoint: 0xe86f,
    categories: [6],
    tags: [
      3105,
      380,
      419,
      3909,
      3592,
      2624,
      6580,
      6581,
      2896,
      954,
      6582,
      6583,
      1186,
      2625,
      1187,
      6584,
      2835,
      787,
      339,
      6585,
      6586,
      6587,
      6588,
      421,
      780,
      1194,
      2876,
      2630,
      6589,
      3379,
      6590,
      1196,
      6591,
      6592,
      2229
    ],
  ),
  "code_blocks": SymbolsMetadata(
    popularity: 653,
    codepoint: 0xf84d,
    categories: [6],
    tags: [
      1074,
      918,
      3909,
      3592,
      2624,
      6593,
      6580,
      6594,
      6595,
      6581,
      954,
      3233,
      6582,
      6583,
      1186,
      6596,
      2625,
      6597,
      6584,
      2835,
      6585,
      6598,
      6587,
      1194,
      2630,
      6589,
      3379,
      6590,
      1196,
      6591,
      6592,
      4087,
      2229
    ],
  ),
  "code_off": SymbolsMetadata(
    popularity: 643,
    codepoint: 0xe4f3,
    categories: [6],
    tags: [
      1074,
      3909,
      895,
      2950,
      2624,
      6599,
      6600,
      6582,
      896,
      897,
      6583,
      1186,
      2625,
      2969,
      1077,
      767,
      898,
      2189,
      6584,
      2835,
      2985,
      900,
      6585,
      901,
      1602,
      6601,
      907,
      909,
      1194,
      6602,
      2630,
      911,
      914,
      1196,
      1083,
      2126,
      6603,
      5587
    ],
  ),
  "coffee": SymbolsMetadata(
    popularity: 2624,
    codepoint: 0xefef,
    categories: [8],
    tags: [
      1343,
      4383,
      2136,
      6604,
      3790,
      3792,
      6605,
      6606,
      6607,
      6608,
      6609,
      4390,
      6610,
      5154,
      4219,
      6611,
      2607,
      6612,
      788,
      6613,
      2097,
      6614,
      1456,
      96,
      6615,
      1959,
      3807,
      6616,
      6617,
      1504,
      1459
    ],
  ),
  "coffee_maker": SymbolsMetadata(
    popularity: 821,
    codepoint: 0xeff0,
    categories: [8],
    tags: [
      1888,
      6618,
      4383,
      6619,
      3790,
      6620,
      6621,
      3792,
      6605,
      6622,
      6607,
      6623,
      6624,
      6625,
      6609,
      4390,
      6626,
      959,
      999,
      6611,
      2607,
      16,
      3802,
      1717,
      6627,
      2097,
      6614,
      1456,
      5639,
      6628,
      3807,
      35
    ],
  ),
  "cognition": SymbolsMetadata(
    popularity: 510,
    codepoint: 0xe09f,
    categories: [3],
    tags: [
      3325,
      2513,
      4944,
      584,
      6629,
      6630,
      5164,
      2332,
      1190,
      595,
      483,
      3944,
      6631,
      6632,
      3945,
      3502,
      4688,
      3375,
      6191,
      5291,
      6633,
      6634,
      6635,
      488,
      6636,
      489,
      6637,
      490,
      6638,
      6639,
      2463,
      6640,
      6641,
      6642,
      6643,
      6644
    ],
  ),
  "cognition_2": SymbolsMetadata(
    popularity: 153,
    codepoint: 0xf3b5,
    categories: [3],
    tags: [
      3325,
      4944,
      584,
      6629,
      6645,
      6630,
      6646,
      6647,
      1190,
      595,
      483,
      3944,
      6631,
      3945,
      6648,
      3502,
      4688,
      3375,
      5291,
      6633,
      6635,
      6649,
      6650,
      1361,
      488,
      6636,
      489,
      942,
      490,
      6638,
      6641,
      6642,
      6643,
      6644
    ],
  ),
  "collapse_all": SymbolsMetadata(
    popularity: 374,
    codepoint: 0xe944,
    categories: [2],
    tags: [
      2325,
      380,
      419,
      2871,
      6651,
      1113,
      2862,
      3592,
      2950,
      2896,
      6652,
      6653,
      3086,
      6247,
      2919,
      1578,
      2450,
      6654,
      3593,
      2840,
      787,
      900,
      6655,
      92,
      788,
      2928,
      6656,
      421,
      2930,
      1377,
      2933,
      6657,
      1677
    ],
  ),
  "collapse_content": SymbolsMetadata(
    popularity: 269,
    codepoint: 0xf507,
    categories: [2],
    tags: [
      6658,
      380,
      419,
      2862,
      2950,
      2896,
      6659,
      6653,
      3086,
      6660,
      6661,
      2919,
      1062,
      388,
      6662,
      2651,
      2941,
      787,
      6663,
      6664,
      6665,
      900,
      6666,
      3759,
      92,
      2928,
      6667,
      789,
      421,
      2653,
      1770,
      2930,
      3046,
      1377,
      2933,
      6668,
      3100,
      6669
    ],
  ),
  "collections_bookmark": SymbolsMetadata(
    popularity: 3118,
    codepoint: 0xe431,
    categories: [6],
    tags: [
      1266,
      4764,
      6670,
      1538,
      2151,
      1670,
      2155,
      5798,
      6671,
      1347,
      5243,
      3578,
      4740,
      1541,
      930,
      931,
      18,
      4723,
      1066,
      2159,
      2557,
      98,
      100,
      2506,
      6672,
      2507,
      4735,
      4272,
      2368,
      1664,
      4273,
      107,
      1069,
      674,
      1298,
      1070,
      4809,
      2384,
      4778
    ],
  ),
  "colorize": SymbolsMetadata(
    popularity: 1187,
    codepoint: 0xe3b8,
    categories: [1],
    tags: [
      1128,
      2829,
      266,
      4850,
      6673,
      6674,
      6675,
      3457,
      6676,
      299,
      5165,
      2834,
      6677,
      696,
      2299,
      6243,
      6300,
      6678,
      2279,
      305,
      53,
      2836,
      1740,
      5167,
      59,
      3022,
      6679,
      6680,
      288,
      2182,
      2537
    ],
  ),
  "colors": SymbolsMetadata(
    popularity: 150,
    codepoint: 0xe997,
    categories: [12],
    tags: [
      1128,
      2829,
      6360,
      4850,
      6681,
      6682,
      1269,
      5164,
      6676,
      299,
      1528,
      302,
      1500,
      4473,
      6683,
      696,
      2299,
      1371,
      2279,
      6684,
      3145,
      2725,
      2798,
      656,
      5167,
      5170,
      6685,
      65,
      4788,
      6686,
      1379,
      32,
      2182,
      38,
      441,
      2537,
      1701,
      40,
      704
    ],
  ),
  "combine_columns": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf420,
    categories: [12],
    tags: [
      192,
      526,
      1058,
      1368,
      6687,
      802,
      1061,
      6688,
      921,
      3087,
      1202,
      10,
      299,
      1347,
      696,
      2299,
      1372,
      246,
      930,
      1064,
      6689,
      306,
      935,
      1067,
      6690,
      1211,
      940,
      202,
      1376,
      1379,
      945,
      35,
      1380,
      38,
      441,
      4858,
      5950,
      1381,
      317,
      1053
    ],
  ),
  "comedy_mask": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xf4d6,
    categories: [3],
    tags: [
      6691,
      6287,
      6288,
      3332,
      6692,
      6693,
      3336,
      6694,
      6695,
      6696,
      6697,
      1552,
      3337,
      6698,
      2094,
      6699,
      479,
      6700,
      1558,
      6701,
      6702,
      6703,
      6704,
      278,
      3134,
      189,
      2613,
      2162,
      1516,
      1517,
      1519,
      1520,
      1011,
      2997,
      1567,
      6705,
      6706,
      3412,
      6707,
      6708,
      6709,
      2102
    ],
  ),
  "comic_bubble": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf5dd,
    categories: [3],
    tags: [
      469,
      264,
      6710,
      4663,
      6711,
      472,
      6696,
      6712,
      6713,
      6714,
      6715,
      473,
      443,
      476,
      477,
      478,
      480,
      481,
      6189,
      6716,
      3944,
      6717,
      6718,
      485,
      486,
      6719,
      6720,
      491,
      311,
      492,
      494,
      5058,
      496,
      38,
      6721
    ],
  ),
  "comment": SymbolsMetadata(
    popularity: 6616,
    codepoint: 0xe0b9,
    categories: [7],
    tags: [
      526,
      6025,
      1400,
      471,
      472,
      473,
      474,
      443,
      477,
      478,
      696,
      480,
      481,
      1044,
      6722,
      366,
      485,
      763,
      1407,
      1533,
      1361,
      1409,
      75,
      1410,
      492,
      493,
      494,
      496,
      38,
      441,
      1536
    ],
  ),
  "comment_bank": SymbolsMetadata(
    popularity: 508,
    codepoint: 0xea4e,
    categories: [7],
    tags: [
      2151,
      795,
      1670,
      471,
      6723,
      472,
      2155,
      473,
      6724,
      6725,
      474,
      443,
      476,
      477,
      6726,
      3578,
      480,
      6727,
      6728,
      6729,
      18,
      2159,
      485,
      1533,
      4272,
      1410,
      2843,
      1565,
      3184,
      2368,
      1664,
      6730,
      6731,
      6732,
      493,
      494,
      674,
      2384,
      496
    ],
  ),
  "comments_disabled": SymbolsMetadata(
    popularity: 474,
    codepoint: 0xe7a2,
    categories: [7],
    tags: [
      6733,
      471,
      6734,
      472,
      473,
      6735,
      6736,
      6737,
      6738,
      6739,
      6740,
      6741,
      474,
      6742,
      6743,
      4565,
      3304,
      6744,
      767,
      898,
      480,
      6745,
      6746,
      6747,
      485,
      6748,
      6749,
      6750,
      6751,
      907,
      908,
      909,
      2123,
      75,
      6752,
      6753,
      6754,
      6755,
      6756,
      914,
      493,
      6757,
      6758,
      32,
      441,
      6759
    ],
  ),
  "commit": SymbolsMetadata(
    popularity: 618,
    codepoint: 0xeaf5,
    categories: [6],
    tags: [
      6760,
      2687,
      6761,
      1730,
      1731,
      1630,
      6100,
      383,
      2624,
      6762,
      1633,
      1636,
      211,
      6763,
      3064,
      2625,
      1639,
      337,
      957,
      6764,
      6007,
      6008,
      2176,
      1064,
      1602,
      1067,
      1643,
      978,
      6765,
      2630,
      3012,
      121,
      3068,
      2843,
      1664,
      1196,
      1412,
      1667,
      3529,
      1260,
      346,
      6011
    ],
  ),
  "communication": SymbolsMetadata(
    popularity: 2188,
    codepoint: 0xe27c,
    categories: [3],
    tags: [
      1129,
      355,
      443,
      921,
      211,
      475,
      476,
      5255,
      478,
      480,
      930,
      483,
      6036,
      485,
      1004,
      223,
      488,
      489,
      1665,
      227,
      228,
      607,
      492,
      493,
      496,
      946,
      2007,
      5087,
      501,
      1161,
      233,
      234
    ],
  ),
  "communities": SymbolsMetadata(
    popularity: 279,
    codepoint: 0xe7ed,
    categories: [3],
    tags: [
      383,
      953,
      6766,
      3281,
      6767,
      194,
      922,
      211,
      6768,
      3360,
      481,
      6769,
      6278,
      930,
      6770,
      6771,
      223,
      4481,
      488,
      1257,
      1665,
      607,
      31,
      6772,
      946,
      6773,
      374,
      983,
      1159
    ],
  ),
  "commute": SymbolsMetadata(
    popularity: 980,
    codepoint: 0xe940,
    categories: [14],
    tags: [
      1814,
      1815,
      5734,
      2063,
      6774,
      6775,
      6776,
      388,
      6777,
      1581,
      1490,
      6778,
      6779,
      6780,
      6781,
      4321,
      2071,
      4603,
      5230,
      6782,
      4624,
      5234,
      2008,
      1842,
      1930,
      1504,
      6783,
      6784,
      1591,
      1844,
      6785
    ],
  ),
  "compare": SymbolsMetadata(
    popularity: 1386,
    codepoint: 0xe3b9,
    categories: [1],
    tags: [
      6786,
      6787,
      1128,
      5061,
      2513,
      3811,
      794,
      2447,
      5125,
      3812,
      3813,
      1734,
      5333,
      1370,
      4834,
      6788,
      696,
      2299,
      6789,
      528,
      3819,
      6790,
      1737,
      53,
      5800,
      281,
      656,
      59,
      61,
      5801,
      2281,
      1723,
      288,
      371,
      2264,
      65,
      3425,
      6791,
      1378,
      315,
      3032,
      6792,
      6793,
      6794
    ],
  ),
  "compare_arrows": SymbolsMetadata(
    popularity: 3623,
    codepoint: 0xe915,
    categories: [2],
    tags: [
      6795,
      380,
      419,
      1731,
      6796,
      3812,
      6797,
      1734,
      785,
      5333,
      6798,
      388,
      6799,
      2450,
      2627,
      5498,
      1375,
      421,
      6800,
      6801,
      1783,
      4461,
      3012,
      2881,
      2496,
      1396,
      6802,
      3425,
      5256,
      313,
      6803,
      5753,
      2007,
      2455
    ],
  ),
  "compass_calibration": SymbolsMetadata(
    popularity: 281,
    codepoint: 0xe57c,
    categories: [5],
    tags: [
      1725,
      1128,
      2167,
      2169,
      1729,
      5960,
      2831,
      268,
      1733,
      211,
      388,
      955,
      4294,
      960,
      6804,
      1488,
      215,
      1001,
      6805,
      1490,
      421,
      223,
      3070,
      3147,
      1496,
      5963,
      1741,
      424,
      122,
      2631,
      310,
      65,
      2649,
      227,
      2537,
      233,
      234
    ],
  ),
  "component_exchange": SymbolsMetadata(
    popularity: 1641,
    codepoint: 0xf1e7,
    categories: [6],
    tags: [
      384,
      6806,
      4175,
      3281,
      4866,
      268,
      211,
      385,
      2835,
      2627,
      926,
      3487,
      2629,
      1834,
      2837,
      4178,
      223,
      942,
      3662,
      396,
      397,
      65,
      5256,
      2632,
      6807,
      374,
      427,
      2571,
      1701
    ],
  ),
  "compost": SymbolsMetadata(
    popularity: 3167,
    codepoint: 0xe761,
    categories: [3],
    tags: [
      380,
      6808,
      2490,
      6809,
      6810,
      385,
      6811,
      6812,
      6813,
      6814,
      6566,
      1890,
      6815,
      6816,
      6817,
      6818,
      1204,
      196,
      5637,
      6819,
      6820,
      390,
      1859,
      6821,
      1835,
      6822,
      6823,
      6824,
      397,
      6825,
      2370,
      2371,
      6826
    ],
  ),
  "compress": SymbolsMetadata(
    popularity: 1199,
    codepoint: 0xe94d,
    categories: [2],
    tags: [
      2151,
      380,
      419,
      6827,
      2896,
      6796,
      6653,
      3086,
      3537,
      6247,
      3087,
      6828,
      6829,
      6830,
      6831,
      2840,
      6832,
      2080,
      6833,
      2928,
      6834,
      4988,
      4461,
      3012,
      6835,
      2930,
      3013,
      2933,
      6836,
      6803,
      1214,
      1677,
      6837
    ],
  ),
  "computer": SymbolsMetadata(
    popularity: 8828,
    codepoint: 0xe30a,
    categories: [11],
    tags: [
      1109,
      1110,
      4312,
      1684,
      694,
      6838,
      1685,
      445,
      88,
      12,
      1711,
      965,
      2176,
      1114,
      215,
      4052,
      1602,
      1687,
      327,
      4710,
      1456,
      819,
      6839,
      6840,
      2585,
      75,
      190,
      330,
      32,
      4325,
      551,
      1691,
      1054,
      1459,
      6841
    ],
  ),
  "computer_arrow_up": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf2f7,
    categories: [11],
    tags: [
      1109,
      1110,
      380,
      2052,
      2871,
      6842,
      1684,
      694,
      6843,
      6844,
      6845,
      1685,
      445,
      965,
      1114,
      4052,
      6846,
      6847,
      1687,
      327,
      6839,
      2343,
      6848,
      6849,
      6850,
      2007,
      6851,
      6852,
      1676,
      1677,
      346,
      6853,
      6854,
      3061,
      3062,
      1691,
      1054,
      6841
    ],
  ),
  "computer_cancel": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf2f6,
    categories: [11],
    tags: [
      1109,
      1110,
      5589,
      1074,
      895,
      1684,
      3436,
      2950,
      694,
      1202,
      896,
      4441,
      897,
      1685,
      445,
      1077,
      6427,
      2189,
      3438,
      2766,
      2985,
      2768,
      965,
      1114,
      4052,
      1687,
      327,
      6602,
      2772,
      4451,
      4452,
      911,
      6855,
      1083,
      551,
      5593,
      5587,
      1261,
      1691,
      1054,
      3736
    ],
  ),
  "concierge": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf561,
    categories: [16],
    tags: [
      469,
      738,
      6856,
      3073,
      1246,
      6857,
      1133,
      6858,
      6859,
      86,
      6860,
      6861,
      1019,
      6862,
      2734,
      6863,
      2735,
      6864,
      2738,
      482,
      6865,
      4219,
      6866,
      2607,
      6867,
      6868,
      1254,
      508,
      3162,
      6869,
      1257,
      6870,
      1960,
      2631,
      6871,
      495,
      1504,
      1591
    ],
  ),
  "conditions": SymbolsMetadata(
    popularity: 98,
    codepoint: 0xe0a0,
    categories: [3],
    tags: [
      733,
      468,
      2513,
      584,
      6872,
      6873,
      132,
      955,
      6874,
      958,
      959,
      960,
      6875,
      964,
      595,
      483,
      135,
      4296,
      967,
      971,
      973,
      974,
      975,
      976,
      656,
      488,
      489,
      329,
      490,
      6876,
      980,
      6877,
      981,
      65,
      750,
      501,
      6878,
      986
    ],
  ),
  "confirmation_number": SymbolsMetadata(
    popularity: 4740,
    codepoint: 0xe638,
    categories: [15],
    tags: [
      755,
      4712,
      6879,
      1936,
      4271,
      6880,
      6881,
      956,
      3337,
      1597,
      2094,
      3167,
      2810,
      23,
      24,
      96,
      2028,
      4851,
      3641,
      840,
      75,
      1924,
      77,
      6882,
      6883,
      791,
      2022,
      1504,
      2388,
      6884
    ],
  ),
  "congenital": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xe0a1,
    categories: [3],
    tags: [
      3325,
      6885,
      2412,
      6886,
      584,
      862,
      6887,
      6888,
      6889,
      6890,
      5182,
      2625,
      2414,
      6891,
      6892,
      6893,
      6894,
      4351,
      595,
      1753,
      6895,
      483,
      16,
      3606,
      6896,
      6897,
      6898,
      1757,
      6899,
      6900,
      3609,
      6901,
      5011,
      6902,
      35,
      6903,
      6904
    ],
  ),
  "connect_without_contact": SymbolsMetadata(
    popularity: 2104,
    codepoint: 0xf223,
    categories: [3],
    tags: [
      355,
      6905,
      443,
      921,
      211,
      475,
      6906,
      6907,
      588,
      589,
      6036,
      4897,
      223,
      436,
      488,
      489,
      5717,
      6908,
      3058,
      227,
      228,
      607,
      6909,
      608,
      6910,
      2007,
      5087,
      501,
      1159,
      1862,
      1902,
      233,
      234,
      6911,
      6912
    ],
  ),
  "connected_tv": SymbolsMetadata(
    popularity: 858,
    codepoint: 0xe998,
    categories: [11],
    tags: [
      1109,
      1110,
      2051,
      2827,
      355,
      1684,
      5866,
      921,
      922,
      6913,
      1685,
      445,
      6914,
      12,
      1711,
      3337,
      965,
      1114,
      6915,
      1687,
      367,
      5873,
      327,
      223,
      6916,
      330,
      5871,
      227,
      5872,
      2057,
      342,
      343,
      6917,
      344,
      1902,
      1691,
      233,
      1054,
      234
    ],
  ),
  "connecting_airports": SymbolsMetadata(
    popularity: 848,
    codepoint: 0xe7c9,
    categories: [5],
    tags: [
      707,
      6918,
      2010,
      1906,
      1907,
      1932,
      2012,
      2013,
      2014,
      1935,
      1995,
      211,
      2016,
      1484,
      1917,
      2017,
      1918,
      1973,
      1501,
      1581,
      307,
      909,
      308,
      2020,
      1503,
      227,
      2023,
      2007,
      2008,
      1930,
      1504,
      1981,
      1591,
      6919
    ],
  ),
  "construction": SymbolsMetadata(
    popularity: 9614,
    codepoint: 0xea3c,
    categories: [15],
    tags: [
      4864,
      798,
      5805,
      268,
      2832,
      1201,
      6920,
      2625,
      2835,
      2523,
      1737,
      6921,
      6922,
      6923,
      6924,
      2770,
      6925,
      5197,
      2837,
      329,
      3474,
      2631,
      65,
      6926,
      5198,
      2756,
      6927,
      6928,
      6929,
      6930,
      5199
    ],
  ),
  "contact_emergency": SymbolsMetadata(
    popularity: 730,
    codepoint: 0xf8d1,
    categories: [7],
    tags: [
      6931,
      468,
      469,
      2479,
      738,
      3255,
      470,
      1133,
      1113,
      475,
      848,
      3775,
      1751,
      2482,
      6932,
      479,
      4474,
      595,
      1753,
      482,
      1754,
      483,
      724,
      1251,
      6933,
      484,
      135,
      1757,
      219,
      486,
      488,
      489,
      226,
      490,
      602,
      2486,
      495,
      1034,
      501
    ],
  ),
  "contact_mail": SymbolsMetadata(
    popularity: 4749,
    codepoint: 0xe0d0,
    categories: [7],
    tags: [
      468,
      1429,
      6934,
      470,
      799,
      474,
      443,
      921,
      475,
      847,
      6935,
      2331,
      6860,
      6936,
      2335,
      479,
      480,
      6937,
      482,
      483,
      484,
      135,
      6938,
      4706,
      2340,
      6939,
      485,
      223,
      4948,
      488,
      489,
      3171,
      490,
      2343,
      495,
      501
    ],
  ),
  "contact_page": SymbolsMetadata(
    popularity: 3565,
    codepoint: 0xf22e,
    categories: [12],
    tags: [
      6940,
      468,
      1429,
      6934,
      470,
      443,
      475,
      847,
      6941,
      6935,
      10,
      132,
      6936,
      1528,
      1347,
      1654,
      479,
      1530,
      1656,
      1657,
      1598,
      6937,
      482,
      483,
      135,
      6942,
      1534,
      488,
      489,
      790,
      490,
      4788,
      4789,
      3767,
      674,
      495,
      946,
      501,
      704
    ],
  ),
  "contact_phone": SymbolsMetadata(
    popularity: 2822,
    codepoint: 0xe0cf,
    categories: [7],
    tags: [
      468,
      6934,
      738,
      470,
      1133,
      6943,
      474,
      443,
      921,
      475,
      6944,
      6945,
      6935,
      6860,
      1308,
      6936,
      479,
      6937,
      1309,
      6946,
      483,
      484,
      135,
      485,
      219,
      23,
      488,
      489,
      3171,
      226,
      6947,
      6948,
      490,
      6949,
      1318,
      1257,
      495,
      1320,
      501
    ],
  ),
  "contact_support": SymbolsMetadata(
    popularity: 9865,
    codepoint: 0xe94c,
    categories: [7],
    tags: [
      4102,
      6950,
      738,
      471,
      472,
      383,
      473,
      474,
      475,
      6935,
      476,
      6861,
      477,
      6951,
      6952,
      6937,
      482,
      6946,
      484,
      135,
      6938,
      1641,
      485,
      4103,
      979,
      4104,
      6953,
      4105,
      492,
      493,
      494,
      495,
      35,
      496
    ],
  ),
  "contactless": SymbolsMetadata(
    popularity: 1340,
    codepoint: 0xea71,
    categories: [9],
    tags: [
      2827,
      4479,
      355,
      6954,
      800,
      383,
      443,
      921,
      211,
      212,
      475,
      6906,
      6955,
      805,
      2332,
      445,
      831,
      808,
      6956,
      6957,
      6958,
      820,
      821,
      6959,
      2083,
      122,
      227,
      4008,
      551,
      441,
      6960,
      842,
      5087,
      1902,
      233,
      234
    ],
  ),
  "contactless_off": SymbolsMetadata(
    popularity: 91,
    codepoint: 0xf858,
    categories: [9],
    tags: [
      6961,
      4479,
      800,
      383,
      921,
      211,
      212,
      475,
      6906,
      6962,
      6963,
      6964,
      6965,
      805,
      445,
      1077,
      767,
      6966,
      898,
      808,
      899,
      6967,
      6968,
      6969,
      6970,
      6971,
      6972,
      6973,
      6974,
      6975,
      6976,
      6977,
      907,
      6978,
      908,
      909,
      820,
      821,
      6979,
      171,
      227,
      6980,
      914,
      6981,
      6982,
      6983,
      842,
      233,
      234,
      2050,
      6984
    ],
  ),
  "contacts": SymbolsMetadata(
    popularity: 4814,
    codepoint: 0xe0ba,
    categories: [7],
    tags: [
      468,
      6934,
      470,
      846,
      1133,
      1113,
      383,
      443,
      211,
      6985,
      848,
      6936,
      479,
      6986,
      930,
      1190,
      483,
      91,
      6987,
      484,
      135,
      92,
      6988,
      219,
      223,
      488,
      489,
      226,
      490,
      6989,
      77,
      2899,
      6990,
      946,
      1214,
      501
    ],
  ),
  "contacts_product": SymbolsMetadata(
    popularity: 287,
    codepoint: 0xe999,
    categories: [6],
    tags: [
      755,
      468,
      1126,
      6991,
      6992,
      211,
      6768,
      475,
      848,
      6993,
      6994,
      930,
      6770,
      885,
      6987,
      2528,
      936,
      6995,
      6996,
      488,
      489,
      1622,
      6997,
      490,
      1153,
      2631,
      2755,
      946,
      6773,
      501,
      1159
    ],
  ),
  "content_copy": SymbolsMetadata(
    popularity: 20301,
    codepoint: 0xe14d,
    categories: [12],
    tags: [
      1750,
      3753,
      1042,
      6998,
      6999,
      1707,
      7000,
      1062,
      5808,
      10,
      1528,
      1347,
      2999,
      1530,
      53,
      135,
      1066,
      778,
      2557,
      4916,
      1534,
      3000,
      6073,
      75,
      5482,
      7001,
      1665,
      32,
      107,
      1069,
      38,
      2007,
      315
    ],
  ),
  "content_cut": SymbolsMetadata(
    popularity: 1826,
    codepoint: 0xe14e,
    categories: [12],
    tags: [
      949,
      1469,
      1750,
      1042,
      7002,
      1707,
      1819,
      5808,
      897,
      3303,
      1370,
      1528,
      1347,
      696,
      2299,
      7003,
      7004,
      6243,
      1530,
      7005,
      778,
      6073,
      911,
      7006,
      1377,
      4852,
      7007,
      7008,
      1378,
      2537,
      7009
    ],
  ),
  "content_paste": SymbolsMetadata(
    popularity: 3460,
    codepoint: 0xe14f,
    categories: [12],
    tags: [
      1230,
      3115,
      1631,
      1469,
      1750,
      1042,
      1707,
      5808,
      10,
      1528,
      1347,
      696,
      1530,
      1598,
      135,
      966,
      92,
      2557,
      3155,
      1533,
      1456,
      6073,
      6129,
      75,
      1353,
      190,
      32,
      3296,
      1570,
      3159,
      38,
      704
    ],
  ),
  "content_paste_go": SymbolsMetadata(
    popularity: 614,
    codepoint: 0xea8e,
    categories: [12],
    tags: [
      949,
      380,
      1509,
      1469,
      1750,
      1633,
      1042,
      776,
      388,
      767,
      1528,
      1347,
      337,
      898,
      1672,
      1530,
      2910,
      1542,
      778,
      780,
      909,
      6073,
      781,
      75,
      1353,
      782,
      2343,
      1665,
      914,
      32,
      1412,
      1645,
      2007,
      346
    ],
  ),
  "content_paste_off": SymbolsMetadata(
    popularity: 286,
    codepoint: 0xe4f8,
    categories: [12],
    tags: [
      1074,
      895,
      1750,
      1042,
      1707,
      1202,
      5808,
      4442,
      1077,
      767,
      1528,
      1347,
      696,
      898,
      1530,
      899,
      1598,
      901,
      7010,
      7011,
      7012,
      1532,
      3155,
      907,
      909,
      6073,
      7013,
      911,
      171,
      914,
      915,
      3736
    ],
  ),
  "content_paste_search": SymbolsMetadata(
    popularity: 1663,
    codepoint: 0xea9b,
    categories: [12],
    tags: [
      3811,
      3115,
      7014,
      1631,
      1750,
      1042,
      7015,
      1707,
      10,
      132,
      4294,
      1528,
      1347,
      6874,
      958,
      1530,
      960,
      135,
      4296,
      4352,
      976,
      6073,
      2506,
      4361,
      3184,
      980,
      1645,
      3937,
      2165,
      2388,
      317,
      986
    ],
  ),
  "contextual_token": SymbolsMetadata(
    popularity: 87,
    codepoint: 0xf486,
    categories: [4],
    tags: [
      2501,
      1042,
      7016,
      7017,
      7018,
      7019,
      10,
      7020,
      1528,
      1347,
      696,
      1530,
      7021,
      135,
      7022,
      1044,
      306,
      2503,
      1534,
      2295,
      1048,
      2630,
      75,
      77,
      32,
      35,
      38,
      6080,
      441,
      7023,
      1214,
      40,
      7024,
      7025,
      1215,
      704
    ],
  ),
  "contextual_token_add": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf485,
    categories: [4],
    tags: [
      192,
      526,
      1057,
      2501,
      4866,
      268,
      7016,
      7017,
      1201,
      1735,
      1528,
      1347,
      696,
      3327,
      1530,
      2550,
      1206,
      1044,
      1620,
      306,
      366,
      92,
      788,
      1740,
      763,
      1211,
      2503,
      656,
      1534,
      202,
      75,
      77,
      65,
      32,
      107,
      35,
      38,
      441,
      7023,
      704
    ],
  ),
  "contract": SymbolsMetadata(
    popularity: 330,
    codepoint: 0xf5a0,
    categories: [12],
    tags: [
      7026,
      1230,
      7027,
      2919,
      1707,
      5751,
      1528,
      1347,
      1530,
      7028,
      1598,
      135,
      817,
      3361,
      366,
      92,
      1532,
      7029,
      7030,
      1534,
      1535,
      7031,
      7032,
      1721,
      121,
      75,
      1353,
      4788,
      6122,
      7033,
      38,
      842
    ],
  ),
  "contract_delete": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf5a2,
    categories: [12],
    tags: [
      7034,
      7026,
      895,
      7035,
      3436,
      2950,
      2919,
      1202,
      4565,
      897,
      7036,
      6427,
      1528,
      1347,
      3438,
      2985,
      1530,
      92,
      4145,
      7037,
      1534,
      1535,
      7031,
      4451,
      121,
      4452,
      911,
      7038,
      7039,
      7040,
      1083,
      5593,
      7041,
      842,
      7042,
      3736,
      7043
    ],
  ),
  "contract_edit": SymbolsMetadata(
    popularity: 252,
    codepoint: 0xf5a1,
    categories: [12],
    tags: [
      7026,
      1726,
      2488,
      1230,
      1731,
      693,
      6872,
      2919,
      2376,
      1201,
      1528,
      1347,
      1853,
      696,
      2299,
      1530,
      1598,
      966,
      817,
      92,
      1755,
      1740,
      1532,
      1534,
      1535,
      7031,
      2693,
      2694,
      121,
      3184,
      2497,
      7033,
      38,
      842,
      1260,
      1536,
      704
    ],
  ),
  "contrast": SymbolsMetadata(
    popularity: 1335,
    codepoint: 0xeb37,
    categories: [1],
    tags: [
      733,
      1128,
      7044,
      794,
      7045,
      1728,
      383,
      1734,
      3690,
      5025,
      7046,
      5036,
      12,
      1370,
      696,
      2299,
      2567,
      959,
      7047,
      5043,
      7048,
      53,
      5800,
      3680,
      7049,
      4222,
      6800,
      59,
      61,
      119,
      5802,
      3685,
      65,
      1378,
      7050,
      7051,
      41,
      317,
      5024,
      7052,
      7053
    ],
  ),
  "contrast_circle": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf49f,
    categories: [1],
    tags: [
      192,
      81,
      733,
      526,
      1128,
      7054,
      1728,
      383,
      1734,
      269,
      3690,
      2922,
      12,
      1370,
      696,
      7055,
      2299,
      7056,
      7057,
      7058,
      53,
      1207,
      7059,
      3680,
      7060,
      1116,
      59,
      202,
      330,
      65,
      1378,
      1122,
      41,
      5024
    ],
  ),
  "contrast_rtl_off": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xec72,
    categories: [1],
    tags: [
      733,
      7061,
      7045,
      383,
      1734,
      7062,
      7063,
      7064,
      3302,
      7065,
      3304,
      7066,
      767,
      325,
      696,
      2299,
      2567,
      898,
      959,
      7047,
      7057,
      53,
      5800,
      4411,
      901,
      7067,
      7060,
      4412,
      7068,
      907,
      908,
      909,
      61,
      119,
      5802,
      7069,
      3151,
      65,
      7070,
      914,
      7071,
      5024,
      4585,
      7052
    ],
  ),
  "contrast_square": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf4a0,
    categories: [1],
    tags: [
      192,
      79,
      733,
      526,
      1128,
      7044,
      7054,
      1728,
      1734,
      269,
      3690,
      2922,
      2969,
      12,
      325,
      696,
      7055,
      2299,
      7056,
      7058,
      53,
      1207,
      7059,
      3680,
      7060,
      1116,
      327,
      1770,
      3422,
      202,
      3685,
      65,
      32,
      1122,
      1701
    ],
  ),
  "control_camera": SymbolsMetadata(
    popularity: 337,
    codepoint: 0xe074,
    categories: [0],
    tags: [
      1128,
      5958,
      380,
      419,
      5488,
      47,
      7072,
      116,
      1730,
      383,
      269,
      1416,
      388,
      832,
      270,
      1738,
      3089,
      53,
      1375,
      126,
      367,
      2903,
      778,
      278,
      59,
      61,
      121,
      177,
      7073,
      1396,
      32,
      5545,
      5546,
      36,
      41,
      7074,
      2814,
      352
    ],
  ),
  "control_point_duplicate": SymbolsMetadata(
    popularity: 615,
    codepoint: 0xe3bb,
    categories: [1],
    tags: [
      192,
      526,
      2520,
      2827,
      383,
      3753,
      269,
      1360,
      1707,
      1201,
      1202,
      2332,
      299,
      3108,
      2999,
      696,
      787,
      2996,
      2550,
      305,
      1207,
      1218,
      2557,
      3261,
      763,
      3282,
      1081,
      1586,
      202,
      1363,
      2367,
      5482,
      7001,
      35,
      3025
    ],
  ),
  "controller_gen": SymbolsMetadata(
    popularity: 241,
    codepoint: 0xe83d,
    categories: [8],
    tags: [
      526,
      3453,
      4864,
      298,
      383,
      693,
      7075,
      4867,
      269,
      5258,
      1201,
      6583,
      832,
      7076,
      1598,
      2550,
      7077,
      7078,
      6632,
      7079,
      7080,
      1004,
      763,
      7081,
      202,
      1363,
      1837,
      7082,
      78,
      32,
      108
    ],
  ),
  "conversion_path": SymbolsMetadata(
    popularity: 2806,
    codepoint: 0xf0c1,
    categories: [9],
    tags: [
      1056,
      5,
      3352,
      84,
      1731,
      7083,
      211,
      1778,
      7084,
      2332,
      1484,
      956,
      2189,
      926,
      7085,
      1581,
      1602,
      935,
      1045,
      421,
      3362,
      1586,
      942,
      28,
      1503,
      7086,
      104,
      108,
      109,
      947,
      2571,
      7087,
      2746
    ],
  ),
  "conversion_path_off": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf7b4,
    categories: [9],
    tags: [
      1056,
      5,
      3352,
      894,
      7088,
      1075,
      7083,
      1778,
      7089,
      7090,
      7091,
      7084,
      896,
      7092,
      767,
      956,
      898,
      7093,
      7094,
      901,
      7095,
      1602,
      7096,
      907,
      908,
      909,
      1586,
      7097,
      7098,
      7099,
      7100,
      7101,
      7102,
      7103,
      914,
      7104,
      7105
    ],
  ),
  "convert_to_text": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf41f,
    categories: [12],
    tags: [
      380,
      2501,
      1731,
      1042,
      7106,
      3121,
      7107,
      388,
      1528,
      1347,
      2651,
      337,
      696,
      7108,
      1672,
      1530,
      1372,
      777,
      1542,
      366,
      1740,
      1534,
      1535,
      7109,
      979,
      3122,
      75,
      3124,
      309,
      1396,
      982,
      32,
      38,
      2007,
      427,
      7110,
      40,
      2185,
      704
    ],
  ),
  "conveyor_belt": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xf867,
    categories: [9],
    tags: [
      7111,
      2148,
      4613,
      7112,
      7113,
      1019,
      2210,
      7114,
      926,
      6923,
      6924,
      1602,
      7115,
      3896,
      1717,
      7116,
      6925,
      7117,
      1858,
      2647,
      942,
      1622,
      6296,
      7118,
      28,
      100,
      4606,
      7119,
      3899,
      2632,
      1842,
      1930,
      3902
    ],
  ),
  "cookie": SymbolsMetadata(
    popularity: 2201,
    codepoint: 0xeaac,
    categories: [3],
    tags: [
      3785,
      3787,
      7120,
      7121,
      5099,
      1039,
      5250,
      7122,
      7123,
      383,
      7124,
      7125,
      7126,
      10,
      3797,
      3800,
      7127,
      7128,
      1829,
      7129,
      329,
      1516,
      889,
      65,
      3809,
      3810,
      947,
      5319,
      7130,
      7131
    ],
  ),
  "cookie_off": SymbolsMetadata(
    popularity: 81,
    codepoint: 0xf79a,
    categories: [3],
    tags: [
      7132,
      7120,
      1074,
      7133,
      7134,
      7135,
      895,
      383,
      7136,
      7124,
      7137,
      7125,
      10,
      7138,
      897,
      3797,
      7139,
      767,
      898,
      899,
      7140,
      6528,
      7141,
      7142,
      907,
      908,
      909,
      329,
      1516,
      7143,
      911,
      7144,
      1011,
      65,
      914,
      947,
      7130,
      7145,
      7146
    ],
  ),
  "cooking": SymbolsMetadata(
    popularity: 1093,
    codepoint: 0xe2b6,
    categories: [8],
    tags: [
      7147,
      7148,
      7149,
      7150,
      3793,
      1269,
      3795,
      4388,
      7151,
      7152,
      7153,
      6170,
      7154,
      1829,
      4392,
      6174,
      3076,
      7155,
      999,
      1435,
      7156,
      3802,
      4398,
      7157,
      3804,
      7158,
      1004,
      3805,
      4484,
      5639,
      7159,
      6178,
      7160,
      3967,
      7161,
      7162,
      7163,
      6377,
      6369
    ],
  ),
  "cool_to_dry": SymbolsMetadata(
    popularity: 207,
    codepoint: 0xe276,
    categories: [10],
    tags: [
      3325,
      1731,
      712,
      5722,
      717,
      7164,
      385,
      2922,
      1500,
      4473,
      7165,
      7166,
      926,
      2790,
      999,
      1904,
      2798,
      2315,
      1004,
      942,
      2930,
      1787,
      7167,
      35,
      727,
      729,
      441,
      427,
      2571,
      2801,
      1862,
      1902,
      731
    ],
  ),
  "copy_all": SymbolsMetadata(
    popularity: 1121,
    codepoint: 0xe2ec,
    categories: [12],
    tags: [
      2325,
      1750,
      3753,
      1633,
      1042,
      1707,
      7168,
      7169,
      7000,
      5808,
      2448,
      2449,
      1528,
      1347,
      2999,
      2352,
      1530,
      1066,
      2557,
      1534,
      1535,
      2841,
      75,
      2367,
      5482,
      7001,
      190,
      1377,
      2381,
      371,
      32,
      1069,
      38,
      2007
    ],
  ),
  "copyright": SymbolsMetadata(
    popularity: 2512,
    codepoint: 0xe90c,
    categories: [9],
    tags: [
      7170,
      4,
      3352,
      3116,
      691,
      8,
      383,
      7171,
      7172,
      1042,
      1707,
      3357,
      3359,
      3128,
      3577,
      7173,
      14,
      16,
      7174,
      4964,
      5076,
      817,
      7175,
      19,
      3361,
      3119,
      3363,
      4331,
      7176,
      7177,
      7178,
      35,
      38,
      4966
    ],
  ),
  "coronavirus": SymbolsMetadata(
    popularity: 2415,
    codepoint: 0xf221,
    categories: [3],
    tags: [
      178,
      6332,
      2412,
      1113,
      383,
      7179,
      585,
      586,
      587,
      2414,
      956,
      7180,
      6334,
      6335,
      595,
      2416,
      6337,
      7181,
      1757,
      7182,
      4357,
      7183,
      598,
      7184,
      7185,
      5040,
      603,
      2424,
      7186,
      607,
      7187,
      5193
    ],
  ),
  "corporate_fare": SymbolsMetadata(
    popularity: 3727,
    codepoint: 0xf1d0,
    categories: [9],
    tags: [
      468,
      3313,
      2601,
      1325,
      1936,
      828,
      798,
      1284,
      2602,
      1285,
      5242,
      1327,
      3166,
      2605,
      3318,
      7188,
      7189,
      808,
      7190,
      1456,
      940,
      821,
      1495,
      1337,
      5246,
      286,
      2614,
      1446,
      2616,
      2617,
      2618,
      1930,
      1504,
      1591,
      2621,
      1459
    ],
  ),
  "cottage": SymbolsMetadata(
    popularity: 3594,
    codepoint: 0xe587,
    categories: [16],
    tags: [
      2599,
      2601,
      3923,
      798,
      5203,
      5262,
      5204,
      1817,
      4827,
      2604,
      1434,
      2605,
      867,
      999,
      5205,
      7191,
      1435,
      4617,
      5998,
      2610,
      5207,
      1490,
      1495,
      1444,
      2614,
      1445,
      2615,
      1446,
      2616,
      7192,
      1838,
      2617,
      5266,
      32,
      3846,
      5209,
      1701,
      2024,
      7193
    ],
  ),
  "counter_0": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf785,
    categories: [12],
    tags: [
      5059,
      458,
      5,
      6,
      383,
      9,
      86,
      11,
      4013,
      188,
      2472,
      7194,
      937,
      7195,
      486,
      6303,
      23,
      24,
      3641,
      28,
      29,
      101,
      2851,
      889,
      7196,
      33,
      35,
      7197,
      191,
      947,
      375
    ],
  ),
  "counter_1": SymbolsMetadata(
    popularity: 685,
    codepoint: 0xf784,
    categories: [12],
    tags: [
      79,
      6,
      84,
      383,
      9,
      86,
      11,
      1020,
      90,
      188,
      5206,
      2472,
      7194,
      486,
      23,
      24,
      25,
      3542,
      3641,
      28,
      29,
      101,
      889,
      7196,
      7198,
      108,
      3935,
      35,
      1033,
      947
    ],
  ),
  "counter_2": SymbolsMetadata(
    popularity: 299,
    codepoint: 0xf783,
    categories: [12],
    tags: [
      81,
      7199,
      6,
      383,
      9,
      86,
      11,
      1020,
      188,
      1620,
      2472,
      92,
      7194,
      486,
      23,
      7200,
      7201,
      24,
      25,
      96,
      28,
      29,
      100,
      101,
      889,
      7196,
      103,
      104,
      3935,
      35,
      1033,
      315,
      7202
    ],
  ),
  "counter_3": SymbolsMetadata(
    popularity: 238,
    codepoint: 0xf782,
    categories: [12],
    tags: [
      82,
      458,
      6,
      7203,
      383,
      9,
      86,
      11,
      188,
      2245,
      2472,
      459,
      7194,
      486,
      7204,
      23,
      24,
      25,
      7205,
      28,
      29,
      100,
      3582,
      2851,
      889,
      7196,
      6705,
      3935,
      35,
      7197,
      374,
      191
    ],
  ),
  "counter_4": SymbolsMetadata(
    popularity: 135,
    codepoint: 0xf781,
    categories: [12],
    tags: [
      534,
      458,
      6,
      383,
      9,
      86,
      11,
      1020,
      538,
      188,
      1620,
      2472,
      92,
      7194,
      486,
      23,
      24,
      25,
      96,
      28,
      29,
      889,
      104,
      6705,
      3935,
      461,
      35,
      1033,
      191,
      2165,
      2593
    ],
  ),
  "counter_5": SymbolsMetadata(
    popularity: 87,
    codepoint: 0xf780,
    categories: [12],
    tags: [
      564,
      458,
      6,
      383,
      9,
      86,
      11,
      4709,
      697,
      188,
      2472,
      7194,
      7206,
      486,
      7204,
      23,
      24,
      7205,
      28,
      29,
      3582,
      1257,
      889,
      7196,
      6705,
      3935,
      35,
      7197,
      191,
      2165
    ],
  ),
  "counter_6": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf77f,
    categories: [12],
    tags: [
      580,
      458,
      6,
      383,
      9,
      86,
      11,
      3360,
      188,
      2472,
      7194,
      390,
      486,
      23,
      24,
      25,
      7205,
      1496,
      29,
      101,
      1257,
      889,
      7196,
      7207,
      6705,
      3935,
      461,
      35,
      191,
      2165,
      947
    ],
  ),
  "counter_7": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf77e,
    categories: [12],
    tags: [
      636,
      458,
      6,
      383,
      9,
      86,
      11,
      3360,
      188,
      1620,
      2472,
      92,
      7194,
      390,
      486,
      23,
      24,
      25,
      96,
      1496,
      28,
      29,
      3582,
      1257,
      889,
      7196,
      104,
      641,
      6705,
      3935,
      35,
      191
    ],
  ),
  "counter_8": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf77d,
    categories: [12],
    tags: [
      658,
      6,
      7208,
      7209,
      383,
      9,
      86,
      11,
      1020,
      661,
      5015,
      188,
      2472,
      459,
      7194,
      486,
      23,
      24,
      7205,
      3641,
      3962,
      28,
      29,
      101,
      889,
      7196,
      7210,
      5781,
      6705,
      3935,
      35,
      1033,
      191
    ],
  ),
  "counter_9": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf77c,
    categories: [12],
    tags: [
      677,
      458,
      6,
      383,
      9,
      86,
      11,
      188,
      1620,
      2472,
      459,
      92,
      7194,
      682,
      486,
      23,
      24,
      25,
      7205,
      96,
      28,
      29,
      100,
      3582,
      889,
      7196,
      104,
      6705,
      3935,
      35,
      7197,
      191
    ],
  ),
  "countertops": SymbolsMetadata(
    popularity: 481,
    codepoint: 0xf1f7,
    categories: [8],
    tags: [
      4004,
      1868,
      7211,
      6343,
      4005,
      86,
      7212,
      7213,
      7214,
      1433,
      3990,
      1964,
      999,
      2080,
      1435,
      6350,
      4420,
      3802,
      7215,
      2800,
      75,
      7216,
      5816,
      3999,
      32,
      1380,
      4008,
      7217,
      7218,
      4001,
      3986
    ],
  ),
  "create_new_folder": SymbolsMetadata(
    popularity: 3939,
    codepoint: 0xe2cc,
    categories: [2],
    tags: [
      192,
      526,
      7219,
      2151,
      1042,
      1201,
      7220,
      7221,
      7222,
      10,
      6936,
      1528,
      1347,
      1654,
      1530,
      4783,
      1656,
      7223,
      135,
      763,
      7224,
      7225,
      98,
      202,
      7226,
      2843,
      1664,
      4788,
      4789,
      674,
      35
    ],
  ),
  "credit_card": SymbolsMetadata(
    popularity: 14590,
    codepoint: 0xe870,
    categories: [9],
    tags: [
      468,
      794,
      796,
      797,
      1325,
      799,
      800,
      1326,
      801,
      803,
      1327,
      805,
      829,
      806,
      830,
      7227,
      807,
      7228,
      834,
      808,
      811,
      2080,
      818,
      819,
      836,
      820,
      821,
      1337,
      840,
      75,
      77,
      841,
      7229,
      35,
      4008,
      842,
      843
    ],
  ),
  "credit_card_clock": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf438,
    categories: [9],
    tags: [
      989,
      797,
      7230,
      799,
      800,
      1016,
      801,
      803,
      1327,
      805,
      829,
      7231,
      7232,
      7233,
      7234,
      806,
      1017,
      1018,
      807,
      6405,
      1020,
      7235,
      808,
      1023,
      818,
      819,
      820,
      7236,
      7237,
      821,
      7238,
      7239,
      7240,
      7241,
      2858,
      1337,
      840,
      7242,
      1029,
      1031,
      841,
      35,
      289,
      1033,
      842,
      7243,
      2147
    ],
  ),
  "credit_card_gear": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf52d,
    categories: [9],
    tags: [
      1230,
      797,
      1325,
      7244,
      799,
      7245,
      800,
      1731,
      4174,
      4175,
      801,
      803,
      268,
      7246,
      7247,
      1327,
      805,
      829,
      7248,
      806,
      7249,
      132,
      807,
      7250,
      7251,
      808,
      7252,
      3485,
      484,
      135,
      7253,
      7254,
      818,
      7255,
      819,
      656,
      820,
      821,
      1336,
      7256,
      7257,
      790,
      329,
      1337,
      75,
      2631,
      65,
      841,
      35
    ],
  ),
  "credit_card_heart": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf52c,
    categories: [9],
    tags: [
      468,
      796,
      797,
      1670,
      799,
      800,
      7258,
      801,
      803,
      3314,
      1327,
      805,
      829,
      806,
      6993,
      807,
      3316,
      4472,
      7228,
      3578,
      808,
      4457,
      1560,
      4770,
      5759,
      3118,
      818,
      819,
      820,
      821,
      3641,
      4773,
      1337,
      840,
      7259,
      4272,
      3584,
      1664,
      841,
      532,
      495,
      35
    ],
  ),
  "credit_card_off": SymbolsMetadata(
    popularity: 762,
    codepoint: 0xe4f4,
    categories: [9],
    tags: [
      796,
      797,
      1074,
      895,
      799,
      800,
      801,
      803,
      1327,
      805,
      829,
      806,
      896,
      7249,
      5450,
      897,
      767,
      807,
      7228,
      898,
      2766,
      808,
      899,
      7067,
      818,
      7260,
      7261,
      7262,
      907,
      819,
      820,
      821,
      1336,
      7256,
      1337,
      840,
      75,
      911,
      912,
      841,
      914,
      35,
      842,
      915
    ],
  ),
  "credit_score": SymbolsMetadata(
    popularity: 3067,
    codepoint: 0xeff1,
    categories: [9],
    tags: [
      468,
      2717,
      1549,
      2480,
      796,
      797,
      799,
      800,
      1630,
      1632,
      801,
      803,
      1633,
      1327,
      805,
      829,
      7263,
      806,
      807,
      1639,
      808,
      809,
      4194,
      1023,
      135,
      5736,
      1641,
      818,
      1643,
      819,
      820,
      821,
      1213,
      102,
      1353,
      7196,
      288,
      35,
      1647,
      2385,
      2386,
      2387,
      2388,
      1523,
      2389,
      1650
    ],
  ),
  "crib": SymbolsMetadata(
    popularity: 495,
    codepoint: 0xe588,
    categories: [8],
    tags: [
      3598,
      3599,
      7264,
      4228,
      1909,
      862,
      4236,
      3602,
      865,
      4229,
      7265,
      4230,
      2332,
      867,
      1964,
      3606,
      870,
      871,
      7266,
      4238,
      3609,
      4232,
      5010,
      75,
      1925,
      7267,
      4233,
      190,
      1929,
      7268,
      7269,
      3612
    ],
  ),
  "crisis_alert": SymbolsMetadata(
    popularity: 2258,
    codepoint: 0xebe9,
    categories: [5],
    tags: [
      3175,
      951,
      1244,
      469,
      4943,
      1245,
      3073,
      355,
      1775,
      1693,
      383,
      1732,
      7270,
      3176,
      2482,
      2766,
      2767,
      1251,
      5223,
      2769,
      1641,
      486,
      3782,
      7271,
      2772,
      5862,
      602,
      1011,
      2485,
      35,
      36,
      4679,
      441,
      1034,
      1261
    ],
  ),
  "crop": SymbolsMetadata(
    popularity: 1409,
    codepoint: 0xe3be,
    categories: [1],
    tags: [
      1128,
      7054,
      993,
      2301,
      994,
      2391,
      1819,
      7272,
      5808,
      696,
      2299,
      274,
      5970,
      53,
      7273,
      3145,
      7274,
      5800,
      366,
      1361,
      59,
      7275,
      3422,
      5801,
      119,
      75,
      2930,
      2247,
      2281,
      371,
      65,
      311,
      673,
      32,
      427,
      7009
    ],
  ),
  "crop_16_9": SymbolsMetadata(
    popularity: 573,
    codepoint: 0xe3bc,
    categories: [1],
    tags: [
      142,
      2300,
      677,
      1128,
      7054,
      993,
      2301,
      7276,
      6289,
      1469,
      1819,
      5808,
      12,
      696,
      2299,
      270,
      1372,
      274,
      53,
      3145,
      5800,
      1543,
      367,
      278,
      59,
      5801,
      119,
      7277,
      3149,
      75,
      2247,
      77,
      2281,
      330,
      65,
      673,
      32,
      7009,
      41,
      364,
      2309
    ],
  ),
  "crop_3_2": SymbolsMetadata(
    popularity: 312,
    codepoint: 0xe3bd,
    categories: [1],
    tags: [
      81,
      82,
      7278,
      1128,
      7054,
      993,
      2301,
      994,
      7276,
      1819,
      7279,
      696,
      7280,
      7281,
      2299,
      274,
      53,
      7282,
      7273,
      3145,
      7283,
      7284,
      7285,
      5800,
      59,
      7275,
      3422,
      7286,
      5801,
      7287,
      4550,
      7288,
      75,
      2247,
      77,
      2281,
      65,
      311,
      673,
      32,
      7009
    ],
  ),
  "crop_5_4": SymbolsMetadata(
    popularity: 330,
    codepoint: 0xe3bf,
    categories: [1],
    tags: [
      534,
      564,
      7289,
      1128,
      7054,
      993,
      2301,
      994,
      7276,
      1819,
      7290,
      7291,
      7272,
      696,
      7292,
      7293,
      7294,
      274,
      53,
      7273,
      3145,
      7295,
      117,
      5800,
      59,
      3422,
      7296,
      118,
      5801,
      119,
      7287,
      3149,
      75,
      2247,
      190,
      77,
      2281,
      673,
      32
    ],
  ),
  "crop_7_5": SymbolsMetadata(
    popularity: 460,
    codepoint: 0xe3c0,
    categories: [1],
    tags: [
      564,
      636,
      7297,
      7298,
      1128,
      7054,
      993,
      2301,
      994,
      7276,
      1469,
      1819,
      7279,
      5808,
      696,
      2299,
      274,
      53,
      4536,
      7273,
      3145,
      117,
      5800,
      59,
      7275,
      3422,
      118,
      5801,
      7299,
      7287,
      75,
      2247,
      2281,
      288,
      371,
      65,
      673,
      32,
      7009
    ],
  ),
  "crop_9_16": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf549,
    categories: [1],
    tags: [
      142,
      2300,
      677,
      7300,
      1128,
      7054,
      993,
      2301,
      7276,
      1469,
      1819,
      7279,
      5808,
      696,
      2299,
      274,
      53,
      7273,
      3145,
      5800,
      7301,
      7302,
      59,
      7275,
      3422,
      5801,
      854,
      7303,
      75,
      2247,
      2281,
      65,
      7304,
      673,
      7305,
      32,
      7306,
      7009,
      7307,
      7308,
      364
    ],
  ),
  "crop_free": SymbolsMetadata(
    popularity: 1683,
    codepoint: 0xe3c2,
    categories: [1],
    tags: [
      1128,
      7054,
      2301,
      994,
      2391,
      1819,
      7309,
      12,
      696,
      2299,
      1738,
      274,
      5970,
      7310,
      7311,
      7312,
      7313,
      53,
      7273,
      3145,
      1361,
      59,
      3422,
      5801,
      119,
      7287,
      2247,
      288,
      371,
      65,
      673,
      32,
      427,
      7009,
      986
    ],
  ),
  "crop_landscape": SymbolsMetadata(
    popularity: 356,
    codepoint: 0xe3c3,
    categories: [1],
    tags: [
      2300,
      1128,
      7054,
      993,
      2301,
      994,
      1469,
      1819,
      5808,
      12,
      696,
      2299,
      787,
      1372,
      274,
      53,
      3145,
      5800,
      1543,
      59,
      3422,
      5801,
      119,
      3149,
      75,
      2930,
      2247,
      2281,
      330,
      65,
      673,
      7009,
      317,
      2309
    ],
  ),
  "crop_portrait": SymbolsMetadata(
    popularity: 458,
    codepoint: 0xe3c5,
    categories: [1],
    tags: [
      1128,
      7054,
      993,
      2301,
      349,
      1469,
      1819,
      7272,
      5808,
      696,
      2299,
      274,
      53,
      7273,
      3145,
      5800,
      3147,
      1361,
      59,
      3422,
      5801,
      119,
      7287,
      854,
      5503,
      3149,
      75,
      2930,
      2247,
      2281,
      65,
      673,
      32,
      7009,
      1381
    ],
  ),
  "crop_rotate": SymbolsMetadata(
    popularity: 324,
    codepoint: 0xe437,
    categories: [1],
    tags: [
      7314,
      6422,
      1128,
      7315,
      7054,
      378,
      993,
      380,
      419,
      6548,
      2907,
      1062,
      3523,
      1819,
      7279,
      696,
      2299,
      274,
      53,
      7316,
      7317,
      5800,
      3147,
      59,
      7318,
      5801,
      119,
      7073,
      396,
      397,
      65,
      673,
      399,
      32,
      427,
      402
    ],
  ),
  "crop_square": SymbolsMetadata(
    popularity: 1997,
    codepoint: 0xe3c6,
    categories: [1],
    tags: [
      7319,
      1128,
      7054,
      1229,
      1230,
      993,
      2301,
      994,
      2750,
      1819,
      7320,
      7321,
      7322,
      7279,
      7272,
      299,
      7323,
      696,
      2299,
      787,
      274,
      304,
      53,
      7273,
      3145,
      5800,
      2751,
      2653,
      59,
      7275,
      3422,
      5801,
      7287,
      3149,
      75,
      2247,
      2281,
      330,
      65,
      311,
      5923,
      2882,
      673,
      32,
      7324,
      7009,
      2757,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "crossword": SymbolsMetadata(
    popularity: 87,
    codepoint: 0xf5e5,
    categories: [3],
    tags: [
      918,
      6183,
      7325,
      6184,
      6187,
      7326,
      3153,
      3337,
      697,
      1659,
      6189,
      246,
      1218,
      3375,
      7327,
      6191,
      7328,
      7329,
      202,
      6637,
      7330,
      3157,
      3347,
      311,
      944,
      6193,
      3160,
      6641,
      3637,
      7331,
      7332,
      7333,
      7334
    ],
  ),
  "crowdsource": SymbolsMetadata(
    popularity: 207,
    codepoint: 0xeb18,
    categories: [3],
    tags: [
      754,
      1284,
      3281,
      4865,
      194,
      3314,
      7335,
      7336,
      478,
      480,
      481,
      7337,
      811,
      930,
      7338,
      6631,
      6632,
      966,
      815,
      2528,
      223,
      2653,
      4948,
      7339,
      821,
      488,
      7340,
      2071,
      3058,
      607,
      7341,
      946,
      983,
      791,
      7342,
      3855
    ],
  ),
  "crown": SymbolsMetadata(
    popularity: 72,
    codepoint: 0xecb3,
    categories: [3],
    tags: [
      3,
      2730,
      3574,
      6,
      3575,
      6188,
      7343,
      5757,
      90,
      7344,
      16,
      4220,
      7345,
      7346,
      2472,
      3118,
      7347,
      7348,
      3782,
      531,
      4226,
      101,
      3582,
      5912,
      553,
      35,
      7349,
      7350,
      1124,
      2852,
      3858,
      3588,
      5767,
      3589
    ],
  ),
  "cruelty_free": SymbolsMetadata(
    popularity: 2509,
    codepoint: 0xe799,
    categories: [3],
    tags: [
      5177,
      7351,
      7352,
      7353,
      3600,
      7354,
      7355,
      7356,
      7357,
      7358,
      6814,
      7359,
      479,
      959,
      7310,
      7360,
      16,
      7361,
      2528,
      7362,
      1859,
      7363,
      7364,
      3974,
      7365,
      7366,
      7367,
      841,
      7368,
      607,
      2370,
      2371,
      35,
      5192,
      7369,
      7370,
      7371
    ],
  ),
  "css": SymbolsMetadata(
    popularity: 1617,
    codepoint: 0xeb93,
    categories: [2],
    tags: [
      186,
      687,
      4,
      690,
      3909,
      7372,
      8,
      2624,
      6582,
      6583,
      1186,
      2625,
      88,
      1347,
      6584,
      2835,
      1530,
      3540,
      14,
      7373,
      6585,
      215,
      19,
      1194,
      2630,
      7374,
      7375,
      2182,
      7376,
      35,
      38,
      3554,
      40,
      702,
      1691,
      7377,
      7378,
      1241,
      1053
    ],
  ),
  "csv": SymbolsMetadata(
    popularity: 153,
    codepoint: 0xe6cf,
    categories: [12],
    tags: [
      687,
      4,
      8,
      7379,
      7380,
      7381,
      10,
      7382,
      7383,
      3754,
      3050,
      1347,
      337,
      1672,
      1530,
      7384,
      3540,
      7385,
      14,
      1372,
      1542,
      19,
      2653,
      75,
      1664,
      7386,
      1379,
      7387,
      32,
      35,
      1380,
      38,
      7388,
      40,
      346,
      7389
    ],
  ),
  "currency_bitcoin": SymbolsMetadata(
    popularity: 1925,
    codepoint: 0xebc5,
    categories: [9],
    tags: [
      797,
      7390,
      7391,
      7392,
      799,
      800,
      801,
      803,
      1327,
      805,
      7393,
      7394,
      806,
      7395,
      88,
      7396,
      3315,
      807,
      2138,
      2627,
      808,
      7397,
      16,
      815,
      7398,
      2528,
      1291,
      7399,
      818,
      819,
      820,
      821,
      1337,
      841,
      35,
      5753,
      842,
      7400,
      843,
      3324
    ],
  ),
  "currency_exchange": SymbolsMetadata(
    popularity: 5965,
    codepoint: 0xeb70,
    categories: [9],
    tags: [
      376,
      2284,
      380,
      419,
      796,
      800,
      383,
      384,
      801,
      803,
      1778,
      7106,
      806,
      7401,
      385,
      388,
      3315,
      807,
      2627,
      808,
      3524,
      390,
      818,
      820,
      821,
      424,
      2494,
      396,
      397,
      5256,
      313,
      1667,
      5753,
      842,
      2007,
      402,
      2455,
      7402,
      1260,
      3323
    ],
  ),
  "currency_franc": SymbolsMetadata(
    popularity: 245,
    codepoint: 0xeafa,
    categories: [9],
    tags: [
      796,
      797,
      799,
      800,
      7403,
      7404,
      7405,
      7406,
      801,
      803,
      7407,
      1327,
      805,
      806,
      7408,
      3315,
      807,
      2627,
      808,
      7409,
      7397,
      7410,
      7411,
      7412,
      7413,
      7414,
      818,
      819,
      820,
      821,
      1337,
      841,
      7415,
      7416,
      7417,
      7418,
      35,
      842,
      7419
    ],
  ),
  "currency_lira": SymbolsMetadata(
    popularity: 334,
    codepoint: 0xeaef,
    categories: [9],
    tags: [
      468,
      796,
      797,
      828,
      1618,
      799,
      800,
      801,
      803,
      1327,
      805,
      806,
      3315,
      807,
      1937,
      2627,
      808,
      3319,
      2527,
      815,
      7420,
      7421,
      818,
      819,
      820,
      821,
      1337,
      286,
      3322,
      841,
      35,
      842,
      7422,
      7423,
      7424,
      7425,
      1214,
      3324
    ],
  ),
  "currency_pound": SymbolsMetadata(
    popularity: 1028,
    codepoint: 0xeaf1,
    categories: [9],
    tags: [
      796,
      797,
      7426,
      799,
      800,
      801,
      803,
      1327,
      805,
      806,
      3315,
      807,
      7427,
      2627,
      808,
      7428,
      7429,
      811,
      7430,
      7431,
      7432,
      815,
      7433,
      818,
      819,
      820,
      821,
      7434,
      7435,
      1337,
      840,
      841,
      7436,
      35,
      842,
      7437,
      7438,
      3324,
      7439
    ],
  ),
  "currency_ruble": SymbolsMetadata(
    popularity: 613,
    codepoint: 0xeaec,
    categories: [9],
    tags: [
      796,
      797,
      1284,
      799,
      800,
      801,
      803,
      1327,
      805,
      806,
      7440,
      3315,
      807,
      7441,
      2627,
      808,
      811,
      1205,
      7414,
      815,
      7442,
      7433,
      818,
      819,
      820,
      821,
      1337,
      840,
      286,
      7443,
      7444,
      7445,
      7446,
      841,
      35,
      842,
      3324
    ],
  ),
  "currency_rupee": SymbolsMetadata(
    popularity: 3397,
    codepoint: 0xeaf7,
    categories: [9],
    tags: [
      3313,
      796,
      797,
      828,
      7447,
      799,
      800,
      801,
      803,
      1327,
      805,
      806,
      3315,
      807,
      3317,
      7448,
      2627,
      808,
      811,
      2080,
      7449,
      7450,
      7451,
      815,
      1291,
      818,
      819,
      820,
      821,
      1337,
      840,
      7452,
      3322,
      841,
      35,
      441,
      5753,
      842,
      3324
    ],
  ),
  "currency_rupee_circle": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf460,
    categories: [9],
    tags: [
      468,
      796,
      797,
      828,
      799,
      800,
      383,
      801,
      803,
      1327,
      805,
      806,
      3315,
      807,
      3317,
      7448,
      2627,
      808,
      809,
      811,
      7449,
      7450,
      7451,
      815,
      818,
      819,
      820,
      821,
      1337,
      840,
      889,
      7452,
      841,
      35,
      842,
      3324
    ],
  ),
  "currency_yen": SymbolsMetadata(
    popularity: 1062,
    codepoint: 0xeafb,
    categories: [9],
    tags: [
      7453,
      7454,
      796,
      797,
      1618,
      799,
      800,
      801,
      803,
      1327,
      805,
      806,
      3315,
      807,
      2627,
      808,
      809,
      3319,
      815,
      3958,
      3959,
      7455,
      1291,
      818,
      819,
      820,
      821,
      1337,
      840,
      286,
      3322,
      841,
      35,
      441,
      5753,
      842,
      1214,
      3324,
      7456,
      7457
    ],
  ),
  "currency_yuan": SymbolsMetadata(
    popularity: 311,
    codepoint: 0xeaf9,
    categories: [9],
    tags: [
      7453,
      7454,
      796,
      797,
      799,
      800,
      7458,
      7459,
      7460,
      801,
      803,
      1327,
      805,
      7461,
      806,
      3315,
      807,
      7448,
      2627,
      808,
      3958,
      3959,
      7455,
      818,
      819,
      820,
      821,
      1337,
      7462,
      7463,
      841,
      35,
      842,
      1214,
      1215,
      7456,
      7464
    ],
  ),
  "curtains": SymbolsMetadata(
    popularity: 288,
    codepoint: 0xec1e,
    categories: [8],
    tags: [
      4311,
      4418,
      267,
      2950,
      6660,
      4367,
      7465,
      4419,
      3690,
      1416,
      7466,
      7467,
      274,
      1659,
      7468,
      4420,
      3680,
      1004,
      2653,
      189,
      1516,
      2948,
      4206,
      4424,
      6705,
      7469,
      4211,
      3412,
      7470,
      1054,
      4427,
      7471,
      4429
    ],
  ),
  "curtains_closed": SymbolsMetadata(
    popularity: 147,
    codepoint: 0xec1d,
    categories: [8],
    tags: [
      4418,
      267,
      4430,
      7472,
      4367,
      7473,
      4419,
      3690,
      5979,
      6697,
      999,
      2796,
      278,
      1004,
      4222,
      189,
      1516,
      75,
      1960,
      4206,
      2997,
      4424,
      1929,
      6705,
      4211,
      3412,
      441,
      2252,
      1592,
      7474,
      1054,
      4426,
      4427
    ],
  ),
  "custom_typography": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xe732,
    categories: [12],
    tags: [
      3495,
      685,
      1128,
      4,
      1731,
      8,
      2919,
      785,
      7019,
      7475,
      6676,
      1735,
      2922,
      696,
      787,
      959,
      14,
      1372,
      1204,
      1207,
      4706,
      19,
      1740,
      2281,
      65,
      2933,
      673,
      372,
      3264,
      2182,
      35,
      38,
      7476,
      5028,
      1744,
      40,
      702
    ],
  ),
  "cycle": SymbolsMetadata(
    popularity: 958,
    codepoint: 0xf854,
    categories: [2],
    tags: [
      380,
      419,
      1731,
      383,
      2902,
      384,
      2907,
      2349,
      3523,
      385,
      388,
      926,
      1023,
      7477,
      3513,
      2568,
      390,
      421,
      780,
      2876,
      942,
      6822,
      424,
      425,
      2494,
      2367,
      426,
      3516,
      7478,
      396,
      397,
      889,
      5256,
      313,
      402,
      2455,
      1260
    ],
  ),
  "cyclone": SymbolsMetadata(
    popularity: 721,
    codepoint: 0xebd5,
    categories: [3],
    tags: [
      7479,
      1775,
      383,
      384,
      712,
      1732,
      7270,
      7480,
      4670,
      7481,
      7482,
      7483,
      1857,
      7484,
      7485,
      7486,
      397,
      399,
      2463,
      4652,
      6640,
      36,
      441,
      7487,
      7488,
      7489,
      2801,
      731,
      1863,
      7490,
      7491
    ],
  ),
  "dangerous": SymbolsMetadata(
    popularity: 3304,
    codepoint: 0xe99a,
    categories: [6],
    tags: [
      892,
      469,
      894,
      5099,
      895,
      1693,
      2950,
      3775,
      1202,
      3176,
      7492,
      897,
      2766,
      1737,
      899,
      4649,
      1251,
      2769,
      7493,
      3696,
      4145,
      3580,
      2772,
      4449,
      911,
      171,
      5862,
      1011,
      4101,
      1083,
      4679,
      1260,
      1261,
      7494,
      3736
    ],
  ),
  "dark_mode": SymbolsMetadata(
    popularity: 11853,
    codepoint: 0xe51c,
    categories: [4],
    tags: [
      733,
      1229,
      1230,
      4245,
      4214,
      1728,
      4246,
      4248,
      4249,
      3690,
      5025,
      7046,
      445,
      12,
      4253,
      2751,
      7495,
      4254,
      307,
      4255,
      4222,
      4256,
      329,
      65,
      1171,
      1929,
      313,
      5028,
      314,
      2757,
      792,
      7496,
      2759,
      5024,
      1053
    ],
  ),
  "dashboard": SymbolsMetadata(
    popularity: 16551,
    codepoint: 0xe871,
    categories: [12],
    tags: [
      5,
      1229,
      1230,
      5794,
      3233,
      269,
      2515,
      10,
      1372,
      246,
      999,
      135,
      2518,
      306,
      7497,
      936,
      788,
      937,
      327,
      421,
      7498,
      1770,
      75,
      2258,
      1353,
      5923,
      32,
      944,
      6404,
      3426,
      947,
      317,
      1691,
      1053,
      7499,
      1054
    ],
  ),
  "dashboard_2": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf3ea,
    categories: [12],
    tags: [
      5,
      1230,
      2170,
      5793,
      5794,
      2750,
      3234,
      2515,
      7500,
      10,
      12,
      1372,
      246,
      7501,
      2516,
      2751,
      306,
      937,
      5795,
      940,
      7498,
      4857,
      75,
      2258,
      7502,
      5923,
      32,
      944,
      6404,
      3426,
      792,
      317,
      1691,
      1053,
      1054,
      1084
    ],
  ),
  "dashboard_customize": SymbolsMetadata(
    popularity: 2543,
    codepoint: 0xe99b,
    categories: [12],
    tags: [
      526,
      1197,
      1367,
      918,
      5794,
      4866,
      268,
      269,
      1201,
      1735,
      2515,
      696,
      3327,
      787,
      1372,
      246,
      1207,
      306,
      1755,
      1740,
      763,
      656,
      98,
      2695,
      202,
      75,
      1377,
      65,
      5923,
      32,
      944,
      3426,
      1691,
      1053,
      7503
    ],
  ),
  "data_alert": SymbolsMetadata(
    popularity: 159,
    codepoint: 0xf7f6,
    categories: [2],
    tags: [
      3175,
      469,
      5,
      3073,
      1693,
      3176,
      2515,
      10,
      7504,
      3756,
      1347,
      2766,
      2767,
      1530,
      1251,
      135,
      2516,
      2769,
      1066,
      92,
      7505,
      1641,
      485,
      937,
      486,
      2772,
      1353,
      1376,
      3761,
      1379,
      107,
      674,
      35,
      1380,
      1261
    ],
  ),
  "data_array": SymbolsMetadata(
    popularity: 520,
    codepoint: 0xead1,
    categories: [12],
    tags: [
      3638,
      3909,
      2624,
      7506,
      6581,
      2155,
      1269,
      10,
      7507,
      7508,
      7509,
      7510,
      7511,
      7512,
      7513,
      7514,
      7515,
      2625,
      3327,
      135,
      7516,
      92,
      5136,
      2630,
      6589,
      104,
      3918,
      945,
      35,
      6592
    ],
  ),
  "data_check": SymbolsMetadata(
    popularity: 241,
    codepoint: 0xf7f2,
    categories: [2],
    tags: [
      1627,
      1549,
      2480,
      1630,
      1632,
      575,
      1633,
      1636,
      2376,
      10,
      7517,
      7518,
      7519,
      7520,
      7521,
      3756,
      1639,
      135,
      7522,
      7523,
      92,
      7505,
      1641,
      1643,
      5137,
      1376,
      288,
      107,
      1647,
      6088,
      2386,
      2387,
      1523,
      2389,
      1650
    ],
  ),
  "data_exploration": SymbolsMetadata(
    popularity: 1512,
    codepoint: 0xe76f,
    categories: [9],
    tags: [
      7524,
      5,
      380,
      4292,
      920,
      383,
      10,
      4293,
      7525,
      7526,
      2847,
      924,
      4294,
      832,
      5575,
      958,
      960,
      929,
      196,
      933,
      135,
      2516,
      967,
      4688,
      976,
      597,
      937,
      28,
      1354,
      4361,
      980,
      33,
      947,
      5176,
      7527
    ],
  ),
  "data_info_alert": SymbolsMetadata(
    popularity: 119,
    codepoint: 0xf7f5,
    categories: [2],
    tags: [
      7528,
      469,
      1245,
      738,
      383,
      10,
      3756,
      6326,
      132,
      6327,
      960,
      3225,
      482,
      6063,
      5463,
      484,
      135,
      7529,
      4688,
      1066,
      4697,
      366,
      92,
      7505,
      486,
      1353,
      1376,
      3761,
      2631,
      107,
      674,
      495,
      7530,
      6070,
      1261
    ],
  ),
  "data_loss_prevention": SymbolsMetadata(
    popularity: 172,
    codepoint: 0xe2dc,
    categories: [6],
    tags: [
      755,
      468,
      7014,
      470,
      3241,
      10,
      7531,
      3244,
      955,
      958,
      479,
      960,
      964,
      483,
      850,
      7532,
      4296,
      967,
      1489,
      971,
      7533,
      973,
      974,
      975,
      976,
      488,
      489,
      599,
      1516,
      490,
      7534,
      3184,
      3249,
      980,
      1011,
      981,
      7535,
      7536,
      7537,
      501,
      317,
      7538
    ],
  ),
  "data_object": SymbolsMetadata(
    popularity: 1905,
    codepoint: 0xead3,
    categories: [12],
    tags: [
      3638,
      1074,
      7539,
      3909,
      2624,
      7506,
      6581,
      7540,
      954,
      7541,
      10,
      7542,
      7514,
      1186,
      6596,
      2625,
      963,
      6586,
      7516,
      422,
      5136,
      2630,
      6589,
      3379,
      1196,
      6591,
      945,
      6592,
      2229
    ],
  ),
  "data_saver_on": SymbolsMetadata(
    popularity: 513,
    codepoint: 0xeff3,
    categories: [4],
    tags: [
      192,
      526,
      5,
      7543,
      3512,
      210,
      920,
      383,
      211,
      10,
      7544,
      7545,
      7546,
      7547,
      7548,
      7549,
      7550,
      7551,
      924,
      929,
      3053,
      1207,
      933,
      7552,
      7553,
      597,
      937,
      433,
      7554,
      7555,
      763,
      909,
      202,
      329,
      7556,
      7557,
      1257,
      7558,
      4100,
      65,
      33,
      35,
      947
    ],
  ),
  "data_table": SymbolsMetadata(
    popularity: 350,
    codepoint: 0xe99c,
    categories: [9],
    tags: [
      2513,
      1229,
      1230,
      2151,
      7559,
      3639,
      920,
      1368,
      802,
      2750,
      1042,
      10,
      7560,
      3756,
      299,
      1347,
      246,
      135,
      2751,
      306,
      6121,
      92,
      1755,
      2753,
      219,
      327,
      98,
      226,
      5137,
      1353,
      1603,
      1376,
      330,
      4788,
      2882,
      106,
      1379,
      674,
      945,
      1380,
      447,
      2757,
      2759,
      317,
      1691,
      1053,
      1054
    ],
  ),
  "data_thresholding": SymbolsMetadata(
    popularity: 1565,
    codepoint: 0xeb9f,
    categories: [2],
    tags: [
      2513,
      5,
      2311,
      994,
      920,
      10,
      4293,
      7561,
      7562,
      2847,
      924,
      959,
      929,
      1078,
      2517,
      2518,
      2472,
      459,
      634,
      937,
      189,
      1516,
      1353,
      1354,
      171,
      32,
      33,
      441,
      563,
      7563,
      7564,
      947,
      2852,
      1355
    ],
  ),
  "data_usage": SymbolsMetadata(
    popularity: 1289,
    codepoint: 0xe1af,
    categories: [4],
    tags: [
      5,
      5099,
      3512,
      210,
      920,
      383,
      4501,
      212,
      10,
      7548,
      7565,
      7551,
      7566,
      896,
      924,
      7567,
      767,
      7568,
      929,
      3053,
      933,
      215,
      2568,
      597,
      937,
      433,
      223,
      907,
      3055,
      28,
      6980,
      33,
      947,
      7569,
      2049
    ],
  ),
  "database": SymbolsMetadata(
    popularity: 13418,
    codepoint: 0xf20e,
    categories: [9],
    tags: [
      5,
      1651,
      1343,
      365,
      7570,
      920,
      383,
      1652,
      801,
      268,
      1269,
      7571,
      10,
      3756,
      924,
      2157,
      929,
      135,
      5074,
      1755,
      597,
      937,
      7572,
      223,
      7573,
      7574,
      3749,
      3761,
      65,
      7575,
      107,
      33,
      674,
      551,
      441,
      947,
      7576
    ],
  ),
  "database_off": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf414,
    categories: [9],
    tags: [
      5,
      1343,
      365,
      895,
      920,
      801,
      7571,
      10,
      7577,
      3873,
      7578,
      3756,
      7579,
      7580,
      7581,
      924,
      1077,
      767,
      3306,
      2037,
      898,
      929,
      597,
      937,
      7582,
      7583,
      7584,
      7585,
      907,
      908,
      909,
      3761,
      7586,
      7587,
      7588,
      914,
      33,
      674,
      7589,
      7590,
      7591,
      441,
      947
    ],
  ),
  "database_search": SymbolsMetadata(
    popularity: 91,
    codepoint: 0xf38e,
    categories: [9],
    tags: [
      5,
      1343,
      365,
      920,
      801,
      7571,
      10,
      7592,
      7593,
      7594,
      7595,
      3744,
      3756,
      7596,
      7597,
      924,
      7598,
      7599,
      959,
      960,
      7600,
      7601,
      964,
      929,
      135,
      7602,
      7603,
      971,
      972,
      973,
      974,
      975,
      976,
      597,
      937,
      979,
      980,
      7604,
      981,
      107,
      33,
      674,
      441,
      947
    ],
  ),
  "database_upload": SymbolsMetadata(
    popularity: 67,
    codepoint: 0xf3dc,
    categories: [9],
    tags: [
      526,
      5,
      380,
      1343,
      365,
      920,
      383,
      1652,
      7605,
      801,
      1540,
      7571,
      10,
      6550,
      3756,
      7606,
      924,
      7598,
      929,
      1542,
      135,
      966,
      1044,
      1674,
      3513,
      597,
      937,
      3012,
      1664,
      2343,
      3761,
      1665,
      107,
      33,
      674,
      1412,
      441,
      947,
      2007,
      1676,
      1260,
      346,
      3061,
      3062
    ],
  ),
  "dataset": SymbolsMetadata(
    popularity: 4402,
    codepoint: 0xf8ee,
    categories: [2],
    tags: [
      2513,
      5,
      2151,
      3639,
      2155,
      802,
      10,
      3756,
      7607,
      255,
      246,
      135,
      306,
      936,
      2753,
      98,
      1068,
      5137,
      1353,
      2843,
      1376,
      1379,
      32,
      674,
      945,
      1380,
      317,
      1054
    ],
  ),
  "dataset_linked": SymbolsMetadata(
    popularity: 1489,
    codepoint: 0xf8ef,
    categories: [2],
    tags: [
      1058,
      1061,
      921,
      211,
      10,
      213,
      3756,
      7607,
      7608,
      1672,
      2628,
      246,
      1472,
      1542,
      4869,
      1064,
      935,
      1000,
      7609,
      1067,
      223,
      3124,
      7610,
      7611,
      7612,
      1665,
      1379,
      1380,
      7613
    ],
  ),
  "date_range": SymbolsMetadata(
    popularity: 7526,
    codepoint: 0xe916,
    categories: [6],
    tags: [
      5340,
      1015,
      1936,
      5341,
      7614,
      1017,
      7615,
      7616,
      5036,
      1018,
      1020,
      2094,
      5347,
      98,
      7617,
      2838,
      1007,
      75,
      4272,
      1030,
      1924,
      1031,
      7618,
      32,
      791,
      289,
      5395,
      5351,
      5372
    ],
  ),
  "deblur": SymbolsMetadata(
    popularity: 366,
    codepoint: 0xeb77,
    categories: [1],
    tags: [
      1128,
      2827,
      47,
      953,
      544,
      2332,
      7619,
      956,
      696,
      2299,
      2567,
      528,
      479,
      959,
      1738,
      7057,
      53,
      4536,
      4568,
      3145,
      4569,
      54,
      530,
      366,
      59,
      3422,
      4573,
      61,
      119,
      2493,
      30,
      3749,
      5064,
      4579,
      4580
    ],
  ),
  "deceased": SymbolsMetadata(
    popularity: 79,
    codepoint: 0xe0a5,
    categories: [3],
    tags: [
      7620,
      7621,
      7622,
      7623,
      7624,
      4011,
      7625,
      7626,
      7627,
      7628,
      2433,
      7629,
      7630,
      6277,
      6816,
      7631,
      7632,
      595,
      7633,
      7533,
      5605,
      7634,
      1859,
      7635,
      7636,
      1835,
      5608,
      7637,
      7638,
      7639,
      7640,
      7641
    ],
  ),
  "decimal_decrease": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf82d,
    categories: [12],
    tags: [
      1128,
      380,
      419,
      2375,
      268,
      806,
      7642,
      4441,
      2922,
      7643,
      11,
      2651,
      808,
      7644,
      7645,
      7646,
      966,
      1375,
      7647,
      1210,
      2380,
      818,
      23,
      1363,
      1741,
      29,
      2930,
      2493,
      2281,
      65,
      7648,
      463,
      375,
      2404
    ],
  ),
  "decimal_increase": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf82c,
    categories: [12],
    tags: [
      526,
      1128,
      380,
      419,
      7649,
      268,
      806,
      7642,
      7650,
      50,
      787,
      808,
      7644,
      777,
      7645,
      7646,
      7651,
      196,
      1207,
      1217,
      966,
      7652,
      2380,
      818,
      789,
      780,
      24,
      7205,
      202,
      1741,
      29,
      1396,
      65,
      3935,
      1676,
      463
    ],
  ),
  "deck": SymbolsMetadata(
    popularity: 839,
    codepoint: 0xea42,
    categories: [8],
    tags: [
      1283,
      7653,
      6228,
      7654,
      3835,
      1964,
      7655,
      6816,
      999,
      1435,
      7656,
      1860,
      7657,
      3727,
      3841,
      3842,
      4282,
      3843,
      3347,
      1958,
      1925,
      5988,
      4206,
      2617,
      607,
      4208,
      1380,
      3847,
      1701,
      7658,
      4212,
      7641
    ],
  ),
  "dehaze": SymbolsMetadata(
    popularity: 733,
    codepoint: 0xe3c7,
    categories: [1],
    tags: [
      1128,
      2761,
      298,
      2950,
      2896,
      7659,
      2983,
      696,
      2299,
      528,
      787,
      6328,
      7660,
      2080,
      16,
      53,
      7661,
      1066,
      366,
      92,
      788,
      6329,
      421,
      2653,
      656,
      59,
      61,
      911,
      65,
      2993,
      6387,
      35,
      441,
      314,
      7662,
      7663
    ],
  ),
  "delete": SymbolsMetadata(
    popularity: 70907,
    codepoint: 0xe872,
    categories: [2],
    tags: [
      3433,
      7,
      3434,
      895,
      3435,
      3436,
      1269,
      897,
      7664,
      4667,
      6427,
      7665,
      6452,
      3438,
      7666,
      3439,
      7667,
      1361,
      3440,
      911,
      7668,
      6603,
      441,
      3444,
      3445,
      1214,
      7669,
      7670
    ],
  ),
  "delete_forever": SymbolsMetadata(
    popularity: 13189,
    codepoint: 0xe92b,
    categories: [2],
    tags: [
      3433,
      7,
      3434,
      895,
      3435,
      3436,
      6378,
      1269,
      1202,
      897,
      7671,
      4667,
      6427,
      3437,
      7672,
      6452,
      3438,
      2985,
      2354,
      3439,
      7673,
      7674,
      3440,
      911,
      7675,
      3444,
      7676,
      3445,
      7670,
      3736,
      7677
    ],
  ),
  "delete_history": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xf518,
    categories: [6],
    tags: [
      380,
      2489,
      3035,
      895,
      7678,
      383,
      2490,
      7679,
      3436,
      7680,
      1016,
      7681,
      2950,
      1202,
      1017,
      897,
      7682,
      3438,
      2985,
      1023,
      7683,
      4145,
      2841,
      4451,
      424,
      911,
      7684,
      2494,
      426,
      2881,
      2886,
      396,
      1031,
      1083,
      289,
      2099,
      7685,
      1033,
      402,
      2499,
      3736
    ],
  ),
  "delete_sweep": SymbolsMetadata(
    popularity: 2890,
    codepoint: 0xe16c,
    categories: [2],
    tags: [
      3433,
      3434,
      1871,
      3435,
      3436,
      6378,
      1269,
      897,
      6384,
      7686,
      7687,
      7688,
      6427,
      3437,
      3438,
      7689,
      3439,
      2080,
      7690,
      3440,
      7691,
      911,
      6385,
      6376,
      441,
      3444,
      3445,
      7670
    ],
  ),
  "delivery_truck_bolt": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf3a2,
    categories: [9],
    tags: [
      1814,
      3467,
      4089,
      1815,
      4613,
      1816,
      1019,
      7692,
      2210,
      1329,
      4074,
      7693,
      4112,
      3779,
      4114,
      1021,
      1022,
      7694,
      4616,
      19,
      4094,
      6868,
      3896,
      2340,
      1490,
      1456,
      2647,
      4921,
      1409,
      4922,
      1027,
      7695,
      7696,
      2343,
      4606,
      841,
      231,
      2728,
      3899,
      7697,
      4098,
      1842,
      1930,
      1843,
      1034,
      1844
    ],
  ),
  "delivery_truck_speed": SymbolsMetadata(
    popularity: 110,
    codepoint: 0xf3a1,
    categories: [9],
    tags: [
      1814,
      1815,
      4613,
      1816,
      1019,
      7698,
      7692,
      2210,
      1329,
      7699,
      1021,
      7700,
      1022,
      7694,
      4616,
      19,
      6868,
      3896,
      2340,
      1490,
      7701,
      1456,
      1621,
      96,
      2647,
      4921,
      1409,
      4922,
      1027,
      7695,
      1028,
      7702,
      7696,
      7703,
      2343,
      4606,
      841,
      231,
      2728,
      1842,
      1930,
      1843,
      1034,
      1844
    ],
  ),
  "demography": SymbolsMetadata(
    popularity: 131,
    codepoint: 0xe489,
    categories: [3],
    tags: [
      5,
      584,
      7704,
      920,
      194,
      10,
      1063,
      7705,
      132,
      1528,
      1347,
      1530,
      930,
      595,
      7706,
      483,
      7707,
      850,
      135,
      92,
      936,
      1532,
      940,
      1534,
      1535,
      488,
      489,
      7708,
      490,
      5137,
      1353,
      7709,
      33,
      945,
      1380,
      946,
      501,
      704
    ],
  ),
  "density_large": SymbolsMetadata(
    popularity: 580,
    codepoint: 0xeba9,
    categories: [2],
    tags: [
      2170,
      7710,
      2919,
      2922,
      7711,
      588,
      7712,
      787,
      1372,
      2176,
      2080,
      1207,
      7713,
      3634,
      306,
      7714,
      366,
      7715,
      2180,
      2295,
      2247,
      601,
      2181,
      2281,
      7716,
      673,
      2248,
      38,
      7717,
      1214,
      986
    ],
  ),
  "density_medium": SymbolsMetadata(
    popularity: 2417,
    codepoint: 0xeb9e,
    categories: [2],
    tags: [
      2761,
      2170,
      2896,
      269,
      7711,
      12,
      787,
      959,
      6328,
      2176,
      2080,
      2751,
      1066,
      366,
      92,
      4044,
      7718,
      788,
      6329,
      789,
      421,
      656,
      96,
      98,
      601,
      2181,
      65,
      106,
      2248,
      6387,
      441,
      317,
      7663
    ],
  ),
  "density_small": SymbolsMetadata(
    popularity: 1632,
    codepoint: 0xeba8,
    categories: [2],
    tags: [
      6653,
      3086,
      6247,
      7710,
      2919,
      2922,
      7711,
      7719,
      7720,
      2176,
      2080,
      7713,
      1066,
      7721,
      366,
      92,
      788,
      2928,
      6834,
      656,
      2930,
      601,
      2181,
      3093,
      65,
      2933,
      1979,
      107,
      6387,
      7717,
      7722,
      2404
    ],
  ),
  "dentistry": SymbolsMetadata(
    popularity: 673,
    codepoint: 0xe0a6,
    categories: [3],
    tags: [
      1015,
      7539,
      1182,
      7723,
      7724,
      6188,
      7725,
      7726,
      7727,
      7728,
      7729,
      7730,
      7731,
      595,
      3972,
      7732,
      1757,
      7733,
      6899,
      7734,
      7735,
      1567,
      5819,
      7736,
      7737,
      7738,
      7739
    ],
  ),
  "departure_board": SymbolsMetadata(
    popularity: 715,
    codepoint: 0xe576,
    categories: [14],
    tags: [
      2013,
      2014,
      7740,
      1814,
      6182,
      2062,
      7741,
      1815,
      1816,
      1016,
      7742,
      2063,
      2016,
      7743,
      1581,
      1490,
      7744,
      2071,
      7745,
      4603,
      1031,
      3611,
      4623,
      4087,
      289,
      1033,
      5371,
      4624,
      7746,
      4625,
      7747,
      1930,
      1504,
      6784,
      1591,
      1844
    ],
  ),
  "deployed_code": SymbolsMetadata(
    popularity: 558,
    codepoint: 0xf720,
    categories: [2],
    tags: [
      406,
      1230,
      1074,
      7,
      1652,
      2624,
      6581,
      1269,
      1201,
      408,
      3064,
      7748,
      7749,
      2625,
      300,
      2173,
      1659,
      1661,
      5074,
      1674,
      7750,
      3080,
      223,
      2647,
      7751,
      1194,
      1622,
      2504,
      3068,
      3761,
      2631,
      1196,
      32,
      7752
    ],
  ),
  "deployed_code_account": SymbolsMetadata(
    popularity: 68,
    codepoint: 0xf51b,
    categories: [2],
    tags: [
      406,
      755,
      468,
      1126,
      1230,
      7753,
      7,
      1731,
      2624,
      6581,
      4866,
      1269,
      1201,
      408,
      1019,
      3064,
      7754,
      7749,
      132,
      2625,
      300,
      2210,
      479,
      3485,
      483,
      1674,
      7750,
      1755,
      936,
      656,
      3119,
      3363,
      2647,
      7751,
      488,
      489,
      1622,
      490,
      2504,
      3068,
      2843,
      2631,
      65,
      1196,
      501
    ],
  ),
  "deployed_code_alert": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf5f2,
    categories: [2],
    tags: [
      3175,
      406,
      469,
      1230,
      3073,
      4863,
      7,
      5178,
      1693,
      2624,
      6581,
      1269,
      1201,
      408,
      3176,
      1019,
      7754,
      7749,
      2625,
      300,
      2766,
      2767,
      1659,
      1251,
      5223,
      1674,
      7750,
      2769,
      1641,
      486,
      2647,
      7751,
      2772,
      6296,
      3068,
      2631,
      2535,
      1196,
      32,
      35,
      441,
      1261
    ],
  ),
  "deployed_code_history": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xf5f3,
    categories: [2],
    tags: [
      406,
      989,
      2151,
      4863,
      7,
      6005,
      7755,
      1016,
      2624,
      6581,
      6762,
      1269,
      7756,
      1201,
      408,
      1017,
      7754,
      7749,
      2625,
      7757,
      300,
      7758,
      6007,
      1023,
      1674,
      7750,
      7759,
      5264,
      2647,
      7751,
      2841,
      2858,
      3505,
      1029,
      3068,
      2843,
      1031,
      1196,
      289,
      290,
      4310,
      7760
    ],
  ),
  "deployed_code_update": SymbolsMetadata(
    popularity: 120,
    codepoint: 0xf5f4,
    categories: [2],
    tags: [
      406,
      380,
      2650,
      419,
      4863,
      7,
      383,
      2624,
      6581,
      1269,
      1201,
      408,
      7761,
      3064,
      7749,
      2625,
      300,
      2173,
      2651,
      337,
      6519,
      1672,
      6007,
      5195,
      1542,
      1674,
      7750,
      2647,
      7751,
      7762,
      3012,
      3068,
      2843,
      2535,
      1196,
      1260,
      6011
    ],
  ),
  "dermatology": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xe0a7,
    categories: [3],
    tags: [
      7763,
      7352,
      7764,
      7765,
      584,
      1749,
      7766,
      7355,
      7767,
      7768,
      7769,
      445,
      7770,
      7771,
      7772,
      7773,
      7774,
      6220,
      595,
      483,
      2836,
      390,
      1757,
      7775,
      7776,
      7777,
      7778,
      7779,
      7368,
      2537,
      2428,
      1905,
      7780
    ],
  ),
  "description": SymbolsMetadata(
    popularity: 34312,
    codepoint: 0xe873,
    categories: [12],
    tags: [
      2501,
      1058,
      693,
      1042,
      1201,
      10,
      6326,
      1528,
      1347,
      337,
      1654,
      696,
      1530,
      1656,
      1657,
      135,
      1044,
      366,
      1533,
      2653,
      1534,
      1535,
      2506,
      1353,
      1664,
      4788,
      4789,
      2510,
      38,
      3114,
      7388,
      346,
      317,
      704
    ],
  ),
  "deselect": SymbolsMetadata(
    popularity: 426,
    codepoint: 0xebb6,
    categories: [12],
    tags: [
      949,
      951,
      2325,
      895,
      3639,
      266,
      3436,
      802,
      10,
      896,
      4721,
      1077,
      767,
      956,
      2855,
      898,
      246,
      2753,
      7195,
      907,
      909,
      281,
      3021,
      3641,
      911,
      1376,
      288,
      371,
      65,
      914,
      1379,
      32,
      313,
      1380,
      314,
      2537,
      5588
    ],
  ),
  "design_services": SymbolsMetadata(
    popularity: 4880,
    codepoint: 0xf10a,
    categories: [12],
    tags: [
      2601,
      7781,
      4864,
      1061,
      693,
      2832,
      7782,
      1201,
      1202,
      299,
      7783,
      7784,
      6583,
      1853,
      2833,
      7785,
      302,
      696,
      2299,
      2835,
      7786,
      966,
      1218,
      1064,
      597,
      4916,
      2693,
      2694,
      2107,
      7787,
      2631,
      2755,
      2756,
      1536,
      704,
      3736
    ],
  ),
  "desk": SymbolsMetadata(
    popularity: 361,
    codepoint: 0xf8f4,
    categories: [8],
    tags: [
      5541,
      2983,
      7788,
      1964,
      5981,
      999,
      7789,
      16,
      2796,
      4420,
      7790,
      7791,
      1456,
      7792,
      940,
      1361,
      75,
      7793,
      674,
      4691,
      35,
      1380,
      7794,
      441,
      1459,
      3508,
      6841
    ],
  ),
  "deskphone": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf7fa,
    categories: [11],
    tags: [
      5532,
      5172,
      1284,
      952,
      1133,
      7795,
      443,
      7796,
      921,
      475,
      476,
      5541,
      7797,
      7798,
      445,
      1308,
      7799,
      1309,
      965,
      6946,
      970,
      5403,
      219,
      1456,
      7800,
      226,
      1318,
      1257,
      495,
      496,
      1320,
      7801,
      7802
    ],
  ),
  "desktop_access_disabled": SymbolsMetadata(
    popularity: 262,
    codepoint: 0xe99d,
    categories: [11],
    tags: [
      1109,
      1110,
      755,
      894,
      895,
      1684,
      694,
      7803,
      1202,
      4442,
      1685,
      7804,
      445,
      767,
      12,
      898,
      899,
      965,
      1114,
      7067,
      1687,
      327,
      7805,
      2678,
      7011,
      907,
      908,
      909,
      4449,
      7806,
      912,
      171,
      330,
      7807,
      914,
      1083,
      915,
      1691,
      1054,
      3736
    ],
  ),
  "desktop_cloud": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf3db,
    categories: [11],
    tags: [
      1109,
      1110,
      1651,
      1684,
      1652,
      6523,
      3739,
      7808,
      6504,
      3741,
      694,
      212,
      7809,
      3744,
      1685,
      7810,
      7811,
      445,
      12,
      337,
      1654,
      3745,
      965,
      1114,
      1025,
      215,
      1687,
      327,
      223,
      7812,
      7813,
      7814,
      330,
      674,
      1667,
      3750,
      2632,
      343,
      344,
      346,
      2826,
      7815,
      1691,
      1054,
      1084
    ],
  ),
  "desktop_cloud_stack": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf3be,
    categories: [11],
    tags: [
      1109,
      1110,
      1651,
      1684,
      1652,
      3739,
      7816,
      7817,
      6504,
      3741,
      2155,
      694,
      211,
      7809,
      10,
      1685,
      7811,
      445,
      12,
      337,
      1654,
      930,
      965,
      1114,
      5074,
      1025,
      1687,
      327,
      223,
      1194,
      7814,
      330,
      2631,
      1196,
      107,
      674,
      1667,
      3529,
      2632,
      343,
      2007,
      344,
      346,
      7815,
      7818,
      7819,
      1691,
      1054,
      1084,
      3508
    ],
  ),
  "desktop_landscape": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf45e,
    categories: [2],
    tags: [
      1230,
      7820,
      1368,
      694,
      1062,
      1685,
      445,
      12,
      787,
      2054,
      2395,
      246,
      2751,
      1543,
      306,
      2307,
      327,
      7821,
      1770,
      2400,
      2648,
      3156,
      75,
      2247,
      1603,
      330,
      7822,
      4900,
      1378,
      7823,
      32,
      313,
      317,
      2309,
      1054
    ],
  ),
  "desktop_landscape_add": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf439,
    categories: [2],
    tags: [
      192,
      526,
      7824,
      7825,
      7826,
      7827,
      7828,
      1368,
      1201,
      7829,
      7830,
      7831,
      7832,
      7833,
      1685,
      12,
      787,
      2996,
      246,
      1543,
      306,
      327,
      7821,
      763,
      7834,
      7835,
      7836,
      7837,
      1211,
      3003,
      202,
      7838,
      7839,
      7840,
      1603,
      330,
      4900,
      1378,
      7823,
      107,
      35,
      1054
    ],
  ),
  "desktop_mac": SymbolsMetadata(
    popularity: 1090,
    codepoint: 0xe30b,
    categories: [11],
    tags: [
      1109,
      1110,
      2964,
      4312,
      5126,
      1284,
      1684,
      443,
      694,
      1685,
      7841,
      445,
      88,
      12,
      1711,
      965,
      999,
      1114,
      7842,
      215,
      1687,
      327,
      1456,
      6839,
      6840,
      75,
      330,
      32,
      4325,
      551,
      1691,
      1054,
      1459,
      6841
    ],
  ),
  "desktop_portrait": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf45d,
    categories: [2],
    tags: [
      2301,
      1731,
      1368,
      694,
      1062,
      1685,
      7841,
      445,
      88,
      12,
      1711,
      274,
      246,
      3759,
      306,
      327,
      7821,
      3147,
      6839,
      854,
      75,
      396,
      1603,
      330,
      7843,
      4900,
      1378,
      7823,
      32,
      313,
      551,
      1381,
      317,
      1054,
      6841
    ],
  ),
  "desktop_windows": SymbolsMetadata(
    popularity: 5239,
    codepoint: 0xe30c,
    categories: [11],
    tags: [
      1109,
      1110,
      1230,
      4312,
      1284,
      1684,
      694,
      1685,
      7841,
      445,
      88,
      12,
      1711,
      965,
      1114,
      1687,
      327,
      1456,
      6839,
      6840,
      2648,
      75,
      190,
      330,
      1196,
      32,
      4325,
      495,
      551,
      343,
      344,
      792,
      317,
      1691,
      1054,
      1084,
      1459,
      6841
    ],
  ),
  "destruction": SymbolsMetadata(
    popularity: 128,
    codepoint: 0xf585,
    categories: [3],
    tags: [
      469,
      4658,
      7844,
      4659,
      4661,
      4662,
      4663,
      3436,
      5667,
      2765,
      4666,
      3176,
      897,
      4667,
      4668,
      7845,
      7846,
      7847,
      3438,
      3104,
      4671,
      4127,
      4649,
      7848,
      7849,
      911,
      7850,
      5058,
      4679,
      1261
    ],
  ),
  "details": SymbolsMetadata(
    popularity: 801,
    codepoint: 0xe3c8,
    categories: [1],
    tags: [
      6658,
      7851,
      380,
      2871,
      2862,
      2950,
      2896,
      7852,
      6660,
      132,
      3101,
      7853,
      2941,
      696,
      2299,
      528,
      787,
      7854,
      7855,
      7856,
      932,
      53,
      1066,
      7647,
      788,
      789,
      938,
      2653,
      59,
      61,
      2948,
      4579,
      7857,
      7858,
      7859,
      314,
      1701
    ],
  ),
  "detection_and_zone": SymbolsMetadata(
    popularity: 314,
    codepoint: 0xe29f,
    categories: [10],
    tags: [
      755,
      989,
      469,
      993,
      994,
      2391,
      2805,
      7860,
      1597,
      4410,
      274,
      999,
      483,
      7861,
      420,
      7862,
      1858,
      1004,
      486,
      1006,
      489,
      7863,
      7864,
      1008,
      1009,
      1011,
      122,
      32,
      351,
      985,
      3939,
      1013,
      7865
    ],
  ),
  "detector": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xe282,
    categories: [10],
    tags: [
      1244,
      469,
      2148,
      3669,
      7866,
      2805,
      7867,
      445,
      2523,
      999,
      2080,
      1896,
      1897,
      4460,
      420,
      1858,
      1004,
      486,
      1519,
      7868,
      602,
      1723,
      1724,
      1011,
      122,
      227,
      1901,
      5266,
      351,
      551,
      441,
      947,
      1902,
      234
    ],
  ),
  "detector_alarm": SymbolsMetadata(
    popularity: 270,
    codepoint: 0xe1f7,
    categories: [10],
    tags: [
      1244,
      469,
      3669,
      7869,
      7866,
      2805,
      7867,
      7870,
      445,
      2482,
      999,
      5512,
      7871,
      327,
      420,
      1858,
      1004,
      486,
      1519,
      1520,
      75,
      602,
      1011,
      122,
      227,
      2485,
      5266,
      1156,
      351,
      441,
      985,
      1261
    ],
  ),
  "detector_battery": SymbolsMetadata(
    popularity: 123,
    codepoint: 0xe204,
    categories: [10],
    tags: [
      1244,
      469,
      3769,
      3772,
      4028,
      3773,
      7866,
      2805,
      7867,
      7872,
      445,
      4086,
      3216,
      2523,
      4066,
      965,
      999,
      188,
      1897,
      2472,
      3780,
      327,
      1004,
      3782,
      602,
      1011,
      122,
      7873,
      227,
      7874,
      5266,
      553,
      351,
      551,
      7875
    ],
  ),
  "detector_co": SymbolsMetadata(
    popularity: 147,
    codepoint: 0xe2af,
    categories: [10],
    tags: [
      1244,
      469,
      2148,
      798,
      7876,
      953,
      7866,
      2805,
      7867,
      445,
      956,
      5601,
      1854,
      999,
      1435,
      1897,
      2797,
      327,
      4460,
      1004,
      1519,
      1520,
      602,
      1011,
      122,
      1901,
      5266,
      351,
      1261
    ],
  ),
  "detector_offline": SymbolsMetadata(
    popularity: 101,
    codepoint: 0xe223,
    categories: [10],
    tags: [
      469,
      895,
      211,
      1202,
      2805,
      7867,
      445,
      767,
      2037,
      2766,
      2768,
      7877,
      999,
      2080,
      901,
      7878,
      327,
      1004,
      223,
      7879,
      908,
      2772,
      75,
      602,
      1011,
      122,
      227,
      5266,
      351,
      915,
      1261,
      3736
    ],
  ),
  "detector_smoke": SymbolsMetadata(
    popularity: 463,
    codepoint: 0xe285,
    categories: [8],
    tags: [
      1244,
      469,
      798,
      7880,
      2804,
      2805,
      7867,
      445,
      2482,
      5601,
      7881,
      7882,
      7883,
      4649,
      3076,
      999,
      1435,
      7884,
      1004,
      599,
      1520,
      5862,
      602,
      1011,
      122,
      5266,
      7885,
      441,
      1261,
      1902
    ],
  ),
  "detector_status": SymbolsMetadata(
    popularity: 169,
    codepoint: 0xe1e8,
    categories: [10],
    tags: [
      1242,
      1244,
      2480,
      2148,
      1630,
      1632,
      2805,
      7867,
      445,
      898,
      7886,
      999,
      1897,
      4460,
      1004,
      1643,
      819,
      7887,
      1213,
      75,
      602,
      1011,
      122,
      1901,
      5266,
      553,
      2487,
      351,
      441,
      1647,
      2387,
      1523,
      7888
    ],
  ),
  "developer_board": SymbolsMetadata(
    popularity: 1701,
    codepoint: 0xe30d,
    categories: [11],
    tags: [
      6182,
      7889,
      5250,
      7890,
      694,
      4365,
      1186,
      7891,
      2625,
      445,
      1711,
      7892,
      2835,
      246,
      965,
      2751,
      1897,
      7893,
      7894,
      7895,
      7896,
      7897,
      2630,
      7898,
      75,
      3507,
      32,
      7899,
      551
    ],
  ),
  "developer_board_off": SymbolsMetadata(
    popularity: 179,
    codepoint: 0xe4ff,
    categories: [11],
    tags: [
      7900,
      6182,
      7901,
      895,
      5250,
      7902,
      7903,
      694,
      896,
      7904,
      1186,
      7891,
      2625,
      7905,
      7906,
      767,
      1711,
      7907,
      7892,
      7908,
      898,
      965,
      7909,
      7893,
      7894,
      7910,
      7911,
      907,
      909,
      7897,
      2630,
      7912,
      7913,
      914,
      7914
    ],
  ),
  "developer_guide": SymbolsMetadata(
    popularity: 318,
    codepoint: 0xe99e,
    categories: [6],
    tags: [
      7026,
      2622,
      1910,
      7915,
      1670,
      2719,
      2624,
      7506,
      2919,
      1186,
      2625,
      1528,
      1347,
      6726,
      1530,
      3226,
      7916,
      7917,
      482,
      135,
      5485,
      7918,
      4697,
      7919,
      21,
      2630,
      2506,
      75,
      3124,
      5248,
      2181,
      7920,
      1196,
      32,
      495,
      1070,
      5882
    ],
  ),
  "developer_mode": SymbolsMetadata(
    popularity: 1498,
    codepoint: 0xe1b0,
    categories: [11],
    tags: [
      1109,
      1110,
      3105,
      1181,
      419,
      3751,
      3909,
      1113,
      208,
      3592,
      383,
      2624,
      6581,
      268,
      6676,
      1184,
      1185,
      1186,
      7921,
      6596,
      2625,
      445,
      832,
      6584,
      965,
      1114,
      219,
      7922,
      1191,
      3682,
      307,
      656,
      226,
      2630,
      75,
      65,
      446,
      1196,
      32,
      447,
      441
    ],
  ),
  "developer_mode_tv": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xe874,
    categories: [11],
    tags: [
      1109,
      1110,
      3105,
      1230,
      3909,
      3592,
      1684,
      2624,
      6581,
      268,
      1184,
      1185,
      1685,
      6583,
      1186,
      7921,
      2625,
      445,
      4182,
      12,
      965,
      1114,
      1687,
      307,
      327,
      2630,
      330,
      65,
      5872,
      1196,
      343,
      344,
      7923,
      7924,
      7925,
      7926,
      1691,
      1054
    ],
  ),
  "device_band": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf2f5,
    categories: [11],
    tags: [
      989,
      469,
      2588,
      4479,
      7927,
      211,
      7571,
      10,
      445,
      88,
      2926,
      2927,
      4636,
      595,
      5779,
      219,
      327,
      486,
      75,
      3331,
      1929,
      2591,
      5781,
      109,
      551,
      947,
      2102,
      2715,
      2594,
      234,
      7928
    ],
  ),
  "device_hub": SymbolsMetadata(
    popularity: 1250,
    codepoint: 0xe335,
    categories: [11],
    tags: [
      1109,
      1110,
      1994,
      3026,
      383,
      1061,
      7929,
      694,
      921,
      7930,
      211,
      1685,
      445,
      7931,
      7932,
      7933,
      2173,
      2210,
      1711,
      965,
      932,
      3236,
      1114,
      1064,
      6321,
      4052,
      935,
      1067,
      6322,
      219,
      327,
      7934,
      223,
      7935,
      226,
      1665,
      3058,
      32,
      945,
      447,
      551,
      948,
      1701,
      2102,
      2594,
      1691
    ],
  ),
  "device_thermostat": SymbolsMetadata(
    popularity: 2728,
    codepoint: 0xe1ff,
    categories: [11],
    tags: [
      1128,
      7936,
      712,
      269,
      717,
      7937,
      445,
      7938,
      3560,
      3076,
      3235,
      7939,
      723,
      188,
      366,
      634,
      7940,
      3561,
      327,
      889,
      122,
      65,
      1901,
      7941,
      3442,
      727,
      728,
      7942,
      7943,
      729,
      1381,
      731
    ],
  ),
  "device_unknown": SymbolsMetadata(
    popularity: 554,
    codepoint: 0xe339,
    categories: [11],
    tags: [
      4102,
      1109,
      1110,
      738,
      1113,
      445,
      7944,
      6951,
      960,
      965,
      482,
      7945,
      1114,
      484,
      135,
      6938,
      2769,
      6127,
      7946,
      219,
      1675,
      7947,
      226,
      2772,
      4103,
      979,
      4104,
      4105,
      75,
      77,
      980,
      446,
      495,
      35,
      447,
      7948,
      7949,
      1364,
      7950,
      7951
    ],
  ),
  "devices": SymbolsMetadata(
    popularity: 7183,
    codepoint: 0xe1b1,
    categories: [11],
    tags: [
      1109,
      1110,
      4080,
      208,
      443,
      694,
      211,
      1685,
      445,
      7952,
      88,
      832,
      1711,
      965,
      5091,
      1114,
      4052,
      935,
      5868,
      219,
      327,
      223,
      3000,
      6839,
      226,
      7953,
      75,
      7813,
      77,
      330,
      3058,
      446,
      32,
      1667,
      447,
      551,
      7954,
      2007,
      2102,
      2594,
      1691
    ],
  ),
  "devices_fold": SymbolsMetadata(
    popularity: 268,
    codepoint: 0xebde,
    categories: [4],
    tags: [
      1109,
      1110,
      1367,
      1910,
      7915,
      1113,
      2950,
      7955,
      2896,
      2448,
      2449,
      445,
      7952,
      4834,
      7956,
      787,
      6665,
      7957,
      7958,
      965,
      7959,
      1114,
      1066,
      306,
      2307,
      788,
      2928,
      219,
      7821,
      2653,
      1770,
      226,
      2280,
      330,
      2993,
      1378,
      447,
      2949,
      1054
    ],
  ),
  "devices_fold_2": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf406,
    categories: [4],
    tags: [
      1109,
      1110,
      3042,
      1113,
      2950,
      2896,
      1062,
      445,
      1347,
      7956,
      787,
      1530,
      6665,
      7957,
      965,
      900,
      7959,
      1114,
      4965,
      2307,
      2928,
      219,
      2653,
      1081,
      1534,
      7960,
      226,
      2948,
      330,
      2997,
      107,
      1070,
      447,
      2949,
      1054
    ],
  ),
  "devices_off": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf7a5,
    categories: [11],
    tags: [
      1109,
      1110,
      2033,
      1074,
      895,
      2053,
      208,
      2950,
      694,
      7961,
      4565,
      896,
      897,
      1685,
      3303,
      445,
      2673,
      7952,
      2969,
      1077,
      7962,
      7963,
      7964,
      7965,
      767,
      7966,
      7967,
      3306,
      7968,
      7969,
      4251,
      898,
      2189,
      2985,
      899,
      965,
      1114,
      4052,
      1602,
      935,
      903,
      5868,
      219,
      327,
      1164,
      223,
      7970,
      2043,
      7971,
      7972,
      7973,
      7974,
      2680,
      7975,
      7976,
      2045,
      907,
      908,
      909,
      226,
      7953,
      6602,
      5869,
      75,
      911,
      7977,
      7978,
      912,
      330,
      3058,
      913,
      1170,
      914,
      446,
      32,
      1083,
      7979,
      7980,
      7981,
      7982,
      447,
      5587,
      915,
      3312,
      7983,
      2102,
      2594,
      1691,
      234
    ],
  ),
  "devices_other": SymbolsMetadata(
    popularity: 1192,
    codepoint: 0xe337,
    categories: [11],
    tags: [
      1109,
      1110,
      7984,
      1229,
      1230,
      379,
      1113,
      1684,
      211,
      3234,
      2515,
      1685,
      445,
      2673,
      7952,
      88,
      7985,
      1711,
      2590,
      930,
      965,
      1114,
      1896,
      1897,
      7986,
      1687,
      219,
      327,
      7934,
      2451,
      4483,
      226,
      1194,
      75,
      7987,
      6616,
      446,
      2591,
      32,
      1667,
      447,
      551,
      417,
      405,
      2102,
      2594,
      2596,
      1054
    ],
  ),
  "devices_wearables": SymbolsMetadata(
    popularity: 169,
    codepoint: 0xf6ab,
    categories: [11],
    tags: [
      2587,
      469,
      379,
      1133,
      1113,
      472,
      383,
      1016,
      211,
      269,
      445,
      7952,
      88,
      1711,
      2590,
      965,
      1114,
      2629,
      1896,
      1897,
      935,
      936,
      219,
      486,
      4483,
      226,
      75,
      77,
      330,
      65,
      3237,
      446,
      2591,
      1667,
      447,
      551,
      38,
      289,
      2593,
      405,
      2102,
      7988,
      2596,
      1691,
      2598
    ],
  ),
  "dew_point": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf879,
    categories: [3],
    tags: [
      2513,
      1847,
      7479,
      712,
      5722,
      6247,
      7989,
      7990,
      7991,
      4473,
      7992,
      7993,
      5724,
      6393,
      1904,
      16,
      188,
      597,
      634,
      1857,
      1877,
      2799,
      1363,
      7994,
      7486,
      7995,
      35,
      727,
      7943,
      7996,
      2801,
      7997,
      731
    ],
  ),
  "diagnosis": SymbolsMetadata(
    popularity: 114,
    codepoint: 0xe0a8,
    categories: [12],
    tags: [
      2513,
      2514,
      799,
      4454,
      7724,
      10,
      2413,
      1528,
      1347,
      6874,
      1530,
      1598,
      595,
      7998,
      1753,
      4457,
      135,
      19,
      4770,
      1757,
      7999,
      1532,
      1534,
      1535,
      1762,
      1765,
      121,
      75,
      1353,
      4477,
      77,
      1214,
      4463,
      4648,
      1905,
      704
    ],
  ),
  "diagonal_line": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf41e,
    categories: [12],
    tags: [
      378,
      8000,
      1343,
      8001,
      1182,
      920,
      383,
      953,
      921,
      211,
      2969,
      924,
      1370,
      956,
      2834,
      696,
      2299,
      8002,
      8003,
      304,
      929,
      1064,
      1602,
      935,
      223,
      8004,
      1586,
      3641,
      8005,
      1503,
      2264,
      311,
      8006,
      8007,
      32,
      945
    ],
  ),
  "dialer_sip": SymbolsMetadata(
    popularity: 267,
    codepoint: 0xe0bb,
    categories: [7],
    tags: [
      4,
      5411,
      1133,
      7795,
      1113,
      8,
      443,
      5400,
      921,
      475,
      445,
      1308,
      8008,
      8009,
      14,
      1309,
      8010,
      965,
      8011,
      215,
      8012,
      8013,
      19,
      219,
      8014,
      8015,
      8016,
      226,
      5407,
      5081,
      1318,
      3228,
      8017,
      8018,
      8019,
      8020,
      35,
      496,
      438,
      439,
      1320,
      38,
      40,
      1161,
      5421,
      8021,
      5466,
      8022
    ],
  ),
  "dialogs": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xe99f,
    categories: [2],
    tags: [
      949,
      469,
      1229,
      1230,
      7,
      471,
      5174,
      472,
      473,
      6735,
      443,
      2750,
      476,
      299,
      477,
      8023,
      478,
      480,
      481,
      135,
      2751,
      306,
      485,
      2341,
      6052,
      219,
      327,
      8024,
      8025,
      486,
      226,
      1049,
      330,
      2882,
      492,
      493,
      32,
      944,
      447,
      496,
      8026,
      3159,
      2757,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "dialpad": SymbolsMetadata(
    popularity: 1429,
    codepoint: 0xe0bc,
    categories: [7],
    tags: [
      3638,
      952,
      1133,
      953,
      443,
      475,
      445,
      1308,
      8027,
      50,
      956,
      246,
      966,
      2751,
      970,
      219,
      8028,
      24,
      7205,
      8029,
      8030,
      226,
      8031,
      446,
      1320,
      8032,
      8033,
      8034,
      5410
    ],
  ),
  "diamond": SymbolsMetadata(
    popularity: 4496,
    codepoint: 0xead5,
    categories: [3],
    tags: [
      3,
      5249,
      3671,
      8035,
      1416,
      8036,
      8037,
      8038,
      2705,
      1418,
      8039,
      8040,
      1659,
      8041,
      8042,
      2528,
      1944,
      3118,
      1361,
      1662,
      531,
      62,
      1296,
      3584,
      311,
      8043,
      2487,
      8044,
      8045,
      8046,
      8047,
      5767,
      3324
    ],
  ),
  "dictionary": SymbolsMetadata(
    popularity: 223,
    codepoint: 0xf539,
    categories: [12],
    tags: [
      686,
      4,
      1910,
      668,
      4704,
      3153,
      4705,
      8048,
      135,
      4688,
      5651,
      3375,
      4706,
      8049,
      2159,
      366,
      972,
      3463,
      1534,
      2506,
      2507,
      3124,
      3158,
      980,
      4691,
      38,
      4693,
      8050,
      8051,
      8052,
      8053
    ],
  ),
  "difference": SymbolsMetadata(
    popularity: 1477,
    codepoint: 0xeb7d,
    categories: [12],
    tags: [
      3313,
      526,
      794,
      2375,
      6005,
      3812,
      3813,
      1042,
      1734,
      1707,
      5808,
      1694,
      8054,
      5333,
      8055,
      6799,
      1528,
      1347,
      2999,
      1530,
      1655,
      6007,
      1066,
      1210,
      1116,
      2557,
      1081,
      2841,
      202,
      2264,
      7387,
      107,
      1122,
      8056,
      8057,
      6011
    ],
  ),
  "digital_out_of_home": SymbolsMetadata(
    popularity: 288,
    codepoint: 0xf1de,
    categories: [0],
    tags: [
      1037,
      8058,
      2602,
      443,
      8059,
      8060,
      12,
      8061,
      135,
      8062,
      8063,
      1045,
      367,
      421,
      8064,
      8065,
      489,
      2162,
      1050,
      8066,
      8067,
      330,
      1589,
      1701,
      2621,
      3939,
      3229
    ],
  ),
  "digital_wellbeing": SymbolsMetadata(
    popularity: 234,
    codepoint: 0xef86,
    categories: [3],
    tags: [
      468,
      1229,
      1230,
      794,
      584,
      3600,
      383,
      88,
      8068,
      8069,
      8070,
      1190,
      595,
      8071,
      8072,
      8073,
      4457,
      483,
      4770,
      8074,
      8075,
      6635,
      8076,
      489,
      490,
      8077,
      8078,
      8079,
      501,
      8080,
      4648,
      8081,
      1905
    ],
  ),
  "dining": SymbolsMetadata(
    popularity: 903,
    codepoint: 0xeff4,
    categories: [8],
    tags: [
      7,
      3790,
      3792,
      8082,
      6165,
      8083,
      3798,
      8084,
      3799,
      4277,
      3800,
      3801,
      8085,
      7128,
      1829,
      8086,
      2000,
      8087,
      3803,
      3804,
      788,
      8088,
      3807,
      1960,
      8089,
      3809,
      8090,
      32,
      8091,
      8092,
      6377
    ],
  ),
  "dinner_dining": SymbolsMetadata(
    popularity: 973,
    codepoint: 0xea57,
    categories: [16],
    tags: [
      3790,
      6165,
      6169,
      6170,
      3798,
      3799,
      4277,
      8093,
      8094,
      3800,
      8095,
      7128,
      1829,
      4975,
      2000,
      4219,
      8096,
      3803,
      3804,
      4978,
      8097,
      8098,
      6615,
      3807,
      8089,
      8099,
      8091,
      4285,
      6377,
      8100
    ],
  ),
  "directions": SymbolsMetadata(
    popularity: 1708,
    codepoint: 0xe52e,
    categories: [5],
    tags: [
      380,
      8101,
      776,
      1062,
      1416,
      388,
      1578,
      777,
      1488,
      3225,
      1001,
      1002,
      1490,
      421,
      780,
      1586,
      781,
      2452,
      1396,
      3227,
      1587,
      396,
      1503,
      4101,
      32,
      1589,
      1590,
      2008,
      1504,
      402,
      8102,
      3229
    ],
  ),
  "directions_alt": SymbolsMetadata(
    popularity: 251,
    codepoint: 0xf880,
    categories: [5],
    tags: [
      380,
      776,
      1484,
      1416,
      8103,
      1578,
      8104,
      8105,
      777,
      1488,
      1001,
      1002,
      1490,
      421,
      780,
      1586,
      2865,
      781,
      1396,
      782,
      396,
      1503,
      3228,
      4101,
      32,
      1424,
      1590,
      1504,
      3229
    ],
  ),
  "directions_alt_off": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf881,
    categories: [5],
    tags: [
      8106,
      8107,
      2441,
      8108,
      380,
      3302,
      1578,
      8109,
      8110,
      1077,
      767,
      898,
      1488,
      8111,
      8112,
      901,
      1001,
      8113,
      8114,
      1002,
      8115,
      8116,
      1490,
      421,
      8117,
      8118,
      8119,
      8120,
      8121,
      907,
      909,
      1396,
      1503,
      7102,
      4101,
      914,
      32,
      1590
    ],
  ),
  "directions_bike": SymbolsMetadata(
    popularity: 3017,
    codepoint: 0xe52f,
    categories: [14],
    tags: [
      989,
      4313,
      4314,
      8122,
      383,
      2063,
      386,
      4328,
      388,
      1578,
      2925,
      2927,
      1488,
      483,
      16,
      3344,
      1001,
      1002,
      1490,
      421,
      489,
      2071,
      3347,
      2072,
      8123,
      1503,
      105,
      5781,
      750,
      1930,
      1504,
      4342
    ],
  ),
  "directions_boat": SymbolsMetadata(
    popularity: 2138,
    codepoint: 0xe532,
    categories: [14],
    tags: [
      1814,
      2521,
      1815,
      4613,
      1816,
      4599,
      388,
      1578,
      8124,
      8125,
      4601,
      1490,
      2529,
      2530,
      2532,
      421,
      2533,
      1922,
      2071,
      8126,
      8127,
      2476,
      2535,
      4606,
      2023,
      1842,
      1930,
      1504,
      1844,
      6369,
      4607,
      2801,
      8128,
      1862,
      1902
    ],
  ),
  "directions_bus": SymbolsMetadata(
    popularity: 3385,
    codepoint: 0xe530,
    categories: [14],
    tags: [
      1814,
      2062,
      5227,
      5222,
      1815,
      1816,
      7742,
      2063,
      1484,
      1578,
      1581,
      1001,
      1002,
      1490,
      421,
      1922,
      2071,
      4603,
      5230,
      2072,
      1503,
      2073,
      2008,
      1842,
      1930,
      5236,
      1504,
      5237,
      1591,
      1844
    ],
  ),
  "directions_car": SymbolsMetadata(
    popularity: 10480,
    codepoint: 0xe531,
    categories: [14],
    tags: [
      2014,
      1131,
      1814,
      3467,
      1815,
      8129,
      1816,
      2063,
      2016,
      1484,
      388,
      1578,
      3484,
      8130,
      8131,
      8132,
      1488,
      1581,
      1001,
      1490,
      421,
      2071,
      2072,
      4518,
      1503,
      8133,
      1590,
      1842,
      1930,
      1504,
      1591,
      1844
    ],
  ),
  "directions_off": SymbolsMetadata(
    popularity: 140,
    codepoint: 0xf10f,
    categories: [5],
    tags: [
      380,
      8134,
      8135,
      8136,
      3302,
      1578,
      8137,
      8138,
      8139,
      8140,
      8141,
      767,
      898,
      1488,
      8112,
      1001,
      8114,
      1002,
      1490,
      421,
      8142,
      8120,
      8143,
      8121,
      8144,
      907,
      909,
      1396,
      1503,
      7102,
      4101,
      914,
      1590,
      8145
    ],
  ),
  "directions_railway": SymbolsMetadata(
    popularity: 401,
    codepoint: 0xe534,
    categories: [14],
    tags: [
      2014,
      1814,
      1815,
      6229,
      1816,
      2063,
      2016,
      1484,
      388,
      4615,
      1581,
      1602,
      4618,
      1490,
      7744,
      1922,
      2071,
      7745,
      4603,
      4620,
      8146,
      4621,
      3611,
      4623,
      2165,
      4624,
      4625,
      2008,
      1842,
      1930,
      1504,
      1591,
      1625,
      8147,
      1844
    ],
  ),
  "directions_railway_2": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf462,
    categories: [14],
    tags: [
      2014,
      6229,
      2063,
      2016,
      1484,
      4615,
      1581,
      1602,
      4618,
      7744,
      1922,
      1194,
      4603,
      4620,
      8146,
      4621,
      1503,
      3611,
      4623,
      2165,
      3112,
      4624,
      2008,
      1842,
      1930,
      1504,
      1591,
      8147
    ],
  ),
  "directions_run": SymbolsMetadata(
    popularity: 4821,
    codepoint: 0xe566,
    categories: [14],
    tags: [
      8148,
      584,
      1578,
      2925,
      1022,
      4410,
      2927,
      483,
      8149,
      8150,
      1002,
      1490,
      8151,
      420,
      778,
      8152,
      421,
      488,
      489,
      1027,
      8153,
      8154,
      1503,
      8155,
      8156,
      2932,
      5781,
      3595,
      8157,
      8158,
      750,
      3206
    ],
  ),
  "directions_subway": SymbolsMetadata(
    popularity: 579,
    codepoint: 0xe533,
    categories: [14],
    tags: [
      2014,
      1814,
      1815,
      1816,
      2602,
      2063,
      2016,
      1484,
      388,
      1578,
      1581,
      1602,
      8159,
      1490,
      7744,
      8160,
      421,
      2071,
      4603,
      5230,
      4620,
      8146,
      4621,
      1503,
      3611,
      4623,
      4624,
      4625,
      2008,
      1842,
      1930,
      1504,
      1625,
      8161,
      8147,
      8162,
      2621,
      1844
    ],
  ),
  "directions_walk": SymbolsMetadata(
    popularity: 4130,
    codepoint: 0xe536,
    categories: [14],
    tags: [
      584,
      2063,
      8163,
      388,
      1578,
      4410,
      6106,
      3930,
      483,
      8150,
      1581,
      4939,
      1490,
      778,
      1858,
      421,
      8065,
      8164,
      488,
      489,
      8165,
      1503,
      8155,
      3935,
      109,
      8166,
      1504,
      8167,
      3206,
      3207,
      3939,
      8168,
      3229,
      8169
    ],
  ),
  "directory_sync": SymbolsMetadata(
    popularity: 136,
    codepoint: 0xe394,
    categories: [2],
    tags: [
      2284,
      419,
      1651,
      383,
      384,
      6548,
      385,
      6507,
      388,
      6936,
      2627,
      1530,
      3052,
      1656,
      6007,
      390,
      421,
      424,
      425,
      2843,
      3749,
      396,
      889,
      5256,
      1667,
      3529,
      8170,
      2455,
      1260,
      6011
    ],
  ),
  "dirty_lens": SymbolsMetadata(
    popularity: 200,
    codepoint: 0xef4b,
    categories: [1],
    tags: [
      469,
      8171,
      8172,
      8173,
      47,
      8174,
      8175,
      8176,
      4005,
      8177,
      8178,
      8179,
      8180,
      5111,
      126,
      8181,
      8182,
      2770,
      8183,
      8184,
      59,
      8185,
      61,
      8186,
      119,
      8187,
      3474,
      8188,
      8189,
      8190,
      8191,
      8192,
      8193,
      1261
    ],
  ),
  "disabled_by_default": SymbolsMetadata(
    popularity: 5034,
    codepoint: 0xf230,
    categories: [2],
    tags: [
      1074,
      7,
      7276,
      895,
      3436,
      2950,
      1202,
      1076,
      4827,
      897,
      1077,
      767,
      8194,
      2985,
      529,
      899,
      901,
      3696,
      4145,
      907,
      281,
      285,
      4449,
      4451,
      911,
      171,
      310,
      32,
      1083,
      314,
      915,
      3736
    ],
  ),
  "disabled_visible": SymbolsMetadata(
    popularity: 1176,
    codepoint: 0xe76e,
    categories: [13],
    tags: [
      8195,
      895,
      8196,
      383,
      8197,
      2950,
      767,
      2985,
      6300,
      8198,
      8199,
      8200,
      8201,
      1078,
      900,
      1856,
      4145,
      8202,
      8203,
      909,
      4451,
      911,
      8204,
      2948,
      981,
      2997,
      8205,
      8206,
      8207,
      914,
      1083,
      8208,
      8209,
      317,
      8210,
      8211,
      5024,
      8212,
      8213,
      8214,
      8215
    ],
  ),
  "disc_full": SymbolsMetadata(
    popularity: 350,
    codepoint: 0xe610,
    categories: [11],
    tags: [
      3175,
      469,
      3073,
      8216,
      4054,
      8217,
      1693,
      2154,
      383,
      1732,
      3176,
      10,
      7546,
      3744,
      2156,
      8218,
      8219,
      8220,
      2766,
      2767,
      3177,
      4043,
      8221,
      8222,
      1251,
      135,
      459,
      1641,
      2081,
      8223,
      486,
      8224,
      8225,
      2772,
      674,
      8226,
      8227,
      35,
      1261
    ],
  ),
  "discover_tune": SymbolsMetadata(
    popularity: 1432,
    codepoint: 0xe018,
    categories: [0],
    tags: [
      1128,
      5061,
      1129,
      794,
      365,
      785,
      1202,
      1735,
      955,
      696,
      2299,
      8228,
      8229,
      958,
      959,
      960,
      277,
      8230,
      366,
      1740,
      2081,
      763,
      656,
      5922,
      202,
      329,
      310,
      65,
      1743,
      1156,
      751,
      441,
      1744,
      8231,
      1745
    ],
  ),
  "dishwasher": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xe9a0,
    categories: [8],
    tags: [
      1888,
      8232,
      8233,
      8234,
      1871,
      8235,
      4005,
      8094,
      8236,
      8237,
      7214,
      1433,
      1500,
      4473,
      999,
      1895,
      1435,
      1436,
      6350,
      3802,
      8238,
      1717,
      32,
      4001,
      8239,
      8240,
      8241,
      8242,
      2801,
      8243
    ],
  ),
  "dishwasher_gen": SymbolsMetadata(
    popularity: 431,
    codepoint: 0xe832,
    categories: [8],
    tags: [
      1888,
      8232,
      1132,
      8234,
      953,
      1871,
      8235,
      4005,
      3795,
      4388,
      8236,
      8237,
      956,
      1500,
      4473,
      4074,
      999,
      3235,
      1435,
      6350,
      16,
      3802,
      1717,
      1004,
      75,
      77,
      1901,
      32,
      35,
      5138,
      4001,
      8240,
      2801,
      8243
    ],
  ),
  "display_external_input": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf7e7,
    categories: [4],
    tags: [
      380,
      2053,
      921,
      8244,
      2391,
      12,
      325,
      8245,
      8246,
      8247,
      2054,
      8248,
      8249,
      274,
      5273,
      306,
      935,
      8250,
      778,
      8251,
      2398,
      1719,
      2400,
      3156,
      2055,
      1396,
      782,
      330,
      2056,
      5874,
      7822,
      1665,
      32,
      2057,
      1054,
      2059
    ],
  ),
  "display_settings": SymbolsMetadata(
    popularity: 1558,
    codepoint: 0xeb97,
    categories: [11],
    tags: [
      1109,
      1110,
      1128,
      5061,
      1230,
      1728,
      1731,
      1684,
      268,
      1733,
      1734,
      785,
      6676,
      1735,
      1685,
      132,
      445,
      12,
      8252,
      8253,
      8254,
      696,
      3485,
      965,
      1114,
      53,
      484,
      135,
      1687,
      1740,
      327,
      618,
      656,
      790,
      329,
      30,
      330,
      3151,
      2631,
      65,
      2649,
      1743,
      41,
      1691,
      1054
    ],
  ),
  "distance": SymbolsMetadata(
    popularity: 108,
    codepoint: 0xf6ea,
    categories: [15],
    tags: [
      1429,
      1483,
      1484,
      388,
      1578,
      588,
      1500,
      958,
      960,
      1486,
      1487,
      1488,
      8255,
      1001,
      8256,
      1002,
      6280,
      1490,
      21,
      421,
      1493,
      1494,
      1495,
      1363,
      1496,
      6959,
      1503,
      980,
      1083,
      5610,
      947,
      1504
    ],
  ),
  "diversity_1": SymbolsMetadata(
    popularity: 3806,
    codepoint: 0xf8d7,
    categories: [3],
    tags: [
      8257,
      1059,
      3281,
      1134,
      194,
      211,
      8258,
      1063,
      8259,
      742,
      867,
      1137,
      5071,
      930,
      6770,
      4457,
      7706,
      483,
      1141,
      747,
      8260,
      8261,
      223,
      940,
      8262,
      488,
      1151,
      5248,
      607,
      495,
      946,
      983,
      499,
      8263,
      8264,
      1159
    ],
  ),
  "diversity_2": SymbolsMetadata(
    popularity: 2830,
    codepoint: 0xf8d8,
    categories: [3],
    tags: [
      3325,
      733,
      8265,
      383,
      3281,
      1134,
      194,
      211,
      8258,
      8259,
      742,
      3817,
      3818,
      8266,
      867,
      1137,
      1791,
      5071,
      930,
      6770,
      4457,
      483,
      1141,
      850,
      747,
      7414,
      8267,
      1000,
      390,
      8261,
      223,
      940,
      488,
      1151,
      8153,
      5607,
      5248,
      607,
      946,
      374,
      8263,
      1701,
      8264
    ],
  ),
  "diversity_3": SymbolsMetadata(
    popularity: 7962,
    codepoint: 0xf8d9,
    categories: [3],
    tags: [
      8257,
      3281,
      1134,
      194,
      8268,
      211,
      1063,
      8259,
      742,
      867,
      1137,
      930,
      6770,
      7706,
      7707,
      1141,
      747,
      223,
      940,
      8262,
      488,
      1151,
      7708,
      607,
      7709,
      495,
      946,
      6807,
      983,
      499,
      8263,
      8264,
      8269
    ],
  ),
  "diversity_4": SymbolsMetadata(
    popularity: 270,
    codepoint: 0xf857,
    categories: [3],
    tags: [
      2716,
      8265,
      7258,
      3281,
      1134,
      194,
      7354,
      211,
      8259,
      742,
      8270,
      867,
      1137,
      2737,
      930,
      6770,
      8070,
      4457,
      8271,
      1141,
      747,
      7361,
      4770,
      223,
      8272,
      488,
      1151,
      8005,
      8273,
      607,
      495,
      946,
      983,
      499,
      8263,
      8274,
      8264
    ],
  ),
  "dns": SymbolsMetadata(
    popularity: 4970,
    codepoint: 0xe875,
    categories: [11],
    tags: [
      755,
      1429,
      365,
      1652,
      694,
      268,
      211,
      10,
      3756,
      8275,
      8276,
      5073,
      135,
      5074,
      215,
      5076,
      8277,
      92,
      972,
      3764,
      8278,
      223,
      819,
      2294,
      121,
      8279,
      3761,
      2631,
      65,
      107,
      674,
      2632,
      551,
      5138,
      8280,
      1053
    ],
  ),
  "do_not_disturb_off": SymbolsMetadata(
    popularity: 888,
    codepoint: 0xe643,
    categories: [2],
    tags: [
      8281,
      8282,
      8283,
      8284,
      8285,
      3063,
      895,
      4438,
      2950,
      4440,
      2448,
      4442,
      8286,
      767,
      4443,
      8287,
      8288,
      8289,
      8290,
      898,
      8291,
      901,
      8292,
      907,
      909,
      8293,
      911,
      8294,
      8295,
      1170,
      8296,
      8297,
      8298,
      1083,
      2126,
      8299,
      8300,
      8301,
      8302
    ],
  ),
  "do_not_disturb_on": SymbolsMetadata(
    popularity: 8646,
    codepoint: 0xe644,
    categories: [2],
    tags: [
      1074,
      895,
      383,
      8303,
      2950,
      2448,
      897,
      4442,
      8286,
      1077,
      767,
      4443,
      4250,
      8288,
      4251,
      898,
      2766,
      899,
      900,
      1116,
      1164,
      3696,
      4145,
      8304,
      486,
      907,
      908,
      909,
      1361,
      911,
      3310,
      1170,
      553,
      1083,
      1122,
      915,
      1261
    ],
  ),
  "do_not_disturb_on_total_silence": SymbolsMetadata(
    popularity: 337,
    codepoint: 0xeffb,
    categories: [4],
    tags: [
      8305,
      8306,
      4214,
      1074,
      8307,
      383,
      8308,
      4264,
      2448,
      4443,
      4250,
      8288,
      4251,
      1738,
      899,
      8309,
      1116,
      1164,
      4145,
      8310,
      8311,
      1169,
      8304,
      8312,
      8313,
      8314,
      1516,
      2123,
      8315,
      1170,
      8316,
      1929,
      8317,
      8318,
      8319,
      8320
    ],
  ),
  "do_not_step": SymbolsMetadata(
    popularity: 273,
    codepoint: 0xf19f,
    categories: [16],
    tags: [
      892,
      8306,
      3074,
      895,
      1693,
      1202,
      2969,
      767,
      8288,
      8321,
      8322,
      898,
      590,
      1954,
      899,
      4649,
      8323,
      3696,
      7011,
      8324,
      8325,
      8326,
      8304,
      8004,
      907,
      909,
      4450,
      1009,
      171,
      602,
      8327,
      8328,
      914,
      8329,
      3935,
      8330,
      109,
      2126,
      1261,
      3736
    ],
  ),
  "do_not_touch": SymbolsMetadata(
    popularity: 445,
    codepoint: 0xf1b0,
    categories: [16],
    tags: [
      892,
      1074,
      895,
      1693,
      8286,
      3304,
      767,
      8288,
      8321,
      8331,
      8332,
      898,
      2734,
      899,
      3616,
      2735,
      2738,
      8333,
      8334,
      2678,
      7011,
      8335,
      8304,
      907,
      8336,
      909,
      1517,
      4450,
      1520,
      1009,
      171,
      602,
      1011,
      914,
      1083,
      2126,
      8034,
      8337,
      1261
    ],
  ),
  "dock": SymbolsMetadata(
    popularity: 250,
    codepoint: 0xe30e,
    categories: [11],
    tags: [
      1109,
      1110,
      2587,
      1058,
      4312,
      1113,
      3774,
      383,
      921,
      211,
      4365,
      3050,
      445,
      2522,
      4320,
      832,
      1711,
      965,
      1114,
      966,
      1044,
      2751,
      219,
      1719,
      8338,
      226,
      1194,
      4373,
      2534,
      3782,
      75,
      77,
      446,
      4325,
      3611,
      1667,
      447,
      551
    ],
  ),
  "dock_to_bottom": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf7e6,
    categories: [4],
    tags: [
      2167,
      2520,
      1230,
      1367,
      4312,
      2188,
      4873,
      12,
      2522,
      8339,
      2751,
      306,
      778,
      98,
      1770,
      3421,
      1493,
      2820,
      1496,
      2648,
      75,
      2247,
      330,
      8340,
      8341,
      32,
      8342,
      4079,
      317,
      7503,
      1054,
      2746
    ],
  ),
  "dock_to_left": SymbolsMetadata(
    popularity: 180,
    codepoint: 0xf7e5,
    categories: [4],
    tags: [
      1229,
      1230,
      1367,
      4834,
      2522,
      8343,
      2751,
      306,
      8344,
      778,
      421,
      98,
      1770,
      3421,
      1496,
      75,
      2247,
      8345,
      1377,
      2238,
      8346,
      2993,
      8341,
      1378,
      8347,
      6257,
      32,
      1215,
      317,
      1054,
      8348,
      2746
    ],
  ),
  "dock_to_right": SymbolsMetadata(
    popularity: 68,
    codepoint: 0xf7e4,
    categories: [4],
    tags: [
      8349,
      8350,
      1367,
      2232,
      2522,
      8351,
      8352,
      306,
      2235,
      1770,
      3421,
      8353,
      75,
      7073,
      2247,
      8354,
      8355,
      8356,
      8345,
      2238,
      8346,
      2993,
      8341,
      1378,
      8347,
      6257,
      32,
      441,
      8280,
      1215,
      8357,
      1054,
      8348,
      2746
    ],
  ),
  "docs": SymbolsMetadata(
    popularity: 2545,
    codepoint: 0xea7d,
    categories: [12],
    tags: [
      2501,
      1466,
      1042,
      1201,
      10,
      1528,
      8358,
      1347,
      337,
      1654,
      696,
      1530,
      1656,
      1657,
      1598,
      135,
      366,
      92,
      763,
      1532,
      1533,
      2653,
      1534,
      1535,
      2506,
      1353,
      1664,
      4788,
      4789,
      38,
      346,
      317,
      704
    ],
  ),
  "docs_add_on": SymbolsMetadata(
    popularity: 742,
    codepoint: 0xf0c2,
    categories: [12],
    tags: [
      526,
      1341,
      1228,
      8359,
      8360,
      1057,
      1058,
      1201,
      1526,
      1347,
      787,
      8361,
      1530,
      7720,
      1204,
      1207,
      1044,
      366,
      92,
      763,
      1350,
      1534,
      4131,
      202,
      107,
      6330,
      38,
      441
    ],
  ),
  "docs_apps_script": SymbolsMetadata(
    popularity: 156,
    codepoint: 0xf0c3,
    categories: [12],
    tags: [
      526,
      1229,
      1230,
      2657,
      1367,
      2148,
      1731,
      266,
      1776,
      2624,
      6581,
      1781,
      8358,
      1347,
      696,
      2299,
      7720,
      2738,
      1044,
      366,
      92,
      1740,
      96,
      3021,
      1783,
      3379,
      288,
      371,
      107,
      441
    ],
  ),
  "document_scanner": SymbolsMetadata(
    popularity: 2311,
    codepoint: 0xe5fa,
    categories: [12],
    tags: [
      8362,
      2501,
      3909,
      116,
      1707,
      2391,
      10,
      3113,
      1709,
      8363,
      1528,
      1347,
      8364,
      8365,
      1654,
      1530,
      1656,
      1657,
      53,
      2811,
      1542,
      366,
      1533,
      8366,
      1534,
      1535,
      59,
      119,
      121,
      75,
      1723,
      8367,
      1724,
      4788,
      4789,
      32,
      38,
      346,
      704
    ],
  ),
  "document_search": SymbolsMetadata(
    popularity: 79,
    codepoint: 0xf385,
    categories: [12],
    tags: [
      2513,
      1042,
      10,
      955,
      1528,
      1347,
      8368,
      8369,
      1654,
      958,
      8370,
      1530,
      8371,
      8372,
      959,
      960,
      8373,
      8374,
      1656,
      1657,
      964,
      135,
      4296,
      8375,
      967,
      971,
      8376,
      973,
      974,
      975,
      976,
      8377,
      1534,
      1535,
      2506,
      4361,
      980,
      8378,
      7604,
      8379,
      981,
      4788,
      4789,
      38,
      704,
      986
    ],
  ),
  "domain": SymbolsMetadata(
    popularity: 4817,
    codepoint: 0xe7ee,
    categories: [9],
    tags: [
      1429,
      2600,
      2601,
      1074,
      798,
      1284,
      5240,
      803,
      1285,
      8380,
      8276,
      5244,
      2626,
      2605,
      246,
      8381,
      999,
      6924,
      3170,
      1001,
      1456,
      940,
      1495,
      1444,
      2614,
      1445,
      75,
      1446,
      2616,
      2617,
      2882,
      2618,
      32,
      441,
      2620,
      1691,
      1054,
      1459,
      5655
    ],
  ),
  "domain_add": SymbolsMetadata(
    popularity: 894,
    codepoint: 0xeb62,
    categories: [9],
    tags: [
      192,
      468,
      526,
      8382,
      2600,
      2601,
      1058,
      798,
      1284,
      1285,
      8383,
      921,
      1201,
      8384,
      8276,
      8385,
      8386,
      8387,
      2605,
      787,
      1204,
      999,
      215,
      1064,
      223,
      763,
      8388,
      1456,
      940,
      1495,
      202,
      2614,
      1256,
      1446,
      2616,
      2617,
      857,
      35,
      1691,
      8389,
      1053,
      5655
    ],
  ),
  "domain_disabled": SymbolsMetadata(
    popularity: 693,
    codepoint: 0xe0ef,
    categories: [9],
    tags: [
      892,
      2600,
      2601,
      1074,
      894,
      798,
      1284,
      1075,
      1285,
      211,
      1076,
      767,
      8276,
      8390,
      2651,
      898,
      2766,
      2605,
      899,
      999,
      5073,
      901,
      215,
      2770,
      1490,
      223,
      2678,
      907,
      1456,
      908,
      909,
      2771,
      1495,
      2772,
      2614,
      1446,
      2616,
      171,
      3761,
      7588,
      914,
      1083,
      8391,
      915,
      1691,
      1053,
      8392
    ],
  ),
  "domain_verification": SymbolsMetadata(
    popularity: 1072,
    codepoint: 0xef4c,
    categories: [6],
    tags: [
      1229,
      8393,
      1549,
      2480,
      1039,
      1630,
      5827,
      1632,
      1633,
      1636,
      2481,
      2376,
      299,
      8276,
      8394,
      8395,
      1639,
      8396,
      2751,
      215,
      306,
      1641,
      1643,
      819,
      1772,
      330,
      1773,
      1011,
      288,
      2882,
      8397,
      1647,
      6088,
      8398,
      2757,
      1479,
      2759,
      2386,
      8399,
      2387,
      2388,
      1523,
      2389,
      1691,
      8389,
      1053,
      8400,
      1054,
      5655,
      1650
    ],
  ),
  "domain_verification_off": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf7b0,
    categories: [6],
    tags: [
      1229,
      8393,
      1549,
      894,
      895,
      2719,
      1630,
      1633,
      897,
      299,
      3304,
      767,
      8276,
      1639,
      898,
      2766,
      8396,
      901,
      2751,
      215,
      8401,
      306,
      1641,
      223,
      2678,
      907,
      908,
      1643,
      909,
      75,
      911,
      912,
      330,
      1011,
      288,
      2882,
      914,
      32,
      8397,
      1647,
      8398,
      2757,
      915,
      2759,
      2386,
      2388,
      1523,
      1261,
      1691,
      1240,
      1053,
      1054,
      5655,
      1650
    ],
  ),
  "domino_mask": SymbolsMetadata(
    popularity: 90,
    codepoint: 0xf5e4,
    categories: [3],
    tags: [
      6692,
      1074,
      3336,
      5150,
      6696,
      8402,
      8403,
      8404,
      8405,
      8406,
      1188,
      697,
      6189,
      1078,
      900,
      850,
      8407,
      6703,
      6704,
      8408,
      487,
      2162,
      1516,
      2948,
      8409,
      2997,
      8410,
      3637,
      8411,
      8412,
      4585
    ],
  ),
  "done_all": SymbolsMetadata(
    popularity: 9061,
    codepoint: 0xe877,
    categories: [2],
    tags: [
      1627,
      2716,
      2325,
      2717,
      1549,
      1630,
      1632,
      8413,
      1633,
      8414,
      8415,
      1636,
      4271,
      1639,
      8416,
      8417,
      8418,
      3065,
      1066,
      1641,
      2557,
      1643,
      288,
      4753,
      371,
      107,
      2487,
      1645,
      3159,
      1647,
      8419,
      315,
      2386,
      8399,
      2387,
      1523,
      1650
    ],
  ),
  "done_outline": SymbolsMetadata(
    popularity: 7768,
    codepoint: 0xe92f,
    categories: [2],
    tags: [
      1627,
      2716,
      1548,
      7026,
      2325,
      2717,
      1549,
      1630,
      8420,
      1631,
      1632,
      1633,
      1635,
      4270,
      1636,
      4271,
      1639,
      1640,
      3065,
      1641,
      1643,
      4752,
      1361,
      288,
      2487,
      1645,
      8421,
      1647,
      6088,
      6085,
      2386,
      2387,
      1523,
      1650
    ],
  ),
  "donut_large": SymbolsMetadata(
    popularity: 1671,
    codepoint: 0xe917,
    categories: [9],
    tags: [
      5,
      2827,
      2565,
      920,
      383,
      5808,
      10,
      924,
      1370,
      6299,
      8422,
      3108,
      8423,
      929,
      8424,
      2659,
      933,
      3524,
      3634,
      2568,
      390,
      597,
      937,
      1361,
      4130,
      1082,
      6418,
      3055,
      28,
      1257,
      4852,
      2542,
      1378,
      33,
      4820,
      6305,
      947,
      8425,
      2147
    ],
  ),
  "donut_small": SymbolsMetadata(
    popularity: 1319,
    codepoint: 0xe918,
    categories: [9],
    tags: [
      3325,
      5,
      1730,
      920,
      383,
      5808,
      10,
      924,
      1370,
      6299,
      8426,
      8427,
      7645,
      1659,
      929,
      8424,
      16,
      188,
      933,
      3524,
      2568,
      597,
      937,
      8428,
      6418,
      5019,
      28,
      1257,
      1377,
      4852,
      1979,
      1378,
      33,
      35,
      6305,
      947
    ],
  ),
  "door_back": SymbolsMetadata(
    popularity: 342,
    codepoint: 0xeffc,
    categories: [8],
    tags: [
      755,
      2601,
      2489,
      798,
      383,
      4430,
      2604,
      6103,
      832,
      6104,
      1597,
      2985,
      274,
      5647,
      2873,
      999,
      1435,
      6244,
      903,
      5653,
      2876,
      75,
      2495,
      2496,
      1960,
      913,
      32,
      563,
      2499,
      2456
    ],
  ),
  "door_front": SymbolsMetadata(
    popularity: 1079,
    codepoint: 0xeffd,
    categories: [8],
    tags: [
      755,
      2601,
      798,
      383,
      2950,
      4430,
      2604,
      8429,
      6103,
      2909,
      6104,
      1597,
      2985,
      3838,
      274,
      5500,
      8430,
      5647,
      999,
      1435,
      2796,
      3408,
      6244,
      2653,
      5653,
      1444,
      75,
      1446,
      1960,
      8431,
      563,
      2456
    ],
  ),
  "door_open": SymbolsMetadata(
    popularity: 1336,
    codepoint: 0xe77c,
    categories: [10],
    tags: [
      755,
      733,
      2601,
      798,
      1016,
      445,
      2604,
      8432,
      6103,
      2909,
      6104,
      1597,
      8433,
      2985,
      3838,
      5647,
      2910,
      999,
      1435,
      2795,
      2796,
      6244,
      1004,
      2653,
      8434,
      3841,
      8435,
      5653,
      1960,
      563,
      766
    ],
  ),
  "door_sensor": SymbolsMetadata(
    popularity: 151,
    codepoint: 0xe28a,
    categories: [10],
    tags: [
      755,
      1244,
      8436,
      8437,
      383,
      4430,
      269,
      2804,
      2805,
      2604,
      8438,
      1597,
      8433,
      3489,
      999,
      3235,
      1896,
      8439,
      1897,
      1602,
      327,
      1004,
      2653,
      1006,
      1444,
      75,
      1011,
      122,
      1901,
      7874,
      553
    ],
  ),
  "door_sliding": SymbolsMetadata(
    popularity: 381,
    codepoint: 0xeffe,
    categories: [8],
    tags: [
      755,
      2601,
      1131,
      1132,
      8440,
      798,
      7211,
      2950,
      3989,
      1370,
      2604,
      6103,
      3108,
      8441,
      8442,
      6104,
      1597,
      2985,
      5647,
      964,
      999,
      1435,
      2796,
      3472,
      2653,
      1770,
      8443,
      8435,
      5653,
      1960,
      8444,
      8445,
      563,
      2571,
      315,
      8446,
      2714
    ],
  ),
  "doorbell": SymbolsMetadata(
    popularity: 347,
    codepoint: 0xefff,
    categories: [8],
    tags: [
      1244,
      469,
      4943,
      2014,
      1246,
      798,
      1248,
      2604,
      8447,
      1597,
      8430,
      8448,
      999,
      3235,
      1435,
      1896,
      1897,
      486,
      3843,
      1444,
      1446,
      1257,
      2098,
      1011,
      227,
      1901,
      1156,
      3768,
      766
    ],
  ),
  "doorbell_3p": SymbolsMetadata(
    popularity: 182,
    codepoint: 0xe1e7,
    categories: [8],
    tags: [
      8449,
      755,
      1242,
      1244,
      469,
      2148,
      1246,
      798,
      298,
      1248,
      383,
      2604,
      8447,
      8450,
      6104,
      1597,
      930,
      8448,
      999,
      1435,
      1896,
      1897,
      1004,
      486,
      1120,
      1254,
      75,
      1030,
      1257,
      1011,
      227,
      1901,
      1156,
      499,
      3768
    ],
  ),
  "doorbell_chime": SymbolsMetadata(
    popularity: 134,
    codepoint: 0xe1f3,
    categories: [10],
    tags: [
      469,
      1129,
      298,
      1248,
      443,
      921,
      445,
      8447,
      6104,
      1597,
      8448,
      999,
      1897,
      1004,
      486,
      5185,
      4988,
      1257,
      77,
      1011,
      227,
      1901,
      1156,
      5138,
      3768,
      1902,
      233,
      234
    ],
  ),
  "double_arrow": SymbolsMetadata(
    popularity: 7915,
    codepoint: 0xea50,
    categories: [2],
    tags: [
      775,
      380,
      419,
      2862,
      776,
      388,
      3108,
      2450,
      3593,
      2999,
      8451,
      8452,
      777,
      2903,
      778,
      2557,
      779,
      421,
      780,
      2162,
      781,
      28,
      2367,
      1396,
      2899,
      2966,
      4789,
      2571,
      2455
    ],
  ),
  "downhill_skiing": SymbolsMetadata(
    popularity: 728,
    codepoint: 0xe509,
    categories: [15],
    tags: [
      989,
      8453,
      8148,
      8454,
      584,
      8455,
      8456,
      3337,
      2925,
      6190,
      483,
      16,
      1544,
      1545,
      488,
      489,
      1967,
      3347,
      4204,
      6000,
      8457,
      8458,
      8459,
      8460,
      8007,
      8461,
      725,
      5781,
      3595,
      750,
      1504,
      2024,
      732,
      5289
    ],
  ),
  "download": SymbolsMetadata(
    popularity: 19008,
    codepoint: 0xf090,
    categories: [2],
    tags: [
      5656,
      380,
      2650,
      5249,
      7,
      1269,
      1042,
      10,
      1347,
      2651,
      337,
      2897,
      8462,
      6519,
      1654,
      1530,
      8463,
      8464,
      1542,
      851,
      1674,
      5660,
      3001,
      2342,
      4068,
      2844,
      1664,
      8465,
      8466,
      441,
      2007,
      2344,
      346,
      1381
    ],
  ),
  "download_2": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xf523,
    categories: [2],
    tags: [
      5656,
      380,
      2650,
      1343,
      2188,
      1042,
      10,
      1347,
      2651,
      337,
      8462,
      2924,
      1654,
      1530,
      2652,
      1542,
      851,
      966,
      1674,
      1602,
      6868,
      5660,
      908,
      3001,
      2342,
      2844,
      1664,
      1667,
      2007,
      1214,
      346
    ],
  ),
  "download_done": SymbolsMetadata(
    popularity: 2284,
    codepoint: 0xf091,
    categories: [2],
    tags: [
      1627,
      2716,
      2717,
      1549,
      380,
      419,
      1630,
      1632,
      1633,
      2481,
      1347,
      1639,
      2651,
      337,
      8467,
      8468,
      8469,
      8470,
      8462,
      1654,
      1530,
      8471,
      8472,
      8473,
      3065,
      1542,
      8474,
      8475,
      1674,
      7750,
      1643,
      1664,
      8476,
      8477,
      2487,
      1647,
      6088,
      346,
      2387
    ],
  ),
  "download_for_offline": SymbolsMetadata(
    popularity: 4228,
    codepoint: 0xf000,
    categories: [2],
    tags: [
      380,
      2650,
      8478,
      1343,
      3521,
      383,
      8479,
      2651,
      337,
      8480,
      2897,
      2924,
      8481,
      2652,
      1542,
      1674,
      8482,
      1602,
      6868,
      8483,
      908,
      8484,
      2046,
      8485,
      8486,
      3001,
      2844,
      1664,
      8466,
      8487,
      1298,
      1667,
      346
    ],
  ),
  "downloading": SymbolsMetadata(
    popularity: 3572,
    codepoint: 0xf001,
    categories: [2],
    tags: [
      8488,
      380,
      2650,
      5249,
      3512,
      383,
      8489,
      3050,
      8490,
      2651,
      337,
      8491,
      8462,
      8463,
      3052,
      2652,
      1542,
      3053,
      188,
      1674,
      3513,
      2568,
      2858,
      3055,
      28,
      2342,
      2844,
      1664,
      1667,
      2007,
      346
    ],
  ),
  "draft": SymbolsMetadata(
    popularity: 6280,
    codepoint: 0xe66d,
    categories: [12],
    tags: [
      526,
      2151,
      1058,
      1652,
      693,
      1042,
      1201,
      10,
      1528,
      1347,
      337,
      1853,
      1654,
      696,
      1672,
      1530,
      1656,
      1657,
      1542,
      1044,
      763,
      1532,
      1534,
      1535,
      1664,
      4788,
      4789,
      674,
      38,
      346,
      1536
    ],
  ),
  "draft_orders": SymbolsMetadata(
    popularity: 53,
    codepoint: 0xe7b3,
    categories: [6],
    tags: [
      1726,
      2488,
      1731,
      383,
      693,
      2376,
      1201,
      1347,
      1853,
      1329,
      696,
      2299,
      966,
      1740,
      1533,
      8492,
      8493,
      1361,
      2693,
      2694,
      8494,
      3184,
      2497,
      889,
      3296,
      3443,
      8495,
      1260,
      6929,
      6930,
      1536,
      704
    ],
  ),
  "drafts": SymbolsMetadata(
    popularity: 2707,
    codepoint: 0xe151,
    categories: [7],
    tags: [
      443,
      693,
      8496,
      2331,
      1347,
      1853,
      8497,
      696,
      2335,
      1530,
      851,
      4706,
      19,
      2340,
      485,
      1408,
      1533,
      3288,
      1361,
      2858,
      7159,
      100,
      2506,
      2342,
      4273,
      2343,
      5171,
      3443,
      8495,
      2664,
      6930,
      704
    ],
  ),
  "drag_click": SymbolsMetadata(
    popularity: 47,
    codepoint: 0xf71f,
    categories: [2],
    tags: [
      1128,
      2827,
      380,
      383,
      953,
      2490,
      1776,
      1777,
      2907,
      1732,
      269,
      3523,
      1781,
      3007,
      8498,
      2735,
      4897,
      2568,
      3020,
      778,
      421,
      423,
      1783,
      5040,
      424,
      425,
      7167,
      396,
      397,
      288,
      371,
      8499,
      65,
      399,
      402
    ],
  ),
  "drag_handle": SymbolsMetadata(
    popularity: 3828,
    codepoint: 0xe25d,
    categories: [12],
    tags: [
      1128,
      1229,
      8500,
      1367,
      4866,
      2750,
      299,
      2138,
      3007,
      8501,
      8502,
      8503,
      3327,
      5659,
      5811,
      2986,
      3489,
      2176,
      2751,
      1620,
      306,
      366,
      92,
      788,
      778,
      656,
      2295,
      1496,
      8504,
      2247,
      330,
      65,
      2882,
      106,
      1214,
      2757,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "drag_indicator": SymbolsMetadata(
    popularity: 7105,
    codepoint: 0xe945,
    categories: [2],
    tags: [
      1128,
      1229,
      1230,
      1367,
      953,
      4866,
      2750,
      269,
      1735,
      299,
      956,
      3007,
      8501,
      8505,
      8503,
      1500,
      8506,
      5811,
      3489,
      188,
      2751,
      306,
      92,
      8507,
      788,
      219,
      327,
      778,
      656,
      226,
      1496,
      8504,
      2247,
      330,
      65,
      311,
      3036,
      2882,
      8508,
      106,
      447,
      8509,
      2757,
      2759,
      8510,
      1691,
      1053,
      1054
    ],
  ),
  "drag_pan": SymbolsMetadata(
    popularity: 111,
    codepoint: 0xf71e,
    categories: [2],
    tags: [
      1128,
      380,
      6434,
      419,
      1777,
      6437,
      1781,
      388,
      8511,
      2840,
      3007,
      8501,
      787,
      3089,
      8512,
      2875,
      1002,
      8513,
      3020,
      778,
      8514,
      421,
      2653,
      4484,
      8515,
      1783,
      1496,
      7073,
      782,
      8516,
      2899,
      288,
      371,
      8499,
      1677,
      8517,
      986,
      2404
    ],
  ),
  "draw": SymbolsMetadata(
    popularity: 5918,
    codepoint: 0xe746,
    categories: [12],
    tags: [
      8518,
      2829,
      5161,
      693,
      1201,
      2332,
      299,
      8519,
      1853,
      2834,
      302,
      696,
      2299,
      8520,
      3328,
      8521,
      8522,
      53,
      966,
      1602,
      1641,
      1532,
      2693,
      2694,
      8523,
      311,
      5171,
      8524,
      1536,
      704
    ],
  ),
  "draw_abstract": SymbolsMetadata(
    popularity: 97,
    codepoint: 0xf7f8,
    categories: [12],
    tags: [
      3325,
      8525,
      2829,
      8526,
      83,
      383,
      693,
      5807,
      1201,
      299,
      8519,
      1853,
      2834,
      302,
      696,
      2299,
      3327,
      8520,
      1659,
      304,
      2735,
      3328,
      16,
      5166,
      53,
      966,
      1602,
      119,
      311,
      5923,
      105,
      5171,
      32,
      8527,
      35
    ],
  ),
  "draw_collage": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf7f7,
    categories: [12],
    tags: [
      8528,
      8525,
      1367,
      2829,
      8526,
      4861,
      1058,
      4864,
      3417,
      1061,
      693,
      921,
      4867,
      5807,
      1201,
      1996,
      299,
      1853,
      2834,
      302,
      696,
      2299,
      2550,
      2735,
      8529,
      3328,
      53,
      966,
      1064,
      306,
      1067,
      1740,
      119,
      311,
      5923,
      8527,
      3493,
      441
    ],
  ),
  "dresser": SymbolsMetadata(
    popularity: 346,
    codepoint: 0xe210,
    categories: [8],
    tags: [
      2600,
      4213,
      8530,
      8531,
      7211,
      8532,
      3989,
      1943,
      1269,
      8533,
      7788,
      8534,
      5980,
      1964,
      5981,
      999,
      7468,
      8535,
      2607,
      1435,
      2796,
      4420,
      5982,
      5726,
      1004,
      940,
      1960,
      8340,
      8536,
      674,
      2714
    ],
  ),
  "drive_export": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf41d,
    categories: [12],
    tags: [
      3325,
      1229,
      1230,
      380,
      1651,
      1652,
      10,
      388,
      1347,
      1654,
      1672,
      2628,
      1530,
      1655,
      1656,
      1657,
      1658,
      1659,
      1189,
      1661,
      421,
      223,
      4189,
      1662,
      1663,
      1396,
      1664,
      2343,
      2631,
      1665,
      674,
      1667,
      2007,
      1676,
      1677,
      346
    ],
  ),
  "drive_file_move": SymbolsMetadata(
    popularity: 1094,
    codepoint: 0xe675,
    categories: [12],
    tags: [
      2151,
      380,
      8537,
      1707,
      10,
      8538,
      3050,
      388,
      1528,
      1347,
      337,
      1654,
      1672,
      1530,
      4783,
      3052,
      1656,
      8539,
      1542,
      8540,
      778,
      421,
      8541,
      1396,
      782,
      2343,
      1665,
      4788,
      4789,
      674,
      2007,
      346
    ],
  ),
  "drive_folder_upload": SymbolsMetadata(
    popularity: 1092,
    codepoint: 0xe9a3,
    categories: [12],
    tags: [
      526,
      2151,
      380,
      1651,
      1652,
      3741,
      1653,
      1042,
      1540,
      10,
      6936,
      1528,
      1347,
      1654,
      8542,
      1672,
      1530,
      6551,
      1656,
      8543,
      8544,
      1542,
      135,
      1044,
      778,
      1495,
      2843,
      3749,
      1664,
      2343,
      1665,
      4788,
      4789,
      674,
      1412,
      1667,
      2007,
      1676,
      346,
      8545,
      3297,
      8546
    ],
  ),
  "dropdown": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xe9a4,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      7,
      2447,
      2950,
      2896,
      2750,
      269,
      299,
      2651,
      2941,
      787,
      959,
      2751,
      4965,
      306,
      92,
      788,
      219,
      327,
      789,
      421,
      2653,
      656,
      1770,
      226,
      329,
      330,
      288,
      371,
      65,
      2882,
      106,
      32,
      944,
      447,
      314,
      2757,
      4889,
      2759,
      1691,
      1053,
      7503,
      1054
    ],
  ),
  "dropper_eye": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf351,
    categories: [1],
    tags: [
      2513,
      8547,
      4850,
      8548,
      8549,
      6675,
      8550,
      2200,
      6677,
      8551,
      6243,
      8552,
      6300,
      6678,
      8553,
      8554,
      8555,
      971,
      8556,
      3021,
      3022,
      6679,
      8557,
      981,
      288,
      8558,
      36,
      1071,
      2537,
      317,
      4585
    ],
  ),
  "dry": SymbolsMetadata(
    popularity: 204,
    codepoint: 0xf1b3,
    categories: [8],
    tags: [
      707,
      8559,
      8560,
      1868,
      712,
      8561,
      8562,
      7165,
      8563,
      8564,
      8565,
      8566,
      7166,
      2734,
      2735,
      2738,
      8567,
      3617,
      3076,
      3078,
      1857,
      8568,
      3967,
      727,
      8569,
      441,
      8570,
      3978,
      3083,
      1902,
      3613,
      731
    ],
  ),
  "dry_cleaning": SymbolsMetadata(
    popularity: 658,
    codepoint: 0xea58,
    categories: [5],
    tags: [
      3597,
      2697,
      1871,
      4005,
      3989,
      8571,
      6134,
      2702,
      7165,
      8572,
      8573,
      8574,
      2705,
      2706,
      8575,
      6138,
      2527,
      2607,
      8576,
      8577,
      2613,
      75,
      2631,
      32,
      2713,
      8578,
      1504,
      8579,
      8580,
      2714,
      4001
    ],
  ),
  "dual_screen": SymbolsMetadata(
    popularity: 117,
    codepoint: 0xf6cf,
    categories: [4],
    tags: [
      1175,
      8581,
      445,
      12,
      3108,
      6788,
      8582,
      7956,
      8583,
      787,
      8584,
      7957,
      7958,
      327,
      8585,
      7821,
      2653,
      3000,
      3421,
      226,
      3506,
      8586,
      2056,
      5874,
      8587,
      7822,
      3425,
      8347,
      6257,
      8588,
      8589,
      317,
      1054,
      1084
    ],
  ),
  "duo": SymbolsMetadata(
    popularity: 704,
    codepoint: 0xe9a5,
    categories: [7],
    tags: [
      355,
      1133,
      5488,
      47,
      116,
      472,
      383,
      1135,
      3456,
      445,
      3108,
      4473,
      6788,
      8583,
      3360,
      270,
      4986,
      5516,
      367,
      278,
      328,
      2162,
      121,
      177,
      889,
      2057,
      342,
      5610,
      315,
      41,
      5519,
      540,
      8590
    ],
  ),
  "dvr": SymbolsMetadata(
    popularity: 2075,
    codepoint: 0xe1b2,
    categories: [4],
    tags: [
      1109,
      1110,
      1129,
      4312,
      8591,
      1684,
      953,
      694,
      785,
      1685,
      445,
      8592,
      12,
      956,
      8593,
      3216,
      1711,
      3337,
      965,
      2080,
      1114,
      92,
      1687,
      367,
      788,
      327,
      656,
      283,
      121,
      1154,
      177,
      75,
      190,
      330,
      65,
      4325,
      551,
      343,
      344,
      7202,
      1214,
      41,
      1691,
      1054
    ],
  ),
  "dynamic_feed": SymbolsMetadata(
    popularity: 1956,
    codepoint: 0xea14,
    categories: [6],
    tags: [
      8594,
      8595,
      8596,
      989,
      2501,
      8597,
      1400,
      355,
      5794,
      3095,
      1042,
      8598,
      2502,
      926,
      1066,
      4986,
      2503,
      486,
      3421,
      1409,
      4701,
      100,
      1029,
      424,
      8599,
      227,
      107,
      2057,
      1258,
      290,
      1260,
      1054
    ],
  ),
  "dynamic_form": SymbolsMetadata(
    popularity: 1811,
    codepoint: 0xf1bf,
    categories: [2],
    tags: [
      4089,
      1731,
      3773,
      2624,
      1733,
      785,
      1735,
      7020,
      2547,
      8600,
      696,
      8601,
      4074,
      4049,
      3779,
      1022,
      8602,
      4127,
      1598,
      966,
      4094,
      7505,
      1740,
      656,
      3782,
      329,
      6129,
      1027,
      75,
      65,
      32,
      4098,
      315,
      1260
    ],
  ),
  "e911_avatar": SymbolsMetadata(
    popularity: 243,
    codepoint: 0xf11a,
    categories: [7],
    tags: [
      3175,
      6931,
      469,
      738,
      3073,
      1133,
      1693,
      1113,
      443,
      8603,
      475,
      8604,
      3176,
      445,
      2482,
      8605,
      2766,
      2767,
      480,
      1309,
      965,
      482,
      5402,
      1251,
      2769,
      1641,
      219,
      486,
      226,
      8606,
      2772,
      1318,
      1353,
      495,
      35,
      1320,
      8607,
      1701,
      1034,
      8608,
      1261
    ],
  ),
  "e911_emergency": SymbolsMetadata(
    popularity: 1179,
    codepoint: 0xf119,
    categories: [13],
    tags: [
      6931,
      3466,
      1244,
      469,
      2479,
      738,
      8609,
      1246,
      7270,
      3775,
      2482,
      8610,
      5601,
      8611,
      8612,
      4649,
      482,
      1251,
      5223,
      3680,
      486,
      8613,
      1520,
      5862,
      602,
      1011,
      227,
      2485,
      2486,
      1034,
      1261
    ],
  ),
  "e_mobiledata": SymbolsMetadata(
    popularity: 130,
    codepoint: 0xf002,
    categories: [4],
    tags: [
      8614,
      4,
      365,
      208,
      210,
      429,
      443,
      211,
      212,
      10,
      213,
      8615,
      236,
      14,
      215,
      8616,
      19,
      219,
      433,
      434,
      221,
      222,
      223,
      242,
      437,
      227,
      228,
      38,
      2296,
      441,
      40,
      234,
      235
    ],
  ),
  "e_mobiledata_badge": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf7e3,
    categories: [4],
    tags: [
      8614,
      428,
      4,
      6,
      210,
      8617,
      8618,
      212,
      10,
      8619,
      213,
      8615,
      236,
      14,
      215,
      432,
      8616,
      19,
      219,
      8620,
      433,
      8621,
      221,
      222,
      223,
      8622,
      8623,
      227,
      228,
      32,
      38,
      40,
      234
    ],
  ),
  "ear_sound": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf356,
    categories: [0],
    tags: [
      733,
      734,
      8624,
      8625,
      1129,
      584,
      1133,
      2332,
      8626,
      8627,
      744,
      8628,
      8629,
      1139,
      1140,
      8630,
      482,
      483,
      759,
      1143,
      8631,
      1147,
      8632,
      2081,
      1152,
      2083,
      121,
      177,
      1156,
      8633,
      8634,
      1157,
      493,
      1320,
      441,
      8299,
      1161,
      1745,
      1902
    ],
  ),
  "earbud_case": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf327,
    categories: [11],
    tags: [
      2587,
      1129,
      3769,
      4479,
      7,
      5241,
      3773,
      8635,
      1269,
      445,
      8636,
      8637,
      8638,
      8639,
      1711,
      2590,
      8628,
      4492,
      1143,
      2081,
      8640,
      2585,
      3782,
      78,
      1156,
      32,
      674,
      4097,
      441,
      234
    ],
  ),
  "earbud_left": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf326,
    categories: [11],
    tags: [
      79,
      2587,
      1129,
      8641,
      8642,
      2332,
      445,
      8626,
      8627,
      8643,
      8637,
      8638,
      8639,
      7057,
      8644,
      8628,
      4492,
      8629,
      8645,
      1375,
      8646,
      8647,
      1143,
      8648,
      2081,
      3542,
      1719,
      7198,
      8649,
      1156,
      8650,
      3411,
      751,
      551,
      1745,
      2594,
      234
    ],
  ),
  "earbud_right": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf325,
    categories: [11],
    tags: [
      2587,
      1129,
      8641,
      4479,
      445,
      8626,
      8627,
      8651,
      8637,
      8638,
      8639,
      5415,
      8644,
      8628,
      4492,
      8629,
      8645,
      1143,
      8648,
      2081,
      8652,
      8653,
      5693,
      8649,
      1156,
      8650,
      751,
      551,
      1745,
      2594,
      234
    ],
  ),
  "earbuds": SymbolsMetadata(
    popularity: 312,
    codepoint: 0xf003,
    categories: [11],
    tags: [
      2587,
      1129,
      8654,
      8641,
      922,
      2332,
      445,
      8626,
      8637,
      8638,
      8639,
      3337,
      8628,
      8655,
      4492,
      8629,
      8645,
      366,
      1143,
      8656,
      390,
      2081,
      8657,
      3346,
      2585,
      1156,
      8650,
      551,
      1745,
      234
    ],
  ),
  "earbuds_2": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf324,
    categories: [11],
    tags: [
      2587,
      1129,
      8641,
      922,
      445,
      3108,
      8626,
      8637,
      8658,
      8638,
      8639,
      8628,
      4492,
      8629,
      8659,
      1143,
      8631,
      2081,
      3000,
      3346,
      8660,
      1156,
      3411,
      751,
      551,
      315,
      234,
      8661
    ],
  ),
  "earbuds_battery": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xf004,
    categories: [11],
    tags: [
      2587,
      1129,
      3769,
      3772,
      4479,
      3773,
      3774,
      922,
      445,
      8626,
      8637,
      8662,
      8638,
      8639,
      4066,
      8628,
      8663,
      4492,
      8629,
      188,
      2472,
      1143,
      8631,
      3780,
      2081,
      3782,
      1156,
      553,
      551,
      2594,
      234,
      8661,
      4529
    ],
  ),
  "early_on": SymbolsMetadata(
    popularity: 274,
    codepoint: 0xe2ba,
    categories: [10],
    tags: [
      5340,
      1015,
      84,
      5341,
      712,
      1017,
      5036,
      5046,
      1018,
      8664,
      2094,
      90,
      999,
      5206,
      5347,
      2097,
      1004,
      909,
      2838,
      5486,
      1030,
      1031,
      8665,
      32,
      108,
      3686,
      6396,
      3687,
      289,
      8666,
      5372
    ],
  ),
  "earthquake": SymbolsMetadata(
    popularity: 78,
    codepoint: 0xf64f,
    categories: [3],
    tags: [
      8667,
      469,
      8668,
      920,
      7270,
      3176,
      4670,
      8669,
      8670,
      2482,
      8671,
      8672,
      8673,
      929,
      8674,
      1602,
      597,
      327,
      1859,
      8675,
      8676,
      1787,
      5862,
      602,
      8677,
      8678,
      8679,
      8680,
      8681,
      2086,
      1261,
      1862
    ],
  ),
  "east": SymbolsMetadata(
    popularity: 5053,
    codepoint: 0xf1df,
    categories: [5],
    tags: [
      775,
      8682,
      380,
      3040,
      776,
      388,
      2961,
      8683,
      3016,
      2962,
      777,
      8684,
      188,
      1490,
      789,
      778,
      779,
      421,
      780,
      8685,
      8686,
      3147,
      1783,
      781,
      28,
      1396,
      782,
      8687,
      2967,
      1504
    ],
  ),
  "ecg": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf80f,
    categories: [11],
    tags: [
      5774,
      5775,
      4454,
      920,
      7724,
      10,
      4455,
      1528,
      1751,
      5786,
      5788,
      6874,
      2927,
      929,
      595,
      3863,
      4457,
      5789,
      5778,
      5779,
      3569,
      1754,
      2848,
      1757,
      1760,
      327,
      1761,
      1762,
      3570,
      286,
      5298,
      947,
      5791,
      4463,
      8688,
      1905
    ],
  ),
  "ecg_heart": SymbolsMetadata(
    popularity: 251,
    codepoint: 0xf6e9,
    categories: [15],
    tags: [
      5293,
      5774,
      5775,
      4454,
      1528,
      1751,
      5786,
      5787,
      5788,
      2926,
      2927,
      595,
      1753,
      4457,
      5789,
      5779,
      8689,
      3569,
      1754,
      5790,
      8690,
      4770,
      1757,
      327,
      1761,
      3570,
      286,
      5298,
      4774,
      947,
      5791,
      4463,
      1905
    ],
  ),
  "eco": SymbolsMetadata(
    popularity: 6838,
    codepoint: 0xea35,
    categories: [3],
    tags: [
      1812,
      6808,
      8691,
      8692,
      8669,
      6814,
      8693,
      8694,
      6566,
      8695,
      3779,
      1890,
      8696,
      6816,
      6818,
      196,
      5637,
      8697,
      7484,
      1859,
      6821,
      1835,
      6822,
      6824,
      2370,
      2371,
      948,
      7369,
      7370
    ],
  ),
  "eda": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf6e8,
    categories: [15],
    tags: [
      892,
      469,
      3073,
      1769,
      2489,
      8698,
      1074,
      954,
      269,
      8286,
      8699,
      8700,
      8701,
      8702,
      2734,
      2926,
      3616,
      2735,
      3448,
      2738,
      5779,
      850,
      1251,
      966,
      7011,
      486,
      8703,
      2743,
      1082,
      3619,
      912,
      1723,
      1011,
      1083,
      8704,
      2388,
      1261
    ],
  ),
  "edgesensor_high": SymbolsMetadata(
    popularity: 275,
    codepoint: 0xf005,
    categories: [4],
    tags: [
      1109,
      1110,
      469,
      365,
      1113,
      208,
      211,
      10,
      2805,
      445,
      236,
      8705,
      965,
      2471,
      8706,
      1114,
      215,
      1897,
      634,
      219,
      1675,
      8707,
      778,
      223,
      486,
      226,
      6959,
      75,
      77,
      2425,
      122,
      227,
      5894,
      5953,
      447,
      551,
      2253,
      8708,
      234
    ],
  ),
  "edgesensor_low": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xf006,
    categories: [4],
    tags: [
      1109,
      1110,
      469,
      2148,
      8709,
      8710,
      365,
      4479,
      1113,
      383,
      211,
      269,
      2805,
      445,
      588,
      236,
      8705,
      4184,
      8711,
      8712,
      965,
      2471,
      1114,
      188,
      1896,
      1897,
      8713,
      366,
      4014,
      3780,
      217,
      634,
      219,
      1675,
      8707,
      778,
      223,
      6958,
      486,
      2295,
      226,
      4023,
      6959,
      1007,
      75,
      77,
      2425,
      122,
      8714,
      8715,
      8716,
      227,
      1155,
      553,
      5953,
      7859,
      8717,
      447,
      551,
      985,
      1381,
      8708,
      5975,
      232,
      233,
      234
    ],
  ),
  "edit": SymbolsMetadata(
    popularity: 49407,
    codepoint: 0xe3c9,
    categories: [1],
    tags: [
      1726,
      1933,
      1731,
      693,
      8718,
      2376,
      1201,
      3457,
      299,
      2834,
      302,
      696,
      8719,
      2299,
      1371,
      5166,
      966,
      2836,
      21,
      1740,
      763,
      1532,
      1361,
      2693,
      2694,
      75,
      2497,
      5171,
      8006,
      441,
      2537,
      1260,
      1536,
      704
    ],
  ),
  "edit_arrow_down": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf380,
    categories: [2],
    tags: [
      8518,
      1367,
      380,
      2940,
      2188,
      1731,
      693,
      1201,
      2922,
      2651,
      337,
      3007,
      2834,
      1500,
      696,
      2299,
      966,
      1044,
      92,
      2315,
      1740,
      778,
      421,
      763,
      780,
      96,
      2693,
      2694,
      2899,
      3036,
      106,
      2007,
      1676,
      1260,
      1536,
      704
    ],
  ),
  "edit_arrow_up": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf37f,
    categories: [2],
    tags: [
      1367,
      380,
      2871,
      1731,
      693,
      1201,
      388,
      2651,
      2834,
      696,
      2299,
      8720,
      2957,
      1207,
      966,
      92,
      1740,
      778,
      2958,
      421,
      763,
      96,
      2693,
      2694,
      1496,
      1518,
      8721,
      106,
      1124,
      1676,
      1260,
      533,
      346,
      1536,
      704
    ],
  ),
  "edit_attributes": SymbolsMetadata(
    popularity: 546,
    codepoint: 0xe578,
    categories: [5],
    tags: [
      1726,
      2687,
      1549,
      8722,
      3352,
      1748,
      1731,
      1630,
      1632,
      1633,
      268,
      1636,
      1735,
      1639,
      696,
      8723,
      1755,
      1641,
      1740,
      1643,
      656,
      5922,
      1764,
      8724,
      2497,
      77,
      1664,
      288,
      65,
      1412,
      1647,
      1260,
      2386,
      2387,
      1523,
      1650
    ],
  ),
  "edit_audio": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf42d,
    categories: [0],
    tags: [
      1128,
      8725,
      380,
      419,
      1129,
      8726,
      8654,
      8727,
      365,
      1731,
      8728,
      5808,
      2804,
      2805,
      2450,
      696,
      8729,
      8730,
      8228,
      8229,
      2996,
      3328,
      8731,
      1375,
      1740,
      8732,
      2081,
      8657,
      8733,
      1148,
      177,
      2247,
      1396,
      8734,
      1156,
      8735,
      8736,
      8737,
      8634,
      8738,
      7009,
      1161,
      8688
    ],
  ),
  "edit_calendar": SymbolsMetadata(
    popularity: 4460,
    codepoint: 0xe742,
    categories: [6],
    tags: [
      1726,
      2488,
      1015,
      5341,
      1731,
      8739,
      693,
      2376,
      1201,
      1017,
      5365,
      5036,
      1853,
      8740,
      696,
      8741,
      8742,
      2299,
      2094,
      1755,
      1740,
      8743,
      5347,
      98,
      2693,
      2694,
      2838,
      75,
      1030,
      8744,
      2497,
      1031,
      32,
      289,
      1260,
      8745,
      1536,
      704
    ],
  ),
  "edit_document": SymbolsMetadata(
    popularity: 2097,
    codepoint: 0xf88c,
    categories: [12],
    tags: [
      1726,
      1731,
      693,
      8746,
      1201,
      1528,
      1347,
      8747,
      1853,
      1654,
      696,
      8748,
      8749,
      2299,
      1530,
      8750,
      8751,
      1656,
      1657,
      966,
      1740,
      8752,
      1532,
      1533,
      1534,
      1535,
      2693,
      2694,
      2497,
      8753,
      38,
      3114,
      1260,
      8754,
      1536,
      704
    ],
  ),
  "edit_location": SymbolsMetadata(
    popularity: 811,
    codepoint: 0xe568,
    categories: [5],
    tags: [
      1429,
      1731,
      8755,
      1484,
      388,
      696,
      8756,
      8757,
      8758,
      8759,
      1488,
      1001,
      8760,
      1002,
      8761,
      8762,
      1490,
      21,
      1740,
      8763,
      421,
      2693,
      2694,
      1493,
      1494,
      1495,
      8764,
      1783,
      1496,
      1498,
      1083,
      1260,
      8765
    ],
  ),
  "edit_location_alt": SymbolsMetadata(
    popularity: 611,
    codepoint: 0xe1c5,
    categories: [5],
    tags: [
      1499,
      1731,
      8755,
      696,
      8766,
      8756,
      8767,
      8757,
      8768,
      8758,
      8769,
      8759,
      8770,
      8771,
      1488,
      1001,
      8760,
      1002,
      8761,
      8772,
      21,
      1740,
      8763,
      421,
      2693,
      2694,
      1493,
      1494,
      1495,
      1783,
      1496,
      1260,
      8765
    ],
  ),
  "edit_note": SymbolsMetadata(
    popularity: 14827,
    codepoint: 0xe745,
    categories: [12],
    tags: [
      1726,
      2488,
      1731,
      693,
      2376,
      1201,
      1347,
      1853,
      696,
      8748,
      1529,
      8773,
      2299,
      1371,
      530,
      966,
      366,
      92,
      8774,
      1740,
      1532,
      8775,
      3155,
      2693,
      2694,
      2497,
      8776,
      38,
      441,
      1260,
      1536,
      704,
      8777
    ],
  ),
  "edit_notifications": SymbolsMetadata(
    popularity: 880,
    codepoint: 0xe525,
    categories: [6],
    tags: [
      1242,
      1244,
      469,
      8778,
      1246,
      6309,
      1731,
      8779,
      1248,
      693,
      1733,
      269,
      1201,
      1735,
      1853,
      696,
      8780,
      2299,
      966,
      1755,
      1740,
      8781,
      763,
      486,
      8782,
      8312,
      1120,
      1254,
      2693,
      8783,
      2694,
      8784,
      329,
      1030,
      8785,
      1257,
      65,
      1156,
      1260,
      8786,
      1536,
      704
    ],
  ),
  "edit_off": SymbolsMetadata(
    popularity: 880,
    codepoint: 0xe950,
    categories: [12],
    tags: [
      1074,
      8787,
      8788,
      8789,
      693,
      1201,
      1202,
      3302,
      2969,
      8790,
      8791,
      8792,
      767,
      1853,
      696,
      8793,
      2299,
      8794,
      898,
      899,
      966,
      7067,
      763,
      8795,
      8796,
      8797,
      907,
      908,
      909,
      2693,
      2694,
      8798,
      8799,
      8800,
      3310,
      914,
      1083,
      915,
      1536,
      704,
      8801,
      3736
    ],
  ),
  "edit_road": SymbolsMetadata(
    popularity: 466,
    codepoint: 0xef4d,
    categories: [5],
    tags: [
      1726,
      1731,
      8802,
      2832,
      1577,
      1484,
      388,
      1578,
      1579,
      2834,
      696,
      8803,
      8804,
      1580,
      1581,
      366,
      1002,
      1490,
      1740,
      8805,
      421,
      1586,
      2693,
      2694,
      8806,
      1587,
      8807,
      1503,
      1589,
      441,
      1590,
      1591,
      1260,
      8808,
      3229
    ],
  ),
  "edit_square": SymbolsMetadata(
    popularity: 4468,
    codepoint: 0xf88d,
    categories: [6],
    tags: [
      1128,
      1726,
      2488,
      3254,
      8809,
      1731,
      693,
      2376,
      1201,
      1735,
      1853,
      302,
      696,
      4932,
      8748,
      7280,
      8810,
      8773,
      2299,
      530,
      966,
      1641,
      8811,
      1740,
      1532,
      1533,
      2693,
      2694,
      8812,
      2695,
      2497,
      32,
      8813,
      1260,
      1536,
      704
    ],
  ),
  "editor_choice": SymbolsMetadata(
    popularity: 273,
    codepoint: 0xf528,
    categories: [3],
    tags: [
      2717,
      1549,
      2480,
      3574,
      6,
      3575,
      3576,
      1630,
      1632,
      383,
      1635,
      8814,
      8815,
      8816,
      8817,
      90,
      3579,
      1661,
      1207,
      1641,
      1643,
      202,
      3581,
      62,
      8818,
      8819,
      3584,
      2368,
      3585,
      288,
      371,
      5781,
      1645,
      1647,
      1124,
      8820,
      6196,
      2387,
      2388,
      1523,
      8821,
      3589,
      1650
    ],
  ),
  "egg": SymbolsMetadata(
    popularity: 1100,
    codepoint: 0xeacc,
    categories: [3],
    tags: [
      5177,
      8822,
      8823,
      6886,
      3790,
      3791,
      8824,
      4388,
      8825,
      8826,
      8827,
      8828,
      1822,
      1829,
      8072,
      2018,
      16,
      8829,
      1859,
      8830,
      8088,
      1361,
      5185,
      2423,
      3808,
      105,
      2439,
      8831
    ],
  ),
  "egg_alt": SymbolsMetadata(
    popularity: 748,
    codepoint: 0xeac8,
    categories: [3],
    tags: [
      3325,
      8832,
      3790,
      3791,
      3792,
      383,
      3795,
      4388,
      8825,
      8826,
      8827,
      1829,
      8833,
      3328,
      8072,
      2018,
      16,
      8829,
      3804,
      788,
      2097,
      8088,
      5185,
      2423,
      3807,
      105,
      35,
      8831
    ],
  ),
  "eject": SymbolsMetadata(
    popularity: 967,
    codepoint: 0xe8fb,
    categories: [2],
    tags: [
      2052,
      2154,
      3050,
      3303,
      2156,
      3306,
      2157,
      1654,
      8220,
      6242,
      1672,
      8834,
      6243,
      1602,
      367,
      6467,
      1719,
      2904,
      8835,
      8836,
      8837,
      8838,
      3068,
      911,
      2343,
      1665,
      2007,
      1701,
      1677,
      346,
      5275
    ],
  ),
  "elderly": SymbolsMetadata(
    popularity: 1361,
    codepoint: 0xf21a,
    categories: [3],
    tags: [
      733,
      734,
      3194,
      3195,
      738,
      584,
      4408,
      8839,
      3198,
      4410,
      8840,
      1753,
      483,
      4939,
      1757,
      770,
      8841,
      8842,
      488,
      489,
      8843,
      8844,
      3205,
      8845,
      3493,
      495,
      3206,
      3939
    ],
  ),
  "elderly_woman": SymbolsMetadata(
    popularity: 975,
    codepoint: 0xeb69,
    categories: [3],
    tags: [
      733,
      156,
      3195,
      738,
      584,
      4408,
      8839,
      3198,
      8846,
      1790,
      1791,
      8840,
      8847,
      8848,
      8849,
      8850,
      1753,
      483,
      8851,
      1757,
      770,
      8841,
      8842,
      488,
      489,
      8852,
      8844,
      3205,
      8853,
      607,
      3493,
      495,
      35,
      3206,
      3939,
      5012,
      8854
    ],
  ),
  "electric_bike": SymbolsMetadata(
    popularity: 487,
    codepoint: 0xeb1b,
    categories: [14],
    tags: [
      3769,
      4313,
      4314,
      4089,
      3773,
      2063,
      386,
      8855,
      8856,
      8694,
      4074,
      8857,
      4049,
      3779,
      2927,
      6818,
      4121,
      1490,
      8858,
      8859,
      3782,
      2072,
      4341,
      231,
      2371,
      4098,
      1930,
      1504,
      4342,
      1844,
      4344
    ],
  ),
  "electric_bolt": SymbolsMetadata(
    popularity: 2735,
    codepoint: 0xec1c,
    categories: [8],
    tags: [
      469,
      4089,
      3773,
      3774,
      3176,
      4074,
      8860,
      8861,
      8862,
      4049,
      8863,
      3779,
      8864,
      1022,
      4127,
      4650,
      4093,
      4094,
      8865,
      1004,
      3782,
      4096,
      8866,
      1027,
      231,
      4652,
      8867,
      4098,
      1261,
      4656
    ],
  ),
  "electric_car": SymbolsMetadata(
    popularity: 1283,
    codepoint: 0xeb1c,
    categories: [14],
    tags: [
      1131,
      1814,
      3467,
      3769,
      4089,
      1815,
      1816,
      8868,
      3774,
      2063,
      6814,
      4074,
      8869,
      8861,
      8870,
      4112,
      4049,
      3779,
      1890,
      4114,
      6818,
      5634,
      4121,
      1490,
      3782,
      2371,
      4098,
      1930,
      1504,
      1844
    ],
  ),
  "electric_meter": SymbolsMetadata(
    popularity: 726,
    codepoint: 0xec1b,
    categories: [8],
    tags: [
      8871,
      4089,
      798,
      383,
      8872,
      1851,
      1308,
      4074,
      8873,
      4049,
      3779,
      1022,
      3560,
      999,
      1435,
      188,
      4093,
      8874,
      4094,
      4121,
      597,
      634,
      3561,
      327,
      1004,
      3782,
      2507,
      2631,
      7119,
      4098,
      2165,
      8875,
      7569,
      6368,
      4655,
      8876,
      8877
    ],
  ),
  "electric_moped": SymbolsMetadata(
    popularity: 647,
    codepoint: 0xeb1d,
    categories: [14],
    tags: [
      1814,
      3769,
      4314,
      4089,
      1815,
      1816,
      3774,
      2063,
      1019,
      8878,
      4074,
      8879,
      8880,
      4333,
      4112,
      4049,
      4114,
      8881,
      4121,
      1490,
      4336,
      4337,
      4338,
      4340,
      3782,
      8882,
      4341,
      8883,
      4098,
      1930,
      1504,
      4342,
      4343,
      1844,
      4344
    ],
  ),
  "electric_rickshaw": SymbolsMetadata(
    popularity: 370,
    codepoint: 0xeb1e,
    categories: [14],
    tags: [
      1131,
      8884,
      1814,
      3467,
      8885,
      4089,
      8886,
      1815,
      1816,
      3774,
      2063,
      8694,
      4074,
      8887,
      8879,
      8888,
      8889,
      4112,
      4114,
      8881,
      7449,
      4121,
      1490,
      4336,
      8890,
      2072,
      8882,
      8883,
      8891,
      8892,
      4098,
      1930,
      1504,
      1843,
      8893,
      1844,
      8894
    ],
  ),
  "electric_scooter": SymbolsMetadata(
    popularity: 563,
    codepoint: 0xeb1f,
    categories: [14],
    tags: [
      3769,
      4314,
      4089,
      3773,
      3774,
      2602,
      2063,
      388,
      1578,
      8895,
      4332,
      8694,
      4074,
      4333,
      4049,
      8881,
      8896,
      4121,
      1490,
      8897,
      8898,
      3782,
      2615,
      2072,
      4341,
      3058,
      8883,
      4098,
      1930,
      1504,
      4342,
      8899,
      1844,
      4344,
      4345
    ],
  ),
  "electrical_services": SymbolsMetadata(
    popularity: 1785,
    codepoint: 0xf102,
    categories: [5],
    tags: [
      8900,
      1888,
      4364,
      3773,
      3774,
      921,
      211,
      4366,
      8901,
      445,
      3306,
      4074,
      4072,
      8902,
      8903,
      8904,
      4049,
      3216,
      1711,
      3779,
      4372,
      4373,
      4131,
      3782,
      4376,
      4128,
      2631,
      2755,
      4378,
      2758,
      4380
    ],
  ),
  "elevation": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xf6e7,
    categories: [15],
    tags: [
      3325,
      2465,
      2466,
      2467,
      2468,
      2927,
      304,
      4546,
      196,
      595,
      2470,
      8905,
      8906,
      8907,
      8908,
      1207,
      934,
      366,
      1544,
      1545,
      2474,
      28,
      8909,
      2475,
      8007,
      109,
      2477,
      8910,
      2478,
      1701,
      1676,
      2917
    ],
  ),
  "elevator": SymbolsMetadata(
    popularity: 654,
    codepoint: 0xf1a0,
    categories: [16],
    tags: [
      755,
      733,
      419,
      584,
      7,
      798,
      8911,
      8912,
      388,
      2651,
      8442,
      8913,
      483,
      3472,
      1001,
      421,
      1922,
      488,
      489,
      2071,
      32,
      2008,
      1842,
      1930,
      1504,
      1701,
      1676,
      501,
      8914
    ],
  ),
  "emergency": SymbolsMetadata(
    popularity: 3085,
    codepoint: 0xe1eb,
    categories: [5],
    tags: [
      6931,
      3466,
      736,
      469,
      2479,
      738,
      3255,
      1749,
      7270,
      3775,
      1202,
      1751,
      2482,
      4474,
      595,
      1753,
      482,
      1754,
      3201,
      1490,
      1757,
      1760,
      602,
      8915,
      2486,
      3264,
      495,
      35,
      1034,
      1261
    ],
  ),
  "emergency_heat": SymbolsMetadata(
    popularity: 366,
    codepoint: 0xf15d,
    categories: [8],
    tags: [
      3175,
      6931,
      469,
      3073,
      8916,
      1693,
      712,
      3775,
      3176,
      2482,
      8917,
      2766,
      2767,
      3177,
      5601,
      5311,
      8918,
      4649,
      3076,
      8919,
      5673,
      2471,
      999,
      3078,
      8920,
      1251,
      2769,
      1641,
      1004,
      486,
      8921,
      2772,
      5862,
      602,
      35,
      727,
      729,
      1034,
      1261
    ],
  ),
  "emergency_heat_2": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf4e5,
    categories: [8],
    tags: [
      3175,
      707,
      2078,
      469,
      3073,
      8922,
      2777,
      1849,
      1850,
      1693,
      712,
      713,
      3176,
      2482,
      8917,
      2766,
      2767,
      3177,
      3075,
      8923,
      926,
      3076,
      8919,
      8924,
      5673,
      2471,
      8925,
      999,
      3078,
      723,
      1251,
      1641,
      1004,
      486,
      3967,
      35,
      727,
      8926,
      729,
      441,
      1261,
      1862,
      1902,
      8927,
      731,
      1863
    ],
  ),
  "emergency_home": SymbolsMetadata(
    popularity: 2077,
    codepoint: 0xe82a,
    categories: [8],
    tags: [
      469,
      3073,
      1693,
      3775,
      3176,
      1416,
      1434,
      2482,
      2766,
      2767,
      3075,
      4649,
      999,
      1435,
      1436,
      1251,
      5223,
      2769,
      1641,
      1004,
      486,
      2772,
      1444,
      1446,
      5862,
      1423,
      602,
      1011,
      32,
      35,
      1034,
      1261
    ],
  ),
  "emergency_recording": SymbolsMetadata(
    popularity: 255,
    codepoint: 0xebf4,
    categories: [8],
    tags: [
      6931,
      3466,
      469,
      2479,
      3255,
      3073,
      5488,
      47,
      116,
      1693,
      7270,
      3176,
      6726,
      2482,
      8928,
      8929,
      270,
      5509,
      4474,
      965,
      595,
      1754,
      53,
      1251,
      5223,
      1757,
      420,
      486,
      119,
      121,
      177,
      602,
      1011,
      2486,
      3264,
      41,
      5519,
      5521,
      1261
    ],
  ),
  "emergency_share": SymbolsMetadata(
    popularity: 338,
    codepoint: 0xebf6,
    categories: [8],
    tags: [
      469,
      738,
      3073,
      355,
      1693,
      8930,
      3176,
      8931,
      2482,
      8932,
      960,
      8933,
      1488,
      482,
      1251,
      1489,
      1001,
      8934,
      1002,
      421,
      223,
      486,
      1493,
      1495,
      1496,
      602,
      1011,
      2343,
      1665,
      8935,
      227,
      228,
      2486,
      947,
      5087,
      1261,
      233
    ],
  ),
  "emergency_share_off": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf59e,
    categories: [8],
    tags: [
      469,
      3073,
      355,
      8936,
      1693,
      3176,
      896,
      1076,
      1077,
      8937,
      8140,
      7965,
      767,
      2482,
      8932,
      8938,
      898,
      960,
      8939,
      1251,
      1489,
      8940,
      1001,
      8114,
      8934,
      8941,
      8942,
      7976,
      486,
      907,
      908,
      909,
      1493,
      8943,
      1665,
      8944,
      3058,
      8945,
      227,
      6980,
      914,
      2486,
      1261
    ],
  ),
  "emoji_food_beverage": SymbolsMetadata(
    popularity: 1416,
    codepoint: 0xea1b,
    categories: [3],
    tags: [
      4383,
      2136,
      3790,
      3792,
      6605,
      8946,
      6607,
      6609,
      4390,
      8947,
      1550,
      4974,
      8948,
      4219,
      8949,
      6611,
      8950,
      788,
      2097,
      6614,
      6615,
      8951,
      1958,
      3807,
      6616,
      6617,
      8952,
      8953,
      8954,
      8955
    ],
  ),
  "emoji_language": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf4cd,
    categories: [11],
    tags: [
      8956,
      472,
      443,
      476,
      8258,
      8957,
      1550,
      1553,
      1554,
      479,
      1555,
      8958,
      1556,
      5071,
      8959,
      5072,
      1557,
      1558,
      8960,
      7414,
      8961,
      215,
      969,
      8962,
      5651,
      1560,
      8963,
      1561,
      8964,
      489,
      5652,
      1563,
      1567,
      1569,
      607,
      492,
      493,
      496,
      7110,
      8051,
      1504,
      1053,
      4763,
      8965,
      5655
    ],
  ),
  "emoji_nature": SymbolsMetadata(
    popularity: 2230,
    codepoint: 0xea1c,
    categories: [3],
    tags: [
      5177,
      1180,
      8966,
      7621,
      7622,
      5178,
      8967,
      7985,
      1550,
      1890,
      8968,
      2433,
      1918,
      1973,
      6816,
      196,
      8969,
      5184,
      8970,
      8971,
      1859,
      1860,
      8972,
      1835,
      8973,
      2439,
      4208,
      7371,
      8974
    ],
  ),
  "emoji_objects": SymbolsMetadata(
    popularity: 7496,
    codepoint: 0xea24,
    categories: [3],
    tags: [
      3670,
      3942,
      8975,
      5164,
      955,
      4074,
      1550,
      8976,
      3779,
      8977,
      960,
      6063,
      3944,
      6632,
      3945,
      8978,
      8979,
      4688,
      4697,
      3680,
      3946,
      763,
      422,
      8980,
      3782,
      8981,
      8982,
      6641,
      7530
    ],
  ),
  "emoji_people": SymbolsMetadata(
    popularity: 4006,
    codepoint: 0xea1d,
    categories: [3],
    tags: [
      468,
      8983,
      470,
      584,
      194,
      475,
      1550,
      6155,
      930,
      2738,
      8984,
      8985,
      483,
      488,
      489,
      490,
      8986,
      105,
      607,
      4941,
      750,
      495,
      946,
      501,
      1862,
      8987,
      766
    ],
  ),
  "emoji_symbols": SymbolsMetadata(
    popularity: 780,
    codepoint: 0xea1e,
    categories: [3],
    tags: [
      8988,
      8989,
      8,
      693,
      696,
      1550,
      8990,
      5334,
      4076,
      8991,
      16,
      966,
      1044,
      969,
      2081,
      3394,
      1532,
      6414,
      4075,
      4101,
      3263,
      35,
      8992,
      38,
      40,
      702,
      704
    ],
  ),
  "emoji_transportation": SymbolsMetadata(
    popularity: 1404,
    codepoint: 0xea1f,
    categories: [3],
    tags: [
      2601,
      2014,
      1814,
      798,
      1815,
      1816,
      2602,
      8993,
      2063,
      4327,
      2016,
      1484,
      388,
      1654,
      3484,
      1550,
      2605,
      1581,
      1001,
      1490,
      421,
      4321,
      1495,
      2071,
      2614,
      1446,
      2616,
      2072,
      6782,
      1587,
      2617,
      1589,
      8891,
      8994,
      1590,
      1842,
      1930,
      1504,
      1591,
      2621,
      1844
    ],
  ),
  "emoticon": SymbolsMetadata(
    popularity: 64,
    codepoint: 0xe5f3,
    categories: [3],
    tags: [
      192,
      526,
      472,
      443,
      1042,
      1550,
      1551,
      1552,
      1553,
      6699,
      1554,
      479,
      8995,
      1555,
      8996,
      6231,
      2819,
      1556,
      4194,
      1557,
      1558,
      6701,
      16,
      1559,
      1044,
      6157,
      8997,
      1560,
      485,
      1561,
      763,
      8998,
      489,
      2821,
      1563,
      202,
      1213,
      8999,
      1567,
      1568,
      1569,
      607,
      31,
      1570,
      35,
      9000,
      9001,
      9002
    ],
  ),
  "empty_dashboard": SymbolsMetadata(
    popularity: 194,
    codepoint: 0xf844,
    categories: [2],
    tags: [
      526,
      5,
      1230,
      6089,
      5794,
      1733,
      1201,
      2515,
      10,
      4827,
      4013,
      9003,
      1372,
      538,
      246,
      7501,
      3079,
      2518,
      306,
      937,
      763,
      7582,
      7498,
      1068,
      4857,
      2648,
      5796,
      75,
      2258,
      1353,
      2649,
      5923,
      32,
      944,
      108,
      6404,
      1691,
      1053,
      1054
    ],
  ),
  "enable": SymbolsMetadata(
    popularity: 1336,
    codepoint: 0xf188,
    categories: [2],
    tags: [
      755,
      951,
      380,
      2650,
      3453,
      3074,
      6100,
      383,
      1776,
      896,
      2651,
      2840,
      337,
      2855,
      9004,
      2909,
      966,
      1044,
      852,
      907,
      909,
      26,
      3782,
      4988,
      3012,
      288,
      65,
      2913,
      108,
      9005,
      313,
      314
    ],
  ),
  "encrypted": SymbolsMetadata(
    popularity: 874,
    codepoint: 0xe593,
    categories: [13],
    tags: [
      755,
      1510,
      3242,
      9006,
      7138,
      3244,
      3245,
      9007,
      2854,
      9008,
      6527,
      9009,
      6528,
      968,
      9010,
      9011,
      2674,
      9012,
      6529,
      5716,
      1516,
      1517,
      1519,
      4331,
      1520,
      1772,
      9013,
      602,
      1773,
      1011,
      1522,
      9014,
      1523
    ],
  ),
  "encrypted_add": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf429,
    categories: [13],
    tags: [
      192,
      526,
      9015,
      9016,
      9017,
      9018,
      9019,
      1510,
      1201,
      3244,
      9008,
      6527,
      9020,
      9021,
      968,
      9010,
      9011,
      2674,
      763,
      9022,
      9023,
      1211,
      5716,
      202,
      9024,
      9025,
      9026,
      1516,
      1517,
      1519,
      1520,
      1772,
      602,
      1773,
      1011,
      1522,
      35,
      1523
    ],
  ),
  "encrypted_add_circle": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf42a,
    categories: [13],
    tags: [
      192,
      526,
      9027,
      9015,
      9016,
      9017,
      9018,
      9028,
      9029,
      9019,
      1506,
      1510,
      1201,
      9008,
      6527,
      9030,
      9021,
      968,
      9011,
      763,
      2692,
      1211,
      9031,
      5716,
      202,
      9026,
      1515,
      1516,
      1517,
      1519,
      1520,
      1772,
      602,
      1773,
      1011,
      1522,
      35,
      1523
    ],
  ),
  "encrypted_minus_circle": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf428,
    categories: [13],
    tags: [
      5330,
      755,
      468,
      1074,
      1510,
      383,
      9006,
      3244,
      2922,
      9032,
      897,
      8286,
      9033,
      9008,
      6527,
      9034,
      900,
      9009,
      968,
      9011,
      1116,
      6529,
      1211,
      5716,
      1516,
      1517,
      1519,
      1520,
      2930,
      911,
      9035,
      3310,
      889,
      602,
      1773,
      1011,
      1522,
      1122,
      35,
      9036,
      501,
      1523
    ],
  ),
  "encrypted_off": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf427,
    categories: [13],
    tags: [
      755,
      895,
      1510,
      3176,
      9032,
      9037,
      9033,
      9038,
      767,
      898,
      9008,
      6527,
      9034,
      9039,
      899,
      9040,
      968,
      9011,
      9041,
      9042,
      9043,
      907,
      908,
      909,
      2653,
      5716,
      1516,
      1517,
      1519,
      1520,
      9044,
      5862,
      602,
      1773,
      1011,
      9045,
      1522,
      9046,
      914,
      4679,
      5718,
      9047,
      1523,
      7538
    ],
  ),
  "endocrinology": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xe0a9,
    categories: [3],
    tags: [
      3325,
      9048,
      1015,
      2412,
      584,
      1751,
      9049,
      9050,
      9051,
      9052,
      9053,
      196,
      595,
      1753,
      9054,
      9055,
      483,
      9056,
      9057,
      1757,
      9058,
      9059,
      9060,
      822,
      9061,
      9062,
      9063,
      2424,
      9064,
      9065,
      9066,
      35,
      9067,
      9068,
      1905
    ],
  ),
  "energy": SymbolsMetadata(
    popularity: 66,
    codepoint: 0xe9a6,
    categories: [9],
    tags: [
      707,
      9069,
      9070,
      9071,
      712,
      6814,
      4049,
      3779,
      1890,
      719,
      2550,
      7077,
      9072,
      6818,
      9073,
      3782,
      9074,
      6824,
      9075,
      397,
      2371,
      9076,
      9077,
      730,
      731,
      1863,
      9078,
      9079,
      9080
    ],
  ),
  "energy_program_saving": SymbolsMetadata(
    popularity: 452,
    codepoint: 0xf15f,
    categories: [8],
    tags: [
      2717,
      6,
      1510,
      8692,
      8878,
      9081,
      4113,
      9082,
      4184,
      1890,
      2433,
      9073,
      3579,
      5637,
      9083,
      1859,
      1835,
      4023,
      2648,
      9084,
      9085,
      3585,
      310,
      65,
      2728,
      3264,
      2370,
      9086
    ],
  ),
  "energy_program_time_used": SymbolsMetadata(
    popularity: 372,
    codepoint: 0xf161,
    categories: [8],
    tags: [
      5,
      1015,
      1344,
      365,
      5341,
      920,
      8872,
      10,
      1020,
      6814,
      3500,
      3779,
      929,
      6818,
      1023,
      5637,
      366,
      1859,
      2648,
      75,
      1353,
      1031,
      32,
      33,
      289,
      947,
      7569,
      9087,
      1592
    ],
  ),
  "energy_savings_leaf": SymbolsMetadata(
    popularity: 1294,
    codepoint: 0xec1a,
    categories: [8],
    tags: [
      6559,
      8692,
      6814,
      8694,
      6566,
      4049,
      3779,
      9088,
      9089,
      4113,
      9090,
      9091,
      1890,
      6818,
      9073,
      5637,
      6820,
      4121,
      3781,
      1859,
      1004,
      9092,
      3782,
      4023,
      9084,
      9075,
      9085,
      824,
      2370,
      2371,
      7569
    ],
  ),
  "engineering": SymbolsMetadata(
    popularity: 8447,
    codepoint: 0xea3d,
    categories: [15],
    tags: [
      584,
      5804,
      5240,
      6806,
      4175,
      2832,
      2625,
      6584,
      2835,
      9093,
      3487,
      9094,
      6175,
      9095,
      483,
      6924,
      3170,
      9096,
      2770,
      6925,
      2837,
      9097,
      488,
      489,
      9098,
      490,
      3474,
      602,
      310,
      65,
      495,
      9099,
      501,
      9100
    ],
  ),
  "enhanced_encryption": SymbolsMetadata(
    popularity: 1016,
    codepoint: 0xe63f,
    categories: [13],
    tags: [
      192,
      755,
      526,
      4164,
      3242,
      9006,
      3244,
      3245,
      6527,
      654,
      9101,
      530,
      1207,
      2674,
      5715,
      763,
      6531,
      5716,
      202,
      1516,
      1517,
      1519,
      1520,
      9102,
      912,
      1772,
      602,
      1773,
      1011,
      5965,
      9103,
      35,
      533,
      9104
    ],
  ),
  "ent": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xe0aa,
    categories: [3],
    tags: [
      3325,
      470,
      4944,
      1400,
      584,
      6629,
      472,
      9105,
      473,
      443,
      194,
      4264,
      6647,
      2332,
      8626,
      479,
      1738,
      14,
      481,
      1659,
      6220,
      1190,
      4492,
      595,
      9095,
      483,
      16,
      3944,
      6631,
      850,
      5206,
      3945,
      3502,
      4688,
      3375,
      9106,
      1602,
      1143,
      2528,
      5291,
      6633,
      485,
      6635,
      2783,
      6899,
      9059,
      223,
      9107,
      488,
      6636,
      489,
      1409,
      490,
      9108,
      6638,
      311,
      2074,
      6201,
      607,
      492,
      35,
      496,
      9109,
      6641,
      6642,
      6643,
      9067,
      6644,
      501,
      9110
    ],
  ),
  "enterprise": SymbolsMetadata(
    popularity: 227,
    codepoint: 0xe70e,
    categories: [9],
    tags: [
      1747,
      3719,
      4743,
      7,
      5238,
      1284,
      5240,
      5241,
      383,
      1285,
      9111,
      1269,
      8380,
      1347,
      832,
      5244,
      2626,
      1655,
      808,
      1656,
      5811,
      3489,
      3170,
      936,
      1045,
      1456,
      9112,
      940,
      5245,
      5246,
      3156,
      5247,
      75,
      5248,
      3857,
      2755,
      32,
      674,
      6193,
      4746,
      1645,
      1459
    ],
  ),
  "enterprise_off": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xeb4d,
    categories: [9],
    tags: [
      3719,
      4743,
      894,
      5238,
      1284,
      1075,
      5240,
      5241,
      1285,
      5242,
      896,
      9113,
      2969,
      1077,
      767,
      5244,
      898,
      2626,
      901,
      3170,
      7067,
      9114,
      9115,
      9116,
      9117,
      9118,
      9119,
      907,
      1456,
      909,
      5247,
      75,
      171,
      914,
      32,
      4746,
      915,
      1459
    ],
  ),
  "equal": SymbolsMetadata(
    popularity: 263,
    codepoint: 0xf77b,
    categories: [12],
    tags: [
      794,
      1199,
      5332,
      3812,
      3813,
      9,
      2138,
      2174,
      3817,
      5334,
      2377,
      9120,
      2378,
      6328,
      2176,
      2080,
      9121,
      2472,
      366,
      2379,
      9122,
      1210,
      2380,
      9123,
      788,
      421,
      977,
      656,
      2294,
      9124,
      65,
      461,
      35,
      1214
    ],
  ),
  "equalizer": SymbolsMetadata(
    popularity: 3391,
    codepoint: 0xe01d,
    categories: [0],
    tags: [
      1128,
      9125,
      5061,
      5,
      1129,
      9126,
      9127,
      9128,
      6457,
      794,
      365,
      920,
      269,
      1735,
      10,
      8229,
      277,
      929,
      934,
      597,
      937,
      2081,
      9129,
      9130,
      1148,
      65,
      1156,
      9131,
      9132,
      9133,
      8318,
      9134,
      9135,
      33,
      3411,
      440,
      947,
      2253,
      1745,
      9136,
      8688
    ],
  ),
  "eraser_size_1": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf3fc,
    categories: [12],
    tags: [
      79,
      3254,
      1748,
      3436,
      3181,
      897,
      2969,
      302,
      9137,
      696,
      2299,
      3438,
      9138,
      1372,
      1602,
      9139,
      3330,
      1764,
      75,
      911,
      3331,
      311,
      673,
      5171,
      1979,
      4820,
      9140,
      9141,
      2537,
      3831,
      9142,
      3014
    ],
  ),
  "eraser_size_2": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf3fb,
    categories: [12],
    tags: [
      5163,
      895,
      1748,
      3436,
      3181,
      897,
      2969,
      302,
      696,
      2299,
      3438,
      9138,
      1372,
      3634,
      1602,
      9139,
      4044,
      9143,
      3330,
      1764,
      911,
      3331,
      9144,
      673,
      5171,
      4820,
      9140,
      9145,
      9141,
      2537,
      2499,
      3831,
      3014
    ],
  ),
  "eraser_size_3": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf3fa,
    categories: [12],
    tags: [
      895,
      1748,
      3436,
      3181,
      897,
      299,
      2969,
      302,
      696,
      2299,
      3438,
      9138,
      1372,
      1602,
      9139,
      4044,
      9143,
      3330,
      5185,
      1764,
      911,
      3331,
      7443,
      9144,
      673,
      5171,
      4820,
      9140,
      9145,
      9141,
      374,
      2537,
      2499,
      3831,
      3014
    ],
  ),
  "eraser_size_4": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf3f9,
    categories: [12],
    tags: [
      534,
      2829,
      9146,
      895,
      3436,
      3181,
      897,
      299,
      302,
      696,
      2299,
      8828,
      3438,
      9138,
      1372,
      538,
      3634,
      9139,
      9143,
      3330,
      5185,
      911,
      3331,
      7443,
      9144,
      673,
      4820,
      9140,
      9145,
      9141,
      2537,
      2499,
      3831,
      3014
    ],
  ),
  "eraser_size_5": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf3f8,
    categories: [12],
    tags: [
      2829,
      9147,
      895,
      3436,
      3181,
      897,
      9148,
      302,
      696,
      2299,
      8828,
      3438,
      9138,
      1372,
      3634,
      9139,
      9143,
      3330,
      5185,
      911,
      3331,
      7443,
      9144,
      9149,
      5171,
      4820,
      9140,
      9141,
      2537,
      2499,
      3831
    ],
  ),
  "error": SymbolsMetadata(
    popularity: 29529,
    codepoint: 0xe000,
    categories: [6],
    tags: [
      3175,
      469,
      3073,
      1693,
      383,
      3176,
      2766,
      2767,
      9150,
      480,
      482,
      1251,
      9151,
      135,
      8401,
      2769,
      1641,
      485,
      9143,
      486,
      9152,
      1361,
      1363,
      2772,
      1353,
      3331,
      553,
      495,
      35,
      9153,
      1261
    ],
  ),
  "error_med": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xe49b,
    categories: [2],
    tags: [
      469,
      3073,
      1693,
      383,
      3176,
      2766,
      2768,
      7877,
      480,
      595,
      16,
      1251,
      135,
      2769,
      366,
      1760,
      4044,
      485,
      9143,
      4045,
      9154,
      486,
      2772,
      1353,
      889,
      553,
      35,
      1261,
      9155
    ],
  ),
  "escalator": SymbolsMetadata(
    popularity: 233,
    codepoint: 0xf1a1,
    categories: [16],
    tags: [
      755,
      733,
      2013,
      798,
      8912,
      2969,
      2651,
      9156,
      8442,
      9157,
      8907,
      3472,
      9158,
      7744,
      9159,
      9160,
      4603,
      8909,
      8007,
      32,
      9161,
      9162,
      3611,
      4623,
      2008,
      1842,
      1930,
      1504,
      1676
    ],
  ),
  "escalator_warning": SymbolsMetadata(
    popularity: 1085,
    codepoint: 0xf1ac,
    categories: [16],
    tags: [
      755,
      733,
      154,
      469,
      9163,
      584,
      1693,
      862,
      865,
      2063,
      9156,
      9157,
      867,
      591,
      3225,
      4649,
      9164,
      483,
      870,
      9159,
      874,
      1922,
      488,
      489,
      1967,
      4603,
      2072,
      602,
      750,
      877,
      1930,
      1504,
      1261
    ],
  ),
  "euro": SymbolsMetadata(
    popularity: 3164,
    codepoint: 0xea15,
    categories: [9],
    tags: [
      796,
      797,
      1618,
      799,
      1619,
      800,
      1326,
      801,
      803,
      1327,
      805,
      806,
      807,
      9165,
      9166,
      9167,
      9168,
      9169,
      2627,
      808,
      815,
      7175,
      1291,
      7433,
      818,
      819,
      9170,
      820,
      821,
      1337,
      840,
      3322,
      841,
      35,
      5753,
      842,
      1214,
      463,
      3324
    ],
  ),
  "euro_symbol": SymbolsMetadata(
    popularity: 2157,
    codepoint: 0xe926,
    categories: [9],
    tags: [
      468,
      796,
      797,
      828,
      799,
      800,
      801,
      803,
      1327,
      805,
      806,
      807,
      9165,
      9166,
      9167,
      9168,
      2627,
      3318,
      808,
      7409,
      811,
      7414,
      815,
      7433,
      818,
      819,
      9170,
      820,
      821,
      1337,
      840,
      841,
      35,
      842,
      1214,
      3324,
      9171
    ],
  ),
  "ev_mobiledata_badge": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf7e2,
    categories: [4],
    tags: [
      4,
      1814,
      3467,
      6,
      1815,
      208,
      8,
      4516,
      213,
      11,
      4112,
      4114,
      14,
      16,
      2780,
      432,
      19,
      219,
      433,
      221,
      222,
      223,
      24,
      226,
      190,
      227,
      231,
      32,
      35,
      9172,
      38,
      1930,
      40,
      9173,
      233,
      234
    ],
  ),
  "ev_shadow": SymbolsMetadata(
    popularity: 324,
    codepoint: 0xef8f,
    categories: [1],
    tags: [
      365,
      4418,
      5271,
      3774,
      383,
      1734,
      4367,
      4248,
      3690,
      5036,
      9174,
      696,
      2299,
      2567,
      4074,
      4049,
      4114,
      959,
      5072,
      9175,
      9176,
      1078,
      53,
      3680,
      366,
      4255,
      4222,
      6304,
      1081,
      61,
      119,
      3782,
      2948,
      4206,
      9177,
      4424,
      5082,
      2586,
      9178,
      9179,
      5677,
      731
    ],
  ),
  "ev_shadow_add": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf580,
    categories: [1],
    tags: [
      192,
      526,
      1057,
      1058,
      9180,
      5271,
      3774,
      383,
      1061,
      4866,
      1201,
      4248,
      696,
      2299,
      4074,
      4049,
      3327,
      4114,
      787,
      959,
      9175,
      1204,
      53,
      1206,
      1207,
      1044,
      1064,
      4965,
      366,
      1067,
      763,
      422,
      1081,
      61,
      119,
      202,
      1213,
      3782,
      4206,
      9177,
      6330,
      441,
      9178
    ],
  ),
  "ev_shadow_minus": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf57f,
    categories: [1],
    tags: [
      5330,
      3325,
      1343,
      5271,
      3774,
      383,
      1469,
      268,
      1735,
      5808,
      2922,
      897,
      9181,
      696,
      2299,
      4074,
      4049,
      4114,
      959,
      9175,
      2176,
      16,
      53,
      6248,
      1116,
      3696,
      656,
      1081,
      61,
      119,
      3782,
      2930,
      911,
      889,
      65,
      4206,
      9177,
      2586,
      1122,
      35,
      441,
      9178
    ],
  ),
  "ev_station": SymbolsMetadata(
    popularity: 1090,
    codepoint: 0xe56d,
    categories: [5],
    tags: [
      1814,
      3467,
      3769,
      4089,
      4364,
      1815,
      1816,
      3773,
      5271,
      3774,
      6017,
      6814,
      4074,
      8869,
      4370,
      8861,
      4112,
      4049,
      3779,
      4114,
      9182,
      9183,
      9184,
      6818,
      999,
      4121,
      1001,
      6280,
      1490,
      421,
      2613,
      4373,
      3782,
      9185,
      3611,
      2371,
      4098,
      1930,
      1844,
      4380
    ],
  ),
  "event": SymbolsMetadata(
    popularity: 13906,
    codepoint: 0xe878,
    categories: [6],
    tags: [
      526,
      5340,
      1015,
      1936,
      5341,
      383,
      1201,
      1017,
      5036,
      1018,
      832,
      2094,
      2018,
      1044,
      9186,
      1641,
      1145,
      5347,
      9187,
      2838,
      1007,
      75,
      4272,
      1030,
      1924,
      5349,
      1031,
      9188,
      32,
      289,
      5351,
      5372,
      5352
    ],
  ),
  "event_available": SymbolsMetadata(
    popularity: 6819,
    codepoint: 0xe614,
    categories: [6],
    tags: [
      1627,
      6081,
      5340,
      1015,
      1549,
      2480,
      6099,
      3063,
      5341,
      1630,
      1632,
      1633,
      1635,
      1636,
      4271,
      1017,
      5036,
      1639,
      2094,
      1641,
      1643,
      2838,
      2107,
      1030,
      1031,
      288,
      2487,
      1647,
      289,
      2385,
      2386,
      2387,
      1523,
      1650
    ],
  ),
  "event_busy": SymbolsMetadata(
    popularity: 2183,
    codepoint: 0xe615,
    categories: [6],
    tags: [
      1015,
      9189,
      8307,
      9190,
      5341,
      895,
      9191,
      3436,
      2950,
      4665,
      1202,
      1017,
      5036,
      4441,
      9192,
      897,
      2094,
      9193,
      2985,
      4043,
      5347,
      4145,
      9194,
      4452,
      911,
      9195,
      1031,
      9196,
      1083,
      289,
      915,
      9197,
      3736
    ],
  ),
  "event_list": SymbolsMetadata(
    popularity: 113,
    codepoint: 0xf683,
    categories: [2],
    tags: [
      5340,
      9198,
      5793,
      5341,
      9199,
      6086,
      1631,
      9200,
      2094,
      9201,
      5134,
      2080,
      2245,
      1501,
      1602,
      92,
      9202,
      7505,
      1755,
      940,
      98,
      2838,
      2107,
      100,
      9203,
      1031,
      944,
      3159,
      290,
      1649,
      1214,
      9204,
      317
    ],
  ),
  "event_note": SymbolsMetadata(
    popularity: 4053,
    codepoint: 0xe616,
    categories: [6],
    tags: [
      5340,
      1015,
      5341,
      9205,
      1017,
      9206,
      5036,
      1018,
      3458,
      1347,
      2094,
      9207,
      5346,
      3461,
      92,
      8774,
      5347,
      1532,
      1533,
      486,
      940,
      2107,
      1030,
      1031,
      9208,
      1645,
      38,
      289,
      704,
      5352
    ],
  ),
  "event_repeat": SymbolsMetadata(
    popularity: 1572,
    codepoint: 0xeb7b,
    categories: [6],
    tags: [
      5340,
      2284,
      5341,
      385,
      5374,
      1017,
      5036,
      1018,
      2094,
      277,
      3524,
      3513,
      3525,
      390,
      936,
      5347,
      9209,
      2107,
      9210,
      2366,
      9211,
      9212,
      9213,
      424,
      425,
      1030,
      2494,
      2367,
      5297,
      396,
      1031,
      289,
      402,
      1260,
      5397,
      9214
    ],
  ),
  "event_seat": SymbolsMetadata(
    popularity: 452,
    codepoint: 0xe903,
    categories: [8],
    tags: [
      1015,
      5977,
      1509,
      9215,
      9216,
      1059,
      1936,
      1912,
      267,
      4713,
      1135,
      2094,
      9217,
      1964,
      1001,
      1145,
      189,
      1495,
      1924,
      1603,
      1926,
      5988,
      1377,
      2997,
      1961,
      8192,
      32,
      3412,
      441,
      2022,
      5138,
      9218
    ],
  ),
  "event_upcoming": SymbolsMetadata(
    popularity: 2757,
    codepoint: 0xf238,
    categories: [6],
    tags: [
      5339,
      5340,
      1015,
      380,
      9219,
      1936,
      5341,
      9220,
      1017,
      5036,
      1018,
      2094,
      777,
      6408,
      6106,
      9221,
      5347,
      780,
      9222,
      2838,
      1030,
      1924,
      1396,
      5349,
      1031,
      289,
      9223,
      5372
    ],
  ),
  "exclamation": SymbolsMetadata(
    popularity: 2961,
    codepoint: 0xf22f,
    categories: [13],
    tags: [
      3175,
      469,
      3073,
      1693,
      3775,
      3176,
      2482,
      2766,
      2767,
      3177,
      3075,
      6951,
      480,
      482,
      2471,
      9224,
      1251,
      135,
      2769,
      1641,
      9154,
      486,
      2772,
      4104,
      1030,
      1353,
      5862,
      9225,
      553,
      495,
      35,
      1261
    ],
  ),
  "exercise": SymbolsMetadata(
    popularity: 193,
    codepoint: 0xf6e6,
    categories: [15],
    tags: [
      1242,
      989,
      8148,
      9226,
      1343,
      9227,
      9228,
      1730,
      9229,
      2925,
      2242,
      2926,
      2927,
      5777,
      595,
      6190,
      2080,
      9230,
      9231,
      4297,
      2613,
      3782,
      5781,
      3595,
      5953,
      5965,
      441,
      5782,
      3831,
      9232,
      9233,
      1905,
      3596
    ],
  ),
  "exit_to_app": SymbolsMetadata(
    popularity: 5904,
    codepoint: 0xe879,
    categories: [2],
    tags: [
      1229,
      1230,
      380,
      7,
      2750,
      299,
      2604,
      6103,
      2985,
      9234,
      1672,
      9235,
      1471,
      777,
      6105,
      2751,
      3080,
      306,
      6244,
      9236,
      903,
      219,
      327,
      778,
      780,
      9237,
      9238,
      2398,
      1719,
      226,
      5653,
      782,
      330,
      913,
      2882,
      32,
      447,
      1689,
      2757,
      2759,
      1691,
      1053,
      1054
    ],
  ),
  "expand": SymbolsMetadata(
    popularity: 2479,
    codepoint: 0xe94f,
    categories: [2],
    tags: [
      380,
      419,
      3086,
      132,
      2450,
      2651,
      2840,
      1216,
      787,
      9239,
      2996,
      1673,
      1204,
      2080,
      366,
      2307,
      789,
      778,
      2653,
      3012,
      2247,
      2281,
      3093,
      2401,
      2249,
      6803,
      2455,
      1676,
      1677,
      1381,
      3110,
      986,
      2403,
      2404
    ],
  ),
  "expand_all": SymbolsMetadata(
    popularity: 503,
    codepoint: 0xe946,
    categories: [2],
    tags: [
      2325,
      380,
      419,
      2871,
      2862,
      2896,
      7852,
      1578,
      3101,
      2450,
      6654,
      3593,
      2651,
      2941,
      9240,
      787,
      3096,
      9241,
      7855,
      92,
      788,
      421,
      2653,
      9242,
      9243,
      2948,
      9244,
      3099,
      9245,
      314,
      2949,
      9246,
      1676
    ],
  ),
  "expand_circle_down": SymbolsMetadata(
    popularity: 9346,
    codepoint: 0xe7cd,
    categories: [2],
    tags: [
      6658,
      380,
      2892,
      419,
      2871,
      2862,
      383,
      2902,
      2896,
      132,
      388,
      12,
      2651,
      2941,
      787,
      9247,
      9241,
      9248,
      9249,
      7855,
      2953,
      3102,
      6663,
      92,
      789,
      421,
      2653,
      2948,
      2900,
      2997,
      314,
      9250
    ],
  ),
  "expand_circle_right": SymbolsMetadata(
    popularity: 139,
    codepoint: 0xf591,
    categories: [2],
    tags: [
      380,
      9251,
      2892,
      419,
      2862,
      383,
      2902,
      9252,
      2896,
      776,
      132,
      388,
      3101,
      2651,
      2941,
      1216,
      787,
      9253,
      9247,
      7855,
      9254,
      6663,
      2996,
      777,
      92,
      789,
      778,
      421,
      9255,
      780,
      2653,
      28,
      1396,
      782,
      9256
    ],
  ),
  "expand_circle_up": SymbolsMetadata(
    popularity: 105,
    codepoint: 0xf5d2,
    categories: [2],
    tags: [
      380,
      419,
      2466,
      2871,
      2862,
      383,
      2896,
      388,
      2995,
      2651,
      1216,
      787,
      9247,
      9241,
      9248,
      2956,
      6663,
      2996,
      1204,
      1207,
      92,
      2307,
      789,
      2958,
      421,
      2653,
      2948,
      2475,
      3103,
      1124,
      6331,
      2949,
      1676,
      346
    ],
  ),
  "expand_content": SymbolsMetadata(
    popularity: 810,
    codepoint: 0xf830,
    categories: [2],
    tags: [
      380,
      419,
      2862,
      2896,
      2391,
      545,
      388,
      2651,
      1216,
      787,
      9248,
      7855,
      6663,
      6664,
      2996,
      1673,
      9257,
      1204,
      2396,
      3759,
      92,
      2397,
      2307,
      9258,
      789,
      421,
      2653,
      2247,
      2948,
      3046,
      2401,
      3103,
      2249,
      2949,
      3110,
      2403
    ],
  ),
  "expansion_panels": SymbolsMetadata(
    popularity: 74,
    codepoint: 0xe600,
    categories: [2],
    tags: [
      6658,
      380,
      419,
      2862,
      3592,
      2950,
      2896,
      4901,
      6660,
      1042,
      1578,
      2450,
      3593,
      2651,
      2941,
      787,
      4902,
      9259,
      900,
      4965,
      788,
      421,
      2653,
      1770,
      3421,
      2948,
      1377,
      2997,
      314,
      1676
    ],
  ),
  "experiment": SymbolsMetadata(
    popularity: 1555,
    codepoint: 0xe686,
    categories: [15],
    tags: [
      2513,
      9260,
      9261,
      9262,
      6558,
      9263,
      4349,
      9264,
      9265,
      9266,
      9267,
      9268,
      4350,
      9269,
      9270,
      9271,
      964,
      4476,
      9272,
      4354,
      4361,
      9273,
      2424,
      9274,
      9275,
      9276,
      3160,
      9277,
      8161
    ],
  ),
  "explicit": SymbolsMetadata(
    popularity: 392,
    codepoint: 0xe01e,
    categories: [0],
    tags: [
      686,
      154,
      4,
      1074,
      7,
      8,
      443,
      693,
      1042,
      1201,
      8615,
      696,
      2299,
      9278,
      14,
      5206,
      9279,
      1044,
      5651,
      4706,
      8616,
      19,
      367,
      485,
      3541,
      2081,
      78,
      32,
      35,
      38,
      40,
      702,
      704
    ],
  ),
  "explore": SymbolsMetadata(
    popularity: 9671,
    codepoint: 0xe87a,
    categories: [5],
    tags: [
      2464,
      383,
      2831,
      9280,
      1484,
      1416,
      388,
      3043,
      955,
      4294,
      3016,
      5575,
      958,
      9281,
      960,
      3226,
      1581,
      1001,
      1002,
      1490,
      421,
      3045,
      3562,
      3070,
      3147,
      1496,
      980,
      2935,
      1504,
      5237,
      3229,
      3039
    ],
  ),
  "explore_nearby": SymbolsMetadata(
    popularity: 91,
    codepoint: 0xe538,
    categories: [5],
    tags: [
      993,
      1483,
      1484,
      388,
      955,
      958,
      9282,
      960,
      1486,
      1488,
      6868,
      9283,
      9284,
      1001,
      1002,
      6280,
      21,
      421,
      9285,
      9286,
      1493,
      1494,
      1495,
      9287,
      9288,
      1496,
      6959,
      1008,
      980,
      8192,
      1504
    ],
  ),
  "explore_off": SymbolsMetadata(
    popularity: 255,
    codepoint: 0xe9a8,
    categories: [5],
    tags: [
      9289,
      380,
      383,
      2831,
      9290,
      1076,
      1484,
      388,
      9291,
      767,
      9292,
      3016,
      898,
      9293,
      9294,
      958,
      9295,
      9296,
      8939,
      8112,
      9297,
      901,
      7095,
      1001,
      8114,
      8116,
      1490,
      8142,
      3562,
      9298,
      3070,
      907,
      909,
      9299,
      7102,
      9300,
      9301,
      914,
      2935,
      2126,
      9302,
      9303,
      9304,
      1504,
      9305,
      1701,
      9306,
      9307,
      3039
    ],
  ),
  "explosion": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xf685,
    categories: [3],
    tags: [
      469,
      3255,
      4657,
      7844,
      4659,
      4660,
      4661,
      4662,
      4663,
      4664,
      5667,
      3176,
      4668,
      4669,
      4670,
      3257,
      3779,
      787,
      3104,
      4671,
      4672,
      9308,
      4127,
      7848,
      7849,
      4674,
      4675,
      9309,
      3782,
      9310,
      9311,
      9312,
      3264,
      5058,
      1261
    ],
  ),
  "export_notes": SymbolsMetadata(
    popularity: 164,
    codepoint: 0xe0ac,
    categories: [12],
    tags: [
      380,
      383,
      1042,
      10,
      1528,
      1347,
      337,
      1672,
      2628,
      6243,
      1530,
      595,
      9313,
      135,
      366,
      778,
      1532,
      1533,
      1719,
      1534,
      1535,
      1396,
      78,
      1664,
      2343,
      1665,
      3058,
      32,
      38,
      2007,
      1677,
      346,
      704
    ],
  ),
  "exposure": SymbolsMetadata(
    popularity: 496,
    codepoint: 0xe3ca,
    categories: [1],
    tags: [
      526,
      1128,
      794,
      1728,
      47,
      1734,
      269,
      2922,
      2969,
      88,
      696,
      2299,
      2567,
      5048,
      270,
      16,
      53,
      1207,
      9314,
      2472,
      3680,
      1116,
      59,
      61,
      119,
      202,
      75,
      2425,
      122,
      65,
      1378,
      32,
      1122,
      35
    ],
  ),
  "exposure_neg_1": SymbolsMetadata(
    popularity: 257,
    codepoint: 0xe3cb,
    categories: [1],
    tags: [
      79,
      1128,
      1728,
      47,
      1734,
      269,
      9315,
      2922,
      7643,
      11,
      2651,
      696,
      2299,
      2567,
      4114,
      5048,
      9316,
      9317,
      53,
      7647,
      1116,
      9318,
      9319,
      3696,
      9320,
      23,
      24,
      3542,
      59,
      61,
      2930,
      65,
      1122,
      35,
      9321
    ],
  ),
  "exposure_neg_2": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xe3cc,
    categories: [1],
    tags: [
      9322,
      81,
      1128,
      1728,
      47,
      1734,
      9315,
      2922,
      7643,
      11,
      2651,
      696,
      2299,
      2567,
      4114,
      5048,
      9316,
      9317,
      53,
      9323,
      2315,
      9324,
      9319,
      3696,
      9325,
      23,
      24,
      59,
      61,
      2930,
      65,
      1122,
      35,
      315,
      9321
    ],
  ),
  "exposure_plus_1": SymbolsMetadata(
    popularity: 736,
    codepoint: 0xe3cd,
    categories: [1],
    tags: [
      79,
      526,
      9326,
      1197,
      1198,
      4164,
      1728,
      2375,
      1734,
      9,
      11,
      696,
      2299,
      2567,
      5048,
      9327,
      777,
      6021,
      53,
      1207,
      9328,
      1217,
      9329,
      1210,
      2380,
      789,
      780,
      23,
      24,
      3542,
      59,
      61,
      202,
      9330,
      1213,
      29,
      65,
      3935,
      461,
      35,
      191,
      1676
    ],
  ),
  "exposure_plus_2": SymbolsMetadata(
    popularity: 258,
    codepoint: 0xe3ce,
    categories: [1],
    tags: [
      9331,
      81,
      526,
      1197,
      9332,
      1728,
      47,
      1734,
      11,
      696,
      2299,
      2567,
      9333,
      5048,
      9316,
      53,
      3145,
      1207,
      9334,
      1217,
      9335,
      7200,
      7201,
      24,
      59,
      3422,
      61,
      202,
      9336,
      1213,
      65,
      35,
      315,
      9337,
      9338,
      1676
    ],
  ),
  "exposure_zero": SymbolsMetadata(
    popularity: 304,
    codepoint: 0xe3cf,
    categories: [1],
    tags: [
      5059,
      1128,
      5061,
      1131,
      1132,
      1728,
      47,
      383,
      1734,
      269,
      4827,
      11,
      696,
      2299,
      2567,
      4114,
      5048,
      9316,
      16,
      53,
      3680,
      5063,
      1804,
      23,
      24,
      5185,
      59,
      61,
      119,
      426,
      889,
      65,
      35,
      375
    ],
  ),
  "extension": SymbolsMetadata(
    popularity: 4424,
    codepoint: 0xe87b,
    categories: [6],
    tags: [
      526,
      8359,
      8360,
      1229,
      1058,
      1061,
      1633,
      4866,
      268,
      921,
      6676,
      787,
      6264,
      8361,
      1951,
      529,
      2242,
      9339,
      697,
      1044,
      2629,
      9340,
      1064,
      935,
      4870,
      656,
      5019,
      4131,
      9341,
      7330,
      65,
      311,
      7859
    ],
  ),
  "extension_off": SymbolsMetadata(
    popularity: 680,
    codepoint: 0xe4f5,
    categories: [2],
    tags: [
      8360,
      9342,
      894,
      896,
      9343,
      9344,
      9345,
      1077,
      9346,
      9347,
      9348,
      767,
      898,
      6264,
      8361,
      9349,
      9340,
      9350,
      9351,
      9352,
      907,
      909,
      5019,
      4131,
      9353,
      7330,
      9354,
      911,
      9355,
      9356,
      9357,
      311,
      914,
      9358,
      9359,
      9360,
      9361
    ],
  ),
  "eye_tracking": SymbolsMetadata(
    popularity: 117,
    codepoint: 0xf4c9,
    categories: [0],
    tags: [
      1242,
      5958,
      3811,
      8698,
      3909,
      1730,
      2391,
      2804,
      2805,
      6300,
      9362,
      9363,
      1738,
      1250,
      274,
      9364,
      2809,
      971,
      327,
      420,
      9365,
      8556,
      909,
      3583,
      2948,
      1723,
      1011,
      981,
      2997,
      7070,
      32,
      36,
      2165,
      947,
      317,
      5024,
      4585,
      2102
    ],
  ),
  "eyeglasses": SymbolsMetadata(
    popularity: 295,
    codepoint: 0xf6ee,
    categories: [3],
    tags: [
      7984,
      3370,
      9366,
      9367,
      9368,
      9369,
      2705,
      276,
      9370,
      9371,
      900,
      9372,
      971,
      9373,
      9374,
      4538,
      9375,
      2506,
      9376,
      2948,
      981,
      2997,
      7070,
      9377,
      9378,
      3730,
      9379,
      9380,
      317,
      5024,
      4585
    ],
  ),
  "eyeglasses_2": SymbolsMetadata(
    popularity: 68,
    codepoint: 0xf2c7,
    categories: [3],
    tags: [
      733,
      7984,
      758,
      9366,
      9367,
      9368,
      9369,
      2705,
      276,
      9370,
      9371,
      2149,
      126,
      9372,
      971,
      9373,
      9381,
      9374,
      4538,
      9375,
      2506,
      2507,
      981,
      1155,
      9377,
      9378,
      2182,
      9379,
      9380,
      317,
      9382,
      4585,
      986
    ],
  ),
  "face": SymbolsMetadata(
    popularity: 13213,
    codepoint: 0xe87c,
    categories: [3],
    tags: [
      755,
      468,
      1768,
      470,
      8698,
      383,
      2805,
      1550,
      1188,
      479,
      9383,
      2808,
      9384,
      6220,
      1190,
      483,
      2809,
      850,
      2674,
      5127,
      852,
      903,
      1361,
      488,
      489,
      490,
      9108,
      3583,
      889,
      1723,
      1011,
      9385,
      607,
      858,
      4494,
      5718,
      501,
      4942
    ],
  ),
  "face_2": SymbolsMetadata(
    popularity: 895,
    codepoint: 0xf8da,
    categories: [3],
    tags: [
      81,
      3325,
      468,
      3211,
      3212,
      2148,
      470,
      2538,
      384,
      443,
      194,
      475,
      88,
      956,
      1550,
      1188,
      479,
      9386,
      481,
      4868,
      1190,
      482,
      483,
      2540,
      850,
      366,
      2674,
      5127,
      852,
      903,
      853,
      223,
      423,
      488,
      489,
      490,
      3583,
      1786,
      1195,
      1011,
      607,
      495,
      6640,
      4097,
      551,
      858,
      315,
      5718,
      501
    ],
  ),
  "face_3": SymbolsMetadata(
    popularity: 1229,
    codepoint: 0xf8db,
    categories: [3],
    tags: [
      468,
      470,
      9387,
      6089,
      383,
      475,
      4827,
      1550,
      9388,
      1188,
      479,
      1790,
      9389,
      9390,
      8847,
      6220,
      1190,
      483,
      16,
      850,
      885,
      2674,
      5127,
      852,
      903,
      7791,
      1804,
      1361,
      488,
      489,
      854,
      490,
      3583,
      3331,
      1011,
      105,
      607,
      35,
      441,
      858,
      5718,
      501,
      5012
    ],
  ),
  "face_4": SymbolsMetadata(
    popularity: 1147,
    codepoint: 0xf8dc,
    categories: [3],
    tags: [
      468,
      470,
      9391,
      383,
      475,
      9392,
      9393,
      1550,
      1188,
      479,
      1790,
      9394,
      8847,
      9395,
      6220,
      1190,
      483,
      850,
      885,
      8851,
      2674,
      5127,
      852,
      903,
      853,
      488,
      489,
      854,
      490,
      3583,
      1786,
      1011,
      607,
      858,
      5718,
      501,
      5012,
      9396
    ],
  ),
  "face_5": SymbolsMetadata(
    popularity: 781,
    codepoint: 0xf8dd,
    categories: [3],
    tags: [
      3325,
      468,
      470,
      9397,
      9398,
      383,
      956,
      3640,
      1550,
      1551,
      1188,
      479,
      9399,
      246,
      6220,
      1190,
      483,
      2540,
      16,
      2674,
      5127,
      852,
      903,
      9400,
      3635,
      488,
      489,
      490,
      3583,
      889,
      9401,
      1011,
      105,
      607,
      35,
      3636,
      858,
      5718,
      501
    ],
  ),
  "face_6": SymbolsMetadata(
    popularity: 1431,
    codepoint: 0xf8de,
    categories: [3],
    tags: [
      468,
      6692,
      470,
      83,
      9402,
      383,
      475,
      9403,
      1550,
      9404,
      9388,
      1188,
      479,
      9405,
      9406,
      1190,
      483,
      16,
      850,
      2674,
      5127,
      852,
      903,
      1804,
      1361,
      488,
      489,
      854,
      490,
      3583,
      889,
      1011,
      105,
      607,
      35,
      858,
      5718,
      501,
      860
    ],
  ),
  "face_down": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf402,
    categories: [3],
    tags: [
      2650,
      470,
      9407,
      388,
      2651,
      2840,
      337,
      2924,
      1500,
      1550,
      2909,
      1188,
      479,
      9408,
      9409,
      2735,
      9410,
      1190,
      9411,
      483,
      1542,
      966,
      9412,
      489,
      9413,
      854,
      490,
      9414,
      1664,
      1412,
      501,
      9415
    ],
  ),
  "face_left": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf401,
    categories: [3],
    tags: [
      468,
      380,
      470,
      2489,
      1731,
      383,
      388,
      1550,
      1188,
      479,
      2735,
      9410,
      1190,
      483,
      850,
      1375,
      779,
      421,
      489,
      790,
      854,
      2876,
      490,
      2495,
      2496,
      396,
      65,
      313,
      441,
      402,
      2499,
      501
    ],
  ),
  "face_nod": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf400,
    categories: [3],
    tags: [
      1627,
      2716,
      3350,
      9416,
      1548,
      7026,
      2717,
      1549,
      419,
      470,
      9417,
      383,
      443,
      1636,
      4271,
      388,
      2450,
      1550,
      1188,
      479,
      2735,
      9410,
      1190,
      483,
      9418,
      9419,
      1643,
      4752,
      489,
      490,
      396,
      9420,
      402,
      9421,
      501,
      1650
    ],
  ),
  "face_retouching_off": SymbolsMetadata(
    popularity: 282,
    codepoint: 0xf007,
    categories: [1],
    tags: [
      9422,
      9423,
      9424,
      9425,
      9426,
      9427,
      767,
      696,
      2299,
      9428,
      9429,
      2567,
      1550,
      1552,
      898,
      9430,
      479,
      9431,
      9432,
      9433,
      9434,
      9435,
      9436,
      53,
      9437,
      7484,
      9438,
      9439,
      9440,
      9441,
      9442,
      9443,
      907,
      909,
      9444,
      59,
      9445,
      61,
      9446,
      9447,
      9448,
      9449,
      9450,
      9451,
      65,
      914,
      2384,
      9452,
      9453,
      9454
    ],
  ),
  "face_right": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf3ff,
    categories: [3],
    tags: [
      468,
      775,
      380,
      470,
      1731,
      776,
      388,
      1550,
      1188,
      479,
      9455,
      2962,
      777,
      2735,
      9410,
      1190,
      483,
      778,
      421,
      780,
      489,
      781,
      490,
      28,
      1396,
      396,
      2343,
      1665,
      313,
      2007,
      2571,
      402,
      501
    ],
  ),
  "face_shake": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf3fe,
    categories: [3],
    tags: [
      264,
      419,
      470,
      3005,
      383,
      4441,
      8286,
      388,
      9456,
      2722,
      2450,
      1550,
      1552,
      6699,
      1188,
      479,
      2735,
      9410,
      1190,
      2176,
      483,
      1858,
      4145,
      9457,
      489,
      490,
      9458,
      4452,
      396,
      8679,
      9459,
      501,
      9460
    ],
  ),
  "face_up": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf3fd,
    categories: [3],
    tags: [
      468,
      9461,
      380,
      470,
      194,
      1540,
      388,
      1550,
      1188,
      479,
      9462,
      2735,
      9410,
      1190,
      483,
      850,
      223,
      489,
      854,
      490,
      9108,
      1665,
      31,
      1412,
      1677,
      346,
      9463,
      9464,
      9465,
      9466,
      501,
      9467
    ],
  ),
  "fact_check": SymbolsMetadata(
    popularity: 8086,
    codepoint: 0xf0c5,
    categories: [12],
    tags: [
      1627,
      6081,
      1549,
      2480,
      1630,
      1631,
      1632,
      1633,
      1635,
      1636,
      2481,
      2376,
      1347,
      1639,
      9468,
      9469,
      9470,
      9471,
      1640,
      3065,
      1598,
      366,
      92,
      1641,
      1643,
      1353,
      1396,
      288,
      32,
      1645,
      1647,
      6088,
      6085,
      9472,
      2385,
      2386,
      2388,
      1523,
      1650
    ],
  ),
  "factory": SymbolsMetadata(
    popularity: 4051,
    codepoint: 0xebbc,
    categories: [5],
    tags: [
      9473,
      798,
      5262,
      2832,
      9474,
      7114,
      9475,
      9476,
      6923,
      9477,
      9478,
      9479,
      6924,
      9480,
      6925,
      9481,
      9482,
      7117,
      1835,
      3949,
      6296,
      9483,
      9484,
      5266,
      9485,
      3899,
      3902
    ],
  ),
  "falling": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf60d,
    categories: [3],
    tags: [
      3466,
      949,
      9486,
      584,
      1693,
      9487,
      3176,
      9488,
      2651,
      9489,
      9490,
      9491,
      9492,
      9493,
      9494,
      483,
      9495,
      3201,
      9496,
      420,
      1858,
      488,
      489,
      9497,
      9498,
      750,
      9499,
      1591,
      9500,
      1261
    ],
  ),
  "familiar_face_and_zone": SymbolsMetadata(
    popularity: 760,
    codepoint: 0xe21c,
    categories: [10],
    tags: [
      755,
      989,
      993,
      8698,
      3909,
      2391,
      2804,
      2805,
      479,
      2808,
      9384,
      9501,
      960,
      1738,
      274,
      9502,
      1190,
      999,
      2809,
      2810,
      1001,
      1004,
      489,
      490,
      3583,
      1008,
      1723,
      2812,
      980,
      1011,
      32,
      36,
      1071,
      2165,
      947,
      501,
      1013
    ],
  ),
  "family_history": SymbolsMetadata(
    popularity: 139,
    codepoint: 0xe0ad,
    categories: [9],
    tags: [
      9503,
      9504,
      1994,
      920,
      865,
      383,
      921,
      923,
      924,
      867,
      9505,
      925,
      926,
      928,
      7077,
      929,
      595,
      9506,
      932,
      1023,
      933,
      1064,
      9507,
      935,
      1067,
      223,
      4242,
      9508,
      8005,
      9509,
      32,
      945,
      9510
    ],
  ),
  "family_home": SymbolsMetadata(
    popularity: 219,
    codepoint: 0xeb26,
    categories: [8],
    tags: [
      2601,
      798,
      1433,
      1434,
      2605,
      867,
      9511,
      9512,
      9513,
      4457,
      9514,
      999,
      9515,
      9516,
      9517,
      7191,
      1435,
      9518,
      1436,
      2608,
      4770,
      9519,
      9520,
      9521,
      1495,
      1444,
      2614,
      1445,
      1446,
      2616,
      9522,
      2617,
      9523
    ],
  ),
  "family_link": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xeb19,
    categories: [15],
    tags: [
      989,
      8001,
      865,
      194,
      211,
      1416,
      867,
      1918,
      1973,
      2819,
      697,
      930,
      1064,
      9524,
      9525,
      935,
      223,
      1860,
      4242,
      2162,
      3347,
      8005,
      1421,
      1665,
      3058,
      9526,
      495,
      9527,
      8263,
      8264,
      1863
    ],
  ),
  "family_restroom": SymbolsMetadata(
    popularity: 2307,
    codepoint: 0xf1a2,
    categories: [16],
    tags: [
      733,
      734,
      9528,
      1868,
      862,
      865,
      867,
      9529,
      3605,
      591,
      1791,
      9530,
      930,
      483,
      760,
      871,
      1001,
      9531,
      3607,
      421,
      9532,
      4242,
      488,
      489,
      2071,
      3610,
      9533,
      499,
      1885,
      9534,
      3613,
      8854
    ],
  ),
  "family_star": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xf527,
    categories: [3],
    tags: [
      468,
      8265,
      3575,
      1670,
      862,
      865,
      9535,
      194,
      1550,
      479,
      867,
      3578,
      2819,
      930,
      1558,
      3019,
      999,
      1251,
      6157,
      870,
      871,
      8260,
      1213,
      285,
      490,
      3582,
      286,
      102,
      8005,
      1664,
      65,
      1567,
      3264,
      946
    ],
  ),
  "fan_focus": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf334,
    categories: [14],
    tags: [
      705,
      1128,
      709,
      5690,
      1846,
      380,
      419,
      1814,
      3467,
      1815,
      712,
      9536,
      269,
      3088,
      718,
      388,
      2651,
      2924,
      719,
      9537,
      1738,
      6834,
      1363,
      310,
      9538,
      9539,
      727,
      9540,
      9541,
      1844,
      730,
      986
    ],
  ),
  "fan_indirect": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf333,
    categories: [14],
    tags: [
      709,
      9542,
      1846,
      380,
      419,
      1847,
      1814,
      3467,
      9543,
      1850,
      1815,
      2348,
      713,
      716,
      269,
      718,
      9544,
      388,
      9545,
      2173,
      9546,
      1890,
      719,
      926,
      723,
      2001,
      5481,
      65,
      2438,
      2057,
      727,
      9540,
      1844,
      730,
      731,
      1863
    ],
  ),
  "farsight_digital": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf559,
    categories: [10],
    tags: [
      111,
      9547,
      1015,
      383,
      712,
      1016,
      2092,
      88,
      9548,
      9549,
      9550,
      12,
      1020,
      9551,
      6408,
      999,
      2095,
      597,
      2096,
      1004,
      24,
      94,
      3948,
      1030,
      889,
      1031,
      103,
      3549,
      729,
      9552,
      289,
      1033,
      123,
      2102
    ],
  ),
  "fast_forward": SymbolsMetadata(
    popularity: 3280,
    codepoint: 0xe01f,
    categories: [0],
    tags: [
      775,
      380,
      1129,
      269,
      785,
      2450,
      9553,
      1022,
      8451,
      9554,
      777,
      9555,
      367,
      2081,
      421,
      780,
      2162,
      2904,
      1152,
      1027,
      1028,
      7535,
      2966,
      9556,
      231,
      289,
      1701,
      344,
      9557,
      41
    ],
  ),
  "fast_rewind": SymbolsMetadata(
    popularity: 1644,
    codepoint: 0xe020,
    categories: [0],
    tags: [
      380,
      9558,
      2489,
      2870,
      84,
      269,
      9553,
      1022,
      9559,
      367,
      2903,
      326,
      2081,
      9560,
      421,
      2162,
      1152,
      2876,
      1027,
      3515,
      3516,
      2495,
      2881,
      2886,
      9561,
      231,
      108,
      289,
      1701,
      344,
      9557,
      2499,
      41,
      291
    ],
  ),
  "fastfood": SymbolsMetadata(
    popularity: 2691,
    codepoint: 0xe57a,
    categories: [5],
    tags: [
      4383,
      9562,
      3792,
      9563,
      9564,
      6609,
      8084,
      4277,
      4390,
      3800,
      7128,
      9565,
      9566,
      1829,
      5154,
      2986,
      3803,
      1490,
      3804,
      2613,
      9567,
      3807,
      4979,
      3809,
      9568,
      9569,
      9570,
      4285,
      4286
    ],
  ),
  "faucet": SymbolsMetadata(
    popularity: 423,
    codepoint: 0xe278,
    categories: [8],
    tags: [
      1888,
      4004,
      1868,
      1871,
      4005,
      1269,
      2332,
      6626,
      3990,
      926,
      3489,
      999,
      1435,
      3972,
      3802,
      2797,
      1004,
      4372,
      9571,
      2800,
      3610,
      9572,
      2631,
      3999,
      9573,
      4008,
      6368,
      4001,
      9574,
      3986,
      2801
    ],
  ),
  "favorite": SymbolsMetadata(
    popularity: 76966,
    codepoint: 0xe87d,
    categories: [2],
    tags: [
      4764,
      9575,
      4765,
      4766,
      1670,
      9576,
      187,
      3578,
      9577,
      4457,
      9578,
      1560,
      4770,
      2379,
      285,
      329,
      4272,
      9579,
      9580,
      4774,
      1664,
      311,
      31,
      4795,
      9581,
      9582,
      4797,
      4777,
      9583,
      4778,
      4750
    ],
  ),
  "fax": SymbolsMetadata(
    popularity: 1398,
    codepoint: 0xead8,
    categories: [11],
    tags: [
      1284,
      952,
      443,
      7796,
      445,
      12,
      1347,
      3216,
      1712,
      1713,
      1309,
      970,
      9584,
      1717,
      1456,
      8841,
      9585,
      226,
      1721,
      2342,
      9586,
      701,
      1724,
      330,
      2343,
      9587,
      551,
      1320,
      5087
    ],
  ),
  "feature_search": SymbolsMetadata(
    popularity: 241,
    codepoint: 0xe9a9,
    categories: [6],
    tags: [
      2513,
      3351,
      7,
      9588,
      132,
      955,
      9589,
      958,
      529,
      959,
      960,
      964,
      135,
      4296,
      967,
      1620,
      1489,
      971,
      972,
      973,
      974,
      975,
      976,
      1622,
      1444,
      980,
      981,
      7535,
      2631,
      32,
      986
    ],
  ),
  "featured_play_list": SymbolsMetadata(
    popularity: 679,
    codepoint: 0xe06d,
    categories: [0],
    tags: [
      1538,
      1129,
      2155,
      3337,
      4800,
      9590,
      2080,
      1066,
      2159,
      366,
      92,
      367,
      788,
      328,
      2081,
      656,
      2162,
      2163,
      2648,
      100,
      8819,
      75,
      77,
      371,
      2164,
      1156,
      32,
      107,
      2165,
      41
    ],
  ),
  "featured_seasonal_and_gifts": SymbolsMetadata(
    popularity: 630,
    codepoint: 0xef91,
    categories: [15],
    tags: [
      8989,
      5302,
      9591,
      9592,
      7,
      5150,
      5600,
      5751,
      1329,
      4800,
      5942,
      9593,
      9594,
      9595,
      6155,
      2018,
      9187,
      2742,
      6995,
      2647,
      5591,
      3581,
      1050,
      3584,
      2368,
      9596,
      841,
      3586,
      9597,
      732
    ],
  ),
  "featured_video": SymbolsMetadata(
    popularity: 475,
    codepoint: 0xe06e,
    categories: [0],
    tags: [
      9598,
      1037,
      267,
      1469,
      12,
      3337,
      4800,
      9599,
      270,
      1738,
      274,
      3019,
      9590,
      1251,
      7497,
      367,
      278,
      328,
      2162,
      5208,
      1518,
      1050,
      8819,
      75,
      330,
      371,
      2997,
      9600,
      32,
      3264,
      41,
      2102,
      1054
    ],
  ),
  "feedback": SymbolsMetadata(
    popularity: 1323,
    codepoint: 0xe87f,
    categories: [6],
    tags: [
      3175,
      469,
      1245,
      3073,
      471,
      1693,
      472,
      1401,
      473,
      474,
      443,
      476,
      3176,
      9601,
      2766,
      2767,
      3177,
      9150,
      9602,
      2768,
      480,
      1251,
      851,
      135,
      2769,
      1641,
      485,
      486,
      2772,
      1353,
      9603,
      2631,
      1121,
      493,
      494,
      553,
      35,
      38,
      9604,
      1261
    ],
  ),
  "female": SymbolsMetadata(
    popularity: 2280,
    codepoint: 0xe590,
    categories: [3],
    tags: [
      468,
      470,
      9605,
      383,
      1202,
      9392,
      1790,
      9606,
      9607,
      1791,
      1795,
      8847,
      850,
      9608,
      8851,
      3982,
      489,
      202,
      490,
      3610,
      9609,
      607,
      35,
      501,
      9610,
      9611,
      3613,
      5012,
      8854,
      9612
    ],
  ),
  "femur": SymbolsMetadata(
    popularity: 171,
    codepoint: 0xf891,
    categories: [3],
    tags: [
      3919,
      5177,
      2412,
      584,
      9613,
      4291,
      9614,
      9615,
      9616,
      9617,
      9618,
      9619,
      9620,
      9621,
      9622,
      595,
      9623,
      4637,
      9624,
      9625,
      1955,
      9626,
      1757,
      9627,
      9628,
      7365,
      9629,
      9630,
      9631,
      5319
    ],
  ),
  "femur_alt": SymbolsMetadata(
    popularity: 165,
    codepoint: 0xf892,
    categories: [3],
    tags: [
      3919,
      2412,
      584,
      4291,
      9632,
      9633,
      9616,
      2136,
      9619,
      9620,
      9634,
      9622,
      595,
      9623,
      4637,
      3201,
      9624,
      9625,
      1955,
      9626,
      1757,
      9627,
      9635,
      1723,
      9636,
      9630,
      9637,
      9631,
      9638
    ],
  ),
  "fence": SymbolsMetadata(
    popularity: 379,
    codepoint: 0xf1f6,
    categories: [8],
    tags: [
      755,
      7653,
      9639,
      349,
      9640,
      994,
      9641,
      1370,
      2604,
      5251,
      6104,
      9642,
      7629,
      6816,
      6105,
      9643,
      999,
      1435,
      9644,
      1859,
      9286,
      1004,
      1696,
      1860,
      3841,
      9645,
      8443,
      1006,
      9646,
      1517,
      1444,
      1520,
      3310,
      1011,
      2264,
      9647,
      9648,
      5021,
      7641
    ],
  ),
  "fertile": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf6e5,
    categories: [15],
    tags: [
      1812,
      84,
      6886,
      4465,
      7621,
      7622,
      9649,
      9650,
      6188,
      385,
      7985,
      1890,
      1825,
      1790,
      9651,
      2926,
      2433,
      6816,
      6817,
      196,
      595,
      5603,
      9652,
      9653,
      1859,
      8830,
      9654,
      9655,
      1835,
      9656,
      9657,
      2439,
      6825,
      441,
      7640,
      9658
    ],
  ),
  "festival": SymbolsMetadata(
    popularity: 893,
    codepoint: 0xea68,
    categories: [16],
    tags: [
      3332,
      9659,
      6228,
      3336,
      5150,
      9660,
      194,
      4713,
      8258,
      3337,
      2094,
      3338,
      3341,
      2819,
      6278,
      2018,
      6868,
      1490,
      1291,
      9661,
      2081,
      1860,
      487,
      9662,
      189,
      2613,
      3347,
      6705,
      9663,
      5578,
      6709,
      9664,
      1504,
      2024
    ],
  ),
  "fiber_dvr": SymbolsMetadata(
    popularity: 170,
    codepoint: 0xe05d,
    categories: [0],
    tags: [
      186,
      4,
      1180,
      1888,
      7,
      4364,
      8,
      88,
      8592,
      8593,
      1711,
      9665,
      14,
      19,
      9666,
      223,
      1082,
      9667,
      2648,
      9668,
      1318,
      121,
      9669,
      1154,
      177,
      3515,
      77,
      6315,
      1031,
      9670,
      32,
      9671,
      35,
      343,
      38,
      9672,
      344,
      40,
      41,
      1690
    ],
  ),
  "fiber_manual_record": SymbolsMetadata(
    popularity: 3895,
    codepoint: 0xe061,
    categories: [0],
    tags: [
      1242,
      9673,
      116,
      383,
      832,
      9665,
      9674,
      9675,
      901,
      188,
      7919,
      367,
      6467,
      907,
      909,
      1082,
      2162,
      283,
      9676,
      121,
      5489,
      177,
      1257,
      227,
      108,
      5545,
      553,
      1083,
      5546,
      314,
      9677,
      9678,
      2102
    ],
  ),
  "fiber_new": SymbolsMetadata(
    popularity: 1053,
    codepoint: 0xe05e,
    categories: [0],
    tags: [
      469,
      4,
      1245,
      2014,
      6,
      7,
      8,
      1042,
      529,
      9665,
      14,
      274,
      3019,
      135,
      18,
      9679,
      19,
      223,
      763,
      2503,
      486,
      2742,
      1622,
      1050,
      1029,
      75,
      3068,
      77,
      35,
      2384,
      38,
      40,
      1260,
      5145,
      9680
    ],
  ),
  "fiber_pin": SymbolsMetadata(
    popularity: 201,
    codepoint: 0xe06a,
    categories: [0],
    tags: [
      4,
      2520,
      1058,
      1670,
      8,
      1484,
      2522,
      9665,
      2525,
      14,
      1488,
      3019,
      1251,
      18,
      19,
      1001,
      1002,
      1641,
      21,
      421,
      223,
      1532,
      1493,
      1495,
      1363,
      1496,
      9681,
      1030,
      1664,
      1773,
      3493,
      35,
      9682,
      2384,
      36,
      38,
      9683,
      40
    ],
  ),
  "fiber_smart_record": SymbolsMetadata(
    popularity: 258,
    codepoint: 0xe062,
    categories: [0],
    tags: [
      2827,
      1132,
      2148,
      355,
      116,
      383,
      953,
      2566,
      211,
      832,
      9684,
      9665,
      3053,
      1897,
      390,
      367,
      6467,
      9685,
      1082,
      2162,
      121,
      177,
      227,
      1155,
      1901,
      9686,
      9687,
      108,
      1083,
      342,
      2102
    ],
  ),
  "file_copy": SymbolsMetadata(
    popularity: 5079,
    codepoint: 0xe173,
    categories: [12],
    tags: [
      3753,
      1042,
      6998,
      4780,
      1707,
      9688,
      9689,
      9690,
      1062,
      5808,
      1528,
      1347,
      9691,
      9692,
      2999,
      9693,
      1530,
      9694,
      9695,
      4783,
      2557,
      4916,
      1534,
      9696,
      2841,
      5482,
      7001,
      107,
      1069,
      8056,
      9697
    ],
  ),
  "file_copy_off": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf4d8,
    categories: [12],
    tags: [
      1074,
      895,
      9698,
      1042,
      1707,
      9699,
      5808,
      897,
      1077,
      9700,
      767,
      1528,
      1347,
      9701,
      2999,
      898,
      1530,
      9694,
      9702,
      899,
      2557,
      4145,
      9703,
      9704,
      8304,
      907,
      908,
      909,
      2841,
      5594,
      9705,
      911,
      9706,
      3310,
      914,
      107,
      1083,
      9707
    ],
  ),
  "file_download_off": SymbolsMetadata(
    popularity: 753,
    codepoint: 0xe4fe,
    categories: [2],
    tags: [
      380,
      2650,
      9708,
      894,
      9709,
      4565,
      767,
      2651,
      337,
      9710,
      1654,
      898,
      1672,
      9711,
      1530,
      8463,
      9712,
      899,
      9713,
      9714,
      1674,
      7067,
      9715,
      9716,
      9717,
      907,
      908,
      909,
      9718,
      9719,
      9720,
      1664,
      9721,
      914,
      9722,
      9723,
      915,
      346
    ],
  ),
  "file_export": SymbolsMetadata(
    popularity: 96,
    codepoint: 0xf3b2,
    categories: [2],
    tags: [
      380,
      7,
      1707,
      1062,
      2173,
      1528,
      1347,
      337,
      1654,
      1672,
      2628,
      6243,
      1530,
      777,
      2652,
      1542,
      935,
      778,
      2653,
      2398,
      4189,
      1534,
      1535,
      2504,
      3068,
      2844,
      1396,
      3046,
      1664,
      2343,
      1665,
      32,
      441,
      2007,
      346
    ],
  ),
  "file_json": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xf3bb,
    categories: [2],
    tags: [
      1230,
      3638,
      8,
      2624,
      268,
      10,
      7383,
      2625,
      1347,
      337,
      2627,
      1530,
      3540,
      14,
      1372,
      2551,
      305,
      9724,
      6587,
      7516,
      9725,
      4706,
      19,
      422,
      2653,
      2630,
      75,
      77,
      1664,
      3379,
      65,
      1196,
      32,
      674,
      35,
      38,
      2007,
      40,
      346,
      1691
    ],
  ),
  "file_map": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xe2c5,
    categories: [5],
    tags: [
      1429,
      2151,
      10,
      1578,
      1347,
      337,
      1530,
      9726,
      1486,
      1487,
      1488,
      135,
      1001,
      9727,
      1002,
      9728,
      1641,
      21,
      421,
      1493,
      1494,
      1495,
      1783,
      1496,
      1503,
      1664,
      5781,
      32,
      674,
      1504,
      346
    ],
  ),
  "file_map_stack": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf3e2,
    categories: [5],
    tags: [
      2151,
      9729,
      9730,
      2155,
      10,
      6936,
      1347,
      1530,
      1655,
      2469,
      9731,
      1487,
      1488,
      930,
      135,
      1066,
      92,
      1001,
      1002,
      1641,
      21,
      2557,
      421,
      1081,
      1493,
      1495,
      2613,
      1783,
      1496,
      5781,
      32,
      107,
      1069,
      674
    ],
  ),
  "file_open": SymbolsMetadata(
    popularity: 4169,
    codepoint: 0xeaf3,
    categories: [2],
    tags: [
      755,
      526,
      380,
      5124,
      9732,
      1042,
      1062,
      10,
      1528,
      1347,
      1654,
      958,
      1530,
      4783,
      1656,
      1542,
      135,
      966,
      1044,
      1375,
      3513,
      2653,
      9733,
      1534,
      1535,
      2506,
      2844,
      9734,
      1677,
      346,
      317
    ],
  ),
  "file_png": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf3bc,
    categories: [1],
    tags: [
      1466,
      9735,
      7,
      8,
      88,
      1347,
      337,
      1672,
      1530,
      7385,
      14,
      1372,
      2551,
      305,
      16,
      53,
      9736,
      1542,
      9724,
      4706,
      19,
      9737,
      367,
      119,
      9738,
      9739,
      4584,
      75,
      77,
      1664,
      32,
      35,
      38,
      40,
      346
    ],
  ),
  "file_present": SymbolsMetadata(
    popularity: 1520,
    codepoint: 0xea0e,
    categories: [12],
    tags: [
      755,
      2151,
      1058,
      3063,
      1469,
      1042,
      10,
      9740,
      1528,
      1347,
      337,
      1654,
      9741,
      1672,
      1530,
      9742,
      1656,
      1657,
      6126,
      9743,
      1542,
      135,
      935,
      9744,
      1532,
      2653,
      1534,
      1535,
      5591,
      75,
      1030,
      1664,
      1665,
      4788,
      4789,
      32,
      674,
      9745,
      346,
      317,
      704
    ],
  ),
  "file_save": SymbolsMetadata(
    popularity: 132,
    codepoint: 0xf17f,
    categories: [12],
    tags: [
      2151,
      380,
      2650,
      1651,
      1042,
      10,
      2157,
      1528,
      1347,
      2651,
      2840,
      337,
      9746,
      1654,
      1672,
      1530,
      8463,
      9747,
      9748,
      1656,
      1657,
      1542,
      135,
      8482,
      1534,
      1535,
      9749,
      121,
      1664,
      9750,
      4788,
      4789,
      674,
      1298,
      2007,
      1536,
      704
    ],
  ),
  "file_save_off": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xe505,
    categories: [12],
    tags: [
      380,
      1074,
      895,
      6005,
      1202,
      10,
      2969,
      767,
      2157,
      1528,
      1347,
      2651,
      337,
      1654,
      898,
      1530,
      9751,
      9748,
      1656,
      1657,
      899,
      901,
      8482,
      1602,
      7533,
      9752,
      907,
      909,
      599,
      4450,
      1519,
      171,
      1664,
      4788,
      914,
      4789,
      1083,
      674,
      915,
      4797,
      704,
      3736
    ],
  ),
  "file_upload_off": SymbolsMetadata(
    popularity: 388,
    codepoint: 0xf886,
    categories: [2],
    tags: [
      380,
      2052,
      419,
      9753,
      9754,
      7,
      9755,
      9756,
      1653,
      9757,
      9758,
      9759,
      9760,
      9761,
      9762,
      9763,
      767,
      1347,
      337,
      1654,
      898,
      1672,
      1530,
      6551,
      9764,
      9765,
      9766,
      9767,
      1542,
      9768,
      9714,
      9769,
      9770,
      9771,
      9772,
      907,
      908,
      909,
      2343,
      9773,
      9774,
      914,
      2007,
      9723,
      9775,
      1676,
      346,
      6547,
      9776
    ],
  ),
  "files": SymbolsMetadata(
    popularity: 590,
    codepoint: 0xea85,
    categories: [12],
    tags: [
      755,
      2151,
      5124,
      2155,
      1042,
      10,
      6936,
      1528,
      1347,
      337,
      1654,
      958,
      1530,
      4783,
      1655,
      1656,
      930,
      135,
      1065,
      2159,
      92,
      2557,
      2653,
      98,
      4916,
      1534,
      1535,
      2843,
      1664,
      4788,
      4789,
      107,
      674,
      2007,
      346,
      317
    ],
  ),
  "filter": SymbolsMetadata(
    popularity: 647,
    codepoint: 0xe3d3,
    categories: [1],
    tags: [
      1538,
      1367,
      5798,
      1042,
      696,
      2299,
      2567,
      959,
      1541,
      930,
      53,
      5800,
      1543,
      1066,
      2159,
      1755,
      367,
      1544,
      1545,
      2557,
      98,
      4916,
      59,
      61,
      5801,
      119,
      5802,
      2493,
      288,
      371,
      65,
      106,
      32,
      107,
      317
    ],
  ),
  "filter_1": SymbolsMetadata(
    popularity: 670,
    codepoint: 0xe3d0,
    categories: [1],
    tags: [
      79,
      3751,
      1062,
      6676,
      1735,
      11,
      696,
      2299,
      2567,
      959,
      9777,
      90,
      53,
      5800,
      5206,
      7005,
      7181,
      3759,
      2557,
      23,
      9778,
      24,
      3542,
      656,
      61,
      119,
      5802,
      329,
      5208,
      2493,
      1742,
      288,
      371,
      2264,
      604,
      65,
      7198,
      106,
      9779,
      32,
      107,
      35
    ],
  ),
  "filter_2": SymbolsMetadata(
    popularity: 358,
    codepoint: 0xe3d1,
    categories: [1],
    tags: [
      81,
      1367,
      1707,
      6873,
      11,
      3108,
      6788,
      2999,
      696,
      2299,
      2567,
      959,
      9780,
      9781,
      9782,
      53,
      5800,
      9783,
      1066,
      2557,
      9784,
      23,
      7200,
      24,
      656,
      98,
      4916,
      9785,
      61,
      119,
      5802,
      2493,
      9786,
      103,
      371,
      65,
      106,
      107,
      9787,
      35,
      315,
      9788
    ],
  ),
  "filter_3": SymbolsMetadata(
    popularity: 318,
    codepoint: 0xe3d2,
    categories: [1],
    tags: [
      82,
      2170,
      6873,
      11,
      12,
      696,
      2299,
      2567,
      959,
      53,
      5800,
      1066,
      459,
      92,
      2557,
      6834,
      23,
      24,
      656,
      96,
      98,
      4916,
      61,
      119,
      5802,
      329,
      99,
      100,
      2493,
      2851,
      330,
      288,
      371,
      65,
      9789,
      106,
      107,
      35,
      110,
      374,
      317
    ],
  ),
  "filter_4": SymbolsMetadata(
    popularity: 321,
    codepoint: 0xe3d4,
    categories: [1],
    tags: [
      534,
      2170,
      3095,
      785,
      6873,
      1735,
      11,
      12,
      696,
      2299,
      2567,
      959,
      9790,
      538,
      9791,
      53,
      5800,
      1066,
      459,
      2557,
      9784,
      6834,
      24,
      656,
      98,
      2559,
      9785,
      61,
      119,
      5802,
      329,
      2493,
      9792,
      2851,
      371,
      65,
      9789,
      106,
      32,
      107,
      35,
      317
    ],
  ),
  "filter_5": SymbolsMetadata(
    popularity: 239,
    codepoint: 0xe3d5,
    categories: [1],
    tags: [
      564,
      1367,
      3095,
      6873,
      1735,
      11,
      696,
      2299,
      2567,
      959,
      9793,
      4709,
      932,
      53,
      5800,
      1066,
      459,
      92,
      2557,
      23,
      9794,
      24,
      656,
      98,
      4916,
      61,
      119,
      5802,
      329,
      2493,
      171,
      2851,
      980,
      288,
      371,
      65,
      106,
      32,
      107,
      35
    ],
  ),
  "filter_6": SymbolsMetadata(
    popularity: 181,
    codepoint: 0xe3d6,
    categories: [1],
    tags: [
      580,
      1367,
      6,
      3095,
      6873,
      1735,
      11,
      696,
      2299,
      2567,
      6243,
      959,
      9795,
      53,
      5800,
      7005,
      1066,
      459,
      2557,
      23,
      9796,
      24,
      656,
      4916,
      5922,
      61,
      119,
      5802,
      329,
      2493,
      171,
      288,
      371,
      2264,
      65,
      7207,
      106,
      32,
      107,
      35
    ],
  ),
  "filter_7": SymbolsMetadata(
    popularity: 232,
    codepoint: 0xe3d7,
    categories: [1],
    tags: [
      636,
      6,
      7,
      3751,
      1062,
      9,
      6873,
      11,
      696,
      2299,
      2567,
      959,
      53,
      5800,
      7005,
      1066,
      459,
      2557,
      6834,
      23,
      24,
      656,
      4916,
      61,
      119,
      5802,
      329,
      2493,
      2851,
      980,
      288,
      371,
      65,
      641,
      106,
      32,
      107,
      35
    ],
  ),
  "filter_8": SymbolsMetadata(
    popularity: 203,
    codepoint: 0xe3d8,
    categories: [1],
    tags: [
      658,
      2170,
      268,
      6873,
      1735,
      11,
      696,
      2299,
      2567,
      661,
      6243,
      959,
      53,
      5800,
      7005,
      1066,
      459,
      2557,
      23,
      9797,
      24,
      656,
      98,
      4916,
      61,
      119,
      5802,
      329,
      2493,
      171,
      330,
      288,
      2264,
      65,
      9789,
      106,
      32,
      107,
      35
    ],
  ),
  "filter_9": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xe3d9,
    categories: [1],
    tags: [
      677,
      1367,
      7,
      3095,
      785,
      9,
      6873,
      11,
      12,
      696,
      2299,
      2567,
      959,
      53,
      5800,
      1066,
      459,
      2557,
      682,
      23,
      24,
      656,
      98,
      4916,
      1081,
      61,
      119,
      5802,
      329,
      2493,
      3310,
      2851,
      371,
      2264,
      65,
      106,
      32,
      107,
      35,
      317
    ],
  ),
  "filter_9_plus": SymbolsMetadata(
    popularity: 211,
    codepoint: 0xe3da,
    categories: [1],
    tags: [
      192,
      677,
      9798,
      9799,
      9800,
      9801,
      158,
      1074,
      9802,
      9803,
      159,
      1062,
      11,
      696,
      2299,
      2567,
      9804,
      959,
      53,
      5800,
      9805,
      9806,
      1066,
      459,
      9807,
      2557,
      9808,
      9809,
      24,
      9810,
      875,
      169,
      61,
      119,
      5802,
      202,
      171,
      9811,
      330,
      65,
      32,
      107,
      1069,
      35,
      878
    ],
  ),
  "filter_alt": SymbolsMetadata(
    popularity: 16964,
    codepoint: 0xef4f,
    categories: [2],
    tags: [
      1367,
      266,
      9803,
      1735,
      9812,
      696,
      6243,
      959,
      9813,
      9814,
      7085,
      9815,
      9816,
      6834,
      656,
      98,
      329,
      2493,
      17