// Copyright (c) 2023, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'package:analyzer/src/error/codes.dart';
import 'package:test_reflective_loader/test_reflective_loader.dart';

import '../dart/resolution/context_collection_resolution.dart';

main() {
  defineReflectiveSuite(() {
    defineReflectiveTests(BuiltInIdentifierAsExtensionTypeNameTest);
  });
}

@reflectiveTest
class BuiltInIdentifierAsExtensionTypeNameTest
    extends PubPackageResolutionTest {
  test_as() async {
    await assertErrorsInCode(
      r'''
extension type as(int it) {}
''',
      [
        error(
          CompileTimeErrorCode.BUILT_IN_IDENTIFIER_AS_EXTENSION_TYPE_NAME,
          15,
          2,
        ),
      ],
    );
  }

  test_Function() async {
    await assertErrorsInCode(
      r'''
extension type Function(int it) {}
''',
      [
        error(
          CompileTimeErrorCode.BUILT_IN_IDENTIFIER_AS_EXTENSION_TYPE_NAME,
          15,
          8,
        ),
      ],
    );
  }
}
