// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class AppLocalizationsRu extends AppLocalizations {
  AppLocalizationsRu([String locale = 'ru']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Русский';

  @override
  String s_translated(int percentage) {
    return 'Переведено: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Вычитка: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Неполный перевод';

  @override
  String get p_translation_progress_desc =>
      'Показатели прогресса отражают зрелость перевода.';

  @override
  String get s_community => 'Сообщество';

  @override
  String get l_localization_project => 'Проект локализации';

  @override
  String get s_save => 'Сохранить';

  @override
  String get s_cancel => 'Отмена';

  @override
  String get s_close => 'Закрыть';

  @override
  String get s_delete => 'Удалить';

  @override
  String get s_move => 'Переместить';

  @override
  String get s_quit => 'Выйти';

  @override
  String get s_enable => 'Включить';

  @override
  String get s_enabled => 'Включено';

  @override
  String get s_disabled => 'Отключено';

  @override
  String get s_status => 'Статус';

  @override
  String get s_unlock => 'Разблокировать';

  @override
  String get s_calculate => 'Вычислить';

  @override
  String get s_import => 'Импортировать';

  @override
  String get s_overwrite => 'Перезаписать';

  @override
  String get s_done => 'Готово';

  @override
  String get s_success => 'Выполнено';

  @override
  String get s_loading => 'Загрузка…';

  @override
  String get s_more => 'Подробнее';

  @override
  String get s_label => 'Этикетка';

  @override
  String get s_name => 'Имя';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Опции';

  @override
  String get s_details => 'Сведения';

  @override
  String get s_show_window => 'Показать окно';

  @override
  String get s_hide_window => 'Скрыть окно';

  @override
  String get s_show_navigation => 'Показать навигацию';

  @override
  String get s_expand_navigation => 'Развернуть панель навигации';

  @override
  String get s_collapse_navigation => 'Свернуть панель навигации';

  @override
  String get s_expand_collapse_navigation =>
      'Развернуть/свернуть панель навигации';

  @override
  String get s_show_menu => 'Показать меню';

  @override
  String get s_toggle_menu_bar => 'Показать/скрыть строку меню';

  @override
  String get s_more_info => 'Дополнительная информация';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'О программе';

  @override
  String get s_algorithm => 'Алгоритм';

  @override
  String get s_appearance => 'Внешний вид';

  @override
  String get s_actions => 'Действия';

  @override
  String get s_manage => 'Управление';

  @override
  String get s_setup => 'Настройка';

  @override
  String get s_device => 'Устройство';

  @override
  String get s_application => 'Приложение';

  @override
  String get s_settings => 'Настройки';

  @override
  String get s_reset_settings => 'Сброс настроек';

  @override
  String get l_reset_settings_desc => 'Восстановить настройки по умолчанию';

  @override
  String get q_reset_settings => 'Сбросить настройки?';

  @override
  String get p_reset_settings_confirmation_desc =>
      'Это восстановит все настройки до значений по умолчанию.';

  @override
  String get s_support => 'Поддержка';

  @override
  String get s_certificates => 'Сертификаты';

  @override
  String get s_security_key => 'Ключ безопасности';

  @override
  String get s_slots => 'Слоты';

  @override
  String get s_help_and_about => 'Помощь и о нас';

  @override
  String get s_help => 'Помощь';

  @override
  String get s_app_information => 'Информация о приложении';

  @override
  String get s_home => 'Главная';

  @override
  String get s_user_guide => 'Руководство пользователя';

  @override
  String get s_i_need_help => 'Мне нужна помощь';

  @override
  String get s_terms_of_use => 'Условия использования';

  @override
  String get s_privacy_policy => 'Политика конфиденциальности';

  @override
  String get s_open_src_licenses => 'Лицензии с открытым исходным кодом';

  @override
  String get s_please_wait => 'Пожалуйста, подождите…';

  @override
  String get s_secret_key => 'Секретный ключ';

  @override
  String get s_show_secret_key => 'Показать секретный ключ';

  @override
  String get s_hide_secret_key => 'Скрыть секретный ключ';

  @override
  String get s_private_key => 'Закрытый ключ';

  @override
  String get s_public_key => 'Открытый ключ';

  @override
  String get s_invalid_length => 'Недопустимая длина';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Недопустимый формат, допустимые символы: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Недопустимые символы для выбранной клавиатуры';

  @override
  String get s_require_touch => 'Требуется прикосновение';

  @override
  String get q_have_account_info => 'У вас есть информация об учетной записи?';

  @override
  String get s_debugging_tools => 'Инструменты отладки';

  @override
  String get s_run_diagnostics => 'Запустить диагностику';

  @override
  String get l_run_diagnostics_desc =>
      'Запустите диагностику для устранения неполадок';

  @override
  String get s_logging_level => 'Уровень журнала';

  @override
  String s_current_log_level(String level) {
    return 'Уровень журнала: $level';
  }

  @override
  String get s_character_count => 'Количество символов';

  @override
  String get s_language => 'Язык';

  @override
  String get s_app_theme => 'Тема приложения';

  @override
  String get s_system_default => 'Системный дефолт';

  @override
  String get s_light_mode => 'Светлый режим';

  @override
  String get s_dark_mode => 'Темный режим';

  @override
  String get s_list_layout => 'Расположение списка';

  @override
  String get s_grid_layout => 'Расположение сетки';

  @override
  String get s_mixed_layout => 'Смешанная планировка';

  @override
  String get s_select_layout => 'Выберите макет';

  @override
  String get s_select_to_scan => 'Выберите для сканирования';

  @override
  String get s_hide_reader => 'Скрыть считыватель';

  @override
  String get s_show_hidden_readers => 'Показать скрытые считыватели';

  @override
  String get s_toggle_readers => 'Переключать считыватели';

  @override
  String get l_toggle_readers_desc => 'Показать или скрыть считыватели';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Серийный номер: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Версия прошивки: $version';
  }

  @override
  String get l_fips_capable => 'Поддерживает FIPS';

  @override
  String get l_fips_approved => 'Одобрен FIPS';

  @override
  String get l_insert_yk => 'Вставьте свой YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Вставьте или коснитесь YubiKey';

  @override
  String get l_unplug_yk => 'Отключите свой YubiKey от сети';

  @override
  String get l_reinsert_yk => 'Снова вставьте YubiKey';

  @override
  String get l_place_on_nfc_reader =>
      'Поместите свой YubiKey на считыватель NFC';

  @override
  String get l_replace_yk_on_reader =>
      'Положите свой YubiKey обратно на считывающее устройство';

  @override
  String get l_remove_yk_from_reader => 'Уберите YubiKey со считывателя NFC';

  @override
  String get p_try_reinsert_yk =>
      'Попробуйте снять и снова вставить свой YubiKey.';

  @override
  String get s_touch_required => 'Требуется касание';

  @override
  String get l_touch_button_now =>
      'Прикоснись к кнопке на своем YubiKey прямо сейчас';

  @override
  String get l_long_touch_button_now =>
      'Нажмите и удерживайте кнопку на вашем YubiKey в течение 10 секунд';

  @override
  String get l_keep_touching_yk =>
      'Продолжайте постоянно прикасаться к своему YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Переключить приложения';

  @override
  String get s_toggle_interfaces => 'Переключать интерфейсы';

  @override
  String get p_toggle_applications_desc =>
      'Включайте или отключайте приложения через доступные транспортные средства.';

  @override
  String get p_toggle_interfaces_desc =>
      'Включение или выключение USB-интерфейсов.';

  @override
  String get l_toggle_applications_desc => 'Включение / выключение приложений';

  @override
  String get l_toggle_interfaces_desc => 'Включение / выключение интерфейсов';

  @override
  String get s_reconfiguring_yk => 'Перенастройка YubiKey…';

  @override
  String get s_config_updated => 'Обновлена конфигурация';

  @override
  String get l_config_updated_reinsert =>
      'Обновлена конфигурация, извлеките и снова вставьте YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 отключен';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn требует, чтобы приложение FIDO2 было включено на вашем YubiKey';

  @override
  String get s_lock_code => 'Код блокировки';

  @override
  String get l_wrong_lock_code => 'Неправильный код блокировки';

  @override
  String get s_show_lock_code => 'Показать код блокировки';

  @override
  String get s_hide_lock_code => 'Скрыть код блокировки';

  @override
  String get p_lock_code_required_desc =>
      'Действие, которое вы собираетесь выполнить, требует ввода кода блокировки конфигурации.';

  @override
  String get l_helper_not_responding => 'Вспомогательный процесс не отвечает';

  @override
  String get l_yk_no_access => 'К этому YubiKey невозможно получить доступ';

  @override
  String get s_yk_inaccessible => 'Устройство недоступно';

  @override
  String get l_open_connection_failed => 'Не удалось открыть соединение';

  @override
  String get l_ccid_connection_failed =>
      'Не удалось установить подключение к смарт-карте';

  @override
  String get p_ccid_service_unavailable =>
      'Убедитесь, что ваш сервис смарт-карт работает.';

  @override
  String get p_pcscd_unavailable =>
      'Убедитесь, что pcscd установлен и запущен.';

  @override
  String get l_no_yk_present => 'Yubikey нет в наличии';

  @override
  String get s_unknown_type => 'Неизвестный тип';

  @override
  String get s_unknown_device => 'Нераспознанное устройство';

  @override
  String get s_restricted_nfc => 'Активация NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Как активировать NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Подключите YubiKey к любому USB-источнику питания, например к компьютеру, не менее чем на 3 секунды.\n\nПосле включения NFC будет активирован и готов к использованию.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Ваш YubiKey оснащен функцией NFC с ограниченным доступом, разработанной для защиты от беспроводных манипуляций во время доставки. Это означает, что операции NFC временно отключены до тех пор, пока вы их не активируете.';

  @override
  String get s_unsupported_yk => 'Неподдерживаемый YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'Операция завершилась неудачей, пожалуйста, попробуйте еще раз.';

  @override
  String get l_configuration_unsupported => 'Конфигурация не поддерживается';

  @override
  String get p_scp_unsupported =>
      'Для связи по NFC YubiKey требуется технология, которая не поддерживается данным телефоном. Пожалуйста, подключите YubiKey к USB-порту телефона.';

  @override
  String get l_error_occurred => 'Произошла ошибка';

  @override
  String get s_application_error => 'Ошибка приложения';

  @override
  String get l_import_error => 'Ошибка импорта';

  @override
  String get l_file_not_found => 'Файл не найден';

  @override
  String get l_file_too_big => 'Слишком большой размер файла';

  @override
  String get l_filesystem_error => 'Ошибка работы файловой системы';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Установить PIN-код';

  @override
  String get s_change_pin => 'Сменить PIN-код';

  @override
  String get s_change_puk => 'Изменить PUK-код';

  @override
  String get s_show_pin => 'Показать PIN-код';

  @override
  String get s_hide_pin => 'Скрыть PIN-код';

  @override
  String get s_show_puk => 'Показать PUK-код';

  @override
  String get s_hide_puk => 'Скрыть PUK-код';

  @override
  String get s_current_pin => 'Текущий PIN-код';

  @override
  String get s_current_puk => 'Текущий PUK-код';

  @override
  String get s_new_pin => 'Новый PIN-код';

  @override
  String get s_new_puk => 'Новый PUK-код';

  @override
  String get s_confirm_pin => 'Подтвердите PIN-код';

  @override
  String get s_confirm_puk => 'Подтвердите PUK-код';

  @override
  String get s_unblock_pin => 'Сбросить PIN-код';

  @override
  String get l_pin_mismatch => 'PIN-коды не совпадают';

  @override
  String get l_puk_mismatch => 'PUK-коды не совпадают';

  @override
  String get s_pin_set => 'Набор ПИН кодов';

  @override
  String get s_puk_set => 'Набор PUK';

  @override
  String l_set_pin_failed(String message) {
    return 'Не удалось установить PIN-код: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'Осталась $retries попытка',
      many: 'Осталось $retries попыток',
      few: 'Осталось $retries попытки',
      one: 'Осталась $retries попытка',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries',
      one: '$retries попытки остаются',
    );
    return 'Неверный PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries попытки остаются',
      one: '$retries попытки остаются',
    );
    return 'Неправильно PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Защита PIN-кода FIDO';

  @override
  String get s_pin_change_required => 'Требуется замена PIN-кода';

  @override
  String get l_enter_fido2_pin => 'Введите PIN-код FIDO2 для вашего YubiKey';

  @override
  String get p_fido2_pin_required =>
      'Действие, которое вы собираетесь выполнить, требует ввода PIN-кода FIDO2';

  @override
  String get l_pin_blocked_reset =>
      'PIN-код заблокирован; сброс настроек приложения FIDO к заводским настройкам';

  @override
  String get l_pin_blocked => 'PIN-код заблокирован';

  @override
  String get l_set_pin_first => 'Требуется PIN-код';

  @override
  String get l_unlock_pin_first => 'Разблокировка с помощью PIN-кода';

  @override
  String get l_pin_soft_locked =>
      'PIN-код был заблокирован до тех пор, пока YubiKey не будет извлечен и вставлен заново';

  @override
  String get l_pin_change_required_desc =>
      'Прежде чем вы сможете использовать это приложение, необходимо установить новый PIN-код';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'PIN-код должен состоять из символов $min_length-$max_length и может содержать буквы, цифры и специальные символы.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'PIN-код должен быть длиной в символы $min_length-$max_length, содержать не менее уникальных символов $unique_characters и не быть часто используемым PIN-кодом, например \"$common_pin\". Он может содержать буквы, цифры и специальные символы.';
  }

  @override
  String get s_ep_attestation => 'Аттестация предприятия';

  @override
  String get s_ep_attestation_enabled => 'Включена Корпоративная аттестация';

  @override
  String get q_enable_ep_attestation => 'Включить корпоративную аттестацию?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Это позволит провести корпоративную аттестацию, позволяя авторизованным доменам однозначно идентифицировать ваш YubiKey.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'После включения корпоративную аттестацию можно отключить, только выполнив сброс настроек FIDO к заводским настройкам.';

  @override
  String get s_pin_required => 'Требуется PIN-код';

  @override
  String get p_pin_required_desc =>
      'Действие, которое вы собираетесь выполнить, требует ввода PIN-кода PIV.';

  @override
  String get l_piv_pin_blocked => 'Заблокирован, используйте PUK для сброса';

  @override
  String get p_piv_pin_blocked_desc =>
      'PIN-код заблокирован. Используйте PUK для его сброса.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'PIN-код заблокирован. Требуется сброс к заводским настройкам.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Заблокирован, требуется сброс к заводским настройкам';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'И PIN-код, и PUK заблокированы. Требуется сброс настроек приложения PIV к заводским настройкам.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name должен содержать не менее $length символов.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name должен быть не менее $length символов, содержать не менее 2 уникальных символов и не быть часто используемым $name, например \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Новый $name не соответствует требованиям сложности.';
  }

  @override
  String get s_dismiss => 'Отменить';

  @override
  String get p_default_pin_puk_key_desc =>
      'Рекомендуется изменить PIN-код по умолчанию, PUK и ключ управления.';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      'Для соответствия требованиям FIPS необходимо изменить PIN-код, PUK-код и ключ управления по умолчанию';

  @override
  String get l_warning_default_pin =>
      'Предупреждение: Используется PIN-код по умолчанию';

  @override
  String get l_warning_default_puk =>
      'Предупреждение: Используется PUK по умолчанию';

  @override
  String get l_default_pin_used => 'Используется PIN-код по умолчанию';

  @override
  String get l_default_puk_used => 'Используется PUK-код по умолчанию';

  @override
  String get l_pin_complexity => 'Принудительная сложность ПИН код';

  @override
  String get s_password => 'Пароль';

  @override
  String get s_manage_password => 'Управление паролем';

  @override
  String get s_set_password => 'Установите пароль';

  @override
  String get s_password_set => 'Установленный пароль';

  @override
  String get s_show_password => 'Показать пароль';

  @override
  String get s_hide_password => 'Скрыть пароль';

  @override
  String get l_password_protection => 'Защита учетных записей паролем';

  @override
  String get s_new_password => 'Новый пароль';

  @override
  String get s_current_password => 'Текущий пароль';

  @override
  String get s_confirm_password => 'Подтвердите пароль';

  @override
  String get l_password_mismatch => 'Пароли не совпадают';

  @override
  String get s_wrong_password => 'Неверный пароль';

  @override
  String get p_wrong_password =>
      'Неверный пароль. Если вы не знаете свой пароль, вам нужно сбросить YubiKey.';

  @override
  String get s_remove_password => 'Удалить пароль';

  @override
  String get s_password_removed => 'Пароль удален';

  @override
  String get s_remember_password => 'Запомнить пароль';

  @override
  String get s_clear_saved_password => 'Очистить сохраненный пароль';

  @override
  String get s_password_forgotten => 'Забытый пароль';

  @override
  String get l_keystore_unavailable =>
      'Хранилище ключей операционной системы недоступно';

  @override
  String get l_remember_pw_failed => 'Не удалось запомнить пароль';

  @override
  String get l_unlock_first => 'Разблокировать паролем';

  @override
  String get l_set_password_first => 'Установить пароль';

  @override
  String get l_enter_oath_pw => 'Введите OATH пароль для вашего YubiKey';

  @override
  String get p_new_password_requirements =>
      'Пароль может содержать буквы, цифры и специальные символы.';

  @override
  String get s_management_key => 'Ключ управления';

  @override
  String get s_current_management_key => 'Текущий ключ управления';

  @override
  String get s_new_management_key => 'Новый ключ управления';

  @override
  String get l_change_management_key => 'Изменить ключ управления';

  @override
  String get l_management_key_changed => 'Ключ управления изменен';

  @override
  String get l_default_key_used => 'Используется ключ управления по умолчанию';

  @override
  String get s_generate_random => 'Сгенерировать случайно';

  @override
  String get s_use_default => 'Использовать по умолчанию';

  @override
  String get l_warning_default_key =>
      'Предупреждение: Используется ключ по умолчанию';

  @override
  String get s_protect_key => 'Защитить PIN-кодом';

  @override
  String get p_protect_key_desc =>
      'Использовать PIN-код вместо ключа управления во время операций, требующих аутентификации ключа управления.';

  @override
  String get s_management_key_algorithm => 'Алгоритм управления ключами';

  @override
  String get p_management_key_algorithm_desc =>
      'Алгоритм для ключа управления.';

  @override
  String get l_pin_protected_key => 'Вместо этого можно использовать PIN-код';

  @override
  String get l_wrong_key => 'Неверный ключ';

  @override
  String get l_unlock_piv_management => 'Разблокировать управление PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'Действие, которое вы собираетесь выполнить, требует ключа управления PIV.';

  @override
  String l_account(String label) {
    return 'Аккаунт: $label';
  }

  @override
  String get s_accounts => 'Аккаунты';

  @override
  String get s_no_accounts => 'Нет учётных записей';

  @override
  String l_results_for(String query) {
    return 'Результаты для \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Начало работы с OTP аккаунтами';

  @override
  String get l_no_accounts_desc =>
      'Добавьте аккаунты в ваш YubiKey от любого поставщика услуг, поддерживающего OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Добавить аккаунт';

  @override
  String get p_add_account_desc =>
      'Отсканируйте QR-код или введите данные учетной записи вручную.';

  @override
  String get s_add_accounts => 'Добавить аккаунт(ы)';

  @override
  String get l_drop_qr_description =>
      'Перетащите QR-код, чтобы добавить аккаунт(ы)';

  @override
  String get p_add_account_three_ways =>
      'Существует три способа добавления учетных записей.';

  @override
  String get s_scanning => 'Сканирование (рекомендуется)';

  @override
  String get p_scanning_desc =>
      'Перед сканированием QR-кода убедитесь, что весь код виден на экране.';

  @override
  String get s_drag_and_drop => 'Перетащите';

  @override
  String get p_drag_and_drop_desc =>
      'Изображение, содержащее QR-код, можно перетащить в любое место на вкладке Аккаунты.';

  @override
  String get s_manually => 'Вручную';

  @override
  String get p_manually_desc =>
      'Данные учетной записи могут быть введены вручную в форме.';

  @override
  String get s_account_added => 'Аккаунт добавлен';

  @override
  String l_account_add_failed(String message) {
    return 'Не удалось добавить аккаунт: $message';
  }

  @override
  String get l_add_account_password_required => 'Требуется пароль';

  @override
  String get l_add_account_unlock_required => 'Требуется разблокировка';

  @override
  String get l_add_account_func_missing =>
      'Функциональность отсутствует или отключена';

  @override
  String get l_account_name_required =>
      'У вашей учетной записи должно быть имя';

  @override
  String get l_name_already_exists =>
      'Такое имя уже существует для этого издателя';

  @override
  String get l_account_already_exists =>
      'Эта учётная запись уже существует на YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Недопустимый символ: \':\' не допускается в издателе';

  @override
  String get l_select_accounts =>
      'Выберите учётную запись(и) для добавления на YubiKey';

  @override
  String get s_pin_account => 'Закрепить учётную запись';

  @override
  String get s_unpin_account => 'Открепить учётную запись';

  @override
  String get s_no_pinned_accounts => 'Нет закреплённых учётных записей';

  @override
  String get s_pinned => 'Закреплено';

  @override
  String get l_pin_account_desc => 'Держите важные учётные записи вместе';

  @override
  String get s_rename_account => 'Переименовать запись';

  @override
  String get l_rename_account_desc => 'Измените издателя/имя учётной записи';

  @override
  String get s_account_renamed => 'Аккаунт переименован';

  @override
  String l_rename_account_failed(String message) {
    return 'Не удалось переименовать учётную запись: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Это изменит отображаемое имя учётной записи в списке.';

  @override
  String get s_delete_account => 'Профиль удален';

  @override
  String get q_delete_account => 'Удалить профиль?';

  @override
  String get l_delete_account_desc => 'Удаление профиля на YubiKey';

  @override
  String get s_account_deleted => 'Профиль удалено';

  @override
  String get p_warning_delete_account =>
      'Внимание! Это действие удалит учётную запись с вашего YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Отключите эту учётную запись в сервисе, иначе вы можете потерять к нему доступ.';

  @override
  String get s_account_name => 'Имя учётной записи';

  @override
  String get s_search_accounts => 'Поиск учётных записей';

  @override
  String l_accounts_used(int used, int capacity) {
    return 'Используется $used из $capacity учётных записей';
  }

  @override
  String s_num_digits(int num) {
    return '$num Цифр';
  }

  @override
  String s_num_sec(int num) {
    return '$num Секунд';
  }

  @override
  String get s_issuer_optional => 'Издатель (необязательно)';

  @override
  String get s_counter_based => 'На основе счётчика';

  @override
  String get s_time_based => 'На основе времени';

  @override
  String get l_copy_code_desc => 'Вставьте код в другое приложение';

  @override
  String get l_calculate_code_desc => 'Получить новый код YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'User ID';

  @override
  String get s_credential_id => 'Идентификатор учетных данных';

  @override
  String get s_display_name => 'Отображаемое имя';

  @override
  String get s_user_name => 'Имя пользователя';

  @override
  String get s_passkeys => 'Ключи входа';

  @override
  String get s_no_passkeys => 'Нет ключей входа';

  @override
  String get l_ready_to_use => 'Готово к использованию';

  @override
  String get l_register_sk_on_websites =>
      'Зарегистрируйте как ключ безопасности на сайтах';

  @override
  String get l_no_discoverable_accounts => 'Ключи входа не сохранены';

  @override
  String get p_non_passkeys_note =>
      'Могут существовать другие учётные данные, но их нельзя отобразить.';

  @override
  String get s_delete_passkey => 'Ключ входа удален';

  @override
  String get q_delete_passkey => 'Удалить ключ входа?';

  @override
  String get l_delete_passkey_desc => 'Удаление ключа для входа YubiKey';

  @override
  String get s_passkey_deleted => 'Ключ входа удалён';

  @override
  String get p_warning_delete_passkey =>
      'Внимание! Это действие удалит ключ входа с вашего YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Вы больше не сможете использовать этот ключ входа для сервиса, где он был зарегистрирован.';

  @override
  String get l_do_not_remove_yk_delete =>
      'Не извлекайте YubiKey во время удаления';

  @override
  String get s_search_passkeys => 'Поиск ключей входа';

  @override
  String p_passkeys_used(int used, int max) {
    return 'Использовано $used из $max  ключей входа.';
  }

  @override
  String get s_biometrics => 'Биометрия';

  @override
  String l_fingerprint(String label) {
    return 'Отпечаток пальца: $label';
  }

  @override
  String get s_fingerprints => 'Отпечатки пальцев';

  @override
  String get l_fingerprint_captured => 'Отпечаток считан успешно!';

  @override
  String get s_fingerprint_added => 'Отпечаток добавлен';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Ошибка при добавлении отпечатка: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Ошибка при установке имени: $message';
  }

  @override
  String get s_setup_fingerprints => 'Настройка отпечатка';

  @override
  String get p_setup_fingerprints_desc =>
      'Для использования ключа необходимо настроить отпечаток.';

  @override
  String get s_add_fingerprint => 'Добавить отпечаток пальца';

  @override
  String get s_delete_fingerprint => 'Удалите отпечаток пальца';

  @override
  String get q_delete_fingerprint => 'Удалить отпечаток пальца?';

  @override
  String get l_delete_fingerprint_desc => 'Удаление YubiKey отпечатка пальца';

  @override
  String get s_fingerprint_deleted => 'Отпечаток пальца удален';

  @override
  String get p_warning_delete_fingerprint =>
      'Это удалит отпечаток пальца с вашего YubiKey.';

  @override
  String get s_fingerprints_get_started =>
      'Начните работу с отпечатками пальцев';

  @override
  String get p_set_fingerprints_desc =>
      'Перед регистрацией отпечатков пальцев необходимо установить PIN-код.';

  @override
  String get l_no_fps_added => 'Отпечатки пальцев не добавлены';

  @override
  String get s_rename_fp => 'Переименовать отпечаток пальца';

  @override
  String get l_rename_fp_desc => 'Изменить имя';

  @override
  String get s_fingerprint_renamed => 'Отпечаток пальца переименован';

  @override
  String l_rename_fp_failed(String message) {
    return 'Ошибка переименования: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Добавьте один или несколько (до пяти) отпечатков пальцев';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 отпечатков пальцев зарегистрировано';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Приложите палец к YubiKey, чтобы начать';

  @override
  String get l_name_fingerprint => 'Назовите этот отпечаток пальца';

  @override
  String get l_user_action_timeout_error =>
      'Не удалось из-за бездействия пользователя';

  @override
  String get l_wrong_inserted_yk_error =>
      'Вставленный заново YubiKey не совпадает с исходным устройством';

  @override
  String get l_failed_connecting_to_fido =>
      'Не удалось подключиться к интерфейсу FIDO';

  @override
  String get l_self_signed_certificate => 'Самоподписанный сертификат';

  @override
  String get l_certificate_signing_request =>
      'Запрос на подписание сертификата (CSR)';

  @override
  String get s_certificate => 'Сертификат';

  @override
  String get s_subject => 'Субъект';

  @override
  String get l_export_csr_file => 'Сохранить CSR в файл';

  @override
  String get l_export_public_key => 'Экспорт публичного ключа';

  @override
  String get l_export_public_key_file => 'Сохранить публичный ключ в файл';

  @override
  String get l_export_public_key_desc => 'Экспорт публичного ключа в файл';

  @override
  String get l_public_key_exported => 'Публичный ключ экспортирован';

  @override
  String get l_export_certificate => 'Экспортировать сертификат';

  @override
  String get l_export_certificate_file => 'Экспортировать сертификат в файл';

  @override
  String get l_export_certificate_desc => 'Экспортировать сертификат в файл';

  @override
  String get l_certificate_exported => 'Сертификат экспортирован';

  @override
  String get l_select_import_file => 'Выберите файл для импорта';

  @override
  String get l_import_file => 'Импортировать файл';

  @override
  String get l_import_desc => 'Импортировать ключ и/или сертификат';

  @override
  String get l_import_nothing => 'Нечего импортировать';

  @override
  String get l_importing_file => 'Импортирование файла…';

  @override
  String get s_file_imported => 'Файл импортирован';

  @override
  String get l_unsupported_key_type => 'Неподдерживаемый тип ключа';

  @override
  String get l_delete_certificate => 'Удалить сертификат';

  @override
  String get q_delete_certificate => 'Удалить сертификат?';

  @override
  String get l_delete_certificate_desc => 'Удалить сертификат с вашего YubiKey';

  @override
  String get l_delete_key => 'Удалить ключ';

  @override
  String get q_delete_key => 'Удалить ключ?';

  @override
  String get l_delete_key_desc => 'Извлеките ключ из вашего YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Удалить сертификат/ключ';

  @override
  String get q_delete_certificate_or_key => 'Удалить сертификат/ключ?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Удалите сертификат или ключ с вашего YubiKey';

  @override
  String get l_move_key => 'Переместить ключ';

  @override
  String get l_move_key_desc =>
      'Перемещение ключа из одного слота PIV в другой';

  @override
  String get l_change_defaults => 'Изменить коды доступа по умолчанию';

  @override
  String get s_issuer => 'Издатель';

  @override
  String get s_serial => 'Серийный';

  @override
  String get s_certificate_fingerprint => 'Отпечаток';

  @override
  String get s_valid_from => 'Действует с';

  @override
  String get s_valid_to => 'Действует до';

  @override
  String get l_no_certificate => 'Сертификат не загружен';

  @override
  String get l_key_no_certificate => 'Ключ без сертификата загружен';

  @override
  String get s_generate_key => 'Сгенерировать ключ';

  @override
  String get l_generate_desc => 'Создать новый сертификат или CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Это создаст новый ключ на YubiKey в слоте PIV $slot.';
  }

  @override
  String get s_private_key_generated => 'Сгенерирован закрытый ключ';

  @override
  String get p_select_what_to_delete => 'Выберите, что удалить из слота.';

  @override
  String get p_warning_delete_certificate =>
      'Внимание! Это действие удалит сертификат с вашего YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Внимание! Это действие удалит закрытый ключ с вашего YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Внимание! Это действие удалит сертификат и закрытый ключ с вашего YubiKey.';

  @override
  String get p_warning_usb_preferred =>
      'Советуем использовать USB для ключей RSA. Использование NFC может приводить к ошибкам.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Это удалит сертификат в слоте PIV $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Это удалит закрытый ключ в слоте PIV $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Это удалит сертификат и закрытый ключ в слоте PIV $slot.';
  }

  @override
  String get l_certificate_deleted => 'Сертификат удален';

  @override
  String get l_key_deleted => 'Ключ удален';

  @override
  String get l_certificate_and_key_deleted => 'Сертификат и ключ удалены';

  @override
  String get l_include_certificate => 'Включить сертификат';

  @override
  String get l_select_destination_slot => 'Выберите слот назначения';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Переместить закрытый ключ в слот PIV $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Переместить закрытый ключ из слота PIV $from_slot в слот $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Переместить закрытый ключ и сертификат из слота PIV $from_slot в слот $to_slot?';
  }

  @override
  String get p_password_protected_file => 'Выбранный файл защищен паролем.';

  @override
  String p_import_items_desc(String slot) {
    return 'В слот PIV $slot будут импортированы следующие предметы.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Публичный ключ сертификата не совпадает с закрытым ключом в слоте';

  @override
  String get l_key_moved => 'Ключ перемещен';

  @override
  String get l_key_and_certificate_moved => 'Ключ и сертификат перемещены';

  @override
  String get p_subject_desc =>
      'Уникальное имя (DN), отформатированное в соответствии со спецификацией RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Неверный формат RFC 4514';

  @override
  String get rfc4514_examples =>
      'Примеры:\nCN=Example Name\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => 'Разрешите использование отпечатка пальцев';

  @override
  String get s_pin_policy => 'Политика PIN';

  @override
  String get s_output_format => 'Выходной формат';

  @override
  String get s_expiration_date => 'Срок действия';

  @override
  String get p_algorithm_desc => 'Используемый алгоритм ключа.';

  @override
  String get p_expiration_date_desc =>
      'Дата окончания сертификата, по умолчанию 1 год (только сертификат).';

  @override
  String get p_key_options_bio_desc =>
      'Использовать биометрию вместо PIN-кода.';

  @override
  String get q_overwrite_slot => 'Перезаписать слот?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Это навсегда перезапишет существующее содержимое слота $slot.';
  }

  @override
  String get l_overwrite_cert => 'Сертификат будет перезаписан';

  @override
  String get l_overwrite_key => 'Приватный ключ будет перезаписан';

  @override
  String get l_overwrite_key_maybe =>
      'Все подключенные приватные ключи будут перезаписаны';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Аутентификация';

  @override
  String get s_slot_9c => 'Цифровая подпись';

  @override
  String get s_slot_9d => 'Управление ключами';

  @override
  String get s_slot_9e => 'Аутентификация карты';

  @override
  String get s_retired_slot => 'Retired Key Management';

  @override
  String get s_otp_slot_one => 'Короткое касание';

  @override
  String get s_otp_slot_two => 'Долгое прикосновение';

  @override
  String get l_otp_slot_empty => 'Слот пуст';

  @override
  String get l_otp_slot_configured => 'Слот настроен';

  @override
  String get l_yubiotp_desc => 'Program a Yubico OTP credential';

  @override
  String get s_challenge_response => 'Challenge-response';

  @override
  String get l_challenge_response_desc =>
      'Program a challenge-response credential';

  @override
  String get s_static_password => 'Static password';

  @override
  String get l_static_password_desc => 'Configure a static password';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Program a HMAC-SHA1 based credential';

  @override
  String get s_public_id => 'Публичный ID';

  @override
  String get s_private_id => 'Приватный ID';

  @override
  String get s_use_serial => 'Use serial';

  @override
  String get l_select_file => 'Выбрать файл';

  @override
  String get l_no_export_file => 'Нет файла для экспорта';

  @override
  String get s_no_export => 'No export';

  @override
  String get s_export => 'Экспорт';

  @override
  String get l_export_configuration_file => 'Экспорт конфигурации в файл';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Экспортированные учетные данные можно загрузить на сайт $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Клавиатура $layout';
  }

  @override
  String get s_delete_slot => 'Delete credential';

  @override
  String get q_delete_slot => 'Delete credential?';

  @override
  String get l_delete_slot_desc => 'Remove credential in slot';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Warning! This action will permanently remove the credential from slot $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Credential deleted';

  @override
  String get s_swap => 'Swap';

  @override
  String get s_swap_slots => 'Swap slots';

  @override
  String get q_swap_slots => 'Swap slots?';

  @override
  String get l_swap_slots_desc => 'Swap short/long touch';

  @override
  String get p_swap_slots_desc => 'Это изменит конфигурацию двух слотов.';

  @override
  String get l_slots_swapped => 'Slot configurations swapped';

  @override
  String l_slot_credential_configured(String type) {
    return 'Configured $type credential';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Configured $type credential and exported to $file';
  }

  @override
  String get s_append_enter => 'Append ⏎';

  @override
  String get l_append_enter_desc =>
      'Append an Enter keystroke after emitting the OTP';

  @override
  String get p_otp_swap_error =>
      'Failed to swap slots! Make sure the YubiKey does not have restrictive access.';

  @override
  String get l_wrong_access_code => 'Неправильный код доступа';

  @override
  String get s_access_code => 'Код доступа';

  @override
  String get s_show_access_code => 'Показать код доступа';

  @override
  String get s_hide_access_code => 'Скрыть код доступа';

  @override
  String p_enter_access_code(String slot) {
    return 'Введите код доступа для слота $slot.';
  }

  @override
  String get s_enable_nfc => 'Включить NFC';

  @override
  String get s_request_access => 'Запросить доступ';

  @override
  String get s_permission_denied => 'Доступ запрещен';

  @override
  String get l_elevating_permissions => 'Elevating permissions…';

  @override
  String get s_review_permissions => 'Просмотр разрешений';

  @override
  String get s_open_windows_settings => 'Открыть Параметры Windows';

  @override
  String get l_admin_privileges_required => 'Требуются права администратора';

  @override
  String get p_elevated_permissions_required =>
      'Managing this device requires elevated privileges. Alternatively, you can use Windows Settings to manage FIDO configuration.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'WebAuthn management requires elevated privileges. Alternatively, you can use Windows Settings to manage FIDO configuration.';

  @override
  String get p_ms_store_permission_note =>
      'Версия приложения для Microsoft Store, как правило, не может повысить разрешения из-за ограничений в песочнице Windows. Мы рекомендуем установить Yubico Authenticator с нашего официального установщика .msi.';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator требует разрешения камеры для сканирования QR-кодов.';

  @override
  String get s_qr_scan => 'Сканировать QR-код';

  @override
  String get l_invalid_qr => 'Некорректный QR-код';

  @override
  String get l_qr_not_found => 'QR-код не найден';

  @override
  String get l_qr_scanned => 'Отсканированный QR-код';

  @override
  String l_qr_file_too_large(String max) {
    return 'Файл слишком большой (макс. $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Недопустимый формат изображения';

  @override
  String get l_qr_select_file => 'Выберите файл с QR-кодом';

  @override
  String l_qr_not_read(String message) {
    return 'Не удалось считать QR-код: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Наведите камеру на QR-код, чтобы отсканировать его';

  @override
  String get q_want_to_scan => 'Хотите отсканировать?';

  @override
  String get q_no_qr => 'Нет QR-кода?';

  @override
  String get s_enter_manually => 'Ввести вручную';

  @override
  String get s_read_from_file => 'Прочитать из файла';

  @override
  String get s_reset => 'Сбросить';

  @override
  String get s_factory_reset => 'Сброс к заводским настройкам';

  @override
  String get l_factory_reset_desc =>
      'Восстановление настроек YubiKey по умолчанию';

  @override
  String get l_factory_reset_required =>
      'Требуется сброс к заводским настройкам';

  @override
  String get l_oath_application_reset => 'OATH application reset';

  @override
  String get l_fido_app_reset => 'FIDO application reset';

  @override
  String l_reset_failed(String message) {
    return 'Error performing reset: $message';
  }

  @override
  String get l_piv_app_reset => 'PIV application reset';

  @override
  String get p_factory_reset_an_app =>
      'Factory reset an application on your YubiKey.';

  @override
  String get p_factory_reset_desc =>
      'Data is stored in multiple applications on the YubiKey, some of which can be factory reset independently of each other.\n\nSelect an application above to reset.';

  @override
  String get p_warning_factory_reset =>
      'Warning! This will irrevocably delete all OATH TOTP/HOTP accounts from your YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Your OATH credentials, as well as any password set, will be removed from this YubiKey. Make sure to disable these from their respective web sites to avoid being locked out of your accounts.';

  @override
  String get p_warning_deletes_accounts =>
      'Warning! This will irrevocably delete all U2F and FIDO2 accounts, including passkeys, from your YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Your credentials, as well as any PIN set, will be removed from this YubiKey. Make sure to disable these from their respective web sites to avoid being locked out of your accounts.';

  @override
  String l_reset_not_allowed_over(String transport) {
    return 'FIDO reset is disabled over $transport';
  }

  @override
  String get p_warning_piv_reset =>
      'Warning! All data stored for PIV will be irrevocably deleted from your YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'This includes private keys and certificates. Your PIN, PUK, and management key will be reset to their factory default values.';

  @override
  String get p_warning_global_reset =>
      'Внимание! Это безвозвратно удалит из YubiKee все сохраненные данные, включая учетные записи.';

  @override
  String get p_warning_global_reset_desc =>
      'Factory reset the applications on your YubiKey. PIN will be reset to its factory default value, and registered fingerprints will be removed. Any keys, certificates, or other credentials will all be permanently removed.';

  @override
  String get l_copy_to_clipboard => 'Скопировать в буфер обмена';

  @override
  String get s_code_copied => 'Код скопирован';

  @override
  String get l_code_copied_clipboard => 'Код скопирован в буфер обмена';

  @override
  String get s_copy_log => 'Скопировать лог';

  @override
  String get l_copy_log_clipboard => 'Скопировать лог в буфер обмена';

  @override
  String get l_log_copied => 'Лог скопирован в буфер обмена';

  @override
  String get l_diagnostics_copied =>
      'Диагностические данные скопированы в буфер обмена';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label скопирован в буфер обмена.';
  }

  @override
  String get s_custom_icons => 'Пользовательские иконки';

  @override
  String get l_set_icons_for_accounts => 'Установить иконки для аккаунтов';

  @override
  String get p_custom_icons_description =>
      'Icon packs can make your accounts more easily distinguishable with familiar logos and colors.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Icon packs use the $aegis_icon_pack format. You can download a pre-made icon pack, or you can create your own.';
  }

  @override
  String get s_replace_icon_pack => 'Заменить набор значков';

  @override
  String get l_loading_icon_pack => 'Загрузка набора значков…';

  @override
  String get s_load_icon_pack => 'Загрузить набор значков';

  @override
  String get l_load_icon_pack_desc => 'Загрузить набор значков из файла';

  @override
  String get s_remove_icon_pack => 'Удалить набор значков';

  @override
  String get l_remove_icon_pack_desc => 'Удалить активный набор значков';

  @override
  String get l_icon_pack_removed => 'Набор значков удалён';

  @override
  String get l_remove_icon_pack_failed => 'Ошибка удаления набора значков';

  @override
  String get s_choose_icon_pack => 'Выбрать набор значков';

  @override
  String get l_icon_pack_imported => 'Пакет значков импортирован';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Error importing icon pack: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Недопустимый набор иконок';

  @override
  String get l_icon_pack_copy_failed =>
      'Не удалось скопировать файлы набора значков';

  @override
  String get s_nfc_and_usb_options => 'Настройки NFC & USB';

  @override
  String get l_nfc_and_usb_options_desc => 'Настроить действие для YubiKey';

  @override
  String get l_on_yk_nfc_tap => 'On NFC tap';

  @override
  String get l_on_yk_usb_insert => 'On USB insert';

  @override
  String get l_do_nothing => 'Do nothing';

  @override
  String get l_launch_ya => 'Launch Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Скопировать OTP в буфер обмена';

  @override
  String get l_launch_and_copy_otp => 'Launch app and copy OTP';

  @override
  String get l_kbd_layout_for_static => 'Keyboard layout (for static password)';

  @override
  String get s_choose_kbd_layout => 'Выберите раскладку клавиатуры';

  @override
  String get l_bypass_touch_requirement => 'Обход требования к прикосновению';

  @override
  String get l_bypass_touch_requirement_on =>
      'Accounts that require touch are automatically shown over NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Accounts that require touch need an additional tap over NFC';

  @override
  String get s_silence_nfc_sounds => 'Silence NFC sounds';

  @override
  String get l_silence_nfc_sounds_on => 'No sounds will be played on NFC tap';

  @override
  String get l_silence_nfc_sounds_off => 'Sound will play on NFC tap';

  @override
  String get l_launch_app_on_usb_on =>
      'This prevents other apps from using the YubiKey over USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Other apps can use the YubiKey over USB';

  @override
  String get s_allow_screenshots => 'Разрешить скриншоты';

  @override
  String get l_allow_screenshots_desc =>
      'Разрешить другим приложениям делать снимки экрана';

  @override
  String get s_nfc_ready_to_scan => 'Ready to scan';

  @override
  String get s_nfc_hold_still => 'Hold still…';

  @override
  String get s_nfc_tap_your_yubikey => 'Tap your YubiKey';

  @override
  String get s_nfc_remove_key => 'Remove YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Failed to scan, try again';

  @override
  String get s_usb_processing => 'Чтение данных на YubiKey';

  @override
  String get s_usb_dont_remove => 'Don\'t remove the key…';

  @override
  String get l_usb_read_error => 'Не удалось считать данные из YubiKey';

  @override
  String get p_ndef_set_otp => 'Код OTP скопирован из YubiKey в буфер обмена.';

  @override
  String get p_ndef_set_password =>
      'Пароль успешно скопирован из YubiKey в буфер обмена.';

  @override
  String get p_ndef_parse_failure =>
      'Не удалось обработать OTP код из YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Не удалось получить доступ к буферу обмена при попытке скопировать код OTP из YubiKey.';

  @override
  String get s_set_label => 'Установить метку';

  @override
  String get s_set_color => 'Установить цвет';

  @override
  String get s_change_label => 'Изменить метку';

  @override
  String get p_set_will_add_custom_name =>
      'Это даст вашему YubiKey пользовательское имя.';

  @override
  String get p_rename_will_change_custom_name => 'Это изменит метку YubiKey.';

  @override
  String get s_keyboard_shortcuts => 'Keyboard shortcuts';

  @override
  String get s_global_shortcuts => 'Горячие клавиши';

  @override
  String get s_application_shortcuts => 'Application shortcuts';

  @override
  String s_quit_app(String app) {
    return 'Закрыть $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Скрыть $app';
  }

  @override
  String get s_search => 'Поиск';

  @override
  String get s_next_device => 'Следующее устройство';

  @override
  String get s_previous_device => 'Предыдущее устройство';

  @override
  String get s_open_settings => 'Открыть настройки';

  @override
  String get s_open_item => 'Open item';

  @override
  String get s_edit_item => 'Edit item';

  @override
  String get s_delete_item => 'Delete item';

  @override
  String get s_calculate_oath_code => 'Calculate OATH code';

  @override
  String get s_open_keyboard_shortcuts => 'Open keyboard shortcuts';
}
