// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Modern Greek (`el`).
class AppLocalizationsEl extends AppLocalizations {
  AppLocalizationsEl([String locale = 'el']) : super(locale);

  @override
  String get app_name => 'Επαληθευτής Yubico';

  @override
  String get native_language_name => 'Ελληνικά';

  @override
  String s_translated(int percentage) {
    return 'Μεταφρασμένο: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Διορθωμένο: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Ελλιπής μετάφραση';

  @override
  String get p_translation_progress_desc =>
      'Οι δείκτες προόδου αντικατοπτρίζουν την ωριμότητα της μετάφρασης.';

  @override
  String get s_community => 'Community';

  @override
  String get l_localization_project => 'Localization project';

  @override
  String get s_save => 'Αποθήκευση';

  @override
  String get s_cancel => 'Άκυρο';

  @override
  String get s_close => 'Κλείσιμο';

  @override
  String get s_delete => 'Διαγραφή';

  @override
  String get s_move => 'Μετακίνηση';

  @override
  String get s_quit => 'Έξοδος';

  @override
  String get s_enable => 'Ενεργοποίηση';

  @override
  String get s_enabled => 'Ενεργοποιημένο';

  @override
  String get s_disabled => 'Απενεργοποιημένο';

  @override
  String get s_status => 'Κατάσταση';

  @override
  String get s_unlock => 'Ξεκλείδωμα';

  @override
  String get s_calculate => 'Υπολογισμός';

  @override
  String get s_import => 'Εισαγωγή';

  @override
  String get s_overwrite => 'Αντικατάσταση';

  @override
  String get s_done => 'Τέλος';

  @override
  String get s_success => 'Success';

  @override
  String get s_loading => 'Loading…';

  @override
  String get s_more => 'More';

  @override
  String get s_label => 'Ετικέτα';

  @override
  String get s_name => 'Όνομα';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Επιλογές';

  @override
  String get s_details => 'Λεπτομέρειες';

  @override
  String get s_show_window => 'Εμφάνιση παραθύρου';

  @override
  String get s_hide_window => 'Απόκρυψη παραθύρου';

  @override
  String get s_show_navigation => 'Εμφάνιση πλοήγησης';

  @override
  String get s_expand_navigation => 'Επέκταση γραμμής πλοήγησης';

  @override
  String get s_collapse_navigation => 'Σύμπτυξη γραμμής πλοήγησης';

  @override
  String get s_expand_collapse_navigation =>
      'Επέκταση/σύμπτυξη γραμμής πλοήγησης';

  @override
  String get s_show_menu => 'Εμφάνιση μενού';

  @override
  String get s_toggle_menu_bar => 'Εναλλαγή γραμμής μενού';

  @override
  String get s_more_info => 'Περισσότερες πληροφορίες';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<κανένα>';

  @override
  String get s_about => 'Πληροφορίες';

  @override
  String get s_algorithm => 'Αλγόριθμος';

  @override
  String get s_appearance => 'Εμφάνιση';

  @override
  String get s_actions => 'Ενέργειες';

  @override
  String get s_manage => 'Διαχείριση';

  @override
  String get s_setup => 'Ρύθμιση';

  @override
  String get s_device => 'Συσκευή';

  @override
  String get s_application => 'Εφαρμογή';

  @override
  String get s_settings => 'Ρυθμίσεις';

  @override
  String get s_reset_settings => 'Reset settings';

  @override
  String get l_reset_settings_desc => 'Restore settings to default';

  @override
  String get q_reset_settings => 'Reset settings?';

  @override
  String get p_reset_settings_confirmation_desc =>
      'This will restore all settings to their default values.';

  @override
  String get s_support => 'Support';

  @override
  String get s_certificates => 'Πιστοποιητικά';

  @override
  String get s_security_key => 'Κλειδί ασφαλείας';

  @override
  String get s_slots => 'Υποδοχές';

  @override
  String get s_help_and_about => 'Help & about';

  @override
  String get s_help => 'Help';

  @override
  String get s_app_information => 'Application information';

  @override
  String get s_home => 'Αρχική';

  @override
  String get s_user_guide => 'Οδηγός χρήσης';

  @override
  String get s_i_need_help => 'Χρειάζομαι βοήθεια';

  @override
  String get s_terms_of_use => 'Όροι χρήσης';

  @override
  String get s_privacy_policy => 'Πολιτική απορρήτου';

  @override
  String get s_open_src_licenses => 'Άδειες ανοιχτού κώδικα';

  @override
  String get s_please_wait => 'Παρακαλώ περιμένετε…';

  @override
  String get s_secret_key => 'Μυστικό κλειδί';

  @override
  String get s_show_secret_key => 'Εμφάνιση μυστικού κλειδιού';

  @override
  String get s_hide_secret_key => 'Απόκρυψη μυστικού κλειδιού';

  @override
  String get s_private_key => 'Ιδιωτικό κλειδί';

  @override
  String get s_public_key => 'Δημόσιο κλειδί';

  @override
  String get s_invalid_length => 'Μη έγκυρο μήκος';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Μη έγκυρη μορφή, επιτρεπόμενοι χαρακτήρες: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Μη έγκυροι χαρακτήρες για το επιλεγμένο πληκτρολόγιο';

  @override
  String get s_require_touch => 'Απαίτηση αφής';

  @override
  String get q_have_account_info => 'Έχετε πληροφορίες λογαριασμού;';

  @override
  String get s_debugging_tools => 'Debugging tools';

  @override
  String get s_run_diagnostics => 'Εκτέλεση διαγνωστικών';

  @override
  String get l_run_diagnostics_desc => 'Run diagnostics to troubleshoot';

  @override
  String get s_logging_level => 'Log level';

  @override
  String s_current_log_level(String level) {
    return 'Log level: $level';
  }

  @override
  String get s_character_count => 'Αριθμός χαρακτήρων';

  @override
  String get s_language => 'Γλώσσα';

  @override
  String get s_app_theme => 'Θέμα εφαρμογής';

  @override
  String get s_system_default => 'Προεπιλογή συστήματος';

  @override
  String get s_light_mode => 'Φωτεινή λειτουργία';

  @override
  String get s_dark_mode => 'Σκοτεινή λειτουργία';

  @override
  String get s_list_layout => 'Διάταξη λίστας';

  @override
  String get s_grid_layout => 'Διάταξη πλέγματος';

  @override
  String get s_mixed_layout => 'Μικτή διάταξη';

  @override
  String get s_select_layout => 'Επιλογή διάταξης';

  @override
  String get s_select_to_scan => 'Επιλογή για σάρωση';

  @override
  String get s_hide_reader => 'Απόκρυψη αναγνώστη';

  @override
  String get s_show_hidden_readers => 'Εμφάνιση κρυφών αναγνωστών';

  @override
  String get s_toggle_readers => 'Εναλλαγή αναγνωστών';

  @override
  String get l_toggle_readers_desc => 'Εμφάνιση ή απόκρυψη αναγνωστών';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Αριθμός σειράς: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Έκδοση υλικολογισμικού: $version';
  }

  @override
  String get l_fips_capable => 'Συμβατό με FIPS';

  @override
  String get l_fips_approved => 'Εγκεκριμένο κατά FIPS';

  @override
  String get l_insert_yk => 'Εισαγάγετε το YubiKey σας';

  @override
  String get l_insert_or_tap_yk => 'Εισαγάγετε ή ακουμπήστε ένα YubiKey';

  @override
  String get l_unplug_yk => 'Αποσυνδέστε το YubiKey σας';

  @override
  String get l_reinsert_yk => 'Επανεισαγάγετε το YubiKey σας';

  @override
  String get l_place_on_nfc_reader =>
      'Τοποθετήστε το YubiKey σας στον αναγνώστη NFC';

  @override
  String get l_replace_yk_on_reader =>
      'Τοποθετήστε ξανά το YubiKey σας στον αναγνώστη';

  @override
  String get l_remove_yk_from_reader =>
      'Αφαιρέστε το YubiKey σας από τον αναγνώστη NFC';

  @override
  String get p_try_reinsert_yk =>
      'Δοκιμάστε να αφαιρέσετε και να επανεισαγάγετε το YubiKey σας.';

  @override
  String get s_touch_required => 'Απαιτείται άγγιγμα';

  @override
  String get l_touch_button_now => 'Αγγίξτε το κουμπί στο YubiKey σας τώρα';

  @override
  String get l_long_touch_button_now =>
      'Press and hold the button on your YubiKey for 10 seconds now';

  @override
  String get l_keep_touching_yk =>
      'Συνεχίστε να αγγίζετε επανειλημμένα το YubiKey σας…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Εναλλαγή εφαρμογών';

  @override
  String get s_toggle_interfaces => 'Εναλλαγή διεπαφών';

  @override
  String get p_toggle_applications_desc =>
      'Ενεργοποίηση ή απενεργοποίηση εφαρμογών μέσω των διαθέσιμων τρόπων μεταφοράς.';

  @override
  String get p_toggle_interfaces_desc =>
      'Ενεργοποίηση ή απενεργοποίηση διεπαφών USB.';

  @override
  String get l_toggle_applications_desc =>
      'Ενεργοποίηση/απενεργοποίηση εφαρμογών';

  @override
  String get l_toggle_interfaces_desc => 'Ενεργοποίηση/απενεργοποίηση διεπαφών';

  @override
  String get s_reconfiguring_yk => 'Επαναδιαμόρφωση YubiKey…';

  @override
  String get s_config_updated => 'Η διαμόρφωση ενημερώθηκε';

  @override
  String get l_config_updated_reinsert =>
      'Η διαμόρφωση ενημερώθηκε, αφαιρέστε και επανεισαγάγετε το YubiKey σας';

  @override
  String get s_fido_disabled => 'Το FIDO2 είναι απενεργοποιημένο';

  @override
  String get l_webauthn_req_fido2 =>
      'Το WebAuthn απαιτεί την ενεργοποίηση της εφαρμογής FIDO2 στο YubiKey σας';

  @override
  String get s_lock_code => 'Κωδικός κλειδώματος';

  @override
  String get l_wrong_lock_code => 'Λανθασμένος κωδικός κλειδώματος';

  @override
  String get s_show_lock_code => 'Εμφάνιση κωδικού κλειδώματος';

  @override
  String get s_hide_lock_code => 'Απόκρυψη κωδικού κλειδώματος';

  @override
  String get p_lock_code_required_desc =>
      'Η ενέργεια που πρόκειται να εκτελέσετε απαιτεί την εισαγωγή του κωδικού κλειδώματος διαμόρφωσης.';

  @override
  String get l_helper_not_responding => 'Η βοηθητική διεργασία δεν αποκρίνεται';

  @override
  String get l_yk_no_access => 'Δεν είναι δυνατή η πρόσβαση σε αυτό το YubiKey';

  @override
  String get s_yk_inaccessible => 'Μη προσβάσιμη συσκευή';

  @override
  String get l_open_connection_failed => 'Αποτυχία ανοίγματος σύνδεσης';

  @override
  String get l_ccid_connection_failed =>
      'Αποτυχία ανοίγματος σύνδεσης έξυπνης κάρτας';

  @override
  String get p_ccid_service_unavailable =>
      'Βεβαιωθείτε ότι η υπηρεσία έξυπνης κάρτας λειτουργεί.';

  @override
  String get p_pcscd_unavailable =>
      'Βεβαιωθείτε ότι το pcscd είναι εγκατεστημένο και εκτελείται.';

  @override
  String get l_no_yk_present => 'Δεν υπάρχει YubiKey';

  @override
  String get s_unknown_type => 'Άγνωστος τύπος';

  @override
  String get s_unknown_device => 'Μη αναγνωρισμένη συσκευή';

  @override
  String get s_restricted_nfc => 'Ενεργοποίηση NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Πώς να ενεργοποιήσετε το NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Συνδέστε το YubiKey σας σε οποιαδήποτε πηγή τροφοδοσίας USB, όπως έναν υπολογιστή, για τουλάχιστον 3 δευτερόλεπτα.\n\nΜόλις τροφοδοτηθεί, το NFC θα ενεργοποιηθεί και θα είναι έτοιμο για χρήση.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Το YubiKey σας είναι εξοπλισμένο με Περιορισμένο NFC, μια λειτουργία σχεδιασμένη για προστασία από ασύρματη παραποίηση κατά την αποστολή. Αυτό σημαίνει ότι οι λειτουργίες NFC είναι προσωρινά απενεργοποιημένες μέχρι να τις ενεργοποιήσετε.';

  @override
  String get s_unsupported_yk => 'Μη υποστηριζόμενο YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'Η λειτουργία απέτυχε, παρακαλώ προσπαθήστε ξανά.';

  @override
  String get l_configuration_unsupported => 'Η διαμόρφωση δεν υποστηρίζεται';

  @override
  String get p_scp_unsupported =>
      'Για επικοινωνία μέσω NFC, το YubiKey απαιτεί τεχνολογία η οποία δεν υποστηρίζεται από αυτό το τηλέφωνο. Παρακαλούμε συνδέστε το YubiKey στη θύρα USB του τηλεφώνου.';

  @override
  String get l_error_occurred => 'Παρουσιάστηκε σφάλμα';

  @override
  String get s_application_error => 'Σφάλμα εφαρμογής';

  @override
  String get l_import_error => 'Σφάλμα εισαγωγής';

  @override
  String get l_file_not_found => 'Το αρχείο δεν βρέθηκε';

  @override
  String get l_file_too_big => 'Το μέγεθος του αρχείου είναι πολύ μεγάλο';

  @override
  String get l_filesystem_error => 'Σφάλμα λειτουργίας συστήματος αρχείων';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Ορισμός PIN';

  @override
  String get s_change_pin => 'Αλλαγή PIN';

  @override
  String get s_change_puk => 'Αλλαγή PUK';

  @override
  String get s_show_pin => 'Εμφάνιση PIN';

  @override
  String get s_hide_pin => 'Απόκρυψη PIN';

  @override
  String get s_show_puk => 'Εμφάνιση PUK';

  @override
  String get s_hide_puk => 'Απόκρυψη PUK';

  @override
  String get s_current_pin => 'Τρέχον PIN';

  @override
  String get s_current_puk => 'Τρέχον PUK';

  @override
  String get s_new_pin => 'Νέο PIN';

  @override
  String get s_new_puk => 'Νέο PUK';

  @override
  String get s_confirm_pin => 'Επιβεβαίωση PIN';

  @override
  String get s_confirm_puk => 'Επιβεβαίωση PUK';

  @override
  String get s_unblock_pin => 'Επαναφορά PIN';

  @override
  String get l_pin_mismatch => 'Τα PIN δεν ταιριάζουν';

  @override
  String get l_puk_mismatch => 'Τα PUK δεν ταιριάζουν';

  @override
  String get s_pin_set => 'Το PIN ορίστηκε';

  @override
  String get s_puk_set => 'Το PUK ορίστηκε';

  @override
  String l_set_pin_failed(String message) {
    return 'Αποτυχία ορισμού PIN: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries attempts remaining',
      one: '$retries attempt remaining',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries attempts remaining',
      one: '$retries attempt remaining',
    );
    return 'Wrong PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries attempts remaining',
      one: '$retries attempt remaining',
    );
    return 'Wrong PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Προστασία PIN FIDO';

  @override
  String get s_pin_change_required => 'Απαιτείται αλλαγή PIN';

  @override
  String get l_enter_fido2_pin => 'Εισαγάγετε το PIN FIDO2 για το YubiKey σας';

  @override
  String get p_fido2_pin_required =>
      'The action you are about to perform requires the FIDO2 PIN to be entered.';

  @override
  String get l_pin_blocked_reset =>
      'Το PIN είναι μπλοκαρισμένο. Κάντε επαναφορά εργοστασιακών ρυθμίσεων της εφαρμογής FIDO';

  @override
  String get l_pin_blocked => 'Το PIN είναι μπλοκαρισμένο';

  @override
  String get l_set_pin_first => 'Απαιτείται PIN';

  @override
  String get l_unlock_pin_first => 'Ξεκλείδωμα με PIN';

  @override
  String get l_pin_soft_locked =>
      'Το PIN έχει μπλοκαριστεί μέχρι να αφαιρεθεί και να επανεισαχθεί το YubiKey';

  @override
  String get l_pin_change_required_desc =>
      'Πρέπει να οριστεί νέο PIN για να μπορέσετε να χρησιμοποιήσετε αυτήν την εφαρμογή';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'Ένα PIN πρέπει να έχει μήκος $min_length-$max_length χαρακτήρες και μπορεί να περιέχει γράμματα, αριθμούς και ειδικούς χαρακτήρες.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'Ένα PIN πρέπει να έχει μήκος $min_length-$max_length χαρακτήρες, να περιέχει τουλάχιστον $unique_characters μοναδικούς χαρακτήρες και να μην είναι ένα κοινώς χρησιμοποιούμενο PIN, όπως το \"$common_pin\". Μπορεί να περιέχει γράμματα, αριθμούς και ειδικούς χαρακτήρες.';
  }

  @override
  String get s_ep_attestation =>
      'Εταιρική Πιστοποίηση (Enterprise Attestation)';

  @override
  String get s_ep_attestation_enabled =>
      'Η Εταιρική Πιστοποίηση είναι ενεργοποιημένη';

  @override
  String get q_enable_ep_attestation => 'Ενεργοποίηση Εταιρικής Πιστοποίησης;';

  @override
  String get p_enable_ep_attestation_desc =>
      'Αυτό θα ενεργοποιήσει την Εταιρική Πιστοποίηση, επιτρέποντας σε εξουσιοδοτημένους τομείς να αναγνωρίζουν μοναδικά το YubiKey σας.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Μόλις ενεργοποιηθεί, η Εταιρική Πιστοποίηση μπορεί να απενεργοποιηθεί μόνο με την εκτέλεση επαναφοράς εργοστασιακών ρυθμίσεων FIDO.';

  @override
  String get s_pin_required => 'Απαιτείται PIN';

  @override
  String get p_pin_required_desc =>
      'Η ενέργεια που πρόκειται να εκτελέσετε απαιτεί την εισαγωγή του PIN PIV.';

  @override
  String get l_piv_pin_blocked =>
      'Μπλοκαρισμένο, χρησιμοποιήστε το PUK για επαναφορά';

  @override
  String get p_piv_pin_blocked_desc =>
      'Το PIN είναι μπλοκαρισμένο. Χρησιμοποιήστε το PUK για να το επαναφέρετε.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'Το PIN είναι μπλοκαρισμένο. Απαιτείται επαναφορά εργοστασιακών ρυθμίσεων.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Μπλοκαρισμένο, απαιτείται επαναφορά εργοστασιακών ρυθμίσεων';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Τόσο το PIN όσο και το PUK είναι μπλοκαρισμένα. Απαιτείται επαναφορά εργοστασιακών ρυθμίσεων της εφαρμογής PIV.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'Ένα $name πρέπει να έχει μήκος τουλάχιστον $length χαρακτήρες.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'Ένα $name πρέπει να έχει μήκος τουλάχιστον $length χαρακτήρες, να περιέχει τουλάχιστον 2 μοναδικούς χαρακτήρες και να μην είναι ένα κοινώς χρησιμοποιούμενο $name, όπως το \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Το νέο $name δεν πληροί τις απαιτήσεις πολυπλοκότητας.';
  }

  @override
  String get s_dismiss => 'Παράβλεψη';

  @override
  String get p_default_pin_puk_key_desc =>
      'Συνιστάται η αλλαγή του προεπιλεγμένου PIN, PUK και κλειδιού διαχείρισης.';

  @override
  String get p_default_pin_puk_key_fips_desc =>
      'For FIPS compliance it is required to change the default PIN, PUK and management key.';

  @override
  String get l_warning_default_pin =>
      'Προειδοποίηση: Χρησιμοποιείται προεπιλεγμένο PIN';

  @override
  String get l_warning_default_puk =>
      'Προειδοποίηση: Χρησιμοποιείται προεπιλεγμένο PUK';

  @override
  String get l_default_pin_used => 'Χρησιμοποιήθηκε προεπιλεγμένο PIN';

  @override
  String get l_default_puk_used => 'Χρησιμοποιήθηκε προεπιλεγμένο PUK';

  @override
  String get l_pin_complexity => 'Επιβολή πολυπλοκότητας PIN';

  @override
  String get s_password => 'Κωδικός πρόσβασης';

  @override
  String get s_manage_password => 'Διαχείριση κωδικού πρόσβασης';

  @override
  String get s_set_password => 'Ορισμός κωδικού πρόσβασης';

  @override
  String get s_password_set => 'Ο κωδικός πρόσβασης ορίστηκε';

  @override
  String get s_show_password => 'Εμφάνιση κωδικού πρόσβασης';

  @override
  String get s_hide_password => 'Απόκρυψη κωδικού πρόσβασης';

  @override
  String get l_password_protection =>
      'Προστασία λογαριασμών με κωδικό πρόσβασης';

  @override
  String get s_new_password => 'Νέος κωδικός πρόσβασης';

  @override
  String get s_current_password => 'Τρέχων κωδικός πρόσβασης';

  @override
  String get s_confirm_password => 'Επιβεβαίωση κωδικού πρόσβασης';

  @override
  String get l_password_mismatch => 'Οι κωδικοί πρόσβασης δεν ταιριάζουν';

  @override
  String get s_wrong_password => 'Λανθασμένος κωδικός πρόσβασης';

  @override
  String get p_wrong_password =>
      'Λανθασμένος κωδικός πρόσβασης. Εάν δεν γνωρίζετε τον κωδικό πρόσβασής σας, θα χρειαστεί να επαναφέρετε το YubiKey.';

  @override
  String get s_remove_password => 'Κατάργηση κωδικού πρόσβασης';

  @override
  String get s_password_removed => 'Ο κωδικός πρόσβασης καταργήθηκε';

  @override
  String get s_remember_password => 'Απομνημόνευση κωδικού πρόσβασης';

  @override
  String get s_clear_saved_password =>
      'Εκκαθάριση αποθηκευμένου κωδικού πρόσβασης';

  @override
  String get s_password_forgotten => 'Ο κωδικός πρόσβασης ξεχάστηκε';

  @override
  String get l_keystore_unavailable =>
      'Το Keystore του λειτουργικού συστήματος δεν είναι διαθέσιμο';

  @override
  String get l_remember_pw_failed =>
      'Αποτυχία απομνημόνευσης κωδικού πρόσβασης';

  @override
  String get l_unlock_first => 'Ξεκλείδωμα με κωδικό πρόσβασης';

  @override
  String get l_set_password_first => 'Ορισμός κωδικού πρόσβασης';

  @override
  String get l_enter_oath_pw =>
      'Εισαγάγετε τον κωδικό πρόσβασης OATH για το YubiKey σας';

  @override
  String get p_new_password_requirements =>
      'Ένας κωδικός πρόσβασης μπορεί να περιέχει γράμματα, αριθμούς και ειδικούς χαρακτήρες.';

  @override
  String get s_management_key => 'Κλειδί διαχείρισης';

  @override
  String get s_current_management_key => 'Τρέχον κλειδί διαχείρισης';

  @override
  String get s_new_management_key => 'Νέο κλειδί διαχείρισης';

  @override
  String get l_change_management_key => 'Αλλαγή κλειδιού διαχείρισης';

  @override
  String get l_management_key_changed => 'Το κλειδί διαχείρισης άλλαξε';

  @override
  String get l_default_key_used =>
      'Χρησιμοποιήθηκε προεπιλεγμένο κλειδί διαχείρισης';

  @override
  String get s_generate_random => 'Δημιουργία τυχαίου';

  @override
  String get s_use_default => 'Χρήση προεπιλογής';

  @override
  String get l_warning_default_key =>
      'Προειδοποίηση: Χρησιμοποιήθηκε προεπιλεγμένο κλειδί';

  @override
  String get s_protect_key => 'Προστασία με PIN';

  @override
  String get p_protect_key_desc =>
      'Χρησιμοποιήστε το PIN αντί του κλειδιού διαχείρισης κατά τις λειτουργίες που απαιτούν έλεγχο ταυτότητας κλειδιού διαχείρισης.';

  @override
  String get s_management_key_algorithm => 'Αλγόριθμος κλειδιού διαχείρισης';

  @override
  String get p_management_key_algorithm_desc =>
      'Ο αλγόριθμος που θα επιλεγεί για το κλειδί διαχείρισης.';

  @override
  String get l_pin_protected_key =>
      'Το PIN μπορεί να χρησιμοποιηθεί αντ\' αυτού';

  @override
  String get l_wrong_key => 'Λανθασμένο κλειδί';

  @override
  String get l_unlock_piv_management => 'Ξεκλείδωμα διαχείρισης PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'Η ενέργεια που πρόκειται να εκτελέσετε απαιτεί το κλειδί διαχείρισης PIV.';

  @override
  String l_account(String label) {
    return 'Λογαριασμός: $label';
  }

  @override
  String get s_accounts => 'Λογαριασμοί';

  @override
  String get s_no_accounts => 'Δεν υπάρχουν λογαριασμοί';

  @override
  String l_results_for(String query) {
    return 'Αποτελέσματα για \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Ξεκινήστε με λογαριασμούς OTP';

  @override
  String get l_no_accounts_desc =>
      'Προσθέστε λογαριασμούς στο YubiKey σας από οποιονδήποτε πάροχο υπηρεσιών που υποστηρίζει OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Προσθήκη λογαριασμού';

  @override
  String get p_add_account_desc =>
      'Σαρώστε τον κωδικό QR ή εισαγάγετε τα στοιχεία διαπιστευτηρίου μη αυτόματα.';

  @override
  String get s_add_accounts => 'Προσθήκη λογαριασμού(ών)';

  @override
  String get l_drop_qr_description =>
      'Σύρετε τον κωδικό QR για προσθήκη λογαριασμού(ών)';

  @override
  String get p_add_account_three_ways =>
      'Υπάρχουν τρεις τρόποι προσθήκης λογαριασμών.';

  @override
  String get s_scanning => 'Σάρωση (συνιστάται)';

  @override
  String get p_scanning_desc =>
      'Πριν από τη σάρωση ενός κωδικού QR, βεβαιωθείτε ότι ο πλήρης κωδικός είναι ορατός στην οθόνη.';

  @override
  String get s_drag_and_drop => 'Μεταφορά και απόθεση';

  @override
  String get p_drag_and_drop_desc =>
      'Μια εικόνα που περιέχει έναν κωδικό QR μπορεί να αποθετηθεί οπουδήποτε στην προβολή Λογαριασμών.';

  @override
  String get s_manually => 'Μη αυτόματα';

  @override
  String get p_manually_desc =>
      'Τα στοιχεία διαπιστευτηρίου λογαριασμού μπορούν να εισαχθούν μη αυτόματα στη φόρμα.';

  @override
  String get s_account_added => 'Ο λογαριασμός προστέθηκε';

  @override
  String l_account_add_failed(String message) {
    return 'Αποτυχία προσθήκης λογαριασμού: $message';
  }

  @override
  String get l_add_account_password_required => 'Απαιτείται κωδικός πρόσβασης';

  @override
  String get l_add_account_unlock_required => 'Απαιτείται ξεκλείδωμα';

  @override
  String get l_add_account_func_missing =>
      'Η λειτουργικότητα λείπει ή είναι απενεργοποιημένη';

  @override
  String get l_account_name_required =>
      'Ο λογαριασμός σας πρέπει να έχει όνομα';

  @override
  String get l_name_already_exists =>
      'Αυτό το όνομα υπάρχει ήδη για τον εκδότη';

  @override
  String get l_account_already_exists =>
      'Αυτός ο λογαριασμός υπάρχει ήδη στο YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Μη έγκυρος χαρακτήρας: Το \':\' δεν επιτρέπεται στον εκδότη';

  @override
  String get l_select_accounts =>
      'Επιλέξτε λογαριασμό(ούς) για προσθήκη στο YubiKey';

  @override
  String get s_pin_account => 'Καρφίτσωμα λογαριασμού';

  @override
  String get s_unpin_account => 'Ξεκαρφίτσωμα λογαριασμού';

  @override
  String get s_no_pinned_accounts => 'Δεν υπάρχουν καρφιτσωμένοι λογαριασμοί';

  @override
  String get s_pinned => 'Καρφιτσωμένο';

  @override
  String get l_pin_account_desc =>
      'Διατηρήστε τους σημαντικούς λογαριασμούς σας μαζί';

  @override
  String get s_rename_account => 'Μετονομασία λογαριασμού';

  @override
  String get l_rename_account_desc =>
      'Επεξεργασία εκδότη/ονόματος του λογαριασμού';

  @override
  String get s_account_renamed => 'Ο λογαριασμός μετονομάστηκε';

  @override
  String l_rename_account_failed(String message) {
    return 'Αποτυχία μετονομασίας λογαριασμού: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Αυτό θα αλλάξει τον τρόπο εμφάνισης του λογαριασμού στη λίστα.';

  @override
  String get s_delete_account => 'Διαγραφή λογαριασμού';

  @override
  String get q_delete_account => 'Διαγραφή λογαριασμού;';

  @override
  String get l_delete_account_desc =>
      'Κατάργηση του λογαριασμού από το YubiKey σας';

  @override
  String get s_account_deleted => 'Ο λογαριασμός διαγράφηκε';

  @override
  String get p_warning_delete_account =>
      'Προειδοποίηση! Αυτή η ενέργεια θα διαγράψει τον λογαριασμό από το YubiKey σας.';

  @override
  String get p_warning_disable_credential =>
      'Βεβαιωθείτε ότι έχετε απενεργοποιήσει αυτόν τον λογαριασμό από την υπηρεσία με την οποία είναι καταχωρημένος για να αποφύγετε τον αποκλεισμό.';

  @override
  String get s_account_name => 'Όνομα λογαριασμού';

  @override
  String get s_search_accounts => 'Αναζήτηση λογαριασμών';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used από $capacity λογαριασμοί σε χρήση';
  }

  @override
  String s_num_digits(int num) {
    return '$num ψηφία';
  }

  @override
  String s_num_sec(int num) {
    return '$num δευτ.';
  }

  @override
  String get s_issuer_optional => 'Εκδότης (προαιρετικό)';

  @override
  String get s_counter_based => 'Βάσει μετρητή';

  @override
  String get s_time_based => 'Βάσει χρόνου';

  @override
  String get l_copy_code_desc => 'Επικολλήστε τον κωδικό σε άλλη εφαρμογή';

  @override
  String get l_calculate_code_desc => 'Λάβετε νέο κωδικό από το YubiKey σας';

  @override
  String get s_rp_id => 'Αναγνωριστικό RP';

  @override
  String get s_user_id => 'Αναγνωριστικό χρήστη';

  @override
  String get s_credential_id => 'Αναγνωριστικό διαπιστευτηρίου';

  @override
  String get s_display_name => 'Εμφανιζόμενο όνομα';

  @override
  String get s_user_name => 'Όνομα χρήστη';

  @override
  String get s_passkeys => 'Κλειδιά πρόσβασης (Passkeys)';

  @override
  String get s_no_passkeys => 'Δεν υπάρχουν κλειδιά πρόσβασης';

  @override
  String get l_ready_to_use => 'Έτοιμο για χρήση';

  @override
  String get l_register_sk_on_websites =>
      'Εγγραφή ως Κλειδί Ασφαλείας σε ιστοσελίδες';

  @override
  String get l_no_discoverable_accounts =>
      'Δεν υπάρχουν αποθηκευμένα κλειδιά πρόσβασης';

  @override
  String get p_non_passkeys_note =>
      'Ενδέχεται να υπάρχουν διαπιστευτήρια που δεν είναι κλειδιά πρόσβασης, αλλά δεν είναι δυνατή η εμφάνισή τους.';

  @override
  String get s_delete_passkey => 'Διαγραφή κλειδιού πρόσβασης';

  @override
  String get q_delete_passkey => 'Διαγραφή κλειδιού πρόσβασης;';

  @override
  String get l_delete_passkey_desc =>
      'Κατάργηση του κλειδιού πρόσβασης από το YubiKey';

  @override
  String get s_passkey_deleted => 'Το κλειδί πρόσβασης διαγράφηκε';

  @override
  String get p_warning_delete_passkey =>
      'Προειδοποίηση! Αυτή η ενέργεια θα διαγράψει το κλειδί πρόσβασης από το YubiKey σας.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Δεν θα μπορείτε πλέον να χρησιμοποιείτε αυτό το κλειδί πρόσβασης για την υπηρεσία όπου είναι καταχωρημένο.';

  @override
  String get l_do_not_remove_yk_delete =>
      'Do not remove YubiKey during deletion';

  @override
  String get s_search_passkeys => 'Αναζήτηση κλειδιών πρόσβασης';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used από $max κλειδιά πρόσβασης σε χρήση.';
  }

  @override
  String get s_biometrics => 'Βιομετρικά στοιχεία';

  @override
  String l_fingerprint(String label) {
    return 'Δακτυλικό αποτύπωμα: $label';
  }

  @override
  String get s_fingerprints => 'Δακτυλικά αποτυπώματα';

  @override
  String get l_fingerprint_captured =>
      'Το δακτυλικό αποτύπωμα καταγράφηκε με επιτυχία!';

  @override
  String get s_fingerprint_added => 'Το δακτυλικό αποτύπωμα προστέθηκε';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Σφάλμα προσθήκης δακτυλικού αποτυπώματος: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Σφάλμα ορισμού ονόματος: $message';
  }

  @override
  String get s_setup_fingerprints => 'Ρύθμιση δακτυλικών αποτυπωμάτων';

  @override
  String get p_setup_fingerprints_desc =>
      'Τα δακτυλικά αποτυπώματα πρέπει να ρυθμιστούν για να μπορεί να χρησιμοποιηθεί το κλειδί.';

  @override
  String get s_add_fingerprint => 'Προσθήκη δακτυλικού αποτυπώματος';

  @override
  String get s_delete_fingerprint => 'Διαγραφή δακτυλικού αποτυπώματος';

  @override
  String get q_delete_fingerprint => 'Διαγραφή δακτυλικού αποτυπώματος;';

  @override
  String get l_delete_fingerprint_desc =>
      'Κατάργηση του δακτυλικού αποτυπώματος από το YubiKey';

  @override
  String get s_fingerprint_deleted => 'Το δακτυλικό αποτύπωμα διαγράφηκε';

  @override
  String get p_warning_delete_fingerprint =>
      'Αυτό θα διαγράψει το δακτυλικό αποτύπωμα από το YubiKey σας.';

  @override
  String get s_fingerprints_get_started =>
      'Ξεκινήστε με τα δακτυλικά αποτυπώματα';

  @override
  String get p_set_fingerprints_desc =>
      'Για να είναι δυνατή η καταχώρηση δακτυλικών αποτυπωμάτων, πρέπει να οριστεί ένα PIN.';

  @override
  String get l_no_fps_added => 'Δεν έχουν προστεθεί δακτυλικά αποτυπώματα';

  @override
  String get s_rename_fp => 'Μετονομασία δακτυλικού αποτυπώματος';

  @override
  String get l_rename_fp_desc => 'Αλλαγή ονόματος';

  @override
  String get s_fingerprint_renamed => 'Το δακτυλικό αποτύπωμα μετονομάστηκε';

  @override
  String l_rename_fp_failed(String message) {
    return 'Σφάλμα μετονομασίας: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Προσθέστε ένα ή περισσότερα (έως πέντε) δακτυλικά αποτυπώματα';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 δακτυλικά αποτυπώματα καταχωρήθηκαν';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Πιέστε το δάχτυλό σας πάνω στο YubiKey για να ξεκινήσετε.';

  @override
  String get l_name_fingerprint => 'Ονομάστε αυτό το δακτυλικό αποτύπωμα';

  @override
  String get l_user_action_timeout_error => 'Απέτυχε λόγω αδράνειας χρήστη';

  @override
  String get l_wrong_inserted_yk_error =>
      'Το επανεισαχθέν YubiKey δεν ταιριάζει με την αρχική συσκευή';

  @override
  String get l_failed_connecting_to_fido =>
      'Αποτυχία σύνδεσης στη διεπαφή FIDO';

  @override
  String get l_self_signed_certificate => 'Αυτο-υπογεγραμμένο πιστοποιητικό';

  @override
  String get l_certificate_signing_request =>
      'Αίτημα Υπογραφής Πιστοποιητικού (CSR)';

  @override
  String get s_certificate => 'Πιστοποιητικό';

  @override
  String get s_subject => 'Θέμα';

  @override
  String get l_export_csr_file => 'Αποθήκευση CSR σε αρχείο';

  @override
  String get l_export_public_key => 'Εξαγωγή δημόσιου κλειδιού';

  @override
  String get l_export_public_key_file =>
      'Αποθήκευση δημόσιου κλειδιού σε αρχείο';

  @override
  String get l_export_public_key_desc =>
      'Εξαγωγή του δημόσιου κλειδιού σε αρχείο';

  @override
  String get l_public_key_exported => 'Το δημόσιο κλειδί εξήχθη';

  @override
  String get l_export_certificate => 'Εξαγωγή πιστοποιητικού';

  @override
  String get l_export_certificate_file => 'Εξαγωγή πιστοποιητικού σε αρχείο';

  @override
  String get l_export_certificate_desc =>
      'Εξαγωγή του πιστοποιητικού σε αρχείο';

  @override
  String get l_certificate_exported => 'Το πιστοποιητικό εξήχθη';

  @override
  String get l_select_import_file => 'Επιλογή αρχείου για εισαγωγή';

  @override
  String get l_import_file => 'Εισαγωγή αρχείου';

  @override
  String get l_import_desc => 'Εισαγωγή κλειδιού ή/και πιστοποιητικού';

  @override
  String get l_import_nothing => 'Τίποτα για εισαγωγή';

  @override
  String get l_importing_file => 'Εισαγωγή αρχείου…';

  @override
  String get s_file_imported => 'Το αρχείο εισήχθη';

  @override
  String get l_unsupported_key_type => 'Μη υποστηριζόμενος τύπος κλειδιού';

  @override
  String get l_delete_certificate => 'Διαγραφή πιστοποιητικού';

  @override
  String get q_delete_certificate => 'Διαγραφή πιστοποιητικού;';

  @override
  String get l_delete_certificate_desc =>
      'Κατάργηση του πιστοποιητικού από το YubiKey σας';

  @override
  String get l_delete_key => 'Διαγραφή κλειδιού';

  @override
  String get q_delete_key => 'Διαγραφή κλειδιού;';

  @override
  String get l_delete_key_desc => 'Κατάργηση του κλειδιού από το YubiKey σας';

  @override
  String get l_delete_certificate_or_key => 'Διαγραφή πιστοποιητικού/κλειδιού';

  @override
  String get q_delete_certificate_or_key => 'Διαγραφή πιστοποιητικού/κλειδιού;';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Κατάργηση του πιστοποιητικού ή του κλειδιού από το YubiKey σας';

  @override
  String get l_move_key => 'Μετακίνηση κλειδιού';

  @override
  String get l_move_key_desc =>
      'Μετακίνηση κλειδιού από μια υποδοχή PIV σε άλλη';

  @override
  String get l_change_defaults => 'Αλλαγή προεπιλεγμένων κωδικών πρόσβασης';

  @override
  String get s_issuer => 'Εκδότης';

  @override
  String get s_serial => 'Σειριακός αριθμός';

  @override
  String get s_certificate_fingerprint => 'Δακτυλικό αποτύπωμα';

  @override
  String get s_valid_from => 'Έγκυρο από';

  @override
  String get s_valid_to => 'Έγκυρο έως';

  @override
  String get l_no_certificate => 'Δεν έχει φορτωθεί πιστοποιητικό';

  @override
  String get l_key_no_certificate => 'Φορτώθηκε κλειδί χωρίς πιστοποιητικό';

  @override
  String get s_generate_key => 'Δημιουργία κλειδιού';

  @override
  String get l_generate_desc => 'Δημιουργία νέου πιστοποιητικού ή CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Αυτό θα δημιουργήσει ένα νέο κλειδί στο YubiKey στην υποδοχή PIV $slot.';
  }

  @override
  String get s_private_key_generated => 'Το ιδιωτικό κλειδί δημιουργήθηκε';

  @override
  String get p_select_what_to_delete =>
      'Επιλέξτε τι θα διαγραφεί από την υποδοχή.';

  @override
  String get p_warning_delete_certificate =>
      'Προειδοποίηση! Αυτή η ενέργεια θα διαγράψει το πιστοποιητικό από το YubiKey σας.';

  @override
  String get p_warning_delete_key =>
      'Προειδοποίηση! Αυτή η ενέργεια θα διαγράψει το ιδιωτικό κλειδί από το YubiKey σας.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Προειδοποίηση! Αυτή η ενέργεια θα διαγράψει το πιστοποιητικό και το ιδιωτικό κλειδί από το YubiKey σας.';

  @override
  String get p_warning_usb_preferred =>
      'Prefer USB for RSA keys. NFC may result in errors.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Αυτό θα διαγράψει το πιστοποιητικό στην υποδοχή PIV $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Αυτό θα διαγράψει το ιδιωτικό κλειδί στην υποδοχή PIV $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Αυτό θα διαγράψει το πιστοποιητικό και το ιδιωτικό κλειδί στην υποδοχή PIV $slot.';
  }

  @override
  String get l_certificate_deleted => 'Το πιστοποιητικό διαγράφηκε';

  @override
  String get l_key_deleted => 'Το κλειδί διαγράφηκε';

  @override
  String get l_certificate_and_key_deleted =>
      'Το πιστοποιητικό και το κλειδί διαγράφηκαν';

  @override
  String get l_include_certificate => 'Συμπερίληψη πιστοποιητικού';

  @override
  String get l_select_destination_slot => 'Επιλογή υποδοχής προορισμού';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Μετακίνηση του ιδιωτικού κλειδιού στην υποδοχή PIV $from_slot;';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Μετακίνηση του ιδιωτικού κλειδιού από την υποδοχή PIV $from_slot στην υποδοχή $to_slot;';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Μετακίνηση του ιδιωτικού κλειδιού και του πιστοποιητικού από την υποδοχή PIV $from_slot στην υποδοχή $to_slot;';
  }

  @override
  String get p_password_protected_file =>
      'Το επιλεγμένο αρχείο προστατεύεται με κωδικό πρόσβασης.';

  @override
  String p_import_items_desc(String slot) {
    return 'Το(α) ακόλουθο(α) στοιχείο(α) θα εισαχθεί(ούν) στην υποδοχή PIV $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Το δημόσιο κλειδί του πιστοποιητικού δεν ταιριάζει με το ιδιωτικό κλειδί στην υποδοχή';

  @override
  String get l_key_moved => 'Το κλειδί μετακινήθηκε';

  @override
  String get l_key_and_certificate_moved =>
      'Το κλειδί και το πιστοποιητικό μετακινήθηκαν';

  @override
  String get p_subject_desc =>
      'Ένα διακεκριμένο όνομα (DN) μορφοποιημένο σύμφωνα με τις προδιαγραφές RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Μη έγκυρη μορφή RFC 4514';

  @override
  String get rfc4514_examples =>
      'Παραδείγματα:\nCN=Παράδειγμα Ονόματος\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => 'Να επιτρέπεται το δακτυλικό αποτύπωμα';

  @override
  String get s_pin_policy => 'Πολιτική PIN';

  @override
  String get s_output_format => 'Μορφή εξόδου';

  @override
  String get s_expiration_date => 'Ημερομηνία λήξης';

  @override
  String get p_algorithm_desc => 'Αλγόριθμος κλειδιού προς χρήση.';

  @override
  String get p_expiration_date_desc =>
      'Ημερομηνία λήξης του πιστοποιητικού, προεπιλογή 1 έτος (μόνο πιστοποιητικό).';

  @override
  String get p_key_options_bio_desc =>
      'Να επιτρέπεται η χρήση βιομετρικών στοιχείων αντί για PIN.';

  @override
  String get q_overwrite_slot => 'Αντικατάσταση υποδοχής;';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Αυτό θα αντικαταστήσει οριστικά το υπάρχον περιεχόμενο στην υποδοχή $slot.';
  }

  @override
  String get l_overwrite_cert => 'Το πιστοποιητικό θα αντικατασταθεί';

  @override
  String get l_overwrite_key => 'Το ιδιωτικό κλειδί θα αντικατασταθεί';

  @override
  String get l_overwrite_key_maybe =>
      'Οποιοδήποτε υπάρχον ιδιωτικό κλειδί στην υποδοχή θα αντικατασταθεί';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Έλεγχος ταυτότητας';

  @override
  String get s_slot_9c => 'Ψηφιακή Υπογραφή';

  @override
  String get s_slot_9d => 'Διαχείριση Κλειδιών';

  @override
  String get s_slot_9e => 'Έλεγχος Ταυτότητας Κάρτας';

  @override
  String get s_retired_slot => 'Διαχείριση Αποσυρμένων Κλειδιών';

  @override
  String get s_otp_slot_one => 'Σύντομο άγγιγμα';

  @override
  String get s_otp_slot_two => 'Παρατεταμένο άγγιγμα';

  @override
  String get l_otp_slot_empty => 'Η υποδοχή είναι κενή';

  @override
  String get l_otp_slot_configured => 'Η υποδοχή είναι διαμορφωμένη';

  @override
  String get l_yubiotp_desc => 'Προγραμματισμός διαπιστευτηρίου Yubico OTP';

  @override
  String get s_challenge_response => 'Ερώτηση-απόκριση';

  @override
  String get l_challenge_response_desc =>
      'Προγραμματισμός διαπιστευτηρίου ερώτησης-απόκρισης';

  @override
  String get s_static_password => 'Στατικός κωδικός πρόσβασης';

  @override
  String get l_static_password_desc => 'Διαμόρφωση στατικού κωδικού πρόσβασης';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Προγραμματισμός διαπιστευτηρίου βάσει HMAC-SHA1';

  @override
  String get s_public_id => 'Δημόσιο αναγνωριστικό';

  @override
  String get s_private_id => 'Ιδιωτικό αναγνωριστικό';

  @override
  String get s_use_serial => 'Χρήση σειριακού αριθμού';

  @override
  String get l_select_file => 'Επιλογή αρχείου';

  @override
  String get l_no_export_file => 'Δεν υπάρχει αρχείο εξαγωγής';

  @override
  String get s_no_export => 'Χωρίς εξαγωγή';

  @override
  String get s_export => 'Εξαγωγή';

  @override
  String get l_export_configuration_file => 'Εξαγωγή διαμόρφωσης σε αρχείο';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Τα εξαγόμενα διαπιστευτήρια μπορούν να μεταφορτωθούν στη διεύθυνση $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Πληκτρολόγιο $layout';
  }

  @override
  String get s_delete_slot => 'Διαγραφή διαπιστευτηρίου';

  @override
  String get q_delete_slot => 'Διαγραφή διαπιστευτηρίου;';

  @override
  String get l_delete_slot_desc => 'Κατάργηση διαπιστευτηρίου από την υποδοχή';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Προειδοποίηση! Αυτή η ενέργεια θα καταργήσει οριστικά το διαπιστευτήριο από την υποδοχή $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Το διαπιστευτήριο διαγράφηκε';

  @override
  String get s_swap => 'Ανταλλαγή';

  @override
  String get s_swap_slots => 'Ανταλλαγή υποδοχών';

  @override
  String get q_swap_slots => 'Ανταλλαγή υποδοχών;';

  @override
  String get l_swap_slots_desc => 'Ανταλλαγή σύντομου/παρατεταμένου αγγίγματος';

  @override
  String get p_swap_slots_desc =>
      'Αυτό θα ανταλλάξει τη διαμόρφωση των δύο υποδοχών.';

  @override
  String get l_slots_swapped => 'Οι διαμορφώσεις των υποδοχών ανταλλάχθηκαν';

  @override
  String l_slot_credential_configured(String type) {
    return 'Διαμορφωμένο διαπιστευτήριο $type';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Διαμορφωμένο διαπιστευτήριο $type και εξαγωγή στο $file';
  }

  @override
  String get s_append_enter => 'Προσθήκη ⏎';

  @override
  String get l_append_enter_desc =>
      'Προσθήκη ενός πατήματος Enter μετά την εκπομπή του OTP';

  @override
  String get p_otp_swap_error =>
      'Αποτυχία ανταλλαγής υποδοχών! Βεβαιωθείτε ότι το YubiKey δεν έχει περιορισμένη πρόσβαση.';

  @override
  String get l_wrong_access_code => 'Λανθασμένος κωδικός πρόσβασης';

  @override
  String get s_access_code => 'Κωδικός πρόσβασης';

  @override
  String get s_show_access_code => 'Εμφάνιση κωδικού πρόσβασης';

  @override
  String get s_hide_access_code => 'Απόκρυψη κωδικού πρόσβασης';

  @override
  String p_enter_access_code(String slot) {
    return 'Εισαγάγετε τον κωδικό πρόσβασης για την υποδοχή $slot.';
  }

  @override
  String get s_enable_nfc => 'Ενεργοποίηση NFC';

  @override
  String get s_request_access => 'Αίτηση πρόσβασης';

  @override
  String get s_permission_denied => 'Άρνηση άδειας';

  @override
  String get l_elevating_permissions => 'Ανύψωση δικαιωμάτων…';

  @override
  String get s_review_permissions => 'Έλεγχος δικαιωμάτων';

  @override
  String get s_open_windows_settings => 'Άνοιγμα ρυθμίσεων Windows';

  @override
  String get l_admin_privileges_required =>
      'Απαιτούνται δικαιώματα διαχειριστή';

  @override
  String get p_elevated_permissions_required =>
      'Η διαχείριση αυτής της συσκευής απαιτεί αυξημένα δικαιώματα. Εναλλακτικά, μπορείτε να χρησιμοποιήσετε τις Ρυθμίσεις των Windows για τη διαχείριση της διαμόρφωσης FIDO.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'Η διαχείριση WebAuthn απαιτεί αυξημένα δικαιώματα. Εναλλακτικά, μπορείτε να χρησιμοποιήσετε τις Ρυθμίσεις των Windows για τη διαχείριση της διαμόρφωσης FIDO.';

  @override
  String get p_ms_store_permission_note =>
      'The Microsoft Store version of the app is generally unable to elevate permissions due to sandboxing limitations of Windows. We recommend installing Yubico Authenticator from our official .msi installer.';

  @override
  String get p_need_camera_permission =>
      'Το Yubico Authenticator χρειάζεται δικαιώματα Κάμερας για τη σάρωση κωδικών QR.';

  @override
  String get s_qr_scan => 'Σάρωση κωδικού QR';

  @override
  String get l_invalid_qr => 'Μη έγκυρος κωδικός QR';

  @override
  String get l_qr_not_found => 'Δεν βρέθηκε κωδικός QR';

  @override
  String get l_qr_scanned => 'Σαρωμένος κωδικός QR';

  @override
  String l_qr_file_too_large(String max) {
    return 'Το αρχείο είναι πολύ μεγάλο (μέγ. $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Μη έγκυρο αρχείο εικόνας';

  @override
  String get l_qr_select_file => 'Επιλογή αρχείου με κωδικό QR';

  @override
  String l_qr_not_read(String message) {
    return 'Αποτυχία ανάγνωσης κωδικού QR: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Στρέψτε την κάμερά σας σε έναν κωδικό QR για να τον σαρώσετε';

  @override
  String get q_want_to_scan => 'Θέλετε να σαρώσετε;';

  @override
  String get q_no_qr => 'Δεν υπάρχει κωδικός QR;';

  @override
  String get s_enter_manually => 'Εισαγωγή μη αυτόματα';

  @override
  String get s_read_from_file => 'Ανάγνωση από αρχείο';

  @override
  String get s_reset => 'Επαναφορά';

  @override
  String get s_factory_reset => 'Επαναφορά εργοστασιακών ρυθμίσεων';

  @override
  String get l_factory_reset_desc => 'Επαναφορά προεπιλογών YubiKey';

  @override
  String get l_factory_reset_required =>
      'Απαιτείται επαναφορά εργοστασιακών ρυθμίσεων';

  @override
  String get l_oath_application_reset => 'Επαναφορά εφαρμογής OATH';

  @override
  String get l_fido_app_reset => 'Επαναφορά εφαρμογής FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Σφάλμα κατά την επαναφορά: $message';
  }

  @override
  String get l_piv_app_reset => 'Επαναφορά εφαρμογής PIV';

  @override
  String get p_factory_reset_an_app =>
      'Επαναφορά εργοστασιακών ρυθμίσεων μιας εφαρμογής στο YubiKey σας.';

  @override
  String get p_factory_reset_desc =>
      'Τα δεδομένα αποθηκεύονται σε πολλαπλές εφαρμογές στο YubiKey, ορισμένες από τις οποίες μπορούν να επαναφερθούν στις εργοστασιακές ρυθμίσεις ανεξάρτητα η μία από την άλλη.\n\nΕπιλέξτε μια εφαρμογή παραπάνω για επαναφορά.';

  @override
  String get p_warning_factory_reset =>
      'Προειδοποίηση! Αυτό θα διαγράψει αμετάκλητα όλους τους λογαριασμούς OATH TOTP/HOTP από το YubiKey σας.';

  @override
  String get p_warning_disable_credentials =>
      'Τα διαπιστευτήριά σας OATH, καθώς και οποιοσδήποτε ορισμένος κωδικός πρόσβασης, θα καταργηθούν από αυτό το YubiKey. Βεβαιωθείτε ότι τα έχετε απενεργοποιήσει από τις αντίστοιχες ιστοσελίδες τους για να αποφύγετε τον αποκλεισμό από τους λογαριασμούς σας.';

  @override
  String get p_warning_deletes_accounts =>
      'Προειδοποίηση! Αυτό θα διαγράψει αμετάκλητα όλους τους λογαριασμούς U2F και FIDO2, συμπεριλαμβανομένων των κλειδιών πρόσβασης, από το YubiKey σας.';

  @override
  String get p_warning_disable_accounts =>
      'Τα διαπιστευτήριά σας, καθώς και οποιοδήποτε ορισμένο PIN, θα καταργηθούν από αυτό το YubiKey. Βεβαιωθείτε ότι τα έχετε απενεργοποιήσει από τις αντίστοιχες ιστοσελίδες τους για να αποφύγετε τον αποκλεισμό από τους λογαριασμούς σας.';

  @override
  String l_reset_not_allowed_over(String transport) {
    return 'FIDO reset is disabled over $transport';
  }

  @override
  String get p_warning_piv_reset =>
      'Προειδοποίηση! Όλα τα δεδομένα που είναι αποθηκευμένα για το PIV θα διαγραφούν αμετάκλητα από το YubiKey σας.';

  @override
  String get p_warning_piv_reset_desc =>
      'Αυτό περιλαμβάνει ιδιωτικά κλειδιά και πιστοποιητικά. Το PIN, το PUK και το κλειδί διαχείρισής σας θα επαναφερθούν στις εργοστασιακές προεπιλεγμένες τιμές τους.';

  @override
  String get p_warning_global_reset =>
      'Προειδοποίηση! Αυτό θα διαγράψει αμετάκλητα όλα τα αποθηκευμένα δεδομένα, συμπεριλαμβανομένων των διαπιστευτηρίων, από το YubiKey σας.';

  @override
  String get p_warning_global_reset_desc =>
      'Επαναφορά εργοστασιακών ρυθμίσεων των εφαρμογών στο YubiKey σας. Το PIN θα επαναφερθεί στην εργοστασιακή προεπιλεγμένη τιμή του και τα καταχωρημένα δακτυλικά αποτυπώματα θα καταργηθούν. Οποιαδήποτε κλειδιά, πιστοποιητικά ή άλλα διαπιστευτήρια θα καταργηθούν οριστικά.';

  @override
  String get l_copy_to_clipboard => 'Αντιγραφή στο πρόχειρο';

  @override
  String get s_code_copied => 'Ο κωδικός αντιγράφηκε';

  @override
  String get l_code_copied_clipboard => 'Ο κωδικός αντιγράφηκε στο πρόχειρο';

  @override
  String get s_copy_log => 'Αντιγραφή αρχείου καταγραφής';

  @override
  String get l_copy_log_clipboard => 'Copy log to clipboard';

  @override
  String get l_log_copied => 'Το αρχείο καταγραφής αντιγράφηκε στο πρόχειρο';

  @override
  String get l_diagnostics_copied =>
      'Τα διαγνωστικά δεδομένα αντιγράφηκαν στο πρόχειρο';

  @override
  String p_target_copied_clipboard(String label) {
    return 'Το $label αντιγράφηκε στο πρόχειρο.';
  }

  @override
  String get s_custom_icons => 'Προσαρμοσμένα εικονίδια';

  @override
  String get l_set_icons_for_accounts => 'Ορισμός εικονιδίων για λογαριασμούς';

  @override
  String get p_custom_icons_description =>
      'Τα πακέτα εικονιδίων μπορούν να κάνουν τους λογαριασμούς σας πιο εύκολα διακριτούς με οικεία λογότυπα και χρώματα.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Τα πακέτα εικονιδίων χρησιμοποιούν τη μορφή $aegis_icon_pack. Μπορείτε να κατεβάσετε ένα έτοιμο πακέτο εικονιδίων ή να δημιουργήσετε το δικό σας.';
  }

  @override
  String get s_replace_icon_pack => 'Αντικατάσταση πακέτου εικονιδίων';

  @override
  String get l_loading_icon_pack => 'Φόρτωση πακέτου εικονιδίων…';

  @override
  String get s_load_icon_pack => 'Φόρτωση πακέτου εικονιδίων';

  @override
  String get l_load_icon_pack_desc => 'Load icon pack from file';

  @override
  String get s_remove_icon_pack => 'Κατάργηση πακέτου εικονιδίων';

  @override
  String get l_remove_icon_pack_desc => 'Delete the active icon pack';

  @override
  String get l_icon_pack_removed => 'Το πακέτο εικονιδίων καταργήθηκε';

  @override
  String get l_remove_icon_pack_failed =>
      'Σφάλμα κατάργησης πακέτου εικονιδίων';

  @override
  String get s_choose_icon_pack => 'Επιλογή πακέτου εικονιδίων';

  @override
  String get l_icon_pack_imported => 'Το πακέτο εικονιδίων εισήχθη';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Σφάλμα εισαγωγής πακέτου εικονιδίων: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Μη έγκυρο πακέτο εικονιδίων';

  @override
  String get l_icon_pack_copy_failed =>
      'Αποτυχία αντιγραφής αρχείων πακέτου εικονιδίων';

  @override
  String get s_nfc_and_usb_options => 'NFC & USB options';

  @override
  String get l_nfc_and_usb_options_desc => 'Configure action for YubiKey';

  @override
  String get l_on_yk_nfc_tap => 'On NFC tap';

  @override
  String get l_on_yk_usb_insert => 'On USB insert';

  @override
  String get l_do_nothing => 'Καμία ενέργεια';

  @override
  String get l_launch_ya => 'Εκκίνηση του Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Αντιγραφή OTP στο πρόχειρο';

  @override
  String get l_launch_and_copy_otp => 'Εκκίνηση εφαρμογής και αντιγραφή OTP';

  @override
  String get l_kbd_layout_for_static =>
      'Διάταξη πληκτρολογίου (για στατικό κωδικό πρόσβασης)';

  @override
  String get s_choose_kbd_layout => 'Επιλογή διάταξης πληκτρολογίου';

  @override
  String get l_bypass_touch_requirement => 'Παράκαμψη απαίτησης αφής';

  @override
  String get l_bypass_touch_requirement_on =>
      'Οι λογαριασμοί που απαιτούν άγγιγμα εμφανίζονται αυτόματα μέσω NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Οι λογαριασμοί που απαιτούν άγγιγμα χρειάζονται ένα επιπλέον άγγιγμα μέσω NFC';

  @override
  String get s_silence_nfc_sounds => 'Σίγαση ήχων NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'Δεν θα αναπαράγονται ήχοι κατά το άγγιγμα NFC';

  @override
  String get l_silence_nfc_sounds_off =>
      'Θα αναπαραχθεί ήχος κατά το άγγιγμα NFC';

  @override
  String get l_launch_app_on_usb_on =>
      'Αυτό εμποδίζει άλλες εφαρμογές να χρησιμοποιούν το YubiKey μέσω USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Άλλες εφαρμογές μπορούν να χρησιμοποιούν το YubiKey μέσω USB';

  @override
  String get s_allow_screenshots => 'Να επιτρέπονται τα στιγμιότυπα οθόνης';

  @override
  String get l_allow_screenshots_desc => 'Allow other apps to take screenshots';

  @override
  String get s_nfc_ready_to_scan => 'Έτοιμο για σάρωση';

  @override
  String get s_nfc_hold_still => 'Μείνετε ακίνητοι…';

  @override
  String get s_nfc_tap_your_yubikey => 'Αγγίξτε το YubiKey σας';

  @override
  String get s_nfc_remove_key => 'Remove YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Αποτυχία σάρωσης, προσπαθήστε ξανά';

  @override
  String get s_usb_processing => 'Ανάγνωση δεδομένων από το YubiKey';

  @override
  String get s_usb_dont_remove => 'Μην αφαιρείτε το κλειδί…';

  @override
  String get l_usb_read_error => 'Αποτυχία ανάγνωσης δεδομένων από το YubiKey';

  @override
  String get p_ndef_set_otp =>
      'Επιτυχής αντιγραφή κωδικού OTP από το YubiKey στο πρόχειρο.';

  @override
  String get p_ndef_set_password =>
      'Επιτυχής αντιγραφή κωδικού πρόσβασης από το YubiKey στο πρόχειρο.';

  @override
  String get p_ndef_parse_failure =>
      'Αποτυχία ανάλυσης κωδικού OTP από το YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Αποτυχία πρόσβασης στο πρόχειρο κατά την προσπάθεια αντιγραφής κωδικού OTP από το YubiKey.';

  @override
  String get s_set_label => 'Ορισμός ετικέτας';

  @override
  String get s_set_color => 'Ορισμός χρώματος';

  @override
  String get s_change_label => 'Αλλαγή ετικέτας';

  @override
  String get p_set_will_add_custom_name =>
      'Αυτό θα δώσει στο YubiKey σας ένα προσαρμοσμένο όνομα.';

  @override
  String get p_rename_will_change_custom_name =>
      'Αυτό θα αλλάξει την ετικέτα του YubiKey σας.';

  @override
  String get s_keyboard_shortcuts => 'Συντομεύσεις πληκτρολογίου';

  @override
  String get s_global_shortcuts => 'Καθολικές συντομεύσεις';

  @override
  String get s_application_shortcuts => 'Συντομεύσεις εφαρμογής';

  @override
  String s_quit_app(String app) {
    return 'Έξοδος από $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Απόκρυψη $app';
  }

  @override
  String get s_search => 'Αναζήτηση';

  @override
  String get s_next_device => 'Επόμενη συσκευή';

  @override
  String get s_previous_device => 'Προηγούμενη συσκευή';

  @override
  String get s_open_settings => 'Άνοιγμα ρυθμίσεων';

  @override
  String get s_open_item => 'Άνοιγμα στοιχείου';

  @override
  String get s_edit_item => 'Επεξεργασία στοιχείου';

  @override
  String get s_delete_item => 'Διαγραφή στοιχείου';

  @override
  String get s_calculate_oath_code => 'Υπολογισμός κωδικού OATH';

  @override
  String get s_open_keyboard_shortcuts => 'Άνοιγμα συντομεύσεων πληκτρολογίου';
}
