// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class AppLocalizationsPl extends AppLocalizations {
  AppLocalizationsPl([String locale = 'pl']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Polski';

  @override
  String s_translated(int percentage) {
    return 'Przetłumaczono: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Zatwierdzono: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Niekompletne tłumaczenie';

  @override
  String get p_translation_progress_desc =>
      'Wskaźniki odzwierciedlają postęp tłumaczenia.';

  @override
  String get s_save => 'Zapisz';

  @override
  String get s_cancel => 'Anuluj';

  @override
  String get s_close => 'Zamknij';

  @override
  String get s_delete => 'Usuń';

  @override
  String get s_move => 'Przenieś';

  @override
  String get s_quit => 'Wyjdź';

  @override
  String get s_enable => 'Włącz';

  @override
  String get s_enabled => 'Włączone';

  @override
  String get s_disabled => 'Wyłączone';

  @override
  String get s_status => 'Status';

  @override
  String get s_unlock => 'Odblokuj';

  @override
  String get s_calculate => 'Oblicz';

  @override
  String get s_import => 'Importuj';

  @override
  String get s_overwrite => 'Nadpisz';

  @override
  String get s_done => 'Gotowe';

  @override
  String get s_label => 'Etykieta';

  @override
  String get s_name => 'Nazwa';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Opcje';

  @override
  String get s_details => 'Szczegóły';

  @override
  String get s_show_window => 'Pokaż okno';

  @override
  String get s_hide_window => 'Ukryj okno';

  @override
  String get s_show_navigation => 'Pokaż nawigację';

  @override
  String get s_expand_navigation => 'Rozwiń pasek nawigacji';

  @override
  String get s_collapse_navigation => 'Zwiń pasek nawigacji';

  @override
  String get s_expand_collapse_navigation => 'Przełącz pasek nawigacji';

  @override
  String get s_show_menu => 'Pokaż menu';

  @override
  String get s_toggle_menu_bar => 'Przełącz pasek menu';

  @override
  String get s_more_info => 'Więcej informacji';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'O aplikacji';

  @override
  String get s_algorithm => 'Algorytm';

  @override
  String get s_appearance => 'Wygląd';

  @override
  String get s_actions => 'Działania';

  @override
  String get s_manage => 'Zarządzanie';

  @override
  String get s_setup => 'Konfiguracja';

  @override
  String get s_device => 'Urządzenie';

  @override
  String get s_application => 'Aplikacja';

  @override
  String get s_settings => 'Ustawienia';

  @override
  String get l_settings_desc => 'Zmień ustawienia aplikacji';

  @override
  String get s_certificates => 'Certyfikaty';

  @override
  String get s_security_key => 'Klucz bezpieczeństwa';

  @override
  String get s_slots => 'Sloty';

  @override
  String get s_help_and_about => 'Pomoc i informacje';

  @override
  String get l_help_and_about_desc => 'Rozwiązywanie problemów i wsparcie';

  @override
  String get s_help_and_feedback => 'Pomoc i opinie';

  @override
  String get s_home => 'Strona główna';

  @override
  String get s_user_guide => 'Przewodnik użytkownika';

  @override
  String get s_i_need_help => 'Pomoc';

  @override
  String get s_troubleshooting => 'Rozwiązywanie problemów';

  @override
  String get s_terms_of_use => 'Warunki użytkowania';

  @override
  String get s_privacy_policy => 'Polityka prywatności';

  @override
  String get s_open_src_licenses => 'Licencje open source';

  @override
  String get s_please_wait => 'Poczekaj…';

  @override
  String get s_secret_key => 'Tajny klucz';

  @override
  String get s_show_secret_key => 'Pokaż tajny klucz';

  @override
  String get s_hide_secret_key => 'Ukryj tajny klucz';

  @override
  String get s_private_key => 'Klucz prywatny';

  @override
  String get s_public_key => 'Klucz publiczny';

  @override
  String get s_invalid_length => 'Długość jest nieprawidłowa';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Format jest niedozwolony. Dozwolone znaki: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Nieprawidłowe znaki dla wybranej klawiatury';

  @override
  String get s_require_touch => 'Wymagaj dotknięcia';

  @override
  String get q_have_account_info => 'Masz dane konta?';

  @override
  String get s_run_diagnostics => 'Uruchom diagnostykę';

  @override
  String s_log_level(String level) {
    return 'Poziom logów: $level';
  }

  @override
  String get s_character_count => 'Liczba znaków';

  @override
  String get s_language => 'Język';

  @override
  String p_community_translations_desc(String crowdin) {
    return 'Tłumaczenia są utrzymywane przez społeczność $crowdin.';
  }

  @override
  String get s_choose_language => 'Wybierz język';

  @override
  String get s_app_theme => 'Motyw aplikacji';

  @override
  String get s_choose_app_theme => 'Wybierz motyw';

  @override
  String get s_system_default => 'Domyślny systemu';

  @override
  String get s_light_mode => 'Jasny';

  @override
  String get s_dark_mode => 'Ciemny';

  @override
  String get s_list_layout => 'Układ listy';

  @override
  String get s_grid_layout => 'Układ siatki';

  @override
  String get s_mixed_layout => 'Układ mieszany';

  @override
  String get s_select_layout => 'Wybierz układ';

  @override
  String get s_select_to_scan => 'Wybierz, aby zeskanować';

  @override
  String get s_hide_reader => 'Ukryj czytnik';

  @override
  String get s_show_hidden_readers => 'Pokaż ukryte czytniki';

  @override
  String get s_toggle_readers => 'Przełącz czytniki';

  @override
  String get l_toggle_readers_desc => 'Pokaż lub ukryj czytniki';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Numer seryjny: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Wersja oprogramowania: $version';
  }

  @override
  String get l_fips_capable => 'Zgodny z FIPS';

  @override
  String get l_fips_approved => 'Zatwierdzony przez FIPS';

  @override
  String get l_insert_yk => 'Podłącz klucz YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Podłącz lub zbliż klucz YubiKey';

  @override
  String get l_unplug_yk => 'Odłącz klucz YubiKey';

  @override
  String get l_reinsert_yk => 'Podłącz ponownie klucz YubiKey';

  @override
  String get l_place_on_nfc_reader => 'Zbliż klucz YubiKey do czytnika NFC';

  @override
  String get l_replace_yk_on_reader => 'Zbliż klucz YubiKey do czytnika';

  @override
  String get l_remove_yk_from_reader => 'Odsuń klucz YubiKey od czytnika NFC';

  @override
  String get p_try_reinsert_yk => 'Spróbuj podłączyć ponownie klucz YubiKey.';

  @override
  String get s_touch_required => 'Dotknięcie wymagane';

  @override
  String get l_touch_button_now => 'Dotknij przycisku na kluczu YubiKey';

  @override
  String get l_keep_touching_yk => 'Wielokrotnie dotykaj klucza YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Przełączanie aplikacji';

  @override
  String get s_toggle_interfaces => 'Przełączanie interfejsów';

  @override
  String get p_toggle_applications_desc =>
      'Włącz lub wyłącz aplikacje przez dostępne interfejsy.';

  @override
  String get p_toggle_interfaces_desc => 'Włącz lub wyłącz interfejs USB.';

  @override
  String get l_toggle_applications_desc => 'Włącz lub wyłącz aplikacje';

  @override
  String get l_toggle_interfaces_desc => 'Włącz lub wyłącz interfejsy';

  @override
  String get s_reconfiguring_yk => 'Rekonfigurowanie klucza YubiKey…';

  @override
  String get s_config_updated => 'Konfiguracja została zaktualizowana';

  @override
  String get l_config_updated_reinsert =>
      'Konfiguracja została zaktualizowana. Podłącz ponownie klucz YubiKey';

  @override
  String get s_fido_disabled => 'Aplikacja FIDO2 została wyłączona';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn wymaga włączenia aplikacji FIDO2 w kluczu YubiKey';

  @override
  String get s_lock_code => 'Kod blokady';

  @override
  String get l_wrong_lock_code => 'Kod blokady jest nieprawidłowy';

  @override
  String get s_show_lock_code => 'Pokaż kod blokady';

  @override
  String get s_hide_lock_code => 'Ukryj kod blokady';

  @override
  String get p_lock_code_required_desc =>
      'Działanie wymaga wpisania kodu blokady.';

  @override
  String get l_helper_not_responding => 'Proces Helper nie odpowiada';

  @override
  String get l_yk_no_access => 'Dostęp do klucza YubiKey jest niemożliwy';

  @override
  String get s_yk_inaccessible => 'Urządzenie jest niedostępne';

  @override
  String get l_open_connection_failed => 'Nie udało się nawiązać połączenia';

  @override
  String get l_ccid_connection_failed =>
      'Nie udało się nawiązać połączenia z kartą inteligentną';

  @override
  String get p_ccid_service_unavailable =>
      'Upewnij się, że aplikacja kart inteligentnych działa.';

  @override
  String get p_pcscd_unavailable =>
      'Upewnij się, że pakiet pcscd jest zainstalowany i uruchomiony.';

  @override
  String get l_no_yk_present => 'Nie wykryto klucza YubiKey';

  @override
  String get s_unknown_type => 'Nieznany typ';

  @override
  String get s_unknown_device => 'Nierozpoznane urządzenie';

  @override
  String get s_restricted_nfc => 'Aktywacja NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Jak aktywować NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Podłącz YubiKey do dowolnego źródła zasilania USB, takiego jak komputer, na co najmniej 3 sekundy.\n\nPo włączeniu zasilania, NFC zostanie aktywowane i będzie gotowe do użycia.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Klucz YubiKey jest wyposażony w funkcję \"Restricted NFC\", zaprojektowaną w celu zabezpieczenia przed manipulacją bezprzewodową podczas transportu. Oznacza to, że operacje NFC są tymczasowo wyłączone do momentu ich aktywacji.';

  @override
  String get s_unsupported_yk => 'Klucz YubiKey jest nieobsługiwany';

  @override
  String get p_operation_failed_try_again =>
      'Operacja nie powiodła się. Spróbuj ponownie.';

  @override
  String get l_configuration_unsupported => 'Konfiguracja nie jest obsługiwana';

  @override
  String get p_scp_unsupported =>
      'Aby komunikować się przez NFC, klucz YubiKey wymaga technologii, która nie jest obsługiwana przez ten telefon. Podłącz YubiKey do portu USB telefonu.';

  @override
  String get l_error_occurred => 'Wystąpił błąd';

  @override
  String get s_application_error => 'Błąd aplikacji';

  @override
  String get l_import_error => 'Błąd importowania';

  @override
  String get l_file_not_found => 'Plik nie został znaleziony';

  @override
  String get l_file_too_big => 'Plik jest zbyt duży';

  @override
  String get l_filesystem_error => 'Błąd operacji systemu plików';

  @override
  String get s_pin => 'Kod PIN';

  @override
  String get s_puk => 'Kod PUK';

  @override
  String get s_set_pin => 'Ustaw kod PIN';

  @override
  String get s_change_pin => 'Zmień kod PIN';

  @override
  String get s_change_puk => 'Zmień kod PUK';

  @override
  String get s_show_pin => 'Pokaż kod PIN';

  @override
  String get s_hide_pin => 'Ukryj kod PIN';

  @override
  String get s_show_puk => 'Pokaż kod PUK';

  @override
  String get s_hide_puk => 'Ukryj kod PUK';

  @override
  String get s_current_pin => 'Obecny kod PIN';

  @override
  String get s_current_puk => 'Obecny kod PUK';

  @override
  String get s_new_pin => 'Nowy kod PIN';

  @override
  String get s_new_puk => 'Nowy kod PUK';

  @override
  String get s_confirm_pin => 'Potwierdź kod PIN';

  @override
  String get s_confirm_puk => 'Potwierdź kod PUK';

  @override
  String get s_unblock_pin => 'Resetuj kod PIN';

  @override
  String get l_pin_mismatch => 'Kody PIN nie pasują do siebie';

  @override
  String get l_puk_mismatch => 'Kody PUK nie pasują do siebie';

  @override
  String get s_pin_set => 'Kod PIN został ustawiony';

  @override
  String get s_puk_set => 'Kod PUK został ustawiony';

  @override
  String l_set_pin_failed(String message) {
    return 'Nie udało się ustawić kodu PIN: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'Pozostało $retries prób',
      one: 'Pozostała $retries próba',
      many: 'Pozostało $retries prób',
      few: 'Pozostały $retries próby',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'Pozostało $retries prób',
      one: 'Pozostała $retries próba',
      many: 'Pozostało $retries prób',
      few: 'Pozostały $retries próby',
    );
    return 'Kod PIN jest nieprawidłowy. $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'Pozostało $retries prób',
      one: 'Pozostała $retries próba',
      many: 'Pozostało $retries prób',
      few: 'Pozostały $retries próby',
    );
    return 'Kod PUK jest nieprawidłowy. $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Ochrona FIDO kodem PIN';

  @override
  String get s_pin_change_required => 'Wymagana zmiana kodu PIN';

  @override
  String get l_enter_fido2_pin => 'Wpisz kod PIN FIDO2 klucza YubiKey';

  @override
  String get l_pin_blocked_reset =>
      'Kod PIN jest zablokowany. Przywróć ustawienia fabryczne aplikacji FIDO';

  @override
  String get l_pin_blocked => 'Kod PIN jest zablokowany';

  @override
  String get l_set_pin_first => 'Kod PIN jest wymagany';

  @override
  String get l_unlock_pin_first => 'Odblokuj kodem PIN';

  @override
  String get l_pin_soft_locked =>
      'Kod PIN został zablokowany do momentu ponownego podłączenia klucza YubiKey';

  @override
  String get l_pin_change_required_desc =>
      'Przed użyciem tej aplikacji ustaw nowy kod PIN';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'Kod PIN musi mieć długość od $min_length do $max_length znaków i może zawierać litery, cyfry oraz znaki specjalne.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'Kod PIN musi mieć długość od $min_length do $max_length znaków, składać się z co najmniej $unique_characters unikalnych znaków i nie może być popularnym kodem typu \"$common_pin\". Kod PIN może zawierać litery, cyfry oraz znaki specjalne.';
  }

  @override
  String get s_ep_attestation => 'Atest przedsiębiorstwa';

  @override
  String get s_ep_attestation_enabled =>
      'Atest przedsiębiorstwa został włączony';

  @override
  String get q_enable_ep_attestation => 'Włączyć atest przedsiębiorstwa?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Spowoduje to włączenie atestu przedsiębiorstwa, pozwalającego autoryzowanym domenom na jednoznaczną identyfikację klucza YubiKey.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Wyłączenie atestu przedsiębiorstwa możliwe jest tylko poprzez przywrócenie ustawień fabrycznych aplikacji FIDO.';

  @override
  String get s_pin_required => 'Kod PIN jest wymagany';

  @override
  String get p_pin_required_desc => 'Działanie wymaga wpisania kodu PIN PIV.';

  @override
  String get l_piv_pin_blocked => 'Zablokowano. Użyj kodu PUK, aby zresetować';

  @override
  String get p_piv_pin_blocked_desc =>
      'Kod PIN jest zablokowany. Użyj kodu PUK, aby zresetować.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'Kod PIN jest zablokowany. Wymagane jest przywrócenie ustawień fabrycznych.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Zablokowano. Wymagane jest przywrócenie ustawień fabrycznych';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Kody PIN i PUK są zablokowane. Wymagane jest przywrócenie ustawień fabrycznych aplikacji PIV.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name musi składać się z co najmniej $length znaków.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name musi składać się z co najmniej $length znaków, zawierać min. 2 unikalne znaki i nie może być powszechnie używanym $name kodem, np. \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return '$name nie spełnia wymogów.';
  }

  @override
  String get s_dismiss => 'Odrzuć';

  @override
  String get p_default_pin_puk_key_desc =>
      'Zalecana jest zmiana domyślnego kodu PIN, PUK i kluczu zarządzania.';

  @override
  String get l_warning_default_pin =>
      'Ostrzeżenie: Używany jest domyślny kod PIN';

  @override
  String get l_warning_default_puk =>
      'Ostrzeżenie: Używany jest domyślny kod PUK';

  @override
  String get l_default_pin_used => 'Używany jest domyślny kod PIN';

  @override
  String get l_default_puk_used => 'Używany jest domyślny kod PUK';

  @override
  String get l_pin_complexity => 'Wymuszona złożoność kodu PIN';

  @override
  String get s_password => 'Hasło';

  @override
  String get s_manage_password => 'Zarządzaj hasłem';

  @override
  String get s_set_password => 'Ustaw hasło';

  @override
  String get s_password_set => 'Hasło zostało ustawione';

  @override
  String get s_show_password => 'Pokaż hasło';

  @override
  String get s_hide_password => 'Ukryj hasło';

  @override
  String get l_password_protection => 'Ochrona kont hasłem';

  @override
  String get s_new_password => 'Nowe hasło';

  @override
  String get s_current_password => 'Obecne hasło';

  @override
  String get s_confirm_password => 'Potwierdź hasło';

  @override
  String get l_password_mismatch => 'Hasła nie pasują do siebie';

  @override
  String get s_wrong_password => 'Hasło jest nieprawidłowe';

  @override
  String get p_wrong_password =>
      'Hasło jest nieprawidłowe. Jeśli go nie pamiętasz, zresetuj klucz YubiKey.';

  @override
  String get s_remove_password => 'Usuń hasło';

  @override
  String get s_password_removed => 'Hasło zostało usunięte';

  @override
  String get s_remember_password => 'Zapamiętaj hasło';

  @override
  String get s_clear_saved_password => 'Usuń zapisane hasło';

  @override
  String get s_password_forgotten => 'Zapomniane hasło';

  @override
  String get l_keystore_unavailable =>
      'Magazyn kluczy systemu operacyjnego jest niedostępny';

  @override
  String get l_remember_pw_failed => 'Nie udało się zapamiętać hasła';

  @override
  String get l_unlock_first => 'Odblokuj hasłem';

  @override
  String get l_set_password_first => 'Ustaw hasło';

  @override
  String get l_enter_oath_pw => 'Wpisz hasło OATH dla klucza YubiKey';

  @override
  String get p_new_password_requirements =>
      'Hasło może zawierać litery, cyfry i znaki specjalne.';

  @override
  String get s_management_key => 'Klucz zarządzania';

  @override
  String get s_current_management_key => 'Obecny klucz zarządzania';

  @override
  String get s_new_management_key => 'Nowy klucz zarządzania';

  @override
  String get l_change_management_key => 'Zmień klucz zarządzania';

  @override
  String get l_management_key_changed => 'Klucz zarządzania został zmieniony';

  @override
  String get l_default_key_used => 'Używany jest domyślny klucz zarządzania';

  @override
  String get s_generate_random => 'Generuj losowo';

  @override
  String get s_use_default => 'Użyj domyślnego';

  @override
  String get l_warning_default_key =>
      'Ostrzeżenie: Używany jest domyślny klucz';

  @override
  String get s_protect_key => 'Zabezpiecz kodem PIN';

  @override
  String get p_protect_key_desc =>
      'Użyj kodu PIN zamiast klucza zarządzania podczas operacji wymagających uwierzytelniania.';

  @override
  String get s_management_key_algorithm => 'Algorytm klucza zarządzania';

  @override
  String get p_management_key_algorithm_desc =>
      'Algorytm dla klucza zarządzania.';

  @override
  String get l_pin_protected_key => 'Użyj zamiast tego kodu PIN';

  @override
  String get l_wrong_key => 'Klucz jest nieprawidłowy';

  @override
  String get l_unlock_piv_management => 'Odblokuj zarządzanie PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'Działanie wymaga wpisania klucza zarządzania PIV.';

  @override
  String l_account(String label) {
    return 'Konto: $label';
  }

  @override
  String get s_accounts => 'Konta';

  @override
  String get s_no_accounts => 'Brak kont';

  @override
  String l_results_for(String query) {
    return 'Wyniki dla \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Zacznij korzystać z kont OTP';

  @override
  String get l_no_accounts_desc =>
      'Dodaj do klucza YubiKey konta z dowolnej usługi wspierające kody OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Dodaj konto';

  @override
  String get p_add_account_desc =>
      'Zeskanuj kod QR lub wpisz poświadczenie ręcznie.';

  @override
  String get s_add_accounts => 'Dodaj konta';

  @override
  String get l_drop_qr_description => 'Zeskanuj kod QR, aby dodać konta';

  @override
  String get p_add_account_three_ways => 'Są trzy sposoby dodawania kont.';

  @override
  String get s_scanning => 'Skanowanie (zalecane)';

  @override
  String get p_scanning_desc =>
      'Przed zeskanowaniem kodu QR upewnij się, że pełny kod jest widoczny na ekranie.';

  @override
  String get s_drag_and_drop => 'Przeciągnij i upuść';

  @override
  String get p_drag_and_drop_desc =>
      'Obraz zawierający kod QR możesz upuścić w dowolnym miejscu w widoku Konta.';

  @override
  String get s_manually => 'Ręcznie';

  @override
  String get p_manually_desc => 'Poświadczenia konta możesz wpisać ręcznie.';

  @override
  String get s_account_added => 'Konto zostało dodane';

  @override
  String l_account_add_failed(String message) {
    return 'Nie udało się dodać konta: $message';
  }

  @override
  String get l_add_account_password_required => 'Wymagane hasło';

  @override
  String get l_add_account_unlock_required => 'Wymagane odblokowanie';

  @override
  String get l_add_account_already_exists => 'Konto już istnieje';

  @override
  String get l_add_account_func_missing =>
      'Funkcja nie jest dostępna lub jest wyłączona';

  @override
  String get l_account_name_required => 'Konto musi mieć nazwę';

  @override
  String get l_name_already_exists => 'Ta nazwa wydawcy już istnieje';

  @override
  String get l_account_already_exists =>
      'To konto już istnieje w kluczu YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Nieprawidłowy znak: \":\" nie jest dozwolony w polu wydawcy';

  @override
  String get l_select_accounts =>
      'Wybierz konta, które chcesz dodać do klucza YubiKey';

  @override
  String get s_pin_account => 'Przypnij konto';

  @override
  String get s_unpin_account => 'Odepnij konto';

  @override
  String get s_no_pinned_accounts => 'Brak przypiętych kont';

  @override
  String get s_pinned => 'Przypięte';

  @override
  String get l_pin_account_desc => 'Trzymaj ważne konta razem';

  @override
  String get s_rename_account => 'Zmień nazwę konta';

  @override
  String get l_rename_account_desc => 'Edytuj wydawcę lub nazwę konta';

  @override
  String get s_account_renamed => 'Nazwa konta została zmieniona';

  @override
  String l_rename_account_failed(String message) {
    return 'Zmiana nazwy konta nie powiodła się: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Spowoduje to zmianę sposobu wyświetlania konta na liście.';

  @override
  String get s_delete_account => 'Usuń konto';

  @override
  String get q_delete_account => 'Usunąć konto?';

  @override
  String get l_delete_account_desc => 'Usuń konto z klucza YubiKey';

  @override
  String get s_account_deleted => 'Konto zostało usunięte';

  @override
  String get p_warning_delete_account =>
      'Ostrzeżenie! Spowoduje to usunięcie konta z klucza YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Upewnij się, że poświadczenie zostało wyłączone, aby uniknąć zablokowania konta.';

  @override
  String get s_account_name => 'Nazwa konta';

  @override
  String get s_search_accounts => 'Szukaj kont';

  @override
  String l_accounts_used(int used, int capacity) {
    return 'Użyto $used z $capacity kont';
  }

  @override
  String s_num_digits(int num) {
    return '$num cyfr';
  }

  @override
  String s_num_sec(int num) {
    return '$num sek.';
  }

  @override
  String get s_issuer_optional => 'Wydawca (opcjonalnie)';

  @override
  String get s_counter_based => 'Na podstawie licznika';

  @override
  String get s_time_based => 'Na podstawie czasu';

  @override
  String get l_copy_code_desc => 'Wklej kod do innej aplikacji';

  @override
  String get l_calculate_code_desc => 'Uzyskaj nowy kod z klucza YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'User ID';

  @override
  String get s_credential_id => 'Credential ID';

  @override
  String get s_display_name => 'Nazwa wyświetlana';

  @override
  String get s_user_name => 'Nazwa użytkownika';

  @override
  String get s_passkeys => 'Klucze dostępu';

  @override
  String get s_no_passkeys => 'Brak kluczy dostępu';

  @override
  String get l_ready_to_use => 'Gotowy do użycia';

  @override
  String get l_register_sk_on_websites =>
      'Zarejestruj jako klucz bezpieczeństwa na stronach internetowych';

  @override
  String get l_no_discoverable_accounts => 'Brak kluczy dostępu';

  @override
  String get p_non_passkeys_note =>
      'Poświadczenia U2F mogą istnieć, ale nie mogą zostać wyświetlone.';

  @override
  String get s_delete_passkey => 'Usuń klucz dostępu';

  @override
  String get q_delete_passkey => 'Usunąć klucz dostępu?';

  @override
  String get l_delete_passkey_desc => 'Usuń klucz dostępu z klucza YubiKey';

  @override
  String get s_passkey_deleted => 'Klucz dostępu został usunięty';

  @override
  String get p_warning_delete_passkey =>
      'Ostrzeżenie! Spowoduje to usunięcie klucza dostępu z YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Użycie tego klucza dostępu nie będzie już możliwe.';

  @override
  String get s_search_passkeys => 'Szukaj kluczy dostępu';

  @override
  String p_passkeys_used(int used, int max) {
    return 'Użyto $used z $max kluczy dostępu.';
  }

  @override
  String get s_biometrics => 'Biometria';

  @override
  String l_fingerprint(String label) {
    return 'Odcisk palca: $label';
  }

  @override
  String get s_fingerprints => 'Odciski palców';

  @override
  String get l_fingerprint_captured => 'Odcisk palca został dodany!';

  @override
  String get s_fingerprint_added => 'Odcisk palca został dodany';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Wystąpił błąd podczas dodawania odcisku palca: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Wystąpił błąd podczas ustawienia nazwy: $message';
  }

  @override
  String get s_setup_fingerprints => 'Skonfiguruj odciski palców';

  @override
  String get p_setup_fingerprints_desc =>
      'Przed użyciem klucza należy skonfigurować odciski palców.';

  @override
  String get s_add_fingerprint => 'Dodaj odcisk palca';

  @override
  String get s_delete_fingerprint => 'Usuń odcisk palca';

  @override
  String get q_delete_fingerprint => 'Usunąć odcisk palca?';

  @override
  String get l_delete_fingerprint_desc => 'Usuń odcisk palca z klucza YubiKey';

  @override
  String get s_fingerprint_deleted => 'Odcisk palca został usunięty';

  @override
  String get p_warning_delete_fingerprint =>
      'Spowoduje to usunięcie odcisku palca z klucza YubiKey.';

  @override
  String get s_fingerprints_get_started =>
      'Zacznij korzystać z odcisków palców';

  @override
  String get p_set_fingerprints_desc =>
      'Przed zarejestrowaniem odcisków palców należy ustawić kod PIN.';

  @override
  String get l_no_fps_added => 'Brak dodanych odcisków palców';

  @override
  String get s_rename_fp => 'Zmień nazwę odcisku palca';

  @override
  String get l_rename_fp_desc => 'Zmień nazwę';

  @override
  String get s_fingerprint_renamed => 'Nazwa odcisku palca została zmieniona';

  @override
  String l_rename_fp_failed(String message) {
    return 'Wystąpił błąd podczas zmiany nazwy: $message';
  }

  @override
  String get l_add_one_or_more_fps => 'Dodaj do 5 odcisków palców';

  @override
  String l_fingerprints_used(int used) {
    return 'Zarejestrowano $used z 5 odcisków palców';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Przytrzymaj palec na kluczu YubiKey, aby rozpocząć.';

  @override
  String get l_name_fingerprint => 'Nazwij odcisk palca';

  @override
  String get l_user_action_timeout_error =>
      'Nie powiodło się z powodu braku aktywności użytkownika';

  @override
  String get l_wrong_inserted_yk_error =>
      'Podłączony ponownie klucz YubiKey nie pasuje do poprzedniego urządzenia';

  @override
  String get l_failed_connecting_to_fido =>
      'Połączenie z interfejsem FIDO nie powiodło się';

  @override
  String get l_self_signed_certificate => 'Certyfikat z własnym podpisem';

  @override
  String get l_certificate_signing_request =>
      'Żądanie podpisania certyfikatu (CSR)';

  @override
  String get s_certificate => 'Certyfikat';

  @override
  String get s_subject => 'Temat';

  @override
  String get l_export_csr_file => 'Zapisz CSR do pliku';

  @override
  String get l_export_public_key => 'Eksportuj klucz publiczny';

  @override
  String get l_export_public_key_file => 'Zapisz klucz publiczny do pliku';

  @override
  String get l_export_public_key_desc => 'Eksportuj klucz publiczny do pliku';

  @override
  String get l_public_key_exported => 'Klucz publiczny został wyeksportowany';

  @override
  String get l_export_certificate => 'Eksportuj certyfikat';

  @override
  String get l_export_certificate_file => 'Eksportuj certyfikat do pliku';

  @override
  String get l_export_certificate_desc => 'Eksportuj certyfikat do pliku';

  @override
  String get l_certificate_exported => 'Certyfikat został wyeksportowany';

  @override
  String get l_select_import_file => 'Wybierz plik do zaimportowania';

  @override
  String get l_import_file => 'Importuj plik';

  @override
  String get l_import_desc => 'Importuj klucz lub certyfikat';

  @override
  String get l_import_nothing => 'Nic do zaimportowania';

  @override
  String get l_importing_file => 'Importowanie pliku…';

  @override
  String get s_file_imported => 'Plik został zaimportowany';

  @override
  String get l_unsupported_key_type => 'Typ klucza jest nieobsługiwany';

  @override
  String get l_delete_certificate => 'Usuń certyfikat';

  @override
  String get q_delete_certificate => 'Usunąć certyfikat?';

  @override
  String get l_delete_certificate_desc => 'Usuń certyfikat z klucza YubiKey';

  @override
  String get l_delete_key => 'Usuń klucz';

  @override
  String get q_delete_key => 'Usunąć klucz?';

  @override
  String get l_delete_key_desc => 'Usuń klucz z YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Usuń certyfikat lub klucz';

  @override
  String get q_delete_certificate_or_key => 'Usuń certyfikat lub klucz?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Usuń certyfikat lub klucz z YubiKey';

  @override
  String get l_move_key => 'Przenieś klucz';

  @override
  String get l_move_key_desc => 'Przenieś klucz pomiędzy slotami PIV';

  @override
  String get l_change_defaults => 'Zmień domyślne kody dostępu';

  @override
  String get s_issuer => 'Wydawca';

  @override
  String get s_serial => 'Numer seryjny';

  @override
  String get s_certificate_fingerprint => 'Odcisk palca';

  @override
  String get s_valid_from => 'Ważny od';

  @override
  String get s_valid_to => 'Ważny do';

  @override
  String get l_no_certificate => 'Nie załadowano certyfikatu';

  @override
  String get l_key_no_certificate => 'Załadowano klucz bez certyfikatu';

  @override
  String get s_generate_key => 'Generuj klucz';

  @override
  String get l_generate_desc => 'Generuj nowy certyfikat lub CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Spowoduje to wygenerowanie nowego klucza w slocie PIV $slot.';
  }

  @override
  String get s_private_key_generated => 'Klucz prywatny został wygeneroewany';

  @override
  String get p_select_what_to_delete => 'Wybierz, co usunąć ze slotu.';

  @override
  String get p_warning_delete_certificate =>
      'Ostrzeżenie! Spowoduje to usunięcie certyfikatu z klucza YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Ostrzeżenie! Spowoduje to usunięcie klucza prywatnego z YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Ostrzeżenie! Spowoduje to usunięcie certyfikatu i klucza prywatnego z YubiKey.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Spowoduje to usunięcie certyfikatu ze slotu PIV $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Spowoduje to usunięcie klucza prywatnego ze slotu PIV $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Spowoduje to usunięcie certyfikatu i klucza prywatnego ze slotu PIV $slot.';
  }

  @override
  String get l_certificate_deleted => 'Certyfikat został usunięty';

  @override
  String get l_key_deleted => 'Klucz został usunięty';

  @override
  String get l_certificate_and_key_deleted =>
      'Certyfikat i klucz został usunięty';

  @override
  String get l_include_certificate => 'Dołącz certyfikat';

  @override
  String get l_select_destination_slot => 'Wybierz docelowy slot';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Przenieść klucz prywatny ze slotu PIV $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Przenieść klucz prywatny ze slotu PIV $from_slot do $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Przenieść klucz prywatny i certyfikat ze slotu PIV $from_slot do $to_slot?';
  }

  @override
  String get p_password_protected_file => 'Plik jest chroniony hasłem.';

  @override
  String p_import_items_desc(String slot) {
    return 'Następujące elementy zostaną zaimportowane do slotu PIV $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Klucz publiczny certyfikatu nie pasuje do klucza prywatnego w slocie';

  @override
  String get l_key_moved => 'Klucz został przeniesiony';

  @override
  String get l_key_and_certificate_moved =>
      'Klucz i certyfikat został przeniesiony';

  @override
  String get p_subject_desc =>
      'Nazwa wyróżniająca (DN) sformatowana zgodnie ze specyfikacją RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Format RFC 4514 jest nieprawidłowy';

  @override
  String get rfc4514_examples =>
      'Przykłady:\nCN=Przykładowa nazwa\nCN=jkowalski,DC=przyklad,DC=pl';

  @override
  String get s_allow_fingerprint => 'Zezwalaj na odcisk palca';

  @override
  String get s_pin_policy => 'Zasady dotyczące kodu PIN';

  @override
  String get s_output_format => 'Format wyjściowy';

  @override
  String get s_expiration_date => 'Data wygaśnięcia';

  @override
  String get p_algorithm_desc => 'Algorytm do generowania klucza.';

  @override
  String get p_expiration_date_desc =>
      'Data wygaśnięcia certyfikatu, domyślnie 1 rok (tylko certyfikat).';

  @override
  String get p_key_options_bio_desc =>
      'Umożliwia korzystanie z danych biometrycznych zamiast kodu PIN.';

  @override
  String get q_overwrite_slot => 'Nadpisać slot?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Spowoduje to trwałe nadpisanie obecnej zawartości w slocie $slot.';
  }

  @override
  String get l_overwrite_cert => 'Certyfikat zostanie nadpisany';

  @override
  String get l_overwrite_key => 'Klucz prywatny zostanie nadpisany';

  @override
  String get l_overwrite_key_maybe =>
      'Każdy obecny klucz prywatny w slocie zostanie nadpisany';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Uwierzytelnienie';

  @override
  String get s_slot_9c => 'Podpis cyfrowy';

  @override
  String get s_slot_9d => 'Zarządzanie kluczem';

  @override
  String get s_slot_9e => 'Uwierzytelnianie kartą';

  @override
  String get s_retired_slot => 'Stare zarządzanie kluczem';

  @override
  String get s_otp_slot_one => 'Krótkie dotknięcie';

  @override
  String get s_otp_slot_two => 'Długie dotknięcie';

  @override
  String get l_otp_slot_empty => 'Slot jest pusty';

  @override
  String get l_otp_slot_configured => 'Slot jest skonfigurowany';

  @override
  String get l_yubiotp_desc => 'Skonfiguruj poświadczenie Yubico OTP';

  @override
  String get s_challenge_response => 'Challenge-response';

  @override
  String get l_challenge_response_desc =>
      'Skonfiguruj poświadczenie challenge-response';

  @override
  String get s_static_password => 'Hasło statyczne';

  @override
  String get l_static_password_desc => 'Skonfiguruj hasło statyczne';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Skonfiguruj poświadczenie HMAC-SHA1';

  @override
  String get s_public_id => 'Public ID';

  @override
  String get s_private_id => 'Private ID';

  @override
  String get s_use_serial => 'Użyj numeru seryjnego';

  @override
  String get l_select_file => 'Wybierz plik';

  @override
  String get l_no_export_file => 'Brak pliku eksportu';

  @override
  String get s_no_export => 'Brak eksportu';

  @override
  String get s_export => 'Eksportuj';

  @override
  String get l_export_configuration_file => 'Eksportuj konfigurację do pliku';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Wyeksportowane poświadczenia mogą zostać przesłane na stronie $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Klawiatura $layout';
  }

  @override
  String get s_delete_slot => 'Usuń poświadczenie';

  @override
  String get q_delete_slot => 'Usunąć poświadczenie?';

  @override
  String get l_delete_slot_desc => 'Usuń poświadczenie ze slotu';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Ostrzeżenie! Spowoduje to trwałe usunięcie poświadczenia ze slotu $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Poświadczenie zostało usunięte';

  @override
  String get s_swap => 'Zmień';

  @override
  String get s_swap_slots => 'Zmień sloty';

  @override
  String get q_swap_slots => 'Zmienić sloty?';

  @override
  String get l_swap_slots_desc => 'Zmień krótkie i długie dotknięcie';

  @override
  String get p_swap_slots_desc => 'Spowoduje to zmianę miejsc slotów.';

  @override
  String get l_slots_swapped => 'Sloty zostały zmienione';

  @override
  String l_slot_credential_configured(String type) {
    return 'Poświadczenie $type zostało skonfigurowane';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Poświadczenie $type zostało skonfigurowane i wyeksportowane do pliku $file';
  }

  @override
  String get s_append_enter => 'Dołącz ⏎';

  @override
  String get l_append_enter_desc => 'Dołącz klawisz Enter po wysłaniu kodu OTP';

  @override
  String get p_otp_swap_error =>
      'Nie udało się zmienić slotów! Upewnij się, że klucz YubiKey nie ma ograniczonego dostępu.';

  @override
  String get l_wrong_access_code => 'Kod dostępu jest nieprawidłowy';

  @override
  String get s_access_code => 'Kod dostępu';

  @override
  String get s_show_access_code => 'Pokaż kod dostępu';

  @override
  String get s_hide_access_code => 'Ukryj kod dostępu';

  @override
  String p_enter_access_code(String slot) {
    return 'Wpisz kod dostępu slotu $slot.';
  }

  @override
  String get s_enable_nfc => 'Włącz NFC';

  @override
  String get s_request_access => 'Żądanie dostępu';

  @override
  String get s_permission_denied => 'Odmowa dostępu';

  @override
  String get l_elevating_permissions => 'Podnoszenie uprawnień…';

  @override
  String get s_review_permissions => 'Sprawdź uprawnienia';

  @override
  String get s_open_windows_settings => 'Otwórz ustawienia systemu Windows';

  @override
  String get l_admin_privileges_required =>
      'Uprawnienia administratora są wymagane';

  @override
  String get p_elevated_permissions_required =>
      'Zarządzanie tym urządzeniem wymaga podwyższonych uprawnień. Opcjonalnie, możesz użyć ustawień systemu Windows do zarządzania konfiguracją FIDO.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'Zarządzanie WebAuthn wymaga podwyższonych uprawnień. Opcjonalnie, możesz użyć ustawień systemu Windows do zarządzania konfiguracją FIDO.';

  @override
  String get l_ms_store_permission_note =>
      'Wersja aplikacji ze sklepu Microsoft Store może nie być w stanie podnieść uprawnień';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator wymaga dostępu do aparatu w celu skanowania kodów QR.';

  @override
  String get s_qr_scan => 'Zeskanuj kod QR';

  @override
  String get l_invalid_qr => 'Kod QR jest nieprawidłowy';

  @override
  String get l_qr_not_found => 'Nie znaleziono kodu QR';

  @override
  String get l_qr_scanned => 'Kod QR został zeskanowany';

  @override
  String l_qr_file_too_large(String max) {
    return 'Plik jest zbyt duży (maksymalnie $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Plik obrazu jest nieprawidłowy';

  @override
  String get l_qr_select_file => 'Wybierz plik z kodem QR';

  @override
  String l_qr_not_read(String message) {
    return 'Odczytanie kodu QR nie powiodło się: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Skieruj aparat na kod QR, by go zeskanować';

  @override
  String get q_want_to_scan => 'Czy chcesz zeskanować?';

  @override
  String get q_no_qr => 'Nie masz kodu QR?';

  @override
  String get s_enter_manually => 'Wpisz ręcznie';

  @override
  String get s_read_from_file => 'Odczytaj z pliku';

  @override
  String get s_reset => 'Resetuj';

  @override
  String get s_factory_reset => 'Ustawienia fabryczne';

  @override
  String get l_factory_reset_desc =>
      'Przywróć ustawienia domyślne klucza YubiKey';

  @override
  String get l_factory_reset_required =>
      'Wymagane jest przywrócenie ustawień fabrycznych';

  @override
  String get l_oath_application_reset => 'Resetowanie aplikacji OATH';

  @override
  String get l_fido_app_reset => 'Resetowanie aplikacji FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Wystąpił błąd podczas resetowania: $message';
  }

  @override
  String get l_piv_app_reset => 'Resetowanie aplikacji PIV';

  @override
  String get p_factory_reset_an_app =>
      'Przywróć aplikację klucza YubiKey do ustawień fabrycznych.';

  @override
  String get p_factory_reset_desc =>
      'Dane są przechowywane w wielu aplikacjach klucza YubiKey, a niektóre z nich można przywrócić do ustawień fabrycznych niezależnie od siebie.\n\nWybierz aplikację powyżej, aby przywrócić ustawienia fabryczne.';

  @override
  String get p_warning_factory_reset =>
      'Ostrzeżenie! Spowoduje to nieodwracalne usunięcie wszystkich kont OATH TOTP/HOTP z klucza YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Twoje poświadczenia OATH, a także ustawione hasła, zostaną usunięte z klucza YubiKey. Upewnij się, że poświadczenia zostały wyłączone, aby uniknąć zablokowania kont.';

  @override
  String get p_warning_deletes_accounts =>
      'Ostrzeżenie! Spowoduje to nieodwracalne usunięcie wszystkich kont U2F i FIDO2 z klucza YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Twoje poświadczenia, a także ustawione kody PIN, zostaną usunięte z klucza YubiKey. Upewnij się, że poświadczenia zostały wyłączone, aby uniknąć zablokowania kont.';

  @override
  String get p_warning_piv_reset =>
      'Ostrzeżenie! Wszystkie dane przechowywane w aplikacji PIV zostaną nieodwracalnie usunięte z klucza YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'Obejmuje to klucze prywatne i certyfikaty. Kod PIN, PUK i klucz zarządzania zostaną zresetowane do domyślnych wartości fabrycznych.';

  @override
  String get p_warning_global_reset =>
      'Ostrzeżenie! Spowoduje to nieodwracalne usunięcie wszystkich zapisanych danych, w tym poświadczeń, z klucza YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Przywróć aplikację klucza YubiKey do ustawień fabrycznych. Kod PIN zostanie zresetowany do wartości domyślnej, a zarejestrowane odciski palców zostaną usunięte. Wszystkie klucze, certyfikaty i inne poświadczenia zostaną trwale usunięte.';

  @override
  String get l_copy_to_clipboard => 'Kopiuj do schowka';

  @override
  String get s_code_copied => 'Kod został skopiowany';

  @override
  String get l_code_copied_clipboard => 'Kod został skopiowany do schowka';

  @override
  String get s_copy_log => 'Kopiuj logi';

  @override
  String get l_log_copied => 'Logi zostały skopiowane do schowka';

  @override
  String get l_diagnostics_copied =>
      'Dane diagnostyczne zostały skopiowane do schowka';

  @override
  String p_target_copied_clipboard(String label) {
    return 'Skopiowano $label do schowka.';
  }

  @override
  String get s_custom_icons => 'Niestandardowe ikony';

  @override
  String get l_set_icons_for_accounts => 'Ustaw ikony dla kont';

  @override
  String get p_custom_icons_description =>
      'Pakiety ikon mogą sprawić, że Twoje konta będą łatwiejsze do rozróżnienia dzięki znanym logo i kolorom.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Pakiety ikon używają formatu $aegis_icon_pack. Możesz pobrać gotowy pakiet ikon lub stworzyć własny.';
  }

  @override
  String get s_replace_icon_pack => 'Zmień pakiet ikon';

  @override
  String get l_loading_icon_pack => 'Ładowanie pakietu ikon…';

  @override
  String get s_load_icon_pack => 'Wybierz pakiet ikon';

  @override
  String get s_remove_icon_pack => 'Usuń pakiet ikon';

  @override
  String get l_icon_pack_removed => 'Pakiet ikon został usunięty';

  @override
  String get l_remove_icon_pack_failed =>
      'Wystąpił błąd podczas usuwania pakietu ikon';

  @override
  String get s_choose_icon_pack => 'Wybierz pakiet ikon';

  @override
  String get l_icon_pack_imported => 'Pakiet ikon został zaimportowany';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Wystąpił błąd podczas importowania pakietu ikon: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Pakiet ikon jest nieprawidłowy';

  @override
  String get l_icon_pack_copy_failed =>
      'Nie udało się skopiować plików pakietu ikon';

  @override
  String get s_nfc_options => 'Opcje NFC';

  @override
  String get l_on_yk_nfc_tap => 'Podczas zbliżenia klucza YubiKey przez NFC';

  @override
  String get l_do_nothing => 'Nic nie rób';

  @override
  String get l_launch_ya => 'Uruchom Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Kopiuj kod OTP do schowka';

  @override
  String get l_launch_and_copy_otp => 'Uruchom aplikację i kopiuj kod OTP';

  @override
  String get l_kbd_layout_for_static =>
      'Układ klawiatury (dla hasła statycznego)';

  @override
  String get s_choose_kbd_layout => 'Wybierz układ klawiatury';

  @override
  String get l_bypass_touch_requirement => 'Pomiń wymagane dotknięcie';

  @override
  String get l_bypass_touch_requirement_on =>
      'Konta, które wymagają dotknięcia, będą automatycznie wyświetlane przez NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Konta, które wymagają dotknięcia, będą wymagały dodatkowego zbliżenia przez NFC';

  @override
  String get s_silence_nfc_sounds => 'Wycisz dźwięki NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'Dźwięk zbliżenia NFC nie będzie odtwarzany';

  @override
  String get l_silence_nfc_sounds_off =>
      'Dźwięk zbliżenia NFC będzie odtwarzany';

  @override
  String get s_usb_options => 'Opcje USB';

  @override
  String get l_launch_app_on_usb => 'Uruchom po podłączeniu klucza YubiKey';

  @override
  String get l_launch_app_on_usb_on =>
      'Inne aplikacje nie mogą korzystać z klucza YubiKey przez USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Inne aplikacje mogą korzystać z klucza YubiKey przez USB';

  @override
  String get s_allow_screenshots => 'Zezwalaj na zrzuty ekranu';

  @override
  String get s_nfc_ready_to_scan => 'Gotowy do skanowania';

  @override
  String get s_nfc_hold_still => 'Nie ruszaj się…';

  @override
  String get s_nfc_tap_your_yubikey => 'Zbliż klucz YubiKey';

  @override
  String get l_nfc_failed_to_scan =>
      'Nie udało się zeskanować. Spróbuj ponownie';

  @override
  String get s_usb_processing => 'Odczytywanie danych z klucza YubiKey';

  @override
  String get s_usb_dont_remove => 'Nie usuwaj klucza YubiKey…';

  @override
  String get l_usb_read_error =>
      'Nie udało się odczytać danych z klucza YubiKey';

  @override
  String get p_ndef_set_otp => 'Kod OTP został skopiowany do schowka.';

  @override
  String get p_ndef_set_password => 'Hasło zostało skopiowane do schowka.';

  @override
  String get p_ndef_parse_failure =>
      'Nie udało się odczytać kodu OTP z klucza YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Wystąpił błąd podczas kopiowania kodu OTP do schowka.';

  @override
  String get s_set_label => 'Ustaw etykietę';

  @override
  String get s_set_color => 'Ustaw kolor';

  @override
  String get s_change_label => 'Zmień etykietę';

  @override
  String get p_set_will_add_custom_name =>
      'Spowoduje to nazwanie klucza YubiKey.';

  @override
  String get p_rename_will_change_custom_name =>
      'Spowoduje to zmianę etykiety klucza YubiKey.';

  @override
  String get s_shortcuts => 'Skróty';

  @override
  String get s_keyboard_shortcuts => 'Skróty klawiszowe';

  @override
  String get s_global_shortcuts => 'Skróty globalne';

  @override
  String get s_application_shortcuts => 'Skróty aplikacji';

  @override
  String s_quit_app(String app) {
    return 'Wyjdź z $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Ukryj $app';
  }

  @override
  String get s_search => 'Szukaj';

  @override
  String get s_next_device => 'Następne urządzenie';

  @override
  String get s_previous_device => 'Poprzednie urządzenie';

  @override
  String get s_open_settings => 'Otwórz ustawienia';

  @override
  String get s_open_help_and_about => 'Otwórz pomoc i informacje';

  @override
  String get s_open_item => 'Otwórz element';

  @override
  String get s_edit_item => 'Edytuj element';

  @override
  String get s_delete_item => 'Usuń element';

  @override
  String get s_calculate_oath_code => 'Oblicz kod OATH';

  @override
  String get s_open_keyboard_shortcuts => 'Otwórz skróty klawiszowe';
}
