// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class AppLocalizationsTr extends AppLocalizations {
  AppLocalizationsTr([String locale = 'tr']) : super(locale);

  @override
  String get app_name => 'Yubico Kimlik Doğrulayıcı';

  @override
  String get native_language_name => 'Türkçe';

  @override
  String s_translated(int percentage) {
    return 'Çeviri oranı: %$percentage';
  }

  @override
  String s_proofread(int percentage) {
    return 'Gözden geçirme oranı: %$percentage';
  }

  @override
  String get l_incomplete_translation => 'Tamamlanmamış çeviri';

  @override
  String get p_translation_progress_desc =>
      'İlerleme göstergeleri, çevirinin durumunu yansıtır.';

  @override
  String get s_save => 'Kaydet';

  @override
  String get s_cancel => 'İptal et';

  @override
  String get s_close => 'Kapat';

  @override
  String get s_delete => 'Sil';

  @override
  String get s_move => 'Taşı';

  @override
  String get s_quit => 'Çık';

  @override
  String get s_enable => 'Aktifleştir';

  @override
  String get s_enabled => 'Aktif';

  @override
  String get s_disabled => 'Deaktif';

  @override
  String get s_status => 'Durum';

  @override
  String get s_unlock => 'Kilidini aç';

  @override
  String get s_calculate => 'Hesapla';

  @override
  String get s_import => 'İçe Aktar';

  @override
  String get s_overwrite => 'Geçerli Olanın Üzerine Yaz';

  @override
  String get s_done => 'Tamamlandı';

  @override
  String get s_label => 'Etiket';

  @override
  String get s_name => 'İsim';

  @override
  String get s_usb => 'Taşınabilir Bellek';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Şeçenekler';

  @override
  String get s_details => 'Ayrıntılar';

  @override
  String get s_show_window => 'Pencereyi göster';

  @override
  String get s_hide_window => 'Pencereyi gizle';

  @override
  String get s_show_navigation => 'Navigasyonu göster';

  @override
  String get s_expand_navigation => 'Expand navigation bar';

  @override
  String get s_collapse_navigation => 'Collapse navigation bar';

  @override
  String get s_expand_collapse_navigation => 'Expand/collapse navigation bar';

  @override
  String get s_show_menu => 'Menüyü göster';

  @override
  String get s_toggle_menu_bar => 'Toggle menu bar';

  @override
  String get s_more_info => 'Daha fazla bilgi';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'Hakkında';

  @override
  String get s_algorithm => 'Algoritma';

  @override
  String get s_appearance => 'Görünüm';

  @override
  String get s_actions => 'Eylemler';

  @override
  String get s_manage => 'Yönet';

  @override
  String get s_setup => 'Kurulum';

  @override
  String get s_device => 'Cihaz';

  @override
  String get s_application => 'Uygulama';

  @override
  String get s_settings => 'Ayarlar';

  @override
  String get l_settings_desc => 'Uygulama tercihlerini değiştir';

  @override
  String get s_certificates => 'Sertifikalar';

  @override
  String get s_security_key => 'Güvenlik Anahtarı';

  @override
  String get s_slots => 'Yuvalar';

  @override
  String get s_help_and_about => 'Yardım ve hakkında';

  @override
  String get l_help_and_about_desc => 'Sorun giderme ve destek';

  @override
  String get s_help_and_feedback => 'Yardım ve geri bildirim';

  @override
  String get s_home => 'Ana sayfa';

  @override
  String get s_user_guide => 'Kullanıcı Rehberi';

  @override
  String get s_i_need_help => 'Yardıma ihtiyacım var';

  @override
  String get s_troubleshooting => 'Sorun giderme';

  @override
  String get s_terms_of_use => 'Kullanım koşulları';

  @override
  String get s_privacy_policy => 'Gizlilik politikası';

  @override
  String get s_open_src_licenses => 'Açık kaynak lisansları';

  @override
  String get s_please_wait => 'Lütfen bekleyin…';

  @override
  String get s_secret_key => 'Gizli anahtar';

  @override
  String get s_show_secret_key => 'Gizli anahtarı göster';

  @override
  String get s_hide_secret_key => 'Gizli anahtarı gizle';

  @override
  String get s_private_key => 'Özel anahtar';

  @override
  String get s_public_key => 'Genel anahtar';

  @override
  String get s_invalid_length => 'Geçersiz uzunluk';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Geçersiz biçim, izin verilen karakterler: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Seçili klavye için geçersiz karakterler';

  @override
  String get s_require_touch => 'Dokunma gerektirir';

  @override
  String get q_have_account_info => 'Hesap bilgileriniz var mı?';

  @override
  String get s_run_diagnostics => 'Tanılamayı çalıştırın';

  @override
  String s_log_level(String level) {
    return 'Günlük seviyesi: $level';
  }

  @override
  String get s_character_count => 'Karakter sayısı';

  @override
  String get s_language => 'Dil';

  @override
  String p_community_translations_desc(String crowdin) {
    return 'Çeviriler, $crowdin platformundaki topluluk tarafından yapılmaktadır.';
  }

  @override
  String get s_choose_language => 'Dil seçin';

  @override
  String get s_app_theme => 'Uygulama teması';

  @override
  String get s_choose_app_theme => 'Tema seçin';

  @override
  String get s_system_default => 'Sistem varsayılanı';

  @override
  String get s_light_mode => 'Aydınlık mod';

  @override
  String get s_dark_mode => 'Karanlık mod';

  @override
  String get s_list_layout => 'Liste düzeni';

  @override
  String get s_grid_layout => 'Izgara düzeni';

  @override
  String get s_mixed_layout => 'Karma düzen';

  @override
  String get s_select_layout => 'Düzen seçin';

  @override
  String get s_select_to_scan => 'Taramak için seçin';

  @override
  String get s_hide_reader => 'Okuyucuyu gizle';

  @override
  String get s_show_hidden_readers => 'Gizli okuyucuları göster';

  @override
  String get s_toggle_readers => 'Okuyucuları değiştir';

  @override
  String get l_toggle_readers_desc => 'Okuyucuları göster veya gizle';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'D/Y: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Seri numarası: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Donanım yazılımı sürümü: $version';
  }

  @override
  String get l_fips_capable => 'FIPS özellikli';

  @override
  String get l_fips_approved => 'FIPS onaylı';

  @override
  String get l_insert_yk => 'YubiKey\'inizi yerleştirin';

  @override
  String get l_insert_or_tap_yk => 'Bir YubiKey yerleştirin veya dokundurun';

  @override
  String get l_unplug_yk => 'YubiKey\'inizi çıkartın';

  @override
  String get l_reinsert_yk => 'YubiKey\'inizi yeniden takın';

  @override
  String get l_place_on_nfc_reader =>
      'YubiKey\'inizi NFC okuyucunun üzerine yerleştirin';

  @override
  String get l_replace_yk_on_reader =>
      'YubiKey\'inizi NFC okuyucunun arkasına yerleştirin';

  @override
  String get l_remove_yk_from_reader =>
      'YubiKey\'inizi NFC okuyucudan kaldırın';

  @override
  String get p_try_reinsert_yk =>
      'YubiKey\'inizi çıkarıp ardından yeniden takmayı deneyin.';

  @override
  String get s_touch_required => 'Dokunma gerekli';

  @override
  String get l_touch_button_now => 'Şimdi YubiKey\'inizdeki düğmeye dokunun';

  @override
  String get l_keep_touching_yk =>
      'YubiKey\'inize art arda dokunmaya devam edin…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Kimlik Doğrulama';

  @override
  String get s_toggle_applications => 'Uygulamaları değiştir';

  @override
  String get s_toggle_interfaces => 'Arayüzü değiştir';

  @override
  String get p_toggle_applications_desc =>
      'Kullanılabilir taşıyıcılar üzerinden uygulamaları etkinleştir veya devre dışı bırak.';

  @override
  String get p_toggle_interfaces_desc =>
      'USB arayüzlerini etkinleştirin veya devre dışı bırakın.';

  @override
  String get l_toggle_applications_desc =>
      'Uygulamaları etkinleştir/devre dışı bırak';

  @override
  String get l_toggle_interfaces_desc => 'Arayüzü etkinleştir/devre dışı bırak';

  @override
  String get s_reconfiguring_yk => 'YubiKey yeniden yapılandırılıyor…';

  @override
  String get s_config_updated => 'Yapılandırma güncellendi';

  @override
  String get l_config_updated_reinsert =>
      'Yapılandırma güncellendi, YubiKey\'inizi çıkarın ve yeniden takın';

  @override
  String get s_fido_disabled => 'FIDO2 devre dışı';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn kullanabilmek için YubiKey\'inizde FIDO2 uygulamasının etkin olması gerekir';

  @override
  String get s_lock_code => 'Kilit kodu';

  @override
  String get l_wrong_lock_code => 'Yanlış kilit kodu';

  @override
  String get s_show_lock_code => 'Kilit kodunu göster';

  @override
  String get s_hide_lock_code => 'Kilit kodunu gizle';

  @override
  String get p_lock_code_required_desc =>
      'Gerçekleştirmek üzere olduğunuz eylem, yapılandırma kilit kodunun girilmesini gerektirir.';

  @override
  String get l_helper_not_responding => 'Yardımcı işlemi yanıt vermiyor';

  @override
  String get l_yk_no_access => 'Bu YubiKey\'e erişilemez';

  @override
  String get s_yk_inaccessible => 'Cihaza erişilemiyor';

  @override
  String get l_open_connection_failed => 'Bağlantı kurmakta başarısız olundu';

  @override
  String get l_ccid_connection_failed =>
      'Akıllı kart bağlantısı kurmakta başarısız olundu';

  @override
  String get p_ccid_service_unavailable =>
      'Akıllı kart hizmetinizin çalıştığından emin olun.';

  @override
  String get p_pcscd_unavailable =>
      'Pcscd\'nin kurulduğundan ve çalıştığından emin olun.';

  @override
  String get l_no_yk_present => 'YubiKey mevcut değil';

  @override
  String get s_unknown_type => 'Bilinmeyen tür';

  @override
  String get s_unknown_device => 'Tanınmayan cihaz';

  @override
  String get s_restricted_nfc => 'NFC aktivasyonu';

  @override
  String get l_deactivate_restricted_nfc => 'NFC nasıl etkinleştirilir';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'YubiKey\'inizi bilgisayar gibi herhangi bir USB güç kaynağına en az 3 saniye boyunca takılı tutun.\n\nGüç verildiğinde, NFC etkinleştirilecek ve kullanıma hazır olacaktır.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'YubiKey\'iniz, nakliye sırasında kablosuz manipülasyona karşı koruma sağlamak için tasarlanmış bir özellik olan Kısıtlı NFC ile donatılmıştır. Bu, siz etkinleştirene kadar NFC işlemlerinin geçici olarak devre dışı bırakıldığı anlamına gelir.';

  @override
  String get s_unsupported_yk => 'Desteklenmeyen YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'İşlem başarısız oldu, lütfen tekrar deneyin.';

  @override
  String get l_configuration_unsupported => 'Yapılandırma desteklenmiyor';

  @override
  String get p_scp_unsupported =>
      'NFC üzerinden iletişim kurmak için YubiKey\'in bu telefon tarafından desteklenmeyen bir teknolojiye ihtiyacı vardır. Lütfen YubiKey\'i telefonun USB girişine takın.';

  @override
  String get l_error_occurred => 'Bir hata meydana geldi';

  @override
  String get s_application_error => 'Uygulama hatası';

  @override
  String get l_import_error => 'İçe aktarma hatası';

  @override
  String get l_file_not_found => 'Dosya bulunamadı';

  @override
  String get l_file_too_big => 'Dosya boyutu çok büyük';

  @override
  String get l_filesystem_error => 'Dosya sistemi işlem hatası';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'PIN ayarla';

  @override
  String get s_change_pin => 'PIN\'i değiştir';

  @override
  String get s_change_puk => 'PUK\'u değiştir';

  @override
  String get s_show_pin => 'PIN\'i göster';

  @override
  String get s_hide_pin => 'PIN\'i gizle';

  @override
  String get s_show_puk => 'PUK\'u göster';

  @override
  String get s_hide_puk => 'PUK\'u gizle';

  @override
  String get s_current_pin => 'Mevcut PIN';

  @override
  String get s_current_puk => 'Mevcut PUK';

  @override
  String get s_new_pin => 'Yeni PIN';

  @override
  String get s_new_puk => 'Yeni PUK';

  @override
  String get s_confirm_pin => 'PIN\'i doğrula';

  @override
  String get s_confirm_puk => 'PUK\'u doğrula';

  @override
  String get s_unblock_pin => 'PIN\'i sıfırla';

  @override
  String get l_pin_mismatch => 'PIN\'ler eşleşmiyor';

  @override
  String get l_puk_mismatch => 'PUK\'lar eşleşmiyor';

  @override
  String get s_pin_set => 'PIN ayarlandı';

  @override
  String get s_puk_set => 'PUK ayarlandı';

  @override
  String l_set_pin_failed(String message) {
    return 'PIN\'in ayarlanmasında başarısız olundu: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries deneme hakkı kaldı',
      one: '$retries deneme hakkı kaldı',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries deneme hakkı kaldı',
      one: '$retries deneme hakkı kaldı',
    );
    return 'Yanlış PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries deneme hakkı kaldı',
      one: '$retries deneme hakkı kaldı',
    );
    return 'Yanlış PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'FIDO PIN koruması';

  @override
  String get s_pin_change_required => 'PIN değişikliği gerekli';

  @override
  String get l_enter_fido2_pin => 'YubiKey\'iniz için FIDO2 PIN kodunu girin';

  @override
  String get l_pin_blocked_reset =>
      'PIN bloke edildi; FIDO uygulamasını fabrika ayarlarına sıfırlayın';

  @override
  String get l_pin_blocked => 'PIN bloke edildi';

  @override
  String get l_set_pin_first => 'PIN kodu gereklidir';

  @override
  String get l_unlock_pin_first => 'Kilidi PIN koduyla açın';

  @override
  String get l_pin_soft_locked =>
      'YubiKey çıkarılıp yeniden takılana kadar PIN bloke edilmiştir';

  @override
  String get l_pin_change_required_desc =>
      'Bu uygulamayı kullanabilmeniz için yeni bir PIN kodu ayarlanmalıdır';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'PIN kodu $min_length-$max_length karakter uzunluğunda olmalı ve harf, rakam ve özel karakterler içerebilir.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'PIN kodu $min_length-$max_length karakter uzunluğunda olmalı, en az $unique_characters benzersiz karakter içermeli ve \"$common_pin\" gibi yaygın olarak kullanılan bir PIN kodu olmamalıdır. Harfler, sayılar ve özel karakterler içerebilir.';
  }

  @override
  String get s_ep_attestation => 'Kurumsal Doğrulama';

  @override
  String get s_ep_attestation_enabled => 'Kurumsal Doğrulama etkinleştirildi';

  @override
  String get q_enable_ep_attestation =>
      'Kurumsal Doğrulama etkinleştirilsin mi?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Bu, Kurumsal Doğrulamayı etkinleştirecek ve yetkili alan adlarının YubiKey\'inizi benzersiz şekilde tanımlamasına olanak tanıyacaktır.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Kurumsal Doğrulama etkinleştirildikten sonra, yalnızca FIDO fabrika ayarlarına sıfırlama işlemi ile devre dışı bırakılabilir.';

  @override
  String get s_pin_required => 'PIN gerekli';

  @override
  String get p_pin_required_desc =>
      'Gerçekleştirmek üzere olduğunuz eylem PIV PIN kodunun girilmesini gerektirir.';

  @override
  String get l_piv_pin_blocked => 'Engellendi, sıfırlamak için PUK kullanın';

  @override
  String get p_piv_pin_blocked_desc =>
      'PIN bloke edilmiştir. Sıfırlamak için PUK kullanın.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'The PIN is blocked. A factory reset is required.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Bloke edildi, fabrika ayarlarına sıfırlama gerekli';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Hem PIN hem de PUK bloke edilmiştir. PIV uygulamasının fabrika ayarlarına sıfırlanması gerekmektedir.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'Bir $name en az $length karakter uzunluğunda olmalıdır.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'Bir $name en az $length karakter uzunluğunda olmalı, en az 2 benzersiz karakter içermeli ve \"$common\" gibi yaygın olarak kullanılan bir $name içermemelidir.';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Yeni $name karmaşıklık gereksinimlerini karşılamıyor.';
  }

  @override
  String get s_dismiss => 'Yoksay';

  @override
  String get p_default_pin_puk_key_desc =>
      'Varsayılan PIN, PUK ve yönetim anahtarının değiştirilmesi önerilir.';

  @override
  String get l_warning_default_pin => 'Uyarı: Varsayılan PIN kullanıldı';

  @override
  String get l_warning_default_puk => 'Uyarı: Varsayılan PUK kullanıldı';

  @override
  String get l_default_pin_used => 'Varsayılan PIN kullanıldı';

  @override
  String get l_default_puk_used => 'Varsayılan PUK kullanıldı';

  @override
  String get l_pin_complexity => 'PIN karmaşıklığı zorunlu kılındı';

  @override
  String get s_password => 'Şifre';

  @override
  String get s_manage_password => 'Şifreyi yönet';

  @override
  String get s_set_password => 'Şifre belirle';

  @override
  String get s_password_set => 'Şifre ayarlandı';

  @override
  String get s_show_password => 'Şifreyi göster';

  @override
  String get s_hide_password => 'Şifreyi Gizle';

  @override
  String get l_password_protection => 'Hesapların parola koruması';

  @override
  String get s_new_password => 'Yeni şifre';

  @override
  String get s_current_password => 'Geçerli şifre';

  @override
  String get s_confirm_password => 'Şifreyi doğrula';

  @override
  String get l_password_mismatch => 'Şifreler eşleşmiyor';

  @override
  String get s_wrong_password => 'Yanlış şifre';

  @override
  String get p_wrong_password =>
      'Yanlış şifre. Şifrenizi bilmiyorsanız, YubiKey\'i sıfırlamanız gerekmektedir.';

  @override
  String get s_remove_password => 'Şifreyi kaldır';

  @override
  String get s_password_removed => 'Şifre kaldırıldı';

  @override
  String get s_remember_password => 'Şifreyi hatırla';

  @override
  String get s_clear_saved_password => 'Kayıtlı şifreyi temizle';

  @override
  String get s_password_forgotten => 'Şifremi unuttum';

  @override
  String get l_keystore_unavailable =>
      'İşletim sistemi anahtar deposu kullanılamıyor';

  @override
  String get l_remember_pw_failed =>
      'Şifrenin hatırlanmasında başarısız olundu';

  @override
  String get l_unlock_first => 'Kilidi şifre ile açın';

  @override
  String get l_set_password_first => 'Şifre ayarla';

  @override
  String get l_enter_oath_pw => 'YubiKey\'iniz için OATH şifresini girin';

  @override
  String get p_new_password_requirements =>
      'Bir şifre harfler, sayılar ve özel karakterler içerebilir.';

  @override
  String get s_management_key => 'Yönetim anahtarı';

  @override
  String get s_current_management_key => 'Mevcut yönetim anahtarı';

  @override
  String get s_new_management_key => 'Yeni yönetim anahtarı';

  @override
  String get l_change_management_key => 'Yönetim anahtarını değiştir';

  @override
  String get l_management_key_changed => 'Yönetim anahtarı değiştirildi';

  @override
  String get l_default_key_used => 'Varsayılan yönetim anahtarı kullanıldı';

  @override
  String get s_generate_random => 'Rastgele oluştur';

  @override
  String get s_use_default => 'Varsayılanı kullan';

  @override
  String get l_warning_default_key => 'Uyarı: Varsayılan anahtar kullanıldı';

  @override
  String get s_protect_key => 'PIN ile koruyun';

  @override
  String get p_protect_key_desc =>
      'Yönetim anahtarı kimlik doğrulaması gerektiren işlemler sırasında yönetim anahtarı yerine PIN kullanın.';

  @override
  String get s_management_key_algorithm => 'Yönetim anahtarı algoritması';

  @override
  String get p_management_key_algorithm_desc =>
      'Yönetim anahtarı için seçilecek algoritma.';

  @override
  String get l_pin_protected_key => 'Bunun yerine PIN kullanılabilir';

  @override
  String get l_wrong_key => 'Yanlış anahtar';

  @override
  String get l_unlock_piv_management => 'PIV yönetiminin kilidini açın';

  @override
  String get p_unlock_piv_management_desc =>
      'Gerçekleştirmek üzere olduğunuz eylem PIV yönetim anahtarını gerektirir.';

  @override
  String l_account(String label) {
    return 'Hesap: $label';
  }

  @override
  String get s_accounts => 'Hesaplar';

  @override
  String get s_no_accounts => 'Hesap yok';

  @override
  String l_results_for(String query) {
    return '\"$query\" için sonuçlar';
  }

  @override
  String get l_authenticator_get_started =>
      'OTP hesaplarını kullanmaya başlayın';

  @override
  String get l_no_accounts_desc =>
      'YubiKey\'inize OATH TOTP/HOTP destekleyen herhangi bir servis sağlayıcıdan hesap ekleyin';

  @override
  String get s_add_account => 'Hesap ekle';

  @override
  String get p_add_account_desc =>
      'QR kodunu tarayın veya kimlik bilgisi ayrıntılarını manuel olarak girin.';

  @override
  String get s_add_accounts => 'Hesap(lar) ekleyin';

  @override
  String get l_drop_qr_description =>
      'Hesap(lar)ı eklemek için QR kodunu bırakın';

  @override
  String get p_add_account_three_ways => 'Hesap eklemenin üç yolu vardır.';

  @override
  String get s_scanning => 'Tarama (önerilir)';

  @override
  String get p_scanning_desc =>
      'Bir QR kodunu taramadan önce, kodun tamamının ekranda görülebilir olduğundan emin olun.';

  @override
  String get s_drag_and_drop => 'Sürükle ve bırak';

  @override
  String get p_drag_and_drop_desc =>
      'QR kod içeren bir görüntü, Hesaplar görünümünde herhangi bir yere bırakılabilir.';

  @override
  String get s_manually => 'Manuel olarak';

  @override
  String get p_manually_desc =>
      'Hesap kimlik bilgileri forma manuel olarak girilebilir.';

  @override
  String get s_account_added => 'Hesap eklendi';

  @override
  String l_account_add_failed(String message) {
    return 'Hesabın eklenmesinde başarısız olundu: $message';
  }

  @override
  String get l_add_account_password_required => 'Şifre gerekli';

  @override
  String get l_add_account_unlock_required => 'Kilidin açılması gerekli';

  @override
  String get l_add_account_already_exists => 'Hesap zaten mevcut';

  @override
  String get l_add_account_func_missing =>
      'Bu özellik mevcut değil ya da devre dışı bırakılmış';

  @override
  String get l_account_name_required => 'Hesabınızın bir adı olmalıdır';

  @override
  String get l_name_already_exists => 'Bu adda sağlayıcı zaten mevcut';

  @override
  String get l_account_already_exists => 'Bu hesap YubiKey\'de zaten mevcut';

  @override
  String get l_invalid_character_issuer =>
      'Geçersiz karakter: \':\' sağlayıcı isminde izin verilmiyor';

  @override
  String get l_select_accounts => 'YubiKey\'e eklenecek hesap(lar)ı seçin';

  @override
  String get s_pin_account => 'Hesabı sabitle';

  @override
  String get s_unpin_account => 'Hesabın sabitlemesini kaldır';

  @override
  String get s_no_pinned_accounts => 'Sabitlenmiş hesap yok';

  @override
  String get s_pinned => 'Sabitlendi';

  @override
  String get l_pin_account_desc => 'Önemli hesaplarınızı bir arada tutun';

  @override
  String get s_rename_account => 'Hesabı yeniden adlandır';

  @override
  String get l_rename_account_desc => 'Hesabın sağlayıcısını/adını düzenleyin';

  @override
  String get s_account_renamed => 'Hesap yeniden adlandırıldı';

  @override
  String l_rename_account_failed(String message) {
    return 'Hesabın yeniden adlandırılmasında başarısız olundu: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Bu işlem, hesabın listedeki görünümünü değiştirecek.';

  @override
  String get s_delete_account => 'Hesabı sil';

  @override
  String get q_delete_account => 'Hesabı sil?';

  @override
  String get l_delete_account_desc => 'Hesabı YubiKey\'inizden kaldırın';

  @override
  String get s_account_deleted => 'Hesap silindi';

  @override
  String get p_warning_delete_account =>
      'Uyarı! Bu işlem, hesabı YubiKey\'inizden silecektir.';

  @override
  String get p_warning_disable_credential =>
      'Kilitlenmeyi önlemek için bu hesabın kayıtlı olduğu hizmetten devre dışı bıraktığınızdan emin olun.';

  @override
  String get s_account_name => 'Hesap adı';

  @override
  String get s_search_accounts => 'Hesapları Ara';

  @override
  String l_accounts_used(int used, int capacity) {
    return 'Toplam $capacity hesap kapasitesinin, $used tanesi kullanılıyor';
  }

  @override
  String s_num_digits(int num) {
    return '$num haneli';
  }

  @override
  String s_num_sec(int num) {
    return '$num sn';
  }

  @override
  String get s_issuer_optional => 'Sağlayıcı (isteğe bağlı)';

  @override
  String get s_counter_based => 'Sayaca dayalı';

  @override
  String get s_time_based => 'Zamana dayalı';

  @override
  String get l_copy_code_desc => 'Kodu başka bir uygulamaya yapıştırın';

  @override
  String get l_calculate_code_desc => 'YubiKey\'inizden yeni bir kod alın';

  @override
  String get s_rp_id => 'RP kimliği';

  @override
  String get s_user_id => 'Kullanıcı kimliği';

  @override
  String get s_credential_id => 'Kimlik Bilgisi Kimliği';

  @override
  String get s_display_name => 'Görünen Ad';

  @override
  String get s_user_name => 'Kullanıcı Adı';

  @override
  String get s_passkeys => 'Geçiş Anahtarları';

  @override
  String get s_no_passkeys => 'Geçiş anahtarı yok';

  @override
  String get l_ready_to_use => 'Kullanıma hazır';

  @override
  String get l_register_sk_on_websites =>
      'Web sitelerine Güvenlik Anahtarı olarak kaydolun';

  @override
  String get l_no_discoverable_accounts => 'Kayıtlı geçiş anahtarı yok';

  @override
  String get p_non_passkeys_note =>
      'Geçiş anahtarı olmayan kimlik bilgileri mevcut olabilir, ancak bunlar listenemez.';

  @override
  String get s_delete_passkey => 'Geçiş anahtarını sil';

  @override
  String get q_delete_passkey => 'Geçiş anahtarını sil?';

  @override
  String get l_delete_passkey_desc => 'Geçiş anahtarını YubiKey\'den kaldır';

  @override
  String get s_passkey_deleted => 'Geçiş anahtarı silindi';

  @override
  String get p_warning_delete_passkey =>
      'Uyarı! Bu işlem YubiKey\'inizden geçiş anahtarını silecektir.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Artık bu geçiş anahtarını kayıtlı olduğu hizmet için kullanamazsınız.';

  @override
  String get s_search_passkeys => 'Geçiş anahtarı ara';

  @override
  String p_passkeys_used(int used, int max) {
    return 'Toplam $max geçiş anahtarı kapasitesinin, $used tanesi kullanılıyor.';
  }

  @override
  String get s_biometrics => 'Biyometri';

  @override
  String l_fingerprint(String label) {
    return 'Parmak izi: $label';
  }

  @override
  String get s_fingerprints => 'Parmak izleri';

  @override
  String get l_fingerprint_captured => 'Parmak izi başarıyla alındı!';

  @override
  String get s_fingerprint_added => 'Parmak izi eklendi';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Parmak izi eklenirken hata oluştu: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'İsim ayarlanırken hata oluştu: $message';
  }

  @override
  String get s_setup_fingerprints => 'Parmak izi kurulumu';

  @override
  String get p_setup_fingerprints_desc =>
      'Anahtarı kullanabilmek için önce parmak izi eklemelisiniz.';

  @override
  String get s_add_fingerprint => 'Parmak izi ekle';

  @override
  String get s_delete_fingerprint => 'Parmak izini sil';

  @override
  String get q_delete_fingerprint => 'Parmak izini sil?';

  @override
  String get l_delete_fingerprint_desc => 'Parmak izini YubiKey\'den kaldır';

  @override
  String get s_fingerprint_deleted => 'Parmak izi silindi';

  @override
  String get p_warning_delete_fingerprint =>
      'Bu işlem parmak izini YubiKey\'inizden silecektir.';

  @override
  String get s_fingerprints_get_started => 'Parmak izi kaydetmeye başlayın';

  @override
  String get p_set_fingerprints_desc =>
      'Parmak izlerinin kaydedilebilmesi için öncelikle bir PIN kodunun ayarlanması gerekiyor.';

  @override
  String get l_no_fps_added => 'Parmak izi eklenmedi';

  @override
  String get s_rename_fp => 'Parmak izini yeniden adlandır';

  @override
  String get l_rename_fp_desc => 'Adını değiştir';

  @override
  String get s_fingerprint_renamed => 'Parmak izi yeniden adlandırıldı';

  @override
  String l_rename_fp_failed(String message) {
    return 'Yeniden adlandırırken hata oluştu: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Bir veya daha fazla (en fazla beş) parmak izi ekleyin';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 parmak izi kaydedildi';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Başlamak için parmağınızı YubiKey\'e bastırın.';

  @override
  String get l_name_fingerprint => 'Bu parmak izini adlandırın';

  @override
  String get l_user_action_timeout_error =>
      'Kullanıcı hareketsizliği nedeniyle başarısız olundu';

  @override
  String get l_wrong_inserted_yk_error =>
      'Yeniden takılan YubiKey ilk cihazla eşleşmiyor';

  @override
  String get l_failed_connecting_to_fido =>
      'FIDO arayüzüne bağlanılmasında başarısız olundu';

  @override
  String get l_self_signed_certificate => 'Kendi imzasını taşıyan sertifika';

  @override
  String get l_certificate_signing_request => 'Sertifika İmzalama İsteği (CSR)';

  @override
  String get s_certificate => 'Sertifika';

  @override
  String get s_subject => 'Başlık';

  @override
  String get l_export_csr_file => 'CSR\'yi dosyaya kaydet';

  @override
  String get l_export_public_key => 'Genel anahtarı dışa aktar';

  @override
  String get l_export_public_key_file => 'Genel anahtarı dosyaya kaydet';

  @override
  String get l_export_public_key_desc => 'Genel anahtarı bir dosyaya aktar';

  @override
  String get l_public_key_exported => 'Genel anahtar dışa aktarıldı';

  @override
  String get l_export_certificate => 'Sertifikayı dışa aktar';

  @override
  String get l_export_certificate_file => 'Sertifikayı dosyaya aktar';

  @override
  String get l_export_certificate_desc => 'Sertifikayı dosyaya aktar';

  @override
  String get l_certificate_exported => 'Sertifika dışa aktarıldı';

  @override
  String get l_select_import_file => 'İçe aktarılacak dosyayı seçin';

  @override
  String get l_import_file => 'Dosya içe aktar';

  @override
  String get l_import_desc => 'Bir anahtarı ve/veya sertifikayı içe aktar';

  @override
  String get l_import_nothing => 'İçe aktarılacak bir şey yok';

  @override
  String get l_importing_file => 'Dosya içe aktarılıyor…';

  @override
  String get s_file_imported => 'Dosya içe aktarıldı';

  @override
  String get l_unsupported_key_type => 'Desteklenmeyen anahtar türü';

  @override
  String get l_delete_certificate => 'Sertifikayı sil';

  @override
  String get q_delete_certificate => 'Sertifikayı sil?';

  @override
  String get l_delete_certificate_desc =>
      'Sertifikayı YubiKey\'inizden kaldırın';

  @override
  String get l_delete_key => 'Anahtarı sil';

  @override
  String get q_delete_key => 'Anahtarı sil?';

  @override
  String get l_delete_key_desc => 'Anahtarı YubiKey\'inizden kaldırın';

  @override
  String get l_delete_certificate_or_key => 'Sertifikayı/anahtarı sil';

  @override
  String get q_delete_certificate_or_key => 'Sertifikayı/anahtarı sil?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Sertifikayı veya anahtarı YubiKey\'inizden kaldırın';

  @override
  String get l_move_key => 'Anahtarı taşı';

  @override
  String get l_move_key_desc => 'Bir anahtarı bir PIV yuvasından diğerine taşı';

  @override
  String get l_change_defaults => 'Varsayılan erişim kodlarını değiştir';

  @override
  String get s_issuer => 'Sağlayıcı';

  @override
  String get s_serial => 'Seri Numarası';

  @override
  String get s_certificate_fingerprint => 'Parmak izi';

  @override
  String get s_valid_from => 'Geçerlilik süresi başlangıcı';

  @override
  String get s_valid_to => 'Geçerlilik süresi sonu';

  @override
  String get l_no_certificate => 'Sertifika yüklenmedi';

  @override
  String get l_key_no_certificate => 'Sertifika yüklenmemiş anahtar';

  @override
  String get s_generate_key => 'Anahtar üret';

  @override
  String get l_generate_desc => 'Yeni bir sertifika veya CSR üret';

  @override
  String p_generate_desc(String slot) {
    return 'Bu, $slot PIV yuvasındaki YubiKey üzerinde yeni bir anahtar oluşturacaktır.';
  }

  @override
  String get s_private_key_generated => 'Özel anahtar oluşturuldu';

  @override
  String get p_select_what_to_delete => 'Yuvadan neyin silineceğini seçin.';

  @override
  String get p_warning_delete_certificate =>
      'Uyarı! Bu işlem sertifikayı YubiKey\'inizden silecektir.';

  @override
  String get p_warning_delete_key =>
      'Uyarı! Bu işlem özel anahtarı YubiKey\'inizden silecektir.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Uyarı! Bu işlem sertifikayı ve özel anahtarı YubiKey\'inizden silecektir.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Bu işlem $slot PIV yuvasındaki sertifikayı silecektir.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Bu işlem $slot PIV yuvasındaki özel anahtarı silecektir.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Bu işlem $slot PIV yuvasındaki sertifikayı ve özel anahtarı silecektir.';
  }

  @override
  String get l_certificate_deleted => 'Sertifika silindi';

  @override
  String get l_key_deleted => 'Anahtar silindi';

  @override
  String get l_certificate_and_key_deleted => 'Sertifika ve anahtar silindi';

  @override
  String get l_include_certificate => 'Sertifikayı dahil et';

  @override
  String get l_select_destination_slot => 'Hedef yuvasını seçin';

  @override
  String q_move_key_confirm(String from_slot) {
    return '$from_slot PIV yuvasındaki özel anahtar taşınsın mı?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return '$from_slot PIV yuvasındaki özel anahtar, $to_slot yuvasına taşınsın mı?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return '$from_slot PIV yuvasındaki özel anahtar ve sertifika, $to_slot yuvasına taşınsın mı?';
  }

  @override
  String get p_password_protected_file => 'Seçilen dosya parola korumalıdır.';

  @override
  String p_import_items_desc(String slot) {
    return 'Aşağıdaki(ler), $slot PIV yuvasına aktarılacaktır.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Sertifikanın genel anahtarı, yuvadaki özel anahtarla eşleşmiyor';

  @override
  String get l_key_moved => 'Anahtar taşındı';

  @override
  String get l_key_and_certificate_moved => 'Anahtar ve sertifika taşındı';

  @override
  String get p_subject_desc =>
      'RFC 4514 spesifikasyonuna uygun biçimlendirilmiş ayırt edici isim (DN).';

  @override
  String get l_rfc4514_invalid => 'Geçersiz RFC 4514 biçimi';

  @override
  String get rfc4514_examples =>
      'Örnekler:\nCN=Örnek Adı\nCN=jsmith,DC=örnek,DC=net';

  @override
  String get s_allow_fingerprint => 'Parmak izine izin ver';

  @override
  String get s_pin_policy => 'PIN politikası';

  @override
  String get s_output_format => 'Çıktı formatı';

  @override
  String get s_expiration_date => 'Son kullanma tarihi';

  @override
  String get p_algorithm_desc => 'Anahtarda kullanılacak algoritma.';

  @override
  String get p_expiration_date_desc =>
      'Sertifikanın sona ereceği tarih; varsayılan olarak 1 yıl (yalnızca sertifikalar için).';

  @override
  String get p_key_options_bio_desc =>
      'PIN yerine biyometri kullanılmasına izin verin.';

  @override
  String get q_overwrite_slot => 'Yuvanın üzerine yazılsın mı?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Bu işlem, $slot yuvasındaki mevcut içeriğin üzerine kalıcı olarak yazacaktır.';
  }

  @override
  String get l_overwrite_cert => 'Sertifikanın üzerine yazılacaktır';

  @override
  String get l_overwrite_key => 'Özel anahtarın üzerine yazılacaktır';

  @override
  String get l_overwrite_key_maybe =>
      'Yuvadaki mevcut tüm özel anahtarların üzerine yazılacaktır';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Kimlik doğrulama';

  @override
  String get s_slot_9c => 'Dijital imza';

  @override
  String get s_slot_9d => 'Anahtar yönetimi';

  @override
  String get s_slot_9e => 'Kart kimlik doğrulama';

  @override
  String get s_retired_slot => 'Kullanımdan kaldırılmış Anahtar Yönetimi';

  @override
  String get s_otp_slot_one => 'Kısa dokunuş';

  @override
  String get s_otp_slot_two => 'Uzun dokunuş';

  @override
  String get l_otp_slot_empty => 'Yuva boş';

  @override
  String get l_otp_slot_configured => 'Yuva yapılandırıldı';

  @override
  String get l_yubiotp_desc => 'Bir Yubico OTP kimlik bilgisi programlayın';

  @override
  String get s_challenge_response => 'Meydan okuma-yanıt';

  @override
  String get l_challenge_response_desc =>
      'Bir meydan okuma-yanıt kimlik bilgisi programlayın';

  @override
  String get s_static_password => 'Statik şifre';

  @override
  String get l_static_password_desc => 'Statik bir şifre yapılandır';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'HMAC-SHA1 tabanlı bir kimlik bilgisi programlayın';

  @override
  String get s_public_id => 'Genel Kimlik';

  @override
  String get s_private_id => 'Özel Kimlik';

  @override
  String get s_use_serial => 'Seri numarasını kullan';

  @override
  String get l_select_file => 'Dosya seçin';

  @override
  String get l_no_export_file => 'Dışa aktarma dosyası yok';

  @override
  String get s_no_export => 'Dışa aktarma yok';

  @override
  String get s_export => 'Dışa aktar';

  @override
  String get l_export_configuration_file => 'Yapılandırmayı dosyaya aktar';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Dışa aktarılan kimlik bilgileri, $url adresinden yükleyebilirsiniz';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Klavye $layout';
  }

  @override
  String get s_delete_slot => 'Kimlik bilgisini sil';

  @override
  String get q_delete_slot => 'Kimlik bilgisi silinsin mi?';

  @override
  String get l_delete_slot_desc => 'Yuvadaki kimlik bilgisini kaldırın';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Uyarı! Bu eylem kimlik bilgisini $slot_id yuvasından kalıcı olarak kaldıracaktır.';
  }

  @override
  String get l_slot_deleted => 'Kimlik bilgisi silindi';

  @override
  String get s_swap => 'Değiştir';

  @override
  String get s_swap_slots => 'Yuvaları değiştir';

  @override
  String get q_swap_slots => 'Yuvalar değiştirilsin mi?';

  @override
  String get l_swap_slots_desc => 'Kısa/uzun dokunuşu değiştir';

  @override
  String get p_swap_slots_desc =>
      'Bu işlem, iki yuvanın yapılandırmasını birbirleriyle değiştirecektir.';

  @override
  String get l_slots_swapped => 'Yuva yapılandırmaları değiştirildi';

  @override
  String l_slot_credential_configured(String type) {
    return '$type kimlik bilgisi yapılandırıldı';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return '$type kimlik bilgisi yapılandırıldı ve $file adresine aktarıldı';
  }

  @override
  String get s_append_enter => 'Ekle ⏎';

  @override
  String get l_append_enter_desc =>
      'OTP gönderiminden sonra otomatik olarak Enter tuşuna bas';

  @override
  String get p_otp_swap_error =>
      'Yuva değişimi başarısız oldu! YubiKey\'de erişim kısıtlaması olmadığından emin olun.';

  @override
  String get l_wrong_access_code => 'Yanlış erişim kodu';

  @override
  String get s_access_code => 'Erişim kodu';

  @override
  String get s_show_access_code => 'Erişim kodunu göster';

  @override
  String get s_hide_access_code => 'Erişim kodunu gizle';

  @override
  String p_enter_access_code(String slot) {
    return '$slot yuvasına erişebilmek için erişim kodunu girin.';
  }

  @override
  String get s_enable_nfc => 'NFC\'yi Etkinleştir';

  @override
  String get s_request_access => 'Erişim talep et';

  @override
  String get s_permission_denied => 'Erişim reddedildi';

  @override
  String get l_elevating_permissions => 'İzinler yükseltiliyor…';

  @override
  String get s_review_permissions => 'İzinleri gözden geçir';

  @override
  String get s_open_windows_settings => 'Windows ayarlarını aç';

  @override
  String get l_admin_privileges_required => 'Yönetici ayrıcalıkları gerekli';

  @override
  String get p_elevated_permissions_required =>
      'Bu cihazı yönetebilmek için yönetici iznine (yükseltilmiş yetkilere) ihtiyacınız var. Alternatif olarak, FIDO yapılandırmasını yönetmek için Windows Ayarlarını kullanabilirsiniz.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'WebAuthn yönetimi için yönetici iznine (yükseltilmiş yetkilere) ihtiyacınız var. Alternatif olarak, FIDO yapılandırmasını yönetmek için Windows Ayarlarını kullanabilirsiniz.';

  @override
  String get l_ms_store_permission_note =>
      'Uygulamanın Microsoft Store sürümü izinleri yükseltemeyebilir';

  @override
  String get p_need_camera_permission =>
      'Yubico Kimlik Doğrulayıcı, QR kodlarını tarayabilmek için kameraya erişme iznine ihtiyacı var.';

  @override
  String get s_qr_scan => 'QR kodunu tara';

  @override
  String get l_invalid_qr => 'Geçersiz QR kodu';

  @override
  String get l_qr_not_found => 'QR kod bulunamadı';

  @override
  String get l_qr_scanned => 'Taranmış QR kodu';

  @override
  String l_qr_file_too_large(String max) {
    return 'Dosya çok büyük (maks. $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Geçersiz resim dosyası';

  @override
  String get l_qr_select_file => 'QR kodlu dosyayı seçin';

  @override
  String l_qr_not_read(String message) {
    return 'QR kodun okunmasında başarısız olundu: $message';
  }

  @override
  String get l_point_camera_scan =>
      'QR kodunu taramak için kameranızı bir QR koduna doğrultun';

  @override
  String get q_want_to_scan => 'Taramak ister misiniz?';

  @override
  String get q_no_qr => 'QR kodu yok mu?';

  @override
  String get s_enter_manually => 'Manuel olarak girin';

  @override
  String get s_read_from_file => 'Dosyadan oku';

  @override
  String get s_reset => 'Sıfırla';

  @override
  String get s_factory_reset => 'Fabrika ayarlarına sıfırla';

  @override
  String get l_factory_reset_desc => 'YubiKey varsayılan ayarlarını geri yükle';

  @override
  String get l_factory_reset_required => 'Fabrika ayarlarına sıfırlama gerekli';

  @override
  String get l_oath_application_reset => 'OATH uygulaması sıfırlandı';

  @override
  String get l_fido_app_reset => 'FIDO uygulaması sıfırlandı';

  @override
  String l_reset_failed(String message) {
    return 'Sıfırlama gerçekleştirilirken hata oluştu: $message';
  }

  @override
  String get l_piv_app_reset => 'PIV uygulaması sıfırlandı';

  @override
  String get p_factory_reset_an_app =>
      'YubiKey\'inizdeki bir uygulamayı fabrika ayarlarına sıfırlayın.';

  @override
  String get p_factory_reset_desc =>
      'Veriler YubiKey\'de birden fazla uygulamada saklanır ve bunlardan bazıları birbirinden bağımsız olarak fabrika ayarlarına sıfırlanabilir.\n\nYukarıdaki seçeneklerden sıfırlamak istediğiniz bir uygulamayı seçin.';

  @override
  String get p_warning_factory_reset =>
      'Uyarı! Bu işlem tüm OATH TOTP/HOTP hesaplarını YubiKey\'inizden geri alınamaz şekilde silecektir.';

  @override
  String get p_warning_disable_credentials =>
      'OATH kimlik bilgilerinizin yanı sıra ayarlanan tüm parolalar YubiKey\'den kaldırılacaktır. Hesaplarınızın kilitlenmesini önlemek için bunları ilgili web sitelerinden devre dışı bıraktığınızdan emin olun.';

  @override
  String get p_warning_deletes_accounts =>
      'Uyarı! Bu işlem, geçiş anahtarları da dahil olmak üzere tüm U2F ve FIDO2 hesaplarını YubiKey\'inizden geri alınamaz bir şekilde silecektir.';

  @override
  String get p_warning_disable_accounts =>
      'Kimlik bilgileriniz ve ayarladığınız herhangi bir PIN bu YubiKey\'den kaldırılacaktır. Hesaplarınızın kilitlenmesini önlemek için bunları ilgili web sitelerinden devre dışı bıraktığınızdan emin olun.';

  @override
  String get p_warning_piv_reset =>
      'Uyarı! PIV içinde saklanan tüm veriler YubiKey\'inizden geri alınamaz şekilde silinecektir.';

  @override
  String get p_warning_piv_reset_desc =>
      'Buna özel anahtarlar ve sertifikalar da dahildir. PIN, PUK ve yönetim anahtarınız fabrika varsayılana sıfırlanacaktır.';

  @override
  String get p_warning_global_reset =>
      'Uyarı! Bu işlem, kimlik bilgileri de dahil olmak üzere kayıtlı tüm verileri YubiKey\'inizden geri alınamaz bir şekilde silecektir.';

  @override
  String get p_warning_global_reset_desc =>
      'YubiKey\'inizdeki uygulamaları fabrika ayarlarına sıfırlayın. PIN fabrika varsayılana sıfırlanacak ve kayıtlı parmak izleri kaldırılacaktır. Tüm anahtarlar, sertifikalar veya diğer kimlik bilgileri kalıcı olarak kaldırılacaktır.';

  @override
  String get l_copy_to_clipboard => 'Panoya kopyala';

  @override
  String get s_code_copied => 'Kod kopyalandı';

  @override
  String get l_code_copied_clipboard => 'Kod panoya kopyalandı';

  @override
  String get s_copy_log => 'Günlüğü kopyala';

  @override
  String get l_log_copied => 'Günlük panoya kopyalandı';

  @override
  String get l_diagnostics_copied => 'Teşhis verileri panoya kopyalandı';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label panoya kopyalandı.';
  }

  @override
  String get s_custom_icons => 'Özel simgeler';

  @override
  String get l_set_icons_for_accounts => 'Hesaplar için simge ayarla';

  @override
  String get p_custom_icons_description =>
      'Simge paketleri, hesaplarınızı tanıdık logolar ve renklerle daha kolay ayırt edilebilir hale getirebilir.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Simge paketleri $aegis_icon_pack formatını kullanır. Önceden hazırlanmış bir simge paketi indirebilir veya kendi simge paketinizi oluşturabilirsiniz.';
  }

  @override
  String get s_replace_icon_pack => 'Simge paketini değiştir';

  @override
  String get l_loading_icon_pack => 'Simge paketi yükleniyor…';

  @override
  String get s_load_icon_pack => 'Simge paketi yükle';

  @override
  String get s_remove_icon_pack => 'Simge paketini kaldır';

  @override
  String get l_icon_pack_removed => 'Simge paketi kaldırıldı';

  @override
  String get l_remove_icon_pack_failed =>
      'Simge paketi kaldırılırken hata oluştu';

  @override
  String get s_choose_icon_pack => 'Simge paketini seçin';

  @override
  String get l_icon_pack_imported => 'Simge paketi içe aktarıldı';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Simge paketi içe aktarılırken hata oluştu: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Geçersiz simge paketi';

  @override
  String get l_icon_pack_copy_failed =>
      'Simge paketi dosyaları kopyalanırken başarısız olundu';

  @override
  String get s_nfc_options => 'NFC seçenekleri';

  @override
  String get l_on_yk_nfc_tap => 'YubiKey NFC dokunuşunda';

  @override
  String get l_do_nothing => 'Hiçbir şey yapma';

  @override
  String get l_launch_ya => 'Yubico Kimlik Doğrulayıcısını başlatın';

  @override
  String get l_copy_otp_clipboard => 'OTP\'yi panoya kopyala';

  @override
  String get l_launch_and_copy_otp =>
      'Uygulamayı başlatın ve OTP\'yi kopyalayın';

  @override
  String get l_kbd_layout_for_static => 'Klavye düzeni (statik şifre için)';

  @override
  String get s_choose_kbd_layout => 'Klavye düzeni seçin';

  @override
  String get l_bypass_touch_requirement => 'Dokunma gereksinimi atla';

  @override
  String get l_bypass_touch_requirement_on =>
      'Dokunma gerektiren hesaplar otomatik olarak NFC üzerinden gösterilir';

  @override
  String get l_bypass_touch_requirement_off =>
      'Dokunma gerektiren hesaplar için NFC üzerinden ek bir dokunuşa ihtiyaç vardır';

  @override
  String get s_silence_nfc_sounds => 'NFC seslerini sustur';

  @override
  String get l_silence_nfc_sounds_on =>
      'NFC dokunuşunda hiçbir ses oynatılmayacaktır';

  @override
  String get l_silence_nfc_sounds_off => 'NFC dokunuşunda ses oynatılacaktır';

  @override
  String get s_usb_options => 'USB seçenekleri';

  @override
  String get l_launch_app_on_usb => 'YubiKey bağlandığında başlat';

  @override
  String get l_launch_app_on_usb_on =>
      'Bu, diğer uygulamaların USB üzerinden YubiKey\'i kullanmasını engeller';

  @override
  String get l_launch_app_on_usb_off =>
      'Diğer uygulamalar USB üzerinden YubiKey\'i kullanabilir';

  @override
  String get s_allow_screenshots => 'Ekran görüntülerine izin ver';

  @override
  String get s_nfc_ready_to_scan => 'Taramaya hazır';

  @override
  String get s_nfc_hold_still => 'Aynı yerde tutmaya devam edin…';

  @override
  String get s_nfc_tap_your_yubikey => 'YubiKey\'inize dokunun';

  @override
  String get l_nfc_failed_to_scan => 'Tarama başarısız, tekrar deneyin';

  @override
  String get s_usb_processing => 'YubiKey üzerinden veri okunuyor';

  @override
  String get s_usb_dont_remove => 'Anahtarı çıkarmayın…';

  @override
  String get l_usb_read_error =>
      'YubiKey üzerinden veri okunurken başarısız olundu';

  @override
  String get p_ndef_set_otp =>
      'OTP kodu, YubiKey\'den panoya başarıyla kopyalandı.';

  @override
  String get p_ndef_set_password =>
      'Şifre, YubiKey\'den panoya başarıyla kopyalandı.';

  @override
  String get p_ndef_parse_failure =>
      'YubiKey\'den OTP kodunun ayrıştırılmasında başarısız olundu.';

  @override
  String get p_ndef_set_clip_failure =>
      'YubiKey\'den OTP kodu kopyalamaya çalışırken panoya erişilemedi.';

  @override
  String get s_set_label => 'Etiket ayarla';

  @override
  String get s_set_color => 'Renk ayarla';

  @override
  String get s_change_label => 'Etiketi değiştir';

  @override
  String get p_set_will_add_custom_name =>
      'Bu, YubiKey\'inize özel bir ad verecektir.';

  @override
  String get p_rename_will_change_custom_name =>
      'Bu, YubiKey\'inizin etiketini değiştirecektir.';

  @override
  String get s_shortcuts => 'Shortcuts';

  @override
  String get s_keyboard_shortcuts => 'Keyboard shortcuts';

  @override
  String get s_global_shortcuts => 'Global shortcuts';

  @override
  String get s_application_shortcuts => 'Application shortcuts';

  @override
  String s_quit_app(String app) {
    return 'Quit $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Hide $app';
  }

  @override
  String get s_search => 'Search';

  @override
  String get s_next_device => 'Next device';

  @override
  String get s_previous_device => 'Previous device';

  @override
  String get s_open_settings => 'Open settings';

  @override
  String get s_open_help_and_about => 'Open help and about';

  @override
  String get s_open_item => 'Open item';

  @override
  String get s_edit_item => 'Edit item';

  @override
  String get s_delete_item => 'Delete item';

  @override
  String get s_calculate_oath_code => 'Calculate OATH code';

  @override
  String get s_open_keyboard_shortcuts => 'Open keyboard shortcuts';
}
