// GENERATED FILE. DO NOT EDIT.
//
// To edit this file modify the generator file `generator/update_package.dart` and
// re-generate.
// This file was generated 2025-05-24 10:34:05.888769 by the dart file
// `generator/update_package.dart`.
//
// Copyright 2025. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/// These data tables provide metadata for the Material Symbols icons.
///  The data was derived from the official Material Symbols metadata file
/// downloaded from `http://fonts.google.com/metadata/icons?incomplete=1&key=material_symbols`
/// 
library symbols;

import 'dart:convert';

/// This class represents the metadata for an icon in the Material Symbols collection.
class SymbolsMetadata {
  String? originalName;  // This is set if the icon was renamed from the original name (to create a valid Dart symbol name). Otherwise it is null.
  int popularity;
  int codepoint;
  List<int> categories;
  List<int> tags;
  bool rtlAutoMirrored = false; // Default to false
  List<int> codePointsFromCodePointsFiles = [];
  
  SymbolsMetadata(
      {
      this.originalName,
      required this.popularity,
      required this.codepoint,
      required this.categories,
      required this.tags,
      this.rtlAutoMirrored = false}); // Default to false

  factory SymbolsMetadata.fromJson(Map<String, dynamic> json) {
    return SymbolsMetadata(
      originalName: (json['originalName']!=null && json['originalName']!.isNotEmpty && json['originalName']!=json['name']) ? json['originalName'] : null,
      popularity: json['popularity'] ?? 0,
      codepoint: json['codepoint'] ?? 0,
      categories:
          (json['categories'] as List<dynamic>?)?.cast<int>() ?? [],
      tags: (json['tags'] as List<dynamic>?)?.cast<int>() ?? [],
      rtlAutoMirrored: json['rtlAutoMirrored'] ?? false,
    );
  }

  String toJson() {
    return json.encode({
      if(originalName!=null && originalName!.isNotEmpty) 'originalName': originalName!,
      if(rtlAutoMirrored) 'rtlAutoMirrored': rtlAutoMirrored,
      'popularity': popularity,
      'codepoint': codepoint,
      'categories': categories,
      'tags': tags,
    });
  }
}

/// List of all Categories - SymbolsMetadata() objects reference categories by their INDEX this table.
/// To get the category name, use `categoryMap[categoryIndexFromSymbolsMetadata]`
List<String> categoryMap = [
  "Audio&Video",
  "Images",
  "UI actions",
  "Social",
  "Android",
  "Maps",
  "Actions",
  "Communicate",
  "Household",
  "Business",
  "Home",
  "Hardware",
  "Text",
  "Privacy",
  "Transit",
  "Activities",
  "Travel",
];

/// List of all Tags - SymbolsMetadata() objects reference tags by their INDEX this table.
/// To get the tag name, use `tagMap[tagIndexFromSymbolsMetadata]`
List<String> tagMap = [
  "10000",
  "10K",
  "10k",
  "achievement",
  "alphabet",
  "analytics",
  "badge",
  "box",
  "character",
  "count",
  "data",
  "digit",
  "display",
  "followers",
  "font",
  "goal",
  "icon",
  "k",
  "label",
  "letters",
  "likes",
  "marker",
  "metric",
  "number",
  "numbers",
  "numeral",
  "pixel",
  "pixels",
  "progress",
  "quantity",
  "resolution",
  "social media",
  "square",
  "statistics",
  "subscribers",
  "symbol",
  "target",
  "ten thousand",
  "text",
  "thousand",
  "type",
  "video",
  "views",
  "10",
  "10 megapixel",
  "10 megapixels",
  "10mp",
  "camera",
  "camera icon",
  "camera settings",
  "digits",
  "high quality",
  "high resolution",
  "image",
  "image quality",
  "image resolution",
  "megapixel",
  "megapixels",
  "mp",
  "photo",
  "photo icon",
  "photography",
  "quality",
  "quality icon",
  "resolution icon",
  "settings",
  "settings icon",
  "video icon",
  "video resolution",
  "11",
  "11mp",
  "digital camera",
  "eleven megapixel",
  "photo quality",
  "picture resolution",
  "rectangle",
  "resolution settings",
  "rounded rectangle",
  "rounded square",
  "1",
  "123",
  "2",
  "3",
  "basic",
  "beginning",
  "cardinal",
  "counter",
  "counting",
  "digital",
  "elementary",
  "first",
  "index",
  "list",
  "numbering",
  "numerals",
  "one two three",
  "order",
  "ordinal",
  "organize",
  "prioritize",
  "queue",
  "rank",
  "rating",
  "second",
  "sequence",
  "simple",
  "sort",
  "stack",
  "start",
  "steps",
  "third",
  "12",
  "12 megapixel",
  "12mp",
  "camera resolution",
  "camera setting",
  "capture",
  "image size",
  "photo size",
  "picture",
  "picture size",
  "record",
  "sensor",
  "twelve",
  "13",
  "13mp",
  "lens",
  "thirteen megapixel",
  "14",
  "14 megapixel",
  "14mp",
  "camera spec",
  "details",
  "high quality image",
  "high quality photo",
  "information",
  "specification",
  "15",
  "15 megapixel",
  "15mp",
  "high-res",
  "photo resolution",
  "16",
  "16 megapixel",
  "16mp",
  "camera sensor",
  "sixteen",
  "17",
  "17mp",
  "camera quality",
  "picture quality",
  "seventeen megapixel",
  "18",
  "18+",
  "adult",
  "adults only",
  "age",
  "age limit",
  "age restriction",
  "content rating",
  "content warning",
  "eighteen",
  "eighteen plus",
  "explicit content",
  "mature",
  "no minors",
  "nsfw",
  "number in square",
  "over 18",
  "parental guidance",
  "pg-18",
  "restriction",
  "sensitive content",
  "under 18 not allowed",
  "x-rated",
  "18 megapixel",
  "18mp",
  "recording",
  "19",
  "19 megapixel",
  "19mp",
  "digital image",
  "photography icon",
  "1000",
  "1K",
  "1k",
  "abbreviation",
  "engagement",
  "indicator",
  "performance",
  "rounded corners",
  "total",
  "+",
  "1k plus",
  "community",
  "greater than one thousand",
  "growth",
  "influence",
  "milestone",
  "more than one thousand",
  "one thousand",
  "over one thousand",
  "plus",
  "popularity",
  "reach",
  "stats",
  "1x",
  "1x speed",
  "cellular",
  "cellular connection",
  "cellular data",
  "connection",
  "connectivity",
  "data connection",
  "data speed",
  "internet",
  "internet connection",
  "low signal",
  "low speed",
  "mobile",
  "mobile connectivity",
  "mobile network",
  "mobiledata",
  "network",
  "network speed",
  "one x",
  "phone",
  "signal",
  "signal strength",
  "slow",
  "slow connection",
  "speed",
  "weak signal",
  "wifi",
  "wireless",
  "wireless connection",
  "edge",
  "gprs",
  "internet speed",
  "limited connection",
  "mobile data connection",
  "mobile icon",
  "network status",
  "20",
  "20 megapixel",
  "20mp",
  "grid",
  "high quality picture",
  "resolution setting",
  "21",
  "21 megapixel",
  "21mp",
  "22",
  "22 megapixel",
  "22mp",
  "four squares",
  "hd",
  "high definition",
  "23",
  "23 megapixel",
  "23mp",
  "24 frames per second",
  "24fps",
  "30",
  "animation",
  "animation rate",
  "choose",
  "cinema",
  "configuration",
  "control",
  "film",
  "film settings",
  "film speed",
  "fps",
  "frame",
  "frame rate",
  "frames",
  "frequency",
  "movie",
  "movie player",
  "movie settings",
  "option",
  "per",
  "playback",
  "playback speed",
  "preference",
  "rate",
  "seconds",
  "select",
  "time",
  "timeline",
  "video player",
  "video settings",
  "video speed",
  "24",
  "24 megapixel",
  "24mp",
  "2d",
  "button",
  "design",
  "dimension",
  "dimensional",
  "drawing",
  "flat",
  "geometry",
  "graphics",
  "layout",
  "mode",
  "plane",
  "render",
  "setting",
  "shape",
  "surface",
  "switch",
  "toggle",
  "two",
  "two dimensional",
  "view",
  "1080p",
  "2000",
  "2048",
  "2048 x 1080",
  "2048p",
  "2K",
  "2k",
  "display settings",
  "media player",
  "monitor",
  "multimedia",
  "preferences",
  "screen",
  "screen resolution",
  "uhd",
  "ultra high definition",
  "video quality",
  "2k plus",
  "2k resolution",
  "download",
  "gaming",
  "greater than",
  "minimum",
  "more than",
  "streaming",
  "television",
  "tv",
  "two thousand",
  "upload",
  "2 megapixel",
  "2mp",
  "border",
  "cctv",
  "surveillance",
  "webcam",
  "30 frames per second",
  "30fps",
  "broadcast",
  "digital video",
  "fast motion",
  "frames per second",
  "high speed",
  "motion picture",
  "refresh rate",
  "slow motion",
  "time lapse",
  "video editing",
  "bars",
  "lines",
  "media",
  "media settings",
  "playback settings",
  "recording settings",
  "selection",
  "slider",
  "thirty",
  "three",
  "zero",
  "360",
  "all around",
  "angle",
  "ar",
  "arrow",
  "augmented reality",
  "av",
  "circle",
  "circular",
  "cycle",
  "cycling",
  "degree",
  "direction",
  "immersive",
  "loop",
  "looping",
  "panorama",
  "panoramic",
  "revolution",
  "revolve",
  "rotate",
  "rotation",
  "spherical",
  "spin",
  "spinning",
  "surround",
  "turn",
  "turning",
  "virtual reality",
  "vr",
  "3d",
  "D",
  "cube",
  "depth",
  "holographic",
  "model",
  "perspective",
  "spatial",
  "stereoscopic",
  "three dimensional",
  "three dimensions",
  "virtual_reality",
  "3d rotation",
  "arrows",
  "motion",
  "navigation",
  "object",
  "orbit",
  "refresh",
  "reload",
  "reset",
  "transform",
  "3g",
  "cellular network",
  "connection status",
  "generation three",
  "internet access",
  "mobile data",
  "mobile internet",
  "mobile technology",
  "network connection",
  "phone signal",
  "telecom",
  "telecommunication",
  "three bars",
  "three lines",
  "wireless network",
  "communication",
  "data indicator",
  "device",
  "smartphone",
  "tablet",
  "three g",
  "1440p",
  "2160p",
  "3000",
  "3000 pixels",
  "3K",
  "3k",
  "4k",
  "three thousand",
  "three thousand pixels",
  "amount",
  "limit",
  "statistic",
  "sum",
  "thousands",
  "value",
  "3 megapixel",
  "3mp",
  "medium resolution",
  "3p",
  "account",
  "alert",
  "avatar",
  "bubble",
  "chat",
  "comment",
  "communicate",
  "contact",
  "conversation",
  "dialog",
  "discussion",
  "face",
  "feedback",
  "forum",
  "help",
  "human",
  "info",
  "message",
  "notification",
  "party",
  "people",
  "person",
  "profile",
  "quote",
  "speak",
  "speech",
  "speech bubble",
  "support",
  "talk",
  "testimonial",
  "third person",
  "three people",
  "three person",
  "user",
  "4g",
  "4g lte",
  "broadband",
  "fourth generation",
  "high-speed",
  "lte",
  "reception",
  "4g+",
  "data plan",
  "enhanced 4g",
  "enhanced lte",
  "fast internet",
  "high speed data",
  "lte+",
  "mobile signal",
  "network signal",
  "4000",
  "4096p",
  "4K",
  "4k resolution",
  "four k",
  "ultra hd",
  "ultra high definition video",
  "4k+",
  "add",
  "better quality",
  "enhance",
  "feature",
  "improve",
  "premium",
  "subscription",
  "upgrade",
  "4",
  "4 megapixel",
  "4 megapixels",
  "4mp",
  "four",
  "four megapixel",
  "video recording",
  "50",
  "50 megapixel",
  "50mp",
  "clarity",
  "detail",
  "5g",
  "5g icon",
  "5g symbol",
  "five g",
  "network icon",
  "technology",
  "5g network",
  "status",
  "5000",
  "5K",
  "5k",
  "5k display",
  "5k resolution",
  "5k video",
  "five k",
  "5k plus",
  "five thousand",
  "threshold",
  "5",
  "5 megapixel",
  "5mp",
  "video setting",
  "60",
  "60fps",
  "high frame rate",
  "high performance",
  "sixty",
  "smooth motion",
  "video game",
  "chosen",
  "high refresh rate",
  "sixty fps",
  "video option",
  "video playback",
  "6",
  "6 feet",
  "6ft apart",
  "apart",
  "body",
  "coronavirus",
  "covid",
  "covid-19",
  "distance",
  "distancing",
  "feet",
  "figures",
  "ft",
  "gap",
  "guidelines",
  "health",
  "infection control",
  "measure",
  "pandemic",
  "prevention",
  "regulation",
  "rule",
  "safety",
  "sars-cov-2",
  "separation",
  "six feet",
  "six ft apart",
  "social",
  "social distancing",
  "space",
  "two figures",
  "two people",
  "6000",
  "6K",
  "6k",
  "6k resolution",
  "6k video",
  "8k",
  "monitor settings",
  "6k plus",
  "six k",
  "six k plus",
  "six thousand",
  "6 megapixel",
  "6 megapixels",
  "6mp",
  "7000",
  "7K",
  "7k",
  "seven k",
  "seven thousand",
  "7k resolution",
  "7k video",
  "kilo",
  "measurement",
  "unit",
  "7",
  "7 megapixel",
  "7 megapixels",
  "7mp",
  "number 7",
  "seven",
  "4320p",
  "8000",
  "8K",
  "8k video",
  "sharpness",
  "super high resolution",
  "video format",
  "8k plus icon",
  "8k resolution",
  "8k ultra hd",
  "8k+",
  "display resolution",
  "enhanced",
  "k plus",
  "options",
  "video options",
  "8",
  "8 megapixel",
  "8mp",
  "eight",
  "letters mp",
  "number 8",
  "9 kilobytes",
  "9000",
  "9K",
  "9k",
  "definition",
  "kilobytes",
  "nine k",
  "nine kilobytes",
  "nine thousand",
  "size",
  "storage",
  "9 thousand",
  "9k resolution",
  "9",
  "9 megapixel",
  "9 megapixels",
  "9mp",
  "digital photography",
  "nine",
  "number nine",
  "8-bit",
  "a",
  "abc",
  "acronym",
  "arcade",
  "b",
  "block letters",
  "c",
  "characters",
  "compose",
  "computer",
  "digital text",
  "edit",
  "game",
  "initialism",
  "monospace",
  "pixel font",
  "retro",
  "typography",
  "vintage",
  "writing",
  "ac",
  "ac unit",
  "air",
  "air conditioner",
  "air conditioning",
  "arctic",
  "chill",
  "climate",
  "climate control",
  "cold",
  "conditioner",
  "conditioning",
  "cool",
  "cooling",
  "fan",
  "flake",
  "freeze",
  "frosty",
  "hvac",
  "ice",
  "snow",
  "snowflake",
  "temperature",
  "temperature control",
  "thermostat",
  "ventilation",
  "weather",
  "winter",
  "accessibility",
  "accessible",
  "ada",
  "aid",
  "arms outstretched",
  "assistance",
  "assistive technology",
  "barrier-free",
  "disability",
  "diversity",
  "equal access",
  "handicap",
  "human figure",
  "impairment",
  "inclusion",
  "inclusive design",
  "section 508",
  "stick figure",
  "t-shape",
  "universal access",
  "wcag",
  "abstract person",
  "access",
  "accessibility new",
  "aoda",
  "assistive",
  "impaired",
  "inclusive",
  "inclusiveness",
  "inclusivity",
  "new",
  "open arms",
  "outstretched arms",
  "welcome",
  "disabled",
  "handicapped",
  "impaired mobility",
  "mobility",
  "person in wheelchair",
  "sitting",
  "wheel",
  "wheelchair",
  "advance",
  "continue",
  "forward",
  "move",
  "navigate",
  "next",
  "proceed",
  "right arrow",
  "a11y",
  "accessible design",
  "controls",
  "ellipsis",
  "expand",
  "menu",
  "more",
  "personal",
  "three dots",
  "user interface",
  "account balance",
  "balance",
  "bank",
  "banking",
  "bill",
  "building",
  "card",
  "cash",
  "coin",
  "columns",
  "commerce",
  "courthouse",
  "credit",
  "currency",
  "dollars",
  "finance",
  "financial",
  "financial institution",
  "funds",
  "government",
  "government building",
  "institution",
  "investment",
  "law",
  "legal",
  "money",
  "online",
  "pay",
  "payment",
  "pillars",
  "roof",
  "savings",
  "savings account",
  "three pillars",
  "billfold",
  "budget",
  "credit card",
  "debit card",
  "digital wallet",
  "dot",
  "e-wallet",
  "expenses",
  "flap",
  "online payment",
  "personal finance",
  "pocketbook",
  "pouch",
  "purchase",
  "shopping",
  "transaction",
  "wallet",
  "account box",
  "account settings",
  "bust",
  "contact information",
  "contacts",
  "head and shoulders",
  "identity",
  "inbox",
  "login",
  "member",
  "portrait",
  "profile settings",
  "registration",
  "signup",
  "thumbnail",
  "user information",
  "user profile",
  "add child",
  "child",
  "child account",
  "child profile",
  "children",
  "dependent",
  "family",
  "family account",
  "guardian",
  "kid",
  "kids",
  "manage child",
  "minor",
  "parent",
  "parental control",
  "parenting",
  "supervision",
  "under 18",
  "young",
  "youth",
  "invert",
  "underaged",
  "young person",
  "account circle",
  "individual",
  "my account",
  "person circle",
  "personal information",
  "round",
  "user account",
  "user circle",
  "access denied",
  "account disabled",
  "blocked",
  "cancel",
  "deactivate",
  "delete",
  "enabled",
  "forbidden",
  "hide",
  "inactive",
  "log out",
  "logout",
  "no account",
  "no profile",
  "no user",
  "off",
  "offline",
  "on",
  "profile disabled",
  "remove",
  "restricted",
  "sign out",
  "slash",
  "unavailable",
  "user disabled",
  "account tree",
  "blocks",
  "branches",
  "chart",
  "connect",
  "connected",
  "descendants",
  "diagram",
  "family tree",
  "flow",
  "flow chart",
  "genealogy",
  "graph",
  "group",
  "grouping",
  "hierarchy",
  "infographic",
  "levels",
  "link",
  "management",
  "metrics",
  "nested",
  "nodes",
  "organization",
  "organization chart",
  "process",
  "sitemap",
  "squares",
  "structure",
  "team",
  "tracking",
  "tree",
  "action",
  "action key",
  "activate",
  "buttons",
  "circles",
  "command",
  "discover",
  "dots",
  "execute",
  "explore",
  "filter",
  "find",
  "four circles",
  "four rings",
  "function",
  "glass",
  "hardware",
  "input",
  "investigate",
  "key",
  "keyboard",
  "keypad",
  "look",
  "lookup",
  "magnifier",
  "magnify",
  "magnifying",
  "magnifying glass",
  "operation",
  "perform",
  "query",
  "search",
  "see",
  "shortcut",
  "three circles",
  "three rings",
  "trigger",
  "zoom",
  "active area",
  "active zone",
  "activity",
  "activity ",
  "activity area",
  "activity zone",
  "area",
  "boundary",
  "contained area",
  "designated area",
  "four corners",
  "four points",
  "home",
  "linked",
  "location",
  "map",
  "mapping",
  "nest",
  "network zone",
  "perimeter",
  "range",
  "region",
  "restricted area",
  "scope",
  "security",
  "select area",
  "zone",
  "acute",
  "appointment",
  "clock",
  "date",
  "deadline",
  "delivery",
  "duration",
  "express",
  "fast",
  "history",
  "immediate",
  "instance",
  "occurrence",
  "quick",
  "rapid",
  "recent",
  "reminder",
  "schedule",
  "short-term",
  "timer",
  "urgent",
  "ad",
  "advert",
  "advertisement",
  "banner",
  "browser",
  "campaign",
  "commercial",
  "content",
  "digital marketing",
  "insert",
  "marketing",
  "online advertising",
  "paid content",
  "placeholder",
  "pop-up",
  "promotion",
  "sponsored",
  "web advertising",
  "website",
  "window",
  "ad group",
  "ads",
  "append",
  "attach",
  "audience",
  "banner multiple",
  "combine",
  "corner",
  "demographics",
  "join",
  "layered",
  "layers",
  "merge",
  "pane",
  "stacked",
  "tab",
  "targeting",
  "Ads",
  "advertising",
  "block",
  "cancelled",
  "deactivated",
  "disable",
  "hidden",
  "no ads",
  "no promotion",
  "overlay",
  "pause",
  "stop",
  "windows",
  "ad block",
  "ad blocker",
  "ad break off",
  "ad disabled",
  "ad_off",
  "advertisement disabled",
  "advertisement off",
  "advertising off",
  "block ad",
  "block advertisement",
  "disable ad",
  "disable ads",
  "disable advertisement",
  "hide ad",
  "hide advertisement",
  "no advertisement",
  "no advertising",
  "remove ad",
  "remove advertisement",
  "stop ad",
  "stop advertisement",
  "stop advertising",
  "turn off ads",
  "turn off advertisement",
  "Android",
  "OS",
  "ad management",
  "ad unit",
  "cell",
  "iOS",
  "message ad",
  "minus",
  "mobile ad",
  "mobile marketing",
  "mobile text ad",
  "notifications",
  "sms",
  "subtract",
  "text ad",
  "top",
  "units",
  "accounts",
  "adaptive",
  "adjust",
  "audio",
  "audio mesh",
  "auto",
  "automatic",
  "call",
  "committee",
  "conference",
  "dictation",
  "friends",
  "google meet",
  "hear",
  "hearing",
  "humans",
  "interview",
  "listen",
  "meet",
  "meeting",
  "mic",
  "microphone",
  "noise",
  "noise cancelling",
  "noise reduction",
  "persons",
  "podcast",
  "profiles",
  "recorder",
  "smart",
  "sound",
  "speaker",
  "transcription",
  "users",
  "video call",
  "voice",
  "voice chat",
  "adaptive audio",
  "mute",
  "muted",
  "no audio",
  "no mic",
  "no microphone",
  "no sound",
  "silence",
  "silent",
  "speaking",
  "video conference",
  "adb",
  "android",
  "android debug bridge",
  "android icon",
  "android logo",
  "android robot",
  "antenna",
  "app development",
  "bridge",
  "bugdroid",
  "debug",
  "debugging",
  "developer",
  "development tools",
  "eyes",
  "google",
  "head",
  "mobile development",
  "operating system",
  "os",
  "platform",
  "robot",
  "software",
  "addition",
  "arithmetic",
  "calculate",
  "center point",
  "create",
  "cross",
  "four way",
  "grow",
  "horizontal line",
  "include",
  "increase",
  "intersecting lines",
  "intersection",
  "math",
  "new symbol",
  "plus sign",
  "positive",
  "two lines",
  "vertical line",
  "enlarge",
  "increment",
  "intersect",
  "a photo",
  "add image",
  "add photo",
  "add picture",
  "add symbol",
  "image icon",
  "picture icon",
  "add ad",
  "add advertisement",
  "add page",
  "app",
  "application",
  "create ad",
  "create page",
  "digital ad",
  "new ad",
  "new advertisement",
  "new page",
  "online ad",
  "plus ad",
  "web ad",
  "web page",
  "webpage",
  "active",
  "add notification",
  "alarm",
  "announcement",
  "bell",
  "bell plus",
  "chime",
  "create alert",
  "follow",
  "important",
  "new alert",
  "notification bell",
  "notify",
  "plus bell",
  "register",
  "ring",
  "subscribe",
  "subscribe to alerts",
  "update",
  "warning",
  "add box",
  "add container",
  "add item",
  "add square",
  "add to collection",
  "add to list",
  "append item",
  "container",
  "create container",
  "create new",
  "include item",
  "insert item",
  "new box",
  "new item",
  "new square",
  "plus box",
  "plus square",
  "add business",
  "add company",
  "add shop",
  "add store",
  "awning",
  "business",
  "company",
  "create business",
  "create company",
  "create shop",
  "create store",
  "local business",
  "market",
  "marketplace",
  "new business",
  "new shop",
  "new store",
  "retail",
  "shop",
  "store",
  "storefront",
  "vendor",
  "add call",
  "add participant",
  "add phone",
  "add to call",
  "communication plus",
  "conference call",
  "create call",
  "dial",
  "handset",
  "initiate call",
  "invite",
  "join call",
  "join conference",
  "merge call",
  "new call",
  "phone plus",
  "plus phone",
  "receiver",
  "start call",
  "telephone",
  "add credit card",
  "add debit card",
  "add payment",
  "attach card",
  "billing",
  "checkout",
  "cost",
  "credit card details",
  "ecommerce",
  "include card",
  "insert card",
  "link card",
  "new card",
  "new payment",
  "payment details",
  "payment method",
  "price",
  "register card",
  "add bar chart",
  "add chart",
  "add document",
  "add graph",
  "bar",
  "bar chart",
  "bar graph",
  "create chart",
  "document",
  "insert chart",
  "new chart",
  "new document",
  "plus chart",
  "plus graph",
  "report",
  "reporting",
  "visualization",
  "add circle",
  "add new",
  "circle plus",
  "circles add",
  "control point",
  "outline",
  "plus circle",
  "point",
  "unknown",
  "add column",
  "add left",
  "arrange",
  "column",
  "column left",
  "divide",
  "editor",
  "format",
  "insert column",
  "insert left",
  "left",
  "rows",
  "section",
  "split",
  "spreadsheet",
  "table",
  "vertical",
  "add right",
  "add section",
  "column right",
  "expand grid",
  "expand layout",
  "grid layout",
  "increase grid",
  "increase layout",
  "insert right",
  "layout grid",
  "new column",
  "new section",
  "plus column",
  "plus right",
  "right",
  "section layout",
  "table grid",
  "add message",
  "blog",
  "chat bubble",
  "create comment",
  "create message",
  "insert comment",
  "insert message",
  "message bubble",
  "new comment",
  "new message",
  "post",
  "reply",
  "respond",
  "submit",
  "45 degrees",
  "add diamond",
  "create diamond",
  "diamond",
  "diamond shape",
  "gem",
  "insert diamond",
  "new diamond",
  "rhombus",
  "rotated diamond",
  "rotated square",
  "tilted square",
  "add address",
  "add home",
  "add property",
  "add residence",
  "address",
  "create home",
  "create house",
  "create property",
  "domestic",
  "dwelling",
  "house",
  "household",
  "new home",
  "new house",
  "new property",
  "new residence",
  "plus home",
  "plus house",
  "primary residence",
  "property",
  "real estate",
  "residence",
  "set home",
  "add building",
  "add house",
  "add work",
  "create building",
  "create work",
  "homework",
  "new building",
  "new work",
  "office",
  "plus building",
  "plus work",
  "work",
  "workplace",
  "add connection",
  "add link",
  "add url",
  "add website",
  "attach link",
  "attachment",
  "chain",
  "chain link",
  "clip",
  "create link",
  "external link",
  "hyperlink",
  "insert hyperlink",
  "insert link",
  "link icon",
  "new connection",
  "new link",
  "plus link",
  "url",
  "web link",
  "add location",
  "add marker",
  "current location",
  "destination",
  "drop pin",
  "geolocation",
  "geotag",
  "gps",
  "locate",
  "maps",
  "mark location",
  "new location",
  "pin",
  "pinpoint",
  "place",
  "position",
  "save location",
  "set location",
  "alt",
  "drop",
  "itinerary",
  "plus location",
  "route",
  "travel",
  "add moderator",
  "add user",
  "admin",
  "administrator",
  "assign",
  "certified",
  "grant",
  "moderator",
  "new moderator",
  "permission",
  "plus shield",
  "privacy",
  "private",
  "promote",
  "protect",
  "protection",
  "role",
  "shield",
  "verified",
  "add note",
  "compose note",
  "create document",
  "create note",
  "doc",
  "edit note",
  "file",
  "new note",
  "note",
  "notes",
  "page",
  "paper",
  "write",
  "write note",
  "album",
  "alternate",
  "contribute",
  "gallery",
  "import",
  "landscape",
  "mountain",
  "mountains",
  "scenery",
  "add reaction",
  "agree",
  "approve",
  "emoji",
  "emoticon",
  "emotion",
  "emotions",
  "expressions",
  "feelings",
  "glad",
  "happiness",
  "happy",
  "icons",
  "like",
  "mood",
  "new reaction",
  "pleased",
  "reaction",
  "response",
  "sentiment",
  "smile",
  "smiley",
  "smiling",
  "survey",
  "add destination",
  "add path",
  "add route",
  "add street",
  "create road",
  "create route",
  "dashed line",
  "directions",
  "dotted line",
  "highway",
  "journey",
  "new path",
  "new road",
  "new route",
  "new street",
  "path",
  "road",
  "route planning",
  "street",
  "traffic",
  "trip",
  "vertical lines",
  "above",
  "add above",
  "add line",
  "add row",
  "entry",
  "form",
  "insert above",
  "insert line",
  "insert row",
  "line",
  "row",
  "spreadsheet row",
  "table row",
  "add below",
  "data grid",
  "insert below",
  "line below",
  "new line",
  "new row",
  "row below",
  "add to basket",
  "add to cart",
  "add to shopping cart",
  "basket",
  "basket plus",
  "buy",
  "cart",
  "item",
  "online shopping",
  "product",
  "purchase item",
  "shopping cart plus",
  "trolley",
  "trolley plus",
  "accept",
  "add task",
  "assign task",
  "check",
  "checklist",
  "checkmark",
  "complete",
  "complete task",
  "completed",
  "confirm",
  "confirm task",
  "create task",
  "done",
  "finish",
  "mark",
  "new task",
  "ok",
  "project management",
  "task",
  "task management",
  "tick",
  "to do",
  "to-do",
  "yes",
  "backup",
  "cloud",
  "cloud upload",
  "drive",
  "files",
  "folder",
  "folders",
  "gdrive",
  "geometric",
  "google drive",
  "hexagon",
  "polygon",
  "recovery",
  "save",
  "share",
  "six sides",
  "sync",
  "add to",
  "add to home screen",
  "bookmark",
  "diagonal arrow",
  "export",
  "fullscreen",
  "install",
  "mobile device",
  "up",
  "up arrow",
  "add movie",
  "add program",
  "add to playlist",
  "add to queue",
  "add to watchlist",
  "add video",
  "chrome",
  "desktop",
  "enqueue",
  "mac",
  "task list",
  "to",
  "watch later",
  "web",
  "add triangle",
  "caution",
  "delta",
  "mid trip",
  "obstacle",
  "plus triangle",
  "pyramid",
  "slowdown",
  "three sides",
  "triangle",
  "triangle add",
  "triangle plus",
  "trigon",
  "adf",
  "all-in-one",
  "copy",
  "copy machine",
  "digitize",
  "document scanner",
  "electronics",
  "fax",
  "fax machine",
  "feeder",
  "flatbed scanner",
  "image scanner",
  "machine",
  "multifunction",
  "output",
  "peripherals",
  "print",
  "printer",
  "scan",
  "scanner",
  "accuracy",
  "alter",
  "auto click",
  "brightness",
  "calibrate",
  "center",
  "change",
  "concentric circles",
  "configure",
  "contrast",
  "customize",
  "dials",
  "fix",
  "focus",
  "knobs",
  "modify",
  "precision",
  "refinement",
  "sliders",
  "tune",
  "volume",
  "administer",
  "administration",
  "capsule",
  "clinic",
  "clipboard",
  "doctor",
  "drugs",
  "healthcare",
  "hospital",
  "manage",
  "med",
  "medical",
  "medical record",
  "medication",
  "medicine",
  "nurse",
  "patient",
  "pharmacy",
  "pill",
  "prescription",
  "rx",
  "admin settings",
  "authentication",
  "authorization",
  "panel",
  "pentagon",
  "safe",
  "secure",
  "user settings",
  "bullseye",
  "click",
  "clicks",
  "conversion",
  "cost per click",
  "cpc",
  "cursor",
  "pay per click",
  "pointer",
  "ppc",
  "propagation",
  "rings",
  "ripple",
  "agender",
  "combined symbol",
  "female",
  "gender",
  "gender expression",
  "gender identity",
  "gender neutrality",
  "gender symbol",
  "genderfree",
  "genderless",
  "genderqueer",
  "lgbt",
  "lgbtq",
  "lgbtq+",
  "lgbtqia",
  "male",
  "neutral",
  "neutrois",
  "no gender",
  "non-binary",
  "pride",
  "sexless",
  "without gender",
  "agricultural machinery",
  "agriculture",
  "agriculture icon",
  "automobile",
  "car",
  "cars",
  "countryside",
  "countryside icon",
  "crop",
  "cultivate",
  "cultivation",
  "farm",
  "farm equipment",
  "farmer",
  "farming",
  "farming icon",
  "field",
  "field icon",
  "food",
  "grow icon",
  "harvest",
  "harvest icon",
  "land",
  "machinery",
  "plant",
  "plant icon",
  "produce",
  "rural",
  "soil",
  "tractor",
  "tractor icon",
  "transport",
  "truck",
  "vehicle",
  "aerodynamics",
  "airflow",
  "atmosphere",
  "blow",
  "blowing",
  "breeze",
  "current",
  "curves",
  "draft",
  "gas",
  "gust",
  "invisible",
  "meteorology",
  "movement",
  "nature",
  "outdoor",
  "swirls",
  "wave",
  "wind",
  "aerosol",
  "air freshener",
  "air purifier",
  "aroma",
  "bathroom",
  "bottle",
  "bottler",
  "clean",
  "deodorant",
  "dispenser",
  "fragrance",
  "fragrance diffuser",
  "fresh",
  "mist",
  "odor",
  "perfume",
  "room spray",
  "scent",
  "smell",
  "spray",
  "spray bottle",
  "toilet",
  "air flow",
  "air quality",
  "appliance",
  "cleaner",
  "environment",
  "filtration",
  "fresh air",
  "freshener",
  "healthy air",
  "home appliance",
  "internet of things",
  "iot",
  "pure air",
  "purifier",
  "purify",
  "smart home",
  "waves",
  "air cleaning",
  "humidity",
  "wellness",
  "aircraft",
  "airline",
  "airplane seat",
  "bed",
  "book",
  "business class",
  "chair",
  "class",
  "comfort",
  "cushion",
  "first class",
  "flight",
  "fly",
  "headrest",
  "legroom",
  "lie flat",
  "passenger",
  "recline",
  "reservation",
  "rest",
  "seat",
  "seat selection",
  "select seat",
  "sleep",
  "transportation",
  "airline seat",
  "airplane",
  "angled",
  "angled seat",
  "aviation",
  "booking",
  "economy",
  "flat seat",
  "aisle seat",
  "amenity",
  "armrest",
  "check-in",
  "compartment",
  "luxury",
  "pod",
  "reclined seat",
  "single seat",
  "suite",
  "window seat",
  "aeroplane",
  "extra",
  "extra legroom",
  "extra space",
  "foot",
  "leg",
  "more space",
  "reclining",
  "relax",
  "relaxation",
  "room",
  "sit",
  "spacious",
  "travel comfort",
  "furniture",
  "leg space",
  "normal",
  "pictogram",
  "standard",
  "basic economy",
  "cramped",
  "crowded",
  "discomfort",
  "flying",
  "knee room",
  "limited",
  "no legroom",
  "personal space",
  "reduced",
  "small",
  "tight",
  "travel planning",
  "uncomfortable",
  "adjustable seat",
  "extra recline",
  "lean back",
  "reclining seat",
  "choose seat",
  "flight settings",
  "person sitting",
  "seat adjustment",
  "travel settings",
  "upright",
  "airline stops",
  "branch",
  "connecting flights",
  "curved line",
  "detour",
  "divert",
  "flight stops",
  "fork",
  "indirect",
  "layover",
  "layovers",
  "multiple stops",
  "stops",
  "straight line",
  "transfer",
  "transit",
  "two paths",
  "air travel",
  "airlines",
  "airplanes",
  "airport",
  "arrival",
  "cockpit",
  "departure",
  "flights",
  "holiday",
  "parallelogram",
  "planes",
  "porthole",
  "ticket",
  "tourism",
  "vacation",
  "airplane ticket",
  "boarding",
  "boarding pass",
  "pass",
  "plane icon",
  "travel document",
  "airplane disabled",
  "airplane inactive",
  "airplane mode",
  "airplane mode off",
  "bluetooth off",
  "cellular off",
  "disconnected",
  "flight disabled",
  "flight mode",
  "flight mode off",
  "network off",
  "no airplane mode",
  "no connection",
  "no flight",
  "no signal",
  "offline mode",
  "radio off",
  "signals off",
  "wifi off",
  "wireless off",
  "airplay",
  "arrow up",
  "cast",
  "external display",
  "projector",
  "screen mirroring",
  "stream",
  "streaming media",
  "wireless display",
  "airport shuttle",
  "airport transfer",
  "bus",
  "commute",
  "drop off",
  "four wheels",
  "ground transportation",
  "hotel shuttle",
  "mini",
  "minivan",
  "pick up",
  "public",
  "ride",
  "shuttle",
  "side view",
  "two windows",
  "van",
  "airware",
  "airwave",
  "curved lines",
  "horizontal lines",
  "music",
  "oscillation",
  "radio",
  "signals",
  "transmission",
  "vibration",
  "access alarms",
  "access_alarm",
  "access_alarms",
  "alarms",
  "bells",
  "countdown",
  "due date",
  "event",
  "hour",
  "minute",
  "morning",
  "ringing",
  "time management",
  "wake",
  "wake up",
  "watch",
  "add alarm",
  "add time",
  "create alarm",
  "new alarm",
  "planning",
  "set alarm",
  "alarm cancelled",
  "alarm disabled",
  "alarm inactive",
  "alarm off",
  "bell off",
  "bell silenced",
  "cancel alarm",
  "clock disabled",
  "clock off",
  "deactivate alarm",
  "disable alarm",
  "mute alarm",
  "no alarm",
  "notification off",
  "quiet",
  "reminder off",
  "silence alarm",
  "strikethrough",
  "time off",
  "timer off",
  "turn off alarm",
  "alarm active",
  "alarm clock",
  "alarm on",
  "alarm set",
  "scheduled",
  "bedside",
  "break",
  "delay",
  "double lines",
  "hold",
  "interrupt",
  "pause button",
  "postpone",
  "resume",
  "snooze",
  "temporary stop",
  "two bars",
  "wait",
  "automation",
  "intelligent",
  "smart alarm",
  "archive",
  "artist",
  "bvb",
  "cd",
  "collection",
  "disc",
  "disk",
  "gramophone",
  "library",
  "lp",
  "phonograph",
  "play",
  "playlist",
  "song",
  "track",
  "vinyl",
  "align",
  "align center",
  "alignment",
  "arrangement",
  "center align",
  "content alignment",
  "distribute",
  "equal",
  "formatting",
  "horizontal",
  "horizontal alignment",
  "justify",
  "middle",
  "paragraph",
  "rules",
  "style",
  "text alignment",
  "text edit",
  "word processing",
  "align end",
  "align right",
  "bottom",
  "end",
  "flush right",
  "horizontal align",
  "justify end",
  "justify right",
  "right align",
  "right alignment",
  "text align",
  "text right",
  "vertical align",
  "vertical alignment",
  "crosshair",
  "equidistant",
  "flex",
  "flexible",
  "justify center",
  "midpoint",
  "symmetry",
  "align bottom",
  "align to bottom",
  "bottom alignment",
  "distribution",
  "flex end",
  "flexbox",
  "align items",
  "align top",
  "flex start",
  "justify content",
  "justify start",
  "justify top",
  "text top",
  "top align",
  "top left",
  "word processor",
  "content organization",
  "document formatting",
  "justify left",
  "left align",
  "page layout",
  "paragraph alignment",
  "text editor",
  "text formatting",
  "text left",
  "arrange right",
  "horizontal align right",
  "horizontal alignment right",
  "move right",
  "right justified",
  "shift right",
  "side",
  "align_items",
  "equal height",
  "equal width",
  "fit",
  "full height",
  "full width",
  "items",
  "justification",
  "resize",
  "spacing",
  "stretch",
  "equal spacing",
  "three columns",
  "three rectangles",
  "vertical bars",
  "flex-end",
  "justify-content",
  "text-align-right",
  "paragraph formatting",
  "rectangles",
  "space around",
  "edges",
  "horizontal spacing",
  "margins",
  "padding",
  "separate",
  "space between",
  "text justify",
  "text spacing",
  "vertical spacing",
  "even",
  "justify space even",
  "typesetting",
  "content editing",
  "fit to width",
  "text justification",
  "text stretch",
  "adapt",
  "align self",
  "content fitting",
  "fill",
  "responsive",
  "scale",
  "self stretch",
  "vertical stretch",
  "around",
  "horizontal distribution",
  "horizontal space",
  "paragraph spacing",
  "vertical distribution",
  "vertical space",
  "equal distance",
  "horizontal distribute",
  "justify space",
  "organize horizontally",
  "parallel",
  "parallel lines",
  "three horizontal lines",
  "align left",
  "align start",
  "editing",
  "16:9",
  "aspect ratio",
  "capital h",
  "h",
  "horizontal scale",
  "horizontal stretch",
  "letterbox",
  "maximize",
  "pillarbox",
  "widescreen",
  "arrange vertical",
  "baseline",
  "bottom align",
  "bottom justification",
  "justify bottom",
  "lower",
  "vertical bottom",
  "vertical justification",
  "centering",
  "equilibrium",
  "vertical center",
  "align vertical",
  "column alignment",
  "text layout",
  "Inbox",
  "all",
  "all inbox",
  "archive all",
  "collect",
  "collect all",
  "combined",
  "correspondence",
  "curve",
  "delivered",
  "download all",
  "email",
  "gather",
  "gather all",
  "incoming",
  "integrated",
  "mail",
  "messages",
  "receive",
  "send",
  "tray",
  "unified",
  "all inclusive",
  "boundless",
  "circulation",
  "continuous",
  "endless",
  "eternity",
  "everything",
  "figure eight",
  "forever",
  "included",
  "infinite",
  "infinity",
  "limitless",
  "mobius",
  "mobius strip",
  "neverending",
  "no limits",
  "ongoing",
  "package deal",
  "perpetual",
  "recurring",
  "repeat",
  "ribbon",
  "strip",
  "sustainability",
  "sustainable",
  "unending",
  "unlimited",
  "all match",
  "calculation",
  "correct",
  "equation",
  "formula",
  "match",
  "mathematics",
  "select all",
  "sigma",
  "summation",
  "tag",
  "valid",
  "validate",
  "validation",
  "verification",
  "verify",
  "all out",
  "corners",
  "expand outwards",
  "fit to screen",
  "fit to window",
  "full screen",
  "increase size",
  "make bigger",
  "out",
  "outwards",
  "presentation",
  "scale up",
  "windowed mode",
  "zoom in",
  "zoom out",
  "allergen",
  "allergic",
  "allergies",
  "allergy",
  "antibodies",
  "antibody",
  "antibody test",
  "biology",
  "diagnosis",
  "disease",
  "health condition",
  "illness",
  "immune",
  "immune system",
  "immunoglobulin",
  "immunology",
  "intolerance",
  "pollen",
  "protein",
  "science",
  "sensitivity",
  "sickness",
  "symptom",
  "treatment",
  "y-shaped",
  "airway",
  "asthma",
  "dust",
  "flower",
  "inflammation",
  "irritation",
  "respiratory",
  "spores",
  "spread",
  "spring",
  "alt_route",
  "alternate route",
  "alternative",
  "alternative route",
  "arrow fork",
  "arrow split",
  "branching arrows",
  "choice",
  "dash",
  "dashed",
  "double arrow",
  "other",
  "reroute",
  "route change",
  "routes",
  "two arrows",
  "way",
  "@",
  "alternate email",
  "at sign",
  "at symbol",
  "electronic mail",
  "secondary email",
  "spiral",
  "adventure",
  "altitude",
  "ascend",
  "climb",
  "elevation",
  "geography",
  "height",
  "high",
  "level",
  "level up",
  "peak",
  "rise",
  "sea",
  "terrain",
  "topography",
  "ambulance",
  "approved",
  "confirmed",
  "emergency",
  "emergency lights",
  "lights",
  "siren",
  "sos",
  "success",
  "amend",
  "back",
  "circular arrow",
  "document edit",
  "redo",
  "refine",
  "renew",
  "return",
  "revert",
  "revise",
  "underline",
  "undo",
  "amp",
  "article",
  "feed",
  "news",
  "publish",
  "publishing",
  "read",
  "reading",
  "sidebars",
  "stories",
  "story",
  "trio",
  "viewing",
  "analysis",
  "assessment",
  "dashboard",
  "insights",
  "key performance indicator",
  "kpi",
  "visualize",
  "anchor",
  "boat",
  "dock",
  "equipment",
  "fastener",
  "fixed",
  "harbor",
  "hook",
  "logo",
  "marine",
  "maritime",
  "mooring",
  "nautical",
  "ocean",
  "port",
  "ship",
  "stability",
  "tool",
  "bot",
  "brand",
  "humanoid",
  "mascot",
  "semicircle",
  "toy",
  "animated gif",
  "animated_images",
  "cinemagraph",
  "dynamic",
  "frame animation",
  "gemini",
  "generate",
  "gif",
  "gifs",
  "image carousel",
  "image sequence",
  "moving image",
  "moving picture",
  "multiple",
  "multiple images",
  "overlapping",
  "prints",
  "short video",
  "slideshow",
  "videos",
  "animated",
  "buffer",
  "concentric",
  "effect",
  "loading",
  "rotating",
  "series",
  "transition",
  "visual effect",
  "always",
  "always on display",
  "aod",
  "cellphone",
  "content display",
  "homescreen",
  "mobile content",
  "mobile info",
  "mobile message",
  "mobile notification",
  "mobile text",
  "borders",
  "portable",
  "stripes",
  "accessory",
  "band",
  "digital watch",
  "gadget",
  "smartwatch",
  "strap",
  "tracker",
  "wearable",
  "wearable tech",
  "wearables",
  "wrist",
  "wristwatch",
  "accommodation",
  "apartment",
  "architecture",
  "city",
  "condominium",
  "door",
  "estate",
  "high rise",
  "hotel",
  "housing",
  "lease",
  "lodging",
  "motel",
  "multi-story",
  "places",
  "real",
  "rental",
  "residential",
  "shelter",
  "skyscraper",
  "three sections",
  "tower",
  "urban",
  "api",
  "application programming interface",
  "code",
  "development",
  "enterprise",
  "exchange",
  "external",
  "integration",
  "programming",
  "service",
  "system",
  "android application",
  "android document",
  "android file",
  "android package",
  "android setup",
  "android software",
  "apk",
  "apk document",
  "apk file",
  "app download",
  "app install",
  "installation",
  "mobile app",
  "mobile software",
  "package",
  "program",
  "setup",
  "arrow down",
  "down",
  "get",
  "open",
  "alerts",
  "app badge",
  "app icon",
  "apps",
  "badging",
  "incomplete",
  "new messages",
  "notification badge",
  "notification icon",
  "reminder icon",
  "unread",
  "unread messages",
  "updates available",
  "app block",
  "app management",
  "app security",
  "blocking",
  "device block",
  "device lock",
  "device management",
  "lock",
  "mobile block",
  "mobile management",
  "mobile security",
  "no access",
  "no mobile",
  "no phone",
  "no symbol",
  "phone lock",
  "prohibition",
  "stopped",
  "app registration",
  "app settings",
  "apply",
  "create account",
  "edit app",
  "enroll",
  "enrollment",
  "new account",
  "pen",
  "pencil",
  "personalize",
  "sign up",
  "apparel",
  "attire",
  "blouse",
  "casual",
  "clothes",
  "clothing",
  "cotton",
  "fabric",
  "fashion",
  "garment",
  "outfit",
  "shirt",
  "short sleeves",
  "sleeve",
  "t-shirt",
  "tee",
  "textile",
  "wardrobe",
  "wear",
  "acceptance",
  "approval",
  "approvals",
  "certificate",
  "certification",
  "checkpoint",
  "disapproval",
  "dropoff",
  "impression",
  "ink",
  "location tag",
  "postage",
  "stamp",
  "submission",
  "authority",
  "authorize",
  "delegation",
  "empowerment",
  "fingers",
  "gesture",
  "give",
  "giving",
  "hand",
  "handoff",
  "handover",
  "hands",
  "offer",
  "palm",
  "responsibility",
  "trust",
  "workflow",
  "app drawer",
  "app store",
  "applications",
  "components",
  "interface",
  "launcher",
  "matrix",
  "programs",
  "services",
  "tools",
  "ui",
  "utilities",
  "ux",
  "app launcher",
  "app menu",
  "application error",
  "application outage",
  "apps down",
  "crash",
  "error",
  "exclamation",
  "failure",
  "issue",
  "maintenance",
  "outage",
  "problem",
  "service unavailable",
  "system error",
  "a and q",
  "aq",
  "bismuth",
  "bold",
  "branding",
  "initials",
  "letter a",
  "letter q",
  "monogram",
  "pollutants",
  "pollution",
  "sans serif",
  "text icon",
  "two letters",
  "uppercase",
  "fluid",
  "house icon",
  "iaq",
  "indoor",
  "indoor air quality",
  "inside",
  "interior",
  "leak",
  "liquid",
  "moisture",
  "plumbing",
  "water",
  "waves icon",
  "ar_on_you",
  "detect",
  "detection",
  "face recognition",
  "face tracking",
  "facial recognition",
  "identification",
  "identify",
  "image capture",
  "scanning",
  "selfie",
  "viewfinder",
  "you",
  "ar location",
  "ar object",
  "ar sticker placement",
  "fun",
  "placement",
  "playful",
  "playground",
  "reality",
  "sticker",
  "stickers",
  "virtual",
  "arc",
  "architect",
  "art",
  "blueprint",
  "compass",
  "construction",
  "drafting",
  "draw",
  "engineering",
  "instrument",
  "mechanical",
  "plan",
  "technical",
  "down arrow",
  "past",
  "put away",
  "repository",
  "retrieve",
  "area chart",
  "area graph",
  "data visualization",
  "line graph",
  "mountain chart",
  "polygon chart",
  "results",
  "trend",
  "arming",
  "defense",
  "enable",
  "guard",
  "initialization",
  "pending",
  "preparing",
  "starting",
  "branched",
  "chevron",
  "inbound",
  "inverted y",
  "pathway",
  "DISABLE_IOS",
  "arrow back",
  "arrow left",
  "back arrow",
  "backward",
  "caret",
  "disable_ios",
  "go back",
  "last",
  "left arrow",
  "previous",
  "previous page",
  "prior",
  "retrace",
  "return arrow",
  "reverse",
  "site",
  "arrowhead",
  "earlier",
  "last page",
  "rewind",
  "step back",
  "ios",
  "angled lines",
  "angular",
  "arrow circle",
  "arrow in circle",
  "caret circle",
  "caret in circle",
  "circled arrow",
  "collapse",
  "download icon",
  "move down",
  "scroll",
  "scroll down",
  "back button",
  "circle arrow",
  "media control",
  "player",
  "previous button",
  "previous track",
  "clockwise",
  "clockwise rotation",
  "enter",
  "go",
  "right arrow in circle",
  "rotate right",
  "sign in",
  "back to top",
  "scroll up",
  "upward",
  "upwards",
  "breathe",
  "contract",
  "cool down",
  "cool off",
  "decrease",
  "descending",
  "downward",
  "exercise",
  "fitbit",
  "fitness",
  "minimize",
  "point down",
  "reduce",
  "routine",
  "running",
  "shrink",
  "slow down",
  "south",
  "three squares",
  "descend",
  "drop down",
  "triangle down",
  "below",
  "dropdown",
  "under",
  "arrowhead down",
  "caret down",
  "drop down arrow",
  "dropdown arrow",
  "expand more",
  "reveal",
  "unfold",
  "close",
  "drop-down menu",
  "dropdown menu",
  "expand menu",
  "arrow drop up",
  "drop up",
  "expand up",
  "higher",
  "move up",
  "arrow forward",
  "arrow head",
  "direction indicator",
  "following",
  "angle bracket",
  "apple",
  "arrow forward ios",
  "skip",
  "subsequent",
  "arrow insert",
  "diagonal",
  "embed",
  "ingress",
  "northwest",
  "leftward",
  "move left",
  "turn left",
  "arrow left alt",
  "directional arrow",
  "retreat",
  "shift left",
  "arrow and line",
  "close panel",
  "collapse menu",
  "drawer",
  "drawer close",
  "exit",
  "hamburger",
  "hide menu",
  "menu close",
  "minimize menu",
  "nav",
  "panel close",
  "retract",
  "sidebar",
  "sidebar close",
  "disclose",
  "extend",
  "show",
  "double down arrow",
  "duplicate",
  "pair",
  "pull",
  "two down arrows",
  "new window",
  "outward",
  "back and forth",
  "between",
  "drag",
  "forth",
  "length",
  "opposite arrows",
  "opposite direction",
  "push",
  "shorten",
  "width",
  "arrow right alt",
  "east",
  "pointing",
  "right direction",
  "highlight",
  "mouse",
  "pick",
  "picker",
  "polyline",
  "sharp",
  "vector",
  "branching",
  "decision",
  "diverge",
  "diverging",
  "pathways",
  "two-way",
  "variant",
  "arrow left up",
  "arrow top left",
  "backwards",
  "shift",
  "up left",
  "upstairs",
  "west",
  "arrow icon",
  "arrow top right",
  "bend",
  "direction icon",
  "minimalist arrow",
  "navigation icon",
  "right angle",
  "simple arrow",
  "top right",
  "contributing",
  "data transfer",
  "exporting",
  "file transfer",
  "incomplete circle",
  "loading indicator",
  "pie chart",
  "progress indicator",
  "sending",
  "sharing",
  "submitting",
  "transferring",
  "uploading",
  "uploads",
  "available",
  "deploy",
  "finished",
  "online upload",
  "ready",
  "release",
  "upload ready",
  "north",
  "arrow upward alternative",
  "upward arrow alt",
  "attention",
  "boot",
  "exclamation point",
  "heat",
  "heating up",
  "hot",
  "initialize",
  "launch",
  "preparation",
  "warm up",
  "warmth",
  "warmup",
  "centralize",
  "compress",
  "consolidate",
  "converge",
  "four arrows",
  "fullscreen exit",
  "in",
  "inward",
  "scale down",
  "window resize",
  "cascade",
  "expand all",
  "overflow",
  "reveal all",
  "show all",
  "two ls",
  "disclosure",
  "expand section",
  "show more",
  "explode",
  "angle brackets",
  "arrow out",
  "arrows outward",
  "double",
  "expand outward",
  "widen",
  "art track",
  "tracks",
  "digital document",
  "text document",
  "assignment",
  "author",
  "contributor",
  "membership",
  "owner",
  "writer",
  "curved arrow",
  "query reference",
  "quick access",
  "reference",
  "artist profile",
  "composer",
  "content creator",
  "creator",
  "music account",
  "music creator",
  "music library",
  "music note",
  "music profile",
  "musical",
  "musical artist",
  "musician",
  "my music",
  "performer",
  "personal music",
  "singer",
  "user music",
  "4:3",
  "aspect",
  "display ratio",
  "image editing",
  "image ratio",
  "orientation",
  "proportions",
  "ratio",
  "screen ratio",
  "screen settings",
  "screen size",
  "education",
  "exam",
  "notepad",
  "project",
  "quiz",
  "school",
  "tasks",
  "test",
  "to do list",
  "request",
  "assign user",
  "assignment card",
  "delegate",
  "employee",
  "id",
  "id card",
  "ind",
  "job",
  "person card",
  "person icon",
  "profile card",
  "user assignment",
  "!",
  "danger",
  "exclamation mark",
  "late",
  "missed",
  "overdue",
  "correction",
  "grading",
  "retun",
  "review",
  "send back",
  "give back",
  "hand in",
  "returned",
  "turn in",
  "assignment complete",
  "finished task",
  "submit assignment",
  "turned in",
  "aged",
  "aging",
  "assist",
  "eldercare",
  "elderly",
  "independence",
  "injured",
  "injury",
  "mobility device",
  "rehabilitation",
  "rolling walker",
  "senior",
  "walk",
  "walker",
  "walking aid",
  "zimmer frame",
  "IoT",
  "ai",
  "artificial intelligence",
  "assistant",
  "assistant device",
  "digital assistant",
  "electronic",
  "home assistant",
  "home device",
  "smart speaker",
  "virtual assistant",
  "voice assistant",
  "voice control",
  "assistant direction",
  "direction assistant",
  "guidance",
  "guide",
  "right turn",
  "routing",
  "wayfinding",
  "straight",
  "ai assistant",
  "assistant on hub",
  "console",
  "control panel",
  "home automation",
  "hub",
  "smart device",
  "smart hub",
  "assured",
  "assured workload",
  "compliance",
  "confidential",
  "data integrity",
  "data protection",
  "data security",
  "enterprise security",
  "federal",
  "regulatory compliance",
  "risk management",
  "secure data",
  "secure workload",
  "sensitive regulatory",
  "workload",
  "annotation",
  "asterisk",
  "eight-pointed asterisk",
  "eight-pointed star",
  "emphasis",
  "footnote",
  "multiplication",
  "multiply",
  "operator",
  "special character",
  "star",
  "times",
  "wildcard",
  "atm",
  "automated",
  "automated teller machine",
  "automatic teller machine",
  "bank machine",
  "banking machine",
  "cash machine",
  "deposit",
  "money machine",
  "pixelated",
  "teller",
  "teller machine",
  "withdrawal",
  "atr",
  "collaboration",
  "node",
  "attach document",
  "attach file",
  "email attachment",
  "envelop",
  "new mail",
  "outbox",
  "paperclip",
  "add attachment",
  "add file",
  "clip file",
  "insert file",
  "link file",
  "pinned",
  "stationery",
  "upload file",
  "attach page",
  "clip add",
  "link plus",
  "paperclip plus",
  "crossed out",
  "detach",
  "diagonal line",
  "disable attachment",
  "disconnect",
  "no attachments",
  "no file",
  "remove attachment",
  "restrict",
  "unattach",
  "unlink",
  "accounting",
  "contribution",
  "dollar",
  "donate",
  "earnings",
  "expense",
  "fund",
  "income",
  "monetization",
  "sell",
  "usd",
  "wealth",
  "abstract",
  "curved",
  "element",
  "graphic",
  "minimal",
  "oblong",
  "rounded",
  "amusement",
  "amusement park",
  "attractions",
  "cabins",
  "carnival",
  "entertainment",
  "fair",
  "ferris",
  "ferris wheel",
  "festival",
  "gondolas",
  "landmark",
  "leisure",
  "park",
  "pods",
  "recreation",
  "sightseeing",
  "accreditation",
  "acknowledge",
  "attribute",
  "attribution",
  "cc attribution",
  "citation",
  "cite",
  "contained",
  "copyright",
  "copywriter",
  "creative commons",
  "enclosed",
  "license",
  "origin",
  "ownership",
  "source",
  "youtube",
  "youtube attribution",
  "alt text",
  "alternative text",
  "audio description",
  "blind",
  "descriptive",
  "descriptive audio",
  "documentary",
  "e-learning",
  "learning",
  "narrated",
  "narration",
  "screen reader",
  "script",
  "sound waves",
  "spoken text",
  "tv show",
  "visually impaired",
  "voiceover",
  "aiff",
  "audio content",
  "audio document",
  "audio file",
  "audio track",
  "mp3",
  "music content",
  "music document",
  "music file",
  "musical note",
  "sheet music",
  "sound content",
  "sound document",
  "sound file",
  "sound recording",
  "wav",
  "amplifier",
  "audio receiver",
  "av equipment",
  "av receiver",
  "avr",
  "hi-fi",
  "home theater",
  "knob",
  "renderer",
  "sound system",
  "stereo",
  "theater",
  "tuner",
  "video receiver",
  "auto awesome",
  "awesome",
  "collage",
  "composition",
  "framework",
  "mosaic",
  "panels",
  "photo editing",
  "sections",
  "segments",
  "side by side",
  "tiles",
  "two panels",
  "cinematography",
  "enhancement",
  "auto-delete",
  "automated deletion",
  "autoremove",
  "bin",
  "can",
  "cleanup",
  "clear",
  "dispose",
  "erase",
  "garbage",
  "purge",
  "scheduled deletion",
  "temp",
  "temporary",
  "trash",
  "trash can",
  "auto read pause",
  "auto-read pause",
  "halt",
  "interruption",
  "auto play",
  "auto read",
  "autoplay",
  "begin",
  "play arrow",
  "chapter",
  "content creation",
  "creation",
  "diary",
  "flipping",
  "generated",
  "journal",
  "literature",
  "open book",
  "pages",
  "storytelling",
  "accident",
  "automotive",
  "breakdown",
  "broken down",
  "crane",
  "garage",
  "lift",
  "removal",
  "repair",
  "roadside",
  "roadside assistance",
  "tow",
  "tow truck",
  "towing",
  "vehicle recovery",
  "wrecker",
  "automatic transmission",
  "clutch",
  "driving",
  "gear",
  "gearbox",
  "gears",
  "h-pattern",
  "handle",
  "manual transmission",
  "mechanism",
  "shifter",
  "stick",
  "stick shift",
  "A",
  "optimize",
  "smooth",
  "algorithm",
  "automations",
  "efficiency",
  "flowchart",
  "intelligence",
  "machine learning",
  "magic",
  "pipeline",
  "productivity",
  "robotics",
  "workspace",
  "auto-pause",
  "automatic pause",
  "autopause",
  "broken circle",
  "load",
  "player controls",
  "replay",
  "restart",
  "two vertical lines",
  "succession",
  "uninterrupted",
  "autorenew",
  "cache",
  "cached",
  "counterclockwise",
  "inprogress",
  "loading refresh",
  "refresh page",
  "reload page",
  "retry",
  "synchronize",
  "autostop",
  "cease",
  "repeating",
  "alliance for open media",
  "aom",
  "av1",
  "codec",
  "compression",
  "decoding",
  "encoding",
  "file format",
  "movies",
  "one",
  "open source",
  "royalty-free",
  "video codec",
  "video compression",
  "av_timer",
  "minutes",
  "stopwatch",
  "advanced video coding",
  "avc",
  "h.264",
  "mpeg-4",
  "three letters",
  "video encoding",
  "video file format",
  "average",
  "average pace",
  "avg pace",
  "gauge",
  "meter",
  "needle",
  "pace",
  "speedometer",
  "tempo",
  "average duration",
  "average time",
  "avg time",
  "heartbeat",
  "pulse",
  "sine wave",
  "variability",
  "accomplishment",
  "award",
  "best",
  "champion",
  "emblem",
  "favorite",
  "guarantee",
  "octagon",
  "prize",
  "ranking",
  "recognition",
  "reward",
  "seal",
  "special",
  "star in octagon",
  "victory",
  "winner",
  "active zone minutes",
  "azm",
  "chevrons",
  "double chevron",
  "modern",
  "sports",
  "workout",
  "amenities",
  "babies",
  "baby",
  "care",
  "changing",
  "childcare",
  "diaper",
  "facilities",
  "father",
  "infant",
  "mother",
  "nappy",
  "newborn",
  "restroom",
  "station",
  "toddler",
  "wc",
  "backhand",
  "dismiss",
  "four fingers",
  "hand gesture",
  "move back",
  "raised",
  "return to previous",
  "app navigation",
  "back to tab",
  "change tab",
  "new tab",
  "open tab",
  "return to previous tab",
  "switch tab",
  "tab navigation",
  "web navigation",
  "background",
  "background option",
  "background setting",
  "four dots",
  "large",
  "pattern",
  "texture",
  "tile",
  "array",
  "cells",
  "dotted",
  "points",
  "small dots",
  "4x4",
  "background grid",
  "background pattern",
  "grid pattern",
  "small grid",
  "small squares",
  "square grid",
  "tile pattern",
  "account background",
  "backdrop",
  "backdrop replacement",
  "change background",
  "customize background",
  "diagonal lines",
  "edit background",
  "image background",
  "photo background",
  "profile background",
  "remove background",
  "replace",
  "scene",
  "swap background",
  "user background",
  "adjust brightness",
  "backlight",
  "backlit",
  "beam",
  "bright",
  "brilliance",
  "display brightness",
  "full brightness",
  "glow",
  "high brightness",
  "illuminate",
  "illumination",
  "increase brightness",
  "intense light",
  "light",
  "maximum brightness",
  "mobile settings",
  "radiant",
  "rays",
  "screen brightness",
  "sun",
  "sunshine",
  "backlight off",
  "brightness off",
  "dark",
  "dim",
  "disable backlight",
  "disable brightness",
  "high backlight",
  "monitor brightness",
  "negative",
  "no backlight",
  "no brightness",
  "shine",
  "turn off backlight",
  "turn off brightness",
  "brightness control",
  "brightness level",
  "brightness setting",
  "device brightness",
  "diamonds",
  "dimmed",
  "display dim",
  "laptop brightness",
  "low backlight",
  "low brightness",
  "low illumination",
  "low light",
  "phone brightness",
  "reduce brightness",
  "screen dim",
  "tablet brightness",
  "backpack",
  "bag",
  "belongings",
  "bookbag",
  "camping",
  "carry",
  "hiking",
  "knapsack",
  "luggage",
  "outdoors",
  "pack",
  "rucksack",
  "student",
  "backspace",
  "character delete",
  "text field",
  "text input",
  "typing",
  "x",
  "archiving",
  "cloud backup",
  "cloud computing",
  "cloud icon",
  "cloud storage",
  "data backup",
  "data safety",
  "data storage",
  "file storage",
  "files folders",
  "online storage",
  "recover",
  "restore",
  "synchronization",
  "bracket",
  "business continuity",
  "clone",
  "data management",
  "data recovery",
  "database",
  "database backup",
  "disaster recovery",
  "l shape",
  "retrieval",
  "server",
  "table backup",
  "credentials",
  "name",
  "name tag",
  "permit",
  "staff",
  "visitor",
  "battery",
  "battery indicator",
  "battery level",
  "battery life",
  "charge",
  "charging",
  "critical",
  "critical battery",
  "critical power",
  "empty battery",
  "energy",
  "low battery",
  "low power",
  "power",
  "power source",
  "very low battery",
  "bake",
  "baked goods",
  "bakery",
  "bakery dining",
  "bread",
  "breakfast",
  "brunch",
  "cafe",
  "chef",
  "clam",
  "cook",
  "croissant",
  "dessert",
  "dine in",
  "dining",
  "eat",
  "eat in",
  "kitchen",
  "lunch",
  "meal",
  "oven",
  "pastry",
  "restaurant",
  "shell",
  "snack",
  "sweet",
  "analyze",
  "compare",
  "comparison",
  "compromise",
  "court",
  "courtroom",
  "equality",
  "equity",
  "evaluate",
  "fairness",
  "impartiality",
  "judgment",
  "justice",
  "parity",
  "pros and cons",
  "scales",
  "stability. equilibrium",
  "steadiness",
  "tradeoff",
  "unbiased",
  "weight",
  "arched window",
  "balcony",
  "balustrade",
  "deck",
  "doors",
  "double doors",
  "exterior",
  "french doors",
  "open air",
  "outside",
  "patio",
  "porch",
  "railing",
  "scenic",
  "stay",
  "terrace",
  "veranda",
  "ballot",
  "ballot box",
  "bullet",
  "checkboxes",
  "election",
  "poll",
  "vote",
  "voting",
  "sales",
  "trending",
  "4 bars",
  "four bars",
  "health dashboard",
  "health metric dashboard",
  "health monitoring",
  "histogram",
  "oxygen",
  "analytics off",
  "bar chart disabled",
  "bar graph disabled",
  "cancel chart",
  "cancel graph",
  "chart disabled",
  "chart off",
  "data off",
  "data visualization off",
  "disable chart",
  "disable graph",
  "graph disabled",
  "graph off",
  "hide chart",
  "hide graph",
  "measurement off",
  "metrics off",
  "no chart",
  "no graph",
  "remove chart",
  "remove graph",
  "reporting off",
  "statistics off",
  "turn off chart",
  "turn off graph",
  "visualization off",
  "barcode",
  "ean",
  "grocery",
  "inventory",
  "logistics",
  "product code",
  "sale",
  "supply chain",
  "universal product code",
  "upc",
  "warehouse",
  "barcode reader",
  "barcode scanner",
  "handheld",
  "laser",
  "qr code",
  "reader",
  "brackets",
  "code reader",
  "point of sale",
  "pos",
  "price check",
  "price scanner",
  "product scanner",
  "qr code scanner",
  "scan code",
  "square brackets",
  "anatomy",
  "bare",
  "bare foot",
  "barefoot",
  "beach",
  "footmark",
  "footprint",
  "footprint outline",
  "footstep",
  "footsteps",
  "ground",
  "hike",
  "imprint",
  "podiatry",
  "sand",
  "sole",
  "step",
  "toes",
  "trace",
  "trail",
  "walking",
  "batch",
  "batch prediction",
  "bulb",
  "computation",
  "idea",
  "insight",
  "lightbulb",
  "predict",
  "prediction",
  "processing",
  "bath",
  "bathe",
  "bathhouse",
  "bathing",
  "geothermal",
  "hot spring",
  "hot springs",
  "hot tub",
  "japan",
  "japanese",
  "mineral bath",
  "onsen",
  "pool",
  "rocks",
  "sauna",
  "soak",
  "spa",
  "steam",
  "stones",
  "tub",
  "bathtub",
  "couple",
  "hygiene",
  "jacuzzi",
  "personal care",
  "shared bath",
  "steam lines",
  "steam room",
  "warm",
  "comfort station",
  "communal bath",
  "group bath",
  "lavatory",
  "public bath",
  "public restroom",
  "sento",
  "washroom",
  "water closet",
  "accessible restroom",
  "closet",
  "faucet",
  "gender neutral restroom",
  "latrine",
  "loo",
  "men's room",
  "powder room",
  "privy",
  "rounded top",
  "shower",
  "sink",
  "sprinkler",
  "wash",
  "wash closet",
  "women's room",
  "basin",
  "cleaning",
  "hot water",
  "sanitary",
  "tap",
  "battery_0",
  "battery_empty",
  "dead",
  "dead_battery",
  "empty",
  "low",
  "low_battery",
  "low_power",
  "no_charge",
  "no_power",
  "20%",
  "battery low",
  "charge level",
  "one bar",
  "power saving",
  "2 bars",
  "30 percent",
  "30%",
  "battery charging",
  "battery status",
  "portable device",
  "status bar icon",
  "thirty percent",
  "50 percent",
  "half charged",
  "half full",
  "medium battery",
  "power management",
  "status bar",
  "system status",
  "three segments",
  "3/4",
  "60%",
  "almost full",
  "full",
  "medium",
  "moderate",
  "sixty percent",
  "three quarters",
  "80%",
  "electricity",
  "five bars",
  "high battery",
  "laptop",
  "90%",
  "capacity",
  "nearly full",
  "six bars",
  "battery alert",
  "battery_android_0",
  "dead battery",
  "android battery",
  "full battery",
  "system icon",
  "android 2",
  "75%",
  "three out of four",
  "mobile battery",
  "phone battery",
  "power level",
  "power status",
  "battery icon",
  "power icon",
  "rectangle with bar",
  "alert symbol",
  "cell phone",
  "energy saving",
  "bolt",
  "charge status",
  "electric",
  "fast charging",
  "flash",
  "full charge",
  "instant",
  "lightning",
  "power supply",
  "quick charge",
  "thunderbolt",
  "battery full",
  "charge indicator",
  "charged",
  "full energy",
  "power indicator",
  "battery plus",
  "boost",
  "saver",
  "?",
  "battery health",
  "battery information",
  "battery unknown",
  "information needed",
  "missing",
  "punctuation",
  "question",
  "question mark",
  "battery share",
  "battery sharing",
  "charge sharing",
  "energy transfer",
  "external battery",
  "portable charger",
  "power transfer",
  "reverse charging",
  "send power",
  "transfer power",
  "wireless power sharing",
  "battery management",
  "battery optimization",
  "battery protected",
  "battery saver",
  "battery security",
  "defend",
  "endurance",
  "long life",
  "low power mode",
  "power saving mode",
  "safe battery",
  "battery change",
  "battery replacement",
  "battery swap",
  "battery symbol",
  "change battery",
  "lightning bolt",
  "new battery",
  "replace battery",
  "surge",
  "swap battery",
  "charging symbol",
  "twenty percent",
  "partial",
  "plugin",
  "power up",
  "mid charge",
  "percentage",
  "charging battery",
  "eighty percent",
  "ninety percent",
  "battery critical",
  "battery error",
  "battery failure",
  "battery issue",
  "battery problem",
  "charging error",
  "no",
  "power error",
  "power issue",
  "full power",
  "energy indicator",
  "full bar",
  "0%",
  "no charge",
  "50%",
  "medium charge",
  "75 percent",
  "almost empty",
  "add battery",
  "add sign",
  "battery boost",
  "battery top up",
  "extend battery",
  "increase battery",
  "more battery",
  "more power",
  "top up",
  "battery profile",
  "battery settings",
  "cog",
  "cogwheel",
  "energy management",
  "energy settings",
  "mechanics",
  "power settings",
  "conserve battery",
  "device settings",
  "energy saver",
  "optimize battery",
  "power save",
  "save battery",
  "outgoing",
  "power bank",
  "wireless charging",
  "battery charged",
  "battery good",
  "good",
  "status indicator",
  "vertical rectangle",
  "device status",
  "status unknown",
  "unknown level",
  "beach umbrella",
  "beach_access",
  "coast",
  "parasol",
  "resort",
  "seaside",
  "shade",
  "shoreline",
  "summer",
  "sun protection",
  "sunny",
  "sunshade",
  "umbrella",
  "bedroom",
  "bedtime",
  "blanket",
  "double bed",
  "dream",
  "guest room",
  "hospitality",
  "king",
  "mattress",
  "night",
  "overnight",
  "pillow",
  "pillows",
  "queen",
  "twin bed",
  "bassinet",
  "cot",
  "crib",
  "horse",
  "nursery",
  "rocking",
  "rocking horse",
  "bunk bed",
  "child's room",
  "kids room",
  "nap",
  "twin",
  "headboard",
  "master bedroom",
  "parents",
  "sizem master",
  "after dark",
  "astronomy",
  "celestial",
  "clear night",
  "crescent",
  "crescent moon",
  "dnd",
  "do not disturb",
  "dusk",
  "evening",
  "lunar",
  "moon",
  "night mode",
  "nightime",
  "nighttime",
  "quiet time",
  "shhh",
  "sleep mode",
  "twilight",
  "bedtime mode",
  "concentration",
  "downtime",
  "focus mode",
  "quiet mode",
  "time out",
  "beenhere",
  "completion",
  "confirmation",
  "remember",
  "saved",
  "visited",
  "bento",
  "compartments",
  "dinner",
  "divided",
  "food container",
  "lunchbox",
  "meal prep",
  "picnic",
  "portable meal",
  "school lunch",
  "takeaway",
  "takeout",
  "work lunch",
  "bia",
  "bodies",
  "body composition",
  "bone",
  "business intelligence",
  "data analysis",
  "discovery",
  "fat",
  "inspect",
  "muscle",
  "bid",
  "fusion table",
  "zigzag",
  "bidding disabled",
  "landscape disabled",
  "landscape off",
  "no bidding",
  "no landscape",
  "bigtop",
  "bigtop updates",
  "concentric arcs",
  "transmitter",
  "updates",
  "arch",
  "base",
  "bicycle",
  "bike",
  "bike parking",
  "bike rack",
  "bike rental",
  "bike share",
  "bike stand",
  "docking station",
  "parking",
  "pillar",
  "rack",
  "slot",
  "stand",
  "bike lane",
  "commuting",
  "cyclist",
  "lane",
  "permitted",
  "protected",
  "e-scooter",
  "electric scooter",
  "handlebars",
  "kick scooter",
  "micro mobility",
  "moped",
  "motorbike",
  "motorcycle",
  "personal transport",
  "scooter",
  "two wheels",
  "urban mobility",
  "vespa",
  "wheels",
  "biochemistry",
  "biotech",
  "biotechnology",
  "chemistry",
  "experiment",
  "genetics",
  "investigation",
  "lab equipment",
  "laboratory",
  "life science",
  "microbiology",
  "microorganism",
  "microscope",
  "molecule",
  "pharmaceutical",
  "research",
  "scientific instrument",
  "scientific research",
  "cable",
  "connector",
  "cord",
  "cover",
  "electric cable",
  "electric cord",
  "electric plug",
  "electric wire",
  "outlet",
  "plug",
  "plug in",
  "power cable",
  "power cord",
  "recharge",
  "socket",
  "throw",
  "wire",
  "wrap",
  "appliance icon",
  "beverage",
  "blade",
  "blend",
  "blender",
  "chop",
  "cooking",
  "crush",
  "drink",
  "food icon",
  "food preparation",
  "food processor",
  "jug",
  "juice",
  "juicer",
  "kitchen tool",
  "kitchenware",
  "liquefy",
  "milkshake",
  "mix",
  "motor",
  "puree",
  "smoothie",
  "vitamix",
  "blind person",
  "blindness",
  "cane",
  "disability access",
  "figure",
  "impaired vision",
  "low vision",
  "sightless",
  "visual aid",
  "walking cane",
  "walking stick",
  "white cane",
  "blinds",
  "curtains",
  "interior design",
  "lever",
  "light control",
  "roller blinds",
  "shutter",
  "venetian blinds",
  "window blinds",
  "window covering",
  "window shade",
  "window treatment",
  "closed",
  "horizontal blinds",
  "mini blinds",
  "room darkening",
  "shut",
  "slatted blinds",
  "window dressing",
  "avoid",
  "circle with line",
  "circle with slash",
  "crossed out circle",
  "decline",
  "denied",
  "disturb",
  "do disturb",
  "ignore",
  "not allowed",
  "not interested",
  "opt out",
  "prohibit",
  "prohibited",
  "quit",
  "reject",
  "blood pressure",
  "cardiology",
  "diagnostics",
  "health data",
  "heart",
  "hypertension",
  "hypotension",
  "monitoring",
  "pressure",
  "sphygmomanometer",
  "vital signs",
  "vitals",
  "blood",
  "blood donation",
  "blood drop",
  "blood group",
  "blood test",
  "blood type",
  "bloodtype",
  "donation",
  "droplet",
  "first aid",
  "health record",
  "lab",
  "result",
  "transfusion",
  "bluetooth",
  "bluetooth icon",
  "networking",
  "paired",
  "pairing",
  "pan",
  "paring",
  "personal area network",
  "short-range",
  "unpaired",
  "wireless technology",
  "b symbol",
  "bluetooth connected",
  "headphones",
  "rune",
  "two dots",
  "x shape",
  "bluetooth disabled",
  "bluetooth logo",
  "bluetooth symbol",
  "connection disabled",
  "connection icon",
  "connection off",
  "device disabled",
  "device off",
  "network disabled",
  "no bluetooth",
  "nordic",
  "pairing disabled",
  "pairing off",
  "sync disabled",
  "sync off",
  "wireless disabled",
  "wireless icon",
  "bluetooth car",
  "bluetooth connection",
  "car bluetooth",
  "connected car",
  "in-car entertainment",
  "road trip",
  "smart car",
  "vehicle connection",
  "wireless automotive",
  "wireless car",
  "audio connection",
  "bluetooth audio",
  "bluetooth searching",
  "find device",
  "searching",
  "wireless audio",
  "wireless headphones",
  "blur",
  "blur circular",
  "bokeh",
  "defocus",
  "diffuse",
  "distortion",
  "image adjustment",
  "image effect",
  "optics",
  "out of focus",
  "radial blur",
  "scattered",
  "soften",
  "unfocus",
  "blur linear",
  "fade",
  "gradient",
  "linear",
  "motion blur",
  "photo effect",
  "picture edit",
  "row of circles",
  "three rows",
  "blurring",
  "gaussian blur",
  "image blur",
  "image filter",
  "medium blur",
  "photo blur",
  "photo filter",
  "soft focus",
  "unfocused",
  "anti blur",
  "blur off",
  "cancel blur",
  "cross out",
  "defocus off",
  "disable blur",
  "image correction",
  "image enhancement",
  "no blur",
  "out of focus off",
  "photo correction",
  "photo enhancement",
  "picture correction",
  "picture editing",
  "picture enhancement",
  "remove blur",
  "restore sharpness",
  "sharpen",
  "unblur",
  "blur on",
  "blurry",
  "dispersion",
  "raster",
  "vision",
  "adjust blur",
  "blur tool",
  "editing tool",
  "fast blur",
  "photo adjustment",
  "quick blur",
  "short",
  "special effect",
  "toggle blur",
  "aquatic",
  "boat icon",
  "boat trip",
  "bus icon",
  "cruise",
  "excursion",
  "ferry",
  "marine transport",
  "public transport",
  "river bus",
  "sea bus",
  "shipping",
  "voyage",
  "water bus",
  "water taxi",
  "water travel",
  "waterfront",
  "canal",
  "cargo",
  "crossing",
  "engine",
  "freight",
  "lake",
  "locomotive",
  "monorail",
  "rail",
  "railway",
  "river",
  "subway",
  "train",
  "tram",
  "bmi",
  "body fat",
  "body fat caliper",
  "body fat measurement",
  "body fat percentage",
  "body fat scale",
  "body fat tracker",
  "body mass index",
  "caliper",
  "fat percentage",
  "fitness tracker",
  "human body",
  "measurement tool",
  "physical health",
  "pinch",
  "skinfold",
  "wellness tracker",
  "body system",
  "full body",
  "holistic",
  "organs",
  "physiology",
  "wellbeing",
  "hazard",
  "high voltage",
  "shock",
  "storm",
  "strike",
  "thunderstorm",
  "voltage",
  "zap",
  "atomic",
  "attack",
  "blast",
  "blasts",
  "bomb",
  "boom",
  "burst",
  "bursts",
  "conflict",
  "damage",
  "destroy",
  "destruction",
  "detonation",
  "disaster",
  "explosion",
  "explosive",
  "fuse",
  "loud",
  "mine",
  "sabotage",
  "security threat",
  "terrorism",
  "threat",
  "violence",
  "war",
  "weapon",
  "🧨",
  "academy",
  "bookmark ribbon",
  "course",
  "curriculum",
  "knowledge",
  "lesson",
  "page marker",
  "study",
  "syllabus",
  "textbook",
  "book_2",
  "digital book",
  "ebook",
  "learn",
  "magazine",
  "novel",
  "online reading",
  "publication",
  "studying",
  "academic",
  "dictionary",
  "encyclopedia",
  "letter",
  "fourth",
  "spine",
  "five",
  "notebook",
  "stacked books",
  "admission",
  "concert",
  "digital ticket",
  "e-ticket",
  "entry pass",
  "event ticket",
  "mobile ticket",
  "museum",
  "travel ticket",
  "deselect",
  "flag",
  "later",
  "unmark",
  "add bookmark",
  "add to bookmarks",
  "add to reading list",
  "bookmark add",
  "bookmark plus",
  "bookmarking",
  "bookmarks",
  "favorite bookmark",
  "new bookmark",
  "plus bookmark",
  "reading list",
  "save bookmark",
  "save to reading list",
  "added",
  "bookmark added",
  "favorites",
  "mark as read",
  "save for later",
  "baggage",
  "packing list",
  "shopping bag",
  "suitcase",
  "tote",
  "travel bag",
  "travel gear",
  "wishlist",
  "completed task",
  "okay",
  "selected",
  "country",
  "flags",
  "follow up",
  "milepost",
  "nation",
  "pole",
  "priority",
  "tagged",
  "waypoint",
  "world",
  "add to favorites",
  "affection",
  "appreciate",
  "bookmark heart",
  "favorites list",
  "heart bookmark",
  "love",
  "mark as favorite",
  "passion",
  "preferred",
  "romance",
  "romantic",
  "saved items",
  "valentine",
  "wish list",
  "bookmark manager",
  "content management",
  "document management",
  "edit bookmark",
  "file management",
  "folder edit",
  "folder editor",
  "manage bookmarks",
  "organize bookmarks",
  "sheet",
  "slide",
  "check mark",
  "delete bookmark",
  "remove bookmark",
  "unarchive",
  "unbookmark",
  "unfavorite",
  "unsave",
  "unsaved",
  "bookmark shape",
  "essential",
  "featured",
  "five pointed star",
  "five points",
  "important items",
  "memorable",
  "noteworthy",
  "star shape",
  "starred",
  "ribbons",
  "tabs",
  "audiobook",
  "book and play",
  "books",
  "combined media",
  "digital content",
  "entertainment library",
  "media library",
  "movie and play",
  "music and play",
  "border all",
  "stroke",
  "border bottom",
  "bottom border",
  "bottom line",
  "separator",
  "underscore",
  "border_clear",
  "default",
  "no border",
  "plain",
  "remove border",
  "remove formatting",
  "border color",
  "border horizontal",
  "divider",
  "splitter",
  "inner",
  "inset",
  "internal",
  "margin",
  "border left",
  "border style",
  "border_left",
  "left alignment",
  "left border",
  "text border",
  "outer",
  "border right",
  "right border",
  "broken line",
  "color",
  "perforated",
  "segment",
  "border_top",
  "header",
  "top border",
  "border vertical",
  "panes",
  "two columns",
  "vertical border",
  "vertical divide",
  "assemble",
  "assimilate",
  "borg",
  "build",
  "collective",
  "component",
  "construct",
  "futuristic",
  "integrate",
  "module",
  "app bar",
  "bottom app bar",
  "bottom bar",
  "bottom dock",
  "bottom navigation",
  "bottom panel",
  "footer",
  "mobile interface",
  "mobile navigation",
  "mobile ui",
  "navigation bar",
  "ui bar",
  "bottom drawer",
  "bottom modal",
  "bottom sheet",
  "modal",
  "popup",
  "slide up",
  "ui component",
  "bottom menu",
  "bottom tabs",
  "tab bar",
  "web app",
  "website navigation",
  "UI panel",
  "bottom sheet close",
  "interaction",
  "interface element",
  "mobile UI",
  "slide down",
  "spaces",
  "collapse panel",
  "expand panel",
  "pull up",
  "bottom corner",
  "bottom right",
  "bottom right corner",
  "click location",
  "context menu",
  "context menu location",
  "corner click",
  "mouse click",
  "right click",
  "right click corner",
  "right corner",
  "bottom_sheets",
  "overlap",
  "sheets",
  "closed box",
  "goods",
  "merchandise",
  "parcel",
  "postal",
  "shipment",
  "add package",
  "add to box",
  "add to package",
  "create box",
  "create package",
  "new package",
  "plus package",
  "box edit",
  "edit box",
  "avatar icon",
  "boy",
  "boy icon",
  "child icon",
  "kid icon",
  "male icon",
  "man",
  "profile icon",
  "standing",
  "user icon",
  "announce",
  "awareness",
  "brand awareness",
  "brand recognition",
  "megaphone",
  "outreach",
  "pr",
  "public relations",
  "capital a",
  "change font",
  "choose font",
  "font selection",
  "fonts",
  "italic",
  "lowercase a",
  "regular",
  "serif",
  "styles",
  "tester",
  "typeface",
  "typefaces",
  "intellectual property",
  "layer",
  "trademark",
  "watermark",
  "breakfast food",
  "breakfast time",
  "butter",
  "carbohydrate",
  "continental breakfast",
  "edible",
  "food and beverage",
  "food service",
  "grain",
  "loaf",
  "mealtime",
  "sandwich",
  "slice",
  "toast",
  "wheat",
  "breaking news",
  "bulletin",
  "headline",
  "live",
  "newspaper",
  "press",
  "press release",
  "baby care",
  "breast",
  "breast milk",
  "breastfed",
  "breastfeed",
  "breastfeeding",
  "cuddle",
  "feeding",
  "hug",
  "human milk",
  "infant feeding",
  "lactation",
  "mama",
  "maternity",
  "mom",
  "mommy",
  "motherhood",
  "nursing",
  "nursing mother",
  "nurturing",
  "parenthood",
  "pregnancy",
  "woman",
  "brick",
  "building block",
  "games",
  "lego",
  "masonry",
  "minecraft",
  "piece",
  "pixel art",
  "wall",
  "empty circle",
  "hollow",
  "visibility",
  "dark mode",
  "half moon",
  "sky",
  "theme",
  "waning crescent",
  "third quarter",
  "eight pointed star",
  "islamic star",
  "level 4",
  "moderate brightness",
  "quarter",
  "day",
  "intensity",
  "luminance",
  "maximum",
  "radial",
  "50% brightness",
  "eight points",
  "half",
  "half brightness",
  "medium brightness",
  "daylight",
  "level 7",
  "exposure",
  "overexposure",
  "adaptive brightness",
  "ambient light",
  "auto brightness",
  "auto-adjust",
  "auto-control",
  "automatic brightness",
  "brightness auto",
  "dynamic brightness",
  "starburst",
  "0",
  "octagram",
  "adjustment",
  "brightness medium",
  "lighting",
  "semi-circle",
  "bring",
  "bring your own ip",
  "byoip",
  "custom ip",
  "data center",
  "external ip",
  "global",
  "globe",
  "hosting",
  "infrastructure",
  "internet protocol",
  "ip",
  "ip address",
  "manage ip",
  "network settings",
  "own",
  "protocol",
  "sphere",
  "user ip",
  "your",
  "broadcast on home",
  "router",
  "transmit",
  "broadcast signal",
  "home broadcast",
  "home network",
  "hotspot",
  "house broadcast",
  "lan",
  "local network",
  "personal broadcast",
  "smart house",
  "wlan",
  "bad file",
  "broken",
  "broken file",
  "broken image",
  "connection error",
  "corrupt",
  "corrupted image",
  "damaged file",
  "display error",
  "download error",
  "file error",
  "file not found",
  "glitch",
  "image error",
  "image not found",
  "image placeholder",
  "load error",
  "lost image",
  "missing image",
  "network error",
  "server error",
  "sync error",
  "torn",
  "unreadable file",
  "upload error",
  "zig zag",
  "browse",
  "choices",
  "browsing",
  "log",
  "online activity",
  "page views",
  "site activity",
  "web activity",
  "website activity",
  "browse_gallery",
  "events",
  "moments",
  "parentheses",
  "records",
  "two circles",
  "application update",
  "browser download",
  "browser update",
  "new version",
  "software update",
  "system update",
  "updated",
  "web browser",
  "breakfast and lunch",
  "brunch icon",
  "cafe icon",
  "celebration",
  "champagne",
  "dining icon",
  "flute",
  "food and drink",
  "meal icon",
  "mimosa",
  "pancakes",
  "restaurant icon",
  "waffles",
  "weekend",
  "artistic",
  "artistic tool",
  "brush",
  "creativity",
  "digital art",
  "illustration",
  "paint",
  "paint tool",
  "paintbrush",
  "painting",
  "sketch",
  "answer",
  "bubble chart",
  "bubbles",
  "overlapping circles",
  "representation",
  "trends",
  "animal",
  "bug",
  "bug icon",
  "bug report",
  "bug tracking",
  "defect",
  "exoskeleton",
  "insect",
  "oval",
  "qa",
  "quality assurance",
  "report bug",
  "segmented",
  "software testing",
  "submit bug",
  "testing",
  "virus",
  "crescent wrench",
  "implement",
  "implementation",
  "mechanic",
  "spanner",
  "wrench",
  "build_circle",
  "works",
  "bungalow",
  "cabin",
  "cottage",
  "home page",
  "initial",
  "main page",
  "primary",
  "traveling",
  "burst mode",
  "camera burst",
  "continuous capture",
  "continuous shooting",
  "image burst",
  "multi-shot",
  "multiple photos",
  "photo burst",
  "photo sequence",
  "quick capture",
  "rapid capture",
  "rapid fire",
  "bus stop",
  "incident",
  "road closure",
  "schedule change",
  "service disruption",
  "bus station",
  "commute icon",
  "public transport icon",
  "public transportation",
  "railway icon",
  "straight lines",
  "train icon",
  "train station",
  "transport icon",
  "transportation icon",
  "travel icon",
  "briefcase",
  "business_center",
  "career",
  "case",
  "corporate",
  "documents",
  "employment",
  "portfolio",
  "professional",
  "purse",
  "resources",
  "asset",
  "chip",
  "enclosure",
  "business chat",
  "business communication",
  "business message",
  "dialogue",
  "swap",
  "UI",
  "controller",
  "floating",
  "gamepad",
  "chalet",
  "chimney",
  "getaway",
  "logs",
  "rustic",
  "smoke",
  "wood",
  "wooden",
  "adapter",
  "aux",
  "charger",
  "ethernet",
  "hdmi",
  "jack",
  "usb",
  "aerial tramway",
  "cable car",
  "cable railway",
  "cablecar",
  "chairlift",
  "funicular",
  "gondola",
  "mountain cableway",
  "ropeway",
  "san francisco",
  "ski lift",
  "ski resort",
  "three windows",
  "winter sports",
  "buffering",
  "memory",
  "amplitude",
  "beat",
  "beats per minute",
  "cadence",
  "consistent",
  "repetition",
  "rhythm",
  "steps per minute",
  "anniversary",
  "baked",
  "birthday",
  "birthday cake",
  "birthday icon",
  "cake",
  "cake icon",
  "candle",
  "candles",
  "celebration icon",
  "dessert icon",
  "flame",
  "frosting",
  "party icon",
  "pastries",
  "single candle",
  "special occasion",
  "sweets icon",
  "tiered cake",
  "treat",
  "two layers",
  "add birthday",
  "add cake",
  "add icon",
  "confectionery",
  "create cake",
  "new birthday",
  "new cake",
  "plus cake",
  "plus icon",
  "-",
  "=",
  "calculator",
  "difference",
  "equals",
  "finance calculator",
  "quotient",
  "solve",
  "add reminder",
  "add to calendar",
  "agenda",
  "calendar",
  "calendar icon",
  "calendar page",
  "create event",
  "date picker",
  "event planning",
  "month",
  "new appointment",
  "save the date",
  "schedule meeting",
  "today",
  "year",
  "add event",
  "calendar apps script",
  "choose date",
  "new event",
  "pick date",
  "save date",
  "select date",
  "appointment reminder",
  "calendar date",
  "calendar reminder",
  "clock icon",
  "daily schedule",
  "date and time",
  "time of day",
  "calendar month",
  "month view",
  "organization icon",
  "schedule icon",
  "timetable",
  "week",
  "current date",
  "daily",
  "schedule date",
  "today's date",
  "calendar day",
  "calendar view",
  "daily agenda",
  "daily calendar",
  "daily view",
  "date view",
  "day planner",
  "day view",
  "organizer",
  "schedule day",
  "single day",
  "view day",
  "calendar grid",
  "calendar month view",
  "grid view",
  "monthly calendar",
  "schedule view",
  "seven days",
  "timeframe",
  "week view",
  "weekly",
  "alternative phone",
  "call icon",
  "communication icon",
  "contact icon",
  "hotline",
  "landline",
  "local call",
  "local phone",
  "phone alt",
  "phone icon",
  "receiver icon",
  "telephone call",
  "voicemail",
  "audio call",
  "call end",
  "call_end",
  "call_end_alt",
  "earpiece",
  "end call",
  "hang up",
  "mouthpiece",
  "phone call",
  "telephony",
  "voice call",
  "all calls",
  "call details",
  "call history",
  "call log",
  "call records",
  "calls",
  "communication history",
  "contact history",
  "contact log",
  "dialed calls",
  "missed calls",
  "past calls",
  "phone calls",
  "phone log",
  "phone records",
  "received calls",
  "recent calls",
  "call made",
  "made",
  "outgoing call",
  "call merge",
  "converging arrows",
  "converging lines",
  "group call",
  "multi call",
  "three way call",
  "call missed",
  "callback",
  "declined",
  "hung up",
  "ignored",
  "missed call",
  "rejected",
  "cancel call",
  "declined call",
  "missed connection",
  "no answer",
  "rejected call",
  "unanswered",
  "about",
  "call quality",
  "i",
  "phone information",
  "troubleshoot",
  "voip",
  "accept call",
  "answer call",
  "call received",
  "get call",
  "incoming call",
  "receive call",
  "received",
  "slanted arrow",
  "call branching",
  "call forwarding",
  "call management",
  "call split",
  "call transfer",
  "diverging arrows",
  "redirect",
  "replicate",
  "call to action",
  "cta",
  "instruction",
  "prompt",
  "aperture",
  "camcorder",
  "record button",
  "shoot",
  "snapshot",
  "take photo",
  "take picture",
  "take video",
  "triangles",
  "videocamera",
  "camera flip",
  "facing",
  "flip",
  "front",
  "front camera",
  "mobile camera",
  "portrait mode",
  "self portrait",
  "switch camera",
  "user facing camera",
  "cam",
  "camera indoor",
  "filming",
  "home cam",
  "home monitoring",
  "home security",
  "house camera",
  "indoor camera",
  "ip camera",
  "live stream",
  "security camera",
  "surveillance camera",
  "video camera",
  "video surveillance",
  "videography",
  "camera recording",
  "outdoor camera",
  "property surveillance",
  "remote viewing",
  "smart camera",
  "video monitoring",
  "camera app",
  "rear",
  "rear camera",
  "video capture",
  "analog",
  "camera roll",
  "classic camera",
  "film reel",
  "film roll",
  "filmstrip",
  "picture roll",
  "reel",
  "roll",
  "desk",
  "live video",
  "online meeting",
  "record video",
  "start recording",
  "stop recording",
  "tripod",
  "video broadcast",
  "video chat",
  "video streaming",
  "virtual meeting",
  "webcam call",
  "back camera",
  "camera rotate",
  "camera switch",
  "camera toggle",
  "cameraswitch",
  "change camera",
  "flip camera",
  "rotate camera",
  "selfie camera",
  "advertise",
  "bullhorn",
  "content marketing",
  "email marketing",
  "influencer marketing",
  "loudspeaker",
  "paid advertising",
  "public address",
  "shout",
  "social media marketing",
  "camp",
  "campsite",
  "expedition",
  "exploration",
  "outdoor activities",
  "teepee",
  "tent",
  "trekking",
  "wigwam",
  "wilderness",
  "cancel button",
  "close button",
  "cross mark",
  "highlight off",
  "remove selection",
  "turn off",
  "unselect",
  "abort",
  "cancel presentation mode",
  "present",
  "presentation mode",
  "terminate",
  "prevent",
  "unschedule",
  "unsend",
  "burn",
  "candelabra",
  "candlestick",
  "christmas",
  "fire",
  "holder",
  "hope",
  "ideology",
  "memorial",
  "prayer",
  "religion",
  "remembrance",
  "spiritual",
  "teardrop",
  "torch",
  "vigil",
  "wax",
  "worship",
  "candlestick chart",
  "financial chart",
  "market chart",
  "price chart",
  "stock",
  "stock chart",
  "trading",
  "trading chart",
  "trend chart",
  "wick",
  "420",
  "alternative medicine",
  "cannabis",
  "cbd",
  "dispensary",
  "drug",
  "ganja",
  "hemp",
  "herbal",
  "hybrid",
  "illegal",
  "indica",
  "leaf",
  "marijuana",
  "pot",
  "rasta",
  "recreational",
  "sativa",
  "seven leaves",
  "thc",
  "weed",
  "captive portal",
  "gateway",
  "go to",
  "guest wifi",
  "landing page",
  "language",
  "planet",
  "portal",
  "public wifi",
  "www",
  "acquire",
  "content capture",
  "data capture",
  "grab",
  "obtain",
  "picture in picture",
  "screen capture",
  "screengrab",
  "screenshot",
  "window capture",
  "car symbol",
  "collision",
  "insurance",
  "defog",
  "defrost",
  "demist",
  "driver",
  "heating",
  "warmer",
  "windshield",
  "blower",
  "vent",
  "car controls",
  "front window",
  "windscreen",
  "front seat",
  "mid",
  "seated",
  "back seat",
  "mid left",
  "middle seat",
  "rear seat",
  "air direction",
  "air vent",
  "low level",
  "mid level",
  "right side",
  "air circulation",
  "car interior",
  "circulate",
  "recirculate",
  "recirculation symbol",
  "auto maintenance",
  "auto repair",
  "auto service",
  "car maintenance",
  "car repair",
  "car service",
  "car settings",
  "tuning",
  "vehicle maintenance",
  "vehicle repair",
  "vehicle service",
  "anti-theft",
  "car lock",
  "car security",
  "immobilizer",
  "keyless entry",
  "locked",
  "password",
  "remote",
  "unlock",
  "vehicle lock",
  "vehicle security",
  "car part",
  "condensation",
  "defroster",
  "fog",
  "heated",
  "mirror",
  "rearview mirror",
  "side mirror",
  "sideview",
  "wing mirror",
  "car hire",
  "car rental",
  "car sharing",
  "carpool",
  "hire",
  "loan",
  "pickup",
  "rent",
  "car lift",
  "elevated",
  "fix car",
  "hoist",
  "service car",
  "workshop",
  "car deal",
  "car label",
  "car offer",
  "car price",
  "car sale",
  "car tag",
  "deal",
  "discount",
  "trade",
  "access card",
  "badge card",
  "card membership",
  "exclusive",
  "exclusive card",
  "loyalty",
  "loyalty card",
  "payment card",
  "premium card",
  "rewards",
  "rewards card",
  "saved card",
  "subscription card",
  "vip",
  "vip card",
  "business trip",
  "card_travel",
  "carry-on",
  "miles",
  "work trip",
  "cardiac",
  "cardio",
  "exertion",
  "gym",
  "heart monitor",
  "heart rate",
  "physical activity",
  "sport",
  "training",
  "training effort",
  "training load",
  "cardiovascular",
  "ecg",
  "ekg",
  "electrocardiogram",
  "heart health",
  "life",
  "vital",
  "app view",
  "boxes",
  "cards",
  "modules",
  "quad",
  "switch view",
  "collections",
  "highlights",
  "images",
  "photos",
  "pictures",
  "scratchcard",
  "builder",
  "carpenter",
  "carpentry",
  "craft",
  "cut",
  "cutting",
  "diy",
  "grip",
  "handsaw",
  "handyman",
  "home improvement",
  "lumber",
  "renovation",
  "saw",
  "sawing",
  "teeth",
  "timber",
  "woodworking",
  "cabin luggage",
  "carryon",
  "personal item",
  "rolling",
  "allowed",
  "checked",
  "hand luggage",
  "overhead compartment",
  "travel accessories",
  "carry on",
  "airport information",
  "baggage information",
  "baggage question",
  "carry-on baggage",
  "carry-on luggage",
  "flight information",
  "luggage information",
  "luggage question",
  "travel information",
  "travel question",
  "assignments",
  "cases",
  "bet",
  "betting",
  "casino",
  "casino chip",
  "casino game",
  "chance",
  "chips",
  "dice",
  "dice roll",
  "five dots",
  "fortune",
  "gamble",
  "gambling",
  "game of chance",
  "las vegas",
  "luck",
  "probability",
  "random",
  "risk",
  "spots",
  "tokens",
  "wager",
  "chromecast",
  "media sharing",
  "mirroring",
  "projection",
  "screen share",
  "screencast",
  "smart tv",
  "miracast",
  "screen sharing",
  "classroom",
  "distance learning",
  "for",
  "graduation cap",
  "lecture",
  "lessons teaching",
  "teach",
  "tutorial",
  "university",
  "webinar",
  "cast alert",
  "cast error",
  "cast issue",
  "cast problem",
  "cast signal",
  "connection issue",
  "connection problem",
  "network issue",
  "network problem",
  "signal bars",
  "wireless error",
  "wireless issue",
  "wireless problem",
  "ancient",
  "battlement",
  "castle",
  "citadel",
  "fairytale",
  "fantasy",
  "fort",
  "fortification",
  "fortress",
  "kingdom",
  "mansion",
  "medieval",
  "palace",
  "rampart",
  "royalty",
  "stronghold",
  "turret",
  "assortment",
  "building blocks",
  "categories",
  "categorize",
  "category",
  "classification",
  "elements",
  "personalization",
  "shapes",
  "taxonomy",
  "themes",
  "types",
  "variety",
  "advanced search",
  "classify",
  "department",
  "detailed search",
  "item category",
  "product category",
  "topic",
  "celebrate",
  "cheers",
  "cone",
  "confetti",
  "congrats",
  "congratulations",
  "exploding",
  "festive",
  "hooray",
  "noisemaker",
  "party popper",
  "popper",
  "streams",
  "yay",
  "incorporate",
  "unite",
  "casting",
  "cell tower",
  "strength",
  "transmitting",
  "cellular service",
  "roaming",
  "signal bar",
  "aim",
  "aiming",
  "calibration",
  "center focus",
  "object recognition",
  "precise",
  "reticle",
  "strong",
  "strong focus",
  "auto focus",
  "autofocus",
  "center focus weak",
  "framing",
  "image focus",
  "manual focus",
  "positioning",
  "screen focus",
  "weak",
  "weak focus",
  "armchair",
  "couch",
  "decoration",
  "furnishings",
  "furniture store",
  "living",
  "living room",
  "lobby",
  "lounge",
  "lounging",
  "loveseat",
  "seating",
  "sofa",
  "two seater",
  "waiting room",
  "alternative chair",
  "bench",
  "cahir",
  "chair_alt",
  "stool",
  "waiting",
  "lodge",
  "mountain resort",
  "ski",
  "winter holiday",
  "winter vacation",
  "alteration",
  "change history",
  "changes",
  "edit history",
  "git",
  "github",
  "revisions",
  "track changes",
  "version control",
  "version history",
  "versioning",
  "batteries",
  "electric vehicle",
  "ev",
  "fast charge",
  "charging station",
  "fill up",
  "mobile charging",
  "power station",
  "gain",
  "line chart",
  "messenger",
  "add chat",
  "add comment",
  "add conversation",
  "add post",
  "create chat",
  "join chat",
  "new chat",
  "new post",
  "plus message",
  "start chat",
  "chat bot",
  "chatbot",
  "interact",
  "comment bubble",
  "cancel chat",
  "chat error",
  "chat fail",
  "chat problem",
  "chat x",
  "close chat",
  "communication error",
  "delete chat",
  "delete message",
  "error message",
  "fail message",
  "message error",
  "message fail",
  "message problem",
  "messaging",
  "remove chat",
  "remove message",
  "about chat",
  "chat details",
  "chat info",
  "chat information",
  "chat support",
  "conversation details",
  "conversation info",
  "conversation information",
  "hint",
  "info bubble",
  "learn more",
  "message details",
  "message info",
  "message information",
  "more info",
  "tooltip",
  "chat message",
  "chat reply",
  "paste",
  "paste text",
  "quick reply",
  "send message",
  "share text",
  "share message",
  "text area",
  "text box",
  "accepted",
  "agreed",
  "submitted",
  "task complete",
  "todo",
  "checkbox",
  "checked box",
  "tick mark",
  "blank",
  "deselected",
  "empty box",
  "empty square",
  "tickbox",
  "uncheck",
  "unchecked",
  "unselected",
  "successful",
  "attendance",
  "availability",
  "check in",
  "check out",
  "coming",
  "doorway",
  "entrance",
  "gate",
  "going",
  "inscription",
  "presence",
  "hyphen",
  "in progress",
  "indeterminate",
  "indeterminate state",
  "intermediate",
  "mixed state",
  "progress bar",
  "three-state",
  "tri-state",
  "undefined",
  "checkbook",
  "cheque",
  "ledger",
  "signature",
  "withdraw",
  "carousel",
  "baggage_info",
  "found",
  "lost",
  "travel_info",
  "questionnaire",
  "right to left",
  "rtl",
  "checkroom",
  "cloakroom",
  "clothes hanger",
  "clothes rack",
  "coat check",
  "coat hanger",
  "hanger",
  "hanging",
  "lost and found",
  "temporary storage",
  "applaud",
  "applause",
  "cheer",
  "cheering",
  "clap",
  "clapping hands",
  "encourage",
  "encouragement",
  "enthusiasm",
  "excitement",
  "fans",
  "good job",
  "gratitude",
  "greeting",
  "hype",
  "joy",
  "ovation",
  "positive feedback",
  "praise",
  "thank you",
  "thanks",
  "well done",
  "baker",
  "catering",
  "chef's hat",
  "chef's uniform",
  "cooking show",
  "cuisine",
  "culinary",
  "culinary arts",
  "food blog",
  "food industry",
  "gastronomy",
  "hat",
  "head chef",
  "pastry chef",
  "recipe",
  "restaurant management",
  "toque",
  "uniform",
  "board",
  "board game",
  "challenge",
  "chess",
  "chess piece",
  "competition",
  "crown",
  "google play",
  "hobby",
  "logic",
  "skill",
  "strategy",
  "tactics",
  "tournament",
  "trophy",
  "beginner",
  "chess pawn",
  "game icon",
  "pawn",
  "silhouette",
  "tabletop",
  "tactic",
  "backward navigation",
  "before",
  "caret back",
  "chevron back",
  "arrow_forward",
  "chevron_forward",
  "fast_forward",
  "greater_than",
  "right_arrow",
  "next page",
  "next track",
  "babysitting",
  "child friendly",
  "childhood",
  "curl",
  "daycare",
  "hair",
  "kids zone",
  "parental",
  "preschool",
  "baby carriage",
  "baby products",
  "baby transport",
  "buggy",
  "canopy",
  "carriage",
  "family-friendly",
  "friendly",
  "hood",
  "juvenile",
  "kids friendly",
  "pram",
  "pushchair",
  "stroller",
  "travel with kids",
  "chip extraction",
  "data extraction",
  "depart",
  "eject",
  "extract",
  "leave",
  "undocking",
  "unplug",
  "condense",
  "lessen",
  "take away",
  "chrome reader mode",
  "clean view",
  "digital reading",
  "distraction-free",
  "mobile view",
  "readability",
  "simplify",
  "split view",
  "text mode",
  "chromecast 2",
  "dongle",
  "google cast",
  "streaming device",
  "chronic",
  "extended",
  "interval",
  "long-term",
  "persistent",
  "scheduling",
  "cathedral",
  "ceremony",
  "chapel",
  "christian",
  "christianity",
  "church",
  "crucifix",
  "faith",
  "funeral",
  "gathering",
  "holy",
  "map marker",
  "place of worship",
  "pray",
  "religious",
  "spirituality",
  "steeple",
  "wedding",
  "actor",
  "actress",
  "cinematic",
  "clapper",
  "clapperboard",
  "crew",
  "director",
  "film making",
  "headshot",
  "production",
  "slate",
  "circumference",
  "donut",
  "eye",
  "fish",
  "hoop",
  "null",
  "orb",
  "torus",
  "wide",
  "alert icon",
  "bell icon",
  "bell symbol",
  "circle notification",
  "notification symbol",
  "round notification",
  "orbital",
  "satellite",
  "venn diagram",
  "cluster",
  "converging",
  "converging circles",
  "ext",
  "joining",
  "merging",
  "triangular",
  "additional",
  "clarify",
  "description",
  "explanation",
  "hamburger menu",
  "mobile menu",
  "supplement",
  "uncover",
  "bacteria",
  "disinfect",
  "germ",
  "germs",
  "handwashing",
  "infection",
  "sanitize",
  "sanitizer",
  "soap",
  "bleach",
  "bottle shape",
  "chores",
  "clean surface",
  "cleaning product",
  "cleaning supplies",
  "detergent",
  "disinfectant",
  "housekeeping",
  "housework",
  "sanitation",
  "sanitizing",
  "spring cleaning",
  "tidy",
  "tidying",
  "trigger spray",
  "washing",
  "wipe",
  "wiping",
  "bucket",
  "disinfection",
  "janitorial",
  "pail",
  "sterilization",
  "sterilize",
  "suds",
  "trapezoid",
  "utility",
  "vessel",
  "broom",
  "cleaning services",
  "dirt",
  "dustpan",
  "mess",
  "scoop",
  "sweep",
  "utensil",
  "clear all",
  "clear field",
  "clear input",
  "clear list",
  "clear selection",
  "clear text",
  "delete all",
  "remove all",
  "remove list",
  "stacked lines",
  "beams",
  "clear day",
  "clear sky",
  "daytime",
  "eight rays",
  "forecast",
  "solar",
  "sunny day",
  "sunrise",
  "sunset",
  "mini split",
  "split system",
  "wall mounted",
  "clinical notes",
  "consultation",
  "medic",
  "summary",
  "due",
  "accelerate",
  "clock arrow",
  "future",
  "time up",
  "10%",
  "circular progress",
  "loader",
  "partial circle",
  "percent",
  "ten percent",
  "1/4",
  "25%",
  "pie",
  "portion",
  "hourglass",
  "spinner",
  "90 degrees",
  "asynchronous",
  "background task",
  "alert close",
  "dialog close",
  "discard",
  "error close",
  "modal close",
  "notification close",
  "overlay close",
  "popup close",
  "window close",
  "arrow cross",
  "close fullscreen",
  "corner arrows",
  "cross arrows",
  "default view",
  "diagonal arrows",
  "exit fullscreen",
  "four way arrow",
  "leave fullscreen",
  "normal screen",
  "pointing in",
  "pointing inwards",
  "quad arrow",
  "standard view",
  "unfullscreen",
  "close dialog",
  "close window",
  "close_small",
  "eliminate",
  "kill",
  "remove small",
  "small close button",
  "accessibility options",
  "audio settings",
  "caption",
  "captioning",
  "captions",
  "cc",
  "closed caption",
  "closed captioning",
  "decoder",
  "disable subtitles",
  "double c",
  "media controls",
  "mute subtitles",
  "speech to text",
  "subtitle",
  "subtitles",
  "transcript",
  "turn off subtitles",
  "two c's",
  "video controls",
  "add subtitles",
  "enable closed captions",
  "turn on",
  "cc off",
  "no captions",
  "no subtitles",
  "cloudy",
  "cumulus",
  "nimbus",
  "overcast",
  "stratus",
  "cloud alert",
  "cloud error",
  "cloud issue",
  "cloud notification",
  "cloud problem",
  "cloud status",
  "cloud warning",
  "data alert",
  "data warning",
  "network alert",
  "network warning",
  "server alert",
  "server warning",
  "circled cloud",
  "cloud data",
  "cloud hosting",
  "cloud in circle",
  "cloud service",
  "cloud symbol",
  "data cloud",
  "data synchronization",
  "network storage",
  "cloud check",
  "cloud complete",
  "cloud success",
  "cloud tick",
  "complete download",
  "complete upload",
  "successful download",
  "successful upload",
  "synchronized",
  "cloud download",
  "downward arrow",
  "rounded shapes",
  "web storage",
  "access control",
  "cloud access",
  "cloud lock",
  "cloud security",
  "data encryption",
  "encryption",
  "internet security",
  "network security",
  "online security",
  "padlock",
  "private cloud",
  "restricted access",
  "secure cloud",
  "cloud delete",
  "cloud disabled",
  "cloud disconnect",
  "cloud off",
  "cloud remove",
  "delete cloud",
  "download disabled",
  "internet off",
  "no cloud",
  "no internet",
  "no wifi",
  "remove cloud",
  "upload disabled",
  "circular arrows",
  "data import",
  "data upload",
  "file upload",
  "save to cloud",
  "upload icon",
  "air pollution",
  "carbon",
  "carbon dioxide",
  "carbon footprint",
  "chemical",
  "climate change",
  "co2",
  "co2 emissions",
  "co2 icon",
  "co2 levels",
  "co2 reduction",
  "dioxide",
  "ecology",
  "emissions",
  "global warming",
  "greenhouse effect",
  "greenhouse gas",
  "reduce emissions",
  "co-present",
  "presenter",
  "seminar",
  "share screen",
  "slides",
  "togather",
  "wfh",
  "work from home",
  "code editor",
  "coding",
  "css",
  "develop",
  "engineer",
  "html",
  "ide",
  "javascript",
  "less than",
  "programming language",
  "snippet",
  "source code",
  "syntax",
  "code blocks",
  "code snippet",
  "code window",
  "developer tools",
  "edit code",
  "insert code",
  "terminal",
  "code_off",
  "coding off",
  "no code",
  "power off",
  "suppress",
  "break time",
  "caffeine",
  "cappuccino",
  "coffee",
  "coffee shop",
  "cup",
  "espresso",
  "hot drink",
  "latte",
  "mocha",
  "mug",
  "plate",
  "set",
  "tea",
  "appliances",
  "break room",
  "brew",
  "brewing",
  "carafe",
  "coffee machine",
  "coffee maker",
  "coffee pot",
  "drip",
  "maker",
  "pour",
  "brain",
  "cognition",
  "ideas",
  "innovation",
  "mental",
  "mental process",
  "mind",
  "perception",
  "problem solving",
  "psychology",
  "reasoning",
  "swirl",
  "thinking",
  "thought",
  "thoughts",
  "understanding",
  "brainpower",
  "concept",
  "consciousness",
  "intellect",
  "neurology",
  "neuroscience",
  "carets",
  "collapse all",
  "compact",
  "double caret",
  "inverted v",
  "minimize all",
  "tree view",
  "accordion",
  "collapse content",
  "conceal",
  "content toggle",
  "display toggle",
  "expandable",
  "expansion",
  "fold",
  "hide content",
  "minimize content",
  "tuck",
  "visibility toggle",
  "add to library",
  "corner bookmark",
  "read later",
  "color fill",
  "color sampling",
  "colorize",
  "customization",
  "dropper",
  "eyedropper",
  "pipette",
  "sample",
  "colors",
  "colour",
  "dye",
  "graphic design",
  "pigment",
  "spill",
  "column layout",
  "combine columns",
  "join columns",
  "merge columns",
  "acting",
  "anonymous",
  "broadway",
  "comedy",
  "comedy mask",
  "comic",
  "drama",
  "entertainment genre",
  "expression",
  "funny",
  "humor",
  "laugh",
  "mask",
  "masks",
  "stage",
  "standup",
  "theatre",
  "theatrical mask",
  "tour",
  "anime",
  "cartoons",
  "comic book",
  "comic bubble",
  "comic strip",
  "comics",
  "graphic novels",
  "jagged",
  "manga",
  "opinion",
  "pointed",
  "thought bubble",
  "insert_comment",
  "cchat",
  "comment bank",
  "comment repository",
  "documentation",
  "feedback repository",
  "flagged comments",
  "important comments",
  "saved comments",
  "saved messages",
  "saved replies",
  "block comments",
  "cancel comments",
  "comments",
  "comments blocked",
  "comments disabled",
  "comments hidden",
  "comments off",
  "comments restricted",
  "comments slash",
  "conversation disabled",
  "conversation off",
  "disable comments",
  "feedback disabled",
  "feedback off",
  "hide comments",
  "message disabled",
  "message off",
  "mute comments",
  "no comments",
  "remove comments",
  "reply disabled",
  "reply off",
  "restrict comments",
  "silence comments",
  "speech bubble disabled",
  "speech bubble off",
  "turn off comments",
  "accomplish",
  "bind",
  "commit",
  "dedicate",
  "finalize",
  "pledge",
  "collaborate",
  "communities",
  "connections",
  "forums",
  "groups",
  "huddle",
  "social network",
  "teams",
  "commute mode",
  "commute time",
  "daily commute",
  "going out",
  "mode of transport",
  "multi-modal",
  "multimodal",
  "park and ride",
  "rideshare",
  "travel options",
  "travel time",
  "work commute",
  "a/b",
  "a/b testing",
  "dual",
  "edits",
  "evaluation",
  "similarity",
  "variants",
  "versus",
  "vs",
  "alongside",
  "collide",
  "compare arrows",
  "differentiate",
  "distinction",
  "opposite",
  "opposition",
  "shuffle",
  "together",
  "finding",
  "magnetic",
  "cogs",
  "teamwork",
  "bio",
  "compost",
  "compostable",
  "decomposable",
  "decompose",
  "decomposition",
  "eco",
  "environmental",
  "garden",
  "gardening",
  "green",
  "leafs",
  "leaves",
  "organic",
  "recycle",
  "recycling",
  "renewable",
  "sprout",
  "zero waste",
  "bring together",
  "constrict",
  "decrease height",
  "decrease size",
  "deflate",
  "flatten",
  "make smaller",
  "narrow",
  "push together",
  "squeeze",
  "zip",
  "computing",
  "pc",
  "personal computer",
  "workstation",
  "caret up",
  "computer arrow",
  "computer transfer",
  "computer upload",
  "laptop transfer",
  "laptop upload",
  "send to computer",
  "send to device",
  "send to laptop",
  "transfer to computer",
  "transfer to device",
  "upload to device",
  "upload to pc",
  "shut down",
  "assistance bell",
  "bellhop",
  "call for help",
  "concierge",
  "customer service",
  "customer support",
  "dome",
  "front desk",
  "guest services",
  "help desk",
  "hospitality service",
  "hotel service",
  "local",
  "request assistance",
  "ring for service",
  "service bell",
  "conditions",
  "criteria",
  "examination",
  "find person",
  "requirements",
  "search user",
  "user search",
  "admit",
  "confirmation number",
  "coupon",
  "stub",
  "tear-off",
  "voucher",
  "anomaly",
  "birth",
  "chromosome",
  "cleft",
  "condition",
  "congenital",
  "dna",
  "embryo",
  "fetus",
  "genetic",
  "hereditary",
  "inherited",
  "lip",
  "lips",
  "mouth",
  "mutation",
  "palate",
  "prenatal",
  "syndrome",
  "trait",
  "communicating",
  "contactless",
  "contactless connection",
  "remote connection",
  "social distance",
  "socialize",
  "wireless communication",
  "without",
  "connected tv",
  "digital tv",
  "internet tv",
  "online tv",
  "three arcs",
  "air traffic",
  "two airplanes",
  "crossed tools",
  "hammer",
  "improvement",
  "industrial",
  "industry",
  "manufacturing",
  "site maintenance",
  "under construction",
  "website maintenance",
  "wip",
  "work in progress",
  "911",
  "emergency contact",
  "in case of emergency",
  "address book",
  "contact us",
  "directory",
  "get in touch",
  "inquiry",
  "mail contact",
  "about us",
  "contact page",
  "listing",
  "call contact",
  "contact card",
  "contact info",
  "helpline",
  "phone book",
  "phone contact",
  "reach out",
  "ask",
  "faq",
  "get help",
  "question circle",
  "cardless",
  "contactless payment",
  "mobile pay",
  "near field communication",
  "nfc",
  "proximity",
  "touchless",
  "blocked contactless",
  "contactless blocked",
  "contactless disabled",
  "contactless off",
  "contactless payment off",
  "disabled contactless",
  "mobile payment off",
  "nfc disabled",
  "nfc off",
  "nfc payment off",
  "no contactless",
  "no mobile payment",
  "no nfc",
  "no proximity payment",
  "no tap",
  "no tap to pay",
  "no wireless payment",
  "off contactless",
  "proximity payment off",
  "signal off",
  "tap disabled",
  "tap off",
  "tap to pay off",
  "wireless payment off",
  "contact list",
  "find contact",
  "individuals",
  "manage contacts",
  "roster",
  "shoulders",
  "client",
  "clients",
  "customer",
  "customers",
  "offering",
  "offerings",
  "products",
  "content copy",
  "content duplication",
  "copy paste",
  "reproduce",
  "content_cut",
  "excerpt",
  "excise",
  "isolate",
  "scissors",
  "sever",
  "snip",
  "trim",
  "no document",
  "no entry",
  "no paste",
  "paste off",
  "audit",
  "content_paste_search",
  "context",
  "contextual",
  "contextual token",
  "custom",
  "data entry",
  "form field",
  "input field",
  "token",
  "user input",
  "variable",
  "agreement",
  "binding",
  "folded corner",
  "obligation",
  "official",
  "paperwork",
  "policy",
  "terms",
  "abolish",
  "cancel contract",
  "delete contract",
  "nullify",
  "remove contract",
  "repeal",
  "revoke",
  "terminate contract",
  "void",
  "x out",
  "adjust contrast",
  "black",
  "dark theme",
  "grayscale",
  "half and half",
  "light mode",
  "two halves",
  "two parts",
  "white",
  "yin yang",
  "adjustments",
  "editier",
  "filters",
  "half circle",
  "high contrast",
  "increases",
  "low contrast",
  "accessibility off",
  "contrast disabled",
  "contrast off",
  "contrast setting",
  "default contrast",
  "disable contrast",
  "line through",
  "normal contrast",
  "reset contrast",
  "sight",
  "view settings",
  "camera control",
  "reposition",
  "video control",
  "constitute",
  "establish",
  "generation",
  "initiate",
  "institute",
  "make",
  "originate",
  "regulator",
  "connecting",
  "conversion path",
  "funnel",
  "sales funnel",
  "two points",
  "cancel conversion",
  "conversion blocked",
  "conversion disabled",
  "conversion off",
  "disable conversion",
  "flow off",
  "funnel off",
  "journey off",
  "no conversion",
  "path blocked",
  "path disabled",
  "path off",
  "process off",
  "route disabled",
  "route off",
  "sequence off",
  "stop conversion",
  "workflow off",
  "convert",
  "decode",
  "encode",
  "parse",
  "translate",
  "assembly line",
  "conveyor",
  "conveyor belt",
  "factory",
  "logistic",
  "manufactory",
  "manufacturing process",
  "production line",
  "supply",
  "biscuit",
  "bite",
  "chocolate chip",
  "chunk",
  "cookie",
  "cookies",
  "crumbs",
  "eaten",
  "eating",
  "missing piece",
  "wafer",
  "web cookie",
  "anti-tracking",
  "block cookies",
  "block tracking",
  "browser settings",
  "clear cookies",
  "cookie off",
  "data privacy",
  "disable cookies",
  "internet privacy",
  "no cookies",
  "no tracking",
  "reject cookies",
  "remove cookies",
  "web tracking",
  "website tracking",
  "boil",
  "braiser",
  "burner",
  "cast iron",
  "cooking pot",
  "cooktop",
  "cookware",
  "dutch oven",
  "hob",
  "induction",
  "lid",
  "meals",
  "prepare",
  "simmer",
  "stockpot",
  "stove",
  "stovetop",
  "cool ",
  "dry",
  "evaporation",
  "ripples",
  "copy all",
  "copy content",
  "all rights reserved",
  "circled c",
  "commercial use",
  "fair use",
  "infringement",
  "letter c",
  "registered",
  "reserved",
  "rights",
  "contagion",
  "epidemic",
  "isolation",
  "microbe",
  "outbreak",
  "pathogen",
  "quarantine",
  "sick",
  "spikes",
  "fare",
  "fee",
  "invoice",
  "homestead",
  "rooftop",
  "village",
  "looks",
  "none",
  "score",
  "tally",
  "single",
  "2 items",
  "number 2",
  "number two",
  "two items",
  "badge count",
  "notification count",
  "numeric",
  "message count",
  "six",
  "balls",
  "billiard",
  "snooker",
  "cabinet",
  "countertop surface",
  "countertops",
  "dishwashing",
  "kitchen counter",
  "remodel",
  "tops",
  "vanity",
  "add folder",
  "create directory",
  "create folder",
  "create new folder",
  "folder management",
  "new directory",
  "new folder",
  "plus folder",
  "debt",
  "e-commerce",
  "swipe",
  "bnpl",
  "credit card activity",
  "credit card expiry",
  "credit card payment time",
  "credit card timer",
  "expiry",
  "pay later",
  "pay over time",
  "payment due",
  "payment pending",
  "payment schedule",
  "payment time",
  "purchase history",
  "transaction history",
  "billing settings",
  "card settings",
  "configure billing",
  "configure payment",
  "credit card settings",
  "debit",
  "edit billing",
  "edit payment",
  "finance settings",
  "manage billing",
  "manage payment",
  "money management",
  "payment options",
  "payment settings",
  "charity",
  "redeem",
  "no card",
  "no credit card",
  "no payment",
  "credit score",
  "baby furniture",
  "cradle",
  "lullaby",
  "rocker",
  "sleeping",
  "swing",
  "crisis",
  "power button",
  "cropping tool",
  "image crop",
  "image manipulation",
  "photo crop",
  "by",
  "proportion",
  "3:2 ratio",
  "crop tool",
  "edit image",
  "edit photo",
  "image adjust",
  "image frame",
  "image resize",
  "image trim",
  "photo resize",
  "picture crop",
  "picture resize",
  "5:4",
  "crop image",
  "crop photo",
  "editing settings",
  "five by four",
  "five to four",
  "image proportions",
  "photo proportions",
  "7 by 5",
  "7:5",
  "picture adjustment",
  "9:16",
  "mobile first",
  "mobile video",
  "portrait video",
  "sixteen by nine",
  "social media video",
  "story format",
  "vertical format",
  "vertical video",
  "crop free",
  "free",
  "free aspect ratio",
  "freeform",
  "freeform crop",
  "180 degrees",
  "adjust image",
  "image editor",
  "image rotation",
  "photo manipulation",
  "1:1",
  "crop din",
  "crop square",
  "crop to square",
  "din",
  "square crop tool",
  "brain teaser",
  "crossword",
  "letter game",
  "mental exercise",
  "mind game",
  "puzzle",
  "trivia",
  "word game",
  "word puzzle",
  "words",
  "crowd",
  "crowdsource",
  "funding",
  "hands up",
  "participation",
  "polling",
  "sourcing",
  "user generated content",
  "diadem",
  "headwear",
  "leader",
  "leadership",
  "monarchy",
  "noble",
  "tiara",
  "tier",
  "animal friendly",
  "beauty",
  "bunny",
  "compassion",
  "cosmetics",
  "cruelty",
  "cruelty free",
  "ears",
  "ethical",
  "humane",
  "kindness",
  "makeup",
  "no animal testing",
  "not tested on animals",
  "pet",
  "product label",
  "rabbit",
  "skincare",
  "vegan",
  "vegetarian",
  "wildlife",
  "cascading style sheets",
  "frontend",
  "sans-serif",
  "software development",
  "stylesheet",
  "web design",
  "web development",
  "comma",
  "comma separated values",
  "csv",
  "data exchange",
  "data file",
  "file extension",
  "file type",
  "separated",
  "spreadsheets",
  "text file",
  "values",
  "bitcoin",
  "blockchain",
  "btc",
  "crypto",
  "cryptocurrency",
  "decentralized",
  "digital currency",
  "franc",
  "letter b",
  "mining",
  "virtual currency",
  "currency exchange",
  "universal",
  "central african cfa franc",
  "cfa franc",
  "cfp franc",
  "chf",
  "comorian franc",
  "djiboutian franc",
  "foreign currency",
  "france",
  "france money",
  "french franc",
  "guinean franc",
  "international",
  "swiss",
  "swiss franc",
  "swiss money",
  "switzerland",
  "west african cfa franc",
  "letter l",
  "lira",
  "try",
  "turkey",
  "turkish",
  "turkish lira",
  "british pound",
  "england",
  "foreign exchange",
  "forex",
  "gbp",
  "great britain",
  "great britain pound",
  "monetary",
  "pound",
  "pound sterling",
  "sterling",
  "uk",
  "united kingdom",
  "£",
  "cyrillic",
  "economics",
  "letter p",
  "rub",
  "ruble",
  "russia",
  "russian ruble",
  "capital letter r",
  "economic",
  "india",
  "indian rupee",
  "inr",
  "rupee",
  "asia",
  "asian",
  "letter y",
  "yen",
  "¥",
  "china",
  "chinese",
  "cny",
  "crossbar",
  "renminbi",
  "rmb",
  "yuan",
  "curtain rods",
  "drapery",
  "drapes",
  "home decor",
  "stage curtain",
  "theater curtains",
  "window frame",
  "closed blinds",
  "curtain",
  "vertical rectangles",
  "custom typography",
  "text editing",
  "iteration",
  "reuse",
  "atmospheric",
  "cyclone",
  "eye of the storm",
  "hurricane",
  "low pressure",
  "natural",
  "natural disaster",
  "rain",
  "tornado",
  "typhoon",
  "vortex",
  "winds",
  "windy",
  "dangerous",
  "multiplication sign",
  "sign",
  "wrong",
  "light switch",
  "user preferences",
  "main",
  "overview",
  "widgets",
  "dashboard 2",
  "homepage",
  "reports",
  "widget",
  "data_alert",
  "lists",
  "coder",
  "data array",
  "data collection",
  "data container",
  "data element",
  "data format",
  "data list",
  "data sequence",
  "data structure",
  "delimiter",
  "json",
  "data approved",
  "data check",
  "data complete",
  "data validation",
  "data verification",
  "information check",
  "information verified",
  "analysis tool",
  "data exploration",
  "data mining",
  "upward trend",
  "advice",
  "information icon",
  "tip",
  "data loss prevention",
  "information protection",
  "loss",
  "results about you",
  "seek",
  "sensitive data",
  "threat detection",
  "vulnerability",
  "braces",
  "coding tools",
  "curly brackets",
  "data object",
  "bandwidth",
  "data control",
  "data economy",
  "data limit",
  "data restriction",
  "data saver",
  "data saving",
  "data settings",
  "data usage",
  "internet data",
  "limit data",
  "network data",
  "network management",
  "reduce data",
  "restrict data",
  "save data",
  "catalog",
  "data table",
  "data filtering",
  "data thresholding",
  "thresholding",
  "thresold",
  "data saver off",
  "data usage off",
  "disable data",
  "enable data",
  "usage",
  "big data",
  "cylinder",
  "mysql",
  "nosql",
  "postgresql",
  "sql",
  "warehousing",
  "data disabled",
  "data offline",
  "database disabled",
  "database off",
  "database offline",
  "no data",
  "no database",
  "no server",
  "no storage",
  "server disabled",
  "server off",
  "server offline",
  "storage disabled",
  "storage off",
  "storage offline",
  "data inspection",
  "data lookup",
  "data query",
  "data search",
  "database query",
  "database search",
  "disks",
  "explore data",
  "find data",
  "find information",
  "information retrieval",
  "inspect data",
  "search icon",
  "cloud storage upload",
  "database import",
  "dataset",
  "dataset link",
  "linked data",
  "related",
  "relation",
  "relational",
  "table link",
  "calendar event",
  "date range",
  "date_range",
  "period",
  "schedule event",
  "deblur",
  "bereavement",
  "bloom",
  "blossom",
  "cemetery",
  "condolences",
  "death",
  "deceased",
  "died",
  "end of life",
  "flowers",
  "fragility",
  "grave",
  "grief",
  "life cycle",
  "mourning",
  "obituary",
  "passed away",
  "rest in peace",
  "rip",
  "sympathy",
  "tulip",
  "yard",
  "decimal",
  "decrement",
  "fine-tune",
  "fraction",
  "fractions",
  "less",
  "smaller",
  "bigger",
  "decimal point",
  "greater",
  "larger",
  "backyard",
  "chairs",
  "furniture set",
  "lawn",
  "outdoor seating",
  "two chairs",
  "dehaze",
  "haze",
  "interface menu",
  "unhide",
  "website menu",
  "delete_outline",
  "disposal",
  "expunge",
  "garbage can",
  "rub out",
  "waste",
  "wastebasket",
  "delete forever",
  "dustbin",
  "obliterate",
  "permanently delete",
  "remove permanently",
  "trash bin",
  "x mark",
  "cancel history",
  "circular time",
  "clear history",
  "clock with x",
  "delete history",
  "history removal",
  "remove history",
  "time with x",
  "delete many",
  "delete selection",
  "delete_sweep",
  "fast delete",
  "multiple delete",
  "quick delete",
  "delivery truck",
  "electric delivery",
  "fast delivery",
  "quick shipping",
  "rush",
  "sustainable delivery",
  "delivery service",
  "expedite",
  "express delivery",
  "next day delivery",
  "rapid shipping",
  "same day delivery",
  "census",
  "demography",
  "hr",
  "human resources",
  "population",
  "society",
  "content density",
  "density",
  "double space",
  "information density",
  "line spacing",
  "magnification",
  "single space",
  "text density",
  "medium density",
  "density_small",
  "four lines",
  "layout density",
  "visual density",
  "cavity",
  "checkup",
  "dental",
  "dental care",
  "dentist",
  "dentistry",
  "enamel",
  "flossing",
  "gum",
  "implant",
  "molar",
  "oral",
  "root canal",
  "teeth whitening",
  "tooth",
  "toothbrush",
  "veneer",
  "arrival time",
  "bus schedule",
  "coach",
  "departure time",
  "metro",
  "public transit",
  "train schedule",
  "transport schedule",
  "deployed_code",
  "deployment",
  "installed",
  "packet",
  "three-dimensional",
  "artifact",
  "deployed",
  "cicd",
  "containerization",
  "devops",
  "docker",
  "kubernetes",
  "version",
  "deliver",
  "product launch",
  "acne",
  "blackhead",
  "blemish",
  "comedone extractor",
  "cosmetology",
  "derm",
  "dermatology",
  "estetics",
  "esthetics",
  "extraction",
  "facial",
  "follicle",
  "metal",
  "pore",
  "pores",
  "skin",
  "skin care",
  "whitehead",
  "architecture tools",
  "construction tools",
  "design services",
  "design tools",
  "drafting tools",
  "engineering tools",
  "ruler",
  "drawers",
  "home office",
  "line art",
  "minimalist",
  "office furniture",
  "simple desk",
  "three drawers",
  "calling",
  "communication device",
  "desk phone",
  "desk phone icon",
  "dialing",
  "office phone",
  "telephone icon",
  "telephone receiver",
  "computer access disabled",
  "desktop off",
  "monitor disabled",
  "remote access disabled",
  "screen disabled",
  "cloud desktop service",
  "daas",
  "desktop access",
  "desktop as a service",
  "online desktop",
  "remote access",
  "remote desktop",
  "virtual desktop",
  "cloud desktop",
  "cloud infrastructure",
  "virtual machine",
  "virtual workspace",
  "change view",
  "multitasking",
  "second screen",
  "splitscreen",
  "add desktop",
  "add display",
  "add landscape",
  "add screen",
  "add window",
  "create desktop",
  "create display",
  "create landscape",
  "create screen",
  "create window",
  "new desktop",
  "new display",
  "new landscape",
  "new screen",
  "plus desktop",
  "plus display",
  "plus screen",
  "desktop computer",
  "imac",
  "screen rotation",
  "bang",
  "detonate",
  "detonator",
  "dynamite",
  "impact",
  "kaboom",
  "sparkles",
  "additional information",
  "collapse icon",
  "drill down",
  "expand details",
  "expand icon",
  "hide details",
  "show details",
  "submenu",
  "supplementary",
  "detection zone",
  "monitored area",
  "motion detection",
  "person in area",
  "person in zone",
  "zone detection",
  "co",
  "detector",
  "radar",
  "building security",
  "detector alarm",
  "intrusion detection",
  "detector power",
  "device battery",
  "sensor battery",
  "smart sensor",
  "wireless sensor",
  "carbon monoxide",
  "fault",
  "malfunction",
  "not working",
  "ceiling",
  "fire alarm",
  "fire detector",
  "fumes",
  "mount",
  "smoke detector",
  "functional",
  "operational",
  "working",
  "breadboard",
  "circuit",
  "developer board",
  "embedded",
  "microchip",
  "microcontroller",
  "pins",
  "ports",
  "processor",
  "prototype",
  "stem",
  "arduino",
  "board off",
  "circuit board",
  "circuit off",
  "deactivated board",
  "development off",
  "disable board",
  "electronics off",
  "embedded off",
  "hardware off",
  "no board",
  "no electronics",
  "programming off",
  "raspberry pi",
  "stop board",
  "booklet",
  "guideline",
  "handbook",
  "instructions",
  "manual",
  "sdk",
  "developer mode",
  "mobile code",
  "tv code",
  "tv developer mode",
  "tv programming",
  "tv settings",
  "calories",
  "wristband",
  "combining",
  "connected devices",
  "device connection",
  "device link",
  "device network",
  "multiple devices",
  "network hub",
  "celsius",
  "degrees",
  "fahrenheit",
  "home climate control",
  "mercury",
  "smart thermostat",
  "temperature sensor",
  "thermometer",
  "device_unknown",
  "how",
  "mobile_question",
  "troubleshooting",
  "unidentified",
  "what",
  "why",
  "devices",
  "phonelink",
  "tethering",
  "closing",
  "dual screen",
  "foldable",
  "folding",
  "hinge",
  "peel",
  "connection management",
  "disable casting",
  "disable mirroring",
  "disable projection",
  "disable sharing",
  "disabled device",
  "disabled phone",
  "disconnect device",
  "disconnect phone",
  "no casting",
  "no devices",
  "no mirroring",
  "no network",
  "no pairing",
  "no projection",
  "no sharing",
  "remove device",
  "remove phone",
  "stop casting",
  "stop mirroring",
  "stop projection",
  "stop sharing",
  "unpair",
  "accessories",
  "ecosystem",
  "ipad",
  "rounded corner",
  "wearable technology",
  "dew",
  "dew point",
  "dewpoint",
  "droplets",
  "drops",
  "precipitation",
  "saturation",
  "three drops",
  "water vapor",
  "health report",
  "medical report",
  "association",
  "bond",
  "endpoints",
  "ends",
  "oblique",
  "relationship",
  "slanted",
  "slope",
  "dial icon",
  "dialer",
  "handset icon",
  "initiation",
  "internet call",
  "internet telephony",
  "network call",
  "online call",
  "over",
  "session",
  "session initiation protocol",
  "sip",
  "sip icon",
  "voice over ip",
  "voip icon",
  "dialogs",
  "nested boxes",
  "nested squares",
  "talking",
  "dialpad",
  "number pad",
  "pad",
  "pbx",
  "push buttons",
  "ten",
  "tone",
  "touch",
  "crystal",
  "elegant",
  "expensive",
  "facet",
  "gems",
  "gemstone",
  "jewel",
  "jewelry",
  "sparkle",
  "top tier",
  "treasure",
  "valuable",
  "valuables",
  "glossary",
  "lexicon",
  "thesaurus",
  "translation",
  "vocabulary",
  "word",
  "diff",
  "dissimilarity",
  "two files",
  "variation",
  "billboard",
  "digital out of home",
  "digital signage",
  "dooh",
  "interactive",
  "kiosk",
  "outdoor advertising",
  "pedestrian",
  "public display",
  "public space",
  "digital detox",
  "digital wellbeing",
  "harmony",
  "health settings",
  "healthy",
  "healthy lifestyle",
  "mental health",
  "mental health settings",
  "mindfulness",
  "screen time",
  "self-care",
  "spirit",
  "well-being",
  "wellbeing settings",
  "cafeteria",
  "cutlery",
  "diner",
  "eatery",
  "food court",
  "hunger",
  "nutrition",
  "silverware",
  "spoon",
  "supper",
  "table service",
  "dinner time",
  "dish",
  "eat out",
  "italian",
  "noodles",
  "pasta",
  "spaghetti",
  "utensils",
  "change direction",
  "turn right",
  "direction right",
  "directions alternative",
  "directions_alt",
  "alt route off",
  "alternate directions off",
  "alternate route off",
  "directions alt off",
  "directions disabled",
  "gps disabled",
  "gps off",
  "location disabled",
  "location off",
  "map disabled",
  "map off",
  "navigation disabled",
  "no alt route",
  "no alternate route",
  "no directions",
  "no navigation",
  "biker",
  "riding",
  "directions_boat",
  "directions_boat_filled",
  "sail",
  "sailing",
  "watercraft",
  "car icon",
  "estimated time of arrival",
  "eta",
  "front view",
  "time to leave",
  "cancel location",
  "cancel navigation",
  "cancel route",
  "directions off",
  "disable directions",
  "disable gps",
  "disable location",
  "disable navigation",
  "navigation off",
  "no gps",
  "no route",
  "turn off directions",
  "railroad",
  "underground",
  "athlete",
  "jogger",
  "jogging",
  "marathon",
  "moving",
  "race",
  "racing",
  "run",
  "runner",
  "sprint",
  "sprinting",
  "locomotion",
  "metropolitan",
  "tube",
  "underground railway",
  "crosswalk",
  "pedestrian crossing",
  "person walking",
  "stroll",
  "trek",
  "walking man",
  "🚶",
  "syncing",
  "bad photo",
  "blocked lens",
  "blot",
  "camera error",
  "camera malfunction",
  "camera problem",
  "corrupt image",
  "dirty",
  "dirty camera",
  "dirty lens",
  "lens cap",
  "lens problem",
  "obscured lens",
  "obstruction",
  "photo error",
  "photography problem",
  "picture error",
  "smudge",
  "splash",
  "splat",
  "splatter",
  "spot",
  "stain",
  "disabled by default",
  "blocked view",
  "cancel view",
  "circle slash",
  "eye crossed",
  "eye disabled",
  "eye off",
  "eye slash",
  "no view",
  "no visibility",
  "restricted view",
  "show disabled",
  "sight disabled",
  "sight off",
  "unseen",
  "unview",
  "view disabled",
  "view hidden",
  "visibility off",
  "visible",
  "vision disabled",
  "vision off",
  "blu-ray",
  "capacity limit",
  "disk full",
  "disk space",
  "dvd",
  "full disc",
  "full storage",
  "no space",
  "optical disc",
  "optical media",
  "storage capacity",
  "storage full",
  "eq",
  "equalizer",
  "horizontal slider",
  "vertical sliders",
  "appliance control",
  "automatic dishwasher",
  "chore",
  "clean dishes",
  "dishes",
  "dishwasher",
  "kitchen appliance",
  "wash cycle",
  "wash dishes",
  "washer",
  "washing machine",
  "water drop",
  "connect to display",
  "dual monitors",
  "extend display",
  "external device",
  "external input",
  "external output",
  "mirror display",
  "multiple displays",
  "display adjustment",
  "display configuration",
  "display options",
  "here",
  "location services",
  "abstract people",
  "culture",
  "diverse",
  "members",
  "multicultural",
  "partnership",
  "togetherness",
  "unity",
  "belonging",
  "ethnicity",
  "interwoven",
  "connected group",
  "user group",
  "empathy",
  "humanity",
  "non-profit",
  "respect",
  "tolerance",
  "dns",
  "domain",
  "it",
  "nameserver",
  "resolve",
  "two rectangles",
  "alerts on",
  "allow alerts",
  "allow disturbances",
  "allow notifications",
  "allow sounds",
  "deny",
  "dnd off",
  "do",
  "do disturb off",
  "do not disturb off",
  "focus off",
  "notifications on",
  "quiet mode off",
  "remove restriction",
  "ringer on",
  "silence off",
  "sleep off",
  "sounds on",
  "unmute",
  "unrestricted",
  "volume on",
  "work off",
  "circle outline",
  "not",
  "alarms off",
  "ban",
  "busy",
  "complete silence",
  "interruptions off",
  "no alerts",
  "no notifications",
  "notification settings",
  "on total",
  "phone settings",
  "ringer off",
  "silent mode",
  "sound off",
  "sound settings",
  "total silence",
  "volume off",
  "do not enter",
  "do not step",
  "keep off",
  "no step",
  "no stepping",
  "no trespassing",
  "shoe",
  "slanted line",
  "sneaker",
  "stepping",
  "do not touch",
  "don't touch",
  "hands off",
  "keep out",
  "no touch",
  "off limits",
  "unauthorized",
  "peripheral",
  "dock to bottom",
  "shelf",
  "snap",
  "taskbar",
  "ui element",
  "dock to left",
  "left dock",
  "screen layout",
  "side panel",
  "split screen",
  "window management",
  "app layout",
  "application layout",
  "dock right",
  "interface layout",
  "position right",
  "right dock",
  "right panel",
  "right sidebar",
  "view arrangement",
  "docs",
  "add-on",
  "addon",
  "extension",
  "OCR",
  "digitize document",
  "document capture",
  "document scan",
  "optical character recognition",
  "scan document",
  "document icon",
  "document search",
  "explore document",
  "file icon",
  "file search",
  "find document",
  "find page",
  "inspect document",
  "loupe",
  "magnifying glass on document",
  "search file",
  "search page",
  "corporation",
  "headquarters",
  "add domain",
  "company registration",
  "create domain",
  "domain creation",
  "domain registration",
  "domain setup",
  "new domain",
  "web address",
  "domain inactive",
  "suspend",
  "website disabled",
  "application desktop",
  "domain security",
  "domain validated",
  "https",
  "ssl",
  "tls",
  "validated",
  "website security",
  "invalid",
  "costume",
  "disguise",
  "domino",
  "domino mask",
  "eye mask",
  "incognito",
  "masquerade",
  "secret",
  "superhero",
  "unmask",
  "villain",
  "checkmarks",
  "complete all",
  "completed tasks",
  "done all",
  "double check",
  "finish all",
  "ticks",
  "check outline",
  "thin checkmark",
  "donut_large",
  "doughnut chart",
  "hole",
  "two-part",
  "donut_small",
  "doughnut",
  "part",
  "door knob",
  "front door",
  "single door",
  "door frame",
  "entryway",
  "open door",
  "passage",
  "breach",
  "building automation",
  "door sensor",
  "intrusion",
  "automatic door",
  "double door",
  "elevator",
  "partition",
  "sliding",
  "sliding door",
  "two doors",
  "doorbell",
  "guest",
  "3 people",
  "doorbell_3p",
  "fast forward",
  "fast skip",
  "alpine skiing",
  "athletic",
  "downhill",
  "downhill skiing",
  "ski social",
  "skier",
  "skiing",
  "skis",
  "slopes",
  "downloads",
  "file download",
  "get app",
  "resource",
  "save alt",
  "save icon",
  "download complete",
  "download done",
  "download finished",
  "download successful",
  "file complete",
  "file downloaded",
  "file finished",
  "import complete",
  "import finished",
  "save complete",
  "save finished",
  "available offline",
  "device storage",
  "download for offline",
  "for offline",
  "keep",
  "local storage",
  "offline access",
  "offline use",
  "offline viewing",
  "save offline",
  "acquisition",
  "content download",
  "digital asset",
  "downloading",
  "order processing",
  "orders",
  "preliminary",
  "unfinished",
  "compose message",
  "drafts",
  "drag click",
  "selects",
  "application ui",
  "drag and drop",
  "drag handle",
  "draggable",
  "reorder",
  "drag indicator",
  "grabber",
  "manipulator",
  "six circles",
  "three by two",
  "vertical dots",
  "directional arrows",
  "four directions",
  "map navigation",
  "move tool",
  "pan tool",
  "screen navigation",
  "with",
  "annotate",
  "doodle",
  "freehand",
  "handwriting",
  "illustrate",
  "scribble",
  "stylus",
  "abstraction",
  "artwork",
  "squiggle",
  "abstract shape",
  "glue",
  "bedroom furniture",
  "bureau",
  "chest of drawers",
  "decor",
  "dresser",
  "home furnishings",
  "sideboard",
  "content migration",
  "data migration",
  "folder transfer",
  "migrate",
  "relocate",
  "drive folder",
  "folder drive",
  "folder upload",
  "upload cloud",
  "upload folder",
  "choose color",
  "color picker",
  "color selector",
  "copy color",
  "element selection",
  "extract color",
  "identify color",
  "inspect color",
  "inspect element",
  "observe",
  "sample color",
  "select element",
  "air dry",
  "arid",
  "dehydration",
  "desert",
  "dry hands",
  "dryer",
  "drying",
  "evaporate",
  "hand dryer",
  "no water",
  "thermal",
  "vapor",
  "clothes care",
  "dry cleaning",
  "dry cleaning service",
  "dryclean",
  "garment care",
  "laundry",
  "laundry service",
  "towel",
  "valet",
  "valet service",
  "application window",
  "dual monitor",
  "duo",
  "extended display",
  "multiple monitors",
  "screen extend",
  "screens",
  "two monitors",
  "two screens",
  "waterdrop",
  "bullets",
  "digital video recorder",
  "dvr",
  "'mail_outline'",
  "'markunread'. Keep 'mail' and remove others.",
  "Duplicate of 'email'",
  "atom",
  "dynamic feed",
  "rss",
  "dynamic form",
  "efficient",
  "fields",
  "communication alert",
  "contact emergency",
  "emergency call",
  "phone alert",
  "telephone notification",
  "urgent call",
  "beacon",
  "emergency light",
  "first responder",
  "flashing",
  "police",
  "2g",
  "e",
  "letter e",
  "cellular indicator",
  "connection badge",
  "data badge",
  "mobile badge",
  "mobile indicator",
  "network badge",
  "network indicator",
  "aids",
  "amplify",
  "ear",
  "earbud",
  "headphone",
  "headset",
  "hearing aids",
  "listening",
  "mono",
  "sound on",
  "soundwave",
  "charging case",
  "earbud case",
  "earbuds",
  "earphone",
  "earphones",
  "open case",
  "tech",
  "audio device",
  "audio input",
  "earbud left",
  "handsfree",
  "in-ear",
  "left earbud",
  "left side",
  "listening device",
  "single earbud",
  "sound device",
  "earbud right",
  "right ear",
  "right earbud",
  "audio controls",
  "headphone jack",
  "listen to music",
  "music controls",
  "earbuds_2",
  "in-ear headphones",
  "portable audio",
  "wireless earbuds",
  "earbuds battery",
  "headphone battery",
  "early",
  "soon",
  "timely",
  "aftershock",
  "catastrophe",
  "earth",
  "earthquake",
  "fault line",
  "geology",
  "geophysics",
  "ground motion",
  "plates",
  "preparedness",
  "seismic",
  "seismograph",
  "shake",
  "tectonic",
  "tremor",
  "ahead",
  "directional",
  "further",
  "onwards",
  "orient",
  "rightward",
  "waveform",
  "heart rhythm",
  "lifeline",
  "botanical",
  "conservation",
  "eco icon",
  "eco-friendly",
  "economical",
  "environment protection",
  "leaf icon",
  "biometric",
  "eda",
  "electrodermal",
  "electrodermal activity responses",
  "electrodermal responses",
  "open hand",
  "thumb",
  "edge sensor",
  "high alert",
  "mobile sensor",
  "vibrate",
  "auxiliary",
  "auxiliary sensor",
  "flanking",
  "flanking sensors",
  "limited range",
  "short range",
  "side bars",
  "side sensors",
  "supplementary sensor",
  "compose mode",
  "edit mode",
  "elevate",
  "shift up",
  "attributes",
  "edit attributes",
  "properties",
  "adjust sound",
  "audio adjust",
  "audio editing",
  "change sound",
  "edit audio",
  "edit sound",
  "horizontal arrows",
  "modify sound",
  "music editing",
  "scrub",
  "sound adjust",
  "sound controls",
  "sound editing",
  "timing",
  "change date",
  "e appointment",
  "edit calendar",
  "edit date",
  "modify event",
  "reschedul",
  "update schedule",
  "compose document",
  "document editing",
  "edit document",
  "edit file",
  "file edit",
  "file editing",
  "modify document",
  "revise document",
  "update document",
  "change location",
  "edit location",
  "edit marker",
  "edit pin",
  "edit place",
  "location editing",
  "map edit",
  "map marker edit",
  "modify location",
  "place edit",
  "update location",
  "edit gps",
  "edit map",
  "edit navigation",
  "edit pinpoint",
  "edit pointer",
  "edit position",
  "map pin",
  "edit text",
  "memo",
  "note taking",
  "taking notes",
  "writing tool",
  "alert settings",
  "change notification",
  "edit notification",
  "modify notification",
  "notification preferences",
  "pen icon",
  "pencil icon",
  "reminder settings",
  "update notification",
  "cancel edit",
  "cancel pencil",
  "cancel writing",
  "disable edit",
  "disable pencil",
  "disable writing",
  "edit off",
  "editing disabled",
  "no edit",
  "no pencil",
  "no writing",
  "pencil off",
  "read only",
  "remove edit",
  "writing off",
  "change road",
  "edit road",
  "edit route",
  "modify road",
  "plan route",
  "roadwork",
  "update road",
  "annotations",
  "edit square",
  "markup",
  "pencil square",
  "square edit",
  "editor choice",
  "editor pick",
  "editor's choice",
  "editor's pick",
  "recommendation",
  "recommended",
  "top pick",
  "win",
  "baking",
  "bird",
  "chicken",
  "diet",
  "easter",
  "egg",
  "ellipse",
  "ingredient",
  "new life",
  "yolk",
  "blob",
  "fried egg",
  "external storage",
  "pop out",
  "pop-out",
  "push out",
  "push-out",
  "elder",
  "geriatric",
  "old",
  "pensioner",
  "retiree",
  "retirement",
  "social security",
  "elderly care",
  "girl",
  "grandma",
  "grandmother",
  "grandparent",
  "lady",
  "retired",
  "senior citizen",
  "women",
  "e-bike",
  "ebike",
  "electric bike",
  "motorized bicycle",
  "pedal assist",
  "electric icon",
  "electric power",
  "electric shock",
  "electricity symbol",
  "energy symbol",
  "lightning bolt symbol",
  "power symbol",
  "thunder",
  "charge station",
  "electric car",
  "electric station",
  "ampere",
  "consumption",
  "electric meter",
  "kilowatts",
  "two legs",
  "volts",
  "watts",
  "eco friendly",
  "electric charge",
  "electric moped",
  "green transport",
  "ride sharing",
  "sustainable transport",
  "auto rickshaw",
  "battery powered",
  "cab",
  "electric auto",
  "electric rickshaw",
  "electric transport",
  "rickshaw",
  "taxi",
  "three wheeler",
  "tuk tuk",
  "zero emission",
  "dockless",
  "handlebar",
  "micro-mobility",
  "personal mobility",
  "urban transport",
  "ac power",
  "dc power",
  "electrical",
  "electrical services",
  "electrical work",
  "electrician",
  "hill",
  "hills",
  "incline",
  "inclines",
  "ramp",
  "tiers",
  "building navigation",
  "conveyance",
  "floor",
  "vertical transport",
  "six pointed star",
  "boiler",
  "emergency heat",
  "furnace",
  "heat alert",
  "house fire",
  "overheat",
  "auxiliary heat",
  "extreme temperature",
  "heat waves",
  "high temperature",
  "temperature warning",
  "wavy",
  "emergency services",
  "evidence",
  "coordinates",
  "drop a pin",
  "emergency location",
  "find my location",
  "location sharing",
  "share location",
  "broadcast off",
  "disable emergency",
  "emergency sharing off",
  "find off",
  "locate off",
  "no location",
  "no share",
  "pin off",
  "share off",
  "sharing off",
  "coaster",
  "drink menu",
  "herbal tea",
  "hot beverage menu",
  "infusion",
  "refreshment",
  "tea bag",
  "tea time",
  "teacup",
  "warm beverage",
  "abroad",
  "dialect",
  "foreign language",
  "global communication",
  "intercultural",
  "internationalization",
  "keyboards",
  "localization",
  "multilingual",
  "worldwide",
  "bee",
  "daisy",
  "floral",
  "honey",
  "ladybug",
  "meadow",
  "petals",
  "pollination",
  "wings",
  "creative",
  "emoji_objects",
  "filament",
  "inspiration",
  "invention",
  "objects",
  "solution",
  "suggestion",
  "arm",
  "hello",
  "hi",
  "raised hand",
  "waving",
  "ampersand",
  "and",
  "equal sign",
  "glyph",
  "hieroglyph",
  "symbols",
  "cityscape",
  "town",
  "feeling",
  "flirt",
  "kind",
  "nice",
  "satisfied",
  "tease",
  "wink",
  "winking",
  "empty state",
  "engage",
  "startup",
  "cybersecurity",
  "encrypted",
  "information security",
  "keyhole",
  "latch",
  "lock and key",
  "safeguard",
  "system security",
  "add encrypted",
  "add encryption",
  "add privacy",
  "add protection",
  "add security",
  "enhance security",
  "increase security",
  "new encryption",
  "new security",
  "plus privacy",
  "plus protection",
  "plus security",
  "add account",
  "add safe",
  "add safety",
  "increase privacy",
  "new user",
  "decrypt",
  "disable encryption",
  "encryption off",
  "remove encryption",
  "unencrypted",
  "decrypted",
  "disable security",
  "exposed",
  "insecure",
  "lock off",
  "no encryption",
  "no security",
  "protection off",
  "security off",
  "shield off",
  "unlocked",
  "adrenal gland",
  "double curve",
  "endocrine system",
  "endocrinology",
  "gland",
  "glands",
  "hormone therapy",
  "hormones",
  "insulin",
  "m shape",
  "metabolism",
  "neck",
  "pancreas",
  "pituitary gland",
  "reproduction",
  "rounded shape",
  "sexual health",
  "specialist",
  "stylized",
  "throat",
  "thyroid",
  "alternative energy",
  "blades",
  "clean energy",
  "generator",
  "green energy",
  "propeller",
  "renewable energy",
  "sustainable energy",
  "turbine",
  "wind energy",
  "wind power",
  "windmill",
  "eco mode",
  "energy efficiency",
  "energy program",
  "lower consumption",
  "reduce energy",
  "save energy",
  "warranty",
  "used",
  "energy conservation",
  "energy consumption",
  "energy performance",
  "energy savings",
  "optimize energy",
  "fixing",
  "hardhat",
  "helmet",
  "labor",
  "occupation",
  "profession",
  "technician",
  "worker",
  "enhanced encryption",
  "reinforced",
  "stronger security",
  "vault",
  "chin",
  "letter f",
  "nose",
  "profile picture",
  "think",
  "wisdom",
  "consulting",
  "operations",
  "deactivate enterprise",
  "no business",
  "no company",
  "no enterprise",
  "no job",
  "no office",
  "no work",
  "equivalent",
  "identical",
  "matching",
  "mathmatical",
  "same",
  "adjust frequency",
  "audio control",
  "audio frequency",
  "audio levels",
  "music control",
  "music settings",
  "sound control",
  "sound frequency",
  "sound levels",
  "sound wave",
  "static",
  "volume control",
  "drawing tool",
  "eraser",
  "line weight",
  "strokes",
  "thickness",
  "whiteboard",
  "mistake",
  "rubber",
  "thick",
  "big",
  "brush size",
  "design tool",
  "size 5",
  "fail",
  "incorrect",
  "oops",
  "uh oh",
  "notice",
  "zig-zag",
  "electric stairs",
  "escalator",
  "mall",
  "moving stairs",
  "moving walkway",
  "staircase",
  "stairs",
  "beware",
  "holding hands",
  "eu",
  "euro",
  "europe",
  "european union",
  "euros",
  "open c",
  "€",
  "telematics",
  "vehicle connectivity",
  "eclipse",
  "greyscale",
  "grill",
  "shadow",
  "tonality",
  "transparency",
  "augment",
  "diminish",
  "ev charger",
  "ev station",
  "fuel",
  "refill",
  "invitation",
  "occasion",
  "special day",
  "booked",
  "busy day",
  "cancel event",
  "decline event",
  "event conflict",
  "occupied",
  "remove event",
  "scheduling conflict",
  "unavailable date",
  "appointments",
  "camerazilla",
  "entries",
  "event list",
  "list view",
  "reminders",
  "two squares",
  "calendar note",
  "date note",
  "event note",
  "schedule note",
  "monthly",
  "recurrence",
  "recurring appointment",
  "recurring event",
  "recurring task",
  "yearly",
  "assigned",
  "attendee",
  "event_seat",
  "venue",
  "attend",
  "calendar entry",
  "import event",
  "participate",
  "upcoming",
  "high priority",
  "severity",
  "athletics",
  "barbell",
  "bodybuilding",
  "dumbbell",
  "lifestyle",
  "lifting",
  "weightlifting",
  "weights",
  "exit app",
  "external application",
  "leave app",
  "open app",
  "open in new",
  "expand arrows",
  "dropdown icon",
  "expand collapse",
  "open all",
  "open icon",
  "reveal icon",
  "show icon",
  "unfold icon",
  "expand circle",
  "expand content",
  "expand down",
  "v shape",
  "arrow button",
  "circle icon",
  "expand button",
  "expand right",
  "navigation button",
  "right arrow button",
  "fullscreen icon",
  "maximize icon",
  "expansion panel",
  "analysis icon",
  "beaker",
  "beaker icon",
  "chemical icon",
  "chemistry icon",
  "conical flask",
  "conical flask icon",
  "erlenmeyer flask",
  "erlenmeyer flask icon",
  "experiment icon",
  "flask",
  "flask icon",
  "lab icon",
  "research icon",
  "science icon",
  "scientific",
  "scientific icon",
  "test icon",
  "explicit",
  "initial e",
  "compass icon",
  "explore icon",
  "explore nearby",
  "local search",
  "locartion",
  "nearby",
  "neighborhood",
  "poi",
  "point of interest",
  "adventure off",
  "compass off",
  "direction off",
  "discovery off",
  "expedition off",
  "exploration off",
  "explore disabled",
  "explore off",
  "guide off",
  "no explore",
  "roam off",
  "search off",
  "sightseeing off",
  "tour off",
  "track off",
  "trail off",
  "travel off",
  "trip off",
  "wander off",
  "fireworks",
  "pow",
  "radiate",
  "shockwave",
  "spark",
  "import/export",
  "iso",
  "darken",
  "exposure compensation",
  "exposure value",
  "minus one",
  "neg",
  "negative one",
  "underexpose",
  "-2",
  "level down",
  "minus two",
  "negative two",
  "add one",
  "exposure plus one",
  "increase by one",
  "increment one",
  "plus one",
  "+2",
  "brighter",
  "ev+2",
  "increase exposure",
  "lighten",
  "plus two",
  "two levels",
  "two steps",
  "functionality",
  "jigsaw",
  "plugin add",
  "addon off",
  "deactivate addon",
  "deactivate extension",
  "deactivate plugin",
  "disable addon",
  "disable extension",
  "disable plugin",
  "extension off",
  "no addon",
  "no extension",
  "no plugin",
  "plugin off",
  "puzzle piece",
  "remove addon",
  "remove extension",
  "remove plugin",
  "uninstall",
  "uninstall addon",
  "uninstall extension",
  "uninstall plugin",
  "eye scan",
  "eye tracking",
  "gaze",
  "motion sensor",
  "eye protection",
  "eyeglasses",
  "eyesight",
  "eyewear",
  "geek",
  "glasses",
  "lenses",
  "nerd",
  "optical",
  "professor",
  "reading glasses",
  "specs",
  "spectacles",
  "sunglasses",
  "teacher",
  "optic",
  "view mode",
  "face unlock",
  "facial scan",
  "simple face",
  "face 2",
  "bangs",
  "expressionless",
  "fringe",
  "generic",
  "bun",
  "demographic",
  "double bun",
  "female user",
  "girl avatar",
  "woman profile",
  "bald",
  "balding",
  "forehead",
  "mesh",
  "scalp",
  "blank face",
  "default profile",
  "emotionless",
  "face 6",
  "generic person",
  "avatar down",
  "face down",
  "face forward",
  "gestures",
  "head down",
  "looking down",
  "person down",
  "profile down",
  "user down",
  "acknowledgment",
  "body language",
  "nod",
  "nonverbal",
  "rotate head",
  "understood",
  "authentic look",
  "beauty filter off",
  "beauty mode off",
  "cosmetic edits off",
  "disable filter",
  "disable retouching",
  "editing off",
  "edits off",
  "enhancements off",
  "face adjustments off",
  "face retouch disabled",
  "face retouching off",
  "faces",
  "filter off",
  "filters disabled",
  "image editing off",
  "natural face",
  "no cosmetic filters",
  "no edits",
  "no face retouch",
  "no filter",
  "no retouching",
  "original face",
  "photo editing off",
  "portrait retouching off",
  "raw image",
  "retouch",
  "retouch off",
  "retouching",
  "selfie retouching off",
  "unedited photo",
  "unretouched",
  "untouched",
  "follower",
  "disagree",
  "oscillate",
  "refuse",
  "side to side",
  "wobble",
  "account picture",
  "face up",
  "upload avatar",
  "upload face",
  "upload photo",
  "upload profile",
  "user upload",
  "fact",
  "fact check",
  "fact checking",
  "fact-check",
  "true",
  "assembly",
  "fabrication",
  "factory building",
  "heavy industry",
  "industrial building",
  "industrial plant",
  "industrial production",
  "light industry",
  "manufacturing facility",
  "manufacturing plant",
  "production facility",
  "production plant",
  "smokestack",
  "awkward",
  "clumsiness",
  "descent",
  "downwards",
  "fall",
  "falling",
  "falling down",
  "falling over",
  "gravity",
  "imbalance",
  "lose balance",
  "person falling",
  "slip",
  "stumble",
  "tumbling",
  "familiar",
  "guided frame",
  "ancestors",
  "ancestry",
  "family structure",
  "heritage",
  "lineage",
  "pedigree",
  "root",
  "tree structure",
  "family home",
  "family house",
  "family values",
  "heart home",
  "home heart",
  "home love",
  "home sweet home",
  "house heart",
  "love house",
  "loved ones",
  "my home",
  "safe place",
  "sweet home",
  "kite",
  "kiting",
  "string",
  "tail",
  "all gender",
  "family symbol",
  "gender neutral",
  "men",
  "parent and child",
  "stick figures",
  "unisex",
  "clan",
  "concentrate",
  "fan focus",
  "specific",
  "targeted",
  "three arrows",
  "triple arrow",
  "air distribution",
  "bounce",
  "deflect",
  "disperse",
  "down arrows",
  "36",
  "digital clock",
  "digital display",
  "digital time",
  "farsight",
  "thirty-six",
  "double triangle",
  "fastforward",
  "jump",
  "skip forward",
  "two triangles",
  "audio player",
  "fast rewind",
  "music player",
  "skip back",
  "burger",
  "cheeseburger",
  "combo",
  "fast food meal",
  "fastfood",
  "quick service",
  "soda",
  "soft drink",
  "straw",
  "pipe",
  "running water",
  "spout",
  "washbasin",
  "add to favourites",
  "dating",
  "favourite",
  "heart outline",
  "remove from favorites",
  "remove from favourites",
  "unfavourite",
  "unlike",
  "valentine's day",
  "legacy",
  "outdated",
  "receive fax",
  "send fax",
  "characteristic",
  "examine",
  "highlighted",
  "bonus",
  "bow",
  "gift",
  "gifts",
  "giveaway",
  "seasonal",
  "surprise",
  "advertised",
  "featured video",
  "spotlight",
  "delivery failed",
  "failed",
  "sending failed",
  "undelivered",
  "biological sex",
  "female symbol",
  "feminine",
  "ladies' room",
  "sex",
  "venus",
  "venus symbol",
  "women's restroom",
  "body part",
  "bone health",
  "bone structure",
  "bones",
  "calcium",
  "dinosaur",
  "dog bone",
  "femur",
  "fossil",
  "fracture",
  "hip",
  "joint",
  "knee",
  "limb",
  "orthopedic",
  "osteology",
  "skeletal system",
  "skeleton",
  "thigh bone",
  "bone scan",
  "bone symbol",
  "femur_alt",
  "orthopedics",
  "skeletal",
  "thigh",
  "x-ray",
  "barrier",
  "boundaries",
  "boundary line",
  "fence",
  "grass",
  "limits",
  "paling",
  "picket fence",
  "suburban",
  "three peaks",
  "botany",
  "cracked",
  "fertile",
  "horticulture",
  "menstrual",
  "opening",
  "ovulation",
  "potential",
  "seed",
  "u shape",
  "booth",
  "circus",
  "marquee",
  "pavilion",
  "stall",
  "tradition",
  "fiber",
  "live tv",
  "personal video recorder",
  "pvr",
  "record show",
  "set top box",
  "stb",
  "timeshift",
  "audio record",
  "filled circle",
  "hollow circle",
  "radio button",
  "video record",
  "voice record",
  "latest",
  "wordmark",
  "pushpin",
  "tack",
  "thumbtack",
  "double circle",
  "open circle",
  "smart record",
  "smart recording",
  "copy document",
  "copy file",
  "copy page",
  "document copy",
  "document duplicate",
  "duplicate file",
  "file copy",
  "file duplicate",
  "page copy",
  "two pages",
  "cancel copy",
  "copy disabled",
  "disable copy",
  "document restriction",
  "file restriction",
  "no copy",
  "no duplicate",
  "prevent copy",
  "remove copy",
  "stop copy",
  "block download",
  "cancel download",
  "download off",
  "export off",
  "file download off",
  "get file off",
  "import off",
  "no download",
  "no file download",
  "no files",
  "prevent download",
  "receive file off",
  "restrict download",
  "save disabled",
  "stop download",
  "transfer disabled",
  "interchange",
  "key-value",
  "geo data",
  "location file",
  "map file",
  "atlas",
  "cartography",
  "geospatial",
  "choose file",
  "open file",
  "select file",
  "bitmap",
  "image file",
  "lossless",
  "png",
  "portable network graphics",
  "discovered",
  "existing",
  "file_present",
  "horseshoe",
  "located",
  "u",
  "download file",
  "file save",
  "floppy",
  "preserve",
  "save file",
  "file_save_off",
  "no save",
  "blocked import",
  "blocked upload",
  "cancel import",
  "cancel upload",
  "cloud upload disabled",
  "cloud upload off",
  "disable cloud upload",
  "disable import",
  "disable send",
  "disable transfer",
  "disable upload",
  "file upload disabled",
  "file upload off",
  "forbidden import",
  "forbidden upload",
  "import disabled",
  "no import",
  "no send",
  "no transfer",
  "no upload",
  "send disabled",
  "send off",
  "transfer off",
  "upload off",
  "filter_1",
  "number one",
  "sorting",
  "filter criteria",
  "filter settings",
  "filter_2",
  "layered filter",
  "multiple filters",
  "parameters",
  "refine options",
  "stacking",
  "two filters",
  "sift",
  "filter options",
  "four filters",
  "refine results",
  "filter 5",
  "number five",
  "filter 6",
  "number 6",
  "number eight",
  "9 and over",
  "9+",
  "adult content",
  "age rating",
  "child protection",
  "content filter",
  "family filter",
  "inappropriate content",
  "kids filter",
  "mature content",
  "nine and up",
  "nine plus",
  "over 9",
  "safe search",
  "data filter",
  "filter_alt",
  "filtering",
  "funnel shape",
  "inverted triangle",
  "results filter",
  "search filter",
  "strain",
  "disable funnel",
  "disable options",
  "disable refine",
  "disable sort",
  "filter disabled",
  "funnel disabled",
  "no funnel",
  "no options",
  "no refine",
  "no sort",
  "options disabled",
  "options off",
  "refine disabled",
  "refine off",
  "remove filter",
  "remove funnel",
  "remove options",
  "remove refine",
  "remove sort",
  "sort disabled",
  "sort off",
  "apply filter",
  "arrow right",
  "filter next",
  "filter right",
  "funnel right",
  "b&w",
  "black and white",
  "filter_b_and_w",
  "monochrome",
  "w",
  "cloud shape",
  "content filtering",
  "drama filter",
  "sky camera",
  "theatrical",
  "tragedy",
  "boarders",
  "filter frames",
  "filtering options",
  "media editing",
  "video filter",
  "hdr",
  "high dynamic range",
  "filter_list",
  "clear filter",
  "clear funnel",
  "filter delete",
  "filter remove",
  "funnel delete",
  "funnel remove",
  "hide filter",
  "hide funnel",
  "display all",
  "filter none",
  "no restrictions",
  "reset filter",
  "lux",
  "retrolux",
  "diorama",
  "diorama effect",
  "miniature",
  "miniature effect",
  "tilt",
  "tilt shift",
  "tilt shift effect",
  "tilt-shift",
  "decorative",
  "ornamentation",
  "petal",
  "sieve",
  "axis",
  "revenue",
  "stocks",
  "pill shape",
  "poker chip",
  "stake",
  "finance mode",
  "financial report",
  "explore page",
  "find in document",
  "find in page",
  "find text",
  "page search",
  "search document",
  "search text",
  "find and replace",
  "search and replace",
  "finger",
  "fingerprint",
  "loops",
  "ridges",
  "thumbprint",
  "touch id",
  "whorls",
  "biometric off",
  "biometrics",
  "biometrics disabled",
  "disable fingerprint",
  "fingerprint disabled",
  "fingerprint login",
  "fingerprint off",
  "fingerprint scan",
  "no fingerprint",
  "remove fingerprint",
  "touch id off",
  "building safety",
  "canister",
  "emergency equipment",
  "extinguisher",
  "fire control",
  "fire extinguisher",
  "fire hazard",
  "fire safety",
  "firefighting",
  "hose",
  "nozzle",
  "office safety",
  "put out fire",
  "rescue",
  "stop fire",
  "suppressant",
  "tank",
  "workplace safety",
  "fire hydrant",
  "firefighter",
  "fireplug",
  "hydrant",
  "municipal",
  "blaze",
  "emergency service",
  "fire department",
  "fire truck",
  "fireman",
  "firetruck",
  "flames",
  "ladder",
  "ladder truck",
  "burning",
  "cozy",
  "ember",
  "fireplace",
  "hearth",
  "ignite",
  "pit",
  "wood burning",
  "angled line",
  "earliest",
  "form control",
  "go to beginning",
  "jump to start",
  "page 1",
  "page one",
  "very beginning",
  "expand to fit",
  "fit page",
  "fit to height",
  "fit to page",
  "full page",
  "horizontal fit",
  "page break",
  "scale to fit",
  "shrink to fit",
  "vertical fit",
  "zoom to fit",
  "fit height",
  "page height",
  "tall",
  "fit content",
  "fit page width",
  "page formatting",
  "resize page",
  "resize width",
  "scale to page",
  "scale to width",
  "zoom to page",
  "zoom to width",
  "expand to screen",
  "fit screen",
  "container fit",
  "content fit",
  "fit width",
  "frame fit",
  "image fit",
  "maximize width",
  "text fit",
  "window fit",
  "exercise equipment",
  "fitness center",
  "fitness equipment",
  "gym equipment",
  "flag outline",
  "outlined flag",
  "flag_2",
  "flag post",
  "flagpole",
  "objective",
  "flag in circle",
  "erratic",
  "flaky",
  "inconsistent",
  "intermittent",
  "irregular",
  "maybe",
  "patchy",
  "sporadic",
  "undependable",
  "unpredictable",
  "unreliable",
  "unstable",
  "dazzle",
  "flare",
  "glimmer",
  "glitter",
  "glowing",
  "radiating",
  "ray",
  "shimmer",
  "shining",
  "sunburst",
  "automatic flash",
  "flash auto mode",
  "flash photography",
  "energy off",
  "flash_off",
  "no bolt",
  "no electricity",
  "no flash",
  "no lightning",
  "no lightning bolt",
  "no thunderstorm",
  "photography settings",
  "flash on",
  "instantaneous",
  "flashlight",
  "flashlight off",
  "lamp",
  "no flashlight",
  "no light",
  "no torch",
  "switch off",
  "torch off",
  "activated",
  "flashlight on",
  "torch on",
  "flatware",
  "knife",
  "place setting",
  "restaurant menu",
  "table setting",
  "flex direction",
  "layouts",
  "3x3",
  "fixed size",
  "fixed width",
  "inflexible",
  "inflexible layout",
  "line break",
  "no overflow",
  "no wrap",
  "nowrap",
  "rigid",
  "text flow",
  "three boxes",
  "word wrap",
  "6x6",
  "flex wrap",
  "reflow",
  "text wrap",
  "wraparound",
  "airfare",
  "fuselage",
  "holidays",
  "jet",
  "overhead view",
  "downgrade",
  "flight class",
  "in-flight",
  "airplane arrival",
  "airplane landing",
  "airport icon",
  "approaching",
  "arrive",
  "arriving",
  "coming down",
  "departing",
  "flight arrival",
  "incoming flight",
  "landing",
  "plane landing",
  "runway",
  "touchdown",
  "airborne",
  "embark",
  "flight path",
  "takeoff",
  "flight booking",
  "hotel reservation",
  "hotels",
  "leisure travel",
  "travel and hotel",
  "trip planning",
  "vacation planning",
  "scan scanning",
  "transpose",
  "backside",
  "detached window",
  "float",
  "floating panel",
  "floating window",
  "popout",
  "separate window",
  "undock",
  "deluge",
  "flood",
  "flood zone",
  "flooded house",
  "flooding",
  "heavy rain",
  "inundation",
  "property damage",
  "sinking",
  "sinking house",
  "submerged",
  "torrential rain",
  "floors",
  "four levels",
  "four steps",
  "multi-level",
  "storey",
  "fixture",
  "floor ",
  "floor lamp",
  "standing lamp",
  "data flow",
  "flowsheet",
  "information flow",
  "procedure",
  "fluids",
  "karaoke",
  "voice input",
  "voice memo",
  "fluid balance",
  "fluid intake",
  "hydration",
  "intake",
  "intravenous",
  "iv",
  "medical chart",
  "therapy",
  "dose",
  "injection",
  "syringe",
  "vaccination",
  "vaccine",
  "flourescent",
  "fluorescent",
  "iridescent",
  "tungsten",
  "wb_iridescent",
  "abstract arrow",
  "application development",
  "cross-platform",
  "dart",
  "flutter",
  "google flutter",
  "software development kit",
  "stylized arrow",
  "ui toolkit",
  "beak",
  "cute",
  "owl",
  "penguin",
  "whimsical",
  "autobahn",
  "bypass",
  "expressway",
  "flyover",
  "freeway",
  "motorway",
  "overpass",
  "ramps",
  "road bridge",
  "thruway",
  "turnpike",
  "bad",
  "fmd",
  "location alert",
  "map warning",
  "clouds",
  "cloudy with fog",
  "evening fog",
  "foggy",
  "hazy",
  "low visibility",
  "morning fog",
  "partly cloudy",
  "folded hands",
  "mosque",
  "namaste",
  "peace",
  "please",
  "praying hands",
  "temple",
  "wish",
  "archive folder",
  "contents",
  "directory icon",
  "documents folder",
  "file folder",
  "folder icon",
  "check folder",
  "folder check",
  "folder complete",
  "folder confirmed",
  "folder verified",
  "code brackets",
  "code directory",
  "development folder",
  "folder symbol",
  "programming folder",
  "repository folder",
  "script folder",
  "scripts",
  "source folder",
  "archive management",
  "copy folder",
  "duplicate folder",
  "folder copy",
  "multiple folders",
  "two folders",
  "data folder",
  "folder connection",
  "folder data",
  "folder structure",
  "linked folder",
  "organize data",
  "shared folder",
  "delete folder",
  "delete icon",
  "folder delete",
  "folder removal",
  "remove folder",
  "trash folder",
  "trash icon",
  "directory access",
  "directory view",
  "file access",
  "file view",
  "folder access",
  "folder view",
  "peek",
  "preview",
  "reveal hidden files",
  "show hidden files",
  "details view",
  "directory information",
  "file help",
  "file info",
  "file properties",
  "folder details",
  "folder help",
  "folder properties",
  "get info",
  "lowercase i",
  "metadata",
  "question mark symbol",
  "file permission",
  "folder restriction",
  "limited access",
  "permissions",
  "restricted folder",
  "directory management",
  "directory options",
  "directory settings",
  "folder options",
  "folder settings",
  "archives",
  "copying",
  "directories",
  "duplicating",
  "block folder",
  "cancel folder",
  "disable folder",
  "folder disabled",
  "folder inactive",
  "folder off",
  "folder unavailable",
  "hide folder",
  "no folder",
  "file browser",
  "file explorer",
  "folder open",
  "open folder",
  "contribute folder",
  "folder share",
  "folder sharing",
  "folder user",
  "shared",
  "shared directory",
  "user folder",
  "marked",
  "oversee",
  "supervise",
  "bundled",
  "compressed",
  "compressed folder",
  "decompress",
  "folder zip",
  "zipped",
  "zipped folder",
  "zipper",
  "follow the signs",
  "obey",
  "signage",
  "signs",
  "the",
  "add font",
  "character set",
  "download font",
  "font family",
  "font icon",
  "font library",
  "font management",
  "font pack",
  "font style",
  "get font",
  "install font",
  "new font",
  "text style",
  "font download",
  "font off",
  "no fonts",
  "food bank",
  "food donation center",
  "food drive",
  "food pantry",
  "hunger relief",
  "relief",
  "social services",
  "ankle",
  "appendage",
  "chiropractic",
  "foot bones",
  "heel",
  "joints",
  "metatarsals",
  "phalanges",
  "podiatrist",
  "tarsals",
  "footprints",
  "cupped hands",
  "curated",
  "for you",
  "holding",
  "my feed",
  "personalized",
  "recommendation engine",
  "serving",
  "suggestions",
  "tailored",
  "abstract tree",
  "conifer",
  "evergreen",
  "fir",
  "forest",
  "grove",
  "jungle",
  "national park",
  "pine",
  "plantation",
  "plants",
  "spruce",
  "trees",
  "two trees",
  "woodland",
  "woods",
  "branch left",
  "diverge left",
  "fork left",
  "split left",
  "branch right",
  "decisions",
  "diverge right",
  "fork right",
  "paths",
  "split right",
  "two directions",
  "forklift",
  "handling",
  "heavy machinery",
  "lift truck",
  "pallet",
  "unloading",
  "horizontal center",
  "align text",
  "five lines",
  "format text",
  "justify text",
  "text format",
  "B",
  "boldface",
  "font weight",
  "rich text",
  "T",
  "cancel format",
  "character formatting",
  "clear format",
  "clear formatting",
  "delete format",
  "format clear",
  "indentation",
  "no format",
  "remove format",
  "reset format",
  "change color",
  "color adjustment",
  "paint bucket",
  "pouring",
  "styling",
  "cancel formatting",
  "clear color",
  "delete color",
  "no color",
  "no formatting",
  "remove color",
  "font color",
  "text color",
  "underlining",
  "h1",
  "heading",
  "information architecture",
  "text size",
  "title",
  "h2",
  "heading 2",
  "large text",
  "second level heading",
  "subheading",
  "h3",
  "heading 3",
  "third level heading",
  "fourth heading",
  "h4",
  "heading 4",
  "heading level 4",
  "fifth heading",
  "font size",
  "h5",
  "heading 5",
  "heading five",
  "html tag",
  "html5",
  "h6",
  "heading 6",
  "heading six",
  "markdown",
  "sixth heading",
  "small text",
  "arrange image",
  "image formatting",
  "insert image",
  "image right",
  "decrease indent",
  "decrease indentation",
  "formatting tools",
  "indent",
  "outdent",
  "reduce indent",
  "unindent",
  "code formatting",
  "increase indent",
  "indent right",
  "tab right",
  "text indent",
  "emphasize",
  "highlighter",
  "text highlight",
  "capital i",
  "adjust spacing",
  "character spacing",
  "kerning",
  "decrease spacing",
  "increase spacing",
  "letter spacing",
  "text manipulation",
  "sentence",
  "character width",
  "formatting options",
  "letter width",
  "text adjust",
  "text width",
  "letter manipulation",
  "text adjustment",
  "wider",
  "writing tools",
  "line height",
  "bullet points",
  "bulleted",
  "bulleted list",
  "ordering",
  "unordered list",
  "create list",
  "list add",
  "list append",
  "list insert",
  "new list",
  "numbered",
  "numbered list",
  "ordered list",
  "format rtl",
  "list rtl",
  "right-to-left",
  "overbar",
  "overline",
  "overscore",
  "text decoration",
  "text overlay",
  "appearance",
  "roller",
  "insert paragraph",
  "new paragraph",
  "paragraph symbol",
  "pilcrow",
  "blockquote",
  "double quote",
  "ninety-nine",
  "quotation",
  "delete quote",
  "disable quote",
  "format quote",
  "quotation marks",
  "remove location",
  "remove quote",
  "speech marks",
  "turn off quote",
  "uncite",
  "unquote",
  "text frame",
  "change text size",
  "format strikethrough",
  "letter h",
  "text clip formatting",
  "textdirection",
  "truncate",
  "text overflow",
  "wrap text",
  "carriage return",
  "format text wrap",
  "newline",
  "language settings",
  "left to right",
  "ltr",
  "reading direction",
  "text direction",
  "writing direction",
  "arabic",
  "bidi",
  "bidirectional",
  "flip text",
  "hebrew",
  "i18n",
  "l10n",
  "mirror text",
  "persian",
  "reverse text",
  "switch direction",
  "urdu",
  "portrait orientation",
  "rotate text",
  "vertical text",
  "format underlined",
  "letter u",
  "text formatting toolbar",
  "underbar",
  "underlined",
  "u letter",
  "underline squiggle",
  "underscored",
  "wavy line",
  "wavy underline",
  "add entry",
  "add form",
  "add list",
  "create form",
  "forms",
  "new entry",
  "crenellation",
  "military",
  "parapet",
  "answers",
  "discuss",
  "online forum",
  "overlapping speech bubbles",
  "q&a",
  "question_answer",
  "questions",
  "two speech bubbles",
  "google plus",
  "googleplus",
  "open in new window",
  "repost",
  "reshare",
  "sent",
  "+10",
  "forward 10",
  "next 10",
  "skip 10",
  "step forward",
  "30 seconds forward",
  "30 seconds skip",
  "forward 30",
  "next 30",
  "skip 30",
  "advance 5",
  "forward 5",
  "jump 5",
  "next 5",
  "skip 5",
  "ff",
  "envelope",
  "move to",
  "paper plane",
  "send to",
  "basis",
  "beginnings",
  "foundation",
  "scaffold",
  "underpinning",
  "body spray",
  "cologne",
  "cosmetic",
  "freshness",
  "particles",
  "puff",
  "sprinkle",
  "spritz",
  "toiletry",
  "frame_inspect",
  "image recognition",
  "object detection",
  "audio recording",
  "framed",
  "speech recording",
  "voice recording",
  "exclude",
  "frame disabled",
  "hidden person",
  "hidden profile",
  "hidden user",
  "no frame",
  "no person",
  "person disabled",
  "person hidden",
  "person removed",
  "profile hidden",
  "profile removed",
  "user hidden",
  "user removed",
  "resync",
  "change source",
  "choose source",
  "external source",
  "frame source",
  "inward arrows",
  "select source",
  "cancellation",
  "free cancellation",
  "front hand",
  "haptic",
  "high five",
  "bulldozer",
  "dig",
  "digger",
  "earth mover",
  "earthmoving",
  "excavate",
  "excavation",
  "front loader",
  "groundworks",
  "heavy equipment",
  "landscaping",
  "shovel",
  "breaking",
  "coverage",
  "full coverage",
  "propaganda",
  "ux element",
  "1920x1080",
  "fhd",
  "full hd",
  "high-resolution",
  "expand view",
  "l shapes",
  "maximize view",
  "outward arrows",
  "four l's",
  "opposite l's",
  "small screen",
  "undo fullscreen",
  "unmaximize",
  "windowed",
  "nested rectangles",
  "algebra",
  "calculus",
  "compute",
  "f(x)",
  "function of x",
  "functions",
  "fx",
  "letter x",
  "notation",
  "plotting",
  "greek letter",
  "inclined plane",
  "mountain transport",
  "uphill",
  "cellular plan",
  "g",
  "internet plan",
  "letter g",
  "mobile plan",
  "square with cutout",
  "mobile phone",
  "foreign character",
  "google translate",
  "interpret",
  "overlapping squares",
  "phrasebook",
  "translator",
  "d-pad",
  "directional pad",
  "game controller",
  "game start",
  "play button",
  "playstation",
  "headlights",
  "gable",
  "garage door",
  "garden cart",
  "haul",
  "single wheel",
  "wheelbarrow",
  "butane",
  "natural gas",
  "propane",
  "abdomen",
  "belly",
  "bowels",
  "digest",
  "digestion",
  "digestive",
  "digestive health",
  "digestive system",
  "esophageal",
  "gastric",
  "gastro",
  "gastroenterology",
  "gastrointestinal",
  "gi",
  "gi tract",
  "gut",
  "gut health",
  "guts",
  "internal organs",
  "intestine",
  "intestines",
  "organ",
  "stomach",
  "tract",
  "archway",
  "members only",
  "attorney",
  "auction",
  "bidding",
  "constitution",
  "gavel",
  "judge",
  "lawsuit",
  "lawyer",
  "litigation",
  "mallet",
  "politics",
  "trial",
  "verdict",
  "consumer electronics",
  "digital device",
  "electronic device",
  "general",
  "general device",
  "bioengineering",
  "bioinformatics",
  "biological",
  "double helix",
  "evolution",
  "gene",
  "genetic code",
  "genetic engineering",
  "genome",
  "helix",
  "heredity",
  "inheritance",
  "nucleotide",
  "organism",
  "strand",
  "genres",
  "melody",
  "music genres",
  "play all",
  "play music",
  "songs",
  "start music",
  "air gesture",
  "thread",
  "index finger",
  "touchscreen",
  "animated image",
  "graphic interchange format",
  "meme",
  "video clip",
  "animated loop",
  "gif file",
  "gif image",
  "gif_2",
  "graphics interchange format",
  "internet meme",
  "reaction image",
  "animated icon",
  "gif box",
  "gif icon",
  "dress",
  "skirt",
  "womens",
  "farmhouse",
  "gite",
  "holiday home",
  "hostel",
  "short-term rental",
  "vacation rental",
  "alcohol",
  "barware",
  "drinking",
  "drinkware",
  "glassware",
  "liquor",
  "pub",
  "shot glass",
  "single line",
  "tableware",
  "tumbler",
  "waterglass",
  "whiskey",
  "trinity",
  "apac",
  "asia-pacific",
  "continent",
  "eastern",
  "eastern hemisphere",
  "eastern world",
  "far east",
  "global business",
  "global network",
  "globe icon",
  "hemisphere",
  "southeast",
  "territory",
  "digital learning",
  "global education",
  "global knowledge",
  "global learning",
  "global resources",
  "globe book",
  "international education",
  "international library",
  "online learning",
  "online resources",
  "study abroad",
  "world book",
  "world library",
  "globe pin",
  "world location",
  "britain",
  "british",
  "blood glucose",
  "blood sugar",
  "diabetes",
  "finger prick",
  "glucose",
  "glucose check",
  "glucose meter",
  "glucose test",
  "foreign",
  "glyphs",
  "latin",
  "go to line",
  "goto",
  "line jump",
  "line number",
  "specific line",
  "ball",
  "club",
  "flag in hole",
  "golf",
  "golf ball",
  "golf course",
  "golf flag",
  "golfer",
  "golfing",
  "putt",
  "putting green",
  "aerial lift",
  "cable transportation",
  "cableway",
  "gondola lift",
  "mountain transportation",
  "snowboard",
  "snowboarding",
  "audio output",
  "connected home",
  "device pairing",
  "google devices",
  "google home",
  "home entertainment",
  "screen cast",
  "smart display",
  "av remote",
  "channel changer",
  "clicker",
  "device control",
  "google tv remote",
  "input device",
  "media remote",
  "nest remote",
  "remote control",
  "six dots",
  "smart remote",
  "streaming remote",
  "television remote",
  "tv remote",
  "access point",
  "gale",
  "google wifi",
  "horizontal bars",
  "modem",
  "nest wifi",
  "network device",
  "rectangular",
  "compromised",
  "gpp",
  "sim",
  "unsafe",
  "data breach",
  "potential threat",
  "questionable",
  "security alert",
  "uncertain",
  "unsure",
  "checkerboard",
  "color blend",
  "color fade",
  "color gradient",
  "color transition",
  "dithering",
  "gradual change",
  "image edit",
  "photo edit",
  "smooth transition",
  "spectrum",
  "'favorite'_new'.  ' Remove this icon & keep 'star'.",
  "'star_boarder'",
  "'star_border_purple500'",
  "'star_outline'",
  "'star_purple500'",
  "'star_rate'",
  "Same as 'star'",
  "assess",
  "grade",
  "scoring",
  "cereal",
  "couscous",
  "particle",
  "quinoa",
  "rice",
  "rough",
  "scatter",
  "seeds",
  "links",
  "connected circles",
  "top down",
  "tree diagram",
  "network graph",
  "graph_6",
  "plot",
  "relationships",
  "scheme",
  "audio adjustment",
  "graphic equalizer",
  "sound adjustment",
  "fodder",
  "foliage",
  "three leaves",
  "turf",
  "vegetation",
  "hashtag",
  "number sign",
  "tic-tac-toe",
  "disable blocks",
  "disable grid",
  "disable layout",
  "disable matrix",
  "grid off",
  "grid view off",
  "hashtag off",
  "hide blocks",
  "hide grid",
  "hide matrix",
  "layout off",
  "matrix off",
  "no blocks",
  "no grid",
  "no matrix",
  "remove blocks",
  "remove grid",
  "remove matrix",
  "grate",
  "lattice",
  "weave",
  "aesthetics",
  "divine proportion",
  "golden",
  "golden ratio",
  "golden section",
  "goldenratio",
  "grid system",
  "modular",
  "phi",
  "template",
  "cropping",
  "grid guides",
  "grids",
  "guides",
  "resizing",
  "rule of thirds",
  "scaling",
  "snapping",
  "grid layout disable",
  "grid layout off",
  "grid view disable",
  "grid on",
  "thumbnails",
  "toggle view",
  "waffle",
  "application square",
  "food delivery",
  "fruit",
  "groceries",
  "grocery delivery",
  "ingredients",
  "milk",
  "online grocery",
  "orange",
  "shopping cart",
  "supermarket",
  "multiple users",
  "personnel",
  "add friend",
  "add member",
  "add person",
  "add to group",
  "create group",
  "friend",
  "join group",
  "new group",
  "block group",
  "block team",
  "cancel group",
  "cancel team",
  "deactivate group",
  "deactivate team",
  "delete group",
  "delete team",
  "disable group",
  "disable team",
  "exclude group",
  "exclude team",
  "group disabled",
  "group hidden",
  "group off",
  "group remove",
  "hide group",
  "hide team",
  "no group",
  "no team",
  "remove group",
  "remove team",
  "team disabled",
  "team hidden",
  "team off",
  "team remove",
  "turn off group",
  "turn off team",
  "ungroup",
  "delete from group",
  "exit group",
  "leave group",
  "remove from group",
  "unfriend",
  "unsubscribe",
  "find group",
  "find team",
  "find users",
  "group search",
  "look up",
  "people search",
  "recruitment",
  "search people",
  "search team",
  "search users",
  "team search",
  "alliance",
  "collaboration circle",
  "group circle",
  "group work",
  "team circle",
  "three users",
  "grouped",
  "forum discussion",
  "group chat",
  "online group",
  "avatars",
  "busts",
  "heads",
  "different",
  "group of three",
  "custodian",
  "supervised",
  "supervisor",
  "birth control",
  "cervix",
  "endometriosis",
  "fallopian",
  "fallopian tubes",
  "female reproductive system",
  "fertility",
  "fibroids",
  "gynecology",
  "gyno",
  "hormone",
  "menstrual cycle",
  "obgyn",
  "obstetrics",
  "ovaries",
  "ovary",
  "pcos",
  "pelvic pain",
  "reproductive",
  "reproductive health",
  "uterus",
  "vagina",
  "women's health",
  "h symbol",
  "hsdpa",
  "hspa",
  "h+",
  "high-speed data",
  "3.5g",
  "3g plus",
  "enhanced 3g",
  "fast connection",
  "h plus",
  "phone network",
  "signal icon",
  "curb",
  "get a ride",
  "hail",
  "hail a cab",
  "hail a taxi",
  "hailing",
  "hand up",
  "street hail",
  "corridor",
  "hallway",
  "long",
  "passageway",
  "walls",
  "arthritis",
  "hand_bones",
  "radiology",
  "five fingers",
  "flick",
  "swipe down",
  "swipe left",
  "block gesture",
  "block hand",
  "cancel gesture",
  "cancel hand",
  "crossed hand",
  "deactivate gesture",
  "deactivate hand",
  "disable gesture",
  "disable hand",
  "gesture blocked",
  "gesture cancel",
  "gesture deactivate",
  "gesture disabled",
  "gesture off",
  "gesture reject",
  "hand blocked",
  "hand cancel",
  "hand deactivate",
  "hand disabled",
  "hand gesture off",
  "hand reject",
  "hand with line",
  "no gesture",
  "no hand",
  "reject gesture",
  "reject hand",
  "slashed hand",
  "stop gesture",
  "stop hand",
  "flight stick",
  "game console",
  "gaming device",
  "handheld game",
  "handheld gaming device",
  "handheld_controller",
  "joystick",
  "play game",
  "portable console",
  "videogame",
  "commitment",
  "cooperate",
  "cooperation",
  "deal making",
  "friendship",
  "handshake",
  "partnership agreement",
  "crossed",
  "do it yourself",
  "screw",
  "screwdriver",
  "woodwork",
  "google hangout",
  "hangout",
  "video meeting",
  "virtual call",
  "camera disabled",
  "camera off",
  "disable video",
  "end video",
  "mute video",
  "no camera",
  "no video",
  "no webcam",
  "screen recording off",
  "screen share off",
  "stop video",
  "video call off",
  "video chat off",
  "video conference off",
  "video disabled",
  "video off",
  "video recording off",
  "webcam disabled",
  "webcam off",
  "hard disk",
  "hard drive",
  "hdd",
  "indicator light",
  "hand tool",
  "nail",
  "tinker",
  "toolbox",
  "720p",
  "high res",
  "high-definition",
  "auto hdr",
  "dynamic range",
  "hdr auto",
  "hdr mode",
  "imaging",
  "auto selection",
  "hdr selection",
  "hdr+",
  "rich colors",
  "vivid",
  "dynamic range enhancement",
  "visual",
  "disable hdr",
  "hdr off",
  "image settings",
  "no hdr",
  "hdr deactivated",
  "hdr disabled",
  "hdr plus",
  "toggle hdr",
  "dynamic range imaging",
  "enhanced video",
  "high dynamic range plus",
  "improved video",
  "visual enhancement",
  "hdr plus off",
  "no hdr plus",
  "post-processing",
  "tone mapping",
  "augmented",
  "daydream",
  "experience",
  "extended reality",
  "goggles",
  "head mounted display",
  "hmd",
  "metaverse",
  "mixed reality",
  "simulation",
  "straps",
  "visor",
  "xr",
  "audio jack",
  "bluetooth headphones",
  "headphone battery life",
  "headphones battery",
  "headset battery",
  "headset battery life",
  "music device",
  "headphone symbol",
  "headset mic",
  "headset symbol",
  "microphone symbol",
  "over-the-ear headphones",
  "tech support",
  "audio disabled",
  "audio off",
  "cancel audio",
  "cancel sound",
  "disable audio",
  "disable headphones",
  "disable headset",
  "disable sound",
  "headphones disabled",
  "headphones off",
  "headset disabled",
  "headset off",
  "no headphones",
  "no headset",
  "silenced",
  "sound disabled",
  "adhesive bandage",
  "band-aid",
  "bandage",
  "bandaid",
  "cure",
  "healing",
  "mend",
  "plaster",
  "remedy",
  "wound",
  "beauty products",
  "comb",
  "getting ready",
  "grooming",
  "hair care",
  "hair styling",
  "hairbrush",
  "morning routine",
  "polish",
  "self",
  "toiletries",
  "cross icon",
  "health and safety",
  "health insurance",
  "health protection",
  "health security",
  "medical safety",
  "medical security",
  "medical shield",
  "safety protection",
  "shield icon",
  "blood oxygen saturation",
  "body metrics",
  "breathing rate",
  "health information",
  "health metrics",
  "heart rate variability",
  "medical cross",
  "medical data",
  "medical information",
  "medical symbol",
  "resting heart rate",
  "skin temperature",
  "heap",
  "java",
  "allocation",
  "profiling",
  "division",
  "parts",
  "whole",
  "audio waves",
  "deaf",
  "hard of hearing",
  "hearing_aid",
  "hearing aid",
  "hearing impaired",
  "hearing loss",
  "no hearing",
  "disabled hearing aid",
  "hearing aid off",
  "hearing device",
  "left ear",
  "assistive device",
  "sound amplifier",
  "accessibility icon",
  "crossed ear",
  "deafness",
  "ear icon",
  "ear with slash",
  "hearing disability",
  "impaired hearing",
  "listen off",
  "broken heart",
  "core",
  "crack",
  "dislike",
  "electric heart",
  "heartbreak",
  "heartbreak icon",
  "hurt",
  "nucleus",
  "pain",
  "sadness",
  "unfollow",
  "deduct",
  "delete favorite",
  "heart break",
  "heart broken",
  "heart removal",
  "heart with minus",
  "less love",
  "remove favorite",
  "removeFromFavorites",
  "unlike post",
  "unlove",
  "add favorite",
  "add heart",
  "add to wishlist",
  "create favorite",
  "heart collection",
  "heart plus",
  "heart symbol",
  "love symbol",
  "new love",
  "plus heart",
  "save heart",
  "rising",
  "furnance",
  "heat pump",
  "pump",
  "spokes",
  "pipes",
  "increase height",
  "shorter",
  "taller",
  "aerial",
  "airlift",
  "chopper",
  "copter",
  "helicopter",
  "rotor",
  "rotorcraft",
  "whirlybird",
  "find answer",
  "help center",
  "help outline",
  "how to",
  "question icon",
  "contact support",
  "find answers",
  "knowledge base",
  "online help",
  "question box",
  "clinic information",
  "health center",
  "home icon",
  "arteries",
  "blood analysis",
  "blood count",
  "blood sample",
  "blood vessels",
  "blood work",
  "capillaries",
  "cell biology",
  "circulatory system",
  "hematology",
  "platelets",
  "red blood cells",
  "vein",
  "veins",
  "white blood cells",
  "h.265",
  "hevc",
  "high efficiency video coding",
  "video file",
  "video standard",
  "6 sided",
  "honeycomb",
  "nut",
  "six sided",
  "disappear",
  "obscure",
  "pointing arrows",
  "vanish",
  "block image",
  "cancel image",
  "content visibility",
  "delete image",
  "disable image",
  "hide image",
  "no image",
  "no photo",
  "no picture",
  "remove image",
  "censored",
  "hide source",
  "obfuscate",
  "redact",
  "dense",
  "dots per inch",
  "dpi",
  "high density",
  "pixel density",
  "pixels per inch",
  "ppi",
  "retina",
  "audio quality",
  "hq",
  "media quality",
  "hi-res",
  "high dpi",
  "hires",
  "upscale",
  "symbolic",
  "I",
  "chromeos",
  "highlight text",
  "i beam",
  "i-beam",
  "keyboard focus",
  "select text",
  "indicate",
  "mouse hover",
  "mouseover",
  "insert text",
  "text cursor",
  "text selection",
  "text tool",
  "type tool",
  "writing text",
  "size 1",
  "medium size",
  "size 2",
  "size two",
  "text marker",
  "size 3",
  "four sides",
  "quadrilateral",
  "backpacking",
  "climbing",
  "duffle",
  "hiker",
  "rollback",
  "turn back",
  "clock face",
  "viewed",
  "college",
  "edu",
  "feather",
  "history_edu",
  "quill",
  "no history",
  "activity history",
  "history disabled",
  "history off",
  "history toggle",
  "notches",
  "tick marks",
  "time tracking",
  "bee nest",
  "beehive",
  "bees",
  "colony",
  "hexagons",
  "hive",
  "honeycomb structure",
  "insects",
  "adaptive bitrate streaming",
  "adaptive streaming",
  "cdn",
  "content delivery",
  "hls",
  "http",
  "http live streaming",
  "internet protocol suite",
  "m3u8",
  "on-demand",
  "real-time",
  "vod",
  "hls deactivated",
  "hls disabled",
  "hls off",
  "live stream off",
  "live streaming",
  "live streaming off",
  "no hls",
  "no live stream",
  "no live streaming",
  "no streaming",
  "stop streaming",
  "buildings",
  "homes",
  "houses",
  "application--house",
  "filled home",
  "go home",
  "home screen",
  "home symbol",
  "solid home",
  "home and garden",
  "abode",
  "abstract house",
  "back to home",
  "initial view",
  "main menu",
  "primary navigation",
  "return home",
  "start page",
  "starting point",
  "stylized house",
  "assisted living",
  "doctor house call",
  "elder care",
  "home health aide",
  "home healthcare",
  "home medical equipment",
  "home medical services",
  "home nursing",
  "home visit",
  "house with cross",
  "in-home care",
  "medical house call",
  "nurse house call",
  "private nursing",
  "remote patient monitoring",
  "senior care",
  "visiting nurse",
  "furniture assembly",
  "home repair",
  "slotted",
  "slotted screw",
  "home control",
  "smart light",
  "smart temperature",
  "max",
  "things",
  "Internet",
  "site navigation",
  "default location",
  "find home",
  "home address",
  "home base",
  "home location",
  "home pin",
  "house location",
  "property location",
  "residence location",
  "contractor",
  "home services",
  "kit",
  "repair service",
  "repairing",
  "toolkit",
  "bluetooth speaker",
  "home audio",
  "speaker system",
  "wireless speaker",
  "home folder",
  "my documents",
  "my files",
  "personal files",
  "user data",
  "building icon",
  "combined building",
  "hybrid work",
  "office address",
  "overlapping icons",
  "remote work",
  "telecommute",
  "work address",
  "evenly",
  "horizontal_distribute",
  "content divider",
  "design element",
  "gmail",
  "horizontal rule",
  "list divider",
  "menu separator",
  "novitas",
  "section break",
  "section divider",
  "subsection",
  "thematic break",
  "toolbar",
  "horizontal split",
  "parallel bars",
  "cloud server",
  "computers",
  "host",
  "network hosting",
  "racks",
  "servers",
  "web hosting",
  "jets",
  "steamy",
  "swim",
  "abstract bed",
  "check-out",
  "hotel symbol",
  "inn",
  "local hotel",
  "place to sleep",
  "simple bed",
  "broken star",
  "five star",
  "four star",
  "hotel class",
  "hotel rating",
  "one star",
  "stars",
  "three star",
  "two star",
  "hourglass icon",
  "loading icon",
  "patience",
  "progress icon",
  "sand clock",
  "sand timer",
  "sandglass",
  "time icon",
  "timer icon",
  "wait icon",
  "download time",
  "hourglass down",
  "time elapsed",
  "time remaining",
  "faster",
  "hourglass up",
  "speed up",
  "time increase",
  "anticipation",
  "hourglass_bottom",
  "limited time",
  "time passing",
  "delay off",
  "hourglass disabled",
  "hourglass not allowed",
  "hourglass off",
  "no delay",
  "no processing",
  "no time",
  "no waiting",
  "paused",
  "time not allowed",
  "timeout",
  "wait off",
  "duration icon",
  "empty hourglass",
  "hourglass empty",
  "hourglass outline",
  "deferred",
  "delay timer",
  "hourglass pause",
  "hourglass timer",
  "on hold",
  "pause process",
  "paused timer",
  "process pause",
  "suspension",
  "task pause",
  "workflow pause",
  "hourglass top half",
  "hourglass_top",
  "top half hourglass",
  "⏳",
  "simple house",
  "facade",
  "homeowner",
  "property management",
  "siding",
  "domestic security",
  "family safety",
  "home protection",
  "home safe",
  "house protection",
  "property security",
  "protected home",
  "protected house",
  "residential security",
  "safe home",
  "secure house",
  "boat house",
  "floating accommodation",
  "floating home",
  "floating house",
  "house on water",
  "houseboat",
  "vacation home",
  "disinfecting",
  "household supplies",
  "plant care",
  "sprayer",
  "squirt",
  "supplies",
  "watering",
  "high occupancy vehicle",
  "hov",
  "hover",
  "account creation",
  "sign-up",
  "to reg",
  "user registration",
  "civic duty",
  "civic engagement",
  "democracy",
  "elections",
  "calm",
  "healthy heart",
  "heart icon",
  "low intensity",
  "resting",
  "rhr",
  "backend",
  "central",
  "distribute hub",
  "focal point",
  "network node",
  "topology",
  "arm bone",
  "chew",
  "dog",
  "forelimb",
  "humerus",
  "surgery",
  "upper arm",
  "vitamin d",
  "arm injury",
  "bone fracture",
  "broken bone",
  "heal",
  "sling",
  "trauma",
  "damp",
  "high humidity",
  "humid",
  "muggy",
  "raindrop",
  "tear",
  "wet",
  "humidity control",
  "indoor climate",
  "droplet outline",
  "dry air",
  "empty drop",
  "low humidity",
  "low moisture",
  "menstruation",
  "thirst",
  "waterless",
  "half empty",
  "humidity mid",
  "mid humidity",
  "sweat",
  "water level",
  "air moisture",
  "dampness",
  "drop shape",
  "humidity percentage",
  "building management",
  "defogger",
  "s shape",
  "figure skating",
  "footwear",
  "frozen",
  "glide",
  "hockey",
  "ice skate",
  "ice skating",
  "new year",
  "rink",
  "skate",
  "skates",
  "skating",
  "winter activity",
  "chocolate",
  "cone icon",
  "cream",
  "dairy",
  "frozen dessert",
  "frozen yogurt",
  "gelato",
  "ice cream",
  "ice cream cone",
  "icecream",
  "scoop icon",
  "soft serve",
  "sorbet",
  "strawberry",
  "summer icon",
  "sundae",
  "vanilla",
  "driver license",
  "driver's license",
  "id_card",
  "aware",
  "firewall",
  "iap",
  "identity aware proxy",
  "proxy",
  "zero trust",
  "identity management",
  "user management",
  "die",
  "i'm",
  "ifl",
  "lucky",
  "randomness",
  "table game",
  "triple circle",
  "triple dot",
  "content loading",
  "external content",
  "iframe",
  "inline",
  "inline frame",
  "subwindow",
  "web component",
  "no iframe",
  "third party",
  "original",
  "upload picture",
  "export image",
  "export photo",
  "export picture",
  "image upload",
  "move image",
  "move photo",
  "move picture",
  "photo upload",
  "picture upload",
  "send image",
  "send photo",
  "send picture",
  "share image",
  "share photo",
  "share picture",
  "transfer image",
  "transfer photo",
  "transfer picture",
  "image aspect ratio",
  "explore images",
  "find image",
  "find photo",
  "find photos",
  "find picture",
  "gallery search",
  "image discovery",
  "image explorer",
  "image finder",
  "image library search",
  "image search",
  "photo finder",
  "photo search",
  "picture finder",
  "picture search",
  "search image",
  "search photo",
  "search picture",
  "coat",
  "decorate",
  "decorating",
  "imagesearch",
  "paint roller",
  "assets",
  "image browser",
  "image collection",
  "image gallery",
  "image library",
  "image mode",
  "photo mode",
  "picture mode",
  "upload image",
  "view images",
  "antigen",
  "immune response",
  "infectious",
  "viruses",
  "add contacts",
  "copy contacts",
  "import contacts",
  "transfer contacts",
  "upload contacts",
  "device priority",
  "important devices",
  "manage devices",
  "my devices",
  "preferred device",
  "primary device",
  "select device",
  "top devices",
  "checked in",
  "home mode",
  "house mode",
  "in home",
  "stay at home",
  "stay home",
  "inactive order",
  "purchase order",
  "receipt",
  "receipts",
  "sales order",
  "work order",
  "rounded bottom",
  "recipient",
  "sender",
  "3/4 circle",
  "circle segment",
  "three quarter circle",
  "mixed",
  "no tick",
  "partial selection",
  "state",
  "ui widget",
  "undetermined",
  "ambiguity",
  "doubt",
  "unknown location",
  "letter i",
  "electromagnetic",
  "infrared",
  "ir",
  "night vision",
  "radiation",
  "wavelength",
  "art tool",
  "ink eraser",
  "slant",
  "block eraser",
  "disable eraser",
  "no eraser",
  "no ink",
  "restrict eraser",
  "sketching",
  "highlighting",
  "felt tip",
  "content selection",
  "dashed square",
  "dotted square",
  "ink selection",
  "inpatient",
  "ward",
  "log in",
  "input circle",
  "into",
  "rounded arrow",
  "add break",
  "insert page",
  "page divider",
  "text break",
  "letter t",
  "t",
  "text container",
  "text entry",
  "computer download",
  "desktop download",
  "desktop install",
  "download to desktop",
  "install on desktop",
  "monitor download",
  "pwa",
  "screen download",
  "audio mixer",
  "dj",
  "faders",
  "instant mix",
  "mixing",
  "multitrack",
  "remix",
  "soundboard",
  "stems",
  "studio",
  "switches",
  "engineering clipboard",
  "how-to",
  "digital world",
  "geometric shapes",
  "interactive space",
  "activities",
  "areas of interest",
  "choose interests",
  "favorite things",
  "fields of interest",
  "hobbies",
  "interest selection",
  "interests",
  "my interests",
  "passions",
  "pick interests",
  "select interests",
  "things i like",
  "topics of interest",
  "interpreter",
  "packages",
  "archive box",
  "fewer",
  "inventory management",
  "product inventory",
  "stock control",
  "storage container",
  "hue",
  "inverse",
  "inverted",
  "palette",
  "color inversion disabled",
  "disable invert",
  "high contrast off",
  "inverse colors off",
  "inverse off",
  "invert colors off",
  "invert off",
  "inverted colors disabled",
  "negative colors off",
  "negative off",
  "no invert",
  "opacity",
  "reverse colors off",
  "reverse off",
  "toggle off",
  "apple ecosystem",
  "apple inc",
  "iphone",
  "ipod",
  "lowercase",
  "mobile os",
  "o",
  "operating",
  "operating system icon",
  "s",
  "clothes iron",
  "crease",
  "flatiron",
  "iron",
  "iron icon",
  "ironing",
  "presser",
  "steam iron",
  "wrinkle",
  "wrinkles",
  "display mode",
  "google jamboard",
  "interactive display",
  "jamboard",
  "public access",
  "self-service",
  "coding language",
  "javascript icon",
  "js",
  "js icon",
  "scripting",
  "arcs",
  "combined shape",
  "common",
  "crossroads",
  "union",
  "docking",
  "join left",
  "join right",
  "northeast",
  "teleport",
  "warp",
  "boating",
  "canoe",
  "canoeing",
  "kayak",
  "kayaking",
  "paddle",
  "paddling",
  "rafting",
  "water sports",
  "appetizer",
  "barbecue",
  "bbq",
  "brochette",
  "cookout",
  "grilled",
  "kebab",
  "meat",
  "satay",
  "shish kebab",
  "skewer",
  "souvlaki",
  "two skewers",
  "vegetable",
  "location pin",
  "pin icon",
  "pin location",
  "pin outline",
  "pin point",
  "pin symbol",
  "push pin",
  "stick pin",
  "no pin",
  "no tack",
  "remove pin",
  "unfasten",
  "unpin",
  "unpin post",
  "unstick",
  "untack",
  "boiling",
  "electric kettle",
  "hot beverage",
  "kettle",
  "steamer",
  "stovetop kettle",
  "tea kettle",
  "teapot",
  "decryption",
  "disabled key",
  "key disabled",
  "key off",
  "credential",
  "key_vertical",
  "sign-in",
  "vertical key",
  "heatmap",
  "introspection",
  "key_visualizer",
  "visualizer",
  "keys",
  "spacebar",
  "alternative keyboard",
  "external keyboard",
  "keyboard_alt",
  "expand_more",
  "keyboard_arrow_down",
  "keyboard arrow",
  "keyboard arrow left",
  "left caret",
  "left chevron",
  "chevron right",
  "disclosure indicator",
  "keyboard navigation",
  "keyboard right",
  "scroll right",
  "slide right",
  "swipe right",
  "keyboard_arrow_up",
  "navigate back",
  "all caps",
  "capital letters",
  "caps lock",
  "capslock",
  "capitalization",
  "caps",
  "access key",
  "cloverleaf",
  "command key",
  "hotkey",
  "intertwined",
  "keyboard shortcut",
  "keystroke",
  "knot",
  "macos",
  "modifier key",
  "osx",
  "control key",
  "up key",
  "chevron down",
  "keyboard input",
  "page down",
  "chevron left",
  "double left arrow",
  "fast forward (reverse)",
  "jump back",
  "two chevrons",
  "arrow keys",
  "right key",
  "double up arrow",
  "page up",
  "up arrows",
  "add keyboard",
  "bluetooth keyboard",
  "connect keyboard",
  "external hardware",
  "pair keyboard",
  "send to keyboard",
  "wireless keyboard",
  "enter text",
  "full keyboard",
  "keyboard layout",
  "keyboard_full",
  "close keyboard",
  "dismiss keyboard",
  "form input",
  "hide keypad",
  "input method",
  "keyboard arrow down",
  "keyboard down",
  "keyboard hide",
  "mobile keyboard",
  "onscreen keyboard",
  "virtual keyboard",
  "keyboard keys",
  "disable keyboard",
  "enable keyboard",
  "input lock",
  "keyboard access",
  "keyboard blocked",
  "keyboard disabled",
  "keyboard lock",
  "keyboard security",
  "keypad lock",
  "lock keys",
  "locked keyboard",
  "secure keyboard",
  "typing lock",
  "block keyboard",
  "deactivate keyboard",
  "input block",
  "input disabled",
  "keyboard deactivated",
  "keyboard lock off",
  "keyboard off",
  "keyboard restriction",
  "keyboard unlock",
  "no keyboard",
  "no typing",
  "unlock keyboard",
  "input off",
  "keyboard inactive",
  "keys disabled",
  "keys off",
  "text entry off",
  "text input off",
  "typing disabled",
  "typing off",
  "chatting",
  "commenting",
  "digital keyboard",
  "soft keyboard",
  "alt key",
  "modifier",
  "option key",
  "language selection",
  "previous language",
  "angular arrow",
  "bent arrow",
  "arrow key",
  "keyboard tab",
  "next field",
  "next item",
  "tab key",
  "reverse tab",
  "child-friendly",
  "favourites",
  "kids' content",
  "king bed",
  "king-size",
  "cooler",
  "food preservation",
  "fridge",
  "meal preparation",
  "refrigerator",
  "shelves",
  "two door",
  "extreme sport",
  "extreme sports",
  "kite board",
  "kite surf",
  "kiteboarding",
  "kitesurf",
  "kitesurfing",
  "surf",
  "surfing",
  "water sport",
  "cylinders",
  "lab panel",
  "labs",
  "samples",
  "lab profile",
  "lab report",
  "lab results",
  "lab test",
  "patient profile",
  "biological research",
  "chemical analysis",
  "explore research",
  "lab research",
  "medical research",
  "scientific discovery",
  "test tube",
  "vial",
  "wing",
  "disable label",
  "disable tag",
  "hide label",
  "hide tag",
  "label off",
  "marker off",
  "markers",
  "markers off",
  "no label",
  "no tag",
  "suppress label",
  "suppress tag",
  "tag off",
  "tags",
  "tags off",
  "untagged",
  "research and development",
  "local area network",
  "mountain range",
  "peaks",
  "summit",
  "vista",
  "horizon",
  "landscape_2",
  "outdoor activity",
  "rolling hills",
  "scenic route",
  "valleys",
  "autorotate",
  "autorotate disabled",
  "autorotate off",
  "display disabled",
  "display off",
  "orientation disabled",
  "orientation off",
  "rotate disabled",
  "rotate off",
  "screen rotation disabled",
  "screen rotation off",
  "view off",
  "avalanche",
  "cliff collapse",
  "debris",
  "earth movement",
  "erosion",
  "falling debris",
  "falling rocks",
  "ground movement",
  "landfall",
  "landslide",
  "mudslide",
  "rockfall",
  "rockslide",
  "tumbling rocks",
  "unstable ground",
  "cantonese",
  "languages",
  "linguistics",
  "mandarin",
  "translations",
  "cangjie",
  "cangjie input method",
  "chinese input method",
  "dayi",
  "phonetic",
  "pinyin",
  "eastern languages",
  "language support",
  "east asian languages",
  "five strokes",
  "ime",
  "wubi",
  "country code",
  "european",
  "fr",
  "french",
  "language code",
  "language icon",
  "language option",
  "language select",
  "locale",
  "text language",
  "gb",
  "globalization",
  "intl",
  "language options",
  "multiple languages",
  "world language",
  "east asian",
  "hiragana",
  "japanese language",
  "kana",
  "katakana",
  "nihongo",
  "hangul",
  "korean",
  "korean language",
  "romanization",
  "조선말",
  "조선어",
  "한국",
  "한국어",
  "한글",
  "hanzi",
  "pronunciation",
  "tones",
  "choose language",
  "es",
  "latin america",
  "select language",
  "spain",
  "spanish",
  "america",
  "american",
  "en",
  "english",
  "united states",
  "us",
  "usa",
  "colemak",
  "essay",
  "dv",
  "dvorak",
  "dvorak keyboard",
  "keyboard settings",
  "language us",
  "language us dvorak",
  "us dvorak",
  "lap",
  "laps",
  "car tech",
  "chrome os",
  "chromebook",
  "mac chromebook",
  "mobile computing",
  "netbook",
  "portable computer",
  "trackpad",
  "ultrabook",
  "clamshell",
  "macbook",
  "microsoft",
  "area selection",
  "dotted circle",
  "free select",
  "freeform selection",
  "lasso",
  "object selection",
  "region selection",
  "select tool",
  "end page",
  "end slide",
  "final",
  "final page",
  "go to end",
  "greater than sign",
  "jump to end",
  "last slide",
  "pagination",
  "right chevron",
  "scroll to end",
  "two shapes",
  "vertical bar",
  "cleanliness",
  "clothing care",
  "fabric care",
  "laundromat",
  "laundry basket",
  "laundry day",
  "laundry room",
  "tshirt",
  "tumble dry",
  "combine layers",
  "delete layers",
  "flatten layers",
  "hide layers",
  "layer management",
  "layering",
  "layers off",
  "merge layers",
  "no layers",
  "remove layers",
  "reset layers",
  "unstack",
  "drain",
  "lda",
  "modeling",
  "parameter",
  "topics",
  "variables",
  "contest",
  "first place",
  "high score",
  "leaderboard",
  "podium",
  "scores",
  "second place",
  "third place",
  "winners",
  "diffusion",
  "emit",
  "leak_add",
  "quadrants",
  "synce",
  "fix_leak",
  "leak_remove",
  "leak_repair",
  "no_crack",
  "no_leak",
  "prevent_leak",
  "stop_leak",
  "waterproof",
  "watertight",
  "clicking",
  "computer interaction",
  "computer mouse",
  "gui",
  "left click",
  "mouse action",
  "mouse arrow",
  "hide panel",
  "left panel",
  "show panel",
  "toggle panel",
  "legend",
  "legend_toggle",
  "map key",
  "map legend",
  "stackdriver",
  "depth of field",
  "fuzzy",
  "lens blur",
  "character switch",
  "flips",
  "swaps",
  "append to queue",
  "stack of layers",
  "save to library",
  "textbooks",
  "albums",
  "audio collection",
  "audio library",
  "library_music",
  "music collection",
  "sound library",
  "sounds",
  "medal",
  "lift to talk",
  "ptt",
  "push to talk",
  "raise",
  "walkie talkie",
  "ceiling light",
  "dome light",
  "electric light",
  "hanging light",
  "house light",
  "lighting fixture",
  "pendant light",
  "pendent",
  "room light",
  "fixtures",
  "hanging lamp",
  "lamps",
  "table lamp",
  "darkness",
  "deactivated light",
  "disabled light",
  "light off",
  "lights out",
  "no illumination",
  "incandescent",
  "led",
  "light bulb",
  "invent",
  "lightbulb_2",
  "electric stand",
  "energy boost",
  "ev charging",
  "line_axis",
  "quarter circle",
  "top left corner",
  "trajectory",
  "arrowheads",
  "endcap",
  "endpoint",
  "line end",
  "termination",
  "arrow end",
  "end point",
  "line arrow",
  "triangle arrow",
  "notch",
  "line end circle",
  "conclude",
  "commence",
  "jump off",
  "line segment",
  "onset",
  "outset",
  "line start",
  "start point",
  "beginning of line",
  "start of line",
  "entry point",
  "prepend",
  "lines of text",
  "paragraphs",
  "text lines",
  "linear_scale",
  "attached",
  "broken chain",
  "broken link",
  "cancel link",
  "chain off",
  "delete link",
  "disable link",
  "disconnection",
  "lost connection",
  "remove chain",
  "remove link",
  "slashed",
  "unchain",
  "connected camera",
  "linked camera",
  "remote camera",
  "wireless camera",
  "digital markets act",
  "dma",
  "federation",
  "linked circles",
  "alcohol consumption",
  "bottle and glass",
  "celebration drink",
  "cocktail",
  "coupe",
  "martini",
  "nightlife",
  "spirits",
  "spirits bottle",
  "wine",
  "wineglass",
  "live chat",
  "live help",
  "need help",
  "antennas hardware",
  "channel",
  "video on demand",
  "indoors",
  "entertainment ticket",
  "local event",
  "local show",
  "nearby event",
  "star ticket",
  "dollar sign",
  "bar location",
  "find bar",
  "happy hour",
  "local bar",
  "nearby bar",
  "nightclub",
  "breakfast service",
  "cafe service",
  "coffee cup",
  "local cafe",
  "auto cleaning",
  "auto detailing",
  "automotive service",
  "car care",
  "car cleaning",
  "car wash",
  "car wash service",
  "local car wash",
  "nearby car wash",
  "vehicle cleaning",
  "water drops",
  "--",
  "24 hours",
  "24/7",
  "all day",
  "all night",
  "all night long",
  "always open",
  "anytime",
  "convenience",
  "convenience store",
  "hours",
  "local market",
  "local store",
  "open 24 hours",
  "open 24/7",
  "twenty four",
  "dine",
  "find restaurant",
  "local restaurant",
  "nearby restaurant",
  "restaurant locator",
  "beer",
  "drinkable",
  "local drink",
  "nearby drinks",
  "potable",
  "combustion",
  "hotness",
  "inferno",
  "local fire department",
  "popular",
  "trending topic",
  "trending up",
  "viral",
  "wildfire",
  "youtube trending",
  "bouquet",
  "florist",
  "flower shop",
  "local florist",
  "local shop",
  "plant shop",
  "diesel",
  "fuel station",
  "gas station",
  "gasoline",
  "oil",
  "petrol",
  "petrol station",
  "refuel",
  "service station",
  "infirmary",
  "medical center",
  "urgent care",
  "clothes washing",
  "local laundry",
  "spin cycle",
  "bookstore",
  "community learning",
  "public library",
  "consumerism",
  "department store",
  "handbag",
  "local shopping",
  "nearby shops",
  "plaza",
  "retail therapy",
  "shopping center",
  "auto park",
  "car park",
  "find parking",
  "local parking",
  "nearby parking",
  "on-street parking",
  "p",
  "parking area",
  "parking garage",
  "parking lot",
  "parking space",
  "street parking",
  "apothecary",
  "chemist",
  "drugstore",
  "mortar",
  "pestle",
  "cheese",
  "fast food",
  "italian food",
  "local pizza",
  "order food",
  "pepperoni",
  "pizza",
  "pizza slice",
  "toppings",
  "community policing",
  "crime prevention",
  "enforcement",
  "first responders",
  "law enforcement",
  "local police",
  "neighborhood watch",
  "officer",
  "precinct",
  "public safety",
  "sheriff",
  "local mail",
  "mail delivery",
  "mailbox",
  "post office",
  "postal service",
  "find a place",
  "local guide",
  "nearby photos",
  "courier",
  "delivery van",
  "local delivery",
  "local shipping",
  "lorry",
  "shipping truck",
  "shipping van",
  "lyft",
  "ride-sharing",
  "roof sign",
  "taxi sign",
  "uber",
  "yellow",
  "away",
  "gone",
  "leaving",
  "location away",
  "not home",
  "occupancy",
  "vacant",
  "find location",
  "location chip",
  "apartments",
  "civic",
  "downtown",
  "municipality",
  "offices",
  "hide location",
  "location services off",
  "resident",
  "crossed out location",
  "disabled location",
  "find location off",
  "gps slash",
  "gps unavailable",
  "location hidden",
  "location slash",
  "location unavailable",
  "map pin off",
  "marker slash",
  "no position",
  "pinpoint off",
  "pinpoint slash",
  "place off",
  "position disabled",
  "position off",
  "position unavailable",
  "tracking disabled",
  "tracking off",
  "fmd good",
  "location on",
  "meeting place",
  "acquiring location",
  "finding location",
  "location error",
  "location not found",
  "searching for gps",
  "signal lost",
  "lock screen timeout",
  "lock timer",
  "session timeout",
  "temporary access",
  "time limit",
  "time lock",
  "unlock time",
  "access granted",
  "lock_open",
  "no restriction",
  "open access",
  "open lock",
  "open padlock",
  "unlocked padlock",
  "lock open",
  "authorized",
  "no lock",
  "open right",
  "right open",
  "right unlock",
  "shackle",
  "u-shape",
  "unlock right",
  "lock person",
  "user lock",
  "change password",
  "forgot password",
  "lock_reset",
  "password reset",
  "dev",
  "dev.to",
  "door out",
  "end session",
  "escape",
  "session end",
  "sign off",
  "arches",
  "glance",
  "glimpse",
  "rainbow",
  "seen",
  "semi-circles",
  "triple",
  "quartet",
  "looks 6",
  "looks six",
  "number six",
  "numeral six",
  "rounded box",
  "six looks",
  "looks_two",
  "closer",
  "observation",
  "zoom tool",
  "dispersed",
  "low density",
  "small amount",
  "sparse",
  "spread out",
  "de-prioritize",
  "decrease priority",
  "deprioritize",
  "importance",
  "low priority",
  "reduce priority",
  "text transformation",
  "title case",
  "benefits",
  "data signal",
  "lte network",
  "mobile broadband",
  "burger icon",
  "eating icon",
  "lunchtime",
  "sandwich icon",
  "closed captions",
  "lyrics",
  "music lyrics",
  "sing",
  "singing",
  "song lyrics",
  "close-up",
  "macro",
  "macro photography",
  "close up",
  "close-up off",
  "closeup",
  "deactivate macro",
  "disable macro",
  "macro disabled",
  "macro_off",
  "no close-up",
  "no closeup",
  "no focus",
  "no macro",
  "no_macro",
  "smaller view",
  "docked",
  "enter fullscreen",
  "full screen mode",
  "mail outline",
  "closed lock",
  "email lock",
  "email privacy",
  "email security",
  "locked mail",
  "mail lock",
  "mail privacy",
  "mail security",
  "message privacy",
  "message security",
  "privacy lock",
  "private message",
  "secure mail",
  "secure message",
  "communication off",
  "email disabled",
  "inbox off",
  "mail disabled",
  "no email",
  "no mail",
  "no messages",
  "unsubscribed",
  "boy's restroom",
  "gentleman",
  "male symbol",
  "mars",
  "masculine",
  "men's restroom",
  "account icon",
  "gender icon",
  "human icon",
  "restroom sign",
  "simple figure",
  "man icon",
  "guy",
  "man 3",
  "individual icon",
  "member icon",
  "account management",
  "edit profile",
  "manage accounts",
  "person and cog",
  "person and gear",
  "list search",
  "manage search",
  "search options",
  "broken manga",
  "broken panel",
  "cracked screen",
  "damaged manga",
  "fragment",
  "graphic novel",
  "ripped page",
  "shattered",
  "torn page",
  "clockwork",
  "operate",
  "refinery",
  "brochure",
  "folded",
  "folded map",
  "leaflet",
  "pamphlet",
  "paper map",
  "three panels",
  "explore map",
  "find place",
  "location search",
  "map quest",
  "route finder",
  "search map",
  "ugc",
  "as",
  "mark as unread",
  "mark unread",
  "multiple emails",
  "reopen",
  "stacked mail",
  "two messages",
  "undo read",
  "mark read",
  "read message",
  "direct message",
  "dm",
  "letter m",
  "m",
  "markup language",
  "copy to clipboard",
  "markunread",
  "postbox",
  "raised flag",
  "blending",
  "compositing",
  "effects",
  "masked",
  "masked transitions",
  "masking",
  "morph",
  "morphing",
  "spheres",
  "transformation",
  "transitions",
  "add mask",
  "add transition",
  "create mask",
  "layer mask",
  "new transition",
  "contagious",
  "face covering",
  "face mask",
  "flu",
  "medical mask",
  "personal protective equipment",
  "ppe",
  "respirator",
  "surgical mask",
  "aa",
  "capital",
  "fontsize",
  "lower case",
  "upper case",
  "case insensitive",
  "case insensitive filter",
  "case insensitive search",
  "case sensitivity",
  "disable case sensitivity",
  "ignore case",
  "match case off",
  "no case",
  "no match case",
  "text matching",
  "toggle case sensitivity",
  "match_word",
  "proofread",
  "convergence",
  "matter",
  "title bar",
  "top bar",
  "upper bar",
  "dimensions",
  "extendable",
  "measuring_tape",
  "retractable",
  "rolled",
  "sewing",
  "tailoring",
  "tape",
  "media bluetooth",
  "media off",
  "music off",
  "no music",
  "car audio",
  "connected media",
  "media embed",
  "media layers",
  "media link",
  "media merge",
  "play video",
  "shared media",
  "video link",
  "video merge",
  "computer audio",
  "external audio",
  "media output",
  "mobile audio",
  "phone audio",
  "share audio",
  "aggregation",
  "channels",
  "combination",
  "confluence",
  "mediation",
  "medical history",
  "medical id",
  "medical information card",
  "ear loops",
  "respiratory protection",
  "health services",
  "healthcare provider",
  "medical assistance",
  "medical bag",
  "medical help",
  "medical kit",
  "medical supplies",
  "cap",
  "jar",
  "medicine bottle",
  "pill bottle",
  "pills",
  "cough syrup",
  "dosage",
  "liquid medication bottle",
  "liquid medicine",
  "medications",
  "syrup",
  "boardroom",
  "book_room",
  "conference_room",
  "huddle_room",
  "meeting_room",
  "meeting_space",
  "open_door",
  "reserve",
  "cpu",
  "electronic component",
  "integrated circuit",
  "memory module",
  "micro",
  "motherboard",
  "ram",
  "rom",
  "sd",
  "semiconductor",
  "connectors",
  "memory card",
  "memory stick",
  "abstract flower",
  "cycle tracker",
  "feminine health",
  "menstrual health",
  "period tracker",
  "womb",
  "application menu",
  "close menu",
  "drawer menu",
  "menu open",
  "code merge",
  "collaborative",
  "combine data",
  "combine files",
  "data merging",
  "fusion",
  "git merge",
  "junction",
  "synthesize",
  "two way",
  "amalgamation",
  "merge type",
  "M",
  "city icon",
  "city transit",
  "initial m",
  "m logo",
  "metro system",
  "rapid transit",
  "subway system",
  "transit system",
  "underground system",
  "digital lock",
  "electronic lock",
  "mfg",
  "numeric keypad",
  "passcode",
  "pin code",
  "pin pad",
  "smart lock",
  "yale",
  "keyboard voice",
  "mic none",
  "mic off",
  "microphone off",
  "speech recognition",
  "voice command",
  "voice search",
  "audio error",
  "audio problem",
  "input error",
  "mic alert",
  "microphone error",
  "microphone problem",
  "recording error",
  "sound error",
  "sound problem",
  "speech error",
  "voice error",
  "voice problem",
  "double mic",
  "dual mic",
  "duet",
  "two microphones",
  "external mic",
  "external microphone",
  "no recording",
  "wired",
  "amoeba",
  "biohazard",
  "contamination",
  "eukaryote",
  "medical icon",
  "microbes",
  "microbiology lab",
  "microscopic",
  "prokaryote",
  "single-celled",
  "cook time",
  "microwave",
  "nuking",
  "quick meal",
  "reheat",
  "nuke",
  "achievement unlocked",
  "armed forces",
  "army",
  "bravery",
  "heroism",
  "honor",
  "insignia",
  "merit",
  "military tech",
  "privilege",
  "soldier",
  "valor",
  "veteran",
  "warrior",
  "hangouts",
  "mimo",
  "no computer",
  "no display",
  "no monitor",
  "no screen",
  "shutdown",
  "brain waves",
  "human head",
  "meditation",
  "personal growth",
  "restore down",
  "system tray",
  "window control",
  "fender bender",
  "mishap",
  "small accident",
  "wreck",
  "cheap",
  "mintmark",
  "declined video call",
  "declined videocall",
  "missed video call",
  "missed videocall",
  "rejected video call",
  "rejected videocall",
  "upward arrow",
  "videocall",
  "locating",
  "misty",
  "smog",
  "bishop's mitre",
  "cyber attacks",
  "mitre",
  "schema",
  "antibiotic",
  "booster",
  "immunization",
  "meds",
  "mixture",
  "shot",
  "vitamin",
  "image message",
  "mms",
  "multimedia message",
  "photo message",
  "picture message",
  "texting",
  "take",
  "grasp",
  "calls off",
  "cellphone off",
  "disable calls",
  "disable cellphone",
  "disable mobile",
  "disable phone",
  "disable smartphone",
  "disable texting",
  "hand off",
  "handheld off",
  "mobile off",
  "no calls",
  "no cellphone",
  "no device",
  "no handheld",
  "no smartphone",
  "no texting",
  "phone off",
  "restrict calls",
  "restrict cellphone",
  "restrict mobile",
  "restrict phone",
  "restrict smartphone",
  "restrict texting",
  "smartphone off",
  "texting off",
  "no cellular",
  "no handoff",
  "add tag",
  "create tag",
  "label phone",
  "mobile search",
  "new tag",
  "phone search",
  "tag phone",
  "mobile_off",
  "mobile application",
  "mobile screen share",
  "mobile share",
  "idle",
  "lock screen",
  "screen lock",
  "screensaver",
  "standby",
  "wallpaper",
  "ringer",
  "ringtone",
  "vibrate mode",
  "volume down",
  "volume up",
  "speakerphone",
  "cellular disabled",
  "internet disabled",
  "signal disabled",
  "comment box",
  "leave comment",
  "mode comment",
  "chiller",
  "cool mode",
  "frost",
  "ice crystal",
  "low temperature",
  "mode cool",
  "wintertime",
  "ac off",
  "air conditioning off",
  "cold off",
  "cooling off",
  "deactivate cool",
  "disable cool",
  "freeze off",
  "mode cool off",
  "no cool",
  "no cooling",
  "snowflake off",
  "stop cool",
  "stop cooling",
  "turn off cool",
  "winter off",
  "cool air",
  "four blades",
  "four leaf clover",
  "velocity",
  "disable fan",
  "fan control",
  "fan disabled",
  "mode fan off",
  "no airflow",
  "no fan",
  "no ventilation",
  "heatwave",
  "warm weather",
  "deactivate heat",
  "disable heating",
  "disabled heat",
  "fire off",
  "flame off",
  "heat disabled",
  "heat off",
  "heating disabled",
  "heating off",
  "no fire",
  "no flame",
  "no heat",
  "no heating",
  "no warmth",
  "temperature off",
  "thermostat off",
  "turn off heat",
  "turn off heating",
  "warmth off",
  "mode of travel",
  "of",
  "returning",
  "round trip",
  "on/off switch",
  "hibernate",
  "on/off",
  "deep learning",
  "iterate",
  "ml",
  "model_training",
  "neural network",
  "optimization",
  "manipulate",
  "manipulation",
  "modelling",
  "100",
  "hundred",
  "profit",
  "lend",
  "loans",
  "loot",
  "money bag",
  "money sack",
  "sack",
  "cancel payment",
  "cashback",
  "currency off",
  "dollar off",
  "money off",
  "no cost",
  "no fee",
  "no money",
  "no transaction",
  "price cut",
  "price reduction",
  "reduced price",
  "refund",
  "remove cost",
  "slashed price",
  "zero cost",
  "lcd",
  "ecc",
  "monitor_heart",
  "telehealth",
  "add weight",
  "weight tracking",
  "digital health",
  "online tracking",
  "open corner",
  "track weight",
  "weight goal",
  "weight loss",
  "weight management",
  "bw",
  "dual tone",
  "photography mode",
  "two tone",
  "elevated train",
  "reactions",
  "smiley face",
  "bad mood",
  "customer feedback",
  "disappointment",
  "frown",
  "mood bad",
  "negative emotion",
  "sad",
  "unhappiness",
  "unhappy",
  "unhappy face",
  "unpleased",
  "unsmile",
  "unsmiling",
  "upset",
  "cosmos",
  "galaxy",
  "night time",
  "twinkle",
  "bristles",
  "custodial",
  "janitor",
  "mop",
  "neaten",
  "sweep up",
  "sweeper",
  "tidy up",
  "meal delivery",
  "on-demand delivery",
  "rider",
  "actions",
  "etc",
  "show less",
  "double l",
  "see more",
  "hamburger menu alternative",
  "horiz",
  "kebab menu",
  "more actions",
  "more options",
  "add duration",
  "additional duration",
  "additional time",
  "extra duration",
  "extra time",
  "increase duration",
  "more time",
  "rescheduling",
  "time extension",
  "double line",
  "more up",
  "additional options",
  "additional settings",
  "extra options",
  "hidden menu",
  "more settings",
  "vert",
  "vertical ellipsis",
  "vertical menu",
  "arab",
  "eid",
  "holy place",
  "islam",
  "islamic",
  "masjid",
  "middle east",
  "minaret",
  "muslim",
  "pilgrimage",
  "ramadan",
  "acceleration",
  "comet",
  "motionblur",
  "streaks",
  "swift",
  "motion mode",
  "live photo",
  "motion photo",
  "disable motion photo",
  "line through circle",
  "live picture",
  "motion photos",
  "motion photos off",
  "no motion",
  "no motion photos",
  "no photos",
  "animate",
  "live photos",
  "still",
  "field of view",
  "motion ",
  "no movement",
  "not detected",
  "movement sensor",
  "motorsport",
  "two-wheeler",
  "aspiration",
  "conquer",
  "motivation",
  "mountain top",
  "overcome",
  "self help",
  "computer hardware",
  "computer peripheral",
  "scrolling",
  "click lock",
  "click restrict",
  "cursor lock",
  "mouse access",
  "mouse control",
  "mouse lock",
  "mouse restriction",
  "peripheral lock",
  "pointer lock",
  "disable mouse",
  "mouse disabled",
  "mouse off",
  "no mouse",
  "restrict mouse",
  "unlock mouse",
  "move location",
  "content movement",
  "rearrange",
  "export group",
  "import group",
  "migration",
  "move group",
  "relocate group",
  "send group",
  "shift group",
  "transfer group",
  "transition group",
  "export item",
  "item management",
  "move item",
  "relocate item",
  "send item",
  "share item",
  "shift item",
  "transfer item",
  "change address",
  "direction arrow",
  "person location",
  "search location",
  "user location",
  "move selection",
  "content arrangement",
  "element movement",
  "layer adjustment",
  "move selection left",
  "position adjustment",
  "realign",
  "move selection up",
  "compile",
  "moved",
  "directing",
  "hollywood",
  "shooting",
  "film editing",
  "filmmaker",
  "movie editing",
  "movie maker",
  "post-production",
  "film details",
  "movie information",
  "movie reel",
  "synopsis",
  "block film",
  "block movie",
  "block video",
  "cancel film",
  "cancel movie",
  "cancel video",
  "cinema off",
  "clapperboard off",
  "disabled film",
  "disabled movie",
  "disabled video",
  "end film",
  "end movie",
  "film off",
  "film slate",
  "movie off",
  "movie slate",
  "no cinema",
  "no film",
  "no movie",
  "restrict film",
  "restrict movie",
  "restrict video",
  "stop film",
  "stop movie",
  "advancement",
  "ascending",
  "change rooms",
  "department transfer",
  "healthcare move",
  "hospital bed",
  "medical transfer",
  "move patient",
  "move ward",
  "moving_beds",
  "patient move",
  "patient transfer",
  "room change",
  "transfer bed",
  "ward change",
  "company move",
  "ministry",
  "move office",
  "relocation",
  "audio format",
  "digital media",
  "media format",
  "mp4",
  "crock-pot",
  "electric cooker",
  "instant pot",
  "multicooker",
  "pressure cooker",
  "slow cooker",
  "multiline chart",
  "hand eye coordination",
  "human computer interaction",
  "airports",
  "destinations",
  "locations",
  "multi-city",
  "multi-city flight",
  "multiple airports",
  "waypoints",
  "left and right",
  "multi-stop",
  "attraction",
  "exhibit",
  "exhibition",
  "family trip",
  "field trip",
  "school trip",
  "visit",
  "audio cast",
  "audio sharing",
  "broadcasting",
  "music broadcast",
  "music share",
  "music streaming",
  "sound stream",
  "audiotrack",
  "eighth note",
  "quaver",
  "single note",
  "soundtrack",
  "add audio",
  "add music",
  "add sound",
  "audio plus",
  "create audio",
  "create music",
  "create sound",
  "include audio",
  "include music",
  "include sound",
  "insert audio",
  "insert music",
  "insert sound",
  "music plus",
  "new audio",
  "new music",
  "new sound",
  "plus audio",
  "plus music",
  "plus sound",
  "sound plus",
  "disable music",
  "music disabled",
  "turn off music",
  "turn off sound",
  "music video",
  "my location",
  "whereabouts",
  "detective",
  "eyeball",
  "magnify glass",
  "mystery",
  "thrillers",
  "nat",
  "network address translation",
  "port forwarding",
  "arbor",
  "flora",
  "greenery",
  "roots",
  "sapling",
  "seedling",
  "trunk",
  "nature walk",
  "find me",
  "me",
  "near",
  "near me",
  "find disabled",
  "location services disabled",
  "near me disabled",
  "pin disabled",
  "pinpoint disabled",
  "place disabled",
  "proximity disabled",
  "search disabled",
  "around me",
  "points of interest",
  "surroundings",
  "vicinity",
  "gps error",
  "map error",
  "nearby issue",
  "nearby problem",
  "proximity alert",
  "area disabled",
  "area off",
  "local disabled",
  "local off",
  "nearby_off",
  "neighborhood disabled",
  "neighborhood off",
  "proximity off",
  "surrounding",
  "surrounding disabled",
  "surrounding off",
  "vicinity disabled",
  "vicinity off",
  "abstract kidney",
  "bladder",
  "clinical",
  "dual kidney",
  "human organ",
  "human organs",
  "kidney",
  "kidney icon",
  "kidney symbol",
  "kidneys",
  "mirrored kidney",
  "nephrology",
  "renal",
  "ureter",
  "urethra",
  "urinary",
  "urinary system",
  "urology",
  "google nest",
  "nest hub",
  "nest mini",
  "floodlight",
  "iq",
  "nest cam",
  "protext",
  "nest cam iq",
  "mounted",
  "wall mount",
  "adhesion",
  "magnet",
  "magnet mount",
  "magnetic mount",
  "mounting",
  "wifi camera",
  "swivel",
  "wall ",
  "internet camera",
  "watching",
  "12:36",
  "twelve thirty-six",
  "linking",
  "hub max",
  "nest display max",
  "doorbell cam",
  "remote monitoring",
  "rebate",
  "gen",
  "gen 3",
  "heat link",
  "nest thermostat",
  "intercom",
  "nest hello",
  "smart doorbell",
  "video doorbell",
  "ornament",
  "pendant",
  "floor plan",
  "multi",
  "multi-room",
  "multiple rooms",
  "rooms",
  "carbon monoxide detector",
  "nest protect",
  "smarthouse",
  "access code",
  "nest secure",
  "nine dots",
  "sunblock",
  "sunscreen",
  "ultraviolet",
  "uv",
  "locator",
  "70",
  "digital thermostat",
  "frostat",
  "room temperature",
  "temperature setting",
  "nest thermostat e",
  "nest thermostat eu",
  "generation 3",
  "nest gen 3",
  "nest learning thermostat",
  "zirconium",
  "double u",
  "flowing",
  "meander",
  "meandering",
  "serpentine",
  "snake",
  "winding",
  "approach",
  "approach detection",
  "proximity sensor",
  "user presence",
  "wake on approach",
  "power on",
  "extender",
  "repeater",
  "vento",
  "pro",
  "single dot",
  "curved rectangle",
  "mesh network",
  "mistral",
  "network cell",
  "diagnose",
  "network check",
  "network performance",
  "speed test",
  "wi-fi",
  "clever",
  "connected nodes",
  "digital brain",
  "distributed network",
  "network connections",
  "network intelligence node",
  "smart network",
  "hemispheres",
  "network analysis",
  "network diagram",
  "network intelligence",
  "ai history",
  "ai network",
  "deep learning history",
  "intelligence history",
  "intelligence timeline",
  "machine learning history",
  "machine learning network",
  "network activity",
  "network history",
  "network insights",
  "network intelligence history",
  "network intelligence log",
  "network log",
  "network timeline",
  "neural network history",
  "past intelligence",
  "past network activity",
  "brain icon",
  "cognitive",
  "connection security",
  "network access",
  "network locked",
  "network symbol",
  "network unavailable",
  "private network",
  "restricted network",
  "secure network",
  "signal lock",
  "signal secure",
  "wifi locked",
  "wifi security",
  "wireless locked",
  "wireless security",
  "wireless symbol",
  "internet management",
  "internet settings",
  "network configuration",
  "wifi icon",
  "wifi management",
  "wifi settings",
  "wireless management",
  "wireless settings",
  "joined",
  "network topology",
  "echo",
  "ping",
  "sonar",
  "radiating lines",
  "radio waves",
  "internet signal",
  "low wifi",
  "network bars",
  "poor connection",
  "weak wifi",
  "wifi bars",
  "wifi signal",
  "wifi status",
  "wifi strength",
  "wireless status",
  "network lock",
  "wifi connection",
  "wifi lock",
  "wireless lock",
  "internet icon",
  "internet status",
  "medium signal",
  "wireless fidelity",
  "locked network",
  "secure wifi",
  "3 bars",
  "moderate signal",
  "full signal",
  "strong signal",
  "wep",
  "wpa",
  "brainstorm",
  "central nervous system",
  "nervous system",
  "neural",
  "neurologist",
  "add label",
  "create label",
  "forward arrow",
  "add tab",
  "browser tab",
  "browser window",
  "create tab",
  "open in new tab",
  "open window",
  "tab management",
  "newsletter",
  "current events",
  "digital news",
  "newsmode",
  "online news",
  "jagged edge",
  "periodical",
  "articles",
  "leaning",
  "newsstand",
  "next plan",
  "next song",
  "progression",
  "next week",
  "mobile payment",
  "payment off",
  "homeless",
  "homelessness",
  "night_shelter",
  "nonprofit",
  "refuge",
  "resting place",
  "sanctuary",
  "temporary housing",
  "auto night sight",
  "night sight",
  "night view",
  "auto adjust",
  "auto night mode off",
  "auto rotate",
  "night photography",
  "late night",
  "night sight max",
  "dance",
  "nightlife icon",
  "astronomy icon",
  "bedtime story",
  "night icon",
  "nightlight",
  "sleep icon",
  "honeymoon",
  "nights",
  "nights_stay",
  "phases",
  "ban user",
  "block user",
  "cancel account",
  "delete account",
  "no accounts",
  "no login",
  "no registration",
  "no sign in",
  "remove user",
  "unidentifiable",
  "adult content ban",
  "block adult content",
  "child safe",
  "explicit content ban",
  "family friendly",
  "mature content ban",
  "no 18+",
  "no adult",
  "no adult content",
  "no explicit content",
  "no mature content",
  "no nsfw",
  "no nudity",
  "no pornography",
  "no sex",
  "no xxx",
  "nsfw ban",
  "pornography ban",
  "prohibition sign",
  "restricted content",
  "under 18 restricted",
  "xxx forbidden",
  "bag ban",
  "baggage restriction",
  "luggage ban",
  "luggage restriction",
  "no backpack",
  "no backpacks allowed",
  "no baggage",
  "no bags",
  "no bags allowed",
  "no carry on",
  "no knapsack",
  "no large bags",
  "no luggage",
  "no personal items",
  "no rucksack",
  "no school bags",
  "pack ban",
  "school ban",
  "school restriction",
  "travel ban",
  "travel restriction",
  "accident prevention",
  "car check",
  "no accident",
  "no crash",
  "road safety",
  "safe car",
  "secure car",
  "cocktail glass",
  "do not drink",
  "drinks",
  "martini glass",
  "no alcohol",
  "no beer",
  "no beverages",
  "no cocktails",
  "no drinking",
  "no drinks",
  "no liquids",
  "no wine",
  "sobriety",
  "temperance",
  "unprotected",
  "disable flash",
  "flash forbidden",
  "flash off",
  "flash prohibited",
  "no photo flash",
  "no photography",
  "no pictures",
  "photography disabled",
  "photography restriction",
  "pictures disabled",
  "dieting",
  "do not eat",
  "do not eat here",
  "dont",
  "eating prohibited",
  "fasting",
  "food prohibited",
  "food restriction",
  "no consumption",
  "no eating",
  "no food",
  "no food allowed",
  "no food or drink",
  "no meals",
  "no snacks",
  "restricted food",
  "disallowed",
  "no carry-on",
  "no hand luggage",
  "no suitcase",
  "no travel",
  "restricted luggage",
  "avoid food",
  "cleanse",
  "cutlery ban",
  "detox",
  "dining restrictions",
  "food break",
  "fork and knife",
  "hunger strike",
  "intermittent fasting",
  "no breakfast",
  "no dining",
  "no dinner",
  "no lunch",
  "no utensils",
  "restricted diet",
  "skip meal",
  "appointment cancelled",
  "booking cancelled",
  "conference room unavailable",
  "meeting cancelled",
  "meeting unavailable",
  "no appointments",
  "no availability",
  "no bookings",
  "no conference room",
  "no meeting",
  "no meeting room",
  "no room available",
  "no rooms",
  "room unavailable",
  "camera ban",
  "capture ban",
  "do not record",
  "film ban",
  "image ban",
  "no capture",
  "no images",
  "photo off",
  "photography ban",
  "picture ban",
  "record off",
  "video ban",
  "insert sim",
  "missing sim",
  "network strength",
  "no sim",
  "sim card",
  "sim error",
  "Volume",
  "audio mute",
  "audio with x",
  "crossed out speaker",
  "disable volume",
  "no volume",
  "sound mute",
  "sound with x",
  "speaker disabled",
  "speaker mute",
  "speaker off",
  "speaker with x",
  "turn off audio",
  "turn off volume",
  "volume disabled",
  "volume mute",
  "volume with x",
  "no babies",
  "no children",
  "no stroller",
  "bus stop closed",
  "bus unavailable",
  "no bus",
  "no coach",
  "no service",
  "no shuttle",
  "no transportation",
  "public transport unavailable",
  "transportation disabled",
  "ambient noise",
  "noise cancellation",
  "noise control",
  "noise_aware",
  "sound sensitivity",
  "mute audio",
  "mute sound",
  "noise cancellation off",
  "noise control off",
  "noise reduction off",
  "activate audio",
  "audio on",
  "enable sound",
  "noise on",
  "sound activated",
  "sound enabled",
  "unmuted",
  "cross-country",
  "figure walking",
  "nordic walking",
  "poles",
  "snowshoeing",
  "sticks",
  "noth",
  "up right",
  "upper right",
  "arrow pointing northwest",
  "arrow pointing top left",
  "arrow pointing up left",
  "north west",
  "top-left",
  "up-left",
  "accessibility restriction",
  "disabled access",
  "inaccessible",
  "mobility impaired",
  "no disabilities",
  "no wheelchair",
  "not accessible",
  "wheelchair access denied",
  "wheelchair symbol",
  "wheelchair user",
  "disabled person",
  "no go",
  "no wheelchair access",
  "wheelchair inaccessible",
  "explore location",
  "explore place",
  "hidden location",
  "listed",
  "mystery location",
  "not listed location",
  "search place",
  "secret location",
  "uncharted territory",
  "undiscovered location",
  "unknown area",
  "unknown place",
  "unlisted location",
  "unmarked place",
  "where",
  "not started",
  "started",
  "unpause",
  "create file",
  "document creation",
  "file creation",
  "new file",
  "alternative note",
  "jot down",
  "note alt",
  "note pad",
  "take notes",
  "papers",
  "post it",
  "post-it",
  "sticky note",
  "sticky notes",
  "memo pad",
  "add alert",
  "create notification",
  "enable notifications",
  "new notification",
  "notification control",
  "notification management",
  "notification on",
  "notification plus",
  "subscribe to notifications",
  "turn on notifications",
  "alert bell",
  "application notification",
  "essential notification",
  "important update",
  "status update",
  "system notification",
  "time sensitive",
  "warning bell",
  "alert control",
  "alert management",
  "alert preferences",
  "bell settings",
  "audio notification",
  "bell curve",
  "notification sound",
  "ringing bell",
  "sound effect",
  "warnings",
  "active notification",
  "alerts disabled",
  "alerts off",
  "bell with slash",
  "crossed out bell",
  "disable alerts",
  "disable notifications",
  "notification disabled",
  "notifications off",
  "slashed bell",
  "turn off notifications",
  "notification paused",
  "notifications paused",
  "ring --- pause",
  "z",
  "zzz",
  "announcements",
  "facebook",
  "hash",
  "instagram",
  "tagging",
  "tagging symbol",
  "twitter",
  "citrus",
  "healthy eating",
  "minerals",
  "plant-based",
  "vitamins",
  "calc",
  "libreoffice",
  "ods",
  "office suite",
  "open document",
  "open document spreadsheet",
  "openoffice",
  "workbook",
  "editable",
  "odt",
  "open format",
  "word document alternative",
  "word processing document",
  "no power",
  "not available",
  "offline bolt",
  "power outage",
  "synced",
  "map marker off",
  "offline location",
  "unavailable location",
  "device to device",
  "offline share",
  "barrel",
  "commodity",
  "crude oil",
  "drum",
  "energy industry",
  "fossil fuel",
  "oil barrel",
  "oil drop",
  "oil industry",
  "petroleum",
  "mobile learning",
  "mobile training",
  "on device",
  "on-device",
  "active device",
  "connected device",
  "device hub",
  "device on",
  "hub device",
  "cancer",
  "cancer diagnosis",
  "cancer treatment",
  "find oncology",
  "health research",
  "healthcare icon",
  "oncology",
  "oncology research",
  "physician",
  "search oncology",
  "anticipate",
  "foresee",
  "bowl",
  "japanese bath",
  "rising steam",
  "thermal bath",
  "alpha",
  "see-through",
  "translucent",
  "external program",
  "open in browser",
  "open link",
  "open in full",
  "external website",
  "offsite link",
  "external link off",
  "launch off",
  "new window off",
  "open in new off",
  "open off",
  "pop out off",
  "jam",
  "jam session",
  "open jam",
  "fullscreen mode",
  "breakout",
  "cardinal directions",
  "open with",
  "eye care",
  "ophthalmology",
  "optometry",
  "vision care",
  "abstract teeth",
  "bad breath",
  "cavities",
  "gingivitis",
  "gum disease",
  "gums",
  "halitosis",
  "oral health",
  "periodontitis",
  "plaque",
  "tooth decay",
  "tooth icon",
  "two teeth",
  "dv360",
  "outer space",
  "physics",
  "planetary",
  "solar system",
  "universe",
  "checkmark circle",
  "order approve",
  "begin order",
  "begin process",
  "execute order",
  "execute process",
  "order execution",
  "play document",
  "play list",
  "play order",
  "process order",
  "run order",
  "run process",
  "start order",
  "start process",
  "open box",
  "packaged",
  "unboxing",
  "backbone",
  "physical therapy",
  "physiotherapy",
  "posture",
  "spinal",
  "vertebrae",
  "vertebral column",
  "alternative admission",
  "other admission",
  "pend",
  "special admission",
  "accommodations",
  "listings",
  "multiple houses",
  "other houses",
  "suburb",
  "offsite",
  "outbound",
  "dispatch",
  "front yard",
  "three pickets",
  "charcoal",
  "grilling",
  "hotdog",
  "outdoor cooking",
  "steak",
  "mail out",
  "outgoing mail",
  "send mail",
  "share email",
  "connecter",
  "electric socket",
  "electrical outlet",
  "power outlet",
  "three prongs",
  "two prongs",
  "wall socket",
  "day care",
  "discharge",
  "facility",
  "non-resident",
  "outpatient",
  "short stay",
  "cooker",
  "cooking appliance",
  "heet",
  "roast",
  "birdwatching",
  "nocturnal",
  "ornithology",
  "predator",
  "wise",
  "blood oxygen",
  "breathing",
  "lungs",
  "nostril",
  "oximetry",
  "oxygen level",
  "pulse ox",
  "pulse oximeter",
  "respiration",
  "spo2",
  "data bridge",
  "data sharing",
  "file sharing",
  "p2p",
  "peer",
  "peer to peer",
  "peer-to-peer",
  "peers",
  "life support",
  "pacemaker",
  "isometric",
  "negative space",
  "offset",
  "white space",
  "current page",
  "image slider",
  "onboarding",
  "page control",
  "paging",
  "steppers",
  "walkthrough",
  "end of page",
  "page footer",
  "privacy policy",
  "terms of service",
  "underneath",
  "page header",
  "doc info",
  "document details",
  "document information",
  "document symbol",
  "file details",
  "file information",
  "info symbol",
  "page details",
  "page info",
  "page information",
  "page symbol",
  "borderless",
  "continuous view",
  "edge to edge",
  "frameless",
  "no breaks",
  "no pages",
  "pageless",
  "seamless",
  "gplus",
  "pageview",
  "site search",
  "dues",
  "paid",
  "cmyk",
  "color lens",
  "color scheme",
  "color selection",
  "color theory",
  "color wheel",
  "rgb",
  "swatch",
  "crate",
  "skid",
  "drag tool",
  "grab tool",
  "three fingers",
  "viewport",
  "pan down",
  "pan left",
  "pan right",
  "pan up",
  "shrink view",
  "zooms",
  "planner",
  "ultrawide",
  "wide angle",
  "360 view",
  "full view",
  "panoramic view",
  "photosphere",
  "surround view",
  "vertical panorama",
  "air sports",
  "gliding",
  "hang gliding",
  "harness",
  "parachute",
  "paragliding",
  "skydiving",
  "evergreen icon",
  "fir tree icon",
  "pine tree icon",
  "state park",
  "three triangles",
  "tree icon",
  "afternoon",
  "broken clouds",
  "cloudy sunshine",
  "light cloud",
  "mostly sunny",
  "partial cloud",
  "scattered clouds",
  "sun and cloud",
  "sun behind cloud",
  "sun icon",
  "sun rays",
  "sunny intervals",
  "cloud cover",
  "cloudy night",
  "moon phase",
  "night sky",
  "partially cloudy",
  "partly cloudy night",
  "partner",
  "partner report",
  "partner reports",
  "partners",
  "moment",
  "party mode",
  "account key",
  "key management",
  "passkey",
  "personal key",
  "secure key",
  "signin",
  "user access",
  "user key",
  "asterisks",
  "redacted",
  "three stars",
  "horizontal bar",
  "hide password",
  "mask password",
  "password disabled",
  "password hidden",
  "password off",
  "password visibility",
  "show password",
  "toggle password",
  "unmask password",
  "view password",
  "health records",
  "medical records",
  "patient list",
  "person list",
  "user list",
  "control button",
  "double bar",
  "intermission",
  "media button",
  "playback control",
  "filled",
  "outlined",
  "solid",
  "pause presentation",
  "presentation control",
  "slide deck",
  "stop button",
  "video conferencing",
  "payments",
  "bicycle icon",
  "biking",
  "pedal",
  "pedal bike",
  "baby bottle",
  "child health",
  "feeding bottle",
  "pacifier",
  "pediatrics",
  "fine",
  "oblique line",
  "pen stroke",
  "pen tool",
  "thin",
  "pen_size_2",
  "pen size",
  "pen_size_3",
  "pending action",
  "pending task",
  "queued",
  "delayed",
  "pending actions",
  "postponed",
  "five sides",
  "five-angled",
  "five-sided",
  "regular pentagon",
  "%",
  "per hundred",
  "gazebo",
  "outdoor structure",
  "pergola",
  "posts",
  "trellis",
  "audio conference",
  "min",
  "perm",
  "calendar appointment",
  "contact calendar",
  "contact date",
  "contact event",
  "person calendar",
  "profile calendar",
  "schedule appointment",
  "user calendar",
  "user event",
  "adjust angle",
  "change angle",
  "data adjust",
  "data configuration",
  "data permission",
  "data setting",
  "data transformation",
  "perm data setting",
  "about device",
  "about phone",
  "device details",
  "device info",
  "handset information",
  "mobile device information",
  "mobile information",
  "mobile specs",
  "phone details",
  "specifications",
  "perm_media",
  "msg",
  "phone message",
  "connection details",
  "connection help",
  "connection info",
  "info icon",
  "internet details",
  "internet help",
  "internet info",
  "network details",
  "network help",
  "network info",
  "signal details",
  "signal help",
  "signal info",
  "wifi details",
  "wifi help",
  "wifi info",
  "wireless details",
  "wireless help",
  "wireless info",
  "person outline",
  "2 people",
  "person_2",
  "torso",
  "3 users",
  "multiple people",
  "people group",
  "users group",
  "four people",
  "group of people",
  "team of four",
  "add contact",
  "create contact",
  "create person",
  "create user",
  "new contact",
  "new member",
  "new person",
  "person plus",
  "plus person",
  "user plus",
  "add person disabled",
  "add user disabled",
  "cannot add",
  "create user disabled",
  "forbid",
  "new user disabled",
  "no add",
  "no new users",
  "person add disabled",
  "person_alert",
  "apron",
  "barista",
  "bartender",
  "butcher",
  "craftsman",
  "gardener",
  "laborer",
  "painter",
  "potter",
  "protective gear",
  "waiter",
  "waitress",
  "biography",
  "memoir",
  "account deletion",
  "account removal",
  "block friend",
  "block person",
  "cancel person",
  "cancel user",
  "delete friend",
  "delete person",
  "delete user",
  "person deletion",
  "person removal",
  "person x",
  "person_cancel",
  "profile deletion",
  "profile removal",
  "remove friend",
  "remove person",
  "user deletion",
  "user removal",
  "user x",
  "juggle",
  "juggling",
  "person_celebrate",
  "talent",
  "person check",
  "user check",
  "account off",
  "ban person",
  "deactivate account",
  "disable person",
  "disable user",
  "hide person",
  "hide user",
  "person blocked",
  "person off",
  "profile off",
  "user off",
  "contact location",
  "person pin",
  "profile location",
  "coordinate",
  "location marker",
  "map pointer",
  "person marker",
  "user pin",
  "entertain",
  "multitask",
  "person_play",
  "trick",
  "tricks",
  "ask question",
  "raise hand",
  "simple person",
  "volunteer",
  "account delete",
  "account remove",
  "delete profile",
  "minus person",
  "person block",
  "person delete",
  "person minus",
  "person subtract",
  "person_remove",
  "profile delete",
  "profile remove",
  "remove account",
  "remove profile",
  "subtract person",
  "user block",
  "user delete",
  "user minus",
  "person_search",
  "account security",
  "member protection",
  "profile security",
  "security settings",
  "user privacy",
  "user security",
  "haversack",
  "personal items",
  "satchel",
  "baggage restrictions",
  "luggage restrictions",
  "no bag",
  "no satchel",
  "personal item restriction",
  "uncertainty",
  "broke",
  "broken arm",
  "claim",
  "personal injury",
  "worker's compensation",
  "custom locations",
  "favorite places",
  "my places",
  "placemark",
  "saved places",
  "user locations",
  "ant",
  "anti pest",
  "beetle",
  "bug fix",
  "bug spray",
  "cockroach",
  "eliminate pest",
  "extermination",
  "exterminator",
  "fix bug",
  "insect control",
  "insecticide",
  "kill bug",
  "pest",
  "pest control",
  "pest removal",
  "remove bug",
  "software bug",
  "spider",
  "bait",
  "health hazard",
  "home pest",
  "household pests",
  "infestation",
  "mammal",
  "mice",
  "pest problem",
  "rat",
  "rats",
  "rodent",
  "rodent control",
  "trap",
  "unwanted guest",
  "vermin",
  "animal food",
  "animal supplies",
  "cat",
  "chew toy",
  "dog treat",
  "kitten",
  "pet food",
  "pet products",
  "pet shop",
  "pet store",
  "pet supplies",
  "puppy",
  "adoption",
  "animal footprint",
  "animal paw",
  "animal shelter",
  "animal track",
  "companion animal",
  "domestic animal",
  "fauna",
  "four paws",
  "four toes",
  "paw",
  "paw print",
  "pawpads",
  "pet care",
  "pets",
  "veterinary",
  "account takeover",
  "cyber security",
  "cybercrime",
  "fish hook",
  "fishing",
  "fraud",
  "hack",
  "identity theft",
  "internet fraud",
  "lure",
  "malicious",
  "online fraud",
  "phishing",
  "scam",
  "suspicious",
  "android phone",
  "android phone icon",
  "button icon",
  "cellular icon",
  "device icon",
  "digital icon",
  "display icon",
  "dot icon",
  "electronics icon",
  "gadget icon",
  "handheld icon",
  "mobile phone icon",
  "portable icon",
  "rectangle icon",
  "rounded rectangle icon",
  "screen icon",
  "technology icon",
  "hands free",
  "helpdesk",
  "inbound call",
  "phone and arrow",
  "phone arrow",
  "return call",
  "calling disabled",
  "no calling",
  "phone disabled",
  "make a call",
  "receive a call",
  "call divert",
  "call redirect",
  "forwarded",
  "forwarding",
  "telephone forwarding",
  "telephone redirect",
  "telephone transfer",
  "active call",
  "in call",
  "ongoing call",
  "call blocked",
  "call lock",
  "call restriction",
  "incoming call lock",
  "outgoing call lock",
  "phone locked",
  "phone restriction",
  "phone security",
  "missed notification",
  "call paused",
  "communication paused",
  "hold call",
  "mute call",
  "pause call",
  "phone paused",
  "break link",
  "mobile connection",
  "phone management",
  "call mute",
  "call silence",
  "no mobile signal",
  "no ring",
  "notification mute",
  "notification silence",
  "app_settings_alt",
  "application settings",
  "mobile gear",
  "mobile_gear",
  "phonelink_setup",
  "picture frame",
  "bookmarked album",
  "favorite album",
  "image folder",
  "memories",
  "photo album",
  "photo archive",
  "photo storage",
  "picture archive",
  "picture folder",
  "picture gallery",
  "saved album",
  "scrapbook",
  "photo auto merge",
  "best take",
  "capture icon",
  "camera mode",
  "toggle camera",
  "account image",
  "front facing camera",
  "photo capture",
  "profile image",
  "user image",
  "user photo",
  "digital photo",
  "picture viewer",
  "hard copy",
  "photo prints",
  "physical photo",
  "photo frame",
  "photo settings",
  "picture settings",
  "dynamic website",
  "hypertext preprocessor",
  "php",
  "php development",
  "scripting language",
  "server-side scripting",
  "web application",
  "physical therapist",
  "pose",
  "rehab center",
  "stretching",
  "therapy session",
  "yoga",
  "audio app",
  "black keys",
  "chords",
  "digital piano",
  "midi",
  "music app",
  "musical instrument",
  "musical keys",
  "piano",
  "synthesizer",
  "three keys",
  "white keys",
  "no piano",
  "no playing",
  "piano keys",
  "acrobat",
  "adobe",
  "pdf",
  "portable document format",
  "cropped",
  "displays",
  "floating video",
  "multi window",
  "nested window",
  "overlay window",
  "pip",
  "pop-out video",
  "sizes",
  "small window",
  "talktrack",
  "video overlay",
  "multiscreen",
  "nested square",
  "expand window",
  "large view",
  "multi-window",
  "shrink window",
  "mini player",
  "no pip",
  "picture-in-picture",
  "pop up",
  "compact view",
  "pie graph",
  "painkiller",
  "capsules",
  "illicit",
  "medication off",
  "no drugs",
  "no medication",
  "no pills",
  "pills off",
  "stop medication",
  "stop pills",
  "tablets",
  "treatment off",
  "latitude",
  "longitude",
  "pin drop",
  "invoke",
  "pin invoke",
  "pin note",
  "pin push",
  "pin tack",
  "pinboard",
  "sticky",
  "mobile gesture",
  "multitouch",
  "nip",
  "shrink arrows",
  "tweak",
  "two fingers",
  "expand gesture",
  "image scaling",
  "map scaling",
  "pinch gesture",
  "two finger",
  "zoom control",
  "zoom gesture",
  "zoom in gesture",
  "pinch out",
  "mini view",
  "pip exit",
  "bi",
  "data manipulation",
  "pivot",
  "pivot chart",
  "pivot table",
  "place item",
  "put",
  "honesty",
  "integrity",
  "originality",
  "plagiarism",
  "plagiarism check",
  "asteroid",
  "extraterrestrial",
  "gas giant",
  "ringed planet",
  "saturn",
  "sci-fi",
  "pt",
  "audio visual",
  "play circle",
  "start playback",
  "blocked play",
  "cant play",
  "disabled play",
  "inactive play",
  "no play",
  "play blocked",
  "play disabled",
  "play off",
  "play restriction",
  "restrict play",
  "stop play",
  "unavailable play",
  "unplayable",
  "begin task",
  "download for work",
  "duty",
  "play for work",
  "start work",
  "work assignment",
  "audio lesson",
  "begin lesson",
  "online course",
  "play course",
  "play lesson",
  "play tutorial",
  "play_lesson",
  "start course",
  "start lesson",
  "video lesson",
  "play/pause",
  "right triangle",
  "blackjack",
  "card deck",
  "card game",
  "clubs",
  "hearts",
  "playing",
  "playing cards",
  "poker",
  "solitaire",
  "spades",
  "suit",
  "suits",
  "append to playlist",
  "create playlist",
  "new playlist",
  "playlist complete",
  "playlist confirmed",
  "playlist created",
  "playlist success",
  "playlist valid",
  "save playlist",
  "check circle",
  "confirmed playlist",
  "playlist addition",
  "playlist checked",
  "add song",
  "audio playlist",
  "media playlist",
  "music playlist",
  "play icon",
  "play playlist",
  "playlist icon",
  "start playlist",
  "adjustable wrench",
  "pipe wrench",
  "plumbing service",
  "podcasts",
  "boots",
  "chiropodist",
  "chiropody",
  "foot care",
  "foot health",
  "insole",
  "lower leg",
  "shoes",
  "toe",
  "conference equipment",
  "dais",
  "debate",
  "keynote",
  "lectern",
  "microphone stand",
  "presentation stand",
  "public speaking",
  "pulpit",
  "rostrum",
  "seminar equipment",
  "speaking engagement",
  "cash register",
  "cashier",
  "merchant",
  "four rectangles",
  "casino token",
  "coins",
  "gambling chip",
  "jackpot",
  "slots",
  "winnings",
  "find policy",
  "inspect policy",
  "policy inspection",
  "policy review",
  "policy search",
  "review policy",
  "search policy",
  "security policy",
  "inspection",
  "policy breach",
  "policy violation",
  "angles",
  "multi-point",
  "three points",
  "vertices",
  "material",
  "plastic",
  "polymer",
  "synthetic",
  "dive",
  "diving",
  "person swimming",
  "swimmer",
  "swimming",
  "wavy lines",
  "mobile hotspot",
  "personal hotspot",
  "tether",
  "bottom left",
  "z-index",
  "position bottom right",
  "compose post",
  "create post",
  "write post",
  "flowerpot",
  "houseplant",
  "indoor plant",
  "planter",
  "potted",
  "potted plant",
  "two leaves",
  "reboot",
  "power input",
  "appliance off",
  "computer off",
  "off switch",
  "power plug",
  "system off",
  "technology off",
  "system settings",
  "power control",
  "universal power symbol",
  "asr",
  "dhuhr",
  "fajr",
  "isha",
  "islamic calendar",
  "maghrib",
  "prayer times",
  "rub el hizb",
  "salah",
  "articulated arm",
  "clamp",
  "industrial robot",
  "mechanical arm",
  "robotic arm",
  "robotic automation",
  "three claws",
  "childbirth",
  "dad",
  "expectant mother",
  "expecting",
  "gestation",
  "paternity",
  "pregnant",
  "prescriptions",
  "present to all",
  "send to all",
  "triangle up",
  "pre-view",
  "quick view",
  "block preview",
  "cancel preview",
  "disable preview",
  "eye closed",
  "hide view",
  "monitor off",
  "no eye",
  "no preview",
  "presentation off",
  "preview_off",
  "screen off",
  "stop preview",
  "cost change",
  "price change",
  "pricing",
  "hardcopy",
  "local print",
  "local printshop",
  "print job",
  "printing",
  "printshop",
  "add print job",
  "add print task",
  "add printer",
  "create printer",
  "new print job",
  "new printer",
  "print document",
  "print queue",
  "print task",
  "print connected",
  "printer ready",
  "select printer",
  "block print",
  "cannot print",
  "crossed out print",
  "disable print",
  "disabled printer",
  "forbidden print",
  "no print",
  "no printer",
  "no printing",
  "off printer",
  "print block",
  "print crossed out",
  "print disabled",
  "print forbidden",
  "print off",
  "print restriction",
  "print slash",
  "print stop",
  "print unavailable",
  "printer disabled",
  "printer off",
  "printer unavailable",
  "printing disabled",
  "printing off",
  "restrict print",
  "slash print",
  "stop print",
  "unavailable print",
  "document error",
  "print error",
  "print fail",
  "print warning",
  "printer error",
  "printer issue",
  "printer warning",
  "printing failure",
  "printing problem",
  "confidential printing",
  "document security",
  "lock print",
  "manage printing",
  "print access",
  "print job security",
  "print lock",
  "print management",
  "print permissions",
  "print restrictions",
  "print security",
  "printing restrictions",
  "private printing",
  "protected printing",
  "restricted printing",
  "secure document printing",
  "secure print",
  "secure print job",
  "tick box",
  "microphone disabled",
  "recording disabled",
  "recording off",
  "private information",
  "security tip",
  "closed network",
  "intranet",
  "isolated",
  "private link",
  "secure connection",
  "secure link",
  "tunnel",
  "virtual private network",
  "vpn",
  "execution",
  "method",
  "operating room",
  "slants",
  "slashes",
  "stages",
  "out of stock",
  "finish task",
  "loading animation",
  "progress animation",
  "artificial",
  "autocomplete",
  "genai",
  "predictive text",
  "prompt_suggestion",
  "camping gear",
  "energy source",
  "fuel tank",
  "gas canister",
  "gas cylinder",
  "heating fuel",
  "propane tank",
  "camping fuel",
  "liquid propane gas",
  "lpg",
  "propane gas",
  "valve",
  "brain health",
  "emotional health",
  "flourish",
  "new beginnings",
  "psychiatry",
  "thrive",
  "ability",
  "behavior",
  "brain function",
  "intellectual",
  "psychiatric",
  "psychology settings",
  "confusion",
  "curiosity",
  "psychology_alt",
  "wonder",
  "dissemination",
  "everyone",
  "no public access",
  "public_off",
  "unshare",
  "go live",
  "share online",
  "modification",
  "published",
  "abstract lungs",
  "airways",
  "alveoli",
  "breath",
  "bronchi",
  "bronchial tubes",
  "chest",
  "exhale",
  "inhale",
  "lung",
  "pulmonology",
  "stylized lungs",
  "thorax",
  "trachea",
  "emergency alert",
  "health alert",
  "heart issue",
  "heartbeat alert",
  "irregular heartbeat",
  "loss of pulse",
  "medical alert",
  "pulse rate",
  "vital sign alert",
  "clock in",
  "clock out",
  "payroll",
  "punch",
  "punch clock",
  "time clock",
  "timecard",
  "timekeeping",
  "timesheet",
  "work hours",
  "2d code",
  "barcode scan",
  "digital code",
  "mobile scan",
  "mobile tag",
  "qr",
  "qrcode",
  "quick response",
  "quick response code",
  "squares and pixels",
  "two-dimensional code",
  "urls",
  "qr code 2",
  "scannable",
  "square code",
  "add qr",
  "create qr",
  "generate qr",
  "new qr code",
  "qr code add",
  "qr code create",
  "qr code generate",
  "qr code plus",
  "mobile scanning",
  "read qr",
  "read qr code",
  "data insights",
  "data metrics",
  "query_stats",
  "search data",
  "search trends",
  "trend analysis",
  "knowledge sharing",
  "question exchange",
  "interrogation",
  "music queue",
  "now playing",
  "playlist queue",
  "queue music",
  "song list",
  "up next",
  "media queue",
  "next up",
  "play next",
  "queue management",
  "automated response",
  "canned response",
  "phrases",
  "quick phrases",
  "cheat sheet",
  "frequently asked questions",
  "quick reference",
  "quickref",
  "all documents",
  "all files",
  "find all",
  "quick find",
  "quickview",
  "search all",
  "quick reorder",
  "quickreply",
  "multiple choice",
  "online exam",
  "online quiz",
  "online test",
  "true false",
  "cellular signal",
  "data roaming",
  "letter r",
  "r",
  "roaming indicator",
  "am",
  "classic",
  "fm",
  "old fashioned",
  "portable radio",
  "transistor",
  "checked radio button",
  "form element",
  "radiobutton",
  "selection control",
  "ui control",
  "halfway",
  "inner circle",
  "outer circle",
  "false",
  "medical exam",
  "medical imaging",
  "medical test",
  "radiography",
  "radiologists",
  "disruption",
  "railway alert",
  "train alert",
  "train car",
  "exclamatory",
  "autumn",
  "bad weather",
  "cloud with rain",
  "downpour",
  "drizzle",
  "raindrops",
  "rainfall",
  "raining",
  "rainy",
  "showers",
  "cloudburst",
  "heavy",
  "intense",
  "rainstorm",
  "slanted lines",
  "torrent",
  "intermittent rain",
  "isolated showers",
  "light rain",
  "light shower",
  "scattered showers",
  "spitting",
  "blizzard",
  "flurries",
  "inclement weather",
  "mixed precipitation",
  "rain and snow",
  "rainy snow",
  "sleet",
  "snow rain",
  "snowing",
  "snowy rain",
  "winter weather",
  "wintry mix",
  "asian food",
  "chopsticks",
  "japanese cuisine",
  "japanese food",
  "noodle bowl",
  "ramen",
  "ramen noodles",
  "merge left",
  "ramp left",
  "arrow join",
  "arrow merge",
  "merge right",
  "on-ramp",
  "ramp right",
  "air filtration",
  "aroma control",
  "clean air",
  "exhaust",
  "extractor fan",
  "fume extractor",
  "grease",
  "kitchen ventilation",
  "overhead hood",
  "range hood",
  "restaurants",
  "suction",
  "avian",
  "blackbird",
  "claw",
  "corvid",
  "creature",
  "crow",
  "perch",
  "poetry",
  "raven",
  "cancel raw",
  "disable editing",
  "image format",
  "image processing",
  "no raw",
  "no unprocessed",
  "post processing",
  "raw",
  "raw disabled",
  "raw format",
  "raw off",
  "remove raw",
  "unedited",
  "unprocessed",
  "uncompressed",
  "read more",
  "view more",
  "hrv",
  "readiness",
  "tachometer",
  "agent",
  "broker",
  "mortgage",
  "realtor",
  "outward facing camera",
  "rebase",
  "proof of purchase",
  "tax",
  "torn paper",
  "zig zag edge",
  "budget management",
  "long receipt",
  "order history",
  "bill off",
  "disable bill",
  "disable invoice",
  "disable payment",
  "disable purchase",
  "disable receipt",
  "disable ticket",
  "hide bill",
  "hide invoice",
  "hide payment",
  "hide purchase",
  "hide receipt",
  "hide ticket",
  "invoice off",
  "no bill",
  "no invoice",
  "no purchase",
  "no receipt",
  "no ticket",
  "purchase off",
  "receipt off",
  "remove bill",
  "remove invoice",
  "remove payment",
  "remove purchase",
  "remove receipt",
  "remove ticket",
  "ticket off",
  "actors",
  "recent activity",
  "recent history",
  "recent items",
  "ehr",
  "electronic health record",
  "emr",
  "meeting point",
  "normalize",
  "recenter",
  "circled thumb up",
  "endorse",
  "endorsement",
  "recommend",
  "suggest",
  "thumb up",
  "thumb up in circle",
  "thumbs",
  "thumbs up",
  "well",
  "audio message",
  "audio note",
  "person speaking",
  "user speaking",
  "voice message",
  "voice note",
  "image area",
  "parallelograms",
  "polygons",
  "quadrilaterals",
  "recangle",
  "arrow loop",
  "ecological",
  "recyclable",
  "waste management",
  "gift card",
  "gift certificate",
  "giftcard",
  "decrease capacity",
  "downsize",
  "fewer people",
  "less people",
  "lower capacity",
  "reduce attendees",
  "reduce capacity",
  "shrink group",
  "smaller group",
  "restart page",
  "update page",
  "algorithms",
  "patterns",
  "regex",
  "regular expression",
  "strings",
  "chillout",
  "de-stress",
  "destress",
  "lax",
  "loosen up",
  "repose",
  "selfcare",
  "serenity",
  "stay loose",
  "stress relief",
  "tranquility",
  "unwind",
  "releases",
  "persistence",
  "remember me",
  "grabbing",
  "prompts",
  "TV",
  "universal remote",
  "substract",
  "action complete",
  "delete done",
  "remove done",
  "dequeue",
  "from",
  "remove from list",
  "remove from queue",
  "waiting list",
  "demote",
  "no protection",
  "remove admin",
  "remove moderator",
  "remove permission",
  "remove role",
  "revoke admin",
  "revoke moderator",
  "revoke permission",
  "revoke role",
  "unmoderator",
  "clear road",
  "delete road",
  "directions delete",
  "directions remove",
  "erase road",
  "highway delete",
  "highway remove",
  "map delete",
  "map remove",
  "navigation delete",
  "navigation remove",
  "path delete",
  "path remove",
  "remove road",
  "road deletion",
  "road removal",
  "route delete",
  "route remove",
  "street delete",
  "street remove",
  "cancel selection",
  "selection border",
  "selection box",
  "selection tool",
  "cancel order",
  "cancel purchase",
  "clear cart",
  "delete from cart",
  "empty cart",
  "remove from cart",
  "change order",
  "item order",
  "list reorder",
  "reallocate",
  "redistribute",
  "repartition",
  "reshuffle",
  "reiterate",
  "repeat all",
  "repeat on",
  "loop one",
  "number 1",
  "repeat one",
  "repeat song",
  "repeat track",
  "replay one",
  "single item",
  "single song",
  "single track",
  "loop single",
  "numeral 1",
  "numeral one",
  "once",
  "repeat single",
  "replay single",
  "restart one",
  "restart single",
  "alternate audio",
  "change audio",
  "exchange audio",
  "refresh audio",
  "replace audio",
  "restart audio",
  "sound clip",
  "substitute audio",
  "swap audio",
  "switch audio",
  "update audio",
  "change orientation",
  "photo rotation",
  "picture rotation",
  "change video",
  "replace video",
  "substitute",
  "substitute video",
  "update video",
  "replay track",
  "start over",
  "try again",
  "u-turn",
  "10 seconds back",
  "back 10 seconds",
  "previous 10 seconds",
  "replay 10 seconds",
  "rewind 10 seconds",
  "replay 30",
  "rewind 30",
  "thirty seconds",
  "5s",
  "back 5 seconds",
  "five seconds back",
  "last 5 seconds",
  "previous 5 seconds",
  "replay 5 seconds",
  "rewind 5 seconds",
  "react",
  "reply all",
  "answer all",
  "distribution list",
  "group message",
  "reply to all",
  "respond all",
  "send all",
  "important message",
  "alert disabled",
  "alert off",
  "cancel report",
  "cancel reporting",
  "disable report",
  "disable reporting",
  "no report",
  "no reporting",
  "no warnings",
  "report off",
  "reporting disabled",
  "reports disabled",
  "reports off",
  "stop reporting",
  "stop reports",
  "turn off reporting",
  "turn off reports",
  "warning disabled",
  "warning off",
  "currency symbol",
  "request page",
  "statement",
  "ask price",
  "estimate",
  "get quote",
  "request pricing",
  "request quote",
  "defaults",
  "refocus",
  "reset camera",
  "reset view",
  "reset zoom",
  "reset image",
  "reset picture",
  "restore default",
  "restore image",
  "revert image",
  "anticlockwise",
  "factory reset",
  "reset settings",
  "revert to default",
  "system restore",
  "factory settings",
  "initial settings",
  "default settings",
  "reset exposure",
  "shutter aperture",
  "display reset",
  "monitor reset",
  "reset tv",
  "screen reset",
  "tv reset",
  "wb",
  "white balance",
  "boundary box",
  "dashes",
  "sizing",
  "pulmonary",
  "respiratory health",
  "respiratory_rate",
  "responsive layout",
  "restart process",
  "eat icon",
  "find food",
  "food service icon",
  "knife and fork",
  "where to eat",
  "get back",
  "put back",
  "recycle bin",
  "reinstate",
  "remove from trash",
  "salvage",
  "undelete",
  "restore page",
  "revert changes",
  "google suite",
  "gsuite",
  "reviews",
  "chalice",
  "earn",
  "incentive",
  "mission",
  "rewarded",
  "ache",
  "osteoarthritis",
  "rheumatic",
  "rheumatism",
  "rheumatoid",
  "rheumatologists",
  "rheumatology",
  "cage",
  "rib",
  "rib_cage",
  "ribs",
  "sternum",
  "thoracic",
  "appetite",
  "serve",
  "staple",
  "open menu",
  "right-click menu",
  "secondary click",
  "minimize panel",
  "hide right panel",
  "show right panel",
  "slide in",
  "slide out",
  "toggle right panel",
  "disturbance",
  "expanding",
  "radial effect",
  "spreading",
  "avenue",
  "boulevard",
  "dashed lines",
  "dotted lines",
  "pavement",
  "road markings",
  "roadway",
  "automation bot",
  "cyborg",
  "droid",
  "science fiction",
  "scifi",
  "square jaw",
  "robot head",
  "astronaut",
  "blastoff",
  "propulsion",
  "rocket",
  "spaceship",
  "pull down",
  "roller blind",
  "roller shade",
  "block light",
  "closed shade",
  "lower shade",
  "window blind",
  "quad skate",
  "quad skates",
  "roller skate",
  "roller skating",
  "rollerskates",
  "building maintenance",
  "roofing",
  "room access",
  "room control",
  "room management",
  "room setup",
  "cloche",
  "in-room dining",
  "room service",
  "90",
  "ccw",
  "ninety degrees",
  "rotate image",
  "rotate left",
  "rotate object",
  "rotate photo",
  "cw",
  "auto a",
  "auto-rotate",
  "device rotation",
  "rotate a",
  "object rotation",
  "left turn",
  "roundabout",
  "roundabout left",
  "turn around",
  "u turn",
  "circular intersection",
  "rotary",
  "roundabout right",
  "traffic circle",
  "bevel",
  "border radius",
  "fillet",
  "rounded edge",
  "soft corner",
  "wan",
  "disable router",
  "router off",
  "consistency",
  "habit",
  "ui theme",
  "oar",
  "rowing",
  "rss feed",
  "syndicate",
  "syndication",
  "web feed",
  "xml",
  "guest list",
  "not going",
  "plaît",
  "respond please",
  "rsvp",
  "répondez",
  "répondez s'il vous plaît",
  "sil",
  "vous",
  "hurry",
  "initial t",
  "latency",
  "real time",
  "round trip time",
  "rrt",
  "rtt",
  "rubric",
  "standards",
  "policies",
  "regulations",
  "validation check",
  "automated rules",
  "manage rules",
  "rule management",
  "rule_settings",
  "workflow settings",
  "jog",
  "errors",
  "interrupted",
  "camper",
  "caravan",
  "hookup",
  "mobile home",
  "pull in",
  "recreational vehicle",
  "rv",
  "trailer",
  "clock shield",
  "protection check",
  "safe time",
  "safety check",
  "safety timer",
  "schedule security",
  "secure schedule",
  "secure time",
  "security check",
  "security timer",
  "time protection",
  "time security",
  "time shield",
  "disable safety",
  "no safety",
  "safety check off",
  "security check off",
  "turn off safety",
  "turn off security",
  "community health",
  "physical distancing",
  "precaution",
  "prevent spread",
  "public health",
  "safety measure",
  "sailboat",
  "social sports",
  "yacht",
  "mineral",
  "purity",
  "saline",
  "salinity",
  "salt",
  "antibacterial",
  "antimicrobial",
  "antiseptic",
  "hand sanitizer",
  "handwash",
  "liquid soap",
  "earth observation",
  "remote sensing",
  "satellite_alt",
  "space station",
  "space technology",
  "diskette",
  "floppy disk",
  "retain",
  "save as",
  "autosave",
  "save time",
  "timestamp",
  "bookmarked",
  "bookmarked search",
  "favorite search",
  "important search",
  "remember search",
  "saved query",
  "saved search",
  "search history",
  "starred search",
  "accumulation",
  "interest",
  "pig",
  "piggy",
  "piggy bank",
  "weighing",
  "file scan",
  "scan file",
  "scan image",
  "scan paper",
  "text recognition",
  "cancel scan",
  "clear scan",
  "close scan",
  "delete document",
  "delete file",
  "delete page",
  "delete scan",
  "document delete",
  "document removal",
  "file delete",
  "file removal",
  "page delete",
  "remove scan",
  "scan removal",
  "circle group",
  "data points",
  "scatter plot",
  "reading light",
  "access time",
  "o'clock",
  "delayed message",
  "event reminder",
  "paper airplane",
  "post later",
  "schedule message",
  "schedule post",
  "send later",
  "timed message",
  "timed post",
  "graduate",
  "graduation",
  "mortarboard",
  "beaker disabled",
  "beaker off",
  "blocked science",
  "cancel science",
  "chemistry off",
  "deactivate science",
  "disable science",
  "experiment off",
  "flask disabled",
  "flask off",
  "forbidden science",
  "lab off",
  "laboratory off",
  "no beaker",
  "no chemistry",
  "no experiment",
  "no flask",
  "no research",
  "no science",
  "research off",
  "science disabled",
  "science inactive",
  "science_off",
  "micro scooter",
  "push scooter",
  "short distance",
  "2k image",
  "2k video",
  "two k",
  "colon",
  "flipboard",
  "lose",
  "scoreboard",
  "mobile lock",
  "screen orientation",
  "device security",
  "lock portrait",
  "lock symbol",
  "mobile device security",
  "padlock symbol",
  "phone portrait",
  "privacy settings",
  "screen security",
  "screenlock",
  "smartphone security",
  "autorotation",
  "disable rotation",
  "fixed orientation",
  "immobile",
  "locked rotation",
  "orientation lock",
  "prevent rotation",
  "rotation lock",
  "abstract circle",
  "capture screen",
  "livestream",
  "rec",
  "screen record",
  "screen recording",
  "screencapture",
  "start rec",
  "stop rec",
  "mobile setting",
  "screen orientation lock",
  "screen rotation lock",
  "display rotation",
  "rotate screen",
  "rotation control",
  "screen_rotation_alt",
  "change display",
  "computer search",
  "desktop search",
  "explore screen",
  "find in desktop",
  "find in screen",
  "inspect screen",
  "magnifying glass on screen",
  "screen search",
  "search computer",
  "search desktop",
  "search screen",
  "screen_share",
  "snipping tool",
  "print screen",
  "screenshot frame 2",
  "clipping",
  "desktop capture",
  "prtscn",
  "record screen",
  "screen grab",
  "screenshot keyboard",
  "computer screen",
  "display capture",
  "partial screenshot",
  "screenshot region",
  "select region",
  "device screenshot",
  "mobile screenshot",
  "screen image",
  "tablet screenshot",
  "ui capture",
  "hand-drawn",
  "scrollable",
  "scrollbar",
  "diver",
  "scuba",
  "scuba diving",
  "underwater",
  "flash memory",
  "portable storage",
  "sd card",
  "secure digital",
  "digital storage",
  "micro sd",
  "removable storage",
  "sd storage",
  "corner cut",
  "error sign",
  "memory alert",
  "memory error",
  "memory problem",
  "memory warning",
  "notification sign",
  "sd card alert",
  "sd card error",
  "sd card issue",
  "sd card notification",
  "sd card problem",
  "sd card warning",
  "sim card alert",
  "sim card error",
  "sim card issue",
  "sim card notification",
  "sim card problem",
  "sim card warning",
  "storage alert",
  "storage error",
  "storage problem",
  "storage warning",
  "warning sign",
  "websites",
  "broad",
  "comprehensive",
  "entire",
  "everywhere",
  "overall",
  "search_activity",
  "magnifying glass with check",
  "search complete",
  "search successful",
  "search with check",
  "magnifyingglass",
  "search_check",
  "hands-free",
  "in-car",
  "steering",
  "steering wheel",
  "voice activated",
  "bar chart search",
  "chart analysis",
  "data analysis tools",
  "data discovery",
  "dataform",
  "magnifying glass graph",
  "market research",
  "search analytics",
  "search_insights",
  "cancel search",
  "clear search",
  "deactivate search",
  "disable search",
  "hide search",
  "magnifier disabled",
  "magnifier off",
  "magnifying glass disabled",
  "magnifying glass off",
  "no search",
  "remove search",
  "search deactivated",
  "search_off",
  "climate control seat",
  "cooled seat",
  "heated seat",
  "seat warmer",
  "car seat",
  "passenger seat",
  "fan blades",
  "seat ventilation",
  "antivirus",
  "armor",
  "threat protection",
  "2-step",
  "2fa",
  "digital security",
  "fob",
  "hardware key",
  "ldap",
  "reauth",
  "security key",
  "thumb drive",
  "two-factor authentication",
  "u2f",
  "webauthn",
  "yubi",
  "yubi key",
  "mobile friendly",
  "mobile update",
  "passed",
  "mobile alert",
  "security warning",
  "choosing",
  "marking",
  "multiple selection",
  "selector",
  "ticking",
  "check box",
  "select box",
  "select to speak",
  "activate window",
  "arrange windows",
  "change window",
  "choose window",
  "dual windows",
  "focus window",
  "highlight window",
  "manage windows",
  "multiple windows",
  "organize windows",
  "overlapping windows",
  "pick window",
  "program window",
  "select window",
  "software window",
  "stacked squares",
  "stacked windows",
  "switch window",
  "webpages",
  "active window",
  "alt+tab",
  "application windows",
  "cascading windows",
  "command+tab",
  "select application",
  "task switching",
  "ui window",
  "window navigation",
  "window selection",
  "no selection",
  "no windows",
  "barbershop",
  "chi",
  "hairstyle",
  "pampering",
  "reflection",
  "salon",
  "self_care",
  "legs crossed",
  "lotus position",
  "meditate",
  "self care",
  "self improvement",
  "zen",
  "bargain",
  "price tag",
  "message icon",
  "send icon",
  "share icon",
  "inbox zero",
  "send and archive",
  "digital payment",
  "double arc",
  "electronic transfer",
  "funds transfer",
  "remit",
  "remittance",
  "send money",
  "extend deadline",
  "fitting",
  "reschedule",
  "send document",
  "send file",
  "open in",
  "open on",
  "porting",
  "push notification",
  "security system",
  "area occupied",
  "body response",
  "detected",
  "occupancy sensor",
  "person detected",
  "presence sensor",
  "room occupied",
  "sensors",
  "smart body scan sensor",
  "space occupied",
  "user present",
  "closed window",
  "double pane",
  "smart window",
  "window sensor",
  "receiving",
  "krx",
  "no connections",
  "no signals",
  "sensor off",
  "sensors off",
  "activate sensors",
  "deactivate sensors",
  "disable sensors",
  "enable sensors",
  "no sensors",
  "parenthesis",
  "toggle sensors",
  "at peace",
  "closed eyes",
  "dreamy",
  "peaceful",
  "relaxed",
  "serene",
  "smile face",
  "tranquil",
  "apathy",
  "facial expression",
  "indifferent",
  "passive",
  "satisfy",
  "uninterested",
  "angry",
  "disappointed",
  "dissatisfied",
  "frowning face",
  "poor",
  "sad face",
  "sentiment analysis",
  "unsatisfied",
  "user feedback",
  "amused",
  "delighted",
  "ecstatic",
  "entertained",
  "excite",
  "excited",
  "glee",
  "good vibes",
  "grin",
  "grinning",
  "laughing",
  "overjoyed",
  "passionate",
  "pleasure",
  "thrilled",
  "awful",
  "extremely",
  "extremely dissatisfied",
  "eyebrows",
  "frustration",
  "furious",
  "hate",
  "mad",
  "rage",
  "terrible",
  "very angry",
  "worst",
  "anxious",
  "concerned",
  "frustrated",
  "stressed",
  "troubled",
  "worried",
  "indifference",
  "meh",
  "no expression",
  "poker face",
  "straight face",
  "cry",
  "sentiment_sad",
  "sorrow",
  "satisfaction",
  "sentiment satisfied",
  "sentiment_satisfied",
  "sentiment_satisfied_alt",
  "anxiety",
  "burden",
  "concern",
  "distressed",
  "emotional state",
  "overwhelmed",
  "stress",
  "tense",
  "tension",
  "worry",
  "very",
  "very dissatisfied",
  "amazing",
  "excellent",
  "five stars",
  "great",
  "perfect",
  "smiling face",
  "top rating",
  "very satisfied",
  "wonderful",
  "apprehensive",
  "fear",
  "grimace",
  "nervous",
  "uneasy",
  "traditional",
  "network administration",
  "server administration",
  "server management",
  "server settings",
  "sole tenancy",
  "sole tenant",
  "user administration",
  "instruments",
  "combo meal",
  "fish dish",
  "meal deal",
  "menu icon",
  "seafood",
  "set meal",
  "teishoku",
  "accessibility settings",
  "cognitive impairment",
  "hearing impairment",
  "motor impairment",
  "visual impairment",
  "person settings",
  "settings alert",
  "settings warning",
  "modifications",
  "program settings",
  "settings b roll",
  "settings export",
  "settings migration",
  "settings transfer",
  "settings bluetooth",
  "brightness settings",
  "setting_brightness",
  "mobile options",
  "phone menu",
  "blur settings",
  "cinematic mode",
  "dof",
  "film mode",
  "video mode",
  "cables",
  "composite",
  "inputs",
  "three sliders",
  "audio video",
  "audiovisual",
  "four pin",
  "s-video",
  "svideo",
  "video input",
  "activity tracking",
  "motion settings",
  "movement detection",
  "overscan",
  "three sixty",
  "vrpano",
  "call settings",
  "communication settings",
  "contact settings",
  "handset settings",
  "phone options",
  "telephone settings",
  "camera options",
  "photo options",
  "power options",
  "settings menu",
  "decrease speed",
  "reduce speed",
  "settings cog",
  "settings gear",
  "snail",
  "turtle",
  "imagination",
  "fast forward settings",
  "settings timelapse",
  "time-lapse settings",
  "timelapse",
  "camera configuration",
  "camera controls",
  "camera preferences",
  "video configuration",
  "video preferences",
  "video recording settings",
  "webcam settings",
  "microphone settings",
  "voice settings",
  "cable box",
  "digital receiver",
  "settop",
  "tv box",
  "extreme cold",
  "ice storm",
  "severe",
  "severe weather",
  "weather alert",
  "winter storm",
  "behind",
  "add layer",
  "clip art",
  "branched lines",
  "contect",
  "three dots connected",
  "delivery time",
  "send eta",
  "send time",
  "share arrival time",
  "share eta",
  "share time",
  "send location",
  "share coordinates",
  "share place",
  "share position",
  "block share",
  "cancel share",
  "cross share",
  "disable share",
  "disconnect share",
  "distribute off",
  "forbidden share",
  "link off",
  "remove share",
  "restrict share",
  "share disabled",
  "sharing disabled",
  "sharing prohibited",
  "slashed share",
  "social media off",
  "social share off",
  "x share",
  "customer review",
  "post review",
  "referral",
  "review sharing",
  "share feedback",
  "share reviews",
  "submit review",
  "user review",
  "word of mouth",
  "auto-hide",
  "autohide",
  "bookcase",
  "infographic grid",
  "shelf position",
  "containers",
  "stacked boxes",
  "two shelves",
  "malware protection",
  "lock security",
  "security lock",
  "shield lock",
  "moon icon",
  "night shield",
  "protection mode",
  "person in shield",
  "shield person",
  "shield user",
  "user protection",
  "user safety",
  "user shield",
  "secure help",
  "security information",
  "security question",
  "shield question",
  "active protection",
  "around the clock",
  "constant protection",
  "personal safety",
  "real-time protection",
  "smartwatch security",
  "time management security",
  "watch icon",
  "watch protection",
  "wearable security",
  "heart in shield",
  "shield with heart",
  "house inside shield",
  "safe house",
  "shield with house",
  "composing",
  "shift key",
  "small letters",
  "digital shop",
  "online store",
  "web store",
  "product video",
  "shop 2",
  "shop two",
  "add to bag",
  "consumer",
  "shopping_bag",
  "next day",
  "quick buy",
  "same day",
  "retail store",
  "shopping_basket",
  "local grocery",
  "push cart",
  "shopping list",
  "complete order",
  "confirm order",
  "finalize order",
  "go to checkout",
  "proceed to checkout",
  "cart disabled",
  "cart off",
  "cart unavailable",
  "disable cart",
  "no cart",
  "no orders",
  "no purchases",
  "no shopping",
  "shopping cart off",
  "shopping cart unavailable",
  "shopping disabled",
  "shopping off",
  "shopping mode",
  "shoppingmode",
  "brief",
  "few days",
  "short term",
  "staycation",
  "short_text",
  "fluctuation",
  "show chart",
  "bathroom fixture",
  "rinse",
  "showerhead",
  "crisscross",
  "disarray",
  "disorganized",
  "intersecting arrows",
  "jumble",
  "randomize",
  "scramble",
  "chaos",
  "crisscross arrows",
  "crossed arrows",
  "randomized",
  "shuffle mode",
  "shuffle on",
  "shuffle play",
  "diaphragm",
  "quick settings",
  "shutter speed",
  "slower",
  "fever",
  "ill",
  "unhealthy",
  "unwell",
  "content navigation",
  "off-canvas",
  "page navigation",
  "section navigation",
  "side menu",
  "side navigation",
  "view navigation",
  "american sign language",
  "asl",
  "communication access",
  "deaf culture",
  "hand talk",
  "interpretation",
  "nonverbal communication",
  "sign language",
  "sign symbol",
  "signing",
  "speech impaired",
  "talking hands",
  "lost signal",
  "no bars",
  "zero bars",
  "cell signal",
  "increasing",
  "cell service",
  "carrier",
  "provider",
  "strengthen",
  "full bars",
  "increasing bars",
  "signal indicator",
  "gsm",
  "empty bars",
  "4 bar",
  "cellularnodata",
  "nodata",
  "antenna off",
  "no antenna",
  "no wireless",
  "held",
  "suspended",
  "connection lost",
  "internet disconnected",
  "network offline",
  "no broadcast",
  "wifi disconnected",
  "wireless disconnected",
  "excellent connection",
  "strong connection",
  "bad signal",
  "statusbar",
  "wifi error",
  "wifi problem",
  "empty signal",
  "autograph",
  "cancel signature",
  "clear signature",
  "cursive",
  "delete signature",
  "john hancock",
  "remove signature",
  "signatory",
  "signpost",
  "cut corner",
  "identity module",
  "simcard",
  "subscriber",
  "sim card alt",
  "sim card download",
  "virtual world",
  "double bed (as a potential search term from users unsure of bed sizes)",
  "one person",
  "single bed",
  "real-time communication",
  "rtc",
  "ambulance siren",
  "emergency vehicle",
  "police siren",
  "warning signal",
  "siren_check",
  "alarm status",
  "emergency question",
  "find out",
  "extreme",
  "grind",
  "ollie",
  "skateboard",
  "skateboarder",
  "skateboarding",
  "skateboarding icon",
  "skater",
  "sports icon",
  "halloween",
  "halloween costume",
  "human skeleton",
  "monster",
  "rib cage",
  "spinal column",
  "spooky",
  "cooking pan",
  "fry",
  "fry pan",
  "frying",
  "saucepan",
  "skillet",
  "steaming",
  "frying pan",
  "saute",
  "jump ahead",
  "next button",
  "skip button",
  "skip next",
  "skip track",
  "previous song",
  "previous video",
  "skip_previous",
  "cranium",
  "evil",
  "gothic",
  "graveyard",
  "grim reaper",
  "piracy",
  "poison",
  "scary",
  "skull",
  "toxic",
  "blacklist",
  "dark web",
  "mortality",
  "subject",
  "character style",
  "slab serif",
  "luge",
  "sled",
  "sledding",
  "sledge",
  "toboggan",
  "sleep analysis",
  "sleep data",
  "sleep health",
  "sleep quality",
  "sleep score",
  "sleep time",
  "sleep tracking",
  "stat",
  "tracking progress",
  "creating",
  "designing",
  "presentations",
  "image viewer",
  "photo viewer",
  "gaps",
  "play triangle",
  "card reader",
  "chip card",
  "pc/sc",
  "rfid",
  "smart card",
  "smart card reader",
  "swipe card",
  "tap card",
  "no card reader",
  "no smart card",
  "power socket",
  "receptacle",
  "smart outlet",
  "wall outlet",
  "smart menu",
  "smart screen",
  "smart settings",
  "smart toy",
  "front-facing camera",
  "stay current",
  "mobile camera app",
  "mobile photography",
  "smartphone camera app",
  "smartphone photography",
  "cloud share",
  "cloud sharing",
  "network share",
  "network sharing",
  "server message block",
  "smb",
  "windows share",
  "anti smoking",
  "cigarette",
  "cigarette ban",
  "dont smoke",
  "never",
  "nicotine free",
  "no cigarettes",
  "no smoke",
  "no smoking",
  "no tobacco",
  "non smoking",
  "smoke free",
  "smoking",
  "smoking prohibited",
  "stop smoking",
  "tobacco",
  "tobacco free",
  "addiction",
  "ashtray",
  "cigar",
  "cigarette break",
  "designated smoking area",
  "nicotine",
  "permitted smoking",
  "smoking allowed",
  "smoking area",
  "smoking lounge",
  "smoking room",
  "vape",
  "vaping",
  "text message",
  "folder within folder",
  "inner folder",
  "nested folder",
  "subfolder",
  "remind",
  "flakes",
  "season",
  "flurry",
  "heavy snow",
  "powder",
  "slush",
  "snow shower",
  "snowfall",
  "snowstorm",
  "whiteout",
  "motorized sled",
  "skimobile",
  "snow machine",
  "snow travel",
  "snowmobile",
  "cold weather",
  "snow gear",
  "snow trail",
  "snowshoe",
  "winter gear",
  "winter sport",
  "winter trail",
  "hand care",
  "hand hygiene",
  "lather",
  "2 meters",
  "keep apart",
  "keep distance",
  "two users",
  "medallion",
  "medals",
  "photovoltaic",
  "solar energy",
  "solar panel",
  "solar power",
  "alphabetical",
  "numerical",
  "a-z",
  "alphabetically",
  "alphabetize",
  "az",
  "by alpha",
  "sequencing",
  "bold text",
  "distress",
  "morse code",
  "save our souls",
  "animal noise",
  "bark",
  "barking",
  "canine",
  "dog sound",
  "hound",
  "noise detection",
  "pet sound",
  "sound recognition",
  "woof",
  "shatter",
  "high volume",
  "sound detection",
  "sampler",
  "sound player",
  "helping",
  "ladle",
  "soup",
  "soup kitchen",
  "volunteering",
  "bottom arrow",
  "south arrow",
  "central america",
  "south america",
  "south american continent",
  "southern hemisphere",
  "arrow down right",
  "arrow point down right",
  "south east",
  "south east arrow",
  "southeast arrow",
  "bottom-left",
  "lower left",
  "southwest",
  "aromatherapy",
  "lotus",
  "massage",
  "stylized flower",
  "space bar",
  "whitespace",
  "multi-tasking",
  "space management",
  "360 audio",
  "360 sound",
  "3d audio",
  "3d sound",
  "dolby atmos",
  "dts:x",
  "headphone settings",
  "immersive audio",
  "immersive sound",
  "person audio",
  "sound propagation",
  "spatial audio",
  "spatial sound",
  "speaker settings",
  "surround sound",
  "user audio",
  "3d audio off",
  "immersive audio off",
  "spatial sound off",
  "surround sound off",
  "apple spatial audio",
  "audio signal",
  "multichannel",
  "sound output",
  "speaker output",
  "find user",
  "locate user",
  "person position",
  "person tracking",
  "spatial_tracking",
  "track user",
  "user position",
  "audio icon",
  "music icon",
  "sound icon",
  "speaker icon",
  "volume icon",
  "audio system",
  "multiple speakers",
  "pa system",
  "speaker group",
  "speakers",
  "speaker notes",
  "blog off",
  "chat off",
  "comment off",
  "dialogue off",
  "messages off",
  "no speech",
  "notes off",
  "speakers off",
  "speech off",
  "closed loop",
  "greek alphabet",
  "ohms",
  "omega",
  "open loop",
  "resistance",
  "u-shaped",
  "ultimate",
  "hydrometer",
  "mass",
  "relative density",
  "specific gravity",
  "substance",
  "audio to text",
  "voice recognition",
  "speedometer needle",
  "0.25",
  "0.25x",
  "audio speed",
  "quarter speed",
  "speed control",
  "tortoise",
  "0.2x",
  "half speed",
  "multiplier",
  "point two",
  ".5",
  "0.5",
  "playback rate",
  "point five",
  "speed adjustment",
  ".5x",
  "0.5x",
  "slow playback",
  "0.75",
  "point seventy-five",
  "0.7x",
  "70%",
  "1.2",
  "one and two tenths",
  "one point two",
  "speed indicator",
  "speed setting",
  "1.25",
  "1.25x",
  "125%",
  "audio playback speed",
  "one and a quarter speed",
  "one point two five",
  "time control",
  "video playback speed",
  "1.2x",
  "1.5",
  "1.5x",
  "decelerate",
  "one and a half",
  "one point five",
  "150%",
  "one and one half",
  "one hundred fifty percent",
  "1.75",
  "175",
  "one point seventy-five",
  "1.7",
  "1.7x",
  "170%",
  "one point seven",
  "rate control",
  "2x",
  "double speed",
  "quick motion",
  "twice",
  "two times",
  "l-shape",
  "speed limit",
  "speed_camera",
  "speed_control",
  "speed_limit",
  "speeding",
  "grammar",
  "spell",
  "spell checker",
  "spellcheck",
  "spelling",
  "content split",
  "dual pane",
  "vertical split",
  "divide layout",
  "divide scene",
  "divide screen",
  "divide view",
  "split layout",
  "split scene",
  "divide right",
  "multi-panel",
  "partition right",
  "right split",
  "screen split",
  "separate right",
  "double window",
  "dual view",
  "splitview",
  "view split",
  "add pane",
  "add panel",
  "multiple panes",
  "new pane",
  "new panel",
  "bottom split",
  "double panel",
  "layered panels",
  "split bottom",
  "stacked panels",
  "stacked view",
  "screen divide",
  "two panes",
  "parallel view",
  "dual window",
  "multi panel",
  "horizontal divide",
  "lower panel",
  "split top",
  "split window",
  "top split",
  "upper panel",
  "window pane",
  "window split",
  "add split",
  "new split",
  "blood oxygenation",
  "o2",
  "oximeter",
  "oxygen saturation",
  "radius",
  "rim",
  "spoke",
  "tire",
  "referee",
  "whistle",
  "and outdoors",
  "football",
  "kick",
  "league",
  "soccer",
  "ale",
  "bubbly",
  "foam",
  "froth",
  "game day",
  "lager",
  "pint",
  "sports bar",
  "stein",
  "stout",
  "tankard",
  "tavern",
  "watch party",
  "baseball",
  "baseball icon",
  "leather",
  "major league",
  "mlb",
  "pastime",
  "seam",
  "sports equipment",
  "stitches",
  "basketball",
  "bball",
  "hoops",
  "nba",
  "australia",
  "bat",
  "championship",
  "cricket",
  "hit",
  "innings",
  "pakistan",
  "stumps",
  "wicket",
  "esports",
  "play games",
  "sports esports",
  "stadia",
  "video gaming",
  "xbox",
  "american football",
  "field goal",
  "gridiron",
  "laces",
  "nfl",
  "pigskin",
  "quarterback",
  "running back",
  "stadium",
  "super bowl",
  "fairway",
  "putter",
  "sports golf",
  "flexibility",
  "gymnastics",
  "leg split",
  "martial arts",
  "side kick",
  "splits",
  "catch",
  "catching",
  "handball",
  "jumping",
  "throwing",
  "crossed sticks",
  "hockey sticks",
  "ice hockey",
  "nhl",
  "puck",
  "anti",
  "athletes",
  "combat",
  "contact sport",
  "fighting",
  "indian sport",
  "kabaddi",
  "offence",
  "players",
  "raid",
  "raider",
  "sport icon",
  "struggle",
  "tackle",
  "tackling",
  "team sport",
  "wrestle",
  "wrestling",
  "arts",
  "fighter",
  "judo",
  "karate",
  "kickboxing",
  "kung fu",
  "martial",
  "self defense",
  "taekwondo",
  "boxing",
  "boxing glove",
  "fight",
  "fist",
  "glove",
  "mixed martial arts",
  "mma",
  "sparring",
  "ufc",
  "ultimate fighting championship",
  "f1",
  "formula one",
  "indycar",
  "motogp",
  "motorsports",
  "nascar",
  "racing helmet",
  "superbike",
  "rugby",
  "rugby ball",
  "rugby football",
  "auto racing",
  "car racing",
  "checkered flag",
  "finish line",
  "penalty",
  "pitch",
  "world cup",
  "Australian Open",
  "French Open",
  "US Open",
  "Wimbledon",
  "grand slam",
  "racket",
  "racquet",
  "sport equipment",
  "tennis",
  "tennis ball",
  "sports_volleyball",
  "volley",
  "volleyball",
  "irrigation",
  "t-shaped",
  "water feature",
  "geometric shape",
  "quadrangle",
  "sides",
  "centered dot",
  "circle in square",
  "dot in square",
  "full stop",
  "lacto",
  "lacto-vegetarian",
  "square dot",
  "hypotenuse",
  "inches",
  "set square",
  "square foot",
  "square footage",
  "ssid",
  "pile",
  "no stacking",
  "badges",
  "stack_star",
  "chart-chart",
  "stacked bar chart",
  "filing",
  "trays",
  "stacked chart",
  "stacked line chart",
  "moma search",
  "stack of diamonds",
  "stack of squares",
  "stacks",
  "teamgraph",
  "controller icon",
  "gamepad icon",
  "gamer",
  "gaming controller",
  "joystick icon",
  "stadia controller",
  "start game",
  "video game controller",
  "amphitheater",
  "arena",
  "coliseum",
  "pennants",
  "multilevel",
  "stairway",
  "stairwell",
  "next level",
  "three steps",
  "empty star",
  "favorite news",
  "five-pointed star",
  "toggle favorite",
  "unfilled star",
  "2.5 stars",
  "adequate",
  "decent",
  "fifty percent",
  "half star",
  "rating rank",
  "satisfactory",
  "so-so",
  "two and a half stars",
  "5 star",
  "customer rating",
  "feedback rating",
  "partially filled",
  "star outline",
  "user rating",
  "brilliant",
  "excellence",
  "gleam",
  "shiny",
  "sparkle lines",
  "achievements",
  "double star",
  "two stars",
  "45 degree rotation",
  "stat 0",
  "stat_0",
  "1 arrow",
  "doward",
  "three chevrons",
  "three down arrows",
  "rectangle with rounded corners",
  "heat control",
  "heated steering wheel",
  "heater",
  "steering wheel warmer",
  "phase",
  "code stepping",
  "debugger",
  "step into",
  "step out",
  "step over",
  "step through",
  "linear progress",
  "stepper",
  "wizard",
  "pedometer",
  "sneakers",
  "auscultation",
  "physical",
  "practitioner",
  "stethoscope",
  "poa",
  "stethoscope arrow",
  "health check",
  "stethoscope check",
  "notepaper",
  "asset management",
  "content library",
  "media browser",
  "media manager",
  "stock audio",
  "stock images",
  "stock media",
  "stock music",
  "stock photos",
  "covered",
  "hot food",
  "stew",
  "discontinue",
  "filled square",
  "stop sign",
  "brick and mortar",
  "storefront icon",
  "twister",
  "direct",
  "straight up",
  "equalize",
  "neat",
  "straighten",
  "symmetrical",
  "app streaming",
  "chat app",
  "message app",
  "mobile chat",
  "mobile streaming",
  "online chat",
  "phone app",
  "streaming app",
  "street view",
  "streetview",
  "virtual tour",
  "emotional",
  "psychological",
  "stress management",
  "strikeout",
  "hatch",
  "shading",
  "block stroke",
  "cancel stroke",
  "delete stroke",
  "disable stroke",
  "end stroke",
  "hide stroke",
  "partial stroke",
  "remove stroke",
  "stop stroke",
  "fatherhood",
  "boutique",
  "fashion design",
  "hairdresser",
  "styler",
  "digital pen",
  "tablet pen",
  "calligraphy",
  "digital ink",
  "digital painting",
  "fountain pen",
  "nib",
  "chisel tip",
  "electronic pen",
  "slanted tip",
  "touchscreen pen",
  "electronic signature",
  "laser pointer",
  "annotation tool",
  "creative tool",
  "note-taking",
  "sketching tool",
  "enter directory",
  "enter folder",
  "exit directory",
  "exit folder",
  "parent directory",
  "parent folder",
  "previous directory",
  "previous folder",
  "sub",
  "subdirectory",
  "up one level",
  "angle arrow",
  "file system",
  "inline arrow",
  "subheader",
  "exponent",
  "scientific notation",
  "squared",
  "subscript",
  "x2",
  "films",
  "playlists",
  "shows",
  "subscribed",
  "subscriptions",
  "live caption",
  "caption settings",
  "captions configuration",
  "subtitle settings",
  "subtitles configuration",
  "text settings",
  "captions off",
  "closed captions off",
  "no text",
  "subtitles off",
  "text off",
  "underground station",
  "abridge",
  "recap",
  "summarize",
  "eight lines",
  "changing weather",
  "daytime snow",
  "sun and snow",
  "unusual weather",
  "winter sun",
  "power of two",
  "raise to the power",
  "second power",
  "superscript",
  "x squared",
  "x to the power of two",
  "restrictions",
  "supervised user",
  "block supervision",
  "cancel supervision",
  "child lock off",
  "circle cross",
  "disable supervision",
  "monitoring off",
  "no supervision",
  "parental control off",
  "remove supervision",
  "restricted user",
  "stop supervision",
  "supervised user circle off",
  "supervised user disabled",
  "supervised user inactive",
  "supervision disabled",
  "supervision off",
  "unsupervised",
  "unsupervised user",
  "user disable",
  "user restricted",
  "user supervision off",
  "user unsupervised",
  "assistance icon",
  "buoy",
  "emergency icon",
  "life preserver",
  "life ring",
  "life ring icon",
  "lifebuoy",
  "lifesaver",
  "solutions",
  "support icon",
  "technical support",
  "call center",
  "customer support agent",
  "online support",
  "representative",
  "service desk",
  "coastline",
  "surfboard",
  "surfer",
  "surfing icon",
  "water activity",
  "watersport",
  "wave riding",
  "incision",
  "scalpel",
  "surgeon",
  "surgical",
  "atmos",
  "dolby",
  "surround system",
  "volumn",
  "call change",
  "call flip",
  "call swap",
  "call switch",
  "change call",
  "flip call",
  "redirect call",
  "swap calls",
  "switch calls",
  "transfer call",
  "car navigation",
  "change apps",
  "change navigation",
  "driving directions",
  "swap routes",
  "switch apps",
  "toggle apps",
  "swap horizontal",
  "import export",
  "swap vertical",
  "vertical arrows",
  "one finger",
  "drag down",
  "pull to refresh",
  "swpie",
  "circle arrow down",
  "left swipe",
  "slide left",
  "swipe left gesture",
  "finger swipe",
  "right swipe",
  "touch screen",
  "swipe_right_alt",
  "swipe up",
  "drag up",
  "vertical drag",
  "vertical navigation",
  "vertical scroll",
  "vertical swipe",
  "verticle",
  "concentric squares",
  "settings control",
  "toggle switch",
  "alternative input",
  "switch access",
  "device switching",
  "accessibility shortcut",
  "switch control",
  "alternate account",
  "change account",
  "change user",
  "choose account",
  "multiple accounts",
  "profile management",
  "select account",
  "swap user",
  "switch account",
  "switch profile",
  "switch user",
  "toggle account",
  "camera outline",
  "invert camera",
  "reverse camera",
  "swap camera",
  "switch left",
  "toggle left",
  "change right",
  "switch right",
  "toggle right",
  "transfer right",
  "camera direction",
  "camera input",
  "switch input",
  "toggle video",
  "video device",
  "video switch",
  "battle",
  "beast",
  "chivalry",
  "dagger",
  "duel",
  "rose",
  "rpg",
  "sword",
  "young adult",
  "blades crossed",
  "crossed swords",
  "fencing",
  "knight",
  "player versus player",
  "pvp",
  "swords",
  "two swords",
  "viking",
  "conjunctivitis",
  "crying",
  "crying eye",
  "dryness",
  "eye infection",
  "eye irritation",
  "eye problem",
  "pink eye",
  "symptoms",
  "tears",
  "watery eye",
  "weep",
  "high holidays",
  "house of worship",
  "israel",
  "jew",
  "jewish",
  "judaism",
  "rosh hashanah",
  "shabbat",
  "shul",
  "star of david",
  "synagogue",
  "torah",
  "yom kippur",
  "cloud sync",
  "file synchronization",
  "refresh icon",
  "reload icon",
  "sync icon",
  "update icon",
  "alternative sync",
  "correspond",
  "cyclical",
  "information exchange",
  "sync alt",
  "sync down",
  "cancel sync",
  "cloud sync disabled",
  "data synchronization disabled",
  "disable synchronization",
  "not syncing",
  "pause sync",
  "refresh disabled",
  "stop sync",
  "syncing off",
  "unsynchronized",
  "locked refresh",
  "locked update",
  "refresh lock",
  "restricted sync",
  "restricted update",
  "secure sync",
  "secure update",
  "sync lock",
  "sync security",
  "update security",
  "out of sync",
  "refresh error",
  "refresh issue",
  "refresh problem",
  "sync issue",
  "sync problem",
  "synchronization error",
  "synchronization issue",
  "syncing error",
  "syncing issue",
  "update error",
  "update issue",
  "update problem",
  "flu shot",
  "health care",
  "hypodermic",
  "inoculation",
  "jab",
  "vaccines",
  "download app",
  "install app",
  "mobile download",
  "security update",
  "application install",
  "firmware update",
  "install icon",
  "os update",
  "software install",
  "system refresh",
  "close tab",
  "multiple tabs",
  "remove panel",
  "stacked tabs",
  "close right",
  "close right tabs",
  "close tabs",
  "delete tab",
  "delete tabs",
  "dismiss tab",
  "dismiss tabs",
  "remove tab",
  "remove tabs",
  "tabs right",
  "browser tabs",
  "layered windows",
  "switching",
  "tab group",
  "web pages",
  "tab inactive",
  "duplicate tab",
  "forward tab",
  "move tab",
  "next tab",
  "open new",
  "browser history",
  "last viewed",
  "open recent",
  "previously viewed",
  "recent documents",
  "recent files",
  "recent tabs",
  "restore tab",
  "search tab",
  "tab search",
  "bar table",
  "bistro",
  "bistro table",
  "cafe table",
  "high top",
  "high top table",
  "legs",
  "pub table",
  "restaurant table",
  "round table",
  "table bar",
  "column chart",
  "table chart",
  "chart view",
  "data view",
  "restructure",
  "data edit",
  "edit table",
  "grid edit",
  "modify table",
  "spreadsheet edit",
  "table edit",
  "table modify",
  "inspect table",
  "show table",
  "table inspection",
  "table view",
  "view table",
  "adjustable",
  "desk lamp",
  "banquet",
  "canteen",
  "four legs",
  "table rows",
  "tabular data",
  "digital tablet",
  "handheld device",
  "rectangle screen",
  "square screen",
  "home button",
  "capture image",
  "device camera",
  "portable camera",
  "tablet photography",
  "tablet mac",
  "content sections",
  "panel navigation",
  "tab control",
  "tabbed interface",
  "tabbed navigation",
  "tabbed view",
  "gameplan",
  "crosshatch",
  "hash symbol",
  "keyword",
  "microblogging",
  "octothorpe",
  "pound sign",
  "carryout",
  "chinese food",
  "delivery icon",
  "food box",
  "food order",
  "food package",
  "handles",
  "takeout icon",
  "to go",
  "to-go box",
  "to-go container",
  "anti-tamper",
  "interference",
  "no tampering",
  "tamper",
  "tamper detection",
  "OS wifi",
  "mobile cast",
  "tap and play",
  "mediterranean",
  "olives",
  "small plates",
  "tapas",
  "toothpick",
  "archery",
  "bulls",
  "dartboard",
  "task_alt",
  "tick circle",
  "boast",
  "brag",
  "dab",
  "dabbing",
  "disrespect",
  "emote",
  "internet culture",
  "jeer",
  "mock",
  "ridicule",
  "show off",
  "taunt",
  "troll",
  "taxi cab",
  "taxi service",
  "group dashboard",
  "project dashboard",
  "shared dashboard",
  "team dashboard",
  "conserve",
  "preservation",
  "buddha",
  "buddhism",
  "buddhist",
  "historical",
  "monastery",
  "monument",
  "pagoda",
  "religious icon",
  "shrine",
  "gopuram",
  "hindu",
  "hinduism",
  "hindus",
  "indian",
  "mandir",
  "south asia",
  "affiliation",
  "subordinate",
  "tenancy",
  "bash",
  "cli",
  "command line",
  "command prompt",
  "emulator",
  "zsh",
  "blog post",
  "web form",
  "revision",
  "text_compare",
  "character size",
  "decrease font",
  "font scaling",
  "font size decrease",
  "reduce text size",
  "smaller text",
  "text decrease",
  "text scaling",
  "zoom out text",
  "capital t",
  "double t",
  "lowercase t",
  "text fields",
  "tt",
  "two t's",
  "ai content",
  "ai text",
  "ai writing",
  "generate text",
  "language model",
  "text generation",
  "square A",
  "text options",
  "text styling",
  "text_increase",
  "capital letter",
  "rotate text up",
  "text flip",
  "text orientation",
  "text rotate",
  "text rotation",
  "vertical rotation",
  "angledown",
  "angle up",
  "angleup",
  "text angle",
  "character rotation",
  "dow",
  "rotate text down",
  "text down",
  "no rotation",
  "end of text",
  "text end",
  "go to start",
  "scroll to top",
  "text navigation",
  "cursor navigation",
  "end of line",
  "eol",
  "move cursor",
  "skip to end",
  "text jump",
  "editing text",
  "move text",
  "previous character",
  "previous word",
  "adjust text",
  "change text order",
  "down caret",
  "line down",
  "lower text",
  "move line down",
  "move text down",
  "order down",
  "paragraph down",
  "paragraph move",
  "reorder text",
  "shift down",
  "sort down",
  "text move",
  "text position",
  "text reorder",
  "text select",
  "text shift",
  "next character",
  "move word",
  "select word",
  "shift text",
  "move line up",
  "move paragraph up",
  "move text up",
  "select move",
  "text block",
  "text select move",
  "text up",
  "text_snippet",
  "convert text",
  "doc data",
  "listen to text",
  "play sound",
  "pronounce",
  "read aloud",
  "read text",
  "text reader",
  "text to speech",
  "tts",
  "capitalize",
  "increase font size",
  "unknow",
  "grooved",
  "ribbed",
  "ridged",
  "tilted",
  "add pattern",
  "add texture",
  "apply texture",
  "create texture",
  "insert texture",
  "new pattern",
  "new texture",
  "pattern icon",
  "plus pattern",
  "plus texture",
  "stripes pattern",
  "texture icon",
  "decrease pattern",
  "decrease texture",
  "diagonal stripes",
  "less pattern",
  "less texture",
  "pattern control",
  "pattern removal",
  "reduce pattern",
  "reduce texture",
  "remove overlay",
  "remove pattern",
  "remove texture",
  "subtract pattern",
  "subtract texture",
  "texture control",
  "texture removal",
  "comedy show",
  "drama show",
  "entertainment industry",
  "mask icon",
  "performing arts",
  "theatrical performance",
  "tragedy mask",
  "entertainment venues",
  "local cinema",
  "local films",
  "local movies",
  "local theater",
  "showtimes",
  "theaters",
  "tickets",
  "kelvin",
  "weather forecast",
  "add temperature",
  "add thermometer",
  "create temperature",
  "hotter",
  "new temperature",
  "new thermometer",
  "temperature measurement",
  "thermometer plus",
  "heat up",
  "temperature increase",
  "temperature rising",
  "thermometer up",
  "warming",
  "heat loss",
  "reduction",
  "subzero",
  "temperature drop",
  "thermometer down",
  "cold temperature",
  "colder",
  "decrease temperature",
  "lower temperature",
  "reduce temperature",
  "remove heat",
  "temperature down",
  "adjust temperature",
  "increase temperature",
  "raise temperature",
  "temperature adjustment",
  "temperature up",
  "regulate",
  "landmarks",
  "things to do",
  "cyberattack",
  "cybersecurity threat",
  "risk assessment",
  "threat analysis",
  "threat intelligence",
  "against",
  "ate",
  "disapproval gesture",
  "disapprove",
  "dislike button",
  "down vote",
  "downvote",
  "negative feedback",
  "thumb down",
  "thumbs down",
  "thumbs down button",
  "unlike button",
  "veto",
  "like outline",
  "thumb up outline",
  "upvote",
  "content view",
  "image list",
  "image preview",
  "previews",
  "thumbnail bar",
  "double thumbs",
  "thumbs up down",
  "cloud with lightning",
  "electric storm",
  "tibia",
  "fibula",
  "human anatomy",
  "human leg",
  "leg bone",
  "patella",
  "large tile",
  "tile large",
  "tile medium",
  "auto time",
  "auto timer",
  "automatic time",
  "time automation",
  "time settings",
  "elapsed time",
  "chronology",
  "dates",
  "roadmap",
  "count up",
  "10 minutes",
  "10 seconds",
  "count down",
  "10s",
  "picked",
  "ten seconds",
  "3 seconds",
  "3s",
  "number three",
  "numeral three",
  "short timer",
  "three seconds",
  "5 minutes",
  "5 seconds",
  "brief timer",
  "five minutes",
  "five seconds",
  "quick timer",
  "countdown down",
  "decrease time",
  "duration decrease",
  "lower time",
  "reduce time",
  "shorten time",
  "stopwatch down",
  "time decrease",
  "time down",
  "timer down",
  "increase time",
  "lengthen",
  "timer up",
  "no timer",
  "remove timer",
  "countdown timer",
  "interval timer",
  "pause symbol",
  "progress pause",
  "task timer",
  "timer control",
  "begin timer",
  "play symbol",
  "start timer",
  "air pump",
  "check tire pressure",
  "flat tire",
  "inflate",
  "inflation",
  "pit stop",
  "pressure gauge",
  "tire inflation gauge",
  "tire pressure",
  "cross shape",
  "letterform",
  "resize text",
  "sentence case",
  "heads up display",
  "hud",
  "snackbar",
  "system message",
  "user interface element",
  "chapters",
  "table of contents",
  "titles",
  "toc",
  "now",
  "inable",
  "power_off",
  "slider_off",
  "switch_off",
  "toggle_button",
  "toggle_off",
  "toggle_switch",
  "switch on",
  "toggle button",
  "toggle on",
  "toll",
  "adjust tone",
  "color balance",
  "color tone",
  "image balance",
  "image exposure",
  "light and shadow",
  "shadows",
  "flat head",
  "rungs",
  "three rungs",
  "bubble level",
  "spirit level",
  "crosshead",
  "phillips",
  "crimp",
  "crimper",
  "crimping",
  "cutter",
  "gripping",
  "pincers",
  "pliers",
  "stripper",
  "wire stripper",
  "bore",
  "cordless drill",
  "crafting",
  "drill",
  "drilling",
  "electric drill",
  "fasten",
  "power drill",
  "powertool",
  "screws",
  "bubbletool",
  "expand information",
  "explain",
  "more information",
  "say",
  "additional info",
  "on hover",
  "top panel",
  "open panel",
  "folder with lines",
  "lines in folder",
  "force",
  "dissolved",
  "impurity",
  "salts",
  "sediment",
  "substances",
  "tds",
  "total dissolved solids",
  "water analysis",
  "water quality",
  "water testing",
  "double click",
  "double finger tap",
  "double press",
  "double tap",
  "double touch",
  "multi-touch",
  "touchpad",
  "two taps",
  "two touches",
  "long press",
  "long touch",
  "press and hold",
  "touch and hold",
  "three touch",
  "triple arc",
  "triple tap",
  "triple touch",
  "clickwheel",
  "cursor control",
  "mouse settings",
  "pointing device",
  "scroll wheel",
  "touchpad settings",
  "two-finger scroll",
  "no cursor",
  "no pointer",
  "travel plan",
  "children's toy",
  "kids store",
  "toy car",
  "toy store",
  "toys",
  "jigsaw piece",
  "puzzles",
  "pinwheel",
  "quatrefoil",
  "activity log",
  "change log",
  "compare versions",
  "evolve",
  "revision history",
  "three finger gesture",
  "three finger swipe",
  "three finger tap",
  "trackpad_input_3",
  "signalization",
  "stoplight",
  "three lights",
  "traffic light",
  "bumper to bumper",
  "car column",
  "car row",
  "congestion",
  "heavy traffic",
  "standstill",
  "three cars",
  "traffic jam",
  "vehicles",
  "meteor",
  "streak",
  "mid-level",
  "short path",
  "short trail",
  "electric train",
  "light rail",
  "public transit map",
  "streetcar",
  "trolleybus",
  "transcribe",
  "voice to text",
  "bus transfer",
  "internal transfer",
  "platform change",
  "station change",
  "station transfer",
  "train transfer",
  "transport hub",
  "within",
  "within station",
  "human rights",
  "sexual identity",
  "social movement",
  "trans",
  "transgender",
  "transgender symbol",
  "egress",
  "enterexit",
  "public transportation ticket",
  "train ticket",
  "transit pass",
  "director's cut",
  "film cut",
  "flix",
  "jump cut",
  "montage",
  "scenes",
  "appear",
  "dissolve",
  "image transition",
  "transition effect",
  "video transition",
  "fade to black",
  "halftone",
  "stipple",
  "car and motorcycle",
  "four wheeled vehicle",
  "mixed transportation",
  "transportation modes",
  "two wheeled vehicle",
  "destination search",
  "explore the world",
  "find a trip",
  "global search",
  "globe search",
  "search travel",
  "travel discovery",
  "travel search",
  "world explorer",
  "bags",
  "luggage bag",
  "packing",
  "depreciation",
  "downturn",
  "trending down",
  "domestic travel",
  "international travel",
  "long trip",
  "overseas trip",
  "short trip",
  "weekend getaway",
  "handcart",
  "pushcart",
  "shopping trolley",
  "two boxes",
  "cable car icon",
  "passenger car",
  "public transit icon",
  "tourism icon",
  "tram icon",
  "trolley icon",
  "uphill transport",
  "1st",
  "big wave",
  "cataclysm",
  "crest",
  "giant wave",
  "seaquake",
  "tidal wave",
  "tide",
  "tsunami",
  "delimited",
  "tab separated values",
  "tsv",
  "digital communication",
  "teletype",
  "text-based communication",
  "tty",
  "horizontal sliders",
  "sharp left",
  "sharp turn",
  "sharp turn left",
  "turn left arrow",
  "arrow turn right",
  "right turn arrow",
  "sharp right",
  "sharp right turn",
  "turn corner",
  "turn sharp right",
  "upwards arrow",
  "arrow bend",
  "continue left",
  "proceed left",
  "slight",
  "slight left",
  "slight turn",
  "turn arrow",
  "slight right",
  "slight right turn",
  "my tv",
  "my videos",
  "personal media",
  "personal video",
  "video library",
  "configure displays",
  "connect display",
  "dual screens",
  "duplicate display",
  "monitors",
  "tv setup",
  "airtime",
  "channel guide",
  "episode",
  "program guide",
  "tv icon",
  "tv listing",
  "tv logo",
  "tv program",
  "forward skip",
  "next channel",
  "next episode",
  "tv control",
  "disabled state",
  "inactive state",
  "monitor power",
  "no television",
  "no tv",
  "off state",
  "television disabled",
  "television off",
  "tv disabled",
  "tv power",
  "tv_off",
  "channel list",
  "epg",
  "google connect",
  "google tv",
  "television control",
  "tv with assistant",
  "double page",
  "dual page",
  "page spread",
  "two page",
  "two pager",
  "pager",
  "sidecar",
  "two wheeler",
  "specimen",
  "180",
  "about-face",
  "backtrack",
  "hairpin turn",
  "about face",
  "u turn right",
  "uturn",
  "connected lines",
  "forearm",
  "intertwined lines",
  "orthopaedic",
  "ulna",
  "two bones",
  "rainy day",
  "rainy season",
  "decompression",
  "unpack",
  "command z",
  "control z",
  "display less",
  "expand less",
  "reveal less",
  "section toggle",
  "unfold less",
  "collapse less",
  "minimize less",
  "reveal more",
  "vertical expand",
  "break apart",
  "unmerge",
  "unknown document",
  "unknown file",
  "unknown file type",
  "unsupported",
  "what is this",
  "miss",
  "temporary halt",
  "anti-copyright",
  "cc0",
  "copyright free",
  "creative commons zero",
  "free to use",
  "freeware",
  "license removal",
  "no copyright",
  "no license",
  "open license",
  "permissive license",
  "public domain",
  "remove license",
  "slashed c",
  "slashed circle",
  "uncrossed circle",
  "unlicense",
  "all-terrain",
  "bumpy road",
  "dirt road",
  "gravel road",
  "off-road",
  "pebbles",
  "rough road",
  "suv",
  "uneven surface",
  "unmaintained road",
  "unpaved road",
  "unpublished",
  "mail stop",
  "no notification",
  "expect",
  "forthcoming",
  "imminent",
  "block refresh",
  "block reload",
  "block sync",
  "block update",
  "disabled refresh",
  "disabled reload",
  "disabled sync",
  "disabled update",
  "no refresh",
  "no reload",
  "no sync",
  "no update",
  "reload disabled",
  "update disabled",
  "instal",
  "cashless",
  "fast payment",
  "gpay",
  "instant payment",
  "mobile banking",
  "secure payment",
  "unified payments interface",
  "upi",
  "contribute file",
  "document upload",
  "import file",
  "share file",
  "submit file",
  "transfer file",
  "media upload",
  "upload 2",
  "incontinence",
  "men's health",
  "pelvic health",
  "prostate",
  "urinary tract",
  "urologist",
  "trident",
  "universal serial bus",
  "data transfer off",
  "device disconnected",
  "hardware disconnected",
  "no usb",
  "port disabled",
  "port off",
  "usb disabled",
  "usb disconnect",
  "usb off",
  "user options",
  "user profile attributes",
  "immunisation",
  "immunity",
  "carpet",
  "deep clean",
  "hoover",
  "upholstery",
  "vacuum",
  "vacuuming",
  "hydraulic",
  "pneumatic",
  "shut off",
  "do not",
  "e-cigarette",
  "e-cigarette ban",
  "electronic cigarette prohibited",
  "no e-cigarette",
  "no electronic cigarette",
  "no nicotine",
  "no vape",
  "no vaping",
  "smoking ban",
  "vape free",
  "vaping prohibited",
  "ecigarette",
  "electronic cigarette",
  "vape pen",
  "vape shop",
  "vape store",
  "vaping area",
  "vaping lounge",
  "vaping room",
  "vaporizer",
  "add variable",
  "create variable",
  "insert variable",
  "new variable",
  "clear variable",
  "delete variable",
  "field remove",
  "form delete",
  "input delete",
  "remove variable",
  "variable delete",
  "breathing apparatus",
  "icu",
  "intensive care",
  "mechanical ventilation",
  "medical device",
  "medical equipment",
  "respiratory support",
  "respiratory therapy",
  "ventilator",
  "new releases",
  "reliable",
  "authenticity disabled",
  "authenticity off",
  "authenticity remove",
  "badge disabled",
  "badge off",
  "badge remove",
  "cancel verification",
  "disable verification",
  "not verified",
  "reject verification",
  "remove verification",
  "seal broken",
  "seal disabled",
  "seal off",
  "seal remove",
  "security disabled",
  "security remove",
  "starburst disabled",
  "starburst off",
  "starburst remove",
  "trust disabled",
  "trust off",
  "trust remove",
  "unverification",
  "unverified",
  "verification cancelled",
  "verification disabled",
  "verification off",
  "verification rejected",
  "verification removed",
  "verified_off",
  "trusted",
  "lowest",
  "middle align",
  "up and down",
  "vertical_distribute",
  "covering",
  "louvers",
  "shades",
  "four columns",
  "lowered",
  "vertical_split",
  "tremble",
  "create video call",
  "join video call",
  "new video call",
  "start video call",
  "camera view",
  "add recording",
  "camera add",
  "create video",
  "film video",
  "new video",
  "plus camera",
  "plus video",
  "video camera add",
  "video plus",
  "capture video",
  "person video",
  "profile video",
  "record symbol",
  "start video",
  "user video",
  "video camera icon",
  "video message",
  "video stream",
  "video symbol",
  "camera slash",
  "forbidden video",
  "front camera off",
  "no video signal",
  "selfie camera off",
  "user camera off",
  "video broadcast off",
  "video slash",
  "video stream off",
  "facetime",
  "movie file",
  "video archive",
  "video document",
  "footage",
  "video label",
  "video management",
  "video marker",
  "video metadata",
  "video tag",
  "film library",
  "movie library",
  "content search",
  "explore video",
  "find video",
  "media search",
  "online video",
  "search video",
  "video browser",
  "video discovery",
  "video platform",
  "video player search",
  "video search",
  "video setup",
  "anti-shake",
  "image stabilization",
  "motion stabilization",
  "stabilize",
  "stable",
  "steady",
  "steady cam",
  "steady video",
  "taping",
  "video stabilization",
  "video_stable",
  "movie camera",
  "record icon",
  "video recorder",
  "camera issue",
  "camera warning",
  "recording issue",
  "recording problem",
  "recording warning",
  "video error",
  "video issue",
  "video problem",
  "video warning",
  "disable camera",
  "disabled camera",
  "end video call",
  "end video chat",
  "hide video",
  "video hidden",
  "video mute",
  "video privacy",
  "videocam off",
  "game asset",
  "gaming console",
  "video game asset",
  "asset off",
  "controller disabled",
  "end game",
  "game asset off",
  "game off",
  "gamepad disabled",
  "gaming disabled",
  "no controller",
  "no game",
  "no gamepad",
  "no gaming",
  "pause game",
  "stop game",
  "subjects",
  "view agenda",
  "select app",
  "view all",
  "view array",
  "content browsing",
  "image browsing",
  "media browsing",
  "media viewer",
  "picture browsing",
  "three items",
  "three slides",
  "three vertical lines",
  "view column",
  "view display",
  "view layout",
  "view_column",
  "comfortable",
  "comfy",
  "two column",
  "2x2",
  "condensed",
  "layout dense",
  "view cozy",
  "multiple lines",
  "view content",
  "view headline",
  "view title",
  "3d model",
  "view in ar",
  "3d disabled",
  "3d inactive",
  "3d off",
  "3d view off",
  "ar disabled",
  "ar inactive",
  "ar off",
  "augmented reality disabled",
  "augmented reality inactive",
  "augmented reality off",
  "disable 3d",
  "disable ar",
  "disable view",
  "disable vr",
  "three dimensional off",
  "three dimensional view off",
  "view in ar off",
  "virtual reality disabled",
  "virtual reality inactive",
  "virtual reality off",
  "vr disabled",
  "vr inactive",
  "vr off",
  "agile",
  "columns view",
  "kanban",
  "kanban board",
  "kanban view",
  "project organization",
  "project view",
  "scrum",
  "vertical columns",
  "view kanban",
  "workflow management",
  "view_list",
  "view module",
  "quilt",
  "100%",
  "actual size",
  "default size",
  "full size",
  "normal size",
  "one hundred percent",
  "one to one",
  "original size",
  "real size",
  "screen fit",
  "stream view",
  "view stream",
  "chronological",
  "view timeline",
  "weekly view",
  "select image",
  "vignette",
  "vacation stay",
  "villa",
  "eye icon",
  "open eye",
  "viewable",
  "eye lock",
  "show view",
  "view lock",
  "visibility lock",
  "cant see",
  "censorship",
  "do not show",
  "no looking",
  "obscured",
  "unsee",
  "viewing off",
  "life signs",
  "vital statistics",
  "aerobic",
  "cardiorespiratory",
  "maximal oxygen consumption",
  "vital capacity",
  "vo2",
  "vo2 max",
  "vocal",
  "voice_chat",
  "commentary off",
  "disable voice",
  "narration off",
  "no voice",
  "person mute",
  "user mute",
  "voice disabled",
  "voice off",
  "voice over off",
  "voiceover off",
  "choose voice",
  "select voice",
  "side profile",
  "voice selection",
  "sound input",
  "speech control",
  "speech input",
  "speech selection",
  "answerphone",
  "cassette tape",
  "reel-to-reel",
  "voicemail symbol",
  "cassette",
  "voicemail message",
  "voicemail_2",
  "active volcano",
  "eruption",
  "geological",
  "lava",
  "magma",
  "volcano",
  "adjust volume",
  "audio down",
  "decrease volume",
  "lower volume",
  "quieter",
  "reduce volume",
  "sound down",
  "volume adjustment",
  "volume decrease",
  "volume_down",
  "lower sound",
  "volume down alt",
  "audio muted",
  "sound muted",
  "speaker muted",
  "volume_mute",
  "amplification",
  "increase volume",
  "louder",
  "volume increase",
  "activism",
  "generosity",
  "humanitarian",
  "philanthropy",
  "social good",
  "welfare",
  "key icon",
  "lock icon",
  "privacy key",
  "vpn key",
  "connection alert",
  "key alert",
  "private key",
  "vpn alert",
  "vpn warning",
  "no key",
  "no vpn",
  "private off",
  "unlock off",
  "vpn disabled",
  "global security",
  "safe browsing",
  "secure browsing",
  "vpn connection",
  "web security",
  "encrypted connection",
  "globe lock",
  "lock globe",
  "world lock",
  "create2d",
  "vr180",
  "vr panorama",
  "canvas",
  "poster",
  "wall art",
  "sconce",
  "wall lamp",
  "wall light",
  "wall-mounted",
  "enchantment",
  "magic wand",
  "sorcery",
  "wand",
  "wand_shine",
  "witch",
  "fairy",
  "illusion",
  "mage",
  "magical",
  "miracle",
  "mystic",
  "warlock",
  "witchcraft",
  "depot",
  "hangar",
  "house shape",
  "storage building",
  "storehouse",
  "wholesale",
  "all clear",
  "cancel warning",
  "caution off",
  "disable warning",
  "ignore warnings",
  "issue resolved",
  "problem solved",
  "remove warning",
  "silence warnings",
  "suppress warnings",
  "threat removed",
  "turn off warnings",
  "warning dismissed",
  "warning inactive",
  "disease prevention",
  "hand wash",
  "analog watch",
  "lugs",
  "timepiece",
  "watch app",
  "watch control",
  "watch face",
  "watch navigation",
  "wearable control",
  "side button",
  "watch button",
  "watch check",
  "watch checkmark",
  "no watch",
  "watch off",
  "screentime",
  "activity tracker",
  "awaken",
  "wearable device",
  "aqua",
  "hydrate",
  "hydration reminder",
  "hydroflask",
  "reusable",
  "sipper",
  "sports bottle",
  "water_bottle",
  "gallon",
  "h2o",
  "water bottle",
  "water cooler",
  "burst pipe",
  "home insurance",
  "house flood",
  "leak detection",
  "plumbing issue",
  "roof leak",
  "water damage",
  "carbonated",
  "droplet do",
  "fizz",
  "sparkling",
  "water do",
  "water supply",
  "hydroelectricity",
  "hydropower",
  "save water",
  "water charge",
  "water conservation",
  "water electricity",
  "water energy",
  "water power",
  "drinking water",
  "full cup",
  "full glass",
  "full tank",
  "potable water",
  "quench",
  "reservoir",
  "geyser",
  "water heater",
  "water_heater",
  "conserve water",
  "leakproof",
  "sealed",
  "water resistant",
  "water_lock",
  "drought",
  "refraction",
  "orp",
  "oxidation",
  "oxidation-reduction potential",
  "purification",
  "redox",
  "water treatment",
  "acid",
  "acidic",
  "acidity",
  "alkaline",
  "alkalinity",
  "hydrogen",
  "ph",
  "water droplet",
  "water ph",
  "groundwater intake",
  "pump system",
  "pumping",
  "rainwater harvesting",
  "wastewater",
  "water pressure",
  "water pressure boosting",
  "water pump",
  "waterworks",
  "chemicals",
  "compounds",
  "voc",
  "volatile",
  "volatile organic compounds",
  "warm water",
  "water pollution",
  "water voc",
  "rectangular bars",
  "waterfall",
  "approachable",
  "bye",
  "farewell",
  "goodbye",
  "greetings",
  "hey",
  "salutation",
  "waving hand",
  "W",
  "aw",
  "letter w",
  "wp",
  "light fixture",
  "wb_incandescent",
  "sunlight",
  "wb_shade",
  "wb_sunny",
  "dawn",
  "half sun",
  "noon",
  "partial sun",
  "rising sun",
  "setting sun",
  "restroom symbols",
  "forecast icon",
  "hailstone",
  "hailstones",
  "hailstorm",
  "snowy",
  "weather icon",
  "weather symbol",
  "mixed conditions",
  "rain symbol",
  "snow symbol",
  "freezing",
  "-website",
  "browser error",
  "incompatible",
  "not supported",
  "web error",
  "online content",
  "web stories",
  "clickstream",
  "inbound marketing",
  "internet traffic",
  "mouse cursor",
  "online marketing",
  "sem",
  "seo",
  "user activity",
  "user engagement",
  "web traffic",
  "website analytics",
  "website traffic",
  "website visits",
  "webhook",
  "days off",
  "free time",
  "saturday",
  "sunday",
  "grams",
  "heavy lifting",
  "kg",
  "kilogram",
  "lb",
  "lbs",
  "pounds",
  "tonne",
  "weigh",
  "weight plate",
  "western",
  "hot topics",
  "trending content",
  "trending now",
  "trending topics",
  "what's hot",
  "whatshot",
  "para-transit",
  "paratransit",
  "pick-up",
  "find polling place",
  "polling place",
  "validate election",
  "vote location",
  "where to vote",
  "content width",
  "default width",
  "display size",
  "video size",
  "window size",
  "1 bar",
  "connection indicator",
  "low connectivity",
  "weak connection",
  "wifi bar",
  "wifi indicator",
  "add network",
  "add wifi",
  "connect wifi",
  "join wifi",
  "new network",
  "new wifi",
  "wifi add",
  "wifi plus",
  "voip call",
  "wifi calling",
  "wireless call",
  "high signal",
  "change channel",
  "double arch",
  "select channel",
  "wifi channel",
  "connection search",
  "discover wifi",
  "find signal",
  "find wifi",
  "internet search",
  "locate wifi",
  "network discovery",
  "network search",
  "search signal",
  "search wifi",
  "signal search",
  "wifi find",
  "wifi location",
  "wifi scan",
  "wireless search",
  "domestic network",
  "home wifi",
  "residential network",
  "wifi_home",
  "full strength",
  "connectivity alert",
  "internet notification",
  "network notification",
  "signal notification",
  "wifi alert",
  "disable internet",
  "disable network",
  "disable wifi",
  "disable wireless",
  "no internet symbol",
  "wifi symbol",
  "lock wifi",
  "password protected",
  "private wifi",
  "wifi password",
  "wps",
  "wifi building",
  "wifi proxy",
  "concentric semicircles",
  "internet sharing",
  "portable hotspot",
  "semicircles",
  "wifi tethering",
  "three blades",
  "wind farm",
  "sliding window",
  "demister",
  "goblet",
  "wine bar",
  "female icon",
  "woman symbol",
  "female_2",
  "ladies",
  "profile_2",
  "user_2",
  "woman_2",
  "cv",
  "attention work",
  "briefcase alert",
  "briefcase notification",
  "briefcase warning",
  "business alert",
  "business notification",
  "career alert",
  "deadline alert",
  "deadline warning",
  "employment alert",
  "employment notification",
  "employment warning",
  "important task",
  "job alert",
  "job notification",
  "job reminder",
  "job warning",
  "office alert",
  "office notification",
  "project alert",
  "project notification",
  "task alert",
  "task notification",
  "urgent task",
  "work alert",
  "work notification",
  "work reminder",
  "work warning",
  "employment history",
  "job history",
  "past work",
  "previous jobs",
  "track record",
  "work history",
  "benefit",
  "perk",
  "workspace premium",
  "projects",
  "workspaces",
  "abrasion",
  "gash",
  "injuries",
  "laceration",
  "scar",
  "scratch",
  "sew",
  "staples",
  "stitch",
  "stitching",
  "suture",
  "wounds",
  "arrow writing",
  "line wrap",
  "feel",
  "bad location",
  "inaccurate",
  "incorrect position",
  "misplaced",
  "not found",
  "content editor",
  "what you see is what you get",
  "wysiwyg",
  "pettle",
  "past trips",
  "trips",
  "your_trips",
  "find again",
  "last search",
  "past searches",
  "previous searches",
  "redo search",
  "refresh search",
  "reload search",
  "repeat search",
  "search loop",
  "geofence",
  "person alert",
  "zone alert",
  "account blocked",
  "exclusion zone",
  "no people allowed",
  "person crossed out",
  "person restriction",
  "user blocked",
  "user restriction",
  "closer look",
  "zoom level",
  "zoom_in",
  "closer view",
  "detailed view",
  "enlarge map",
  "expand map",
  "inwards",
  "inwards arrows",
  "location zoom",
  "magnify map",
  "map zoom",
  "navigation zoom",
  "zoom map",
  "zoom_in_map",
  "content zoom",
  "document zoom",
  "image zoom",
  "text zoom",
  "zoom_out",
  "zoom out map",
];


/// This map contains the metadata for all Material Symbols icons.
/// The keys are the icon's dart symbol name and the values are SymbolsMetadata objects that contain the metadata.
/// The metadata includes the original name, popularity, codepoint, categories, tags, and whether the icon is RTL auto-mirrored.
Map<String, SymbolsMetadata> iconMap = {
  "ten_k": SymbolsMetadata(
    originalName: "10k",
    popularity: 194,
    codepoint: 0xe951,
    categories: [ 0 ],
    tags: [ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42 ],
  ),
  "ten_mp": SymbolsMetadata(
    originalName: "10mp",
    popularity: 110,
    codepoint: 0xe952,
    categories: [ 1 ],
    tags: [ 43, 44, 45, 46, 7, 47, 48, 49, 50, 14, 51, 52, 53, 54, 55, 19, 56, 57, 58, 23, 24, 59, 60, 61, 26, 27, 62, 63, 30, 64, 65, 66, 32, 35, 38, 40, 41, 67, 68 ],
  ),
  "eleven_mp": SymbolsMetadata(
    originalName: "11mp",
    popularity: 90,
    codepoint: 0xe953,
    categories: [ 1 ],
    tags: [ 69, 70, 47, 48, 49, 71, 50, 72, 14, 53, 54, 55, 19, 56, 57, 58, 24, 59, 60, 73, 61, 74, 26, 27, 62, 75, 30, 64, 76, 77, 78, 65, 32, 35, 38, 40 ],
  ),
  "onetwothree": SymbolsMetadata(
    originalName: "123",
    popularity: 2242,
    codepoint: 0xeb8d,
    categories: [ 2 ],
    tags: [ 79, 80, 81, 82, 83, 84, 85, 86, 87, 11, 88, 89, 90, 91, 92, 93, 24, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 35, 110 ],
  ),
  "twelve_mp": SymbolsMetadata(
    originalName: "12mp",
    popularity: 110,
    codepoint: 0xe954,
    categories: [ 1 ],
    tags: [ 111, 112, 113, 47, 114, 115, 116, 71, 50, 14, 52, 53, 117, 19, 56, 57, 58, 23, 24, 59, 118, 61, 119, 120, 26, 27, 62, 121, 30, 78, 122, 65, 32, 35, 38, 123, 40 ],
  ),
  "thirteen_mp": SymbolsMetadata(
    originalName: "13mp",
    popularity: 98,
    codepoint: 0xe955,
    categories: [ 1 ],
    tags: [ 124, 125, 47, 48, 49, 116, 71, 50, 14, 52, 53, 55, 126, 19, 56, 57, 58, 23, 24, 59, 60, 61, 119, 26, 27, 62, 75, 30, 64, 78, 122, 32, 35, 38, 127, 40 ],
  ),
  "fourteen_mp": SymbolsMetadata(
    originalName: "14mp",
    popularity: 92,
    codepoint: 0xe956,
    categories: [ 1 ],
    tags: [ 128, 129, 130, 47, 114, 115, 131, 132, 71, 50, 14, 133, 134, 52, 53, 117, 135, 19, 56, 57, 58, 23, 24, 59, 61, 119, 26, 27, 62, 30, 78, 122, 136, 32, 35, 38, 40 ],
  ),
  "fifteen_mp": SymbolsMetadata(
    originalName: "15mp",
    popularity: 95,
    codepoint: 0xe957,
    categories: [ 1 ],
    tags: [ 137, 138, 139, 47, 114, 49, 71, 50, 14, 51, 52, 140, 53, 54, 55, 19, 56, 57, 58, 23, 24, 59, 73, 141, 61, 119, 26, 27, 62, 30, 78, 122, 65, 32, 35, 38, 40 ],
  ),
  "sixteen_mp": SymbolsMetadata(
    originalName: "16mp",
    popularity: 94,
    codepoint: 0xe958,
    categories: [ 1 ],
    tags: [ 142, 143, 144, 7, 47, 114, 145, 49, 71, 50, 14, 133, 134, 52, 53, 117, 19, 56, 57, 58, 23, 24, 59, 141, 61, 119, 26, 27, 62, 30, 122, 65, 146, 32, 35, 38, 40 ],
  ),
  "seventeen_mp": SymbolsMetadata(
    originalName: "17mp",
    popularity: 86,
    codepoint: 0xe959,
    categories: [ 1 ],
    tags: [ 147, 148, 47, 48, 149, 49, 71, 50, 14, 52, 16, 53, 55, 19, 56, 57, 58, 23, 24, 59, 141, 61, 119, 150, 26, 27, 62, 30, 64, 76, 65, 151, 32, 35, 38, 40 ],
  ),
  "eighteen_up_rating": SymbolsMetadata(
    originalName: "18_up_rating",
    popularity: 441,
    codepoint: 0xf8fd,
    categories: [ 3 ],
    tags: [ 152, 153, 154, 155, 156, 157, 158, 7, 159, 160, 161, 162, 163, 164, 165, 166, 23, 167, 168, 169, 170, 102, 171, 172, 32, 173, 174 ],
  ),
  "eighteen_mp": SymbolsMetadata(
    originalName: "18mp",
    popularity: 108,
    codepoint: 0xe95a,
    categories: [ 1 ],
    tags: [ 152, 175, 176, 7, 47, 114, 115, 71, 50, 161, 14, 51, 52, 53, 19, 56, 57, 58, 23, 24, 59, 61, 119, 26, 27, 62, 177, 30, 65, 32, 35, 38, 40, 41, 68 ],
  ),
  "nineteen_mp": SymbolsMetadata(
    originalName: "19mp",
    popularity: 96,
    codepoint: 0xe95b,
    categories: [ 1 ],
    tags: [ 178, 179, 180, 47, 48, 114, 49, 71, 181, 50, 14, 133, 134, 52, 53, 117, 19, 56, 57, 58, 23, 24, 59, 141, 61, 182, 119, 26, 27, 62, 30, 76, 122, 32, 35, 38, 40 ],
  ),
  "one_k": SymbolsMetadata(
    originalName: "1k",
    popularity: 131,
    codepoint: 0xe95c,
    categories: [ 0 ],
    tags: [ 183, 184, 185, 186, 4, 5, 6, 7, 8, 9, 86, 10, 11, 12, 187, 13, 14, 188, 17, 18, 19, 20, 22, 23, 24, 189, 26, 27, 29, 30, 190, 31, 32, 33, 34, 35, 38, 39, 191, 40, 41, 42 ],
  ),
  "one_k_plus": SymbolsMetadata(
    originalName: "1k_plus",
    popularity: 101,
    codepoint: 0xe95d,
    categories: [ 0 ],
    tags: [ 192, 183, 184, 185, 193, 3, 4, 6, 7, 8, 194, 9, 86, 11, 12, 187, 13, 14, 195, 196, 197, 19, 20, 22, 198, 199, 24, 200, 201, 26, 27, 202, 203, 204, 30, 78, 31, 32, 33, 205, 34, 35, 38, 39, 40, 41, 42 ],
  ),
  "one_x_mobiledata": SymbolsMetadata(
    originalName: "1x_mobiledata",
    popularity: 328,
    codepoint: 0xefcd,
    categories: [ 4 ],
    tags: [ 206, 207, 4, 208, 209, 210, 8, 211, 212, 10, 213, 214, 11, 14, 215, 216, 19, 217, 218, 219, 220, 221, 222, 223, 224, 24, 225, 226, 227, 228, 229, 230, 231, 35, 38, 40, 232, 233, 234, 235 ],
  ),
  "one_x_mobiledata_badge": SymbolsMetadata(
    originalName: "1x_mobiledata_badge",
    popularity: 11,
    codepoint: 0xf7f1,
    categories: [ 4 ],
    tags: [ 206, 207, 4, 6, 208, 209, 8, 211, 212, 10, 214, 11, 236, 14, 237, 188, 215, 238, 19, 239, 217, 219, 240, 241, 221, 222, 223, 242, 24, 226, 227, 228, 229, 230, 231, 35, 38, 40, 232, 233, 234 ],
  ),
  "twenty_mp": SymbolsMetadata(
    originalName: "20mp",
    popularity: 97,
    codepoint: 0xe95e,
    categories: [ 1 ],
    tags: [ 243, 244, 245, 47, 48, 114, 115, 71, 50, 14, 246, 133, 134, 247, 52, 53, 54, 117, 19, 56, 57, 58, 24, 59, 73, 118, 61, 119, 150, 120, 26, 27, 62, 30, 248, 78, 122, 32, 35, 38, 40 ],
  ),
  "twenty_one_mp": SymbolsMetadata(
    originalName: "21mp",
    popularity: 87,
    codepoint: 0xe95f,
    categories: [ 1 ],
    tags: [ 249, 250, 251, 47, 48, 114, 115, 116, 71, 181, 50, 14, 133, 52, 53, 117, 19, 56, 57, 58, 23, 24, 59, 118, 61, 119, 26, 27, 62, 121, 30, 248, 78, 122, 65, 32, 35, 38, 40 ],
  ),
  "twenty_two_mp": SymbolsMetadata(
    originalName: "22mp",
    popularity: 117,
    codepoint: 0xe960,
    categories: [ 1 ],
    tags: [ 252, 253, 254, 47, 48, 115, 131, 71, 50, 14, 255, 246, 256, 257, 51, 52, 53, 117, 19, 56, 57, 58, 23, 24, 59, 118, 61, 119, 26, 27, 62, 30, 248, 122, 136, 32, 35, 38, 40 ],
  ),
  "twenty_three_mp": SymbolsMetadata(
    originalName: "23mp",
    popularity: 95,
    codepoint: 0xe961,
    categories: [ 1 ],
    tags: [ 258, 259, 260, 47, 114, 49, 71, 181, 50, 14, 256, 257, 51, 52, 53, 55, 117, 19, 56, 57, 58, 23, 24, 59, 141, 61, 150, 26, 27, 62, 30, 76, 78, 122, 32, 35, 38, 40 ],
  ),
  "twenty_four_fps_select": SymbolsMetadata(
    originalName: "24fps_select",
    popularity: 0,
    codepoint: 0xf3f2,
    categories: [ 1 ],
    tags: [ 261, 262, 263, 264, 265, 47, 266, 267, 268, 269, 50, 270, 271, 272, 273, 274, 275, 276, 277, 53, 278, 279, 280, 24, 281, 282, 283, 284, 285, 286, 103, 287, 288, 65, 231, 289, 290, 41, 291, 292, 293 ],
  ),
  "twenty_four_mp": SymbolsMetadata(
    originalName: "24mp",
    popularity: 124,
    codepoint: 0xe962,
    categories: [ 1 ],
    tags: [ 294, 295, 296, 47, 48, 114, 115, 116, 71, 181, 50, 14, 133, 52, 53, 117, 19, 56, 57, 58, 23, 24, 59, 141, 61, 182, 119, 26, 27, 62, 121, 30, 248, 122, 32, 35, 38, 40 ],
  ),
  "twod": SymbolsMetadata(
    originalName: "2d",
    popularity: 17,
    codepoint: 0xef37,
    categories: [ 0 ],
    tags: [ 297, 4, 298, 8, 299, 11, 300, 301, 12, 302, 303, 14, 304, 305, 16, 53, 18, 306, 19, 307, 23, 24, 25, 281, 308, 309, 288, 310, 311, 32, 312, 313, 35, 38, 314, 315, 316, 40, 317 ],
  ),
  "two_k": SymbolsMetadata(
    originalName: "2k",
    popularity: 109,
    codepoint: 0xe963,
    categories: [ 0 ],
    tags: [ 318, 319, 320, 321, 322, 323, 324, 4, 7, 8, 11, 12, 325, 14, 256, 257, 52, 19, 326, 327, 328, 24, 26, 27, 285, 329, 30, 330, 331, 310, 65, 32, 35, 38, 40, 332, 333, 41, 291, 334, 292 ],
  ),
  "two_k_plus": SymbolsMetadata(
    originalName: "2k_plus",
    popularity: 91,
    codepoint: 0xe964,
    categories: [ 0 ],
    tags: [ 192, 319, 324, 335, 336, 4, 7, 8, 11, 12, 337, 14, 274, 338, 339, 52, 53, 19, 340, 327, 341, 24, 202, 62, 30, 330, 32, 342, 35, 343, 38, 344, 345, 40, 332, 333, 346, 41 ],
  ),
  "two_mp": SymbolsMetadata(
    originalName: "2mp",
    popularity: 93,
    codepoint: 0xe965,
    categories: [ 1 ],
    tags: [ 81, 347, 348, 349, 7, 47, 350, 11, 88, 12, 14, 274, 53, 19, 56, 57, 327, 58, 23, 24, 59, 61, 26, 27, 62, 177, 30, 331, 65, 32, 351, 35, 38, 315, 40, 41, 352 ],
  ),
  "thirty_fps": SymbolsMetadata(
    originalName: "30fps",
    popularity: 164,
    codepoint: 0xefce,
    categories: [ 0 ],
    tags: [ 353, 354, 4, 264, 355, 47, 8, 267, 11, 356, 357, 270, 14, 273, 275, 276, 358, 359, 19, 218, 360, 278, 24, 283, 177, 361, 362, 231, 342, 35, 343, 38, 363, 40, 41, 364, 291, 334, 292 ],
  ),
  "thirty_fps_select": SymbolsMetadata(
    originalName: "30fps_select",
    popularity: 158,
    codepoint: 0xefcf,
    categories: [ 1 ],
    tags: [ 263, 353, 354, 365, 47, 266, 269, 50, 270, 273, 274, 275, 277, 53, 366, 367, 368, 280, 23, 24, 281, 282, 283, 369, 286, 177, 370, 103, 287, 288, 371, 65, 372, 231, 373, 374, 41, 292, 375 ],
  ),
  "threesixty": SymbolsMetadata(
    originalName: "360",
    popularity: 1838,
    codepoint: 0xe577,
    categories: [ 5 ],
    tags: [ 376, 377, 378, 379, 380, 381, 382, 47, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 317, 404, 405 ],
    rtlAutoMirrored: true,
  ),
  "threed": SymbolsMetadata(
    originalName: "3d",
    popularity: 0,
    codepoint: 0xed38,
    categories: [ 0 ],
    tags: [ 82, 406, 407, 4, 264, 379, 381, 7, 8, 408, 409, 11, 12, 270, 14, 304, 410, 389, 19, 411, 278, 24, 412, 75, 309, 330, 413, 32, 414, 35, 38, 415, 416, 40, 41, 317, 404, 417, 405 ],
  ),
  "threed_rotation": SymbolsMetadata(
    originalName: "3d_rotation",
    popularity: 1208,
    codepoint: 0xe84d,
    categories: [ 6 ],
    tags: [ 82, 406, 418, 407, 4, 264, 379, 380, 419, 381, 382, 47, 8, 383, 384, 269, 385, 11, 14, 19, 390, 411, 420, 421, 24, 422, 423, 424, 425, 426, 395, 396, 397, 399, 35, 38, 415, 416, 427, 402, 40, 317, 404, 417, 405 ],
  ),
  "three_g_mobiledata": SymbolsMetadata(
    originalName: "3g_mobiledata",
    popularity: 192,
    codepoint: 0xefd0,
    categories: [ 4 ],
    tags: [ 428, 4, 208, 210, 429, 8, 430, 212, 10, 213, 11, 14, 431, 215, 432, 19, 219, 433, 434, 221, 435, 222, 223, 436, 242, 24, 226, 437, 227, 228, 231, 35, 438, 439, 38, 440, 441, 40, 233, 234, 442 ],
  ),
  "three_g_mobiledata_badge": SymbolsMetadata(
    originalName: "3g_mobiledata_badge",
    popularity: 2,
    codepoint: 0xf7f0,
    categories: [ 4 ],
    tags: [ 428, 4, 6, 208, 210, 429, 8, 443, 430, 213, 444, 445, 11, 14, 16, 215, 216, 19, 219, 433, 434, 221, 222, 223, 242, 24, 226, 77, 227, 228, 446, 231, 32, 35, 447, 38, 448, 40, 233, 234, 442 ],
  ),
  "three_k": SymbolsMetadata(
    originalName: "3k",
    popularity: 86,
    codepoint: 0xe966,
    categories: [ 0 ],
    tags: [ 318, 449, 450, 324, 451, 452, 453, 454, 455, 4, 8, 11, 12, 325, 14, 256, 257, 52, 19, 327, 24, 26, 27, 285, 329, 62, 30, 330, 331, 310, 65, 35, 38, 456, 457, 40, 332, 333, 41, 334, 68, 292 ],
  ),
  "three_k_plus": SymbolsMetadata(
    originalName: "3k_plus",
    popularity: 86,
    codepoint: 0xe967,
    categories: [ 0 ],
    tags: [ 192, 451, 453, 454, 186, 4, 458, 6, 7, 8, 9, 86, 10, 11, 12, 14, 274, 339, 17, 19, 459, 22, 341, 23, 24, 26, 27, 202, 29, 30, 78, 32, 460, 461, 35, 38, 39, 462, 456, 191, 40, 463, 41 ],
  ),
  "three_mp": SymbolsMetadata(
    originalName: "3mp",
    popularity: 95,
    codepoint: 0xe968,
    categories: [ 1 ],
    tags: [ 82, 464, 465, 7, 47, 49, 11, 71, 356, 14, 52, 16, 53, 54, 19, 466, 56, 57, 58, 23, 24, 59, 73, 61, 26, 27, 62, 177, 30, 76, 65, 32, 35, 38, 40, 41, 292 ],
  ),
  "three_p": SymbolsMetadata(
    originalName: "3p",
    popularity: 1279,
    codepoint: 0xefd1,
    categories: [ 7 ],
    tags: [ 82, 467, 468, 469, 470, 471, 472, 473, 474, 443, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 135, 485, 223, 486, 487, 488, 489, 490, 491, 31, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501 ],
  ),
  "four_g_mobiledata": SymbolsMetadata(
    originalName: "4g_mobiledata",
    popularity: 335,
    codepoint: 0xefd2,
    categories: [ 4 ],
    tags: [ 502, 503, 4, 504, 208, 210, 8, 443, 211, 212, 213, 445, 11, 14, 505, 506, 215, 19, 507, 219, 433, 434, 221, 222, 223, 242, 24, 226, 508, 227, 228, 446, 231, 35, 447, 38, 40, 233, 234 ],
  ),
  "four_g_mobiledata_badge": SymbolsMetadata(
    originalName: "4g_mobiledata_badge",
    popularity: 3,
    codepoint: 0xf7ef,
    categories: [ 4 ],
    tags: [ 502, 503, 4, 6, 7, 208, 210, 8, 443, 211, 213, 445, 11, 14, 505, 16, 215, 432, 19, 507, 219, 433, 434, 221, 222, 223, 24, 226, 77, 227, 446, 231, 32, 35, 447, 38, 40, 233, 234, 235 ],
  ),
  "four_g_plus_mobiledata": SymbolsMetadata(
    originalName: "4g_plus_mobiledata",
    popularity: 222,
    codepoint: 0xefd3,
    categories: [ 4 ],
    tags: [ 502, 509, 4, 208, 210, 429, 8, 212, 213, 510, 11, 511, 512, 513, 14, 359, 514, 215, 216, 19, 507, 515, 219, 433, 434, 221, 516, 222, 223, 517, 24, 226, 437, 202, 227, 228, 231, 35, 38, 40, 233, 234, 442 ],
  ),
  "four_k": SymbolsMetadata(
    originalName: "4k",
    popularity: 357,
    codepoint: 0xe072,
    categories: [ 0 ],
    tags: [ 450, 518, 519, 520, 455, 521, 4, 7, 8, 11, 356, 12, 337, 270, 14, 522, 257, 51, 52, 19, 367, 278, 24, 26, 27, 283, 30, 330, 32, 342, 35, 343, 38, 344, 40, 332, 523, 333, 524, 41, 334, 68 ],
  ),
  "four_k_plus": SymbolsMetadata(
    originalName: "4k_plus",
    popularity: 159,
    codepoint: 0xe969,
    categories: [ 0 ],
    tags: [ 192, 518, 520, 455, 521, 525, 526, 4, 527, 8, 11, 12, 528, 529, 270, 14, 522, 257, 51, 52, 530, 19, 367, 278, 24, 281, 26, 27, 202, 531, 30, 330, 310, 532, 35, 38, 40, 332, 523, 333, 533, 41, 334 ],
  ),
  "four_mp": SymbolsMetadata(
    originalName: "4mp",
    popularity: 87,
    codepoint: 0xe96a,
    categories: [ 1 ],
    tags: [ 534, 535, 536, 537, 7, 47, 114, 49, 11, 14, 538, 539, 256, 257, 52, 53, 54, 55, 19, 56, 57, 58, 24, 59, 61, 26, 27, 62, 177, 30, 65, 32, 35, 38, 40, 41, 334, 540, 68, 292 ],
  ),
  "five_0mp": SymbolsMetadata(
    originalName: "50mp",
    popularity: 27,
    codepoint: 0xf6f3,
    categories: [ 1 ],
    tags: [ 541, 542, 543, 47, 114, 115, 116, 544, 545, 11, 71, 529, 14, 51, 52, 53, 54, 19, 56, 57, 58, 23, 24, 281, 59, 61, 119, 26, 27, 62, 121, 30, 78, 122, 65, 136, 32, 35, 38, 40 ],
  ),
  "five_g": SymbolsMetadata(
    originalName: "5g",
    popularity: 594,
    codepoint: 0xef38,
    categories: [ 4 ],
    tags: [ 546, 547, 548, 4, 504, 208, 210, 8, 443, 211, 212, 10, 11, 88, 549, 14, 506, 215, 432, 19, 219, 433, 221, 223, 550, 24, 226, 227, 228, 231, 35, 551, 438, 439, 38, 40, 233, 234, 442 ],
  ),
  "five_g_mobiledata_badge": SymbolsMetadata(
    originalName: "5g_mobiledata_badge",
    popularity: 12,
    codepoint: 0xf7ee,
    categories: [ 4 ],
    tags: [ 546, 552, 4, 6, 208, 210, 8, 443, 211, 212, 10, 213, 444, 11, 14, 359, 16, 188, 215, 432, 19, 219, 433, 241, 221, 435, 223, 550, 24, 226, 227, 228, 231, 553, 35, 551, 438, 38, 40, 233, 234, 235 ],
  ),
  "five_k": SymbolsMetadata(
    originalName: "5k",
    popularity: 98,
    codepoint: 0xe96b,
    categories: [ 0 ],
    tags: [ 554, 555, 556, 557, 558, 559, 4, 349, 7, 8, 11, 12, 325, 560, 14, 274, 256, 257, 52, 19, 327, 24, 281, 26, 27, 285, 30, 330, 331, 310, 32, 35, 38, 40, 332, 333, 41, 334, 68, 292 ],
  ),
  "five_k_plus": SymbolsMetadata(
    originalName: "5k_plus",
    popularity: 89,
    codepoint: 0xe96c,
    categories: [ 0 ],
    tags: [ 192, 554, 555, 556, 561, 4, 7, 8, 9, 11, 12, 562, 14, 274, 339, 51, 52, 19, 340, 327, 341, 23, 24, 26, 27, 202, 62, 29, 30, 330, 32, 35, 343, 38, 563, 344, 40, 332, 333, 41, 68 ],
  ),
  "five_mp": SymbolsMetadata(
    originalName: "5mp",
    popularity: 97,
    codepoint: 0xe96d,
    categories: [ 1 ],
    tags: [ 564, 565, 566, 47, 114, 115, 11, 14, 52, 53, 54, 19, 56, 57, 58, 23, 24, 59, 73, 61, 26, 27, 285, 329, 62, 177, 30, 248, 310, 65, 32, 35, 38, 40, 41, 68, 567 ],
  ),
  "sixty_fps": SymbolsMetadata(
    originalName: "60fps",
    popularity: 191,
    codepoint: 0xefd4,
    categories: [ 0 ],
    tags: [ 568, 569, 264, 47, 11, 325, 270, 273, 275, 276, 358, 338, 570, 571, 51, 359, 326, 420, 23, 24, 25, 189, 283, 361, 572, 573, 231, 35, 41, 574, 291, 334, 292 ],
  ),
  "sixty_fps_select": SymbolsMetadata(
    originalName: "60fps_select",
    popularity: 163,
    codepoint: 0xefd5,
    categories: [ 1 ],
    tags: [ 568, 569, 47, 575, 50, 273, 274, 275, 358, 277, 570, 51, 576, 359, 420, 24, 281, 282, 189, 283, 284, 286, 361, 103, 287, 288, 371, 310, 65, 572, 577, 573, 231, 41, 578, 579, 334, 292 ],
  ),
  "six_ft_apart": SymbolsMetadata(
    originalName: "6_ft_apart",
    popularity: 436,
    codepoint: 0xf21e,
    categories: [ 3 ],
    tags: [ 580, 581, 582, 583, 419, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594, 595, 483, 596, 597, 598, 488, 489, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611 ],
  ),
  "six_k": SymbolsMetadata(
    originalName: "6k",
    popularity: 92,
    codepoint: 0xe96e,
    categories: [ 0 ],
    tags: [ 455, 612, 613, 614, 615, 616, 617, 4, 7, 8, 11, 12, 325, 337, 270, 14, 257, 51, 52, 19, 618, 278, 328, 24, 26, 27, 62, 30, 331, 32, 342, 35, 38, 40, 332, 523, 333, 346, 41, 291, 334, 68, 292 ],
  ),
  "six_k_plus": SymbolsMetadata(
    originalName: "6k_plus",
    popularity: 87,
    codepoint: 0xe96f,
    categories: [ 0 ],
    tags: [ 192, 612, 613, 614, 619, 4, 349, 8, 11, 12, 325, 14, 274, 339, 257, 52, 17, 19, 327, 618, 341, 24, 26, 27, 202, 30, 330, 331, 620, 621, 622, 32, 35, 38, 40, 332, 523, 41, 334, 68, 292 ],
  ),
  "six_mp": SymbolsMetadata(
    originalName: "6mp",
    popularity: 92,
    codepoint: 0xe970,
    categories: [ 1 ],
    tags: [ 580, 623, 624, 625, 47, 114, 116, 11, 71, 181, 356, 14, 51, 52, 53, 55, 19, 367, 56, 57, 58, 23, 24, 141, 61, 119, 26, 27, 62, 121, 30, 122, 65, 32, 35, 38, 40, 41 ],
  ),
  "seven_k": SymbolsMetadata(
    originalName: "7k",
    popularity: 106,
    codepoint: 0xe971,
    categories: [ 0 ],
    tags: [ 626, 627, 628, 4, 7, 8, 11, 12, 325, 270, 14, 256, 257, 17, 19, 278, 328, 24, 26, 27, 285, 329, 62, 30, 330, 331, 310, 65, 629, 630, 32, 35, 38, 40, 332, 333, 41, 291, 334, 68 ],
  ),
  "seven_k_plus": SymbolsMetadata(
    originalName: "7k_plus",
    popularity: 86,
    codepoint: 0xe972,
    categories: [ 0 ],
    tags: [ 192, 626, 627, 628, 631, 632, 4, 458, 6, 349, 7, 8, 9, 11, 12, 14, 274, 339, 188, 17, 633, 18, 19, 634, 22, 341, 23, 24, 26, 27, 202, 29, 30, 330, 630, 32, 461, 35, 38, 462, 191, 40, 523, 635, 41, 334 ],
  ),
  "seven_mp": SymbolsMetadata(
    originalName: "7mp",
    popularity: 96,
    codepoint: 0xe973,
    categories: [ 1 ],
    tags: [ 636, 637, 638, 639, 47, 48, 49, 116, 11, 71, 14, 52, 53, 54, 55, 19, 367, 56, 57, 58, 23, 640, 24, 73, 141, 61, 26, 27, 62, 177, 30, 122, 65, 641, 32, 35, 38, 40, 41, 334, 68 ],
  ),
  "eight_k": SymbolsMetadata(
    originalName: "8k",
    popularity: 150,
    codepoint: 0xe974,
    categories: [ 0 ],
    tags: [ 642, 643, 644, 617, 645, 4, 8, 544, 545, 11, 356, 12, 337, 14, 256, 257, 52, 53, 19, 367, 327, 24, 119, 26, 27, 30, 330, 646, 342, 647, 35, 343, 38, 344, 40, 332, 523, 333, 346, 41, 648, 334 ],
  ),
  "eight_k_plus": SymbolsMetadata(
    originalName: "8k_plus",
    popularity: 112,
    codepoint: 0xe975,
    categories: [ 0 ],
    tags: [ 192, 626, 644, 617, 649, 650, 651, 645, 652, 4, 8, 11, 12, 653, 654, 14, 274, 257, 51, 52, 655, 19, 367, 24, 656, 26, 27, 202, 531, 30, 64, 330, 331, 65, 32, 35, 38, 40, 332, 523, 41, 657, 334, 68, 292 ],
  ),
  "eight_mp": SymbolsMetadata(
    originalName: "8mp",
    popularity: 93,
    codepoint: 0xe976,
    categories: [ 1 ],
    tags: [ 658, 659, 660, 47, 115, 116, 11, 71, 661, 529, 14, 51, 52, 53, 54, 19, 662, 56, 57, 58, 663, 24, 281, 59, 61, 26, 27, 62, 177, 30, 248, 78, 122, 65, 32, 35, 38, 40, 41 ],
  ),
  "nine_k": SymbolsMetadata(
    originalName: "9k",
    popularity: 99,
    codepoint: 0xe977,
    categories: [ 0 ],
    tags: [ 664, 665, 666, 667, 4, 8, 10, 668, 11, 12, 337, 14, 51, 52, 17, 669, 19, 367, 670, 671, 672, 24, 26, 27, 62, 30, 330, 673, 674, 342, 35, 38, 40, 332, 333, 346, 41, 334, 68 ],
  ),
  "nine_k_plus": SymbolsMetadata(
    originalName: "9k_plus",
    popularity: 102,
    codepoint: 0xe978,
    categories: [ 0 ],
    tags: [ 192, 675, 665, 666, 667, 676, 4, 7, 8, 9, 11, 12, 337, 14, 274, 339, 52, 17, 19, 367, 340, 341, 23, 24, 26, 27, 283, 202, 29, 30, 330, 32, 342, 35, 38, 462, 40, 332, 333, 41, 334, 68 ],
  ),
  "nine_mp": SymbolsMetadata(
    originalName: "9mp",
    popularity: 102,
    codepoint: 0xe979,
    categories: [ 1 ],
    tags: [ 677, 678, 679, 680, 7, 47, 114, 49, 11, 71, 681, 14, 51, 52, 53, 54, 55, 19, 56, 57, 58, 682, 23, 683, 24, 59, 141, 61, 119, 26, 27, 62, 30, 65, 32, 35, 38, 40 ],
  ),
  "abc": SymbolsMetadata(
    popularity: 1486,
    codepoint: 0xeb94,
    categories: [ 2 ],
    tags: [ 684, 685, 186, 686, 687, 4, 688, 689, 690, 691, 8, 692, 693, 694, 695, 696, 14, 697, 698, 19, 485, 699, 700, 701, 35, 38, 40, 702, 703, 704 ],
  ),
  "ac_unit": SymbolsMetadata(
    popularity: 3115,
    codepoint: 0xeb3b,
    categories: [ 8 ],
    tags: [ 705, 706, 707, 708, 709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 725, 726, 727, 728, 729, 635, 730, 731, 732 ],
  ),
  "accessibility": SymbolsMetadata(
    popularity: 1937,
    codepoint: 0xe84e,
    categories: [ 6 ],
    tags: [ 733, 734, 468, 735, 736, 737, 738, 739, 740, 584, 741, 742, 743, 744, 482, 483, 745, 746, 747, 748, 656, 488, 489, 329, 490, 749, 65, 750, 495, 751, 752, 501, 753 ],
  ),
  "accessibility_new": SymbolsMetadata(
    popularity: 3492,
    codepoint: 0xe92c,
    categories: [ 6 ],
    tags: [ 754, 755, 733, 756, 734, 735, 757, 738, 758, 584, 741, 744, 482, 483, 745, 759, 746, 760, 761, 762, 763, 764, 765, 488, 489, 749, 750, 495, 752, 501, 753, 766 ],
  ),
  "accessible": SymbolsMetadata(
    popularity: 2272,
    codepoint: 0xe914,
    categories: [ 6 ],
    tags: [ 755, 733, 734, 735, 738, 758, 739, 740, 584, 383, 741, 767, 744, 768, 482, 483, 769, 747, 760, 770, 488, 489, 771, 772, 495, 752, 501, 753, 773, 774 ],
  ),
  "accessible_forward": SymbolsMetadata(
    popularity: 1130,
    codepoint: 0xe934,
    categories: [ 6 ],
    tags: [ 755, 733, 734, 775, 758, 584, 383, 776, 388, 741, 767, 777, 744, 768, 482, 483, 760, 770, 778, 779, 421, 780, 488, 489, 781, 28, 782, 501, 773, 774 ],
  ),
  "accessible_menu": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf34e,
    categories: [ 2 ],
    tags: [ 783, 733, 734, 784, 468, 738, 584, 785, 132, 741, 786, 787, 483, 760, 135, 788, 789, 421, 764, 656, 488, 489, 790, 329, 490, 65, 791, 752, 501, 792, 766 ],
  ),
  "account_balance": SymbolsMetadata(
    popularity: 11394,
    codepoint: 0xe84f,
    categories: [ 9 ],
    tags: [ 468, 793, 794, 795, 796, 797, 798, 799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826 ],
  ),
  "account_balance_wallet": SymbolsMetadata(
    popularity: 10219,
    codepoint: 0xe850,
    categories: [ 9 ],
    tags: [ 468, 793, 794, 795, 796, 797, 827, 828, 799, 800, 383, 801, 803, 805, 829, 806, 830, 831, 807, 832, 833, 834, 808, 835, 811, 818, 819, 836, 820, 821, 837, 838, 839, 840, 75, 824, 841, 32, 842, 843 ],
  ),
  "account_box": SymbolsMetadata(
    popularity: 5233,
    codepoint: 0xe851,
    categories: [ 6 ],
    tags: [ 468, 844, 845, 470, 7, 846, 383, 475, 847, 848, 479, 849, 483, 850, 53, 851, 852, 853, 488, 489, 790, 59, 119, 854, 490, 855, 856, 78, 857, 32, 858, 501, 859, 860 ],
  ),
  "account_child": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xe852,
    categories: [ 6 ],
    tags: [ 468, 845, 861, 584, 862, 863, 864, 865, 383, 866, 867, 868, 869, 483, 870, 871, 872, 873, 874, 875, 876, 488, 489, 490, 877, 878, 501, 879, 880 ],
  ),
  "account_child_invert": SymbolsMetadata(
    popularity: 64,
    codepoint: 0xe659,
    categories: [ 6 ],
    tags: [ 755, 468, 845, 470, 584, 862, 863, 864, 865, 866, 867, 868, 869, 483, 881, 870, 871, 852, 873, 874, 875, 876, 488, 489, 490, 877, 882, 501, 879, 883, 880 ],
  ),
  "account_circle": SymbolsMetadata(
    popularity: 67223,
    codepoint: 0xe853,
    categories: [ 6 ],
    tags: [ 468, 884, 845, 470, 383, 475, 479, 483, 850, 885, 135, 852, 853, 886, 488, 489, 887, 790, 888, 854, 329, 490, 855, 889, 65, 857, 858, 501, 890, 891, 860 ],
  ),
  "account_circle_off": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf7b3,
    categories: [ 6 ],
    tags: [ 892, 468, 893, 470, 894, 895, 383, 896, 897, 767, 898, 479, 899, 900, 483, 901, 902, 903, 904, 905, 906, 907, 908, 909, 488, 489, 490, 910, 911, 912, 913, 914, 858, 915, 501, 916 ],
  ),
  "account_tree": SymbolsMetadata(
    popularity: 7298,
    codepoint: 0xe97a,
    categories: [ 9 ],
    tags: [ 468, 917, 5, 918, 919, 920, 862, 921, 922, 211, 10, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 597, 937, 938, 223, 939, 940, 941, 874, 942, 943, 32, 944, 33, 945, 946, 947, 948 ],
  ),
  "action_key": SymbolsMetadata(
    popularity: 109,
    codepoint: 0xf502,
    categories: [ 2 ],
    tags: [ 755, 949, 950, 951, 952, 953, 954, 694, 445, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 246, 965, 966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 981, 982, 983, 984, 985, 986 ],
  ),
  "activity_zone": SymbolsMetadata(
    popularity: 407,
    codepoint: 0xe1e6,
    categories: [ 10 ],
    tags: [ 987, 988, 989, 990, 991, 992, 993, 994, 921, 211, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 223, 1005, 939, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 371, 32, 1013 ],
  ),
  "acute": SymbolsMetadata(
    popularity: 213,
    codepoint: 0xe4cb,
    categories: [ 2 ],
    tags: [ 989, 1014, 469, 1015, 383, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 595, 1023, 1024, 1025, 486, 1026, 28, 1027, 1028, 1029, 1030, 1031, 1032, 231, 441, 289, 1033, 947, 1034 ],
  ),
  "ad": SymbolsMetadata(
    popularity: 83,
    codepoint: 0xe65a,
    categories: [ 6 ],
    tags: [ 1035, 1036, 1037, 469, 1038, 1039, 1040, 1041, 1042, 1043, 12, 274, 1044, 215, 1045, 367, 486, 1046, 1047, 1048, 1049, 1050, 75, 190, 1051, 32, 1052, 1053, 1054 ],
  ),
  "ad_group": SymbolsMetadata(
    popularity: 99,
    codepoint: 0xe65b,
    categories: [ 6 ],
    tags: [ 1035, 1055, 526, 1056, 1037, 1057, 1058, 1059, 1060, 1039, 1040, 1061, 921, 1062, 1063, 930, 215, 1064, 1065, 1066, 935, 1045, 1067, 1068, 1050, 75, 32, 107, 1069, 1070, 1071, 1053, 1054 ],
  ),
  "ad_group_off": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xeae5,
    categories: [ 6 ],
    tags: [ 1072, 1035, 1055, 1037, 1073, 1074, 894, 1040, 895, 1075, 896, 1076, 897, 1077, 767, 930, 1078, 900, 1045, 1079, 1080, 907, 1081, 1082, 1050, 75, 911, 65, 914, 32, 1083, 1084 ],
  ),
  "ad_off": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf7b2,
    categories: [ 6 ],
    tags: [ 1035, 1085, 1086, 1087, 1088, 1089, 1037, 1090, 1091, 1092, 1038, 1093, 1094, 1039, 895, 1095, 1096, 1097, 767, 898, 899, 1098, 1099, 215, 1079, 1100, 1101, 907, 908, 909, 1102, 1103, 914, 32, 1104, 1105, 1106, 1107, 1108, 1053, 1054 ],
  ),
  "ad_units": SymbolsMetadata(
    popularity: 791,
    codepoint: 0xef39,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1035, 1111, 1112, 1073, 1038, 1040, 1113, 208, 472, 443, 1042, 897, 445, 1043, 696, 965, 1114, 1045, 485, 1115, 1116, 219, 1117, 1118, 1119, 486, 1120, 226, 75, 911, 1121, 1122, 447, 38, 1123, 1124, 1125 ],
  ),
  "adaptive_audio_mic": SymbolsMetadata(
    popularity: 125,
    codepoint: 0xf4cc,
    categories: [ 0 ],
    tags: [ 468, 1126, 1127, 1128, 1129, 1130, 1131, 1132, 1133, 1134, 443, 1135, 445, 1136, 479, 867, 1137, 1138, 930, 1139, 1140, 483, 1141, 966, 1142, 969, 1143, 1144, 1145, 1146, 1147, 223, 1148, 1149, 1150, 488, 489, 1151, 1152, 490, 1153, 121, 1154, 177, 1155, 607, 1156, 492, 1157, 496, 946, 1158, 501, 1159, 1160, 1161, 1162 ],
  ),
  "adaptive_audio_mic_off": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf4cb,
    categories: [ 0 ],
    tags: [ 468, 1126, 1127, 1163, 1129, 1130, 1133, 1134, 443, 1135, 1136, 1077, 767, 479, 867, 1137, 1138, 930, 1139, 1140, 483, 1141, 969, 1144, 1145, 1146, 1147, 1164, 1165, 223, 1166, 1167, 1168, 1169, 1148, 907, 488, 489, 1151, 490, 1153, 121, 1154, 1170, 1171, 607, 1156, 1157, 1172, 493, 496, 946, 501, 1159, 1160, 1173, 1161 ],
  ),
  "adb": SymbolsMetadata(
    popularity: 857,
    codepoint: 0xe60e,
    categories: [ 4 ],
    tags: [ 1174, 1175, 1176, 1177, 1178, 1179, 1180, 1181, 584, 1182, 1183, 1184, 1185, 1186, 1187, 445, 1188, 1189, 1190, 219, 1191, 1192, 1193, 1194, 1195, 446, 1196, 447, 551 ],
  ),
  "add": SymbolsMetadata(
    popularity: 71989,
    codepoint: 0xe145,
    categories: [ 2 ],
    tags: [ 192, 526, 1197, 1057, 1198, 1199, 1200, 1061, 1201, 1202, 787, 1203, 1204, 1205, 1206, 1207, 1044, 1208, 1209, 1064, 1210, 763, 1211, 202, 1212, 1213, 461, 35, 1214, 1215 ],
  ),
  "add_2": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf3dd,
    categories: [ 2 ],
    tags: [ 192, 526, 1197, 1057, 1198, 1058, 1061, 1201, 1202, 1216, 787, 1204, 1205, 1206, 1207, 1217, 1044, 1218, 1209, 1064, 1210, 763, 1211, 202, 1212, 1213, 461, 35, 1214, 1215 ],
  ),
  "add_a_photo": SymbolsMetadata(
    popularity: 6301,
    codepoint: 0xe439,
    categories: [ 1 ],
    tags: [ 192, 1219, 526, 1220, 1221, 1222, 1223, 47, 48, 116, 383, 1042, 1201, 53, 1224, 966, 1044, 126, 367, 763, 59, 60, 61, 119, 1225, 202, 1212, 75, 32, 35, 346 ],
  ),
  "add_ad": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xe72a,
    categories: [ 6 ],
    tags: [ 192, 1035, 526, 1226, 1227, 1228, 1037, 1229, 1230, 1039, 1201, 1231, 1232, 1233, 1206, 1044, 215, 1045, 763, 1234, 1235, 1236, 1237, 202, 1238, 1050, 1239, 1240, 1241, 1053, 1054 ],
  ),
  "add_alert": SymbolsMetadata(
    popularity: 1072,
    codepoint: 0xe003,
    categories: [ 6 ],
    tags: [ 192, 1242, 526, 1243, 1244, 469, 1245, 1246, 1247, 1248, 1201, 1249, 1250, 1251, 763, 1252, 486, 1253, 1120, 1254, 202, 1255, 1256, 1030, 1257, 227, 857, 1156, 1258, 1259, 35, 1260, 1034, 1261 ],
  ),
  "add_box": SymbolsMetadata(
    popularity: 10838,
    codepoint: 0xe146,
    categories: [ 2 ],
    tags: [ 526, 1262, 1263, 1264, 1265, 1266, 1267, 1057, 1268, 7, 1269, 1201, 1270, 1271, 1206, 1272, 1044, 1273, 763, 1274, 1275, 1276, 202, 1277, 1212, 1278, 32, 35 ],
  ),
  "add_business": SymbolsMetadata(
    popularity: 2085,
    codepoint: 0xe729,
    categories: [ 9 ],
    tags: [ 192, 526, 1279, 1280, 1281, 1282, 1283, 797, 798, 1284, 799, 800, 801, 803, 1285, 1201, 1286, 1287, 1288, 1289, 805, 806, 807, 1290, 1291, 1292, 818, 763, 1293, 1294, 1295, 819, 940, 820, 821, 202, 1212, 1296, 1297, 841, 1298, 1299, 35, 1300 ],
  ),
  "add_call": SymbolsMetadata(
    popularity: 827,
    codepoint: 0xe0e8,
    categories: [ 7 ],
    tags: [ 192, 526, 1301, 1302, 1303, 1304, 1133, 1113, 443, 1305, 1135, 1306, 475, 1307, 445, 1308, 1309, 965, 1206, 1310, 1311, 1312, 1313, 1314, 219, 763, 1315, 226, 1316, 202, 1317, 1318, 1319, 35, 1320 ],
  ),
  "add_card": SymbolsMetadata(
    popularity: 2047,
    codepoint: 0xeb86,
    categories: [ 9 ],
    tags: [ 192, 526, 1321, 1322, 1323, 1223, 1324, 796, 797, 1325, 799, 800, 1326, 801, 803, 1327, 805, 829, 1328, 806, 830, 807, 1329, 808, 1330, 1331, 1332, 818, 763, 1333, 1334, 819, 820, 821, 1335, 1336, 202, 1212, 1337, 75, 1338, 841, 35 ],
  ),
  "add_chart": SymbolsMetadata(
    popularity: 927,
    codepoint: 0xe97b,
    categories: [ 9 ],
    tags: [ 192, 526, 1339, 1340, 1341, 1342, 5, 1343, 1344, 1345, 365, 920, 1201, 1346, 10, 924, 1347, 929, 933, 1044, 1348, 597, 937, 763, 1349, 1350, 202, 1351, 1352, 1353, 1354, 33, 35, 947, 1355 ],
  ),
  "add_circle": SymbolsMetadata(
    popularity: 40861,
    codepoint: 0xe147,
    categories: [ 2 ],
    tags: [ 192, 526, 1356, 1357, 1057, 1058, 298, 383, 1358, 1359, 269, 1360, 86, 1201, 1271, 787, 1206, 1207, 1044, 1064, 1210, 789, 763, 1361, 202, 1362, 1363, 1213, 461, 1364 ],
  ),
  "add_column_left": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf425,
    categories: [ 12 ],
    tags: [ 192, 526, 1365, 1366, 1367, 1368, 1369, 802, 1042, 1201, 299, 1370, 1347, 1371, 1372, 246, 1044, 1373, 1374, 306, 1375, 763, 1211, 98, 1068, 202, 1376, 1377, 1378, 1379, 35, 1380, 1381, 317, 1053, 1054 ],
  ),
  "add_column_right": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf424,
    categories: [ 12 ],
    tags: [ 192, 526, 1365, 1382, 1383, 1057, 1368, 1384, 802, 299, 787, 1385, 1386, 1372, 246, 1387, 1207, 1388, 1389, 1044, 1373, 1390, 306, 1391, 763, 1392, 1393, 1211, 202, 1394, 1395, 1396, 1376, 1377, 1397, 1379, 35, 1380, 1398, 1381, 317, 1053 ],
  ),
  "add_comment": SymbolsMetadata(
    popularity: 2128,
    codepoint: 0xe266,
    categories: [ 7 ],
    tags: [ 192, 526, 1399, 1400, 471, 472, 1401, 473, 474, 443, 476, 1402, 1403, 1202, 477, 480, 481, 1404, 1405, 485, 1406, 763, 1407, 1408, 202, 1212, 1409, 1410, 1411, 77, 31, 493, 494, 1412, 35 ],
  ),
  "add_diamond": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf49c,
    categories: [ 11 ],
    tags: [ 192, 1413, 526, 1414, 1264, 1357, 1057, 1201, 1415, 1271, 1202, 1416, 1417, 787, 1418, 1204, 1206, 1207, 1044, 1419, 763, 1420, 1211, 202, 1212, 1421, 1422, 1423, 32, 35, 1424 ],
  ),
  "add_home": SymbolsMetadata(
    popularity: 383,
    codepoint: 0xf8eb,
    categories: [ 5 ],
    tags: [ 526, 1425, 1426, 1427, 1428, 1429, 798, 1430, 1431, 1432, 1433, 1434, 867, 999, 1435, 1436, 1001, 1437, 1438, 1439, 1440, 202, 1441, 1442, 1443, 1444, 1445, 1446, 1447 ],
  ),
  "add_home_work": SymbolsMetadata(
    popularity: 323,
    codepoint: 0xf8ed,
    categories: [ 5 ],
    tags: [ 526, 1448, 1426, 1449, 1450, 798, 1201, 1451, 1430, 1431, 1452, 999, 1453, 1435, 763, 1454, 1437, 1438, 1455, 1456, 202, 1457, 1441, 1442, 1458, 1446, 1459, 1460 ],
  ),
  "add_link": SymbolsMetadata(
    popularity: 1421,
    codepoint: 0xe178,
    categories: [ 12 ],
    tags: [ 526, 1461, 1462, 1463, 1464, 1058, 1465, 1466, 1467, 1468, 1469, 921, 211, 1470, 1471, 1472, 1473, 1474, 1064, 935, 1475, 763, 1476, 1477, 202, 1478, 35, 1479, 1480, 1053 ],
  ),
  "add_location": SymbolsMetadata(
    popularity: 2775,
    codepoint: 0xe567,
    categories: [ 5 ],
    tags: [ 192, 526, 1481, 1482, 1429, 1483, 1484, 388, 955, 1485, 958, 960, 1486, 1487, 1488, 1489, 1001, 1002, 1490, 1491, 21, 421, 763, 1492, 1493, 1494, 1495, 202, 1363, 1496, 1497, 1498, 1083, 35, 947 ],
  ),
  "add_location_alt": SymbolsMetadata(
    popularity: 1684,
    codepoint: 0xef3a,
    categories: [ 5 ],
    tags: [ 192, 526, 1481, 1429, 1499, 1201, 1484, 388, 955, 1500, 958, 960, 1486, 1487, 1488, 1501, 1489, 1001, 1002, 1490, 21, 421, 763, 1492, 1493, 1494, 1495, 202, 1502, 1363, 1496, 1503, 1083, 35, 1504 ],
  ),
  "add_moderator": SymbolsMetadata(
    popularity: 608,
    codepoint: 0xe97d,
    categories: [ 13 ],
    tags: [ 192, 755, 526, 1505, 1506, 1507, 1508, 1509, 6, 1510, 194, 269, 481, 1511, 930, 936, 1512, 763, 1513, 819, 1514, 202, 1515, 1516, 1517, 1518, 1519, 1520, 1521, 1011, 1522, 31, 35, 946, 501, 1523 ],
  ),
  "add_notes": SymbolsMetadata(
    popularity: 80,
    codepoint: 0xe091,
    categories: [ 12 ],
    tags: [ 192, 526, 1341, 1524, 1228, 693, 1525, 1201, 1526, 1527, 1232, 1528, 1347, 696, 1529, 1530, 366, 92, 763, 1350, 1531, 1236, 1532, 1533, 1534, 1535, 202, 1212, 107, 38, 1536, 1537 ],
  ),
  "add_photo_alternate": SymbolsMetadata(
    popularity: 4099,
    codepoint: 0xe43e,
    categories: [ 1 ],
    tags: [ 192, 526, 1220, 1221, 1222, 1538, 1539, 1058, 1042, 1540, 1201, 1541, 53, 1542, 966, 1044, 1543, 367, 1544, 1545, 763, 59, 61, 119, 202, 1212, 1546, 32, 35, 441, 346 ],
  ),
  "add_reaction": SymbolsMetadata(
    popularity: 2491,
    codepoint: 0xe1d3,
    categories: [ 3 ],
    tags: [ 192, 526, 1547, 1548, 1549, 472, 383, 473, 443, 478, 1550, 1551, 1552, 1553, 1554, 479, 480, 1555, 481, 1556, 1557, 1558, 16, 1559, 1044, 1560, 1561, 763, 1562, 489, 1563, 202, 1213, 102, 1564, 1565, 1566, 1567, 1568, 1569, 607, 31, 495, 1570, 35 ],
  ),
  "add_road": SymbolsMetadata(
    popularity: 745,
    codepoint: 0xef3b,
    categories: [ 5 ],
    tags: [ 192, 526, 1571, 1572, 1573, 1574, 1575, 1576, 1202, 1577, 1484, 388, 1578, 1579, 1488, 1580, 1581, 366, 1002, 1490, 421, 763, 1582, 1583, 1584, 1585, 1586, 202, 1212, 1587, 1588, 1083, 1589, 35, 441, 1590, 1591, 1592 ],
  ),
  "add_row_above": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf423,
    categories: [ 12 ],
    tags: [ 192, 1593, 526, 1594, 1595, 1596, 1368, 802, 1201, 1202, 10, 299, 1597, 1598, 1372, 246, 1044, 1599, 1600, 1601, 306, 1602, 92, 763, 1211, 202, 1212, 1603, 1376, 1379, 1604, 32, 35, 1380, 1605, 441, 1124, 1381, 317, 1053 ],
  ),
  "add_row_below": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf422,
    categories: [ 12 ],
    tags: [ 192, 526, 1606, 1595, 1596, 1057, 1368, 802, 1201, 1202, 10, 1607, 299, 787, 1372, 246, 1044, 1608, 1600, 1601, 306, 1602, 1609, 763, 1610, 1611, 1211, 202, 1212, 1603, 1612, 1376, 1379, 1604, 35, 1380, 1605, 1381, 317, 1053 ],
  ),
  "add_shopping_cart": SymbolsMetadata(
    popularity: 6917,
    codepoint: 0xe854,
    categories: [ 9 ],
    tags: [ 526, 1264, 1613, 1614, 1615, 1616, 1617, 1618, 799, 1619, 800, 1326, 801, 803, 805, 806, 807, 1329, 1620, 1291, 818, 1275, 819, 1621, 96, 820, 821, 202, 1622, 840, 1623, 1296, 1297, 841, 1624, 1298, 1625, 1626 ],
  ),
  "add_task": SymbolsMetadata(
    popularity: 4138,
    codepoint: 0xf23a,
    categories: [ 2 ],
    tags: [ 192, 1627, 526, 1628, 1267, 1549, 1629, 1630, 1631, 1632, 383, 1633, 1634, 1635, 1636, 1637, 1201, 1638, 1639, 1640, 1207, 1641, 763, 1642, 1643, 202, 1212, 1644, 288, 1412, 1645, 1646, 1647, 1648, 1649, 1650 ],
  ),
  "add_to_drive": SymbolsMetadata(
    popularity: 705,
    codepoint: 0xe65c,
    categories: [ 12 ],
    tags: [ 526, 1229, 1057, 1230, 1651, 1652, 1653, 1540, 1201, 10, 1347, 1654, 1530, 1655, 1656, 1657, 1658, 1659, 1189, 1660, 1661, 1542, 1206, 1044, 763, 202, 1662, 1663, 1664, 311, 1665, 982, 1666, 674, 1412, 1667, 346 ],
  ),
  "add_to_home_screen": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xe1fe,
    categories: [ 11 ],
    tags: [ 1109, 1110, 949, 526, 1668, 1669, 1229, 1230, 380, 1670, 1113, 445, 1671, 388, 787, 1672, 1673, 965, 999, 1114, 1674, 219, 1675, 421, 226, 1493, 75, 782, 1664, 330, 1665, 982, 446, 32, 35, 447, 1676, 1677, 346 ],
    rtlAutoMirrored: true,
  ),
  "add_to_queue": SymbolsMetadata(
    popularity: 527,
    codepoint: 0xe05c,
    categories: [ 0 ],
    tags: [ 192, 1109, 1110, 526, 1678, 1679, 1267, 1680, 1681, 1682, 1683, 1057, 1684, 694, 1201, 1202, 1685, 445, 12, 1686, 965, 1114, 1206, 1044, 1687, 327, 763, 202, 1212, 100, 330, 342, 35, 1645, 1688, 343, 1689, 344, 1690, 1691, 1054 ],
  ),
  "add_triangle": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf48e,
    categories: [ 5 ],
    tags: [ 192, 526, 1692, 469, 1057, 380, 1693, 1201, 1694, 388, 787, 304, 1204, 1206, 1207, 1044, 1695, 421, 763, 1211, 1696, 202, 1697, 1698, 311, 1699, 35, 1700, 1590, 1701, 1702, 1703, 1704, 1261 ],
  ),
  "adf_scanner": SymbolsMetadata(
    popularity: 243,
    codepoint: 0xeada,
    categories: [ 11 ],
    tags: [ 1705, 1706, 383, 1707, 1708, 445, 181, 1709, 1347, 1710, 832, 1711, 1712, 1713, 1714, 1715, 965, 53, 1716, 966, 1717, 1718, 1456, 1719, 1534, 1535, 1720, 1721, 1722, 75, 1723, 1724, 32, 551 ],
  ),
  "adjust": SymbolsMetadata(
    popularity: 1657,
    codepoint: 0xe39e,
    categories: [ 1 ],
    tags: [ 1725, 1128, 1726, 1129, 1727, 794, 1728, 1729, 1730, 1731, 383, 953, 1732, 1733, 1734, 269, 1735, 1736, 832, 696, 1737, 1738, 53, 1739, 934, 1740, 778, 656, 1741, 329, 1742, 65, 1743, 1156, 36, 1744, 1745 ],
  ),
  "admin_meds": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xe48d,
    categories: [ 3 ],
    tags: [ 1507, 1746, 1747, 1748, 1749, 1750, 1751, 1347, 1752, 696, 595, 1753, 1754, 92, 1755, 1756, 1757, 1758, 1759, 1760, 1761, 1762, 1763, 1764, 1765, 121, 1353, 1766, 447 ],
  ),
  "admin_panel_settings": SymbolsMetadata(
    popularity: 7926,
    codepoint: 0xef3d,
    categories: [ 13 ],
    tags: [ 754, 755, 468, 1507, 1767, 1508, 1768, 1769, 470, 6, 1510, 268, 269, 479, 1661, 483, 850, 936, 853, 1770, 1771, 488, 489, 1516, 1517, 490, 1519, 1520, 1772, 602, 1773, 1011, 65, 1522, 501, 1774, 1523 ],
  ),
  "ads_click": SymbolsMetadata(
    popularity: 6862,
    codepoint: 0xe762,
    categories: [ 6 ],
    tags: [ 1035, 1056, 1037, 5, 1039, 1775, 1040, 953, 1776, 1777, 1732, 1778, 1779, 1780, 1781, 1043, 215, 1045, 1046, 1782, 1783, 1784, 1050, 1785, 1786, 1787, 288, 36, 1071, 947, 1590, 1691 ],
  ),
  "agender": SymbolsMetadata(
    popularity: 174,
    codepoint: 0xf888,
    categories: [ 3 ],
    tags: [ 1788, 383, 1789, 1790, 1791, 1792, 1793, 1794, 1795, 1796, 1797, 1798, 1205, 16, 850, 1799, 1800, 1801, 1802, 1602, 1803, 1804, 1805, 1806, 1807, 1808, 1809, 607, 35, 1215, 1810 ],
  ),
  "agriculture": SymbolsMetadata(
    popularity: 1693,
    codepoint: 0xea79,
    categories: [ 14 ],
    tags: [ 1811, 1812, 1813, 1814, 1815, 1816, 1817, 1818, 1819, 1820, 1821, 1822, 1823, 1824, 1825, 1826, 1827, 1828, 1829, 1204, 1830, 1831, 1832, 1833, 1834, 1490, 1835, 1836, 1837, 1838, 1839, 1840, 1841, 1842, 1504, 1843, 1844 ],
  ),
  "air": SymbolsMetadata(
    popularity: 2731,
    codepoint: 0xefd8,
    categories: [ 15 ],
    tags: [ 705, 1845, 707, 709, 1846, 1847, 1848, 1849, 1850, 712, 1851, 1852, 1853, 719, 926, 1854, 1855, 723, 1856, 366, 1857, 1858, 1859, 1860, 1861, 441, 730, 1862, 731, 1863 ],
  ),
  "air_freshener": SymbolsMetadata(
    popularity: 415,
    codepoint: 0xe2ca,
    categories: [ 8 ],
    tags: [ 1864, 707, 1865, 1866, 1867, 1868, 1869, 1870, 1815, 953, 1871, 1269, 1872, 1873, 956, 1874, 1875, 1876, 999, 1877, 1004, 1878, 1879, 424, 1880, 1881, 1882, 1883, 1884, 1885 ],
  ),
  "air_purifier": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xe97e,
    categories: [ 8 ],
    tags: [ 707, 1886, 1866, 1887, 1846, 1888, 1848, 1849, 383, 1871, 1889, 712, 445, 1711, 1890, 719, 959, 1891, 1874, 1876, 1892, 1893, 1894, 999, 1895, 1435, 1896, 1897, 1898, 1899, 1900, 1901, 32, 727, 730, 1902 ],
  ),
  "air_purifier_gen": SymbolsMetadata(
    popularity: 322,
    codepoint: 0xe829,
    categories: [ 8 ],
    tags: [ 707, 1903, 1886, 1866, 1846, 1888, 1848, 1871, 1889, 712, 269, 445, 1890, 719, 959, 1892, 595, 999, 1895, 1435, 1904, 1897, 1004, 1899, 1901, 727, 441, 730, 1862, 1902, 1905, 1863 ],
  ),
  "airline_seat_flat": SymbolsMetadata(
    popularity: 268,
    codepoint: 0xe630,
    categories: [ 16 ],
    tags: [ 1906, 1907, 1908, 1909, 584, 1910, 1284, 1911, 1912, 1913, 1914, 1915, 90, 1916, 303, 1917, 1918, 1919, 483, 1581, 1920, 1921, 1922, 488, 489, 308, 1923, 1924, 1925, 1926, 1927, 1928, 1929, 1930, 1504, 1591 ],
  ),
  "airline_seat_flat_angled": SymbolsMetadata(
    popularity: 143,
    codepoint: 0xe631,
    categories: [ 16 ],
    tags: [ 1907, 1931, 1932, 1908, 1933, 1934, 1935, 584, 1910, 1936, 1284, 1911, 1912, 1913, 1914, 1937, 90, 1916, 303, 1938, 1917, 1918, 1919, 483, 1581, 1920, 1922, 488, 489, 308, 1923, 1924, 1925, 1926, 1929, 1842, 1930, 1504, 1591 ],
  ),
  "airline_seat_individual_suite": SymbolsMetadata(
    popularity: 218,
    codepoint: 0xe632,
    categories: [ 16 ],
    tags: [ 1906, 1907, 1932, 1939, 1940, 1941, 584, 1936, 1284, 1911, 1942, 1913, 1914, 1943, 90, 1916, 1917, 1919, 483, 885, 1920, 1944, 1922, 488, 489, 1945, 531, 1517, 1946, 1924, 1925, 1926, 1947, 1929, 1948, 1930, 1504, 1949 ],
  ),
  "airline_seat_legroom_extra": SymbolsMetadata(
    popularity: 157,
    codepoint: 0xe633,
    categories: [ 16 ],
    tags: [ 1950, 1907, 1931, 1932, 1908, 584, 1912, 1914, 1951, 1952, 1953, 590, 1917, 1954, 483, 1955, 1920, 1956, 1922, 488, 489, 1923, 1957, 1958, 1959, 1960, 1926, 1961, 772, 609, 1962, 1504, 1963, 533 ],
  ),
  "airline_seat_legroom_normal": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xe634,
    categories: [ 16 ],
    tags: [ 1906, 1907, 1932, 584, 1910, 1936, 1912, 266, 1914, 1937, 590, 1917, 1918, 1964, 483, 16, 1581, 1955, 1965, 1920, 1966, 1922, 488, 489, 1967, 308, 1924, 1926, 288, 1961, 772, 609, 1968, 35, 1930, 1504, 1591 ],
  ),
  "airline_seat_legroom_reduced": SymbolsMetadata(
    popularity: 137,
    codepoint: 0xe635,
    categories: [ 16 ],
    tags: [ 1907, 1932, 1908, 1969, 584, 828, 1912, 1970, 1971, 1972, 1937, 590, 1917, 1973, 483, 1974, 1955, 1920, 1975, 1976, 1922, 488, 489, 1977, 1978, 912, 1926, 1927, 772, 1979, 609, 1980, 1504, 1981, 1982 ],
  ),
  "airline_seat_recline_extra": SymbolsMetadata(
    popularity: 566,
    codepoint: 0xe636,
    categories: [ 16 ],
    tags: [ 1983, 1907, 1932, 1908, 1940, 584, 1911, 1912, 1914, 1951, 1984, 590, 1916, 1917, 1918, 1919, 483, 1985, 1955, 1920, 1922, 488, 489, 1923, 1986, 1958, 1926, 772, 609, 750, 1930, 1504, 1591, 533 ],
  ),
  "airline_seat_recline_normal": SymbolsMetadata(
    popularity: 654,
    codepoint: 0xe637,
    categories: [ 16 ],
    tags: [ 1128, 1907, 1932, 584, 1912, 1987, 1914, 1951, 590, 1917, 1988, 483, 16, 1955, 1920, 1966, 1922, 488, 489, 1989, 308, 1496, 1923, 1926, 1990, 1927, 1928, 65, 1961, 772, 609, 750, 35, 1504, 1991, 1992 ],
  ),
  "airline_stops": SymbolsMetadata(
    popularity: 366,
    codepoint: 0xe7d0,
    categories: [ 5 ],
    tags: [ 1907, 1993, 380, 1994, 1731, 1995, 1996, 1484, 1997, 388, 1578, 1998, 1999, 2000, 2001, 1501, 1581, 2002, 2003, 1001, 1490, 2004, 421, 1586, 1495, 1503, 1378, 2005, 2006, 441, 2007, 2008, 1930, 1504, 1591, 2009 ],
  ),
  "airlines": SymbolsMetadata(
    popularity: 437,
    codepoint: 0xe7ca,
    categories: [ 14 ],
    tags: [ 1950, 707, 2010, 1906, 2011, 1932, 2012, 2013, 2014, 1935, 1936, 383, 2015, 2016, 832, 1917, 2017, 1918, 1973, 2018, 1581, 307, 909, 2019, 308, 2020, 2021, 227, 2022, 1424, 2023, 1930, 1504, 1591, 2024, 1054 ],
  ),
  "airplane_ticket": SymbolsMetadata(
    popularity: 1622,
    codepoint: 0xefd9,
    categories: [ 16 ],
    tags: [ 707, 2010, 1906, 1907, 1932, 2025, 2012, 2013, 2014, 1935, 2026, 2027, 1936, 2016, 1917, 2017, 1918, 1973, 2018, 1501, 1581, 1490, 2028, 308, 2029, 2020, 75, 1924, 77, 227, 2022, 2023, 1930, 1504, 2030, 1591, 2024 ],
    rtlAutoMirrored: true,
  ),
  "airplanemode_inactive": SymbolsMetadata(
    popularity: 257,
    codepoint: 0xe194,
    categories: [ 4 ],
    tags: [ 1950, 707, 1906, 1932, 2031, 2032, 2033, 2034, 2012, 2013, 2035, 895, 2036, 1202, 1077, 767, 2037, 898, 1917, 2038, 2039, 2040, 2017, 1918, 1973, 901, 1490, 307, 2041, 2042, 2043, 2044, 2045, 907, 908, 2046, 909, 308, 2020, 2047, 227, 2048, 914, 1930, 1504, 1591, 2049, 2050 ],
  ),
  "airplay": SymbolsMetadata(
    popularity: 365,
    codepoint: 0xe055,
    categories: [ 0 ],
    tags: [ 2051, 380, 2052, 1129, 355, 2053, 921, 269, 1685, 445, 12, 2054, 367, 327, 1719, 2055, 75, 330, 2056, 1665, 227, 32, 2057, 2058, 343, 1701, 344, 41, 235, 2059 ],
  ),
  "airport_shuttle": SymbolsMetadata(
    popularity: 2242,
    codepoint: 0xeb3c,
    categories: [ 14 ],
    tags: [ 2013, 2060, 2061, 2014, 1814, 2062, 1815, 1816, 1041, 2063, 1019, 2016, 388, 2064, 2065, 2066, 2067, 1581, 1490, 2068, 2069, 1922, 2070, 2071, 2072, 2073, 2074, 2007, 2008, 1842, 1930, 1504, 1591, 1843, 2075, 2076, 1844 ],
    rtlAutoMirrored: true,
  ),
  "airware": SymbolsMetadata(
    popularity: 441,
    codepoint: 0xf154,
    categories: [ 8 ],
    tags: [ 2077, 2078, 1129, 355, 212, 2079, 10, 926, 277, 2080, 215, 420, 2081, 223, 2082, 2083, 1787, 227, 2084, 1156, 342, 441, 2085, 2086, 1862, 1902, 233, 234 ],
  ),
  "airwave": SymbolsMetadata(
    popularity: 648,
    codepoint: 0xe29c,
    categories: [ 10 ],
    tags: [ 707, 2077, 2078, 1129, 1849, 1850, 355, 712, 212, 2079, 10, 926, 277, 999, 2080, 215, 420, 2081, 1004, 223, 2082, 2083, 1787, 227, 2084, 1156, 342, 729, 441, 2085, 2086, 1862, 1902, 731, 233, 1863, 234 ],
  ),
  "alarm": SymbolsMetadata(
    popularity: 4602,
    codepoint: 0xe855,
    categories: [ 6 ],
    tags: [ 2087, 2088, 2089, 1244, 2090, 469, 1015, 1246, 2091, 1016, 2092, 1017, 1018, 2093, 2094, 2095, 2096, 2097, 486, 1030, 1257, 2098, 1031, 103, 289, 2099, 1033, 2100, 2101, 2102 ],
  ),
  "alarm_add": SymbolsMetadata(
    popularity: 724,
    codepoint: 0xe856,
    categories: [ 6 ],
    tags: [ 192, 526, 2103, 2104, 1244, 469, 1246, 2091, 383, 1016, 2092, 1201, 2105, 1017, 2097, 763, 2106, 486, 98, 2107, 202, 1212, 1030, 2098, 1031, 2108, 35, 441, 289, 2099, 1033, 2101 ],
  ),
  "alarm_off": SymbolsMetadata(
    popularity: 470,
    codepoint: 0xe857,
    categories: [ 6 ],
    tags: [ 1244, 2109, 2110, 2111, 2112, 469, 1246, 2113, 2114, 2115, 1075, 1630, 1632, 383, 1016, 2116, 2117, 2118, 2119, 767, 1020, 898, 901, 1164, 2120, 2121, 486, 2122, 907, 909, 2123, 1030, 2124, 1170, 2125, 914, 2126, 289, 2127, 1033, 2128, 2129, 2102 ],
  ),
  "alarm_on": SymbolsMetadata(
    popularity: 1925,
    codepoint: 0xe858,
    categories: [ 6 ],
    tags: [ 1242, 1244, 2130, 2131, 2132, 2133, 469, 1246, 1630, 1632, 383, 1016, 1633, 1636, 1639, 1020, 898, 2097, 486, 909, 1030, 2098, 1031, 2134, 1156, 1647, 289, 2099, 1033, 1214, 2101, 2102 ],
  ),
  "alarm_pause": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf35b,
    categories: [ 6 ],
    tags: [ 1244, 2131, 469, 2135, 1246, 2136, 383, 1016, 2137, 2138, 1020, 2139, 2140, 2097, 486, 1082, 2141, 2142, 1030, 2143, 1929, 2144, 1083, 2145, 289, 2099, 1033, 2146, 2147, 2100, 2102 ],
  ),
  "alarm_smart_wake": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf6b0,
    categories: [ 6 ],
    tags: [ 1244, 2131, 469, 2148, 1246, 383, 1016, 786, 2149, 788, 789, 2097, 486, 656, 1030, 1257, 1031, 65, 1929, 2150, 1901, 1156, 791, 289, 1033, 2100, 2101 ],
  ),
  "album": SymbolsMetadata(
    popularity: 1445,
    codepoint: 0xe019,
    categories: [ 0 ],
    tags: [ 1538, 2151, 2152, 1129, 2153, 2154, 383, 2155, 694, 1732, 10, 2156, 2157, 1530, 2158, 2159, 1143, 2160, 367, 2081, 2161, 2162, 2163, 121, 701, 1786, 2164, 1156, 674, 2165, 703, 2166 ],
  ),
  "align_center": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xe356,
    categories: [ 12 ],
    tags: [ 2167, 2168, 2169, 2170, 794, 1730, 2171, 2172, 2173, 696, 2174, 1372, 2175, 2176, 2177, 2080, 2178, 1066, 306, 366, 2179, 98, 2180, 1496, 601, 2181, 107, 2182, 38, 2183, 2184, 441, 702, 2185 ],
  ),
  "align_end": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf797,
    categories: [ 12 ],
    tags: [ 2167, 2186, 2187, 2169, 2188, 2189, 2190, 1372, 2191, 2177, 2178, 2192, 2193, 366, 2180, 1396, 2194, 2195, 38, 2196, 2183, 2197, 441, 2198, 2199 ],
  ),
  "align_flex_center": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf796,
    categories: [ 12 ],
    tags: [ 526, 2167, 2169, 2170, 794, 1730, 2171, 1061, 1202, 2200, 2173, 2201, 2202, 2203, 1372, 2191, 1209, 1064, 2178, 2204, 306, 366, 1067, 2179, 2205, 202, 1212, 1496, 601, 2182, 2206, 1381, 2198 ],
  ),
  "align_flex_end": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf795,
    categories: [ 12 ],
    tags: [ 2167, 2207, 2187, 2208, 2169, 1367, 1343, 2188, 2209, 1730, 1368, 2173, 2210, 2189, 2202, 2211, 2212, 2203, 1372, 2178, 2192, 306, 1602, 366, 96, 1496, 75, 1396, 2194, 601, 107, 2182, 2196, 2183, 1381, 2198, 2199 ],
  ),
  "align_flex_start": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf794,
    categories: [ 12 ],
    tags: [ 2167, 2213, 2214, 2169, 1367, 2170, 1730, 2173, 2202, 2215, 2212, 2203, 1372, 2175, 2177, 2178, 2216, 2217, 2218, 306, 366, 96, 1496, 601, 108, 2182, 38, 2196, 2183, 2219, 1124, 2220, 2221, 1381, 2198, 2199 ],
  ),
  "align_horizontal_center": SymbolsMetadata(
    popularity: 340,
    codepoint: 0xe00f,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 1730, 2171, 1202, 2173, 696, 1371, 1372, 2175, 2176, 2191, 2177, 2178, 306, 366, 2179, 2180, 202, 601, 2181, 2182, 38, 2183, 2184, 702, 2198, 2199, 2222 ],
  ),
  "align_horizontal_left": SymbolsMetadata(
    popularity: 457,
    codepoint: 0xe00d,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 2172, 2223, 1347, 2224, 1372, 2175, 2176, 2191, 2177, 2178, 2225, 306, 1375, 2226, 366, 96, 98, 2227, 2180, 2228, 601, 2181, 2182, 38, 2183, 2229, 2230, 2231, 441, 702 ],
    rtlAutoMirrored: true,
  ),
  "align_horizontal_right": SymbolsMetadata(
    popularity: 308,
    codepoint: 0xe010,
    categories: [ 12 ],
    tags: [ 2167, 2187, 2169, 1367, 2232, 365, 236, 2190, 1372, 2175, 2176, 2233, 2234, 2178, 2193, 306, 366, 2235, 2180, 1396, 2194, 2236, 601, 2181, 2237, 2238, 2182, 38, 2183, 2197, 441 ],
    rtlAutoMirrored: true,
  ),
  "align_items_stretch": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf793,
    categories: [ 12 ],
    tags: [ 2167, 2213, 2239, 2169, 1367, 2170, 2188, 1730, 802, 2173, 2210, 2240, 2241, 787, 2242, 1372, 2243, 2244, 246, 2176, 2245, 2246, 2178, 306, 366, 2247, 1376, 601, 2181, 2248, 2249, 2182, 1124, 1381, 2198, 2199 ],
  ),
  "align_justify_center": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf792,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 1730, 2171, 802, 2172, 2173, 2250, 1372, 2175, 2176, 2178, 2204, 306, 366, 2179, 98, 2180, 601, 2248, 107, 2182, 38, 2183, 2230, 2251, 441, 2252, 2198, 2199, 2253 ],
  ),
  "align_justify_flex_end": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf791,
    categories: [ 12 ],
    tags: [ 2167, 2169, 2170, 365, 918, 1730, 2173, 236, 2189, 2202, 2254, 2212, 2203, 2190, 1372, 2175, 2178, 2255, 306, 366, 2180, 1496, 1396, 2194, 2195, 601, 2182, 38, 2183, 2230, 2256, 440, 441, 1381, 1592 ],
  ),
  "align_justify_flex_start": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf790,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 365, 84, 1730, 802, 2172, 2173, 1347, 1371, 2215, 2203, 1372, 2175, 2178, 2225, 306, 2226, 366, 98, 2180, 2228, 601, 108, 2182, 2196, 2183, 2230, 2231, 440, 1124, 1381, 2198, 2253 ],
  ),
  "align_justify_space_around": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf78f,
    categories: [ 12 ],
    tags: [ 2167, 2169, 2170, 794, 365, 1730, 802, 2173, 2250, 2201, 1372, 2175, 2176, 2178, 306, 366, 98, 2180, 2257, 2258, 601, 2259, 2248, 2182, 2206, 2183, 2229, 2230, 702, 1592, 2222 ],
  ),
  "align_justify_space_between": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf78e,
    categories: [ 12 ],
    tags: [ 2167, 2169, 2170, 794, 918, 1730, 802, 2173, 2260, 2250, 2201, 1372, 246, 2176, 2261, 2178, 306, 366, 2262, 98, 2263, 2180, 601, 2264, 2265, 2248, 945, 2182, 2183, 2266, 2267, 2268 ],
  ),
  "align_justify_space_even": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf78d,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 365, 918, 1730, 802, 2172, 2173, 1347, 1371, 2250, 2201, 2269, 1372, 2175, 2176, 2178, 2270, 306, 366, 2227, 2180, 601, 609, 2248, 2182, 38, 2183, 2266, 2271, 702, 1592 ],
  ),
  "align_justify_stretch": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf78c,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1730, 802, 2272, 2173, 1347, 696, 1371, 787, 2273, 1372, 2175, 2244, 246, 2176, 2191, 2178, 306, 366, 2227, 2247, 601, 2249, 2182, 1380, 2196, 2230, 2274, 2275, 702, 2198, 1054, 2185 ],
  ),
  "align_self_stretch": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf78b,
    categories: [ 12 ],
    tags: [ 2276, 1128, 2167, 2277, 2169, 2170, 2188, 1730, 1368, 1269, 2278, 2173, 787, 2279, 2242, 2212, 1372, 2243, 246, 306, 366, 1496, 2247, 2280, 1603, 601, 2181, 2281, 2282, 2249, 2182, 1124, 1381, 2198, 2283 ],
  ),
  "align_space_around": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf78a,
    categories: [ 12 ],
    tags: [ 2167, 2169, 2284, 2170, 794, 1730, 2173, 1347, 696, 2250, 2201, 1372, 2191, 2261, 2178, 1066, 306, 2179, 98, 2180, 609, 2248, 107, 2183, 440, 441, 2252, 702, 2268 ],
  ),
  "align_space_between": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf789,
    categories: [ 12 ],
    tags: [ 2167, 2169, 2170, 794, 365, 2188, 2173, 2260, 2250, 2201, 1372, 2191, 2285, 2286, 2178, 306, 366, 2262, 96, 98, 2263, 2228, 2287, 2265, 2248, 2183, 2266, 1124, 2198, 2288, 2289 ],
  ),
  "align_space_even": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf788,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 2170, 794, 2173, 2290, 2250, 2201, 2269, 1372, 2176, 2177, 2291, 2261, 2178, 2292, 1066, 306, 366, 98, 2293, 2294, 2295, 609, 2248, 107, 2296, 441 ],
  ),
  "align_start": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf787,
    categories: [ 12 ],
    tags: [ 2167, 2297, 2298, 2170, 84, 1042, 1347, 696, 2299, 1372, 2175, 2080, 2246, 2178, 306, 2226, 366, 96, 98, 2180, 108, 2196, 2183, 2184, 2229, 2231, 441, 1124 ],
  ),
  "align_stretch": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf786,
    categories: [ 12 ],
    tags: [ 2300, 2167, 2170, 2301, 365, 2302, 1042, 2210, 787, 2273, 2244, 2303, 2191, 2304, 2305, 53, 2178, 306, 2306, 2307, 2308, 2247, 2281, 2249, 38, 2296, 441, 2309, 1054 ],
  ),
  "align_vertical_bottom": SymbolsMetadata(
    popularity: 317,
    codepoint: 0xe015,
    categories: [ 12 ],
    tags: [ 2167, 2207, 2169, 1367, 2310, 365, 2311, 2188, 2312, 2313, 802, 1372, 2178, 2314, 306, 1602, 366, 2315, 96, 98, 2180, 601, 2181, 106, 107, 2182, 38, 2196, 2183, 1381, 2198, 2316, 2317 ],
  ),
  "align_vertical_center": SymbolsMetadata(
    popularity: 256,
    codepoint: 0xe011,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 794, 365, 1730, 2171, 2318, 802, 1347, 696, 2319, 1372, 2175, 1205, 2178, 2204, 306, 366, 2179, 2205, 2180, 1496, 601, 2181, 2182, 38, 2196, 2183, 2184, 2229, 702, 1381, 2198, 2199, 2320, 1592, 2222 ],
  ),
  "align_vertical_top": SymbolsMetadata(
    popularity: 252,
    codepoint: 0xe00c,
    categories: [ 12 ],
    tags: [ 2167, 2214, 2321, 2169, 1367, 2322, 802, 1372, 2175, 1205, 2178, 306, 366, 2180, 2228, 601, 2181, 2182, 38, 2196, 2183, 2323, 441, 1124, 2220, 1214, 702, 1381, 2198, 2199, 1592 ],
  ),
  "all_inbox": SymbolsMetadata(
    popularity: 804,
    codepoint: 0xe97f,
    categories: [ 7 ],
    tags: [ 2324, 2325, 2326, 2151, 2327, 7, 2328, 2329, 2330, 443, 1269, 2331, 2332, 2333, 1019, 337, 2334, 2335, 2336, 2337, 851, 2338, 2339, 2340, 485, 2341, 2342, 75, 2343, 32, 674, 1298, 2344, 2345 ],
  ),
  "all_inclusive": SymbolsMetadata(
    popularity: 3134,
    codepoint: 0xeb3d,
    categories: [ 6 ],
    tags: [ 2325, 2346, 2347, 2348, 2349, 385, 2350, 2351, 2352, 2353, 926, 2354, 2355, 760, 2356, 2357, 2358, 390, 2359, 2360, 2361, 2362, 2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 2372, 2373 ],
  ),
  "all_match": SymbolsMetadata(
    popularity: 68,
    codepoint: 0xe093,
    categories: [ 2 ],
    tags: [ 1627, 1548, 2325, 2374, 1549, 1199, 2375, 1630, 1632, 1633, 1636, 2376, 1639, 2377, 2378, 18, 1641, 2379, 1210, 2380, 1643, 1213, 288, 2381, 2382, 461, 2383, 2384, 1647, 2385, 2386, 2387, 2388, 1523, 2389, 1650 ],
  ),
  "all_out": SymbolsMetadata(
    popularity: 411,
    codepoint: 0xe90b,
    categories: [ 6 ],
    tags: [ 2325, 2390, 419, 2301, 383, 2391, 12, 1216, 787, 2392, 2393, 2394, 2395, 1673, 1204, 2396, 2397, 2307, 2398, 2399, 2400, 2247, 2281, 2401, 311, 2249, 317, 2402, 986, 2403, 2404 ],
  ),
  "allergies": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xe094,
    categories: [ 3 ],
    tags: [ 2405, 2406, 2407, 2408, 2409, 2410, 2411, 2412, 383, 2413, 2414, 595, 2415, 1753, 2416, 2417, 2418, 2419, 2420, 2421, 1757, 1760, 2422, 2423, 1564, 2424, 2425, 2426, 2427, 441, 2428, 2429 ],
  ),
  "allergy": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xe64e,
    categories: [ 3 ],
    tags: [ 2430, 2405, 2406, 2407, 2408, 2431, 2412, 1994, 2332, 2414, 956, 2432, 2433, 595, 2417, 2434, 2421, 2435, 366, 1757, 1859, 1835, 2422, 1564, 2436, 2425, 2426, 2437, 2438, 2439, 948 ],
  ),
  "alt_route": SymbolsMetadata(
    popularity: 1352,
    codepoint: 0xf184,
    categories: [ 5 ],
    tags: [ 1499, 2440, 1539, 2441, 2442, 2443, 2444, 2445, 419, 1994, 2446, 1731, 2447, 2448, 2449, 1997, 388, 1578, 2450, 2000, 777, 1488, 1581, 1002, 1490, 421, 656, 2451, 1586, 2452, 1587, 1503, 2453, 2454, 1378, 35, 1504, 2455, 1676, 2456 ],
    rtlAutoMirrored: true,
  ),
  "alternate_email": SymbolsMetadata(
    popularity: 7819,
    codepoint: 0xe0e6,
    categories: [ 7 ],
    tags: [ 2457, 468, 1429, 1539, 2458, 2442, 2459, 2460, 383, 443, 693, 475, 2332, 2461, 2335, 851, 215, 390, 2340, 485, 223, 819, 490, 1410, 2462, 2343, 2463, 2384, 501, 1053 ],
  ),
  "altitude": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xf873,
    categories: [ 3 ],
    tags: [ 1593, 2464, 2465, 380, 2052, 2466, 2467, 388, 2468, 2469, 1488, 196, 2470, 2471, 1207, 2472, 2473, 1001, 1545, 421, 1860, 2474, 28, 2475, 2476, 2477, 2478, 1504, 1701, 1676 ],
  ),
  "ambulance": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf803,
    categories: [ 14 ],
    tags: [ 469, 2479, 1549, 2480, 1131, 1814, 1815, 1630, 1632, 1633, 2481, 2376, 1639, 2482, 2483, 595, 1753, 1754, 2484, 1641, 1757, 486, 1643, 1213, 288, 2485, 2486, 2487, 1647, 1842, 1930, 2385, 2386, 2076, 1844, 1523, 1650 ],
  ),
  "amend": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf802,
    categories: [ 2 ],
    tags: [ 1128, 1726, 2488, 380, 419, 2489, 1731, 383, 2490, 2376, 388, 1347, 2491, 696, 1737, 530, 1375, 1602, 390, 1740, 421, 2492, 2493, 424, 425, 2494, 2367, 2495, 2496, 2497, 396, 2184, 2498, 2499, 1260 ],
  ),
  "amp_stories": SymbolsMetadata(
    popularity: 185,
    codepoint: 0xea13,
    categories: [ 12 ],
    tags: [ 2500, 2501, 365, 1400, 2155, 802, 1042, 2502, 930, 366, 367, 219, 2503, 2504, 2505, 2506, 2507, 75, 2508, 31, 32, 2509, 2510, 374, 2511, 317, 2512, 1691 ],
  ),
  "analytics": SymbolsMetadata(
    popularity: 10616,
    codepoint: 0xef3e,
    categories: [ 9 ],
    tags: [ 2513, 5, 2514, 1343, 1344, 365, 1284, 920, 2515, 10, 924, 929, 933, 2516, 2517, 2518, 597, 634, 937, 189, 2400, 28, 1353, 1354, 78, 32, 33, 440, 947, 2253, 1355, 2519 ],
  ),
  "anchor": SymbolsMetadata(
    popularity: 1235,
    codepoint: 0xf1cd,
    categories: [ 6 ],
    tags: [ 2520, 1058, 2521, 211, 1202, 2332, 2522, 2523, 2524, 2525, 1189, 2526, 2139, 2527, 16, 935, 2528, 2529, 2530, 2531, 2532, 421, 2533, 2534, 1257, 2476, 1773, 2535, 2536, 35, 2537 ],
  ),
  "android": SymbolsMetadata(
    popularity: 3202,
    codepoint: 0xe859,
    categories: [ 4 ],
    tags: [ 1175, 1180, 1229, 1230, 2148, 2538, 2539, 8, 383, 2332, 445, 1188, 479, 1189, 1190, 2540, 2528, 2541, 219, 1192, 1193, 1194, 1195, 2542, 446, 1196, 35, 447, 551, 2543 ],
  ),
  "animated_images": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xf49a,
    categories: [ 0 ],
    tags: [ 2544, 2545, 264, 2546, 2547, 270, 2548, 1541, 2549, 2550, 2551, 2552, 2553, 2554, 1066, 390, 367, 420, 2555, 2556, 328, 2557, 2558, 2559, 59, 61, 119, 2162, 283, 2560, 2561, 2562, 107, 41, 2563 ],
  ),
  "animation": SymbolsMetadata(
    popularity: 1032,
    codepoint: 0xe71c,
    categories: [ 1 ],
    tags: [ 2564, 264, 2565, 953, 384, 2566, 2349, 385, 2547, 2567, 270, 926, 276, 1065, 2568, 390, 420, 1858, 2559, 28, 2367, 1786, 396, 2569, 104, 2570, 2562, 1069, 2571, 41, 2572 ],
  ),
  "aod": SymbolsMetadata(
    popularity: 333,
    codepoint: 0xefda,
    categories: [ 11 ],
    tags: [ 1109, 1110, 469, 2573, 2574, 2575, 365, 2576, 472, 443, 2577, 445, 88, 12, 965, 2578, 2080, 1114, 135, 366, 485, 219, 2579, 2580, 2581, 2582, 2583, 486, 909, 226, 75, 77, 330, 446, 1121, 447, 38 ],
  ),
  "aod_tablet": SymbolsMetadata(
    popularity: 138,
    codepoint: 0xf89f,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2573, 2574, 2575, 2584, 268, 1042, 269, 445, 88, 12, 1347, 1711, 965, 2578, 1114, 135, 366, 788, 219, 909, 656, 1770, 226, 2585, 75, 77, 330, 65, 2508, 2586, 447, 551, 38 ],
  ),
  "aod_watch": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf6ac,
    categories: [ 11 ],
    tags: [ 2587, 469, 2574, 2575, 379, 2588, 1016, 445, 2589, 12, 2590, 2080, 1114, 485, 486, 1082, 330, 2591, 2592, 2586, 551, 441, 289, 1033, 2593, 1214, 405, 2102, 2594, 2595, 2596, 1691, 2597, 2598 ],
  ),
  "apartment": SymbolsMetadata(
    popularity: 11231,
    codepoint: 0xea40,
    categories: [ 16 ],
    tags: [ 2599, 2600, 2601, 1074, 798, 2602, 1285, 2603, 2604, 1434, 2605, 303, 2606, 999, 2607, 1435, 2608, 2609, 2610, 2611, 2612, 1456, 2613, 1444, 2614, 1445, 2615, 1446, 2616, 2617, 2618, 944, 2619, 2620, 1125, 2621, 1084, 1460 ],
  ),
  "api": SymbolsMetadata(
    popularity: 2716,
    codepoint: 0xf1b7,
    categories: [ 6 ],
    tags: [ 755, 2622, 2623, 1730, 2624, 921, 211, 10, 1186, 2625, 1416, 2626, 2627, 787, 2628, 255, 2629, 935, 1067, 223, 1194, 2630, 396, 2631, 1665, 1196, 32, 2632, 551, 2007 ],
  ),
  "apk_document": SymbolsMetadata(
    popularity: 146,
    codepoint: 0xf88e,
    categories: [ 4 ],
    tags: [ 1175, 2633, 2634, 2635, 2636, 2637, 2638, 2639, 2640, 2641, 1229, 2642, 2643, 1230, 1183, 10, 1347, 337, 1654, 1530, 1674, 2644, 219, 2645, 2646, 2647, 1534, 1535, 2648, 1195, 2649, 1196, 2632 ],
  ),
  "apk_install": SymbolsMetadata(
    popularity: 209,
    codepoint: 0xf88f,
    categories: [ 4 ],
    tags: [ 526, 1175, 1179, 2639, 1230, 380, 2650, 10, 445, 1347, 2651, 337, 1654, 1530, 2652, 1674, 219, 763, 2653, 2647, 1534, 1535, 226, 2648, 1195, 2649, 1196, 2632, 447, 1260, 533 ],
  ),
  "app_badging": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf72f,
    categories: [ 2 ],
    tags: [ 469, 2654, 1229, 2655, 2656, 1230, 2657, 6, 2658, 383, 832, 16, 2659, 188, 2568, 485, 763, 2660, 486, 2661, 2662, 1120, 28, 1030, 2663, 1257, 553, 35, 2664, 2665, 1260, 2666 ],
  ),
  "app_blocking": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xef3f,
    categories: [ 11 ],
    tags: [ 1109, 1110, 892, 1229, 2667, 2668, 2669, 1230, 1074, 2670, 895, 1113, 383, 269, 896, 445, 2671, 2672, 2673, 1077, 899, 965, 1114, 459, 2674, 219, 2675, 1675, 2676, 2677, 2678, 2679, 2680, 2681, 875, 226, 2682, 1516, 2683, 75, 171, 77, 1011, 914, 1083, 2684, 447 ],
  ),
  "app_registration": SymbolsMetadata(
    popularity: 4284,
    codepoint: 0xef40,
    categories: [ 2 ],
    tags: [ 755, 468, 1229, 2685, 2686, 1230, 2687, 2657, 953, 2688, 1735, 956, 696, 2689, 2690, 2691, 246, 852, 853, 1740, 2692, 2693, 2694, 2695, 329, 490, 1256, 856, 65, 2696, 857, 501 ],
  ),
  "apparel": SymbolsMetadata(
    popularity: 287,
    codepoint: 0xef7b,
    categories: [ 8 ],
    tags: [ 2697, 2698, 2699, 2700, 2701, 2702, 2703, 2704, 2705, 2706, 16, 2707, 1967, 1622, 1296, 2708, 841, 2709, 2710, 1298, 2182, 35, 2711, 2712, 2713, 1124, 2714, 2715 ],
  ),
  "approval": SymbolsMetadata(
    popularity: 1756,
    codepoint: 0xe982,
    categories: [ 6 ],
    tags: [ 1627, 2716, 1429, 2687, 2717, 2718, 1549, 2480, 2719, 2720, 1630, 2721, 1636, 1484, 2722, 1654, 1500, 2723, 1530, 1487, 2724, 2725, 1001, 2726, 1002, 1641, 21, 1493, 1494, 1495, 1496, 2727, 288, 371, 2728, 2729, 1412, 2384, 2387 ],
  ),
  "approval_delegation": SymbolsMetadata(
    popularity: 326,
    codepoint: 0xf84a,
    categories: [ 6 ],
    tags: [ 1627, 755, 1548, 2687, 2717, 2718, 1549, 1509, 2730, 2731, 1630, 1632, 1633, 1636, 2732, 1639, 2733, 2734, 777, 2735, 2736, 2737, 2738, 2739, 2740, 2741, 936, 2742, 2743, 1514, 942, 2342, 2744, 2487, 1645, 1647, 2007, 2745, 2387, 2746 ],
  ),
  "apps": SymbolsMetadata(
    popularity: 18655,
    codepoint: 0xe5c3,
    categories: [ 2 ],
    tags: [ 755, 2325, 2747, 2748, 1230, 2749, 2657, 1731, 953, 2155, 2750, 956, 246, 2751, 2752, 2753, 788, 789, 421, 682, 656, 98, 1194, 2754, 371, 2755, 1196, 32, 944, 313, 2756, 2757, 2758, 2759, 317 ],
  ),
  "apps_outage": SymbolsMetadata(
    popularity: 1122,
    codepoint: 0xe7cc,
    categories: [ 2 ],
    tags: [ 469, 2325, 2760, 2761, 1230, 2762, 2763, 2749, 2657, 2764, 953, 2155, 2750, 2765, 2037, 956, 2651, 2766, 2767, 2768, 246, 2751, 2769, 2752, 2770, 788, 486, 908, 2771, 2772, 2773, 944, 2774, 2757, 915, 2759, 1261 ],
  ),
  "aq": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf55a,
    categories: [ 10 ],
    tags: [ 2775, 186, 707, 1887, 4, 2776, 1847, 6, 2777, 2778, 2779, 8, 712, 14, 850, 698, 2780, 18, 2781, 2782, 19, 2528, 2783, 2784, 2785, 62, 2786, 35, 38, 2787, 2788, 40, 702, 2789 ],
  ),
  "aq_indoor": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf55b,
    categories: [ 10 ],
    tags: [ 707, 709, 1887, 4, 2776, 1847, 2777, 798, 8, 712, 1890, 2790, 14, 999, 1435, 2791, 1904, 723, 2792, 2793, 2794, 2795, 2796, 2797, 19, 2798, 2799, 2800, 2784, 2785, 1444, 62, 1446, 35, 38, 441, 40, 730, 2801, 1862, 1902, 2802 ],
  ),
  "ar_on_you": SymbolsMetadata(
    popularity: 114,
    codepoint: 0xef7c,
    categories: [ 0 ],
    tags: [ 379, 2803, 381, 47, 383, 2391, 2804, 2805, 1553, 1554, 479, 2806, 2807, 2808, 1555, 960, 1738, 274, 1556, 1557, 1558, 2809, 2810, 2811, 1560, 1561, 909, 489, 59, 1563, 1723, 2812, 2813, 1567, 1569, 32, 1570, 36, 1071, 947, 501, 2814, 2815 ],
  ),
  "ar_stickers": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xe983,
    categories: [ 0 ],
    tags: [ 406, 379, 2816, 2817, 2818, 381, 1550, 1551, 1553, 1554, 479, 1555, 2819, 1556, 1558, 1001, 1002, 21, 1561, 421, 422, 1081, 1493, 1495, 2820, 2821, 2822, 1496, 2823, 1567, 1568, 1569, 2824, 2825, 1570, 2826 ],
  ),
  "architecture": SymbolsMetadata(
    popularity: 1991,
    codepoint: 0xea3b,
    categories: [ 15 ],
    tags: [ 2827, 2828, 2601, 2829, 2830, 798, 383, 2831, 2832, 1201, 299, 2833, 2834, 302, 2835, 1659, 304, 2836, 366, 1210, 2380, 634, 2837, 2838, 1741, 945, 2839, 2537, 1701 ],
  ),
  "archive": SymbolsMetadata(
    popularity: 3505,
    codepoint: 0xe149,
    categories: [ 12 ],
    tags: [ 2151, 2650, 1651, 7, 2155, 1269, 10, 1347, 2840, 337, 1530, 1023, 851, 135, 966, 1044, 2159, 2340, 936, 98, 2841, 2842, 121, 2843, 2844, 1664, 674, 1298 ],
  ),
  "area_chart": SymbolsMetadata(
    popularity: 1044,
    codepoint: 0xe770,
    categories: [ 9 ],
    tags: [ 2513, 5, 993, 2845, 2846, 1284, 920, 10, 2847, 924, 808, 929, 196, 933, 135, 2518, 2848, 597, 634, 937, 2849, 189, 2850, 2400, 28, 1353, 2851, 33, 947, 2852, 1355 ],
  ),
  "arming_countdown": SymbolsMetadata(
    popularity: 180,
    codepoint: 0xe78a,
    categories: [ 10 ],
    tags: [ 951, 469, 2827, 2853, 6, 383, 2092, 2854, 2137, 2855, 2856, 999, 2857, 2568, 1004, 486, 2858, 2859, 942, 28, 1520, 1772, 602, 1773, 1011, 2649, 1522, 2860, 553, 791, 1033, 2147 ],
  ),
  "arrow_and_edge": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf5d7,
    categories: [ 2 ],
    tags: [ 380, 2650, 419, 1058, 2861, 2862, 1061, 921, 1484, 1578, 2651, 2840, 337, 1597, 926, 2000, 1542, 2863, 966, 1044, 2864, 1064, 935, 1067, 421, 1586, 2865, 1318, 1503, 1378, 36, 441, 2007, 2571 ],
  ),
  "arrow_back": SymbolsMetadata(
    popularity: 53797,
    codepoint: 0xe5c4,
    categories: [ 2 ],
    tags: [ 2866, 1229, 1230, 380, 2867, 2868, 2489, 2869, 2870, 2871, 2862, 2750, 269, 388, 2872, 2873, 1023, 188, 2751, 2874, 1375, 2875, 779, 421, 1783, 2876, 2877, 2878, 2879, 2495, 2880, 2881, 2496, 330, 2882, 2757, 2499, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_back_2": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf43a,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2883, 2489, 2870, 2871, 2862, 2750, 269, 785, 388, 2884, 777, 2873, 1023, 188, 2751, 2885, 1375, 367, 2081, 779, 421, 2162, 1783, 2876, 2877, 2878, 2495, 2881, 2886, 1396, 330, 2882, 2887, 1701, 2757, 2499, 2759, 41, 1691, 1053 ],
  ),
  "arrow_back_ios": SymbolsMetadata(
    popularity: 39246,
    codepoint: 0xe5e0,
    categories: [ 2 ],
    tags: [ 2866, 378, 1229, 1230, 380, 2489, 2869, 2870, 2871, 2862, 2750, 269, 388, 2872, 2873, 1023, 188, 2751, 2888, 1375, 2875, 219, 779, 421, 1783, 2876, 2877, 2878, 2495, 2880, 2881, 2886, 330, 2882, 2757, 2499, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_back_ios_new": SymbolsMetadata(
    popularity: 10759,
    codepoint: 0xe2ea,
    categories: [ 2 ],
    tags: [ 2866, 2889, 2890, 1229, 1230, 380, 2489, 2870, 2871, 2862, 2750, 1062, 388, 2872, 2884, 2873, 1023, 188, 2751, 2888, 1375, 219, 779, 421, 1783, 2876, 2878, 2879, 2495, 2881, 330, 2882, 1214, 2757, 2499, 2759, 1691, 1053 ],
  ),
  "arrow_circle_down": SymbolsMetadata(
    popularity: 2886,
    codepoint: 0xf181,
    categories: [ 2 ],
    tags: [ 380, 2891, 2892, 2188, 2871, 2893, 2894, 383, 2895, 2896, 388, 2651, 337, 2897, 787, 2652, 1542, 188, 1674, 2898, 421, 780, 1664, 2899, 2900, 2007 ],
  ),
  "arrow_circle_left": SymbolsMetadata(
    popularity: 4173,
    codepoint: 0xeaa7,
    categories: [ 2 ],
    tags: [ 380, 2892, 2489, 2901, 383, 2902, 269, 388, 2884, 2874, 1375, 390, 2903, 2081, 779, 421, 2904, 2876, 2905, 2906, 2367, 2495, 2881, 2886, 396, 402, 2499, 41 ],
    rtlAutoMirrored: true,
  ),
  "arrow_circle_right": SymbolsMetadata(
    popularity: 9026,
    codepoint: 0xeaaa,
    categories: [ 2 ],
    tags: [ 775, 380, 2892, 383, 2902, 2907, 2908, 776, 388, 2909, 777, 2910, 852, 778, 779, 421, 780, 2162, 781, 28, 1396, 782, 2911, 2912, 2913, 108, 1412 ],
    rtlAutoMirrored: true,
  ),
  "arrow_circle_up": SymbolsMetadata(
    popularity: 4212,
    codepoint: 0xf182,
    categories: [ 2 ],
    tags: [ 380, 2466, 2914, 383, 384, 2490, 776, 388, 787, 777, 1204, 1207, 778, 421, 780, 1518, 2495, 2475, 889, 2899, 2915, 1124, 1676, 346, 2916, 2917 ],
  ),
  "arrow_cool_down": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf4b6,
    categories: [ 15 ],
    tags: [ 380, 2650, 419, 2188, 2918, 2871, 2862, 2896, 2919, 2920, 2921, 2448, 2449, 2922, 2923, 388, 956, 2651, 337, 2924, 2925, 2926, 2927, 2315, 2928, 421, 780, 2929, 2930, 2931, 2932, 2900, 2933, 2934, 2935, 944, 791, 2936, 1381 ],
  ),
  "arrow_downward": SymbolsMetadata(
    popularity: 11312,
    codepoint: 0xe5db,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2650, 2188, 2871, 2862, 2896, 2750, 776, 2937, 2923, 388, 2651, 337, 2924, 2938, 2909, 787, 777, 188, 966, 2751, 788, 421, 780, 330, 2899, 2882, 106, 1412, 441, 2939, 2757, 2759, 1691, 1053 ],
  ),
  "arrow_downward_alt": SymbolsMetadata(
    popularity: 164,
    codepoint: 0xe984,
    categories: [ 2 ],
    tags: [ 380, 2650, 419, 2940, 2188, 2871, 776, 2937, 388, 2651, 337, 2924, 2941, 787, 777, 1542, 188, 966, 1044, 788, 421, 780, 2653, 2899, 2900, 2935, 2007, 2942 ],
  ),
  "arrow_drop_down": SymbolsMetadata(
    popularity: 32851,
    codepoint: 0xe5c5,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2650, 2883, 2943, 2871, 2944, 2750, 388, 12, 2651, 1500, 2938, 2945, 2941, 2946, 787, 2947, 2751, 788, 789, 421, 2653, 2948, 330, 2899, 2900, 288, 371, 2882, 314, 1701, 2939, 2757, 2949, 2759, 1691, 1053 ],
  ),
  "arrow_drop_down_circle": SymbolsMetadata(
    popularity: 2547,
    codepoint: 0xe5c6,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2891, 2892, 2871, 383, 2950, 2896, 2750, 388, 2651, 1500, 2938, 2951, 2941, 2952, 787, 2953, 1598, 966, 2751, 92, 788, 789, 421, 2653, 656, 330, 2899, 2900, 288, 371, 65, 2882, 314, 2757, 2759, 1691, 1053 ],
  ),
  "arrow_drop_up": SymbolsMetadata(
    popularity: 6274,
    codepoint: 0xe5c7,
    categories: [ 2 ],
    tags: [ 775, 1229, 1230, 380, 2954, 2466, 2871, 2862, 2750, 388, 1500, 2955, 787, 2956, 777, 1204, 2957, 1207, 188, 2751, 2958, 421, 780, 1783, 2475, 330, 2915, 2882, 1124, 1701, 2757, 1676, 1677, 346, 2916, 2759, 1691, 1053 ],
  ),
  "arrow_forward": SymbolsMetadata(
    popularity: 35292,
    codepoint: 0xe5c8,
    categories: [ 2 ],
    tags: [ 775, 1229, 1230, 380, 2959, 2960, 419, 2862, 2750, 776, 269, 388, 2961, 2909, 2962, 777, 2910, 339, 2751, 2903, 778, 779, 421, 780, 2162, 1783, 781, 28, 1396, 782, 330, 2343, 2882, 1412, 2571, 2757, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_forward_ios": SymbolsMetadata(
    popularity: 45414,
    codepoint: 0xe5e1,
    categories: [ 2 ],
    tags: [ 775, 2963, 1229, 2964, 1230, 380, 2965, 2862, 2750, 776, 388, 2909, 2962, 777, 339, 2751, 2888, 778, 779, 421, 780, 2162, 781, 28, 1396, 782, 330, 2343, 2882, 2966, 1412, 2967, 2757, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_insert": SymbolsMetadata(
    popularity: 149,
    codepoint: 0xf837,
    categories: [ 2 ],
    tags: [ 526, 378, 1229, 1230, 380, 2968, 2896, 2750, 1062, 2969, 388, 2970, 2909, 787, 1542, 1206, 188, 2971, 966, 1044, 2751, 1375, 421, 2972, 1495, 1363, 1783, 330, 2343, 2882, 1412, 2221, 1214, 2757, 346, 2759, 1691, 1053 ],
  ),
  "arrow_left": SymbolsMetadata(
    popularity: 3282,
    codepoint: 0xe5de,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2868, 2489, 2901, 2870, 2871, 2862, 2750, 388, 2884, 2873, 188, 2751, 2885, 1375, 2875, 2973, 2974, 779, 421, 1783, 2876, 2877, 2878, 2495, 2881, 2886, 330, 2882, 1701, 2975, 2757, 2499, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_left_alt": SymbolsMetadata(
    popularity: 95,
    codepoint: 0xef7d,
    categories: [ 2 ],
    tags: [ 1499, 2442, 380, 2976, 419, 2489, 2870, 2871, 388, 2977, 2884, 2873, 188, 2874, 1375, 2875, 2973, 2974, 779, 421, 1783, 2876, 2878, 2978, 2495, 2881, 2886, 2979, 2238, 1214, 2499 ],
    rtlAutoMirrored: true,
  ),
  "arrow_menu_close": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf3d3,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2980, 2489, 2869, 2950, 2981, 2896, 2982, 2750, 388, 2983, 2984, 2985, 2986, 900, 2987, 188, 2751, 1375, 2875, 788, 2988, 2928, 2989, 2990, 421, 2653, 1770, 2991, 2992, 2495, 1396, 2993, 2994, 2882, 1701, 2757, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_menu_open": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf3d2,
    categories: [ 2 ],
    tags: [ 755, 1229, 1230, 380, 2950, 2896, 2750, 269, 388, 2995, 12, 2983, 2909, 787, 2996, 777, 1659, 2986, 188, 2751, 1375, 92, 788, 789, 2990, 421, 780, 2653, 656, 2162, 2948, 1396, 2997, 2993, 2882, 108, 314, 1701, 2757, 2949, 2759, 1215, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_or_edge": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf5d6,
    categories: [ 2 ],
    tags: [ 378, 2650, 419, 2188, 1707, 1062, 2923, 388, 1578, 2450, 2998, 2651, 2840, 337, 2999, 236, 926, 2652, 1542, 2863, 1067, 778, 421, 3000, 1586, 3001, 2342, 1503, 1664, 2007, 2571, 2455, 3002, 1381 ],
  ),
  "arrow_outward": SymbolsMetadata(
    popularity: 2380,
    codepoint: 0xf8ce,
    categories: [ 2 ],
    tags: [ 378, 1229, 1230, 380, 419, 2750, 776, 1062, 2969, 388, 787, 1672, 2628, 1471, 777, 2751, 421, 3003, 780, 2653, 2398, 3004, 1586, 781, 1396, 1503, 330, 2343, 1665, 2882, 1214, 2757, 1676, 346, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_range": SymbolsMetadata(
    popularity: 76,
    codepoint: 0xf69b,
    categories: [ 2 ],
    tags: [ 1128, 380, 419, 2489, 3005, 3006, 2919, 269, 588, 2450, 3007, 787, 2996, 2926, 3008, 2176, 2875, 3009, 778, 421, 3010, 3011, 3001, 3012, 1007, 2247, 782, 2281, 1010, 3013, 372, 2455, 3014 ],
  ),
  "arrow_right": SymbolsMetadata(
    popularity: 8918,
    codepoint: 0xe5df,
    categories: [ 2 ],
    tags: [ 775, 1229, 1230, 380, 2750, 776, 388, 2909, 787, 2962, 777, 2910, 2751, 789, 778, 779, 421, 780, 2653, 2162, 1363, 781, 28, 1396, 782, 330, 2343, 2882, 1412, 2967, 2571, 1701, 2757, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "arrow_right_alt": SymbolsMetadata(
    popularity: 18443,
    codepoint: 0xe941,
    categories: [ 2 ],
    tags: [ 755, 775, 1499, 2963, 380, 3015, 419, 2862, 776, 388, 3016, 2909, 787, 777, 339, 188, 789, 778, 779, 421, 780, 2653, 1783, 3017, 781, 28, 1396, 782, 3018, 2343, 1412 ],
    rtlAutoMirrored: true,
  ),
  "arrow_selector_tool": SymbolsMetadata(
    popularity: 466,
    codepoint: 0xf82f,
    categories: [ 6 ],
    tags: [ 2890, 380, 2883, 419, 266, 1776, 694, 269, 1781, 299, 388, 302, 696, 2299, 305, 3019, 1375, 3020, 421, 281, 3021, 3022, 1783, 3017, 1662, 3023, 288, 371, 3024, 2537, 1701, 3025 ],
  ),
  "arrow_split": SymbolsMetadata(
    popularity: 239,
    codepoint: 0xe985,
    categories: [ 2 ],
    tags: [ 380, 2445, 419, 1994, 3026, 2447, 3027, 388, 2173, 2210, 3028, 3029, 1370, 2450, 2651, 926, 2000, 2557, 421, 656, 1586, 3030, 942, 1396, 1503, 2264, 1378, 2455, 3031, 1676, 3032, 2746 ],
    rtlAutoMirrored: true,
  ),
  "arrow_top_left": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf72e,
    categories: [ 2 ],
    tags: [ 378, 380, 3033, 3034, 419, 2489, 3035, 2862, 1062, 2969, 388, 1659, 778, 421, 1363, 1783, 2876, 2495, 396, 3036, 441, 2221, 2571, 402, 1214, 2499, 1676, 3037, 3038, 3039 ],
  ),
  "arrow_top_right": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf72d,
    categories: [ 2 ],
    tags: [ 380, 3040, 3041, 419, 3042, 776, 1062, 388, 3043, 3016, 1216, 787, 1471, 777, 1659, 3044, 421, 3045, 780, 781, 3046, 2343, 1665, 3047, 3048, 402, 1214, 1676, 346 ],
  ),
  "arrow_upload_progress": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf3f4,
    categories: [ 2 ],
    tags: [ 380, 383, 384, 1653, 1540, 3049, 2448, 2449, 3050, 1672, 3051, 3052, 3053, 1674, 2568, 3054, 2858, 3055, 28, 3056, 2504, 2505, 2343, 3057, 1665, 3058, 553, 1412, 3059, 2007, 3060, 1676, 1677, 346, 3061, 3062 ],
  ),
  "arrow_upload_ready": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf3f5,
    categories: [ 2 ],
    tags: [ 380, 3063, 383, 1653, 1633, 1540, 2448, 2449, 3050, 3064, 2173, 1672, 3052, 3065, 1674, 421, 3066, 2858, 1409, 28, 2504, 3067, 3068, 2343, 1665, 227, 553, 1412, 36, 2007, 1676, 1677, 346, 3069, 3061, 3062 ],
  ),
  "arrow_upward": SymbolsMetadata(
    popularity: 14631,
    codepoint: 0xe5d8,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2052, 2466, 2914, 2871, 2862, 2750, 776, 388, 787, 777, 1207, 2751, 778, 421, 780, 3070, 2475, 330, 2915, 2343, 2882, 1412, 441, 1124, 1701, 2757, 1676, 346, 2916, 2759, 1691, 1053 ],
  ),
  "arrow_upward_alt": SymbolsMetadata(
    popularity: 182,
    codepoint: 0xe986,
    categories: [ 2 ],
    tags: [ 775, 380, 3071, 419, 2466, 2871, 2862, 388, 787, 777, 1204, 1207, 421, 780, 3070, 1518, 2475, 2343, 441, 1124, 1701, 1676, 1677, 533, 346, 2916, 3072 ],
  ),
  "arrow_warm_up": SymbolsMetadata(
    popularity: 86,
    codepoint: 0xf4b5,
    categories: [ 15 ],
    tags: [ 469, 380, 419, 2466, 3073, 3074, 1693, 2448, 2449, 388, 956, 2767, 3075, 2925, 787, 2926, 2927, 1204, 3076, 3077, 3078, 530, 1207, 3079, 3080, 2568, 421, 486, 3081, 28, 3056, 3067, 2475, 2931, 2932, 108, 553, 791, 1676, 1677, 346, 3082, 3083, 3084, 1261 ],
  ),
  "arrows_input": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf394,
    categories: [ 2 ],
    tags: [ 380, 419, 1730, 3085, 2896, 1061, 3086, 3087, 2919, 3088, 2922, 1484, 388, 1738, 3089, 3090, 3091, 966, 3092, 1001, 1490, 1067, 2179, 2928, 778, 421, 1495, 1363, 2930, 3093, 2933, 1083, 36, 3094, 986, 2404 ],
  ),
  "arrows_more_down": SymbolsMetadata(
    popularity: 161,
    codepoint: 0xf8ab,
    categories: [ 10 ],
    tags: [ 378, 419, 2188, 3095, 712, 1042, 785, 1062, 12, 2651, 337, 2941, 787, 3096, 1659, 932, 999, 1066, 92, 788, 789, 421, 1004, 2653, 656, 3097, 2948, 3098, 3046, 2899, 65, 3099, 107, 729, 3100, 2949 ],
  ),
  "arrows_more_up": SymbolsMetadata(
    popularity: 340,
    codepoint: 0xf8ac,
    categories: [ 10 ],
    tags: [ 378, 419, 2466, 2871, 2862, 712, 2896, 776, 1062, 388, 3101, 2450, 787, 3102, 1204, 999, 1207, 2928, 789, 778, 421, 1004, 781, 2948, 3046, 2899, 3103, 729, 2007, 2455, 1676, 346 ],
  ),
  "arrows_output": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf393,
    categories: [ 2 ],
    tags: [ 380, 419, 1730, 2391, 3064, 1484, 2969, 388, 832, 1216, 787, 3104, 2996, 2628, 3089, 1673, 1204, 3080, 1001, 1490, 2307, 2179, 778, 2653, 2398, 1719, 3004, 1495, 1363, 2247, 2281, 1665, 32, 1083, 2249, 2949, 986 ],
  ),
  "arrows_outward": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf72c,
    categories: [ 2 ],
    tags: [ 3105, 380, 3106, 419, 3107, 2862, 388, 3108, 2450, 1216, 787, 3109, 2393, 2395, 1673, 1375, 2875, 2307, 778, 421, 3010, 2398, 3004, 2247, 1396, 782, 2281, 2401, 2249, 2455, 3110, 986, 2403, 2404 ],
  ),
  "art_track": SymbolsMetadata(
    popularity: 381,
    codepoint: 0xe060,
    categories: [ 0 ],
    tags: [ 1538, 1367, 2829, 3111, 2152, 1129, 2155, 1042, 12, 1541, 930, 53, 1543, 2159, 92, 367, 1544, 2557, 2081, 98, 2295, 59, 61, 119, 2163, 100, 75, 106, 1156, 32, 107, 441, 2165, 3112, 1592, 317 ],
  ),
  "article": SymbolsMetadata(
    popularity: 8828,
    codepoint: 0xef42,
    categories: [ 12 ],
    tags: [ 2501, 1652, 1042, 1201, 3113, 1528, 1347, 337, 1853, 1654, 696, 1530, 1598, 135, 366, 92, 1533, 2653, 1361, 1534, 1535, 2506, 75, 1353, 1664, 32, 674, 38, 3114, 441, 346, 317, 1536, 704 ],
    rtlAutoMirrored: true,
  ),
  "article_person": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf368,
    categories: [ 12 ],
    tags: [ 468, 2501, 3115, 3116, 1400, 475, 1042, 3117, 1528, 1347, 479, 1530, 483, 850, 135, 92, 853, 3118, 2503, 3119, 1534, 1535, 488, 489, 1409, 490, 2506, 2507, 78, 2729, 1412, 1645, 38, 441, 501, 3120, 704 ],
  ),
  "article_shortcut": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xf587,
    categories: [ 12 ],
    tags: [ 526, 380, 2501, 1042, 1540, 1201, 3121, 388, 1528, 1347, 2651, 1471, 1530, 777, 1542, 366, 935, 763, 1534, 1535, 1409, 2504, 979, 3122, 3123, 75, 3124, 1396, 2343, 1665, 982, 32, 1412, 38, 1677, 346, 704 ],
  ),
  "artist": SymbolsMetadata(
    popularity: 68,
    codepoint: 0xe01a,
    categories: [ 0 ],
    tags: [ 468, 2152, 3125, 1129, 470, 3126, 3127, 3128, 479, 483, 1143, 2081, 3129, 3130, 3131, 3132, 3133, 3134, 3135, 3136, 3137, 1532, 488, 3138, 489, 3139, 2163, 490, 3140, 2164, 1156, 501, 3141 ],
  ),
  "aspect_ratio": SymbolsMetadata(
    popularity: 1680,
    codepoint: 0xe85b,
    categories: [ 1 ],
    tags: [ 2300, 3142, 3143, 2301, 2391, 1819, 2448, 2449, 3144, 325, 787, 2242, 1372, 274, 1673, 53, 3145, 3146, 117, 1543, 3147, 854, 3148, 3149, 2247, 2281, 3150, 3151, 3152, 673, 32, 364, 292, 2309, 986 ],
  ),
  "assignment": SymbolsMetadata(
    popularity: 7093,
    codepoint: 0xe85d,
    categories: [ 12 ],
    tags: [ 1230, 3115, 1631, 1750, 1633, 1528, 1347, 3153, 3154, 1598, 1453, 92, 3155, 1533, 1456, 98, 2858, 2838, 3156, 3157, 1353, 1031, 3158, 1412, 1645, 3159, 3160, 38, 3161, 1649, 1459, 704 ],
    rtlAutoMirrored: true,
  ),
  "assignment_add": SymbolsMetadata(
    popularity: 156,
    codepoint: 0xf848,
    categories: [ 12 ],
    tags: [ 192, 526, 1057, 1230, 3115, 1058, 1631, 1750, 693, 1201, 1528, 1347, 696, 3153, 1598, 1453, 1206, 1044, 92, 763, 1532, 3155, 1456, 202, 3156, 1027, 3162, 3158, 1412, 35, 1645, 38, 1459, 704 ],
  ),
  "assignment_ind": SymbolsMetadata(
    popularity: 3006,
    codepoint: 0xe85e,
    categories: [ 12 ],
    tags: [ 468, 1509, 1629, 3163, 3115, 3164, 6, 799, 383, 1750, 475, 3165, 1528, 1347, 3166, 479, 3167, 3168, 2809, 3169, 885, 3170, 853, 488, 489, 3171, 3172, 490, 3173, 2744, 1521, 78, 32, 1645, 501, 3174 ],
  ),
  "assignment_late": SymbolsMetadata(
    popularity: 1080,
    codepoint: 0xe85f,
    categories: [ 12 ],
    tags: [ 3175, 469, 3115, 3073, 1693, 1750, 3176, 1018, 2137, 1528, 1347, 2766, 2767, 3177, 3075, 1530, 1251, 2769, 3178, 1641, 3179, 486, 3180, 2858, 2772, 1030, 1353, 1031, 1412, 35, 1645, 1649, 1034, 1261 ],
  ),
  "assignment_return": SymbolsMetadata(
    popularity: 996,
    codepoint: 0xe860,
    categories: [ 12 ],
    tags: [ 380, 3115, 2489, 1750, 1633, 3181, 388, 1528, 1347, 696, 480, 3065, 1598, 3182, 1453, 1375, 2875, 2876, 75, 1353, 3183, 2495, 2881, 2496, 3184, 3185, 32, 1412, 1645, 2499 ],
    rtlAutoMirrored: true,
  ),
  "assignment_returned": SymbolsMetadata(
    popularity: 477,
    codepoint: 0xe861,
    categories: [ 12 ],
    tags: [ 380, 2650, 3115, 1631, 1750, 1633, 1528, 1347, 2651, 337, 2924, 3153, 480, 1530, 3186, 3182, 3187, 1453, 1542, 2342, 75, 1353, 2844, 2495, 3188, 3158, 32, 1412, 1645, 3189 ],
  ),
  "assignment_turned_in": SymbolsMetadata(
    popularity: 2924,
    codepoint: 0xe862,
    categories: [ 12 ],
    tags: [ 1627, 1549, 3115, 3190, 1630, 1631, 1632, 1750, 1633, 1634, 1636, 1528, 1347, 1639, 3153, 3154, 1640, 3191, 1453, 3091, 1641, 1643, 3157, 1353, 3158, 288, 1412, 3192, 1645, 3160, 1647, 402, 3193, 2386, 2387, 1523, 1650 ],
  ),
  "assist_walker": SymbolsMetadata(
    popularity: 332,
    codepoint: 0xf8d5,
    categories: [ 5 ],
    tags: [ 733, 734, 3194, 3195, 736, 3196, 738, 584, 741, 3197, 3198, 744, 1753, 482, 483, 746, 3199, 3200, 3201, 1757, 770, 3202, 489, 3203, 3204, 3205, 750, 495, 3206, 3207, 3208, 3209 ],
    rtlAutoMirrored: true,
  ),
  "assistant_device": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xe987,
    categories: [ 11 ],
    tags: [ 3210, 3211, 3212, 3213, 3214, 1129, 2148, 383, 443, 445, 3215, 832, 3216, 1711, 2590, 1189, 965, 999, 3217, 3218, 1435, 215, 1897, 1143, 1147, 1004, 75, 77, 1155, 1901, 3219, 1156, 1157, 496, 551, 3220, 3221, 3222, 234 ],
  ),
  "assistant_direction": SymbolsMetadata(
    popularity: 1616,
    codepoint: 0xe988,
    categories: [ 2 ],
    tags: [ 380, 3213, 3223, 383, 776, 1484, 1416, 388, 3224, 1578, 777, 1488, 3225, 3226, 1001, 1002, 1490, 779, 421, 780, 1586, 1493, 1495, 781, 1396, 3227, 396, 1503, 3228, 32, 1083, 1504, 402, 3229 ],
    rtlAutoMirrored: true,
  ),
  "assistant_navigation": SymbolsMetadata(
    popularity: 2554,
    codepoint: 0xe989,
    categories: [ 2 ],
    tags: [ 380, 3213, 383, 2831, 776, 1484, 388, 1578, 958, 777, 1488, 3225, 3226, 188, 1581, 1001, 1002, 1490, 421, 780, 3070, 1493, 1495, 1363, 781, 1503, 1083, 3230, 1504, 1701, 1676, 3229 ],
  ),
  "assistant_on_hub": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf6c1,
    categories: [ 10 ],
    tags: [ 3210, 3231, 3213, 3232, 2148, 268, 211, 3233, 3234, 2515, 1685, 445, 3215, 12, 956, 3216, 1189, 965, 999, 3235, 1435, 3236, 2751, 215, 788, 327, 1004, 223, 656, 330, 65, 1155, 3237, 1901, 3238, 791, 3221, 234 ],
  ),
  "assured_workload": SymbolsMetadata(
    popularity: 2092,
    codepoint: 0xeb6f,
    categories: [ 13 ],
    tags: [ 468, 3239, 3240, 794, 795, 797, 798, 799, 800, 1632, 801, 803, 3241, 3242, 804, 805, 806, 3243, 3244, 3245, 807, 3246, 3247, 808, 812, 814, 818, 819, 820, 821, 822, 1520, 3248, 3249, 1772, 602, 1773, 3250, 3251, 1011, 3252, 1522, 2745, 1523, 3253 ],
  ),
  "asterisk": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xf525,
    categories: [ 12 ],
    tags: [ 3254, 3255, 8, 2950, 2896, 897, 3256, 3257, 3258, 787, 14, 3259, 3019, 16, 1251, 1641, 1210, 2380, 788, 3260, 3261, 421, 3262, 656, 3124, 911, 65, 3263, 3264, 35, 38, 3265, 40, 3266, 986 ],
  ),
  "atm": SymbolsMetadata(
    popularity: 512,
    codepoint: 0xe573,
    categories: [ 9 ],
    tags: [ 4, 3267, 3268, 3269, 3270, 3271, 796, 3272, 797, 690, 799, 1619, 800, 3273, 8, 801, 803, 805, 829, 806, 830, 3274, 88, 807, 808, 809, 14, 811, 19, 1001, 1717, 1002, 818, 3275, 819, 820, 821, 1493, 26, 3276, 701, 841, 35, 3277, 3278, 38, 842, 40, 3279 ],
  ),
  "atr": SymbolsMetadata(
    popularity: 1024,
    codepoint: 0xebc7,
    categories: [ 9 ],
    tags: [ 733, 3280, 953, 3281, 2896, 194, 921, 211, 832, 956, 787, 930, 932, 788, 789, 421, 223, 3282, 656, 940, 329, 1698, 65, 1665, 3058, 607, 609, 945, 946, 983, 791, 1701, 1459 ],
  ),
  "attach_email": SymbolsMetadata(
    popularity: 1078,
    codepoint: 0xea5e,
    categories: [ 7 ],
    tags: [ 526, 1058, 3283, 3284, 1466, 1469, 443, 693, 475, 2331, 1347, 337, 2335, 3285, 3286, 1530, 777, 851, 1044, 19, 935, 2340, 485, 3287, 3288, 3289, 1410, 2343, 1665, 346 ],
  ),
  "attach_file": SymbolsMetadata(
    popularity: 7691,
    codepoint: 0xe226,
    categories: [ 12 ],
    tags: [ 526, 3290, 1341, 3291, 1057, 1058, 3283, 3284, 1466, 1469, 3292, 921, 1347, 1530, 1044, 3293, 1064, 935, 3294, 2340, 367, 1456, 1535, 3289, 1493, 3295, 3296, 346, 3297 ],
  ),
  "attach_file_add": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf841,
    categories: [ 12 ],
    tags: [ 192, 526, 3290, 3291, 1462, 1057, 1058, 3283, 3284, 3298, 1466, 1469, 3299, 1061, 1201, 1530, 1206, 1044, 3293, 1064, 935, 3300, 2340, 367, 763, 3289, 3301, 202, 1212, 346 ],
  ),
  "attach_file_off": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf4d9,
    categories: [ 12 ],
    tags: [ 526, 1058, 1466, 1074, 895, 1469, 3302, 897, 3303, 3304, 1077, 3305, 767, 3306, 898, 1530, 899, 1044, 935, 2340, 367, 3307, 3308, 907, 908, 909, 3289, 911, 3309, 3310, 914, 3311, 915, 3312, 346 ],
  ),
  "attach_money": SymbolsMetadata(
    popularity: 13500,
    codepoint: 0xe227,
    categories: [ 9 ],
    tags: [ 3313, 526, 1058, 796, 797, 828, 1618, 799, 800, 383, 801, 803, 3314, 1327, 805, 806, 3315, 807, 3316, 3317, 3318, 808, 809, 3319, 3320, 815, 935, 3321, 818, 909, 819, 820, 821, 1337, 840, 3322, 841, 35, 842, 3323, 3324 ],
  ),
  "attachment": SymbolsMetadata(
    popularity: 3084,
    codepoint: 0xe2bc,
    categories: [ 12 ],
    tags: [ 3325, 2587, 526, 1058, 1466, 1469, 693, 921, 3326, 1347, 3327, 1530, 3328, 16, 53, 2751, 1064, 366, 935, 390, 3329, 3330, 1456, 3289, 1586, 3331, 311, 105, 3296, 35, 2537 ],
  ),
  "attractions": SymbolsMetadata(
    popularity: 869,
    codepoint: 0xea52,
    categories: [ 16 ],
    tags: [ 989, 3332, 3333, 3334, 3335, 3336, 383, 384, 2602, 1484, 3337, 3338, 3339, 3340, 3341, 2819, 3342, 2018, 3343, 3344, 1490, 3345, 2613, 3346, 3347, 2072, 396, 2569, 3348, 2023, 1504, 2024, 773 ],
  ),
  "attribution": SymbolsMetadata(
    popularity: 730,
    codepoint: 0xefdb,
    categories: [ 7 ],
    tags: [ 468, 3349, 3350, 3351, 3352, 3116, 584, 3353, 383, 3354, 3355, 3356, 3357, 3358, 3359, 3128, 805, 3360, 483, 850, 885, 3361, 3362, 3363, 488, 489, 490, 3124, 1257, 3364, 501, 3365, 3366 ],
  ),
  "audio_description": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf58c,
    categories: [ 0 ],
    tags: [ 733, 1035, 4, 3367, 3368, 739, 1129, 3369, 3370, 355, 8, 3371, 3372, 3373, 3374, 3153, 270, 14, 3375, 19, 326, 278, 3376, 3377, 1152, 330, 3378, 3379, 227, 1156, 3380, 3381, 35, 38, 344, 3382, 40, 41, 291, 3383, 3384, 1902 ],
  ),
  "audio_file": SymbolsMetadata(
    popularity: 682,
    codepoint: 0xeb82,
    categories: [ 0 ],
    tags: [ 3385, 1129, 3386, 3387, 3388, 3389, 1528, 1347, 1530, 968, 1143, 367, 3390, 328, 2081, 3391, 3392, 3393, 3394, 1532, 2162, 2163, 1152, 121, 3395, 1156, 3396, 3397, 3398, 3399, 2165, 3400 ],
  ),
  "audio_video_receiver": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf5d3,
    categories: [ 11 ],
    tags: [ 2500, 3401, 1888, 1129, 3402, 382, 3403, 3404, 3405, 298, 383, 269, 445, 1711, 3337, 3406, 3407, 3408, 367, 326, 2081, 2083, 1318, 75, 3409, 77, 65, 1156, 3410, 3411, 343, 3412, 3413, 344, 41, 3414 ],
  ),
  "auto_awesome_mosaic": SymbolsMetadata(
    popularity: 695,
    codepoint: 0xe660,
    categories: [ 1 ],
    tags: [ 1128, 2169, 1367, 1131, 3415, 3416, 918, 3417, 1061, 3418, 12, 1370, 696, 2299, 528, 3419, 1541, 246, 53, 3145, 306, 1067, 3420, 98, 3421, 59, 3422, 2258, 3423, 3424, 3425, 1378, 944, 945, 3426, 3427, 317, 1054 ],
  ),
  "auto_awesome_motion": SymbolsMetadata(
    popularity: 887,
    codepoint: 0xe661,
    categories: [ 1 ],
    tags: [ 1128, 264, 1131, 1132, 2148, 3416, 3095, 267, 3428, 3417, 2391, 696, 2299, 528, 3429, 270, 53, 530, 1066, 367, 420, 1858, 278, 59, 3046, 190, 104, 32, 107, 41 ],
  ),
  "auto_delete": SymbolsMetadata(
    popularity: 1107,
    codepoint: 0xea4c,
    categories: [ 6 ],
    tags: [ 2151, 1131, 3430, 3431, 1132, 3432, 1616, 3433, 3434, 3435, 3436, 1016, 1269, 1017, 897, 3437, 3438, 3439, 1023, 3440, 1029, 911, 1031, 3441, 674, 3442, 3443, 289, 1033, 3444, 3445 ],
  ),
  "auto_read_pause": SymbolsMetadata(
    popularity: 287,
    codepoint: 0xf219,
    categories: [ 7 ],
    tags: [ 1129, 1131, 3446, 3447, 1132, 2136, 471, 472, 473, 474, 269, 477, 3448, 3449, 1143, 485, 3377, 1082, 283, 2904, 2506, 75, 77, 493, 494, 1083, 38, 1214, 1592, 1161, 2147 ],
  ),
  "auto_read_play": SymbolsMetadata(
    popularity: 411,
    codepoint: 0xf216,
    categories: [ 7 ],
    tags: [ 380, 1129, 1131, 3450, 3451, 1132, 3452, 3453, 471, 472, 1401, 473, 474, 476, 477, 1143, 367, 485, 1406, 2162, 3454, 283, 1152, 2506, 782, 77, 493, 494, 32, 108, 342, 496, 1701, 41, 2102 ],
  ),
  "auto_stories": SymbolsMetadata(
    popularity: 4856,
    codepoint: 0xe666,
    categories: [ 1 ],
    tags: [ 2501, 1131, 1132, 2148, 1400, 1910, 3455, 1042, 3456, 1201, 3457, 3458, 1347, 3153, 3459, 2550, 3460, 3461, 3375, 2159, 3462, 2503, 3463, 1534, 3464, 2506, 2507, 3379, 2509, 2510, 3465 ],
  ),
  "auto_towing": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xe71e,
    categories: [ 14 ],
    tags: [ 3466, 738, 1131, 1814, 3467, 3468, 3469, 1815, 1816, 3470, 388, 2482, 3471, 2527, 3472, 1490, 3473, 3474, 3475, 3476, 2631, 3477, 3478, 3479, 1842, 1930, 1843, 1844, 3480, 3481 ],
  ),
  "auto_transmission": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf53f,
    categories: [ 14 ],
    tags: [ 534, 1131, 1132, 3482, 1814, 3467, 1815, 1731, 953, 3483, 922, 269, 3484, 538, 3485, 3486, 3487, 3488, 3489, 366, 3490, 3491, 281, 1586, 285, 65, 3036, 3492, 231, 3493, 3494, 2085, 1842, 1930, 1844 ],
  ),
  "autofps_select": SymbolsMetadata(
    popularity: 149,
    codepoint: 0xefdc,
    categories: [ 1 ],
    tags: [ 3495, 1128, 4, 264, 1131, 1132, 365, 47, 8, 267, 383, 268, 269, 270, 14, 273, 274, 275, 358, 277, 2781, 19, 420, 278, 3496, 282, 189, 283, 286, 177, 103, 287, 288, 65, 372, 3497, 231, 35, 38, 314, 40, 41 ],
  ),
  "automation": SymbolsMetadata(
    popularity: 121,
    codepoint: 0xf421,
    categories: [ 12 ],
    tags: [ 3211, 3498, 3212, 1131, 1132, 2148, 3499, 2538, 921, 211, 269, 385, 3500, 926, 3501, 2629, 3502, 935, 1000, 390, 3503, 3504, 936, 3282, 977, 3505, 942, 3506, 2367, 3507, 104, 2632, 1645, 2746, 3508 ],
  ),
  "autopause": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf6b6,
    categories: [ 0 ],
    tags: [ 2284, 380, 3509, 1132, 3510, 3511, 3512, 383, 384, 269, 785, 2448, 2449, 3513, 2568, 390, 2903, 326, 2081, 1082, 2141, 283, 3514, 424, 425, 2494, 3515, 3516, 2143, 2495, 2886, 396, 397, 1156, 1667, 1214, 3517, 2499, 41 ],
  ),
  "autoplay": SymbolsMetadata(
    popularity: 47,
    codepoint: 0xf6b5,
    categories: [ 0 ],
    tags: [ 2284, 380, 1129, 1132, 3452, 3453, 383, 384, 2348, 2349, 269, 785, 385, 2448, 2449, 926, 3513, 2568, 390, 367, 2081, 780, 2162, 3454, 283, 424, 2494, 2367, 3515, 3516, 396, 104, 1156, 108, 3518, 1667, 3519, 41 ],
  ),
  "autorenew": SymbolsMetadata(
    popularity: 12568,
    codepoint: 0xe863,
    categories: [ 2 ],
    tags: [ 2284, 380, 419, 3520, 3521, 3522, 383, 384, 2907, 2349, 3523, 385, 388, 2450, 3524, 3513, 3525, 390, 421, 2492, 424, 3526, 425, 3527, 2494, 2367, 3515, 426, 3516, 3528, 2496, 396, 397, 1667, 3529, 402, 2499, 1260 ],
  ),
  "autostop": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf682,
    categories: [ 0 ],
    tags: [ 2284, 380, 1132, 2148, 3530, 2136, 895, 3531, 383, 269, 785, 385, 386, 2448, 2449, 3448, 2140, 3513, 2568, 390, 391, 2081, 424, 425, 2494, 2367, 3532, 3515, 426, 3516, 2496, 396, 397, 1156, 32, 1083, 1667, 402, 403, 2499 ],
  ),
  "av1": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf4b0,
    categories: [ 0 ],
    tags: [ 79, 3533, 4, 3534, 382, 3535, 8, 3536, 3537, 3538, 668, 356, 12, 337, 3539, 1530, 3540, 270, 14, 1372, 2471, 18, 19, 278, 3541, 328, 3542, 3543, 2162, 283, 75, 30, 77, 3544, 330, 32, 342, 35, 38, 344, 40, 41, 3545, 3546, 648 ],
  ),
  "av_timer": SymbolsMetadata(
    popularity: 1333,
    codepoint: 0xe01b,
    categories: [ 0 ],
    tags: [ 1015, 380, 382, 3547, 383, 384, 1016, 2092, 956, 1020, 2568, 3548, 1082, 942, 28, 424, 1030, 396, 889, 1031, 287, 65, 3549, 1667, 3529, 791, 289, 1033, 1260, 2147, 2102 ],
  ),
  "avc": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf4af,
    categories: [ 0 ],
    tags: [ 687, 3550, 4, 3551, 7, 8, 3536, 3537, 1269, 3538, 668, 356, 12, 337, 3539, 1530, 270, 14, 1372, 3552, 2471, 19, 326, 278, 3541, 3553, 328, 283, 75, 30, 77, 330, 342, 35, 38, 3554, 344, 40, 41, 364, 3555, 3556, 291 ],
  ),
  "avg_pace": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xf6bb,
    categories: [ 15 ],
    tags: [ 5, 3557, 3558, 3559, 383, 1016, 2448, 2515, 2449, 1308, 956, 1020, 2927, 3560, 188, 597, 634, 3561, 937, 3562, 3563, 189, 1783, 28, 286, 2542, 231, 3564, 3549, 3565, 289, 1033, 947 ],
  ),
  "avg_time": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf813,
    categories: [ 15 ],
    tags: [ 5, 3557, 3566, 3567, 3568, 383, 1016, 1020, 2927, 277, 595, 3569, 1602, 597, 634, 937, 327, 2082, 189, 3570, 227, 3571, 231, 33, 3549, 3565, 289, 1033, 2165, 947, 3572, 1862, 1905 ],
  ),
  "award_star": SymbolsMetadata(
    popularity: 209,
    codepoint: 0xf612,
    categories: [ 6 ],
    tags: [ 3573, 3, 3574, 6, 3575, 1670, 3576, 3257, 3577, 3578, 1659, 3579, 1251, 3580, 531, 3581, 62, 3582, 102, 3583, 3584, 3585, 311, 3586, 3264, 3587, 2487, 3588, 3589 ],
  ),
  "azm": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xf6ec,
    categories: [ 15 ],
    tags: [ 3325, 1242, 3590, 2890, 380, 419, 3591, 2539, 2862, 3592, 388, 2450, 3593, 2925, 2926, 2927, 777, 1659, 196, 16, 366, 2528, 3548, 3594, 421, 780, 1783, 28, 1396, 2343, 311, 3024, 3595, 35, 2916, 3596, 1013 ],
  ),
  "baby_changing_station": SymbolsMetadata(
    popularity: 636,
    codepoint: 0xf19b,
    categories: [ 5 ],
    tags: [ 733, 734, 3597, 3598, 3599, 1868, 584, 3600, 1731, 3601, 862, 3602, 865, 3603, 3604, 867, 3605, 483, 3606, 871, 1001, 1002, 3607, 3608, 3609, 874, 876, 488, 489, 2071, 3610, 2631, 3611, 1380, 3612, 1885, 3613, 879 ],
  ),
  "back_hand": SymbolsMetadata(
    popularity: 2039,
    codepoint: 0xe764,
    categories: [ 8 ],
    tags: [ 2489, 2869, 3614, 2870, 895, 388, 3615, 2734, 538, 3616, 2735, 2873, 2738, 3617, 1023, 2874, 1375, 3618, 421, 2743, 2876, 2878, 3619, 2978, 2495, 3620, 2881, 2496, 2499 ],
  ),
  "back_to_tab": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf72b,
    categories: [ 2 ],
    tags: [ 3621, 380, 2489, 3622, 3042, 1039, 3623, 1062, 2985, 1471, 274, 1375, 2875, 390, 779, 421, 3624, 3625, 2876, 75, 2495, 3626, 2496, 32, 3627, 1070, 3628, 2499, 1676, 3629, 1054 ],
  ),
  "background_dot_large": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf79e,
    categories: [ 1 ],
    tags: [ 3630, 3631, 3632, 298, 266, 383, 953, 269, 832, 956, 538, 961, 3633, 246, 3019, 3634, 306, 2753, 788, 421, 281, 3635, 285, 78, 288, 371, 65, 609, 32, 3636, 3637, 314 ],
  ),
  "background_dot_small": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf514,
    categories: [ 1 ],
    tags: [ 2170, 3638, 3630, 918, 3639, 956, 3640, 246, 306, 2753, 788, 682, 656, 98, 3635, 27, 3641, 329, 78, 288, 371, 65, 1979, 3642, 609, 32, 945, 3636, 3637, 3426 ],
  ),
  "background_grid_small": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf79d,
    categories: [ 1 ],
    tags: [ 534, 3643, 2170, 3630, 3644, 3645, 3639, 802, 299, 3419, 246, 1387, 3646, 306, 1602, 2753, 940, 98, 3635, 1376, 3647, 3648, 609, 1379, 3649, 944, 945, 1380, 3636, 3650, 3426 ],
  ),
  "background_replace": SymbolsMetadata(
    popularity: 1320,
    codepoint: 0xf20a,
    categories: [ 6 ],
    tags: [ 3651, 470, 3652, 3653, 3630, 47, 3654, 3655, 2969, 3656, 3657, 959, 483, 3658, 1543, 366, 3635, 488, 489, 3659, 854, 490, 3660, 3661, 3662, 3663, 1546, 310, 32, 2586, 3664, 3636, 501, 3665, 41, 352 ],
  ),
  "backlight_high": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf7ed,
    categories: [ 4 ],
    tags: [ 3666, 3667, 3668, 3669, 3670, 1728, 3671, 785, 3672, 325, 3673, 3674, 3675, 3676, 3677, 3678, 3679, 969, 3680, 3681, 3682, 618, 3683, 3684, 3685, 3151, 65, 3686, 3687 ],
  ),
  "backlight_high_off": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf4ef,
    categories: [ 4 ],
    tags: [ 3667, 3688, 3668, 3670, 1728, 3689, 895, 3690, 3691, 3692, 3693, 767, 3672, 898, 3694, 3675, 969, 3680, 366, 3695, 3696, 3697, 3698, 907, 908, 909, 3684, 2258, 3685, 3699, 914, 2126, 3686, 441, 3700, 3701 ],
  ),
  "backlight_low": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf7ec,
    categories: [ 4 ],
    tags: [ 3666, 3667, 3668, 1728, 3702, 3703, 3704, 3690, 3705, 3706, 3691, 3707, 3672, 3708, 3677, 969, 3709, 3680, 3710, 3711, 3712, 3713, 3695, 3714, 75, 3715, 1421, 3685, 3716, 944, 3717, 2936 ],
  ),
  "backpack": SymbolsMetadata(
    popularity: 965,
    codepoint: 0xf19c,
    categories: [ 15 ],
    tags: [ 2464, 2489, 3718, 3719, 3720, 1910, 3721, 3722, 3723, 1269, 3153, 2523, 835, 3489, 3724, 2245, 3725, 3726, 3727, 3728, 790, 2585, 75, 3729, 3158, 32, 674, 2592, 3730, 1504 ],
  ),
  "backspace": SymbolsMetadata(
    popularity: 9045,
    codepoint: 0xe14a,
    categories: [ 2 ],
    tags: [ 380, 2489, 3731, 2870, 895, 3732, 3436, 2376, 3181, 1202, 897, 696, 1597, 3438, 1598, 966, 969, 2875, 2876, 911, 2495, 2184, 3733, 3734, 40, 3735, 2499, 3736 ],
    rtlAutoMirrored: true,
  ),
  "backup": SymbolsMetadata(
    popularity: 1988,
    codepoint: 0xe864,
    categories: [ 6 ],
    tags: [ 2151, 3737, 380, 1651, 1652, 3738, 3739, 3740, 3741, 10, 3742, 3743, 3744, 3050, 1654, 3745, 3052, 3746, 3747, 1520, 3748, 1663, 3749, 1664, 1011, 674, 1298, 1667, 3750, 2007, 1676, 1677, 346 ],
  ),
  "backup_table": SymbolsMetadata(
    popularity: 799,
    codepoint: 0xef43,
    categories: [ 6 ],
    tags: [ 2151, 1651, 3751, 3752, 3753, 3741, 1707, 10, 3754, 3755, 3756, 3757, 3758, 1654, 2999, 3746, 1372, 246, 3759, 306, 3748, 75, 2843, 3749, 3760, 1664, 3761, 1379, 32, 107, 674, 1380, 3762, 2936 ],
  ),
  "badge": SymbolsMetadata(
    popularity: 11539,
    codepoint: 0xea67,
    categories: [ 13 ],
    tags: [ 755, 468, 1768, 1769, 470, 6, 799, 1510, 1942, 1469, 1135, 3763, 3166, 2094, 479, 483, 3167, 3168, 2809, 850, 3118, 3764, 3765, 2028, 488, 3766, 489, 490, 75, 1011, 3767, 2384, 501, 2388, 3768, 1459 ],
  ),
  "badge_critical_battery": SymbolsMetadata(
    popularity: 342,
    codepoint: 0xf147,
    categories: [ 4 ],
    tags: [ 469, 6, 1343, 3769, 3770, 3771, 3772, 1113, 3773, 3774, 3775, 3776, 3777, 445, 3778, 3779, 965, 3780, 3781, 219, 486, 3782, 3783, 75, 65, 553, 2632, 3784, 1261 ],
  ),
  "bakery_dining": SymbolsMetadata(
    popularity: 1339,
    codepoint: 0xea53,
    categories: [ 16 ],
    tags: [ 3785, 3786, 3787, 3788, 3789, 3790, 3791, 3792, 3793, 3794, 3795, 3796, 3797, 3798, 3799, 3800, 3801, 1829, 3802, 3803, 3804, 3805, 3806, 3807, 3808, 3809, 3810, 441 ],
  ),
  "balance": SymbolsMetadata(
    popularity: 2649,
    codepoint: 0xeaf6,
    categories: [ 11 ],
    tags: [ 3811, 2514, 794, 2447, 3812, 3813, 3814, 3815, 3816, 3027, 2174, 3817, 2319, 3818, 3819, 3820, 3821, 3822, 3823, 816, 817, 597, 634, 656, 3824, 3825, 3826, 3827, 3828, 2206, 3829, 3830, 3831 ],
  ),
  "balcony": SymbolsMetadata(
    popularity: 404,
    codepoint: 0xe58f,
    categories: [ 8 ],
    tags: [ 1940, 2600, 3832, 2601, 3833, 3834, 798, 3835, 3836, 3837, 2605, 3838, 529, 3839, 999, 1435, 1490, 3840, 2398, 1860, 3841, 3842, 1495, 3843, 1444, 3844, 2614, 1445, 2615, 1446, 2616, 3845, 3846, 3847, 3848, 317, 1054 ],
  ),
  "ballot": SymbolsMetadata(
    popularity: 1433,
    codepoint: 0xe172,
    categories: [ 12 ],
    tags: [ 3849, 3850, 3851, 1630, 3852, 1631, 2447, 953, 3027, 956, 3853, 1598, 2080, 966, 2245, 366, 92, 656, 1363, 3854, 285, 78, 288, 371, 32, 1570, 1647, 3855, 3856 ],
  ),
  "bar_chart": SymbolsMetadata(
    popularity: 7466,
    codepoint: 0xe26b,
    categories: [ 9 ],
    tags: [ 2513, 5, 1343, 1344, 1345, 365, 1284, 920, 802, 10, 924, 808, 929, 933, 2518, 1045, 597, 634, 937, 189, 28, 1353, 1354, 2851, 3857, 33, 440, 947, 2852, 3858, 2253, 1355, 2519 ],
  ),
  "bar_chart_4_bars": SymbolsMetadata(
    popularity: 280,
    codepoint: 0xf681,
    categories: [ 9 ],
    tags: [ 3859, 2513, 5, 1344, 1345, 1284, 920, 802, 10, 924, 808, 2926, 2927, 3860, 929, 3861, 3862, 3863, 3864, 933, 2518, 1045, 597, 634, 22, 937, 3865, 189, 28, 1353, 1354, 2851, 3857, 33, 947, 2852, 3858, 2253, 1355, 2519 ],
  ),
  "bar_chart_off": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf411,
    categories: [ 9 ],
    tags: [ 5, 3866, 1343, 1344, 3867, 1345, 3868, 3869, 3870, 920, 3871, 3872, 10, 3873, 3874, 3304, 924, 3875, 3876, 929, 3877, 3878, 3879, 3880, 933, 597, 3881, 937, 3882, 3883, 3884, 3885, 3886, 3887, 914, 33, 3888, 440, 947, 3889, 3890, 3891 ],
  ),
  "barcode": SymbolsMetadata(
    popularity: 2437,
    codepoint: 0xe70b,
    categories: [ 9 ],
    tags: [ 3892, 1326, 2624, 10, 3893, 1329, 3894, 2809, 135, 3895, 3896, 2295, 1337, 1622, 3897, 840, 1296, 3898, 1723, 1724, 1297, 841, 1298, 2586, 3899, 2384, 947, 3900, 3901, 1592, 3902 ],
  ),
  "barcode_reader": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf85c,
    categories: [ 9 ],
    tags: [ 3892, 3903, 3904, 3669, 1630, 1326, 2624, 10, 445, 1329, 3216, 960, 3905, 2809, 135, 3895, 3906, 1717, 1337, 1622, 3907, 3908, 2507, 1296, 1723, 1724, 980, 122, 1297, 841, 1298, 2384, 947, 3901 ],
  ),
  "barcode_scanner": SymbolsMetadata(
    popularity: 2931,
    codepoint: 0xe70c,
    categories: [ 9 ],
    tags: [ 3892, 3904, 365, 3909, 1326, 3910, 2805, 1329, 2810, 3895, 3906, 3911, 3912, 1337, 3913, 3914, 3897, 3915, 3907, 3916, 3908, 1296, 1723, 3917, 1724, 122, 1297, 841, 3918, 1298, 2384, 947, 3900, 3901, 1592 ],
  ),
  "barefoot": SymbolsMetadata(
    popularity: 48,
    codepoint: 0xf871,
    categories: [ 3 ],
    tags: [ 3919, 3920, 3921, 3922, 3923, 584, 590, 1954, 3924, 3925, 3926, 3927, 3928, 3929, 3930, 3724, 483, 2724, 3931, 1581, 1859, 3727, 489, 3932, 3933, 3934, 3935, 109, 3936, 3937, 2165, 947, 3938, 1504, 3206, 3939 ],
  ),
  "batch_prediction": SymbolsMetadata(
    popularity: 649,
    codepoint: 0xf0f5,
    categories: [ 6 ],
    tags: [ 3211, 2513, 5, 3212, 2148, 3940, 3941, 3942, 1199, 3943, 10, 930, 3944, 135, 3945, 2516, 1066, 3680, 3946, 92, 3503, 2557, 3947, 3948, 942, 3949, 100, 2851, 107 ],
  ),
  "bath_outdoor": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf6fb,
    categories: [ 15 ],
    tags: [ 3950, 3951, 3952, 3953, 3954, 3076, 3078, 3955, 3956, 3957, 3958, 3959, 3960, 1859, 3961, 1860, 3841, 3962, 1959, 3963, 3964, 3965, 3966, 3967, 3968, 2023, 1504, 3969, 3083, 2801, 1905 ],
  ),
  "bath_private": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf6fa,
    categories: [ 15 ],
    tags: [ 3950, 3951, 3952, 3953, 1868, 3970, 584, 3971, 3078, 3955, 3956, 3957, 483, 3972, 2795, 3973, 366, 3961, 488, 489, 3974, 1517, 1958, 1959, 3964, 3975, 3966, 3967, 3976, 3977, 2586, 3969, 611, 3978, 2801, 1902, 1905 ],
  ),
  "bath_public_large": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf6f9,
    categories: [ 15 ],
    tags: [ 3950, 3951, 3952, 1868, 584, 3979, 3980, 930, 3981, 3078, 3955, 3956, 3957, 483, 2795, 3982, 3961, 488, 489, 3983, 3984, 1959, 3610, 3964, 3985, 3975, 3966, 3967, 3977, 499, 1885, 3986, 2801, 3987, 1902, 3613, 1905 ],
  ),
  "bathroom": SymbolsMetadata(
    popularity: 529,
    codepoint: 0xefdd,
    categories: [ 8 ],
    tags: [ 733, 3988, 735, 3950, 1868, 3970, 3989, 3979, 956, 3604, 3990, 3991, 246, 999, 1435, 3972, 3992, 3982, 3993, 3994, 1495, 2800, 3995, 3996, 3984, 3610, 1960, 3997, 3998, 3999, 4000, 32, 1885, 4001, 4002, 3986, 2801, 3987, 3613, 4003 ],
  ),
  "bathtub": SymbolsMetadata(
    popularity: 1289,
    codepoint: 0xea41,
    categories: [ 8 ],
    tags: [ 4004, 3950, 3953, 1868, 3970, 584, 1871, 4005, 3990, 999, 4006, 2607, 483, 3972, 489, 2800, 1958, 1959, 3610, 4007, 3998, 3965, 3966, 4008, 1504, 3969, 501, 4001, 2801, 1905 ],
  ),
  "battery_0_bar": SymbolsMetadata(
    popularity: 1127,
    codepoint: 0xebdc,
    categories: [ 4 ],
    tags: [ 469, 1343, 3769, 4009, 4010, 1113, 3773, 3774, 4011, 4012, 445, 1711, 4013, 965, 188, 4014, 4015, 4016, 219, 4017, 4018, 2585, 3782, 75, 553, 1261 ],
  ),
  "battery_1_bar": SymbolsMetadata(
    popularity: 798,
    codepoint: 0xebd9,
    categories: [ 4 ],
    tags: [ 4019, 469, 1343, 3769, 3770, 3772, 4020, 1113, 3773, 4021, 3774, 3776, 445, 1711, 3778, 3779, 188, 1602, 3780, 3781, 219, 4022, 226, 3782, 4023, 75, 553, 1261 ],
  ),
  "battery_2_bar": SymbolsMetadata(
    popularity: 586,
    codepoint: 0xebe0,
    categories: [ 4 ],
    tags: [ 4024, 4025, 4026, 3769, 4027, 3770, 3771, 3772, 4020, 4028, 1113, 3773, 3774, 445, 1711, 3779, 3780, 3781, 219, 226, 4029, 3782, 3783, 75, 77, 4030, 4031, 2146 ],
  ),
  "battery_3_bar": SymbolsMetadata(
    popularity: 793,
    codepoint: 0xebdd,
    categories: [ 4 ],
    tags: [ 4032, 1343, 3769, 4027, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 3779, 4033, 4034, 3781, 4035, 219, 3782, 4036, 75, 77, 65, 4037, 4038, 440, 4039 ],
  ),
  "battery_4_bar": SymbolsMetadata(
    popularity: 1215,
    codepoint: 0xebe2,
    categories: [ 4 ],
    tags: [ 4040, 3859, 4041, 4042, 1345, 365, 3769, 3770, 3772, 1113, 3773, 445, 1711, 3779, 3860, 4043, 188, 2472, 366, 4044, 219, 4045, 2585, 3782, 3783, 75, 77, 4046, 553, 4047 ],
  ),
  "battery_5_bar": SymbolsMetadata(
    popularity: 1705,
    codepoint: 0xebd4,
    categories: [ 4 ],
    tags: [ 4048, 4042, 1344, 3769, 1113, 3773, 3774, 445, 4049, 1711, 3779, 4050, 3860, 4043, 4051, 188, 4052, 2472, 219, 226, 2585, 3782, 3783, 75, 77, 553, 447 ],
  ),
  "battery_6_bar": SymbolsMetadata(
    popularity: 1027,
    codepoint: 0xebd2,
    categories: [ 4 ],
    tags: [ 4053, 4042, 1344, 3769, 3770, 3772, 4054, 1113, 3773, 3774, 445, 1711, 3779, 4043, 188, 4052, 2472, 366, 219, 4055, 226, 3782, 3783, 75, 4056, 553, 447, 2253 ],
  ),
  "battery_alert": SymbolsMetadata(
    popularity: 769,
    codepoint: 0xe19c,
    categories: [ 4 ],
    tags: [ 3175, 469, 3073, 1343, 3769, 4057, 1693, 1113, 3773, 3774, 3775, 3176, 445, 4013, 3779, 2766, 2767, 3177, 3075, 1251, 4052, 3780, 3781, 1641, 219, 486, 226, 3782, 4036, 75, 65, 553, 35, 447, 1261 ],
  ),
  "battery_android_0": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf30d,
    categories: [ 4 ],
    tags: [ 1175, 1343, 3769, 4058, 1113, 3773, 4059, 445, 1711, 4013, 3779, 965, 188, 2472, 3780, 219, 486, 226, 3782, 75, 77, 65, 553, 2632, 447, 1261 ],
  ),
  "battery_android_1": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf30c,
    categories: [ 4 ],
    tags: [ 469, 1175, 4060, 1343, 3769, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 3778, 3779, 4061, 3780, 219, 486, 226, 2585, 3782, 4036, 75, 77, 65, 4037, 4062, 4038 ],
  ),
  "battery_android_2": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf30b,
    categories: [ 4 ],
    tags: [ 1175, 4063, 1343, 3769, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 4049, 1711, 3779, 4061, 965, 3780, 219, 486, 226, 2585, 3782, 75, 65, 4037, 2632 ],
  ),
  "battery_android_3": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf30a,
    categories: [ 4 ],
    tags: [ 4064, 1175, 4060, 1343, 3769, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 3779, 4061, 3780, 219, 486, 226, 3782, 75, 65, 4030, 440, 4065, 4047 ],
  ),
  "battery_android_4": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf309,
    categories: [ 4 ],
    tags: [ 1175, 4060, 1343, 3769, 4027, 3770, 3771, 3772, 4028, 1113, 3773, 4021, 3774, 4049, 3779, 4043, 188, 2472, 3780, 219, 4066, 226, 4067, 3782, 4068, 4069, 75, 553 ],
  ),
  "battery_android_5": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf308,
    categories: [ 4 ],
    tags: [ 1175, 4060, 1343, 3769, 4070, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 4049, 3779, 4043, 188, 2472, 3780, 219, 226, 3782, 4071, 4069, 75, 4072, 553, 447 ],
  ),
  "battery_android_6": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf307,
    categories: [ 4 ],
    tags: [ 469, 1175, 1343, 3769, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 4049, 1711, 3779, 4043, 965, 188, 2472, 3780, 219, 486, 226, 2585, 3782, 75, 65, 553, 2632 ],
  ),
  "battery_android_alert": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf306,
    categories: [ 4 ],
    tags: [ 3175, 469, 4073, 1175, 3073, 3769, 4057, 4070, 3770, 4028, 1693, 1113, 4074, 3773, 3776, 3176, 445, 4075, 2766, 2767, 3177, 1251, 2769, 3780, 3781, 1641, 219, 486, 3782, 4036, 2772, 75, 77, 446, 35, 1261 ],
  ),
  "battery_android_bolt": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf305,
    categories: [ 4 ],
    tags: [ 1175, 3769, 4070, 3770, 3771, 3772, 4028, 4076, 1113, 3773, 4077, 3774, 445, 4078, 4049, 3779, 4079, 4080, 4081, 4082, 4083, 4014, 219, 226, 3782, 4071, 4084, 4085, 75, 77, 4086 ],
  ),
  "battery_android_full": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf304,
    categories: [ 4 ],
    tags: [ 1175, 4060, 1343, 3769, 4087, 3770, 3771, 4028, 1113, 2576, 3773, 4088, 4089, 3779, 4043, 4061, 4090, 188, 219, 226, 3782, 4091, 4068, 75, 77, 4037 ],
  ),
  "battery_android_plus": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf303,
    categories: [ 4 ],
    tags: [ 192, 526, 1175, 4060, 3769, 4027, 4087, 4092, 4093, 1113, 3773, 3774, 1202, 445, 3779, 4043, 1207, 188, 219, 763, 226, 202, 1213, 3782, 75, 4094, 65, 553, 35 ],
  ),
  "battery_android_question": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf302,
    categories: [ 4 ],
    tags: [ 4095, 1175, 738, 3769, 4096, 4097, 4098, 1113, 3773, 445, 2766, 482, 484, 135, 4099, 2472, 3780, 4100, 219, 3782, 2772, 4101, 979, 4102, 4103, 75, 77, 65, 553, 495, 35, 1364, 1261 ],
  ),
  "battery_android_share": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf301,
    categories: [ 4 ],
    tags: [ 1175, 380, 419, 3769, 4104, 4105, 4028, 1113, 3773, 4106, 212, 3779, 4107, 4108, 219, 4109, 3782, 4084, 4110, 75, 4111, 1396, 782, 77, 2343, 4112, 1665, 3058, 2007, 4113, 234, 4114 ],
  ),
  "battery_android_shield": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf300,
    categories: [ 4 ],
    tags: [ 1175, 3769, 4096, 4070, 3772, 4115, 4116, 4117, 4118, 4119, 4028, 1113, 1510, 3773, 4120, 445, 4121, 2856, 4122, 4123, 219, 3782, 4036, 4124, 1516, 1517, 1519, 1520, 1772, 4125, 1773, 1011, 1522, 1523 ],
  ),
  "battery_change": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf7eb,
    categories: [ 4 ],
    tags: [ 3769, 4126, 4070, 3770, 3771, 4127, 4028, 4128, 4129, 1113, 4130, 3773, 3774, 445, 3216, 3778, 3779, 965, 4131, 3780, 219, 4132, 3782, 4036, 75, 4133, 65, 4134, 4135 ],
  ),
  "battery_charging_20": SymbolsMetadata(
    popularity: 421,
    codepoint: 0xf0a2,
    categories: [ 4 ],
    tags: [ 4019, 1343, 3769, 3770, 3771, 4028, 4076, 1113, 3773, 3774, 4136, 445, 4078, 4049, 1711, 3779, 4080, 4082, 4083, 4131, 4014, 3780, 3781, 219, 226, 2585, 3782, 4084, 75, 4037, 4086, 4137 ],
  ),
  "battery_charging_30": SymbolsMetadata(
    popularity: 280,
    codepoint: 0xf0a3,
    categories: [ 4 ],
    tags: [ 4026, 3769, 3771, 3772, 4076, 1113, 3773, 3774, 445, 4078, 4049, 1711, 3779, 4080, 4043, 188, 4082, 4083, 4014, 219, 4138, 226, 4139, 2585, 3782, 4140, 75, 553, 4031, 4086 ],
  ),
  "battery_charging_50": SymbolsMetadata(
    popularity: 383,
    codepoint: 0xf0a4,
    categories: [ 4 ],
    tags: [ 4032, 1343, 3769, 3770, 3771, 3772, 4028, 4076, 1113, 3773, 3774, 4136, 445, 4078, 4049, 3779, 4080, 4034, 4082, 4083, 4131, 4014, 3780, 4141, 219, 486, 3782, 4036, 75, 65, 4037, 4086 ],
  ),
  "battery_charging_60": SymbolsMetadata(
    popularity: 317,
    codepoint: 0xf0a5,
    categories: [ 4 ],
    tags: [ 4041, 3769, 3770, 3771, 4028, 4076, 1113, 3773, 3774, 445, 4078, 4049, 3216, 3779, 4043, 16, 188, 4082, 4083, 4131, 4014, 219, 4142, 226, 3782, 75, 77, 4046, 553, 35, 447, 4086 ],
  ),
  "battery_charging_80": SymbolsMetadata(
    popularity: 416,
    codepoint: 0xf0a6,
    categories: [ 4 ],
    tags: [ 4048, 4042, 3769, 3770, 3771, 4028, 4076, 1113, 3773, 3774, 4143, 445, 4144, 4078, 4049, 1711, 3779, 4080, 4043, 188, 4082, 4083, 4014, 219, 226, 2585, 3782, 4084, 75, 77, 553, 4086 ],
  ),
  "battery_charging_90": SymbolsMetadata(
    popularity: 429,
    codepoint: 0xf0a7,
    categories: [ 4 ],
    tags: [ 4053, 4042, 3769, 3770, 3771, 4028, 4076, 1113, 3773, 3774, 445, 4078, 4049, 1711, 3779, 4080, 4043, 188, 4082, 4083, 4131, 4014, 219, 4145, 226, 3782, 4140, 75, 77, 553, 4086 ],
  ),
  "battery_charging_full": SymbolsMetadata(
    popularity: 2234,
    codepoint: 0xe1a3,
    categories: [ 4 ],
    tags: [ 3769, 4087, 4070, 3770, 3771, 4028, 4076, 1113, 3773, 4089, 3774, 445, 4078, 4049, 3779, 4080, 4043, 4061, 4081, 188, 4082, 4083, 4131, 4014, 219, 226, 3782, 4084, 75, 553, 4086 ],
  ),
  "battery_error": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf7ea,
    categories: [ 4 ],
    tags: [ 469, 3769, 4146, 4147, 4148, 4149, 4150, 895, 1113, 3773, 4151, 3436, 2950, 1202, 445, 2766, 2985, 965, 2769, 4052, 366, 3780, 219, 4152, 486, 226, 3782, 4153, 4154, 2772, 75, 911, 553, 1083, 447, 1261, 3736 ],
  ),
  "battery_full": SymbolsMetadata(
    popularity: 2628,
    codepoint: 0xe1a4,
    categories: [ 4 ],
    tags: [ 1343, 3769, 4070, 3770, 3771, 3772, 4028, 1113, 3773, 4089, 445, 4049, 1711, 3779, 4043, 4061, 4155, 188, 219, 2585, 3782, 4036, 75, 77, 65, 553, 2632 ],
  ),
  "battery_full_alt": SymbolsMetadata(
    popularity: 1170,
    codepoint: 0xf13b,
    categories: [ 4 ],
    tags: [ 1343, 3769, 4087, 3770, 3771, 4028, 1113, 3773, 4089, 445, 1711, 3779, 4156, 4157, 4061, 4081, 4090, 4155, 188, 4052, 2472, 219, 226, 3782, 4091, 75, 77, 553, 447 ],
  ),
  "battery_horiz_000": SymbolsMetadata(
    popularity: 293,
    codepoint: 0xf8ae,
    categories: [ 10 ],
    tags: [ 4158, 469, 1343, 3769, 4070, 3770, 3771, 4028, 1113, 3773, 3774, 4059, 445, 1711, 3778, 3779, 999, 2176, 188, 4052, 3780, 219, 1004, 4159, 226, 3782, 4036, 75, 65, 4037, 447, 1261 ],
  ),
  "battery_horiz_050": SymbolsMetadata(
    popularity: 501,
    codepoint: 0xf8af,
    categories: [ 10 ],
    tags: [ 4160, 1343, 3769, 4070, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 1711, 3779, 4033, 4034, 999, 2176, 3781, 4035, 4161, 219, 1004, 486, 3782, 4036, 3783, 75, 4037 ],
  ),
  "battery_horiz_075": SymbolsMetadata(
    popularity: 829,
    codepoint: 0xf8b0,
    categories: [ 10 ],
    tags: [ 4162, 4064, 1343, 3769, 3770, 3771, 3772, 4028, 1113, 3773, 3774, 445, 4049, 1711, 3779, 4043, 999, 2176, 4052, 3780, 219, 1004, 226, 3782, 4036, 75, 4037, 447, 4047 ],
  ),
  "battery_low": SymbolsMetadata(
    popularity: 706,
    codepoint: 0xf155,
    categories: [ 4 ],
    tags: [ 469, 4163, 1343, 3769, 3770, 4020, 4028, 1113, 3773, 3774, 3776, 445, 1711, 4013, 3779, 965, 999, 2176, 188, 3780, 3781, 219, 1004, 486, 3782, 3783, 75, 553, 1261 ],
  ),
  "battery_plus": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf7e9,
    categories: [ 4 ],
    tags: [ 192, 526, 4164, 4165, 3769, 4166, 4027, 3770, 3771, 3772, 4118, 4028, 4167, 4093, 3773, 3774, 3779, 4168, 1207, 4169, 366, 4170, 4171, 763, 202, 1212, 3782, 4023, 75, 4094, 35, 4172 ],
  ),
  "battery_profile": SymbolsMetadata(
    popularity: 186,
    codepoint: 0xe206,
    categories: [ 10 ],
    tags: [ 1128, 1230, 3769, 4115, 4116, 4173, 4118, 4174, 1731, 3773, 3774, 4175, 4176, 268, 269, 1735, 132, 3779, 4177, 4178, 3485, 999, 484, 135, 3780, 4179, 1740, 1004, 656, 790, 3782, 4036, 4180, 329, 490, 1011, 2631, 65 ],
  ),
  "battery_saver": SymbolsMetadata(
    popularity: 429,
    codepoint: 0xefde,
    categories: [ 4 ],
    tags: [ 192, 526, 4164, 3769, 4166, 4070, 3770, 3772, 4116, 4092, 4118, 3773, 3774, 4181, 4182, 4183, 4075, 4168, 3781, 4123, 763, 4184, 202, 3782, 4185, 4023, 75, 4186, 4094, 65, 35 ],
  ),
  "battery_share": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf67e,
    categories: [ 4 ],
    tags: [ 380, 419, 3769, 3771, 4028, 1113, 3773, 3774, 211, 445, 3779, 2985, 1672, 3780, 219, 4187, 4109, 3782, 4188, 3068, 4111, 1396, 782, 2343, 1665, 3058, 2007, 234, 4189 ],
  ),
  "battery_status_good": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf67d,
    categories: [ 4 ],
    tags: [ 1549, 3769, 4190, 4087, 4191, 4028, 1113, 3773, 4089, 1630, 1632, 1633, 445, 1639, 3779, 4043, 4192, 4052, 219, 1643, 226, 1213, 3782, 75, 288, 65, 4193, 2487, 4038, 447, 441, 1647, 2386, 1523, 4194, 1650 ],
  ),
  "battery_unknown": SymbolsMetadata(
    popularity: 415,
    codepoint: 0xe1a6,
    categories: [ 4 ],
    tags: [ 4095, 469, 738, 3769, 4096, 4070, 3770, 3771, 4028, 1113, 3773, 3774, 4195, 3778, 2766, 4061, 482, 484, 135, 2769, 3780, 219, 486, 3782, 2772, 4101, 4102, 4103, 75, 65, 4196, 495, 35, 1364, 4197, 1261 ],
    rtlAutoMirrored: true,
  ),
  "battery_very_low": SymbolsMetadata(
    popularity: 435,
    codepoint: 0xf156,
    categories: [ 4 ],
    tags: [ 469, 1343, 3769, 3770, 3771, 3772, 1113, 3773, 3774, 3776, 3777, 445, 3778, 3779, 965, 999, 2176, 3780, 3781, 219, 1004, 486, 3782, 3783, 75, 65, 553, 2632, 3784, 1261 ],
  ),
  "beach_access": SymbolsMetadata(
    popularity: 2201,
    codepoint: 0xeb3e,
    categories: [ 16 ],
    tags: [ 755, 3923, 4198, 4199, 4200, 1484, 2018, 2533, 3727, 4201, 2613, 3347, 1959, 4202, 3933, 2476, 4203, 4204, 4205, 4206, 3686, 4207, 4208, 4209, 2023, 1504, 1591, 4210, 2024 ],
  ),
  "bed": SymbolsMetadata(
    popularity: 3263,
    codepoint: 0xefdf,
    categories: [ 8 ],
    tags: [ 2599, 1909, 4211, 4212, 4213, 1936, 1914, 3108, 4214, 4215, 4043, 1964, 4216, 2018, 999, 4217, 2607, 1435, 4218, 2610, 4219, 2611, 4220, 4221, 4222, 4223, 4224, 1959, 1924, 1925, 1960, 673, 1929, 3846, 1948, 1504, 4225, 2024 ],
  ),
  "bedroom_baby": SymbolsMetadata(
    popularity: 563,
    codepoint: 0xefe0,
    categories: [ 8 ],
    tags: [ 2600, 3598, 3599, 4226, 4211, 862, 865, 4227, 4228, 867, 1964, 999, 4229, 1435, 3606, 2796, 870, 3609, 4230, 75, 1925, 4231, 4232, 1960, 1929, 32, 3612, 2543, 879 ],
  ),
  "bedroom_child": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xefe1,
    categories: [ 8 ],
    tags: [ 2599, 2600, 3599, 1909, 4211, 4233, 862, 4234, 865, 4228, 867, 1964, 999, 2607, 1435, 3606, 870, 4235, 366, 4236, 4220, 4230, 4223, 75, 1925, 1960, 673, 1929, 32, 3612, 1504, 4237, 4225, 879 ],
  ),
  "bedroom_parent": SymbolsMetadata(
    popularity: 603,
    codepoint: 0xefe2,
    categories: [ 8 ],
    tags: [ 2599, 2600, 1909, 4211, 1936, 865, 3108, 4214, 867, 274, 4043, 1964, 4238, 999, 2607, 1435, 2796, 871, 4218, 2610, 4239, 4220, 874, 4240, 4223, 4224, 75, 1924, 1925, 1960, 4241, 1929, 32, 1948 ],
  ),
  "bedtime": SymbolsMetadata(
    popularity: 2092,
    codepoint: 0xef44,
    categories: [ 3 ],
    tags: [ 4242, 4243, 4212, 4244, 3436, 4245, 712, 4246, 4247, 3690, 4248, 4249, 4250, 4251, 999, 4252, 4253, 1004, 4220, 4254, 4255, 4256, 2123, 4257, 1958, 1925, 1011, 4258, 1170, 1171, 1929, 4259, 729, 289, 4260, 731 ],
  ),
  "bedtime_off": SymbolsMetadata(
    popularity: 288,
    codepoint: 0xeb76,
    categories: [ 3 ],
    tags: [ 1242, 4212, 4261, 2136, 895, 1075, 3436, 712, 4262, 4246, 767, 4248, 4249, 4263, 4264, 899, 999, 901, 4252, 4253, 1164, 1004, 4220, 4255, 907, 908, 1082, 2123, 4265, 4257, 1959, 1925, 1011, 1170, 914, 1929, 4259, 729, 289, 4266, 915, 731 ],
  ),
  "beenhere": SymbolsMetadata(
    popularity: 1325,
    codepoint: 0xe52d,
    categories: [ 5 ],
    tags: [ 2717, 1549, 2480, 2151, 6, 4267, 1670, 1630, 1632, 1633, 1635, 4268, 1636, 4269, 2481, 1639, 3578, 1023, 18, 2159, 1001, 1641, 21, 1643, 1493, 2506, 2507, 4270, 2368, 1772, 602, 1664, 4271, 1773, 1011, 288, 1522, 2384, 1647, 2386, 2387, 1523, 2389, 4272, 1650 ],
  ),
  "bento": SymbolsMetadata(
    popularity: 312,
    codepoint: 0xf1f4,
    categories: [ 16 ],
    tags: [ 4273, 7, 383, 4274, 1269, 4275, 4276, 832, 1829, 4277, 246, 3959, 306, 3803, 4278, 3804, 4279, 940, 98, 4280, 4281, 75, 3807, 4282, 3423, 3809, 32, 674, 4283, 4284, 4285 ],
  ),
  "bia": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf6eb,
    categories: [ 15 ],
    tags: [ 2513, 5, 3811, 4286, 4287, 584, 4288, 4289, 1284, 4290, 920, 2515, 10, 4291, 4292, 958, 4293, 2926, 2927, 929, 595, 483, 135, 966, 2516, 4294, 969, 2518, 366, 976, 634, 937, 4295, 75, 1354, 3184, 980, 33 ],
  ),
  "bid_landscape": SymbolsMetadata(
    popularity: 147,
    codepoint: 0xe667,
    categories: [ 9 ],
    tags: [ 2513, 5, 1343, 365, 4296, 1284, 920, 10, 3756, 924, 808, 4297, 304, 929, 196, 1207, 933, 2516, 2518, 1543, 366, 1291, 597, 634, 937, 189, 28, 1354, 1379, 32, 33, 1380, 947, 2852, 1676, 1355, 4298 ],
  ),
  "bid_landscape_disabled": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xef81,
    categories: [ 9 ],
    tags: [ 5, 380, 2301, 1343, 365, 4296, 4299, 894, 895, 920, 10, 924, 767, 899, 929, 53, 901, 933, 1543, 4300, 4301, 597, 937, 4302, 4303, 907, 3147, 59, 119, 912, 396, 914, 32, 33, 313, 314, 947, 915, 2309 ],
  ),
  "bigtop_updates": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xe669,
    categories: [ 4 ],
    tags: [ 469, 1180, 2827, 4304, 4305, 355, 383, 443, 4306, 1732, 211, 212, 10, 277, 135, 215, 223, 486, 2083, 1318, 227, 342, 441, 2620, 2085, 4307, 1260, 4308, 1902, 233, 234 ],
  ),
  "bike_dock": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf47b,
    categories: [ 14 ],
    tags: [ 4309, 4310, 4311, 4312, 4313, 4314, 4315, 4316, 4317, 2602, 2063, 386, 2522, 4318, 1001, 1002, 1490, 421, 4319, 4320, 4321, 2615, 3058, 4322, 4323, 441, 1930, 1504, 2621, 1381 ],
  ),
  "bike_lane": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf47a,
    categories: [ 14 ],
    tags: [ 1549, 2480, 4311, 4312, 4324, 1510, 1630, 1632, 2063, 4325, 1633, 386, 4326, 388, 1578, 1639, 2925, 2927, 1488, 483, 4327, 1001, 1002, 1490, 1641, 421, 1643, 1586, 4328, 489, 1516, 1517, 1519, 4329, 1520, 2071, 3347, 1587, 1503, 1772, 602, 1773, 1011, 288, 1522, 1647, 1930, 1504, 501, 2386, 1523, 1650 ],
    rtlAutoMirrored: true,
  ),
  "bike_scooter": SymbolsMetadata(
    popularity: 260,
    codepoint: 0xef45,
    categories: [ 14 ],
    tags: [ 1814, 4311, 4312, 1815, 1816, 2602, 2063, 1019, 4330, 4331, 4332, 4333, 1490, 4334, 4335, 4336, 4337, 4338, 2615, 2072, 1587, 4339, 3058, 1589, 1842, 1930, 1504, 4340, 4341, 1844, 4342, 4343 ],
  ),
  "biotech": SymbolsMetadata(
    popularity: 2682,
    codepoint: 0xea3a,
    categories: [ 15 ],
    tags: [ 2513, 4344, 2412, 4345, 4346, 1113, 4347, 4292, 4348, 4349, 1753, 4350, 4351, 4352, 126, 4353, 974, 1757, 4354, 4355, 4356, 4357, 4358, 4359, 2424, 4360, 4361, 551, 986 ],
  ),
  "blanket": SymbolsMetadata(
    popularity: 160,
    codepoint: 0xe828,
    categories: [ 8 ],
    tags: [ 3769, 4213, 4362, 3773, 3774, 714, 211, 4363, 4364, 4365, 445, 4078, 4366, 4367, 4368, 4369, 4049, 3216, 1711, 3779, 1004, 4370, 4371, 4372, 4109, 3782, 4188, 4373, 4374, 4375, 4376, 4377, 4378, 4379 ],
  ),
  "blender": SymbolsMetadata(
    popularity: 598,
    codepoint: 0xefe3,
    categories: [ 8 ],
    tags: [ 1888, 4380, 4381, 4382, 4383, 4384, 298, 4385, 1269, 269, 3795, 4386, 4387, 4388, 4078, 4389, 4390, 4391, 3489, 4392, 4393, 4394, 3802, 4395, 4396, 4397, 1717, 4398, 4399, 4400, 4401, 4402, 4403 ],
  ),
  "blind": SymbolsMetadata(
    popularity: 445,
    codepoint: 0xf8d6,
    categories: [ 3 ],
    tags: [ 733, 734, 784, 736, 3196, 738, 739, 3370, 4404, 4405, 584, 4406, 741, 4407, 4408, 744, 482, 483, 4409, 3199, 4410, 770, 421, 489, 4411, 750, 4412, 3383, 3206, 3207, 4413, 4414, 4415 ],
  ),
  "blinds": SymbolsMetadata(
    popularity: 244,
    codepoint: 0xe286,
    categories: [ 8 ],
    tags: [ 1128, 4416, 2950, 269, 4364, 4365, 4417, 3489, 3235, 2176, 2080, 4418, 4419, 4420, 1004, 2653, 1516, 3001, 75, 4421, 65, 4204, 4422, 1901, 32, 4209, 4423, 730, 1054, 4424, 4425, 4426, 4427 ],
  ),
  "blinds_closed": SymbolsMetadata(
    popularity: 205,
    codepoint: 0xec1f,
    categories: [ 8 ],
    tags: [ 4416, 1074, 4428, 4365, 4417, 2651, 3235, 4429, 2080, 4418, 4420, 366, 2315, 4430, 1004, 1516, 75, 4431, 4204, 4432, 4422, 4433, 1901, 944, 4209, 4423, 1054, 4424, 4425, 4434, 4427 ],
  ),
  "block": SymbolsMetadata(
    popularity: 11565,
    codepoint: 0xe14b,
    categories: [ 2 ],
    tags: [ 4435, 1074, 895, 383, 4436, 4437, 2950, 4438, 4439, 4440, 767, 4441, 4248, 4442, 4249, 1597, 2985, 899, 4443, 1164, 4152, 4444, 4445, 907, 4446, 4447, 4448, 4449, 4450, 911, 171, 1170, 914, 1083, 915 ],
    rtlAutoMirrored: true,
  ),
  "blood_pressure": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xe097,
    categories: [ 3 ],
    tags: [ 4451, 4452, 920, 10, 4453, 1751, 3560, 929, 595, 4454, 1753, 4455, 3569, 4456, 4457, 597, 634, 1757, 1760, 3561, 327, 4458, 1762, 4459, 3570, 121, 177, 4460, 2165, 947, 4461, 4462 ],
  ),
  "bloodtype": SymbolsMetadata(
    popularity: 1080,
    codepoint: 0xefe4,
    categories: [ 3 ],
    tags: [ 2513, 4463, 4464, 4465, 4466, 4467, 4468, 4469, 1749, 3316, 4470, 1500, 4471, 2482, 4472, 595, 4473, 1753, 1754, 4474, 4352, 1757, 1758, 1760, 1116, 3696, 1762, 202, 1213, 4475, 4476, 40, 2801 ],
  ),
  "bluetooth": SymbolsMetadata(
    popularity: 2360,
    codepoint: 0xe1a7,
    categories: [ 4 ],
    tags: [ 951, 4477, 4478, 2053, 443, 921, 211, 212, 269, 3050, 896, 445, 1077, 3306, 1711, 2855, 277, 223, 4479, 656, 4480, 4481, 4482, 4483, 4484, 2083, 65, 4485, 227, 342, 35, 1667, 3529, 551, 4486, 234, 4487 ],
  ),
  "bluetooth_connected": SymbolsMetadata(
    popularity: 629,
    codepoint: 0xe1a8,
    categories: [ 4 ],
    tags: [ 2587, 1129, 4488, 4477, 4489, 2053, 443, 694, 921, 922, 211, 269, 3050, 445, 1711, 4490, 4052, 2081, 223, 4480, 4481, 4483, 226, 4491, 65, 227, 1157, 342, 35, 1667, 447, 551, 1701, 4492, 234, 4493 ],
  ),
  "bluetooth_disabled": SymbolsMetadata(
    popularity: 523,
    codepoint: 0xe1a9,
    categories: [ 4 ],
    tags: [ 4477, 4494, 4478, 4495, 2035, 4496, 895, 2053, 921, 211, 4497, 4498, 4499, 1202, 445, 4500, 4501, 767, 898, 4502, 2041, 4503, 2043, 4504, 907, 908, 909, 4505, 4506, 4483, 4491, 914, 342, 35, 4507, 4508, 234, 4509, 4510, 2050 ],
  ),
  "bluetooth_drive": SymbolsMetadata(
    popularity: 241,
    codepoint: 0xefe5,
    categories: [ 4 ],
    tags: [ 1131, 1814, 3467, 4477, 4511, 4512, 1815, 4513, 1816, 2053, 2063, 921, 4514, 211, 445, 1654, 1488, 4515, 1001, 1490, 421, 4483, 4516, 4517, 342, 35, 551, 1842, 1930, 1504, 1844, 4518, 234, 4519, 4520 ],
  ),
  "bluetooth_searching": SymbolsMetadata(
    popularity: 682,
    codepoint: 0xe1aa,
    categories: [ 4 ],
    tags: [ 1129, 4521, 4477, 4522, 4523, 355, 921, 211, 445, 955, 1711, 4524, 4490, 1143, 2081, 223, 4504, 4481, 4483, 4491, 980, 4525, 227, 1156, 1157, 2057, 35, 551, 234, 4526, 4527 ],
  ),
  "blur_circular": SymbolsMetadata(
    popularity: 434,
    codepoint: 0xe3a2,
    categories: [ 1 ],
    tags: [ 4528, 4529, 4530, 47, 383, 384, 4531, 4532, 4533, 956, 696, 2299, 2567, 528, 959, 1738, 4534, 3145, 4535, 126, 4536, 4537, 3422, 61, 119, 3641, 4538, 1257, 4539, 4540, 2438, 4541 ],
  ),
  "blur_linear": SymbolsMetadata(
    popularity: 257,
    codepoint: 0xe3a3,
    categories: [ 1 ],
    tags: [ 1128, 4528, 4542, 953, 4531, 956, 696, 2299, 2567, 528, 4543, 959, 1738, 4544, 53, 4534, 3145, 4535, 4545, 366, 4546, 4537, 59, 3422, 4547, 119, 4548, 4549, 441, 4550, 2571 ],
  ),
  "blur_medium": SymbolsMetadata(
    popularity: 240,
    codepoint: 0xe84c,
    categories: [ 1 ],
    tags: [ 4528, 4551, 47, 383, 4531, 696, 2299, 2567, 528, 1022, 959, 4552, 4553, 3145, 4535, 4554, 4044, 4555, 420, 4546, 1858, 4537, 4556, 3422, 4547, 4557, 61, 4558, 4540, 231, 441, 2571, 4559, 41, 364 ],
  ),
  "blur_off": SymbolsMetadata(
    popularity: 164,
    codepoint: 0xe3a4,
    categories: [ 1 ],
    tags: [ 4560, 4528, 4561, 4562, 953, 544, 4563, 4564, 3304, 4565, 767, 956, 696, 2299, 2567, 898, 528, 1738, 4534, 4566, 3145, 4567, 4568, 907, 909, 4569, 4570, 3422, 4571, 4572, 4573, 4574, 4575, 4576, 4539, 4577, 914, 2438, 4578 ],
  ),
  "blur_on": SymbolsMetadata(
    popularity: 1360,
    codepoint: 0xe3a5,
    categories: [ 1 ],
    tags: [ 4528, 4579, 4580, 4530, 47, 953, 4531, 4532, 767, 4581, 4533, 956, 696, 2299, 2567, 898, 528, 959, 1738, 246, 4534, 4535, 54, 2753, 907, 909, 4536, 4537, 3635, 3422, 3276, 4582, 4539, 914, 4558, 2438, 4541, 4583 ],
  ),
  "blur_short": SymbolsMetadata(
    popularity: 198,
    codepoint: 0xe8cf,
    categories: [ 1 ],
    tags: [ 4584, 4528, 4585, 4551, 383, 2332, 4531, 696, 2299, 4586, 2567, 528, 4587, 959, 1738, 4534, 3145, 4535, 4554, 366, 420, 1858, 4537, 4588, 3422, 4557, 4589, 3331, 4590, 4591, 314, 4592, 1214, 4578, 2572 ],
  ),
  "boat_bus": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf36d,
    categories: [ 14 ],
    tags: [ 4593, 1814, 2521, 4594, 4595, 2062, 4596, 1815, 1816, 2063, 4597, 388, 1578, 4598, 4599, 2526, 1490, 4600, 2530, 2532, 1922, 2071, 4601, 4602, 4603, 4604, 2023, 2008, 1930, 1504, 1844, 4605, 4606, 4607, 4608, 4609 ],
  ),
  "boat_railway": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf36c,
    categories: [ 14 ],
    tags: [ 1814, 2521, 4610, 1815, 4611, 1816, 2063, 4612, 388, 1578, 4613, 4599, 4614, 1581, 4615, 4616, 1490, 4617, 2533, 1922, 2071, 4601, 4618, 4619, 4620, 2476, 2535, 4604, 4621, 2165, 4622, 4623, 2008, 1842, 1930, 1504, 1844, 4605, 2801 ],
  ),
  "body_fat": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xe098,
    categories: [ 3 ],
    tags: [ 2513, 4624, 4288, 4625, 4626, 4627, 4628, 4629, 4630, 4631, 4632, 4633, 2927, 4634, 595, 4454, 4635, 597, 634, 4636, 3561, 4637, 4638, 2281, 4639, 947, 1701, 3831, 1905, 4640 ],
  ),
  "body_system": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xe099,
    categories: [ 3 ],
    tags: [ 376, 377, 3919, 2412, 584, 4641, 383, 385, 2927, 4642, 595, 1753, 4643, 483, 390, 1757, 4644, 488, 489, 4645, 396, 397, 2424, 399, 2632, 402, 4646, 1905 ],
  ),
  "bolt": SymbolsMetadata(
    popularity: 15363,
    codepoint: 0xea0b,
    categories: [ 2 ],
    tags: [ 469, 3769, 4076, 3773, 3774, 3176, 4078, 4049, 3779, 1022, 4080, 4647, 4648, 4082, 4083, 3782, 1027, 1028, 4649, 231, 4650, 4651, 4086, 4652, 4653, 1261, 731, 4654 ],
  ),
  "bomb": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf568,
    categories: [ 3 ],
    tags: [ 469, 688, 4655, 4656, 4657, 4658, 4659, 4660, 4661, 4662, 4663, 4664, 3176, 4665, 4666, 4667, 4668, 3104, 4669, 4670, 4671, 697, 4647, 4672, 4673, 4674, 4675, 4676, 4677, 4678, 4679, 1261, 4680, 4681 ],
  ),
  "book": SymbolsMetadata(
    popularity: 4714,
    codepoint: 0xe865,
    categories: [ 12 ],
    tags: [ 4682, 3115, 1910, 1670, 4683, 3455, 1913, 4684, 4685, 1347, 3153, 3578, 1530, 1453, 135, 4686, 18, 3375, 4687, 2159, 1533, 4688, 2506, 2507, 75, 4270, 2368, 1664, 3158, 4689, 4690, 2384, 4691 ],
  ),
  "book_2": SymbolsMetadata(
    popularity: 91,
    codepoint: 0xf53e,
    categories: [ 12 ],
    tags: [ 1910, 4692, 1670, 3455, 1042, 4693, 1347, 4694, 3153, 3578, 135, 3461, 4686, 18, 4695, 3375, 2159, 3462, 4696, 4697, 4698, 1534, 4699, 2506, 2507, 4270, 4359, 2368, 1664, 3158, 4689, 4700, 2384, 4691 ],
  ),
  "book_3": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf53d,
    categories: [ 12 ],
    tags: [ 685, 4701, 4, 2501, 1910, 1670, 1042, 4702, 4693, 1347, 4694, 3153, 4703, 3578, 135, 3461, 4686, 18, 4695, 3375, 4704, 2159, 3462, 4697, 3463, 4699, 2506, 2507, 4270, 4359, 2368, 1664, 3158, 4689, 4700, 2384, 38, 4691 ],
  ),
  "book_4": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf53c,
    categories: [ 12 ],
    tags: [ 534, 4701, 1910, 1670, 3455, 2155, 3458, 1347, 3153, 3578, 4705, 135, 3461, 4686, 18, 4695, 3375, 2159, 3462, 4697, 3463, 3464, 4699, 2506, 2507, 4270, 4359, 2368, 1664, 2570, 4706, 2510, 4689, 2384, 4691, 1745 ],
  ),
  "book_5": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf53b,
    categories: [ 12 ],
    tags: [ 564, 1910, 1670, 3455, 2155, 3458, 1347, 3153, 3578, 4707, 135, 3461, 4686, 18, 4695, 3375, 2159, 3462, 4708, 3463, 1534, 4699, 2506, 2507, 4270, 2368, 1664, 2570, 4709, 2510, 4689, 2384, 4691 ],
  ),
  "book_6": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf3df,
    categories: [ 12 ],
    tags: [ 4701, 4, 2501, 1910, 1670, 4702, 1347, 696, 2299, 3153, 4703, 3578, 14, 135, 3461, 4686, 18, 4695, 3375, 4704, 2159, 4699, 2506, 2507, 4270, 2368, 1664, 3158, 4689, 4700, 2384, 38, 4691, 702, 1536, 704 ],
  ),
  "book_online": SymbolsMetadata(
    popularity: 1465,
    codepoint: 0xf217,
    categories: [ 11 ],
    tags: [ 1109, 1110, 755, 4710, 1229, 1015, 1910, 1936, 2062, 1113, 267, 4711, 1636, 445, 88, 4712, 956, 4713, 3216, 3337, 4714, 2094, 4715, 1917, 965, 1114, 788, 219, 1675, 4716, 4717, 819, 656, 96, 2028, 226, 840, 75, 1924, 77, 2997, 446, 447, 3412, 791, 2022, 4622, 1842, 4718, 2387 ],
  ),
  "book_ribbon": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf3e7,
    categories: [ 6 ],
    tags: [ 1910, 1670, 3455, 4684, 4685, 1347, 3153, 3578, 135, 3461, 4686, 18, 4695, 3375, 2159, 3462, 4696, 1641, 3463, 1534, 28, 4699, 2506, 2507, 4270, 2368, 1664, 2510, 4689, 4690, 2384, 4691 ],
  ),
  "bookmark": SymbolsMetadata(
    popularity: 13342,
    codepoint: 0xe866,
    categories: [ 6 ],
    tags: [ 526, 2151, 2501, 1038, 1670, 1062, 4719, 1347, 4013, 3578, 4720, 1251, 18, 4721, 2159, 935, 1641, 1361, 1534, 1048, 2506, 2507, 4270, 1030, 911, 2368, 1664, 288, 1070, 2384, 314, 4722, 2664, 1053 ],
  ),
  "bookmark_add": SymbolsMetadata(
    popularity: 2191,
    codepoint: 0xe598,
    categories: [ 6 ],
    tags: [ 192, 526, 4723, 4724, 4725, 1670, 4726, 4727, 4728, 4729, 1062, 1201, 3578, 4730, 4720, 215, 935, 1641, 763, 4731, 1534, 202, 4732, 2507, 4733, 75, 4270, 2368, 1664, 4734, 4735, 35, 441, 1691 ],
  ),
  "bookmark_added": SymbolsMetadata(
    popularity: 1521,
    codepoint: 0xe599,
    categories: [ 6 ],
    tags: [ 526, 4723, 4736, 1549, 1670, 4737, 1630, 1631, 1632, 1633, 1636, 4269, 1062, 1639, 3578, 4738, 4720, 1641, 4739, 1643, 4733, 4270, 2368, 1664, 4734, 4740, 288, 2487, 441, 1647, 2386, 1523, 1650 ],
  ),
  "bookmark_bag": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf410,
    categories: [ 6 ],
    tags: [ 2013, 2151, 3719, 4741, 1670, 3723, 1484, 3578, 4720, 1917, 3489, 1501, 1581, 18, 2159, 3726, 21, 909, 4742, 2506, 2507, 75, 4270, 1030, 2368, 1664, 4740, 841, 4743, 32, 4744, 2384, 4745, 2023, 1504, 4746, 4747, 1981, 1591, 2024, 4748 ],
  ),
  "bookmark_check": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf457,
    categories: [ 6 ],
    tags: [ 2716, 526, 4736, 1549, 2480, 2151, 1670, 1630, 1632, 1633, 4749, 1636, 2376, 1639, 2909, 3578, 4738, 3065, 4720, 1251, 18, 2159, 1641, 1643, 4750, 2506, 2507, 4733, 4270, 2368, 1664, 4271, 288, 4751, 2384, 1646, 1647, 2385, 2387, 1523, 1650 ],
  ),
  "bookmark_flag": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf456,
    categories: [ 6 ],
    tags: [ 469, 2151, 1670, 1631, 4752, 1484, 1550, 3578, 4738, 4720, 4753, 4754, 15, 3019, 1251, 18, 3343, 4721, 2159, 1001, 1641, 21, 4755, 198, 4756, 486, 1493, 1495, 4757, 4758, 2506, 2507, 4733, 4270, 1030, 1353, 2368, 1664, 607, 108, 2384, 4759, 1645, 1648, 2165, 4760, 4761 ],
  ),
  "bookmark_heart": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf455,
    categories: [ 6 ],
    tags: [ 4762, 4763, 4764, 2151, 1670, 4765, 3578, 4766, 4720, 4455, 4767, 1251, 18, 2159, 1560, 4768, 4769, 21, 4770, 4771, 2506, 2507, 4733, 75, 4270, 2368, 4772, 4773, 1664, 4774, 311, 3586, 2384, 4775, 4776 ],
  ),
  "bookmark_manager": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf7b1,
    categories: [ 6 ],
    tags: [ 2151, 1367, 1670, 4777, 4729, 1731, 2155, 693, 4778, 1201, 1735, 10, 1528, 1347, 4779, 1853, 1654, 696, 4780, 2299, 4738, 1530, 4781, 1656, 4782, 4783, 966, 2159, 1755, 4784, 1740, 763, 98, 4785, 2693, 2694, 202, 4733, 1664, 4786, 4787, 674, 35, 1260, 1536, 704 ],
  ),
  "bookmark_remove": SymbolsMetadata(
    popularity: 723,
    codepoint: 0xe59a,
    categories: [ 6 ],
    tags: [ 2151, 1670, 895, 4788, 1631, 1062, 897, 4789, 1347, 3578, 4720, 2159, 21, 1116, 1534, 2507, 4733, 4270, 911, 4790, 2368, 1664, 1122, 4791, 4792, 4793, 4794, 4795, 1691 ],
  ),
  "bookmark_star": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf454,
    categories: [ 6 ],
    tags: [ 2151, 1038, 3575, 1670, 4796, 4797, 3578, 4738, 4798, 4799, 4800, 4720, 3019, 1251, 4801, 18, 2159, 1641, 21, 4802, 4803, 3582, 286, 102, 2506, 2507, 4733, 4270, 1030, 2368, 1664, 4271, 3586, 3264, 4804, 4805, 2384, 314 ],
  ),
  "bookmarks": SymbolsMetadata(
    popularity: 3349,
    codepoint: 0xe98b,
    categories: [ 6 ],
    tags: [ 2151, 1670, 4729, 2155, 1062, 1347, 3578, 4738, 4720, 4753, 18, 4721, 1065, 1066, 2159, 1641, 21, 2557, 1361, 1534, 2506, 2507, 4733, 4270, 2368, 4806, 1664, 4271, 107, 1069, 4807, 2384, 315 ],
  ),
  "books_movies_and_music": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xef82,
    categories: [ 15 ],
    tags: [ 1129, 4808, 1910, 4809, 4810, 2155, 4811, 1042, 4812, 1347, 4694, 3153, 3337, 4813, 1530, 3375, 2159, 367, 4814, 278, 4815, 3541, 328, 2081, 4816, 3463, 2162, 2163, 1152, 342, 41 ],
  ),
  "border_all": SymbolsMetadata(
    popularity: 381,
    codepoint: 0xe228,
    categories: [ 12 ],
    tags: [ 2325, 1230, 1367, 349, 4817, 7, 3639, 802, 1269, 1370, 1528, 696, 2299, 1371, 538, 274, 246, 306, 2753, 98, 1361, 1068, 75, 1376, 371, 2264, 4786, 1379, 32, 4818, 945, 1380, 38, 40, 317, 1054, 704 ],
  ),
  "border_bottom": SymbolsMetadata(
    popularity: 121,
    codepoint: 0xe229,
    categories: [ 12 ],
    tags: [ 349, 4819, 2188, 4820, 4821, 3639, 802, 1042, 2448, 2449, 1370, 1528, 1347, 696, 2299, 1371, 1372, 2175, 246, 1205, 306, 1376, 1377, 4822, 4786, 1379, 944, 4818, 1380, 38, 2230, 40, 3735, 2498, 4823, 2185, 704 ],
  ),
  "border_clear": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xe22a,
    categories: [ 12 ],
    tags: [ 2170, 349, 4824, 994, 3639, 3436, 2448, 2449, 4825, 897, 1528, 236, 696, 2299, 1371, 1372, 246, 306, 2753, 4826, 3841, 3635, 4827, 911, 4828, 4829, 426, 4786, 105, 1379, 32, 944, 4818, 945, 1380, 38, 3637, 3426, 40, 704 ],
  ),
  "border_color": SymbolsMetadata(
    popularity: 4683,
    codepoint: 0xe22b,
    categories: [ 12 ],
    tags: [ 1128, 2325, 349, 4830, 1731, 693, 1042, 1201, 1735, 299, 1528, 1347, 2834, 696, 2299, 1371, 1372, 1205, 1602, 21, 1740, 1532, 1534, 2693, 2694, 75, 4786, 1379, 4818, 2182, 38, 40, 2498, 4823, 1536, 704 ],
  ),
  "border_horizontal": SymbolsMetadata(
    popularity: 138,
    codepoint: 0xe22c,
    categories: [ 12 ],
    tags: [ 1593, 2170, 2940, 349, 4831, 2188, 3639, 802, 1042, 2448, 2449, 1370, 4832, 1528, 696, 2299, 1371, 1372, 2175, 246, 2176, 306, 1602, 940, 98, 75, 1376, 1377, 2264, 4822, 4786, 1378, 4833, 1379, 32, 944, 4818, 945, 1380, 38, 1124, 40, 704 ],
  ),
  "border_inner": SymbolsMetadata(
    popularity: 116,
    codepoint: 0xe22d,
    categories: [ 12 ],
    tags: [ 2169, 2170, 349, 994, 1202, 2448, 2449, 1370, 1528, 956, 236, 696, 2299, 1371, 2628, 274, 246, 4834, 4835, 2795, 4836, 306, 459, 366, 4837, 2263, 1068, 202, 1496, 75, 1377, 2264, 4786, 2248, 1379, 32, 4818, 945, 38, 40, 1054, 704 ],
  ),
  "border_left": SymbolsMetadata(
    popularity: 118,
    codepoint: 0xe22e,
    categories: [ 12 ],
    tags: [ 2167, 2169, 349, 4838, 4839, 4840, 3639, 1368, 1042, 2272, 2448, 2449, 1528, 696, 2299, 1371, 1372, 2175, 246, 2225, 306, 1375, 2226, 4841, 4842, 1534, 2180, 4786, 1379, 944, 4818, 1380, 38, 2183, 4843, 2231, 40, 1215, 704 ],
  ),
  "border_outer": SymbolsMetadata(
    popularity: 179,
    codepoint: 0xe22f,
    categories: [ 12 ],
    tags: [ 2169, 2170, 349, 994, 7, 1269, 2919, 2448, 2449, 1528, 956, 236, 696, 2299, 1371, 787, 2628, 274, 246, 306, 459, 4837, 4844, 1361, 3841, 2263, 1068, 3635, 1006, 75, 2247, 2281, 4786, 2248, 1379, 32, 944, 4818, 945, 38, 40, 1054, 704 ],
  ),
  "border_right": SymbolsMetadata(
    popularity: 103,
    codepoint: 0xe230,
    categories: [ 12 ],
    tags: [ 2169, 1367, 349, 4845, 3639, 802, 1042, 2448, 2449, 1370, 4832, 1528, 1347, 236, 696, 2299, 1371, 274, 246, 306, 98, 1534, 1770, 1396, 4846, 1376, 1377, 4822, 4786, 2238, 2993, 1378, 1379, 4818, 945, 1380, 38, 40, 1381, 1054, 704 ],
  ),
  "border_style": SymbolsMetadata(
    popularity: 195,
    codepoint: 0xe231,
    categories: [ 12 ],
    tags: [ 1128, 349, 4839, 994, 4847, 4848, 1042, 1062, 2448, 2449, 1577, 1370, 1528, 1347, 1579, 236, 696, 2299, 1371, 1372, 274, 306, 1361, 1534, 1770, 4849, 75, 2247, 1377, 4850, 371, 4822, 311, 4786, 1379, 32, 4818, 945, 2182, 38, 40, 1054, 704 ],
  ),
  "border_top": SymbolsMetadata(
    popularity: 117,
    codepoint: 0xe232,
    categories: [ 12 ],
    tags: [ 2169, 1367, 349, 4851, 3639, 802, 1042, 2448, 2449, 10, 1370, 1528, 1347, 696, 2299, 1371, 1372, 246, 4852, 2176, 306, 1602, 92, 98, 1534, 75, 1376, 1377, 2264, 4786, 1379, 32, 4818, 945, 1380, 38, 1124, 4853, 40, 704 ],
  ),
  "border_vertical": SymbolsMetadata(
    popularity: 153,
    codepoint: 0xe233,
    categories: [ 12 ],
    tags: [ 2169, 1367, 349, 4854, 802, 2448, 2449, 1370, 4832, 1528, 696, 2299, 1371, 1372, 2175, 246, 306, 940, 2227, 3421, 4855, 1377, 2264, 4822, 4786, 1378, 1379, 4818, 1380, 38, 2183, 2230, 2251, 4856, 40, 1381, 2199, 4857, 4858, 1054, 704 ],
  ),
  "borg": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf40d,
    categories: [ 2 ],
    tags: [ 3325, 4859, 4860, 4861, 7, 4862, 4863, 4864, 211, 4865, 1269, 408, 10, 3419, 4866, 1659, 930, 1661, 4867, 1064, 935, 4868, 223, 2424, 32, 945, 2632, 551 ],
  ),
  "bottom_app_bar": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xe730,
    categories: [ 2 ],
    tags: [ 1229, 4869, 3621, 1230, 1343, 2188, 4870, 4871, 4872, 4873, 4874, 383, 2750, 299, 1370, 4832, 2522, 4875, 1205, 2751, 306, 1602, 788, 219, 2645, 4876, 4877, 4878, 327, 421, 4879, 1770, 226, 78, 330, 1377, 2882, 1378, 32, 447, 2757, 4880, 792, 2759, 1691, 1053, 1054 ],
  ),
  "bottom_drawer": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xe72d,
    categories: [ 2 ],
    tags: [ 1229, 1230, 2188, 4881, 4882, 4883, 2896, 4864, 2750, 1269, 1042, 299, 2983, 787, 1078, 900, 2751, 1065, 306, 788, 219, 4884, 327, 421, 1081, 1770, 226, 4885, 75, 2948, 330, 4786, 2997, 2882, 4787, 4886, 32, 447, 1214, 2757, 4887, 2759, 1691, 1053, 1054 ],
  ),
  "bottom_navigation": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xe98c,
    categories: [ 2 ],
    tags: [ 1229, 4869, 1230, 1343, 2188, 4871, 4888, 4873, 4889, 2750, 299, 4875, 2751, 306, 1602, 788, 219, 2645, 4877, 4878, 327, 421, 4879, 1770, 226, 75, 190, 78, 330, 2882, 32, 4890, 447, 4807, 2757, 4880, 792, 2759, 1691, 4891, 1053, 4892, 1054 ],
  ),
  "bottom_panel_close": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf72a,
    categories: [ 2 ],
    tags: [ 4893, 380, 2188, 4874, 4894, 2871, 2950, 2981, 2896, 269, 388, 3615, 2651, 2924, 2983, 2735, 900, 4895, 4896, 306, 2928, 4897, 4884, 421, 1081, 1770, 3421, 4786, 4898, 4899, 1701, 1054, 2746 ],
  ),
  "bottom_panel_open": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf729,
    categories: [ 2 ],
    tags: [ 1229, 380, 2052, 2188, 4874, 2871, 2862, 4900, 1943, 388, 12, 2983, 787, 4901, 1078, 306, 2315, 788, 4878, 421, 2653, 1770, 3421, 4902, 2948, 1377, 4786, 2997, 4886, 4899, 314, 1701, 1676, 2916, 1054, 2746 ],
  ),
  "bottom_right_click": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf684,
    categories: [ 2 ],
    tags: [ 380, 2650, 419, 2188, 4903, 4904, 4905, 1776, 4906, 4907, 4908, 1062, 4909, 1781, 388, 832, 2840, 3016, 3759, 1001, 788, 3020, 4910, 421, 1783, 1496, 1396, 4911, 4912, 4913, 288, 371, 2935, 32, 36 ],
  ),
  "bottom_sheets": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe98d,
    categories: [ 2 ],
    tags: [ 1229, 1230, 2188, 4914, 2896, 4864, 2750, 299, 2983, 787, 2751, 1066, 306, 788, 219, 4884, 327, 656, 4915, 1081, 1770, 3421, 226, 4902, 330, 4786, 4916, 2882, 4886, 107, 1069, 447, 2344, 2757, 2759, 317, 42, 1691, 1053, 1054, 1084 ],
  ),
  "box": SymbolsMetadata(
    popularity: 75,
    codepoint: 0xf5a4,
    categories: [ 9 ],
    tags: [ 1670, 7, 4917, 1269, 408, 1019, 2210, 3578, 4918, 1251, 3895, 18, 3896, 1641, 4919, 96, 2647, 4920, 1409, 4921, 1622, 1030, 2368, 1664, 4922, 4604, 841, 674, 532, 2384, 441, 3902 ],
  ),
  "box_add": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf5a5,
    categories: [ 9 ],
    tags: [ 192, 526, 1262, 1264, 4923, 4924, 4925, 1057, 2151, 7, 4917, 1269, 1201, 4926, 4927, 1019, 1206, 1044, 763, 1274, 4928, 2647, 4920, 202, 1277, 4929, 1409, 4921, 1622, 4922, 4604, 674 ],
  ),
  "box_edit": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf5a6,
    categories: [ 9 ],
    tags: [ 1128, 1726, 2488, 1670, 7, 4930, 1731, 693, 1269, 2376, 1201, 1735, 1019, 1347, 1853, 696, 4931, 2299, 1530, 966, 1740, 1532, 2647, 4920, 2693, 2694, 2695, 75, 2497, 1664, 4604, 441, 1260, 1536, 704 ],
  ),
  "boy": SymbolsMetadata(
    popularity: 1515,
    codepoint: 0xeb67,
    categories: [ 3 ],
    tags: [ 468, 470, 4932, 83, 584, 4933, 4934, 862, 4935, 1791, 483, 16, 870, 4936, 1803, 4937, 4938, 1361, 488, 489, 3172, 1967, 490, 4939, 105, 607, 4940, 750, 35, 501, 4941 ],
  ),
  "brand_awareness": SymbolsMetadata(
    popularity: 489,
    codepoint: 0xe98e,
    categories: [ 0 ],
    tags: [ 1073, 469, 4942, 1245, 3073, 1129, 4943, 2539, 4944, 4945, 355, 1040, 443, 269, 187, 197, 1045, 4946, 2081, 2503, 486, 4947, 4948, 1050, 4949, 204, 1665, 227, 31, 1156, 1157, 441, 344, 1745, 1902 ],
    rtlAutoMirrored: true,
  ),
  "brand_family": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf4f1,
    categories: [ 12 ],
    tags: [ 3495, 685, 4, 2778, 2539, 4950, 4951, 8, 692, 4952, 867, 14, 4953, 4954, 1372, 2175, 4955, 19, 4956, 4957, 2786, 3379, 4958, 2182, 4959, 35, 4960, 38, 2230, 40, 4961, 4962, 702 ],
  ),
  "branding_watermark": SymbolsMetadata(
    popularity: 983,
    codepoint: 0xe06b,
    categories: [ 0 ],
    tags: [ 526, 3352, 3116, 6, 2539, 2779, 2750, 1042, 3357, 3128, 299, 2970, 3577, 1372, 850, 53, 1044, 4963, 2751, 4964, 306, 2528, 1081, 3363, 59, 119, 1520, 75, 330, 2882, 32, 2728, 4965, 2757, 2759, 4966, 1691, 1053, 1054 ],
    rtlAutoMirrored: true,
  ),
  "breakfast_dining": SymbolsMetadata(
    popularity: 539,
    codepoint: 0xea54,
    categories: [ 16 ],
    tags: [ 3787, 3789, 3790, 4967, 4968, 3791, 4969, 3792, 4970, 4971, 3799, 3800, 4972, 1829, 4973, 4974, 4975, 4976, 3804, 4977, 2097, 3807, 4978, 4979, 3809, 4980, 4981 ],
  ),
  "breaking_news": SymbolsMetadata(
    popularity: 115,
    codepoint: 0xea08,
    categories: [ 12 ],
    tags: [ 3175, 469, 1245, 2501, 3073, 1400, 4982, 4983, 1693, 3176, 832, 2766, 2767, 3177, 2502, 4984, 1251, 135, 92, 4985, 1641, 367, 485, 2503, 4986, 486, 1409, 4987, 1029, 1353, 77, 1258, 35, 441, 1260, 1034, 1261 ],
  ),
  "breaking_news_alt_1": SymbolsMetadata(
    popularity: 961,
    codepoint: 0xf0ba,
    categories: [ 12 ],
    tags: [ 3175, 469, 1245, 2501, 3073, 1400, 4982, 4983, 1693, 3176, 2766, 2767, 3177, 2502, 4984, 1251, 135, 1641, 367, 2503, 4986, 486, 1409, 4988, 4758, 75, 1353, 190, 32, 1258, 35, 441, 1260, 1034, 1261 ],
  ),
  "breastfeeding": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xf856,
    categories: [ 3 ],
    tags: [ 3598, 3599, 4989, 584, 4990, 4991, 4992, 4993, 4994, 3600, 862, 3602, 865, 4995, 867, 2502, 4996, 595, 4997, 483, 4998, 3606, 4999, 871, 5000, 4768, 5001, 5002, 5003, 5004, 3607, 5005, 3609, 5006, 5007, 5008, 874, 5009, 488, 489, 5010, 495, 3612, 1905, 5011, 879 ],
  ),
  "brick": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf388,
    categories: [ 3 ],
    tags: [ 684, 2601, 1074, 5012, 4862, 798, 5013, 4864, 2832, 1201, 88, 3327, 697, 5014, 1659, 871, 4964, 5015, 2472, 5016, 5017, 4868, 5018, 26, 5019, 75, 105, 32, 107, 945, 3637, 2543, 5020 ],
  ),
  "brightness_1": SymbolsMetadata(
    popularity: 622,
    codepoint: 0xe3a6,
    categories: [ 1 ],
    tags: [ 79, 733, 1128, 1728, 47, 116, 383, 1732, 269, 4246, 12, 5021, 4080, 1738, 5022, 53, 126, 2472, 3680, 974, 4253, 1361, 61, 121, 177, 1257, 330, 310, 41, 317, 5023, 986 ],
  ),
  "brightness_2": SymbolsMetadata(
    popularity: 401,
    codepoint: 0xe3a7,
    categories: [ 1 ],
    tags: [ 81, 1128, 4243, 4212, 1728, 4244, 383, 269, 4246, 4247, 5024, 3691, 4251, 5025, 2472, 4252, 4253, 4220, 4254, 329, 330, 3685, 65, 5026, 1929, 313, 5027, 314, 4260, 5028, 731 ],
  ),
  "brightness_3": SymbolsMetadata(
    popularity: 469,
    codepoint: 0xe3a8,
    categories: [ 1 ],
    tags: [ 82, 4040, 3666, 4243, 4212, 1728, 4244, 383, 269, 4246, 4247, 5024, 3691, 4250, 4251, 2472, 3713, 4252, 4253, 4220, 4254, 3715, 330, 3685, 310, 1929, 5029, 374, 4047, 4260, 5028 ],
  ),
  "brightness_4": SymbolsMetadata(
    popularity: 879,
    codepoint: 0xe3a9,
    categories: [ 1 ],
    tags: [ 534, 3325, 3666, 1728, 383, 269, 4246, 5024, 3691, 3672, 5030, 538, 1659, 16, 5031, 2472, 5032, 3680, 5033, 4253, 4220, 4254, 1662, 5034, 330, 3685, 65, 3699, 3264, 3686, 35 ],
  ),
  "brightness_5": SymbolsMetadata(
    popularity: 1017,
    codepoint: 0xe3aa,
    categories: [ 1 ],
    tags: [ 564, 1128, 3670, 1728, 383, 269, 4246, 5035, 12, 3257, 4043, 3674, 2471, 3677, 5036, 2472, 3680, 5037, 5038, 327, 4253, 3641, 5039, 3683, 330, 310, 3699, 3264, 3686, 4208, 731 ],
  ),
  "brightness_6": SymbolsMetadata(
    popularity: 1583,
    codepoint: 0xe3ab,
    categories: [ 1 ],
    tags: [ 5040, 580, 1128, 3666, 1728, 3702, 383, 269, 4246, 3691, 12, 5041, 3257, 1659, 5042, 5043, 2472, 3680, 5044, 4045, 327, 4253, 4138, 1662, 330, 3685, 310, 65, 3699, 3264, 3686 ],
  ),
  "brightness_7": SymbolsMetadata(
    popularity: 602,
    codepoint: 0xe3ac,
    categories: [ 1 ],
    tags: [ 636, 1128, 3670, 1728, 3702, 3703, 3704, 383, 269, 4246, 5045, 12, 3257, 1659, 3674, 2471, 3676, 5036, 2472, 5046, 3680, 5037, 5038, 327, 4253, 2097, 3683, 330, 310, 641, 3699, 3264, 3686, 4208 ],
  ),
  "brightness_alert": SymbolsMetadata(
    popularity: 105,
    codepoint: 0xf5cf,
    categories: [ 4 ],
    tags: [ 3175, 469, 3073, 6, 3670, 1728, 1693, 269, 3775, 3176, 12, 2766, 2767, 5047, 480, 2471, 3019, 1251, 5036, 2769, 2472, 3680, 1641, 219, 327, 486, 5048, 226, 1363, 2772, 1353, 330, 310, 3264, 3686, 1034, 1261 ],
  ),
  "brightness_auto": SymbolsMetadata(
    popularity: 271,
    codepoint: 0xe1ab,
    categories: [ 4 ],
    tags: [ 3495, 685, 1127, 5049, 1128, 5050, 1131, 5051, 5052, 5053, 1132, 5054, 6, 1728, 5055, 3702, 269, 12, 325, 5056, 2781, 2472, 3680, 5037, 219, 327, 226, 330, 3685, 310, 65, 3264, 5057, 3686 ],
  ),
  "brightness_empty": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xf7e8,
    categories: [ 4 ],
    tags: [ 5058, 1128, 3670, 1728, 269, 3690, 3691, 3257, 4013, 1659, 901, 188, 5036, 2472, 3680, 4014, 3329, 5059, 907, 1361, 1662, 65, 311, 105, 372, 3264, 4818, 3686, 314 ],
  ),
  "brightness_medium": SymbolsMetadata(
    popularity: 480,
    codepoint: 0xe1ae,
    categories: [ 4 ],
    tags: [ 4160, 1128, 5060, 1131, 1728, 5061, 269, 785, 4246, 12, 5030, 5042, 4034, 3677, 5036, 2472, 3680, 5062, 5037, 4044, 219, 4045, 327, 656, 1770, 226, 330, 5063, 310, 65, 3699, 3264, 3686 ],
  ),
  "bring_your_own_ip": SymbolsMetadata(
    popularity: 876,
    codepoint: 0xe016,
    categories: [ 3 ],
    tags: [ 5064, 5065, 5066, 1652, 268, 211, 212, 5067, 5068, 5069, 5070, 5071, 246, 5072, 5073, 215, 5074, 5075, 5076, 5077, 223, 5078, 5079, 5080, 3761, 65, 5081, 32, 5082, 4761, 5083 ],
  ),
  "broadcast_on_home": SymbolsMetadata(
    popularity: 186,
    codepoint: 0xf8f8,
    categories: [ 0 ],
    tags: [ 1180, 2827, 355, 5084, 211, 445, 1711, 999, 3235, 1435, 16, 215, 223, 75, 5085, 2343, 3057, 1665, 3058, 227, 1901, 342, 35, 551, 441, 2085, 5086, 1902, 233, 234 ],
  ),
  "broadcast_on_personal": SymbolsMetadata(
    popularity: 235,
    codepoint: 0xf8f9,
    categories: [ 0 ],
    tags: [ 1180, 355, 5087, 211, 999, 5088, 5089, 5090, 1435, 5091, 215, 216, 5092, 5093, 223, 436, 790, 5094, 5085, 1665, 227, 228, 1901, 5095, 2057, 5086, 233, 234, 442, 5096 ],
  ),
  "broken_image": SymbolsMetadata(
    popularity: 967,
    codepoint: 0xe3ad,
    categories: [ 1 ],
    tags: [ 469, 5097, 5098, 5099, 5100, 5101, 5102, 5103, 5104, 5105, 5106, 2766, 5107, 5108, 5109, 53, 5110, 5111, 5112, 1543, 5113, 5114, 5115, 1544, 1545, 5116, 59, 61, 119, 1048, 2772, 5117, 32, 5118, 441, 5119, 5120, 5121, 1261, 5122 ],
  ),
  "browse": SymbolsMetadata(
    popularity: 133,
    codepoint: 0xeb13,
    categories: [ 6 ],
    tags: [ 1230, 1367, 5123, 1039, 5124, 1042, 955, 958, 1541, 246, 215, 306, 2159, 2557, 421, 656, 98, 3464, 3421, 4855, 2258, 371, 944, 313, 314, 317, 1691, 1053, 1054, 1084 ],
  ),
  "browse_activity": SymbolsMetadata(
    popularity: 1350,
    codepoint: 0xf8a5,
    categories: [ 2 ],
    tags: [ 989, 5123, 1039, 5125, 920, 1685, 445, 924, 12, 929, 965, 1023, 5126, 327, 4458, 5127, 5128, 189, 1353, 330, 980, 5129, 3264, 33, 947, 2852, 317, 5130, 5131, 1054 ],
  ),
  "browse_gallery": SymbolsMetadata(
    popularity: 1667,
    codepoint: 0xebd1,
    categories: [ 2 ],
    tags: [ 989, 2151, 5123, 5132, 383, 1016, 2155, 385, 1020, 5133, 958, 1541, 1023, 2159, 5126, 390, 5134, 5135, 2841, 28, 1029, 5136, 2367, 1031, 107, 289, 290, 5137, 317, 2102 ],
  ),
  "browser_updated": SymbolsMetadata(
    popularity: 646,
    codepoint: 0xe7cf,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1230, 5138, 380, 2650, 1039, 5139, 5140, 1684, 694, 1685, 445, 12, 337, 965, 1114, 1542, 1674, 215, 3513, 1687, 327, 5141, 2648, 424, 1664, 330, 5142, 5143, 1260, 5144, 533, 1691, 5145, 1054 ],
  ),
  "brunch_dining": SymbolsMetadata(
    popularity: 457,
    codepoint: 0xea73,
    categories: [ 16 ],
    tags: [ 3790, 5146, 3791, 5147, 3792, 5148, 5149, 5150, 3799, 5151, 4388, 5152, 1829, 5153, 964, 1066, 3803, 3804, 5154, 5155, 2097, 5156, 3807, 5157, 1069, 4980, 5158, 5159 ],
  ),
  "brush": SymbolsMetadata(
    popularity: 3850,
    codepoint: 0xe3ae,
    categories: [ 1 ],
    tags: [ 2829, 5160, 5161, 5162, 1201, 5163, 2332, 299, 5164, 2834, 302, 696, 2299, 1371, 305, 5165, 53, 3145, 2836, 1602, 1740, 5166, 5167, 5168, 5169, 311, 5170, 4818, 2537 ],
  ),
  "bubble": SymbolsMetadata(
    popularity: 91,
    codepoint: 0xef83,
    categories: [ 2 ],
    tags: [ 5171, 380, 419, 471, 472, 383, 384, 473, 474, 443, 476, 2969, 477, 388, 480, 777, 485, 1409, 979, 4102, 1410, 1565, 1396, 889, 2343, 1665, 31, 493, 1412, 496, 1676, 346 ],
    rtlAutoMirrored: true,
  ),
  "bubble_chart": SymbolsMetadata(
    popularity: 1317,
    codepoint: 0xe6dd,
    categories: [ 9 ],
    tags: [ 2513, 5, 1343, 365, 471, 5172, 5173, 1284, 920, 953, 10, 4291, 2847, 924, 808, 929, 933, 135, 2516, 2518, 1045, 597, 937, 5174, 189, 1353, 5175, 3857, 33, 983, 947, 5176, 1355 ],
  ),
  "bubbles": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf64e,
    categories: [ 2 ],
    tags: [ 469, 1229, 380, 2650, 419, 2188, 471, 5173, 116, 472, 383, 2950, 2896, 473, 1042, 3050, 388, 832, 2651, 337, 2652, 1542, 2863, 2338, 2751, 485, 763, 3282, 486, 1363, 2342, 75, 1396, 1664, 32, 2007, 2757, 1260, 2759, 1054 ],
  ),
  "bug_report": SymbolsMetadata(
    popularity: 6202,
    codepoint: 0xe868,
    categories: [ 6 ],
    tags: [ 469, 5177, 1180, 5178, 5179, 5180, 5181, 1184, 1185, 5182, 2766, 5183, 480, 1737, 5184, 2769, 366, 5185, 2772, 5186, 5187, 1353, 5188, 5189, 5190, 5191, 5192, 441, 5193, 1261 ],
  ),
  "build": SymbolsMetadata(
    popularity: 8095,
    codepoint: 0xe869,
    categories: [ 6 ],
    tags: [ 1128, 4862, 268, 2832, 5194, 1735, 2625, 696, 2835, 1737, 999, 5195, 5196, 1674, 2644, 2770, 5197, 2837, 1740, 1004, 656, 329, 3474, 2631, 65, 2649, 5198, 2537, 2756, 5199 ],
  ),
  "build_circle": SymbolsMetadata(
    popularity: 2594,
    codepoint: 0xef48,
    categories: [ 6 ],
    tags: [ 1128, 4862, 5200, 383, 4865, 2832, 1201, 3457, 2625, 1737, 2770, 1755, 5197, 2837, 1740, 281, 329, 3474, 65, 2649, 5198, 2537, 1260, 533, 5201, 5199 ],
  ),
  "bungalow": SymbolsMetadata(
    popularity: 262,
    codepoint: 0xe591,
    categories: [ 16 ],
    tags: [ 2599, 2601, 798, 5202, 5203, 5204, 4825, 1434, 2605, 999, 5205, 1435, 5206, 2781, 2610, 5207, 1490, 421, 1495, 5208, 1444, 2614, 1445, 2615, 1446, 2616, 823, 2617, 32, 3846, 5209, 1701, 2024 ],
  ),
  "burst_mode": SymbolsMetadata(
    popularity: 232,
    codepoint: 0xe43c,
    categories: [ 1 ],
    tags: [ 4661, 5210, 47, 5211, 116, 5212, 5213, 53, 5214, 2554, 1543, 366, 307, 1544, 1545, 5215, 2557, 5216, 59, 5217, 5218, 61, 119, 5219, 5220, 5221, 75, 2570, 32, 2586, 440, 441 ],
  ),
  "bus_alert": SymbolsMetadata(
    popularity: 456,
    codepoint: 0xe98f,
    categories: [ 14 ],
    tags: [ 3175, 3466, 469, 3073, 1814, 2062, 5222, 1815, 1816, 1693, 383, 2063, 3176, 2137, 1997, 2482, 2766, 2767, 3177, 1251, 5223, 2769, 1490, 1641, 486, 2772, 4601, 5224, 2453, 5225, 5226, 35, 1590, 2008, 1930, 1504, 1844, 1261 ],
  ),
  "bus_railway": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf36b,
    categories: [ 14 ],
    tags: [ 2014, 1814, 2062, 4596, 5227, 1815, 1816, 383, 2063, 5228, 2079, 2016, 388, 1581, 1490, 1967, 2071, 4601, 5229, 5230, 4618, 4619, 5231, 3611, 5232, 4621, 35, 4622, 5233, 5234, 4623, 2008, 5235, 1930, 5236, 1504, 5237, 1591, 1625, 1844 ],
  ),
  "business_center": SymbolsMetadata(
    popularity: 5152,
    codepoint: 0xeb3f,
    categories: [ 5 ],
    tags: [ 3719, 4741, 5238, 1284, 5239, 5240, 3723, 5241, 1730, 1285, 5242, 5243, 5244, 808, 3489, 3170, 3726, 1145, 1456, 940, 2613, 2585, 5245, 5246, 5247, 75, 5248, 32, 4744, 2537, 1459 ],
  ),
  "business_chip": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf84c,
    categories: [ 12 ],
    tags: [ 5249, 6, 3719, 4741, 5238, 1284, 298, 5240, 5241, 5250, 383, 1269, 5251, 808, 16, 815, 3170, 936, 1456, 5185, 5245, 5246, 1519, 1520, 5247, 3331, 1011, 2631, 4744, 35, 1459 ],
  ),
  "business_messages": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xef84,
    categories: [ 7 ],
    tags: [ 419, 3005, 471, 1284, 5252, 5253, 5254, 472, 473, 443, 476, 5255, 478, 2450, 2627, 1672, 480, 1542, 485, 2341, 2342, 75, 1410, 1411, 2343, 1665, 493, 494, 32, 5256, 313, 496, 38, 2007 ],
    rtlAutoMirrored: true,
  ),
  "buttons_alt": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xe72f,
    categories: [ 2 ],
    tags: [ 192, 5257, 949, 526, 298, 952, 383, 4864, 1733, 3233, 269, 5258, 1201, 1202, 1735, 445, 1711, 787, 5259, 697, 5260, 1207, 966, 2751, 789, 763, 656, 1770, 202, 1212, 1213, 75, 77, 65, 551 ],
  ),
  "cabin": SymbolsMetadata(
    popularity: 494,
    codepoint: 0xe589,
    categories: [ 16 ],
    tags: [ 2599, 2601, 798, 5203, 3722, 5261, 5262, 5204, 1817, 2605, 5263, 2018, 999, 2080, 1435, 366, 2610, 5126, 5264, 1490, 1495, 2614, 2615, 1446, 2616, 2978, 823, 5265, 2617, 5266, 1069, 3846, 2586, 1504, 5209, 1701, 2024, 5267, 5268 ],
  ),
  "cable": SymbolsMetadata(
    popularity: 1340,
    codepoint: 0xefe6,
    categories: [ 4 ],
    tags: [ 5269, 1129, 5270, 382, 4362, 5271, 921, 211, 4363, 4364, 445, 1711, 5272, 965, 5273, 966, 5274, 1602, 935, 223, 1719, 4371, 2534, 3782, 227, 551, 2007, 5275, 41, 4378 ],
  ),
  "cable_car": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf479,
    categories: [ 14 ],
    tags: [ 5276, 1814, 7, 5277, 5278, 5279, 1815, 1816, 5280, 383, 388, 5281, 5282, 2018, 1490, 1544, 5283, 2071, 4601, 5230, 4618, 4619, 5284, 5285, 3348, 5286, 5287, 4621, 5288, 2023, 4622, 4623, 2008, 1842, 1930, 1504, 1625, 2024, 1844, 732, 5289 ],
  ),
  "cached": SymbolsMetadata(
    popularity: 5473,
    codepoint: 0xe86a,
    categories: [ 2 ],
    tags: [ 2284, 419, 2565, 5290, 3521, 3522, 384, 2907, 3523, 385, 2627, 3524, 3513, 2568, 3525, 390, 5291, 2492, 424, 425, 2494, 426, 3516, 2496, 396, 397, 674, 5256, 1667, 3529, 2007, 2499, 1260 ],
  ),
  "cadence": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf4b4,
    categories: [ 15 ],
    tags: [ 5292, 4309, 1129, 365, 5293, 5294, 1182, 5295, 920, 5296, 2332, 385, 10, 2925, 2926, 2927, 926, 277, 929, 390, 634, 937, 2081, 2082, 3635, 3570, 5297, 5298, 2931, 2932, 227, 1156, 109, 5299, 3565, 441, 2086, 1862 ],
  ),
  "cake": SymbolsMetadata(
    popularity: 3879,
    codepoint: 0xe7e9,
    categories: [ 15 ],
    tags: [ 526, 5300, 5301, 3787, 5302, 5303, 5304, 5305, 5306, 5307, 5308, 5149, 5309, 3797, 5310, 2094, 5311, 1829, 5312, 2018, 763, 487, 5313, 5314, 3806, 202, 5315, 607, 5316, 3810, 5317, 35, 5318, 5319, 5320 ],
  ),
  "cake_add": SymbolsMetadata(
    popularity: 96,
    codepoint: 0xf85b,
    categories: [ 15 ],
    tags: [ 526, 5321, 5322, 5323, 5300, 3787, 5302, 5303, 5305, 5306, 5149, 5324, 1201, 5325, 3797, 5310, 2094, 1829, 763, 5326, 5327, 487, 3806, 202, 5328, 5329, 5316, 3810 ],
  ),
  "calculate": SymbolsMetadata(
    popularity: 7486,
    codepoint: 0xea5f,
    categories: [ 9 ],
    tags: [ 192, 5330, 5331, 526, 5171, 1230, 1198, 298, 1199, 2375, 5332, 3943, 9, 5333, 1370, 5334, 2377, 5335, 2378, 1210, 2380, 1116, 3261, 202, 1622, 5336, 4475, 5337, 32, 1122, 461, 3265, 2537 ],
  ),
  "calendar_add_on": SymbolsMetadata(
    popularity: 2178,
    codepoint: 0xef85,
    categories: [ 7 ],
    tags: [ 192, 526, 5338, 5339, 5340, 1015, 1936, 5341, 5342, 5343, 1201, 5344, 1017, 5345, 5035, 2094, 5346, 5347, 763, 5348, 1211, 2838, 202, 1212, 1030, 5349, 1031, 5350, 35, 289, 5351, 5352 ],
  ),
  "calendar_apps_script": SymbolsMetadata(
    popularity: 319,
    codepoint: 0xf0bb,
    categories: [ 7 ],
    tags: [ 5353, 5340, 1015, 2148, 1936, 5341, 5354, 5355, 5344, 1017, 5035, 1018, 337, 2094, 1672, 5347, 5356, 98, 5357, 2838, 1030, 5358, 1031, 3379, 5359, 1645, 289, 5351, 5352 ],
  ),
  "calendar_clock": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xf540,
    categories: [ 6 ],
    tags: [ 5340, 1244, 469, 1015, 5360, 1246, 1936, 5341, 5361, 5342, 5362, 1016, 5363, 5364, 1017, 5365, 5035, 1018, 767, 2093, 1020, 898, 2094, 4721, 459, 5347, 486, 2838, 1030, 1031, 5350, 289, 2099, 5366, 1033, 5351, 2102, 5352 ],
  ),
  "calendar_month": SymbolsMetadata(
    popularity: 37926,
    codepoint: 0xebcc,
    categories: [ 6 ],
    tags: [ 5340, 1015, 1936, 5341, 5342, 5367, 1017, 5345, 5035, 1018, 956, 2094, 5347, 5368, 940, 5369, 2107, 1030, 2663, 1924, 1031, 5370, 32, 289, 2099, 5371, 5351, 5372 ],
  ),
  "calendar_today": SymbolsMetadata(
    popularity: 11736,
    codepoint: 0xe935,
    categories: [ 6 ],
    tags: [ 5340, 1015, 5341, 5342, 5343, 1851, 5373, 5374, 1017, 5345, 5035, 1018, 2094, 5347, 1534, 2107, 75, 1030, 1031, 5375, 32, 289, 5351, 5376, 1214, 5372, 5352 ],
  ),
  "calendar_view_day": SymbolsMetadata(
    popularity: 679,
    codepoint: 0xe936,
    categories: [ 12 ],
    tags: [ 5340, 1015, 5341, 5377, 5378, 5374, 5379, 5380, 5364, 5381, 1017, 5382, 5035, 5383, 5384, 2094, 1372, 246, 306, 5347, 5385, 2107, 75, 1030, 1031, 5386, 5387, 441, 5371, 5351, 317, 5388, 5372 ],
  ),
  "calendar_view_month": SymbolsMetadata(
    popularity: 984,
    codepoint: 0xefe7,
    categories: [ 12 ],
    tags: [ 5340, 1015, 5341, 5389, 5342, 5390, 5378, 1017, 5345, 5035, 2094, 1372, 246, 5391, 306, 2753, 5347, 5368, 5392, 940, 2107, 1030, 1031, 5393, 32, 944, 289, 5371, 5351, 317, 5372 ],
  ),
  "calendar_view_week": SymbolsMetadata(
    popularity: 735,
    codepoint: 0xefe8,
    categories: [ 12 ],
    tags: [ 5340, 1015, 5341, 5378, 802, 1017, 5035, 1018, 2094, 1372, 3860, 246, 306, 92, 5347, 5385, 2107, 1030, 1031, 5393, 5394, 289, 5395, 5371, 5351, 2253, 317, 5372, 5396, 5397 ],
  ),
  "call": SymbolsMetadata(
    popularity: 47883,
    codepoint: 0xe0b0,
    categories: [ 7 ],
    tags: [ 5398, 5171, 738, 1133, 5399, 1113, 443, 5400, 475, 5401, 3326, 445, 1308, 1309, 965, 2527, 5402, 5403, 5404, 5405, 219, 226, 5406, 5407, 1318, 5408, 1257, 495, 496, 1320, 5409, 5410 ],
  ),
  "call_end": SymbolsMetadata(
    popularity: 1803,
    codepoint: 0xe0b1,
    categories: [ 7 ],
    tags: [ 2827, 5411, 1133, 5412, 5413, 5414, 895, 1113, 443, 475, 476, 2332, 4439, 445, 3306, 5415, 2189, 5416, 3489, 1309, 5417, 965, 219, 5418, 226, 5419, 1318, 4450, 1083, 496, 438, 1320, 5420, 5421 ],
  ),
  "call_log": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xe08e,
    categories: [ 7 ],
    tags: [ 5422, 1133, 5423, 5424, 5425, 5426, 5427, 1113, 443, 5428, 475, 5429, 5430, 445, 5431, 1309, 965, 1023, 366, 92, 5126, 788, 5432, 219, 5433, 226, 5434, 5435, 5436, 5437, 1318, 5438, 1320, 441 ],
  ),
  "call_made": SymbolsMetadata(
    popularity: 1383,
    codepoint: 0xe0b2,
    categories: [ 7 ],
    tags: [ 378, 380, 1133, 5439, 776, 1062, 445, 2969, 388, 787, 1672, 1471, 777, 3080, 5440, 219, 421, 780, 2653, 5441, 5419, 781, 1396, 2343, 1665, 1412, 1214, 346, 2916 ],
    rtlAutoMirrored: true,
  ),
  "call_merge": SymbolsMetadata(
    popularity: 433,
    codepoint: 0xe0b3,
    categories: [ 7 ],
    tags: [ 1301, 1302, 380, 419, 3026, 1133, 5442, 1061, 443, 1135, 1306, 921, 5443, 5444, 445, 5445, 1064, 1312, 366, 935, 1067, 219, 5446, 226, 1320, 441, 5447, 1701, 1677, 2916 ],
    rtlAutoMirrored: true,
  ),
  "call_missed": SymbolsMetadata(
    popularity: 353,
    codepoint: 0xe0b4,
    categories: [ 7 ],
    tags: [ 380, 1133, 5448, 5449, 1630, 1632, 443, 475, 4439, 5450, 445, 2189, 5416, 5417, 1023, 5451, 4443, 5452, 5126, 3179, 5453, 219, 226, 5419, 1029, 4450, 5454, 1320, 1647, 5410 ],
    rtlAutoMirrored: true,
  ),
  "call_missed_outgoing": SymbolsMetadata(
    popularity: 382,
    codepoint: 0xe0e4,
    categories: [ 7 ],
    tags: [ 378, 380, 1133, 5424, 5425, 5455, 443, 475, 1062, 4439, 5456, 445, 1308, 3306, 5416, 5417, 3179, 5453, 5457, 219, 5458, 4187, 5441, 226, 5419, 5438, 5459, 782, 1320, 1214, 5460, 915 ],
    rtlAutoMirrored: true,
  ),
  "call_quality": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf652,
    categories: [ 7 ],
    tags: [ 5461, 469, 1245, 738, 1133, 5462, 1113, 443, 211, 475, 132, 445, 1309, 965, 482, 5463, 484, 135, 2769, 219, 223, 486, 226, 5464, 2772, 62, 1318, 2631, 227, 553, 495, 1320, 5465, 5466, 1261 ],
  ),
  "call_received": SymbolsMetadata(
    popularity: 919,
    codepoint: 0xe0b5,
    categories: [ 7 ],
    tags: [ 1627, 5467, 5171, 5468, 380, 2650, 1133, 5469, 443, 921, 475, 445, 1671, 337, 2924, 5470, 2863, 2338, 5471, 219, 226, 5419, 2070, 2342, 5472, 5473, 5474, 1319, 1320 ],
    rtlAutoMirrored: true,
  ),
  "call_split": SymbolsMetadata(
    popularity: 907,
    codepoint: 0xe0b6,
    categories: [ 7 ],
    tags: [ 380, 2868, 2052, 419, 1994, 2446, 1133, 5475, 5476, 5477, 5478, 5479, 443, 1306, 445, 2173, 3028, 5480, 1370, 2450, 2999, 2000, 219, 226, 5481, 5482, 2452, 1503, 2264, 1378, 1320, 2007, 2455 ],
    rtlAutoMirrored: true,
  ),
  "call_to_action": SymbolsMetadata(
    popularity: 571,
    codepoint: 0xe06c,
    categories: [ 0 ],
    tags: [ 949, 469, 1343, 4871, 298, 1133, 5483, 1776, 2896, 954, 2750, 269, 5484, 299, 2983, 787, 1598, 484, 135, 966, 5485, 2751, 306, 788, 485, 421, 486, 907, 909, 281, 4987, 5486, 75, 77, 330, 288, 2882, 4787, 372, 32, 1412, 313, 1689, 314, 2757, 2759, 1691, 1053, 1054 ],
  ),
  "camera": SymbolsMetadata(
    popularity: 2660,
    codepoint: 0xe3af,
    categories: [ 1 ],
    tags: [ 5487, 5488, 47, 116, 383, 384, 270, 53, 126, 367, 59, 61, 119, 1662, 121, 5489, 177, 5490, 4422, 5491, 5492, 5493, 5494, 1701, 5495, 41, 5496, 352 ],
  ),
  "camera_front": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xe3b1,
    categories: [ 1 ],
    tags: [ 380, 584, 47, 5497, 116, 1731, 383, 1135, 445, 388, 5498, 5499, 777, 5500, 5501, 483, 966, 126, 1145, 219, 5502, 489, 226, 61, 854, 5503, 490, 121, 396, 5504, 2813, 1665, 31, 32, 313, 5505, 314, 2007, 346, 501, 5506, 41, 1160 ],
  ),
  "camera_indoor": SymbolsMetadata(
    popularity: 398,
    codepoint: 0xefe9,
    categories: [ 8 ],
    tags: [ 2601, 798, 5507, 47, 5508, 350, 2605, 270, 5509, 999, 5510, 5511, 5512, 1435, 5513, 53, 2793, 5514, 2795, 2796, 5515, 5516, 327, 420, 1004, 119, 1495, 2614, 177, 1446, 2616, 1960, 1011, 5517, 2617, 1901, 2057, 351, 5518, 41, 5519, 5520, 5521, 352 ],
  ),
  "camera_outdoor": SymbolsMetadata(
    popularity: 315,
    codepoint: 0xefea,
    categories: [ 8 ],
    tags: [ 2601, 798, 47, 5522, 350, 2605, 270, 5509, 999, 5511, 5512, 1435, 5513, 53, 327, 420, 1004, 1860, 5523, 3841, 119, 1495, 1444, 5524, 1519, 2614, 121, 177, 5525, 1446, 2616, 602, 1011, 5517, 2617, 5526, 1901, 351, 41, 5527, 5520, 5521, 2102 ],
  ),
  "camera_rear": SymbolsMetadata(
    popularity: 158,
    codepoint: 0xe3b2,
    categories: [ 1 ],
    tags: [ 380, 47, 5528, 116, 383, 3456, 445, 388, 832, 1672, 5500, 2811, 966, 126, 367, 219, 5502, 1675, 1719, 226, 59, 61, 119, 854, 5529, 5530, 177, 782, 2813, 2343, 1665, 32, 2007, 346, 41, 5531 ],
  ),
  "camera_roll": SymbolsMetadata(
    popularity: 439,
    codepoint: 0xe3b3,
    categories: [ 1 ],
    tags: [ 5532, 264, 2151, 47, 5533, 116, 267, 5534, 270, 5535, 5536, 5537, 276, 1541, 53, 2159, 367, 5291, 278, 3696, 59, 61, 5538, 121, 5539, 5540, 104, 674, 2369, 41, 703 ],
  ),
  "camera_video": SymbolsMetadata(
    popularity: 63,
    codepoint: 0xf7a6,
    categories: [ 11 ],
    tags: [ 355, 5507, 5488, 47, 116, 383, 5541, 270, 5509, 965, 53, 5516, 5542, 420, 278, 5543, 119, 121, 5544, 4323, 5545, 5546, 342, 5547, 41, 5548, 1160, 5519, 5549, 1173, 540, 5550, 5521, 5551, 352, 5552 ],
  ),
  "cameraswitch": SymbolsMetadata(
    popularity: 1092,
    codepoint: 0xefeb,
    categories: [ 4 ],
    tags: [ 419, 5553, 47, 5497, 5554, 5555, 5556, 5557, 116, 1731, 5558, 383, 385, 5499, 5559, 5501, 881, 126, 59, 177, 2881, 396, 5560, 5561, 5256, 313, 5505, 314, 41, 1160, 5519, 1173, 317, 352 ],
  ),
  "campaign": SymbolsMetadata(
    popularity: 10205,
    codepoint: 0xef49,
    categories: [ 15 ],
    tags: [ 5562, 1037, 469, 1245, 355, 5563, 1040, 443, 5564, 1043, 5565, 5566, 4672, 5567, 1045, 4946, 1147, 2503, 486, 4947, 5568, 1050, 5569, 3857, 1665, 5570, 5571, 492, 1157, 496 ],
  ),
  "camping": SymbolsMetadata(
    popularity: 760,
    codepoint: 0xf8a2,
    categories: [ 15 ],
    tags: [ 2599, 989, 2464, 5572, 3722, 5573, 1202, 5574, 5575, 1659, 3724, 2018, 16, 366, 2610, 1859, 5576, 3727, 3347, 2617, 105, 35, 5577, 5578, 2023, 1504, 5579, 1701, 2024, 5580, 5581, 3736 ],
  ),
  "cancel": SymbolsMetadata(
    popularity: 40726,
    codepoint: 0xe5c9,
    categories: [ 2 ],
    tags: [ 895, 5582, 383, 3436, 2950, 5583, 1202, 5584, 2200, 896, 4439, 897, 4719, 1077, 3615, 2985, 900, 5585, 3696, 4152, 907, 4450, 911, 5586, 1083, 5587, 5588, 3736 ],
  ),
  "cancel_presentation": SymbolsMetadata(
    popularity: 1174,
    codepoint: 0xe0e9,
    categories: [ 7 ],
    tags: [ 5589, 895, 5590, 3531, 3436, 2950, 1202, 4439, 897, 445, 3615, 12, 2189, 2985, 3448, 3696, 4152, 5591, 2400, 5592, 4449, 4450, 911, 330, 4787, 2562, 1083, 5593, 3265, 1053, 1054, 3736 ],
  ),
  "cancel_schedule_send": SymbolsMetadata(
    popularity: 576,
    codepoint: 0xea39,
    categories: [ 7 ],
    tags: [ 5589, 469, 1074, 5341, 895, 383, 3436, 2950, 1202, 4439, 897, 1077, 3615, 2335, 2094, 3448, 2340, 485, 4152, 486, 5594, 4449, 4450, 1030, 911, 1031, 2343, 1665, 1083, 441, 1701, 2499, 5595, 5596, 3736 ],
  ),
  "candle": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf588,
    categories: [ 3 ],
    tags: [ 5300, 5302, 5597, 5598, 5307, 5599, 5149, 5600, 2332, 4471, 5601, 5311, 3489, 5602, 2018, 5603, 5604, 3677, 3680, 5062, 5605, 5606, 1959, 5607, 5608, 4772, 3966, 5609, 5610, 5611, 5612, 3083, 5613, 5614 ],
  ),
  "candlestick_chart": SymbolsMetadata(
    popularity: 683,
    codepoint: 0xead4,
    categories: [ 9 ],
    tags: [ 2513, 5, 584, 7, 5599, 5615, 920, 2950, 10, 2847, 924, 808, 5616, 929, 2471, 933, 815, 4014, 1291, 5617, 597, 937, 2653, 1337, 5618, 75, 33, 5619, 5620, 947, 5621, 5622, 2852, 5623, 1592, 5624 ],
  ),
  "cannabis": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf2f3,
    categories: [ 3 ],
    tags: [ 5625, 5626, 5627, 5628, 5629, 5630, 1752, 5631, 595, 5632, 5633, 5634, 5635, 5636, 5637, 817, 5638, 1760, 1859, 1835, 5639, 5640, 5641, 5642, 5643, 5644, 5645, 1905 ],
  ),
  "captive_portal": SymbolsMetadata(
    popularity: 161,
    codepoint: 0xf728,
    categories: [ 2 ],
    tags: [ 755, 380, 1039, 5646, 211, 388, 2909, 1471, 5647, 5071, 5648, 5649, 5090, 966, 215, 5650, 5651, 1375, 935, 852, 223, 2972, 819, 2653, 5652, 5653, 5654, 2631, 2913, 346, 1691, 1053, 233, 234, 4761, 5655 ],
  ),
  "capture": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf727,
    categories: [ 2 ],
    tags: [ 5656, 1229, 1230, 993, 349, 116, 1469, 2750, 5657, 1707, 5658, 1347, 274, 4043, 1673, 5659, 53, 1542, 2751, 306, 5660, 1361, 59, 119, 5661, 1496, 121, 75, 1008, 1664, 1723, 330, 5662, 5663, 5664, 288, 2882, 673, 5491, 32, 2757, 2759, 317, 1691, 1053, 1054, 5665 ],
  ),
  "car_crash": SymbolsMetadata(
    popularity: 877,
    codepoint: 0xebf2,
    categories: [ 14 ],
    tags: [ 3466, 469, 738, 1814, 3467, 3468, 1815, 5666, 1816, 383, 5667, 2765, 3176, 388, 2482, 2766, 2767, 3075, 4647, 5223, 5668, 2769, 1490, 1641, 486, 2772, 2071, 3474, 1353, 3475, 602, 2631, 1930, 1844, 1261 ],
  ),
  "car_defrost_left": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf344,
    categories: [ 14 ],
    tags: [ 707, 380, 1814, 3467, 1815, 712, 1914, 716, 269, 5669, 5670, 5671, 388, 5672, 5500, 3076, 5673, 483, 723, 1375, 366, 1922, 488, 489, 1926, 2238, 727, 1844, 730, 3978, 5674, 1902, 1054, 5675 ],
  ),
  "car_defrost_low_left": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf343,
    categories: [ 14 ],
    tags: [ 705, 707, 1846, 380, 1814, 3467, 1848, 5676, 1815, 1912, 712, 716, 269, 5669, 5670, 5671, 388, 2651, 5672, 719, 5500, 3076, 5673, 483, 723, 1375, 366, 4014, 1922, 488, 489, 1926, 35, 727, 1844, 5677, 730, 3978, 5674, 1902, 1054, 5675 ],
  ),
  "car_defrost_low_right": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf342,
    categories: [ 14 ],
    tags: [ 709, 1846, 380, 1814, 3467, 5676, 1815, 5678, 712, 713, 5669, 5670, 5671, 388, 2651, 719, 5679, 3076, 5673, 483, 723, 4014, 1922, 488, 489, 1396, 1926, 727, 1844, 730, 1054, 5680, 5675 ],
  ),
  "car_defrost_mid_low_left": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf341,
    categories: [ 14 ],
    tags: [ 707, 380, 1814, 3467, 1815, 712, 716, 269, 5669, 5670, 5671, 388, 5672, 5500, 3076, 5673, 483, 723, 1375, 366, 4014, 4044, 1922, 488, 489, 1926, 727, 1844, 5677, 730, 3978, 5674, 1902, 1054, 5680, 5675 ],
  ),
  "car_defrost_mid_right": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf340,
    categories: [ 14 ],
    tags: [ 707, 380, 1814, 3467, 1815, 712, 716, 269, 5669, 5670, 5671, 388, 5500, 3076, 5673, 483, 723, 16, 2179, 1922, 488, 489, 1396, 1926, 35, 727, 1844, 5677, 730, 3978, 5674, 5680, 5675 ],
  ),
  "car_defrost_right": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf33f,
    categories: [ 14 ],
    tags: [ 707, 1846, 380, 1814, 3467, 1848, 1815, 1912, 712, 1914, 716, 269, 2079, 5669, 5670, 5671, 388, 719, 5500, 3076, 5673, 483, 723, 366, 1922, 488, 489, 1396, 1926, 727, 1844, 730, 3978, 5674, 1902, 5675 ],
  ),
  "car_fan_low_left": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf33e,
    categories: [ 14 ],
    tags: [ 705, 1128, 709, 1846, 380, 1814, 3467, 1815, 712, 713, 1914, 717, 388, 2651, 5672, 719, 5681, 3076, 483, 723, 1375, 4014, 1922, 488, 489, 1496, 1926, 65, 727, 1844, 730 ],
  ),
  "car_fan_low_mid_left": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf33d,
    categories: [ 14 ],
    tags: [ 705, 1128, 5060, 709, 1846, 380, 1814, 3467, 1815, 712, 713, 1914, 269, 717, 718, 2969, 388, 2651, 719, 3076, 483, 723, 1375, 4014, 5682, 1922, 488, 489, 1496, 1926, 65, 727, 1844, 730 ],
  ),
  "car_fan_low_right": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf33c,
    categories: [ 14 ],
    tags: [ 705, 1128, 709, 1846, 380, 1814, 3467, 1815, 1912, 712, 713, 1914, 269, 717, 718, 388, 2651, 719, 3076, 483, 723, 4014, 1922, 488, 489, 1396, 1926, 5683, 310, 727, 1844, 730 ],
  ),
  "car_fan_mid_left": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf33b,
    categories: [ 14 ],
    tags: [ 705, 1128, 709, 1846, 380, 1814, 3467, 5684, 1815, 712, 1914, 269, 388, 719, 3076, 483, 723, 1375, 5685, 5686, 1922, 488, 489, 1496, 5687, 1926, 5683, 65, 772, 1842, 1930, 1504, 1844, 730 ],
  ),
  "car_fan_mid_low_right": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf33a,
    categories: [ 14 ],
    tags: [ 705, 1128, 5060, 709, 5688, 5689, 1846, 380, 1814, 3467, 5676, 1815, 712, 713, 1914, 269, 388, 2840, 719, 3076, 483, 723, 5690, 5691, 1922, 488, 489, 5692, 1926, 65, 727, 1677, 1844, 730 ],
  ),
  "car_fan_mid_right": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf339,
    categories: [ 14 ],
    tags: [ 705, 1128, 709, 1846, 380, 1814, 3467, 1848, 1815, 1912, 2348, 712, 1914, 269, 718, 388, 719, 3076, 5673, 483, 723, 2179, 1922, 488, 489, 1396, 1926, 5683, 727, 1844, 5677, 730 ],
  ),
  "car_fan_recirculate": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf338,
    categories: [ 14 ],
    tags: [ 705, 707, 5693, 709, 1846, 380, 1814, 3467, 5203, 1815, 5694, 5695, 712, 1914, 269, 385, 1890, 719, 3076, 723, 2795, 4836, 390, 5696, 5697, 424, 2367, 727, 1844, 730 ],
  ),
  "car_gear": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf337,
    categories: [ 14 ],
    tags: [ 1131, 5698, 5699, 5700, 1814, 3467, 1815, 5701, 5702, 5703, 5704, 4175, 4176, 268, 1735, 1737, 3471, 3485, 2770, 5197, 656, 790, 3474, 2631, 65, 5705, 533, 1844, 5706, 5707, 5708 ],
  ),
  "car_lock": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf336,
    categories: [ 14 ],
    tags: [ 755, 1244, 5709, 1131, 1814, 3467, 1815, 5710, 5711, 269, 3471, 5712, 5713, 2674, 5714, 4319, 5715, 1516, 1517, 1520, 5716, 602, 1773, 1011, 1842, 1930, 1504, 5717, 1844, 5718, 5719 ],
  ),
  "car_mirror_heat": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf335,
    categories: [ 14 ],
    tags: [ 1814, 3467, 1815, 5720, 3436, 714, 5721, 269, 5669, 5670, 5722, 5671, 5723, 3076, 5724, 724, 366, 5725, 5726, 65, 5727, 5728, 725, 3967, 727, 1844, 5023, 3978, 1902, 5729, 732 ],
  ),
  "car_rental": SymbolsMetadata(
    popularity: 680,
    codepoint: 0xea55,
    categories: [ 16 ],
    tags: [ 755, 1131, 1814, 1936, 1815, 5730, 5731, 5732, 5733, 1816, 2064, 2723, 1597, 5734, 1581, 968, 2609, 5735, 2674, 1490, 5715, 2070, 5736, 5737, 2615, 1924, 2495, 1930, 1504, 1591, 5717, 1844 ],
  ),
  "car_repair": SymbolsMetadata(
    popularity: 509,
    codepoint: 0xea56,
    categories: [ 16 ],
    tags: [ 1131, 5699, 5700, 1814, 3467, 3468, 1815, 5738, 5701, 5703, 1816, 5739, 1737, 5740, 3471, 5741, 3472, 2770, 1490, 5197, 1194, 3619, 3474, 2631, 5742, 1930, 1844, 5706, 5707, 5743 ],
  ),
  "car_tag": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf4e3,
    categories: [ 14 ],
    tags: [ 1131, 1814, 3467, 797, 1618, 1815, 5744, 5745, 5746, 5747, 5748, 5749, 799, 1816, 1619, 800, 801, 803, 1327, 805, 806, 5750, 5751, 807, 2809, 18, 2609, 21, 818, 2742, 819, 820, 821, 1337, 840, 5737, 3898, 3322, 841, 2824, 2384, 5752, 1930, 1504, 463, 1844 ],
  ),
  "card_membership": SymbolsMetadata(
    popularity: 1963,
    codepoint: 0xe8f7,
    categories: [ 9 ],
    tags: [ 755, 5753, 6, 5754, 797, 1670, 799, 5755, 800, 2719, 801, 803, 1327, 805, 829, 806, 830, 807, 5756, 5757, 808, 5758, 5759, 853, 3118, 818, 819, 820, 821, 5760, 531, 5761, 75, 5762, 5763, 2368, 1664, 5764, 841, 532, 5765, 5766, 5767 ],
  ),
  "card_travel": SymbolsMetadata(
    popularity: 863,
    codepoint: 0xe8f8,
    categories: [ 9 ],
    tags: [ 2014, 3719, 4741, 797, 5238, 5768, 799, 5769, 5770, 800, 801, 803, 2063, 1327, 805, 806, 2016, 1484, 807, 808, 3489, 2018, 1581, 3726, 3118, 5771, 818, 819, 1922, 820, 821, 2585, 75, 4744, 2023, 1842, 1930, 1504, 1591, 2024, 4605, 5772 ],
  ),
  "cardio_load": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf4b9,
    categories: [ 3 ],
    tags: [ 989, 4764, 5773, 5774, 4452, 10, 2925, 5775, 3578, 2926, 2927, 5776, 595, 1753, 4455, 5777, 5778, 3569, 5036, 934, 1560, 3513, 2568, 4768, 597, 1757, 937, 327, 5779, 28, 3570, 5780, 5781, 5782, 5783, 4461, 1905, 3596 ],
  ),
  "cardiology": SymbolsMetadata(
    popularity: 78,
    codepoint: 0xe09c,
    categories: [ 3 ],
    tags: [ 5773, 5774, 4452, 5784, 1749, 1751, 5785, 5786, 5787, 2927, 595, 3863, 1753, 4455, 5788, 5778, 3569, 1754, 5789, 597, 1757, 1760, 327, 1762, 3570, 5298, 5790, 4461, 4646, 1905 ],
  ),
  "cards": SymbolsMetadata(
    popularity: 100,
    codepoint: 0xe991,
    categories: [ 2 ],
    tags: [ 1229, 5791, 1230, 2749, 1367, 5792, 5123, 5793, 2155, 2750, 1042, 2515, 299, 958, 538, 1541, 246, 930, 2751, 306, 2159, 219, 5794, 327, 2557, 656, 98, 4855, 226, 5795, 330, 3423, 2882, 944, 5796, 447, 2757, 2759, 317, 1691, 1053, 1054 ],
  ),
  "cards_star": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf375,
    categories: [ 9 ],
    tags: [ 3575, 1670, 4729, 799, 5793, 2155, 5797, 3578, 4738, 4798, 1541, 3019, 5798, 53, 5799, 1251, 4964, 1066, 2557, 59, 5800, 119, 5801, 2560, 99, 4758, 3582, 286, 102, 1664, 5802, 288, 371, 3586, 107, 1069, 3264, 4805 ],
  ),
  "carpenter": SymbolsMetadata(
    popularity: 518,
    codepoint: 0xf1f8,
    categories: [ 16 ],
    tags: [ 4382, 4862, 5803, 798, 5804, 5805, 2832, 5806, 5807, 5808, 5809, 5810, 3489, 5811, 5812, 5813, 5814, 2770, 5815, 3474, 5816, 5817, 5818, 5819, 2537, 5267, 5820, 5743 ],
  ),
  "carry_on_bag": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xeb08,
    categories: [ 16 ],
    tags: [ 2013, 2014, 3719, 4741, 5821, 3723, 5822, 2016, 1917, 3489, 2018, 1581, 366, 3726, 909, 5823, 2585, 75, 5824, 4744, 2023, 1842, 1504, 1591, 1625, 2024, 773 ],
  ),
  "carry_on_bag_checked": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xeb0b,
    categories: [ 16 ],
    tags: [ 1627, 1907, 1932, 5825, 1549, 2480, 3719, 4741, 5821, 3723, 5770, 1630, 5826, 1632, 383, 1633, 2481, 1917, 5827, 3726, 1643, 909, 5828, 4328, 288, 4744, 1647, 1504, 5829, 1591, 2385, 1650 ],
  ),
  "carry_on_bag_inactive": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xeb0a,
    categories: [ 16 ],
    tags: [ 1932, 2013, 3719, 894, 895, 3723, 5830, 5770, 383, 3302, 897, 2969, 767, 898, 1917, 899, 901, 1602, 3726, 4152, 907, 909, 4448, 75, 911, 912, 914, 2126, 4744, 1504, 915 ],
  ),
  "carry_on_bag_question": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xeb09,
    categories: [ 16 ],
    tags: [ 4095, 1907, 2013, 5831, 738, 3719, 4741, 5832, 5833, 3723, 5830, 5770, 5834, 5835, 1917, 5836, 5827, 482, 484, 135, 3726, 5837, 5838, 909, 979, 4102, 4103, 4744, 495, 35, 1504, 5839, 5840, 1591, 1364 ],
  ),
  "cases": SymbolsMetadata(
    popularity: 1119,
    codepoint: 0xe992,
    categories: [ 9 ],
    tags: [ 5841, 3719, 4741, 5238, 1284, 5240, 5241, 5842, 1269, 1062, 5243, 1655, 3489, 3170, 3759, 1066, 3726, 936, 1456, 940, 5245, 5246, 3156, 5247, 75, 32, 107, 674, 4744, 3159, 1459 ],
  ),
  "casino": SymbolsMetadata(
    popularity: 1671,
    codepoint: 0xeb40,
    categories: [ 16 ],
    tags: [ 564, 5843, 5844, 5845, 5846, 5847, 5848, 5849, 408, 5850, 5851, 956, 3337, 4707, 5852, 5853, 5854, 5855, 697, 5856, 5014, 5857, 5858, 2613, 2162, 5859, 5860, 3347, 5861, 5540, 5862, 32, 5863, 5864 ],
  ),
  "cast": SymbolsMetadata(
    popularity: 1620,
    codepoint: 0xe307,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2051, 2053, 1684, 5865, 921, 211, 1685, 445, 12, 965, 1114, 1687, 367, 5866, 5725, 5867, 327, 1719, 2400, 3156, 5868, 330, 5869, 5870, 1665, 3058, 227, 5871, 2057, 342, 343, 344, 1691, 233, 1054, 234 ],
  ),
  "cast_connected": SymbolsMetadata(
    popularity: 573,
    codepoint: 0xe308,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2051, 2827, 1129, 355, 2053, 1684, 5865, 921, 922, 211, 1685, 445, 12, 2996, 965, 1114, 1687, 367, 5872, 5867, 327, 223, 1719, 5868, 1318, 190, 330, 5873, 5870, 1665, 227, 5871, 32, 342, 343, 441, 4307, 344, 41, 1902, 1691, 233, 1054, 234 ],
  ),
  "cast_for_education": SymbolsMetadata(
    popularity: 1325,
    codepoint: 0xefec,
    categories: [ 11 ],
    tags: [ 1109, 1110, 4701, 2051, 2053, 1684, 5874, 921, 1685, 445, 12, 5875, 3374, 3153, 5876, 5877, 965, 1114, 3375, 5878, 5879, 1687, 327, 819, 2400, 3156, 5716, 3158, 330, 5870, 1665, 227, 342, 5880, 343, 5781, 5881, 344, 5882, 1691, 5883, 233, 1054, 234 ],
  ),
  "cast_pause": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf5f0,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2051, 2827, 355, 2053, 1684, 5865, 383, 921, 269, 785, 1685, 445, 12, 965, 1114, 1687, 367, 5867, 327, 2081, 223, 1719, 1082, 2141, 2400, 5868, 330, 5870, 1665, 227, 228, 5871, 1083, 342, 343, 344, 1214, 41, 1902, 1691, 233, 1054, 234 ],
  ),
  "cast_warning": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf5ef,
    categories: [ 11 ],
    tags: [ 3175, 1109, 1110, 2051, 469, 2827, 3073, 2053, 5884, 5885, 5886, 5887, 5888, 1693, 1684, 383, 921, 211, 5101, 5889, 5890, 3176, 1685, 445, 12, 2766, 2767, 3177, 965, 2471, 1114, 1251, 2769, 1687, 1641, 327, 223, 5116, 5891, 5892, 486, 2772, 330, 5870, 227, 5893, 342, 35, 343, 344, 1261, 1691, 233, 1054, 234, 5894, 5895, 5896 ],
  ),
  "castle": SymbolsMetadata(
    popularity: 694,
    codepoint: 0xeab1,
    categories: [ 5 ],
    tags: [ 5897, 2601, 5898, 798, 5899, 5900, 2854, 1484, 5901, 5902, 5903, 5904, 5905, 697, 1023, 5906, 3343, 1001, 5907, 5908, 5909, 1495, 1520, 5910, 5911, 1011, 5912, 2023, 2620, 1504, 5913, 5020 ],
  ),
  "category": SymbolsMetadata(
    popularity: 9314,
    codepoint: 0xe574,
    categories: [ 6 ],
    tags: [ 5914, 5915, 5916, 5917, 5918, 383, 5919, 2155, 2750, 1735, 5920, 959, 304, 930, 932, 2245, 656, 940, 5921, 329, 1622, 288, 65, 5922, 106, 32, 945, 5923, 5924, 1701, 5925, 5926 ],
  ),
  "category_search": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xf437,
    categories: [ 2 ],
    tags: [ 5927, 5123, 5916, 5917, 5918, 2447, 383, 5928, 2155, 5929, 5930, 955, 958, 959, 960, 964, 930, 932, 5931, 2245, 92, 971, 974, 975, 976, 656, 940, 1622, 5932, 2493, 980, 1377, 981, 288, 5922, 106, 32, 945, 5923, 5933, 1701 ],
  ),
  "celebration": SymbolsMetadata(
    popularity: 5480,
    codepoint: 0xea65,
    categories: [ 6 ],
    tags: [ 3, 989, 5300, 5302, 4661, 5934, 5149, 5935, 5936, 5937, 5938, 5939, 1852, 2094, 5940, 5941, 2819, 2018, 5942, 366, 5943, 487, 5944, 5945, 5316, 5946, 2487, 1701, 5947 ],
  ),
  "cell_merge": SymbolsMetadata(
    popularity: 55,
    codepoint: 0xf82e,
    categories: [ 12 ],
    tags: [ 2169, 380, 419, 1113, 3639, 802, 1061, 3086, 921, 3087, 10, 388, 787, 2175, 246, 930, 2176, 5948, 4867, 3092, 1064, 306, 1375, 935, 1067, 778, 1396, 1376, 4916, 3036, 1379, 1380, 5949 ],
  ),
  "cell_tower": SymbolsMetadata(
    popularity: 1773,
    codepoint: 0xebba,
    categories: [ 7 ],
    tags: [ 502, 546, 1180, 355, 5950, 1113, 5951, 208, 211, 212, 10, 277, 5090, 215, 507, 219, 223, 2083, 1318, 508, 2631, 227, 5952, 438, 439, 2620, 4307, 5953, 1902, 233, 234 ],
  ),
  "cell_wifi": SymbolsMetadata(
    popularity: 414,
    codepoint: 0xe0ec,
    categories: [ 7 ],
    tags: [ 1180, 1343, 355, 1113, 4074, 5951, 208, 5954, 443, 211, 10, 445, 5090, 215, 432, 219, 433, 221, 223, 226, 508, 5955, 2631, 227, 5956, 5952, 2620, 1701, 233, 234, 235 ],
  ),
  "center_focus_strong": SymbolsMetadata(
    popularity: 1367,
    codepoint: 0xe3b4,
    categories: [ 1 ],
    tags: [ 1725, 5957, 5958, 2169, 1775, 1729, 5959, 47, 1730, 5960, 2318, 2200, 2805, 12, 1738, 53, 126, 5961, 59, 61, 1363, 3017, 5962, 1741, 5963, 330, 5964, 5965, 36, 1071, 2814, 986 ],
  ),
  "center_focus_weak": SymbolsMetadata(
    popularity: 889,
    codepoint: 0xe3b5,
    categories: [ 1 ],
    tags: [ 5957, 5958, 2169, 5966, 5967, 3909, 47, 1730, 5968, 2318, 383, 2391, 2805, 1738, 5969, 53, 5970, 126, 5971, 5961, 59, 61, 1496, 5972, 177, 5973, 4558, 36, 1071, 41, 2814, 5974, 5975, 986 ],
  ),
  "chair": SymbolsMetadata(
    popularity: 2919,
    codepoint: 0xefed,
    categories: [ 8 ],
    tags: [ 2600, 5976, 1912, 1914, 5977, 5978, 5979, 1964, 5980, 999, 4217, 2607, 1435, 4418, 5981, 5982, 5983, 5984, 5985, 5986, 1361, 508, 1958, 1925, 1960, 1926, 5987, 105, 1961, 5988, 5989, 5990 ],
  ),
  "chair_alt": SymbolsMetadata(
    popularity: 600,
    codepoint: 0xefee,
    categories: [ 8 ],
    tags: [ 2599, 5991, 2600, 5976, 5992, 2136, 5993, 1912, 5994, 1964, 5980, 999, 2607, 1435, 4418, 3802, 5983, 5984, 5985, 1456, 508, 1958, 1925, 1960, 1926, 5987, 1961, 5995, 1380, 5996, 5990 ],
  ),
  "chalet": SymbolsMetadata(
    popularity: 191,
    codepoint: 0xe585,
    categories: [ 16 ],
    tags: [ 2599, 2601, 798, 5203, 5261, 714, 5204, 2605, 721, 2018, 999, 1435, 2608, 724, 5997, 2610, 1490, 1544, 5998, 1495, 1444, 2614, 2615, 1446, 2616, 5999, 5287, 725, 726, 3846, 727, 5209, 2024, 731, 732, 6000, 6001 ],
  ),
  "change_circle": SymbolsMetadata(
    popularity: 5113,
    codepoint: 0xe2e7,
    categories: [ 2 ],
    tags: [ 2284, 2891, 419, 1731, 383, 384, 2490, 385, 388, 2450, 696, 2627, 390, 1740, 421, 2492, 424, 425, 2367, 3662, 426, 2496, 396, 397, 5256, 313, 1667, 3529, 2007, 427, 2455, 2499, 1260 ],
  ),
  "change_history": SymbolsMetadata(
    popularity: 2908,
    codepoint: 0xe86b,
    categories: [ 6 ],
    tags: [ 989, 6002, 1731, 6003, 6004, 3812, 1694, 5333, 6005, 1659, 6006, 6007, 1023, 5126, 1740, 2492, 2496, 6008, 311, 1700, 290, 6009, 1701, 2499, 4308, 6010, 6011, 6012 ],
  ),
  "charger": SymbolsMetadata(
    popularity: 977,
    codepoint: 0xe2ae,
    categories: [ 4 ],
    tags: [ 5269, 6013, 3769, 4093, 4362, 3773, 5271, 3774, 383, 445, 4078, 6014, 4049, 3779, 6015, 6016, 4081, 4083, 4131, 1004, 4371, 3782, 4084, 4140, 4085, 4375, 889, 4086, 4653, 4189 ],
  ),
  "charging_station": SymbolsMetadata(
    popularity: 501,
    codepoint: 0xf19d,
    categories: [ 11 ],
    tags: [ 1109, 1110, 3769, 4076, 1113, 3773, 3774, 6017, 445, 4078, 6014, 4049, 3779, 6015, 6018, 4043, 965, 1114, 16, 188, 4082, 4393, 4083, 219, 6019, 226, 3782, 6020, 4375, 75, 77, 3611, 553, 35, 447, 4086, 4172, 4189 ],
  ),
  "chart_data": SymbolsMetadata(
    popularity: 195,
    codepoint: 0xe473,
    categories: [ 9 ],
    tags: [ 5, 380, 2052, 7, 1284, 920, 10, 924, 808, 6021, 929, 196, 595, 530, 1207, 933, 1602, 6022, 597, 634, 937, 189, 1213, 28, 1353, 32, 33, 2487, 947, 2852, 3858, 1676, 2916 ],
  ),
  "chat": SymbolsMetadata(
    popularity: 18210,
    codepoint: 0xe0b7,
    categories: [ 7 ],
    tags: [ 1400, 471, 472, 473, 474, 443, 475, 476, 477, 478, 480, 481, 851, 485, 6023, 2503, 486, 1410, 1565, 77, 1121, 492, 493, 494, 495, 496, 38, 441 ],
    rtlAutoMirrored: true,
  ),
  "chat_add_on": SymbolsMetadata(
    popularity: 540,
    codepoint: 0xf0f3,
    categories: [ 7 ],
    tags: [ 526, 6024, 6025, 6026, 1399, 6027, 472, 473, 693, 476, 1201, 6028, 1403, 1064, 6029, 485, 763, 6030, 1407, 1408, 6031, 202, 6032, 1409, 494, 108, 6033, 496 ],
    rtlAutoMirrored: true,
  ),
  "chat_apps_script": SymbolsMetadata(
    popularity: 267,
    codepoint: 0xf0bd,
    categories: [ 7 ],
    tags: [ 2657, 2148, 2538, 472, 6034, 6035, 266, 1776, 2624, 473, 443, 476, 1781, 1347, 696, 2738, 966, 6036, 485, 1533, 1409, 1410, 3379, 288, 2343, 1121, 38, 1536 ],
  ),
  "chat_bubble": SymbolsMetadata(
    popularity: 10004,
    codepoint: 0xe0ca,
    categories: [ 7 ],
    tags: [ 1400, 471, 472, 1401, 473, 6037, 474, 443, 475, 476, 477, 480, 481, 851, 485, 1406, 486, 1361, 75, 77, 1121, 492, 493, 494, 32, 495, 496, 38 ],
  ),
  "chat_error": SymbolsMetadata(
    popularity: 48,
    codepoint: 0xf7ac,
    categories: [ 7 ],
    tags: [ 469, 3073, 471, 895, 6038, 1693, 472, 1401, 6039, 6040, 6041, 6042, 3436, 2950, 6043, 473, 474, 6044, 476, 1202, 3176, 6045, 6046, 477, 2766, 6047, 2985, 6048, 480, 1251, 2769, 1641, 485, 6049, 6050, 6051, 6052, 4152, 486, 2772, 911, 6053, 6054, 1353, 493, 494, 1083, 35, 1261, 3736 ],
  ),
  "chat_info": SymbolsMetadata(
    popularity: 97,
    codepoint: 0xf52b,
    categories: [ 7 ],
    tags: [ 6055, 469, 1245, 738, 471, 472, 1401, 6056, 6057, 6058, 6059, 383, 473, 474, 6060, 6061, 6062, 132, 477, 480, 3225, 482, 6063, 5463, 484, 6064, 135, 6065, 485, 6066, 6067, 6068, 6069, 77, 2631, 493, 494, 495, 496, 6070 ],
    rtlAutoMirrored: true,
  ),
  "chat_paste_go": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf6bd,
    categories: [ 7 ],
    tags: [ 380, 419, 471, 472, 6071, 6072, 1750, 473, 474, 443, 476, 1707, 477, 388, 1578, 1347, 1672, 480, 777, 2910, 1542, 485, 421, 6073, 6074, 1409, 6075, 1410, 1411, 1396, 2343, 6076, 1665, 6077, 493, 1412, 38 ],
    rtlAutoMirrored: true,
  ),
  "chat_paste_go_2": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf3cb,
    categories: [ 7 ],
    tags: [ 380, 419, 471, 472, 6071, 473, 474, 443, 476, 477, 388, 1578, 1672, 480, 777, 2910, 966, 485, 421, 1719, 6073, 6074, 1409, 6075, 1410, 1396, 782, 2343, 6076, 1665, 6078, 493, 494, 1412, 6079, 6080, 3734, 2007 ],
    rtlAutoMirrored: true,
  ),
  "check": SymbolsMetadata(
    popularity: 30170,
    codepoint: 0xe5ca,
    categories: [ 2 ],
    tags: [ 2866, 1627, 6081, 1548, 6082, 1549, 2480, 1630, 1632, 1633, 1635, 1636, 2481, 2376, 2872, 1639, 2909, 1640, 3065, 1641, 1643, 4750, 1213, 288, 4751, 1412, 6083, 2487, 6084, 1647, 6085, 2385, 2387, 1650 ],
  ),
  "check_box": SymbolsMetadata(
    popularity: 25304,
    codepoint: 0xe834,
    categories: [ 2 ],
    tags: [ 1627, 1548, 1549, 2480, 7, 298, 1630, 4788, 6086, 6087, 2447, 1633, 4864, 1636, 269, 1639, 1598, 966, 1641, 1643, 281, 329, 288, 4751, 371, 65, 32, 1645, 1647, 6088, 6085, 314, 2757, 2387, 1523, 1650 ],
  ),
  "check_box_outline_blank": SymbolsMetadata(
    popularity: 21780,
    codepoint: 0xe835,
    categories: [ 2 ],
    tags: [ 6089, 349, 7, 298, 1630, 4788, 6086, 1631, 1632, 2447, 4864, 269, 2448, 2449, 4719, 6090, 4013, 6091, 6092, 1598, 966, 281, 1361, 3331, 190, 288, 371, 32, 1645, 1647, 6093, 6085, 314, 2757, 6094, 6095, 6096 ],
  ),
  "check_circle": SymbolsMetadata(
    popularity: 83242,
    codepoint: 0xe86c,
    categories: [ 2 ],
    tags: [ 1627, 6081, 1548, 6082, 1549, 2480, 1630, 1632, 383, 1633, 1635, 4268, 1636, 4269, 2376, 1639, 1641, 1643, 4750, 1361, 1213, 1257, 288, 4751, 2487, 6097, 1645, 1647, 6088, 6085, 2385, 2386, 2387, 1523, 1650 ],
  ),
  "check_in_out": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf6f6,
    categories: [ 15 ],
    tags: [ 755, 2014, 6098, 6099, 3952, 1630, 6100, 6101, 6102, 2016, 6103, 6104, 1597, 2985, 6105, 6106, 4217, 2607, 3091, 6107, 2795, 852, 903, 2398, 3841, 6108, 1256, 3964, 2913, 913, 3966, 313, 1647, 314 ],
  ),
  "check_indeterminate_small": SymbolsMetadata(
    popularity: 676,
    codepoint: 0xf88a,
    categories: [ 2 ],
    tags: [ 1549, 1343, 1630, 6086, 383, 1633, 2448, 1639, 3065, 1205, 6109, 6110, 2659, 6111, 6112, 6113, 2568, 1641, 1116, 6114, 1643, 281, 1361, 4138, 2858, 1048, 6115, 75, 288, 371, 1979, 6116, 1647, 314, 6117, 6095, 6118, 1364, 2386, 1523, 1650 ],
  ),
  "check_small": SymbolsMetadata(
    popularity: 1879,
    codepoint: 0xf88b,
    categories: [ 2 ],
    tags: [ 1627, 6081, 1548, 2717, 1549, 2480, 1630, 1632, 383, 1633, 1635, 1636, 2376, 1639, 1640, 3065, 1641, 1643, 4750, 1361, 1213, 1396, 288, 4751, 1979, 2487, 1645, 1647, 6085, 2386, 2387, 1523, 1650 ],
  ),
  "checkbook": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xe70d,
    categories: [ 9 ],
    tags: [ 468, 3313, 794, 795, 796, 1910, 1284, 1630, 6119, 6120, 3274, 1347, 696, 3318, 808, 1598, 811, 3320, 6121, 366, 818, 1532, 820, 821, 2694, 121, 75, 1256, 6122, 842, 6123, 1536 ],
    rtlAutoMirrored: true,
  ),
  "checked_bag": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xeb0c,
    categories: [ 16 ],
    tags: [ 6081, 2013, 2480, 3719, 4741, 6124, 1630, 5826, 1632, 1633, 2481, 1639, 1917, 3489, 2018, 1581, 1602, 3726, 1194, 75, 288, 4751, 32, 4744, 1647, 1504, 1591, 2024 ],
  ),
  "checked_bag_question": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xeb0d,
    categories: [ 16 ],
    tags: [ 1907, 2013, 738, 3719, 4741, 6125, 5238, 1630, 5826, 1917, 6126, 482, 135, 2769, 1581, 6127, 3726, 2772, 979, 4102, 4103, 553, 4744, 495, 1647, 1504, 6128, 1591, 1364 ],
  ),
  "checklist": SymbolsMetadata(
    popularity: 6917,
    codepoint: 0xe6b1,
    categories: [ 12 ],
    tags: [ 3573, 2167, 2169, 1230, 1549, 2514, 1630, 1631, 1632, 2447, 1633, 1636, 1528, 1347, 1639, 696, 2299, 1371, 3154, 1598, 1372, 2245, 92, 1641, 1533, 1643, 656, 3854, 28, 3157, 288, 4786, 1379, 109, 1570, 1645, 3160, 38, 1647, 6085, 40, 2386, 2387, 1523, 2389, 3855, 704, 1650 ],
  ),
  "checklist_rtl": SymbolsMetadata(
    popularity: 2180,
    codepoint: 0xe6b3,
    categories: [ 12 ],
    tags: [ 1627, 2716, 2167, 2169, 2717, 1549, 1630, 1631, 1632, 5124, 1633, 1635, 1636, 1528, 1639, 3108, 696, 2299, 1371, 1598, 1372, 2245, 366, 92, 1641, 1533, 1643, 656, 6129, 6130, 6131, 288, 371, 4786, 1379, 1570, 1645, 38, 1647, 6085, 315, 40, 2386, 2387, 2388, 1523, 704, 1650 ],
  ),
  "checkroom": SymbolsMetadata(
    popularity: 1937,
    codepoint: 0xf19e,
    categories: [ 8 ],
    tags: [ 1940, 2697, 4741, 6132, 6133, 3989, 2701, 6134, 6135, 6136, 6137, 3274, 2705, 2706, 6138, 6139, 2527, 2607, 6140, 3726, 1296, 2631, 841, 674, 6141, 1504, 1701, 2714 ],
  ),
  "cheer": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xf6a8,
    categories: [ 3 ],
    tags: [ 6142, 6143, 2717, 1059, 5934, 5149, 6144, 6145, 6146, 6147, 5938, 5939, 6148, 6149, 6150, 6151, 719, 6152, 6153, 6154, 6155, 1557, 5942, 6156, 6157, 6158, 6159, 6160, 495, 6161, 6162, 6163, 5947 ],
  ),
  "chef_hat": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf357,
    categories: [ 3 ],
    tags: [ 6164, 3787, 6165, 3793, 6166, 6167, 3795, 4386, 6168, 6169, 6170, 6171, 3799, 3800, 1829, 6172, 6173, 4390, 4974, 6174, 6175, 6176, 3802, 4396, 3804, 788, 6177, 6178, 3807, 6179, 6180, 6181 ],
  ),
  "chess": SymbolsMetadata(
    popularity: 128,
    codepoint: 0xf5e7,
    categories: [ 3 ],
    tags: [ 3, 3574, 6182, 6183, 6184, 3576, 6185, 6186, 6187, 6188, 3337, 697, 6189, 6190, 3502, 4218, 3344, 6191, 778, 5018, 2107, 2162, 4224, 101, 6192, 6193, 6194, 6195, 6196, 3588, 3589 ],
  ),
  "chess_pawn": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf3b6,
    categories: [ 3 ],
    tags: [ 4310, 6197, 6182, 6183, 6184, 6185, 6198, 6186, 383, 6187, 4408, 697, 6199, 6189, 16, 390, 3329, 778, 1361, 6200, 5018, 2162, 2904, 889, 6201, 105, 4323, 6193, 35, 6202, 6203 ],
  ),
  "chevron_backward": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf46b,
    categories: [ 2 ],
    tags: [ 380, 419, 2489, 2869, 2870, 6204, 6205, 2871, 6206, 2862, 6207, 388, 2884, 5499, 2873, 1023, 2874, 1375, 2875, 779, 421, 2876, 2877, 2878, 2495, 2881, 2886, 396, 402, 2499 ],
    rtlAutoMirrored: true,
  ),
  "chevron_forward": SymbolsMetadata(
    popularity: 100,
    codepoint: 0xf46a,
    categories: [ 2 ],
    tags: [ 775, 378, 2890, 380, 6208, 419, 2871, 2862, 6209, 776, 132, 388, 3101, 787, 6210, 777, 6211, 789, 778, 779, 421, 780, 2653, 2162, 781, 28, 1396, 6212, 2966 ],
    rtlAutoMirrored: true,
  ),
  "chevron_left": SymbolsMetadata(
    popularity: 20243,
    codepoint: 0xe5cb,
    categories: [ 2 ],
    tags: [ 2866, 2890, 380, 419, 2489, 2869, 2870, 6205, 2871, 2862, 269, 388, 2872, 2884, 5499, 2873, 188, 2874, 1375, 778, 779, 421, 1783, 2876, 2877, 2878, 2495, 2881, 2886, 396, 402, 2499 ],
    rtlAutoMirrored: true,
  ),
  "chevron_right": SymbolsMetadata(
    popularity: 51767,
    codepoint: 0xe5cc,
    categories: [ 2 ],
    tags: [ 775, 2963, 380, 419, 2871, 2862, 776, 132, 388, 787, 777, 339, 188, 789, 778, 779, 421, 780, 6213, 6214, 2653, 2162, 781, 28, 1396, 782, 2899, 4787, 2571 ],
    rtlAutoMirrored: true,
  ),
  "child_care": SymbolsMetadata(
    popularity: 2425,
    codepoint: 0xeb41,
    categories: [ 8 ],
    tags: [ 3598, 3599, 4989, 6215, 3600, 862, 6216, 3602, 6217, 865, 383, 6218, 6219, 479, 867, 6220, 1558, 1190, 3606, 870, 871, 6221, 3609, 4230, 874, 6222, 876, 6223, 889, 1567, 3612, 879 ],
  ),
  "child_friendly": SymbolsMetadata(
    popularity: 577,
    codepoint: 0xeb42,
    categories: [ 16 ],
    tags: [ 734, 3599, 6224, 6225, 6226, 6227, 6228, 3600, 6229, 862, 6216, 3602, 865, 867, 6230, 6231, 3489, 6232, 3606, 6233, 870, 6234, 5002, 3609, 876, 6235, 6236, 6237, 3612, 6238, 4340, 4343, 879 ],
  ),
  "chip_extraction": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf821,
    categories: [ 2 ],
    tags: [ 2827, 380, 419, 5250, 6239, 3121, 10, 6240, 6241, 3064, 3303, 388, 3306, 6103, 3016, 6242, 2985, 6243, 6105, 6244, 903, 2653, 2398, 3068, 911, 2844, 1396, 782, 2542, 2343, 913, 2007, 6245, 6246, 346 ],
  ),
  "chips": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xe993,
    categories: [ 2 ],
    tags: [ 949, 1229, 1230, 3351, 1343, 952, 895, 5250, 5849, 2896, 2750, 6247, 2448, 4439, 2922, 897, 299, 900, 2176, 1205, 966, 2751, 306, 6248, 1602, 2928, 1116, 219, 327, 3696, 226, 75, 2930, 911, 77, 78, 330, 3013, 2882, 32, 1122, 447, 6249, 4283, 2757, 2759, 1691, 1053, 1054 ],
  ),
  "chrome_reader_mode": SymbolsMetadata(
    popularity: 947,
    codepoint: 0xe86d,
    categories: [ 6 ],
    tags: [ 2501, 1039, 1684, 6250, 6251, 802, 1042, 6252, 6253, 1347, 4694, 1738, 306, 6254, 307, 1534, 1770, 3421, 2506, 6255, 3908, 2507, 6256, 1378, 6257, 38, 6258, 4856, 317, 1241, 1053 ],
    rtlAutoMirrored: true,
  ),
  "chromecast_2": SymbolsMetadata(
    popularity: 196,
    codepoint: 0xf17b,
    categories: [ 10 ],
    tags: [ 81, 2051, 1129, 2053, 5865, 6259, 383, 921, 211, 445, 12, 6260, 3337, 1189, 6261, 965, 5273, 390, 5866, 278, 2081, 1004, 2056, 5870, 1665, 227, 342, 343, 2085, 344, 41, 234, 2059 ],
  ),
  "chromecast_device": SymbolsMetadata(
    popularity: 209,
    codepoint: 0xe83c,
    categories: [ 11 ],
    tags: [ 3210, 2051, 2053, 5865, 921, 445, 12, 6260, 3216, 1711, 3337, 1189, 6261, 965, 5273, 999, 1435, 215, 367, 5866, 327, 1004, 5868, 1318, 2056, 5869, 5870, 1665, 227, 1155, 342, 6262, 551, 343, 344, 233, 234, 2059 ],
  ),
  "chronic": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xebb2,
    categories: [ 2 ],
    tags: [ 1244, 469, 6263, 1016, 268, 2349, 269, 385, 1020, 6264, 277, 595, 1023, 6265, 6266, 936, 2363, 656, 6267, 28, 2366, 1030, 2367, 3532, 1031, 6268, 65, 289, 1033, 947, 2102 ],
  ),
  "church": SymbolsMetadata(
    popularity: 1167,
    codepoint: 0xeaae,
    categories: [ 5 ],
    tags: [ 798, 6269, 6270, 6271, 6272, 6273, 6274, 194, 1202, 6275, 6276, 6277, 6278, 6279, 5604, 3343, 1001, 6280, 6281, 6282, 5606, 5607, 6283, 2631, 5609, 6284, 6285, 1504, 6286, 5614 ],
  ),
  "cinematic_blur": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf853,
    categories: [ 0 ],
    tags: [ 468, 6287, 6288, 4528, 2053, 267, 6289, 3428, 6290, 6291, 6292, 6293, 2567, 270, 6294, 959, 1738, 6295, 483, 278, 489, 854, 6296, 490, 121, 177, 6297, 441, 501, 41, 364 ],
  ),
  "circle": SymbolsMetadata(
    popularity: 8246,
    codepoint: 0xef4a,
    categories: [ 1 ],
    tags: [ 3325, 378, 383, 6298, 385, 6299, 3327, 4013, 6300, 6301, 4043, 304, 3328, 5022, 6302, 53, 126, 2568, 390, 4253, 6303, 6304, 1361, 392, 59, 61, 119, 1048, 28, 121, 2367, 1257, 396, 889, 311, 5081, 35, 6305, 6306, 375 ],
  ),
  "circle_notifications": SymbolsMetadata(
    popularity: 2395,
    codepoint: 0xe994,
    categories: [ 6 ],
    tags: [ 1242, 1244, 469, 6307, 4073, 1245, 1246, 6308, 6309, 1248, 383, 6310, 1251, 851, 484, 135, 485, 1408, 486, 1253, 6311, 1120, 1254, 1030, 2663, 1257, 889, 6312, 227, 1156, 1260, 4308, 1261 ],
  ),
  "circles": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xe7ea,
    categories: [ 6 ],
    tags: [ 3325, 920, 383, 953, 443, 921, 211, 4246, 924, 1654, 304, 929, 930, 1064, 935, 390, 1067, 4253, 223, 423, 6313, 4915, 1081, 5652, 396, 397, 6314, 607, 6315 ],
  ),
  "circles_ext": SymbolsMetadata(
    popularity: 48,
    codepoint: 0xe7ec,
    categories: [ 6 ],
    tags: [ 3325, 1994, 3026, 953, 6316, 1732, 921, 211, 6317, 6318, 924, 2173, 2210, 2985, 787, 6319, 2996, 2628, 1659, 930, 1064, 6320, 1067, 6321, 223, 4844, 3841, 1786, 1665, 3058, 374, 1701, 6322, 2511, 6315 ],
  ),
  "clarify": SymbolsMetadata(
    popularity: 246,
    codepoint: 0xf0bf,
    categories: [ 12 ],
    tags: [ 6323, 2501, 6324, 269, 6325, 132, 12, 1528, 1347, 2983, 787, 6326, 958, 1951, 1530, 6327, 900, 135, 306, 366, 92, 788, 6328, 789, 421, 2503, 656, 1534, 1770, 329, 2948, 77, 65, 2997, 2993, 32, 6329, 38, 441, 314, 6330, 704 ],
    rtlAutoMirrored: true,
  ),
  "clean_hands": SymbolsMetadata(
    popularity: 931,
    codepoint: 0xf21f,
    categories: [ 3 ],
    tags: [ 6331, 1868, 1871, 4005, 2414, 6332, 1500, 4471, 3990, 6333, 6334, 2735, 2738, 2741, 6335, 595, 3972, 6336, 1757, 599, 2071, 3610, 602, 4007, 6337, 6338, 6339, 5193, 4001, 3986, 2801 ],
  ),
  "cleaning": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xe995,
    categories: [ 15 ],
    tags: [ 6340, 1869, 6341, 6342, 6343, 1889, 4005, 6344, 6345, 6346, 6347, 1433, 999, 1436, 6348, 6349, 3972, 2798, 2770, 6350, 6337, 6351, 1883, 1884, 6352, 6353, 6354, 6355, 4001, 6356, 6357, 6358 ],
  ),
  "cleaning_bucket": SymbolsMetadata(
    popularity: 388,
    codepoint: 0xf8b4,
    categories: [ 10 ],
    tags: [ 1868, 5173, 6359, 6342, 953, 4005, 6345, 3435, 1269, 6360, 999, 6348, 6349, 3972, 6361, 3802, 2770, 6362, 6350, 6339, 6352, 6363, 6364, 6365, 6353, 6354, 6366, 6367, 6368, 4001, 6356 ],
  ),
  "cleaning_services": SymbolsMetadata(
    popularity: 1866,
    codepoint: 0xf0ff,
    categories: [ 5 ],
    tags: [ 6369, 6342, 1871, 4005, 6370, 3435, 3436, 6371, 1433, 2432, 6372, 3489, 1436, 6348, 3972, 6361, 2770, 6373, 75, 911, 77, 6350, 6374, 2755, 6352, 6375, 441, 6353, 2537, 6376 ],
  ),
  "clear_all": SymbolsMetadata(
    popularity: 2486,
    codepoint: 0xe0b8,
    categories: [ 2 ],
    tags: [ 2325, 895, 3436, 6377, 6378, 6379, 6380, 6381, 6382, 897, 6383, 3615, 1528, 1347, 3438, 1372, 2080, 1066, 366, 92, 788, 763, 656, 424, 911, 6384, 6385, 426, 3516, 65, 6386, 6375, 441 ],
  ),
  "clear_day": SymbolsMetadata(
    popularity: 1558,
    codepoint: 0xf157,
    categories: [ 3 ],
    tags: [ 6387, 1728, 383, 3436, 6388, 6389, 712, 5035, 5045, 6390, 6391, 6392, 3076, 999, 3078, 1857, 2097, 1004, 3684, 6393, 4206, 3686, 4208, 6394, 6395, 6396, 3687, 727, 729, 3978, 731 ],
  ),
  "climate_mini_split": SymbolsMetadata(
    popularity: 148,
    codepoint: 0xf8b5,
    categories: [ 10 ],
    tags: [ 705, 708, 709, 5689, 1846, 798, 712, 713, 716, 717, 718, 1852, 3076, 5673, 999, 1435, 723, 2793, 2068, 6397, 1456, 75, 1960, 1378, 6398, 727, 728, 729, 441, 730, 6399 ],
  ),
  "clinical_notes": SymbolsMetadata(
    popularity: 90,
    codepoint: 0xe09e,
    categories: [ 3 ],
    tags: [ 755, 468, 1015, 584, 1749, 6400, 6401, 10, 132, 1528, 1751, 1347, 696, 1530, 1598, 595, 1753, 1754, 483, 135, 92, 1755, 6402, 1757, 1532, 1533, 1761, 1534, 1535, 1762, 488, 489, 490, 121, 1353, 78, 6403, 441, 501, 317, 1536, 704 ],
  ),
  "clock_arrow_down": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf382,
    categories: [ 2 ],
    tags: [ 755, 2151, 380, 1016, 1018, 2922, 2651, 337, 6404, 1020, 2094, 1023, 5126, 656, 2841, 329, 1029, 121, 2930, 1030, 2844, 1664, 1031, 65, 1298, 289, 1033 ],
  ),
  "clock_arrow_up": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf381,
    categories: [ 2 ],
    tags: [ 6405, 469, 380, 2052, 383, 1016, 6406, 1018, 1020, 1022, 777, 6407, 1023, 1207, 486, 1409, 28, 2504, 1027, 1030, 1031, 2343, 231, 1412, 289, 6408, 1033, 1676, 346 ],
  ),
  "clock_loader_10": SymbolsMetadata(
    popularity: 132,
    codepoint: 0xf726,
    categories: [ 2 ],
    tags: [ 6409, 920, 383, 384, 6410, 1016, 2092, 337, 1020, 3524, 3513, 6411, 2568, 6412, 6413, 4142, 3055, 28, 3056, 424, 1257, 396, 397, 4850, 1667, 3529, 6414, 289, 1033, 1260, 346, 2147, 5996 ],
  ),
  "clock_loader_20": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf725,
    categories: [ 2 ],
    tags: [ 4019, 383, 6410, 1016, 4268, 2092, 337, 3524, 3513, 6411, 2568, 6412, 6413, 4142, 3055, 942, 28, 3056, 5034, 424, 396, 4850, 553, 1667, 3529, 289, 1033, 4137, 1260, 346, 2147, 5996 ],
  ),
  "clock_loader_40": SymbolsMetadata(
    popularity: 145,
    codepoint: 0xf724,
    categories: [ 2 ],
    tags: [ 6415, 6416, 989, 920, 383, 384, 1016, 2092, 337, 1020, 929, 188, 3524, 3513, 6411, 2568, 6413, 4142, 6417, 3055, 6418, 3949, 28, 5034, 424, 396, 4850, 553, 1667, 3529, 289, 1033, 1260, 346, 2147, 5996 ],
  ),
  "clock_loader_60": SymbolsMetadata(
    popularity: 189,
    codepoint: 0xf723,
    categories: [ 2 ],
    tags: [ 568, 383, 1016, 4268, 2092, 337, 1020, 6419, 188, 3524, 3513, 6411, 2568, 4138, 6413, 4142, 3055, 942, 28, 424, 396, 4850, 572, 6420, 553, 1667, 3529, 1645, 289, 1033, 1260, 346, 2147, 5996 ],
  ),
  "clock_loader_80": SymbolsMetadata(
    popularity: 81,
    codepoint: 0xf722,
    categories: [ 2 ],
    tags: [ 4048, 920, 383, 1016, 2092, 337, 1020, 4144, 2659, 3524, 3513, 6411, 2568, 4138, 6413, 4142, 6417, 3055, 942, 28, 5034, 424, 396, 4850, 553, 1667, 3529, 289, 1033, 1260, 346, 2147, 5996 ],
  ),
  "clock_loader_90": SymbolsMetadata(
    popularity: 78,
    codepoint: 0xf721,
    categories: [ 2 ],
    tags: [ 6421, 6422, 6423, 383, 1016, 2092, 337, 1020, 188, 3524, 3513, 6411, 2568, 977, 6413, 4142, 3055, 942, 28, 5034, 424, 396, 4850, 553, 1667, 3529, 1645, 289, 1033, 1260, 346, 2147, 5996 ],
  ),
  "close": SymbolsMetadata(
    popularity: 134238,
    codepoint: 0xe5cd,
    categories: [ 2 ],
    tags: [ 6424, 895, 3436, 2950, 1202, 5584, 2200, 4439, 897, 6425, 6426, 3615, 2189, 3438, 6427, 2985, 900, 6428, 3696, 4152, 6429, 6430, 6431, 4449, 4450, 911, 1083, 5593, 6432, 3736 ],
  ),
  "close_fullscreen": SymbolsMetadata(
    popularity: 4373,
    codepoint: 0xf1cf,
    categories: [ 2 ],
    tags: [ 949, 380, 6433, 419, 2950, 6434, 2896, 3086, 2919, 6435, 6436, 6437, 6438, 388, 6439, 3089, 6440, 4043, 1673, 3090, 3092, 6441, 2928, 6442, 3010, 6443, 6444, 6445, 2930, 3749, 330, 2933, 6446, 6447, 1054 ],
  ),
  "close_small": SymbolsMetadata(
    popularity: 88,
    codepoint: 0xf508,
    categories: [ 2 ],
    tags: [ 895, 3436, 2950, 5583, 6448, 6449, 6450, 1202, 4439, 897, 1077, 6426, 3615, 6451, 2189, 3438, 2985, 900, 6452, 3696, 907, 4449, 4450, 911, 6453, 1979, 6454, 1083, 5593, 3736 ],
  ),
  "closed_caption": SymbolsMetadata(
    popularity: 1283,
    codepoint: 0xe01c,
    categories: [ 0 ],
    tags: [ 733, 6455, 734, 4, 6456, 6457, 6458, 6459, 6460, 8, 4428, 6461, 6462, 6463, 6464, 6465, 14, 5651, 19, 367, 6466, 326, 3541, 6467, 6468, 32, 6469, 6470, 35, 38, 6080, 6471, 6472, 344, 6473, 40, 702, 6474, 291, 292 ],
  ),
  "closed_caption_add": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf4ae,
    categories: [ 0 ],
    tags: [ 192, 733, 734, 951, 526, 6475, 4, 7, 6457, 6459, 6460, 8, 4428, 6461, 6462, 1733, 1201, 6463, 2855, 6476, 14, 1044, 5651, 19, 367, 3541, 763, 1211, 656, 2904, 202, 1212, 65, 32, 6469, 6470, 35, 38, 6477, 344, 2788, 40, 41 ],
  ),
  "closed_caption_disabled": SymbolsMetadata(
    popularity: 305,
    codepoint: 0xf1dc,
    categories: [ 0 ],
    tags: [ 733, 734, 4, 1129, 6457, 6459, 6460, 6478, 8, 4428, 6461, 6462, 6463, 3304, 767, 898, 14, 899, 5651, 19, 367, 3541, 1164, 6479, 6480, 907, 909, 283, 3514, 75, 1170, 914, 6468, 32, 2126, 6469, 6470, 35, 38, 344, 40, 915, 41 ],
  ),
  "cloud": SymbolsMetadata(
    popularity: 6533,
    codepoint: 0xe2bd,
    categories: [ 12 ],
    tags: [ 1847, 5290, 712, 1652, 3739, 6481, 211, 6482, 3744, 337, 6392, 215, 1857, 223, 6483, 819, 6484, 2858, 3949, 100, 3761, 5026, 553, 674, 6485, 1667, 727, 346, 731 ],
  ),
  "cloud_alert": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf3cc,
    categories: [ 12 ],
    tags: [ 3175, 469, 3073, 1693, 712, 1652, 6486, 3739, 6487, 6488, 6489, 6490, 6491, 6492, 211, 3176, 6493, 6494, 2766, 2767, 3177, 3075, 2471, 1251, 215, 2769, 1641, 223, 6495, 6496, 486, 3747, 2772, 100, 6497, 6498, 5026, 553, 35, 727, 346, 1261, 731 ],
  ),
  "cloud_circle": SymbolsMetadata(
    popularity: 569,
    codepoint: 0xe2be,
    categories: [ 12 ],
    tags: [ 1229, 1230, 1847, 1651, 383, 6499, 712, 1652, 3739, 6500, 6501, 3740, 6502, 6503, 3741, 6504, 211, 212, 6505, 3744, 6506, 3756, 337, 1654, 1655, 1657, 6392, 215, 223, 6507, 3747, 3761, 5026, 674, 1667, 3529, 346, 731 ],
  ),
  "cloud_done": SymbolsMetadata(
    popularity: 1971,
    codepoint: 0xe2bf,
    categories: [ 12 ],
    tags: [ 1229, 1230, 1549, 1651, 1630, 1632, 1652, 6508, 6509, 3739, 3741, 6510, 6511, 1633, 6512, 6513, 211, 10, 1639, 337, 1654, 1655, 3065, 1657, 215, 1641, 223, 1643, 1664, 4271, 288, 3761, 5026, 674, 2487, 6514, 6515, 1667, 6516, 1647, 2007, 346, 2386, 1523, 1650 ],
  ),
  "cloud_download": SymbolsMetadata(
    popularity: 3925,
    codepoint: 0xe2c0,
    categories: [ 12 ],
    tags: [ 1229, 1230, 380, 2650, 1651, 1652, 3739, 6517, 3740, 6503, 3741, 6504, 211, 6506, 3050, 2651, 337, 2897, 6518, 1654, 3052, 1655, 1657, 2652, 1542, 215, 223, 3747, 3001, 3749, 2844, 6519, 1664, 5026, 674, 1667, 3529, 441, 2007, 346, 6520 ],
  ),
  "cloud_lock": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf386,
    categories: [ 12 ],
    tags: [ 6521, 712, 1652, 6522, 3739, 6500, 6523, 6524, 6503, 3741, 3242, 211, 6525, 3244, 3245, 6526, 215, 6527, 2674, 5714, 223, 6528, 6529, 6530, 5715, 1516, 1517, 6531, 1520, 100, 6532, 1772, 602, 1773, 6533, 1011, 5026, 727, 346, 731 ],
  ),
  "cloud_off": SymbolsMetadata(
    popularity: 1530,
    codepoint: 0xe2c1,
    categories: [ 12 ],
    tags: [ 1229, 1230, 1651, 1652, 3739, 6534, 6535, 6536, 6537, 6538, 3741, 211, 4499, 6539, 1077, 767, 3306, 2037, 6540, 1654, 898, 1655, 1657, 215, 6541, 223, 6542, 2043, 6543, 6544, 907, 908, 909, 911, 6545, 5026, 914, 674, 4507, 346, 6546, 2049 ],
  ),
  "cloud_sync": SymbolsMetadata(
    popularity: 2006,
    codepoint: 0xeb5a,
    categories: [ 12 ],
    tags: [ 1229, 1230, 2284, 419, 1651, 6547, 1652, 3738, 3739, 6517, 3741, 1653, 211, 212, 3121, 385, 3742, 6506, 3050, 337, 1654, 3052, 1655, 1657, 3524, 215, 3513, 3525, 390, 223, 3747, 424, 2494, 2367, 3749, 396, 5026, 674, 1667, 2007, 402, 2455, 346 ],
  ),
  "cloud_upload": SymbolsMetadata(
    popularity: 6289,
    codepoint: 0xe2c3,
    categories: [ 12 ],
    tags: [ 1229, 1230, 380, 1651, 1652, 3739, 3740, 3741, 1653, 211, 10, 3742, 6548, 3050, 6549, 1347, 337, 1654, 1530, 3052, 6550, 1655, 1657, 1542, 215, 223, 3747, 1664, 6551, 1665, 3058, 5026, 674, 1667, 3529, 2007, 1676, 1677, 346, 6552, 6520 ],
  ),
  "co2": SymbolsMetadata(
    popularity: 1062,
    codepoint: 0xe7b0,
    categories: [ 3 ],
    tags: [ 6553, 1847, 6554, 6555, 6556, 6557, 712, 6558, 6559, 6560, 6561, 6562, 6563, 6564, 6565, 6566, 1890, 3925, 1854, 6567, 6568, 6569, 4357, 2785, 6570, 2424, 2370 ],
  ),
  "co_present": SymbolsMetadata(
    popularity: 1931,
    codepoint: 0xeaf0,
    categories: [ 7 ],
    tags: [ 380, 355, 5874, 6571, 443, 1135, 12, 3153, 5878, 1145, 5543, 489, 5591, 2400, 6572, 2055, 5716, 1353, 330, 6573, 1665, 6574, 2882, 6575, 2562, 1172, 5880, 6576, 5781, 1160, 1173, 1691, 5883, 1053, 6577, 6578 ],
  ),
  "code": SymbolsMetadata(
    popularity: 8536,
    codepoint: 0xe86f,
    categories: [ 6 ],
    tags: [ 3105, 380, 419, 3909, 3592, 2624, 6579, 6580, 2896, 954, 6581, 6582, 1186, 2625, 1187, 6583, 2835, 787, 339, 6584, 6585, 6586, 6587, 421, 780, 1194, 2876, 2630, 6588, 3379, 6589, 1196, 6590, 6591, 2229 ],
  ),
  "code_blocks": SymbolsMetadata(
    popularity: 505,
    codepoint: 0xf84d,
    categories: [ 6 ],
    tags: [ 1074, 918, 3909, 3592, 2624, 6592, 6579, 6593, 6594, 6580, 954, 3233, 6581, 6582, 1186, 6595, 2625, 6596, 6583, 2835, 6584, 6597, 6586, 1194, 2630, 6588, 3379, 6589, 1196, 6590, 6591, 6598, 2229 ],
  ),
  "code_off": SymbolsMetadata(
    popularity: 634,
    codepoint: 0xe4f3,
    categories: [ 6 ],
    tags: [ 1074, 3909, 895, 2950, 2624, 6599, 6600, 6581, 896, 897, 6582, 1186, 2625, 2969, 1077, 767, 898, 2189, 6583, 2835, 2985, 900, 6584, 901, 1602, 6601, 907, 909, 1194, 6602, 2630, 911, 914, 1196, 1083, 2126, 6603, 5587 ],
  ),
  "coffee": SymbolsMetadata(
    popularity: 2589,
    codepoint: 0xefef,
    categories: [ 8 ],
    tags: [ 1343, 4381, 2136, 6604, 3790, 3792, 6605, 6606, 6607, 6608, 6609, 4388, 6610, 5153, 4217, 6611, 2607, 6612, 788, 6613, 2097, 6614, 1456, 96, 6615, 1959, 3807, 6616, 6617, 1504, 1459 ],
  ),
  "coffee_maker": SymbolsMetadata(
    popularity: 819,
    codepoint: 0xeff0,
    categories: [ 8 ],
    tags: [ 1888, 6618, 4381, 6619, 3790, 6620, 6621, 3792, 6605, 6622, 6607, 6623, 6624, 6625, 6609, 4388, 6626, 959, 999, 6611, 2607, 16, 3802, 1717, 6627, 2097, 6614, 1456, 5639, 6628, 3807, 35 ],
  ),
  "cognition": SymbolsMetadata(
    popularity: 376,
    codepoint: 0xe09f,
    categories: [ 3 ],
    tags: [ 3325, 2513, 4943, 584, 6629, 6630, 5163, 2332, 1190, 595, 483, 3944, 6631, 6632, 3945, 3502, 4686, 3375, 6191, 5291, 6633, 6634, 6635, 488, 6636, 489, 6637, 490, 6638, 6639, 2463, 6640, 6641, 6642, 6643, 6644 ],
  ),
  "cognition_2": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf3b5,
    categories: [ 3 ],
    tags: [ 3325, 4943, 584, 6629, 6645, 6630, 6646, 6647, 1190, 595, 483, 3944, 6631, 3945, 6648, 3502, 4686, 3375, 5291, 6633, 6635, 6649, 6650, 1361, 488, 6636, 489, 942, 490, 6638, 6641, 6642, 6643, 6644 ],
  ),
  "collapse_all": SymbolsMetadata(
    popularity: 325,
    codepoint: 0xe944,
    categories: [ 2 ],
    tags: [ 2325, 380, 419, 2871, 6651, 1113, 2862, 3592, 2950, 2896, 6652, 6653, 3086, 6247, 2919, 1578, 2450, 6654, 3593, 2840, 787, 900, 6655, 92, 788, 2928, 6656, 421, 2930, 1377, 2933, 6657, 1677 ],
  ),
  "collapse_content": SymbolsMetadata(
    popularity: 205,
    codepoint: 0xf507,
    categories: [ 2 ],
    tags: [ 6658, 380, 419, 2862, 2950, 2896, 6659, 6653, 3086, 6660, 6661, 2919, 1062, 388, 6662, 2651, 2941, 787, 6663, 6664, 6665, 900, 6666, 3759, 92, 2928, 6667, 789, 421, 2653, 1770, 2930, 3046, 1377, 2933, 6668, 3100, 6669 ],
  ),
  "collections_bookmark": SymbolsMetadata(
    popularity: 3099,
    codepoint: 0xe431,
    categories: [ 6 ],
    tags: [ 1266, 4762, 6670, 1538, 2151, 1670, 2155, 5797, 6671, 1347, 5243, 3578, 4738, 1541, 930, 931, 18, 4721, 1066, 2159, 2557, 98, 100, 2506, 6672, 2507, 4733, 4270, 2368, 1664, 4271, 107, 1069, 674, 1298, 1070, 4807, 2384, 4776 ],
  ),
  "colorize": SymbolsMetadata(
    popularity: 1172,
    codepoint: 0xe3b8,
    categories: [ 1 ],
    tags: [ 1128, 2829, 266, 4848, 6673, 6674, 6675, 3457, 6676, 299, 5164, 2834, 6677, 696, 2299, 6243, 6300, 6678, 2279, 305, 53, 2836, 1740, 5166, 59, 3022, 6679, 6680, 288, 2182, 2537 ],
  ),
  "colors": SymbolsMetadata(
    popularity: 131,
    codepoint: 0xe997,
    categories: [ 12 ],
    tags: [ 1128, 2829, 6359, 4848, 6681, 6682, 1269, 5163, 6676, 299, 1528, 302, 1500, 4471, 6683, 696, 2299, 1371, 2279, 6684, 3145, 2725, 2798, 656, 5166, 5169, 6685, 65, 4786, 6686, 1379, 32, 2182, 38, 441, 2537, 1701, 40, 704 ],
  ),
  "combine_columns": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf420,
    categories: [ 12 ],
    tags: [ 192, 526, 1058, 1368, 6687, 802, 1061, 6688, 921, 3087, 1202, 10, 299, 1347, 696, 2299, 1372, 246, 930, 1064, 6689, 306, 935, 1067, 6690, 1211, 940, 202, 1376, 1379, 945, 35, 1380, 38, 441, 4856, 5949, 1381, 317, 1053 ],
  ),
  "comedy_mask": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf4d6,
    categories: [ 3 ],
    tags: [ 6691, 6287, 6288, 3332, 6692, 6693, 3336, 6694, 6695, 6696, 6697, 1552, 3337, 6698, 2094, 6699, 479, 6700, 1558, 6701, 6702, 6703, 6704, 278, 3134, 189, 2613, 2162, 1516, 1517, 1519, 1520, 1011, 2997, 1567, 6705, 6706, 3412, 6707, 6708, 6709, 2102 ],
  ),
  "comic_bubble": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf5dd,
    categories: [ 3 ],
    tags: [ 469, 264, 6710, 4661, 6711, 472, 6696, 6712, 6713, 6714, 6715, 473, 443, 476, 477, 478, 480, 481, 6189, 6716, 3944, 6717, 6718, 485, 486, 6719, 6720, 491, 311, 492, 494, 5057, 496, 38, 6721 ],
  ),
  "comment": SymbolsMetadata(
    popularity: 6546,
    codepoint: 0xe0b9,
    categories: [ 7 ],
    tags: [ 526, 6025, 1400, 471, 472, 473, 474, 443, 477, 478, 696, 480, 481, 1044, 6722, 366, 485, 763, 1407, 1533, 1361, 1409, 75, 1410, 492, 493, 494, 496, 38, 441, 1536 ],
    rtlAutoMirrored: true,
  ),
  "comment_bank": SymbolsMetadata(
    popularity: 505,
    codepoint: 0xea4e,
    categories: [ 7 ],
    tags: [ 2151, 795, 1670, 471, 6723, 472, 2155, 473, 6724, 6725, 474, 443, 476, 477, 6726, 3578, 480, 6727, 6728, 6729, 18, 2159, 485, 1533, 4270, 1410, 2843, 1565, 3184, 2368, 1664, 6730, 6731, 6732, 493, 494, 674, 2384, 496 ],
  ),
  "comments_disabled": SymbolsMetadata(
    popularity: 470,
    codepoint: 0xe7a2,
    categories: [ 7 ],
    tags: [ 6733, 471, 6734, 472, 473, 6735, 6736, 6737, 6738, 6739, 6740, 6741, 474, 6742, 6743, 4563, 3304, 6744, 767, 898, 480, 6745, 6746, 6747, 485, 6748, 6749, 6750, 6751, 907, 908, 909, 2123, 75, 6752, 6753, 6754, 6755, 6756, 914, 493, 6757, 6758, 32, 441, 6759 ],
  ),
  "commit": SymbolsMetadata(
    popularity: 600,
    codepoint: 0xeaf5,
    categories: [ 6 ],
    tags: [ 6760, 2687, 6761, 1730, 1731, 1630, 6100, 383, 2624, 6762, 1633, 1636, 211, 6763, 3064, 2625, 1639, 337, 957, 6764, 6006, 6007, 2176, 1064, 1602, 1067, 1643, 978, 6765, 2630, 3012, 121, 3068, 2843, 1664, 1196, 1412, 1667, 3529, 1260, 346, 6010 ],
  ),
  "communication": SymbolsMetadata(
    popularity: 2115,
    codepoint: 0xe27c,
    categories: [ 3 ],
    tags: [ 1129, 355, 443, 921, 211, 475, 476, 5255, 478, 480, 930, 483, 6036, 485, 1004, 223, 488, 489, 1665, 227, 228, 607, 492, 493, 496, 946, 2007, 5086, 501, 1161, 233, 234 ],
  ),
  "communities": SymbolsMetadata(
    popularity: 268,
    codepoint: 0xe7ed,
    categories: [ 3 ],
    tags: [ 383, 953, 6766, 3281, 6767, 194, 922, 211, 6768, 3360, 481, 6769, 6278, 930, 6770, 6771, 223, 4479, 488, 1257, 1665, 607, 31, 6772, 946, 6773, 374, 983, 1159 ],
  ),
  "commute": SymbolsMetadata(
    popularity: 972,
    codepoint: 0xe940,
    categories: [ 14 ],
    tags: [ 1814, 1815, 5733, 2063, 6774, 6775, 6776, 388, 6777, 1581, 1490, 6778, 6779, 6780, 6781, 4319, 2071, 4601, 5230, 6782, 4622, 5234, 2008, 1842, 1930, 1504, 6783, 6784, 1591, 1844, 6785 ],
  ),
  "compare": SymbolsMetadata(
    popularity: 1342,
    codepoint: 0xe3b9,
    categories: [ 1 ],
    tags: [ 6786, 6787, 1128, 5060, 2513, 3811, 794, 2447, 5124, 3812, 3813, 1734, 5333, 1370, 4832, 6788, 696, 2299, 6789, 528, 3819, 6790, 1737, 53, 5799, 281, 656, 59, 61, 5800, 2281, 1723, 288, 371, 2264, 65, 3425, 6791, 1378, 315, 3032, 6792, 6793, 6794 ],
  ),
  "compare_arrows": SymbolsMetadata(
    popularity: 3532,
    codepoint: 0xe915,
    categories: [ 2 ],
    tags: [ 6795, 380, 419, 1731, 6796, 3812, 6797, 1734, 785, 5333, 6798, 388, 6799, 2450, 2627, 5498, 1375, 421, 6800, 6801, 1783, 4459, 3012, 2881, 2496, 1396, 6802, 3425, 5256, 313, 6803, 5752, 2007, 2455 ],
    rtlAutoMirrored: true,
  ),
  "compass_calibration": SymbolsMetadata(
    popularity: 278,
    codepoint: 0xe57c,
    categories: [ 5 ],
    tags: [ 1725, 1128, 2167, 2169, 1729, 5959, 2831, 268, 1733, 211, 388, 955, 4292, 960, 6804, 1488, 215, 1001, 6805, 1490, 421, 223, 3070, 3147, 1496, 5962, 1741, 424, 122, 2631, 310, 65, 2649, 227, 2537, 233, 234 ],
  ),
  "component_exchange": SymbolsMetadata(
    popularity: 1566,
    codepoint: 0xf1e7,
    categories: [ 6 ],
    tags: [ 384, 6806, 4176, 3281, 4864, 268, 211, 385, 2835, 2627, 926, 3487, 2629, 1834, 2837, 4179, 223, 942, 3662, 396, 397, 65, 5256, 2632, 6807, 374, 427, 2571, 1701 ],
  ),
  "compost": SymbolsMetadata(
    popularity: 3157,
    codepoint: 0xe761,
    categories: [ 3 ],
    tags: [ 380, 6808, 2490, 6809, 6810, 385, 6811, 6812, 6813, 6814, 6565, 1890, 6815, 6816, 6817, 6818, 1204, 196, 5637, 6819, 6820, 390, 1859, 6821, 1835, 6822, 6823, 6824, 397, 6825, 2370, 2371, 6826 ],
  ),
  "compress": SymbolsMetadata(
    popularity: 1178,
    codepoint: 0xe94d,
    categories: [ 2 ],
    tags: [ 2151, 380, 419, 6827, 2896, 6796, 6653, 3086, 3537, 6247, 3087, 6828, 6829, 6830, 6831, 2840, 6832, 2080, 6833, 2928, 6834, 4987, 4459, 3012, 6835, 2930, 3013, 2933, 6836, 6803, 1214, 1677, 6837 ],
  ),
  "computer": SymbolsMetadata(
    popularity: 8657,
    codepoint: 0xe30a,
    categories: [ 11 ],
    tags: [ 1109, 1110, 4310, 1684, 694, 6838, 1685, 445, 88, 12, 1711, 965, 2176, 1114, 215, 4052, 1602, 1687, 327, 4708, 1456, 819, 6839, 6840, 2585, 75, 190, 330, 32, 4323, 551, 1691, 1054, 1459, 6841 ],
  ),
  "computer_arrow_up": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf2f7,
    categories: [ 11 ],
    tags: [ 1109, 1110, 380, 2052, 2871, 6842, 1684, 694, 6843, 6844, 6845, 1685, 445, 965, 1114, 4052, 6846, 6847, 1687, 327, 6839, 2343, 6848, 6849, 6850, 2007, 6851, 6852, 1676, 1677, 346, 6853, 6854, 3061, 3062, 1691, 1054, 6841 ],
  ),
  "computer_cancel": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf2f6,
    categories: [ 11 ],
    tags: [ 1109, 1110, 5589, 1074, 895, 1684, 3436, 2950, 694, 1202, 896, 4439, 897, 1685, 445, 1077, 6426, 2189, 3438, 2766, 2985, 2768, 965, 1114, 4052, 1687, 327, 6602, 2772, 4449, 4450, 911, 6855, 1083, 551, 5593, 5587, 1261, 1691, 1054, 3736 ],
  ),
  "concierge": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf561,
    categories: [ 16 ],
    tags: [ 469, 738, 6856, 3073, 1246, 6857, 1133, 6858, 6859, 86, 6860, 6861, 1019, 6862, 2734, 6863, 2735, 6864, 2738, 482, 6865, 4217, 6866, 2607, 6867, 6868, 1254, 508, 3162, 6869, 1257, 6870, 1960, 2631, 6871, 495, 1504, 1591 ],
  ),
  "conditions": SymbolsMetadata(
    popularity: 79,
    codepoint: 0xe0a0,
    categories: [ 3 ],
    tags: [ 733, 468, 2513, 584, 6872, 6873, 132, 955, 6874, 958, 959, 960, 6875, 964, 595, 483, 135, 4294, 967, 971, 973, 974, 975, 976, 656, 488, 489, 329, 490, 6876, 980, 6877, 981, 65, 750, 501, 6878, 986 ],
  ),
  "confirmation_number": SymbolsMetadata(
    popularity: 4701,
    codepoint: 0xe638,
    categories: [ 15 ],
    tags: [ 755, 4710, 6879, 1936, 4269, 6880, 6881, 956, 3337, 1597, 2094, 3167, 2810, 23, 24, 96, 2028, 4849, 3641, 840, 75, 1924, 77, 6882, 6883, 791, 2022, 1504, 2388, 6884 ],
  ),
  "congenital": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xe0a1,
    categories: [ 3 ],
    tags: [ 3325, 6885, 2412, 6886, 584, 862, 6887, 6888, 6889, 6890, 5182, 2625, 2414, 6891, 6892, 6893, 6894, 4349, 595, 1753, 6895, 483, 16, 3606, 6896, 6897, 6898, 1757, 6899, 6900, 3609, 6901, 5010, 6902, 35, 6903, 6904 ],
  ),
  "connect_without_contact": SymbolsMetadata(
    popularity: 2083,
    codepoint: 0xf223,
    categories: [ 3 ],
    tags: [ 355, 6905, 443, 921, 211, 475, 6906, 6907, 588, 589, 6036, 4895, 223, 436, 488, 489, 5716, 6908, 3058, 227, 228, 607, 6909, 608, 6910, 2007, 5086, 501, 1159, 1862, 1902, 233, 234, 6911, 6912 ],
  ),
  "connected_tv": SymbolsMetadata(
    popularity: 819,
    codepoint: 0xe998,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2051, 2827, 355, 1684, 5865, 921, 922, 6913, 1685, 445, 6914, 12, 1711, 3337, 965, 1114, 6915, 1687, 367, 5872, 327, 223, 6916, 330, 5870, 227, 5871, 2057, 342, 343, 6917, 344, 1902, 1691, 233, 1054, 234 ],
  ),
  "connecting_airports": SymbolsMetadata(
    popularity: 845,
    codepoint: 0xe7c9,
    categories: [ 5 ],
    tags: [ 707, 6918, 2010, 1906, 1907, 1932, 2012, 2013, 2014, 1935, 1995, 211, 2016, 1484, 1917, 2017, 1918, 1973, 1501, 1581, 307, 909, 308, 2020, 1503, 227, 2023, 2007, 2008, 1930, 1504, 1981, 1591, 6919 ],
  ),
  "construction": SymbolsMetadata(
    popularity: 9407,
    codepoint: 0xea3c,
    categories: [ 15 ],
    tags: [ 4862, 798, 5804, 268, 2832, 1201, 6920, 2625, 2835, 2523, 1737, 6921, 6922, 6923, 6924, 2770, 6925, 5197, 2837, 329, 3474, 2631, 65, 6926, 5198, 2756, 6927, 6928, 6929, 6930, 5199 ],
  ),
  "contact_emergency": SymbolsMetadata(
    popularity: 717,
    codepoint: 0xf8d1,
    categories: [ 7 ],
    tags: [ 6931, 468, 469, 2479, 738, 3255, 470, 1133, 1113, 475, 848, 3775, 1751, 2482, 6932, 479, 4472, 595, 1753, 482, 1754, 483, 724, 1251, 6933, 484, 135, 1757, 219, 486, 488, 489, 226, 490, 602, 2486, 495, 1034, 501 ],
  ),
  "contact_mail": SymbolsMetadata(
    popularity: 4739,
    codepoint: 0xe0d0,
    categories: [ 7 ],
    tags: [ 468, 1429, 6934, 470, 799, 474, 443, 921, 475, 847, 6935, 2331, 6860, 6936, 2335, 479, 480, 6937, 482, 483, 484, 135, 6938, 4704, 2340, 6939, 485, 223, 4947, 488, 489, 3171, 490, 2343, 495, 501 ],
  ),
  "contact_page": SymbolsMetadata(
    popularity: 3555,
    codepoint: 0xf22e,
    categories: [ 12 ],
    tags: [ 6940, 468, 1429, 6934, 470, 443, 475, 847, 6941, 6935, 10, 132, 6936, 1528, 1347, 1654, 479, 1530, 1656, 1657, 1598, 6937, 482, 483, 135, 6942, 1534, 488, 489, 790, 490, 4786, 4787, 3767, 674, 495, 946, 501, 704 ],
  ),
  "contact_phone": SymbolsMetadata(
    popularity: 2809,
    codepoint: 0xe0cf,
    categories: [ 7 ],
    tags: [ 468, 6934, 738, 470, 1133, 6943, 474, 443, 921, 475, 6944, 6945, 6935, 6860, 1308, 6936, 479, 6937, 1309, 6946, 483, 484, 135, 485, 219, 23, 488, 489, 3171, 226, 6947, 6948, 490, 6949, 1318, 1257, 495, 1320, 501 ],
  ),
  "contact_support": SymbolsMetadata(
    popularity: 9797,
    codepoint: 0xe94c,
    categories: [ 7 ],
    tags: [ 4095, 6950, 738, 471, 472, 383, 473, 474, 475, 6935, 476, 6861, 477, 6951, 6952, 6937, 482, 6946, 484, 135, 6938, 1641, 485, 4101, 979, 4102, 6953, 4103, 492, 493, 494, 495, 35, 496 ],
    rtlAutoMirrored: true,
  ),
  "contactless": SymbolsMetadata(
    popularity: 1305,
    codepoint: 0xea71,
    categories: [ 9 ],
    tags: [ 2827, 4477, 355, 6954, 800, 383, 443, 921, 211, 212, 475, 6906, 6955, 805, 2332, 445, 831, 808, 6956, 6957, 6958, 820, 821, 6959, 2083, 122, 227, 4008, 551, 441, 6960, 842, 5086, 1902, 233, 234 ],
  ),
  "contactless_off": SymbolsMetadata(
    popularity: 88,
    codepoint: 0xf858,
    categories: [ 9 ],
    tags: [ 6961, 4477, 800, 383, 921, 211, 212, 475, 6906, 6962, 6963, 6964, 6965, 805, 445, 1077, 767, 6966, 898, 808, 899, 6967, 6968, 6969, 6970, 6971, 6972, 6973, 6974, 6975, 6976, 6977, 907, 6978, 908, 909, 820, 821, 6979, 171, 227, 6980, 914, 6981, 6982, 6983, 842, 233, 234, 2050, 6984 ],
  ),
  "contacts": SymbolsMetadata(
    popularity: 4791,
    codepoint: 0xe0ba,
    categories: [ 7 ],
    tags: [ 468, 6934, 470, 846, 1133, 1113, 383, 443, 211, 6985, 848, 6936, 479, 6986, 930, 1190, 483, 91, 6987, 484, 135, 92, 6988, 219, 223, 488, 489, 226, 490, 6989, 77, 2899, 6990, 946, 1214, 501 ],
  ),
  "contacts_product": SymbolsMetadata(
    popularity: 241,
    codepoint: 0xe999,
    categories: [ 6 ],
    tags: [ 755, 468, 1126, 6991, 6992, 211, 6768, 475, 848, 6993, 6994, 930, 6770, 885, 6987, 2528, 936, 6995, 6996, 488, 489, 1622, 6997, 490, 1153, 2631, 2755, 946, 6773, 501, 1159 ],
  ),
  "content_copy": SymbolsMetadata(
    popularity: 20056,
    codepoint: 0xe14d,
    categories: [ 12 ],
    tags: [ 1750, 3753, 1042, 6998, 6999, 1707, 7000, 1062, 5807, 10, 1528, 1347, 2999, 1530, 53, 135, 1066, 778, 2557, 4915, 1534, 3000, 6073, 75, 5482, 7001, 1665, 32, 107, 1069, 38, 2007, 315 ],
    rtlAutoMirrored: true,
  ),
  "content_cut": SymbolsMetadata(
    popularity: 1790,
    codepoint: 0xe14e,
    categories: [ 12 ],
    tags: [ 949, 1469, 1750, 1042, 7002, 1707, 1819, 5807, 897, 3303, 1370, 1528, 1347, 696, 2299, 7003, 7004, 6243, 1530, 7005, 778, 6073, 911, 7006, 1377, 4850, 7007, 7008, 1378, 2537, 7009 ],
    rtlAutoMirrored: true,
  ),
  "content_paste": SymbolsMetadata(
    popularity: 3433,
    codepoint: 0xe14f,
    categories: [ 12 ],
    tags: [ 1230, 3115, 1631, 1469, 1750, 1042, 1707, 5807, 10, 1528, 1347, 696, 1530, 1598, 135, 966, 92, 2557, 3155, 1533, 1456, 6073, 6129, 75, 1353, 190, 32, 3296, 1570, 3159, 38, 704 ],
  ),
  "content_paste_go": SymbolsMetadata(
    popularity: 608,
    codepoint: 0xea8e,
    categories: [ 12 ],
    tags: [ 949, 380, 1509, 1469, 1750, 1633, 1042, 776, 388, 767, 1528, 1347, 337, 898, 1672, 1530, 2910, 1542, 778, 780, 909, 6073, 781, 75, 1353, 782, 2343, 1665, 914, 32, 1412, 1645, 2007, 346 ],
  ),
  "content_paste_off": SymbolsMetadata(
    popularity: 285,
    codepoint: 0xe4f8,
    categories: [ 12 ],
    tags: [ 1074, 895, 1750, 1042, 1707, 1202, 5807, 4440, 1077, 767, 1528, 1347, 696, 898, 1530, 899, 1598, 901, 7010, 7011, 7012, 1532, 3155, 907, 909, 6073, 7013, 911, 171, 914, 915, 3736 ],
  ),
  "content_paste_search": SymbolsMetadata(
    popularity: 1629,
    codepoint: 0xea9b,
    categories: [ 12 ],
    tags: [ 3811, 3115, 7014, 1631, 1750, 1042, 7015, 1707, 10, 132, 4292, 1528, 1347, 6874, 958, 1530, 960, 135, 4294, 4350, 976, 6073, 2506, 4359, 3184, 980, 1645, 3937, 2165, 2388, 317, 986 ],
  ),
  "contextual_token": SymbolsMetadata(
    popularity: 72,
    codepoint: 0xf486,
    categories: [ 4 ],
    tags: [ 2501, 1042, 7016, 7017, 7018, 7019, 10, 7020, 1528, 1347, 696, 1530, 7021, 135, 7022, 1044, 306, 2503, 1534, 2295, 1048, 2630, 75, 77, 32, 35, 38, 6080, 441, 7023, 1214, 40, 7024, 7025, 1215, 704 ],
    rtlAutoMirrored: true,
  ),
  "contextual_token_add": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf485,
    categories: [ 4 ],
    tags: [ 192, 526, 1057, 2501, 4864, 268, 7016, 7017, 1201, 1735, 1528, 1347, 696, 3327, 1530, 2550, 1206, 1044, 1620, 306, 366, 92, 788, 1740, 763, 1211, 2503, 656, 1534, 202, 75, 77, 65, 32, 107, 35, 38, 441, 7023, 704 ],
    rtlAutoMirrored: true,
  ),
  "contract": SymbolsMetadata(
    popularity: 242,
    codepoint: 0xf5a0,
    categories: [ 12 ],
    tags: [ 7026, 1230, 7027, 2919, 1707, 5750, 1528, 1347, 1530, 7028, 1598, 135, 817, 3361, 366, 92, 1532, 7029, 7030, 1534, 1535, 7031, 7032, 1721, 121, 75, 1353, 4786, 6122, 7033, 38, 842 ],
  ),
  "contract_delete": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf5a2,
    categories: [ 12 ],
    tags: [ 7034, 7026, 895, 7035, 3436, 2950, 2919, 1202, 4563, 897, 7036, 6426, 1528, 1347, 3438, 2985, 1530, 92, 4152, 7037, 1534, 1535, 7031, 4449, 121, 4450, 911, 7038, 7039, 7040, 1083, 5593, 7041, 842, 7042, 3736, 7043 ],
  ),
  "contract_edit": SymbolsMetadata(
    popularity: 200,
    codepoint: 0xf5a1,
    categories: [ 12 ],
    tags: [ 7026, 1726, 2488, 1230, 1731, 693, 6872, 2919, 2376, 1201, 1528, 1347, 1853, 696, 2299, 1530, 1598, 966, 817, 92, 1755, 1740, 1532, 1534, 1535, 7031, 2693, 2694, 121, 3184, 2497, 7033, 38, 842, 1260, 1536, 704 ],
  ),
  "contrast": SymbolsMetadata(
    popularity: 1318,
    codepoint: 0xeb37,
    categories: [ 1 ],
    tags: [ 733, 1128, 7044, 794, 7045, 1728, 383, 1734, 3690, 5024, 7046, 5035, 12, 1370, 696, 2299, 2567, 959, 7047, 5042, 7048, 53, 5799, 3680, 7049, 4220, 6800, 59, 61, 119, 5801, 3685, 65, 1378, 7050, 7051, 41, 317, 5023, 7052, 7053 ],
    rtlAutoMirrored: true,
  ),
  "contrast_circle": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf49f,
    categories: [ 1 ],
    tags: [ 192, 81, 733, 526, 1128, 7054, 1728, 383, 1734, 269, 3690, 2922, 12, 1370, 696, 7055, 2299, 7056, 7057, 7058, 53, 1207, 7059, 3680, 7060, 1116, 59, 202, 330, 65, 1378, 1122, 41, 5023 ],
  ),
  "contrast_rtl_off": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xec72,
    categories: [ 1 ],
    tags: [ 733, 7061, 7045, 383, 1734, 7062, 7063, 7064, 3302, 7065, 3304, 7066, 767, 325, 696, 2299, 2567, 898, 959, 7047, 7057, 53, 5799, 4409, 901, 7067, 7060, 4410, 7068, 907, 908, 909, 61, 119, 5801, 7069, 3151, 65, 7070, 914, 7071, 5023, 4583, 7052 ],
  ),
  "contrast_square": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf4a0,
    categories: [ 1 ],
    tags: [ 192, 79, 733, 526, 1128, 7044, 7054, 1728, 1734, 269, 3690, 2922, 2969, 12, 325, 696, 7055, 2299, 7056, 7058, 53, 1207, 7059, 3680, 7060, 1116, 327, 1770, 3422, 202, 3685, 65, 32, 1122, 1701 ],
  ),
  "control_camera": SymbolsMetadata(
    popularity: 325,
    codepoint: 0xe074,
    categories: [ 0 ],
    tags: [ 1128, 5957, 380, 419, 5488, 47, 7072, 116, 1730, 383, 269, 1416, 388, 832, 270, 1738, 3089, 53, 1375, 126, 367, 2903, 778, 278, 59, 61, 121, 177, 7073, 1396, 32, 5545, 5546, 36, 41, 7074, 2814, 352 ],
  ),
  "control_point_duplicate": SymbolsMetadata(
    popularity: 604,
    codepoint: 0xe3bb,
    categories: [ 1 ],
    tags: [ 192, 526, 2520, 2827, 383, 3753, 269, 1360, 1707, 1201, 1202, 2332, 299, 3108, 2999, 696, 787, 2996, 2550, 305, 1207, 1218, 2557, 3261, 763, 3282, 1081, 1586, 202, 1363, 2367, 5482, 7001, 35, 3025 ],
  ),
  "controller_gen": SymbolsMetadata(
    popularity: 240,
    codepoint: 0xe83d,
    categories: [ 8 ],
    tags: [ 526, 3453, 4862, 298, 383, 693, 7075, 4865, 269, 5258, 1201, 6582, 832, 7076, 1598, 2550, 7077, 7078, 6632, 7079, 7080, 1004, 763, 7081, 202, 1363, 1837, 7082, 78, 32, 108 ],
  ),
  "conversion_path": SymbolsMetadata(
    popularity: 2696,
    codepoint: 0xf0c1,
    categories: [ 9 ],
    tags: [ 1056, 5, 3352, 84, 1731, 7083, 211, 1778, 7084, 2332, 1484, 956, 2189, 926, 7085, 1581, 1602, 935, 1045, 421, 3362, 1586, 942, 28, 1503, 7086, 104, 108, 109, 947, 2571, 7087, 2746 ],
  ),
  "conversion_path_off": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf7b4,
    categories: [ 9 ],
    tags: [ 1056, 5, 3352, 894, 7088, 1075, 7083, 1778, 7089, 7090, 7091, 7084, 896, 7092, 767, 956, 898, 7093, 7094, 901, 7095, 1602, 7096, 907, 908, 909, 1586, 7097, 7098, 7099, 7100, 7101, 7102, 7103, 914, 7104, 7105 ],
  ),
  "convert_to_text": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf41f,
    categories: [ 12 ],
    tags: [ 380, 2501, 1731, 1042, 7106, 3121, 7107, 388, 1528, 1347, 2651, 337, 696, 7108, 1672, 1530, 1372, 777, 1542, 366, 1740, 1534, 1535, 7109, 979, 3122, 75, 3124, 309, 1396, 982, 32, 38, 2007, 427, 7110, 40, 2185, 704 ],
  ),
  "conveyor_belt": SymbolsMetadata(
    popularity: 107,
    codepoint: 0xf867,
    categories: [ 9 ],
    tags: [ 7111, 2148, 4611, 7112, 7113, 1019, 2210, 7114, 926, 6923, 6924, 1602, 7115, 3896, 1717, 7116, 6925, 7117, 1858, 2647, 942, 1622, 6296, 7118, 28, 100, 4604, 7119, 3899, 2632, 1842, 1930, 3902 ],
  ),
  "cookie": SymbolsMetadata(
    popularity: 2181,
    codepoint: 0xeaac,
    categories: [ 3 ],
    tags: [ 3785, 3787, 7120, 7121, 5098, 1039, 5250, 7122, 7123, 383, 7124, 7125, 7126, 10, 3797, 3800, 7127, 7128, 1829, 7129, 329, 1516, 889, 65, 3809, 3810, 947, 5319, 7130, 7131 ],
  ),
  "cookie_off": SymbolsMetadata(
    popularity: 80,
    codepoint: 0xf79a,
    categories: [ 3 ],
    tags: [ 7132, 7120, 1074, 7133, 7134, 7135, 895, 383, 7136, 7124, 7137, 7125, 10, 7138, 897, 3797, 7139, 767, 898, 899, 7140, 6527, 7141, 7142, 907, 908, 909, 329, 1516, 7143, 911, 7144, 1011, 65, 914, 947, 7130, 7145, 7146 ],
  ),
  "cooking": SymbolsMetadata(
    popularity: 1090,
    codepoint: 0xe2b6,
    categories: [ 8 ],
    tags: [ 7147, 7148, 7149, 7150, 3793, 1269, 3795, 4386, 7151, 7152, 7153, 6170, 7154, 1829, 4390, 6174, 3076, 7155, 999, 1435, 7156, 3802, 4396, 7157, 3804, 7158, 1004, 3805, 4482, 5639, 7159, 6178, 7160, 3967, 7161, 7162, 7163, 6376, 6368 ],
  ),
  "cool_to_dry": SymbolsMetadata(
    popularity: 203,
    codepoint: 0xe276,
    categories: [ 10 ],
    tags: [ 3325, 1731, 712, 5721, 717, 7164, 385, 2922, 1500, 4471, 7165, 7166, 926, 2790, 999, 1904, 2798, 2315, 1004, 942, 2930, 1787, 7167, 35, 727, 729, 441, 427, 2571, 2801, 1862, 1902, 731 ],
  ),
  "copy_all": SymbolsMetadata(
    popularity: 1114,
    codepoint: 0xe2ec,
    categories: [ 12 ],
    tags: [ 2325, 1750, 3753, 1633, 1042, 1707, 7168, 7169, 7000, 5807, 2448, 2449, 1528, 1347, 2999, 2352, 1530, 1066, 2557, 1534, 1535, 2841, 75, 2367, 5482, 7001, 190, 1377, 2381, 371, 32, 1069, 38, 2007 ],
  ),
  "copyright": SymbolsMetadata(
    popularity: 2493,
    codepoint: 0xe90c,
    categories: [ 9 ],
    tags: [ 7170, 4, 3352, 3116, 691, 8, 383, 7171, 7172, 1042, 1707, 3357, 3359, 3128, 3577, 7173, 14, 16, 7174, 4963, 5075, 817, 7175, 19, 3361, 3119, 3363, 4329, 7176, 7177, 7178, 35, 38, 4965 ],
  ),
  "coronavirus": SymbolsMetadata(
    popularity: 2406,
    codepoint: 0xf221,
    categories: [ 3 ],
    tags: [ 178, 6331, 2412, 1113, 383, 7179, 585, 586, 587, 2414, 956, 7180, 6333, 6334, 595, 2416, 6336, 7181, 1757, 7182, 4355, 7183, 598, 7184, 7185, 5039, 603, 2424, 7186, 607, 7187, 5193 ],
  ),
  "corporate_fare": SymbolsMetadata(
    popularity: 3687,
    codepoint: 0xf1d0,
    categories: [ 9 ],
    tags: [ 468, 3313, 2601, 1325, 1936, 828, 798, 1284, 2602, 1285, 5242, 1327, 3166, 2605, 3318, 7188, 7189, 808, 7190, 1456, 940, 821, 1495, 1337, 5246, 286, 2614, 1446, 2616, 2617, 2618, 1930, 1504, 1591, 2621, 1459 ],
  ),
  "cottage": SymbolsMetadata(
    popularity: 3589,
    codepoint: 0xe587,
    categories: [ 16 ],
    tags: [ 2599, 2601, 3923, 798, 5203, 5262, 5204, 1817, 4825, 2604, 1434, 2605, 867, 999, 5205, 7191, 1435, 4615, 5997, 2610, 5207, 1490, 1495, 1444, 2614, 1445, 2615, 1446, 2616, 7192, 1838, 2617, 5266, 32, 3846, 5209, 1701, 2024, 7193 ],
  ),
  "counter_0": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf785,
    categories: [ 12 ],
    tags: [ 5058, 458, 5, 6, 383, 9, 86, 11, 4013, 188, 2472, 7194, 937, 7195, 486, 6303, 23, 24, 3641, 28, 29, 101, 2851, 889, 7196, 33, 35, 7197, 191, 947, 375 ],
  ),
  "counter_1": SymbolsMetadata(
    popularity: 565,
    codepoint: 0xf784,
    categories: [ 12 ],
    tags: [ 79, 6, 84, 383, 9, 86, 11, 1020, 90, 188, 5206, 2472, 7194, 486, 23, 24, 25, 3542, 3641, 28, 29, 101, 889, 7196, 7198, 108, 3935, 35, 1033, 947 ],
  ),
  "counter_2": SymbolsMetadata(
    popularity: 235,
    codepoint: 0xf783,
    categories: [ 12 ],
    tags: [ 81, 7199, 6, 383, 9, 86, 11, 1020, 188, 1620, 2472, 92, 7194, 486, 23, 7200, 7201, 24, 25, 96, 28, 29, 100, 101, 889, 7196, 103, 104, 3935, 35, 1033, 315, 7202 ],
  ),
  "counter_3": SymbolsMetadata(
    popularity: 188,
    codepoint: 0xf782,
    categories: [ 12 ],
    tags: [ 82, 458, 6, 7203, 383, 9, 86, 11, 188, 2245, 2472, 459, 7194, 486, 7204, 23, 24, 25, 7205, 28, 29, 100, 3582, 2851, 889, 7196, 6705, 3935, 35, 7197, 374, 191 ],
  ),
  "counter_4": SymbolsMetadata(
    popularity: 105,
    codepoint: 0xf781,
    categories: [ 12 ],
    tags: [ 534, 458, 6, 383, 9, 86, 11, 1020, 538, 188, 1620, 2472, 92, 7194, 486, 23, 24, 25, 96, 28, 29, 889, 104, 6705, 3935, 461, 35, 1033, 191, 2165, 2593 ],
  ),
  "counter_5": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf780,
    categories: [ 12 ],
    tags: [ 564, 458, 6, 383, 9, 86, 11, 4707, 697, 188, 2472, 7194, 7206, 486, 7204, 23, 24, 7205, 28, 29, 3582, 1257, 889, 7196, 6705, 3935, 35, 7197, 191, 2165 ],
  ),
  "counter_6": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf77f,
    categories: [ 12 ],
    tags: [ 580, 458, 6, 383, 9, 86, 11, 3360, 188, 2472, 7194, 390, 486, 23, 24, 25, 7205, 1496, 29, 101, 1257, 889, 7196, 7207, 6705, 3935, 461, 35, 191, 2165, 947 ],
  ),
  "counter_7": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf77e,
    categories: [ 12 ],
    tags: [ 636, 458, 6, 383, 9, 86, 11, 3360, 188, 1620, 2472, 92, 7194, 390, 486, 23, 24, 25, 96, 1496, 28, 29, 3582, 1257, 889, 7196, 104, 641, 6705, 3935, 35, 191 ],
  ),
  "counter_8": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf77d,
    categories: [ 12 ],
    tags: [ 658, 6, 7208, 7209, 383, 9, 86, 11, 1020, 661, 5014, 188, 2472, 459, 7194, 486, 23, 24, 7205, 3641, 3962, 28, 29, 101, 889, 7196, 7210, 5780, 6705, 3935, 35, 1033, 191 ],
  ),
  "counter_9": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf77c,
    categories: [ 12 ],
    tags: [ 677, 458, 6, 383, 9, 86, 11, 188, 1620, 2472, 459, 92, 7194, 682, 486, 23, 24, 25, 7205, 96, 28, 29, 100, 3582, 889, 7196, 104, 6705, 3935, 35, 7197, 191 ],
  ),
  "countertops": SymbolsMetadata(
    popularity: 480,
    codepoint: 0xf1f7,
    categories: [ 8 ],
    tags: [ 4004, 1868, 7211, 6342, 4005, 86, 7212, 7213, 7214, 1433, 3990, 1964, 999, 2080, 1435, 6349, 4418, 3802, 7215, 2800, 75, 7216, 5815, 3999, 32, 1380, 4008, 7217, 7218, 4001, 3986 ],
  ),
  "create_new_folder": SymbolsMetadata(
    popularity: 3920,
    codepoint: 0xe2cc,
    categories: [ 2 ],
    tags: [ 192, 526, 7219, 2151, 1042, 1201, 7220, 7221, 7222, 10, 6936, 1528, 1347, 1654, 1530, 4781, 1656, 7223, 135, 763, 7224, 7225, 98, 202, 7226, 2843, 1664, 4786, 4787, 674, 35 ],
  ),
  "credit_card": SymbolsMetadata(
    popularity: 14493,
    codepoint: 0xe870,
    categories: [ 9 ],
    tags: [ 468, 794, 796, 797, 1325, 799, 800, 1326, 801, 803, 1327, 805, 829, 806, 830, 7227, 807, 7228, 834, 808, 811, 2080, 818, 819, 836, 820, 821, 1337, 840, 75, 77, 841, 7229, 35, 4008, 842, 843 ],
  ),
  "credit_card_clock": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf438,
    categories: [ 9 ],
    tags: [ 989, 797, 7230, 799, 800, 1016, 801, 803, 1327, 805, 829, 7231, 7232, 7233, 7234, 806, 1017, 1018, 807, 6404, 1020, 7235, 808, 1023, 818, 819, 820, 7236, 7237, 821, 7238, 7239, 7240, 7241, 2858, 1337, 840, 7242, 1029, 1031, 841, 35, 289, 1033, 842, 7243, 2147 ],
  ),
  "credit_card_gear": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf52d,
    categories: [ 9 ],
    tags: [ 1230, 797, 1325, 7244, 799, 7245, 800, 1731, 4175, 4176, 801, 803, 268, 7246, 7247, 1327, 805, 829, 7248, 806, 7249, 132, 807, 7250, 7251, 808, 7252, 3485, 484, 135, 7253, 7254, 818, 7255, 819, 656, 820, 821, 1336, 7256, 7257, 790, 329, 1337, 75, 2631, 65, 841, 35 ],
  ),
  "credit_card_heart": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf52c,
    categories: [ 9 ],
    tags: [ 468, 796, 797, 1670, 799, 800, 7258, 801, 803, 3314, 1327, 805, 829, 806, 6993, 807, 3316, 4470, 7228, 3578, 808, 4455, 1560, 4768, 5758, 3118, 818, 819, 820, 821, 3641, 4771, 1337, 840, 7259, 4270, 3584, 1664, 841, 532, 495, 35 ],
  ),
  "credit_card_off": SymbolsMetadata(
    popularity: 758,
    codepoint: 0xe4f4,
    categories: [ 9 ],
    tags: [ 796, 797, 1074, 895, 799, 800, 801, 803, 1327, 805, 829, 806, 896, 7249, 5450, 897, 767, 807, 7228, 898, 2766, 808, 899, 7067, 818, 7260, 7261, 7262, 907, 819, 820, 821, 1336, 7256, 1337, 840, 75, 911, 912, 841, 914, 35, 842, 915 ],
  ),
  "credit_score": SymbolsMetadata(
    popularity: 3050,
    codepoint: 0xeff1,
    categories: [ 9 ],
    tags: [ 468, 2717, 1549, 2480, 796, 797, 799, 800, 1630, 1632, 801, 803, 1633, 1327, 805, 829, 7263, 806, 807, 1639, 808, 809, 4192, 1023, 135, 5735, 1641, 818, 1643, 819, 820, 821, 1213, 102, 1353, 7196, 288, 35, 1647, 2385, 2386, 2387, 2388, 1523, 2389, 1650 ],
  ),
  "crib": SymbolsMetadata(
    popularity: 492,
    codepoint: 0xe588,
    categories: [ 8 ],
    tags: [ 3598, 3599, 7264, 4226, 1909, 862, 4234, 3602, 865, 4227, 7265, 4228, 2332, 867, 1964, 3606, 870, 871, 7266, 4236, 3609, 4230, 5009, 75, 1925, 7267, 4231, 190, 1929, 7268, 7269, 3612 ],
  ),
  "crisis_alert": SymbolsMetadata(
    popularity: 2206,
    codepoint: 0xebe9,
    categories: [ 5 ],
    tags: [ 3175, 951, 1244, 469, 4942, 1245, 3073, 355, 1775, 1693, 383, 1732, 7270, 3176, 2482, 2766, 2767, 1251, 5223, 2769, 1641, 486, 3782, 7271, 2772, 5861, 602, 1011, 2485, 35, 36, 4677, 441, 1034, 1261 ],
  ),
  "crop": SymbolsMetadata(
    popularity: 1382,
    codepoint: 0xe3be,
    categories: [ 1 ],
    tags: [ 1128, 7054, 993, 2301, 994, 2391, 1819, 7272, 5807, 696, 2299, 274, 5969, 53, 7273, 3145, 7274, 5799, 366, 1361, 59, 7275, 3422, 5800, 119, 75, 2930, 2247, 2281, 371, 65, 311, 673, 32, 427, 7009 ],
  ),
  "crop_16_9": SymbolsMetadata(
    popularity: 560,
    codepoint: 0xe3bc,
    categories: [ 1 ],
    tags: [ 142, 2300, 677, 1128, 7054, 993, 2301, 7276, 6289, 1469, 1819, 5807, 12, 696, 2299, 270, 1372, 274, 53, 3145, 5799, 1543, 367, 278, 59, 5800, 119, 7277, 3149, 75, 2247, 77, 2281, 330, 65, 673, 32, 7009, 41, 364, 2309 ],
  ),
  "crop_3_2": SymbolsMetadata(
    popularity: 309,
    codepoint: 0xe3bd,
    categories: [ 1 ],
    tags: [ 81, 82, 7278, 1128, 7054, 993, 2301, 994, 7276, 1819, 7279, 696, 7280, 7281, 2299, 274, 53, 7282, 7273, 3145, 7283, 7284, 7285, 5799, 59, 7275, 3422, 7286, 5800, 7287, 4548, 7288, 75, 2247, 77, 2281, 65, 311, 673, 32, 7009 ],
  ),
  "crop_5_4": SymbolsMetadata(
    popularity: 328,
    codepoint: 0xe3bf,
    categories: [ 1 ],
    tags: [ 534, 564, 7289, 1128, 7054, 993, 2301, 994, 7276, 1819, 7290, 7291, 7272, 696, 7292, 7293, 7294, 274, 53, 7273, 3145, 7295, 117, 5799, 59, 3422, 7296, 118, 5800, 119, 7287, 3149, 75, 2247, 190, 77, 2281, 673, 32 ],
  ),
  "crop_7_5": SymbolsMetadata(
    popularity: 458,
    codepoint: 0xe3c0,
    categories: [ 1 ],
    tags: [ 564, 636, 7297, 7298, 1128, 7054, 993, 2301, 994, 7276, 1469, 1819, 7279, 5807, 696, 2299, 274, 53, 4534, 7273, 3145, 117, 5799, 59, 7275, 3422, 118, 5800, 7299, 7287, 75, 2247, 2281, 288, 371, 65, 673, 32, 7009 ],
  ),
  "crop_9_16": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf549,
    categories: [ 1 ],
    tags: [ 142, 2300, 677, 7300, 1128, 7054, 993, 2301, 7276, 1469, 1819, 7279, 5807, 696, 2299, 274, 53, 7273, 3145, 5799, 7301, 7302, 59, 7275, 3422, 5800, 854, 7303, 75, 2247, 2281, 65, 7304, 673, 7305, 32, 7306, 7009, 7307, 7308, 364 ],
  ),
  "crop_free": SymbolsMetadata(
    popularity: 1669,
    codepoint: 0xe3c2,
    categories: [ 1 ],
    tags: [ 1128, 7054, 2301, 994, 2391, 1819, 7309, 12, 696, 2299, 1738, 274, 5969, 7310, 7311, 7312, 7313, 53, 7273, 3145, 1361, 59, 3422, 5800, 119, 7287, 2247, 288, 371, 65, 673, 32, 427, 7009, 986 ],
  ),
  "crop_landscape": SymbolsMetadata(
    popularity: 352,
    codepoint: 0xe3c3,
    categories: [ 1 ],
    tags: [ 2300, 1128, 7054, 993, 2301, 994, 1469, 1819, 5807, 12, 696, 2299, 787, 1372, 274, 53, 3145, 5799, 1543, 59, 3422, 5800, 119, 3149, 75, 2930, 2247, 2281, 330, 65, 673, 7009, 317, 2309 ],
  ),
  "crop_portrait": SymbolsMetadata(
    popularity: 449,
    codepoint: 0xe3c5,
    categories: [ 1 ],
    tags: [ 1128, 7054, 993, 2301, 349, 1469, 1819, 7272, 5807, 696, 2299, 274, 53, 7273, 3145, 5799, 3147, 1361, 59, 3422, 5800, 119, 7287, 854, 5503, 3149, 75, 2930, 2247, 2281, 65, 673, 32, 7009, 1381 ],
  ),
  "crop_rotate": SymbolsMetadata(
    popularity: 316,
    codepoint: 0xe437,
    categories: [ 1 ],
    tags: [ 7314, 6421, 1128, 7315, 7054, 378, 993, 380, 419, 6547, 2907, 1062, 3523, 1819, 7279, 696, 2299, 274, 53, 7316, 7317, 5799, 3147, 59, 7318, 5800, 119, 7073, 396, 397, 65, 673, 399, 32, 427, 402 ],
  ),
  "crop_square": SymbolsMetadata(
    popularity: 1971,
    codepoint: 0xe3c6,
    categories: [ 1 ],
    tags: [ 7319, 1128, 7054, 1229, 1230, 993, 2301, 994, 2750, 1819, 7320, 7321, 7322, 7279, 7272, 299, 7323, 696, 2299, 787, 274, 304, 53, 7273, 3145, 5799, 2751, 2653, 59, 7275, 3422, 5800, 7287, 3149, 75, 2247, 2281, 330, 65, 311, 5922, 2882, 673, 32, 7324, 7009, 2757, 2759, 1691, 1053, 1054 ],
  ),
  "crossword": SymbolsMetadata(
    popularity: 64,
    codepoint: 0xf5e5,
    categories: [ 3 ],
    tags: [ 918, 6183, 7325, 6184, 6187, 7326, 3153, 3337, 697, 1659, 6189, 246, 1218, 3375, 7327, 6191, 7328, 7329, 202, 6637, 7330, 3157, 3347, 311, 944, 6193, 3160, 6641, 3637, 7331, 7332, 7333, 7334 ],
  ),
  "crowdsource": SymbolsMetadata(
    popularity: 175,
    codepoint: 0xeb18,
    categories: [ 3 ],
    tags: [ 754, 1284, 3281, 4863, 194, 3314, 7335, 7336, 478, 480, 481, 7337, 811, 930, 7338, 6631, 6632, 966, 815, 2528, 223, 2653, 4947, 7339, 821, 488, 7340, 2071, 3058, 607, 7341, 946, 983, 791, 7342, 3855 ],
  ),
  "crown": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xecb3,
    categories: [ 3 ],
    tags: [ 3, 2730, 3574, 6, 3575, 6188, 7343, 5756, 90, 7344, 16, 4218, 7345, 7346, 2472, 3118, 7347, 7348, 3782, 531, 4224, 101, 3582, 5911, 553, 35, 7349, 7350, 1124, 2852, 3858, 3588, 5766, 3589 ],
  ),
  "cruelty_free": SymbolsMetadata(
    popularity: 2503,
    codepoint: 0xe799,
    categories: [ 3 ],
    tags: [ 5177, 7351, 7352, 7353, 3600, 7354, 7355, 7356, 7357, 7358, 6814, 7359, 479, 959, 7310, 7360, 16, 7361, 2528, 7362, 1859, 7363, 7364, 3974, 7365, 7366, 7367, 841, 7368, 607, 2370, 2371, 35, 5192, 7369, 7370, 7371 ],
  ),
  "css": SymbolsMetadata(
    popularity: 1613,
    codepoint: 0xeb93,
    categories: [ 2 ],
    tags: [ 186, 687, 4, 690, 3909, 7372, 8, 2624, 6581, 6582, 1186, 2625, 88, 1347, 6583, 2835, 1530, 3540, 14, 7373, 6584, 215, 19, 1194, 2630, 7374, 7375, 2182, 7376, 35, 38, 3554, 40, 702, 1691, 7377, 7378, 1241, 1053 ],
  ),
  "csv": SymbolsMetadata(
    popularity: 123,
    codepoint: 0xe6cf,
    categories: [ 12 ],
    tags: [ 687, 4, 8, 7379, 7380, 7381, 10, 7382, 7383, 3754, 3050, 1347, 337, 1672, 1530, 7384, 3540, 7385, 14, 1372, 1542, 19, 2653, 75, 1664, 7386, 1379, 7387, 32, 35, 1380, 38, 7388, 40, 346, 7389 ],
  ),
  "currency_bitcoin": SymbolsMetadata(
    popularity: 1914,
    codepoint: 0xebc5,
    categories: [ 9 ],
    tags: [ 797, 7390, 7391, 7392, 799, 800, 801, 803, 1327, 805, 7393, 7394, 806, 7395, 88, 7396, 3315, 807, 2138, 2627, 808, 7397, 16, 815, 7398, 2528, 1291, 7399, 818, 819, 820, 821, 1337, 841, 35, 5752, 842, 7400, 843, 3324 ],
  ),
  "currency_exchange": SymbolsMetadata(
    popularity: 5912,
    codepoint: 0xeb70,
    categories: [ 9 ],
    tags: [ 376, 2284, 380, 419, 796, 800, 383, 384, 801, 803, 1778, 7106, 806, 7401, 385, 388, 3315, 807, 2627, 808, 3524, 390, 818, 820, 821, 424, 2494, 396, 397, 5256, 313, 1667, 5752, 842, 2007, 402, 2455, 7402, 1260, 3323 ],
  ),
  "currency_franc": SymbolsMetadata(
    popularity: 245,
    codepoint: 0xeafa,
    categories: [ 9 ],
    tags: [ 796, 797, 799, 800, 7403, 7404, 7405, 7406, 801, 803, 7407, 1327, 805, 806, 7408, 3315, 807, 2627, 808, 7409, 7397, 7410, 7411, 7412, 7413, 7414, 818, 819, 820, 821, 1337, 841, 7415, 7416, 7417, 7418, 35, 842, 7419 ],
  ),
  "currency_lira": SymbolsMetadata(
    popularity: 332,
    codepoint: 0xeaef,
    categories: [ 9 ],
    tags: [ 468, 796, 797, 828, 1618, 799, 800, 801, 803, 1327, 805, 806, 3315, 807, 1937, 2627, 808, 3319, 2527, 815, 7420, 7421, 818, 819, 820, 821, 1337, 286, 3322, 841, 35, 842, 7422, 7423, 7424, 7425, 1214, 3324 ],
  ),
  "currency_pound": SymbolsMetadata(
    popularity: 1022,
    codepoint: 0xeaf1,
    categories: [ 9 ],
    tags: [ 796, 797, 7426, 799, 800, 801, 803, 1327, 805, 806, 3315, 807, 7427, 2627, 808, 7428, 7429, 811, 7430, 7431, 7432, 815, 7433, 818, 819, 820, 821, 7434, 7435, 1337, 840, 841, 7436, 35, 842, 7437, 7438, 3324, 7439 ],
  ),
  "currency_ruble": SymbolsMetadata(
    popularity: 612,
    codepoint: 0xeaec,
    categories: [ 9 ],
    tags: [ 796, 797, 1284, 799, 800, 801, 803, 1327, 805, 806, 7440, 3315, 807, 7441, 2627, 808, 811, 1205, 7414, 815, 7442, 7433, 818, 819, 820, 821, 1337, 840, 286, 7443, 7444, 7445, 7446, 841, 35, 842, 3324 ],
  ),
  "currency_rupee": SymbolsMetadata(
    popularity: 3392,
    codepoint: 0xeaf7,
    categories: [ 9 ],
    tags: [ 3313, 796, 797, 828, 7447, 799, 800, 801, 803, 1327, 805, 806, 3315, 807, 3317, 7448, 2627, 808, 811, 2080, 7449, 7450, 7451, 815, 1291, 818, 819, 820, 821, 1337, 840, 7452, 3322, 841, 35, 441, 5752, 842, 3324 ],
  ),
  "currency_rupee_circle": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf460,
    categories: [ 9 ],
    tags: [ 468, 796, 797, 828, 799, 800, 383, 801, 803, 1327, 805, 806, 3315, 807, 3317, 7448, 2627, 808, 809, 811, 7449, 7450, 7451, 815, 818, 819, 820, 821, 1337, 840, 889, 7452, 841, 35, 842, 3324 ],
  ),
  "currency_yen": SymbolsMetadata(
    popularity: 1053,
    codepoint: 0xeafb,
    categories: [ 9 ],
    tags: [ 7453, 7454, 796, 797, 1618, 799, 800, 801, 803, 1327, 805, 806, 3315, 807, 2627, 808, 809, 3319, 815, 3958, 3959, 7455, 1291, 818, 819, 820, 821, 1337, 840, 286, 3322, 841, 35, 441, 5752, 842, 1214, 3324, 7456, 7457 ],
  ),
  "currency_yuan": SymbolsMetadata(
    popularity: 307,
    codepoint: 0xeaf9,
    categories: [ 9 ],
    tags: [ 7453, 7454, 796, 797, 799, 800, 7458, 7459, 7460, 801, 803, 1327, 805, 7461, 806, 3315, 807, 7448, 2627, 808, 3958, 3959, 7455, 818, 819, 820, 821, 1337, 7462, 7463, 841, 35, 842, 1214, 1215, 7456, 7464 ],
  ),
  "curtains": SymbolsMetadata(
    popularity: 279,
    codepoint: 0xec1e,
    categories: [ 8 ],
    tags: [ 4309, 4416, 267, 2950, 6660, 4365, 7465, 4417, 3690, 1416, 7466, 7467, 274, 1659, 7468, 4418, 3680, 1004, 2653, 189, 1516, 2948, 4204, 4422, 6705, 7469, 4209, 3412, 7470, 1054, 4425, 7471, 4427 ],
  ),
  "curtains_closed": SymbolsMetadata(
    popularity: 144,
    codepoint: 0xec1d,
    categories: [ 8 ],
    tags: [ 4416, 267, 4428, 7472, 4365, 7473, 4417, 3690, 5978, 6697, 999, 2796, 278, 1004, 4220, 189, 1516, 75, 1960, 4204, 2997, 4422, 1929, 6705, 4209, 3412, 441, 2252, 1592, 7474, 1054, 4424, 4425 ],
  ),
  "custom_typography": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xe732,
    categories: [ 12 ],
    tags: [ 3495, 685, 1128, 4, 1731, 8, 2919, 785, 7019, 7475, 6676, 1735, 2922, 696, 787, 959, 14, 1372, 1204, 1207, 4704, 19, 1740, 2281, 65, 2933, 673, 372, 3264, 2182, 35, 38, 7476, 5027, 1744, 40, 702 ],
  ),
  "cycle": SymbolsMetadata(
    popularity: 866,
    codepoint: 0xf854,
    categories: [ 2 ],
    tags: [ 380, 419, 1731, 383, 2902, 384, 2907, 2349, 3523, 385, 388, 926, 1023, 7477, 3513, 2568, 390, 421, 780, 2876, 942, 6822, 424, 425, 2494, 2367, 426, 3516, 7478, 396, 397, 889, 5256, 313, 402, 2455, 1260 ],
  ),
  "cyclone": SymbolsMetadata(
    popularity: 709,
    codepoint: 0xebd5,
    categories: [ 3 ],
    tags: [ 7479, 1775, 383, 384, 712, 1732, 7270, 7480, 4668, 7481, 7482, 7483, 1857, 7484, 7485, 7486, 397, 399, 2463, 4650, 6640, 36, 441, 7487, 7488, 7489, 2801, 731, 1863, 7490, 7491 ],
  ),
  "dangerous": SymbolsMetadata(
    popularity: 3230,
    codepoint: 0xe99a,
    categories: [ 6 ],
    tags: [ 892, 469, 894, 5098, 895, 1693, 2950, 3775, 1202, 3176, 7492, 897, 2766, 1737, 899, 4647, 1251, 2769, 7493, 3696, 4152, 3580, 2772, 4447, 911, 171, 5861, 1011, 7494, 1083, 4677, 1260, 1261, 7495, 3736 ],
  ),
  "dark_mode": SymbolsMetadata(
    popularity: 11816,
    codepoint: 0xe51c,
    categories: [ 4 ],
    tags: [ 733, 1229, 1230, 4243, 4212, 1728, 4244, 4246, 4247, 3690, 5024, 7046, 445, 12, 4251, 2751, 7496, 4252, 307, 4253, 4220, 4254, 329, 65, 1171, 1929, 313, 5027, 314, 2757, 792, 7497, 2759, 5023, 1053 ],
  ),
  "dashboard": SymbolsMetadata(
    popularity: 16409,
    codepoint: 0xe871,
    categories: [ 12 ],
    tags: [ 5, 1229, 1230, 5793, 3233, 269, 2515, 10, 1372, 246, 999, 135, 2518, 306, 7498, 936, 788, 937, 327, 421, 7499, 1770, 75, 2258, 1353, 5922, 32, 944, 6403, 3426, 947, 317, 1691, 1053, 7500, 1054 ],
  ),
  "dashboard_2": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf3ea,
    categories: [ 12 ],
    tags: [ 5, 1230, 2170, 5792, 5793, 2750, 3234, 2515, 7501, 10, 12, 1372, 246, 7502, 2516, 2751, 306, 937, 5794, 940, 7499, 4855, 75, 2258, 7503, 5922, 32, 944, 6403, 3426, 792, 317, 1691, 1053, 1054, 1084 ],
  ),
  "dashboard_customize": SymbolsMetadata(
    popularity: 2498,
    codepoint: 0xe99b,
    categories: [ 12 ],
    tags: [ 526, 1197, 1367, 918, 5793, 4864, 268, 269, 1201, 1735, 2515, 696, 3327, 787, 1372, 246, 1207, 306, 1755, 1740, 763, 656, 98, 2695, 202, 75, 1377, 65, 5922, 32, 944, 3426, 1691, 1053, 7504 ],
  ),
  "data_alert": SymbolsMetadata(
    popularity: 144,
    codepoint: 0xf7f6,
    categories: [ 2 ],
    tags: [ 3175, 469, 5, 3073, 1693, 3176, 2515, 10, 7505, 3756, 1347, 2766, 2767, 1530, 1251, 135, 2516, 2769, 1066, 92, 7506, 1641, 485, 937, 486, 2772, 1353, 1376, 3761, 1379, 107, 674, 35, 1380, 1261 ],
  ),
  "data_array": SymbolsMetadata(
    popularity: 507,
    codepoint: 0xead1,
    categories: [ 12 ],
    tags: [ 3638, 3909, 2624, 7507, 6580, 2155, 1269, 10, 7508, 7509, 7510, 7511, 7512, 7513, 7514, 7515, 7516, 2625, 3327, 135, 7517, 92, 5135, 2630, 6588, 104, 3918, 945, 35, 6591 ],
  ),
  "data_check": SymbolsMetadata(
    popularity: 199,
    codepoint: 0xf7f2,
    categories: [ 2 ],
    tags: [ 1627, 1549, 2480, 1630, 1632, 575, 1633, 1636, 2376, 10, 7518, 7519, 7520, 7521, 7522, 3756, 1639, 135, 7523, 7524, 92, 7506, 1641, 1643, 5136, 1376, 288, 107, 1647, 6088, 2386, 2387, 1523, 2389, 1650 ],
  ),
  "data_exploration": SymbolsMetadata(
    popularity: 1461,
    codepoint: 0xe76f,
    categories: [ 9 ],
    tags: [ 7525, 5, 380, 4290, 920, 383, 10, 4291, 7526, 7527, 2847, 924, 4292, 832, 5575, 958, 960, 929, 196, 933, 135, 2516, 967, 4686, 976, 597, 937, 28, 1354, 4359, 980, 33, 947, 5176, 7528 ],
  ),
  "data_info_alert": SymbolsMetadata(
    popularity: 106,
    codepoint: 0xf7f5,
    categories: [ 2 ],
    tags: [ 7529, 469, 1245, 738, 383, 10, 3756, 6325, 132, 6326, 960, 3225, 482, 6063, 5463, 484, 135, 7530, 4686, 1066, 4695, 366, 92, 7506, 486, 1353, 1376, 3761, 2631, 107, 674, 495, 7531, 6070, 1261 ],
  ),
  "data_loss_prevention": SymbolsMetadata(
    popularity: 133,
    codepoint: 0xe2dc,
    categories: [ 6 ],
    tags: [ 755, 468, 7014, 470, 3241, 10, 7532, 3244, 955, 958, 479, 960, 964, 483, 850, 7533, 4294, 967, 1489, 971, 7534, 973, 974, 975, 976, 488, 489, 599, 1516, 490, 7535, 3184, 3249, 980, 1011, 981, 7536, 7537, 7538, 501, 317, 7539 ],
  ),
  "data_object": SymbolsMetadata(
    popularity: 1850,
    codepoint: 0xead3,
    categories: [ 12 ],
    tags: [ 3638, 1074, 7540, 3909, 2624, 7507, 6580, 7541, 954, 7542, 10, 7543, 7515, 1186, 6595, 2625, 963, 6585, 7517, 422, 5135, 2630, 6588, 3379, 1196, 6590, 945, 6591, 2229 ],
  ),
  "data_saver_on": SymbolsMetadata(
    popularity: 507,
    codepoint: 0xeff3,
    categories: [ 4 ],
    tags: [ 192, 526, 5, 7544, 3512, 210, 920, 383, 211, 10, 7545, 7546, 7547, 7548, 7549, 7550, 7551, 7552, 924, 929, 3053, 1207, 933, 7553, 7554, 597, 937, 433, 7555, 7556, 763, 909, 202, 329, 7557, 7558, 1257, 7559, 4094, 65, 33, 35, 947 ],
  ),
  "data_table": SymbolsMetadata(
    popularity: 230,
    codepoint: 0xe99c,
    categories: [ 9 ],
    tags: [ 2513, 1229, 1230, 2151, 7560, 3639, 920, 1368, 802, 2750, 1042, 10, 7561, 3756, 299, 1347, 246, 135, 2751, 306, 6121, 92, 1755, 2753, 219, 327, 98, 226, 5136, 1353, 1603, 1376, 330, 4786, 2882, 106, 1379, 674, 945, 1380, 447, 2757, 2759, 317, 1691, 1053, 1054 ],
  ),
  "data_thresholding": SymbolsMetadata(
    popularity: 1536,
    codepoint: 0xeb9f,
    categories: [ 2 ],
    tags: [ 2513, 5, 2311, 994, 920, 10, 4291, 7562, 7563, 2847, 924, 959, 929, 1078, 2517, 2518, 2472, 459, 634, 937, 189, 1516, 1353, 1354, 171, 32, 33, 441, 563, 7564, 7565, 947, 2852, 1355 ],
  ),
  "data_usage": SymbolsMetadata(
    popularity: 1277,
    codepoint: 0xe1af,
    categories: [ 4 ],
    tags: [ 5, 5098, 3512, 210, 920, 383, 4499, 212, 10, 7549, 7566, 7552, 7567, 896, 924, 7568, 767, 7569, 929, 3053, 933, 215, 2568, 597, 937, 433, 223, 907, 3055, 28, 6980, 33, 947, 7570, 2049 ],
  ),
  "database": SymbolsMetadata(
    popularity: 12989,
    codepoint: 0xf20e,
    categories: [ 9 ],
    tags: [ 5, 1651, 1343, 365, 7571, 920, 383, 1652, 801, 268, 1269, 7572, 10, 3756, 924, 2157, 929, 135, 5073, 1755, 597, 937, 7573, 223, 7574, 7575, 3749, 3761, 65, 7576, 107, 33, 674, 551, 441, 947, 7577 ],
  ),
  "database_off": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf414,
    categories: [ 9 ],
    tags: [ 5, 1343, 365, 895, 920, 801, 7572, 10, 7578, 3873, 7579, 3756, 7580, 7581, 7582, 924, 1077, 767, 3306, 2037, 898, 929, 597, 937, 7583, 7584, 7585, 7586, 907, 908, 909, 3761, 7587, 7588, 7589, 914, 33, 674, 7590, 7591, 7592, 441, 947 ],
  ),
  "database_search": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf38e,
    categories: [ 9 ],
    tags: [ 5, 1343, 365, 920, 801, 7572, 10, 7593, 7594, 7595, 7596, 3744, 3756, 7597, 7598, 924, 7599, 7600, 959, 960, 7601, 7602, 964, 929, 135, 7603, 7604, 971, 972, 973, 974, 975, 976, 597, 937, 979, 980, 7605, 981, 107, 33, 674, 441, 947 ],
  ),
  "database_upload": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf3dc,
    categories: [ 9 ],
    tags: [ 526, 5, 380, 1343, 365, 920, 383, 1652, 7606, 801, 1540, 7572, 10, 6549, 3756, 7607, 924, 7599, 929, 1542, 135, 966, 1044, 1674, 3513, 597, 937, 3012, 1664, 2343, 3761, 1665, 107, 33, 674, 1412, 441, 947, 2007, 1676, 1260, 346, 3061, 3062 ],
  ),
  "dataset": SymbolsMetadata(
    popularity: 4301,
    codepoint: 0xf8ee,
    categories: [ 2 ],
    tags: [ 2513, 5, 2151, 3639, 2155, 802, 10, 3756, 7608, 255, 246, 135, 306, 936, 2753, 98, 1068, 5136, 1353, 2843, 1376, 1379, 32, 674, 945, 1380, 317, 1054 ],
  ),
  "dataset_linked": SymbolsMetadata(
    popularity: 1459,
    codepoint: 0xf8ef,
    categories: [ 2 ],
    tags: [ 1058, 1061, 921, 211, 10, 213, 3756, 7608, 7609, 1672, 2628, 246, 1472, 1542, 4867, 1064, 935, 1000, 7610, 1067, 223, 3124, 7611, 7612, 7613, 1665, 1379, 1380, 7614 ],
  ),
  "date_range": SymbolsMetadata(
    popularity: 7498,
    codepoint: 0xe916,
    categories: [ 6 ],
    tags: [ 5340, 1015, 1936, 5341, 7615, 1017, 7616, 7617, 5035, 1018, 1020, 2094, 5347, 98, 7618, 2838, 1007, 75, 4270, 1030, 1924, 1031, 7619, 32, 791, 289, 5395, 5351, 5372 ],
  ),
  "deblur": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xeb77,
    categories: [ 1 ],
    tags: [ 1128, 2827, 47, 953, 544, 2332, 7620, 956, 696, 2299, 2567, 528, 479, 959, 1738, 7057, 53, 4534, 4566, 3145, 4567, 54, 530, 366, 59, 3422, 4571, 61, 119, 2493, 30, 3749, 5063, 4577, 4578 ],
  ),
  "deceased": SymbolsMetadata(
    popularity: 70,
    codepoint: 0xe0a5,
    categories: [ 3 ],
    tags: [ 7621, 7622, 7623, 7624, 7625, 4011, 7626, 7627, 7628, 7629, 2433, 7630, 7631, 6277, 6816, 7632, 7633, 595, 7634, 7534, 5605, 7635, 1859, 7636, 7637, 1835, 5608, 7638, 7639, 7640, 7641, 7642 ],
  ),
  "decimal_decrease": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf82d,
    categories: [ 12 ],
    tags: [ 1128, 380, 419, 2375, 268, 806, 7643, 4439, 2922, 7644, 11, 2651, 808, 7645, 7646, 7647, 966, 1375, 7648, 1210, 2380, 818, 23, 1363, 1741, 29, 2930, 2493, 2281, 65, 7649, 463, 375, 2404 ],
  ),
  "decimal_increase": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xf82c,
    categories: [ 12 ],
    tags: [ 526, 1128, 380, 419, 7650, 268, 806, 7643, 7651, 50, 787, 808, 7645, 777, 7646, 7647, 7652, 196, 1207, 1217, 966, 7653, 2380, 818, 789, 780, 24, 7205, 202, 1741, 29, 1396, 65, 3935, 1676, 463 ],
  ),
  "deck": SymbolsMetadata(
    popularity: 837,
    codepoint: 0xea42,
    categories: [ 8 ],
    tags: [ 1283, 7654, 6228, 7655, 3835, 1964, 7656, 6816, 999, 1435, 7657, 1860, 7658, 3727, 3841, 3842, 4280, 3843, 3347, 1958, 1925, 5987, 4204, 2617, 607, 4206, 1380, 3847, 1701, 7659, 4210, 7642 ],
  ),
  "dehaze": SymbolsMetadata(
    popularity: 730,
    codepoint: 0xe3c7,
    categories: [ 1 ],
    tags: [ 1128, 2761, 298, 2950, 2896, 7660, 2983, 696, 2299, 528, 787, 6327, 7661, 2080, 16, 53, 7662, 1066, 366, 92, 788, 6328, 421, 2653, 656, 59, 61, 911, 65, 2993, 6386, 35, 441, 314, 7663, 7664 ],
  ),
  "delete": SymbolsMetadata(
    popularity: 70624,
    codepoint: 0xe872,
    categories: [ 2 ],
    tags: [ 3433, 7, 3434, 895, 3435, 3436, 1269, 897, 7665, 4665, 6426, 7666, 6451, 3438, 7667, 3439, 7668, 1361, 3440, 911, 7669, 6603, 441, 3444, 3445, 1214, 7670, 7671 ],
  ),
  "delete_forever": SymbolsMetadata(
    popularity: 13146,
    codepoint: 0xe92b,
    categories: [ 2 ],
    tags: [ 3433, 7, 3434, 895, 3435, 3436, 6377, 1269, 1202, 897, 7672, 4665, 6426, 3437, 7673, 6451, 3438, 2985, 2354, 3439, 7674, 7675, 3440, 911, 7676, 3444, 7677, 3445, 7671, 3736, 7678 ],
  ),
  "delete_history": SymbolsMetadata(
    popularity: 81,
    codepoint: 0xf518,
    categories: [ 6 ],
    tags: [ 380, 2489, 3035, 895, 7679, 383, 2490, 7680, 3436, 7681, 1016, 7682, 2950, 1202, 1017, 897, 7683, 3438, 2985, 1023, 7684, 4152, 2841, 4449, 424, 911, 7685, 2494, 426, 2881, 2886, 396, 1031, 1083, 289, 2099, 7686, 1033, 402, 2499, 3736 ],
  ),
  "delete_sweep": SymbolsMetadata(
    popularity: 2863,
    codepoint: 0xe16c,
    categories: [ 2 ],
    tags: [ 3433, 3434, 1871, 3435, 3436, 6377, 1269, 897, 6383, 7687, 7688, 7689, 6426, 3437, 3438, 7690, 3439, 2080, 7691, 3440, 7692, 911, 6384, 6375, 441, 3444, 3445, 7671 ],
  ),
  "delivery_truck_bolt": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf3a2,
    categories: [ 9 ],
    tags: [ 1814, 3467, 4076, 1815, 4611, 1816, 1019, 7693, 2210, 1329, 4078, 7694, 6014, 3779, 6015, 1021, 1022, 7695, 4614, 19, 4083, 6868, 3896, 2340, 1490, 1456, 2647, 4920, 1409, 4921, 1027, 7696, 7697, 2343, 4604, 841, 231, 2728, 3899, 7698, 4086, 1842, 1930, 1843, 1034, 1844 ],
  ),
  "delivery_truck_speed": SymbolsMetadata(
    popularity: 60,
    codepoint: 0xf3a1,
    categories: [ 9 ],
    tags: [ 1814, 1815, 4611, 1816, 1019, 7699, 7693, 2210, 1329, 7700, 1021, 7701, 1022, 7695, 4614, 19, 6868, 3896, 2340, 1490, 7702, 1456, 1621, 96, 2647, 4920, 1409, 4921, 1027, 7696, 1028, 7703, 7697, 7704, 2343, 4604, 841, 231, 2728, 1842, 1930, 1843, 1034, 1844 ],
  ),
  "demography": SymbolsMetadata(
    popularity: 111,
    codepoint: 0xe489,
    categories: [ 3 ],
    tags: [ 5, 584, 7705, 920, 194, 10, 1063, 7706, 132, 1528, 1347, 1530, 930, 595, 7707, 483, 7708, 850, 135, 92, 936, 1532, 940, 1534, 1535, 488, 489, 7709, 490, 5136, 1353, 7710, 33, 945, 1380, 946, 501, 704 ],
  ),
  "density_large": SymbolsMetadata(
    popularity: 579,
    codepoint: 0xeba9,
    categories: [ 2 ],
    tags: [ 2170, 7711, 2919, 2922, 7712, 588, 7713, 787, 1372, 2176, 2080, 1207, 7714, 3634, 306, 7715, 366, 7716, 2180, 2295, 2247, 601, 2181, 2281, 7717, 673, 2248, 38, 7718, 1214, 986 ],
  ),
  "density_medium": SymbolsMetadata(
    popularity: 2409,
    codepoint: 0xeb9e,
    categories: [ 2 ],
    tags: [ 2761, 2170, 2896, 269, 7712, 12, 787, 959, 6327, 2176, 2080, 2751, 1066, 366, 92, 4044, 7719, 788, 6328, 789, 421, 656, 96, 98, 601, 2181, 65, 106, 2248, 6386, 441, 317, 7664 ],
  ),
  "density_small": SymbolsMetadata(
    popularity: 1625,
    codepoint: 0xeba8,
    categories: [ 2 ],
    tags: [ 6653, 3086, 6247, 7711, 2919, 2922, 7712, 7720, 7721, 2176, 2080, 7714, 1066, 7722, 366, 92, 788, 2928, 6834, 656, 2930, 601, 2181, 3093, 65, 2933, 1979, 107, 6386, 7718, 7723, 2404 ],
  ),
  "dentistry": SymbolsMetadata(
    popularity: 666,
    codepoint: 0xe0a6,
    categories: [ 3 ],
    tags: [ 1015, 7540, 1182, 7724, 7725, 6188, 7726, 7727, 7728, 7729, 7730, 7731, 7732, 595, 3972, 7733, 1757, 7734, 6899, 7735, 7736, 1567, 5818, 7737, 7738, 7739, 7740 ],
  ),
  "departure_board": SymbolsMetadata(
    popularity: 711,
    codepoint: 0xe576,
    categories: [ 14 ],
    tags: [ 2013, 2014, 7741, 1814, 6182, 2062, 7742, 1815, 1816, 1016, 7743, 2063, 2016, 7744, 1581, 1490, 7745, 2071, 7746, 4601, 1031, 3611, 4621, 6598, 289, 1033, 5371, 4622, 7747, 4623, 7748, 1930, 1504, 6784, 1591, 1844 ],
  ),
  "deployed_code": SymbolsMetadata(
    popularity: 467,
    codepoint: 0xf720,
    categories: [ 2 ],
    tags: [ 406, 1230, 1074, 7, 1652, 2624, 6580, 1269, 1201, 408, 3064, 7749, 7750, 2625, 300, 2173, 1659, 1661, 5073, 1674, 7751, 3080, 223, 2647, 7752, 1194, 1622, 2504, 3068, 3761, 2631, 1196, 32, 7753 ],
  ),
  "deployed_code_account": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf51b,
    categories: [ 2 ],
    tags: [ 406, 755, 468, 1126, 1230, 7754, 7, 1731, 2624, 6580, 4864, 1269, 1201, 408, 1019, 3064, 7755, 7750, 132, 2625, 300, 2210, 479, 3485, 483, 1674, 7751, 1755, 936, 656, 3119, 3363, 2647, 7752, 488, 489, 1622, 490, 2504, 3068, 2843, 2631, 65, 1196, 501 ],
  ),
  "deployed_code_alert": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf5f2,
    categories: [ 2 ],
    tags: [ 3175, 406, 469, 1230, 3073, 4861, 7, 5178, 1693, 2624, 6580, 1269, 1201, 408, 3176, 1019, 7755, 7750, 2625, 300, 2766, 2767, 1659, 1251, 5223, 1674, 7751, 2769, 1641, 486, 2647, 7752, 2772, 6296, 3068, 2631, 2535, 1196, 32, 35, 441, 1261 ],
  ),
  "deployed_code_history": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf5f3,
    categories: [ 2 ],
    tags: [ 406, 989, 2151, 4861, 7, 6004, 7756, 1016, 2624, 6580, 6762, 1269, 7757, 1201, 408, 1017, 7755, 7750, 2625, 7758, 300, 7759, 6006, 1023, 1674, 7751, 7760, 5264, 2647, 7752, 2841, 2858, 3505, 1029, 3068, 2843, 1031, 1196, 289, 290, 4308, 7761 ],
  ),
  "deployed_code_update": SymbolsMetadata(
    popularity: 98,
    codepoint: 0xf5f4,
    categories: [ 2 ],
    tags: [ 406, 380, 2650, 419, 4861, 7, 383, 2624, 6580, 1269, 1201, 408, 7762, 3064, 7750, 2625, 300, 2173, 2651, 337, 6518, 1672, 6006, 5195, 1542, 1674, 7751, 2647, 7752, 7763, 3012, 3068, 2843, 2535, 1196, 1260, 6010 ],
  ),
  "dermatology": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xe0a7,
    categories: [ 3 ],
    tags: [ 7764, 7352, 7765, 7766, 584, 1749, 7767, 7355, 7768, 7769, 7770, 445, 7771, 7772, 7773, 7774, 7775, 6220, 595, 483, 2836, 390, 1757, 7776, 7777, 7778, 7779, 7780, 7368, 2537, 2428, 1905, 7781 ],
  ),
  "description": SymbolsMetadata(
    popularity: 34125,
    codepoint: 0xe873,
    categories: [ 12 ],
    tags: [ 2501, 1058, 693, 1042, 1201, 10, 6325, 1528, 1347, 337, 1654, 696, 1530, 1656, 1657, 135, 1044, 366, 1533, 2653, 1534, 1535, 2506, 1353, 1664, 4786, 4787, 2510, 38, 3114, 7388, 346, 317, 704 ],
  ),
  "deselect": SymbolsMetadata(
    popularity: 422,
    codepoint: 0xebb6,
    categories: [ 12 ],
    tags: [ 949, 951, 2325, 895, 3639, 266, 3436, 802, 10, 896, 4719, 1077, 767, 956, 2855, 898, 246, 2753, 7195, 907, 909, 281, 3021, 3641, 911, 1376, 288, 371, 65, 914, 1379, 32, 313, 1380, 314, 2537, 5588 ],
  ),
  "design_services": SymbolsMetadata(
    popularity: 4782,
    codepoint: 0xf10a,
    categories: [ 12 ],
    tags: [ 2601, 7782, 4862, 1061, 693, 2832, 7783, 1201, 1202, 299, 7784, 7785, 6582, 1853, 2833, 7786, 302, 696, 2299, 2835, 7787, 966, 1218, 1064, 597, 4915, 2693, 2694, 2107, 7788, 2631, 2755, 2756, 1536, 704, 3736 ],
  ),
  "desk": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xf8f4,
    categories: [ 8 ],
    tags: [ 5541, 2983, 7789, 1964, 5980, 999, 7790, 16, 2796, 4418, 7791, 7792, 1456, 7793, 940, 1361, 75, 7794, 674, 4689, 35, 1380, 7795, 441, 1459, 3508, 6841 ],
  ),
  "deskphone": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf7fa,
    categories: [ 11 ],
    tags: [ 5532, 5171, 1284, 952, 1133, 7796, 443, 7797, 921, 475, 476, 5541, 7798, 7799, 445, 1308, 7800, 1309, 965, 6946, 970, 5403, 219, 1456, 7801, 226, 1318, 1257, 495, 496, 1320, 7802, 7803 ],
  ),
  "desktop_access_disabled": SymbolsMetadata(
    popularity: 261,
    codepoint: 0xe99d,
    categories: [ 11 ],
    tags: [ 1109, 1110, 755, 894, 895, 1684, 694, 7804, 1202, 4440, 1685, 7805, 445, 767, 12, 898, 899, 965, 1114, 7067, 1687, 327, 7806, 2678, 7011, 907, 908, 909, 4447, 7807, 912, 171, 330, 7808, 914, 1083, 915, 1691, 1054, 3736 ],
  ),
  "desktop_cloud": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf3db,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1651, 1684, 1652, 6522, 3739, 7809, 6503, 3741, 694, 212, 7810, 3744, 1685, 7811, 7812, 445, 12, 337, 1654, 3745, 965, 1114, 1025, 215, 1687, 327, 223, 7813, 7814, 7815, 330, 674, 1667, 3750, 2632, 343, 344, 346, 2826, 7816, 1691, 1054, 1084 ],
  ),
  "desktop_cloud_stack": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf3be,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1651, 1684, 1652, 3739, 7817, 7818, 6503, 3741, 2155, 694, 211, 7810, 10, 1685, 7812, 445, 12, 337, 1654, 930, 965, 1114, 5073, 1025, 1687, 327, 223, 1194, 7815, 330, 2631, 1196, 107, 674, 1667, 3529, 2632, 343, 2007, 344, 346, 7816, 7819, 7820, 1691, 1054, 1084, 3508 ],
  ),
  "desktop_landscape": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf45e,
    categories: [ 2 ],
    tags: [ 1230, 7821, 1368, 694, 1062, 1685, 445, 12, 787, 2054, 2395, 246, 2751, 1543, 306, 2307, 327, 7822, 1770, 2400, 2648, 3156, 75, 2247, 1603, 330, 7823, 4899, 1378, 7824, 32, 313, 317, 2309, 1054 ],
    rtlAutoMirrored: true,
  ),
  "desktop_landscape_add": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf439,
    categories: [ 2 ],
    tags: [ 192, 526, 7825, 7826, 7827, 7828, 7829, 1368, 1201, 7830, 7831, 7832, 7833, 7834, 1685, 12, 787, 2996, 246, 1543, 306, 327, 7822, 763, 7835, 7836, 7837, 7838, 1211, 3003, 202, 7839, 7840, 7841, 1603, 330, 4899, 1378, 7824, 107, 35, 1054 ],
    rtlAutoMirrored: true,
  ),
  "desktop_mac": SymbolsMetadata(
    popularity: 1076,
    codepoint: 0xe30b,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2964, 4310, 5125, 1284, 1684, 443, 694, 1685, 7842, 445, 88, 12, 1711, 965, 999, 1114, 7843, 215, 1687, 327, 1456, 6839, 6840, 75, 330, 32, 4323, 551, 1691, 1054, 1459, 6841 ],
  ),
  "desktop_portrait": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf45d,
    categories: [ 2 ],
    tags: [ 2301, 1731, 1368, 694, 1062, 1685, 7842, 445, 88, 12, 1711, 274, 246, 3759, 306, 327, 7822, 3147, 6839, 854, 75, 396, 1603, 330, 7844, 4899, 1378, 7824, 32, 313, 551, 1381, 317, 1054, 6841 ],
    rtlAutoMirrored: true,
  ),
  "desktop_windows": SymbolsMetadata(
    popularity: 5167,
    codepoint: 0xe30c,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1230, 4310, 1284, 1684, 694, 1685, 7842, 445, 88, 12, 1711, 965, 1114, 1687, 327, 1456, 6839, 6840, 2648, 75, 190, 330, 1196, 32, 4323, 495, 551, 343, 344, 792, 317, 1691, 1054, 1084, 1459, 6841 ],
  ),
  "destruction": SymbolsMetadata(
    popularity: 83,
    codepoint: 0xf585,
    categories: [ 3 ],
    tags: [ 469, 4656, 7845, 4657, 4659, 4660, 4661, 3436, 5667, 2765, 4664, 3176, 897, 4665, 4666, 7846, 7847, 7848, 3438, 3104, 4669, 4080, 4647, 7849, 7850, 911, 7851, 5057, 4677, 1261 ],
  ),
  "details": SymbolsMetadata(
    popularity: 799,
    codepoint: 0xe3c8,
    categories: [ 1 ],
    tags: [ 6658, 7852, 380, 2871, 2862, 2950, 2896, 7853, 6660, 132, 3101, 7854, 2941, 696, 2299, 528, 787, 7855, 7856, 7857, 932, 53, 1066, 7648, 788, 789, 938, 2653, 59, 61, 2948, 4577, 7858, 7859, 7860, 314, 1701 ],
  ),
  "detection_and_zone": SymbolsMetadata(
    popularity: 307,
    codepoint: 0xe29f,
    categories: [ 10 ],
    tags: [ 755, 989, 469, 993, 994, 2391, 2805, 7861, 1597, 4408, 274, 999, 483, 7862, 420, 7863, 1858, 1004, 486, 1006, 489, 7864, 7865, 1008, 1009, 1011, 122, 32, 351, 985, 3939, 1013, 7866 ],
  ),
  "detector": SymbolsMetadata(
    popularity: 166,
    codepoint: 0xe282,
    categories: [ 10 ],
    tags: [ 1244, 469, 2148, 3669, 7867, 2805, 7868, 445, 2523, 999, 2080, 1896, 1897, 4458, 420, 1858, 1004, 486, 1519, 7869, 602, 1723, 1724, 1011, 122, 227, 1901, 5266, 351, 551, 441, 947, 1902, 234 ],
  ),
  "detector_alarm": SymbolsMetadata(
    popularity: 263,
    codepoint: 0xe1f7,
    categories: [ 10 ],
    tags: [ 1244, 469, 3669, 7870, 7867, 2805, 7868, 7871, 445, 2482, 999, 5512, 7872, 327, 420, 1858, 1004, 486, 1519, 1520, 75, 602, 1011, 122, 227, 2485, 5266, 1156, 351, 441, 985, 1261 ],
  ),
  "detector_battery": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xe204,
    categories: [ 10 ],
    tags: [ 1244, 469, 3769, 3772, 4028, 3773, 7867, 2805, 7868, 7873, 445, 7874, 3216, 2523, 4061, 965, 999, 188, 1897, 2472, 3780, 327, 1004, 3782, 602, 1011, 122, 7875, 227, 7876, 5266, 553, 351, 551, 7877 ],
  ),
  "detector_co": SymbolsMetadata(
    popularity: 142,
    codepoint: 0xe2af,
    categories: [ 10 ],
    tags: [ 1244, 469, 2148, 798, 7878, 953, 7867, 2805, 7868, 445, 956, 5601, 1854, 999, 1435, 1897, 2797, 327, 4458, 1004, 1519, 1520, 602, 1011, 122, 1901, 5266, 351, 1261 ],
  ),
  "detector_offline": SymbolsMetadata(
    popularity: 100,
    codepoint: 0xe223,
    categories: [ 10 ],
    tags: [ 469, 895, 211, 1202, 2805, 7868, 445, 767, 2037, 2766, 2768, 7879, 999, 2080, 901, 7880, 327, 1004, 223, 7881, 908, 2772, 75, 602, 1011, 122, 227, 5266, 351, 915, 1261, 3736 ],
  ),
  "detector_smoke": SymbolsMetadata(
    popularity: 443,
    codepoint: 0xe285,
    categories: [ 8 ],
    tags: [ 1244, 469, 798, 7882, 2804, 2805, 7868, 445, 2482, 5601, 7883, 7884, 7885, 4647, 3076, 999, 1435, 7886, 1004, 599, 1520, 5861, 602, 1011, 122, 5266, 7887, 441, 1261, 1902 ],
  ),
  "detector_status": SymbolsMetadata(
    popularity: 169,
    codepoint: 0xe1e8,
    categories: [ 10 ],
    tags: [ 1242, 1244, 2480, 2148, 1630, 1632, 2805, 7868, 445, 898, 7888, 999, 1897, 4458, 1004, 1643, 819, 7889, 1213, 75, 602, 1011, 122, 1901, 5266, 553, 2487, 351, 441, 1647, 2387, 1523, 7890 ],
  ),
  "developer_board": SymbolsMetadata(
    popularity: 1674,
    codepoint: 0xe30d,
    categories: [ 11 ],
    tags: [ 6182, 7891, 5250, 7892, 694, 4363, 1186, 7893, 2625, 445, 1711, 7894, 2835, 246, 965, 2751, 1897, 7895, 7896, 7897, 7898, 7899, 2630, 7900, 75, 3507, 32, 7901, 551 ],
  ),
  "developer_board_off": SymbolsMetadata(
    popularity: 176,
    codepoint: 0xe4ff,
    categories: [ 11 ],
    tags: [ 7902, 6182, 7903, 895, 5250, 7904, 7905, 694, 896, 7906, 1186, 7893, 2625, 7907, 7908, 767, 1711, 7909, 7894, 7910, 898, 965, 7911, 7895, 7896, 7912, 7913, 907, 909, 7899, 2630, 7914, 7915, 914, 7916 ],
  ),
  "developer_guide": SymbolsMetadata(
    popularity: 265,
    codepoint: 0xe99e,
    categories: [ 6 ],
    tags: [ 7026, 2622, 1910, 7917, 1670, 2719, 2624, 7507, 2919, 1186, 2625, 1528, 1347, 6726, 1530, 3226, 7918, 7919, 482, 135, 5485, 7920, 4695, 7921, 21, 2630, 2506, 75, 3124, 5248, 2181, 7922, 1196, 32, 495, 1070, 5881 ],
  ),
  "developer_mode": SymbolsMetadata(
    popularity: 1498,
    codepoint: 0xe1b0,
    categories: [ 11 ],
    tags: [ 1109, 1110, 3105, 1181, 419, 3751, 3909, 1113, 208, 3592, 383, 2624, 6580, 268, 6676, 1184, 1185, 1186, 7923, 6595, 2625, 445, 832, 6583, 965, 1114, 219, 7924, 1191, 3682, 307, 656, 226, 2630, 75, 65, 446, 1196, 32, 447, 441 ],
  ),
  "developer_mode_tv": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xe874,
    categories: [ 11 ],
    tags: [ 1109, 1110, 3105, 1230, 3909, 3592, 1684, 2624, 6580, 268, 1184, 1185, 1685, 6582, 1186, 7923, 2625, 445, 4182, 12, 965, 1114, 1687, 307, 327, 2630, 330, 65, 5871, 1196, 343, 344, 7925, 7926, 7927, 7928, 1691, 1054 ],
  ),
  "device_band": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf2f5,
    categories: [ 11 ],
    tags: [ 989, 469, 2588, 4477, 7929, 211, 7572, 10, 445, 88, 2926, 2927, 4634, 595, 5778, 219, 327, 486, 75, 3331, 1929, 2591, 5780, 109, 551, 947, 2102, 2715, 2594, 234, 7930 ],
  ),
  "device_hub": SymbolsMetadata(
    popularity: 1240,
    codepoint: 0xe335,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1994, 3026, 383, 1061, 7931, 694, 921, 7932, 211, 1685, 445, 7933, 7934, 7935, 2173, 2210, 1711, 965, 932, 3236, 1114, 1064, 6320, 4052, 935, 1067, 6321, 219, 327, 7936, 223, 7937, 226, 1665, 3058, 32, 945, 447, 551, 948, 1701, 2102, 2594, 1691 ],
  ),
  "device_thermostat": SymbolsMetadata(
    popularity: 2707,
    codepoint: 0xe1ff,
    categories: [ 11 ],
    tags: [ 1128, 7938, 712, 269, 717, 7939, 445, 7940, 3560, 3076, 3235, 7941, 723, 188, 366, 634, 7942, 3561, 327, 889, 122, 65, 1901, 7943, 3442, 727, 728, 7944, 7945, 729, 1381, 731 ],
  ),
  "device_unknown": SymbolsMetadata(
    popularity: 554,
    codepoint: 0xe339,
    categories: [ 11 ],
    tags: [ 4095, 1109, 1110, 738, 1113, 445, 7946, 6951, 960, 965, 482, 7947, 1114, 484, 135, 6938, 2769, 6127, 4100, 219, 1675, 7948, 226, 2772, 4101, 979, 4102, 4103, 75, 77, 980, 446, 495, 35, 447, 7949, 7950, 1364, 7951, 7952 ],
  ),
  "devices": SymbolsMetadata(
    popularity: 7047,
    codepoint: 0xe1b1,
    categories: [ 11 ],
    tags: [ 1109, 1110, 4074, 208, 443, 694, 211, 1685, 445, 7953, 88, 832, 1711, 965, 5090, 1114, 4052, 935, 5867, 219, 327, 223, 3000, 6839, 226, 7954, 75, 7814, 77, 330, 3058, 446, 32, 1667, 447, 551, 7955, 2007, 2102, 2594, 1691 ],
  ),
  "devices_fold": SymbolsMetadata(
    popularity: 265,
    codepoint: 0xebde,
    categories: [ 4 ],
    tags: [ 1109, 1110, 1367, 1910, 7917, 1113, 2950, 7956, 2896, 2448, 2449, 445, 7953, 4832, 7957, 787, 6665, 7958, 7959, 965, 7960, 1114, 1066, 306, 2307, 788, 2928, 219, 7822, 2653, 1770, 226, 2280, 330, 2993, 1378, 447, 2949, 1054 ],
  ),
  "devices_fold_2": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf406,
    categories: [ 4 ],
    tags: [ 1109, 1110, 3042, 1113, 2950, 2896, 1062, 445, 1347, 7957, 787, 1530, 6665, 7958, 965, 900, 7960, 1114, 4964, 2307, 2928, 219, 2653, 1081, 1534, 7961, 226, 2948, 330, 2997, 107, 1070, 447, 2949, 1054 ],
  ),
  "devices_off": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf7a5,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2033, 1074, 895, 2053, 208, 2950, 694, 7962, 4563, 896, 897, 1685, 3303, 445, 2673, 7953, 2969, 1077, 7963, 7964, 7965, 7966, 767, 7967, 7968, 3306, 7969, 7970, 4249, 898, 2189, 2985, 899, 965, 1114, 4052, 1602, 935, 903, 5867, 219, 327, 1164, 223, 7971, 2043, 7972, 7973, 7974, 7975, 2680, 7976, 7977, 2045, 907, 908, 909, 226, 7954, 6602, 5868, 75, 911, 7978, 7979, 912, 330, 3058, 913, 1170, 914, 446, 32, 1083, 7980, 7981, 7982, 7983, 447, 5587, 915, 3312, 7984, 2102, 2594, 1691, 234 ],
  ),
  "devices_other": SymbolsMetadata(
    popularity: 1147,
    codepoint: 0xe337,
    categories: [ 11 ],
    tags: [ 1109, 1110, 7985, 1229, 1230, 379, 1113, 1684, 211, 3234, 2515, 1685, 445, 2673, 7953, 88, 7986, 1711, 2590, 930, 965, 1114, 1896, 1897, 7987, 1687, 219, 327, 7936, 2451, 4481, 226, 1194, 75, 7988, 6616, 446, 2591, 32, 1667, 447, 551, 417, 405, 2102, 2594, 2596, 1054 ],
    rtlAutoMirrored: true,
  ),
  "devices_wearables": SymbolsMetadata(
    popularity: 155,
    codepoint: 0xf6ab,
    categories: [ 11 ],
    tags: [ 2587, 469, 379, 1133, 1113, 472, 383, 1016, 211, 269, 445, 7953, 88, 1711, 2590, 965, 1114, 2629, 1896, 1897, 935, 936, 219, 486, 4481, 226, 75, 77, 330, 65, 3237, 446, 2591, 1667, 447, 551, 38, 289, 2593, 405, 2102, 7989, 2596, 1691, 2598 ],
  ),
  "dew_point": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf879,
    categories: [ 3 ],
    tags: [ 2513, 1847, 7479, 712, 5721, 6247, 7990, 7991, 7992, 4471, 7993, 7994, 5723, 6392, 1904, 16, 188, 597, 634, 1857, 1877, 2799, 1363, 7995, 7486, 7996, 35, 727, 7945, 7997, 2801, 7998, 731 ],
  ),
  "diagnosis": SymbolsMetadata(
    popularity: 103,
    codepoint: 0xe0a8,
    categories: [ 12 ],
    tags: [ 2513, 2514, 799, 4452, 7725, 10, 2413, 1528, 1347, 6874, 1530, 1598, 595, 7999, 1753, 4455, 135, 19, 4768, 1757, 8000, 1532, 1534, 1535, 1762, 1765, 121, 75, 1353, 4475, 77, 1214, 4461, 4646, 1905, 704 ],
  ),
  "diagonal_line": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf41e,
    categories: [ 12 ],
    tags: [ 378, 8001, 1343, 8002, 1182, 920, 383, 953, 921, 211, 2969, 924, 1370, 956, 2834, 696, 2299, 8003, 8004, 304, 929, 1064, 1602, 935, 223, 8005, 1586, 3641, 8006, 1503, 2264, 311, 8007, 8008, 32, 945 ],
    rtlAutoMirrored: true,
  ),
  "dialer_sip": SymbolsMetadata(
    popularity: 267,
    codepoint: 0xe0bb,
    categories: [ 7 ],
    tags: [ 4, 5411, 1133, 7796, 1113, 8, 443, 5400, 921, 475, 445, 1308, 8009, 8010, 14, 1309, 8011, 965, 8012, 215, 8013, 8014, 19, 219, 8015, 8016, 8017, 226, 5407, 5080, 1318, 3228, 8018, 8019, 8020, 8021, 35, 496, 438, 439, 1320, 38, 40, 1161, 5421, 8022, 5466, 8023 ],
  ),
  "dialogs": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xe99f,
    categories: [ 2 ],
    tags: [ 949, 469, 1229, 1230, 7, 471, 5173, 472, 473, 6735, 443, 2750, 476, 299, 477, 8024, 478, 480, 481, 135, 2751, 306, 485, 2341, 6052, 219, 327, 8025, 8026, 486, 226, 1049, 330, 2882, 492, 493, 32, 944, 447, 496, 8027, 3159, 2757, 2759, 1691, 1053, 1054 ],
  ),
  "dialpad": SymbolsMetadata(
    popularity: 1420,
    codepoint: 0xe0bc,
    categories: [ 7 ],
    tags: [ 3638, 952, 1133, 953, 443, 475, 445, 1308, 8028, 50, 956, 246, 966, 2751, 970, 219, 8029, 24, 7205, 8030, 8031, 226, 8032, 446, 1320, 8033, 8034, 8035, 5410 ],
  ),
  "diamond": SymbolsMetadata(
    popularity: 4418,
    codepoint: 0xead5,
    categories: [ 3 ],
    tags: [ 3, 5249, 3671, 8036, 1416, 8037, 8038, 8039, 2705, 1418, 8040, 8041, 1659, 8042, 8043, 2528, 1944, 3118, 1361, 1662, 531, 62, 1296, 3584, 311, 8044, 2487, 8045, 8046, 8047, 8048, 5766, 3324 ],
  ),
  "dictionary": SymbolsMetadata(
    popularity: 180,
    codepoint: 0xf539,
    categories: [ 12 ],
    tags: [ 686, 4, 1910, 668, 4702, 3153, 4703, 8049, 135, 4686, 5651, 3375, 4704, 8050, 2159, 366, 972, 3463, 1534, 2506, 2507, 3124, 3158, 980, 4689, 38, 4691, 8051, 8052, 8053, 8054 ],
  ),
  "difference": SymbolsMetadata(
    popularity: 1450,
    codepoint: 0xeb7d,
    categories: [ 12 ],
    tags: [ 3313, 526, 794, 2375, 6004, 3812, 3813, 1042, 1734, 1707, 5807, 1694, 8055, 5333, 8056, 6799, 1528, 1347, 2999, 1530, 1655, 6006, 1066, 1210, 1116, 2557, 1081, 2841, 202, 2264, 7387, 107, 1122, 8057, 8058, 6010 ],
  ),
  "digital_out_of_home": SymbolsMetadata(
    popularity: 287,
    codepoint: 0xf1de,
    categories: [ 0 ],
    tags: [ 1037, 8059, 2602, 443, 8060, 8061, 12, 8062, 135, 8063, 8064, 1045, 367, 421, 8065, 8066, 489, 2162, 1050, 8067, 8068, 330, 1589, 1701, 2621, 3939, 3229 ],
  ),
  "digital_wellbeing": SymbolsMetadata(
    popularity: 205,
    codepoint: 0xef86,
    categories: [ 3 ],
    tags: [ 468, 1229, 1230, 794, 584, 3600, 383, 88, 8069, 8070, 8071, 1190, 595, 8072, 8073, 8074, 4455, 483, 4768, 8075, 8076, 6635, 8077, 489, 490, 8078, 8079, 8080, 501, 8081, 4646, 8082, 1905 ],
  ),
  "dining": SymbolsMetadata(
    popularity: 884,
    codepoint: 0xeff4,
    categories: [ 8 ],
    tags: [ 7, 3790, 3792, 8083, 6165, 8084, 3798, 8085, 3799, 4275, 3800, 3801, 8086, 7128, 1829, 8087, 2000, 8088, 3803, 3804, 788, 8089, 3807, 1960, 8090, 3809, 8091, 32, 8092, 8093, 6376 ],
  ),
  "dinner_dining": SymbolsMetadata(
    popularity: 970,
    codepoint: 0xea57,
    categories: [ 16 ],
    tags: [ 3790, 6165, 6169, 6170, 3798, 3799, 4275, 8094, 8095, 3800, 8096, 7128, 1829, 4974, 2000, 4217, 8097, 3803, 3804, 4977, 8098, 8099, 6615, 3807, 8090, 8100, 8092, 4283, 6376, 8101 ],
  ),
  "directions": SymbolsMetadata(
    popularity: 1672,
    codepoint: 0xe52e,
    categories: [ 5 ],
    tags: [ 380, 8102, 776, 1062, 1416, 388, 1578, 777, 1488, 3225, 1001, 1002, 1490, 421, 780, 1586, 781, 2452, 1396, 3227, 1587, 396, 1503, 7494, 32, 1589, 1590, 2008, 1504, 402, 8103, 3229 ],
    rtlAutoMirrored: true,
  ),
  "directions_alt": SymbolsMetadata(
    popularity: 248,
    codepoint: 0xf880,
    categories: [ 5 ],
    tags: [ 380, 776, 1484, 1416, 8104, 1578, 8105, 8106, 777, 1488, 1001, 1002, 1490, 421, 780, 1586, 2865, 781, 1396, 782, 396, 1503, 3228, 7494, 32, 1424, 1590, 1504, 3229 ],
    rtlAutoMirrored: true,
  ),
  "directions_alt_off": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf881,
    categories: [ 5 ],
    tags: [ 8107, 8108, 2441, 8109, 380, 3302, 1578, 8110, 8111, 1077, 767, 898, 1488, 8112, 8113, 901, 1001, 8114, 8115, 1002, 8116, 8117, 1490, 421, 8118, 8119, 8120, 8121, 8122, 907, 909, 1396, 1503, 7102, 7494, 914, 32, 1590 ],
  ),
  "directions_bike": SymbolsMetadata(
    popularity: 2982,
    codepoint: 0xe52f,
    categories: [ 14 ],
    tags: [ 989, 4311, 4312, 8123, 383, 2063, 386, 4326, 388, 1578, 2925, 2927, 1488, 483, 16, 3344, 1001, 1002, 1490, 421, 489, 2071, 3347, 2072, 8124, 1503, 105, 5780, 750, 1930, 1504, 4340 ],
    rtlAutoMirrored: true,
  ),
  "directions_boat": SymbolsMetadata(
    popularity: 2121,
    codepoint: 0xe532,
    categories: [ 14 ],
    tags: [ 1814, 2521, 1815, 4611, 1816, 4597, 388, 1578, 8125, 8126, 4599, 1490, 2529, 2530, 2532, 421, 2533, 1922, 2071, 8127, 8128, 2476, 2535, 4604, 2023, 1842, 1930, 1504, 1844, 6368, 4605, 2801, 8129, 1862, 1902 ],
  ),
  "directions_bus": SymbolsMetadata(
    popularity: 3368,
    codepoint: 0xe530,
    categories: [ 14 ],
    tags: [ 1814, 2062, 5227, 5222, 1815, 1816, 7743, 2063, 1484, 1578, 1581, 1001, 1002, 1490, 421, 1922, 2071, 4601, 5230, 2072, 1503, 2073, 2008, 1842, 1930, 5236, 1504, 5237, 1591, 1844 ],
  ),
  "directions_car": SymbolsMetadata(
    popularity: 10361,
    codepoint: 0xe531,
    categories: [ 14 ],
    tags: [ 2014, 1131, 1814, 3467, 1815, 8130, 1816, 2063, 2016, 1484, 388, 1578, 3484, 8131, 8132, 8133, 1488, 1581, 1001, 1490, 421, 2071, 2072, 4516, 1503, 8134, 1590, 1842, 1930, 1504, 1591, 1844 ],
  ),
  "directions_off": SymbolsMetadata(
    popularity: 139,
    codepoint: 0xf10f,
    categories: [ 5 ],
    tags: [ 380, 8135, 8136, 8137, 3302, 1578, 8138, 8139, 8140, 8141, 8142, 767, 898, 1488, 8113, 1001, 8115, 1002, 1490, 421, 8143, 8121, 8144, 8122, 8145, 907, 909, 1396, 1503, 7102, 7494, 914, 1590, 8146 ],
  ),
  "directions_railway": SymbolsMetadata(
    popularity: 396,
    codepoint: 0xe534,
    categories: [ 14 ],
    tags: [ 2014, 1814, 1815, 6229, 1816, 2063, 2016, 1484, 388, 4613, 1581, 1602, 4616, 1490, 7745, 1922, 2071, 7746, 4601, 4618, 8147, 4619, 3611, 4621, 2165, 4622, 4623, 2008, 1842, 1930, 1504, 1591, 1625, 8148, 1844 ],
  ),
  "directions_railway_2": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf462,
    categories: [ 14 ],
    tags: [ 2014, 6229, 2063, 2016, 1484, 4613, 1581, 1602, 4616, 7745, 1922, 1194, 4601, 4618, 8147, 4619, 1503, 3611, 4621, 2165, 3112, 4622, 2008, 1842, 1930, 1504, 1591, 8148 ],
  ),
  "directions_run": SymbolsMetadata(
    popularity: 4772,
    codepoint: 0xe566,
    categories: [ 14 ],
    tags: [ 8149, 584, 1578, 2925, 1022, 4408, 2927, 483, 8150, 8151, 1002, 1490, 8152, 420, 778, 8153, 421, 488, 489, 1027, 8154, 8155, 1503, 8156, 8157, 2932, 5780, 3595, 8158, 8159, 750, 3206 ],
    rtlAutoMirrored: true,
  ),
  "directions_subway": SymbolsMetadata(
    popularity: 567,
    codepoint: 0xe533,
    categories: [ 14 ],
    tags: [ 2014, 1814, 1815, 1816, 2602, 2063, 2016, 1484, 388, 1578, 1581, 1602, 8160, 1490, 7745, 8161, 421, 2071, 4601, 5230, 4618, 8147, 4619, 1503, 3611, 4621, 4622, 4623, 2008, 1842, 1930, 1504, 1625, 8162, 8148, 8163, 2621, 1844 ],
  ),
  "directions_walk": SymbolsMetadata(
    popularity: 4046,
    codepoint: 0xe536,
    categories: [ 14 ],
    tags: [ 584, 2063, 8164, 388, 1578, 4408, 6106, 3930, 483, 8151, 1581, 4938, 1490, 778, 1858, 421, 8066, 8165, 488, 489, 8166, 1503, 8156, 3935, 109, 8167, 1504, 8168, 3206, 3207, 3939, 8169, 3229, 8170 ],
    rtlAutoMirrored: true,
  ),
  "directory_sync": SymbolsMetadata(
    popularity: 122,
    codepoint: 0xe394,
    categories: [ 2 ],
    tags: [ 2284, 419, 1651, 383, 384, 6547, 385, 6506, 388, 6936, 2627, 1530, 3052, 1656, 6006, 390, 421, 424, 425, 2843, 3749, 396, 889, 5256, 1667, 3529, 8171, 2455, 1260, 6010 ],
  ),
  "dirty_lens": SymbolsMetadata(
    popularity: 198,
    codepoint: 0xef4b,
    categories: [ 1 ],
    tags: [ 469, 8172, 8173, 8174, 47, 8175, 8176, 8177, 4005, 8178, 8179, 8180, 8181, 5110, 126, 8182, 8183, 2770, 8184, 8185, 59, 8186, 61, 8187, 119, 8188, 3474, 8189, 8190, 8191, 8192, 8193, 8194, 1261 ],
  ),
  "disabled_by_default": SymbolsMetadata(
    popularity: 5010,
    codepoint: 0xf230,
    categories: [ 2 ],
    tags: [ 1074, 7, 7276, 895, 3436, 2950, 1202, 1076, 4825, 897, 1077, 767, 8195, 2985, 529, 899, 901, 3696, 4152, 907, 281, 285, 4447, 4449, 911, 171, 310, 32, 1083, 314, 915, 3736 ],
  ),
  "disabled_visible": SymbolsMetadata(
    popularity: 1175,
    codepoint: 0xe76e,
    categories: [ 13 ],
    tags: [ 8196, 895, 8197, 383, 8198, 2950, 767, 2985, 6300, 8199, 8200, 8201, 8202, 1078, 900, 1856, 4152, 8203, 8204, 909, 4449, 911, 8205, 2948, 981, 2997, 8206, 8207, 8208, 914, 1083, 8209, 8210, 317, 8211, 8212, 5023, 8213, 8214, 8215, 8216 ],
  ),
  "disc_full": SymbolsMetadata(
    popularity: 346,
    codepoint: 0xe610,
    categories: [ 11 ],
    tags: [ 3175, 469, 3073, 8217, 4054, 8218, 1693, 2154, 383, 1732, 3176, 10, 7547, 3744, 2156, 8219, 8220, 8221, 2766, 2767, 3177, 4043, 8222, 8223, 1251, 135, 459, 1641, 2081, 8224, 486, 8225, 8226, 2772, 674, 8227, 8228, 35, 1261 ],
  ),
  "discover_tune": SymbolsMetadata(
    popularity: 1391,
    codepoint: 0xe018,
    categories: [ 0 ],
    tags: [ 1128, 5060, 1129, 794, 365, 785, 1202, 1735, 955, 696, 2299, 8229, 8230, 958, 959, 960, 277, 8231, 366, 1740, 2081, 763, 656, 5921, 202, 329, 310, 65, 1743, 1156, 751, 441, 1744, 8232, 1745 ],
  ),
  "dishwasher": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xe9a0,
    categories: [ 8 ],
    tags: [ 1888, 8233, 8234, 8235, 1871, 8236, 4005, 8095, 8237, 8238, 7214, 1433, 1500, 4471, 999, 1895, 1435, 1436, 6349, 3802, 8239, 1717, 32, 4001, 8240, 8241, 8242, 8243, 2801, 8244 ],
  ),
  "dishwasher_gen": SymbolsMetadata(
    popularity: 430,
    codepoint: 0xe832,
    categories: [ 8 ],
    tags: [ 1888, 8233, 1132, 8235, 953, 1871, 8236, 4005, 3795, 4386, 8237, 8238, 956, 1500, 4471, 4078, 999, 3235, 1435, 6349, 16, 3802, 1717, 1004, 75, 77, 1901, 32, 35, 5137, 4001, 8241, 2801, 8244 ],
  ),
  "display_external_input": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf7e7,
    categories: [ 4 ],
    tags: [ 380, 2053, 921, 8245, 2391, 12, 325, 8246, 8247, 8248, 2054, 8249, 8250, 274, 5273, 306, 935, 8251, 778, 8252, 2398, 1719, 2400, 3156, 2055, 1396, 782, 330, 2056, 5873, 7823, 1665, 32, 2057, 1054, 2059 ],
  ),
  "display_settings": SymbolsMetadata(
    popularity: 1539,
    codepoint: 0xeb97,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1128, 5060, 1230, 1728, 1731, 1684, 268, 1733, 1734, 785, 6676, 1735, 1685, 132, 445, 12, 8253, 8254, 8255, 696, 3485, 965, 1114, 53, 484, 135, 1687, 1740, 327, 618, 656, 790, 329, 30, 330, 3151, 2631, 65, 2649, 1743, 41, 1691, 1054 ],
  ),
  "distance": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xf6ea,
    categories: [ 15 ],
    tags: [ 1429, 1483, 1484, 388, 1578, 588, 1500, 958, 960, 1486, 1487, 1488, 8256, 1001, 8257, 1002, 6280, 1490, 21, 421, 1493, 1494, 1495, 1363, 1496, 6959, 1503, 980, 1083, 5610, 947, 1504 ],
  ),
  "diversity_1": SymbolsMetadata(
    popularity: 3739,
    codepoint: 0xf8d7,
    categories: [ 3 ],
    tags: [ 8258, 1059, 3281, 1134, 194, 211, 8259, 1063, 8260, 742, 867, 1137, 5070, 930, 6770, 4455, 7707, 483, 1141, 747, 8261, 8262, 223, 940, 8263, 488, 1151, 5248, 607, 495, 946, 983, 499, 8264, 8265, 1159 ],
  ),
  "diversity_2": SymbolsMetadata(
    popularity: 2796,
    codepoint: 0xf8d8,
    categories: [ 3 ],
    tags: [ 3325, 733, 8266, 383, 3281, 1134, 194, 211, 8259, 8260, 742, 3817, 3818, 8267, 867, 1137, 1791, 5070, 930, 6770, 4455, 483, 1141, 850, 747, 7414, 8268, 1000, 390, 8262, 223, 940, 488, 1151, 8154, 5607, 5248, 607, 946, 374, 8264, 1701, 8265 ],
  ),
  "diversity_3": SymbolsMetadata(
    popularity: 7777,
    codepoint: 0xf8d9,
    categories: [ 3 ],
    tags: [ 8258, 3281, 1134, 194, 8269, 211, 1063, 8260, 742, 867, 1137, 930, 6770, 7707, 7708, 1141, 747, 223, 940, 8263, 488, 1151, 7709, 607, 7710, 495, 946, 6807, 983, 499, 8264, 8265, 8270 ],
  ),
  "diversity_4": SymbolsMetadata(
    popularity: 243,
    codepoint: 0xf857,
    categories: [ 3 ],
    tags: [ 2716, 8266, 7258, 3281, 1134, 194, 7354, 211, 8260, 742, 8271, 867, 1137, 2737, 930, 6770, 8071, 4455, 8272, 1141, 747, 7361, 4768, 223, 8273, 488, 1151, 8006, 8274, 607, 495, 946, 983, 499, 8264, 8275, 8265 ],
  ),
  "dns": SymbolsMetadata(
    popularity: 4936,
    codepoint: 0xe875,
    categories: [ 11 ],
    tags: [ 755, 1429, 365, 1652, 694, 268, 211, 10, 3756, 8276, 8277, 5072, 135, 5073, 215, 5075, 8278, 92, 972, 3764, 8279, 223, 819, 2294, 121, 8280, 3761, 2631, 65, 107, 674, 2632, 551, 5137, 8281, 1053 ],
  ),
  "do_not_disturb_off": SymbolsMetadata(
    popularity: 881,
    codepoint: 0xe643,
    categories: [ 2 ],
    tags: [ 8282, 8283, 8284, 8285, 8286, 3063, 895, 4436, 2950, 4438, 2448, 4440, 8287, 767, 4441, 8288, 8289, 8290, 8291, 898, 8292, 901, 8293, 907, 909, 8294, 911, 8295, 8296, 1170, 8297, 8298, 8299, 1083, 2126, 8300, 8301, 8302, 8303 ],
  ),
  "do_not_disturb_on": SymbolsMetadata(
    popularity: 8525,
    codepoint: 0xe644,
    categories: [ 2 ],
    tags: [ 1074, 895, 383, 8304, 2950, 2448, 897, 4440, 8287, 1077, 767, 4441, 4248, 8289, 4249, 898, 2766, 899, 900, 1116, 1164, 3696, 4152, 8305, 486, 907, 908, 909, 1361, 911, 3310, 1170, 553, 1083, 1122, 915, 1261 ],
  ),
  "do_not_disturb_on_total_silence": SymbolsMetadata(
    popularity: 329,
    codepoint: 0xeffb,
    categories: [ 4 ],
    tags: [ 8306, 8307, 4212, 1074, 8308, 383, 8309, 4262, 2448, 4441, 4248, 8289, 4249, 1738, 899, 8310, 1116, 1164, 4152, 8311, 8312, 1169, 8305, 8313, 8314, 8315, 1516, 2123, 8316, 1170, 8317, 1929, 8318, 8319, 8320, 8321 ],
  ),
  "do_not_step": SymbolsMetadata(
    popularity: 272,
    codepoint: 0xf19f,
    categories: [ 16 ],
    tags: [ 892, 8307, 3074, 895, 1693, 1202, 2969, 767, 8289, 8322, 8323, 898, 590, 1954, 899, 4647, 8324, 3696, 7011, 8325, 8326, 8327, 8305, 8005, 907, 909, 4448, 1009, 171, 602, 8328, 8329, 914, 8330, 3935, 8331, 109, 2126, 1261, 3736 ],
  ),
  "do_not_touch": SymbolsMetadata(
    popularity: 433,
    codepoint: 0xf1b0,
    categories: [ 16 ],
    tags: [ 892, 1074, 895, 1693, 8287, 3304, 767, 8289, 8322, 8332, 8333, 898, 2734, 899, 3616, 2735, 2738, 8334, 8335, 2678, 7011, 8336, 8305, 907, 8337, 909, 1517, 4448, 1520, 1009, 171, 602, 1011, 914, 1083, 2126, 8035, 8338, 1261 ],
  ),
  "dock": SymbolsMetadata(
    popularity: 250,
    codepoint: 0xe30e,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2587, 1058, 4310, 1113, 3774, 383, 921, 211, 4363, 3050, 445, 2522, 4318, 832, 1711, 965, 1114, 966, 1044, 2751, 219, 1719, 8339, 226, 1194, 4371, 2534, 3782, 75, 77, 446, 4323, 3611, 1667, 447, 551 ],
  ),
  "dock_to_bottom": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf7e6,
    categories: [ 4 ],
    tags: [ 2167, 2520, 1230, 1367, 4310, 2188, 4871, 12, 2522, 8340, 2751, 306, 778, 98, 1770, 3421, 1493, 2820, 1496, 2648, 75, 2247, 330, 8341, 8342, 32, 8343, 8344, 317, 7504, 1054, 2746 ],
  ),
  "dock_to_left": SymbolsMetadata(
    popularity: 147,
    codepoint: 0xf7e5,
    categories: [ 4 ],
    tags: [ 1229, 1230, 1367, 4832, 2522, 8345, 2751, 306, 8346, 778, 421, 98, 1770, 3421, 1496, 75, 2247, 8347, 1377, 2238, 8348, 2993, 8342, 1378, 8349, 6257, 32, 1215, 317, 1054, 8350, 2746 ],
  ),
  "dock_to_right": SymbolsMetadata(
    popularity: 50,
    codepoint: 0xf7e4,
    categories: [ 4 ],
    tags: [ 8351, 8352, 1367, 2232, 2522, 8353, 8354, 306, 2235, 1770, 3421, 8355, 75, 7073, 2247, 8356, 8357, 8358, 8347, 2238, 8348, 2993, 8342, 1378, 8349, 6257, 32, 441, 8281, 1215, 8359, 1054, 8350, 2746 ],
  ),
  "docs": SymbolsMetadata(
    popularity: 2316,
    codepoint: 0xea7d,
    categories: [ 12 ],
    tags: [ 2501, 1466, 1042, 1201, 10, 1528, 8360, 1347, 337, 1654, 696, 1530, 1656, 1657, 1598, 135, 366, 92, 763, 1532, 1533, 2653, 1534, 1535, 2506, 1353, 1664, 4786, 4787, 38, 346, 317, 704 ],
    rtlAutoMirrored: true,
  ),
  "docs_add_on": SymbolsMetadata(
    popularity: 734,
    codepoint: 0xf0c2,
    categories: [ 12 ],
    tags: [ 526, 1341, 1228, 8361, 8362, 1057, 1058, 1201, 1526, 1347, 787, 8363, 1530, 7721, 1204, 1207, 1044, 366, 92, 763, 1350, 1534, 4139, 202, 107, 6329, 38, 441 ],
  ),
  "docs_apps_script": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xf0c3,
    categories: [ 12 ],
    tags: [ 526, 1229, 1230, 2657, 1367, 2148, 1731, 266, 1776, 2624, 6580, 1781, 8360, 1347, 696, 2299, 7721, 2738, 1044, 366, 92, 1740, 96, 3021, 1783, 3379, 288, 371, 107, 441 ],
  ),
  "document_scanner": SymbolsMetadata(
    popularity: 2302,
    codepoint: 0xe5fa,
    categories: [ 12 ],
    tags: [ 8364, 2501, 3909, 116, 1707, 2391, 10, 3113, 1709, 8365, 1528, 1347, 8366, 8367, 1654, 1530, 1656, 1657, 53, 2811, 1542, 366, 1533, 8368, 1534, 1535, 59, 119, 121, 75, 1723, 8369, 1724, 4786, 4787, 32, 38, 346, 704 ],
  ),
  "document_search": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf385,
    categories: [ 12 ],
    tags: [ 2513, 1042, 10, 955, 1528, 1347, 8370, 8371, 1654, 958, 8372, 1530, 8373, 8374, 959, 960, 8375, 8376, 1656, 1657, 964, 135, 4294, 8377, 967, 971, 8378, 973, 974, 975, 976, 8379, 1534, 1535, 2506, 4359, 980, 8380, 7605, 8381, 981, 4786, 4787, 38, 704, 986 ],
  ),
  "domain": SymbolsMetadata(
    popularity: 4704,
    codepoint: 0xe7ee,
    categories: [ 9 ],
    tags: [ 1429, 2600, 2601, 1074, 798, 1284, 5240, 803, 1285, 8382, 8277, 5244, 2626, 2605, 246, 8383, 999, 6924, 3170, 1001, 1456, 940, 1495, 1444, 2614, 1445, 75, 1446, 2616, 2617, 2882, 2618, 32, 441, 2620, 1691, 1054, 1459, 5655 ],
  ),
  "domain_add": SymbolsMetadata(
    popularity: 889,
    codepoint: 0xeb62,
    categories: [ 9 ],
    tags: [ 192, 468, 526, 8384, 2600, 2601, 1058, 798, 1284, 1285, 8385, 921, 1201, 8386, 8277, 8387, 8388, 8389, 2605, 787, 1204, 999, 215, 1064, 223, 763, 8390, 1456, 940, 1495, 202, 2614, 1256, 1446, 2616, 2617, 857, 35, 1691, 8391, 1053, 5655 ],
  ),
  "domain_disabled": SymbolsMetadata(
    popularity: 657,
    codepoint: 0xe0ef,
    categories: [ 9 ],
    tags: [ 892, 2600, 2601, 1074, 894, 798, 1284, 1075, 1285, 211, 1076, 767, 8277, 8392, 2651, 898, 2766, 2605, 899, 999, 5072, 901, 215, 2770, 1490, 223, 2678, 907, 1456, 908, 909, 2771, 1495, 2772, 2614, 1446, 2616, 171, 3761, 7589, 914, 1083, 8393, 915, 1691, 1053, 8394 ],
  ),
  "domain_verification": SymbolsMetadata(
    popularity: 1057,
    codepoint: 0xef4c,
    categories: [ 6 ],
    tags: [ 1229, 8395, 1549, 2480, 1039, 1630, 5826, 1632, 1633, 1636, 2481, 2376, 299, 8277, 8396, 8397, 1639, 8398, 2751, 215, 306, 1641, 1643, 819, 1772, 330, 1773, 1011, 288, 2882, 8399, 1647, 6088, 8400, 2757, 1479, 2759, 2386, 8401, 2387, 2388, 1523, 2389, 1691, 8391, 1053, 8402, 1054, 5655, 1650 ],
  ),
  "domain_verification_off": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf7b0,
    categories: [ 6 ],
    tags: [ 1229, 8395, 1549, 894, 895, 2719, 1630, 1633, 897, 299, 3304, 767, 8277, 1639, 898, 2766, 8398, 901, 2751, 215, 8403, 306, 1641, 223, 2678, 907, 908, 1643, 909, 75, 911, 912, 330, 1011, 288, 2882, 914, 32, 8399, 1647, 8400, 2757, 915, 2759, 2386, 2388, 1523, 1261, 1691, 1240, 1053, 1054, 5655, 1650 ],
  ),
  "domino_mask": SymbolsMetadata(
    popularity: 78,
    codepoint: 0xf5e4,
    categories: [ 3 ],
    tags: [ 6692, 1074, 3336, 5149, 6696, 8404, 8405, 8406, 8407, 8408, 1188, 697, 6189, 1078, 900, 850, 8409, 6703, 6704, 8410, 487, 2162, 1516, 2948, 8411, 2997, 8412, 3637, 8413, 8414, 4583 ],
  ),
  "done_all": SymbolsMetadata(
    popularity: 9004,
    codepoint: 0xe877,
    categories: [ 2 ],
    tags: [ 1627, 2716, 2325, 2717, 1549, 1630, 1632, 8415, 1633, 8416, 8417, 1636, 4269, 1639, 8418, 8419, 8420, 3065, 1066, 1641, 2557, 1643, 288, 4751, 371, 107, 2487, 1645, 3159, 1647, 8421, 315, 2386, 8401, 2387, 1523, 1650 ],
  ),
  "done_outline": SymbolsMetadata(
    popularity: 7669,
    codepoint: 0xe92f,
    categories: [ 2 ],
    tags: [ 1627, 2716, 1548, 7026, 2325, 2717, 1549, 1630, 8422, 1631, 1632, 1633, 1635, 4268, 1636, 4269, 1639, 1640, 3065, 1641, 1643, 4750, 1361, 288, 2487, 1645, 8423, 1647, 6088, 6085, 2386, 2387, 1523, 1650 ],
  ),
  "donut_large": SymbolsMetadata(
    popularity: 1669,
    codepoint: 0xe917,
    categories: [ 9 ],
    tags: [ 5, 2827, 2565, 920, 383, 5807, 10, 924, 1370, 6299, 8424, 3108, 8425, 929, 8426, 2659, 933, 3524, 3634, 2568, 390, 597, 937, 1361, 4138, 1082, 6417, 3055, 28, 1257, 4850, 2542, 1378, 33, 4818, 6305, 947, 8427, 2147 ],
  ),
  "donut_small": SymbolsMetadata(
    popularity: 1308,
    codepoint: 0xe918,
    categories: [ 9 ],
    tags: [ 3325, 5, 1730, 920, 383, 5807, 10, 924, 1370, 6299, 8428, 8429, 7646, 1659, 929, 8426, 16, 188, 933, 3524, 2568, 597, 937, 8430, 6417, 5018, 28, 1257, 1377, 4850, 1979, 1378, 33, 35, 6305, 947 ],
  ),
  "door_back": SymbolsMetadata(
    popularity: 340,
    codepoint: 0xeffc,
    categories: [ 8 ],
    tags: [ 755, 2601, 2489, 798, 383, 4428, 2604, 6103, 832, 6104, 1597, 2985, 274, 5647, 2873, 999, 1435, 6244, 903, 5653, 2876, 75, 2495, 2496, 1960, 913, 32, 563, 2499, 2456 ],
  ),
  "door_front": SymbolsMetadata(
    popularity: 1070,
    codepoint: 0xeffd,
    categories: [ 8 ],
    tags: [ 755, 2601, 798, 383, 2950, 4428, 2604, 8431, 6103, 2909, 6104, 1597, 2985, 3838, 274, 5500, 8432, 5647, 999, 1435, 2796, 3408, 6244, 2653, 5653, 1444, 75, 1446, 1960, 8433, 563, 2456 ],
  ),
  "door_open": SymbolsMetadata(
    popularity: 1311,
    codepoint: 0xe77c,
    categories: [ 10 ],
    tags: [ 755, 733, 2601, 798, 1016, 445, 2604, 8434, 6103, 2909, 6104, 1597, 8435, 2985, 3838, 5647, 2910, 999, 1435, 2795, 2796, 6244, 1004, 2653, 8436, 3841, 8437, 5653, 1960, 563, 766 ],
  ),
  "door_sensor": SymbolsMetadata(
    popularity: 150,
    codepoint: 0xe28a,
    categories: [ 10 ],
    tags: [ 755, 1244, 8438, 8439, 383, 4428, 269, 2804, 2805, 2604, 8440, 1597, 8435, 3489, 999, 3235, 1896, 8441, 1897, 1602, 327, 1004, 2653, 1006, 1444, 75, 1011, 122, 1901, 7876, 553 ],
  ),
  "door_sliding": SymbolsMetadata(
    popularity: 379,
    codepoint: 0xeffe,
    categories: [ 8 ],
    tags: [ 755, 2601, 1131, 1132, 8442, 798, 7211, 2950, 3989, 1370, 2604, 6103, 3108, 8443, 8444, 6104, 1597, 2985, 5647, 964, 999, 1435, 2796, 3472, 2653, 1770, 8445, 8437, 5653, 1960, 8446, 8447, 563, 2571, 315, 8448, 2714 ],
  ),
  "doorbell": SymbolsMetadata(
    popularity: 344,
    codepoint: 0xefff,
    categories: [ 8 ],
    tags: [ 1244, 469, 4942, 2014, 1246, 798, 1248, 2604, 8449, 1597, 8432, 8450, 999, 3235, 1435, 1896, 1897, 486, 3843, 1444, 1446, 1257, 2098, 1011, 227, 1901, 1156, 3768, 766 ],
  ),
  "doorbell_3p": SymbolsMetadata(
    popularity: 179,
    codepoint: 0xe1e7,
    categories: [ 8 ],
    tags: [ 8451, 755, 1242, 1244, 469, 2148, 1246, 798, 298, 1248, 383, 2604, 8449, 8452, 6104, 1597, 930, 8450, 999, 1435, 1896, 1897, 1004, 486, 1120, 1254, 75, 1030, 1257, 1011, 227, 1901, 1156, 499, 3768 ],
  ),
  "doorbell_chime": SymbolsMetadata(
    popularity: 131,
    codepoint: 0xe1f3,
    categories: [ 10 ],
    tags: [ 469, 1129, 298, 1248, 443, 921, 445, 8449, 6104, 1597, 8450, 999, 1897, 1004, 486, 5185, 4987, 1257, 77, 1011, 227, 1901, 1156, 5137, 3768, 1902, 233, 234 ],
  ),
  "double_arrow": SymbolsMetadata(
    popularity: 7865,
    codepoint: 0xea50,
    categories: [ 2 ],
    tags: [ 775, 380, 419, 2862, 776, 388, 3108, 2450, 3593, 2999, 8453, 8454, 777, 2903, 778, 2557, 779, 421, 780, 2162, 781, 28, 2367, 1396, 2899, 2966, 4787, 2571, 2455 ],
    rtlAutoMirrored: true,
  ),
  "downhill_skiing": SymbolsMetadata(
    popularity: 720,
    codepoint: 0xe509,
    categories: [ 15 ],
    tags: [ 989, 8455, 8149, 8456, 584, 8457, 8458, 3337, 2925, 6190, 483, 16, 1544, 1545, 488, 489, 1967, 3347, 4202, 5999, 8459, 8460, 8461, 8462, 8008, 8463, 725, 5780, 3595, 750, 1504, 2024, 732, 5289 ],
  ),
  "download": SymbolsMetadata(
    popularity: 18842,
    codepoint: 0xf090,
    categories: [ 2 ],
    tags: [ 5656, 380, 2650, 5249, 7, 1269, 1042, 10, 1347, 2651, 337, 2897, 8464, 6518, 1654, 1530, 8465, 8466, 1542, 851, 1674, 5660, 3001, 2342, 8467, 2844, 1664, 8468, 8469, 441, 2007, 2344, 346, 1381 ],
  ),
  "download_2": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xf523,
    categories: [ 2 ],
    tags: [ 5656, 380, 2650, 1343, 2188, 1042, 10, 1347, 2651, 337, 8464, 2924, 1654, 1530, 2652, 1542, 851, 966, 1674, 1602, 6868, 5660, 908, 3001, 2342, 2844, 1664, 1667, 2007, 1214, 346 ],
  ),
  "download_done": SymbolsMetadata(
    popularity: 2259,
    codepoint: 0xf091,
    categories: [ 2 ],
    tags: [ 1627, 2716, 2717, 1549, 380, 419, 1630, 1632, 1633, 2481, 1347, 1639, 2651, 337, 8470, 8471, 8472, 8473, 8464, 1654, 1530, 8474, 8475, 8476, 3065, 1542, 8477, 8478, 1674, 7751, 1643, 1664, 8479, 8480, 2487, 1647, 6088, 346, 2387 ],
  ),
  "download_for_offline": SymbolsMetadata(
    popularity: 4214,
    codepoint: 0xf000,
    categories: [ 2 ],
    tags: [ 380, 2650, 8481, 1343, 3521, 383, 8482, 2651, 337, 8483, 2897, 2924, 8484, 2652, 1542, 1674, 8485, 1602, 6868, 8486, 908, 8487, 2046, 8488, 8489, 3001, 2844, 1664, 8469, 8490, 1298, 1667, 346 ],
  ),
  "downloading": SymbolsMetadata(
    popularity: 3542,
    codepoint: 0xf001,
    categories: [ 2 ],
    tags: [ 8491, 380, 2650, 5249, 3512, 383, 8492, 3050, 8493, 2651, 337, 8494, 8464, 8465, 3052, 2652, 1542, 3053, 188, 1674, 3513, 2568, 2858, 3055, 28, 2342, 2844, 1664, 1667, 2007, 346 ],
  ),
  "draft": SymbolsMetadata(
    popularity: 6213,
    codepoint: 0xe66d,
    categories: [ 12 ],
    tags: [ 526, 2151, 1058, 1652, 693, 1042, 1201, 10, 1528, 1347, 337, 1853, 1654, 696, 1672, 1530, 1656, 1657, 1542, 1044, 763, 1532, 1534, 1535, 1664, 4786, 4787, 674, 38, 346, 1536 ],
    rtlAutoMirrored: true,
  ),
  "draft_orders": SymbolsMetadata(
    popularity: 46,
    codepoint: 0xe7b3,
    categories: [ 6 ],
    tags: [ 1726, 2488, 1731, 383, 693, 2376, 1201, 1347, 1853, 1329, 696, 2299, 966, 1740, 1533, 8495, 8496, 1361, 2693, 2694, 8497, 3184, 2497, 889, 3296, 3443, 8498, 1260, 6929, 6930, 1536, 704 ],
  ),
  "drafts": SymbolsMetadata(
    popularity: 2692,
    codepoint: 0xe151,
    categories: [ 7 ],
    tags: [ 443, 693, 8499, 2331, 1347, 1853, 8500, 696, 2335, 1530, 851, 4704, 19, 2340, 485, 1408, 1533, 3288, 1361, 2858, 7159, 100, 2506, 2342, 4271, 2343, 5170, 3443, 8498, 2664, 6930, 704 ],
  ),
  "drag_click": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf71f,
    categories: [ 2 ],
    tags: [ 1128, 2827, 380, 383, 953, 2490, 1776, 1777, 2907, 1732, 269, 3523, 1781, 3007, 8501, 2735, 4895, 2568, 3020, 778, 421, 423, 1783, 5039, 424, 425, 7167, 396, 397, 288, 371, 8502, 65, 399, 402 ],
  ),
  "drag_handle": SymbolsMetadata(
    popularity: 3811,
    codepoint: 0xe25d,
    categories: [ 12 ],
    tags: [ 1128, 1229, 8503, 1367, 4864, 2750, 299, 2138, 3007, 8504, 8505, 8506, 3327, 5659, 5810, 2986, 3489, 2176, 2751, 1620, 306, 366, 92, 788, 778, 656, 2295, 1496, 8507, 2247, 330, 65, 2882, 106, 1214, 2757, 2759, 1691, 1053, 1054 ],
  ),
  "drag_indicator": SymbolsMetadata(
    popularity: 7061,
    codepoint: 0xe945,
    categories: [ 2 ],
    tags: [ 1128, 1229, 1230, 1367, 953, 4864, 2750, 269, 1735, 299, 956, 3007, 8504, 8508, 8506, 1500, 8509, 5810, 3489, 188, 2751, 306, 92, 8510, 788, 219, 327, 778, 656, 226, 1496, 8507, 2247, 330, 65, 311, 3036, 2882, 8511, 106, 447, 8512, 2757, 2759, 8513, 1691, 1053, 1054 ],
  ),
  "drag_pan": SymbolsMetadata(
    popularity: 99,
    codepoint: 0xf71e,
    categories: [ 2 ],
    tags: [ 1128, 380, 6433, 419, 1777, 6436, 1781, 388, 8514, 2840, 3007, 8504, 787, 3089, 8515, 2875, 1002, 8516, 3020, 778, 8517, 421, 2653, 4482, 8518, 1783, 1496, 7073, 782, 8519, 2899, 288, 371, 8502, 1677, 8520, 986, 2404 ],
  ),
  "draw": SymbolsMetadata(
    popularity: 5847,
    codepoint: 0xe746,
    categories: [ 12 ],
    tags: [ 8521, 2829, 5160, 693, 1201, 2332, 299, 8522, 1853, 2834, 302, 696, 2299, 8523, 3328, 8524, 8525, 53, 966, 1602, 1641, 1532, 2693, 2694, 8526, 311, 5170, 8527, 1536, 704 ],
  ),
  "draw_abstract": SymbolsMetadata(
    popularity: 89,
    codepoint: 0xf7f8,
    categories: [ 12 ],
    tags: [ 3325, 8528, 2829, 8529, 83, 383, 693, 5806, 1201, 299, 8522, 1853, 2834, 302, 696, 2299, 3327, 8523, 1659, 304, 2735, 3328, 16, 5165, 53, 966, 1602, 119, 311, 5922, 105, 5170, 32, 8530, 35 ],
  ),
  "draw_collage": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf7f7,
    categories: [ 12 ],
    tags: [ 8531, 8528, 1367, 2829, 8529, 4859, 1058, 4862, 3417, 1061, 693, 921, 4865, 5806, 1201, 1996, 299, 1853, 2834, 302, 696, 2299, 2550, 2735, 8532, 3328, 53, 966, 1064, 306, 1067, 1740, 119, 311, 5922, 8530, 3493, 441 ],
  ),
  "dresser": SymbolsMetadata(
    popularity: 346,
    codepoint: 0xe210,
    categories: [ 8 ],
    tags: [ 2600, 4211, 8533, 8534, 7211, 8535, 3989, 1943, 1269, 8536, 7789, 8537, 5979, 1964, 5980, 999, 7468, 8538, 2607, 1435, 2796, 4418, 5981, 5725, 1004, 940, 1960, 8341, 8539, 674, 2714 ],
  ),
  "drive_export": SymbolsMetadata(
    popularity: 49,
    codepoint: 0xf41d,
    categories: [ 12 ],
    tags: [ 3325, 1229, 1230, 380, 1651, 1652, 10, 388, 1347, 1654, 1672, 2628, 1530, 1655, 1656, 1657, 1658, 1659, 1189, 1661, 421, 223, 4187, 1662, 1663, 1396, 1664, 2343, 2631, 1665, 674, 1667, 2007, 1676, 1677, 346 ],
    rtlAutoMirrored: true,
  ),
  "drive_file_move": SymbolsMetadata(
    popularity: 1072,
    codepoint: 0xe675,
    categories: [ 12 ],
    tags: [ 2151, 380, 8540, 1707, 10, 8541, 3050, 388, 1528, 1347, 337, 1654, 1672, 1530, 4781, 3052, 1656, 8542, 1542, 8543, 778, 421, 8544, 1396, 782, 2343, 1665, 4786, 4787, 674, 2007, 346 ],
    rtlAutoMirrored: true,
  ),
  "drive_folder_upload": SymbolsMetadata(
    popularity: 1085,
    codepoint: 0xe9a3,
    categories: [ 12 ],
    tags: [ 526, 2151, 380, 1651, 1652, 3741, 1653, 1042, 1540, 10, 6936, 1528, 1347, 1654, 8545, 1672, 1530, 6550, 1656, 8546, 8547, 1542, 135, 1044, 778, 1495, 2843, 3749, 1664, 2343, 1665, 4786, 4787, 674, 1412, 1667, 2007, 1676, 346, 8548, 3297, 8549 ],
  ),
  "dropdown": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xe9a4,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 7, 2447, 2950, 2896, 2750, 269, 299, 2651, 2941, 787, 959, 2751, 4964, 306, 92, 788, 219, 327, 789, 421, 2653, 656, 1770, 226, 329, 330, 288, 371, 65, 2882, 106, 32, 944, 447, 314, 2757, 4887, 2759, 1691, 1053, 7504, 1054 ],
  ),
  "dropper_eye": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf351,
    categories: [ 1 ],
    tags: [ 2513, 8550, 4848, 8551, 8552, 6675, 8553, 2200, 6677, 8554, 6243, 8555, 6300, 6678, 8556, 8557, 8558, 971, 8559, 3021, 3022, 6679, 8560, 981, 288, 8561, 36, 1071, 2537, 317, 4583 ],
  ),
  "dry": SymbolsMetadata(
    popularity: 203,
    codepoint: 0xf1b3,
    categories: [ 8 ],
    tags: [ 707, 8562, 8563, 1868, 712, 8564, 8565, 7165, 8566, 8567, 8568, 8569, 7166, 2734, 2735, 2738, 8570, 3617, 3076, 3078, 1857, 8571, 3967, 727, 8572, 441, 8573, 3978, 3083, 1902, 3613, 731 ],
  ),
  "dry_cleaning": SymbolsMetadata(
    popularity: 654,
    codepoint: 0xea58,
    categories: [ 5 ],
    tags: [ 3597, 2697, 1871, 4005, 3989, 8574, 6134, 2702, 7165, 8575, 8576, 8577, 2705, 2706, 8578, 6138, 2527, 2607, 8579, 8580, 2613, 75, 2631, 32, 2713, 8581, 1504, 8582, 8583, 2714, 4001 ],
  ),
  "dual_screen": SymbolsMetadata(
    popularity: 109,
    codepoint: 0xf6cf,
    categories: [ 4 ],
    tags: [ 1175, 8584, 445, 12, 3108, 6788, 8585, 7957, 8586, 787, 8587, 7958, 7959, 327, 8588, 7822, 2653, 3000, 3421, 226, 3506, 8589, 2056, 5873, 8590, 7823, 3425, 8349, 6257, 8591, 8592, 317, 1054, 1084 ],
  ),
  "duo": SymbolsMetadata(
    popularity: 704,
    codepoint: 0xe9a5,
    categories: [ 7 ],
    tags: [ 355, 1133, 5488, 47, 116, 472, 383, 1135, 3456, 445, 3108, 4471, 6788, 8586, 3360, 270, 4985, 5516, 367, 278, 328, 2162, 121, 177, 889, 2057, 342, 5610, 315, 41, 5519, 540, 8593 ],
  ),
  "dvr": SymbolsMetadata(
    popularity: 2067,
    codepoint: 0xe1b2,
    categories: [ 4 ],
    tags: [ 1109, 1110, 1129, 4310, 8594, 1684, 953, 694, 785, 1685, 445, 8595, 12, 956, 8596, 3216, 1711, 3337, 965, 2080, 1114, 92, 1687, 367, 788, 327, 656, 283, 121, 1154, 177, 75, 190, 330, 65, 4323, 551, 343, 344, 7202, 1214, 41, 1691, 1054 ],
    rtlAutoMirrored: true,
  ),
  "dynamic_feed": SymbolsMetadata(
    popularity: 1929,
    codepoint: 0xea14,
    categories: [ 6 ],
    tags: [ 8597, 8598, 8599, 989, 2501, 8600, 1400, 355, 5793, 3095, 1042, 8601, 2502, 926, 1066, 4985, 2503, 486, 3421, 1409, 4699, 100, 1029, 424, 8602, 227, 107, 2057, 1258, 290, 1260, 1054 ],
  ),
  "dynamic_form": SymbolsMetadata(
    popularity: 1799,
    codepoint: 0xf1bf,
    categories: [ 2 ],
    tags: [ 4076, 1731, 3773, 2624, 1733, 785, 1735, 7020, 2547, 8603, 696, 8604, 4078, 4049, 3779, 1022, 8605, 4080, 1598, 966, 4083, 7506, 1740, 656, 3782, 329, 6129, 1027, 75, 65, 32, 4086, 315, 1260 ],
  ),
  "e911_avatar": SymbolsMetadata(
    popularity: 237,
    codepoint: 0xf11a,
    categories: [ 7 ],
    tags: [ 3175, 6931, 469, 738, 3073, 1133, 1693, 1113, 443, 8606, 475, 8607, 3176, 445, 2482, 8608, 2766, 2767, 480, 1309, 965, 482, 5402, 1251, 2769, 1641, 219, 486, 226, 8609, 2772, 1318, 1353, 495, 35, 1320, 8610, 1701, 1034, 8611, 1261 ],
  ),
  "e911_emergency": SymbolsMetadata(
    popularity: 1133,
    codepoint: 0xf119,
    categories: [ 13 ],
    tags: [ 6931, 3466, 1244, 469, 2479, 738, 8612, 1246, 7270, 3775, 2482, 8613, 5601, 8614, 8615, 4647, 482, 1251, 5223, 3680, 486, 8616, 1520, 5861, 602, 1011, 227, 2485, 2486, 1034, 1261 ],
  ),
  "e_mobiledata": SymbolsMetadata(
    popularity: 129,
    codepoint: 0xf002,
    categories: [ 4 ],
    tags: [ 8617, 4, 365, 208, 210, 429, 443, 211, 212, 10, 213, 8618, 236, 14, 215, 8619, 19, 219, 433, 434, 221, 222, 223, 242, 437, 227, 228, 38, 2296, 441, 40, 234, 235 ],
  ),
  "e_mobiledata_badge": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf7e3,
    categories: [ 4 ],
    tags: [ 8617, 428, 4, 6, 210, 8620, 8621, 212, 10, 8622, 213, 8618, 236, 14, 215, 432, 8619, 19, 219, 8623, 433, 8624, 221, 222, 223, 8625, 8626, 227, 228, 32, 38, 40, 234 ],
  ),
  "ear_sound": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf356,
    categories: [ 0 ],
    tags: [ 733, 734, 8627, 8628, 1129, 584, 1133, 2332, 8629, 8630, 744, 8631, 8632, 1139, 1140, 8633, 482, 483, 759, 1143, 8634, 1147, 8635, 2081, 1152, 2083, 121, 177, 1156, 8636, 8637, 1157, 493, 1320, 441, 8300, 1161, 1745, 1902 ],
  ),
  "earbud_case": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf327,
    categories: [ 11 ],
    tags: [ 2587, 1129, 3769, 4477, 7, 5241, 3773, 8638, 1269, 445, 8639, 8640, 8641, 8642, 1711, 2590, 8631, 4490, 1143, 2081, 8643, 2585, 3782, 78, 1156, 32, 674, 8644, 441, 234 ],
  ),
  "earbud_left": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf326,
    categories: [ 11 ],
    tags: [ 79, 2587, 1129, 8645, 8646, 2332, 445, 8629, 8630, 8647, 8640, 8641, 8642, 7057, 8648, 8631, 4490, 8632, 8649, 1375, 8650, 8651, 1143, 8652, 2081, 3542, 1719, 7198, 8653, 1156, 8654, 3411, 751, 551, 1745, 2594, 234 ],
  ),
  "earbud_right": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf325,
    categories: [ 11 ],
    tags: [ 2587, 1129, 8645, 4477, 445, 8629, 8630, 8655, 8640, 8641, 8642, 5415, 8648, 8631, 4490, 8632, 8649, 1143, 8652, 2081, 8656, 8657, 5692, 8653, 1156, 8654, 751, 551, 1745, 2594, 234 ],
  ),
  "earbuds": SymbolsMetadata(
    popularity: 310,
    codepoint: 0xf003,
    categories: [ 11 ],
    tags: [ 2587, 1129, 8658, 8645, 922, 2332, 445, 8629, 8640, 8641, 8642, 3337, 8631, 8659, 4490, 8632, 8649, 366, 1143, 8660, 390, 2081, 8661, 3346, 2585, 1156, 8654, 551, 1745, 234 ],
  ),
  "earbuds_2": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf324,
    categories: [ 11 ],
    tags: [ 2587, 1129, 8645, 922, 445, 3108, 8629, 8640, 8662, 8641, 8642, 8631, 4490, 8632, 8663, 1143, 8634, 2081, 3000, 3346, 8664, 1156, 3411, 751, 551, 315, 234, 8665 ],
  ),
  "earbuds_battery": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xf004,
    categories: [ 11 ],
    tags: [ 2587, 1129, 3769, 3772, 4477, 3773, 3774, 922, 445, 8629, 8640, 8666, 8641, 8642, 4061, 8631, 8667, 4490, 8632, 188, 2472, 1143, 8634, 3780, 2081, 3782, 1156, 553, 551, 2594, 234, 8665, 4527 ],
  ),
  "early_on": SymbolsMetadata(
    popularity: 265,
    codepoint: 0xe2ba,
    categories: [ 10 ],
    tags: [ 5340, 1015, 84, 5341, 712, 1017, 5035, 5045, 1018, 8668, 2094, 90, 999, 5206, 5347, 2097, 1004, 909, 2838, 5486, 1030, 1031, 8669, 32, 108, 3686, 6395, 3687, 289, 8670, 5372 ],
  ),
  "earthquake": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xf64f,
    categories: [ 3 ],
    tags: [ 8671, 469, 8672, 920, 7270, 3176, 4668, 8673, 8674, 2482, 8675, 8676, 8677, 929, 8678, 1602, 597, 327, 1859, 8679, 8680, 1787, 5861, 602, 8681, 8682, 8683, 8684, 8685, 2086, 1261, 1862 ],
  ),
  "east": SymbolsMetadata(
    popularity: 5036,
    codepoint: 0xf1df,
    categories: [ 5 ],
    tags: [ 775, 8686, 380, 3040, 776, 388, 2961, 8687, 3016, 2962, 777, 8688, 188, 1490, 789, 778, 779, 421, 780, 8689, 8690, 3147, 1783, 781, 28, 1396, 782, 8691, 2967, 1504 ],
  ),
  "ecg": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf80f,
    categories: [ 11 ],
    tags: [ 5773, 5774, 4452, 920, 7725, 10, 4453, 1528, 1751, 5785, 5787, 6874, 2927, 929, 595, 3863, 4455, 5788, 5777, 5778, 3569, 1754, 2848, 1757, 1760, 327, 1761, 1762, 3570, 286, 5298, 947, 5790, 4461, 8692, 1905 ],
  ),
  "ecg_heart": SymbolsMetadata(
    popularity: 224,
    codepoint: 0xf6e9,
    categories: [ 15 ],
    tags: [ 5293, 5773, 5774, 4452, 1528, 1751, 5785, 5786, 5787, 2926, 2927, 595, 1753, 4455, 5788, 5778, 8693, 3569, 1754, 5789, 8694, 4768, 1757, 327, 1761, 3570, 286, 5298, 4772, 947, 5790, 4461, 1905 ],
  ),
  "eco": SymbolsMetadata(
    popularity: 6814,
    codepoint: 0xea35,
    categories: [ 3 ],
    tags: [ 1812, 6808, 8695, 8696, 8673, 6814, 8697, 8698, 6565, 8699, 3779, 1890, 8700, 6816, 6818, 196, 5637, 8701, 7484, 1859, 6821, 1835, 6822, 6824, 2370, 2371, 948, 7369, 7370 ],
  ),
  "eda": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf6e8,
    categories: [ 15 ],
    tags: [ 892, 469, 3073, 1769, 2489, 8702, 1074, 954, 269, 8287, 8703, 8704, 8705, 8706, 2734, 2926, 3616, 2735, 3448, 2738, 5778, 850, 1251, 966, 7011, 486, 8707, 2743, 1082, 3619, 912, 1723, 1011, 1083, 8708, 2388, 1261 ],
  ),
  "edgesensor_high": SymbolsMetadata(
    popularity: 275,
    codepoint: 0xf005,
    categories: [ 4 ],
    tags: [ 1109, 1110, 469, 365, 1113, 208, 211, 10, 2805, 445, 236, 8709, 965, 2471, 8710, 1114, 215, 1897, 634, 219, 1675, 8711, 778, 223, 486, 226, 6959, 75, 77, 2425, 122, 227, 5893, 5952, 447, 551, 2253, 8712, 234 ],
  ),
  "edgesensor_low": SymbolsMetadata(
    popularity: 192,
    codepoint: 0xf006,
    categories: [ 4 ],
    tags: [ 1109, 1110, 469, 2148, 8713, 8714, 365, 4477, 1113, 383, 211, 269, 2805, 445, 588, 236, 8709, 4075, 8715, 8716, 965, 2471, 1114, 188, 1896, 1897, 8717, 366, 4014, 3780, 217, 634, 219, 1675, 8711, 778, 223, 6958, 486, 2295, 226, 4023, 6959, 1007, 75, 77, 2425, 122, 8718, 8719, 8720, 227, 1155, 553, 5952, 7860, 8721, 447, 551, 985, 1381, 8712, 5974, 232, 233, 234 ],
  ),
  "edit": SymbolsMetadata(
    popularity: 49075,
    codepoint: 0xe3c9,
    categories: [ 1 ],
    tags: [ 1726, 1933, 1731, 693, 8722, 2376, 1201, 3457, 299, 2834, 302, 696, 8723, 2299, 1371, 5165, 966, 2836, 21, 1740, 763, 1532, 1361, 2693, 2694, 75, 2497, 5170, 8007, 441, 2537, 1260, 1536, 704 ],
  ),
  "edit_arrow_down": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf380,
    categories: [ 2 ],
    tags: [ 8521, 1367, 380, 2940, 2188, 1731, 693, 1201, 2922, 2651, 337, 3007, 2834, 1500, 696, 2299, 966, 1044, 92, 2315, 1740, 778, 421, 763, 780, 96, 2693, 2694, 2899, 3036, 106, 2007, 1676, 1260, 1536, 704 ],
  ),
  "edit_arrow_up": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf37f,
    categories: [ 2 ],
    tags: [ 1367, 380, 2871, 1731, 693, 1201, 388, 2651, 2834, 696, 2299, 8724, 2957, 1207, 966, 92, 1740, 778, 2958, 421, 763, 96, 2693, 2694, 1496, 1518, 8725, 106, 1124, 1676, 1260, 533, 346, 1536, 704 ],
  ),
  "edit_attributes": SymbolsMetadata(
    popularity: 538,
    codepoint: 0xe578,
    categories: [ 5 ],
    tags: [ 1726, 2687, 1549, 8726, 3352, 1748, 1731, 1630, 1632, 1633, 268, 1636, 1735, 1639, 696, 8727, 1755, 1641, 1740, 1643, 656, 5921, 1764, 8728, 2497, 77, 1664, 288, 65, 1412, 1647, 1260, 2386, 2387, 1523, 1650 ],
  ),
  "edit_audio": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf42d,
    categories: [ 0 ],
    tags: [ 1128, 8729, 380, 419, 1129, 8730, 8658, 8731, 365, 1731, 8732, 5807, 2804, 2805, 2450, 696, 8733, 8734, 8229, 8230, 2996, 3328, 8735, 1375, 1740, 8736, 2081, 8661, 8737, 1148, 177, 2247, 1396, 8738, 1156, 8739, 8740, 8741, 8637, 8742, 7009, 1161, 8692 ],
  ),
  "edit_calendar": SymbolsMetadata(
    popularity: 4442,
    codepoint: 0xe742,
    categories: [ 6 ],
    tags: [ 1726, 2488, 1015, 5341, 1731, 8743, 693, 2376, 1201, 1017, 5365, 5035, 1853, 8744, 696, 8745, 8746, 2299, 2094, 1755, 1740, 8747, 5347, 98, 2693, 2694, 2838, 75, 1030, 8748, 2497, 1031, 32, 289, 1260, 8749, 1536, 704 ],
  ),
  "edit_document": SymbolsMetadata(
    popularity: 2059,
    codepoint: 0xf88c,
    categories: [ 12 ],
    tags: [ 1726, 1731, 693, 8750, 1201, 1528, 1347, 8751, 1853, 1654, 696, 8752, 8753, 2299, 1530, 8754, 8755, 1656, 1657, 966, 1740, 8756, 1532, 1533, 1534, 1535, 2693, 2694, 2497, 8757, 38, 3114, 1260, 8758, 1536, 704 ],
  ),
  "edit_location": SymbolsMetadata(
    popularity: 803,
    codepoint: 0xe568,
    categories: [ 5 ],
    tags: [ 1429, 1731, 8759, 1484, 388, 696, 8760, 8761, 8762, 8763, 1488, 1001, 8764, 1002, 8765, 8766, 1490, 21, 1740, 8767, 421, 2693, 2694, 1493, 1494, 1495, 8768, 1783, 1496, 1498, 1083, 1260, 8769 ],
  ),
  "edit_location_alt": SymbolsMetadata(
    popularity: 604,
    codepoint: 0xe1c5,
    categories: [ 5 ],
    tags: [ 1499, 1731, 8759, 696, 8770, 8760, 8771, 8761, 8772, 8762, 8773, 8763, 8774, 8775, 1488, 1001, 8764, 1002, 8765, 8776, 21, 1740, 8767, 421, 2693, 2694, 1493, 1494, 1495, 1783, 1496, 1260, 8769 ],
  ),
  "edit_note": SymbolsMetadata(
    popularity: 14748,
    codepoint: 0xe745,
    categories: [ 12 ],
    tags: [ 1726, 2488, 1731, 693, 2376, 1201, 1347, 1853, 696, 8752, 1529, 8777, 2299, 1371, 530, 966, 366, 92, 8778, 1740, 1532, 8779, 3155, 2693, 2694, 2497, 8780, 38, 441, 1260, 1536, 704, 8781 ],
  ),
  "edit_notifications": SymbolsMetadata(
    popularity: 879,
    codepoint: 0xe525,
    categories: [ 6 ],
    tags: [ 1242, 1244, 469, 8782, 1246, 6308, 1731, 8783, 1248, 693, 1733, 269, 1201, 1735, 1853, 696, 8784, 2299, 966, 1755, 1740, 8785, 763, 486, 8786, 8313, 1120, 1254, 2693, 8787, 2694, 8788, 329, 1030, 8789, 1257, 65, 1156, 1260, 8790, 1536, 704 ],
  ),
  "edit_off": SymbolsMetadata(
    popularity: 874,
    codepoint: 0xe950,
    categories: [ 12 ],
    tags: [ 1074, 8791, 8792, 8793, 693, 1201, 1202, 3302, 2969, 8794, 8795, 8796, 767, 1853, 696, 8797, 2299, 8798, 898, 899, 966, 7067, 763, 8799, 8800, 8801, 907, 908, 909, 2693, 2694, 8802, 8803, 8804, 3310, 914, 1083, 915, 1536, 704, 8805, 3736 ],
  ),
  "edit_road": SymbolsMetadata(
    popularity: 462,
    codepoint: 0xef4d,
    categories: [ 5 ],
    tags: [ 1726, 1731, 8806, 2832, 1577, 1484, 388, 1578, 1579, 2834, 696, 8807, 8808, 1580, 1581, 366, 1002, 1490, 1740, 8809, 421, 1586, 2693, 2694, 8810, 1587, 8811, 1503, 1589, 441, 1590, 1591, 1260, 8812, 3229 ],
  ),
  "edit_square": SymbolsMetadata(
    popularity: 4395,
    codepoint: 0xf88d,
    categories: [ 6 ],
    tags: [ 1128, 1726, 2488, 3254, 8813, 1731, 693, 2376, 1201, 1735, 1853, 302, 696, 4931, 8752, 7280, 8814, 8777, 2299, 530, 966, 1641, 8815, 1740, 1532, 1533, 2693, 2694, 8816, 2695, 2497, 32, 8817, 1260, 1536, 704 ],
  ),
  "editor_choice": SymbolsMetadata(
    popularity: 220,
    codepoint: 0xf528,
    categories: [ 3 ],
    tags: [ 2717, 1549, 2480, 3574, 6, 3575, 3576, 1630, 1632, 383, 1635, 8818, 8819, 8820, 8821, 90, 3579, 1661, 1207, 1641, 1643, 202, 3581, 62, 8822, 8823, 3584, 2368, 3585, 288, 371, 5780, 1645, 1647, 1124, 8824, 6196, 2387, 2388, 1523, 8825, 3589, 1650 ],
  ),
  "egg": SymbolsMetadata(
    popularity: 1090,
    codepoint: 0xeacc,
    categories: [ 3 ],
    tags: [ 5177, 8826, 8827, 6886, 3790, 3791, 8828, 4386, 8829, 8830, 8831, 8832, 1822, 1829, 8073, 2018, 16, 8833, 1859, 8834, 8089, 1361, 5185, 2423, 3808, 105, 2439, 8835 ],
  ),
  "egg_alt": SymbolsMetadata(
    popularity: 747,
    codepoint: 0xeac8,
    categories: [ 3 ],
    tags: [ 3325, 8836, 3790, 3791, 3792, 383, 3795, 4386, 8829, 8830, 8831, 1829, 8837, 3328, 8073, 2018, 16, 8833, 3804, 788, 2097, 8089, 5185, 2423, 3807, 105, 35, 8835 ],
  ),
  "eject": SymbolsMetadata(
    popularity: 960,
    codepoint: 0xe8fb,
    categories: [ 2 ],
    tags: [ 2052, 2154, 3050, 3303, 2156, 3306, 2157, 1654, 8221, 6242, 1672, 8838, 6243, 1602, 367, 6466, 1719, 2904, 8839, 8840, 8841, 8842, 3068, 911, 2343, 1665, 2007, 1701, 1677, 346, 5275 ],
  ),
  "elderly": SymbolsMetadata(
    popularity: 1352,
    codepoint: 0xf21a,
    categories: [ 3 ],
    tags: [ 733, 734, 3194, 3195, 738, 584, 4406, 8843, 3198, 4408, 8844, 1753, 483, 4938, 1757, 770, 8845, 8846, 488, 489, 8847, 8848, 3205, 8849, 3493, 495, 3206, 3939 ],
  ),
  "elderly_woman": SymbolsMetadata(
    popularity: 966,
    codepoint: 0xeb69,
    categories: [ 3 ],
    tags: [ 733, 156, 3195, 738, 584, 4406, 8843, 3198, 8850, 1790, 1791, 8844, 8851, 8852, 8853, 8854, 1753, 483, 8855, 1757, 770, 8845, 8846, 488, 489, 8856, 8848, 3205, 8857, 607, 3493, 495, 35, 3206, 3939, 5011, 8858 ],
  ),
  "electric_bike": SymbolsMetadata(
    popularity: 483,
    codepoint: 0xeb1b,
    categories: [ 14 ],
    tags: [ 3769, 4311, 4312, 4076, 3773, 2063, 386, 8859, 8860, 8698, 4078, 8861, 4049, 3779, 2927, 6818, 4131, 1490, 8862, 8863, 3782, 2072, 4339, 231, 2371, 4086, 1930, 1504, 4340, 1844, 4342 ],
    rtlAutoMirrored: true,
  ),
  "electric_bolt": SymbolsMetadata(
    popularity: 2693,
    codepoint: 0xec1c,
    categories: [ 8 ],
    tags: [ 469, 4076, 3773, 3774, 3176, 4078, 8864, 8865, 8866, 4049, 8867, 3779, 8868, 1022, 4080, 4648, 4082, 4083, 8869, 1004, 3782, 4071, 8870, 1027, 231, 4650, 8871, 4086, 1261, 4654 ],
  ),
  "electric_car": SymbolsMetadata(
    popularity: 1280,
    codepoint: 0xeb1c,
    categories: [ 14 ],
    tags: [ 1131, 1814, 3467, 3769, 4076, 1815, 1816, 8872, 3774, 2063, 6814, 4078, 8873, 8865, 8874, 6014, 4049, 3779, 1890, 6015, 6818, 5634, 4131, 1490, 3782, 2371, 4086, 1930, 1504, 1844 ],
  ),
  "electric_meter": SymbolsMetadata(
    popularity: 718,
    codepoint: 0xec1b,
    categories: [ 8 ],
    tags: [ 8875, 4076, 798, 383, 8876, 1851, 1308, 4078, 8877, 4049, 3779, 1022, 3560, 999, 1435, 188, 4082, 8878, 4083, 4131, 597, 634, 3561, 327, 1004, 3782, 2507, 2631, 7119, 4086, 2165, 8879, 7570, 6367, 4653, 8880, 8881 ],
  ),
  "electric_moped": SymbolsMetadata(
    popularity: 646,
    codepoint: 0xeb1d,
    categories: [ 14 ],
    tags: [ 1814, 3769, 4312, 4076, 1815, 1816, 3774, 2063, 1019, 8882, 4078, 8883, 8884, 4331, 6014, 4049, 6015, 8885, 4131, 1490, 4334, 4335, 4336, 4338, 3782, 8886, 4339, 8887, 4086, 1930, 1504, 4340, 4341, 1844, 4342 ],
    rtlAutoMirrored: true,
  ),
  "electric_rickshaw": SymbolsMetadata(
    popularity: 369,
    codepoint: 0xeb1e,
    categories: [ 14 ],
    tags: [ 1131, 8888, 1814, 3467, 8889, 4076, 8890, 1815, 1816, 3774, 2063, 8698, 4078, 8891, 8883, 8892, 8893, 6014, 6015, 8885, 7449, 4131, 1490, 4334, 8894, 2072, 8886, 8887, 8895, 8896, 4086, 1930, 1504, 1843, 8897, 1844, 8898 ],
    rtlAutoMirrored: true,
  ),
  "electric_scooter": SymbolsMetadata(
    popularity: 562,
    codepoint: 0xeb1f,
    categories: [ 14 ],
    tags: [ 3769, 4312, 4076, 3773, 3774, 2602, 2063, 388, 1578, 8899, 4330, 8698, 4078, 4331, 4049, 8885, 8900, 4131, 1490, 8901, 8902, 3782, 2615, 2072, 4339, 3058, 8887, 4086, 1930, 1504, 4340, 8903, 1844, 4342, 4343 ],
    rtlAutoMirrored: true,
  ),
  "electrical_services": SymbolsMetadata(
    popularity: 1775,
    codepoint: 0xf102,
    categories: [ 5 ],
    tags: [ 8904, 1888, 4362, 3773, 3774, 921, 211, 4364, 8905, 445, 3306, 4078, 8906, 8907, 8908, 8909, 4049, 3216, 1711, 3779, 4370, 4371, 4139, 3782, 4374, 4084, 2631, 2755, 4376, 2758, 4378 ],
  ),
  "elevation": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xf6e7,
    categories: [ 15 ],
    tags: [ 3325, 2465, 2466, 2467, 2468, 2927, 304, 4544, 196, 595, 2470, 8910, 8911, 8912, 8913, 1207, 934, 366, 1544, 1545, 2474, 28, 8914, 2475, 8008, 109, 2477, 8915, 2478, 1701, 1676, 2917 ],
  ),
  "elevator": SymbolsMetadata(
    popularity: 652,
    codepoint: 0xf1a0,
    categories: [ 16 ],
    tags: [ 755, 733, 419, 584, 7, 798, 8916, 8917, 388, 2651, 8444, 8918, 483, 3472, 1001, 421, 1922, 488, 489, 2071, 32, 2008, 1842, 1930, 1504, 1701, 1676, 501, 8919 ],
  ),
  "emergency": SymbolsMetadata(
    popularity: 3068,
    codepoint: 0xe1eb,
    categories: [ 5 ],
    tags: [ 6931, 3466, 736, 469, 2479, 738, 3255, 1749, 7270, 3775, 1202, 1751, 2482, 4472, 595, 1753, 482, 1754, 3201, 1490, 1757, 1760, 602, 8920, 2486, 3264, 495, 35, 1034, 1261 ],
  ),
  "emergency_heat": SymbolsMetadata(
    popularity: 351,
    codepoint: 0xf15d,
    categories: [ 8 ],
    tags: [ 3175, 6931, 469, 3073, 8921, 1693, 712, 3775, 3176, 2482, 8922, 2766, 2767, 3177, 5601, 5311, 8923, 4647, 3076, 8924, 5673, 2471, 999, 3078, 8925, 1251, 2769, 1641, 1004, 486, 8926, 2772, 5861, 602, 35, 727, 729, 1034, 1261 ],
  ),
  "emergency_heat_2": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf4e5,
    categories: [ 8 ],
    tags: [ 3175, 707, 2078, 469, 3073, 8927, 2777, 1849, 1850, 1693, 712, 713, 3176, 2482, 8922, 2766, 2767, 3177, 3075, 8928, 926, 3076, 8924, 8929, 5673, 2471, 8930, 999, 3078, 723, 1251, 1641, 1004, 486, 3967, 35, 727, 8931, 729, 441, 1261, 1862, 1902, 8932, 731, 1863 ],
  ),
  "emergency_home": SymbolsMetadata(
    popularity: 2037,
    codepoint: 0xe82a,
    categories: [ 8 ],
    tags: [ 469, 3073, 1693, 3775, 3176, 1416, 1434, 2482, 2766, 2767, 3075, 4647, 999, 1435, 1436, 1251, 5223, 2769, 1641, 1004, 486, 2772, 1444, 1446, 5861, 1423, 602, 1011, 32, 35, 1034, 1261 ],
  ),
  "emergency_recording": SymbolsMetadata(
    popularity: 253,
    codepoint: 0xebf4,
    categories: [ 8 ],
    tags: [ 6931, 3466, 469, 2479, 3255, 3073, 5488, 47, 116, 1693, 7270, 3176, 6726, 2482, 8933, 8934, 270, 5509, 4472, 965, 595, 1754, 53, 1251, 5223, 1757, 420, 486, 119, 121, 177, 602, 1011, 2486, 3264, 41, 5519, 5521, 1261 ],
  ),
  "emergency_share": SymbolsMetadata(
    popularity: 326,
    codepoint: 0xebf6,
    categories: [ 8 ],
    tags: [ 469, 738, 3073, 355, 1693, 8935, 3176, 8936, 2482, 8937, 960, 8938, 1488, 482, 1251, 1489, 1001, 8939, 1002, 421, 223, 486, 1493, 1495, 1496, 602, 1011, 2343, 1665, 8940, 227, 228, 2486, 947, 5086, 1261, 233 ],
  ),
  "emergency_share_off": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf59e,
    categories: [ 8 ],
    tags: [ 469, 3073, 355, 8941, 1693, 3176, 896, 1076, 1077, 8942, 8141, 7966, 767, 2482, 8937, 8943, 898, 960, 8944, 1251, 1489, 8945, 1001, 8115, 8939, 8946, 8947, 7977, 486, 907, 908, 909, 1493, 8948, 1665, 8949, 3058, 8950, 227, 6980, 914, 2486, 1261 ],
  ),
  "emoji_food_beverage": SymbolsMetadata(
    popularity: 1405,
    codepoint: 0xea1b,
    categories: [ 3 ],
    tags: [ 4381, 2136, 3790, 3792, 6605, 8951, 6607, 6609, 4388, 8952, 1550, 4973, 8953, 4217, 8954, 6611, 8955, 788, 2097, 6614, 6615, 8956, 1958, 3807, 6616, 6617, 8957, 8958, 8959, 8960 ],
  ),
  "emoji_language": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf4cd,
    categories: [ 11 ],
    tags: [ 8961, 472, 443, 476, 8259, 8962, 1550, 1553, 1554, 479, 1555, 8963, 1556, 5070, 8964, 5071, 1557, 1558, 8965, 7414, 8966, 215, 969, 8967, 5651, 1560, 8968, 1561, 8969, 489, 5652, 1563, 1567, 1569, 607, 492, 493, 496, 7110, 8052, 1504, 1053, 4761, 8970, 5655 ],
  ),
  "emoji_nature": SymbolsMetadata(
    popularity: 2223,
    codepoint: 0xea1c,
    categories: [ 3 ],
    tags: [ 5177, 1180, 8971, 7622, 7623, 5178, 8972, 7986, 1550, 1890, 8973, 2433, 1918, 1973, 6816, 196, 8974, 5184, 8975, 8976, 1859, 1860, 8977, 1835, 8978, 2439, 4206, 7371, 8979 ],
  ),
  "emoji_objects": SymbolsMetadata(
    popularity: 7363,
    codepoint: 0xea24,
    categories: [ 3 ],
    tags: [ 3670, 3942, 8980, 5163, 955, 4078, 1550, 8981, 3779, 8982, 960, 6063, 3944, 6632, 3945, 8983, 8984, 4686, 4695, 3680, 3946, 763, 422, 8985, 3782, 8986, 8987, 6641, 7531 ],
  ),
  "emoji_people": SymbolsMetadata(
    popularity: 3933,
    codepoint: 0xea1d,
    categories: [ 3 ],
    tags: [ 468, 8988, 470, 584, 194, 475, 1550, 6155, 930, 2738, 8989, 8990, 483, 488, 489, 490, 8991, 105, 607, 4940, 750, 495, 946, 501, 1862, 8992, 766 ],
  ),
  "emoji_symbols": SymbolsMetadata(
    popularity: 774,
    codepoint: 0xea1e,
    categories: [ 3 ],
    tags: [ 8993, 8994, 8, 693, 696, 1550, 8995, 5334, 8996, 8997, 16, 966, 1044, 969, 2081, 3394, 1532, 6413, 4142, 7494, 3263, 35, 8998, 38, 40, 702, 704 ],
  ),
  "emoji_transportation": SymbolsMetadata(
    popularity: 1398,
    codepoint: 0xea1f,
    categories: [ 3 ],
    tags: [ 2601, 2014, 1814, 798, 1815, 1816, 2602, 8999, 2063, 4325, 2016, 1484, 388, 1654, 3484, 1550, 2605, 1581, 1001, 1490, 421, 4319, 1495, 2071, 2614, 1446, 2616, 2072, 6782, 1587, 2617, 1589, 8895, 9000, 1590, 1842, 1930, 1504, 1591, 2621, 1844 ],
  ),
  "emoticon": SymbolsMetadata(
    popularity: 55,
    codepoint: 0xe5f3,
    categories: [ 3 ],
    tags: [ 192, 526, 472, 443, 1042, 1550, 1551, 1552, 1553, 6699, 1554, 479, 9001, 1555, 9002, 6231, 2819, 1556, 4192, 1557, 1558, 6701, 16, 1559, 1044, 6157, 9003, 1560, 485, 1561, 763, 9004, 489, 2821, 1563, 202, 1213, 9005, 1567, 1568, 1569, 607, 31, 1570, 35, 9006, 9007, 9008 ],
  ),
  "empty_dashboard": SymbolsMetadata(
    popularity: 188,
    codepoint: 0xf844,
    categories: [ 2 ],
    tags: [ 526, 5, 1230, 6089, 5793, 1733, 1201, 2515, 10, 4825, 4013, 9009, 1372, 538, 246, 7502, 3079, 2518, 306, 937, 763, 7583, 7499, 1068, 4855, 2648, 5795, 75, 2258, 1353, 2649, 5922, 32, 944, 108, 6403, 1691, 1053, 1054 ],
  ),
  "enable": SymbolsMetadata(
    popularity: 1324,
    codepoint: 0xf188,
    categories: [ 2 ],
    tags: [ 755, 951, 380, 2650, 3453, 3074, 6100, 383, 1776, 896, 2651, 2840, 337, 2855, 9010, 2909, 966, 1044, 852, 907, 909, 26, 3782, 4987, 3012, 288, 65, 2913, 108, 9011, 313, 314 ],
  ),
  "encrypted": SymbolsMetadata(
    popularity: 794,
    codepoint: 0xe593,
    categories: [ 13 ],
    tags: [ 755, 1510, 3242, 9012, 7138, 3244, 3245, 4120, 2854, 9013, 6526, 9014, 6527, 968, 9015, 9016, 2674, 9017, 6528, 5715, 1516, 1517, 1519, 4329, 1520, 1772, 9018, 602, 1773, 1011, 1522, 9019, 1523 ],
  ),
  "encrypted_add": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf429,
    categories: [ 13 ],
    tags: [ 192, 526, 9020, 9021, 9022, 9023, 9024, 1510, 1201, 3244, 9013, 6526, 9025, 9026, 968, 9015, 9016, 2674, 763, 9027, 9028, 1211, 5715, 202, 9029, 9030, 9031, 1516, 1517, 1519, 1520, 1772, 602, 1773, 1011, 1522, 35, 1523 ],
  ),
  "encrypted_add_circle": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf42a,
    categories: [ 13 ],
    tags: [ 192, 526, 9032, 9020, 9021, 9022, 9023, 9033, 9034, 9024, 1506, 1510, 1201, 9013, 6526, 9035, 9026, 968, 9016, 763, 2692, 1211, 9036, 5715, 202, 9031, 1515, 1516, 1517, 1519, 1520, 1772, 602, 1773, 1011, 1522, 35, 1523 ],
  ),
  "encrypted_minus_circle": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf428,
    categories: [ 13 ],
    tags: [ 5330, 755, 468, 1074, 1510, 383, 9012, 3244, 2922, 9037, 897, 8287, 9038, 9013, 6526, 9039, 900, 9014, 968, 9016, 1116, 6528, 1211, 5715, 1516, 1517, 1519, 1520, 2930, 911, 9040, 3310, 889, 602, 1773, 1011, 1522, 1122, 35, 9041, 501, 1523 ],
  ),
  "encrypted_off": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf427,
    categories: [ 13 ],
    tags: [ 755, 895, 1510, 3176, 9037, 9042, 9038, 9043, 767, 898, 9013, 6526, 9039, 9044, 899, 9045, 968, 9016, 9046, 9047, 9048, 907, 908, 909, 2653, 5715, 1516, 1517, 1519, 1520, 9049, 5861, 602, 1773, 1011, 9050, 1522, 9051, 914, 4677, 5717, 9052, 1523, 7539 ],
  ),
  "endocrinology": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xe0a9,
    categories: [ 3 ],
    tags: [ 3325, 9053, 1015, 2412, 584, 1751, 9054, 9055, 9056, 9057, 9058, 196, 595, 1753, 9059, 9060, 483, 9061, 9062, 1757, 9063, 9064, 9065, 822, 9066, 9067, 9068, 2424, 9069, 9070, 9071, 35, 9072, 9073, 1905 ],
  ),
  "energy": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xe9a6,
    categories: [ 9 ],
    tags: [ 707, 9074, 9075, 9076, 712, 6814, 4049, 3779, 1890, 719, 2550, 7077, 9077, 6818, 9078, 3782, 9079, 6824, 9080, 397, 2371, 9081, 9082, 730, 731, 1863, 9083, 9084, 9085 ],
  ),
  "energy_program_saving": SymbolsMetadata(
    popularity: 437,
    codepoint: 0xf15f,
    categories: [ 8 ],
    tags: [ 2717, 6, 1510, 8696, 8882, 9086, 9087, 9088, 4075, 1890, 2433, 9078, 3579, 5637, 9089, 1859, 1835, 4023, 2648, 9090, 9091, 3585, 310, 65, 2728, 3264, 2370, 9092 ],
  ),
  "energy_program_time_used": SymbolsMetadata(
    popularity: 364,
    codepoint: 0xf161,
    categories: [ 8 ],
    tags: [ 5, 1015, 1344, 365, 5341, 920, 8876, 10, 1020, 6814, 3500, 3779, 929, 6818, 1023, 5637, 366, 1859, 2648, 75, 1353, 1031, 32, 33, 289, 947, 7570, 9093, 1592 ],
  ),
  "energy_savings_leaf": SymbolsMetadata(
    popularity: 1291,
    codepoint: 0xec1a,
    categories: [ 8 ],
    tags: [ 6558, 8696, 6814, 8698, 6565, 4049, 3779, 9094, 9095, 9087, 9096, 9097, 1890, 6818, 9078, 5637, 6820, 4131, 3781, 1859, 1004, 9098, 3782, 4023, 9090, 9080, 9091, 824, 2370, 2371, 7570 ],
  ),
  "engineering": SymbolsMetadata(
    popularity: 8326,
    codepoint: 0xea3d,
    categories: [ 15 ],
    tags: [ 584, 5803, 5240, 6806, 4176, 2832, 2625, 6583, 2835, 9099, 3487, 9100, 6175, 9101, 483, 6924, 3170, 9102, 2770, 6925, 2837, 9103, 488, 489, 9104, 490, 3474, 602, 310, 65, 495, 9105, 501, 9106 ],
  ),
  "enhanced_encryption": SymbolsMetadata(
    popularity: 1008,
    codepoint: 0xe63f,
    categories: [ 13 ],
    tags: [ 192, 755, 526, 4093, 3242, 9012, 3244, 3245, 6526, 654, 9107, 530, 1207, 2674, 5714, 763, 6530, 5715, 202, 1516, 1517, 1519, 1520, 9108, 912, 1772, 602, 1773, 1011, 5964, 9109, 35, 533, 9110 ],
  ),
  "ent": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xe0aa,
    categories: [ 3 ],
    tags: [ 3325, 470, 4943, 1400, 584, 6629, 472, 9111, 473, 443, 194, 4262, 6647, 2332, 8629, 479, 1738, 14, 481, 1659, 6220, 1190, 4490, 595, 9101, 483, 16, 3944, 6631, 850, 5206, 3945, 3502, 4686, 3375, 9112, 1602, 1143, 2528, 5291, 6633, 485, 6635, 2783, 6899, 9064, 223, 9113, 488, 6636, 489, 1409, 490, 9114, 6638, 311, 2074, 6201, 607, 492, 35, 496, 9115, 6641, 6642, 6643, 9072, 6644, 501, 9116 ],
  ),
  "enterprise": SymbolsMetadata(
    popularity: 177,
    codepoint: 0xe70e,
    categories: [ 9 ],
    tags: [ 1747, 3719, 4741, 7, 5238, 1284, 5240, 5241, 383, 1285, 9117, 1269, 8382, 1347, 832, 5244, 2626, 1655, 808, 1656, 5810, 3489, 3170, 936, 1045, 1456, 9118, 940, 5245, 5246, 3156, 5247, 75, 5248, 3857, 2755, 32, 674, 6193, 4744, 1645, 1459 ],
  ),
  "enterprise_off": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xeb4d,
    categories: [ 9 ],
    tags: [ 3719, 4741, 894, 5238, 1284, 1075, 5240, 5241, 1285, 5242, 896, 9119, 2969, 1077, 767, 5244, 898, 2626, 901, 3170, 7067, 9120, 9121, 9122, 9123, 9124, 9125, 907, 1456, 909, 5247, 75, 171, 914, 32, 4744, 915, 1459 ],
  ),
  "equal": SymbolsMetadata(
    popularity: 233,
    codepoint: 0xf77b,
    categories: [ 12 ],
    tags: [ 794, 1199, 5332, 3812, 3813, 9, 2138, 2174, 3817, 5334, 2377, 9126, 2378, 6327, 2176, 2080, 9127, 2472, 366, 2379, 9128, 1210, 2380, 9129, 788, 421, 977, 656, 2294, 9130, 65, 461, 35, 1214 ],
  ),
  "equalizer": SymbolsMetadata(
    popularity: 3363,
    codepoint: 0xe01d,
    categories: [ 0 ],
    tags: [ 1128, 9131, 5060, 5, 1129, 9132, 9133, 9134, 6456, 794, 365, 920, 269, 1735, 10, 8230, 277, 929, 934, 597, 937, 2081, 9135, 9136, 1148, 65, 1156, 9137, 9138, 9139, 8319, 9140, 9141, 33, 3411, 440, 947, 2253, 1745, 9142, 8692 ],
  ),
  "eraser_size_1": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf3fc,
    categories: [ 12 ],
    tags: [ 79, 3254, 1748, 3436, 3181, 897, 2969, 302, 9143, 696, 2299, 3438, 9144, 1372, 1602, 9145, 3330, 1764, 75, 911, 3331, 311, 673, 5170, 1979, 4818, 9146, 9147, 2537, 3831, 9148, 3014 ],
  ),
  "eraser_size_2": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf3fb,
    categories: [ 12 ],
    tags: [ 5162, 895, 1748, 3436, 3181, 897, 2969, 302, 696, 2299, 3438, 9144, 1372, 3634, 1602, 9145, 4044, 9149, 3330, 1764, 911, 3331, 9150, 673, 5170, 4818, 9146, 9151, 9147, 2537, 2499, 3831, 3014 ],
  ),
  "eraser_size_3": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf3fa,
    categories: [ 12 ],
    tags: [ 895, 1748, 3436, 3181, 897, 299, 2969, 302, 696, 2299, 3438, 9144, 1372, 1602, 9145, 4044, 9149, 3330, 5185, 1764, 911, 3331, 7443, 9150, 673, 5170, 4818, 9146, 9151, 9147, 374, 2537, 2499, 3831, 3014 ],
  ),
  "eraser_size_4": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf3f9,
    categories: [ 12 ],
    tags: [ 534, 2829, 9152, 895, 3436, 3181, 897, 299, 302, 696, 2299, 8832, 3438, 9144, 1372, 538, 3634, 9145, 9149, 3330, 5185, 911, 3331, 7443, 9150, 673, 4818, 9146, 9151, 9147, 2537, 2499, 3831, 3014 ],
  ),
  "eraser_size_5": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf3f8,
    categories: [ 12 ],
    tags: [ 2829, 9153, 895, 3436, 3181, 897, 9154, 302, 696, 2299, 8832, 3438, 9144, 1372, 3634, 9145, 9149, 3330, 5185, 911, 3331, 7443, 9150, 9155, 5170, 4818, 9146, 9147, 2537, 2499, 3831 ],
  ),
  "error": SymbolsMetadata(
    popularity: 28983,
    codepoint: 0xe000,
    categories: [ 6 ],
    tags: [ 3175, 469, 3073, 1693, 383, 3176, 2766, 2767, 9156, 480, 482, 1251, 9157, 135, 8403, 2769, 1641, 485, 9149, 486, 9158, 1361, 1363, 2772, 1353, 3331, 553, 495, 35, 9159, 1261 ],
  ),
  "error_med": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xe49b,
    categories: [ 2 ],
    tags: [ 469, 3073, 1693, 383, 3176, 2766, 2768, 7879, 480, 595, 16, 1251, 135, 2769, 366, 1760, 4044, 485, 9149, 4045, 9160, 486, 2772, 1353, 889, 553, 35, 1261, 9161 ],
  ),
  "escalator": SymbolsMetadata(
    popularity: 230,
    codepoint: 0xf1a1,
    categories: [ 16 ],
    tags: [ 755, 733, 2013, 798, 8917, 2969, 2651, 9162, 8444, 9163, 8912, 3472, 9164, 7745, 9165, 9166, 4601, 8914, 8008, 32, 9167, 9168, 3611, 4621, 2008, 1842, 1930, 1504, 1676 ],
  ),
  "escalator_warning": SymbolsMetadata(
    popularity: 1075,
    codepoint: 0xf1ac,
    categories: [ 16 ],
    tags: [ 755, 733, 154, 469, 9169, 584, 1693, 862, 865, 2063, 9162, 9163, 867, 591, 3225, 4647, 9170, 483, 870, 9165, 874, 1922, 488, 489, 1967, 4601, 2072, 602, 750, 877, 1930, 1504, 1261 ],
  ),
  "euro": SymbolsMetadata(
    popularity: 3159,
    codepoint: 0xea15,
    categories: [ 9 ],
    tags: [ 796, 797, 1618, 799, 1619, 800, 1326, 801, 803, 1327, 805, 806, 807, 9171, 9172, 9173, 9174, 9175, 2627, 808, 815, 7175, 1291, 7433, 818, 819, 9176, 820, 821, 1337, 840, 3322, 841, 35, 5752, 842, 1214, 463, 3324 ],
  ),
  "euro_symbol": SymbolsMetadata(
    popularity: 2155,
    codepoint: 0xe926,
    categories: [ 9 ],
    tags: [ 468, 796, 797, 828, 799, 800, 801, 803, 1327, 805, 806, 807, 9171, 9172, 9173, 9174, 2627, 3318, 808, 7409, 811, 7414, 815, 7433, 818, 819, 9176, 820, 821, 1337, 840, 841, 35, 842, 1214, 3324, 9177 ],
  ),
  "ev_mobiledata_badge": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf7e2,
    categories: [ 4 ],
    tags: [ 4, 1814, 3467, 6, 1815, 208, 8, 4514, 213, 11, 6014, 6015, 14, 16, 2780, 432, 19, 219, 433, 221, 222, 223, 24, 226, 190, 227, 231, 32, 35, 9178, 38, 1930, 40, 9179, 233, 234 ],
  ),
  "ev_shadow": SymbolsMetadata(
    popularity: 313,
    codepoint: 0xef8f,
    categories: [ 1 ],
    tags: [ 365, 4416, 5271, 3774, 383, 1734, 4365, 4246, 3690, 5035, 9180, 696, 2299, 2567, 4078, 4049, 6015, 959, 5071, 9181, 9182, 1078, 53, 3680, 366, 4253, 4220, 6304, 1081, 61, 119, 3782, 2948, 4204, 9183, 4422, 5081, 2586, 9184, 9185, 5677, 731 ],
  ),
  "ev_shadow_add": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf580,
    categories: [ 1 ],
    tags: [ 192, 526, 1057, 1058, 9186, 5271, 3774, 383, 1061, 4864, 1201, 4246, 696, 2299, 4078, 4049, 3327, 6015, 787, 959, 9181, 1204, 53, 1206, 1207, 1044, 1064, 4964, 366, 1067, 763, 422, 1081, 61, 119, 202, 1213, 3782, 4204, 9183, 6329, 441, 9184 ],
  ),
  "ev_shadow_minus": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf57f,
    categories: [ 1 ],
    tags: [ 5330, 3325, 1343, 5271, 3774, 383, 1469, 268, 1735, 5807, 2922, 897, 9187, 696, 2299, 4078, 4049, 6015, 959, 9181, 2176, 16, 53, 6248, 1116, 3696, 656, 1081, 61, 119, 3782, 2930, 911, 889, 65, 4204, 9183, 2586, 1122, 35, 441, 9184 ],
  ),
  "ev_station": SymbolsMetadata(
    popularity: 1068,
    codepoint: 0xe56d,
    categories: [ 5 ],
    tags: [ 1814, 3467, 3769, 4076, 4362, 1815, 1816, 3773, 5271, 3774, 6017, 6814, 4078, 8873, 4368, 8865, 6014, 4049, 3779, 6015, 9188, 9189, 9190, 6818, 999, 4131, 1001, 6280, 1490, 421, 2613, 4371, 3782, 9191, 3611, 2371, 4086, 1930, 1844, 4378 ],
  ),
  "event": SymbolsMetadata(
    popularity: 13770,
    codepoint: 0xe878,
    categories: [ 6 ],
    tags: [ 526, 5340, 1015, 1936, 5341, 383, 1201, 1017, 5035, 1018, 832, 2094, 2018, 1044, 9192, 1641, 1145, 5347, 9193, 2838, 1007, 75, 4270, 1030, 1924, 5349, 1031, 9194, 32, 289, 5351, 5372, 5352 ],
  ),
  "event_available": SymbolsMetadata(
    popularity: 6772,
    codepoint: 0xe614,
    categories: [ 6 ],
    tags: [ 1627, 6081, 5340, 1015, 1549, 2480, 6099, 3063, 5341, 1630, 1632, 1633, 1635, 1636, 4269, 1017, 5035, 1639, 2094, 1641, 1643, 2838, 2107, 1030, 1031, 288, 2487, 1647, 289, 2385, 2386, 2387, 1523, 1650 ],
  ),
  "event_busy": SymbolsMetadata(
    popularity: 2167,
    codepoint: 0xe615,
    categories: [ 6 ],
    tags: [ 1015, 9195, 8308, 9196, 5341, 895, 9197, 3436, 2950, 4663, 1202, 1017, 5035, 4439, 9198, 897, 2094, 9199, 2985, 4043, 5347, 4152, 9200, 4450, 911, 9201, 1031, 9202, 1083, 289, 915, 9203, 3736 ],
  ),
  "event_list": SymbolsMetadata(
    popularity: 88,
    codepoint: 0xf683,
    categories: [ 2 ],
    tags: [ 5340, 9204, 5792, 5341, 9205, 6086, 1631, 9206, 2094, 9207, 5133, 2080, 2245, 1501, 1602, 92, 9208, 7506, 1755, 940, 98, 2838, 2107, 100, 9209, 1031, 944, 3159, 290, 1649, 1214, 9210, 317 ],
  ),
  "event_note": SymbolsMetadata(
    popularity: 4040,
    codepoint: 0xe616,
    categories: [ 6 ],
    tags: [ 5340, 1015, 5341, 9211, 1017, 9212, 5035, 1018, 3458, 1347, 2094, 9213, 5346, 3461, 92, 8778, 5347, 1532, 1533, 486, 940, 2107, 1030, 1031, 9214, 1645, 38, 289, 704, 5352 ],
    rtlAutoMirrored: true,
  ),
  "event_repeat": SymbolsMetadata(
    popularity: 1550,
    codepoint: 0xeb7b,
    categories: [ 6 ],
    tags: [ 5340, 2284, 5341, 385, 5374, 1017, 5035, 1018, 2094, 277, 3524, 3513, 3525, 390, 936, 5347, 9215, 2107, 9216, 2366, 9217, 9218, 9219, 424, 425, 1030, 2494, 2367, 5297, 396, 1031, 289, 402, 1260, 5397, 9220 ],
  ),
  "event_seat": SymbolsMetadata(
    popularity: 445,
    codepoint: 0xe903,
    categories: [ 8 ],
    tags: [ 1015, 5976, 1509, 9221, 9222, 1059, 1936, 1912, 267, 4711, 1135, 2094, 9223, 1964, 1001, 1145, 189, 1495, 1924, 1603, 1926, 5987, 1377, 2997, 1961, 8193, 32, 3412, 441, 2022, 5137, 9224 ],
  ),
  "event_upcoming": SymbolsMetadata(
    popularity: 2726,
    codepoint: 0xf238,
    categories: [ 6 ],
    tags: [ 5339, 5340, 1015, 380, 9225, 1936, 5341, 9226, 1017, 5035, 1018, 2094, 777, 6407, 6106, 9227, 5347, 780, 9228, 2838, 1030, 1924, 1396, 5349, 1031, 289, 9229, 5372 ],
    rtlAutoMirrored: true,
  ),
  "exclamation": SymbolsMetadata(
    popularity: 2849,
    codepoint: 0xf22f,
    categories: [ 13 ],
    tags: [ 3175, 469, 3073, 1693, 3775, 3176, 2482, 2766, 2767, 3177, 3075, 6951, 480, 482, 2471, 9230, 1251, 135, 2769, 1641, 9160, 486, 2772, 4102, 1030, 1353, 5861, 9231, 553, 495, 35, 1261 ],
  ),
  "exercise": SymbolsMetadata(
    popularity: 162,
    codepoint: 0xf6e6,
    categories: [ 15 ],
    tags: [ 1242, 989, 8149, 9232, 1343, 9233, 9234, 1730, 9235, 2925, 2242, 2926, 2927, 5776, 595, 6190, 2080, 9236, 9237, 4295, 2613, 3782, 5780, 3595, 5952, 5964, 441, 5781, 3831, 9238, 9239, 1905, 3596 ],
  ),
  "exit_to_app": SymbolsMetadata(
    popularity: 5859,
    codepoint: 0xe879,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 7, 2750, 299, 2604, 6103, 2985, 9240, 1672, 9241, 1471, 777, 6105, 2751, 3080, 306, 6244, 9242, 903, 219, 327, 778, 780, 9243, 9244, 2398, 1719, 226, 5653, 782, 330, 913, 2882, 32, 447, 1689, 2757, 2759, 1691, 1053, 1054 ],
    rtlAutoMirrored: true,
  ),
  "expand": SymbolsMetadata(
    popularity: 2431,
    codepoint: 0xe94f,
    categories: [ 2 ],
    tags: [ 380, 419, 3086, 132, 2450, 2651, 2840, 1216, 787, 9245, 2996, 1673, 1204, 2080, 366, 2307, 789, 778, 2653, 3012, 2247, 2281, 3093, 2401, 2249, 6803, 2455, 1676, 1677, 1381, 3110, 986, 2403, 2404 ],
  ),
  "expand_all": SymbolsMetadata(
    popularity: 429,
    codepoint: 0xe946,
    categories: [ 2 ],
    tags: [ 2325, 380, 419, 2871, 2862, 2896, 7853, 1578, 3101, 2450, 6654, 3593, 2651, 2941, 9246, 787, 3096, 9247, 7856, 92, 788, 421, 2653, 9248, 9249, 2948, 9250, 3099, 9251, 314, 2949, 9252, 1676 ],
  ),
  "expand_circle_down": SymbolsMetadata(
    popularity: 9306,
    codepoint: 0xe7cd,
    categories: [ 2 ],
    tags: [ 6658, 380, 2892, 419, 2871, 2862, 383, 2902, 2896, 132, 388, 12, 2651, 2941, 787, 9253, 9247, 9254, 9255, 7856, 2953, 3102, 6663, 92, 789, 421, 2653, 2948, 2900, 2997, 314, 9256 ],
  ),
  "expand_circle_right": SymbolsMetadata(
    popularity: 115,
    codepoint: 0xf591,
    categories: [ 2 ],
    tags: [ 380, 9257, 2892, 419, 2862, 383, 2902, 9258, 2896, 776, 132, 388, 3101, 2651, 2941, 1216, 787, 9259, 9253, 7856, 9260, 6663, 2996, 777, 92, 789, 778, 421, 9261, 780, 2653, 28, 1396, 782, 9262 ],
    rtlAutoMirrored: true,
  ),
  "expand_circle_up": SymbolsMetadata(
    popularity: 97,
    codepoint: 0xf5d2,
    categories: [ 2 ],
    tags: [ 380, 419, 2466, 2871, 2862, 383, 2896, 388, 2995, 2651, 1216, 787, 9253, 9247, 9254, 2956, 6663, 2996, 1204, 1207, 92, 2307, 789, 2958, 421, 2653, 2948, 2475, 3103, 1124, 6330, 2949, 1676, 346 ],
  ),
  "expand_content": SymbolsMetadata(
    popularity: 674,
    codepoint: 0xf830,
    categories: [ 2 ],
    tags: [ 380, 419, 2862, 2896, 2391, 545, 388, 2651, 1216, 787, 9254, 7856, 6663, 6664, 2996, 1673, 9263, 1204, 2396, 3759, 92, 2397, 2307, 9264, 789, 421, 2653, 2247, 2948, 3046, 2401, 3103, 2249, 2949, 3110, 2403 ],
  ),
  "expansion_panels": SymbolsMetadata(
    popularity: 72,
    codepoint: 0xe600,
    categories: [ 2 ],
    tags: [ 6658, 380, 419, 2862, 3592, 2950, 2896, 4900, 6660, 1042, 1578, 2450, 3593, 2651, 2941, 787, 4901, 9265, 900, 4964, 788, 421, 2653, 1770, 3421, 2948, 1377, 2997, 314, 1676 ],
  ),
  "experiment": SymbolsMetadata(
    popularity: 1390,
    codepoint: 0xe686,
    categories: [ 15 ],
    tags: [ 2513, 9266, 9267, 9268, 6557, 9269, 4347, 9270, 9271, 9272, 9273, 9274, 4348, 9275, 9276, 9277, 964, 4474, 9278, 4352, 4359, 9279, 2424, 9280, 9281, 9282, 3160, 9283, 8162 ],
  ),
  "explicit": SymbolsMetadata(
    popularity: 383,
    codepoint: 0xe01e,
    categories: [ 0 ],
    tags: [ 686, 154, 4, 1074, 7, 8, 443, 693, 1042, 1201, 8618, 696, 2299, 9284, 14, 5206, 9285, 1044, 5651, 4704, 8619, 19, 367, 485, 3541, 2081, 78, 32, 35, 38, 40, 702, 704 ],
  ),
  "explore": SymbolsMetadata(
    popularity: 9579,
    codepoint: 0xe87a,
    categories: [ 5 ],
    tags: [ 2464, 383, 2831, 9286, 1484, 1416, 388, 3043, 955, 4292, 3016, 5575, 958, 9287, 960, 3226, 1581, 1001, 1002, 1490, 421, 3045, 3562, 3070, 3147, 1496, 980, 2935, 1504, 5237, 3229, 3039 ],
  ),
  "explore_nearby": SymbolsMetadata(
    popularity: 70,
    codepoint: 0xe538,
    categories: [ 5 ],
    tags: [ 993, 1483, 1484, 388, 955, 958, 9288, 960, 1486, 1488, 6868, 9289, 9290, 1001, 1002, 6280, 21, 421, 9291, 9292, 1493, 1494, 1495, 9293, 9294, 1496, 6959, 1008, 980, 8193, 1504 ],
  ),
  "explore_off": SymbolsMetadata(
    popularity: 252,
    codepoint: 0xe9a8,
    categories: [ 5 ],
    tags: [ 9295, 380, 383, 2831, 9296, 1076, 1484, 388, 9297, 767, 9298, 3016, 898, 9299, 9300, 958, 9301, 9302, 8944, 8113, 9303, 901, 7095, 1001, 8115, 8117, 1490, 8143, 3562, 9304, 3070, 907, 909, 9305, 7102, 9306, 9307, 914, 2935, 2126, 9308, 9309, 9310, 1504, 9311, 1701, 9312, 9313, 3039 ],
  ),
  "explosion": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf685,
    categories: [ 3 ],
    tags: [ 469, 3255, 4655, 7845, 4657, 4658, 4659, 4660, 4661, 4662, 5667, 3176, 4666, 4667, 4668, 3257, 3779, 787, 3104, 4669, 4670, 9314, 4080, 7849, 7850, 4672, 4673, 9315, 3782, 9316, 9317, 9318, 3264, 5057, 1261 ],
  ),
  "export_notes": SymbolsMetadata(
    popularity: 151,
    codepoint: 0xe0ac,
    categories: [ 12 ],
    tags: [ 380, 383, 1042, 10, 1528, 1347, 337, 1672, 2628, 6243, 1530, 595, 9319, 135, 366, 778, 1532, 1533, 1719, 1534, 1535, 1396, 78, 1664, 2343, 1665, 3058, 32, 38, 2007, 1677, 346, 704 ],
  ),
  "exposure": SymbolsMetadata(
    popularity: 495,
    codepoint: 0xe3ca,
    categories: [ 1 ],
    tags: [ 526, 1128, 794, 1728, 47, 1734, 269, 2922, 2969, 88, 696, 2299, 2567, 5047, 270, 16, 53, 1207, 9320, 2472, 3680, 1116, 59, 61, 119, 202, 75, 2425, 122, 65, 1378, 32, 1122, 35 ],
  ),
  "exposure_neg_1": SymbolsMetadata(
    popularity: 254,
    codepoint: 0xe3cb,
    categories: [ 1 ],
    tags: [ 79, 1128, 1728, 47, 1734, 269, 9321, 2922, 7644, 11, 2651, 696, 2299, 2567, 6015, 5047, 9322, 9323, 53, 7648, 1116, 9324, 9325, 3696, 9326, 23, 24, 3542, 59, 61, 2930, 65, 1122, 35, 9327 ],
  ),
  "exposure_neg_2": SymbolsMetadata(
    popularity: 174,
    codepoint: 0xe3cc,
    categories: [ 1 ],
    tags: [ 9328, 81, 1128, 1728, 47, 1734, 9321, 2922, 7644, 11, 2651, 696, 2299, 2567, 6015, 5047, 9322, 9323, 53, 9329, 2315, 9330, 9325, 3696, 9331, 23, 24, 59, 61, 2930, 65, 1122, 35, 315, 9327 ],
  ),
  "exposure_plus_1": SymbolsMetadata(
    popularity: 736,
    codepoint: 0xe3cd,
    categories: [ 1 ],
    tags: [ 79, 526, 9332, 1197, 1198, 4093, 1728, 2375, 1734, 9, 11, 696, 2299, 2567, 5047, 9333, 777, 6021, 53, 1207, 9334, 1217, 9335, 1210, 2380, 789, 780, 23, 24, 3542, 59, 61, 202, 9336, 1213, 29, 65, 3935, 461, 35, 191, 1676 ],
  ),
  "exposure_plus_2": SymbolsMetadata(
    popularity: 254,
    codepoint: 0xe3ce,
    categories: [ 1 ],
    tags: [ 9337, 81, 526, 1197, 9338, 1728, 47, 1734, 11, 696, 2299, 2567, 9339, 5047, 9322, 53, 3145, 1207, 9340, 1217, 9341, 7200, 7201, 24, 59, 3422, 61, 202, 9342, 1213, 65, 35, 315, 9343, 9344, 1676 ],
  ),
  "exposure_zero": SymbolsMetadata(
    popularity: 296,
    codepoint: 0xe3cf,
    categories: [ 1 ],
    tags: [ 5058, 1128, 5060, 1131, 1132, 1728, 47, 383, 1734, 269, 4825, 11, 696, 2299, 2567, 6015, 5047, 9322, 16, 53, 3680, 5062, 1804, 23, 24, 5185, 59, 61, 119, 426, 889, 65, 35, 375 ],
  ),
  "extension": SymbolsMetadata(
    popularity: 4352,
    codepoint: 0xe87b,
    categories: [ 6 ],
    tags: [ 526, 8361, 8362, 1229, 1058, 1061, 1633, 4864, 268, 921, 6676, 787, 6264, 8363, 1951, 529, 2242, 9345, 697, 1044, 2629, 9346, 1064, 935, 4868, 656, 5018, 4139, 9347, 7330, 65, 311, 7860 ],
  ),
  "extension_off": SymbolsMetadata(
    popularity: 678,
    codepoint: 0xe4f5,
    categories: [ 2 ],
    tags: [ 8362, 9348, 894, 896, 9349, 9350, 9351, 1077, 9352, 9353, 9354, 767, 898, 6264, 8363, 9355, 9346, 9356, 9357, 9358, 907, 909, 5018, 4139, 9359, 7330, 9360, 911, 9361, 9362, 9363, 311, 914, 9364, 9365, 9366, 9367 ],
  ),
  "eye_tracking": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf4c9,
    categories: [ 0 ],
    tags: [ 1242, 5957, 3811, 8702, 3909, 1730, 2391, 2804, 2805, 6300, 9368, 9369, 1738, 1250, 274, 9370, 2809, 971, 327, 420, 9371, 8559, 909, 3583, 2948, 1723, 1011, 981, 2997, 7070, 32, 36, 2165, 947, 317, 5023, 4583, 2102 ],
  ),
  "eyeglasses": SymbolsMetadata(
    popularity: 276,
    codepoint: 0xf6ee,
    categories: [ 3 ],
    tags: [ 7985, 3370, 9372, 9373, 9374, 9375, 2705, 276, 9376, 9377, 900, 9378, 971, 9379, 9380, 4536, 9381, 2506, 9382, 2948, 981, 2997, 7070, 9383, 9384, 3730, 9385, 9386, 317, 5023, 4583 ],
  ),
  "eyeglasses_2": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf2c7,
    categories: [ 3 ],
    tags: [ 733, 7985, 758, 9372, 9373, 9374, 9375, 2705, 276, 9376, 9377, 2149, 126, 9378, 971, 9379, 9387, 9380, 4536, 9381, 2506, 2507, 981, 1155, 9383, 9384, 2182, 9385, 9386, 317, 9388, 4583, 986 ],
  ),
  "face": SymbolsMetadata(
    popularity: 13098,
    codepoint: 0xe87c,
    categories: [ 3 ],
    tags: [ 755, 468, 1768, 470, 8702, 383, 2805, 1550, 1188, 479, 9389, 2808, 9390, 6220, 1190, 483, 2809, 850, 2674, 5126, 852, 903, 1361, 488, 489, 490, 9114, 3583, 889, 1723, 1011, 9391, 607, 858, 4492, 5717, 501, 4941 ],
  ),
  "face_2": SymbolsMetadata(
    popularity: 881,
    codepoint: 0xf8da,
    categories: [ 3 ],
    tags: [ 81, 3325, 468, 3211, 3212, 2148, 470, 2538, 384, 443, 194, 475, 88, 956, 1550, 1188, 479, 9392, 481, 4866, 1190, 482, 483, 2540, 850, 366, 2674, 5126, 852, 903, 853, 223, 423, 488, 489, 490, 3583, 1786, 1195, 1011, 607, 495, 6640, 8644, 551, 858, 315, 5717, 501 ],
  ),
  "face_3": SymbolsMetadata(
    popularity: 1209,
    codepoint: 0xf8db,
    categories: [ 3 ],
    tags: [ 468, 470, 9393, 6089, 383, 475, 4825, 1550, 9394, 1188, 479, 1790, 9395, 9396, 8851, 6220, 1190, 483, 16, 850, 885, 2674, 5126, 852, 903, 7792, 1804, 1361, 488, 489, 854, 490, 3583, 3331, 1011, 105, 607, 35, 441, 858, 5717, 501, 5011 ],
  ),
  "face_4": SymbolsMetadata(
    popularity: 1119,
    codepoint: 0xf8dc,
    categories: [ 3 ],
    tags: [ 468, 470, 9397, 383, 475, 9398, 9399, 1550, 1188, 479, 1790, 9400, 8851, 9401, 6220, 1190, 483, 850, 885, 8855, 2674, 5126, 852, 903, 853, 488, 489, 854, 490, 3583, 1786, 1011, 607, 858, 5717, 501, 5011, 9402 ],
  ),
  "face_5": SymbolsMetadata(
    popularity: 774,
    codepoint: 0xf8dd,
    categories: [ 3 ],
    tags: [ 3325, 468, 470, 9403, 9404, 383, 956, 3640, 1550, 1551, 1188, 479, 9405, 246, 6220, 1190, 483, 2540, 16, 2674, 5126, 852, 903, 9406, 3635, 488, 489, 490, 3583, 889, 9407, 1011, 105, 607, 35, 3636, 858, 5717, 501 ],
  ),
  "face_6": SymbolsMetadata(
    popularity: 1409,
    codepoint: 0xf8de,
    categories: [ 3 ],
    tags: [ 468, 6692, 470, 83, 9408, 383, 475, 9409, 1550, 9410, 9394, 1188, 479, 9411, 9412, 1190, 483, 16, 850, 2674, 5126, 852, 903, 1804, 1361, 488, 489, 854, 490, 3583, 889, 1011, 105, 607, 35, 858, 5717, 501, 860 ],
  ),
  "face_down": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf402,
    categories: [ 3 ],
    tags: [ 2650, 470, 9413, 388, 2651, 2840, 337, 2924, 1500, 1550, 2909, 1188, 479, 9414, 9415, 2735, 9416, 1190, 9417, 483, 1542, 966, 9418, 489, 9419, 854, 490, 9420, 1664, 1412, 501, 9421 ],
  ),
  "face_left": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf401,
    categories: [ 3 ],
    tags: [ 468, 380, 470, 2489, 1731, 383, 388, 1550, 1188, 479, 2735, 9416, 1190, 483, 850, 1375, 779, 421, 489, 790, 854, 2876, 490, 2495, 2496, 396, 65, 313, 441, 402, 2499, 501 ],
  ),
  "face_nod": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf400,
    categories: [ 3 ],
    tags: [ 1627, 2716, 3350, 9422, 1548, 7026, 2717, 1549, 419, 470, 9423, 383, 443, 1636, 4269, 388, 2450, 1550, 1188, 479, 2735, 9416, 1190, 483, 9424, 9425, 1643, 4750, 489, 490, 396, 9426, 402, 9427, 501, 1650 ],
  ),
  "face_retouching_off": SymbolsMetadata(
    popularity: 271,
    codepoint: 0xf007,
    categories: [ 1 ],
    tags: [ 9428, 9429, 9430, 9431, 9432, 9433, 767, 696, 2299, 9434, 9435, 2567, 1550, 1552, 898, 9436, 479, 9437, 9438, 9439, 9440, 9441, 9442, 53, 9443, 7484, 9444, 9445, 9446, 9447, 9448, 9449, 907, 909, 9450, 59, 9451, 61, 9452, 9453, 9454, 9455, 9456, 9457, 65, 914, 2384, 9458, 9459, 9460 ],
  ),
  "face_right": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf3ff,
    categories: [ 3 ],
    tags: [ 468, 775, 380, 470, 1731, 776, 388, 1550, 1188, 479, 9461, 2962, 777, 2735, 9416, 1190, 483, 778, 421, 780, 489, 781, 490, 28, 1396, 396, 2343, 1665, 313, 2007, 2571, 402, 501 ],
  ),
  "face_shake": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf3fe,
    categories: [ 3 ],
    tags: [ 264, 419, 470, 3005, 383, 4439, 8287, 388, 9462, 2722, 2450, 1550, 1552, 6699, 1188, 479, 2735, 9416, 1190, 2176, 483, 1858, 4152, 9463, 489, 490, 9464, 4450, 396, 8683, 9465, 501, 9466 ],
  ),
  "face_up": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf3fd,
    categories: [ 3 ],
    tags: [ 468, 9467, 380, 470, 194, 1540, 388, 1550, 1188, 479, 9468, 2735, 9416, 1190, 483, 850, 223, 489, 854, 490, 9114, 1665, 31, 1412, 1677, 346, 9469, 9470, 9471, 9472, 501, 9473 ],
  ),
  "fact_check": SymbolsMetadata(
    popularity: 8023,
    codepoint: 0xf0c5,
    categories: [ 12 ],
    tags: [ 1627, 6081, 1549, 2480, 1630, 1631, 1632, 1633, 1635, 1636, 2481, 2376, 1347, 1639, 9474, 9475, 9476, 9477, 1640, 3065, 1598, 366, 92, 1641, 1643, 1353, 1396, 288, 32, 1645, 1647, 6088, 6085, 9478, 2385, 2386, 2388, 1523, 1650 ],
  ),
  "factory": SymbolsMetadata(
    popularity: 3980,
    codepoint: 0xebbc,
    categories: [ 5 ],
    tags: [ 9479, 798, 5262, 2832, 9480, 7114, 9481, 9482, 6923, 9483, 9484, 9485, 6924, 9486, 6925, 9487, 9488, 7117, 1835, 3949, 6296, 9489, 9490, 5266, 9491, 3899, 3902 ],
  ),
  "falling": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf60d,
    categories: [ 3 ],
    tags: [ 3466, 949, 9492, 584, 1693, 9493, 3176, 9494, 2651, 9495, 9496, 9497, 9498, 9499, 9500, 483, 9501, 3201, 9502, 420, 1858, 488, 489, 9503, 9504, 750, 9505, 1591, 9506, 1261 ],
  ),
  "familiar_face_and_zone": SymbolsMetadata(
    popularity: 724,
    codepoint: 0xe21c,
    categories: [ 10 ],
    tags: [ 755, 989, 993, 8702, 3909, 2391, 2804, 2805, 479, 2808, 9390, 9507, 960, 1738, 274, 9508, 1190, 999, 2809, 2810, 1001, 1004, 489, 490, 3583, 1008, 1723, 2812, 980, 1011, 32, 36, 1071, 2165, 947, 501, 1013 ],
  ),
  "family_history": SymbolsMetadata(
    popularity: 126,
    codepoint: 0xe0ad,
    categories: [ 9 ],
    tags: [ 9509, 9510, 1994, 920, 865, 383, 921, 923, 924, 867, 9511, 925, 926, 928, 7077, 929, 595, 9512, 932, 1023, 933, 1064, 9513, 935, 1067, 223, 4240, 9514, 8006, 9515, 32, 945, 9516 ],
  ),
  "family_home": SymbolsMetadata(
    popularity: 201,
    codepoint: 0xeb26,
    categories: [ 8 ],
    tags: [ 2601, 798, 1433, 1434, 2605, 867, 9517, 9518, 9519, 4455, 9520, 999, 9521, 9522, 9523, 7191, 1435, 9524, 1436, 2608, 4768, 9525, 9526, 9527, 1495, 1444, 2614, 1445, 1446, 2616, 9528, 2617, 9529 ],
  ),
  "family_link": SymbolsMetadata(
    popularity: 292,
    codepoint: 0xeb19,
    categories: [ 15 ],
    tags: [ 989, 8002, 865, 194, 211, 1416, 867, 1918, 1973, 2819, 697, 930, 1064, 9530, 9531, 935, 223, 1860, 4240, 2162, 3347, 8006, 1421, 1665, 3058, 9532, 495, 9533, 8264, 8265, 1863 ],
  ),
  "family_restroom": SymbolsMetadata(
    popularity: 2284,
    codepoint: 0xf1a2,
    categories: [ 16 ],
    tags: [ 733, 734, 9534, 1868, 862, 865, 867, 9535, 3605, 591, 1791, 9536, 930, 483, 760, 871, 1001, 9537, 3607, 421, 9538, 4240, 488, 2071, 3610, 9539, 499, 1885, 9540, 3613, 8858 ],
  ),
  "family_star": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf527,
    categories: [ 3 ],
    tags: [ 468, 8266, 3575, 1670, 862, 865, 9541, 194, 1550, 479, 867, 3578, 2819, 930, 1558, 3019, 999, 1251, 6157, 870, 871, 8261, 1213, 285, 490, 3582, 286, 102, 8006, 1664, 65, 1567, 3264, 946 ],
  ),
  "fan_focus": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf334,
    categories: [ 14 ],
    tags: [ 705, 1128, 709, 5689, 1846, 380, 419, 1814, 3467, 1815, 712, 9542, 269, 3088, 718, 388, 2651, 2924, 719, 9543, 1738, 6834, 1363, 310, 9544, 9545, 727, 9546, 9547, 1844, 730, 986 ],
  ),
  "fan_indirect": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf333,
    categories: [ 14 ],
    tags: [ 709, 9548, 1846, 380, 419, 1847, 1814, 3467, 9549, 1850, 1815, 2348, 713, 716, 269, 718, 9550, 388, 9551, 2173, 9552, 1890, 719, 926, 723, 2001, 5481, 65, 2438, 2057, 727, 9546, 1844, 730, 731, 1863 ],
  ),
  "farsight_digital": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf559,
    categories: [ 10 ],
    tags: [ 111, 9553, 1015, 383, 712, 1016, 2092, 88, 9554, 9555, 9556, 12, 1020, 9557, 6407, 999, 2095, 597, 2096, 1004, 24, 94, 3948, 1030, 889, 1031, 103, 3549, 729, 9558, 289, 1033, 123, 2102 ],
  ),
  "fast_forward": SymbolsMetadata(
    popularity: 3234,
    codepoint: 0xe01f,
    categories: [ 0 ],
    tags: [ 775, 380, 1129, 269, 785, 2450, 9559, 1022, 8453, 9560, 777, 9561, 367, 2081, 421, 780, 2162, 2904, 1152, 1027, 1028, 7536, 2966, 9562, 231, 289, 1701, 344, 9563, 41 ],
  ),
  "fast_rewind": SymbolsMetadata(
    popularity: 1628,
    codepoint: 0xe020,
    categories: [ 0 ],
    tags: [ 380, 9564, 2489, 2870, 84, 269, 9559, 1022, 9565, 367, 2903, 326, 2081, 9566, 421, 2162, 1152, 2876, 1027, 3515, 3516, 2495, 2881, 2886, 9567, 231, 108, 289, 1701, 344, 9563, 2499, 41, 291 ],
  ),
  "fastfood": SymbolsMetadata(
    popularity: 2682,
    codepoint: 0xe57a,
    categories: [ 5 ],
    tags: [ 4381, 9568, 3792, 9569, 9570, 6609, 8085, 4275, 4388, 3800, 7128, 9571, 9572, 1829, 5153, 2986, 3803, 1490, 3804, 2613, 9573, 3807, 4978, 3809, 9574, 9575, 9576, 4283, 4284 ],
  ),
  "faucet": SymbolsMetadata(
    popularity: 421,
    codepoint: 0xe278,
    categories: [ 8 ],
    tags: [ 1888, 4004, 1868, 1871, 4005, 1269, 2332, 6626, 3990, 926, 3489, 999, 1435, 3972, 3802, 2797, 1004, 4370, 9577, 2800, 3610, 9578, 2631, 3999, 9579, 4008, 6367, 4001, 9580, 3986, 2801 ],
  ),
  "favorite": SymbolsMetadata(
    popularity: 76639,
    codepoint: 0xe87d,
    categories: [ 2 ],
    tags: [ 4762, 9581, 4763, 4764, 1670, 9582, 187, 3578, 9583, 4455, 9584, 1560, 4768, 2379, 285, 329, 4270, 9585, 9586, 4772, 1664, 311, 31, 4793, 9587, 9588, 4795, 4775, 9589, 4776, 4748 ],
  ),
  "fax": SymbolsMetadata(
    popularity: 1397,
    codepoint: 0xead8,
    categories: [ 11 ],
    tags: [ 1284, 952, 443, 7797, 445, 12, 1347, 3216, 1712, 1713, 1309, 970, 9590, 1717, 1456, 8845, 9591, 226, 1721, 2342, 9592, 701, 1724, 330, 2343, 9593, 551, 1320, 5086 ],
  ),
  "feature_search": SymbolsMetadata(
    popularity: 208,
    codepoint: 0xe9a9,
    categories: [ 6 ],
    tags: [ 2513, 3351, 7, 9594, 132, 955, 9595, 958, 529, 959, 960, 964, 135, 4294, 967, 1620, 1489, 971, 972, 973, 974, 975, 976, 1622, 1444, 980, 981, 7536, 2631, 32, 986 ],
  ),
  "featured_play_list": SymbolsMetadata(
    popularity: 677,
    codepoint: 0xe06d,
    categories: [ 0 ],
    tags: [ 1538, 1129, 2155, 3337, 4798, 9596, 2080, 1066, 2159, 366, 92, 367, 788, 328, 2081, 656, 2162, 2163, 2648, 100, 8823, 75, 77, 371, 2164, 1156, 32, 107, 2165, 41 ],
    rtlAutoMirrored: true,
  ),
  "featured_seasonal_and_gifts": SymbolsMetadata(
    popularity: 597,
    codepoint: 0xef91,
    categories: [ 15 ],
    tags: [ 8994, 5302, 9597, 9598, 7, 5149, 5600, 5750, 1329, 4798, 5941, 9599, 9600, 9601, 6155, 2018, 9193, 2742, 6995, 2647, 5591, 3581, 1050, 3584, 2368, 9602, 841, 3586, 9603, 732 ],
  ),
  "featured_video": SymbolsMetadata(
    popularity: 468,
    codepoint: 0xe06e,
    categories: [ 0 ],
    tags: [ 9604, 1037, 267, 1469, 12, 3337, 4798, 9605, 270, 1738, 274, 3019, 9596, 1251, 7498, 367, 278, 328, 2162, 5208, 1518, 1050, 8823, 75, 330, 371, 2997, 9606, 32, 3264, 41, 2102, 1054 ],
    rtlAutoMirrored: true,
  ),
  "feedback": SymbolsMetadata(
    popularity: 1174,
    codepoint: 0xe87f,
    categories: [ 6 ],
    tags: [ 3175, 469, 1245, 3073, 471, 1693, 472, 1401, 473, 474, 443, 476, 3176, 9607, 2766, 2767, 3177, 9156, 9608, 2768, 480, 1251, 851, 135, 2769, 1641, 485, 486, 2772, 1353, 9609, 2631, 1121, 493, 494, 553, 35, 38, 9610, 1261 ],
  ),
  "female": SymbolsMetadata(
    popularity: 2269,
    codepoint: 0xe590,
    categories: [ 3 ],
    tags: [ 468, 470, 9611, 383, 1202, 9398, 1790, 9612, 9613, 1791, 1795, 8851, 850, 9614, 8855, 3982, 489, 202, 490, 3610, 9615, 607, 35, 501, 9616, 9617, 3613, 5011, 8858, 9618 ],
  ),
  "femur": SymbolsMetadata(
    popularity: 171,
    codepoint: 0xf891,
    categories: [ 3 ],
    tags: [ 3919, 5177, 2412, 584, 9619, 4289, 9620, 9621, 9622, 9623, 9624, 9625, 9626, 9627, 9628, 595, 9629, 4635, 9630, 9631, 1955, 9632, 1757, 9633, 9634, 7365, 9635, 9636, 9637, 5319 ],
  ),
  "femur_alt": SymbolsMetadata(
    popularity: 163,
    codepoint: 0xf892,
    categories: [ 3 ],
    tags: [ 3919, 2412, 584, 4289, 9638, 9639, 9622, 2136, 9625, 9626, 9640, 9628, 595, 9629, 4635, 3201, 9630, 9631, 1955, 9632, 1757, 9633, 9641, 1723, 9642, 9636, 9643, 9637, 9644 ],
  ),
  "fence": SymbolsMetadata(
    popularity: 374,
    codepoint: 0xf1f6,
    categories: [ 8 ],
    tags: [ 755, 7654, 9645, 349, 9646, 994, 9647, 1370, 2604, 5251, 6104, 9648, 7630, 6816, 6105, 9649, 999, 1435, 9650, 1859, 9292, 1004, 1696, 1860, 3841, 9651, 8445, 1006, 9652, 1517, 1444, 1520, 3310, 1011, 2264, 9653, 9654, 5020, 7642 ],
  ),
  "fertile": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf6e5,
    categories: [ 15 ],
    tags: [ 1812, 84, 6886, 4463, 7622, 7623, 9655, 9656, 6188, 385, 7986, 1890, 1825, 1790, 9657, 2926, 2433, 6816, 6817, 196, 595, 5603, 9658, 9659, 1859, 8834, 9660, 9661, 1835, 9662, 9663, 2439, 6825, 441, 7641, 9664 ],
  ),
  "festival": SymbolsMetadata(
    popularity: 888,
    codepoint: 0xea68,
    categories: [ 16 ],
    tags: [ 3332, 9665, 6228, 3336, 5149, 9666, 194, 4711, 8259, 3337, 2094, 3338, 3341, 2819, 6278, 2018, 6868, 1490, 1291, 9667, 2081, 1860, 487, 9668, 189, 2613, 3347, 6705, 9669, 5578, 6709, 9670, 1504, 2024 ],
  ),
  "fiber_dvr": SymbolsMetadata(
    popularity: 170,
    codepoint: 0xe05d,
    categories: [ 0 ],
    tags: [ 186, 4, 1180, 1888, 7, 4362, 8, 88, 8595, 8596, 1711, 9671, 14, 19, 9672, 223, 1082, 9673, 2648, 9674, 1318, 121, 9675, 1154, 177, 3515, 77, 6314, 1031, 9676, 32, 9677, 35, 343, 38, 9678, 344, 40, 41, 1690 ],
  ),
  "fiber_manual_record": SymbolsMetadata(
    popularity: 3852,
    codepoint: 0xe061,
    categories: [ 0 ],
    tags: [ 1242, 9679, 116, 383, 832, 9671, 9680, 9681, 901, 188, 7921, 367, 6466, 907, 909, 1082, 2162, 283, 9682, 121, 5489, 177, 1257, 227, 108, 5545, 553, 1083, 5546, 314, 9683, 9684, 2102 ],
  ),
  "fiber_new": SymbolsMetadata(
    popularity: 1033,
    codepoint: 0xe05e,
    categories: [ 0 ],
    tags: [ 469, 4, 1245, 2014, 6, 7, 8, 1042, 529, 9671, 14, 274, 3019, 135, 18, 9685, 19, 223, 763, 2503, 486, 2742, 1622, 1050, 1029, 75, 3068, 77, 35, 2384, 38, 40, 1260, 5144, 9686 ],
  ),
  "fiber_pin": SymbolsMetadata(
    popularity: 197,
    codepoint: 0xe06a,
    categories: [ 0 ],
    tags: [ 4, 2520, 1058, 1670, 8, 1484, 2522, 9671, 2525, 14, 1488, 3019, 1251, 18, 19, 1001, 1002, 1641, 21, 421, 223, 1532, 1493, 1495, 1363, 1496, 9687, 1030, 1664, 1773, 3493, 35, 9688, 2384, 36, 38, 9689, 40 ],
  ),
  "fiber_smart_record": SymbolsMetadata(
    popularity: 256,
    codepoint: 0xe062,
    categories: [ 0 ],
    tags: [ 2827, 1132, 2148, 355, 116, 383, 953, 2566, 211, 832, 9690, 9671, 3053, 1897, 390, 367, 6466, 9691, 1082, 2162, 121, 177, 227, 1155, 1901, 9692, 9693, 108, 1083, 342, 2102 ],
  ),
  "file_copy": SymbolsMetadata(
    popularity: 5032,
    codepoint: 0xe173,
    categories: [ 12 ],
    tags: [ 3753, 1042, 6998, 4778, 1707, 9694, 9695, 9696, 1062, 5807, 1528, 1347, 9697, 9698, 2999, 9699, 1530, 9700, 9701, 4781, 2557, 4915, 1534, 9702, 2841, 5482, 7001, 107, 1069, 8057, 9703 ],
  ),
  "file_copy_off": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf4d8,
    categories: [ 12 ],
    tags: [ 1074, 895, 9704, 1042, 1707, 9705, 5807, 897, 1077, 9706, 767, 1528, 1347, 9707, 2999, 898, 1530, 9700, 9708, 899, 2557, 4152, 9709, 9710, 8305, 907, 908, 909, 2841, 5594, 9711, 911, 9712, 3310, 914, 107, 1083, 9713 ],
  ),
  "file_download_off": SymbolsMetadata(
    popularity: 744,
    codepoint: 0xe4fe,
    categories: [ 2 ],
    tags: [ 380, 2650, 9714, 894, 9715, 4563, 767, 2651, 337, 9716, 1654, 898, 1672, 9717, 1530, 8465, 9718, 899, 9719, 9720, 1674, 7067, 9721, 9722, 9723, 907, 908, 909, 9724, 9725, 9726, 1664, 9727, 914, 9728, 9729, 915, 346 ],
  ),
  "file_export": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xf3b2,
    categories: [ 2 ],
    tags: [ 380, 7, 1707, 1062, 2173, 1528, 1347, 337, 1654, 1672, 2628, 6243, 1530, 777, 2652, 1542, 935, 778, 2653, 2398, 4187, 1534, 1535, 2504, 3068, 2844, 1396, 3046, 1664, 2343, 1665, 32, 441, 2007, 346 ],
  ),
  "file_json": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf3bb,
    categories: [ 2 ],
    tags: [ 1230, 3638, 8, 2624, 268, 10, 7383, 2625, 1347, 337, 2627, 1530, 3540, 14, 1372, 2551, 305, 9730, 6586, 7517, 9731, 4704, 19, 422, 2653, 2630, 75, 77, 1664, 3379, 65, 1196, 32, 674, 35, 38, 2007, 40, 346, 1691 ],
  ),
  "file_map": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xe2c5,
    categories: [ 5 ],
    tags: [ 1429, 2151, 10, 1578, 1347, 337, 1530, 9732, 1486, 1487, 1488, 135, 1001, 9733, 1002, 9734, 1641, 21, 421, 1493, 1494, 1495, 1783, 1496, 1503, 1664, 5780, 32, 674, 1504, 346 ],
  ),
  "file_map_stack": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf3e2,
    categories: [ 5 ],
    tags: [ 2151, 9735, 9736, 2155, 10, 6936, 1347, 1530, 1655, 2469, 9737, 1487, 1488, 930, 135, 1066, 92, 1001, 1002, 1641, 21, 2557, 421, 1081, 1493, 1495, 2613, 1783, 1496, 5780, 32, 107, 1069, 674 ],
  ),
  "file_open": SymbolsMetadata(
    popularity: 4148,
    codepoint: 0xeaf3,
    categories: [ 2 ],
    tags: [ 755, 526, 380, 5123, 9738, 1042, 1062, 10, 1528, 1347, 1654, 958, 1530, 4781, 1656, 1542, 135, 966, 1044, 1375, 3513, 2653, 9739, 1534, 1535, 2506, 2844, 9740, 1677, 346, 317 ],
  ),
  "file_png": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf3bc,
    categories: [ 1 ],
    tags: [ 1466, 9741, 7, 8, 88, 1347, 337, 1672, 1530, 7385, 14, 1372, 2551, 305, 16, 53, 9742, 1542, 9730, 4704, 19, 9743, 367, 119, 9744, 9745, 4582, 75, 77, 1664, 32, 35, 38, 40, 346 ],
  ),
  "file_present": SymbolsMetadata(
    popularity: 1510,
    codepoint: 0xea0e,
    categories: [ 12 ],
    tags: [ 755, 2151, 1058, 3063, 1469, 1042, 10, 9746, 1528, 1347, 337, 1654, 9747, 1672, 1530, 9748, 1656, 1657, 6126, 9749, 1542, 135, 935, 9750, 1532, 2653, 1534, 1535, 5591, 75, 1030, 1664, 1665, 4786, 4787, 32, 674, 9751, 346, 317, 704 ],
  ),
  "file_save": SymbolsMetadata(
    popularity: 108,
    codepoint: 0xf17f,
    categories: [ 12 ],
    tags: [ 2151, 380, 2650, 1651, 1042, 10, 2157, 1528, 1347, 2651, 2840, 337, 9752, 1654, 1672, 1530, 8465, 9753, 9754, 1656, 1657, 1542, 135, 8485, 1534, 1535, 9755, 121, 1664, 9756, 4786, 4787, 674, 1298, 2007, 1536, 704 ],
  ),
  "file_save_off": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe505,
    categories: [ 12 ],
    tags: [ 380, 1074, 895, 6004, 1202, 10, 2969, 767, 2157, 1528, 1347, 2651, 337, 1654, 898, 1530, 9757, 9754, 1656, 1657, 899, 901, 8485, 1602, 7534, 9758, 907, 909, 599, 4448, 1519, 171, 1664, 4786, 914, 4787, 1083, 674, 915, 4795, 704, 3736 ],
  ),
  "file_upload_off": SymbolsMetadata(
    popularity: 385,
    codepoint: 0xf886,
    categories: [ 2 ],
    tags: [ 380, 2052, 419, 9759, 9760, 7, 9761, 9762, 1653, 9763, 9764, 9765, 9766, 9767, 9768, 9769, 767, 1347, 337, 1654, 898, 1672, 1530, 6550, 9770, 9771, 9772, 9773, 1542, 9774, 9720, 9775, 9776, 9777, 9778, 907, 908, 909, 2343, 9779, 9780, 914, 2007, 9729, 9781, 1676, 346, 6546, 9782 ],
  ),
  "files": SymbolsMetadata(
    popularity: 558,
    codepoint: 0xea85,
    categories: [ 12 ],
    tags: [ 755, 2151, 5123, 2155, 1042, 10, 6936, 1528, 1347, 337, 1654, 958, 1530, 4781, 1655, 1656, 930, 135, 1065, 2159, 92, 2557, 2653, 98, 4915, 1534, 1535, 2843, 1664, 4786, 4787, 107, 674, 2007, 346, 317 ],
  ),
  "filter": SymbolsMetadata(
    popularity: 632,
    codepoint: 0xe3d3,
    categories: [ 1 ],
    tags: [ 1538, 1367, 5797, 1042, 696, 2299, 2567, 959, 1541, 930, 53, 5799, 1543, 1066, 2159, 1755, 367, 1544, 1545, 2557, 98, 4915, 59, 61, 5800, 119, 5801, 2493, 288, 371, 65, 106, 32, 107, 317 ],
  ),
  "filter_1": SymbolsMetadata(
    popularity: 665,
    codepoint: 0xe3d0,
    categories: [ 1 ],
    tags: [ 79, 3751, 1062, 6676, 1735, 11, 696, 2299, 2567, 959, 9783, 90, 53, 5799, 5206, 7005, 7181, 3759, 2557, 23, 9784, 24, 3542, 656, 61, 119, 5801, 329, 5208, 2493, 1742, 288, 371, 2264, 604, 65, 7198, 106, 9785, 32, 107, 35 ],
  ),
  "filter_2": SymbolsMetadata(
    popularity: 355,
    codepoint: 0xe3d1,
    categories: [ 1 ],
    tags: [ 81, 1367, 1707, 6873, 11, 3108, 6788, 2999, 696, 2299, 2567, 959, 9786, 9787, 9788, 53, 5799, 9789, 1066, 2557, 9790, 23, 7200, 24, 656, 98, 4915, 9791, 61, 119, 5801, 2493, 9792, 103, 371, 65, 106, 107, 9793, 35, 315, 9794 ],
  ),
  "filter_3": SymbolsMetadata(
    popularity: 313,
    codepoint: 0xe3d2,
    categories: [ 1 ],
    tags: [ 82, 2170, 6873, 11, 12, 696, 2299, 2567, 959, 53, 5799, 1066, 459, 92, 2557, 6834, 23, 24, 656, 96, 98, 4915, 61, 119, 5801, 329, 99, 100, 2493, 2851, 330, 288, 371, 65, 9795, 106, 107, 35, 110, 374, 317 ],
  ),
  "filter_4": SymbolsMetadata(
    popularity: 319,
    codepoint: 0xe3d4,
    categories: [ 1 ],
    tags: [ 534, 2170, 3095, 785, 6873, 1735, 11, 12, 696, 2299, 2567, 959, 9796, 538, 9797, 53, 5799, 1066, 459, 2557, 9790, 6834, 24, 656, 98, 2559, 9791, 61, 119, 5801, 329, 2493, 9798, 2851, 371, 65, 9795, 106, 32, 107, 35, 317 ],
  ),
  "filter_5": SymbolsMetadata(
    popularity: 236,
    codepoint: 0xe3d5,
    categories: [ 1 ],
    tags: [ 564, 1367, 3095, 6873, 1735, 11, 696, 2299, 2567, 959, 9799, 4707, 932, 53, 5799, 1066, 459, 92, 2557, 23, 9800, 24, 656, 98, 4915, 61, 119, 5801, 329, 2493, 171, 2851, 980, 288, 371, 65, 106, 32, 107, 35 ],
  ),
  "filter_6": SymbolsMetadata(
    popularity: 181,
    codepoint: 0xe3d6,
    categories: [ 1 ],
    tags: [ 580, 1367, 6, 3095, 6873, 1735, 11, 696, 2299, 2567, 6243, 959, 9801, 53, 5799, 7005, 1066, 459, 2557, 23, 9802, 24, 656, 4915, 5921, 61, 119, 5801, 329, 2493, 171, 288, 371, 2264, 65, 7207, 106, 32, 107, 35 ],
  ),
  "filter_7": SymbolsMetadata(
    popularity: 232,
    codepoint: 0xe3d7,
    categories: [ 1 ],
    tags: [ 636, 6, 7, 3751, 1062, 9, 6873, 11, 696, 2299, 2567, 959, 53, 5799, 7005, 1066, 459, 2557, 6834, 23, 24, 656, 4915, 61, 119, 5801, 329, 2493, 2851, 980, 288, 371, 65, 641, 106, 32, 107, 35 ],
  ),
  "filter_8": SymbolsMetadata(
    popularity: 203,
    codepoint: 0xe3d8,
    categories: [ 1 ],
    tags: [ 658, 2170, 268, 6873, 1735, 11, 696, 2299, 2567, 661, 6243, 959, 53, 5799, 7005, 1066, 459, 2557, 23, 9803, 24, 656, 98, 4915, 61, 119, 5801, 329, 2493, 171, 330, 288, 2264, 65, 9795, 106, 32, 107, 35 ],
  ),
  "filter_9": SymbolsMetadata(
    popularity: 191,
    codepoint: 0xe3d9,
    categories: [ 1 ],
    tags: [ 677, 1367, 7, 3095, 785, 9, 6873, 11, 12, 696, 2299, 2567, 959, 53, 5799, 1066, 459, 2557, 682, 23, 24, 656, 98, 4915, 1081, 61, 119, 5801, 329, 2493, 3310, 2851, 371, 2264, 65, 106, 32, 107, 35, 317 ],
  ),
  "filter_9_plus": SymbolsMetadata(
    popularity: 210,
    codepoint: 0xe3da,
    categories: [ 1 ],
    tags: [ 192, 677, 9804, 9805, 9806, 9807, 158, 1074, 9808, 9809, 159, 1062, 11, 696, 2299, 2567, 9810, 959, 53, 5799, 9811, 9812, 1066, 459, 9813, 2557, 9814, 9815, 24, 9816, 875, 169, 61, 119, 5801, 202, 171, 9817, 330, 65, 32, 107, 1069, 35, 878 ],
  ),
  "filter_alt": SymbolsMetadata(
    popularity: 16805,
    codepoint: 0xef4f,
    categories: [ 2 ],
    tags: [ 1367, 266, 9809, 1735, 9818, 696, 6243, 959, 9819, 9820, 7085, 9821, 9822, 6834, 656, 98, 329, 2493, 1742, 9823, 9824, 288, 371, 2264, 65, 9795, 106, 9825, 441, 1701 ],
  ),
  "filter_alt_off": SymbolsMetadata(
    popularity: 2320,
    codepoint: 0xeb32,
    categories: [ 2 ],
    tags: [ 1499, 894, 895, 9432, 9826, 9827, 9828, 9829, 767, 696, 959, 9830, 9441, 7085, 9831, 7094, 9448, 9832, 9833, 9834, 9835, 907, 908, 656, 9836, 9837, 2493, 9838, 9839, 9840, 9841, 9842, 9843, 9844, 9795, 914, 106, 9845, 9846 ],
  ),
  "filter_arrow_right": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf3d1,
    categories: [ 2 ],
    tags: [ 775, 2687, 9847, 380, 9848, 776, 388, 696, 959, 9849, 9850, 9820, 926, 777, 7085, 9851, 2910, 778, 2990, 421, 780, 656, 781, 942, 2493, 1396, 288, 9795, 106, 1412, 1701 ],
    rtlAutoMirrored: true,
  ),
  "filter_b_and_w": SymbolsMetadata(
    popularity: 259,
    codepoint: 0xe3db,
    categories: [ 1 ],
    tags: [ 3325, 1128, 8994, 689, 9852, 7045, 9853, 1734, 269, 1735, 1370, 696, 2299, 2567, 959, 9854, 960, 7085, 1659, 7047, 53, 5799, 9855, 6834, 656, 61, 119, 5801, 329, 75, 2493, 9798, 980, 371, 2264, 65, 106, 1378, 32, 1701, 9856, 7052 ],
  ),
  "filter_center_focus": SymbolsMetadata(
    popularity: 901,
    codepoint: 0xe3dc,
    categories: [ 1 ],
    tags: [ 5957, 2169, 3909, 1775, 47, 1730, 5960, 3085, 383, 9542, 2391, 2200, 832, 696, 959, 960, 1738, 274, 53, 1489, 421, 59, 61, 119, 1494, 1363, 1496, 2493, 1010, 330, 980, 371, 32, 36, 317, 986 ],
  ),
  "filter_drama": SymbolsMetadata(
    popularity: 1120,
    codepoint: 0xe3dd,
    categories: [ 1 ],
    tags: [ 1847, 5917, 1652, 3739, 6503, 9857, 3741, 6694, 9858, 10, 6505, 7562, 3744, 6697, 9859, 696, 2299, 2567, 959, 9820, 6392, 53, 1857, 656, 98, 59, 61, 119, 329, 2493, 371, 65, 9860, 106, 9861, 9862, 731 ],
  ),
  "filter_frames": SymbolsMetadata(
    popularity: 279,
    codepoint: 0xe3de,
    categories: [ 1 ],
    tags: [ 1128, 380, 9863, 349, 47, 1730, 9858, 1735, 696, 2299, 2567, 959, 9864, 9865, 7056, 1738, 274, 276, 53, 4534, 3145, 4554, 1066, 9866, 1740, 938, 8026, 656, 98, 59, 3422, 4557, 61, 119, 2493, 371, 65, 106, 32, 107, 1701, 1677, 364, 9867 ],
  ),
  "filter_hdr": SymbolsMetadata(
    popularity: 490,
    codepoint: 0xe3df,
    categories: [ 1 ],
    tags: [ 3325, 1128, 5060, 47, 12, 696, 2299, 2567, 528, 959, 1659, 9868, 9869, 53, 530, 1543, 1544, 1545, 1859, 656, 1081, 2474, 59, 61, 119, 62, 2493, 1546, 65, 1701, 5495, 41, 317 ],
  ),
  "filter_list": SymbolsMetadata(
    popularity: 13976,
    codepoint: 0xe152,
    categories: [ 2 ],
    tags: [ 1367, 365, 269, 6873, 1735, 12, 2941, 959, 9870, 7085, 2080, 1066, 366, 92, 788, 656, 98, 9791, 329, 2493, 2851, 371, 2264, 65, 9795, 106, 107, 441, 314, 317 ],
  ),
  "filter_list_off": SymbolsMetadata(
    popularity: 1094,
    codepoint: 0xeb57,
    categories: [ 2 ],
    tags: [ 1499, 895, 9871, 9872, 4563, 9432, 9826, 767, 696, 959, 9873, 9830, 9441, 9874, 7085, 9875, 9831, 7094, 9876, 9877, 9878, 366, 92, 9448, 9832, 907, 908, 656, 2493, 9839, 9840, 9841, 9795, 914, 106, 9846, 441 ],
  ),
  "filter_none": SymbolsMetadata(
    popularity: 1148,
    codepoint: 0xe3e0,
    categories: [ 1 ],
    tags: [ 2325, 378, 1367, 3751, 3095, 3436, 9871, 785, 1062, 9879, 2352, 959, 9880, 3759, 1066, 2557, 9448, 9881, 7195, 656, 4915, 329, 911, 9840, 426, 9882, 65, 3099, 9785, 32, 107 ],
  ),
  "filter_retrolux": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xe3e1,
    categories: [ 1 ],
    tags: [ 3325, 989, 1128, 1229, 1230, 383, 269, 1735, 1416, 696, 2299, 1371, 3327, 959, 697, 1659, 3328, 16, 53, 9530, 9531, 390, 9883, 1740, 656, 59, 329, 2648, 2493, 701, 9884, 1421, 1423, 371, 65, 1196, 106, 32, 35, 2537, 703 ],
  ),
  "filter_tilt_shift": SymbolsMetadata(
    popularity: 351,
    codepoint: 0xe3e2,
    categories: [ 1 ],
    tags: [ 1128, 5487, 4528, 47, 1730, 383, 384, 269, 2448, 2449, 9885, 9886, 956, 696, 2299, 2567, 959, 1738, 53, 3145, 4554, 5799, 126, 9887, 9888, 656, 3422, 4557, 61, 119, 5801, 5039, 889, 3424, 310, 3036, 36, 9889, 9890, 9891, 9892 ],
  ),
  "filter_vintage": SymbolsMetadata(
    popularity: 1405,
    codepoint: 0xe3e3,
    categories: [ 1 ],
    tags: [ 3325, 1128, 2170, 7622, 7623, 953, 1735, 9893, 696, 2299, 2567, 959, 8973, 2433, 1659, 53, 5799, 1740, 1859, 656, 98, 9894, 9895, 61, 119, 5801, 329, 2493, 889, 330, 371, 2264, 65, 9896, 106, 2439, 703 ],
  ),
  "finance": SymbolsMetadata(
    popularity: 205,
    codepoint: 0xe6bf,
    categories: [ 9 ],
    tags: [ 3313, 2513, 5, 9897, 1343, 1344, 1345, 365, 828, 1284, 920, 10, 924, 808, 929, 196, 933, 815, 1291, 597, 937, 189, 28, 1353, 1354, 9898, 3857, 33, 5619, 9899, 947, 2852, 3858, 2253, 1355 ],
  ),
  "finance_chip": SymbolsMetadata(
    popularity: 190,
    codepoint: 0xf84e,
    categories: [ 12 ],
    tags: [ 796, 5843, 797, 828, 800, 5846, 5250, 801, 803, 805, 806, 3315, 807, 3317, 834, 808, 811, 5855, 3320, 815, 818, 5185, 820, 821, 9900, 9901, 1337, 77, 824, 9902, 842, 3323, 5864, 3324 ],
  ),
  "finance_mode": SymbolsMetadata(
    popularity: 283,
    codepoint: 0xef92,
    categories: [ 9 ],
    tags: [ 3313, 5, 380, 365, 1284, 920, 10, 7448, 808, 9903, 9904, 929, 196, 1207, 815, 2518, 1291, 189, 28, 1354, 9898, 3857, 33, 5619, 2852, 1677, 7528 ],
  ),
  "find_in_page": SymbolsMetadata(
    popularity: 2408,
    codepoint: 0xe880,
    categories: [ 12 ],
    tags: [ 383, 1042, 10, 955, 1528, 1347, 8371, 1654, 958, 9905, 1530, 960, 9906, 9907, 9908, 1656, 1657, 964, 3091, 4294, 1489, 971, 973, 974, 975, 976, 1534, 9909, 1535, 2506, 75, 980, 9910, 8381, 9911, 981, 4786, 4787, 32, 38, 317, 704, 986 ],
  ),
  "find_replace": SymbolsMetadata(
    popularity: 886,
    codepoint: 0xe881,
    categories: [ 6 ],
    tags: [ 2284, 380, 419, 1731, 383, 2490, 385, 696, 2627, 960, 9912, 964, 7057, 3524, 3513, 3525, 971, 390, 973, 974, 975, 976, 1740, 2492, 424, 2494, 2367, 3662, 396, 980, 9913, 7605, 981, 5256, 313, 2007, 2455, 2499, 1260 ],
  ),
  "fingerprint": SymbolsMetadata(
    popularity: 9409,
    codepoint: 0xe90d,
    categories: [ 6 ],
    tags: [ 755, 1768, 1769, 8702, 1852, 9914, 9915, 3167, 2809, 850, 366, 852, 9916, 1721, 1516, 1520, 3908, 9917, 1723, 1773, 1011, 122, 1861, 9918, 8035, 9919, 5717, 2388, 9920 ],
  ),
  "fingerprint_off": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf49d,
    categories: [ 6 ],
    tags: [ 755, 1768, 1769, 8702, 9921, 9922, 9923, 895, 1852, 4440, 9924, 767, 898, 9914, 9915, 9925, 9926, 9927, 9928, 3167, 2809, 850, 366, 2674, 852, 9929, 907, 908, 909, 1721, 3908, 9930, 1723, 1011, 914, 1083, 9918, 9919, 9931, 5717, 2388 ],
  ),
  "fire_extinguisher": SymbolsMetadata(
    popularity: 471,
    codepoint: 0xf1d8,
    categories: [ 8 ],
    tags: [ 9932, 9933, 7572, 2482, 9934, 9935, 5601, 9936, 9937, 9938, 9939, 9940, 4472, 5311, 4647, 9941, 16, 9942, 9943, 599, 1520, 9944, 9945, 602, 9946, 6603, 9947, 35, 9948, 2801, 9949 ],
  ),
  "fire_hydrant": SymbolsMetadata(
    popularity: 356,
    codepoint: 0xf1a3,
    categories: [ 5 ],
    tags: [ 6931, 1244, 2602, 3176, 5929, 2482, 2523, 5601, 9950, 9951, 9940, 9952, 5311, 9941, 3078, 9953, 16, 5073, 1001, 1002, 9954, 421, 599, 1520, 2071, 9945, 602, 2631, 1589, 35, 2621, 6367, 2801 ],
  ),
  "fire_truck": SymbolsMetadata(
    popularity: 711,
    codepoint: 0xf8f2,
    categories: [ 5 ],
    tags: [ 6931, 3466, 469, 738, 9955, 3176, 2482, 9956, 4613, 5601, 9957, 9958, 9951, 9959, 9960, 8614, 9961, 482, 9962, 9963, 9954, 9945, 2631, 2485, 1842, 1930, 1843, 1844, 1261 ],
    rtlAutoMirrored: true,
  ),
  "fireplace": SymbolsMetadata(
    popularity: 770,
    codepoint: 0xea43,
    categories: [ 8 ],
    tags: [ 798, 9964, 5262, 5600, 1914, 9965, 9966, 5601, 9967, 5311, 1964, 9968, 3076, 2018, 999, 7468, 3078, 1435, 9969, 2793, 2796, 5981, 5982, 9970, 1495, 1959, 1960, 32, 5610, 727, 3978, 3083, 732, 9971 ],
  ),
  "first_page": SymbolsMetadata(
    popularity: 2745,
    codepoint: 0xe5dc,
    categories: [ 2 ],
    tags: [ 9972, 380, 2489, 84, 1910, 2862, 269, 1347, 9973, 90, 9974, 9975, 5206, 9976, 1375, 2875, 2903, 421, 1534, 9977, 9978, 2876, 2878, 3516, 2495, 2886, 108, 1124, 1214, 1215, 9979 ],
  ),
  "fit_page": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf77a,
    categories: [ 12 ],
    tags: [ 1128, 2301, 1042, 2448, 2449, 12, 1347, 1579, 1216, 9980, 2242, 9981, 9982, 9983, 2393, 2273, 1372, 9984, 2395, 2470, 9985, 306, 9986, 2227, 2930, 2247, 2281, 9987, 330, 9988, 673, 944, 441, 1214, 9989, 317, 3014, 986, 9990 ],
  ),
  "fit_page_height": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf397,
    categories: [ 12 ],
    tags: [ 1128, 419, 2301, 1042, 12, 1347, 2450, 2651, 2840, 1216, 787, 9991, 9981, 9982, 9983, 1372, 274, 2243, 2470, 53, 1534, 9992, 75, 2247, 2281, 2933, 9993, 38, 2455, 1676, 1677, 9989, 317, 1054, 986 ],
  ),
  "fit_page_width": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf396,
    categories: [ 12 ],
    tags: [ 1128, 419, 1042, 2919, 12, 1347, 1216, 787, 9994, 9995, 9983, 2273, 1372, 274, 2244, 1375, 9996, 2227, 2247, 9997, 9998, 1396, 2281, 9999, 10000, 2933, 2249, 38, 317, 6306, 3014, 1054, 10001, 10002 ],
  ),
  "fit_screen": SymbolsMetadata(
    popularity: 1899,
    codepoint: 0xea10,
    categories: [ 2 ],
    tags: [ 1128, 419, 2301, 3909, 1042, 2391, 12, 1216, 787, 10003, 2242, 9994, 10004, 2393, 1372, 2395, 1673, 53, 306, 2307, 367, 2400, 75, 2930, 2247, 2281, 330, 673, 32, 2249, 41, 317, 1054, 986 ],
  ),
  "fit_width": SymbolsMetadata(
    popularity: 32,
    codepoint: 0xf779,
    categories: [ 12 ],
    tags: [ 1128, 2301, 802, 10005, 10006, 2919, 1216, 787, 2242, 9983, 2393, 2273, 10007, 1372, 10008, 2244, 2176, 10009, 306, 10010, 2930, 2247, 2281, 330, 2933, 673, 2249, 10011, 791, 2936, 1592, 317, 6306, 3014, 10012, 986 ],
  ),
  "fitness_center": SymbolsMetadata(
    popularity: 4768,
    codepoint: 0xeb43,
    categories: [ 16 ],
    tags: [ 1242, 8149, 1343, 9233, 1730, 9235, 2925, 10013, 2927, 10014, 10015, 5776, 10016, 595, 6190, 9236, 3472, 4295, 5779, 5019, 2613, 3782, 5780, 5952, 5964, 5781, 3831, 9238, 9239, 1905, 3596 ],
  ),
  "fitness_tracker": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf463,
    categories: [ 11 ],
    tags: [ 989, 379, 2588, 1133, 7929, 1113, 472, 1016, 445, 88, 588, 2925, 2927, 4634, 2590, 5776, 965, 595, 5778, 1114, 219, 226, 75, 8156, 2932, 330, 446, 2591, 5780, 109, 2592, 447, 551, 38, 289, 2593, 405, 3206, 3939, 2102, 2594, 2596, 1691, 1905, 3596, 7930, 2598 ],
  ),
  "flag": SymbolsMetadata(
    popularity: 9288,
    codepoint: 0xe153,
    categories: [ 5 ],
    tags: [ 3, 469, 1670, 1631, 1633, 4752, 1484, 1550, 1640, 4720, 10017, 4753, 15, 16, 1251, 188, 3343, 1001, 1002, 1641, 21, 4755, 198, 4756, 421, 486, 10018, 1493, 1495, 4757, 75, 1030, 1353, 1664, 227, 607, 32, 108, 35, 2384, 4760, 4761 ],
    rtlAutoMirrored: true,
  ),
  "flag_2": SymbolsMetadata(
    popularity: 127,
    codepoint: 0xf40f,
    categories: [ 5 ],
    tags: [ 3, 469, 1670, 1633, 4752, 1484, 1550, 1640, 4720, 10019, 4753, 15, 16, 1251, 188, 3343, 1602, 1001, 1641, 21, 788, 4755, 198, 4756, 421, 486, 1495, 4757, 1409, 75, 1030, 1353, 1664, 8348, 227, 607, 32, 108, 35, 4761 ],
  ),
  "flag_check": SymbolsMetadata(
    popularity: 57,
    codepoint: 0xf3d8,
    categories: [ 5 ],
    tags: [ 1627, 6081, 3573, 3, 1549, 2480, 1630, 5826, 1632, 1633, 1636, 2481, 2376, 4752, 1484, 1639, 1550, 2909, 1640, 3065, 4720, 10020, 10021, 4753, 15, 3343, 1001, 1641, 4755, 198, 4756, 10022, 1643, 4750, 1495, 4757, 1353, 1354, 1664, 288, 4751, 607, 108, 2487, 1645, 1647, 2386, 8401, 2387, 4761, 1650 ],
  ),
  "flag_circle": SymbolsMetadata(
    popularity: 1796,
    codepoint: 0xeaf8,
    categories: [ 5 ],
    tags: [ 3, 469, 1670, 383, 384, 4752, 1484, 4720, 10023, 15, 16, 1251, 1001, 1002, 1641, 21, 198, 4756, 421, 486, 9293, 9294, 4758, 1030, 1353, 1354, 1257, 889, 3331, 1664, 108, 35, 4760 ],
  ),
  "flaky": SymbolsMetadata(
    popularity: 766,
    codepoint: 0xef50,
    categories: [ 1 ],
    tags: [ 1549, 5098, 5178, 1630, 383, 2950, 1633, 1734, 1202, 5182, 1639, 10024, 2766, 2985, 2768, 7879, 10025, 5109, 5042, 10026, 6111, 10027, 10028, 2769, 1641, 10029, 4152, 1643, 656, 10030, 2772, 288, 1378, 10031, 1083, 1647, 10032, 10033, 10034, 10035, 7025, 1523, 3736, 1650 ],
  ),
  "flare": SymbolsMetadata(
    popularity: 1181,
    codepoint: 0xe3e4,
    categories: [ 1 ],
    tags: [ 3669, 3670, 1728, 4661, 383, 10036, 696, 2299, 2567, 10037, 4080, 10038, 10039, 3674, 10040, 3019, 3676, 3677, 53, 5799, 3680, 366, 61, 119, 5801, 5039, 9316, 10041, 10042, 10043, 3699, 10044, 6393, 8044, 9606, 3264, 3686, 10045 ],
  ),
  "flash_auto": SymbolsMetadata(
    popularity: 363,
    codepoint: 0xe3e5,
    categories: [ 1 ],
    tags: [ 685, 1131, 1132, 10046, 3769, 4076, 47, 116, 3773, 4078, 4049, 3779, 1022, 4080, 10047, 10048, 53, 4082, 2781, 4083, 4131, 59, 61, 119, 3782, 1027, 1028, 231, 8871, 4086, 4654 ],
  ),
  "flash_off": SymbolsMetadata(
    popularity: 878,
    codepoint: 0xe3e6,
    categories: [ 1 ],
    tags: [ 4076, 47, 49, 895, 1077, 767, 4078, 898, 3779, 10049, 1022, 4080, 10050, 899, 4082, 4083, 4131, 10051, 10052, 10053, 10054, 10055, 2681, 10056, 907, 909, 59, 61, 10057, 6602, 171, 914, 2126, 4086, 4652 ],
  ),
  "flash_on": SymbolsMetadata(
    popularity: 2763,
    codepoint: 0xe3e7,
    categories: [ 1 ],
    tags: [ 951, 1242, 469, 4076, 3773, 767, 4078, 4049, 2855, 898, 3779, 1022, 4080, 10058, 4648, 4082, 10059, 4083, 4131, 486, 907, 909, 3782, 1027, 1028, 914, 231, 4650, 8871, 4086, 1261, 731, 4654 ],
  ),
  "flashlight_off": SymbolsMetadata(
    popularity: 406,
    codepoint: 0xf00a,
    categories: [ 4 ],
    tags: [ 3669, 895, 3690, 896, 1076, 1077, 767, 898, 4080, 10060, 10061, 899, 3674, 3676, 901, 10062, 3680, 4220, 10063, 10064, 10065, 907, 909, 6602, 4447, 4448, 10042, 171, 3699, 914, 10066, 5611, 10067, 5587 ],
  ),
  "flashlight_on": SymbolsMetadata(
    popularity: 1081,
    codepoint: 0xf00b,
    categories: [ 4 ],
    tags: [ 951, 10068, 3769, 3669, 3670, 1728, 3690, 445, 767, 4078, 898, 958, 960, 4080, 10060, 10069, 3674, 3905, 3676, 3680, 4220, 4254, 907, 909, 2585, 980, 3699, 914, 2537, 5611, 10070, 6367 ],
  ),
  "flatware": SymbolsMetadata(
    popularity: 775,
    codepoint: 0xf00c,
    categories: [ 8 ],
    tags: [ 3790, 3792, 8083, 6165, 4386, 6170, 8084, 8085, 3799, 4275, 3800, 8086, 7128, 10071, 1829, 8087, 4974, 2000, 4217, 3802, 10072, 6868, 3803, 3804, 10073, 3807, 10074, 8090, 8091, 10075, 8101 ],
  ),
  "flex_direction": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf778,
    categories: [ 12 ],
    tags: [ 2167, 2170, 380, 7, 2862, 1368, 1269, 1042, 388, 2651, 2924, 5920, 10076, 2212, 926, 1372, 2245, 306, 10077, 92, 778, 3070, 96, 98, 1496, 75, 106, 32, 107, 8344, 1381 ],
  ),
  "flex_no_wrap": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf777,
    categories: [ 12 ],
    tags: [ 10078, 2169, 2170, 918, 5792, 802, 1269, 1042, 10079, 10080, 2202, 1372, 2175, 246, 2176, 10081, 10082, 306, 10083, 10084, 10085, 10086, 75, 2258, 10087, 1603, 944, 10088, 10089, 2936, 2271, 317, 10090 ],
  ),
  "flex_wrap": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf776,
    categories: [ 12 ],
    tags: [ 10091, 1127, 1128, 2169, 2170, 918, 802, 1042, 2547, 10092, 2203, 926, 1372, 246, 2176, 306, 219, 98, 75, 2258, 10093, 2247, 2280, 1376, 3152, 944, 10094, 3426, 317, 7377, 10090, 4379, 10095 ],
  ),
  "flight": SymbolsMetadata(
    popularity: 5885,
    codepoint: 0xe539,
    categories: [ 14 ],
    tags: [ 1950, 707, 2010, 1906, 10096, 1907, 1932, 2012, 2013, 2014, 1935, 1936, 2016, 1484, 1917, 2017, 1918, 1973, 10097, 10098, 10099, 1581, 307, 6778, 909, 10100, 308, 2020, 227, 9533, 2022, 2023, 1930, 1504, 1591, 2024, 8979 ],
  ),
  "flight_class": SymbolsMetadata(
    popularity: 318,
    codepoint: 0xe7cb,
    categories: [ 5 ],
    tags: [ 707, 1906, 1907, 1932, 2012, 2013, 3597, 1935, 1936, 1284, 1911, 1912, 1913, 1914, 10101, 1937, 1916, 1917, 10102, 2017, 1918, 1973, 10103, 1581, 1920, 1922, 308, 2020, 531, 1924, 1926, 227, 1930, 1504, 1981, 1591, 533 ],
  ),
  "flight_land": SymbolsMetadata(
    popularity: 1187,
    codepoint: 0xe904,
    categories: [ 14 ],
    tags: [ 707, 2010, 1906, 1907, 1932, 10104, 10105, 2012, 2013, 10106, 10107, 2014, 10108, 10109, 1935, 10110, 10111, 2016, 2937, 9494, 1917, 10112, 2017, 1918, 1973, 10113, 1581, 1833, 10114, 308, 10115, 2020, 10116, 227, 10117, 1930, 1504, 5237, 1591 ],
    rtlAutoMirrored: true,
  ),
  "flight_takeoff": SymbolsMetadata(
    popularity: 3843,
    codepoint: 0xe905,
    categories: [ 14 ],
    tags: [ 1593, 1950, 707, 2010, 10118, 1906, 1907, 1932, 2012, 2013, 2014, 10109, 2466, 1935, 10111, 2016, 10119, 1917, 10120, 2017, 1918, 1973, 2018, 1581, 10114, 3080, 308, 2020, 2475, 10116, 227, 10121, 2023, 1842, 1930, 1504, 1591, 1676, 2024 ],
    rtlAutoMirrored: true,
  ),
  "flights_and_hotels": SymbolsMetadata(
    popularity: 74,
    codepoint: 0xe9ab,
    categories: [ 16 ],
    tags: [ 2599, 707, 2010, 1906, 1932, 2012, 2013, 1909, 1936, 5768, 2330, 1917, 10122, 2017, 1918, 1973, 1964, 2018, 2607, 10123, 10124, 10125, 2610, 4220, 2364, 308, 2020, 1924, 1925, 1960, 227, 1929, 1930, 1504, 10126, 1981, 1591, 10127, 2024, 10128 ],
    rtlAutoMirrored: true,
  ),
  "flip": SymbolsMetadata(
    popularity: 880,
    codepoint: 0xe3e8,
    categories: [ 1 ],
    tags: [ 1367, 1731, 2272, 2448, 2449, 1370, 8751, 956, 696, 2299, 5499, 2175, 53, 3145, 881, 306, 5725, 1740, 3147, 2227, 3422, 75, 8507, 2881, 396, 10129, 1378, 32, 5256, 313, 2183, 427, 10130, 402, 1215 ],
  ),
  "flip_camera_android": SymbolsMetadata(
    popularity: 858,
    codepoint: 0xea37,
    categories: [ 1 ],
    tags: [ 1175, 419, 5553, 47, 5497, 5554, 5555, 1730, 1731, 5558, 383, 385, 696, 2299, 5499, 5559, 5501, 53, 881, 219, 3147, 59, 177, 2881, 396, 5560, 397, 2813, 5256, 313, 5505, 314, 402, 41, 1160 ],
  ),
  "flip_camera_ios": SymbolsMetadata(
    popularity: 657,
    codepoint: 0xea38,
    categories: [ 1 ],
    tags: [ 2866, 1175, 419, 5553, 47, 7072, 48, 49, 116, 1731, 5558, 383, 2872, 696, 2299, 5499, 5559, 5501, 53, 881, 2888, 367, 219, 3147, 59, 5530, 177, 424, 2881, 396, 5560, 5561, 313, 5505, 314, 402, 41 ],
  ),
  "flip_to_back": SymbolsMetadata(
    popularity: 256,
    codepoint: 0xe882,
    categories: [ 12 ],
    tags: [ 1539, 1367, 2170, 2489, 10131, 799, 1731, 1042, 1062, 2448, 2449, 3640, 5499, 1372, 5500, 246, 1078, 881, 3759, 306, 778, 780, 96, 1534, 2876, 2948, 2881, 396, 106, 944, 5256, 313, 3637, 3426, 1689, 427, 2571, 402, 317 ],
  ),
  "flip_to_front": SymbolsMetadata(
    popularity: 399,
    codepoint: 0xe883,
    categories: [ 12 ],
    tags: [ 264, 1367, 2170, 2489, 799, 1731, 1042, 2448, 2449, 1347, 956, 1530, 5499, 1372, 777, 5500, 4964, 306, 778, 96, 1534, 1770, 412, 75, 8507, 2881, 396, 190, 106, 32, 107, 5256, 313, 791, 1689, 2571, 402, 317, 1054 ],
  ),
  "float_landscape_2": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf45c,
    categories: [ 2 ],
    tags: [ 1367, 7, 2896, 10132, 12, 2522, 3007, 5499, 10133, 10134, 10135, 1372, 1543, 4964, 306, 778, 7822, 3003, 2653, 1081, 1770, 1049, 10136, 4885, 1496, 75, 2247, 396, 330, 10137, 8349, 32, 10138, 317, 1054, 8350 ],
    rtlAutoMirrored: true,
  ),
  "float_portrait_2": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf45b,
    categories: [ 2 ],
    tags: [ 81, 2301, 2896, 1042, 12, 1347, 1530, 5499, 10133, 1372, 274, 1541, 53, 1044, 306, 367, 219, 2653, 3147, 1534, 226, 59, 119, 854, 1496, 75, 396, 330, 32, 315, 346, 1381, 317, 1054 ],
    rtlAutoMirrored: true,
  ),
  "flood": SymbolsMetadata(
    popularity: 779,
    codepoint: 0xebe6,
    categories: [ 3 ],
    tags: [ 469, 8672, 6558, 7270, 4664, 10139, 4668, 2482, 10140, 10141, 10142, 10143, 926, 4647, 10144, 999, 1435, 5668, 10145, 7484, 7485, 3097, 10146, 7486, 5861, 10147, 10148, 4650, 10149, 10150, 1261, 2801, 1862, 1902, 731 ],
  ),
  "floor": SymbolsMetadata(
    popularity: 89,
    codepoint: 0xf6e4,
    categories: [ 15 ],
    tags: [ 755, 733, 2466, 798, 2467, 2937, 388, 2651, 8444, 9163, 2926, 8918, 10151, 538, 10152, 10153, 934, 1858, 10154, 421, 2865, 8914, 9167, 9168, 109, 10155, 2571, 1676, 3229, 9161 ],
  ),
  "floor_lamp": SymbolsMetadata(
    popularity: 236,
    codepoint: 0xe21e,
    categories: [ 10 ],
    tags: [ 4310, 4211, 1728, 8536, 5978, 4251, 10156, 8918, 10157, 10158, 1964, 999, 1435, 3676, 2793, 2796, 10062, 3680, 5062, 5982, 4220, 1361, 4757, 2507, 1959, 1960, 4204, 105, 4323, 10159 ],
  ),
  "flowchart": SymbolsMetadata(
    popularity: 106,
    codepoint: 0xf38d,
    categories: [ 9 ],
    tags: [ 468, 3498, 2513, 5, 3026, 920, 5124, 921, 211, 10, 3027, 924, 926, 927, 3501, 929, 932, 933, 935, 6191, 597, 937, 223, 656, 96, 940, 1586, 2838, 942, 8006, 104, 32, 33, 109, 6193, 945, 947, 948, 2746 ],
  ),
  "flowsheet": SymbolsMetadata(
    popularity: 97,
    codepoint: 0xe0ae,
    categories: [ 9 ],
    tags: [ 3498, 2513, 3026, 920, 953, 922, 211, 10160, 924, 1528, 1347, 1530, 926, 3501, 10161, 929, 595, 933, 10162, 366, 935, 92, 6191, 1757, 223, 3282, 940, 1534, 1535, 2838, 10163, 942, 1353, 104, 4786, 4787, 109, 6193, 945, 2632, 2746 ],
  ),
  "fluid": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xe483,
    categories: [ 3 ],
    tags: [ 1129, 8646, 1136, 926, 2790, 10164, 595, 1142, 10165, 2798, 1143, 1756, 1757, 1760, 1146, 1147, 1152, 121, 177, 77, 1156, 3399, 492, 493, 4323, 7901, 496, 441, 1161, 10166, 10167, 1862, 1902 ],
  ),
  "fluid_balance": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf80d,
    categories: [ 3 ],
    tags: [ 794, 3600, 920, 1528, 1347, 6626, 1530, 10168, 10169, 10164, 929, 595, 4473, 1754, 10170, 933, 10171, 10172, 10173, 92, 597, 1757, 10174, 327, 1719, 1534, 1535, 1762, 121, 4786, 4787, 10175, 2165, 2428, 2801, 4646, 1905 ],
  ),
  "fluid_med": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf80c,
    categories: [ 3 ],
    tags: [ 9267, 3600, 920, 1528, 1347, 10176, 6626, 5630, 2482, 1530, 4472, 2790, 10164, 929, 595, 1753, 1754, 933, 8955, 10177, 10172, 10173, 2798, 1757, 1759, 1760, 3562, 1534, 1535, 1762, 1763, 4786, 4787, 10178, 10175, 4476, 2428, 10179, 10180 ],
  ),
  "fluorescent": SymbolsMetadata(
    popularity: 298,
    codepoint: 0xec31,
    categories: [ 1 ],
    tags: [ 3669, 3670, 1728, 3942, 1416, 4078, 3779, 10156, 10181, 10182, 10039, 3674, 3676, 3677, 10183, 10062, 3680, 3946, 5062, 1116, 10042, 75, 10043, 3699, 8044, 32, 1122, 10184, 10185 ],
  ),
  "flutter": SymbolsMetadata(
    popularity: 145,
    codepoint: 0xf1dd,
    categories: [ 6 ],
    tags: [ 10186, 2963, 1229, 1181, 1230, 10187, 380, 3909, 2862, 2624, 10188, 10189, 1186, 3593, 10190, 3419, 1659, 10191, 339, 6587, 2528, 1191, 3543, 2648, 2630, 7922, 1196, 10192, 10193, 1701, 5495, 2455, 10194, 7504 ],
  ),
  "flutter_dash": SymbolsMetadata(
    popularity: 1993,
    codepoint: 0xe00b,
    categories: [ 6 ],
    tags: [ 5177, 1229, 1230, 470, 10195, 8827, 8, 383, 10196, 2448, 2625, 590, 1917, 10190, 1918, 3419, 6231, 2819, 16, 2528, 2541, 219, 3543, 10197, 10198, 2648, 889, 1196, 10199, 8979 ],
  ),
  "flyover": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf478,
    categories: [ 14 ],
    tags: [ 10200, 1182, 10201, 1484, 1654, 3484, 10202, 10203, 10204, 1488, 1580, 5073, 9730, 1209, 1581, 1001, 1002, 1490, 10205, 421, 10206, 10207, 1587, 10208, 1503, 1589, 10209, 1590, 1842, 1930, 1504, 1591, 10210 ],
  ),
  "fmd_bad": SymbolsMetadata(
    popularity: 1494,
    codepoint: 0xf00e,
    categories: [ 5 ],
    tags: [ 3175, 469, 3073, 10211, 1693, 3176, 1484, 388, 2766, 2767, 960, 4720, 10212, 1488, 1251, 5223, 2769, 1001, 10213, 1002, 10214, 1490, 1641, 21, 421, 3696, 486, 1493, 1495, 9293, 9294, 2772, 1353, 980, 35, 1261 ],
  ),
  "foggy": SymbolsMetadata(
    popularity: 537,
    codepoint: 0xe818,
    categories: [ 3 ],
    tags: [ 707, 1847, 712, 1652, 10215, 6481, 10216, 5721, 956, 10217, 5723, 10218, 6392, 3328, 7661, 10219, 1904, 16, 10220, 1857, 1877, 2799, 10221, 6484, 10222, 3948, 9602, 35, 727, 441, 7998, 731, 732 ],
  ),
  "folded_hands": SymbolsMetadata(
    popularity: 67,
    codepoint: 0xf5ed,
    categories: [ 3 ],
    tags: [ 3325, 6950, 9423, 6274, 6276, 10223, 2735, 6154, 2738, 2741, 5603, 483, 16, 10224, 10225, 10226, 489, 10227, 6282, 5606, 10228, 5607, 6283, 3162, 6201, 5609, 6284, 35, 10229, 6161, 6162, 10230, 5614 ],
  ),
  "folder": SymbolsMetadata(
    popularity: 10490,
    codepoint: 0xe2c7,
    categories: [ 12 ],
    tags: [ 2151, 10231, 5123, 2155, 1269, 10232, 10, 6936, 10233, 1528, 1347, 10234, 1654, 1530, 10235, 4781, 1656, 10236, 1657, 135, 2159, 1001, 2653, 98, 1586, 5136, 2843, 1664, 1377, 4786, 4787, 674, 1070 ],
  ),
  "folder_check": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf3d7,
    categories: [ 12 ],
    tags: [ 1627, 2716, 6081, 2717, 1549, 2480, 1630, 10237, 1632, 1633, 1635, 1636, 2481, 2376, 10, 6936, 1528, 1347, 1639, 1654, 2909, 1530, 1640, 3065, 1656, 10238, 10239, 10240, 1657, 1641, 1643, 4750, 1664, 4271, 288, 4786, 4787, 674, 2487, 1647, 2385, 8401, 2387, 1650 ],
  ),
  "folder_check_2": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf3d6,
    categories: [ 12 ],
    tags: [ 1627, 6081, 1549, 2480, 1630, 10237, 1632, 1633, 1635, 1636, 2481, 2376, 10, 6936, 1528, 1347, 1639, 1654, 2909, 1530, 1640, 3065, 1656, 10238, 10239, 10241, 1657, 1641, 1643, 4750, 1664, 4271, 288, 4751, 4786, 4787, 674, 2487, 1647, 8401, 2387, 1523, 2389, 1650 ],
  ),
  "folder_code": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf3c8,
    categories: [ 12 ],
    tags: [ 2151, 3909, 2862, 2624, 10242, 10243, 6580, 6581, 10, 6582, 1186, 2625, 10244, 6936, 1528, 1347, 5243, 1654, 6583, 2835, 1530, 1655, 1656, 10245, 1657, 6006, 6007, 6584, 3543, 1194, 2630, 10246, 3156, 2843, 10247, 10248, 10249, 4786, 4787, 1196, 6590, 10250, 674, 6010 ],
  ),
  "folder_copy": SymbolsMetadata(
    popularity: 1503,
    codepoint: 0xebbd,
    categories: [ 12 ],
    tags: [ 2151, 10251, 3753, 1042, 4778, 1707, 10252, 5807, 10, 3754, 3050, 6936, 1528, 1347, 5243, 1654, 2999, 10253, 1530, 4781, 3052, 1655, 1656, 10254, 1657, 1065, 778, 2557, 10255, 4915, 6073, 5482, 4786, 4787, 107, 674, 2007, 10256 ],
  ),
  "folder_data": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf586,
    categories: [ 12 ],
    tags: [ 2151, 1994, 2624, 211, 10, 10257, 3754, 7515, 3756, 6936, 1528, 1347, 1654, 1530, 4781, 1656, 10258, 10259, 10260, 1657, 932, 135, 7610, 10261, 223, 3282, 98, 10262, 1586, 2843, 1665, 10263, 4786, 4787, 674, 945, 983 ],
  ),
  "folder_delete": SymbolsMetadata(
    popularity: 694,
    codepoint: 0xeb34,
    categories: [ 12 ],
    tags: [ 2151, 3433, 3434, 1871, 3435, 3436, 10, 897, 10264, 10265, 6936, 6426, 1528, 1347, 1654, 3438, 1530, 4781, 1655, 1656, 10266, 10236, 10267, 1657, 3439, 3440, 911, 10268, 4786, 4787, 674, 3444, 10269, 10270 ],
  ),
  "folder_eye": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf3d5,
    categories: [ 12 ],
    tags: [ 755, 5123, 10, 10271, 10272, 12, 1528, 1347, 1654, 958, 6300, 1530, 10273, 10274, 1656, 10275, 10276, 1657, 1078, 971, 8559, 909, 2653, 10277, 10278, 2948, 10279, 981, 4786, 2997, 10280, 4787, 674, 7663, 317, 5023, 8214, 2102 ],
  ),
  "folder_info": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf395,
    categories: [ 12 ],
    tags: [ 5461, 469, 1245, 738, 383, 10, 6325, 132, 10281, 6936, 10282, 1528, 1347, 1654, 1530, 10283, 10284, 10285, 1656, 10286, 10287, 10236, 10288, 1657, 10289, 482, 5463, 484, 135, 7530, 4695, 10290, 10291, 789, 8728, 10292, 2631, 4786, 4787, 674, 495, 6070 ],
  ),
  "folder_limited": SymbolsMetadata(
    popularity: 81,
    codepoint: 0xf4e4,
    categories: [ 12 ],
    tags: [ 892, 4435, 1074, 894, 895, 383, 2950, 3242, 10, 3244, 8287, 1528, 1347, 1654, 1597, 2985, 1530, 10273, 10293, 1656, 10275, 10294, 1657, 899, 459, 10295, 4152, 2678, 7011, 908, 1514, 10296, 1516, 1517, 4448, 4329, 4449, 911, 912, 10297, 1011, 4786, 914, 4787, 1083, 674, 915 ],
  ),
  "folder_managed": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf775,
    categories: [ 12 ],
    tags: [ 1507, 1747, 1230, 1731, 4175, 4176, 268, 269, 6676, 1735, 10, 132, 6936, 10298, 10299, 10300, 1528, 1347, 4779, 1654, 1530, 4781, 1656, 7223, 10301, 10302, 3485, 484, 135, 2770, 1755, 936, 656, 940, 98, 1514, 10296, 790, 329, 2631, 65, 4786, 4787, 674 ],
  ),
  "folder_match": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf3d4,
    categories: [ 12 ],
    tags: [ 2151, 10303, 3812, 3813, 1707, 10304, 10, 10305, 6936, 1528, 1347, 5243, 1654, 2999, 10306, 1530, 1655, 1656, 1657, 935, 936, 2379, 9128, 1067, 6321, 778, 8153, 940, 4786, 4787, 674, 1667, 3750, 3529, 2007, 3060 ],
  ),
  "folder_off": SymbolsMetadata(
    popularity: 321,
    codepoint: 0xeb83,
    categories: [ 12 ],
    tags: [ 2151, 10307, 895, 10308, 1202, 10, 1076, 10264, 10309, 767, 1528, 1347, 1654, 898, 1530, 4781, 1656, 10310, 10311, 10312, 10313, 1657, 899, 10314, 901, 2678, 10315, 907, 909, 819, 940, 75, 10268, 912, 4786, 914, 4787, 674, 441, 915 ],
  ),
  "folder_open": SymbolsMetadata(
    popularity: 8967,
    codepoint: 0xe2c8,
    categories: [ 12 ],
    tags: [ 755, 2151, 1039, 1269, 1042, 10, 6936, 10233, 1528, 1347, 5243, 1654, 958, 1530, 10316, 10317, 4781, 1655, 1656, 10236, 10318, 1657, 135, 3513, 936, 2653, 10319, 98, 1664, 4786, 4787, 674, 317 ],
  ),
  "folder_shared": SymbolsMetadata(
    popularity: 1622,
    codepoint: 0xe2c9,
    categories: [ 12 ],
    tags: [ 755, 468, 3281, 1540, 10320, 10, 6936, 1528, 1347, 1654, 479, 1530, 1656, 10275, 10321, 10322, 10323, 930, 483, 936, 223, 940, 488, 1514, 489, 1516, 490, 2071, 2843, 1665, 10324, 10325, 10263, 3058, 4786, 4787, 674, 946, 501, 10326 ],
  ),
  "folder_special": SymbolsMetadata(
    popularity: 1000,
    codepoint: 0xe617,
    categories: [ 12 ],
    tags: [ 755, 2151, 1670, 2155, 10, 6936, 1528, 1347, 1654, 3578, 4798, 1530, 1656, 3019, 1251, 968, 10327, 98, 790, 531, 4758, 1517, 101, 102, 1664, 4271, 1773, 311, 4786, 4787, 3586, 3264, 4805, 674, 5766 ],
  ),
  "folder_supervised": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf774,
    categories: [ 12 ],
    tags: [ 755, 468, 1508, 2151, 584, 3281, 269, 10, 6936, 1528, 1347, 1654, 1530, 1656, 930, 483, 936, 327, 940, 10328, 3119, 1514, 10296, 489, 790, 1516, 490, 912, 1011, 10324, 4786, 4787, 674, 10329, 946, 501 ],
  ),
  "folder_zip": SymbolsMetadata(
    popularity: 971,
    codepoint: 0xeb2c,
    categories: [ 12 ],
    tags: [ 2151, 10231, 10330, 3086, 10331, 10332, 3537, 1269, 10, 10333, 1528, 1347, 337, 1654, 6243, 1530, 4781, 1656, 10334, 1657, 2653, 2647, 1664, 4786, 4787, 674, 441, 2252, 346, 6837, 10335, 10336, 10337 ],
  ),
  "follow_the_signs": SymbolsMetadata(
    popularity: 1049,
    codepoint: 0xf222,
    categories: [ 3 ],
    tags: [ 380, 584, 3241, 776, 388, 8687, 1578, 1250, 10338, 777, 3225, 483, 5485, 7920, 4938, 421, 780, 10339, 1586, 8066, 488, 489, 781, 1396, 1503, 7494, 10340, 10341, 607, 750, 10342, 3206, 3939, 3229 ],
    rtlAutoMirrored: true,
  ),
  "font_download": SymbolsMetadata(
    popularity: 679,
    codepoint: 0xe167,
    categories: [ 12 ],
    tags: [ 3495, 685, 10343, 4, 7, 8, 10344, 5919, 337, 10345, 14, 10346, 10347, 10348, 10349, 10350, 4953, 10351, 10352, 8996, 10353, 4704, 19, 10354, 32, 35, 38, 10355, 40, 4961, 2271, 702 ],
  ),
  "font_download_off": SymbolsMetadata(
    popularity: 135,
    codepoint: 0xe4f9,
    categories: [ 12 ],
    tags: [ 685, 4, 1074, 895, 4950, 8, 1202, 896, 1077, 767, 337, 898, 14, 10356, 10357, 899, 4704, 19, 7067, 9721, 10358, 907, 909, 911, 3310, 914, 32, 1083, 35, 38, 40, 4961, 702, 915 ],
  ),
  "food_bank": SymbolsMetadata(
    popularity: 871,
    codepoint: 0xf1f2,
    categories: [ 16 ],
    tags: [ 736, 2601, 738, 795, 798, 7258, 194, 8084, 3316, 4470, 3800, 7128, 2605, 1829, 10359, 10360, 10361, 10362, 2000, 482, 999, 1435, 8088, 10363, 10072, 3804, 8273, 1495, 2614, 10364, 1446, 2616, 2617, 10365, 495, 8101 ],
  ),
  "foot_bones": SymbolsMetadata(
    popularity: 177,
    codepoint: 0xf893,
    categories: [ 3 ],
    tags: [ 3919, 10366, 10367, 584, 4289, 9621, 9622, 10368, 1954, 10369, 9628, 595, 10370, 4635, 3201, 10371, 1955, 9632, 1757, 10372, 9641, 10373, 10374, 3932, 9635, 9636, 10375, 3936, 9644 ],
  ),
  "footprint": SymbolsMetadata(
    popularity: 177,
    codepoint: 0xf87d,
    categories: [ 3 ],
    tags: [ 989, 388, 590, 2927, 1954, 3924, 3925, 10376, 3927, 3928, 1488, 3929, 1023, 483, 2724, 3931, 1581, 1001, 1002, 421, 1361, 3000, 1586, 1496, 1721, 1503, 8328, 109, 3937, 2165, 947, 3938, 1504, 315, 3206, 3939 ],
  ),
  "for_you": SymbolsMetadata(
    popularity: 76,
    codepoint: 0xe9ac,
    categories: [ 7 ],
    tags: [ 468, 2447, 10377, 10378, 7019, 6676, 1735, 479, 5876, 10379, 9599, 10380, 483, 885, 10381, 6995, 488, 489, 2695, 10382, 3021, 285, 5591, 490, 8822, 10383, 288, 10384, 8987, 10385, 495, 10386, 2344, 501, 2815 ],
  ),
  "forest": SymbolsMetadata(
    popularity: 3091,
    codepoint: 0xea99,
    categories: [ 3 ],
    tags: [ 10387, 2464, 3722, 10388, 1890, 10389, 10390, 10391, 1659, 10392, 3724, 10393, 1543, 5814, 10394, 1859, 1860, 3345, 10395, 10396, 10397, 1924, 3845, 10398, 5819, 3938, 1504, 10399, 1701, 10400, 5581, 10401, 10402 ],
  ),
  "fork_left": SymbolsMetadata(
    popularity: 320,
    codepoint: 0xeba0,
    categories: [ 14 ],
    tags: [ 380, 419, 1994, 10403, 266, 2624, 3027, 388, 1578, 3028, 10404, 2000, 10405, 6006, 6007, 1375, 2875, 1490, 1067, 421, 281, 656, 1586, 2865, 2496, 1503, 7494, 7375, 1378, 10406, 1590, 402, 2975, 1677, 6010 ],
  ),
  "fork_right": SymbolsMetadata(
    popularity: 605,
    codepoint: 0xebac,
    categories: [ 14 ],
    tags: [ 380, 419, 1994, 10407, 2447, 5124, 3027, 10408, 1997, 388, 1578, 3028, 10409, 2000, 10410, 6006, 6007, 1490, 421, 281, 656, 1586, 10411, 2843, 1396, 782, 1503, 7494, 1378, 10412, 1590, 402, 8103, 2455, 10413, 2009, 1677 ],
  ),
  "fork_spoon": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf3e4,
    categories: [ 8 ],
    tags: [ 3790, 3792, 8083, 6165, 3793, 383, 3795, 4386, 8084, 3798, 8085, 3799, 4275, 3800, 3801, 7128, 1829, 4974, 2000, 3802, 10072, 6868, 3803, 3804, 3807, 10074, 8090, 3809, 8091, 4283, 4284, 441, 6376, 8101 ],
  ),
  "forklift": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf868,
    categories: [ 9 ],
    tags: [ 4611, 3723, 2832, 1019, 2210, 2523, 7114, 10414, 4614, 4918, 10415, 10416, 6923, 6924, 3472, 10417, 2568, 3896, 1834, 7116, 6925, 10418, 4604, 674, 7119, 3899, 1842, 1930, 1843, 10419, 1844, 3902 ],
  ),
  "format_align_center": SymbolsMetadata(
    popularity: 986,
    codepoint: 0xe234,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 1730, 2171, 1042, 1528, 1347, 696, 2299, 1371, 1372, 2175, 2191, 2177, 10420, 2178, 1066, 366, 2179, 2180, 4786, 1379, 107, 38, 2183, 2229, 441, 40, 702, 704 ],
  ),
  "format_align_justify": SymbolsMetadata(
    popularity: 739,
    codepoint: 0xe235,
    categories: [ 12 ],
    tags: [ 2167, 10421, 2169, 1367, 3418, 1042, 7712, 2173, 1528, 1347, 696, 2299, 1371, 1951, 10422, 1372, 10423, 7721, 2080, 2178, 10424, 306, 366, 98, 2180, 2505, 4786, 1979, 2248, 1379, 38, 2183, 2229, 2230, 40, 702, 2222, 704 ],
  ),
  "format_align_left": SymbolsMetadata(
    popularity: 1404,
    codepoint: 0xe236,
    categories: [ 12 ],
    tags: [ 2167, 2297, 2169, 1367, 1042, 1528, 1347, 696, 2299, 1371, 1372, 10423, 2175, 2080, 2225, 306, 1375, 2226, 366, 92, 788, 96, 2227, 2180, 4786, 1379, 38, 2183, 2184, 2230, 2231, 40, 702, 2185, 704 ],
    rtlAutoMirrored: true,
  ),
  "format_align_right": SymbolsMetadata(
    popularity: 917,
    codepoint: 0xe237,
    categories: [ 12 ],
    tags: [ 1128, 2167, 2187, 2169, 1367, 1528, 1347, 696, 8777, 2299, 1371, 1372, 10423, 2175, 7721, 2080, 2178, 306, 366, 98, 2180, 1496, 1396, 2194, 2236, 4786, 1379, 38, 2183, 2229, 10425, 2266, 2197, 40, 2271, 702, 2185, 704 ],
    rtlAutoMirrored: true,
  ),
  "format_bold": SymbolsMetadata(
    popularity: 2407,
    codepoint: 0xe238,
    categories: [ 12 ],
    tags: [ 10426, 4, 689, 2778, 10427, 8, 1528, 696, 2299, 1371, 3258, 14, 10428, 1372, 2175, 3019, 1251, 4704, 7398, 19, 10429, 4786, 1379, 5964, 2182, 4959, 35, 38, 7476, 2230, 10355, 40, 4961, 702, 3831, 704 ],
  ),
  "format_clear": SymbolsMetadata(
    popularity: 321,
    codepoint: 0xe239,
    categories: [ 12 ],
    tags: [ 10430, 2169, 4, 3851, 10431, 8, 10432, 3436, 10433, 10434, 10435, 767, 1528, 696, 2299, 1371, 898, 14, 10351, 1372, 10436, 2175, 10437, 19, 7715, 92, 10438, 23, 907, 909, 2257, 10439, 4829, 10440, 4786, 914, 1379, 2182, 35, 38, 2184, 10425, 2230, 40, 702, 704 ],
  ),
  "format_color_fill": SymbolsMetadata(
    popularity: 1627,
    codepoint: 0xe23a,
    categories: [ 12 ],
    tags: [ 2829, 6359, 10441, 4848, 10442, 6673, 8551, 1201, 6676, 299, 1528, 1500, 4471, 696, 2299, 1371, 2279, 1372, 2175, 6684, 53, 3145, 5166, 10443, 119, 10444, 4786, 1379, 2182, 10445, 38, 2537, 40, 704 ],
  ),
  "format_color_reset": SymbolsMetadata(
    popularity: 576,
    codepoint: 0xe23b,
    categories: [ 12 ],
    tags: [ 10431, 10446, 383, 3436, 10447, 10434, 4848, 4563, 3302, 10448, 1077, 767, 1528, 4471, 696, 2299, 1371, 898, 2279, 1372, 2175, 7067, 10449, 10450, 907, 909, 5166, 10451, 4829, 426, 4786, 914, 1379, 2126, 2182, 10445, 38, 2230, 40, 2801, 704 ],
  ),
  "format_color_text": SymbolsMetadata(
    popularity: 1104,
    codepoint: 0xe23c,
    categories: [ 12 ],
    tags: [ 685, 1731, 8, 4848, 6676, 1735, 1528, 1347, 696, 2299, 1371, 2279, 14, 10452, 1372, 2175, 4704, 1740, 5166, 4786, 1379, 2182, 38, 10453, 7476, 2230, 10355, 40, 702, 2498, 10454, 4823, 2185, 704 ],
  ),
  "format_h1": SymbolsMetadata(
    popularity: 119,
    codepoint: 0xf85d,
    categories: [ 12 ],
    tags: [ 9152, 1042, 2272, 1528, 1347, 696, 2299, 1371, 2279, 14, 1372, 2175, 10455, 4852, 10456, 932, 2396, 10457, 3634, 1534, 2180, 2281, 2401, 1377, 673, 2182, 38, 10458, 10459, 40, 702, 704, 986, 2403 ],
  ),
  "format_h2": SymbolsMetadata(
    popularity: 67,
    codepoint: 0xf85e,
    categories: [ 12 ],
    tags: [ 2501, 1400, 1042, 1528, 1347, 696, 2299, 1371, 2279, 14, 1372, 2175, 10460, 4852, 10456, 10461, 932, 6584, 10462, 306, 98, 2180, 10463, 1377, 945, 2182, 10464, 6469, 38, 10459, 40, 702, 1240, 704 ],
  ),
  "format_h3": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf85f,
    categories: [ 12 ],
    tags: [ 2501, 1400, 1042, 6581, 1528, 1347, 696, 2299, 1371, 2279, 14, 1372, 2175, 10465, 4852, 10456, 10466, 932, 6584, 10462, 1361, 1377, 945, 2182, 6469, 38, 10467, 10459, 40, 702, 1691, 1053, 704 ],
  ),
  "format_h4": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xf860,
    categories: [ 12 ],
    tags: [ 1042, 2272, 6581, 1528, 1347, 696, 2299, 1371, 2279, 14, 1372, 2175, 4705, 10468, 10469, 4852, 10456, 10470, 10471, 6584, 5032, 2182, 38, 2230, 10355, 10459, 40, 702, 1691, 704 ],
  ),
  "format_h5": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf861,
    categories: [ 12 ],
    tags: [ 2501, 1400, 1042, 1528, 1347, 696, 2299, 1371, 10472, 2279, 14, 10473, 1372, 2175, 10474, 4852, 10456, 10475, 10476, 6584, 10477, 10478, 10462, 673, 2182, 6469, 38, 10459, 40, 702, 1691, 704 ],
  ),
  "format_h6": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf862,
    categories: [ 12 ],
    tags: [ 1042, 2272, 6830, 1528, 1347, 696, 2299, 1371, 2279, 14, 10473, 1372, 2175, 10479, 4852, 10456, 10480, 10481, 2396, 10462, 10482, 10429, 10483, 673, 10484, 2182, 4959, 38, 2230, 10458, 10459, 40, 702, 704 ],
  ),
  "format_image_left": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xf863,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 10485, 1042, 1528, 1347, 696, 2299, 1371, 2279, 1372, 2175, 2080, 53, 10486, 1044, 10487, 2178, 306, 1375, 366, 778, 2227, 2180, 119, 1496, 32, 2182, 38, 2183, 2230, 441, 40, 704 ],
  ),
  "format_image_right": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf864,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 1042, 1528, 1347, 696, 2299, 1371, 2279, 1372, 2175, 53, 10488, 1044, 2178, 306, 366, 778, 1534, 2180, 59, 119, 1496, 75, 1396, 32, 2586, 2182, 38, 2183, 441, 40, 704 ],
  ),
  "format_indent_decrease": SymbolsMetadata(
    popularity: 341,
    codepoint: 0xe23d,
    categories: [ 12 ],
    tags: [ 2167, 2169, 380, 2489, 2624, 6579, 2922, 10489, 10490, 1528, 1347, 696, 2299, 1371, 1372, 10491, 10492, 10437, 1375, 2875, 366, 92, 10493, 2180, 10494, 4786, 1379, 38, 2229, 2230, 40, 702, 10495, 2185, 704 ],
    rtlAutoMirrored: true,
  ),
  "format_indent_increase": SymbolsMetadata(
    popularity: 540,
    codepoint: 0xe23e,
    categories: [ 12 ],
    tags: [ 2167, 2169, 380, 2624, 10496, 1528, 696, 2299, 1371, 1372, 2175, 1207, 10497, 10492, 10498, 10437, 366, 2235, 2180, 2257, 1396, 782, 4786, 2237, 2248, 1379, 1070, 10499, 38, 2229, 2230, 10500, 1701, 40, 2222, 704 ],
    rtlAutoMirrored: true,
  ),
  "format_ink_highlighter": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xf82b,
    categories: [ 12 ],
    tags: [ 8521, 3254, 4848, 1528, 1347, 2834, 302, 696, 2299, 1371, 10501, 9144, 2279, 1372, 2175, 3019, 10502, 1251, 2725, 1641, 21, 1532, 1533, 1456, 5166, 2693, 3158, 288, 371, 4786, 1379, 3296, 2182, 38, 2230, 10503, 40, 2498, 10454, 704 ],
  ),
  "format_italic": SymbolsMetadata(
    popularity: 1626,
    codepoint: 0xe23f,
    categories: [ 12 ],
    tags: [ 4, 10504, 8, 10432, 1528, 696, 2299, 1371, 3258, 14, 10351, 1372, 2175, 3019, 5463, 8912, 4955, 4704, 19, 8005, 10429, 4958, 4786, 8007, 1379, 2182, 35, 38, 7476, 2230, 10355, 9889, 40, 2271, 702, 2185, 704 ],
  ),
  "format_letter_spacing": SymbolsMetadata(
    popularity: 38,
    codepoint: 0xf773,
    categories: [ 12 ],
    tags: [ 1128, 10505, 2167, 419, 10506, 6247, 2919, 2173, 2450, 696, 1371, 787, 1372, 8735, 2080, 10507, 1375, 2875, 4704, 366, 6834, 1396, 782, 609, 2248, 2438, 38, 2229, 2230, 441, 947, 702, 3110, 2222 ],
  ),
  "format_letter_spacing_2": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf618,
    categories: [ 12 ],
    tags: [ 1128, 2167, 4, 419, 1731, 8, 10506, 2919, 10508, 2173, 2450, 696, 787, 14, 1372, 8735, 10509, 1375, 4704, 10510, 19, 1740, 6834, 3010, 2247, 1396, 2281, 609, 2248, 2438, 38, 7476, 2230, 10511, 2455, 40, 702, 3110, 2185 ],
  ),
  "format_letter_spacing_standard": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf617,
    categories: [ 12 ],
    tags: [ 1128, 2167, 2169, 4, 365, 1731, 8, 2173, 1347, 696, 787, 14, 1372, 10507, 4704, 2781, 19, 366, 1740, 2263, 2180, 10512, 609, 2248, 2438, 1968, 38, 2229, 2230, 947, 40, 2271, 702, 1381, 3014, 2185 ],
  ),
  "format_letter_spacing_wide": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf616,
    categories: [ 12 ],
    tags: [ 1128, 2167, 4, 8, 10506, 10513, 2919, 10508, 2173, 8751, 696, 787, 14, 1372, 10514, 10509, 4704, 2781, 10515, 19, 1740, 2263, 609, 2248, 2438, 2249, 38, 10516, 7476, 2230, 10517, 1214, 40, 702, 1592, 6306, 2185, 2222 ],
  ),
  "format_letter_spacing_wider": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf615,
    categories: [ 12 ],
    tags: [ 685, 10505, 2167, 4, 365, 4950, 8, 10506, 2173, 8751, 8777, 787, 14, 1372, 10491, 10509, 4704, 10518, 10515, 19, 366, 2263, 609, 2248, 2438, 2249, 38, 10519, 2229, 2230, 10511, 40, 702, 1592, 10520, 2222, 10521 ],
  ),
  "format_line_spacing": SymbolsMetadata(
    popularity: 381,
    codepoint: 0xe240,
    categories: [ 12 ],
    tags: [ 10505, 2167, 2169, 1367, 380, 1528, 1347, 2450, 2840, 696, 2299, 1371, 1372, 1602, 10522, 7715, 366, 92, 788, 96, 2180, 2287, 2247, 4786, 106, 2248, 1379, 38, 2229, 2230, 441, 40, 702, 1677, 2268, 2222, 704 ],
  ),
  "format_list_bulleted": SymbolsMetadata(
    popularity: 7341,
    codepoint: 0xe241,
    categories: [ 12 ],
    tags: [ 2167, 2169, 10523, 10524, 10525, 8594, 1631, 1528, 1347, 696, 2299, 1371, 1372, 2175, 2080, 2245, 92, 788, 421, 1533, 656, 96, 10526, 65, 4786, 106, 9785, 1379, 3159, 38, 2230, 983, 791, 441, 6085, 40, 10527, 2199, 704 ],
    rtlAutoMirrored: true,
  ),
  "format_list_bulleted_add": SymbolsMetadata(
    popularity: 75,
    codepoint: 0xf849,
    categories: [ 12 ],
    tags: [ 192, 526, 1264, 1267, 2167, 2169, 1057, 1268, 10524, 10525, 8594, 1631, 383, 1201, 10528, 1528, 696, 2299, 1371, 1597, 1372, 1044, 1273, 1620, 92, 10529, 10530, 10531, 763, 10532, 1532, 1533, 656, 202, 1362, 1027, 371, 4786, 1379, 35, 38, 983, 791, 441, 40, 704 ],
    rtlAutoMirrored: true,
  ),
  "format_list_numbered": SymbolsMetadata(
    popularity: 2964,
    codepoint: 0xe242,
    categories: [ 12 ],
    tags: [ 80, 2167, 2169, 1367, 10523, 1631, 11, 1528, 696, 2299, 1371, 1372, 2175, 932, 2080, 91, 2245, 366, 92, 1533, 23, 10533, 10534, 24, 25, 94, 95, 656, 10535, 98, 10163, 3582, 104, 4786, 9785, 1379, 109, 945, 35, 1688, 38, 6085, 40, 704 ],
  ),
  "format_list_numbered_rtl": SymbolsMetadata(
    popularity: 668,
    codepoint: 0xe267,
    categories: [ 12 ],
    tags: [ 80, 2167, 2169, 1367, 11, 1528, 1347, 696, 2299, 1371, 1372, 10536, 2175, 2080, 91, 366, 92, 10537, 1533, 10533, 10534, 24, 95, 96, 10535, 940, 99, 10163, 10538, 6131, 104, 4786, 1379, 109, 945, 35, 38, 2183, 40, 704 ],
  ),
  "format_overline": SymbolsMetadata(
    popularity: 141,
    codepoint: 0xeb65,
    categories: [ 12 ],
    tags: [ 1593, 4, 1343, 8, 383, 5978, 1528, 696, 2299, 1371, 14, 1372, 2175, 2176, 1205, 4704, 19, 1602, 10539, 1081, 10540, 10541, 4786, 1379, 2182, 35, 38, 10542, 2184, 2230, 10543, 1124, 40, 702, 2942, 2498, 704 ],
  ),
  "format_paint": SymbolsMetadata(
    popularity: 1462,
    codepoint: 0xe243,
    categories: [ 12 ],
    tags: [ 10544, 2829, 5160, 5162, 1731, 4848, 1201, 1735, 299, 1528, 302, 696, 2299, 1371, 2279, 14, 1372, 2175, 3489, 53, 366, 1740, 5166, 5169, 75, 10545, 311, 4786, 1379, 32, 2182, 38, 2537, 40, 702, 704 ],
  ),
  "format_paragraph": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf865,
    categories: [ 12 ],
    tags: [ 2167, 2169, 2501, 1400, 693, 1042, 1528, 1347, 696, 2299, 1371, 2279, 1372, 2175, 10492, 10437, 10546, 1610, 10547, 2180, 10548, 10549, 2510, 2182, 38, 2229, 2230, 40, 702, 2222, 1536, 704 ],
  ),
  "format_quote": SymbolsMetadata(
    popularity: 4384,
    codepoint: 0xe244,
    categories: [ 12 ],
    tags: [ 10550, 3354, 473, 476, 1528, 1347, 10551, 696, 2299, 1371, 1372, 2175, 8815, 10552, 23, 25, 10553, 491, 3124, 10429, 4786, 493, 1379, 38, 2230, 40, 3735, 8054, 704 ],
  ),
  "format_quote_off": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf413,
    categories: [ 12 ],
    tags: [ 3354, 3355, 10434, 10554, 8141, 10555, 767, 1528, 696, 2299, 1371, 898, 1372, 10556, 2175, 1001, 1002, 8776, 907, 908, 909, 1493, 1495, 10553, 10557, 491, 4829, 10558, 10559, 4786, 914, 10560, 1379, 38, 2230, 10561, 40, 10562, 10563, 704 ],
  ),
  "format_shapes": SymbolsMetadata(
    popularity: 704,
    codepoint: 0xe25e,
    categories: [ 12 ],
    tags: [ 685, 1128, 4, 349, 7, 1731, 8, 4848, 2391, 299, 1528, 696, 8777, 2299, 1371, 2279, 14, 1372, 10423, 274, 1044, 306, 4704, 19, 1740, 1361, 5166, 2247, 2281, 5922, 4786, 1379, 32, 2182, 35, 38, 6080, 10564, 427, 40, 702, 3025, 704 ],
  ),
  "format_size": SymbolsMetadata(
    popularity: 1320,
    codepoint: 0xe245,
    categories: [ 12 ],
    tags: [ 1128, 4, 7650, 10565, 8, 4848, 2919, 2922, 1528, 696, 2299, 1371, 787, 2279, 14, 10473, 1372, 2175, 1204, 1207, 3634, 4704, 19, 5166, 2247, 2281, 4786, 2933, 673, 1979, 7649, 1379, 2182, 35, 38, 10458, 40, 4961, 702, 704, 986 ],
  ),
  "format_strikethrough": SymbolsMetadata(
    popularity: 401,
    codepoint: 0xe246,
    categories: [ 12 ],
    tags: [ 686, 4, 895, 8, 4563, 897, 1528, 696, 2299, 1371, 14, 1372, 10566, 1205, 19, 1602, 10540, 911, 10429, 4786, 1379, 2126, 2182, 35, 38, 10542, 2230, 10355, 40, 3735, 702, 2498, 2185, 704 ],
  ),
  "format_text_clip": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf82a,
    categories: [ 12 ],
    tags: [ 365, 1469, 1750, 1042, 1707, 5807, 1528, 1347, 696, 2299, 1371, 14, 1372, 2175, 2303, 2176, 10567, 1602, 366, 2180, 6073, 75, 10429, 4786, 1379, 32, 2182, 38, 10568, 7476, 2230, 10569, 10570, 40, 702, 1381, 704 ],
  ),
  "format_text_overflow": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf829,
    categories: [ 12 ],
    tags: [ 380, 365, 1042, 776, 1528, 1347, 696, 2299, 1371, 787, 2996, 1372, 2175, 306, 366, 789, 3097, 4915, 1534, 2247, 782, 4786, 1379, 38, 2230, 10571, 10094, 10569, 40, 702, 1592, 3014, 10090, 10572, 704 ],
  ),
  "format_text_wrap": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf828,
    categories: [ 12 ],
    tags: [ 380, 9646, 10573, 1042, 3121, 1528, 1347, 696, 2299, 1371, 1372, 10574, 2175, 10492, 306, 2875, 10083, 366, 10575, 1534, 2180, 2495, 4786, 1379, 38, 2230, 10094, 10569, 1214, 40, 10090, 4379, 10572, 704 ],
  ),
  "format_textdirection_l_to_r": SymbolsMetadata(
    popularity: 146,
    codepoint: 0xe247,
    categories: [ 12 ],
    tags: [ 2167, 2169, 380, 388, 1528, 696, 2299, 1371, 1372, 2175, 2176, 8966, 10576, 306, 10577, 8968, 10578, 2180, 2228, 10579, 1396, 782, 6131, 4786, 1379, 38, 2183, 10580, 2229, 10088, 10569, 40, 702, 2222, 704, 10581 ],
  ),
  "format_textdirection_r_to_l": SymbolsMetadata(
    popularity: 133,
    codepoint: 0xe248,
    categories: [ 12 ],
    tags: [ 2167, 2169, 10582, 10583, 10584, 8102, 1528, 696, 2299, 1371, 10585, 1372, 10586, 10587, 8966, 10588, 10576, 2875, 8968, 10578, 10589, 2180, 10590, 10591, 782, 6130, 6131, 4786, 1379, 10592, 38, 2183, 10580, 10569, 40, 10593, 704 ],
  ),
  "format_textdirection_vertical": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf4b8,
    categories: [ 12 ],
    tags: [ 2167, 2321, 2169, 2650, 1368, 6687, 388, 1528, 2840, 2924, 696, 2299, 1371, 1372, 2175, 306, 10578, 3147, 2180, 2228, 854, 5503, 10594, 396, 10595, 4786, 1379, 38, 10580, 2230, 2323, 10569, 40, 2271, 702, 1381, 2199, 10596, 704 ],
  ),
  "format_underlined": SymbolsMetadata(
    popularity: 1243,
    codepoint: 0xe249,
    categories: [ 12 ],
    tags: [ 4, 4821, 8, 1528, 696, 2299, 1371, 14, 10351, 1372, 10597, 2175, 1205, 10598, 19, 1602, 10429, 4786, 1379, 2182, 35, 38, 10542, 2229, 10599, 10355, 40, 702, 9751, 2942, 10600, 2498, 10601, 10454, 4823, 2185, 704 ],
  ),
  "format_underlined_squiggle": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xf885,
    categories: [ 12 ],
    tags: [ 4, 4820, 8, 2332, 1528, 1347, 696, 2299, 1371, 14, 1372, 2175, 10598, 19, 1602, 10429, 4786, 1379, 8530, 2182, 35, 38, 10542, 2229, 2230, 10355, 40, 702, 10602, 9664, 2942, 2498, 10603, 10601, 10454, 10604, 1862, 8932, 10605, 10606, 2222, 704 ],
  ),
  "forms_add_on": SymbolsMetadata(
    popularity: 686,
    codepoint: 0xf0c7,
    categories: [ 12 ],
    tags: [ 526, 1341, 10607, 10608, 1264, 10609, 1596, 1057, 1201, 1526, 10610, 10528, 1347, 5243, 1598, 10611, 2080, 1044, 1620, 2245, 92, 7506, 763, 10612, 1611, 202, 1212, 441 ],
  ),
  "forms_apps_script": SymbolsMetadata(
    popularity: 164,
    codepoint: 0xf0c8,
    categories: [ 12 ],
    tags: [ 949, 1230, 1367, 2148, 266, 1776, 954, 1733, 1781, 1735, 1347, 696, 1597, 10611, 2738, 966, 92, 1755, 1740, 656, 96, 3021, 1783, 329, 3379, 288, 65, 106, 1645, 2746 ],
  ),
  "fort": SymbolsMetadata(
    popularity: 308,
    codepoint: 0xeaad,
    categories: [ 5 ],
    tags: [ 5897, 4309, 2601, 5898, 798, 5899, 5900, 10613, 2854, 5902, 5903, 5904, 5905, 697, 6105, 1023, 5906, 3343, 5907, 5908, 10614, 5909, 10615, 1520, 5910, 1772, 602, 1011, 5912, 2620, 4679 ],
  ),
  "forum": SymbolsMetadata(
    popularity: 12846,
    codepoint: 0xe0bf,
    categories: [ 7 ],
    tags: [ 5171, 10616, 6950, 471, 5173, 472, 473, 474, 443, 194, 476, 5255, 10617, 478, 480, 481, 482, 3236, 485, 6052, 10618, 10619, 10620, 10621, 10622, 1410, 77, 493, 494, 495, 496, 10623 ],
  ),
  "forward": SymbolsMetadata(
    popularity: 3579,
    codepoint: 0xe154,
    categories: [ 2 ],
    tags: [ 380, 776, 3121, 388, 2450, 1471, 777, 10624, 10625, 935, 2340, 485, 421, 780, 10626, 1586, 283, 1409, 781, 5481, 10627, 10628, 1396, 782, 1503, 2343, 10629, 1665, 3058, 982, 31, 6772, 2007 ],
    rtlAutoMirrored: true,
  ),
  "forward_10": SymbolsMetadata(
    popularity: 1068,
    codepoint: 0xe056,
    categories: [ 0 ],
    tags: [ 10630, 43, 775, 380, 9564, 383, 269, 785, 11, 1020, 1022, 8453, 777, 10631, 1217, 9561, 390, 2903, 326, 2081, 421, 780, 10632, 24, 2162, 283, 28, 3515, 396, 287, 2966, 10633, 10634, 35, 8033, 1033, 41, 291 ],
  ),
  "forward_30": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xe057,
    categories: [ 0 ],
    tags: [ 263, 10635, 10636, 775, 380, 383, 384, 2907, 269, 785, 11, 1020, 1022, 8453, 777, 10637, 9561, 390, 367, 2081, 421, 780, 10638, 24, 2904, 781, 2367, 3515, 396, 287, 2966, 10639, 35, 373, 289, 41 ],
  ),
  "forward_5": SymbolsMetadata(
    popularity: 358,
    codepoint: 0xe058,
    categories: [ 0 ],
    tags: [ 43, 564, 775, 10640, 380, 2490, 2907, 776, 269, 785, 11, 1022, 8453, 4707, 777, 10641, 1217, 9561, 10642, 390, 2903, 2081, 421, 780, 10643, 24, 2904, 781, 28, 2367, 3515, 396, 287, 2966, 10644, 109, 35, 41 ],
  ),
  "forward_circle": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf6f5,
    categories: [ 0 ],
    tags: [ 775, 380, 383, 2490, 776, 269, 785, 385, 11, 388, 1022, 777, 9561, 390, 2903, 778, 2081, 421, 780, 24, 2904, 781, 28, 424, 425, 2367, 3515, 1396, 396, 889, 287, 2966, 3935, 35, 2571, 41 ],
  ),
  "forward_media": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf6f4,
    categories: [ 0 ],
    tags: [ 775, 380, 1129, 2490, 2907, 776, 269, 785, 11, 1022, 8453, 10645, 777, 9561, 390, 367, 2903, 2081, 779, 421, 780, 24, 283, 2904, 781, 28, 2367, 3515, 1396, 396, 287, 2966, 1156, 35, 41 ],
  ),
  "forward_to_inbox": SymbolsMetadata(
    popularity: 3244,
    codepoint: 0xf187,
    categories: [ 7 ],
    tags: [ 380, 419, 443, 475, 2331, 7762, 388, 1578, 2335, 3286, 10646, 1672, 777, 851, 135, 4704, 19, 2340, 485, 10647, 421, 486, 4187, 10648, 75, 5481, 8544, 1396, 782, 2343, 10649, 1665, 32, 1689, 2007, 1701 ],
    rtlAutoMirrored: true,
  ),
  "foundation": SymbolsMetadata(
    popularity: 1067,
    codepoint: 0xf200,
    categories: [ 8 ],
    tags: [ 2601, 4310, 10650, 6387, 10651, 4862, 798, 4865, 2832, 2625, 2605, 10652, 3419, 3929, 999, 1435, 5073, 3362, 822, 1444, 2614, 1445, 2616, 823, 10653, 2536, 945, 495, 441, 1701, 10654 ],
  ),
  "fragrance": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf345,
    categories: [ 8 ],
    tags: [ 1864, 1865, 1867, 10655, 1869, 10656, 10657, 1872, 956, 1874, 10658, 3972, 1877, 1878, 10659, 1879, 3974, 10660, 1880, 1881, 1882, 1883, 1884, 10661, 10662, 10663, 8573 ],
  ),
  "frame_inspect": SymbolsMetadata(
    popularity: 210,
    codepoint: 0xf772,
    categories: [ 12 ],
    tags: [ 2513, 3811, 349, 2584, 3909, 2391, 545, 132, 5575, 958, 959, 960, 1738, 274, 10664, 276, 10665, 4294, 1489, 1001, 971, 974, 976, 307, 10666, 1496, 5972, 10278, 1723, 2812, 980, 981, 288, 371, 32, 36, 1071, 317, 986 ],
  ),
  "frame_person": SymbolsMetadata(
    popularity: 786,
    codepoint: 0xf8a6,
    categories: [ 0 ],
    tags: [ 468, 470, 8702, 584, 349, 2584, 3909, 47, 116, 1730, 2391, 2805, 1738, 274, 5969, 483, 2810, 850, 53, 885, 1361, 488, 489, 59, 119, 854, 490, 3583, 1723, 288, 32, 36, 2165, 947, 501, 2814, 986 ],
  ),
  "frame_person_mic": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf4d5,
    categories: [ 0 ],
    tags: [ 1129, 10667, 470, 584, 349, 2584, 355, 1133, 116, 1730, 443, 1135, 2391, 1136, 274, 10668, 1139, 1140, 483, 1142, 969, 1146, 1147, 1148, 488, 489, 1152, 490, 121, 1154, 177, 1156, 1157, 493, 10669, 32, 342, 2165, 947, 501, 41, 540, 1161, 10670 ],
  ),
  "frame_person_off": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf7d1,
    categories: [ 0 ],
    tags: [ 1074, 584, 349, 2584, 895, 1730, 2391, 4563, 897, 1077, 767, 898, 10671, 274, 10672, 10673, 10674, 10675, 900, 483, 10676, 10677, 905, 906, 907, 908, 909, 488, 489, 10678, 10679, 10680, 910, 10681, 10682, 911, 914, 32, 2126, 2165, 947, 916, 10683, 10684, 3736 ],
  ),
  "frame_reload": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf771,
    categories: [ 12 ],
    tags: [ 2284, 380, 349, 2584, 47, 116, 2490, 2391, 3523, 385, 274, 276, 53, 3524, 3513, 2568, 390, 59, 119, 424, 425, 2494, 2367, 426, 3516, 10685, 2496, 396, 5664, 5491, 32, 1667, 402, 2499, 1260, 2814, 1054 ],
  ),
  "frame_source": SymbolsMetadata(
    popularity: 71,
    codepoint: 0xf770,
    categories: [ 12 ],
    tags: [ 419, 349, 2584, 3909, 10686, 2862, 10687, 2624, 6580, 1042, 2391, 1201, 2625, 3593, 2970, 2628, 10688, 274, 10689, 276, 53, 1542, 966, 1044, 3092, 10690, 935, 367, 421, 3362, 288, 10691, 3364, 32, 41 ],
  ),
  "free_cancellation": SymbolsMetadata(
    popularity: 1323,
    codepoint: 0xe748,
    categories: [ 6 ],
    tags: [ 1627, 1015, 1549, 1936, 5341, 895, 10692, 1731, 1630, 1632, 3436, 1633, 1636, 1202, 1017, 5035, 1018, 897, 1639, 696, 2094, 2985, 2203, 1917, 7310, 10693, 2607, 1641, 1740, 5347, 4152, 4159, 1643, 1030, 911, 1924, 1031, 288, 1083, 1647, 1504, 2386, 1523, 3736, 1650 ],
  ),
  "front_hand": SymbolsMetadata(
    popularity: 2702,
    codepoint: 0xe769,
    categories: [ 3 ],
    tags: [ 733, 1074, 954, 269, 2734, 4707, 777, 3616, 5500, 10694, 2735, 5659, 6155, 3448, 2738, 10695, 8989, 10696, 2139, 966, 8063, 8707, 2743, 1082, 3012, 8991, 204, 1083, 495, 8035 ],
  ),
  "front_loader": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf869,
    categories: [ 9 ],
    tags: [ 1812, 6359, 4862, 798, 10697, 3723, 953, 2832, 10698, 10699, 10700, 10701, 10702, 10703, 7114, 1825, 10704, 10705, 10706, 6923, 10707, 3513, 6411, 1834, 7116, 6374, 10708, 2882, 7119, 1840, 1701, 1843, 4340, 1844, 1459 ],
  ),
  "full_coverage": SymbolsMetadata(
    popularity: 158,
    codepoint: 0xeb12,
    categories: [ 12 ],
    tags: [ 1230, 2501, 2301, 10709, 1042, 4365, 10710, 12, 1216, 787, 2242, 2393, 4043, 10711, 2395, 135, 2751, 306, 4696, 2307, 2503, 4986, 1081, 1770, 1535, 2400, 2648, 10712, 2247, 2281, 3099, 2249, 8344, 10713, 317, 6306, 2309, 1054, 8350, 986 ],
  ),
  "full_hd": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf58b,
    categories: [ 0 ],
    tags: [ 318, 10714, 4, 2301, 7, 47, 8, 12, 325, 10715, 14, 274, 10716, 256, 2471, 257, 10717, 19, 327, 278, 328, 75, 30, 77, 330, 331, 342, 35, 343, 38, 344, 40, 41, 291, 334, 292, 2309 ],
  ),
  "full_stacked_bar_chart": SymbolsMetadata(
    popularity: 642,
    codepoint: 0xf212,
    categories: [ 9 ],
    tags: [ 5, 1343, 1344, 365, 1284, 920, 802, 1633, 10, 4291, 924, 808, 4043, 929, 933, 2518, 597, 634, 937, 28, 75, 1353, 1354, 32, 107, 1069, 33, 440, 947, 2253, 1355 ],
  ),
  "fullscreen": SymbolsMetadata(
    popularity: 6892,
    codepoint: 0xe5d0,
    categories: [ 2 ],
    tags: [ 1128, 1229, 1230, 419, 2750, 2391, 12, 1216, 787, 10718, 2393, 3089, 997, 4043, 2395, 1673, 53, 389, 2751, 10719, 2307, 10720, 367, 327, 10721, 2904, 5592, 2281, 330, 2882, 673, 2249, 2757, 2759, 41, 317, 1691, 1053, 2309, 1054, 986 ],
  ),
  "fullscreen_exit": SymbolsMetadata(
    popularity: 2912,
    codepoint: 0xe5d1,
    categories: [ 2 ],
    tags: [ 1128, 1229, 1230, 419, 2950, 2750, 3086, 2919, 2391, 6437, 2985, 6439, 997, 10722, 4043, 1673, 3090, 2751, 10690, 10719, 2928, 6442, 10723, 6444, 2930, 3749, 2496, 330, 2933, 2882, 673, 10724, 6446, 2757, 10725, 10726, 2759, 317, 1691, 1053, 1054, 10727, 2402 ],
  ),
  "fullscreen_portrait": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf45a,
    categories: [ 2 ],
    tags: [ 1229, 1230, 2301, 349, 7, 2750, 445, 12, 787, 2242, 274, 4043, 2395, 1673, 2751, 306, 2307, 219, 10728, 3147, 226, 5661, 854, 1496, 75, 2247, 2281, 330, 5663, 5664, 2882, 673, 2249, 447, 8281, 2757, 2759, 1381, 317, 1691, 1053, 1054, 986 ],
  ),
  "function": SymbolsMetadata(
    popularity: 354,
    codepoint: 0xf866,
    categories: [ 12 ],
    tags: [ 4701, 10729, 2513, 3557, 1199, 2375, 10730, 10731, 9, 7019, 1528, 696, 2299, 1371, 3153, 2835, 2377, 10732, 2378, 963, 10733, 10734, 10735, 929, 3375, 9112, 10736, 1210, 2380, 10737, 10738, 2424, 3379, 4786, 5337, 1379, 2182, 461, 35, 38, 40, 7025, 704 ],
  ),
  "functions": SymbolsMetadata(
    popularity: 1654,
    codepoint: 0xe24a,
    categories: [ 12 ],
    tags: [ 526, 1197, 10729, 3498, 5, 3557, 1199, 2375, 10730, 2624, 9, 7019, 4291, 1528, 696, 2299, 1371, 2835, 2377, 2378, 963, 10734, 10739, 1210, 2380, 2630, 9281, 4786, 2382, 1379, 33, 205, 2182, 461, 2383, 35, 38, 191, 40, 704 ],
  ),
  "funicular": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf477,
    categories: [ 14 ],
    tags: [ 5276, 1814, 5277, 5278, 1815, 1816, 2467, 2063, 9494, 388, 8457, 5281, 5282, 8910, 8912, 10740, 1490, 1544, 5283, 10741, 2071, 4601, 4618, 4619, 4202, 5286, 8008, 4621, 2023, 4622, 4623, 2008, 1930, 1504, 1625, 10742, 1844 ],
    rtlAutoMirrored: true,
  ),
  "g_mobiledata": SymbolsMetadata(
    popularity: 157,
    codepoint: 0xf010,
    categories: [ 4 ],
    tags: [ 4, 208, 210, 429, 10743, 8, 211, 212, 10, 213, 510, 14, 10744, 215, 216, 10745, 10746, 19, 219, 433, 221, 10747, 516, 223, 517, 226, 437, 78, 2631, 227, 10748, 35, 38, 40, 234, 235 ],
  ),
  "g_mobiledata_badge": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf7e1,
    categories: [ 4 ],
    tags: [ 4, 6, 208, 210, 8, 443, 211, 212, 10, 213, 444, 510, 14, 10744, 215, 432, 10746, 19, 219, 433, 241, 434, 221, 10749, 223, 242, 226, 5955, 78, 2631, 227, 228, 32, 35, 38, 40, 234, 235 ],
  ),
  "g_translate": SymbolsMetadata(
    popularity: 2133,
    codepoint: 0xe927,
    categories: [ 7 ],
    tags: [ 4, 8, 443, 7106, 4702, 3577, 10750, 8963, 10744, 5070, 1189, 10751, 7414, 10752, 5651, 4704, 8050, 8968, 2528, 1641, 8969, 10753, 10754, 1172, 493, 32, 35, 38, 7110, 8052, 10755, 9210, 7334 ],
  ),
  "gallery_thumbnail": SymbolsMetadata(
    popularity: 127,
    codepoint: 0xf86f,
    categories: [ 1 ],
    tags: [ 1538, 5123, 2155, 958, 1541, 246, 930, 16, 53, 5799, 1543, 2159, 1755, 367, 1544, 1545, 2557, 98, 59, 61, 5800, 119, 5801, 10278, 75, 1546, 288, 32, 107, 858, 317 ],
  ),
  "gamepad": SymbolsMetadata(
    popularity: 107,
    codepoint: 0xe30f,
    categories: [ 11 ],
    tags: [ 688, 419, 952, 3233, 269, 5258, 1202, 10756, 445, 388, 10757, 2651, 3337, 3089, 697, 10758, 10759, 5260, 5014, 338, 966, 1375, 1858, 421, 2162, 10760, 2904, 10761, 202, 1396, 108, 1676, 41, 574 ],
  ),
  "garage": SymbolsMetadata(
    popularity: 937,
    codepoint: 0xf011,
    categories: [ 8 ],
    tags: [ 1814, 3467, 7, 798, 1815, 1816, 388, 5500, 3471, 10762, 999, 1435, 16, 2484, 1001, 1002, 1490, 421, 4319, 1444, 1445, 1446, 2617, 32, 674, 1298, 1299, 35, 1842, 1930, 1504, 1844 ],
  ),
  "garage_door": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xe714,
    categories: [ 8 ],
    tags: [ 2601, 1132, 2148, 798, 1815, 2950, 269, 2604, 6104, 2985, 10763, 3471, 10764, 5647, 999, 2080, 1435, 16, 2653, 4319, 1444, 2616, 823, 1011, 2617, 1901, 674, 945, 35, 441 ],
  ),
  "garage_home": SymbolsMetadata(
    popularity: 1069,
    codepoint: 0xe82d,
    categories: [ 8 ],
    tags: [ 755, 2601, 8442, 798, 1815, 2950, 269, 6103, 6104, 3471, 10764, 6105, 999, 3235, 1435, 1004, 2653, 4319, 1444, 1445, 1446, 2616, 823, 1011, 2617, 1901, 674, 945, 441, 1214 ],
  ),
  "garden_cart": SymbolsMetadata(
    popularity: 764,
    codepoint: 0xf8a9,
    categories: [ 3 ],
    tags: [ 1812, 3723, 1619, 2832, 1269, 6371, 1822, 1825, 7630, 6816, 10765, 6817, 3489, 10766, 10707, 778, 1860, 10397, 10767, 1839, 2537, 2756, 1842, 2344, 773, 10768, 1459, 7642 ],
  ),
  "gas_meter": SymbolsMetadata(
    popularity: 498,
    codepoint: 0xec19,
    categories: [ 8 ],
    tags: [ 798, 10769, 8876, 1269, 6626, 4471, 3779, 926, 2790, 9190, 1854, 3560, 999, 1435, 188, 6924, 2472, 2798, 597, 634, 3561, 327, 10770, 1004, 4459, 10771, 8467, 7119, 9948, 7570, 6367, 2801 ],
  ),
  "gastroenterology": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xe0f1,
    categories: [ 3 ],
    tags: [ 10772, 3919, 10773, 584, 10774, 1749, 10775, 10776, 10777, 10778, 10779, 1751, 10780, 10781, 10782, 10783, 10784, 10785, 10786, 10787, 10788, 10789, 595, 1753, 1754, 483, 4635, 10790, 10791, 10792, 1757, 10793, 10794, 10795 ],
  ),
  "gate": SymbolsMetadata(
    popularity: 470,
    codepoint: 0xe277,
    categories: [ 8 ],
    tags: [ 755, 4309, 2601, 10796, 7654, 9645, 9646, 994, 798, 802, 1202, 1370, 2604, 6103, 6104, 1597, 2985, 9648, 7630, 6816, 6105, 9649, 999, 1435, 852, 10797, 1859, 1004, 9660, 1860, 3841, 1068, 8437, 2865, 822, 202, 5653, 1517, 1520, 3310, 1009, 1011, 2264, 945, 1054, 7642 ],
  ),
  "gavel": SymbolsMetadata(
    popularity: 4777,
    codepoint: 0xe90e,
    categories: [ 3 ],
    tags: [ 7026, 10798, 10799, 2730, 4296, 10800, 1074, 10801, 2919, 3815, 3027, 1347, 10802, 812, 6921, 10803, 3822, 3823, 816, 10804, 10805, 817, 10806, 10807, 7030, 96, 8616, 10808, 75, 601, 2181, 32, 4651, 7033, 441, 10809, 10810 ],
  ),
  "general_device": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xe6de,
    categories: [ 11 ],
    tags: [ 3210, 3213, 1343, 4871, 443, 921, 211, 10811, 445, 10812, 3216, 10813, 1711, 2590, 10814, 10815, 1189, 3905, 965, 999, 1435, 215, 1602, 219, 1675, 1004, 223, 226, 4029, 75, 5716, 77, 1155, 446, 447, 551, 4194, 234 ],
  ),
  "genetics": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xe0f3,
    categories: [ 3 ],
    tags: [ 2513, 10816, 10817, 10818, 2412, 4346, 6887, 6891, 10819, 10820, 10821, 6894, 10822, 10823, 4349, 10824, 595, 1753, 10825, 6895, 10826, 10827, 9962, 4353, 1757, 6900, 10828, 10829, 4359, 2424, 10830 ],
  ),
  "genres": SymbolsMetadata(
    popularity: 67,
    codepoint: 0xe022,
    categories: [ 0 ],
    tags: [ 1129, 3389, 3453, 5918, 383, 2155, 10831, 2159, 10832, 2081, 10833, 3131, 3132, 9566, 3394, 1532, 2162, 10834, 10835, 2163, 1257, 889, 2164, 10836, 1156, 108, 10837, 5924, 1744 ],
  ),
  "gesture": SymbolsMetadata(
    popularity: 1054,
    codepoint: 0xe155,
    categories: [ 6 ],
    tags: [ 10838, 954, 269, 2332, 8522, 2834, 302, 9914, 8523, 2735, 9416, 2738, 8524, 16, 966, 4895, 1602, 390, 420, 1858, 1586, 8526, 311, 7494, 227, 2463, 8530, 9532, 7229, 35, 10839, 8035, 2165, 3938, 1862 ],
  ),
  "gesture_select": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xf657,
    categories: [ 6 ],
    tags: [ 733, 3638, 266, 1776, 269, 1781, 2448, 2449, 956, 9914, 2735, 246, 2738, 10840, 966, 4895, 4896, 2753, 219, 421, 3635, 3021, 1363, 1783, 3017, 330, 288, 371, 944, 4008, 8035, 10841 ],
  ),
  "gif": SymbolsMetadata(
    popularity: 504,
    codepoint: 0xe908,
    categories: [ 1 ],
    tags: [ 4, 2564, 10842, 264, 1058, 9741, 8, 473, 1042, 337, 3337, 14, 1372, 6700, 2551, 10843, 305, 53, 1044, 9730, 19, 390, 391, 367, 10844, 485, 2555, 328, 1409, 1564, 1665, 3058, 2561, 31, 35, 38, 40, 346, 10845 ],
  ),
  "gif_2": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf40e,
    categories: [ 1 ],
    tags: [ 2544, 10846, 264, 1469, 337, 2551, 10847, 10848, 10849, 10850, 9742, 10851, 390, 391, 367, 2555, 2556, 328, 119, 1564, 10852, 3515, 1665, 2561, 31, 346 ],
  ),
  "gif_box": SymbolsMetadata(
    popularity: 763,
    codepoint: 0xe7a3,
    categories: [ 1 ],
    tags: [ 526, 4, 2564, 2544, 10853, 264, 1058, 9741, 7, 8, 266, 1269, 337, 3540, 7385, 14, 1372, 2551, 10854, 10847, 10855, 305, 10850, 53, 1044, 9730, 4704, 19, 367, 2555, 328, 119, 288, 1665, 32, 35, 38, 40, 346 ],
  ),
  "girl": SymbolsMetadata(
    popularity: 676,
    codepoint: 0xeb68,
    categories: [ 3 ],
    tags: [ 3325, 468, 470, 584, 383, 9398, 10856, 1790, 9613, 4408, 1791, 1659, 8851, 483, 16, 9614, 8855, 853, 488, 489, 1967, 490, 3610, 6201, 105, 10857, 607, 4940, 35, 1885, 1701, 501, 3613, 5011, 8858, 10858 ],
  ),
  "gite": SymbolsMetadata(
    popularity: 607,
    codepoint: 0xe58b,
    categories: [ 16 ],
    tags: [ 2599, 2601, 798, 5203, 5262, 5204, 1817, 1434, 2605, 10859, 3471, 10860, 10861, 999, 7191, 10862, 1435, 2608, 2610, 1490, 1495, 1444, 2614, 1445, 1446, 2616, 823, 1838, 2617, 10863, 3846, 945, 5209, 10864, 7193 ],
  ),
  "glass_cup": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf6e3,
    categories: [ 15 ],
    tags: [ 10865, 1343, 10866, 4381, 3792, 1269, 6609, 3799, 4388, 10867, 10868, 3800, 2926, 1829, 964, 10869, 3802, 10870, 1361, 10871, 8956, 3807, 10872, 6201, 10873, 10874, 441, 10875, 6368, 2801, 10876, 10877 ],
  ),
  "globe": SymbolsMetadata(
    popularity: 453,
    codepoint: 0xe64c,
    categories: [ 5 ],
    tags: [ 733, 383, 384, 443, 211, 4292, 8673, 958, 2469, 5070, 5071, 7414, 215, 5651, 1001, 1002, 421, 223, 5652, 396, 397, 3423, 3424, 5081, 399, 6640, 374, 1504, 10878, 1053, 4761, 5655 ],
  ),
  "globe_asia": SymbolsMetadata(
    popularity: 184,
    codepoint: 0xf799,
    categories: [ 5 ],
    tags: [ 10879, 7453, 10880, 383, 10881, 8673, 10882, 10883, 10884, 10885, 2469, 5070, 10886, 8964, 10887, 5071, 10888, 10889, 7414, 215, 5651, 1001, 1002, 8690, 5652, 1008, 10890, 5081, 10891, 1504, 1053, 4761, 5655 ],
  ),
  "globe_book": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf3c9,
    categories: [ 3 ],
    tags: [ 4701, 1910, 10892, 5875, 3374, 8673, 3153, 10893, 10894, 10895, 10896, 5071, 10897, 10898, 10899, 215, 4686, 5651, 3375, 2159, 10900, 10901, 3463, 5652, 2506, 2507, 4359, 10902, 1053, 4761, 10903, 10904, 5655 ],
  ),
  "globe_location_pin": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xf35d,
    categories: [ 5 ],
    tags: [ 1429, 8935, 1484, 388, 4292, 8673, 958, 960, 1486, 1487, 5070, 5071, 10905, 1488, 7414, 215, 5651, 1001, 1002, 1490, 21, 421, 909, 1493, 1494, 1495, 5652, 1783, 1496, 980, 2165, 1504, 1053, 4761, 10906, 5655 ],
  ),
  "globe_uk": SymbolsMetadata(
    popularity: 82,
    codepoint: 0xf798,
    categories: [ 5 ],
    tags: [ 10907, 10908, 383, 4752, 8673, 7427, 9173, 958, 2469, 5070, 5071, 7431, 7414, 215, 5651, 1001, 1002, 421, 5652, 1008, 5081, 10891, 1504, 7437, 7438, 1053, 4761, 8970, 5655 ],
  ),
  "glucose": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xe4a0,
    categories: [ 3 ],
    tags: [ 4463, 4465, 10909, 10910, 4467, 584, 1630, 1776, 10911, 1500, 4471, 9914, 10912, 10913, 10914, 10915, 10916, 2738, 595, 3863, 1753, 483, 597, 1757, 327, 1363, 4008, 3160, 8035, 2165 ],
  ),
  "glyphs": SymbolsMetadata(
    popularity: 320,
    codepoint: 0xf8a3,
    categories: [ 12 ],
    tags: [ 4, 8993, 8, 10344, 443, 1550, 14, 10917, 10918, 8997, 10587, 8966, 10588, 5651, 10919, 4704, 8968, 6413, 4142, 3379, 7494, 35, 8998, 4960, 38, 8052, 40, 702, 704 ],
  ),
  "go_to_line": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf71d,
    categories: [ 2 ],
    tags: [ 2624, 6580, 1781, 2625, 588, 956, 1371, 5648, 10920, 10921, 6585, 9561, 10922, 10923, 1001, 778, 779, 421, 1496, 2630, 2264, 2966, 6590, 10924, 32, 944, 38, 2229, 9210, 1381 ],
  ),
  "golf_course": SymbolsMetadata(
    popularity: 861,
    codepoint: 0xeb45,
    categories: [ 16 ],
    tags: [ 989, 8149, 8456, 10925, 383, 10926, 6187, 4684, 1484, 388, 3337, 4720, 10927, 697, 10928, 10929, 10930, 10931, 10932, 10933, 6818, 6190, 8426, 3344, 1001, 1002, 21, 421, 1493, 2613, 10934, 10935, 3347, 3595, 2712, 6195, 1701 ],
  ),
  "gondola_lift": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf476,
    categories: [ 14 ],
    tags: [ 2464, 10936, 1814, 5277, 10937, 10938, 1815, 1816, 5280, 388, 5282, 10939, 2018, 1490, 1544, 5283, 10940, 1860, 2071, 4618, 4619, 3347, 5999, 5286, 5287, 8461, 10941, 10942, 4621, 2023, 4622, 4623, 2008, 1842, 1930, 1504, 1625, 10742, 2024, 1844, 732, 5289 ],
    rtlAutoMirrored: true,
  ),
  "google_home_devices": SymbolsMetadata(
    popularity: 103,
    codepoint: 0xe715,
    categories: [ 11 ],
    tags: [ 1129, 10943, 2053, 1684, 5865, 7932, 10944, 1685, 445, 10945, 7953, 12, 3337, 1189, 6261, 10946, 10947, 965, 999, 3235, 10948, 3407, 367, 327, 2081, 10949, 2056, 10950, 1901, 5871, 1156, 1157, 342, 343, 344, 41, 1691 ],
  ),
  "google_tv_remote": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf5db,
    categories: [ 10 ],
    tags: [ 10951, 952, 10952, 383, 10953, 5258, 445, 10954, 956, 1711, 3337, 1189, 10955, 246, 965, 10948, 10956, 367, 10957, 421, 1004, 10958, 5185, 5716, 10959, 77, 10960, 10961, 10962, 343, 10963, 344, 10964, 9142 ],
  ),
  "google_wifi": SymbolsMetadata(
    popularity: 291,
    codepoint: 0xe840,
    categories: [ 10 ],
    tags: [ 10965, 208, 443, 268, 211, 269, 10, 445, 10966, 1189, 10967, 965, 5089, 10968, 215, 432, 1755, 219, 10969, 1004, 10970, 223, 10971, 10972, 190, 5085, 1723, 2631, 65, 227, 1901, 551, 2146, 233, 234, 442 ],
  ),
  "gpp_bad": SymbolsMetadata(
    popularity: 1308,
    codepoint: 0xf012,
    categories: [ 4 ],
    tags: [ 892, 469, 10211, 1074, 8438, 895, 1510, 2950, 10973, 1202, 3176, 897, 1077, 2766, 2985, 10974, 9045, 3696, 4152, 907, 1516, 1517, 2772, 1519, 1520, 911, 912, 1011, 1522, 10975, 1083, 4677, 10976, 1523, 7539, 1261, 3736 ],
  ),
  "gpp_maybe": SymbolsMetadata(
    popularity: 1656,
    codepoint: 0xf014,
    categories: [ 4 ],
    tags: [ 3175, 755, 469, 3073, 1693, 1510, 10973, 3176, 10977, 3245, 2766, 2767, 10974, 1251, 135, 9045, 1641, 10029, 6528, 486, 2858, 10978, 1516, 1517, 1519, 1520, 10979, 5861, 602, 1011, 10980, 1522, 10975, 35, 9019, 4677, 10981, 1364, 10982, 1523, 7539, 1261 ],
  ),
  "gradient": SymbolsMetadata(
    popularity: 464,
    codepoint: 0xe3e9,
    categories: [ 1 ],
    tags: [ 1128, 5060, 4383, 10983, 4848, 10984, 10985, 10986, 10987, 9154, 10988, 696, 2299, 2567, 4543, 959, 4544, 10989, 6684, 53, 4534, 10990, 4554, 5799, 4588, 10991, 4557, 61, 119, 5801, 3276, 27, 10992, 10993, 944, 2571, 2572 ],
  ),
  "grading": SymbolsMetadata(
    popularity: 913,
    codepoint: 0xea4f,
    categories: [ 12 ],
    tags: [ 10994, 10995, 10996, 10997, 10998, 10999, 11000, 1627, 2716, 6081, 2717, 1549, 2480, 11001, 2514, 1630, 1631, 1632, 1633, 1635, 1639, 3819, 6790, 1640, 3065, 11002, 3182, 366, 92, 3184, 7196, 11003, 1645, 3159, 1647, 2387 ],
    rtlAutoMirrored: true,
  ),
  "grain": SymbolsMetadata(
    popularity: 802,
    codepoint: 0xe3ea,
    categories: [ 1 ],
    tags: [ 1812, 8600, 8826, 3789, 11004, 953, 6316, 2155, 4386, 11005, 956, 696, 2299, 2567, 3327, 1825, 959, 1829, 4975, 930, 1831, 53, 5799, 8833, 4357, 2557, 11006, 3635, 61, 119, 5801, 11007, 11008, 11009, 11010, 11011, 2438, 3636 ],
  ),
  "graph_1": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf3a0,
    categories: [ 9 ],
    tags: [ 3498, 5, 1994, 3026, 920, 1061, 921, 211, 6768, 10, 7515, 924, 926, 3501, 929, 932, 3236, 933, 1064, 935, 11012, 1067, 411, 223, 3282, 939, 940, 1586, 10411, 3505, 945, 948, 2746 ],
  ),
  "graph_2": SymbolsMetadata(
    popularity: 52,
    codepoint: 0xf39f,
    categories: [ 9 ],
    tags: [ 2513, 5, 1994, 1284, 920, 921, 211, 5242, 10, 923, 924, 926, 3501, 930, 932, 3236, 933, 934, 935, 936, 411, 223, 3282, 939, 940, 941, 2107, 8006, 6193, 945, 946, 948, 2746 ],
  ),
  "graph_3": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf39e,
    categories: [ 9 ],
    tags: [ 2513, 5, 3026, 920, 953, 6316, 1061, 921, 211, 10, 924, 2173, 926, 929, 930, 932, 3236, 933, 1064, 366, 935, 1002, 1067, 411, 223, 3282, 939, 940, 3641, 8006, 1665, 945, 374, 948 ],
  ),
  "graph_4": SymbolsMetadata(
    popularity: 36,
    codepoint: 0xf39d,
    categories: [ 9 ],
    tags: [ 2513, 5, 1994, 3026, 920, 953, 921, 11013, 211, 10, 924, 2173, 2210, 787, 6664, 926, 927, 929, 932, 3236, 933, 366, 935, 411, 223, 3282, 939, 940, 8006, 945, 983, 11014, 948, 11015, 1355, 2519 ],
  ),
  "graph_5": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf39c,
    categories: [ 9 ],
    tags: [ 2513, 5, 920, 953, 384, 6316, 921, 11013, 211, 10, 924, 956, 926, 2433, 929, 930, 932, 3236, 933, 935, 411, 223, 11016, 3282, 939, 656, 940, 9895, 5039, 8006, 945, 2632, 1355 ],
  ),
  "graph_6": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf39b,
    categories: [ 9 ],
    tags: [ 580, 5, 2170, 920, 953, 384, 6316, 921, 211, 10, 924, 956, 929, 11017, 930, 3236, 933, 411, 223, 939, 940, 3635, 11018, 3641, 1257, 1786, 104, 2570, 7207, 33, 945, 1355 ],
  ),
  "graph_7": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf346,
    categories: [ 9 ],
    tags: [ 636, 2513, 5, 920, 921, 6768, 10, 2847, 924, 926, 3501, 929, 932, 3236, 933, 935, 1000, 1002, 411, 223, 3282, 939, 940, 11018, 942, 8006, 11019, 11020, 641, 945, 2632, 2519, 1691 ],
  ),
  "graphic_eq": SymbolsMetadata(
    popularity: 2168,
    codepoint: 0xe1b8,
    categories: [ 4 ],
    tags: [ 5060, 5292, 1129, 11021, 9132, 9134, 6456, 794, 365, 269, 2804, 2805, 8229, 8230, 4050, 277, 3328, 11022, 934, 2081, 9135, 9136, 1148, 177, 65, 1156, 11023, 9137, 9139, 8319, 9140, 3411, 441, 2253, 1161, 1745, 8692 ],
  ),
  "grass": SymbolsMetadata(
    popularity: 1888,
    codepoint: 0xf205,
    categories: [ 8 ],
    tags: [ 1812, 7654, 4382, 9655, 7986, 1890, 1822, 1827, 11024, 11025, 6816, 6817, 9649, 3929, 196, 999, 1543, 10707, 7657, 6820, 8976, 1859, 1860, 3345, 1835, 2439, 6825, 4206, 11026, 11027, 11028, 7642 ],
  ),
  "grid_3x3": SymbolsMetadata(
    popularity: 258,
    codepoint: 0xf015,
    categories: [ 4 ],
    tags: [ 82, 10078, 2169, 1229, 1230, 1367, 918, 3639, 802, 10, 12, 246, 11029, 135, 306, 1602, 2753, 788, 682, 11030, 656, 98, 7434, 1376, 371, 65, 609, 1379, 944, 945, 1380, 11031, 317 ],
  ),
  "grid_3x3_off": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf67c,
    categories: [ 4 ],
    tags: [ 82, 10078, 918, 895, 3302, 1077, 11032, 11033, 11034, 11035, 767, 898, 246, 11036, 11037, 11029, 11038, 1078, 11039, 11040, 11041, 306, 11042, 1602, 366, 2753, 11043, 11044, 11045, 11046, 907, 909, 11047, 11048, 11049, 914, 609, 32, 944 ],
  ),
  "grid_4x4": SymbolsMetadata(
    popularity: 416,
    codepoint: 0xf016,
    categories: [ 4 ],
    tags: [ 534, 3643, 2170, 918, 7276, 3639, 802, 2832, 1607, 2704, 9648, 3419, 11050, 246, 5391, 11051, 306, 366, 2753, 9406, 98, 3635, 1376, 609, 1379, 944, 945, 1380, 2713, 3426, 11052, 1054 ],
  ),
  "grid_goldenratio": SymbolsMetadata(
    popularity: 163,
    codepoint: 0xf017,
    categories: [ 4 ],
    tags: [ 11053, 2169, 2601, 2829, 794, 3418, 1202, 299, 11054, 3419, 304, 11055, 11056, 11057, 11058, 246, 11059, 8071, 1209, 306, 366, 2380, 11060, 11061, 202, 7277, 3149, 75, 609, 32, 945, 2206, 11062 ],
  ),
  "grid_guides": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xf76f,
    categories: [ 12 ],
    tags: [ 2169, 1367, 1730, 2318, 383, 3418, 1819, 11063, 1202, 2200, 299, 3419, 6684, 246, 11064, 11065, 3226, 7918, 594, 11066, 3145, 306, 61, 1048, 2247, 11067, 11068, 2281, 11069, 8342, 11070, 32, 945, 11062 ],
  ),
  "grid_off": SymbolsMetadata(
    popularity: 216,
    codepoint: 0xe3eb,
    categories: [ 1 ],
    tags: [ 2170, 918, 895, 3639, 3417, 896, 897, 1077, 767, 12, 898, 246, 11071, 11072, 11073, 11037, 1078, 900, 53, 306, 2753, 11045, 907, 909, 98, 911, 914, 944, 945, 10066, 1380, 5587, 317 ],
  ),
  "grid_on": SymbolsMetadata(
    popularity: 1922,
    codepoint: 0xe3ec,
    categories: [ 1 ],
    tags: [ 1230, 2657, 1367, 3630, 5792, 3639, 3417, 2155, 802, 767, 12, 898, 1541, 246, 11074, 5391, 53, 306, 2159, 2753, 788, 907, 909, 98, 1376, 914, 944, 945, 5796, 1380, 858, 11075, 3637, 3426, 11076, 317, 11077 ],
  ),
  "grid_view": SymbolsMetadata(
    popularity: 14009,
    codepoint: 0xe9b0,
    categories: [ 12 ],
    tags: [ 1229, 1230, 11078, 1367, 918, 3639, 2750, 1042, 2515, 299, 12, 538, 1541, 246, 5391, 2751, 306, 2753, 98, 1068, 4855, 3635, 330, 1377, 3423, 2882, 32, 944, 945, 1380, 858, 11075, 3637, 3426, 2757, 2759, 317, 1691, 1053, 1054 ],
  ),
  "grocery": SymbolsMetadata(
    popularity: 146,
    codepoint: 0xef97,
    categories: [ 8 ],
    tags: [ 2964, 1616, 1869, 1618, 4386, 4388, 3800, 1822, 1829, 11079, 1876, 11080, 11081, 3894, 11082, 11083, 1291, 3804, 11084, 11085, 11086, 96, 1837, 840, 841, 11087, 1298, 11088 ],
  ),
  "group": SymbolsMetadata(
    popularity: 37090,
    codepoint: 0xe7ef,
    categories: [ 3 ],
    tags: [ 468, 1126, 9479, 1059, 6991, 3281, 1134, 194, 211, 848, 7335, 6993, 1063, 479, 867, 481, 1137, 6278, 930, 7708, 1141, 1145, 8261, 11089, 223, 940, 8263, 488, 11090, 1151, 490, 1153, 607, 946, 611, 8270, 1159 ],
  ),
  "group_add": SymbolsMetadata(
    popularity: 9179,
    codepoint: 0xe7f0,
    categories: [ 3 ],
    tags: [ 468, 1126, 526, 11091, 11092, 11093, 11094, 1506, 1134, 194, 475, 1201, 11095, 479, 867, 11096, 1137, 930, 1141, 1206, 1207, 1311, 11097, 853, 789, 223, 763, 11098, 488, 489, 1151, 202, 490, 1153, 607, 946, 501, 1159 ],
  ),
  "group_off": SymbolsMetadata(
    popularity: 633,
    codepoint: 0xe747,
    categories: [ 3 ],
    tags: [ 11099, 11100, 584, 11101, 11102, 10926, 3281, 7335, 11103, 11104, 11105, 11106, 11107, 11108, 11109, 11110, 6278, 930, 11111, 11112, 11113, 11114, 11115, 11116, 483, 1145, 11117, 11118, 907, 488, 489, 11119, 11120, 607, 11121, 11122, 11123, 11124, 6773, 11125, 11126, 11127 ],
  ),
  "group_remove": SymbolsMetadata(
    popularity: 1075,
    codepoint: 0xe7ad,
    categories: [ 3 ],
    tags: [ 754, 468, 1126, 1074, 383, 1134, 194, 211, 897, 11128, 3615, 6242, 10671, 11129, 479, 867, 1137, 930, 1141, 11130, 853, 1116, 223, 488, 489, 1151, 490, 1153, 911, 11131, 607, 1122, 946, 441, 11132, 11133, 501, 1159 ],
  ),
  "group_search": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xf3ce,
    categories: [ 7 ],
    tags: [ 468, 1059, 470, 194, 848, 955, 958, 479, 959, 960, 11134, 11135, 11136, 964, 930, 11137, 7707, 483, 7708, 2810, 967, 1489, 971, 11138, 974, 975, 976, 8261, 4479, 488, 11139, 489, 490, 11140, 980, 11141, 11142, 11143, 7536, 607, 36, 946, 11144, 501, 6878, 1159 ],
  ),
  "group_work": SymbolsMetadata(
    popularity: 2762,
    codepoint: 0xe886,
    categories: [ 3 ],
    tags: [ 11145, 9479, 383, 3281, 11146, 4863, 194, 1135, 211, 481, 930, 11147, 11148, 6771, 1145, 8261, 11089, 223, 940, 8263, 607, 946, 11149, 6807, 983, 791, 499, 11150, 6803, 1159, 1459 ],
  ),
  "grouped_bar_chart": SymbolsMetadata(
    popularity: 889,
    codepoint: 0xf211,
    categories: [ 9 ],
    tags: [ 2513, 5, 1343, 1344, 365, 1284, 920, 802, 10, 924, 808, 929, 11151, 933, 2518, 1045, 597, 634, 937, 189, 28, 1353, 1354, 2851, 3857, 33, 440, 947, 2852, 3858, 2253, 1355, 2519 ],
  ),
  "groups": SymbolsMetadata(
    popularity: 21973,
    codepoint: 0xf233,
    categories: [ 3 ],
    tags: [ 9479, 1059, 584, 10926, 3281, 443, 194, 1135, 6768, 848, 7335, 481, 11152, 6278, 11153, 6770, 483, 1145, 3118, 11089, 223, 11154, 940, 488, 489, 6573, 607, 946, 6773, 499, 11150, 1159, 5743 ],
  ),
  "groups_2": SymbolsMetadata(
    popularity: 2095,
    codepoint: 0xf8df,
    categories: [ 3 ],
    tags: [ 81, 82, 9479, 1059, 11155, 584, 11156, 10926, 3281, 4863, 194, 1135, 6768, 848, 7335, 481, 6278, 6770, 6220, 11157, 483, 1145, 8261, 2557, 223, 940, 488, 489, 1153, 607, 946, 6773, 374, 315, 1159 ],
  ),
  "groups_3": SymbolsMetadata(
    popularity: 1210,
    codepoint: 0xf8e0,
    categories: [ 3 ],
    tags: [ 82, 3325, 11155, 584, 383, 10926, 3281, 194, 7335, 1416, 11158, 8260, 481, 6278, 1659, 11159, 6770, 483, 1145, 2557, 223, 940, 488, 489, 1151, 1153, 5922, 607, 32, 946, 6773, 374, 499, 11150, 1701, 8270, 1159, 5926 ],
  ),
  "guardian": SymbolsMetadata(
    popularity: 48,
    codepoint: 0xf4c1,
    categories: [ 3 ],
    tags: [ 755, 468, 993, 584, 994, 383, 269, 11160, 4120, 2854, 4408, 869, 483, 1001, 6222, 875, 4240, 488, 1006, 489, 1496, 490, 1519, 1520, 3310, 171, 1772, 602, 1773, 1011, 6201, 4323, 4940, 11161, 11162, 501, 1013 ],
  ),
  "gynecology": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xe0f4,
    categories: [ 3 ],
    tags: [ 3919, 10818, 11163, 584, 11164, 11165, 11166, 11167, 1790, 11168, 11169, 11170, 11171, 11172, 595, 1753, 11173, 483, 1757, 11174, 11175, 11176, 10793, 11177, 11178, 11179, 11180, 5010, 11181, 11182, 9069, 11183, 11184, 5011, 11185 ],
  ),
  "h_mobiledata": SymbolsMetadata(
    popularity: 121,
    codepoint: 0xf018,
    categories: [ 4 ],
    tags: [ 428, 4, 365, 208, 210, 8, 443, 211, 212, 10, 14, 2303, 11186, 506, 11187, 11188, 215, 10567, 19, 219, 433, 434, 221, 223, 517, 226, 2631, 227, 228, 35, 38, 2146, 40, 234 ],
  ),
  "h_mobiledata_badge": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf7e0,
    categories: [ 4 ],
    tags: [ 428, 4, 6, 210, 8, 443, 211, 212, 10, 213, 444, 14, 2303, 11189, 11190, 5090, 11187, 16, 215, 10567, 19, 219, 433, 8624, 434, 221, 223, 517, 242, 78, 2631, 228, 32, 35, 38, 40, 234 ],
  ),
  "h_plus_mobiledata": SymbolsMetadata(
    popularity: 119,
    codepoint: 0xf019,
    categories: [ 4 ],
    tags: [ 192, 11191, 11192, 4, 210, 429, 8, 443, 211, 212, 1202, 10, 213, 11193, 11194, 14, 2303, 11195, 11189, 359, 11188, 215, 19, 219, 433, 241, 434, 221, 223, 242, 11196, 437, 202, 1212, 2631, 227, 35, 38, 40, 234 ],
  ),
  "h_plus_mobiledata_badge": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf7df,
    categories: [ 4 ],
    tags: [ 192, 428, 4, 6, 210, 429, 8, 443, 211, 212, 10, 510, 14, 2303, 11195, 11189, 11188, 188, 215, 19, 219, 433, 241, 221, 223, 517, 242, 226, 202, 1212, 77, 2631, 11197, 228, 446, 35, 38, 441, 40, 234 ],
  ),
  "hail": SymbolsMetadata(
    popularity: 1048,
    codepoint: 0xe9b1,
    categories: [ 14 ],
    tags: [ 3719, 584, 1910, 8890, 1133, 2063, 11198, 11199, 11200, 11201, 11202, 11203, 11204, 483, 3726, 96, 1922, 488, 489, 3021, 2070, 5736, 2071, 3162, 2072, 6782, 3475, 1083, 11205, 4744, 8895, 1930, 1504, 5996, 8992 ],
  ),
  "hallway": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xe6f8,
    categories: [ 8 ],
    tags: [ 3325, 755, 2601, 798, 11206, 388, 6103, 6104, 2985, 274, 1659, 11207, 6139, 999, 1435, 53, 2793, 2795, 2796, 1543, 11208, 1544, 1545, 6834, 421, 8437, 11209, 1586, 412, 59, 61, 119, 1960, 1503, 1701, 11210, 3229 ],
  ),
  "hand_bones": SymbolsMetadata(
    popularity: 307,
    codepoint: 0xf894,
    categories: [ 3 ],
    tags: [ 3919, 11211, 584, 4289, 9621, 9622, 9, 9914, 2734, 4707, 9628, 2735, 5659, 5810, 2738, 11212, 595, 3201, 1757, 9641, 2743, 11213, 204, 1723, 9636, 7197, 2597, 9644 ],
  ),
  "hand_gesture": SymbolsMetadata(
    popularity: 985,
    codepoint: 0xef9c,
    categories: [ 6 ],
    tags: [ 269, 2651, 3007, 2734, 11214, 11215, 3616, 2735, 5659, 2738, 3617, 966, 4895, 1375, 219, 778, 421, 2743, 4482, 3001, 2899, 4787, 7229, 11216, 11217, 8035, 10841, 1862 ],
  ),
  "hand_gesture_off": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf3f3,
    categories: [ 6 ],
    tags: [ 1074, 11218, 11219, 895, 11220, 11221, 11222, 896, 11223, 11224, 1077, 11225, 11226, 2734, 899, 2735, 11227, 11228, 11229, 11230, 11231, 11232, 2738, 11233, 11234, 11235, 11236, 11237, 11238, 11239, 4152, 11240, 11241, 907, 2743, 4450, 11242, 11243, 11244, 1083, 11245, 11246, 1862 ],
  ),
  "handheld_controller": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf4c6,
    categories: [ 11 ],
    tags: [ 688, 380, 419, 298, 952, 3233, 269, 5258, 10756, 445, 388, 10757, 1711, 3337, 11247, 697, 11248, 5260, 338, 11249, 3905, 11250, 11251, 11252, 966, 11253, 2162, 11254, 2585, 11255, 41, 574, 11256 ],
    rtlAutoMirrored: true,
  ),
  "handshake": SymbolsMetadata(
    popularity: 14263,
    codepoint: 0xebcb,
    categories: [ 3 ],
    tags: [ 7026, 1284, 3281, 11257, 194, 921, 211, 2919, 11258, 11259, 5750, 11260, 11096, 11261, 6155, 2738, 2741, 11262, 1145, 4479, 8263, 11263, 8006, 8683, 495, 946, 6807, 2745, 766 ],
  ),
  "handyman": SymbolsMetadata(
    popularity: 4129,
    codepoint: 0xf10b,
    categories: [ 5 ],
    tags: [ 4862, 5803, 5804, 4865, 2832, 1202, 11264, 6920, 5809, 11265, 1737, 6921, 5812, 965, 5813, 2770, 5197, 656, 329, 5815, 3474, 11266, 11267, 2631, 65, 9105, 2756, 11268, 5743, 3736 ],
  ),
  "hangout_video": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xe0c1,
    categories: [ 0 ],
    tags: [ 355, 5488, 47, 443, 1306, 270, 5509, 1189, 11269, 1138, 11270, 53, 5516, 1144, 420, 278, 8016, 5543, 119, 2162, 121, 75, 77, 32, 2057, 41, 1160, 5519, 5549, 1173, 11271, 291, 540, 5521, 11272, 5551, 352 ],
  ),
  "hangout_video_off": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xe0c2,
    categories: [ 0 ],
    tags: [ 1133, 47, 11273, 11274, 443, 1135, 3304, 11275, 767, 898, 11276, 270, 5509, 1189, 11270, 53, 1145, 420, 11277, 11278, 11279, 11280, 907, 909, 119, 10760, 75, 11281, 11282, 914, 11283, 41, 11284, 11285, 11286, 11287, 11288, 291, 11289, 5521, 11290, 11291 ],
  ),
  "hard_disk": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf3da,
    categories: [ 11 ],
    tags: [ 1651, 383, 4864, 694, 10, 445, 88, 2157, 5243, 1654, 1711, 1530, 11292, 11293, 965, 11294, 135, 1602, 5291, 223, 2506, 75, 3749, 1664, 3761, 674, 1298, 2632, 551, 1536 ],
  ),
  "hard_drive": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf80e,
    categories: [ 11 ],
    tags: [ 1651, 7, 383, 3741, 694, 10, 445, 88, 2157, 1347, 5243, 1711, 1530, 11292, 11293, 965, 11294, 11295, 135, 5291, 223, 3782, 75, 1664, 3761, 674, 1298, 551, 441 ],
  ),
  "hard_drive_2": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf7a4,
    categories: [ 11 ],
    tags: [ 1651, 694, 10, 1685, 445, 88, 2157, 1347, 5243, 956, 1711, 1530, 11292, 11293, 965, 11294, 135, 5291, 223, 6839, 75, 1664, 3761, 674, 1298, 2632, 551, 2620, 5137 ],
  ),
  "hardware": SymbolsMetadata(
    popularity: 548,
    codepoint: 0xea59,
    categories: [ 8 ],
    tags: [ 1128, 2136, 4862, 5805, 268, 4865, 2832, 1735, 445, 5809, 2523, 1737, 6921, 11296, 965, 5813, 5195, 2836, 2770, 5197, 1740, 11297, 656, 329, 3474, 65, 11298, 2537, 11299, 6367, 5743 ],
  ),
  "hd": SymbolsMetadata(
    popularity: 629,
    codepoint: 0xe052,
    categories: [ 0 ],
    tags: [ 318, 455, 11300, 4, 8, 3536, 668, 12, 337, 529, 270, 14, 256, 2471, 257, 11301, 11302, 140, 19, 367, 278, 3541, 328, 281, 62, 75, 30, 77, 330, 65, 32, 342, 35, 343, 38, 344, 40, 346, 41, 334 ],
  ),
  "hdr_auto": SymbolsMetadata(
    popularity: 468,
    codepoint: 0xf01a,
    categories: [ 1 ],
    tags: [ 3495, 685, 4, 1131, 11303, 1132, 1728, 47, 8, 383, 1734, 269, 12, 2547, 11304, 528, 654, 5047, 14, 9868, 11305, 11306, 2471, 9869, 11307, 2781, 19, 281, 59, 61, 1007, 889, 330, 310, 65, 35, 38, 314, 40, 41 ],
  ),
  "hdr_auto_select": SymbolsMetadata(
    popularity: 107,
    codepoint: 0xf01b,
    categories: [ 1 ],
    tags: [ 192, 3495, 685, 4, 1131, 11303, 11308, 1132, 47, 8, 383, 269, 12, 2547, 654, 14, 9868, 11305, 11309, 11310, 2471, 7058, 9869, 53, 2781, 19, 281, 59, 202, 1007, 11311, 330, 288, 371, 65, 35, 38, 314, 40, 41, 11312 ],
  ),
  "hdr_enhanced_select": SymbolsMetadata(
    popularity: 136,
    codepoint: 0xef51,
    categories: [ 1 ],
    tags: [ 526, 4, 1728, 8, 266, 383, 1734, 1202, 12, 2547, 11313, 528, 654, 14, 9868, 11310, 2471, 9869, 53, 6922, 19, 281, 59, 202, 1212, 285, 62, 1007, 11311, 330, 288, 4751, 310, 35, 36, 38, 40, 41, 11314, 11312 ],
  ),
  "hdr_off": SymbolsMetadata(
    popularity: 137,
    codepoint: 0xe3ed,
    categories: [ 1 ],
    tags: [ 4, 1074, 47, 49, 895, 8, 896, 11315, 767, 12, 325, 2547, 11304, 898, 528, 14, 899, 9868, 11316, 2471, 9869, 53, 11317, 19, 4152, 11318, 907, 909, 59, 61, 1007, 911, 171, 330, 3151, 288, 914, 35, 38, 40, 41, 292 ],
  ),
  "hdr_off_select": SymbolsMetadata(
    popularity: 95,
    codepoint: 0xf01c,
    categories: [ 1 ],
    tags: [ 4, 47, 49, 895, 8, 383, 8198, 1076, 1077, 11315, 767, 325, 2547, 898, 14, 9868, 11319, 11320, 11316, 11321, 11310, 2471, 9869, 53, 11317, 19, 1602, 3696, 11318, 907, 909, 59, 61, 1007, 3151, 288, 914, 35, 38, 11322, 40, 41, 292 ],
  ),
  "hdr_on": SymbolsMetadata(
    popularity: 250,
    codepoint: 0xe3ee,
    categories: [ 1 ],
    tags: [ 1242, 526, 4, 1728, 47, 8, 1734, 12, 2547, 11304, 898, 528, 654, 529, 14, 9868, 2471, 7058, 9869, 53, 6922, 19, 367, 328, 909, 59, 202, 62, 1007, 11311, 330, 288, 310, 65, 35, 343, 38, 314, 344, 40, 41, 11314, 11312 ],
  ),
  "hdr_on_select": SymbolsMetadata(
    popularity: 127,
    codepoint: 0xf01d,
    categories: [ 1 ],
    tags: [ 192, 10068, 4, 1728, 47, 8, 383, 1734, 12, 2547, 11323, 898, 11324, 14, 9868, 11310, 2471, 9869, 11325, 54, 11326, 19, 367, 909, 59, 202, 1007, 30, 11311, 330, 288, 4751, 65, 35, 38, 314, 40, 41, 334, 11327 ],
  ),
  "hdr_plus": SymbolsMetadata(
    popularity: 107,
    codepoint: 0xf01e,
    categories: [ 1 ],
    tags: [ 192, 951, 526, 4, 6, 47, 8, 383, 1734, 2547, 11304, 898, 528, 654, 5047, 14, 9868, 11310, 2471, 9869, 51, 16, 53, 6922, 19, 909, 61, 202, 62, 1007, 11311, 288, 310, 65, 35, 38, 314, 40, 41, 11312 ],
  ),
  "hdr_plus_off": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xe3ef,
    categories: [ 1 ],
    tags: [ 192, 47, 895, 383, 1077, 767, 11304, 2855, 898, 899, 9868, 11316, 11321, 11328, 9869, 53, 11318, 11329, 907, 909, 59, 61, 119, 202, 171, 65, 914, 314, 41 ],
  ),
  "hdr_strong": SymbolsMetadata(
    popularity: 468,
    codepoint: 0xe3f1,
    categories: [ 1 ],
    tags: [ 1728, 47, 953, 1732, 1734, 956, 9690, 2547, 11304, 528, 5047, 9868, 2471, 9869, 53, 4567, 5036, 5062, 4014, 907, 909, 59, 61, 11330, 1007, 310, 5964, 314, 11331, 5137, 41, 5521 ],
  ),
  "hdr_weak": SymbolsMetadata(
    popularity: 323,
    codepoint: 0xe3f2,
    categories: [ 1 ],
    tags: [ 733, 1728, 47, 383, 953, 1732, 1734, 767, 12, 832, 956, 2547, 898, 528, 9868, 2471, 9869, 53, 188, 4014, 367, 907, 909, 61, 1007, 1786, 310, 227, 553, 5952, 314, 41, 5974 ],
  ),
  "head_mounted_device": SymbolsMetadata(
    popularity: 154,
    codepoint: 0xf4c5,
    categories: [ 11 ],
    tags: [ 406, 379, 11332, 381, 11333, 445, 88, 11334, 11335, 338, 11336, 1190, 11337, 8632, 11338, 389, 6703, 11339, 11340, 7886, 75, 77, 11341, 3411, 11342, 551, 317, 404, 4583, 11343, 405, 2594, 11344 ],
  ),
  "headphones": SymbolsMetadata(
    popularity: 4392,
    codepoint: 0xf01f,
    categories: [ 11 ],
    tags: [ 2587, 1129, 11345, 1133, 443, 1135, 475, 6861, 445, 8629, 8641, 8642, 7358, 8659, 4490, 8632, 482, 1143, 8634, 2081, 1164, 1152, 121, 177, 1156, 495, 8300, 1160, 1161, 5421, 1745 ],
  ),
  "headphones_battery": SymbolsMetadata(
    popularity: 246,
    codepoint: 0xf020,
    categories: [ 11 ],
    tags: [ 2587, 1129, 8645, 3769, 3770, 3771, 11346, 3773, 3774, 445, 8629, 8641, 4061, 11347, 4490, 11348, 8632, 11349, 11350, 188, 2472, 1143, 8634, 8652, 3780, 2081, 11351, 3782, 4069, 1156, 8654, 553, 1745, 4527 ],
  ),
  "headset_mic": SymbolsMetadata(
    popularity: 2979,
    codepoint: 0xe311,
    categories: [ 11 ],
    tags: [ 2587, 1129, 8645, 1133, 472, 443, 1135, 1306, 6861, 445, 8629, 8641, 11352, 4490, 8632, 11353, 11354, 482, 6865, 1143, 1146, 1147, 11355, 2081, 11356, 121, 177, 1156, 492, 495, 496, 11357, 1161, 5421 ],
  ),
  "headset_off": SymbolsMetadata(
    popularity: 265,
    codepoint: 0xe33a,
    categories: [ 11 ],
    tags: [ 2587, 1129, 11358, 11359, 11360, 11361, 472, 3302, 445, 11362, 11363, 11364, 11365, 767, 8629, 8641, 898, 4490, 11366, 11367, 8632, 11368, 11369, 7067, 1143, 1146, 2081, 1164, 1165, 1166, 11370, 11371, 1169, 907, 909, 1170, 11372, 914, 1156, 11373, 8318, 496 ],
  ),
  "healing": SymbolsMetadata(
    popularity: 1092,
    codepoint: 0xe3f3,
    categories: [ 1 ],
    tags: [ 11374, 11375, 11376, 11377, 3600, 1202, 11378, 696, 2299, 2482, 4472, 1737, 11379, 595, 1754, 53, 3201, 1757, 1760, 11380, 11381, 1212, 1520, 3748, 1663, 11382, 3474, 3749, 602, 495, 2428, 4646, 1905, 11383, 3736 ],
  ),
  "health_and_beauty": SymbolsMetadata(
    popularity: 198,
    codepoint: 0xef9d,
    categories: [ 8 ],
    tags: [ 7985, 8994, 1868, 7352, 11384, 5162, 3600, 10656, 11385, 7355, 2705, 1874, 11386, 11387, 6220, 11388, 11389, 11390, 595, 3972, 7362, 11391, 11297, 1879, 3974, 11392, 1881, 11393, 8079, 2182, 11394, 7218, 1905 ],
  ),
  "health_and_safety": SymbolsMetadata(
    popularity: 5832,
    codepoint: 0xe1d5,
    categories: [ 3 ],
    tags: [ 192, 526, 8994, 1510, 1749, 1202, 11395, 1751, 2482, 4472, 595, 11396, 11397, 11398, 11399, 1753, 999, 1754, 5668, 1757, 11400, 11401, 11402, 1760, 1004, 202, 5329, 1212, 1516, 1517, 1519, 1520, 602, 11403, 1011, 1522, 11404, 35, 1523, 4646, 1905 ],
  ),
  "health_metrics": SymbolsMetadata(
    popularity: 201,
    codepoint: 0xf6e2,
    categories: [ 15 ],
    tags: [ 989, 11405, 11406, 11407, 4452, 920, 1749, 1202, 924, 1751, 5786, 5787, 2927, 929, 595, 3861, 4454, 11408, 3862, 11409, 3863, 1753, 5778, 11410, 3569, 1754, 1602, 597, 1757, 11411, 11412, 11413, 11414, 1760, 22, 937, 3865, 1762, 202, 1212, 3570, 11415, 11416, 4461, 4462 ],
  ),
  "heap_snapshot_large": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf76e,
    categories: [ 12 ],
    tags: [ 2513, 5, 9152, 2624, 10, 1185, 2625, 4453, 1528, 1347, 1530, 7646, 11417, 11418, 3634, 5291, 1534, 1535, 6413, 4142, 189, 2630, 7277, 286, 3149, 1353, 673, 5491, 1196, 33 ],
  ),
  "heap_snapshot_multiple": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf76d,
    categories: [ 12 ],
    tags: [ 11419, 2513, 2624, 1707, 1201, 10, 1185, 2625, 4453, 1528, 1347, 5243, 2999, 1530, 1655, 11417, 11418, 1066, 5291, 937, 2557, 4915, 1534, 1535, 6413, 4142, 189, 11420, 2630, 7277, 3149, 7503, 5491, 1196, 107, 8057 ],
  ),
  "heap_snapshot_thumbnail": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf76c,
    categories: [ 12 ],
    tags: [ 2513, 1230, 2624, 10, 1184, 1185, 2625, 4453, 11421, 1541, 246, 11417, 11418, 1066, 5291, 11422, 6413, 4142, 189, 59, 5800, 10278, 11420, 2630, 7277, 3149, 75, 2258, 1377, 5491, 1196, 32, 944, 107, 858, 11423 ],
  ),
  "hearing": SymbolsMetadata(
    popularity: 2065,
    codepoint: 0xe023,
    categories: [ 0 ],
    tags: [ 733, 734, 8627, 758, 1129, 8658, 11424, 584, 443, 476, 11425, 8629, 744, 11426, 8631, 1139, 1140, 8633, 482, 483, 759, 746, 1143, 8634, 1147, 8635, 2081, 1152, 121, 1156, 9137, 3380, 1157, 1161, 1745, 9142, 1902 ],
  ),
  "hearing_aid": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf464,
    categories: [ 0 ],
    tags: [ 733, 734, 8627, 8628, 738, 758, 1129, 584, 443, 2332, 11425, 445, 8629, 5415, 744, 11426, 595, 1753, 1140, 8633, 11427, 482, 483, 16, 759, 746, 8649, 1143, 1757, 8635, 1156, 3380, 35, 551, 1745, 1902, 2594 ],
  ),
  "hearing_aid_disabled": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf3b0,
    categories: [ 0 ],
    tags: [ 733, 734, 736, 758, 1129, 11359, 3302, 11425, 1077, 767, 8629, 898, 744, 11426, 1140, 11428, 11429, 11430, 482, 759, 746, 1143, 1164, 11431, 1169, 907, 909, 2123, 1170, 914, 1156, 8318, 551, 1745, 8321 ],
  ),
  "hearing_aid_disabled_left": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf2ec,
    categories: [ 0 ],
    tags: [ 733, 734, 736, 758, 11359, 895, 11425, 11365, 767, 11432, 8629, 5415, 898, 744, 11426, 1140, 11428, 11433, 11434, 11429, 482, 759, 746, 11435, 8651, 1143, 8652, 1164, 11431, 1169, 907, 909, 2123, 1170, 914, 1156, 8318, 1745, 8321 ],
  ),
  "hearing_aid_left": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf2ed,
    categories: [ 0 ],
    tags: [ 733, 734, 8627, 8628, 11436, 739, 1129, 8645, 584, 383, 2332, 11425, 445, 8629, 5415, 744, 11426, 595, 1753, 1140, 11428, 8633, 482, 483, 759, 746, 11435, 1143, 1757, 1760, 8635, 285, 490, 65, 1156, 11437, 441, 1774, 1745 ],
  ),
  "hearing_disabled": SymbolsMetadata(
    popularity: 465,
    codepoint: 0xf104,
    categories: [ 0 ],
    tags: [ 733, 11438, 734, 736, 758, 739, 11359, 11439, 11425, 11440, 11365, 767, 8629, 11441, 11442, 898, 744, 11426, 1140, 11443, 11429, 482, 759, 11444, 1143, 11445, 1164, 11431, 1169, 907, 909, 6980, 1170, 1171, 914, 1156, 8318, 6917, 1745, 8321 ],
  ),
  "heart_broken": SymbolsMetadata(
    popularity: 1577,
    codepoint: 0xeac2,
    categories: [ 3 ],
    tags: [ 10211, 2136, 5098, 11446, 11447, 11448, 4387, 897, 11449, 4078, 11450, 2189, 7633, 595, 4455, 11451, 11452, 11453, 4083, 4768, 3696, 11454, 11455, 8006, 911, 4772, 11456, 4649, 1378, 11457, 9588 ],
  ),
  "heart_check": SymbolsMetadata(
    popularity: 132,
    codepoint: 0xf60a,
    categories: [ 2 ],
    tags: [ 1627, 4762, 1548, 4764, 1549, 1630, 1632, 1633, 2481, 1639, 3578, 9583, 595, 4455, 3569, 1560, 4768, 2379, 1643, 1213, 3570, 8006, 4270, 4773, 1664, 288, 1647, 2386, 2387, 1523, 5790, 1905, 1650 ],
  ),
  "heart_minus": SymbolsMetadata(
    popularity: 804,
    codepoint: 0xf883,
    categories: [ 2 ],
    tags: [ 5330, 4764, 2922, 11458, 897, 11459, 11449, 3578, 4455, 11460, 11461, 9584, 11462, 11463, 7648, 11464, 1560, 4768, 1116, 3696, 2930, 4270, 911, 11465, 9585, 11466, 1664, 1122, 4793, 11457, 9588, 11467, 11468, 11133 ],
  ),
  "heart_plus": SymbolsMetadata(
    popularity: 2557,
    codepoint: 0xf884,
    categories: [ 2 ],
    tags: [ 192, 526, 11469, 11470, 1266, 4762, 11471, 4763, 4764, 5797, 11472, 3578, 4455, 11473, 11474, 11475, 1207, 1560, 4768, 11476, 763, 11477, 202, 11478, 1212, 1213, 4270, 4772, 1664, 11479 ],
  ),
  "heat": SymbolsMetadata(
    popularity: 69,
    codepoint: 0xf537,
    categories: [ 10 ],
    tags: [ 705, 707, 709, 2078, 2777, 1849, 1850, 712, 269, 1852, 5601, 926, 3076, 5673, 999, 3078, 723, 16, 188, 366, 1004, 11480, 3964, 553, 3967, 4206, 3686, 35, 727, 8572, 729, 441, 3978, 1862, 1902, 8932, 731, 1863 ],
  ),
  "heat_pump": SymbolsMetadata(
    popularity: 559,
    codepoint: 0xec18,
    categories: [ 8 ],
    tags: [ 707, 708, 709, 1888, 5676, 798, 383, 712, 269, 717, 718, 3500, 3779, 719, 11481, 3076, 11482, 5673, 999, 1435, 723, 1004, 11483, 5039, 11484, 32, 2632, 728, 729, 7570, 5677, 730, 773 ],
  ),
  "heat_pump_balance": SymbolsMetadata(
    popularity: 180,
    codepoint: 0xe27e,
    categories: [ 10 ],
    tags: [ 380, 794, 2348, 712, 1269, 269, 718, 385, 3500, 3779, 2627, 926, 3954, 3076, 11482, 5673, 999, 723, 390, 1004, 11485, 2800, 11483, 1396, 727, 8572, 729, 2007, 2801 ],
  ),
  "height": SymbolsMetadata(
    popularity: 1168,
    codepoint: 0xea16,
    categories: [ 12 ],
    tags: [ 1128, 380, 419, 2301, 10584, 4848, 3086, 2919, 6829, 300, 1528, 2450, 2651, 696, 2299, 1371, 787, 2279, 1372, 1204, 2470, 11486, 3009, 2307, 2928, 3010, 5166, 2247, 2281, 4786, 11487, 2933, 1379, 2249, 2182, 11488, 38, 2455, 40, 1676, 1381, 2199, 2268, 704 ],
  ),
  "helicopter": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf60c,
    categories: [ 3 ],
    tags: [ 2464, 11489, 707, 1906, 11490, 1935, 9075, 11491, 11492, 2482, 5575, 1917, 1918, 11493, 1581, 10614, 2503, 308, 8616, 9079, 9945, 11494, 11495, 1590, 1842, 1930, 1504, 1591, 1844, 11496 ],
  ),
  "help": SymbolsMetadata(
    popularity: 32197,
    codepoint: 0xe887,
    categories: [ 6 ],
    tags: [ 4095, 7529, 738, 383, 6951, 11497, 6952, 3225, 482, 11498, 11499, 6063, 11500, 484, 135, 6938, 7920, 4686, 4695, 2772, 4101, 979, 4102, 6953, 11501, 4103, 1029, 3749, 311, 8986, 495, 35, 7531, 7949, 5881 ],
    rtlAutoMirrored: true,
  ),
  "help_center": SymbolsMetadata(
    popularity: 3437,
    codepoint: 0xf1c0,
    categories: [ 6 ],
    tags: [ 4095, 5171, 738, 7, 1730, 11502, 6860, 6951, 11503, 6952, 3225, 482, 11498, 6865, 11500, 484, 135, 6938, 7920, 11504, 11505, 2772, 4101, 979, 4102, 11506, 4103, 1029, 3749, 8986, 32, 495, 35, 7949, 5881 ],
    rtlAutoMirrored: true,
  ),
  "help_clinic": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf810,
    categories: [ 6 ],
    tags: [ 7529, 469, 1245, 5171, 738, 798, 1749, 11507, 475, 132, 1751, 2482, 6951, 960, 4472, 3225, 595, 11508, 1753, 482, 999, 11509, 1754, 1435, 2791, 1436, 5463, 484, 135, 1001, 1757, 4102, 8467, 980, 2631, 495 ],
  ),
  "hematology": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xe0f6,
    categories: [ 3 ],
    tags: [ 2513, 11510, 10818, 2412, 4463, 11511, 11512, 11513, 4467, 11514, 11515, 584, 11516, 5784, 1113, 11517, 3639, 11518, 1749, 4453, 1751, 595, 1753, 11519, 1754, 483, 4474, 4352, 4353, 1757, 1760, 4356, 10829, 1762, 11520, 11521, 4359, 2424, 11522, 11523, 6368, 1905, 11524 ],
  ),
  "hevc": SymbolsMetadata(
    popularity: 106,
    codepoint: 0xf021,
    categories: [ 1 ],
    tags: [ 455, 617, 4, 8, 3536, 6580, 3537, 3538, 356, 337, 3500, 3539, 270, 14, 1372, 11525, 256, 11526, 2471, 257, 11527, 19, 278, 328, 283, 342, 35, 38, 40, 332, 333, 41, 3545, 3546, 11528, 648, 11529 ],
  ),
  "hexagon": SymbolsMetadata(
    popularity: 757,
    codepoint: 0xeb39,
    categories: [ 12 ],
    tags: [ 11530, 3325, 4076, 349, 298, 1113, 268, 1269, 3327, 274, 1659, 304, 3328, 1661, 11531, 16, 223, 11532, 656, 1361, 3635, 1662, 65, 311, 11533, 1666, 945, 35 ],
  ),
  "hide": SymbolsMetadata(
    popularity: 1064,
    codepoint: 0xef9e,
    categories: [ 2 ],
    tags: [ 2650, 2052, 419, 2950, 2896, 3086, 6660, 6247, 2919, 2969, 388, 11534, 787, 900, 6703, 2928, 421, 11535, 3010, 11536, 1516, 2930, 3093, 8411, 2933, 11537, 2404 ],
  ),
  "hide_image": SymbolsMetadata(
    popularity: 626,
    codepoint: 0xf022,
    categories: [ 1 ],
    tags: [ 11538, 11539, 11540, 4563, 11541, 3304, 11542, 767, 12, 898, 899, 1078, 900, 6666, 11543, 53, 1856, 1543, 367, 1544, 1545, 11544, 11545, 11546, 2681, 907, 909, 59, 61, 119, 1516, 11547, 171, 914, 32, 8209, 317 ],
  ),
  "hide_source": SymbolsMetadata(
    popularity: 1829,
    codepoint: 0xf023,
    categories: [ 2 ],
    tags: [ 1074, 895, 11548, 383, 2624, 6660, 3302, 2625, 1077, 767, 898, 899, 1078, 900, 11549, 1856, 7067, 4152, 8305, 11550, 907, 908, 909, 2630, 11551, 911, 311, 914, 3364, 2126, 6603, 915, 5023 ],
  ),
  "high_density": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf79c,
    categories: [ 1 ],
    tags: [ 2301, 2448, 2449, 11552, 7712, 545, 12, 956, 11553, 11554, 246, 11555, 52, 54, 117, 7716, 2753, 327, 1719, 11556, 27, 11557, 11558, 62, 30, 11559, 330, 3152, 646, 32, 3637, 3426, 986 ],
  ),
  "high_quality": SymbolsMetadata(
    popularity: 586,
    codepoint: 0xe024,
    categories: [ 0 ],
    tags: [ 4, 1129, 11560, 6, 8, 668, 12, 529, 14, 256, 2471, 257, 51, 11301, 10717, 11561, 16, 53, 54, 18, 19, 367, 11562, 327, 278, 3541, 281, 285, 62, 75, 30, 77, 330, 65, 35, 38, 344, 40, 41, 334 ],
  ),
  "high_res": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf54b,
    categories: [ 1 ],
    tags: [ 318, 455, 4, 47, 8, 544, 545, 12, 528, 14, 256, 11563, 2471, 257, 11564, 52, 11565, 53, 54, 530, 19, 327, 278, 281, 119, 27, 285, 62, 30, 330, 65, 646, 32, 35, 38, 344, 40, 332, 523, 11566, 41, 334 ],
  ),
  "highlight": SymbolsMetadata(
    popularity: 791,
    codepoint: 0xe25f,
    categories: [ 8 ],
    tags: [ 3325, 4848, 269, 6676, 10, 1528, 696, 2299, 1371, 10501, 6243, 2279, 959, 4080, 1738, 1372, 7085, 9821, 304, 3019, 135, 9822, 3680, 6834, 656, 98, 5166, 329, 99, 2493, 371, 2264, 65, 4786, 106, 1379, 944, 2182, 11567, 38, 2936, 2537, 40, 704 ],
  ),
  "highlight_keyboard_focus": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf510,
    categories: [ 2 ],
    tags: [ 11568, 783, 733, 1242, 575, 11569, 383, 1851, 1781, 2448, 696, 1738, 3019, 11570, 5463, 11571, 11572, 966, 1044, 969, 11573, 19, 1602, 1740, 288, 11574, 4751, 371, 36, 38, 3734, 40, 3735, 1536 ],
  ),
  "highlight_mouse_cursor": SymbolsMetadata(
    popularity: 79,
    codepoint: 0xf511,
    categories: [ 2 ],
    tags: [ 733, 949, 380, 1039, 266, 11569, 383, 384, 1776, 1777, 1781, 3258, 1738, 3019, 11575, 4895, 215, 1375, 1489, 390, 3020, 4910, 11576, 11577, 778, 423, 3021, 1494, 1783, 396, 288, 371, 8502, 399, 9606, 36, 1590, 402, 1691 ],
    rtlAutoMirrored: true,
  ),
  "highlight_text_cursor": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf512,
    categories: [ 2 ],
    tags: [ 3669, 11569, 1776, 1781, 696, 8777, 2299, 1372, 3019, 11570, 11571, 11572, 966, 1044, 11578, 1783, 288, 11574, 371, 38, 11579, 7476, 3734, 11580, 11581, 40, 11582, 3735, 1536, 704, 11583 ],
  ),
  "highlighter_size_1": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf76b,
    categories: [ 12 ],
    tags: [ 8521, 3254, 1343, 696, 2299, 10501, 1372, 3019, 10502, 1602, 9145, 1641, 21, 3329, 3330, 75, 288, 371, 105, 11584, 1979, 4818, 9146, 38, 7476, 11580, 9147, 2498, 10454, 3831, 704 ],
  ),
  "highlighter_size_2": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf76a,
    categories: [ 12 ],
    tags: [ 8521, 3254, 2969, 696, 2299, 10501, 1372, 2175, 3019, 10502, 9145, 21, 4044, 11585, 8005, 75, 77, 11574, 11586, 11587, 8007, 4818, 9146, 2230, 10503, 11588, 10458, 10355, 9147, 3831, 704, 8781 ],
  ),
  "highlighter_size_3": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf769,
    categories: [ 12 ],
    tags: [ 8521, 3254, 696, 2299, 1372, 2175, 3019, 10502, 3634, 9145, 1641, 21, 8815, 8005, 75, 288, 371, 673, 11589, 8007, 4818, 9146, 2182, 2184, 7476, 2230, 10503, 10355, 9151, 9147, 3831, 3014 ],
  ),
  "highlighter_size_4": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf768,
    categories: [ 12 ],
    tags: [ 534, 8521, 3254, 696, 2299, 1372, 2175, 538, 3019, 10502, 3634, 9145, 21, 8005, 75, 77, 288, 371, 673, 8007, 4818, 9146, 2182, 10445, 2184, 7476, 10425, 2230, 10503, 10355, 9151, 9147, 3831 ],
  ),
  "highlighter_size_5": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf767,
    categories: [ 12 ],
    tags: [ 3254, 8813, 1781, 1416, 696, 2299, 1372, 2175, 11590, 3019, 10502, 3634, 9145, 21, 1532, 1533, 1783, 11591, 1421, 288, 371, 311, 673, 4818, 9146, 38, 9151, 9147, 2537, 2756, 3831, 3014, 704 ],
  ),
  "hiking": SymbolsMetadata(
    popularity: 2196,
    codepoint: 0xe50a,
    categories: [ 15 ],
    tags: [ 989, 2464, 3718, 11592, 3719, 11593, 11594, 5575, 958, 4408, 2927, 1488, 3930, 11595, 3724, 483, 1001, 1002, 1544, 421, 3727, 8166, 3347, 607, 5780, 3595, 3493, 750, 3938, 1504, 8168, 5579, 3206, 3939, 8169 ],
  ),
  "history": SymbolsMetadata(
    popularity: 14964,
    codepoint: 0xe889,
    categories: [ 6 ],
    tags: [ 2151, 380, 2489, 3035, 2490, 1016, 3523, 385, 1017, 445, 1023, 999, 3513, 390, 1004, 2841, 2876, 424, 425, 2494, 2367, 426, 3516, 3749, 2844, 2495, 2881, 2496, 2886, 11596, 396, 1031, 289, 402, 11597, 2499 ],
  ),
  "history_2": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf3e6,
    categories: [ 6 ],
    tags: [ 989, 2151, 380, 2489, 3035, 383, 1016, 11598, 1017, 445, 2884, 5133, 1023, 999, 2874, 5126, 421, 1004, 8845, 2841, 2876, 1029, 121, 424, 2494, 426, 3749, 2495, 2881, 2496, 396, 1031, 441, 1647, 289, 290, 2165, 402, 2499, 11599, 4272 ],
  ),
  "history_edu": SymbolsMetadata(
    popularity: 4689,
    codepoint: 0xea3e,
    categories: [ 12 ],
    tags: [ 4701, 2513, 2151, 2412, 11600, 4292, 1347, 11601, 3153, 4348, 5575, 11602, 1023, 11603, 4350, 4686, 4474, 3375, 126, 19, 4356, 1535, 2841, 2693, 11604, 1353, 4359, 3158, 2424, 2510, 4689, 290, 2756, 5882, 317, 1536, 704, 986 ],
  ),
  "history_off": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf4da,
    categories: [ 6 ],
    tags: [ 989, 380, 2489, 3035, 1074, 895, 383, 7681, 1016, 269, 1202, 1017, 7683, 767, 898, 899, 777, 1023, 901, 5126, 421, 11605, 907, 908, 909, 2841, 1029, 2492, 424, 7685, 2494, 2881, 396, 1031, 914, 289, 1033, 402, 2499 ],
  ),
  "history_toggle_off": SymbolsMetadata(
    popularity: 1654,
    codepoint: 0xf17d,
    categories: [ 6 ],
    tags: [ 11606, 2151, 383, 1016, 11598, 2448, 2449, 1017, 896, 1077, 767, 5133, 1023, 11607, 11608, 11609, 901, 5126, 11610, 907, 2841, 1029, 121, 1031, 313, 11611, 289, 2099, 11612, 290, 314, 947 ],
  ),
  "hive": SymbolsMetadata(
    popularity: 1563,
    codepoint: 0xeaa6,
    categories: [ 3 ],
    tags: [ 1812, 5177, 8971, 11613, 11614, 11615, 3639, 3281, 11616, 194, 211, 1822, 1659, 930, 1661, 11617, 11618, 8974, 11531, 11619, 5184, 11620, 1859, 223, 940, 3635, 2439, 674, 945, 4206, 7371 ],
  ),
  "hls": SymbolsMetadata(
    popularity: 408,
    codepoint: 0xeb8a,
    categories: [ 2 ],
    tags: [ 11621, 11622, 4, 355, 11623, 8, 11624, 6582, 1186, 6583, 2835, 14, 11625, 11626, 11627, 5074, 11628, 5075, 19, 5516, 5542, 11629, 367, 326, 328, 223, 11630, 1194, 283, 11631, 2057, 342, 35, 38, 40, 41, 291, 5550, 11632 ],
  ),
  "hls_off": SymbolsMetadata(
    popularity: 403,
    codepoint: 0xeb8c,
    categories: [ 2 ],
    tags: [ 4, 895, 8, 896, 1076, 6582, 1186, 1077, 767, 898, 6583, 2835, 14, 11625, 11633, 11634, 11635, 19, 5516, 11636, 11637, 11638, 11639, 11640, 11641, 11642, 11279, 907, 908, 909, 1194, 914, 1083, 11643, 11283, 342, 35, 38, 40, 41, 5550 ],
  ),
  "holiday_village": SymbolsMetadata(
    popularity: 1102,
    codepoint: 0xe58a,
    categories: [ 16 ],
    tags: [ 3325, 2599, 2601, 3923, 798, 11644, 5203, 3722, 5261, 194, 5204, 1484, 2605, 1659, 930, 2018, 999, 11509, 11645, 1435, 2791, 11646, 4615, 5997, 2610, 1490, 2557, 9292, 1495, 1444, 2614, 1445, 2615, 1446, 2616, 4202, 1603, 3425, 3846, 374, 2023, 1504, 5209, 2024, 7193 ],
  ),
  "home": SymbolsMetadata(
    popularity: 166299,
    codepoint: 0xe88a,
    categories: [ 2 ],
    tags: [ 1429, 1229, 11647, 2601, 2489, 84, 798, 2750, 2515, 4825, 299, 2604, 2605, 11648, 11649, 999, 11650, 11651, 7502, 1435, 2791, 2751, 5650, 306, 7498, 5207, 779, 421, 1495, 5208, 2614, 1446, 2616, 2495, 823, 330, 2617, 2882, 11652, 32, 108, 945, 1701, 2757, 635, 2759, 11210, 1691, 1053, 1054 ],
  ),
  "home_and_garden": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xef9f,
    categories: [ 8 ],
    tags: [ 8994, 2601, 7622, 7623, 798, 1433, 1434, 2605, 3838, 867, 2433, 6816, 6817, 999, 11653, 5813, 1435, 2608, 2793, 2796, 10707, 9236, 1859, 1860, 9895, 1495, 1835, 1444, 2614, 1445, 1446, 2616, 2617, 2439 ],
  ),
  "home_app_logo": SymbolsMetadata(
    popularity: 1948,
    codepoint: 0xe295,
    categories: [ 6 ],
    tags: [ 11654, 11655, 1229, 1230, 11656, 2539, 798, 2515, 6437, 1434, 11649, 999, 11650, 7502, 1435, 850, 11657, 5650, 2528, 11658, 5207, 421, 1004, 11659, 1444, 1446, 2495, 11660, 823, 11661, 11662, 11663 ],
  ),
  "home_health": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xe4b9,
    categories: [ 3 ],
    tags: [ 11664, 798, 3600, 1749, 1202, 11665, 11666, 595, 1753, 999, 11667, 11668, 11669, 11670, 11671, 11672, 1754, 1435, 11673, 1436, 11674, 1757, 11675, 11676, 202, 1212, 11677, 11678, 1446, 11679, 11680 ],
  ),
  "home_improvement_and_tools": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xefa0,
    categories: [ 8 ],
    tags: [ 8994, 9479, 4862, 798, 5805, 2832, 5809, 2524, 1737, 11681, 5812, 965, 999, 5813, 11682, 1435, 6922, 2770, 11297, 656, 7216, 5815, 3474, 11266, 65, 11683, 11684, 441, 2537, 2756, 1701, 5820 ],
  ),
  "home_iot_device": SymbolsMetadata(
    popularity: 491,
    codepoint: 0xe283,
    categories: [ 8 ],
    tags: [ 3210, 3213, 2148, 3942, 712, 10944, 269, 445, 3500, 3216, 3779, 1189, 965, 999, 3235, 11685, 1435, 215, 1896, 1897, 3680, 3946, 5062, 1755, 327, 1004, 65, 1155, 3237, 1901, 11686, 11687, 727, 728, 7945, 729, 234 ],
  ),
  "home_max": SymbolsMetadata(
    popularity: 197,
    codepoint: 0xf024,
    categories: [ 11 ],
    tags: [ 11654, 11656, 4310, 798, 2515, 4825, 445, 1434, 787, 2395, 1673, 2590, 11649, 965, 999, 7502, 1435, 215, 1897, 5650, 5207, 11688, 2307, 1004, 5208, 1444, 1445, 75, 1446, 11660, 77, 1155, 32, 4323, 11661, 11689, 1054 ],
  ),
  "home_max_dots": SymbolsMetadata(
    popularity: 213,
    codepoint: 0xe849,
    categories: [ 10 ],
    tags: [ 3210, 6323, 3213, 84, 7, 798, 3234, 2515, 4825, 445, 956, 1434, 3216, 786, 787, 1951, 1189, 965, 999, 3235, 7502, 1435, 215, 7498, 788, 789, 1004, 656, 3097, 5208, 11659, 75, 1446, 77, 65, 1155, 1901, 108, 791, 234 ],
  ),
  "home_mini": SymbolsMetadata(
    popularity: 169,
    codepoint: 0xf025,
    categories: [ 11 ],
    tags: [ 11690, 11654, 3621, 84, 798, 383, 2515, 4825, 445, 1370, 1434, 2590, 2873, 965, 999, 7502, 1205, 1435, 1897, 5650, 11658, 5207, 2068, 7792, 421, 1004, 3362, 5208, 11659, 1446, 2495, 105, 11691, 1155, 1378, 11661, 11689 ],
  ),
  "home_pin": SymbolsMetadata(
    popularity: 10663,
    codepoint: 0xf14d,
    categories: [ 5 ],
    tags: [ 1429, 11692, 1484, 388, 11693, 11649, 1488, 999, 11694, 11695, 11696, 11697, 1435, 11698, 1001, 1002, 8776, 1490, 21, 421, 1493, 1494, 1495, 1363, 1443, 1444, 11699, 1446, 11700, 11660, 1447, 11662, 1083 ],
  ),
  "home_repair_service": SymbolsMetadata(
    popularity: 2445,
    codepoint: 0xf100,
    categories: [ 5 ],
    tags: [ 7, 5238, 798, 3723, 5241, 2832, 1269, 11701, 2523, 1737, 3489, 5812, 999, 5813, 11682, 11702, 1435, 11703, 366, 2770, 5197, 2585, 1444, 1445, 75, 5815, 3474, 11704, 11705, 2631, 674, 2537, 11299, 11706, 2756, 5743 ],
  ),
  "home_speaker": SymbolsMetadata(
    popularity: 242,
    codepoint: 0xf11c,
    categories: [ 10 ],
    tags: [ 3211, 3213, 1129, 8645, 11707, 10944, 445, 1711, 1189, 3406, 999, 11708, 10948, 1896, 1897, 1143, 2081, 9566, 2162, 1945, 75, 1155, 1901, 3219, 1156, 3410, 3380, 1157, 11709, 3411, 551, 6366, 1161, 1745, 11710 ],
  ),
  "home_storage": SymbolsMetadata(
    popularity: 365,
    codepoint: 0xf86c,
    categories: [ 10 ],
    tags: [ 2151, 3433, 7, 3741, 1269, 1042, 10, 3756, 6936, 5243, 337, 1530, 1655, 999, 11711, 1435, 1066, 2159, 8486, 11712, 11713, 940, 11714, 2843, 1664, 3761, 107, 674, 441, 346, 11715 ],
  ),
  "home_work": SymbolsMetadata(
    popularity: 3343,
    codepoint: 0xea09,
    categories: [ 5 ],
    tags: [ 1429, 2601, 798, 11716, 11717, 2063, 2605, 999, 11694, 11509, 7790, 1435, 2791, 11718, 1001, 1002, 1490, 421, 1456, 11719, 11720, 1495, 2614, 75, 11721, 1446, 2616, 2617, 32, 11722, 1701, 6577, 1459, 11723, 6578, 1460 ],
  ),
  "horizontal_distribute": SymbolsMetadata(
    popularity: 274,
    codepoint: 0xe014,
    categories: [ 12 ],
    tags: [ 2167, 2169, 1367, 2170, 588, 2173, 5920, 2174, 2201, 2269, 11724, 1372, 2175, 2176, 11725, 2178, 306, 366, 8985, 940, 98, 1770, 2180, 1496, 5972, 601, 2181, 2993, 609, 2248, 2182, 38, 2251, 441, 1592 ],
  ),
  "horizontal_rule": SymbolsMetadata(
    popularity: 1581,
    codepoint: 0xf108,
    categories: [ 12 ],
    tags: [ 4820, 994, 2136, 1042, 11726, 11727, 4832, 696, 2175, 11728, 2176, 1205, 11729, 7707, 6584, 1602, 11730, 10482, 11731, 11732, 9986, 2180, 601, 11733, 11734, 4822, 2182, 11735, 38, 11736, 11737, 4853 ],
  ),
  "horizontal_split": SymbolsMetadata(
    popularity: 357,
    codepoint: 0xe947,
    categories: [ 12 ],
    tags: [ 1367, 365, 802, 1042, 1370, 1372, 2176, 10968, 2080, 11738, 1066, 306, 366, 92, 788, 421, 656, 98, 1068, 1770, 11739, 2295, 75, 1376, 3423, 3424, 2264, 65, 1378, 107, 1069, 440, 441, 317, 1054 ],
  ),
  "host": SymbolsMetadata(
    popularity: 185,
    codepoint: 0xf3d9,
    categories: [ 11 ],
    tags: [ 1429, 1747, 365, 1652, 6501, 11740, 1368, 802, 694, 11741, 211, 5068, 3756, 8276, 8277, 6788, 246, 11742, 5072, 135, 5073, 215, 5075, 8278, 92, 972, 936, 3764, 223, 11743, 2294, 1194, 4321, 11744, 3761, 11745, 2631, 674, 2632, 551, 315, 11746 ],
  ),
  "hot_tub": SymbolsMetadata(
    popularity: 528,
    codepoint: 0xeb46,
    categories: [ 8 ],
    tags: [ 1940, 3950, 3953, 1868, 3970, 5173, 3076, 3078, 3957, 2607, 483, 3973, 11747, 3344, 489, 3962, 3347, 1958, 1959, 4202, 3964, 3998, 3965, 3966, 3967, 3977, 11748, 11749, 727, 1504, 3969, 2024, 3978, 2801, 1905 ],
  ),
  "hotel": SymbolsMetadata(
    popularity: 2666,
    codepoint: 0xe53a,
    categories: [ 16 ],
    tags: [ 11750, 2599, 1909, 584, 1936, 1942, 11751, 383, 1659, 8450, 2080, 4217, 2607, 11752, 483, 11753, 11754, 2610, 2611, 4221, 488, 489, 4222, 11755, 1924, 1925, 1960, 11756, 1929, 3846, 1504, 1591, 2024 ],
    rtlAutoMirrored: true,
  ),
  "hotel_class": SymbolsMetadata(
    popularity: 2459,
    codepoint: 0xe743,
    categories: [ 6 ],
    tags: [ 2599, 3, 1940, 6, 1670, 11757, 1913, 3578, 480, 11758, 11759, 3019, 4217, 2607, 11760, 11761, 1251, 2610, 1944, 10327, 11762, 531, 62, 101, 3582, 286, 102, 3184, 3584, 1664, 4271, 2631, 311, 3586, 3264, 11763, 11764, 1504, 11765 ],
    rtlAutoMirrored: true,
  ),
  "hourglass": SymbolsMetadata(
    popularity: 155,
    codepoint: 0xebff,
    categories: [ 6 ],
    tags: [ 1016, 2092, 2137, 1020, 4013, 4043, 6407, 1023, 6419, 11766, 2568, 11767, 597, 634, 3548, 2841, 11768, 5591, 942, 28, 11769, 3933, 11770, 11771, 11772, 289, 11773, 1033, 11774, 2147, 11775, 5996 ],
  ),
  "hourglass_arrow_down": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf37e,
    categories: [ 2 ],
    tags: [ 2151, 380, 1016, 2092, 2137, 2651, 337, 11776, 1020, 4013, 926, 4043, 6407, 1023, 6419, 11777, 1542, 2568, 3548, 421, 2841, 28, 2342, 3933, 1664, 289, 11778, 11779, 1033, 2007, 1676, 2147, 5996 ],
  ),
  "hourglass_arrow_up": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf37d,
    categories: [ 2 ],
    tags: [ 6405, 380, 2092, 2137, 2651, 1020, 4013, 1022, 11780, 4043, 6407, 1023, 6419, 11781, 1207, 2568, 3548, 421, 2841, 2142, 28, 1031, 2343, 231, 11782, 1412, 289, 11783, 6408, 1033, 1676, 346, 2147, 5996 ],
  ),
  "hourglass_bottom": SymbolsMetadata(
    popularity: 2621,
    codepoint: 0xea5c,
    categories: [ 7 ],
    tags: [ 11784, 2188, 1016, 2092, 1018, 2137, 1020, 6407, 5042, 1023, 6419, 11766, 11785, 6265, 11786, 2568, 597, 634, 2096, 3548, 2841, 1082, 2858, 28, 3933, 11772, 289, 11787, 1033, 2147, 5996 ],
  ),
  "hourglass_disabled": SymbolsMetadata(
    popularity: 577,
    codepoint: 0xef53,
    categories: [ 6 ],
    tags: [ 894, 1075, 1016, 2092, 2137, 11788, 767, 4013, 898, 2139, 6419, 11789, 11790, 11791, 901, 2568, 2096, 3548, 11792, 11793, 11794, 11795, 907, 909, 11796, 2142, 171, 914, 2684, 289, 11797, 2127, 11798, 1033, 2128, 915, 2147, 11799, 5996 ],
  ),
  "hourglass_empty": SymbolsMetadata(
    popularity: 4055,
    codepoint: 0xe88b,
    categories: [ 6 ],
    tags: [ 11784, 2092, 2137, 1020, 11800, 4013, 11801, 4043, 6407, 1023, 6419, 11802, 11766, 11803, 2568, 11767, 3548, 2841, 1082, 2858, 28, 11769, 11771, 11772, 289, 11773, 1033, 11774, 2147, 11775, 5996 ],
  ),
  "hourglass_pause": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf38c,
    categories: [ 6 ],
    tags: [ 2136, 269, 785, 2092, 11804, 2137, 11805, 4013, 4043, 2139, 6419, 11806, 11807, 3449, 2568, 367, 3548, 2081, 11808, 1082, 11809, 11796, 11810, 2858, 2142, 11811, 28, 8393, 11812, 11813, 2145, 289, 2099, 4266, 1033, 41, 2147, 5996, 11814 ],
  ),
  "hourglass_top": SymbolsMetadata(
    popularity: 2910,
    codepoint: 0xea5b,
    categories: [ 7 ],
    tags: [ 1016, 2092, 1020, 6407, 5042, 1023, 6419, 11815, 11816, 6265, 2568, 597, 634, 2096, 3548, 2841, 1082, 2858, 7618, 28, 3933, 11770, 11771, 289, 1033, 1124, 11817, 2147, 5996, 11818 ],
  ),
  "house": SymbolsMetadata(
    popularity: 8877,
    codepoint: 0xea44,
    categories: [ 8 ],
    tags: [ 2601, 11656, 798, 11716, 5262, 2515, 1433, 2604, 1434, 2605, 867, 11649, 999, 11509, 7502, 1435, 2791, 1436, 5650, 5207, 1495, 2613, 1444, 2614, 1445, 1446, 2616, 11660, 823, 2617, 11819, 11661, 945, 1054 ],
  ),
  "house_siding": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xf202,
    categories: [ 8 ],
    tags: [ 2601, 798, 11716, 2832, 11701, 1434, 2605, 3838, 11820, 999, 11509, 5813, 11821, 2080, 1435, 2791, 2608, 1444, 11822, 2614, 1445, 7216, 5815, 3474, 1446, 2616, 823, 2617, 11823, 441, 11210 ],
  ),
  "house_with_shield": SymbolsMetadata(
    popularity: 209,
    codepoint: 0xe786,
    categories: [ 10 ],
    tags: [ 1244, 798, 7870, 11824, 11825, 999, 11509, 11826, 11827, 5512, 1435, 2791, 11828, 5668, 1004, 1444, 11829, 11830, 11831, 1520, 11832, 1772, 11833, 602, 1773, 11834, 1011, 1522, 11404 ],
  ),
  "houseboat": SymbolsMetadata(
    popularity: 414,
    codepoint: 0xe584,
    categories: [ 16 ],
    tags: [ 2599, 2601, 3923, 2521, 11835, 2605, 5259, 11836, 11837, 11838, 5263, 2018, 999, 1435, 11839, 11840, 4615, 2610, 1490, 2529, 2532, 2533, 1495, 2614, 2615, 1446, 2616, 4620, 2476, 2617, 3846, 1504, 5209, 2024, 11841, 2801, 8129, 4609 ],
  ),
  "household_supplies": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xefa1,
    categories: [ 8 ],
    tags: [ 1868, 1869, 6342, 1871, 1889, 4005, 6345, 6332, 6347, 11842, 6817, 1436, 11843, 6348, 3972, 3802, 8579, 1877, 9942, 11844, 6350, 6337, 6338, 1883, 1884, 11845, 11846, 11847, 985, 2801, 11848 ],
  ),
  "hov": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf475,
    categories: [ 14 ],
    tags: [ 3325, 949, 5733, 2896, 2063, 4864, 269, 1781, 1416, 2941, 3327, 787, 1738, 10204, 1659, 11849, 3019, 1580, 6063, 11850, 11851, 188, 135, 8063, 4327, 1490, 788, 11577, 421, 1361, 1421, 1503, 371, 311, 313, 314, 6070, 1590, 1930 ],
  ),
  "how_to_reg": SymbolsMetadata(
    popularity: 5079,
    codepoint: 0xe174,
    categories: [ 6 ],
    tags: [ 1627, 11852, 1506, 1549, 2480, 3849, 1630, 1632, 1633, 1636, 2688, 1639, 3853, 2690, 7947, 1064, 1641, 853, 3118, 9036, 1643, 489, 3854, 490, 1256, 856, 288, 2696, 11853, 857, 1412, 1258, 1647, 11854, 11855, 2386, 2387, 1523, 2389, 3855, 1650 ],
  ),
  "how_to_vote": SymbolsMetadata(
    popularity: 1047,
    codepoint: 0xe175,
    categories: [ 15 ],
    tags: [ 3849, 3850, 7, 2053, 5950, 2447, 11856, 11857, 1540, 3027, 11858, 3853, 11859, 812, 7947, 1044, 6719, 1535, 10808, 3854, 7340, 75, 288, 371, 32, 1412, 1689, 1161, 3855, 3856 ],
  ),
  "hr_resting": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf6ba,
    categories: [ 15 ],
    tags: [ 2311, 11860, 4452, 2927, 595, 1753, 11861, 4455, 5788, 11862, 5778, 3569, 1205, 7707, 1602, 11863, 1757, 327, 3570, 286, 1663, 1958, 1925, 11864, 11415, 11865, 1929, 947, 1905 ],
  ),
  "html": SymbolsMetadata(
    popularity: 3059,
    codepoint: 0xeb7e,
    categories: [ 2 ],
    tags: [ 4, 11866, 3909, 1039, 8, 2624, 6581, 6582, 1186, 2625, 1347, 3327, 6583, 2835, 14, 7373, 339, 6584, 1472, 215, 5651, 6587, 19, 8815, 223, 1194, 2630, 1196, 3364, 35, 2384, 38, 441, 40, 1691, 1241, 1053, 5655 ],
  ),
  "http": SymbolsMetadata(
    popularity: 813,
    codepoint: 0xe902,
    categories: [ 6 ],
    tags: [ 186, 687, 1429, 4, 1039, 8, 443, 211, 10, 88, 8277, 14, 5071, 11626, 1472, 135, 215, 19, 223, 819, 5080, 1773, 3761, 35, 551, 38, 2007, 40, 1479, 1691, 1053, 4761, 5655 ],
  ),
  "hub": SymbolsMetadata(
    popularity: 6581,
    codepoint: 0xe9f4,
    categories: [ 7 ],
    tags: [ 1994, 3026, 1730, 11867, 383, 953, 194, 921, 211, 6768, 11447, 2173, 11868, 2210, 956, 11869, 930, 931, 3236, 1064, 935, 1000, 223, 7937, 11870, 3282, 939, 11454, 5039, 1665, 3058, 11871 ],
  ),
  "humerus": SymbolsMetadata(
    popularity: 183,
    codepoint: 0xf895,
    categories: [ 3 ],
    tags: [ 3919, 5177, 8988, 11872, 2412, 584, 4289, 9622, 2136, 9623, 11873, 11874, 9625, 11875, 9628, 595, 11876, 3201, 1757, 9633, 7365, 1723, 9642, 9636, 11877, 2543, 5319, 11878, 11879, 9644 ],
  ),
  "humerus_alt": SymbolsMetadata(
    popularity: 149,
    codepoint: 0xf896,
    categories: [ 3 ],
    tags: [ 3466, 3919, 8988, 11880, 11376, 2412, 584, 4289, 11881, 9622, 2136, 11882, 2053, 2482, 4472, 11875, 9628, 11883, 595, 1753, 483, 11876, 3201, 9632, 1757, 1663, 9642, 9636, 11884, 495, 11885 ],
  ),
  "humidity_high": SymbolsMetadata(
    popularity: 778,
    codepoint: 0xf163,
    categories: [ 8 ],
    tags: [ 1847, 712, 5721, 11886, 7990, 1500, 4471, 1890, 2790, 6392, 2471, 11887, 11888, 1904, 2798, 1857, 2799, 11889, 7995, 7486, 11890, 11748, 11891, 5610, 8573, 2801, 8244, 7998, 731, 11892 ],
  ),
  "humidity_indoor": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf558,
    categories: [ 10 ],
    tags: [ 707, 709, 1847, 2148, 2777, 798, 712, 1914, 269, 1500, 4471, 1890, 999, 1435, 1904, 11893, 723, 2793, 11894, 2795, 2796, 2799, 62, 1446, 122, 1901, 729, 8573, 2801, 731 ],
  ),
  "humidity_low": SymbolsMetadata(
    popularity: 746,
    codepoint: 0xf164,
    categories: [ 8 ],
    tags: [ 707, 8563, 1847, 712, 8564, 8565, 7990, 1500, 4471, 11895, 7165, 11896, 11897, 1890, 2926, 1904, 4014, 11898, 11899, 11900, 1857, 2799, 1361, 7618, 11890, 11891, 5610, 11901, 8573, 2801, 11902, 731 ],
  ),
  "humidity_mid": SymbolsMetadata(
    popularity: 674,
    codepoint: 0xf165,
    categories: [ 8 ],
    tags: [ 1847, 712, 7990, 1500, 4471, 1890, 6392, 3560, 11903, 4034, 1904, 11904, 188, 2472, 597, 634, 1857, 5682, 11905, 4045, 2799, 11890, 11906, 11891, 5610, 8573, 2801, 11907, 731, 11892 ],
  ),
  "humidity_percentage": SymbolsMetadata(
    popularity: 12,
    codepoint: 0xf87e,
    categories: [ 3 ],
    tags: [ 11908, 1847, 712, 5721, 11909, 7991, 1500, 11910, 4471, 1890, 1904, 11911, 10170, 188, 2472, 1857, 2799, 6413, 4142, 7995, 7277, 7486, 3149, 7996, 11891, 5610, 8573, 2801, 8244, 11907, 731 ],
  ),
  "hvac": SymbolsMetadata(
    popularity: 343,
    codepoint: 0xf10e,
    categories: [ 8 ],
    tags: [ 705, 707, 709, 5689, 1846, 5676, 11912, 383, 712, 713, 716, 718, 719, 926, 9182, 5673, 3235, 723, 10171, 366, 4370, 1901, 32, 2586, 727, 729, 5677, 730 ],
  ),
  "hvac_max_defrost": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf332,
    categories: [ 14 ],
    tags: [ 705, 709, 1886, 1814, 3467, 1815, 712, 713, 714, 2079, 5669, 11913, 5670, 5679, 3076, 5673, 723, 724, 11688, 5038, 11914, 725, 727, 441, 1844, 3978, 1902, 5680, 5675, 732 ],
  ),
  "ice_skating": SymbolsMetadata(
    popularity: 325,
    codepoint: 0xe50b,
    categories: [ 15 ],
    tags: [ 989, 8149, 8456, 4382, 3074, 5600, 714, 3337, 2925, 11915, 11916, 11917, 11918, 6190, 11919, 2018, 724, 11920, 11921, 3344, 11922, 3347, 11923, 8328, 11924, 11925, 11926, 4787, 725, 607, 5780, 3595, 1504, 732, 11927, 5289 ],
  ),
  "icecream": SymbolsMetadata(
    popularity: 1109,
    codepoint: 0xea69,
    categories: [ 16 ],
    tags: [ 11928, 714, 5936, 11929, 11930, 11931, 3797, 5310, 1829, 4389, 11917, 11932, 11933, 11934, 724, 11935, 11936, 11937, 6374, 11938, 3809, 11939, 11940, 11941, 4206, 11942, 11943, 3810, 5319, 11944 ],
  ),
  "id_card": SymbolsMetadata(
    popularity: 147,
    codepoint: 0xf4ca,
    categories: [ 13 ],
    tags: [ 755, 468, 1768, 470, 6, 799, 475, 3763, 132, 1347, 11945, 11946, 479, 483, 3167, 3168, 11947, 2809, 850, 135, 3361, 852, 853, 3118, 3764, 488, 3766, 489, 790, 490, 75, 1011, 501, 2388, 1459 ],
  ),
  "identity_aware_proxy": SymbolsMetadata(
    popularity: 51,
    codepoint: 0xe2dd,
    categories: [ 13 ],
    tags: [ 755, 468, 1230, 1768, 1769, 11948, 1652, 211, 10, 956, 11949, 5647, 2080, 11950, 850, 11951, 215, 852, 223, 1516, 1520, 11952, 1011, 3761, 2631, 32, 441, 501, 11953 ],
  ),
  "identity_platform": SymbolsMetadata(
    popularity: 823,
    codepoint: 0xebb7,
    categories: [ 3 ],
    tags: [ 755, 468, 1768, 1769, 470, 383, 6991, 6993, 479, 1659, 930, 1661, 483, 850, 11954, 885, 852, 936, 8261, 223, 940, 488, 489, 1194, 1516, 490, 1011, 65, 311, 857, 946, 858, 501, 11955 ],
  ),
  "ifl": SymbolsMetadata(
    popularity: 202,
    codepoint: 0xe025,
    categories: [ 15 ],
    tags: [ 82, 6183, 5845, 5848, 5850, 11956, 956, 9001, 5855, 697, 338, 11957, 11958, 5858, 11959, 2162, 5859, 5860, 11960, 5540, 78, 980, 5862, 32, 11961, 374, 983, 791, 11962, 11963 ],
  ),
  "iframe": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf71b,
    categories: [ 2 ],
    tags: [ 2624, 1269, 2577, 11964, 12, 2970, 11965, 1471, 274, 6584, 11966, 11967, 11968, 1044, 2629, 4964, 938, 4139, 5653, 75, 330, 32, 11969, 2384, 11970, 7378, 1241, 1053, 1054 ],
  ),
  "iframe_off": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf71c,
    categories: [ 2 ],
    tags: [ 1074, 895, 2624, 1202, 897, 1077, 767, 12, 2970, 7894, 898, 8363, 11965, 899, 274, 6584, 11966, 11967, 2629, 11971, 907, 908, 909, 4139, 75, 911, 171, 330, 914, 6589, 32, 2384, 11972, 915, 1241, 1053, 1054 ],
  ),
  "image": SymbolsMetadata(
    popularity: 17000,
    codepoint: 0xe3f4,
    categories: [ 1 ],
    tags: [ 526, 1221, 1538, 349, 1042, 4825, 12, 274, 1541, 53, 1542, 1044, 10487, 1543, 367, 1544, 1545, 11973, 1361, 2474, 59, 61, 119, 1048, 75, 1546, 32, 346, 11974, 317 ],
  ),
  "image_arrow_up": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf317,
    categories: [ 1 ],
    tags: [ 380, 2052, 419, 11975, 11976, 11977, 1541, 53, 1224, 11978, 1543, 367, 1544, 1545, 11979, 11980, 11981, 59, 11982, 61, 119, 1225, 11983, 11984, 11985, 11986, 11987, 11988, 11989, 32, 11990, 11991, 11992, 1676, 1677, 346, 6552 ],
  ),
  "image_aspect_ratio": SymbolsMetadata(
    popularity: 182,
    codepoint: 0xe3f5,
    categories: [ 1 ],
    tags: [ 2300, 3142, 1128, 3143, 2301, 694, 268, 2919, 1819, 12, 956, 787, 1372, 3633, 53, 11993, 117, 1543, 367, 219, 59, 61, 119, 854, 3149, 75, 2247, 2281, 331, 3152, 65, 32, 791, 41, 2309 ],
  ),
  "image_search": SymbolsMetadata(
    popularity: 1453,
    codepoint: 0xe43f,
    categories: [ 1 ],
    tags: [ 4292, 958, 11994, 960, 11995, 11996, 11997, 11998, 11999, 964, 53, 12000, 12001, 12002, 12003, 12004, 1543, 971, 974, 975, 976, 1544, 1545, 59, 12005, 12006, 61, 119, 12007, 12008, 980, 12009, 12010, 12011, 981 ],
  ),
  "imagesearch_roller": SymbolsMetadata(
    popularity: 681,
    codepoint: 0xe9b4,
    categories: [ 12 ],
    tags: [ 2687, 2829, 12012, 2832, 4365, 5163, 7572, 12013, 12014, 5809, 3489, 5813, 1435, 53, 12004, 12015, 2770, 5166, 12016, 5169, 75, 7216, 5815, 3474, 10545, 980, 2438, 2537, 5020 ],
  ),
  "imagesmode": SymbolsMetadata(
    popularity: 3127,
    codepoint: 0xefa2,
    categories: [ 1 ],
    tags: [ 1220, 1538, 5249, 12017, 12, 1541, 53, 12018, 12019, 12020, 12021, 12022, 5799, 10487, 1543, 367, 307, 1544, 1545, 2558, 59, 12023, 61, 5800, 119, 12024, 5801, 1546, 3686, 12025, 317, 12026 ],
  ),
  "immunology": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xe0fb,
    categories: [ 3 ],
    tags: [ 2410, 12027, 6331, 10818, 2412, 584, 1113, 2854, 2414, 6333, 595, 1753, 483, 2417, 12028, 2418, 2420, 6336, 12029, 2434, 4474, 1757, 1760, 7182, 4355, 10829, 7184, 1520, 4359, 2424, 2426, 10180, 5193, 12030 ],
  ),
  "import_contacts": SymbolsMetadata(
    popularity: 4931,
    codepoint: 0xe0e0,
    categories: [ 7 ],
    tags: [ 526, 12031, 1429, 6934, 1910, 6985, 848, 1707, 12032, 10, 6936, 1347, 1542, 12033, 484, 135, 4686, 3375, 2653, 3463, 1534, 3464, 2506, 2507, 4691, 2007, 12034, 346, 12035 ],
  ),
  "important_devices": SymbolsMetadata(
    popularity: 957,
    codepoint: 0xe912,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1113, 694, 1685, 445, 2673, 12036, 4182, 7953, 12, 3578, 4738, 4798, 965, 3019, 1114, 1251, 12037, 12038, 219, 327, 12039, 226, 12040, 12041, 4758, 330, 12042, 446, 3264, 447, 12043, 1691 ],
  ),
  "in_home_mode": SymbolsMetadata(
    popularity: 528,
    codepoint: 0xe833,
    categories: [ 8 ],
    tags: [ 2014, 3063, 1630, 6100, 12044, 1632, 1633, 1636, 1434, 999, 12045, 1435, 12046, 1436, 12047, 1001, 1641, 1004, 1643, 1495, 5591, 1444, 1446, 2495, 1772, 1773, 12048, 12049, 2487, 1647, 2386, 2387, 1523 ],
  ),
  "inactive_order": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xe0fc,
    categories: [ 9 ],
    tags: [ 1549, 3115, 797, 1630, 383, 1633, 1528, 1347, 1639, 1530, 595, 2139, 901, 12050, 7190, 366, 92, 1641, 1759, 3155, 907, 1643, 96, 8496, 1534, 1535, 1082, 11796, 2858, 840, 12051, 12052, 12053, 12054, 288, 2684, 1645, 1647, 1214, 3517, 2386, 1523, 12055, 1650 ],
  ),
  "inbox": SymbolsMetadata(
    popularity: 2773,
    codepoint: 0xe156,
    categories: [ 7 ],
    tags: [ 2151, 5918, 472, 443, 475, 1269, 2331, 2332, 1347, 2335, 482, 851, 2338, 135, 4704, 2340, 485, 763, 486, 2506, 2342, 3331, 1121, 32, 674, 495, 2344, 2664 ],
  ),
  "inbox_customize": SymbolsMetadata(
    popularity: 202,
    codepoint: 0xf859,
    categories: [ 7 ],
    tags: [ 1128, 1230, 2151, 1731, 4175, 4176, 443, 268, 269, 2331, 7019, 1735, 132, 696, 2335, 1656, 3485, 851, 2338, 484, 135, 4704, 2340, 1755, 485, 1740, 656, 98, 790, 2695, 329, 2342, 2631, 65, 2649, 32, 441, 2344 ],
  ),
  "inbox_text": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf399,
    categories: [ 7 ],
    tags: [ 2151, 5918, 472, 443, 1269, 2331, 1347, 2335, 2080, 851, 2338, 135, 966, 4704, 92, 2340, 485, 1408, 1533, 486, 1770, 2506, 2342, 12056, 1121, 32, 674, 38, 441, 2344, 2664 ],
  ),
  "inbox_text_asterisk": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf360,
    categories: [ 7 ],
    tags: [ 469, 3254, 2151, 3255, 3073, 5918, 443, 693, 1347, 1853, 696, 2335, 480, 4720, 3259, 3019, 1251, 851, 2338, 366, 2340, 1641, 485, 763, 1532, 486, 4758, 2506, 1030, 3264, 35, 38, 441, 2664 ],
  ),
  "inbox_text_person": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf35e,
    categories: [ 7 ],
    tags: [ 468, 2151, 5918, 472, 383, 443, 475, 2331, 1347, 2335, 482, 483, 851, 2338, 135, 4704, 366, 92, 2340, 485, 486, 488, 489, 490, 2506, 2342, 12057, 12058, 32, 495, 38, 2664, 501 ],
  ),
  "inbox_text_share": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf35c,
    categories: [ 7 ],
    tags: [ 2151, 1994, 5918, 443, 921, 211, 476, 10, 2173, 1347, 956, 2335, 1672, 1530, 777, 1542, 851, 2338, 935, 2340, 485, 223, 939, 78, 2343, 1665, 3058, 607, 32, 38, 441 ],
  ),
  "incomplete_circle": SymbolsMetadata(
    popularity: 967,
    codepoint: 0xe79b,
    categories: [ 1 ],
    tags: [ 12059, 2565, 5290, 920, 383, 12060, 6410, 385, 337, 7646, 2659, 3053, 1674, 2568, 3054, 390, 4100, 8430, 6412, 2858, 3055, 6418, 28, 3056, 4850, 1667, 3529, 12061, 8498, 1260, 346, 2147 ],
  ),
  "indeterminate_check_box": SymbolsMetadata(
    popularity: 2870,
    codepoint: 0xe909,
    categories: [ 2 ],
    tags: [ 1229, 1230, 7, 298, 1630, 6086, 2447, 4864, 2750, 269, 2448, 299, 1598, 2176, 6109, 6111, 6112, 966, 2751, 6113, 1602, 1116, 12062, 12063, 281, 4138, 12064, 330, 288, 4751, 371, 2882, 32, 12065, 1647, 314, 2757, 12066, 6095, 12067, 5588, 2759, 1691, 1053 ],
  ),
  "indeterminate_question_box": SymbolsMetadata(
    popularity: 89,
    codepoint: 0xf56d,
    categories: [ 6 ],
    tags: [ 4095, 12068, 738, 7, 3909, 2391, 12069, 960, 1738, 274, 482, 7947, 2810, 6111, 484, 135, 1489, 4101, 979, 4102, 11506, 4103, 1723, 371, 32, 495, 35, 36, 10981, 1364, 12070, 10982, 7951, 7952 ],
  ),
  "info": SymbolsMetadata(
    popularity: 56547,
    codepoint: 0xe88e,
    categories: [ 6 ],
    tags: [ 5461, 6323, 7529, 469, 1245, 5171, 738, 383, 10, 6325, 132, 832, 6326, 6951, 3226, 482, 6063, 5463, 16, 484, 135, 7920, 4686, 4695, 10290, 789, 1363, 4102, 2631, 495, 35, 7531 ],
  ),
  "info_i": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xf59b,
    categories: [ 6 ],
    tags: [ 5461, 7529, 469, 1245, 738, 383, 6325, 132, 832, 6326, 6951, 3225, 482, 6063, 5463, 484, 135, 5485, 7920, 4686, 4695, 12071, 1602, 10290, 7921, 789, 979, 2631, 495, 7531, 1215 ],
  ),
  "infrared": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf87c,
    categories: [ 3 ],
    tags: [ 1180, 2827, 2148, 3669, 355, 443, 212, 269, 2079, 3050, 2805, 445, 12072, 1711, 3076, 12073, 12074, 223, 12075, 12076, 1318, 5716, 122, 227, 551, 441, 4307, 12077, 1902, 234 ],
  ),
  "ink_eraser": SymbolsMetadata(
    popularity: 294,
    codepoint: 0xe6d0,
    categories: [ 12 ],
    tags: [ 2829, 12078, 895, 1871, 3436, 4848, 2376, 3181, 897, 1528, 302, 9143, 696, 2299, 1371, 9144, 2279, 2725, 12079, 1602, 9149, 8005, 5166, 2019, 2693, 911, 7669, 4786, 12080, 1379, 3296, 4818, 2182, 38, 2537, 40, 2499, 6357, 704, 8781 ],
  ),
  "ink_eraser_off": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xe7e3,
    categories: [ 12 ],
    tags: [ 3254, 12081, 895, 3436, 4848, 4563, 897, 3304, 12082, 767, 1528, 302, 696, 2299, 1371, 3438, 9144, 2279, 899, 901, 2725, 12079, 12083, 12084, 1532, 1533, 907, 5166, 2693, 911, 12085, 4786, 5170, 12086, 914, 1379, 2182, 38, 40, 915, 2499, 704 ],
  ),
  "ink_highlighter": SymbolsMetadata(
    popularity: 231,
    codepoint: 0xe6d1,
    categories: [ 12 ],
    tags: [ 8521, 3254, 4848, 1528, 1347, 2834, 302, 696, 2299, 1371, 3258, 10501, 9144, 2279, 3019, 10502, 2725, 1641, 21, 8815, 1532, 1533, 1456, 5166, 2693, 75, 3158, 288, 371, 4786, 12080, 1379, 3296, 2182, 38, 7476, 40, 2498, 10454, 704 ],
  ),
  "ink_highlighter_move": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf524,
    categories: [ 12 ],
    tags: [ 3254, 4848, 2448, 1528, 1347, 3007, 302, 696, 2299, 4586, 1371, 9144, 1022, 2279, 3019, 10502, 12087, 2725, 366, 21, 8815, 420, 778, 1532, 1533, 3330, 5166, 2693, 1027, 75, 8544, 7073, 288, 4786, 3036, 231, 1379, 2182, 38, 441, 2007, 40, 704 ],
    rtlAutoMirrored: true,
  ),
  "ink_marker": SymbolsMetadata(
    popularity: 47,
    codepoint: 0xe6d2,
    categories: [ 12 ],
    tags: [ 8521, 2829, 4848, 693, 1201, 9154, 1528, 1347, 2834, 9143, 696, 2299, 1371, 12088, 2279, 3019, 10502, 5165, 2725, 1602, 6627, 21, 1532, 5166, 2693, 75, 4786, 7494, 6122, 5170, 1379, 3296, 4818, 2182, 38, 7531, 8162, 40, 2498, 1536, 704 ],
  ),
  "ink_pen": SymbolsMetadata(
    popularity: 275,
    codepoint: 0xe6d3,
    categories: [ 12 ],
    tags: [ 8521, 2501, 1400, 4848, 693, 1201, 2969, 3458, 1528, 1347, 2834, 696, 2299, 1371, 2279, 2725, 966, 3461, 21, 1532, 5166, 2693, 2694, 8526, 4786, 7494, 6122, 5170, 1379, 3296, 2510, 2182, 38, 441, 2537, 40, 1536, 704 ],
  ),
  "ink_selection": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xe6d4,
    categories: [ 12 ],
    tags: [ 380, 349, 266, 4848, 12089, 1781, 12090, 1528, 1347, 12091, 696, 2299, 1371, 2279, 274, 3019, 12087, 2725, 12092, 2875, 1641, 5166, 2693, 2694, 3021, 1783, 1007, 288, 2381, 1012, 371, 4786, 1379, 32, 2182, 38, 7476, 11580, 40, 704 ],
  ),
  "inpatient": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xe0fe,
    categories: [ 3 ],
    tags: [ 468, 526, 4710, 6879, 2014, 380, 2489, 1909, 584, 1942, 1749, 1202, 2909, 595, 1753, 1754, 483, 3091, 12093, 10171, 1375, 1757, 1762, 489, 202, 2876, 490, 2495, 1960, 501, 12094 ],
  ),
  "input": SymbolsMetadata(
    popularity: 2249,
    codepoint: 0xe890,
    categories: [ 6 ],
    tags: [ 755, 468, 1230, 380, 1768, 1769, 7, 776, 3763, 6103, 337, 2909, 1597, 1598, 777, 6105, 1542, 966, 12095, 852, 853, 778, 2653, 5653, 781, 490, 1396, 782, 2913, 1412, 501, 1691 ],
    rtlAutoMirrored: true,
  ),
  "input_circle": SymbolsMetadata(
    popularity: 61,
    codepoint: 0xf71a,
    categories: [ 2 ],
    tags: [ 526, 380, 2891, 2892, 419, 2466, 2871, 383, 2902, 1540, 388, 2909, 787, 1542, 966, 12096, 1044, 2795, 1674, 12097, 2958, 421, 3070, 2653, 1409, 2504, 12098, 2343, 1665, 1412, 1124, 1676, 1677, 346 ],
  ),
  "insert_chart": SymbolsMetadata(
    popularity: 3575,
    codepoint: 0xe24b,
    categories: [ 9 ],
    tags: [ 2513, 5, 1343, 1344, 1345, 365, 1284, 920, 10, 924, 808, 929, 933, 1044, 597, 634, 937, 189, 2400, 28, 75, 1353, 1354, 2851, 32, 33, 440, 947, 2852, 2253, 1355, 2519 ],
  ),
  "insert_page_break": SymbolsMetadata(
    popularity: 282,
    codepoint: 0xeaca,
    categories: [ 12 ],
    tags: [ 12099, 1228, 2136, 1042, 2448, 2449, 1370, 1528, 1347, 696, 1530, 2175, 1044, 12100, 306, 10083, 1236, 1534, 9986, 12101, 1535, 1377, 11733, 2264, 4786, 1378, 38, 12102, 2185, 704 ],
  ),
  "insert_text": SymbolsMetadata(
    popularity: 44,
    codepoint: 0xf827,
    categories: [ 12 ],
    tags: [ 4, 349, 8, 2391, 1528, 696, 8777, 2299, 1371, 14, 1372, 274, 7022, 1044, 11578, 12103, 19, 1361, 4786, 1379, 32, 2182, 35, 12104, 38, 6079, 6080, 12105, 2229, 12106, 3733, 10564, 3734, 11581, 40, 11582, 3735, 702, 3025, 1536, 704 ],
  ),
  "install_desktop": SymbolsMetadata(
    popularity: 1308,
    codepoint: 0xeb71,
    categories: [ 2 ],
    tags: [ 1109, 1110, 526, 1230, 380, 2650, 1684, 694, 12107, 3064, 1685, 12108, 12109, 445, 88, 12, 337, 12110, 1737, 2652, 965, 1114, 5195, 1542, 1674, 12111, 4867, 3513, 1687, 327, 12112, 6839, 1495, 2648, 12113, 1664, 330, 12114, 2649, 1196, 551, 2007, 1691, 1054, 6841 ],
  ),
  "instant_mix": SymbolsMetadata(
    popularity: 188,
    codepoint: 0xe026,
    categories: [ 0 ],
    tags: [ 1128, 5060, 1129, 12115, 794, 3233, 785, 7019, 1735, 12116, 696, 2299, 8229, 8230, 12117, 959, 7056, 4082, 12118, 934, 4985, 4399, 12119, 12120, 2081, 656, 189, 6296, 177, 12121, 310, 65, 372, 1743, 1156, 12122, 12123, 12124, 12125, 1744, 1745 ],
  ),
  "integration_instructions": SymbolsMetadata(
    popularity: 2509,
    codepoint: 0xef54,
    categories: [ 12 ],
    tags: [ 3105, 2622, 3909, 1631, 3592, 1750, 2624, 6580, 268, 6581, 6582, 1186, 2625, 1578, 1528, 1347, 6726, 6583, 12126, 1530, 3226, 12127, 6584, 5196, 7920, 4867, 2629, 92, 1533, 1194, 942, 2630, 2649, 1196, 109, 2384, 5881 ],
  ),
  "interactive_space": SymbolsMetadata(
    popularity: 65,
    codepoint: 0xf7ff,
    categories: [ 15 ],
    tags: [ 379, 2829, 381, 584, 383, 1416, 12128, 955, 12, 3153, 187, 11334, 958, 697, 12129, 483, 2644, 6036, 8063, 12130, 4695, 11339, 11340, 327, 278, 488, 489, 2823, 330, 11341, 609, 5781, 501, 2826, 405, 11344 ],
  ),
  "interests": SymbolsMetadata(
    popularity: 3134,
    codepoint: 0xe7c8,
    categories: [ 6 ],
    tags: [ 12131, 12132, 5916, 12133, 383, 1735, 12134, 4738, 12135, 1659, 304, 4455, 12136, 12137, 12138, 20, 4768, 12139, 656, 12140, 5921, 12141, 329, 12142, 5922, 607, 32, 12143, 12144, 1701 ],
  ),
  "interpreter_mode": SymbolsMetadata(
    popularity: 937,
    codepoint: 0xe83b,
    categories: [ 0 ],
    tags: [ 468, 1126, 738, 1129, 1134, 443, 1135, 476, 1136, 479, 867, 1137, 930, 1139, 1140, 483, 1141, 10752, 12145, 969, 5651, 1143, 8634, 1145, 1146, 1147, 307, 223, 1148, 488, 489, 1151, 490, 1153, 121, 1154, 177, 607, 1156, 492, 1157, 1172, 493, 495, 35, 496, 8027, 946, 7110, 8052, 501, 1159, 1161 ],
  ),
  "inventory": SymbolsMetadata(
    popularity: 9049,
    codepoint: 0xe179,
    categories: [ 12 ],
    tags: [ 1627, 2716, 2717, 1549, 2151, 7, 1630, 1631, 1750, 1633, 1636, 1528, 1347, 1639, 1530, 3065, 3895, 92, 3896, 1755, 936, 96, 98, 12146, 1622, 5619, 7119, 3899, 1645, 3159, 1647, 2165, 947, 2387, 2389, 3902 ],
  ),
  "inventory_2": SymbolsMetadata(
    popularity: 10890,
    codepoint: 0xe1a1,
    categories: [ 7 ],
    tags: [ 2151, 12147, 5249, 7, 1269, 2922, 897, 12148, 1530, 4918, 3895, 12149, 1620, 7648, 3896, 936, 1116, 940, 98, 12146, 1622, 12150, 2930, 911, 5619, 12151, 674, 12152, 1122, 11847, 7119, 3902 ],
  ),
  "invert_colors": SymbolsMetadata(
    popularity: 995,
    codepoint: 0xe891,
    categories: [ 1 ],
    tags: [ 1128, 1539, 1731, 6681, 1734, 7106, 6676, 5333, 1370, 1500, 4471, 696, 2299, 2567, 959, 5499, 12153, 53, 12154, 881, 12155, 1740, 3696, 6800, 12156, 59, 119, 2881, 310, 1378, 5256, 313, 5610, 314, 8034, 427, 2801, 8593 ],
  ),
  "invert_colors_off": SymbolsMetadata(
    popularity: 236,
    codepoint: 0xe0c4,
    categories: [ 1 ],
    tags: [ 733, 7061, 895, 383, 12157, 6681, 1734, 7063, 12158, 767, 1500, 4471, 898, 899, 12159, 12153, 12160, 12161, 881, 12162, 12163, 12155, 12164, 12165, 12166, 12167, 907, 908, 909, 12168, 12156, 12169, 12170, 914, 10066, 5610, 12171, 8034, 5587, 2801 ],
  ),
  "ios": SymbolsMetadata(
    popularity: 289,
    codepoint: 0xe027,
    categories: [ 4 ],
    tags: [ 2748, 2964, 12172, 12173, 2539, 445, 88, 965, 5463, 2888, 7987, 12174, 12175, 19, 2528, 12176, 1687, 219, 12177, 12178, 12179, 1192, 12180, 1193, 1194, 12181, 7374, 446, 1196, 2632, 447, 551, 38, 702 ],
  ),
  "ios_share": SymbolsMetadata(
    popularity: 6483,
    codepoint: 0xe6b8,
    categories: [ 2 ],
    tags: [ 949, 2964, 380, 2052, 7, 443, 211, 1042, 2173, 1672, 2628, 777, 16, 2888, 935, 367, 219, 223, 1409, 2504, 2343, 1665, 3058, 607, 32, 35, 2007, 1676, 346 ],
  ),
  "iron": SymbolsMetadata(
    popularity: 370,
    codepoint: 0xe583,
    categories: [ 8 ],
    tags: [ 1888, 4310, 8235, 2701, 12182, 2702, 12183, 1433, 4078, 2704, 12184, 2706, 8578, 3489, 3076, 3078, 1436, 6348, 12185, 12186, 12187, 8579, 1717, 422, 4987, 12188, 3497, 3967, 12189, 727, 2713, 12190, 12191 ],
  ),
  "jamboard_kiosk": SymbolsMetadata(
    popularity: 73,
    codepoint: 0xe9b5,
    categories: [ 11 ],
    tags: [ 1284, 1684, 3281, 694, 1685, 445, 8061, 12, 12192, 12193, 965, 135, 12194, 12195, 8064, 1145, 327, 2400, 5592, 12196, 75, 330, 12197, 32, 4323, 551, 6598, 10841, 9148 ],
  ),
  "javascript": SymbolsMetadata(
    popularity: 1912,
    codepoint: 0xeb7c,
    categories: [ 2 ],
    tags: [ 186, 4, 1230, 11866, 3909, 8, 2624, 12198, 6581, 6582, 1186, 2625, 6583, 2835, 14, 7373, 6584, 2780, 215, 6586, 12199, 12200, 12201, 19, 1194, 2630, 6588, 10972, 3379, 12202, 1196, 32, 35, 551, 38, 2788, 40, 1691, 7378, 1053 ],
  ),
  "join": SymbolsMetadata(
    popularity: 170,
    codepoint: 0xf84f,
    categories: [ 12 ],
    tags: [ 526, 9479, 1058, 4383, 383, 953, 3281, 1061, 954, 1633, 921, 9690, 4043, 6278, 930, 1206, 2629, 1209, 1064, 1375, 935, 390, 1145, 1067, 223, 4844, 4915, 5174, 8263, 1396, 7576, 6803, 8265, 6315, 11423 ],
  ),
  "join_inner": SymbolsMetadata(
    popularity: 676,
    codepoint: 0xeaf4,
    categories: [ 12 ],
    tags: [ 12203, 4859, 1058, 4383, 383, 953, 1061, 12204, 954, 12205, 921, 3087, 6317, 5443, 12206, 930, 4834, 4867, 1218, 1209, 1064, 935, 9128, 1145, 1067, 4915, 8263, 10324, 7576, 6803, 12207, 8265, 7389, 6315 ],
  ),
  "join_left": SymbolsMetadata(
    popularity: 417,
    codepoint: 0xeaf2,
    categories: [ 12 ],
    tags: [ 526, 2169, 9479, 1058, 4383, 383, 953, 384, 1061, 954, 921, 211, 6317, 12208, 9690, 930, 1206, 5948, 4867, 1218, 1064, 12209, 9630, 1375, 935, 390, 9128, 1145, 1067, 4915, 7576, 5137, 12207, 7389, 6315 ],
  ),
  "join_right": SymbolsMetadata(
    popularity: 359,
    codepoint: 0xeaea,
    categories: [ 12 ],
    tags: [ 526, 4859, 1058, 4383, 383, 953, 384, 3281, 1061, 954, 921, 211, 6317, 9690, 930, 1206, 5948, 4867, 1218, 1064, 12210, 9630, 935, 390, 9128, 1145, 1067, 4915, 8263, 1396, 7576, 5137, 12207, 7389, 6315 ],
  ),
  "joystick": SymbolsMetadata(
    popularity: 102,
    codepoint: 0xf5ee,
    categories: [ 11 ],
    tags: [ 688, 383, 1733, 3233, 269, 5258, 445, 388, 2651, 11247, 697, 10758, 5260, 338, 3489, 966, 11253, 1375, 778, 1858, 421, 656, 2162, 2904, 1396, 65, 2649, 32, 3493, 441, 1676, 41, 574, 11256 ],
  ),
  "jump_to_element": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xf719,
    categories: [ 2 ],
    tags: [ 380, 419, 918, 266, 88, 388, 3327, 960, 1738, 274, 5648, 246, 9561, 1375, 1489, 778, 10647, 779, 421, 780, 12211, 27, 1783, 1496, 288, 371, 2966, 944, 36, 12212, 2007, 2571, 12213, 986 ],
  ),
  "kayaking": SymbolsMetadata(
    popularity: 703,
    codepoint: 0xe50c,
    categories: [ 15 ],
    tags: [ 989, 2464, 8149, 8456, 2521, 12214, 584, 12215, 12216, 3337, 2925, 6190, 483, 12217, 12218, 4615, 2533, 3727, 12219, 12220, 488, 489, 12221, 3347, 4620, 1603, 2476, 607, 5780, 3595, 750, 4206, 441, 2023, 1504, 2024, 2801, 12222, 1862, 1902 ],
  ),
  "kebab_dining": SymbolsMetadata(
    popularity: 391,
    codepoint: 0xe842,
    categories: [ 5 ],
    tags: [ 12223, 12224, 12225, 12226, 953, 12227, 6169, 3799, 4275, 3800, 1829, 5153, 12228, 12229, 3803, 3804, 12230, 1860, 4280, 3807, 12231, 12232, 12233, 3809, 12234, 944, 3493, 4206, 12235, 12236, 1592 ],
  ),
  "keep": SymbolsMetadata(
    popularity: 562,
    codepoint: 0xe6aa,
    categories: [ 6 ],
    tags: [ 1058, 1670, 8485, 1001, 12237, 1002, 6280, 8776, 1491, 21, 1532, 1493, 12238, 12239, 12240, 12241, 12242, 3295, 1495, 1363, 3012, 12243, 9687, 1030, 1664, 3493, 12244, 9688, 1645, 8708, 9689 ],
  ),
  "keep_off": SymbolsMetadata(
    popularity: 165,
    codepoint: 0xe6f9,
    categories: [ 6 ],
    tags: [ 895, 3436, 4563, 897, 3303, 3304, 1077, 767, 6426, 3615, 898, 10671, 899, 8485, 7067, 12245, 12246, 907, 909, 1493, 4448, 3012, 9687, 3068, 1030, 911, 12247, 1664, 914, 9688, 1645, 8708, 9689, 915, 2499, 12248, 5717, 12249, 12250, 12251, 12252 ],
  ),
  "keep_public": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xf56f,
    categories: [ 6 ],
    tags: [ 755, 468, 4942, 355, 479, 11742, 483, 8485, 1001, 1002, 21, 1144, 223, 4479, 2653, 488, 489, 1493, 3295, 1495, 1409, 490, 2071, 2504, 3012, 9687, 1030, 1664, 1665, 3058, 607, 9688, 1645, 8708, 5717, 9052, 501, 5023, 8214 ],
  ),
  "kettle": SymbolsMetadata(
    popularity: 311,
    codepoint: 0xe2b9,
    categories: [ 8 ],
    tags: [ 1888, 4381, 7147, 12253, 3790, 6620, 6607, 1269, 3795, 4386, 4388, 4078, 12254, 3489, 999, 12255, 6611, 4006, 1435, 4392, 12256, 3802, 4396, 2097, 1004, 5639, 6628, 9579, 12257, 12258, 6617, 12259, 12260, 6368, 2801 ],
  ),
  "key": SymbolsMetadata(
    popularity: 11952,
    codepoint: 0xe73c,
    categories: [ 2 ],
    tags: [ 755, 468, 1768, 2950, 3242, 10, 12261, 2604, 6526, 1597, 1078, 135, 968, 2674, 852, 2653, 5715, 1514, 329, 1516, 1517, 490, 1519, 912, 602, 8411, 1011, 65, 2913, 5717, 501 ],
  ),
  "key_off": SymbolsMetadata(
    popularity: 952,
    codepoint: 0xeb84,
    categories: [ 2 ],
    tags: [ 755, 892, 1768, 1769, 1074, 894, 895, 383, 896, 1076, 2969, 1077, 767, 12262, 2604, 898, 1597, 899, 1078, 900, 968, 12263, 12264, 1602, 2674, 5714, 852, 2678, 907, 908, 909, 5715, 912, 171, 1011, 2913, 913, 914, 2126, 5717 ],
  ),
  "key_vertical": SymbolsMetadata(
    popularity: 53,
    codepoint: 0xf51a,
    categories: [ 2 ],
    tags: [ 755, 468, 1768, 2731, 383, 12265, 3244, 2604, 6526, 1597, 1078, 968, 12266, 2674, 852, 5715, 1514, 329, 1516, 1517, 490, 912, 602, 8411, 1011, 65, 2913, 12267, 441, 5717, 501, 12268 ],
  ),
  "key_visualizer": SymbolsMetadata(
    popularity: 474,
    codepoint: 0xf199,
    categories: [ 13 ],
    tags: [ 2513, 5, 2170, 365, 802, 268, 269, 785, 6676, 1735, 2515, 10, 12, 246, 12269, 3078, 135, 3945, 4294, 12270, 968, 12271, 366, 1755, 936, 2753, 4458, 656, 940, 98, 3635, 329, 2258, 1353, 2948, 1603, 1376, 65, 2997, 944, 945, 317, 1355, 2519, 12272 ],
  ),
  "keyboard": SymbolsMetadata(
    popularity: 3286,
    codepoint: 0xe312,
    categories: [ 11 ],
    tags: [ 733, 954, 443, 694, 7020, 445, 1347, 696, 1598, 246, 965, 966, 969, 970, 12273, 19, 485, 1456, 8339, 75, 77, 65, 982, 12274, 32, 38, 12106, 40, 3735, 2185, 1536 ],
  ),
  "keyboard_alt": SymbolsMetadata(
    popularity: 847,
    codepoint: 0xf028,
    categories: [ 11 ],
    tags: [ 2587, 12275, 694, 7020, 445, 696, 12276, 1598, 246, 965, 16, 966, 10956, 7022, 969, 12277, 970, 12273, 19, 1456, 75, 77, 32, 35, 38, 12106, 3734, 40, 3735, 1536 ],
  ),
  "keyboard_arrow_down": SymbolsMetadata(
    popularity: 9409,
    codepoint: 0xe313,
    categories: [ 11 ],
    tags: [ 380, 419, 2871, 2862, 2896, 954, 388, 12, 2651, 2924, 2941, 787, 12278, 959, 188, 966, 969, 12279, 92, 788, 789, 779, 780, 2653, 2948, 2899, 288, 106, 314, 2949 ],
  ),
  "keyboard_arrow_left": SymbolsMetadata(
    popularity: 2121,
    codepoint: 0xe314,
    categories: [ 11 ],
    tags: [ 378, 380, 419, 2489, 2901, 2871, 2862, 1062, 388, 2977, 5499, 2873, 188, 969, 12280, 12281, 1375, 2875, 12282, 12283, 779, 421, 1783, 2876, 2877, 2495, 2881, 2886, 396, 402, 2499 ],
    rtlAutoMirrored: true,
  ),
  "keyboard_arrow_right": SymbolsMetadata(
    popularity: 3370,
    codepoint: 0xe315,
    categories: [ 11 ],
    tags: [ 775, 2963, 380, 2960, 419, 2871, 2862, 12284, 776, 132, 388, 12285, 787, 777, 339, 969, 12280, 12286, 12287, 789, 2235, 779, 421, 780, 2653, 781, 1396, 782, 12288, 12289, 12290 ],
    rtlAutoMirrored: true,
  ),
  "keyboard_arrow_up": SymbolsMetadata(
    popularity: 3363,
    codepoint: 0xe316,
    categories: [ 11 ],
    tags: [ 2963, 380, 2052, 419, 2466, 2489, 2871, 2862, 2950, 2896, 388, 787, 6663, 339, 1207, 12280, 12291, 7648, 92, 2928, 2958, 421, 2876, 2495, 2475, 2915, 441, 1124, 1701, 1676, 1677, 2916 ],
  ),
  "keyboard_backspace": SymbolsMetadata(
    popularity: 4354,
    codepoint: 0xe317,
    categories: [ 11 ],
    tags: [ 380, 2489, 2869, 2901, 3731, 3035, 2871, 897, 388, 2977, 696, 3438, 2873, 966, 969, 1375, 2875, 12292, 421, 1783, 2876, 2877, 911, 2495, 2881, 3734, 2499 ],
    rtlAutoMirrored: true,
  ),
  "keyboard_capslock": SymbolsMetadata(
    popularity: 358,
    codepoint: 0xe318,
    categories: [ 11 ],
    tags: [ 951, 12293, 4, 380, 2052, 12294, 12295, 12296, 2871, 8, 896, 696, 2299, 14, 966, 969, 4704, 1602, 907, 909, 3036, 38, 314, 40, 3735, 2498, 1676, 1677, 2789, 1536, 704 ],
  ),
  "keyboard_capslock_badge": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf7de,
    categories: [ 4 ],
    tags: [ 10068, 1242, 380, 419, 6, 12294, 12297, 12298, 12295, 12296, 2871, 8, 693, 3418, 696, 2299, 14, 1372, 2175, 963, 188, 966, 969, 1602, 12176, 909, 3036, 32, 553, 7476, 3734, 314, 40, 3735, 1676, 1677, 2789, 704 ],
  ),
  "keyboard_command_key": SymbolsMetadata(
    popularity: 1288,
    codepoint: 0xeae7,
    categories: [ 2 ],
    tags: [ 3325, 12299, 2964, 298, 12300, 954, 12301, 269, 12302, 16, 966, 12303, 969, 12304, 12305, 12306, 390, 9916, 1687, 12307, 12308, 1192, 12309, 982, 32, 35 ],
  ),
  "keyboard_control_key": SymbolsMetadata(
    popularity: 1007,
    codepoint: 0xeae6,
    categories: [ 2 ],
    tags: [ 2052, 2466, 2870, 2871, 2862, 2896, 954, 12310, 1781, 388, 787, 6665, 777, 2957, 1207, 966, 969, 2958, 421, 780, 2876, 2915, 982, 1124, 2949, 1677, 12311, 2916 ],
  ),
  "keyboard_double_arrow_down": SymbolsMetadata(
    popularity: 3979,
    codepoint: 0xead0,
    categories: [ 2 ],
    tags: [ 380, 2650, 419, 2188, 2944, 12312, 776, 2937, 388, 3108, 2450, 3593, 2651, 2840, 787, 777, 966, 969, 12313, 12286, 2898, 2557, 421, 780, 12314, 781, 2948, 2900, 3103, 38, 2455, 40 ],
  ),
  "keyboard_double_arrow_left": SymbolsMetadata(
    popularity: 4044,
    codepoint: 0xeac3,
    categories: [ 2 ],
    tags: [ 380, 419, 2489, 84, 2871, 12315, 269, 1781, 388, 3108, 2450, 3593, 12316, 12317, 9565, 966, 12318, 969, 1375, 2875, 2974, 2557, 421, 2876, 2877, 2878, 2886, 2979, 9567, 108, 3734, 12319, 3735 ],
    rtlAutoMirrored: true,
  ),
  "keyboard_double_arrow_right": SymbolsMetadata(
    popularity: 6438,
    codepoint: 0xeac9,
    categories: [ 2 ],
    tags: [ 775, 380, 12320, 419, 2862, 776, 269, 388, 3108, 2450, 3593, 8453, 777, 966, 969, 12304, 2557, 779, 421, 780, 781, 1027, 1028, 1396, 782, 12321, 982, 2966, 231, 3734, 2455, 3735 ],
    rtlAutoMirrored: true,
  ),
  "keyboard_double_arrow_up": SymbolsMetadata(
    popularity: 2662,
    codepoint: 0xeacf,
    categories: [ 2 ],
    tags: [ 380, 2052, 419, 2466, 84, 2871, 1781, 388, 3108, 2450, 12322, 2884, 8453, 1207, 966, 969, 2958, 2557, 421, 12323, 2876, 2899, 2915, 2966, 108, 3734, 1124, 2455, 40, 3735, 1676, 12324, 2917 ],
  ),
  "keyboard_external_input": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf7dd,
    categories: [ 4 ],
    tags: [ 2587, 12325, 380, 12326, 694, 921, 12327, 445, 1672, 12328, 8249, 12276, 965, 1542, 966, 10956, 969, 12313, 12304, 970, 19, 935, 1456, 1719, 3000, 12329, 8339, 75, 1396, 2343, 12330, 65, 38, 12106, 3734, 40, 3735, 12331 ],
  ),
  "keyboard_full": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf7dc,
    categories: [ 4 ],
    tags: [ 298, 443, 693, 694, 445, 696, 2299, 12332, 12333, 1673, 966, 10956, 7022, 969, 12334, 12335, 12273, 306, 485, 1770, 3421, 75, 77, 32, 35, 38, 12106, 3734, 40, 3735, 1536, 704 ],
  ),
  "keyboard_hide": SymbolsMetadata(
    popularity: 388,
    codepoint: 0xe31a,
    categories: [ 11 ],
    tags: [ 380, 12336, 2896, 694, 6660, 445, 11534, 12337, 2651, 12338, 965, 900, 12339, 966, 12340, 969, 12280, 12341, 12342, 12343, 970, 2928, 12344, 12345, 2842, 2992, 38, 12106, 3734, 40, 3735, 12346 ],
  ),
  "keyboard_keys": SymbolsMetadata(
    popularity: 28,
    codepoint: 0xf67b,
    categories: [ 4 ],
    tags: [ 755, 733, 954, 694, 7020, 1685, 445, 696, 2299, 246, 965, 966, 12340, 969, 12347, 12304, 970, 12273, 4052, 19, 1456, 75, 1603, 982, 12274, 32, 35, 38, 3734, 40, 3735, 1536, 704 ],
  ),
  "keyboard_lock": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf492,
    categories: [ 11 ],
    tags: [ 755, 1074, 694, 3244, 445, 12348, 12349, 965, 966, 12350, 969, 12351, 12352, 12353, 12354, 12355, 970, 12356, 19, 2674, 12357, 5714, 12358, 1456, 5715, 1516, 1517, 1519, 1520, 912, 171, 1772, 602, 1773, 12359, 1011, 38, 40, 12360, 5717 ],
  ),
  "keyboard_lock_off": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf491,
    categories: [ 11 ],
    tags: [ 755, 12361, 694, 12362, 445, 12348, 767, 12349, 898, 965, 966, 12363, 12364, 969, 12351, 12352, 12365, 12366, 12367, 12368, 12355, 12369, 970, 19, 2674, 5714, 12370, 12371, 907, 1456, 909, 5715, 1516, 1517, 1520, 912, 6532, 602, 1773, 1011, 914, 38, 40, 3735, 5717, 12372 ],
  ),
  "keyboard_off": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf67a,
    categories: [ 4 ],
    tags: [ 733, 1074, 895, 694, 445, 3304, 12348, 767, 898, 246, 965, 901, 966, 12364, 12340, 12373, 969, 12353, 12374, 12367, 970, 12375, 12376, 19, 1164, 12370, 907, 1456, 909, 75, 1170, 914, 32, 38, 12377, 12378, 40, 12379, 12380 ],
  ),
  "keyboard_onscreen": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf7db,
    categories: [ 4 ],
    tags: [ 472, 12381, 473, 12382, 694, 445, 12383, 696, 2299, 965, 966, 7022, 969, 12334, 970, 12273, 19, 485, 6052, 12344, 1456, 12345, 75, 77, 12384, 38, 12106, 3734, 40, 3735, 12346, 1536, 704 ],
  ),
  "keyboard_option_key": SymbolsMetadata(
    popularity: 511,
    codepoint: 0xeae8,
    categories: [ 2 ],
    tags: [ 12299, 1499, 12385, 2964, 8, 954, 12301, 269, 1062, 963, 966, 968, 969, 12304, 1687, 788, 12386, 12308, 1192, 281, 12387, 1193, 65, 982, 3263, 35, 38, 1214, 40 ],
  ),
  "keyboard_previous_language": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf7da,
    categories: [ 4 ],
    tags: [ 380, 2489, 1731, 694, 385, 445, 965, 10587, 966, 12340, 8966, 969, 12334, 970, 10588, 5651, 12388, 19, 8968, 8969, 1456, 329, 2876, 12389, 2492, 424, 3749, 2496, 396, 65, 313, 38, 8052, 40, 3735, 2499 ],
  ),
  "keyboard_return": SymbolsMetadata(
    popularity: 2036,
    codepoint: 0xe31b,
    categories: [ 11 ],
    tags: [ 1627, 12390, 5171, 380, 2489, 12391, 1633, 1636, 776, 1062, 388, 1639, 2189, 2909, 1640, 966, 969, 3759, 1375, 2875, 1602, 421, 1643, 2876, 781, 1410, 2495, 2881, 2343, 1412, 2499 ],
    rtlAutoMirrored: true,
  ),
  "keyboard_tab": SymbolsMetadata(
    popularity: 746,
    codepoint: 0xe31c,
    categories: [ 11 ],
    tags: [ 755, 733, 380, 12392, 269, 1738, 1598, 777, 10492, 966, 969, 12304, 12393, 1375, 1602, 421, 780, 12394, 12395, 1396, 782, 982, 2966, 1070, 12396, 3628, 3733, 3734 ],
    rtlAutoMirrored: true,
  ),
  "keyboard_tab_rtl": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xec73,
    categories: [ 11 ],
    tags: [ 380, 2868, 2489, 3731, 2870, 1731, 269, 1781, 1597, 1598, 1205, 966, 969, 1375, 2875, 1602, 421, 780, 2876, 2881, 12397, 1396, 10538, 6131, 3036, 313, 1070, 38, 2499, 1215 ],
    rtlAutoMirrored: true,
  ),
  "kid_star": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xf526,
    categories: [ 3 ],
    tags: [ 3, 3574, 6, 3575, 1670, 862, 12398, 865, 3578, 4738, 9583, 12399, 4799, 4800, 1659, 3019, 1251, 870, 12400, 1641, 1361, 3582, 286, 102, 3584, 1664, 4271, 311, 3264 ],
  ),
  "king_bed": SymbolsMetadata(
    popularity: 1273,
    codepoint: 0xea45,
    categories: [ 8 ],
    tags: [ 2599, 2600, 1909, 4211, 4213, 1914, 3108, 4214, 1964, 4216, 999, 4217, 2607, 1435, 2796, 4218, 12401, 12402, 2610, 4219, 2611, 4220, 4222, 4223, 4224, 1959, 1924, 1925, 1960, 1929, 1948, 1504 ],
  ),
  "kitchen": SymbolsMetadata(
    popularity: 1554,
    codepoint: 0xeb47,
    categories: [ 8 ],
    tags: [ 1888, 714, 4274, 4386, 12403, 8443, 1829, 12404, 721, 12405, 11081, 999, 1435, 1436, 724, 16, 3802, 12406, 7792, 1361, 2613, 9755, 75, 12407, 12408, 105, 32, 674, 35, 12409, 1381 ],
  ),
  "kitesurfing": SymbolsMetadata(
    popularity: 424,
    codepoint: 0xe50d,
    categories: [ 15 ],
    tags: [ 989, 8149, 8456, 3923, 6182, 584, 3337, 2925, 12410, 12411, 6190, 483, 9530, 12412, 12413, 12414, 12415, 12416, 3344, 2533, 488, 489, 3347, 2476, 6201, 607, 5780, 3595, 750, 12417, 12418, 1504, 2024, 2801, 12419, 12222, 1862, 1902, 1863 ],
  ),
  "lab_panel": SymbolsMetadata(
    popularity: 34,
    codepoint: 0xe103,
    categories: [ 3 ],
    tags: [ 2513, 2412, 4347, 802, 268, 269, 12420, 2515, 10, 2523, 4348, 595, 1753, 4474, 12421, 12422, 1757, 1760, 327, 1770, 4321, 75, 4359, 2851, 3331, 6680, 12423, 2424, 3761, 65, 551, 3160, 315 ],
  ),
  "lab_profile": SymbolsMetadata(
    popularity: 120,
    codepoint: 0xe104,
    categories: [ 12 ],
    tags: [ 2513, 10, 132, 4453, 1528, 1347, 6874, 1530, 7028, 1656, 1657, 595, 1753, 135, 4474, 12424, 12425, 12426, 12427, 12422, 1757, 1758, 1533, 1534, 1535, 1762, 12428, 490, 121, 1353, 7503, 4359, 2851, 2424, 6403, 3160, 441 ],
  ),
  "lab_research": SymbolsMetadata(
    popularity: 72,
    codepoint: 0xf80b,
    categories: [ 3 ],
    tags: [ 2513, 9267, 12429, 2412, 12430, 4347, 4291, 4292, 4348, 958, 12431, 960, 4294, 4350, 4474, 12432, 4352, 976, 12433, 4359, 2424, 12434, 4361, 980, 3160, 12435, 12436, 986 ],
  ),
  "label": SymbolsMetadata(
    popularity: 4389,
    codepoint: 0xe892,
    categories: [ 6 ],
    tags: [ 380, 6, 1670, 298, 5917, 269, 388, 3327, 3578, 4720, 1598, 777, 16, 2810, 10492, 188, 966, 18, 2159, 2340, 21, 421, 780, 98, 1361, 4270, 1396, 1664, 311, 7494, 2728, 2824, 35, 2384, 2757 ],
    rtlAutoMirrored: true,
  ),
  "label_important": SymbolsMetadata(
    popularity: 1773,
    codepoint: 0xe937,
    categories: [ 6 ],
    tags: [ 775, 469, 380, 3073, 6, 1670, 2862, 776, 388, 3258, 3578, 4720, 777, 3019, 1251, 10492, 188, 18, 2159, 2340, 21, 421, 780, 486, 1361, 4758, 781, 28, 4270, 1030, 1396, 782, 1664, 2728, 2824, 2384, 12437 ],
    rtlAutoMirrored: true,
  ),
  "label_off": SymbolsMetadata(
    popularity: 427,
    codepoint: 0xe9b6,
    categories: [ 6 ],
    tags: [ 895, 897, 1077, 12438, 12439, 767, 898, 3578, 1078, 900, 12440, 12441, 10492, 18, 12442, 2159, 2340, 21, 12443, 12444, 12445, 12446, 12447, 907, 909, 4270, 911, 1664, 914, 2728, 2824, 12448, 12449, 2384, 12450, 12451, 12452, 12453, 12437 ],
  ),
  "labs": SymbolsMetadata(
    popularity: 244,
    codepoint: 0xe105,
    categories: [ 3 ],
    tags: [ 2513, 9267, 2412, 6557, 4347, 1269, 4292, 4348, 2790, 595, 1753, 6632, 4474, 4352, 12422, 2798, 634, 1757, 1760, 4359, 12454, 6680, 12423, 2424, 9281, 3160, 12435, 5192, 8162, 12436 ],
  ),
  "lan": SymbolsMetadata(
    popularity: 2947,
    codepoint: 0xeb2f,
    categories: [ 7 ],
    tags: [ 920, 6991, 694, 11741, 921, 211, 10, 924, 5272, 926, 3501, 932, 3236, 5073, 215, 5092, 12455, 223, 939, 940, 5085, 3761, 2631, 1665, 3058, 945, 313, 11871, 948 ],
  ),
  "landscape": SymbolsMetadata(
    popularity: 2396,
    codepoint: 0xe3f7,
    categories: [ 1 ],
    tags: [ 3325, 2464, 2465, 11593, 2468, 1890, 2469, 1659, 3724, 8911, 16, 53, 1543, 1001, 1002, 1544, 12456, 1545, 1859, 421, 1860, 2474, 12457, 59, 61, 119, 1546, 105, 12458, 35, 2477, 1504, 1701, 317, 12459 ],
  ),
  "landscape_2": SymbolsMetadata(
    popularity: 41,
    codepoint: 0xf4c4,
    categories: [ 1 ],
    tags: [ 406, 2464, 1538, 379, 11332, 1890, 958, 1541, 2469, 8911, 12460, 53, 1543, 12461, 1544, 1545, 1859, 12462, 3727, 392, 61, 119, 12463, 1546, 12464, 5026, 3686, 6395, 6396, 2477, 2478, 1504, 317, 404, 12459, 405 ],
  ),
  "landscape_2_edit": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf310,
    categories: [ 1 ],
    tags: [ 406, 1128, 1726, 379, 11332, 1731, 693, 1201, 2332, 299, 302, 696, 2299, 1371, 1890, 2469, 8911, 3145, 966, 1543, 1602, 1740, 1544, 1545, 1859, 763, 1860, 1586, 2693, 2694, 3422, 1546, 311, 3686, 2477, 2478, 12465, 404, 405, 1536, 704 ],
  ),
  "landscape_2_off": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf4c3,
    categories: [ 1 ],
    tags: [ 406, 379, 11332, 12466, 12467, 12468, 895, 4563, 2969, 1077, 767, 12, 12469, 12470, 898, 899, 53, 1543, 4300, 4301, 219, 1544, 1545, 1859, 4303, 907, 908, 909, 3147, 12471, 12472, 226, 119, 396, 12473, 12474, 7844, 12475, 12476, 914, 3686, 447, 1214, 317, 8211, 12477, 404, 405 ],
  ),
  "landslide": SymbolsMetadata(
    popularity: 527,
    codepoint: 0xebd7,
    categories: [ 3 ],
    tags: [ 469, 12478, 12479, 7270, 3176, 12480, 4668, 12481, 12482, 9497, 12483, 12484, 8676, 12485, 4647, 8910, 12486, 12487, 1544, 12488, 7484, 7485, 7486, 12489, 12490, 8008, 4650, 2477, 12491, 12492, 1261, 731 ],
  ),
  "language": SymbolsMetadata(
    popularity: 30405,
    codepoint: 0xe894,
    categories: [ 6 ],
    tags: [ 443, 4292, 8673, 958, 10917, 2469, 5070, 5071, 4984, 7414, 8966, 215, 5651, 8968, 1001, 1002, 421, 2503, 819, 5652, 7110, 8052, 1504, 1691, 1053, 4761, 5655 ],
  ),
  "language_chinese_array": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf766,
    categories: [ 12 ],
    tags: [ 4, 3638, 7453, 7454, 12493, 8, 7458, 7459, 443, 8962, 10882, 14, 10917, 1372, 930, 7414, 5651, 12494, 4695, 4704, 12495, 92, 8968, 12496, 2557, 2506, 492, 4689, 496, 38, 7110, 8052, 12497, 1536, 704 ],
  ),
  "language_chinese_cangjie": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf765,
    categories: [ 12 ],
    tags: [ 686, 4, 7453, 7454, 12498, 12499, 8, 7459, 12500, 8962, 10882, 10917, 1372, 8996, 10587, 966, 8966, 10588, 5651, 12494, 8968, 3379, 35, 38, 7110, 8052, 12497, 3735, 1536, 704 ],
  ),
  "language_chinese_dayi": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf764,
    categories: [ 12 ],
    tags: [ 685, 733, 4, 7650, 4950, 8, 7459, 1202, 12501, 8962, 1216, 787, 14, 8963, 1372, 1204, 1207, 5651, 12494, 3634, 4704, 8968, 7716, 656, 202, 329, 2281, 65, 673, 38, 7110, 8052, 12497, 702, 704, 986 ],
  ),
  "language_chinese_pinyin": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf763,
    categories: [ 12 ],
    tags: [ 685, 4, 7453, 8, 7458, 7459, 443, 8962, 4702, 10882, 3153, 14, 1372, 8996, 966, 5651, 12494, 4695, 4704, 12495, 8968, 12496, 12502, 12503, 492, 4689, 35, 496, 38, 8052, 12497, 40, 1536, 704 ],
  ),
  "language_chinese_quick": SymbolsMetadata(
    popularity: 14,
    codepoint: 0xf762,
    categories: [ 12 ],
    tags: [ 4, 7453, 7454, 12493, 8, 7458, 7459, 443, 8962, 12504, 1022, 8963, 1372, 10587, 8966, 10588, 5651, 12388, 10576, 12505, 12494, 4704, 8968, 12496, 1027, 231, 35, 38, 7110, 8052, 12497, 704 ],
  ),
  "language_chinese_wubi": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf761,
    categories: [ 12 ],
    tags: [ 7453, 8, 7458, 7459, 443, 8962, 12506, 12507, 8963, 1372, 8996, 10587, 12508, 966, 12340, 8966, 969, 10588, 5651, 12494, 8968, 8969, 12503, 3379, 35, 38, 8052, 12497, 3735, 704, 12509 ],
  ),
  "language_french": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf760,
    categories: [ 12 ],
    tags: [ 4, 443, 476, 12510, 8962, 4702, 9173, 12511, 1372, 12512, 7410, 12513, 5070, 7414, 8966, 5651, 12514, 12515, 12516, 12517, 10576, 12505, 12494, 12518, 8968, 493, 38, 12519, 7110, 8052, 12497, 704 ],
  ),
  "language_gb_english": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf75f,
    categories: [ 12 ],
    tags: [ 186, 690, 10907, 10908, 4752, 8962, 7427, 1372, 12520, 5070, 12521, 7431, 2780, 7414, 5651, 12494, 19, 12518, 8968, 1001, 1008, 190, 2786, 38, 7110, 8052, 12497, 2788, 7437, 7438, 704 ],
  ),
  "language_international": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf75e,
    categories: [ 12 ],
    tags: [ 186, 733, 687, 443, 4752, 8962, 8963, 1372, 5070, 5071, 10587, 7414, 12522, 10588, 5651, 12523, 10576, 12505, 12494, 19, 8968, 8969, 12524, 329, 1008, 65, 38, 7110, 8052, 12497, 4761, 12525, 704 ],
  ),
  "language_japanese_kana": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf513,
    categories: [ 12 ],
    tags: [ 4, 7454, 8, 443, 8962, 12526, 10882, 14, 1372, 12527, 10587, 8966, 3958, 3959, 12528, 12529, 12530, 10588, 5651, 12494, 4704, 12495, 8968, 12531, 3379, 38, 8052, 12497, 702, 704 ],
  ),
  "language_korean_latin": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xf75d,
    categories: [ 12 ],
    tags: [ 4, 7453, 8, 443, 8962, 10882, 1372, 5070, 12532, 7414, 12533, 12534, 5651, 12523, 12388, 10576, 12494, 10919, 4704, 12495, 8968, 8969, 12535, 38, 7110, 8052, 12497, 704, 12536, 12537, 12538, 12539, 12540 ],
  ),
  "language_pinyin": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf75c,
    categories: [ 12 ],
    tags: [ 7453, 12493, 692, 7458, 7459, 443, 8962, 4702, 3153, 1372, 8996, 12541, 966, 5651, 12494, 3375, 12495, 8968, 12496, 12502, 12503, 12542, 12535, 3379, 493, 35, 38, 12543, 8052, 12497, 40, 704 ],
  ),
  "language_spanish": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf5e9,
    categories: [ 12 ],
    tags: [ 186, 4, 12544, 443, 8962, 12545, 1372, 5070, 10587, 698, 8966, 10588, 5651, 12388, 10576, 12505, 12494, 12546, 19, 12518, 8968, 8969, 12547, 12548, 12549, 38, 7110, 8052, 12497, 2788, 702, 704 ],
  ),
  "language_us": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf759,
    categories: [ 12 ],
    tags: [ 186, 687, 12550, 12551, 4752, 12510, 8962, 12552, 12553, 4720, 1372, 10587, 2780, 8966, 10588, 5651, 12494, 19, 12518, 8968, 1001, 285, 1008, 65, 38, 8052, 12497, 702, 12554, 12555, 12556, 704 ],
  ),
  "language_us_colemak": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf75b,
    categories: [ 12 ],
    tags: [ 733, 4, 2442, 12550, 2501, 1400, 8, 12557, 443, 268, 7019, 8962, 12553, 12558, 1372, 966, 969, 5651, 12494, 306, 4704, 8968, 2180, 1409, 10512, 65, 38, 8052, 12497, 40, 3735, 12554, 12555, 8054, 1536, 704 ],
  ),
  "language_us_dvorak": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf75a,
    categories: [ 12 ],
    tags: [ 733, 4, 12275, 692, 8962, 12559, 12560, 12561, 12553, 1372, 966, 12340, 969, 12334, 12562, 12273, 5651, 10576, 12563, 12564, 12494, 306, 19, 8968, 329, 65, 982, 38, 3734, 8052, 12497, 3735, 12554, 12555, 12565, 704 ],
  ),
  "laps": SymbolsMetadata(
    popularity: 115,
    codepoint: 0xf6b9,
    categories: [ 15 ],
    tags: [ 380, 2891, 383, 7892, 2490, 2348, 86, 4684, 385, 2925, 2927, 7477, 12566, 12567, 390, 5185, 8154, 9216, 2492, 424, 425, 2367, 3515, 426, 3516, 394, 396, 889, 8156, 2932, 5780, 3549, 1033, 2165, 2499, 3596 ],
  ),
  "laptop_car": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf3cd,
    categories: [ 11 ],
    tags: [ 1109, 1110, 755, 1814, 3467, 1815, 12568, 1816, 1684, 694, 4514, 211, 269, 1685, 445, 4453, 1654, 3484, 3471, 965, 1114, 4515, 1896, 1897, 4052, 1687, 2770, 327, 223, 5716, 3474, 2631, 4517, 551, 9178, 1844, 1691, 1084, 234 ],
  ),
  "laptop_chromebook": SymbolsMetadata(
    popularity: 2270,
    codepoint: 0xe31f,
    categories: [ 11 ],
    tags: [ 1109, 1110, 5125, 1684, 12569, 12570, 694, 445, 88, 12, 1711, 1189, 965, 1114, 215, 969, 4052, 12571, 12572, 327, 12573, 4708, 2653, 6839, 6840, 2585, 12574, 330, 4689, 551, 12575, 12576, 1691, 1054, 1459 ],
  ),
  "laptop_mac": SymbolsMetadata(
    popularity: 3070,
    codepoint: 0xe320,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2964, 5125, 1284, 1684, 12577, 443, 694, 445, 88, 12, 1711, 965, 1114, 215, 969, 4052, 1687, 12578, 327, 4708, 1456, 819, 790, 2585, 75, 190, 330, 551, 12575, 1691, 1054, 1459 ],
  ),
  "laptop_windows": SymbolsMetadata(
    popularity: 1732,
    codepoint: 0xe321,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1230, 5123, 1284, 1684, 694, 6838, 445, 88, 12, 1711, 965, 999, 1114, 215, 4052, 1687, 12579, 327, 4708, 1456, 1192, 1193, 6839, 790, 2585, 2648, 75, 330, 1196, 32, 551, 1691, 1054, 1084, 1459 ],
  ),
  "lasso_select": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xeb03,
    categories: [ 12 ],
    tags: [ 12580, 380, 266, 383, 1776, 4848, 1781, 2448, 2449, 9154, 1528, 12581, 1579, 3007, 696, 2299, 1371, 2279, 12582, 12583, 6684, 3019, 3145, 2725, 12584, 390, 12585, 5166, 2693, 2694, 3422, 3021, 1783, 12586, 288, 12587, 371, 4786, 1379, 2182, 38, 2537, 40, 704 ],
  ),
  "last_page": SymbolsMetadata(
    popularity: 2315,
    codepoint: 0xe5dd,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 1343, 2862, 2750, 2189, 12588, 12589, 12590, 12591, 777, 12592, 339, 12593, 2751, 12594, 2874, 2885, 12595, 1602, 421, 780, 1534, 12596, 1396, 782, 12597, 330, 2899, 12598, 2882, 2966, 1214, 12599, 2757, 2759, 12600, 1215, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "laundry": SymbolsMetadata(
    popularity: 902,
    codepoint: 0xe2a8,
    categories: [ 10 ],
    tags: [ 2697, 6342, 4005, 12601, 2701, 2702, 12602, 1433, 8575, 12603, 2706, 999, 6348, 3972, 12604, 8579, 12605, 12606, 12607, 8580, 424, 2708, 2713, 12608, 12609, 4001, 8240, 8242, 6356, 8243 ],
  ),
  "layers": SymbolsMetadata(
    popularity: 3358,
    codepoint: 0xe53b,
    categories: [ 5 ],
    tags: [ 1367, 2170, 5793, 3095, 1042, 409, 3706, 767, 3108, 898, 1659, 932, 4895, 1065, 1066, 306, 2472, 934, 92, 1490, 907, 909, 96, 940, 98, 4915, 1081, 3464, 3421, 1421, 104, 4916, 914, 944, 107, 9793, 945, 3426, 315 ],
  ),
  "layers_clear": SymbolsMetadata(
    popularity: 602,
    codepoint: 0xe53c,
    categories: [ 5 ],
    tags: [ 3325, 1367, 895, 3436, 6377, 12610, 1202, 897, 12611, 2969, 767, 898, 12612, 304, 900, 12613, 4895, 12614, 12615, 1066, 12616, 366, 1490, 12617, 12618, 907, 909, 1081, 3464, 2258, 911, 12619, 12620, 914, 944, 107, 12621, 3736 ],
  ),
  "lda": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xe106,
    categories: [ 11 ],
    tags: [ 1128, 3211, 2430, 3498, 2513, 5, 2520, 1731, 268, 269, 1735, 1751, 1347, 5243, 12622, 595, 12623, 1602, 3503, 1755, 1757, 411, 12624, 1740, 1761, 656, 12625, 9791, 329, 65, 2649, 2537, 5933, 12626, 7025, 12627 ],
  ),
  "leaderboard": SymbolsMetadata(
    popularity: 3900,
    codepoint: 0xf20c,
    categories: [ 9 ],
    tags: [ 3, 5, 1343, 365, 918, 920, 802, 6187, 12628, 10, 924, 12629, 697, 929, 932, 12630, 933, 12631, 934, 597, 937, 12632, 28, 3582, 2851, 3584, 7196, 12633, 12634, 33, 109, 12635, 374, 1124, 947, 6196, 12636 ],
  ),
  "leak_add": SymbolsMetadata(
    popularity: 483,
    codepoint: 0xe3f8,
    categories: [ 1 ],
    tags: [ 526, 12203, 355, 953, 2566, 921, 211, 1062, 10, 12637, 4581, 2173, 12638, 787, 1207, 2797, 12639, 935, 223, 763, 202, 1785, 12640, 9316, 2631, 1665, 227, 2084, 2438, 12641, 5086, 1902, 233, 234 ],
  ),
  "leak_remove": SymbolsMetadata(
    popularity: 174,
    codepoint: 0xe3f9,
    categories: [ 1 ],
    tags: [ 5098, 895, 211, 11448, 1202, 4664, 10, 2969, 767, 898, 1737, 12642, 2797, 12643, 12644, 366, 935, 2770, 223, 12645, 12646, 907, 908, 909, 9577, 3505, 2800, 12647, 2772, 911, 3474, 3585, 2631, 2084, 914, 8986, 12648, 12641, 441, 12649, 12650, 234 ],
  ),
  "left_click": SymbolsMetadata(
    popularity: 166,
    codepoint: 0xf718,
    categories: [ 2 ],
    tags: [ 951, 2827, 380, 266, 383, 1776, 12651, 1777, 694, 12652, 12653, 269, 4246, 1781, 12654, 3019, 966, 6036, 1375, 2875, 12655, 3020, 12656, 12657, 4910, 778, 421, 2653, 3021, 1363, 1783, 288, 371, 8502 ],
  ),
  "left_panel_close": SymbolsMetadata(
    popularity: 60,
    codepoint: 0xf717,
    categories: [ 2 ],
    tags: [ 380, 2489, 2862, 2950, 2981, 2896, 2919, 388, 2983, 2985, 787, 900, 12658, 2751, 306, 1375, 2875, 788, 2928, 421, 1770, 3421, 75, 2930, 2992, 2993, 4787, 4899, 32, 441, 314, 1215, 1054, 2746 ],
  ),
  "left_panel_open": SymbolsMetadata(
    popularity: 84,
    codepoint: 0xf716,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2862, 2896, 4864, 269, 388, 12, 2983, 787, 4901, 12658, 2751, 306, 12659, 788, 421, 2653, 1068, 3421, 75, 2948, 782, 12597, 2997, 12660, 2993, 4787, 4899, 32, 314, 12661, 1215, 1054, 2746 ],
  ),
  "legend_toggle": SymbolsMetadata(
    popularity: 844,
    codepoint: 0xf11b,
    categories: [ 9 ],
    tags: [ 5, 920, 6660, 269, 10, 924, 12, 6326, 929, 900, 2080, 933, 135, 968, 4964, 1066, 12662, 12663, 366, 12664, 12665, 597, 937, 4458, 907, 909, 656, 2948, 65, 2997, 12666, 33, 313, 441, 314, 947, 4298 ],
  ),
  "lens_blur": SymbolsMetadata(
    popularity: 818,
    codepoint: 0xf029,
    categories: [ 1 ],
    tags: [ 1128, 3638, 4528, 4530, 47, 953, 4531, 12667, 4532, 3691, 4533, 832, 956, 2299, 2567, 959, 1738, 10218, 12668, 246, 53, 126, 12669, 2753, 4536, 3635, 59, 61, 5039, 310, 4540, 2438, 986 ],
  ),
  "letter_switch": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf758,
    categories: [ 12 ],
    tags: [ 4, 419, 1731, 12670, 692, 443, 7106, 3121, 2450, 12553, 2627, 5499, 12671, 1372, 10587, 8966, 3959, 10588, 5651, 12523, 10576, 12494, 4704, 12495, 8968, 396, 5256, 12672, 313, 38, 314, 7110, 8052, 12497, 2455, 704 ],
  ),
  "library_add": SymbolsMetadata(
    popularity: 5449,
    codepoint: 0xe02e,
    categories: [ 2 ],
    tags: [ 192, 526, 1264, 1266, 6670, 1680, 1681, 1057, 12673, 2155, 1062, 1201, 1202, 1686, 1044, 3759, 1066, 2159, 92, 2557, 2081, 763, 1275, 2163, 202, 1212, 100, 75, 944, 107, 12674, 1069, 35, 5320, 41 ],
  ),
  "library_add_check": SymbolsMetadata(
    popularity: 1266,
    codepoint: 0xe9b7,
    categories: [ 0 ],
    tags: [ 1627, 526, 6670, 1057, 1549, 1630, 5826, 1632, 2155, 1633, 1636, 1062, 2376, 1639, 1542, 1206, 3759, 1066, 2159, 1641, 2557, 2081, 1643, 202, 12675, 288, 32, 107, 1069, 1412, 2487, 1647, 2385, 2386, 1523, 41, 1650 ],
  ),
  "library_books": SymbolsMetadata(
    popularity: 6579,
    codepoint: 0xe02f,
    categories: [ 0 ],
    tags: [ 526, 1538, 2151, 1129, 1910, 4810, 2155, 1042, 1062, 1347, 5243, 3153, 1530, 1655, 135, 4686, 1066, 3375, 2159, 366, 3000, 2506, 2507, 75, 4359, 3158, 32, 107, 1069, 4689, 4691, 12676, 315 ],
    rtlAutoMirrored: true,
  ),
  "library_music": SymbolsMetadata(
    popularity: 1918,
    codepoint: 0xe030,
    categories: [ 0 ],
    tags: [ 526, 1538, 12677, 1129, 12678, 12679, 2155, 1062, 3759, 2159, 12680, 367, 326, 2081, 12681, 3131, 9566, 3394, 1532, 2163, 2164, 10836, 1156, 12682, 12683, 32, 2165, 3112 ],
  ),
  "license": SymbolsMetadata(
    popularity: 239,
    codepoint: 0xeb04,
    categories: [ 6 ],
    tags: [ 755, 3, 2717, 1769, 3574, 6, 2719, 2720, 1510, 383, 1732, 3357, 387, 1347, 1329, 3579, 4963, 817, 3361, 12684, 3118, 7030, 2028, 3766, 531, 7176, 2368, 7178, 889, 3585, 532, 441, 4965, 2387, 2388, 2389 ],
  ),
  "lift_to_talk": SymbolsMetadata(
    popularity: 306,
    codepoint: 0xefa3,
    categories: [ 11 ],
    tags: [ 951, 380, 1129, 443, 445, 2735, 2738, 3905, 2139, 966, 3472, 12685, 1143, 485, 1147, 219, 226, 12686, 12687, 12688, 121, 446, 1156, 492, 496, 1676, 1161, 12689 ],
  ),
  "light": SymbolsMetadata(
    popularity: 1005,
    codepoint: 0xf02a,
    categories: [ 8 ],
    tags: [ 1728, 3942, 7882, 12690, 2332, 5978, 12691, 12692, 10156, 1964, 3674, 7057, 6139, 12693, 999, 7468, 12694, 3677, 2795, 2796, 4418, 10062, 3680, 3946, 5062, 12695, 1602, 1456, 12696, 12697, 1960, 12698, 2542, 3699 ],
  ),
  "light_group": SymbolsMetadata(
    popularity: 305,
    codepoint: 0xe28b,
    categories: [ 10 ],
    tags: [ 2148, 1728, 2155, 269, 5978, 4049, 10156, 12699, 1964, 930, 12700, 999, 1435, 3676, 2796, 10062, 12701, 3680, 5062, 2484, 2557, 907, 909, 3782, 1960, 6616, 1901, 12702, 314 ],
    rtlAutoMirrored: true,
  ),
  "light_mode": SymbolsMetadata(
    popularity: 11737,
    codepoint: 0xe518,
    categories: [ 4 ],
    tags: [ 10544, 3670, 1728, 383, 5035, 6390, 445, 12, 3677, 3680, 7049, 9341, 5062, 366, 307, 2097, 5039, 3684, 330, 310, 5026, 6393, 3686, 4208, 6395, 3687, 313, 5027, 314, 317, 5023 ],
  ),
  "light_off": SymbolsMetadata(
    popularity: 60,
    codepoint: 0xe9b8,
    categories: [ 8 ],
    tags: [ 3942, 895, 5024, 12703, 896, 12704, 1077, 767, 12705, 898, 1078, 3944, 901, 1856, 10062, 3680, 12706, 3946, 2484, 12707, 4220, 4254, 12708, 10064, 907, 909, 3782, 6602, 914, 1929, 10066, 5587 ],
  ),
  "lightbulb": SymbolsMetadata(
    popularity: 10726,
    codepoint: 0xe0f0,
    categories: [ 6 ],
    tags: [ 469, 1245, 5171, 3670, 3942, 5163, 4292, 4078, 4049, 3779, 960, 6063, 16, 3944, 12709, 484, 135, 6632, 3945, 8983, 8984, 4686, 12710, 3680, 12711, 3946, 7791, 3329, 763, 1361, 3782, 4102, 105, 8986, 8987, 35, 9115, 6641, 7531 ],
  ),
  "lightbulb_2": SymbolsMetadata(
    popularity: 93,
    codepoint: 0xf3e3,
    categories: [ 8 ],
    tags: [ 7529, 469, 1245, 3670, 3942, 5163, 955, 4292, 960, 6063, 3944, 12709, 484, 135, 6632, 3945, 8983, 3502, 12712, 8984, 4686, 4695, 3375, 12710, 3680, 3946, 12713, 763, 1155, 8986, 9115, 6641, 7531 ],
  ),
  "lightbulb_circle": SymbolsMetadata(
    popularity: 925,
    codepoint: 0xebfe,
    categories: [ 6 ],
    tags: [ 7529, 469, 1245, 3942, 383, 5163, 4292, 3153, 4078, 3779, 6063, 3944, 12709, 484, 135, 6632, 3945, 8983, 4686, 10062, 3375, 12710, 3680, 3946, 763, 1361, 3782, 3331, 8986, 8987, 9115, 6641, 7531 ],
  ),
  "lightning_stand": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xefa4,
    categories: [ 11 ],
    tags: [ 4310, 4076, 4093, 3773, 3774, 6017, 383, 4363, 7572, 445, 2156, 2522, 4078, 12714, 6014, 4049, 3779, 12715, 12716, 4079, 965, 4082, 4083, 4131, 219, 1194, 3782, 4140, 4085, 4323, 4086, 234, 4189, 4654 ],
  ),
  "line_axis": SymbolsMetadata(
    popularity: 281,
    codepoint: 0xea9a,
    categories: [ 12 ],
    tags: [ 2513, 5, 9897, 920, 8935, 1202, 2448, 10, 2969, 924, 304, 929, 2176, 933, 1218, 1209, 1602, 12717, 366, 1210, 634, 1081, 11018, 33, 4818, 441, 2852, 1214, 1381, 1355, 2519, 3736, 4298 ],
  ),
  "line_curve": SymbolsMetadata(
    popularity: 45,
    codepoint: 0xf757,
    categories: [ 12 ],
    tags: [ 378, 2827, 4309, 3042, 349, 4864, 1062, 2332, 299, 388, 2834, 302, 696, 2299, 3327, 1372, 274, 304, 1602, 1361, 1586, 12718, 396, 889, 3331, 4850, 2542, 311, 4818, 12719, 12720, 402, 3025 ],
    rtlAutoMirrored: true,
  ),
  "line_end": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf826,
    categories: [ 12 ],
    tags: [ 2883, 12721, 1343, 211, 269, 2448, 1484, 3007, 2189, 12722, 12723, 1640, 5810, 3489, 2176, 1205, 1602, 12724, 935, 1001, 21, 3282, 1586, 1493, 28, 6115, 1396, 1503, 372, 1083, 4818, 5593, 12725 ],
  ),
  "line_end_arrow": SymbolsMetadata(
    popularity: 23,
    codepoint: 0xf81d,
    categories: [ 12 ],
    tags: [ 775, 380, 12726, 2883, 12721, 1633, 776, 269, 2448, 388, 2189, 12727, 12722, 1640, 777, 2176, 188, 1602, 12728, 12724, 421, 780, 1586, 2162, 1783, 781, 28, 1396, 782, 8691, 2343, 4818, 1412, 2571, 1701, 12729 ],
  ),
  "line_end_arrow_notch": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf81c,
    categories: [ 12 ],
    tags: [ 775, 380, 2883, 12721, 776, 269, 2448, 388, 2189, 12722, 2909, 926, 777, 2176, 188, 1602, 778, 421, 780, 12730, 1586, 2162, 1783, 781, 28, 1396, 782, 8691, 2343, 104, 3935, 4818, 1412, 2571, 1701 ],
  ),
  "line_end_circle": SymbolsMetadata(
    popularity: 33,
    codepoint: 0xf81b,
    categories: [ 12 ],
    tags: [ 2883, 12721, 1058, 1994, 383, 1633, 4268, 211, 2448, 1484, 2189, 12722, 12723, 1640, 15, 2176, 1064, 1602, 12731, 935, 1001, 1002, 21, 421, 223, 3282, 1586, 1493, 1396, 1503, 1083, 4818, 36, 5593, 12725 ],
  ),
  "line_end_diamond": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf81a,
    categories: [ 12 ],
    tags: [ 380, 2883, 12721, 1994, 211, 4363, 2448, 1484, 924, 1416, 388, 2189, 12722, 12723, 1640, 926, 3501, 304, 2176, 1064, 1602, 935, 1067, 223, 1586, 3505, 1783, 1421, 1396, 1503, 32, 1083, 4818, 6598, 5593 ],
  ),
  "line_end_square": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf819,
    categories: [ 12 ],
    tags: [ 380, 2883, 12721, 1058, 1994, 1633, 12732, 921, 211, 2448, 3306, 2189, 12722, 12590, 1640, 926, 1659, 2176, 966, 1064, 2874, 1602, 935, 3329, 1719, 1586, 75, 1396, 782, 105, 32, 1083, 4818, 5593 ],
  ),
  "line_start": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xf825,
    categories: [ 12 ],
    tags: [ 951, 2883, 12721, 3453, 84, 383, 12733, 211, 2448, 832, 12722, 12723, 90, 2910, 2176, 1205, 5206, 8012, 12734, 3080, 1375, 1602, 12735, 935, 3282, 12736, 3362, 12737, 1586, 2162, 1363, 1503, 108, 11662, 4818, 12720, 985 ],
  ),
  "line_start_arrow": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf818,
    categories: [ 12 ],
    tags: [ 380, 2883, 12721, 2489, 3453, 84, 2871, 2862, 269, 2448, 388, 12722, 1659, 2873, 2176, 188, 1375, 2875, 1602, 12738, 2974, 779, 421, 3282, 1586, 1783, 2876, 2878, 2495, 2881, 2886, 108, 12739, 4818, 1701, 2499 ],
  ),
  "line_start_arrow_notch": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf817,
    categories: [ 12 ],
    tags: [ 380, 2883, 12721, 2489, 3453, 84, 12740, 2871, 2862, 269, 2448, 388, 12722, 2176, 188, 1375, 2875, 1602, 12738, 778, 779, 421, 3282, 12730, 1586, 1783, 2876, 2495, 2881, 2886, 108, 12741, 4818, 2571, 1701, 2499 ],
  ),
  "line_start_circle": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xf816,
    categories: [ 12 ],
    tags: [ 755, 951, 2883, 12721, 1058, 3453, 84, 383, 12733, 921, 211, 269, 1201, 2448, 12722, 12742, 90, 3489, 2176, 5206, 7078, 1044, 1064, 3408, 3080, 1375, 1602, 935, 788, 421, 763, 3282, 281, 3362, 1586, 108, 4818, 313, 314, 985 ],
  ),
  "line_start_diamond": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf815,
    categories: [ 12 ],
    tags: [ 951, 380, 2883, 12721, 3453, 84, 12733, 269, 2448, 1416, 388, 12722, 1659, 3489, 2176, 188, 7078, 1375, 1602, 421, 3282, 12736, 3362, 12737, 1586, 2162, 1363, 1421, 1396, 782, 1422, 1423, 311, 372, 32, 108, 12739, 4818, 985 ],
  ),
  "line_start_square": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xf814,
    categories: [ 12 ],
    tags: [ 951, 526, 1057, 380, 2883, 12721, 1058, 3453, 84, 921, 1201, 2448, 388, 12722, 90, 926, 2176, 5206, 7078, 1044, 1064, 3080, 1375, 1602, 935, 763, 3282, 3362, 1586, 12743, 942, 75, 1396, 104, 32, 108, 3935, 4818, 985 ],
  ),
  "line_style": SymbolsMetadata(
    popularity: 273,
    codepoint: 0xe919,
    categories: [ 12 ],
    tags: [ 2169, 918, 1042, 2448, 3640, 696, 2299, 1372, 2175, 246, 2176, 2080, 4964, 1066, 1602, 366, 12744, 92, 2180, 12745, 75, 2258, 1603, 1376, 601, 2248, 944, 107, 1069, 2182, 38, 12746, 40, 3735, 704 ],
  ),
  "line_weight": SymbolsMetadata(
    popularity: 372,
    codepoint: 0xe91a,
    categories: [ 12 ],
    tags: [ 2169, 1367, 2778, 1347, 1371, 14, 1372, 2175, 2470, 2176, 2080, 4964, 1066, 1602, 366, 92, 788, 656, 2180, 329, 371, 65, 673, 2248, 107, 1069, 2182, 38, 2230, 9147, 40, 702, 3831 ],
  ),
  "linear_scale": SymbolsMetadata(
    popularity: 891,
    codepoint: 0xe260,
    categories: [ 12 ],
    tags: [ 1128, 1229, 1230, 1058, 383, 1061, 3813, 2750, 211, 2919, 299, 588, 787, 2176, 2751, 1064, 306, 3009, 1602, 4545, 12747, 935, 597, 634, 4636, 788, 1067, 223, 3282, 1363, 7277, 1007, 3149, 2247, 7788, 2281, 330, 2882, 372, 2757, 2759, 1691, 1053, 3014, 1054 ],
  ),
  "link": SymbolsMetadata(
    popularity: 15933,
    codepoint: 0xe157,
    categories: [ 7 ],
    tags: [ 526, 1462, 1058, 1466, 3909, 1467, 1469, 921, 211, 6465, 1471, 2080, 1472, 1044, 1474, 215, 1064, 935, 1000, 11012, 328, 223, 77, 1665, 3058, 441, 1479, 1480, 1241, 1053 ],
  ),
  "link_off": SymbolsMetadata(
    popularity: 2284,
    codepoint: 0xe16f,
    categories: [ 7 ],
    tags: [ 1058, 12748, 2136, 12749, 12750, 12751, 1467, 12752, 1469, 211, 4563, 1076, 12753, 3303, 12754, 767, 3306, 12755, 898, 901, 7067, 935, 1000, 11012, 12756, 328, 2043, 907, 909, 12757, 12758, 2264, 914, 12759, 12760, 3312, 1479 ],
  ),
  "linked_camera": SymbolsMetadata(
    popularity: 575,
    codepoint: 0xe438,
    categories: [ 1 ],
    tags: [ 355, 47, 116, 383, 921, 12761, 211, 445, 1711, 53, 215, 126, 1000, 12762, 4985, 5516, 223, 819, 59, 61, 119, 121, 12763, 227, 2084, 32, 2057, 342, 1667, 551, 441, 41, 540, 233, 234, 12764 ],
  ),
  "linked_services": SymbolsMetadata(
    popularity: 140,
    codepoint: 0xf535,
    categories: [ 2 ],
    tags: [ 1058, 1467, 920, 953, 1061, 921, 11013, 211, 10, 924, 12765, 12766, 12767, 926, 3501, 930, 931, 932, 4867, 2629, 1064, 366, 935, 1000, 12768, 1067, 223, 939, 940, 3641, 3962, 7611, 8006, 2755, 945 ],
  ),
  "liquor": SymbolsMetadata(
    popularity: 1780,
    codepoint: 0xea60,
    categories: [ 16 ],
    tags: [ 10865, 12769, 1343, 4381, 1869, 12770, 5149, 12771, 5150, 5935, 10926, 12772, 12773, 4388, 10867, 5152, 1829, 964, 2018, 10870, 12774, 12775, 487, 10871, 3807, 12776, 12777, 1298, 4980, 12778, 12779 ],
  ),
  "list": SymbolsMetadata(
    popularity: 11735,
    codepoint: 0xe896,
    categories: [ 12 ],
    tags: [ 1367, 10523, 10525, 1631, 953, 10232, 6936, 956, 1530, 1372, 2080, 91, 135, 2245, 92, 788, 421, 656, 98, 329, 99, 371, 65, 2993, 3159, 441, 6085, 10527 ],
    rtlAutoMirrored: true,
  ),
  "list_alt": SymbolsMetadata(
    popularity: 9627,
    codepoint: 0xe0ee,
    categories: [ 12 ],
    tags: [ 1499, 2442, 1367, 7, 8594, 1631, 1652, 3356, 10, 132, 1347, 1654, 1530, 1598, 1372, 135, 2245, 366, 92, 788, 656, 96, 98, 329, 8507, 78, 371, 65, 32, 1069, 674, 945, 3159, 441, 4550, 10459, 6085, 317 ],
    rtlAutoMirrored: true,
  ),
  "list_alt_add": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xf756,
    categories: [ 12 ],
    tags: [ 192, 526, 1264, 1057, 7, 10523, 1631, 953, 693, 1201, 1528, 1347, 1654, 696, 1530, 1044, 1620, 366, 92, 7506, 1755, 1740, 763, 1275, 1533, 98, 1534, 202, 1212, 32, 1645, 441, 6085 ],
  ),
  "list_alt_check": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf3de,
    categories: [ 12 ],
    tags: [ 1499, 1230, 2717, 1549, 2480, 7, 1630, 5826, 1631, 1632, 1633, 1635, 1636, 4269, 3356, 2376, 1639, 2909, 1598, 1372, 366, 92, 1755, 936, 1641, 1643, 4750, 96, 8507, 288, 371, 1069, 1645, 1688, 1646, 3159, 1647, 6088, 10459, 6085, 2386, 8401, 2387, 1650 ],
  ),
  "lists": SymbolsMetadata(
    popularity: 230,
    codepoint: 0xe9b9,
    categories: [ 6 ],
    tags: [ 2170, 5123, 3851, 10523, 1630, 1631, 1042, 10, 6936, 12, 1347, 1598, 6327, 2080, 91, 135, 2245, 92, 7506, 788, 421, 1533, 656, 98, 3641, 75, 371, 2993, 944, 3159, 441, 2252, 1648, 6085, 317 ],
    rtlAutoMirrored: true,
  ),
  "live_help": SymbolsMetadata(
    popularity: 3756,
    codepoint: 0xe0c6,
    categories: [ 7 ],
    tags: [ 4095, 5171, 6950, 738, 471, 472, 473, 474, 443, 475, 6860, 477, 6951, 6952, 482, 484, 135, 6938, 4985, 12780, 12781, 485, 12782, 11505, 1363, 1783, 4101, 979, 4102, 4103, 1029, 3749, 78, 492, 493, 494, 495, 35, 496 ],
    rtlAutoMirrored: true,
  ),
  "live_tv": SymbolsMetadata(
    popularity: 3153,
    codepoint: 0xe639,
    categories: [ 11 ],
    tags: [ 1109, 1110, 12783, 355, 12784, 1684, 1685, 445, 12, 3337, 270, 1114, 4985, 1687, 367, 327, 278, 328, 11630, 2162, 283, 2904, 2648, 330, 108, 2057, 342, 343, 1701, 344, 41, 12785, 317, 11632, 2102, 1691, 1054 ],
  ),
  "living": SymbolsMetadata(
    popularity: 473,
    codepoint: 0xf02b,
    categories: [ 8 ],
    tags: [ 2600, 5976, 1912, 1914, 5977, 5978, 1434, 1964, 999, 1435, 1436, 12786, 2796, 9236, 5981, 5982, 5984, 5985, 5986, 1444, 1958, 1959, 1446, 1960, 1926, 5987, 1947, 5988, 32, 3846 ],
  ),
  "local_activity": SymbolsMetadata(
    popularity: 3333,
    codepoint: 0xe53f,
    categories: [ 5 ],
    tags: [ 755, 989, 4710, 6879, 267, 4711, 6881, 3337, 12787, 1597, 2094, 4715, 3341, 6868, 12788, 12789, 1001, 278, 9291, 12790, 2028, 1495, 2162, 2997, 3264, 12791, 3412, 11689, 2022, 6884 ],
  ),
  "local_atm": SymbolsMetadata(
    popularity: 1838,
    codepoint: 0xe53e,
    categories: [ 5 ],
    tags: [ 1429, 3267, 795, 796, 797, 799, 1619, 800, 801, 803, 805, 806, 3274, 3315, 12792, 807, 808, 811, 6868, 1001, 1002, 818, 421, 9291, 819, 820, 821, 1493, 1495, 1363, 77, 824, 841, 35, 441, 842, 3279 ],
  ),
  "local_bar": SymbolsMetadata(
    popularity: 2064,
    codepoint: 0xe540,
    categories: [ 16 ],
    tags: [ 10865, 1343, 12793, 4381, 1869, 5149, 10926, 12772, 1578, 4388, 3337, 12794, 1829, 6278, 964, 1488, 12795, 10870, 6868, 12796, 1001, 5984, 1002, 12774, 421, 12797, 12798, 12775, 487, 2613, 10871, 3807, 607, 12778 ],
  ),
  "local_cafe": SymbolsMetadata(
    popularity: 3497,
    codepoint: 0xe541,
    categories: [ 16 ],
    tags: [ 1940, 4381, 1869, 3790, 12799, 3792, 12800, 6605, 6607, 12801, 6609, 4388, 3800, 1829, 4974, 7310, 4217, 6611, 2607, 6868, 12802, 3804, 2097, 6614, 3807, 2631, 6617, 8959 ],
  ),
  "local_car_wash": SymbolsMetadata(
    popularity: 534,
    codepoint: 0xe542,
    categories: [ 5 ],
    tags: [ 1131, 12803, 12804, 1814, 3467, 12805, 1815, 12806, 12807, 5701, 12808, 12809, 1816, 4005, 7993, 7994, 8133, 6868, 12810, 1490, 12811, 7486, 3998, 7997, 1930, 1504, 1844, 12812, 4001, 2801, 12813 ],
  ),
  "local_convenience_store": SymbolsMetadata(
    popularity: 1279,
    codepoint: 0xe543,
    categories: [ 5 ],
    tags: [ 12814, 294, 12815, 12816, 12817, 12818, 12819, 12820, 12821, 3063, 1283, 797, 798, 1284, 799, 800, 801, 803, 1285, 12822, 12823, 805, 806, 807, 12824, 6868, 12825, 12826, 1490, 1291, 818, 763, 819, 2653, 12827, 12828, 4221, 820, 821, 202, 1296, 1297, 841, 1298, 1299, 35, 12829 ],
  ),
  "local_dining": SymbolsMetadata(
    popularity: 1191,
    codepoint: 0xe556,
    categories: [ 16 ],
    tags: [ 3790, 3791, 3792, 8083, 6165, 8084, 12830, 3798, 3799, 4275, 3800, 3801, 12831, 1829, 4389, 4974, 2000, 4217, 10072, 6868, 12832, 3803, 3804, 788, 12833, 3807, 5157, 12834, 8090, 8091, 8101 ],
  ),
  "local_drink": SymbolsMetadata(
    popularity: 1339,
    codepoint: 0xe544,
    categories: [ 5 ],
    tags: [ 10865, 1343, 12835, 4381, 3792, 12772, 1269, 6609, 4388, 12836, 1500, 4471, 964, 4393, 2798, 6868, 12837, 12838, 3345, 12839, 10871, 8956, 3807, 9574, 11891, 11901, 6368, 2801, 12778 ],
  ),
  "local_fire_department": SymbolsMetadata(
    popularity: 6003,
    codepoint: 0xef55,
    categories: [ 5 ],
    tags: [ 6931, 469, 9955, 5597, 712, 12840, 5929, 2482, 5601, 9957, 9951, 5311, 3076, 999, 3078, 12841, 9969, 12842, 12843, 1004, 486, 12844, 31, 727, 7945, 729, 3858, 12845, 12846, 12847, 1261, 12848, 12849 ],
  ),
  "local_florist": SymbolsMetadata(
    popularity: 2196,
    codepoint: 0xe545,
    categories: [ 5 ],
    tags: [ 2170, 7622, 7623, 9655, 12850, 8973, 12851, 2433, 12852, 6816, 6817, 9599, 196, 5637, 6820, 6868, 1290, 12853, 12854, 1859, 9895, 1835, 12855, 1297, 2439, 7901, 1298, 4206 ],
  ),
  "local_gas_station": SymbolsMetadata(
    popularity: 1992,
    codepoint: 0xe546,
    categories: [ 5 ],
    tags: [ 1131, 3467, 1815, 12823, 12856, 3779, 6018, 9190, 12857, 1854, 12858, 12859, 6868, 1001, 1002, 421, 9291, 12860, 12861, 12862, 6959, 11483, 12863, 3476, 12864, 3611, 1930, 1504, 1844 ],
  ),
  "local_hospital": SymbolsMetadata(
    popularity: 2324,
    codepoint: 0xe548,
    categories: [ 5 ],
    tags: [ 6931, 736, 738, 1749, 1202, 388, 1751, 2482, 9956, 960, 90, 4472, 595, 11508, 1753, 1754, 12865, 6868, 1001, 1002, 1757, 12866, 1760, 421, 9291, 1495, 202, 980, 495, 12867 ],
  ),
  "local_laundry_service": SymbolsMetadata(
    popularity: 1157,
    codepoint: 0xe54a,
    categories: [ 5 ],
    tags: [ 1888, 8235, 383, 4005, 2701, 12868, 2702, 194, 1433, 7165, 8575, 8567, 2706, 2607, 6349, 12604, 8579, 8580, 6868, 1290, 12869, 9292, 889, 2631, 399, 12870, 32, 2713, 4001, 8242, 8243 ],
  ),
  "local_library": SymbolsMetadata(
    popularity: 3839,
    codepoint: 0xe54b,
    categories: [ 5 ],
    tags: [ 4701, 1429, 1910, 12871, 798, 194, 12872, 1484, 3153, 135, 814, 4686, 3375, 2159, 3462, 6868, 1001, 1002, 21, 3463, 1493, 1495, 12873, 2506, 2507, 4359, 3158, 3730, 4689, 4691 ],
  ),
  "local_mall": SymbolsMetadata(
    popularity: 5863,
    codepoint: 0xe54c,
    categories: [ 5 ],
    tags: [ 3719, 797, 798, 1284, 1618, 799, 3723, 1619, 800, 801, 803, 12874, 805, 806, 12875, 807, 4918, 11081, 12876, 6868, 1290, 12877, 12826, 9164, 1291, 4919, 818, 12878, 819, 820, 821, 12879, 6997, 840, 1296, 12880, 1297, 841, 4743, 12881, 1298, 1299, 11088, 4745 ],
  ),
  "local_parking": SymbolsMetadata(
    popularity: 2440,
    codepoint: 0xe54f,
    categories: [ 5 ],
    tags: [ 4, 993, 1131, 12882, 1815, 12883, 8, 12884, 14, 3471, 7442, 19, 6868, 12885, 1001, 1002, 421, 12886, 9292, 12887, 12888, 3345, 4319, 12889, 12890, 12891, 12892, 1493, 1495, 6959, 12893, 35, 38, 1930, 40, 1844, 1013 ],
  ),
  "local_pharmacy": SymbolsMetadata(
    popularity: 746,
    codepoint: 0xe550,
    categories: [ 5 ],
    tags: [ 6931, 736, 12894, 12895, 194, 1202, 5630, 1752, 12896, 2482, 960, 90, 4472, 595, 1753, 1754, 6868, 1001, 1757, 1759, 1760, 12897, 9291, 12898, 1763, 1495, 2613, 202, 1765, 1766, 980, 1297, 1298 ],
  ),
  "local_pizza": SymbolsMetadata(
    popularity: 1358,
    codepoint: 0xe552,
    categories: [ 5 ],
    tags: [ 12899, 6169, 1019, 4275, 4388, 3800, 12900, 9572, 1829, 11079, 8097, 12901, 6868, 1290, 12902, 12832, 3803, 3804, 12903, 12904, 6417, 12905, 12906, 3807, 4979, 3809, 4283, 12907, 1701 ],
  ),
  "local_police": SymbolsMetadata(
    popularity: 2394,
    codepoint: 0xef56,
    categories: [ 5 ],
    tags: [ 6931, 738, 2730, 6, 12908, 12909, 4120, 5929, 2482, 8933, 12910, 12911, 482, 816, 12912, 6868, 12913, 12914, 12915, 8616, 12916, 1519, 1520, 12917, 602, 1011, 12918, 1522, 3264, 3611 ],
  ),
  "local_post_office": SymbolsMetadata(
    popularity: 1313,
    codepoint: 0xe554,
    categories: [ 5 ],
    tags: [ 1429, 798, 443, 194, 475, 2331, 1019, 2335, 3286, 10646, 812, 16, 135, 4704, 19, 6868, 12919, 1001, 2340, 12920, 12921, 485, 9292, 1456, 2647, 4920, 1495, 1409, 12922, 4921, 12923, 2071, 2342, 2343, 2631, 4604, 2728, 35 ],
  ),
  "local_see": SymbolsMetadata(
    popularity: 354,
    codepoint: 0xe557,
    categories: [ 5 ],
    tags: [ 47, 955, 958, 3578, 12924, 1488, 53, 1251, 3343, 126, 6868, 12925, 9289, 1001, 1002, 21, 421, 12926, 59, 61, 119, 1493, 1495, 9293, 9294, 4271, 981, 3348, 3264, 2023, 1504 ],
  ),
  "local_shipping": SymbolsMetadata(
    popularity: 20221,
    codepoint: 0xe558,
    categories: [ 14 ],
    tags: [ 1814, 1815, 4611, 1816, 12927, 1019, 7693, 12928, 2210, 1329, 7701, 4614, 19, 6868, 12929, 12930, 3896, 12931, 2340, 1490, 1456, 96, 2647, 4920, 1409, 4921, 7704, 2343, 4922, 4604, 12932, 12933, 841, 2728, 1842, 1930, 1843, 2076, 1844 ],
    rtlAutoMirrored: true,
  ),
  "local_taxi": SymbolsMetadata(
    popularity: 1625,
    codepoint: 0xe559,
    categories: [ 14 ],
    tags: [ 1814, 3467, 8890, 1133, 1815, 1816, 2063, 1484, 388, 2723, 2065, 1488, 2066, 11203, 6868, 1001, 12934, 1002, 1490, 421, 1922, 5736, 2071, 2072, 12935, 1587, 12936, 2631, 1589, 8895, 12937, 1842, 1930, 1504, 12938, 1844, 12939 ],
  ),
  "location_away": SymbolsMetadata(
    popularity: 2138,
    codepoint: 0xf150,
    categories: [ 5 ],
    tags: [ 468, 1429, 2601, 470, 12940, 798, 2016, 588, 2605, 479, 12941, 999, 1435, 1436, 483, 188, 6244, 12942, 1001, 12943, 12944, 12945, 2398, 3841, 488, 489, 1495, 1516, 490, 2614, 5716, 1446, 2616, 65, 553, 915, 501, 12946 ],
  ),
  "location_chip": SymbolsMetadata(
    popularity: 31,
    codepoint: 0xf850,
    categories: [ 12 ],
    tags: [ 1429, 993, 1748, 5250, 1483, 1484, 388, 12947, 1486, 1487, 1488, 1001, 12948, 8257, 1002, 1490, 21, 421, 5185, 1764, 1493, 1495, 1363, 1496, 1008, 77, 1503, 8193, 1083, 2165, 947 ],
  ),
  "location_city": SymbolsMetadata(
    popularity: 4859,
    codepoint: 0xe7f1,
    categories: [ 16 ],
    tags: [ 1429, 2600, 12949, 2601, 1074, 798, 11644, 1284, 2602, 8999, 12950, 194, 12951, 1434, 2605, 999, 2607, 1435, 11646, 1543, 1001, 1002, 8161, 12952, 421, 9292, 1456, 12953, 1495, 1444, 2614, 1445, 1446, 2616, 2617, 2618, 1589, 9000, 2621 ],
  ),
  "location_disabled": SymbolsMetadata(
    popularity: 298,
    codepoint: 0xe1b6,
    categories: [ 5 ],
    tags: [ 1074, 1075, 383, 2200, 1484, 388, 767, 898, 960, 1488, 8112, 8113, 12954, 901, 1001, 8114, 8115, 12955, 1002, 1490, 421, 8144, 8946, 907, 909, 1493, 1494, 1495, 1783, 5972, 171, 980, 914, 1083, 36, 947, 915 ],
  ),
  "location_home": SymbolsMetadata(
    popularity: 1353,
    codepoint: 0xf152,
    categories: [ 5 ],
    tags: [ 468, 2601, 470, 84, 798, 2515, 4825, 1434, 2605, 479, 867, 11649, 999, 7502, 1435, 1436, 483, 1001, 7498, 779, 421, 488, 489, 1495, 5208, 490, 2614, 1446, 12956, 2616, 2495, 1772, 2617, 108, 12049, 501 ],
  ),
  "location_off": SymbolsMetadata(
    popularity: 882,
    codepoint: 0xe0c7,
    categories: [ 5 ],
    tags: [ 12957, 1484, 388, 8138, 8141, 12958, 12959, 8112, 8113, 12960, 12961, 12954, 1001, 8114, 12962, 8115, 12955, 12963, 12964, 12965, 1490, 12443, 12966, 8143, 8144, 8946, 12967, 7142, 907, 1493, 12968, 12969, 1495, 12970, 12971, 12972, 12973, 1083, 12974, 12975 ],
  ),
  "location_on": SymbolsMetadata(
    popularity: 18201,
    codepoint: 0xe0c8,
    categories: [ 5 ],
    tags: [ 1429, 993, 1483, 1484, 388, 960, 12976, 1486, 1487, 1488, 1001, 12977, 12237, 1002, 6280, 1490, 21, 12978, 421, 909, 1493, 1494, 1495, 1363, 1496, 1008, 1960, 980, 8193, 1083, 2165, 1504 ],
  ),
  "location_searching": SymbolsMetadata(
    popularity: 2228,
    codepoint: 0xe1b7,
    categories: [ 5 ],
    tags: [ 5656, 12979, 1483, 1484, 388, 955, 958, 960, 12980, 1488, 8113, 12961, 1001, 8114, 12981, 12982, 8257, 12964, 1002, 1490, 421, 1493, 1494, 1495, 1783, 1496, 1503, 4525, 12983, 12984, 1083, 36, 947, 1504, 3229 ],
  ),
  "lock": SymbolsMetadata(
    popularity: 30303,
    codepoint: 0xe897,
    categories: [ 6 ],
    tags: [ 755, 1768, 1769, 3242, 9012, 3244, 6526, 8398, 6527, 2674, 5714, 852, 6528, 1361, 6530, 5715, 1516, 1517, 1520, 912, 1772, 602, 1773, 1011, 2913, 8399, 8400, 5717 ],
  ),
  "lock_clock": SymbolsMetadata(
    popularity: 1133,
    codepoint: 0xef57,
    categories: [ 6 ],
    tags: [ 755, 1016, 1017, 2137, 1020, 11786, 2674, 12985, 12986, 5714, 5715, 2858, 1516, 1517, 1520, 171, 602, 1031, 1773, 1011, 8018, 12987, 3443, 12988, 289, 12989, 12990, 11798, 1033, 12991, 2147 ],
  ),
  "lock_open": SymbolsMetadata(
    popularity: 8336,
    codepoint: 0xe898,
    categories: [ 6 ],
    tags: [ 755, 12992, 468, 1768, 1769, 383, 3244, 7310, 2527, 9045, 9016, 2674, 12993, 852, 12994, 2653, 12995, 12996, 12997, 6530, 5715, 1514, 10296, 1516, 1517, 1520, 602, 1773, 1011, 2913, 913, 32, 5717, 9052, 12998 ],
  ),
  "lock_open_circle": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf361,
    categories: [ 6 ],
    tags: [ 755, 733, 468, 3063, 383, 384, 7310, 12999, 852, 903, 12994, 2653, 12997, 656, 6530, 1514, 329, 1516, 490, 1257, 889, 1011, 65, 2913, 913, 5717, 9052, 12998 ],
  ),
  "lock_open_right": SymbolsMetadata(
    popularity: 156,
    codepoint: 0xf656,
    categories: [ 6 ],
    tags: [ 755, 12992, 733, 13000, 3063, 383, 7310, 2527, 2674, 13001, 2653, 12996, 13002, 6530, 5715, 1514, 1516, 1517, 1520, 3068, 13003, 13004, 1772, 602, 1773, 1011, 13005, 32, 13006, 5717, 13007, 9052 ],
  ),
  "lock_person": SymbolsMetadata(
    popularity: 1195,
    codepoint: 0xf8f3,
    categories: [ 6 ],
    tags: [ 755, 468, 1768, 1769, 3242, 850, 2674, 13008, 852, 903, 853, 3118, 6530, 489, 1516, 1517, 490, 1519, 1520, 912, 1772, 602, 1773, 1011, 2913, 913, 501, 13009 ],
  ),
  "lock_reset": SymbolsMetadata(
    popularity: 2179,
    codepoint: 0xeade,
    categories: [ 6 ],
    tags: [ 755, 468, 2284, 1768, 1769, 1731, 13010, 2490, 3763, 385, 13011, 3524, 3513, 3525, 2674, 13012, 5714, 390, 6530, 5715, 13013, 1516, 1517, 1520, 424, 425, 2494, 426, 3516, 396, 602, 1773, 1011, 65, 402, 5717 ],
  ),
  "login": SymbolsMetadata(
    popularity: 20907,
    codepoint: 0xea77,
    categories: [ 2 ],
    tags: [ 755, 468, 1229, 1230, 380, 1768, 1769, 2750, 776, 299, 2604, 6103, 2909, 1597, 777, 6105, 3091, 2795, 2751, 1375, 5126, 852, 853, 2653, 5653, 781, 490, 782, 330, 1011, 7494, 2913, 2882, 1412, 2757, 5717, 501, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "logo_dev": SymbolsMetadata(
    popularity: 497,
    codepoint: 0xead6,
    categories: [ 6 ],
    tags: [ 186, 687, 1229, 1230, 7, 2539, 6580, 194, 13014, 13015, 1186, 2625, 6583, 2835, 850, 19, 2528, 1194, 2630, 8467, 5248, 1196, 32, 38, 2537, 2756, 1691, 1053 ],
  ),
  "logout": SymbolsMetadata(
    popularity: 45488,
    codepoint: 0xe9ba,
    categories: [ 2 ],
    tags: [ 468, 1229, 1230, 380, 3106, 2950, 2750, 299, 3306, 2604, 13016, 6103, 13017, 13018, 2985, 777, 2751, 6244, 5126, 852, 903, 907, 8436, 2398, 3782, 1516, 490, 4449, 1396, 782, 330, 1011, 13019, 13020, 913, 2882, 2757, 501, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "looks": SymbolsMetadata(
    popularity: 542,
    codepoint: 0xe3fc,
    categories: [ 1 ],
    tags: [ 2827, 13021, 1182, 383, 2566, 2332, 1852, 12, 3108, 6300, 1188, 13022, 13023, 5042, 1066, 7194, 8559, 10277, 10278, 13024, 2948, 13025, 5063, 13026, 2997, 7070, 317, 2512, 8214, 4583, 2102 ],
  ),
  "looks_3": SymbolsMetadata(
    popularity: 1069,
    codepoint: 0xe3fb,
    categories: [ 1 ],
    tags: [ 82, 10544, 6, 7, 298, 9, 11, 930, 16, 2472, 92, 7194, 421, 23, 24, 25, 96, 29, 100, 104, 32, 6705, 3935, 35, 110, 374, 2511, 13027, 8344, 317 ],
  ),
  "looks_4": SymbolsMetadata(
    popularity: 675,
    codepoint: 0xe3fd,
    categories: [ 1 ],
    tags: [ 534, 10544, 2170, 1074, 7, 2155, 1269, 9, 299, 11, 1372, 538, 4705, 246, 930, 306, 7194, 23, 24, 25, 1068, 412, 29, 13028, 6616, 32, 2182, 35, 5027, 317, 1054 ],
  ),
  "looks_5": SymbolsMetadata(
    popularity: 509,
    codepoint: 0xe3fe,
    categories: [ 1 ],
    tags: [ 564, 10544, 6, 7, 9, 86, 299, 11, 4707, 188, 1620, 2472, 92, 7194, 23, 24, 25, 29, 101, 102, 4475, 190, 7196, 104, 32, 6705, 3935, 2182, 35, 5027 ],
  ),
  "looks_6": SymbolsMetadata(
    popularity: 379,
    codepoint: 0xe3ff,
    categories: [ 1 ],
    tags: [ 580, 7, 9, 86, 11, 3327, 1620, 2472, 92, 7194, 13029, 13030, 23, 13031, 24, 25, 13032, 96, 1496, 29, 101, 102, 13033, 78, 104, 7207, 13034, 32, 6705, 3935, 35 ],
  ),
  "looks_one": SymbolsMetadata(
    popularity: 2585,
    codepoint: 0xe400,
    categories: [ 1 ],
    tags: [ 79, 6, 84, 7, 9, 86, 11, 90, 16, 5206, 2472, 7194, 23, 24, 25, 7205, 3542, 96, 5208, 29, 101, 102, 104, 7198, 32, 6705, 108, 3935, 35 ],
  ),
  "looks_two": SymbolsMetadata(
    popularity: 1226,
    codepoint: 0xe401,
    categories: [ 1 ],
    tags: [ 81, 6, 7, 9, 11, 3108, 6788, 16, 18, 2472, 7194, 13035, 21, 421, 23, 24, 25, 12596, 3000, 29, 190, 103, 104, 32, 6705, 3935, 35, 315 ],
  ),
  "loupe": SymbolsMetadata(
    popularity: 735,
    codepoint: 0xe402,
    categories: [ 1 ],
    tags: [ 192, 526, 2513, 7650, 13036, 545, 132, 4292, 528, 1216, 6874, 787, 958, 960, 1738, 964, 196, 1207, 1217, 4294, 8378, 973, 974, 975, 976, 763, 13037, 202, 1213, 2401, 980, 35, 986, 2403, 13038 ],
  ),
  "low_density": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf79b,
    categories: [ 1 ],
    tags: [ 1128, 269, 2448, 2449, 10, 2922, 11552, 7712, 9551, 13039, 2210, 956, 12148, 246, 135, 7648, 4014, 13040, 2753, 3329, 2928, 656, 1719, 3641, 329, 62, 2930, 11010, 4539, 330, 65, 13041, 13042, 2438, 13043, 32 ],
  ),
  "low_priority": SymbolsMetadata(
    popularity: 1122,
    codepoint: 0xe16d,
    categories: [ 12 ],
    tags: [ 1367, 380, 2489, 2870, 2188, 3121, 13044, 13045, 13046, 13047, 2874, 366, 92, 4014, 13048, 936, 778, 96, 98, 4758, 100, 101, 2492, 13049, 2495, 2496, 65, 106, 1645, 3159, 441, 2499 ],
  ),
  "lowercase": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf48a,
    categories: [ 12 ],
    tags: [ 685, 4, 2940, 2188, 2871, 8, 2896, 2919, 2922, 2923, 388, 2840, 337, 14, 777, 1542, 188, 2781, 19, 12176, 2928, 421, 780, 2930, 1664, 2933, 35, 38, 13050, 13051, 40, 702, 2789 ],
  ),
  "loyalty": SymbolsMetadata(
    popularity: 2914,
    codepoint: 0xe89a,
    categories: [ 9 ],
    tags: [ 6, 13052, 799, 805, 6993, 5751, 1329, 5756, 3578, 4455, 18, 4768, 5758, 1045, 853, 3118, 5771, 2742, 3641, 531, 2648, 1050, 8006, 1296, 3584, 3898, 841, 532, 2384, 1504, 1591, 5766 ],
  ),
  "lte_mobiledata": SymbolsMetadata(
    popularity: 251,
    codepoint: 0xf02c,
    categories: [ 4 ],
    tags: [ 502, 503, 4, 504, 208, 210, 8, 211, 10, 213, 13053, 14, 514, 506, 215, 216, 19, 507, 13054, 219, 13055, 433, 434, 221, 516, 222, 223, 517, 227, 231, 35, 438, 439, 38, 40, 233, 234, 235 ],
  ),
  "lte_mobiledata_badge": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf7d9,
    categories: [ 4 ],
    tags: [ 502, 4, 6, 208, 210, 8, 443, 211, 10, 213, 14, 16, 188, 215, 18, 19, 507, 219, 433, 221, 223, 226, 75, 77, 227, 231, 553, 35, 38, 3554, 40, 233, 234 ],
  ),
  "lte_plus_mobiledata": SymbolsMetadata(
    popularity: 173,
    codepoint: 0xf02d,
    categories: [ 4 ],
    tags: [ 192, 502, 4, 365, 208, 210, 8, 443, 211, 212, 10, 213, 512, 513, 14, 359, 215, 432, 19, 507, 515, 219, 433, 221, 516, 222, 223, 226, 202, 227, 231, 35, 38, 40, 233, 234 ],
  ),
  "lte_plus_mobiledata_badge": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf7d8,
    categories: [ 4 ],
    tags: [ 192, 502, 526, 4, 6, 4093, 208, 210, 8, 443, 211, 10, 528, 14, 16, 1207, 188, 215, 19, 507, 515, 219, 433, 221, 223, 189, 226, 202, 227, 231, 553, 35, 38, 40, 233, 234 ],
  ),
  "luggage": SymbolsMetadata(
    popularity: 1949,
    codepoint: 0xf235,
    categories: [ 16 ],
    tags: [ 2013, 2014, 3719, 4741, 3720, 3723, 5770, 5241, 1942, 2016, 1917, 3489, 2018, 2607, 1581, 3726, 909, 1922, 75, 5824, 32, 4744, 2023, 1842, 1930, 1504, 5829, 1591, 2024, 4343 ],
  ),
  "lunch_dining": SymbolsMetadata(
    popularity: 4001,
    codepoint: 0xea61,
    categories: [ 16 ],
    tags: [ 2136, 3790, 9568, 13056, 3792, 8083, 3799, 4275, 4388, 3800, 13057, 12900, 9572, 1829, 8087, 11079, 4389, 2986, 3803, 13058, 3804, 5154, 788, 12903, 3807, 4978, 13059, 3809, 4283, 4284 ],
  ),
  "lyrics": SymbolsMetadata(
    popularity: 656,
    codepoint: 0xec0b,
    categories: [ 0 ],
    tags: [ 1538, 1129, 471, 6459, 472, 1401, 13060, 473, 474, 6325, 132, 480, 135, 10165, 968, 13061, 485, 2081, 13062, 3394, 1532, 1533, 2163, 3395, 13063, 13064, 2164, 13065, 1156, 493, 494, 6470, 38, 2165, 7334 ],
    rtlAutoMirrored: true,
  ),
  "macro_auto": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf6f2,
    categories: [ 1 ],
    tags: [ 4, 1131, 1132, 2148, 7622, 7623, 9655, 47, 116, 13066, 1201, 545, 2433, 1738, 6816, 6817, 2550, 1204, 196, 53, 126, 2781, 13067, 13068, 1859, 61, 1835, 121, 986 ],
  ),
  "macro_off": SymbolsMetadata(
    popularity: 283,
    codepoint: 0xf8d2,
    categories: [ 1 ],
    tags: [ 7622, 7623, 47, 13069, 13070, 13071, 13072, 545, 1077, 13073, 767, 898, 2433, 1738, 6816, 53, 6820, 13067, 13074, 13075, 1859, 13076, 13077, 13078, 13079, 13080, 907, 908, 909, 8977, 61, 1835, 914, 986 ],
  ),
  "magnification_large": SymbolsMetadata(
    popularity: 35,
    codepoint: 0xf83d,
    categories: [ 2 ],
    tags: [ 7650, 349, 7, 545, 1216, 787, 1738, 274, 1673, 1204, 2396, 3634, 7653, 7716, 973, 974, 975, 2307, 1361, 1068, 75, 190, 77, 2401, 32, 2249, 317, 1054, 986, 2403 ],
  ),
  "magnification_small": SymbolsMetadata(
    popularity: 37,
    codepoint: 0xf83c,
    categories: [ 2 ],
    tags: [ 7, 1269, 1042, 2922, 12, 1738, 274, 53, 7716, 974, 975, 6833, 2068, 2928, 1068, 1770, 119, 75, 2930, 77, 3093, 2933, 1979, 13081, 32, 317, 1054, 986, 2404 ],
  ),
  "magnify_docked": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf7d6,
    categories: [ 4 ],
    tags: [ 192, 526, 13036, 545, 12, 2522, 13082, 1216, 787, 958, 960, 1738, 1673, 964, 1204, 1207, 4294, 971, 7716, 973, 974, 2307, 763, 1068, 1770, 202, 2400, 2401, 330, 980, 317, 1054, 986 ],
  ),
  "magnify_fullscreen": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf7d5,
    categories: [ 4 ],
    tags: [ 192, 526, 1202, 12, 2522, 1216, 13083, 6439, 787, 2393, 13084, 1673, 1204, 1207, 7716, 2397, 2307, 763, 202, 5592, 75, 77, 2281, 2401, 330, 317, 1054, 2402, 986, 2403 ],
  ),
  "mail": SymbolsMetadata(
    popularity: 65826,
    codepoint: 0xe158,
    categories: [ 7 ],
    tags: [ 443, 693, 475, 6935, 2331, 2335, 3286, 10646, 777, 851, 4704, 19, 366, 2340, 13085, 485, 6052, 1408, 486, 1361, 2342, 75, 1410, 2343, 32, 2664 ],
  ),
  "mail_lock": SymbolsMetadata(
    popularity: 746,
    codepoint: 0xec0a,
    categories: [ 7 ],
    tags: [ 13086, 3242, 2335, 13087, 13088, 13089, 6526, 3286, 19, 2674, 5714, 13090, 2340, 13091, 13092, 13093, 485, 13094, 13095, 6530, 5715, 1516, 13096, 1517, 13097, 1520, 602, 1773, 13098, 13099, 1011, 2343 ],
  ),
  "mail_off": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf48b,
    categories: [ 7 ],
    tags: [ 1074, 894, 13100, 896, 1076, 1077, 767, 2335, 13101, 898, 3286, 4443, 5452, 13102, 19, 2340, 13103, 485, 6748, 1164, 1165, 13104, 13105, 13106, 8312, 2122, 907, 908, 909, 2343, 9780, 1170, 11372, 914, 11133, 13107 ],
  ),
  "male": SymbolsMetadata(
    popularity: 1981,
    codepoint: 0xe58e,
    categories: [ 3 ],
    tags: [ 468, 380, 470, 2412, 4933, 13108, 383, 9398, 1791, 13109, 483, 16, 390, 1803, 13110, 4938, 13111, 13112, 9537, 13113, 489, 490, 3610, 9615, 607, 35, 501, 3613 ],
  ),
  "man": SymbolsMetadata(
    popularity: 2496,
    codepoint: 0xe4eb,
    categories: [ 3 ],
    tags: [ 468, 13114, 470, 4932, 4933, 4934, 4408, 1791, 13115, 483, 13116, 16, 885, 1803, 4937, 4938, 489, 3172, 1967, 490, 4939, 13117, 13118, 607, 4940, 750, 35, 501, 4941 ],
  ),
  "man_2": SymbolsMetadata(
    popularity: 444,
    codepoint: 0xf8e1,
    categories: [ 3 ],
    tags: [ 468, 13114, 470, 83, 4933, 475, 6993, 4408, 1791, 13109, 483, 13116, 16, 885, 1803, 4938, 13119, 853, 488, 489, 3172, 1967, 490, 4939, 105, 607, 4940, 750, 35, 501, 4941 ],
  ),
  "man_3": SymbolsMetadata(
    popularity: 250,
    codepoint: 0xf8e2,
    categories: [ 3 ],
    tags: [ 3325, 468, 470, 4933, 475, 1416, 4408, 1791, 13109, 1659, 13120, 1190, 483, 2540, 16, 885, 1803, 4938, 13121, 853, 489, 490, 105, 607, 32, 4940, 35, 501, 860 ],
  ),
  "man_4": SymbolsMetadata(
    popularity: 376,
    codepoint: 0xf8e3,
    categories: [ 3 ],
    tags: [ 3325, 468, 13114, 470, 83, 4933, 475, 6993, 4825, 3166, 4408, 1791, 9396, 483, 13116, 16, 885, 13122, 1803, 4938, 13119, 853, 13123, 488, 489, 3172, 1967, 490, 4939, 6201, 105, 607, 4940, 35, 1992, 501, 4941 ],
  ),
  "manage_accounts": SymbolsMetadata(
    popularity: 16057,
    codepoint: 0xf02e,
    categories: [ 6 ],
    tags: [ 468, 13124, 845, 1126, 1507, 1747, 1508, 1731, 4175, 268, 269, 132, 13125, 479, 3485, 483, 1755, 13126, 1740, 656, 488, 489, 13127, 13128, 490, 855, 2631, 65, 501, 890, 11955, 1774 ],
  ),
  "manage_history": SymbolsMetadata(
    popularity: 2376,
    codepoint: 0xebe7,
    categories: [ 6 ],
    tags: [ 989, 1128, 1747, 1230, 380, 2489, 3035, 1731, 383, 384, 1016, 268, 269, 1017, 132, 696, 5133, 3485, 1023, 5126, 2770, 1755, 1740, 656, 2841, 1029, 5136, 2492, 424, 2494, 3749, 2881, 2496, 396, 1031, 65, 289, 290, 402, 2499, 1260 ],
  ),
  "manage_search": SymbolsMetadata(
    popularity: 8102,
    codepoint: 0xf02f,
    categories: [ 2 ],
    tags: [ 1367, 268, 269, 1735, 955, 696, 958, 959, 960, 964, 1023, 4294, 92, 13129, 975, 976, 1755, 13130, 788, 1740, 656, 96, 98, 329, 2493, 980, 13131, 65, 106, 38, 441, 317 ],
    rtlAutoMirrored: true,
  ),
  "manga": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xf5e3,
    categories: [ 3 ],
    tags: [ 469, 264, 6710, 5098, 13132, 13133, 6711, 6712, 6714, 6715, 11448, 13134, 4664, 13135, 2766, 13136, 6189, 13137, 6716, 3462, 6718, 1534, 1770, 2772, 2507, 7639, 13138, 13139, 494, 1378, 11891, 13140, 1261, 9161 ],
  ),
  "manufacturing": SymbolsMetadata(
    popularity: 900,
    codepoint: 0xe726,
    categories: [ 6 ],
    tags: [ 7054, 9479, 2148, 4862, 13141, 4175, 6806, 4176, 268, 2832, 1201, 2625, 4613, 2835, 2523, 9480, 7114, 3487, 6923, 6924, 1717, 1834, 6925, 7117, 2837, 4179, 13142, 977, 656, 1835, 942, 6296, 13143, 3474, 65, 2537 ],
  ),
  "map": SymbolsMetadata(
    popularity: 13089,
    codepoint: 0xe55b,
    categories: [ 5 ],
    tags: [ 2464, 9735, 13144, 9736, 920, 1484, 388, 1578, 1347, 958, 13145, 13146, 1488, 3226, 135, 1581, 13147, 1001, 1002, 1490, 421, 13148, 3421, 13149, 1493, 1495, 2838, 1503, 1083, 13150, 2023, 1504, 1591, 3229 ],
  ),
  "map_search": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf3ca,
    categories: [ 5 ],
    tags: [ 9735, 9736, 1484, 388, 1578, 955, 958, 13151, 959, 960, 12947, 13152, 964, 1488, 1581, 1001, 13153, 971, 973, 974, 975, 976, 1002, 8516, 13154, 1490, 21, 421, 1493, 1495, 1496, 1503, 13155, 980, 13156, 981, 1083, 1504 ],
  ),
  "maps_ugc": SymbolsMetadata(
    popularity: 1949,
    codepoint: 0xef58,
    categories: [ 5 ],
    tags: [ 192, 526, 471, 472, 383, 473, 474, 1540, 1201, 1202, 696, 480, 966, 1001, 1002, 1490, 21, 485, 763, 1493, 1495, 202, 1363, 1409, 1665, 493, 494, 1412, 8987, 35, 13157, 346, 7342 ],
  ),
  "margin": SymbolsMetadata(
    popularity: 234,
    codepoint: 0xe9bb,
    categories: [ 12 ],
    tags: [ 1128, 2169, 349, 994, 7, 953, 299, 1347, 956, 236, 2628, 1372, 274, 246, 10492, 4835, 4836, 306, 4837, 12737, 2263, 1534, 2180, 2247, 7207, 673, 2248, 32, 38 ],
  ),
  "mark_as_unread": SymbolsMetadata(
    popularity: 1108,
    codepoint: 0xe9bc,
    categories: [ 7 ],
    tags: [ 2151, 13158, 443, 2331, 2335, 3286, 4720, 1251, 851, 4704, 19, 2340, 1641, 13159, 13160, 485, 6052, 13161, 1408, 486, 1409, 4921, 4758, 2506, 2342, 13162, 2496, 2343, 13163, 13164, 4791, 13165, 2664 ],
  ),
  "mark_chat_read": SymbolsMetadata(
    popularity: 714,
    codepoint: 0xf18b,
    categories: [ 7 ],
    tags: [ 3350, 1549, 1400, 471, 472, 1630, 1632, 473, 474, 443, 1633, 2481, 476, 477, 10617, 1639, 480, 3065, 481, 1641, 13166, 485, 486, 1643, 2506, 13167, 1410, 1565, 13025, 288, 2343, 10629, 493, 1412, 496, 1647, 1523, 11599, 1650 ],
  ),
  "mark_chat_unread": SymbolsMetadata(
    popularity: 1606,
    codepoint: 0xf189,
    categories: [ 7 ],
    tags: [ 1244, 469, 471, 472, 1401, 383, 473, 474, 475, 476, 5255, 13168, 10617, 13169, 832, 480, 481, 851, 1641, 485, 6052, 1408, 486, 1120, 1254, 1030, 493, 495, 496, 38, 5460, 2664 ],
  ),
  "mark_email_read": SymbolsMetadata(
    popularity: 2509,
    codepoint: 0xf18c,
    categories: [ 7 ],
    tags: [ 1627, 2716, 949, 2717, 1549, 1630, 1632, 443, 1633, 1635, 1636, 4269, 2376, 1639, 2335, 3286, 10646, 851, 4704, 19, 2340, 1641, 485, 1532, 486, 1643, 2506, 288, 2343, 10629, 553, 1412, 6083, 2487, 1647, 6088, 2385, 2386, 2387, 1523, 1650 ],
  ),
  "mark_email_unread": SymbolsMetadata(
    popularity: 2943,
    codepoint: 0xf18a,
    categories: [ 7 ],
    tags: [ 469, 1630, 383, 443, 475, 2331, 832, 2335, 3286, 10646, 16, 1251, 851, 188, 4704, 19, 2340, 1641, 13160, 485, 1408, 1532, 486, 2661, 4921, 2506, 2342, 1030, 2343, 553, 35, 2664, 1260 ],
  ),
  "mark_unread_chat_alt": SymbolsMetadata(
    popularity: 1338,
    codepoint: 0xeb9d,
    categories: [ 7 ],
    tags: [ 989, 1244, 469, 471, 472, 383, 473, 474, 443, 476, 477, 832, 480, 481, 1251, 851, 366, 1641, 485, 1408, 2503, 486, 1120, 1254, 4758, 1029, 1030, 493, 494, 38, 2664, 4308 ],
  ),
  "markdown": SymbolsMetadata(
    popularity: 16,
    codepoint: 0xf552,
    categories: [ 12 ],
    tags: [ 5656, 4, 380, 2650, 7, 8, 2624, 6580, 1042, 1347, 337, 1530, 14, 2652, 1542, 966, 1044, 13170, 19, 3513, 13171, 10482, 8815, 13172, 5660, 3001, 2342, 2844, 78, 1664, 32, 35, 6591, 38, 2229, 2007, 40 ],
  ),
  "markdown_copy": SymbolsMetadata(
    popularity: 13,
    codepoint: 0xf553,
    categories: [ 12 ],
    tags: [ 4, 1400, 3751, 2539, 2779, 8, 3753, 2624, 6580, 1042, 3456, 1707, 13173, 1062, 5807, 1528, 1347, 2999, 1371, 1530, 14, 5206, 13170, 19, 2528, 13171, 10482, 8815, 13172, 2557, 1534, 6073, 1409, 2504, 5482, 1665, 32, 35, 6591, 38, 2229, 40, 704 ],
  ),
  "markdown_paste": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf554,
    categories: [ 12 ],
    tags: [ 4, 8, 1631, 1750, 2624, 6580, 693, 1042, 1707, 1201, 5807, 7020, 1528, 1347, 696, 1530, 14, 1598, 135, 966, 19, 92, 10482, 8815, 13172, 2557, 8779, 1533, 1456, 8030, 6073, 75, 1353, 3296, 1570, 35, 6591, 1646, 3159, 38, 2229, 441, 40, 704 ],
  ),
  "markunread_mailbox": SymbolsMetadata(
    popularity: 808,
    codepoint: 0xe89b,
    categories: [ 7 ],
    tags: [ 469, 443, 475, 2331, 7762, 2335, 3286, 4720, 10021, 1251, 851, 135, 4704, 19, 2340, 12921, 13159, 13160, 13174, 485, 1408, 486, 1409, 12922, 4921, 13175, 4758, 13176, 2342, 75, 1030, 2343, 32, 2664 ],
  ),
  "masked_transitions": SymbolsMetadata(
    popularity: 95,
    codepoint: 0xe72e,
    categories: [ 1 ],
    tags: [ 264, 4383, 13177, 383, 953, 13178, 696, 2299, 2567, 13179, 270, 959, 9820, 3145, 6703, 13180, 13181, 13182, 6704, 13183, 13184, 420, 278, 423, 6313, 4915, 2559, 1081, 2400, 104, 65, 2562, 5081, 13185, 107, 427, 13186, 2571, 13187, 41, 364 ],
  ),
  "masked_transitions_add": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf42b,
    categories: [ 1 ],
    tags: [ 192, 526, 13188, 13189, 264, 4383, 383, 953, 1061, 13178, 1201, 13190, 696, 2299, 2567, 13179, 270, 959, 4964, 13191, 1066, 6703, 13180, 13182, 1067, 420, 278, 763, 1211, 13192, 2559, 1081, 202, 104, 65, 107, 35, 2571, 13187, 41, 364 ],
  ),
  "masks": SymbolsMetadata(
    popularity: 1597,
    codepoint: 0xf218,
    categories: [ 3 ],
    tags: [ 707, 13193, 585, 4365, 586, 587, 1751, 479, 13194, 13195, 13196, 595, 1753, 1754, 3972, 2416, 6336, 6703, 6704, 1757, 13197, 1761, 598, 1762, 13198, 2785, 13199, 599, 1520, 13200, 2436, 602, 7186, 2426, 607, 13201, 5193 ],
  ),
  "match_case": SymbolsMetadata(
    popularity: 86,
    codepoint: 0xf6f1,
    categories: [ 12 ],
    tags: [ 685, 13202, 4, 13203, 4950, 5241, 8, 696, 2299, 14, 10473, 13204, 1372, 2175, 4704, 19, 13205, 12176, 4956, 2247, 2281, 1979, 2182, 35, 38, 7476, 13050, 13051, 40, 4961, 702, 13206, 2789 ],
  ),
  "match_case_off": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf36f,
    categories: [ 12 ],
    tags: [ 685, 13202, 4, 895, 13207, 13208, 13209, 13210, 8, 1077, 13211, 767, 898, 9796, 14, 13212, 19, 12176, 13213, 13214, 13215, 907, 908, 909, 13131, 914, 12759, 2126, 35, 38, 13216, 13050, 13051, 13217, 40, 702, 2789 ],
  ),
  "match_word": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf6f0,
    categories: [ 12 ],
    tags: [ 685, 4, 2513, 5, 689, 2311, 8, 692, 1630, 3812, 3813, 5333, 696, 2299, 960, 14, 19, 2379, 13218, 13219, 3184, 980, 6791, 35, 38, 40, 702, 2498, 4823, 2389 ],
  ),
  "matter": SymbolsMetadata(
    popularity: 473,
    codepoint: 0xe907,
    categories: [ 8 ],
    tags: [ 3325, 419, 4477, 1730, 3085, 3281, 1061, 921, 211, 3087, 13220, 445, 2173, 2840, 926, 930, 3236, 4867, 1064, 935, 13221, 1067, 2179, 223, 4483, 942, 1665, 945, 35, 946, 374, 1701, 8265, 1677, 234 ],
  ),
  "maximize": SymbolsMetadata(
    popularity: 1910,
    codepoint: 0xe930,
    categories: [ 2 ],
    tags: [ 1229, 1230, 8584, 1343, 2750, 269, 299, 12, 1216, 787, 2393, 2395, 1673, 1204, 1205, 2396, 2751, 1602, 2397, 2307, 5592, 75, 2247, 2281, 2401, 330, 311, 10873, 2882, 2249, 13222, 13223, 2757, 13224, 2759, 317, 1691, 1053, 1054, 8350, 986, 2403 ],
  ),
  "measuring_tape": SymbolsMetadata(
    popularity: 11,
    codepoint: 0xf6af,
    categories: [ 6 ],
    tags: [ 1725, 584, 383, 384, 2832, 2332, 3326, 13225, 588, 5809, 2996, 13226, 2927, 2470, 5813, 3009, 1602, 366, 597, 634, 13227, 5962, 13228, 5540, 13229, 7788, 13230, 673, 13231, 13232, 2537, 2756, 3014 ],
  ),
  "media_bluetooth_off": SymbolsMetadata(
    popularity: 138,
    codepoint: 0xf031,
    categories: [ 4 ],
    tags: [ 1129, 11359, 4477, 2035, 383, 921, 211, 4499, 212, 445, 1077, 767, 898, 367, 13233, 13234, 2081, 13235, 1164, 1165, 1166, 4503, 13236, 1169, 1532, 907, 908, 909, 4483, 227, 1170, 11372, 914, 1156, 8318, 35, 1701, 234, 2050 ],
  ),
  "media_bluetooth_on": SymbolsMetadata(
    popularity: 240,
    codepoint: 0xf032,
    categories: [ 4 ],
    tags: [ 1129, 4477, 355, 13237, 921, 211, 212, 445, 767, 8641, 898, 8648, 8631, 8632, 1143, 367, 2081, 1532, 907, 909, 819, 1719, 4480, 4481, 4483, 2162, 1665, 227, 914, 1156, 1157, 3411, 2057, 342, 35, 551, 234 ],
  ),
  "media_link": SymbolsMetadata(
    popularity: 67,
    codepoint: 0xf83f,
    categories: [ 0 ],
    tags: [ 1058, 1466, 1467, 1061, 13238, 211, 2970, 1066, 935, 1000, 367, 13239, 13240, 13241, 13242, 1067, 1081, 3289, 2162, 13243, 13244, 4787, 2562, 32, 107, 9210, 41, 13245, 13246, 291 ],
  ),
  "media_output": SymbolsMetadata(
    popularity: 39,
    codepoint: 0xf4f2,
    categories: [ 11 ],
    tags: [ 2587, 2051, 2827, 1129, 8645, 10943, 7, 2053, 13247, 921, 445, 8629, 8641, 3216, 13248, 8250, 4490, 8632, 1143, 4672, 367, 13249, 13250, 2081, 1719, 13251, 75, 3331, 13252, 1156, 1157, 32, 3411, 2057, 342, 2632, 41 ],
  ),
  "media_output_off": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf4f3,
    categories: [ 11 ],
    tags: [ 2587, 1129, 1074, 7, 895, 2053, 445, 2969, 767, 3306, 12, 8629, 8641, 3216, 898, 2628, 899, 4490, 8632, 1602, 1143, 4672, 367, 327, 2081, 1164, 4152, 907, 908, 909, 1719, 5868, 330, 5870, 1665, 1170, 914, 1156, 1157, 3411, 1083, 342, 2632, 343, 344, 41 ],
  ),
  "mediation": SymbolsMetadata(
    popularity: 776,
    codepoint: 0xefa7,
    categories: [ 9 ],
    tags: [ 13253, 380, 419, 13254, 3281, 13255, 1061, 13256, 921, 3087, 3088, 388, 2210, 956, 926, 777, 930, 4867, 1064, 13257, 1145, 1067, 2557, 223, 1586, 30, 1396, 2343, 6807, 374, 2007, 5086, 5949 ],
  ),
  "medical_information": SymbolsMetadata(
    popularity: 2481,
    codepoint: 0xebed,
    categories: [ 3 ],
    tags: [ 755, 6, 799, 1749, 1202, 132, 1751, 2482, 4472, 595, 1753, 2080, 1754, 3167, 3168, 2809, 484, 135, 1757, 13258, 13259, 13260, 1758, 1761, 1762, 202, 490, 121, 75, 2755 ],
  ),
  "medical_mask": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf80a,
    categories: [ 3 ],
    tags: [ 585, 586, 587, 2414, 13261, 13194, 13195, 13196, 595, 1753, 1754, 3972, 2416, 6336, 7181, 6703, 6704, 1757, 13197, 598, 13198, 13199, 599, 1520, 13262, 602, 2426, 6909, 13201, 441, 5193 ],
  ),
  "medical_services": SymbolsMetadata(
    popularity: 3375,
    codepoint: 0xf109,
    categories: [ 5 ],
    tags: [ 736, 3719, 5238, 1749, 1202, 1751, 2482, 8933, 90, 4472, 595, 13263, 1753, 13264, 1754, 11703, 1757, 13265, 13266, 13267, 13268, 13269, 11414, 1760, 202, 2755, 495, 2428 ],
  ),
  "medication": SymbolsMetadata(
    popularity: 2744,
    codepoint: 0xf033,
    categories: [ 3 ],
    tags: [ 1869, 13270, 1749, 1269, 1202, 11378, 1751, 5630, 1752, 2482, 4472, 595, 1753, 1754, 13271, 7157, 1757, 1759, 1760, 13272, 1763, 13273, 13274, 202, 1765, 75, 32, 2428, 1905 ],
  ),
  "medication_liquid": SymbolsMetadata(
    popularity: 1067,
    codepoint: 0xea87,
    categories: [ 3 ],
    tags: [ 192, 1869, 1269, 13275, 1202, 1751, 13276, 10176, 5630, 4472, 595, 1753, 1754, 2416, 13271, 2798, 13277, 13278, 1757, 1759, 13279, 1760, 13272, 1763, 202, 1765, 11382, 7186, 8091, 13280, 2428, 6368, 1905 ],
  ),
  "meeting_room": SymbolsMetadata(
    popularity: 3274,
    codepoint: 0xeb4f,
    categories: [ 9 ],
    tags: [ 755, 1015, 3063, 13281, 13282, 798, 1135, 13283, 2604, 6103, 2909, 6104, 1597, 6278, 930, 999, 1435, 13284, 2796, 1064, 1145, 13285, 13286, 1456, 2653, 13287, 2613, 1924, 13288, 1960, 1031, 946, 12946, 3508 ],
  ),
  "memory": SymbolsMetadata(
    popularity: 3541,
    codepoint: 0xe322,
    categories: [ 11 ],
    tags: [ 799, 5250, 7892, 694, 6838, 13289, 10, 445, 88, 13290, 1711, 7721, 965, 135, 13291, 5291, 13292, 13293, 7895, 13294, 3949, 7899, 13295, 13296, 13297, 13298, 32, 674, 8644, 551, 441 ],
  ),
  "memory_alt": SymbolsMetadata(
    popularity: 58,
    codepoint: 0xf7a3,
    categories: [ 11 ],
    tags: [ 2442, 6182, 799, 5250, 7892, 4864, 694, 13299, 10, 445, 88, 13290, 1711, 965, 5291, 13300, 13292, 13301, 13293, 4868, 7897, 3949, 7899, 13295, 75, 13296, 13297, 3761, 32, 674, 551, 441 ],
  ),
  "menstrual_health": SymbolsMetadata(
    popularity: 77,
    codepoint: 0xf6e1,
    categories: [ 15 ],
    tags: [ 3325, 13302, 4463, 7622, 7623, 5341, 385, 13303, 1500, 1790, 9613, 13304, 11169, 2926, 2433, 595, 13305, 11900, 9215, 9661, 7618, 13306, 8977, 5010, 11182, 947, 7641, 11183, 8244, 1905, 13307, 11185 ],
  ),
  "menu": SymbolsMetadata(
    popularity: 137490,
    codepoint: 0xe5d2,
    categories: [ 2 ],
    tags: [ 1229, 1230, 13308, 365, 2896, 2750, 269, 2983, 2941, 787, 2986, 900, 2080, 2751, 7662, 1066, 1602, 366, 92, 788, 6328, 789, 421, 656, 2295, 4978, 330, 65, 2997, 2882, 6386, 2586, 441, 314, 2757, 2759, 1691, 1053, 7664 ],
  ),
  "menu_book": SymbolsMetadata(
    popularity: 14591,
    codepoint: 0xea19,
    categories: [ 12 ],
    tags: [ 1910, 7917, 3455, 266, 10232, 3799, 1347, 3153, 1829, 3226, 91, 135, 4686, 4695, 3375, 2159, 92, 3462, 7921, 3804, 788, 3463, 656, 13148, 4699, 2506, 2507, 3807, 371, 4689, 4700, 4691 ],
    rtlAutoMirrored: true,
  ),
  "menu_open": SymbolsMetadata(
    popularity: 9447,
    codepoint: 0xe9bd,
    categories: [ 2 ],
    tags: [ 1229, 1230, 380, 2489, 2869, 2862, 2950, 13309, 2896, 2982, 2750, 2983, 13310, 787, 2986, 6327, 900, 2987, 2080, 2751, 1375, 2875, 12283, 1602, 366, 92, 788, 13311, 421, 2653, 656, 330, 65, 2993, 2882, 441, 2757, 2759, 1691, 1053 ],
    rtlAutoMirrored: true,
  ),
  "merge": SymbolsMetadata(
    popularity: 843,
    codepoint: 0xeb98,
    categories: [ 11 ],
    tags: [ 380, 2445, 419, 9479, 3026, 13312, 13313, 1061, 13314, 13315, 13256, 921, 3087, 3088, 13316, 388, 1578, 13317, 13318, 2629, 1064, 13319, 1490, 1067, 421, 1586, 1503, 7494, 13320, 6807, 441, 1590, 13321, 5949, 1677, 346, 6010 ],
  ),
  "merge_type": SymbolsMetadata(
    popularity: 463,
    codepoint: 0xe252,
    categories: [ 12 ],
    tags: [ 3325, 13322, 2890, 380, 2862, 1061, 3087, 269, 13220, 388, 1372, 1659, 8996, 16, 4867, 1064, 366, 1067, 13323, 2958, 421, 8725, 35, 38, 441, 40, 5949, 1677, 346 ],
    rtlAutoMirrored: true,
  ),
  "metabolism": SymbolsMetadata(
    popularity: 22,
    codepoint: 0xe10b,
    categories: [ 3 ],
    tags: [ 989, 2284, 380, 419, 2412, 584, 5597, 1731, 384, 7106, 385, 2922, 10776, 2651, 3779, 963, 595, 483, 3524, 9236, 3513, 3525, 2315, 9063, 489, 942, 286, 2930, 2494, 396, 229, 427, 402, 3831, 1905 ],
  ),
  "metro": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf474,
    categories: [ 14 ],
    tags: [ 13324, 4, 2602, 13325, 13326, 2063, 5228, 13327, 4704, 13170, 13328, 7745, 13329, 8161, 2071, 4601, 5230, 4619, 13330, 10340, 4621, 13331, 4622, 2008, 13332, 5235, 1930, 1504, 8162, 8148, 8163, 13333, 2621, 8903 ],
  ),
  "mfg_nest_yale_lock": SymbolsMetadata(
    popularity: 278,
    codepoint: 0xf11d,
    categories: [ 10 ],
    tags: [ 755, 2148, 952, 383, 2624, 269, 445, 13334, 956, 13335, 1597, 1189, 246, 965, 5512, 5713, 970, 2674, 13336, 1004, 8029, 13337, 5185, 13338, 5715, 13339, 13340, 5716, 1011, 13341, 5717, 13342 ],
  ),
  "mic": SymbolsMetadata(
    popularity: 12881,
    codepoint: 0xe029,
    categories: [ 0 ],
    tags: [ 1129, 8645, 8646, 1136, 1139, 1140, 966, 10165, 969, 13343, 1143, 1146, 13344, 13345, 1147, 13346, 1164, 1148, 1152, 121, 1154, 177, 13063, 1156, 3399, 1157, 493, 13347, 496, 8300, 1161, 13348, 3222, 10166, 10670, 13349 ],
  ),
  "mic_alert": SymbolsMetadata(
    popularity: 17,
    codepoint: 0xf392,
    categories: [ 0 ],
    tags: [ 3175, 469, 3073, 1129, 13350, 13351, 1693, 3176, 445, 1136, 767, 2766, 2767, 1139, 1140, 2471, 1251, 966, 13352, 969, 1641, 1146, 13353, 1147, 13354, 13355, 1164, 1166, 1169, 1148, 486, 2772, 121, 1154, 177, 13356, 1156, 13357, 13358, 1157, 493, 13359, 35, 8300, 1161, 13360, 13361, 1261 ],
  ),
  "mic_double": SymbolsMetadata(
    popularity: 42,
    codepoint: 0xf5d1,
    categories: [ 0 ],
    tags: [ 1129, 10667, 1133, 116, 1135, 476, 1136, 3108, 13362, 13363, 13364, 1139, 1140, 966, 1142, 10165, 969, 1143, 1145, 1146, 1147, 1148, 3000, 1152, 121, 1154, 177, 1156, 3399, 492, 1157, 3411, 496, 13365, 1161 ],
  ),
  "mic_external_off": SymbolsMetadata(
    popularity: 150,
    codepoint: 0xef59,
    categories: [ 1 ],
    tags: [ 1129, 1074, 894, 895, 1075, 1077, 767, 898, 2628, 13366, 13367, 966, 1146, 1147, 1164, 1165, 1166, 1167, 1168, 13368, 1169, 907, 909, 121, 177, 1170, 1171, 914, 1156, 493, 1161 ],
  ),
  "mic_external_on": SymbolsMetadata(
    popularity: 814,
    codepoint: 0xef5a,
    categories: [ 1 ],
    tags: [ 1242, 1129, 4362, 443, 922, 445, 767, 898, 2628, 13248, 8249, 13366, 13367, 4490, 8632, 966, 10165, 1143, 1146, 1147, 907, 909, 4372, 4139, 177, 13063, 914, 1156, 493, 496, 1161, 4378, 13369 ],
  ),
  "mic_off": SymbolsMetadata(
    popularity: 2340,
    codepoint: 0xe02b,
    categories: [ 0 ],
    tags: [ 1129, 8658, 1074, 1133, 895, 443, 1135, 767, 898, 899, 1139, 1140, 966, 6466, 1146, 13345, 1147, 13346, 1164, 1166, 1169, 1148, 907, 909, 2123, 121, 177, 1170, 914, 1156, 493, 8300, 1161 ],
  ),
  "microbiology": SymbolsMetadata(
    popularity: 40,
    codepoint: 0xe10c,
    categories: [ 3 ],
    tags: [ 13370, 2410, 6331, 13371, 10818, 2412, 584, 1113, 13372, 2414, 13373, 6333, 595, 1753, 483, 2417, 2418, 6336, 12029, 4474, 9278, 5789, 1757, 13374, 7182, 13375, 4354, 13376, 4355, 13377, 10829, 7184, 13378, 4359, 2424, 9280, 2426, 13379, 5193, 12030 ],
  ),
  "microwave": SymbolsMetadata(
    popularity: 567,
    codepoint: 0xf204,
    categories: [ 8 ],
    tags: [ 1888, 952, 785, 3795, 13380, 4386, 1736, 4078, 1711, 12900, 1829, 3076, 999, 1895, 1435, 3802, 8239, 1717, 4279, 13381, 13382, 3805, 13383, 12076, 13384, 190, 227, 32, 1033, 3978, 1902, 4654 ],
  ),
  "microwave_gen": SymbolsMetadata(
    popularity: 392,
    codepoint: 0xe847,
    categories: [ 8 ],
    tags: [ 1888, 952, 953, 785, 3795, 4386, 1736, 956, 4078, 3216, 1022, 1829, 3076, 999, 3078, 1435, 1436, 3802, 1717, 3804, 13381, 1004, 13385, 3805, 1027, 75, 13384, 77, 32, 983, 1033, 3978 ],
  ),
  "military_tech": SymbolsMetadata(
    popularity: 5071,
    codepoint: 0xea3f,
    categories: [ 3 ],
    tags: [ 3573, 3, 13386, 13387, 13388, 3574, 6, 365, 13389, 2862, 5978, 13390, 13391, 13392, 12684, 13393, 10614, 13394, 96, 13395, 3581, 101, 3583, 3584, 2368, 2631, 13396, 3264, 553, 2586, 8644, 551, 6196, 13397, 13398, 13399, 8825, 3589 ],
  ),
  "mimo": SymbolsMetadata(
    popularity: 54,
    codepoint: 0xe9be,
    categories: [ 11 ],
    tags: [ 455, 1230, 47, 1684, 694, 1685, 445, 88, 767, 12, 1711, 898, 1189, 13400, 965, 5273, 215, 1144, 1146, 13401, 327, 278, 907, 909, 819, 6839, 2400, 2648, 330, 914, 2562, 1196, 1157, 2057, 551, 343, 8035, 344, 41, 317, 2102, 1053, 1054 ],
  ),
  "mimo_disconnect": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xe9bf,
    categories: [ 11 ],
    tags: [ 455, 1074, 47, 895, 1684, 2950, 694, 4563, 1076, 897, 445, 1077, 767, 3306, 12, 898, 2189, 2985, 899, 1189, 13400, 965, 5273, 902, 1144, 1146, 13401, 327, 13402, 13403, 13404, 13405, 907, 908, 909, 6602, 911, 330, 13406, 913, 914, 1157, 1083, 8035, 915 ],
  ),
  "mindfulness": SymbolsMetadata(
    popularity: 180,
    codepoint: 0xf6e0,
    categories: [ 15 ],
    tags: [ 3073, 4943, 365, 6629, 13407, 11860, 4262, 6647, 2926, 1738, 1190, 13408, 13409, 8075, 6635, 8077, 10226, 13410, 6108, 490, 6638, 2123, 1958, 1959, 8079, 2074, 227, 9115, 6641, 6642, 4646, 1905 ],
  ),
  "minimize": SymbolsMetadata(
    popularity: 4154,
    codepoint: 0xe931,
    categories: [ 2 ],
    tags: [ 1229, 1230, 1343, 2896, 6653, 2750, 3086, 6247, 2448, 299, 2522, 900, 1205, 2751, 1602, 2928, 2648, 75, 2930, 13411, 330, 311, 2933, 2882, 1979, 7649, 13412, 8343, 2344, 2757, 10138, 2759, 1691, 1053, 1054, 13413, 8350 ],
  ),
  "minor_crash": SymbolsMetadata(
    popularity: 776,
    codepoint: 0xebf1,
    categories: [ 5 ],
    tags: [ 3466, 469, 1131, 1814, 3467, 1815, 1816, 1693, 5667, 2765, 4664, 3176, 1578, 2482, 13414, 4647, 5223, 1490, 873, 13415, 486, 2772, 2071, 1587, 602, 1011, 13416, 1590, 1930, 1844, 1261, 13417 ],
  ),
  "mintmark": SymbolsMetadata(
    popularity: 47,
    codepoint: 0xefa9,
    categories: [ 9 ],
    tags: [ 380, 419, 797, 1325, 799, 800, 13418, 1652, 801, 803, 1327, 805, 806, 4439, 2922, 11458, 3274, 2937, 2969, 388, 5751, 3315, 807, 2651, 1500, 9496, 808, 1189, 6248, 2315, 13419, 818, 819, 820, 821, 1337, 2930, 2343, 2631, 3999, 1122, 35, 2007, 3279 ],
  ),
  "missed_video_call": SymbolsMetadata(
    popularity: 206,
    codepoint: 0xe073,
    categories: [ 0 ],
    tags: [ 380, 1133, 5424, 47, 1630, 1632, 443, 4439, 5456, 13420, 13421, 270, 5509, 965, 1023, 53, 126, 3179, 5453, 13422, 13423, 420, 226, 119, 121, 177, 75, 4450, 5459, 13424, 13425, 32, 1320, 915, 13426, 41, 1160, 5519, 540, 13427, 5521 ],
    rtlAutoMirrored: true,
  ),
  "missing_controller": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xe701,
    categories: [ 11 ],
    tags: [ 2587, 2148, 4477, 268, 921, 211, 269, 5258, 445, 3306, 1711, 960, 12073, 1489, 13428, 6127, 4100, 4481, 5716, 77, 980, 65, 227, 2084, 1901, 551, 6917, 1902, 233, 234 ],
  ),
  "mist": SymbolsMetadata(
    popularity: 30,
    codepoint: 0xe188,
    categories: [ 3 ],
    tags: [ 707, 1847, 4580, 953, 712, 1652, 10215, 5721, 956, 7993, 2432, 5723, 6392, 7661, 10219, 2080, 1904, 366, 10220, 1857, 1877, 13429, 11535, 6484, 10659, 3635, 13430, 5266, 727, 317, 7998, 731 ],
  ),
  "mitre": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf547,
    categories: [ 9 ],
    tags: [ 6421, 5, 378, 13431, 918, 4862, 5805, 1467, 920, 2750, 921, 211, 2832, 1062, 13432, 10, 924, 5920, 926, 3419, 1659, 929, 7344, 933, 1064, 9630, 935, 597, 937, 13433, 11060, 3635, 1519, 1520, 2258, 2367, 3046, 13434, 1011, 311, 944, 33, 945, 947, 5820 ],
  ),
  "mixture_med": SymbolsMetadata(
    popularity: 15,
    codepoint: 0xe4c8,
    categories: [ 3 ],
    tags: [ 13435, 11376, 11377, 13436, 1748, 13255, 2330, 11378, 10176, 5630, 1752, 595, 1753, 2417, 13437, 10177, 1757, 1759, 1760, 13438, 13439, 3562, 1763, 1764, 1765, 11382, 13440, 6329, 10178, 447, 2428, 10180, 13441 ],
  ),
  "mms": SymbolsMetadata(
    popularity: 407,
    codepoint: 0xe618,
    categories: [ 7 ],
    tags: [ 471, 472, 473, 474, 443, 476, 477, 480, 53, 13442, 1543, 367, 485, 13443, 219, 1544, 1545, 328, 13444, 2474, 226, 59, 13445, 61, 119, 13446, 75, 77, 2343, 11984, 11985, 1665, 11987, 11988, 1121, 493, 494, 38, 13447, 1701 ],
  ),
  "mobile_hand": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf323,
    categories: [ 11 ],
    tags: [ 1109, 1110, 380, 1133, 2576, 472, 383, 443, 445, 767, 832, 2651, 898, 2735, 5659, 5810, 2738, 3489, 2741, 965, 2139, 10380, 1114, 4895, 219, 1675, 10749, 907, 908, 909, 226, 5736, 2585, 75, 77, 2899, 914, 446, 7229, 13448, 38, 8035 ],
  ),
  "mobile_hand_left": SymbolsMetadata(
    popularity: 1,
    codepoint: 0xf313,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1133, 2576, 472, 383, 443, 269, 445, 767, 832, 898, 2735, 13449, 5810, 2738, 3905, 3489, 2741, 965, 2139, 10380, 1114, 1375, 219, 1675, 10749, 421, 907, 908, 909, 226, 2585, 75, 77, 914, 4787, 446, 7229, 38, 8035 ],
  ),
  "mobile_hand_left_off": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf312,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1133, 13450, 895, 2576, 13451, 472, 445, 4501, 3304, 13452, 13453, 13454, 13455, 13456, 13457, 767, 898, 899, 2738, 13458, 13459, 2741, 965, 1114, 219, 13460, 13461, 13462, 13463, 11241, 13464, 2679, 2680, 13465, 13466, 907, 908, 909, 226, 13467, 13468, 13469, 13470, 13471, 13472, 13473, 914, 446, 13474, 38, 13475 ],
  ),
  "mobile_hand_off": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf314,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1074, 2670, 1133, 895, 2576, 208, 472, 445, 1077, 767, 3306, 898, 2189, 899, 2738, 2739, 2741, 965, 1114, 219, 4152, 13476, 13477, 2679, 2680, 2045, 9777, 907, 908, 909, 226, 912, 171, 227, 914, 446, 1083, 38, 2007 ],
  ),
  "mobile_loupe": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf322,
    categories: [ 11 ],
    tags: [ 192, 1109, 1110, 526, 13478, 1133, 2576, 472, 383, 1201, 13479, 1202, 132, 445, 787, 1738, 964, 965, 1114, 1207, 18, 13480, 8378, 974, 975, 219, 10749, 13481, 763, 13482, 226, 13483, 202, 75, 77, 980, 446, 35, 2384, 13484, 38, 986 ],
  ),
  "mobile_off": SymbolsMetadata(
    popularity: 270,
    codepoint: 0xe201,
    categories: [ 11 ],
    tags: [ 1109, 1110, 2033, 8307, 1074, 895, 1113, 383, 443, 269, 1076, 445, 3304, 767, 3306, 4249, 1711, 898, 2039, 899, 965, 1114, 219, 13485, 1164, 13461, 2679, 2680, 907, 909, 226, 6602, 4448, 75, 171, 65, 1170, 914, 447, 5587 ],
  ),
  "mobile_screen_share": SymbolsMetadata(
    popularity: 353,
    codepoint: 0xe0e7,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1229, 1230, 380, 2053, 1113, 921, 445, 388, 12, 1672, 965, 1114, 5725, 5867, 219, 13486, 13487, 13488, 327, 1719, 226, 3156, 75, 1396, 77, 330, 5873, 5870, 2343, 1665, 6574, 982, 2057, 342, 447, 2007, 344, 234 ],
    rtlAutoMirrored: true,
  ),
  "mobile_screensaver": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf321,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1133, 2576, 472, 383, 1042, 445, 9555, 12, 1541, 965, 1114, 13489, 53, 1543, 13490, 367, 219, 1675, 1544, 1545, 226, 59, 61, 119, 75, 77, 1546, 13491, 13492, 2562, 446, 13493, 38, 1701, 317, 13494 ],
  ),
  "mobile_sound_2": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf318,
    categories: [ 11 ],
    tags: [ 469, 1129, 1133, 208, 443, 1309, 219, 1675, 1164, 486, 226, 13495, 13496, 227, 1171, 1156, 8318, 8636, 3380, 1157, 8300, 8712, 13497, 1745, 13498, 13499, 1902, 234 ],
  ),
  "mobile_speaker": SymbolsMetadata(
    popularity: 0,
    codepoint: 0xf320,
    categories: [ 11 ],
    tags: [ 1109, 1110, 469, 4942, 1129, 355, 1133, 2576, 208, 472, 443, 445, 1309, 965, 1114, 219, 10749, 2081, 1164, 486, 226, 13496, 227, 8317, 446, 1156, 8318, 8636, 1157, 13500, 38, 8300, 1676, 8712, 1745 ],
  ),
  "mobiledata_off": SymbolsMetadata(
    popularity: 422,
    codepoint: 0xf034,
    categories: [ 4 ],
    tags: [ 380, 2650, 2052, 895, 210, 13501, 4497, 4499, 3302, 10, 7578, 3873, 767, 2651, 898, 215, 13502, 6541, 219, 433, 221, 223, 4502, 2041, 2043, 7583, 6543, 2045, 907, 908, 909, 171, 13503, 6980, 914, 231, 1676, 233, 234, 4509, 2050 ],
  ),
  "mode_comment": SymbolsMetadata(
    popularity: 2801,
    codepoint: 0xe253,
    categories: [ 7 ],
    tags: [ 6025, 1400, 471, 472, 473, 13504, 474, 443, 476, 477, 478, 480, 481, 966, 13505, 485, 13506, 75, 1410, 1565, 77, 492, 493, 494, 32, 496, 6080, 6070, 1161 ],
  ),
  "mode_cool": SymbolsMetadata(
    popularity: 524,
    codepoint: 0xf166,
    categories: [ 8 ],
    tags: [ 705, 709, 710, 13507, 5600, 712, 714, 717, 13508, 718, 5311, 721, 13509, 11917, 3076, 2018, 999, 724, 13510, 13511, 13512, 1004, 725, 726, 727, 729, 731, 732, 13513 ],
  ),
  "mode_cool_off": SymbolsMetadata(
    popularity: 124,
    codepoint: 0xf167,
    categories: [ 8 ],
    tags: [ 13514, 13515, 895, 712, 13516, 717, 2921, 13517, 3302, 13518, 13519, 767, 898, 5311, 13520, 3076, 999, 723, 901, 13521, 1004, 13522, 13523, 907, 908, 909, 914, 726, 13524, 13525, 13526, 727, 729, 13527, 13528 ],
  ),
  "mode_dual": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf557,
    categories: [ 10 ],
    tags: [ 705, 1128, 707, 709, 2777, 1849, 1850, 712, 713, 714, 269, 717, 718, 6788, 5311, 926, 3076, 5673, 999, 3078, 723, 307, 1004, 310, 726, 3967, 313, 727, 7945, 729, 314, 730, 1862, 1902, 731, 1863 ],
  ),
  "mode_fan": SymbolsMetadata(
    popularity: 1764,
    codepoint: 0xf168,
    categories: [ 8 ],
    tags: [ 705, 707, 5693, 708, 709, 1846, 1888, 9075, 1848, 2348, 712, 269, 717, 13529, 718, 719, 13530, 13531, 723, 307, 1004, 9079, 396, 310, 399, 727, 9082, 13532, 730, 1863 ],
  ),
  "mode_fan_off": SymbolsMetadata(
    popularity: 335,
    codepoint: 0xec17,
    categories: [ 8 ],
    tags: [ 705, 708, 709, 1846, 9075, 712, 717, 718, 13533, 767, 898, 719, 13534, 13535, 723, 901, 13536, 1004, 13537, 13523, 13538, 13539, 907, 909, 6602, 9079, 396, 914, 399, 1083, 727, 5587, 730 ],
  ),
  "mode_heat": SymbolsMetadata(
    popularity: 1017,
    codepoint: 0xf16a,
    categories: [ 8 ],
    tags: [ 1242, 8921, 5597, 7149, 712, 269, 3779, 5601, 9967, 5311, 8923, 3076, 5673, 13540, 999, 3078, 723, 9969, 307, 1004, 909, 3782, 310, 7162, 4206, 727, 8572, 729, 314, 13541, 3083 ],
  ),
  "mode_heat_cool": SymbolsMetadata(
    popularity: 260,
    codepoint: 0xf16b,
    categories: [ 8 ],
    tags: [ 705, 709, 1131, 1132, 712, 713, 714, 269, 717, 718, 5601, 5311, 3076, 5673, 999, 3235, 723, 307, 1004, 1901, 726, 313, 727, 728, 7945, 729, 314, 3978, 731 ],
  ),
  "mode_heat_off": SymbolsMetadata(
    popularity: 142,
    codepoint: 0xf16d,
    categories: [ 8 ],
    tags: [ 895, 383, 712, 714, 717, 896, 13542, 13543, 767, 13544, 898, 13545, 5311, 13546, 899, 13547, 13548, 13549, 13550, 999, 3078, 901, 1004, 13551, 13552, 13553, 13554, 13555, 907, 909, 914, 13556, 729, 13557, 13558, 13559, 13560 ],
  ),
  "mode_night": SymbolsMetadata(
    popularity: 718,
    codepoint: 0xf036,
    categories: [ 8 ],
    tags: [ 1128, 4243, 4212, 1728, 4244, 269, 4246, 4247, 3690, 5024, 3691, 4441, 4251, 5025, 4252, 307, 4253, 4220, 4254, 329, 3685, 65, 5026, 1929, 313, 5027, 314, 4260, 5028, 731 ],
  ),
  "mode_of_travel": SymbolsMetadata(
    popularity: 774,
    codepoint: 0xe7ce,
    categories: [ 5 ],
    tags: [ 380, 2489, 383, 384, 2063, 1484, 388, 2840, 1581, 1001, 390, 8776, 1490, 21, 307, 13561, 421, 13562, 1493, 1495, 2495, 13563, 2881, 13564, 1503, 1083, 2008, 1842, 1930, 1504, 1591, 4760 ],
  ),
  "mode_off_on": SymbolsMetadata(
    popularity: 523,
    codepoint: 0xf16f,
    categories: [ 8 ],
    tags: [ 951, 3074, 298, 383, 269, 4246, 896, 1077, 2855, 1602, 307, 907, 909, 13565, 281, 3782, 7271, 8870, 3516, 2542, 310, 13406, 108, 1083, 313, 314, 5587, 6477, 1215 ],
  ),
  "mode_standby": SymbolsMetadata(
    popularity: 463,
    codepoint: 0xf037,
    categories: [ 4 ],
    tags: [ 383, 1732, 4441, 4249, 832, 13566, 13489, 901, 188, 3781, 307, 908, 13567, 1082, 3782, 7271, 4023, 2123, 121, 177, 1925, 1786, 1929, 13493, 553, 8393, 313, 36, 314, 2147 ],
  ),
  "model_training": SymbolsMetadata(
    popularity: 2295,
    codepoint: 0xf0cf,
    categories: [ 6 ],
    tags: [ 3211, 3498, 380, 3212, 3942, 2490, 385, 13568, 2625, 3944, 530, 6632, 3524, 13569, 4686, 4695, 3375, 3680, 3946, 3513, 2568, 390, 3503, 13570, 411, 13571, 13572, 13573, 942, 28, 424, 425, 2494, 2367, 3749, 2881, 396, 5781 ],
  ),
  "modeling": SymbolsMetadata(
    popularity: 56,
    codepoint: 0xf3aa,
    categories: [ 2 ],
    tags: [ 1367, 2170, 380, 419, 4862, 798, 1731, 4865, 2832, 1778, 7106, 696, 2299, 304, 2875, 13574, 13575, 411, 12624, 13576, 778, 1858, 75, 2258, 782, 5861, 311, 5922, 11341, 32, 944, 945, 5781, 427, 13186 ],
  ),
  "money": SymbolsMetadata(
    popularity: 1233,
    codepoint: 0xe57d,
    categories: [ 9 ],
    tags: [ 13577, 3313, 458, 796, 797, 1074, 9597, 828, 799, 800, 801, 803, 1327, 805, 806, 11, 807, 3317, 834, 808, 811, 13578, 815, 818, 23, 24, 25, 819, 820, 821, 3641, 1337, 13579, 75, 3584, 824, 7196, 841, 32, 35, 441, 842, 463, 3324 ],
  ),
  "money_bag": SymbolsMetadata(
    popularity: 62,
    codepoint: 0xf3ee,
    categories: [ 9 ],
    tags: [ 775, 3719, 796, 828, 800, 803, 806, 3274, 3315, 3317, 834, 808, 811, 3320, 815, 13580, 5735, 13581, 13582, 818, 13583, 13584, 820, 821, 839, 3581, 13579, 5247, 13585, 824, 842, 8046, 3324, 3279 ],
  ),
  "money_off": SymbolsMetadata(
    popularity: 1164,
    codepoint: 0xe25c,
    categories: [ 9 ],
    tags: [ 797, 13586, 799, 1619, 800, 13587, 801, 803, 6881, 805, 806, 13588, 5750, 767, 5751, 13589, 807, 898, 808, 7310, 818, 13590, 4159, 13591, 13592, 13593, 7262, 13594, 907, 2742, 909, 819, 820, 821, 1336, 13595, 13596, 1050, 13597, 13598, 13599, 3898, 824, 841, 914, 13600, 35, 6884, 13601 ],
  ),
  "monitor": SymbolsMetadata(
    popularity: 1031,
    codepoint: 0xef5b,
    categories: [ 11 ],
    tags: [ 1109, 1110, 1684, 694, 1685, 445, 88, 12, 1711, 965, 1114, 53, 135, 215, 13602, 12710, 1687, 367, 327, 819, 119, 2400, 75, 330, 32, 551, 343, 344, 41, 317, 2102, 1691, 1053, 1054 ],
  ),
  "monitor_heart": SymbolsMetadata(
    popularity: 4166,
    codepoint: 0xeaa2,
    categories: [ 3 ],
    tags: [ 989, 2311, 5773, 4452, 7725, 445, 2413, 12, 13603, 5785, 5786, 5787, 6874, 2927, 595, 1753, 4455, 5778, 3569, 1754, 1757, 327, 13604, 4458, 1762, 3570, 5298, 330, 13605, 2165, 947, 4461, 4462, 1905 ],
  ),
  "monitor_weight": SymbolsMetadata(
    popularity: 862,
    codepoint: 0xf039,
    categories: [ 11 ],
    tags: [ 2513, 5, 584, 383, 694, 10, 445, 8829, 88, 12, 956, 595, 188, 135, 2568, 597, 634, 788, 327, 789, 656, 3641, 28, 2281, 330, 65, 1155, 32, 551, 791, 2165, 947, 3831 ],
  ),
  "monitor_weight_gain": SymbolsMetadata(
    popularity: 8,
    codepoint: 0xf6df,
    categories: [ 15 ],
    tags: [ 192, 526, 13606, 5, 4624, 584, 4631, 920, 10, 445, 8829, 12, 2926, 2927, 6021, 929, 595, 1207, 966, 5126, 327, 789, 763, 202, 28, 121, 2281, 330, 1155, 33, 2165, 947, 3831, 13607, 1905 ],
  ),
  "monitor_weight_loss": SymbolsMetadata(
    popularity: 9,
    codepoint: 0xf6de,
    categories: [ 15 ],
    tags: [ 2513, 584, 920, 383, 694, 1062, 10, 445, 8829, 13608, 12, 2926, 2927, 929, 595, 2568, 1116, 327, 13609, 13610, 28, 75, 2930, 911, 2281, 330, 1155, 32, 1122, 551, 791, 13611, 5996, 3831, 13612, 13613, 13614, 1905 ],
  ),
  "monitoring": SymbolsMetadata(
    popularity: 18391,
    codepoint: 0xf190,
    categories: [ 9 ],
    tags: [ 2513, 5, 2514, 1343, 365, 1284, 920, 2515, 10, 924, 6790, 808, 929, 196, 1207, 933, 2518, 2848, 936, 597, 937, 4458, 8559, 7499, 189, 28, 1353, 33, 10329, 440, 2165, 947, 2852, 2102 ],
    rtlAutoMirrored: true,
  ),
  "monochrome_photos": SymbolsMetadata(
    popularity: 337,
    codepoint: 0xe403,
    categories: [ 1 ],
    tags: [ 7045, 9853, 13615, 47, 49, 116, 383, 1734, 13616, 2567, 959, 7047, 5042, 53, 11317, 126, 367, 9855, 10449, 59, 61, 13617, 5800, 119, 12024, 121, 78, 5490, 1378, 13618, 7052 ],
  ),
  "monorail": SymbolsMetadata(
    popularity: 3,
    codepoint: 0xf473,
    categories: [ 14 ],
    tags: [ 2014, 1814, 1815, 1816, 2602, 2063, 2016, 1484, 388, 13619, 1659, 1581, 1602, 1490, 8161, 4617, 1922, 1194, 2071, 4601, 5230, 4618, 4619, 75, 32, 3611, 4621, 2165, 4622, 4623, 2008, 1842, 1930, 1504, 1591, 1625, 2621, 1844 ],
  ),
  "mood": SymbolsMetadata(
    popularity: 6448,
    codepoint: 0xe7f2,
    categories: [ 3 ],
    tags: [ 526, 472, 383, 473, 1550, 1551, 1552, 1553, 6699, 1554, 479, 9440, 480, 9001, 1555, 481, 1556, 1557, 1558, 1044, 6157, 1560, 6052, 1561, 489, 1563, 13620, 889, 1567, 1568, 13621, 1569, 607, 31, 1570, 2384 ],
  ),
  "mood_bad": SymbolsMetadata(
    popularity: 2060,
    codepoint: 0xe7f3,
    categories: [ 3 ],
    tags: [ 470, 10211, 13622, 383, 13623, 13624, 11449, 1550, 1551, 1552, 1553, 6699, 1554, 479, 480, 9001, 1555, 13625, 1561, 13626, 3696, 13627, 489, 490, 102, 3184, 889, 13628, 1566, 607, 1570, 13629, 13630, 13631, 13632, 13633, 13634, 13635, 501 ],
  ),
  "moon_stars": SymbolsMetadata(
    popularity: 5,
    codepoint: 0xf34f,
    categories: [ 3 ],
    tags: [ 4243, 4212, 4244, 3436, 712, 13636, 4246, 4247, 5024, 4215, 4251, 13637, 1659, 10039, 5025, 999, 3680, 4252, 4253, 1004, 4220, 13638, 4255, 423, 5652, 2123, 6314, 1011, 3699, 5026, 1929, 609, 8044, 944, 11763, 729, 289, 13639, 9210, 731 ],
  ),
  "mop": SymbolsMetadata(
    popularity: 1615,
    codepoint: 0xe28d,
    categories: [ 8 ],
    tags: [ 13640, 6369, 6342, 1871, 4005, 13641, 1433, 6372, 2523, 8918, 3489, 1436, 6348, 6349, 3972, 13642, 2770, 6373, 13643, 13644, 1004, 11392, 6350, 6352, 6375, 13645, 13646, 6353, 13647, 2537, 4001, 6357 ],
  ),
  "moped": SymbolsMetadata(
    popularity: 76,
    codepoint: 0xeb28,
    categories: [ 14 ],
    tags: [ 3325, 1814, 4312, 1815, 1816, 2063, 12927, 1019, 7699, 3799, 1654, 4613, 7701, 12900, 11079, 1659, 1490, 13648, 4335, 4336, 4337, 13649, 96, 3807, 13650, 4339, 4283, 4284, 1842, 1930, 1504, 4340, 1844, 4342 ],
    rtlAutoMirrored: true,
  ),
  "more": SymbolsMetadata(
    popularity: 1629,
    codepoint: 0xe619,
    categories: [ 6 ],
    tags: [ 82, 13651, 6323, 2151, 380, 2489, 1670, 2862, 2896, 4907, 776, 956, 2941, 786, 13652, 787, 2996, 1951, 3578, 1078, 10492, 18, 92, 788, 789, 421, 656, 3097, 2876, 4270, 2948, 1664, 65, 13653, 3103, 2728, 2824, 7859, 1070, 2384, 374, 983, 791 ],
    rtlAutoMirrored: true,
  ),
  "more_down": SymbolsMetadata(
    popularity: 617,
    codepoint: 0xf196,
    categories: [ 2 ],
    tags: [ 6323, 378, 380, 2871, 3095, 2862, 5124, 1062, 12, 13654, 2651, 2941, 787, 9255, 1066, 934, 92, 788, 789, 421, 2653, 656, 3097, 2948, 13655, 371, 3103, 3100 ],
  ),
  "more_horiz": SymbolsMetadata(
    popularity: 18925,
    codepoint: 0xe5d3,
    categories: [ 2 ],
    tags: [ 82, 2866, 13651, 6323, 1229, 1230, 2750, 4907, 2872, 956, 2941, 786, 13652, 787, 2996, 1951, 13656, 1078, 13657, 2176, 2751, 2888, 13658, 92, 788, 789, 13659, 13660, 421, 656, 3097, 2948, 330, 65, 3103, 2882, 7859, 7860, 374, 983, 791, 2757, 2759, 1691, 1053 ],
  ),
  "more_time": SymbolsMetadata(
    popularity: 2080,
    codepoint: 0xea5d,
    categories: [ 6 ],
    tags: [ 192, 526, 13661, 2104, 13662, 13663, 1016, 2092, 1017, 2137, 1020, 2996, 13664, 13665, 6407, 1207, 13666, 4721, 789, 13667, 763, 202, 2142, 1030, 13668, 1031, 5225, 35, 289, 13669, 2099, 1033 ],
  ),
  "more_up": SymbolsMetadata(
    popularity: 1007,
    codepoint: 0xf197,
    categories: [ 2 ],
    tags: [ 3325, 378, 380, 2871, 2862, 2896, 1062, 3101, 13670, 2941, 787, 2953, 2956, 1659, 900, 1066, 366, 788, 789, 13671, 421, 2948, 3046, 2997, 7859, 1214, 2949, 1676 ],
  ),
  "more_vert": SymbolsMetadata(
    popularity: 30701,
    codepoint: 0xe5d4,
    categories: [ 2 ],
    tags: [ 82, 2866, 13651, 13672, 13673, 1175, 1229, 1230, 5124, 2750, 4907, 2872, 956, 2941, 786, 13652, 787, 13674, 13675, 2751, 13658, 92, 788, 789, 13659, 13660, 13676, 421, 656, 3097, 330, 288, 65, 2882, 374, 983, 791, 2757, 2759, 13677, 1381, 13678, 13679, 1691, 1053 ],
  ),
  "mosque": SymbolsMetadata(
    popularity: 591,
    codepoint: 0xeab2,
    categories: [ 5 ],
    tags: [ 13680, 10582, 4309, 2601, 7453, 7454, 798, 8259, 6862, 10882, 13681, 13682, 5604, 13683, 13684, 3343, 13685, 13686, 13687, 10224, 13688, 13689, 6281, 5606, 13690, 5607, 6283, 5609, 2023, 1504, 5614 ],
  ),
  "motion_blur": SymbolsMetadata(
    popularity: 266,
    codepoint: 0xf0d0,
    categories: [ 1 ],
    tags: [ 13691, 264, 4528, 47, 383, 13692, 2448, 2547, 2299, 2567, 1022, 529, 959, 53, 366, 307, 420, 4546, 13693, 1858, 59, 61, 119, 28, 1027, 1028, 889, 231, 13694, 13695, 441, 2571, 41 ],
  ),
  "motion_mode": SymbolsMetadata(
    popularity: 21,
    codepoint: 0xf842,
    categories: [ 1 ],
    tags: [ 989, 264, 365, 4528, 47, 383, 2805, 2547, 529, 270, 7721, 53, 366, 307, 420, 13696, 1858, 2295, 59, 61, 119, 2162, 121, 1723, 1011, 122, 231, 108, 2586, 351, 441, 947, 2571, 1592, 41 ],
  ),
  "motion_photos_auto": SymbolsMetadata(
    popularity: 441,
    codepoint: 0xf03a,
    categories: [ 1 ],
    tags: [ 3495, 4, 2544, 264, 1131, 1132, 47, 116, 8, 2546, 3428, 383, 1469, 832, 270, 14, 2551, 2781, 19, 4985, 13697, 390, 367, 420, 13698, 360, 2555, 2556, 328, 423, 5800, 2162, 283, 121, 2561, 35, 38, 40, 41 ],
  ),
  "motion_photos_off": SymbolsMetadata(
    popularity: 258,
    codepoint: 0xe9c0,
    categories: [ 1 ],
    tags: [ 264, 1074, 895, 383, 4436, 4437, 896, 1076, 1077, 13699, 767, 898, 899, 13700, 13697, 13701, 420, 13702, 13703, 360, 2555, 4152, 13704, 13705, 13706, 907, 909, 5800, 171, 914, 1083, 41 ],
  ),
  "motion_photos_on": SymbolsMetadata(
    popularity: 59,
    codepoint: 0xe9c1,
    categories: [ 1 ],
    tags: [ 951, 1242, 13707, 264, 116, 383, 384, 767, 832, 898, 4985, 13697, 13708, 390, 391, 420, 13698, 13702, 2555, 2556, 907, 909, 423, 6313, 59, 5800, 2162, 283, 1363, 121, 177, 914, 41 ],
  ),
  "motion_photos_paused": SymbolsMetadata(
    popularity: 335,
    codepoint: 0xe9c2,
    categories: [ 1 ],
    tags: [ 2564, 264, 383, 269, 785, 832, 2138, 2139, 53, 4985, 13697, 13708, 390, 391, 367, 420, 13698, 13702, 1082, 11796, 59, 5800, 283, 2904, 13709, 1083, 2684, 1214, 3517, 1592, 41 ],
  ),
  "motion_play": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf40b,
    categories: [ 1 ],
    tags: [ 192, 949, 526, 264, 380, 1129, 3453, 355, 383, 1469, 776, 269, 832, 777, 2910, 484, 135, 3080, 367, 420, 278, 2081, 2162, 283, 2904, 202, 1152, 2143, 1156, 108, 2057, 35, 1701, 41 ],
  ),
  "motion_sensor_active": SymbolsMetadata(
    popularity: 222,
    codepoint: 0xe792,
    categories: [ 10 ],
    tags: [ 10068, 1242, 5957, 1244, 469, 2148, 3909, 1732, 2200, 2804, 2805, 1738, 274, 999, 1896, 1897, 420, 7863, 9371, 1858, 1004, 486, 6959, 7869, 1007, 1724, 1011, 122, 1901, 32, 351, 36, 2165, 947, 985 ],
  ),
  "motion_sensor_alert": SymbolsMetadata(
    popularity: 114,
    codepoint: 0xe784,
    categories: [ 10 ],
    tags: [ 3175, 10068, 1244, 469, 12203, 993, 3073, 1693, 383, 2391, 3176, 2804, 2805, 7861, 2766, 2767, 3177, 13710, 274, 2471, 999, 1251, 1641, 327, 420, 13711, 9371, 1858, 1004, 486, 6959, 7869, 1007, 1724, 1011, 122, 351, 35, 36, 2165, 947, 985, 1261 ],
  ),
  "motion_sensor_idle": SymbolsMetadata(
    popularity: 89,
    codepoint: 0xe783,
    categories: [ 10 ],
    tags: [ 2148, 1075, 383, 2391, 2805, 767, 898, 274, 999, 3235, 13489, 901, 1896, 1897, 327, 420, 9371, 1858, 1004, 13704, 13712, 13713, 907, 908, 909, 11796, 1011, 122, 914, 1901, 32, 13493, 9141, 13709, 351, 441, 2165, 947 ],
  ),
  "motion_sensor_urgent": SymbolsMetadata(
    popularity: 118,
    codepoint: 0xe78e,
    categories: [ 10 ],
    tags: [ 3175, 10068, 1244, 469, 3073, 2148, 1693, 383, 3176, 2804, 2805, 7861, 2766, 2767, 3177, 2471, 999, 5512, 1251, 1641, 327, 420, 7863, 9371, 1858, 13714, 1004, 486, 6959, 7869, 1007, 1724, 1011, 122, 7876, 351, 35, 36, 2165, 947, 1701, 985, 1034, 1261 ],
  ),
  "motorcycle": SymbolsMetadata(
    popularity: 842,
    codepoint: 0xe91b,
    categories: [ 14 ],
    tags: [ 1814, 4311, 4312, 8123, 1815, 1816, 383, 384, 2063, 1019, 388, 4613, 8900, 1581, 1490, 4335, 4400, 4336, 4337, 13715, 2071, 8155, 2072, 8124, 1587, 4339, 5780, 1930, 1504, 1591, 4340, 13716, 1844, 773, 4343 ],
  ),
  "mountain_flag": SymbolsMetadata(
    popularity: 97,
    codepoint: 0xf5e2,
    categories: [ 3 ],
    tags: [ 3573, 3, 13386, 2464, 13717, 6184, 2467, 13718, 1484, 4720, 15, 6189, 3724, 8983, 1543, 7346, 1001, 21, 198, 13719, 1544, 13720, 13721, 2474, 1493, 28, 13722, 2487, 12458, 36, 5579, 1701, 3588 ],
  ),
  "mouse": SymbolsMetadata(
    popularity: 2453,
    codepoint: 0xe323,
    categories: [ 11 ],
    tags: [ 1776, 12651, 694, 13723, 12653, 13724, 269, 1781, 1685, 445, 10812, 10813, 965, 966, 10956, 4052, 3020, 778, 1858, 421, 8339, 1363, 1783, 2899, 13725, 288, 551, 2165, 947, 792, 234 ],
  ),
  "mouse_lock": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf490,
    categories: [ 11 ],
    tags: [ 755, 1074, 1776, 13726, 13727, 694, 12653, 269, 1781, 13728, 445, 1077, 2855, 965, 966, 10956, 12350, 2674, 5714, 3020, 13729, 13730, 13731, 13732, 5715, 8339, 13733, 1783, 13734, 1516, 1517, 1520, 3310, 171, 602, 1773, 1011, 5717, 234 ],
  ),
  "mouse_lock_off": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf48f,
    categories: [ 11 ],
    tags: [ 755, 733, 1074, 895, 1776, 694, 269, 1781, 13728, 4440, 445, 13735, 767, 898, 899, 965, 966, 2674, 5714, 3020, 13730, 13736, 13737, 421, 13738, 907, 909, 5715, 1783, 13734, 285, 1516, 1517, 1520, 13739, 171, 602, 1773, 1011, 65, 914, 1083, 5717, 13740, 234 ],
  ),
  "move": SymbolsMetadata(
    popularity: 20,
    codepoint: 0xe740,
    categories: [ 5 ],
    tags: [ 2284, 380, 419, 584, 1731, 8759, 383, 384, 1483, 385, 1484, 388, 2651, 2924, 1488, 595, 483, 2568, 1001, 390, 1002, 1490, 778, 13741, 421, 488, 489, 1493, 1495, 1496, 424, 425, 8544, 7073, 1396, 396, 397, 1503, 1083, 2007, 1504, 8769 ],
  ),
  "move_down": SymbolsMetadata(
    popularity: 1460,
    codepoint: 0xeb61,
    categories: [ 2 ],
    tags: [ 380, 2650, 2188, 13742, 3121, 2937, 388, 2651, 2840, 3007, 1500, 932, 9561, 306, 92, 2315, 778, 2898, 421, 96, 98, 1496, 4758, 101, 13743, 8507, 7073, 3036, 106, 944, 107, 2007, 8281 ],
  ),
  "move_group": SymbolsMetadata(
    popularity: 64,
    codepoint: 0xf715,
    categories: [ 2 ],
    tags: [ 380, 3751, 1707, 388, 2999, 2909, 2985, 1672, 13744, 777, 930, 931, 6770, 1542, 13745, 6244, 8543, 13746, 778, 13747, 421, 1719, 8544, 13748, 782, 2343, 13749, 3036, 13750, 32, 1070, 4807, 1689, 2007, 13751, 2571, 13752, 1054, 1084 ],
  ),
  "move_item": SymbolsMetadata(
    popularity: 109,
    codepoint: 0xf1ff,
    categories: [ 2 ],
    tags: [ 380, 419, 8759, 4778, 388, 4779, 3007, 8504, 2985, 1672, 13753, 4781, 777, 1542, 1620, 13754, 6244, 903, 778, 13755, 2235, 421, 8544, 13756, 782, 2343, 13757, 1665, 13758, 3036, 13759, 2007, 13760, 2571, 346 ],
    rtlAutoMirrored: true,
  ),
  "move_location": SymbolsMetadata(
    popularity: 24,
    codepoint: 0xe741,
    categories: [ 5 ],
    tags: [ 380, 419, 584, 13761, 8759, 1483, 1484, 388, 13762, 1578, 3016, 960, 777, 5648, 1488, 595, 483, 1001, 1002, 1490, 778, 13741, 10647, 421, 2398, 488, 489, 13763, 1493, 1495, 1783, 1496, 8544, 1396, 782, 13764, 1083, 2007, 1504, 8769, 13765 ],
    rtlAutoMirrored: true,
  ),
  "move_selection_down": SymbolsMetadata(
    popularity: 4,
    codepoint: 0xf714,
    categories: [ 2 ],
    tags: [ 1367, 380, 2448, 2449, 956, 2651, 3007, 1500, 696, 932, 1066, 92, 788, 778, 2898, 13755, 13766, 96, 98, 1496, 13743, 8544, 8507, 288, 371, 104, 3036, 106, 32, 107, 2936, 2007, 1381 ],
  ),
  "move_selection_left": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xf713,
    categories: [ 2 ],
    tags: [ 2169, 1367, 918, 13767, 2448, 2449, 956, 3007, 696, 13768, 4964, 13769, 306, 13746, 778, 2974, 13770, 421, 96, 98, 1496, 13771, 13772, 13743, 8507, 7073, 288, 371, 3036, 4787, 32, 2183, 791, 2936, 2007, 2571 ],
  ),
  "move_selection_right": SymbolsMetadata(
    popularity: 19,
    codepoint: 0xf712,
    categories: [ 2 ],
    tags: [ 2169, 1367, 380, 918, 269, 2448, 2449, 388, 696, 246, 932, 1066, 306, 92, 778, 2235, 421, 96, 98, 1496, 13743, 8544, 8507, 7073, 1396, 782, 288, 371, 104, 3036, 944, 2007 ],
  ),
  "move_selection_up": SymbolsMetadata(
    popularity: 10,
    codepoint: 0xf711,
    categories: [ 2 ],
    tags: [ 1367, 380, 2466, 2448, 2449, 388, 956, 3007, 1500, 696, 8724, 932, 4964, 92, 778, 13773, 2958, 421, 98, 1496, 99, 1518, 12688, 13743, 75, 8507, 288, 371, 3036, 106, 32, 107, 1676, 2916 ],
  ),
  "move_to_inbox": SymbolsMetadata(
    popularity: 1126,
    codepoint: 0xe168,
    categories: [ 7 ],
    tags: [ 526, 2151, 380, 7, 2328, 13774, 1269, 1347, 2651, 2840, 337, 2924, 2335, 3286, 1530, 1656, 2336, 1542, 851, 2338, 966, 1044, 19, 2340, 485, 778, 10647, 98, 1664, 2343, 106, 32, 1298, 441, 2007, 2344 ],
  ),
  "move_up": SymbolsMetadata(
    popularity: 1588,
    codepoint: 0xeb64,
    categories: [ 2 ],
    tags: [ 1367, 380, 2052, 3121, 388, 3007, 1500, 932, 2957, 9561, 1066, 92, 778, 2958, 421, 96, 98, 1496, 1518, 8507, 7073, 3036, 106, 944, 107, 1124, 2007, 8281, 1676, 346 ],
  ),
  "moved_location": SymbolsMetadata(
    popularity: 29,
    codepoint: 0xe594,
    categories: [ 5 ],
    tags: [ 380, 1731, 8759, 1484, 388, 1578, 777, 1488, 1001, 1002, 8776, 1490, 13746, 778, 13775, 421, 1493, 1495, 1496, 8544, 1503, 2343, 10649, 1665, 8940, 1083, 2007, 1504, 1260, 8769 ],
  ),
  "movie": SymbolsMetadata(
    popularity: 6131,
    codepoint: 0xe02c,
    categories: [ 0 ],
    tags: [ 267, 6290, 6291, 1042, 1201, 3457, 13776, 6293, 696, 2299, 3337, 270, 13777, 367, 278, 328, 2162, 1837, 6296, 121, 177, 75, 5490, 13778, 6297, 2586, 41 ],
  ),
  "movie_edit": SymbolsMetadata(
    popularity: 43,
    codepoint: 0xf840,
    categories: [ 0 ],
    tags: [ 1128, 1726, 1731, 267, 6290, 6291, 693, 3456, 1201, 1853, 2834, 696, 2299, 270, 13779, 13780, 966, 367, 1740, 278, 13781, 13782, 3541, 328, 2693, 2694, 13783, 6296, 75, 6297, 441, 41, 364, 1536 ],
  ),
  "movie_info": SymbolsMetadata(
    popularity: 18,
    codepoint: 0xe02d,
    categories: [ 0 ],
    tags: [ 5461, 267, 383, 6325, 132, 270, 13784, 5537, 5463, 484, 135, 7530, 4695, 12071, 367, 10291, 789, 278, 13785, 13786, 283, 2904, 5539, 77, 330, 2997, 944, 6403, 13787, 441, 344, 41, 2102 ],
  ),
  "movie_off": SymbolsMetadata(
    popularity: 2,
    codepoint: 0xf499,
    categories: [ 0 ],
    tags: [ 13788, 13789, 13790, 13791, 13792, 13793, 267, 13794, 6291, 13795, 767, 13796, 13797, 13798, 898, 13799, 13800, 270, 13801, 13802, 367, 278, 13803, 13804, 13805, 13806, 13807, 13368, 11279, 907, 909, 13808, 13809, 13810, 914, 6297, 13811, 13812, 5546, 11283, 41, 11288 ],
  ),
  "moving": SymbolsMetadata(
    popularity: 1049,
    codepoint: 0xe501,
    categories: [ 5 ],
    tags: [ 989, 775, 13813, 380, 2466, 13814, 1731, 2332, 2625, 388, 926, 196, 6922, 1207, 1581, 1602, 420, 778, 8153, 421, 1586, 28, 2475, 11480, 3036, 2571, 1504, 2852, 1676, 2916, 2917, 4298 ],
    rtlAutoMirrored: true,
  ),
  "moving_beds": SymbolsMetadata(
    popularity: 7,
    codepoint: 0xe73d,
    categories: [ 3 ],
    tags: [ 380, 419, 1909, 584, 13815, 1749, 1202, 13816, 388, 3016, 777, 595, 1753, 13817, 1754, 13818, 483, 1757, 13819, 778, 13820, 13821, 13822, 421, 2398, 1762, 13823, 13824, 488, 489, 202, 490, 8544, 1396, 782, 13825, 3036, 2007, 13826, 501, 13827 ],
  ),
  "moving_ministry": SymbolsMetadata(
    popularity: 27,
    codepoint: 0xe73e,
    categories: [ 5 ],
    tags: [ 380, 419, 798, 1284, 1731, 6274, 1749, 13828, 5929, 388, 3016, 2626, 777, 2910, 595, 1754, 814, 13746, 13829, 778, 13830, 8153, 779, 421, 1492, 780, 1456, 940, 2398, 28, 13831, 1396, 782, 3036, 2007, 2571 ],
    rtlAutoMirrored: true,
  ),
  "mp": SymbolsMetadata(
    popularity: 134,
    codepoint: 0xe9c3,
    categories: [ 1 ],
    tags: [ 4, 1230, 1129, 13832, 2539, 8, 13833, 3337, 3540, 14, 53, 2780, 13170, 7442, 19, 2528, 13834, 326, 56, 2783, 58, 3390, 13835, 328, 2081, 9566, 59, 61, 27, 2162, 2163, 2648, 62, 30, 78, 1196, 1156, 32, 35, 38, 40 ],
  ),
  "multicooker": SymbolsMetadata(
    popularity: 280,
    codepoint: 0xe293,
    categories: [ 8 ],
    tags: [ 1888, 7, 953, 3234, 3795, 4386, 13836, 6170, 88, 1433, 956, 4078, 13837, 3216, 1829, 4390, 3489, 999, 1895, 1435, 1436, 13838, 3802, 8239, 1717, 3804, 4279, 13839, 1004, 7159, 13840, 6178, 75, 13841, 983 ],
  ),
  "multiline_chart": SymbolsMetadata(
    popularity: 431,
    codepoint: 0xe6df,
    categories: [ 9 ],
    tags: [ 2513, 5, 9897, 1343, 365, 1284, 920, 8935, 1852, 2515, 10, 924, 808, 929, 196, 933, 1209, 2518, 1602, 6022, 366, 597, 634, 937, 13842, 2557, 189, 11018, 28, 1353, 33, 947, 2852, 3858, 1355 ],
    rtlAutoMirrored: true,
  ),
  "multimodal_hand_eye": SymbolsMetadata(
    popularity: 26,
    codepoint: 0xf41b,
    categories: [ 2 ],
    tags: [ 733, 5957, 266, 1776, 269, 1781, 6300, 2734, 1250, 2735, 2738, 13843, 2741, 13844, 11575, 966, 6036, 971, 6780, 8559, 909, 1363, 2948, 981, 288, 2997, 7229, 36, 8035, 2165, 317, 5023, 11314, 2102 ],
  ),
  "multiple_airports": SymbolsMetadata(
    popularity: 25,
    codepoint: 0xefab,
    categories: [ 5 ],
    tags: [ 707, 2010, 1932, 2013, 13845, 1935, 1484, 13846, 388, 1917, 2017, 1488, 1501, 1581, 1001, 13847, 1002, 6280, 8776, 1641, 21, 13848, 13849, 2557, 13850, 421, 1493, 1495, 308, 8193, 1930, 1504, 1591, 10127, 4760, 13851 ],
  ),
  "multiple_stop": SymbolsMetadata(
    popularity: 803,
    codepoint: 0xf1b9,
    categories: [ 5 ],
    tags: [ 419, 3005, 1731, 2063, 2448, 2449, 13846, 1578, 956, 2450, 2627, 1672, 1542, 1581, 1375, 13852, 1490, 13853, 2557, 421, 3010, 2342, 2881, 1396, 1503, 2343, 1083, 2005, 5256, 5752, 2007, 2008, 2571, 3031, 13851 ],
  ),
  "museum": SymbolsMetadata(
    popularity: 903,
    codepoint: 0xea36,
    categories: [ 16 ],
    tags: [ 2601, 2829, 13854, 798, 802, 8259, 1484, 3153, 2605, 2094, 13855, 13856, 958, 13857, 13858, 1023, 1435, 814, 3343, 3375, 13170, 6868, 13171, 4717, 822, 1495, 2613, 2614, 823, 13859, 981, 1297, 1298, 6709, 2023, 1504, 1701, 1591, 2024, 13860 ],
  ),
  "music_cast": SymbolsMetadata(
    popularity: 87,
    codepoint: 0xeb1a,
    categories: [ 0 ],
    tags: [ 2051, 1129, 13861, 13862, 4477, 355, 13863, 2053, 921, 211, 968, 2081, 13864, 3132, 13865, 13866, 223, 1532, 1665, 3058, 227, 1156, 13867, 2057, 342, 441, 2165, 2085, 5086, 1902, 233, 234 ],
  ),
  "music_note": SymbolsMetadata(
    popularity: 7304,
    codepoint: 0xe405,
    categories: [ 0 ],
    tags: [ 1538, 2152, 1129, 8658, 9564, 3389, 13868, 13869, 3337, 968, 1143, 367, 10832, 3390, 2081, 3131, 3132, 9566, 3394, 1532, 2162, 2163, 13870, 13871, 2164, 1156, 9137, 13872, 2165, 1744, 1745 ],
  ),
  "music_note_add": SymbolsMetadata(
    popularity: 6,
    codepoint: 0xf391,
    categories: [ 0 ],
    tags: [ 192, 526, 13873, 13874, 1524, 13875, 1129, 13876, 13868, 13877, 13878, 13879, 13880, 13881, 13882, 13883, 13884, 13885, 968, 2081, 3132, 13886, 13887, 13888, 1531, 13889, 1211, 1532, 202, 13890, 13891, 13892, 1156, 13893, 35, 2165 ],
  ),
  "music_off": SymbolsMetadata(
    popularity: 521,
    codepoint: 0xe440,
    categories: [ 0 ],
    tags: [ 1129, 9132, 11358, 11359, 13868, 383, 3304, 13894, 11365, 767, 898, 4720, 968, 2903, 326, 2081, 9135, 13895, 3132, 13235, 1164, 1166, 13236, 1169, 1532, 907, 909, 3514, 2123, 1170, 1171, 914, 1156, 9137, 11373, 8318, 2165, 13896, 13897, 8321 ],
  ),
  "music_video": SymbolsMetadata(
    popularity: 349,
    codepoint: 0xe063,
    categories: [ 0 ],
    tags: [ 1129, 2588, 1469, 12, 3337, 270, 1143, 367, 10832, 278, 328, 2081, 13898, 3394, 1532, 2162, 2904, 2163, 177, 75, 77, 330, 2164, 1156, 2057, 1744, 344, 41, 2102, 1054 ],
  ),
  "my_location": SymbolsMetadata(
    popularity: 8090,
    codepoint: 0xe55c,
    categories: [ 5 ],
    tags: [ 1775, 1730, 383, 1732, 8935, 2200, 1483, 1484, 388, 1578, 832, 960, 1738, 1488, 8256, 1001, 1002, 1490, 21, 2179, 13899, 421, 1493, 1494, 1495, 1363, 1783, 1496, 8193, 1083, 36, 2165, 947, 13900 ],
  ),
  "mystery": SymbolsMetadata(
    popularity: 171,
    codepoint: 0xf5e1,
    categories: [ 3 ],
    tags: [ 2513, 13901, 955, 9595, 958, 6300, 13902, 960, 1738, 6189, 1078, 4294, 967, 4350, 126, 971, 974, 13903, 975, 976, 13904, 8559, 4359, 2948, 3184, 980, 981, 7536, 13905, 6330, 317, 5023, 2102, 986 ],
  ),
  "nat": SymbolsMetadata(
    popularity: 257,
    codepoint: 0xef5c,
    categories: [ 7 ],
    tags: [ 755, 2827, 380, 383, 443, 211, 3121, 832, 5647, 968, 9015, 1001, 1002, 1003, 13906, 421, 223, 13907, 1363, 2534, 13908, 782, 1503, 3228, 5063, 2343, 2007, 7110 ],
  ),
  "nature": SymbolsMetadata(
    popularity: 2837,
    codepoint: 0