// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Japanese (`ja`).
class AppLocalizationsJa extends AppLocalizations {
  AppLocalizationsJa([String locale = 'ja']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => '日本語';

  @override
  String s_translated(int percentage) {
    return '翻訳済み: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return '校閲済み: $percentage%';
  }

  @override
  String get l_incomplete_translation => '未翻訳';

  @override
  String get p_translation_progress_desc => '進捗メーターで翻訳の進行状況を表示しています。';

  @override
  String get s_save => '保存';

  @override
  String get s_cancel => 'キャンセル';

  @override
  String get s_close => '閉じる';

  @override
  String get s_delete => '削除';

  @override
  String get s_move => '移動';

  @override
  String get s_quit => '終了';

  @override
  String get s_enable => '有効にする';

  @override
  String get s_enabled => '有効';

  @override
  String get s_disabled => '無効';

  @override
  String get s_status => 'ステータス';

  @override
  String get s_unlock => 'ロック解除';

  @override
  String get s_calculate => '導出';

  @override
  String get s_import => 'インポート';

  @override
  String get s_overwrite => '上書き';

  @override
  String get s_done => '完了';

  @override
  String get s_label => 'ラベル';

  @override
  String get s_name => '名前';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'オプション';

  @override
  String get s_details => '詳細';

  @override
  String get s_show_window => 'ウィンドウを表示';

  @override
  String get s_hide_window => 'ウィンドウを非表示';

  @override
  String get s_show_navigation => 'ナビゲーションを表示します';

  @override
  String get s_expand_navigation => 'Expand navigation bar';

  @override
  String get s_collapse_navigation => 'Collapse navigation bar';

  @override
  String get s_expand_collapse_navigation => 'Expand/collapse navigation bar';

  @override
  String get s_show_menu => 'メニューを表示します';

  @override
  String get s_toggle_menu_bar => 'Toggle menu bar';

  @override
  String get s_more_info => '詳細情報';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<なし>';

  @override
  String get s_about => 'アプリ情報';

  @override
  String get s_algorithm => 'アルゴリズム';

  @override
  String get s_appearance => '外観';

  @override
  String get s_actions => '操作';

  @override
  String get s_manage => '管理';

  @override
  String get s_setup => 'セットアップ';

  @override
  String get s_device => 'デバイス';

  @override
  String get s_application => 'アプリケーション';

  @override
  String get s_settings => '設定';

  @override
  String get l_settings_desc => 'アプリの設定を変更します';

  @override
  String get s_certificates => '証明書';

  @override
  String get s_security_key => 'セキュリティキー';

  @override
  String get s_slots => 'スロット';

  @override
  String get s_help_and_about => 'ヘルプとアプリ情報';

  @override
  String get l_help_and_about_desc => 'トラブルシューティングとサポート';

  @override
  String get s_help_and_feedback => 'ヘルプとフィードバック';

  @override
  String get s_home => 'ホーム';

  @override
  String get s_user_guide => 'ユーザーガイド';

  @override
  String get s_i_need_help => 'ヘルプが必要な場合';

  @override
  String get s_troubleshooting => 'トラブルシューティング';

  @override
  String get s_terms_of_use => '利用規約';

  @override
  String get s_privacy_policy => 'プライバシーポリシー';

  @override
  String get s_open_src_licenses => 'オープンソースライセンス';

  @override
  String get s_please_wait => 'お待ちください…';

  @override
  String get s_secret_key => '秘密鍵';

  @override
  String get s_show_secret_key => '秘密鍵を表示します';

  @override
  String get s_hide_secret_key => '秘密鍵を隠します';

  @override
  String get s_private_key => '秘密鍵';

  @override
  String get s_public_key => '公開鍵';

  @override
  String get s_invalid_length => '文字数が不正です';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return '形式が不正です。使用できる文字: $characters';
  }

  @override
  String get l_invalid_keyboard_character => '選択したキーボードでは無効な文字です';

  @override
  String get s_require_touch => 'タッチを要求する';

  @override
  String get q_have_account_info => 'アカウント情報がありますか？';

  @override
  String get s_run_diagnostics => '診断を実行';

  @override
  String s_log_level(String level) {
    return 'ログレベル: $level';
  }

  @override
  String get s_character_count => '文字数';

  @override
  String get s_language => '言語';

  @override
  String p_community_translations_desc(String crowdin) {
    return '翻訳は $crowdin でコミュニティによりメンテナンスされています。';
  }

  @override
  String get s_choose_language => '言語を選択してください';

  @override
  String get s_app_theme => 'アプリのテーマ';

  @override
  String get s_choose_app_theme => 'テーマを選択';

  @override
  String get s_system_default => 'システム標準';

  @override
  String get s_light_mode => 'ライト';

  @override
  String get s_dark_mode => 'ダーク';

  @override
  String get s_list_layout => 'リストレイアウト';

  @override
  String get s_grid_layout => 'グリッドレイアウト';

  @override
  String get s_mixed_layout => 'ミックスレイアウト';

  @override
  String get s_select_layout => 'レイアウトを選択';

  @override
  String get s_select_to_scan => '選択してスキャン';

  @override
  String get s_hide_reader => 'リーダーを隠す';

  @override
  String get s_show_hidden_readers => '非表示のリーダーを表示する';

  @override
  String get s_toggle_readers => 'リーダーを切り替える';

  @override
  String get l_toggle_readers_desc => 'リーダーを表示/非表示にします';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'シリアル番号: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'ファームウェアバージョン: $version';
  }

  @override
  String get l_fips_capable => 'FIPS対応';

  @override
  String get l_fips_approved => 'FIPS承認済み';

  @override
  String get l_insert_yk => 'YubiKey を挿入してください';

  @override
  String get l_insert_or_tap_yk => 'YubiKey をかざすか挿入してください';

  @override
  String get l_unplug_yk => 'YubiKey を取り外してください';

  @override
  String get l_reinsert_yk => 'YubiKey をもう一度挿入してください';

  @override
  String get l_place_on_nfc_reader => 'YubiKey を NFC リーダーに合わせてください';

  @override
  String get l_replace_yk_on_reader => 'YubiKey をもう一度 NFC リーダーに合わせてください';

  @override
  String get l_remove_yk_from_reader => 'YubiKey を NFC リーダーから外してください';

  @override
  String get p_try_reinsert_yk => 'YubiKey を取り外して、もう一度挿入してください。';

  @override
  String get s_touch_required => 'タッチが必要です';

  @override
  String get l_touch_button_now => 'YubiKey のボタンをタッチしてください';

  @override
  String get l_keep_touching_yk => 'YubiKey を繰り返しタッチしてください...';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'アプリケーションを切り替える';

  @override
  String get s_toggle_interfaces => 'インターフェイスを切り替える';

  @override
  String get p_toggle_applications_desc =>
      '利用可能なトランスポート上でアプリケーションを有効または無効にします。';

  @override
  String get p_toggle_interfaces_desc => 'USBインターフェースの有効化または無効化。';

  @override
  String get l_toggle_applications_desc => 'アプリケーションを有効/無効にします';

  @override
  String get l_toggle_interfaces_desc => 'インターフェイスを有効/無効にします';

  @override
  String get s_reconfiguring_yk => 'YubiKeyを再設定しています...';

  @override
  String get s_config_updated => '設定を更新しました';

  @override
  String get l_config_updated_reinsert => '設定を更新しました。YubiKey を取り外して再挿入してください';

  @override
  String get s_fido_disabled => 'FIDO2が無効です';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn を使用するには、YubiKey で FIDO2 アプリケーションを有効にしてください';

  @override
  String get s_lock_code => 'ロックコード';

  @override
  String get l_wrong_lock_code => 'ロックコードが正しくありません';

  @override
  String get s_show_lock_code => 'ロックコードを表示';

  @override
  String get s_hide_lock_code => 'ロックコードを隠す';

  @override
  String get p_lock_code_required_desc => '操作を実行するには、設定ロックコードを入力する必要があります。';

  @override
  String get l_helper_not_responding => 'ヘルパープロセスが応答していません';

  @override
  String get l_yk_no_access => 'この YubiKey にアクセスできません';

  @override
  String get s_yk_inaccessible => 'デバイスにアクセスできません';

  @override
  String get l_open_connection_failed => '接続を開けませんでした';

  @override
  String get l_ccid_connection_failed => 'スマートカード接続を開けませんでした';

  @override
  String get p_ccid_service_unavailable => 'スマートカードサービスが機能していることを確認してください。';

  @override
  String get p_pcscd_unavailable => 'pcscdがインストールされ、実行中であることを確認してください。';

  @override
  String get l_no_yk_present => 'YubiKey がありません';

  @override
  String get s_unknown_type => 'タイプが不明です';

  @override
  String get s_unknown_device => '認識できないデバイスです';

  @override
  String get s_restricted_nfc => 'NFC の有効化';

  @override
  String get l_deactivate_restricted_nfc => 'NFC 有効化の方法';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'YubiKey をコンピューターなどの USB 電源に 3 秒以上接続してください。\n\n初回の電源投入後は NFC が有効化され、使用できるようになります。';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'YubiKey には輸送中の無線による改ざんから保護するための制限付き NFC が搭載されています。NFC 操作はあなたが有効化するまで一時的に無効になります。';

  @override
  String get s_unsupported_yk => '対応していない YubiKey です';

  @override
  String get p_operation_failed_try_again => '操作に失敗しました。もう一度やり直してください。';

  @override
  String get l_configuration_unsupported => '設定に対応していません';

  @override
  String get p_scp_unsupported =>
      'YubiKey が NFCで通信するには、この携帯電話が対応していない技術が必要です。YubiKey を携帯電話の USB ポートに接続してください。';

  @override
  String get l_error_occurred => 'エラーが発生しました';

  @override
  String get s_application_error => 'アプリケーションエラー';

  @override
  String get l_import_error => 'インポートエラー';

  @override
  String get l_file_not_found => 'ファイルが見つかりません';

  @override
  String get l_file_too_big => 'ファイルのサイズが大きすぎます';

  @override
  String get l_filesystem_error => 'ファイルのシステム操作エラー';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'PIN を設定';

  @override
  String get s_change_pin => 'PIN を変更';

  @override
  String get s_change_puk => 'PUK を変更';

  @override
  String get s_show_pin => 'PIN を表示します';

  @override
  String get s_hide_pin => 'PIN を隠します';

  @override
  String get s_show_puk => 'PUK を表示します';

  @override
  String get s_hide_puk => 'PUK を隠します';

  @override
  String get s_current_pin => '現在の PIN';

  @override
  String get s_current_puk => '現在の PUK';

  @override
  String get s_new_pin => '新しい PIN';

  @override
  String get s_new_puk => '新しい PUK';

  @override
  String get s_confirm_pin => 'PIN を確認';

  @override
  String get s_confirm_puk => 'PUK を確認';

  @override
  String get s_unblock_pin => 'PIN をリセット';

  @override
  String get l_pin_mismatch => 'PIN が一致しません';

  @override
  String get l_puk_mismatch => 'PUK が一致しません';

  @override
  String get s_pin_set => 'PIN を設定しました';

  @override
  String get s_puk_set => 'PUK を設定しました';

  @override
  String l_set_pin_failed(String message) {
    return 'PIN を設定できませんでした: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'あと $retries 回試行できます',
      one: 'あと $retries 回試行できます',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'あと $retries 回試行できます',
      one: 'あと $retries 回試行できます',
    );
    return 'PIN が間違っています。$_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: 'あと $retries 回試行できます',
      one: 'あと $retries 回試行できます',
    );
    return 'PUK が間違っています。$_temp0';
  }

  @override
  String get s_fido_pin_protection => 'FIDO PIN保護';

  @override
  String get s_pin_change_required => 'PIN を変更してください';

  @override
  String get l_enter_fido2_pin => 'YubiKey の FIDO2 PIN を入力してください';

  @override
  String get l_pin_blocked_reset =>
      'PIN がブロックされています。FIDO アプリケーションを工場出荷時の状態にリセットしてください';

  @override
  String get l_pin_blocked => 'PIN がブロックされています';

  @override
  String get l_set_pin_first => 'PIN を設定してください';

  @override
  String get l_unlock_pin_first => 'PIN でロック解除してください';

  @override
  String get l_pin_soft_locked => 'YubiKey を取り外して挿入し直すまで、PIN がブロックされています';

  @override
  String get l_pin_change_required_desc => 'このアプリケーションを使用する前に新しい PIN を設定してください';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return '新しい PIN を入力してください。PIN は $min_length-$max_length 文字で、英数字と特殊文字を使用できます。';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return '新しい PIN を入力してください。PIN は $min_length-$max_length 文字、記号を $unique_characters 文字以上含む、よく使用される「$common_pin」のような PIN ではないものを設定してください。英数字と特殊文字を使用できます。';
  }

  @override
  String get s_ep_attestation => 'Enterprise Attestation';

  @override
  String get s_ep_attestation_enabled => 'Enterprise Attestation が有効です';

  @override
  String get q_enable_ep_attestation => 'Enterprise Attestation を有効にしますか？';

  @override
  String get p_enable_ep_attestation_desc =>
      'Enterprise Attestation が有効になり、認可されたドメインが YubiKey を一意に識別できるようになります。';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      '一度 Enterprise Attestation を有効にすると、無効にするには FIDO の工場出荷時リセットを実行する必要があります。';

  @override
  String get s_pin_required => 'PIN が必要';

  @override
  String get p_pin_required_desc => '実行しようとしている操作では、PIV PIN を入力する必要があります。';

  @override
  String get l_piv_pin_blocked => 'ブロックされています。PUK を使用してリセットしてください';

  @override
  String get p_piv_pin_blocked_desc => 'PIN がブロックされています。PUK を使用してリセットしてください。';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'The PIN is blocked. A factory reset is required.';

  @override
  String get l_piv_pin_puk_blocked => 'ブロックされています。工場出荷時の状態にリセットしてください';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'PIN と PUK の両方がブロックされています。PIV アプリケーションの工場出荷時リセットが必要です。';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return '$name は $length 文字以上で設定してください。';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return '$name は $length 文字以上で、記号を 2 文字以上含む、よく使用される「$common」のような $name ではないものを設定してください。';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return '新しい $name は複雑さの要件を満たしていません。';
  }

  @override
  String get s_dismiss => '閉じる';

  @override
  String get p_default_pin_puk_key_desc => 'デフォルトの PIN、PUK、管理キーの変更をお勧めします。';

  @override
  String get l_warning_default_pin => '警告: デフォルトの PIN を使用されています';

  @override
  String get l_warning_default_puk => '警告: デフォルトの PUK を使用しています';

  @override
  String get l_default_pin_used => 'デフォルトの PIN を使用しています';

  @override
  String get l_default_puk_used => 'デフォルトの PUK を使用しています';

  @override
  String get l_pin_complexity => 'PIN の複雑さのルール';

  @override
  String get s_password => 'パスワード';

  @override
  String get s_manage_password => 'パスワードを管理';

  @override
  String get s_set_password => 'パスワードを設定';

  @override
  String get s_password_set => 'パスワードを設定しました';

  @override
  String get s_show_password => 'パスワードを表示します';

  @override
  String get s_hide_password => 'パスワードを隠します';

  @override
  String get l_password_protection => 'アカウントのパスワード保護';

  @override
  String get s_new_password => '新しいパスワード';

  @override
  String get s_current_password => '現在のパスワード';

  @override
  String get s_confirm_password => 'パスワードを確認';

  @override
  String get l_password_mismatch => 'パスワードが一致しません';

  @override
  String get s_wrong_password => 'パスワードが正しくありません';

  @override
  String get p_wrong_password =>
      'パスワードが間違っています。パスワードがわからない場合は、Yubikey をリセットする必要があります。';

  @override
  String get s_remove_password => 'パスワードを削除';

  @override
  String get s_password_removed => 'パスワードを削除しました';

  @override
  String get s_remember_password => 'パスワードを記憶する';

  @override
  String get s_clear_saved_password => '保存しているパスワードを消去';

  @override
  String get s_password_forgotten => '記憶していたパスワードを消去しました';

  @override
  String get l_keystore_unavailable => 'OS のキーストアが利用できません';

  @override
  String get l_remember_pw_failed => 'パスワードを記憶できませんでした';

  @override
  String get l_unlock_first => 'パスワードでロック解除';

  @override
  String get l_set_password_first => 'パスワードを設定';

  @override
  String get l_enter_oath_pw => 'YubiKey の OATH パスワードを入力してください';

  @override
  String get p_new_password_requirements => 'パスワードには、英数字と特殊文字を使用できます。';

  @override
  String get s_management_key => '管理キー';

  @override
  String get s_current_management_key => '現在の管理キー';

  @override
  String get s_new_management_key => '新しい管理キー';

  @override
  String get l_change_management_key => '管理キーを変更';

  @override
  String get l_management_key_changed => '管理キーを変更しました';

  @override
  String get l_default_key_used => 'デフォルトの管理キーを使用しています';

  @override
  String get s_generate_random => 'ランダムに生成します';

  @override
  String get s_use_default => 'デフォルトを使用';

  @override
  String get l_warning_default_key => '警告: デフォルトのキーを使用しています';

  @override
  String get s_protect_key => 'PIN で保護する';

  @override
  String get p_protect_key_desc => '管理キーが必要な操作で、代わりに PIN を使用します。';

  @override
  String get s_management_key_algorithm => '鍵のアルゴリズムを管理';

  @override
  String get p_management_key_algorithm_desc => '管理キーのアルゴリズムを選択します。';

  @override
  String get l_pin_protected_key => 'PIN を代わりに使用できます';

  @override
  String get l_wrong_key => 'キーが正しくありません';

  @override
  String get l_unlock_piv_management => 'PIV管理をロック解除';

  @override
  String get p_unlock_piv_management_desc => 'この操作では、PIV 管理キーが必要です。';

  @override
  String l_account(String label) {
    return 'アカウント: $label';
  }

  @override
  String get s_accounts => 'アカウント';

  @override
  String get s_no_accounts => 'アカウントなし';

  @override
  String l_results_for(String query) {
    return '「$query」の結果';
  }

  @override
  String get l_authenticator_get_started => 'OTP アカウントの使用をはじめる';

  @override
  String get l_no_accounts_desc =>
      'OATH TOTP/HOTP に対応したサービスプロバイダーのアカウントを YubiKey に追加してください';

  @override
  String get s_add_account => 'アカウントを追加';

  @override
  String get p_add_account_desc => 'QR コードをスキャンするか、資格情報を入力してください。';

  @override
  String get s_add_accounts => 'アカウントを追加';

  @override
  String get l_drop_qr_description => 'QR コードをドラッグ&ドロップしてアカウントを追加';

  @override
  String get p_add_account_three_ways => '3 通りの方法でアカウントを追加できます。';

  @override
  String get s_scanning => 'スキャン (推奨)';

  @override
  String get p_scanning_desc => 'QR コードをスキャンする前に、画面にコード全体が表示されているか確認してください。';

  @override
  String get s_drag_and_drop => 'ドラッグアンドドロップ';

  @override
  String get p_drag_and_drop_desc => 'アカウント表示の任意の場所に QR コードを含む画像をドロップします。';

  @override
  String get s_manually => '手動';

  @override
  String get p_manually_desc => 'フォームにアカウント資格情報の詳細を入力します。';

  @override
  String get s_account_added => 'アカウントを追加しました';

  @override
  String l_account_add_failed(String message) {
    return 'アカウントを追加できませんでした: $message';
  }

  @override
  String get l_add_account_password_required => 'パスワードが必要です';

  @override
  String get l_add_account_unlock_required => 'ロック解除が必要です';

  @override
  String get l_add_account_already_exists => '既に存在するアカウントです';

  @override
  String get l_add_account_func_missing => '機能が存在しないか無効です';

  @override
  String get l_account_name_required => 'アカウントには名前を付けてください';

  @override
  String get l_name_already_exists => 'この名前は発行者にすでに存在します';

  @override
  String get l_account_already_exists => 'このアカウントは YubiKey にすでに存在します';

  @override
  String get l_invalid_character_issuer => '無効な文字: 「:」は発行者には使用できません';

  @override
  String get l_select_accounts => 'YubiKey に追加するアカウントを選択';

  @override
  String get s_pin_account => 'アカウントをピン留めする';

  @override
  String get s_unpin_account => 'アカウントのピン留めを外す';

  @override
  String get s_no_pinned_accounts => 'ピン留めされているアカウントはありません';

  @override
  String get s_pinned => 'ピン留め';

  @override
  String get l_pin_account_desc => '重要なアカウントを固定します';

  @override
  String get s_rename_account => 'アカウント名を変更';

  @override
  String get l_rename_account_desc => 'アカウントの発行者/名前を編集します';

  @override
  String get s_account_renamed => 'アカウントの名前を変更しました';

  @override
  String l_rename_account_failed(String message) {
    return 'アカウント名を変更できませんでした: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'リスト内でのアカウントの表示内容が変更されます。';

  @override
  String get s_delete_account => 'アカウントを削除';

  @override
  String get q_delete_account => 'アカウントを削除しますか？';

  @override
  String get l_delete_account_desc => 'YubiKey からアカウントを削除します';

  @override
  String get s_account_deleted => 'アカウントを削除しました';

  @override
  String get p_warning_delete_account => '警告！YubiKey からアカウントが削除されます。';

  @override
  String get p_warning_disable_credential =>
      'ログインできなくならないように、まず登録しているサービスからこの資格情報を無効にしてください。';

  @override
  String get s_account_name => 'アカウント名';

  @override
  String get s_search_accounts => 'アカウントを検索';

  @override
  String l_accounts_used(int used, int capacity) {
    return 'アカウント $used / $capacity 個を使用中';
  }

  @override
  String s_num_digits(int num) {
    return '$num 桁';
  }

  @override
  String s_num_sec(int num) {
    return '$num 秒';
  }

  @override
  String get s_issuer_optional => '発行者 (オプション)';

  @override
  String get s_counter_based => 'カウンターベース';

  @override
  String get s_time_based => '時間ベース';

  @override
  String get l_copy_code_desc => '別のアプリケーションにコードを貼り付けて使用してください';

  @override
  String get l_calculate_code_desc => 'YubiKey から新しいコードを取得します';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'ユーザー ID';

  @override
  String get s_credential_id => 'Credential ID';

  @override
  String get s_display_name => '表示名';

  @override
  String get s_user_name => 'ユーザー名';

  @override
  String get s_passkeys => 'パスキー';

  @override
  String get s_no_passkeys => 'パスキーはありません';

  @override
  String get l_ready_to_use => '使用可能';

  @override
  String get l_register_sk_on_websites => 'ウェブサイトサイトでセキュリティキーとして登録してください';

  @override
  String get l_no_discoverable_accounts => 'パスキーは保存されていません';

  @override
  String get p_non_passkeys_note => 'パスキー以外の資格情報が存在する可能性がありますが、一覧はに表示されません。';

  @override
  String get s_delete_passkey => 'パスキーを削除';

  @override
  String get q_delete_passkey => 'パスキーを削除しますか？';

  @override
  String get l_delete_passkey_desc => 'YubiKey からパスキーを削除します';

  @override
  String get s_passkey_deleted => 'パスキーを削除しました';

  @override
  String get p_warning_delete_passkey => '警告！この操作は Yubikey からパスキーを削除します。';

  @override
  String get p_warning_delete_passkey_desc => '登録しているサービスで、このパスキーが使用できなくなります。';

  @override
  String get s_search_passkeys => 'パスキーを検索';

  @override
  String p_passkeys_used(int used, int max) {
    return 'パスキー $used / $max 個を使用中。';
  }

  @override
  String get s_biometrics => '生体認証';

  @override
  String l_fingerprint(String label) {
    return '指紋：$label';
  }

  @override
  String get s_fingerprints => '指紋';

  @override
  String get l_fingerprint_captured => '指紋が正常に読み取られました！';

  @override
  String get s_fingerprint_added => '指紋が追加されました';

  @override
  String l_adding_fingerprint_failed(String message) {
    return '指紋の追加エラー：$message';
  }

  @override
  String l_setting_name_failed(String message) {
    return '名前の設定エラー：$message';
  }

  @override
  String get s_setup_fingerprints => '指紋を設定';

  @override
  String get p_setup_fingerprints_desc => 'キーを使用する前に指紋を設定する必要があります。';

  @override
  String get s_add_fingerprint => '指紋を追加';

  @override
  String get s_delete_fingerprint => '指紋を削除';

  @override
  String get q_delete_fingerprint => '指紋を削除しますか？';

  @override
  String get l_delete_fingerprint_desc => 'YubiKeyから指紋を削除します';

  @override
  String get s_fingerprint_deleted => '指紋が削除されました';

  @override
  String get p_warning_delete_fingerprint => 'これにより、YubiKeyから指紋が削除されます。';

  @override
  String get s_fingerprints_get_started => '指紋の使用を開始';

  @override
  String get p_set_fingerprints_desc => '指紋を登録する前に、PINを設定する必要があります。';

  @override
  String get l_no_fps_added => '追加されている指紋はありません';

  @override
  String get s_rename_fp => '指紋の名前を変更';

  @override
  String get l_rename_fp_desc => '名前を変更します';

  @override
  String get s_fingerprint_renamed => '指紋の名前が変更されました';

  @override
  String l_rename_fp_failed(String message) {
    return '名前変更のエラー: $message';
  }

  @override
  String get l_add_one_or_more_fps => '指紋を1つ以上（最大5つ）追加してください';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5の指紋が登録されています';
  }

  @override
  String get p_press_fingerprint_begin => '最初にYubiKeyに指を押し付けてください。';

  @override
  String get l_name_fingerprint => 'この指紋に名前を付ける';

  @override
  String get l_user_action_timeout_error => 'ユーザーの操作がないため失敗しました';

  @override
  String get l_wrong_inserted_yk_error => '挿入し直した YubiKey が元のデバイスと一致しません';

  @override
  String get l_failed_connecting_to_fido => 'FIDO インターフェイスへ接続できませんでした';

  @override
  String get l_self_signed_certificate => '自己署名証明書';

  @override
  String get l_certificate_signing_request => '証明書署名要求 (CSR)';

  @override
  String get s_certificate => '証明書';

  @override
  String get s_subject => 'サブジェクト';

  @override
  String get l_export_csr_file => 'CSR をファイルに保存';

  @override
  String get l_export_public_key => '公開鍵をエクスポート';

  @override
  String get l_export_public_key_file => '公開鍵をファイルに保存';

  @override
  String get l_export_public_key_desc => '公開鍵をファイルにエクスポートします';

  @override
  String get l_public_key_exported => '公開鍵がエクスポートされました';

  @override
  String get l_export_certificate => '証明書をエクスポート';

  @override
  String get l_export_certificate_file => '証明書をファイルにエクスポート';

  @override
  String get l_export_certificate_desc => '証明書をファイルにエクスポートします';

  @override
  String get l_certificate_exported => '証明書をエクスポートしました';

  @override
  String get l_select_import_file => 'インポートするファイルの選択';

  @override
  String get l_import_file => 'ファイルをインポート';

  @override
  String get l_import_desc => '鍵と証明書をインポートします';

  @override
  String get l_import_nothing => 'インポートするものがありません';

  @override
  String get l_importing_file => 'ファイルをインポートしています…';

  @override
  String get s_file_imported => 'ファイルをインポートしました';

  @override
  String get l_unsupported_key_type => '対応していない鍵の種類です';

  @override
  String get l_delete_certificate => '証明書を削除';

  @override
  String get q_delete_certificate => '証明書を削除しますか？';

  @override
  String get l_delete_certificate_desc => 'YubiKey から証明書を削除します';

  @override
  String get l_delete_key => '鍵を削除';

  @override
  String get q_delete_key => '鍵を削除しますか？';

  @override
  String get l_delete_key_desc => 'YubiKey から鍵を削除します';

  @override
  String get l_delete_certificate_or_key => '証明書/鍵を削除';

  @override
  String get q_delete_certificate_or_key => '証明書/鍵を削除しますか？';

  @override
  String get l_delete_certificate_or_key_desc => 'YubiKey から証明書または鍵を削除します';

  @override
  String get l_move_key => '鍵を移動';

  @override
  String get l_move_key_desc => '鍵を別の PIV スロットにキーを移動します';

  @override
  String get l_change_defaults => 'デフォルトのアクセスコードを変更する';

  @override
  String get s_issuer => '発行者';

  @override
  String get s_serial => 'シリアル';

  @override
  String get s_certificate_fingerprint => 'フィンガープリント';

  @override
  String get s_valid_from => '発効';

  @override
  String get s_valid_to => '失効';

  @override
  String get l_no_certificate => '証明書は読み込まれませんでした';

  @override
  String get l_key_no_certificate => '証明書のない鍵を読み込みました';

  @override
  String get s_generate_key => '鍵を生成';

  @override
  String get l_generate_desc => '新しい証明書または CSR を生成します';

  @override
  String p_generate_desc(String slot) {
    return 'Yubikey の PIV スロット $slot に新しい鍵を生成します。';
  }

  @override
  String get s_private_key_generated => '秘密鍵が生成されました';

  @override
  String get p_select_what_to_delete => '削除するものをスロットから選択してください。';

  @override
  String get p_warning_delete_certificate => '警告！YubiKey から証明書が削除されます。';

  @override
  String get p_warning_delete_key => '警告！YubiKeyから秘密鍵を削除します。';

  @override
  String get p_warning_delete_certificate_and_key =>
      '警告！証明書と秘密鍵を YubiKey から削除します。';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'PIV スロット $slot の証明書を削除します。';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'PIV スロット $slot の秘密鍵を削除します。';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'PIV スロット $slot の証明書と秘密鍵を削除します。';
  }

  @override
  String get l_certificate_deleted => '証明書を削除しました';

  @override
  String get l_key_deleted => '鍵を削除しました';

  @override
  String get l_certificate_and_key_deleted => '証明書と鍵を削除しました';

  @override
  String get l_include_certificate => '証明書を含める';

  @override
  String get l_select_destination_slot => '移動先のスロットを選択';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'PIVスロット $from_slot の秘密鍵を移動しますか？';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'PIVスロット $from_slot の秘密鍵をスロット $to_slot に移動しますか？';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'PIV スロット $from_slot の秘密鍵と証明書をスロット $to_slot に移動しますか？';
  }

  @override
  String get p_password_protected_file => '選択したファイルはパスワードで保護されています。';

  @override
  String p_import_items_desc(String slot) {
    return '以下のアイテムがPIVスロット$slotにインポートされます。';
  }

  @override
  String get l_warning_public_key_mismatch => '証明書の公開鍵がスロットにある秘密鍵と一致しません';

  @override
  String get l_key_moved => '鍵が移動されました';

  @override
  String get l_key_and_certificate_moved => '鍵と証明書が移動されました';

  @override
  String get p_subject_desc => 'RFC 4514仕様に準拠した形式の識別名（DN）。';

  @override
  String get l_rfc4514_invalid => '無効なRFC 4514形式';

  @override
  String get rfc4514_examples =>
      '例:\nCN=Example Name CN=jsmith,DC=example,\nDC=net';

  @override
  String get s_allow_fingerprint => '指紋認証を許可する';

  @override
  String get s_pin_policy => 'PIN ポリシー';

  @override
  String get s_output_format => '出力フォーマット';

  @override
  String get s_expiration_date => '有効期限';

  @override
  String get p_algorithm_desc => '使用する鍵アルゴリズム。';

  @override
  String get p_expiration_date_desc => '証明書が失効する日付、デフォルトでは 1 年 (証明書のみ)。';

  @override
  String get p_key_options_bio_desc => 'PIN の代わりに生体認証を使用できるようにします。';

  @override
  String get q_overwrite_slot => 'スロットを上書きしますか？';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'これにより、スロット $slot 内の既存コンテンツが完全に上書きされます。';
  }

  @override
  String get l_overwrite_cert => '証明書が上書きされます';

  @override
  String get l_overwrite_key => '秘密鍵が上書きされます';

  @override
  String get l_overwrite_key_maybe => 'スロット内の既存の秘密鍵がすべて上書きされます';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => '認証';

  @override
  String get s_slot_9c => 'デジタル署名';

  @override
  String get s_slot_9d => '鍵管理';

  @override
  String get s_slot_9e => 'カード認証';

  @override
  String get s_retired_slot => '以前の鍵の管理';

  @override
  String get s_otp_slot_one => '短くタッチ';

  @override
  String get s_otp_slot_two => '長くタッチ';

  @override
  String get l_otp_slot_empty => 'スロットは空です';

  @override
  String get l_otp_slot_configured => 'このスロットは設定済みです';

  @override
  String get l_yubiotp_desc => 'Yubico OTP 資格情報をプログラムします';

  @override
  String get s_challenge_response => 'チャレンジレスポンス';

  @override
  String get l_challenge_response_desc => 'チャレンジレスポンス資格情報をプログラムします';

  @override
  String get s_static_password => '静的パスワード';

  @override
  String get l_static_password_desc => '静的パスワードを設定します';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'HMAC-SHA1 ベースの資格情報をプログラムします';

  @override
  String get s_public_id => '公開 ID';

  @override
  String get s_private_id => '非公開 ID';

  @override
  String get s_use_serial => 'シリアルを使用する';

  @override
  String get l_select_file => 'ファイルを選択';

  @override
  String get l_no_export_file => 'エクスポートファイルなし';

  @override
  String get s_no_export => 'エクスポートなし';

  @override
  String get s_export => 'エクスポート';

  @override
  String get l_export_configuration_file => '設定をファイルにエクスポート';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'エクスポートした資格情報は $url にアップロードできます';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'キーボード $layout';
  }

  @override
  String get s_delete_slot => '資格情報を削除する';

  @override
  String get q_delete_slot => '資格情報を削除しますか？';

  @override
  String get l_delete_slot_desc => 'スロット内の資格情報を削除します';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return '警告！スロット $slot_id から資格情報が完全に削除されます。';
  }

  @override
  String get l_slot_deleted => '資格情報を削除しました';

  @override
  String get s_swap => '交換';

  @override
  String get s_swap_slots => 'スロットの交換';

  @override
  String get q_swap_slots => 'スロットを交換しますか？';

  @override
  String get l_swap_slots_desc => '短いタッチ/長いタッチを交換します';

  @override
  String get p_swap_slots_desc => '2 つのスロットの設定内容が交換されます。';

  @override
  String get l_slots_swapped => 'スロットの設定内容を交換しました';

  @override
  String l_slot_credential_configured(String type) {
    return '$type 資格情報を設定しました';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return '$type 資格情報を設定し、$file にエクスポートしました';
  }

  @override
  String get s_append_enter => '⏎ を追加';

  @override
  String get l_append_enter_desc => 'OTP を発行した後に Enter キーストロークを追加します';

  @override
  String get p_otp_swap_error =>
      'スロットを交換できませんでした！YubiKey がアクセス制限されていないことを確認してください。';

  @override
  String get l_wrong_access_code => 'アクセスコードが間違っています';

  @override
  String get s_access_code => 'アクセスコード';

  @override
  String get s_show_access_code => 'アクセスコードを表示';

  @override
  String get s_hide_access_code => 'アクセスコードを隠す';

  @override
  String p_enter_access_code(String slot) {
    return 'スロット $slot のアクセスコードを入力してください。';
  }

  @override
  String get s_enable_nfc => 'NFCを有効にする';

  @override
  String get s_request_access => 'アクセスを要求する';

  @override
  String get s_permission_denied => '権限が拒否されました';

  @override
  String get l_elevating_permissions => '権限を取得しています…';

  @override
  String get s_review_permissions => '権限を確認';

  @override
  String get s_open_windows_settings => 'Windows の設定を開く';

  @override
  String get l_admin_privileges_required => '管理者権限が必要です';

  @override
  String get p_elevated_permissions_required => 'このデバイスを管理するには管理者権限が必要です。';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'WebAuthn の管理には管理者権限が必要です。';

  @override
  String get l_ms_store_permission_note =>
      'Microsoft Store 版では、権限を取得できない可能性があります';

  @override
  String get p_need_camera_permission =>
      'QR コードをスキャンするには、Yubico Authenticator にカメラへのアクセスを許可してください。';

  @override
  String get s_qr_scan => 'QR コードをスキャン';

  @override
  String get l_invalid_qr => 'QR コードが無効です';

  @override
  String get l_qr_not_found => 'QR コードが見つかりません';

  @override
  String get l_qr_scanned => 'QR コードをスキャンしました';

  @override
  String l_qr_file_too_large(String max) {
    return 'ファイルが大きすぎます (最大 $max)';
  }

  @override
  String get l_qr_invalid_image_file => '画像ファイルが無効です';

  @override
  String get l_qr_select_file => 'QR コードを含むファイルを選択してください';

  @override
  String l_qr_not_read(String message) {
    return 'QRコードの読み取りに失敗しました: $message';
  }

  @override
  String get l_point_camera_scan => 'カメラを QR コードに向けてスキャンしてください';

  @override
  String get q_want_to_scan => 'スキャンしますか？';

  @override
  String get q_no_qr => 'QR コードがありませんか？';

  @override
  String get s_enter_manually => '手動で入力';

  @override
  String get s_read_from_file => 'ファイルから読み取る';

  @override
  String get s_reset => 'リセット';

  @override
  String get s_factory_reset => '工場出荷時の状態にリセット';

  @override
  String get l_factory_reset_desc => 'YubiKey の既定値を復元します';

  @override
  String get l_factory_reset_required => '工場出荷時の状態にリセットする必要があります';

  @override
  String get l_oath_application_reset => 'OATH アプリケーションのリセット';

  @override
  String get l_fido_app_reset => 'FIDO アプリケーションのリセット';

  @override
  String l_reset_failed(String message) {
    return 'リセットの実行エラー: $message';
  }

  @override
  String get l_piv_app_reset => 'PIV アプリケーションのリセット';

  @override
  String get p_factory_reset_an_app => 'YubiKey のアプリケーションを工場出荷時の状態にリセットします。';

  @override
  String get p_factory_reset_desc =>
      'データが YubiKey の複数のアプリケーションに保存されています。一部のアプリケーションは、単独で工場出荷時の状態にリセットできます。\n\n上のボタンからリセットしたいアプリケーションを選択してください。';

  @override
  String get p_warning_factory_reset =>
      '警告！すべての OATH TOTP/HOTP アカウントが YubiKey から削除されます。削除されたデータは回復できません。';

  @override
  String get p_warning_disable_credentials =>
      'あなたの OATH 認証情報、および設定されているパスワードは、この YubiKey から削除されます。アカウントにログインできなくならないように、それぞれのウェブサイトから該当する認証情報を無効にしてください。';

  @override
  String get p_warning_deletes_accounts =>
      '警告！パスキーを含めたすべての U2F および FIDO2 アカウントが YubiKey から削除されます。削除されたデータは回復できません。';

  @override
  String get p_warning_disable_accounts =>
      'あなたの認証情報および設定された PIN は、この YubiKey から削除されます。アカウントにログインできなくならないように、それぞれのウェブサイトから該当する認証情報を無効にしてください。';

  @override
  String get p_warning_piv_reset =>
      '警告！PIV に保存されたすべてのデータが YubiKey から削除されます。削除されたデータは回復できません。';

  @override
  String get p_warning_piv_reset_desc =>
      '秘密鍵と証明書が含まれます。PIN、PUK、および管理キーが工場出荷時のデフォルト値にリセットされます。';

  @override
  String get p_warning_global_reset =>
      '警告！資格情報を含めた保存されているすべてのデータが YubiKey から削除されます。削除されたデータは回復できません。';

  @override
  String get p_warning_global_reset_desc =>
      'YubiKey のアプリケーションを工場出荷時の状態にリセットします。PIN は工場出荷時のデフォルト値にリセットされ、登録されていた指紋は削除されます。鍵、証明書、その他の認証情報はすべて完全に削除されます。';

  @override
  String get l_copy_to_clipboard => 'クリップボードにコピー';

  @override
  String get s_code_copied => 'コードをコピーしました';

  @override
  String get l_code_copied_clipboard => 'コードをクリップボードにコピーしました';

  @override
  String get s_copy_log => 'ログをコピー';

  @override
  String get l_log_copied => 'ログをクリップボードにコピーしました';

  @override
  String get l_diagnostics_copied => '診断データをクリップボードにコピーしました';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label をクリップボードにコピーしました。';
  }

  @override
  String get s_custom_icons => 'カスタムアイコン';

  @override
  String get l_set_icons_for_accounts => 'アカウントのアイコンを設定します';

  @override
  String get p_custom_icons_description =>
      'アイコンパックを使用すると、見慣れたロゴや色が表示されてアカウントを識別しやすくなります。';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'アイコンパックは、$aegis_icon_pack フォーマットを使用しています。既存のアイコンパックをダウンロードすることも、新たに作成することもできます。';
  }

  @override
  String get s_replace_icon_pack => '別のアイコンパックを選択';

  @override
  String get l_loading_icon_pack => 'アイコンパックを読み込んでいます…';

  @override
  String get s_load_icon_pack => 'アイコンパックを読み込む';

  @override
  String get s_remove_icon_pack => 'アイコンパックを削除します';

  @override
  String get l_icon_pack_removed => 'アイコンパックを削除しました';

  @override
  String get l_remove_icon_pack_failed => 'アイコンパックの削除エラー';

  @override
  String get s_choose_icon_pack => 'アイコンパックの選択';

  @override
  String get l_icon_pack_imported => 'アイコンパックをインポートしました';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'アイコンパックのインポートエラー: $message';
  }

  @override
  String get l_invalid_icon_pack => 'アイコンパックが無効です';

  @override
  String get l_icon_pack_copy_failed => 'アイコンパックファイルをコピーできませんでした';

  @override
  String get s_nfc_options => 'NFCオプション';

  @override
  String get l_on_yk_nfc_tap => 'YubiKey NFCのタップ時の動作';

  @override
  String get l_do_nothing => '何もしない';

  @override
  String get l_launch_ya => 'Yubico Authenticator を起動';

  @override
  String get l_copy_otp_clipboard => 'OTP をクリップボードにコピー';

  @override
  String get l_launch_and_copy_otp => 'アプリを起動してOTPをコピー';

  @override
  String get l_kbd_layout_for_static => 'キーボードレイアウト (静的パスワード用)';

  @override
  String get s_choose_kbd_layout => 'キーボードレイアウトを選択';

  @override
  String get l_bypass_touch_requirement => 'タッチ要件をバイパスする';

  @override
  String get l_bypass_touch_requirement_on => 'タッチが必要なアカウントがNFCを介して自動的に表示されます';

  @override
  String get l_bypass_touch_requirement_off =>
      'タッチが必要なアカウントはNFCを介して追加のタップが必要です';

  @override
  String get s_silence_nfc_sounds => 'NFC 通知音を鳴らさない';

  @override
  String get l_silence_nfc_sounds_on => 'NFC にかざしても音声を再生しません';

  @override
  String get l_silence_nfc_sounds_off => 'NFC にかざすと音声を再生します';

  @override
  String get s_usb_options => 'USBオプション';

  @override
  String get l_launch_app_on_usb => 'YubiKey の接続で起動する';

  @override
  String get l_launch_app_on_usb_on =>
      'これにより、他のアプリが USB 経由で YubiKey を使用できなくなります';

  @override
  String get l_launch_app_on_usb_off => '他のアプリは USB 経由で YubiKey を使用できます';

  @override
  String get s_allow_screenshots => 'スクリーンショットを許可する';

  @override
  String get s_nfc_ready_to_scan => 'スキャンの準備完了';

  @override
  String get s_nfc_hold_still => 'そのまま保持してください…';

  @override
  String get s_nfc_tap_your_yubikey => 'YubiKey をタップしてください';

  @override
  String get l_nfc_failed_to_scan => 'スキャンに失敗しました。もう一度お試しください';

  @override
  String get s_usb_processing => 'YubiKey からデータを読み込み中';

  @override
  String get s_usb_dont_remove => 'キーを取り外さないでください…';

  @override
  String get l_usb_read_error => 'YubiKey からデータを読み込めませんでした';

  @override
  String get p_ndef_set_otp => 'OTP コードを YubiKey からクリップボードにコピーしました。';

  @override
  String get p_ndef_set_password => 'パスワードを YubiKey からクリップボードにコピーしました。';

  @override
  String get p_ndef_parse_failure => 'YubiKey から OTP コードを解析できませんでした。';

  @override
  String get p_ndef_set_clip_failure =>
      'OTP コードを YubiKey からコピーしようと試みましたが、クリップボードにアクセスできませんでした。';

  @override
  String get s_set_label => 'ラベルを設定します';

  @override
  String get s_set_color => '色を設定';

  @override
  String get s_change_label => 'ラベルを変更します';

  @override
  String get p_set_will_add_custom_name => 'YubiKey に任意の名前を付けます。';

  @override
  String get p_rename_will_change_custom_name => 'YubiKey のラベルを変更します。';

  @override
  String get s_shortcuts => 'Shortcuts';

  @override
  String get s_keyboard_shortcuts => 'Keyboard shortcuts';

  @override
  String get s_global_shortcuts => 'Global shortcuts';

  @override
  String get s_application_shortcuts => 'Application shortcuts';

  @override
  String s_quit_app(String app) {
    return 'Quit $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Hide $app';
  }

  @override
  String get s_search => 'Search';

  @override
  String get s_next_device => 'Next device';

  @override
  String get s_previous_device => 'Previous device';

  @override
  String get s_open_settings => 'Open settings';

  @override
  String get s_open_help_and_about => 'Open help and about';

  @override
  String get s_open_item => 'Open item';

  @override
  String get s_edit_item => 'Edit item';

  @override
  String get s_delete_item => 'Delete item';

  @override
  String get s_calculate_oath_code => 'Calculate OATH code';

  @override
  String get s_open_keyboard_shortcuts => 'Open keyboard shortcuts';
}
