// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Français';

  @override
  String s_translated(int percentage) {
    return 'Traduit : $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Relecture : $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Traduction incomplète';

  @override
  String get p_translation_progress_desc =>
      'Les indicateurs de progrès reflètent la maturité de la traduction.';

  @override
  String get s_save => 'Enregistrer';

  @override
  String get s_cancel => 'Annuler';

  @override
  String get s_close => 'Fermer';

  @override
  String get s_delete => 'Supprimer';

  @override
  String get s_move => 'Déplacer';

  @override
  String get s_quit => 'Quitter';

  @override
  String get s_enable => 'Activer';

  @override
  String get s_enabled => 'Activé';

  @override
  String get s_disabled => 'Désactivé';

  @override
  String get s_status => 'État';

  @override
  String get s_unlock => 'Déverrouiller';

  @override
  String get s_calculate => 'Calculer';

  @override
  String get s_import => 'Importer';

  @override
  String get s_overwrite => 'Écraser';

  @override
  String get s_done => 'Terminé';

  @override
  String get s_label => 'Étiquette';

  @override
  String get s_name => 'Nom';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Paramètres';

  @override
  String get s_details => 'Détails';

  @override
  String get s_show_window => 'Montrer fenêtre';

  @override
  String get s_hide_window => 'Masquer fenêtre';

  @override
  String get s_show_navigation => 'Afficher la navigation';

  @override
  String get s_expand_navigation => 'Développer la barre de navigation';

  @override
  String get s_collapse_navigation => 'Replier la barre de navigation';

  @override
  String get s_expand_collapse_navigation =>
      'Développer/réduire la barre de navigation';

  @override
  String get s_show_menu => 'Afficher le menu';

  @override
  String get s_toggle_menu_bar => 'Basculer la barre de menu';

  @override
  String get s_more_info => 'Plus d\'infos';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<aucun>';

  @override
  String get s_about => 'Infos';

  @override
  String get s_algorithm => 'Algorithme';

  @override
  String get s_appearance => 'Apparence';

  @override
  String get s_actions => 'Actions';

  @override
  String get s_manage => 'Gérer';

  @override
  String get s_setup => 'Configuration';

  @override
  String get s_device => 'Appareil';

  @override
  String get s_application => 'Application';

  @override
  String get s_settings => 'Réglages';

  @override
  String get l_settings_desc => 'Modifier les préférences de l\'application';

  @override
  String get s_certificates => 'Certificats';

  @override
  String get s_security_key => 'Clé de sécurité';

  @override
  String get s_slots => 'Slots';

  @override
  String get s_help_and_about => 'Aide et à propos';

  @override
  String get l_help_and_about_desc => 'Dépannage et assistance';

  @override
  String get s_help_and_feedback => 'Aide/commentaires';

  @override
  String get s_home => 'Accueil';

  @override
  String get s_user_guide => 'Guide d\'utilisation';

  @override
  String get s_i_need_help => 'J\'ai besoin d\'aide';

  @override
  String get s_troubleshooting => 'Dépannage';

  @override
  String get s_terms_of_use => 'Conditions d\'utilisation';

  @override
  String get s_privacy_policy => 'Confidentialité';

  @override
  String get s_open_src_licenses => 'Licences Open Source';

  @override
  String get s_please_wait => 'Patientez…';

  @override
  String get s_secret_key => 'Clé secrète';

  @override
  String get s_show_secret_key => 'Afficher clé secrète';

  @override
  String get s_hide_secret_key => 'Masquer clé secrète';

  @override
  String get s_private_key => 'Clé privée';

  @override
  String get s_public_key => 'Clé publique';

  @override
  String get s_invalid_length => 'Longueur invalide';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Format invalide, caractères autorisés : $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Caractères invalides pour clavier sélectionné';

  @override
  String get s_require_touch => 'Toucher requis';

  @override
  String get q_have_account_info => 'Vous avez des infos d\'identification ?';

  @override
  String get s_run_diagnostics => 'Exécuter diagnostics';

  @override
  String s_log_level(String level) {
    return 'Niveau de journalisation : $level';
  }

  @override
  String get s_character_count => 'Nombre caractères';

  @override
  String get s_language => 'Langue';

  @override
  String p_community_translations_desc(String crowdin) {
    return 'Les traductions sont gérées par la communauté sur $crowdin.';
  }

  @override
  String get s_choose_language => 'Sélectionner une langue';

  @override
  String get s_app_theme => 'Thème de l\'application';

  @override
  String get s_choose_app_theme => 'Choisir un thème';

  @override
  String get s_system_default => 'Système par défaut';

  @override
  String get s_light_mode => 'Thème clair';

  @override
  String get s_dark_mode => 'Thème sombre';

  @override
  String get s_list_layout => 'Présentation de la liste';

  @override
  String get s_grid_layout => 'Disposition de la grille';

  @override
  String get s_mixed_layout => 'Disposition mixte';

  @override
  String get s_select_layout => 'Sélectionner la mise en page';

  @override
  String get s_select_to_scan => 'Sélectionner pour scanner';

  @override
  String get s_hide_reader => 'Cacher le lecteur';

  @override
  String get s_show_hidden_readers => 'Afficher les lecteurs cachés';

  @override
  String get s_toggle_readers => 'Activer/désactiver les lecteurs';

  @override
  String get l_toggle_readers_desc => 'Afficher ou masquer les lecteurs';

  @override
  String s_sn_serial(int serial) {
    return 'N/S : $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W : $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Numéro de série : $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Version du firmware : $version';
  }

  @override
  String get l_fips_capable => 'Compatible FIPS';

  @override
  String get l_fips_approved => 'Approuvé par FIPS';

  @override
  String get l_insert_yk => 'Insérez votre YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Insérez ou appuyez sur YubiKey';

  @override
  String get l_unplug_yk => 'Retirez votre YubiKey';

  @override
  String get l_reinsert_yk => 'Réinsérez votre YubiKey';

  @override
  String get l_place_on_nfc_reader => 'Placez votre YubiKey sur le lecteur NFC';

  @override
  String get l_replace_yk_on_reader => 'Replacez votre YubiKey sur le lecteur';

  @override
  String get l_remove_yk_from_reader => 'Retirez votre YubiKey du lecteur NFC';

  @override
  String get p_try_reinsert_yk =>
      'Essayez de retirer et de réinsérer votre YubiKey.';

  @override
  String get s_touch_required => 'Toucher requis';

  @override
  String get l_touch_button_now => 'Touchez le bouton de votre YubiKey';

  @override
  String get l_keep_touching_yk => 'Touchez votre YubiKey plusieurs fois…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Parcourir applications';

  @override
  String get s_toggle_interfaces => 'Parcourir interfaces';

  @override
  String get p_toggle_applications_desc =>
      'Activer ou désactiver les applications sur les transports disponibles.';

  @override
  String get p_toggle_interfaces_desc =>
      'Activer ou désactiver les interfaces USB.';

  @override
  String get l_toggle_applications_desc =>
      'Activer/désactiver des applications';

  @override
  String get l_toggle_interfaces_desc => 'Activer/Désactiver les interfaces';

  @override
  String get s_reconfiguring_yk => 'Reconfiguration YubiKey…';

  @override
  String get s_config_updated => 'Configuration mise à jour';

  @override
  String get l_config_updated_reinsert =>
      'Configuration mise à jour, retirez et réinsérez votre YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 désactivé';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn nécessite que FIDO2 soit activé sur votre YubiKey';

  @override
  String get s_lock_code => 'Code de verrouillage';

  @override
  String get l_wrong_lock_code => 'Code de verrouillage erroné';

  @override
  String get s_show_lock_code => 'Afficher le code de verrouillage';

  @override
  String get s_hide_lock_code => 'Cacher le code de verrouillage';

  @override
  String get p_lock_code_required_desc =>
      'L\'action que vous êtes sur le point d\'effectuer nécessite la saisie du code de verrouillage de la configuration.';

  @override
  String get l_helper_not_responding => 'Le processus d\'aide ne répond pas';

  @override
  String get l_yk_no_access => 'Accès à cette YubiKey impossible';

  @override
  String get s_yk_inaccessible => 'Appareil inaccessible';

  @override
  String get l_open_connection_failed => 'Impossible d\'ouvrir la connexion';

  @override
  String get l_ccid_connection_failed =>
      'Impossible d\'ouvrir la connexion de la carte à puce';

  @override
  String get p_ccid_service_unavailable =>
      'Vérifiez que votre service de carte à puce fonctionne.';

  @override
  String get p_pcscd_unavailable =>
      'Vérifiez que pcscd est installé et en cours d\'exécution.';

  @override
  String get l_no_yk_present => 'Aucune YubiKey présente';

  @override
  String get s_unknown_type => 'Type inconnu';

  @override
  String get s_unknown_device => 'Appareil non reconnu';

  @override
  String get s_restricted_nfc => 'Activation NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Comment activer le NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Connectez votre YubiKey à une source d\'alimentation USB, telle qu\'un ordinateur, pendant au moins 3 secondes.\n\nUne fois alimentée, le NFC sera activé et prêt à l\'emploi.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Votre YubiKey est équipé d\'une fonction NFC restreinte, conçue pour éviter les manipulations sans fil pendant le transport. Cela signifie que les opérations NFC sont temporairement désactivées jusqu\'à ce que vous les activiez.';

  @override
  String get s_unsupported_yk => 'YubiKey non prise en charge';

  @override
  String get p_operation_failed_try_again =>
      'L\'opération a échoué, veuillez réessayer.';

  @override
  String get l_configuration_unsupported =>
      'La configuration n\'est pas prise en charge';

  @override
  String get p_scp_unsupported =>
      'Pour communiquer par NFC, la YubiKey nécessite une technologie qui n\'est pas prise en charge par ce téléphone. Veuillez brancher la YubiKey sur le port USB du téléphone.';

  @override
  String get l_error_occurred => 'Une erreur s\'est produite';

  @override
  String get s_application_error => 'Erreur d\'application';

  @override
  String get l_import_error => 'Erreur importation';

  @override
  String get l_file_not_found => 'Fichier introuvable';

  @override
  String get l_file_too_big => 'Fichier trop gros';

  @override
  String get l_filesystem_error => 'Erreur du système de fichiers';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Définir PIN';

  @override
  String get s_change_pin => 'Modifier PIN';

  @override
  String get s_change_puk => 'Modifier PUK';

  @override
  String get s_show_pin => 'Montrer PIN';

  @override
  String get s_hide_pin => 'Masquer PIN';

  @override
  String get s_show_puk => 'Montrer PUK';

  @override
  String get s_hide_puk => 'Masquer PUK';

  @override
  String get s_current_pin => 'PIN actuel';

  @override
  String get s_current_puk => 'PUK actuel';

  @override
  String get s_new_pin => 'Nouveau PIN';

  @override
  String get s_new_puk => 'Nouveau PUK';

  @override
  String get s_confirm_pin => 'Confirmer PIN';

  @override
  String get s_confirm_puk => 'Confirmer PUK';

  @override
  String get s_unblock_pin => 'Réinitialiser PIN';

  @override
  String get l_pin_mismatch => 'Les codes PIN ne correspondent pas';

  @override
  String get l_puk_mismatch => 'Les PUK ne correspondent pas';

  @override
  String get s_pin_set => 'PIN défini';

  @override
  String get s_puk_set => 'PUK défini';

  @override
  String l_set_pin_failed(String message) {
    return 'Impossible de définir PIN : $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries tentatives restantes',
      one: '$retries tentative restante',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries tentatives restantes',
      one: '$retries tentative restante',
    );
    return 'PIN erroné, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries tentatives restantes',
      one: '$retries tentative restante',
    );
    return 'PUK erroné, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'Protection PIN FIDO';

  @override
  String get s_pin_change_required => 'Changement PIN requise';

  @override
  String get l_enter_fido2_pin => 'Saisissez le PIN FIDO2 de votre YubiKey';

  @override
  String get l_pin_blocked_reset =>
      'PIN bloqué, réinitialisez FIDO aux paramètres d\'usine';

  @override
  String get l_pin_blocked => 'Le code PIN est bloqué';

  @override
  String get l_set_pin_first => 'Un code PIN est nécessaire';

  @override
  String get l_unlock_pin_first => 'Déverrouiller avec un code PIN';

  @override
  String get l_pin_soft_locked =>
      'PIN bloqué jusqu\'à ce que la YubiKey soit retirée et réinsérée';

  @override
  String get l_pin_change_required_desc =>
      'Vous devez créer un nouveau PIN avant d\'utiliser cette appli';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'Le code PIN doit être composé de $min_length-$max_length caractères et peut contenir des lettres, des chiffres et des caractères spéciaux.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'Le code PIN doit être composé de $min_length-$max_length caractères, contenir au moins $unique_characters caractères uniques et ne pas être un code PIN couramment utilisé, comme \"$common_pin\". Il peut contenir des lettres, des chiffres et des caractères spéciaux.';
  }

  @override
  String get s_ep_attestation => 'Attestation d\'entreprise';

  @override
  String get s_ep_attestation_enabled => 'Attestation d\'entreprise activée';

  @override
  String get q_enable_ep_attestation =>
      'Activer l\'Attestation d\'Entreprise ?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Cela activera l\'Attestation d\'Entreprise, permettant aux domaines autorisés d\'identifier votre YubiKey de manière unique.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Une fois activée, l\'attestation d\'entreprise ne peut être désactivée qu\'en procédant à une réinitialisation d\'usine de FIDO.';

  @override
  String get s_pin_required => 'PIN requis';

  @override
  String get p_pin_required_desc =>
      'L\'action que vous allez effectuer nécessite la saisie du PIN PIV.';

  @override
  String get l_piv_pin_blocked => 'Bloqué, utilisez PUK pour réinitialiser';

  @override
  String get p_piv_pin_blocked_desc =>
      'Le code PIN est bloqué. Utilisez le code PUK pour le réinitialiser.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'Le code PIN est bloqué. Une réinitialisation d\'usine est requise.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Bloqué, réinitialisation aux paramètres d\'usine nécessaire';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Le code PIN et le code PUK sont tous deux bloqués. Une réinitialisation d\'usine de l\'application PIV est nécessaire.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'Le $name doit avoir au moins $length caractères.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'Un code $name doit être composé d\'au moins $length caractères, contenir au moins 2 caractères uniques et ne pas être un $name couramment utilisé, comme \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Le nouveau $name ne répond pas aux exigences de complexité.';
  }

  @override
  String get s_dismiss => 'Fermer';

  @override
  String get p_default_pin_puk_key_desc =>
      'Il est recommandé de changer le code PIN, le code PUK et la clé de gestion par défaut.';

  @override
  String get l_warning_default_pin =>
      'Avertissement : Code PIN par défaut utilisé';

  @override
  String get l_warning_default_puk => 'Attention : PUK par défaut utilisé';

  @override
  String get l_default_pin_used => 'Code PIN par défaut utilisé';

  @override
  String get l_default_puk_used => 'PUK par défaut utilisé';

  @override
  String get l_pin_complexity => 'Complexité du code PIN appliquée';

  @override
  String get s_password => 'Mot de passe';

  @override
  String get s_manage_password => 'Gérer mot de passe';

  @override
  String get s_set_password => 'Créer mot de passe';

  @override
  String get s_password_set => 'Mot de passe créé';

  @override
  String get s_show_password => 'Montrer mot de passe';

  @override
  String get s_hide_password => 'Masquer mot de passe';

  @override
  String get l_password_protection => 'Protection des comptes par mot de passe';

  @override
  String get s_new_password => 'Nouveau mot de passe';

  @override
  String get s_current_password => 'Mot de passe actuel';

  @override
  String get s_confirm_password => 'Confirmer mot de passe';

  @override
  String get l_password_mismatch => 'Les mots de passe ne correspondent pas';

  @override
  String get s_wrong_password => 'Mot de passe incorrect';

  @override
  String get p_wrong_password =>
      'Mot de passe erroné. Si vous ne connaissez pas votre mot de passe, vous devez réinitialiser la YubiKey.';

  @override
  String get s_remove_password => 'Supprimer mot de passe';

  @override
  String get s_password_removed => 'Mot de passe supprimé';

  @override
  String get s_remember_password => 'Mémoriser mot de passe';

  @override
  String get s_clear_saved_password => 'Effacer mot de passe enregistré';

  @override
  String get s_password_forgotten => 'Mot de passe oublié';

  @override
  String get l_keystore_unavailable => 'OS Keystore indisponible';

  @override
  String get l_remember_pw_failed => 'Mémorisation mot de passe impossible';

  @override
  String get l_unlock_first => 'Déverrouillage par mot de passe';

  @override
  String get l_set_password_first => 'Définir un mot de passe';

  @override
  String get l_enter_oath_pw =>
      'Saisissez le mot de passe OATH de votre YubiKey';

  @override
  String get p_new_password_requirements =>
      'Un mot de passe peut contenir des lettres, des chiffres et des caractères spéciaux.';

  @override
  String get s_management_key => 'Clé de gestion';

  @override
  String get s_current_management_key => 'Clé de gestion actuelle';

  @override
  String get s_new_management_key => 'Nouvelle clé de gestion';

  @override
  String get l_change_management_key => 'Changer clé de gestion';

  @override
  String get l_management_key_changed => 'Clé de gestion changée';

  @override
  String get l_default_key_used => 'Clé de gestion par défaut utilisée';

  @override
  String get s_generate_random => 'Génération aléatoire';

  @override
  String get s_use_default => 'Utiliser clé par défaut';

  @override
  String get l_warning_default_key => 'Attention : clé par défaut utilisée';

  @override
  String get s_protect_key => 'Protéger par PIN';

  @override
  String get p_protect_key_desc =>
      'Utilisez le code PIN à la place de la clé de gestion lors d\'opérations nécessitant l\'authentification de la clé de gestion.';

  @override
  String get s_management_key_algorithm => 'Algorithme de la clé de gestion';

  @override
  String get p_management_key_algorithm_desc =>
      'L\'algorithme à choisir pour la clé de gestion.';

  @override
  String get l_pin_protected_key => 'PIN peut être utilisé à la place';

  @override
  String get l_wrong_key => 'Clé incorrecte';

  @override
  String get l_unlock_piv_management => 'Débloquer gestion PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'L\'action que vous allez effectuer nécessite la clé de gestion PIV.';

  @override
  String l_account(String label) {
    return 'Compte : $label';
  }

  @override
  String get s_accounts => 'Comptes';

  @override
  String get s_no_accounts => 'Aucun compte';

  @override
  String l_results_for(String query) {
    return 'Résultats pour \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Démarrer avec les comptes OTP';

  @override
  String get l_no_accounts_desc =>
      'Ajoutez à votre YubiKey des comptes de fournisseurs prenant en charge OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Ajouter compte';

  @override
  String get p_add_account_desc =>
      'Scannez le code QR ou saisissez les informations d\'identification manuellement.';

  @override
  String get s_add_accounts => 'Ajouter compte(s)';

  @override
  String get l_drop_qr_description =>
      'Supprimer code QR pour ajouter compte(s)';

  @override
  String get p_add_account_three_ways =>
      'Il y a trois façons d\'ajouter des comptes.';

  @override
  String get s_scanning => 'Scanner (recommandé)';

  @override
  String get p_scanning_desc =>
      'Avant de scanner un code QR, assurez-vous que le code complet soit visible à l\'écran.';

  @override
  String get s_drag_and_drop => 'Glisser-déposer';

  @override
  String get p_drag_and_drop_desc =>
      'Une image contenant un code QR peut être déposée n\'importe où dans la vue des comptes.';

  @override
  String get s_manually => 'Manuellement';

  @override
  String get p_manually_desc =>
      'Les données d\'identification du compte peuvent être saisies manuellement dans le formulaire.';

  @override
  String get s_account_added => 'Compte ajouté';

  @override
  String l_account_add_failed(String message) {
    return 'Échec d\'ajout du compte : $message';
  }

  @override
  String get l_add_account_password_required => 'Mot de passe requis';

  @override
  String get l_add_account_unlock_required => 'Déverrouillage requis';

  @override
  String get l_add_account_already_exists => 'Le compte existe déjà';

  @override
  String get l_add_account_func_missing =>
      'Fonctionnalité manquante ou désactivée';

  @override
  String get l_account_name_required => 'Votre compte doit avoir un nom';

  @override
  String get l_name_already_exists => 'Ce nom existe déjà pour l\'émetteur';

  @override
  String get l_account_already_exists => 'Ce compte existe déjà sur la YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Caractère invalide : « : » non autorisé dans l\'émetteur';

  @override
  String get l_select_accounts =>
      'Sélectionner compte(s) à ajouter à la YubiKey';

  @override
  String get s_pin_account => 'Épingler compte';

  @override
  String get s_unpin_account => 'Détacher compte';

  @override
  String get s_no_pinned_accounts => 'Aucun compte épinglé';

  @override
  String get s_pinned => 'Épinglé';

  @override
  String get l_pin_account_desc => 'Conserver vos comptes importants ensemble';

  @override
  String get s_rename_account => 'Renommer compte';

  @override
  String get l_rename_account_desc => 'Modifier émetteur/nom du compte';

  @override
  String get s_account_renamed => 'Compte renommé';

  @override
  String l_rename_account_failed(String message) {
    return 'Échec du renommage du compte : $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Cela modifiera l\'affichage du compte dans la liste.';

  @override
  String get s_delete_account => 'Supprimer compte';

  @override
  String get q_delete_account => 'Supprimer le compte ?';

  @override
  String get l_delete_account_desc => 'Supprimer le compte de votre YubiKey';

  @override
  String get s_account_deleted => 'Compte supprimé';

  @override
  String get p_warning_delete_account =>
      'Attention ! Cela supprimera le compte de votre YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Assurez-vous de désactiver ce compte du service avec lequel il est enregistré pour éviter d\'être bloqué.';

  @override
  String get s_account_name => 'Nom du compte';

  @override
  String get s_search_accounts => 'Rechercher comptes';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used comptes sur $capacity utilisés';
  }

  @override
  String s_num_digits(int num) {
    return '$num chiffres';
  }

  @override
  String s_num_sec(int num) {
    return '$num s';
  }

  @override
  String get s_issuer_optional => 'Émetteur (facultatif)';

  @override
  String get s_counter_based => 'Basé sur compteur';

  @override
  String get s_time_based => 'Basé sur temps';

  @override
  String get l_copy_code_desc => 'Coller le code dans une autre application';

  @override
  String get l_calculate_code_desc => 'Obtenir un nouveau code YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'ID d\'utilisateur';

  @override
  String get s_credential_id => 'Credential ID';

  @override
  String get s_display_name => 'Nom affiché';

  @override
  String get s_user_name => 'Nom d\'utilisateur';

  @override
  String get s_passkeys => 'Passkeys';

  @override
  String get s_no_passkeys => 'Pas de passkeys';

  @override
  String get l_ready_to_use => 'Prête à l\'emploi';

  @override
  String get l_register_sk_on_websites =>
      'Enregistrer comme clé de sécurité sur le Web';

  @override
  String get l_no_discoverable_accounts => 'Pas de passkeys enregistrées';

  @override
  String get p_non_passkeys_note =>
      'Des identifiants non-passkey peuvent exister, mais ne peuvent pas être listés.';

  @override
  String get s_delete_passkey => 'Supprimer passkey';

  @override
  String get q_delete_passkey => 'Supprimer la clé d\'accès ?';

  @override
  String get l_delete_passkey_desc => 'Supprimer passkey de la YubiKey';

  @override
  String get s_passkey_deleted => 'Passkey supprimé';

  @override
  String get p_warning_delete_passkey =>
      'Attention ! Cette action supprimera la clé d\'accès de votre YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Vous ne pourrez plus utiliser cette clé d\'accès pour le service où elle est enregistrée.';

  @override
  String get s_search_passkeys => 'Rechercher des passkeys';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used des $max passkeys utilisées.';
  }

  @override
  String get s_biometrics => 'Biométrie';

  @override
  String l_fingerprint(String label) {
    return 'Empreinte digitale : $label';
  }

  @override
  String get s_fingerprints => 'Empreintes digitales';

  @override
  String get l_fingerprint_captured =>
      'Empreinte digitale capturée avec succès !';

  @override
  String get s_fingerprint_added => 'Empreinte digitale ajoutée';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Erreur d\'ajout d\'empreinte : $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Erreur de définition du nom : $message';
  }

  @override
  String get s_setup_fingerprints => 'Configurer empreintes digitales';

  @override
  String get p_setup_fingerprints_desc =>
      'Les empreintes digitales doivent être configurées avant d\'utiliser la clé.';

  @override
  String get s_add_fingerprint => 'Ajouter empreinte digitale';

  @override
  String get s_delete_fingerprint => 'Supprimer empreinte digitale';

  @override
  String get q_delete_fingerprint => 'Supprimer l\'empreinte digitale ?';

  @override
  String get l_delete_fingerprint_desc =>
      'Retirer l\'empreinte digitale de la YubiKey';

  @override
  String get s_fingerprint_deleted => 'Empreinte digitale supprimée';

  @override
  String get p_warning_delete_fingerprint =>
      'Cela supprimera l\'empreinte digitale de votre YubiKey.';

  @override
  String get s_fingerprints_get_started =>
      'Démarrer avec les empreintes digitales';

  @override
  String get p_set_fingerprints_desc =>
      'Créez un code PIN avant d\'enregistrer des empreintes digitales.';

  @override
  String get l_no_fps_added => 'Aucune empreinte digitale ajoutée';

  @override
  String get s_rename_fp => 'Renommer empreinte digitale';

  @override
  String get l_rename_fp_desc => 'Renommer';

  @override
  String get s_fingerprint_renamed => 'Empreinte renommée';

  @override
  String l_rename_fp_failed(String message) {
    return 'Erreur de renommage : $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Ajouter une ou plusieurs empreintes (jusqu\'à 5)';

  @override
  String l_fingerprints_used(int used) {
    return '$used empreintes sur 5 enregistrées';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Appuyez votre doigt sur la YubiKey pour commencer.';

  @override
  String get l_name_fingerprint => 'Nommer cette empreinte';

  @override
  String get l_user_action_timeout_error => 'Échec : utilisateur inactif';

  @override
  String get l_wrong_inserted_yk_error =>
      'La YubiKey réinsérée ne correspond pas à l\'appareil initial';

  @override
  String get l_failed_connecting_to_fido =>
      'Échec de connexion à l\'interface FIDO';

  @override
  String get l_self_signed_certificate => 'Certificat auto-signé';

  @override
  String get l_certificate_signing_request =>
      'Demande de signature de certificat (CSR)';

  @override
  String get s_certificate => 'Certificat';

  @override
  String get s_subject => 'Objet';

  @override
  String get l_export_csr_file => 'Enregistrer CSR dans un fichier';

  @override
  String get l_export_public_key => 'Exporter la clé publique';

  @override
  String get l_export_public_key_file =>
      'Enregistrer la clé publique dans le fichier';

  @override
  String get l_export_public_key_desc =>
      'Exporter la clé publique vers un fichier';

  @override
  String get l_public_key_exported => 'Clé publique exportée';

  @override
  String get l_export_certificate => 'Exporter certificat';

  @override
  String get l_export_certificate_file => 'Exporter certificat vers fichier';

  @override
  String get l_export_certificate_desc => 'Exporte certificat vers un fichier';

  @override
  String get l_certificate_exported => 'Certificat exporté';

  @override
  String get l_select_import_file => 'Choisir fichier à importer';

  @override
  String get l_import_file => 'Importer fichier';

  @override
  String get l_import_desc => 'Importez clé et/ou certificat';

  @override
  String get l_import_nothing => 'Rien à importer';

  @override
  String get l_importing_file => 'Importation du fichier…';

  @override
  String get s_file_imported => 'Fichier importé';

  @override
  String get l_unsupported_key_type => 'Type de clé non pris en charge';

  @override
  String get l_delete_certificate => 'Supprimer certificat';

  @override
  String get q_delete_certificate => 'Supprimer le certificat ?';

  @override
  String get l_delete_certificate_desc =>
      'Supprimer le certificat de votre YubiKey';

  @override
  String get l_delete_key => 'Supprimer la clé';

  @override
  String get q_delete_key => 'Supprimer la clé?';

  @override
  String get l_delete_key_desc => 'Supprimer la clé de votre YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Supprimer le certificat/clé';

  @override
  String get q_delete_certificate_or_key => 'Supprimer le certificat/clé ?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Supprimer le certificat ou la clé de votre YubiKey';

  @override
  String get l_move_key => 'Déplacer la clé';

  @override
  String get l_move_key_desc =>
      'Déplacer une clé d\'un emplacement PIV vers un autre';

  @override
  String get l_change_defaults => 'Modifier les codes d\'accès par défaut';

  @override
  String get s_issuer => 'Émetteur';

  @override
  String get s_serial => 'Série';

  @override
  String get s_certificate_fingerprint => 'Empreinte digitale';

  @override
  String get s_valid_from => 'Valide à partir du';

  @override
  String get s_valid_to => 'Valide jusqu\'au';

  @override
  String get l_no_certificate => 'Aucun certificat chargé';

  @override
  String get l_key_no_certificate => 'Clé sans certificat chargé';

  @override
  String get s_generate_key => 'Générer clé';

  @override
  String get l_generate_desc => 'Générer un nouveau certificat ou CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Cette opération génère une nouvelle clé sur la YubiKey dans l\'emplacement PIV $slot.';
  }

  @override
  String get s_private_key_generated => 'Clé privée générée';

  @override
  String get p_select_what_to_delete =>
      'Sélectionnez ce que vous voulez supprimer de l\'emplacement.';

  @override
  String get p_warning_delete_certificate =>
      'Attention ! Cela supprimera le certificat de votre YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Attention! Cette action supprimera la clé privée de votre YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Attention! Cette action supprimera le certificat et la clé privée de votre YubiKey.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Cela supprimera le certificat dans l\'emplacement PIV $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Cela supprimera le certificat dans l\'emplacement PIV $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Ceci supprimera le certificat et la clé privée dans l\'emplacement PIV $slot.';
  }

  @override
  String get l_certificate_deleted => 'Certificat supprimé';

  @override
  String get l_key_deleted => 'Clé supprimée';

  @override
  String get l_certificate_and_key_deleted => 'Certificat et clé supprimés';

  @override
  String get l_include_certificate => 'Inclure le certificat';

  @override
  String get l_select_destination_slot =>
      'Sélectionnez l\'emplacement de destination';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Déplacer la clé privée depuis l\'emplacement PIV $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Déplacer la clé privée depuis l\'emplacement PIV $from_slot vers l\'emplacement $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Déplacer la clé privée et le certificat depuis l\'emplacement PIV $from_slot vers l\'emplacement $to_slot?';
  }

  @override
  String get p_password_protected_file =>
      'Le fichier sélectionné est protégé par un mot de passe.';

  @override
  String p_import_items_desc(String slot) {
    return 'Les éléments suivants seront importés dans le slot PIV $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'La clé publique du certificat ne correspond pas à la clé privée de l\'emplacement';

  @override
  String get l_key_moved => 'Clé déplacée';

  @override
  String get l_key_and_certificate_moved => 'Clé et certificat déplacés';

  @override
  String get p_subject_desc =>
      'DN (nom distinctif) formaté conformément à la spécification RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Format RFC 4514 non valide';

  @override
  String get rfc4514_examples =>
      'Exemples :\nCN=exemple de nom\nCN=jsmith,DC=exemple,DC=net';

  @override
  String get s_allow_fingerprint => 'Autoriser les empreintes digitales';

  @override
  String get s_pin_policy => 'Politique de code PIN';

  @override
  String get s_output_format => 'Format de sortie';

  @override
  String get s_expiration_date => 'Date d\'expiration';

  @override
  String get p_algorithm_desc => 'Algorithme de la clé à utiliser.';

  @override
  String get p_expiration_date_desc =>
      'Date d\'expiration du certificat, par défaut 1 an (certificat uniquement).';

  @override
  String get p_key_options_bio_desc =>
      'Permettre l\'utilisation de données biométriques au lieu d\'un code PIN.';

  @override
  String get q_overwrite_slot => 'Remplacer l\'emplacement ?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Cela écrasera définitivement le contenu du slot $slot.';
  }

  @override
  String get l_overwrite_cert => 'Le certificat sera écrasé';

  @override
  String get l_overwrite_key => 'La clé privée sera écrasée';

  @override
  String get l_overwrite_key_maybe =>
      'Toute clé privée se trouvant dans le slot sera écrasée';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Authentification';

  @override
  String get s_slot_9c => 'Signature numérique';

  @override
  String get s_slot_9d => 'Gestion des clés';

  @override
  String get s_slot_9e => 'Authentification par carte';

  @override
  String get s_retired_slot => 'Clé de gestion retraitée';

  @override
  String get s_otp_slot_one => 'Pression courte';

  @override
  String get s_otp_slot_two => 'Pression longue';

  @override
  String get l_otp_slot_empty => 'Slot vide';

  @override
  String get l_otp_slot_configured => 'Slot configuré';

  @override
  String get l_yubiotp_desc => 'Programmer un identifiant Yubico OTP';

  @override
  String get s_challenge_response => 'Défi-réponse';

  @override
  String get l_challenge_response_desc =>
      'Programmer un identifiant pour défi-réponse';

  @override
  String get s_static_password => 'Mot de passe statique';

  @override
  String get l_static_password_desc => 'Configurer mot de passe statique';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Programmer un identifiant basé sur HMAC-SHA1';

  @override
  String get s_public_id => 'ID public';

  @override
  String get s_private_id => 'ID privé';

  @override
  String get s_use_serial => 'Utiliser série';

  @override
  String get l_select_file => 'Sélectionner fichier';

  @override
  String get l_no_export_file => 'Pas de fichier d\'exportation';

  @override
  String get s_no_export => 'Pas d\'exportation';

  @override
  String get s_export => 'Exporter';

  @override
  String get l_export_configuration_file =>
      'Exporter configuration vers fichier';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Les identifiants exportés peuvent être téléchargés sur $url';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Clavier $layout';
  }

  @override
  String get s_delete_slot => 'Supprimer les infos d\'identification';

  @override
  String get q_delete_slot => 'Supprimer les informations d\'identification ?';

  @override
  String get l_delete_slot_desc =>
      'Supprimer les infos d\'identification dans le slot';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Attention ! Cela supprimera définitivement les infos d\'identification du slot $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Infos d\'identification supprimées';

  @override
  String get s_swap => 'Permuter';

  @override
  String get s_swap_slots => 'Permuter slots';

  @override
  String get q_swap_slots => 'Permuter les emplacements ?';

  @override
  String get l_swap_slots_desc => 'Permuter pression courte/longue';

  @override
  String get p_swap_slots_desc =>
      'Cela permutera la configuration des deux slots.';

  @override
  String get l_slots_swapped => 'Configurations de slot permutées';

  @override
  String l_slot_credential_configured(String type) {
    return 'Infos d\'identification $type configurées';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Infos d\'identification $type configurées et exportées vers $file';
  }

  @override
  String get s_append_enter => 'Ajouter ⏎';

  @override
  String get l_append_enter_desc =>
      'Ajouter une touche Entrée après émission de l\'OTP';

  @override
  String get p_otp_swap_error =>
      'Échec de l\'échange des emplacements ! Assurez-vous que la YubiKey n\'a pas un accès restrictif.';

  @override
  String get l_wrong_access_code => 'Code d\'accès erroné';

  @override
  String get s_access_code => 'Code d\'accès';

  @override
  String get s_show_access_code => 'Afficher le code d\'accès';

  @override
  String get s_hide_access_code => 'Cacher le code d\'accès';

  @override
  String p_enter_access_code(String slot) {
    return 'Entrez le code d\'accès pour l\'emplacement $slot.';
  }

  @override
  String get s_enable_nfc => 'Activer NFC';

  @override
  String get s_request_access => 'Demander l\'accès';

  @override
  String get s_permission_denied => 'Autorisation refusée';

  @override
  String get l_elevating_permissions => 'Élévation des autorisations…';

  @override
  String get s_review_permissions => 'Vérifier autorisations';

  @override
  String get s_open_windows_settings => 'Ouvrir les paramètres Windows';

  @override
  String get l_admin_privileges_required =>
      'Privilèges d\'administrateur requis';

  @override
  String get p_elevated_permissions_required =>
      'La gestion de cet appareil nécessite des privilèges élevés.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'La gestion WebAuthn nécessite des privilèges élevés.';

  @override
  String get l_ms_store_permission_note =>
      'La version de l\'application sur le Microsoft Store pourrait ne pas pouvoir élever les permissions';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator a besoin d\'autorisations de caméra pour les codes QR.';

  @override
  String get s_qr_scan => 'Scanner code QR';

  @override
  String get l_invalid_qr => 'Code QR non valide';

  @override
  String get l_qr_not_found => 'Aucun code QR';

  @override
  String get l_qr_scanned => 'Code QR scanné';

  @override
  String l_qr_file_too_large(String max) {
    return 'Fichier trop gros (max. $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Fichier image non valide';

  @override
  String get l_qr_select_file => 'Choisir fichier avec code QR';

  @override
  String l_qr_not_read(String message) {
    return 'Échec de lecture du code QR : $message';
  }

  @override
  String get l_point_camera_scan =>
      'Pointez votre caméra vers le code QR pour le scanner';

  @override
  String get q_want_to_scan => 'Effectuer un scan ?';

  @override
  String get q_no_qr => 'Pas de code QR ?';

  @override
  String get s_enter_manually => 'Saisir manuellement';

  @override
  String get s_read_from_file => 'Lire à partir du fichier';

  @override
  String get s_reset => 'Réinitialiser';

  @override
  String get s_factory_reset => 'Réinitialisation usine';

  @override
  String get l_factory_reset_desc =>
      'Restaurer les paramètres par défaut de la YubiKey';

  @override
  String get l_factory_reset_required => 'Réinitialisation d\'usine nécessaire';

  @override
  String get l_oath_application_reset => 'Réinitialisation OATH';

  @override
  String get l_fido_app_reset => 'Réinitialisation FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Erreur de réinitialisation : $message';
  }

  @override
  String get l_piv_app_reset => 'Réinitialisation PIV';

  @override
  String get p_factory_reset_an_app =>
      'Réinitialisation d\'usine d\'une appli sur votre YubiKey.';

  @override
  String get p_factory_reset_desc =>
      'Les données sont stockées dans plusieurs applis de la YubiKey. Certaines peuvent être réinitialisées indépendamment.\n\nChoisissez une appli ci-dessus à réinitialiser.';

  @override
  String get p_warning_factory_reset =>
      'Attention ! Cela supprimera définitivement tous les comptes OATH TOTP/HOTP de votre YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Vos informations d\'identification OATH, ainsi que tout mot de passe défini, seront supprimés de cette clé YubiKey. Veillez à les désactiver à partir de leurs sites web respectifs afin d\'éviter que vos comptes ne soient verrouillés.';

  @override
  String get p_warning_deletes_accounts =>
      'Attention ! Cela supprimera définitivement tous les comptes U2F et FIDO2, notamment les passkeys, de votre YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Vos informations d\'identification, ainsi que tout code PIN défini, seront supprimés de cette YubiKey. Veillez à les désactiver à partir de leurs sites web respectifs pour éviter que vos comptes ne soient verrouillés.';

  @override
  String get p_warning_piv_reset =>
      'Attention ! Toutes les données PIV seront définitivement supprimées de votre YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'Cela inclut les clés privées et les certificats. Vos PIN, PUK et clé de gestion seront réinitialisés à leurs valeurs d\'usine.';

  @override
  String get p_warning_global_reset =>
      'Attention ! Cela supprimera définitivement toutes les données enregistrées, notamment les identifiants, de votre YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Réinitialiser les applications de votre YubiKey. Le code PIN sera réinitialisé à sa valeur d\'usine par défaut et les empreintes digitales enregistrées seront supprimées. Les clés, certificats ou autres informations d\'identification seront tous définitivement supprimés.';

  @override
  String get l_copy_to_clipboard => 'Copier dans presse-papiers';

  @override
  String get s_code_copied => 'Code copié';

  @override
  String get l_code_copied_clipboard => 'Code copié dans presse-papiers';

  @override
  String get s_copy_log => 'Copier journal';

  @override
  String get l_log_copied => 'Journal copié dans presse-papiers';

  @override
  String get l_diagnostics_copied =>
      'Données de diagnostic copiées dans presse-papiers';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label copié dans le presse-papiers.';
  }

  @override
  String get s_custom_icons => 'Icônes personnalisées';

  @override
  String get l_set_icons_for_accounts => 'Définir des icônes pour les comptes';

  @override
  String get p_custom_icons_description =>
      'Les packs d\'icônes permettent de distinguer plus facilement vos comptes avec des logos et couleurs familiers.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Les packs d\'icônes utilisent le format $aegis_icon_pack. Vous pouvez télécharger un pack d\'icônes préétabli ou créer votre propre pack.';
  }

  @override
  String get s_replace_icon_pack => 'Remplacer le pack d\'icônes';

  @override
  String get l_loading_icon_pack => 'Chargement du pack d\'icônes…';

  @override
  String get s_load_icon_pack => 'Charger le pack d\'icônes';

  @override
  String get s_remove_icon_pack => 'Retirer le pack d\'icônes';

  @override
  String get l_icon_pack_removed => 'Pack d\'icônes supprimé';

  @override
  String get l_remove_icon_pack_failed =>
      'Erreur lors de la suppression du pack d\'icônes';

  @override
  String get s_choose_icon_pack => 'Choisir un pack d\'icônes';

  @override
  String get l_icon_pack_imported => 'Pack d\'icônes importé';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Erreur d\'importation du pack d\'icônes : $message';
  }

  @override
  String get l_invalid_icon_pack => 'Pack d\'icônes non valide';

  @override
  String get l_icon_pack_copy_failed =>
      'Impossible de copier les fichiers du pack d\'icônes';

  @override
  String get s_nfc_options => 'Options NFC';

  @override
  String get l_on_yk_nfc_tap => 'En cas de rapprochement de la clef en NFC';

  @override
  String get l_do_nothing => 'Ne rien faire';

  @override
  String get l_launch_ya => 'Lancer Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Copier OTP dans presse-papiers';

  @override
  String get l_launch_and_copy_otp => 'Lancer application et copier OTP';

  @override
  String get l_kbd_layout_for_static =>
      'Configuration clavier (pour mot de passe statique)';

  @override
  String get s_choose_kbd_layout => 'Choisir configuration clavier';

  @override
  String get l_bypass_touch_requirement => 'Contourner les exigences tactiles';

  @override
  String get l_bypass_touch_requirement_on =>
      'Les comptes tactiles s\'affichent automatiquement sur NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Les comptes tactiles nécessitent un rapprochement de la clef en NFC de plus';

  @override
  String get s_silence_nfc_sounds => 'Désactiver sons NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'Aucun son en cas de rapprochement en NFC';

  @override
  String get l_silence_nfc_sounds_off =>
      'Son émis en cas de rapprochement en NFC';

  @override
  String get s_usb_options => 'Options USB';

  @override
  String get l_launch_app_on_usb => 'Lancer lorsque la YubiKey est connectée';

  @override
  String get l_launch_app_on_usb_on =>
      'Cela empêche d\'autres applications d\'utiliser la YubiKey en USB';

  @override
  String get l_launch_app_on_usb_off =>
      'D\'autres applications peuvent utiliser la YubiKey en USB';

  @override
  String get s_allow_screenshots => 'Autoriser captures d\'écran';

  @override
  String get s_nfc_ready_to_scan => 'Prêt à scanner';

  @override
  String get s_nfc_hold_still => 'Ne bougez pas…';

  @override
  String get s_nfc_tap_your_yubikey => 'Touchez votre YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Échec de l\'analyse, réessayez';

  @override
  String get s_usb_processing => 'Lecture des données depuis YubiKey';

  @override
  String get s_usb_dont_remove => 'Ne retirez pas la clé…';

  @override
  String get l_usb_read_error => 'Impossible de lire les données de YubiKey';

  @override
  String get p_ndef_set_otp =>
      'Code OTP copié de la YubiKey dans le presse-papiers.';

  @override
  String get p_ndef_set_password =>
      'Mot de passe copié de la YubiKey dans le presse-papiers.';

  @override
  String get p_ndef_parse_failure =>
      'Impossible d\'analyser le code OTP de la YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Presse-papiers inaccessible lors de la tentative de copie du code OTP depuis la YubiKey.';

  @override
  String get s_set_label => 'Définir l\'étiquette';

  @override
  String get s_set_color => 'Définir la couleur';

  @override
  String get s_change_label => 'Modifier l\'étiquette';

  @override
  String get p_set_will_add_custom_name =>
      'Cela donnera un nom personnalisé à votre YubiKey.';

  @override
  String get p_rename_will_change_custom_name =>
      'Cela changera l\'étiquette de votre YubiKey.';

  @override
  String get s_shortcuts => 'Raccourcis';

  @override
  String get s_keyboard_shortcuts => 'Raccourcis clavier';

  @override
  String get s_global_shortcuts => 'Raccourcis globaux';

  @override
  String get s_application_shortcuts => 'Raccourcis d\'application';

  @override
  String s_quit_app(String app) {
    return 'Quitter $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Cacher $app';
  }

  @override
  String get s_search => 'Recherche';

  @override
  String get s_next_device => 'Appareil suivant';

  @override
  String get s_previous_device => 'Appareil précédent';

  @override
  String get s_open_settings => 'Ouvrir les paramètres';

  @override
  String get s_open_help_and_about => 'Ouvrir l\'aide et à propos';

  @override
  String get s_open_item => 'Ouvrir l\'article';

  @override
  String get s_edit_item => 'Modifier l’article';

  @override
  String get s_delete_item => 'Supprimer l’article';

  @override
  String get s_calculate_oath_code => 'Calculer le code OATH';

  @override
  String get s_open_keyboard_shortcuts => 'Ouvrir les raccourcis clavier';
}
