// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Español';

  @override
  String s_translated(int percentage) {
    return 'Traducido: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Revisión: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Traducción incompleta';

  @override
  String get p_translation_progress_desc =>
      'Los indicadores de progreso reflejan el grado de avance de la traducción.';

  @override
  String get s_save => 'Guardar';

  @override
  String get s_cancel => 'Cancelar';

  @override
  String get s_close => 'Cerrar';

  @override
  String get s_delete => 'Borrar';

  @override
  String get s_move => 'Mover';

  @override
  String get s_quit => 'Salir';

  @override
  String get s_enable => 'Habilitar';

  @override
  String get s_enabled => 'Habilitado';

  @override
  String get s_disabled => 'Deshabilitado';

  @override
  String get s_status => 'Estado';

  @override
  String get s_unlock => 'Desbloquear';

  @override
  String get s_calculate => 'Calcular';

  @override
  String get s_import => 'Importar';

  @override
  String get s_overwrite => 'Sobreescribir';

  @override
  String get s_done => 'Hecho';

  @override
  String get s_label => 'Etiqueta';

  @override
  String get s_name => 'Nombre';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Opciones';

  @override
  String get s_details => 'Detalles';

  @override
  String get s_show_window => 'Mostrar ventana';

  @override
  String get s_hide_window => 'Ocultar ventana';

  @override
  String get s_show_navigation => 'Mostrar navegación';

  @override
  String get s_expand_navigation => 'Ampliar la barra navegación';

  @override
  String get s_collapse_navigation => 'Contraer barra de navegación';

  @override
  String get s_expand_collapse_navigation =>
      'Ampliar/contraer barra de navegación';

  @override
  String get s_show_menu => 'Mostrar menú';

  @override
  String get s_toggle_menu_bar => 'Cambiar barra de menú';

  @override
  String get s_more_info => 'Más información';

  @override
  String l_bullet(String item) {
    return '· $item';
  }

  @override
  String get s_none => '<none>';

  @override
  String get s_about => 'Acerca de';

  @override
  String get s_algorithm => 'Algoritmo';

  @override
  String get s_appearance => 'Apariencia';

  @override
  String get s_actions => 'Acciones';

  @override
  String get s_manage => 'Administración';

  @override
  String get s_setup => 'Configurar';

  @override
  String get s_device => 'Dispositivo';

  @override
  String get s_application => 'Aplicación';

  @override
  String get s_settings => 'Ajustes';

  @override
  String get l_settings_desc => 'Cambiar las preferencias de la aplicación';

  @override
  String get s_certificates => 'Certificados';

  @override
  String get s_security_key => 'Claves de seguridad';

  @override
  String get s_slots => 'Ranuras';

  @override
  String get s_help_and_about => 'Ayuda y acerca de';

  @override
  String get l_help_and_about_desc => 'Resolución de problemas y soporte';

  @override
  String get s_help_and_feedback => 'Ayuda y comentarios';

  @override
  String get s_home => 'Inicio';

  @override
  String get s_user_guide => 'Guía del usuario';

  @override
  String get s_i_need_help => 'Necesito ayuda';

  @override
  String get s_troubleshooting => 'Resolución de problemas';

  @override
  String get s_terms_of_use => 'Condiciones generales de uso';

  @override
  String get s_privacy_policy => 'Política de Privacidad';

  @override
  String get s_open_src_licenses => 'Licencias de software libre';

  @override
  String get s_please_wait => 'Por favor, espera…';

  @override
  String get s_secret_key => 'Clave secreta';

  @override
  String get s_show_secret_key => 'Mostrar clave secreta';

  @override
  String get s_hide_secret_key => 'Ocultar clave secreta';

  @override
  String get s_private_key => 'Clave privada';

  @override
  String get s_public_key => 'Clave pública';

  @override
  String get s_invalid_length => 'Longitud no válida';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Formato no válido, caracteres permitidos: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Caracteres no válidos para el teclado seleccionado';

  @override
  String get s_require_touch => 'Se requiere un toque';

  @override
  String get q_have_account_info => '¿Tienes datos de la cuenta?';

  @override
  String get s_run_diagnostics => 'Correr diagnósticos';

  @override
  String s_log_level(String level) {
    return 'Nivel de log: $level';
  }

  @override
  String get s_character_count => 'Cantidad de caracteres';

  @override
  String get s_language => 'Idioma';

  @override
  String p_community_translations_desc(String crowdin) {
    return 'Las traducciones son mantenidas por la comunidad en $crowdin.';
  }

  @override
  String get s_choose_language => 'Elegir idioma';

  @override
  String get s_app_theme => 'Tema de la aplicación';

  @override
  String get s_choose_app_theme => 'Seleccionar tema';

  @override
  String get s_system_default => 'Predeterminado del sistema';

  @override
  String get s_light_mode => 'Modo claro';

  @override
  String get s_dark_mode => 'Modo oscuro';

  @override
  String get s_list_layout => 'Vista de lista';

  @override
  String get s_grid_layout => 'Vista de cuadrícula';

  @override
  String get s_mixed_layout => 'Vista Mixta';

  @override
  String get s_select_layout => 'Elegir vista';

  @override
  String get s_select_to_scan => 'Seleccionar para escanear';

  @override
  String get s_hide_reader => 'Ocultar lector';

  @override
  String get s_show_hidden_readers => 'Mostrar lectores ocultos';

  @override
  String get s_toggle_readers => 'Cambiar estado de lectores';

  @override
  String get l_toggle_readers_desc => 'Mostrar u ocultar lectores';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Número de serie: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Versión de firmware: $version';
  }

  @override
  String get l_fips_capable => 'Capacidad FIPS';

  @override
  String get l_fips_approved => 'Aprobado por FIPS';

  @override
  String get l_insert_yk => 'Inserta tu YubiKey';

  @override
  String get l_insert_or_tap_yk => 'Inserta o toca una YubiKey';

  @override
  String get l_unplug_yk => 'Desconecta tu YubiKey';

  @override
  String get l_reinsert_yk => 'Vuelve a insertar tu YubiKey';

  @override
  String get l_place_on_nfc_reader => 'Coloca tu YubiKey en el lector NFC';

  @override
  String get l_replace_yk_on_reader =>
      'Vuelve a colocar tu YubiKey en el lector';

  @override
  String get l_remove_yk_from_reader => 'Retira tu YubiKey del lector NFC';

  @override
  String get p_try_reinsert_yk =>
      'Intenta extraer y volver a insertar tu YubiKey.';

  @override
  String get s_touch_required => 'Se requiere un toque';

  @override
  String get l_touch_button_now => 'Toca el botón de tu YubiKey ahora';

  @override
  String get l_keep_touching_yk => 'Sigue tocando repetidamente tu YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Cambiar estado de aplicaciones';

  @override
  String get s_toggle_interfaces => 'Cambiar estado de interfaces';

  @override
  String get p_toggle_applications_desc =>
      'Habilitar o deshabilitar aplicaciones a través de los protocolos disponibles.';

  @override
  String get p_toggle_interfaces_desc =>
      'Habilitar o deshabilitar las interfaces USB.';

  @override
  String get l_toggle_applications_desc =>
      'Habilitar/deshabilitar aplicaciones';

  @override
  String get l_toggle_interfaces_desc => 'Habilitar/deshabilitar interfaces';

  @override
  String get s_reconfiguring_yk => 'Reconfigurando YubiKey…';

  @override
  String get s_config_updated => 'Configuración actualizada';

  @override
  String get l_config_updated_reinsert =>
      'Configuración actualizada, extrae y vuelve a insertar tu YubiKey';

  @override
  String get s_fido_disabled => 'FIDO2 desactivado';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn requiere que la aplicación FIDO2 esté habilitada en tu YubiKey';

  @override
  String get s_lock_code => 'Código de bloqueo';

  @override
  String get l_wrong_lock_code => 'Código de bloqueo incorrecto';

  @override
  String get s_show_lock_code => 'Mostrar código de bloqueo';

  @override
  String get s_hide_lock_code => 'Ocultar código de bloqueo';

  @override
  String get p_lock_code_required_desc =>
      'La acción que estás por ejecutar requiere el código de bloqueo de configuración.';

  @override
  String get l_helper_not_responding => 'El proceso Helper no responde';

  @override
  String get l_yk_no_access => 'No se puede acceder a esta YubiKey';

  @override
  String get s_yk_inaccessible => 'Dispositivo inaccesible';

  @override
  String get l_open_connection_failed =>
      'No se ha podido establecer la conexión';

  @override
  String get l_ccid_connection_failed =>
      'Error al establecer conexión con la smart card';

  @override
  String get p_ccid_service_unavailable =>
      'Asegúrate de que tu servicio de smart card funciona.';

  @override
  String get p_pcscd_unavailable =>
      'Asegúrate de que pcscd está instalado y funcionando.';

  @override
  String get l_no_yk_present => 'No hay YubiKey';

  @override
  String get s_unknown_type => 'Tipo desconocido';

  @override
  String get s_unknown_device => 'Dispositivo no reconocido';

  @override
  String get s_restricted_nfc => 'Activación de NFC';

  @override
  String get l_deactivate_restricted_nfc => 'Cómo activar NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Conecta tu YubiKey a cualquier fuente de alimentación USB, como un ordenador, durante al menos 3 segundos.\n\nUna vez alimentado, NFC se activará y estará listo para su uso.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Tu YubiKey está equipada con NFC restringido, una función diseñada para protegerla contra la manipulación inalámbrica durante el envío. Esto significa que las operaciones NFC se encuentran temporalmente deshabilitadas hasta que las actives.';

  @override
  String get s_unsupported_yk => 'YubiKey no soportada';

  @override
  String get p_operation_failed_try_again =>
      'La operación ha fallado, por favor inténtalo de nuevo.';

  @override
  String get l_configuration_unsupported => 'Configuración no soportada';

  @override
  String get p_scp_unsupported =>
      'Para comunicarse a través de NFC, la YubiKey requiere una tecnología que no es compatible con este teléfono. Conecta la YubiKey al puerto USB del teléfono.';

  @override
  String get l_error_occurred => 'Ha ocurrido un error';

  @override
  String get s_application_error => 'Error de la aplicación';

  @override
  String get l_import_error => 'Error al importar';

  @override
  String get l_file_not_found => 'Archivo no encontrado';

  @override
  String get l_file_too_big => 'El tamaño de archivo es demasiado grande';

  @override
  String get l_filesystem_error =>
      'Error en la operación del sistema de archivos';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'Establecer PIN';

  @override
  String get s_change_pin => 'Cambiar PIN';

  @override
  String get s_change_puk => 'Cambiar PUK';

  @override
  String get s_show_pin => 'Mostrar PIN';

  @override
  String get s_hide_pin => 'Ocultar PIN';

  @override
  String get s_show_puk => 'Mostrar PUK';

  @override
  String get s_hide_puk => 'Ocultar PUK';

  @override
  String get s_current_pin => 'PIN actual';

  @override
  String get s_current_puk => 'PUK actual';

  @override
  String get s_new_pin => 'Nuevo PIN';

  @override
  String get s_new_puk => 'Nuevo PUK';

  @override
  String get s_confirm_pin => 'Confirmar PIN';

  @override
  String get s_confirm_puk => 'Confirmar PUK';

  @override
  String get s_unblock_pin => 'Restablecer PIN';

  @override
  String get l_pin_mismatch => 'Los PIN no coinciden';

  @override
  String get l_puk_mismatch => 'Los PUK no coinciden';

  @override
  String get s_pin_set => 'PIN configurado';

  @override
  String get s_puk_set => 'PUK configurado';

  @override
  String l_set_pin_failed(String message) {
    return 'Error al establecer el PIN: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries intentos restantes',
      one: '$retries intento restante',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries intentos restantes',
      one: '$retries intento restante',
    );
    return 'PIN incorrecto, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries intentos restantes',
      one: '$retries intento restante',
    );
    return 'PUK incorrecto, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'PIN de protección FIDO';

  @override
  String get s_pin_change_required => 'Cambio de PIN requerido';

  @override
  String get l_enter_fido2_pin => 'Ingresa el PIN FIDO2 para tu YubiKey';

  @override
  String get l_pin_blocked_reset =>
      'PIN bloqueado; restablecer los valores de fábrica de la aplicación FIDO';

  @override
  String get l_pin_blocked => 'PIN bloqueado';

  @override
  String get l_set_pin_first => 'Se requiere un PIN';

  @override
  String get l_unlock_pin_first => 'Desbloquear con PIN';

  @override
  String get l_pin_soft_locked =>
      'El PIN ha sido bloqueado hasta que la YubiKey sea removida y reinsertada';

  @override
  String get l_pin_change_required_desc =>
      'Un nuevo PIN debe establecerse antes de poder utilizar esta aplicación';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'Un PIN debe tener entre $min_length y $max_length caracteres y puede contener letras, números y caracteres especiales.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'Un PIN debe tener entre $min_length y $max_length caracteres, contener al menos $unique_characters caracteres únicos y no ser un PIN de uso común, como «$common_pin». Puede contener letras, números y caracteres especiales.';
  }

  @override
  String get s_ep_attestation => 'Atestación empresarial';

  @override
  String get s_ep_attestation_enabled => 'Atestación empresarial habilitada';

  @override
  String get q_enable_ep_attestation => '¿Habilitar atestación empresarial?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Esto habilitará la atestación empresarial, permitiendo que los dominios autorizados identifiquen de forma exclusiva tu YubiKey.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Una vez habilitada, la atestación empresarial solo se puede deshabilitar realizando un restablecimiento de fábrica de FIDO.';

  @override
  String get s_pin_required => 'PIN requerido';

  @override
  String get p_pin_required_desc =>
      'La acción que estás a punto de realizar requiere la introducción del PIN PIV.';

  @override
  String get l_piv_pin_blocked => 'Bloqueado, utiliza el PUK para restablecer';

  @override
  String get p_piv_pin_blocked_desc =>
      'El PIN está bloqueado. Utiliza el PUK para restablecerlo.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'El PIN está bloqueado. Se requiere un restablecimiento de fábrica.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Bloqueado, se necesita un restablecimiento de fábrica';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Tanto el PIN como el PUK están bloqueados. Se requiere un restablecimiento de fábrica de la aplicación PIV.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'Un $name debe tener al menos $length caracteres.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'Un $name debe tener al menos $length caracteres, contener al menos 2 caracteres únicos y no ser un $name de uso común, como \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'El nuevo $name no cumple los requisitos de complejidad.';
  }

  @override
  String get s_dismiss => 'Descartar';

  @override
  String get p_default_pin_puk_key_desc =>
      'Se recomienda cambiar el PIN, el PUK y la clave de administración predeterminados.';

  @override
  String get l_warning_default_pin => 'Advertencia: PIN predeterminado usado';

  @override
  String get l_warning_default_puk => 'Advertencia: PUK predeterminado usado';

  @override
  String get l_default_pin_used => 'PIN por defecto usado';

  @override
  String get l_default_puk_used => 'PUK por defecto usado';

  @override
  String get l_pin_complexity => 'Complejidad de PIN aplicada';

  @override
  String get s_password => 'Contraseña';

  @override
  String get s_manage_password => 'Administrar contraseña';

  @override
  String get s_set_password => 'Establecer contraseña';

  @override
  String get s_password_set => 'Contraseña establecida';

  @override
  String get s_show_password => 'Mostrar contraseña';

  @override
  String get s_hide_password => 'Ocultar contraseña';

  @override
  String get l_password_protection => 'Cuentas protegidas con contraseña';

  @override
  String get s_new_password => 'Nueva contraseña';

  @override
  String get s_current_password => 'Contraseña actual';

  @override
  String get s_confirm_password => 'Confirmar contraseña';

  @override
  String get l_password_mismatch => 'Las contraseñas no coinciden';

  @override
  String get s_wrong_password => 'Contraseña incorrecta';

  @override
  String get p_wrong_password =>
      'Contraseña incorrecta. Si no sabes tu contraseña, tendrás que restablecer la YubiKey.';

  @override
  String get s_remove_password => 'Borrar contraseña';

  @override
  String get s_password_removed => 'Contraseña borrada';

  @override
  String get s_remember_password => 'Recordar contraseña';

  @override
  String get s_clear_saved_password => 'Borrar contraseña guardada';

  @override
  String get s_password_forgotten => 'Contraseña olvidada';

  @override
  String get l_keystore_unavailable =>
      'Repositorio de claves del SO no disponible';

  @override
  String get l_remember_pw_failed => 'Error al recordar la contraseña';

  @override
  String get l_unlock_first => 'Desbloquear con contraseña';

  @override
  String get l_set_password_first => 'Establecer una contraseña';

  @override
  String get l_enter_oath_pw => 'Introduce la contraseña OATH de tu YubiKey';

  @override
  String get p_new_password_requirements =>
      'Una contraseña puede contener letras, números y caracteres especiales.';

  @override
  String get s_management_key => 'Clave de administración';

  @override
  String get s_current_management_key => 'Clave de administración actual';

  @override
  String get s_new_management_key => 'Nueva clave de administración';

  @override
  String get l_change_management_key => 'Cambiar clave de administración';

  @override
  String get l_management_key_changed => 'Clave de administración cambiada';

  @override
  String get l_default_key_used =>
      'Clave de administración predeterminada usada';

  @override
  String get s_generate_random => 'Generar clave aleatoria';

  @override
  String get s_use_default => 'Usar valores predeterminados';

  @override
  String get l_warning_default_key => 'Advertencia: Clave predeterminada usada';

  @override
  String get s_protect_key => 'Proteger con PIN';

  @override
  String get p_protect_key_desc =>
      'Usa el PIN en lugar de la clave de administración durante las operaciones que requieran la autenticación de la clave de administración.';

  @override
  String get s_management_key_algorithm => 'Algoritmo de clave de gestión';

  @override
  String get p_management_key_algorithm_desc =>
      'El algoritmo a elegir para la clave de gestión.';

  @override
  String get l_pin_protected_key => 'El PIN puede ser usado en su lugar';

  @override
  String get l_wrong_key => 'Clave incorrecta';

  @override
  String get l_unlock_piv_management => 'Desbloquear la administración de PIV';

  @override
  String get p_unlock_piv_management_desc =>
      'La acción que estás a punto de realizar requiere la clave de administración PIV.';

  @override
  String l_account(String label) {
    return 'Cuenta: $label';
  }

  @override
  String get s_accounts => 'Cuentas';

  @override
  String get s_no_accounts => 'No hay cuentas';

  @override
  String l_results_for(String query) {
    return 'Resultados para \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Introducción a las cuentas OTP';

  @override
  String get l_no_accounts_desc =>
      'Añade cuentas a tu YubiKey desde cualquier proveedor de servicios compatible con OATH TOTP/HOTP';

  @override
  String get s_add_account => 'Añadir cuenta';

  @override
  String get p_add_account_desc =>
      'Escanea el código QR o introduce los detalles de la credencial manualmente.';

  @override
  String get s_add_accounts => 'Añadir cuenta(s)';

  @override
  String get l_drop_qr_description =>
      'Arrastra el código QR para añadir cuenta(s)';

  @override
  String get p_add_account_three_ways => 'Hay tres formas de añadir cuentas.';

  @override
  String get s_scanning => 'Escaneado (recomendado)';

  @override
  String get p_scanning_desc =>
      'Antes de escanear un código QR, asegúrate de que el código completo esté visible en la pantalla.';

  @override
  String get s_drag_and_drop => 'Arrastra y suelta';

  @override
  String get p_drag_and_drop_desc =>
      'Puedes arrastrar una imagen con un código QR a cualquier lugar de la Vista de cuentas.';

  @override
  String get s_manually => 'Manualmente';

  @override
  String get p_manually_desc =>
      'Los detalles de las credenciales de la cuenta pueden introducirse manualmente en el formulario.';

  @override
  String get s_account_added => 'Cuenta añadida';

  @override
  String l_account_add_failed(String message) {
    return 'Error al añadir cuenta: $message';
  }

  @override
  String get l_add_account_password_required => 'Contraseña requerida';

  @override
  String get l_add_account_unlock_required => 'Desbloqueo requerido';

  @override
  String get l_add_account_already_exists => 'La cuenta ya existe';

  @override
  String get l_add_account_func_missing =>
      'Funcionalidad faltante o deshabilitada';

  @override
  String get l_account_name_required => 'Tu cuenta debe tener un nombre';

  @override
  String get l_name_already_exists => 'Este nombre ya existe para el emisor';

  @override
  String get l_account_already_exists => 'Esta cuenta ya existe en la YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Carácter inválido: “:” no está permitido en el emisor';

  @override
  String get l_select_accounts =>
      'Selecciona la(s) cuenta(s) que deseas añadir a la YubiKey';

  @override
  String get s_pin_account => 'Anclar cuenta';

  @override
  String get s_unpin_account => 'Desanclar cuenta';

  @override
  String get s_no_pinned_accounts => 'No hay cuentas ancladas';

  @override
  String get s_pinned => 'Anclada';

  @override
  String get l_pin_account_desc => 'Mantén tus cuentas importantes juntas';

  @override
  String get s_rename_account => 'Renombrar cuenta';

  @override
  String get l_rename_account_desc => 'Editar el emisor/nombre de la cuenta';

  @override
  String get s_account_renamed => 'Cuenta renombrada';

  @override
  String l_rename_account_failed(String message) {
    return 'Error al renombrar la cuenta: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Esto cambiará la forma en que la cuenta se muestra en la lista.';

  @override
  String get s_delete_account => 'Borrar cuenta';

  @override
  String get q_delete_account => '¿Borrar cuenta?';

  @override
  String get l_delete_account_desc => 'Remover la cuenta de tu YubiKey';

  @override
  String get s_account_deleted => 'Cuenta borrada';

  @override
  String get p_warning_delete_account =>
      '¡Advertencia! Esta acción eliminará la cuenta de tu YubiKey.';

  @override
  String get p_warning_disable_credential =>
      'Asegúrate de deshabilitar esta cuenta del servicio en el que está registrada para evitar que se bloquee.';

  @override
  String get s_account_name => 'Nombre de la cuenta';

  @override
  String get s_search_accounts => 'Buscar cuentas';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used de $capacity cuentas usadas';
  }

  @override
  String s_num_digits(int num) {
    return '$num dígitos';
  }

  @override
  String s_num_sec(int num) {
    return '$num segs';
  }

  @override
  String get s_issuer_optional => 'Emisor (opcional)';

  @override
  String get s_counter_based => 'Basado en contador';

  @override
  String get s_time_based => 'Basado en tiempo';

  @override
  String get l_copy_code_desc => 'Pegar el código en otra aplicación';

  @override
  String get l_calculate_code_desc => 'Obtener un nuevo código de tu YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'ID de Usuario';

  @override
  String get s_credential_id => 'ID de credencial';

  @override
  String get s_display_name => 'Nombre para mostrar';

  @override
  String get s_user_name => 'Nombre de Usuario';

  @override
  String get s_passkeys => 'Passkeys';

  @override
  String get s_no_passkeys => 'No hay passkeys';

  @override
  String get l_ready_to_use => 'Listo para usar';

  @override
  String get l_register_sk_on_websites =>
      'Registrar como clave de seguridad en sitios web';

  @override
  String get l_no_discoverable_accounts => 'No hay passkeys almacenadas';

  @override
  String get p_non_passkeys_note =>
      'Es posible que existan credenciales sin passkey, pero no se pueden listar.';

  @override
  String get s_delete_passkey => 'Borrar passkey';

  @override
  String get q_delete_passkey => '¿Borrar passkey?';

  @override
  String get l_delete_passkey_desc => 'Remover la passkey de la YubiKey';

  @override
  String get s_passkey_deleted => 'Passkey eliminada';

  @override
  String get p_warning_delete_passkey =>
      'Advertencia. Esta acción borrará la passkey de tu YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Ya no podrás usar esta passkey para el servicio en el que está registrada.';

  @override
  String get s_search_passkeys => 'Buscar passkeys';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used de $max passkeys usadas.';
  }

  @override
  String get s_biometrics => 'Biometría';

  @override
  String l_fingerprint(String label) {
    return 'Huella dactilar: $label';
  }

  @override
  String get s_fingerprints => 'Huellas dactilares';

  @override
  String get l_fingerprint_captured =>
      '¡Huella dactilar capturada exitosamente!';

  @override
  String get s_fingerprint_added => 'Huella digital añadida';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Error al añadir la huella dactilar: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Error estableciendo el nombre: $message';
  }

  @override
  String get s_setup_fingerprints => 'Configurar huellas dactilares';

  @override
  String get p_setup_fingerprints_desc =>
      'Las huellas dactilares deben configurarse antes de que la YubiKey pueda ser usada.';

  @override
  String get s_add_fingerprint => 'Añadir huella dactilar';

  @override
  String get s_delete_fingerprint => 'Borrar huella dactilar';

  @override
  String get q_delete_fingerprint => '¿Borrar huella dactilar?';

  @override
  String get l_delete_fingerprint_desc =>
      'Remover la huella dactilar de la YubiKey';

  @override
  String get s_fingerprint_deleted => 'Huella dactilar borrada';

  @override
  String get p_warning_delete_fingerprint =>
      'Esto borrará la huella dactilar de tu YubiKey.';

  @override
  String get s_fingerprints_get_started =>
      'Introducción a las huellas dactilares';

  @override
  String get p_set_fingerprints_desc =>
      'Antes de registrar las huellas dactilares, es necesario establecer un PIN.';

  @override
  String get l_no_fps_added => 'No se han añadido huellas digitales';

  @override
  String get s_rename_fp => 'Renombrar huella dactilar';

  @override
  String get l_rename_fp_desc => 'Cambiar el nombre';

  @override
  String get s_fingerprint_renamed => 'Huella dactilar renombrada';

  @override
  String l_rename_fp_failed(String message) {
    return 'Error al renombrar: $message';
  }

  @override
  String get l_add_one_or_more_fps =>
      'Añadir una o más (hasta cinco) huellas dactilares';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 Huellas dactilares registradas';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Presiona la YubiKey con tu dedo para empezar.';

  @override
  String get l_name_fingerprint => 'Nombra esta huella dactilar';

  @override
  String get l_user_action_timeout_error =>
      'Error debido a la inactividad del usuario';

  @override
  String get l_wrong_inserted_yk_error =>
      'La YubiKey reinsertada no coincide con el dispositivo inicial';

  @override
  String get l_failed_connecting_to_fido =>
      'Fallo al conectar con la interfaz FIDO';

  @override
  String get l_self_signed_certificate => 'Certificado autofirmado';

  @override
  String get l_certificate_signing_request =>
      'Solicitud de Firma de Certificado (CSR)';

  @override
  String get s_certificate => 'Certificado';

  @override
  String get s_subject => 'Asunto';

  @override
  String get l_export_csr_file => 'Guardar CSR a archivo';

  @override
  String get l_export_public_key => 'Exportar clave pública';

  @override
  String get l_export_public_key_file => 'Guardar clave pública a archivo';

  @override
  String get l_export_public_key_desc =>
      'Guardar la clave pública a un archivo';

  @override
  String get l_public_key_exported => 'Clave pública exportada';

  @override
  String get l_export_certificate => 'Exportar certificado';

  @override
  String get l_export_certificate_file => 'Exportar certificado a archivo';

  @override
  String get l_export_certificate_desc =>
      'Exportar el certificado a un archivo';

  @override
  String get l_certificate_exported => 'Certificado exportado';

  @override
  String get l_select_import_file => 'Selecciona archivo a importar';

  @override
  String get l_import_file => 'Importar archivo';

  @override
  String get l_import_desc => 'Importar un archivo y/o certificado';

  @override
  String get l_import_nothing => 'Nada a importar';

  @override
  String get l_importing_file => 'Importando archivo…';

  @override
  String get s_file_imported => 'Archivo importado';

  @override
  String get l_unsupported_key_type => 'Tipo de clave no soportado';

  @override
  String get l_delete_certificate => 'Borrar certificado';

  @override
  String get q_delete_certificate => '¿Borrar certificado?';

  @override
  String get l_delete_certificate_desc =>
      'Remover el certificado de tu YubiKey';

  @override
  String get l_delete_key => 'Borrar clave';

  @override
  String get q_delete_key => '¿Borrar clave?';

  @override
  String get l_delete_key_desc => 'Remover la clave de tu YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Borrar certificado/clave';

  @override
  String get q_delete_certificate_or_key => '¿Borrar certificado/clave?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Remover el certificado o la clave de tu YubiKey';

  @override
  String get l_move_key => 'Mover clave';

  @override
  String get l_move_key_desc => 'Mover una clave de una ranura PIV a otra';

  @override
  String get l_change_defaults =>
      'Cambiar los códigos de acceso predeterminados';

  @override
  String get s_issuer => 'Emisor';

  @override
  String get s_serial => 'Serie';

  @override
  String get s_certificate_fingerprint => 'Huella dactilar';

  @override
  String get s_valid_from => 'Válido desde';

  @override
  String get s_valid_to => 'Válido hasta';

  @override
  String get l_no_certificate => 'No se ha cargado ningún certificado';

  @override
  String get l_key_no_certificate => 'Clave sin certificado cargada';

  @override
  String get s_generate_key => 'Generar clave';

  @override
  String get l_generate_desc => 'Generar un nuevo certificado o CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Esto generará una nueva clave en la YubiKey en la ranura PIV $slot.';
  }

  @override
  String get s_private_key_generated => 'Clave privada generada';

  @override
  String get p_select_what_to_delete => 'Selecciona qué borrar de la ranura.';

  @override
  String get p_warning_delete_certificate =>
      '¡Advertencia! Esta acción eliminará el certificado de tu YubiKey.';

  @override
  String get p_warning_delete_key =>
      '¡Advertencia! Esta acción borrará la clave privada de tu YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      '¡Advertencia! Esta acción borrará el certificado y la clave privada de tu YubiKey.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Esto borrará el certificado en la ranura PIV $slot.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Esto borrará la clave privada en la ranura PIV $slot.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Esto borrará el certificado y la clave privada en la ranura PIV $slot.';
  }

  @override
  String get l_certificate_deleted => 'Certificado borrado';

  @override
  String get l_key_deleted => 'Clave borrada';

  @override
  String get l_certificate_and_key_deleted => 'Certificado y clave borrados';

  @override
  String get l_include_certificate => 'Incluir certificado';

  @override
  String get l_select_destination_slot => 'Selecciona la ranura de destino';

  @override
  String q_move_key_confirm(String from_slot) {
    return '¿Mover la clave privada de la ranura PIV $from_slot?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return '¿Mover la clave privada de la ranura PIV $from_slot a la ranura $to_slot?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return '¿Mover la clave privada y el certificado de la ranura PIV $from_slot a la ranura $to_slot?';
  }

  @override
  String get p_password_protected_file =>
      'El archivo seleccionado está protegido por contraseña.';

  @override
  String p_import_items_desc(String slot) {
    return 'Los siguientes elementos se importarán en la ranura PIV $slot.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'La clave pública del certificado no coincide con la clave privada en la ranura';

  @override
  String get l_key_moved => 'Clave movida';

  @override
  String get l_key_and_certificate_moved => 'Clave y certificado movidos';

  @override
  String get p_subject_desc =>
      'Un nombre distinguido (DN) formateado de acuerdo con la especificación RFC 4514.';

  @override
  String get l_rfc4514_invalid => 'Formato RFC 4514 inválido';

  @override
  String get rfc4514_examples =>
      'Ejemplos:\nCN=Nombre de Ejemplo\nCN=jsmith,DC=ejemplo,DC=net';

  @override
  String get s_allow_fingerprint => 'Permitir huella dactilar';

  @override
  String get s_pin_policy => 'Política de PIN';

  @override
  String get s_output_format => 'Formato de salida';

  @override
  String get s_expiration_date => 'Fecha de expiración';

  @override
  String get p_algorithm_desc => 'Algoritmo de clave a usar.';

  @override
  String get p_expiration_date_desc =>
      'Fecha de caducidad del certificado, por defecto 1 año (solo certificado).';

  @override
  String get p_key_options_bio_desc =>
      'Permitir el uso de biometría en lugar del PIN.';

  @override
  String get q_overwrite_slot => '¿Sobreescribir ranura?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Esto sobrescribirá permanentemente el contenido existente en la ranura $slot.';
  }

  @override
  String get l_overwrite_cert => 'El certificado será sobrescrito';

  @override
  String get l_overwrite_key => 'La clave privada será sobrescrita';

  @override
  String get l_overwrite_key_maybe =>
      'Cualquier clave privada existente en la ranura será sobrescrita';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Autenticación';

  @override
  String get s_slot_9c => 'Firma digital';

  @override
  String get s_slot_9d => 'Administración de claves';

  @override
  String get s_slot_9e => 'Autenticación de smart card';

  @override
  String get s_retired_slot => 'Administración de Claves Retiradas';

  @override
  String get s_otp_slot_one => 'Toque corto';

  @override
  String get s_otp_slot_two => 'Toque largo';

  @override
  String get l_otp_slot_empty => 'La ranura está vacía';

  @override
  String get l_otp_slot_configured => 'La ranura está configurada';

  @override
  String get l_yubiotp_desc => 'Programar una credencial Yubico OTP';

  @override
  String get s_challenge_response => 'Challenge-Response';

  @override
  String get l_challenge_response_desc =>
      'Programar una credencial de desafío y respuesta';

  @override
  String get s_static_password => 'Contraseña estática';

  @override
  String get l_static_password_desc => 'Configurar una contraseña estática';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Programar una credencial basada en HMAC-SHA1';

  @override
  String get s_public_id => 'ID Público';

  @override
  String get s_private_id => 'ID Privado';

  @override
  String get s_use_serial => 'Usar serial';

  @override
  String get l_select_file => 'Seleccionar archivo';

  @override
  String get l_no_export_file => 'Ningún archivo de exportación';

  @override
  String get s_no_export => 'Ninguna exportación';

  @override
  String get s_export => 'Exportar';

  @override
  String get l_export_configuration_file => 'Exportar configuración a archivo';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Las credenciales exportadas pueden cargarse en $url.';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Teclado $layout';
  }

  @override
  String get s_delete_slot => 'Borrar credencial';

  @override
  String get q_delete_slot => '¿Borrar credencial?';

  @override
  String get l_delete_slot_desc => 'Remover credencial en ranura';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return '¡Advertencia! Esta acción eliminará permanentemente la credencial de la ranura $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Credencial borrada';

  @override
  String get s_swap => 'Intercambiar';

  @override
  String get s_swap_slots => 'Intercambiar ranuras';

  @override
  String get q_swap_slots => '¿Intercambiar ranuras?';

  @override
  String get l_swap_slots_desc => 'Intercambiar toque corto/largo';

  @override
  String get p_swap_slots_desc =>
      'Esto intercambiará la configuración de las dos ranuras.';

  @override
  String get l_slots_swapped => 'Configuraciones de ranuras intercambiadas';

  @override
  String l_slot_credential_configured(String type) {
    return 'Credencial $type configurada';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return 'Configurada la credencial $type y exportada a $file';
  }

  @override
  String get s_append_enter => 'Añadir ⏎';

  @override
  String get l_append_enter_desc => 'Añadir un Enter después de generar el OTP';

  @override
  String get p_otp_swap_error =>
      'Error al intercambiar ranuras. Asegúrate de que la YubiKey no tenga acceso restrictivo.';

  @override
  String get l_wrong_access_code => 'Código de acceso incorrecto';

  @override
  String get s_access_code => 'Código de acceso';

  @override
  String get s_show_access_code => 'Mostrar código de acceso';

  @override
  String get s_hide_access_code => 'Ocultar código de acceso';

  @override
  String p_enter_access_code(String slot) {
    return 'Introduce el código de acceso para la ranura $slot.';
  }

  @override
  String get s_enable_nfc => 'Activar NFC';

  @override
  String get s_request_access => 'Solicitar acceso';

  @override
  String get s_permission_denied => 'Permiso denegado';

  @override
  String get l_elevating_permissions => 'Obteniendo permisos elevados...';

  @override
  String get s_review_permissions => 'Revisar permisos';

  @override
  String get s_open_windows_settings => 'Abrir configuración de Windows';

  @override
  String get l_admin_privileges_required =>
      'Se requieren privilegios de administrador';

  @override
  String get p_elevated_permissions_required =>
      'La administración de este dispositivo requiere privilegios elevados. Como alternativa, puedes usar la configuración de Windows para administrar la configuración de FIDO.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'La administración de WebAuthn requiere privilegios elevados. Como alternativa, puedes usar la configuración de Windows para administrar la configuración de FIDO.';

  @override
  String get l_ms_store_permission_note =>
      'La versión de Microsoft Store de la aplicación no puede obtener permisos elevados.';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator necesita acceder a la cámara para escanear el código QR. Revise los permisos';

  @override
  String get s_qr_scan => 'Escanear código QR';

  @override
  String get l_invalid_qr => 'Código QR inválido';

  @override
  String get l_qr_not_found => 'Código QR no encontrado';

  @override
  String get l_qr_scanned => 'Código QR escaneado';

  @override
  String l_qr_file_too_large(String max) {
    return 'Archivo demasiado grande (máx. $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Archivo de imagen inválido';

  @override
  String get l_qr_select_file => 'Seleccionar archivo con código QR';

  @override
  String l_qr_not_read(String message) {
    return 'Error al leer el código QR: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Apunta tu cámara a un código QR para escanearlo';

  @override
  String get q_want_to_scan => '¿Te gustaría escanear?';

  @override
  String get q_no_qr => '¿No hay código QR?';

  @override
  String get s_enter_manually => 'Introducir manualmente';

  @override
  String get s_read_from_file => 'Leer desde archivo';

  @override
  String get s_reset => 'Restablecer';

  @override
  String get s_factory_reset => 'Restablecer valores de fábrica';

  @override
  String get l_factory_reset_desc =>
      'Restaurar los valores predeterminados de YubiKey';

  @override
  String get l_factory_reset_required =>
      'Restablecer configuración de fábrica requerida';

  @override
  String get l_oath_application_reset => 'Restablecer aplicación OATH';

  @override
  String get l_fido_app_reset => 'Restablecer aplicación FIDO';

  @override
  String l_reset_failed(String message) {
    return 'Error al ejecutar restablecimiento: $message';
  }

  @override
  String get l_piv_app_reset => 'Restablecer aplicación PIV';

  @override
  String get p_factory_reset_an_app =>
      'Restablecer valores de fábrica para una aplicación en tu YubiKey.';

  @override
  String get p_factory_reset_desc =>
      'Los datos se almacenan en varias aplicaciones de la YubiKey, algunas de las cuales pueden restablecerse a los valores de fábrica independientemente unas de otras.';

  @override
  String get p_warning_factory_reset =>
      '¡Advertencia! Esto borrará irrevocablemente todas las cuentas TOTP/HOTP de OATH de tu YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Tus credenciales OATH, así como cualquier contraseña establecida, serán removidas de esta YubiKey. Asegúrate de desactivarlas desde sus respectivos sitios web para evitar ser bloqueado de tus cuentas.';

  @override
  String get p_warning_deletes_accounts =>
      '¡Advertencia! Esto borrará irrevocablemente todas las cuentas U2F y FIDO2, incluidas las passkeys, de tu YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Tus credenciales, así como cualquier PIN establecido, se eliminarán de esta YubiKey. Asegúrate de desvincularlos de los respectivos sitios web para evitar quedar bloqueado/a de tus cuentas.';

  @override
  String get p_warning_piv_reset =>
      '¡Advertencia! Todos los datos almacenados para PIV se eliminarán irrevocablemente de tu YubiKey.';

  @override
  String get p_warning_piv_reset_desc =>
      'Esto incluye claves privadas y certificados. Su PIN, PUK y clave de administración se restablecerán a sus valores predeterminados de fábrica.';

  @override
  String get p_warning_global_reset =>
      '¡Advertencia! Esto borrará irrevocablemente todos los datos guardados, incluidas las credenciales, de tu YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Restablecer a valores de fábrica las aplicaciones de tu YubiKey. El PIN se restablecerá a su valor predeterminado de fábrica y se eliminarán las huellas dactilares registradas. Todas las claves, certificados u otras credenciales se eliminarán permanentemente.';

  @override
  String get l_copy_to_clipboard => 'Copiar al portapapeles';

  @override
  String get s_code_copied => 'Código copiado';

  @override
  String get l_code_copied_clipboard => 'Código copiado al portapapeles';

  @override
  String get s_copy_log => 'Copiar log';

  @override
  String get l_log_copied => 'Log copiado en el portapapeles';

  @override
  String get l_diagnostics_copied =>
      'Datos de diagnóstico copiados al portapapeles';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label copiado al portapapeles.';
  }

  @override
  String get s_custom_icons => 'Íconos personalizados';

  @override
  String get l_set_icons_for_accounts => 'Establecer íconos para las cuentas';

  @override
  String get p_custom_icons_description =>
      'Los paquetes de iconos pueden hacer que tus cuentas sean distinguibles más fácilmente con logos y colores familiares.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Los paquetes de íconos usan el formato $aegis_icon_pack. Puedes descargar un paquete de íconos ya hecho o crear el tuyo propio.';
  }

  @override
  String get s_replace_icon_pack => 'Reemplazar paquete de íconos';

  @override
  String get l_loading_icon_pack => 'Cargando paquete de íconos…';

  @override
  String get s_load_icon_pack => 'Cargar paquete de íconos';

  @override
  String get s_remove_icon_pack => 'Remover paquete de íconos';

  @override
  String get l_icon_pack_removed => 'Paquete de íconos removido';

  @override
  String get l_remove_icon_pack_failed =>
      'Error removiendo el paquete de íconos';

  @override
  String get s_choose_icon_pack => 'Elegir paquete de íconos';

  @override
  String get l_icon_pack_imported => 'Paquete de íconos importado';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Error al importar paquete de íconos: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Paquete de íconos inválido';

  @override
  String get l_icon_pack_copy_failed =>
      'Error al copiar los archivos del paquete de íconos';

  @override
  String get s_nfc_options => 'Opciones de NFC';

  @override
  String get l_on_yk_nfc_tap => 'Al tocar la YubiKey con NFC';

  @override
  String get l_do_nothing => 'No hacer nada';

  @override
  String get l_launch_ya => 'Iniciar Yubico Authenticator';

  @override
  String get l_copy_otp_clipboard => 'Copiar OTP al portapapeles';

  @override
  String get l_launch_and_copy_otp => 'Iniciar la aplicación y copiar la OTP';

  @override
  String get l_kbd_layout_for_static =>
      'Distribución del teclado (para contraseña estática)';

  @override
  String get s_choose_kbd_layout => 'Elegir la distribución del teclado';

  @override
  String get l_bypass_touch_requirement => 'Omitir requisito de toque';

  @override
  String get l_bypass_touch_requirement_on =>
      'Las cuentas que requieren toque se muestran automáticamente a través de NFC';

  @override
  String get l_bypass_touch_requirement_off =>
      'Las cuentas que requieren toque necesitan un toque adicional sobre NFC';

  @override
  String get s_silence_nfc_sounds => 'Silenciar los sonidos NFC';

  @override
  String get l_silence_nfc_sounds_on =>
      'No se reproducirá ningún sonido al tocar el NFC';

  @override
  String get l_silence_nfc_sounds_off =>
      'El sonido se reproducirá al tocar con NFC.';

  @override
  String get s_usb_options => 'Opciones de USB';

  @override
  String get l_launch_app_on_usb => 'Iniciar cuando la YubiKey esté conectada';

  @override
  String get l_launch_app_on_usb_on =>
      'Esto previene que otras aplicaciones utilicen la YubiKey a través de USB';

  @override
  String get l_launch_app_on_usb_off =>
      'Otras aplicaciones pueden utilizar la YubiKey a través de USB';

  @override
  String get s_allow_screenshots => 'Permitir capturas de pantalla';

  @override
  String get s_nfc_ready_to_scan => 'Listo para escanear';

  @override
  String get s_nfc_hold_still => 'Mantén presionado…';

  @override
  String get s_nfc_tap_your_yubikey => 'Toca tu YubiKey';

  @override
  String get l_nfc_failed_to_scan => 'Error al escanear, inténtalo de nuevo';

  @override
  String get s_usb_processing => 'Leyendo datos de la YubiKey';

  @override
  String get s_usb_dont_remove => 'No remuevas la llave…';

  @override
  String get l_usb_read_error => 'Error al leer datos de YubiKey';

  @override
  String get p_ndef_set_otp => 'Código OTP de YubiKey copiado al portapapeles.';

  @override
  String get p_ndef_set_password =>
      'Contraseña de YubiKey copiada al portapapeles.';

  @override
  String get p_ndef_parse_failure =>
      'Error al analizar el código OTP de la YubiKey.';

  @override
  String get p_ndef_set_clip_failure =>
      'Error al acceder al portapapeles al intentar copiar el código OTP desde la YubiKey.';

  @override
  String get s_set_label => 'Establecer etiqueta';

  @override
  String get s_set_color => 'Establecer color';

  @override
  String get s_change_label => 'Cambiar etiqueta';

  @override
  String get p_set_will_add_custom_name =>
      'Esto asignará un nombre personalizado a tu YubiKey.';

  @override
  String get p_rename_will_change_custom_name =>
      'Esto cambiará la etiqueta de tu YubiKey.';

  @override
  String get s_shortcuts => 'Atajos';

  @override
  String get s_keyboard_shortcuts => 'Atajos de teclado';

  @override
  String get s_global_shortcuts => 'Atajos globales';

  @override
  String get s_application_shortcuts => 'Atajos de la aplicación';

  @override
  String s_quit_app(String app) {
    return 'Salir $app';
  }

  @override
  String s_hide_app(String app) {
    return 'Ocultar $app';
  }

  @override
  String get s_search => 'Buscar';

  @override
  String get s_next_device => 'Dispositivo siguiente';

  @override
  String get s_previous_device => 'Dispositivo anterior';

  @override
  String get s_open_settings => 'Abrir ajustes';

  @override
  String get s_open_help_and_about => 'Abrir ayuda y acerca de';

  @override
  String get s_open_item => 'Abrir elemento';

  @override
  String get s_edit_item => 'Editar elemento';

  @override
  String get s_delete_item => 'Borrar elemento';

  @override
  String get s_calculate_oath_code => 'Calcular código OATH';

  @override
  String get s_open_keyboard_shortcuts => 'Abrir atajos de teclado';
}
