// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get app_name => 'Yubico Authenticator';

  @override
  String get native_language_name => 'Deutsch';

  @override
  String s_translated(int percentage) {
    return 'Übersetzt: $percentage%';
  }

  @override
  String s_proofread(int percentage) {
    return 'Überprüft: $percentage%';
  }

  @override
  String get l_incomplete_translation => 'Unvollständige Übersetzung';

  @override
  String get p_translation_progress_desc =>
      'Die Fortschrittsanzeige reflektiert den Stand der Übersetzung.';

  @override
  String get s_save => 'Speichern';

  @override
  String get s_cancel => 'Abbrechen';

  @override
  String get s_close => 'Schließen';

  @override
  String get s_delete => 'Löschen';

  @override
  String get s_move => 'Verschieben';

  @override
  String get s_quit => 'Beenden';

  @override
  String get s_enable => 'Aktivieren';

  @override
  String get s_enabled => 'Aktiviert';

  @override
  String get s_disabled => 'Deaktiviert';

  @override
  String get s_status => 'Status';

  @override
  String get s_unlock => 'Entsperren';

  @override
  String get s_calculate => 'Berechnen';

  @override
  String get s_import => 'Importieren';

  @override
  String get s_overwrite => 'Überschreiben';

  @override
  String get s_done => 'Erledigt';

  @override
  String get s_label => 'Namen';

  @override
  String get s_name => 'Name';

  @override
  String get s_usb => 'USB';

  @override
  String get s_nfc => 'NFC';

  @override
  String get s_options => 'Optionen';

  @override
  String get s_details => 'Details';

  @override
  String get s_show_window => 'Fenster anzeigen';

  @override
  String get s_hide_window => 'Fenster verstecken';

  @override
  String get s_show_navigation => 'Navigation anzeigen';

  @override
  String get s_expand_navigation => 'Navigationsleiste erweitern';

  @override
  String get s_collapse_navigation => 'Navigationsleiste minimieren';

  @override
  String get s_expand_collapse_navigation =>
      'Navigationsleiste erweitern/minimieren';

  @override
  String get s_show_menu => 'Menü anzeigen';

  @override
  String get s_toggle_menu_bar => 'Menüleiste anzeigen/ausblenden';

  @override
  String get s_more_info => 'Weitere Infos';

  @override
  String l_bullet(String item) {
    return '• $item';
  }

  @override
  String get s_none => '<keine>';

  @override
  String get s_about => 'Über';

  @override
  String get s_algorithm => 'Algorithmus';

  @override
  String get s_appearance => 'Aussehen';

  @override
  String get s_actions => 'Aktionen';

  @override
  String get s_manage => 'Verwalten';

  @override
  String get s_setup => 'Einrichten';

  @override
  String get s_device => 'Gerät';

  @override
  String get s_application => 'Anwendung';

  @override
  String get s_settings => 'Einstellungen';

  @override
  String get l_settings_desc => 'Anwendungs-Einstellungen ändern';

  @override
  String get s_certificates => 'Zertifikate';

  @override
  String get s_security_key => 'Sicherheitsschlüssel';

  @override
  String get s_slots => 'Slots';

  @override
  String get s_help_and_about => 'Hilfe und Info';

  @override
  String get l_help_and_about_desc => 'Problembehebung und Unterstützung';

  @override
  String get s_help_and_feedback => 'Hilfe und Feedback';

  @override
  String get s_home => 'Start';

  @override
  String get s_user_guide => 'Nutzerhandbuch';

  @override
  String get s_i_need_help => 'Hilfe';

  @override
  String get s_troubleshooting => 'Fehlersuche';

  @override
  String get s_terms_of_use => 'Nutzungsbedingungen';

  @override
  String get s_privacy_policy => 'Datenschutzerklärung';

  @override
  String get s_open_src_licenses => 'Open Source Lizenzen';

  @override
  String get s_please_wait => 'Bitte warten…';

  @override
  String get s_secret_key => 'Schlüssel';

  @override
  String get s_show_secret_key => 'Schlüssel anzeigen';

  @override
  String get s_hide_secret_key => 'Schlüssel ausblenden';

  @override
  String get s_private_key => 'Privater Schlüssel';

  @override
  String get s_public_key => 'Öffentlicher Schlüssel';

  @override
  String get s_invalid_length => 'Ungültige Länge';

  @override
  String l_invalid_format_allowed_chars(String characters) {
    return 'Ungültiges Format, erlaubte Zeichen: $characters';
  }

  @override
  String get l_invalid_keyboard_character =>
      'Ungültige Zeichen für ausgewählte Tastatur';

  @override
  String get s_require_touch => 'Berührung erforderlich';

  @override
  String get q_have_account_info => 'Hast du Konto Informationen?';

  @override
  String get s_run_diagnostics => 'Diagnose ausführen';

  @override
  String s_log_level(String level) {
    return 'Log-Level: $level';
  }

  @override
  String get s_character_count => 'Anzahl Zeichen';

  @override
  String get s_language => 'Sprache';

  @override
  String p_community_translations_desc(String crowdin) {
    return 'Die Übersetzungen werden von der Community auf $crowdin gepflegt.';
  }

  @override
  String get s_choose_language => 'Sprache wählen';

  @override
  String get s_app_theme => 'App Theme';

  @override
  String get s_choose_app_theme => 'App Theme auswählen';

  @override
  String get s_system_default => 'System-Standard­einstellung';

  @override
  String get s_light_mode => 'Heller Modus';

  @override
  String get s_dark_mode => 'Dunkler Modus';

  @override
  String get s_list_layout => 'Listen-Ansicht';

  @override
  String get s_grid_layout => 'Kachel-Ansicht';

  @override
  String get s_mixed_layout => 'Gemischte Ansicht';

  @override
  String get s_select_layout => 'Ansicht wählen';

  @override
  String get s_select_to_scan => 'Zum Scannen auswählen';

  @override
  String get s_hide_reader => 'Leser ausblenden';

  @override
  String get s_show_hidden_readers => 'Ausgeblendete Leser anzeigen';

  @override
  String get s_toggle_readers => 'Leser anzeigen/ausblenden';

  @override
  String get l_toggle_readers_desc => 'Leser anzeigen oder ausblenden';

  @override
  String s_sn_serial(int serial) {
    return 'S/N: $serial';
  }

  @override
  String s_fw_version(Object version) {
    return 'F/W: $version';
  }

  @override
  String l_serial_number(int serial) {
    return 'Seriennummer: $serial';
  }

  @override
  String l_firmware_version(Object version) {
    return 'Firmware-Version: $version';
  }

  @override
  String get l_fips_capable => 'FIPS fähig';

  @override
  String get l_fips_approved => 'FIPS zugelassen';

  @override
  String get l_insert_yk => 'YubiKey anschließen';

  @override
  String get l_insert_or_tap_yk =>
      'YubiKey anschließen oder an den Leser halten';

  @override
  String get l_unplug_yk => 'Entferne deinen YubiKey';

  @override
  String get l_reinsert_yk => 'Schließe deinen YubiKey wieder an';

  @override
  String get l_place_on_nfc_reader => 'Halte deinen YubiKey an den NFC-Leser';

  @override
  String get l_replace_yk_on_reader =>
      'Halte deinen YubiKey wieder an den Leser';

  @override
  String get l_remove_yk_from_reader => 'Entferne deinen YubiKey vom NFC-Leser';

  @override
  String get p_try_reinsert_yk =>
      'Versuche deinen YubiKey zu entfernen und wieder anzuschließen.';

  @override
  String get s_touch_required => 'Berührung erforderlich';

  @override
  String get l_touch_button_now => 'Berühre jetzt deinen YubiKey';

  @override
  String get l_keep_touching_yk => 'Berühre wiederholt deinen YubiKey…';

  @override
  String get s_capability_otp => 'Yubico OTP';

  @override
  String get s_capability_u2f => 'FIDO U2F';

  @override
  String get s_capability_fido2 => 'FIDO2';

  @override
  String get s_capability_oath => 'OATH';

  @override
  String get s_capability_piv => 'PIV';

  @override
  String get s_capability_openpgp => 'OpenPGP';

  @override
  String get s_capability_hsmauth => 'YubiHSM Auth';

  @override
  String get s_toggle_applications => 'Anwendungen aktivieren/deaktivieren';

  @override
  String get s_toggle_interfaces => 'Schnittstellen aktivieren/deaktivieren';

  @override
  String get p_toggle_applications_desc =>
      'Anwendungen per Schnittstelle aktivieren/deaktivieren.';

  @override
  String get p_toggle_interfaces_desc =>
      'USB-Schnittstellen aktivieren/deaktivieren.';

  @override
  String get l_toggle_applications_desc =>
      'Anwendungen aktivieren/deaktivieren';

  @override
  String get l_toggle_interfaces_desc =>
      'Schnittstellen aktivieren/deaktivieren';

  @override
  String get s_reconfiguring_yk => 'YubiKey wird neu konfiguriert…';

  @override
  String get s_config_updated => 'Konfiguration aktualisiert';

  @override
  String get l_config_updated_reinsert =>
      'Konfiguration aktualisiert, entferne deinen YubiKey und schließe ihn wieder an';

  @override
  String get s_fido_disabled => 'FIDO2 deaktiviert';

  @override
  String get l_webauthn_req_fido2 =>
      'WebAuthn erfordert, dass die FIDO2 Anwendung auf deinem YubiKey aktiviert ist';

  @override
  String get s_lock_code => 'Lock Code';

  @override
  String get l_wrong_lock_code => 'Falscher Lock Code';

  @override
  String get s_show_lock_code => 'Lock Code anzeigen';

  @override
  String get s_hide_lock_code => 'Lock Code verstecken';

  @override
  String get p_lock_code_required_desc =>
      'Diese Aktion erfordert die Eingabe des Konfigurations Lock Codes.';

  @override
  String get l_helper_not_responding => 'Der Helper-Prozess antwortet nicht';

  @override
  String get l_yk_no_access =>
      'Auf diesen YubiKey kann nicht zugegriffen werden';

  @override
  String get s_yk_inaccessible => 'Gerät nicht verfügbar';

  @override
  String get l_open_connection_failed => 'Fehler beim Verbindungsaufbau';

  @override
  String get l_ccid_connection_failed =>
      'Fehler beim Herstellen der Smartcard Verbindung';

  @override
  String get p_ccid_service_unavailable =>
      'Stelle bitte sicher, dass der Smartcard-Service verfügbar ist.';

  @override
  String get p_pcscd_unavailable =>
      'Stelle bitte sicher, dass pcscd installiert ist und ausgeführt wird.';

  @override
  String get l_no_yk_present => 'Kein YubiKey vorhanden';

  @override
  String get s_unknown_type => 'Unbekannter Typ';

  @override
  String get s_unknown_device => 'Unbekanntes Gerät';

  @override
  String get s_restricted_nfc => 'NFC-Aktivierung';

  @override
  String get l_deactivate_restricted_nfc => 'So aktivierst du NFC';

  @override
  String get p_deactivate_restricted_nfc_desc =>
      'Verbinde deinen YubiKey für mindestens 3 Sekunden mit einer USB-Stromquelle, z. B. einem Computer.\n\nSobald er mit Strom versorgt wird, wird NFC aktiviert und ist einsatzbereit.';

  @override
  String get p_deactivate_restricted_nfc_footer =>
      'Dein YubiKey ist mit einem Schutz vor drahtloser Manipulation während des Transports ausgestattet. Dies bedeutet, dass die NFC-Funktionen vorübergehend deaktiviert sind, bis du sie aktivierst.';

  @override
  String get s_unsupported_yk => 'Nicht unterstützter YubiKey';

  @override
  String get p_operation_failed_try_again =>
      'Die Aktion ist fehlgeschlagen, bitte versuche es erneut.';

  @override
  String get l_configuration_unsupported => 'Konfiguration nicht unterstützt';

  @override
  String get p_scp_unsupported =>
      'Dein Handy scheint die Kommunikation per NFC nicht zu unterstützen. Bitte schließe den YubiKey an den USB-Anschluss Deines Handys an.';

  @override
  String get l_error_occurred => 'Es ist ein Fehler aufgetreten';

  @override
  String get s_application_error => 'Anwendungs-Fehler';

  @override
  String get l_import_error => 'Importfehler';

  @override
  String get l_file_not_found => 'Datei nicht gefunden';

  @override
  String get l_file_too_big => 'Datei ist zu groß';

  @override
  String get l_filesystem_error => 'Fehler beim Dateisystem-Zugriff';

  @override
  String get s_pin => 'PIN';

  @override
  String get s_puk => 'PUK';

  @override
  String get s_set_pin => 'PIN setzen';

  @override
  String get s_change_pin => 'PIN ändern';

  @override
  String get s_change_puk => 'PUK ändern';

  @override
  String get s_show_pin => 'PIN anzeigen';

  @override
  String get s_hide_pin => 'PIN ausblenden';

  @override
  String get s_show_puk => 'PUK anzeigen';

  @override
  String get s_hide_puk => 'PUK ausblenden';

  @override
  String get s_current_pin => 'Aktuelle PIN';

  @override
  String get s_current_puk => 'Aktuelle PUK';

  @override
  String get s_new_pin => 'Neue PIN';

  @override
  String get s_new_puk => 'Neue PUK';

  @override
  String get s_confirm_pin => 'PIN bestätigen';

  @override
  String get s_confirm_puk => 'PUK bestätigen';

  @override
  String get s_unblock_pin => 'PIN zurücksetzen';

  @override
  String get l_pin_mismatch => 'PINs stimmen nicht überein';

  @override
  String get l_puk_mismatch => 'PUKs stimmen nicht überein';

  @override
  String get s_pin_set => 'PIN gesetzt';

  @override
  String get s_puk_set => 'PUK gesetzt';

  @override
  String l_set_pin_failed(String message) {
    return 'PIN konnte nicht gesetzt werden: $message';
  }

  @override
  String l_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries verbleibende Versuche',
      one: '$retries verbleibender Versuch',
    );
    return '$_temp0';
  }

  @override
  String l_wrong_pin_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries verbleibende Versuche',
      one: '$retries verbleibender Versuch',
    );
    return 'Falsche PIN, $_temp0';
  }

  @override
  String l_wrong_puk_attempts_remaining(int retries) {
    String _temp0 = intl.Intl.pluralLogic(
      retries,
      locale: localeName,
      other: '$retries verbleibende Versuche',
      one: '$retries verbleibender Versuch',
    );
    return 'Falsche PUK, $_temp0';
  }

  @override
  String get s_fido_pin_protection => 'FIDO PIN Schutz';

  @override
  String get s_pin_change_required => 'PIN Änderung erforderlich';

  @override
  String get l_enter_fido2_pin => 'Gib die FIDO2 PIN für deinen YubiKey ein';

  @override
  String get l_pin_blocked_reset =>
      'PIN ist geblockt; setze die FIDO Anwendung auf Werkseinstellung zurück';

  @override
  String get l_pin_blocked => 'PIN ist geblockt';

  @override
  String get l_set_pin_first => 'PIN benötigt';

  @override
  String get l_unlock_pin_first => 'Mit PIN entsperren';

  @override
  String get l_pin_soft_locked =>
      'PIN ist geblockt bis der YubiKey entfernt und wieder angeschlossen wird';

  @override
  String get l_pin_change_required_desc =>
      'Vor Verwendung der Anwendung muss eine neue PIN gesetzt werden';

  @override
  String p_new_fido2_pin_requirements(int min_length, int max_length) {
    return 'Eine PIN muss aus $min_length-$max_length Zeichen bestehen und kann Buchstaben, Ziffern und Sonderzeichen enthalten.';
  }

  @override
  String p_new_fido2_pin_complexity_active_requirements(
    int min_length,
    int max_length,
    int unique_characters,
    String common_pin,
  ) {
    return 'Eine PIN muss aus $min_length-$max_length Zeichen bestehen, muss mindestens $unique_characters unterschiedliche Zeichen enthalten und darf keine triviale PIN wie z.B. \"$common_pin\" sein. Die PIN kann Buchstaben, Ziffern und Sonderzeichen enthalten.';
  }

  @override
  String get s_ep_attestation => 'Enterprise Attestation';

  @override
  String get s_ep_attestation_enabled => 'Enterprise Attestation aktiviert';

  @override
  String get q_enable_ep_attestation => 'Enterprise Attestation aktivieren?';

  @override
  String get p_enable_ep_attestation_desc =>
      'Dies aktiviert Enterprise Attestation, eine Funktion die es berechtigten Domains ermöglicht deinen YubiKey eindeutig zu identifizieren.';

  @override
  String get p_enable_ep_attestation_disable_with_factory_reset =>
      'Einmal aktiviert, kann Enterprise Attestation nur durch einen FIDO-Reset deaktiviert werden.';

  @override
  String get s_pin_required => 'PIN erforderlich';

  @override
  String get p_pin_required_desc => 'Diese Aktion erfordert die PIV PIN.';

  @override
  String get l_piv_pin_blocked => 'Gesperrt, verwende die PUK zum Zurücksetzen';

  @override
  String get p_piv_pin_blocked_desc =>
      'Die PIN ist blockiert. Benutze die PUK um sie zurückzusetzen.';

  @override
  String get p_piv_pin_blocked_bio_desc =>
      'Die PIN ist gesperrt. Ein Zurücksetzen auf Werkseinstellungen ist erforderlich.';

  @override
  String get l_piv_pin_puk_blocked =>
      'Gesperrt, Zurücksetzen auf Werkseinstellungen erforderlich';

  @override
  String get p_piv_pin_puk_blocked_desc =>
      'Sowohl die PIN als auch PUK sind blockiert. Die PIV-Anwendung muss zurückgesetzt werden.';

  @override
  String p_new_piv_pin_puk_requirements(String name, int length) {
    return 'Eine $name muss mindestens $length Zeichen lang sein.';
  }

  @override
  String p_new_piv_pin_puk_complexity_active_requirements(
    String name,
    int length,
    String common,
  ) {
    return 'Ein $name muss mindestens $length Zeichen lang sein, mindestens 2 eindeutige Zeichen enthalten und darf nicht eine häufig verwendete $name sein, wie z.B. \"$common\".';
  }

  @override
  String p_pin_puk_complexity_failure(String name) {
    return 'Die neue $name entspricht nicht den Komplexitätsanforderungen.';
  }

  @override
  String get s_dismiss => 'Schließen';

  @override
  String get p_default_pin_puk_key_desc =>
      'Wir empfehlen Dir die Standard-PIN, -PUK und den Management-Key zu ändern.\n';

  @override
  String get l_warning_default_pin =>
      'Achtung: Die Standard-PIN ist konfiguriert';

  @override
  String get l_warning_default_puk =>
      'Achtung: Die Standard-PUK ist konfiguriert';

  @override
  String get l_default_pin_used => 'Standard-PIN konfiguriert';

  @override
  String get l_default_puk_used => 'Standard-PUK konfiguriert';

  @override
  String get l_pin_complexity => 'PIN-Komplexität aktiv';

  @override
  String get s_password => 'Passwort';

  @override
  String get s_manage_password => 'Passwort verwalten';

  @override
  String get s_set_password => 'Passwort setzen';

  @override
  String get s_password_set => 'Passwort gesetzt';

  @override
  String get s_show_password => 'Passwort anzeigen';

  @override
  String get s_hide_password => 'Passwort ausblenden';

  @override
  String get l_password_protection => 'Passwortschutz von Konten';

  @override
  String get s_new_password => 'Neues Passwort';

  @override
  String get s_current_password => 'Aktuelles Passwort';

  @override
  String get s_confirm_password => 'Passwort bestätigen';

  @override
  String get l_password_mismatch => 'Passwörter stimmen nicht überein';

  @override
  String get s_wrong_password => 'Falsches Passwort';

  @override
  String get p_wrong_password =>
      'Falsches Passwort. Wenn Du Dein Passwort nicht kennst, musst Du den YubiKey zurücksetzen.';

  @override
  String get s_remove_password => 'Passwort entfernen';

  @override
  String get s_password_removed => 'Passwort entfernt';

  @override
  String get s_remember_password => 'Passwort speichern';

  @override
  String get s_clear_saved_password => 'Gespeichertes Passwort entfernen';

  @override
  String get s_password_forgotten => 'Passwort vergessen';

  @override
  String get l_keystore_unavailable =>
      'Keystore des Betriebssystems nicht verfügbar';

  @override
  String get l_remember_pw_failed => 'Passwort konnte nicht gespeichert werden';

  @override
  String get l_unlock_first => 'Mit Passwort entsperren';

  @override
  String get l_set_password_first => 'Passwort setzen';

  @override
  String get l_enter_oath_pw => 'Gib das OATH Passwort für deinen YubiKey ein';

  @override
  String get p_new_password_requirements =>
      'Ein Passwort kann Buchstaben, Zahlen und Sonderzeichen enthalten.';

  @override
  String get s_management_key => 'Management-Key';

  @override
  String get s_current_management_key => 'Aktueller Management-Key';

  @override
  String get s_new_management_key => 'Neuer Management-Key';

  @override
  String get l_change_management_key => 'Management-Key ändern';

  @override
  String get l_management_key_changed => 'Management-Key geändert';

  @override
  String get l_default_key_used => 'Standard Management-Key konfiguriert';

  @override
  String get s_generate_random => 'Zufällig generieren';

  @override
  String get s_use_default => 'Standard verwenden';

  @override
  String get l_warning_default_key =>
      'Achtung: Der Standard Management-Key ist konfiguriert';

  @override
  String get s_protect_key => 'Mit PIN schützen';

  @override
  String get p_protect_key_desc =>
      'Verwende die PIN anstelle des Management-Schlüssels bei Vorgängen, die eine Authentifizierung per Management-Key benötigen.';

  @override
  String get s_management_key_algorithm => 'Management-Key Algorithmus';

  @override
  String get p_management_key_algorithm_desc =>
      'Der zu verwendende Algorithmus für den Management-Key.';

  @override
  String get l_pin_protected_key => 'PIN kann stattdessen verwendet werden';

  @override
  String get l_wrong_key => 'Falscher Key';

  @override
  String get l_unlock_piv_management => 'PIV Verwaltung entsperren';

  @override
  String get p_unlock_piv_management_desc =>
      'Diese Aktion erfordert den PIV Management-Key.';

  @override
  String l_account(String label) {
    return 'Konto: $label';
  }

  @override
  String get s_accounts => 'Konten';

  @override
  String get s_no_accounts => 'Keine Konten';

  @override
  String l_results_for(String query) {
    return 'Ergebnisse für \"$query\"';
  }

  @override
  String get l_authenticator_get_started => 'Erste Schritte mit OTP Konten';

  @override
  String get l_no_accounts_desc =>
      'Füge One-Time Password (OATH HOTP/TOTP) Konten zu Deinem YubiKey hinzu';

  @override
  String get s_add_account => 'Konto hinzufügen';

  @override
  String get p_add_account_desc =>
      'QR-Code scannen oder die Zugangsdaten manuell eingeben.';

  @override
  String get s_add_accounts => 'Konten hinzufügen';

  @override
  String get l_drop_qr_description =>
      'QR-Code per Drag & Drop hierhin ziehen, um Konten hinzuzufügen';

  @override
  String get p_add_account_three_ways =>
      'Es gibt drei Möglichkeiten, Konten hinzuzufügen.';

  @override
  String get s_scanning => 'Scannen (empfohlen)';

  @override
  String get p_scanning_desc =>
      'Vergewissere Dich vor dem Scannen eines QR-Codes, dass der vollständige Code auf dem Bildschirm zu sehen ist.';

  @override
  String get s_drag_and_drop => 'Drag&Drop';

  @override
  String get p_drag_and_drop_desc =>
      'Ein Bild, das einen QR-Code enthält, kann an einer beliebigen Stelle in der Kontenansicht abgelegt werden.';

  @override
  String get s_manually => 'Manuell';

  @override
  String get p_manually_desc =>
      'Zugangsdaten können manuell in das Formular eingegeben werden.';

  @override
  String get s_account_added => 'Konto hinzugefügt';

  @override
  String l_account_add_failed(String message) {
    return 'Fehler beim Hinzufügen des Kontos: $message';
  }

  @override
  String get l_add_account_password_required => 'Passwort erforderlich';

  @override
  String get l_add_account_unlock_required => 'Freischaltung erforderlich';

  @override
  String get l_add_account_already_exists => 'Konto existiert bereits';

  @override
  String get l_add_account_func_missing =>
      'Funktion nicht verfügbar oder deaktiviert';

  @override
  String get l_account_name_required => 'Dein Konto muss einen Namen haben';

  @override
  String get l_name_already_exists =>
      'Dieser Name wird für diesen Aussteller bereits verwendet';

  @override
  String get l_account_already_exists =>
      'Dieses Konto existiert bereits auf dem YubiKey';

  @override
  String get l_invalid_character_issuer =>
      'Ungültiges Zeichen: \':\' ist im Feld für Aussteller nicht erlaubt';

  @override
  String get l_select_accounts => 'Konten zum Hinzufügen zum YubiKey auswählen';

  @override
  String get s_pin_account => 'Konto anpinnen';

  @override
  String get s_unpin_account => 'Konto nicht mehr anpinnen';

  @override
  String get s_no_pinned_accounts => 'Keine angepinnten Konten';

  @override
  String get s_pinned => 'Angepinnt';

  @override
  String get l_pin_account_desc =>
      'Behalte die Übersicht über deine wichtigsten Konten';

  @override
  String get s_rename_account => 'Konto umbenennen';

  @override
  String get l_rename_account_desc =>
      'Bearbeite den Aussteller/Namen des Kontos';

  @override
  String get s_account_renamed => 'Konto umbenannt';

  @override
  String l_rename_account_failed(String message) {
    return 'Umbenennung des Kontos fehlgeschlagen: $message';
  }

  @override
  String get p_rename_will_change_account_displayed =>
      'Dies ändert die Anzeige des Kontos in der Liste.';

  @override
  String get s_delete_account => 'Konto löschen';

  @override
  String get q_delete_account => 'Konto löschen?';

  @override
  String get l_delete_account_desc => 'Lösche das Konto von deinem YubiKey';

  @override
  String get s_account_deleted => 'Konto gelöscht';

  @override
  String get p_warning_delete_account =>
      'Achtung! Du bist dabei das Konto von deinem YubiKey zu löschen.';

  @override
  String get p_warning_disable_credential =>
      'Achte darauf, dass dieses Anmeldedaten von keinem Dienst verwendet werden um nicht ausgesperrt zu werden.';

  @override
  String get s_account_name => 'Kontoname';

  @override
  String get s_search_accounts => 'Konten durchsuchen';

  @override
  String l_accounts_used(int used, int capacity) {
    return '$used von $capacity Konten verwendet';
  }

  @override
  String s_num_digits(int num) {
    return '$num Ziffern';
  }

  @override
  String s_num_sec(int num) {
    return '$num sek';
  }

  @override
  String get s_issuer_optional => 'Anbieter/Dienst (optional)';

  @override
  String get s_counter_based => 'Zähler-basiert';

  @override
  String get s_time_based => 'Zeit-basiert';

  @override
  String get l_copy_code_desc => 'Füge den Code in einer anderen Anwendung ein';

  @override
  String get l_calculate_code_desc =>
      'Erhalte einen neuen Code von deinem YubiKey';

  @override
  String get s_rp_id => 'RP ID';

  @override
  String get s_user_id => 'Benutzer ID';

  @override
  String get s_credential_id => 'Anmeldedaten ID';

  @override
  String get s_display_name => 'Anzeigename';

  @override
  String get s_user_name => 'Benutzername';

  @override
  String get s_passkeys => 'Passkeys';

  @override
  String get s_no_passkeys => 'Keine Passkeys';

  @override
  String get l_ready_to_use => 'Bereit zur Verwendung';

  @override
  String get l_register_sk_on_websites =>
      'Als Sicherheitsschlüssel auf Webseiten registrieren';

  @override
  String get l_no_discoverable_accounts => 'Keine Passkeys gespeichert';

  @override
  String get p_non_passkeys_note =>
      'Die Liste beinhaltet ausschließlich Passkeys. Weitere Anmeldedaten können existieren.';

  @override
  String get s_delete_passkey => 'Passkey löschen';

  @override
  String get q_delete_passkey => 'Passkey löschen?';

  @override
  String get l_delete_passkey_desc => 'Entfernen Sie den Passkey vom YubiKey';

  @override
  String get s_passkey_deleted => 'Passkey gelöscht';

  @override
  String get p_warning_delete_passkey =>
      'Achtung! Diese Aktion löscht den Passkey von deinem YubiKey.';

  @override
  String get p_warning_delete_passkey_desc =>
      'Du wirst diesen Passkey nicht mehr für den Dienst, für den er registriert ist, verwenden können.';

  @override
  String get s_search_passkeys => 'Passkeys durchsuchen';

  @override
  String p_passkeys_used(int used, int max) {
    return '$used von $max Passkeys verwendet.';
  }

  @override
  String get s_biometrics => 'Biometrische Daten';

  @override
  String l_fingerprint(String label) {
    return 'Fingerabdruck: $label';
  }

  @override
  String get s_fingerprints => 'Fingerabdrücke';

  @override
  String get l_fingerprint_captured => 'Fingerabdruck erfolgreich erfasst!';

  @override
  String get s_fingerprint_added => 'Fingerabdruck hinzugefügt';

  @override
  String l_adding_fingerprint_failed(String message) {
    return 'Fehler beim Hinzufügen des Fingerabdrucks: $message';
  }

  @override
  String l_setting_name_failed(String message) {
    return 'Fehler beim Zuweisen des Namens: $message';
  }

  @override
  String get s_setup_fingerprints => 'Fingerabdrücke einrichten';

  @override
  String get p_setup_fingerprints_desc =>
      'Fingerabdrücken müssen eingerichtet werden, bevor der Schlüssel verwendet werden kann.';

  @override
  String get s_add_fingerprint => 'Fingerabdruck hinzufügen';

  @override
  String get s_delete_fingerprint => 'Fingerabdruck löschen';

  @override
  String get q_delete_fingerprint => 'Fingerabdruck löschen?';

  @override
  String get l_delete_fingerprint_desc => 'Fingerabdruck vom YubiKey entfernen';

  @override
  String get s_fingerprint_deleted => 'Fingerabdruck gelöscht';

  @override
  String get p_warning_delete_fingerprint =>
      'Dies löscht den Fingerabdruck von deinem YubiKey.';

  @override
  String get s_fingerprints_get_started => 'Erste Schritte mit Fingerabdrücken';

  @override
  String get p_set_fingerprints_desc =>
      'Bevor du Fingerabdrücke hinzufügen kannst, muss eine PIN gesetzt werden.';

  @override
  String get l_no_fps_added => 'Es wurden keine Fingerabdrücke hinzugefügt';

  @override
  String get s_rename_fp => 'Fingerabdruck umbenennen';

  @override
  String get l_rename_fp_desc => 'Namen ändern';

  @override
  String get s_fingerprint_renamed => 'Fingerabdruck umbenannt';

  @override
  String l_rename_fp_failed(String message) {
    return 'Fehler beim Umbenennen: $message';
  }

  @override
  String get l_add_one_or_more_fps => 'Füge bis zu fünf Fingerabdrücke hinzu';

  @override
  String l_fingerprints_used(int used) {
    return '$used/5 Fingerabdrücke registriert';
  }

  @override
  String get p_press_fingerprint_begin =>
      'Lege den Finger auf den Sensor deines YubiKeys um zu beginnen.';

  @override
  String get l_name_fingerprint =>
      'Für diesen Fingerabdruck einen Namen vergeben';

  @override
  String get l_user_action_timeout_error =>
      'Wegen Benutzer-Inaktivität fehlgeschlagen';

  @override
  String get l_wrong_inserted_yk_error =>
      'Verwendeter YubiKey stimmt nicht mit dem initialen Gerät überein';

  @override
  String get l_failed_connecting_to_fido =>
      'Die Verbindung zur FIDO-Schnittstelle ist fehlgeschlagen';

  @override
  String get l_self_signed_certificate => 'Selbstsigniertes Zertifikat';

  @override
  String get l_certificate_signing_request =>
      'Certificate Signing Request (CSR)';

  @override
  String get s_certificate => 'Zertifikat';

  @override
  String get s_subject => 'Betreff';

  @override
  String get l_export_csr_file => 'CSR in Datei speichern';

  @override
  String get l_export_public_key => 'Öffentlichen Schlüssel exportieren';

  @override
  String get l_export_public_key_file =>
      'Öffentlichen Schlüssel in Datei speichern';

  @override
  String get l_export_public_key_desc =>
      'Öffentlichen Schlüssel in eine Datei exportieren';

  @override
  String get l_public_key_exported => 'Öffentlicher Schlüssel wurde exportiert';

  @override
  String get l_export_certificate => 'Zertifikat exportieren';

  @override
  String get l_export_certificate_file => 'Zertifikat in Datei exportieren';

  @override
  String get l_export_certificate_desc =>
      'Das Zertifikat in eine Datei exportieren';

  @override
  String get l_certificate_exported => 'Zertifikat exportiert';

  @override
  String get l_select_import_file => 'Datei zum Importieren auswählen';

  @override
  String get l_import_file => 'Datei importieren';

  @override
  String get l_import_desc =>
      'Importieren Sie einen Schlüssel und/oder ein Zertifikat';

  @override
  String get l_import_nothing => 'Nichts zu importieren';

  @override
  String get l_importing_file => 'Importiere Datei…';

  @override
  String get s_file_imported => 'Datei importiert';

  @override
  String get l_unsupported_key_type => 'Schlüssel-Typ wird nicht unterstützt';

  @override
  String get l_delete_certificate => 'Zertifikat löschen';

  @override
  String get q_delete_certificate => 'Zertifikat löschen?';

  @override
  String get l_delete_certificate_desc =>
      'Entferne das Zertifikat von deinem YubiKey';

  @override
  String get l_delete_key => 'Schlüssel löschen';

  @override
  String get q_delete_key => 'Schlüssel löschen?';

  @override
  String get l_delete_key_desc => 'Entferne den Schlüssel von deinem YubiKey';

  @override
  String get l_delete_certificate_or_key => 'Zertifikat/Schlüssel löschen';

  @override
  String get q_delete_certificate_or_key => 'Zertifikat/Schlüssel löschen?';

  @override
  String get l_delete_certificate_or_key_desc =>
      'Entferne das Zertifikat oder den Schlüssel von deinem YubiKey';

  @override
  String get l_move_key => 'Schlüssel verschieben';

  @override
  String get l_move_key_desc =>
      'Verschiebe einen Schlüssel zwischen zwei  PIV Slots';

  @override
  String get l_change_defaults => 'Standard Access Codes ändern';

  @override
  String get s_issuer => 'Aussteller';

  @override
  String get s_serial => 'Serial';

  @override
  String get s_certificate_fingerprint => 'Fingerprint';

  @override
  String get s_valid_from => 'Gültig von';

  @override
  String get s_valid_to => 'Gültig bis';

  @override
  String get l_no_certificate => 'Kein Zertifikat geladen';

  @override
  String get l_key_no_certificate => 'Schlüssel ohne Zertifikat geladen';

  @override
  String get s_generate_key => 'Schlüssel erzeugen';

  @override
  String get l_generate_desc => 'Erzeuge ein neues Zertifikat oder CSR';

  @override
  String p_generate_desc(String slot) {
    return 'Dies generiert einen neuen Schlüssel auf Deinem YubiKey in PIV-Slot $slot.';
  }

  @override
  String get s_private_key_generated => 'Privater Schlüssel erzeugt';

  @override
  String get p_select_what_to_delete =>
      'Wähle aus was aus dem Slot gelöscht werden soll.';

  @override
  String get p_warning_delete_certificate =>
      'Achtung! Diese Aktion löscht das Zertifikat von deinem YubiKey.';

  @override
  String get p_warning_delete_key =>
      'Achtung! Diese Aktion löscht den privaten Schlüssel von deinem YubiKey.';

  @override
  String get p_warning_delete_certificate_and_key =>
      'Achtung! Diese Aktion löscht das Zertifikat und den privaten Schlüssel von deinem YubiKey.';

  @override
  String p_delete_certificate_desc(String slot) {
    return 'Dadurch wird das Zertifikat im PIV-Slot $slot gelöscht.';
  }

  @override
  String p_delete_key_desc(String slot) {
    return 'Dadurch wird der private Schlüssel im PIV-Slot $slot gelöscht.';
  }

  @override
  String p_delete_certificate_and_key_desc(String slot) {
    return 'Dadurch werden das Zertifikat und der private Schlüssel im PIV-Slot $slot gelöscht.';
  }

  @override
  String get l_certificate_deleted => 'Zertifikat gelöscht';

  @override
  String get l_key_deleted => 'Schlüssel gelöscht';

  @override
  String get l_certificate_and_key_deleted =>
      'Zertifikat und Schlüssel gelöscht';

  @override
  String get l_include_certificate => 'Zertifikat einbeziehen';

  @override
  String get l_select_destination_slot => 'Ziel-Slot wählen';

  @override
  String q_move_key_confirm(String from_slot) {
    return 'Soll der private Schlüssel in  PIV Slot $from_slot verschoben werden?';
  }

  @override
  String q_move_key_to_slot_confirm(String from_slot, String to_slot) {
    return 'Soll der private Schlüssel von PIV Slot $from_slot zu Slot $to_slot verschoben werden?';
  }

  @override
  String q_move_key_and_certificate_to_slot_confirm(
    String from_slot,
    String to_slot,
  ) {
    return 'Soll der private Schlüssel und das Zertifikat von PIV Slot $from_slot zu Slot $to_slot verschoben werden?';
  }

  @override
  String get p_password_protected_file =>
      'Die ausgewählte Datei ist passwortgeschützt.';

  @override
  String p_import_items_desc(String slot) {
    return 'Die folgenden Elemente werden in den PIV Slot $slot importiert.';
  }

  @override
  String get l_warning_public_key_mismatch =>
      'Der öffentliche Schlüssel des Zertifikats stimmt nicht mit dem privaten Schlüssel im Slot überein';

  @override
  String get l_key_moved => 'Schlüssel verschoben';

  @override
  String get l_key_and_certificate_moved =>
      'Schlüssel und Zertifikat verschoben';

  @override
  String get p_subject_desc =>
      'Distinguished Name (DN) RFC 4514 konform formatiert.';

  @override
  String get l_rfc4514_invalid => 'Ungültiges RFC 4514Format';

  @override
  String get rfc4514_examples =>
      'Beispiele:\nCN=Beispielname\nCN=jsmith,DC=example,DC=net';

  @override
  String get s_allow_fingerprint => 'Fingerabdruck zulassen';

  @override
  String get s_pin_policy => 'PIN Richtlinie';

  @override
  String get s_output_format => 'Ausgabeformat';

  @override
  String get s_expiration_date => 'Ablaufdatum';

  @override
  String get p_algorithm_desc => 'Zu verwendender Schlüsselalgorithmus.';

  @override
  String get p_expiration_date_desc =>
      'Datum, an dem das Zertifikat abläuft, standardmäßig 1 Jahr (betrifft nur das Zertifikat).';

  @override
  String get p_key_options_bio_desc =>
      'Erlaube die Verwendung von Fingerabdrücken anstelle der PIN.';

  @override
  String get q_overwrite_slot => 'Slot überschreiben?';

  @override
  String p_overwrite_slot_desc(String slot) {
    return 'Dies überschreibt dauerhaft evtl. vorhandenen Inhalt in Slot $slot.';
  }

  @override
  String get l_overwrite_cert => 'Das Zertifikat wird überschrieben';

  @override
  String get l_overwrite_key => 'Der private Schlüssel wird überschrieben';

  @override
  String get l_overwrite_key_maybe =>
      'Ein vorhandener privater Schlüssel im Slot wird überschrieben';

  @override
  String s_slot_display_name(String name, String hexid) {
    return '$name ($hexid)';
  }

  @override
  String get s_slot_9a => 'Authentifizierung';

  @override
  String get s_slot_9c => 'Digitale Signatur';

  @override
  String get s_slot_9d => 'Schlüssel Verwaltung';

  @override
  String get s_slot_9e => 'Karten Authentifizierung';

  @override
  String get s_retired_slot => 'Verwaltung zurückgezogener Schlüssel';

  @override
  String get s_otp_slot_one => 'Kurze Berührung';

  @override
  String get s_otp_slot_two => 'Lange Berührung';

  @override
  String get l_otp_slot_empty => 'Slot ist leer';

  @override
  String get l_otp_slot_configured => 'Slot ist konfiguriert';

  @override
  String get l_yubiotp_desc =>
      'Konfiguriere Yubico OTP basierte Authentifizierung';

  @override
  String get s_challenge_response => 'Challenge-Response';

  @override
  String get l_challenge_response_desc =>
      'Konfiguriere Challenge-Response basierte Authentifizierung';

  @override
  String get s_static_password => 'Statisches Passwort';

  @override
  String get l_static_password_desc => 'Konfiguriere ein statisches Passwort';

  @override
  String get s_hotp => 'OATH-HOTP';

  @override
  String get l_hotp_desc => 'Konfiguriere HMAC-SHA1 basierte Authentifizierung';

  @override
  String get s_public_id => 'Öffentliche ID';

  @override
  String get s_private_id => 'Private ID';

  @override
  String get s_use_serial => 'Seriennummer verwenden';

  @override
  String get l_select_file => 'Datei auswählen';

  @override
  String get l_no_export_file => 'Keine Datei für den Export';

  @override
  String get s_no_export => 'Kein Export';

  @override
  String get s_export => 'Export';

  @override
  String get l_export_configuration_file =>
      'Exportiere die Konfiguration in eine Datei';

  @override
  String l_exported_can_be_uploaded_at(String url) {
    return 'Exportierte Anmeldedaten können auf $url hochgeladen werden';
  }

  @override
  String l_keyboard_layout(Object layout) {
    return 'Tastatur $layout';
  }

  @override
  String get s_delete_slot => 'Anmeldedaten löschen';

  @override
  String get q_delete_slot => 'Anmeldedaten löschen?';

  @override
  String get l_delete_slot_desc => 'Anmeldedaten in Slot löschen';

  @override
  String p_warning_delete_slot_configuration(int slot_id) {
    return 'Achtung! Diese Aktion löscht die Anmeldedaten dauerhaft aus Slot $slot_id.';
  }

  @override
  String get l_slot_deleted => 'Anmeldedaten gelöscht';

  @override
  String get s_swap => 'Tauschen';

  @override
  String get s_swap_slots => 'Slots tauschen';

  @override
  String get q_swap_slots => 'Slots tauschen?';

  @override
  String get l_swap_slots_desc => 'Kurze/lange Berührung tauschen';

  @override
  String get p_swap_slots_desc =>
      'Dies tauscht die Konfiguration der beiden Slots.';

  @override
  String get l_slots_swapped => 'Slot Konfigurationen getauscht';

  @override
  String l_slot_credential_configured(String type) {
    return '$type Anmeldedaten konfiguriert';
  }

  @override
  String l_slot_credential_configured_and_exported(String type, String file) {
    return '$type Anmeldedaten konfiguriert und nach $file';
  }

  @override
  String get s_append_enter => '⏎ anhängen';

  @override
  String get l_append_enter_desc =>
      'Nach dem OTP einen Druck der Eingabetaste simulieren';

  @override
  String get p_otp_swap_error =>
      'Das Vertauschen der Slots ist fehlgeschlagen! Stelle sicher, dass der YubiKey nicht zugriffsgeschützt ist.';

  @override
  String get l_wrong_access_code => 'Falscher Access Code';

  @override
  String get s_access_code => 'Access Code';

  @override
  String get s_show_access_code => 'Access Code anzeigen';

  @override
  String get s_hide_access_code => 'Access Code ausblenden';

  @override
  String p_enter_access_code(String slot) {
    return 'Access Code für Slot $slot eingeben.';
  }

  @override
  String get s_enable_nfc => 'NFC aktivieren';

  @override
  String get s_request_access => 'Zugriff anfordern';

  @override
  String get s_permission_denied => 'Zugriff verweigert';

  @override
  String get l_elevating_permissions => 'Erweitere Berechtigungen…';

  @override
  String get s_review_permissions => 'Berechtigungen überprüfen';

  @override
  String get s_open_windows_settings => 'Windows-Einstellungen öffnen';

  @override
  String get l_admin_privileges_required => 'Administrator-Rechte erforderlich';

  @override
  String get p_elevated_permissions_required =>
      'Die Verwaltung dieses Geräts benötigt erweiterte Berechtigungen. Alternativ kannst Du die Windows Einstellungen zur Verwaltung der FIDO Konfiguration verwenden.';

  @override
  String get p_webauthn_elevated_permissions_required =>
      'WebAuthn-Verwaltung benötigt erweiterte Berechtigungen.';

  @override
  String get l_ms_store_permission_note =>
      'Die Version der App aus dem Microsoft Store kann ggf. keine erweiterten Berechtigungen anfragen';

  @override
  String get p_need_camera_permission =>
      'Yubico Authenticator benötigt Zugriff auf die Kamera um QR-Codes aufnehmen zu können.';

  @override
  String get s_qr_scan => 'QR-Code aufnehmen';

  @override
  String get l_invalid_qr => 'Ungültiger QR-Code';

  @override
  String get l_qr_not_found => 'Kein QR-Code gefunden';

  @override
  String get l_qr_scanned => 'QR-Code gescannt';

  @override
  String l_qr_file_too_large(String max) {
    return 'Datei zu groß (max $max)';
  }

  @override
  String get l_qr_invalid_image_file => 'Ungültige Bilddatei';

  @override
  String get l_qr_select_file => 'Datei mit QR-Code auswählen';

  @override
  String l_qr_not_read(String message) {
    return 'Fehler beim Lesen des QR-Codes: $message';
  }

  @override
  String get l_point_camera_scan =>
      'Richte die Kamera zum Scannen auf einen QR-Code';

  @override
  String get q_want_to_scan => 'Möchtest du scannen?';

  @override
  String get q_no_qr => 'Kein QR-Code?';

  @override
  String get s_enter_manually => 'Manuell eingeben';

  @override
  String get s_read_from_file => 'Aus Datei lesen';

  @override
  String get s_reset => 'Zurücksetzen';

  @override
  String get s_factory_reset => 'Auf Werkseinstellungen zurücksetzen';

  @override
  String get l_factory_reset_desc =>
      'YubiKey-Standardeinstellungen wiederherstellen';

  @override
  String get l_factory_reset_required =>
      'Zurücksetzen auf Werkseinstellungen erforderlich';

  @override
  String get l_oath_application_reset => 'OATH Anwendung zurücksetzen';

  @override
  String get l_fido_app_reset => 'FIDO Anwendung zurücksetzen';

  @override
  String l_reset_failed(String message) {
    return 'Fehler beim Zurücksetzen: $message';
  }

  @override
  String get l_piv_app_reset => 'PIV Anwendung zurücksetzen';

  @override
  String get p_factory_reset_an_app =>
      'Setze eine Anwendung des YubiKey auf Werkseinstellungen zurück.';

  @override
  String get p_factory_reset_desc =>
      'Daten werden in mehreren Anwendungen auf dem YubiKey gespeichert. Einige dieser Anwendungen können unabhängig voneinander auf Werkseinstellungen zurückgesetzt werden.\n\nWähle oben eine Anwendung zum Zurücksetzen aus.';

  @override
  String get p_warning_factory_reset =>
      'Achtung! Dies löscht alle OATH TOTP/HOTP Konten dauerhaft von deinem YubiKey.';

  @override
  String get p_warning_disable_credentials =>
      'Deine OATH Anmeldedaten und sämtliche Passwörter werden von diesem YubiKey entfernt. Deaktiviere die Anmeldedaten unbedingt zuerst auf den zugehörigen Webseiten, bevor du fortfährst, um nicht aus deinen Konten ausgesperrt zu werden.';

  @override
  String get p_warning_deletes_accounts =>
      'Achtung! Dies löscht alle U2F und FIDO2 Konten dauerhaft von deinem YubiKey.';

  @override
  String get p_warning_disable_accounts =>
      'Deine Anmeldedaten und sämtliche PINs werden von diesem YubiKey entfernt. Deaktiviere die Anmeldedaten unbedingt zuerst auf den zugehörigen Webseiten, bevor du fortfährst, um nicht aus deinen Konten ausgesperrt zu werden.';

  @override
  String get p_warning_piv_reset =>
      'Achtung! Alle gespeicherten PIV Daten werden dauerhaft von deinem YubiKey gelöscht.';

  @override
  String get p_warning_piv_reset_desc =>
      'Dies schließt private Schlüssel und Zertifikate mit ein. Deine PIN, PUK und der Management-Key werden auf Werkseinstellung zurückgesetzt.';

  @override
  String get p_warning_global_reset =>
      'Achtung! Dies löscht alle gespeicherten Daten inkl. Anmeldedaten dauerhaft von deinem YubiKey.';

  @override
  String get p_warning_global_reset_desc =>
      'Setzt die Anwendungen auf Ihrem YubiKey auf Werkseinstellungen zurück. Ihre PIN wird auf ihre Werkseinstellung zurückgesetzt, gespeicherte Fingerabdrücke werden entfernt, jegliche Schlüssel, Zertifikate oder andere Anmeldeinformationen werden dauerhaft entfernt.';

  @override
  String get l_copy_to_clipboard => 'In die Zwischenablage kopieren';

  @override
  String get s_code_copied => 'Code kopiert';

  @override
  String get l_code_copied_clipboard => 'Code in die Zwischenablage kopiert';

  @override
  String get s_copy_log => 'Log kopieren';

  @override
  String get l_log_copied => 'Log in die Zwischenablage kopiert';

  @override
  String get l_diagnostics_copied =>
      'Diagnosedaten in die Zwischenablage kopiert';

  @override
  String p_target_copied_clipboard(String label) {
    return '$label in die Zwischenablage kopiert.';
  }

  @override
  String get s_custom_icons => 'Benutzerdefinierte Icons';

  @override
  String get l_set_icons_for_accounts =>
      'Individuelle Icons für Konten konfigurieren';

  @override
  String get p_custom_icons_description =>
      'Icon-Pakete machen Ihre Konten mit bekannten Logos und Farben leichter unterscheidbar.';

  @override
  String p_custom_icons_format_desc(String aegis_icon_pack) {
    return 'Icon-Pakete verwenden das $aegis_icon_pack Format. Du kannst entweder ein bestehendes Icon-Paket herunterladen oder ein eigenes erstellen.';
  }

  @override
  String get s_replace_icon_pack => 'Icon-Paket ersetzen';

  @override
  String get l_loading_icon_pack => 'Lade Icon-Paket…';

  @override
  String get s_load_icon_pack => 'Icon-Paket laden';

  @override
  String get s_remove_icon_pack => 'Icon-Paket entfernen';

  @override
  String get l_icon_pack_removed => 'Icon-Paket entfernt';

  @override
  String get l_remove_icon_pack_failed =>
      'Fehler beim Entfernen des Icon-Pakets';

  @override
  String get s_choose_icon_pack => 'Icon-Paket auswählen';

  @override
  String get l_icon_pack_imported => 'Icon-Paket importiert';

  @override
  String l_import_icon_pack_failed(String message) {
    return 'Fehler beim Importieren des Icon-Pakets: $message';
  }

  @override
  String get l_invalid_icon_pack => 'Ungültiges Icon-Paket';

  @override
  String get l_icon_pack_copy_failed =>
      'Kopieren der Dateien des Icon-Pakets fehlgeschlagen';

  @override
  String get s_nfc_options => 'NFC Optionen';

  @override
  String get l_on_yk_nfc_tap => 'Bei YubiKey NFC-Berührung';

  @override
  String get l_do_nothing => 'Nichts tun';

  @override
  String get l_launch_ya => 'Yubico Authenticator starten';

  @override
  String get l_copy_otp_clipboard => 'OTP in Zwischenablage kopieren';

  @override
  String get l_launch_and_copy_otp => 'App starten und OTP kopieren';

  @override
  String get l_kbd_layout_for_static =>
      'Tastaturlayout (für statisches Passwort)';

  @override
  String get s_choose_kbd_layout => 'Tastaturlayout auswählen';

  @override
  String get l_bypass_touch_requirement =>
      'Notwendigkeit zur Berührung umgehen';

  @override
  String get l_bypass_touch_requirement_on =>
      'Konten, die Berührung erfordern, werden automatisch über NFC angezeigt';

  @override
  String get l_bypass_touch_requirement_off =>
      'Konten, die Berührung erfordern, benötigen eine zusätzliche NFC-Berührung';

  @override
  String get s_silence_nfc_sounds => 'NFC-Töne stummschalten';

  @override
  String get l_silence_nfc_sounds_on =>
      'Keine Töne werden bei NFC-Berührung abgespielt';

  @override
  String get l_silence_nfc_sounds_off =>
      'Töne werden bei NFC-Berührung abgespielt';

  @override
  String get s_usb_options => 'USB Optionen';

  @override
  String get l_launch_app_on_usb => 'Starten, wenn YubiKey angesteckt wird';

  @override
  String get l_launch_app_on_usb_on =>
      'Das verhindert, dass andere Anwendungen den YubiKey über USB nutzen';

  @override
  String get l_launch_app_on_usb_off =>
      'Andere Anwendungen können den YubiKey über USB nutzen';

  @override
  String get s_allow_screenshots => 'Bildschirmfotos erlauben';

  @override
  String get s_nfc_ready_to_scan => 'Bereit zum Scannen';

  @override
  String get s_nfc_hold_still => 'Deinen YubiKey nicht bewegen…';

  @override
  String get s_nfc_tap_your_yubikey => 'Halte Deinen YubiKey an den Leser';

  @override
  String get l_nfc_failed_to_scan =>
      'Scanvorgang fehlgeschlagen, versuche es nochmal';

  @override
  String get s_usb_processing => 'Daten von YubiKey werden gelesen';

  @override
  String get s_usb_dont_remove => 'Bitte entferne nicht deinen YubiKey...';

  @override
  String get l_usb_read_error => 'Lesen der Daten von YubiKey fehlgeschlagen';

  @override
  String get p_ndef_set_otp =>
      'OTP Code wurde erfolgreich in die Zwischenablage kopiert.';

  @override
  String get p_ndef_set_password =>
      'Passwort wurde erfolgreich in die Zwischenablage kopiert.';

  @override
  String get p_ndef_parse_failure =>
      'Beim Auslesen des OTP Codes von deinem YubiKey ist ein Fehler aufgetreten.';

  @override
  String get p_ndef_set_clip_failure =>
      'Fehler beim Zugriff auf die Zwischenablage als der OTP Code kopiert wurde.';

  @override
  String get s_set_label => 'Namen konfigurieren';

  @override
  String get s_set_color => 'Farbe auswählen';

  @override
  String get s_change_label => 'Namen ändern';

  @override
  String get p_set_will_add_custom_name =>
      'Dies gibt deinem YubiKey einen eigenen Namen.';

  @override
  String get p_rename_will_change_custom_name =>
      'Dies ändert den Namen deines YubiKeys.';

  @override
  String get s_shortcuts => 'Verknüpfungen';

  @override
  String get s_keyboard_shortcuts => 'Tastaturkürzel';

  @override
  String get s_global_shortcuts => 'Globale Verknüpfungen';

  @override
  String get s_application_shortcuts => 'Anwendungs-Verknüpfungen';

  @override
  String s_quit_app(String app) {
    return '$app beenden';
  }

  @override
  String s_hide_app(String app) {
    return '$app ausblenden';
  }

  @override
  String get s_search => 'Suche';

  @override
  String get s_next_device => 'Nächstes Gerät';

  @override
  String get s_previous_device => 'Vorheriges Gerät';

  @override
  String get s_open_settings => 'Einstellungen öffnen';

  @override
  String get s_open_help_and_about => 'Hilfe und Informationen öffnen';

  @override
  String get s_open_item => 'Element öffnen';

  @override
  String get s_edit_item => 'Element bearbeiten';

  @override
  String get s_delete_item => 'Element löschen';

  @override
  String get s_calculate_oath_code => 'OATH Code generieren';

  @override
  String get s_open_keyboard_shortcuts => 'Tastenkürzel-Übersicht öffnen';
}
